
module ol_vamp_2_ppllllj2_eexmmxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eexmmxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eexmmxggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eexmmxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eexmmxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,60) :: G1
  complex(REALKIND), dimension(4,15,4,262) :: G2
  complex(REALKIND), dimension(4,35,4,342) :: G3
  complex(REALKIND), dimension(4,70,4,160) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,116,128))
    allocate(G4tensorhel(70,194,128))
    allocate(G5tensorhel(126,108,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,2),gZd)
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-6),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,124),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,76),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,3),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,124),ZERO,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_A_Q(l_switch,G3(:,:,:,5),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,4),wf(:,9),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-4),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,92),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-5),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-5),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,108),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,-4),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,124),ZERO,G4(:,:,:,4))
  call loop_AV_Q(G4(:,:,:,4),wf(:,1),G4(:,:,:,5))
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,9),G4(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,92),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-5),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,124),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,9),G3(:,:,:,13),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,44),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,12),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,124),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,1),G3(:,:,:,15))
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,14),wf(:,9),G3(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,60),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-6),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,124),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,1),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,9),G4(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-6),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,108),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-4),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,124),ZERO,G4(:,:,:,10))
  call loop_AV_Q(G4(:,:,:,10),wf(:,1),G4(:,:,:,11))
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,9),G4(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,108),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,124),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,9),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,28),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,17),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,124),ZERO,G3(:,:,:,24))
  call loop_AV_Q(G3(:,:,:,24),wf(:,1),G3(:,:,:,25))
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,24),wf(:,9),G3(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,60),ZERO,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-6),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,124),ZERO,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,1),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,9),G4(:,:,:,15),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-6),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,92),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,124),ZERO,G4(:,:,:,16))
  call loop_AV_Q(G4(:,:,:,16),wf(:,1),G4(:,:,:,17))
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,9),G4(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,3),gZd)
  call loop_A_Q(G0(:,:,:,3),Q(:,12),MB,G1(:,:,:,8))
  call loop_AV_Q(G1(:,:,:,8),wf(:,3),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,60),MB,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-6),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,124),MB,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,1),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MB,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,9),G3(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),MB,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-6),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,76),MB,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,3),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,124),MB,G3(:,:,:,34))
  call loop_AV_Q(G3(:,:,:,34),wf(:,1),G3(:,:,:,35))
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),MB,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,9),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),MB,G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,92),MB,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,124),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,1),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MB,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,9),G4(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,21),Q(:,127),MB,G5tensor(:,14))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-5),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,108),MB,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,124),MB,G4(:,:,:,22))
  call loop_AV_Q(G4(:,:,:,22),wf(:,1),G4(:,:,:,23))
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),MB,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,22),wf(:,9),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MB,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,8),wf(:,12),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,92),MB,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,124),MB,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,1),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MB,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,9),G3(:,:,:,43),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),MB,G4tensor(:,18))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,44),MB,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,12),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,124),MB,G3(:,:,:,44))
  call loop_AV_Q(G3(:,:,:,44),wf(:,1),G3(:,:,:,45))
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MB,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,44),wf(:,9),G3(:,:,:,46),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),MB,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,60),MB,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-6),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,124),MB,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MB,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),MB,G5tensor(:,18))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-6),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,108),MB,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,-4),G3(:,:,:,50))
  call loop_A_Q(G3(:,:,:,50),Q(:,124),MB,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),MB,G5tensor(:,19))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MB,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,8),wf(:,17),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,108),MB,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-4),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,124),MB,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,1),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),MB,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,9),G3(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),MB,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-4),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,28),MB,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,17),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,124),MB,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,1),G3(:,:,:,55))
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),MB,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,54),wf(:,9),G3(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),MB,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-5),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,60),MB,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-6),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,124),MB,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),MB,G5tensor(:,21))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,9),G4(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),MB,G5tensor(:,22))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-6),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,92),MB,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-5),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,124),MB,G4(:,:,:,34))
  call loop_AV_Q(G4(:,:,:,34),wf(:,1),G4(:,:,:,35))
  call check_last_A_Q(l_switch,G4(:,:,:,35),Q(:,127),MB,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,34),wf(:,9),G4(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),MB,G5tensor(:,24))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,4),gZd)
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,3),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,60),ZERO,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-6),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,124),ZERO,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,1),G3(:,:,:,62))
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,61),wf(:,9),G3(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QV_A(G1(:,:,:,15),wf(:,-6),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,76),ZERO,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,3),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,124),ZERO,G3(:,:,:,64))
  call loop_QV_A(G3(:,:,:,64),wf(:,1),G3(:,:,:,65))
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,127),ZERO,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,64),wf(:,9),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,92),ZERO,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,124),ZERO,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,1),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),ZERO,G5tensor(:,25))
  call loop_QZ_A(G4(:,:,:,37),wf(:,9),G4(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,39),Q(:,127),ZERO,G5tensor(:,26))
  call loop_QV_A(G2(:,:,:,39),wf(:,-5),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,108),ZERO,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,124),ZERO,G4(:,:,:,40))
  call loop_QV_A(G4(:,:,:,40),wf(:,1),G4(:,:,:,41))
  call check_last_Q_A(l_switch,G4(:,:,:,41),Q(:,127),ZERO,G5tensor(:,27))
  call loop_QZ_A(G4(:,:,:,40),wf(:,9),G4(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),ZERO,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,15),wf(:,12),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,92),ZERO,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,124),ZERO,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,1),G3(:,:,:,72))
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,71),wf(:,9),G3(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,15),wf(:,-5),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,44),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,12),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,124),ZERO,G3(:,:,:,74))
  call loop_QV_A(G3(:,:,:,74),wf(:,1),G3(:,:,:,75))
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,127),ZERO,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,74),wf(:,9),G3(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,45),wf(:,-4),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,60),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,124),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,1),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),ZERO,G5tensor(:,29))
  call loop_QZ_A(G4(:,:,:,43),wf(:,9),G4(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),ZERO,G5tensor(:,30))
  call loop_QV_A(G2(:,:,:,45),wf(:,-6),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,108),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,124),ZERO,G4(:,:,:,46))
  call loop_QV_A(G4(:,:,:,46),wf(:,1),G4(:,:,:,47))
  call check_last_Q_A(l_switch,G4(:,:,:,47),Q(:,127),ZERO,G5tensor(:,31))
  call loop_QZ_A(G4(:,:,:,46),wf(:,9),G4(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),ZERO,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,15),wf(:,17),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,108),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,124),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,1),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,33))
  call loop_QZ_A(G3(:,:,:,81),wf(:,9),G3(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),ZERO,G4tensor(:,34))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,28),ZERO,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,17),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,124),ZERO,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,1),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,127),ZERO,G4tensor(:,35))
  call loop_QZ_A(G3(:,:,:,84),wf(:,9),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),ZERO,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,60),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-6),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,124),ZERO,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,1),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,33))
  call loop_QZ_A(G4(:,:,:,49),wf(:,9),G4(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,51),Q(:,127),ZERO,G5tensor(:,34))
  call loop_QV_A(G2(:,:,:,51),wf(:,-6),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,92),ZERO,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,124),ZERO,G4(:,:,:,52))
  call loop_QV_A(G4(:,:,:,52),wf(:,1),G4(:,:,:,53))
  call check_last_Q_A(l_switch,G4(:,:,:,53),Q(:,127),ZERO,G5tensor(:,35))
  call loop_QZ_A(G4(:,:,:,52),wf(:,9),G4(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,5),gZd)
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,3),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,60),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-6),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,124),MB,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,1),G3(:,:,:,92))
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),MB,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,91),wf(:,9),G3(:,:,:,93),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),MB,G4tensor(:,38))
  call loop_QV_A(G1(:,:,:,22),wf(:,-6),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,76),MB,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,3),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,124),MB,G3(:,:,:,94))
  call loop_QV_A(G3(:,:,:,94),wf(:,1),G3(:,:,:,95))
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,127),MB,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,94),wf(:,9),G3(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,57),wf(:,-4),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,92),MB,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,-5),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,124),MB,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,1),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MB,G5tensor(:,37))
  call loop_QZ_A(G4(:,:,:,55),wf(:,9),G4(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,127),MB,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,57),wf(:,-5),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,108),MB,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,124),MB,G4(:,:,:,58))
  call loop_QV_A(G4(:,:,:,58),wf(:,1),G4(:,:,:,59))
  call check_last_Q_A(l_switch,G4(:,:,:,59),Q(:,127),MB,G5tensor(:,39))
  call loop_QZ_A(G4(:,:,:,58),wf(:,9),G4(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),MB,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,22),wf(:,12),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,92),MB,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,124),MB,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,1),G3(:,:,:,102))
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),MB,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,101),wf(:,9),G3(:,:,:,103),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,103),Q(:,127),MB,G4tensor(:,42))
  call loop_QV_A(G1(:,:,:,22),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,44),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,12),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,124),MB,G3(:,:,:,104))
  call loop_QV_A(G3(:,:,:,104),wf(:,1),G3(:,:,:,105))
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),MB,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,104),wf(:,9),G3(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),MB,G4tensor(:,44))
  call loop_QV_A(G2(:,:,:,63),wf(:,-4),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,60),MB,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,-6),G3(:,:,:,108))
  call loop_Q_A(G3(:,:,:,108),Q(:,124),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,1),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,61),wf(:,9),G4(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,63),Q(:,127),MB,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,63),wf(:,-6),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,108),MB,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-4),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,124),MB,G4(:,:,:,64))
  call loop_QV_A(G4(:,:,:,64),wf(:,1),G4(:,:,:,65))
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,127),MB,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,64),wf(:,9),G4(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,22),wf(:,17),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,108),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-4),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,124),MB,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,1),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,127),MB,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,111),wf(:,9),G3(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,113),Q(:,127),MB,G4tensor(:,46))
  call loop_QV_A(G1(:,:,:,22),wf(:,-4),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,28),MB,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,17),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,124),MB,G3(:,:,:,114))
  call loop_QV_A(G3(:,:,:,114),wf(:,1),G3(:,:,:,115))
  call check_last_Q_A(l_switch,G3(:,:,:,115),Q(:,127),MB,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,114),wf(:,9),G3(:,:,:,116),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,127),MB,G4tensor(:,48))
  call loop_QV_A(G2(:,:,:,69),wf(:,-5),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,60),MB,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-6),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,124),MB,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,1),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,45))
  call loop_QZ_A(G4(:,:,:,67),wf(:,9),G4(:,:,:,69),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,69),Q(:,127),MB,G5tensor(:,46))
  call loop_QV_A(G2(:,:,:,69),wf(:,-6),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,92),MB,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-5),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,124),MB,G4(:,:,:,70))
  call loop_QV_A(G4(:,:,:,70),wf(:,1),G4(:,:,:,71))
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,127),MB,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,70),wf(:,9),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,32),MT,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,12),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,112),MT,G2(:,:,:,73))
  call loop_AS_Q(G2(:,:,:,73),wf(:,64),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,73),wf(:,86),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,87),G2(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MT,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,73),wf(:,88),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,89),G2(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MT,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,73),wf(:,90),G2(:,:,:,79))
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,91),G2(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MT,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,73),wf(:,92),G2(:,:,:,81))
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,93),G2(:,:,:,82),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),MT,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,73),wf(:,94),G2(:,:,:,83))
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,127),MT,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,95),G2(:,:,:,84),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),MT,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,73),wf(:,96),G2(:,:,:,85))
  call check_last_A_Q(l_switch,G2(:,:,:,85),Q(:,127),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,97),G2(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,127),MT,G3tensor(:,13))
  call loop_AV_Q(G2(:,:,:,73),wf(:,98),G2(:,:,:,87))
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,127),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,73),wf(:,99),G2(:,:,:,88))
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,127),MT,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,100),G2(:,:,:,89),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,89),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,101),G2(:,:,:,90),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,127),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,29),wf(:,2),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,44),MT,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,12),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),MT,G3(:,:,:,121))
  call loop_AV_Q(G3(:,:,:,121),wf(:,1),G3(:,:,:,122))
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),MT,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,121),wf(:,9),G3(:,:,:,123),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,123),Q(:,127),MT,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-4),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,60),MT,G3(:,:,:,124))
  call loop_AV_Q(G3(:,:,:,124),wf(:,-6),G3(:,:,:,125))
  call loop_A_Q(G3(:,:,:,125),Q(:,124),MT,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,1),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,127),MT,G5tensor(:,49))
  call loop_AZ_Q(G4(:,:,:,73),wf(:,9),G4(:,:,:,75),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,75),Q(:,127),MT,G5tensor(:,50))
  call loop_AZ_Q(G1(:,:,:,29),wf(:,6),G1(:,:,:,32),gZu)
  call loop_A_Q(G1(:,:,:,32),Q(:,44),MT,G2(:,:,:,94))
  call loop_AV_Q(G2(:,:,:,94),wf(:,12),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,124),MT,G3(:,:,:,126))
  call loop_AV_Q(G3(:,:,:,126),wf(:,1),G3(:,:,:,127))
  call check_last_A_Q(l_switch,G3(:,:,:,127),Q(:,127),MT,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,126),wf(:,9),G3(:,:,:,128),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,127),MT,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,94),wf(:,-4),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,60),MT,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-6),G3(:,:,:,130))
  call loop_A_Q(G3(:,:,:,130),Q(:,124),MT,G4(:,:,:,76))
  call loop_AV_Q(G4(:,:,:,76),wf(:,1),G4(:,:,:,77))
  call check_last_A_Q(l_switch,G4(:,:,:,77),Q(:,127),MT,G5tensor(:,51))
  call loop_AZ_Q(G4(:,:,:,76),wf(:,9),G4(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,127),MT,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,48),MT,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-6),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,112),MT,G3(:,:,:,131))
  call loop_AS_Q(G3(:,:,:,131),wf(:,64),G3(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),MT,G4tensor(:,53))
  call loop_AV_Q(G3(:,:,:,131),wf(:,86),G3(:,:,:,133))
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),MT,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,87),G3(:,:,:,134),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,127),MT,G4tensor(:,55))
  call loop_AV_Q(G3(:,:,:,131),wf(:,88),G3(:,:,:,135))
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,127),MT,G4tensor(:,56))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,89),G3(:,:,:,136),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,127),MT,G4tensor(:,57))
  call loop_AV_Q(G3(:,:,:,131),wf(:,90),G3(:,:,:,137))
  call check_last_A_Q(l_switch,G3(:,:,:,137),Q(:,127),MT,G4tensor(:,58))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,91),G3(:,:,:,138),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,127),MT,G4tensor(:,59))
  call loop_AV_Q(G3(:,:,:,131),wf(:,92),G3(:,:,:,139))
  call check_last_A_Q(l_switch,G3(:,:,:,139),Q(:,127),MT,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,93),G3(:,:,:,140),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),MT,G4tensor(:,61))
  call loop_AV_Q(G3(:,:,:,131),wf(:,94),G3(:,:,:,141))
  call check_last_A_Q(l_switch,G3(:,:,:,141),Q(:,127),MT,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,95),G3(:,:,:,142),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,127),MT,G4tensor(:,63))
  call loop_AV_Q(G3(:,:,:,131),wf(:,96),G3(:,:,:,143))
  call check_last_A_Q(l_switch,G3(:,:,:,143),Q(:,127),MT,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,97),G3(:,:,:,144),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,144),Q(:,127),MT,G4tensor(:,65))
  call loop_AV_Q(G3(:,:,:,131),wf(:,98),G3(:,:,:,145))
  call check_last_A_Q(l_switch,G3(:,:,:,145),Q(:,127),MT,G4tensor(:,66))
  call loop_AV_Q(G3(:,:,:,131),wf(:,99),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,127),MT,G4tensor(:,67))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,100),G3(:,:,:,147),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,147),Q(:,127),MT,G4tensor(:,68))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,101),G3(:,:,:,148),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,127),MT,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,97),wf(:,2),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,60),MT,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-6),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,124),MT,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,1),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,127),MT,G5tensor(:,53))
  call loop_AZ_Q(G4(:,:,:,79),wf(:,9),G4(:,:,:,81),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,81),Q(:,127),MT,G5tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,97),wf(:,6),G2(:,:,:,100),gZu)
  call loop_A_Q(G2(:,:,:,100),Q(:,60),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-6),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,124),MT,G4(:,:,:,82))
  call loop_AV_Q(G4(:,:,:,82),wf(:,1),G4(:,:,:,83))
  call check_last_A_Q(l_switch,G4(:,:,:,83),Q(:,127),MT,G5tensor(:,55))
  call loop_AZ_Q(G4(:,:,:,82),wf(:,9),G4(:,:,:,84),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,127),MT,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,32),MT,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,12),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,112),MT,G2(:,:,:,101))
  call loop_QS_A(G2(:,:,:,101),wf(:,64),G2(:,:,:,102),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,127),MT,G3tensor(:,18))
  call loop_QV_A(G2(:,:,:,101),wf(:,86),G2(:,:,:,103))
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,127),MT,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,101),wf(:,87),G2(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,127),MT,G3tensor(:,20))
  call loop_QV_A(G2(:,:,:,101),wf(:,88),G2(:,:,:,105))
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,127),MT,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,101),wf(:,89),G2(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,127),MT,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,101),wf(:,90),G2(:,:,:,107))
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,127),MT,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,101),wf(:,91),G2(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,127),MT,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,101),wf(:,92),G2(:,:,:,109))
  call check_last_Q_A(l_switch,G2(:,:,:,109),Q(:,127),MT,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,101),wf(:,93),G2(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,127),MT,G3tensor(:,26))
  call loop_QV_A(G2(:,:,:,101),wf(:,94),G2(:,:,:,111))
  call check_last_Q_A(l_switch,G2(:,:,:,111),Q(:,127),MT,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,101),wf(:,95),G2(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,127),MT,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,101),wf(:,96),G2(:,:,:,113))
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,127),MT,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,101),wf(:,97),G2(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,127),MT,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,101),wf(:,98),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,127),MT,G3tensor(:,31))
  call loop_QV_A(G2(:,:,:,101),wf(:,99),G2(:,:,:,116))
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,127),MT,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,101),wf(:,100),G2(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,127),MT,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,101),wf(:,101),G2(:,:,:,118),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,127),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,2),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,44),MT,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,12),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,124),MT,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,1),G3(:,:,:,154))
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),MT,G4tensor(:,70))
  call loop_QZ_A(G3(:,:,:,153),wf(:,9),G3(:,:,:,155),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,127),MT,G4tensor(:,71))
  call loop_QV_A(G2(:,:,:,119),wf(:,-4),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,60),MT,G3(:,:,:,156))
  call loop_QV_A(G3(:,:,:,156),wf(:,-6),G3(:,:,:,157))
  call loop_Q_A(G3(:,:,:,157),Q(:,124),MT,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,1),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),MT,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,85),wf(:,9),G4(:,:,:,87),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,87),Q(:,127),MT,G5tensor(:,58))
  call loop_QZ_A(G1(:,:,:,34),wf(:,6),G1(:,:,:,37),gZu)
  call loop_Q_A(G1(:,:,:,37),Q(:,44),MT,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,12),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,124),MT,G3(:,:,:,158))
  call loop_QV_A(G3(:,:,:,158),wf(:,1),G3(:,:,:,159))
  call check_last_Q_A(l_switch,G3(:,:,:,159),Q(:,127),MT,G4tensor(:,72))
  call loop_QZ_A(G3(:,:,:,158),wf(:,9),G3(:,:,:,160),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,127),MT,G4tensor(:,73))
  call loop_QV_A(G2(:,:,:,122),wf(:,-4),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,60),MT,G3(:,:,:,161))
  call loop_QV_A(G3(:,:,:,161),wf(:,-6),G3(:,:,:,162))
  call loop_Q_A(G3(:,:,:,162),Q(:,124),MT,G4(:,:,:,88))
  call loop_QV_A(G4(:,:,:,88),wf(:,1),G4(:,:,:,89))
  call check_last_Q_A(l_switch,G4(:,:,:,89),Q(:,127),MT,G5tensor(:,59))
  call loop_QZ_A(G4(:,:,:,88),wf(:,9),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),MT,G5tensor(:,60))
  call loop_QV_A(G1(:,:,:,34),wf(:,-4),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,48),MT,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-6),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,112),MT,G3(:,:,:,163))
  call loop_QS_A(G3(:,:,:,163),wf(:,64),G3(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,127),MT,G4tensor(:,74))
  call loop_QV_A(G3(:,:,:,163),wf(:,86),G3(:,:,:,165))
  call check_last_Q_A(l_switch,G3(:,:,:,165),Q(:,127),MT,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,163),wf(:,87),G3(:,:,:,166),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,127),MT,G4tensor(:,76))
  call loop_QV_A(G3(:,:,:,163),wf(:,88),G3(:,:,:,167))
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,127),MT,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,163),wf(:,89),G3(:,:,:,168),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,127),MT,G4tensor(:,78))
  call loop_QV_A(G3(:,:,:,163),wf(:,90),G3(:,:,:,169))
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),MT,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,163),wf(:,91),G3(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),MT,G4tensor(:,80))
  call loop_QV_A(G3(:,:,:,163),wf(:,92),G3(:,:,:,171))
  call check_last_Q_A(l_switch,G3(:,:,:,171),Q(:,127),MT,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,163),wf(:,93),G3(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),MT,G4tensor(:,82))
  call loop_QV_A(G3(:,:,:,163),wf(:,94),G3(:,:,:,173))
  call check_last_Q_A(l_switch,G3(:,:,:,173),Q(:,127),MT,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,163),wf(:,95),G3(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,127),MT,G4tensor(:,84))
  call loop_QV_A(G3(:,:,:,163),wf(:,96),G3(:,:,:,175))
  call check_last_Q_A(l_switch,G3(:,:,:,175),Q(:,127),MT,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,163),wf(:,97),G3(:,:,:,176),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),MT,G4tensor(:,86))
  call loop_QV_A(G3(:,:,:,163),wf(:,98),G3(:,:,:,177))
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,127),MT,G4tensor(:,87))
  call loop_QV_A(G3(:,:,:,163),wf(:,99),G3(:,:,:,178))
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),MT,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,163),wf(:,100),G3(:,:,:,179),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,179),Q(:,127),MT,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,163),wf(:,101),G3(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),MT,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,125),wf(:,2),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,60),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-6),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,124),MT,G4(:,:,:,91))
  call loop_QV_A(G4(:,:,:,91),wf(:,1),G4(:,:,:,92))
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),MT,G5tensor(:,61))
  call loop_QZ_A(G4(:,:,:,91),wf(:,9),G4(:,:,:,93),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,93),Q(:,127),MT,G5tensor(:,62))
  call loop_QZ_A(G2(:,:,:,125),wf(:,6),G2(:,:,:,128),gZu)
  call loop_Q_A(G2(:,:,:,128),Q(:,60),MT,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-6),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,124),MT,G4(:,:,:,94))
  call loop_QV_A(G4(:,:,:,94),wf(:,1),G4(:,:,:,95))
  call check_last_Q_A(l_switch,G4(:,:,:,95),Q(:,127),MT,G5tensor(:,63))
  call loop_QZ_A(G4(:,:,:,94),wf(:,9),G4(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),MT,G5tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,32),MB,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,12),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,112),MB,G2(:,:,:,129))
  call loop_AS_Q(G2(:,:,:,129),wf(:,64),G2(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,127),MB,G3tensor(:,35))
  call loop_AV_Q(G2(:,:,:,129),wf(:,86),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,127),MB,G3tensor(:,36))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,87),G2(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,127),MB,G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,129),wf(:,88),G2(:,:,:,133))
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,127),MB,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,89),G2(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,127),MB,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,129),wf(:,90),G2(:,:,:,135))
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,127),MB,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,91),G2(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,127),MB,G3tensor(:,41))
  call loop_AV_Q(G2(:,:,:,129),wf(:,92),G2(:,:,:,137))
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,127),MB,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,93),G2(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,127),MB,G3tensor(:,43))
  call loop_AV_Q(G2(:,:,:,129),wf(:,94),G2(:,:,:,139))
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,127),MB,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,95),G2(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,127),MB,G3tensor(:,45))
  call loop_AV_Q(G2(:,:,:,129),wf(:,96),G2(:,:,:,141))
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,127),MB,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,97),G2(:,:,:,142),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,127),MB,G3tensor(:,47))
  call loop_AV_Q(G2(:,:,:,129),wf(:,98),G2(:,:,:,143))
  call check_last_A_Q(l_switch,G2(:,:,:,143),Q(:,127),MB,G3tensor(:,48))
  call loop_AV_Q(G2(:,:,:,129),wf(:,99),G2(:,:,:,144))
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,127),MB,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,100),G2(:,:,:,145),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,145),Q(:,127),MB,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,101),G2(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,127),MB,G3tensor(:,51))
  call loop_AV_Q(G1(:,:,:,39),wf(:,2),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,44),MB,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,12),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,124),MB,G3(:,:,:,185))
  call loop_AV_Q(G3(:,:,:,185),wf(:,1),G3(:,:,:,186))
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,127),MB,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,185),wf(:,9),G3(:,:,:,187),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,187),Q(:,127),MB,G4tensor(:,92))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-4),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,60),MB,G3(:,:,:,188))
  call loop_AV_Q(G3(:,:,:,188),wf(:,-6),G3(:,:,:,189))
  call loop_A_Q(G3(:,:,:,189),Q(:,124),MB,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,1),G4(:,:,:,98))
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MB,G5tensor(:,65))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,9),G4(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,99),Q(:,127),MB,G5tensor(:,66))
  call loop_AZ_Q(G1(:,:,:,39),wf(:,6),G1(:,:,:,42),gZd)
  call loop_A_Q(G1(:,:,:,42),Q(:,44),MB,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,12),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,124),MB,G3(:,:,:,190))
  call loop_AV_Q(G3(:,:,:,190),wf(:,1),G3(:,:,:,191))
  call check_last_A_Q(l_switch,G3(:,:,:,191),Q(:,127),MB,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,190),wf(:,9),G3(:,:,:,192),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,127),MB,G4tensor(:,94))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-4),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,60),MB,G3(:,:,:,193))
  call loop_AV_Q(G3(:,:,:,193),wf(:,-6),G3(:,:,:,194))
  call loop_A_Q(G3(:,:,:,194),Q(:,124),MB,G4(:,:,:,100))
  call loop_AV_Q(G4(:,:,:,100),wf(:,1),G4(:,:,:,101))
  call check_last_A_Q(l_switch,G4(:,:,:,101),Q(:,127),MB,G5tensor(:,67))
  call loop_AZ_Q(G4(:,:,:,100),wf(:,9),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MB,G5tensor(:,68))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-4),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,48),MB,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-6),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,112),MB,G3(:,:,:,195))
  call loop_AS_Q(G3(:,:,:,195),wf(:,64),G3(:,:,:,196),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,127),MB,G4tensor(:,95))
  call loop_AV_Q(G3(:,:,:,195),wf(:,86),G3(:,:,:,197))
  call check_last_A_Q(l_switch,G3(:,:,:,197),Q(:,127),MB,G4tensor(:,96))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,87),G3(:,:,:,198),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),MB,G4tensor(:,97))
  call loop_AV_Q(G3(:,:,:,195),wf(:,88),G3(:,:,:,199))
  call check_last_A_Q(l_switch,G3(:,:,:,199),Q(:,127),MB,G4tensor(:,98))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,89),G3(:,:,:,200),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,127),MB,G4tensor(:,99))
  call loop_AV_Q(G3(:,:,:,195),wf(:,90),G3(:,:,:,201))
  call check_last_A_Q(l_switch,G3(:,:,:,201),Q(:,127),MB,G4tensor(:,100))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,91),G3(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,127),MB,G4tensor(:,101))
  call loop_AV_Q(G3(:,:,:,195),wf(:,92),G3(:,:,:,203))
  call check_last_A_Q(l_switch,G3(:,:,:,203),Q(:,127),MB,G4tensor(:,102))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,93),G3(:,:,:,204),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,127),MB,G4tensor(:,103))
  call loop_AV_Q(G3(:,:,:,195),wf(:,94),G3(:,:,:,205))
  call check_last_A_Q(l_switch,G3(:,:,:,205),Q(:,127),MB,G4tensor(:,104))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,95),G3(:,:,:,206),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,127),MB,G4tensor(:,105))
  call loop_AV_Q(G3(:,:,:,195),wf(:,96),G3(:,:,:,207))
  call check_last_A_Q(l_switch,G3(:,:,:,207),Q(:,127),MB,G4tensor(:,106))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,97),G3(:,:,:,208),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,127),MB,G4tensor(:,107))
  call loop_AV_Q(G3(:,:,:,195),wf(:,98),G3(:,:,:,209))
  call check_last_A_Q(l_switch,G3(:,:,:,209),Q(:,127),MB,G4tensor(:,108))
  call loop_AV_Q(G3(:,:,:,195),wf(:,99),G3(:,:,:,210))
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,127),MB,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,100),G3(:,:,:,211),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,211),Q(:,127),MB,G4tensor(:,110))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,101),G3(:,:,:,212),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,127),MB,G4tensor(:,111))
  call loop_AV_Q(G2(:,:,:,153),wf(:,2),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,60),MB,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-6),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,124),MB,G4(:,:,:,103))
  call loop_AV_Q(G4(:,:,:,103),wf(:,1),G4(:,:,:,104))
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),MB,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,9),G4(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,105),Q(:,127),MB,G5tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,153),wf(:,6),G2(:,:,:,156),gZd)
  call loop_A_Q(G2(:,:,:,156),Q(:,60),MB,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-6),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,124),MB,G4(:,:,:,106))
  call loop_AV_Q(G4(:,:,:,106),wf(:,1),G4(:,:,:,107))
  call check_last_A_Q(l_switch,G4(:,:,:,107),Q(:,127),MB,G5tensor(:,71))
  call loop_AZ_Q(G4(:,:,:,106),wf(:,9),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),MB,G5tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,32),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,12),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,112),MB,G2(:,:,:,157))
  call loop_QS_A(G2(:,:,:,157),wf(:,64),G2(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,127),MB,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,157),wf(:,86),G2(:,:,:,159))
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,127),MB,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,157),wf(:,87),G2(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,127),MB,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,157),wf(:,88),G2(:,:,:,161))
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,127),MB,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,157),wf(:,89),G2(:,:,:,162),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,162),Q(:,127),MB,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,157),wf(:,90),G2(:,:,:,163))
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,127),MB,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,157),wf(:,91),G2(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,127),MB,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,157),wf(:,92),G2(:,:,:,165))
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,127),MB,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,157),wf(:,93),G2(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,127),MB,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,157),wf(:,94),G2(:,:,:,167))
  call check_last_Q_A(l_switch,G2(:,:,:,167),Q(:,127),MB,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,157),wf(:,95),G2(:,:,:,168),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,127),MB,G3tensor(:,62))
  call loop_QV_A(G2(:,:,:,157),wf(:,96),G2(:,:,:,169))
  call check_last_Q_A(l_switch,G2(:,:,:,169),Q(:,127),MB,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,157),wf(:,97),G2(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,127),MB,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,157),wf(:,98),G2(:,:,:,171))
  call check_last_Q_A(l_switch,G2(:,:,:,171),Q(:,127),MB,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,157),wf(:,99),G2(:,:,:,172))
  call check_last_Q_A(l_switch,G2(:,:,:,172),Q(:,127),MB,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,157),wf(:,100),G2(:,:,:,173),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,173),Q(:,127),MB,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,157),wf(:,101),G2(:,:,:,174),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,127),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,44),wf(:,2),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,44),MB,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,12),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,124),MB,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,1),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),MB,G4tensor(:,112))
  call loop_QZ_A(G3(:,:,:,217),wf(:,9),G3(:,:,:,219),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,127),MB,G4tensor(:,113))
  call loop_QV_A(G2(:,:,:,175),wf(:,-4),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,60),MB,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,-6),G3(:,:,:,221))
  call loop_Q_A(G3(:,:,:,221),Q(:,124),MB,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,1),G4(:,:,:,110))
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MB,G5tensor(:,73))
  call loop_QZ_A(G4(:,:,:,109),wf(:,9),G4(:,:,:,111),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,111),Q(:,127),MB,G5tensor(:,74))
  call loop_QZ_A(G1(:,:,:,44),wf(:,6),G1(:,:,:,47),gZd)
  call loop_Q_A(G1(:,:,:,47),Q(:,44),MB,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,12),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,124),MB,G3(:,:,:,222))
  call loop_QV_A(G3(:,:,:,222),wf(:,1),G3(:,:,:,223))
  call check_last_Q_A(l_switch,G3(:,:,:,223),Q(:,127),MB,G4tensor(:,114))
  call loop_QZ_A(G3(:,:,:,222),wf(:,9),G3(:,:,:,224),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),MB,G4tensor(:,115))
  call loop_QV_A(G2(:,:,:,178),wf(:,-4),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,60),MB,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,-6),G3(:,:,:,226))
  call loop_Q_A(G3(:,:,:,226),Q(:,124),MB,G4(:,:,:,112))
  call loop_QV_A(G4(:,:,:,112),wf(:,1),G4(:,:,:,113))
  call check_last_Q_A(l_switch,G4(:,:,:,113),Q(:,127),MB,G5tensor(:,75))
  call loop_QZ_A(G4(:,:,:,112),wf(:,9),G4(:,:,:,114),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,127),MB,G5tensor(:,76))
  call loop_QV_A(G1(:,:,:,44),wf(:,-4),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,48),MB,G2(:,:,:,181))
  call loop_QV_A(G2(:,:,:,181),wf(:,-6),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,112),MB,G3(:,:,:,227))
  call loop_QS_A(G3(:,:,:,227),wf(:,64),G3(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,127),MB,G4tensor(:,116))
  call loop_QV_A(G3(:,:,:,227),wf(:,86),G3(:,:,:,229))
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,127),MB,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,227),wf(:,87),G3(:,:,:,230),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,127),MB,G4tensor(:,118))
  call loop_QV_A(G3(:,:,:,227),wf(:,88),G3(:,:,:,231))
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,127),MB,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,227),wf(:,89),G3(:,:,:,232),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,127),MB,G4tensor(:,120))
  call loop_QV_A(G3(:,:,:,227),wf(:,90),G3(:,:,:,233))
  call check_last_Q_A(l_switch,G3(:,:,:,233),Q(:,127),MB,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,227),wf(:,91),G3(:,:,:,234),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,234),Q(:,127),MB,G4tensor(:,122))
  call loop_QV_A(G3(:,:,:,227),wf(:,92),G3(:,:,:,235))
  call check_last_Q_A(l_switch,G3(:,:,:,235),Q(:,127),MB,G4tensor(:,123))
  call loop_QZ_A(G3(:,:,:,227),wf(:,93),G3(:,:,:,236),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,127),MB,G4tensor(:,124))
  call loop_QV_A(G3(:,:,:,227),wf(:,94),G3(:,:,:,237))
  call check_last_Q_A(l_switch,G3(:,:,:,237),Q(:,127),MB,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,227),wf(:,95),G3(:,:,:,238),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,127),MB,G4tensor(:,126))
  call loop_QV_A(G3(:,:,:,227),wf(:,96),G3(:,:,:,239))
  call check_last_Q_A(l_switch,G3(:,:,:,239),Q(:,127),MB,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,227),wf(:,97),G3(:,:,:,240),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,240),Q(:,127),MB,G4tensor(:,128))
  call loop_QV_A(G3(:,:,:,227),wf(:,98),G3(:,:,:,241))
  call check_last_Q_A(l_switch,G3(:,:,:,241),Q(:,127),MB,G4tensor(:,129))
  call loop_QV_A(G3(:,:,:,227),wf(:,99),G3(:,:,:,242))
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,127),MB,G4tensor(:,130))
  call loop_QZ_A(G3(:,:,:,227),wf(:,100),G3(:,:,:,243),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,243),Q(:,127),MB,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,227),wf(:,101),G3(:,:,:,244),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,127),MB,G4tensor(:,132))
  call loop_QV_A(G2(:,:,:,181),wf(:,2),G2(:,:,:,183))
  call loop_Q_A(G2(:,:,:,183),Q(:,60),MB,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-6),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,124),MB,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,1),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),MB,G5tensor(:,77))
  call loop_QZ_A(G4(:,:,:,115),wf(:,9),G4(:,:,:,117),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,117),Q(:,127),MB,G5tensor(:,78))
  call loop_QZ_A(G2(:,:,:,181),wf(:,6),G2(:,:,:,184),gZd)
  call loop_Q_A(G2(:,:,:,184),Q(:,60),MB,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-6),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,124),MB,G4(:,:,:,118))
  call loop_QV_A(G4(:,:,:,118),wf(:,1),G4(:,:,:,119))
  call check_last_Q_A(l_switch,G4(:,:,:,119),Q(:,127),MB,G5tensor(:,79))
  call loop_QZ_A(G4(:,:,:,118),wf(:,9),G4(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,127),MB,G5tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,32),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,2),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,44),ZERO,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,12),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,124),ZERO,G3(:,:,:,249))
  call loop_QV_A(G3(:,:,:,249),wf(:,1),G3(:,:,:,250))
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,127),ZERO,G4tensor(:,133))
  call loop_QZ_A(G3(:,:,:,249),wf(:,9),G3(:,:,:,251),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,251),Q(:,127),ZERO,G4tensor(:,134))
  call loop_QZ_A(G3(:,:,:,249),wf(:,9),G3(:,:,:,252),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,127),ZERO,G4tensor(:,135))
  call loop_QV_A(G2(:,:,:,185),wf(:,-4),G2(:,:,:,187))
  call loop_Q_A(G2(:,:,:,187),Q(:,60),ZERO,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,-6),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,124),ZERO,G4(:,:,:,121))
  call loop_QV_A(G4(:,:,:,121),wf(:,1),G4(:,:,:,122))
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,81))
  call loop_QZ_A(G4(:,:,:,121),wf(:,9),G4(:,:,:,123),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,123),Q(:,127),ZERO,G5tensor(:,82))
  call loop_QZ_A(G4(:,:,:,121),wf(:,9),G4(:,:,:,124),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,83))
  call loop_QZ_A(G1(:,:,:,49),wf(:,6),G1(:,:,:,51),gZu)
  call loop_Q_A(G1(:,:,:,51),Q(:,44),ZERO,G2(:,:,:,188))
  call loop_QV_A(G2(:,:,:,188),wf(:,12),G2(:,:,:,189))
  call loop_Q_A(G2(:,:,:,189),Q(:,124),ZERO,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,1),G3(:,:,:,256))
  call check_last_Q_A(l_switch,G3(:,:,:,256),Q(:,127),ZERO,G4tensor(:,136))
  call loop_QZ_A(G3(:,:,:,255),wf(:,9),G3(:,:,:,257),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,257),Q(:,127),ZERO,G4tensor(:,137))
  call loop_QV_A(G2(:,:,:,188),wf(:,-4),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,60),ZERO,G3(:,:,:,258))
  call loop_QV_A(G3(:,:,:,258),wf(:,-6),G3(:,:,:,259))
  call loop_Q_A(G3(:,:,:,259),Q(:,124),ZERO,G4(:,:,:,125))
  call loop_QV_A(G4(:,:,:,125),wf(:,1),G4(:,:,:,126))
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,84))
  call loop_QZ_A(G4(:,:,:,125),wf(:,9),G4(:,:,:,127),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,127),Q(:,127),ZERO,G5tensor(:,85))
  call loop_QZ_A(G1(:,:,:,49),wf(:,6),G1(:,:,:,52),gZd)
  call loop_Q_A(G1(:,:,:,52),Q(:,44),ZERO,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,12),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,124),ZERO,G3(:,:,:,260))
  call loop_QV_A(G3(:,:,:,260),wf(:,1),G3(:,:,:,261))
  call check_last_Q_A(l_switch,G3(:,:,:,261),Q(:,127),ZERO,G4tensor(:,138))
  call loop_QZ_A(G3(:,:,:,260),wf(:,9),G3(:,:,:,262),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,139))
  call loop_QV_A(G2(:,:,:,191),wf(:,-4),G2(:,:,:,193))
  call loop_Q_A(G2(:,:,:,193),Q(:,60),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-6),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,124),ZERO,G4(:,:,:,128))
  call loop_QV_A(G4(:,:,:,128),wf(:,1),G4(:,:,:,129))
  call check_last_Q_A(l_switch,G4(:,:,:,129),Q(:,127),ZERO,G5tensor(:,86))
  call loop_QZ_A(G4(:,:,:,128),wf(:,9),G4(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,87))
  call loop_QV_A(G1(:,:,:,49),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,48),ZERO,G2(:,:,:,194))
  call loop_QV_A(G2(:,:,:,194),wf(:,2),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,60),ZERO,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-6),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,124),ZERO,G4(:,:,:,131))
  call loop_QV_A(G4(:,:,:,131),wf(:,1),G4(:,:,:,132))
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,88))
  call loop_QZ_A(G4(:,:,:,131),wf(:,9),G4(:,:,:,133),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,133),Q(:,127),ZERO,G5tensor(:,89))
  call loop_QZ_A(G4(:,:,:,131),wf(:,9),G4(:,:,:,134),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,90))
  call loop_QZ_A(G2(:,:,:,194),wf(:,6),G2(:,:,:,196),gZu)
  call loop_Q_A(G2(:,:,:,196),Q(:,60),ZERO,G3(:,:,:,267))
  call loop_QV_A(G3(:,:,:,267),wf(:,-6),G3(:,:,:,268))
  call loop_Q_A(G3(:,:,:,268),Q(:,124),ZERO,G4(:,:,:,135))
  call loop_QV_A(G4(:,:,:,135),wf(:,1),G4(:,:,:,136))
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,127),ZERO,G5tensor(:,91))
  call loop_QZ_A(G4(:,:,:,135),wf(:,9),G4(:,:,:,137),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,137),Q(:,127),ZERO,G5tensor(:,92))
  call loop_QZ_A(G2(:,:,:,194),wf(:,6),G2(:,:,:,197),gZd)
  call loop_Q_A(G2(:,:,:,197),Q(:,60),ZERO,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-6),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,124),ZERO,G4(:,:,:,138))
  call loop_QV_A(G4(:,:,:,138),wf(:,1),G4(:,:,:,139))
  call check_last_Q_A(l_switch,G4(:,:,:,139),Q(:,127),ZERO,G5tensor(:,93))
  call loop_QZ_A(G4(:,:,:,138),wf(:,9),G4(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,127),ZERO,G5tensor(:,94))
  call loop_QV_A(G2(:,:,:,194),wf(:,-6),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,112),ZERO,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,86),G3(:,:,:,272))
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,127),ZERO,G4tensor(:,140))
  call loop_QZ_A(G3(:,:,:,271),wf(:,87),G3(:,:,:,273),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,273),Q(:,127),ZERO,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,271),wf(:,87),G3(:,:,:,274),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,127),ZERO,G4tensor(:,142))
  call loop_QV_A(G3(:,:,:,271),wf(:,88),G3(:,:,:,275))
  call check_last_Q_A(l_switch,G3(:,:,:,275),Q(:,127),ZERO,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,271),wf(:,89),G3(:,:,:,276),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,127),ZERO,G4tensor(:,144))
  call loop_QZ_A(G3(:,:,:,271),wf(:,89),G3(:,:,:,277),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,277),Q(:,127),ZERO,G4tensor(:,145))
  call loop_QV_A(G3(:,:,:,271),wf(:,90),G3(:,:,:,278))
  call check_last_Q_A(l_switch,G3(:,:,:,278),Q(:,127),ZERO,G4tensor(:,146))
  call loop_QZ_A(G3(:,:,:,271),wf(:,91),G3(:,:,:,279),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,279),Q(:,127),ZERO,G4tensor(:,147))
  call loop_QZ_A(G3(:,:,:,271),wf(:,91),G3(:,:,:,280),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,280),Q(:,127),ZERO,G4tensor(:,148))
  call loop_QV_A(G3(:,:,:,271),wf(:,92),G3(:,:,:,281))
  call check_last_Q_A(l_switch,G3(:,:,:,281),Q(:,127),ZERO,G4tensor(:,149))
  call loop_QZ_A(G3(:,:,:,271),wf(:,93),G3(:,:,:,282),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,282),Q(:,127),ZERO,G4tensor(:,150))
  call loop_QZ_A(G3(:,:,:,271),wf(:,93),G3(:,:,:,283),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,283),Q(:,127),ZERO,G4tensor(:,151))
  call loop_QV_A(G3(:,:,:,271),wf(:,94),G3(:,:,:,284))
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,127),ZERO,G4tensor(:,152))
  call loop_QZ_A(G3(:,:,:,271),wf(:,95),G3(:,:,:,285),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,285),Q(:,127),ZERO,G4tensor(:,153))
  call loop_QZ_A(G3(:,:,:,271),wf(:,95),G3(:,:,:,286),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,286),Q(:,127),ZERO,G4tensor(:,154))
  call loop_QV_A(G3(:,:,:,271),wf(:,96),G3(:,:,:,287))
  call check_last_Q_A(l_switch,G3(:,:,:,287),Q(:,127),ZERO,G4tensor(:,155))
  call loop_QZ_A(G3(:,:,:,271),wf(:,97),G3(:,:,:,288),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,288),Q(:,127),ZERO,G4tensor(:,156))
  call loop_QZ_A(G3(:,:,:,271),wf(:,97),G3(:,:,:,289),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,289),Q(:,127),ZERO,G4tensor(:,157))
  call loop_QV_A(G3(:,:,:,271),wf(:,98),G3(:,:,:,290))
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,127),ZERO,G4tensor(:,158))
  call loop_QV_A(G3(:,:,:,271),wf(:,99),G3(:,:,:,291))
  call check_last_Q_A(l_switch,G3(:,:,:,291),Q(:,127),ZERO,G4tensor(:,159))
  call loop_QZ_A(G3(:,:,:,271),wf(:,100),G3(:,:,:,292),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,292),Q(:,127),ZERO,G4tensor(:,160))
  call loop_QZ_A(G3(:,:,:,271),wf(:,100),G3(:,:,:,293),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,293),Q(:,127),ZERO,G4tensor(:,161))
  call loop_QZ_A(G3(:,:,:,271),wf(:,101),G3(:,:,:,294),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,294),Q(:,127),ZERO,G4tensor(:,162))
  call loop_QZ_A(G3(:,:,:,271),wf(:,101),G3(:,:,:,295),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,295),Q(:,127),ZERO,G4tensor(:,163))
  call loop_QV_A(G1(:,:,:,49),wf(:,12),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,112),ZERO,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,86),G2(:,:,:,200))
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,127),ZERO,G3tensor(:,69))
  call loop_QZ_A(G2(:,:,:,199),wf(:,87),G2(:,:,:,201),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,201),Q(:,127),ZERO,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,199),wf(:,87),G2(:,:,:,202),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,202),Q(:,127),ZERO,G3tensor(:,71))
  call loop_QV_A(G2(:,:,:,199),wf(:,88),G2(:,:,:,203))
  call check_last_Q_A(l_switch,G2(:,:,:,203),Q(:,127),ZERO,G3tensor(:,72))
  call loop_QZ_A(G2(:,:,:,199),wf(:,89),G2(:,:,:,204),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,127),ZERO,G3tensor(:,73))
  call loop_QZ_A(G2(:,:,:,199),wf(:,89),G2(:,:,:,205),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,205),Q(:,127),ZERO,G3tensor(:,74))
  call loop_QV_A(G2(:,:,:,199),wf(:,90),G2(:,:,:,206))
  call check_last_Q_A(l_switch,G2(:,:,:,206),Q(:,127),ZERO,G3tensor(:,75))
  call loop_QZ_A(G2(:,:,:,199),wf(:,91),G2(:,:,:,207),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,207),Q(:,127),ZERO,G3tensor(:,76))
  call loop_QZ_A(G2(:,:,:,199),wf(:,91),G2(:,:,:,208),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,127),ZERO,G3tensor(:,77))
  call loop_QV_A(G2(:,:,:,199),wf(:,92),G2(:,:,:,209))
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,127),ZERO,G3tensor(:,78))
  call loop_QZ_A(G2(:,:,:,199),wf(:,93),G2(:,:,:,210),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,210),Q(:,127),ZERO,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,199),wf(:,93),G2(:,:,:,211),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,211),Q(:,127),ZERO,G3tensor(:,80))
  call loop_QV_A(G2(:,:,:,199),wf(:,94),G2(:,:,:,212))
  call check_last_Q_A(l_switch,G2(:,:,:,212),Q(:,127),ZERO,G3tensor(:,81))
  call loop_QZ_A(G2(:,:,:,199),wf(:,95),G2(:,:,:,213),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,213),Q(:,127),ZERO,G3tensor(:,82))
  call loop_QZ_A(G2(:,:,:,199),wf(:,95),G2(:,:,:,214),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,214),Q(:,127),ZERO,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,199),wf(:,96),G2(:,:,:,215))
  call check_last_Q_A(l_switch,G2(:,:,:,215),Q(:,127),ZERO,G3tensor(:,84))
  call loop_QZ_A(G2(:,:,:,199),wf(:,97),G2(:,:,:,216),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,127),ZERO,G3tensor(:,85))
  call loop_QZ_A(G2(:,:,:,199),wf(:,97),G2(:,:,:,217),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,217),Q(:,127),ZERO,G3tensor(:,86))
  call loop_QV_A(G2(:,:,:,199),wf(:,98),G2(:,:,:,218))
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,127),ZERO,G3tensor(:,87))
  call loop_QV_A(G2(:,:,:,199),wf(:,99),G2(:,:,:,219))
  call check_last_Q_A(l_switch,G2(:,:,:,219),Q(:,127),ZERO,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,199),wf(:,100),G2(:,:,:,220),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,127),ZERO,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,199),wf(:,100),G2(:,:,:,221),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,221),Q(:,127),ZERO,G3tensor(:,90))
  call loop_QZ_A(G2(:,:,:,199),wf(:,101),G2(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,127),ZERO,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,199),wf(:,101),G2(:,:,:,223),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,223),Q(:,127),ZERO,G3tensor(:,92))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,32),ZERO,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,2),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,44),ZERO,G2(:,:,:,224))
  call loop_AV_Q(G2(:,:,:,224),wf(:,12),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,124),ZERO,G3(:,:,:,296))
  call loop_AV_Q(G3(:,:,:,296),wf(:,1),G3(:,:,:,297))
  call check_last_A_Q(l_switch,G3(:,:,:,297),Q(:,127),ZERO,G4tensor(:,164))
  call loop_AZ_Q(G3(:,:,:,296),wf(:,9),G3(:,:,:,298),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,165))
  call loop_AZ_Q(G3(:,:,:,296),wf(:,9),G3(:,:,:,299),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,299),Q(:,127),ZERO,G4tensor(:,166))
  call loop_AV_Q(G2(:,:,:,224),wf(:,-4),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,60),ZERO,G3(:,:,:,300))
  call loop_AV_Q(G3(:,:,:,300),wf(:,-6),G3(:,:,:,301))
  call loop_A_Q(G3(:,:,:,301),Q(:,124),ZERO,G4(:,:,:,141))
  call loop_AV_Q(G4(:,:,:,141),wf(:,1),G4(:,:,:,142))
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,127),ZERO,G5tensor(:,95))
  call loop_AZ_Q(G4(:,:,:,141),wf(:,9),G4(:,:,:,143),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,143),Q(:,127),ZERO,G5tensor(:,96))
  call loop_AZ_Q(G4(:,:,:,141),wf(:,9),G4(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),ZERO,G5tensor(:,97))
  call loop_AZ_Q(G1(:,:,:,55),wf(:,6),G1(:,:,:,57),gZu)
  call loop_A_Q(G1(:,:,:,57),Q(:,44),ZERO,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,12),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,124),ZERO,G3(:,:,:,302))
  call loop_AV_Q(G3(:,:,:,302),wf(:,1),G3(:,:,:,303))
  call check_last_A_Q(l_switch,G3(:,:,:,303),Q(:,127),ZERO,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,302),wf(:,9),G3(:,:,:,304),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,127),ZERO,G4tensor(:,168))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-4),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,60),ZERO,G3(:,:,:,305))
  call loop_AV_Q(G3(:,:,:,305),wf(:,-6),G3(:,:,:,306))
  call loop_A_Q(G3(:,:,:,306),Q(:,124),ZERO,G4(:,:,:,145))
  call loop_AV_Q(G4(:,:,:,145),wf(:,1),G4(:,:,:,146))
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),ZERO,G5tensor(:,98))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,9),G4(:,:,:,147),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,147),Q(:,127),ZERO,G5tensor(:,99))
  call loop_AZ_Q(G1(:,:,:,55),wf(:,6),G1(:,:,:,58),gZd)
  call loop_A_Q(G1(:,:,:,58),Q(:,44),ZERO,G2(:,:,:,230))
  call loop_AV_Q(G2(:,:,:,230),wf(:,12),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,124),ZERO,G3(:,:,:,307))
  call loop_AV_Q(G3(:,:,:,307),wf(:,1),G3(:,:,:,308))
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),ZERO,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,307),wf(:,9),G3(:,:,:,309),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,309),Q(:,127),ZERO,G4tensor(:,170))
  call loop_AV_Q(G2(:,:,:,230),wf(:,-4),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,60),ZERO,G3(:,:,:,310))
  call loop_AV_Q(G3(:,:,:,310),wf(:,-6),G3(:,:,:,311))
  call loop_A_Q(G3(:,:,:,311),Q(:,124),ZERO,G4(:,:,:,148))
  call loop_AV_Q(G4(:,:,:,148),wf(:,1),G4(:,:,:,149))
  call check_last_A_Q(l_switch,G4(:,:,:,149),Q(:,127),ZERO,G5tensor(:,100))
  call loop_AZ_Q(G4(:,:,:,148),wf(:,9),G4(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,127),ZERO,G5tensor(:,101))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,48),ZERO,G2(:,:,:,233))
  call loop_AV_Q(G2(:,:,:,233),wf(:,2),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,60),ZERO,G3(:,:,:,312))
  call loop_AV_Q(G3(:,:,:,312),wf(:,-6),G3(:,:,:,313))
  call loop_A_Q(G3(:,:,:,313),Q(:,124),ZERO,G4(:,:,:,151))
  call loop_AV_Q(G4(:,:,:,151),wf(:,1),G4(:,:,:,152))
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),ZERO,G5tensor(:,102))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,9),G4(:,:,:,153),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,153),Q(:,127),ZERO,G5tensor(:,103))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,9),G4(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,127),ZERO,G5tensor(:,104))
  call loop_AZ_Q(G2(:,:,:,233),wf(:,6),G2(:,:,:,235),gZu)
  call loop_A_Q(G2(:,:,:,235),Q(:,60),ZERO,G3(:,:,:,314))
  call loop_AV_Q(G3(:,:,:,314),wf(:,-6),G3(:,:,:,315))
  call loop_A_Q(G3(:,:,:,315),Q(:,124),ZERO,G4(:,:,:,155))
  call loop_AV_Q(G4(:,:,:,155),wf(:,1),G4(:,:,:,156))
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,127),ZERO,G5tensor(:,105))
  call loop_AZ_Q(G4(:,:,:,155),wf(:,9),G4(:,:,:,157),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,157),Q(:,127),ZERO,G5tensor(:,106))
  call loop_AZ_Q(G2(:,:,:,233),wf(:,6),G2(:,:,:,236),gZd)
  call loop_A_Q(G2(:,:,:,236),Q(:,60),ZERO,G3(:,:,:,316))
  call loop_AV_Q(G3(:,:,:,316),wf(:,-6),G3(:,:,:,317))
  call loop_A_Q(G3(:,:,:,317),Q(:,124),ZERO,G4(:,:,:,158))
  call loop_AV_Q(G4(:,:,:,158),wf(:,1),G4(:,:,:,159))
  call check_last_A_Q(l_switch,G4(:,:,:,159),Q(:,127),ZERO,G5tensor(:,107))
  call loop_AZ_Q(G4(:,:,:,158),wf(:,9),G4(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,160),Q(:,127),ZERO,G5tensor(:,108))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-6),G2(:,:,:,237))
  call loop_A_Q(G2(:,:,:,237),Q(:,112),ZERO,G3(:,:,:,318))
  call loop_AV_Q(G3(:,:,:,318),wf(:,86),G3(:,:,:,319))
  call check_last_A_Q(l_switch,G3(:,:,:,319),Q(:,127),ZERO,G4tensor(:,171))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,87),G3(:,:,:,320),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,320),Q(:,127),ZERO,G4tensor(:,172))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,87),G3(:,:,:,321),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,321),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AV_Q(G3(:,:,:,318),wf(:,88),G3(:,:,:,322))
  call check_last_A_Q(l_switch,G3(:,:,:,322),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,89),G3(:,:,:,323),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,323),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,89),G3(:,:,:,324),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AV_Q(G3(:,:,:,318),wf(:,90),G3(:,:,:,325))
  call check_last_A_Q(l_switch,G3(:,:,:,325),Q(:,127),ZERO,G4tensor(:,177))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,91),G3(:,:,:,326),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,326),Q(:,127),ZERO,G4tensor(:,178))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,91),G3(:,:,:,327),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,327),Q(:,127),ZERO,G4tensor(:,179))
  call loop_AV_Q(G3(:,:,:,318),wf(:,92),G3(:,:,:,328))
  call check_last_A_Q(l_switch,G3(:,:,:,328),Q(:,127),ZERO,G4tensor(:,180))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,93),G3(:,:,:,329),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,329),Q(:,127),ZERO,G4tensor(:,181))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,93),G3(:,:,:,330),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,127),ZERO,G4tensor(:,182))
  call loop_AV_Q(G3(:,:,:,318),wf(:,94),G3(:,:,:,331))
  call check_last_A_Q(l_switch,G3(:,:,:,331),Q(:,127),ZERO,G4tensor(:,183))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,95),G3(:,:,:,332),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,332),Q(:,127),ZERO,G4tensor(:,184))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,95),G3(:,:,:,333),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,333),Q(:,127),ZERO,G4tensor(:,185))
  call loop_AV_Q(G3(:,:,:,318),wf(:,96),G3(:,:,:,334))
  call check_last_A_Q(l_switch,G3(:,:,:,334),Q(:,127),ZERO,G4tensor(:,186))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,97),G3(:,:,:,335),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,335),Q(:,127),ZERO,G4tensor(:,187))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,97),G3(:,:,:,336),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,336),Q(:,127),ZERO,G4tensor(:,188))
  call loop_AV_Q(G3(:,:,:,318),wf(:,98),G3(:,:,:,337))
  call check_last_A_Q(l_switch,G3(:,:,:,337),Q(:,127),ZERO,G4tensor(:,189))
  call loop_AV_Q(G3(:,:,:,318),wf(:,99),G3(:,:,:,338))
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,127),ZERO,G4tensor(:,190))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,100),G3(:,:,:,339),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,339),Q(:,127),ZERO,G4tensor(:,191))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,100),G3(:,:,:,340),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,340),Q(:,127),ZERO,G4tensor(:,192))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,101),G3(:,:,:,341),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,341),Q(:,127),ZERO,G4tensor(:,193))
  call loop_AZ_Q(G3(:,:,:,318),wf(:,101),G3(:,:,:,342),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,342),Q(:,127),ZERO,G4tensor(:,194))
  call loop_AV_Q(G1(:,:,:,55),wf(:,12),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,112),ZERO,G2(:,:,:,238))
  call loop_AV_Q(G2(:,:,:,238),wf(:,86),G2(:,:,:,239))
  call check_last_A_Q(l_switch,G2(:,:,:,239),Q(:,127),ZERO,G3tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,87),G2(:,:,:,240),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,240),Q(:,127),ZERO,G3tensor(:,94))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,87),G2(:,:,:,241),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,241),Q(:,127),ZERO,G3tensor(:,95))
  call loop_AV_Q(G2(:,:,:,238),wf(:,88),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,127),ZERO,G3tensor(:,96))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,89),G2(:,:,:,243),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,243),Q(:,127),ZERO,G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,89),G2(:,:,:,244),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,244),Q(:,127),ZERO,G3tensor(:,98))
  call loop_AV_Q(G2(:,:,:,238),wf(:,90),G2(:,:,:,245))
  call check_last_A_Q(l_switch,G2(:,:,:,245),Q(:,127),ZERO,G3tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,91),G2(:,:,:,246),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,246),Q(:,127),ZERO,G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,91),G2(:,:,:,247),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,247),Q(:,127),ZERO,G3tensor(:,101))
  call loop_AV_Q(G2(:,:,:,238),wf(:,92),G2(:,:,:,248))
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,127),ZERO,G3tensor(:,102))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,93),G2(:,:,:,249),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,249),Q(:,127),ZERO,G3tensor(:,103))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,93),G2(:,:,:,250),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,127),ZERO,G3tensor(:,104))
  call loop_AV_Q(G2(:,:,:,238),wf(:,94),G2(:,:,:,251))
  call check_last_A_Q(l_switch,G2(:,:,:,251),Q(:,127),ZERO,G3tensor(:,105))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,95),G2(:,:,:,252),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,127),ZERO,G3tensor(:,106))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,95),G2(:,:,:,253),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,253),Q(:,127),ZERO,G3tensor(:,107))
  call loop_AV_Q(G2(:,:,:,238),wf(:,96),G2(:,:,:,254))
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,127),ZERO,G3tensor(:,108))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,97),G2(:,:,:,255),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,255),Q(:,127),ZERO,G3tensor(:,109))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,97),G2(:,:,:,256),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,127),ZERO,G3tensor(:,110))
  call loop_AV_Q(G2(:,:,:,238),wf(:,98),G2(:,:,:,257))
  call check_last_A_Q(l_switch,G2(:,:,:,257),Q(:,127),ZERO,G3tensor(:,111))
  call loop_AV_Q(G2(:,:,:,238),wf(:,99),G2(:,:,:,258))
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,127),ZERO,G3tensor(:,112))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,100),G2(:,:,:,259),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,259),Q(:,127),ZERO,G3tensor(:,113))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,100),G2(:,:,:,260),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,127),ZERO,G3tensor(:,114))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,101),G2(:,:,:,261),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,261),Q(:,127),ZERO,G3tensor(:,115))
  call loop_AZ_Q(G2(:,:,:,238),wf(:,101),G2(:,:,:,262),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,127),ZERO,G3tensor(:,116))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,1),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,1),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,13),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,13),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,25),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,25),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,37),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,37),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,2),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,2),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,14),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,14),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,26),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,26),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,38),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,38),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,27),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,27),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,39),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,39),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,3),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,3),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,15),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,15),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,28),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,28),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,40),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,40),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,4),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,4),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,16),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,16),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(27) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(27)) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(27) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(27)) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(25) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(25)) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(25) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(25)) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,70),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,70),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,164),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,164),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,49),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,49),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,112),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,112),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,164),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,164),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,91),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,91),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,136),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,136),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,72),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,72),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,167),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,167),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,51),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,51),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,138),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,138),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,114),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,114),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,169),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,169),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,93),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,93),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,134),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,134),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,71),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,71),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,165),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,165),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,50),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,50),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,135),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,135),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,113),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,113),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,166),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,166),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,92),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,137),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,137),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,73),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,73),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,168),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,168),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,52),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,52),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,139),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,139),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,115),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,115),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,170),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,170),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,94),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,94),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,5),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,5),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,17),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,17),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,29),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,29),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,41),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,41),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,6),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,18),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,18),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,30),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,30),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,42),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,42),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,31),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,31),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,43),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,43),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,7),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,7),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(9)) * den(115)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,19),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(9) * den(115)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,19),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,32),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,32),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,44),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,44),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,8),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,8),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,20),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,20),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(11) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,9),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,9),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(9) * den(119)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,21),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(9)) * den(119)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,21),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(11) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,33),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,33),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(9) * den(119)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,45),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(9)) * den(119)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,45),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,10),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,10),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,22),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,22),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,34),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,34),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,46),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,46),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(11) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,35),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,35),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(9) * den(119)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,47),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(9)) * den(119)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,47),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(11) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,11),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,11),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(9) * den(119)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,23),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(9)) * den(119)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,23),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,36),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,36),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,48),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,48),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,12),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,12),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,24),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,24),T4sum(1:70,27))
  M(1) = M(1) + (f(28) * den(55)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,74),T4sum(1:70,28))
  M(2) = M(2) + (f(28) * den(55)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,53),T4sum(1:70,28))
  M(1) = M(1) + (f(26) * den(55)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,116),T4sum(1:70,29))
  M(2) = M(2) + (f(26) * den(55)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,95),T4sum(1:70,29))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,13),T5sum(1:126,3))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,25),T5sum(1:126,1))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,37),T5sum(1:126,3))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,2),T5sum(1:126,1))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,14),T5sum(1:126,3))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,26),T5sum(1:126,1))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,38),T5sum(1:126,3))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,29),T5sum(1:126,4))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,41),T5sum(1:126,6))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,5),T5sum(1:126,4))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,17),T5sum(1:126,6))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,30),T5sum(1:126,4))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,42),T5sum(1:126,6))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,6),T5sum(1:126,4))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,18),T5sum(1:126,6))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,27),T5sum(1:126,7))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,39),T5sum(1:126,9))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,3),T5sum(1:126,7))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,15),T5sum(1:126,9))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,28),T5sum(1:126,7))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,40),T5sum(1:126,9))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,4),T5sum(1:126,7))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,16),T5sum(1:126,9))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,9),T5sum(1:126,13))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,21),T5sum(1:126,15))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,33),T5sum(1:126,13))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,45),T5sum(1:126,15))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,10),T5sum(1:126,13))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,22),T5sum(1:126,15))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,34),T5sum(1:126,13))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,46),T5sum(1:126,15))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,88),T5sum(1:126,16))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,61),T5sum(1:126,17))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,102),T5sum(1:126,16))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,53),T5sum(1:126,17))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,88),T5sum(1:126,16))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,77),T5sum(1:126,18))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,102),T5sum(1:126,16))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,69),T5sum(1:126,18))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,91),T5sum(1:126,16))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,63),T5sum(1:126,17))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,105),T5sum(1:126,16))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,55),T5sum(1:126,17))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,93),T5sum(1:126,16))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,79),T5sum(1:126,18))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,107),T5sum(1:126,16))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,71),T5sum(1:126,18))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,89),T5sum(1:126,16))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,62),T5sum(1:126,17))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,103),T5sum(1:126,16))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,54),T5sum(1:126,17))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,90),T5sum(1:126,16))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,78),T5sum(1:126,18))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,104),T5sum(1:126,16))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,70),T5sum(1:126,18))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,92),T5sum(1:126,16))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,64),T5sum(1:126,17))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,106),T5sum(1:126,16))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,56),T5sum(1:126,17))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,94),T5sum(1:126,16))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,80),T5sum(1:126,18))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,108),T5sum(1:126,16))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,72),T5sum(1:126,18))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,31),T5sum(1:126,19))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,43),T5sum(1:126,21))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,7),T5sum(1:126,19))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,19),T5sum(1:126,21))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,32),T5sum(1:126,19))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,44),T5sum(1:126,21))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,8),T5sum(1:126,19))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,20),T5sum(1:126,21))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,11),T5sum(1:126,25))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,23),T5sum(1:126,27))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,35),T5sum(1:126,25))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,47),T5sum(1:126,27))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,12),T5sum(1:126,25))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,24),T5sum(1:126,27))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,36),T5sum(1:126,25))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,48),T5sum(1:126,27))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,95),T5sum(1:126,28))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,49),T5sum(1:126,29))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,81),T5sum(1:126,28))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,57),T5sum(1:126,29))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,95),T5sum(1:126,28))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,65),T5sum(1:126,30))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,81),T5sum(1:126,28))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,73),T5sum(1:126,30))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,98),T5sum(1:126,28))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,51),T5sum(1:126,29))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,84),T5sum(1:126,28))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,59),T5sum(1:126,29))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,100),T5sum(1:126,28))
  M(2) = M(2) + (-f(18) * den(7)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,67),T5sum(1:126,30))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,86),T5sum(1:126,28))
  M(1) = M(1) + (-f(18) * den(7)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,75),T5sum(1:126,30))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,96),T5sum(1:126,28))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,50),T5sum(1:126,29))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,82),T5sum(1:126,28))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,58),T5sum(1:126,29))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,97),T5sum(1:126,28))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,66),T5sum(1:126,30))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,83),T5sum(1:126,28))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,74),T5sum(1:126,30))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,99),T5sum(1:126,28))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,52),T5sum(1:126,29))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,85),T5sum(1:126,28))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,60),T5sum(1:126,29))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,101),T5sum(1:126,28))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,68),T5sum(1:126,30))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,87),T5sum(1:126,28))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,76),T5sum(1:126,30))
  M(1) = M(1) + (CI*f(14) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(130)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(130)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(130)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(130)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(130)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(130)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(130)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(130)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(130)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,94),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,94),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,95),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(131)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,95),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(131)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(132)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(132)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(132)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(132)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(132)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(132)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(132)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(132)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(132)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,73),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,73),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(133)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(133)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(133)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(133)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,74),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,74),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(133)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(133)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,98),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(133)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,98),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(133)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(133)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(134)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(134)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(134)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(134)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(134)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(134)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(134)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(134)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(134)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,76),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,76),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(135)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,77),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,77),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(135)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(135)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(136)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(136)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(136)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(136)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(136)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(136)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(136)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(136)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(136)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,79),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,79),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(137)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,80),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,80),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(137)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(137)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(1) = M(1) + (f(23) * den(93)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,140),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(93)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,75),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(93)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,171),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(93)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,54),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(93)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,140),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(93)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,117),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(93)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,171),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(93)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,96),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(95)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,141),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(95)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,76),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(95)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,172),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(95)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,55),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(95)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,142),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(95)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,118),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(95)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,173),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(95)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,97),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(96)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,143),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(96)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,77),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(96)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,174),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(96)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,56),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(96)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,143),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(96)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,119),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(96)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,174),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(96)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,98),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(97)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,144),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(97)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,78),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(97)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,175),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(97)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,57),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(97)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,145),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(97)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,120),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(97)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,176),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(97)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,99),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(98)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,146),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(98)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,79),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(98)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,177),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(98)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,58),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(98)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,146),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(98)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,121),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(98)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,177),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(98)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,100),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(99)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,147),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(99)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,80),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(99)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,178),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(99)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,59),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(99)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,148),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(99)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,122),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(99)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,179),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(99)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,101),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(100)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,149),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(100)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,81),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(100)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,180),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(100)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,60),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(100)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,149),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(100)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,123),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(100)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,180),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(100)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,102),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(101)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,150),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(101)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,82),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(101)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,181),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(101)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,61),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(101)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,151),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(101)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,124),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(101)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,182),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(101)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,103),T4sum(1:70,29))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(154)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(154)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(154)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(154)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(154)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(154)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(154)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(154)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(154)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,82),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,82),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,83),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,83),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(155)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(155)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(155)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(155)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(155)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(156)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(156)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(157)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(157)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(157)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(157)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,86),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,86),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(157)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(157)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(157)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(157)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(157)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(158)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(158)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(158)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(159)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(159)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(14) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(159)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(159)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(159)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(159)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(159)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(159)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(159)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,89),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,89),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(160)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(160)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(160)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(160)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,90),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,90),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(160)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(160)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(160)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(160)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(160)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,91),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,91),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(161)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(161)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(161)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(13) * den(161)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(15)) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,92),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,92),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(161)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(161)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(161)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(161)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(161)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (f(23) * den(102)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,152),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(102)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,83),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(102)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,183),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(102)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,62),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(102)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,152),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(102)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,125),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(102)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,183),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(102)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,104),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(103)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,153),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(103)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,84),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(103)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,184),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(103)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,63),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(103)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,154),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(103)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,126),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(103)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,185),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(103)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,105),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(104)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,155),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(104)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,85),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(104)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,186),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(104)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,64),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(104)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,155),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(104)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,127),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(104)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,186),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(104)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,106),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(105)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,156),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(105)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,86),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(105)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,187),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(105)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,65),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(105)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,157),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(105)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,128),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(105)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,188),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(105)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,107),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(106)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,158),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(106)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,87),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(106)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,189),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(106)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,66),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(106)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,158),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(106)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,129),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(106)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,189),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(106)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,108),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(107)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,159),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(107)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,88),T4sum(1:70,28))
  M(2) = M(2) + (f(23) * den(107)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,190),T4sum(1:70,34))
  M(2) = M(2) + (f(20) * den(107)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,67),T4sum(1:70,28))
  M(1) = M(1) + (-f(20) * den(107)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,159),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(107)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,130),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(107)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,190),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(107)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,109),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(108)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,160),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(108)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,89),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(108)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,191),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(108)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,68),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(108)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,161),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(108)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,131),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(108)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,192),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(108)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,110),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(109)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,162),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(109)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,90),T4sum(1:70,28))
  M(2) = M(2) + (-f(24) * den(109)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,193),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(109)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,69),T4sum(1:70,28))
  M(1) = M(1) + (-f(24) * den(109)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,163),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(109)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,132),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(109)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,194),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(109)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,111),T4sum(1:70,29))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_ppllllj2_eexmmxggg_1_/**/REALKIND
