
module ol_vamp_1_ppllllj2_nmnmxeexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nmnmxeexuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nmnmxeexuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nmnmxeexuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nmnmxeexuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,21) :: G0
  complex(REALKIND), dimension(4,5,4,68) :: G1
  complex(REALKIND), dimension(4,15,4,138) :: G2
  complex(REALKIND), dimension(4,35,4,90) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,48,128))
    allocate(G4tensorhel(70,48,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,9),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,45),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,46),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,47),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,48),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,1),wf(:,49),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,50),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,-6),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,124),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,7),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-6),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,124),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,4),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,9),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,8))
  call loop_AV_Q(G2(:,:,:,13),wf(:,45),G2(:,:,:,15))
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,46),G2(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,13),wf(:,47),G2(:,:,:,17))
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,48),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,49),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,50),G2(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-6),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,124),MT,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,7),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-6),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,124),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,25))
  call loop_QS_A(G2(:,:,:,25),wf(:,9),G2(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,127),MB,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,25),wf(:,45),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,127),MB,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,25),wf(:,46),G2(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,127),MB,G3tensor(:,17))
  call loop_QV_A(G2(:,:,:,25),wf(:,47),G2(:,:,:,29))
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,127),MB,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,25),wf(:,48),G2(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,127),MB,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,25),wf(:,49),G2(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,127),MB,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,25),wf(:,50),G2(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,60),MB,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-6),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,124),MB,G3(:,:,:,9))
  call loop_QZ_A(G3(:,:,:,9),wf(:,4),G3(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,127),MB,G4tensor(:,5))
  call loop_QZ_A(G1(:,:,:,9),wf(:,7),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-6),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,124),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,37))
  call loop_AS_Q(G2(:,:,:,37),wf(:,9),G2(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MB,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,37),wf(:,45),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),MB,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,46),G2(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),MB,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,37),wf(:,47),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,48),G2(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),MB,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,49),G2(:,:,:,43),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),MB,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,50),G2(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),MB,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MB,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-6),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,124),MB,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,7),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MB,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-6),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,124),MB,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,4),G3(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,60),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-6),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,124),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,19),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,7),G1(:,:,:,19),gZu)
  call loop_A_Q(G1(:,:,:,19),Q(:,60),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-6),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,124),ZERO,G3(:,:,:,20))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,4),G3(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,7),G1(:,:,:,20),gZd)
  call loop_A_Q(G1(:,:,:,20),Q(:,60),ZERO,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-6),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,124),ZERO,G3(:,:,:,22))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,4),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,112),ZERO,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,45),G2(:,:,:,56))
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,46),G2(:,:,:,57),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,127),ZERO,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,46),G2(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,55),wf(:,47),G2(:,:,:,59))
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,127),ZERO,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,48),G2(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,127),ZERO,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,48),G2(:,:,:,61),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,127),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,49),G2(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),ZERO,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,49),G2(:,:,:,63),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),ZERO,G3tensor(:,36))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,50),G2(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),ZERO,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,50),G2(:,:,:,65),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,2),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,60),ZERO,G2(:,:,:,66))
  call loop_QV_A(G2(:,:,:,66),wf(:,-6),G2(:,:,:,67))
  call loop_Q_A(G2(:,:,:,67),Q(:,124),ZERO,G3(:,:,:,24))
  call loop_QZ_A(G3(:,:,:,24),wf(:,4),G3(:,:,:,25),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,127),ZERO,G4tensor(:,13))
  call loop_QZ_A(G3(:,:,:,24),wf(:,4),G3(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,14))
  call loop_QZ_A(G1(:,:,:,22),wf(:,7),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,60),ZERO,G2(:,:,:,68))
  call loop_QV_A(G2(:,:,:,68),wf(:,-6),G2(:,:,:,69))
  call loop_Q_A(G2(:,:,:,69),Q(:,124),ZERO,G3(:,:,:,27))
  call loop_QZ_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,15))
  call loop_QZ_A(G1(:,:,:,22),wf(:,7),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,60),ZERO,G2(:,:,:,70))
  call loop_QV_A(G2(:,:,:,70),wf(:,-6),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,124),ZERO,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,4),G3(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,16))
  call loop_QV_A(G1(:,:,:,22),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),ZERO,G2(:,:,:,72))
  call loop_QV_A(G2(:,:,:,72),wf(:,45),G2(:,:,:,73))
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,72),wf(:,46),G2(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,72),wf(:,46),G2(:,:,:,75),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,72),wf(:,47),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,72),wf(:,48),G2(:,:,:,77),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,72),wf(:,48),G2(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,127),ZERO,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,72),wf(:,49),G2(:,:,:,79),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,127),ZERO,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,72),wf(:,49),G2(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,127),ZERO,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,72),wf(:,50),G2(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,127),ZERO,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,72),wf(:,50),G2(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,3),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,60),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-6),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,124),ZERO,G3(:,:,:,31))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,4),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,4),G3(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-6),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,76),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,3),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),ZERO,G3(:,:,:,34))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,4),G3(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,4),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,30))
  call loop_AV_Q(G1(:,:,:,30),wf(:,3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,60),MT,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,124),MT,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,4),G3(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MT,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-6),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,76),MT,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,3),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),MT,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MT,G4tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,3),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,60),ZERO,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-6),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,124),ZERO,G3(:,:,:,41))
  call loop_QZ_A(G3(:,:,:,41),wf(:,4),G3(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,127),ZERO,G4tensor(:,23))
  call loop_QZ_A(G3(:,:,:,41),wf(:,4),G3(:,:,:,43),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,33),wf(:,-6),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,76),ZERO,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,3),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,124),ZERO,G3(:,:,:,44))
  call loop_QZ_A(G3(:,:,:,44),wf(:,4),G3(:,:,:,45),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,44),wf(:,4),G3(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,3),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,60),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-6),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,124),MT,G3(:,:,:,47))
  call loop_QZ_A(G3(:,:,:,47),wf(:,4),G3(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,36),wf(:,-6),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,76),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,3),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,124),MT,G3(:,:,:,49))
  call loop_QZ_A(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,127),MT,G4tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MB,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,3),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,60),MB,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-6),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,124),MB,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,4),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),MB,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-6),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,76),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,124),MB,G3(:,:,:,53))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,4),G3(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),MB,G4tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,60),MB,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,-6),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,124),MB,G3(:,:,:,55))
  call loop_QZ_A(G3(:,:,:,55),wf(:,4),G3(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,127),MB,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,42),wf(:,-6),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,76),MB,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,3),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,124),MB,G3(:,:,:,57))
  call loop_QZ_A(G3(:,:,:,57),wf(:,4),G3(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,127),MB,G4tensor(:,32))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,60),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-6),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,124),ZERO,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-6),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,76),ZERO,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,3),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,124),ZERO,G3(:,:,:,61))
  call loop_AZ_Q(G3(:,:,:,61),wf(:,4),G3(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,48))
  call loop_AV_Q(G1(:,:,:,48),wf(:,3),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,60),MT,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-6),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,124),MT,G3(:,:,:,63))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,4),G3(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),MT,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,48),wf(:,-6),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,76),MT,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,124),MT,G3(:,:,:,65))
  call loop_AZ_Q(G3(:,:,:,65),wf(:,4),G3(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),MT,G4tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,60),ZERO,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,-6),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,124),ZERO,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,4),G3(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,37))
  call loop_QV_A(G1(:,:,:,51),wf(:,-6),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,76),ZERO,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,3),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,124),ZERO,G3(:,:,:,69))
  call loop_QZ_A(G3(:,:,:,69),wf(:,4),G3(:,:,:,70),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,38))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,60),MT,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-6),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,124),MT,G3(:,:,:,71))
  call loop_QZ_A(G3(:,:,:,71),wf(:,4),G3(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,54),wf(:,-6),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,76),MT,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,3),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,124),MT,G3(:,:,:,73))
  call loop_QZ_A(G3(:,:,:,73),wf(:,4),G3(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,40))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,60),ZERO,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-6),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,124),ZERO,G3(:,:,:,75))
  call loop_AZ_Q(G3(:,:,:,75),wf(:,4),G3(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-6),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,76),ZERO,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,3),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,124),ZERO,G3(:,:,:,77))
  call loop_AZ_Q(G3(:,:,:,77),wf(:,4),G3(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,60))
  call loop_AV_Q(G1(:,:,:,60),wf(:,3),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,60),MB,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-6),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,124),MB,G3(:,:,:,79))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,4),G3(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,127),MB,G4tensor(:,43))
  call loop_AV_Q(G1(:,:,:,60),wf(:,-6),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,76),MB,G2(:,:,:,129))
  call loop_AV_Q(G2(:,:,:,129),wf(:,3),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,124),MB,G3(:,:,:,81))
  call loop_AZ_Q(G3(:,:,:,81),wf(:,4),G3(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,127),MB,G4tensor(:,44))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,12),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,3),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,60),ZERO,G2(:,:,:,131))
  call loop_QV_A(G2(:,:,:,131),wf(:,-6),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,124),ZERO,G3(:,:,:,83))
  call loop_QZ_A(G3(:,:,:,83),wf(:,4),G3(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,63),wf(:,-6),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,76),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,3),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,124),ZERO,G3(:,:,:,85))
  call loop_QZ_A(G3(:,:,:,85),wf(:,4),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,12),MB,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,60),MB,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,-6),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,124),MB,G3(:,:,:,87))
  call loop_QZ_A(G3(:,:,:,87),wf(:,4),G3(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,127),MB,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,66),wf(:,-6),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,76),MB,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,3),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,124),MB,G3(:,:,:,89))
  call loop_QZ_A(G3(:,:,:,89),wf(:,4),G3(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),MB,G4tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,14),T4sum(1:70,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,5),T4sum(1:70,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,15),T4sum(1:70,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,12),T4sum(1:70,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,16),T4sum(1:70,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,21),T4sum(1:70,5))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,23),T4sum(1:70,4))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,27),T4sum(1:70,5))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,18),T4sum(1:70,4))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,29),T4sum(1:70,6))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,24),T4sum(1:70,4))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,31),T4sum(1:70,6))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,35),T4sum(1:70,5))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,37),T4sum(1:70,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,39),T4sum(1:70,5))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,43),T4sum(1:70,6))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,45),T4sum(1:70,4))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,25),T4sum(1:70,7))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,28),T4sum(1:70,8))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,19),T4sum(1:70,7))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(54)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,22),T4sum(1:70,8))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,26),T4sum(1:70,7))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,32),T4sum(1:70,9))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,20),T4sum(1:70,7))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(54)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,30),T4sum(1:70,9))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,38),T4sum(1:70,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,40),T4sum(1:70,8))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,36),T4sum(1:70,8))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,46),T4sum(1:70,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,48),T4sum(1:70,9))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,42),T4sum(1:70,7))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(55)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,44),T4sum(1:70,9))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(56)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(57)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(58)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(58)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(58)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(58)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(58)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(58)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(58)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(61)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nmnmxeexuuxg_1_/**/REALKIND
