
module ol_vamp_1_ppllllj2_nexnmemxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nexnmemxuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nexnmemxuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nexnmemxuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nexnmemxuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,28) :: G1
  complex(REALKIND), dimension(4,15,4,92) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,62,128))
    allocate(G4tensorhel(70,12,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,7),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,9),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,11),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,25),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,26),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,1),wf(:,27),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,28),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,29),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,30),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,-6),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,112),MT,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,7),G2(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,11),wf(:,9),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,11),G2(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,11),wf(:,25),G2(:,:,:,15))
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,26),G2(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,27),G2(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,11),wf(:,28),G2(:,:,:,18))
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,29),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,30),G2(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,18))
  call loop_AW_Q(G1(:,:,:,3),wf(:,5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,58),MB,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-6),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,122),MB,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,-6),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,112),MB,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,7),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,127),MB,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,23),wf(:,9),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,127),MB,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,23),wf(:,11),G2(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,127),MB,G3tensor(:,21))
  call loop_QV_A(G2(:,:,:,23),wf(:,25),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,127),MB,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,23),wf(:,26),G2(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,127),MB,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,23),wf(:,27),G2(:,:,:,29),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,127),MB,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,23),wf(:,28),G2(:,:,:,30))
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,127),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,23),wf(:,29),G2(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,127),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,23),wf(:,30),G2(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,27))
  call loop_QW_A(G1(:,:,:,6),wf(:,5),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,58),MT,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-6),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,122),MT,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,4),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MB,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,35))
  call loop_AS_Q(G2(:,:,:,35),wf(:,7),G2(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,35),wf(:,9),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,11),G2(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MB,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,35),wf(:,25),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),MB,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,26),G2(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,27),G2(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),MB,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,35),wf(:,28),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),MB,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,29),G2(:,:,:,43),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),MB,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,30),G2(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),MB,G3tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-6),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,112),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,9),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),ZERO,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,45),wf(:,11),G2(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),ZERO,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,45),wf(:,11),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),ZERO,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,45),wf(:,25),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),ZERO,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,45),wf(:,26),G2(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QZ_A(G2(:,:,:,45),wf(:,26),G2(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),ZERO,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,27),G2(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),ZERO,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,45),wf(:,27),G2(:,:,:,53),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),ZERO,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,45),wf(:,28),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),ZERO,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,45),wf(:,29),G2(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),ZERO,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,29),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,45),wf(:,30),G2(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),ZERO,G3tensor(:,48))
  call loop_QZ_A(G2(:,:,:,45),wf(:,30),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,49))
  call loop_QW_A(G1(:,:,:,11),wf(:,5),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,58),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,122),ZERO,G3(:,:,:,5))
  call loop_QW_A(G3(:,:,:,5),wf(:,4),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,14))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-6),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,112),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,9),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,11),G2(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,11),G2(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AV_Q(G2(:,:,:,61),wf(:,25),G2(:,:,:,65))
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,26),G2(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,26),G2(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,27),G2(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,27),G2(:,:,:,69),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AV_Q(G2(:,:,:,61),wf(:,28),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,29),G2(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,29),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,30),G2(:,:,:,73),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,30),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,62))
  call loop_AW_Q(G1(:,:,:,14),wf(:,5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,58),ZERO,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-6),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,122),ZERO,G3(:,:,:,7))
  call loop_AW_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),ZERO,G4tensor(:,4))
  call loop_QW_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,58),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-6),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,122),ZERO,G3(:,:,:,9))
  call loop_QW_A(G3(:,:,:,9),wf(:,4),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,17),wf(:,-6),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,74),ZERO,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,3),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,122),ZERO,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,6))
  call loop_QW_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,3),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,58),MT,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-6),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,122),MT,G3(:,:,:,13))
  call loop_QW_A(G3(:,:,:,13),wf(:,4),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,20),wf(:,-6),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,74),MT,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,3),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,122),MT,G3(:,:,:,15))
  call loop_QW_A(G3(:,:,:,15),wf(:,4),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AW_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,3),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,58),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,122),ZERO,G3(:,:,:,17))
  call loop_AW_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-6),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,74),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,3),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,122),ZERO,G3(:,:,:,19))
  call loop_AW_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AW_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,10),MB,G1(:,:,:,26))
  call loop_AV_Q(G1(:,:,:,26),wf(:,3),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,58),MB,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-6),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,122),MB,G3(:,:,:,21))
  call loop_AW_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-6),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,74),MB,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,3),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,122),MB,G3(:,:,:,23))
  call loop_AW_Q(G3(:,:,:,23),wf(:,4),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MT,G4tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,4),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,1),T4sum(1:70,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_2,masses2_8,G4tensor(:,5),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_2,masses2_7,G4tensor(:,7),T4sum(1:70,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_2,masses2_8,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,11),T4sum(1:70,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_3,masses2_8,G4tensor(:,6),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_3,masses2_7,G4tensor(:,8),T4sum(1:70,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_3,masses2_8,G4tensor(:,10),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(35)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,12),T4sum(1:70,9))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(36)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(36)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(36)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(36)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(40)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(41)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nexnmemxuuxg_1_/**/REALKIND
