
module ol_vamp_1_ppllllj2_nexnmemxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nexnmemxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nexnmemxggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nexnmemxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nexnmemxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,22) :: G0
  complex(REALKIND), dimension(4,5,4,89) :: G1
  complex(REALKIND), dimension(4,15,4,336) :: G2
  complex(REALKIND), dimension(4,35,4,334) :: G3
  complex(REALKIND), dimension(4,70,4,88) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,173,128))
    allocate(G4tensorhel(70,195,128))
    allocate(G5tensorhel(126,44,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,40),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,12),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,43),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,57),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,58),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,1),wf(:,59),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,60),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,61),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,62),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,-6),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,112),MT,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,40),G2(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,11),wf(:,12),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,43),G2(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,11),wf(:,57),G2(:,:,:,15))
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,58),G2(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,59),G2(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,11),wf(:,60),G2(:,:,:,18))
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,61),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,62),G2(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,18))
  call loop_AW_Q(G1(:,:,:,3),wf(:,5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,58),MB,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-6),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,122),MB,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,-6),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,112),MB,G2(:,:,:,23))
  call loop_QS_A(G2(:,:,:,23),wf(:,40),G2(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,127),MB,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,23),wf(:,12),G2(:,:,:,25))
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,127),MB,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,23),wf(:,43),G2(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,127),MB,G3tensor(:,21))
  call loop_QV_A(G2(:,:,:,23),wf(:,57),G2(:,:,:,27))
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,127),MB,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,23),wf(:,58),G2(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,127),MB,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,23),wf(:,59),G2(:,:,:,29),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,127),MB,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,23),wf(:,60),G2(:,:,:,30))
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,127),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,23),wf(:,61),G2(:,:,:,31),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,127),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,23),wf(:,62),G2(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,27))
  call loop_QW_A(G1(:,:,:,6),wf(:,5),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,58),MT,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-6),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,122),MT,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,4),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MB,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,35))
  call loop_AS_Q(G2(:,:,:,35),wf(:,40),G2(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,35),wf(:,12),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,43),G2(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MB,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,35),wf(:,57),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),MB,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,58),G2(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,59),G2(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),MB,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,35),wf(:,60),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),MB,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,61),G2(:,:,:,43),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),MB,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,35),wf(:,62),G2(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),MB,G3tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-6),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,112),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,12),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),ZERO,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,45),wf(:,43),G2(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),ZERO,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,45),wf(:,43),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),ZERO,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,45),wf(:,57),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),ZERO,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,45),wf(:,58),G2(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QZ_A(G2(:,:,:,45),wf(:,58),G2(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),ZERO,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,59),G2(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),ZERO,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,45),wf(:,59),G2(:,:,:,53),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),ZERO,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,45),wf(:,60),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),ZERO,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,45),wf(:,61),G2(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),ZERO,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,61),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,45),wf(:,62),G2(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),ZERO,G3tensor(:,48))
  call loop_QZ_A(G2(:,:,:,45),wf(:,62),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,49))
  call loop_QW_A(G1(:,:,:,11),wf(:,5),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,58),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,122),ZERO,G3(:,:,:,5))
  call loop_QW_A(G3(:,:,:,5),wf(:,4),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,14))
  call loop_AV_Q(G1(:,:,:,14),wf(:,-6),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,112),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,12),G2(:,:,:,62))
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,43),G2(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,43),G2(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AV_Q(G2(:,:,:,61),wf(:,57),G2(:,:,:,65))
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,58),G2(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,58),G2(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,59),G2(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,59),G2(:,:,:,69),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AV_Q(G2(:,:,:,61),wf(:,60),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,61),G2(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,61),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,62),G2(:,:,:,73),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,61),wf(:,62),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,62))
  call loop_AW_Q(G1(:,:,:,14),wf(:,5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,58),ZERO,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-6),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,122),ZERO,G3(:,:,:,7))
  call loop_AW_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),ZERO,G4tensor(:,4))
  call loop_QW_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,58),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-6),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,122),ZERO,G3(:,:,:,9))
  call loop_QW_A(G3(:,:,:,9),wf(:,4),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,17),wf(:,-6),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,74),ZERO,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,3),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,122),ZERO,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,79),wf(:,-4),G2(:,:,:,81))
  call loop_Q_A(G2(:,:,:,81),Q(:,90),ZERO,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,-5),G3(:,:,:,14))
  call loop_Q_A(G3(:,:,:,14),Q(:,122),ZERO,G4(:,:,:,1))
  call loop_QW_A(G4(:,:,:,1),wf(:,4),G4(:,:,:,2))
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_QV_A(G2(:,:,:,79),wf(:,-5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,106),ZERO,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,122),ZERO,G4(:,:,:,3))
  call loop_QW_A(G4(:,:,:,3),wf(:,4),G4(:,:,:,4))
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,2))
  call loop_QV_A(G1(:,:,:,17),wf(:,7),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,90),ZERO,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,122),ZERO,G3(:,:,:,17))
  call loop_QW_A(G3(:,:,:,17),wf(:,4),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,17),wf(:,-5),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,42),ZERO,G2(:,:,:,85))
  call loop_QV_A(G2(:,:,:,85),wf(:,7),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,122),ZERO,G3(:,:,:,19))
  call loop_QW_A(G3(:,:,:,19),wf(:,4),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,85),wf(:,-4),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,58),ZERO,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,-6),G3(:,:,:,22))
  call loop_Q_A(G3(:,:,:,22),Q(:,122),ZERO,G4(:,:,:,5))
  call loop_QW_A(G4(:,:,:,5),wf(:,4),G4(:,:,:,6))
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,85),wf(:,-6),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,106),ZERO,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_Q_A(G3(:,:,:,24),Q(:,122),ZERO,G4(:,:,:,7))
  call loop_QW_A(G4(:,:,:,7),wf(:,4),G4(:,:,:,8))
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,4))
  call loop_QV_A(G1(:,:,:,17),wf(:,9),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,106),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,122),ZERO,G3(:,:,:,25))
  call loop_QW_A(G3(:,:,:,25),wf(:,4),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,26),ZERO,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,9),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,122),ZERO,G3(:,:,:,27))
  call loop_QW_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,58),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-6),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,122),ZERO,G4(:,:,:,9))
  call loop_QW_A(G4(:,:,:,9),wf(:,4),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,5))
  call loop_QV_A(G2(:,:,:,91),wf(:,-6),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,90),ZERO,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-5),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,122),ZERO,G4(:,:,:,11))
  call loop_QW_A(G4(:,:,:,11),wf(:,4),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,6))
  call loop_QW_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,3),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,58),MT,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-6),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,122),MT,G3(:,:,:,33))
  call loop_QW_A(G3(:,:,:,33),wf(:,4),G3(:,:,:,34))
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,127),MB,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,24),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,74),MT,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,3),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,122),MT,G3(:,:,:,35))
  call loop_QW_A(G3(:,:,:,35),wf(:,4),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),MB,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,97),wf(:,-4),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,90),MT,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,122),MT,G4(:,:,:,13))
  call loop_QW_A(G4(:,:,:,13),wf(:,4),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,127),MB,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,106),MT,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,122),MT,G4(:,:,:,15))
  call loop_QW_A(G4(:,:,:,15),wf(:,4),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,127),MB,G5tensor(:,8))
  call loop_QV_A(G1(:,:,:,24),wf(:,7),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,90),MT,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,122),MT,G3(:,:,:,41))
  call loop_QW_A(G3(:,:,:,41),wf(:,4),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,127),MB,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,24),wf(:,-5),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,42),MT,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,7),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,122),MT,G3(:,:,:,43))
  call loop_QW_A(G3(:,:,:,43),wf(:,4),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),MB,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,103),wf(:,-4),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,58),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-6),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,122),MT,G4(:,:,:,17))
  call loop_QW_A(G4(:,:,:,17),wf(:,4),G4(:,:,:,18))
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,127),MB,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,103),wf(:,-6),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,106),MT,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,122),MT,G4(:,:,:,19))
  call loop_QW_A(G4(:,:,:,19),wf(:,4),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,127),MB,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,24),wf(:,9),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,106),MT,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,122),MT,G3(:,:,:,49))
  call loop_QW_A(G3(:,:,:,49),wf(:,4),G3(:,:,:,50))
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,127),MB,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,26),MT,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,9),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,122),MT,G3(:,:,:,51))
  call loop_QW_A(G3(:,:,:,51),wf(:,4),G3(:,:,:,52))
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,127),MB,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,109),wf(:,-5),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,58),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-6),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,122),MT,G4(:,:,:,21))
  call loop_QW_A(G4(:,:,:,21),wf(:,4),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,127),MB,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,109),wf(:,-6),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,90),MT,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-5),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,122),MT,G4(:,:,:,23))
  call loop_QW_A(G4(:,:,:,23),wf(:,4),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,127),MB,G5tensor(:,12))
  call loop_AW_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,58),ZERO,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-6),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,122),ZERO,G3(:,:,:,57))
  call loop_AW_Q(G3(:,:,:,57),wf(:,4),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-6),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,74),ZERO,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,3),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,122),ZERO,G3(:,:,:,59))
  call loop_AW_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-4),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,90),ZERO,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-5),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,122),ZERO,G4(:,:,:,25))
  call loop_AW_Q(G4(:,:,:,25),wf(:,4),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-5),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,106),ZERO,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,122),ZERO,G4(:,:,:,27))
  call loop_AW_Q(G4(:,:,:,27),wf(:,4),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,127),ZERO,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,31),wf(:,7),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,90),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,122),ZERO,G3(:,:,:,65))
  call loop_AW_Q(G3(:,:,:,65),wf(:,4),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,42),ZERO,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,7),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,122),ZERO,G3(:,:,:,67))
  call loop_AW_Q(G3(:,:,:,67),wf(:,4),G3(:,:,:,68))
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-4),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,58),ZERO,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-6),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,122),ZERO,G4(:,:,:,29))
  call loop_AW_Q(G4(:,:,:,29),wf(:,4),G4(:,:,:,30))
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-6),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,106),ZERO,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,122),ZERO,G4(:,:,:,31))
  call loop_AW_Q(G4(:,:,:,31),wf(:,4),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,31),wf(:,9),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,106),ZERO,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-4),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,122),ZERO,G3(:,:,:,73))
  call loop_AW_Q(G3(:,:,:,73),wf(:,4),G3(:,:,:,74))
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,26),ZERO,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,9),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,122),ZERO,G3(:,:,:,75))
  call loop_AW_Q(G3(:,:,:,75),wf(:,4),G3(:,:,:,76))
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,58),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,122),ZERO,G4(:,:,:,33))
  call loop_AW_Q(G4(:,:,:,33),wf(:,4),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-6),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,90),ZERO,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,122),ZERO,G4(:,:,:,35))
  call loop_AW_Q(G4(:,:,:,35),wf(:,4),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,18))
  call loop_AW_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,10),MB,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,3),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,58),MB,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-6),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,122),MB,G3(:,:,:,81))
  call loop_AW_Q(G3(:,:,:,81),wf(:,4),G3(:,:,:,82))
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,127),MT,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-6),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,74),MB,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,3),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,122),MB,G3(:,:,:,83))
  call loop_AW_Q(G3(:,:,:,83),wf(:,4),G3(:,:,:,84))
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,127),MT,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,90),MB,G3(:,:,:,85))
  call loop_AV_Q(G3(:,:,:,85),wf(:,-5),G3(:,:,:,86))
  call loop_A_Q(G3(:,:,:,86),Q(:,122),MB,G4(:,:,:,37))
  call loop_AW_Q(G4(:,:,:,37),wf(:,4),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,106),MB,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,122),MB,G4(:,:,:,39))
  call loop_AW_Q(G4(:,:,:,39),wf(:,4),G4(:,:,:,40))
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,127),MT,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,38),wf(:,7),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,90),MB,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-5),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,122),MB,G3(:,:,:,89))
  call loop_AW_Q(G3(:,:,:,89),wf(:,4),G3(:,:,:,90))
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),MT,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-5),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,42),MB,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,7),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,122),MB,G3(:,:,:,91))
  call loop_AW_Q(G3(:,:,:,91),wf(:,4),G3(:,:,:,92))
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-4),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,58),MB,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,-6),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,122),MB,G4(:,:,:,41))
  call loop_AW_Q(G4(:,:,:,41),wf(:,4),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-6),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,106),MB,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,122),MB,G4(:,:,:,43))
  call loop_AW_Q(G4(:,:,:,43),wf(:,4),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,127),MT,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,38),wf(:,9),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,106),MB,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-4),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,122),MB,G3(:,:,:,97))
  call loop_AW_Q(G3(:,:,:,97),wf(:,4),G3(:,:,:,98))
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,127),MT,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-4),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,26),MB,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,9),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,122),MB,G3(:,:,:,99))
  call loop_AW_Q(G3(:,:,:,99),wf(:,4),G3(:,:,:,100))
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,127),MT,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-5),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,58),MB,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-6),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,122),MB,G4(:,:,:,45))
  call loop_AW_Q(G4(:,:,:,45),wf(:,4),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,127),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-6),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,90),MB,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-5),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,122),MB,G4(:,:,:,47))
  call loop_AW_Q(G4(:,:,:,47),wf(:,4),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,127),MT,G5tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,32),MT,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,7),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,112),MT,G2(:,:,:,149))
  call loop_AS_Q(G2(:,:,:,149),wf(:,40),G2(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,127),MT,G3tensor(:,63))
  call loop_AV_Q(G2(:,:,:,149),wf(:,12),G2(:,:,:,151))
  call check_last_A_Q(l_switch,G2(:,:,:,151),Q(:,127),MT,G3tensor(:,64))
  call loop_AZ_Q(G2(:,:,:,149),wf(:,43),G2(:,:,:,152),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,127),MT,G3tensor(:,65))
  call loop_AV_Q(G2(:,:,:,149),wf(:,57),G2(:,:,:,153))
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,127),MT,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,149),wf(:,58),G2(:,:,:,154),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,127),MT,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,149),wf(:,59),G2(:,:,:,155),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,127),MT,G3tensor(:,68))
  call loop_AV_Q(G2(:,:,:,149),wf(:,60),G2(:,:,:,156))
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,127),MT,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,149),wf(:,61),G2(:,:,:,157),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,127),MT,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,149),wf(:,62),G2(:,:,:,158),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,127),MT,G3tensor(:,71))
  call loop_AW_Q(G1(:,:,:,45),wf(:,5),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,42),MB,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,7),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,122),MB,G3(:,:,:,105))
  call loop_AW_Q(G3(:,:,:,105),wf(:,4),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,127),MT,G4tensor(:,29))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-4),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,58),MB,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-6),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,122),MB,G4(:,:,:,49))
  call loop_AW_Q(G4(:,:,:,49),wf(:,4),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,127),MT,G5tensor(:,25))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-4),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,48),MT,G2(:,:,:,162))
  call loop_AV_Q(G2(:,:,:,162),wf(:,-6),G2(:,:,:,163))
  call loop_A_Q(G2(:,:,:,163),Q(:,112),MT,G3(:,:,:,109))
  call loop_AS_Q(G3(:,:,:,109),wf(:,40),G3(:,:,:,110),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),MT,G4tensor(:,30))
  call loop_AV_Q(G3(:,:,:,109),wf(:,12),G3(:,:,:,111))
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,127),MT,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,43),G3(:,:,:,112),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,127),MT,G4tensor(:,32))
  call loop_AV_Q(G3(:,:,:,109),wf(:,57),G3(:,:,:,113))
  call check_last_A_Q(l_switch,G3(:,:,:,113),Q(:,127),MT,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,58),G3(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),MT,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,59),G3(:,:,:,115),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,127),MT,G4tensor(:,35))
  call loop_AV_Q(G3(:,:,:,109),wf(:,60),G3(:,:,:,116))
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),MT,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,61),G3(:,:,:,117),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,117),Q(:,127),MT,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,62),G3(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,127),MT,G4tensor(:,38))
  call loop_AW_Q(G2(:,:,:,162),wf(:,5),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,58),MB,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,-6),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,122),MB,G4(:,:,:,51))
  call loop_AW_Q(G4(:,:,:,51),wf(:,4),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,127),MT,G5tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,32),MT,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,7),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,112),MT,G2(:,:,:,165))
  call loop_QS_A(G2(:,:,:,165),wf(:,40),G2(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,127),MT,G3tensor(:,72))
  call loop_QV_A(G2(:,:,:,165),wf(:,12),G2(:,:,:,167))
  call check_last_Q_A(l_switch,G2(:,:,:,167),Q(:,127),MT,G3tensor(:,73))
  call loop_QZ_A(G2(:,:,:,165),wf(:,43),G2(:,:,:,168),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,127),MT,G3tensor(:,74))
  call loop_QV_A(G2(:,:,:,165),wf(:,57),G2(:,:,:,169))
  call check_last_Q_A(l_switch,G2(:,:,:,169),Q(:,127),MT,G3tensor(:,75))
  call loop_QZ_A(G2(:,:,:,165),wf(:,58),G2(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,127),MT,G3tensor(:,76))
  call loop_QZ_A(G2(:,:,:,165),wf(:,59),G2(:,:,:,171),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,171),Q(:,127),MT,G3tensor(:,77))
  call loop_QV_A(G2(:,:,:,165),wf(:,60),G2(:,:,:,172))
  call check_last_Q_A(l_switch,G2(:,:,:,172),Q(:,127),MT,G3tensor(:,78))
  call loop_QZ_A(G2(:,:,:,165),wf(:,61),G2(:,:,:,173),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,173),Q(:,127),MT,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,165),wf(:,62),G2(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,127),MT,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,49),wf(:,-4),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,48),MT,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-6),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,112),MT,G3(:,:,:,121))
  call loop_QS_A(G3(:,:,:,121),wf(:,40),G3(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,127),MT,G4tensor(:,39))
  call loop_QV_A(G3(:,:,:,121),wf(:,12),G3(:,:,:,123))
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,127),MT,G4tensor(:,40))
  call loop_QZ_A(G3(:,:,:,121),wf(:,43),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MT,G4tensor(:,41))
  call loop_QV_A(G3(:,:,:,121),wf(:,57),G3(:,:,:,125))
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,127),MT,G4tensor(:,42))
  call loop_QZ_A(G3(:,:,:,121),wf(:,58),G3(:,:,:,126),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,127),MT,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,121),wf(:,59),G3(:,:,:,127),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,127),Q(:,127),MT,G4tensor(:,44))
  call loop_QV_A(G3(:,:,:,121),wf(:,60),G3(:,:,:,128))
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),MT,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,121),wf(:,61),G3(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,129),Q(:,127),MT,G4tensor(:,46))
  call loop_QZ_A(G3(:,:,:,121),wf(:,62),G3(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,127),MT,G4tensor(:,47))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,32),MB,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,7),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,112),MB,G2(:,:,:,177))
  call loop_AS_Q(G2(:,:,:,177),wf(:,40),G2(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,127),MB,G3tensor(:,81))
  call loop_AV_Q(G2(:,:,:,177),wf(:,12),G2(:,:,:,179))
  call check_last_A_Q(l_switch,G2(:,:,:,179),Q(:,127),MB,G3tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,43),G2(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,127),MB,G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,177),wf(:,57),G2(:,:,:,181))
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,127),MB,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,58),G2(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,127),MB,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,59),G2(:,:,:,183),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,127),MB,G3tensor(:,86))
  call loop_AV_Q(G2(:,:,:,177),wf(:,60),G2(:,:,:,184))
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,127),MB,G3tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,61),G2(:,:,:,185),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,127),MB,G3tensor(:,88))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,62),G2(:,:,:,186),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,127),MB,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-4),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,48),MB,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-6),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,112),MB,G3(:,:,:,131))
  call loop_AS_Q(G3(:,:,:,131),wf(:,40),G3(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),MB,G4tensor(:,48))
  call loop_AV_Q(G3(:,:,:,131),wf(:,12),G3(:,:,:,133))
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),MB,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,43),G3(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,127),MB,G4tensor(:,50))
  call loop_AV_Q(G3(:,:,:,131),wf(:,57),G3(:,:,:,135))
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,127),MB,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,58),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,127),MB,G4tensor(:,52))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,59),G3(:,:,:,137),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,137),Q(:,127),MB,G4tensor(:,53))
  call loop_AV_Q(G3(:,:,:,131),wf(:,60),G3(:,:,:,138))
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,127),MB,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,61),G3(:,:,:,139),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,139),Q(:,127),MB,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,62),G3(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),MB,G4tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,32),MB,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,7),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,112),MB,G2(:,:,:,189))
  call loop_QS_A(G2(:,:,:,189),wf(:,40),G2(:,:,:,190),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,190),Q(:,127),MB,G3tensor(:,90))
  call loop_QV_A(G2(:,:,:,189),wf(:,12),G2(:,:,:,191))
  call check_last_Q_A(l_switch,G2(:,:,:,191),Q(:,127),MB,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,189),wf(:,43),G2(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,127),MB,G3tensor(:,92))
  call loop_QV_A(G2(:,:,:,189),wf(:,57),G2(:,:,:,193))
  call check_last_Q_A(l_switch,G2(:,:,:,193),Q(:,127),MB,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,189),wf(:,58),G2(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,127),MB,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,189),wf(:,59),G2(:,:,:,195),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,195),Q(:,127),MB,G3tensor(:,95))
  call loop_QV_A(G2(:,:,:,189),wf(:,60),G2(:,:,:,196))
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,127),MB,G3tensor(:,96))
  call loop_QZ_A(G2(:,:,:,189),wf(:,61),G2(:,:,:,197),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,197),Q(:,127),MB,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,189),wf(:,62),G2(:,:,:,198),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,127),MB,G3tensor(:,98))
  call loop_QW_A(G1(:,:,:,55),wf(:,5),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,42),MT,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,7),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,122),MT,G3(:,:,:,141))
  call loop_QW_A(G3(:,:,:,141),wf(:,4),G3(:,:,:,142))
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),MB,G4tensor(:,57))
  call loop_QV_A(G2(:,:,:,199),wf(:,-4),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,58),MT,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-6),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,122),MT,G4(:,:,:,53))
  call loop_QW_A(G4(:,:,:,53),wf(:,4),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),MB,G5tensor(:,27))
  call loop_QV_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,48),MB,G2(:,:,:,202))
  call loop_QV_A(G2(:,:,:,202),wf(:,-6),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,112),MB,G3(:,:,:,145))
  call loop_QS_A(G3(:,:,:,145),wf(:,40),G3(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,127),MB,G4tensor(:,58))
  call loop_QV_A(G3(:,:,:,145),wf(:,12),G3(:,:,:,147))
  call check_last_Q_A(l_switch,G3(:,:,:,147),Q(:,127),MB,G4tensor(:,59))
  call loop_QZ_A(G3(:,:,:,145),wf(:,43),G3(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,127),MB,G4tensor(:,60))
  call loop_QV_A(G3(:,:,:,145),wf(:,57),G3(:,:,:,149))
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),MB,G4tensor(:,61))
  call loop_QZ_A(G3(:,:,:,145),wf(:,58),G3(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,127),MB,G4tensor(:,62))
  call loop_QZ_A(G3(:,:,:,145),wf(:,59),G3(:,:,:,151),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),MB,G4tensor(:,63))
  call loop_QV_A(G3(:,:,:,145),wf(:,60),G3(:,:,:,152))
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MB,G4tensor(:,64))
  call loop_QZ_A(G3(:,:,:,145),wf(:,61),G3(:,:,:,153),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,127),MB,G4tensor(:,65))
  call loop_QZ_A(G3(:,:,:,145),wf(:,62),G3(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),MB,G4tensor(:,66))
  call loop_QW_A(G2(:,:,:,202),wf(:,5),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,58),MT,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,-6),G3(:,:,:,156))
  call loop_Q_A(G3(:,:,:,156),Q(:,122),MT,G4(:,:,:,55))
  call loop_QW_A(G4(:,:,:,55),wf(:,4),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MB,G5tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,32),ZERO,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,7),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,112),ZERO,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,12),G2(:,:,:,206))
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,127),ZERO,G3tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,43),G2(:,:,:,207),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,207),Q(:,127),ZERO,G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,43),G2(:,:,:,208),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,127),ZERO,G3tensor(:,101))
  call loop_AV_Q(G2(:,:,:,205),wf(:,57),G2(:,:,:,209))
  call check_last_A_Q(l_switch,G2(:,:,:,209),Q(:,127),ZERO,G3tensor(:,102))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,58),G2(:,:,:,210),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,127),ZERO,G3tensor(:,103))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,58),G2(:,:,:,211),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,211),Q(:,127),ZERO,G3tensor(:,104))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,59),G2(:,:,:,212),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,212),Q(:,127),ZERO,G3tensor(:,105))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,59),G2(:,:,:,213),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,213),Q(:,127),ZERO,G3tensor(:,106))
  call loop_AV_Q(G2(:,:,:,205),wf(:,60),G2(:,:,:,214))
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,127),ZERO,G3tensor(:,107))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,61),G2(:,:,:,215),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,127),ZERO,G3tensor(:,108))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,61),G2(:,:,:,216),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,127),ZERO,G3tensor(:,109))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,62),G2(:,:,:,217),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,217),Q(:,127),ZERO,G3tensor(:,110))
  call loop_AZ_Q(G2(:,:,:,205),wf(:,62),G2(:,:,:,218),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,127),ZERO,G3tensor(:,111))
  call loop_AW_Q(G1(:,:,:,59),wf(:,5),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,42),ZERO,G2(:,:,:,219))
  call loop_AV_Q(G2(:,:,:,219),wf(:,7),G2(:,:,:,220))
  call loop_A_Q(G2(:,:,:,220),Q(:,122),ZERO,G3(:,:,:,157))
  call loop_AW_Q(G3(:,:,:,157),wf(:,4),G3(:,:,:,158))
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,127),ZERO,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,219),wf(:,-4),G2(:,:,:,221))
  call loop_A_Q(G2(:,:,:,221),Q(:,58),ZERO,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-6),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,122),ZERO,G4(:,:,:,57))
  call loop_AW_Q(G4(:,:,:,57),wf(:,4),G4(:,:,:,58))
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,29))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-4),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,48),ZERO,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-6),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,112),ZERO,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,12),G3(:,:,:,162))
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,127),ZERO,G4tensor(:,68))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,43),G3(:,:,:,163),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,163),Q(:,127),ZERO,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,43),G3(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,127),ZERO,G4tensor(:,70))
  call loop_AV_Q(G3(:,:,:,161),wf(:,57),G3(:,:,:,165))
  call check_last_A_Q(l_switch,G3(:,:,:,165),Q(:,127),ZERO,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,58),G3(:,:,:,166),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,127),ZERO,G4tensor(:,72))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,58),G3(:,:,:,167),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,167),Q(:,127),ZERO,G4tensor(:,73))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,59),G3(:,:,:,168),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,127),ZERO,G4tensor(:,74))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,59),G3(:,:,:,169),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,169),Q(:,127),ZERO,G4tensor(:,75))
  call loop_AV_Q(G3(:,:,:,161),wf(:,60),G3(:,:,:,170))
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,76))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,61),G3(:,:,:,171),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,171),Q(:,127),ZERO,G4tensor(:,77))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,61),G3(:,:,:,172),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,127),ZERO,G4tensor(:,78))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,62),G3(:,:,:,173),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,173),Q(:,127),ZERO,G4tensor(:,79))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,62),G3(:,:,:,174),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,174),Q(:,127),ZERO,G4tensor(:,80))
  call loop_AW_Q(G2(:,:,:,222),wf(:,5),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,58),ZERO,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,-6),G3(:,:,:,176))
  call loop_A_Q(G3(:,:,:,176),Q(:,122),ZERO,G4(:,:,:,59))
  call loop_AW_Q(G4(:,:,:,59),wf(:,4),G4(:,:,:,60))
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,32),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,7),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,112),ZERO,G2(:,:,:,225))
  call loop_QV_A(G2(:,:,:,225),wf(:,12),G2(:,:,:,226))
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,127),ZERO,G3tensor(:,112))
  call loop_QZ_A(G2(:,:,:,225),wf(:,43),G2(:,:,:,227),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,227),Q(:,127),ZERO,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,225),wf(:,43),G2(:,:,:,228),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,228),Q(:,127),ZERO,G3tensor(:,114))
  call loop_QV_A(G2(:,:,:,225),wf(:,57),G2(:,:,:,229))
  call check_last_Q_A(l_switch,G2(:,:,:,229),Q(:,127),ZERO,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,225),wf(:,58),G2(:,:,:,230),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,230),Q(:,127),ZERO,G3tensor(:,116))
  call loop_QZ_A(G2(:,:,:,225),wf(:,58),G2(:,:,:,231),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,231),Q(:,127),ZERO,G3tensor(:,117))
  call loop_QZ_A(G2(:,:,:,225),wf(:,59),G2(:,:,:,232),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,232),Q(:,127),ZERO,G3tensor(:,118))
  call loop_QZ_A(G2(:,:,:,225),wf(:,59),G2(:,:,:,233),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,233),Q(:,127),ZERO,G3tensor(:,119))
  call loop_QV_A(G2(:,:,:,225),wf(:,60),G2(:,:,:,234))
  call check_last_Q_A(l_switch,G2(:,:,:,234),Q(:,127),ZERO,G3tensor(:,120))
  call loop_QZ_A(G2(:,:,:,225),wf(:,61),G2(:,:,:,235),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,235),Q(:,127),ZERO,G3tensor(:,121))
  call loop_QZ_A(G2(:,:,:,225),wf(:,61),G2(:,:,:,236),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,236),Q(:,127),ZERO,G3tensor(:,122))
  call loop_QZ_A(G2(:,:,:,225),wf(:,62),G2(:,:,:,237),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,237),Q(:,127),ZERO,G3tensor(:,123))
  call loop_QZ_A(G2(:,:,:,225),wf(:,62),G2(:,:,:,238),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,238),Q(:,127),ZERO,G3tensor(:,124))
  call loop_QW_A(G1(:,:,:,63),wf(:,5),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,42),ZERO,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,7),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,122),ZERO,G3(:,:,:,177))
  call loop_QW_A(G3(:,:,:,177),wf(:,4),G3(:,:,:,178))
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,239),wf(:,-4),G2(:,:,:,241))
  call loop_Q_A(G2(:,:,:,241),Q(:,58),ZERO,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,-6),G3(:,:,:,180))
  call loop_Q_A(G3(:,:,:,180),Q(:,122),ZERO,G4(:,:,:,61))
  call loop_QW_A(G4(:,:,:,61),wf(:,4),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),ZERO,G5tensor(:,31))
  call loop_QV_A(G1(:,:,:,63),wf(:,-4),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,48),ZERO,G2(:,:,:,242))
  call loop_QV_A(G2(:,:,:,242),wf(:,-6),G2(:,:,:,243))
  call loop_Q_A(G2(:,:,:,243),Q(:,112),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,12),G3(:,:,:,182))
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),ZERO,G4tensor(:,82))
  call loop_QZ_A(G3(:,:,:,181),wf(:,43),G3(:,:,:,183),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,181),wf(:,43),G3(:,:,:,184),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QV_A(G3(:,:,:,181),wf(:,57),G3(:,:,:,185))
  call check_last_Q_A(l_switch,G3(:,:,:,185),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,181),wf(:,58),G3(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,181),wf(:,58),G3(:,:,:,187),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,127),ZERO,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,181),wf(:,59),G3(:,:,:,188),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,181),wf(:,59),G3(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,89))
  call loop_QV_A(G3(:,:,:,181),wf(:,60),G3(:,:,:,190))
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),ZERO,G4tensor(:,90))
  call loop_QZ_A(G3(:,:,:,181),wf(:,61),G3(:,:,:,191),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,191),Q(:,127),ZERO,G4tensor(:,91))
  call loop_QZ_A(G3(:,:,:,181),wf(:,61),G3(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,92))
  call loop_QZ_A(G3(:,:,:,181),wf(:,62),G3(:,:,:,193),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,181),wf(:,62),G3(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,94))
  call loop_QW_A(G2(:,:,:,242),wf(:,5),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,58),ZERO,G3(:,:,:,195))
  call loop_QV_A(G3(:,:,:,195),wf(:,-6),G3(:,:,:,196))
  call loop_Q_A(G3(:,:,:,196),Q(:,122),ZERO,G4(:,:,:,63))
  call loop_QW_A(G4(:,:,:,63),wf(:,4),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,127),ZERO,G5tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,16),MT,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,9),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,112),MT,G2(:,:,:,245))
  call loop_AS_Q(G2(:,:,:,245),wf(:,40),G2(:,:,:,246),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,246),Q(:,127),MT,G3tensor(:,125))
  call loop_AV_Q(G2(:,:,:,245),wf(:,12),G2(:,:,:,247))
  call check_last_A_Q(l_switch,G2(:,:,:,247),Q(:,127),MT,G3tensor(:,126))
  call loop_AZ_Q(G2(:,:,:,245),wf(:,43),G2(:,:,:,248),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,127),MT,G3tensor(:,127))
  call loop_AV_Q(G2(:,:,:,245),wf(:,57),G2(:,:,:,249))
  call check_last_A_Q(l_switch,G2(:,:,:,249),Q(:,127),MT,G3tensor(:,128))
  call loop_AZ_Q(G2(:,:,:,245),wf(:,58),G2(:,:,:,250),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,127),MT,G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,245),wf(:,59),G2(:,:,:,251),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,251),Q(:,127),MT,G3tensor(:,130))
  call loop_AV_Q(G2(:,:,:,245),wf(:,60),G2(:,:,:,252))
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,127),MT,G3tensor(:,131))
  call loop_AZ_Q(G2(:,:,:,245),wf(:,61),G2(:,:,:,253),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,253),Q(:,127),MT,G3tensor(:,132))
  call loop_AZ_Q(G2(:,:,:,245),wf(:,62),G2(:,:,:,254),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,127),MT,G3tensor(:,133))
  call loop_AW_Q(G1(:,:,:,67),wf(:,5),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,26),MB,G2(:,:,:,255))
  call loop_AV_Q(G2(:,:,:,255),wf(:,9),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,122),MB,G3(:,:,:,197))
  call loop_AW_Q(G3(:,:,:,197),wf(:,4),G3(:,:,:,198))
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),MT,G4tensor(:,95))
  call loop_AV_Q(G2(:,:,:,255),wf(:,-6),G2(:,:,:,257))
  call loop_A_Q(G2(:,:,:,257),Q(:,90),MB,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,122),MB,G4(:,:,:,65))
  call loop_AW_Q(G4(:,:,:,65),wf(:,4),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),MT,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,255),wf(:,-5),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,58),MB,G3(:,:,:,201))
  call loop_AV_Q(G3(:,:,:,201),wf(:,-6),G3(:,:,:,202))
  call loop_A_Q(G3(:,:,:,202),Q(:,122),MB,G4(:,:,:,67))
  call loop_AW_Q(G4(:,:,:,67),wf(:,4),G4(:,:,:,68))
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),MT,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,48),MT,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-6),G2(:,:,:,260))
  call loop_A_Q(G2(:,:,:,260),Q(:,112),MT,G3(:,:,:,203))
  call loop_AS_Q(G3(:,:,:,203),wf(:,40),G3(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,127),MT,G4tensor(:,96))
  call loop_AV_Q(G3(:,:,:,203),wf(:,12),G3(:,:,:,205))
  call check_last_A_Q(l_switch,G3(:,:,:,205),Q(:,127),MT,G4tensor(:,97))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,43),G3(:,:,:,206),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,127),MT,G4tensor(:,98))
  call loop_AV_Q(G3(:,:,:,203),wf(:,57),G3(:,:,:,207))
  call check_last_A_Q(l_switch,G3(:,:,:,207),Q(:,127),MT,G4tensor(:,99))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,58),G3(:,:,:,208),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,208),Q(:,127),MT,G4tensor(:,100))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,59),G3(:,:,:,209),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,209),Q(:,127),MT,G4tensor(:,101))
  call loop_AV_Q(G3(:,:,:,203),wf(:,60),G3(:,:,:,210))
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,127),MT,G4tensor(:,102))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,61),G3(:,:,:,211),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,211),Q(:,127),MT,G4tensor(:,103))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,62),G3(:,:,:,212),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,127),MT,G4tensor(:,104))
  call loop_AW_Q(G2(:,:,:,259),wf(:,5),G2(:,:,:,261))
  call loop_A_Q(G2(:,:,:,261),Q(:,58),MB,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-6),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,122),MB,G4(:,:,:,69))
  call loop_AW_Q(G4(:,:,:,69),wf(:,4),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),MT,G5tensor(:,35))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-6),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,80),MT,G2(:,:,:,262))
  call loop_AV_Q(G2(:,:,:,262),wf(:,-5),G2(:,:,:,263))
  call loop_A_Q(G2(:,:,:,263),Q(:,112),MT,G3(:,:,:,215))
  call loop_AS_Q(G3(:,:,:,215),wf(:,40),G3(:,:,:,216),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,216),Q(:,127),MT,G4tensor(:,105))
  call loop_AV_Q(G3(:,:,:,215),wf(:,12),G3(:,:,:,217))
  call check_last_A_Q(l_switch,G3(:,:,:,217),Q(:,127),MT,G4tensor(:,106))
  call loop_AZ_Q(G3(:,:,:,215),wf(:,43),G3(:,:,:,218),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,127),MT,G4tensor(:,107))
  call loop_AV_Q(G3(:,:,:,215),wf(:,57),G3(:,:,:,219))
  call check_last_A_Q(l_switch,G3(:,:,:,219),Q(:,127),MT,G4tensor(:,108))
  call loop_AZ_Q(G3(:,:,:,215),wf(:,58),G3(:,:,:,220),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,127),MT,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,215),wf(:,59),G3(:,:,:,221),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,221),Q(:,127),MT,G4tensor(:,110))
  call loop_AV_Q(G3(:,:,:,215),wf(:,60),G3(:,:,:,222))
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,127),MT,G4tensor(:,111))
  call loop_AZ_Q(G3(:,:,:,215),wf(:,61),G3(:,:,:,223),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,223),Q(:,127),MT,G4tensor(:,112))
  call loop_AZ_Q(G3(:,:,:,215),wf(:,62),G3(:,:,:,224),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,224),Q(:,127),MT,G4tensor(:,113))
  call loop_AW_Q(G2(:,:,:,262),wf(:,5),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,90),MB,G3(:,:,:,225))
  call loop_AV_Q(G3(:,:,:,225),wf(:,-5),G3(:,:,:,226))
  call loop_A_Q(G3(:,:,:,226),Q(:,122),MB,G4(:,:,:,71))
  call loop_AW_Q(G4(:,:,:,71),wf(:,4),G4(:,:,:,72))
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,127),MT,G5tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,16),MT,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,9),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,112),MT,G2(:,:,:,265))
  call loop_QS_A(G2(:,:,:,265),wf(:,40),G2(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,127),MT,G3tensor(:,134))
  call loop_QV_A(G2(:,:,:,265),wf(:,12),G2(:,:,:,267))
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,127),MT,G3tensor(:,135))
  call loop_QZ_A(G2(:,:,:,265),wf(:,43),G2(:,:,:,268),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,127),MT,G3tensor(:,136))
  call loop_QV_A(G2(:,:,:,265),wf(:,57),G2(:,:,:,269))
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,127),MT,G3tensor(:,137))
  call loop_QZ_A(G2(:,:,:,265),wf(:,58),G2(:,:,:,270),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,127),MT,G3tensor(:,138))
  call loop_QZ_A(G2(:,:,:,265),wf(:,59),G2(:,:,:,271),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,271),Q(:,127),MT,G3tensor(:,139))
  call loop_QV_A(G2(:,:,:,265),wf(:,60),G2(:,:,:,272))
  call check_last_Q_A(l_switch,G2(:,:,:,272),Q(:,127),MT,G3tensor(:,140))
  call loop_QZ_A(G2(:,:,:,265),wf(:,61),G2(:,:,:,273),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,127),MT,G3tensor(:,141))
  call loop_QZ_A(G2(:,:,:,265),wf(:,62),G2(:,:,:,274),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,274),Q(:,127),MT,G3tensor(:,142))
  call loop_QV_A(G1(:,:,:,72),wf(:,-5),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,48),MT,G2(:,:,:,275))
  call loop_QV_A(G2(:,:,:,275),wf(:,-6),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,112),MT,G3(:,:,:,227))
  call loop_QS_A(G3(:,:,:,227),wf(:,40),G3(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,127),MT,G4tensor(:,114))
  call loop_QV_A(G3(:,:,:,227),wf(:,12),G3(:,:,:,229))
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,127),MT,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,227),wf(:,43),G3(:,:,:,230),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,127),MT,G4tensor(:,116))
  call loop_QV_A(G3(:,:,:,227),wf(:,57),G3(:,:,:,231))
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,127),MT,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,227),wf(:,58),G3(:,:,:,232),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,127),MT,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,227),wf(:,59),G3(:,:,:,233),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,233),Q(:,127),MT,G4tensor(:,119))
  call loop_QV_A(G3(:,:,:,227),wf(:,60),G3(:,:,:,234))
  call check_last_Q_A(l_switch,G3(:,:,:,234),Q(:,127),MT,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,227),wf(:,61),G3(:,:,:,235),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,235),Q(:,127),MT,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,227),wf(:,62),G3(:,:,:,236),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,127),MT,G4tensor(:,122))
  call loop_QV_A(G1(:,:,:,72),wf(:,-6),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,80),MT,G2(:,:,:,277))
  call loop_QV_A(G2(:,:,:,277),wf(:,-5),G2(:,:,:,278))
  call loop_Q_A(G2(:,:,:,278),Q(:,112),MT,G3(:,:,:,237))
  call loop_QS_A(G3(:,:,:,237),wf(:,40),G3(:,:,:,238),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,127),MT,G4tensor(:,123))
  call loop_QV_A(G3(:,:,:,237),wf(:,12),G3(:,:,:,239))
  call check_last_Q_A(l_switch,G3(:,:,:,239),Q(:,127),MT,G4tensor(:,124))
  call loop_QZ_A(G3(:,:,:,237),wf(:,43),G3(:,:,:,240),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,240),Q(:,127),MT,G4tensor(:,125))
  call loop_QV_A(G3(:,:,:,237),wf(:,57),G3(:,:,:,241))
  call check_last_Q_A(l_switch,G3(:,:,:,241),Q(:,127),MT,G4tensor(:,126))
  call loop_QZ_A(G3(:,:,:,237),wf(:,58),G3(:,:,:,242),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,127),MT,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,237),wf(:,59),G3(:,:,:,243),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,243),Q(:,127),MT,G4tensor(:,128))
  call loop_QV_A(G3(:,:,:,237),wf(:,60),G3(:,:,:,244))
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,127),MT,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,237),wf(:,61),G3(:,:,:,245),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,245),Q(:,127),MT,G4tensor(:,130))
  call loop_QZ_A(G3(:,:,:,237),wf(:,62),G3(:,:,:,246),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,127),MT,G4tensor(:,131))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,16),MB,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,9),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,112),MB,G2(:,:,:,279))
  call loop_AS_Q(G2(:,:,:,279),wf(:,40),G2(:,:,:,280),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,280),Q(:,127),MB,G3tensor(:,143))
  call loop_AV_Q(G2(:,:,:,279),wf(:,12),G2(:,:,:,281))
  call check_last_A_Q(l_switch,G2(:,:,:,281),Q(:,127),MB,G3tensor(:,144))
  call loop_AZ_Q(G2(:,:,:,279),wf(:,43),G2(:,:,:,282),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,127),MB,G3tensor(:,145))
  call loop_AV_Q(G2(:,:,:,279),wf(:,57),G2(:,:,:,283))
  call check_last_A_Q(l_switch,G2(:,:,:,283),Q(:,127),MB,G3tensor(:,146))
  call loop_AZ_Q(G2(:,:,:,279),wf(:,58),G2(:,:,:,284),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,284),Q(:,127),MB,G3tensor(:,147))
  call loop_AZ_Q(G2(:,:,:,279),wf(:,59),G2(:,:,:,285),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,285),Q(:,127),MB,G3tensor(:,148))
  call loop_AV_Q(G2(:,:,:,279),wf(:,60),G2(:,:,:,286))
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,127),MB,G3tensor(:,149))
  call loop_AZ_Q(G2(:,:,:,279),wf(:,61),G2(:,:,:,287),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,287),Q(:,127),MB,G3tensor(:,150))
  call loop_AZ_Q(G2(:,:,:,279),wf(:,62),G2(:,:,:,288),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,127),MB,G3tensor(:,151))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-5),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,48),MB,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,-6),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,112),MB,G3(:,:,:,247))
  call loop_AS_Q(G3(:,:,:,247),wf(:,40),G3(:,:,:,248),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,127),MB,G4tensor(:,132))
  call loop_AV_Q(G3(:,:,:,247),wf(:,12),G3(:,:,:,249))
  call check_last_A_Q(l_switch,G3(:,:,:,249),Q(:,127),MB,G4tensor(:,133))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,43),G3(:,:,:,250),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,127),MB,G4tensor(:,134))
  call loop_AV_Q(G3(:,:,:,247),wf(:,57),G3(:,:,:,251))
  call check_last_A_Q(l_switch,G3(:,:,:,251),Q(:,127),MB,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,58),G3(:,:,:,252),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,127),MB,G4tensor(:,136))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,59),G3(:,:,:,253),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,253),Q(:,127),MB,G4tensor(:,137))
  call loop_AV_Q(G3(:,:,:,247),wf(:,60),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),MB,G4tensor(:,138))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,61),G3(:,:,:,255),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),MB,G4tensor(:,139))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,62),G3(:,:,:,256),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,127),MB,G4tensor(:,140))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-6),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,80),MB,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-5),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,112),MB,G3(:,:,:,257))
  call loop_AS_Q(G3(:,:,:,257),wf(:,40),G3(:,:,:,258),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),MB,G4tensor(:,141))
  call loop_AV_Q(G3(:,:,:,257),wf(:,12),G3(:,:,:,259))
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),MB,G4tensor(:,142))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,43),G3(:,:,:,260),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),MB,G4tensor(:,143))
  call loop_AV_Q(G3(:,:,:,257),wf(:,57),G3(:,:,:,261))
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),MB,G4tensor(:,144))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,58),G3(:,:,:,262),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),MB,G4tensor(:,145))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,59),G3(:,:,:,263),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),MB,G4tensor(:,146))
  call loop_AV_Q(G3(:,:,:,257),wf(:,60),G3(:,:,:,264))
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,127),MB,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,61),G3(:,:,:,265),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,265),Q(:,127),MB,G4tensor(:,148))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,62),G3(:,:,:,266),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,127),MB,G4tensor(:,149))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,16),MB,G1(:,:,:,80))
  call loop_QV_A(G1(:,:,:,80),wf(:,9),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,112),MB,G2(:,:,:,293))
  call loop_QS_A(G2(:,:,:,293),wf(:,40),G2(:,:,:,294),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,294),Q(:,127),MB,G3tensor(:,152))
  call loop_QV_A(G2(:,:,:,293),wf(:,12),G2(:,:,:,295))
  call check_last_Q_A(l_switch,G2(:,:,:,295),Q(:,127),MB,G3tensor(:,153))
  call loop_QZ_A(G2(:,:,:,293),wf(:,43),G2(:,:,:,296),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,296),Q(:,127),MB,G3tensor(:,154))
  call loop_QV_A(G2(:,:,:,293),wf(:,57),G2(:,:,:,297))
  call check_last_Q_A(l_switch,G2(:,:,:,297),Q(:,127),MB,G3tensor(:,155))
  call loop_QZ_A(G2(:,:,:,293),wf(:,58),G2(:,:,:,298),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,298),Q(:,127),MB,G3tensor(:,156))
  call loop_QZ_A(G2(:,:,:,293),wf(:,59),G2(:,:,:,299),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,299),Q(:,127),MB,G3tensor(:,157))
  call loop_QV_A(G2(:,:,:,293),wf(:,60),G2(:,:,:,300))
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,127),MB,G3tensor(:,158))
  call loop_QZ_A(G2(:,:,:,293),wf(:,61),G2(:,:,:,301),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,301),Q(:,127),MB,G3tensor(:,159))
  call loop_QZ_A(G2(:,:,:,293),wf(:,62),G2(:,:,:,302),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,302),Q(:,127),MB,G3tensor(:,160))
  call loop_QW_A(G1(:,:,:,80),wf(:,5),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,26),MT,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,9),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,122),MT,G3(:,:,:,267))
  call loop_QW_A(G3(:,:,:,267),wf(:,4),G3(:,:,:,268))
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,127),MB,G4tensor(:,150))
  call loop_QV_A(G2(:,:,:,303),wf(:,-6),G2(:,:,:,305))
  call loop_Q_A(G2(:,:,:,305),Q(:,90),MT,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-5),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,122),MT,G4(:,:,:,73))
  call loop_QW_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),MB,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,303),wf(:,-5),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,58),MT,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-6),G3(:,:,:,272))
  call loop_Q_A(G3(:,:,:,272),Q(:,122),MT,G4(:,:,:,75))
  call loop_QW_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76))
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),MB,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,80),wf(:,-5),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,48),MB,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-6),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,112),MB,G3(:,:,:,273))
  call loop_QS_A(G3(:,:,:,273),wf(:,40),G3(:,:,:,274),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,127),MB,G4tensor(:,151))
  call loop_QV_A(G3(:,:,:,273),wf(:,12),G3(:,:,:,275))
  call check_last_Q_A(l_switch,G3(:,:,:,275),Q(:,127),MB,G4tensor(:,152))
  call loop_QZ_A(G3(:,:,:,273),wf(:,43),G3(:,:,:,276),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,127),MB,G4tensor(:,153))
  call loop_QV_A(G3(:,:,:,273),wf(:,57),G3(:,:,:,277))
  call check_last_Q_A(l_switch,G3(:,:,:,277),Q(:,127),MB,G4tensor(:,154))
  call loop_QZ_A(G3(:,:,:,273),wf(:,58),G3(:,:,:,278),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,278),Q(:,127),MB,G4tensor(:,155))
  call loop_QZ_A(G3(:,:,:,273),wf(:,59),G3(:,:,:,279),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,279),Q(:,127),MB,G4tensor(:,156))
  call loop_QV_A(G3(:,:,:,273),wf(:,60),G3(:,:,:,280))
  call check_last_Q_A(l_switch,G3(:,:,:,280),Q(:,127),MB,G4tensor(:,157))
  call loop_QZ_A(G3(:,:,:,273),wf(:,61),G3(:,:,:,281),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,281),Q(:,127),MB,G4tensor(:,158))
  call loop_QZ_A(G3(:,:,:,273),wf(:,62),G3(:,:,:,282),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,282),Q(:,127),MB,G4tensor(:,159))
  call loop_QW_A(G2(:,:,:,307),wf(:,5),G2(:,:,:,309))
  call loop_Q_A(G2(:,:,:,309),Q(:,58),MT,G3(:,:,:,283))
  call loop_QV_A(G3(:,:,:,283),wf(:,-6),G3(:,:,:,284))
  call loop_Q_A(G3(:,:,:,284),Q(:,122),MT,G4(:,:,:,77))
  call loop_QW_A(G4(:,:,:,77),wf(:,4),G4(:,:,:,78))
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),MB,G5tensor(:,39))
  call loop_QV_A(G1(:,:,:,80),wf(:,-6),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,80),MB,G2(:,:,:,310))
  call loop_QV_A(G2(:,:,:,310),wf(:,-5),G2(:,:,:,311))
  call loop_Q_A(G2(:,:,:,311),Q(:,112),MB,G3(:,:,:,285))
  call loop_QS_A(G3(:,:,:,285),wf(:,40),G3(:,:,:,286),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,286),Q(:,127),MB,G4tensor(:,160))
  call loop_QV_A(G3(:,:,:,285),wf(:,12),G3(:,:,:,287))
  call check_last_Q_A(l_switch,G3(:,:,:,287),Q(:,127),MB,G4tensor(:,161))
  call loop_QZ_A(G3(:,:,:,285),wf(:,43),G3(:,:,:,288),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,288),Q(:,127),MB,G4tensor(:,162))
  call loop_QV_A(G3(:,:,:,285),wf(:,57),G3(:,:,:,289))
  call check_last_Q_A(l_switch,G3(:,:,:,289),Q(:,127),MB,G4tensor(:,163))
  call loop_QZ_A(G3(:,:,:,285),wf(:,58),G3(:,:,:,290),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,127),MB,G4tensor(:,164))
  call loop_QZ_A(G3(:,:,:,285),wf(:,59),G3(:,:,:,291),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,291),Q(:,127),MB,G4tensor(:,165))
  call loop_QV_A(G3(:,:,:,285),wf(:,60),G3(:,:,:,292))
  call check_last_Q_A(l_switch,G3(:,:,:,292),Q(:,127),MB,G4tensor(:,166))
  call loop_QZ_A(G3(:,:,:,285),wf(:,61),G3(:,:,:,293),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,293),Q(:,127),MB,G4tensor(:,167))
  call loop_QZ_A(G3(:,:,:,285),wf(:,62),G3(:,:,:,294),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,294),Q(:,127),MB,G4tensor(:,168))
  call loop_QW_A(G2(:,:,:,310),wf(:,5),G2(:,:,:,312))
  call loop_Q_A(G2(:,:,:,312),Q(:,90),MT,G3(:,:,:,295))
  call loop_QV_A(G3(:,:,:,295),wf(:,-5),G3(:,:,:,296))
  call loop_Q_A(G3(:,:,:,296),Q(:,122),MT,G4(:,:,:,79))
  call loop_QW_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,80))
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),MB,G5tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,16),ZERO,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,9),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,112),ZERO,G2(:,:,:,313))
  call loop_AV_Q(G2(:,:,:,313),wf(:,12),G2(:,:,:,314))
  call check_last_A_Q(l_switch,G2(:,:,:,314),Q(:,127),ZERO,G3tensor(:,161))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,43),G2(:,:,:,315),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,315),Q(:,127),ZERO,G3tensor(:,162))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,43),G2(:,:,:,316),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,316),Q(:,127),ZERO,G3tensor(:,163))
  call loop_AV_Q(G2(:,:,:,313),wf(:,57),G2(:,:,:,317))
  call check_last_A_Q(l_switch,G2(:,:,:,317),Q(:,127),ZERO,G3tensor(:,164))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,58),G2(:,:,:,318),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,318),Q(:,127),ZERO,G3tensor(:,165))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,58),G2(:,:,:,319),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,319),Q(:,127),ZERO,G3tensor(:,166))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,59),G2(:,:,:,320),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,320),Q(:,127),ZERO,G3tensor(:,167))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,59),G2(:,:,:,321),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,321),Q(:,127),ZERO,G3tensor(:,168))
  call loop_AV_Q(G2(:,:,:,313),wf(:,60),G2(:,:,:,322))
  call check_last_A_Q(l_switch,G2(:,:,:,322),Q(:,127),ZERO,G3tensor(:,169))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,61),G2(:,:,:,323),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,323),Q(:,127),ZERO,G3tensor(:,170))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,61),G2(:,:,:,324),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,324),Q(:,127),ZERO,G3tensor(:,171))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,62),G2(:,:,:,325),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,325),Q(:,127),ZERO,G3tensor(:,172))
  call loop_AZ_Q(G2(:,:,:,313),wf(:,62),G2(:,:,:,326),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,326),Q(:,127),ZERO,G3tensor(:,173))
  call loop_AW_Q(G1(:,:,:,85),wf(:,5),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,26),ZERO,G2(:,:,:,327))
  call loop_AV_Q(G2(:,:,:,327),wf(:,9),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,122),ZERO,G3(:,:,:,297))
  call loop_AW_Q(G3(:,:,:,297),wf(:,4),G3(:,:,:,298))
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,169))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-6),G2(:,:,:,329))
  call loop_A_Q(G2(:,:,:,329),Q(:,90),ZERO,G3(:,:,:,299))
  call loop_AV_Q(G3(:,:,:,299),wf(:,-5),G3(:,:,:,300))
  call loop_A_Q(G3(:,:,:,300),Q(:,122),ZERO,G4(:,:,:,81))
  call loop_AW_Q(G4(:,:,:,81),wf(:,4),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-5),G2(:,:,:,330))
  call loop_A_Q(G2(:,:,:,330),Q(:,58),ZERO,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-6),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,122),ZERO,G4(:,:,:,83))
  call loop_AW_Q(G4(:,:,:,83),wf(:,4),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,42))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,48),ZERO,G2(:,:,:,331))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-6),G2(:,:,:,332))
  call loop_A_Q(G2(:,:,:,332),Q(:,112),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,12),G3(:,:,:,304))
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,127),ZERO,G4tensor(:,170))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,43),G3(:,:,:,305),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,305),Q(:,127),ZERO,G4tensor(:,171))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,43),G3(:,:,:,306),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,127),ZERO,G4tensor(:,172))
  call loop_AV_Q(G3(:,:,:,303),wf(:,57),G3(:,:,:,307))
  call check_last_A_Q(l_switch,G3(:,:,:,307),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,58),G3(:,:,:,308),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,58),G3(:,:,:,309),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,309),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,59),G3(:,:,:,310),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,59),G3(:,:,:,311),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,311),Q(:,127),ZERO,G4tensor(:,177))
  call loop_AV_Q(G3(:,:,:,303),wf(:,60),G3(:,:,:,312))
  call check_last_A_Q(l_switch,G3(:,:,:,312),Q(:,127),ZERO,G4tensor(:,178))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,61),G3(:,:,:,313),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,313),Q(:,127),ZERO,G4tensor(:,179))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,61),G3(:,:,:,314),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,314),Q(:,127),ZERO,G4tensor(:,180))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,62),G3(:,:,:,315),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,315),Q(:,127),ZERO,G4tensor(:,181))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,62),G3(:,:,:,316),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,127),ZERO,G4tensor(:,182))
  call loop_AW_Q(G2(:,:,:,331),wf(:,5),G2(:,:,:,333))
  call loop_A_Q(G2(:,:,:,333),Q(:,58),ZERO,G3(:,:,:,317))
  call loop_AV_Q(G3(:,:,:,317),wf(:,-6),G3(:,:,:,318))
  call loop_A_Q(G3(:,:,:,318),Q(:,122),ZERO,G4(:,:,:,85))
  call loop_AW_Q(G4(:,:,:,85),wf(:,4),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,43))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-6),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,80),ZERO,G2(:,:,:,334))
  call loop_AV_Q(G2(:,:,:,334),wf(:,-5),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,112),ZERO,G3(:,:,:,319))
  call loop_AV_Q(G3(:,:,:,319),wf(:,12),G3(:,:,:,320))
  call check_last_A_Q(l_switch,G3(:,:,:,320),Q(:,127),ZERO,G4tensor(:,183))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,43),G3(:,:,:,321),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,321),Q(:,127),ZERO,G4tensor(:,184))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,43),G3(:,:,:,322),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,322),Q(:,127),ZERO,G4tensor(:,185))
  call loop_AV_Q(G3(:,:,:,319),wf(:,57),G3(:,:,:,323))
  call check_last_A_Q(l_switch,G3(:,:,:,323),Q(:,127),ZERO,G4tensor(:,186))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,58),G3(:,:,:,324),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,127),ZERO,G4tensor(:,187))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,58),G3(:,:,:,325),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,325),Q(:,127),ZERO,G4tensor(:,188))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,59),G3(:,:,:,326),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,326),Q(:,127),ZERO,G4tensor(:,189))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,59),G3(:,:,:,327),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,327),Q(:,127),ZERO,G4tensor(:,190))
  call loop_AV_Q(G3(:,:,:,319),wf(:,60),G3(:,:,:,328))
  call check_last_A_Q(l_switch,G3(:,:,:,328),Q(:,127),ZERO,G4tensor(:,191))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,61),G3(:,:,:,329),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,329),Q(:,127),ZERO,G4tensor(:,192))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,61),G3(:,:,:,330),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,127),ZERO,G4tensor(:,193))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,62),G3(:,:,:,331),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,331),Q(:,127),ZERO,G4tensor(:,194))
  call loop_AZ_Q(G3(:,:,:,319),wf(:,62),G3(:,:,:,332),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,332),Q(:,127),ZERO,G4tensor(:,195))
  call loop_AW_Q(G2(:,:,:,334),wf(:,5),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,90),ZERO,G3(:,:,:,333))
  call loop_AV_Q(G3(:,:,:,333),wf(:,-5),G3(:,:,:,334))
  call loop_A_Q(G3(:,:,:,334),Q(:,122),ZERO,G4(:,:,:,87))
  call loop_AW_Q(G4(:,:,:,87),wf(:,4),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,44))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(13)) * den(30)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(30)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(13)) * den(30)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(30)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(11)) * den(30)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(11) * den(30)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(11)) * den(30)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(11) * den(30)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(22) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(22)) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(20) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(20)) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(22) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(22)) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(20) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(20)) * den(65)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(20)) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(20) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(19)) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(19) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(20)) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(20) * den(65)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(19)) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(19) * den(65)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,38),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(16)) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,38),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(15) * den(33)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(15)) * den(33)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,51),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(16)) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(15) * den(33)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(15)) * den(33)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(16)) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(15) * den(33)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(15)) * den(33)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,52),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(16)) * den(33)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,52),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(15) * den(33)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(15)) * den(33)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,4),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,4),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_15,masses2_7,G4tensor(:,1),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_15,masses2_7,G4tensor(:,1),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,5),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,5),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,11),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,11),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,17),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,23),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,23),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,6),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,6),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,12),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,12),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(8) * den(66)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,18),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(8)) * den(66)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,18),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(7) * den(66)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,24),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,24),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(13) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(13) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(34)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,81),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(34)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,90),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(22)) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(22) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(20)) * den(67)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(20) * den(67)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(22)) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(22) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(20)) * den(67)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(20) * den(67)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(20) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(20)) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(19) * den(67)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(19)) * den(67)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,82),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(20) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(20)) * den(67)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(19) * den(67)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(19)) * den(67)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,91),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(16)) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(15) * den(35)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(16)) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(15) * den(35)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(16)) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(15) * den(35)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,83),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(16)) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(35)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(15) * den(35)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,92),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,67),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,67),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_13,masses2_7,G4tensor(:,29),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_13,masses2_7,G4tensor(:,29),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,81),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,81),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,57),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,57),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,7),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,7),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,13),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,13),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,19),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,19),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,25),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,25),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,8),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,8),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,14),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,14),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(8)) * den(68)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,20),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(8) * den(68)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,20),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,26),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,26),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(13)) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,125),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(13) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,125),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(13)) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,134),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(13) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,134),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,143),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,143),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,152),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,152),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(22) * den(69)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(22)) * den(69)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(20) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,126),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(20)) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,126),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(20) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,135),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(20)) * den(69)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,135),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(20)) * den(69)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(20) * den(69)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(19)) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,144),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(19) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,144),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(19)) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,153),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(19) * den(69)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,153),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(16) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,162),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,162),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,127),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,127),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(15) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,136),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(37)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,136),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(16) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,163),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(37)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,163),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,145),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,145),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,154),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(37)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,154),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(8) * den(70)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,169),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(8)) * den(70)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,169),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_10,masses2_7,G4tensor(:,95),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_10,masses2_7,G4tensor(:,95),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,150),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,150),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(8) * den(70)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,9),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(8)) * den(70)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,9),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,15),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,15),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(8) * den(70)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,21),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(8)) * den(70)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,21),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,27),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,27),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(8) * den(70)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,10),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(8)) * den(70)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,10),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,16),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,16),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(8) * den(70)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,22),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(8)) * den(70)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,22),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(7) * den(70)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,28),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(7)) * den(70)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,28),T4sum(1:70,27))
  M(1) = M(1) + (f(14) * den(29)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,39),T4sum(1:70,28))
  M(2) = M(2) + (f(14) * den(29)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,30),T4sum(1:70,28))
  M(1) = M(1) + (f(12) * den(29)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,58),T4sum(1:70,29))
  M(2) = M(2) + (f(12) * den(29)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,48),T4sum(1:70,29))
  M(1) = M(1) + (-f(27) * den(58)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,82),T4sum(1:70,30))
  M(1) = M(1) + (-f(25) * den(58)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,40),T4sum(1:70,28))
  M(2) = M(2) + (-f(27) * den(58)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,68),T4sum(1:70,30))
  M(2) = M(2) + (-f(25) * den(58)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,31),T4sum(1:70,28))
  M(1) = M(1) + (f(25) * den(58)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,82),T4sum(1:70,30))
  M(1) = M(1) + (f(24) * den(58)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,59),T4sum(1:70,29))
  M(2) = M(2) + (f(25) * den(58)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,68),T4sum(1:70,30))
  M(2) = M(2) + (f(24) * den(58)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,49),T4sum(1:70,29))
  M(1) = M(1) + (-f(18) * den(32)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,83),T4sum(1:70,30))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,41),T4sum(1:70,28))
  M(2) = M(2) + (-f(18) * den(32)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,69),T4sum(1:70,30))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,32),T4sum(1:70,28))
  M(1) = M(1) + (-f(18) * den(32)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,84),T4sum(1:70,30))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,60),T4sum(1:70,29))
  M(2) = M(2) + (-f(18) * den(32)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,70),T4sum(1:70,30))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,50),T4sum(1:70,29))
  M(1) = M(1) + (f(14) * den(29)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,96),T4sum(1:70,31))
  M(2) = M(2) + (f(14) * den(29)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,114),T4sum(1:70,31))
  M(1) = M(1) + (f(12) * den(29)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,132),T4sum(1:70,32))
  M(2) = M(2) + (f(12) * den(29)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,151),T4sum(1:70,32))
  M(1) = M(1) + (-f(27) * den(58)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,170),T4sum(1:70,33))
  M(1) = M(1) + (-f(25) * den(58)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,97),T4sum(1:70,31))
  M(2) = M(2) + (-f(25) * den(58)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,115),T4sum(1:70,31))
  M(1) = M(1) + (f(25) * den(58)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,170),T4sum(1:70,33))
  M(1) = M(1) + (f(24) * den(58)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,133),T4sum(1:70,32))
  M(2) = M(2) + (f(24) * den(58)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,152),T4sum(1:70,32))
  M(1) = M(1) + (-f(18) * den(32)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,171),T4sum(1:70,33))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,98),T4sum(1:70,31))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,116),T4sum(1:70,31))
  M(1) = M(1) + (-f(18) * den(32)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,172),T4sum(1:70,33))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,134),T4sum(1:70,32))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,153),T4sum(1:70,32))
  M(2) = M(2) + (f(14) * den(29)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,105),T4sum(1:70,34))
  M(1) = M(1) + (f(14) * den(29)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,123),T4sum(1:70,34))
  M(2) = M(2) + (f(12) * den(29)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,141),T4sum(1:70,35))
  M(1) = M(1) + (f(12) * den(29)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,160),T4sum(1:70,35))
  M(2) = M(2) + (-f(27) * den(58)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,183),T4sum(1:70,36))
  M(2) = M(2) + (-f(25) * den(58)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,106),T4sum(1:70,34))
  M(1) = M(1) + (-f(25) * den(58)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,124),T4sum(1:70,34))
  M(2) = M(2) + (f(25) * den(58)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,183),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(58)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,142),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(58)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,161),T4sum(1:70,35))
  M(2) = M(2) + (-f(18) * den(32)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,184),T4sum(1:70,36))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,107),T4sum(1:70,34))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,125),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(32)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,185),T4sum(1:70,36))
  M(2) = M(2) + (-f(17) * den(32)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,143),T4sum(1:70,35))
  M(1) = M(1) + (-f(17) * den(32)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,162),T4sum(1:70,35))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_20,masses2_17,G5tensor(:,1),T5sum(1:126,1))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_20,masses2_16,G5tensor(:,7),T5sum(1:126,2))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_20,masses2_17,G5tensor(:,13),T5sum(1:126,1))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_20,masses2_11,G5tensor(:,19),T5sum(1:126,3))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_18,masses2_17,G5tensor(:,3),T5sum(1:126,4))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_18,masses2_16,G5tensor(:,9),T5sum(1:126,5))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_18,masses2_17,G5tensor(:,15),T5sum(1:126,4))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_18,masses2_11,G5tensor(:,21),T5sum(1:126,6))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_21,masses2_17,G5tensor(:,2),T5sum(1:126,7))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_21,masses2_16,G5tensor(:,8),T5sum(1:126,8))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_21,masses2_17,G5tensor(:,14),T5sum(1:126,7))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_21,masses2_11,G5tensor(:,20),T5sum(1:126,9))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_24,masses2_17,G5tensor(:,43),T5sum(1:126,10))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_24,masses2_15,G5tensor(:,35),T5sum(1:126,11))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_24,masses2_12,G5tensor(:,39),T5sum(1:126,12))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_16,masses2_17,G5tensor(:,5),T5sum(1:126,13))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_16,masses2_16,G5tensor(:,11),T5sum(1:126,14))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_16,masses2_17,G5tensor(:,17),T5sum(1:126,13))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_16,masses2_11,G5tensor(:,23),T5sum(1:126,15))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_27,masses2_17,G5tensor(:,30),T5sum(1:126,16))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_27,masses2_15,G5tensor(:,26),T5sum(1:126,17))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_27,masses2_17,G5tensor(:,32),T5sum(1:126,16))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_27,masses2_12,G5tensor(:,28),T5sum(1:126,18))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_19,masses2_17,G5tensor(:,4),T5sum(1:126,19))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_19,masses2_16,G5tensor(:,10),T5sum(1:126,20))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_19,masses2_17,G5tensor(:,16),T5sum(1:126,19))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_19,masses2_11,G5tensor(:,22),T5sum(1:126,21))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_25,masses2_17,G5tensor(:,44),T5sum(1:126,22))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_25,masses2_15,G5tensor(:,36),T5sum(1:126,23))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_25,masses2_12,G5tensor(:,40),T5sum(1:126,24))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_17,masses2_17,G5tensor(:,6),T5sum(1:126,25))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_17,masses2_16,G5tensor(:,12),T5sum(1:126,26))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_17,masses2_17,G5tensor(:,18),T5sum(1:126,25))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_17,masses2_11,G5tensor(:,24),T5sum(1:126,27))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_26,masses2_17,G5tensor(:,31),T5sum(1:126,28))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_26,masses2_13,G5tensor(:,27),T5sum(1:126,29))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_26,masses2_17,G5tensor(:,29),T5sum(1:126,28))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_26,masses2_14,G5tensor(:,25),T5sum(1:126,30))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_23,masses2_13,G5tensor(:,37),T5sum(1:126,32))
  M(2) = M(2) + (-f(10) * den(4)) * TI2_call(5,momenta_23,masses2_17,G5tensor(:,41),T5sum(1:126,31))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_23,masses2_14,G5tensor(:,33),T5sum(1:126,33))
  M(2) = M(2) + (-f(9) * den(4)) * TI2_call(5,momenta_22,masses2_13,G5tensor(:,38),T5sum(1:126,35))
  M(1) = M(1) + (-f(10) * den(4)) * TI2_call(5,momenta_22,masses2_17,G5tensor(:,42),T5sum(1:126,34))
  M(1) = M(1) + (-f(9) * den(4)) * TI2_call(5,momenta_22,masses2_14,G5tensor(:,34),T5sum(1:126,36))
  M(1) = M(1) + (-(CI*f(22)) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(22) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(20)) * den(71)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(20) * den(71)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(22)) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(22) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(20)) * den(71)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(20) * den(71)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(20) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(20)) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(19) * den(71)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19)) * den(71)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(20) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(20)) * den(71)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(19) * den(71)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19)) * den(71)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,54),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(72)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(72)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(72)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(72)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,55),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,55),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(72)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(72)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(72)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(72)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(72)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,56),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,56),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(73)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(73)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(73)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(73)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,57),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,57),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(73)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(73)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(73)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(73)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(73)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(22) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(22)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(20) * den(74)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(20)) * den(74)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(22) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(22)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(20) * den(74)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(20)) * den(74)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(20)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(20) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(19)) * den(74)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(19) * den(74)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(20)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(20) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(19)) * den(74)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(19) * den(74)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,84),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(75)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(75)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(75)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(75)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(75)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(75)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(75)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(75)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,85),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(76)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(76)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(76)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(76)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(76)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(76)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(76)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(76)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,86),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(20)) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,137),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(20) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,137),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(22)) * den(77)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(22) * den(77)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(20)) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,128),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(20) * den(77)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,128),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(19) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,155),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(19)) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,155),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(20) * den(77)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(20)) * den(77)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(19) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,146),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(19)) * den(77)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,146),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(21) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,138),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,138),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(23) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,165),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,165),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,129),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,129),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(21) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,156),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,156),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(23) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,166),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,166),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,147),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,147),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(21) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,139),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,139),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(23) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,167),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,167),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,130),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,130),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(21) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,157),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,157),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(23) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,168),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,168),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,148),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,148),T3sum(1:35,8))
  M(1) = M(1) + (f(27) * den(59)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,85),T4sum(1:70,30))
  M(1) = M(1) + (f(25) * den(59)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,42),T4sum(1:70,28))
  M(2) = M(2) + (f(27) * den(59)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,71),T4sum(1:70,30))
  M(2) = M(2) + (f(25) * den(59)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,33),T4sum(1:70,28))
  M(1) = M(1) + (-f(25) * den(59)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,85),T4sum(1:70,30))
  M(1) = M(1) + (-f(24) * den(59)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,61),T4sum(1:70,29))
  M(2) = M(2) + (-f(25) * den(59)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,71),T4sum(1:70,30))
  M(2) = M(2) + (-f(24) * den(59)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,51),T4sum(1:70,29))
  M(1) = M(1) + (-f(28) * den(60)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,86),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,43),T4sum(1:70,28))
  M(2) = M(2) + (-f(28) * den(60)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,72),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,34),T4sum(1:70,28))
  M(1) = M(1) + (-f(28) * den(60)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,87),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,62),T4sum(1:70,29))
  M(2) = M(2) + (-f(28) * den(60)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,73),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,52),T4sum(1:70,29))
  M(1) = M(1) + (f(27) * den(59)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,173),T4sum(1:70,33))
  M(1) = M(1) + (f(25) * den(59)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,99),T4sum(1:70,31))
  M(2) = M(2) + (f(25) * den(59)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,117),T4sum(1:70,31))
  M(1) = M(1) + (-f(25) * den(59)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,173),T4sum(1:70,33))
  M(1) = M(1) + (-f(24) * den(59)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,135),T4sum(1:70,32))
  M(2) = M(2) + (-f(24) * den(59)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,154),T4sum(1:70,32))
  M(1) = M(1) + (-f(28) * den(60)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,174),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,100),T4sum(1:70,31))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,118),T4sum(1:70,31))
  M(1) = M(1) + (-f(28) * den(60)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,175),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,136),T4sum(1:70,32))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,155),T4sum(1:70,32))
  M(2) = M(2) + (f(27) * den(59)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,186),T4sum(1:70,36))
  M(2) = M(2) + (f(25) * den(59)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,108),T4sum(1:70,34))
  M(1) = M(1) + (f(25) * den(59)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,126),T4sum(1:70,34))
  M(2) = M(2) + (-f(25) * den(59)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,186),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(59)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,144),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(59)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,163),T4sum(1:70,35))
  M(2) = M(2) + (-f(28) * den(60)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,187),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,109),T4sum(1:70,34))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,127),T4sum(1:70,34))
  M(2) = M(2) + (-f(28) * den(60)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,188),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(60)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,145),T4sum(1:70,35))
  M(1) = M(1) + (-f(26) * den(60)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,164),T4sum(1:70,35))
  M(1) = M(1) + (-f(28) * den(61)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,88),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,44),T4sum(1:70,28))
  M(2) = M(2) + (-f(28) * den(61)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,74),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,35),T4sum(1:70,28))
  M(1) = M(1) + (-f(28) * den(61)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,89),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,63),T4sum(1:70,29))
  M(2) = M(2) + (-f(28) * den(61)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,75),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,53),T4sum(1:70,29))
  M(1) = M(1) + (-f(28) * den(61)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,176),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,101),T4sum(1:70,31))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,119),T4sum(1:70,31))
  M(1) = M(1) + (-f(28) * den(61)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,177),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,137),T4sum(1:70,32))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,156),T4sum(1:70,32))
  M(2) = M(2) + (-f(28) * den(61)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,189),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,110),T4sum(1:70,34))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,128),T4sum(1:70,34))
  M(2) = M(2) + (-f(28) * den(61)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,190),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,146),T4sum(1:70,35))
  M(1) = M(1) + (-f(26) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,165),T4sum(1:70,35))
  M(1) = M(1) + (-(CI*f(22)) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(22) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(20)) * den(80)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(20) * den(80)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(22)) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(22) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(20)) * den(80)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(20) * den(80)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(20) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(20)) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(19) * den(80)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19)) * den(80)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(20) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(20)) * den(80)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(19) * den(80)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(19)) * den(80)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,59),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,59),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(81)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(81)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(81)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(81)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,60),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,60),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(81)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(81)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(81)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(81)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(81)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(82)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(82)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(82)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(21)) * den(82)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(23) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,62),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,62),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(82)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(82)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,49),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(23)) * den(82)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,49),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(21) * den(82)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(21)) * den(82)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(22) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(22)) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(20) * den(83)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(20)) * den(83)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(22) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(22)) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(20) * den(83)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(20)) * den(83)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(20)) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(20) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(19)) * den(83)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(19) * den(83)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(20)) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(20) * den(83)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(19)) * den(83)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(19) * den(83)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,87),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(84)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(84)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(84)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(84)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(84)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(84)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(84)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(84)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,88),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(85)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(85)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(85)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(21) * den(85)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(23)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(85)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(85)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(23) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(21)) * den(85)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(21) * den(85)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,89),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(20)) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,140),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(20) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,140),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(22)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,169),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(22) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,169),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(20)) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,131),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(20) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,131),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(19) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,158),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(19)) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,158),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(20) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,169),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(20)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,169),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(19) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,149),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(19)) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,149),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(21) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,141),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,141),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(23) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,170),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,170),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,132),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,132),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(21) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,159),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,159),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(23) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,171),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,171),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,150),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,150),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(21) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,142),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,142),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(23) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,172),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,172),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,133),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(21)) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,133),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(21) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,160),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,160),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(23) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,173),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(23)) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,173),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(21) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,151),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(21)) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,151),T3sum(1:35,8))
  M(1) = M(1) + (f(27) * den(62)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,90),T4sum(1:70,30))
  M(1) = M(1) + (f(25) * den(62)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,45),T4sum(1:70,28))
  M(2) = M(2) + (f(27) * den(62)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,76),T4sum(1:70,30))
  M(2) = M(2) + (f(25) * den(62)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,36),T4sum(1:70,28))
  M(1) = M(1) + (-f(25) * den(62)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,90),T4sum(1:70,30))
  M(1) = M(1) + (-f(24) * den(62)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,64),T4sum(1:70,29))
  M(2) = M(2) + (-f(25) * den(62)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,76),T4sum(1:70,30))
  M(2) = M(2) + (-f(24) * den(62)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,54),T4sum(1:70,29))
  M(1) = M(1) + (-f(28) * den(63)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,91),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,46),T4sum(1:70,28))
  M(2) = M(2) + (-f(28) * den(63)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,77),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,37),T4sum(1:70,28))
  M(1) = M(1) + (-f(28) * den(63)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,92),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,65),T4sum(1:70,29))
  M(2) = M(2) + (-f(28) * den(63)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,78),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,55),T4sum(1:70,29))
  M(1) = M(1) + (f(27) * den(62)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,178),T4sum(1:70,33))
  M(1) = M(1) + (f(25) * den(62)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,102),T4sum(1:70,31))
  M(2) = M(2) + (f(25) * den(62)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,120),T4sum(1:70,31))
  M(1) = M(1) + (-f(25) * den(62)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,178),T4sum(1:70,33))
  M(1) = M(1) + (-f(24) * den(62)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,138),T4sum(1:70,32))
  M(2) = M(2) + (-f(24) * den(62)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,157),T4sum(1:70,32))
  M(1) = M(1) + (-f(28) * den(63)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,179),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,103),T4sum(1:70,31))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,121),T4sum(1:70,31))
  M(1) = M(1) + (-f(28) * den(63)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,180),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,139),T4sum(1:70,32))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,158),T4sum(1:70,32))
  M(2) = M(2) + (f(27) * den(62)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,191),T4sum(1:70,36))
  M(2) = M(2) + (f(25) * den(62)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,111),T4sum(1:70,34))
  M(1) = M(1) + (f(25) * den(62)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,129),T4sum(1:70,34))
  M(2) = M(2) + (-f(25) * den(62)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,191),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(62)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,147),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(62)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,166),T4sum(1:70,35))
  M(2) = M(2) + (-f(28) * den(63)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,192),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,112),T4sum(1:70,34))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,130),T4sum(1:70,34))
  M(2) = M(2) + (-f(28) * den(63)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,193),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(63)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,148),T4sum(1:70,35))
  M(1) = M(1) + (-f(26) * den(63)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,167),T4sum(1:70,35))
  M(1) = M(1) + (-f(28) * den(64)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,93),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,47),T4sum(1:70,28))
  M(2) = M(2) + (-f(28) * den(64)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,79),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,38),T4sum(1:70,28))
  M(1) = M(1) + (-f(28) * den(64)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,94),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,66),T4sum(1:70,29))
  M(2) = M(2) + (-f(28) * den(64)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,80),T4sum(1:70,30))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,56),T4sum(1:70,29))
  M(1) = M(1) + (-f(28) * den(64)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,181),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,104),T4sum(1:70,31))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,122),T4sum(1:70,31))
  M(1) = M(1) + (-f(28) * den(64)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,182),T4sum(1:70,33))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,140),T4sum(1:70,32))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,159),T4sum(1:70,32))
  M(2) = M(2) + (-f(28) * den(64)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,194),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,113),T4sum(1:70,34))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,131),T4sum(1:70,34))
  M(2) = M(2) + (-f(28) * den(64)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,195),T4sum(1:70,36))
  M(2) = M(2) + (-f(26) * den(64)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,149),T4sum(1:70,35))
  M(1) = M(1) + (-f(26) * den(64)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,168),T4sum(1:70,35))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nexnmemxggg_1_/**/REALKIND
