
module ol_vamp_1_ppllllj2_nenexnmnmxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenexnmnmxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenexnmnmxggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenexnmnmxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenexnmnmxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,27) :: G0
  complex(REALKIND), dimension(4,5,4,134) :: G1
  complex(REALKIND), dimension(4,15,4,402) :: G2
  complex(REALKIND), dimension(4,35,4,462) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,108,128))
    allocate(G4tensorhel(70,180,128))
    allocate(G5tensorhel(126,96,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,33),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,49),G2(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,50),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QZ_A(G2(:,:,:,1),wf(:,51),G2(:,:,:,5),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,52),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3),gZu)
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,-6),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,124),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-6),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,112),MT,G2(:,:,:,9))
  call loop_AS_Q(G2(:,:,:,9),wf(:,33),G2(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,49),G2(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,50),G2(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,51),G2(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,52),G2(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,5),G1(:,:,:,6),gZu)
  call loop_A_Q(G1(:,:,:,6),Q(:,60),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-6),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,124),MT,G3(:,:,:,3))
  call loop_AZ_Q(G3(:,:,:,3),wf(:,4),G3(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-6),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,112),MB,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,33),G2(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,127),MB,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,17),wf(:,49),G2(:,:,:,19),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,127),MB,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,17),wf(:,50),G2(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,127),MB,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,17),wf(:,51),G2(:,:,:,21),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,127),MB,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,17),wf(:,52),G2(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,127),MB,G3tensor(:,15))
  call loop_QZ_A(G1(:,:,:,7),wf(:,5),G1(:,:,:,9),gZd)
  call loop_Q_A(G1(:,:,:,9),Q(:,60),MB,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-6),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,124),MB,G3(:,:,:,5))
  call loop_QZ_A(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),MB,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-6),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,112),MB,G2(:,:,:,25))
  call loop_AS_Q(G2(:,:,:,25),wf(:,33),G2(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MB,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,49),G2(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MB,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,50),G2(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MB,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,51),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MB,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,52),G2(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MB,G3tensor(:,20))
  call loop_AZ_Q(G1(:,:,:,10),wf(:,5),G1(:,:,:,12),gZd)
  call loop_A_Q(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-6),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,124),MB,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MB,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,13))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,14),gZu)
  call loop_A_Q(G1(:,:,:,14),Q(:,60),ZERO,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-6),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,124),ZERO,G3(:,:,:,9))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,4),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,60),ZERO,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-6),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,124),ZERO,G3(:,:,:,11))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,4),G3(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,112),ZERO,G2(:,:,:,37))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,49),G2(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),ZERO,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,49),G2(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),ZERO,G3tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,50),G2(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),ZERO,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,50),G2(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),ZERO,G3tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,51),G2(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),ZERO,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,51),G2(:,:,:,43),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),ZERO,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,52),G2(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),ZERO,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,52),G2(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,127),ZERO,G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_QZ_A(G1(:,:,:,17),wf(:,5),G1(:,:,:,18),gZu)
  call loop_Q_A(G1(:,:,:,18),Q(:,60),ZERO,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,-6),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,124),ZERO,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),ZERO,G4tensor(:,7))
  call loop_QZ_A(G1(:,:,:,17),wf(:,5),G1(:,:,:,19),gZd)
  call loop_Q_A(G1(:,:,:,19),Q(:,60),ZERO,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,-6),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,124),ZERO,G3(:,:,:,15))
  call loop_QZ_A(G3(:,:,:,15),wf(:,4),G3(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,127),ZERO,G4tensor(:,8))
  call loop_QV_A(G1(:,:,:,17),wf(:,-6),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,112),ZERO,G2(:,:,:,50))
  call loop_QZ_A(G2(:,:,:,50),wf(:,49),G2(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,50),wf(:,49),G2(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),ZERO,G3tensor(:,30))
  call loop_QZ_A(G2(:,:,:,50),wf(:,50),G2(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),ZERO,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,50),wf(:,50),G2(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,50),wf(:,51),G2(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),ZERO,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,50),wf(:,51),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,50),wf(:,52),G2(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),ZERO,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,50),wf(:,52),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,36))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,3),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,60),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,124),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-6),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,76),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,3),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,124),ZERO,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-4),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,92),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-5),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-5),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,108),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,124),ZERO,G4(:,:,:,3))
  call loop_AZ_Q(G4(:,:,:,3),wf(:,4),G4(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,21),wf(:,7),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,92),ZERO,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,124),ZERO,G3(:,:,:,25))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,4),G3(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-5),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,44),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,7),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,124),ZERO,G3(:,:,:,27))
  call loop_AZ_Q(G3(:,:,:,27),wf(:,4),G3(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-4),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,60),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-6),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,124),ZERO,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,4),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-6),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,108),ZERO,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,-4),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,124),ZERO,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,4),G4(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,21),wf(:,9),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,108),ZERO,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-4),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,124),ZERO,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,4),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,28),ZERO,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,9),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,124),ZERO,G3(:,:,:,35))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,4),G3(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-5),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,60),ZERO,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,-6),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,124),ZERO,G4(:,:,:,9))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,4),G4(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-6),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,92),ZERO,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-5),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,124),ZERO,G4(:,:,:,11))
  call loop_AZ_Q(G4(:,:,:,11),wf(:,4),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,3),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,60),MT,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-6),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,124),MT,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,4),G3(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MT,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-6),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,76),MT,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,3),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,124),MT,G3(:,:,:,43))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,4),G3(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MT,G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-4),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,92),MT,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,124),MT,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,4),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MT,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-5),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,108),MT,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,124),MT,G4(:,:,:,15))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,4),G4(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,28),wf(:,7),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,92),MT,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,124),MT,G3(:,:,:,49))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),MT,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,44),MT,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,7),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),MT,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,4),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),MT,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-4),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,60),MT,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-6),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,124),MT,G4(:,:,:,17))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,4),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),MT,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,108),MT,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,124),MT,G4(:,:,:,19))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,4),G4(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,28),wf(:,9),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,108),MT,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),MT,G3(:,:,:,57))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,4),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-4),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,28),MT,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,9),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),MT,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-5),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,60),MT,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-6),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,124),MT,G4(:,:,:,21))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,4),G4(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),MT,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,92),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,124),MT,G4(:,:,:,23))
  call loop_AZ_Q(G4(:,:,:,23),wf(:,4),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZu)
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,3),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,60),ZERO,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-6),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,124),ZERO,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,4),G3(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,35),wf(:,-6),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,76),ZERO,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,3),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,124),ZERO,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,4),G3(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,97),wf(:,-4),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,92),ZERO,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,124),ZERO,G4(:,:,:,25))
  call loop_QZ_A(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,97),wf(:,-5),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,108),ZERO,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,124),ZERO,G4(:,:,:,27))
  call loop_QZ_A(G4(:,:,:,27),wf(:,4),G4(:,:,:,28),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,127),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,35),wf(:,7),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,92),ZERO,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,124),ZERO,G3(:,:,:,73))
  call loop_QZ_A(G3(:,:,:,73),wf(:,4),G3(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,35),wf(:,-5),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,44),ZERO,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,7),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,124),ZERO,G3(:,:,:,75))
  call loop_QZ_A(G3(:,:,:,75),wf(:,4),G3(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,24))
  call loop_QV_A(G2(:,:,:,103),wf(:,-4),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,60),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,124),ZERO,G4(:,:,:,29))
  call loop_QZ_A(G4(:,:,:,29),wf(:,4),G4(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,103),wf(:,-6),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,108),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,124),ZERO,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,35),wf(:,9),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,108),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,124),ZERO,G3(:,:,:,81))
  call loop_QZ_A(G3(:,:,:,81),wf(:,4),G3(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,28),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,9),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,124),ZERO,G3(:,:,:,83))
  call loop_QZ_A(G3(:,:,:,83),wf(:,4),G3(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,109),wf(:,-5),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,60),ZERO,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-6),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,124),ZERO,G4(:,:,:,33))
  call loop_QZ_A(G4(:,:,:,33),wf(:,4),G4(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,109),wf(:,-6),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,92),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-5),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,124),ZERO,G4(:,:,:,35))
  call loop_QZ_A(G4(:,:,:,35),wf(:,4),G4(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,18))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,11),gZu)
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,60),MT,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-6),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,124),MT,G3(:,:,:,89))
  call loop_QZ_A(G3(:,:,:,89),wf(:,4),G3(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),MT,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,42),wf(:,-6),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,76),MT,G2(:,:,:,115))
  call loop_QV_A(G2(:,:,:,115),wf(:,3),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,124),MT,G3(:,:,:,91))
  call loop_QZ_A(G3(:,:,:,91),wf(:,4),G3(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,115),wf(:,-4),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,92),MT,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-5),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,124),MT,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,115),wf(:,-5),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,108),MT,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,124),MT,G4(:,:,:,39))
  call loop_QZ_A(G4(:,:,:,39),wf(:,4),G4(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,127),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,42),wf(:,7),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,92),MT,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,124),MT,G3(:,:,:,97))
  call loop_QZ_A(G3(:,:,:,97),wf(:,4),G3(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),MT,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,42),wf(:,-5),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,44),MT,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,7),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,124),MT,G3(:,:,:,99))
  call loop_QZ_A(G3(:,:,:,99),wf(:,4),G3(:,:,:,100),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),MT,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,121),wf(:,-4),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,60),MT,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-6),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,124),MT,G4(:,:,:,41))
  call loop_QZ_A(G4(:,:,:,41),wf(:,4),G4(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,121),wf(:,-6),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,108),MT,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-4),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,124),MT,G4(:,:,:,43))
  call loop_QZ_A(G4(:,:,:,43),wf(:,4),G4(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),MT,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,42),wf(:,9),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,108),MT,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-4),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,124),MT,G3(:,:,:,105))
  call loop_QZ_A(G3(:,:,:,105),wf(:,4),G3(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),MT,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,42),wf(:,-4),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,28),MT,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,9),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,124),MT,G3(:,:,:,107))
  call loop_QZ_A(G3(:,:,:,107),wf(:,4),G3(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),MT,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,127),wf(:,-5),G2(:,:,:,129))
  call loop_Q_A(G2(:,:,:,129),Q(:,60),MT,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-6),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,124),MT,G4(:,:,:,45))
  call loop_QZ_A(G4(:,:,:,45),wf(:,4),G4(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,127),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,127),wf(:,-6),G2(:,:,:,130))
  call loop_Q_A(G2(:,:,:,130),Q(:,92),MT,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-5),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,124),MT,G4(:,:,:,47))
  call loop_QZ_A(G4(:,:,:,47),wf(:,4),G4(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),MT,G5tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,12),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,60),ZERO,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-6),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,124),ZERO,G3(:,:,:,113))
  call loop_AZ_Q(G3(:,:,:,113),wf(:,4),G3(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-6),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,76),ZERO,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,3),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,124),ZERO,G3(:,:,:,115))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,4),G3(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,92),ZERO,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-5),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,124),ZERO,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,4),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,108),ZERO,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,124),ZERO,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,49),wf(:,7),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,92),ZERO,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-5),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,124),ZERO,G3(:,:,:,121))
  call loop_AZ_Q(G3(:,:,:,121),wf(:,4),G3(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-5),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,44),ZERO,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,7),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,124),ZERO,G3(:,:,:,123))
  call loop_AZ_Q(G3(:,:,:,123),wf(:,4),G3(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-4),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,60),ZERO,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-6),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,124),ZERO,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-6),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,108),ZERO,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-4),G3(:,:,:,128))
  call loop_A_Q(G3(:,:,:,128),Q(:,124),ZERO,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,4),G4(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,127),ZERO,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,49),wf(:,9),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,108),ZERO,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-4),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,124),ZERO,G3(:,:,:,129))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,4),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-4),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,28),ZERO,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,9),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,124),ZERO,G3(:,:,:,131))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,4),G3(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-5),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,60),ZERO,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-6),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,124),ZERO,G4(:,:,:,57))
  call loop_AZ_Q(G4(:,:,:,57),wf(:,4),G4(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-6),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,92),ZERO,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-5),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,124),ZERO,G4(:,:,:,59))
  call loop_AZ_Q(G4(:,:,:,59),wf(:,4),G4(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,30))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,3),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,60),MB,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-6),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,124),MB,G3(:,:,:,137))
  call loop_AZ_Q(G3(:,:,:,137),wf(:,4),G3(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,127),MB,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-6),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,76),MB,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,3),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,124),MB,G3(:,:,:,139))
  call loop_AZ_Q(G3(:,:,:,139),wf(:,4),G3(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),MB,G4tensor(:,40))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-4),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,92),MB,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-5),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,124),MB,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-5),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,108),MB,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,124),MB,G4(:,:,:,63))
  call loop_AZ_Q(G4(:,:,:,63),wf(:,4),G4(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,127),MB,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,56),wf(:,7),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,92),MB,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,124),MB,G3(:,:,:,145))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,4),G3(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,127),MB,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-5),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,44),MB,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,7),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,124),MB,G3(:,:,:,147))
  call loop_AZ_Q(G3(:,:,:,147),wf(:,4),G3(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,127),MB,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-4),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,60),MB,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-6),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,124),MB,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,4),G4(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-6),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,108),MB,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-4),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,124),MB,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,56),wf(:,9),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,108),MB,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-4),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,124),MB,G3(:,:,:,153))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,4),G3(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,127),MB,G4tensor(:,43))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,28),MB,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,9),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,124),MB,G3(:,:,:,155))
  call loop_AZ_Q(G3(:,:,:,155),wf(:,4),G3(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,127),MB,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-5),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,60),MB,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-6),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,124),MB,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),MB,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-6),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,92),MB,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-5),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,124),MB,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,14),gZd)
  call loop_Q_A(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,3),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,60),ZERO,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,-6),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,124),ZERO,G3(:,:,:,161))
  call loop_QZ_A(G3(:,:,:,161),wf(:,4),G3(:,:,:,162),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,127),ZERO,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,63),wf(:,-6),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,76),ZERO,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,3),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,124),ZERO,G3(:,:,:,163))
  call loop_QZ_A(G3(:,:,:,163),wf(:,4),G3(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,169),wf(:,-4),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,92),ZERO,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-5),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,124),ZERO,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,169),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,108),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,124),ZERO,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),ZERO,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,63),wf(:,7),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,92),ZERO,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,124),ZERO,G3(:,:,:,169))
  call loop_QZ_A(G3(:,:,:,169),wf(:,4),G3(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,63),wf(:,-5),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,44),ZERO,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,7),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,124),ZERO,G3(:,:,:,171))
  call loop_QZ_A(G3(:,:,:,171),wf(:,4),G3(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),ZERO,G4tensor(:,48))
  call loop_QV_A(G2(:,:,:,175),wf(:,-4),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,60),ZERO,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-6),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,124),ZERO,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,4),G4(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),ZERO,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,175),wf(:,-6),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,108),ZERO,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-4),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,124),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,63),wf(:,9),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,108),ZERO,G2(:,:,:,179))
  call loop_QV_A(G2(:,:,:,179),wf(:,-4),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,124),ZERO,G3(:,:,:,177))
  call loop_QZ_A(G3(:,:,:,177),wf(:,4),G3(:,:,:,178),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,63),wf(:,-4),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,28),ZERO,G2(:,:,:,181))
  call loop_QV_A(G2(:,:,:,181),wf(:,9),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,124),ZERO,G3(:,:,:,179))
  call loop_QZ_A(G3(:,:,:,179),wf(:,4),G3(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,181),wf(:,-5),G2(:,:,:,183))
  call loop_Q_A(G2(:,:,:,183),Q(:,60),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-6),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,124),ZERO,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,4),G4(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,181),wf(:,-6),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,92),ZERO,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-5),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,124),ZERO,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,4),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,15),gZd)
  call loop_Q_A(G0(:,:,:,15),Q(:,12),MB,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,3),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,60),MB,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-6),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,124),MB,G3(:,:,:,185))
  call loop_QZ_A(G3(:,:,:,185),wf(:,4),G3(:,:,:,186),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),MB,G4tensor(:,51))
  call loop_QV_A(G1(:,:,:,70),wf(:,-6),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,76),MB,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,3),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,124),MB,G3(:,:,:,187))
  call loop_QZ_A(G3(:,:,:,187),wf(:,4),G3(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),MB,G4tensor(:,52))
  call loop_QV_A(G2(:,:,:,187),wf(:,-4),G2(:,:,:,189))
  call loop_Q_A(G2(:,:,:,189),Q(:,92),MB,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,-5),G3(:,:,:,190))
  call loop_Q_A(G3(:,:,:,190),Q(:,124),MB,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,4),G4(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),MB,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,187),wf(:,-5),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,108),MB,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,124),MB,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,4),G4(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,70),wf(:,7),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,92),MB,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,-5),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,124),MB,G3(:,:,:,193))
  call loop_QZ_A(G3(:,:,:,193),wf(:,4),G3(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),MB,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,70),wf(:,-5),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,44),MB,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,7),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,124),MB,G3(:,:,:,195))
  call loop_QZ_A(G3(:,:,:,195),wf(:,4),G3(:,:,:,196),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,127),MB,G4tensor(:,54))
  call loop_QV_A(G2(:,:,:,193),wf(:,-4),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,60),MB,G3(:,:,:,197))
  call loop_QV_A(G3(:,:,:,197),wf(:,-6),G3(:,:,:,198))
  call loop_Q_A(G3(:,:,:,198),Q(:,124),MB,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,4),G4(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),MB,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,193),wf(:,-6),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,108),MB,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,-4),G3(:,:,:,200))
  call loop_Q_A(G3(:,:,:,200),Q(:,124),MB,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,4),G4(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),MB,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,70),wf(:,9),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,108),MB,G2(:,:,:,197))
  call loop_QV_A(G2(:,:,:,197),wf(:,-4),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,124),MB,G3(:,:,:,201))
  call loop_QZ_A(G3(:,:,:,201),wf(:,4),G3(:,:,:,202),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,127),MB,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,70),wf(:,-4),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,28),MB,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,9),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,124),MB,G3(:,:,:,203))
  call loop_QZ_A(G3(:,:,:,203),wf(:,4),G3(:,:,:,204),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,127),MB,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,199),wf(:,-5),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,60),MB,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,-6),G3(:,:,:,206))
  call loop_Q_A(G3(:,:,:,206),Q(:,124),MB,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,4),G4(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,127),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,199),wf(:,-6),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,92),MB,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,-5),G3(:,:,:,208))
  call loop_Q_A(G3(:,:,:,208),Q(:,124),MB,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,4),G4(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),MB,G5tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,32),MT,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,7),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,112),MT,G2(:,:,:,203))
  call loop_AS_Q(G2(:,:,:,203),wf(:,33),G2(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,127),MT,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,203),wf(:,49),G2(:,:,:,205),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,205),Q(:,127),MT,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,203),wf(:,50),G2(:,:,:,206),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,127),MT,G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,203),wf(:,51),G2(:,:,:,207),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,207),Q(:,127),MT,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,203),wf(:,52),G2(:,:,:,208),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,127),MT,G3tensor(:,41))
  call loop_AZ_Q(G1(:,:,:,77),wf(:,5),G1(:,:,:,79),gZu)
  call loop_A_Q(G1(:,:,:,79),Q(:,44),MT,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,7),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,124),MT,G3(:,:,:,209))
  call loop_AZ_Q(G3(:,:,:,209),wf(:,4),G3(:,:,:,210),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,127),MT,G4tensor(:,57))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-4),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,60),MT,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,-6),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,124),MT,G4(:,:,:,97))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,4),G4(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MT,G5tensor(:,49))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,48),MT,G2(:,:,:,212))
  call loop_AV_Q(G2(:,:,:,212),wf(:,-6),G2(:,:,:,213))
  call loop_A_Q(G2(:,:,:,213),Q(:,112),MT,G3(:,:,:,213))
  call loop_AS_Q(G3(:,:,:,213),wf(:,33),G3(:,:,:,214),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,127),MT,G4tensor(:,58))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,49),G3(:,:,:,215),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,215),Q(:,127),MT,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,50),G3(:,:,:,216),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,216),Q(:,127),MT,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,51),G3(:,:,:,217),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,217),Q(:,127),MT,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,52),G3(:,:,:,218),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,127),MT,G4tensor(:,62))
  call loop_AZ_Q(G2(:,:,:,212),wf(:,5),G2(:,:,:,214),gZu)
  call loop_A_Q(G2(:,:,:,214),Q(:,60),MT,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-6),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,124),MT,G4(:,:,:,99))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,4),G4(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,127),MT,G5tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,32),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,7),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,112),MT,G2(:,:,:,215))
  call loop_QS_A(G2(:,:,:,215),wf(:,33),G2(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,127),MT,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,215),wf(:,49),G2(:,:,:,217),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,217),Q(:,127),MT,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,215),wf(:,50),G2(:,:,:,218),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,127),MT,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,215),wf(:,51),G2(:,:,:,219),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,219),Q(:,127),MT,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,215),wf(:,52),G2(:,:,:,220),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,127),MT,G3tensor(:,46))
  call loop_QZ_A(G1(:,:,:,81),wf(:,5),G1(:,:,:,83),gZu)
  call loop_Q_A(G1(:,:,:,83),Q(:,44),MT,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,7),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,124),MT,G3(:,:,:,221))
  call loop_QZ_A(G3(:,:,:,221),wf(:,4),G3(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),MT,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,221),wf(:,-4),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,60),MT,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,-6),G3(:,:,:,224))
  call loop_Q_A(G3(:,:,:,224),Q(:,124),MT,G4(:,:,:,101))
  call loop_QZ_A(G4(:,:,:,101),wf(:,4),G4(:,:,:,102),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,127),MT,G5tensor(:,51))
  call loop_QV_A(G1(:,:,:,81),wf(:,-4),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,48),MT,G2(:,:,:,224))
  call loop_QV_A(G2(:,:,:,224),wf(:,-6),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,112),MT,G3(:,:,:,225))
  call loop_QS_A(G3(:,:,:,225),wf(:,33),G3(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,127),MT,G4tensor(:,64))
  call loop_QZ_A(G3(:,:,:,225),wf(:,49),G3(:,:,:,227),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,227),Q(:,127),MT,G4tensor(:,65))
  call loop_QZ_A(G3(:,:,:,225),wf(:,50),G3(:,:,:,228),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,127),MT,G4tensor(:,66))
  call loop_QZ_A(G3(:,:,:,225),wf(:,51),G3(:,:,:,229),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,127),MT,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,225),wf(:,52),G3(:,:,:,230),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,230),Q(:,127),MT,G4tensor(:,68))
  call loop_QZ_A(G2(:,:,:,224),wf(:,5),G2(:,:,:,226),gZu)
  call loop_Q_A(G2(:,:,:,226),Q(:,60),MT,G3(:,:,:,231))
  call loop_QV_A(G3(:,:,:,231),wf(:,-6),G3(:,:,:,232))
  call loop_Q_A(G3(:,:,:,232),Q(:,124),MT,G4(:,:,:,103))
  call loop_QZ_A(G4(:,:,:,103),wf(:,4),G4(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,127),MT,G5tensor(:,52))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,32),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,7),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,112),MB,G2(:,:,:,227))
  call loop_AS_Q(G2(:,:,:,227),wf(:,33),G2(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,127),MB,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,227),wf(:,49),G2(:,:,:,229),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,229),Q(:,127),MB,G3tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,227),wf(:,50),G2(:,:,:,230),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,230),Q(:,127),MB,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,227),wf(:,51),G2(:,:,:,231),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,231),Q(:,127),MB,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,227),wf(:,52),G2(:,:,:,232),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,127),MB,G3tensor(:,51))
  call loop_AZ_Q(G1(:,:,:,85),wf(:,5),G1(:,:,:,87),gZd)
  call loop_A_Q(G1(:,:,:,87),Q(:,44),MB,G2(:,:,:,233))
  call loop_AV_Q(G2(:,:,:,233),wf(:,7),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,124),MB,G3(:,:,:,233))
  call loop_AZ_Q(G3(:,:,:,233),wf(:,4),G3(:,:,:,234),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,127),MB,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-4),G2(:,:,:,235))
  call loop_A_Q(G2(:,:,:,235),Q(:,60),MB,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,-6),G3(:,:,:,236))
  call loop_A_Q(G3(:,:,:,236),Q(:,124),MB,G4(:,:,:,105))
  call loop_AZ_Q(G4(:,:,:,105),wf(:,4),G4(:,:,:,106),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,127),MB,G5tensor(:,53))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-4),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,48),MB,G2(:,:,:,236))
  call loop_AV_Q(G2(:,:,:,236),wf(:,-6),G2(:,:,:,237))
  call loop_A_Q(G2(:,:,:,237),Q(:,112),MB,G3(:,:,:,237))
  call loop_AS_Q(G3(:,:,:,237),wf(:,33),G3(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),MB,G4tensor(:,70))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,49),G3(:,:,:,239),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,239),Q(:,127),MB,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,50),G3(:,:,:,240),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,127),MB,G4tensor(:,72))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,51),G3(:,:,:,241),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,241),Q(:,127),MB,G4tensor(:,73))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,52),G3(:,:,:,242),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,127),MB,G4tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,236),wf(:,5),G2(:,:,:,238),gZd)
  call loop_A_Q(G2(:,:,:,238),Q(:,60),MB,G3(:,:,:,243))
  call loop_AV_Q(G3(:,:,:,243),wf(:,-6),G3(:,:,:,244))
  call loop_A_Q(G3(:,:,:,244),Q(:,124),MB,G4(:,:,:,107))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,4),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),MB,G5tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,32),MB,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,7),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,112),MB,G2(:,:,:,239))
  call loop_QS_A(G2(:,:,:,239),wf(:,33),G2(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,127),MB,G3tensor(:,52))
  call loop_QZ_A(G2(:,:,:,239),wf(:,49),G2(:,:,:,241),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,241),Q(:,127),MB,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,239),wf(:,50),G2(:,:,:,242),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,127),MB,G3tensor(:,54))
  call loop_QZ_A(G2(:,:,:,239),wf(:,51),G2(:,:,:,243),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,243),Q(:,127),MB,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,239),wf(:,52),G2(:,:,:,244),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,127),MB,G3tensor(:,56))
  call loop_QZ_A(G1(:,:,:,89),wf(:,5),G1(:,:,:,91),gZd)
  call loop_Q_A(G1(:,:,:,91),Q(:,44),MB,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,7),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,124),MB,G3(:,:,:,245))
  call loop_QZ_A(G3(:,:,:,245),wf(:,4),G3(:,:,:,246),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,127),MB,G4tensor(:,75))
  call loop_QV_A(G2(:,:,:,245),wf(:,-4),G2(:,:,:,247))
  call loop_Q_A(G2(:,:,:,247),Q(:,60),MB,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-6),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,124),MB,G4(:,:,:,109))
  call loop_QZ_A(G4(:,:,:,109),wf(:,4),G4(:,:,:,110),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MB,G5tensor(:,55))
  call loop_QV_A(G1(:,:,:,89),wf(:,-4),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,48),MB,G2(:,:,:,248))
  call loop_QV_A(G2(:,:,:,248),wf(:,-6),G2(:,:,:,249))
  call loop_Q_A(G2(:,:,:,249),Q(:,112),MB,G3(:,:,:,249))
  call loop_QS_A(G3(:,:,:,249),wf(:,33),G3(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,127),MB,G4tensor(:,76))
  call loop_QZ_A(G3(:,:,:,249),wf(:,49),G3(:,:,:,251),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,251),Q(:,127),MB,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,249),wf(:,50),G3(:,:,:,252),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,127),MB,G4tensor(:,78))
  call loop_QZ_A(G3(:,:,:,249),wf(:,51),G3(:,:,:,253),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,253),Q(:,127),MB,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,249),wf(:,52),G3(:,:,:,254),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,127),MB,G4tensor(:,80))
  call loop_QZ_A(G2(:,:,:,248),wf(:,5),G2(:,:,:,250),gZd)
  call loop_Q_A(G2(:,:,:,250),Q(:,60),MB,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-6),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,124),MB,G4(:,:,:,111))
  call loop_QZ_A(G4(:,:,:,111),wf(:,4),G4(:,:,:,112),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,127),MB,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,32),ZERO,G1(:,:,:,93))
  call loop_QZ_A(G1(:,:,:,93),wf(:,5),G1(:,:,:,94),gZu)
  call loop_Q_A(G1(:,:,:,94),Q(:,44),ZERO,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,7),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,124),ZERO,G3(:,:,:,257))
  call loop_QZ_A(G3(:,:,:,257),wf(:,4),G3(:,:,:,258),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,251),wf(:,-4),G2(:,:,:,253))
  call loop_Q_A(G2(:,:,:,253),Q(:,60),ZERO,G3(:,:,:,259))
  call loop_QV_A(G3(:,:,:,259),wf(:,-6),G3(:,:,:,260))
  call loop_Q_A(G3(:,:,:,260),Q(:,124),ZERO,G4(:,:,:,113))
  call loop_QZ_A(G4(:,:,:,113),wf(:,4),G4(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,127),ZERO,G5tensor(:,57))
  call loop_QZ_A(G1(:,:,:,93),wf(:,5),G1(:,:,:,95),gZd)
  call loop_Q_A(G1(:,:,:,95),Q(:,44),ZERO,G2(:,:,:,254))
  call loop_QV_A(G2(:,:,:,254),wf(:,7),G2(:,:,:,255))
  call loop_Q_A(G2(:,:,:,255),Q(:,124),ZERO,G3(:,:,:,261))
  call loop_QZ_A(G3(:,:,:,261),wf(:,4),G3(:,:,:,262),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,254),wf(:,-4),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,60),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-6),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,124),ZERO,G4(:,:,:,115))
  call loop_QZ_A(G4(:,:,:,115),wf(:,4),G4(:,:,:,116),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),ZERO,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,93),wf(:,-4),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,48),ZERO,G2(:,:,:,257))
  call loop_QZ_A(G2(:,:,:,257),wf(:,5),G2(:,:,:,258),gZu)
  call loop_Q_A(G2(:,:,:,258),Q(:,60),ZERO,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-6),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,124),ZERO,G4(:,:,:,117))
  call loop_QZ_A(G4(:,:,:,117),wf(:,4),G4(:,:,:,118),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,127),ZERO,G5tensor(:,59))
  call loop_QZ_A(G2(:,:,:,257),wf(:,5),G2(:,:,:,259),gZd)
  call loop_Q_A(G2(:,:,:,259),Q(:,60),ZERO,G3(:,:,:,267))
  call loop_QV_A(G3(:,:,:,267),wf(:,-6),G3(:,:,:,268))
  call loop_Q_A(G3(:,:,:,268),Q(:,124),ZERO,G4(:,:,:,119))
  call loop_QZ_A(G4(:,:,:,119),wf(:,4),G4(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,127),ZERO,G5tensor(:,60))
  call loop_QV_A(G2(:,:,:,257),wf(:,-6),G2(:,:,:,260))
  call loop_Q_A(G2(:,:,:,260),Q(:,112),ZERO,G3(:,:,:,269))
  call loop_QZ_A(G3(:,:,:,269),wf(:,49),G3(:,:,:,270),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,270),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,269),wf(:,49),G3(:,:,:,271),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,271),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,269),wf(:,50),G3(:,:,:,272),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,269),wf(:,50),G3(:,:,:,273),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,273),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,269),wf(:,51),G3(:,:,:,274),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,127),ZERO,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,269),wf(:,51),G3(:,:,:,275),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,275),Q(:,127),ZERO,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,269),wf(:,52),G3(:,:,:,276),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,127),ZERO,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,269),wf(:,52),G3(:,:,:,277),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,277),Q(:,127),ZERO,G4tensor(:,90))
  call loop_QV_A(G1(:,:,:,93),wf(:,7),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,112),ZERO,G2(:,:,:,261))
  call loop_QZ_A(G2(:,:,:,261),wf(:,49),G2(:,:,:,262),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,262),Q(:,127),ZERO,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,261),wf(:,49),G2(:,:,:,263),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,263),Q(:,127),ZERO,G3tensor(:,58))
  call loop_QZ_A(G2(:,:,:,261),wf(:,50),G2(:,:,:,264),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,127),ZERO,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,261),wf(:,50),G2(:,:,:,265),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,265),Q(:,127),ZERO,G3tensor(:,60))
  call loop_QZ_A(G2(:,:,:,261),wf(:,51),G2(:,:,:,266),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,127),ZERO,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,261),wf(:,51),G2(:,:,:,267),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,127),ZERO,G3tensor(:,62))
  call loop_QZ_A(G2(:,:,:,261),wf(:,52),G2(:,:,:,268),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,127),ZERO,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,261),wf(:,52),G2(:,:,:,269),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,127),ZERO,G3tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,32),ZERO,G1(:,:,:,98))
  call loop_AZ_Q(G1(:,:,:,98),wf(:,5),G1(:,:,:,99),gZu)
  call loop_A_Q(G1(:,:,:,99),Q(:,44),ZERO,G2(:,:,:,270))
  call loop_AV_Q(G2(:,:,:,270),wf(:,7),G2(:,:,:,271))
  call loop_A_Q(G2(:,:,:,271),Q(:,124),ZERO,G3(:,:,:,278))
  call loop_AZ_Q(G3(:,:,:,278),wf(:,4),G3(:,:,:,279),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,279),Q(:,127),ZERO,G4tensor(:,91))
  call loop_AV_Q(G2(:,:,:,270),wf(:,-4),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,60),ZERO,G3(:,:,:,280))
  call loop_AV_Q(G3(:,:,:,280),wf(:,-6),G3(:,:,:,281))
  call loop_A_Q(G3(:,:,:,281),Q(:,124),ZERO,G4(:,:,:,121))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,4),G4(:,:,:,122),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,61))
  call loop_AZ_Q(G1(:,:,:,98),wf(:,5),G1(:,:,:,100),gZd)
  call loop_A_Q(G1(:,:,:,100),Q(:,44),ZERO,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,7),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,124),ZERO,G3(:,:,:,282))
  call loop_AZ_Q(G3(:,:,:,282),wf(:,4),G3(:,:,:,283),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,283),Q(:,127),ZERO,G4tensor(:,92))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-4),G2(:,:,:,275))
  call loop_A_Q(G2(:,:,:,275),Q(:,60),ZERO,G3(:,:,:,284))
  call loop_AV_Q(G3(:,:,:,284),wf(:,-6),G3(:,:,:,285))
  call loop_A_Q(G3(:,:,:,285),Q(:,124),ZERO,G4(:,:,:,123))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,4),G4(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,62))
  call loop_AV_Q(G1(:,:,:,98),wf(:,-4),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,48),ZERO,G2(:,:,:,276))
  call loop_AZ_Q(G2(:,:,:,276),wf(:,5),G2(:,:,:,277),gZu)
  call loop_A_Q(G2(:,:,:,277),Q(:,60),ZERO,G3(:,:,:,286))
  call loop_AV_Q(G3(:,:,:,286),wf(:,-6),G3(:,:,:,287))
  call loop_A_Q(G3(:,:,:,287),Q(:,124),ZERO,G4(:,:,:,125))
  call loop_AZ_Q(G4(:,:,:,125),wf(:,4),G4(:,:,:,126),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,276),wf(:,5),G2(:,:,:,278),gZd)
  call loop_A_Q(G2(:,:,:,278),Q(:,60),ZERO,G3(:,:,:,288))
  call loop_AV_Q(G3(:,:,:,288),wf(:,-6),G3(:,:,:,289))
  call loop_A_Q(G3(:,:,:,289),Q(:,124),ZERO,G4(:,:,:,127))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,4),G4(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,64))
  call loop_AV_Q(G2(:,:,:,276),wf(:,-6),G2(:,:,:,279))
  call loop_A_Q(G2(:,:,:,279),Q(:,112),ZERO,G3(:,:,:,290))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,49),G3(:,:,:,291),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),ZERO,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,49),G3(:,:,:,292),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),ZERO,G4tensor(:,94))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,50),G3(:,:,:,293),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,293),Q(:,127),ZERO,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,50),G3(:,:,:,294),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,127),ZERO,G4tensor(:,96))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,51),G3(:,:,:,295),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,295),Q(:,127),ZERO,G4tensor(:,97))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,51),G3(:,:,:,296),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,127),ZERO,G4tensor(:,98))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,52),G3(:,:,:,297),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,297),Q(:,127),ZERO,G4tensor(:,99))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,52),G3(:,:,:,298),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,100))
  call loop_AV_Q(G1(:,:,:,98),wf(:,7),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,112),ZERO,G2(:,:,:,280))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,49),G2(:,:,:,281),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,281),Q(:,127),ZERO,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,49),G2(:,:,:,282),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,127),ZERO,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,50),G2(:,:,:,283),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,283),Q(:,127),ZERO,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,50),G2(:,:,:,284),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,284),Q(:,127),ZERO,G3tensor(:,68))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,51),G2(:,:,:,285),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,285),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,51),G2(:,:,:,286),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,52),G2(:,:,:,287),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,287),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AZ_Q(G2(:,:,:,280),wf(:,52),G2(:,:,:,288),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,288),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,16),MT,G1(:,:,:,103))
  call loop_AV_Q(G1(:,:,:,103),wf(:,9),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,112),MT,G2(:,:,:,289))
  call loop_AS_Q(G2(:,:,:,289),wf(:,33),G2(:,:,:,290),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,290),Q(:,127),MT,G3tensor(:,73))
  call loop_AZ_Q(G2(:,:,:,289),wf(:,49),G2(:,:,:,291),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,291),Q(:,127),MT,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,289),wf(:,50),G2(:,:,:,292),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,292),Q(:,127),MT,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,289),wf(:,51),G2(:,:,:,293),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,293),Q(:,127),MT,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,289),wf(:,52),G2(:,:,:,294),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,294),Q(:,127),MT,G3tensor(:,77))
  call loop_AZ_Q(G1(:,:,:,103),wf(:,5),G1(:,:,:,105),gZu)
  call loop_A_Q(G1(:,:,:,105),Q(:,28),MT,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,9),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,124),MT,G3(:,:,:,299))
  call loop_AZ_Q(G3(:,:,:,299),wf(:,4),G3(:,:,:,300),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),MT,G4tensor(:,101))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-6),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,92),MT,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-5),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,124),MT,G4(:,:,:,129))
  call loop_AZ_Q(G4(:,:,:,129),wf(:,4),G4(:,:,:,130),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,127),MT,G5tensor(:,65))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-5),G2(:,:,:,298))
  call loop_A_Q(G2(:,:,:,298),Q(:,60),MT,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-6),G3(:,:,:,304))
  call loop_A_Q(G3(:,:,:,304),Q(:,124),MT,G4(:,:,:,131))
  call loop_AZ_Q(G4(:,:,:,131),wf(:,4),G4(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),MT,G5tensor(:,66))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-5),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,48),MT,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-6),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,112),MT,G3(:,:,:,305))
  call loop_AS_Q(G3(:,:,:,305),wf(:,33),G3(:,:,:,306),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,127),MT,G4tensor(:,102))
  call loop_AZ_Q(G3(:,:,:,305),wf(:,49),G3(:,:,:,307),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,307),Q(:,127),MT,G4tensor(:,103))
  call loop_AZ_Q(G3(:,:,:,305),wf(:,50),G3(:,:,:,308),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),MT,G4tensor(:,104))
  call loop_AZ_Q(G3(:,:,:,305),wf(:,51),G3(:,:,:,309),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,309),Q(:,127),MT,G4tensor(:,105))
  call loop_AZ_Q(G3(:,:,:,305),wf(:,52),G3(:,:,:,310),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,127),MT,G4tensor(:,106))
  call loop_AZ_Q(G2(:,:,:,299),wf(:,5),G2(:,:,:,301),gZu)
  call loop_A_Q(G2(:,:,:,301),Q(:,60),MT,G3(:,:,:,311))
  call loop_AV_Q(G3(:,:,:,311),wf(:,-6),G3(:,:,:,312))
  call loop_A_Q(G3(:,:,:,312),Q(:,124),MT,G4(:,:,:,133))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,4),G4(:,:,:,134),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),MT,G5tensor(:,67))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-6),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,80),MT,G2(:,:,:,302))
  call loop_AV_Q(G2(:,:,:,302),wf(:,-5),G2(:,:,:,303))
  call loop_A_Q(G2(:,:,:,303),Q(:,112),MT,G3(:,:,:,313))
  call loop_AS_Q(G3(:,:,:,313),wf(:,33),G3(:,:,:,314),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,314),Q(:,127),MT,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,313),wf(:,49),G3(:,:,:,315),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,315),Q(:,127),MT,G4tensor(:,108))
  call loop_AZ_Q(G3(:,:,:,313),wf(:,50),G3(:,:,:,316),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,127),MT,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,313),wf(:,51),G3(:,:,:,317),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,317),Q(:,127),MT,G4tensor(:,110))
  call loop_AZ_Q(G3(:,:,:,313),wf(:,52),G3(:,:,:,318),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,318),Q(:,127),MT,G4tensor(:,111))
  call loop_AZ_Q(G2(:,:,:,302),wf(:,5),G2(:,:,:,304),gZu)
  call loop_A_Q(G2(:,:,:,304),Q(:,92),MT,G3(:,:,:,319))
  call loop_AV_Q(G3(:,:,:,319),wf(:,-5),G3(:,:,:,320))
  call loop_A_Q(G3(:,:,:,320),Q(:,124),MT,G4(:,:,:,135))
  call loop_AZ_Q(G4(:,:,:,135),wf(:,4),G4(:,:,:,136),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,127),MT,G5tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,16),MT,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,9),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,112),MT,G2(:,:,:,305))
  call loop_QS_A(G2(:,:,:,305),wf(:,33),G2(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,127),MT,G3tensor(:,78))
  call loop_QZ_A(G2(:,:,:,305),wf(:,49),G2(:,:,:,307),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,307),Q(:,127),MT,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,305),wf(:,50),G2(:,:,:,308),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,308),Q(:,127),MT,G3tensor(:,80))
  call loop_QZ_A(G2(:,:,:,305),wf(:,51),G2(:,:,:,309),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,309),Q(:,127),MT,G3tensor(:,81))
  call loop_QZ_A(G2(:,:,:,305),wf(:,52),G2(:,:,:,310),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,127),MT,G3tensor(:,82))
  call loop_QZ_A(G1(:,:,:,108),wf(:,5),G1(:,:,:,110),gZu)
  call loop_Q_A(G1(:,:,:,110),Q(:,28),MT,G2(:,:,:,311))
  call loop_QV_A(G2(:,:,:,311),wf(:,9),G2(:,:,:,312))
  call loop_Q_A(G2(:,:,:,312),Q(:,124),MT,G3(:,:,:,321))
  call loop_QZ_A(G3(:,:,:,321),wf(:,4),G3(:,:,:,322),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,127),MT,G4tensor(:,112))
  call loop_QV_A(G2(:,:,:,311),wf(:,-6),G2(:,:,:,313))
  call loop_Q_A(G2(:,:,:,313),Q(:,92),MT,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,-5),G3(:,:,:,324))
  call loop_Q_A(G3(:,:,:,324),Q(:,124),MT,G4(:,:,:,137))
  call loop_QZ_A(G4(:,:,:,137),wf(:,4),G4(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,127),MT,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,311),wf(:,-5),G2(:,:,:,314))
  call loop_Q_A(G2(:,:,:,314),Q(:,60),MT,G3(:,:,:,325))
  call loop_QV_A(G3(:,:,:,325),wf(:,-6),G3(:,:,:,326))
  call loop_Q_A(G3(:,:,:,326),Q(:,124),MT,G4(:,:,:,139))
  call loop_QZ_A(G4(:,:,:,139),wf(:,4),G4(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,127),MT,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,108),wf(:,-5),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,48),MT,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,-6),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,112),MT,G3(:,:,:,327))
  call loop_QS_A(G3(:,:,:,327),wf(:,33),G3(:,:,:,328),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,127),MT,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,327),wf(:,49),G3(:,:,:,329),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,329),Q(:,127),MT,G4tensor(:,114))
  call loop_QZ_A(G3(:,:,:,327),wf(:,50),G3(:,:,:,330),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,330),Q(:,127),MT,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,327),wf(:,51),G3(:,:,:,331),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,331),Q(:,127),MT,G4tensor(:,116))
  call loop_QZ_A(G3(:,:,:,327),wf(:,52),G3(:,:,:,332),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,127),MT,G4tensor(:,117))
  call loop_QZ_A(G2(:,:,:,315),wf(:,5),G2(:,:,:,317),gZu)
  call loop_Q_A(G2(:,:,:,317),Q(:,60),MT,G3(:,:,:,333))
  call loop_QV_A(G3(:,:,:,333),wf(:,-6),G3(:,:,:,334))
  call loop_Q_A(G3(:,:,:,334),Q(:,124),MT,G4(:,:,:,141))
  call loop_QZ_A(G4(:,:,:,141),wf(:,4),G4(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,127),MT,G5tensor(:,71))
  call loop_QV_A(G1(:,:,:,108),wf(:,-6),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,80),MT,G2(:,:,:,318))
  call loop_QV_A(G2(:,:,:,318),wf(:,-5),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,112),MT,G3(:,:,:,335))
  call loop_QS_A(G3(:,:,:,335),wf(:,33),G3(:,:,:,336),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,336),Q(:,127),MT,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,335),wf(:,49),G3(:,:,:,337),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,337),Q(:,127),MT,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,335),wf(:,50),G3(:,:,:,338),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,338),Q(:,127),MT,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,335),wf(:,51),G3(:,:,:,339),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,339),Q(:,127),MT,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,335),wf(:,52),G3(:,:,:,340),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,127),MT,G4tensor(:,122))
  call loop_QZ_A(G2(:,:,:,318),wf(:,5),G2(:,:,:,320),gZu)
  call loop_Q_A(G2(:,:,:,320),Q(:,92),MT,G3(:,:,:,341))
  call loop_QV_A(G3(:,:,:,341),wf(:,-5),G3(:,:,:,342))
  call loop_Q_A(G3(:,:,:,342),Q(:,124),MT,G4(:,:,:,143))
  call loop_QZ_A(G4(:,:,:,143),wf(:,4),G4(:,:,:,144),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,127),MT,G5tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,16),MB,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,9),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,112),MB,G2(:,:,:,321))
  call loop_AS_Q(G2(:,:,:,321),wf(:,33),G2(:,:,:,322),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,322),Q(:,127),MB,G3tensor(:,83))
  call loop_AZ_Q(G2(:,:,:,321),wf(:,49),G2(:,:,:,323),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,323),Q(:,127),MB,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,321),wf(:,50),G2(:,:,:,324),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,324),Q(:,127),MB,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,321),wf(:,51),G2(:,:,:,325),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,325),Q(:,127),MB,G3tensor(:,86))
  call loop_AZ_Q(G2(:,:,:,321),wf(:,52),G2(:,:,:,326),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,326),Q(:,127),MB,G3tensor(:,87))
  call loop_AZ_Q(G1(:,:,:,113),wf(:,5),G1(:,:,:,115),gZd)
  call loop_A_Q(G1(:,:,:,115),Q(:,28),MB,G2(:,:,:,327))
  call loop_AV_Q(G2(:,:,:,327),wf(:,9),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,124),MB,G3(:,:,:,343))
  call loop_AZ_Q(G3(:,:,:,343),wf(:,4),G3(:,:,:,344),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,344),Q(:,127),MB,G4tensor(:,123))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-6),G2(:,:,:,329))
  call loop_A_Q(G2(:,:,:,329),Q(:,92),MB,G3(:,:,:,345))
  call loop_AV_Q(G3(:,:,:,345),wf(:,-5),G3(:,:,:,346))
  call loop_A_Q(G3(:,:,:,346),Q(:,124),MB,G4(:,:,:,145))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,4),G4(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),MB,G5tensor(:,73))
  call loop_AV_Q(G2(:,:,:,327),wf(:,-5),G2(:,:,:,330))
  call loop_A_Q(G2(:,:,:,330),Q(:,60),MB,G3(:,:,:,347))
  call loop_AV_Q(G3(:,:,:,347),wf(:,-6),G3(:,:,:,348))
  call loop_A_Q(G3(:,:,:,348),Q(:,124),MB,G4(:,:,:,147))
  call loop_AZ_Q(G4(:,:,:,147),wf(:,4),G4(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,127),MB,G5tensor(:,74))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,48),MB,G2(:,:,:,331))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-6),G2(:,:,:,332))
  call loop_A_Q(G2(:,:,:,332),Q(:,112),MB,G3(:,:,:,349))
  call loop_AS_Q(G3(:,:,:,349),wf(:,33),G3(:,:,:,350),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,350),Q(:,127),MB,G4tensor(:,124))
  call loop_AZ_Q(G3(:,:,:,349),wf(:,49),G3(:,:,:,351),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,351),Q(:,127),MB,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,349),wf(:,50),G3(:,:,:,352),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,352),Q(:,127),MB,G4tensor(:,126))
  call loop_AZ_Q(G3(:,:,:,349),wf(:,51),G3(:,:,:,353),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,353),Q(:,127),MB,G4tensor(:,127))
  call loop_AZ_Q(G3(:,:,:,349),wf(:,52),G3(:,:,:,354),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,354),Q(:,127),MB,G4tensor(:,128))
  call loop_AZ_Q(G2(:,:,:,331),wf(:,5),G2(:,:,:,333),gZd)
  call loop_A_Q(G2(:,:,:,333),Q(:,60),MB,G3(:,:,:,355))
  call loop_AV_Q(G3(:,:,:,355),wf(:,-6),G3(:,:,:,356))
  call loop_A_Q(G3(:,:,:,356),Q(:,124),MB,G4(:,:,:,149))
  call loop_AZ_Q(G4(:,:,:,149),wf(:,4),G4(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,127),MB,G5tensor(:,75))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-6),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,80),MB,G2(:,:,:,334))
  call loop_AV_Q(G2(:,:,:,334),wf(:,-5),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,112),MB,G3(:,:,:,357))
  call loop_AS_Q(G3(:,:,:,357),wf(:,33),G3(:,:,:,358),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,358),Q(:,127),MB,G4tensor(:,129))
  call loop_AZ_Q(G3(:,:,:,357),wf(:,49),G3(:,:,:,359),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,359),Q(:,127),MB,G4tensor(:,130))
  call loop_AZ_Q(G3(:,:,:,357),wf(:,50),G3(:,:,:,360),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,360),Q(:,127),MB,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,357),wf(:,51),G3(:,:,:,361),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,361),Q(:,127),MB,G4tensor(:,132))
  call loop_AZ_Q(G3(:,:,:,357),wf(:,52),G3(:,:,:,362),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,362),Q(:,127),MB,G4tensor(:,133))
  call loop_AZ_Q(G2(:,:,:,334),wf(:,5),G2(:,:,:,336),gZd)
  call loop_A_Q(G2(:,:,:,336),Q(:,92),MB,G3(:,:,:,363))
  call loop_AV_Q(G3(:,:,:,363),wf(:,-5),G3(:,:,:,364))
  call loop_A_Q(G3(:,:,:,364),Q(:,124),MB,G4(:,:,:,151))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,4),G4(:,:,:,152),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),MB,G5tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,16),MB,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,9),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,112),MB,G2(:,:,:,337))
  call loop_QS_A(G2(:,:,:,337),wf(:,33),G2(:,:,:,338),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,127),MB,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,337),wf(:,49),G2(:,:,:,339),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,339),Q(:,127),MB,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,337),wf(:,50),G2(:,:,:,340),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,340),Q(:,127),MB,G3tensor(:,90))
  call loop_QZ_A(G2(:,:,:,337),wf(:,51),G2(:,:,:,341),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,341),Q(:,127),MB,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,337),wf(:,52),G2(:,:,:,342),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,127),MB,G3tensor(:,92))
  call loop_QZ_A(G1(:,:,:,118),wf(:,5),G1(:,:,:,120),gZd)
  call loop_Q_A(G1(:,:,:,120),Q(:,28),MB,G2(:,:,:,343))
  call loop_QV_A(G2(:,:,:,343),wf(:,9),G2(:,:,:,344))
  call loop_Q_A(G2(:,:,:,344),Q(:,124),MB,G3(:,:,:,365))
  call loop_QZ_A(G3(:,:,:,365),wf(:,4),G3(:,:,:,366),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,366),Q(:,127),MB,G4tensor(:,134))
  call loop_QV_A(G2(:,:,:,343),wf(:,-6),G2(:,:,:,345))
  call loop_Q_A(G2(:,:,:,345),Q(:,92),MB,G3(:,:,:,367))
  call loop_QV_A(G3(:,:,:,367),wf(:,-5),G3(:,:,:,368))
  call loop_Q_A(G3(:,:,:,368),Q(:,124),MB,G4(:,:,:,153))
  call loop_QZ_A(G4(:,:,:,153),wf(:,4),G4(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,154),Q(:,127),MB,G5tensor(:,77))
  call loop_QV_A(G2(:,:,:,343),wf(:,-5),G2(:,:,:,346))
  call loop_Q_A(G2(:,:,:,346),Q(:,60),MB,G3(:,:,:,369))
  call loop_QV_A(G3(:,:,:,369),wf(:,-6),G3(:,:,:,370))
  call loop_Q_A(G3(:,:,:,370),Q(:,124),MB,G4(:,:,:,155))
  call loop_QZ_A(G4(:,:,:,155),wf(:,4),G4(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,156),Q(:,127),MB,G5tensor(:,78))
  call loop_QV_A(G1(:,:,:,118),wf(:,-5),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,48),MB,G2(:,:,:,347))
  call loop_QV_A(G2(:,:,:,347),wf(:,-6),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,112),MB,G3(:,:,:,371))
  call loop_QS_A(G3(:,:,:,371),wf(:,33),G3(:,:,:,372),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,372),Q(:,127),MB,G4tensor(:,135))
  call loop_QZ_A(G3(:,:,:,371),wf(:,49),G3(:,:,:,373),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,373),Q(:,127),MB,G4tensor(:,136))
  call loop_QZ_A(G3(:,:,:,371),wf(:,50),G3(:,:,:,374),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,374),Q(:,127),MB,G4tensor(:,137))
  call loop_QZ_A(G3(:,:,:,371),wf(:,51),G3(:,:,:,375),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,375),Q(:,127),MB,G4tensor(:,138))
  call loop_QZ_A(G3(:,:,:,371),wf(:,52),G3(:,:,:,376),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,376),Q(:,127),MB,G4tensor(:,139))
  call loop_QZ_A(G2(:,:,:,347),wf(:,5),G2(:,:,:,349),gZd)
  call loop_Q_A(G2(:,:,:,349),Q(:,60),MB,G3(:,:,:,377))
  call loop_QV_A(G3(:,:,:,377),wf(:,-6),G3(:,:,:,378))
  call loop_Q_A(G3(:,:,:,378),Q(:,124),MB,G4(:,:,:,157))
  call loop_QZ_A(G4(:,:,:,157),wf(:,4),G4(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,127),MB,G5tensor(:,79))
  call loop_QV_A(G1(:,:,:,118),wf(:,-6),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,80),MB,G2(:,:,:,350))
  call loop_QV_A(G2(:,:,:,350),wf(:,-5),G2(:,:,:,351))
  call loop_Q_A(G2(:,:,:,351),Q(:,112),MB,G3(:,:,:,379))
  call loop_QS_A(G3(:,:,:,379),wf(:,33),G3(:,:,:,380),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,380),Q(:,127),MB,G4tensor(:,140))
  call loop_QZ_A(G3(:,:,:,379),wf(:,49),G3(:,:,:,381),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,381),Q(:,127),MB,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,379),wf(:,50),G3(:,:,:,382),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,382),Q(:,127),MB,G4tensor(:,142))
  call loop_QZ_A(G3(:,:,:,379),wf(:,51),G3(:,:,:,383),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,383),Q(:,127),MB,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,379),wf(:,52),G3(:,:,:,384),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,384),Q(:,127),MB,G4tensor(:,144))
  call loop_QZ_A(G2(:,:,:,350),wf(:,5),G2(:,:,:,352),gZd)
  call loop_Q_A(G2(:,:,:,352),Q(:,92),MB,G3(:,:,:,385))
  call loop_QV_A(G3(:,:,:,385),wf(:,-5),G3(:,:,:,386))
  call loop_Q_A(G3(:,:,:,386),Q(:,124),MB,G4(:,:,:,159))
  call loop_QZ_A(G4(:,:,:,159),wf(:,4),G4(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,127),MB,G5tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,16),ZERO,G1(:,:,:,123))
  call loop_QZ_A(G1(:,:,:,123),wf(:,5),G1(:,:,:,124),gZu)
  call loop_Q_A(G1(:,:,:,124),Q(:,28),ZERO,G2(:,:,:,353))
  call loop_QV_A(G2(:,:,:,353),wf(:,9),G2(:,:,:,354))
  call loop_Q_A(G2(:,:,:,354),Q(:,124),ZERO,G3(:,:,:,387))
  call loop_QZ_A(G3(:,:,:,387),wf(:,4),G3(:,:,:,388),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,388),Q(:,127),ZERO,G4tensor(:,145))
  call loop_QV_A(G2(:,:,:,353),wf(:,-6),G2(:,:,:,355))
  call loop_Q_A(G2(:,:,:,355),Q(:,92),ZERO,G3(:,:,:,389))
  call loop_QV_A(G3(:,:,:,389),wf(:,-5),G3(:,:,:,390))
  call loop_Q_A(G3(:,:,:,390),Q(:,124),ZERO,G4(:,:,:,161))
  call loop_QZ_A(G4(:,:,:,161),wf(:,4),G4(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,162),Q(:,127),ZERO,G5tensor(:,81))
  call loop_QV_A(G2(:,:,:,353),wf(:,-5),G2(:,:,:,356))
  call loop_Q_A(G2(:,:,:,356),Q(:,60),ZERO,G3(:,:,:,391))
  call loop_QV_A(G3(:,:,:,391),wf(:,-6),G3(:,:,:,392))
  call loop_Q_A(G3(:,:,:,392),Q(:,124),ZERO,G4(:,:,:,163))
  call loop_QZ_A(G4(:,:,:,163),wf(:,4),G4(:,:,:,164),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,164),Q(:,127),ZERO,G5tensor(:,82))
  call loop_QZ_A(G1(:,:,:,123),wf(:,5),G1(:,:,:,125),gZd)
  call loop_Q_A(G1(:,:,:,125),Q(:,28),ZERO,G2(:,:,:,357))
  call loop_QV_A(G2(:,:,:,357),wf(:,9),G2(:,:,:,358))
  call loop_Q_A(G2(:,:,:,358),Q(:,124),ZERO,G3(:,:,:,393))
  call loop_QZ_A(G3(:,:,:,393),wf(:,4),G3(:,:,:,394),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,394),Q(:,127),ZERO,G4tensor(:,146))
  call loop_QV_A(G2(:,:,:,357),wf(:,-6),G2(:,:,:,359))
  call loop_Q_A(G2(:,:,:,359),Q(:,92),ZERO,G3(:,:,:,395))
  call loop_QV_A(G3(:,:,:,395),wf(:,-5),G3(:,:,:,396))
  call loop_Q_A(G3(:,:,:,396),Q(:,124),ZERO,G4(:,:,:,165))
  call loop_QZ_A(G4(:,:,:,165),wf(:,4),G4(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,166),Q(:,127),ZERO,G5tensor(:,83))
  call loop_QV_A(G2(:,:,:,357),wf(:,-5),G2(:,:,:,360))
  call loop_Q_A(G2(:,:,:,360),Q(:,60),ZERO,G3(:,:,:,397))
  call loop_QV_A(G3(:,:,:,397),wf(:,-6),G3(:,:,:,398))
  call loop_Q_A(G3(:,:,:,398),Q(:,124),ZERO,G4(:,:,:,167))
  call loop_QZ_A(G4(:,:,:,167),wf(:,4),G4(:,:,:,168),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,168),Q(:,127),ZERO,G5tensor(:,84))
  call loop_QV_A(G1(:,:,:,123),wf(:,-5),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,48),ZERO,G2(:,:,:,361))
  call loop_QZ_A(G2(:,:,:,361),wf(:,5),G2(:,:,:,362),gZu)
  call loop_Q_A(G2(:,:,:,362),Q(:,60),ZERO,G3(:,:,:,399))
  call loop_QV_A(G3(:,:,:,399),wf(:,-6),G3(:,:,:,400))
  call loop_Q_A(G3(:,:,:,400),Q(:,124),ZERO,G4(:,:,:,169))
  call loop_QZ_A(G4(:,:,:,169),wf(:,4),G4(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,127),ZERO,G5tensor(:,85))
  call loop_QZ_A(G2(:,:,:,361),wf(:,5),G2(:,:,:,363),gZd)
  call loop_Q_A(G2(:,:,:,363),Q(:,60),ZERO,G3(:,:,:,401))
  call loop_QV_A(G3(:,:,:,401),wf(:,-6),G3(:,:,:,402))
  call loop_Q_A(G3(:,:,:,402),Q(:,124),ZERO,G4(:,:,:,171))
  call loop_QZ_A(G4(:,:,:,171),wf(:,4),G4(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,172),Q(:,127),ZERO,G5tensor(:,86))
  call loop_QV_A(G2(:,:,:,361),wf(:,-6),G2(:,:,:,364))
  call loop_Q_A(G2(:,:,:,364),Q(:,112),ZERO,G3(:,:,:,403))
  call loop_QZ_A(G3(:,:,:,403),wf(:,49),G3(:,:,:,404),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,404),Q(:,127),ZERO,G4tensor(:,147))
  call loop_QZ_A(G3(:,:,:,403),wf(:,49),G3(:,:,:,405),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,405),Q(:,127),ZERO,G4tensor(:,148))
  call loop_QZ_A(G3(:,:,:,403),wf(:,50),G3(:,:,:,406),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,406),Q(:,127),ZERO,G4tensor(:,149))
  call loop_QZ_A(G3(:,:,:,403),wf(:,50),G3(:,:,:,407),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,407),Q(:,127),ZERO,G4tensor(:,150))
  call loop_QZ_A(G3(:,:,:,403),wf(:,51),G3(:,:,:,408),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,408),Q(:,127),ZERO,G4tensor(:,151))
  call loop_QZ_A(G3(:,:,:,403),wf(:,51),G3(:,:,:,409),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,409),Q(:,127),ZERO,G4tensor(:,152))
  call loop_QZ_A(G3(:,:,:,403),wf(:,52),G3(:,:,:,410),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,410),Q(:,127),ZERO,G4tensor(:,153))
  call loop_QZ_A(G3(:,:,:,403),wf(:,52),G3(:,:,:,411),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,411),Q(:,127),ZERO,G4tensor(:,154))
  call loop_QV_A(G1(:,:,:,123),wf(:,-6),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,80),ZERO,G2(:,:,:,365))
  call loop_QZ_A(G2(:,:,:,365),wf(:,5),G2(:,:,:,366),gZu)
  call loop_Q_A(G2(:,:,:,366),Q(:,92),ZERO,G3(:,:,:,412))
  call loop_QV_A(G3(:,:,:,412),wf(:,-5),G3(:,:,:,413))
  call loop_Q_A(G3(:,:,:,413),Q(:,124),ZERO,G4(:,:,:,173))
  call loop_QZ_A(G4(:,:,:,173),wf(:,4),G4(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,127),ZERO,G5tensor(:,87))
  call loop_QZ_A(G2(:,:,:,365),wf(:,5),G2(:,:,:,367),gZd)
  call loop_Q_A(G2(:,:,:,367),Q(:,92),ZERO,G3(:,:,:,414))
  call loop_QV_A(G3(:,:,:,414),wf(:,-5),G3(:,:,:,415))
  call loop_Q_A(G3(:,:,:,415),Q(:,124),ZERO,G4(:,:,:,175))
  call loop_QZ_A(G4(:,:,:,175),wf(:,4),G4(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,127),ZERO,G5tensor(:,88))
  call loop_QV_A(G2(:,:,:,365),wf(:,-5),G2(:,:,:,368))
  call loop_Q_A(G2(:,:,:,368),Q(:,112),ZERO,G3(:,:,:,416))
  call loop_QZ_A(G3(:,:,:,416),wf(:,49),G3(:,:,:,417),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,417),Q(:,127),ZERO,G4tensor(:,155))
  call loop_QZ_A(G3(:,:,:,416),wf(:,49),G3(:,:,:,418),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,418),Q(:,127),ZERO,G4tensor(:,156))
  call loop_QZ_A(G3(:,:,:,416),wf(:,50),G3(:,:,:,419),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,419),Q(:,127),ZERO,G4tensor(:,157))
  call loop_QZ_A(G3(:,:,:,416),wf(:,50),G3(:,:,:,420),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,420),Q(:,127),ZERO,G4tensor(:,158))
  call loop_QZ_A(G3(:,:,:,416),wf(:,51),G3(:,:,:,421),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,421),Q(:,127),ZERO,G4tensor(:,159))
  call loop_QZ_A(G3(:,:,:,416),wf(:,51),G3(:,:,:,422),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,422),Q(:,127),ZERO,G4tensor(:,160))
  call loop_QZ_A(G3(:,:,:,416),wf(:,52),G3(:,:,:,423),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,423),Q(:,127),ZERO,G4tensor(:,161))
  call loop_QZ_A(G3(:,:,:,416),wf(:,52),G3(:,:,:,424),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,424),Q(:,127),ZERO,G4tensor(:,162))
  call loop_QV_A(G1(:,:,:,123),wf(:,9),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,112),ZERO,G2(:,:,:,369))
  call loop_QZ_A(G2(:,:,:,369),wf(:,49),G2(:,:,:,370),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,370),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,369),wf(:,49),G2(:,:,:,371),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,371),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,369),wf(:,50),G2(:,:,:,372),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,372),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QZ_A(G2(:,:,:,369),wf(:,50),G2(:,:,:,373),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,373),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QZ_A(G2(:,:,:,369),wf(:,51),G2(:,:,:,374),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,374),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,369),wf(:,51),G2(:,:,:,375),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,375),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QZ_A(G2(:,:,:,369),wf(:,52),G2(:,:,:,376),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,376),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,369),wf(:,52),G2(:,:,:,377),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,377),Q(:,127),ZERO,G3tensor(:,100))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,16),ZERO,G1(:,:,:,129))
  call loop_AZ_Q(G1(:,:,:,129),wf(:,5),G1(:,:,:,130),gZu)
  call loop_A_Q(G1(:,:,:,130),Q(:,28),ZERO,G2(:,:,:,378))
  call loop_AV_Q(G2(:,:,:,378),wf(:,9),G2(:,:,:,379))
  call loop_A_Q(G2(:,:,:,379),Q(:,124),ZERO,G3(:,:,:,425))
  call loop_AZ_Q(G3(:,:,:,425),wf(:,4),G3(:,:,:,426),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,426),Q(:,127),ZERO,G4tensor(:,163))
  call loop_AV_Q(G2(:,:,:,378),wf(:,-6),G2(:,:,:,380))
  call loop_A_Q(G2(:,:,:,380),Q(:,92),ZERO,G3(:,:,:,427))
  call loop_AV_Q(G3(:,:,:,427),wf(:,-5),G3(:,:,:,428))
  call loop_A_Q(G3(:,:,:,428),Q(:,124),ZERO,G4(:,:,:,177))
  call loop_AZ_Q(G4(:,:,:,177),wf(:,4),G4(:,:,:,178),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,178),Q(:,127),ZERO,G5tensor(:,89))
  call loop_AV_Q(G2(:,:,:,378),wf(:,-5),G2(:,:,:,381))
  call loop_A_Q(G2(:,:,:,381),Q(:,60),ZERO,G3(:,:,:,429))
  call loop_AV_Q(G3(:,:,:,429),wf(:,-6),G3(:,:,:,430))
  call loop_A_Q(G3(:,:,:,430),Q(:,124),ZERO,G4(:,:,:,179))
  call loop_AZ_Q(G4(:,:,:,179),wf(:,4),G4(:,:,:,180),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,180),Q(:,127),ZERO,G5tensor(:,90))
  call loop_AZ_Q(G1(:,:,:,129),wf(:,5),G1(:,:,:,131),gZd)
  call loop_A_Q(G1(:,:,:,131),Q(:,28),ZERO,G2(:,:,:,382))
  call loop_AV_Q(G2(:,:,:,382),wf(:,9),G2(:,:,:,383))
  call loop_A_Q(G2(:,:,:,383),Q(:,124),ZERO,G3(:,:,:,431))
  call loop_AZ_Q(G3(:,:,:,431),wf(:,4),G3(:,:,:,432),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,432),Q(:,127),ZERO,G4tensor(:,164))
  call loop_AV_Q(G2(:,:,:,382),wf(:,-6),G2(:,:,:,384))
  call loop_A_Q(G2(:,:,:,384),Q(:,92),ZERO,G3(:,:,:,433))
  call loop_AV_Q(G3(:,:,:,433),wf(:,-5),G3(:,:,:,434))
  call loop_A_Q(G3(:,:,:,434),Q(:,124),ZERO,G4(:,:,:,181))
  call loop_AZ_Q(G4(:,:,:,181),wf(:,4),G4(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,182),Q(:,127),ZERO,G5tensor(:,91))
  call loop_AV_Q(G2(:,:,:,382),wf(:,-5),G2(:,:,:,385))
  call loop_A_Q(G2(:,:,:,385),Q(:,60),ZERO,G3(:,:,:,435))
  call loop_AV_Q(G3(:,:,:,435),wf(:,-6),G3(:,:,:,436))
  call loop_A_Q(G3(:,:,:,436),Q(:,124),ZERO,G4(:,:,:,183))
  call loop_AZ_Q(G4(:,:,:,183),wf(:,4),G4(:,:,:,184),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,184),Q(:,127),ZERO,G5tensor(:,92))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-5),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,48),ZERO,G2(:,:,:,386))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,5),G2(:,:,:,387),gZu)
  call loop_A_Q(G2(:,:,:,387),Q(:,60),ZERO,G3(:,:,:,437))
  call loop_AV_Q(G3(:,:,:,437),wf(:,-6),G3(:,:,:,438))
  call loop_A_Q(G3(:,:,:,438),Q(:,124),ZERO,G4(:,:,:,185))
  call loop_AZ_Q(G4(:,:,:,185),wf(:,4),G4(:,:,:,186),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,186),Q(:,127),ZERO,G5tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,5),G2(:,:,:,388),gZd)
  call loop_A_Q(G2(:,:,:,388),Q(:,60),ZERO,G3(:,:,:,439))
  call loop_AV_Q(G3(:,:,:,439),wf(:,-6),G3(:,:,:,440))
  call loop_A_Q(G3(:,:,:,440),Q(:,124),ZERO,G4(:,:,:,187))
  call loop_AZ_Q(G4(:,:,:,187),wf(:,4),G4(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,188),Q(:,127),ZERO,G5tensor(:,94))
  call loop_AV_Q(G2(:,:,:,386),wf(:,-6),G2(:,:,:,389))
  call loop_A_Q(G2(:,:,:,389),Q(:,112),ZERO,G3(:,:,:,441))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,49),G3(:,:,:,442),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,442),Q(:,127),ZERO,G4tensor(:,165))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,49),G3(:,:,:,443),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,443),Q(:,127),ZERO,G4tensor(:,166))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,50),G3(:,:,:,444),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,444),Q(:,127),ZERO,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,50),G3(:,:,:,445),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,445),Q(:,127),ZERO,G4tensor(:,168))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,51),G3(:,:,:,446),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,446),Q(:,127),ZERO,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,51),G3(:,:,:,447),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,447),Q(:,127),ZERO,G4tensor(:,170))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,52),G3(:,:,:,448),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,448),Q(:,127),ZERO,G4tensor(:,171))
  call loop_AZ_Q(G3(:,:,:,441),wf(:,52),G3(:,:,:,449),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,449),Q(:,127),ZERO,G4tensor(:,172))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-6),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,80),ZERO,G2(:,:,:,390))
  call loop_AZ_Q(G2(:,:,:,390),wf(:,5),G2(:,:,:,391),gZu)
  call loop_A_Q(G2(:,:,:,391),Q(:,92),ZERO,G3(:,:,:,450))
  call loop_AV_Q(G3(:,:,:,450),wf(:,-5),G3(:,:,:,451))
  call loop_A_Q(G3(:,:,:,451),Q(:,124),ZERO,G4(:,:,:,189))
  call loop_AZ_Q(G4(:,:,:,189),wf(:,4),G4(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,190),Q(:,127),ZERO,G5tensor(:,95))
  call loop_AZ_Q(G2(:,:,:,390),wf(:,5),G2(:,:,:,392),gZd)
  call loop_A_Q(G2(:,:,:,392),Q(:,92),ZERO,G3(:,:,:,452))
  call loop_AV_Q(G3(:,:,:,452),wf(:,-5),G3(:,:,:,453))
  call loop_A_Q(G3(:,:,:,453),Q(:,124),ZERO,G4(:,:,:,191))
  call loop_AZ_Q(G4(:,:,:,191),wf(:,4),G4(:,:,:,192),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,192),Q(:,127),ZERO,G5tensor(:,96))
  call loop_AV_Q(G2(:,:,:,390),wf(:,-5),G2(:,:,:,393))
  call loop_A_Q(G2(:,:,:,393),Q(:,112),ZERO,G3(:,:,:,454))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,49),G3(:,:,:,455),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,455),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,49),G3(:,:,:,456),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,456),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,50),G3(:,:,:,457),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,457),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,50),G3(:,:,:,458),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,458),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,51),G3(:,:,:,459),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,459),Q(:,127),ZERO,G4tensor(:,177))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,51),G3(:,:,:,460),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,460),Q(:,127),ZERO,G4tensor(:,178))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,52),G3(:,:,:,461),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,461),Q(:,127),ZERO,G4tensor(:,179))
  call loop_AZ_Q(G3(:,:,:,454),wf(:,52),G3(:,:,:,462),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,462),Q(:,127),ZERO,G4tensor(:,180))
  call loop_AV_Q(G1(:,:,:,129),wf(:,9),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,112),ZERO,G2(:,:,:,394))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,49),G2(:,:,:,395),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,395),Q(:,127),ZERO,G3tensor(:,101))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,49),G2(:,:,:,396),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,396),Q(:,127),ZERO,G3tensor(:,102))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,50),G2(:,:,:,397),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,397),Q(:,127),ZERO,G3tensor(:,103))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,50),G2(:,:,:,398),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,398),Q(:,127),ZERO,G3tensor(:,104))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,51),G2(:,:,:,399),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,399),Q(:,127),ZERO,G3tensor(:,105))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,51),G2(:,:,:,400),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,400),Q(:,127),ZERO,G3tensor(:,106))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,52),G2(:,:,:,401),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,401),Q(:,127),ZERO,G3tensor(:,107))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,52),G2(:,:,:,402),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,402),Q(:,127),ZERO,G3tensor(:,108))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(11)) * den(25)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(25)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(11)) * den(25)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(25)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(9)) * den(25)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(9) * den(25)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(9)) * den(25)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(9) * den(25)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,7),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,6),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,6),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,4),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,4),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,8),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,8),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,3),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,3),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,15),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,15),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,21),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,21),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,27),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,27),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,39),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,39),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,45),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,45),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,51),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,51),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,22),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,22),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,28),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,28),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,10),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,10),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,16),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,16),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,46),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,46),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,52),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,52),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(6) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(6)) * den(52)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(5) * den(52)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,40),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(5)) * den(52)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,40),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(11) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(11) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(26)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(9) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(9) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(26)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,81),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,81),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,63),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,63),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,91),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,91),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,57),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,57),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,82),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,82),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,75),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,75),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,92),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,92),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,69),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,69),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,11),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,11),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,17),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,17),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,23),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,23),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,29),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,29),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,35),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,35),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,41),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,41),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,47),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,47),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,53),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,53),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,24),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,24),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,30),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,30),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,12),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,12),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,18),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,18),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,48),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,48),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,54),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,54),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(6)) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,36),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(6) * den(53)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,36),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,42),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(5) * den(53)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,42),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(11)) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,73),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,73),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,78),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(27)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,78),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(9)) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,145),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,145),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,112),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,112),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,163),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,163),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,101),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,101),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,146),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,146),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,134),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,134),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,164),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,164),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,123),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,123),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,13),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,13),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,19),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,19),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,25),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,25),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,31),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,31),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,37),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,37),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,43),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,43),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,49),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,49),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,55),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,55),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,26),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,26),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,32),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,32),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,14),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,14),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,20),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,20),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,50),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,50),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,56),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,56),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(6) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,38),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(6)) * den(54)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,38),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(5) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,44),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(5)) * den(54)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,44),T4sum(1:70,27))
  M(1) = M(1) + (f(12) * den(24)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,64),T4sum(1:70,28))
  M(2) = M(2) + (f(12) * den(24)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,58),T4sum(1:70,28))
  M(1) = M(1) + (f(10) * den(24)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,76),T4sum(1:70,29))
  M(2) = M(2) + (f(10) * den(24)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,70),T4sum(1:70,29))
  M(1) = M(1) + (f(12) * den(24)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,102),T4sum(1:70,30))
  M(2) = M(2) + (f(12) * den(24)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,113),T4sum(1:70,30))
  M(1) = M(1) + (f(10) * den(24)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,124),T4sum(1:70,31))
  M(2) = M(2) + (f(10) * den(24)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,135),T4sum(1:70,31))
  M(2) = M(2) + (f(12) * den(24)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,107),T4sum(1:70,32))
  M(1) = M(1) + (f(12) * den(24)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,118),T4sum(1:70,32))
  M(2) = M(2) + (f(10) * den(24)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,129),T4sum(1:70,33))
  M(1) = M(1) + (f(10) * den(24)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,140),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,7),T5sum(1:126,2))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,13),T5sum(1:126,1))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,19),T5sum(1:126,2))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,25),T5sum(1:126,1))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,31),T5sum(1:126,3))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,37),T5sum(1:126,1))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,43),T5sum(1:126,3))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,15),T5sum(1:126,4))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,21),T5sum(1:126,5))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,3),T5sum(1:126,4))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,9),T5sum(1:126,5))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,39),T5sum(1:126,4))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,45),T5sum(1:126,6))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,27),T5sum(1:126,4))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,33),T5sum(1:126,6))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,14),T5sum(1:126,7))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,20),T5sum(1:126,8))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,2),T5sum(1:126,7))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,38),T5sum(1:126,7))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,44),T5sum(1:126,9))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,26),T5sum(1:126,7))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,32),T5sum(1:126,9))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,93),T5sum(1:126,10))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,67),T5sum(1:126,11))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,85),T5sum(1:126,10))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,71),T5sum(1:126,11))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,94),T5sum(1:126,10))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,75),T5sum(1:126,12))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,86),T5sum(1:126,10))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,79),T5sum(1:126,12))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,5),T5sum(1:126,13))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,11),T5sum(1:126,14))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,17),T5sum(1:126,13))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,23),T5sum(1:126,14))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,29),T5sum(1:126,13))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,35),T5sum(1:126,15))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,41),T5sum(1:126,13))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,47),T5sum(1:126,15))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,59),T5sum(1:126,16))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,52),T5sum(1:126,17))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,63),T5sum(1:126,16))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,50),T5sum(1:126,17))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,60),T5sum(1:126,16))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,56),T5sum(1:126,18))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,64),T5sum(1:126,16))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,54),T5sum(1:126,18))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,16),T5sum(1:126,19))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,22),T5sum(1:126,20))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,4),T5sum(1:126,19))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,10),T5sum(1:126,20))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,40),T5sum(1:126,19))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,46),T5sum(1:126,21))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,28),T5sum(1:126,19))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,34),T5sum(1:126,21))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,95),T5sum(1:126,22))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,68),T5sum(1:126,23))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,87),T5sum(1:126,22))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,72),T5sum(1:126,23))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,96),T5sum(1:126,22))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,76),T5sum(1:126,24))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,88),T5sum(1:126,22))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,80),T5sum(1:126,24))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,6),T5sum(1:126,25))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,12),T5sum(1:126,26))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,18),T5sum(1:126,25))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,24),T5sum(1:126,26))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,30),T5sum(1:126,25))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,36),T5sum(1:126,27))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,42),T5sum(1:126,25))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,48),T5sum(1:126,27))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,61),T5sum(1:126,28))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,49),T5sum(1:126,29))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,57),T5sum(1:126,28))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,51),T5sum(1:126,29))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,62),T5sum(1:126,28))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,53),T5sum(1:126,30))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,58),T5sum(1:126,28))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,55),T5sum(1:126,30))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,81),T5sum(1:126,31))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,69),T5sum(1:126,32))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,89),T5sum(1:126,31))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,65),T5sum(1:126,32))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,83),T5sum(1:126,31))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,77),T5sum(1:126,33))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,91),T5sum(1:126,31))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,73),T5sum(1:126,33))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,82),T5sum(1:126,34))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,70),T5sum(1:126,35))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,90),T5sum(1:126,34))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,66),T5sum(1:126,35))
  M(2) = M(2) + (-f(8) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,84),T5sum(1:126,34))
  M(2) = M(2) + (-f(7) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,78),T5sum(1:126,36))
  M(1) = M(1) + (-f(8) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,92),T5sum(1:126,34))
  M(1) = M(1) + (-f(7) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,74),T5sum(1:126,36))
  M(1) = M(1) + (CI*f(6) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(55)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(55)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,29),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(55)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(55)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,22),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,22),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(55)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(55)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,30),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(55)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,30),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(55)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(55)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,23),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,23),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,31),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,31),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,24),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,24),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,32),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(56)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,32),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,57),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,57),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,65),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,65),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(57)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,58),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,58),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,66),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(57)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,66),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(57)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,59),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,59),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(58)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(58)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,67),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,67),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(58)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(58)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,60),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,60),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(58)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(58)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,68),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(58)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,68),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(58)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(58)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,93),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,93),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,101),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,101),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,74),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(59)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,74),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,94),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,94),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,95),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,95),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,103),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,103),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,75),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(60)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,75),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,96),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,96),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,104),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(60)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,104),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(60)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,83),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,65),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,93),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,59),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,84),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,77),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,94),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,71),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,165),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,103),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,147),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,114),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,166),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,125),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,148),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,136),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,173),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,108),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,155),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,119),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(48)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,174),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(48)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,130),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(48)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,156),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(48)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,141),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,85),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,66),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,95),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,60),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,86),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,78),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,96),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,72),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,167),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,104),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,149),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,115),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,168),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,126),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,150),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,137),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,175),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,109),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,157),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,120),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(49)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,176),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(49)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,131),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(49)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,158),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(49)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,142),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(6) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,25),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,25),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(61)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(61)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,33),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,33),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(61)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(61)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,26),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,26),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(61)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(61)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(61)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,34),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(61)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(61)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,27),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,27),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(62)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(62)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,35),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,35),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(62)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(62)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,28),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,28),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(62)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(62)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,36),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(62)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,36),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(62)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(62)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,61),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,61),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(63)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,62),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,62),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(63)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(63)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,63),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,63),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(64)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(64)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(64)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(64)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,64),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,64),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(64)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(64)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(64)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(64)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(64)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,97),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,97),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,105),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,105),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,76),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(65)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,76),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,98),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,98),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,106),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(65)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,106),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(65)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,99),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,99),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,107),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,107),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,77),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,77),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,100),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,100),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,108),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(66)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,108),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,87),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,67),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,97),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,61),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,88),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,79),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,98),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,73),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,169),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,105),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,151),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,116),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,170),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,127),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,152),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,138),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,177),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,110),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,159),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,121),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(50)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,178),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(50)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,132),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(50)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,160),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(50)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,143),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,89),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,68),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,99),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,62),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,90),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,80),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,100),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,74),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,171),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,106),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,153),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,117),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,172),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,128),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,154),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,139),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,179),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,111),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,161),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,122),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(51)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,180),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(51)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,133),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(51)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,162),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(51)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,144),T4sum(1:70,33))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nenexnmnmxggg_1_/**/REALKIND
