
module ol_vamp_1_ppllllj2_nenexeexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenexeexuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenexeexuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenexeexuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenexeexuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,25) :: G0
  complex(REALKIND), dimension(4,5,4,84) :: G1
  complex(REALKIND), dimension(4,15,4,224) :: G2
  complex(REALKIND), dimension(4,35,4,114) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,110,128))
    allocate(G4tensorhel(70,60,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,14),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,65),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,66),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,67),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,68),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QS_A(G2(:,:,:,1),wf(:,44),G2(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,45),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,46),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,1),wf(:,69),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,1),wf(:,70),G2(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,1),wf(:,71),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,1),wf(:,72),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,1),wf(:,73),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,1),wf(:,76),G2(:,:,:,17),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,-6),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,124),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,7),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,-6),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,124),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,4),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,22))
  call loop_AS_Q(G2(:,:,:,22),wf(:,14),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,22),wf(:,65),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,66),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,22),wf(:,67),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,68),G2(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,21))
  call loop_AS_Q(G2(:,:,:,22),wf(:,44),G2(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,22),wf(:,45),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,46),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,22),wf(:,69),G2(:,:,:,31))
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,70),G2(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,71),G2(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,22),wf(:,72),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,73),G2(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,74),G2(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MT,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,75),G2(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MT,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,76),G2(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MT,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-6),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,124),MT,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,7),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-6),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,124),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,4))
  call loop_AW_Q(G1(:,:,:,5),wf(:,11),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,57),MB,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-6),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,121),MB,G3(:,:,:,9))
  call loop_AW_Q(G3(:,:,:,9),wf(:,12),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),MT,G4tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-6),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,112),MB,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,14),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),MB,G3tensor(:,33))
  call loop_QV_A(G2(:,:,:,45),wf(:,65),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,45),wf(:,66),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,45),wf(:,67),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,45),wf(:,68),G2(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,37))
  call loop_QS_A(G2(:,:,:,45),wf(:,44),G2(:,:,:,51),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,38))
  call loop_QV_A(G2(:,:,:,45),wf(:,45),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,45),wf(:,46),G2(:,:,:,53),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,40))
  call loop_QV_A(G2(:,:,:,45),wf(:,69),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,41))
  call loop_QZ_A(G2(:,:,:,45),wf(:,70),G2(:,:,:,55),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,71),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,43))
  call loop_QV_A(G2(:,:,:,45),wf(:,72),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,45),wf(:,73),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,45),wf(:,74),G2(:,:,:,59),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,75),G2(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,45),wf(:,76),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,10),wf(:,2),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-6),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,124),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,6))
  call loop_QZ_A(G1(:,:,:,10),wf(:,7),G1(:,:,:,13),gZd)
  call loop_Q_A(G1(:,:,:,13),Q(:,60),MB,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,-6),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,124),MB,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_QW_A(G1(:,:,:,10),wf(:,11),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,57),MT,G2(:,:,:,66))
  call loop_QV_A(G2(:,:,:,66),wf(:,-6),G2(:,:,:,67))
  call loop_Q_A(G2(:,:,:,67),Q(:,121),MT,G3(:,:,:,15))
  call loop_QW_A(G3(:,:,:,15),wf(:,12),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-6),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,112),MB,G2(:,:,:,68))
  call loop_AS_Q(G2(:,:,:,68),wf(:,14),G2(:,:,:,69),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),MB,G3tensor(:,49))
  call loop_AV_Q(G2(:,:,:,68),wf(:,65),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),MB,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,66),G2(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),MB,G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,68),wf(:,67),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),MB,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,68),G2(:,:,:,73),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),MB,G3tensor(:,53))
  call loop_AS_Q(G2(:,:,:,68),wf(:,44),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MB,G3tensor(:,54))
  call loop_AV_Q(G2(:,:,:,68),wf(:,45),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,46),G2(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,56))
  call loop_AV_Q(G2(:,:,:,68),wf(:,69),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,70),G2(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,71),G2(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,59))
  call loop_AV_Q(G2(:,:,:,68),wf(:,72),G2(:,:,:,80))
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,73),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,74),G2(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),MB,G3tensor(:,62))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,75),G2(:,:,:,83),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,76),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,15),wf(:,2),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,60),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),MB,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,7),G1(:,:,:,18),gZd)
  call loop_A_Q(G1(:,:,:,18),Q(:,60),MB,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,124),MB,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,2),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,60),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-6),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,21),gZu)
  call loop_A_Q(G1(:,:,:,21),Q(:,60),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-6),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),ZERO,G3(:,:,:,24))
  call loop_AZ_Q(G3(:,:,:,24),wf(:,4),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,60),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,124),ZERO,G3(:,:,:,26))
  call loop_AZ_Q(G3(:,:,:,26),wf(:,4),G3(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-6),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,112),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,65),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,66),G2(:,:,:,97),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,66),G2(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,67))
  call loop_AV_Q(G2(:,:,:,95),wf(:,67),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,68))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,68),G2(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,68),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AV_Q(G2(:,:,:,95),wf(:,45),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,46),G2(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,46),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,95),wf(:,69),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,70),G2(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,70),G2(:,:,:,107),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,127),ZERO,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,71),G2(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,127),ZERO,G3tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,71),G2(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,127),ZERO,G3tensor(:,78))
  call loop_AV_Q(G2(:,:,:,95),wf(:,72),G2(:,:,:,110))
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,127),ZERO,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,73),G2(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,127),ZERO,G3tensor(:,80))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,73),G2(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,127),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,74),G2(:,:,:,113),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,127),ZERO,G3tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,74),G2(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,127),ZERO,G3tensor(:,83))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,115),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,127),ZERO,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,127),ZERO,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,76),G2(:,:,:,117),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,86))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,76),G2(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,127),ZERO,G3tensor(:,87))
  call loop_AW_Q(G1(:,:,:,19),wf(:,11),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,57),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-6),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,121),ZERO,G3(:,:,:,28))
  call loop_AW_Q(G3(:,:,:,28),wf(:,12),G3(:,:,:,29))
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),ZERO,G4tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,2),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,60),ZERO,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,-6),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,124),ZERO,G3(:,:,:,30))
  call loop_QZ_A(G3(:,:,:,30),wf(:,4),G3(:,:,:,31),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,16))
  call loop_QZ_A(G3(:,:,:,30),wf(:,4),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,17))
  call loop_QZ_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,27),gZu)
  call loop_Q_A(G1(:,:,:,27),Q(:,60),ZERO,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,-6),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,124),ZERO,G3(:,:,:,33))
  call loop_QZ_A(G3(:,:,:,33),wf(:,4),G3(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,18))
  call loop_QZ_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,60),ZERO,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-6),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,124),ZERO,G3(:,:,:,35))
  call loop_QZ_A(G3(:,:,:,35),wf(:,4),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,25),wf(:,-6),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,112),ZERO,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,65),G2(:,:,:,128))
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,127),wf(:,66),G2(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,127),wf(:,66),G2(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,90))
  call loop_QV_A(G2(:,:,:,127),wf(:,67),G2(:,:,:,131))
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,127),wf(:,68),G2(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,92))
  call loop_QZ_A(G2(:,:,:,127),wf(:,68),G2(:,:,:,133),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QV_A(G2(:,:,:,127),wf(:,45),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,127),wf(:,46),G2(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QZ_A(G2(:,:,:,127),wf(:,46),G2(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QV_A(G2(:,:,:,127),wf(:,69),G2(:,:,:,137))
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,127),wf(:,70),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QZ_A(G2(:,:,:,127),wf(:,70),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,127),wf(:,71),G2(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,127),wf(:,71),G2(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,127),wf(:,72),G2(:,:,:,142))
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,102))
  call loop_QZ_A(G2(:,:,:,127),wf(:,73),G2(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,127),wf(:,73),G2(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,127),wf(:,74),G2(:,:,:,145),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,105))
  call loop_QZ_A(G2(:,:,:,127),wf(:,74),G2(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,127),wf(:,75),G2(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,107))
  call loop_QZ_A(G2(:,:,:,127),wf(:,75),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,127),wf(:,76),G2(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,127),wf(:,76),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,110))
  call loop_QW_A(G1(:,:,:,25),wf(:,11),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,57),ZERO,G2(:,:,:,151))
  call loop_QV_A(G2(:,:,:,151),wf(:,-6),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,121),ZERO,G3(:,:,:,37))
  call loop_QW_A(G3(:,:,:,37),wf(:,12),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,60),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-6),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,124),ZERO,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-6),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,76),ZERO,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,3),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,124),ZERO,G3(:,:,:,42))
  call loop_AZ_Q(G3(:,:,:,42),wf(:,4),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,42),wf(:,4),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,3),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,60),MT,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-6),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,124),MT,G3(:,:,:,45))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,4),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),MT,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-6),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,76),MT,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,3),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,124),MT,G3(:,:,:,47))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,4),G3(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,3),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,60),ZERO,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,-6),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,124),ZERO,G3(:,:,:,49))
  call loop_QZ_A(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,49),wf(:,4),G3(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,28))
  call loop_QV_A(G1(:,:,:,37),wf(:,-6),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,76),ZERO,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,3),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,124),ZERO,G3(:,:,:,52))
  call loop_QZ_A(G3(:,:,:,52),wf(:,4),G3(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,53),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,52),wf(:,4),G3(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,3),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,60),MT,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,-6),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,124),MT,G3(:,:,:,55))
  call loop_QZ_A(G3(:,:,:,55),wf(:,4),G3(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,127),MT,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,40),wf(:,-6),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,76),MT,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,3),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,124),MT,G3(:,:,:,57))
  call loop_QZ_A(G3(:,:,:,57),wf(:,4),G3(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MB,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,3),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,60),MB,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,124),MB,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MB,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-6),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,76),MB,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,3),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,124),MB,G3(:,:,:,61))
  call loop_AZ_Q(G3(:,:,:,61),wf(:,4),G3(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),MB,G4tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,3),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,60),MB,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,-6),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,124),MB,G3(:,:,:,63))
  call loop_QZ_A(G3(:,:,:,63),wf(:,4),G3(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,127),MB,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,46),wf(:,-6),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,76),MB,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,3),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,124),MB,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,4),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),MB,G4tensor(:,36))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,60),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-6),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,124),ZERO,G3(:,:,:,67))
  call loop_AZ_Q(G3(:,:,:,67),wf(:,4),G3(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-6),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,76),ZERO,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,3),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,124),ZERO,G3(:,:,:,69))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,4),G3(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,3),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,60),MT,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-6),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,124),MT,G3(:,:,:,71))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,4),G3(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-6),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,76),MT,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,3),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,124),MT,G3(:,:,:,73))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,4),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,40))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,3),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,60),ZERO,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-6),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,124),ZERO,G3(:,:,:,75))
  call loop_QZ_A(G3(:,:,:,75),wf(:,4),G3(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,41))
  call loop_QV_A(G1(:,:,:,55),wf(:,-6),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,76),ZERO,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,3),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,124),ZERO,G3(:,:,:,77))
  call loop_QZ_A(G3(:,:,:,77),wf(:,4),G3(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,127),ZERO,G4tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,3),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,60),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-6),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,124),MT,G3(:,:,:,79))
  call loop_QZ_A(G3(:,:,:,79),wf(:,4),G3(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,43))
  call loop_QV_A(G1(:,:,:,58),wf(:,-6),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,76),MT,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,3),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,124),MT,G3(:,:,:,81))
  call loop_QZ_A(G3(:,:,:,81),wf(:,4),G3(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),MT,G4tensor(:,44))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,3),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,60),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-6),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,124),ZERO,G3(:,:,:,83))
  call loop_AZ_Q(G3(:,:,:,83),wf(:,4),G3(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-6),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,76),ZERO,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,3),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,124),ZERO,G3(:,:,:,85))
  call loop_AZ_Q(G3(:,:,:,85),wf(:,4),G3(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,3),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,60),MB,G2(:,:,:,197))
  call loop_AV_Q(G2(:,:,:,197),wf(:,-6),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,124),MB,G3(:,:,:,87))
  call loop_AZ_Q(G3(:,:,:,87),wf(:,4),G3(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,127),MB,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-6),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,76),MB,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,3),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,124),MB,G3(:,:,:,89))
  call loop_AZ_Q(G3(:,:,:,89),wf(:,4),G3(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),MB,G4tensor(:,48))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,12),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,3),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,60),ZERO,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-6),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,124),ZERO,G3(:,:,:,91))
  call loop_QZ_A(G3(:,:,:,91),wf(:,4),G3(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,49))
  call loop_QV_A(G1(:,:,:,67),wf(:,-6),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,76),ZERO,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,3),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,124),ZERO,G3(:,:,:,93))
  call loop_QZ_A(G3(:,:,:,93),wf(:,4),G3(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),ZERO,G4tensor(:,50))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,12),MB,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,3),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,60),MB,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-6),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,124),MB,G3(:,:,:,95))
  call loop_QZ_A(G3(:,:,:,95),wf(:,4),G3(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,51))
  call loop_QV_A(G1(:,:,:,70),wf(:,-6),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,76),MB,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,3),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,124),MB,G3(:,:,:,97))
  call loop_QZ_A(G3(:,:,:,97),wf(:,4),G3(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),MB,G4tensor(:,52))
  call loop_QW_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,9),ZERO,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,-6),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,73),ZERO,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,3),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,121),ZERO,G3(:,:,:,99))
  call loop_QW_A(G3(:,:,:,99),wf(:,12),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),ZERO,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,73),wf(:,3),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,57),ZERO,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-6),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,121),ZERO,G3(:,:,:,101))
  call loop_QW_A(G3(:,:,:,101),wf(:,12),G3(:,:,:,102))
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),ZERO,G4tensor(:,54))
  call loop_QW_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,9),MT,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,-6),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,73),MT,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,3),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,121),MT,G3(:,:,:,103))
  call loop_QW_A(G3(:,:,:,103),wf(:,12),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),MB,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,76),wf(:,3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,57),MT,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,-6),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,121),MT,G3(:,:,:,105))
  call loop_QW_A(G3(:,:,:,105),wf(:,12),G3(:,:,:,106))
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),MB,G4tensor(:,56))
  call loop_AW_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,9),ZERO,G1(:,:,:,79))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-6),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,73),ZERO,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,3),G2(:,:,:,218))
  call loop_A_Q(G2(:,:,:,218),Q(:,121),ZERO,G3(:,:,:,107))
  call loop_AW_Q(G3(:,:,:,107),wf(:,12),G3(:,:,:,108))
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,127),ZERO,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,79),wf(:,3),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,57),ZERO,G2(:,:,:,219))
  call loop_AV_Q(G2(:,:,:,219),wf(:,-6),G2(:,:,:,220))
  call loop_A_Q(G2(:,:,:,220),Q(:,121),ZERO,G3(:,:,:,109))
  call loop_AW_Q(G3(:,:,:,109),wf(:,12),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),ZERO,G4tensor(:,58))
  call loop_AW_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,9),MB,G1(:,:,:,82))
  call loop_AV_Q(G1(:,:,:,82),wf(:,-6),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,73),MB,G2(:,:,:,221))
  call loop_AV_Q(G2(:,:,:,221),wf(:,3),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,121),MB,G3(:,:,:,111))
  call loop_AW_Q(G3(:,:,:,111),wf(:,12),G3(:,:,:,112))
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,127),MT,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,82),wf(:,3),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,57),MB,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-6),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,121),MB,G3(:,:,:,113))
  call loop_AW_Q(G3(:,:,:,113),wf(:,12),G3(:,:,:,114))
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),MT,G4tensor(:,60))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(27)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(27)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(26)/2._/**/REALKIND * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,16),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,12),T4sum(1:70,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,18),T4sum(1:70,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_9,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,14),T4sum(1:70,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,21),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_4,masses2_9,G4tensor(:,25),T4sum(1:70,5))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,27),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_4,masses2_9,G4tensor(:,31),T4sum(1:70,5))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,22),T4sum(1:70,4))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,33),T4sum(1:70,6))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,28),T4sum(1:70,4))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,35),T4sum(1:70,6))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,37),T4sum(1:70,4))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_9,G4tensor(:,39),T4sum(1:70,5))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_9,G4tensor(:,43),T4sum(1:70,5))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,45),T4sum(1:70,4))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,49),T4sum(1:70,4))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,51),T4sum(1:70,6))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,29),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_5,masses2_9,G4tensor(:,32),T4sum(1:70,8))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(77)) * TI2_call(4,momenta_5,masses2_9,G4tensor(:,26),T4sum(1:70,8))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,30),T4sum(1:70,7))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,36),T4sum(1:70,9))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,24),T4sum(1:70,7))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(77)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,34),T4sum(1:70,9))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,42),T4sum(1:70,7))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_9,G4tensor(:,44),T4sum(1:70,8))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,38),T4sum(1:70,7))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_9,G4tensor(:,40),T4sum(1:70,8))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,50),T4sum(1:70,7))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,52),T4sum(1:70,9))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,46),T4sum(1:70,7))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(78)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,48),T4sum(1:70,9))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,65),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,65),T3sum(1:35,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,66),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,89),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,67),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,90),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,68),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,91),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,68),T3sum(1:35,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,91),T3sum(1:35,3))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,92),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,70),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,93),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(18)/2._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(45)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(1) = M(1) + (f(24)/2._/**/REALKIND * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,94),T3sum(1:35,3))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(24)/2._/**/REALKIND * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,3))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,94),T3sum(1:35,3))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,3))
  M(1) = M(1) + (-(f(21)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,95),T3sum(1:35,3))
  M(1) = M(1) + (f(19)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(20)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,3))
  M(1) = M(1) + (f(19)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (f(20)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,96),T3sum(1:35,3))
  M(1) = M(1) + (f(19)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (f(20)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,73),T3sum(1:35,3))
  M(1) = M(1) + (f(19)/2._/**/REALKIND * den(48)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,20),T4sum(1:70,10))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,8),T4sum(1:70,11))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,15),T4sum(1:70,10))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_6,masses2_7,G4tensor(:,5),T4sum(1:70,12))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_3,masses2_10,G4tensor(:,53),T4sum(1:70,13))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_3,masses2_8,G4tensor(:,55),T4sum(1:70,14))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_3,masses2_10,G4tensor(:,57),T4sum(1:70,13))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,59),T4sum(1:70,15))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_2,masses2_10,G4tensor(:,54),T4sum(1:70,16))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_2,masses2_8,G4tensor(:,56),T4sum(1:70,17))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_2,masses2_10,G4tensor(:,58),T4sum(1:70,16))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(84)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,60),T4sum(1:70,18))
  M(1) = M(1) + (-(f(24)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,74),T3sum(1:35,3))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-(f(24)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,97),T3sum(1:35,3))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,74),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,97),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,98),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,76),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,99),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,100),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,101),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(1) = M(1) + (-(f(24)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,79),T3sum(1:35,3))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (-(f(24)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,3))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,79),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(1) = M(1) + (f(22)/2._/**/REALKIND * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,3))
  M(1) = M(1) + (f(21)/2._/**/REALKIND * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,80),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,103),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,81),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,104),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,105),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(1) = M(1) + (f(25)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,106),T3sum(1:35,3))
  M(1) = M(1) + (f(23)/2._/**/REALKIND * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,84),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,107),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,108),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,86),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,109),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,87),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,110),T3sum(1:35,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nenexeexuuxg_1_/**/REALKIND
