
module ol_vamp_1_ppllllj2_nenexeexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenexeexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenexeexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenexeexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenexeexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,22) :: G0
  complex(REALKIND), dimension(4,5,4,134) :: G1
  complex(REALKIND), dimension(4,15,4,435) :: G2
  complex(REALKIND), dimension(4,35,4,421) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,126,128))
    allocate(G4tensorhel(70,135,128))
    allocate(G5tensorhel(126,102,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,61),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,85),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,86),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,87),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,88),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QS_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,43),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,1),wf(:,89),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,1),wf(:,90),G2(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,1),wf(:,91),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,1),wf(:,92),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,1),wf(:,93),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,1),wf(:,94),G2(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,1),wf(:,95),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,1),wf(:,96),G2(:,:,:,17),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,-6),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,124),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,7),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,-6),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,124),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,4),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,22))
  call loop_AS_Q(G2(:,:,:,22),wf(:,61),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,22),wf(:,85),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,86),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,22),wf(:,87),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,88),G2(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,21))
  call loop_AS_Q(G2(:,:,:,22),wf(:,74),G2(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,22),wf(:,43),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,75),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,22),wf(:,89),G2(:,:,:,31))
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,90),G2(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,91),G2(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,22),wf(:,92),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,93),G2(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,94),G2(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MT,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,95),G2(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MT,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,22),wf(:,96),G2(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MT,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-6),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,124),MT,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,7),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-6),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,124),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,4))
  call loop_AW_Q(G1(:,:,:,5),wf(:,38),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,57),MB,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-6),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,121),MB,G3(:,:,:,9))
  call loop_AW_Q(G3(:,:,:,9),wf(:,39),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),MT,G4tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-6),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,112),MB,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,61),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),MB,G3tensor(:,33))
  call loop_QV_A(G2(:,:,:,45),wf(:,85),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,45),wf(:,86),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,45),wf(:,87),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,45),wf(:,88),G2(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,37))
  call loop_QS_A(G2(:,:,:,45),wf(:,74),G2(:,:,:,51),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,38))
  call loop_QV_A(G2(:,:,:,45),wf(:,43),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,45),wf(:,75),G2(:,:,:,53),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,40))
  call loop_QV_A(G2(:,:,:,45),wf(:,89),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,41))
  call loop_QZ_A(G2(:,:,:,45),wf(:,90),G2(:,:,:,55),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,91),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,43))
  call loop_QV_A(G2(:,:,:,45),wf(:,92),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,45),wf(:,93),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,45),wf(:,94),G2(:,:,:,59),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,95),G2(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,45),wf(:,96),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,10),wf(:,2),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,-6),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,124),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,4),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,6))
  call loop_QZ_A(G1(:,:,:,10),wf(:,7),G1(:,:,:,13),gZd)
  call loop_Q_A(G1(:,:,:,13),Q(:,60),MB,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,-6),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,124),MB,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_QW_A(G1(:,:,:,10),wf(:,38),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,57),MT,G2(:,:,:,66))
  call loop_QV_A(G2(:,:,:,66),wf(:,-6),G2(:,:,:,67))
  call loop_Q_A(G2(:,:,:,67),Q(:,121),MT,G3(:,:,:,15))
  call loop_QW_A(G3(:,:,:,15),wf(:,39),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-6),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,112),MB,G2(:,:,:,68))
  call loop_AS_Q(G2(:,:,:,68),wf(:,61),G2(:,:,:,69),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),MB,G3tensor(:,49))
  call loop_AV_Q(G2(:,:,:,68),wf(:,85),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),MB,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,86),G2(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),MB,G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,68),wf(:,87),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),MB,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,88),G2(:,:,:,73),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),MB,G3tensor(:,53))
  call loop_AS_Q(G2(:,:,:,68),wf(:,74),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MB,G3tensor(:,54))
  call loop_AV_Q(G2(:,:,:,68),wf(:,43),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,75),G2(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,56))
  call loop_AV_Q(G2(:,:,:,68),wf(:,89),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,90),G2(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,91),G2(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,59))
  call loop_AV_Q(G2(:,:,:,68),wf(:,92),G2(:,:,:,80))
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,93),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,94),G2(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),MB,G3tensor(:,62))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,95),G2(:,:,:,83),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,68),wf(:,96),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,15),wf(:,2),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,60),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),MB,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,7),G1(:,:,:,18),gZd)
  call loop_A_Q(G1(:,:,:,18),Q(:,60),MB,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,124),MB,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,2),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,60),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-6),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,21),gZu)
  call loop_A_Q(G1(:,:,:,21),Q(:,60),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-6),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),ZERO,G3(:,:,:,24))
  call loop_AZ_Q(G3(:,:,:,24),wf(:,4),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,60),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,124),ZERO,G3(:,:,:,26))
  call loop_AZ_Q(G3(:,:,:,26),wf(:,4),G3(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-6),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,112),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,85),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,86),G2(:,:,:,97),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,86),G2(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,67))
  call loop_AV_Q(G2(:,:,:,95),wf(:,87),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,68))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,88),G2(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,88),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AV_Q(G2(:,:,:,95),wf(:,43),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,95),wf(:,89),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,90),G2(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,90),G2(:,:,:,107),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,127),ZERO,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,91),G2(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,127),ZERO,G3tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,91),G2(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,127),ZERO,G3tensor(:,78))
  call loop_AV_Q(G2(:,:,:,95),wf(:,92),G2(:,:,:,110))
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,127),ZERO,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,93),G2(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,127),ZERO,G3tensor(:,80))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,93),G2(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,127),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,94),G2(:,:,:,113),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,127),ZERO,G3tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,94),G2(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,127),ZERO,G3tensor(:,83))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,95),G2(:,:,:,115),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,127),ZERO,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,95),G2(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,127),ZERO,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,96),G2(:,:,:,117),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,86))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,96),G2(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,127),ZERO,G3tensor(:,87))
  call loop_AW_Q(G1(:,:,:,19),wf(:,38),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,57),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-6),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,121),ZERO,G3(:,:,:,28))
  call loop_AW_Q(G3(:,:,:,28),wf(:,39),G3(:,:,:,29))
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),ZERO,G4tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,2),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,60),ZERO,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,-6),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,124),ZERO,G3(:,:,:,30))
  call loop_QZ_A(G3(:,:,:,30),wf(:,4),G3(:,:,:,31),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,16))
  call loop_QZ_A(G3(:,:,:,30),wf(:,4),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,17))
  call loop_QZ_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,27),gZu)
  call loop_Q_A(G1(:,:,:,27),Q(:,60),ZERO,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,-6),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,124),ZERO,G3(:,:,:,33))
  call loop_QZ_A(G3(:,:,:,33),wf(:,4),G3(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,18))
  call loop_QZ_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,60),ZERO,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,-6),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,124),ZERO,G3(:,:,:,35))
  call loop_QZ_A(G3(:,:,:,35),wf(:,4),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,25),wf(:,-6),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,112),ZERO,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,85),G2(:,:,:,128))
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,127),wf(:,86),G2(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,127),wf(:,86),G2(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,90))
  call loop_QV_A(G2(:,:,:,127),wf(:,87),G2(:,:,:,131))
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,127),wf(:,88),G2(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,92))
  call loop_QZ_A(G2(:,:,:,127),wf(:,88),G2(:,:,:,133),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QV_A(G2(:,:,:,127),wf(:,43),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,127),wf(:,75),G2(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QZ_A(G2(:,:,:,127),wf(:,75),G2(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QV_A(G2(:,:,:,127),wf(:,89),G2(:,:,:,137))
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,127),wf(:,90),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QZ_A(G2(:,:,:,127),wf(:,90),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,127),wf(:,91),G2(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,127),wf(:,91),G2(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,127),wf(:,92),G2(:,:,:,142))
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,102))
  call loop_QZ_A(G2(:,:,:,127),wf(:,93),G2(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,127),wf(:,93),G2(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,127),wf(:,94),G2(:,:,:,145),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,105))
  call loop_QZ_A(G2(:,:,:,127),wf(:,94),G2(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,127),wf(:,95),G2(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,107))
  call loop_QZ_A(G2(:,:,:,127),wf(:,95),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,127),wf(:,96),G2(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,127),wf(:,96),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,110))
  call loop_QW_A(G1(:,:,:,25),wf(:,38),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,57),ZERO,G2(:,:,:,151))
  call loop_QV_A(G2(:,:,:,151),wf(:,-6),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,121),ZERO,G3(:,:,:,37))
  call loop_QW_A(G3(:,:,:,37),wf(:,39),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,60),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-6),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,124),ZERO,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-6),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,76),ZERO,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,3),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,124),ZERO,G3(:,:,:,42))
  call loop_AZ_Q(G3(:,:,:,42),wf(:,4),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,42),wf(:,4),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-4),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,92),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-5),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,108),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,124),ZERO,G4(:,:,:,4))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,4),G4(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,4),G4(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,31),wf(:,9),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,92),ZERO,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,124),ZERO,G3(:,:,:,49))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,26))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,44),ZERO,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,9),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,124),ZERO,G3(:,:,:,52))
  call loop_AZ_Q(G3(:,:,:,52),wf(:,4),G3(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),ZERO,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,52),wf(:,4),G3(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),ZERO,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-4),G2(:,:,:,163))
  call loop_A_Q(G2(:,:,:,163),Q(:,60),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-6),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,124),ZERO,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,4),G4(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,4),G4(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-6),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,108),ZERO,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-4),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,124),ZERO,G4(:,:,:,10))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,4),G4(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,4),G4(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,31),wf(:,12),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,108),ZERO,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-4),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,124),ZERO,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,61),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),ZERO,G4tensor(:,30))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,28),ZERO,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,12),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,124),ZERO,G3(:,:,:,62))
  call loop_AZ_Q(G3(:,:,:,62),wf(:,4),G3(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,62),wf(:,4),G3(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,32))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-5),G2(:,:,:,169))
  call loop_A_Q(G2(:,:,:,169),Q(:,60),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-6),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,124),ZERO,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,4),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,4),G4(:,:,:,15),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,92),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-5),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,124),ZERO,G4(:,:,:,16))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,4),G4(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,4),G4(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,3),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,60),MT,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-6),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,124),MT,G3(:,:,:,69))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,4),G3(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),MT,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-6),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,76),MT,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,3),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,124),MT,G3(:,:,:,71))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,4),G3(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-4),G2(:,:,:,175))
  call loop_A_Q(G2(:,:,:,175),Q(:,92),MT,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-5),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,124),MT,G4(:,:,:,19))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,4),G4(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,108),MT,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-4),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,124),MT,G4(:,:,:,21))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,4),G4(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),MT,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,38),wf(:,9),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,92),MT,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-5),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,124),MT,G3(:,:,:,77))
  call loop_AZ_Q(G3(:,:,:,77),wf(:,4),G3(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),MT,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-5),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,44),MT,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,9),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,124),MT,G3(:,:,:,79))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,4),G3(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,36))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-4),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,60),MT,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-6),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,124),MT,G4(:,:,:,23))
  call loop_AZ_Q(G4(:,:,:,23),wf(:,4),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-6),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,108),MT,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,124),MT,G4(:,:,:,25))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,38),wf(:,12),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,108),MT,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-4),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,124),MT,G3(:,:,:,85))
  call loop_AZ_Q(G3(:,:,:,85),wf(:,4),G3(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),MT,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-4),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,28),MT,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,12),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,124),MT,G3(:,:,:,87))
  call loop_AZ_Q(G3(:,:,:,87),wf(:,4),G3(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,127),MT,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-5),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,60),MT,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-6),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,124),MT,G4(:,:,:,27))
  call loop_AZ_Q(G4(:,:,:,27),wf(:,4),G4(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,127),MT,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-6),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,92),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-5),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,124),MT,G4(:,:,:,29))
  call loop_AZ_Q(G4(:,:,:,29),wf(:,4),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,3),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,60),ZERO,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-6),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,124),ZERO,G3(:,:,:,93))
  call loop_QZ_A(G3(:,:,:,93),wf(:,4),G3(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),ZERO,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,93),wf(:,4),G3(:,:,:,95),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,127),ZERO,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,45),wf(:,-6),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,76),ZERO,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,3),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,124),ZERO,G3(:,:,:,96))
  call loop_QZ_A(G3(:,:,:,96),wf(:,4),G3(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,127),ZERO,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,96),wf(:,4),G3(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),ZERO,G4tensor(:,42))
  call loop_QV_A(G2(:,:,:,191),wf(:,-4),G2(:,:,:,193))
  call loop_Q_A(G2(:,:,:,193),Q(:,92),ZERO,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-5),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,124),ZERO,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,19))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,33),Q(:,127),ZERO,G5tensor(:,20))
  call loop_QV_A(G2(:,:,:,191),wf(:,-5),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,108),ZERO,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-4),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,124),ZERO,G4(:,:,:,34))
  call loop_QZ_A(G4(:,:,:,34),wf(:,4),G4(:,:,:,35),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,35),Q(:,127),ZERO,G5tensor(:,21))
  call loop_QZ_A(G4(:,:,:,34),wf(:,4),G4(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,45),wf(:,9),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,92),ZERO,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,-5),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,124),ZERO,G3(:,:,:,103))
  call loop_QZ_A(G3(:,:,:,103),wf(:,4),G3(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),ZERO,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,103),wf(:,4),G3(:,:,:,105),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),ZERO,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,45),wf(:,-5),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,44),ZERO,G2(:,:,:,197))
  call loop_QV_A(G2(:,:,:,197),wf(:,9),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,124),ZERO,G3(:,:,:,106))
  call loop_QZ_A(G3(:,:,:,106),wf(:,4),G3(:,:,:,107),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,107),Q(:,127),ZERO,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,106),wf(:,4),G3(:,:,:,108),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,197),wf(:,-4),G2(:,:,:,199))
  call loop_Q_A(G2(:,:,:,199),Q(:,60),ZERO,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-6),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,124),ZERO,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),ZERO,G5tensor(:,23))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,39),Q(:,127),ZERO,G5tensor(:,24))
  call loop_QV_A(G2(:,:,:,197),wf(:,-6),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,108),ZERO,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,124),ZERO,G4(:,:,:,40))
  call loop_QZ_A(G4(:,:,:,40),wf(:,4),G4(:,:,:,41),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,41),Q(:,127),ZERO,G5tensor(:,25))
  call loop_QZ_A(G4(:,:,:,40),wf(:,4),G4(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),ZERO,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,45),wf(:,12),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,108),ZERO,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,-4),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,124),ZERO,G3(:,:,:,113))
  call loop_QZ_A(G3(:,:,:,113),wf(:,4),G3(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,127),ZERO,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,113),wf(:,4),G3(:,:,:,115),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,115),Q(:,127),ZERO,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,45),wf(:,-4),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,28),ZERO,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,12),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,124),ZERO,G3(:,:,:,116))
  call loop_QZ_A(G3(:,:,:,116),wf(:,4),G3(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,117),Q(:,127),ZERO,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,116),wf(:,4),G3(:,:,:,118),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,127),ZERO,G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,203),wf(:,-5),G2(:,:,:,205))
  call loop_Q_A(G2(:,:,:,205),Q(:,60),ZERO,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-6),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,124),ZERO,G4(:,:,:,43))
  call loop_QZ_A(G4(:,:,:,43),wf(:,4),G4(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),ZERO,G5tensor(:,27))
  call loop_QZ_A(G4(:,:,:,43),wf(:,4),G4(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),ZERO,G5tensor(:,28))
  call loop_QV_A(G2(:,:,:,203),wf(:,-6),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,92),ZERO,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,-5),G3(:,:,:,122))
  call loop_Q_A(G3(:,:,:,122),Q(:,124),ZERO,G4(:,:,:,46))
  call loop_QZ_A(G4(:,:,:,46),wf(:,4),G4(:,:,:,47),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,47),Q(:,127),ZERO,G5tensor(:,29))
  call loop_QZ_A(G4(:,:,:,46),wf(:,4),G4(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),ZERO,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,3),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,60),MT,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,-6),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,124),MT,G3(:,:,:,123))
  call loop_QZ_A(G3(:,:,:,123),wf(:,4),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MT,G4tensor(:,51))
  call loop_QV_A(G1(:,:,:,52),wf(:,-6),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,76),MT,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,3),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,124),MT,G3(:,:,:,125))
  call loop_QZ_A(G3(:,:,:,125),wf(:,4),G3(:,:,:,126),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,127),MT,G4tensor(:,52))
  call loop_QV_A(G2(:,:,:,209),wf(:,-4),G2(:,:,:,211))
  call loop_Q_A(G2(:,:,:,211),Q(:,92),MT,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-5),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,124),MT,G4(:,:,:,49))
  call loop_QZ_A(G4(:,:,:,49),wf(:,4),G4(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),MT,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,209),wf(:,-5),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,108),MT,G3(:,:,:,129))
  call loop_QV_A(G3(:,:,:,129),wf(:,-4),G3(:,:,:,130))
  call loop_Q_A(G3(:,:,:,130),Q(:,124),MT,G4(:,:,:,51))
  call loop_QZ_A(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,127),MT,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,52),wf(:,9),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,92),MT,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,-5),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,124),MT,G3(:,:,:,131))
  call loop_QZ_A(G3(:,:,:,131),wf(:,4),G3(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,127),MT,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,52),wf(:,-5),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,44),MT,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,9),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,124),MT,G3(:,:,:,133))
  call loop_QZ_A(G3(:,:,:,133),wf(:,4),G3(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,127),MT,G4tensor(:,54))
  call loop_QV_A(G2(:,:,:,215),wf(:,-4),G2(:,:,:,217))
  call loop_Q_A(G2(:,:,:,217),Q(:,60),MT,G3(:,:,:,135))
  call loop_QV_A(G3(:,:,:,135),wf(:,-6),G3(:,:,:,136))
  call loop_Q_A(G3(:,:,:,136),Q(:,124),MT,G4(:,:,:,53))
  call loop_QZ_A(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),MT,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,215),wf(:,-6),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,108),MT,G3(:,:,:,137))
  call loop_QV_A(G3(:,:,:,137),wf(:,-4),G3(:,:,:,138))
  call loop_Q_A(G3(:,:,:,138),Q(:,124),MT,G4(:,:,:,55))
  call loop_QZ_A(G4(:,:,:,55),wf(:,4),G4(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MT,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,52),wf(:,12),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,108),MT,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,-4),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,124),MT,G3(:,:,:,139))
  call loop_QZ_A(G3(:,:,:,139),wf(:,4),G3(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),MT,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,52),wf(:,-4),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,28),MT,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,12),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,124),MT,G3(:,:,:,141))
  call loop_QZ_A(G3(:,:,:,141),wf(:,4),G3(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),MT,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,221),wf(:,-5),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,60),MT,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-6),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,124),MT,G4(:,:,:,57))
  call loop_QZ_A(G4(:,:,:,57),wf(:,4),G4(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,127),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,221),wf(:,-6),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,92),MT,G3(:,:,:,145))
  call loop_QV_A(G3(:,:,:,145),wf(:,-5),G3(:,:,:,146))
  call loop_Q_A(G3(:,:,:,146),Q(:,124),MT,G4(:,:,:,59))
  call loop_QZ_A(G4(:,:,:,59),wf(:,4),G4(:,:,:,60),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),MT,G5tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,3),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,60),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-6),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,124),MB,G3(:,:,:,147))
  call loop_AZ_Q(G3(:,:,:,147),wf(:,4),G3(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,127),MB,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-6),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,76),MB,G2(:,:,:,227))
  call loop_AV_Q(G2(:,:,:,227),wf(:,3),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,124),MB,G3(:,:,:,149))
  call loop_AZ_Q(G3(:,:,:,149),wf(:,4),G3(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,127),MB,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-4),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,92),MB,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-5),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,124),MB,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,227),wf(:,-5),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,108),MB,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,-4),G3(:,:,:,154))
  call loop_A_Q(G3(:,:,:,154),Q(:,124),MB,G4(:,:,:,63))
  call loop_AZ_Q(G4(:,:,:,63),wf(:,4),G4(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,127),MB,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,59),wf(:,9),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,92),MB,G2(:,:,:,231))
  call loop_AV_Q(G2(:,:,:,231),wf(:,-5),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,124),MB,G3(:,:,:,155))
  call loop_AZ_Q(G3(:,:,:,155),wf(:,4),G3(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,127),MB,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-5),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,44),MB,G2(:,:,:,233))
  call loop_AV_Q(G2(:,:,:,233),wf(:,9),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,124),MB,G3(:,:,:,157))
  call loop_AZ_Q(G3(:,:,:,157),wf(:,4),G3(:,:,:,158),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,127),MB,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-4),G2(:,:,:,235))
  call loop_A_Q(G2(:,:,:,235),Q(:,60),MB,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-6),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,124),MB,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,4),G4(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-6),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,108),MB,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,-4),G3(:,:,:,162))
  call loop_A_Q(G3(:,:,:,162),Q(:,124),MB,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,59),wf(:,12),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,108),MB,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-4),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,124),MB,G3(:,:,:,163))
  call loop_AZ_Q(G3(:,:,:,163),wf(:,4),G3(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,127),MB,G4tensor(:,61))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-4),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,28),MB,G2(:,:,:,239))
  call loop_AV_Q(G2(:,:,:,239),wf(:,12),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,124),MB,G3(:,:,:,165))
  call loop_AZ_Q(G3(:,:,:,165),wf(:,4),G3(:,:,:,166),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,127),MB,G4tensor(:,62))
  call loop_AV_Q(G2(:,:,:,239),wf(:,-5),G2(:,:,:,241))
  call loop_A_Q(G2(:,:,:,241),Q(:,60),MB,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,-6),G3(:,:,:,168))
  call loop_A_Q(G3(:,:,:,168),Q(:,124),MB,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),MB,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,239),wf(:,-6),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,92),MB,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-5),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,124),MB,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,60),MB,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-6),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,124),MB,G3(:,:,:,171))
  call loop_QZ_A(G3(:,:,:,171),wf(:,4),G3(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),MB,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,66),wf(:,-6),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,76),MB,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,3),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,124),MB,G3(:,:,:,173))
  call loop_QZ_A(G3(:,:,:,173),wf(:,4),G3(:,:,:,174),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,127),MB,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,245),wf(:,-4),G2(:,:,:,247))
  call loop_Q_A(G2(:,:,:,247),Q(:,92),MB,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-5),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,124),MB,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),MB,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,245),wf(:,-5),G2(:,:,:,248))
  call loop_Q_A(G2(:,:,:,248),Q(:,108),MB,G3(:,:,:,177))
  call loop_QV_A(G3(:,:,:,177),wf(:,-4),G3(:,:,:,178))
  call loop_Q_A(G3(:,:,:,178),Q(:,124),MB,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,66),wf(:,9),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,92),MB,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,-5),G2(:,:,:,250))
  call loop_Q_A(G2(:,:,:,250),Q(:,124),MB,G3(:,:,:,179))
  call loop_QZ_A(G3(:,:,:,179),wf(:,4),G3(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),MB,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,66),wf(:,-5),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,44),MB,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,9),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,124),MB,G3(:,:,:,181))
  call loop_QZ_A(G3(:,:,:,181),wf(:,4),G3(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),MB,G4tensor(:,66))
  call loop_QV_A(G2(:,:,:,251),wf(:,-4),G2(:,:,:,253))
  call loop_Q_A(G2(:,:,:,253),Q(:,60),MB,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-6),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,124),MB,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,4),G4(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),MB,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,251),wf(:,-6),G2(:,:,:,254))
  call loop_Q_A(G2(:,:,:,254),Q(:,108),MB,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,-4),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,124),MB,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),MB,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,66),wf(:,12),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,108),MB,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,-4),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,124),MB,G3(:,:,:,187))
  call loop_QZ_A(G3(:,:,:,187),wf(:,4),G3(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),MB,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,66),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,28),MB,G2(:,:,:,257))
  call loop_QV_A(G2(:,:,:,257),wf(:,12),G2(:,:,:,258))
  call loop_Q_A(G2(:,:,:,258),Q(:,124),MB,G3(:,:,:,189))
  call loop_QZ_A(G3(:,:,:,189),wf(:,4),G3(:,:,:,190),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),MB,G4tensor(:,68))
  call loop_QV_A(G2(:,:,:,257),wf(:,-5),G2(:,:,:,259))
  call loop_Q_A(G2(:,:,:,259),Q(:,60),MB,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-6),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,124),MB,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,4),G4(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,257),wf(:,-6),G2(:,:,:,260))
  call loop_Q_A(G2(:,:,:,260),Q(:,92),MB,G3(:,:,:,193))
  call loop_QV_A(G3(:,:,:,193),wf(:,-5),G3(:,:,:,194))
  call loop_Q_A(G3(:,:,:,194),Q(:,124),MB,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,4),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),MB,G5tensor(:,48))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,3),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,60),ZERO,G2(:,:,:,261))
  call loop_AV_Q(G2(:,:,:,261),wf(:,-6),G2(:,:,:,262))
  call loop_A_Q(G2(:,:,:,262),Q(:,124),ZERO,G3(:,:,:,195))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,4),G3(:,:,:,196),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,69))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-6),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,76),ZERO,G2(:,:,:,263))
  call loop_AV_Q(G2(:,:,:,263),wf(:,3),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,124),ZERO,G3(:,:,:,197))
  call loop_AZ_Q(G3(:,:,:,197),wf(:,4),G3(:,:,:,198),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),ZERO,G4tensor(:,70))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-4),G2(:,:,:,265))
  call loop_A_Q(G2(:,:,:,265),Q(:,92),ZERO,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,124),ZERO,G4(:,:,:,85))
  call loop_AZ_Q(G4(:,:,:,85),wf(:,4),G4(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,49))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-5),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,108),ZERO,G3(:,:,:,201))
  call loop_AV_Q(G3(:,:,:,201),wf(:,-4),G3(:,:,:,202))
  call loop_A_Q(G3(:,:,:,202),Q(:,124),ZERO,G4(:,:,:,87))
  call loop_AZ_Q(G4(:,:,:,87),wf(:,4),G4(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,50))
  call loop_AV_Q(G1(:,:,:,73),wf(:,9),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,92),ZERO,G2(:,:,:,267))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-5),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,124),ZERO,G3(:,:,:,203))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,4),G3(:,:,:,204),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,127),ZERO,G4tensor(:,71))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-5),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,44),ZERO,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,9),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,124),ZERO,G3(:,:,:,205))
  call loop_AZ_Q(G3(:,:,:,205),wf(:,4),G3(:,:,:,206),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,206),Q(:,127),ZERO,G4tensor(:,72))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-4),G2(:,:,:,271))
  call loop_A_Q(G2(:,:,:,271),Q(:,60),ZERO,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-6),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,124),ZERO,G4(:,:,:,89))
  call loop_AZ_Q(G4(:,:,:,89),wf(:,4),G4(:,:,:,90),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,51))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-6),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,108),ZERO,G3(:,:,:,209))
  call loop_AV_Q(G3(:,:,:,209),wf(:,-4),G3(:,:,:,210))
  call loop_A_Q(G3(:,:,:,210),Q(:,124),ZERO,G4(:,:,:,91))
  call loop_AZ_Q(G4(:,:,:,91),wf(:,4),G4(:,:,:,92),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,73),wf(:,12),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,108),ZERO,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-4),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,124),ZERO,G3(:,:,:,211))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,4),G3(:,:,:,212),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,127),ZERO,G4tensor(:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,28),ZERO,G2(:,:,:,275))
  call loop_AV_Q(G2(:,:,:,275),wf(:,12),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,124),ZERO,G3(:,:,:,213))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,4),G3(:,:,:,214),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,127),ZERO,G4tensor(:,74))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-5),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,60),ZERO,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-6),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,124),ZERO,G4(:,:,:,93))
  call loop_AZ_Q(G4(:,:,:,93),wf(:,4),G4(:,:,:,94),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,53))
  call loop_AV_Q(G2(:,:,:,275),wf(:,-6),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,92),ZERO,G3(:,:,:,217))
  call loop_AV_Q(G3(:,:,:,217),wf(:,-5),G3(:,:,:,218))
  call loop_A_Q(G3(:,:,:,218),Q(:,124),ZERO,G4(:,:,:,95))
  call loop_AZ_Q(G4(:,:,:,95),wf(:,4),G4(:,:,:,96),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,127),ZERO,G5tensor(:,54))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,80))
  call loop_AV_Q(G1(:,:,:,80),wf(:,3),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,60),MT,G2(:,:,:,279))
  call loop_AV_Q(G2(:,:,:,279),wf(:,-6),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,124),MT,G3(:,:,:,219))
  call loop_AZ_Q(G3(:,:,:,219),wf(:,4),G3(:,:,:,220),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,127),MT,G4tensor(:,75))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-6),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,76),MT,G2(:,:,:,281))
  call loop_AV_Q(G2(:,:,:,281),wf(:,3),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,124),MT,G3(:,:,:,221))
  call loop_AZ_Q(G3(:,:,:,221),wf(:,4),G3(:,:,:,222),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,127),MT,G4tensor(:,76))
  call loop_AV_Q(G2(:,:,:,281),wf(:,-4),G2(:,:,:,283))
  call loop_A_Q(G2(:,:,:,283),Q(:,92),MT,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-5),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,124),MT,G4(:,:,:,97))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,4),G4(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MT,G5tensor(:,55))
  call loop_AV_Q(G2(:,:,:,281),wf(:,-5),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,108),MT,G3(:,:,:,225))
  call loop_AV_Q(G3(:,:,:,225),wf(:,-4),G3(:,:,:,226))
  call loop_A_Q(G3(:,:,:,226),Q(:,124),MT,G4(:,:,:,99))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,4),G4(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,127),MT,G5tensor(:,56))
  call loop_AV_Q(G1(:,:,:,80),wf(:,9),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,92),MT,G2(:,:,:,285))
  call loop_AV_Q(G2(:,:,:,285),wf(:,-5),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,124),MT,G3(:,:,:,227))
  call loop_AZ_Q(G3(:,:,:,227),wf(:,4),G3(:,:,:,228),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,127),MT,G4tensor(:,77))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-5),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,44),MT,G2(:,:,:,287))
  call loop_AV_Q(G2(:,:,:,287),wf(:,9),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,124),MT,G3(:,:,:,229))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,4),G3(:,:,:,230),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),MT,G4tensor(:,78))
  call loop_AV_Q(G2(:,:,:,287),wf(:,-4),G2(:,:,:,289))
  call loop_A_Q(G2(:,:,:,289),Q(:,60),MT,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-6),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,124),MT,G4(:,:,:,101))
  call loop_AZ_Q(G4(:,:,:,101),wf(:,4),G4(:,:,:,102),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MT,G5tensor(:,57))
  call loop_AV_Q(G2(:,:,:,287),wf(:,-6),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,108),MT,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,-4),G3(:,:,:,234))
  call loop_A_Q(G3(:,:,:,234),Q(:,124),MT,G4(:,:,:,103))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,4),G4(:,:,:,104),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),MT,G5tensor(:,58))
  call loop_AV_Q(G1(:,:,:,80),wf(:,12),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,108),MT,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-4),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,124),MT,G3(:,:,:,235))
  call loop_AZ_Q(G3(:,:,:,235),wf(:,4),G3(:,:,:,236),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,127),MT,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-4),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,28),MT,G2(:,:,:,293))
  call loop_AV_Q(G2(:,:,:,293),wf(:,12),G2(:,:,:,294))
  call loop_A_Q(G2(:,:,:,294),Q(:,124),MT,G3(:,:,:,237))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,4),G3(:,:,:,238),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),MT,G4tensor(:,80))
  call loop_AV_Q(G2(:,:,:,293),wf(:,-5),G2(:,:,:,295))
  call loop_A_Q(G2(:,:,:,295),Q(:,60),MT,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-6),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,124),MT,G4(:,:,:,105))
  call loop_AZ_Q(G4(:,:,:,105),wf(:,4),G4(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,127),MT,G5tensor(:,59))
  call loop_AV_Q(G2(:,:,:,293),wf(:,-6),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,92),MT,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,-5),G3(:,:,:,242))
  call loop_A_Q(G3(:,:,:,242),Q(:,124),MT,G4(:,:,:,107))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,4),G4(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),MT,G5tensor(:,60))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,3),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,60),ZERO,G2(:,:,:,297))
  call loop_QV_A(G2(:,:,:,297),wf(:,-6),G2(:,:,:,298))
  call loop_Q_A(G2(:,:,:,298),Q(:,124),ZERO,G3(:,:,:,243))
  call loop_QZ_A(G3(:,:,:,243),wf(:,4),G3(:,:,:,244),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,127),ZERO,G4tensor(:,81))
  call loop_QV_A(G1(:,:,:,87),wf(:,-6),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,76),ZERO,G2(:,:,:,299))
  call loop_QV_A(G2(:,:,:,299),wf(:,3),G2(:,:,:,300))
  call loop_Q_A(G2(:,:,:,300),Q(:,124),ZERO,G3(:,:,:,245))
  call loop_QZ_A(G3(:,:,:,245),wf(:,4),G3(:,:,:,246),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,127),ZERO,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,299),wf(:,-4),G2(:,:,:,301))
  call loop_Q_A(G2(:,:,:,301),Q(:,92),ZERO,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-5),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,124),ZERO,G4(:,:,:,109))
  call loop_QZ_A(G4(:,:,:,109),wf(:,4),G4(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),ZERO,G5tensor(:,61))
  call loop_QV_A(G2(:,:,:,299),wf(:,-5),G2(:,:,:,302))
  call loop_Q_A(G2(:,:,:,302),Q(:,108),ZERO,G3(:,:,:,249))
  call loop_QV_A(G3(:,:,:,249),wf(:,-4),G3(:,:,:,250))
  call loop_Q_A(G3(:,:,:,250),Q(:,124),ZERO,G4(:,:,:,111))
  call loop_QZ_A(G4(:,:,:,111),wf(:,4),G4(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,127),ZERO,G5tensor(:,62))
  call loop_QV_A(G1(:,:,:,87),wf(:,9),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,92),ZERO,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,-5),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,124),ZERO,G3(:,:,:,251))
  call loop_QZ_A(G3(:,:,:,251),wf(:,4),G3(:,:,:,252),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QV_A(G1(:,:,:,87),wf(:,-5),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,44),ZERO,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,9),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,124),ZERO,G3(:,:,:,253))
  call loop_QZ_A(G3(:,:,:,253),wf(:,4),G3(:,:,:,254),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QV_A(G2(:,:,:,305),wf(:,-4),G2(:,:,:,307))
  call loop_Q_A(G2(:,:,:,307),Q(:,60),ZERO,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-6),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,124),ZERO,G4(:,:,:,113))
  call loop_QZ_A(G4(:,:,:,113),wf(:,4),G4(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,127),ZERO,G5tensor(:,63))
  call loop_QV_A(G2(:,:,:,305),wf(:,-6),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,108),ZERO,G3(:,:,:,257))
  call loop_QV_A(G3(:,:,:,257),wf(:,-4),G3(:,:,:,258))
  call loop_Q_A(G3(:,:,:,258),Q(:,124),ZERO,G4(:,:,:,115))
  call loop_QZ_A(G4(:,:,:,115),wf(:,4),G4(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),ZERO,G5tensor(:,64))
  call loop_QV_A(G1(:,:,:,87),wf(:,12),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,108),ZERO,G2(:,:,:,309))
  call loop_QV_A(G2(:,:,:,309),wf(:,-4),G2(:,:,:,310))
  call loop_Q_A(G2(:,:,:,310),Q(:,124),ZERO,G3(:,:,:,259))
  call loop_QZ_A(G3(:,:,:,259),wf(:,4),G3(:,:,:,260),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QV_A(G1(:,:,:,87),wf(:,-4),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,28),ZERO,G2(:,:,:,311))
  call loop_QV_A(G2(:,:,:,311),wf(:,12),G2(:,:,:,312))
  call loop_Q_A(G2(:,:,:,312),Q(:,124),ZERO,G3(:,:,:,261))
  call loop_QZ_A(G3(:,:,:,261),wf(:,4),G3(:,:,:,262),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,311),wf(:,-5),G2(:,:,:,313))
  call loop_Q_A(G2(:,:,:,313),Q(:,60),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-6),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,124),ZERO,G4(:,:,:,117))
  call loop_QZ_A(G4(:,:,:,117),wf(:,4),G4(:,:,:,118),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,127),ZERO,G5tensor(:,65))
  call loop_QV_A(G2(:,:,:,311),wf(:,-6),G2(:,:,:,314))
  call loop_Q_A(G2(:,:,:,314),Q(:,92),ZERO,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-5),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,124),ZERO,G4(:,:,:,119))
  call loop_QZ_A(G4(:,:,:,119),wf(:,4),G4(:,:,:,120),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,127),ZERO,G5tensor(:,66))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,94))
  call loop_QV_A(G1(:,:,:,94),wf(:,3),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,60),MT,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,-6),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,124),MT,G3(:,:,:,267))
  call loop_QZ_A(G3(:,:,:,267),wf(:,4),G3(:,:,:,268),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,127),MT,G4tensor(:,87))
  call loop_QV_A(G1(:,:,:,94),wf(:,-6),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,76),MT,G2(:,:,:,317))
  call loop_QV_A(G2(:,:,:,317),wf(:,3),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,124),MT,G3(:,:,:,269))
  call loop_QZ_A(G3(:,:,:,269),wf(:,4),G3(:,:,:,270),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,270),Q(:,127),MT,G4tensor(:,88))
  call loop_QV_A(G2(:,:,:,317),wf(:,-4),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,92),MT,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-5),G3(:,:,:,272))
  call loop_Q_A(G3(:,:,:,272),Q(:,124),MT,G4(:,:,:,121))
  call loop_QZ_A(G4(:,:,:,121),wf(:,4),G4(:,:,:,122),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,127),MT,G5tensor(:,67))
  call loop_QV_A(G2(:,:,:,317),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,108),MT,G3(:,:,:,273))
  call loop_QV_A(G3(:,:,:,273),wf(:,-4),G3(:,:,:,274))
  call loop_Q_A(G3(:,:,:,274),Q(:,124),MT,G4(:,:,:,123))
  call loop_QZ_A(G4(:,:,:,123),wf(:,4),G4(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,127),MT,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,94),wf(:,9),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,92),MT,G2(:,:,:,321))
  call loop_QV_A(G2(:,:,:,321),wf(:,-5),G2(:,:,:,322))
  call loop_Q_A(G2(:,:,:,322),Q(:,124),MT,G3(:,:,:,275))
  call loop_QZ_A(G3(:,:,:,275),wf(:,4),G3(:,:,:,276),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,127),MT,G4tensor(:,89))
  call loop_QV_A(G1(:,:,:,94),wf(:,-5),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,44),MT,G2(:,:,:,323))
  call loop_QV_A(G2(:,:,:,323),wf(:,9),G2(:,:,:,324))
  call loop_Q_A(G2(:,:,:,324),Q(:,124),MT,G3(:,:,:,277))
  call loop_QZ_A(G3(:,:,:,277),wf(:,4),G3(:,:,:,278),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,278),Q(:,127),MT,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,323),wf(:,-4),G2(:,:,:,325))
  call loop_Q_A(G2(:,:,:,325),Q(:,60),MT,G3(:,:,:,279))
  call loop_QV_A(G3(:,:,:,279),wf(:,-6),G3(:,:,:,280))
  call loop_Q_A(G3(:,:,:,280),Q(:,124),MT,G4(:,:,:,125))
  call loop_QZ_A(G4(:,:,:,125),wf(:,4),G4(:,:,:,126),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,127),MT,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,323),wf(:,-6),G2(:,:,:,326))
  call loop_Q_A(G2(:,:,:,326),Q(:,108),MT,G3(:,:,:,281))
  call loop_QV_A(G3(:,:,:,281),wf(:,-4),G3(:,:,:,282))
  call loop_Q_A(G3(:,:,:,282),Q(:,124),MT,G4(:,:,:,127))
  call loop_QZ_A(G4(:,:,:,127),wf(:,4),G4(:,:,:,128),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,127),MT,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,94),wf(:,12),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,108),MT,G2(:,:,:,327))
  call loop_QV_A(G2(:,:,:,327),wf(:,-4),G2(:,:,:,328))
  call loop_Q_A(G2(:,:,:,328),Q(:,124),MT,G3(:,:,:,283))
  call loop_QZ_A(G3(:,:,:,283),wf(:,4),G3(:,:,:,284),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,127),MT,G4tensor(:,91))
  call loop_QV_A(G1(:,:,:,94),wf(:,-4),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,28),MT,G2(:,:,:,329))
  call loop_QV_A(G2(:,:,:,329),wf(:,12),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,124),MT,G3(:,:,:,285))
  call loop_QZ_A(G3(:,:,:,285),wf(:,4),G3(:,:,:,286),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,286),Q(:,127),MT,G4tensor(:,92))
  call loop_QV_A(G2(:,:,:,329),wf(:,-5),G2(:,:,:,331))
  call loop_Q_A(G2(:,:,:,331),Q(:,60),MT,G3(:,:,:,287))
  call loop_QV_A(G3(:,:,:,287),wf(:,-6),G3(:,:,:,288))
  call loop_Q_A(G3(:,:,:,288),Q(:,124),MT,G4(:,:,:,129))
  call loop_QZ_A(G4(:,:,:,129),wf(:,4),G4(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,127),MT,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,329),wf(:,-6),G2(:,:,:,332))
  call loop_Q_A(G2(:,:,:,332),Q(:,92),MT,G3(:,:,:,289))
  call loop_QV_A(G3(:,:,:,289),wf(:,-5),G3(:,:,:,290))
  call loop_Q_A(G3(:,:,:,290),Q(:,124),MT,G4(:,:,:,131))
  call loop_QZ_A(G4(:,:,:,131),wf(:,4),G4(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,127),MT,G5tensor(:,72))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,101))
  call loop_AV_Q(G1(:,:,:,101),wf(:,3),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,60),ZERO,G2(:,:,:,333))
  call loop_AV_Q(G2(:,:,:,333),wf(:,-6),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,124),ZERO,G3(:,:,:,291))
  call loop_AZ_Q(G3(:,:,:,291),wf(:,4),G3(:,:,:,292),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),ZERO,G4tensor(:,93))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-6),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,76),ZERO,G2(:,:,:,335))
  call loop_AV_Q(G2(:,:,:,335),wf(:,3),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,124),ZERO,G3(:,:,:,293))
  call loop_AZ_Q(G3(:,:,:,293),wf(:,4),G3(:,:,:,294),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,127),ZERO,G4tensor(:,94))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-4),G2(:,:,:,337))
  call loop_A_Q(G2(:,:,:,337),Q(:,92),ZERO,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,-5),G3(:,:,:,296))
  call loop_A_Q(G3(:,:,:,296),Q(:,124),ZERO,G4(:,:,:,133))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,4),G4(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,73))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-5),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,108),ZERO,G3(:,:,:,297))
  call loop_AV_Q(G3(:,:,:,297),wf(:,-4),G3(:,:,:,298))
  call loop_A_Q(G3(:,:,:,298),Q(:,124),ZERO,G4(:,:,:,135))
  call loop_AZ_Q(G4(:,:,:,135),wf(:,4),G4(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,127),ZERO,G5tensor(:,74))
  call loop_AV_Q(G1(:,:,:,101),wf(:,9),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,92),ZERO,G2(:,:,:,339))
  call loop_AV_Q(G2(:,:,:,339),wf(:,-5),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,124),ZERO,G3(:,:,:,299))
  call loop_AZ_Q(G3(:,:,:,299),wf(:,4),G3(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),ZERO,G4tensor(:,95))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-5),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,44),ZERO,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,9),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,124),ZERO,G3(:,:,:,301))
  call loop_AZ_Q(G3(:,:,:,301),wf(:,4),G3(:,:,:,302),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,302),Q(:,127),ZERO,G4tensor(:,96))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-4),G2(:,:,:,343))
  call loop_A_Q(G2(:,:,:,343),Q(:,60),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-6),G3(:,:,:,304))
  call loop_A_Q(G3(:,:,:,304),Q(:,124),ZERO,G4(:,:,:,137))
  call loop_AZ_Q(G4(:,:,:,137),wf(:,4),G4(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,127),ZERO,G5tensor(:,75))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-6),G2(:,:,:,344))
  call loop_A_Q(G2(:,:,:,344),Q(:,108),ZERO,G3(:,:,:,305))
  call loop_AV_Q(G3(:,:,:,305),wf(:,-4),G3(:,:,:,306))
  call loop_A_Q(G3(:,:,:,306),Q(:,124),ZERO,G4(:,:,:,139))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,4),G4(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,127),ZERO,G5tensor(:,76))
  call loop_AV_Q(G1(:,:,:,101),wf(:,12),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,108),ZERO,G2(:,:,:,345))
  call loop_AV_Q(G2(:,:,:,345),wf(:,-4),G2(:,:,:,346))
  call loop_A_Q(G2(:,:,:,346),Q(:,124),ZERO,G3(:,:,:,307))
  call loop_AZ_Q(G3(:,:,:,307),wf(:,4),G3(:,:,:,308),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),ZERO,G4tensor(:,97))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-4),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,28),ZERO,G2(:,:,:,347))
  call loop_AV_Q(G2(:,:,:,347),wf(:,12),G2(:,:,:,348))
  call loop_A_Q(G2(:,:,:,348),Q(:,124),ZERO,G3(:,:,:,309))
  call loop_AZ_Q(G3(:,:,:,309),wf(:,4),G3(:,:,:,310),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,127),ZERO,G4tensor(:,98))
  call loop_AV_Q(G2(:,:,:,347),wf(:,-5),G2(:,:,:,349))
  call loop_A_Q(G2(:,:,:,349),Q(:,60),ZERO,G3(:,:,:,311))
  call loop_AV_Q(G3(:,:,:,311),wf(:,-6),G3(:,:,:,312))
  call loop_A_Q(G3(:,:,:,312),Q(:,124),ZERO,G4(:,:,:,141))
  call loop_AZ_Q(G4(:,:,:,141),wf(:,4),G4(:,:,:,142),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,127),ZERO,G5tensor(:,77))
  call loop_AV_Q(G2(:,:,:,347),wf(:,-6),G2(:,:,:,350))
  call loop_A_Q(G2(:,:,:,350),Q(:,92),ZERO,G3(:,:,:,313))
  call loop_AV_Q(G3(:,:,:,313),wf(:,-5),G3(:,:,:,314))
  call loop_A_Q(G3(:,:,:,314),Q(:,124),ZERO,G4(:,:,:,143))
  call loop_AZ_Q(G4(:,:,:,143),wf(:,4),G4(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),ZERO,G5tensor(:,78))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,108))
  call loop_AV_Q(G1(:,:,:,108),wf(:,3),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,60),MB,G2(:,:,:,351))
  call loop_AV_Q(G2(:,:,:,351),wf(:,-6),G2(:,:,:,352))
  call loop_A_Q(G2(:,:,:,352),Q(:,124),MB,G3(:,:,:,315))
  call loop_AZ_Q(G3(:,:,:,315),wf(:,4),G3(:,:,:,316),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,127),MB,G4tensor(:,99))
  call loop_AV_Q(G1(:,:,:,108),wf(:,-6),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,76),MB,G2(:,:,:,353))
  call loop_AV_Q(G2(:,:,:,353),wf(:,3),G2(:,:,:,354))
  call loop_A_Q(G2(:,:,:,354),Q(:,124),MB,G3(:,:,:,317))
  call loop_AZ_Q(G3(:,:,:,317),wf(:,4),G3(:,:,:,318),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,318),Q(:,127),MB,G4tensor(:,100))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-4),G2(:,:,:,355))
  call loop_A_Q(G2(:,:,:,355),Q(:,92),MB,G3(:,:,:,319))
  call loop_AV_Q(G3(:,:,:,319),wf(:,-5),G3(:,:,:,320))
  call loop_A_Q(G3(:,:,:,320),Q(:,124),MB,G4(:,:,:,145))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,4),G4(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),MB,G5tensor(:,79))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-5),G2(:,:,:,356))
  call loop_A_Q(G2(:,:,:,356),Q(:,108),MB,G3(:,:,:,321))
  call loop_AV_Q(G3(:,:,:,321),wf(:,-4),G3(:,:,:,322))
  call loop_A_Q(G3(:,:,:,322),Q(:,124),MB,G4(:,:,:,147))
  call loop_AZ_Q(G4(:,:,:,147),wf(:,4),G4(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,127),MB,G5tensor(:,80))
  call loop_AV_Q(G1(:,:,:,108),wf(:,9),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,92),MB,G2(:,:,:,357))
  call loop_AV_Q(G2(:,:,:,357),wf(:,-5),G2(:,:,:,358))
  call loop_A_Q(G2(:,:,:,358),Q(:,124),MB,G3(:,:,:,323))
  call loop_AZ_Q(G3(:,:,:,323),wf(:,4),G3(:,:,:,324),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,127),MB,G4tensor(:,101))
  call loop_AV_Q(G1(:,:,:,108),wf(:,-5),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,44),MB,G2(:,:,:,359))
  call loop_AV_Q(G2(:,:,:,359),wf(:,9),G2(:,:,:,360))
  call loop_A_Q(G2(:,:,:,360),Q(:,124),MB,G3(:,:,:,325))
  call loop_AZ_Q(G3(:,:,:,325),wf(:,4),G3(:,:,:,326),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,326),Q(:,127),MB,G4tensor(:,102))
  call loop_AV_Q(G2(:,:,:,359),wf(:,-4),G2(:,:,:,361))
  call loop_A_Q(G2(:,:,:,361),Q(:,60),MB,G3(:,:,:,327))
  call loop_AV_Q(G3(:,:,:,327),wf(:,-6),G3(:,:,:,328))
  call loop_A_Q(G3(:,:,:,328),Q(:,124),MB,G4(:,:,:,149))
  call loop_AZ_Q(G4(:,:,:,149),wf(:,4),G4(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,127),MB,G5tensor(:,81))
  call loop_AV_Q(G2(:,:,:,359),wf(:,-6),G2(:,:,:,362))
  call loop_A_Q(G2(:,:,:,362),Q(:,108),MB,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,-4),G3(:,:,:,330))
  call loop_A_Q(G3(:,:,:,330),Q(:,124),MB,G4(:,:,:,151))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,4),G4(:,:,:,152),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),MB,G5tensor(:,82))
  call loop_AV_Q(G1(:,:,:,108),wf(:,12),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,108),MB,G2(:,:,:,363))
  call loop_AV_Q(G2(:,:,:,363),wf(:,-4),G2(:,:,:,364))
  call loop_A_Q(G2(:,:,:,364),Q(:,124),MB,G3(:,:,:,331))
  call loop_AZ_Q(G3(:,:,:,331),wf(:,4),G3(:,:,:,332),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,332),Q(:,127),MB,G4tensor(:,103))
  call loop_AV_Q(G1(:,:,:,108),wf(:,-4),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,28),MB,G2(:,:,:,365))
  call loop_AV_Q(G2(:,:,:,365),wf(:,12),G2(:,:,:,366))
  call loop_A_Q(G2(:,:,:,366),Q(:,124),MB,G3(:,:,:,333))
  call loop_AZ_Q(G3(:,:,:,333),wf(:,4),G3(:,:,:,334),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,334),Q(:,127),MB,G4tensor(:,104))
  call loop_AV_Q(G2(:,:,:,365),wf(:,-5),G2(:,:,:,367))
  call loop_A_Q(G2(:,:,:,367),Q(:,60),MB,G3(:,:,:,335))
  call loop_AV_Q(G3(:,:,:,335),wf(:,-6),G3(:,:,:,336))
  call loop_A_Q(G3(:,:,:,336),Q(:,124),MB,G4(:,:,:,153))
  call loop_AZ_Q(G4(:,:,:,153),wf(:,4),G4(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,127),MB,G5tensor(:,83))
  call loop_AV_Q(G2(:,:,:,365),wf(:,-6),G2(:,:,:,368))
  call loop_A_Q(G2(:,:,:,368),Q(:,92),MB,G3(:,:,:,337))
  call loop_AV_Q(G3(:,:,:,337),wf(:,-5),G3(:,:,:,338))
  call loop_A_Q(G3(:,:,:,338),Q(:,124),MB,G4(:,:,:,155))
  call loop_AZ_Q(G4(:,:,:,155),wf(:,4),G4(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,127),MB,G5tensor(:,84))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,12),ZERO,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,3),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,60),ZERO,G2(:,:,:,369))
  call loop_QV_A(G2(:,:,:,369),wf(:,-6),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,124),ZERO,G3(:,:,:,339))
  call loop_QZ_A(G3(:,:,:,339),wf(:,4),G3(:,:,:,340),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,127),ZERO,G4tensor(:,105))
  call loop_QV_A(G1(:,:,:,115),wf(:,-6),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,76),ZERO,G2(:,:,:,371))
  call loop_QV_A(G2(:,:,:,371),wf(:,3),G2(:,:,:,372))
  call loop_Q_A(G2(:,:,:,372),Q(:,124),ZERO,G3(:,:,:,341))
  call loop_QZ_A(G3(:,:,:,341),wf(:,4),G3(:,:,:,342),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,127),ZERO,G4tensor(:,106))
  call loop_QV_A(G2(:,:,:,371),wf(:,-4),G2(:,:,:,373))
  call loop_Q_A(G2(:,:,:,373),Q(:,92),ZERO,G3(:,:,:,343))
  call loop_QV_A(G3(:,:,:,343),wf(:,-5),G3(:,:,:,344))
  call loop_Q_A(G3(:,:,:,344),Q(:,124),ZERO,G4(:,:,:,157))
  call loop_QZ_A(G4(:,:,:,157),wf(:,4),G4(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,127),ZERO,G5tensor(:,85))
  call loop_QV_A(G2(:,:,:,371),wf(:,-5),G2(:,:,:,374))
  call loop_Q_A(G2(:,:,:,374),Q(:,108),ZERO,G3(:,:,:,345))
  call loop_QV_A(G3(:,:,:,345),wf(:,-4),G3(:,:,:,346))
  call loop_Q_A(G3(:,:,:,346),Q(:,124),ZERO,G4(:,:,:,159))
  call loop_QZ_A(G4(:,:,:,159),wf(:,4),G4(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,127),ZERO,G5tensor(:,86))
  call loop_QV_A(G1(:,:,:,115),wf(:,9),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,92),ZERO,G2(:,:,:,375))
  call loop_QV_A(G2(:,:,:,375),wf(:,-5),G2(:,:,:,376))
  call loop_Q_A(G2(:,:,:,376),Q(:,124),ZERO,G3(:,:,:,347))
  call loop_QZ_A(G3(:,:,:,347),wf(:,4),G3(:,:,:,348),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,127),ZERO,G4tensor(:,107))
  call loop_QV_A(G1(:,:,:,115),wf(:,-5),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,44),ZERO,G2(:,:,:,377))
  call loop_QV_A(G2(:,:,:,377),wf(:,9),G2(:,:,:,378))
  call loop_Q_A(G2(:,:,:,378),Q(:,124),ZERO,G3(:,:,:,349))
  call loop_QZ_A(G3(:,:,:,349),wf(:,4),G3(:,:,:,350),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,350),Q(:,127),ZERO,G4tensor(:,108))
  call loop_QV_A(G2(:,:,:,377),wf(:,-4),G2(:,:,:,379))
  call loop_Q_A(G2(:,:,:,379),Q(:,60),ZERO,G3(:,:,:,351))
  call loop_QV_A(G3(:,:,:,351),wf(:,-6),G3(:,:,:,352))
  call loop_Q_A(G3(:,:,:,352),Q(:,124),ZERO,G4(:,:,:,161))
  call loop_QZ_A(G4(:,:,:,161),wf(:,4),G4(:,:,:,162),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,162),Q(:,127),ZERO,G5tensor(:,87))
  call loop_QV_A(G2(:,:,:,377),wf(:,-6),G2(:,:,:,380))
  call loop_Q_A(G2(:,:,:,380),Q(:,108),ZERO,G3(:,:,:,353))
  call loop_QV_A(G3(:,:,:,353),wf(:,-4),G3(:,:,:,354))
  call loop_Q_A(G3(:,:,:,354),Q(:,124),ZERO,G4(:,:,:,163))
  call loop_QZ_A(G4(:,:,:,163),wf(:,4),G4(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,164),Q(:,127),ZERO,G5tensor(:,88))
  call loop_QV_A(G1(:,:,:,115),wf(:,12),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,108),ZERO,G2(:,:,:,381))
  call loop_QV_A(G2(:,:,:,381),wf(:,-4),G2(:,:,:,382))
  call loop_Q_A(G2(:,:,:,382),Q(:,124),ZERO,G3(:,:,:,355))
  call loop_QZ_A(G3(:,:,:,355),wf(:,4),G3(:,:,:,356),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,356),Q(:,127),ZERO,G4tensor(:,109))
  call loop_QV_A(G1(:,:,:,115),wf(:,-4),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,28),ZERO,G2(:,:,:,383))
  call loop_QV_A(G2(:,:,:,383),wf(:,12),G2(:,:,:,384))
  call loop_Q_A(G2(:,:,:,384),Q(:,124),ZERO,G3(:,:,:,357))
  call loop_QZ_A(G3(:,:,:,357),wf(:,4),G3(:,:,:,358),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,358),Q(:,127),ZERO,G4tensor(:,110))
  call loop_QV_A(G2(:,:,:,383),wf(:,-5),G2(:,:,:,385))
  call loop_Q_A(G2(:,:,:,385),Q(:,60),ZERO,G3(:,:,:,359))
  call loop_QV_A(G3(:,:,:,359),wf(:,-6),G3(:,:,:,360))
  call loop_Q_A(G3(:,:,:,360),Q(:,124),ZERO,G4(:,:,:,165))
  call loop_QZ_A(G4(:,:,:,165),wf(:,4),G4(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,166),Q(:,127),ZERO,G5tensor(:,89))
  call loop_QV_A(G2(:,:,:,383),wf(:,-6),G2(:,:,:,386))
  call loop_Q_A(G2(:,:,:,386),Q(:,92),ZERO,G3(:,:,:,361))
  call loop_QV_A(G3(:,:,:,361),wf(:,-5),G3(:,:,:,362))
  call loop_Q_A(G3(:,:,:,362),Q(:,124),ZERO,G4(:,:,:,167))
  call loop_QZ_A(G4(:,:,:,167),wf(:,4),G4(:,:,:,168),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,168),Q(:,127),ZERO,G5tensor(:,90))
  call loop_QZ_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,12),MB,G1(:,:,:,122))
  call loop_QV_A(G1(:,:,:,122),wf(:,3),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,60),MB,G2(:,:,:,387))
  call loop_QV_A(G2(:,:,:,387),wf(:,-6),G2(:,:,:,388))
  call loop_Q_A(G2(:,:,:,388),Q(:,124),MB,G3(:,:,:,363))
  call loop_QZ_A(G3(:,:,:,363),wf(:,4),G3(:,:,:,364),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,364),Q(:,127),MB,G4tensor(:,111))
  call loop_QV_A(G1(:,:,:,122),wf(:,-6),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,76),MB,G2(:,:,:,389))
  call loop_QV_A(G2(:,:,:,389),wf(:,3),G2(:,:,:,390))
  call loop_Q_A(G2(:,:,:,390),Q(:,124),MB,G3(:,:,:,365))
  call loop_QZ_A(G3(:,:,:,365),wf(:,4),G3(:,:,:,366),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,366),Q(:,127),MB,G4tensor(:,112))
  call loop_QV_A(G2(:,:,:,389),wf(:,-4),G2(:,:,:,391))
  call loop_Q_A(G2(:,:,:,391),Q(:,92),MB,G3(:,:,:,367))
  call loop_QV_A(G3(:,:,:,367),wf(:,-5),G3(:,:,:,368))
  call loop_Q_A(G3(:,:,:,368),Q(:,124),MB,G4(:,:,:,169))
  call loop_QZ_A(G4(:,:,:,169),wf(:,4),G4(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,127),MB,G5tensor(:,91))
  call loop_QV_A(G2(:,:,:,389),wf(:,-5),G2(:,:,:,392))
  call loop_Q_A(G2(:,:,:,392),Q(:,108),MB,G3(:,:,:,369))
  call loop_QV_A(G3(:,:,:,369),wf(:,-4),G3(:,:,:,370))
  call loop_Q_A(G3(:,:,:,370),Q(:,124),MB,G4(:,:,:,171))
  call loop_QZ_A(G4(:,:,:,171),wf(:,4),G4(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,172),Q(:,127),MB,G5tensor(:,92))
  call loop_QV_A(G1(:,:,:,122),wf(:,9),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,92),MB,G2(:,:,:,393))
  call loop_QV_A(G2(:,:,:,393),wf(:,-5),G2(:,:,:,394))
  call loop_Q_A(G2(:,:,:,394),Q(:,124),MB,G3(:,:,:,371))
  call loop_QZ_A(G3(:,:,:,371),wf(:,4),G3(:,:,:,372),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,372),Q(:,127),MB,G4tensor(:,113))
  call loop_QV_A(G1(:,:,:,122),wf(:,-5),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,44),MB,G2(:,:,:,395))
  call loop_QV_A(G2(:,:,:,395),wf(:,9),G2(:,:,:,396))
  call loop_Q_A(G2(:,:,:,396),Q(:,124),MB,G3(:,:,:,373))
  call loop_QZ_A(G3(:,:,:,373),wf(:,4),G3(:,:,:,374),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,374),Q(:,127),MB,G4tensor(:,114))
  call loop_QV_A(G2(:,:,:,395),wf(:,-4),G2(:,:,:,397))
  call loop_Q_A(G2(:,:,:,397),Q(:,60),MB,G3(:,:,:,375))
  call loop_QV_A(G3(:,:,:,375),wf(:,-6),G3(:,:,:,376))
  call loop_Q_A(G3(:,:,:,376),Q(:,124),MB,G4(:,:,:,173))
  call loop_QZ_A(G4(:,:,:,173),wf(:,4),G4(:,:,:,174),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,127),MB,G5tensor(:,93))
  call loop_QV_A(G2(:,:,:,395),wf(:,-6),G2(:,:,:,398))
  call loop_Q_A(G2(:,:,:,398),Q(:,108),MB,G3(:,:,:,377))
  call loop_QV_A(G3(:,:,:,377),wf(:,-4),G3(:,:,:,378))
  call loop_Q_A(G3(:,:,:,378),Q(:,124),MB,G4(:,:,:,175))
  call loop_QZ_A(G4(:,:,:,175),wf(:,4),G4(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,127),MB,G5tensor(:,94))
  call loop_QV_A(G1(:,:,:,122),wf(:,12),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,108),MB,G2(:,:,:,399))
  call loop_QV_A(G2(:,:,:,399),wf(:,-4),G2(:,:,:,400))
  call loop_Q_A(G2(:,:,:,400),Q(:,124),MB,G3(:,:,:,379))
  call loop_QZ_A(G3(:,:,:,379),wf(:,4),G3(:,:,:,380),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,380),Q(:,127),MB,G4tensor(:,115))
  call loop_QV_A(G1(:,:,:,122),wf(:,-4),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,28),MB,G2(:,:,:,401))
  call loop_QV_A(G2(:,:,:,401),wf(:,12),G2(:,:,:,402))
  call loop_Q_A(G2(:,:,:,402),Q(:,124),MB,G3(:,:,:,381))
  call loop_QZ_A(G3(:,:,:,381),wf(:,4),G3(:,:,:,382),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,382),Q(:,127),MB,G4tensor(:,116))
  call loop_QV_A(G2(:,:,:,401),wf(:,-5),G2(:,:,:,403))
  call loop_Q_A(G2(:,:,:,403),Q(:,60),MB,G3(:,:,:,383))
  call loop_QV_A(G3(:,:,:,383),wf(:,-6),G3(:,:,:,384))
  call loop_Q_A(G3(:,:,:,384),Q(:,124),MB,G4(:,:,:,177))
  call loop_QZ_A(G4(:,:,:,177),wf(:,4),G4(:,:,:,178),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,127),MB,G5tensor(:,95))
  call loop_QV_A(G2(:,:,:,401),wf(:,-6),G2(:,:,:,404))
  call loop_Q_A(G2(:,:,:,404),Q(:,92),MB,G3(:,:,:,385))
  call loop_QV_A(G3(:,:,:,385),wf(:,-5),G3(:,:,:,386))
  call loop_Q_A(G3(:,:,:,386),Q(:,124),MB,G4(:,:,:,179))
  call loop_QZ_A(G4(:,:,:,179),wf(:,4),G4(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,127),MB,G5tensor(:,96))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,32),MT,G1(:,:,:,129))
  call loop_AV_Q(G1(:,:,:,129),wf(:,9),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,112),MT,G2(:,:,:,405))
  call loop_AS_Q(G2(:,:,:,405),wf(:,61),G2(:,:,:,406),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,406),Q(:,127),MT,G3tensor(:,111))
  call loop_AV_Q(G2(:,:,:,405),wf(:,85),G2(:,:,:,407))
  call check_last_A_Q(l_switch,G2(:,:,:,407),Q(:,127),MT,G3tensor(:,112))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,86),G2(:,:,:,408),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,408),Q(:,127),MT,G3tensor(:,113))
  call loop_AV_Q(G2(:,:,:,405),wf(:,87),G2(:,:,:,409))
  call check_last_A_Q(l_switch,G2(:,:,:,409),Q(:,127),MT,G3tensor(:,114))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,88),G2(:,:,:,410),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,410),Q(:,127),MT,G3tensor(:,115))
  call loop_AS_Q(G2(:,:,:,405),wf(:,74),G2(:,:,:,411),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,411),Q(:,127),MT,G3tensor(:,116))
  call loop_AV_Q(G2(:,:,:,405),wf(:,43),G2(:,:,:,412))
  call check_last_A_Q(l_switch,G2(:,:,:,412),Q(:,127),MT,G3tensor(:,117))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,75),G2(:,:,:,413),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,413),Q(:,127),MT,G3tensor(:,118))
  call loop_AV_Q(G2(:,:,:,405),wf(:,89),G2(:,:,:,414))
  call check_last_A_Q(l_switch,G2(:,:,:,414),Q(:,127),MT,G3tensor(:,119))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,90),G2(:,:,:,415),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,415),Q(:,127),MT,G3tensor(:,120))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,91),G2(:,:,:,416),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,416),Q(:,127),MT,G3tensor(:,121))
  call loop_AV_Q(G2(:,:,:,405),wf(:,92),G2(:,:,:,417))
  call check_last_A_Q(l_switch,G2(:,:,:,417),Q(:,127),MT,G3tensor(:,122))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,93),G2(:,:,:,418),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,418),Q(:,127),MT,G3tensor(:,123))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,94),G2(:,:,:,419),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,419),Q(:,127),MT,G3tensor(:,124))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,95),G2(:,:,:,420),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,420),Q(:,127),MT,G3tensor(:,125))
  call loop_AZ_Q(G2(:,:,:,405),wf(:,96),G2(:,:,:,421),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,421),Q(:,127),MT,G3tensor(:,126))
  call loop_AV_Q(G1(:,:,:,129),wf(:,2),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,44),MT,G2(:,:,:,422))
  call loop_AV_Q(G2(:,:,:,422),wf(:,9),G2(:,:,:,423))
  call loop_A_Q(G2(:,:,:,423),Q(:,124),MT,G3(:,:,:,387))
  call loop_AZ_Q(G3(:,:,:,387),wf(:,4),G3(:,:,:,388),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,388),Q(:,127),MT,G4tensor(:,117))
  call loop_AV_Q(G2(:,:,:,422),wf(:,-4),G2(:,:,:,424))
  call loop_A_Q(G2(:,:,:,424),Q(:,60),MT,G3(:,:,:,389))
  call loop_AV_Q(G3(:,:,:,389),wf(:,-6),G3(:,:,:,390))
  call loop_A_Q(G3(:,:,:,390),Q(:,124),MT,G4(:,:,:,181))
  call loop_AZ_Q(G4(:,:,:,181),wf(:,4),G4(:,:,:,182),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,182),Q(:,127),MT,G5tensor(:,97))
  call loop_AZ_Q(G1(:,:,:,129),wf(:,7),G1(:,:,:,132),gZu)
  call loop_A_Q(G1(:,:,:,132),Q(:,44),MT,G2(:,:,:,425))
  call loop_AV_Q(G2(:,:,:,425),wf(:,9),G2(:,:,:,426))
  call loop_A_Q(G2(:,:,:,426),Q(:,124),MT,G3(:,:,:,391))
  call loop_AZ_Q(G3(:,:,:,391),wf(:,4),G3(:,:,:,392),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,392),Q(:,127),MT,G4tensor(:,118))
  call loop_AV_Q(G2(:,:,:,425),wf(:,-4),G2(:,:,:,427))
  call loop_A_Q(G2(:,:,:,427),Q(:,60),MT,G3(:,:,:,393))
  call loop_AV_Q(G3(:,:,:,393),wf(:,-6),G3(:,:,:,394))
  call loop_A_Q(G3(:,:,:,394),Q(:,124),MT,G4(:,:,:,183))
  call loop_AZ_Q(G4(:,:,:,183),wf(:,4),G4(:,:,:,184),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,184),Q(:,127),MT,G5tensor(:,98))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-4),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,48),MT,G2(:,:,:,428))
  call loop_AV_Q(G2(:,:,:,428),wf(:,-6),G2(:,:,:,429))
  call loop_A_Q(G2(:,:,:,429),Q(:,112),MT,G3(:,:,:,395))
  call loop_AS_Q(G3(:,:,:,395),wf(:,61),G3(:,:,:,396),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,396),Q(:,127),MT,G4tensor(:,119))
  call loop_AV_Q(G3(:,:,:,395),wf(:,85),G3(:,:,:,397))
  call check_last_A_Q(l_switch,G3(:,:,:,397),Q(:,127),MT,G4tensor(:,120))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,86),G3(:,:,:,398),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,398),Q(:,127),MT,G4tensor(:,121))
  call loop_AV_Q(G3(:,:,:,395),wf(:,87),G3(:,:,:,399))
  call check_last_A_Q(l_switch,G3(:,:,:,399),Q(:,127),MT,G4tensor(:,122))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,88),G3(:,:,:,400),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,400),Q(:,127),MT,G4tensor(:,123))
  call loop_AS_Q(G3(:,:,:,395),wf(:,74),G3(:,:,:,401),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,401),Q(:,127),MT,G4tensor(:,124))
  call loop_AV_Q(G3(:,:,:,395),wf(:,43),G3(:,:,:,402))
  call check_last_A_Q(l_switch,G3(:,:,:,402),Q(:,127),MT,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,75),G3(:,:,:,403),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,403),Q(:,127),MT,G4tensor(:,126))
  call loop_AV_Q(G3(:,:,:,395),wf(:,89),G3(:,:,:,404))
  call check_last_A_Q(l_switch,G3(:,:,:,404),Q(:,127),MT,G4tensor(:,127))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,90),G3(:,:,:,405),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,405),Q(:,127),MT,G4tensor(:,128))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,91),G3(:,:,:,406),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,406),Q(:,127),MT,G4tensor(:,129))
  call loop_AV_Q(G3(:,:,:,395),wf(:,92),G3(:,:,:,407))
  call check_last_A_Q(l_switch,G3(:,:,:,407),Q(:,127),MT,G4tensor(:,130))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,93),G3(:,:,:,408),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,408),Q(:,127),MT,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,94),G3(:,:,:,409),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,409),Q(:,127),MT,G4tensor(:,132))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,95),G3(:,:,:,410),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,410),Q(:,127),MT,G4tensor(:,133))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,96),G3(:,:,:,411),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,411),Q(:,127),MT,G4tensor(:,134))
  call loop_AV_Q(G2(:,:,:,428),wf(:,2),G2(:,:,:,430))
  call loop_A_Q(G2(:,:,:,430),Q(:,60),MT,G3(:,:,:,412))
  call loop_AV_Q(G3(:,:,:,412),wf(:,-6),G3(:,:,:,413))
  call loop_A_Q(G3(:,:,:,413),Q(:,124),MT,G4(:,:,:,185))
  call loop_AZ_Q(G4(:,:,:,185),wf(:,4),G4(:,:,:,186),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,186),Q(:,127),MT,G5tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,428),wf(:,7),G2(:,:,:,431),gZu)
  call loop_A_Q(G2(:,:,:,431),Q(:,60),MT,G3(:,:,:,414))
  call loop_AV_Q(G3(:,:,:,414),wf(:,-6),G3(:,:,:,415))
  call loop_A_Q(G3(:,:,:,415),Q(:,124),MT,G4(:,:,:,187))
  call loop_AZ_Q(G4(:,:,:,187),wf(:,4),G4(:,:,:,188),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,188),Q(:,127),MT,G5tensor(:,100))
  call loop_AW_Q(G2(:,:,:,428),wf(:,38),G2(:,:,:,432))
  call loop_A_Q(G2(:,:,:,432),Q(:,57),MB,G3(:,:,:,416))
  call loop_AV_Q(G3(:,:,:,416),wf(:,-6),G3(:,:,:,417))
  call loop_A_Q(G3(:,:,:,417),Q(:,121),MB,G4(:,:,:,189))
  call loop_AW_Q(G4(:,:,:,189),wf(:,39),G4(:,:,:,190))
  call check_last_A_Q(l_switch,G4(:,:,:,190),Q(:,127),MT,G5tensor(:,101))
  call loop_AW_Q(G1(:,:,:,129),wf(:,38),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,41),MB,G2(:,:,:,433))
  call loop_AV_Q(G2(:,:,:,433),wf(:,9),G2(:,:,:,434))
  call loop_A_Q(G2(:,:,:,434),Q(:,121),MB,G3(:,:,:,418))
  call loop_AW_Q(G3(:,:,:,418),wf(:,39),G3(:,:,:,419))
  call check_last_A_Q(l_switch,G3(:,:,:,419),Q(:,127),MT,G4tensor(:,135))
  call loop_AV_Q(G2(:,:,:,433),wf(:,-4),G2(:,:,:,435))
  call loop_A_Q(G2(:,:,:,435),Q(:,57),MB,G3(:,:,:,420))
  call loop_AV_Q(G3(:,:,:,420),wf(:,-6),G3(:,:,:,421))
  call loop_A_Q(G3(:,:,:,421),Q(:,121),MB,G4(:,:,:,191))
  call loop_AW_Q(G4(:,:,:,191),wf(:,39),G4(:,:,:,192))
  call check_last_A_Q(l_switch,G4(:,:,:,192),Q(:,127),MT,G5tensor(:,102))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(46)) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(46) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(46)) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(46) * den(53)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(44)) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(44) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(44)) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(44) * den(53)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,11),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,11),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,3),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,16),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,16),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,1),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,12),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,12),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,17),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,13),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,4),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,18),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,18),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_24,masses2_9,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,14),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,14),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,19),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_24,masses2_10,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,21),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,21),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,33),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,33),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,39),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,39),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,51),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,51),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,22),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,22),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,57),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,57),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,40),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,40),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,63),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,63),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,69),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,69),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,75),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,75),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,81),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,81),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,87),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,87),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,93),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,93),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,99),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,99),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,105),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,105),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,111),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,111),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,41),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,41),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,52),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,52),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(15)) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,23),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(15) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,34),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(13) * den(111)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,34),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,42),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,42),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,64),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,64),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(13) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,24),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(13)) * den(111)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,24),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(12) * den(111)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,58),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(12)) * den(111)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,58),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,82),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,82),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,88),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,88),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,70),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,70),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,76),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_13,masses2_9,G4tensor(:,76),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,106),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,106),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,112),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,112),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(16) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,94),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(16)) * den(112)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,94),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(14) * den(112)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,100),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,100),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(46) * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(46)) * den(54)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,111),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_21,masses2_9,G4tensor(:,117),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_21,masses2_9,G4tensor(:,117),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_21,masses2_9,G4tensor(:,118),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_21,masses2_9,G4tensor(:,118),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,25),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,25),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,35),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,35),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,43),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,43),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,53),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,53),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,26),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(13) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,26),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(12)) * den(113)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,59),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(12) * den(113)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,59),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,44),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(13) * den(113)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,44),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(12)) * den(113)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,65),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(12) * den(113)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,65),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,71),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,71),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,77),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,77),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,83),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,83),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,89),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,89),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,95),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,95),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,101),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,101),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,107),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,107),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,113),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,113),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,45),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,45),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,54),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,54),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,27),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,27),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,36),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,36),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,46),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(13) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,46),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(12)) * den(113)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,66),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(12) * den(113)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,66),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,28),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(13) * den(113)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,28),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(12)) * den(113)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,60),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(12) * den(113)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,60),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,84),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,84),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,90),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,90),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,72),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,72),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,78),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,78),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,108),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,108),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,114),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,114),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(16)) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,96),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(16) * den(114)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,96),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(14)) * den(114)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,102),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(14) * den(114)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,102),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,29),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,29),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,37),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(13) * den(115)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,37),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,47),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,47),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,55),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(13) * den(115)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,55),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,30),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,30),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(12) * den(115)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,61),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(12)) * den(115)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,61),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,48),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,48),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(12) * den(115)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,67),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(12)) * den(115)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,67),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,73),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,73),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,79),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,79),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,85),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,85),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,91),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_15,masses2_9,G4tensor(:,91),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,97),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,97),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,103),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,103),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,109),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,109),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,115),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,115),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,49),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,49),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,56),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(13) * den(115)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,56),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,31),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,31),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,38),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(13) * den(115)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,38),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,50),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,50),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(12) * den(115)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,68),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(12)) * den(115)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,68),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,32),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,32),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(12) * den(115)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(12)) * den(115)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,86),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,86),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,92),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,92),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,74),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,74),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,80),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_10,masses2_9,G4tensor(:,80),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,110),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,110),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,116),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,116),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,98),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,98),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,104),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,104),T4sum(1:70,27))
  M(2) = M(2) + (f(47) * den(52)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,119),T4sum(1:70,28))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_35,masses2_18,G5tensor(:,13),T5sum(1:126,2))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,19),T5sum(1:126,1))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_35,masses2_18,G5tensor(:,31),T5sum(1:126,2))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,2),T5sum(1:126,1))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_35,masses2_11,G5tensor(:,37),T5sum(1:126,3))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,20),T5sum(1:126,1))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_35,masses2_11,G5tensor(:,43),T5sum(1:126,3))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,49),T5sum(1:126,1))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_35,masses2_18,G5tensor(:,55),T5sum(1:126,2))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,61),T5sum(1:126,1))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_35,masses2_18,G5tensor(:,67),T5sum(1:126,2))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,73),T5sum(1:126,1))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_35,masses2_11,G5tensor(:,79),T5sum(1:126,3))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_35,masses2_19,G5tensor(:,85),T5sum(1:126,1))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_35,masses2_11,G5tensor(:,91),T5sum(1:126,3))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,23),T5sum(1:126,4))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_33,masses2_18,G5tensor(:,33),T5sum(1:126,5))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,5),T5sum(1:126,4))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_33,masses2_18,G5tensor(:,15),T5sum(1:126,5))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,24),T5sum(1:126,4))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_33,masses2_11,G5tensor(:,45),T5sum(1:126,6))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,6),T5sum(1:126,4))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_33,masses2_11,G5tensor(:,39),T5sum(1:126,6))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,63),T5sum(1:126,4))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_33,masses2_18,G5tensor(:,69),T5sum(1:126,5))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,51),T5sum(1:126,4))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_33,masses2_18,G5tensor(:,57),T5sum(1:126,5))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,87),T5sum(1:126,4))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_33,masses2_11,G5tensor(:,93),T5sum(1:126,6))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_33,masses2_19,G5tensor(:,75),T5sum(1:126,4))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_33,masses2_11,G5tensor(:,81),T5sum(1:126,6))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,21),T5sum(1:126,7))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_36,masses2_18,G5tensor(:,32),T5sum(1:126,8))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,3),T5sum(1:126,7))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_36,masses2_18,G5tensor(:,14),T5sum(1:126,8))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,22),T5sum(1:126,7))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_36,masses2_11,G5tensor(:,44),T5sum(1:126,9))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,4),T5sum(1:126,7))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_36,masses2_11,G5tensor(:,38),T5sum(1:126,9))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,62),T5sum(1:126,7))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_36,masses2_18,G5tensor(:,68),T5sum(1:126,8))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,50),T5sum(1:126,7))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_36,masses2_18,G5tensor(:,56),T5sum(1:126,8))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,86),T5sum(1:126,7))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_36,masses2_11,G5tensor(:,92),T5sum(1:126,9))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_36,masses2_19,G5tensor(:,74),T5sum(1:126,7))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_36,masses2_11,G5tensor(:,80),T5sum(1:126,9))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,9),T5sum(1:126,13))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_31,masses2_18,G5tensor(:,17),T5sum(1:126,14))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,27),T5sum(1:126,13))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_31,masses2_18,G5tensor(:,35),T5sum(1:126,14))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,10),T5sum(1:126,13))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_31,masses2_11,G5tensor(:,41),T5sum(1:126,15))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,28),T5sum(1:126,13))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_31,masses2_11,G5tensor(:,47),T5sum(1:126,15))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,53),T5sum(1:126,13))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_31,masses2_18,G5tensor(:,59),T5sum(1:126,14))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,65),T5sum(1:126,13))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_31,masses2_18,G5tensor(:,71),T5sum(1:126,14))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,77),T5sum(1:126,13))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_31,masses2_11,G5tensor(:,83),T5sum(1:126,15))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_31,masses2_19,G5tensor(:,89),T5sum(1:126,13))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_31,masses2_11,G5tensor(:,95),T5sum(1:126,15))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_48,masses2_18,G5tensor(:,99),T5sum(1:126,17))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_48,masses2_18,G5tensor(:,100),T5sum(1:126,17))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,25),T5sum(1:126,19))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_34,masses2_18,G5tensor(:,34),T5sum(1:126,20))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,7),T5sum(1:126,19))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_34,masses2_18,G5tensor(:,16),T5sum(1:126,20))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,26),T5sum(1:126,19))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_34,masses2_11,G5tensor(:,46),T5sum(1:126,21))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,8),T5sum(1:126,19))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_34,masses2_11,G5tensor(:,40),T5sum(1:126,21))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,64),T5sum(1:126,19))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_34,masses2_18,G5tensor(:,70),T5sum(1:126,20))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,52),T5sum(1:126,19))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_34,masses2_18,G5tensor(:,58),T5sum(1:126,20))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,88),T5sum(1:126,19))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_34,masses2_11,G5tensor(:,94),T5sum(1:126,21))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_34,masses2_19,G5tensor(:,76),T5sum(1:126,19))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_34,masses2_11,G5tensor(:,82),T5sum(1:126,21))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,11),T5sum(1:126,25))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_32,masses2_18,G5tensor(:,18),T5sum(1:126,26))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,29),T5sum(1:126,25))
  M(1) = M(1) + (f(18) * den(4)) * TI2_call(5,momenta_32,masses2_18,G5tensor(:,36),T5sum(1:126,26))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,12),T5sum(1:126,25))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_32,masses2_11,G5tensor(:,42),T5sum(1:126,27))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,30),T5sum(1:126,25))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_32,masses2_11,G5tensor(:,48),T5sum(1:126,27))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,54),T5sum(1:126,25))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_32,masses2_18,G5tensor(:,60),T5sum(1:126,26))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,66),T5sum(1:126,25))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_32,masses2_18,G5tensor(:,72),T5sum(1:126,26))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,78),T5sum(1:126,25))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_32,masses2_11,G5tensor(:,84),T5sum(1:126,27))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_32,masses2_19,G5tensor(:,90),T5sum(1:126,25))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_32,masses2_11,G5tensor(:,96),T5sum(1:126,27))
  M(2) = M(2) + (f(18) * den(4)) * TI2_call(5,momenta_46,masses2_18,G5tensor(:,97),T5sum(1:126,29))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_46,masses2_18,G5tensor(:,98),T5sum(1:126,29))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(13) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(13)) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(12) * den(117)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(12)) * den(117)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(13) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(13)) * den(117)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(12) * den(117)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(12)) * den(117)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,66),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,66),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(118)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(118)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(118)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(118)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(118)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(118)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(118)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(118)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(118)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(15)) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(15) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(13)) * den(119)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(119)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(15)) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(15) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(13)) * den(119)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(13) * den(119)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(13) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(13)) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(12) * den(119)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(12)) * den(119)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(13) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(13)) * den(119)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(12) * den(119)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(12)) * den(119)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(120)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(120)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,92),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,92),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(120)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(120)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(120)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(120)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(120)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(120)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(120)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,112),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(14)) * den(122)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(14) * den(122)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,113),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(13) * den(123)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(13)) * den(123)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,114),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(14)) * den(124)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(14) * den(124)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,115),T3sum(1:35,3))
  M(2) = M(2) + (f(18) * den(98)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,120),T4sum(1:70,28))
  M(2) = M(2) + (-f(19) * den(99)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,121),T4sum(1:70,28))
  M(2) = M(2) + (f(18) * den(100)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,122),T4sum(1:70,28))
  M(2) = M(2) + (-f(19) * den(101)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,123),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(28) * den(67)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(28)) * den(67)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(28) * den(67)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(28)) * den(67)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(26) * den(67)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(26)) * den(67)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(26) * den(67)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(26)) * den(67)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(37)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(37) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(35)) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(35) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(37)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(37) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(35)) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(35) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(35) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(35)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(34) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(34)) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(35) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(35)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(34) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(34)) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(31)) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,95),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(31) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,95),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(30)) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(30) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(31)) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(31) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(30)) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(30) * den(70)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(31)) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(31) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(30)) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(30) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(31)) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(31) * den(70)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(30)) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(30) * den(70)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_23,masses2_10,G4tensor(:,20),T4sum(1:70,37))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_23,masses2_10,G4tensor(:,20),T4sum(1:70,37))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,8),T4sum(1:70,38))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,8),T4sum(1:70,38))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_23,masses2_10,G4tensor(:,15),T4sum(1:70,37))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_23,masses2_10,G4tensor(:,15),T4sum(1:70,37))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_23,masses2_7,G4tensor(:,5),T4sum(1:70,39))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_23,masses2_7,G4tensor(:,5),T4sum(1:70,39))
  M(1) = M(1) + (-(CI*f(28)) * den(71)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(28) * den(71)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,116),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(35) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(35)) * den(131)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,117),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(30) * den(72)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(30)) * den(72)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,118),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(22) * den(132)) * TI2_call(4,momenta_20,masses2_7,G4tensor(:,135),T4sum(1:70,47))
  M(2) = M(2) + (-(CI*f(22)) * den(132)) * TI2_call(4,momenta_20,masses2_7,G4tensor(:,135),T4sum(1:70,47))
  M(2) = M(2) + (-f(29) * den(66)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,124),T4sum(1:70,28))
  M(2) = M(2) + (f(40) * den(102)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,125),T4sum(1:70,28))
  M(2) = M(2) + (f(32) * den(69)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,126),T4sum(1:70,28))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_47,masses2_16,G5tensor(:,101),T5sum(1:126,47))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_45,masses2_15,G5tensor(:,102),T5sum(1:126,60))
  M(1) = M(1) + (CI*f(37) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(37)) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(35) * den(135)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(35)) * den(135)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(37) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(37)) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(35) * den(135)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(35)) * den(135)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(35)) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(35) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(34)) * den(135)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(34) * den(135)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(35)) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(35) * den(135)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(34)) * den(135)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(34) * den(135)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(136)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(136)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,98),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,98),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(136)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(136)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(136)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(136)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(136)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(136)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(136)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(137)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(137)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,100),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,100),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(137)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(137)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(137)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(137)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,101),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(137)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,101),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(137)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(137)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(35)) * den(138)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(35) * den(138)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,119),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(36) * den(139)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(36)) * den(139)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,120),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(36) * den(140)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(36)) * den(140)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,121),T3sum(1:35,3))
  M(2) = M(2) + (-f(40) * den(103)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,127),T4sum(1:70,28))
  M(2) = M(2) + (f(41) * den(104)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,128),T4sum(1:70,28))
  M(2) = M(2) + (f(41) * den(105)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,129),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(37) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(37)) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(35) * den(144)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(35)) * den(144)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(37) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(37)) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(35) * den(144)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(35)) * den(144)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(35)) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(35) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(34)) * den(144)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(34) * den(144)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(35)) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(35) * den(144)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(34)) * den(144)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(34) * den(144)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,80),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,80),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(145)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(145)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(145)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(145)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(145)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(145)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,104),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(145)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,104),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(145)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(145)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,82),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,82),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(36) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(38)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,83),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,83),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(38)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,106),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(38) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,106),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(36)) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(36) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(35)) * den(147)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(35) * den(147)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,122),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(36) * den(148)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(36)) * den(148)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,123),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(36) * den(149)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(36)) * den(149)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,124),T3sum(1:35,3))
  M(2) = M(2) + (-f(40) * den(106)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,130),T4sum(1:70,28))
  M(2) = M(2) + (f(41) * den(107)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,131),T4sum(1:70,28))
  M(2) = M(2) + (f(41) * den(108)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,132),T4sum(1:70,28))
  M(1) = M(1) + (CI*f(16) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,107),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,107),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,109),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,109),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(16) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(16) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,110),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(16)) * den(154)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,110),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(14) * den(154)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(14)) * den(154)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(14) * den(155)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,125),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(14)) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(14) * den(156)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,126),T3sum(1:35,3))
  M(2) = M(2) + (-f(19) * den(109)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,133),T4sum(1:70,28))
  M(2) = M(2) + (-f(19) * den(110)) * TI2_call(4,momenta_22,masses2_9,G4tensor(:,134),T4sum(1:70,28))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nenexeexggg_1_/**/REALKIND
