
module ol_vamp_1_ppllllj2_nenenexnexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenenexnexuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenenexnexuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenenexnexuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenenexnexuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,23) :: G0
  complex(REALKIND), dimension(4,5,4,76) :: G1
  complex(REALKIND), dimension(4,15,4,174) :: G2
  complex(REALKIND), dimension(4,35,4,96) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,72,128))
    allocate(G4tensorhel(70,48,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,12),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,69),G2(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,70),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QS_A(G2(:,:,:,1),wf(:,36),G2(:,:,:,5),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,71),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,1),wf(:,72),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,73),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,1),wf(:,76),G2(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3),gZu)
  call loop_Q_A(G1(:,:,:,3),Q(:,58),MT,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,-6),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,122),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,9),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,57),MT,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-6),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,121),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,10),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,16))
  call loop_AS_Q(G2(:,:,:,16),wf(:,12),G2(:,:,:,17),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,69),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,70),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,13))
  call loop_AS_Q(G2(:,:,:,16),wf(:,36),G2(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,71),G2(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),MT,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,72),G2(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,73),G2(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,74),G2(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,75),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,76),G2(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,5),G1(:,:,:,7),gZu)
  call loop_A_Q(G1(:,:,:,7),Q(:,58),MT,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-6),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,122),MT,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,9),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,57),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-6),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,121),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,10),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,31))
  call loop_QS_A(G2(:,:,:,31),wf(:,12),G2(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,31),wf(:,69),G2(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,127),MB,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,31),wf(:,70),G2(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,127),MB,G3tensor(:,23))
  call loop_QS_A(G2(:,:,:,31),wf(:,36),G2(:,:,:,35),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,127),MB,G3tensor(:,24))
  call loop_QZ_A(G2(:,:,:,31),wf(:,71),G2(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,127),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,31),wf(:,72),G2(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,127),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,31),wf(:,73),G2(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,127),MB,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,31),wf(:,74),G2(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,127),MB,G3tensor(:,28))
  call loop_QZ_A(G2(:,:,:,31),wf(:,75),G2(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,127),MB,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,31),wf(:,76),G2(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,127),MB,G3tensor(:,30))
  call loop_QZ_A(G1(:,:,:,9),wf(:,5),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,58),MB,G2(:,:,:,42))
  call loop_QV_A(G2(:,:,:,42),wf(:,-6),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,122),MB,G3(:,:,:,9))
  call loop_QZ_A(G3(:,:,:,9),wf(:,4),G3(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,127),MB,G4tensor(:,5))
  call loop_QZ_A(G1(:,:,:,9),wf(:,9),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,57),MB,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,-6),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,121),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,10),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,46))
  call loop_AS_Q(G2(:,:,:,46),wf(:,12),G2(:,:,:,47),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,69),G2(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,70),G2(:,:,:,49),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,33))
  call loop_AS_Q(G2(:,:,:,46),wf(:,36),G2(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,71),G2(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,72),G2(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,36))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,73),G2(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,74),G2(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,75),G2(:,:,:,55),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,76),G2(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,40))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,58),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-6),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,122),MB,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,9),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,57),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,121),MB,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,10),G3(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,18),gZu)
  call loop_A_Q(G1(:,:,:,18),Q(:,58),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-6),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,122),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,19),gZd)
  call loop_A_Q(G1(:,:,:,19),Q(:,58),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-6),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,122),ZERO,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,112),ZERO,G2(:,:,:,65))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,69),G2(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,69),G2(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,70),G2(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,70),G2(:,:,:,69),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,71),G2(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,71),G2(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,72),G2(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,72),G2(:,:,:,73),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,73),G2(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,73),G2(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,74),G2(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,74),G2(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,75),G2(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,75),G2(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,76),G2(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,76),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,9),G1(:,:,:,21),gZu)
  call loop_A_Q(G1(:,:,:,21),Q(:,57),ZERO,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-6),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,121),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,10),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,9),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,57),ZERO,G2(:,:,:,84))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-6),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,121),ZERO,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,10),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,23))
  call loop_QZ_A(G1(:,:,:,23),wf(:,5),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,58),ZERO,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-6),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,122),ZERO,G3(:,:,:,25))
  call loop_QZ_A(G3(:,:,:,25),wf(:,4),G3(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,13))
  call loop_QZ_A(G1(:,:,:,23),wf(:,5),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,58),ZERO,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,-6),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,122),ZERO,G3(:,:,:,27))
  call loop_QZ_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,14))
  call loop_QV_A(G1(:,:,:,23),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),ZERO,G2(:,:,:,90))
  call loop_QZ_A(G2(:,:,:,90),wf(:,69),G2(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),ZERO,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,90),wf(:,69),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),ZERO,G3tensor(:,58))
  call loop_QZ_A(G2(:,:,:,90),wf(:,70),G2(:,:,:,93),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,127),ZERO,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,90),wf(:,70),G2(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,127),ZERO,G3tensor(:,60))
  call loop_QZ_A(G2(:,:,:,90),wf(:,71),G2(:,:,:,95),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,95),Q(:,127),ZERO,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,90),wf(:,71),G2(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,62))
  call loop_QZ_A(G2(:,:,:,90),wf(:,72),G2(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,90),wf(:,72),G2(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,64))
  call loop_QZ_A(G2(:,:,:,90),wf(:,73),G2(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,65))
  call loop_QZ_A(G2(:,:,:,90),wf(:,73),G2(:,:,:,100),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,90),wf(:,74),G2(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,90),wf(:,74),G2(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,68))
  call loop_QZ_A(G2(:,:,:,90),wf(:,75),G2(:,:,:,103),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,69))
  call loop_QZ_A(G2(:,:,:,90),wf(:,75),G2(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,90),wf(:,76),G2(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,71))
  call loop_QZ_A(G2(:,:,:,90),wf(:,76),G2(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,72))
  call loop_QZ_A(G1(:,:,:,23),wf(:,9),G1(:,:,:,27),gZu)
  call loop_Q_A(G1(:,:,:,27),Q(:,57),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-6),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,121),ZERO,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,10),G3(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,15))
  call loop_QZ_A(G1(:,:,:,23),wf(:,9),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,57),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,-6),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,121),ZERO,G3(:,:,:,31))
  call loop_QZ_A(G3(:,:,:,31),wf(:,10),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,3),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,58),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-6),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,122),ZERO,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,4),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-6),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,74),ZERO,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,122),ZERO,G3(:,:,:,35))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,4),G3(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,3),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,58),MT,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-6),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,122),MT,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,4),G3(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MT,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-6),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,74),MT,G2(:,:,:,117))
  call loop_AV_Q(G2(:,:,:,117),wf(:,3),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,122),MT,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,4),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MT,G4tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZu)
  call loop_Q_A(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,3),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,58),ZERO,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,-6),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,122),ZERO,G3(:,:,:,41))
  call loop_QZ_A(G3(:,:,:,41),wf(:,4),G3(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,127),ZERO,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,35),wf(:,-6),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,74),ZERO,G2(:,:,:,121))
  call loop_QV_A(G2(:,:,:,121),wf(:,3),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,122),ZERO,G3(:,:,:,43))
  call loop_QZ_A(G3(:,:,:,43),wf(:,4),G3(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,22))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,11),gZu)
  call loop_Q_A(G0(:,:,:,11),Q(:,10),MT,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,3),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,58),MT,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,-6),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,122),MT,G3(:,:,:,45))
  call loop_QZ_A(G3(:,:,:,45),wf(:,4),G3(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,127),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,38),wf(:,-6),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,74),MT,G2(:,:,:,125))
  call loop_QV_A(G2(:,:,:,125),wf(:,3),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,122),MT,G3(:,:,:,47))
  call loop_QZ_A(G3(:,:,:,47),wf(:,4),G3(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,10),ZERO,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,3),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,58),ZERO,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-6),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,122),ZERO,G3(:,:,:,49))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-6),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,74),ZERO,G2(:,:,:,129))
  call loop_AV_Q(G2(:,:,:,129),wf(:,3),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,122),ZERO,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,4),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,26))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,10),MB,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,58),MB,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-6),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,122),MB,G3(:,:,:,53))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,4),G3(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),MB,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-6),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,74),MB,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,3),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,122),MB,G3(:,:,:,55))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,4),G3(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),MB,G4tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,14),gZd)
  call loop_Q_A(G0(:,:,:,14),Q(:,10),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,3),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,58),ZERO,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,-6),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,122),ZERO,G3(:,:,:,57))
  call loop_QZ_A(G3(:,:,:,57),wf(:,4),G3(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,47),wf(:,-6),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,74),ZERO,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,3),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,122),ZERO,G3(:,:,:,59))
  call loop_QZ_A(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,15),gZd)
  call loop_Q_A(G0(:,:,:,15),Q(:,10),MB,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,3),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,58),MB,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,-6),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,122),MB,G3(:,:,:,61))
  call loop_QZ_A(G3(:,:,:,61),wf(:,4),G3(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,127),MB,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,50),wf(:,-6),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,74),MB,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,3),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,122),MB,G3(:,:,:,63))
  call loop_QZ_A(G3(:,:,:,63),wf(:,4),G3(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,127),MB,G4tensor(:,32))
  call loop_QZ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,9),ZERO,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-6),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,73),ZERO,G2(:,:,:,143))
  call loop_QV_A(G2(:,:,:,143),wf(:,3),G2(:,:,:,144))
  call loop_Q_A(G2(:,:,:,144),Q(:,121),ZERO,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,10),G3(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,53),wf(:,3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,57),ZERO,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-6),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,121),ZERO,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,10),G3(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,34))
  call loop_QZ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,9),MT,G1(:,:,:,56))
  call loop_QV_A(G1(:,:,:,56),wf(:,-6),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,73),MT,G2(:,:,:,147))
  call loop_QV_A(G2(:,:,:,147),wf(:,3),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,121),MT,G3(:,:,:,69))
  call loop_QZ_A(G3(:,:,:,69),wf(:,10),G3(:,:,:,70),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),MT,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,56),wf(:,3),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,57),MT,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,-6),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,121),MT,G3(:,:,:,71))
  call loop_QZ_A(G3(:,:,:,71),wf(:,10),G3(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,36))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,18),gZu)
  call loop_A_Q(G0(:,:,:,18),Q(:,9),ZERO,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-6),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,73),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,3),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,121),ZERO,G3(:,:,:,73))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,10),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,59),wf(:,3),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,57),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-6),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,121),ZERO,G3(:,:,:,75))
  call loop_AZ_Q(G3(:,:,:,75),wf(:,10),G3(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,19),gZu)
  call loop_A_Q(G0(:,:,:,19),Q(:,9),MT,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-6),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,73),MT,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,3),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,121),MT,G3(:,:,:,77))
  call loop_AZ_Q(G3(:,:,:,77),wf(:,10),G3(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),MT,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,62),wf(:,3),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,57),MT,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-6),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,121),MT,G3(:,:,:,79))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,10),G3(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,40))
  call loop_QZ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,9),ZERO,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-6),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,73),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,3),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,121),ZERO,G3(:,:,:,81))
  call loop_QZ_A(G3(:,:,:,81),wf(:,10),G3(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,41))
  call loop_QV_A(G1(:,:,:,65),wf(:,3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,57),ZERO,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,-6),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,121),ZERO,G3(:,:,:,83))
  call loop_QZ_A(G3(:,:,:,83),wf(:,10),G3(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,9),MB,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,-6),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,73),MB,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,3),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,121),MB,G3(:,:,:,85))
  call loop_QZ_A(G3(:,:,:,85),wf(:,10),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),MB,G4tensor(:,43))
  call loop_QV_A(G1(:,:,:,68),wf(:,3),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,57),MB,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,-6),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,121),MB,G3(:,:,:,87))
  call loop_QZ_A(G3(:,:,:,87),wf(:,10),G3(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,127),MB,G4tensor(:,44))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,22),gZd)
  call loop_A_Q(G0(:,:,:,22),Q(:,9),ZERO,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-6),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,73),ZERO,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,3),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,121),ZERO,G3(:,:,:,89))
  call loop_AZ_Q(G3(:,:,:,89),wf(:,10),G3(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,71),wf(:,3),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,57),ZERO,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,121),ZERO,G3(:,:,:,91))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,10),G3(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,23),gZd)
  call loop_A_Q(G0(:,:,:,23),Q(:,9),MB,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-6),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,73),MB,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,3),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,121),MB,G3(:,:,:,93))
  call loop_AZ_Q(G3(:,:,:,93),wf(:,10),G3(:,:,:,94),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,127),MB,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,74),wf(:,3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,57),MB,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-6),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,121),MB,G3(:,:,:,95))
  call loop_AZ_Q(G3(:,:,:,95),wf(:,10),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,14),T4sum(1:70,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,5),T4sum(1:70,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,19),T4sum(1:70,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,21),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,23),T4sum(1:70,5))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,25),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,27),T4sum(1:70,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,29),T4sum(1:70,4))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,31),T4sum(1:70,6))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,22),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,24),T4sum(1:70,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,18),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,20),T4sum(1:70,8))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,30),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,32),T4sum(1:70,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,26),T4sum(1:70,7))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(78)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,28),T4sum(1:70,9))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,15),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,2),T4sum(1:70,11))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,11),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,4),T4sum(1:70,11))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,16),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,6),T4sum(1:70,12))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,12),T4sum(1:70,10))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,8),T4sum(1:70,12))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,33),T4sum(1:70,13))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,35),T4sum(1:70,14))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,37),T4sum(1:70,13))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,39),T4sum(1:70,14))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,41),T4sum(1:70,13))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,43),T4sum(1:70,15))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,45),T4sum(1:70,13))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,47),T4sum(1:70,15))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,38),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,40),T4sum(1:70,17))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,34),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,36),T4sum(1:70,17))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,46),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,48),T4sum(1:70,18))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,42),T4sum(1:70,16))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,44),T4sum(1:70,18))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(82)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,63),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,64),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(83)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,65),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,66),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(84)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,67),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,68),T3sum(1:35,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,70),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,3))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nenenexnexuuxg_1_/**/REALKIND
