
module ol_vamp_1_ppllllj2_nenenexnexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenenexnexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenenexnexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenenexnexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenenexnexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,21) :: G0
  complex(REALKIND), dimension(4,5,4,118) :: G1
  complex(REALKIND), dimension(4,15,4,408) :: G2
  complex(REALKIND), dimension(4,35,4,398) :: G3
  complex(REALKIND), dimension(4,70,4,160) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,144,128))
    allocate(G4tensorhel(70,152,128))
    allocate(G5tensorhel(126,80,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,46),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,69),G2(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,70),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QS_A(G2(:,:,:,1),wf(:,59),G2(:,:,:,5),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,71),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,1),wf(:,72),G2(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,73),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,1),wf(:,76),G2(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,3),gZu)
  call loop_Q_A(G1(:,:,:,3),Q(:,58),MT,G2(:,:,:,12))
  call loop_QV_A(G2(:,:,:,12),wf(:,-6),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,122),MT,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,26),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,57),MT,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-6),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,121),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,27),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,16))
  call loop_AS_Q(G2(:,:,:,16),wf(:,46),G2(:,:,:,17),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,69),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,70),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,13))
  call loop_AS_Q(G2(:,:,:,16),wf(:,59),G2(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,71),G2(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),MT,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,72),G2(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,73),G2(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,74),G2(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,75),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,76),G2(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,5),G1(:,:,:,7),gZu)
  call loop_A_Q(G1(:,:,:,7),Q(:,58),MT,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-6),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,122),MT,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,4),G3(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,26),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,57),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-6),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,121),MT,G3(:,:,:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,27),G3(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,31))
  call loop_QS_A(G2(:,:,:,31),wf(:,46),G2(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,31),wf(:,69),G2(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,127),MB,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,31),wf(:,70),G2(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,127),MB,G3tensor(:,23))
  call loop_QS_A(G2(:,:,:,31),wf(:,59),G2(:,:,:,35),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,127),MB,G3tensor(:,24))
  call loop_QZ_A(G2(:,:,:,31),wf(:,71),G2(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,127),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,31),wf(:,72),G2(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,127),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,31),wf(:,73),G2(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,127),MB,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,31),wf(:,74),G2(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,127),MB,G3tensor(:,28))
  call loop_QZ_A(G2(:,:,:,31),wf(:,75),G2(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,127),MB,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,31),wf(:,76),G2(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,127),MB,G3tensor(:,30))
  call loop_QZ_A(G1(:,:,:,9),wf(:,5),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,58),MB,G2(:,:,:,42))
  call loop_QV_A(G2(:,:,:,42),wf(:,-6),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,122),MB,G3(:,:,:,9))
  call loop_QZ_A(G3(:,:,:,9),wf(:,4),G3(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,127),MB,G4tensor(:,5))
  call loop_QZ_A(G1(:,:,:,9),wf(:,26),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,57),MB,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,-6),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,121),MB,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,27),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,46))
  call loop_AS_Q(G2(:,:,:,46),wf(:,46),G2(:,:,:,47),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,69),G2(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,70),G2(:,:,:,49),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,33))
  call loop_AS_Q(G2(:,:,:,46),wf(:,59),G2(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,71),G2(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,72),G2(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,36))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,73),G2(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,74),G2(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,75),G2(:,:,:,55),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,76),G2(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,40))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,58),MB,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-6),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,122),MB,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,4),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,26),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,57),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,121),MB,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,27),G3(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,18),gZu)
  call loop_A_Q(G1(:,:,:,18),Q(:,58),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-6),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,122),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,5),G1(:,:,:,19),gZd)
  call loop_A_Q(G1(:,:,:,19),Q(:,58),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-6),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,122),ZERO,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,4),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,112),ZERO,G2(:,:,:,65))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,69),G2(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,69),G2(:,:,:,67),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,70),G2(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,70),G2(:,:,:,69),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,71),G2(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,71),G2(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,72),G2(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,72),G2(:,:,:,73),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,73),G2(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,73),G2(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,74),G2(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,74),G2(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,75),G2(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,75),G2(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,76),G2(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,76),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,26),G1(:,:,:,21),gZu)
  call loop_A_Q(G1(:,:,:,21),Q(:,57),ZERO,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-6),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,121),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,27),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,26),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,57),ZERO,G2(:,:,:,84))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-6),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,121),ZERO,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,27),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,23))
  call loop_QZ_A(G1(:,:,:,23),wf(:,5),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,58),ZERO,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-6),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,122),ZERO,G3(:,:,:,25))
  call loop_QZ_A(G3(:,:,:,25),wf(:,4),G3(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,13))
  call loop_QZ_A(G1(:,:,:,23),wf(:,5),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,58),ZERO,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,-6),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,122),ZERO,G3(:,:,:,27))
  call loop_QZ_A(G3(:,:,:,27),wf(:,4),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,14))
  call loop_QV_A(G1(:,:,:,23),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),ZERO,G2(:,:,:,90))
  call loop_QZ_A(G2(:,:,:,90),wf(:,69),G2(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),ZERO,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,90),wf(:,69),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),ZERO,G3tensor(:,58))
  call loop_QZ_A(G2(:,:,:,90),wf(:,70),G2(:,:,:,93),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,127),ZERO,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,90),wf(:,70),G2(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,127),ZERO,G3tensor(:,60))
  call loop_QZ_A(G2(:,:,:,90),wf(:,71),G2(:,:,:,95),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,95),Q(:,127),ZERO,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,90),wf(:,71),G2(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,62))
  call loop_QZ_A(G2(:,:,:,90),wf(:,72),G2(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,90),wf(:,72),G2(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,64))
  call loop_QZ_A(G2(:,:,:,90),wf(:,73),G2(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,65))
  call loop_QZ_A(G2(:,:,:,90),wf(:,73),G2(:,:,:,100),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,90),wf(:,74),G2(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,90),wf(:,74),G2(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,68))
  call loop_QZ_A(G2(:,:,:,90),wf(:,75),G2(:,:,:,103),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,69))
  call loop_QZ_A(G2(:,:,:,90),wf(:,75),G2(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,90),wf(:,76),G2(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,71))
  call loop_QZ_A(G2(:,:,:,90),wf(:,76),G2(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,72))
  call loop_QZ_A(G1(:,:,:,23),wf(:,26),G1(:,:,:,27),gZu)
  call loop_Q_A(G1(:,:,:,27),Q(:,57),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-6),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,121),ZERO,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,27),G3(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,15))
  call loop_QZ_A(G1(:,:,:,23),wf(:,26),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,57),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,-6),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,121),ZERO,G3(:,:,:,31))
  call loop_QZ_A(G3(:,:,:,31),wf(:,27),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,3),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,58),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-6),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,122),ZERO,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,4),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-6),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,74),ZERO,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,122),ZERO,G3(:,:,:,35))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,4),G3(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-4),G2(:,:,:,115))
  call loop_A_Q(G2(:,:,:,115),Q(:,90),ZERO,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,-5),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,122),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,113),wf(:,-5),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,106),ZERO,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,122),ZERO,G4(:,:,:,3))
  call loop_AZ_Q(G4(:,:,:,3),wf(:,4),G4(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,29),wf(:,7),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,90),ZERO,G2(:,:,:,117))
  call loop_AV_Q(G2(:,:,:,117),wf(:,-5),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,122),ZERO,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,4),G3(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-5),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,42),ZERO,G2(:,:,:,119))
  call loop_AV_Q(G2(:,:,:,119),wf(:,7),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,122),ZERO,G3(:,:,:,43))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,4),G3(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-4),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,58),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-6),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,122),ZERO,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,4),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,119),wf(:,-6),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,106),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,122),ZERO,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,4),G4(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,29),wf(:,9),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,106),ZERO,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-4),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,122),ZERO,G3(:,:,:,49))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,4),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-4),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,26),ZERO,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,9),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,122),ZERO,G3(:,:,:,51))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,4),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-5),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,58),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-6),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,122),ZERO,G4(:,:,:,9))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,4),G4(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-6),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,90),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-5),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,122),ZERO,G4(:,:,:,11))
  call loop_AZ_Q(G4(:,:,:,11),wf(:,4),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,36))
  call loop_AV_Q(G1(:,:,:,36),wf(:,3),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,58),MT,G2(:,:,:,129))
  call loop_AV_Q(G2(:,:,:,129),wf(:,-6),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,122),MT,G3(:,:,:,57))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,4),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-6),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,74),MT,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,3),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,122),MT,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,4),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-4),G2(:,:,:,133))
  call loop_A_Q(G2(:,:,:,133),Q(:,90),MT,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-5),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,122),MT,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,4),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MT,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-5),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,106),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,122),MT,G4(:,:,:,15))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,4),G4(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,36),wf(:,7),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,90),MT,G2(:,:,:,135))
  call loop_AV_Q(G2(:,:,:,135),wf(:,-5),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,122),MT,G3(:,:,:,65))
  call loop_AZ_Q(G3(:,:,:,65),wf(:,4),G3(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),MT,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-5),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,42),MT,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,7),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,122),MT,G3(:,:,:,67))
  call loop_AZ_Q(G3(:,:,:,67),wf(:,4),G3(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),MT,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-4),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,58),MT,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-6),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,122),MT,G4(:,:,:,17))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,4),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),MT,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-6),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,106),MT,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,122),MT,G4(:,:,:,19))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,4),G4(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,10))
  call loop_AV_Q(G1(:,:,:,36),wf(:,9),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,106),MT,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,-4),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,122),MT,G3(:,:,:,73))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,4),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,26),MT,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,9),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,122),MT,G3(:,:,:,75))
  call loop_AZ_Q(G3(:,:,:,75),wf(:,4),G3(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),MT,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-5),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,58),MT,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,122),MT,G4(:,:,:,21))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,4),G4(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),MT,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-6),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,90),MT,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,122),MT,G4(:,:,:,23))
  call loop_AZ_Q(G4(:,:,:,23),wf(:,4),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZu)
  call loop_Q_A(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,3),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,58),ZERO,G2(:,:,:,147))
  call loop_QV_A(G2(:,:,:,147),wf(:,-6),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,122),ZERO,G3(:,:,:,81))
  call loop_QZ_A(G3(:,:,:,81),wf(:,4),G3(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,43),wf(:,-6),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,74),ZERO,G2(:,:,:,149))
  call loop_QV_A(G2(:,:,:,149),wf(:,3),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,122),ZERO,G3(:,:,:,83))
  call loop_QZ_A(G3(:,:,:,83),wf(:,4),G3(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,149),wf(:,-4),G2(:,:,:,151))
  call loop_Q_A(G2(:,:,:,151),Q(:,90),ZERO,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-5),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,122),ZERO,G4(:,:,:,25))
  call loop_QZ_A(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,149),wf(:,-5),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,106),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,122),ZERO,G4(:,:,:,27))
  call loop_QZ_A(G4(:,:,:,27),wf(:,4),G4(:,:,:,28),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,127),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,43),wf(:,7),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,90),ZERO,G2(:,:,:,153))
  call loop_QV_A(G2(:,:,:,153),wf(:,-5),G2(:,:,:,154))
  call loop_Q_A(G2(:,:,:,154),Q(:,122),ZERO,G3(:,:,:,89))
  call loop_QZ_A(G3(:,:,:,89),wf(:,4),G3(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),ZERO,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,43),wf(:,-5),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,42),ZERO,G2(:,:,:,155))
  call loop_QV_A(G2(:,:,:,155),wf(:,7),G2(:,:,:,156))
  call loop_Q_A(G2(:,:,:,156),Q(:,122),ZERO,G3(:,:,:,91))
  call loop_QZ_A(G3(:,:,:,91),wf(:,4),G3(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,155),wf(:,-4),G2(:,:,:,157))
  call loop_Q_A(G2(:,:,:,157),Q(:,58),ZERO,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-6),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,122),ZERO,G4(:,:,:,29))
  call loop_QZ_A(G4(:,:,:,29),wf(:,4),G4(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,155),wf(:,-6),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,106),ZERO,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,122),ZERO,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,43),wf(:,9),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,106),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,-4),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,122),ZERO,G3(:,:,:,97))
  call loop_QZ_A(G3(:,:,:,97),wf(:,4),G3(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),ZERO,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,43),wf(:,-4),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,26),ZERO,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,9),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,122),ZERO,G3(:,:,:,99))
  call loop_QZ_A(G3(:,:,:,99),wf(:,4),G3(:,:,:,100),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),ZERO,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,161),wf(:,-5),G2(:,:,:,163))
  call loop_Q_A(G2(:,:,:,163),Q(:,58),ZERO,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-6),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,122),ZERO,G4(:,:,:,33))
  call loop_QZ_A(G4(:,:,:,33),wf(:,4),G4(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,161),wf(:,-6),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,90),ZERO,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,-5),G3(:,:,:,104))
  call loop_Q_A(G3(:,:,:,104),Q(:,122),ZERO,G4(:,:,:,35))
  call loop_QZ_A(G4(:,:,:,35),wf(:,4),G4(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,18))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,11),gZu)
  call loop_Q_A(G0(:,:,:,11),Q(:,10),MT,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,3),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,58),MT,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,-6),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,122),MT,G3(:,:,:,105))
  call loop_QZ_A(G3(:,:,:,105),wf(:,4),G3(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),MT,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,50),wf(:,-6),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,74),MT,G2(:,:,:,167))
  call loop_QV_A(G2(:,:,:,167),wf(:,3),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,122),MT,G3(:,:,:,107))
  call loop_QZ_A(G3(:,:,:,107),wf(:,4),G3(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),MT,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,167),wf(:,-4),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,90),MT,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,122),MT,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,167),wf(:,-5),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,106),MT,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,122),MT,G4(:,:,:,39))
  call loop_QZ_A(G4(:,:,:,39),wf(:,4),G4(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,127),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,50),wf(:,7),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,90),MT,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,122),MT,G3(:,:,:,113))
  call loop_QZ_A(G3(:,:,:,113),wf(:,4),G3(:,:,:,114),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,127),MT,G4tensor(:,37))
  call loop_QV_A(G1(:,:,:,50),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,42),MT,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,7),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,122),MT,G3(:,:,:,115))
  call loop_QZ_A(G3(:,:,:,115),wf(:,4),G3(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,127),MT,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,173),wf(:,-4),G2(:,:,:,175))
  call loop_Q_A(G2(:,:,:,175),Q(:,58),MT,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,-6),G3(:,:,:,118))
  call loop_Q_A(G3(:,:,:,118),Q(:,122),MT,G4(:,:,:,41))
  call loop_QZ_A(G4(:,:,:,41),wf(:,4),G4(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,173),wf(:,-6),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,106),MT,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,122),MT,G4(:,:,:,43))
  call loop_QZ_A(G4(:,:,:,43),wf(:,4),G4(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),MT,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,50),wf(:,9),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,106),MT,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,-4),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,122),MT,G3(:,:,:,121))
  call loop_QZ_A(G3(:,:,:,121),wf(:,4),G3(:,:,:,122),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,127),MT,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,50),wf(:,-4),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,26),MT,G2(:,:,:,179))
  call loop_QV_A(G2(:,:,:,179),wf(:,9),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,122),MT,G3(:,:,:,123))
  call loop_QZ_A(G3(:,:,:,123),wf(:,4),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MT,G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,179),wf(:,-5),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,58),MT,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-6),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,122),MT,G4(:,:,:,45))
  call loop_QZ_A(G4(:,:,:,45),wf(:,4),G4(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,127),MT,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,179),wf(:,-6),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,90),MT,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-5),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,122),MT,G4(:,:,:,47))
  call loop_QZ_A(G4(:,:,:,47),wf(:,4),G4(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),MT,G5tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,10),ZERO,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,58),ZERO,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-6),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,122),ZERO,G3(:,:,:,129))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,4),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-6),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,74),ZERO,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,3),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,122),ZERO,G3(:,:,:,131))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,4),G3(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-4),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,90),ZERO,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-5),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,122),ZERO,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,4),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-5),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,106),ZERO,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,122),ZERO,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,57),wf(:,7),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,90),ZERO,G2(:,:,:,189))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-5),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,122),ZERO,G3(:,:,:,137))
  call loop_AZ_Q(G3(:,:,:,137),wf(:,4),G3(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,127),ZERO,G4tensor(:,43))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-5),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,42),ZERO,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,7),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,122),ZERO,G3(:,:,:,139))
  call loop_AZ_Q(G3(:,:,:,139),wf(:,4),G3(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),ZERO,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-4),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,58),ZERO,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-6),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,122),ZERO,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-6),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,106),ZERO,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,122),ZERO,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,4),G4(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,127),ZERO,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,57),wf(:,9),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,106),ZERO,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-4),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,122),ZERO,G3(:,:,:,145))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,4),G3(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-4),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,26),ZERO,G2(:,:,:,197))
  call loop_AV_Q(G2(:,:,:,197),wf(:,9),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,122),ZERO,G3(:,:,:,147))
  call loop_AZ_Q(G3(:,:,:,147),wf(:,4),G3(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AV_Q(G2(:,:,:,197),wf(:,-5),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,58),ZERO,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-6),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,122),ZERO,G4(:,:,:,57))
  call loop_AZ_Q(G4(:,:,:,57),wf(:,4),G4(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,197),wf(:,-6),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,90),ZERO,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-5),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,122),ZERO,G4(:,:,:,59))
  call loop_AZ_Q(G4(:,:,:,59),wf(:,4),G4(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,30))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,10),MB,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,3),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,58),MB,G2(:,:,:,201))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-6),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,122),MB,G3(:,:,:,153))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,4),G3(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,127),MB,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-6),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,74),MB,G2(:,:,:,203))
  call loop_AV_Q(G2(:,:,:,203),wf(:,3),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,122),MB,G3(:,:,:,155))
  call loop_AZ_Q(G3(:,:,:,155),wf(:,4),G3(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,127),MB,G4tensor(:,48))
  call loop_AV_Q(G2(:,:,:,203),wf(:,-4),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,90),MB,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-5),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,122),MB,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,203),wf(:,-5),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,106),MB,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,122),MB,G4(:,:,:,63))
  call loop_AZ_Q(G4(:,:,:,63),wf(:,4),G4(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,127),MB,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,64),wf(:,7),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,90),MB,G2(:,:,:,207))
  call loop_AV_Q(G2(:,:,:,207),wf(:,-5),G2(:,:,:,208))
  call loop_A_Q(G2(:,:,:,208),Q(:,122),MB,G3(:,:,:,161))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,4),G3(:,:,:,162),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,127),MB,G4tensor(:,49))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,42),MB,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,7),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,122),MB,G3(:,:,:,163))
  call loop_AZ_Q(G3(:,:,:,163),wf(:,4),G3(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,127),MB,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-4),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,58),MB,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-6),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,122),MB,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,4),G4(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,209),wf(:,-6),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,106),MB,G3(:,:,:,167))
  call loop_AV_Q(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_A_Q(G3(:,:,:,168),Q(:,122),MB,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,64),wf(:,9),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,106),MB,G2(:,:,:,213))
  call loop_AV_Q(G2(:,:,:,213),wf(:,-4),G2(:,:,:,214))
  call loop_A_Q(G2(:,:,:,214),Q(:,122),MB,G3(:,:,:,169))
  call loop_AZ_Q(G3(:,:,:,169),wf(:,4),G3(:,:,:,170),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,127),MB,G4tensor(:,51))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-4),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,26),MB,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,9),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,122),MB,G3(:,:,:,171))
  call loop_AZ_Q(G3(:,:,:,171),wf(:,4),G3(:,:,:,172),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,127),MB,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-5),G2(:,:,:,217))
  call loop_A_Q(G2(:,:,:,217),Q(:,58),MB,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-6),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,122),MB,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),MB,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-6),G2(:,:,:,218))
  call loop_A_Q(G2(:,:,:,218),Q(:,90),MB,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,-5),G3(:,:,:,176))
  call loop_A_Q(G3(:,:,:,176),Q(:,122),MB,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,14),gZd)
  call loop_Q_A(G0(:,:,:,14),Q(:,10),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,3),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,58),ZERO,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,-6),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,122),ZERO,G3(:,:,:,177))
  call loop_QZ_A(G3(:,:,:,177),wf(:,4),G3(:,:,:,178),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,71),wf(:,-6),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,74),ZERO,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,3),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,122),ZERO,G3(:,:,:,179))
  call loop_QZ_A(G3(:,:,:,179),wf(:,4),G3(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,54))
  call loop_QV_A(G2(:,:,:,221),wf(:,-4),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,90),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-5),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,122),ZERO,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,221),wf(:,-5),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,106),ZERO,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-4),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,122),ZERO,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),ZERO,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,71),wf(:,7),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,90),ZERO,G2(:,:,:,225))
  call loop_QV_A(G2(:,:,:,225),wf(:,-5),G2(:,:,:,226))
  call loop_Q_A(G2(:,:,:,226),Q(:,122),ZERO,G3(:,:,:,185))
  call loop_QZ_A(G3(:,:,:,185),wf(:,4),G3(:,:,:,186),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),ZERO,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,71),wf(:,-5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,42),ZERO,G2(:,:,:,227))
  call loop_QV_A(G2(:,:,:,227),wf(:,7),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,122),ZERO,G3(:,:,:,187))
  call loop_QZ_A(G3(:,:,:,187),wf(:,4),G3(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,227),wf(:,-4),G2(:,:,:,229))
  call loop_Q_A(G2(:,:,:,229),Q(:,58),ZERO,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,-6),G3(:,:,:,190))
  call loop_Q_A(G3(:,:,:,190),Q(:,122),ZERO,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,4),G4(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),ZERO,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,227),wf(:,-6),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,106),ZERO,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,122),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,71),wf(:,9),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,106),ZERO,G2(:,:,:,231))
  call loop_QV_A(G2(:,:,:,231),wf(:,-4),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,122),ZERO,G3(:,:,:,193))
  call loop_QZ_A(G3(:,:,:,193),wf(:,4),G3(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,57))
  call loop_QV_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,26),ZERO,G2(:,:,:,233))
  call loop_QV_A(G2(:,:,:,233),wf(:,9),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,122),ZERO,G3(:,:,:,195))
  call loop_QZ_A(G3(:,:,:,195),wf(:,4),G3(:,:,:,196),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,58))
  call loop_QV_A(G2(:,:,:,233),wf(:,-5),G2(:,:,:,235))
  call loop_Q_A(G2(:,:,:,235),Q(:,58),ZERO,G3(:,:,:,197))
  call loop_QV_A(G3(:,:,:,197),wf(:,-6),G3(:,:,:,198))
  call loop_Q_A(G3(:,:,:,198),Q(:,122),ZERO,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,4),G4(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,233),wf(:,-6),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,90),ZERO,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_Q_A(G3(:,:,:,200),Q(:,122),ZERO,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,4),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,15),gZd)
  call loop_Q_A(G0(:,:,:,15),Q(:,10),MB,G1(:,:,:,78))
  call loop_QV_A(G1(:,:,:,78),wf(:,3),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,58),MB,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,-6),G2(:,:,:,238))
  call loop_Q_A(G2(:,:,:,238),Q(:,122),MB,G3(:,:,:,201))
  call loop_QZ_A(G3(:,:,:,201),wf(:,4),G3(:,:,:,202),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,127),MB,G4tensor(:,59))
  call loop_QV_A(G1(:,:,:,78),wf(:,-6),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,74),MB,G2(:,:,:,239))
  call loop_QV_A(G2(:,:,:,239),wf(:,3),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,122),MB,G3(:,:,:,203))
  call loop_QZ_A(G3(:,:,:,203),wf(:,4),G3(:,:,:,204),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,127),MB,G4tensor(:,60))
  call loop_QV_A(G2(:,:,:,239),wf(:,-4),G2(:,:,:,241))
  call loop_Q_A(G2(:,:,:,241),Q(:,90),MB,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_Q_A(G3(:,:,:,206),Q(:,122),MB,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,4),G4(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),MB,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,239),wf(:,-5),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,106),MB,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_Q_A(G3(:,:,:,208),Q(:,122),MB,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,4),G4(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,78),wf(:,7),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,90),MB,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-5),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,122),MB,G3(:,:,:,209))
  call loop_QZ_A(G3(:,:,:,209),wf(:,4),G3(:,:,:,210),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,127),MB,G4tensor(:,61))
  call loop_QV_A(G1(:,:,:,78),wf(:,-5),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,42),MB,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,7),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,122),MB,G3(:,:,:,211))
  call loop_QZ_A(G3(:,:,:,211),wf(:,4),G3(:,:,:,212),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,127),MB,G4tensor(:,62))
  call loop_QV_A(G2(:,:,:,245),wf(:,-4),G2(:,:,:,247))
  call loop_Q_A(G2(:,:,:,247),Q(:,58),MB,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-6),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,122),MB,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,4),G4(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),MB,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,245),wf(:,-6),G2(:,:,:,248))
  call loop_Q_A(G2(:,:,:,248),Q(:,106),MB,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,122),MB,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,4),G4(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),MB,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,78),wf(:,9),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,106),MB,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,-4),G2(:,:,:,250))
  call loop_Q_A(G2(:,:,:,250),Q(:,122),MB,G3(:,:,:,217))
  call loop_QZ_A(G3(:,:,:,217),wf(:,4),G3(:,:,:,218),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),MB,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,78),wf(:,-4),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,26),MB,G2(:,:,:,251))
  call loop_QV_A(G2(:,:,:,251),wf(:,9),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,122),MB,G3(:,:,:,219))
  call loop_QZ_A(G3(:,:,:,219),wf(:,4),G3(:,:,:,220),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,220),Q(:,127),MB,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,251),wf(:,-5),G2(:,:,:,253))
  call loop_Q_A(G2(:,:,:,253),Q(:,58),MB,G3(:,:,:,221))
  call loop_QV_A(G3(:,:,:,221),wf(:,-6),G3(:,:,:,222))
  call loop_Q_A(G3(:,:,:,222),Q(:,122),MB,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,4),G4(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,127),MB,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,251),wf(:,-6),G2(:,:,:,254))
  call loop_Q_A(G2(:,:,:,254),Q(:,90),MB,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,-5),G3(:,:,:,224))
  call loop_Q_A(G3(:,:,:,224),Q(:,122),MB,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,4),G4(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),MB,G5tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,32),MT,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,7),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,112),MT,G2(:,:,:,255))
  call loop_AS_Q(G2(:,:,:,255),wf(:,46),G2(:,:,:,256),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,127),MT,G3tensor(:,73))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,69),G2(:,:,:,257),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,257),Q(:,127),MT,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,70),G2(:,:,:,258),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,127),MT,G3tensor(:,75))
  call loop_AS_Q(G2(:,:,:,255),wf(:,59),G2(:,:,:,259),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,259),Q(:,127),MT,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,71),G2(:,:,:,260),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,127),MT,G3tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,72),G2(:,:,:,261),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,261),Q(:,127),MT,G3tensor(:,78))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,73),G2(:,:,:,262),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,127),MT,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,74),G2(:,:,:,263),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,263),Q(:,127),MT,G3tensor(:,80))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,75),G2(:,:,:,264),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,127),MT,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,76),G2(:,:,:,265),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,265),Q(:,127),MT,G3tensor(:,82))
  call loop_AZ_Q(G1(:,:,:,85),wf(:,5),G1(:,:,:,87),gZu)
  call loop_A_Q(G1(:,:,:,87),Q(:,42),MT,G2(:,:,:,266))
  call loop_AV_Q(G2(:,:,:,266),wf(:,7),G2(:,:,:,267))
  call loop_A_Q(G2(:,:,:,267),Q(:,122),MT,G3(:,:,:,225))
  call loop_AZ_Q(G3(:,:,:,225),wf(:,4),G3(:,:,:,226),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,127),MT,G4tensor(:,65))
  call loop_AV_Q(G2(:,:,:,266),wf(:,-4),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,58),MT,G3(:,:,:,227))
  call loop_AV_Q(G3(:,:,:,227),wf(:,-6),G3(:,:,:,228))
  call loop_A_Q(G3(:,:,:,228),Q(:,122),MT,G4(:,:,:,97))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,4),G4(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MT,G5tensor(:,49))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-4),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,48),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-6),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,112),MT,G3(:,:,:,229))
  call loop_AS_Q(G3(:,:,:,229),wf(:,46),G3(:,:,:,230),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),MT,G4tensor(:,66))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,69),G3(:,:,:,231),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,231),Q(:,127),MT,G4tensor(:,67))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,70),G3(:,:,:,232),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,232),Q(:,127),MT,G4tensor(:,68))
  call loop_AS_Q(G3(:,:,:,229),wf(:,59),G3(:,:,:,233),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,233),Q(:,127),MT,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,71),G3(:,:,:,234),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,127),MT,G4tensor(:,70))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,72),G3(:,:,:,235),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,235),Q(:,127),MT,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,73),G3(:,:,:,236),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,127),MT,G4tensor(:,72))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,74),G3(:,:,:,237),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,237),Q(:,127),MT,G4tensor(:,73))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,75),G3(:,:,:,238),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),MT,G4tensor(:,74))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,76),G3(:,:,:,239),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,239),Q(:,127),MT,G4tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,269),wf(:,5),G2(:,:,:,271),gZu)
  call loop_A_Q(G2(:,:,:,271),Q(:,58),MT,G3(:,:,:,240))
  call loop_AV_Q(G3(:,:,:,240),wf(:,-6),G3(:,:,:,241))
  call loop_A_Q(G3(:,:,:,241),Q(:,122),MT,G4(:,:,:,99))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,4),G4(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,127),MT,G5tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,269),wf(:,26),G2(:,:,:,272),gZu)
  call loop_A_Q(G2(:,:,:,272),Q(:,57),MT,G3(:,:,:,242))
  call loop_AV_Q(G3(:,:,:,242),wf(:,-6),G3(:,:,:,243))
  call loop_A_Q(G3(:,:,:,243),Q(:,121),MT,G4(:,:,:,101))
  call loop_AZ_Q(G4(:,:,:,101),wf(:,27),G4(:,:,:,102),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MT,G5tensor(:,51))
  call loop_AZ_Q(G1(:,:,:,85),wf(:,26),G1(:,:,:,89),gZu)
  call loop_A_Q(G1(:,:,:,89),Q(:,41),MT,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,7),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,121),MT,G3(:,:,:,244))
  call loop_AZ_Q(G3(:,:,:,244),wf(:,27),G3(:,:,:,245),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,245),Q(:,127),MT,G4tensor(:,76))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-4),G2(:,:,:,275))
  call loop_A_Q(G2(:,:,:,275),Q(:,57),MT,G3(:,:,:,246))
  call loop_AV_Q(G3(:,:,:,246),wf(:,-6),G3(:,:,:,247))
  call loop_A_Q(G3(:,:,:,247),Q(:,121),MT,G4(:,:,:,103))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,27),G4(:,:,:,104),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),MT,G5tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,32),MT,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,7),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,112),MT,G2(:,:,:,276))
  call loop_QS_A(G2(:,:,:,276),wf(:,46),G2(:,:,:,277),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,277),Q(:,127),MT,G3tensor(:,83))
  call loop_QZ_A(G2(:,:,:,276),wf(:,69),G2(:,:,:,278),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,278),Q(:,127),MT,G3tensor(:,84))
  call loop_QZ_A(G2(:,:,:,276),wf(:,70),G2(:,:,:,279),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,279),Q(:,127),MT,G3tensor(:,85))
  call loop_QS_A(G2(:,:,:,276),wf(:,59),G2(:,:,:,280),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,127),MT,G3tensor(:,86))
  call loop_QZ_A(G2(:,:,:,276),wf(:,71),G2(:,:,:,281),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,281),Q(:,127),MT,G3tensor(:,87))
  call loop_QZ_A(G2(:,:,:,276),wf(:,72),G2(:,:,:,282),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,127),MT,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,276),wf(:,73),G2(:,:,:,283),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,283),Q(:,127),MT,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,276),wf(:,74),G2(:,:,:,284),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,284),Q(:,127),MT,G3tensor(:,90))
  call loop_QZ_A(G2(:,:,:,276),wf(:,75),G2(:,:,:,285),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,285),Q(:,127),MT,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,276),wf(:,76),G2(:,:,:,286),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,127),MT,G3tensor(:,92))
  call loop_QZ_A(G1(:,:,:,90),wf(:,5),G1(:,:,:,92),gZu)
  call loop_Q_A(G1(:,:,:,92),Q(:,42),MT,G2(:,:,:,287))
  call loop_QV_A(G2(:,:,:,287),wf(:,7),G2(:,:,:,288))
  call loop_Q_A(G2(:,:,:,288),Q(:,122),MT,G3(:,:,:,248))
  call loop_QZ_A(G3(:,:,:,248),wf(:,4),G3(:,:,:,249),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,249),Q(:,127),MT,G4tensor(:,77))
  call loop_QV_A(G2(:,:,:,287),wf(:,-4),G2(:,:,:,289))
  call loop_Q_A(G2(:,:,:,289),Q(:,58),MT,G3(:,:,:,250))
  call loop_QV_A(G3(:,:,:,250),wf(:,-6),G3(:,:,:,251))
  call loop_Q_A(G3(:,:,:,251),Q(:,122),MT,G4(:,:,:,105))
  call loop_QZ_A(G4(:,:,:,105),wf(:,4),G4(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,127),MT,G5tensor(:,53))
  call loop_QV_A(G1(:,:,:,90),wf(:,-4),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,48),MT,G2(:,:,:,290))
  call loop_QV_A(G2(:,:,:,290),wf(:,-6),G2(:,:,:,291))
  call loop_Q_A(G2(:,:,:,291),Q(:,112),MT,G3(:,:,:,252))
  call loop_QS_A(G3(:,:,:,252),wf(:,46),G3(:,:,:,253),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,253),Q(:,127),MT,G4tensor(:,78))
  call loop_QZ_A(G3(:,:,:,252),wf(:,69),G3(:,:,:,254),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,254),Q(:,127),MT,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,252),wf(:,70),G3(:,:,:,255),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,255),Q(:,127),MT,G4tensor(:,80))
  call loop_QS_A(G3(:,:,:,252),wf(:,59),G3(:,:,:,256),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,256),Q(:,127),MT,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,252),wf(:,71),G3(:,:,:,257),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,257),Q(:,127),MT,G4tensor(:,82))
  call loop_QZ_A(G3(:,:,:,252),wf(:,72),G3(:,:,:,258),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,127),MT,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,252),wf(:,73),G3(:,:,:,259),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,259),Q(:,127),MT,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,252),wf(:,74),G3(:,:,:,260),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,127),MT,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,252),wf(:,75),G3(:,:,:,261),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,261),Q(:,127),MT,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,252),wf(:,76),G3(:,:,:,262),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,262),Q(:,127),MT,G4tensor(:,87))
  call loop_QZ_A(G2(:,:,:,290),wf(:,5),G2(:,:,:,292),gZu)
  call loop_Q_A(G2(:,:,:,292),Q(:,58),MT,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-6),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,122),MT,G4(:,:,:,107))
  call loop_QZ_A(G4(:,:,:,107),wf(:,4),G4(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,127),MT,G5tensor(:,54))
  call loop_QZ_A(G2(:,:,:,290),wf(:,26),G2(:,:,:,293),gZu)
  call loop_Q_A(G2(:,:,:,293),Q(:,57),MT,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,-6),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,121),MT,G4(:,:,:,109))
  call loop_QZ_A(G4(:,:,:,109),wf(:,27),G4(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MT,G5tensor(:,55))
  call loop_QZ_A(G1(:,:,:,90),wf(:,26),G1(:,:,:,94),gZu)
  call loop_Q_A(G1(:,:,:,94),Q(:,41),MT,G2(:,:,:,294))
  call loop_QV_A(G2(:,:,:,294),wf(:,7),G2(:,:,:,295))
  call loop_Q_A(G2(:,:,:,295),Q(:,121),MT,G3(:,:,:,267))
  call loop_QZ_A(G3(:,:,:,267),wf(:,27),G3(:,:,:,268),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,127),MT,G4tensor(:,88))
  call loop_QV_A(G2(:,:,:,294),wf(:,-4),G2(:,:,:,296))
  call loop_Q_A(G2(:,:,:,296),Q(:,57),MT,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-6),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,121),MT,G4(:,:,:,111))
  call loop_QZ_A(G4(:,:,:,111),wf(:,27),G4(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,127),MT,G5tensor(:,56))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,32),MB,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,7),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,112),MB,G2(:,:,:,297))
  call loop_AS_Q(G2(:,:,:,297),wf(:,46),G2(:,:,:,298),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,127),MB,G3tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,69),G2(:,:,:,299),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,299),Q(:,127),MB,G3tensor(:,94))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,70),G2(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,300),Q(:,127),MB,G3tensor(:,95))
  call loop_AS_Q(G2(:,:,:,297),wf(:,59),G2(:,:,:,301),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,301),Q(:,127),MB,G3tensor(:,96))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,71),G2(:,:,:,302),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,127),MB,G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,72),G2(:,:,:,303),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,303),Q(:,127),MB,G3tensor(:,98))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,73),G2(:,:,:,304),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,304),Q(:,127),MB,G3tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,74),G2(:,:,:,305),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,305),Q(:,127),MB,G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,75),G2(:,:,:,306),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,306),Q(:,127),MB,G3tensor(:,101))
  call loop_AZ_Q(G2(:,:,:,297),wf(:,76),G2(:,:,:,307),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,307),Q(:,127),MB,G3tensor(:,102))
  call loop_AZ_Q(G1(:,:,:,95),wf(:,5),G1(:,:,:,97),gZd)
  call loop_A_Q(G1(:,:,:,97),Q(:,42),MB,G2(:,:,:,308))
  call loop_AV_Q(G2(:,:,:,308),wf(:,7),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,122),MB,G3(:,:,:,271))
  call loop_AZ_Q(G3(:,:,:,271),wf(:,4),G3(:,:,:,272),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),MB,G4tensor(:,89))
  call loop_AV_Q(G2(:,:,:,308),wf(:,-4),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,58),MB,G3(:,:,:,273))
  call loop_AV_Q(G3(:,:,:,273),wf(:,-6),G3(:,:,:,274))
  call loop_A_Q(G3(:,:,:,274),Q(:,122),MB,G4(:,:,:,113))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,4),G4(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,127),MB,G5tensor(:,57))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-4),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,48),MB,G2(:,:,:,311))
  call loop_AV_Q(G2(:,:,:,311),wf(:,-6),G2(:,:,:,312))
  call loop_A_Q(G2(:,:,:,312),Q(:,112),MB,G3(:,:,:,275))
  call loop_AS_Q(G3(:,:,:,275),wf(:,46),G3(:,:,:,276),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,127),MB,G4tensor(:,90))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,69),G3(:,:,:,277),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,277),Q(:,127),MB,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,70),G3(:,:,:,278),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,127),MB,G4tensor(:,92))
  call loop_AS_Q(G3(:,:,:,275),wf(:,59),G3(:,:,:,279),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,279),Q(:,127),MB,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,71),G3(:,:,:,280),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,127),MB,G4tensor(:,94))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,72),G3(:,:,:,281),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,281),Q(:,127),MB,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,73),G3(:,:,:,282),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,127),MB,G4tensor(:,96))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,74),G3(:,:,:,283),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,283),Q(:,127),MB,G4tensor(:,97))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,75),G3(:,:,:,284),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,284),Q(:,127),MB,G4tensor(:,98))
  call loop_AZ_Q(G3(:,:,:,275),wf(:,76),G3(:,:,:,285),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,285),Q(:,127),MB,G4tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,311),wf(:,5),G2(:,:,:,313),gZd)
  call loop_A_Q(G2(:,:,:,313),Q(:,58),MB,G3(:,:,:,286))
  call loop_AV_Q(G3(:,:,:,286),wf(:,-6),G3(:,:,:,287))
  call loop_A_Q(G3(:,:,:,287),Q(:,122),MB,G4(:,:,:,115))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,4),G4(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,127),MB,G5tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,311),wf(:,26),G2(:,:,:,314),gZd)
  call loop_A_Q(G2(:,:,:,314),Q(:,57),MB,G3(:,:,:,288))
  call loop_AV_Q(G3(:,:,:,288),wf(:,-6),G3(:,:,:,289))
  call loop_A_Q(G3(:,:,:,289),Q(:,121),MB,G4(:,:,:,117))
  call loop_AZ_Q(G4(:,:,:,117),wf(:,27),G4(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,127),MB,G5tensor(:,59))
  call loop_AZ_Q(G1(:,:,:,95),wf(:,26),G1(:,:,:,99),gZd)
  call loop_A_Q(G1(:,:,:,99),Q(:,41),MB,G2(:,:,:,315))
  call loop_AV_Q(G2(:,:,:,315),wf(:,7),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,121),MB,G3(:,:,:,290))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,27),G3(:,:,:,291),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),MB,G4tensor(:,100))
  call loop_AV_Q(G2(:,:,:,315),wf(:,-4),G2(:,:,:,317))
  call loop_A_Q(G2(:,:,:,317),Q(:,57),MB,G3(:,:,:,292))
  call loop_AV_Q(G3(:,:,:,292),wf(:,-6),G3(:,:,:,293))
  call loop_A_Q(G3(:,:,:,293),Q(:,121),MB,G4(:,:,:,119))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,27),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,127),MB,G5tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,32),MB,G1(:,:,:,100))
  call loop_QV_A(G1(:,:,:,100),wf(:,7),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,112),MB,G2(:,:,:,318))
  call loop_QS_A(G2(:,:,:,318),wf(:,46),G2(:,:,:,319),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,319),Q(:,127),MB,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,318),wf(:,69),G2(:,:,:,320),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,320),Q(:,127),MB,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,318),wf(:,70),G2(:,:,:,321),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,321),Q(:,127),MB,G3tensor(:,105))
  call loop_QS_A(G2(:,:,:,318),wf(:,59),G2(:,:,:,322),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,322),Q(:,127),MB,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,318),wf(:,71),G2(:,:,:,323),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,323),Q(:,127),MB,G3tensor(:,107))
  call loop_QZ_A(G2(:,:,:,318),wf(:,72),G2(:,:,:,324),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,324),Q(:,127),MB,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,318),wf(:,73),G2(:,:,:,325),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,325),Q(:,127),MB,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,318),wf(:,74),G2(:,:,:,326),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,326),Q(:,127),MB,G3tensor(:,110))
  call loop_QZ_A(G2(:,:,:,318),wf(:,75),G2(:,:,:,327),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,327),Q(:,127),MB,G3tensor(:,111))
  call loop_QZ_A(G2(:,:,:,318),wf(:,76),G2(:,:,:,328),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,328),Q(:,127),MB,G3tensor(:,112))
  call loop_QZ_A(G1(:,:,:,100),wf(:,5),G1(:,:,:,102),gZd)
  call loop_Q_A(G1(:,:,:,102),Q(:,42),MB,G2(:,:,:,329))
  call loop_QV_A(G2(:,:,:,329),wf(:,7),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,122),MB,G3(:,:,:,294))
  call loop_QZ_A(G3(:,:,:,294),wf(:,4),G3(:,:,:,295),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,295),Q(:,127),MB,G4tensor(:,101))
  call loop_QV_A(G2(:,:,:,329),wf(:,-4),G2(:,:,:,331))
  call loop_Q_A(G2(:,:,:,331),Q(:,58),MB,G3(:,:,:,296))
  call loop_QV_A(G3(:,:,:,296),wf(:,-6),G3(:,:,:,297))
  call loop_Q_A(G3(:,:,:,297),Q(:,122),MB,G4(:,:,:,121))
  call loop_QZ_A(G4(:,:,:,121),wf(:,4),G4(:,:,:,122),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,127),MB,G5tensor(:,61))
  call loop_QV_A(G1(:,:,:,100),wf(:,-4),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,48),MB,G2(:,:,:,332))
  call loop_QV_A(G2(:,:,:,332),wf(:,-6),G2(:,:,:,333))
  call loop_Q_A(G2(:,:,:,333),Q(:,112),MB,G3(:,:,:,298))
  call loop_QS_A(G3(:,:,:,298),wf(:,46),G3(:,:,:,299),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,299),Q(:,127),MB,G4tensor(:,102))
  call loop_QZ_A(G3(:,:,:,298),wf(:,69),G3(:,:,:,300),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,300),Q(:,127),MB,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,298),wf(:,70),G3(:,:,:,301),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,301),Q(:,127),MB,G4tensor(:,104))
  call loop_QS_A(G3(:,:,:,298),wf(:,59),G3(:,:,:,302),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,302),Q(:,127),MB,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,298),wf(:,71),G3(:,:,:,303),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,303),Q(:,127),MB,G4tensor(:,106))
  call loop_QZ_A(G3(:,:,:,298),wf(:,72),G3(:,:,:,304),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,304),Q(:,127),MB,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,298),wf(:,73),G3(:,:,:,305),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,305),Q(:,127),MB,G4tensor(:,108))
  call loop_QZ_A(G3(:,:,:,298),wf(:,74),G3(:,:,:,306),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,306),Q(:,127),MB,G4tensor(:,109))
  call loop_QZ_A(G3(:,:,:,298),wf(:,75),G3(:,:,:,307),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,307),Q(:,127),MB,G4tensor(:,110))
  call loop_QZ_A(G3(:,:,:,298),wf(:,76),G3(:,:,:,308),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,308),Q(:,127),MB,G4tensor(:,111))
  call loop_QZ_A(G2(:,:,:,332),wf(:,5),G2(:,:,:,334),gZd)
  call loop_Q_A(G2(:,:,:,334),Q(:,58),MB,G3(:,:,:,309))
  call loop_QV_A(G3(:,:,:,309),wf(:,-6),G3(:,:,:,310))
  call loop_Q_A(G3(:,:,:,310),Q(:,122),MB,G4(:,:,:,123))
  call loop_QZ_A(G4(:,:,:,123),wf(:,4),G4(:,:,:,124),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,127),MB,G5tensor(:,62))
  call loop_QZ_A(G2(:,:,:,332),wf(:,26),G2(:,:,:,335),gZd)
  call loop_Q_A(G2(:,:,:,335),Q(:,57),MB,G3(:,:,:,311))
  call loop_QV_A(G3(:,:,:,311),wf(:,-6),G3(:,:,:,312))
  call loop_Q_A(G3(:,:,:,312),Q(:,121),MB,G4(:,:,:,125))
  call loop_QZ_A(G4(:,:,:,125),wf(:,27),G4(:,:,:,126),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,127),MB,G5tensor(:,63))
  call loop_QZ_A(G1(:,:,:,100),wf(:,26),G1(:,:,:,104),gZd)
  call loop_Q_A(G1(:,:,:,104),Q(:,41),MB,G2(:,:,:,336))
  call loop_QV_A(G2(:,:,:,336),wf(:,7),G2(:,:,:,337))
  call loop_Q_A(G2(:,:,:,337),Q(:,121),MB,G3(:,:,:,313))
  call loop_QZ_A(G3(:,:,:,313),wf(:,27),G3(:,:,:,314),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,314),Q(:,127),MB,G4tensor(:,112))
  call loop_QV_A(G2(:,:,:,336),wf(:,-4),G2(:,:,:,338))
  call loop_Q_A(G2(:,:,:,338),Q(:,57),MB,G3(:,:,:,315))
  call loop_QV_A(G3(:,:,:,315),wf(:,-6),G3(:,:,:,316))
  call loop_Q_A(G3(:,:,:,316),Q(:,121),MB,G4(:,:,:,127))
  call loop_QZ_A(G4(:,:,:,127),wf(:,27),G4(:,:,:,128),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,127),MB,G5tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,32),ZERO,G1(:,:,:,105))
  call loop_QZ_A(G1(:,:,:,105),wf(:,5),G1(:,:,:,106),gZu)
  call loop_Q_A(G1(:,:,:,106),Q(:,42),ZERO,G2(:,:,:,339))
  call loop_QV_A(G2(:,:,:,339),wf(:,7),G2(:,:,:,340))
  call loop_Q_A(G2(:,:,:,340),Q(:,122),ZERO,G3(:,:,:,317))
  call loop_QZ_A(G3(:,:,:,317),wf(:,4),G3(:,:,:,318),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,318),Q(:,127),ZERO,G4tensor(:,113))
  call loop_QV_A(G2(:,:,:,339),wf(:,-4),G2(:,:,:,341))
  call loop_Q_A(G2(:,:,:,341),Q(:,58),ZERO,G3(:,:,:,319))
  call loop_QV_A(G3(:,:,:,319),wf(:,-6),G3(:,:,:,320))
  call loop_Q_A(G3(:,:,:,320),Q(:,122),ZERO,G4(:,:,:,129))
  call loop_QZ_A(G4(:,:,:,129),wf(:,4),G4(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,65))
  call loop_QZ_A(G1(:,:,:,105),wf(:,5),G1(:,:,:,107),gZd)
  call loop_Q_A(G1(:,:,:,107),Q(:,42),ZERO,G2(:,:,:,342))
  call loop_QV_A(G2(:,:,:,342),wf(:,7),G2(:,:,:,343))
  call loop_Q_A(G2(:,:,:,343),Q(:,122),ZERO,G3(:,:,:,321))
  call loop_QZ_A(G3(:,:,:,321),wf(:,4),G3(:,:,:,322),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,127),ZERO,G4tensor(:,114))
  call loop_QV_A(G2(:,:,:,342),wf(:,-4),G2(:,:,:,344))
  call loop_Q_A(G2(:,:,:,344),Q(:,58),ZERO,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,-6),G3(:,:,:,324))
  call loop_Q_A(G3(:,:,:,324),Q(:,122),ZERO,G4(:,:,:,131))
  call loop_QZ_A(G4(:,:,:,131),wf(:,4),G4(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,66))
  call loop_QV_A(G1(:,:,:,105),wf(:,-4),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,48),ZERO,G2(:,:,:,345))
  call loop_QZ_A(G2(:,:,:,345),wf(:,5),G2(:,:,:,346),gZu)
  call loop_Q_A(G2(:,:,:,346),Q(:,58),ZERO,G3(:,:,:,325))
  call loop_QV_A(G3(:,:,:,325),wf(:,-6),G3(:,:,:,326))
  call loop_Q_A(G3(:,:,:,326),Q(:,122),ZERO,G4(:,:,:,133))
  call loop_QZ_A(G4(:,:,:,133),wf(:,4),G4(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,67))
  call loop_QZ_A(G2(:,:,:,345),wf(:,5),G2(:,:,:,347),gZd)
  call loop_Q_A(G2(:,:,:,347),Q(:,58),ZERO,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,-6),G3(:,:,:,328))
  call loop_Q_A(G3(:,:,:,328),Q(:,122),ZERO,G4(:,:,:,135))
  call loop_QZ_A(G4(:,:,:,135),wf(:,4),G4(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,127),ZERO,G5tensor(:,68))
  call loop_QV_A(G2(:,:,:,345),wf(:,-6),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,112),ZERO,G3(:,:,:,329))
  call loop_QZ_A(G3(:,:,:,329),wf(:,69),G3(:,:,:,330),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,330),Q(:,127),ZERO,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,329),wf(:,69),G3(:,:,:,331),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,331),Q(:,127),ZERO,G4tensor(:,116))
  call loop_QZ_A(G3(:,:,:,329),wf(:,70),G3(:,:,:,332),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,127),ZERO,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,329),wf(:,70),G3(:,:,:,333),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,333),Q(:,127),ZERO,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,329),wf(:,71),G3(:,:,:,334),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,127),ZERO,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,329),wf(:,71),G3(:,:,:,335),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,335),Q(:,127),ZERO,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,329),wf(:,72),G3(:,:,:,336),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,336),Q(:,127),ZERO,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,329),wf(:,72),G3(:,:,:,337),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,337),Q(:,127),ZERO,G4tensor(:,122))
  call loop_QZ_A(G3(:,:,:,329),wf(:,73),G3(:,:,:,338),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,338),Q(:,127),ZERO,G4tensor(:,123))
  call loop_QZ_A(G3(:,:,:,329),wf(:,73),G3(:,:,:,339),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,339),Q(:,127),ZERO,G4tensor(:,124))
  call loop_QZ_A(G3(:,:,:,329),wf(:,74),G3(:,:,:,340),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,127),ZERO,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,329),wf(:,74),G3(:,:,:,341),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,341),Q(:,127),ZERO,G4tensor(:,126))
  call loop_QZ_A(G3(:,:,:,329),wf(:,75),G3(:,:,:,342),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,127),ZERO,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,329),wf(:,75),G3(:,:,:,343),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,343),Q(:,127),ZERO,G4tensor(:,128))
  call loop_QZ_A(G3(:,:,:,329),wf(:,76),G3(:,:,:,344),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,344),Q(:,127),ZERO,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,329),wf(:,76),G3(:,:,:,345),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,345),Q(:,127),ZERO,G4tensor(:,130))
  call loop_QZ_A(G2(:,:,:,345),wf(:,26),G2(:,:,:,349),gZu)
  call loop_Q_A(G2(:,:,:,349),Q(:,57),ZERO,G3(:,:,:,346))
  call loop_QV_A(G3(:,:,:,346),wf(:,-6),G3(:,:,:,347))
  call loop_Q_A(G3(:,:,:,347),Q(:,121),ZERO,G4(:,:,:,137))
  call loop_QZ_A(G4(:,:,:,137),wf(:,27),G4(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,127),ZERO,G5tensor(:,69))
  call loop_QZ_A(G2(:,:,:,345),wf(:,26),G2(:,:,:,350),gZd)
  call loop_Q_A(G2(:,:,:,350),Q(:,57),ZERO,G3(:,:,:,348))
  call loop_QV_A(G3(:,:,:,348),wf(:,-6),G3(:,:,:,349))
  call loop_Q_A(G3(:,:,:,349),Q(:,121),ZERO,G4(:,:,:,139))
  call loop_QZ_A(G4(:,:,:,139),wf(:,27),G4(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,127),ZERO,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,105),wf(:,7),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,112),ZERO,G2(:,:,:,351))
  call loop_QZ_A(G2(:,:,:,351),wf(:,69),G2(:,:,:,352),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,352),Q(:,127),ZERO,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,351),wf(:,69),G2(:,:,:,353),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,353),Q(:,127),ZERO,G3tensor(:,114))
  call loop_QZ_A(G2(:,:,:,351),wf(:,70),G2(:,:,:,354),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,354),Q(:,127),ZERO,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,351),wf(:,70),G2(:,:,:,355),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,355),Q(:,127),ZERO,G3tensor(:,116))
  call loop_QZ_A(G2(:,:,:,351),wf(:,71),G2(:,:,:,356),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,356),Q(:,127),ZERO,G3tensor(:,117))
  call loop_QZ_A(G2(:,:,:,351),wf(:,71),G2(:,:,:,357),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,357),Q(:,127),ZERO,G3tensor(:,118))
  call loop_QZ_A(G2(:,:,:,351),wf(:,72),G2(:,:,:,358),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,358),Q(:,127),ZERO,G3tensor(:,119))
  call loop_QZ_A(G2(:,:,:,351),wf(:,72),G2(:,:,:,359),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,359),Q(:,127),ZERO,G3tensor(:,120))
  call loop_QZ_A(G2(:,:,:,351),wf(:,73),G2(:,:,:,360),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,127),ZERO,G3tensor(:,121))
  call loop_QZ_A(G2(:,:,:,351),wf(:,73),G2(:,:,:,361),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,361),Q(:,127),ZERO,G3tensor(:,122))
  call loop_QZ_A(G2(:,:,:,351),wf(:,74),G2(:,:,:,362),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,362),Q(:,127),ZERO,G3tensor(:,123))
  call loop_QZ_A(G2(:,:,:,351),wf(:,74),G2(:,:,:,363),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,363),Q(:,127),ZERO,G3tensor(:,124))
  call loop_QZ_A(G2(:,:,:,351),wf(:,75),G2(:,:,:,364),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,364),Q(:,127),ZERO,G3tensor(:,125))
  call loop_QZ_A(G2(:,:,:,351),wf(:,75),G2(:,:,:,365),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,365),Q(:,127),ZERO,G3tensor(:,126))
  call loop_QZ_A(G2(:,:,:,351),wf(:,76),G2(:,:,:,366),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,366),Q(:,127),ZERO,G3tensor(:,127))
  call loop_QZ_A(G2(:,:,:,351),wf(:,76),G2(:,:,:,367),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,367),Q(:,127),ZERO,G3tensor(:,128))
  call loop_QZ_A(G1(:,:,:,105),wf(:,26),G1(:,:,:,110),gZu)
  call loop_Q_A(G1(:,:,:,110),Q(:,41),ZERO,G2(:,:,:,368))
  call loop_QV_A(G2(:,:,:,368),wf(:,7),G2(:,:,:,369))
  call loop_Q_A(G2(:,:,:,369),Q(:,121),ZERO,G3(:,:,:,350))
  call loop_QZ_A(G3(:,:,:,350),wf(:,27),G3(:,:,:,351),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,351),Q(:,127),ZERO,G4tensor(:,131))
  call loop_QV_A(G2(:,:,:,368),wf(:,-4),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,57),ZERO,G3(:,:,:,352))
  call loop_QV_A(G3(:,:,:,352),wf(:,-6),G3(:,:,:,353))
  call loop_Q_A(G3(:,:,:,353),Q(:,121),ZERO,G4(:,:,:,141))
  call loop_QZ_A(G4(:,:,:,141),wf(:,27),G4(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,127),ZERO,G5tensor(:,71))
  call loop_QZ_A(G1(:,:,:,105),wf(:,26),G1(:,:,:,111),gZd)
  call loop_Q_A(G1(:,:,:,111),Q(:,41),ZERO,G2(:,:,:,371))
  call loop_QV_A(G2(:,:,:,371),wf(:,7),G2(:,:,:,372))
  call loop_Q_A(G2(:,:,:,372),Q(:,121),ZERO,G3(:,:,:,354))
  call loop_QZ_A(G3(:,:,:,354),wf(:,27),G3(:,:,:,355),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,355),Q(:,127),ZERO,G4tensor(:,132))
  call loop_QV_A(G2(:,:,:,371),wf(:,-4),G2(:,:,:,373))
  call loop_Q_A(G2(:,:,:,373),Q(:,57),ZERO,G3(:,:,:,356))
  call loop_QV_A(G3(:,:,:,356),wf(:,-6),G3(:,:,:,357))
  call loop_Q_A(G3(:,:,:,357),Q(:,121),ZERO,G4(:,:,:,143))
  call loop_QZ_A(G4(:,:,:,143),wf(:,27),G4(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,127),ZERO,G5tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,32),ZERO,G1(:,:,:,112))
  call loop_AZ_Q(G1(:,:,:,112),wf(:,5),G1(:,:,:,113),gZu)
  call loop_A_Q(G1(:,:,:,113),Q(:,42),ZERO,G2(:,:,:,374))
  call loop_AV_Q(G2(:,:,:,374),wf(:,7),G2(:,:,:,375))
  call loop_A_Q(G2(:,:,:,375),Q(:,122),ZERO,G3(:,:,:,358))
  call loop_AZ_Q(G3(:,:,:,358),wf(:,4),G3(:,:,:,359),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,359),Q(:,127),ZERO,G4tensor(:,133))
  call loop_AV_Q(G2(:,:,:,374),wf(:,-4),G2(:,:,:,376))
  call loop_A_Q(G2(:,:,:,376),Q(:,58),ZERO,G3(:,:,:,360))
  call loop_AV_Q(G3(:,:,:,360),wf(:,-6),G3(:,:,:,361))
  call loop_A_Q(G3(:,:,:,361),Q(:,122),ZERO,G4(:,:,:,145))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,4),G4(:,:,:,146),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),ZERO,G5tensor(:,73))
  call loop_AZ_Q(G1(:,:,:,112),wf(:,5),G1(:,:,:,114),gZd)
  call loop_A_Q(G1(:,:,:,114),Q(:,42),ZERO,G2(:,:,:,377))
  call loop_AV_Q(G2(:,:,:,377),wf(:,7),G2(:,:,:,378))
  call loop_A_Q(G2(:,:,:,378),Q(:,122),ZERO,G3(:,:,:,362))
  call loop_AZ_Q(G3(:,:,:,362),wf(:,4),G3(:,:,:,363),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,363),Q(:,127),ZERO,G4tensor(:,134))
  call loop_AV_Q(G2(:,:,:,377),wf(:,-4),G2(:,:,:,379))
  call loop_A_Q(G2(:,:,:,379),Q(:,58),ZERO,G3(:,:,:,364))
  call loop_AV_Q(G3(:,:,:,364),wf(:,-6),G3(:,:,:,365))
  call loop_A_Q(G3(:,:,:,365),Q(:,122),ZERO,G4(:,:,:,147))
  call loop_AZ_Q(G4(:,:,:,147),wf(:,4),G4(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,127),ZERO,G5tensor(:,74))
  call loop_AV_Q(G1(:,:,:,112),wf(:,-4),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,48),ZERO,G2(:,:,:,380))
  call loop_AZ_Q(G2(:,:,:,380),wf(:,5),G2(:,:,:,381),gZu)
  call loop_A_Q(G2(:,:,:,381),Q(:,58),ZERO,G3(:,:,:,366))
  call loop_AV_Q(G3(:,:,:,366),wf(:,-6),G3(:,:,:,367))
  call loop_A_Q(G3(:,:,:,367),Q(:,122),ZERO,G4(:,:,:,149))
  call loop_AZ_Q(G4(:,:,:,149),wf(:,4),G4(:,:,:,150),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,127),ZERO,G5tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,380),wf(:,5),G2(:,:,:,382),gZd)
  call loop_A_Q(G2(:,:,:,382),Q(:,58),ZERO,G3(:,:,:,368))
  call loop_AV_Q(G3(:,:,:,368),wf(:,-6),G3(:,:,:,369))
  call loop_A_Q(G3(:,:,:,369),Q(:,122),ZERO,G4(:,:,:,151))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,4),G4(:,:,:,152),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),ZERO,G5tensor(:,76))
  call loop_AV_Q(G2(:,:,:,380),wf(:,-6),G2(:,:,:,383))
  call loop_A_Q(G2(:,:,:,383),Q(:,112),ZERO,G3(:,:,:,370))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,69),G3(:,:,:,371),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,371),Q(:,127),ZERO,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,69),G3(:,:,:,372),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,372),Q(:,127),ZERO,G4tensor(:,136))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,70),G3(:,:,:,373),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,373),Q(:,127),ZERO,G4tensor(:,137))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,70),G3(:,:,:,374),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,374),Q(:,127),ZERO,G4tensor(:,138))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,71),G3(:,:,:,375),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,375),Q(:,127),ZERO,G4tensor(:,139))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,71),G3(:,:,:,376),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,376),Q(:,127),ZERO,G4tensor(:,140))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,72),G3(:,:,:,377),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,377),Q(:,127),ZERO,G4tensor(:,141))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,72),G3(:,:,:,378),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,378),Q(:,127),ZERO,G4tensor(:,142))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,73),G3(:,:,:,379),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,379),Q(:,127),ZERO,G4tensor(:,143))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,73),G3(:,:,:,380),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,380),Q(:,127),ZERO,G4tensor(:,144))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,74),G3(:,:,:,381),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,381),Q(:,127),ZERO,G4tensor(:,145))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,74),G3(:,:,:,382),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,382),Q(:,127),ZERO,G4tensor(:,146))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,75),G3(:,:,:,383),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,383),Q(:,127),ZERO,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,75),G3(:,:,:,384),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,384),Q(:,127),ZERO,G4tensor(:,148))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,76),G3(:,:,:,385),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,385),Q(:,127),ZERO,G4tensor(:,149))
  call loop_AZ_Q(G3(:,:,:,370),wf(:,76),G3(:,:,:,386),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,386),Q(:,127),ZERO,G4tensor(:,150))
  call loop_AZ_Q(G2(:,:,:,380),wf(:,26),G2(:,:,:,384),gZu)
  call loop_A_Q(G2(:,:,:,384),Q(:,57),ZERO,G3(:,:,:,387))
  call loop_AV_Q(G3(:,:,:,387),wf(:,-6),G3(:,:,:,388))
  call loop_A_Q(G3(:,:,:,388),Q(:,121),ZERO,G4(:,:,:,153))
  call loop_AZ_Q(G4(:,:,:,153),wf(:,27),G4(:,:,:,154),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,127),ZERO,G5tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,380),wf(:,26),G2(:,:,:,385),gZd)
  call loop_A_Q(G2(:,:,:,385),Q(:,57),ZERO,G3(:,:,:,389))
  call loop_AV_Q(G3(:,:,:,389),wf(:,-6),G3(:,:,:,390))
  call loop_A_Q(G3(:,:,:,390),Q(:,121),ZERO,G4(:,:,:,155))
  call loop_AZ_Q(G4(:,:,:,155),wf(:,27),G4(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,127),ZERO,G5tensor(:,78))
  call loop_AV_Q(G1(:,:,:,112),wf(:,7),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,112),ZERO,G2(:,:,:,386))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,69),G2(:,:,:,387),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,387),Q(:,127),ZERO,G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,69),G2(:,:,:,388),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,388),Q(:,127),ZERO,G3tensor(:,130))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,70),G2(:,:,:,389),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,389),Q(:,127),ZERO,G3tensor(:,131))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,70),G2(:,:,:,390),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,390),Q(:,127),ZERO,G3tensor(:,132))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,71),G2(:,:,:,391),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,391),Q(:,127),ZERO,G3tensor(:,133))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,71),G2(:,:,:,392),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,127),ZERO,G3tensor(:,134))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,72),G2(:,:,:,393),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,393),Q(:,127),ZERO,G3tensor(:,135))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,72),G2(:,:,:,394),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,394),Q(:,127),ZERO,G3tensor(:,136))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,73),G2(:,:,:,395),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,395),Q(:,127),ZERO,G3tensor(:,137))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,73),G2(:,:,:,396),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,396),Q(:,127),ZERO,G3tensor(:,138))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,74),G2(:,:,:,397),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,397),Q(:,127),ZERO,G3tensor(:,139))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,74),G2(:,:,:,398),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,398),Q(:,127),ZERO,G3tensor(:,140))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,75),G2(:,:,:,399),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,399),Q(:,127),ZERO,G3tensor(:,141))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,75),G2(:,:,:,400),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,400),Q(:,127),ZERO,G3tensor(:,142))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,76),G2(:,:,:,401),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,401),Q(:,127),ZERO,G3tensor(:,143))
  call loop_AZ_Q(G2(:,:,:,386),wf(:,76),G2(:,:,:,402),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,402),Q(:,127),ZERO,G3tensor(:,144))
  call loop_AZ_Q(G1(:,:,:,112),wf(:,26),G1(:,:,:,117),gZu)
  call loop_A_Q(G1(:,:,:,117),Q(:,41),ZERO,G2(:,:,:,403))
  call loop_AV_Q(G2(:,:,:,403),wf(:,7),G2(:,:,:,404))
  call loop_A_Q(G2(:,:,:,404),Q(:,121),ZERO,G3(:,:,:,391))
  call loop_AZ_Q(G3(:,:,:,391),wf(:,27),G3(:,:,:,392),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,392),Q(:,127),ZERO,G4tensor(:,151))
  call loop_AV_Q(G2(:,:,:,403),wf(:,-4),G2(:,:,:,405))
  call loop_A_Q(G2(:,:,:,405),Q(:,57),ZERO,G3(:,:,:,393))
  call loop_AV_Q(G3(:,:,:,393),wf(:,-6),G3(:,:,:,394))
  call loop_A_Q(G3(:,:,:,394),Q(:,121),ZERO,G4(:,:,:,157))
  call loop_AZ_Q(G4(:,:,:,157),wf(:,27),G4(:,:,:,158),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,158),Q(:,127),ZERO,G5tensor(:,79))
  call loop_AZ_Q(G1(:,:,:,112),wf(:,26),G1(:,:,:,118),gZd)
  call loop_A_Q(G1(:,:,:,118),Q(:,41),ZERO,G2(:,:,:,406))
  call loop_AV_Q(G2(:,:,:,406),wf(:,7),G2(:,:,:,407))
  call loop_A_Q(G2(:,:,:,407),Q(:,121),ZERO,G3(:,:,:,395))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,27),G3(:,:,:,396),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,396),Q(:,127),ZERO,G4tensor(:,152))
  call loop_AV_Q(G2(:,:,:,406),wf(:,-4),G2(:,:,:,408))
  call loop_A_Q(G2(:,:,:,408),Q(:,57),ZERO,G3(:,:,:,397))
  call loop_AV_Q(G3(:,:,:,397),wf(:,-6),G3(:,:,:,398))
  call loop_A_Q(G3(:,:,:,398),Q(:,121),ZERO,G4(:,:,:,159))
  call loop_AZ_Q(G4(:,:,:,159),wf(:,27),G4(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,160),Q(:,127),ZERO,G5tensor(:,80))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(11) * den(37)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(11)) * den(37)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(37)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(11)) * den(37)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(9) * den(37)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(37)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(9) * den(37)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(37)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,31),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,13),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_24,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,14),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_24,masses2_6,G4tensor(:,14),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,5),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_24,masses2_4,G4tensor(:,5),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,23),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,23),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,29),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,29),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,35),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,35),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,53),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,53),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,59),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,59),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,30),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,30),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,36),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,36),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,18),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,18),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,24),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,24),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,54),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,54),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,60),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(6)) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,42),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(6) * den(86)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,42),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(5)) * den(86)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,48),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(5) * den(86)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,48),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(11)) * den(38)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(11) * den(38)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(38)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(11) * den(38)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(9)) * den(38)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(38)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,93),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(9)) * den(38)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(38)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,103),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,113),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,113),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,77),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,77),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,133),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,65),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_21,masses2_5,G4tensor(:,65),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,114),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,114),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,101),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,101),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,134),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,134),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,89),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,89),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,19),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,19),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,25),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,25),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,31),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,31),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,37),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,37),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,43),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,43),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,49),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,49),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,55),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,55),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,61),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,61),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,32),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,32),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,38),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,38),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,20),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,20),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,26),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,26),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,56),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,56),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,62),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,62),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(6) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,44),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(6)) * den(87)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,44),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(5) * den(87)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,50),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(5)) * den(87)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,50),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,21),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,21),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,27),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,27),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,33),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,33),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,39),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,39),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,51),T4sum(1:70,24))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,51),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,57),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,57),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,63),T4sum(1:70,24))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,63),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,34),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,34),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,40),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,40),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,22),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,22),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,28),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,28),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,58),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,58),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,64),T4sum(1:70,27))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,64),T4sum(1:70,27))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,52),T4sum(1:70,27))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,52),T4sum(1:70,27))
  M(1) = M(1) + (-f(12) * den(36)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,78),T4sum(1:70,28))
  M(2) = M(2) + (-f(12) * den(36)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,66),T4sum(1:70,28))
  M(1) = M(1) + (-f(10) * den(36)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,102),T4sum(1:70,29))
  M(2) = M(2) + (-f(10) * den(36)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,90),T4sum(1:70,29))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_35,masses2_8,G5tensor(:,7),T5sum(1:126,2))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,13),T5sum(1:126,1))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_35,masses2_8,G5tensor(:,19),T5sum(1:126,2))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,25),T5sum(1:126,1))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_35,masses2_7,G5tensor(:,31),T5sum(1:126,3))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_35,masses2_9,G5tensor(:,37),T5sum(1:126,1))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_35,masses2_7,G5tensor(:,43),T5sum(1:126,3))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,15),T5sum(1:126,4))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_33,masses2_8,G5tensor(:,21),T5sum(1:126,5))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,3),T5sum(1:126,4))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_33,masses2_8,G5tensor(:,9),T5sum(1:126,5))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,39),T5sum(1:126,4))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_33,masses2_7,G5tensor(:,45),T5sum(1:126,6))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_33,masses2_9,G5tensor(:,27),T5sum(1:126,4))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_33,masses2_7,G5tensor(:,33),T5sum(1:126,6))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,14),T5sum(1:126,7))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_36,masses2_8,G5tensor(:,20),T5sum(1:126,8))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,2),T5sum(1:126,7))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_36,masses2_8,G5tensor(:,8),T5sum(1:126,8))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,38),T5sum(1:126,7))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_36,masses2_7,G5tensor(:,44),T5sum(1:126,9))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_36,masses2_9,G5tensor(:,26),T5sum(1:126,7))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_36,masses2_7,G5tensor(:,32),T5sum(1:126,9))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,5),T5sum(1:126,13))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_31,masses2_8,G5tensor(:,11),T5sum(1:126,14))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,17),T5sum(1:126,13))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_31,masses2_8,G5tensor(:,23),T5sum(1:126,14))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,29),T5sum(1:126,13))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_31,masses2_7,G5tensor(:,35),T5sum(1:126,15))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_31,masses2_9,G5tensor(:,41),T5sum(1:126,13))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_31,masses2_7,G5tensor(:,47),T5sum(1:126,15))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,67),T5sum(1:126,16))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_48,masses2_8,G5tensor(:,54),T5sum(1:126,17))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,75),T5sum(1:126,16))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_48,masses2_8,G5tensor(:,50),T5sum(1:126,17))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,68),T5sum(1:126,16))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,62),T5sum(1:126,18))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,76),T5sum(1:126,16))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,58),T5sum(1:126,18))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,16),T5sum(1:126,19))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_34,masses2_8,G5tensor(:,22),T5sum(1:126,20))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,4),T5sum(1:126,19))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_34,masses2_8,G5tensor(:,10),T5sum(1:126,20))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,40),T5sum(1:126,19))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_34,masses2_7,G5tensor(:,46),T5sum(1:126,21))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_34,masses2_9,G5tensor(:,28),T5sum(1:126,19))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_34,masses2_7,G5tensor(:,34),T5sum(1:126,21))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,6),T5sum(1:126,25))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_32,masses2_8,G5tensor(:,12),T5sum(1:126,26))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,18),T5sum(1:126,25))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_32,masses2_8,G5tensor(:,24),T5sum(1:126,26))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,30),T5sum(1:126,25))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_32,masses2_7,G5tensor(:,36),T5sum(1:126,27))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_32,masses2_9,G5tensor(:,42),T5sum(1:126,25))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_32,masses2_7,G5tensor(:,48),T5sum(1:126,27))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,73),T5sum(1:126,28))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_46,masses2_8,G5tensor(:,49),T5sum(1:126,29))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,65),T5sum(1:126,28))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_46,masses2_8,G5tensor(:,53),T5sum(1:126,29))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,74),T5sum(1:126,28))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,57),T5sum(1:126,30))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,66),T5sum(1:126,28))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,61),T5sum(1:126,30))
  M(1) = M(1) + (-(CI*f(6)) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,41),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,41),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(89)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,57),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,57),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(89)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,42),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,42),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(89)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,32),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(89)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,58),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(89)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,43),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,43),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(90)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(90)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,59),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,59),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(90)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(90)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,44),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,44),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(90)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(90)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,33),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,60),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(90)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,60),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(90)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(90)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(91)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(91)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(91)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(91)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(91)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(91)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,104),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,130),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(91)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,130),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(91)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(91)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,94),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(92)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,131),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,131),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(92)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(92)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,105),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(92)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(92)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(92)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,95),T3sum(1:35,4))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,115),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,79),T4sum(1:70,28))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,135),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,67),T4sum(1:70,28))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,116),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,103),T4sum(1:70,29))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,136),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,91),T4sum(1:70,29))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,117),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,80),T4sum(1:70,28))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,137),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,68),T4sum(1:70,28))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,118),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,104),T4sum(1:70,29))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,138),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,92),T4sum(1:70,29))
  M(1) = M(1) + (-(CI*f(11)) * den(52)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(52)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(11)) * den(52)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(52)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(9)) * den(52)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(9) * den(52)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(9)) * den(52)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(9) * den(52)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,34),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,15),T4sum(1:70,37))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,2),T4sum(1:70,38))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,2),T4sum(1:70,38))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,11),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,11),T4sum(1:70,37))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,4),T4sum(1:70,38))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_23,masses2_5,G4tensor(:,4),T4sum(1:70,38))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,16),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,16),T4sum(1:70,37))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,6),T4sum(1:70,39))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,6),T4sum(1:70,39))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,12),T4sum(1:70,37))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_23,masses2_6,G4tensor(:,12),T4sum(1:70,37))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,8),T4sum(1:70,39))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_23,masses2_4,G4tensor(:,8),T4sum(1:70,39))
  M(1) = M(1) + (CI*f(11) * den(53)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(53)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(11) * den(53)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(11)) * den(53)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(9) * den(53)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(53)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,96),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(9) * den(53)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(53)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,106),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,151),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,151),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,76),T4sum(1:70,47))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,76),T4sum(1:70,47))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,131),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,131),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,88),T4sum(1:70,47))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_20,masses2_5,G4tensor(:,88),T4sum(1:70,47))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,152),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,152),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,100),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,100),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,132),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,132),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,112),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,112),T4sum(1:70,48))
  M(1) = M(1) + (f(12) * den(51)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,81),T4sum(1:70,28))
  M(2) = M(2) + (f(12) * den(51)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,69),T4sum(1:70,28))
  M(1) = M(1) + (f(10) * den(51)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,105),T4sum(1:70,29))
  M(2) = M(2) + (f(10) * den(51)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,93),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,69),T5sum(1:126,46))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_47,masses2_8,G5tensor(:,55),T5sum(1:126,47))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,77),T5sum(1:126,46))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_47,masses2_8,G5tensor(:,51),T5sum(1:126,47))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,70),T5sum(1:126,46))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,63),T5sum(1:126,48))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,78),T5sum(1:126,46))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,59),T5sum(1:126,48))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,79),T5sum(1:126,58))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_45,masses2_8,G5tensor(:,52),T5sum(1:126,59))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,71),T5sum(1:126,58))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_45,masses2_8,G5tensor(:,56),T5sum(1:126,59))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,80),T5sum(1:126,58))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,60),T5sum(1:126,60))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,72),T5sum(1:126,58))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,64),T5sum(1:126,60))
  M(1) = M(1) + (CI*f(6) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,45),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(98)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(98)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,61),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(98)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(98)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,46),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,46),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(98)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(98)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,62),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(98)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,62),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(98)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(98)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,47),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,47),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(99)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(99)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,63),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,63),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(99)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(99)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,48),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,48),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(99)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(99)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,64),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(99)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,64),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(99)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(99)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(100)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(100)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,133),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,133),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(100)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(100)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(100)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(100)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,107),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,134),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(100)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,134),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(100)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(100)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,97),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(101)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(101)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(101)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(101)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(101)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(101)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,108),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(101)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(101)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(101)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,98),T3sum(1:35,4))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,119),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,82),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,139),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,70),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,120),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,106),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,140),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,94),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,121),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,83),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,141),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,71),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,122),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,107),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,142),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,95),T4sum(1:70,29))
  M(1) = M(1) + (CI*f(6) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,49),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,49),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(104)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(104)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,65),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(104)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(104)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,50),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(104)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(104)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,66),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(104)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,66),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(104)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(104)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,51),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,51),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(105)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(105)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,67),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(105)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(5)) * den(105)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(6) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,52),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,52),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(105)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(105)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(105)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,68),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(5) * den(105)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(5)) * den(105)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,28),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(106)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(106)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,137),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,137),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(106)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(106)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(106)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(106)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,109),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,138),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(106)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,138),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(106)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(106)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,99),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(107)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(107)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,139),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,139),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(107)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(5) * den(107)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(107)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(107)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,110),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(6)) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,140),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(6) * den(107)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,140),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(5)) * den(107)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(5) * den(107)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,100),T3sum(1:35,4))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,123),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,84),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,143),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,72),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,124),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,108),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,144),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,96),T4sum(1:70,29))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,125),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,85),T4sum(1:70,28))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,145),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,73),T4sum(1:70,28))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,126),T4sum(1:70,34))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,109),T4sum(1:70,29))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,146),T4sum(1:70,34))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,97),T4sum(1:70,29))
  M(1) = M(1) + (-(CI*f(6)) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,53),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(110)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(110)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(110)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(110)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,54),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,54),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(110)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(110)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(110)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(110)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(110)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,29),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,55),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,55),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(111)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(111)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(111)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(5) * den(111)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,56),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,56),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(111)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(111)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(6)) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(6) * den(111)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(5)) * den(111)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(5) * den(111)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,30),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,125),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,125),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(112)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(112)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,91),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(112)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(112)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(112)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(112)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,111),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,142),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(112)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,142),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(112)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(112)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,101),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,127),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,127),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(113)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,92),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,143),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,143),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(113)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(6) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,128),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,128),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(113)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,112),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(6) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(113)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(5) * den(113)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,102),T3sum(1:35,4))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,127),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,86),T4sum(1:70,28))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,147),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,74),T4sum(1:70,28))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,128),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,110),T4sum(1:70,29))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,148),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,98),T4sum(1:70,29))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,129),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,87),T4sum(1:70,28))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,149),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_22,masses2_5,G4tensor(:,75),T4sum(1:70,28))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,130),T4sum(1:70,34))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,111),T4sum(1:70,29))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,150),T4sum(1:70,34))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,99),T4sum(1:70,29))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_nenenexnexggg_1_/**/REALKIND
