
module ol_vamp_1_ppllllj2_eexmmxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eexmmxuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eexmmxuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eexmmxuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eexmmxuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,21) :: G0
  complex(REALKIND), dimension(4,5,4,68) :: G1
  complex(REALKIND), dimension(4,15,4,206) :: G2
  complex(REALKIND), dimension(4,35,4,132) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,116,128))
    allocate(G4tensorhel(70,90,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,12),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,66),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,67),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,68),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,69),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,1),wf(:,70),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,71),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,1),wf(:,72),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,73),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QV_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,1),wf(:,76),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,1),wf(:,77),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_QV_A(G2(:,:,:,1),wf(:,78),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_QV_A(G2(:,:,:,1),wf(:,79),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,1),wf(:,80),G2(:,:,:,17),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,1),wf(:,81),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-6),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,124),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,127),MT,G4tensor(:,2))
  call loop_QZ_A(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-6),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,124),MT,G3(:,:,:,4))
  call loop_QV_A(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_Q_A(l_switch,G3(:,:,:,5),Q(:,127),MT,G4tensor(:,3))
  call loop_QZ_A(G3(:,:,:,4),wf(:,9),G3(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,12),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,23),wf(:,66),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,67),G2(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,23),wf(:,68),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,69),G2(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,23),wf(:,70),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,71),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,23),wf(:,72),G2(:,:,:,31))
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,73),G2(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,23),wf(:,74),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,75),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,23),wf(:,76),G2(:,:,:,35))
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,77),G2(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,23),wf(:,78),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,23),wf(:,79),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MT,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,80),G2(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),MT,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,81),G2(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-6),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,124),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,9),G3(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),MT,G4tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,6),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-6),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,124),MT,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,1),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),MT,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,9),G3(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,12),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,45),wf(:,66),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,45),wf(:,67),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,45),wf(:,68),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,45),wf(:,69),G2(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,45),wf(:,70),G2(:,:,:,51))
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,45),wf(:,71),G2(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,45),wf(:,72),G2(:,:,:,53))
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,73),G2(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,43))
  call loop_QV_A(G2(:,:,:,45),wf(:,74),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,45),wf(:,75),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,76),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,77),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,47))
  call loop_QV_A(G2(:,:,:,45),wf(:,78),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,45),wf(:,79),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,49))
  call loop_QZ_A(G2(:,:,:,45),wf(:,80),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,45),wf(:,81),G2(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,127),MB,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,60),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-6),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,124),MB,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,9),G3(:,:,:,15),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,127),MB,G4tensor(:,10))
  call loop_QZ_A(G1(:,:,:,9),wf(:,6),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-6),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,124),MB,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,127),MB,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,16),wf(:,9),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,67))
  call loop_AS_Q(G2(:,:,:,67),wf(:,12),G2(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),MB,G3tensor(:,52))
  call loop_AV_Q(G2(:,:,:,67),wf(:,66),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),MB,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,67),G2(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),MB,G3tensor(:,54))
  call loop_AV_Q(G2(:,:,:,67),wf(:,68),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),MB,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,69),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),MB,G3tensor(:,56))
  call loop_AV_Q(G2(:,:,:,67),wf(:,70),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),MB,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,71),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MB,G3tensor(:,58))
  call loop_AV_Q(G2(:,:,:,67),wf(:,72),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,73),G2(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,60))
  call loop_AV_Q(G2(:,:,:,67),wf(:,74),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,75),G2(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,62))
  call loop_AV_Q(G2(:,:,:,67),wf(:,76),G2(:,:,:,79))
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,77),G2(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,64))
  call loop_AV_Q(G2(:,:,:,67),wf(:,78),G2(:,:,:,81))
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,65))
  call loop_AV_Q(G2(:,:,:,67),wf(:,79),G2(:,:,:,82))
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),MB,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,80),G2(:,:,:,83),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,81),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),MB,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,9),G3(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),MB,G4tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,6),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MB,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,124),MB,G3(:,:,:,22))
  call loop_AV_Q(G3(:,:,:,22),wf(:,1),G3(:,:,:,23))
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MB,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,9),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MB,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,60),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-6),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,9),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,9),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,6),G1(:,:,:,19),gZu)
  call loop_A_Q(G1(:,:,:,19),Q(:,60),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-6),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,9),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,6),G1(:,:,:,20),gZd)
  call loop_A_Q(G1(:,:,:,20),Q(:,60),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,124),ZERO,G3(:,:,:,32))
  call loop_AV_Q(G3(:,:,:,32),wf(:,1),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AZ_Q(G3(:,:,:,32),wf(:,9),G3(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,112),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,66),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,67),G2(:,:,:,97),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,67),G2(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,95),wf(:,68),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,69),G2(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,73))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,69),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,74))
  call loop_AV_Q(G2(:,:,:,95),wf(:,70),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,71),G2(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,71),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,77))
  call loop_AV_Q(G2(:,:,:,95),wf(:,72),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,78))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,73),G2(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,73),G2(:,:,:,107),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,127),ZERO,G3tensor(:,80))
  call loop_AV_Q(G2(:,:,:,95),wf(:,74),G2(:,:,:,108))
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,127),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,109),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,127),ZERO,G3tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,75),G2(:,:,:,110),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,127),ZERO,G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,95),wf(:,76),G2(:,:,:,111))
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,127),ZERO,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,77),G2(:,:,:,112),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,127),ZERO,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,77),G2(:,:,:,113),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,127),ZERO,G3tensor(:,86))
  call loop_AV_Q(G2(:,:,:,95),wf(:,78),G2(:,:,:,114))
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,127),ZERO,G3tensor(:,87))
  call loop_AV_Q(G2(:,:,:,95),wf(:,79),G2(:,:,:,115))
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,127),ZERO,G3tensor(:,88))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,80),G2(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,127),ZERO,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,80),G2(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,90))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,81),G2(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,127),ZERO,G3tensor(:,91))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,81),G2(:,:,:,119),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,127),ZERO,G3tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,2),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,60),ZERO,G2(:,:,:,120))
  call loop_QV_A(G2(:,:,:,120),wf(:,-6),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,124),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,24))
  call loop_QZ_A(G3(:,:,:,35),wf(:,9),G3(:,:,:,37),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,37),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,35),wf(:,9),G3(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QZ_A(G1(:,:,:,22),wf(:,6),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,60),ZERO,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,-6),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,124),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,1),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,39),wf(:,9),G3(:,:,:,41),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,28))
  call loop_QZ_A(G1(:,:,:,22),wf(:,6),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,60),ZERO,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,-6),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,124),ZERO,G3(:,:,:,42))
  call loop_QV_A(G3(:,:,:,42),wf(:,1),G3(:,:,:,43))
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,42),wf(:,9),G3(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,22),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),ZERO,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,66),G2(:,:,:,127))
  call check_last_Q_A(l_switch,G2(:,:,:,127),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,126),wf(:,67),G2(:,:,:,128),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,126),wf(:,67),G2(:,:,:,129),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QV_A(G2(:,:,:,126),wf(:,68),G2(:,:,:,130))
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QZ_A(G2(:,:,:,126),wf(:,69),G2(:,:,:,131),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,126),wf(:,69),G2(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QV_A(G2(:,:,:,126),wf(:,70),G2(:,:,:,133))
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,126),wf(:,71),G2(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,126),wf(:,71),G2(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,126),wf(:,72),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,102))
  call loop_QZ_A(G2(:,:,:,126),wf(:,73),G2(:,:,:,137),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,126),wf(:,73),G2(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,104))
  call loop_QV_A(G2(:,:,:,126),wf(:,74),G2(:,:,:,139))
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,105))
  call loop_QZ_A(G2(:,:,:,126),wf(:,75),G2(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,126),wf(:,75),G2(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,107))
  call loop_QV_A(G2(:,:,:,126),wf(:,76),G2(:,:,:,142))
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,126),wf(:,77),G2(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,126),wf(:,77),G2(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,110))
  call loop_QV_A(G2(:,:,:,126),wf(:,78),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,111))
  call loop_QV_A(G2(:,:,:,126),wf(:,79),G2(:,:,:,146))
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,112))
  call loop_QZ_A(G2(:,:,:,126),wf(:,80),G2(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,126),wf(:,80),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,114))
  call loop_QZ_A(G2(:,:,:,126),wf(:,81),G2(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,126),wf(:,81),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,116))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,3),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,60),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-6),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,124),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,1),G3(:,:,:,46))
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),ZERO,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,9),G3(:,:,:,47),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),ZERO,G4tensor(:,32))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,9),G3(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-6),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,76),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,3),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,124),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,1),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,51),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,30))
  call loop_AV_Q(G1(:,:,:,30),wf(:,3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,60),MT,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-6),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,124),MT,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,1),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),MT,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,9),G3(:,:,:,55),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),MT,G4tensor(:,38))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-6),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,76),MT,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,3),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,124),MT,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,1),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,127),MT,G4tensor(:,39))
  call loop_AZ_Q(G3(:,:,:,56),wf(:,9),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,3),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,60),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,-6),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,124),ZERO,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,1),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,59),wf(:,9),G3(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,127),ZERO,G4tensor(:,42))
  call loop_QZ_A(G3(:,:,:,59),wf(:,9),G3(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,43))
  call loop_QV_A(G1(:,:,:,33),wf(:,-6),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,76),ZERO,G2(:,:,:,161))
  call loop_QV_A(G2(:,:,:,161),wf(:,3),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,124),ZERO,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,1),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,63),wf(:,9),G3(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,127),ZERO,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,63),wf(:,9),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,3),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,60),MT,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,-6),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,124),MT,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,1),G3(:,:,:,68))
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),MT,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,67),wf(:,9),G3(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,127),MT,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,36),wf(:,-6),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,76),MT,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,3),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,124),MT,G3(:,:,:,70))
  call loop_QV_A(G3(:,:,:,70),wf(:,1),G3(:,:,:,71))
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,127),MT,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,70),wf(:,9),G3(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,50))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MB,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,3),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,60),MB,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-6),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,124),MB,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,1),G3(:,:,:,74))
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),MB,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,9),G3(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,127),MB,G4tensor(:,52))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-6),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,76),MB,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,3),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,124),MB,G3(:,:,:,76))
  call loop_AV_Q(G3(:,:,:,76),wf(:,1),G3(:,:,:,77))
  call check_last_A_Q(l_switch,G3(:,:,:,77),Q(:,127),MB,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,76),wf(:,9),G3(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),MB,G4tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,60),MB,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-6),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,124),MB,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,1),G3(:,:,:,80))
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),MB,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,79),wf(:,9),G3(:,:,:,81),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,127),MB,G4tensor(:,56))
  call loop_QV_A(G1(:,:,:,42),wf(:,-6),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,76),MB,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,3),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,124),MB,G3(:,:,:,82))
  call loop_QV_A(G3(:,:,:,82),wf(:,1),G3(:,:,:,83))
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),MB,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,82),wf(:,9),G3(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),MB,G4tensor(:,58))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,60),ZERO,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-6),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,124),ZERO,G3(:,:,:,85))
  call loop_AV_Q(G3(:,:,:,85),wf(:,1),G3(:,:,:,86))
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),ZERO,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,85),wf(:,9),G3(:,:,:,87),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,87),Q(:,127),ZERO,G4tensor(:,60))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-6),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,76),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,3),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,124),ZERO,G3(:,:,:,88))
  call loop_AV_Q(G3(:,:,:,88),wf(:,1),G3(:,:,:,89))
  call check_last_A_Q(l_switch,G3(:,:,:,89),Q(:,127),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,9),G3(:,:,:,90),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),ZERO,G4tensor(:,62))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,48))
  call loop_AV_Q(G1(:,:,:,48),wf(:,3),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,60),MT,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-6),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,124),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,1),G3(:,:,:,92))
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,9),G3(:,:,:,93),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,127),MT,G4tensor(:,64))
  call loop_AV_Q(G1(:,:,:,48),wf(:,-6),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,76),MT,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,3),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,124),MT,G3(:,:,:,94))
  call loop_AV_Q(G3(:,:,:,94),wf(:,1),G3(:,:,:,95))
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,127),MT,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,94),wf(:,9),G3(:,:,:,96),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),MT,G4tensor(:,66))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,60),ZERO,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,-6),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,124),ZERO,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,1),G3(:,:,:,98))
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),ZERO,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,97),wf(:,9),G3(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,127),ZERO,G4tensor(:,68))
  call loop_QV_A(G1(:,:,:,51),wf(:,-6),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,76),ZERO,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,3),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,124),ZERO,G3(:,:,:,100))
  call loop_QV_A(G3(:,:,:,100),wf(:,1),G3(:,:,:,101))
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,127),ZERO,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,100),wf(:,9),G3(:,:,:,102),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),ZERO,G4tensor(:,70))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,60),MT,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,-6),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,124),MT,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,1),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),MT,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,103),wf(:,9),G3(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),MT,G4tensor(:,72))
  call loop_QV_A(G1(:,:,:,54),wf(:,-6),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,76),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,3),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,124),MT,G3(:,:,:,106))
  call loop_QV_A(G3(:,:,:,106),wf(:,1),G3(:,:,:,107))
  call check_last_Q_A(l_switch,G3(:,:,:,107),Q(:,127),MT,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,106),wf(:,9),G3(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),MT,G4tensor(:,74))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,60),ZERO,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-6),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,124),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,1),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),ZERO,G4tensor(:,75))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,9),G3(:,:,:,111),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,127),ZERO,G4tensor(:,76))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-6),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,76),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,3),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,124),ZERO,G3(:,:,:,112))
  call loop_AV_Q(G3(:,:,:,112),wf(:,1),G3(:,:,:,113))
  call check_last_A_Q(l_switch,G3(:,:,:,113),Q(:,127),ZERO,G4tensor(:,77))
  call loop_AZ_Q(G3(:,:,:,112),wf(:,9),G3(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),ZERO,G4tensor(:,78))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,60))
  call loop_AV_Q(G1(:,:,:,60),wf(:,3),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,60),MB,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-6),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,124),MB,G3(:,:,:,115))
  call loop_AV_Q(G3(:,:,:,115),wf(:,1),G3(:,:,:,116))
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),MB,G4tensor(:,79))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,9),G3(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,117),Q(:,127),MB,G4tensor(:,80))
  call loop_AV_Q(G1(:,:,:,60),wf(:,-6),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,76),MB,G2(:,:,:,197))
  call loop_AV_Q(G2(:,:,:,197),wf(:,3),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,124),MB,G3(:,:,:,118))
  call loop_AV_Q(G3(:,:,:,118),wf(:,1),G3(:,:,:,119))
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,81))
  call loop_AZ_Q(G3(:,:,:,118),wf(:,9),G3(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,127),MB,G4tensor(:,82))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,12),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,3),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,60),ZERO,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,-6),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,124),ZERO,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,1),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,121),wf(:,9),G3(:,:,:,123),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,63),wf(:,-6),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,76),ZERO,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,3),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,124),ZERO,G3(:,:,:,124))
  call loop_QV_A(G3(:,:,:,124),wf(:,1),G3(:,:,:,125))
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,124),wf(:,9),G3(:,:,:,126),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,12),MB,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,60),MB,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,-6),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,124),MB,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,1),G3(:,:,:,128))
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),MB,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,127),wf(:,9),G3(:,:,:,129),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,129),Q(:,127),MB,G4tensor(:,88))
  call loop_QV_A(G1(:,:,:,66),wf(:,-6),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,76),MB,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,3),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,124),MB,G3(:,:,:,130))
  call loop_QV_A(G3(:,:,:,130),wf(:,1),G3(:,:,:,131))
  call check_last_Q_A(l_switch,G3(:,:,:,131),Q(:,127),MB,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,130),wf(:,9),G3(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,127),MB,G4tensor(:,90))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,20),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,27),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,22),T4sum(1:70,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,15),T4sum(1:70,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,29),T4sum(1:70,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,11),T4sum(1:70,3))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,18),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,25),T4sum(1:70,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,26),T4sum(1:70,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,21),T4sum(1:70,1))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,28),T4sum(1:70,1))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,23),T4sum(1:70,1))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,16),T4sum(1:70,3))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,30),T4sum(1:70,1))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,37),T4sum(1:70,5))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,47),T4sum(1:70,5))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,51),T4sum(1:70,6))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,41),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,55),T4sum(1:70,6))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,59),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,63),T4sum(1:70,5))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,67),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,71),T4sum(1:70,5))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,75),T4sum(1:70,4))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,79),T4sum(1:70,6))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,83),T4sum(1:70,4))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,87),T4sum(1:70,6))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,32),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,38),T4sum(1:70,5))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,42),T4sum(1:70,4))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,48),T4sum(1:70,5))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,52),T4sum(1:70,6))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,43),T4sum(1:70,4))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,56),T4sum(1:70,6))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,60),T4sum(1:70,4))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,64),T4sum(1:70,5))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,68),T4sum(1:70,4))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,72),T4sum(1:70,5))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,76),T4sum(1:70,4))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,80),T4sum(1:70,6))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,84),T4sum(1:70,4))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,88),T4sum(1:70,6))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,44),T4sum(1:70,7))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,49),T4sum(1:70,8))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,39),T4sum(1:70,8))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,44),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,57),T4sum(1:70,9))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(81)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,53),T4sum(1:70,9))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,69),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,73),T4sum(1:70,8))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,61),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(82)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,65),T4sum(1:70,8))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,85),T4sum(1:70,7))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,89),T4sum(1:70,9))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,77),T4sum(1:70,7))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(82)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,81),T4sum(1:70,9))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,45),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,50),T4sum(1:70,8))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,35),T4sum(1:70,7))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(83)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,40),T4sum(1:70,8))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,46),T4sum(1:70,7))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,58),T4sum(1:70,9))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,36),T4sum(1:70,7))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(83)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,54),T4sum(1:70,9))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,70),T4sum(1:70,7))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,74),T4sum(1:70,8))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,62),T4sum(1:70,7))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,66),T4sum(1:70,8))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,86),T4sum(1:70,7))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,90),T4sum(1:70,9))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,78),T4sum(1:70,7))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(84)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,82),T4sum(1:70,9))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,93),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(85)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,93),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(85)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,70),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,94),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,95),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,96),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,96),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,73),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,97),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,74),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,98),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(88)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,99),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(89)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,75),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(89)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,99),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(89)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,76),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,100),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,101),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(90)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(91)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,78),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,102),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(91)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,79),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,103),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,80),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,104),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(92)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,81),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,105),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,81),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,105),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,82),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,106),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,83),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,107),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(95)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,84),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(95)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(95)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,108),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(95)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(95)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,84),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(95)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,108),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(95)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,85),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,109),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,86),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,110),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(96)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(97)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,87),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(97)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(97)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,111),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(97)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(97)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,87),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(97)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,111),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(97)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(98)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(98)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,112),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(98)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,88),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(98)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(98)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,112),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(98)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,89),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,113),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,90),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,114),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(99)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,91),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,115),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,92),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,68),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,116),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(100)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,51),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_eexmmxuuxg_1_/**/REALKIND
