
module ol_vamp_1_ppllllj2_eexmmxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eexmmxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eexmmxggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eexmmxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eexmmxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,17) :: G0
  complex(REALKIND), dimension(4,5,4,96) :: G1
  complex(REALKIND), dimension(4,15,4,330) :: G2
  complex(REALKIND), dimension(4,35,4,356) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,116,128))
    allocate(G4tensorhel(70,162,128))
    allocate(G5tensorhel(126,132,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,64),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,86),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,87),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,88),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,89),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,1),wf(:,90),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,91),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,1),wf(:,92),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,93),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QV_A(G2(:,:,:,1),wf(:,94),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,1),wf(:,95),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,1),wf(:,96),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,1),wf(:,97),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_QV_A(G2(:,:,:,1),wf(:,98),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_QV_A(G2(:,:,:,1),wf(:,99),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,1),wf(:,100),G2(:,:,:,17),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,1),wf(:,101),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,60),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-6),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,124),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,127),MT,G4tensor(:,2))
  call loop_QZ_A(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,60),MT,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-6),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,124),MT,G3(:,:,:,4))
  call loop_QV_A(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_Q_A(l_switch,G3(:,:,:,5),Q(:,127),MT,G4tensor(:,3))
  call loop_QZ_A(G3(:,:,:,4),wf(:,9),G3(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),MT,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,64),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,23),wf(:,86),G2(:,:,:,25))
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,87),G2(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,23),wf(:,88),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,89),G2(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,23),wf(:,90),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,91),G2(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,23),wf(:,92),G2(:,:,:,31))
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,93),G2(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,23),wf(:,94),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,95),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,23),wf(:,96),G2(:,:,:,35))
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,97),G2(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,23),wf(:,98),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,23),wf(:,99),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),MT,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,100),G2(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),MT,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,101),G2(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,60),MT,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-6),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,124),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,9),G3(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),MT,G4tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,5),wf(:,6),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,60),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-6),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,124),MT,G3(:,:,:,10))
  call loop_AV_Q(G3(:,:,:,10),wf(:,1),G3(:,:,:,11))
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),MT,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,9),G3(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MB,G2(:,:,:,45))
  call loop_QS_A(G2(:,:,:,45),wf(:,64),G2(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,45),wf(:,86),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,45),wf(:,87),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,127),MB,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,45),wf(:,88),G2(:,:,:,49))
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,127),MB,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,45),wf(:,89),G2(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,127),MB,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,45),wf(:,90),G2(:,:,:,51))
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),MB,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,45),wf(:,91),G2(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),MB,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,45),wf(:,92),G2(:,:,:,53))
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,45),wf(:,93),G2(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),MB,G3tensor(:,43))
  call loop_QV_A(G2(:,:,:,45),wf(:,94),G2(:,:,:,55))
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,45),wf(:,95),G2(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,96),G2(:,:,:,57))
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,45),wf(:,97),G2(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,47))
  call loop_QV_A(G2(:,:,:,45),wf(:,98),G2(:,:,:,59))
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,45),wf(:,99),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,49))
  call loop_QZ_A(G2(:,:,:,45),wf(:,100),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,45),wf(:,101),G2(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,127),MB,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,60),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-6),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,124),MB,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,9),G3(:,:,:,15),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,127),MB,G4tensor(:,10))
  call loop_QZ_A(G1(:,:,:,9),wf(:,6),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MB,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-6),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,124),MB,G3(:,:,:,16))
  call loop_QV_A(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,127),MB,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,16),wf(:,9),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,67))
  call loop_AS_Q(G2(:,:,:,67),wf(:,64),G2(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),MB,G3tensor(:,52))
  call loop_AV_Q(G2(:,:,:,67),wf(:,86),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),MB,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,87),G2(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),MB,G3tensor(:,54))
  call loop_AV_Q(G2(:,:,:,67),wf(:,88),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),MB,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,89),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),MB,G3tensor(:,56))
  call loop_AV_Q(G2(:,:,:,67),wf(:,90),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),MB,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,91),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MB,G3tensor(:,58))
  call loop_AV_Q(G2(:,:,:,67),wf(:,92),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,93),G2(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,60))
  call loop_AV_Q(G2(:,:,:,67),wf(:,94),G2(:,:,:,77))
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,95),G2(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,62))
  call loop_AV_Q(G2(:,:,:,67),wf(:,96),G2(:,:,:,79))
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,97),G2(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,64))
  call loop_AV_Q(G2(:,:,:,67),wf(:,98),G2(:,:,:,81))
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,65))
  call loop_AV_Q(G2(:,:,:,67),wf(:,99),G2(:,:,:,82))
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),MB,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,100),G2(:,:,:,83),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,101),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,60),MB,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,124),MB,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,9),G3(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),MB,G4tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,6),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MB,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,124),MB,G3(:,:,:,22))
  call loop_AV_Q(G3(:,:,:,22),wf(:,1),G3(:,:,:,23))
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MB,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,9),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MB,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,60),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-6),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,124),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,9),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,9),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,6),G1(:,:,:,19),gZu)
  call loop_A_Q(G1(:,:,:,19),Q(:,60),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-6),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,124),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,9),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,6),G1(:,:,:,20),gZd)
  call loop_A_Q(G1(:,:,:,20),Q(:,60),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,124),ZERO,G3(:,:,:,32))
  call loop_AV_Q(G3(:,:,:,32),wf(:,1),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AZ_Q(G3(:,:,:,32),wf(:,9),G3(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,112),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,86),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,87),G2(:,:,:,97),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,97),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,87),G2(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,95),wf(:,88),G2(:,:,:,99))
  call check_last_A_Q(l_switch,G2(:,:,:,99),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,89),G2(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,73))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,89),G2(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,127),ZERO,G3tensor(:,74))
  call loop_AV_Q(G2(:,:,:,95),wf(:,90),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,91),G2(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,91),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,77))
  call loop_AV_Q(G2(:,:,:,95),wf(:,92),G2(:,:,:,105))
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,127),ZERO,G3tensor(:,78))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,93),G2(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,93),G2(:,:,:,107),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,127),ZERO,G3tensor(:,80))
  call loop_AV_Q(G2(:,:,:,95),wf(:,94),G2(:,:,:,108))
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,127),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,95),G2(:,:,:,109),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,127),ZERO,G3tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,95),G2(:,:,:,110),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,127),ZERO,G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,95),wf(:,96),G2(:,:,:,111))
  call check_last_A_Q(l_switch,G2(:,:,:,111),Q(:,127),ZERO,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,97),G2(:,:,:,112),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,127),ZERO,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,97),G2(:,:,:,113),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,113),Q(:,127),ZERO,G3tensor(:,86))
  call loop_AV_Q(G2(:,:,:,95),wf(:,98),G2(:,:,:,114))
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,127),ZERO,G3tensor(:,87))
  call loop_AV_Q(G2(:,:,:,95),wf(:,99),G2(:,:,:,115))
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,127),ZERO,G3tensor(:,88))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,100),G2(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,127),ZERO,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,100),G2(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,90))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,101),G2(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,127),ZERO,G3tensor(:,91))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,101),G2(:,:,:,119),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,127),ZERO,G3tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,2),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,60),ZERO,G2(:,:,:,120))
  call loop_QV_A(G2(:,:,:,120),wf(:,-6),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,124),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,24))
  call loop_QZ_A(G3(:,:,:,35),wf(:,9),G3(:,:,:,37),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,37),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,35),wf(:,9),G3(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QZ_A(G1(:,:,:,22),wf(:,6),G1(:,:,:,24),gZu)
  call loop_Q_A(G1(:,:,:,24),Q(:,60),ZERO,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,-6),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,124),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,1),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,39),wf(:,9),G3(:,:,:,41),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,28))
  call loop_QZ_A(G1(:,:,:,22),wf(:,6),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,60),ZERO,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,-6),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,124),ZERO,G3(:,:,:,42))
  call loop_QV_A(G3(:,:,:,42),wf(:,1),G3(:,:,:,43))
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,42),wf(:,9),G3(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G1(:,:,:,22),wf(:,-6),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),ZERO,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,86),G2(:,:,:,127))
  call check_last_Q_A(l_switch,G2(:,:,:,127),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,126),wf(:,87),G2(:,:,:,128),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,126),wf(:,87),G2(:,:,:,129),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QV_A(G2(:,:,:,126),wf(:,88),G2(:,:,:,130))
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QZ_A(G2(:,:,:,126),wf(:,89),G2(:,:,:,131),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,126),wf(:,89),G2(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QV_A(G2(:,:,:,126),wf(:,90),G2(:,:,:,133))
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,126),wf(:,91),G2(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,126),wf(:,91),G2(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,126),wf(:,92),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,102))
  call loop_QZ_A(G2(:,:,:,126),wf(:,93),G2(:,:,:,137),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,126),wf(:,93),G2(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,104))
  call loop_QV_A(G2(:,:,:,126),wf(:,94),G2(:,:,:,139))
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,105))
  call loop_QZ_A(G2(:,:,:,126),wf(:,95),G2(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,126),wf(:,95),G2(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,107))
  call loop_QV_A(G2(:,:,:,126),wf(:,96),G2(:,:,:,142))
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,126),wf(:,97),G2(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,126),wf(:,97),G2(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,110))
  call loop_QV_A(G2(:,:,:,126),wf(:,98),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,111))
  call loop_QV_A(G2(:,:,:,126),wf(:,99),G2(:,:,:,146))
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,112))
  call loop_QZ_A(G2(:,:,:,126),wf(:,100),G2(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,126),wf(:,100),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,114))
  call loop_QZ_A(G2(:,:,:,126),wf(:,101),G2(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,126),wf(:,101),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,116))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,3),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,60),ZERO,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-6),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,124),ZERO,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,1),G3(:,:,:,46))
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),ZERO,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,9),G3(:,:,:,47),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),ZERO,G4tensor(:,32))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,9),G3(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-6),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,76),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,3),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,124),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,1),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,51),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-4),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,92),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-5),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-5),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,108),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,124),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,7),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AV_Q(G1(:,:,:,27),wf(:,12),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,92),ZERO,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,-5),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,124),ZERO,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,1),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,9),G3(:,:,:,59),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,9),G3(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-5),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,44),ZERO,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,12),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,124),ZERO,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,1),G3(:,:,:,62))
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,40))
  call loop_AZ_Q(G3(:,:,:,61),wf(:,9),G3(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,61),wf(:,9),G3(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-4),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,60),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-6),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,124),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,9),G4(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,9),G4(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-6),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,108),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-4),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,124),ZERO,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,1),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,9),G4(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,9),G4(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,27),wf(:,17),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,108),ZERO,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-4),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,124),ZERO,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,1),G3(:,:,:,70))
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,9),G3(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,71),Q(:,127),ZERO,G4tensor(:,44))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,9),G3(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,28),ZERO,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,17),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,124),ZERO,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,1),G3(:,:,:,74))
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,9),G3(:,:,:,75),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,127),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,9),G3(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,48))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-5),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,60),ZERO,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,124),ZERO,G4(:,:,:,17))
  call loop_AV_Q(G4(:,:,:,17),wf(:,1),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),ZERO,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,9),G4(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,19),Q(:,127),ZERO,G5tensor(:,14))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,9),G4(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),ZERO,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-6),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,92),ZERO,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,124),ZERO,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),ZERO,G5tensor(:,16))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),ZERO,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),ZERO,G5tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,3),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,60),MT,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,124),MT,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,1),G3(:,:,:,82))
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,127),MT,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,81),wf(:,9),G3(:,:,:,83),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,83),Q(:,127),MT,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-6),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,76),MT,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,3),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,124),MT,G3(:,:,:,84))
  call loop_AV_Q(G3(:,:,:,84),wf(:,1),G3(:,:,:,85))
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,127),MT,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,84),wf(:,9),G3(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),MT,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-4),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,92),MT,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,-5),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,124),MT,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,19))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),MT,G5tensor(:,20))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,108),MT,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-4),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,124),MT,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),MT,G5tensor(:,21))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,34),wf(:,12),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,92),MT,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-5),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,124),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,1),G3(:,:,:,92))
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,9),G3(:,:,:,93),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,127),MT,G4tensor(:,54))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-5),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,44),MT,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,12),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,124),MT,G3(:,:,:,94))
  call loop_AV_Q(G3(:,:,:,94),wf(:,1),G3(:,:,:,95))
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,127),MT,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,94),wf(:,9),G3(:,:,:,96),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),MT,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-4),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,60),MT,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-6),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,124),MT,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),MT,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,9),G4(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),MT,G5tensor(:,24))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-6),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,108),MT,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,124),MT,G4(:,:,:,34))
  call loop_AV_Q(G4(:,:,:,34),wf(:,1),G4(:,:,:,35))
  call check_last_A_Q(l_switch,G4(:,:,:,35),Q(:,127),MT,G5tensor(:,25))
  call loop_AZ_Q(G4(:,:,:,34),wf(:,9),G4(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),MT,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,34),wf(:,17),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,108),MT,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-4),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,124),MT,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,1),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,127),MT,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,101),wf(:,9),G3(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,127),MT,G4tensor(:,58))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-4),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,28),MT,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,17),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,124),MT,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,1),G3(:,:,:,105))
  call check_last_A_Q(l_switch,G3(:,:,:,105),Q(:,127),MT,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,104),wf(:,9),G3(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,127),MT,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-5),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,60),MT,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-6),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,124),MT,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,1),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,27))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,9),G4(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,39),Q(:,127),MT,G5tensor(:,28))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-6),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,92),MT,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-5),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,124),MT,G4(:,:,:,40))
  call loop_AV_Q(G4(:,:,:,40),wf(:,1),G4(:,:,:,41))
  call check_last_A_Q(l_switch,G4(:,:,:,41),Q(:,127),MT,G5tensor(:,29))
  call loop_AZ_Q(G4(:,:,:,40),wf(:,9),G4(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,3),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,60),ZERO,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,-6),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,124),ZERO,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,1),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,127),ZERO,G4tensor(:,61))
  call loop_QZ_A(G3(:,:,:,111),wf(:,9),G3(:,:,:,113),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,113),Q(:,127),ZERO,G4tensor(:,62))
  call loop_QZ_A(G3(:,:,:,111),wf(:,9),G3(:,:,:,114),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,127),ZERO,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,41),wf(:,-6),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,76),ZERO,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,3),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,124),ZERO,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,1),G3(:,:,:,116))
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,127),ZERO,G4tensor(:,64))
  call loop_QZ_A(G3(:,:,:,115),wf(:,9),G3(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,117),Q(:,127),ZERO,G4tensor(:,65))
  call loop_QZ_A(G3(:,:,:,115),wf(:,9),G3(:,:,:,118),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,127),ZERO,G4tensor(:,66))
  call loop_QV_A(G2(:,:,:,189),wf(:,-4),G2(:,:,:,191))
  call loop_Q_A(G2(:,:,:,191),Q(:,92),ZERO,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-5),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,124),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,1),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),ZERO,G5tensor(:,31))
  call loop_QZ_A(G4(:,:,:,43),wf(:,9),G4(:,:,:,45),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),ZERO,G5tensor(:,32))
  call loop_QZ_A(G4(:,:,:,43),wf(:,9),G4(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,127),ZERO,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,189),wf(:,-5),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,108),ZERO,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,-4),G3(:,:,:,122))
  call loop_Q_A(G3(:,:,:,122),Q(:,124),ZERO,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,1),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),ZERO,G5tensor(:,34))
  call loop_QZ_A(G4(:,:,:,47),wf(:,9),G4(:,:,:,49),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,49),Q(:,127),ZERO,G5tensor(:,35))
  call loop_QZ_A(G4(:,:,:,47),wf(:,9),G4(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,36))
  call loop_QV_A(G1(:,:,:,41),wf(:,12),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,92),ZERO,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,-5),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,124),ZERO,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,1),G3(:,:,:,124))
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),ZERO,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,123),wf(:,9),G3(:,:,:,125),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,127),ZERO,G4tensor(:,68))
  call loop_QZ_A(G3(:,:,:,123),wf(:,9),G3(:,:,:,126),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,127),ZERO,G4tensor(:,69))
  call loop_QV_A(G1(:,:,:,41),wf(:,-5),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,44),ZERO,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,12),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,124),ZERO,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,1),G3(:,:,:,128))
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),ZERO,G4tensor(:,70))
  call loop_QZ_A(G3(:,:,:,127),wf(:,9),G3(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,129),Q(:,127),ZERO,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,127),wf(:,9),G3(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,72))
  call loop_QV_A(G2(:,:,:,195),wf(:,-4),G2(:,:,:,197))
  call loop_Q_A(G2(:,:,:,197),Q(:,60),ZERO,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-6),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,124),ZERO,G4(:,:,:,51))
  call loop_QV_A(G4(:,:,:,51),wf(:,1),G4(:,:,:,52))
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,37))
  call loop_QZ_A(G4(:,:,:,51),wf(:,9),G4(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,53),Q(:,127),ZERO,G5tensor(:,38))
  call loop_QZ_A(G4(:,:,:,51),wf(:,9),G4(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,195),wf(:,-6),G2(:,:,:,198))
  call loop_Q_A(G2(:,:,:,198),Q(:,108),ZERO,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,-4),G3(:,:,:,134))
  call loop_Q_A(G3(:,:,:,134),Q(:,124),ZERO,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,1),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),ZERO,G5tensor(:,40))
  call loop_QZ_A(G4(:,:,:,55),wf(:,9),G4(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,55),wf(:,9),G4(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QV_A(G1(:,:,:,41),wf(:,17),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,108),ZERO,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,-4),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,124),ZERO,G3(:,:,:,135))
  call loop_QV_A(G3(:,:,:,135),wf(:,1),G3(:,:,:,136))
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,127),ZERO,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,135),wf(:,9),G3(:,:,:,137),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,127),ZERO,G4tensor(:,74))
  call loop_QZ_A(G3(:,:,:,135),wf(:,9),G3(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,127),ZERO,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,41),wf(:,-4),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,28),ZERO,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,17),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,124),ZERO,G3(:,:,:,139))
  call loop_QV_A(G3(:,:,:,139),wf(:,1),G3(:,:,:,140))
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),ZERO,G4tensor(:,76))
  call loop_QZ_A(G3(:,:,:,139),wf(:,9),G3(:,:,:,141),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,127),ZERO,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,139),wf(:,9),G3(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),ZERO,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,201),wf(:,-5),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,60),ZERO,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-6),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,124),ZERO,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,1),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,59),wf(:,9),G4(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,61),Q(:,127),ZERO,G5tensor(:,44))
  call loop_QZ_A(G4(:,:,:,59),wf(:,9),G4(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),ZERO,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,201),wf(:,-6),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,92),ZERO,G3(:,:,:,145))
  call loop_QV_A(G3(:,:,:,145),wf(:,-5),G3(:,:,:,146))
  call loop_Q_A(G3(:,:,:,146),Q(:,124),ZERO,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,1),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,127),ZERO,G5tensor(:,46))
  call loop_QZ_A(G4(:,:,:,63),wf(:,9),G4(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,127),ZERO,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,63),wf(:,9),G4(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),ZERO,G5tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MT,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,3),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,60),MT,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-6),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,124),MT,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,1),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,127),MT,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,147),wf(:,9),G3(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),MT,G4tensor(:,80))
  call loop_QV_A(G1(:,:,:,48),wf(:,-6),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,76),MT,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,3),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,124),MT,G3(:,:,:,150))
  call loop_QV_A(G3(:,:,:,150),wf(:,1),G3(:,:,:,151))
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),MT,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,150),wf(:,9),G3(:,:,:,152),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MT,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,207),wf(:,-4),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,92),MT,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-5),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,124),MT,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,1),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),MT,G5tensor(:,49))
  call loop_QZ_A(G4(:,:,:,67),wf(:,9),G4(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,69),Q(:,127),MT,G5tensor(:,50))
  call loop_QV_A(G2(:,:,:,207),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,108),MT,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,-4),G3(:,:,:,156))
  call loop_Q_A(G3(:,:,:,156),Q(:,124),MT,G4(:,:,:,70))
  call loop_QV_A(G4(:,:,:,70),wf(:,1),G4(:,:,:,71))
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,127),MT,G5tensor(:,51))
  call loop_QZ_A(G4(:,:,:,70),wf(:,9),G4(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),MT,G5tensor(:,52))
  call loop_QV_A(G1(:,:,:,48),wf(:,12),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,92),MT,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-5),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,124),MT,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,1),G3(:,:,:,158))
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,127),MT,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,157),wf(:,9),G3(:,:,:,159),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,159),Q(:,127),MT,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,48),wf(:,-5),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,44),MT,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,12),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,124),MT,G3(:,:,:,160))
  call loop_QV_A(G3(:,:,:,160),wf(:,1),G3(:,:,:,161))
  call check_last_Q_A(l_switch,G3(:,:,:,161),Q(:,127),MT,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,160),wf(:,9),G3(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,127),MT,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,213),wf(:,-4),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,60),MT,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,-6),G3(:,:,:,164))
  call loop_Q_A(G3(:,:,:,164),Q(:,124),MT,G4(:,:,:,73))
  call loop_QV_A(G4(:,:,:,73),wf(:,1),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),MT,G5tensor(:,53))
  call loop_QZ_A(G4(:,:,:,73),wf(:,9),G4(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,75),Q(:,127),MT,G5tensor(:,54))
  call loop_QV_A(G2(:,:,:,213),wf(:,-6),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,108),MT,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-4),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,124),MT,G4(:,:,:,76))
  call loop_QV_A(G4(:,:,:,76),wf(:,1),G4(:,:,:,77))
  call check_last_Q_A(l_switch,G4(:,:,:,77),Q(:,127),MT,G5tensor(:,55))
  call loop_QZ_A(G4(:,:,:,76),wf(:,9),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),MT,G5tensor(:,56))
  call loop_QV_A(G1(:,:,:,48),wf(:,17),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,108),MT,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-4),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,124),MT,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,1),G3(:,:,:,168))
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,127),MT,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,167),wf(:,9),G3(:,:,:,169),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),MT,G4tensor(:,88))
  call loop_QV_A(G1(:,:,:,48),wf(:,-4),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,28),MT,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,17),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,124),MT,G3(:,:,:,170))
  call loop_QV_A(G3(:,:,:,170),wf(:,1),G3(:,:,:,171))
  call check_last_Q_A(l_switch,G3(:,:,:,171),Q(:,127),MT,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,170),wf(:,9),G3(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),MT,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,219),wf(:,-5),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,60),MT,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-6),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,124),MT,G4(:,:,:,79))
  call loop_QV_A(G4(:,:,:,79),wf(:,1),G4(:,:,:,80))
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),MT,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,79),wf(:,9),G4(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,81),Q(:,127),MT,G5tensor(:,58))
  call loop_QV_A(G2(:,:,:,219),wf(:,-6),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,92),MT,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-5),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,124),MT,G4(:,:,:,82))
  call loop_QV_A(G4(:,:,:,82),wf(:,1),G4(:,:,:,83))
  call check_last_Q_A(l_switch,G4(:,:,:,83),Q(:,127),MT,G5tensor(:,59))
  call loop_QZ_A(G4(:,:,:,82),wf(:,9),G4(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),MT,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,12),MB,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,3),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,60),MB,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-6),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,124),MB,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,1),G3(:,:,:,178))
  call check_last_A_Q(l_switch,G3(:,:,:,178),Q(:,127),MB,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,177),wf(:,9),G3(:,:,:,179),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,179),Q(:,127),MB,G4tensor(:,92))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-6),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,76),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,3),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,124),MB,G3(:,:,:,180))
  call loop_AV_Q(G3(:,:,:,180),wf(:,1),G3(:,:,:,181))
  call check_last_A_Q(l_switch,G3(:,:,:,181),Q(:,127),MB,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,180),wf(:,9),G3(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,182),Q(:,127),MB,G4tensor(:,94))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-4),G2(:,:,:,227))
  call loop_A_Q(G2(:,:,:,227),Q(:,92),MB,G3(:,:,:,183))
  call loop_AV_Q(G3(:,:,:,183),wf(:,-5),G3(:,:,:,184))
  call loop_A_Q(G3(:,:,:,184),Q(:,124),MB,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,1),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,127),MB,G5tensor(:,61))
  call loop_AZ_Q(G4(:,:,:,85),wf(:,9),G4(:,:,:,87),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,87),Q(:,127),MB,G5tensor(:,62))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-5),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,108),MB,G3(:,:,:,185))
  call loop_AV_Q(G3(:,:,:,185),wf(:,-4),G3(:,:,:,186))
  call loop_A_Q(G3(:,:,:,186),Q(:,124),MB,G4(:,:,:,88))
  call loop_AV_Q(G4(:,:,:,88),wf(:,1),G4(:,:,:,89))
  call check_last_A_Q(l_switch,G4(:,:,:,89),Q(:,127),MB,G5tensor(:,63))
  call loop_AZ_Q(G4(:,:,:,88),wf(:,9),G4(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,127),MB,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,55),wf(:,12),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,92),MB,G2(:,:,:,229))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-5),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,124),MB,G3(:,:,:,187))
  call loop_AV_Q(G3(:,:,:,187),wf(:,1),G3(:,:,:,188))
  call check_last_A_Q(l_switch,G3(:,:,:,188),Q(:,127),MB,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,187),wf(:,9),G3(:,:,:,189),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,189),Q(:,127),MB,G4tensor(:,96))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,44),MB,G2(:,:,:,231))
  call loop_AV_Q(G2(:,:,:,231),wf(:,12),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,124),MB,G3(:,:,:,190))
  call loop_AV_Q(G3(:,:,:,190),wf(:,1),G3(:,:,:,191))
  call check_last_A_Q(l_switch,G3(:,:,:,191),Q(:,127),MB,G4tensor(:,97))
  call loop_AZ_Q(G3(:,:,:,190),wf(:,9),G3(:,:,:,192),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,127),MB,G4tensor(:,98))
  call loop_AV_Q(G2(:,:,:,231),wf(:,-4),G2(:,:,:,233))
  call loop_A_Q(G2(:,:,:,233),Q(:,60),MB,G3(:,:,:,193))
  call loop_AV_Q(G3(:,:,:,193),wf(:,-6),G3(:,:,:,194))
  call loop_A_Q(G3(:,:,:,194),Q(:,124),MB,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,1),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,127),MB,G5tensor(:,65))
  call loop_AZ_Q(G4(:,:,:,91),wf(:,9),G4(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,93),Q(:,127),MB,G5tensor(:,66))
  call loop_AV_Q(G2(:,:,:,231),wf(:,-6),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,108),MB,G3(:,:,:,195))
  call loop_AV_Q(G3(:,:,:,195),wf(:,-4),G3(:,:,:,196))
  call loop_A_Q(G3(:,:,:,196),Q(:,124),MB,G4(:,:,:,94))
  call loop_AV_Q(G4(:,:,:,94),wf(:,1),G4(:,:,:,95))
  call check_last_A_Q(l_switch,G4(:,:,:,95),Q(:,127),MB,G5tensor(:,67))
  call loop_AZ_Q(G4(:,:,:,94),wf(:,9),G4(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,127),MB,G5tensor(:,68))
  call loop_AV_Q(G1(:,:,:,55),wf(:,17),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,108),MB,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-4),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,124),MB,G3(:,:,:,197))
  call loop_AV_Q(G3(:,:,:,197),wf(:,1),G3(:,:,:,198))
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),MB,G4tensor(:,99))
  call loop_AZ_Q(G3(:,:,:,197),wf(:,9),G3(:,:,:,199),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,199),Q(:,127),MB,G4tensor(:,100))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,28),MB,G2(:,:,:,237))
  call loop_AV_Q(G2(:,:,:,237),wf(:,17),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,124),MB,G3(:,:,:,200))
  call loop_AV_Q(G3(:,:,:,200),wf(:,1),G3(:,:,:,201))
  call check_last_A_Q(l_switch,G3(:,:,:,201),Q(:,127),MB,G4tensor(:,101))
  call loop_AZ_Q(G3(:,:,:,200),wf(:,9),G3(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,127),MB,G4tensor(:,102))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-5),G2(:,:,:,239))
  call loop_A_Q(G2(:,:,:,239),Q(:,60),MB,G3(:,:,:,203))
  call loop_AV_Q(G3(:,:,:,203),wf(:,-6),G3(:,:,:,204))
  call loop_A_Q(G3(:,:,:,204),Q(:,124),MB,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,1),G4(:,:,:,98))
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MB,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,9),G4(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,99),Q(:,127),MB,G5tensor(:,70))
  call loop_AV_Q(G2(:,:,:,237),wf(:,-6),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,92),MB,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,124),MB,G4(:,:,:,100))
  call loop_AV_Q(G4(:,:,:,100),wf(:,1),G4(:,:,:,101))
  call check_last_A_Q(l_switch,G4(:,:,:,101),Q(:,127),MB,G5tensor(:,71))
  call loop_AZ_Q(G4(:,:,:,100),wf(:,9),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MB,G5tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,3),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,60),MB,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-6),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,124),MB,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,1),G3(:,:,:,208))
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,127),MB,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,207),wf(:,9),G3(:,:,:,209),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,209),Q(:,127),MB,G4tensor(:,104))
  call loop_QV_A(G1(:,:,:,62),wf(:,-6),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,76),MB,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,3),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,124),MB,G3(:,:,:,210))
  call loop_QV_A(G3(:,:,:,210),wf(:,1),G3(:,:,:,211))
  call check_last_Q_A(l_switch,G3(:,:,:,211),Q(:,127),MB,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,210),wf(:,9),G3(:,:,:,212),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,127),MB,G4tensor(:,106))
  call loop_QV_A(G2(:,:,:,243),wf(:,-4),G2(:,:,:,245))
  call loop_Q_A(G2(:,:,:,245),Q(:,92),MB,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-5),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,124),MB,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,1),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,127),MB,G5tensor(:,73))
  call loop_QZ_A(G4(:,:,:,103),wf(:,9),G4(:,:,:,105),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,105),Q(:,127),MB,G5tensor(:,74))
  call loop_QV_A(G2(:,:,:,243),wf(:,-5),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,108),MB,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,124),MB,G4(:,:,:,106))
  call loop_QV_A(G4(:,:,:,106),wf(:,1),G4(:,:,:,107))
  call check_last_Q_A(l_switch,G4(:,:,:,107),Q(:,127),MB,G5tensor(:,75))
  call loop_QZ_A(G4(:,:,:,106),wf(:,9),G4(:,:,:,108),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,127),MB,G5tensor(:,76))
  call loop_QV_A(G1(:,:,:,62),wf(:,12),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,92),MB,G2(:,:,:,247))
  call loop_QV_A(G2(:,:,:,247),wf(:,-5),G2(:,:,:,248))
  call loop_Q_A(G2(:,:,:,248),Q(:,124),MB,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,1),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),MB,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,217),wf(:,9),G3(:,:,:,219),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,127),MB,G4tensor(:,108))
  call loop_QV_A(G1(:,:,:,62),wf(:,-5),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,44),MB,G2(:,:,:,249))
  call loop_QV_A(G2(:,:,:,249),wf(:,12),G2(:,:,:,250))
  call loop_Q_A(G2(:,:,:,250),Q(:,124),MB,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,1),G3(:,:,:,221))
  call check_last_Q_A(l_switch,G3(:,:,:,221),Q(:,127),MB,G4tensor(:,109))
  call loop_QZ_A(G3(:,:,:,220),wf(:,9),G3(:,:,:,222),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),MB,G4tensor(:,110))
  call loop_QV_A(G2(:,:,:,249),wf(:,-4),G2(:,:,:,251))
  call loop_Q_A(G2(:,:,:,251),Q(:,60),MB,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,-6),G3(:,:,:,224))
  call loop_Q_A(G3(:,:,:,224),Q(:,124),MB,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,1),G4(:,:,:,110))
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MB,G5tensor(:,77))
  call loop_QZ_A(G4(:,:,:,109),wf(:,9),G4(:,:,:,111),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,111),Q(:,127),MB,G5tensor(:,78))
  call loop_QV_A(G2(:,:,:,249),wf(:,-6),G2(:,:,:,252))
  call loop_Q_A(G2(:,:,:,252),Q(:,108),MB,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,-4),G3(:,:,:,226))
  call loop_Q_A(G3(:,:,:,226),Q(:,124),MB,G4(:,:,:,112))
  call loop_QV_A(G4(:,:,:,112),wf(:,1),G4(:,:,:,113))
  call check_last_Q_A(l_switch,G4(:,:,:,113),Q(:,127),MB,G5tensor(:,79))
  call loop_QZ_A(G4(:,:,:,112),wf(:,9),G4(:,:,:,114),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,127),MB,G5tensor(:,80))
  call loop_QV_A(G1(:,:,:,62),wf(:,17),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,108),MB,G2(:,:,:,253))
  call loop_QV_A(G2(:,:,:,253),wf(:,-4),G2(:,:,:,254))
  call loop_Q_A(G2(:,:,:,254),Q(:,124),MB,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,1),G3(:,:,:,228))
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,127),MB,G4tensor(:,111))
  call loop_QZ_A(G3(:,:,:,227),wf(:,9),G3(:,:,:,229),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,127),MB,G4tensor(:,112))
  call loop_QV_A(G1(:,:,:,62),wf(:,-4),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,28),MB,G2(:,:,:,255))
  call loop_QV_A(G2(:,:,:,255),wf(:,17),G2(:,:,:,256))
  call loop_Q_A(G2(:,:,:,256),Q(:,124),MB,G3(:,:,:,230))
  call loop_QV_A(G3(:,:,:,230),wf(:,1),G3(:,:,:,231))
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,127),MB,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,230),wf(:,9),G3(:,:,:,232),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,127),MB,G4tensor(:,114))
  call loop_QV_A(G2(:,:,:,255),wf(:,-5),G2(:,:,:,257))
  call loop_Q_A(G2(:,:,:,257),Q(:,60),MB,G3(:,:,:,233))
  call loop_QV_A(G3(:,:,:,233),wf(:,-6),G3(:,:,:,234))
  call loop_Q_A(G3(:,:,:,234),Q(:,124),MB,G4(:,:,:,115))
  call loop_QV_A(G4(:,:,:,115),wf(:,1),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),MB,G5tensor(:,81))
  call loop_QZ_A(G4(:,:,:,115),wf(:,9),G4(:,:,:,117),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,117),Q(:,127),MB,G5tensor(:,82))
  call loop_QV_A(G2(:,:,:,255),wf(:,-6),G2(:,:,:,258))
  call loop_Q_A(G2(:,:,:,258),Q(:,92),MB,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,-5),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,124),MB,G4(:,:,:,118))
  call loop_QV_A(G4(:,:,:,118),wf(:,1),G4(:,:,:,119))
  call check_last_Q_A(l_switch,G4(:,:,:,119),Q(:,127),MB,G5tensor(:,83))
  call loop_QZ_A(G4(:,:,:,118),wf(:,9),G4(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,127),MB,G5tensor(:,84))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,3),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,60),ZERO,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-6),G2(:,:,:,260))
  call loop_A_Q(G2(:,:,:,260),Q(:,124),ZERO,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,1),G3(:,:,:,238))
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),ZERO,G4tensor(:,115))
  call loop_AZ_Q(G3(:,:,:,237),wf(:,9),G3(:,:,:,239),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,239),Q(:,127),ZERO,G4tensor(:,116))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-6),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,76),ZERO,G2(:,:,:,261))
  call loop_AV_Q(G2(:,:,:,261),wf(:,3),G2(:,:,:,262))
  call loop_A_Q(G2(:,:,:,262),Q(:,124),ZERO,G3(:,:,:,240))
  call loop_AV_Q(G3(:,:,:,240),wf(:,1),G3(:,:,:,241))
  call check_last_A_Q(l_switch,G3(:,:,:,241),Q(:,127),ZERO,G4tensor(:,117))
  call loop_AZ_Q(G3(:,:,:,240),wf(:,9),G3(:,:,:,242),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,127),ZERO,G4tensor(:,118))
  call loop_AV_Q(G2(:,:,:,261),wf(:,-4),G2(:,:,:,263))
  call loop_A_Q(G2(:,:,:,263),Q(:,92),ZERO,G3(:,:,:,243))
  call loop_AV_Q(G3(:,:,:,243),wf(:,-5),G3(:,:,:,244))
  call loop_A_Q(G3(:,:,:,244),Q(:,124),ZERO,G4(:,:,:,121))
  call loop_AV_Q(G4(:,:,:,121),wf(:,1),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,85))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,9),G4(:,:,:,123),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,123),Q(:,127),ZERO,G5tensor(:,86))
  call loop_AV_Q(G2(:,:,:,261),wf(:,-5),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,108),ZERO,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-4),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,124),ZERO,G4(:,:,:,124))
  call loop_AV_Q(G4(:,:,:,124),wf(:,1),G4(:,:,:,125))
  call check_last_A_Q(l_switch,G4(:,:,:,125),Q(:,127),ZERO,G5tensor(:,87))
  call loop_AZ_Q(G4(:,:,:,124),wf(:,9),G4(:,:,:,126),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,88))
  call loop_AV_Q(G1(:,:,:,69),wf(:,12),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,92),ZERO,G2(:,:,:,265))
  call loop_AV_Q(G2(:,:,:,265),wf(:,-5),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,124),ZERO,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,1),G3(:,:,:,248))
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,127),ZERO,G4tensor(:,119))
  call loop_AZ_Q(G3(:,:,:,247),wf(:,9),G3(:,:,:,249),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,249),Q(:,127),ZERO,G4tensor(:,120))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,44),ZERO,G2(:,:,:,267))
  call loop_AV_Q(G2(:,:,:,267),wf(:,12),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,124),ZERO,G3(:,:,:,250))
  call loop_AV_Q(G3(:,:,:,250),wf(:,1),G3(:,:,:,251))
  call check_last_A_Q(l_switch,G3(:,:,:,251),Q(:,127),ZERO,G4tensor(:,121))
  call loop_AZ_Q(G3(:,:,:,250),wf(:,9),G3(:,:,:,252),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,127),ZERO,G4tensor(:,122))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-4),G2(:,:,:,269))
  call loop_A_Q(G2(:,:,:,269),Q(:,60),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,-6),G3(:,:,:,254))
  call loop_A_Q(G3(:,:,:,254),Q(:,124),ZERO,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,1),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,89))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,9),G4(:,:,:,129),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,129),Q(:,127),ZERO,G5tensor(:,90))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-6),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,108),ZERO,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-4),G3(:,:,:,256))
  call loop_A_Q(G3(:,:,:,256),Q(:,124),ZERO,G4(:,:,:,130))
  call loop_AV_Q(G4(:,:,:,130),wf(:,1),G4(:,:,:,131))
  call check_last_A_Q(l_switch,G4(:,:,:,131),Q(:,127),ZERO,G5tensor(:,91))
  call loop_AZ_Q(G4(:,:,:,130),wf(:,9),G4(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,92))
  call loop_AV_Q(G1(:,:,:,69),wf(:,17),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,108),ZERO,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-4),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,124),ZERO,G3(:,:,:,257))
  call loop_AV_Q(G3(:,:,:,257),wf(:,1),G3(:,:,:,258))
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,123))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,9),G3(:,:,:,259),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),ZERO,G4tensor(:,124))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-4),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,28),ZERO,G2(:,:,:,273))
  call loop_AV_Q(G2(:,:,:,273),wf(:,17),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,124),ZERO,G3(:,:,:,260))
  call loop_AV_Q(G3(:,:,:,260),wf(:,1),G3(:,:,:,261))
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),ZERO,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,260),wf(:,9),G3(:,:,:,262),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,126))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-5),G2(:,:,:,275))
  call loop_A_Q(G2(:,:,:,275),Q(:,60),ZERO,G3(:,:,:,263))
  call loop_AV_Q(G3(:,:,:,263),wf(:,-6),G3(:,:,:,264))
  call loop_A_Q(G3(:,:,:,264),Q(:,124),ZERO,G4(:,:,:,133))
  call loop_AV_Q(G4(:,:,:,133),wf(:,1),G4(:,:,:,134))
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,93))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,9),G4(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,135),Q(:,127),ZERO,G5tensor(:,94))
  call loop_AV_Q(G2(:,:,:,273),wf(:,-6),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,92),ZERO,G3(:,:,:,265))
  call loop_AV_Q(G3(:,:,:,265),wf(:,-5),G3(:,:,:,266))
  call loop_A_Q(G3(:,:,:,266),Q(:,124),ZERO,G4(:,:,:,136))
  call loop_AV_Q(G4(:,:,:,136),wf(:,1),G4(:,:,:,137))
  call check_last_A_Q(l_switch,G4(:,:,:,137),Q(:,127),ZERO,G5tensor(:,95))
  call loop_AZ_Q(G4(:,:,:,136),wf(:,9),G4(:,:,:,138),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,127),ZERO,G5tensor(:,96))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,3),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,60),MT,G2(:,:,:,277))
  call loop_AV_Q(G2(:,:,:,277),wf(:,-6),G2(:,:,:,278))
  call loop_A_Q(G2(:,:,:,278),Q(:,124),MT,G3(:,:,:,267))
  call loop_AV_Q(G3(:,:,:,267),wf(:,1),G3(:,:,:,268))
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,127),MT,G4tensor(:,127))
  call loop_AZ_Q(G3(:,:,:,267),wf(:,9),G3(:,:,:,269),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,269),Q(:,127),MT,G4tensor(:,128))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-6),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,76),MT,G2(:,:,:,279))
  call loop_AV_Q(G2(:,:,:,279),wf(:,3),G2(:,:,:,280))
  call loop_A_Q(G2(:,:,:,280),Q(:,124),MT,G3(:,:,:,270))
  call loop_AV_Q(G3(:,:,:,270),wf(:,1),G3(:,:,:,271))
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),MT,G4tensor(:,129))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,9),G3(:,:,:,272),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),MT,G4tensor(:,130))
  call loop_AV_Q(G2(:,:,:,279),wf(:,-4),G2(:,:,:,281))
  call loop_A_Q(G2(:,:,:,281),Q(:,92),MT,G3(:,:,:,273))
  call loop_AV_Q(G3(:,:,:,273),wf(:,-5),G3(:,:,:,274))
  call loop_A_Q(G3(:,:,:,274),Q(:,124),MT,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,1),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,127),MT,G5tensor(:,97))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,9),G4(:,:,:,141),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,141),Q(:,127),MT,G5tensor(:,98))
  call loop_AV_Q(G2(:,:,:,279),wf(:,-5),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,108),MT,G3(:,:,:,275))
  call loop_AV_Q(G3(:,:,:,275),wf(:,-4),G3(:,:,:,276))
  call loop_A_Q(G3(:,:,:,276),Q(:,124),MT,G4(:,:,:,142))
  call loop_AV_Q(G4(:,:,:,142),wf(:,1),G4(:,:,:,143))
  call check_last_A_Q(l_switch,G4(:,:,:,143),Q(:,127),MT,G5tensor(:,99))
  call loop_AZ_Q(G4(:,:,:,142),wf(:,9),G4(:,:,:,144),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),MT,G5tensor(:,100))
  call loop_AV_Q(G1(:,:,:,76),wf(:,12),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,92),MT,G2(:,:,:,283))
  call loop_AV_Q(G2(:,:,:,283),wf(:,-5),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,124),MT,G3(:,:,:,277))
  call loop_AV_Q(G3(:,:,:,277),wf(:,1),G3(:,:,:,278))
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,127),MT,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,277),wf(:,9),G3(:,:,:,279),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,279),Q(:,127),MT,G4tensor(:,132))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-5),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,44),MT,G2(:,:,:,285))
  call loop_AV_Q(G2(:,:,:,285),wf(:,12),G2(:,:,:,286))
  call loop_A_Q(G2(:,:,:,286),Q(:,124),MT,G3(:,:,:,280))
  call loop_AV_Q(G3(:,:,:,280),wf(:,1),G3(:,:,:,281))
  call check_last_A_Q(l_switch,G3(:,:,:,281),Q(:,127),MT,G4tensor(:,133))
  call loop_AZ_Q(G3(:,:,:,280),wf(:,9),G3(:,:,:,282),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,127),MT,G4tensor(:,134))
  call loop_AV_Q(G2(:,:,:,285),wf(:,-4),G2(:,:,:,287))
  call loop_A_Q(G2(:,:,:,287),Q(:,60),MT,G3(:,:,:,283))
  call loop_AV_Q(G3(:,:,:,283),wf(:,-6),G3(:,:,:,284))
  call loop_A_Q(G3(:,:,:,284),Q(:,124),MT,G4(:,:,:,145))
  call loop_AV_Q(G4(:,:,:,145),wf(:,1),G4(:,:,:,146))
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),MT,G5tensor(:,101))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,9),G4(:,:,:,147),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,147),Q(:,127),MT,G5tensor(:,102))
  call loop_AV_Q(G2(:,:,:,285),wf(:,-6),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,108),MT,G3(:,:,:,285))
  call loop_AV_Q(G3(:,:,:,285),wf(:,-4),G3(:,:,:,286))
  call loop_A_Q(G3(:,:,:,286),Q(:,124),MT,G4(:,:,:,148))
  call loop_AV_Q(G4(:,:,:,148),wf(:,1),G4(:,:,:,149))
  call check_last_A_Q(l_switch,G4(:,:,:,149),Q(:,127),MT,G5tensor(:,103))
  call loop_AZ_Q(G4(:,:,:,148),wf(:,9),G4(:,:,:,150),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,127),MT,G5tensor(:,104))
  call loop_AV_Q(G1(:,:,:,76),wf(:,17),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,108),MT,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,-4),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,124),MT,G3(:,:,:,287))
  call loop_AV_Q(G3(:,:,:,287),wf(:,1),G3(:,:,:,288))
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,127),MT,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,287),wf(:,9),G3(:,:,:,289),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,289),Q(:,127),MT,G4tensor(:,136))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-4),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,28),MT,G2(:,:,:,291))
  call loop_AV_Q(G2(:,:,:,291),wf(:,17),G2(:,:,:,292))
  call loop_A_Q(G2(:,:,:,292),Q(:,124),MT,G3(:,:,:,290))
  call loop_AV_Q(G3(:,:,:,290),wf(:,1),G3(:,:,:,291))
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),MT,G4tensor(:,137))
  call loop_AZ_Q(G3(:,:,:,290),wf(:,9),G3(:,:,:,292),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),MT,G4tensor(:,138))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-5),G2(:,:,:,293))
  call loop_A_Q(G2(:,:,:,293),Q(:,60),MT,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-6),G3(:,:,:,294))
  call loop_A_Q(G3(:,:,:,294),Q(:,124),MT,G4(:,:,:,151))
  call loop_AV_Q(G4(:,:,:,151),wf(:,1),G4(:,:,:,152))
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),MT,G5tensor(:,105))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,9),G4(:,:,:,153),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,153),Q(:,127),MT,G5tensor(:,106))
  call loop_AV_Q(G2(:,:,:,291),wf(:,-6),G2(:,:,:,294))
  call loop_A_Q(G2(:,:,:,294),Q(:,92),MT,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,-5),G3(:,:,:,296))
  call loop_A_Q(G3(:,:,:,296),Q(:,124),MT,G4(:,:,:,154))
  call loop_AV_Q(G4(:,:,:,154),wf(:,1),G4(:,:,:,155))
  call check_last_A_Q(l_switch,G4(:,:,:,155),Q(:,127),MT,G5tensor(:,107))
  call loop_AZ_Q(G4(:,:,:,154),wf(:,9),G4(:,:,:,156),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,127),MT,G5tensor(:,108))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,3),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,60),ZERO,G2(:,:,:,295))
  call loop_QV_A(G2(:,:,:,295),wf(:,-6),G2(:,:,:,296))
  call loop_Q_A(G2(:,:,:,296),Q(:,124),ZERO,G3(:,:,:,297))
  call loop_QV_A(G3(:,:,:,297),wf(:,1),G3(:,:,:,298))
  call check_last_Q_A(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,139))
  call loop_QZ_A(G3(:,:,:,297),wf(:,9),G3(:,:,:,299),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,299),Q(:,127),ZERO,G4tensor(:,140))
  call loop_QV_A(G1(:,:,:,83),wf(:,-6),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,76),ZERO,G2(:,:,:,297))
  call loop_QV_A(G2(:,:,:,297),wf(:,3),G2(:,:,:,298))
  call loop_Q_A(G2(:,:,:,298),Q(:,124),ZERO,G3(:,:,:,300))
  call loop_QV_A(G3(:,:,:,300),wf(:,1),G3(:,:,:,301))
  call check_last_Q_A(l_switch,G3(:,:,:,301),Q(:,127),ZERO,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,300),wf(:,9),G3(:,:,:,302),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,302),Q(:,127),ZERO,G4tensor(:,142))
  call loop_QV_A(G2(:,:,:,297),wf(:,-4),G2(:,:,:,299))
  call loop_Q_A(G2(:,:,:,299),Q(:,92),ZERO,G3(:,:,:,303))
  call loop_QV_A(G3(:,:,:,303),wf(:,-5),G3(:,:,:,304))
  call loop_Q_A(G3(:,:,:,304),Q(:,124),ZERO,G4(:,:,:,157))
  call loop_QV_A(G4(:,:,:,157),wf(:,1),G4(:,:,:,158))
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,127),ZERO,G5tensor(:,109))
  call loop_QZ_A(G4(:,:,:,157),wf(:,9),G4(:,:,:,159),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,159),Q(:,127),ZERO,G5tensor(:,110))
  call loop_QV_A(G2(:,:,:,297),wf(:,-5),G2(:,:,:,300))
  call loop_Q_A(G2(:,:,:,300),Q(:,108),ZERO,G3(:,:,:,305))
  call loop_QV_A(G3(:,:,:,305),wf(:,-4),G3(:,:,:,306))
  call loop_Q_A(G3(:,:,:,306),Q(:,124),ZERO,G4(:,:,:,160))
  call loop_QV_A(G4(:,:,:,160),wf(:,1),G4(:,:,:,161))
  call check_last_Q_A(l_switch,G4(:,:,:,161),Q(:,127),ZERO,G5tensor(:,111))
  call loop_QZ_A(G4(:,:,:,160),wf(:,9),G4(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,162),Q(:,127),ZERO,G5tensor(:,112))
  call loop_QV_A(G1(:,:,:,83),wf(:,12),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,92),ZERO,G2(:,:,:,301))
  call loop_QV_A(G2(:,:,:,301),wf(:,-5),G2(:,:,:,302))
  call loop_Q_A(G2(:,:,:,302),Q(:,124),ZERO,G3(:,:,:,307))
  call loop_QV_A(G3(:,:,:,307),wf(:,1),G3(:,:,:,308))
  call check_last_Q_A(l_switch,G3(:,:,:,308),Q(:,127),ZERO,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,307),wf(:,9),G3(:,:,:,309),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,309),Q(:,127),ZERO,G4tensor(:,144))
  call loop_QV_A(G1(:,:,:,83),wf(:,-5),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,44),ZERO,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,12),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,124),ZERO,G3(:,:,:,310))
  call loop_QV_A(G3(:,:,:,310),wf(:,1),G3(:,:,:,311))
  call check_last_Q_A(l_switch,G3(:,:,:,311),Q(:,127),ZERO,G4tensor(:,145))
  call loop_QZ_A(G3(:,:,:,310),wf(:,9),G3(:,:,:,312),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,312),Q(:,127),ZERO,G4tensor(:,146))
  call loop_QV_A(G2(:,:,:,303),wf(:,-4),G2(:,:,:,305))
  call loop_Q_A(G2(:,:,:,305),Q(:,60),ZERO,G3(:,:,:,313))
  call loop_QV_A(G3(:,:,:,313),wf(:,-6),G3(:,:,:,314))
  call loop_Q_A(G3(:,:,:,314),Q(:,124),ZERO,G4(:,:,:,163))
  call loop_QV_A(G4(:,:,:,163),wf(:,1),G4(:,:,:,164))
  call check_last_Q_A(l_switch,G4(:,:,:,164),Q(:,127),ZERO,G5tensor(:,113))
  call loop_QZ_A(G4(:,:,:,163),wf(:,9),G4(:,:,:,165),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,165),Q(:,127),ZERO,G5tensor(:,114))
  call loop_QV_A(G2(:,:,:,303),wf(:,-6),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,108),ZERO,G3(:,:,:,315))
  call loop_QV_A(G3(:,:,:,315),wf(:,-4),G3(:,:,:,316))
  call loop_Q_A(G3(:,:,:,316),Q(:,124),ZERO,G4(:,:,:,166))
  call loop_QV_A(G4(:,:,:,166),wf(:,1),G4(:,:,:,167))
  call check_last_Q_A(l_switch,G4(:,:,:,167),Q(:,127),ZERO,G5tensor(:,115))
  call loop_QZ_A(G4(:,:,:,166),wf(:,9),G4(:,:,:,168),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,168),Q(:,127),ZERO,G5tensor(:,116))
  call loop_QV_A(G1(:,:,:,83),wf(:,17),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,108),ZERO,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-4),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,124),ZERO,G3(:,:,:,317))
  call loop_QV_A(G3(:,:,:,317),wf(:,1),G3(:,:,:,318))
  call check_last_Q_A(l_switch,G3(:,:,:,318),Q(:,127),ZERO,G4tensor(:,147))
  call loop_QZ_A(G3(:,:,:,317),wf(:,9),G3(:,:,:,319),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,319),Q(:,127),ZERO,G4tensor(:,148))
  call loop_QV_A(G1(:,:,:,83),wf(:,-4),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,28),ZERO,G2(:,:,:,309))
  call loop_QV_A(G2(:,:,:,309),wf(:,17),G2(:,:,:,310))
  call loop_Q_A(G2(:,:,:,310),Q(:,124),ZERO,G3(:,:,:,320))
  call loop_QV_A(G3(:,:,:,320),wf(:,1),G3(:,:,:,321))
  call check_last_Q_A(l_switch,G3(:,:,:,321),Q(:,127),ZERO,G4tensor(:,149))
  call loop_QZ_A(G3(:,:,:,320),wf(:,9),G3(:,:,:,322),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,322),Q(:,127),ZERO,G4tensor(:,150))
  call loop_QV_A(G2(:,:,:,309),wf(:,-5),G2(:,:,:,311))
  call loop_Q_A(G2(:,:,:,311),Q(:,60),ZERO,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,-6),G3(:,:,:,324))
  call loop_Q_A(G3(:,:,:,324),Q(:,124),ZERO,G4(:,:,:,169))
  call loop_QV_A(G4(:,:,:,169),wf(:,1),G4(:,:,:,170))
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,127),ZERO,G5tensor(:,117))
  call loop_QZ_A(G4(:,:,:,169),wf(:,9),G4(:,:,:,171),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,171),Q(:,127),ZERO,G5tensor(:,118))
  call loop_QV_A(G2(:,:,:,309),wf(:,-6),G2(:,:,:,312))
  call loop_Q_A(G2(:,:,:,312),Q(:,92),ZERO,G3(:,:,:,325))
  call loop_QV_A(G3(:,:,:,325),wf(:,-5),G3(:,:,:,326))
  call loop_Q_A(G3(:,:,:,326),Q(:,124),ZERO,G4(:,:,:,172))
  call loop_QV_A(G4(:,:,:,172),wf(:,1),G4(:,:,:,173))
  call check_last_Q_A(l_switch,G4(:,:,:,173),Q(:,127),ZERO,G5tensor(:,119))
  call loop_QZ_A(G4(:,:,:,172),wf(:,9),G4(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,174),Q(:,127),ZERO,G5tensor(:,120))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MT,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,3),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,60),MT,G2(:,:,:,313))
  call loop_QV_A(G2(:,:,:,313),wf(:,-6),G2(:,:,:,314))
  call loop_Q_A(G2(:,:,:,314),Q(:,124),MT,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,1),G3(:,:,:,328))
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,127),MT,G4tensor(:,151))
  call loop_QZ_A(G3(:,:,:,327),wf(:,9),G3(:,:,:,329),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,329),Q(:,127),MT,G4tensor(:,152))
  call loop_QV_A(G1(:,:,:,90),wf(:,-6),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,76),MT,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,3),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,124),MT,G3(:,:,:,330))
  call loop_QV_A(G3(:,:,:,330),wf(:,1),G3(:,:,:,331))
  call check_last_Q_A(l_switch,G3(:,:,:,331),Q(:,127),MT,G4tensor(:,153))
  call loop_QZ_A(G3(:,:,:,330),wf(:,9),G3(:,:,:,332),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,127),MT,G4tensor(:,154))
  call loop_QV_A(G2(:,:,:,315),wf(:,-4),G2(:,:,:,317))
  call loop_Q_A(G2(:,:,:,317),Q(:,92),MT,G3(:,:,:,333))
  call loop_QV_A(G3(:,:,:,333),wf(:,-5),G3(:,:,:,334))
  call loop_Q_A(G3(:,:,:,334),Q(:,124),MT,G4(:,:,:,175))
  call loop_QV_A(G4(:,:,:,175),wf(:,1),G4(:,:,:,176))
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,127),MT,G5tensor(:,121))
  call loop_QZ_A(G4(:,:,:,175),wf(:,9),G4(:,:,:,177),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,177),Q(:,127),MT,G5tensor(:,122))
  call loop_QV_A(G2(:,:,:,315),wf(:,-5),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,108),MT,G3(:,:,:,335))
  call loop_QV_A(G3(:,:,:,335),wf(:,-4),G3(:,:,:,336))
  call loop_Q_A(G3(:,:,:,336),Q(:,124),MT,G4(:,:,:,178))
  call loop_QV_A(G4(:,:,:,178),wf(:,1),G4(:,:,:,179))
  call check_last_Q_A(l_switch,G4(:,:,:,179),Q(:,127),MT,G5tensor(:,123))
  call loop_QZ_A(G4(:,:,:,178),wf(:,9),G4(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,127),MT,G5tensor(:,124))
  call loop_QV_A(G1(:,:,:,90),wf(:,12),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,92),MT,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,124),MT,G3(:,:,:,337))
  call loop_QV_A(G3(:,:,:,337),wf(:,1),G3(:,:,:,338))
  call check_last_Q_A(l_switch,G3(:,:,:,338),Q(:,127),MT,G4tensor(:,155))
  call loop_QZ_A(G3(:,:,:,337),wf(:,9),G3(:,:,:,339),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,339),Q(:,127),MT,G4tensor(:,156))
  call loop_QV_A(G1(:,:,:,90),wf(:,-5),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,44),MT,G2(:,:,:,321))
  call loop_QV_A(G2(:,:,:,321),wf(:,12),G2(:,:,:,322))
  call loop_Q_A(G2(:,:,:,322),Q(:,124),MT,G3(:,:,:,340))
  call loop_QV_A(G3(:,:,:,340),wf(:,1),G3(:,:,:,341))
  call check_last_Q_A(l_switch,G3(:,:,:,341),Q(:,127),MT,G4tensor(:,157))
  call loop_QZ_A(G3(:,:,:,340),wf(:,9),G3(:,:,:,342),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,127),MT,G4tensor(:,158))
  call loop_QV_A(G2(:,:,:,321),wf(:,-4),G2(:,:,:,323))
  call loop_Q_A(G2(:,:,:,323),Q(:,60),MT,G3(:,:,:,343))
  call loop_QV_A(G3(:,:,:,343),wf(:,-6),G3(:,:,:,344))
  call loop_Q_A(G3(:,:,:,344),Q(:,124),MT,G4(:,:,:,181))
  call loop_QV_A(G4(:,:,:,181),wf(:,1),G4(:,:,:,182))
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,127),MT,G5tensor(:,125))
  call loop_QZ_A(G4(:,:,:,181),wf(:,9),G4(:,:,:,183),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,183),Q(:,127),MT,G5tensor(:,126))
  call loop_QV_A(G2(:,:,:,321),wf(:,-6),G2(:,:,:,324))
  call loop_Q_A(G2(:,:,:,324),Q(:,108),MT,G3(:,:,:,345))
  call loop_QV_A(G3(:,:,:,345),wf(:,-4),G3(:,:,:,346))
  call loop_Q_A(G3(:,:,:,346),Q(:,124),MT,G4(:,:,:,184))
  call loop_QV_A(G4(:,:,:,184),wf(:,1),G4(:,:,:,185))
  call check_last_Q_A(l_switch,G4(:,:,:,185),Q(:,127),MT,G5tensor(:,127))
  call loop_QZ_A(G4(:,:,:,184),wf(:,9),G4(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,186),Q(:,127),MT,G5tensor(:,128))
  call loop_QV_A(G1(:,:,:,90),wf(:,17),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,108),MT,G2(:,:,:,325))
  call loop_QV_A(G2(:,:,:,325),wf(:,-4),G2(:,:,:,326))
  call loop_Q_A(G2(:,:,:,326),Q(:,124),MT,G3(:,:,:,347))
  call loop_QV_A(G3(:,:,:,347),wf(:,1),G3(:,:,:,348))
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,127),MT,G4tensor(:,159))
  call loop_QZ_A(G3(:,:,:,347),wf(:,9),G3(:,:,:,349),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,349),Q(:,127),MT,G4tensor(:,160))
  call loop_QV_A(G1(:,:,:,90),wf(:,-4),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,28),MT,G2(:,:,:,327))
  call loop_QV_A(G2(:,:,:,327),wf(:,17),G2(:,:,:,328))
  call loop_Q_A(G2(:,:,:,328),Q(:,124),MT,G3(:,:,:,350))
  call loop_QV_A(G3(:,:,:,350),wf(:,1),G3(:,:,:,351))
  call check_last_Q_A(l_switch,G3(:,:,:,351),Q(:,127),MT,G4tensor(:,161))
  call loop_QZ_A(G3(:,:,:,350),wf(:,9),G3(:,:,:,352),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,352),Q(:,127),MT,G4tensor(:,162))
  call loop_QV_A(G2(:,:,:,327),wf(:,-5),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,60),MT,G3(:,:,:,353))
  call loop_QV_A(G3(:,:,:,353),wf(:,-6),G3(:,:,:,354))
  call loop_Q_A(G3(:,:,:,354),Q(:,124),MT,G4(:,:,:,187))
  call loop_QV_A(G4(:,:,:,187),wf(:,1),G4(:,:,:,188))
  call check_last_Q_A(l_switch,G4(:,:,:,188),Q(:,127),MT,G5tensor(:,129))
  call loop_QZ_A(G4(:,:,:,187),wf(:,9),G4(:,:,:,189),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,189),Q(:,127),MT,G5tensor(:,130))
  call loop_QV_A(G2(:,:,:,327),wf(:,-6),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,92),MT,G3(:,:,:,355))
  call loop_QV_A(G3(:,:,:,355),wf(:,-5),G3(:,:,:,356))
  call loop_Q_A(G3(:,:,:,356),Q(:,124),MT,G4(:,:,:,190))
  call loop_QV_A(G4(:,:,:,190),wf(:,1),G4(:,:,:,191))
  call check_last_Q_A(l_switch,G4(:,:,:,191),Q(:,127),MT,G5tensor(:,131))
  call loop_QZ_A(G4(:,:,:,190),wf(:,9),G4(:,:,:,192),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,127),MT,G5tensor(:,132))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(27)) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(27) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(27)) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(27) * den(56)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(25)) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(25) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,35),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(25)) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(25) * den(56)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,52),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,5),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,13),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,24),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,9),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,20),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,20),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,7),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,27),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,27),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,22),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,22),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,15),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,15),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(11) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,29),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,29),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(9) * den(111)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,11),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(9)) * den(111)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,11),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,18),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,18),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,6),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,25),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,25),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,19),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,14),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,26),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,26),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,10),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,21),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,21),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,8),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,28),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,28),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,23),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,23),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,16),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,16),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,30),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,30),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,49),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,49),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,79),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,79),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,91),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,91),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,103),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,103),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,115),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,115),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,127),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,127),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,139),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,139),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,151),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,151),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,32),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,32),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,50),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,50),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,62),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,62),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,80),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,80),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,33),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,92),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,92),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,63),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,63),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,104),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,104),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,116),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,116),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,128),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,128),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,140),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,140),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,152),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,152),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,81),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,81),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(12) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(12)) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(10) * den(110)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,51),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(10)) * den(110)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,51),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,105),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,105),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(8) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(8)) * den(110)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(7) * den(110)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,93),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(7)) * den(110)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,93),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,153),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,153),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(14)) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,117),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(14) * den(111)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,117),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(11)) * den(111)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,129),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(11) * den(111)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,129),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,65),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,65),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,82),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,82),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(14)) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,35),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(14) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,35),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,52),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(11) * den(112)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,52),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,66),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,66),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,106),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,106),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(11) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,36),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(112)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,36),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(9) * den(112)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,94),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(9)) * den(112)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,94),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,142),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,142),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,154),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,154),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(15) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,118),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(15)) * den(113)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,118),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(13) * den(113)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,130),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(13)) * den(113)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,130),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,37),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,37),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,53),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,53),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,67),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,67),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,83),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,83),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,37),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,37),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,95),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,95),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,67),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,67),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,107),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,107),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,119),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,119),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,131),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,131),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,143),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,143),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,155),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,155),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,38),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,54),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,54),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,68),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,68),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,84),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,84),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,39),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,39),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,96),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,96),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,69),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,69),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,108),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,108),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,132),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,132),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,144),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,144),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,156),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,156),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,70),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,70),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,85),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,85),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(12)) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,40),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(12) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,40),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(10)) * den(114)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,55),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(10) * den(114)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,55),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,70),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,70),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,109),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,109),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(8)) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,40),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(8) * den(114)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,40),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(7)) * den(114)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,97),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(7) * den(114)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,97),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,145),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,145),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,157),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,157),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(14) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,121),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(14)) * den(115)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,121),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(11) * den(115)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,133),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(11)) * den(115)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,133),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,71),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,71),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,86),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,86),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,41),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,41),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(11) * den(116)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,56),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,56),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,72),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,72),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,110),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,110),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(11)) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,42),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(116)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,42),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(9)) * den(116)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,98),T4sum(1:70,18))
  M(2) = M(2) + (CI*f(9) * den(116)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,98),T4sum(1:70,18))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,146),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,146),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,158),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,158),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(15)) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,122),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(15) * den(117)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,122),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(13)) * den(117)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,134),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(13) * den(117)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,134),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(12) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,43),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(12)) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,43),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(10) * den(118)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,57),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(10)) * den(118)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,57),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(12) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(12)) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(10) * den(118)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,87),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(10)) * den(118)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,87),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(8) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,43),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(8)) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,43),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(7) * den(118)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,99),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(7)) * den(118)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,99),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(8) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(8)) * den(118)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,73),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(7) * den(118)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,111),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(7)) * den(118)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,111),T4sum(1:70,24))
  M(1) = M(1) + (-(CI*f(14)) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,123),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(14) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,123),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,135),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(11) * den(119)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,135),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(14)) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,147),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(14) * den(119)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,147),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,159),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(11) * den(119)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,159),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(14)) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,44),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(14) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,44),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,58),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(11) * den(120)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,58),T4sum(1:70,23))
  M(1) = M(1) + (-(CI*f(14)) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,74),T4sum(1:70,22))
  M(2) = M(2) + (CI*f(14) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,74),T4sum(1:70,22))
  M(1) = M(1) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,88),T4sum(1:70,23))
  M(2) = M(2) + (CI*f(11) * den(120)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,88),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(11) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,45),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(9) * den(120)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,100),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(9)) * den(120)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,100),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(11) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,75),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,75),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(9) * den(120)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,112),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(9)) * den(120)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,112),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,124),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,124),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,136),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,136),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,148),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,148),T4sum(1:70,22))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,160),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,160),T4sum(1:70,23))
  M(1) = M(1) + (CI*f(12) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,76),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(12)) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,76),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(10) * den(118)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,89),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(10)) * den(118)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,89),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(12) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(12)) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(10) * den(118)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,59),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(10)) * den(118)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,59),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(8) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,76),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(8)) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,76),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(7) * den(118)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,113),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(7)) * den(118)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,113),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(8) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(8)) * den(118)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,46),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(7) * den(118)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,101),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(7)) * den(118)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,101),T4sum(1:70,27))
  M(1) = M(1) + (-(CI*f(14)) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,149),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(14) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,149),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,161),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(11) * den(119)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,161),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(14)) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,125),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(14) * den(119)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,125),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,137),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(11) * den(119)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,137),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(14)) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,77),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(14) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,77),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,90),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(11) * den(120)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,90),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(14)) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,47),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(14) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,47),T4sum(1:70,25))
  M(1) = M(1) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,60),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(11) * den(120)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,60),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(11) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,78),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,78),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(9) * den(120)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,114),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(9)) * den(120)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,114),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(11) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,48),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,48),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(9) * den(120)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,102),T4sum(1:70,27))
  M(2) = M(2) + (-(CI*f(9)) * den(120)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,102),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,150),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,150),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,162),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,162),T4sum(1:70,26))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,126),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,126),T4sum(1:70,25))
  M(1) = M(1) + (CI*f(13) * den(121)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,138),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(13)) * den(121)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,138),T4sum(1:70,26))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,19),T5sum(1:126,2))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,31),T5sum(1:126,1))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,49),T5sum(1:126,2))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,1),T5sum(1:126,1))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,61),T5sum(1:126,3))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,31),T5sum(1:126,1))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,73),T5sum(1:126,3))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,85),T5sum(1:126,1))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,97),T5sum(1:126,2))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,109),T5sum(1:126,1))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,121),T5sum(1:126,2))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,2),T5sum(1:126,1))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,20),T5sum(1:126,2))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,32),T5sum(1:126,1))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,50),T5sum(1:126,2))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,3),T5sum(1:126,1))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,62),T5sum(1:126,3))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,33),T5sum(1:126,1))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,74),T5sum(1:126,3))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,86),T5sum(1:126,1))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,98),T5sum(1:126,2))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_20,masses2_9,G5tensor(:,110),T5sum(1:126,1))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,122),T5sum(1:126,2))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,37),T5sum(1:126,4))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,53),T5sum(1:126,5))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,7),T5sum(1:126,4))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,23),T5sum(1:126,5))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,37),T5sum(1:126,4))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,77),T5sum(1:126,6))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,7),T5sum(1:126,4))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,65),T5sum(1:126,6))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,113),T5sum(1:126,4))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,125),T5sum(1:126,5))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,89),T5sum(1:126,4))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,101),T5sum(1:126,5))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,38),T5sum(1:126,4))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,54),T5sum(1:126,5))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,8),T5sum(1:126,4))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,24),T5sum(1:126,5))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,39),T5sum(1:126,4))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,78),T5sum(1:126,6))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,9),T5sum(1:126,4))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,66),T5sum(1:126,6))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,114),T5sum(1:126,4))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,126),T5sum(1:126,5))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_18,masses2_9,G5tensor(:,90),T5sum(1:126,4))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,102),T5sum(1:126,5))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,34),T5sum(1:126,7))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,51),T5sum(1:126,8))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,4),T5sum(1:126,7))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,21),T5sum(1:126,8))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,34),T5sum(1:126,7))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,75),T5sum(1:126,9))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,4),T5sum(1:126,7))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,63),T5sum(1:126,9))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,111),T5sum(1:126,7))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,123),T5sum(1:126,8))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,87),T5sum(1:126,7))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,99),T5sum(1:126,8))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,35),T5sum(1:126,7))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,52),T5sum(1:126,8))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,5),T5sum(1:126,7))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,22),T5sum(1:126,8))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,36),T5sum(1:126,7))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,76),T5sum(1:126,9))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,6),T5sum(1:126,7))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,64),T5sum(1:126,9))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,112),T5sum(1:126,7))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,124),T5sum(1:126,8))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_21,masses2_9,G5tensor(:,88),T5sum(1:126,7))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,100),T5sum(1:126,8))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,13),T5sum(1:126,13))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,27),T5sum(1:126,14))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,43),T5sum(1:126,13))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,57),T5sum(1:126,14))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,13),T5sum(1:126,13))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,69),T5sum(1:126,15))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,43),T5sum(1:126,13))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,81),T5sum(1:126,15))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,93),T5sum(1:126,13))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,105),T5sum(1:126,14))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,117),T5sum(1:126,13))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,129),T5sum(1:126,14))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,14),T5sum(1:126,13))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,28),T5sum(1:126,14))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,44),T5sum(1:126,13))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,58),T5sum(1:126,14))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,15),T5sum(1:126,13))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,70),T5sum(1:126,15))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,45),T5sum(1:126,13))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,82),T5sum(1:126,15))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,94),T5sum(1:126,13))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,106),T5sum(1:126,14))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_16,masses2_9,G5tensor(:,118),T5sum(1:126,13))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,130),T5sum(1:126,14))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,40),T5sum(1:126,19))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,55),T5sum(1:126,20))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,10),T5sum(1:126,19))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,25),T5sum(1:126,20))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,40),T5sum(1:126,19))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,79),T5sum(1:126,21))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,10),T5sum(1:126,19))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,67),T5sum(1:126,21))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,115),T5sum(1:126,19))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,127),T5sum(1:126,20))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,91),T5sum(1:126,19))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,103),T5sum(1:126,20))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,41),T5sum(1:126,19))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,56),T5sum(1:126,20))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,11),T5sum(1:126,19))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,26),T5sum(1:126,20))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,42),T5sum(1:126,19))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,80),T5sum(1:126,21))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,12),T5sum(1:126,19))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,68),T5sum(1:126,21))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,116),T5sum(1:126,19))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,128),T5sum(1:126,20))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_19,masses2_9,G5tensor(:,92),T5sum(1:126,19))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,104),T5sum(1:126,20))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,16),T5sum(1:126,25))
  M(2) = M(2) + (-f(19) * den(4)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,29),T5sum(1:126,26))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,46),T5sum(1:126,25))
  M(1) = M(1) + (-f(19) * den(4)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,59),T5sum(1:126,26))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,16),T5sum(1:126,25))
  M(2) = M(2) + (-f(16) * den(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,71),T5sum(1:126,27))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,46),T5sum(1:126,25))
  M(1) = M(1) + (-f(16) * den(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,83),T5sum(1:126,27))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,95),T5sum(1:126,25))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,107),T5sum(1:126,26))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,119),T5sum(1:126,25))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,131),T5sum(1:126,26))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,17),T5sum(1:126,25))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,30),T5sum(1:126,26))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,47),T5sum(1:126,25))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,60),T5sum(1:126,26))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,18),T5sum(1:126,25))
  M(2) = M(2) + (-f(18) * den(10)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,72),T5sum(1:126,27))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,48),T5sum(1:126,25))
  M(1) = M(1) + (-f(18) * den(10)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,84),T5sum(1:126,27))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,96),T5sum(1:126,25))
  M(2) = M(2) + (-f(22) * den(12)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,108),T5sum(1:126,26))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_17,masses2_9,G5tensor(:,120),T5sum(1:126,25))
  M(1) = M(1) + (-f(22) * den(12)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,132),T5sum(1:126,26))
  M(1) = M(1) + (-(CI*f(14)) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(122)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(122)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(122)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(122)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,69),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(122)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(122)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,53),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(122)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,93),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(122)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(122)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,36),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,70),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(123)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(123)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,94),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(123)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(123)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,71),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(123)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(123)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,54),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,95),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(123)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,95),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(123)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(123)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,37),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(124)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(124)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(124)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(124)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,72),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(124)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(124)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,55),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(124)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,96),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(124)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(124)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,38),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,73),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,97),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,74),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,56),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,98),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,98),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,39),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(126)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(126)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(126)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(126)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,75),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(126)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(126)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,57),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(126)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,99),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(126)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(126)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,40),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,76),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,100),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,100),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,77),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,58),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,101),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,101),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,41),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(128)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(128)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(128)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(128)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,78),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(128)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(128)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,59),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(128)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,102),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(128)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(128)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,42),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,79),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,103),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(129)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,80),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,80),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,60),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,104),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(129)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,104),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(129)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,43),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(146)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,81),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,61),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(146)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,105),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(146)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,44),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,82),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,82),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(147)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(147)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,106),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,106),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(147)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(147)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,83),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,83),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(147)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(147)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,62),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,107),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(147)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,107),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(147)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(147)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,45),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(148)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(148)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(148)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(148)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,84),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(148)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(148)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,63),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(148)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,108),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(148)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(148)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,46),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,85),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(149)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(149)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,109),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,109),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(149)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(149)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,86),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(149)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(149)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,64),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,110),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(149)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,110),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(149)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(149)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,47),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(150)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(150)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,111),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,111),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(150)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(150)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,87),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(150)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(150)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,65),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,111),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(150)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,111),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(150)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(150)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,48),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(14)) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(151)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(151)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(14)) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,112),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(14) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,112),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(11)) * den(151)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(11) * den(151)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(11) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,88),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(151)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(151)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,66),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(11) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,112),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(11)) * den(151)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,112),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(9) * den(151)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(9)) * den(151)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,49),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,89),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(152)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(152)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,113),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,113),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(152)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(152)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,90),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(152)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(152)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,67),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,114),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(152)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,114),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(152)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(152)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,50),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,91),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,115),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,115),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(153)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(15) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,92),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,92),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,68),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,68),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(15) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,116),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(15)) * den(153)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,116),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(13) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,51),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(13)) * den(153)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,51),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_eexmmxggg_1_/**/REALKIND
