
module ol_vamp_1_ppllllj2_eeexexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eeexexuuxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eeexexuuxg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eeexexuuxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eeexexuuxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,35) :: G0
  complex(REALKIND), dimension(4,5,4,124) :: G1
  complex(REALKIND), dimension(4,15,4,406) :: G2
  complex(REALKIND), dimension(4,35,4,264) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,232,128))
    allocate(G4tensorhel(70,180,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,48),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,22),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,127),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,128),G2(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,129),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,130),G2(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,1),wf(:,131),G2(:,:,:,7))
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,1),wf(:,132),G2(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,1),wf(:,133),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,1),wf(:,134),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_QS_A(G2(:,:,:,1),wf(:,64),G2(:,:,:,11),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,1),wf(:,135),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,1),wf(:,136),G2(:,:,:,13),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_QV_A(G2(:,:,:,1),wf(:,137),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,1),wf(:,138),G2(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_QV_A(G2(:,:,:,1),wf(:,139),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,1),wf(:,140),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,1),wf(:,141),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,1),wf(:,142),G2(:,:,:,19),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,18))
  call loop_QV_A(G2(:,:,:,1),wf(:,143),G2(:,:,:,20))
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,1),wf(:,144),G2(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,21),Q(:,127),MT,G3tensor(:,20))
  call loop_QV_A(G2(:,:,:,1),wf(:,145),G2(:,:,:,22))
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,127),MT,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,1),wf(:,146),G2(:,:,:,23),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,1),wf(:,147),G2(:,:,:,24))
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,1),wf(:,148),G2(:,:,:,25),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,1),wf(:,149),G2(:,:,:,26))
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,1),wf(:,150),G2(:,:,:,27),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,26))
  call loop_QV_A(G2(:,:,:,1),wf(:,151),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,1),wf(:,152),G2(:,:,:,29),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,28))
  call loop_QV_A(G2(:,:,:,1),wf(:,153),G2(:,:,:,30))
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,1),wf(:,154),G2(:,:,:,31),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,1),wf(:,155),G2(:,:,:,32))
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,31))
  call loop_QV_A(G2(:,:,:,1),wf(:,156),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,1),wf(:,157),G2(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,1),wf(:,158),G2(:,:,:,35),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,34))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,58),MT,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,-6),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,122),MT,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,127),MT,G4tensor(:,2))
  call loop_QZ_A(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZu)
  call loop_Q_A(G1(:,:,:,4),Q(:,58),MT,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,-6),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,122),MT,G3(:,:,:,4))
  call loop_QV_A(G3(:,:,:,4),wf(:,1),G3(:,:,:,5))
  call check_last_Q_A(l_switch,G3(:,:,:,5),Q(:,127),MT,G4tensor(:,3))
  call loop_QZ_A(G3(:,:,:,4),wf(:,9),G3(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,127),MT,G4tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,12),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,57),MT,G2(:,:,:,40))
  call loop_QV_A(G2(:,:,:,40),wf(:,-6),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,121),MT,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,13),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,5))
  call loop_QZ_A(G3(:,:,:,7),wf(:,16),G3(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,9),Q(:,127),MT,G4tensor(:,6))
  call loop_QZ_A(G1(:,:,:,1),wf(:,19),G1(:,:,:,6),gZu)
  call loop_Q_A(G1(:,:,:,6),Q(:,57),MT,G2(:,:,:,42))
  call loop_QV_A(G2(:,:,:,42),wf(:,-6),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,121),MT,G3(:,:,:,10))
  call loop_QV_A(G3(:,:,:,10),wf(:,13),G3(:,:,:,11))
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,127),MT,G4tensor(:,7))
  call loop_QZ_A(G3(:,:,:,10),wf(:,16),G3(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,127),MT,G4tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,48),MT,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-6),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,112),MT,G2(:,:,:,44))
  call loop_AS_Q(G2(:,:,:,44),wf(:,22),G2(:,:,:,45),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,127),MT,G3tensor(:,35))
  call loop_AV_Q(G2(:,:,:,44),wf(:,127),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,127),MT,G3tensor(:,36))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,128),G2(:,:,:,47),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),MT,G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,44),wf(:,129),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,127),MT,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,130),G2(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,127),MT,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,44),wf(:,131),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,127),MT,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,132),G2(:,:,:,51),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,127),MT,G3tensor(:,41))
  call loop_AV_Q(G2(:,:,:,44),wf(:,133),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,127),MT,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,134),G2(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,127),MT,G3tensor(:,43))
  call loop_AS_Q(G2(:,:,:,44),wf(:,64),G2(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,127),MT,G3tensor(:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,135),G2(:,:,:,55))
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,127),MT,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,136),G2(:,:,:,56),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),MT,G3tensor(:,46))
  call loop_AV_Q(G2(:,:,:,44),wf(:,137),G2(:,:,:,57))
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,127),MT,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,138),G2(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,127),MT,G3tensor(:,48))
  call loop_AV_Q(G2(:,:,:,44),wf(:,139),G2(:,:,:,59))
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,127),MT,G3tensor(:,49))
  call loop_AV_Q(G2(:,:,:,44),wf(:,140),G2(:,:,:,60))
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,127),MT,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,141),G2(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,127),MT,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,142),G2(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),MT,G3tensor(:,52))
  call loop_AV_Q(G2(:,:,:,44),wf(:,143),G2(:,:,:,63))
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),MT,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,144),G2(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),MT,G3tensor(:,54))
  call loop_AV_Q(G2(:,:,:,44),wf(:,145),G2(:,:,:,65))
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),MT,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,146),G2(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),MT,G3tensor(:,56))
  call loop_AV_Q(G2(:,:,:,44),wf(:,147),G2(:,:,:,67))
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),MT,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,148),G2(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),MT,G3tensor(:,58))
  call loop_AV_Q(G2(:,:,:,44),wf(:,149),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),MT,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,150),G2(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),MT,G3tensor(:,60))
  call loop_AV_Q(G2(:,:,:,44),wf(:,151),G2(:,:,:,71))
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),MT,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,152),G2(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),MT,G3tensor(:,62))
  call loop_AV_Q(G2(:,:,:,44),wf(:,153),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),MT,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,154),G2(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MT,G3tensor(:,64))
  call loop_AV_Q(G2(:,:,:,44),wf(:,155),G2(:,:,:,75))
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MT,G3tensor(:,65))
  call loop_AV_Q(G2(:,:,:,44),wf(:,156),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MT,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,157),G2(:,:,:,77),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MT,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,158),G2(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MT,G3tensor(:,68))
  call loop_AV_Q(G1(:,:,:,7),wf(:,2),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,58),MT,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-6),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,122),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MT,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,9),G3(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,127),MT,G4tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,6),G1(:,:,:,10),gZu)
  call loop_A_Q(G1(:,:,:,10),Q(:,58),MT,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-6),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,122),MT,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),MT,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,16),wf(:,9),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),MT,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,7),wf(:,12),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,57),MT,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-6),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,121),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,13),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MT,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,16),G3(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),MT,G4tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,19),G1(:,:,:,12),gZu)
  call loop_A_Q(G1(:,:,:,12),Q(:,57),MT,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,121),MT,G3(:,:,:,22))
  call loop_AV_Q(G3(:,:,:,22),wf(:,13),G3(:,:,:,23))
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MT,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,16),G3(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MT,G4tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,48),MB,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-6),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,87))
  call loop_QS_A(G2(:,:,:,87),wf(:,22),G2(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,127),MB,G3tensor(:,69))
  call loop_QV_A(G2(:,:,:,87),wf(:,127),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,127),MB,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,87),wf(:,128),G2(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,127),MB,G3tensor(:,71))
  call loop_QV_A(G2(:,:,:,87),wf(:,129),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),MB,G3tensor(:,72))
  call loop_QZ_A(G2(:,:,:,87),wf(:,130),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),MB,G3tensor(:,73))
  call loop_QV_A(G2(:,:,:,87),wf(:,131),G2(:,:,:,93))
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,127),MB,G3tensor(:,74))
  call loop_QZ_A(G2(:,:,:,87),wf(:,132),G2(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,127),MB,G3tensor(:,75))
  call loop_QV_A(G2(:,:,:,87),wf(:,133),G2(:,:,:,95))
  call check_last_Q_A(l_switch,G2(:,:,:,95),Q(:,127),MB,G3tensor(:,76))
  call loop_QZ_A(G2(:,:,:,87),wf(:,134),G2(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,127),MB,G3tensor(:,77))
  call loop_QS_A(G2(:,:,:,87),wf(:,64),G2(:,:,:,97),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,127),MB,G3tensor(:,78))
  call loop_QV_A(G2(:,:,:,87),wf(:,135),G2(:,:,:,98))
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,127),MB,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,87),wf(:,136),G2(:,:,:,99),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,127),MB,G3tensor(:,80))
  call loop_QV_A(G2(:,:,:,87),wf(:,137),G2(:,:,:,100))
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,127),MB,G3tensor(:,81))
  call loop_QZ_A(G2(:,:,:,87),wf(:,138),G2(:,:,:,101),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,127),MB,G3tensor(:,82))
  call loop_QV_A(G2(:,:,:,87),wf(:,139),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,127),MB,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,87),wf(:,140),G2(:,:,:,103))
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,127),MB,G3tensor(:,84))
  call loop_QZ_A(G2(:,:,:,87),wf(:,141),G2(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,127),MB,G3tensor(:,85))
  call loop_QZ_A(G2(:,:,:,87),wf(:,142),G2(:,:,:,105),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,127),MB,G3tensor(:,86))
  call loop_QV_A(G2(:,:,:,87),wf(:,143),G2(:,:,:,106))
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,127),MB,G3tensor(:,87))
  call loop_QZ_A(G2(:,:,:,87),wf(:,144),G2(:,:,:,107),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,127),MB,G3tensor(:,88))
  call loop_QV_A(G2(:,:,:,87),wf(:,145),G2(:,:,:,108))
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,127),MB,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,87),wf(:,146),G2(:,:,:,109),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,109),Q(:,127),MB,G3tensor(:,90))
  call loop_QV_A(G2(:,:,:,87),wf(:,147),G2(:,:,:,110))
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,127),MB,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,87),wf(:,148),G2(:,:,:,111),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,111),Q(:,127),MB,G3tensor(:,92))
  call loop_QV_A(G2(:,:,:,87),wf(:,149),G2(:,:,:,112))
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,127),MB,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,87),wf(:,150),G2(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,127),MB,G3tensor(:,94))
  call loop_QV_A(G2(:,:,:,87),wf(:,151),G2(:,:,:,114))
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,127),MB,G3tensor(:,95))
  call loop_QZ_A(G2(:,:,:,87),wf(:,152),G2(:,:,:,115),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,127),MB,G3tensor(:,96))
  call loop_QV_A(G2(:,:,:,87),wf(:,153),G2(:,:,:,116))
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,127),MB,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,87),wf(:,154),G2(:,:,:,117),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,127),MB,G3tensor(:,98))
  call loop_QV_A(G2(:,:,:,87),wf(:,155),G2(:,:,:,118))
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,127),MB,G3tensor(:,99))
  call loop_QV_A(G2(:,:,:,87),wf(:,156),G2(:,:,:,119))
  call check_last_Q_A(l_switch,G2(:,:,:,119),Q(:,127),MB,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,87),wf(:,157),G2(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,127),MB,G3tensor(:,101))
  call loop_QZ_A(G2(:,:,:,87),wf(:,158),G2(:,:,:,121),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,121),Q(:,127),MB,G3tensor(:,102))
  call loop_QV_A(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,58),MB,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,-6),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,122),MB,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),MB,G4tensor(:,17))
  call loop_QZ_A(G3(:,:,:,25),wf(:,9),G3(:,:,:,27),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,127),MB,G4tensor(:,18))
  call loop_QZ_A(G1(:,:,:,13),wf(:,6),G1(:,:,:,16),gZd)
  call loop_Q_A(G1(:,:,:,16),Q(:,58),MB,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,-6),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,122),MB,G3(:,:,:,28))
  call loop_QV_A(G3(:,:,:,28),wf(:,1),G3(:,:,:,29))
  call check_last_Q_A(l_switch,G3(:,:,:,29),Q(:,127),MB,G4tensor(:,19))
  call loop_QZ_A(G3(:,:,:,28),wf(:,9),G3(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,127),MB,G4tensor(:,20))
  call loop_QV_A(G1(:,:,:,13),wf(:,12),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,57),MB,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,-6),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,121),MB,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,13),G3(:,:,:,32))
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,127),MB,G4tensor(:,21))
  call loop_QZ_A(G3(:,:,:,31),wf(:,16),G3(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,127),MB,G4tensor(:,22))
  call loop_QZ_A(G1(:,:,:,13),wf(:,19),G1(:,:,:,18),gZd)
  call loop_Q_A(G1(:,:,:,18),Q(:,57),MB,G2(:,:,:,128))
  call loop_QV_A(G2(:,:,:,128),wf(:,-6),G2(:,:,:,129))
  call loop_Q_A(G2(:,:,:,129),Q(:,121),MB,G3(:,:,:,34))
  call loop_QV_A(G3(:,:,:,34),wf(:,13),G3(:,:,:,35))
  call check_last_Q_A(l_switch,G3(:,:,:,35),Q(:,127),MB,G4tensor(:,23))
  call loop_QZ_A(G3(:,:,:,34),wf(:,16),G3(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,127),MB,G4tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,48),MB,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-6),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,112),MB,G2(:,:,:,130))
  call loop_AS_Q(G2(:,:,:,130),wf(:,22),G2(:,:,:,131),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,127),MB,G3tensor(:,103))
  call loop_AV_Q(G2(:,:,:,130),wf(:,127),G2(:,:,:,132))
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,127),MB,G3tensor(:,104))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,128),G2(:,:,:,133),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,127),MB,G3tensor(:,105))
  call loop_AV_Q(G2(:,:,:,130),wf(:,129),G2(:,:,:,134))
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,127),MB,G3tensor(:,106))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,130),G2(:,:,:,135),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,127),MB,G3tensor(:,107))
  call loop_AV_Q(G2(:,:,:,130),wf(:,131),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,127),MB,G3tensor(:,108))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,132),G2(:,:,:,137),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,127),MB,G3tensor(:,109))
  call loop_AV_Q(G2(:,:,:,130),wf(:,133),G2(:,:,:,138))
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,127),MB,G3tensor(:,110))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,134),G2(:,:,:,139),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,127),MB,G3tensor(:,111))
  call loop_AS_Q(G2(:,:,:,130),wf(:,64),G2(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,127),MB,G3tensor(:,112))
  call loop_AV_Q(G2(:,:,:,130),wf(:,135),G2(:,:,:,141))
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,127),MB,G3tensor(:,113))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,136),G2(:,:,:,142),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,127),MB,G3tensor(:,114))
  call loop_AV_Q(G2(:,:,:,130),wf(:,137),G2(:,:,:,143))
  call check_last_A_Q(l_switch,G2(:,:,:,143),Q(:,127),MB,G3tensor(:,115))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,138),G2(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,127),MB,G3tensor(:,116))
  call loop_AV_Q(G2(:,:,:,130),wf(:,139),G2(:,:,:,145))
  call check_last_A_Q(l_switch,G2(:,:,:,145),Q(:,127),MB,G3tensor(:,117))
  call loop_AV_Q(G2(:,:,:,130),wf(:,140),G2(:,:,:,146))
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,127),MB,G3tensor(:,118))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,141),G2(:,:,:,147),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,147),Q(:,127),MB,G3tensor(:,119))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,142),G2(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,127),MB,G3tensor(:,120))
  call loop_AV_Q(G2(:,:,:,130),wf(:,143),G2(:,:,:,149))
  call check_last_A_Q(l_switch,G2(:,:,:,149),Q(:,127),MB,G3tensor(:,121))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,144),G2(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,127),MB,G3tensor(:,122))
  call loop_AV_Q(G2(:,:,:,130),wf(:,145),G2(:,:,:,151))
  call check_last_A_Q(l_switch,G2(:,:,:,151),Q(:,127),MB,G3tensor(:,123))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,146),G2(:,:,:,152),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,127),MB,G3tensor(:,124))
  call loop_AV_Q(G2(:,:,:,130),wf(:,147),G2(:,:,:,153))
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,127),MB,G3tensor(:,125))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,148),G2(:,:,:,154),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,127),MB,G3tensor(:,126))
  call loop_AV_Q(G2(:,:,:,130),wf(:,149),G2(:,:,:,155))
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,127),MB,G3tensor(:,127))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,150),G2(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,127),MB,G3tensor(:,128))
  call loop_AV_Q(G2(:,:,:,130),wf(:,151),G2(:,:,:,157))
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,127),MB,G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,152),G2(:,:,:,158),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,127),MB,G3tensor(:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,153),G2(:,:,:,159))
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,127),MB,G3tensor(:,131))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,154),G2(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,160),Q(:,127),MB,G3tensor(:,132))
  call loop_AV_Q(G2(:,:,:,130),wf(:,155),G2(:,:,:,161))
  call check_last_A_Q(l_switch,G2(:,:,:,161),Q(:,127),MB,G3tensor(:,133))
  call loop_AV_Q(G2(:,:,:,130),wf(:,156),G2(:,:,:,162))
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,127),MB,G3tensor(:,134))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,157),G2(:,:,:,163),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,163),Q(:,127),MB,G3tensor(:,135))
  call loop_AZ_Q(G2(:,:,:,130),wf(:,158),G2(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,127),MB,G3tensor(:,136))
  call loop_AV_Q(G1(:,:,:,19),wf(:,2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,58),MB,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-6),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,122),MB,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MB,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,9),G3(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),MB,G4tensor(:,26))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,6),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,58),MB,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-6),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,122),MB,G3(:,:,:,40))
  call loop_AV_Q(G3(:,:,:,40),wf(:,1),G3(:,:,:,41))
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),MB,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,40),wf(:,9),G3(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MB,G4tensor(:,28))
  call loop_AV_Q(G1(:,:,:,19),wf(:,12),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,57),MB,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,121),MB,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,13),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MB,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,16),G3(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MB,G4tensor(:,30))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,19),G1(:,:,:,24),gZd)
  call loop_A_Q(G1(:,:,:,24),Q(:,57),MB,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-6),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,121),MB,G3(:,:,:,46))
  call loop_AV_Q(G3(:,:,:,46),wf(:,13),G3(:,:,:,47))
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),MB,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,46),wf(:,16),G3(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),MB,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,48),ZERO,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,2),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,58),ZERO,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-6),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,122),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,1),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,51),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,9),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,6),G1(:,:,:,27),gZu)
  call loop_A_Q(G1(:,:,:,27),Q(:,58),ZERO,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-6),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,122),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,1),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,9),G3(:,:,:,55),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,6),G1(:,:,:,28),gZd)
  call loop_A_Q(G1(:,:,:,28),Q(:,58),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-6),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,122),ZERO,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,1),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G3(:,:,:,56),wf(:,9),G3(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),ZERO,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-6),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,112),ZERO,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,127),G2(:,:,:,180))
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,127),ZERO,G3tensor(:,137))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,128),G2(:,:,:,181),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,127),ZERO,G3tensor(:,138))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,128),G2(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,127),ZERO,G3tensor(:,139))
  call loop_AV_Q(G2(:,:,:,179),wf(:,129),G2(:,:,:,183))
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,127),ZERO,G3tensor(:,140))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,130),G2(:,:,:,184),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,127),ZERO,G3tensor(:,141))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,130),G2(:,:,:,185),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,127),ZERO,G3tensor(:,142))
  call loop_AV_Q(G2(:,:,:,179),wf(:,131),G2(:,:,:,186))
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,127),ZERO,G3tensor(:,143))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,132),G2(:,:,:,187),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,127),ZERO,G3tensor(:,144))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,132),G2(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,127),ZERO,G3tensor(:,145))
  call loop_AV_Q(G2(:,:,:,179),wf(:,133),G2(:,:,:,189))
  call check_last_A_Q(l_switch,G2(:,:,:,189),Q(:,127),ZERO,G3tensor(:,146))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,134),G2(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,127),ZERO,G3tensor(:,147))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,134),G2(:,:,:,191),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,191),Q(:,127),ZERO,G3tensor(:,148))
  call loop_AV_Q(G2(:,:,:,179),wf(:,135),G2(:,:,:,192))
  call check_last_A_Q(l_switch,G2(:,:,:,192),Q(:,127),ZERO,G3tensor(:,149))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,136),G2(:,:,:,193),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,193),Q(:,127),ZERO,G3tensor(:,150))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,136),G2(:,:,:,194),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,194),Q(:,127),ZERO,G3tensor(:,151))
  call loop_AV_Q(G2(:,:,:,179),wf(:,137),G2(:,:,:,195))
  call check_last_A_Q(l_switch,G2(:,:,:,195),Q(:,127),ZERO,G3tensor(:,152))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,138),G2(:,:,:,196),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,196),Q(:,127),ZERO,G3tensor(:,153))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,138),G2(:,:,:,197),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,197),Q(:,127),ZERO,G3tensor(:,154))
  call loop_AV_Q(G2(:,:,:,179),wf(:,139),G2(:,:,:,198))
  call check_last_A_Q(l_switch,G2(:,:,:,198),Q(:,127),ZERO,G3tensor(:,155))
  call loop_AV_Q(G2(:,:,:,179),wf(:,140),G2(:,:,:,199))
  call check_last_A_Q(l_switch,G2(:,:,:,199),Q(:,127),ZERO,G3tensor(:,156))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,141),G2(:,:,:,200),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,200),Q(:,127),ZERO,G3tensor(:,157))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,141),G2(:,:,:,201),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,201),Q(:,127),ZERO,G3tensor(:,158))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,142),G2(:,:,:,202),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,127),ZERO,G3tensor(:,159))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,142),G2(:,:,:,203),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,203),Q(:,127),ZERO,G3tensor(:,160))
  call loop_AV_Q(G2(:,:,:,179),wf(:,143),G2(:,:,:,204))
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,127),ZERO,G3tensor(:,161))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,144),G2(:,:,:,205),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,205),Q(:,127),ZERO,G3tensor(:,162))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,144),G2(:,:,:,206),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,127),ZERO,G3tensor(:,163))
  call loop_AV_Q(G2(:,:,:,179),wf(:,145),G2(:,:,:,207))
  call check_last_A_Q(l_switch,G2(:,:,:,207),Q(:,127),ZERO,G3tensor(:,164))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,146),G2(:,:,:,208),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,127),ZERO,G3tensor(:,165))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,146),G2(:,:,:,209),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,209),Q(:,127),ZERO,G3tensor(:,166))
  call loop_AV_Q(G2(:,:,:,179),wf(:,147),G2(:,:,:,210))
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,127),ZERO,G3tensor(:,167))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,148),G2(:,:,:,211),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,211),Q(:,127),ZERO,G3tensor(:,168))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,148),G2(:,:,:,212),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,212),Q(:,127),ZERO,G3tensor(:,169))
  call loop_AV_Q(G2(:,:,:,179),wf(:,149),G2(:,:,:,213))
  call check_last_A_Q(l_switch,G2(:,:,:,213),Q(:,127),ZERO,G3tensor(:,170))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,150),G2(:,:,:,214),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,127),ZERO,G3tensor(:,171))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,150),G2(:,:,:,215),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,127),ZERO,G3tensor(:,172))
  call loop_AV_Q(G2(:,:,:,179),wf(:,151),G2(:,:,:,216))
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,127),ZERO,G3tensor(:,173))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,152),G2(:,:,:,217),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,217),Q(:,127),ZERO,G3tensor(:,174))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,152),G2(:,:,:,218),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,127),ZERO,G3tensor(:,175))
  call loop_AV_Q(G2(:,:,:,179),wf(:,153),G2(:,:,:,219))
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,127),ZERO,G3tensor(:,176))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,154),G2(:,:,:,220),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,220),Q(:,127),ZERO,G3tensor(:,177))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,154),G2(:,:,:,221),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,221),Q(:,127),ZERO,G3tensor(:,178))
  call loop_AV_Q(G2(:,:,:,179),wf(:,155),G2(:,:,:,222))
  call check_last_A_Q(l_switch,G2(:,:,:,222),Q(:,127),ZERO,G3tensor(:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,156),G2(:,:,:,223))
  call check_last_A_Q(l_switch,G2(:,:,:,223),Q(:,127),ZERO,G3tensor(:,180))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,157),G2(:,:,:,224),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,127),ZERO,G3tensor(:,181))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,157),G2(:,:,:,225),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,225),Q(:,127),ZERO,G3tensor(:,182))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,158),G2(:,:,:,226),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,226),Q(:,127),ZERO,G3tensor(:,183))
  call loop_AZ_Q(G2(:,:,:,179),wf(:,158),G2(:,:,:,227),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,227),Q(:,127),ZERO,G3tensor(:,184))
  call loop_AV_Q(G1(:,:,:,25),wf(:,12),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,57),ZERO,G2(:,:,:,228))
  call loop_AV_Q(G2(:,:,:,228),wf(:,-6),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,121),ZERO,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,13),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,40))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,16),G3(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,16),G3(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,19),G1(:,:,:,31),gZu)
  call loop_A_Q(G1(:,:,:,31),Q(:,57),ZERO,G2(:,:,:,230))
  call loop_AV_Q(G2(:,:,:,230),wf(:,-6),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,121),ZERO,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,13),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,16),G3(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,65),Q(:,127),ZERO,G4tensor(:,44))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,19),G1(:,:,:,32),gZd)
  call loop_A_Q(G1(:,:,:,32),Q(:,57),ZERO,G2(:,:,:,232))
  call loop_AV_Q(G2(:,:,:,232),wf(:,-6),G2(:,:,:,233))
  call loop_A_Q(G2(:,:,:,233),Q(:,121),ZERO,G3(:,:,:,66))
  call loop_AV_Q(G3(:,:,:,66),wf(:,13),G3(:,:,:,67))
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AZ_Q(G3(:,:,:,66),wf(:,16),G3(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,48),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,2),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,58),ZERO,G2(:,:,:,234))
  call loop_QV_A(G2(:,:,:,234),wf(:,-6),G2(:,:,:,235))
  call loop_Q_A(G2(:,:,:,235),Q(:,122),ZERO,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,1),G3(:,:,:,70))
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,69),wf(:,9),G3(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,127),ZERO,G4tensor(:,48))
  call loop_QZ_A(G3(:,:,:,69),wf(:,9),G3(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,49))
  call loop_QZ_A(G1(:,:,:,33),wf(:,6),G1(:,:,:,35),gZu)
  call loop_Q_A(G1(:,:,:,35),Q(:,58),ZERO,G2(:,:,:,236))
  call loop_QV_A(G2(:,:,:,236),wf(:,-6),G2(:,:,:,237))
  call loop_Q_A(G2(:,:,:,237),Q(:,122),ZERO,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,1),G3(:,:,:,74))
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,50))
  call loop_QZ_A(G3(:,:,:,73),wf(:,9),G3(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,127),ZERO,G4tensor(:,51))
  call loop_QZ_A(G1(:,:,:,33),wf(:,6),G1(:,:,:,36),gZd)
  call loop_Q_A(G1(:,:,:,36),Q(:,58),ZERO,G2(:,:,:,238))
  call loop_QV_A(G2(:,:,:,238),wf(:,-6),G2(:,:,:,239))
  call loop_Q_A(G2(:,:,:,239),Q(:,122),ZERO,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,1),G3(:,:,:,77))
  call check_last_Q_A(l_switch,G3(:,:,:,77),Q(:,127),ZERO,G4tensor(:,52))
  call loop_QZ_A(G3(:,:,:,76),wf(:,9),G3(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,127),ZERO,G4tensor(:,53))
  call loop_QV_A(G1(:,:,:,33),wf(:,-6),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,112),ZERO,G2(:,:,:,240))
  call loop_QV_A(G2(:,:,:,240),wf(:,127),G2(:,:,:,241))
  call check_last_Q_A(l_switch,G2(:,:,:,241),Q(:,127),ZERO,G3tensor(:,185))
  call loop_QZ_A(G2(:,:,:,240),wf(:,128),G2(:,:,:,242),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,127),ZERO,G3tensor(:,186))
  call loop_QZ_A(G2(:,:,:,240),wf(:,128),G2(:,:,:,243),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,243),Q(:,127),ZERO,G3tensor(:,187))
  call loop_QV_A(G2(:,:,:,240),wf(:,129),G2(:,:,:,244))
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,127),ZERO,G3tensor(:,188))
  call loop_QZ_A(G2(:,:,:,240),wf(:,130),G2(:,:,:,245),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,245),Q(:,127),ZERO,G3tensor(:,189))
  call loop_QZ_A(G2(:,:,:,240),wf(:,130),G2(:,:,:,246),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,127),ZERO,G3tensor(:,190))
  call loop_QV_A(G2(:,:,:,240),wf(:,131),G2(:,:,:,247))
  call check_last_Q_A(l_switch,G2(:,:,:,247),Q(:,127),ZERO,G3tensor(:,191))
  call loop_QZ_A(G2(:,:,:,240),wf(:,132),G2(:,:,:,248),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,127),ZERO,G3tensor(:,192))
  call loop_QZ_A(G2(:,:,:,240),wf(:,132),G2(:,:,:,249),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,249),Q(:,127),ZERO,G3tensor(:,193))
  call loop_QV_A(G2(:,:,:,240),wf(:,133),G2(:,:,:,250))
  call check_last_Q_A(l_switch,G2(:,:,:,250),Q(:,127),ZERO,G3tensor(:,194))
  call loop_QZ_A(G2(:,:,:,240),wf(:,134),G2(:,:,:,251),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,251),Q(:,127),ZERO,G3tensor(:,195))
  call loop_QZ_A(G2(:,:,:,240),wf(:,134),G2(:,:,:,252),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,252),Q(:,127),ZERO,G3tensor(:,196))
  call loop_QV_A(G2(:,:,:,240),wf(:,135),G2(:,:,:,253))
  call check_last_Q_A(l_switch,G2(:,:,:,253),Q(:,127),ZERO,G3tensor(:,197))
  call loop_QZ_A(G2(:,:,:,240),wf(:,136),G2(:,:,:,254),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,254),Q(:,127),ZERO,G3tensor(:,198))
  call loop_QZ_A(G2(:,:,:,240),wf(:,136),G2(:,:,:,255),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,255),Q(:,127),ZERO,G3tensor(:,199))
  call loop_QV_A(G2(:,:,:,240),wf(:,137),G2(:,:,:,256))
  call check_last_Q_A(l_switch,G2(:,:,:,256),Q(:,127),ZERO,G3tensor(:,200))
  call loop_QZ_A(G2(:,:,:,240),wf(:,138),G2(:,:,:,257),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,257),Q(:,127),ZERO,G3tensor(:,201))
  call loop_QZ_A(G2(:,:,:,240),wf(:,138),G2(:,:,:,258),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,258),Q(:,127),ZERO,G3tensor(:,202))
  call loop_QV_A(G2(:,:,:,240),wf(:,139),G2(:,:,:,259))
  call check_last_Q_A(l_switch,G2(:,:,:,259),Q(:,127),ZERO,G3tensor(:,203))
  call loop_QV_A(G2(:,:,:,240),wf(:,140),G2(:,:,:,260))
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,127),ZERO,G3tensor(:,204))
  call loop_QZ_A(G2(:,:,:,240),wf(:,141),G2(:,:,:,261),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,261),Q(:,127),ZERO,G3tensor(:,205))
  call loop_QZ_A(G2(:,:,:,240),wf(:,141),G2(:,:,:,262),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,262),Q(:,127),ZERO,G3tensor(:,206))
  call loop_QZ_A(G2(:,:,:,240),wf(:,142),G2(:,:,:,263),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,263),Q(:,127),ZERO,G3tensor(:,207))
  call loop_QZ_A(G2(:,:,:,240),wf(:,142),G2(:,:,:,264),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,127),ZERO,G3tensor(:,208))
  call loop_QV_A(G2(:,:,:,240),wf(:,143),G2(:,:,:,265))
  call check_last_Q_A(l_switch,G2(:,:,:,265),Q(:,127),ZERO,G3tensor(:,209))
  call loop_QZ_A(G2(:,:,:,240),wf(:,144),G2(:,:,:,266),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,127),ZERO,G3tensor(:,210))
  call loop_QZ_A(G2(:,:,:,240),wf(:,144),G2(:,:,:,267),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,127),ZERO,G3tensor(:,211))
  call loop_QV_A(G2(:,:,:,240),wf(:,145),G2(:,:,:,268))
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,127),ZERO,G3tensor(:,212))
  call loop_QZ_A(G2(:,:,:,240),wf(:,146),G2(:,:,:,269),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,127),ZERO,G3tensor(:,213))
  call loop_QZ_A(G2(:,:,:,240),wf(:,146),G2(:,:,:,270),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,127),ZERO,G3tensor(:,214))
  call loop_QV_A(G2(:,:,:,240),wf(:,147),G2(:,:,:,271))
  call check_last_Q_A(l_switch,G2(:,:,:,271),Q(:,127),ZERO,G3tensor(:,215))
  call loop_QZ_A(G2(:,:,:,240),wf(:,148),G2(:,:,:,272),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,272),Q(:,127),ZERO,G3tensor(:,216))
  call loop_QZ_A(G2(:,:,:,240),wf(:,148),G2(:,:,:,273),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,127),ZERO,G3tensor(:,217))
  call loop_QV_A(G2(:,:,:,240),wf(:,149),G2(:,:,:,274))
  call check_last_Q_A(l_switch,G2(:,:,:,274),Q(:,127),ZERO,G3tensor(:,218))
  call loop_QZ_A(G2(:,:,:,240),wf(:,150),G2(:,:,:,275),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,275),Q(:,127),ZERO,G3tensor(:,219))
  call loop_QZ_A(G2(:,:,:,240),wf(:,150),G2(:,:,:,276),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,276),Q(:,127),ZERO,G3tensor(:,220))
  call loop_QV_A(G2(:,:,:,240),wf(:,151),G2(:,:,:,277))
  call check_last_Q_A(l_switch,G2(:,:,:,277),Q(:,127),ZERO,G3tensor(:,221))
  call loop_QZ_A(G2(:,:,:,240),wf(:,152),G2(:,:,:,278),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,278),Q(:,127),ZERO,G3tensor(:,222))
  call loop_QZ_A(G2(:,:,:,240),wf(:,152),G2(:,:,:,279),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,279),Q(:,127),ZERO,G3tensor(:,223))
  call loop_QV_A(G2(:,:,:,240),wf(:,153),G2(:,:,:,280))
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,127),ZERO,G3tensor(:,224))
  call loop_QZ_A(G2(:,:,:,240),wf(:,154),G2(:,:,:,281),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,281),Q(:,127),ZERO,G3tensor(:,225))
  call loop_QZ_A(G2(:,:,:,240),wf(:,154),G2(:,:,:,282),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,127),ZERO,G3tensor(:,226))
  call loop_QV_A(G2(:,:,:,240),wf(:,155),G2(:,:,:,283))
  call check_last_Q_A(l_switch,G2(:,:,:,283),Q(:,127),ZERO,G3tensor(:,227))
  call loop_QV_A(G2(:,:,:,240),wf(:,156),G2(:,:,:,284))
  call check_last_Q_A(l_switch,G2(:,:,:,284),Q(:,127),ZERO,G3tensor(:,228))
  call loop_QZ_A(G2(:,:,:,240),wf(:,157),G2(:,:,:,285),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,285),Q(:,127),ZERO,G3tensor(:,229))
  call loop_QZ_A(G2(:,:,:,240),wf(:,157),G2(:,:,:,286),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,127),ZERO,G3tensor(:,230))
  call loop_QZ_A(G2(:,:,:,240),wf(:,158),G2(:,:,:,287),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,287),Q(:,127),ZERO,G3tensor(:,231))
  call loop_QZ_A(G2(:,:,:,240),wf(:,158),G2(:,:,:,288),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,288),Q(:,127),ZERO,G3tensor(:,232))
  call loop_QV_A(G1(:,:,:,33),wf(:,12),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,57),ZERO,G2(:,:,:,289))
  call loop_QV_A(G2(:,:,:,289),wf(:,-6),G2(:,:,:,290))
  call loop_Q_A(G2(:,:,:,290),Q(:,121),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,13),G3(:,:,:,80))
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),ZERO,G4tensor(:,54))
  call loop_QZ_A(G3(:,:,:,79),wf(:,16),G3(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,127),ZERO,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,79),wf(:,16),G3(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,56))
  call loop_QZ_A(G1(:,:,:,33),wf(:,19),G1(:,:,:,39),gZu)
  call loop_Q_A(G1(:,:,:,39),Q(:,57),ZERO,G2(:,:,:,291))
  call loop_QV_A(G2(:,:,:,291),wf(:,-6),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,121),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,13),G3(:,:,:,84))
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,83),wf(:,16),G3(:,:,:,85),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,127),ZERO,G4tensor(:,58))
  call loop_QZ_A(G1(:,:,:,33),wf(:,19),G1(:,:,:,40),gZd)
  call loop_Q_A(G1(:,:,:,40),Q(:,57),ZERO,G2(:,:,:,293))
  call loop_QV_A(G2(:,:,:,293),wf(:,-6),G2(:,:,:,294))
  call loop_Q_A(G2(:,:,:,294),Q(:,121),ZERO,G3(:,:,:,86))
  call loop_QV_A(G3(:,:,:,86),wf(:,13),G3(:,:,:,87))
  call check_last_Q_A(l_switch,G3(:,:,:,87),Q(:,127),ZERO,G4tensor(:,59))
  call loop_QZ_A(G3(:,:,:,86),wf(:,16),G3(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,127),ZERO,G4tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,10),ZERO,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,3),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,58),ZERO,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-6),G2(:,:,:,296))
  call loop_A_Q(G2(:,:,:,296),Q(:,122),ZERO,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,1),G3(:,:,:,90))
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,89),wf(:,9),G3(:,:,:,91),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,127),ZERO,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,89),wf(:,9),G3(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,63))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-6),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,74),ZERO,G2(:,:,:,297))
  call loop_AV_Q(G2(:,:,:,297),wf(:,3),G2(:,:,:,298))
  call loop_A_Q(G2(:,:,:,298),Q(:,122),ZERO,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,1),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,127),ZERO,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,93),wf(:,9),G3(:,:,:,95),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,127),ZERO,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,93),wf(:,9),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),ZERO,G4tensor(:,66))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,10),MT,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,58),MT,G2(:,:,:,299))
  call loop_AV_Q(G2(:,:,:,299),wf(:,-6),G2(:,:,:,300))
  call loop_A_Q(G2(:,:,:,300),Q(:,122),MT,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,1),G3(:,:,:,98))
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,127),MT,G4tensor(:,67))
  call loop_AZ_Q(G3(:,:,:,97),wf(:,9),G3(:,:,:,99),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,99),Q(:,127),MT,G4tensor(:,68))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-6),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,74),MT,G2(:,:,:,301))
  call loop_AV_Q(G2(:,:,:,301),wf(:,3),G2(:,:,:,302))
  call loop_A_Q(G2(:,:,:,302),Q(:,122),MT,G3(:,:,:,100))
  call loop_AV_Q(G3(:,:,:,100),wf(:,1),G3(:,:,:,101))
  call check_last_A_Q(l_switch,G3(:,:,:,101),Q(:,127),MT,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,100),wf(:,9),G3(:,:,:,102),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,127),MT,G4tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,10),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,3),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,58),ZERO,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,-6),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,122),ZERO,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,1),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),ZERO,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,103),wf(:,9),G3(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),ZERO,G4tensor(:,72))
  call loop_QZ_A(G3(:,:,:,103),wf(:,9),G3(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),ZERO,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,47),wf(:,-6),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,74),ZERO,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,3),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,122),ZERO,G3(:,:,:,107))
  call loop_QV_A(G3(:,:,:,107),wf(:,1),G3(:,:,:,108))
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),ZERO,G4tensor(:,74))
  call loop_QZ_A(G3(:,:,:,107),wf(:,9),G3(:,:,:,109),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,109),Q(:,127),ZERO,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,107),wf(:,9),G3(:,:,:,110),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,127),ZERO,G4tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,10),MT,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,3),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,58),MT,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,-6),G2(:,:,:,308))
  call loop_Q_A(G2(:,:,:,308),Q(:,122),MT,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,1),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,127),MT,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,111),wf(:,9),G3(:,:,:,113),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,113),Q(:,127),MT,G4tensor(:,78))
  call loop_QV_A(G1(:,:,:,50),wf(:,-6),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,74),MT,G2(:,:,:,309))
  call loop_QV_A(G2(:,:,:,309),wf(:,3),G2(:,:,:,310))
  call loop_Q_A(G2(:,:,:,310),Q(:,122),MT,G3(:,:,:,114))
  call loop_QV_A(G3(:,:,:,114),wf(:,1),G3(:,:,:,115))
  call check_last_Q_A(l_switch,G3(:,:,:,115),Q(:,127),MT,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,114),wf(:,9),G3(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,127),MT,G4tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,10),MB,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,3),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,58),MB,G2(:,:,:,311))
  call loop_AV_Q(G2(:,:,:,311),wf(:,-6),G2(:,:,:,312))
  call loop_A_Q(G2(:,:,:,312),Q(:,122),MB,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,1),G3(:,:,:,118))
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,127),MB,G4tensor(:,81))
  call loop_AZ_Q(G3(:,:,:,117),wf(:,9),G3(:,:,:,119),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,82))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-6),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,74),MB,G2(:,:,:,313))
  call loop_AV_Q(G2(:,:,:,313),wf(:,3),G2(:,:,:,314))
  call loop_A_Q(G2(:,:,:,314),Q(:,122),MB,G3(:,:,:,120))
  call loop_AV_Q(G3(:,:,:,120),wf(:,1),G3(:,:,:,121))
  call check_last_A_Q(l_switch,G3(:,:,:,121),Q(:,127),MB,G4tensor(:,83))
  call loop_AZ_Q(G3(:,:,:,120),wf(:,9),G3(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),MB,G4tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,10),MB,G1(:,:,:,56))
  call loop_QV_A(G1(:,:,:,56),wf(:,3),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,58),MB,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,-6),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,122),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,1),G3(:,:,:,124))
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MB,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,123),wf(:,9),G3(:,:,:,125),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,127),MB,G4tensor(:,86))
  call loop_QV_A(G1(:,:,:,56),wf(:,-6),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,74),MB,G2(:,:,:,317))
  call loop_QV_A(G2(:,:,:,317),wf(:,3),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,122),MB,G3(:,:,:,126))
  call loop_QV_A(G3(:,:,:,126),wf(:,1),G3(:,:,:,127))
  call check_last_Q_A(l_switch,G3(:,:,:,127),Q(:,127),MB,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,126),wf(:,9),G3(:,:,:,128),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),MB,G4tensor(:,88))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,10),ZERO,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,3),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,58),ZERO,G2(:,:,:,319))
  call loop_AV_Q(G2(:,:,:,319),wf(:,-6),G2(:,:,:,320))
  call loop_A_Q(G2(:,:,:,320),Q(:,122),ZERO,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,1),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,89))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,9),G3(:,:,:,131),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,131),Q(:,127),ZERO,G4tensor(:,90))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-6),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,74),ZERO,G2(:,:,:,321))
  call loop_AV_Q(G2(:,:,:,321),wf(:,3),G2(:,:,:,322))
  call loop_A_Q(G2(:,:,:,322),Q(:,122),ZERO,G3(:,:,:,132))
  call loop_AV_Q(G3(:,:,:,132),wf(:,1),G3(:,:,:,133))
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),ZERO,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,132),wf(:,9),G3(:,:,:,134),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,127),ZERO,G4tensor(:,92))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,10),MT,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,3),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,58),MT,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-6),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,122),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,1),G3(:,:,:,136))
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,127),MT,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,135),wf(:,9),G3(:,:,:,137),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,137),Q(:,127),MT,G4tensor(:,94))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-6),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,74),MT,G2(:,:,:,325))
  call loop_AV_Q(G2(:,:,:,325),wf(:,3),G2(:,:,:,326))
  call loop_A_Q(G2(:,:,:,326),Q(:,122),MT,G3(:,:,:,138))
  call loop_AV_Q(G3(:,:,:,138),wf(:,1),G3(:,:,:,139))
  call check_last_A_Q(l_switch,G3(:,:,:,139),Q(:,127),MT,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,138),wf(:,9),G3(:,:,:,140),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),MT,G4tensor(:,96))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,10),ZERO,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,3),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,58),ZERO,G2(:,:,:,327))
  call loop_QV_A(G2(:,:,:,327),wf(:,-6),G2(:,:,:,328))
  call loop_Q_A(G2(:,:,:,328),Q(:,122),ZERO,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,1),G3(:,:,:,142))
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),ZERO,G4tensor(:,97))
  call loop_QZ_A(G3(:,:,:,141),wf(:,9),G3(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,127),ZERO,G4tensor(:,98))
  call loop_QV_A(G1(:,:,:,65),wf(:,-6),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,74),ZERO,G2(:,:,:,329))
  call loop_QV_A(G2(:,:,:,329),wf(:,3),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,122),ZERO,G3(:,:,:,144))
  call loop_QV_A(G3(:,:,:,144),wf(:,1),G3(:,:,:,145))
  call check_last_Q_A(l_switch,G3(:,:,:,145),Q(:,127),ZERO,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,144),wf(:,9),G3(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,127),ZERO,G4tensor(:,100))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,10),MT,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,3),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,58),MT,G2(:,:,:,331))
  call loop_QV_A(G2(:,:,:,331),wf(:,-6),G2(:,:,:,332))
  call loop_Q_A(G2(:,:,:,332),Q(:,122),MT,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,1),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,127),MT,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,147),wf(:,9),G3(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),MT,G4tensor(:,102))
  call loop_QV_A(G1(:,:,:,68),wf(:,-6),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,74),MT,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,3),G2(:,:,:,334))
  call loop_Q_A(G2(:,:,:,334),Q(:,122),MT,G3(:,:,:,150))
  call loop_QV_A(G3(:,:,:,150),wf(:,1),G3(:,:,:,151))
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),MT,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,150),wf(:,9),G3(:,:,:,152),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MT,G4tensor(:,104))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,10),ZERO,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,3),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,58),ZERO,G2(:,:,:,335))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-6),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,122),ZERO,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,1),G3(:,:,:,154))
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,127),ZERO,G4tensor(:,105))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,9),G3(:,:,:,155),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,155),Q(:,127),ZERO,G4tensor(:,106))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-6),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,74),ZERO,G2(:,:,:,337))
  call loop_AV_Q(G2(:,:,:,337),wf(:,3),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,122),ZERO,G3(:,:,:,156))
  call loop_AV_Q(G3(:,:,:,156),wf(:,1),G3(:,:,:,157))
  call check_last_A_Q(l_switch,G3(:,:,:,157),Q(:,127),ZERO,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,156),wf(:,9),G3(:,:,:,158),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,127),ZERO,G4tensor(:,108))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,10),MB,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,3),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,58),MB,G2(:,:,:,339))
  call loop_AV_Q(G2(:,:,:,339),wf(:,-6),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,122),MB,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,1),G3(:,:,:,160))
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,127),MB,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,159),wf(:,9),G3(:,:,:,161),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,161),Q(:,127),MB,G4tensor(:,110))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-6),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,74),MB,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,3),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,122),MB,G3(:,:,:,162))
  call loop_AV_Q(G3(:,:,:,162),wf(:,1),G3(:,:,:,163))
  call check_last_A_Q(l_switch,G3(:,:,:,163),Q(:,127),MB,G4tensor(:,111))
  call loop_AZ_Q(G3(:,:,:,162),wf(:,9),G3(:,:,:,164),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,127),MB,G4tensor(:,112))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,10),ZERO,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,58),ZERO,G2(:,:,:,343))
  call loop_QV_A(G2(:,:,:,343),wf(:,-6),G2(:,:,:,344))
  call loop_Q_A(G2(:,:,:,344),Q(:,122),ZERO,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,1),G3(:,:,:,166))
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,127),ZERO,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,165),wf(:,9),G3(:,:,:,167),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,127),ZERO,G4tensor(:,114))
  call loop_QV_A(G1(:,:,:,77),wf(:,-6),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,74),ZERO,G2(:,:,:,345))
  call loop_QV_A(G2(:,:,:,345),wf(:,3),G2(:,:,:,346))
  call loop_Q_A(G2(:,:,:,346),Q(:,122),ZERO,G3(:,:,:,168))
  call loop_QV_A(G3(:,:,:,168),wf(:,1),G3(:,:,:,169))
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),ZERO,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,168),wf(:,9),G3(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,116))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,10),MB,G1(:,:,:,80))
  call loop_QV_A(G1(:,:,:,80),wf(:,3),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,58),MB,G2(:,:,:,347))
  call loop_QV_A(G2(:,:,:,347),wf(:,-6),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,122),MB,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,1),G3(:,:,:,172))
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),MB,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,171),wf(:,9),G3(:,:,:,173),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,173),Q(:,127),MB,G4tensor(:,118))
  call loop_QV_A(G1(:,:,:,80),wf(:,-6),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,74),MB,G2(:,:,:,349))
  call loop_QV_A(G2(:,:,:,349),wf(:,3),G2(:,:,:,350))
  call loop_Q_A(G2(:,:,:,350),Q(:,122),MB,G3(:,:,:,174))
  call loop_QV_A(G3(:,:,:,174),wf(:,1),G3(:,:,:,175))
  call check_last_Q_A(l_switch,G3(:,:,:,175),Q(:,127),MB,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,174),wf(:,9),G3(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),MB,G4tensor(:,120))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,9),ZERO,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,-6),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,73),ZERO,G2(:,:,:,351))
  call loop_QV_A(G2(:,:,:,351),wf(:,3),G2(:,:,:,352))
  call loop_Q_A(G2(:,:,:,352),Q(:,121),ZERO,G3(:,:,:,177))
  call loop_QV_A(G3(:,:,:,177),wf(:,13),G3(:,:,:,178))
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,177),wf(:,16),G3(:,:,:,179),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,179),Q(:,127),ZERO,G4tensor(:,122))
  call loop_QZ_A(G3(:,:,:,177),wf(:,16),G3(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,123))
  call loop_QV_A(G1(:,:,:,83),wf(:,3),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,57),ZERO,G2(:,:,:,353))
  call loop_QV_A(G2(:,:,:,353),wf(:,-6),G2(:,:,:,354))
  call loop_Q_A(G2(:,:,:,354),Q(:,121),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,13),G3(:,:,:,182))
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),ZERO,G4tensor(:,124))
  call loop_QZ_A(G3(:,:,:,181),wf(:,16),G3(:,:,:,183),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,127),ZERO,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,181),wf(:,16),G3(:,:,:,184),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,127),ZERO,G4tensor(:,126))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,9),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,-6),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,73),MT,G2(:,:,:,355))
  call loop_QV_A(G2(:,:,:,355),wf(:,3),G2(:,:,:,356))
  call loop_Q_A(G2(:,:,:,356),Q(:,121),MT,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,13),G3(:,:,:,186))
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),MT,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,185),wf(:,16),G3(:,:,:,187),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,127),MT,G4tensor(:,128))
  call loop_QV_A(G1(:,:,:,86),wf(:,3),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,57),MT,G2(:,:,:,357))
  call loop_QV_A(G2(:,:,:,357),wf(:,-6),G2(:,:,:,358))
  call loop_Q_A(G2(:,:,:,358),Q(:,121),MT,G3(:,:,:,188))
  call loop_QV_A(G3(:,:,:,188),wf(:,13),G3(:,:,:,189))
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),MT,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,188),wf(:,16),G3(:,:,:,190),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),MT,G4tensor(:,130))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,9),ZERO,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-6),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,73),ZERO,G2(:,:,:,359))
  call loop_AV_Q(G2(:,:,:,359),wf(:,3),G2(:,:,:,360))
  call loop_A_Q(G2(:,:,:,360),Q(:,121),ZERO,G3(:,:,:,191))
  call loop_AV_Q(G3(:,:,:,191),wf(:,13),G3(:,:,:,192))
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,191),wf(:,16),G3(:,:,:,193),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,132))
  call loop_AZ_Q(G3(:,:,:,191),wf(:,16),G3(:,:,:,194),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,133))
  call loop_AV_Q(G1(:,:,:,89),wf(:,3),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,57),ZERO,G2(:,:,:,361))
  call loop_AV_Q(G2(:,:,:,361),wf(:,-6),G2(:,:,:,362))
  call loop_A_Q(G2(:,:,:,362),Q(:,121),ZERO,G3(:,:,:,195))
  call loop_AV_Q(G3(:,:,:,195),wf(:,13),G3(:,:,:,196))
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,134))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,16),G3(:,:,:,197),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,197),Q(:,127),ZERO,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,16),G3(:,:,:,198),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),ZERO,G4tensor(:,136))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,9),MT,G1(:,:,:,92))
  call loop_AV_Q(G1(:,:,:,92),wf(:,-6),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,73),MT,G2(:,:,:,363))
  call loop_AV_Q(G2(:,:,:,363),wf(:,3),G2(:,:,:,364))
  call loop_A_Q(G2(:,:,:,364),Q(:,121),MT,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,13),G3(:,:,:,200))
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,127),MT,G4tensor(:,137))
  call loop_AZ_Q(G3(:,:,:,199),wf(:,16),G3(:,:,:,201),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,201),Q(:,127),MT,G4tensor(:,138))
  call loop_AV_Q(G1(:,:,:,92),wf(:,3),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,57),MT,G2(:,:,:,365))
  call loop_AV_Q(G2(:,:,:,365),wf(:,-6),G2(:,:,:,366))
  call loop_A_Q(G2(:,:,:,366),Q(:,121),MT,G3(:,:,:,202))
  call loop_AV_Q(G3(:,:,:,202),wf(:,13),G3(:,:,:,203))
  call check_last_A_Q(l_switch,G3(:,:,:,203),Q(:,127),MT,G4tensor(:,139))
  call loop_AZ_Q(G3(:,:,:,202),wf(:,16),G3(:,:,:,204),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,127),MT,G4tensor(:,140))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,9),MB,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,-6),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,73),MB,G2(:,:,:,367))
  call loop_QV_A(G2(:,:,:,367),wf(:,3),G2(:,:,:,368))
  call loop_Q_A(G2(:,:,:,368),Q(:,121),MB,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,13),G3(:,:,:,206))
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,127),MB,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,205),wf(:,16),G3(:,:,:,207),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,207),Q(:,127),MB,G4tensor(:,142))
  call loop_QV_A(G1(:,:,:,95),wf(:,3),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,57),MB,G2(:,:,:,369))
  call loop_QV_A(G2(:,:,:,369),wf(:,-6),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,121),MB,G3(:,:,:,208))
  call loop_QV_A(G3(:,:,:,208),wf(:,13),G3(:,:,:,209))
  call check_last_Q_A(l_switch,G3(:,:,:,209),Q(:,127),MB,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,208),wf(:,16),G3(:,:,:,210),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,127),MB,G4tensor(:,144))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,9),MB,G1(:,:,:,98))
  call loop_AV_Q(G1(:,:,:,98),wf(:,-6),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,73),MB,G2(:,:,:,371))
  call loop_AV_Q(G2(:,:,:,371),wf(:,3),G2(:,:,:,372))
  call loop_A_Q(G2(:,:,:,372),Q(:,121),MB,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,13),G3(:,:,:,212))
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,127),MB,G4tensor(:,145))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,16),G3(:,:,:,213),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,213),Q(:,127),MB,G4tensor(:,146))
  call loop_AV_Q(G1(:,:,:,98),wf(:,3),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,57),MB,G2(:,:,:,373))
  call loop_AV_Q(G2(:,:,:,373),wf(:,-6),G2(:,:,:,374))
  call loop_A_Q(G2(:,:,:,374),Q(:,121),MB,G3(:,:,:,214))
  call loop_AV_Q(G3(:,:,:,214),wf(:,13),G3(:,:,:,215))
  call check_last_A_Q(l_switch,G3(:,:,:,215),Q(:,127),MB,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,214),wf(:,16),G3(:,:,:,216),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,216),Q(:,127),MB,G4tensor(:,148))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,28),gZu)
  call loop_Q_A(G0(:,:,:,28),Q(:,9),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,-6),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,73),ZERO,G2(:,:,:,375))
  call loop_QV_A(G2(:,:,:,375),wf(:,3),G2(:,:,:,376))
  call loop_Q_A(G2(:,:,:,376),Q(:,121),ZERO,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,13),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),ZERO,G4tensor(:,149))
  call loop_QZ_A(G3(:,:,:,217),wf(:,16),G3(:,:,:,219),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,127),ZERO,G4tensor(:,150))
  call loop_QV_A(G1(:,:,:,101),wf(:,3),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,57),ZERO,G2(:,:,:,377))
  call loop_QV_A(G2(:,:,:,377),wf(:,-6),G2(:,:,:,378))
  call loop_Q_A(G2(:,:,:,378),Q(:,121),ZERO,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,13),G3(:,:,:,221))
  call check_last_Q_A(l_switch,G3(:,:,:,221),Q(:,127),ZERO,G4tensor(:,151))
  call loop_QZ_A(G3(:,:,:,220),wf(:,16),G3(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),ZERO,G4tensor(:,152))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,29),gZu)
  call loop_Q_A(G0(:,:,:,29),Q(:,9),MT,G1(:,:,:,104))
  call loop_QV_A(G1(:,:,:,104),wf(:,-6),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,73),MT,G2(:,:,:,379))
  call loop_QV_A(G2(:,:,:,379),wf(:,3),G2(:,:,:,380))
  call loop_Q_A(G2(:,:,:,380),Q(:,121),MT,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,13),G3(:,:,:,224))
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),MT,G4tensor(:,153))
  call loop_QZ_A(G3(:,:,:,223),wf(:,16),G3(:,:,:,225),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,127),MT,G4tensor(:,154))
  call loop_QV_A(G1(:,:,:,104),wf(:,3),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,57),MT,G2(:,:,:,381))
  call loop_QV_A(G2(:,:,:,381),wf(:,-6),G2(:,:,:,382))
  call loop_Q_A(G2(:,:,:,382),Q(:,121),MT,G3(:,:,:,226))
  call loop_QV_A(G3(:,:,:,226),wf(:,13),G3(:,:,:,227))
  call check_last_Q_A(l_switch,G3(:,:,:,227),Q(:,127),MT,G4tensor(:,155))
  call loop_QZ_A(G3(:,:,:,226),wf(:,16),G3(:,:,:,228),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,127),MT,G4tensor(:,156))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,30),gZu)
  call loop_A_Q(G0(:,:,:,30),Q(:,9),ZERO,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-6),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,73),ZERO,G2(:,:,:,383))
  call loop_AV_Q(G2(:,:,:,383),wf(:,3),G2(:,:,:,384))
  call loop_A_Q(G2(:,:,:,384),Q(:,121),ZERO,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,13),G3(:,:,:,230))
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),ZERO,G4tensor(:,157))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,16),G3(:,:,:,231),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,231),Q(:,127),ZERO,G4tensor(:,158))
  call loop_AV_Q(G1(:,:,:,107),wf(:,3),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,57),ZERO,G2(:,:,:,385))
  call loop_AV_Q(G2(:,:,:,385),wf(:,-6),G2(:,:,:,386))
  call loop_A_Q(G2(:,:,:,386),Q(:,121),ZERO,G3(:,:,:,232))
  call loop_AV_Q(G3(:,:,:,232),wf(:,13),G3(:,:,:,233))
  call check_last_A_Q(l_switch,G3(:,:,:,233),Q(:,127),ZERO,G4tensor(:,159))
  call loop_AZ_Q(G3(:,:,:,232),wf(:,16),G3(:,:,:,234),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,127),ZERO,G4tensor(:,160))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,31),gZu)
  call loop_A_Q(G0(:,:,:,31),Q(:,9),MT,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,-6),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,73),MT,G2(:,:,:,387))
  call loop_AV_Q(G2(:,:,:,387),wf(:,3),G2(:,:,:,388))
  call loop_A_Q(G2(:,:,:,388),Q(:,121),MT,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,13),G3(:,:,:,236))
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,127),MT,G4tensor(:,161))
  call loop_AZ_Q(G3(:,:,:,235),wf(:,16),G3(:,:,:,237),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,237),Q(:,127),MT,G4tensor(:,162))
  call loop_AV_Q(G1(:,:,:,110),wf(:,3),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,57),MT,G2(:,:,:,389))
  call loop_AV_Q(G2(:,:,:,389),wf(:,-6),G2(:,:,:,390))
  call loop_A_Q(G2(:,:,:,390),Q(:,121),MT,G3(:,:,:,238))
  call loop_AV_Q(G3(:,:,:,238),wf(:,13),G3(:,:,:,239))
  call check_last_A_Q(l_switch,G3(:,:,:,239),Q(:,127),MT,G4tensor(:,163))
  call loop_AZ_Q(G3(:,:,:,238),wf(:,16),G3(:,:,:,240),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,127),MT,G4tensor(:,164))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,32),gZd)
  call loop_Q_A(G0(:,:,:,32),Q(:,9),ZERO,G1(:,:,:,113))
  call loop_QV_A(G1(:,:,:,113),wf(:,-6),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,73),ZERO,G2(:,:,:,391))
  call loop_QV_A(G2(:,:,:,391),wf(:,3),G2(:,:,:,392))
  call loop_Q_A(G2(:,:,:,392),Q(:,121),ZERO,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,13),G3(:,:,:,242))
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,127),ZERO,G4tensor(:,165))
  call loop_QZ_A(G3(:,:,:,241),wf(:,16),G3(:,:,:,243),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,243),Q(:,127),ZERO,G4tensor(:,166))
  call loop_QV_A(G1(:,:,:,113),wf(:,3),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,57),ZERO,G2(:,:,:,393))
  call loop_QV_A(G2(:,:,:,393),wf(:,-6),G2(:,:,:,394))
  call loop_Q_A(G2(:,:,:,394),Q(:,121),ZERO,G3(:,:,:,244))
  call loop_QV_A(G3(:,:,:,244),wf(:,13),G3(:,:,:,245))
  call check_last_Q_A(l_switch,G3(:,:,:,245),Q(:,127),ZERO,G4tensor(:,167))
  call loop_QZ_A(G3(:,:,:,244),wf(:,16),G3(:,:,:,246),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,127),ZERO,G4tensor(:,168))
  call loop_QZ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,33),gZd)
  call loop_Q_A(G0(:,:,:,33),Q(:,9),MB,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,-6),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,73),MB,G2(:,:,:,395))
  call loop_QV_A(G2(:,:,:,395),wf(:,3),G2(:,:,:,396))
  call loop_Q_A(G2(:,:,:,396),Q(:,121),MB,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,13),G3(:,:,:,248))
  call check_last_Q_A(l_switch,G3(:,:,:,248),Q(:,127),MB,G4tensor(:,169))
  call loop_QZ_A(G3(:,:,:,247),wf(:,16),G3(:,:,:,249),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,249),Q(:,127),MB,G4tensor(:,170))
  call loop_QV_A(G1(:,:,:,116),wf(:,3),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,57),MB,G2(:,:,:,397))
  call loop_QV_A(G2(:,:,:,397),wf(:,-6),G2(:,:,:,398))
  call loop_Q_A(G2(:,:,:,398),Q(:,121),MB,G3(:,:,:,250))
  call loop_QV_A(G3(:,:,:,250),wf(:,13),G3(:,:,:,251))
  call check_last_Q_A(l_switch,G3(:,:,:,251),Q(:,127),MB,G4tensor(:,171))
  call loop_QZ_A(G3(:,:,:,250),wf(:,16),G3(:,:,:,252),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,127),MB,G4tensor(:,172))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,34),gZd)
  call loop_A_Q(G0(:,:,:,34),Q(:,9),ZERO,G1(:,:,:,119))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-6),G1(:,:,:,120))
  call loop_A_Q(G1(:,:,:,120),Q(:,73),ZERO,G2(:,:,:,399))
  call loop_AV_Q(G2(:,:,:,399),wf(:,3),G2(:,:,:,400))
  call loop_A_Q(G2(:,:,:,400),Q(:,121),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,13),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,16),G3(:,:,:,255),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AV_Q(G1(:,:,:,119),wf(:,3),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,57),ZERO,G2(:,:,:,401))
  call loop_AV_Q(G2(:,:,:,401),wf(:,-6),G2(:,:,:,402))
  call loop_A_Q(G2(:,:,:,402),Q(:,121),ZERO,G3(:,:,:,256))
  call loop_AV_Q(G3(:,:,:,256),wf(:,13),G3(:,:,:,257))
  call check_last_A_Q(l_switch,G3(:,:,:,257),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,256),wf(:,16),G3(:,:,:,258),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,35),gZd)
  call loop_A_Q(G0(:,:,:,35),Q(:,9),MB,G1(:,:,:,122))
  call loop_AV_Q(G1(:,:,:,122),wf(:,-6),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,73),MB,G2(:,:,:,403))
  call loop_AV_Q(G2(:,:,:,403),wf(:,3),G2(:,:,:,404))
  call loop_A_Q(G2(:,:,:,404),Q(:,121),MB,G3(:,:,:,259))
  call loop_AV_Q(G3(:,:,:,259),wf(:,13),G3(:,:,:,260))
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),MB,G4tensor(:,177))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,16),G3(:,:,:,261),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),MB,G4tensor(:,178))
  call loop_AV_Q(G1(:,:,:,122),wf(:,3),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,57),MB,G2(:,:,:,405))
  call loop_AV_Q(G2(:,:,:,405),wf(:,-6),G2(:,:,:,406))
  call loop_A_Q(G2(:,:,:,406),Q(:,121),MB,G3(:,:,:,262))
  call loop_AV_Q(G3(:,:,:,262),wf(:,13),G3(:,:,:,263))
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),MB,G4tensor(:,179))
  call loop_AZ_Q(G3(:,:,:,262),wf(:,16),G3(:,:,:,264),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,127),MB,G4tensor(:,180))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(17)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,35),T3sum(1:35,1))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,2))
  M(1) = M(1) + (-(f(16)/2._/**/REALKIND) * den(28)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,103),T3sum(1:35,2))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,47),T4sum(1:70,1))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,1),T4sum(1:70,2))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,25),T4sum(1:70,3))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,47),T4sum(1:70,1))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,17),T4sum(1:70,3))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,36),T4sum(1:70,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,50),T4sum(1:70,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,38),T4sum(1:70,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,27),T4sum(1:70,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,52),T4sum(1:70,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,19),T4sum(1:70,3))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,34),T4sum(1:70,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,10),T4sum(1:70,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,48),T4sum(1:70,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,35),T4sum(1:70,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,26),T4sum(1:70,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,49),T4sum(1:70,1))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,18),T4sum(1:70,3))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,37),T4sum(1:70,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,12),T4sum(1:70,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,51),T4sum(1:70,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,39),T4sum(1:70,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,28),T4sum(1:70,3))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,53),T4sum(1:70,1))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,20),T4sum(1:70,3))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,67),T4sum(1:70,5))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,71),T4sum(1:70,4))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,77),T4sum(1:70,5))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,61),T4sum(1:70,4))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,81),T4sum(1:70,6))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,71),T4sum(1:70,4))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,85),T4sum(1:70,6))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,89),T4sum(1:70,4))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,93),T4sum(1:70,5))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,97),T4sum(1:70,4))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,101),T4sum(1:70,5))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,105),T4sum(1:70,4))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,109),T4sum(1:70,6))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,113),T4sum(1:70,4))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,117),T4sum(1:70,6))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,62),T4sum(1:70,4))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,68),T4sum(1:70,5))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,72),T4sum(1:70,4))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,78),T4sum(1:70,5))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,63),T4sum(1:70,4))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,82),T4sum(1:70,6))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,73),T4sum(1:70,4))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,86),T4sum(1:70,6))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,90),T4sum(1:70,4))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,94),T4sum(1:70,5))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,98),T4sum(1:70,4))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,102),T4sum(1:70,5))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,106),T4sum(1:70,4))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,110),T4sum(1:70,6))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,114),T4sum(1:70,4))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,118),T4sum(1:70,6))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,74),T4sum(1:70,7))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,79),T4sum(1:70,8))
  M(1) = M(1) + (f(12)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,69),T4sum(1:70,8))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,74),T4sum(1:70,7))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,87),T4sum(1:70,9))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,64),T4sum(1:70,7))
  M(1) = M(1) + (f(7)/2._/**/REALKIND * den(151)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,83),T4sum(1:70,9))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,99),T4sum(1:70,7))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,103),T4sum(1:70,8))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,91),T4sum(1:70,7))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(152)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,95),T4sum(1:70,8))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,115),T4sum(1:70,7))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,119),T4sum(1:70,9))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,107),T4sum(1:70,7))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(152)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,111),T4sum(1:70,9))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,75),T4sum(1:70,7))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,80),T4sum(1:70,8))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,65),T4sum(1:70,7))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(153)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,70),T4sum(1:70,8))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,76),T4sum(1:70,7))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,88),T4sum(1:70,9))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,66),T4sum(1:70,7))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(153)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,84),T4sum(1:70,9))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,100),T4sum(1:70,7))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,104),T4sum(1:70,8))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,92),T4sum(1:70,7))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,96),T4sum(1:70,8))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,116),T4sum(1:70,7))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,120),T4sum(1:70,9))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,108),T4sum(1:70,7))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(154)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,112),T4sum(1:70,9))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,137),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,36),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,185),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(155)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(155)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,137),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(155)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,104),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(155)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,185),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(155)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,138),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,186),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,139),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,105),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,187),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(156)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,140),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(157)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,188),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(157)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,140),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,106),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,188),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(157)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,141),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,189),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,142),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,107),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,190),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(158)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(159)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,143),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(159)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(159)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,191),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(159)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,143),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,108),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,191),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,144),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,192),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,145),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,109),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,193),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(160)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(161)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,146),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(161)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(161)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,194),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(161)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(161)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,146),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(161)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,110),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(161)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,194),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(161)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,147),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,43),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,195),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,148),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,111),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,196),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(162)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,2))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (f(17)/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,44),T3sum(1:35,1))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,2))
  M(1) = M(1) + (f(16)/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,112),T3sum(1:35,2))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,54),T4sum(1:70,10))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,5),T4sum(1:70,11))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,40),T4sum(1:70,10))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,13),T4sum(1:70,11))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,54),T4sum(1:70,10))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,21),T4sum(1:70,12))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,40),T4sum(1:70,10))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,29),T4sum(1:70,12))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,55),T4sum(1:70,10))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,6),T4sum(1:70,11))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,41),T4sum(1:70,10))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,14),T4sum(1:70,11))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,56),T4sum(1:70,10))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,22),T4sum(1:70,12))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,42),T4sum(1:70,10))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,30),T4sum(1:70,12))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,57),T4sum(1:70,10))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,7),T4sum(1:70,11))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,43),T4sum(1:70,10))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,15),T4sum(1:70,11))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,59),T4sum(1:70,10))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,23),T4sum(1:70,12))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,45),T4sum(1:70,10))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,31),T4sum(1:70,12))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,58),T4sum(1:70,10))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,8),T4sum(1:70,11))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,44),T4sum(1:70,10))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,16),T4sum(1:70,11))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,60),T4sum(1:70,10))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,24),T4sum(1:70,12))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,46),T4sum(1:70,10))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,32),T4sum(1:70,12))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,121),T4sum(1:70,13))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,127),T4sum(1:70,14))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,131),T4sum(1:70,13))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,137),T4sum(1:70,14))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,121),T4sum(1:70,13))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,141),T4sum(1:70,15))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,131),T4sum(1:70,13))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,145),T4sum(1:70,15))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,122),T4sum(1:70,13))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,128),T4sum(1:70,14))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,132),T4sum(1:70,13))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,138),T4sum(1:70,14))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,123),T4sum(1:70,13))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,142),T4sum(1:70,15))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,133),T4sum(1:70,13))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,146),T4sum(1:70,15))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,149),T4sum(1:70,13))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,153),T4sum(1:70,14))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,157),T4sum(1:70,13))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,161),T4sum(1:70,14))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,165),T4sum(1:70,13))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,169),T4sum(1:70,15))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,173),T4sum(1:70,13))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,177),T4sum(1:70,15))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,150),T4sum(1:70,13))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,154),T4sum(1:70,14))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,158),T4sum(1:70,13))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,162),T4sum(1:70,14))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,166),T4sum(1:70,13))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,170),T4sum(1:70,15))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,174),T4sum(1:70,13))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,178),T4sum(1:70,15))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,134),T4sum(1:70,16))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,139),T4sum(1:70,17))
  M(1) = M(1) + (-(f(12)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,124),T4sum(1:70,16))
  M(1) = M(1) + (-(f(10)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,129),T4sum(1:70,17))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,134),T4sum(1:70,16))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,147),T4sum(1:70,18))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,124),T4sum(1:70,16))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(163)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,143),T4sum(1:70,18))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,135),T4sum(1:70,16))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,140),T4sum(1:70,17))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,125),T4sum(1:70,16))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(164)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,130),T4sum(1:70,17))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,136),T4sum(1:70,16))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,148),T4sum(1:70,18))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,126),T4sum(1:70,16))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(164)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,144),T4sum(1:70,18))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,159),T4sum(1:70,16))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,163),T4sum(1:70,17))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,151),T4sum(1:70,16))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(165)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,155),T4sum(1:70,17))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,175),T4sum(1:70,16))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,179),T4sum(1:70,18))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,167),T4sum(1:70,16))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(165)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,171),T4sum(1:70,18))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,160),T4sum(1:70,16))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,164),T4sum(1:70,17))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,152),T4sum(1:70,16))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,156),T4sum(1:70,17))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,176),T4sum(1:70,16))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,180),T4sum(1:70,18))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,168),T4sum(1:70,16))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(166)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,172),T4sum(1:70,18))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,149),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(167)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,45),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,197),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(167)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,149),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,113),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,197),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(167)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,150),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,46),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,198),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,151),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,114),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,199),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(168)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,152),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(169)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,47),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,200),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(169)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,152),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(169)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,115),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,200),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(169)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,153),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,48),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,201),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,154),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,116),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,202),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(170)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,155),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,49),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,203),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(171)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(171)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,155),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(171)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,117),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(171)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,203),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(171)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(172)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,156),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(172)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,50),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(172)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,204),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(172)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(172)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,156),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(172)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,118),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(172)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,204),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(172)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,157),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,51),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,205),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,158),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,119),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,206),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(173)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,159),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,52),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,207),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,160),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,120),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,208),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(174)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,53),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,209),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(175)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(175)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,161),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(175)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,121),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(175)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,209),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(175)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,162),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,54),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,210),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,163),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,122),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,211),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(176)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(177)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(177)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,55),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(177)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,212),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(177)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,164),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,123),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,212),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(177)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,165),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,56),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,213),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,166),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,124),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,214),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(178)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(179)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,167),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(179)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,57),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(179)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,215),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(179)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,167),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,125),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,215),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(179)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,168),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,58),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,216),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,169),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,126),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,217),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(180)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,2))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,170),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,59),T3sum(1:35,1))
  M(1) = M(1) + (f(14)/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,218),T3sum(1:35,3))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(181)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,1))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(181)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,170),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(181)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,127),T3sum(1:35,2))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(181)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,218),T3sum(1:35,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(181)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,93),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,171),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,60),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,219),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,1))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,172),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,128),T3sum(1:35,2))
  M(1) = M(1) + (-(f(15)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,220),T3sum(1:35,3))
  M(1) = M(1) + (-(f(13)/2._/**/REALKIND) * den(182)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,94),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,173),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,61),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,221),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(183)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(183)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,173),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(183)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,129),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(183)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,221),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(183)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,95),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,174),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,62),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,222),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,175),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,130),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,223),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(184)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,96),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,176),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,63),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,224),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(185)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(185)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,176),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(185)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,131),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(185)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,224),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(185)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,97),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,177),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,64),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,225),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,178),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,132),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,226),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(186)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,98),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(187)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,179),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(187)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,65),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(187)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,227),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(187)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(187)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,179),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(187)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,133),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(187)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,227),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(187)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,99),T3sum(1:35,2))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(188)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,180),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(188)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,66),T3sum(1:35,1))
  M(1) = M(1) + (-(f(14)/2._/**/REALKIND) * den(188)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,228),T3sum(1:35,3))
  M(1) = M(1) + (-(f(11)/2._/**/REALKIND) * den(188)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,180),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,134),T3sum(1:35,2))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,228),T3sum(1:35,3))
  M(1) = M(1) + (f(9)/2._/**/REALKIND * den(188)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,100),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,181),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,67),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,229),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,182),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,135),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,230),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(189)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,101),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,183),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,68),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,231),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,1))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,184),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,136),T3sum(1:35,2))
  M(1) = M(1) + (f(15)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,232),T3sum(1:35,3))
  M(1) = M(1) + (f(13)/2._/**/REALKIND * den(190)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,102),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppllllj2_eeexexuuxg_1_/**/REALKIND
