
! **********************************************************************
module ol_tensor_sum_storage_ppllllj2_nenenexnexggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,2)
  complex(REALKIND) :: momenta_2(4,2)
  complex(REALKIND) :: momenta_3(4,2)
  complex(REALKIND) :: momenta_4(4,3)
  complex(REALKIND) :: momenta_5(4,3)
  complex(REALKIND) :: momenta_6(4,3)
  complex(REALKIND) :: momenta_7(4,3)
  complex(REALKIND) :: momenta_8(4,3)
  complex(REALKIND) :: momenta_9(4,3)
  complex(REALKIND) :: momenta_10(4,3)
  complex(REALKIND) :: momenta_11(4,3)
  complex(REALKIND) :: momenta_12(4,3)
  complex(REALKIND) :: momenta_13(4,3)
  complex(REALKIND) :: momenta_14(4,3)
  complex(REALKIND) :: momenta_15(4,3)
  complex(REALKIND) :: momenta_16(4,3)
  complex(REALKIND) :: momenta_17(4,3)
  complex(REALKIND) :: momenta_18(4,3)
  complex(REALKIND) :: momenta_19(4,3)
  complex(REALKIND) :: momenta_20(4,3)
  complex(REALKIND) :: momenta_21(4,3)
  complex(REALKIND) :: momenta_22(4,3)
  complex(REALKIND) :: momenta_23(4,3)
  complex(REALKIND) :: momenta_24(4,3)
  complex(REALKIND) :: momenta_25(4,4)
  complex(REALKIND) :: momenta_26(4,4)
  complex(REALKIND) :: momenta_27(4,4)
  complex(REALKIND) :: momenta_28(4,4)
  complex(REALKIND) :: momenta_29(4,4)
  complex(REALKIND) :: momenta_30(4,4)
  complex(REALKIND) :: momenta_31(4,4)
  complex(REALKIND) :: momenta_32(4,4)
  complex(REALKIND) :: momenta_33(4,4)
  complex(REALKIND) :: momenta_34(4,4)
  complex(REALKIND) :: momenta_35(4,4)
  complex(REALKIND) :: momenta_36(4,4)
  complex(REALKIND) :: momenta_37(4,4)
  complex(REALKIND) :: momenta_38(4,4)
  complex(REALKIND) :: momenta_39(4,4)
  complex(REALKIND) :: momenta_40(4,4)
  complex(REALKIND) :: momenta_41(4,4)
  complex(REALKIND) :: momenta_42(4,4)
  complex(REALKIND) :: momenta_43(4,4)
  complex(REALKIND) :: momenta_44(4,4)
  complex(REALKIND) :: momenta_45(4,4)
  complex(REALKIND) :: momenta_46(4,4)
  complex(REALKIND) :: momenta_47(4,4)
  complex(REALKIND) :: momenta_48(4,4)

  complex(REALKIND), save :: masses2_1(3)
  complex(REALKIND), save :: masses2_2(3)
  complex(REALKIND), save :: masses2_3(3)
  complex(REALKIND), save :: masses2_4(4)
  complex(REALKIND), save :: masses2_5(4)
  complex(REALKIND), save :: masses2_6(4)
  complex(REALKIND), save :: masses2_7(5)
  complex(REALKIND), save :: masses2_8(5)
  complex(REALKIND), save :: masses2_9(5)

  complex(REALKIND), save :: T3sum(35,9) = 0
  complex(REALKIND), save :: T4sum(70,63) = 0
  complex(REALKIND), save :: T5sum(126,72) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppllllj2_nenenexnexggg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppllllj2_nenenexnexggg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T3sum(:,1), -4)
  call scale_one_tsum(T3sum(:,2), -4)
  call scale_one_tsum(T3sum(:,3), -4)
  call scale_one_tsum(T3sum(:,4), -4)
  call scale_one_tsum(T3sum(:,5), -4)
  call scale_one_tsum(T3sum(:,6), -4)
  call scale_one_tsum(T3sum(:,7), -4)
  call scale_one_tsum(T3sum(:,8), -4)
  call scale_one_tsum(T3sum(:,9), -4)
  call scale_one_tsum(T4sum(:,1), -2)
  call scale_one_tsum(T4sum(:,2), -2)
  call scale_one_tsum(T4sum(:,3), -2)
  call scale_one_tsum(T4sum(:,4), -2)
  call scale_one_tsum(T4sum(:,5), -2)
  call scale_one_tsum(T4sum(:,6), -2)
  call scale_one_tsum(T4sum(:,7), -2)
  call scale_one_tsum(T4sum(:,8), -2)
  call scale_one_tsum(T4sum(:,9), -2)
  call scale_one_tsum(T4sum(:,10), -2)
  call scale_one_tsum(T4sum(:,11), -2)
  call scale_one_tsum(T4sum(:,12), -2)
  call scale_one_tsum(T4sum(:,13), -2)
  call scale_one_tsum(T4sum(:,14), -2)
  call scale_one_tsum(T4sum(:,15), -2)
  call scale_one_tsum(T4sum(:,16), -2)
  call scale_one_tsum(T4sum(:,17), -2)
  call scale_one_tsum(T4sum(:,18), -2)
  call scale_one_tsum(T4sum(:,19), -2)
  call scale_one_tsum(T4sum(:,20), -2)
  call scale_one_tsum(T4sum(:,21), -2)
  call scale_one_tsum(T4sum(:,22), -2)
  call scale_one_tsum(T4sum(:,23), -2)
  call scale_one_tsum(T4sum(:,24), -2)
  call scale_one_tsum(T4sum(:,25), -2)
  call scale_one_tsum(T4sum(:,26), -2)
  call scale_one_tsum(T4sum(:,27), -2)
  call scale_one_tsum(T4sum(:,28), -2)
  call scale_one_tsum(T4sum(:,29), -2)
  call scale_one_tsum(T4sum(:,30), -2)
  call scale_one_tsum(T4sum(:,31), -2)
  call scale_one_tsum(T4sum(:,32), -2)
  call scale_one_tsum(T4sum(:,33), -2)
  call scale_one_tsum(T4sum(:,34), -2)
  call scale_one_tsum(T4sum(:,35), -2)
  call scale_one_tsum(T4sum(:,36), -2)
  call scale_one_tsum(T4sum(:,37), -2)
  call scale_one_tsum(T4sum(:,38), -2)
  call scale_one_tsum(T4sum(:,39), -2)
  call scale_one_tsum(T4sum(:,40), -2)
  call scale_one_tsum(T4sum(:,41), -2)
  call scale_one_tsum(T4sum(:,42), -2)
  call scale_one_tsum(T4sum(:,43), -2)
  call scale_one_tsum(T4sum(:,44), -2)
  call scale_one_tsum(T4sum(:,45), -2)
  call scale_one_tsum(T4sum(:,46), -2)
  call scale_one_tsum(T4sum(:,47), -2)
  call scale_one_tsum(T4sum(:,48), -2)
  call scale_one_tsum(T4sum(:,49), -2)
  call scale_one_tsum(T4sum(:,50), -2)
  call scale_one_tsum(T4sum(:,51), -2)
  call scale_one_tsum(T4sum(:,52), -2)
  call scale_one_tsum(T4sum(:,53), -2)
  call scale_one_tsum(T4sum(:,54), -2)
  call scale_one_tsum(T4sum(:,55), -2)
  call scale_one_tsum(T4sum(:,56), -2)
  call scale_one_tsum(T4sum(:,57), -2)
  call scale_one_tsum(T4sum(:,58), -2)
  call scale_one_tsum(T4sum(:,59), -2)
  call scale_one_tsum(T4sum(:,60), -2)
  call scale_one_tsum(T4sum(:,61), -2)
  call scale_one_tsum(T4sum(:,62), -2)
  call scale_one_tsum(T4sum(:,63), -2)
  call scale_one_tsum(T5sum(:,1), 0)
  call scale_one_tsum(T5sum(:,2), 0)
  call scale_one_tsum(T5sum(:,3), 0)
  call scale_one_tsum(T5sum(:,4), 0)
  call scale_one_tsum(T5sum(:,5), 0)
  call scale_one_tsum(T5sum(:,6), 0)
  call scale_one_tsum(T5sum(:,7), 0)
  call scale_one_tsum(T5sum(:,8), 0)
  call scale_one_tsum(T5sum(:,9), 0)
  call scale_one_tsum(T5sum(:,10), 0)
  call scale_one_tsum(T5sum(:,11), 0)
  call scale_one_tsum(T5sum(:,12), 0)
  call scale_one_tsum(T5sum(:,13), 0)
  call scale_one_tsum(T5sum(:,14), 0)
  call scale_one_tsum(T5sum(:,15), 0)
  call scale_one_tsum(T5sum(:,16), 0)
  call scale_one_tsum(T5sum(:,17), 0)
  call scale_one_tsum(T5sum(:,18), 0)
  call scale_one_tsum(T5sum(:,19), 0)
  call scale_one_tsum(T5sum(:,20), 0)
  call scale_one_tsum(T5sum(:,21), 0)
  call scale_one_tsum(T5sum(:,22), 0)
  call scale_one_tsum(T5sum(:,23), 0)
  call scale_one_tsum(T5sum(:,24), 0)
  call scale_one_tsum(T5sum(:,25), 0)
  call scale_one_tsum(T5sum(:,26), 0)
  call scale_one_tsum(T5sum(:,27), 0)
  call scale_one_tsum(T5sum(:,28), 0)
  call scale_one_tsum(T5sum(:,29), 0)
  call scale_one_tsum(T5sum(:,30), 0)
  call scale_one_tsum(T5sum(:,31), 0)
  call scale_one_tsum(T5sum(:,32), 0)
  call scale_one_tsum(T5sum(:,33), 0)
  call scale_one_tsum(T5sum(:,34), 0)
  call scale_one_tsum(T5sum(:,35), 0)
  call scale_one_tsum(T5sum(:,36), 0)
  call scale_one_tsum(T5sum(:,37), 0)
  call scale_one_tsum(T5sum(:,38), 0)
  call scale_one_tsum(T5sum(:,39), 0)
  call scale_one_tsum(T5sum(:,40), 0)
  call scale_one_tsum(T5sum(:,41), 0)
  call scale_one_tsum(T5sum(:,42), 0)
  call scale_one_tsum(T5sum(:,43), 0)
  call scale_one_tsum(T5sum(:,44), 0)
  call scale_one_tsum(T5sum(:,45), 0)
  call scale_one_tsum(T5sum(:,46), 0)
  call scale_one_tsum(T5sum(:,47), 0)
  call scale_one_tsum(T5sum(:,48), 0)
  call scale_one_tsum(T5sum(:,49), 0)
  call scale_one_tsum(T5sum(:,50), 0)
  call scale_one_tsum(T5sum(:,51), 0)
  call scale_one_tsum(T5sum(:,52), 0)
  call scale_one_tsum(T5sum(:,53), 0)
  call scale_one_tsum(T5sum(:,54), 0)
  call scale_one_tsum(T5sum(:,55), 0)
  call scale_one_tsum(T5sum(:,56), 0)
  call scale_one_tsum(T5sum(:,57), 0)
  call scale_one_tsum(T5sum(:,58), 0)
  call scale_one_tsum(T5sum(:,59), 0)
  call scale_one_tsum(T5sum(:,60), 0)
  call scale_one_tsum(T5sum(:,61), 0)
  call scale_one_tsum(T5sum(:,62), 0)
  call scale_one_tsum(T5sum(:,63), 0)
  call scale_one_tsum(T5sum(:,64), 0)
  call scale_one_tsum(T5sum(:,65), 0)
  call scale_one_tsum(T5sum(:,66), 0)
  call scale_one_tsum(T5sum(:,67), 0)
  call scale_one_tsum(T5sum(:,68), 0)
  call scale_one_tsum(T5sum(:,69), 0)
  call scale_one_tsum(T5sum(:,70), 0)
  call scale_one_tsum(T5sum(:,71), 0)
  call scale_one_tsum(T5sum(:,72), 0)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_ppllllj2_nenenexnexggg_1, only: channel_number_ppllllj2_nenenexnexggg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on, channel_off
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_ppllllj2_nenenexnexggg_1)
  M2 = 0

  momenta_1(:,1) = Q(1:4,16)
  momenta_1(:,2) = Q(1:4,112)
  momenta_2(:,1) = Q(1:4,32)
  momenta_2(:,2) = Q(1:4,112)
  momenta_3(:,1) = Q(1:4,48)
  momenta_3(:,2) = Q(1:4,112)
  momenta_4(:,1) = Q(1:4,9)
  momenta_4(:,2) = Q(1:4,25)
  momenta_4(:,3) = Q(1:4,121)
  momenta_5(:,1) = Q(1:4,9)
  momenta_5(:,2) = Q(1:4,41)
  momenta_5(:,3) = Q(1:4,121)
  momenta_6(:,1) = Q(1:4,9)
  momenta_6(:,2) = Q(1:4,57)
  momenta_6(:,3) = Q(1:4,121)
  momenta_7(:,1) = Q(1:4,9)
  momenta_7(:,2) = Q(1:4,73)
  momenta_7(:,3) = Q(1:4,121)
  momenta_8(:,1) = Q(1:4,9)
  momenta_8(:,2) = Q(1:4,89)
  momenta_8(:,3) = Q(1:4,121)
  momenta_9(:,1) = Q(1:4,9)
  momenta_9(:,2) = Q(1:4,105)
  momenta_9(:,3) = Q(1:4,121)
  momenta_10(:,1) = Q(1:4,10)
  momenta_10(:,2) = Q(1:4,26)
  momenta_10(:,3) = Q(1:4,122)
  momenta_11(:,1) = Q(1:4,10)
  momenta_11(:,2) = Q(1:4,42)
  momenta_11(:,3) = Q(1:4,122)
  momenta_12(:,1) = Q(1:4,10)
  momenta_12(:,2) = Q(1:4,58)
  momenta_12(:,3) = Q(1:4,122)
  momenta_13(:,1) = Q(1:4,10)
  momenta_13(:,2) = Q(1:4,74)
  momenta_13(:,3) = Q(1:4,122)
  momenta_14(:,1) = Q(1:4,10)
  momenta_14(:,2) = Q(1:4,90)
  momenta_14(:,3) = Q(1:4,122)
  momenta_15(:,1) = Q(1:4,10)
  momenta_15(:,2) = Q(1:4,106)
  momenta_15(:,3) = Q(1:4,122)
  momenta_16(:,1) = Q(1:4,16)
  momenta_16(:,2) = Q(1:4,25)
  momenta_16(:,3) = Q(1:4,121)
  momenta_17(:,1) = Q(1:4,16)
  momenta_17(:,2) = Q(1:4,26)
  momenta_17(:,3) = Q(1:4,122)
  momenta_18(:,1) = Q(1:4,16)
  momenta_18(:,2) = Q(1:4,48)
  momenta_18(:,3) = Q(1:4,112)
  momenta_19(:,1) = Q(1:4,16)
  momenta_19(:,2) = Q(1:4,80)
  momenta_19(:,3) = Q(1:4,112)
  momenta_20(:,1) = Q(1:4,32)
  momenta_20(:,2) = Q(1:4,41)
  momenta_20(:,3) = Q(1:4,121)
  momenta_21(:,1) = Q(1:4,32)
  momenta_21(:,2) = Q(1:4,42)
  momenta_21(:,3) = Q(1:4,122)
  momenta_22(:,1) = Q(1:4,32)
  momenta_22(:,2) = Q(1:4,48)
  momenta_22(:,3) = Q(1:4,112)
  momenta_23(:,1) = Q(1:4,48)
  momenta_23(:,2) = Q(1:4,57)
  momenta_23(:,3) = Q(1:4,121)
  momenta_24(:,1) = Q(1:4,48)
  momenta_24(:,2) = Q(1:4,58)
  momenta_24(:,3) = Q(1:4,122)
  momenta_25(:,1) = Q(1:4,9)
  momenta_25(:,2) = Q(1:4,25)
  momenta_25(:,3) = Q(1:4,57)
  momenta_25(:,4) = Q(1:4,121)
  momenta_26(:,1) = Q(1:4,9)
  momenta_26(:,2) = Q(1:4,25)
  momenta_26(:,3) = Q(1:4,89)
  momenta_26(:,4) = Q(1:4,121)
  momenta_27(:,1) = Q(1:4,9)
  momenta_27(:,2) = Q(1:4,41)
  momenta_27(:,3) = Q(1:4,57)
  momenta_27(:,4) = Q(1:4,121)
  momenta_28(:,1) = Q(1:4,9)
  momenta_28(:,2) = Q(1:4,41)
  momenta_28(:,3) = Q(1:4,105)
  momenta_28(:,4) = Q(1:4,121)
  momenta_29(:,1) = Q(1:4,9)
  momenta_29(:,2) = Q(1:4,73)
  momenta_29(:,3) = Q(1:4,89)
  momenta_29(:,4) = Q(1:4,121)
  momenta_30(:,1) = Q(1:4,9)
  momenta_30(:,2) = Q(1:4,73)
  momenta_30(:,3) = Q(1:4,105)
  momenta_30(:,4) = Q(1:4,121)
  momenta_31(:,1) = Q(1:4,10)
  momenta_31(:,2) = Q(1:4,26)
  momenta_31(:,3) = Q(1:4,58)
  momenta_31(:,4) = Q(1:4,122)
  momenta_32(:,1) = Q(1:4,10)
  momenta_32(:,2) = Q(1:4,26)
  momenta_32(:,3) = Q(1:4,90)
  momenta_32(:,4) = Q(1:4,122)
  momenta_33(:,1) = Q(1:4,10)
  momenta_33(:,2) = Q(1:4,42)
  momenta_33(:,3) = Q(1:4,58)
  momenta_33(:,4) = Q(1:4,122)
  momenta_34(:,1) = Q(1:4,10)
  momenta_34(:,2) = Q(1:4,42)
  momenta_34(:,3) = Q(1:4,106)
  momenta_34(:,4) = Q(1:4,122)
  momenta_35(:,1) = Q(1:4,10)
  momenta_35(:,2) = Q(1:4,74)
  momenta_35(:,3) = Q(1:4,90)
  momenta_35(:,4) = Q(1:4,122)
  momenta_36(:,1) = Q(1:4,10)
  momenta_36(:,2) = Q(1:4,74)
  momenta_36(:,3) = Q(1:4,106)
  momenta_36(:,4) = Q(1:4,122)
  momenta_37(:,1) = Q(1:4,16)
  momenta_37(:,2) = Q(1:4,25)
  momenta_37(:,3) = Q(1:4,57)
  momenta_37(:,4) = Q(1:4,121)
  momenta_38(:,1) = Q(1:4,16)
  momenta_38(:,2) = Q(1:4,25)
  momenta_38(:,3) = Q(1:4,89)
  momenta_38(:,4) = Q(1:4,121)
  momenta_39(:,1) = Q(1:4,16)
  momenta_39(:,2) = Q(1:4,26)
  momenta_39(:,3) = Q(1:4,58)
  momenta_39(:,4) = Q(1:4,122)
  momenta_40(:,1) = Q(1:4,16)
  momenta_40(:,2) = Q(1:4,26)
  momenta_40(:,3) = Q(1:4,90)
  momenta_40(:,4) = Q(1:4,122)
  momenta_41(:,1) = Q(1:4,16)
  momenta_41(:,2) = Q(1:4,48)
  momenta_41(:,3) = Q(1:4,57)
  momenta_41(:,4) = Q(1:4,121)
  momenta_42(:,1) = Q(1:4,16)
  momenta_42(:,2) = Q(1:4,48)
  momenta_42(:,3) = Q(1:4,58)
  momenta_42(:,4) = Q(1:4,122)
  momenta_43(:,1) = Q(1:4,16)
  momenta_43(:,2) = Q(1:4,80)
  momenta_43(:,3) = Q(1:4,89)
  momenta_43(:,4) = Q(1:4,121)
  momenta_44(:,1) = Q(1:4,16)
  momenta_44(:,2) = Q(1:4,80)
  momenta_44(:,3) = Q(1:4,90)
  momenta_44(:,4) = Q(1:4,122)
  momenta_45(:,1) = Q(1:4,32)
  momenta_45(:,2) = Q(1:4,41)
  momenta_45(:,3) = Q(1:4,57)
  momenta_45(:,4) = Q(1:4,121)
  momenta_46(:,1) = Q(1:4,32)
  momenta_46(:,2) = Q(1:4,42)
  momenta_46(:,3) = Q(1:4,58)
  momenta_46(:,4) = Q(1:4,122)
  momenta_47(:,1) = Q(1:4,32)
  momenta_47(:,2) = Q(1:4,48)
  momenta_47(:,3) = Q(1:4,57)
  momenta_47(:,4) = Q(1:4,121)
  momenta_48(:,1) = Q(1:4,32)
  momenta_48(:,2) = Q(1:4,48)
  momenta_48(:,3) = Q(1:4,58)
  momenta_48(:,4) = Q(1:4,122)

  masses2_1 = [ MB2, MB2, MB2 ]
  masses2_2 = [ MT2, MT2, MT2 ]
  masses2_3 = [ ZERO2, ZERO2, ZERO2 ]
  masses2_4 = [ MB2, MB2, MB2, MB2 ]
  masses2_5 = [ MT2, MT2, MT2, MT2 ]
  masses2_6 = [ ZERO2, ZERO2, ZERO2, ZERO2 ]
  masses2_7 = [ MB2, MB2, MB2, MB2, MB2 ]
  masses2_8 = [ MT2, MT2, MT2, MT2, MT2 ]
  masses2_9 = [ ZERO2, ZERO2, ZERO2, ZERO2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call tensor_integral(3, momenta_3, masses2_2, T3sum(:,1))
  call tensor_integral(3, momenta_3, masses2_1, T3sum(:,2))
  call tensor_integral(3, momenta_2, masses2_2, T3sum(:,3))
  call tensor_integral(3, momenta_2, masses2_1, T3sum(:,4))
  call tensor_integral(3, momenta_1, masses2_2, T3sum(:,5))
  call tensor_integral(3, momenta_1, masses2_1, T3sum(:,6))
  call tensor_integral(3, momenta_3, masses2_3, T3sum(:,7))
  call tensor_integral(3, momenta_2, masses2_3, T3sum(:,8))
  call tensor_integral(3, momenta_1, masses2_3, T3sum(:,9))

  call tensor_integral(4, momenta_24, masses2_6, T4sum(:,1))
  call tensor_integral(4, momenta_24, masses2_5, T4sum(:,2))
  call tensor_integral(4, momenta_24, masses2_4, T4sum(:,3))
  call tensor_integral(4, momenta_12, masses2_6, T4sum(:,4))
  call tensor_integral(4, momenta_12, masses2_5, T4sum(:,5))
  call tensor_integral(4, momenta_12, masses2_4, T4sum(:,6))
  call tensor_integral(4, momenta_13, masses2_6, T4sum(:,7))
  call tensor_integral(4, momenta_13, masses2_5, T4sum(:,8))
  call tensor_integral(4, momenta_13, masses2_4, T4sum(:,9))
  call tensor_integral(4, momenta_21, masses2_6, T4sum(:,10))
  call tensor_integral(4, momenta_21, masses2_5, T4sum(:,11))
  call tensor_integral(4, momenta_21, masses2_4, T4sum(:,12))
  call tensor_integral(4, momenta_14, masses2_6, T4sum(:,13))
  call tensor_integral(4, momenta_14, masses2_5, T4sum(:,14))
  call tensor_integral(4, momenta_14, masses2_4, T4sum(:,15))
  call tensor_integral(4, momenta_11, masses2_6, T4sum(:,16))
  call tensor_integral(4, momenta_11, masses2_5, T4sum(:,17))
  call tensor_integral(4, momenta_11, masses2_4, T4sum(:,18))
  call tensor_integral(4, momenta_17, masses2_6, T4sum(:,19))
  call tensor_integral(4, momenta_17, masses2_5, T4sum(:,20))
  call tensor_integral(4, momenta_17, masses2_4, T4sum(:,21))
  call tensor_integral(4, momenta_15, masses2_6, T4sum(:,22))
  call tensor_integral(4, momenta_15, masses2_5, T4sum(:,23))
  call tensor_integral(4, momenta_15, masses2_4, T4sum(:,24))
  call tensor_integral(4, momenta_10, masses2_6, T4sum(:,25))
  call tensor_integral(4, momenta_10, masses2_5, T4sum(:,26))
  call tensor_integral(4, momenta_10, masses2_4, T4sum(:,27))
  call tensor_integral(4, momenta_22, masses2_5, T4sum(:,28))
  call tensor_integral(4, momenta_22, masses2_4, T4sum(:,29))
  call tensor_integral(4, momenta_18, masses2_5, T4sum(:,30))
  call tensor_integral(4, momenta_18, masses2_4, T4sum(:,31))
  call tensor_integral(4, momenta_19, masses2_5, T4sum(:,32))
  call tensor_integral(4, momenta_19, masses2_4, T4sum(:,33))
  call tensor_integral(4, momenta_22, masses2_6, T4sum(:,34))
  call tensor_integral(4, momenta_18, masses2_6, T4sum(:,35))
  call tensor_integral(4, momenta_19, masses2_6, T4sum(:,36))
  call tensor_integral(4, momenta_23, masses2_6, T4sum(:,37))
  call tensor_integral(4, momenta_23, masses2_5, T4sum(:,38))
  call tensor_integral(4, momenta_23, masses2_4, T4sum(:,39))
  call tensor_integral(4, momenta_7, masses2_6, T4sum(:,40))
  call tensor_integral(4, momenta_7, masses2_5, T4sum(:,41))
  call tensor_integral(4, momenta_7, masses2_4, T4sum(:,42))
  call tensor_integral(4, momenta_6, masses2_6, T4sum(:,43))
  call tensor_integral(4, momenta_6, masses2_5, T4sum(:,44))
  call tensor_integral(4, momenta_6, masses2_4, T4sum(:,45))
  call tensor_integral(4, momenta_20, masses2_6, T4sum(:,46))
  call tensor_integral(4, momenta_20, masses2_5, T4sum(:,47))
  call tensor_integral(4, momenta_20, masses2_4, T4sum(:,48))
  call tensor_integral(4, momenta_5, masses2_6, T4sum(:,49))
  call tensor_integral(4, momenta_5, masses2_5, T4sum(:,50))
  call tensor_integral(4, momenta_5, masses2_4, T4sum(:,51))
  call tensor_integral(4, momenta_8, masses2_6, T4sum(:,52))
  call tensor_integral(4, momenta_8, masses2_5, T4sum(:,53))
  call tensor_integral(4, momenta_8, masses2_4, T4sum(:,54))
  call tensor_integral(4, momenta_16, masses2_6, T4sum(:,55))
  call tensor_integral(4, momenta_16, masses2_5, T4sum(:,56))
  call tensor_integral(4, momenta_16, masses2_4, T4sum(:,57))
  call tensor_integral(4, momenta_4, masses2_6, T4sum(:,58))
  call tensor_integral(4, momenta_4, masses2_5, T4sum(:,59))
  call tensor_integral(4, momenta_4, masses2_4, T4sum(:,60))
  call tensor_integral(4, momenta_9, masses2_6, T4sum(:,61))
  call tensor_integral(4, momenta_9, masses2_5, T4sum(:,62))
  call tensor_integral(4, momenta_9, masses2_4, T4sum(:,63))

  call tensor_integral(5, momenta_35, masses2_9, T5sum(:,1))
  call tensor_integral(5, momenta_35, masses2_8, T5sum(:,2))
  call tensor_integral(5, momenta_35, masses2_7, T5sum(:,3))
  call tensor_integral(5, momenta_33, masses2_9, T5sum(:,4))
  call tensor_integral(5, momenta_33, masses2_8, T5sum(:,5))
  call tensor_integral(5, momenta_33, masses2_7, T5sum(:,6))
  call tensor_integral(5, momenta_36, masses2_9, T5sum(:,7))
  call tensor_integral(5, momenta_36, masses2_8, T5sum(:,8))
  call tensor_integral(5, momenta_36, masses2_7, T5sum(:,9))
  call tensor_integral(5, momenta_42, masses2_9, T5sum(:,10))
  call tensor_integral(5, momenta_42, masses2_8, T5sum(:,11))
  call tensor_integral(5, momenta_42, masses2_7, T5sum(:,12))
  call tensor_integral(5, momenta_31, masses2_9, T5sum(:,13))
  call tensor_integral(5, momenta_31, masses2_8, T5sum(:,14))
  call tensor_integral(5, momenta_31, masses2_7, T5sum(:,15))
  call tensor_integral(5, momenta_48, masses2_9, T5sum(:,16))
  call tensor_integral(5, momenta_48, masses2_8, T5sum(:,17))
  call tensor_integral(5, momenta_48, masses2_7, T5sum(:,18))
  call tensor_integral(5, momenta_34, masses2_9, T5sum(:,19))
  call tensor_integral(5, momenta_34, masses2_8, T5sum(:,20))
  call tensor_integral(5, momenta_34, masses2_7, T5sum(:,21))
  call tensor_integral(5, momenta_44, masses2_9, T5sum(:,22))
  call tensor_integral(5, momenta_44, masses2_8, T5sum(:,23))
  call tensor_integral(5, momenta_44, masses2_7, T5sum(:,24))
  call tensor_integral(5, momenta_32, masses2_9, T5sum(:,25))
  call tensor_integral(5, momenta_32, masses2_8, T5sum(:,26))
  call tensor_integral(5, momenta_32, masses2_7, T5sum(:,27))
  call tensor_integral(5, momenta_46, masses2_9, T5sum(:,28))
  call tensor_integral(5, momenta_46, masses2_8, T5sum(:,29))
  call tensor_integral(5, momenta_46, masses2_7, T5sum(:,30))
  call tensor_integral(5, momenta_40, masses2_9, T5sum(:,31))
  call tensor_integral(5, momenta_40, masses2_8, T5sum(:,32))
  call tensor_integral(5, momenta_40, masses2_7, T5sum(:,33))
  call tensor_integral(5, momenta_39, masses2_9, T5sum(:,34))
  call tensor_integral(5, momenta_39, masses2_8, T5sum(:,35))
  call tensor_integral(5, momenta_39, masses2_7, T5sum(:,36))
  call tensor_integral(5, momenta_27, masses2_9, T5sum(:,37))
  call tensor_integral(5, momenta_27, masses2_8, T5sum(:,38))
  call tensor_integral(5, momenta_27, masses2_7, T5sum(:,39))
  call tensor_integral(5, momenta_29, masses2_9, T5sum(:,40))
  call tensor_integral(5, momenta_29, masses2_8, T5sum(:,41))
  call tensor_integral(5, momenta_29, masses2_7, T5sum(:,42))
  call tensor_integral(5, momenta_25, masses2_9, T5sum(:,43))
  call tensor_integral(5, momenta_25, masses2_8, T5sum(:,44))
  call tensor_integral(5, momenta_25, masses2_7, T5sum(:,45))
  call tensor_integral(5, momenta_47, masses2_9, T5sum(:,46))
  call tensor_integral(5, momenta_47, masses2_8, T5sum(:,47))
  call tensor_integral(5, momenta_47, masses2_7, T5sum(:,48))
  call tensor_integral(5, momenta_30, masses2_9, T5sum(:,49))
  call tensor_integral(5, momenta_30, masses2_8, T5sum(:,50))
  call tensor_integral(5, momenta_30, masses2_7, T5sum(:,51))
  call tensor_integral(5, momenta_41, masses2_9, T5sum(:,52))
  call tensor_integral(5, momenta_41, masses2_8, T5sum(:,53))
  call tensor_integral(5, momenta_41, masses2_7, T5sum(:,54))
  call tensor_integral(5, momenta_26, masses2_9, T5sum(:,55))
  call tensor_integral(5, momenta_26, masses2_8, T5sum(:,56))
  call tensor_integral(5, momenta_26, masses2_7, T5sum(:,57))
  call tensor_integral(5, momenta_45, masses2_9, T5sum(:,58))
  call tensor_integral(5, momenta_45, masses2_8, T5sum(:,59))
  call tensor_integral(5, momenta_45, masses2_7, T5sum(:,60))
  call tensor_integral(5, momenta_28, masses2_9, T5sum(:,61))
  call tensor_integral(5, momenta_28, masses2_8, T5sum(:,62))
  call tensor_integral(5, momenta_28, masses2_7, T5sum(:,63))
  call tensor_integral(5, momenta_43, masses2_9, T5sum(:,64))
  call tensor_integral(5, momenta_43, masses2_8, T5sum(:,65))
  call tensor_integral(5, momenta_43, masses2_7, T5sum(:,66))
  call tensor_integral(5, momenta_37, masses2_9, T5sum(:,67))
  call tensor_integral(5, momenta_37, masses2_8, T5sum(:,68))
  call tensor_integral(5, momenta_37, masses2_7, T5sum(:,69))
  call tensor_integral(5, momenta_38, masses2_9, T5sum(:,70))
  call tensor_integral(5, momenta_38, masses2_8, T5sum(:,71))
  call tensor_integral(5, momenta_38, masses2_7, T5sum(:,72))

#ifdef LOOPSQUARED
  end if
#endif

  call channel_off(channel_number_ppllllj2_nenenexnexggg_1)
end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppllllj2_nenenexnexggg_1_/**/REALKIND
