
module ol_vamp_1_ppllll2_nenexnmnmxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nenexnmnmxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nenexnmnmxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nenexnmnmxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nenexnmnmxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,15) :: G0
  complex(REALKIND), dimension(4,5,4,44) :: G1
  complex(REALKIND), dimension(4,15,4,90) :: G2
  complex(REALKIND), dimension(4,35,4,48) :: G3
  complex(REALKIND), dimension(35,36) :: G3tensor
  complex(REALKIND), dimension(70,24) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,26),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,28),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,31),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,28),MT,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-5),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,60),MT,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,-5),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,48),MT,G2(:,:,:,9))
  call loop_QS_A(G2(:,:,:,9),wf(:,7),G2(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,6))
  call loop_QZ_A(G2(:,:,:,9),wf(:,23),G2(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,9),wf(:,26),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,9),wf(:,28),G2(:,:,:,13),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,9),wf(:,31),G2(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,10))
  call loop_QZ_A(G1(:,:,:,4),wf(:,4),G1(:,:,:,6),gZu)
  call loop_Q_A(G1(:,:,:,6),Q(:,28),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_Q_A(G2(:,:,:,16),Q(:,60),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,3),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-5),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,48),MB,G2(:,:,:,17))
  call loop_AS_Q(G2(:,:,:,17),wf(:,7),G2(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MB,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,17),wf(:,23),G2(:,:,:,19),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,63),MB,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,17),wf(:,26),G2(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,17),wf(:,28),G2(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,63),MB,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,17),wf(:,31),G2(:,:,:,22),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,4),G1(:,:,:,9),gZd)
  call loop_A_Q(G1(:,:,:,9),Q(:,28),MB,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-5),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,60),MB,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,3),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-5),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,48),MB,G2(:,:,:,25))
  call loop_QS_A(G2(:,:,:,25),wf(:,7),G2(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,25),wf(:,23),G2(:,:,:,27),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,25),wf(:,26),G2(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,25),wf(:,28),G2(:,:,:,29),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,63),MB,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,25),wf(:,31),G2(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,20))
  call loop_QZ_A(G1(:,:,:,10),wf(:,4),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,28),MB,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,60),MB,G3(:,:,:,7))
  call loop_QZ_A(G3(:,:,:,7),wf(:,3),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,6),gZu)
  call loop_Q_A(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,44),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,60),ZERO,G3(:,:,:,9))
  call loop_QZ_A(G3(:,:,:,9),wf(:,3),G3(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,28),ZERO,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,60),ZERO,G3(:,:,:,11))
  call loop_QZ_A(G3(:,:,:,11),wf(:,3),G3(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),ZERO,G4tensor(:,6))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,7),gZu)
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MT,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,-5),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,44),MT,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,60),MT,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,3),G3(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,16),wf(:,-4),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,28),MT,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,-5),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,60),MT,G3(:,:,:,15))
  call loop_QZ_A(G3(:,:,:,15),wf(:,3),G3(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,44),ZERO,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-4),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,60),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,3),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,28),ZERO,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,60),ZERO,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,3),G3(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,10))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,22))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,44),MT,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,60),MT,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,3),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,22),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,28),MT,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,60),MT,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,3),G3(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,10),gZd)
  call loop_Q_A(G0(:,:,:,10),Q(:,12),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,44),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,60),ZERO,G3(:,:,:,25))
  call loop_QZ_A(G3(:,:,:,25),wf(:,3),G3(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,28),ZERO,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,60),ZERO,G3(:,:,:,27))
  call loop_QZ_A(G3(:,:,:,27),wf(:,3),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,14))
  call loop_QZ_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,11),gZd)
  call loop_Q_A(G0(:,:,:,11),Q(:,12),MB,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,-5),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,44),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,60),MB,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,3),G3(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,28),wf(:,-4),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,28),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,60),MB,G3(:,:,:,31))
  call loop_QZ_A(G3(:,:,:,31),wf(:,3),G3(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,12),ZERO,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,44),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,60),ZERO,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,3),G3(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,28),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,60),ZERO,G3(:,:,:,35))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,3),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,12),MB,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,44),MB,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,60),MB,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,3),G3(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-4),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,28),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,60),MB,G3(:,:,:,39))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,3),G3(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,16),ZERO,G1(:,:,:,37))
  call loop_QZ_A(G1(:,:,:,37),wf(:,4),G1(:,:,:,38),gZu)
  call loop_Q_A(G1(:,:,:,38),Q(:,28),ZERO,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,60),ZERO,G3(:,:,:,41))
  call loop_QZ_A(G3(:,:,:,41),wf(:,3),G3(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,63),ZERO,G4tensor(:,21))
  call loop_QZ_A(G1(:,:,:,37),wf(:,4),G1(:,:,:,39),gZd)
  call loop_Q_A(G1(:,:,:,39),Q(:,28),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-5),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,60),ZERO,G3(:,:,:,43))
  call loop_QZ_A(G3(:,:,:,43),wf(:,3),G3(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),ZERO,G4tensor(:,22))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,48),ZERO,G2(:,:,:,69))
  call loop_QZ_A(G2(:,:,:,69),wf(:,23),G2(:,:,:,70),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),ZERO,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,69),wf(:,23),G2(:,:,:,71),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),ZERO,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,69),wf(:,26),G2(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),ZERO,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,69),wf(:,26),G2(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),ZERO,G3tensor(:,24))
  call loop_QZ_A(G2(:,:,:,69),wf(:,28),G2(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),ZERO,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,69),wf(:,28),G2(:,:,:,75),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),ZERO,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,69),wf(:,31),G2(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),ZERO,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,69),wf(:,31),G2(:,:,:,77),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,63),ZERO,G3tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,16),ZERO,G1(:,:,:,41))
  call loop_AZ_Q(G1(:,:,:,41),wf(:,4),G1(:,:,:,42),gZu)
  call loop_A_Q(G1(:,:,:,42),Q(:,28),ZERO,G2(:,:,:,78))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-5),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,60),ZERO,G3(:,:,:,45))
  call loop_AZ_Q(G3(:,:,:,45),wf(:,3),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G1(:,:,:,41),wf(:,4),G1(:,:,:,43),gZd)
  call loop_A_Q(G1(:,:,:,43),Q(:,28),ZERO,G2(:,:,:,80))
  call loop_AV_Q(G2(:,:,:,80),wf(:,-5),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,60),ZERO,G3(:,:,:,47))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,3),G3(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,63),ZERO,G4tensor(:,24))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-5),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,48),ZERO,G2(:,:,:,82))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,23),G2(:,:,:,83),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,63),ZERO,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,23),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,26),G2(:,:,:,85),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,85),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,26),G2(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,28),G2(:,:,:,87),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,63),ZERO,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,28),G2(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,31),G2(:,:,:,89),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,89),Q(:,63),ZERO,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,82),wf(:,31),G2(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,36))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(7) * den(20)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (f(6) * den(20)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,5),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,7),T4sum(1:70,2))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,15),T4sum(1:70,3))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,17),T4sum(1:70,1))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,19),T4sum(1:70,3))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,10),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,12),T4sum(1:70,5))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,6),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,8),T4sum(1:70,5))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,18),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,20),T4sum(1:70,6))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,14),T4sum(1:70,4))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,16),T4sum(1:70,6))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,21),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,2),T4sum(1:70,8))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,1),T4sum(1:70,8))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,22),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,4),T4sum(1:70,9))
  M(1) = M(1) + (-f(5) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,24),T4sum(1:70,7))
  M(1) = M(1) + (-f(4) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,3),T4sum(1:70,9))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(25)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(25)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(25)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(25)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(29)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(29)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-f(5) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(29)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (-f(5) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,3))
  M(1) = M(1) + (-f(4) * den(29)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,2))

end subroutine vamp_1

end module ol_vamp_1_ppllll2_nenexnmnmxgg_1_/**/REALKIND
