
module ol_vamp_1_ppllll2_nmnmxeexgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllll2_nmnmxeexgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllll2_nmnmxeexgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllll2_nmnmxeexgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllll2_nmnmxeexgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,21) :: G0
  complex(REALKIND), dimension(4,5,4,68) :: G1
  complex(REALKIND), dimension(4,15,4,138) :: G2
  complex(REALKIND), dimension(4,35,4,90) :: G3
  complex(REALKIND), dimension(35,48) :: G3tensor
  complex(REALKIND), dimension(70,48) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,8),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,25),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,27),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,29),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,31),G2(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,34),G2(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,28),MT,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZu)
  call loop_A_Q(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,60),MT,G3(:,:,:,3))
  call loop_AZ_Q(G3(:,:,:,3),wf(:,3),G3(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,-5),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,48),MT,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,8),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,13),wf(:,23),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,13),wf(:,25),G2(:,:,:,16),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,13),wf(:,27),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,13),wf(:,29),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,13),wf(:,31),G2(:,:,:,19),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,13),wf(:,34),G2(:,:,:,20),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,5),wf(:,2),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,28),MT,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-5),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,60),MT,G3(:,:,:,5))
  call loop_QZ_A(G3(:,:,:,5),wf(:,3),G3(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_QZ_A(G1(:,:,:,5),wf(:,6),G1(:,:,:,8),gZu)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MT,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-5),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,60),MT,G3(:,:,:,7))
  call loop_QZ_A(G3(:,:,:,7),wf(:,3),G3(:,:,:,8),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-5),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,48),MB,G2(:,:,:,25))
  call loop_AS_Q(G2(:,:,:,25),wf(:,8),G2(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,25),wf(:,23),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,25),G2(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,25),wf(:,27),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,63),MB,G3tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,29),G2(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,31),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,63),MB,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,34),G2(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,9),wf(:,2),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,28),MB,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-5),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,60),MB,G3(:,:,:,9))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,3),G3(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,9),wf(:,6),G1(:,:,:,12),gZd)
  call loop_A_Q(G1(:,:,:,12),Q(:,28),MB,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,60),MB,G3(:,:,:,11))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,3),G3(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,48),MB,G2(:,:,:,37))
  call loop_QS_A(G2(:,:,:,37),wf(:,8),G2(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MB,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,37),wf(:,23),G2(:,:,:,39))
  call check_last_Q_A(l_switch,G2(:,:,:,39),Q(:,63),MB,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,37),wf(:,25),G2(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,24))
  call loop_QV_A(G2(:,:,:,37),wf(:,27),G2(:,:,:,41))
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,63),MB,G3tensor(:,25))
  call loop_QZ_A(G2(:,:,:,37),wf(:,29),G2(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,37),wf(:,31),G2(:,:,:,43),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,63),MB,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,37),wf(:,34),G2(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),MB,G3tensor(:,28))
  call loop_QV_A(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,28),MB,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-5),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,60),MB,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,3),G3(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MB,G4tensor(:,7))
  call loop_QZ_A(G1(:,:,:,13),wf(:,6),G1(:,:,:,16),gZd)
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MB,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,60),MB,G3(:,:,:,15))
  call loop_QZ_A(G3(:,:,:,15),wf(:,3),G3(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),MB,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,44),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,60),ZERO,G3(:,:,:,17))
  call loop_QZ_A(G3(:,:,:,17),wf(:,3),G3(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,17),wf(:,3),G3(:,:,:,19),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,19),Q(:,63),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,28),ZERO,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,60),ZERO,G3(:,:,:,20))
  call loop_QZ_A(G3(:,:,:,20),wf(:,3),G3(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,20),wf(:,3),G3(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MT,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,-5),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,44),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,60),MT,G3(:,:,:,23))
  call loop_QZ_A(G3(:,:,:,23),wf(:,3),G3(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,20),wf(:,-4),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,28),MT,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,60),MT,G3(:,:,:,25))
  call loop_QZ_A(G3(:,:,:,25),wf(:,3),G3(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MT,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),ZERO,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-5),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,44),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,60),ZERO,G3(:,:,:,27))
  call loop_AZ_Q(G3(:,:,:,27),wf(:,3),G3(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,27),wf(:,3),G3(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,63),ZERO,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-4),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,28),ZERO,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,60),ZERO,G3(:,:,:,30))
  call loop_AZ_Q(G3(:,:,:,30),wf(:,3),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,63),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,30),wf(:,3),G3(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),ZERO,G4tensor(:,18))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,12),MT,G1(:,:,:,26))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-5),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,44),MT,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,60),MT,G3(:,:,:,33))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,3),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-4),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,28),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,60),MT,G3(:,:,:,35))
  call loop_AZ_Q(G3(:,:,:,35),wf(:,3),G3(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,12),MB,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,44),MB,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-4),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,60),MB,G3(:,:,:,37))
  call loop_QZ_A(G3(:,:,:,37),wf(:,3),G3(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,28),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-5),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,60),MB,G3(:,:,:,39))
  call loop_QZ_A(G3(:,:,:,39),wf(:,3),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,12),MB,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-5),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,44),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,60),MB,G3(:,:,:,41))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,3),G3(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,23))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-4),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,28),MB,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,60),MB,G3(:,:,:,43))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,3),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,24))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,12),gZu)
  call loop_Q_A(G0(:,:,:,12),Q(:,12),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,44),ZERO,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,-4),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,60),ZERO,G3(:,:,:,45))
  call loop_QZ_A(G3(:,:,:,45),wf(:,3),G3(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),ZERO,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,28),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,60),ZERO,G3(:,:,:,47))
  call loop_QZ_A(G3(:,:,:,47),wf(:,3),G3(:,:,:,48),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),ZERO,G4tensor(:,26))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,13),gZu)
  call loop_Q_A(G0(:,:,:,13),Q(:,12),MT,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,-5),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,44),MT,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,60),MT,G3(:,:,:,49))
  call loop_QZ_A(G3(:,:,:,49),wf(:,3),G3(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,38),wf(:,-4),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,28),MT,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,60),MT,G3(:,:,:,51))
  call loop_QZ_A(G3(:,:,:,51),wf(:,3),G3(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,28))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),ZERO,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-5),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,44),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,60),ZERO,G3(:,:,:,53))
  call loop_AZ_Q(G3(:,:,:,53),wf(:,3),G3(:,:,:,54),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,63),ZERO,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-4),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,28),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,60),ZERO,G3(:,:,:,55))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,3),G3(:,:,:,56),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,63),ZERO,G4tensor(:,30))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-5),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,44),MT,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-4),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,60),MT,G3(:,:,:,57))
  call loop_AZ_Q(G3(:,:,:,57),wf(:,3),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-4),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,28),MT,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,60),MT,G3(:,:,:,59))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,3),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,63),MT,G4tensor(:,32))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,16),gZd)
  call loop_Q_A(G0(:,:,:,16),Q(:,12),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,-5),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,44),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,60),ZERO,G3(:,:,:,61))
  call loop_QZ_A(G3(:,:,:,61),wf(:,3),G3(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),ZERO,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,47),wf(:,-4),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,28),ZERO,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,60),ZERO,G3(:,:,:,63))
  call loop_QZ_A(G3(:,:,:,63),wf(:,3),G3(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,34))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,17),gZd)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MB,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,44),MB,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,60),MB,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,3),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MB,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,50),wf(:,-4),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,28),MB,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,60),MB,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,3),G3(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MB,G4tensor(:,36))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,12),ZERO,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-5),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,44),ZERO,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,60),ZERO,G3(:,:,:,69))
  call loop_AZ_Q(G3(:,:,:,69),wf(:,3),G3(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),ZERO,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-4),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,28),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-5),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,60),ZERO,G3(:,:,:,71))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,3),G3(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,12),MB,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-5),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,44),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-4),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,60),MB,G3(:,:,:,73))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,3),G3(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,63),MB,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,28),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-5),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,60),MB,G3(:,:,:,75))
  call loop_AZ_Q(G3(:,:,:,75),wf(:,3),G3(:,:,:,76),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MB,G4tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,16),ZERO,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,2),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,28),ZERO,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,60),ZERO,G3(:,:,:,77))
  call loop_QZ_A(G3(:,:,:,77),wf(:,3),G3(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),ZERO,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,77),wf(:,3),G3(:,:,:,79),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,63),ZERO,G4tensor(:,42))
  call loop_QZ_A(G1(:,:,:,59),wf(:,6),G1(:,:,:,61),gZu)
  call loop_Q_A(G1(:,:,:,61),Q(:,28),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-5),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,60),ZERO,G3(:,:,:,80))
  call loop_QZ_A(G3(:,:,:,80),wf(:,3),G3(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,63),ZERO,G4tensor(:,43))
  call loop_QZ_A(G1(:,:,:,59),wf(:,6),G1(:,:,:,62),gZd)
  call loop_Q_A(G1(:,:,:,62),Q(:,28),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,-5),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,60),ZERO,G3(:,:,:,82))
  call loop_QZ_A(G3(:,:,:,82),wf(:,3),G3(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,63),ZERO,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,59),wf(:,-5),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,48),ZERO,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,23),G2(:,:,:,112))
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,63),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,111),wf(:,25),G2(:,:,:,113),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,63),ZERO,G3tensor(:,30))
  call loop_QZ_A(G2(:,:,:,111),wf(:,25),G2(:,:,:,114),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),ZERO,G3tensor(:,31))
  call loop_QV_A(G2(:,:,:,111),wf(:,27),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,111),wf(:,29),G2(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),ZERO,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,111),wf(:,29),G2(:,:,:,117),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,63),ZERO,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,111),wf(:,31),G2(:,:,:,118),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),ZERO,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,111),wf(:,31),G2(:,:,:,119),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,119),Q(:,63),ZERO,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,111),wf(:,34),G2(:,:,:,120),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),ZERO,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,111),wf(:,34),G2(:,:,:,121),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,121),Q(:,63),ZERO,G3tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,16),ZERO,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,2),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,28),ZERO,G2(:,:,:,122))
  call loop_AV_Q(G2(:,:,:,122),wf(:,-5),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,60),ZERO,G3(:,:,:,84))
  call loop_AZ_Q(G3(:,:,:,84),wf(:,3),G3(:,:,:,85),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,63),ZERO,G4tensor(:,45))
  call loop_AZ_Q(G3(:,:,:,84),wf(:,3),G3(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),ZERO,G4tensor(:,46))
  call loop_AZ_Q(G1(:,:,:,64),wf(:,6),G1(:,:,:,66),gZu)
  call loop_A_Q(G1(:,:,:,66),Q(:,28),ZERO,G2(:,:,:,124))
  call loop_AV_Q(G2(:,:,:,124),wf(:,-5),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,60),ZERO,G3(:,:,:,87))
  call loop_AZ_Q(G3(:,:,:,87),wf(:,3),G3(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,63),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G1(:,:,:,64),wf(:,6),G1(:,:,:,67),gZd)
  call loop_A_Q(G1(:,:,:,67),Q(:,28),ZERO,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-5),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,60),ZERO,G3(:,:,:,89))
  call loop_AZ_Q(G3(:,:,:,89),wf(:,3),G3(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,63),ZERO,G4tensor(:,48))
  call loop_AV_Q(G1(:,:,:,64),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,48),ZERO,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,23),G2(:,:,:,129))
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),ZERO,G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,25),G2(:,:,:,130),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),ZERO,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,25),G2(:,:,:,131),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,63),ZERO,G3tensor(:,41))
  call loop_AV_Q(G2(:,:,:,128),wf(:,27),G2(:,:,:,132))
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,63),ZERO,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,29),G2(:,:,:,133),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,63),ZERO,G3tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,29),G2(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,63),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,31),G2(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,63),ZERO,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,31),G2(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),ZERO,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,34),G2(:,:,:,137),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,63),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,128),wf(:,34),G2(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),ZERO,G3tensor(:,48))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(11)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,2))
  M(1) = M(1) + (f(10)/2._/**/REALKIND * den(22)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,2))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,13),T4sum(1:70,2))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,15),T4sum(1:70,1))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,19),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,16),T4sum(1:70,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,23),T4sum(1:70,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,25),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,27),T4sum(1:70,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,29),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_5,G4tensor(:,31),T4sum(1:70,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,33),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,35),T4sum(1:70,3))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_6,G4tensor(:,37),T4sum(1:70,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_3,masses2_4,G4tensor(:,39),T4sum(1:70,3))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,20),T4sum(1:70,5))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,11),T4sum(1:70,4))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,14),T4sum(1:70,5))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,18),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,24),T4sum(1:70,6))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,12),T4sum(1:70,4))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,22),T4sum(1:70,6))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,30),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,32),T4sum(1:70,5))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,26),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_5,G4tensor(:,28),T4sum(1:70,5))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,38),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,40),T4sum(1:70,6))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_6,G4tensor(:,34),T4sum(1:70,4))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_2,masses2_4,G4tensor(:,36),T4sum(1:70,6))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,41),T4sum(1:70,7))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,3),T4sum(1:70,8))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,45),T4sum(1:70,7))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,1),T4sum(1:70,8))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,42),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,7),T4sum(1:70,9))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,46),T4sum(1:70,7))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,5),T4sum(1:70,9))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,43),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,4),T4sum(1:70,8))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,47),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,2),T4sum(1:70,8))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,44),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,8),T4sum(1:70,9))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,48),T4sum(1:70,7))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,6),T4sum(1:70,9))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(24)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(24)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(24)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(24)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(24)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(24)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,2))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(29)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(29)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(29)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(29)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(29)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(30)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(31)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,1))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,2))
  M(1) = M(1) + (-(f(9)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,3))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,2))

end subroutine vamp_1

end module ol_vamp_1_ppllll2_nmnmxeexgg_1_/**/REALKIND
