
module ol_external_decl_ppllj_eexuuxg_1_/**/REALKIND
  use ol_permutations_ppllj_eexuuxg_1, only: external_perm_ppllj_eexuuxg_1
  implicit none
  contains

subroutine get_external_masses(m_ex)
  ! Return the masses of the external particles in the current permutation.
  ! This subroutine is not used internally.
  use KIND_TYPES, only: REALKIND
  use ol_parameters_decl_/**/REALKIND
  use ol_permutations_ppllj_eexuuxg_1, only: external_perm_ppllj_eexuuxg_1
  implicit none
  real(REALKIND), intent(out) :: m_ex(5)
  integer        :: i
  real(REALKIND) :: m_ex_orig(5)
  ! External particle masses for e- e+ up anti-up glue -> 0 in the identity permutation
  m_ex_orig = [ rZERO, rZERO, rZERO, rZERO, rZERO ]
  do i = 1, 5
    m_ex(i) = m_ex_orig(external_perm_ppllj_eexuuxg_1(i))
  end do
end subroutine get_external_masses

end module ol_external_decl_ppllj_eexuuxg_1_/**/REALKIND



module ol_colourmatrix_ppllj_eexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  16]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   2]
  K1(11,:) = [  16]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [ -18]
  K1(15,:) = [ -18]
  K1(16,:) = [  36]
  K1(17,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllj_eexuuxg_1_/**/REALKIND



module ol_forced_parameters_ppllj_eexuuxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (MB /= 0) write(*,101) 'MB = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllj_eexuuxg_1_/**/REALKIND



! Top-level interfaces

#ifdef PRECISION_dp
subroutine ol_get_external_masses_ppllj_eexuuxg_1(m_ex)
  use KIND_TYPES, only: DREALKIND
  use ol_external_decl_ppllj_eexuuxg_1_/**/DREALKIND, only: get_external_masses
  implicit none
  real(DREALKIND), intent(out) :: m_ex(5)
  call get_external_masses(m_ex)
end subroutine ol_get_external_masses_ppllj_eexuuxg_1
#endif

module ol_loop_ppllj_eexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(18), c(11)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:27)
  ! denominators
  complex(REALKIND), save :: den(21)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD)/3._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD
    f( 3) = (2*CI*countertermnorm*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**2*gQCD**3
    f( 5) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*ctGqq*eQED**2*gQCD**3
    f( 7) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 8) = CI*countertermnorm*ctVqq*eQED**2*gQCD**3
    f( 9) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f(10) = (2*CI*eQED**2*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(11) = CI*eQED**2*gQCD**3*integralnorm*SwB
    f(12) = (2*eQED**2*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(13) = eQED**2*gQCD**3*integralnorm*SwB
    f(14) = (2*eQED**2*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(15) = eQED**2*gQCD**3*integralnorm*SwF
    f(16) = (4*eQED**2*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(17) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(18) = 3*eQED**2*gQCD**3*integralnorm*SwF

  c = [ 9*CI*f(10), 9*CI*f(11), f(12), 8*f(12), f(13), 8*f(13), 3*f(14), 3*f(15), 3*f(16), 3*f(17), 3*f(18) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(17)

  ! external WFs

  call wf_Q(P(0,1), rZERO, H(1), wf(1,0))
  call wf_A(P(0,2), rZERO, H(2), wf(1,-1))
  call wf_Q(P(0,3), rZERO, H(3), wf(1,-2))
  call wf_A(P(0,4), rZERO, H(4), wf(1,-3))
  call wf_V(P(0,5), rZERO, H(5), wf(1,-4))


  ! internal WFs

  call vert_QA_V(wf(:, 0), wf(:, -1), wf(:, 1))
  call vert_VQ_A(wf(:, -4), wf(:, -2), wf(:, 2))
  call prop_Q_A(wf(:, 2), Q(:,20), ZERO, 0_intkind1, wf(:, 3))
  call vert_AV_Q(wf(:, -3), wf(:, 1), wf(:, 4))
  call vert_QA_Z(gZl,wf(:, 0), wf(:, -1), wf(:, 5))
  call prop_W_W(wf(:, 5), Q(:,3), MZ, 1_intkind1, wf(:, 6))
  call vert_AZ_Q(gZu,wf(:, -3), wf(:, 6), wf(:, 7))
  call vert_AV_Q(wf(:, -3), wf(:, -4), wf(:, 8))
  call prop_A_Q(wf(:, 8), Q(:,24), ZERO, 0_intkind1, wf(:, 9))
  call vert_VQ_A(wf(:, 1), wf(:, -2), wf(:, 10))
  call vert_ZQ_A(gZu,wf(:, 6), wf(:, -2), wf(:, 11))
  call vert_QA_V(wf(:, -2), wf(:, -3), wf(:, 12))
  call counter_VG_G(wf(:, 6), wf(:, -4), Q(:,16), wf(:, 13), Q(:,19))
  call counter_AV_Q(wf(:, -3), wf(:, 1), wf(:, 14))
  call counter_AZ_Q(gZu,wf(:, -3), wf(:, 6), wf(:, 15))
  call counter_AV_Q(wf(:, -3), wf(:, -4), wf(:, 16))
  call prop_A_Q(wf(:, 16), Q(:,24), ZERO, 0_intkind1, wf(:, 17))
  call counter_VQ_A(wf(:, 1), wf(:, -2), wf(:, 18))
  call counter_ZQ_A(gZu,wf(:, 6), wf(:, -2), wf(:, 19))
  call counter_VQ_A(wf(:, -4), wf(:, -2), wf(:, 20))
  call prop_Q_A(wf(:, 20), Q(:,20), ZERO, 0_intkind1, wf(:, 21))
  call counter_Q_A(ctqq,wf(:, 3), Q(:,20), wf(:, 22))
  call prop_A_Q(wf(:, 4), Q(:,11), ZERO, 0_intkind1, wf(:, 23))
  call prop_A_Q(wf(:, 7), Q(:,11), ZERO, 0_intkind1, wf(:, 24))
  call counter_A_Q(ctqq,wf(:, 9), Q(:,24), wf(:, 25))
  call prop_Q_A(wf(:, 10), Q(:,7), ZERO, 0_intkind1, wf(:, 26))
  call prop_Q_A(wf(:, 11), Q(:,7), ZERO, 0_intkind1, wf(:, 27))


  ! propagators

    den(1) = 1 / (Q(5,3))
    den(2) = 1 / (Q(5,20))
    den(4) = 1 / (Q(5,3) - MZ2)
    den(6) = 1 / (Q(5,24))
    den(9) = 1 / (Q(5,12))
    den(11) = 1 / (Q(5,11))
    den(16) = 1 / (Q(5,7))


  ! denominators

    den(3) = den(1)*den(2)
    den(5) = den(2)*den(4)
    den(7) = den(1)*den(6)
    den(8) = den(4)*den(6)
    den(10) = den(4)*den(9)
    den(12) = den(1)*den(11)
    den(13) = den(2)*den(12)
    den(14) = den(4)*den(11)
    den(15) = den(2)*den(14)
    den(17) = den(1)*den(16)
    den(18) = den(6)*den(17)
    den(19) = den(4)*den(16)
    den(20) = den(6)*den(19)
    den(21) = den(1)*den(9)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(1,3),wf(1,4)) * den(3)
  A(2) = cont_QA(wf(1,3),wf(1,7)) * den(5)
  A(3) = cont_QA(wf(1,9),wf(1,10)) * den(7)
  A(4) = cont_QA(wf(1,9),wf(1,11)) * den(8)

  A(5) = cont_VV(wf(1,12),wf(1,13)) * den(10)
  A(6) = cont_QA(wf(1,3),wf(1,14)) * den(3)
  A(7) = cont_QA(wf(1,3),wf(1,15)) * den(5)
  A(8) = cont_QA(wf(1,10),wf(1,17)) * den(7)
  A(9) = cont_QA(wf(1,11),wf(1,17)) * den(8)
  A(10) = cont_QA(wf(1,9),wf(1,18)) * den(7)
  A(11) = cont_QA(wf(1,9),wf(1,19)) * den(8)
  A(12) = cont_QA(wf(1,4),wf(1,21)) * den(3)
  A(13) = cont_QA(wf(1,7),wf(1,21)) * den(5)
  A(14) = cont_QA(wf(1,22),wf(1,23)) * den(13)
  A(15) = cont_QA(wf(1,22),wf(1,24)) * den(15)
  A(16) = cont_QA(wf(1,25),wf(1,26)) * den(18)
  A(17) = cont_QA(wf(1,25),wf(1,27)) * den(20)


  ! colour vectors

  M1(1) = (-A(1)-A(3))*f(1)+(A(2)+A(4))*f(2)

  M2(1) = (A(14)+A(16))*f(3)+(-A(15)-A(17))*f(4)+(-A(8)-A(12))*f(5)+(A(9)+A(13))*f(6)+(-A(6)-A(10))*f(7)+(A(7)+A(11))*f(8) &
       -A(5)*f(9)


end subroutine tree_wavefunctions

end module ol_loop_ppllj_eexuuxg_1_/**/REALKIND
