
module ol_permutations_ppllj_nenexuuxg_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppllj_nenexuuxg_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: external_perm_inv_ppllj_nenexuuxg_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: extcomb_perm_ppllj_nenexuuxg_1(0:17-1) = &
                     [ (dummy_counter - 1, dummy_counter = 1, 17) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppllj_nenexuuxg_1(5) = &
                     [ 1, 2, 3, 4, 5 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppllj_nenexuuxg_1(5) = &
                     [ 2, 2, 6, 6, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppllj_nenexuuxg_1 = &
                     4
  integer, save :: channel_number_ppllj_nenexuuxg_1 = -1

  contains

  function n_particles()
    ! Return the number of external particles
    implicit none
    integer :: n_particles
    n_particles = 5
  end function n_particles



  subroutine set_permutation(perm)
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(5)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppllj_nenexuuxg_1(5)
    external_perm_ppllj_nenexuuxg_1 = perm
    do i = 1, 5
      external_perm_inv_ppllj_nenexuuxg_1( &
        external_perm_ppllj_nenexuuxg_1(i)) = i
      particle_types_perm_ppllj_nenexuuxg_1(i) = &
        particle_types_ppllj_nenexuuxg_1( &
        external_perm_ppllj_nenexuuxg_1(i))
    end do
    do i = 1, 5
      do j = 1, i
        if (external_perm_ppllj_nenexuuxg_1(i) >= &
          external_perm_ppllj_nenexuuxg_1(j)) then
          ii = external_perm_ppllj_nenexuuxg_1(i)
          jj = external_perm_ppllj_nenexuuxg_1(j)
        else
          ii = external_perm_ppllj_nenexuuxg_1(j)
          jj = external_perm_ppllj_nenexuuxg_1(i)
        end if
        extcomb_perm_ppllj_nenexuuxg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppllj_nenexuuxg_1 = &
      average_factors_ppllj_nenexuuxg_1( &
      external_perm_ppllj_nenexuuxg_1(1)) &
      * average_factors_ppllj_nenexuuxg_1( &
      external_perm_ppllj_nenexuuxg_1(2))
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 5
        average_factor_ppllj_nenexuuxg_1 = &
          average_factor_ppllj_nenexuuxg_1 &
          * factorial(count(particle_types_perm_ppllj_nenexuuxg_1(3:5) == i))
      end do
    end if
  end subroutine set_permutation

end module ol_permutations_ppllj_nenexuuxg_1



module ol_hel_decl_ppllj_nenexuuxg_1
  implicit none
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(5,32) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(32,5)
  contains
  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [ -1, -1, -1, -1, -1 ]
  H(:, 2) = [ -1, -1, -1, -1,  1 ]
  H(:, 3) = [ -1, -1, -1,  1, -1 ]
  H(:, 4) = [ -1, -1, -1,  1,  1 ]
  H(:, 5) = [ -1, -1,  1, -1, -1 ]
  H(:, 6) = [ -1, -1,  1, -1,  1 ]
  H(:, 7) = [ -1, -1,  1,  1, -1 ]
  H(:, 8) = [ -1, -1,  1,  1,  1 ]
  H(:, 9) = [ -1,  1, -1, -1, -1 ]
  H(:,10) = [ -1,  1, -1, -1,  1 ]
  H(:,11) = [ -1,  1, -1,  1, -1 ]
  H(:,12) = [ -1,  1, -1,  1,  1 ]
  H(:,13) = [ -1,  1,  1, -1, -1 ]
  H(:,14) = [ -1,  1,  1, -1,  1 ]
  H(:,15) = [ -1,  1,  1,  1, -1 ]
  H(:,16) = [ -1,  1,  1,  1,  1 ]
  H(:,17) = [  1, -1, -1, -1, -1 ]
  H(:,18) = [  1, -1, -1, -1,  1 ]
  H(:,19) = [  1, -1, -1,  1, -1 ]
  H(:,20) = [  1, -1, -1,  1,  1 ]
  H(:,21) = [  1, -1,  1, -1, -1 ]
  H(:,22) = [  1, -1,  1, -1,  1 ]
  H(:,23) = [  1, -1,  1,  1, -1 ]
  H(:,24) = [  1, -1,  1,  1,  1 ]
  H(:,25) = [  1,  1, -1, -1, -1 ]
  H(:,26) = [  1,  1, -1, -1,  1 ]
  H(:,27) = [  1,  1, -1,  1, -1 ]
  H(:,28) = [  1,  1, -1,  1,  1 ]
  H(:,29) = [  1,  1,  1, -1, -1 ]
  H(:,30) = [  1,  1,  1, -1,  1 ]
  H(:,31) = [  1,  1,  1,  1, -1 ]
  H(:,32) = [  1,  1,  1,  1,  1 ]

  H_HC(:,5) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 32/1/2) ]
  end subroutine hel_init
end module ol_hel_decl_ppllj_nenexuuxg_1



! Top-level interface

function ol_n_particles_ppllj_nenexuuxg_1()
  use ol_permutations_ppllj_nenexuuxg_1, only: n_particles
  implicit none
  integer :: ol_n_particles_ppllj_nenexuuxg_1
  ol_n_particles_ppllj_nenexuuxg_1 = n_particles()
end function ol_n_particles_ppllj_nenexuuxg_1



subroutine ol_set_permutation_ppllj_nenexuuxg_1(perm)
  use ol_permutations_ppllj_nenexuuxg_1, only: set_permutation
  implicit none
  integer, intent(in) :: perm(5)
  call set_permutation(perm)
end subroutine ol_set_permutation_ppllj_nenexuuxg_1



! Only for compatibility with the Sherpa interface
subroutine set_permutation_ppllj_nenexuuxg_1(perm)
  use ol_permutations_ppllj_nenexuuxg_1, only: set_permutation
  implicit none
  integer, intent(in) :: perm(5)
  call set_permutation(perm)
end subroutine set_permutation_ppllj_nenexuuxg_1
