
! **********************************************************************
module ol_heltables_ppllj_eexuuxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init_ppllj_eexuuxg_1 = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n3, n6, n9

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n4, n5, n7, n8, n10, n11, n12, n13, n14, n15


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t5, t8

  integer(intkind2), save, dimension(2,8) :: &
  t4, t7, t10, t11

  integer(intkind2), save, dimension(2,32) :: &
  t12, t13, t14, t15


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(32,5)
  integer,           save :: exthel(32,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  n3 = 4
  call heltable([2,4,8], n4, t4)
  call heltable([2,2,4], n5, t5)
  n6 = 4
  call heltable([2,4,8], n7, t7)
  call heltable([2,2,4], n8, t8)
  n9 = 4
  call heltable([4,2,8], n10, t10)
  call heltable([4,2,8], n11, t11)
  call heltable([4,8,32], n12, t12)
  call heltable([4,8,32], n13, t13)
  call heltable([4,8,32], n14, t14)
  call heltable([4,8,32], n15, t15)

  heltables_not_init_ppllj_eexuuxg_1 = .false.

end subroutine init_heltables

end module ol_heltables_ppllj_eexuuxg_1
