
module ol_vamp_2_pphzjj_ddxhzgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphzjj_ddxhzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphzjj_ddxhzgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphzjj_ddxhzgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphzjj_ddxhzgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,39) :: G0
  complex(REALKIND), dimension(4,5,4,96) :: G1
  complex(REALKIND), dimension(4,15,4,98) :: G2
  complex(REALKIND), dimension(4,35,4,41) :: G3
  complex(REALKIND), dimension(4,70,4,9) :: G4
  complex(REALKIND), dimension(5,15) :: G1tensor
  complex(REALKIND), dimension(15,33) :: G2tensor
  complex(REALKIND), dimension(35,35) :: G3tensor
  complex(REALKIND), dimension(70,13) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,19),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,51),MT,G2(:,:,:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,6),G2(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,-3),G1(:,:,:,3),gZu)
  call loop_Q_A(G1(:,:,:,3),Q(:,27),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,-5),G2(:,:,:,4))
  call loop_Q_A(G2(:,:,:,4),Q(:,59),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,-2),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,19),ZERO,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,51),ZERO,G2(:,:,:,5))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,6),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,6),G2(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),ZERO,G3tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,19),MT,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-5),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,51),MT,G2(:,:,:,8))
  call loop_AZ_Q(G2(:,:,:,8),wf(:,6),G2(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,6),wf(:,-3),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,27),MT,G2(:,:,:,10))
  call loop_AV_Q(G2(:,:,:,10),wf(:,-5),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,59),MT,G3(:,:,:,3))
  call loop_AS_Q(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,19),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,51),MB,G2(:,:,:,12))
  call loop_QZ_A(G2(:,:,:,12),wf(:,6),G2(:,:,:,13),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,63),MB,G3tensor(:,5))
  call loop_QZ_A(G1(:,:,:,9),wf(:,-3),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,27),MB,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-5),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,59),MB,G3(:,:,:,5))
  call loop_QS_A(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MB,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,19),MB,G1(:,:,:,12))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,51),MB,G2(:,:,:,16))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,6),G2(:,:,:,17),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,63),MB,G3tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,12),wf(:,-3),G1(:,:,:,14),gZd)
  call loop_A_Q(G1(:,:,:,14),Q(:,27),MB,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-5),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,59),MB,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,-2),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,18),ZERO,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,50),ZERO,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,18),G2tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,6),G2(:,:,:,21),gZd)
  call loop_A_Q(G2(:,:,:,21),Q(:,62),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,6),G1(:,:,:,17),gZd)
  call loop_A_Q(G1(:,:,:,17),Q(:,30),ZERO,G2(:,:,:,22))
  call loop_AV_Q(G2(:,:,:,22),wf(:,-5),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,62),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,91),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,50),ZERO,G1(:,:,:,18))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,6),G1(:,:,:,19),gZd)
  call loop_A_Q(G1(:,:,:,19),Q(:,62),ZERO,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,0),G2tensor(:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,18),wf(:,18),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,1),wf(:,114),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,30),ZERO,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-5),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,62),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,0),G2tensor(:,3))
  call loop_VQ_A(G0(:,:,:,1),wf(:,83),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,49),ZERO,G1(:,:,:,22))
  call loop_QZ_A(G1(:,:,:,22),wf(:,6),G1(:,:,:,23),gZd)
  call loop_Q_A(G1(:,:,:,23),Q(:,61),ZERO,G2(:,:,:,26))
  call check_last_QA_V(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,4))
  call check_last_QA_V(l_switch,G1(:,:,:,22),wf(:,10),G1tensor(:,2))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,24))
  call loop_VQ_A(G1(:,:,:,24),wf(:,13),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,49),ZERO,G2(:,:,:,27))
  call check_last_QA_V(l_switch,G2(:,:,:,27),wf(:,10),G2tensor(:,5))
  call loop_QZ_A(G2(:,:,:,27),wf(:,6),G2(:,:,:,28),gZd)
  call loop_Q_A(G2(:,:,:,28),Q(:,61),ZERO,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-1),G3tensor(:,9))
  call loop_VQ_A(G1(:,:,:,24),wf(:,117),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,61),ZERO,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-1),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,24),wf(:,5),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,50),ZERO,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,18),G2tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,30),wf(:,6),G2(:,:,:,31),gZd)
  call loop_A_Q(G2(:,:,:,31),Q(:,62),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,10))
  call loop_VA_Q(G1(:,:,:,24),wf(:,105),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,62),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,0),G2tensor(:,8))
  call loop_UV_W(G1(:,:,:,24),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,33))
  call check_last_UV_W(l_switch,G2(:,:,:,33),Q(:,48),wf(:,141),Q(:,15),G3tensor(:,11))
  call check_last_UV_W(l_switch,G2(:,:,:,33),Q(:,48),wf(:,142),Q(:,15),G3tensor(:,12))
  call loop_VQ_A(G2(:,:,:,33),wf(:,18),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,61),ZERO,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,-1),G3tensor(:,13))
  call loop_VA_Q(G2(:,:,:,33),wf(:,10),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,62),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,14))
  call loop_VA_Q(G2(:,:,:,33),wf(:,-1),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,50),ZERO,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,6),G3(:,:,:,16),gZd)
  call loop_A_Q(G3(:,:,:,16),Q(:,62),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,5))
  call loop_VQ_A(G1(:,:,:,24),wf(:,146),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,61),ZERO,G2(:,:,:,37))
  call check_last_QA_V(l_switch,G2(:,:,:,37),wf(:,-1),G2tensor(:,9))
  call loop_VQ_A(G1(:,:,:,24),wf(:,18),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,29),ZERO,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,-5),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,61),ZERO,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,15))
  call loop_VA_Q(G1(:,:,:,24),wf(:,150),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,62),ZERO,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,24),wf(:,10),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,30),ZERO,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-5),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,62),ZERO,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,0),G3tensor(:,16))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-1),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,18),ZERO,G2(:,:,:,43))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,6),G2(:,:,:,44),gZd)
  call loop_A_Q(G2(:,:,:,44),Q(:,30),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,62),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,50),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,6),G3(:,:,:,22),gZd)
  call loop_A_Q(G3(:,:,:,22),Q(:,62),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,117),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,45),ZERO,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,-4),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,61),ZERO,G2(:,:,:,46))
  call check_last_QA_V(l_switch,G2(:,:,:,46),wf(:,-1),G2tensor(:,11))
  call check_last_QA_V(l_switch,G1(:,:,:,34),wf(:,14),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,95),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,50),ZERO,G1(:,:,:,36))
  call loop_AZ_Q(G1(:,:,:,36),wf(:,6),G1(:,:,:,37),gZd)
  call loop_A_Q(G1(:,:,:,37),Q(:,62),ZERO,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,0),G2tensor(:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,36),wf(:,18),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,105),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,46),ZERO,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-4),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,62),ZERO,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,38),wf(:,4),G1tensor(:,5))
  call loop_VQ_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,13),ZERO,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,21),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,61),ZERO,G2(:,:,:,49))
  call check_last_QA_V(l_switch,G2(:,:,:,49),wf(:,-1),G2tensor(:,14))
  call loop_QV_A(G1(:,:,:,40),wf(:,-5),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,45),ZERO,G2(:,:,:,50))
  call loop_QV_A(G2(:,:,:,50),wf(:,-4),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,61),ZERO,G3(:,:,:,23))
  call check_last_QA_V(l_switch,G3(:,:,:,23),wf(:,-1),G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,40),wf(:,-4),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,29),ZERO,G2(:,:,:,52))
  call loop_QV_A(G2(:,:,:,52),wf(:,-5),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,61),ZERO,G3(:,:,:,24))
  call check_last_QA_V(l_switch,G3(:,:,:,24),wf(:,-1),G3tensor(:,18))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,48),G1(:,:,:,44))
  call loop_VQ_A(G1(:,:,:,44),wf(:,18),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,61),ZERO,G2(:,:,:,54))
  call check_last_QA_V(l_switch,G2(:,:,:,54),wf(:,-1),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,44),wf(:,10),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,62),ZERO,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,0),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,44),wf(:,-1),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,50),ZERO,G2(:,:,:,56))
  call loop_AZ_Q(G2(:,:,:,56),wf(:,6),G2(:,:,:,57),gZd)
  call loop_A_Q(G2(:,:,:,57),Q(:,62),ZERO,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,0),G3tensor(:,19))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,48),wf(:,141),Q(:,15),G2tensor(:,17))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,48),wf(:,142),Q(:,15),G2tensor(:,18))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,49),ZERO,G1(:,:,:,48))
  call loop_QZ_A(G1(:,:,:,48),wf(:,6),G1(:,:,:,49),gZd)
  call loop_Q_A(G1(:,:,:,49),Q(:,61),ZERO,G2(:,:,:,58))
  call check_last_QA_V(l_switch,G2(:,:,:,58),wf(:,-1),G2tensor(:,19))
  call check_last_QA_V(l_switch,G1(:,:,:,48),wf(:,10),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,14),ZERO,G1(:,:,:,50))
  call loop_AV_Q(G1(:,:,:,50),wf(:,21),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,62),ZERO,G2(:,:,:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,59),wf(:,0),G2tensor(:,20))
  call loop_AV_Q(G1(:,:,:,50),wf(:,-5),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,46),ZERO,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-4),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,62),ZERO,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,50),wf(:,-4),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,30),ZERO,G2(:,:,:,62))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-5),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,62),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,0),G3tensor(:,21))
  call loop_VA_Q(G0(:,:,:,1),wf(:,96),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,50),ZERO,G1(:,:,:,54))
  call loop_AZ_Q(G1(:,:,:,54),wf(:,6),G1(:,:,:,55),gZd)
  call loop_A_Q(G1(:,:,:,55),Q(:,62),ZERO,G2(:,:,:,64))
  call check_last_AQ_V(l_switch,G2(:,:,:,64),wf(:,0),G2tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,54),wf(:,18),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,2),ZERO,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,21),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,50),ZERO,G2(:,:,:,65))
  call loop_AZ_Q(G2(:,:,:,65),wf(:,6),G2(:,:,:,66),gZd)
  call loop_A_Q(G2(:,:,:,66),Q(:,62),ZERO,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,56),wf(:,6),G1(:,:,:,58),gZd)
  call loop_A_Q(G1(:,:,:,58),Q(:,14),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,21),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,62),ZERO,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,23))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,46),ZERO,G3(:,:,:,30))
  call loop_AV_Q(G3(:,:,:,30),wf(:,-4),G3(:,:,:,31))
  call loop_A_Q(G3(:,:,:,31),Q(:,62),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,67),wf(:,-4),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,30),ZERO,G3(:,:,:,32))
  call loop_AV_Q(G3(:,:,:,32),wf(:,-5),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-5),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,34),ZERO,G2(:,:,:,71))
  call loop_AZ_Q(G2(:,:,:,71),wf(:,6),G2(:,:,:,72),gZd)
  call loop_A_Q(G2(:,:,:,72),Q(:,46),ZERO,G3(:,:,:,34))
  call loop_AV_Q(G3(:,:,:,34),wf(:,-4),G3(:,:,:,35))
  call loop_A_Q(G3(:,:,:,35),Q(:,62),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-4),G2(:,:,:,73))
  call loop_A_Q(G2(:,:,:,73),Q(:,50),ZERO,G3(:,:,:,36))
  call loop_AZ_Q(G3(:,:,:,36),wf(:,6),G3(:,:,:,37),gZd)
  call loop_A_Q(G3(:,:,:,37),Q(:,62),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,0),G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,18),ZERO,G2(:,:,:,74))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,6),G2(:,:,:,75),gZd)
  call loop_A_Q(G2(:,:,:,75),Q(:,30),ZERO,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,-5),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,62),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,74),wf(:,-5),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,50),ZERO,G3(:,:,:,40))
  call loop_AZ_Q(G3(:,:,:,40),wf(:,6),G3(:,:,:,41),gZd)
  call loop_A_Q(G3(:,:,:,41),Q(:,62),ZERO,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,13))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,61))
  call loop_DV_C(G1(:,:,:,61),Q(:,16),wf(:,-5),G2(:,:,:,77))
  call check_last_DV_C(l_switch,G2(:,:,:,77),Q(:,48),wf(:,141),G3tensor(:,24))
  call check_last_DV_C(l_switch,G2(:,:,:,77),Q(:,48),wf(:,142),G3tensor(:,25))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,62))
  call loop_CV_D(G1(:,:,:,62),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,78))
  call check_last_CV_D(l_switch,G2(:,:,:,78),Q(:,48),wf(:,141),Q(:,15),G3tensor(:,26))
  call check_last_CV_D(l_switch,G2(:,:,:,78),Q(:,48),wf(:,142),Q(:,15),G3tensor(:,27))
  call loop_VQ_A(G0(:,:,:,1),wf(:,144),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,29),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,61),ZERO,G2(:,:,:,79))
  call check_last_QA_V(l_switch,G2(:,:,:,79),wf(:,-1),G2tensor(:,22))
  call loop_VQ_A(G0(:,:,:,1),wf(:,146),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,45),ZERO,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,61),ZERO,G2(:,:,:,80))
  call check_last_QA_V(l_switch,G2(:,:,:,80),wf(:,-1),G2tensor(:,23))
  call check_last_QA_V(l_switch,G1(:,:,:,65),wf(:,14),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,148),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,30),ZERO,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,62),ZERO,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,0),G2tensor(:,24))
  call loop_VA_Q(G0(:,:,:,1),wf(:,150),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,46),ZERO,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-4),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,62),ZERO,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,69),wf(:,4),G1tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,152),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,27),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-5),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,59),MT,G2(:,:,:,83))
  call loop_QS_A(G2(:,:,:,83),wf(:,-2),G2(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,152),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,27),MT,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-5),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,59),MT,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,-2),G2(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,152),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,27),MB,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,59),MB,G2(:,:,:,87))
  call loop_QS_A(G2(:,:,:,87),wf(:,-2),G2(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,152),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,27),MB,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,59),MB,G2(:,:,:,89))
  call loop_AS_Q(G2(:,:,:,89),wf(:,-2),G2(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),MB,G3tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,154),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,27),MT,G1(:,:,:,79))
  call loop_QV_A(G1(:,:,:,79),wf(:,-5),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,59),MT,G2(:,:,:,91))
  call loop_QS_A(G2(:,:,:,91),wf(:,-2),G2(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,154),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,27),MT,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-5),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,59),MT,G2(:,:,:,93))
  call loop_AS_Q(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,63),MT,G3tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,154),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,27),MB,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,-5),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,59),MB,G2(:,:,:,95))
  call loop_QS_A(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MB,G3tensor(:,34))
  call loop_AV_Q(G0(:,:,:,1),wf(:,154),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,27),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,59),MB,G2(:,:,:,97))
  call loop_AS_Q(G2(:,:,:,97),wf(:,-2),G2(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),MB,G3tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,141),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,10))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,141),wf(:,-5),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,11))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,141),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,142),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,13))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,142),wf(:,-5),G0(:,:,:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,14))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,142),G0(:,:,:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,47),wf(:,-4),Q(:,16),G1tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,48),ZERO,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,141),G1(:,:,:,88))
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,63),ZERO,G2tensor(:,26))
  call loop_QV_A(G1(:,:,:,87),wf(:,142),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),ZERO,G2tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,48),MT,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,141),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,63),MT,G2tensor(:,28))
  call loop_QV_A(G1(:,:,:,90),wf(:,142),G1(:,:,:,92))
  call check_last_Q_A(l_switch,G1(:,:,:,92),Q(:,63),MT,G2tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,48),MB,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,141),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),MB,G2tensor(:,30))
  call loop_QV_A(G1(:,:,:,93),wf(:,142),G1(:,:,:,95))
  call check_last_Q_A(l_switch,G1(:,:,:,95),Q(:,63),MB,G2tensor(:,31))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,48),G1(:,:,:,96))
  call check_last_CV_D(l_switch,G1(:,:,:,96),Q(:,48),wf(:,141),Q(:,15),G2tensor(:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,96),Q(:,48),wf(:,142),Q(:,15),G2tensor(:,33))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(15)*M(1)) * den(35)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(17)*M(1)) * den(35)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(15)*M(1)) * den(35)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(15)*M(1)) * den(35)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(17)*M(1)) * den(35)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(15)*M(1)) * den(35)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(8)*M(1)) * den(15)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(10)*M(1))) * den(83)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(8)*M(1)) * den(102)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(8)*M(1)) * den(100)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(8)*M(1)) * den(100)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(10)*M(1))) * den(80)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(6)*M(1)) * den(16)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(8)*M(1)) * den(106)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(6)*M(1)) * den(106)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(6)*M(1)) * den(104)
  T3sum(1:35,24) = T3sum(1:35,24) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(6)*M(2))) * den(17)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(10)*M(2))) * den(85)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(8)*M(2)) * den(91)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(6)*M(2))) * den(91)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(6)*M(2))) * den(89)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(19)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(11)*(-M(1)+M(2))) * den(19)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(22)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(88)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(11)*(M(1)-M(2))) * den(88)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(87)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(163)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(3)*(-M(1)+M(2))) * den(163)
  T3sum(1:35,30) = T3sum(1:35,30) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(11)*(M(1)-M(2))) * den(163)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(145)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(145)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(145)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(6)*(-M(1)+M(2))) * den(146)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(146)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(6)*(M(1)-M(2))) * den(146)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(8)*M(2)) * den(147)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(8)*M(1)) * den(148)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(6)*M(1)) * den(148)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(4)*M(3))) * den(14)
  T3sum(1:35,35) = T3sum(1:35,35) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(8)*M(1)-c(9)*M(3)) * den(14)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(11)*M(1))-c(9)*M(3)) * den(14)
  T3sum(1:35,37) = T3sum(1:35,37) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(8)*M(2)-c(9)*M(3)) * den(14)
  T3sum(1:35,38) = T3sum(1:35,38) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(8)*M(1)) * den(149)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(8)*M(2)) * den(150)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(6)*M(2))) * den(150)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(4)*M(3)) * den(7)
  T3sum(1:35,41) = T3sum(1:35,41) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(8)*M(2)-c(9)*M(3)) * den(7)
  T3sum(1:35,42) = T3sum(1:35,42) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(11)*M(2))-c(9)*M(3)) * den(7)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(8)*M(1)-c(9)*M(3)) * den(7)
  T3sum(1:35,44) = T3sum(1:35,44) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(8)*M(2)-c(9)*M(3)) * den(3)
  T4sum(1:70,34) = T4sum(1:70,34) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(8)*M(2)-c(9)*M(3)) * den(3)
  T4sum(1:70,35) = T4sum(1:70,35) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(8)*M(1)-c(9)*M(3)) * den(3)
  T4sum(1:70,36) = T4sum(1:70,36) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(8)*M(1)-c(9)*M(3)) * den(3)
  T4sum(1:70,37) = T4sum(1:70,37) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(8)*M(1)-c(9)*M(3)) * den(3)
  T4sum(1:70,38) = T4sum(1:70,38) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(8)*M(2)-c(9)*M(3)) * den(3)
  T4sum(1:70,39) = T4sum(1:70,39) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(4)*M(3)) * den(3)
  T4sum(1:70,40) = T4sum(1:70,40) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(4)*M(3)) * den(3)
  T4sum(1:70,42) = T4sum(1:70,42) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(11)*M(2))-c(9)*M(3)) * den(3)
  T4sum(1:70,43) = T4sum(1:70,43) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(23)*M(2)) * den(152)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(23)*M(2)) * den(152)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(20)*M(2)) * den(152)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(20)*M(2)) * den(152)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(23)*M(1)) * den(34)
  T4sum(1:70,20) = T4sum(1:70,20) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(23)*M(1)) * den(34)
  T4sum(1:70,20) = T4sum(1:70,20) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(20)*M(1)) * den(34)
  T4sum(1:70,21) = T4sum(1:70,21) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(20)*M(1)) * den(34)
  T4sum(1:70,21) = T4sum(1:70,21) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(23)*M(1)) * den(154)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(23)*M(1)) * den(154)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(20)*M(1)) * den(154)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(20)*M(1)) * den(154)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(145)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(145)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(145)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(146)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(1)*(-M(1)+M(2))) * den(146)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(2)*(-M(1)+M(2))) * den(146)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(10)*M(2))) * den(92)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(10)*M(2))) * den(164)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(10)*M(1))) * den(107)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(10)*M(1))) * den(165)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(10)*M(1))) * den(108)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(10)*M(1))) * den(113)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(10)*M(2))) * den(114)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(13)*(-M(1)+M(2))) * den(168)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(168)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(13)*(-M(1)+M(2))) * den(168)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(168)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(168)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(168)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(13)*(-M(1)+M(2))) * den(169)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(169)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(13)*(-M(1)+M(2))) * den(169)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(12)*(-M(1)+M(2))) * den(169)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(7)*(-M(1)+M(2))) * den(169)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(2)*(M(1)-M(2))) * den(169)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(117)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(5)*(M(1)-M(2))) * den(118)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,6)

end subroutine vamp_2

end module ol_vamp_2_pphzjj_ddxhzgg_1_/**/REALKIND
