
module ol_vamp_1_pphzjj_ddxssxhz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphzjj_ddxssxhz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphzjj_ddxssxhz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphzjj_ddxssxhz_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphzjj_ddxssxhz_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,33) :: G0
  complex(REALKIND), dimension(4,5,4,128) :: G1
  complex(REALKIND), dimension(4,15,4,116) :: G2
  complex(REALKIND), dimension(4,35,4,33) :: G3
  complex(REALKIND), dimension(5,4) :: G1tensor
  complex(REALKIND), dimension(15,48) :: G2tensor
  complex(REALKIND), dimension(35,34) :: G3tensor
  complex(REALKIND), dimension(70,12) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,2),gZu)
  call loop_A_Q(G1(:,:,:,2),Q(:,60),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,3),gZd)
  call loop_A_Q(G1(:,:,:,3),Q(:,60),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,4))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,3),G1(:,:,:,5),gZu)
  call loop_A_Q(G1(:,:,:,5),Q(:,60),MT,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,-5),G1(:,:,:,6),gZu)
  call loop_A_Q(G1(:,:,:,6),Q(:,44),MT,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8),gH)
  call loop_A_Q(G2(:,:,:,8),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AS_Q(G1(:,:,:,4),wf(:,-4),G1(:,:,:,7),gH)
  call loop_A_Q(G1(:,:,:,7),Q(:,28),MT,G2(:,:,:,9))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,10),gZu)
  call loop_A_Q(G2(:,:,:,10),Q(:,60),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,8))
  call loop_QZ_A(G1(:,:,:,8),wf(:,3),G1(:,:,:,9),gZu)
  call loop_Q_A(G1(:,:,:,9),Q(:,60),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,1),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G1(:,:,:,8),wf(:,3),G1(:,:,:,10),gZd)
  call loop_Q_A(G1(:,:,:,10),Q(:,60),ZERO,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MT,G1(:,:,:,11))
  call loop_QZ_A(G1(:,:,:,11),wf(:,3),G1(:,:,:,12),gZu)
  call loop_Q_A(G1(:,:,:,12),Q(:,60),MT,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,6))
  call loop_QZ_A(G1(:,:,:,11),wf(:,-5),G1(:,:,:,13),gZu)
  call loop_Q_A(G1(:,:,:,13),Q(:,44),MT,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18),gH)
  call loop_Q_A(G2(:,:,:,18),Q(:,60),MT,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_QS_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,14),gH)
  call loop_Q_A(G1(:,:,:,14),Q(:,28),MT,G2(:,:,:,19))
  call loop_QZ_A(G2(:,:,:,19),wf(:,-5),G2(:,:,:,20),gZu)
  call loop_Q_A(G2(:,:,:,20),Q(:,60),MT,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),MB,G1(:,:,:,15))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,3),G1(:,:,:,16),gZd)
  call loop_A_Q(G1(:,:,:,16),Q(:,60),MB,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,-5),G1(:,:,:,17),gZd)
  call loop_A_Q(G1(:,:,:,17),Q(:,44),MB,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,-4),G2(:,:,:,24),gH)
  call loop_A_Q(G2(:,:,:,24),Q(:,60),MB,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,5))
  call loop_AS_Q(G1(:,:,:,15),wf(:,-4),G1(:,:,:,18),gH)
  call loop_A_Q(G1(:,:,:,18),Q(:,28),MB,G2(:,:,:,25))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,26),gZd)
  call loop_A_Q(G2(:,:,:,26),Q(:,60),MB,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MB,G1(:,:,:,19))
  call loop_QZ_A(G1(:,:,:,19),wf(:,3),G1(:,:,:,20),gZd)
  call loop_Q_A(G1(:,:,:,20),Q(:,60),MB,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,1),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,8))
  call loop_QZ_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,21),gZd)
  call loop_Q_A(G1(:,:,:,21),Q(:,44),MB,G2(:,:,:,29))
  call loop_QS_A(G2(:,:,:,29),wf(:,-4),G2(:,:,:,30),gH)
  call loop_Q_A(G2(:,:,:,30),Q(:,60),MB,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MB,G4tensor(:,7))
  call loop_QS_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,22),gH)
  call loop_Q_A(G1(:,:,:,22),Q(:,28),MB,G2(:,:,:,31))
  call loop_QZ_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32),gZd)
  call loop_Q_A(G2(:,:,:,32),Q(:,60),MB,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),MB,G4tensor(:,8))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,8),gH)
  call loop_Q_A(G0(:,:,:,8),Q(:,16),MT,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,10),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,28),MT,G2(:,:,:,33))
  call loop_QZ_A(G2(:,:,:,33),wf(:,-5),G2(:,:,:,34),gZu)
  call loop_Q_A(G2(:,:,:,34),Q(:,60),MT,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,23),wf(:,20),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,60),MT,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,1),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,23),wf(:,24),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,60),MT,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,1),G2(:,:,:,38))
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,23),wf(:,33),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,51),MT,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,10),G2(:,:,:,40))
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,23),wf(:,37),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,51),MT,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,10),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),MT,G3tensor(:,12))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,9),gH)
  call loop_A_Q(G0(:,:,:,9),Q(:,16),MT,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,10),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,28),MT,G2(:,:,:,43))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44),gZu)
  call loop_A_Q(G2(:,:,:,44),Q(:,60),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G1(:,:,:,29),wf(:,20),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,60),MT,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,1),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,29),wf(:,24),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,60),MT,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,1),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,29),wf(:,33),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,51),MT,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,10),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,29),wf(:,37),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,51),MT,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,10),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,63),MT,G3tensor(:,16))
  call loop_QS_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,10),gH)
  call loop_Q_A(G0(:,:,:,10),Q(:,16),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,10),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,28),MB,G2(:,:,:,53))
  call loop_QZ_A(G2(:,:,:,53),wf(:,-5),G2(:,:,:,54),gZd)
  call loop_Q_A(G2(:,:,:,54),Q(:,60),MB,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,35),wf(:,20),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,60),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,1),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,35),wf(:,24),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,60),MB,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MB,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,35),wf(:,33),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,51),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,10),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MB,G3tensor(:,19))
  call loop_QV_A(G1(:,:,:,35),wf(:,37),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,51),MB,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,10),G2(:,:,:,62))
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,20))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,11),gH)
  call loop_A_Q(G0(:,:,:,11),Q(:,16),MB,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,10),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,28),MB,G2(:,:,:,63))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64),gZd)
  call loop_A_Q(G2(:,:,:,64),Q(:,60),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,41),wf(:,20),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,60),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,1),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MB,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,41),wf(:,24),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,60),MB,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,1),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MB,G3tensor(:,22))
  call loop_AV_Q(G1(:,:,:,41),wf(:,33),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,51),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,10),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,41),wf(:,37),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,51),MB,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,10),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,24))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,8),ZERO,G1(:,:,:,47))
  call loop_AZ_Q(G1(:,:,:,47),wf(:,3),G1(:,:,:,48),gZd)
  call loop_A_Q(G1(:,:,:,48),Q(:,56),ZERO,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,6),G2tensor(:,1))
  call loop_AV_Q(G2(:,:,:,73),wf(:,1),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,59),ZERO,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-2),G3tensor(:,25))
  call loop_AQ_V(G2(:,:,:,73),wf(:,-2),G2(:,:,:,75))
  call loop_VA_Q(G2(:,:,:,75),wf(:,-1),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,62),ZERO,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,26))
  call loop_AQ_V(G1(:,:,:,47),wf(:,9),G1(:,:,:,49))
  call check_last_UV_W(l_switch,G1(:,:,:,49),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,2))
  call loop_VA_Q(G1(:,:,:,49),wf(:,-1),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,62),ZERO,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,0),G2tensor(:,3))
  call loop_AV_Q(G1(:,:,:,47),wf(:,1),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,11),ZERO,G2(:,:,:,78))
  call loop_AZ_Q(G2(:,:,:,78),wf(:,3),G2(:,:,:,79),gZd)
  call loop_A_Q(G2(:,:,:,79),Q(:,59),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,-2),G3tensor(:,27))
  call loop_AV_Q(G1(:,:,:,47),wf(:,62),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,59),ZERO,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,-2),G2tensor(:,4))
  call loop_AV_Q(G1(:,:,:,47),wf(:,63),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,59),ZERO,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-2),G2tensor(:,5))
  call loop_AQ_V(G1(:,:,:,47),wf(:,-2),G1(:,:,:,54))
  call loop_VQ_A(G1(:,:,:,54),wf(:,16),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,61),ZERO,G2(:,:,:,82))
  call check_last_QA_V(l_switch,G2(:,:,:,82),wf(:,-1),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,54),wf(:,45),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,62),ZERO,G2(:,:,:,83))
  call check_last_AQ_V(l_switch,G2(:,:,:,83),wf(:,0),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,54),wf(:,-1),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,14),ZERO,G2(:,:,:,84))
  call loop_AZ_Q(G2(:,:,:,84),wf(:,3),G2(:,:,:,85),gZd)
  call loop_A_Q(G2(:,:,:,85),Q(:,62),ZERO,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,28))
  call loop_VA_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,11),ZERO,G1(:,:,:,58))
  call loop_AZ_Q(G1(:,:,:,58),wf(:,3),G1(:,:,:,59),gZd)
  call loop_A_Q(G1(:,:,:,59),Q(:,59),ZERO,G2(:,:,:,86))
  call check_last_AQ_V(l_switch,G2(:,:,:,86),wf(:,-2),G2tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,52),ZERO,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,1),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,55),ZERO,G2(:,:,:,87))
  call check_last_QA_V(l_switch,G2(:,:,:,87),wf(:,-3),G2tensor(:,9))
  call loop_QA_V(G1(:,:,:,60),wf(:,-3),G1(:,:,:,62))
  call loop_VA_Q(G1(:,:,:,62),wf(:,-1),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,62),ZERO,G2(:,:,:,88))
  call check_last_AQ_V(l_switch,G2(:,:,:,88),wf(:,0),G2tensor(:,10))
  call check_last_QA_V(l_switch,G1(:,:,:,60),wf(:,28),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,56),ZERO,G1(:,:,:,64))
  call loop_AV_Q(G1(:,:,:,64),wf(:,1),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,59),ZERO,G2(:,:,:,89))
  call check_last_AQ_V(l_switch,G2(:,:,:,89),wf(:,-2),G2tensor(:,11))
  call loop_AQ_V(G1(:,:,:,64),wf(:,-2),G1(:,:,:,66))
  call loop_VA_Q(G1(:,:,:,66),wf(:,-1),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,62),ZERO,G2(:,:,:,90))
  call check_last_AQ_V(l_switch,G2(:,:,:,90),wf(:,0),G2tensor(:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,64),wf(:,6),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,68))
  call loop_QA_V(G1(:,:,:,68),wf(:,30),G1(:,:,:,69))
  call check_last_UV_W(l_switch,G1(:,:,:,69),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,69),wf(:,-1),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,62),ZERO,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,0),G2tensor(:,14))
  call loop_QZ_A(G1(:,:,:,68),wf(:,3),G1(:,:,:,71),gZd)
  call loop_Q_A(G1(:,:,:,71),Q(:,52),ZERO,G2(:,:,:,92))
  call loop_QA_V(G2(:,:,:,92),wf(:,-3),G2(:,:,:,93))
  call check_last_UV_W(l_switch,G2(:,:,:,93),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,29))
  call loop_VA_Q(G2(:,:,:,93),wf(:,-1),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,62),ZERO,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,30))
  call loop_QA_V(G1(:,:,:,68),wf(:,-3),G1(:,:,:,72))
  call loop_VQ_A(G1(:,:,:,72),wf(:,16),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,61),ZERO,G2(:,:,:,95))
  call check_last_QA_V(l_switch,G2(:,:,:,95),wf(:,-1),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,72),wf(:,45),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,62),ZERO,G2(:,:,:,96))
  call check_last_AQ_V(l_switch,G2(:,:,:,96),wf(:,0),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,72),wf(:,-1),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,14),ZERO,G2(:,:,:,97))
  call loop_AZ_Q(G2(:,:,:,97),wf(:,3),G2(:,:,:,98),gZd)
  call loop_A_Q(G2(:,:,:,98),Q(:,62),ZERO,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,0),G3tensor(:,31))
  call loop_VQ_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,13),ZERO,G1(:,:,:,76))
  call loop_QZ_A(G1(:,:,:,76),wf(:,3),G1(:,:,:,77),gZd)
  call loop_Q_A(G1(:,:,:,77),Q(:,61),ZERO,G2(:,:,:,99))
  call check_last_QA_V(l_switch,G2(:,:,:,99),wf(:,-1),G2tensor(:,17))
  call loop_VQ_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,49),ZERO,G1(:,:,:,78))
  call loop_QV_A(G1(:,:,:,78),wf(:,10),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,61),ZERO,G2(:,:,:,100))
  call check_last_QA_V(l_switch,G2(:,:,:,100),wf(:,-1),G2tensor(:,18))
  call check_last_QA_V(l_switch,G1(:,:,:,78),wf(:,47),G1tensor(:,3))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,12),G1(:,:,:,80))
  call loop_VQ_A(G1(:,:,:,80),wf(:,16),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,61),ZERO,G2(:,:,:,101))
  call check_last_QA_V(l_switch,G2(:,:,:,101),wf(:,-1),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,80),wf(:,45),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,62),ZERO,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,0),G2tensor(:,20))
  call loop_VA_Q(G1(:,:,:,80),wf(:,-1),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,14),ZERO,G2(:,:,:,103))
  call loop_AZ_Q(G2(:,:,:,103),wf(:,3),G2(:,:,:,104),gZd)
  call loop_A_Q(G2(:,:,:,104),Q(:,62),ZERO,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,32))
  call loop_VA_Q(G0(:,:,:,1),wf(:,47),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,14),ZERO,G1(:,:,:,84))
  call loop_AZ_Q(G1(:,:,:,84),wf(:,3),G1(:,:,:,85),gZd)
  call loop_A_Q(G1(:,:,:,85),Q(:,62),ZERO,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,0),G2tensor(:,21))
  call loop_VA_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,50),ZERO,G1(:,:,:,86))
  call loop_AV_Q(G1(:,:,:,86),wf(:,10),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,62),ZERO,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,0),G2tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,86),wf(:,13),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,2),ZERO,G1(:,:,:,88))
  call loop_AZ_Q(G1(:,:,:,88),wf(:,3),G1(:,:,:,89),gZd)
  call loop_A_Q(G1(:,:,:,89),Q(:,50),ZERO,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,10),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,62),ZERO,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,0),G3tensor(:,33))
  call loop_AV_Q(G1(:,:,:,88),wf(:,10),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,14),ZERO,G2(:,:,:,109))
  call loop_AZ_Q(G2(:,:,:,109),wf(:,3),G2(:,:,:,110),gZd)
  call loop_A_Q(G2(:,:,:,110),Q(:,62),ZERO,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,0),G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,88),wf(:,64),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,62),ZERO,G2(:,:,:,111))
  call check_last_AQ_V(l_switch,G2(:,:,:,111),wf(:,0),G2tensor(:,23))
  call loop_AV_Q(G1(:,:,:,88),wf(:,65),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,62),ZERO,G2(:,:,:,112))
  call check_last_AQ_V(l_switch,G2(:,:,:,112),wf(:,0),G2tensor(:,24))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,62),Q(:,51),G1(:,:,:,93))
  call loop_VA_Q(G1(:,:,:,93),wf(:,-3),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,59),ZERO,G2(:,:,:,113))
  call check_last_AQ_V(l_switch,G2(:,:,:,113),wf(:,-2),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,93),Q(:,51),wf(:,10),Q(:,12),G2tensor(:,26))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,63),Q(:,51),G1(:,:,:,95))
  call loop_VA_Q(G1(:,:,:,95),wf(:,-3),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,59),ZERO,G2(:,:,:,114))
  call check_last_AQ_V(l_switch,G2(:,:,:,114),wf(:,-2),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,95),Q(:,51),wf(:,10),Q(:,12),G2tensor(:,28))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,64),Q(:,60),G1(:,:,:,97))
  call loop_VA_Q(G1(:,:,:,97),wf(:,-1),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,62),ZERO,G2(:,:,:,115))
  call check_last_AQ_V(l_switch,G2(:,:,:,115),wf(:,0),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,30))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,65),Q(:,60),G1(:,:,:,99))
  call loop_VA_Q(G1(:,:,:,99),wf(:,-1),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),ZERO,G2(:,:,:,116))
  call check_last_AQ_V(l_switch,G2(:,:,:,116),wf(:,0),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,99),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,60),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,1),G1(:,:,:,102))
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,60),MT,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,1),G1(:,:,:,104))
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,63),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,60),MB,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,1),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),MB,G2tensor(:,35))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,64),Q(:,60),G1(:,:,:,107))
  call check_last_CV_D(l_switch,G1(:,:,:,107),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,60),ZERO,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,1),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,63),ZERO,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,60),MT,G1(:,:,:,110))
  call loop_QV_A(G1(:,:,:,110),wf(:,1),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,63),MT,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,60),MB,G1(:,:,:,112))
  call loop_QV_A(G1(:,:,:,112),wf(:,1),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,63),MB,G2tensor(:,39))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,65),Q(:,60),G1(:,:,:,114))
  call check_last_CV_D(l_switch,G1(:,:,:,114),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,62),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,51),ZERO,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,10),G1(:,:,:,116))
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),ZERO,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,62),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,51),MT,G1(:,:,:,117))
  call loop_QV_A(G1(:,:,:,117),wf(:,10),G1(:,:,:,118))
  call check_last_Q_A(l_switch,G1(:,:,:,118),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,62),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,51),MB,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,10),G1(:,:,:,120))
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),MB,G2tensor(:,43))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,62),Q(:,51),G1(:,:,:,121))
  call check_last_CV_D(l_switch,G1(:,:,:,121),Q(:,51),wf(:,10),Q(:,12),G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,51),ZERO,G1(:,:,:,122))
  call loop_QV_A(G1(:,:,:,122),wf(:,10),G1(:,:,:,123))
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,63),ZERO,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,51),MT,G1(:,:,:,124))
  call loop_QV_A(G1(:,:,:,124),wf(:,10),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),MT,G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,63),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,51),MB,G1(:,:,:,126))
  call loop_QV_A(G1(:,:,:,126),wf(:,10),G1(:,:,:,127))
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),MB,G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,63),Q(:,51),G1(:,:,:,128))
  call check_last_CV_D(l_switch,G1(:,:,:,128),Q(:,51),wf(:,10),Q(:,12),G2tensor(:,48))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(60)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(60)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(60)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(60)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(60)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(60)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(60)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(60)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(16)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(16)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(21)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(21)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(21)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(21)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(24)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(24)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(24)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(24)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,22)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(5)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(27)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(8)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(8)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(30)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(30)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(61)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(61)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(61)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(34)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(34)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(34)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(34)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(37)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(21)*M(1)-c(20)*M(2)) * den(37)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(37)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(19)*M(1)-c(18)*M(2)) * den(37)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(15)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(15)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(43)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(40)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(40)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(62)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(62)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,34)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(62)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(55)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(55)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(56)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(56)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(14)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(14)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(39)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(39)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(58)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(58)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(6)*M(1)-c(5)*M(2)) * den(59)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(59)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(7)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(7)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(29)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(29)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(2)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(2)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(7)*M(1)-c(9)*M(2)) * den(2)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(11)*M(1))-c(5)*M(2)) * den(2)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(47)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(48)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(63)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(63)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(63)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(63)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(63)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(63)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(64)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(64)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(64)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(64)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(64)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(64)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(65)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(65)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(65)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(65)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(65)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(65)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(66)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(66)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(66)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(66)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(13)*M(1)-c(10)*M(2)) * den(66)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(66)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(49)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(12)*M(1))+c(8)*M(2)) * den(50)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,3)

end subroutine vamp_1

end module ol_vamp_1_pphzjj_ddxssxhz_1_/**/REALKIND
