
module ol_colourmatrix_pphzjj_bbxhzgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,3), KL(2,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  48,  -6]
  K1( 2,:) = [  -6,  48]
  K1( 3,:) = [  64,  -8]
  K1( 4,:) = [  -8,  64]
  K1( 5,:) = [  -1, -10]
  K1( 6,:) = [ -10,  -1]
  K1( 7,:) = [  64,  -8]
  K1( 8,:) = [  -8,  64]
  K1( 9,:) = [   0,   0]
  K1(10,:) = [   0,   0]
  K1(11,:) = [   0,   0]
  K1(12,:) = [   0,   0]
  K1(13,:) = [   0,   0]
  K1(14,:) = [   0,   0]
  K1(15,:) = [   0,   0]
  K1(16,:) = [   0,   0]
  K1(17,:) = [   0,   0]
  K1(18,:) = [   0,   0]
  K1(19,:) = [   0,   0]
  K1(20,:) = [   0,   0]
  K1(21,:) = [   0,   0]
  K1(22,:) = [   0,   0]
  K1(23,:) = [   9,   9]
  K1(24,:) = [   9, -72]
  K1(25,:) = [ -72,   9]
  K1(26,:) = [   9,   9]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [ 144, -18]
  K1(32,:) = [ -18, 144]
  K1(33,:) = [ -72,   9]
  K1(34,:) = [   9,   9]
  K1(35,:) = [   9,   9]
  K1(36,:) = [   9, -72]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [ -81,   0]
  K1(42,:) = [   0, -81]
  K1(43,:) = [ 144, -18]
  K1(44,:) = [ -18, 144]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 16, -2,  6]
  K2(2,:) = [ -2, 16,  6]
  K2 = (1._/**/REALKIND / 3) * K2

  KL(1,:) = [ 16, -2,  6]
  KL(2,:) = [ -2, 16,  6]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphzjj_bbxhzgg_1_/**/REALKIND



module ol_forced_parameters_pphzjj_bbxhzgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphzjj_bbxhzgg_1_/**/REALKIND

module ol_loop_pphzjj_bbxhzgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(44), c(37)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:453)
  ! denominators
  complex(REALKIND), save :: den(517)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(2,48)
  ! zero helicity identifier
  logical,           save :: zerohel(48) = .true., zerohel_ct(48) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2*lambdaHZZ*MW)/(cw**2*sw)
    f( 2) = (eQED**2*gQCD**2*lambdaHZZ*MW)/(cw**2*sw)
    f( 3) = (CI*countertermnorm*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 4) = (countertermnorm*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 5) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 6) = (countertermnorm*ctGbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 7) = (CI*countertermnorm*ctVbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 8) = (countertermnorm*ctVbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 9) = (countertermnorm*ctVVV*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f(10) = (CI*countertermnorm*ctZGG*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f(11) = (countertermnorm*ctZGG*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f(12) = (CI*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(2._/**/REALKIND*cw**2*sw)
    f(13) = (CI*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw)
    f(14) = (eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw)
    f(15) = (CI*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(16) = (2*CI*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(17) = (eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(18) = (2*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(19) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MB*YB)/MQ2sum
    f(20) = (countertermnorm*ctHGG*eQED**2*gQCD**4*MB*YB)/MQ2sum
    f(21) = (CI*eQED**2*gQCD**2*YB)/(2._/**/REALKIND*MW*sw)
    f(22) = (eQED**2*gQCD**2*YB)/(MW*sw*2._/**/REALKIND)
    f(23) = (CI*countertermnorm*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(24) = (countertermnorm*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(25) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(26) = (countertermnorm*ctGbb*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(27) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(28) = (countertermnorm*ctSbb*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(29) = (CI*countertermnorm*ctVbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(30) = (countertermnorm*ctVbb*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(31) = (countertermnorm*ctVVV*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(32) = (CI*countertermnorm*ctZGG*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(33) = (countertermnorm*ctZGG*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(34) = (CI*eQED**2*gQCD**4*integralnorm*SwB*YB)/(4._/**/REALKIND*MW*sw)
    f(35) = (CI*eQED**2*gQCD**4*integralnorm*SwB*YB)/(2._/**/REALKIND*MW*sw)
    f(36) = (eQED**2*gQCD**4*integralnorm*SwB*YB)/(MW*sw*2._/**/REALKIND)
    f(37) = (CI*eQED**2*gQCD**4*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f(38) = (CI*eQED**2*gQCD**4*integralnorm*SwF*YB)/(MW*sw)
    f(39) = (eQED**2*gQCD**4*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f(40) = (eQED**2*gQCD**4*integralnorm*SwF*YB)/(MW*sw)
    f(41) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MT*YT)/MQ2sum
    f(42) = (countertermnorm*ctHGG*eQED**2*gQCD**4*MT*YT)/MQ2sum
    f(43) = (CI*eQED**2*gQCD**4*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(44) = (eQED**2*gQCD**4*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)

  c = [ 9*CI*f(12), 18*CI*f(12), CI*f(13), 3*CI*f(13), 8*CI*f(13), 9*CI*f(13), 18*CI*f(13), f(14), 3*f(14), 8*f(14), 9*f(14) &
    , 3*CI*f(15), 3*CI*f(16), f(17), 3*f(17), f(18), 3*f(18), 9*CI*f(34), 18*CI*f(34), CI*f(35), 3*CI*f(35), 8*CI*f(35) &
    , 9*CI*f(35), 18*CI*f(35), f(36), 3*f(36), 8*f(36), 9*f(36), 3*CI*f(37), 3*CI*f(38), f(39), 3*f(39), f(40), 3*f(40) &
    , 3*CI*f(43), f(44), 3*f(44) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(2), M2(3)
  complex(REALKIND) :: A(355)
  ! external WFs
  call wf_Q(P(:,1), rMB, H(1), wf(:,0))
  call wf_A(P(:,2), rMB, H(2), wf(:,-1))
  call wf_S(P(:,3), rMH, H(3), wf(:,-2))
  call wf_V(P(:,4), rMZ, H(4), wf(:,-3))
  call wf_V(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))

  ! internal WFs
  call vert_QS_A(gH,wf(:,0),wf(:,-2),wf(:,1))
  call vert_AZ_Q(gZd,wf(:,-1),wf(:,-3),wf(:,2))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call prop_Q_A(wf(:,1),Q(:,5),MB,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,2),Q(:,10),MB,1_intkind1,wf(:,5))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,6))
  call vert_VQ_A(wf(:,-4),wf(:,4),wf(:,7))
  call vert_AV_Q(wf(:,5),wf(:,-5),wf(:,8))
  call prop_Q_A(wf(:,7),Q(:,21),MB,1_intkind1,wf(:,9))
  call vert_AV_Q(wf(:,5),wf(:,-4),wf(:,10))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,26),MB,1_intkind1,wf(:,12))
  call vert_AV_Q(wf(:,-1),wf(:,-4),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,18),MB,1_intkind1,wf(:,14))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,4),wf(:,15))
  call vert_AV_Q(wf(:,14),wf(:,-5),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,13),MB,1_intkind1,wf(:,17))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,-3),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,26),MB,1_intkind1,wf(:,19))
  call vert_AV_Q(wf(:,-1),wf(:,-5),wf(:,20))
  call prop_A_Q(wf(:,20),Q(:,34),MB,1_intkind1,wf(:,21))
  call vert_AV_Q(wf(:,21),wf(:,-4),wf(:,22))
  call vert_AZ_Q(gZd,wf(:,21),wf(:,-3),wf(:,23))
  call prop_A_Q(wf(:,23),Q(:,42),MB,1_intkind1,wf(:,24))
  call vert_AV_Q(wf(:,-1),wf(:,3),wf(:,25))
  call prop_A_Q(wf(:,25),Q(:,50),MB,1_intkind1,wf(:,26))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,0),wf(:,27))
  call vert_SA_Q(gH,wf(:,-2),wf(:,-1),wf(:,28))
  call prop_Q_A(wf(:,27),Q(:,9),MB,1_intkind1,wf(:,29))
  call prop_A_Q(wf(:,28),Q(:,6),MB,1_intkind1,wf(:,30))
  call vert_QA_V(wf(:,29),wf(:,30),wf(:,31))
  call vert_VQ_A(wf(:,-4),wf(:,29),wf(:,32))
  call vert_AV_Q(wf(:,30),wf(:,-5),wf(:,33))
  call prop_Q_A(wf(:,32),Q(:,25),MB,1_intkind1,wf(:,34))
  call vert_AV_Q(wf(:,30),wf(:,-4),wf(:,35))
  call vert_VQ_A(wf(:,-5),wf(:,29),wf(:,36))
  call prop_A_Q(wf(:,35),Q(:,22),MB,1_intkind1,wf(:,37))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,38))
  call prop_Q_A(wf(:,38),Q(:,17),MB,1_intkind1,wf(:,39))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,39),wf(:,40))
  call prop_Q_A(wf(:,40),Q(:,25),MB,1_intkind1,wf(:,41))
  call vert_AZ_Q(gZd,wf(:,30),wf(:,-3),wf(:,42))
  call vert_VQ_A(wf(:,-5),wf(:,39),wf(:,43))
  call prop_A_Q(wf(:,42),Q(:,14),MB,1_intkind1,wf(:,44))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,45))
  call prop_Q_A(wf(:,45),Q(:,33),MB,1_intkind1,wf(:,46))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,46),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,41),MB,1_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,-4),wf(:,46),wf(:,49))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,50))
  call prop_Q_A(wf(:,50),Q(:,49),MB,1_intkind1,wf(:,51))
  call vert_QS_A(gH,wf(:,29),wf(:,-2),wf(:,52))
  call prop_Q_A(wf(:,52),Q(:,13),MB,1_intkind1,wf(:,53))
  call vert_SA_Q(gH,wf(:,-2),wf(:,14),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,22),MB,1_intkind1,wf(:,55))
  call vert_SA_Q(gH,wf(:,-2),wf(:,21),wf(:,56))
  call prop_A_Q(wf(:,56),Q(:,38),MB,1_intkind1,wf(:,57))
  call vert_QS_A(gH,wf(:,39),wf(:,-2),wf(:,58))
  call prop_Q_A(wf(:,58),Q(:,21),MB,1_intkind1,wf(:,59))
  call vert_SA_Q(gH,wf(:,-2),wf(:,5),wf(:,60))
  call prop_A_Q(wf(:,60),Q(:,14),MB,1_intkind1,wf(:,61))
  call vert_QS_A(gH,wf(:,46),wf(:,-2),wf(:,62))
  call prop_Q_A(wf(:,62),Q(:,37),MB,1_intkind1,wf(:,63))
  call vert_SV_V(wf(:,-2),wf(:,-3),wf(:,64))
  call prop_W_W(wf(:,64),Q(:,12),MZ,1_intkind1,wf(:,65))
  call vert_QA_Z(gZd,wf(:,39),wf(:,21),wf(:,66))
  call vert_AZ_Q(gZd,wf(:,-1),wf(:,65),wf(:,67))
  call prop_A_Q(wf(:,67),Q(:,14),MB,1_intkind1,wf(:,68))
  call vert_QA_Z(gZd,wf(:,46),wf(:,14),wf(:,69))
  call vert_ZQ_A(gZd,wf(:,65),wf(:,0),wf(:,70))
  call prop_Q_A(wf(:,70),Q(:,13),MB,1_intkind1,wf(:,71))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,72))
  call counter_GGG_V(ctZGGG,wf(:,72),wf(:,-4),wf(:,-5),wf(:,73))
  call counter_GGG_V(ctZGGG,wf(:,72),wf(:,-5),wf(:,-4),wf(:,74))
  call counter_VGG_G(ctZGGG,wf(:,-3),wf(:,-4),wf(:,-5),wf(:,75))
  call vert_QA_V(wf(:,4),wf(:,-1),wf(:,76))
  call counter_VGG_G(ctZGGG,wf(:,-3),wf(:,-5),wf(:,-4),wf(:,77))
  call vert_QA_V(wf(:,0),wf(:,30),wf(:,78))
  call counter_VG_G(wf(:,65),wf(:,72),Q(:,3),wf(:,79),Q(:,15))
  call vert_UV_W(wf(:,72),Q(:,3),wf(:,-4),Q(:,16),wf(:,80))
  call counter_VG_G(wf(:,65),wf(:,-5),Q(:,32),wf(:,81),Q(:,44))
  call vert_UV_W(wf(:,72),Q(:,3),wf(:,-5),Q(:,32),wf(:,82))
  call counter_VG_G(wf(:,65),wf(:,-4),Q(:,16),wf(:,83),Q(:,28))
  call counter_QA_V(wf(:,4),wf(:,5),wf(:,84))
  call counter_AV_Q(wf(:,5),wf(:,-5),wf(:,85))
  call counter_VQ_A(wf(:,-5),wf(:,4),wf(:,86))
  call counter_AV_Q(wf(:,5),wf(:,-4),wf(:,87))
  call prop_Q_A(wf(:,11),Q(:,37),MB,1_intkind1,wf(:,88))
  call counter_VQ_A(wf(:,-4),wf(:,4),wf(:,89))
  call prop_A_Q(wf(:,8),Q(:,42),MB,1_intkind1,wf(:,90))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,91))
  call counter_AV_Q(wf(:,14),wf(:,-5),wf(:,92))
  call counter_AV_Q(wf(:,21),wf(:,-4),wf(:,93))
  call vert_AV_Q(wf(:,-1),wf(:,91),wf(:,94))
  call prop_A_Q(wf(:,94),Q(:,50),MB,1_intkind1,wf(:,95))
  call counter_AZ_Q(gZd,wf(:,14),wf(:,-3),wf(:,96))
  call counter_ZQ_A(gZd,wf(:,-3),wf(:,4),wf(:,97))
  call prop_A_Q(wf(:,16),Q(:,50),MB,1_intkind1,wf(:,98))
  call counter_VG_G(wf(:,-3),wf(:,-5),Q(:,32),wf(:,99),Q(:,40))
  call vert_QA_V(wf(:,4),wf(:,14),wf(:,100))
  call counter_AZ_Q(gZd,wf(:,21),wf(:,-3),wf(:,101))
  call prop_A_Q(wf(:,22),Q(:,50),MB,1_intkind1,wf(:,102))
  call counter_VG_G(wf(:,-3),wf(:,3),Q(:,48),wf(:,103),Q(:,56))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,99),Q(:,40),wf(:,104))
  call vert_AV_Q(wf(:,-1),wf(:,99),wf(:,105))
  call prop_A_Q(wf(:,105),Q(:,42),MB,1_intkind1,wf(:,106))
  call counter_VG_G(wf(:,-3),wf(:,-4),Q(:,16),wf(:,107),Q(:,24))
  call vert_QA_V(wf(:,4),wf(:,21),wf(:,108))
  call vert_UV_W(wf(:,107),Q(:,24),wf(:,-5),Q(:,32),wf(:,109))
  call vert_AV_Q(wf(:,-1),wf(:,107),wf(:,110))
  call prop_A_Q(wf(:,110),Q(:,26),MB,1_intkind1,wf(:,111))
  call counter_QA_V(wf(:,29),wf(:,30),wf(:,112))
  call counter_AV_Q(wf(:,30),wf(:,-5),wf(:,113))
  call counter_VQ_A(wf(:,-5),wf(:,29),wf(:,114))
  call counter_AV_Q(wf(:,30),wf(:,-4),wf(:,115))
  call prop_Q_A(wf(:,36),Q(:,41),MB,1_intkind1,wf(:,116))
  call counter_VQ_A(wf(:,-4),wf(:,29),wf(:,117))
  call prop_A_Q(wf(:,33),Q(:,38),MB,1_intkind1,wf(:,118))
  call counter_VQ_A(wf(:,-5),wf(:,39),wf(:,119))
  call counter_VQ_A(wf(:,-4),wf(:,46),wf(:,120))
  call vert_VQ_A(wf(:,91),wf(:,0),wf(:,121))
  call prop_Q_A(wf(:,121),Q(:,49),MB,1_intkind1,wf(:,122))
  call counter_AZ_Q(gZd,wf(:,30),wf(:,-3),wf(:,123))
  call prop_Q_A(wf(:,43),Q(:,49),MB,1_intkind1,wf(:,124))
  call counter_ZQ_A(gZd,wf(:,-3),wf(:,39),wf(:,125))
  call vert_QA_V(wf(:,39),wf(:,30),wf(:,126))
  call prop_Q_A(wf(:,49),Q(:,49),MB,1_intkind1,wf(:,127))
  call counter_ZQ_A(gZd,wf(:,-3),wf(:,46),wf(:,128))
  call vert_VQ_A(wf(:,99),wf(:,0),wf(:,129))
  call prop_Q_A(wf(:,129),Q(:,41),MB,1_intkind1,wf(:,130))
  call vert_QA_V(wf(:,46),wf(:,30),wf(:,131))
  call vert_VQ_A(wf(:,107),wf(:,0),wf(:,132))
  call prop_Q_A(wf(:,132),Q(:,25),MB,1_intkind1,wf(:,133))
  call counter_QA_Z(gZd,wf(:,39),wf(:,21),wf(:,134))
  call vert_QA_V(wf(:,39),wf(:,-1),wf(:,135))
  call counter_QA_Z(gZd,wf(:,46),wf(:,14),wf(:,136))
  call vert_QA_V(wf(:,0),wf(:,14),wf(:,137))
  call vert_QA_V(wf(:,46),wf(:,-1),wf(:,138))
  call vert_QA_V(wf(:,0),wf(:,21),wf(:,139))
  call counter_SA_Q(gH,wf(:,-2),wf(:,14),wf(:,140))
  call counter_QS_A(gH,wf(:,29),wf(:,-2),wf(:,141))
  call counter_SG_G(wf(:,-2),wf(:,-5),wf(:,142))
  call vert_QA_V(wf(:,29),wf(:,14),wf(:,143))
  call counter_SA_Q(gH,wf(:,-2),wf(:,21),wf(:,144))
  call vert_QA_V(wf(:,29),wf(:,-1),wf(:,145))
  call counter_SG_G(wf(:,-2),wf(:,3),wf(:,146))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,142),Q(:,36),wf(:,147))
  call vert_AV_Q(wf(:,-1),wf(:,142),wf(:,148))
  call prop_A_Q(wf(:,148),Q(:,38),MB,1_intkind1,wf(:,149))
  call counter_SG_G(wf(:,-2),wf(:,-4),wf(:,150))
  call vert_QA_V(wf(:,29),wf(:,21),wf(:,151))
  call vert_UV_W(wf(:,150),Q(:,20),wf(:,-5),Q(:,32),wf(:,152))
  call vert_AV_Q(wf(:,-1),wf(:,150),wf(:,153))
  call prop_A_Q(wf(:,153),Q(:,22),MB,1_intkind1,wf(:,154))
  call counter_SA_Q(gH,wf(:,-2),wf(:,5),wf(:,155))
  call counter_QS_A(gH,wf(:,39),wf(:,-2),wf(:,156))
  call vert_QA_V(wf(:,39),wf(:,5),wf(:,157))
  call counter_QS_A(gH,wf(:,46),wf(:,-2),wf(:,158))
  call vert_QA_V(wf(:,0),wf(:,5),wf(:,159))
  call vert_VQ_A(wf(:,142),wf(:,0),wf(:,160))
  call prop_Q_A(wf(:,160),Q(:,37),MB,1_intkind1,wf(:,161))
  call vert_QA_V(wf(:,46),wf(:,5),wf(:,162))
  call vert_VQ_A(wf(:,150),wf(:,0),wf(:,163))
  call prop_Q_A(wf(:,163),Q(:,21),MB,1_intkind1,wf(:,164))
  call counter_AV_Q(wf(:,-1),wf(:,3),wf(:,165))
  call counter_AV_Q(wf(:,-1),wf(:,-5),wf(:,166))
  call prop_A_Q(wf(:,166),Q(:,34),MB,1_intkind1,wf(:,167))
  call vert_AV_Q(wf(:,167),wf(:,-4),wf(:,168))
  call vert_AZ_Q(gZd,wf(:,167),wf(:,-3),wf(:,169))
  call prop_A_Q(wf(:,169),Q(:,42),MB,1_intkind1,wf(:,170))
  call counter_AV_Q(wf(:,-1),wf(:,-4),wf(:,171))
  call prop_A_Q(wf(:,171),Q(:,18),MB,1_intkind1,wf(:,172))
  call vert_AV_Q(wf(:,172),wf(:,-5),wf(:,173))
  call vert_AZ_Q(gZd,wf(:,172),wf(:,-3),wf(:,174))
  call prop_A_Q(wf(:,174),Q(:,26),MB,1_intkind1,wf(:,175))
  call counter_AZ_Q(gZd,wf(:,-1),wf(:,-3),wf(:,176))
  call prop_A_Q(wf(:,176),Q(:,10),MB,1_intkind1,wf(:,177))
  call vert_QA_V(wf(:,4),wf(:,177),wf(:,178))
  call vert_AV_Q(wf(:,177),wf(:,-5),wf(:,179))
  call vert_AV_Q(wf(:,177),wf(:,-4),wf(:,180))
  call prop_A_Q(wf(:,180),Q(:,26),MB,1_intkind1,wf(:,181))
  call vert_SA_Q(gH,wf(:,-2),wf(:,167),wf(:,182))
  call prop_A_Q(wf(:,182),Q(:,38),MB,1_intkind1,wf(:,183))
  call vert_SA_Q(gH,wf(:,-2),wf(:,172),wf(:,184))
  call prop_A_Q(wf(:,184),Q(:,22),MB,1_intkind1,wf(:,185))
  call counter_AZ_Q(gZd,wf(:,-1),wf(:,65),wf(:,186))
  call vert_QA_Z(gZd,wf(:,39),wf(:,167),wf(:,187))
  call vert_QA_Z(gZd,wf(:,46),wf(:,172),wf(:,188))
  call vert_SA_Q(gH,wf(:,-2),wf(:,177),wf(:,189))
  call prop_A_Q(wf(:,189),Q(:,14),MB,1_intkind1,wf(:,190))
  call counter_SA_Q(gH,wf(:,-2),wf(:,-1),wf(:,191))
  call prop_A_Q(wf(:,191),Q(:,6),MB,1_intkind1,wf(:,192))
  call vert_QA_V(wf(:,29),wf(:,192),wf(:,193))
  call vert_AV_Q(wf(:,192),wf(:,-5),wf(:,194))
  call vert_AV_Q(wf(:,192),wf(:,-4),wf(:,195))
  call prop_A_Q(wf(:,195),Q(:,22),MB,1_intkind1,wf(:,196))
  call vert_AZ_Q(gZd,wf(:,192),wf(:,-3),wf(:,197))
  call prop_A_Q(wf(:,197),Q(:,14),MB,1_intkind1,wf(:,198))
  call counter_VQ_A(wf(:,3),wf(:,0),wf(:,199))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,200))
  call prop_Q_A(wf(:,200),Q(:,33),MB,1_intkind1,wf(:,201))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,201),wf(:,202))
  call prop_Q_A(wf(:,202),Q(:,41),MB,1_intkind1,wf(:,203))
  call vert_VQ_A(wf(:,-4),wf(:,201),wf(:,204))
  call counter_VQ_A(wf(:,-4),wf(:,0),wf(:,205))
  call prop_Q_A(wf(:,205),Q(:,17),MB,1_intkind1,wf(:,206))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,206),wf(:,207))
  call prop_Q_A(wf(:,207),Q(:,25),MB,1_intkind1,wf(:,208))
  call vert_VQ_A(wf(:,-5),wf(:,206),wf(:,209))
  call counter_ZQ_A(gZd,wf(:,-3),wf(:,0),wf(:,210))
  call prop_Q_A(wf(:,210),Q(:,9),MB,1_intkind1,wf(:,211))
  call vert_QA_V(wf(:,211),wf(:,30),wf(:,212))
  call vert_VQ_A(wf(:,-4),wf(:,211),wf(:,213))
  call prop_Q_A(wf(:,213),Q(:,25),MB,1_intkind1,wf(:,214))
  call vert_VQ_A(wf(:,-5),wf(:,211),wf(:,215))
  call vert_QS_A(gH,wf(:,201),wf(:,-2),wf(:,216))
  call prop_Q_A(wf(:,216),Q(:,37),MB,1_intkind1,wf(:,217))
  call vert_QS_A(gH,wf(:,206),wf(:,-2),wf(:,218))
  call prop_Q_A(wf(:,218),Q(:,21),MB,1_intkind1,wf(:,219))
  call counter_ZQ_A(gZd,wf(:,65),wf(:,0),wf(:,220))
  call vert_QA_Z(gZd,wf(:,201),wf(:,14),wf(:,221))
  call vert_QA_Z(gZd,wf(:,206),wf(:,21),wf(:,222))
  call vert_QS_A(gH,wf(:,211),wf(:,-2),wf(:,223))
  call prop_Q_A(wf(:,223),Q(:,13),MB,1_intkind1,wf(:,224))
  call counter_QS_A(gH,wf(:,0),wf(:,-2),wf(:,225))
  call prop_Q_A(wf(:,225),Q(:,5),MB,1_intkind1,wf(:,226))
  call vert_QA_V(wf(:,226),wf(:,5),wf(:,227))
  call vert_VQ_A(wf(:,-4),wf(:,226),wf(:,228))
  call prop_Q_A(wf(:,228),Q(:,21),MB,1_intkind1,wf(:,229))
  call vert_VQ_A(wf(:,-5),wf(:,226),wf(:,230))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,226),wf(:,231))
  call prop_Q_A(wf(:,231),Q(:,13),MB,1_intkind1,wf(:,232))
  call vert_AV_Q(wf(:,5),wf(:,3),wf(:,233))
  call counter_Q_A(ctbb,wf(:,4),Q(:,5),wf(:,234))
  call prop_A_Q(wf(:,233),Q(:,58),MB,1_intkind1,wf(:,235))
  call vert_VQ_A(wf(:,3),wf(:,4),wf(:,236))
  call counter_A_Q(ctbb,wf(:,5),Q(:,10),wf(:,237))
  call prop_Q_A(wf(:,236),Q(:,53),MB,1_intkind1,wf(:,238))
  call counter_V_V(ctGG,wf(:,3),Q(:,48),wf(:,239))
  call prop_Q_A(wf(:,234),Q(:,5),MB,1_intkind1,wf(:,240))
  call vert_VQ_A(wf(:,-4),wf(:,240),wf(:,241))
  call vert_VQ_A(wf(:,-5),wf(:,240),wf(:,242))
  call prop_A_Q(wf(:,237),Q(:,10),MB,1_intkind1,wf(:,243))
  call vert_AV_Q(wf(:,243),wf(:,-4),wf(:,244))
  call vert_AV_Q(wf(:,243),wf(:,-5),wf(:,245))
  call counter_Q_A(ctbb,wf(:,9),Q(:,21),wf(:,246))
  call counter_A_Q(ctbb,wf(:,12),Q(:,26),wf(:,247))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,240),wf(:,248))
  call counter_A_Q(ctbb,wf(:,14),Q(:,18),wf(:,249))
  call prop_A_Q(wf(:,249),Q(:,18),MB,1_intkind1,wf(:,250))
  call vert_AZ_Q(gZd,wf(:,250),wf(:,-3),wf(:,251))
  call vert_AV_Q(wf(:,250),wf(:,-5),wf(:,252))
  call counter_Q_A(ctbb,wf(:,17),Q(:,13),wf(:,253))
  call counter_A_Q(ctbb,wf(:,19),Q(:,26),wf(:,254))
  call counter_A_Q(ctbb,wf(:,21),Q(:,34),wf(:,255))
  call prop_A_Q(wf(:,255),Q(:,34),MB,1_intkind1,wf(:,256))
  call vert_AZ_Q(gZd,wf(:,256),wf(:,-3),wf(:,257))
  call vert_AV_Q(wf(:,256),wf(:,-4),wf(:,258))
  call counter_A_Q(ctbb,wf(:,24),Q(:,42),wf(:,259))
  call counter_A_Q(ctbb,wf(:,26),Q(:,50),wf(:,260))
  call vert_AV_Q(wf(:,-1),wf(:,239),wf(:,261))
  call vert_AV_Q(wf(:,30),wf(:,3),wf(:,262))
  call counter_Q_A(ctbb,wf(:,29),Q(:,9),wf(:,263))
  call prop_A_Q(wf(:,262),Q(:,54),MB,1_intkind1,wf(:,264))
  call vert_VQ_A(wf(:,3),wf(:,29),wf(:,265))
  call counter_A_Q(ctbb,wf(:,30),Q(:,6),wf(:,266))
  call prop_Q_A(wf(:,265),Q(:,57),MB,1_intkind1,wf(:,267))
  call prop_Q_A(wf(:,263),Q(:,9),MB,1_intkind1,wf(:,268))
  call vert_VQ_A(wf(:,-4),wf(:,268),wf(:,269))
  call vert_VQ_A(wf(:,-5),wf(:,268),wf(:,270))
  call prop_A_Q(wf(:,266),Q(:,6),MB,1_intkind1,wf(:,271))
  call vert_AV_Q(wf(:,271),wf(:,-4),wf(:,272))
  call vert_AV_Q(wf(:,271),wf(:,-5),wf(:,273))
  call counter_Q_A(ctbb,wf(:,34),Q(:,25),wf(:,274))
  call counter_A_Q(ctbb,wf(:,37),Q(:,22),wf(:,275))
  call counter_Q_A(ctbb,wf(:,39),Q(:,17),wf(:,276))
  call prop_Q_A(wf(:,276),Q(:,17),MB,1_intkind1,wf(:,277))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,277),wf(:,278))
  call vert_VQ_A(wf(:,-5),wf(:,277),wf(:,279))
  call vert_AZ_Q(gZd,wf(:,271),wf(:,-3),wf(:,280))
  call counter_Q_A(ctbb,wf(:,41),Q(:,25),wf(:,281))
  call counter_A_Q(ctbb,wf(:,44),Q(:,14),wf(:,282))
  call counter_Q_A(ctbb,wf(:,46),Q(:,33),wf(:,283))
  call prop_Q_A(wf(:,283),Q(:,33),MB,1_intkind1,wf(:,284))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,284),wf(:,285))
  call vert_VQ_A(wf(:,-4),wf(:,284),wf(:,286))
  call counter_Q_A(ctbb,wf(:,48),Q(:,41),wf(:,287))
  call counter_Q_A(ctbb,wf(:,51),Q(:,49),wf(:,288))
  call vert_VQ_A(wf(:,239),wf(:,0),wf(:,289))
  call vert_QS_A(gH,wf(:,268),wf(:,-2),wf(:,290))
  call vert_SA_Q(gH,wf(:,-2),wf(:,250),wf(:,291))
  call counter_Q_A(ctbb,wf(:,53),Q(:,13),wf(:,292))
  call counter_A_Q(ctbb,wf(:,55),Q(:,22),wf(:,293))
  call vert_SA_Q(gH,wf(:,-2),wf(:,256),wf(:,294))
  call counter_A_Q(ctbb,wf(:,57),Q(:,38),wf(:,295))
  call vert_QS_A(gH,wf(:,277),wf(:,-2),wf(:,296))
  call vert_SA_Q(gH,wf(:,-2),wf(:,243),wf(:,297))
  call counter_Q_A(ctbb,wf(:,59),Q(:,21),wf(:,298))
  call counter_A_Q(ctbb,wf(:,61),Q(:,14),wf(:,299))
  call vert_QS_A(gH,wf(:,284),wf(:,-2),wf(:,300))
  call counter_Q_A(ctbb,wf(:,63),Q(:,37),wf(:,301))
  call vert_AZ_Q(gZd,wf(:,21),wf(:,65),wf(:,302))
  call prop_A_Q(wf(:,302),Q(:,46),MB,1_intkind1,wf(:,303))
  call vert_ZQ_A(gZd,wf(:,65),wf(:,39),wf(:,304))
  call prop_Q_A(wf(:,304),Q(:,29),MB,1_intkind1,wf(:,305))
  call counter_A_Q(ctbb,wf(:,68),Q(:,14),wf(:,306))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,65),wf(:,307))
  call prop_A_Q(wf(:,307),Q(:,30),MB,1_intkind1,wf(:,308))
  call vert_ZQ_A(gZd,wf(:,65),wf(:,46),wf(:,309))
  call prop_Q_A(wf(:,309),Q(:,45),MB,1_intkind1,wf(:,310))
  call counter_Q_A(ctbb,wf(:,71),Q(:,13),wf(:,311))
  call vert_UV_W(wf(:,76),Q(:,7),wf(:,-4),Q(:,16),wf(:,312))
  call vert_UV_W(wf(:,76),Q(:,7),wf(:,-5),Q(:,32),wf(:,313))
  call vert_QA_V(wf(:,17),wf(:,-1),wf(:,314))
  call vert_VQ_A(wf(:,-4),wf(:,17),wf(:,315))
  call prop_Q_A(wf(:,315),Q(:,29),MB,1_intkind1,wf(:,316))
  call vert_VQ_A(wf(:,-5),wf(:,17),wf(:,317))
  call prop_Q_A(wf(:,317),Q(:,45),MB,1_intkind1,wf(:,318))
  call vert_QA_V(wf(:,9),wf(:,-1),wf(:,319))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,9),wf(:,320))
  call prop_Q_A(wf(:,320),Q(:,29),MB,1_intkind1,wf(:,321))
  call vert_VQ_A(wf(:,-5),wf(:,9),wf(:,322))
  call prop_Q_A(wf(:,322),Q(:,53),MB,1_intkind1,wf(:,323))
  call vert_QA_V(wf(:,88),wf(:,-1),wf(:,324))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,88),wf(:,325))
  call prop_Q_A(wf(:,325),Q(:,45),MB,1_intkind1,wf(:,326))
  call vert_VQ_A(wf(:,-4),wf(:,88),wf(:,327))
  call prop_Q_A(wf(:,327),Q(:,53),MB,1_intkind1,wf(:,328))
  call vert_UV_W(wf(:,78),Q(:,7),wf(:,-4),Q(:,16),wf(:,329))
  call vert_UV_W(wf(:,78),Q(:,7),wf(:,-5),Q(:,32),wf(:,330))
  call vert_QA_V(wf(:,0),wf(:,44),wf(:,331))
  call vert_QA_V(wf(:,0),wf(:,37),wf(:,332))
  call vert_QA_V(wf(:,0),wf(:,118),wf(:,333))
  call vert_AV_Q(wf(:,44),wf(:,-4),wf(:,334))
  call prop_A_Q(wf(:,334),Q(:,30),MB,1_intkind1,wf(:,335))
  call vert_AV_Q(wf(:,44),wf(:,-5),wf(:,336))
  call prop_A_Q(wf(:,336),Q(:,46),MB,1_intkind1,wf(:,337))
  call vert_AZ_Q(gZd,wf(:,37),wf(:,-3),wf(:,338))
  call prop_A_Q(wf(:,338),Q(:,30),MB,1_intkind1,wf(:,339))
  call vert_AV_Q(wf(:,37),wf(:,-5),wf(:,340))
  call prop_A_Q(wf(:,340),Q(:,54),MB,1_intkind1,wf(:,341))
  call vert_AZ_Q(gZd,wf(:,118),wf(:,-3),wf(:,342))
  call prop_A_Q(wf(:,342),Q(:,46),MB,1_intkind1,wf(:,343))
  call vert_AV_Q(wf(:,118),wf(:,-4),wf(:,344))
  call prop_A_Q(wf(:,344),Q(:,54),MB,1_intkind1,wf(:,345))
  call vert_UV_W(wf(:,145),Q(:,11),wf(:,-4),Q(:,16),wf(:,346))
  call vert_UV_W(wf(:,145),Q(:,11),wf(:,-5),Q(:,32),wf(:,347))
  call vert_QA_V(wf(:,53),wf(:,-1),wf(:,348))
  call vert_VQ_A(wf(:,-4),wf(:,53),wf(:,349))
  call prop_Q_A(wf(:,349),Q(:,29),MB,1_intkind1,wf(:,350))
  call vert_VQ_A(wf(:,-5),wf(:,53),wf(:,351))
  call prop_Q_A(wf(:,351),Q(:,45),MB,1_intkind1,wf(:,352))
  call vert_QA_V(wf(:,34),wf(:,-1),wf(:,353))
  call vert_QS_A(gH,wf(:,34),wf(:,-2),wf(:,354))
  call prop_Q_A(wf(:,354),Q(:,29),MB,1_intkind1,wf(:,355))
  call vert_VQ_A(wf(:,-5),wf(:,34),wf(:,356))
  call prop_Q_A(wf(:,356),Q(:,57),MB,1_intkind1,wf(:,357))
  call vert_QA_V(wf(:,116),wf(:,-1),wf(:,358))
  call vert_QS_A(gH,wf(:,116),wf(:,-2),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,45),MB,1_intkind1,wf(:,360))
  call vert_VQ_A(wf(:,-4),wf(:,116),wf(:,361))
  call prop_Q_A(wf(:,361),Q(:,57),MB,1_intkind1,wf(:,362))
  call vert_UV_W(wf(:,159),Q(:,11),wf(:,-4),Q(:,16),wf(:,363))
  call vert_UV_W(wf(:,159),Q(:,11),wf(:,-5),Q(:,32),wf(:,364))
  call vert_QA_V(wf(:,0),wf(:,61),wf(:,365))
  call vert_QA_V(wf(:,0),wf(:,12),wf(:,366))
  call vert_QA_V(wf(:,0),wf(:,90),wf(:,367))
  call vert_AV_Q(wf(:,61),wf(:,-4),wf(:,368))
  call prop_A_Q(wf(:,368),Q(:,30),MB,1_intkind1,wf(:,369))
  call vert_AV_Q(wf(:,61),wf(:,-5),wf(:,370))
  call prop_A_Q(wf(:,370),Q(:,46),MB,1_intkind1,wf(:,371))
  call vert_SA_Q(gH,wf(:,-2),wf(:,12),wf(:,372))
  call prop_A_Q(wf(:,372),Q(:,30),MB,1_intkind1,wf(:,373))
  call vert_AV_Q(wf(:,12),wf(:,-5),wf(:,374))
  call prop_A_Q(wf(:,374),Q(:,58),MB,1_intkind1,wf(:,375))
  call vert_SA_Q(gH,wf(:,-2),wf(:,90),wf(:,376))
  call prop_A_Q(wf(:,376),Q(:,46),MB,1_intkind1,wf(:,377))
  call vert_AV_Q(wf(:,90),wf(:,-4),wf(:,378))
  call prop_A_Q(wf(:,378),Q(:,58),MB,1_intkind1,wf(:,379))
  call vert_QA_V(wf(:,71),wf(:,-1),wf(:,380))
  call vert_QA_V(wf(:,0),wf(:,68),wf(:,381))
  call vert_VQ_A(wf(:,-4),wf(:,71),wf(:,382))
  call prop_Q_A(wf(:,382),Q(:,29),MB,1_intkind1,wf(:,383))
  call vert_VQ_A(wf(:,-5),wf(:,71),wf(:,384))
  call prop_Q_A(wf(:,384),Q(:,45),MB,1_intkind1,wf(:,385))
  call vert_AV_Q(wf(:,68),wf(:,-4),wf(:,386))
  call prop_A_Q(wf(:,386),Q(:,30),MB,1_intkind1,wf(:,387))
  call vert_AV_Q(wf(:,68),wf(:,-5),wf(:,388))
  call prop_A_Q(wf(:,388),Q(:,46),MB,1_intkind1,wf(:,389))
  call vert_QA_V(wf(:,59),wf(:,-1),wf(:,390))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,59),wf(:,391))
  call prop_Q_A(wf(:,391),Q(:,29),MB,1_intkind1,wf(:,392))
  call vert_VQ_A(wf(:,-5),wf(:,59),wf(:,393))
  call prop_Q_A(wf(:,393),Q(:,53),MB,1_intkind1,wf(:,394))
  call vert_QA_V(wf(:,41),wf(:,-1),wf(:,395))
  call vert_QS_A(gH,wf(:,41),wf(:,-2),wf(:,396))
  call prop_Q_A(wf(:,396),Q(:,29),MB,1_intkind1,wf(:,397))
  call vert_VQ_A(wf(:,-5),wf(:,41),wf(:,398))
  call prop_Q_A(wf(:,398),Q(:,57),MB,1_intkind1,wf(:,399))
  call vert_QS_A(gH,wf(:,124),wf(:,-2),wf(:,400))
  call prop_Q_A(wf(:,400),Q(:,53),MB,1_intkind1,wf(:,401))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,124),wf(:,402))
  call prop_Q_A(wf(:,402),Q(:,57),MB,1_intkind1,wf(:,403))
  call vert_QA_V(wf(:,0),wf(:,55),wf(:,404))
  call vert_QA_V(wf(:,0),wf(:,19),wf(:,405))
  call vert_AZ_Q(gZd,wf(:,55),wf(:,-3),wf(:,406))
  call prop_A_Q(wf(:,406),Q(:,30),MB,1_intkind1,wf(:,407))
  call vert_AV_Q(wf(:,55),wf(:,-5),wf(:,408))
  call prop_A_Q(wf(:,408),Q(:,54),MB,1_intkind1,wf(:,409))
  call vert_SA_Q(gH,wf(:,-2),wf(:,19),wf(:,410))
  call prop_A_Q(wf(:,410),Q(:,30),MB,1_intkind1,wf(:,411))
  call vert_AV_Q(wf(:,19),wf(:,-5),wf(:,412))
  call prop_A_Q(wf(:,412),Q(:,58),MB,1_intkind1,wf(:,413))
  call vert_SA_Q(gH,wf(:,-2),wf(:,98),wf(:,414))
  call prop_A_Q(wf(:,414),Q(:,54),MB,1_intkind1,wf(:,415))
  call vert_AZ_Q(gZd,wf(:,98),wf(:,-3),wf(:,416))
  call prop_A_Q(wf(:,416),Q(:,58),MB,1_intkind1,wf(:,417))
  call vert_QA_V(wf(:,63),wf(:,-1),wf(:,418))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,63),wf(:,419))
  call prop_Q_A(wf(:,419),Q(:,45),MB,1_intkind1,wf(:,420))
  call vert_VQ_A(wf(:,-4),wf(:,63),wf(:,421))
  call prop_Q_A(wf(:,421),Q(:,53),MB,1_intkind1,wf(:,422))
  call vert_QA_V(wf(:,48),wf(:,-1),wf(:,423))
  call vert_QS_A(gH,wf(:,48),wf(:,-2),wf(:,424))
  call prop_Q_A(wf(:,424),Q(:,45),MB,1_intkind1,wf(:,425))
  call vert_VQ_A(wf(:,-4),wf(:,48),wf(:,426))
  call prop_Q_A(wf(:,426),Q(:,57),MB,1_intkind1,wf(:,427))
  call vert_QS_A(gH,wf(:,127),wf(:,-2),wf(:,428))
  call prop_Q_A(wf(:,428),Q(:,53),MB,1_intkind1,wf(:,429))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,127),wf(:,430))
  call prop_Q_A(wf(:,430),Q(:,57),MB,1_intkind1,wf(:,431))
  call vert_QA_V(wf(:,0),wf(:,57),wf(:,432))
  call vert_QA_V(wf(:,0),wf(:,24),wf(:,433))
  call vert_AZ_Q(gZd,wf(:,57),wf(:,-3),wf(:,434))
  call prop_A_Q(wf(:,434),Q(:,46),MB,1_intkind1,wf(:,435))
  call vert_AV_Q(wf(:,57),wf(:,-4),wf(:,436))
  call prop_A_Q(wf(:,436),Q(:,54),MB,1_intkind1,wf(:,437))
  call vert_SA_Q(gH,wf(:,-2),wf(:,24),wf(:,438))
  call prop_A_Q(wf(:,438),Q(:,46),MB,1_intkind1,wf(:,439))
  call vert_AV_Q(wf(:,24),wf(:,-4),wf(:,440))
  call prop_A_Q(wf(:,440),Q(:,58),MB,1_intkind1,wf(:,441))
  call vert_SA_Q(gH,wf(:,-2),wf(:,102),wf(:,442))
  call prop_A_Q(wf(:,442),Q(:,54),MB,1_intkind1,wf(:,443))
  call vert_AZ_Q(gZd,wf(:,102),wf(:,-3),wf(:,444))
  call prop_A_Q(wf(:,444),Q(:,58),MB,1_intkind1,wf(:,445))
  call vert_QS_A(gH,wf(:,51),wf(:,-2),wf(:,446))
  call prop_Q_A(wf(:,446),Q(:,53),MB,1_intkind1,wf(:,447))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,51),wf(:,448))
  call prop_Q_A(wf(:,448),Q(:,57),MB,1_intkind1,wf(:,449))
  call vert_SA_Q(gH,wf(:,-2),wf(:,26),wf(:,450))
  call prop_A_Q(wf(:,450),Q(:,54),MB,1_intkind1,wf(:,451))
  call vert_AZ_Q(gZd,wf(:,26),wf(:,-3),wf(:,452))
  call prop_A_Q(wf(:,452),Q(:,58),MB,1_intkind1,wf(:,453))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MB2)
  den(2) = 1 / (Q(5,10) - MB2)
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,21) - MB2)
  den(9) = 1 / (Q(5,26) - MB2)
  den(12) = 1 / (Q(5,18) - MB2)
  den(13) = 1 / (Q(5,13) - MB2)
  den(18) = 1 / (Q(5,34) - MB2)
  den(20) = 1 / (Q(5,42) - MB2)
  den(23) = 1 / (Q(5,50) - MB2)
  den(26) = 1 / (Q(5,9) - MB2)
  den(27) = 1 / (Q(5,6) - MB2)
  den(30) = 1 / (Q(5,25) - MB2)
  den(33) = 1 / (Q(5,22) - MB2)
  den(36) = 1 / (Q(5,17) - MB2)
  den(39) = 1 / (Q(5,14) - MB2)
  den(42) = 1 / (Q(5,33) - MB2)
  den(43) = 1 / (Q(5,41) - MB2)
  den(47) = 1 / (Q(5,49) - MB2)
  den(55) = 1 / (Q(5,38) - MB2)
  den(63) = 1 / (Q(5,37) - MB2)
  den(68) = 1 / (Q(5,12) - MZ2)
  den(85) = 1 / (Q(5,3))
  den(87) = 1 / (Q(5,56))
  den(91) = 1 / (Q(5,19))
  den(94) = 1 / (Q(5,35))
  den(104) = 1 / (Q(5,40))
  den(110) = 1 / (Q(5,7))
  den(116) = 1 / (Q(5,24))
  den(158) = 1 / (Q(5,36))
  den(163) = 1 / (Q(5,11))
  den(169) = 1 / (Q(5,20))
  den(210) = 1 / (Q(5,58) - MB2)
  den(214) = 1 / (Q(5,53) - MB2)
  den(217) = 1 / (Q(5,15))
  den(247) = 1 / (Q(5,54) - MB2)
  den(251) = 1 / (Q(5,57) - MB2)
  den(312) = 1 / (Q(5,46) - MB2)
  den(316) = 1 / (Q(5,29) - MB2)
  den(322) = 1 / (Q(5,30) - MB2)
  den(326) = 1 / (Q(5,45) - MB2)
  den(351) = 1 / (Q(5,23))
  den(353) = 1 / (Q(5,39))
  den(379) = 1 / (Q(5,27))
  den(381) = 1 / (Q(5,43))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(13)
  den(15) = den(12)*den(14)
  den(16) = den(9)*den(12)
  den(17) = den(1)*den(16)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(3)*den(23)
  den(25) = den(1)*den(24)
  den(28) = den(26)*den(27)
  den(29) = den(3)*den(28)
  den(31) = den(26)*den(30)
  den(32) = den(27)*den(31)
  den(34) = den(27)*den(33)
  den(35) = den(26)*den(34)
  den(37) = den(30)*den(36)
  den(38) = den(27)*den(37)
  den(40) = den(27)*den(39)
  den(41) = den(36)*den(40)
  den(44) = den(42)*den(43)
  den(45) = den(27)*den(44)
  den(46) = den(40)*den(42)
  den(48) = den(3)*den(47)
  den(49) = den(27)*den(48)
  den(50) = den(13)*den(26)
  den(51) = den(12)*den(50)
  den(52) = den(12)*den(33)
  den(53) = den(26)*den(52)
  den(54) = den(18)*den(50)
  den(56) = den(18)*den(55)
  den(57) = den(26)*den(56)
  den(58) = den(24)*den(26)
  den(59) = den(6)*den(36)
  den(60) = den(2)*den(59)
  den(61) = den(2)*den(39)
  den(62) = den(36)*den(61)
  den(64) = den(42)*den(63)
  den(65) = den(2)*den(64)
  den(66) = den(42)*den(61)
  den(67) = den(2)*den(48)
  den(69) = den(18)*den(36)
  den(70) = den(68)*den(69)
  den(71) = den(39)*den(68)
  den(72) = den(36)*den(71)
  den(73) = den(12)*den(42)
  den(74) = den(68)*den(73)
  den(75) = den(13)*den(68)
  den(76) = den(12)*den(75)
  den(77) = den(42)*den(71)
  den(78) = den(18)*den(75)
  den(79) = den(3)*den(75)
  den(80) = den(48)*den(68)
  den(81) = den(18)*den(59)
  den(82) = den(36)*den(56)
  den(83) = den(12)*den(64)
  den(84) = den(42)*den(52)
  den(86) = den(68)*den(85)
  den(88) = den(1)*den(87)
  den(89) = den(27)*den(87)
  den(90) = den(3)*den(86)
  den(92) = den(85)*den(91)
  den(93) = den(68)*den(92)
  den(95) = den(85)*den(94)
  den(96) = den(68)*den(95)
  den(97) = den(1)*den(63)
  den(98) = den(2)*den(97)
  den(99) = den(2)*den(20)
  den(100) = den(1)*den(99)
  den(101) = den(12)*den(97)
  den(102) = den(12)*den(23)
  den(103) = den(1)*den(102)
  den(105) = den(1)*den(12)
  den(106) = den(104)*den(105)
  den(107) = den(7)*den(18)
  den(108) = den(18)*den(23)
  den(109) = den(1)*den(108)
  den(111) = den(1)*den(110)
  den(112) = den(3)*den(111)
  den(113) = den(104)*den(111)
  den(114) = den(20)*den(104)
  den(115) = den(1)*den(114)
  den(117) = den(1)*den(18)
  den(118) = den(116)*den(117)
  den(119) = den(111)*den(116)
  den(120) = den(9)*den(116)
  den(121) = den(1)*den(120)
  den(122) = den(26)*den(43)
  den(123) = den(27)*den(122)
  den(124) = den(27)*den(55)
  den(125) = den(26)*den(124)
  den(126) = den(36)*den(47)
  den(127) = den(27)*den(126)
  den(128) = den(36)*den(124)
  den(129) = den(27)*den(36)
  den(130) = den(104)*den(129)
  den(131) = den(42)*den(47)
  den(132) = den(27)*den(131)
  den(133) = den(34)*den(42)
  den(134) = den(27)*den(110)
  den(135) = den(3)*den(134)
  den(136) = den(104)*den(134)
  den(137) = den(43)*den(104)
  den(138) = den(27)*den(137)
  den(139) = den(27)*den(42)
  den(140) = den(116)*den(139)
  den(141) = den(116)*den(134)
  den(142) = den(30)*den(116)
  den(143) = den(27)*den(142)
  den(144) = den(36)*den(91)
  den(145) = den(68)*den(144)
  den(146) = den(12)*den(91)
  den(147) = den(68)*den(146)
  den(148) = den(42)*den(94)
  den(149) = den(68)*den(148)
  den(150) = den(18)*den(94)
  den(151) = den(68)*den(150)
  den(152) = den(36)*den(114)
  den(153) = den(12)*den(137)
  den(154) = den(42)*den(120)
  den(155) = den(18)*den(142)
  den(156) = den(12)*den(122)
  den(157) = den(26)*den(102)
  den(159) = den(12)*den(26)
  den(160) = den(158)*den(159)
  den(161) = den(18)*den(31)
  den(162) = den(26)*den(108)
  den(164) = den(26)*den(163)
  den(165) = den(3)*den(164)
  den(166) = den(158)*den(164)
  den(167) = den(55)*den(158)
  den(168) = den(26)*den(167)
  den(170) = den(18)*den(26)
  den(171) = den(169)*den(170)
  den(172) = den(164)*den(169)
  den(173) = den(33)*den(169)
  den(174) = den(26)*den(173)
  den(175) = den(2)*den(126)
  den(176) = den(36)*den(99)
  den(177) = den(2)*den(36)
  den(178) = den(158)*den(177)
  den(179) = den(2)*den(131)
  den(180) = den(10)*den(42)
  den(181) = den(2)*den(163)
  den(182) = den(3)*den(181)
  den(183) = den(158)*den(181)
  den(184) = den(63)*den(158)
  den(185) = den(2)*den(184)
  den(186) = den(2)*den(42)
  den(187) = den(169)*den(186)
  den(188) = den(169)*den(181)
  den(189) = den(6)*den(169)
  den(190) = den(2)*den(189)
  den(191) = den(18)*den(37)
  den(192) = den(21)*den(36)
  den(193) = den(36)*den(167)
  den(194) = den(12)*den(44)
  den(195) = den(16)*den(42)
  den(196) = den(12)*den(184)
  den(197) = den(42)*den(173)
  den(198) = den(18)*den(189)
  den(199) = den(3)*den(14)
  den(200) = den(3)*den(50)
  den(201) = den(68)*den(126)
  den(202) = den(68)*den(131)
  den(203) = den(3)*den(40)
  den(204) = den(3)*den(61)
  den(205) = den(68)*den(102)
  den(206) = den(68)*den(108)
  den(207) = den(24)*den(68)
  den(208) = den(3)*den(71)
  den(209) = den(2)*den(3)
  den(211) = den(209)*den(210)
  den(212) = den(1)*den(211)
  den(213) = den(1)*den(3)
  den(215) = den(213)*den(214)
  den(216) = den(2)*den(215)
  den(218) = den(4)*den(217)
  den(219) = den(3)*den(218)
  den(220) = den(1)**2
  den(221) = den(99)*den(220)
  den(222) = den(10)*den(220)
  den(223) = den(2)**2
  den(224) = den(97)*den(223)
  den(225) = den(7)*den(223)
  den(226) = den(7)*den(99)
  den(227) = den(10)*den(97)
  den(228) = den(102)*den(220)
  den(229) = den(16)*den(220)
  den(230) = den(12)**2
  den(231) = den(97)*den(230)
  den(232) = den(14)*den(230)
  den(233) = den(14)*den(102)
  den(234) = den(16)*den(97)
  den(235) = den(108)*den(220)
  den(236) = den(21)*den(220)
  den(237) = den(18)**2
  den(238) = den(7)*den(237)
  den(239) = den(14)*den(237)
  den(240) = den(14)*den(108)
  den(241) = den(7)*den(21)
  den(242) = den(24)*den(220)
  den(243) = den(14)*den(24)
  den(244) = den(3)**2
  den(245) = den(14)*den(244)
  den(246) = den(3)*den(27)
  den(248) = den(246)*den(247)
  den(249) = den(26)*den(248)
  den(250) = den(3)*den(26)
  den(252) = den(250)*den(251)
  den(253) = den(27)*den(252)
  den(254) = den(28)*den(217)
  den(255) = den(3)*den(254)
  den(256) = den(26)**2
  den(257) = den(124)*den(256)
  den(258) = den(34)*den(256)
  den(259) = den(27)**2
  den(260) = den(122)*den(259)
  den(261) = den(31)*den(259)
  den(262) = den(31)*den(124)
  den(263) = den(34)*den(122)
  den(264) = den(36)**2
  den(265) = den(124)*den(264)
  den(266) = den(40)*den(264)
  den(267) = den(126)*den(259)
  den(268) = den(37)*den(259)
  den(269) = den(37)*den(124)
  den(270) = den(40)*den(126)
  den(271) = den(42)**2
  den(272) = den(34)*den(271)
  den(273) = den(40)*den(271)
  den(274) = den(131)*den(259)
  den(275) = den(44)*den(259)
  den(276) = den(34)*den(44)
  den(277) = den(40)*den(131)
  den(278) = den(40)*den(48)
  den(279) = den(40)*den(244)
  den(280) = den(48)*den(259)
  den(281) = den(102)*den(256)
  den(282) = den(52)*den(256)
  den(283) = den(122)*den(230)
  den(284) = den(50)*den(230)
  den(285) = den(50)*den(102)
  den(286) = den(52)*den(122)
  den(287) = den(108)*den(256)
  den(288) = den(56)*den(256)
  den(289) = den(31)*den(237)
  den(290) = den(50)*den(237)
  den(291) = den(50)*den(108)
  den(292) = den(31)*den(56)
  den(293) = den(24)*den(256)
  den(294) = den(24)*den(50)
  den(295) = den(50)*den(244)
  den(296) = den(99)*den(264)
  den(297) = den(61)*den(264)
  den(298) = den(126)*den(223)
  den(299) = den(59)*den(223)
  den(300) = den(59)*den(99)
  den(301) = den(61)*den(126)
  den(302) = den(10)*den(271)
  den(303) = den(61)*den(271)
  den(304) = den(131)*den(223)
  den(305) = den(64)*den(223)
  den(306) = den(10)*den(64)
  den(307) = den(61)*den(131)
  den(308) = den(48)*den(61)
  den(309) = den(61)*den(244)
  den(310) = den(48)*den(223)
  den(311) = den(18)*den(68)
  den(313) = den(311)*den(312)
  den(314) = den(36)*den(313)
  den(315) = den(36)*den(68)
  den(317) = den(315)*den(316)
  den(318) = den(18)*den(317)
  den(319) = den(71)*den(264)
  den(320) = den(71)*den(126)
  den(321) = den(12)*den(68)
  den(323) = den(321)*den(322)
  den(324) = den(42)*den(323)
  den(325) = den(42)*den(68)
  den(327) = den(325)*den(326)
  den(328) = den(12)*den(327)
  den(329) = den(75)*den(102)
  den(330) = den(75)*den(230)
  den(331) = den(71)*den(271)
  den(332) = den(71)*den(131)
  den(333) = den(75)*den(108)
  den(334) = den(75)*den(237)
  den(335) = den(24)*den(75)
  den(336) = den(48)*den(71)
  den(337) = den(71)*den(244)
  den(338) = den(75)*den(244)
  den(339) = den(21)*den(264)
  den(340) = den(56)*den(264)
  den(341) = den(37)*den(237)
  den(342) = den(59)*den(237)
  den(343) = den(21)*den(59)
  den(344) = den(37)*den(56)
  den(345) = den(16)*den(271)
  den(346) = den(52)*den(271)
  den(347) = den(44)*den(230)
  den(348) = den(64)*den(230)
  den(349) = den(16)*den(64)
  den(350) = den(44)*den(52)
  den(352) = den(105)*den(351)
  den(354) = den(117)*den(353)
  den(355) = den(111)*den(351)
  den(356) = den(111)*den(353)
  den(357) = den(14)*den(217)
  den(358) = den(14)*den(316)
  den(359) = den(14)*den(326)
  den(360) = den(7)*den(351)
  den(361) = den(7)*den(316)
  den(362) = den(7)*den(214)
  den(363) = den(97)*den(353)
  den(364) = den(97)*den(326)
  den(365) = den(97)*den(214)
  den(366) = den(129)*den(351)
  den(367) = den(139)*den(353)
  den(368) = den(134)*den(351)
  den(369) = den(134)*den(353)
  den(370) = den(40)*den(217)
  den(371) = den(34)*den(351)
  den(372) = den(124)*den(353)
  den(373) = den(40)*den(322)
  den(374) = den(40)*den(312)
  den(375) = den(34)*den(322)
  den(376) = den(34)*den(247)
  den(377) = den(124)*den(312)
  den(378) = den(124)*den(247)
  den(380) = den(159)*den(379)
  den(382) = den(170)*den(381)
  den(383) = den(164)*den(379)
  den(384) = den(164)*den(381)
  den(385) = den(50)*den(217)
  den(386) = den(50)*den(316)
  den(387) = den(50)*den(326)
  den(388) = den(31)*den(379)
  den(389) = den(31)*den(316)
  den(390) = den(31)*den(251)
  den(391) = den(122)*den(381)
  den(392) = den(122)*den(326)
  den(393) = den(122)*den(251)
  den(394) = den(177)*den(379)
  den(395) = den(186)*den(381)
  den(396) = den(181)*den(379)
  den(397) = den(181)*den(381)
  den(398) = den(61)*den(217)
  den(399) = den(10)*den(379)
  den(400) = den(99)*den(381)
  den(401) = den(61)*den(322)
  den(402) = den(61)*den(312)
  den(403) = den(10)*den(322)
  den(404) = den(10)*den(210)
  den(405) = den(99)*den(312)
  den(406) = den(99)*den(210)
  den(407) = den(75)*den(217)
  den(408) = den(71)*den(217)
  den(409) = den(75)*den(316)
  den(410) = den(75)*den(326)
  den(411) = den(71)*den(322)
  den(412) = den(71)*den(312)
  den(413) = den(59)*den(351)
  den(414) = den(59)*den(316)
  den(415) = den(59)*den(214)
  den(416) = den(37)*den(379)
  den(417) = den(37)*den(316)
  den(418) = den(37)*den(251)
  den(419) = den(126)*den(214)
  den(420) = den(126)*den(251)
  den(421) = den(52)*den(351)
  den(422) = den(16)*den(379)
  den(423) = den(52)*den(322)
  den(424) = den(52)*den(247)
  den(425) = den(16)*den(322)
  den(426) = den(16)*den(210)
  den(427) = den(102)*den(247)
  den(428) = den(102)*den(210)
  den(429) = den(64)*den(353)
  den(430) = den(64)*den(326)
  den(431) = den(64)*den(214)
  den(432) = den(44)*den(381)
  den(433) = den(44)*den(326)
  den(434) = den(44)*den(251)
  den(435) = den(131)*den(214)
  den(436) = den(131)*den(251)
  den(437) = den(56)*den(353)
  den(438) = den(21)*den(381)
  den(439) = den(56)*den(312)
  den(440) = den(56)*den(247)
  den(441) = den(21)*den(312)
  den(442) = den(21)*den(210)
  den(443) = den(108)*den(247)
  den(444) = den(108)*den(210)
  den(445) = den(48)*den(214)
  den(446) = den(48)*den(251)
  den(447) = den(24)*den(247)
  den(448) = den(24)*den(210)
  den(449) = den(3)*den(68)*den(85)
  den(450) = den(3)*den(85)
  den(451) = den(1)*den(2)*den(3)
  den(452) = den(3)*den(26)*den(27)
  den(453) = den(18)*den(36)*den(68)
  den(454) = den(12)*den(42)*den(68)
  den(455) = den(3)*den(68)
  den(456) = den(2)*den(362)
  den(457) = den(2)*den(365)
  den(458) = den(1)*den(404)
  den(459) = den(1)*den(406)
  den(460) = den(12)*den(359)
  den(461) = den(12)*den(364)
  den(462) = den(1)*den(426)
  den(463) = den(1)*den(428)
  den(464) = den(18)*den(358)
  den(465) = den(18)*den(361)
  den(466) = den(1)*den(442)
  den(467) = den(1)*den(444)
  den(468) = den(3)*den(357)
  den(469) = den(1)*den(448)
  den(470) = den(27)*den(390)
  den(471) = den(27)*den(393)
  den(472) = den(26)*den(376)
  den(473) = den(26)*den(378)
  den(474) = den(27)*den(418)
  den(475) = den(27)*den(420)
  den(476) = den(36)*den(374)
  den(477) = den(36)*den(377)
  den(478) = den(27)*den(434)
  den(479) = den(27)*den(436)
  den(480) = den(42)*den(373)
  den(481) = den(42)*den(375)
  den(482) = den(27)*den(446)
  den(483) = den(3)*den(370)
  den(484) = den(12)*den(387)
  den(485) = den(12)*den(392)
  den(486) = den(26)*den(424)
  den(487) = den(26)*den(427)
  den(488) = den(18)*den(386)
  den(489) = den(18)*den(389)
  den(490) = den(26)*den(440)
  den(491) = den(26)*den(443)
  den(492) = den(3)*den(385)
  den(493) = den(26)*den(447)
  den(494) = den(2)*den(415)
  den(495) = den(2)*den(419)
  den(496) = den(36)*den(402)
  den(497) = den(36)*den(405)
  den(498) = den(2)*den(431)
  den(499) = den(2)*den(435)
  den(500) = den(42)*den(401)
  den(501) = den(42)*den(403)
  den(502) = den(2)*den(445)
  den(503) = den(3)*den(398)
  den(504) = den(36)*den(412)
  den(505) = den(12)*den(410)
  den(506) = den(42)*den(411)
  den(507) = den(18)*den(409)
  den(508) = den(3)*den(407)
  den(509) = den(3)*den(408)
  den(510) = den(18)*den(414)
  den(511) = den(18)*den(417)
  den(512) = den(36)*den(439)
  den(513) = den(36)*den(441)
  den(514) = den(12)*den(430)
  den(515) = den(12)*den(433)
  den(516) = den(42)*den(423)
  den(517) = den(42)*den(425)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(355)

  A(1) = cont_VV(wf(:,3),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,8),wf(:,9)) * den(8)
  A(3) = cont_QA(wf(:,11),wf(:,12)) * den(11)
  A(4) = cont_QA(wf(:,16),wf(:,17)) * den(15)
  A(5) = cont_QA(wf(:,11),wf(:,19)) * den(17)
  A(6) = cont_QA(wf(:,17),wf(:,22)) * den(19)
  A(7) = cont_QA(wf(:,7),wf(:,24)) * den(22)
  A(8) = cont_QA(wf(:,15),wf(:,26)) * den(25)
  A(9) = cont_VV(wf(:,3),wf(:,31)) * den(29)
  A(10) = cont_QA(wf(:,33),wf(:,34)) * den(32)
  A(11) = cont_QA(wf(:,36),wf(:,37)) * den(35)
  A(12) = cont_QA(wf(:,33),wf(:,41)) * den(38)
  A(13) = cont_QA(wf(:,43),wf(:,44)) * den(41)
  A(14) = cont_QA(wf(:,35),wf(:,48)) * den(45)
  A(15) = cont_QA(wf(:,44),wf(:,49)) * den(46)
  A(16) = cont_QA(wf(:,42),wf(:,51)) * den(49)
  A(17) = cont_QA(wf(:,16),wf(:,53)) * den(51)
  A(18) = cont_QA(wf(:,36),wf(:,55)) * den(53)
  A(19) = cont_QA(wf(:,22),wf(:,53)) * den(54)
  A(20) = cont_QA(wf(:,32),wf(:,57)) * den(57)
  A(21) = cont_QA(wf(:,26),wf(:,52)) * den(58)
  A(22) = cont_QA(wf(:,8),wf(:,59)) * den(60)
  A(23) = cont_QA(wf(:,43),wf(:,61)) * den(62)
  A(24) = cont_QA(wf(:,10),wf(:,63)) * den(65)
  A(25) = cont_QA(wf(:,49),wf(:,61)) * den(66)
  A(26) = cont_QA(wf(:,51),wf(:,60)) * den(67)
  A(27) = cont_VV(wf(:,65),wf(:,66)) * den(70)
  A(28) = cont_QA(wf(:,43),wf(:,68)) * den(72)
  A(29) = cont_VV(wf(:,65),wf(:,69)) * den(74)
  A(30) = cont_QA(wf(:,16),wf(:,71)) * den(76)
  A(31) = cont_QA(wf(:,49),wf(:,68)) * den(77)
  A(32) = cont_QA(wf(:,22),wf(:,71)) * den(78)
  A(33) = cont_QA(wf(:,25),wf(:,71)) * den(79)
  A(34) = cont_QA(wf(:,51),wf(:,67)) * den(80)
  A(35) = cont_QA(wf(:,23),wf(:,59)) * den(81)
  A(36) = cont_QA(wf(:,40),wf(:,57)) * den(82)
  A(37) = cont_QA(wf(:,18),wf(:,63)) * den(83)
  A(38) = cont_QA(wf(:,47),wf(:,55)) * den(84)

  A(39) = cont_VV(wf(:,65),wf(:,73)) * den(86)
  A(40) = cont_VV(wf(:,65),wf(:,74)) * den(86)
  A(41) = cont_VV(wf(:,75),wf(:,76)) * den(88)
  A(42) = cont_VV(wf(:,76),wf(:,77)) * den(88)
  A(43) = cont_VV(wf(:,75),wf(:,78)) * den(89)
  A(44) = cont_VV(wf(:,77),wf(:,78)) * den(89)
  A(45) = cont_VV(wf(:,3),wf(:,79)) * den(90)
  A(46) = cont_VV(wf(:,80),wf(:,81)) * den(93)
  A(47) = cont_VV(wf(:,82),wf(:,83)) * den(96)
  A(48) = cont_VV(wf(:,3),wf(:,84)) * den(5)
  A(49) = cont_QA(wf(:,9),wf(:,85)) * den(8)
  A(50) = cont_QA(wf(:,12),wf(:,86)) * den(11)
  A(51) = cont_QA(wf(:,87),wf(:,88)) * den(98)
  A(52) = cont_QA(wf(:,89),wf(:,90)) * den(100)
  A(53) = cont_VV(wf(:,6),wf(:,91)) * den(5)
  A(54) = cont_QA(wf(:,17),wf(:,92)) * den(15)
  A(55) = cont_QA(wf(:,19),wf(:,86)) * den(17)
  A(56) = cont_QA(wf(:,17),wf(:,93)) * den(19)
  A(57) = cont_QA(wf(:,24),wf(:,89)) * den(22)
  A(58) = cont_QA(wf(:,15),wf(:,95)) * den(25)
  A(59) = cont_QA(wf(:,88),wf(:,96)) * den(101)
  A(60) = cont_QA(wf(:,97),wf(:,98)) * den(103)
  A(61) = cont_VV(wf(:,99),wf(:,100)) * den(106)
  A(62) = cont_QA(wf(:,9),wf(:,101)) * den(107)
  A(63) = cont_QA(wf(:,97),wf(:,102)) * den(109)
  A(64) = cont_VV(wf(:,76),wf(:,103)) * den(112)
  A(65) = cont_QA(wf(:,26),wf(:,97)) * den(25)
  A(66) = cont_VV(wf(:,76),wf(:,104)) * den(113)
  A(67) = cont_QA(wf(:,7),wf(:,106)) * den(115)
  A(68) = cont_VV(wf(:,107),wf(:,108)) * den(118)
  A(69) = cont_VV(wf(:,76),wf(:,109)) * den(119)
  A(70) = cont_QA(wf(:,11),wf(:,111)) * den(121)
  A(71) = cont_VV(wf(:,3),wf(:,112)) * den(29)
  A(72) = cont_QA(wf(:,34),wf(:,113)) * den(32)
  A(73) = cont_QA(wf(:,37),wf(:,114)) * den(35)
  A(74) = cont_QA(wf(:,115),wf(:,116)) * den(123)
  A(75) = cont_QA(wf(:,117),wf(:,118)) * den(125)
  A(76) = cont_VV(wf(:,31),wf(:,91)) * den(29)
  A(77) = cont_QA(wf(:,41),wf(:,113)) * den(38)
  A(78) = cont_QA(wf(:,44),wf(:,119)) * den(41)
  A(79) = cont_QA(wf(:,48),wf(:,115)) * den(45)
  A(80) = cont_QA(wf(:,44),wf(:,120)) * den(46)
  A(81) = cont_QA(wf(:,42),wf(:,122)) * den(49)
  A(82) = cont_QA(wf(:,123),wf(:,124)) * den(127)
  A(83) = cont_QA(wf(:,118),wf(:,125)) * den(128)
  A(84) = cont_VV(wf(:,99),wf(:,126)) * den(130)
  A(85) = cont_QA(wf(:,123),wf(:,127)) * den(132)
  A(86) = cont_QA(wf(:,37),wf(:,128)) * den(133)
  A(87) = cont_VV(wf(:,78),wf(:,103)) * den(135)
  A(88) = cont_QA(wf(:,51),wf(:,123)) * den(49)
  A(89) = cont_VV(wf(:,78),wf(:,104)) * den(136)
  A(90) = cont_QA(wf(:,35),wf(:,130)) * den(138)
  A(91) = cont_VV(wf(:,107),wf(:,131)) * den(140)
  A(92) = cont_VV(wf(:,78),wf(:,109)) * den(141)
  A(93) = cont_QA(wf(:,33),wf(:,133)) * den(143)
  A(94) = cont_QA(wf(:,53),wf(:,92)) * den(51)
  A(95) = cont_QA(wf(:,55),wf(:,114)) * den(53)
  A(96) = cont_QA(wf(:,53),wf(:,93)) * den(54)
  A(97) = cont_QA(wf(:,57),wf(:,117)) * den(57)
  A(98) = cont_QA(wf(:,52),wf(:,95)) * den(58)
  A(99) = cont_QA(wf(:,59),wf(:,85)) * den(60)
  A(100) = cont_QA(wf(:,61),wf(:,119)) * den(62)
  A(101) = cont_QA(wf(:,63),wf(:,87)) * den(65)
  A(102) = cont_QA(wf(:,61),wf(:,120)) * den(66)
  A(103) = cont_QA(wf(:,60),wf(:,122)) * den(67)
  A(104) = cont_VV(wf(:,65),wf(:,134)) * den(70)
  A(105) = cont_VV(wf(:,81),wf(:,135)) * den(145)
  A(106) = cont_QA(wf(:,68),wf(:,119)) * den(72)
  A(107) = cont_VV(wf(:,65),wf(:,136)) * den(74)
  A(108) = cont_VV(wf(:,81),wf(:,137)) * den(147)
  A(109) = cont_QA(wf(:,71),wf(:,92)) * den(76)
  A(110) = cont_VV(wf(:,83),wf(:,138)) * den(149)
  A(111) = cont_QA(wf(:,68),wf(:,120)) * den(77)
  A(112) = cont_VV(wf(:,83),wf(:,139)) * den(151)
  A(113) = cont_QA(wf(:,71),wf(:,93)) * den(78)
  A(114) = cont_QA(wf(:,71),wf(:,94)) * den(79)
  A(115) = cont_QA(wf(:,67),wf(:,122)) * den(80)
  A(116) = cont_QA(wf(:,59),wf(:,101)) * den(81)
  A(117) = cont_QA(wf(:,57),wf(:,125)) * den(82)
  A(118) = cont_QA(wf(:,58),wf(:,106)) * den(152)
  A(119) = cont_QA(wf(:,63),wf(:,96)) * den(83)
  A(120) = cont_QA(wf(:,55),wf(:,128)) * den(84)
  A(121) = cont_QA(wf(:,54),wf(:,130)) * den(153)
  A(122) = cont_QA(wf(:,62),wf(:,111)) * den(154)
  A(123) = cont_QA(wf(:,56),wf(:,133)) * den(155)
  A(124) = cont_QA(wf(:,116),wf(:,140)) * den(156)
  A(125) = cont_QA(wf(:,98),wf(:,141)) * den(157)
  A(126) = cont_VV(wf(:,142),wf(:,143)) * den(160)
  A(127) = cont_VV(wf(:,142),wf(:,143)) * den(160)
  A(128) = cont_QA(wf(:,34),wf(:,144)) * den(161)
  A(129) = cont_QA(wf(:,102),wf(:,141)) * den(162)
  A(130) = cont_VV(wf(:,145),wf(:,146)) * den(165)
  A(131) = cont_VV(wf(:,145),wf(:,146)) * den(165)
  A(132) = cont_QA(wf(:,26),wf(:,141)) * den(58)
  A(133) = cont_VV(wf(:,145),wf(:,147)) * den(166)
  A(134) = cont_VV(wf(:,145),wf(:,147)) * den(166)
  A(135) = cont_QA(wf(:,32),wf(:,149)) * den(168)
  A(136) = cont_QA(wf(:,32),wf(:,149)) * den(168)
  A(137) = cont_VV(wf(:,150),wf(:,151)) * den(171)
  A(138) = cont_VV(wf(:,150),wf(:,151)) * den(171)
  A(139) = cont_VV(wf(:,145),wf(:,152)) * den(172)
  A(140) = cont_VV(wf(:,145),wf(:,152)) * den(172)
  A(141) = cont_QA(wf(:,36),wf(:,154)) * den(174)
  A(142) = cont_QA(wf(:,36),wf(:,154)) * den(174)
  A(143) = cont_QA(wf(:,124),wf(:,155)) * den(175)
  A(144) = cont_QA(wf(:,90),wf(:,156)) * den(176)
  A(145) = cont_VV(wf(:,142),wf(:,157)) * den(178)
  A(146) = cont_VV(wf(:,142),wf(:,157)) * den(178)
  A(147) = cont_QA(wf(:,127),wf(:,155)) * den(179)
  A(148) = cont_QA(wf(:,12),wf(:,158)) * den(180)
  A(149) = cont_VV(wf(:,146),wf(:,159)) * den(182)
  A(150) = cont_VV(wf(:,146),wf(:,159)) * den(182)
  A(151) = cont_QA(wf(:,51),wf(:,155)) * den(67)
  A(152) = cont_VV(wf(:,147),wf(:,159)) * den(183)
  A(153) = cont_VV(wf(:,147),wf(:,159)) * den(183)
  A(154) = cont_QA(wf(:,10),wf(:,161)) * den(185)
  A(155) = cont_QA(wf(:,10),wf(:,161)) * den(185)
  A(156) = cont_VV(wf(:,150),wf(:,162)) * den(187)
  A(157) = cont_VV(wf(:,150),wf(:,162)) * den(187)
  A(158) = cont_VV(wf(:,152),wf(:,159)) * den(188)
  A(159) = cont_VV(wf(:,152),wf(:,159)) * den(188)
  A(160) = cont_QA(wf(:,8),wf(:,164)) * den(190)
  A(161) = cont_QA(wf(:,8),wf(:,164)) * den(190)
  A(162) = cont_QA(wf(:,41),wf(:,144)) * den(191)
  A(163) = cont_QA(wf(:,24),wf(:,156)) * den(192)
  A(164) = cont_QA(wf(:,40),wf(:,149)) * den(193)
  A(165) = cont_QA(wf(:,40),wf(:,149)) * den(193)
  A(166) = cont_QA(wf(:,48),wf(:,140)) * den(194)
  A(167) = cont_QA(wf(:,19),wf(:,158)) * den(195)
  A(168) = cont_QA(wf(:,18),wf(:,161)) * den(196)
  A(169) = cont_QA(wf(:,18),wf(:,161)) * den(196)
  A(170) = cont_QA(wf(:,47),wf(:,154)) * den(197)
  A(171) = cont_QA(wf(:,47),wf(:,154)) * den(197)
  A(172) = cont_QA(wf(:,23),wf(:,164)) * den(198)
  A(173) = cont_QA(wf(:,23),wf(:,164)) * den(198)
  A(174) = cont_QA(wf(:,17),wf(:,165)) * den(199)
  A(175) = cont_QA(wf(:,17),wf(:,168)) * den(19)
  A(176) = cont_QA(wf(:,7),wf(:,170)) * den(22)
  A(177) = cont_QA(wf(:,17),wf(:,173)) * den(15)
  A(178) = cont_QA(wf(:,11),wf(:,175)) * den(17)
  A(179) = cont_VV(wf(:,3),wf(:,178)) * den(5)
  A(180) = cont_QA(wf(:,9),wf(:,179)) * den(8)
  A(181) = cont_QA(wf(:,11),wf(:,181)) * den(11)
  A(182) = cont_QA(wf(:,53),wf(:,165)) * den(200)
  A(183) = cont_QA(wf(:,53),wf(:,168)) * den(54)
  A(184) = cont_QA(wf(:,32),wf(:,183)) * den(57)
  A(185) = cont_QA(wf(:,53),wf(:,173)) * den(51)
  A(186) = cont_QA(wf(:,36),wf(:,185)) * den(53)
  A(187) = cont_QA(wf(:,124),wf(:,186)) * den(201)
  A(188) = cont_VV(wf(:,65),wf(:,187)) * den(70)
  A(189) = cont_QA(wf(:,127),wf(:,186)) * den(202)
  A(190) = cont_QA(wf(:,71),wf(:,165)) * den(79)
  A(191) = cont_QA(wf(:,51),wf(:,186)) * den(80)
  A(192) = cont_QA(wf(:,71),wf(:,168)) * den(78)
  A(193) = cont_VV(wf(:,65),wf(:,188)) * den(74)
  A(194) = cont_QA(wf(:,71),wf(:,173)) * den(76)
  A(195) = cont_QA(wf(:,59),wf(:,169)) * den(81)
  A(196) = cont_QA(wf(:,40),wf(:,183)) * den(82)
  A(197) = cont_QA(wf(:,63),wf(:,174)) * den(83)
  A(198) = cont_QA(wf(:,47),wf(:,185)) * den(84)
  A(199) = cont_QA(wf(:,59),wf(:,179)) * den(60)
  A(200) = cont_QA(wf(:,43),wf(:,190)) * den(62)
  A(201) = cont_QA(wf(:,63),wf(:,180)) * den(65)
  A(202) = cont_QA(wf(:,49),wf(:,190)) * den(66)
  A(203) = cont_QA(wf(:,51),wf(:,189)) * den(67)
  A(204) = cont_VV(wf(:,3),wf(:,193)) * den(29)
  A(205) = cont_QA(wf(:,34),wf(:,194)) * den(32)
  A(206) = cont_QA(wf(:,36),wf(:,196)) * den(35)
  A(207) = cont_QA(wf(:,41),wf(:,194)) * den(38)
  A(208) = cont_QA(wf(:,43),wf(:,198)) * den(41)
  A(209) = cont_QA(wf(:,48),wf(:,195)) * den(45)
  A(210) = cont_QA(wf(:,49),wf(:,198)) * den(46)
  A(211) = cont_QA(wf(:,51),wf(:,197)) * den(49)
  A(212) = cont_QA(wf(:,44),wf(:,199)) * den(203)
  A(213) = cont_QA(wf(:,35),wf(:,203)) * den(45)
  A(214) = cont_QA(wf(:,44),wf(:,204)) * den(46)
  A(215) = cont_QA(wf(:,33),wf(:,208)) * den(38)
  A(216) = cont_QA(wf(:,44),wf(:,209)) * den(41)
  A(217) = cont_VV(wf(:,3),wf(:,212)) * den(29)
  A(218) = cont_QA(wf(:,33),wf(:,214)) * den(32)
  A(219) = cont_QA(wf(:,37),wf(:,215)) * den(35)
  A(220) = cont_QA(wf(:,61),wf(:,199)) * den(204)
  A(221) = cont_QA(wf(:,10),wf(:,217)) * den(65)
  A(222) = cont_QA(wf(:,61),wf(:,204)) * den(66)
  A(223) = cont_QA(wf(:,8),wf(:,219)) * den(60)
  A(224) = cont_QA(wf(:,61),wf(:,209)) * den(62)
  A(225) = cont_QA(wf(:,98),wf(:,220)) * den(205)
  A(226) = cont_VV(wf(:,65),wf(:,221)) * den(74)
  A(227) = cont_QA(wf(:,102),wf(:,220)) * den(206)
  A(228) = cont_QA(wf(:,26),wf(:,220)) * den(207)
  A(229) = cont_QA(wf(:,68),wf(:,199)) * den(208)
  A(230) = cont_QA(wf(:,68),wf(:,204)) * den(77)
  A(231) = cont_VV(wf(:,65),wf(:,222)) * den(70)
  A(232) = cont_QA(wf(:,68),wf(:,209)) * den(72)
  A(233) = cont_QA(wf(:,18),wf(:,217)) * den(83)
  A(234) = cont_QA(wf(:,55),wf(:,202)) * den(84)
  A(235) = cont_QA(wf(:,23),wf(:,219)) * den(81)
  A(236) = cont_QA(wf(:,57),wf(:,207)) * den(82)
  A(237) = cont_QA(wf(:,16),wf(:,224)) * den(51)
  A(238) = cont_QA(wf(:,55),wf(:,215)) * den(53)
  A(239) = cont_QA(wf(:,22),wf(:,224)) * den(54)
  A(240) = cont_QA(wf(:,57),wf(:,213)) * den(57)
  A(241) = cont_QA(wf(:,26),wf(:,223)) * den(58)
  A(242) = cont_VV(wf(:,3),wf(:,227)) * den(5)
  A(243) = cont_QA(wf(:,8),wf(:,229)) * den(8)
  A(244) = cont_QA(wf(:,12),wf(:,230)) * den(11)
  A(245) = cont_QA(wf(:,16),wf(:,232)) * den(15)
  A(246) = cont_QA(wf(:,19),wf(:,230)) * den(17)
  A(247) = cont_QA(wf(:,22),wf(:,232)) * den(19)
  A(248) = cont_QA(wf(:,24),wf(:,228)) * den(22)
  A(249) = cont_QA(wf(:,26),wf(:,231)) * den(25)
  A(250) = cont_QA(wf(:,234),wf(:,235)) * den(212)
  A(251) = cont_QA(wf(:,237),wf(:,238)) * den(216)
  A(252) = cont_VV(wf(:,6),wf(:,239)) * den(219)
  A(253) = cont_QA(wf(:,90),wf(:,241)) * den(221)
  A(254) = cont_QA(wf(:,12),wf(:,242)) * den(222)
  A(255) = cont_QA(wf(:,88),wf(:,244)) * den(224)
  A(256) = cont_QA(wf(:,9),wf(:,245)) * den(225)
  A(257) = cont_QA(wf(:,90),wf(:,246)) * den(226)
  A(258) = cont_QA(wf(:,88),wf(:,247)) * den(227)
  A(259) = cont_QA(wf(:,98),wf(:,248)) * den(228)
  A(260) = cont_QA(wf(:,19),wf(:,242)) * den(229)
  A(261) = cont_QA(wf(:,88),wf(:,251)) * den(231)
  A(262) = cont_QA(wf(:,17),wf(:,252)) * den(232)
  A(263) = cont_QA(wf(:,98),wf(:,253)) * den(233)
  A(264) = cont_QA(wf(:,88),wf(:,254)) * den(234)
  A(265) = cont_QA(wf(:,102),wf(:,248)) * den(235)
  A(266) = cont_QA(wf(:,24),wf(:,241)) * den(236)
  A(267) = cont_QA(wf(:,9),wf(:,257)) * den(238)
  A(268) = cont_QA(wf(:,17),wf(:,258)) * den(239)
  A(269) = cont_QA(wf(:,102),wf(:,253)) * den(240)
  A(270) = cont_QA(wf(:,9),wf(:,259)) * den(241)
  A(271) = cont_QA(wf(:,26),wf(:,248)) * den(242)
  A(272) = cont_QA(wf(:,17),wf(:,260)) * den(243)
  A(273) = cont_QA(wf(:,17),wf(:,261)) * den(245)
  A(274) = cont_QA(wf(:,263),wf(:,264)) * den(249)
  A(275) = cont_QA(wf(:,266),wf(:,267)) * den(253)
  A(276) = cont_VV(wf(:,31),wf(:,239)) * den(255)
  A(277) = cont_QA(wf(:,118),wf(:,269)) * den(257)
  A(278) = cont_QA(wf(:,37),wf(:,270)) * den(258)
  A(279) = cont_QA(wf(:,116),wf(:,272)) * den(260)
  A(280) = cont_QA(wf(:,34),wf(:,273)) * den(261)
  A(281) = cont_QA(wf(:,118),wf(:,274)) * den(262)
  A(282) = cont_QA(wf(:,116),wf(:,275)) * den(263)
  A(283) = cont_QA(wf(:,118),wf(:,278)) * den(265)
  A(284) = cont_QA(wf(:,44),wf(:,279)) * den(266)
  A(285) = cont_QA(wf(:,124),wf(:,280)) * den(267)
  A(286) = cont_QA(wf(:,41),wf(:,273)) * den(268)
  A(287) = cont_QA(wf(:,118),wf(:,281)) * den(269)
  A(288) = cont_QA(wf(:,124),wf(:,282)) * den(270)
  A(289) = cont_QA(wf(:,37),wf(:,285)) * den(272)
  A(290) = cont_QA(wf(:,44),wf(:,286)) * den(273)
  A(291) = cont_QA(wf(:,127),wf(:,280)) * den(274)
  A(292) = cont_QA(wf(:,48),wf(:,272)) * den(275)
  A(293) = cont_QA(wf(:,37),wf(:,287)) * den(276)
  A(294) = cont_QA(wf(:,127),wf(:,282)) * den(277)
  A(295) = cont_QA(wf(:,44),wf(:,288)) * den(278)
  A(296) = cont_QA(wf(:,44),wf(:,289)) * den(279)
  A(297) = cont_QA(wf(:,51),wf(:,280)) * den(280)
  A(298) = cont_QA(wf(:,98),wf(:,290)) * den(281)
  A(299) = cont_QA(wf(:,55),wf(:,270)) * den(282)
  A(300) = cont_QA(wf(:,116),wf(:,291)) * den(283)
  A(301) = cont_QA(wf(:,53),wf(:,252)) * den(284)
  A(302) = cont_QA(wf(:,98),wf(:,292)) * den(285)
  A(303) = cont_QA(wf(:,116),wf(:,293)) * den(286)
  A(304) = cont_QA(wf(:,102),wf(:,290)) * den(287)
  A(305) = cont_QA(wf(:,57),wf(:,269)) * den(288)
  A(306) = cont_QA(wf(:,34),wf(:,294)) * den(289)
  A(307) = cont_QA(wf(:,53),wf(:,258)) * den(290)
  A(308) = cont_QA(wf(:,102),wf(:,292)) * den(291)
  A(309) = cont_QA(wf(:,34),wf(:,295)) * den(292)
  A(310) = cont_QA(wf(:,26),wf(:,290)) * den(293)
  A(311) = cont_QA(wf(:,53),wf(:,260)) * den(294)
  A(312) = cont_QA(wf(:,53),wf(:,261)) * den(295)
  A(313) = cont_QA(wf(:,90),wf(:,296)) * den(296)
  A(314) = cont_QA(wf(:,61),wf(:,279)) * den(297)
  A(315) = cont_QA(wf(:,124),wf(:,297)) * den(298)
  A(316) = cont_QA(wf(:,59),wf(:,245)) * den(299)
  A(317) = cont_QA(wf(:,90),wf(:,298)) * den(300)
  A(318) = cont_QA(wf(:,124),wf(:,299)) * den(301)
  A(319) = cont_QA(wf(:,12),wf(:,300)) * den(302)
  A(320) = cont_QA(wf(:,61),wf(:,286)) * den(303)
  A(321) = cont_QA(wf(:,127),wf(:,297)) * den(304)
  A(322) = cont_QA(wf(:,63),wf(:,244)) * den(305)
  A(323) = cont_QA(wf(:,12),wf(:,301)) * den(306)
  A(324) = cont_QA(wf(:,127),wf(:,299)) * den(307)
  A(325) = cont_QA(wf(:,61),wf(:,288)) * den(308)
  A(326) = cont_QA(wf(:,61),wf(:,289)) * den(309)
  A(327) = cont_QA(wf(:,51),wf(:,297)) * den(310)
  A(328) = cont_QA(wf(:,276),wf(:,303)) * den(314)
  A(329) = cont_QA(wf(:,255),wf(:,305)) * den(318)
  A(330) = cont_QA(wf(:,68),wf(:,279)) * den(319)
  A(331) = cont_QA(wf(:,124),wf(:,306)) * den(320)
  A(332) = cont_QA(wf(:,283),wf(:,308)) * den(324)
  A(333) = cont_QA(wf(:,249),wf(:,310)) * den(328)
  A(334) = cont_QA(wf(:,98),wf(:,311)) * den(329)
  A(335) = cont_QA(wf(:,71),wf(:,252)) * den(330)
  A(336) = cont_QA(wf(:,68),wf(:,286)) * den(331)
  A(337) = cont_QA(wf(:,127),wf(:,306)) * den(332)
  A(338) = cont_QA(wf(:,102),wf(:,311)) * den(333)
  A(339) = cont_QA(wf(:,71),wf(:,258)) * den(334)
  A(340) = cont_QA(wf(:,26),wf(:,311)) * den(335)
  A(341) = cont_QA(wf(:,68),wf(:,288)) * den(336)
  A(342) = cont_QA(wf(:,68),wf(:,289)) * den(337)
  A(343) = cont_QA(wf(:,71),wf(:,261)) * den(338)
  A(344) = cont_QA(wf(:,24),wf(:,296)) * den(339)
  A(345) = cont_QA(wf(:,57),wf(:,278)) * den(340)
  A(346) = cont_QA(wf(:,41),wf(:,294)) * den(341)
  A(347) = cont_QA(wf(:,59),wf(:,257)) * den(342)
  A(348) = cont_QA(wf(:,24),wf(:,298)) * den(343)
  A(349) = cont_QA(wf(:,41),wf(:,295)) * den(344)
  A(350) = cont_QA(wf(:,19),wf(:,300)) * den(345)
  A(351) = cont_QA(wf(:,55),wf(:,285)) * den(346)
  A(352) = cont_QA(wf(:,48),wf(:,291)) * den(347)
  A(353) = cont_QA(wf(:,63),wf(:,251)) * den(348)
  A(354) = cont_QA(wf(:,19),wf(:,301)) * den(349)
  A(355) = cont_QA(wf(:,48),wf(:,293)) * den(350)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(355)
  complex(REALKIND), intent(out) :: M1(2), M2(3)

  M1(1) = (-A(29)-A(30)-A(31))*f(1)+CI*(-A(33)-A(34))*f(2)+(-A(3)-A(4)-A(5)-A(11)-A(14)-A(15)-A(17)-A(18)-A(24)-A(25)-A(37) &
       -A(38))*f(21)+CI*(-A(1)-A(8)-A(9)-A(16)-A(21)-A(26))*f(22)
  M1(2) = (-A(27)-A(28)-A(32))*f(1)+CI*(A(33)+A(34))*f(2)+(-A(2)-A(6)-A(7)-A(10)-A(12)-A(13)-A(19)-A(20)-A(22)-A(23)-A(35) &
       -A(36))*f(21)+CI*(A(1)+A(8)+A(9)+A(16)+A(21)+A(26))*f(22)

  M2(1) = -(A(39)*f(3))/2._/**/REALKIND+(A(332)+A(333)+A(334)+A(335)+A(336)+A(337))*f(3)+CI*(A(340)+A(341)+A(342)+A(343))*f(4)+( &
       -A(109)-A(111)-A(193)-A(194)-A(226)-A(230))*f(5)+CI*(-A(190)-A(229))*f(6)+(-A(107)-A(189)-A(225))*f(7)+CI*(-A(191) &
       -A(228))*f(8)+CI*(-A(114)-A(115))*f(9)+CI*(-A(45)-A(46)+A(47))*f(10)+(A(108)+A(110))*f(11)+(-A(127)-A(142)-A(155)-A(157) &
       -A(169)-A(171))*f(19)+CI*(-A(131)-A(134)-A(140)-A(150)-A(153)-A(159))*f(20)+((-A(41)-A(43))*f(23))/2._/**/REALKIND+(A(254) &
       +A(255)+A(258)+A(259)+A(260)+A(261)+A(262)+A(263)+A(264)+A(278)+A(279)+A(282)+A(289)+A(290)+A(291)+A(292)+A(293)+A(294) &
       +A(298)+A(299)+A(300)+A(301)+A(302)+A(303)+A(319)+A(320)+A(321)+A(322)+A(323)+A(324)+A(350)+A(351)+A(352)+A(353)+A(354) &
       +A(355))*f(23)+CI*(A(250)+A(251)+A(252)+A(271)+A(272)+A(273)+A(274)+A(275)+A(276)+A(295)+A(296)+A(297)+A(310)+A(311)+A(312) &
       +A(325)+A(326)+A(327))*f(24)+(-A(50)-A(51)-A(54)-A(55)-A(73)-A(74)-A(79)-A(80)-A(94)-A(95)-A(101)-A(102)-A(177)-A(178) &
       -A(185)-A(186)-A(197)-A(198)-A(213)-A(214)-A(221)-A(222)-A(233)-A(234))*f(25)+CI*(-A(48)-A(71)-A(174)-A(182)-A(212) &
       -A(220))*f(26)+(-A(124)-A(125)-A(147)-A(148)-A(166)-A(167)-A(206)-A(209)-A(210)-A(244)-A(245)-A(246))*f(27)+CI*(-A(132) &
       -A(151)-A(204)-A(211)-A(242)-A(249))*f(28)+(-A(59)-A(60)-A(85)-A(86)-A(119)-A(120)-A(181)-A(201)-A(202)-A(219)-A(237) &
       -A(238))*f(29)+CI*(-A(65)-A(88)-A(179)-A(203)-A(217)-A(241))*f(30)+CI*(-A(53)-A(58)-A(76)-A(81)-A(98)-A(103))*f(31)+CI*( &
       -A(64)-A(66)-A(69)-A(87)-A(89)-A(92))*f(32)+(A(61)+A(70)+A(90)+A(91)+A(121)+A(122))*f(33)+(-A(126)-A(141)-A(154)-A(156) &
       -A(168)-A(170))*f(41)+CI*(-A(130)-A(133)-A(139)-A(149)-A(152)-A(158))*f(42)
  M2(2) = -(A(40)*f(3))/2._/**/REALKIND+(A(328)+A(329)+A(330)+A(331)+A(338)+A(339))*f(3)+CI*(-A(340)-A(341)-A(342)-A(343))*f(4)+( &
       -A(106)-A(113)-A(188)-A(192)-A(231)-A(232))*f(5)+CI*(A(190)+A(229))*f(6)+(-A(104)-A(187)-A(227))*f(7)+CI*(A(191) &
       +A(228))*f(8)+CI*(A(114)+A(115))*f(9)+CI*(A(45)+A(46)-A(47))*f(10)+(A(105)+A(112))*f(11)+(-A(136)-A(138)-A(146)-A(161) &
       -A(165)-A(173))*f(19)+CI*(A(131)+A(134)+A(140)+A(150)+A(153)+A(159))*f(20)+((-A(42)-A(44))*f(23))/2._/**/REALKIND+(A(253) &
       +A(256)+A(257)+A(265)+A(266)+A(267)+A(268)+A(269)+A(270)+A(277)+A(280)+A(281)+A(283)+A(284)+A(285)+A(286)+A(287)+A(288) &
       +A(304)+A(305)+A(306)+A(307)+A(308)+A(309)+A(313)+A(314)+A(315)+A(316)+A(317)+A(318)+A(344)+A(345)+A(346)+A(347)+A(348) &
       +A(349))*f(23)+CI*(-A(250)-A(251)-A(252)-A(271)-A(272)-A(273)-A(274)-A(275)-A(276)-A(295)-A(296)-A(297)-A(310)-A(311) &
       -A(312)-A(325)-A(326)-A(327))*f(24)+(-A(49)-A(52)-A(56)-A(57)-A(72)-A(75)-A(77)-A(78)-A(96)-A(97)-A(99)-A(100)-A(175) &
       -A(176)-A(183)-A(184)-A(195)-A(196)-A(215)-A(216)-A(223)-A(224)-A(235)-A(236))*f(25)+CI*(A(48)+A(71)+A(174)+A(182)+A(212) &
       +A(220))*f(26)+(-A(128)-A(129)-A(143)-A(144)-A(162)-A(163)-A(205)-A(207)-A(208)-A(243)-A(247)-A(248))*f(27)+CI*(A(132) &
       +A(151)+A(204)+A(211)+A(242)+A(249))*f(28)+(-A(62)-A(63)-A(82)-A(83)-A(116)-A(117)-A(180)-A(199)-A(200)-A(218)-A(239) &
       -A(240))*f(29)+CI*(A(65)+A(88)+A(179)+A(203)+A(217)+A(241))*f(30)+CI*(A(53)+A(58)+A(76)+A(81)+A(98)+A(103))*f(31)+CI*(A(64) &
       +A(66)+A(69)+A(87)+A(89)+A(92))*f(32)+(A(67)+A(68)+A(84)+A(93)+A(118)+A(123))*f(33)+(-A(135)-A(137)-A(145)-A(160)-A(164) &
       -A(172))*f(41)+CI*(A(130)+A(133)+A(139)+A(149)+A(152)+A(158))*f(42)
  M2(3) = ((A(39)+A(40))*f(3))/6._/**/REALKIND+((A(41)+A(42)+A(43)+A(44))*f(23))/6._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pphzjj_bbxhzgg_1_/**/REALKIND
