
module ol_colourmatrix_pphzjj_bbbxbxhz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,   4]
  K1( 6,:) = [   4,   0]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [   0,  -4]
  K1(10,:) = [  -4, -12]
  K1(11,:) = [ -12,  -4]
  K1(12,:) = [  -4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [ -12,  -4]
  K1(16,:) = [  -4,   0]
  K1(17,:) = [   0,  -4]
  K1(18,:) = [  -4, -12]
  K1(19,:) = [   0,   4]
  K1(20,:) = [   4,   0]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [   0,   0]
  K1(44,:) = [   0,   0]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphzjj_bbbxbxhz_1_/**/REALKIND



module ol_forced_parameters_pphzjj_bbbxbxhz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphzjj_bbbxbxhz_1_/**/REALKIND

module ol_loop_pphzjj_bbbxbxhz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(24), c(36)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:442)
  ! denominators
  complex(REALKIND), save :: den(543)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(2,48)
  ! zero helicity identifier
  logical,           save :: zerohel(48) = .true., zerohel_ct(48) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2*lambdaHZZ*MW)/(cw**2*sw)
    f( 2) = (CI*countertermnorm*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 3) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 4) = (CI*countertermnorm*ctVbb*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 5) = (countertermnorm*ctZGG*eQED**2*gQCD**4*lambdaHZZ*MW)/(cw**2*sw)
    f( 6) = (CI*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw)
    f( 7) = (eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw*2._/**/REALKIND)
    f( 8) = (eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwB)/(cw**2*sw)
    f( 9) = (eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(10) = (2*eQED**2*gQCD**4*integralnorm*lambdaHZZ*MW*SwF)/(cw**2*sw)
    f(11) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MB*YB)/MQ2sum
    f(12) = (CI*eQED**2*gQCD**2*YB)/(2._/**/REALKIND*MW*sw)
    f(13) = (CI*countertermnorm*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(14) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(15) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(16) = (CI*countertermnorm*ctVbb*eQED**2*gQCD**4*YB)/(2._/**/REALKIND*MW*sw)
    f(17) = (countertermnorm*ctZGG*eQED**2*gQCD**4*YB)/(MW*sw*2._/**/REALKIND)
    f(18) = (CI*eQED**2*gQCD**4*integralnorm*SwB*YB)/(2._/**/REALKIND*MW*sw)
    f(19) = (eQED**2*gQCD**4*integralnorm*SwB*YB)/(MW*sw*4._/**/REALKIND)
    f(20) = (eQED**2*gQCD**4*integralnorm*SwB*YB)/(MW*sw*2._/**/REALKIND)
    f(21) = (eQED**2*gQCD**4*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f(22) = (eQED**2*gQCD**4*integralnorm*SwF*YB)/(MW*sw)
    f(23) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MT*YT)/MQ2sum
    f(24) = (eQED**2*gQCD**4*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)

  c = [ 9*CI*f(6), 27*CI*f(6), 18*f(7), 54*f(7), f(8), 3*f(8), 6*f(8), 8*f(8), 10*f(8), 18*f(8), 21*f(8), 24*f(8), 54*f(8), 3*f(9) &
    , 9*f(9), 3*f(10), 9*f(10), 9*CI*f(18), 27*CI*f(18), 18*f(19), 54*f(19), f(20), 3*f(20), 6*f(20), 8*f(20), 10*f(20), 18*f(20) &
    , 21*f(20), 24*f(20), 54*f(20), 3*f(21), 9*f(21), 3*f(22), 9*f(22), 3*f(24), 9*f(24) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(2), M2(2)
  complex(REALKIND) :: A(394)
  ! external WFs
  call wf_Q(P(:,1), rMB, H(1), wf(:,0))
  call wf_Q(P(:,2), rMB, H(2), wf(:,-1))
  call wf_A(P(:,3), rMB, H(3), wf(:,-2))
  call wf_A(P(:,4), rMB, H(4), wf(:,-3))
  call wf_S(P(:,5), rMH, H(5), wf(:,-4))
  call wf_V(P(:,6), rMZ, H(6), wf(:,-5))

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,2))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,-5),wf(:,3))
  call prop_Q_A(wf(:,2),Q(:,18),MB,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,3),Q(:,40),MB,1_intkind1,wf(:,5))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,6))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,7))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,4),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,13),MB,1_intkind1,wf(:,9))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,-1),wf(:,10))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,11))
  call prop_Q_A(wf(:,10),Q(:,34),MB,1_intkind1,wf(:,12))
  call prop_A_Q(wf(:,11),Q(:,24),MB,1_intkind1,wf(:,13))
  call vert_VQ_A(wf(:,1),wf(:,12),wf(:,14))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,15))
  call vert_AZ_Q(gZd,wf(:,13),wf(:,-5),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,7),MB,1_intkind1,wf(:,17))
  call vert_QS_A(gH,wf(:,12),wf(:,-4),wf(:,18))
  call vert_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,19))
  call vert_SV_V(wf(:,-4),wf(:,-5),wf(:,20))
  call prop_W_W(wf(:,20),Q(:,48),MZ,1_intkind1,wf(:,21))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,21),wf(:,22))
  call vert_ZQ_A(gZd,wf(:,21),wf(:,-1),wf(:,23))
  call prop_Q_A(wf(:,23),Q(:,50),MB,1_intkind1,wf(:,24))
  call vert_QS_A(gH,wf(:,0),wf(:,-4),wf(:,25))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,26))
  call prop_Q_A(wf(:,25),Q(:,17),MB,1_intkind1,wf(:,27))
  call vert_VQ_A(wf(:,26),wf(:,27),wf(:,28))
  call vert_AV_Q(wf(:,-3),wf(:,26),wf(:,29))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,27),wf(:,30))
  call prop_A_Q(wf(:,29),Q(:,14),MB,1_intkind1,wf(:,31))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,0),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,33),MB,1_intkind1,wf(:,33))
  call vert_VQ_A(wf(:,26),wf(:,33),wf(:,34))
  call vert_VQ_A(wf(:,26),wf(:,0),wf(:,35))
  call prop_Q_A(wf(:,35),Q(:,7),MB,1_intkind1,wf(:,36))
  call vert_QS_A(gH,wf(:,33),wf(:,-4),wf(:,37))
  call vert_ZQ_A(gZd,wf(:,21),wf(:,0),wf(:,38))
  call prop_Q_A(wf(:,38),Q(:,49),MB,1_intkind1,wf(:,39))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,40))
  call vert_AZ_Q(gZd,wf(:,-2),wf(:,-5),wf(:,41))
  call prop_A_Q(wf(:,41),Q(:,36),MB,1_intkind1,wf(:,42))
  call vert_VQ_A(wf(:,40),wf(:,4),wf(:,43))
  call vert_AV_Q(wf(:,-2),wf(:,40),wf(:,44))
  call prop_A_Q(wf(:,44),Q(:,13),MB,1_intkind1,wf(:,45))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-2),wf(:,46))
  call prop_A_Q(wf(:,46),Q(:,20),MB,1_intkind1,wf(:,47))
  call vert_VQ_A(wf(:,40),wf(:,12),wf(:,48))
  call vert_VQ_A(wf(:,40),wf(:,-1),wf(:,49))
  call vert_AZ_Q(gZd,wf(:,47),wf(:,-5),wf(:,50))
  call prop_Q_A(wf(:,49),Q(:,11),MB,1_intkind1,wf(:,51))
  call vert_SA_Q(gH,wf(:,-4),wf(:,42),wf(:,52))
  call vert_AZ_Q(gZd,wf(:,-2),wf(:,21),wf(:,53))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,54))
  call vert_VQ_A(wf(:,54),wf(:,27),wf(:,55))
  call vert_AV_Q(wf(:,-2),wf(:,54),wf(:,56))
  call prop_A_Q(wf(:,56),Q(:,14),MB,1_intkind1,wf(:,57))
  call vert_VQ_A(wf(:,54),wf(:,33),wf(:,58))
  call vert_VQ_A(wf(:,54),wf(:,0),wf(:,59))
  call prop_Q_A(wf(:,59),Q(:,11),MB,1_intkind1,wf(:,60))
  call vert_QA_V(wf(:,27),wf(:,-2),wf(:,61))
  call vert_QA_V(wf(:,12),wf(:,-3),wf(:,62))
  call vert_QA_V(wf(:,12),wf(:,-2),wf(:,63))
  call vert_QA_V(wf(:,27),wf(:,-3),wf(:,64))
  call vert_QA_V(wf(:,-1),wf(:,42),wf(:,65))
  call vert_QA_V(wf(:,-1),wf(:,5),wf(:,66))
  call vert_QA_V(wf(:,33),wf(:,-2),wf(:,67))
  call vert_QA_V(wf(:,4),wf(:,-3),wf(:,68))
  call vert_QA_V(wf(:,4),wf(:,-2),wf(:,69))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,70))
  call vert_QA_V(wf(:,0),wf(:,42),wf(:,71))
  call vert_QA_V(wf(:,0),wf(:,5),wf(:,72))
  call vert_QA_V(wf(:,-1),wf(:,47),wf(:,73))
  call vert_QA_V(wf(:,0),wf(:,47),wf(:,74))
  call vert_QA_V(wf(:,-1),wf(:,13),wf(:,75))
  call vert_QA_V(wf(:,0),wf(:,13),wf(:,76))
  call counter_GG_V(wf(:,1),Q(:,5),wf(:,54),Q(:,10),wf(:,77))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,78))
  call counter_ZQ_A(gZd,wf(:,-5),wf(:,4),wf(:,79))
  call counter_VG_G(wf(:,-5),wf(:,1),Q(:,5),wf(:,80),Q(:,37))
  call counter_VQ_A(wf(:,1),wf(:,12),wf(:,81))
  call counter_AZ_Q(gZd,wf(:,13),wf(:,-5),wf(:,82))
  call counter_QS_A(gH,wf(:,12),wf(:,-4),wf(:,83))
  call counter_SG_G(wf(:,-4),wf(:,1),wf(:,84))
  call counter_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,85))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,86))
  call prop_Q_A(wf(:,8),Q(:,50),MB,1_intkind1,wf(:,87))
  call counter_AZ_Q(gZd,wf(:,-3),wf(:,-5),wf(:,88))
  call prop_A_Q(wf(:,88),Q(:,40),MB,1_intkind1,wf(:,89))
  call prop_Q_A(wf(:,18),Q(:,50),MB,1_intkind1,wf(:,90))
  call counter_AZ_Q(gZd,wf(:,-3),wf(:,21),wf(:,91))
  call vert_SA_Q(gH,wf(:,-4),wf(:,89),wf(:,92))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,93))
  call prop_A_Q(wf(:,93),Q(:,24),MB,1_intkind1,wf(:,94))
  call vert_AZ_Q(gZd,wf(:,94),wf(:,-5),wf(:,95))
  call counter_GG_V(wf(:,26),Q(:,6),wf(:,40),Q(:,9),wf(:,96))
  call counter_VQ_A(wf(:,26),wf(:,27),wf(:,97))
  call counter_VG_G(wf(:,-5),wf(:,26),Q(:,6),wf(:,98),Q(:,38))
  call counter_ZQ_A(gZd,wf(:,-5),wf(:,27),wf(:,99))
  call counter_VQ_A(wf(:,26),wf(:,33),wf(:,100))
  call counter_SG_G(wf(:,-4),wf(:,26),wf(:,101))
  call counter_QS_A(gH,wf(:,33),wf(:,-4),wf(:,102))
  call counter_AV_Q(wf(:,-3),wf(:,26),wf(:,103))
  call prop_Q_A(wf(:,30),Q(:,49),MB,1_intkind1,wf(:,104))
  call prop_Q_A(wf(:,37),Q(:,49),MB,1_intkind1,wf(:,105))
  call counter_VQ_A(wf(:,40),wf(:,4),wf(:,106))
  call counter_VG_G(wf(:,-5),wf(:,40),Q(:,9),wf(:,107),Q(:,41))
  call counter_VQ_A(wf(:,40),wf(:,12),wf(:,108))
  call counter_AZ_Q(gZd,wf(:,47),wf(:,-5),wf(:,109))
  call counter_SG_G(wf(:,-4),wf(:,40),wf(:,110))
  call counter_SA_Q(gH,wf(:,-4),wf(:,42),wf(:,111))
  call counter_VQ_A(wf(:,54),wf(:,27),wf(:,112))
  call counter_VG_G(wf(:,-5),wf(:,54),Q(:,10),wf(:,113),Q(:,42))
  call counter_VQ_A(wf(:,54),wf(:,33),wf(:,114))
  call counter_SG_G(wf(:,-4),wf(:,54),wf(:,115))
  call counter_QA_V(wf(:,12),wf(:,-3),wf(:,116))
  call counter_QA_V(wf(:,27),wf(:,-3),wf(:,117))
  call vert_QA_V(wf(:,-1),wf(:,89),wf(:,118))
  call counter_QA_V(wf(:,4),wf(:,-3),wf(:,119))
  call counter_QA_V(wf(:,33),wf(:,-3),wf(:,120))
  call vert_QA_V(wf(:,0),wf(:,89),wf(:,121))
  call vert_QA_V(wf(:,-1),wf(:,94),wf(:,122))
  call vert_QA_V(wf(:,0),wf(:,94),wf(:,123))
  call counter_AV_Q(wf(:,-2),wf(:,40),wf(:,124))
  call counter_AZ_Q(gZd,wf(:,-2),wf(:,-5),wf(:,125))
  call prop_A_Q(wf(:,125),Q(:,36),MB,1_intkind1,wf(:,126))
  call counter_AZ_Q(gZd,wf(:,-2),wf(:,21),wf(:,127))
  call vert_SA_Q(gH,wf(:,-4),wf(:,126),wf(:,128))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-2),wf(:,129))
  call prop_A_Q(wf(:,129),Q(:,20),MB,1_intkind1,wf(:,130))
  call vert_AZ_Q(gZd,wf(:,130),wf(:,-5),wf(:,131))
  call counter_AV_Q(wf(:,-2),wf(:,54),wf(:,132))
  call counter_QA_V(wf(:,12),wf(:,-2),wf(:,133))
  call counter_QA_V(wf(:,27),wf(:,-2),wf(:,134))
  call vert_QA_V(wf(:,-1),wf(:,126),wf(:,135))
  call counter_QA_V(wf(:,4),wf(:,-2),wf(:,136))
  call counter_QA_V(wf(:,33),wf(:,-2),wf(:,137))
  call vert_QA_V(wf(:,0),wf(:,126),wf(:,138))
  call vert_QA_V(wf(:,-1),wf(:,130),wf(:,139))
  call vert_QA_V(wf(:,0),wf(:,130),wf(:,140))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,141))
  call prop_A_Q(wf(:,16),Q(:,56),MB,1_intkind1,wf(:,142))
  call counter_ZQ_A(gZd,wf(:,-5),wf(:,-1),wf(:,143))
  call prop_Q_A(wf(:,143),Q(:,34),MB,1_intkind1,wf(:,144))
  call vert_VQ_A(wf(:,1),wf(:,144),wf(:,145))
  call prop_A_Q(wf(:,19),Q(:,56),MB,1_intkind1,wf(:,146))
  call counter_ZQ_A(gZd,wf(:,21),wf(:,-1),wf(:,147))
  call prop_A_Q(wf(:,22),Q(:,56),MB,1_intkind1,wf(:,148))
  call vert_QS_A(gH,wf(:,144),wf(:,-4),wf(:,149))
  call counter_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,150))
  call prop_Q_A(wf(:,150),Q(:,18),MB,1_intkind1,wf(:,151))
  call vert_VQ_A(wf(:,1),wf(:,151),wf(:,152))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,151),wf(:,153))
  call counter_VQ_A(wf(:,40),wf(:,-1),wf(:,154))
  call prop_A_Q(wf(:,50),Q(:,52),MB,1_intkind1,wf(:,155))
  call vert_VQ_A(wf(:,40),wf(:,144),wf(:,156))
  call prop_A_Q(wf(:,52),Q(:,52),MB,1_intkind1,wf(:,157))
  call prop_A_Q(wf(:,53),Q(:,52),MB,1_intkind1,wf(:,158))
  call vert_VQ_A(wf(:,40),wf(:,151),wf(:,159))
  call counter_QA_V(wf(:,-1),wf(:,42),wf(:,160))
  call counter_QA_V(wf(:,-1),wf(:,5),wf(:,161))
  call vert_QA_V(wf(:,144),wf(:,-3),wf(:,162))
  call vert_QA_V(wf(:,144),wf(:,-2),wf(:,163))
  call counter_QA_V(wf(:,-1),wf(:,47),wf(:,164))
  call counter_QA_V(wf(:,-1),wf(:,13),wf(:,165))
  call vert_QA_V(wf(:,151),wf(:,-3),wf(:,166))
  call vert_QA_V(wf(:,151),wf(:,-2),wf(:,167))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,168))
  call vert_VQ_A(wf(:,168),wf(:,27),wf(:,169))
  call vert_AV_Q(wf(:,-2),wf(:,168),wf(:,170))
  call prop_A_Q(wf(:,170),Q(:,14),MB,1_intkind1,wf(:,171))
  call vert_VQ_A(wf(:,168),wf(:,33),wf(:,172))
  call vert_VQ_A(wf(:,168),wf(:,0),wf(:,173))
  call prop_Q_A(wf(:,173),Q(:,11),MB,1_intkind1,wf(:,174))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,175))
  call vert_VQ_A(wf(:,175),wf(:,27),wf(:,176))
  call vert_AV_Q(wf(:,-3),wf(:,175),wf(:,177))
  call prop_A_Q(wf(:,177),Q(:,14),MB,1_intkind1,wf(:,178))
  call vert_VQ_A(wf(:,175),wf(:,33),wf(:,179))
  call vert_VQ_A(wf(:,175),wf(:,0),wf(:,180))
  call prop_Q_A(wf(:,180),Q(:,7),MB,1_intkind1,wf(:,181))
  call counter_VQ_A(wf(:,26),wf(:,0),wf(:,182))
  call counter_ZQ_A(gZd,wf(:,-5),wf(:,0),wf(:,183))
  call prop_Q_A(wf(:,183),Q(:,33),MB,1_intkind1,wf(:,184))
  call vert_VQ_A(wf(:,26),wf(:,184),wf(:,185))
  call counter_ZQ_A(gZd,wf(:,21),wf(:,0),wf(:,186))
  call vert_QS_A(gH,wf(:,184),wf(:,-4),wf(:,187))
  call counter_QS_A(gH,wf(:,0),wf(:,-4),wf(:,188))
  call prop_Q_A(wf(:,188),Q(:,17),MB,1_intkind1,wf(:,189))
  call vert_VQ_A(wf(:,26),wf(:,189),wf(:,190))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,189),wf(:,191))
  call counter_VQ_A(wf(:,54),wf(:,0),wf(:,192))
  call vert_VQ_A(wf(:,54),wf(:,184),wf(:,193))
  call vert_VQ_A(wf(:,54),wf(:,189),wf(:,194))
  call counter_QA_V(wf(:,0),wf(:,42),wf(:,195))
  call counter_QA_V(wf(:,0),wf(:,5),wf(:,196))
  call vert_QA_V(wf(:,184),wf(:,-2),wf(:,197))
  call vert_QA_V(wf(:,184),wf(:,-3),wf(:,198))
  call counter_QA_V(wf(:,0),wf(:,47),wf(:,199))
  call counter_QA_V(wf(:,0),wf(:,13),wf(:,200))
  call vert_QA_V(wf(:,189),wf(:,-2),wf(:,201))
  call vert_QA_V(wf(:,189),wf(:,-3),wf(:,202))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,203))
  call vert_VQ_A(wf(:,203),wf(:,4),wf(:,204))
  call vert_AV_Q(wf(:,-2),wf(:,203),wf(:,205))
  call prop_A_Q(wf(:,205),Q(:,13),MB,1_intkind1,wf(:,206))
  call vert_VQ_A(wf(:,203),wf(:,12),wf(:,207))
  call vert_VQ_A(wf(:,203),wf(:,-1),wf(:,208))
  call prop_Q_A(wf(:,208),Q(:,11),MB,1_intkind1,wf(:,209))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,210))
  call vert_VQ_A(wf(:,210),wf(:,4),wf(:,211))
  call vert_AV_Q(wf(:,-3),wf(:,210),wf(:,212))
  call prop_A_Q(wf(:,212),Q(:,13),MB,1_intkind1,wf(:,213))
  call vert_VQ_A(wf(:,210),wf(:,12),wf(:,214))
  call vert_VQ_A(wf(:,210),wf(:,-1),wf(:,215))
  call prop_Q_A(wf(:,215),Q(:,7),MB,1_intkind1,wf(:,216))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,217))
  call counter_V_V(ctGG,wf(:,1),Q(:,5),wf(:,218))
  call vert_AV_Q(wf(:,5),wf(:,1),wf(:,219))
  call counter_Q_A(ctbb,wf(:,4),Q(:,18),wf(:,220))
  call prop_A_Q(wf(:,219),Q(:,45),MB,1_intkind1,wf(:,221))
  call counter_A_Q(ctbb,wf(:,5),Q(:,40),wf(:,222))
  call prop_Q_A(wf(:,6),Q(:,23),MB,1_intkind1,wf(:,223))
  call vert_AV_Q(wf(:,-3),wf(:,218),wf(:,224))
  call prop_Q_A(wf(:,220),Q(:,18),MB,1_intkind1,wf(:,225))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,225),wf(:,226))
  call counter_A_Q(ctbb,wf(:,9),Q(:,13),wf(:,227))
  call vert_QA_V(wf(:,12),wf(:,13),wf(:,228))
  call vert_AV_Q(wf(:,13),wf(:,1),wf(:,229))
  call counter_Q_A(ctbb,wf(:,12),Q(:,34),wf(:,230))
  call prop_A_Q(wf(:,229),Q(:,29),MB,1_intkind1,wf(:,231))
  call counter_A_Q(ctbb,wf(:,13),Q(:,24),wf(:,232))
  call prop_Q_A(wf(:,14),Q(:,39),MB,1_intkind1,wf(:,233))
  call vert_VQ_A(wf(:,218),wf(:,-1),wf(:,234))
  call counter_Q_A(ctbb,wf(:,17),Q(:,7),wf(:,235))
  call prop_A_Q(wf(:,232),Q(:,24),MB,1_intkind1,wf(:,236))
  call vert_AZ_Q(gZd,wf(:,236),wf(:,-5),wf(:,237))
  call prop_Q_A(wf(:,230),Q(:,34),MB,1_intkind1,wf(:,238))
  call vert_QS_A(gH,wf(:,238),wf(:,-4),wf(:,239))
  call prop_A_Q(wf(:,222),Q(:,40),MB,1_intkind1,wf(:,240))
  call vert_SA_Q(gH,wf(:,-4),wf(:,240),wf(:,241))
  call counter_Q_A(ctbb,wf(:,24),Q(:,50),wf(:,242))
  call vert_AV_Q(wf(:,5),wf(:,26),wf(:,243))
  call counter_Q_A(ctbb,wf(:,27),Q(:,17),wf(:,244))
  call prop_A_Q(wf(:,243),Q(:,46),MB,1_intkind1,wf(:,245))
  call vert_QA_V(wf(:,27),wf(:,5),wf(:,246))
  call counter_V_V(ctGG,wf(:,26),Q(:,6),wf(:,247))
  call prop_Q_A(wf(:,28),Q(:,23),MB,1_intkind1,wf(:,248))
  call prop_Q_A(wf(:,244),Q(:,17),MB,1_intkind1,wf(:,249))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,249),wf(:,250))
  call vert_AV_Q(wf(:,-3),wf(:,247),wf(:,251))
  call counter_A_Q(ctbb,wf(:,31),Q(:,14),wf(:,252))
  call vert_AV_Q(wf(:,13),wf(:,26),wf(:,253))
  call counter_Q_A(ctbb,wf(:,33),Q(:,33),wf(:,254))
  call prop_A_Q(wf(:,253),Q(:,30),MB,1_intkind1,wf(:,255))
  call vert_QA_V(wf(:,33),wf(:,13),wf(:,256))
  call prop_Q_A(wf(:,34),Q(:,39),MB,1_intkind1,wf(:,257))
  call vert_VQ_A(wf(:,247),wf(:,0),wf(:,258))
  call counter_Q_A(ctbb,wf(:,36),Q(:,7),wf(:,259))
  call prop_Q_A(wf(:,254),Q(:,33),MB,1_intkind1,wf(:,260))
  call vert_QS_A(gH,wf(:,260),wf(:,-4),wf(:,261))
  call counter_Q_A(ctbb,wf(:,39),Q(:,49),wf(:,262))
  call vert_QA_V(wf(:,4),wf(:,42),wf(:,263))
  call counter_V_V(ctGG,wf(:,40),Q(:,9),wf(:,264))
  call vert_AV_Q(wf(:,42),wf(:,40),wf(:,265))
  call prop_A_Q(wf(:,265),Q(:,45),MB,1_intkind1,wf(:,266))
  call counter_A_Q(ctbb,wf(:,42),Q(:,36),wf(:,267))
  call prop_Q_A(wf(:,43),Q(:,27),MB,1_intkind1,wf(:,268))
  call vert_AV_Q(wf(:,-2),wf(:,264),wf(:,269))
  call counter_A_Q(ctbb,wf(:,45),Q(:,13),wf(:,270))
  call vert_QA_V(wf(:,12),wf(:,47),wf(:,271))
  call vert_AV_Q(wf(:,47),wf(:,40),wf(:,272))
  call prop_A_Q(wf(:,272),Q(:,29),MB,1_intkind1,wf(:,273))
  call counter_A_Q(ctbb,wf(:,47),Q(:,20),wf(:,274))
  call prop_Q_A(wf(:,48),Q(:,43),MB,1_intkind1,wf(:,275))
  call vert_VQ_A(wf(:,264),wf(:,-1),wf(:,276))
  call counter_Q_A(ctbb,wf(:,51),Q(:,11),wf(:,277))
  call prop_A_Q(wf(:,274),Q(:,20),MB,1_intkind1,wf(:,278))
  call vert_AZ_Q(gZd,wf(:,278),wf(:,-5),wf(:,279))
  call prop_A_Q(wf(:,267),Q(:,36),MB,1_intkind1,wf(:,280))
  call vert_SA_Q(gH,wf(:,-4),wf(:,280),wf(:,281))
  call vert_AV_Q(wf(:,42),wf(:,54),wf(:,282))
  call prop_A_Q(wf(:,282),Q(:,46),MB,1_intkind1,wf(:,283))
  call vert_QA_V(wf(:,27),wf(:,42),wf(:,284))
  call counter_V_V(ctGG,wf(:,54),Q(:,10),wf(:,285))
  call prop_Q_A(wf(:,55),Q(:,27),MB,1_intkind1,wf(:,286))
  call vert_AV_Q(wf(:,-2),wf(:,285),wf(:,287))
  call counter_A_Q(ctbb,wf(:,57),Q(:,14),wf(:,288))
  call vert_AV_Q(wf(:,47),wf(:,54),wf(:,289))
  call prop_A_Q(wf(:,289),Q(:,30),MB,1_intkind1,wf(:,290))
  call vert_QA_V(wf(:,33),wf(:,47),wf(:,291))
  call prop_Q_A(wf(:,58),Q(:,43),MB,1_intkind1,wf(:,292))
  call vert_VQ_A(wf(:,285),wf(:,0),wf(:,293))
  call counter_Q_A(ctbb,wf(:,60),Q(:,11),wf(:,294))
  call vert_QA_V(wf(:,249),wf(:,-2),wf(:,295))
  call vert_QA_V(wf(:,249),wf(:,-3),wf(:,296))
  call vert_QA_V(wf(:,238),wf(:,-2),wf(:,297))
  call vert_QA_V(wf(:,238),wf(:,-3),wf(:,298))
  call counter_V_V(ctGG,wf(:,61),Q(:,21),wf(:,299))
  call counter_V_V(ctGG,wf(:,63),Q(:,38),wf(:,300))
  call vert_QA_V(wf(:,-1),wf(:,280),wf(:,301))
  call counter_V_V(ctGG,wf(:,65),Q(:,38),wf(:,302))
  call counter_V_V(ctGG,wf(:,66),Q(:,42),wf(:,303))
  call vert_QA_V(wf(:,-1),wf(:,240),wf(:,304))
  call vert_QA_V(wf(:,260),wf(:,-2),wf(:,305))
  call vert_QA_V(wf(:,260),wf(:,-3),wf(:,306))
  call vert_QA_V(wf(:,225),wf(:,-2),wf(:,307))
  call vert_QA_V(wf(:,225),wf(:,-3),wf(:,308))
  call counter_V_V(ctGG,wf(:,67),Q(:,37),wf(:,309))
  call counter_V_V(ctGG,wf(:,69),Q(:,22),wf(:,310))
  call vert_QA_V(wf(:,0),wf(:,280),wf(:,311))
  call counter_V_V(ctGG,wf(:,71),Q(:,37),wf(:,312))
  call counter_V_V(ctGG,wf(:,72),Q(:,41),wf(:,313))
  call vert_QA_V(wf(:,0),wf(:,240),wf(:,314))
  call vert_QA_V(wf(:,-1),wf(:,278),wf(:,315))
  call counter_V_V(ctGG,wf(:,73),Q(:,22),wf(:,316))
  call vert_QA_V(wf(:,0),wf(:,278),wf(:,317))
  call counter_V_V(ctGG,wf(:,74),Q(:,21),wf(:,318))
  call counter_V_V(ctGG,wf(:,75),Q(:,26),wf(:,319))
  call vert_QA_V(wf(:,-1),wf(:,236),wf(:,320))
  call counter_V_V(ctGG,wf(:,76),Q(:,25),wf(:,321))
  call vert_QA_V(wf(:,0),wf(:,236),wf(:,322))
  call vert_QS_A(gH,wf(:,17),wf(:,-4),wf(:,323))
  call prop_Q_A(wf(:,323),Q(:,23),MB,1_intkind1,wf(:,324))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,17),wf(:,325))
  call prop_Q_A(wf(:,325),Q(:,39),MB,1_intkind1,wf(:,326))
  call vert_SA_Q(gH,wf(:,-4),wf(:,9),wf(:,327))
  call prop_A_Q(wf(:,327),Q(:,29),MB,1_intkind1,wf(:,328))
  call vert_AZ_Q(gZd,wf(:,9),wf(:,-5),wf(:,329))
  call prop_A_Q(wf(:,329),Q(:,45),MB,1_intkind1,wf(:,330))
  call vert_QS_A(gH,wf(:,36),wf(:,-4),wf(:,331))
  call prop_Q_A(wf(:,331),Q(:,23),MB,1_intkind1,wf(:,332))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,36),wf(:,333))
  call prop_Q_A(wf(:,333),Q(:,39),MB,1_intkind1,wf(:,334))
  call vert_SA_Q(gH,wf(:,-4),wf(:,31),wf(:,335))
  call prop_A_Q(wf(:,335),Q(:,30),MB,1_intkind1,wf(:,336))
  call vert_AZ_Q(gZd,wf(:,31),wf(:,-5),wf(:,337))
  call prop_A_Q(wf(:,337),Q(:,46),MB,1_intkind1,wf(:,338))
  call vert_QS_A(gH,wf(:,51),wf(:,-4),wf(:,339))
  call prop_Q_A(wf(:,339),Q(:,27),MB,1_intkind1,wf(:,340))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,51),wf(:,341))
  call prop_Q_A(wf(:,341),Q(:,43),MB,1_intkind1,wf(:,342))
  call vert_SA_Q(gH,wf(:,-4),wf(:,45),wf(:,343))
  call prop_A_Q(wf(:,343),Q(:,29),MB,1_intkind1,wf(:,344))
  call vert_AZ_Q(gZd,wf(:,45),wf(:,-5),wf(:,345))
  call prop_A_Q(wf(:,345),Q(:,45),MB,1_intkind1,wf(:,346))
  call vert_QS_A(gH,wf(:,60),wf(:,-4),wf(:,347))
  call prop_Q_A(wf(:,347),Q(:,27),MB,1_intkind1,wf(:,348))
  call vert_ZQ_A(gZd,wf(:,-5),wf(:,60),wf(:,349))
  call prop_Q_A(wf(:,349),Q(:,43),MB,1_intkind1,wf(:,350))
  call vert_SA_Q(gH,wf(:,-4),wf(:,57),wf(:,351))
  call prop_A_Q(wf(:,351),Q(:,30),MB,1_intkind1,wf(:,352))
  call vert_AZ_Q(gZd,wf(:,57),wf(:,-5),wf(:,353))
  call prop_A_Q(wf(:,353),Q(:,46),MB,1_intkind1,wf(:,354))
  call vert_VQ_A(wf(:,61),wf(:,-1),wf(:,355))
  call prop_Q_A(wf(:,355),Q(:,23),MB,1_intkind1,wf(:,356))
  call vert_AV_Q(wf(:,-3),wf(:,61),wf(:,357))
  call prop_A_Q(wf(:,357),Q(:,29),MB,1_intkind1,wf(:,358))
  call vert_VQ_A(wf(:,64),wf(:,-1),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,27),MB,1_intkind1,wf(:,360))
  call vert_AV_Q(wf(:,-2),wf(:,64),wf(:,361))
  call prop_A_Q(wf(:,361),Q(:,29),MB,1_intkind1,wf(:,362))
  call vert_QA_V(wf(:,104),wf(:,-2),wf(:,363))
  call vert_QA_V(wf(:,104),wf(:,-3),wf(:,364))
  call vert_VQ_A(wf(:,69),wf(:,0),wf(:,365))
  call prop_Q_A(wf(:,365),Q(:,23),MB,1_intkind1,wf(:,366))
  call vert_VQ_A(wf(:,68),wf(:,0),wf(:,367))
  call prop_Q_A(wf(:,367),Q(:,27),MB,1_intkind1,wf(:,368))
  call vert_AV_Q(wf(:,-3),wf(:,69),wf(:,369))
  call prop_A_Q(wf(:,369),Q(:,30),MB,1_intkind1,wf(:,370))
  call vert_AV_Q(wf(:,-2),wf(:,68),wf(:,371))
  call prop_A_Q(wf(:,371),Q(:,30),MB,1_intkind1,wf(:,372))
  call vert_QA_V(wf(:,87),wf(:,-2),wf(:,373))
  call vert_QA_V(wf(:,87),wf(:,-3),wf(:,374))
  call vert_VQ_A(wf(:,74),wf(:,-1),wf(:,375))
  call prop_Q_A(wf(:,375),Q(:,23),MB,1_intkind1,wf(:,376))
  call vert_VQ_A(wf(:,73),wf(:,0),wf(:,377))
  call prop_Q_A(wf(:,377),Q(:,23),MB,1_intkind1,wf(:,378))
  call vert_AV_Q(wf(:,-3),wf(:,74),wf(:,379))
  call prop_A_Q(wf(:,379),Q(:,29),MB,1_intkind1,wf(:,380))
  call vert_QA_V(wf(:,0),wf(:,155),wf(:,381))
  call vert_AV_Q(wf(:,-3),wf(:,73),wf(:,382))
  call prop_A_Q(wf(:,382),Q(:,30),MB,1_intkind1,wf(:,383))
  call vert_QA_V(wf(:,-1),wf(:,155),wf(:,384))
  call vert_VQ_A(wf(:,76),wf(:,-1),wf(:,385))
  call prop_Q_A(wf(:,385),Q(:,27),MB,1_intkind1,wf(:,386))
  call vert_VQ_A(wf(:,75),wf(:,0),wf(:,387))
  call prop_Q_A(wf(:,387),Q(:,27),MB,1_intkind1,wf(:,388))
  call vert_AV_Q(wf(:,-2),wf(:,76),wf(:,389))
  call prop_A_Q(wf(:,389),Q(:,29),MB,1_intkind1,wf(:,390))
  call vert_QA_V(wf(:,0),wf(:,142),wf(:,391))
  call vert_AV_Q(wf(:,-2),wf(:,75),wf(:,392))
  call prop_A_Q(wf(:,392),Q(:,30),MB,1_intkind1,wf(:,393))
  call vert_QA_V(wf(:,-1),wf(:,142),wf(:,394))
  call vert_VQ_A(wf(:,67),wf(:,-1),wf(:,395))
  call prop_Q_A(wf(:,395),Q(:,39),MB,1_intkind1,wf(:,396))
  call vert_AV_Q(wf(:,-3),wf(:,67),wf(:,397))
  call prop_A_Q(wf(:,397),Q(:,45),MB,1_intkind1,wf(:,398))
  call vert_VQ_A(wf(:,70),wf(:,-1),wf(:,399))
  call prop_Q_A(wf(:,399),Q(:,43),MB,1_intkind1,wf(:,400))
  call vert_AV_Q(wf(:,-2),wf(:,70),wf(:,401))
  call prop_A_Q(wf(:,401),Q(:,45),MB,1_intkind1,wf(:,402))
  call vert_QA_V(wf(:,105),wf(:,-2),wf(:,403))
  call vert_QA_V(wf(:,105),wf(:,-3),wf(:,404))
  call vert_VQ_A(wf(:,63),wf(:,0),wf(:,405))
  call prop_Q_A(wf(:,405),Q(:,39),MB,1_intkind1,wf(:,406))
  call vert_VQ_A(wf(:,62),wf(:,0),wf(:,407))
  call prop_Q_A(wf(:,407),Q(:,43),MB,1_intkind1,wf(:,408))
  call vert_AV_Q(wf(:,-3),wf(:,63),wf(:,409))
  call prop_A_Q(wf(:,409),Q(:,46),MB,1_intkind1,wf(:,410))
  call vert_AV_Q(wf(:,-2),wf(:,62),wf(:,411))
  call prop_A_Q(wf(:,411),Q(:,46),MB,1_intkind1,wf(:,412))
  call vert_QA_V(wf(:,90),wf(:,-2),wf(:,413))
  call vert_QA_V(wf(:,90),wf(:,-3),wf(:,414))
  call vert_VQ_A(wf(:,71),wf(:,-1),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,39),MB,1_intkind1,wf(:,416))
  call vert_VQ_A(wf(:,65),wf(:,0),wf(:,417))
  call prop_Q_A(wf(:,417),Q(:,39),MB,1_intkind1,wf(:,418))
  call vert_AV_Q(wf(:,-3),wf(:,71),wf(:,419))
  call prop_A_Q(wf(:,419),Q(:,45),MB,1_intkind1,wf(:,420))
  call vert_QA_V(wf(:,0),wf(:,157),wf(:,421))
  call vert_AV_Q(wf(:,-3),wf(:,65),wf(:,422))
  call prop_A_Q(wf(:,422),Q(:,46),MB,1_intkind1,wf(:,423))
  call vert_QA_V(wf(:,-1),wf(:,157),wf(:,424))
  call vert_VQ_A(wf(:,72),wf(:,-1),wf(:,425))
  call prop_Q_A(wf(:,425),Q(:,43),MB,1_intkind1,wf(:,426))
  call vert_VQ_A(wf(:,66),wf(:,0),wf(:,427))
  call prop_Q_A(wf(:,427),Q(:,43),MB,1_intkind1,wf(:,428))
  call vert_AV_Q(wf(:,-2),wf(:,72),wf(:,429))
  call prop_A_Q(wf(:,429),Q(:,45),MB,1_intkind1,wf(:,430))
  call vert_QA_V(wf(:,0),wf(:,146),wf(:,431))
  call vert_AV_Q(wf(:,-2),wf(:,66),wf(:,432))
  call prop_A_Q(wf(:,432),Q(:,46),MB,1_intkind1,wf(:,433))
  call vert_QA_V(wf(:,-1),wf(:,146),wf(:,434))
  call vert_QA_V(wf(:,39),wf(:,-2),wf(:,435))
  call vert_QA_V(wf(:,0),wf(:,158),wf(:,436))
  call vert_QA_V(wf(:,39),wf(:,-3),wf(:,437))
  call vert_QA_V(wf(:,0),wf(:,148),wf(:,438))
  call vert_QA_V(wf(:,24),wf(:,-2),wf(:,439))
  call vert_QA_V(wf(:,-1),wf(:,158),wf(:,440))
  call vert_QA_V(wf(:,24),wf(:,-3),wf(:,441))
  call vert_QA_V(wf(:,-1),wf(:,148),wf(:,442))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,18) - MB2)
  den(3) = 1 / (Q(5,40) - MB2)
  den(6) = 1 / (Q(5,13) - MB2)
  den(9) = 1 / (Q(5,34) - MB2)
  den(10) = 1 / (Q(5,24) - MB2)
  den(13) = 1 / (Q(5,7) - MB2)
  den(18) = 1 / (Q(5,48) - MZ2)
  den(20) = 1 / (Q(5,50) - MB2)
  den(23) = 1 / (Q(5,17) - MB2)
  den(24) = 1 / (Q(5,6))
  den(27) = 1 / (Q(5,14) - MB2)
  den(30) = 1 / (Q(5,33) - MB2)
  den(38) = 1 / (Q(5,49) - MB2)
  den(41) = 1 / (Q(5,9))
  den(42) = 1 / (Q(5,36) - MB2)
  den(47) = 1 / (Q(5,20) - MB2)
  den(50) = 1 / (Q(5,11) - MB2)
  den(57) = 1 / (Q(5,10))
  den(70) = 1 / (Q(5,21))
  den(73) = 1 / (Q(5,38))
  den(78) = 1 / (Q(5,42))
  den(81) = 1 / (Q(5,37))
  den(84) = 1 / (Q(5,22))
  den(89) = 1 / (Q(5,41))
  den(98) = 1 / (Q(5,26))
  den(101) = 1 / (Q(5,25))
  den(146) = 1 / (Q(5,56) - MB2)
  den(154) = 1 / (Q(5,52) - MB2)
  den(183) = 1 / (Q(5,58))
  den(187) = 1 / (Q(5,45) - MB2)
  den(190) = 1 / (Q(5,23) - MB2)
  den(202) = 1 / (Q(5,29) - MB2)
  den(205) = 1 / (Q(5,39) - MB2)
  den(225) = 1 / (Q(5,46) - MB2)
  den(229) = 1 / (Q(5,57))
  den(240) = 1 / (Q(5,30) - MB2)
  den(263) = 1 / (Q(5,54))
  den(269) = 1 / (Q(5,27) - MB2)
  den(282) = 1 / (Q(5,43) - MB2)
  den(304) = 1 / (Q(5,53))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(17) = den(3)*den(14)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(25) = den(23)*den(24)
  den(26) = den(3)*den(25)
  den(28) = den(24)*den(27)
  den(29) = den(23)*den(28)
  den(31) = den(24)*den(30)
  den(32) = den(10)*den(31)
  den(33) = den(13)*den(24)
  den(34) = den(10)*den(33)
  den(35) = den(28)*den(30)
  den(36) = den(3)*den(33)
  den(37) = den(18)*den(33)
  den(39) = den(18)*den(38)
  den(40) = den(24)*den(39)
  den(43) = den(2)*den(41)
  den(44) = den(42)*den(43)
  den(45) = den(6)*den(41)
  den(46) = den(2)*den(45)
  den(48) = den(9)*den(41)
  den(49) = den(47)*den(48)
  den(51) = den(41)*den(50)
  den(52) = den(47)*den(51)
  den(53) = den(9)*den(45)
  den(54) = den(42)*den(51)
  den(55) = den(18)*den(51)
  den(56) = den(21)*den(41)
  den(58) = den(23)*den(57)
  den(59) = den(42)*den(58)
  den(60) = den(27)*den(57)
  den(61) = den(23)*den(60)
  den(62) = den(30)*den(57)
  den(63) = den(47)*den(62)
  den(64) = den(50)*den(57)
  den(65) = den(47)*den(64)
  den(66) = den(30)*den(60)
  den(67) = den(42)*den(64)
  den(68) = den(18)*den(64)
  den(69) = den(39)*den(57)
  den(71) = den(23)*den(70)
  den(72) = den(9)*den(71)
  den(74) = den(9)*den(73)
  den(75) = den(23)*den(74)
  den(76) = den(42)*den(73)
  den(77) = den(23)*den(76)
  den(79) = den(3)*den(78)
  den(80) = den(23)*den(79)
  den(82) = den(30)*den(81)
  den(83) = den(2)*den(82)
  den(85) = den(2)*den(84)
  den(86) = den(30)*den(85)
  den(87) = den(42)*den(81)
  den(88) = den(2)*den(87)
  den(90) = den(3)*den(89)
  den(91) = den(2)*den(90)
  den(92) = den(47)*den(84)
  den(93) = den(30)*den(92)
  den(94) = den(47)*den(70)
  den(95) = den(9)*den(94)
  den(96) = den(3)*den(94)
  den(97) = den(47)*den(90)
  den(99) = den(10)*den(98)
  den(100) = den(30)*den(99)
  den(102) = den(10)*den(101)
  den(103) = den(9)*den(102)
  den(104) = den(10)*den(87)
  den(105) = den(42)*den(102)
  den(106) = den(1)*den(57)
  den(107) = den(18)*den(106)
  den(108) = den(2)*den(98)
  den(109) = den(1)*den(108)
  den(110) = den(1)*den(99)
  den(111) = den(9)*den(78)
  den(112) = den(1)*den(111)
  den(113) = den(1)*den(79)
  den(114) = den(2)*den(20)
  den(115) = den(1)*den(114)
  den(116) = den(9)*den(20)
  den(117) = den(1)*den(116)
  den(118) = den(24)*den(41)
  den(119) = den(18)*den(118)
  den(120) = den(23)*den(101)
  den(121) = den(24)*den(120)
  den(122) = den(24)*den(102)
  den(123) = den(30)*den(89)
  den(124) = den(24)*den(123)
  den(125) = den(24)*den(90)
  den(126) = den(23)*den(38)
  den(127) = den(24)*den(126)
  den(128) = den(30)*den(38)
  den(129) = den(24)*den(128)
  den(130) = den(41)*den(85)
  den(131) = den(41)*den(92)
  den(132) = den(41)*den(74)
  den(133) = den(41)*den(76)
  den(134) = den(57)*den(71)
  den(135) = den(57)*den(94)
  den(136) = den(57)*den(82)
  den(137) = den(57)*den(87)
  den(138) = den(41)*den(114)
  den(139) = den(41)*den(116)
  den(140) = den(57)*den(126)
  den(141) = den(57)*den(128)
  den(142) = den(9)*den(120)
  den(143) = den(23)*den(111)
  den(144) = den(2)*den(123)
  den(145) = den(30)*den(108)
  den(147) = den(10)*den(146)
  den(148) = den(1)*den(147)
  den(149) = den(3)*den(146)
  den(150) = den(1)*den(149)
  den(151) = den(7)*den(18)
  den(152) = den(18)*den(146)
  den(153) = den(1)*den(152)
  den(155) = den(47)*den(154)
  den(156) = den(41)*den(155)
  den(157) = den(42)*den(154)
  den(158) = den(41)*den(157)
  den(159) = den(18)*den(45)
  den(160) = den(18)*den(154)
  den(161) = den(41)*den(160)
  den(162) = den(42)*den(120)
  den(163) = den(3)*den(71)
  den(164) = den(47)*den(123)
  den(165) = den(10)*den(82)
  den(166) = den(24)*den(147)
  den(167) = den(24)*den(149)
  den(168) = den(24)*den(152)
  den(169) = den(18)*den(28)
  den(170) = den(57)*den(155)
  den(171) = den(57)*den(157)
  den(172) = den(57)*den(160)
  den(173) = den(18)*den(60)
  den(174) = den(42)*den(108)
  den(175) = den(3)*den(85)
  den(176) = den(47)*den(111)
  den(177) = den(47)*den(79)
  den(178) = den(3)*den(92)
  den(179) = den(10)*den(74)
  den(180) = den(42)*den(99)
  den(181) = den(10)*den(76)
  den(182) = den(2)*den(3)
  den(184) = den(182)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(1)*den(3)
  den(188) = den(186)*den(187)
  den(189) = den(2)*den(188)
  den(191) = den(4)*den(190)
  den(192) = den(3)*den(191)
  den(193) = den(1)**2
  den(194) = den(114)*den(193)
  den(195) = den(2)**2
  den(196) = den(7)*den(195)
  den(197) = den(7)*den(114)
  den(198) = den(9)*den(10)
  den(199) = den(183)*den(198)
  den(200) = den(1)*den(199)
  den(201) = den(1)*den(10)
  den(203) = den(201)*den(202)
  den(204) = den(9)*den(203)
  den(206) = den(11)*den(205)
  den(207) = den(10)*den(206)
  den(208) = den(147)*den(193)
  den(209) = den(14)*den(147)
  den(210) = den(10)**2
  den(211) = den(14)*den(210)
  den(212) = den(116)*den(193)
  den(213) = den(9)**2
  den(214) = den(7)*den(213)
  den(215) = den(7)*den(116)
  den(216) = den(149)*den(193)
  den(217) = den(14)*den(149)
  den(218) = den(3)**2
  den(219) = den(14)*den(218)
  den(220) = den(152)*den(193)
  den(221) = den(21)*den(193)
  den(222) = den(14)*den(152)
  den(223) = den(7)*den(21)
  den(224) = den(3)*den(24)
  den(226) = den(224)*den(225)
  den(227) = den(23)*den(226)
  den(228) = den(3)*den(23)
  den(230) = den(228)*den(229)
  den(231) = den(24)*den(230)
  den(232) = den(25)*den(190)
  den(233) = den(3)*den(232)
  den(234) = den(23)**2
  den(235) = den(28)*den(234)
  den(236) = den(24)**2
  den(237) = den(126)*den(236)
  den(238) = den(28)*den(126)
  den(239) = den(10)*den(24)
  den(241) = den(239)*den(240)
  den(242) = den(30)*den(241)
  den(243) = den(10)*den(30)
  den(244) = den(229)*den(243)
  den(245) = den(24)*den(244)
  den(246) = den(31)*den(205)
  den(247) = den(10)*den(246)
  den(248) = den(147)*den(236)
  den(249) = den(33)*den(147)
  den(250) = den(33)*den(210)
  den(251) = den(30)**2
  den(252) = den(28)*den(251)
  den(253) = den(128)*den(236)
  den(254) = den(28)*den(128)
  den(255) = den(149)*den(236)
  den(256) = den(33)*den(149)
  den(257) = den(33)*den(218)
  den(258) = den(152)*den(236)
  den(259) = den(33)*den(152)
  den(260) = den(28)*den(39)
  den(261) = den(39)*den(236)
  den(262) = den(2)*den(42)
  den(264) = den(262)*den(263)
  den(265) = den(41)*den(264)
  den(266) = den(41)*den(42)
  den(267) = den(187)*den(266)
  den(268) = den(2)*den(267)
  den(270) = den(43)*den(269)
  den(271) = den(42)*den(270)
  den(272) = den(41)**2
  den(273) = den(114)*den(272)
  den(274) = den(45)*den(195)
  den(275) = den(45)*den(114)
  den(276) = den(9)*den(47)
  den(277) = den(263)*den(276)
  den(278) = den(41)*den(277)
  den(279) = den(41)*den(47)
  den(280) = den(202)*den(279)
  den(281) = den(9)*den(280)
  den(283) = den(48)*den(282)
  den(284) = den(47)*den(283)
  den(285) = den(155)*den(272)
  den(286) = den(51)*den(155)
  den(287) = den(47)**2
  den(288) = den(51)*den(287)
  den(289) = den(116)*den(272)
  den(290) = den(45)*den(213)
  den(291) = den(45)*den(116)
  den(292) = den(157)*den(272)
  den(293) = den(51)*den(157)
  den(294) = den(42)**2
  den(295) = den(51)*den(294)
  den(296) = den(160)*den(272)
  den(297) = den(21)*den(272)
  den(298) = den(51)*den(160)
  den(299) = den(21)*den(45)
  den(300) = den(42)*den(57)
  den(301) = den(225)*den(300)
  den(302) = den(23)*den(301)
  den(303) = den(23)*den(42)
  den(305) = den(303)*den(304)
  den(306) = den(57)*den(305)
  den(307) = den(58)*den(269)
  den(308) = den(42)*den(307)
  den(309) = den(60)*den(234)
  den(310) = den(57)**2
  den(311) = den(126)*den(310)
  den(312) = den(60)*den(126)
  den(313) = den(47)*den(57)
  den(314) = den(240)*den(313)
  den(315) = den(30)*den(314)
  den(316) = den(30)*den(47)
  den(317) = den(304)*den(316)
  den(318) = den(57)*den(317)
  den(319) = den(62)*den(282)
  den(320) = den(47)*den(319)
  den(321) = den(155)*den(310)
  den(322) = den(64)*den(155)
  den(323) = den(64)*den(287)
  den(324) = den(60)*den(251)
  den(325) = den(128)*den(310)
  den(326) = den(60)*den(128)
  den(327) = den(157)*den(310)
  den(328) = den(64)*den(157)
  den(329) = den(64)*den(294)
  den(330) = den(160)*den(310)
  den(331) = den(64)*den(160)
  den(332) = den(39)*den(60)
  den(333) = den(39)*den(310)
  den(334) = den(111)*den(234)
  den(335) = den(74)*den(234)
  den(336) = den(120)*den(213)
  den(337) = den(71)*den(213)
  den(338) = den(71)*den(111)
  den(339) = den(74)*den(120)
  den(340) = den(76)*den(234)
  den(341) = den(120)*den(294)
  den(342) = den(76)*den(120)
  den(343) = den(79)*den(234)
  den(344) = den(71)*den(79)
  den(345) = den(71)*den(218)
  den(346) = den(108)*den(251)
  den(347) = den(85)*den(251)
  den(348) = den(123)*den(195)
  den(349) = den(82)*den(195)
  den(350) = den(82)*den(108)
  den(351) = den(85)*den(123)
  den(352) = den(108)*den(294)
  den(353) = den(87)*den(108)
  den(354) = den(87)*den(195)
  den(355) = den(85)*den(90)
  den(356) = den(85)*den(218)
  den(357) = den(90)*den(195)
  den(358) = den(92)*den(251)
  den(359) = den(123)*den(287)
  den(360) = den(92)*den(123)
  den(361) = den(111)*den(287)
  den(362) = den(94)*den(111)
  den(363) = den(94)*den(213)
  den(364) = den(79)*den(94)
  den(365) = den(90)*den(92)
  den(366) = den(79)*den(287)
  den(367) = den(92)*den(218)
  den(368) = den(90)*den(287)
  den(369) = den(94)*den(218)
  den(370) = den(99)*den(251)
  den(371) = den(82)*den(99)
  den(372) = den(82)*den(210)
  den(373) = den(74)*den(102)
  den(374) = den(74)*den(210)
  den(375) = den(102)*den(213)
  den(376) = den(87)*den(99)
  den(377) = den(76)*den(102)
  den(378) = den(99)*den(294)
  den(379) = den(76)*den(210)
  den(380) = den(102)*den(294)
  den(381) = den(87)*den(210)
  den(382) = den(14)*den(190)
  den(383) = den(14)*den(205)
  den(384) = den(7)*den(202)
  den(385) = den(7)*den(187)
  den(386) = den(33)*den(190)
  den(387) = den(33)*den(205)
  den(388) = den(28)*den(240)
  den(389) = den(28)*den(225)
  den(390) = den(51)*den(269)
  den(391) = den(51)*den(282)
  den(392) = den(45)*den(202)
  den(393) = den(45)*den(187)
  den(394) = den(64)*den(269)
  den(395) = den(64)*den(282)
  den(396) = den(60)*den(240)
  den(397) = den(60)*den(225)
  den(398) = den(71)*den(190)
  den(399) = den(71)*den(202)
  den(400) = den(120)*den(269)
  den(401) = den(120)*den(202)
  den(402) = den(126)*den(304)
  den(403) = den(126)*den(229)
  den(404) = den(85)*den(190)
  den(405) = den(108)*den(269)
  den(406) = den(85)*den(240)
  den(407) = den(108)*den(240)
  den(408) = den(114)*den(263)
  den(409) = den(114)*den(183)
  den(410) = den(94)*den(190)
  den(411) = den(92)*den(190)
  den(412) = den(94)*den(202)
  den(413) = den(155)*den(304)
  den(414) = den(92)*den(240)
  den(415) = den(155)*den(263)
  den(416) = den(102)*den(269)
  den(417) = den(99)*den(269)
  den(418) = den(102)*den(202)
  den(419) = den(147)*den(229)
  den(420) = den(99)*den(240)
  den(421) = den(147)*den(183)
  den(422) = den(82)*den(205)
  den(423) = den(82)*den(187)
  den(424) = den(123)*den(282)
  den(425) = den(123)*den(187)
  den(426) = den(128)*den(304)
  den(427) = den(128)*den(229)
  den(428) = den(74)*den(205)
  den(429) = den(111)*den(282)
  den(430) = den(74)*den(225)
  den(431) = den(111)*den(225)
  den(432) = den(116)*den(263)
  den(433) = den(116)*den(183)
  den(434) = den(87)*den(205)
  den(435) = den(76)*den(205)
  den(436) = den(87)*den(187)
  den(437) = den(157)*den(304)
  den(438) = den(76)*den(225)
  den(439) = den(157)*den(263)
  den(440) = den(90)*den(282)
  den(441) = den(79)*den(282)
  den(442) = den(90)*den(187)
  den(443) = den(149)*den(229)
  den(444) = den(79)*den(225)
  den(445) = den(149)*den(183)
  den(446) = den(39)*den(304)
  den(447) = den(160)*den(304)
  den(448) = den(39)*den(229)
  den(449) = den(152)*den(229)
  den(450) = den(21)*den(263)
  den(451) = den(160)*den(263)
  den(452) = den(21)*den(183)
  den(453) = den(152)*den(183)
  den(454) = den(1)*den(18)*den(57)
  den(455) = den(1)*den(2)*den(3)
  den(456) = den(1)*den(9)*den(10)
  den(457) = den(1)*den(18)
  den(458) = den(18)*den(24)*den(41)
  den(459) = den(3)*den(23)*den(24)
  den(460) = den(10)*den(24)*den(30)
  den(461) = den(18)*den(24)
  den(462) = den(2)*den(41)*den(42)
  den(463) = den(9)*den(41)*den(47)
  den(464) = den(18)*den(41)
  den(465) = den(23)*den(42)*den(57)
  den(466) = den(30)*den(47)*den(57)
  den(467) = den(18)*den(57)
  den(468) = den(9)*den(23)
  den(469) = den(2)*den(30)
  den(470) = den(3)*den(47)
  den(471) = den(10)*den(42)
  den(472) = den(2)*den(385)
  den(473) = den(1)*den(409)
  den(474) = den(10)*den(383)
  den(475) = den(1)*den(421)
  den(476) = den(9)*den(384)
  den(477) = den(1)*den(433)
  den(478) = den(3)*den(382)
  den(479) = den(1)*den(445)
  den(480) = den(1)*den(452)
  den(481) = den(1)*den(453)
  den(482) = den(24)*den(403)
  den(483) = den(23)*den(389)
  den(484) = den(10)*den(387)
  den(485) = den(24)*den(419)
  den(486) = den(24)*den(427)
  den(487) = den(30)*den(388)
  den(488) = den(3)*den(386)
  den(489) = den(24)*den(443)
  den(490) = den(24)*den(448)
  den(491) = den(24)*den(449)
  den(492) = den(2)*den(393)
  den(493) = den(41)*den(408)
  den(494) = den(47)*den(391)
  den(495) = den(41)*den(415)
  den(496) = den(9)*den(392)
  den(497) = den(41)*den(432)
  den(498) = den(42)*den(390)
  den(499) = den(41)*den(439)
  den(500) = den(41)*den(450)
  den(501) = den(41)*den(451)
  den(502) = den(57)*den(402)
  den(503) = den(23)*den(397)
  den(504) = den(47)*den(395)
  den(505) = den(57)*den(413)
  den(506) = den(57)*den(426)
  den(507) = den(30)*den(396)
  den(508) = den(42)*den(394)
  den(509) = den(57)*den(437)
  den(510) = den(57)*den(446)
  den(511) = den(57)*den(447)
  den(512) = den(9)*den(399)
  den(513) = den(9)*den(401)
  den(514) = den(23)*den(430)
  den(515) = den(23)*den(431)
  den(516) = den(42)*den(400)
  den(517) = den(23)*den(438)
  den(518) = den(3)*den(398)
  den(519) = den(23)*den(444)
  den(520) = den(2)*den(423)
  den(521) = den(2)*den(425)
  den(522) = den(30)*den(406)
  den(523) = den(30)*den(407)
  den(524) = den(2)*den(436)
  den(525) = den(42)*den(405)
  den(526) = den(2)*den(442)
  den(527) = den(3)*den(404)
  den(528) = den(47)*den(424)
  den(529) = den(30)*den(414)
  den(530) = den(9)*den(412)
  den(531) = den(47)*den(429)
  den(532) = den(3)*den(410)
  den(533) = den(47)*den(440)
  den(534) = den(3)*den(411)
  den(535) = den(47)*den(441)
  den(536) = den(10)*den(422)
  den(537) = den(30)*den(420)
  den(538) = den(9)*den(418)
  den(539) = den(10)*den(428)
  den(540) = den(10)*den(434)
  den(541) = den(42)*den(416)
  den(542) = den(10)*den(435)
  den(543) = den(42)*den(417)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(394)

  A(1) = cont_QA(wf(:,5),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,8),wf(:,9)) * den(8)
  A(3) = cont_QA(wf(:,13),wf(:,14)) * den(12)
  A(4) = cont_QA(wf(:,16),wf(:,17)) * den(15)
  A(5) = cont_QA(wf(:,9),wf(:,18)) * den(16)
  A(6) = cont_QA(wf(:,17),wf(:,19)) * den(17)
  A(7) = cont_QA(wf(:,17),wf(:,22)) * den(19)
  A(8) = cont_QA(wf(:,7),wf(:,24)) * den(22)
  A(9) = cont_QA(wf(:,5),wf(:,28)) * den(26)
  A(10) = cont_QA(wf(:,30),wf(:,31)) * den(29)
  A(11) = cont_QA(wf(:,13),wf(:,34)) * den(32)
  A(12) = cont_QA(wf(:,16),wf(:,36)) * den(34)
  A(13) = cont_QA(wf(:,31),wf(:,37)) * den(35)
  A(14) = cont_QA(wf(:,19),wf(:,36)) * den(36)
  A(15) = cont_QA(wf(:,22),wf(:,36)) * den(37)
  A(16) = cont_QA(wf(:,29),wf(:,39)) * den(40)
  A(17) = cont_QA(wf(:,42),wf(:,43)) * den(44)
  A(18) = cont_QA(wf(:,8),wf(:,45)) * den(46)
  A(19) = cont_QA(wf(:,47),wf(:,48)) * den(49)
  A(20) = cont_QA(wf(:,50),wf(:,51)) * den(52)
  A(21) = cont_QA(wf(:,18),wf(:,45)) * den(53)
  A(22) = cont_QA(wf(:,51),wf(:,52)) * den(54)
  A(23) = cont_QA(wf(:,51),wf(:,53)) * den(55)
  A(24) = cont_QA(wf(:,24),wf(:,44)) * den(56)
  A(25) = cont_QA(wf(:,42),wf(:,55)) * den(59)
  A(26) = cont_QA(wf(:,30),wf(:,57)) * den(61)
  A(27) = cont_QA(wf(:,47),wf(:,58)) * den(63)
  A(28) = cont_QA(wf(:,50),wf(:,60)) * den(65)
  A(29) = cont_QA(wf(:,37),wf(:,57)) * den(66)
  A(30) = cont_QA(wf(:,52),wf(:,60)) * den(67)
  A(31) = cont_QA(wf(:,53),wf(:,60)) * den(68)
  A(32) = cont_QA(wf(:,39),wf(:,56)) * den(69)
  A(33) = cont_VV(wf(:,61),wf(:,62)) * den(72)
  A(34) = cont_VV(wf(:,63),wf(:,64)) * den(75)
  A(35) = cont_VV(wf(:,64),wf(:,65)) * den(77)
  A(36) = cont_VV(wf(:,61),wf(:,66)) * den(80)
  A(37) = cont_VV(wf(:,67),wf(:,68)) * den(83)
  A(38) = cont_VV(wf(:,69),wf(:,70)) * den(86)
  A(39) = cont_VV(wf(:,68),wf(:,71)) * den(88)
  A(40) = cont_VV(wf(:,69),wf(:,72)) * den(91)
  A(41) = cont_VV(wf(:,70),wf(:,73)) * den(93)
  A(42) = cont_VV(wf(:,62),wf(:,74)) * den(95)
  A(43) = cont_VV(wf(:,66),wf(:,74)) * den(96)
  A(44) = cont_VV(wf(:,72),wf(:,73)) * den(97)
  A(45) = cont_VV(wf(:,67),wf(:,75)) * den(100)
  A(46) = cont_VV(wf(:,63),wf(:,76)) * den(103)
  A(47) = cont_VV(wf(:,71),wf(:,75)) * den(104)
  A(48) = cont_VV(wf(:,65),wf(:,76)) * den(105)

  A(49) = cont_VV(wf(:,21),wf(:,77)) * den(107)
  A(50) = cont_QA(wf(:,5),wf(:,78)) * den(5)
  A(51) = cont_QA(wf(:,9),wf(:,79)) * den(8)
  A(52) = cont_VV(wf(:,68),wf(:,80)) * den(109)
  A(53) = cont_QA(wf(:,13),wf(:,81)) * den(12)
  A(54) = cont_QA(wf(:,17),wf(:,82)) * den(15)
  A(55) = cont_VV(wf(:,75),wf(:,80)) * den(110)
  A(56) = cont_QA(wf(:,9),wf(:,83)) * den(16)
  A(57) = cont_VV(wf(:,62),wf(:,84)) * den(112)
  A(58) = cont_VV(wf(:,62),wf(:,84)) * den(112)
  A(59) = cont_QA(wf(:,17),wf(:,85)) * den(17)
  A(60) = cont_VV(wf(:,66),wf(:,84)) * den(113)
  A(61) = cont_VV(wf(:,66),wf(:,84)) * den(113)
  A(62) = cont_QA(wf(:,86),wf(:,87)) * den(115)
  A(63) = cont_QA(wf(:,6),wf(:,89)) * den(5)
  A(64) = cont_QA(wf(:,86),wf(:,90)) * den(117)
  A(65) = cont_QA(wf(:,17),wf(:,91)) * den(19)
  A(66) = cont_QA(wf(:,24),wf(:,86)) * den(22)
  A(67) = cont_QA(wf(:,17),wf(:,92)) * den(17)
  A(68) = cont_QA(wf(:,14),wf(:,94)) * den(12)
  A(69) = cont_QA(wf(:,17),wf(:,95)) * den(15)
  A(70) = cont_VV(wf(:,21),wf(:,96)) * den(119)
  A(71) = cont_QA(wf(:,5),wf(:,97)) * den(26)
  A(72) = cont_VV(wf(:,64),wf(:,98)) * den(121)
  A(73) = cont_QA(wf(:,31),wf(:,99)) * den(29)
  A(74) = cont_QA(wf(:,13),wf(:,100)) * den(32)
  A(75) = cont_QA(wf(:,36),wf(:,82)) * den(34)
  A(76) = cont_VV(wf(:,76),wf(:,98)) * den(122)
  A(77) = cont_VV(wf(:,70),wf(:,101)) * den(124)
  A(78) = cont_VV(wf(:,70),wf(:,101)) * den(124)
  A(79) = cont_QA(wf(:,31),wf(:,102)) * den(35)
  A(80) = cont_QA(wf(:,36),wf(:,85)) * den(36)
  A(81) = cont_VV(wf(:,72),wf(:,101)) * den(125)
  A(82) = cont_VV(wf(:,72),wf(:,101)) * den(125)
  A(83) = cont_QA(wf(:,103),wf(:,104)) * den(127)
  A(84) = cont_QA(wf(:,28),wf(:,89)) * den(26)
  A(85) = cont_QA(wf(:,103),wf(:,105)) * den(129)
  A(86) = cont_QA(wf(:,36),wf(:,91)) * den(37)
  A(87) = cont_QA(wf(:,39),wf(:,103)) * den(40)
  A(88) = cont_QA(wf(:,36),wf(:,92)) * den(36)
  A(89) = cont_QA(wf(:,34),wf(:,94)) * den(32)
  A(90) = cont_QA(wf(:,36),wf(:,95)) * den(34)
  A(91) = cont_QA(wf(:,42),wf(:,106)) * den(44)
  A(92) = cont_QA(wf(:,45),wf(:,79)) * den(46)
  A(93) = cont_VV(wf(:,69),wf(:,107)) * den(130)
  A(94) = cont_QA(wf(:,47),wf(:,108)) * den(49)
  A(95) = cont_QA(wf(:,51),wf(:,109)) * den(52)
  A(96) = cont_VV(wf(:,73),wf(:,107)) * den(131)
  A(97) = cont_QA(wf(:,45),wf(:,83)) * den(53)
  A(98) = cont_VV(wf(:,63),wf(:,110)) * den(132)
  A(99) = cont_VV(wf(:,63),wf(:,110)) * den(132)
  A(100) = cont_QA(wf(:,51),wf(:,111)) * den(54)
  A(101) = cont_VV(wf(:,65),wf(:,110)) * den(133)
  A(102) = cont_VV(wf(:,65),wf(:,110)) * den(133)
  A(103) = cont_QA(wf(:,42),wf(:,112)) * den(59)
  A(104) = cont_VV(wf(:,61),wf(:,113)) * den(134)
  A(105) = cont_QA(wf(:,57),wf(:,99)) * den(61)
  A(106) = cont_QA(wf(:,47),wf(:,114)) * den(63)
  A(107) = cont_QA(wf(:,60),wf(:,109)) * den(65)
  A(108) = cont_VV(wf(:,74),wf(:,113)) * den(135)
  A(109) = cont_VV(wf(:,67),wf(:,115)) * den(136)
  A(110) = cont_VV(wf(:,67),wf(:,115)) * den(136)
  A(111) = cont_QA(wf(:,57),wf(:,102)) * den(66)
  A(112) = cont_QA(wf(:,60),wf(:,111)) * den(67)
  A(113) = cont_VV(wf(:,71),wf(:,115)) * den(137)
  A(114) = cont_VV(wf(:,71),wf(:,115)) * den(137)
  A(115) = cont_VV(wf(:,61),wf(:,116)) * den(72)
  A(116) = cont_VV(wf(:,63),wf(:,117)) * den(75)
  A(117) = cont_VV(wf(:,65),wf(:,117)) * den(77)
  A(118) = cont_VV(wf(:,61),wf(:,118)) * den(80)
  A(119) = cont_VV(wf(:,67),wf(:,119)) * den(83)
  A(120) = cont_VV(wf(:,69),wf(:,120)) * den(86)
  A(121) = cont_VV(wf(:,71),wf(:,119)) * den(88)
  A(122) = cont_VV(wf(:,69),wf(:,121)) * den(91)
  A(123) = cont_VV(wf(:,73),wf(:,120)) * den(93)
  A(124) = cont_VV(wf(:,74),wf(:,116)) * den(95)
  A(125) = cont_VV(wf(:,74),wf(:,118)) * den(96)
  A(126) = cont_VV(wf(:,73),wf(:,121)) * den(97)
  A(127) = cont_VV(wf(:,67),wf(:,122)) * den(100)
  A(128) = cont_VV(wf(:,63),wf(:,123)) * den(103)
  A(129) = cont_VV(wf(:,71),wf(:,122)) * den(104)
  A(130) = cont_VV(wf(:,65),wf(:,123)) * den(105)
  A(131) = cont_QA(wf(:,87),wf(:,124)) * den(138)
  A(132) = cont_QA(wf(:,43),wf(:,126)) * den(44)
  A(133) = cont_QA(wf(:,90),wf(:,124)) * den(139)
  A(134) = cont_QA(wf(:,51),wf(:,127)) * den(55)
  A(135) = cont_QA(wf(:,24),wf(:,124)) * den(56)
  A(136) = cont_QA(wf(:,51),wf(:,128)) * den(54)
  A(137) = cont_QA(wf(:,48),wf(:,130)) * den(49)
  A(138) = cont_QA(wf(:,51),wf(:,131)) * den(52)
  A(139) = cont_QA(wf(:,104),wf(:,132)) * den(140)
  A(140) = cont_QA(wf(:,55),wf(:,126)) * den(59)
  A(141) = cont_QA(wf(:,105),wf(:,132)) * den(141)
  A(142) = cont_QA(wf(:,60),wf(:,127)) * den(68)
  A(143) = cont_QA(wf(:,39),wf(:,132)) * den(69)
  A(144) = cont_QA(wf(:,60),wf(:,128)) * den(67)
  A(145) = cont_QA(wf(:,58),wf(:,130)) * den(63)
  A(146) = cont_QA(wf(:,60),wf(:,131)) * den(65)
  A(147) = cont_VV(wf(:,64),wf(:,133)) * den(142)
  A(148) = cont_VV(wf(:,62),wf(:,134)) * den(143)
  A(149) = cont_VV(wf(:,66),wf(:,134)) * den(80)
  A(150) = cont_VV(wf(:,64),wf(:,135)) * den(77)
  A(151) = cont_VV(wf(:,70),wf(:,136)) * den(144)
  A(152) = cont_VV(wf(:,68),wf(:,137)) * den(145)
  A(153) = cont_VV(wf(:,72),wf(:,136)) * den(91)
  A(154) = cont_VV(wf(:,68),wf(:,138)) * den(88)
  A(155) = cont_VV(wf(:,75),wf(:,137)) * den(100)
  A(156) = cont_VV(wf(:,76),wf(:,133)) * den(103)
  A(157) = cont_VV(wf(:,76),wf(:,135)) * den(105)
  A(158) = cont_VV(wf(:,75),wf(:,138)) * den(104)
  A(159) = cont_VV(wf(:,70),wf(:,139)) * den(93)
  A(160) = cont_VV(wf(:,62),wf(:,140)) * den(95)
  A(161) = cont_VV(wf(:,72),wf(:,139)) * den(97)
  A(162) = cont_VV(wf(:,66),wf(:,140)) * den(96)
  A(163) = cont_QA(wf(:,141),wf(:,142)) * den(148)
  A(164) = cont_QA(wf(:,13),wf(:,145)) * den(12)
  A(165) = cont_QA(wf(:,141),wf(:,146)) * den(150)
  A(166) = cont_QA(wf(:,9),wf(:,147)) * den(151)
  A(167) = cont_QA(wf(:,141),wf(:,148)) * den(153)
  A(168) = cont_QA(wf(:,9),wf(:,149)) * den(16)
  A(169) = cont_QA(wf(:,5),wf(:,152)) * den(5)
  A(170) = cont_QA(wf(:,9),wf(:,153)) * den(8)
  A(171) = cont_QA(wf(:,154),wf(:,155)) * den(156)
  A(172) = cont_QA(wf(:,47),wf(:,156)) * den(49)
  A(173) = cont_QA(wf(:,154),wf(:,157)) * den(158)
  A(174) = cont_QA(wf(:,45),wf(:,147)) * den(159)
  A(175) = cont_QA(wf(:,154),wf(:,158)) * den(161)
  A(176) = cont_QA(wf(:,45),wf(:,149)) * den(53)
  A(177) = cont_QA(wf(:,42),wf(:,159)) * den(44)
  A(178) = cont_QA(wf(:,45),wf(:,153)) * den(46)
  A(179) = cont_VV(wf(:,64),wf(:,160)) * den(162)
  A(180) = cont_VV(wf(:,61),wf(:,161)) * den(163)
  A(181) = cont_VV(wf(:,61),wf(:,162)) * den(72)
  A(182) = cont_VV(wf(:,64),wf(:,163)) * den(75)
  A(183) = cont_VV(wf(:,70),wf(:,164)) * den(164)
  A(184) = cont_VV(wf(:,74),wf(:,161)) * den(96)
  A(185) = cont_VV(wf(:,72),wf(:,164)) * den(97)
  A(186) = cont_VV(wf(:,74),wf(:,162)) * den(95)
  A(187) = cont_VV(wf(:,67),wf(:,165)) * den(165)
  A(188) = cont_VV(wf(:,71),wf(:,165)) * den(104)
  A(189) = cont_VV(wf(:,76),wf(:,160)) * den(105)
  A(190) = cont_VV(wf(:,76),wf(:,163)) * den(103)
  A(191) = cont_VV(wf(:,67),wf(:,166)) * den(83)
  A(192) = cont_VV(wf(:,70),wf(:,167)) * den(86)
  A(193) = cont_VV(wf(:,71),wf(:,166)) * den(88)
  A(194) = cont_VV(wf(:,72),wf(:,167)) * den(91)
  A(195) = cont_QA(wf(:,42),wf(:,169)) * den(59)
  A(196) = cont_QA(wf(:,30),wf(:,171)) * den(61)
  A(197) = cont_QA(wf(:,47),wf(:,172)) * den(63)
  A(198) = cont_QA(wf(:,50),wf(:,174)) * den(65)
  A(199) = cont_QA(wf(:,37),wf(:,171)) * den(66)
  A(200) = cont_QA(wf(:,52),wf(:,174)) * den(67)
  A(201) = cont_QA(wf(:,39),wf(:,170)) * den(69)
  A(202) = cont_QA(wf(:,53),wf(:,174)) * den(68)
  A(203) = cont_QA(wf(:,5),wf(:,176)) * den(26)
  A(204) = cont_QA(wf(:,30),wf(:,178)) * den(29)
  A(205) = cont_QA(wf(:,13),wf(:,179)) * den(32)
  A(206) = cont_QA(wf(:,16),wf(:,181)) * den(34)
  A(207) = cont_QA(wf(:,37),wf(:,178)) * den(35)
  A(208) = cont_QA(wf(:,19),wf(:,181)) * den(36)
  A(209) = cont_QA(wf(:,39),wf(:,177)) * den(40)
  A(210) = cont_QA(wf(:,22),wf(:,181)) * den(37)
  A(211) = cont_QA(wf(:,142),wf(:,182)) * den(166)
  A(212) = cont_QA(wf(:,13),wf(:,185)) * den(32)
  A(213) = cont_QA(wf(:,146),wf(:,182)) * den(167)
  A(214) = cont_QA(wf(:,148),wf(:,182)) * den(168)
  A(215) = cont_QA(wf(:,31),wf(:,186)) * den(169)
  A(216) = cont_QA(wf(:,31),wf(:,187)) * den(35)
  A(217) = cont_QA(wf(:,5),wf(:,190)) * den(26)
  A(218) = cont_QA(wf(:,31),wf(:,191)) * den(29)
  A(219) = cont_QA(wf(:,155),wf(:,192)) * den(170)
  A(220) = cont_QA(wf(:,47),wf(:,193)) * den(63)
  A(221) = cont_QA(wf(:,157),wf(:,192)) * den(171)
  A(222) = cont_QA(wf(:,158),wf(:,192)) * den(172)
  A(223) = cont_QA(wf(:,57),wf(:,186)) * den(173)
  A(224) = cont_QA(wf(:,57),wf(:,187)) * den(66)
  A(225) = cont_QA(wf(:,42),wf(:,194)) * den(59)
  A(226) = cont_QA(wf(:,57),wf(:,191)) * den(61)
  A(227) = cont_VV(wf(:,68),wf(:,195)) * den(174)
  A(228) = cont_VV(wf(:,69),wf(:,196)) * den(175)
  A(229) = cont_VV(wf(:,68),wf(:,197)) * den(83)
  A(230) = cont_VV(wf(:,69),wf(:,198)) * den(86)
  A(231) = cont_VV(wf(:,62),wf(:,199)) * den(176)
  A(232) = cont_VV(wf(:,66),wf(:,199)) * den(177)
  A(233) = cont_VV(wf(:,73),wf(:,196)) * den(178)
  A(234) = cont_VV(wf(:,73),wf(:,198)) * den(93)
  A(235) = cont_VV(wf(:,63),wf(:,200)) * den(179)
  A(236) = cont_VV(wf(:,75),wf(:,195)) * den(180)
  A(237) = cont_VV(wf(:,65),wf(:,200)) * den(181)
  A(238) = cont_VV(wf(:,75),wf(:,197)) * den(100)
  A(239) = cont_VV(wf(:,62),wf(:,201)) * den(72)
  A(240) = cont_VV(wf(:,63),wf(:,202)) * den(75)
  A(241) = cont_VV(wf(:,65),wf(:,202)) * den(77)
  A(242) = cont_VV(wf(:,66),wf(:,201)) * den(80)
  A(243) = cont_QA(wf(:,42),wf(:,204)) * den(44)
  A(244) = cont_QA(wf(:,8),wf(:,206)) * den(46)
  A(245) = cont_QA(wf(:,47),wf(:,207)) * den(49)
  A(246) = cont_QA(wf(:,50),wf(:,209)) * den(52)
  A(247) = cont_QA(wf(:,18),wf(:,206)) * den(53)
  A(248) = cont_QA(wf(:,52),wf(:,209)) * den(54)
  A(249) = cont_QA(wf(:,53),wf(:,209)) * den(55)
  A(250) = cont_QA(wf(:,24),wf(:,205)) * den(56)
  A(251) = cont_QA(wf(:,5),wf(:,211)) * den(5)
  A(252) = cont_QA(wf(:,8),wf(:,213)) * den(8)
  A(253) = cont_QA(wf(:,13),wf(:,214)) * den(12)
  A(254) = cont_QA(wf(:,16),wf(:,216)) * den(15)
  A(255) = cont_QA(wf(:,18),wf(:,213)) * den(16)
  A(256) = cont_QA(wf(:,19),wf(:,216)) * den(17)
  A(257) = cont_QA(wf(:,22),wf(:,216)) * den(19)
  A(258) = cont_QA(wf(:,24),wf(:,212)) * den(22)
  A(259) = cont_VV(wf(:,217),wf(:,218)) * den(185)
  A(260) = cont_QA(wf(:,220),wf(:,221)) * den(189)
  A(261) = cont_QA(wf(:,222),wf(:,223)) * den(192)
  A(262) = cont_QA(wf(:,87),wf(:,224)) * den(194)
  A(263) = cont_QA(wf(:,9),wf(:,226)) * den(196)
  A(264) = cont_QA(wf(:,87),wf(:,227)) * den(197)
  A(265) = cont_VV(wf(:,218),wf(:,228)) * den(200)
  A(266) = cont_QA(wf(:,230),wf(:,231)) * den(204)
  A(267) = cont_QA(wf(:,232),wf(:,233)) * den(207)
  A(268) = cont_QA(wf(:,142),wf(:,234)) * den(208)
  A(269) = cont_QA(wf(:,142),wf(:,235)) * den(209)
  A(270) = cont_QA(wf(:,17),wf(:,237)) * den(211)
  A(271) = cont_QA(wf(:,90),wf(:,224)) * den(212)
  A(272) = cont_QA(wf(:,9),wf(:,239)) * den(214)
  A(273) = cont_QA(wf(:,90),wf(:,227)) * den(215)
  A(274) = cont_QA(wf(:,146),wf(:,234)) * den(216)
  A(275) = cont_QA(wf(:,146),wf(:,235)) * den(217)
  A(276) = cont_QA(wf(:,17),wf(:,241)) * den(219)
  A(277) = cont_QA(wf(:,148),wf(:,234)) * den(220)
  A(278) = cont_QA(wf(:,24),wf(:,224)) * den(221)
  A(279) = cont_QA(wf(:,148),wf(:,235)) * den(222)
  A(280) = cont_QA(wf(:,9),wf(:,242)) * den(223)
  A(281) = cont_QA(wf(:,244),wf(:,245)) * den(227)
  A(282) = cont_VV(wf(:,246),wf(:,247)) * den(231)
  A(283) = cont_QA(wf(:,222),wf(:,248)) * den(233)
  A(284) = cont_QA(wf(:,31),wf(:,250)) * den(235)
  A(285) = cont_QA(wf(:,104),wf(:,251)) * den(237)
  A(286) = cont_QA(wf(:,104),wf(:,252)) * den(238)
  A(287) = cont_QA(wf(:,254),wf(:,255)) * den(242)
  A(288) = cont_VV(wf(:,247),wf(:,256)) * den(245)
  A(289) = cont_QA(wf(:,232),wf(:,257)) * den(247)
  A(290) = cont_QA(wf(:,142),wf(:,258)) * den(248)
  A(291) = cont_QA(wf(:,142),wf(:,259)) * den(249)
  A(292) = cont_QA(wf(:,36),wf(:,237)) * den(250)
  A(293) = cont_QA(wf(:,31),wf(:,261)) * den(252)
  A(294) = cont_QA(wf(:,105),wf(:,251)) * den(253)
  A(295) = cont_QA(wf(:,105),wf(:,252)) * den(254)
  A(296) = cont_QA(wf(:,146),wf(:,258)) * den(255)
  A(297) = cont_QA(wf(:,146),wf(:,259)) * den(256)
  A(298) = cont_QA(wf(:,36),wf(:,241)) * den(257)
  A(299) = cont_QA(wf(:,148),wf(:,258)) * den(258)
  A(300) = cont_QA(wf(:,148),wf(:,259)) * den(259)
  A(301) = cont_QA(wf(:,31),wf(:,262)) * den(260)
  A(302) = cont_QA(wf(:,39),wf(:,251)) * den(261)
  A(303) = cont_VV(wf(:,263),wf(:,264)) * den(265)
  A(304) = cont_QA(wf(:,220),wf(:,266)) * den(268)
  A(305) = cont_QA(wf(:,267),wf(:,268)) * den(271)
  A(306) = cont_QA(wf(:,87),wf(:,269)) * den(273)
  A(307) = cont_QA(wf(:,45),wf(:,226)) * den(274)
  A(308) = cont_QA(wf(:,87),wf(:,270)) * den(275)
  A(309) = cont_VV(wf(:,264),wf(:,271)) * den(278)
  A(310) = cont_QA(wf(:,230),wf(:,273)) * den(281)
  A(311) = cont_QA(wf(:,274),wf(:,275)) * den(284)
  A(312) = cont_QA(wf(:,155),wf(:,276)) * den(285)
  A(313) = cont_QA(wf(:,155),wf(:,277)) * den(286)
  A(314) = cont_QA(wf(:,51),wf(:,279)) * den(288)
  A(315) = cont_QA(wf(:,90),wf(:,269)) * den(289)
  A(316) = cont_QA(wf(:,45),wf(:,239)) * den(290)
  A(317) = cont_QA(wf(:,90),wf(:,270)) * den(291)
  A(318) = cont_QA(wf(:,157),wf(:,276)) * den(292)
  A(319) = cont_QA(wf(:,157),wf(:,277)) * den(293)
  A(320) = cont_QA(wf(:,51),wf(:,281)) * den(295)
  A(321) = cont_QA(wf(:,158),wf(:,276)) * den(296)
  A(322) = cont_QA(wf(:,24),wf(:,269)) * den(297)
  A(323) = cont_QA(wf(:,158),wf(:,277)) * den(298)
  A(324) = cont_QA(wf(:,45),wf(:,242)) * den(299)
  A(325) = cont_QA(wf(:,244),wf(:,283)) * den(302)
  A(326) = cont_VV(wf(:,284),wf(:,285)) * den(306)
  A(327) = cont_QA(wf(:,267),wf(:,286)) * den(308)
  A(328) = cont_QA(wf(:,57),wf(:,250)) * den(309)
  A(329) = cont_QA(wf(:,104),wf(:,287)) * den(311)
  A(330) = cont_QA(wf(:,104),wf(:,288)) * den(312)
  A(331) = cont_QA(wf(:,254),wf(:,290)) * den(315)
  A(332) = cont_VV(wf(:,285),wf(:,291)) * den(318)
  A(333) = cont_QA(wf(:,274),wf(:,292)) * den(320)
  A(334) = cont_QA(wf(:,155),wf(:,293)) * den(321)
  A(335) = cont_QA(wf(:,155),wf(:,294)) * den(322)
  A(336) = cont_QA(wf(:,60),wf(:,279)) * den(323)
  A(337) = cont_QA(wf(:,57),wf(:,261)) * den(324)
  A(338) = cont_QA(wf(:,105),wf(:,287)) * den(325)
  A(339) = cont_QA(wf(:,105),wf(:,288)) * den(326)
  A(340) = cont_QA(wf(:,157),wf(:,293)) * den(327)
  A(341) = cont_QA(wf(:,157),wf(:,294)) * den(328)
  A(342) = cont_QA(wf(:,60),wf(:,281)) * den(329)
  A(343) = cont_QA(wf(:,158),wf(:,293)) * den(330)
  A(344) = cont_QA(wf(:,158),wf(:,294)) * den(331)
  A(345) = cont_QA(wf(:,57),wf(:,262)) * den(332)
  A(346) = cont_QA(wf(:,39),wf(:,287)) * den(333)
  A(347) = cont_VV(wf(:,62),wf(:,295)) * den(334)
  A(348) = cont_VV(wf(:,63),wf(:,296)) * den(335)
  A(349) = cont_VV(wf(:,64),wf(:,297)) * den(336)
  A(350) = cont_VV(wf(:,61),wf(:,298)) * den(337)
  A(351) = cont_VV(wf(:,62),wf(:,299)) * den(338)
  A(352) = cont_VV(wf(:,64),wf(:,300)) * den(339)
  A(353) = cont_VV(wf(:,65),wf(:,296)) * den(340)
  A(354) = cont_VV(wf(:,64),wf(:,301)) * den(341)
  A(355) = cont_VV(wf(:,64),wf(:,302)) * den(342)
  A(356) = cont_VV(wf(:,66),wf(:,295)) * den(343)
  A(357) = cont_VV(wf(:,61),wf(:,303)) * den(344)
  A(358) = cont_VV(wf(:,61),wf(:,304)) * den(345)
  A(359) = cont_VV(wf(:,68),wf(:,305)) * den(346)
  A(360) = cont_VV(wf(:,69),wf(:,306)) * den(347)
  A(361) = cont_VV(wf(:,70),wf(:,307)) * den(348)
  A(362) = cont_VV(wf(:,67),wf(:,308)) * den(349)
  A(363) = cont_VV(wf(:,68),wf(:,309)) * den(350)
  A(364) = cont_VV(wf(:,70),wf(:,310)) * den(351)
  A(365) = cont_VV(wf(:,68),wf(:,311)) * den(352)
  A(366) = cont_VV(wf(:,68),wf(:,312)) * den(353)
  A(367) = cont_VV(wf(:,71),wf(:,308)) * den(354)
  A(368) = cont_VV(wf(:,69),wf(:,313)) * den(355)
  A(369) = cont_VV(wf(:,69),wf(:,314)) * den(356)
  A(370) = cont_VV(wf(:,72),wf(:,307)) * den(357)
  A(371) = cont_VV(wf(:,73),wf(:,306)) * den(358)
  A(372) = cont_VV(wf(:,70),wf(:,315)) * den(359)
  A(373) = cont_VV(wf(:,70),wf(:,316)) * den(360)
  A(374) = cont_VV(wf(:,62),wf(:,317)) * den(361)
  A(375) = cont_VV(wf(:,62),wf(:,318)) * den(362)
  A(376) = cont_VV(wf(:,74),wf(:,298)) * den(363)
  A(377) = cont_VV(wf(:,66),wf(:,318)) * den(364)
  A(378) = cont_VV(wf(:,73),wf(:,313)) * den(365)
  A(379) = cont_VV(wf(:,66),wf(:,317)) * den(366)
  A(380) = cont_VV(wf(:,73),wf(:,314)) * den(367)
  A(381) = cont_VV(wf(:,72),wf(:,315)) * den(368)
  A(382) = cont_VV(wf(:,74),wf(:,304)) * den(369)
  A(383) = cont_VV(wf(:,75),wf(:,305)) * den(370)
  A(384) = cont_VV(wf(:,67),wf(:,319)) * den(371)
  A(385) = cont_VV(wf(:,67),wf(:,320)) * den(372)
  A(386) = cont_VV(wf(:,63),wf(:,321)) * den(373)
  A(387) = cont_VV(wf(:,63),wf(:,322)) * den(374)
  A(388) = cont_VV(wf(:,76),wf(:,297)) * den(375)
  A(389) = cont_VV(wf(:,75),wf(:,312)) * den(376)
  A(390) = cont_VV(wf(:,65),wf(:,321)) * den(377)
  A(391) = cont_VV(wf(:,75),wf(:,311)) * den(378)
  A(392) = cont_VV(wf(:,65),wf(:,322)) * den(379)
  A(393) = cont_VV(wf(:,76),wf(:,301)) * den(380)
  A(394) = cont_VV(wf(:,71),wf(:,320)) * den(381)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(394)
  complex(REALKIND), intent(out) :: M1(2), M2(2)

  M1(1) = ((A(15)+A(16)+A(23)+A(24))*f(1))/6._/**/REALKIND+((A(7)+A(8)+A(31)+A(32))*f(1))/2._/**/REALKIND+((A(1)+A(2)+A(3)+A(4) &
       +A(5)+A(6)+A(25)+A(26)+A(27)+A(28)+A(29)+A(30)+A(33)+A(36)+A(37)+A(39)+A(42)+A(43)+A(45)+A(47))*f(12))/2._/**/REALKIND &
       +((A(9)+A(10)+A(11)+A(12)+A(13)+A(14)+A(17)+A(18)+A(19)+A(20)+A(21)+A(22)+A(34)+A(35)+A(38)+A(40)+A(41)+A(44)+A(46) &
       +A(48))*f(12))/6._/**/REALKIND
  M1(2) = ((-A(15)-A(16)-A(23)-A(24))*f(1))/2._/**/REALKIND+((-A(7)-A(8)-A(31)-A(32))*f(1))/6._/**/REALKIND+((-A(1)-A(2)-A(3)-A(4) &
       -A(5)-A(6)-A(25)-A(26)-A(27)-A(28)-A(29)-A(30)-A(33)-A(36)-A(37)-A(39)-A(42)-A(43)-A(45)-A(47))*f(12))/6._/**/REALKIND+(( &
       -A(9)-A(10)-A(11)-A(12)-A(13)-A(14)-A(17)-A(18)-A(19)-A(20)-A(21)-A(22)-A(34)-A(35)-A(38)-A(40)-A(41)-A(44)-A(46) &
       -A(48))*f(12))/2._/**/REALKIND

  M2(1) = ((-A(299)-A(300)-A(301)-A(302)-A(321)-A(322)-A(323)-A(324))*f(2))/6._/**/REALKIND+((-A(277)-A(278)-A(279)-A(280)-A(343) &
       -A(344)-A(345)-A(346))*f(2))/2._/**/REALKIND+((A(87)+A(135)+A(175)+A(209)+A(210)+A(214)+A(249) &
       +A(250))*f(3))/6._/**/REALKIND+((A(66)+A(143)+A(167)+A(201)+A(202)+A(222)+A(257)+A(258))*f(3))/2._/**/REALKIND+((A(86) &
       +A(134)+A(174)+A(215))*f(4))/6._/**/REALKIND+((A(65)+A(142)+A(166)+A(223))*f(4))/2._/**/REALKIND &
       -(A(49)*f(5))/2._/**/REALKIND-(A(70)*f(5))/6._/**/REALKIND+((A(78)+A(82)+A(99)+A(102))*f(11))/6._/**/REALKIND+((A(58)+A(61) &
       +A(110)+A(114))*f(11))/2._/**/REALKIND+((-A(281)-A(282)-A(283)-A(284)-A(285)-A(286)-A(287)-A(288)-A(289)-A(290)-A(291) &
       -A(292)-A(293)-A(294)-A(295)-A(296)-A(297)-A(298)-A(303)-A(304)-A(305)-A(306)-A(307)-A(308)-A(309)-A(310)-A(311)-A(312) &
       -A(313)-A(314)-A(315)-A(316)-A(317)-A(318)-A(319)-A(320)-A(348)-A(349)-A(352)-A(353)-A(354)-A(355)-A(360)-A(361)-A(364) &
       -A(368)-A(369)-A(370)-A(371)-A(372)-A(373)-A(378)-A(380)-A(381)-A(386)-A(387)-A(388)-A(390)-A(392) &
       -A(393))*f(13))/6._/**/REALKIND+((-A(259)-A(260)-A(261)-A(262)-A(263)-A(264)-A(265)-A(266)-A(267)-A(268)-A(269)-A(270) &
       -A(271)-A(272)-A(273)-A(274)-A(275)-A(276)-A(325)-A(326)-A(327)-A(328)-A(329)-A(330)-A(331)-A(332)-A(333)-A(334)-A(335) &
       -A(336)-A(337)-A(338)-A(339)-A(340)-A(341)-A(342)-A(347)-A(350)-A(351)-A(356)-A(357)-A(358)-A(359)-A(362)-A(363)-A(365) &
       -A(366)-A(367)-A(374)-A(375)-A(376)-A(377)-A(379)-A(382)-A(383)-A(384)-A(385)-A(389)-A(391)-A(394))*f(13))/2._/**/REALKIND &
       +((A(71)+A(74)+A(83)+A(85)+A(91)+A(94)+A(116)+A(117)+A(120)+A(123)+A(131)+A(133)+A(147)+A(151)+A(153)+A(156)+A(171)+A(173) &
       +A(179)+A(183)+A(185)+A(189)+A(203)+A(204)+A(205)+A(206)+A(207)+A(208)+A(211)+A(213)+A(228)+A(233)+A(235)+A(237)+A(243) &
       +A(244)+A(245)+A(246)+A(247)+A(248))*f(14))/6._/**/REALKIND+((A(50)+A(53)+A(62)+A(64)+A(103)+A(106)+A(115)+A(119)+A(121) &
       +A(124)+A(139)+A(141)+A(148)+A(149)+A(152)+A(155)+A(163)+A(165)+A(180)+A(184)+A(187)+A(188)+A(195)+A(196)+A(197)+A(198) &
       +A(199)+A(200)+A(219)+A(221)+A(227)+A(231)+A(232)+A(236)+A(251)+A(252)+A(253)+A(254)+A(255)+A(256))*f(14))/2._/**/REALKIND &
       +((A(79)+A(80)+A(89)+A(90)+A(97)+A(100)+A(128)+A(130)+A(137)+A(138)+A(159)+A(161)+A(177)+A(178)+A(192)+A(194)+A(217)+A(218) &
       +A(240)+A(241))*f(15))/6._/**/REALKIND+((A(56)+A(59)+A(68)+A(69)+A(111)+A(112)+A(127)+A(129)+A(145)+A(146)+A(160)+A(162) &
       +A(169)+A(170)+A(191)+A(193)+A(225)+A(226)+A(239)+A(242))*f(15))/2._/**/REALKIND+((A(73)+A(75)+A(84)+A(88)+A(92)+A(95) &
       +A(122)+A(126)+A(132)+A(136)+A(150)+A(157)+A(172)+A(176)+A(182)+A(190)+A(212)+A(216)+A(230)+A(234))*f(16))/6._/**/REALKIND &
       +((A(51)+A(54)+A(63)+A(67)+A(105)+A(107)+A(118)+A(125)+A(140)+A(144)+A(154)+A(158)+A(164)+A(168)+A(181)+A(186)+A(220) &
       +A(224)+A(229)+A(238))*f(16))/2._/**/REALKIND+((-A(72)-A(76)-A(93)-A(96))*f(17))/6._/**/REALKIND+((-A(52)-A(55)-A(104) &
       -A(108))*f(17))/2._/**/REALKIND+((A(77)+A(81)+A(98)+A(101))*f(23))/6._/**/REALKIND+((A(57)+A(60)+A(109) &
       +A(113))*f(23))/2._/**/REALKIND
  M2(2) = ((A(299)+A(300)+A(301)+A(302)+A(321)+A(322)+A(323)+A(324))*f(2))/2._/**/REALKIND+((A(277)+A(278)+A(279)+A(280)+A(343) &
       +A(344)+A(345)+A(346))*f(2))/6._/**/REALKIND+((-A(87)-A(135)-A(175)-A(209)-A(210)-A(214)-A(249) &
       -A(250))*f(3))/2._/**/REALKIND+((-A(66)-A(143)-A(167)-A(201)-A(202)-A(222)-A(257)-A(258))*f(3))/6._/**/REALKIND+((-A(86) &
       -A(134)-A(174)-A(215))*f(4))/2._/**/REALKIND+((-A(65)-A(142)-A(166)-A(223))*f(4))/6._/**/REALKIND &
       +(A(49)*f(5))/6._/**/REALKIND+(A(70)*f(5))/2._/**/REALKIND+((-A(78)-A(82)-A(99)-A(102))*f(11))/2._/**/REALKIND+((-A(58) &
       -A(61)-A(110)-A(114))*f(11))/6._/**/REALKIND+((A(281)+A(282)+A(283)+A(284)+A(285)+A(286)+A(287)+A(288)+A(289)+A(290)+A(291) &
       +A(292)+A(293)+A(294)+A(295)+A(296)+A(297)+A(298)+A(303)+A(304)+A(305)+A(306)+A(307)+A(308)+A(309)+A(310)+A(311)+A(312) &
       +A(313)+A(314)+A(315)+A(316)+A(317)+A(318)+A(319)+A(320)+A(348)+A(349)+A(352)+A(353)+A(354)+A(355)+A(360)+A(361)+A(364) &
       +A(368)+A(369)+A(370)+A(371)+A(372)+A(373)+A(378)+A(380)+A(381)+A(386)+A(387)+A(388)+A(390)+A(392) &
       +A(393))*f(13))/2._/**/REALKIND+((A(259)+A(260)+A(261)+A(262)+A(263)+A(264)+A(265)+A(266)+A(267)+A(268)+A(269)+A(270) &
       +A(271)+A(272)+A(273)+A(274)+A(275)+A(276)+A(325)+A(326)+A(327)+A(328)+A(329)+A(330)+A(331)+A(332)+A(333)+A(334)+A(335) &
       +A(336)+A(337)+A(338)+A(339)+A(340)+A(341)+A(342)+A(347)+A(350)+A(351)+A(356)+A(357)+A(358)+A(359)+A(362)+A(363)+A(365) &
       +A(366)+A(367)+A(374)+A(375)+A(376)+A(377)+A(379)+A(382)+A(383)+A(384)+A(385)+A(389)+A(391)+A(394))*f(13))/6._/**/REALKIND &
       +((-A(71)-A(74)-A(83)-A(85)-A(91)-A(94)-A(116)-A(117)-A(120)-A(123)-A(131)-A(133)-A(147)-A(151)-A(153)-A(156)-A(171)-A(173) &
       -A(179)-A(183)-A(185)-A(189)-A(203)-A(204)-A(205)-A(206)-A(207)-A(208)-A(211)-A(213)-A(228)-A(233)-A(235)-A(237)-A(243) &
       -A(244)-A(245)-A(246)-A(247)-A(248))*f(14))/2._/**/REALKIND+((-A(50)-A(53)-A(62)-A(64)-A(103)-A(106)-A(115)-A(119)-A(121) &
       -A(124)-A(139)-A(141)-A(148)-A(149)-A(152)-A(155)-A(163)-A(165)-A(180)-A(184)-A(187)-A(188)-A(195)-A(196)-A(197)-A(198) &
       -A(199)-A(200)-A(219)-A(221)-A(227)-A(231)-A(232)-A(236)-A(251)-A(252)-A(253)-A(254)-A(255)-A(256))*f(14))/6._/**/REALKIND &
       +((-A(79)-A(80)-A(89)-A(90)-A(97)-A(100)-A(128)-A(130)-A(137)-A(138)-A(159)-A(161)-A(177)-A(178)-A(192)-A(194)-A(217) &
       -A(218)-A(240)-A(241))*f(15))/2._/**/REALKIND+((-A(56)-A(59)-A(68)-A(69)-A(111)-A(112)-A(127)-A(129)-A(145)-A(146)-A(160) &
       -A(162)-A(169)-A(170)-A(191)-A(193)-A(225)-A(226)-A(239)-A(242))*f(15))/6._/**/REALKIND+((-A(73)-A(75)-A(84)-A(88)-A(92) &
       -A(95)-A(122)-A(126)-A(132)-A(136)-A(150)-A(157)-A(172)-A(176)-A(182)-A(190)-A(212)-A(216)-A(230) &
       -A(234))*f(16))/2._/**/REALKIND+((-A(51)-A(54)-A(63)-A(67)-A(105)-A(107)-A(118)-A(125)-A(140)-A(144)-A(154)-A(158)-A(164) &
       -A(168)-A(181)-A(186)-A(220)-A(224)-A(229)-A(238))*f(16))/6._/**/REALKIND+((A(72)+A(76)+A(93)+A(96))*f(17))/2._/**/REALKIND &
       +((A(52)+A(55)+A(104)+A(108))*f(17))/6._/**/REALKIND+((-A(77)-A(81)-A(98)-A(101))*f(23))/2._/**/REALKIND+((-A(57)-A(60) &
       -A(109)-A(113))*f(23))/6._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pphzjj_bbbxbxhz_1_/**/REALKIND
