
module ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  36,  12,  12,   0]
  K1( 2,:) = [  12,  36,   0,  12]
  K1( 3,:) = [  12,   0,  36,  12]
  K1( 4,:) = [   0,  12,  12,  36]
  K1( 5,:) = [  48,  16,  16,   0]
  K1( 6,:) = [  16,  48,   0,  16]
  K1( 7,:) = [  16,   0,  48,  16]
  K1( 8,:) = [   0,  16,  16,  48]
  K1( 9,:) = [   6,   2,   2,   0]
  K1(10,:) = [   2,   0,  -6, -16]
  K1(11,:) = [   2,  -6,   0, -16]
  K1(12,:) = [   0, -16, -16, -48]
  K1(13,:) = [  48,  16,  16,   0]
  K1(14,:) = [  16,  48,   0,  16]
  K1(15,:) = [  16,   0,  48,  16]
  K1(16,:) = [   0,  16,  16,  48]
  K1(17,:) = [   0,  16,  -2,   6]
  K1(18,:) = [  16,   0,   6,  -2]
  K1(19,:) = [  -2,   6,   0,  16]
  K1(20,:) = [   6,  -2,  16,   0]
  K1(21,:) = [   0,   2, -16,  -6]
  K1(22,:) = [   2,   6,   0,   2]
  K1(23,:) = [ -16,   0, -48, -16]
  K1(24,:) = [  -6,   2, -16,   0]
  K1(25,:) = [  48,  16,  16,   0]
  K1(26,:) = [  16,  48,   0,  16]
  K1(27,:) = [  16,   0,  48,  16]
  K1(28,:) = [   0,  16,  16,  48]
  K1(29,:) = [   0, -16,   2,  -6]
  K1(30,:) = [ -16, -48,   0, -16]
  K1(31,:) = [   2,   0,   6,   2]
  K1(32,:) = [  -6, -16,   2,   0]
  K1(33,:) = [   0,  -2,  16,   6]
  K1(34,:) = [  -2,   0,   6,  16]
  K1(35,:) = [  16,   6,   0,  -2]
  K1(36,:) = [   6,  16,  -2,   0]
  K1(37,:) = [ -48, -16, -16,   0]
  K1(38,:) = [ -16,   0,  -6,   2]
  K1(39,:) = [ -16,  -6,   0,   2]
  K1(40,:) = [   0,   2,   2,   6]
  K1(41,:) = [  48,  16,  16,   0]
  K1(42,:) = [  16,  48,   0,  16]
  K1(43,:) = [  16,   0,  48,  16]
  K1(44,:) = [   0,  16,  16,  48]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [ -54, -18, -18,   0]
  K1(66,:) = [ -18,   0,   0,  18]
  K1(67,:) = [ -18,   0, -54, -18]
  K1(68,:) = [   0,  18, -18,   0]
  K1(69,:) = [ -54, -18, -18,   0]
  K1(70,:) = [ -18, -54,   0, -18]
  K1(71,:) = [ -18,   0,   0,  18]
  K1(72,:) = [   0, -18,  18,   0]
  K1(73,:) = [   0, -18,  18,   0]
  K1(74,:) = [ -18, -54,   0, -18]
  K1(75,:) = [  18,   0,   0, -18]
  K1(76,:) = [   0, -18, -18, -54]
  K1(77,:) = [   0,  18, -18,   0]
  K1(78,:) = [  18,   0,   0, -18]
  K1(79,:) = [ -18,   0, -54, -18]
  K1(80,:) = [   0, -18, -18, -54]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [ 108,  36,  36,   0]
  K1(86,:) = [  36, 108,   0,  36]
  K1(87,:) = [  36,   0, 108,  36]
  K1(88,:) = [   0,  36,  36, 108]
  K1(89,:) = [  36,  12,  12,   0]
  K1(90,:) = [  12,  36,   0,  12]
  K1(91,:) = [  12,   0,  36,  12]
  K1(92,:) = [   0,  12,  12,  36]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND



module ol_forced_parameters_pphttj_ttxddxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphttj_ttxddxhg_1_/**/REALKIND

module ol_loop_pphttj_ttxddxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(23), c(29)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:167)
  ! denominators
  complex(REALKIND), save :: den(185)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(4,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*countertermnorm*ctHGG*eQED*gQCD**5
    f( 2) = countertermnorm*ctHGG*eQED*gQCD**5
    f( 3) = (CI*eQED*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 4) = (eQED*gQCD**3*MT)/(MW*sw*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*eQED*gQCD**5*MT)/(2._/**/REALKIND*MW*sw)
    f( 6) = (countertermnorm*eQED*gQCD**5*MT)/(MW*sw*2._/**/REALKIND)
    f( 7) = (CI*countertermnorm*ctGqq*eQED*gQCD**5*MT)/(2._/**/REALKIND*MW*sw)
    f( 8) = (countertermnorm*ctGqq*eQED*gQCD**5*MT)/(MW*sw*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*ctGtt*eQED*gQCD**5*MT)/(2._/**/REALKIND*MW*sw)
    f(10) = (countertermnorm*ctGtt*eQED*gQCD**5*MT)/(MW*sw*2._/**/REALKIND)
    f(11) = (CI*countertermnorm*ctStt*eQED*gQCD**5*MT)/(2._/**/REALKIND*MW*sw)
    f(12) = (countertermnorm*ctStt*eQED*gQCD**5*MT)/(MW*sw*2._/**/REALKIND)
    f(13) = (countertermnorm*ctVVV*eQED*gQCD**5*MT)/(MW*sw*2._/**/REALKIND)
    f(14) = (CI*eQED*gQCD**5*integralnorm*MT*SwB)/(4._/**/REALKIND*MW*sw)
    f(15) = (CI*eQED*gQCD**5*integralnorm*MT*SwB)/(2._/**/REALKIND*MW*sw)
    f(16) = (eQED*gQCD**5*integralnorm*MT*SwB)/(MW*sw*4._/**/REALKIND)
    f(17) = (eQED*gQCD**5*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(18) = (CI*eQED*gQCD**5*integralnorm*MB*SwF)/(2._/**/REALKIND*MW*sw)
    f(19) = (eQED*gQCD**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(20) = (CI*eQED*gQCD**5*integralnorm*MT*SwF)/(2._/**/REALKIND*MW*sw)
    f(21) = (CI*eQED*gQCD**5*integralnorm*MT*SwF)/(MW*sw)
    f(22) = (eQED*gQCD**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(23) = (eQED*gQCD**5*integralnorm*MT*SwF)/(MW*sw)

  c = [ 27*CI*f(14), 54*CI*f(14), 3*CI*f(15), 9*CI*f(15), 24*CI*f(15), 27*CI*f(15), 54*CI*f(15), 18*f(16), 54*f(16), f(17) &
    , 3*f(17), 6*f(17), 8*f(17), 9*f(17), 10*f(17), 18*f(17), 21*f(17), 24*f(17), 27*f(17), 54*f(17), 9*CI*f(18), 3*f(19), 9*f(19) &
    , 9*CI*f(20), 9*CI*f(21), 3*f(22), 9*f(22), 3*f(23), 9*f(23) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(4), M2(4)
  complex(REALKIND) :: A(107)

  ! external WFs

  call wf_Q(P(:,1), rMT, H(1), wf(:,0))
  call wf_A(P(:,2), rMT, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_S(P(:,5), rMH, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))


  ! internal WFs

  call vert_QS_A(gH,wf(:,0),wf(:,-4),wf(:,1))
  call vert_AV_Q(wf(:,-1),wf(:,-5),wf(:,2))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,3))
  call prop_Q_A(wf(:,1),Q(:,17),MT,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,2),Q(:,34),MT,1_intkind1,wf(:,5))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,6))
  call vert_QA_V(wf(:,4),wf(:,-1),wf(:,7))
  call vert_UV_W(wf(:,3),Q(:,12),wf(:,-5),Q(:,32),wf(:,8))
  call vert_AV_Q(wf(:,-1),wf(:,3),wf(:,9))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,10))
  call prop_A_Q(wf(:,9),Q(:,14),MT,1_intkind1,wf(:,11))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,12))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-1),wf(:,13))
  call prop_Q_A(wf(:,12),Q(:,33),MT,1_intkind1,wf(:,14))
  call prop_A_Q(wf(:,13),Q(:,18),MT,1_intkind1,wf(:,15))
  call vert_QA_V(wf(:,14),wf(:,15),wf(:,16))
  call vert_QA_V(wf(:,0),wf(:,15),wf(:,17))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,18))
  call vert_AV_Q(wf(:,15),wf(:,-5),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,13),MT,1_intkind1,wf(:,20))
  call vert_QS_A(gH,wf(:,14),wf(:,-4),wf(:,21))
  call vert_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,22))
  call vert_VQ_A(wf(:,-5),wf(:,-2),wf(:,23))
  call prop_Q_A(wf(:,23),Q(:,36),ZERO,0_intkind1,wf(:,24))
  call vert_QA_V(wf(:,24),wf(:,-3),wf(:,25))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,26))
  call prop_A_Q(wf(:,26),Q(:,40),ZERO,0_intkind1,wf(:,27))
  call vert_QA_V(wf(:,-2),wf(:,27),wf(:,28))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,29))
  call vert_UV_W(wf(:,29),Q(:,3),wf(:,-5),Q(:,32),wf(:,30))
  call counter_SG_G(wf(:,-4),wf(:,3),wf(:,31))
  call counter_SG_G(wf(:,-4),wf(:,29),wf(:,32))
  call counter_SG_G(wf(:,-4),wf(:,-5),wf(:,33))
  call vert_UV_W(wf(:,29),Q(:,3),wf(:,3),Q(:,12),wf(:,34))
  call vert_VQ_A(wf(:,29),wf(:,-2),wf(:,35))
  call vert_AV_Q(wf(:,-3),wf(:,33),wf(:,36))
  call prop_Q_A(wf(:,35),Q(:,7),ZERO,0_intkind1,wf(:,37))
  call vert_VQ_A(wf(:,33),wf(:,-2),wf(:,38))
  call vert_AV_Q(wf(:,-3),wf(:,29),wf(:,39))
  call prop_Q_A(wf(:,38),Q(:,52),ZERO,0_intkind1,wf(:,40))
  call counter_QA_V(wf(:,4),wf(:,5),wf(:,41))
  call counter_UV_W(wf(:,3),Q(:,12),wf(:,-5),Q(:,32),wf(:,42))
  call counter_VQ_A(wf(:,-5),wf(:,4),wf(:,43))
  call counter_QA_V(wf(:,14),wf(:,15),wf(:,44))
  call counter_AV_Q(wf(:,15),wf(:,-5),wf(:,45))
  call vert_QA_V(wf(:,14),wf(:,-1),wf(:,46))
  call counter_QS_A(gH,wf(:,14),wf(:,-4),wf(:,47))
  call vert_QA_V(wf(:,0),wf(:,5),wf(:,48))
  call counter_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,49))
  call vert_AV_Q(wf(:,-1),wf(:,33),wf(:,50))
  call vert_VQ_A(wf(:,33),wf(:,0),wf(:,51))
  call prop_Q_A(wf(:,51),Q(:,49),MT,1_intkind1,wf(:,52))
  call counter_QA_V(wf(:,24),wf(:,-3),wf(:,53))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,40),ZERO,0_intkind1,wf(:,55))
  call vert_QA_V(wf(:,-2),wf(:,55),wf(:,56))
  call counter_QA_V(wf(:,-2),wf(:,27),wf(:,57))
  call counter_VQ_A(wf(:,-5),wf(:,-2),wf(:,58))
  call prop_Q_A(wf(:,58),Q(:,36),ZERO,0_intkind1,wf(:,59))
  call vert_QA_V(wf(:,59),wf(:,-3),wf(:,60))
  call counter_QA_V(wf(:,-2),wf(:,-3),wf(:,61))
  call vert_UV_W(wf(:,61),Q(:,12),wf(:,-5),Q(:,32),wf(:,62))
  call vert_AV_Q(wf(:,-1),wf(:,61),wf(:,63))
  call prop_A_Q(wf(:,63),Q(:,14),MT,1_intkind1,wf(:,64))
  call vert_VQ_A(wf(:,61),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,13),MT,1_intkind1,wf(:,66))
  call counter_AV_Q(wf(:,-1),wf(:,3),wf(:,67))
  call prop_Q_A(wf(:,10),Q(:,49),MT,1_intkind1,wf(:,68))
  call counter_QA_V(wf(:,4),wf(:,-1),wf(:,69))
  call counter_AV_Q(wf(:,-1),wf(:,-5),wf(:,70))
  call prop_A_Q(wf(:,70),Q(:,34),MT,1_intkind1,wf(:,71))
  call vert_QA_V(wf(:,4),wf(:,71),wf(:,72))
  call prop_Q_A(wf(:,21),Q(:,49),MT,1_intkind1,wf(:,73))
  call vert_SA_Q(gH,wf(:,-4),wf(:,71),wf(:,74))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-1),wf(:,75))
  call prop_A_Q(wf(:,75),Q(:,18),MT,1_intkind1,wf(:,76))
  call vert_QA_V(wf(:,14),wf(:,76),wf(:,77))
  call vert_AV_Q(wf(:,76),wf(:,-5),wf(:,78))
  call vert_QA_V(wf(:,0),wf(:,76),wf(:,79))
  call counter_QA_V(wf(:,0),wf(:,15),wf(:,80))
  call counter_VQ_A(wf(:,3),wf(:,0),wf(:,81))
  call prop_A_Q(wf(:,19),Q(:,50),MT,1_intkind1,wf(:,82))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,83))
  call prop_Q_A(wf(:,83),Q(:,33),MT,1_intkind1,wf(:,84))
  call vert_QA_V(wf(:,84),wf(:,15),wf(:,85))
  call prop_A_Q(wf(:,22),Q(:,50),MT,1_intkind1,wf(:,86))
  call vert_QS_A(gH,wf(:,84),wf(:,-4),wf(:,87))
  call counter_QS_A(gH,wf(:,0),wf(:,-4),wf(:,88))
  call prop_Q_A(wf(:,88),Q(:,17),MT,1_intkind1,wf(:,89))
  call vert_QA_V(wf(:,89),wf(:,5),wf(:,90))
  call vert_QA_V(wf(:,89),wf(:,-1),wf(:,91))
  call vert_VQ_A(wf(:,-5),wf(:,89),wf(:,92))
  call vert_AV_Q(wf(:,5),wf(:,3),wf(:,93))
  call counter_Q_A(cttt,wf(:,4),Q(:,17),wf(:,94))
  call prop_A_Q(wf(:,93),Q(:,46),MT,1_intkind1,wf(:,95))
  call vert_VQ_A(wf(:,3),wf(:,4),wf(:,96))
  call counter_A_Q(cttt,wf(:,5),Q(:,34),wf(:,97))
  call prop_Q_A(wf(:,96),Q(:,29),MT,1_intkind1,wf(:,98))
  call counter_V_V(ctGG,wf(:,3),Q(:,12),wf(:,99))
  call prop_Q_A(wf(:,94),Q(:,17),MT,1_intkind1,wf(:,100))
  call vert_QA_V(wf(:,100),wf(:,-1),wf(:,101))
  call vert_VQ_A(wf(:,-5),wf(:,100),wf(:,102))
  call vert_AV_Q(wf(:,-1),wf(:,99),wf(:,103))
  call counter_V_V(ctGG,wf(:,7),Q(:,19),wf(:,104))
  call counter_A_Q(cttt,wf(:,11),Q(:,14),wf(:,105))
  call vert_UV_W(wf(:,99),Q(:,12),wf(:,-5),Q(:,32),wf(:,106))
  call vert_AV_Q(wf(:,15),wf(:,3),wf(:,107))
  call counter_Q_A(cttt,wf(:,14),Q(:,33),wf(:,108))
  call prop_A_Q(wf(:,107),Q(:,30),MT,1_intkind1,wf(:,109))
  call vert_VQ_A(wf(:,3),wf(:,14),wf(:,110))
  call counter_A_Q(cttt,wf(:,15),Q(:,18),wf(:,111))
  call prop_Q_A(wf(:,110),Q(:,45),MT,1_intkind1,wf(:,112))
  call prop_A_Q(wf(:,111),Q(:,18),MT,1_intkind1,wf(:,113))
  call vert_QA_V(wf(:,0),wf(:,113),wf(:,114))
  call vert_VQ_A(wf(:,99),wf(:,0),wf(:,115))
  call counter_V_V(ctGG,wf(:,17),Q(:,19),wf(:,116))
  call counter_Q_A(cttt,wf(:,20),Q(:,13),wf(:,117))
  call vert_AV_Q(wf(:,113),wf(:,-5),wf(:,118))
  call prop_Q_A(wf(:,108),Q(:,33),MT,1_intkind1,wf(:,119))
  call vert_QS_A(gH,wf(:,119),wf(:,-4),wf(:,120))
  call prop_A_Q(wf(:,97),Q(:,34),MT,1_intkind1,wf(:,121))
  call vert_SA_Q(gH,wf(:,-4),wf(:,121),wf(:,122))
  call counter_Q_A(ctqq,wf(:,24),Q(:,36),wf(:,123))
  call prop_Q_A(wf(:,123),Q(:,36),ZERO,0_intkind1,wf(:,124))
  call vert_QA_V(wf(:,124),wf(:,-3),wf(:,125))
  call counter_A_Q(ctqq,wf(:,27),Q(:,40),wf(:,126))
  call prop_A_Q(wf(:,126),Q(:,40),ZERO,0_intkind1,wf(:,127))
  call vert_QA_V(wf(:,-2),wf(:,127),wf(:,128))
  call vert_QA_V(wf(:,37),wf(:,-3),wf(:,129))
  call prop_A_Q(wf(:,39),Q(:,11),ZERO,0_intkind1,wf(:,130))
  call vert_QA_V(wf(:,-2),wf(:,130),wf(:,131))
  call vert_QA_V(wf(:,20),wf(:,-1),wf(:,132))
  call vert_QA_V(wf(:,0),wf(:,11),wf(:,133))
  call vert_QS_A(gH,wf(:,20),wf(:,-4),wf(:,134))
  call prop_Q_A(wf(:,134),Q(:,29),MT,1_intkind1,wf(:,135))
  call vert_VQ_A(wf(:,-5),wf(:,20),wf(:,136))
  call prop_Q_A(wf(:,136),Q(:,45),MT,1_intkind1,wf(:,137))
  call vert_VQ_A(wf(:,8),wf(:,0),wf(:,138))
  call prop_Q_A(wf(:,138),Q(:,45),MT,1_intkind1,wf(:,139))
  call vert_SA_Q(gH,wf(:,-4),wf(:,11),wf(:,140))
  call prop_A_Q(wf(:,140),Q(:,30),MT,1_intkind1,wf(:,141))
  call vert_AV_Q(wf(:,11),wf(:,-5),wf(:,142))
  call prop_A_Q(wf(:,142),Q(:,46),MT,1_intkind1,wf(:,143))
  call vert_AV_Q(wf(:,-1),wf(:,8),wf(:,144))
  call prop_A_Q(wf(:,144),Q(:,46),MT,1_intkind1,wf(:,145))
  call vert_VQ_A(wf(:,7),wf(:,-2),wf(:,146))
  call prop_Q_A(wf(:,146),Q(:,23),ZERO,0_intkind1,wf(:,147))
  call vert_AV_Q(wf(:,-3),wf(:,7),wf(:,148))
  call prop_A_Q(wf(:,148),Q(:,27),ZERO,0_intkind1,wf(:,149))
  call vert_UV_W(wf(:,7),Q(:,19),wf(:,-5),Q(:,32),wf(:,150))
  call vert_QA_V(wf(:,68),wf(:,-1),wf(:,151))
  call vert_VQ_A(wf(:,17),wf(:,-2),wf(:,152))
  call prop_Q_A(wf(:,152),Q(:,23),ZERO,0_intkind1,wf(:,153))
  call vert_AV_Q(wf(:,-3),wf(:,17),wf(:,154))
  call prop_A_Q(wf(:,154),Q(:,27),ZERO,0_intkind1,wf(:,155))
  call vert_UV_W(wf(:,17),Q(:,19),wf(:,-5),Q(:,32),wf(:,156))
  call vert_QA_V(wf(:,0),wf(:,82),wf(:,157))
  call vert_QA_V(wf(:,73),wf(:,-1),wf(:,158))
  call vert_QA_V(wf(:,0),wf(:,86),wf(:,159))
  call vert_VQ_A(wf(:,25),wf(:,0),wf(:,160))
  call prop_Q_A(wf(:,160),Q(:,45),MT,1_intkind1,wf(:,161))
  call vert_AV_Q(wf(:,-1),wf(:,25),wf(:,162))
  call prop_A_Q(wf(:,162),Q(:,46),MT,1_intkind1,wf(:,163))
  call vert_VQ_A(wf(:,28),wf(:,0),wf(:,164))
  call prop_Q_A(wf(:,164),Q(:,45),MT,1_intkind1,wf(:,165))
  call vert_AV_Q(wf(:,-1),wf(:,28),wf(:,166))
  call prop_A_Q(wf(:,166),Q(:,46),MT,1_intkind1,wf(:,167))


  ! propagators

    den(1) = 1 / (Q(5,17) - MT2)
    den(2) = 1 / (Q(5,34) - MT2)
    den(3) = 1 / (Q(5,12))
    den(6) = 1 / (Q(5,19))
    den(9) = 1 / (Q(5,14) - MT2)
    den(12) = 1 / (Q(5,33) - MT2)
    den(13) = 1 / (Q(5,18) - MT2)
    den(18) = 1 / (Q(5,13) - MT2)
    den(23) = 1 / (Q(5,36))
    den(25) = 1 / (Q(5,40))
    den(29) = 1 / (Q(5,3))
    den(30) = 1 / (Q(5,35))
    den(33) = 1 / (Q(5,44))
    den(36) = 1 / (Q(5,48))
    den(43) = 1 / (Q(5,7))
    den(46) = 1 / (Q(5,52))
    den(54) = 1 / (Q(5,49) - MT2)
    den(65) = 1 / (Q(5,50) - MT2)
    den(73) = 1 / (Q(5,46) - MT2)
    den(77) = 1 / (Q(5,29) - MT2)
    den(80) = 1 / (Q(5,51))
    den(92) = 1 / (Q(5,30) - MT2)
    den(96) = 1 / (Q(5,45) - MT2)
    den(130) = 1 / (Q(5,15))
    den(133) = 1 / (Q(5,11))
    den(144) = 1 / (Q(5,23))
    den(146) = 1 / (Q(5,27))


  ! denominators

    den(4) = den(1)*den(2)
    den(5) = den(3)*den(4)
    den(7) = den(1)*den(6)
    den(8) = den(3)*den(7)
    den(10) = den(3)*den(9)
    den(11) = den(1)*den(10)
    den(14) = den(12)*den(13)
    den(15) = den(3)*den(14)
    den(16) = den(6)*den(13)
    den(17) = den(3)*den(16)
    den(19) = den(3)*den(18)
    den(20) = den(13)*den(19)
    den(21) = den(10)*den(12)
    den(22) = den(2)*den(19)
    den(24) = den(7)*den(23)
    den(26) = den(7)*den(25)
    den(27) = den(16)*den(23)
    den(28) = den(16)*den(25)
    den(31) = den(29)*den(30)
    den(32) = den(3)*den(31)
    den(34) = den(3)*den(33)
    den(35) = den(29)*den(34)
    den(37) = den(3)*den(29)
    den(38) = den(36)*den(37)
    den(39) = den(23)*den(33)
    den(40) = den(29)*den(39)
    den(41) = den(25)*den(33)
    den(42) = den(29)*den(41)
    den(44) = den(29)*den(43)
    den(45) = den(36)*den(44)
    den(47) = den(36)*den(46)
    den(48) = den(29)*den(47)
    den(49) = den(12)*den(30)
    den(50) = den(3)*den(49)
    den(51) = den(2)*den(30)
    den(52) = den(3)*den(51)
    den(53) = den(19)*den(36)
    den(55) = den(36)*den(54)
    den(56) = den(3)*den(55)
    den(57) = den(1)*den(54)
    den(58) = den(3)*den(57)
    den(59) = den(1)*den(34)
    den(60) = den(12)*den(54)
    den(61) = den(3)*den(60)
    den(62) = den(1)*den(39)
    den(63) = den(1)*den(41)
    den(64) = den(13)*den(34)
    den(66) = den(13)*den(65)
    den(67) = den(3)*den(66)
    den(68) = den(2)*den(65)
    den(69) = den(3)*den(68)
    den(70) = den(13)*den(39)
    den(71) = den(13)*den(41)
    den(72) = den(2)*den(3)
    den(74) = den(72)*den(73)
    den(75) = den(1)*den(74)
    den(76) = den(1)*den(3)
    den(78) = den(76)*den(77)
    den(79) = den(2)*den(78)
    den(81) = den(4)*den(80)
    den(82) = den(3)*den(81)
    den(83) = den(1)**2
    den(84) = den(34)*den(83)
    den(85) = den(10)*den(83)
    den(86) = den(3)**2
    den(87) = den(57)*den(86)
    den(88) = den(7)*den(34)
    den(89) = den(10)*den(57)
    den(90) = den(7)*den(86)
    den(91) = den(3)*den(13)
    den(93) = den(91)*den(92)
    den(94) = den(12)*den(93)
    den(95) = den(3)*den(12)
    den(97) = den(95)*den(96)
    den(98) = den(13)*den(97)
    den(99) = den(14)*den(80)
    den(100) = den(3)*den(99)
    den(101) = den(13)**2
    den(102) = den(34)*den(101)
    den(103) = den(66)*den(86)
    den(104) = den(16)*den(34)
    den(105) = den(19)*den(66)
    den(106) = den(19)*den(101)
    den(107) = den(16)*den(86)
    den(108) = den(12)**2
    den(109) = den(10)*den(108)
    den(110) = den(60)*den(86)
    den(111) = den(10)*den(60)
    den(112) = den(68)*den(86)
    den(113) = den(19)*den(68)
    den(114) = den(2)**2
    den(115) = den(19)*den(114)
    den(116) = den(39)*den(83)
    den(117) = den(7)*den(39)
    den(118) = den(23)**2
    den(119) = den(7)*den(118)
    den(120) = den(41)*den(83)
    den(121) = den(7)*den(41)
    den(122) = den(25)**2
    den(123) = den(7)*den(122)
    den(124) = den(39)*den(101)
    den(125) = den(16)*den(39)
    den(126) = den(16)*den(118)
    den(127) = den(41)*den(101)
    den(128) = den(16)*den(41)
    den(129) = den(16)*den(122)
    den(131) = den(37)*den(130)
    den(132) = den(44)*den(130)
    den(134) = den(29)*den(133)
    den(135) = den(130)*den(134)
    den(136) = den(19)*den(130)
    den(137) = den(10)*den(130)
    den(138) = den(19)*den(77)
    den(139) = den(19)*den(96)
    den(140) = den(34)*den(96)
    den(141) = den(10)*den(92)
    den(142) = den(10)*den(73)
    den(143) = den(34)*den(73)
    den(145) = den(7)*den(144)
    den(147) = den(7)*den(146)
    den(148) = den(7)*den(80)
    den(149) = den(57)*den(80)
    den(150) = den(16)*den(144)
    den(151) = den(16)*den(146)
    den(152) = den(16)*den(80)
    den(153) = den(66)*den(80)
    den(154) = den(60)*den(80)
    den(155) = den(68)*den(80)
    den(156) = den(39)*den(96)
    den(157) = den(39)*den(73)
    den(158) = den(41)*den(96)
    den(159) = den(41)*den(73)
    den(160) = den(1)*den(2)*den(3)
    den(161) = den(3)*den(12)*den(13)
    den(162) = den(1)*den(23)
    den(163) = den(1)*den(25)
    den(164) = den(13)*den(23)
    den(165) = den(13)*den(25)
    den(166) = den(3)*den(148)
    den(167) = den(3)*den(149)
    den(168) = den(1)*den(142)
    den(169) = den(1)*den(143)
    den(170) = den(3)*den(152)
    den(171) = den(13)*den(139)
    den(172) = den(3)*den(153)
    den(173) = den(13)*den(140)
    den(174) = den(3)*den(154)
    den(175) = den(12)*den(141)
    den(176) = den(2)*den(138)
    den(177) = den(3)*den(155)
    den(178) = den(23)*den(147)
    den(179) = den(1)*den(157)
    den(180) = den(25)*den(145)
    den(181) = den(1)*den(159)
    den(182) = den(23)*den(151)
    den(183) = den(13)*den(156)
    den(184) = den(25)*den(150)
    den(185) = den(13)*den(158)


  ! colour stripped tree amplitudes

  A(1) = cont_VV(wf(:,3),wf(:,6)) * den(5)
  A(2) = cont_VV(wf(:,7),wf(:,8)) * den(8)
  A(3) = cont_QA(wf(:,10),wf(:,11)) * den(11)
  A(4) = cont_VV(wf(:,3),wf(:,16)) * den(15)
  A(5) = cont_VV(wf(:,8),wf(:,17)) * den(17)
  A(6) = cont_QA(wf(:,19),wf(:,20)) * den(20)
  A(7) = cont_QA(wf(:,11),wf(:,21)) * den(21)
  A(8) = cont_QA(wf(:,20),wf(:,22)) * den(22)
  A(9) = cont_VV(wf(:,7),wf(:,25)) * den(24)
  A(10) = cont_VV(wf(:,7),wf(:,28)) * den(26)
  A(11) = cont_VV(wf(:,17),wf(:,25)) * den(27)
  A(12) = cont_VV(wf(:,17),wf(:,28)) * den(28)

  A(13) = cont_VV(wf(:,30),wf(:,31)) * den(32)
  A(14) = cont_VV(wf(:,8),wf(:,32)) * den(35)
  A(15) = cont_VV(wf(:,33),wf(:,34)) * den(38)
  A(16) = cont_VV(wf(:,25),wf(:,32)) * den(40)
  A(17) = cont_VV(wf(:,28),wf(:,32)) * den(42)
  A(18) = cont_QA(wf(:,36),wf(:,37)) * den(45)
  A(19) = cont_QA(wf(:,39),wf(:,40)) * den(48)
  A(20) = cont_VV(wf(:,3),wf(:,41)) * den(5)
  A(21) = cont_VV(wf(:,7),wf(:,42)) * den(8)
  A(22) = cont_QA(wf(:,11),wf(:,43)) * den(11)
  A(23) = cont_VV(wf(:,3),wf(:,44)) * den(15)
  A(24) = cont_VV(wf(:,17),wf(:,42)) * den(17)
  A(25) = cont_QA(wf(:,20),wf(:,45)) * den(20)
  A(26) = cont_VV(wf(:,31),wf(:,46)) * den(50)
  A(27) = cont_QA(wf(:,11),wf(:,47)) * den(21)
  A(28) = cont_VV(wf(:,31),wf(:,48)) * den(52)
  A(29) = cont_QA(wf(:,20),wf(:,49)) * den(22)
  A(30) = cont_QA(wf(:,20),wf(:,50)) * den(53)
  A(31) = cont_QA(wf(:,9),wf(:,52)) * den(56)
  A(32) = cont_VV(wf(:,7),wf(:,53)) * den(24)
  A(33) = cont_VV(wf(:,7),wf(:,56)) * den(26)
  A(34) = cont_VV(wf(:,17),wf(:,53)) * den(27)
  A(35) = cont_VV(wf(:,17),wf(:,56)) * den(28)
  A(36) = cont_VV(wf(:,7),wf(:,57)) * den(26)
  A(37) = cont_VV(wf(:,7),wf(:,60)) * den(24)
  A(38) = cont_VV(wf(:,17),wf(:,57)) * den(28)
  A(39) = cont_VV(wf(:,17),wf(:,60)) * den(27)
  A(40) = cont_VV(wf(:,6),wf(:,61)) * den(5)
  A(41) = cont_VV(wf(:,7),wf(:,62)) * den(8)
  A(42) = cont_QA(wf(:,10),wf(:,64)) * den(11)
  A(43) = cont_VV(wf(:,16),wf(:,61)) * den(15)
  A(44) = cont_VV(wf(:,17),wf(:,62)) * den(17)
  A(45) = cont_QA(wf(:,19),wf(:,66)) * den(20)
  A(46) = cont_QA(wf(:,21),wf(:,64)) * den(21)
  A(47) = cont_QA(wf(:,22),wf(:,66)) * den(22)
  A(48) = cont_QA(wf(:,67),wf(:,68)) * den(58)
  A(49) = cont_VV(wf(:,8),wf(:,69)) * den(59)
  A(50) = cont_VV(wf(:,3),wf(:,72)) * den(5)
  A(51) = cont_QA(wf(:,67),wf(:,73)) * den(61)
  A(52) = cont_QA(wf(:,20),wf(:,74)) * den(22)
  A(53) = cont_VV(wf(:,3),wf(:,77)) * den(15)
  A(54) = cont_QA(wf(:,20),wf(:,78)) * den(20)
  A(55) = cont_VV(wf(:,8),wf(:,79)) * den(17)
  A(56) = cont_VV(wf(:,25),wf(:,69)) * den(62)
  A(57) = cont_VV(wf(:,28),wf(:,69)) * den(63)
  A(58) = cont_VV(wf(:,25),wf(:,79)) * den(27)
  A(59) = cont_VV(wf(:,28),wf(:,79)) * den(28)
  A(60) = cont_VV(wf(:,8),wf(:,80)) * den(64)
  A(61) = cont_QA(wf(:,81),wf(:,82)) * den(67)
  A(62) = cont_VV(wf(:,3),wf(:,85)) * den(15)
  A(63) = cont_QA(wf(:,81),wf(:,86)) * den(69)
  A(64) = cont_QA(wf(:,11),wf(:,87)) * den(21)
  A(65) = cont_VV(wf(:,3),wf(:,90)) * den(5)
  A(66) = cont_VV(wf(:,8),wf(:,91)) * den(8)
  A(67) = cont_QA(wf(:,11),wf(:,92)) * den(11)
  A(68) = cont_VV(wf(:,25),wf(:,80)) * den(70)
  A(69) = cont_VV(wf(:,28),wf(:,80)) * den(71)
  A(70) = cont_VV(wf(:,25),wf(:,91)) * den(24)
  A(71) = cont_VV(wf(:,28),wf(:,91)) * den(26)
  A(72) = cont_QA(wf(:,94),wf(:,95)) * den(75)
  A(73) = cont_QA(wf(:,97),wf(:,98)) * den(79)
  A(74) = cont_VV(wf(:,6),wf(:,99)) * den(82)
  A(75) = cont_VV(wf(:,8),wf(:,101)) * den(84)
  A(76) = cont_QA(wf(:,11),wf(:,102)) * den(85)
  A(77) = cont_QA(wf(:,68),wf(:,103)) * den(87)
  A(78) = cont_VV(wf(:,8),wf(:,104)) * den(88)
  A(79) = cont_QA(wf(:,68),wf(:,105)) * den(89)
  A(80) = cont_VV(wf(:,7),wf(:,106)) * den(90)
  A(81) = cont_QA(wf(:,108),wf(:,109)) * den(94)
  A(82) = cont_QA(wf(:,111),wf(:,112)) * den(98)
  A(83) = cont_VV(wf(:,16),wf(:,99)) * den(100)
  A(84) = cont_VV(wf(:,8),wf(:,114)) * den(102)
  A(85) = cont_QA(wf(:,82),wf(:,115)) * den(103)
  A(86) = cont_VV(wf(:,8),wf(:,116)) * den(104)
  A(87) = cont_QA(wf(:,82),wf(:,117)) * den(105)
  A(88) = cont_QA(wf(:,20),wf(:,118)) * den(106)
  A(89) = cont_VV(wf(:,17),wf(:,106)) * den(107)
  A(90) = cont_QA(wf(:,11),wf(:,120)) * den(109)
  A(91) = cont_QA(wf(:,73),wf(:,103)) * den(110)
  A(92) = cont_QA(wf(:,73),wf(:,105)) * den(111)
  A(93) = cont_QA(wf(:,86),wf(:,115)) * den(112)
  A(94) = cont_QA(wf(:,86),wf(:,117)) * den(113)
  A(95) = cont_QA(wf(:,20),wf(:,122)) * den(115)
  A(96) = cont_VV(wf(:,25),wf(:,101)) * den(116)
  A(97) = cont_VV(wf(:,25),wf(:,104)) * den(117)
  A(98) = cont_VV(wf(:,7),wf(:,125)) * den(119)
  A(99) = cont_VV(wf(:,28),wf(:,101)) * den(120)
  A(100) = cont_VV(wf(:,28),wf(:,104)) * den(121)
  A(101) = cont_VV(wf(:,7),wf(:,128)) * den(123)
  A(102) = cont_VV(wf(:,25),wf(:,114)) * den(124)
  A(103) = cont_VV(wf(:,25),wf(:,116)) * den(125)
  A(104) = cont_VV(wf(:,17),wf(:,125)) * den(126)
  A(105) = cont_VV(wf(:,28),wf(:,114)) * den(127)
  A(106) = cont_VV(wf(:,28),wf(:,116)) * den(128)
  A(107) = cont_VV(wf(:,17),wf(:,128)) * den(129)


  ! colour vectors

  M1(1) = ((-A(1)-A(3)-A(4)-A(6)-A(7)-A(8))*f(3))/6._/**/REALKIND
  M1(2) = ((A(1)+A(6)+A(8)+A(9)+A(11))*f(3))/2._/**/REALKIND+(CI*(-A(2)-A(5))*f(4))/2._/**/REALKIND
  M1(3) = ((A(3)+A(4)+A(7)+A(10)+A(12))*f(3))/2._/**/REALKIND+(CI*(A(2)+A(5))*f(4))/2._/**/REALKIND
  M1(4) = ((-A(9)-A(10)-A(11)-A(12))*f(3))/6._/**/REALKIND

  M2(1) = ((-A(26)-A(28)-A(30)-A(31))*f(1))/6._/**/REALKIND+((A(72)+A(73)+A(74)+A(76)+A(77)+A(79)+A(81)+A(82)+A(83)+A(85)+A(87) &
       +A(88)+A(90)+A(91)+A(92)+A(93)+A(94)+A(95))*f(5))/6._/**/REALKIND+((-A(40)-A(42)-A(43)-A(45)-A(46) &
       -A(47))*f(7))/6._/**/REALKIND+((-A(20)-A(22)-A(23)-A(25)-A(48)-A(50)-A(51)-A(52)-A(61)-A(62)-A(63) &
       -A(64))*f(9))/6._/**/REALKIND+((-A(27)-A(29)-A(53)-A(54)-A(65)-A(67))*f(11))/6._/**/REALKIND
  M2(2) = ((A(16)+A(19)+A(28)+A(30))*f(1))/2._/**/REALKIND+(CI*(A(13)-A(14)-A(15))*f(2))/2._/**/REALKIND+((-A(72)-A(73)-A(74) &
       -A(85)-A(87)-A(88)-A(93)-A(94)-A(95)-A(96)-A(97)-A(98)-A(102)-A(103)-A(104))*f(5))/2._/**/REALKIND+(CI*(A(75)+A(78)+A(80) &
       +A(84)+A(86)+A(89))*f(6))/2._/**/REALKIND+((A(32)+A(34)+A(37)+A(39)+A(40)+A(45)+A(47))*f(7))/2._/**/REALKIND+(CI*(-A(41) &
       -A(44))*f(8))/2._/**/REALKIND+((A(20)+A(25)+A(50)+A(52)+A(56)+A(61)+A(63)+A(68))*f(9))/2._/**/REALKIND+(CI*(-A(49) &
       -A(60))*f(10))/2._/**/REALKIND+((A(29)+A(54)+A(58)+A(65)+A(70))*f(11))/2._/**/REALKIND+(CI*(-A(55) &
       -A(66))*f(12))/2._/**/REALKIND+(CI*(-A(21)-A(24))*f(13))/2._/**/REALKIND
  M2(3) = ((A(17)+A(18)+A(26)+A(31))*f(1))/2._/**/REALKIND+(CI*(-A(13)+A(14)+A(15))*f(2))/2._/**/REALKIND+((-A(76)-A(77)-A(79) &
       -A(81)-A(82)-A(83)-A(90)-A(91)-A(92)-A(99)-A(100)-A(101)-A(105)-A(106)-A(107))*f(5))/2._/**/REALKIND+(CI*(-A(75)-A(78) &
       -A(80)-A(84)-A(86)-A(89))*f(6))/2._/**/REALKIND+((A(33)+A(35)+A(36)+A(38)+A(42)+A(43)+A(46))*f(7))/2._/**/REALKIND &
       +(CI*(A(41)+A(44))*f(8))/2._/**/REALKIND+((A(22)+A(23)+A(48)+A(51)+A(57)+A(62)+A(64)+A(69))*f(9))/2._/**/REALKIND &
       +(CI*(A(49)+A(60))*f(10))/2._/**/REALKIND+((A(27)+A(53)+A(59)+A(67)+A(71))*f(11))/2._/**/REALKIND+(CI*(A(55) &
       +A(66))*f(12))/2._/**/REALKIND+(CI*(A(21)+A(24))*f(13))/2._/**/REALKIND
  M2(4) = ((-A(16)-A(17)-A(18)-A(19))*f(1))/6._/**/REALKIND+((A(96)+A(97)+A(98)+A(99)+A(100)+A(101)+A(102)+A(103)+A(104)+A(105) &
       +A(106)+A(107))*f(5))/6._/**/REALKIND+((-A(32)-A(33)-A(34)-A(35)-A(36)-A(37)-A(38)-A(39))*f(7))/6._/**/REALKIND+((-A(56) &
       -A(57)-A(68)-A(69))*f(9))/6._/**/REALKIND+((-A(58)-A(59)-A(70)-A(71))*f(11))/6._/**/REALKIND


end subroutine tree_wavefunctions

end module ol_loop_pphttj_ttxddxhg_1_/**/REALKIND
