
! **********************************************************************
module ol_heltables_pphttj_ttxhggg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(1) = [0], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n3, n8, n12, n16, n19, n22, n26, n28, n31, n35, n38, n41, n44, n46, n50, n53, n55, n58, n61, n63, n66, n68, n71, n73, n75, n77 &
  , n79, n81, n83, n85

  integer(intkind2), save, dimension(3) :: &
  n1, n4, n7, n9, n10, n11, n13, n14, n15, n17, n18, n20, n21, n23, n24, n25, n27, n29, n30, n32, n33, n34, n36, n37, n39, n40 &
  , n42, n43, n45, n47, n48, n49, n51, n52, n54, n56, n57, n59, n60, n62, n64, n65, n67, n69, n70, n72, n74, n76, n78, n80, n82 &
  , n84, n86, n87, n88, n89, n90, n91, n92, n93, n94, n95, n96, n97, n98, n99, n100, n101, n102, n103, n104, n105, n106, n107 &
  , n108, n109, n110, n111, n112, n113, n114, n115, n116, n117, n118, n119, n120, n121, n122, n123, n124, n125, n126, n127, n128 &
  , n129, n130, n131, n132, n133, n134, n135, n136, n137, n138, n139

  integer(intkind2), save, dimension(4) :: &
  n2, n5, n6


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,2) :: &
  t1, t7

  integer(intkind2), save, dimension(2,4) :: &
  t4, t9, t10, t11, t14, t18, t20, t21, t24, t29, t30, t45, t49, t51, t54, t59, t62, t74, t76, t78, t80, t82, t84

  integer(intkind2), save, dimension(2,8) :: &
  t13, t15, t17, t23, t25, t27, t32, t33, t34, t36, t37, t39, t40, t42, t43, t47, t48, t52, t56, t57, t60, t64, t65, t67, t69, t70 &
  , t72

  integer(intkind2), save, dimension(2,32) :: &
  t86, t87, t88, t89, t90, t91, t92, t93, t94, t95, t96, t97, t98, t99, t100, t101, t102, t103, t104, t105, t106, t107, t108, t109 &
  , t110, t111, t112, t113, t114, t115, t116, t117, t118, t119, t120, t121, t122, t123, t124, t125, t126, t127, t128, t129, t130 &
  , t131, t132, t133, t134, t135, t136, t137, t138, t139

  integer(intkind2), save, dimension(3,8) :: &
  t2, t5, t6


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(32,6)
  integer,           save :: exthel(32,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,1,2], n1, t1)
  call heltable([2,2,2,8], n2, t2)
  n3 = 2
  call heltable([2,2,4], n4, t4)
  call heltable([2,2,2,8], n5, t5)
  call heltable([2,2,2,8], n6, t6)
  call heltable([1,2,2], n7, t7)
  n8 = 2
  call heltable([2,2,4], n9, t9)
  call heltable([2,2,4], n10, t10)
  call heltable([2,2,4], n11, t11)
  n12 = 4
  call heltable([2,4,8], n13, t13)
  call heltable([2,2,4], n14, t14)
  call heltable([4,2,8], n15, t15)
  n16 = 4
  call heltable([4,2,8], n17, t17)
  call heltable([2,2,4], n18, t18)
  n19 = 8
  call heltable([2,2,4], n20, t20)
  call heltable([2,2,4], n21, t21)
  n22 = 4
  call heltable([2,4,8], n23, t23)
  call heltable([2,2,4], n24, t24)
  call heltable([4,2,8], n25, t25)
  n26 = 4
  call heltable([4,2,8], n27, t27)
  n28 = 8
  call heltable([2,2,4], n29, t29)
  call heltable([2,2,4], n30, t30)
  n31 = 4
  call heltable([2,4,8], n32, t32)
  call heltable([4,2,8], n33, t33)
  call heltable([2,4,8], n34, t34)
  n35 = 8
  call heltable([4,2,8], n36, t36)
  call heltable([4,2,8], n37, t37)
  n38 = 8
  call heltable([2,4,8], n39, t39)
  call heltable([2,4,8], n40, t40)
  n41 = 8
  call heltable([2,4,8], n42, t42)
  call heltable([2,4,8], n43, t43)
  n44 = 8
  call heltable([2,2,4], n45, t45)
  n46 = 4
  call heltable([4,2,8], n47, t47)
  call heltable([2,4,8], n48, t48)
  call heltable([2,2,4], n49, t49)
  n50 = 8
  call heltable([2,2,4], n51, t51)
  call heltable([2,4,8], n52, t52)
  n53 = 4
  call heltable([2,2,4], n54, t54)
  n55 = 4
  call heltable([4,2,8], n56, t56)
  call heltable([2,4,8], n57, t57)
  n58 = 8
  call heltable([2,2,4], n59, t59)
  call heltable([2,4,8], n60, t60)
  n61 = 4
  call heltable([2,2,4], n62, t62)
  n63 = 4
  call heltable([4,2,8], n64, t64)
  call heltable([4,2,8], n65, t65)
  n66 = 8
  call heltable([2,4,8], n67, t67)
  n68 = 8
  call heltable([2,4,8], n69, t69)
  call heltable([4,2,8], n70, t70)
  n71 = 8
  call heltable([4,2,8], n72, t72)
  n73 = 8
  call heltable([4,1,4], n74, t74)
  n75 = 4
  call heltable([1,4,4], n76, t76)
  n77 = 4
  call heltable([1,4,4], n78, t78)
  n79 = 4
  call heltable([4,1,4], n80, t80)
  n81 = 4
  call heltable([1,4,4], n82, t82)
  n83 = 4
  call heltable([4,1,4], n84, t84)
  n85 = 4
  call heltable([8,4,32], n86, t86)
  call heltable([4,8,32], n87, t87)
  call heltable([4,8,32], n88, t88)
  call heltable([8,4,32], n89, t89)
  call heltable([8,4,32], n90, t90)
  call heltable([8,4,32], n91, t91)
  call heltable([4,8,32], n92, t92)
  call heltable([8,4,32], n93, t93)
  call heltable([4,8,32], n94, t94)
  call heltable([4,8,32], n95, t95)
  call heltable([8,4,32], n96, t96)
  call heltable([4,8,32], n97, t97)
  call heltable([4,8,32], n98, t98)
  call heltable([4,8,32], n99, t99)
  call heltable([4,8,32], n100, t100)
  call heltable([4,8,32], n101, t101)
  call heltable([4,8,32], n102, t102)
  call heltable([4,8,32], n103, t103)
  call heltable([4,8,32], n104, t104)
  call heltable([4,8,32], n105, t105)
  call heltable([4,8,32], n106, t106)
  call heltable([4,8,32], n107, t107)
  call heltable([4,8,32], n108, t108)
  call heltable([8,4,32], n109, t109)
  call heltable([4,8,32], n110, t110)
  call heltable([4,8,32], n111, t111)
  call heltable([8,4,32], n112, t112)
  call heltable([4,8,32], n113, t113)
  call heltable([4,8,32], n114, t114)
  call heltable([4,8,32], n115, t115)
  call heltable([4,8,32], n116, t116)
  call heltable([4,8,32], n117, t117)
  call heltable([4,8,32], n118, t118)
  call heltable([4,8,32], n119, t119)
  call heltable([4,8,32], n120, t120)
  call heltable([4,8,32], n121, t121)
  call heltable([8,4,32], n122, t122)
  call heltable([8,4,32], n123, t123)
  call heltable([8,4,32], n124, t124)
  call heltable([8,4,32], n125, t125)
  call heltable([8,4,32], n126, t126)
  call heltable([8,4,32], n127, t127)
  call heltable([8,4,32], n128, t128)
  call heltable([8,4,32], n129, t129)
  call heltable([8,4,32], n130, t130)
  call heltable([8,4,32], n131, t131)
  call heltable([8,4,32], n132, t132)
  call heltable([8,4,32], n133, t133)
  call heltable([8,4,32], n134, t134)
  call heltable([8,4,32], n135, t135)
  call heltable([8,4,32], n136, t136)
  call heltable([8,4,32], n137, t137)
  call heltable([8,4,32], n138, t138)
  call heltable([8,4,32], n139, t139)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pphttj_ttxhggg_1
