
! **********************************************************************
module ol_heltables_pphttj_ttxddxhg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(1) = [0], &
    H6(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n11, n14, n15, n20, n24, n27

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n6, n7, n8, n9, n10, n12, n13, n16, n17, n18, n19, n21, n22, n23, n25, n26, n28, n29, n30, n31, n32, n33, n34, n35 &
  , n36, n37, n38, n39, n40


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,2) :: &
  t1, t13

  integer(intkind2), save, dimension(2,8) :: &
  t6, t8, t9, t16, t18, t25, t28

  integer(intkind2), save, dimension(2,4) :: &
  t2, t3, t7, t10, t12, t17, t19, t21, t22, t23, t26

  integer(intkind2), save, dimension(2,32) :: &
  t29, t30, t31, t32, t33, t34, t35, t36, t37, t38, t39, t40


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(32,6)
  integer,           save :: exthel(32,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,1,2], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 2
  n5 = 4
  call heltable([2,4,8], n6, t6)
  call heltable([2,2,4], n7, t7)
  call heltable([4,2,8], n8, t8)
  call heltable([2,4,8], n9, t9)
  call heltable([2,2,4], n10, t10)
  n11 = 8
  call heltable([2,2,4], n12, t12)
  call heltable([1,2,2], n13, t13)
  n14 = 4
  n15 = 2
  call heltable([4,2,8], n16, t16)
  call heltable([2,2,4], n17, t17)
  call heltable([4,2,8], n18, t18)
  call heltable([2,2,4], n19, t19)
  n20 = 8
  call heltable([4,1,4], n21, t21)
  call heltable([1,4,4], n22, t22)
  call heltable([2,2,4], n23, t23)
  n24 = 4
  call heltable([4,2,8], n25, t25)
  call heltable([2,2,4], n26, t26)
  n27 = 4
  call heltable([2,4,8], n28, t28)
  call heltable([4,8,32], n29, t29)
  call heltable([4,8,32], n30, t30)
  call heltable([4,8,32], n31, t31)
  call heltable([4,8,32], n32, t32)
  call heltable([8,4,32], n33, t33)
  call heltable([4,8,32], n34, t34)
  call heltable([8,4,32], n35, t35)
  call heltable([8,4,32], n36, t36)
  call heltable([4,8,32], n37, t37)
  call heltable([4,8,32], n38, t38)
  call heltable([4,8,32], n39, t39)
  call heltable([4,8,32], n40, t40)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pphttj_ttxddxhg_1
