
! **********************************************************************
module ol_heltables_pphttj_ttxbbxhg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(1) = [0], &
    H6(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n9, n14, n15, n19, n26, n27, n33, n36, n37, n42

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n6, n7, n8, n10, n11, n12, n13, n16, n17, n18, n20, n21, n22, n23, n24, n25, n28, n29, n30, n31, n32, n34, n35, n38 &
  , n39, n40, n41, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57, n58, n59, n60, n61, n62, n63, n64 &
  , n65, n66, n67, n68, n69, n70, n71, n72


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,16) :: &
  t16

  integer(intkind2), save, dimension(2,2) :: &
  t2, t13, t23, t35

  integer(intkind2), save, dimension(2,8) :: &
  t6, t7, t11, t17, t28, t30, t31, t38, t40, t45, t46, t47, t48

  integer(intkind2), save, dimension(2,4) :: &
  t1, t3, t8, t10, t12, t18, t20, t21, t22, t24, t25, t29, t32, t34, t39, t41, t43, t44

  integer(intkind2), save, dimension(2,32) :: &
  t49, t50, t51, t52, t53, t54, t55, t56, t57, t58, t59, t60, t61, t62, t63, t64, t65, t66, t67, t68, t69, t70, t71, t72


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(32,6)
  integer,           save :: exthel(32,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,1,2], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 2
  n5 = 4
  call heltable([4,2,8], n6, t6)
  call heltable([2,4,8], n7, t7)
  call heltable([2,2,4], n8, t8)
  n9 = 8
  call heltable([2,2,4], n10, t10)
  call heltable([4,2,8], n11, t11)
  call heltable([2,2,4], n12, t12)
  call heltable([1,2,2], n13, t13)
  n14 = 4
  n15 = 2
  call heltable([4,4,16], n16, t16)
  call heltable([4,2,8], n17, t17)
  call heltable([2,2,4], n18, t18)
  n19 = 8
  call heltable([2,2,4], n20, t20)
  call heltable([4,1,4], n21, t21)
  call heltable([1,4,4], n22, t22)
  call heltable([2,1,2], n23, t23)
  call heltable([2,2,4], n24, t24)
  call heltable([2,2,4], n25, t25)
  n26 = 2
  n27 = 4
  call heltable([2,4,8], n28, t28)
  call heltable([2,2,4], n29, t29)
  call heltable([4,2,8], n30, t30)
  call heltable([2,4,8], n31, t31)
  call heltable([2,2,4], n32, t32)
  n33 = 8
  call heltable([2,2,4], n34, t34)
  call heltable([1,2,2], n35, t35)
  n36 = 4
  n37 = 2
  call heltable([4,2,8], n38, t38)
  call heltable([2,2,4], n39, t39)
  call heltable([4,2,8], n40, t40)
  call heltable([2,2,4], n41, t41)
  n42 = 8
  call heltable([4,1,4], n43, t43)
  call heltable([1,4,4], n44, t44)
  call heltable([4,2,8], n45, t45)
  call heltable([2,4,8], n46, t46)
  call heltable([4,2,8], n47, t47)
  call heltable([2,4,8], n48, t48)
  call heltable([4,8,32], n49, t49)
  call heltable([4,8,32], n50, t50)
  call heltable([4,8,32], n51, t51)
  call heltable([2,16,32], n52, t52)
  call heltable([4,8,32], n53, t53)
  call heltable([8,4,32], n54, t54)
  call heltable([8,4,32], n55, t55)
  call heltable([8,4,32], n56, t56)
  call heltable([4,8,32], n57, t57)
  call heltable([4,8,32], n58, t58)
  call heltable([4,8,32], n59, t59)
  call heltable([4,8,32], n60, t60)
  call heltable([8,4,32], n61, t61)
  call heltable([4,8,32], n62, t62)
  call heltable([8,4,32], n63, t63)
  call heltable([8,4,32], n64, t64)
  call heltable([4,8,32], n65, t65)
  call heltable([4,8,32], n66, t66)
  call heltable([4,8,32], n67, t67)
  call heltable([4,8,32], n68, t68)
  call heltable([4,8,32], n69, t69)
  call heltable([4,8,32], n70, t70)
  call heltable([4,8,32], n71, t71)
  call heltable([4,8,32], n72, t72)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pphttj_ttxbbxhg_1
