
module ol_tree_pphttj_ttxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(2)
  complex(REALKIND), save :: den(105)

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f(2) = (eQED*gQCD**3*MT)/(MW*sw*2._/**/REALKIND)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

    den(1) = 1 / (Q(5,5) - MT2)
    den(2) = 1 / (Q(5,56))
    den(4) = 1 / (Q(5,6) - MT2)
    den(6) = 1 / (Q(5,10) - MT2)
    den(7) = 1 / (Q(5,48))
    den(10) = 1 / (Q(5,21) - MT2)
    den(13) = 1 / (Q(5,26) - MT2)
    den(16) = 1 / (Q(5,18) - MT2)
    den(17) = 1 / (Q(5,40))
    den(20) = 1 / (Q(5,13) - MT2)
    den(25) = 1 / (Q(5,34) - MT2)
    den(26) = 1 / (Q(5,24))
    den(29) = 1 / (Q(5,7))
    den(35) = 1 / (Q(5,42) - MT2)
    den(42) = 1 / (Q(5,50) - MT2)
    den(45) = 1 / (Q(5,9) - MT2)
    den(48) = 1 / (Q(5,25) - MT2)
    den(51) = 1 / (Q(5,22) - MT2)
    den(54) = 1 / (Q(5,17) - MT2)
    den(59) = 1 / (Q(5,14) - MT2)
    den(62) = 1 / (Q(5,33) - MT2)
    den(69) = 1 / (Q(5,41) - MT2)
    den(77) = 1 / (Q(5,49) - MT2)
    den(85) = 1 / (Q(5,38) - MT2)
    den(93) = 1 / (Q(5,37) - MT2)

  ! denominators

    den(3) = den(1)*den(2)
    den(5) = den(2)*den(4)
    den(8) = den(1)*den(6)
    den(9) = den(7)*den(8)
    den(11) = den(1)*den(10)
    den(12) = den(6)*den(11)
    den(14) = den(6)*den(13)
    den(15) = den(1)*den(14)
    den(18) = den(1)*den(16)
    den(19) = den(17)*den(18)
    den(21) = den(1)*den(20)
    den(22) = den(16)*den(21)
    den(23) = den(13)*den(16)
    den(24) = den(1)*den(23)
    den(27) = den(1)*den(25)
    den(28) = den(26)*den(27)
    den(30) = den(1)*den(29)
    den(31) = den(26)*den(30)
    den(32) = den(13)*den(26)
    den(33) = den(1)*den(32)
    den(34) = den(21)*den(25)
    den(36) = den(25)*den(35)
    den(37) = den(1)*den(36)
    den(38) = den(17)*den(30)
    den(39) = den(17)*den(35)
    den(40) = den(1)*den(39)
    den(41) = den(7)*den(30)
    den(43) = den(7)*den(42)
    den(44) = den(1)*den(43)
    den(46) = den(4)*den(45)
    den(47) = den(7)*den(46)
    den(49) = den(45)*den(48)
    den(50) = den(4)*den(49)
    den(52) = den(4)*den(51)
    den(53) = den(45)*den(52)
    den(55) = den(4)*den(54)
    den(56) = den(17)*den(55)
    den(57) = den(48)*den(54)
    den(58) = den(4)*den(57)
    den(60) = den(4)*den(59)
    den(61) = den(54)*den(60)
    den(63) = den(4)*den(62)
    den(64) = den(26)*den(63)
    den(65) = den(4)*den(29)
    den(66) = den(26)*den(65)
    den(67) = den(26)*den(48)
    den(68) = den(4)*den(67)
    den(70) = den(62)*den(69)
    den(71) = den(4)*den(70)
    den(72) = den(60)*den(62)
    den(73) = den(17)*den(65)
    den(74) = den(17)*den(69)
    den(75) = den(4)*den(74)
    den(76) = den(7)*den(65)
    den(78) = den(7)*den(77)
    den(79) = den(4)*den(78)
    den(80) = den(20)*den(45)
    den(81) = den(16)*den(80)
    den(82) = den(16)*den(51)
    den(83) = den(45)*den(82)
    den(84) = den(25)*den(80)
    den(86) = den(25)*den(85)
    den(87) = den(45)*den(86)
    den(88) = den(43)*den(45)
    den(89) = den(10)*den(54)
    den(90) = den(6)*den(89)
    den(91) = den(6)*den(59)
    den(92) = den(54)*den(91)
    den(94) = den(62)*den(93)
    den(95) = den(6)*den(94)
    den(96) = den(62)*den(91)
    den(97) = den(6)*den(78)
    den(98) = den(25)*den(89)
    den(99) = den(54)*den(86)
    den(100) = den(39)*den(54)
    den(101) = den(16)*den(94)
    den(102) = den(62)*den(82)
    den(103) = den(16)*den(74)
    den(104) = den(32)*den(62)
    den(105) = den(25)*den(67)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs) &
    & bind(c,name="ol_f_amp2_pphttj_ttxhggg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top higgs glue glue glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_pphttj_ttxhggg_1, only: external_perm_pphttj_ttxhggg_1, &
    & external_perm_inv_pphttj_ttxhggg_1, extcomb_perm_pphttj_ttxhggg_1, &
    & average_factor_pphttj_ttxhggg_1
  use ol_external_pphttj_ttxhggg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphttj_ttxhggg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_pphttj_ttxhggg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,6)
  real(REALKIND)    :: extmasses2(6)
  real(REALKIND)    :: M2add(0:23-1)
  complex(REALKIND) :: MOM_LC(4), M1(6), M1helarray(6,32)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(1), ex4(2), ex5(2), ex6(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(2) :: &
    wf1, wf3, wf7, wf8

  type(wfun), dimension(4) :: &
    wf4, wf9, wf10, wf11, wf12, wf14, wf16, wf18, wf20, wf21, wf22, wf24, wf26, wf29, wf30, wf31, wf45, wf46, wf49, wf51, wf53 &
  , wf54, wf55, wf59, wf61, wf62, wf63, wf74, wf75, wf76, wf77, wf78, wf79, wf80, wf81, wf82, wf83, wf84, wf85

  type(wfun), dimension(8) :: &
    wf2, wf5, wf6, wf13, wf15, wf17, wf19, wf23, wf25, wf27, wf28, wf32, wf33, wf34, wf35, wf36, wf37, wf38, wf39, wf40, wf41 &
  , wf42, wf43, wf44, wf47, wf48, wf50, wf52, wf56, wf57, wf58, wf60, wf64, wf65, wf66, wf67, wf68, wf69, wf70, wf71, wf72, wf73

  type(wfun), dimension(32) :: &
    wf86, wf87, wf88, wf89, wf90, wf91, wf92, wf93, wf94, wf95, wf96, wf97, wf98, wf99, wf100, wf101, wf102, wf103, wf104, wf105 &
  , wf106, wf107, wf108, wf109, wf110, wf111, wf112, wf113, wf114, wf115, wf116, wf117, wf118, wf119, wf120, wf121, wf122, wf123 &
  , wf124, wf125, wf126, wf127, wf128, wf129, wf130, wf131, wf132, wf133, wf134, wf135, wf136, wf137, wf138, wf139


  type(polcont) :: A(32,54)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rMT2, rMT2, rMH2, rZERO2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_pphttj_ttxhggg_1,6)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,6)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_pphttj_ttxhggg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pphttj_ttxhggg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  ! external WFs
  call wf_Q(P(:,1), rMT, H1, ex1)
  call wf_A(P(:,2), rMT, H2, ex2)
  call wf_S(P(:,3), rMH, H3, ex3)
  call wf_V(P(:,4), rZERO, H4, ex4)
  call wf_V(P(:,5), rZERO, H5, ex5)
  call wf_V(P(:,6), rZERO, H6, ex6)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...
    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QS_A(gH,ntry, ex1, ex3, wf1, n1, t1)
  call vert_GGG_G(ntry, ex4, ex5, ex6, wf2, n2, t2)
  call prop_Q_A(ntry, wf1, Q(:,5), MT, 1_intkind1, wf3, n3)
  call vert_QA_V(ntry, wf3, ex2, wf4, n4, t4)
  call vert_GGG_G(ntry, ex5, ex6, ex4, wf5, n5, t5)
  call vert_GGG_G(ntry, ex6, ex4, ex5, wf6, n6, t6)
  call vert_SA_Q(gH,ntry, ex3, ex2, wf7, n7, t7)
  call prop_A_Q(ntry, wf7, Q(:,6), MT, 1_intkind1, wf8, n8)
  call vert_QA_V(ntry, ex1, wf8, wf9, n9, t9)
  call vert_AV_Q(ntry, ex2, ex4, wf10, n10, t10)
  call vert_UV_W(ntry, ex5, Q(:,16), ex6, Q(:,32), wf11, n11, t11)
  call prop_A_Q(ntry, wf10, Q(:,10), MT, 1_intkind1, wf12, n12)
  call vert_QA_V(ntry, wf3, wf12, wf13, n13, t13)
  call vert_VQ_A(ntry, ex5, wf3, wf14, n14, t14)
  call vert_AV_Q(ntry, wf12, ex6, wf15, n15, t15)
  call prop_Q_A(ntry, wf14, Q(:,21), MT, 1_intkind1, wf16, n16)
  call vert_AV_Q(ntry, wf12, ex5, wf17, n17, t17)
  call vert_VQ_A(ntry, ex6, wf3, wf18, n18, t18)
  call prop_A_Q(ntry, wf17, Q(:,26), MT, 1_intkind1, wf19, n19)
  call vert_AV_Q(ntry, ex2, ex5, wf20, n20, t20)
  call vert_UV_W(ntry, ex4, Q(:,8), ex6, Q(:,32), wf21, n21, t21)
  call prop_A_Q(ntry, wf20, Q(:,18), MT, 1_intkind1, wf22, n22)
  call vert_QA_V(ntry, wf3, wf22, wf23, n23, t23)
  call vert_VQ_A(ntry, ex4, wf3, wf24, n24, t24)
  call vert_AV_Q(ntry, wf22, ex6, wf25, n25, t25)
  call prop_Q_A(ntry, wf24, Q(:,13), MT, 1_intkind1, wf26, n26)
  call vert_AV_Q(ntry, wf22, ex4, wf27, n27, t27)
  call prop_A_Q(ntry, wf27, Q(:,26), MT, 1_intkind1, wf28, n28)
  call vert_AV_Q(ntry, ex2, ex6, wf29, n29, t29)
  call vert_UV_W(ntry, ex4, Q(:,8), ex5, Q(:,16), wf30, n30, t30)
  call prop_A_Q(ntry, wf29, Q(:,34), MT, 1_intkind1, wf31, n31)
  call vert_QA_V(ntry, wf3, wf31, wf32, n32, t32)
  call vert_UV_W(ntry, wf30, Q(:,24), ex6, Q(:,32), wf33, n33, t33)
  call vert_AV_Q(ntry, ex2, wf30, wf34, n34, t34)
  call prop_A_Q(ntry, wf34, Q(:,26), MT, 1_intkind1, wf35, n35)
  call vert_AV_Q(ntry, wf31, ex5, wf36, n36, t36)
  call vert_AV_Q(ntry, wf31, ex4, wf37, n37, t37)
  call prop_A_Q(ntry, wf37, Q(:,42), MT, 1_intkind1, wf38, n38)
  call vert_UV_W(ntry, ex5, Q(:,16), wf21, Q(:,40), wf39, n39, t39)
  call vert_AV_Q(ntry, ex2, wf21, wf40, n40, t40)
  call prop_A_Q(ntry, wf40, Q(:,42), MT, 1_intkind1, wf41, n41)
  call vert_UV_W(ntry, ex4, Q(:,8), wf11, Q(:,48), wf42, n42, t42)
  call vert_AV_Q(ntry, ex2, wf11, wf43, n43, t43)
  call prop_A_Q(ntry, wf43, Q(:,50), MT, 1_intkind1, wf44, n44)
  call vert_VQ_A(ntry, ex4, ex1, wf45, n45, t45)
  call prop_Q_A(ntry, wf45, Q(:,9), MT, 1_intkind1, wf46, n46)
  call vert_QA_V(ntry, wf46, wf8, wf47, n47, t47)
  call vert_VQ_A(ntry, ex5, wf46, wf48, n48, t48)
  call vert_AV_Q(ntry, wf8, ex6, wf49, n49, t49)
  call prop_Q_A(ntry, wf48, Q(:,25), MT, 1_intkind1, wf50, n50)
  call vert_AV_Q(ntry, wf8, ex5, wf51, n51, t51)
  call vert_VQ_A(ntry, ex6, wf46, wf52, n52, t52)
  call prop_A_Q(ntry, wf51, Q(:,22), MT, 1_intkind1, wf53, n53)
  call vert_VQ_A(ntry, ex5, ex1, wf54, n54, t54)
  call prop_Q_A(ntry, wf54, Q(:,17), MT, 1_intkind1, wf55, n55)
  call vert_QA_V(ntry, wf55, wf8, wf56, n56, t56)
  call vert_VQ_A(ntry, ex4, wf55, wf57, n57, t57)
  call prop_Q_A(ntry, wf57, Q(:,25), MT, 1_intkind1, wf58, n58)
  call vert_AV_Q(ntry, wf8, ex4, wf59, n59, t59)
  call vert_VQ_A(ntry, ex6, wf55, wf60, n60, t60)
  call prop_A_Q(ntry, wf59, Q(:,14), MT, 1_intkind1, wf61, n61)
  call vert_VQ_A(ntry, ex6, ex1, wf62, n62, t62)
  call prop_Q_A(ntry, wf62, Q(:,33), MT, 1_intkind1, wf63, n63)
  call vert_QA_V(ntry, wf63, wf8, wf64, n64, t64)
  call vert_VQ_A(ntry, wf30, ex1, wf65, n65, t65)
  call prop_Q_A(ntry, wf65, Q(:,25), MT, 1_intkind1, wf66, n66)
  call vert_VQ_A(ntry, ex4, wf63, wf67, n67, t67)
  call prop_Q_A(ntry, wf67, Q(:,41), MT, 1_intkind1, wf68, n68)
  call vert_VQ_A(ntry, ex5, wf63, wf69, n69, t69)
  call vert_VQ_A(ntry, wf21, ex1, wf70, n70, t70)
  call prop_Q_A(ntry, wf70, Q(:,41), MT, 1_intkind1, wf71, n71)
  call vert_VQ_A(ntry, wf11, ex1, wf72, n72, t72)
  call prop_Q_A(ntry, wf72, Q(:,49), MT, 1_intkind1, wf73, n73)
  call vert_QS_A(gH,ntry, wf46, ex3, wf74, n74, t74)
  call prop_Q_A(ntry, wf74, Q(:,13), MT, 1_intkind1, wf75, n75)
  call vert_SA_Q(gH,ntry, ex3, wf22, wf76, n76, t76)
  call prop_A_Q(ntry, wf76, Q(:,22), MT, 1_intkind1, wf77, n77)
  call vert_SA_Q(gH,ntry, ex3, wf31, wf78, n78, t78)
  call prop_A_Q(ntry, wf78, Q(:,38), MT, 1_intkind1, wf79, n79)
  call vert_QS_A(gH,ntry, wf55, ex3, wf80, n80, t80)
  call prop_Q_A(ntry, wf80, Q(:,21), MT, 1_intkind1, wf81, n81)
  call vert_SA_Q(gH,ntry, ex3, wf12, wf82, n82, t82)
  call prop_A_Q(ntry, wf82, Q(:,14), MT, 1_intkind1, wf83, n83)
  call vert_QS_A(gH,ntry, wf63, ex3, wf84, n84, t84)
  call prop_Q_A(ntry, wf84, Q(:,37), MT, 1_intkind1, wf85, n85)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf2, wf4, A(:,1), n86, t86, nhel, den(3))
    call cont_VV(nsync, wf4, wf5, A(:,2), n87, t87, nhel, den(3))
    call cont_VV(nsync, wf4, wf6, A(:,3), n88, t88, nhel, den(3))
    call cont_VV(nsync, wf2, wf9, A(:,4), n89, t89, nhel, den(5))
    call cont_VV(nsync, wf5, wf9, A(:,5), n90, t90, nhel, den(5))
    call cont_VV(nsync, wf6, wf9, A(:,6), n91, t91, nhel, den(5))
    call cont_VV(nsync, wf11, wf13, A(:,7), n92, t92, nhel, den(9))
    call cont_QA(nsync, wf15, wf16, A(:,8), n93, t93, nhel, den(12))
    call cont_QA(nsync, wf18, wf19, A(:,9), n94, t94, nhel, den(15))
    call cont_VV(nsync, wf21, wf23, A(:,10), n95, t95, nhel, den(19))
    call cont_QA(nsync, wf25, wf26, A(:,11), n96, t96, nhel, den(22))
    call cont_QA(nsync, wf18, wf28, A(:,12), n97, t97, nhel, den(24))
    call cont_VV(nsync, wf30, wf32, A(:,13), n98, t98, nhel, den(28))
    call cont_VV(nsync, wf4, wf33, A(:,14), n99, t99, nhel, den(31))
    call cont_QA(nsync, wf18, wf35, A(:,15), n100, t100, nhel, den(33))
    call cont_QA(nsync, wf26, wf36, A(:,16), n101, t101, nhel, den(34))
    call cont_QA(nsync, wf14, wf38, A(:,17), n102, t102, nhel, den(37))
    call cont_VV(nsync, wf4, wf39, A(:,18), n103, t103, nhel, den(38))
    call cont_QA(nsync, wf14, wf41, A(:,19), n104, t104, nhel, den(40))
    call cont_VV(nsync, wf4, wf42, A(:,20), n105, t105, nhel, den(41))
    call cont_QA(nsync, wf24, wf44, A(:,21), n106, t106, nhel, den(44))
    call cont_VV(nsync, wf11, wf47, A(:,22), n107, t107, nhel, den(47))
    call cont_QA(nsync, wf49, wf50, A(:,23), n108, t108, nhel, den(50))
    call cont_QA(nsync, wf52, wf53, A(:,24), n109, t109, nhel, den(53))
    call cont_VV(nsync, wf21, wf56, A(:,25), n110, t110, nhel, den(56))
    call cont_QA(nsync, wf49, wf58, A(:,26), n111, t111, nhel, den(58))
    call cont_QA(nsync, wf60, wf61, A(:,27), n112, t112, nhel, den(61))
    call cont_VV(nsync, wf30, wf64, A(:,28), n113, t113, nhel, den(64))
    call cont_VV(nsync, wf9, wf33, A(:,29), n114, t114, nhel, den(66))
    call cont_QA(nsync, wf49, wf66, A(:,30), n115, t115, nhel, den(68))
    call cont_QA(nsync, wf51, wf68, A(:,31), n116, t116, nhel, den(71))
    call cont_QA(nsync, wf61, wf69, A(:,32), n117, t117, nhel, den(72))
    call cont_VV(nsync, wf9, wf39, A(:,33), n118, t118, nhel, den(73))
    call cont_QA(nsync, wf51, wf71, A(:,34), n119, t119, nhel, den(75))
    call cont_VV(nsync, wf9, wf42, A(:,35), n120, t120, nhel, den(76))
    call cont_QA(nsync, wf59, wf73, A(:,36), n121, t121, nhel, den(79))
    call cont_QA(nsync, wf25, wf75, A(:,37), n122, t122, nhel, den(81))
    call cont_QA(nsync, wf52, wf77, A(:,38), n123, t123, nhel, den(83))
    call cont_QA(nsync, wf36, wf75, A(:,39), n124, t124, nhel, den(84))
    call cont_QA(nsync, wf48, wf79, A(:,40), n125, t125, nhel, den(87))
    call cont_QA(nsync, wf44, wf74, A(:,41), n126, t126, nhel, den(88))
    call cont_QA(nsync, wf15, wf81, A(:,42), n127, t127, nhel, den(90))
    call cont_QA(nsync, wf60, wf83, A(:,43), n128, t128, nhel, den(92))
    call cont_QA(nsync, wf17, wf85, A(:,44), n129, t129, nhel, den(95))
    call cont_QA(nsync, wf69, wf83, A(:,45), n130, t130, nhel, den(96))
    call cont_QA(nsync, wf73, wf82, A(:,46), n131, t131, nhel, den(97))
    call cont_QA(nsync, wf37, wf81, A(:,47), n132, t132, nhel, den(98))
    call cont_QA(nsync, wf57, wf79, A(:,48), n133, t133, nhel, den(99))
    call cont_QA(nsync, wf41, wf80, A(:,49), n134, t134, nhel, den(100))
    call cont_QA(nsync, wf27, wf85, A(:,50), n135, t135, nhel, den(101))
    call cont_QA(nsync, wf67, wf77, A(:,51), n136, t136, nhel, den(102))
    call cont_QA(nsync, wf71, wf76, A(:,52), n137, t137, nhel, den(103))
    call cont_QA(nsync, wf35, wf84, A(:,53), n138, t138, nhel, den(104))
    call cont_QA(nsync, wf66, wf78, A(:,54), n139, t139, nhel, den(105))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pphttj_ttxhggg_1

  do k = 0, 23-1
    M2(k) = M2add(extcomb_perm_pphttj_ttxhggg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*6-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(32,54)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(6) ! M1helarray(6,32)

  M1(1) = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,9)%j+A(j,14)%j+A(j,20)%j+A(j,29)%j+A(j,32)%j+A(j,35)%j+A(j,44)%j &
       +A(j,45)%j)*f(1)+CI*(A(j,7)%j+A(j,15)%j+A(j,28)%j+A(j,36)%j+A(j,46)%j+A(j,53)%j)*f(2)
  M1(2) = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,8)%j-A(j,18)%j-A(j,20)%j+A(j,27)%j-A(j,33)%j-A(j,35)%j+A(j,42)%j &
       +A(j,43)%j)*f(1)+CI*(-A(j,7)%j+A(j,19)%j+A(j,25)%j-A(j,36)%j-A(j,46)%j+A(j,49)%j)*f(2)
  M1(3) = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j+A(j,12)%j-A(j,14)%j+A(j,18)%j-A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,50)%j &
       +A(j,51)%j)*f(1)+CI*(A(j,10)%j-A(j,15)%j-A(j,28)%j+A(j,34)%j+A(j,52)%j-A(j,53)%j)*f(2)
  M1(4) = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,11)%j-A(j,18)%j-A(j,20)%j+A(j,24)%j-A(j,33)%j-A(j,35)%j+A(j,37)%j &
       +A(j,38)%j)*f(1)+CI*(-A(j,10)%j+A(j,21)%j+A(j,22)%j-A(j,34)%j+A(j,41)%j-A(j,52)%j)*f(2)
  M1(5) = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j-A(j,14)%j+A(j,17)%j+A(j,18)%j+A(j,26)%j-A(j,29)%j+A(j,33)%j+A(j,47)%j &
       +A(j,48)%j)*f(1)+CI*(A(j,13)%j-A(j,19)%j-A(j,25)%j+A(j,30)%j-A(j,49)%j+A(j,54)%j)*f(2)
  M1(6) = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,14)%j+A(j,16)%j+A(j,20)%j+A(j,23)%j+A(j,29)%j+A(j,35)%j+A(j,39)%j &
       +A(j,40)%j)*f(1)+CI*(-A(j,13)%j-A(j,21)%j-A(j,22)%j-A(j,30)%j-A(j,41)%j-A(j,54)%j)*f(2)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 6*extcomb
    do i = 1, 6
      do j = 1, 6
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_pphttj_ttxhggg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:23-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_pphttj_ttxhggg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_pphttj_ttxhggg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    23, [ (k, k = 0, 23-1) ])
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_pphttj_ttxhggg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_pphttj_ttxhggg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(6)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:23-1)
  integer        :: J, extcombs(6)
  do J = 1, 6
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 6, extcombs)
  do J = 1, 6
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_pphttj_ttxhggg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_pphttj_ttxhggg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_pphttj_ttxhggg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_pphttj_ttxhggg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_pphttj_ttxhggg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c



! Only for compatibility with the old interface
subroutine amp2tree_legacy(p, m2) &
    & bind(c,name="amp2tree_pphttj_ttxhggg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_legacy

subroutine amp2ccone_legacy(p, m2, i, j) &
    & bind(c,name="amp2ccone_pphttj_ttxhggg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_legacy

subroutine amp2ccall_legacy(p, m2) &
    & bind(c,name="amp2ccall_pphttj_ttxhggg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_legacy

subroutine amp2hcone_legacy(p, m2, i, j, mom) &
    & bind(c,name="amp2hcone_pphttj_ttxhggg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_legacy

subroutine amp2hcall_legacy(p, m2, i, mom) &
    & bind(c,name="amp2hcall_pphttj_ttxhggg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_legacy

#endif

end module ol_tree_pphttj_ttxhggg_1_/**/REALKIND
