
module ol_vamp_1_pphtt_ttxddxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ttxddxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ttxddxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphtt_ttxddxh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphtt_ttxddxh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,18) :: G0
  complex(REALKIND), dimension(4,5,4,53) :: G1
  complex(REALKIND), dimension(4,15,4,32) :: G2
  complex(REALKIND), dimension(4,35,4,5) :: G3
  complex(REALKIND), dimension(5,2) :: G1tensor
  complex(REALKIND), dimension(15,24) :: G2tensor
  complex(REALKIND), dimension(35,9) :: G3tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,8),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_QS_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4),gH)
  call loop_Q_A(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,8),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),MT,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,5))
  call loop_AS_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,28),MB,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,8),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MB,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,8),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MB,G3tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,17),MT,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,29),MT,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,9),wf(:,21),G1tensor(:,1))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,11))
  call loop_VQ_A(G1(:,:,:,11),wf(:,3),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,29),MT,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,-1),G2tensor(:,2))
  call loop_VA_Q(G1(:,:,:,11),wf(:,6),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,30),MT,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,0),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,11),wf(:,-1),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,14),MT,G2(:,:,:,12))
  call loop_AS_Q(G2(:,:,:,12),wf(:,-4),G2(:,:,:,13),gH)
  call loop_A_Q(G2(:,:,:,13),Q(:,30),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,18),MT,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,2),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,30),MT,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,15),wf(:,25),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,13),MT,G1(:,:,:,17))
  call loop_QS_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,18),gH)
  call loop_Q_A(G1(:,:,:,18),Q(:,29),MT,G2(:,:,:,15))
  call check_last_QA_V(l_switch,G2(:,:,:,15),wf(:,-1),G2tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,14),MT,G1(:,:,:,19))
  call loop_AS_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20),gH)
  call loop_A_Q(G1(:,:,:,20),Q(:,30),MT,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,6))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,2),MT,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,2),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,14),MT,G2(:,:,:,17))
  call loop_AS_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18),gH)
  call loop_A_Q(G2(:,:,:,18),Q(:,30),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,6))
  call loop_AS_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23),gH)
  call loop_A_Q(G1(:,:,:,23),Q(:,18),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,2),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,30),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),ZERO,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,4),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,27),ZERO,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,-2),G2tensor(:,7))
  call loop_AQ_V(G1(:,:,:,24),wf(:,-2),G1(:,:,:,26))
  call loop_VQ_A(G1(:,:,:,26),wf(:,3),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,29),MT,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,26),wf(:,6),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,30),MT,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,0),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-1),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,14),MT,G2(:,:,:,24))
  call loop_AS_Q(G2(:,:,:,24),wf(:,-4),G2(:,:,:,25),gH)
  call loop_A_Q(G2(:,:,:,25),Q(:,30),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,24),wf(:,7),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,27),ZERO,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-2),G2tensor(:,10))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,19),G1(:,:,:,31))
  call loop_VA_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,27),ZERO,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,-2),G2tensor(:,11))
  call check_last_UV_W(l_switch,G1(:,:,:,31),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,4),ZERO,G1(:,:,:,33))
  call loop_QA_V(G1(:,:,:,33),wf(:,-3),G1(:,:,:,34))
  call loop_VQ_A(G1(:,:,:,34),wf(:,3),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,29),MT,G2(:,:,:,28))
  call check_last_QA_V(l_switch,G2(:,:,:,28),wf(:,-1),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,34),wf(:,6),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,30),MT,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,14))
  call loop_VA_Q(G1(:,:,:,34),wf(:,-1),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,14),MT,G2(:,:,:,30))
  call loop_AS_Q(G2(:,:,:,30),wf(:,-4),G2(:,:,:,31),gH)
  call loop_A_Q(G2(:,:,:,31),Q(:,30),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,9))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,19),G1(:,:,:,38))
  call loop_VA_Q(G1(:,:,:,38),wf(:,-3),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,27),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,-2),G2tensor(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,38),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,19),ZERO,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,2),G1(:,:,:,41))
  call check_last_Q_A(l_switch,G1(:,:,:,41),Q(:,31),ZERO,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,19),MT,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,2),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,31),MT,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,19),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,2),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,31),MB,G2tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,19),G1(:,:,:,46))
  call check_last_CV_D(l_switch,G1(:,:,:,46),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,19),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,2),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,31),ZERO,G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,19),MT,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,2),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,31),MT,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,19),MB,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,2),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,31),MB,G2tensor(:,23))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,19),G1(:,:,:,53))
  call check_last_CV_D(l_switch,G1(:,:,:,53),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,24))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(7)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(7)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(5)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(5)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(15)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(9)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(2)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(2)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(2)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(12)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(11)*M(1)+c(5)*M(2)) * den(1)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2)) * den(1)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(17)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(17)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2)) * den(4)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(11)*M(1)+c(5)*M(2)) * den(4)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2))
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(11)*M(1)+c(5)*M(2))
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(13)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(13)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(10)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(18)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(18)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(18)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(17)*M(1))+c(16)*M(2)) * den(18)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(18)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(18)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(16)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)

end subroutine vamp_1

end module ol_vamp_1_pphtt_ttxddxh_1_/**/REALKIND
