
module ol_vamp_1_pphtt_ttxbbxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ttxbbxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ttxbbxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphtt_ttxbbxh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphtt_ttxbbxh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,27) :: G0
  complex(REALKIND), dimension(4,5,4,90) :: G1
  complex(REALKIND), dimension(4,15,4,52) :: G2
  complex(REALKIND), dimension(4,35,4,9) :: G3
  complex(REALKIND), dimension(5,4) :: G1tensor
  complex(REALKIND), dimension(15,48) :: G2tensor
  complex(REALKIND), dimension(35,14) :: G3tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_QS_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4),gH)
  call loop_Q_A(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),MT,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,5))
  call loop_AS_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,28),MB,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MB,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,9),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MB,G3tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,20),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,1),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,23),MB,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-3),G2tensor(:,1))
  call loop_QA_V(G1(:,:,:,9),wf(:,-3),G1(:,:,:,11))
  call loop_VA_Q(G1(:,:,:,11),wf(:,-1),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,30),MT,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,9),wf(:,37),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,8),MB,G1(:,:,:,13))
  call loop_AQ_V(G1(:,:,:,13),wf(:,3),G1(:,:,:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,14),wf(:,-1),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,30),MT,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,0),G2tensor(:,4))
  call loop_AS_Q(G1(:,:,:,13),wf(:,-4),G1(:,:,:,16),gH)
  call loop_A_Q(G1(:,:,:,16),Q(:,24),MB,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,40),G2tensor(:,5))
  call loop_AV_Q(G2(:,:,:,12),wf(:,1),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,27),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-2),G3tensor(:,5))
  call loop_AQ_V(G2(:,:,:,12),wf(:,-2),G2(:,:,:,14))
  call loop_VA_Q(G2(:,:,:,14),wf(:,-1),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,30),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,13),wf(:,1),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,11),MB,G2(:,:,:,16))
  call loop_AS_Q(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17),gH)
  call loop_A_Q(G2(:,:,:,17),Q(:,27),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-2),G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,13),wf(:,11),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,27),MB,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-2),G2tensor(:,6))
  call loop_AQ_V(G1(:,:,:,13),wf(:,-2),G1(:,:,:,19))
  call loop_VQ_A(G1(:,:,:,19),wf(:,10),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,29),MT,G2(:,:,:,19))
  call check_last_QA_V(l_switch,G2(:,:,:,19),wf(:,-1),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,19),wf(:,13),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,30),MT,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,0),G2tensor(:,8))
  call loop_VA_Q(G1(:,:,:,19),wf(:,-1),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,14),MT,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22),gH)
  call loop_A_Q(G2(:,:,:,22),Q(:,30),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,13),wf(:,14),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,27),MB,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,-2),G2tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,24),MB,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,1),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,27),MB,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,-2),G2tensor(:,10))
  call loop_AQ_V(G1(:,:,:,24),wf(:,-2),G1(:,:,:,26))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-1),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,30),MT,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,0),G2tensor(:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,24),wf(:,40),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,4),MB,G1(:,:,:,28))
  call loop_QA_V(G1(:,:,:,28),wf(:,6),G1(:,:,:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,29),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,29),wf(:,-1),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,30),MT,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,0),G2tensor(:,13))
  call loop_QS_A(G1(:,:,:,28),wf(:,-4),G1(:,:,:,31),gH)
  call loop_Q_A(G1(:,:,:,31),Q(:,20),MB,G2(:,:,:,27))
  call loop_QA_V(G2(:,:,:,27),wf(:,-3),G2(:,:,:,28))
  call check_last_UV_W(l_switch,G2(:,:,:,28),Q(:,28),wf(:,1),Q(:,3),G3tensor(:,9))
  call loop_VA_Q(G2(:,:,:,28),wf(:,-1),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,30),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,10))
  call loop_QA_V(G1(:,:,:,28),wf(:,-3),G1(:,:,:,32))
  call loop_VQ_A(G1(:,:,:,32),wf(:,10),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,29),MT,G2(:,:,:,30))
  call check_last_QA_V(l_switch,G2(:,:,:,30),wf(:,-1),G2tensor(:,14))
  call loop_VA_Q(G1(:,:,:,32),wf(:,13),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,30),MT,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,0),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,32),wf(:,-1),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,14),MT,G2(:,:,:,32))
  call loop_AS_Q(G2(:,:,:,32),wf(:,-4),G2(:,:,:,33),gH)
  call loop_A_Q(G2(:,:,:,33),Q(:,30),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,37),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,11),MB,G1(:,:,:,36))
  call loop_AS_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,37),gH)
  call loop_A_Q(G1(:,:,:,37),Q(:,27),MB,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,-2),G2tensor(:,16))
  call loop_VQ_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,17),MT,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,9),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,29),MT,G2(:,:,:,35))
  call check_last_QA_V(l_switch,G2(:,:,:,35),wf(:,-1),G2tensor(:,17))
  call check_last_QA_V(l_switch,G1(:,:,:,38),wf(:,43),G1tensor(:,3))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,9),Q(:,12),G1(:,:,:,40))
  call loop_VQ_A(G1(:,:,:,40),wf(:,10),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,29),MT,G2(:,:,:,36))
  call check_last_QA_V(l_switch,G2(:,:,:,36),wf(:,-1),G2tensor(:,18))
  call loop_VA_Q(G1(:,:,:,40),wf(:,13),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,30),MT,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,0),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,40),wf(:,-1),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,14),MT,G2(:,:,:,38))
  call loop_AS_Q(G2(:,:,:,38),wf(:,-4),G2(:,:,:,39),gH)
  call loop_A_Q(G2(:,:,:,39),Q(:,30),MT,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,13),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,18),MT,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,9),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,30),MT,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,44),wf(:,47),G1tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,13),MT,G1(:,:,:,46))
  call loop_QS_A(G1(:,:,:,46),wf(:,-4),G1(:,:,:,47),gH)
  call loop_Q_A(G1(:,:,:,47),Q(:,29),MT,G2(:,:,:,41))
  call check_last_QA_V(l_switch,G2(:,:,:,41),wf(:,-1),G2tensor(:,21))
  call loop_VA_Q(G0(:,:,:,1),wf(:,43),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,14),MT,G1(:,:,:,48))
  call loop_AS_Q(G1(:,:,:,48),wf(:,-4),G1(:,:,:,49),gH)
  call loop_A_Q(G1(:,:,:,49),Q(:,30),MT,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,22))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,2),MT,G1(:,:,:,50))
  call loop_AV_Q(G1(:,:,:,50),wf(:,9),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,14),MT,G2(:,:,:,43))
  call loop_AS_Q(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44),gH)
  call loop_A_Q(G2(:,:,:,44),Q(:,30),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,13))
  call loop_AS_Q(G1(:,:,:,50),wf(:,-4),G1(:,:,:,52),gH)
  call loop_A_Q(G1(:,:,:,52),Q(:,18),MT,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,9),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,30),MT,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,50),wf(:,34),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,30),MT,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,0),G2tensor(:,23))
  call loop_AV_Q(G1(:,:,:,50),wf(:,38),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,30),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,24))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,19),G1(:,:,:,55))
  call loop_VA_Q(G1(:,:,:,55),wf(:,-3),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,27),MB,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-2),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,55),Q(:,19),wf(:,9),Q(:,12),G2tensor(:,26))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,19),G1(:,:,:,57))
  call loop_VA_Q(G1(:,:,:,57),wf(:,-3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,27),MB,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,-2),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,57),Q(:,19),wf(:,9),Q(:,12),G2tensor(:,28))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,28),G1(:,:,:,59))
  call loop_VA_Q(G1(:,:,:,59),wf(:,-1),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,30),MT,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,0),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,30))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,38),Q(:,28),G1(:,:,:,61))
  call loop_VA_Q(G1(:,:,:,61),wf(:,-1),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,30),MT,G2(:,:,:,52))
  call check_last_AQ_V(l_switch,G2(:,:,:,52),wf(:,0),G2tensor(:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,28),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,1),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,31),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,28),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,1),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,31),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,28),MB,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,1),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,31),MB,G2tensor(:,35))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,34),Q(:,28),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,28),ZERO,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,1),G1(:,:,:,71))
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,31),ZERO,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,28),MT,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,1),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,31),MT,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,28),MB,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,1),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,31),MB,G2tensor(:,39))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,38),Q(:,28),G1(:,:,:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,19),ZERO,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,9),G1(:,:,:,78))
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,31),ZERO,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,19),MT,G1(:,:,:,79))
  call loop_QV_A(G1(:,:,:,79),wf(:,9),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,31),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,19),MB,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,9),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,31),MB,G2tensor(:,43))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,19),G1(:,:,:,83))
  call check_last_CV_D(l_switch,G1(:,:,:,83),Q(:,19),wf(:,9),Q(:,12),G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,19),ZERO,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,9),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,31),ZERO,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,19),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,9),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,31),MT,G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,14),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,19),MB,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,9),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,31),MB,G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,14),Q(:,19),G1(:,:,:,90))
  call check_last_CV_D(l_switch,G1(:,:,:,90),Q(:,19),wf(:,9),Q(:,12),G2tensor(:,48))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(11)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(11)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(11)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(11)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(5)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(5)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(21)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(16)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(2)*M(1))+c(1)*M(2)) * den(1)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(8)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(15)*M(1))+c(14)*M(2)) * den(8)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(10)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(10)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(30)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(24)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(7)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(7)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(7)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(27)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(27)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(24)*M(1)+c(18)*M(2)) * den(6)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(20)*M(1))+c(22)*M(2)) * den(6)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(19)*M(1))+c(18)*M(2)) * den(32)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(15)*M(1)-c(14)*M(2)) * den(32)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(20)*M(1))+c(22)*M(2)) * den(9)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(24)*M(1)+c(18)*M(2)) * den(9)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(13)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(13)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(11)*M(1)+c(5)*M(2)) * den(2)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2)) * den(2)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(6)*M(1))+c(5)*M(2)) * den(18)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(2)*M(1)-c(1)*M(2)) * den(18)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2)) * den(4)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(11)*M(1)+c(5)*M(2)) * den(4)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(7)*M(1))+c(9)*M(2))
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(11)*M(1)+c(5)*M(2))
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(20)*M(1))+c(22)*M(2))
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(24)*M(1)+c(18)*M(2))
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(17)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(14)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(14)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(14)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(14)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(14)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(14)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(12)*M(1)-c(8)*M(2)) * den(22)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(19)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(19)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(30)*M(1))+c(29)*M(2)) * den(19)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(28)*M(1))+c(27)*M(2)) * den(19)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(13)*M(1))+c(10)*M(2)) * den(19)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(4)*M(1)-c(3)*M(2)) * den(19)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(28)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(28)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(28)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(28)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(26)*M(1))+c(23)*M(2)) * den(28)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(28)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(25)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(33)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(33)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(34)*M(1))+c(33)*M(2)) * den(33)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(32)*M(1))+c(31)*M(2)) * den(33)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(26)*M(1))+c(23)*M(2)) * den(33)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(17)*M(1)-c(16)*M(2)) * den(33)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(25)*M(1)-c(21)*M(2)) * den(31)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)

end subroutine vamp_1

end module ol_vamp_1_pphtt_ttxbbxh_1_/**/REALKIND
