
module ol_colourmatrix_pphtt_ttxddxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(34,2), K2(2,2), KL(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,  -4]
  K1( 6,:) = [  -4, -12]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [   0,   4]
  K1(10,:) = [   4,   0]
  K1(11,:) = [ -12,  -4]
  K1(12,:) = [  -4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [ -12,  -4]
  K1(16,:) = [  -4,   0]
  K1(17,:) = [   0,   4]
  K1(18,:) = [   4,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ttxddxh_1_/**/REALKIND



module ol_forced_parameters_pphtt_ttxddxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ttxddxh_1_/**/REALKIND

module ol_loop_pphtt_ttxddxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(12), c(19)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:25)
  ! denominators
  complex(REALKIND), save :: den(18)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(2,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*countertermnorm*ctHGG*eQED*gQCD**4
    f( 2) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 3) = (CI*countertermnorm*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 4) = (CI*countertermnorm*ctGqq*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 5) = (CI*countertermnorm*ctGtt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 6) = (CI*countertermnorm*ctStt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 7) = (CI*eQED*gQCD**4*integralnorm*MT*SwB)/(2._/**/REALKIND*MW*sw)
    f( 8) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*4._/**/REALKIND)
    f( 9) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(10) = (eQED*gQCD**4*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(11) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(12) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw)

  c = [ 9*CI*f(7), 27*CI*f(7), 18*f(8), 54*f(8), f(9), 3*f(9), 6*f(9), 8*f(9), 10*f(9), 18*f(9), 21*f(9), 24*f(9), 54*f(9) &
    , 3*f(10), 9*f(10), 3*f(11), 9*f(11), 3*f(12), 9*f(12) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  complex(REALKIND), intent(out) :: M1(2), M2(2)
  complex(REALKIND) :: A(13)

  ! external WFs

  call wf_Q(P(:,1), rMT, H(1), wf(:,0))
  call wf_A(P(:,2), rMT, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_S(P(:,5), rMH, H(5), wf(:,-4))


  ! internal WFs

  call vert_QS_A(gH,wf(:,0),wf(:,-4),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call prop_Q_A(wf(:,1),Q(:,17),MT,1_intkind1,wf(:,3))
  call vert_QA_V(wf(:,3),wf(:,-1),wf(:,4))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-1),wf(:,5))
  call prop_A_Q(wf(:,5),Q(:,18),MT,1_intkind1,wf(:,6))
  call vert_QA_V(wf(:,0),wf(:,6),wf(:,7))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,8))
  call counter_SG_G(wf(:,-4),wf(:,8),wf(:,9))
  call counter_QA_V(wf(:,-2),wf(:,-3),wf(:,10))
  call counter_QA_V(wf(:,3),wf(:,-1),wf(:,11))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-1),wf(:,12))
  call prop_A_Q(wf(:,12),Q(:,18),MT,1_intkind1,wf(:,13))
  call vert_QA_V(wf(:,0),wf(:,13),wf(:,14))
  call counter_QA_V(wf(:,0),wf(:,6),wf(:,15))
  call counter_QS_A(gH,wf(:,0),wf(:,-4),wf(:,16))
  call prop_Q_A(wf(:,16),Q(:,17),MT,1_intkind1,wf(:,17))
  call vert_QA_V(wf(:,17),wf(:,-1),wf(:,18))
  call vert_AV_Q(wf(:,-1),wf(:,2),wf(:,19))
  call counter_Q_A(cttt,wf(:,3),Q(:,17),wf(:,20))
  call prop_A_Q(wf(:,19),Q(:,14),MT,1_intkind1,wf(:,21))
  call counter_V_V(ctGG,wf(:,2),Q(:,12),wf(:,22))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,23))
  call counter_A_Q(cttt,wf(:,6),Q(:,18),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,13),MT,1_intkind1,wf(:,25))


  ! propagators

    den(1) = 1 / (Q(5,17) - MT2)
    den(2) = 1 / (Q(5,12))
    den(4) = 1 / (Q(5,18) - MT2)
    den(6) = 1 / (Q(5,3))
    den(8) = 1 / (Q(5,14) - MT2)
    den(11) = 1 / (Q(5,19))
    den(14) = 1 / (Q(5,13) - MT2)


  ! denominators

    den(3) = den(1)*den(2)
    den(5) = den(2)*den(4)
    den(7) = den(2)*den(6)
    den(9) = den(2)*den(8)
    den(10) = den(1)*den(9)
    den(12) = den(1)*den(11)
    den(13) = den(2)*den(12)
    den(15) = den(2)*den(14)
    den(16) = den(4)*den(15)
    den(17) = den(4)*den(11)
    den(18) = den(2)*den(17)


  ! colour stripped tree amplitudes

  A(1) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(2) = cont_VV(wf(:,2),wf(:,7)) * den(5)

  A(3) = cont_VV(wf(:,2),wf(:,9)) * den(7)
  A(4) = cont_VV(wf(:,4),wf(:,10)) * den(3)
  A(5) = cont_VV(wf(:,7),wf(:,10)) * den(5)
  A(6) = cont_VV(wf(:,2),wf(:,11)) * den(3)
  A(7) = cont_VV(wf(:,2),wf(:,14)) * den(5)
  A(8) = cont_VV(wf(:,2),wf(:,15)) * den(5)
  A(9) = cont_VV(wf(:,2),wf(:,18)) * den(3)
  A(10) = cont_QA(wf(:,20),wf(:,21)) * den(10)
  A(11) = cont_VV(wf(:,4),wf(:,22)) * den(13)
  A(12) = cont_QA(wf(:,24),wf(:,25)) * den(16)
  A(13) = cont_VV(wf(:,7),wf(:,22)) * den(18)


  ! colour vectors

  M1(1) = ((A(1)+A(2))*f(2))/2._/**/REALKIND
  M1(2) = ((-A(1)-A(2))*f(2))/6._/**/REALKIND

  M2(1) = (A(3)*f(1))/2._/**/REALKIND+((-A(10)-A(11)-A(12)-A(13))*f(3))/2._/**/REALKIND+((A(4)+A(5))*f(4))/2._/**/REALKIND+((A(6) &
       +A(8))*f(5))/2._/**/REALKIND+((A(7)+A(9))*f(6))/2._/**/REALKIND
  M2(2) = -(A(3)*f(1))/6._/**/REALKIND+((A(10)+A(11)+A(12)+A(13))*f(3))/6._/**/REALKIND+((-A(4)-A(5))*f(4))/6._/**/REALKIND+(( &
       -A(6)-A(8))*f(5))/6._/**/REALKIND+((-A(7)-A(9))*f(6))/6._/**/REALKIND


end subroutine tree_wavefunctions

end module ol_loop_pphtt_ttxddxh_1_/**/REALKIND
