
! **********************************************************************
module ol_heltables_pphtt_ttxhgg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(1) = [0], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n3, n4, n7, n13, n14, n17

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n5, n6, n8, n9, n10, n11, n12, n15, n16, n18, n19, n20, n21, n22, n23, n24, n25, n26, n27, n28, n29


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,2) :: &
  t1, t12

  integer(intkind2), save, dimension(2,8) :: &
  t15, t18

  integer(intkind2), save, dimension(2,16) :: &
  t22, t23, t24, t25, t26, t27, t28, t29

  integer(intkind2), save, dimension(2,4) :: &
  t2, t5, t6, t8, t9, t10, t11, t16, t19, t20, t21


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(16,5)
  integer,           save :: exthel(16,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,1,2], n1, t1)
  call heltable([2,2,4], n2, t2)
  n3 = 2
  n4 = 4
  call heltable([2,2,4], n5, t5)
  call heltable([2,2,4], n6, t6)
  n7 = 4
  call heltable([2,2,4], n8, t8)
  call heltable([2,2,4], n9, t9)
  call heltable([2,2,4], n10, t10)
  call heltable([2,2,4], n11, t11)
  call heltable([1,2,2], n12, t12)
  n13 = 4
  n14 = 2
  call heltable([2,4,8], n15, t15)
  call heltable([2,2,4], n16, t16)
  n17 = 4
  call heltable([2,4,8], n18, t18)
  call heltable([2,2,4], n19, t19)
  call heltable([4,1,4], n20, t20)
  call heltable([4,1,4], n21, t21)
  call heltable([4,4,16], n22, t22)
  call heltable([4,4,16], n23, t23)
  call heltable([4,4,16], n24, t24)
  call heltable([2,8,16], n25, t25)
  call heltable([2,8,16], n26, t26)
  call heltable([4,4,16], n27, t27)
  call heltable([4,4,16], n28, t28)
  call heltable([4,4,16], n29, t29)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pphtt_ttxhgg_1
