
module ol_tree_pphtt_ttxhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(2)
  complex(REALKIND), save :: den(15)

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(2) = (eQED*gQCD**2*MT)/(MW*sw*2._/**/REALKIND)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

    den(1) = 1 / (Q(5,5) - MT2)
    den(2) = 1 / (Q(5,10) - MT2)
    den(4) = 1 / (Q(5,18) - MT2)
    den(6) = 1 / (Q(5,24))
    den(8) = 1 / (Q(5,9) - MT2)
    den(9) = 1 / (Q(5,6) - MT2)
    den(11) = 1 / (Q(5,17) - MT2)

  ! denominators

    den(3) = den(1)*den(2)
    den(5) = den(1)*den(4)
    den(7) = den(1)*den(6)
    den(10) = den(8)*den(9)
    den(12) = den(9)*den(11)
    den(13) = den(6)*den(9)
    den(14) = den(4)*den(8)
    den(15) = den(2)*den(11)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs) &
    & bind(c,name="ol_f_amp2_pphtt_ttxhgg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top higgs glue glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_pphtt_ttxhgg_1, only: external_perm_pphtt_ttxhgg_1, &
    & external_perm_inv_pphtt_ttxhgg_1, extcomb_perm_pphtt_ttxhgg_1, &
    & average_factor_pphtt_ttxhgg_1
  use ol_external_pphtt_ttxhgg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_pphtt_ttxhgg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ttxhgg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_pphtt_ttxhgg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2(0:17-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,5)
  real(REALKIND)    :: extmasses2(5)
  real(REALKIND)    :: M2add(0:17-1)
  complex(REALKIND) :: MOM_LC(4), M1(2), M1helarray(2,16)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(16) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(1), ex4(2), ex5(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(2) :: &
    wf1, wf3, wf12, wf14

  type(wfun), dimension(4) :: &
    wf2, wf4, wf5, wf6, wf7, wf8, wf9, wf10, wf11, wf13, wf16, wf17, wf19, wf20, wf21

  type(wfun), dimension(8) :: &
    wf15, wf18

  type(wfun), dimension(16) :: &
    wf22, wf23, wf24, wf25, wf26, wf27, wf28, wf29


  type(polcont) :: A(16,8)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rMT2, rMT2, rMH2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_pphtt_ttxhgg_1,5)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,5)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_pphtt_ttxhgg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pphtt_ttxhgg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  ! external WFs
  call wf_Q(P(:,1), rMT, H1, ex1)
  call wf_A(P(:,2), rMT, H2, ex2)
  call wf_S(P(:,3), rMH, H3, ex3)
  call wf_V(P(:,4), rZERO, H4, ex4)
  call wf_V(P(:,5), rZERO, H5, ex5)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...
    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QS_A(gH,ntry, ex1, ex3, wf1, n1, t1)
  call vert_AV_Q(ntry, ex2, ex4, wf2, n2, t2)
  call prop_Q_A(ntry, wf1, Q(:,5), MT, 1_intkind1, wf3, n3)
  call prop_A_Q(ntry, wf2, Q(:,10), MT, 1_intkind1, wf4, n4)
  call vert_VQ_A(ntry, ex5, wf3, wf5, n5, t5)
  call vert_AV_Q(ntry, ex2, ex5, wf6, n6, t6)
  call prop_A_Q(ntry, wf6, Q(:,18), MT, 1_intkind1, wf7, n7)
  call vert_VQ_A(ntry, ex4, wf3, wf8, n8, t8)
  call vert_UV_W(ntry, ex4, Q(:,8), ex5, Q(:,16), wf9, n9, t9)
  call vert_QA_V(ntry, wf3, ex2, wf10, n10, t10)
  call vert_VQ_A(ntry, ex4, ex1, wf11, n11, t11)
  call vert_SA_Q(gH,ntry, ex3, ex2, wf12, n12, t12)
  call prop_Q_A(ntry, wf11, Q(:,9), MT, 1_intkind1, wf13, n13)
  call prop_A_Q(ntry, wf12, Q(:,6), MT, 1_intkind1, wf14, n14)
  call vert_VQ_A(ntry, ex5, wf13, wf15, n15, t15)
  call vert_VQ_A(ntry, ex5, ex1, wf16, n16, t16)
  call prop_Q_A(ntry, wf16, Q(:,17), MT, 1_intkind1, wf17, n17)
  call vert_VQ_A(ntry, ex4, wf17, wf18, n18, t18)
  call vert_QA_V(ntry, ex1, wf14, wf19, n19, t19)
  call vert_QS_A(gH,ntry, wf13, ex3, wf20, n20, t20)
  call vert_QS_A(gH,ntry, wf17, ex3, wf21, n21, t21)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf4, wf5, A(:,1), n22, t22, nhel, den(3))
    call cont_QA(nsync, wf7, wf8, A(:,2), n23, t23, nhel, den(5))
    call cont_VV(nsync, wf9, wf10, A(:,3), n24, t24, nhel, den(7))
    call cont_QA(nsync, wf14, wf15, A(:,4), n25, t25, nhel, den(10))
    call cont_QA(nsync, wf14, wf18, A(:,5), n26, t26, nhel, den(12))
    call cont_VV(nsync, wf9, wf19, A(:,6), n27, t27, nhel, den(13))
    call cont_QA(nsync, wf7, wf20, A(:,7), n28, t28, nhel, den(14))
    call cont_QA(nsync, wf4, wf21, A(:,8), n29, t29, nhel, den(15))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pphtt_ttxhgg_1

  do k = 0, 17-1
    M2(k) = M2add(extcomb_perm_pphtt_ttxhgg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*5-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(16,8)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(2) ! M1helarray(2,16)

  M1(1) = (A(j,1)%j+A(j,5)%j+A(j,8)%j)*f(1)+CI*(A(j,3)%j+A(j,6)%j)*f(2)
  M1(2) = (A(j,2)%j+A(j,4)%j+A(j,7)%j)*f(1)+CI*(-A(j,3)%j-A(j,6)%j)*f(2)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_pphtt_ttxhgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint(0:17-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_pphtt_ttxhgg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:17-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_pphtt_ttxhgg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:17-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_pphtt_ttxhgg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2(0:17-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    17, [ (k, k = 0, 17-1) ])
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_pphtt_ttxhgg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:17-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_pphtt_ttxhgg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2(5)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:17-1)
  integer        :: J, extcombs(5)
  do J = 1, 5
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 5, extcombs)
  do J = 1, 5
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_pphtt_ttxhgg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_pphtt_ttxhgg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_pphtt_ttxhgg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2(0:17-1)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2(0:17-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_pphtt_ttxhgg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_pphtt_ttxhgg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2(5)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2(5)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c



! Only for compatibility with the old interface
subroutine amp2tree_legacy(p, m2) &
    & bind(c,name="amp2tree_pphtt_ttxhgg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_legacy

subroutine amp2ccone_legacy(p, m2, i, j) &
    & bind(c,name="amp2ccone_pphtt_ttxhgg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_legacy

subroutine amp2ccall_legacy(p, m2) &
    & bind(c,name="amp2ccall_pphtt_ttxhgg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2(0:17-1)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2(0:17-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_legacy

subroutine amp2hcone_legacy(p, m2, i, j, mom) &
    & bind(c,name="amp2hcone_pphtt_ttxhgg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_legacy

subroutine amp2hcall_legacy(p, m2, i, mom) &
    & bind(c,name="amp2hcall_pphtt_ttxhgg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,5)
  real(c_double), intent(out) :: m2(5)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,5)
  real(DREALKIND) :: f_m2(5)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_legacy

#endif

end module ol_tree_pphtt_ttxhgg_1_/**/REALKIND
