
module ol_vamp_5_pphbbj_bbbxbxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_5(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphbbj_bbbxbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphbbj_bbbxbxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphbbj_bbbxbxhg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphbbj_bbbxbxhg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(4)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,24) :: G0
  complex(REALKIND), dimension(4,5,4,77) :: G1
  complex(REALKIND), dimension(15,62) :: G2tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,42),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,57),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),MT,G2tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,64),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,63),MT,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,42),MB,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,57),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),MB,G2tensor(:,3))
  call loop_QV_A(G1(:,:,:,4),wf(:,64),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),MB,G2tensor(:,4))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,65),Q(:,42),G1(:,:,:,7))
  call check_last_CV_D(l_switch,G1(:,:,:,7),Q(:,42),wf(:,57),Q(:,21),G2tensor(:,5))
  call check_last_CV_D(l_switch,G1(:,:,:,7),Q(:,42),wf(:,64),Q(:,21),G2tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,38),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,27),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,63),ZERO,G2tensor(:,7))
  call loop_QV_A(G1(:,:,:,8),wf(:,37),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),ZERO,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,38),MT,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,27),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MT,G2tensor(:,9))
  call loop_QV_A(G1(:,:,:,11),wf(:,37),G1(:,:,:,13))
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,63),MT,G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,38),MB,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,27),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,63),MB,G2tensor(:,11))
  call loop_QV_A(G1(:,:,:,14),wf(:,37),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,63),MB,G2tensor(:,12))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,66),Q(:,38),G1(:,:,:,17))
  call check_last_CV_D(l_switch,G1(:,:,:,17),Q(:,38),wf(:,27),Q(:,25),G2tensor(:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,17),Q(:,38),wf(:,37),Q(:,25),G2tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,67),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,38),ZERO,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,27),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,63),ZERO,G2tensor(:,15))
  call loop_QV_A(G1(:,:,:,18),wf(:,37),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,63),ZERO,G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,67),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,38),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,27),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),MT,G2tensor(:,17))
  call loop_QV_A(G1(:,:,:,21),wf(:,37),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,63),MT,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,67),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,38),MB,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,27),G1(:,:,:,25))
  call check_last_Q_A(l_switch,G1(:,:,:,25),Q(:,63),MB,G2tensor(:,19))
  call loop_QV_A(G1(:,:,:,24),wf(:,37),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),MB,G2tensor(:,20))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,67),Q(:,38),G1(:,:,:,27))
  call check_last_CV_D(l_switch,G1(:,:,:,27),Q(:,38),wf(:,27),Q(:,25),G2tensor(:,21))
  call check_last_CV_D(l_switch,G1(:,:,:,27),Q(:,38),wf(:,37),Q(:,25),G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,68),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,42),ZERO,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,57),G1(:,:,:,29))
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,63),ZERO,G2tensor(:,23))
  call loop_QV_A(G1(:,:,:,28),wf(:,64),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,63),ZERO,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,68),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,42),MT,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,57),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,63),MT,G2tensor(:,25))
  call loop_QV_A(G1(:,:,:,31),wf(:,64),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,63),MT,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,68),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,42),MB,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,57),G1(:,:,:,35))
  call check_last_Q_A(l_switch,G1(:,:,:,35),Q(:,63),MB,G2tensor(:,27))
  call loop_QV_A(G1(:,:,:,34),wf(:,64),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),MB,G2tensor(:,28))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,68),Q(:,42),G1(:,:,:,37))
  call check_last_CV_D(l_switch,G1(:,:,:,37),Q(:,42),wf(:,57),Q(:,21),G2tensor(:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,37),Q(:,42),wf(:,64),Q(:,21),G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,37),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,10),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,63),ZERO,G2tensor(:,31))
  call loop_QV_A(G1(:,:,:,38),wf(:,20),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),ZERO,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,37),MT,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,10),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),MT,G2tensor(:,33))
  call loop_QV_A(G1(:,:,:,41),wf(:,20),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,63),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,37),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,10),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,63),MB,G2tensor(:,35))
  call loop_QV_A(G1(:,:,:,44),wf(:,20),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,63),MB,G2tensor(:,36))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,69),Q(:,37),G1(:,:,:,47))
  call check_last_CV_D(l_switch,G1(:,:,:,47),Q(:,37),wf(:,10),Q(:,26),G2tensor(:,37))
  call check_last_CV_D(l_switch,G1(:,:,:,47),Q(:,37),wf(:,20),Q(:,26),G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,41),ZERO,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,45),G1(:,:,:,49))
  call check_last_Q_A(l_switch,G1(:,:,:,49),Q(:,63),ZERO,G2tensor(:,39))
  call loop_QV_A(G1(:,:,:,48),wf(:,53),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),ZERO,G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,41),MT,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,45),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),MT,G2tensor(:,41))
  call loop_QV_A(G1(:,:,:,51),wf(:,53),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,41),MB,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,45),G1(:,:,:,55))
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,63),MB,G2tensor(:,43))
  call loop_QV_A(G1(:,:,:,54),wf(:,53),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),MB,G2tensor(:,44))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,70),Q(:,41),G1(:,:,:,57))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,41),wf(:,45),Q(:,22),G2tensor(:,45))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,41),wf(:,53),Q(:,22),G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,37),ZERO,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,10),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),ZERO,G2tensor(:,47))
  call loop_QV_A(G1(:,:,:,58),wf(:,20),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,63),ZERO,G2tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,37),MT,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,10),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,63),MT,G2tensor(:,49))
  call loop_QV_A(G1(:,:,:,61),wf(:,20),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,63),MT,G2tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,37),MB,G1(:,:,:,64))
  call loop_QV_A(G1(:,:,:,64),wf(:,10),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),MB,G2tensor(:,51))
  call loop_QV_A(G1(:,:,:,64),wf(:,20),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),MB,G2tensor(:,52))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,71),Q(:,37),G1(:,:,:,67))
  call check_last_CV_D(l_switch,G1(:,:,:,67),Q(:,37),wf(:,10),Q(:,26),G2tensor(:,53))
  call check_last_CV_D(l_switch,G1(:,:,:,67),Q(:,37),wf(:,20),Q(:,26),G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,41),ZERO,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,45),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,63),ZERO,G2tensor(:,55))
  call loop_QV_A(G1(:,:,:,68),wf(:,53),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,63),ZERO,G2tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,41),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,45),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),MT,G2tensor(:,57))
  call loop_QV_A(G1(:,:,:,71),wf(:,53),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,63),MT,G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,41),MB,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,45),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),MB,G2tensor(:,59))
  call loop_QV_A(G1(:,:,:,74),wf(:,53),G1(:,:,:,76))
  call check_last_Q_A(l_switch,G1(:,:,:,76),Q(:,63),MB,G2tensor(:,60))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,72),Q(:,41),G1(:,:,:,77))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,41),wf(:,45),Q(:,22),G2tensor(:,61))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,41),wf(:,53),Q(:,22),G2tensor(:,62))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(24)*M(2)-c(23)*M(4)) * den(352)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(24)*M(2)-c(23)*M(4)) * den(352)
  T2sum(1:15,184) = T2sum(1:15,184) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(20)*M(2)-c(16)*M(4)) * den(352)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(25)*M(2)-c(26)*M(4)) * den(353)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(23)*M(2)-c(24)*M(4)) * den(353)
  T2sum(1:15,175) = T2sum(1:15,175) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(25)*M(2)-c(26)*M(4)) * den(353)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(23)*M(2)-c(24)*M(4)) * den(353)
  T2sum(1:15,176) = T2sum(1:15,176) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(16)*M(2)-c(20)*M(4)) * den(353)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(2)) * den(356)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(2)) * den(356)
  T2sum(1:15,175) = T2sum(1:15,175) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(2)) * den(356)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(2)) * den(356)
  T2sum(1:15,176) = T2sum(1:15,176) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(20)*M(1))+c(16)*M(2)) * den(356)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(26)*M(3)-c(25)*M(4)) * den(358)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(24)*M(3)-c(23)*M(4)) * den(358)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(26)*M(3)-c(25)*M(4)) * den(358)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(24)*M(3)-c(23)*M(4)) * den(358)
  T2sum(1:15,184) = T2sum(1:15,184) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(20)*M(3)-c(16)*M(4)) * den(358)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(3)) * den(364)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(3)) * den(364)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(3)) * den(364)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(3)) * den(364)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(16)*M(1))+c(20)*M(3)) * den(364)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(3)) * den(365)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(3)) * den(365)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(3)) * den(365)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(3)) * den(365)
  T2sum(1:15,180) = T2sum(1:15,180) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(20)*M(1))+c(16)*M(3)) * den(365)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(2)) * den(367)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(2)) * den(367)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(2)) * den(367)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(2)) * den(367)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(16)*M(1))+c(20)*M(2)) * den(367)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(25)*M(3)-c(26)*M(4)) * den(369)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(23)*M(3)-c(24)*M(4)) * den(369)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(25)*M(3)-c(26)*M(4)) * den(369)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(23)*M(3)-c(24)*M(4)) * den(369)
  T2sum(1:15,180) = T2sum(1:15,180) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(16)*M(3)-c(20)*M(4)) * den(369)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(3)) * den(374)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(3)) * den(374)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(3)) * den(374)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(3)) * den(374)
  T2sum(1:15,180) = T2sum(1:15,180) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(20)*M(1))+c(16)*M(3)) * den(374)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(24)*M(2)-c(23)*M(4)) * den(376)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(24)*M(2)-c(23)*M(4)) * den(376)
  T2sum(1:15,184) = T2sum(1:15,184) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(20)*M(2)-c(16)*M(4)) * den(376)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(26)*M(3)-c(25)*M(4)) * den(378)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(24)*M(3)-c(23)*M(4)) * den(378)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(26)*M(3)-c(25)*M(4)) * den(378)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(24)*M(3)-c(23)*M(4)) * den(378)
  T2sum(1:15,184) = T2sum(1:15,184) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(20)*M(3)-c(16)*M(4)) * den(378)
  T2sum(1:15,168) = T2sum(1:15,168) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(25)*M(3)-c(26)*M(4)) * den(379)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(23)*M(3)-c(24)*M(4)) * den(379)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(25)*M(3)-c(26)*M(4)) * den(379)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(23)*M(3)-c(24)*M(4)) * den(379)
  T2sum(1:15,180) = T2sum(1:15,180) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(16)*M(3)-c(20)*M(4)) * den(379)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(3)) * den(385)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(3)) * den(385)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(3)) * den(385)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(3)) * den(385)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(16)*M(1))+c(20)*M(3)) * den(385)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(25)*M(2)-c(26)*M(4)) * den(387)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(23)*M(2)-c(24)*M(4)) * den(387)
  T2sum(1:15,175) = T2sum(1:15,175) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(25)*M(2)-c(26)*M(4)) * den(387)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(23)*M(2)-c(24)*M(4)) * den(387)
  T2sum(1:15,176) = T2sum(1:15,176) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(16)*M(2)-c(20)*M(4)) * den(387)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(2)) * den(390)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(2)) * den(390)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(25)*M(1))+c(26)*M(2)) * den(390)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(23)*M(1))+c(24)*M(2)) * den(390)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(16)*M(1))+c(20)*M(2)) * den(390)
  T2sum(1:15,162) = T2sum(1:15,162) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(2)) * den(391)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(2)) * den(391)
  T2sum(1:15,175) = T2sum(1:15,175) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(26)*M(1))+c(25)*M(2)) * den(391)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(24)*M(1))+c(23)*M(2)) * den(391)
  T2sum(1:15,176) = T2sum(1:15,176) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(20)*M(1))+c(16)*M(2)) * den(391)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,22)

end subroutine vamp_5

end module ol_vamp_5_pphbbj_bbbxbxhg_1_/**/REALKIND
