
module ol_colourmatrix_pphbbj_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(138,6), K2(6,11), KL(6,11)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  384,  -48,  -48,    6,    6,   60]
  K1(  2,:) = [  -48,  384,    6,   60,  -48,    6]
  K1(  3,:) = [  -48,    6,  384,  -48,   60,    6]
  K1(  4,:) = [    6,   60,  -48,  384,    6,  -48]
  K1(  5,:) = [    6,  -48,   60,    6,  384,  -48]
  K1(  6,:) = [   60,    6,    6,  -48,  -48,  384]
  K1(  7,:) = [  512,  -64,  -64,    8,    8,   80]
  K1(  8,:) = [  -64,  512,    8,   80,  -64,    8]
  K1(  9,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 10,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 11,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 12,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 13,:) = [    1,   10,   10,  -62,  -62,   28]
  K1( 14,:) = [   10,    1,  -62,   28,   10,  -62]
  K1( 15,:) = [   10,  -62,    1,   10,   28,  -62]
  K1( 16,:) = [  -62,   28,   10,    1,  -62,   10]
  K1( 17,:) = [  -62,   10,   28,  -62,    1,   10]
  K1( 18,:) = [   28,  -62,  -62,   10,   10,    1]
  K1( 19,:) = [  512,  -64,  -64,    8,    8,   80]
  K1( 20,:) = [  -64,  512,    8,   80,  -64,    8]
  K1( 21,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 22,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 23,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 24,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 25,:) = [    0,    0,    0,    0,    0,    0]
  K1( 26,:) = [    0,    0,    0,    0,    0,    0]
  K1( 27,:) = [    0,    0,    0,    0,    0,    0]
  K1( 28,:) = [    0,    0,    0,    0,    0,    0]
  K1( 29,:) = [    0,    0,    0,    0,    0,    0]
  K1( 30,:) = [    0,    0,    0,    0,    0,    0]
  K1( 31,:) = [    0,    0,    0,    0,    0,    0]
  K1( 32,:) = [    0,    0,    0,    0,    0,    0]
  K1( 33,:) = [    0,    0,    0,    0,    0,    0]
  K1( 34,:) = [    0,    0,    0,    0,    0,    0]
  K1( 35,:) = [    0,    0,    0,    0,    0,    0]
  K1( 36,:) = [    0,    0,    0,    0,    0,    0]
  K1( 37,:) = [    0,    0,    0,    0,    0,    0]
  K1( 38,:) = [    0,    0,    0,    0,    0,    0]
  K1( 39,:) = [    0,    0,    0,    0,    0,    0]
  K1( 40,:) = [    0,    0,    0,    0,    0,    0]
  K1( 41,:) = [    0,    0,    0,    0,    0,    0]
  K1( 42,:) = [    0,    0,    0,    0,    0,    0]
  K1( 43,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 44,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 45,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 46,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1( 47,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 48,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1( 49,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1( 50,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1( 51,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 52,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 53,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 54,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 55,:) = [    0,    0,    0,    0,    0,    0]
  K1( 56,:) = [    0,    0,    0,    0,    0,    0]
  K1( 57,:) = [    0,    0,    0,    0,    0,    0]
  K1( 58,:) = [    0,    0,    0,    0,    0,    0]
  K1( 59,:) = [    0,    0,    0,    0,    0,    0]
  K1( 60,:) = [    0,    0,    0,    0,    0,    0]
  K1( 61,:) = [ 1152, -144, -144,   18,   18,  180]
  K1( 62,:) = [ -144, 1152,   18,  180, -144,   18]
  K1( 63,:) = [ -144,   18, 1152, -144,  180,   18]
  K1( 64,:) = [   18,  180, -144, 1152,   18, -144]
  K1( 65,:) = [   18, -144,  180,   18, 1152, -144]
  K1( 66,:) = [  180,   18,   18, -144, -144, 1152]
  K1( 67,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 68,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1( 69,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1( 70,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1( 71,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1( 72,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 73,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 74,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1( 75,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1( 76,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1( 77,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1( 78,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 79,:) = [    0,    0,    0,    0,    0,    0]
  K1( 80,:) = [    0,    0,    0,    0,    0,    0]
  K1( 81,:) = [    0,    0,    0,    0,    0,    0]
  K1( 82,:) = [    0,    0,    0,    0,    0,    0]
  K1( 83,:) = [    0,    0,    0,    0,    0,    0]
  K1( 84,:) = [    0,    0,    0,    0,    0,    0]
  K1( 85,:) = [ -648,   81,    0,    0,  -81, -162]
  K1( 86,:) = [   81,   81,    0,  162,   81,    0]
  K1( 87,:) = [    0,    0, -648,   81, -162,  -81]
  K1( 88,:) = [    0,  162,   81,   81,    0,   81]
  K1( 89,:) = [  -81,   81, -162,    0, -648,    0]
  K1( 90,:) = [ -162,    0,  -81,   81,    0, -648]
  K1( 91,:) = [ 1152, -144, -144,   18,   18,  180]
  K1( 92,:) = [ -144, 1152,   18,  180, -144,   18]
  K1( 93,:) = [ -144,   18, 1152, -144,  180,   18]
  K1( 94,:) = [   18,  180, -144, 1152,   18, -144]
  K1( 95,:) = [   18, -144,  180,   18, 1152, -144]
  K1( 96,:) = [  180,   18,   18, -144, -144, 1152]
  K1( 97,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1( 98,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 99,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1(100,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(101,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(102,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(103,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(104,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(105,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(106,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(107,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1(108,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1(109,:) = [    0,    0,    0,    0,    0,    0]
  K1(110,:) = [    0,    0,    0,    0,    0,    0]
  K1(111,:) = [    0,    0,    0,    0,    0,    0]
  K1(112,:) = [    0,    0,    0,    0,    0,    0]
  K1(113,:) = [    0,    0,    0,    0,    0,    0]
  K1(114,:) = [    0,    0,    0,    0,    0,    0]
  K1(115,:) = [   81,   81,   81,    0,    0,  162]
  K1(116,:) = [   81, -648,  -81, -162,    0,    0]
  K1(117,:) = [   81,  -81, -648,    0, -162,    0]
  K1(118,:) = [    0, -162,    0, -648,  -81,   81]
  K1(119,:) = [    0,    0, -162,  -81, -648,   81]
  K1(120,:) = [  162,    0,    0,   81,   81,   81]
  K1(121,:) = [ -648,    0,   81,  -81,    0, -162]
  K1(122,:) = [    0, -648,    0, -162,   81,  -81]
  K1(123,:) = [   81,    0,   81,   81,  162,    0]
  K1(124,:) = [  -81, -162,   81, -648,    0,    0]
  K1(125,:) = [    0,   81,  162,    0,   81,   81]
  K1(126,:) = [ -162,  -81,    0,    0,   81, -648]
  K1(127,:) = [ 1152, -144, -144,   18,   18,  180]
  K1(128,:) = [ -144, 1152,   18,  180, -144,   18]
  K1(129,:) = [ -144,   18, 1152, -144,  180,   18]
  K1(130,:) = [   18,  180, -144, 1152,   18, -144]
  K1(131,:) = [   18, -144,  180,   18, 1152, -144]
  K1(132,:) = [  180,   18,   18, -144, -144, 1152]
  K1(133,:) = [    0,    0,    0,    0,    0,    0]
  K1(134,:) = [    0,    0,    0,    0,    0,    0]
  K1(135,:) = [    0,    0,    0,    0,    0,    0]
  K1(136,:) = [    0,    0,    0,    0,    0,    0]
  K1(137,:) = [    0,    0,    0,    0,    0,    0]
  K1(138,:) = [    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 54) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphbbj_bbxhggg_1_/**/REALKIND



module ol_forced_parameters_pphbbj_bbxhggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphbbj_bbxhggg_1_/**/REALKIND

module ol_loop_pphbbj_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(26), c(29)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:584)
  ! denominators
  complex(REALKIND), save :: den(682)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(6,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 2) = (countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 3) = (CI*eQED*gQCD**3*YB)/(2._/**/REALKIND*MW*sw)
    f( 4) = (eQED*gQCD**3*YB)/(MW*sw*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f( 6) = (countertermnorm*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f( 7) = (CI*countertermnorm*ctGbb*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f( 8) = (countertermnorm*ctGbb*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*ctSbb*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f(10) = (countertermnorm*ctSbb*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f(11) = (CI*countertermnorm*ctVVV*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f(12) = (countertermnorm*ctVVV*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f(13) = (CI*countertermnorm*ctVVVV*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f(14) = (CI*countertermnorm*eQED*gQCD**5*R2GGGG*YB)/(2._/**/REALKIND*MW*sw)
    f(15) = (CI*eQED*gQCD**5*integralnorm*SwB*YB)/(4._/**/REALKIND*MW*sw)
    f(16) = (CI*eQED*gQCD**5*integralnorm*SwB*YB)/(2._/**/REALKIND*MW*sw)
    f(17) = (eQED*gQCD**5*integralnorm*SwB*YB)/(MW*sw*4._/**/REALKIND)
    f(18) = (eQED*gQCD**5*integralnorm*SwB*YB)/(MW*sw*2._/**/REALKIND)
    f(19) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f(20) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw)
    f(21) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f(22) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw)
    f(23) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(24) = (countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(25) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(26) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)

  c = [ 9*CI*f(15), 18*CI*f(15), CI*f(16), 3*CI*f(16), 8*CI*f(16), 9*CI*f(16), 18*CI*f(16), 3*f(17), 6*f(17), 9*f(17), 18*f(17) &
    , f(18), 3*f(18), 6*f(18), 8*f(18), 9*f(18), 18*f(18), CI*f(19), 3*CI*f(19), CI*f(20), 3*CI*f(20), f(21), 3*f(21), f(22) &
    , 3*f(22), CI*f(25), 3*CI*f(25), f(26), 3*f(26) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(6), M2(11)
  complex(REALKIND) :: A(564)
  ! external WFs
  call wf_Q(P(:,1), rMB, H(1), wf(:,0))
  call wf_A(P(:,2), rMB, H(2), wf(:,-1))
  call wf_S(P(:,3), rMH, H(3), wf(:,-2))
  call wf_V(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_V(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))

  ! internal WFs
  call vert_QS_A(gH,wf(:,0),wf(:,-2),wf(:,1))
  call vert_GGG_G(wf(:,-3),wf(:,-4),wf(:,-5),wf(:,2))
  call prop_Q_A(wf(:,1),Q(:,5),MB,1_intkind1,wf(:,3))
  call vert_QA_V(wf(:,3),wf(:,-1),wf(:,4))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,-3),wf(:,5))
  call vert_GGG_G(wf(:,-5),wf(:,-3),wf(:,-4),wf(:,6))
  call vert_SA_Q(gH,wf(:,-2),wf(:,-1),wf(:,7))
  call prop_A_Q(wf(:,7),Q(:,6),MB,1_intkind1,wf(:,8))
  call vert_QA_V(wf(:,0),wf(:,8),wf(:,9))
  call vert_AV_Q(wf(:,-1),wf(:,-3),wf(:,10))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,10),MB,1_intkind1,wf(:,12))
  call vert_QA_V(wf(:,3),wf(:,12),wf(:,13))
  call vert_VQ_A(wf(:,-4),wf(:,3),wf(:,14))
  call vert_AV_Q(wf(:,12),wf(:,-5),wf(:,15))
  call prop_Q_A(wf(:,14),Q(:,21),MB,1_intkind1,wf(:,16))
  call vert_AV_Q(wf(:,12),wf(:,-4),wf(:,17))
  call vert_VQ_A(wf(:,-5),wf(:,3),wf(:,18))
  call prop_A_Q(wf(:,17),Q(:,26),MB,1_intkind1,wf(:,19))
  call vert_AV_Q(wf(:,-1),wf(:,-4),wf(:,20))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,-5),Q(:,32),wf(:,21))
  call prop_A_Q(wf(:,20),Q(:,18),MB,1_intkind1,wf(:,22))
  call vert_QA_V(wf(:,3),wf(:,22),wf(:,23))
  call vert_VQ_A(wf(:,-3),wf(:,3),wf(:,24))
  call vert_AV_Q(wf(:,22),wf(:,-5),wf(:,25))
  call prop_Q_A(wf(:,24),Q(:,13),MB,1_intkind1,wf(:,26))
  call vert_AV_Q(wf(:,22),wf(:,-3),wf(:,27))
  call prop_A_Q(wf(:,27),Q(:,26),MB,1_intkind1,wf(:,28))
  call vert_AV_Q(wf(:,-1),wf(:,-5),wf(:,29))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,-4),Q(:,16),wf(:,30))
  call prop_A_Q(wf(:,29),Q(:,34),MB,1_intkind1,wf(:,31))
  call vert_QA_V(wf(:,3),wf(:,31),wf(:,32))
  call vert_UV_W(wf(:,30),Q(:,24),wf(:,-5),Q(:,32),wf(:,33))
  call vert_AV_Q(wf(:,-1),wf(:,30),wf(:,34))
  call prop_A_Q(wf(:,34),Q(:,26),MB,1_intkind1,wf(:,35))
  call vert_AV_Q(wf(:,31),wf(:,-4),wf(:,36))
  call vert_AV_Q(wf(:,31),wf(:,-3),wf(:,37))
  call prop_A_Q(wf(:,37),Q(:,42),MB,1_intkind1,wf(:,38))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,21),Q(:,40),wf(:,39))
  call vert_AV_Q(wf(:,-1),wf(:,21),wf(:,40))
  call prop_A_Q(wf(:,40),Q(:,42),MB,1_intkind1,wf(:,41))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,11),Q(:,48),wf(:,42))
  call vert_AV_Q(wf(:,-1),wf(:,11),wf(:,43))
  call prop_A_Q(wf(:,43),Q(:,50),MB,1_intkind1,wf(:,44))
  call vert_VQ_A(wf(:,-3),wf(:,0),wf(:,45))
  call prop_Q_A(wf(:,45),Q(:,9),MB,1_intkind1,wf(:,46))
  call vert_QA_V(wf(:,46),wf(:,8),wf(:,47))
  call vert_VQ_A(wf(:,-4),wf(:,46),wf(:,48))
  call vert_AV_Q(wf(:,8),wf(:,-5),wf(:,49))
  call prop_Q_A(wf(:,48),Q(:,25),MB,1_intkind1,wf(:,50))
  call vert_AV_Q(wf(:,8),wf(:,-4),wf(:,51))
  call vert_VQ_A(wf(:,-5),wf(:,46),wf(:,52))
  call prop_A_Q(wf(:,51),Q(:,22),MB,1_intkind1,wf(:,53))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,54))
  call prop_Q_A(wf(:,54),Q(:,17),MB,1_intkind1,wf(:,55))
  call vert_QA_V(wf(:,55),wf(:,8),wf(:,56))
  call vert_VQ_A(wf(:,-3),wf(:,55),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,25),MB,1_intkind1,wf(:,58))
  call vert_AV_Q(wf(:,8),wf(:,-3),wf(:,59))
  call vert_VQ_A(wf(:,-5),wf(:,55),wf(:,60))
  call prop_A_Q(wf(:,59),Q(:,14),MB,1_intkind1,wf(:,61))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,62))
  call prop_Q_A(wf(:,62),Q(:,33),MB,1_intkind1,wf(:,63))
  call vert_QA_V(wf(:,63),wf(:,8),wf(:,64))
  call vert_VQ_A(wf(:,30),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,25),MB,1_intkind1,wf(:,66))
  call vert_VQ_A(wf(:,-3),wf(:,63),wf(:,67))
  call prop_Q_A(wf(:,67),Q(:,41),MB,1_intkind1,wf(:,68))
  call vert_VQ_A(wf(:,-4),wf(:,63),wf(:,69))
  call vert_VQ_A(wf(:,21),wf(:,0),wf(:,70))
  call prop_Q_A(wf(:,70),Q(:,41),MB,1_intkind1,wf(:,71))
  call vert_VQ_A(wf(:,11),wf(:,0),wf(:,72))
  call prop_Q_A(wf(:,72),Q(:,49),MB,1_intkind1,wf(:,73))
  call vert_QS_A(gH,wf(:,46),wf(:,-2),wf(:,74))
  call prop_Q_A(wf(:,74),Q(:,13),MB,1_intkind1,wf(:,75))
  call vert_SA_Q(gH,wf(:,-2),wf(:,22),wf(:,76))
  call prop_A_Q(wf(:,76),Q(:,22),MB,1_intkind1,wf(:,77))
  call vert_SA_Q(gH,wf(:,-2),wf(:,31),wf(:,78))
  call prop_A_Q(wf(:,78),Q(:,38),MB,1_intkind1,wf(:,79))
  call vert_QS_A(gH,wf(:,55),wf(:,-2),wf(:,80))
  call prop_Q_A(wf(:,80),Q(:,21),MB,1_intkind1,wf(:,81))
  call vert_SA_Q(gH,wf(:,-2),wf(:,12),wf(:,82))
  call prop_A_Q(wf(:,82),Q(:,14),MB,1_intkind1,wf(:,83))
  call vert_QS_A(gH,wf(:,63),wf(:,-2),wf(:,84))
  call prop_Q_A(wf(:,84),Q(:,37),MB,1_intkind1,wf(:,85))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,86))
  call counter_SG_G(wf(:,-2),wf(:,86),wf(:,87))
  call counter_SG_G(wf(:,-2),wf(:,-5),wf(:,88))
  call vert_GGG_G(wf(:,86),wf(:,-3),wf(:,-4),wf(:,89))
  call vert_GGG_G(wf(:,-3),wf(:,-4),wf(:,86),wf(:,90))
  call vert_GGG_G(wf(:,-4),wf(:,86),wf(:,-3),wf(:,91))
  call counter_SG_G(wf(:,-2),wf(:,-4),wf(:,92))
  call vert_GGG_G(wf(:,86),wf(:,-3),wf(:,-5),wf(:,93))
  call vert_GGG_G(wf(:,-3),wf(:,-5),wf(:,86),wf(:,94))
  call vert_GGG_G(wf(:,-5),wf(:,86),wf(:,-3),wf(:,95))
  call counter_SG_G(wf(:,-2),wf(:,-3),wf(:,96))
  call vert_GGG_G(wf(:,86),wf(:,-4),wf(:,-5),wf(:,97))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,86),wf(:,98))
  call vert_GGG_G(wf(:,-5),wf(:,86),wf(:,-4),wf(:,99))
  call counter_GGG_G(wf(:,-3),wf(:,-4),wf(:,-5),wf(:,100))
  call counter_GGG_G(wf(:,-4),wf(:,-5),wf(:,-3),wf(:,101))
  call counter_GGG_G(wf(:,-5),wf(:,-3),wf(:,-4),wf(:,102))
  call counter_QA_V(wf(:,3),wf(:,-1),wf(:,103))
  call counter_SA_Q(gH,wf(:,-2),wf(:,-1),wf(:,104))
  call prop_A_Q(wf(:,104),Q(:,6),MB,1_intkind1,wf(:,105))
  call vert_QA_V(wf(:,0),wf(:,105),wf(:,106))
  call counter_QA_V(wf(:,0),wf(:,8),wf(:,107))
  call counter_QS_A(gH,wf(:,0),wf(:,-2),wf(:,108))
  call prop_Q_A(wf(:,108),Q(:,5),MB,1_intkind1,wf(:,109))
  call vert_QA_V(wf(:,109),wf(:,-1),wf(:,110))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,-5),Q(:,32),wf(:,111))
  call counter_SG_G(wf(:,-2),wf(:,30),wf(:,112))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,88),Q(:,36),wf(:,113))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,-4),Q(:,16),wf(:,114))
  call counter_SG_G(wf(:,-2),wf(:,21),wf(:,115))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,-3),Q(:,8),wf(:,116))
  call counter_SG_G(wf(:,-2),wf(:,11),wf(:,117))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,88),Q(:,36),wf(:,118))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,88),Q(:,36),wf(:,119))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,92),Q(:,20),wf(:,120))
  call vert_UV_W(wf(:,92),Q(:,20),wf(:,-5),Q(:,32),wf(:,121))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,92),Q(:,20),wf(:,122))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,96),Q(:,12),wf(:,123))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,-5),Q(:,32),wf(:,124))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,-4),Q(:,16),wf(:,125))
  call counter_QA_V(wf(:,3),wf(:,12),wf(:,126))
  call counter_AV_Q(wf(:,12),wf(:,-5),wf(:,127))
  call counter_VQ_A(wf(:,-5),wf(:,3),wf(:,128))
  call counter_AV_Q(wf(:,12),wf(:,-4),wf(:,129))
  call prop_Q_A(wf(:,18),Q(:,37),MB,1_intkind1,wf(:,130))
  call counter_VQ_A(wf(:,-4),wf(:,3),wf(:,131))
  call prop_A_Q(wf(:,15),Q(:,42),MB,1_intkind1,wf(:,132))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,133))
  call counter_QA_V(wf(:,3),wf(:,22),wf(:,134))
  call counter_AV_Q(wf(:,22),wf(:,-5),wf(:,135))
  call counter_QA_V(wf(:,3),wf(:,31),wf(:,136))
  call counter_UV_W(wf(:,30),Q(:,24),wf(:,-5),Q(:,32),wf(:,137))
  call counter_AV_Q(wf(:,31),wf(:,-4),wf(:,138))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,21),Q(:,40),wf(:,139))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,133),Q(:,48),wf(:,140))
  call vert_AV_Q(wf(:,-1),wf(:,133),wf(:,141))
  call prop_A_Q(wf(:,141),Q(:,50),MB,1_intkind1,wf(:,142))
  call vert_AV_Q(wf(:,-1),wf(:,2),wf(:,143))
  call counter_Q_A(ctbb,wf(:,3),Q(:,5),wf(:,144))
  call prop_A_Q(wf(:,143),Q(:,58),MB,1_intkind1,wf(:,145))
  call vert_AV_Q(wf(:,-1),wf(:,5),wf(:,146))
  call prop_A_Q(wf(:,146),Q(:,58),MB,1_intkind1,wf(:,147))
  call vert_AV_Q(wf(:,-1),wf(:,6),wf(:,148))
  call prop_A_Q(wf(:,148),Q(:,58),MB,1_intkind1,wf(:,149))
  call counter_V_V(ctGG,wf(:,2),Q(:,56),wf(:,150))
  call counter_V_V(ctGG,wf(:,5),Q(:,56),wf(:,151))
  call counter_V_V(ctGG,wf(:,6),Q(:,56),wf(:,152))
  call counter_AV_Q(wf(:,22),wf(:,-3),wf(:,153))
  call counter_VQ_A(wf(:,-3),wf(:,3),wf(:,154))
  call prop_A_Q(wf(:,25),Q(:,50),MB,1_intkind1,wf(:,155))
  call counter_UV_W(wf(:,-3),Q(:,8),wf(:,-5),Q(:,32),wf(:,156))
  call counter_AV_Q(wf(:,31),wf(:,-3),wf(:,157))
  call prop_A_Q(wf(:,36),Q(:,50),MB,1_intkind1,wf(:,158))
  call counter_UV_W(wf(:,-3),Q(:,8),wf(:,11),Q(:,48),wf(:,159))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,156),Q(:,40),wf(:,160))
  call vert_AV_Q(wf(:,-1),wf(:,156),wf(:,161))
  call prop_A_Q(wf(:,161),Q(:,42),MB,1_intkind1,wf(:,162))
  call counter_UV_W(wf(:,-3),Q(:,8),wf(:,-4),Q(:,16),wf(:,163))
  call vert_UV_W(wf(:,163),Q(:,24),wf(:,-5),Q(:,32),wf(:,164))
  call vert_AV_Q(wf(:,-1),wf(:,163),wf(:,165))
  call prop_A_Q(wf(:,165),Q(:,26),MB,1_intkind1,wf(:,166))
  call counter_QA_V(wf(:,46),wf(:,8),wf(:,167))
  call counter_AV_Q(wf(:,8),wf(:,-5),wf(:,168))
  call counter_VQ_A(wf(:,-5),wf(:,46),wf(:,169))
  call counter_AV_Q(wf(:,8),wf(:,-4),wf(:,170))
  call prop_Q_A(wf(:,52),Q(:,41),MB,1_intkind1,wf(:,171))
  call counter_VQ_A(wf(:,-4),wf(:,46),wf(:,172))
  call prop_A_Q(wf(:,49),Q(:,38),MB,1_intkind1,wf(:,173))
  call counter_QA_V(wf(:,55),wf(:,8),wf(:,174))
  call counter_VQ_A(wf(:,-5),wf(:,55),wf(:,175))
  call counter_QA_V(wf(:,63),wf(:,8),wf(:,176))
  call counter_VQ_A(wf(:,-4),wf(:,63),wf(:,177))
  call vert_VQ_A(wf(:,133),wf(:,0),wf(:,178))
  call prop_Q_A(wf(:,178),Q(:,49),MB,1_intkind1,wf(:,179))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,180))
  call counter_A_Q(ctbb,wf(:,8),Q(:,6),wf(:,181))
  call prop_Q_A(wf(:,180),Q(:,57),MB,1_intkind1,wf(:,182))
  call vert_VQ_A(wf(:,5),wf(:,0),wf(:,183))
  call prop_Q_A(wf(:,183),Q(:,57),MB,1_intkind1,wf(:,184))
  call vert_VQ_A(wf(:,6),wf(:,0),wf(:,185))
  call prop_Q_A(wf(:,185),Q(:,57),MB,1_intkind1,wf(:,186))
  call counter_AV_Q(wf(:,8),wf(:,-3),wf(:,187))
  call prop_Q_A(wf(:,60),Q(:,49),MB,1_intkind1,wf(:,188))
  call counter_VQ_A(wf(:,-3),wf(:,55),wf(:,189))
  call prop_Q_A(wf(:,69),Q(:,49),MB,1_intkind1,wf(:,190))
  call counter_VQ_A(wf(:,-3),wf(:,63),wf(:,191))
  call vert_VQ_A(wf(:,156),wf(:,0),wf(:,192))
  call prop_Q_A(wf(:,192),Q(:,41),MB,1_intkind1,wf(:,193))
  call vert_VQ_A(wf(:,163),wf(:,0),wf(:,194))
  call prop_Q_A(wf(:,194),Q(:,25),MB,1_intkind1,wf(:,195))
  call counter_SA_Q(gH,wf(:,-2),wf(:,22),wf(:,196))
  call counter_QS_A(gH,wf(:,46),wf(:,-2),wf(:,197))
  call vert_QA_V(wf(:,46),wf(:,22),wf(:,198))
  call counter_SA_Q(gH,wf(:,-2),wf(:,31),wf(:,199))
  call vert_QA_V(wf(:,46),wf(:,-1),wf(:,200))
  call vert_AV_Q(wf(:,-1),wf(:,88),wf(:,201))
  call prop_A_Q(wf(:,201),Q(:,38),MB,1_intkind1,wf(:,202))
  call vert_QA_V(wf(:,46),wf(:,31),wf(:,203))
  call vert_AV_Q(wf(:,-1),wf(:,92),wf(:,204))
  call prop_A_Q(wf(:,204),Q(:,22),MB,1_intkind1,wf(:,205))
  call counter_SA_Q(gH,wf(:,-2),wf(:,12),wf(:,206))
  call counter_QS_A(gH,wf(:,55),wf(:,-2),wf(:,207))
  call vert_QA_V(wf(:,55),wf(:,12),wf(:,208))
  call counter_QS_A(gH,wf(:,63),wf(:,-2),wf(:,209))
  call vert_QA_V(wf(:,0),wf(:,12),wf(:,210))
  call vert_VQ_A(wf(:,88),wf(:,0),wf(:,211))
  call prop_Q_A(wf(:,211),Q(:,37),MB,1_intkind1,wf(:,212))
  call vert_QA_V(wf(:,63),wf(:,12),wf(:,213))
  call vert_VQ_A(wf(:,92),wf(:,0),wf(:,214))
  call prop_Q_A(wf(:,214),Q(:,21),MB,1_intkind1,wf(:,215))
  call vert_QA_V(wf(:,55),wf(:,-1),wf(:,216))
  call vert_QA_V(wf(:,0),wf(:,22),wf(:,217))
  call vert_QA_V(wf(:,63),wf(:,-1),wf(:,218))
  call vert_QA_V(wf(:,0),wf(:,31),wf(:,219))
  call vert_QA_V(wf(:,55),wf(:,31),wf(:,220))
  call vert_AV_Q(wf(:,-1),wf(:,96),wf(:,221))
  call prop_A_Q(wf(:,221),Q(:,14),MB,1_intkind1,wf(:,222))
  call vert_QA_V(wf(:,63),wf(:,22),wf(:,223))
  call vert_VQ_A(wf(:,96),wf(:,0),wf(:,224))
  call prop_Q_A(wf(:,224),Q(:,13),MB,1_intkind1,wf(:,225))
  call counter_AV_Q(wf(:,-1),wf(:,30),wf(:,226))
  call counter_AV_Q(wf(:,-1),wf(:,-5),wf(:,227))
  call prop_A_Q(wf(:,227),Q(:,34),MB,1_intkind1,wf(:,228))
  call vert_QA_V(wf(:,3),wf(:,228),wf(:,229))
  call counter_AV_Q(wf(:,-1),wf(:,21),wf(:,230))
  call counter_AV_Q(wf(:,-1),wf(:,11),wf(:,231))
  call vert_AV_Q(wf(:,228),wf(:,-4),wf(:,232))
  call vert_AV_Q(wf(:,228),wf(:,-3),wf(:,233))
  call prop_A_Q(wf(:,233),Q(:,42),MB,1_intkind1,wf(:,234))
  call counter_AV_Q(wf(:,-1),wf(:,-4),wf(:,235))
  call prop_A_Q(wf(:,235),Q(:,18),MB,1_intkind1,wf(:,236))
  call vert_QA_V(wf(:,3),wf(:,236),wf(:,237))
  call vert_AV_Q(wf(:,236),wf(:,-5),wf(:,238))
  call vert_AV_Q(wf(:,236),wf(:,-3),wf(:,239))
  call prop_A_Q(wf(:,239),Q(:,26),MB,1_intkind1,wf(:,240))
  call counter_AV_Q(wf(:,-1),wf(:,-3),wf(:,241))
  call prop_A_Q(wf(:,241),Q(:,10),MB,1_intkind1,wf(:,242))
  call vert_QA_V(wf(:,3),wf(:,242),wf(:,243))
  call vert_AV_Q(wf(:,242),wf(:,-5),wf(:,244))
  call vert_AV_Q(wf(:,242),wf(:,-4),wf(:,245))
  call prop_A_Q(wf(:,245),Q(:,26),MB,1_intkind1,wf(:,246))
  call vert_SA_Q(gH,wf(:,-2),wf(:,228),wf(:,247))
  call prop_A_Q(wf(:,247),Q(:,38),MB,1_intkind1,wf(:,248))
  call vert_SA_Q(gH,wf(:,-2),wf(:,236),wf(:,249))
  call prop_A_Q(wf(:,249),Q(:,22),MB,1_intkind1,wf(:,250))
  call vert_SA_Q(gH,wf(:,-2),wf(:,242),wf(:,251))
  call prop_A_Q(wf(:,251),Q(:,14),MB,1_intkind1,wf(:,252))
  call vert_QA_V(wf(:,46),wf(:,105),wf(:,253))
  call vert_AV_Q(wf(:,105),wf(:,-5),wf(:,254))
  call vert_AV_Q(wf(:,105),wf(:,-4),wf(:,255))
  call prop_A_Q(wf(:,255),Q(:,22),MB,1_intkind1,wf(:,256))
  call vert_QA_V(wf(:,55),wf(:,105),wf(:,257))
  call vert_AV_Q(wf(:,105),wf(:,-3),wf(:,258))
  call prop_A_Q(wf(:,258),Q(:,14),MB,1_intkind1,wf(:,259))
  call vert_QA_V(wf(:,63),wf(:,105),wf(:,260))
  call counter_VQ_A(wf(:,30),wf(:,0),wf(:,261))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,262))
  call prop_Q_A(wf(:,262),Q(:,33),MB,1_intkind1,wf(:,263))
  call vert_QA_V(wf(:,263),wf(:,8),wf(:,264))
  call counter_VQ_A(wf(:,21),wf(:,0),wf(:,265))
  call counter_VQ_A(wf(:,11),wf(:,0),wf(:,266))
  call vert_VQ_A(wf(:,-3),wf(:,263),wf(:,267))
  call prop_Q_A(wf(:,267),Q(:,41),MB,1_intkind1,wf(:,268))
  call vert_VQ_A(wf(:,-4),wf(:,263),wf(:,269))
  call counter_VQ_A(wf(:,-4),wf(:,0),wf(:,270))
  call prop_Q_A(wf(:,270),Q(:,17),MB,1_intkind1,wf(:,271))
  call vert_QA_V(wf(:,271),wf(:,8),wf(:,272))
  call vert_VQ_A(wf(:,-3),wf(:,271),wf(:,273))
  call prop_Q_A(wf(:,273),Q(:,25),MB,1_intkind1,wf(:,274))
  call vert_VQ_A(wf(:,-5),wf(:,271),wf(:,275))
  call counter_VQ_A(wf(:,-3),wf(:,0),wf(:,276))
  call prop_Q_A(wf(:,276),Q(:,9),MB,1_intkind1,wf(:,277))
  call vert_QA_V(wf(:,277),wf(:,8),wf(:,278))
  call vert_VQ_A(wf(:,-4),wf(:,277),wf(:,279))
  call prop_Q_A(wf(:,279),Q(:,25),MB,1_intkind1,wf(:,280))
  call vert_VQ_A(wf(:,-5),wf(:,277),wf(:,281))
  call vert_QS_A(gH,wf(:,263),wf(:,-2),wf(:,282))
  call prop_Q_A(wf(:,282),Q(:,37),MB,1_intkind1,wf(:,283))
  call vert_QS_A(gH,wf(:,271),wf(:,-2),wf(:,284))
  call prop_Q_A(wf(:,284),Q(:,21),MB,1_intkind1,wf(:,285))
  call vert_QS_A(gH,wf(:,277),wf(:,-2),wf(:,286))
  call prop_Q_A(wf(:,286),Q(:,13),MB,1_intkind1,wf(:,287))
  call vert_QA_V(wf(:,109),wf(:,12),wf(:,288))
  call vert_VQ_A(wf(:,-4),wf(:,109),wf(:,289))
  call prop_Q_A(wf(:,289),Q(:,21),MB,1_intkind1,wf(:,290))
  call vert_VQ_A(wf(:,-5),wf(:,109),wf(:,291))
  call vert_QA_V(wf(:,109),wf(:,22),wf(:,292))
  call vert_VQ_A(wf(:,-3),wf(:,109),wf(:,293))
  call prop_Q_A(wf(:,293),Q(:,13),MB,1_intkind1,wf(:,294))
  call vert_QA_V(wf(:,109),wf(:,31),wf(:,295))
  call vert_AV_Q(wf(:,12),wf(:,11),wf(:,296))
  call prop_A_Q(wf(:,296),Q(:,58),MB,1_intkind1,wf(:,297))
  call vert_VQ_A(wf(:,11),wf(:,3),wf(:,298))
  call counter_A_Q(ctbb,wf(:,12),Q(:,10),wf(:,299))
  call prop_Q_A(wf(:,298),Q(:,53),MB,1_intkind1,wf(:,300))
  call counter_V_V(ctGG,wf(:,11),Q(:,48),wf(:,301))
  call prop_Q_A(wf(:,144),Q(:,5),MB,1_intkind1,wf(:,302))
  call vert_VQ_A(wf(:,-4),wf(:,302),wf(:,303))
  call vert_VQ_A(wf(:,-5),wf(:,302),wf(:,304))
  call prop_A_Q(wf(:,299),Q(:,10),MB,1_intkind1,wf(:,305))
  call vert_AV_Q(wf(:,305),wf(:,-4),wf(:,306))
  call vert_AV_Q(wf(:,305),wf(:,-5),wf(:,307))
  call counter_Q_A(ctbb,wf(:,16),Q(:,21),wf(:,308))
  call counter_A_Q(ctbb,wf(:,19),Q(:,26),wf(:,309))
  call vert_AV_Q(wf(:,22),wf(:,21),wf(:,310))
  call prop_A_Q(wf(:,310),Q(:,58),MB,1_intkind1,wf(:,311))
  call vert_VQ_A(wf(:,21),wf(:,3),wf(:,312))
  call counter_A_Q(ctbb,wf(:,22),Q(:,18),wf(:,313))
  call prop_Q_A(wf(:,312),Q(:,45),MB,1_intkind1,wf(:,314))
  call counter_V_V(ctGG,wf(:,21),Q(:,40),wf(:,315))
  call vert_VQ_A(wf(:,-3),wf(:,302),wf(:,316))
  call prop_A_Q(wf(:,313),Q(:,18),MB,1_intkind1,wf(:,317))
  call vert_AV_Q(wf(:,317),wf(:,-3),wf(:,318))
  call vert_AV_Q(wf(:,317),wf(:,-5),wf(:,319))
  call counter_Q_A(ctbb,wf(:,26),Q(:,13),wf(:,320))
  call counter_A_Q(ctbb,wf(:,28),Q(:,26),wf(:,321))
  call vert_AV_Q(wf(:,31),wf(:,30),wf(:,322))
  call prop_A_Q(wf(:,322),Q(:,58),MB,1_intkind1,wf(:,323))
  call vert_VQ_A(wf(:,30),wf(:,3),wf(:,324))
  call counter_A_Q(ctbb,wf(:,31),Q(:,34),wf(:,325))
  call prop_Q_A(wf(:,324),Q(:,29),MB,1_intkind1,wf(:,326))
  call counter_V_V(ctGG,wf(:,30),Q(:,24),wf(:,327))
  call vert_QA_V(wf(:,302),wf(:,-1),wf(:,328))
  call vert_AV_Q(wf(:,-1),wf(:,327),wf(:,329))
  call counter_V_V(ctGG,wf(:,4),Q(:,7),wf(:,330))
  call counter_A_Q(ctbb,wf(:,35),Q(:,26),wf(:,331))
  call vert_UV_W(wf(:,327),Q(:,24),wf(:,-5),Q(:,32),wf(:,332))
  call prop_A_Q(wf(:,325),Q(:,34),MB,1_intkind1,wf(:,333))
  call vert_AV_Q(wf(:,333),wf(:,-3),wf(:,334))
  call vert_AV_Q(wf(:,333),wf(:,-4),wf(:,335))
  call counter_A_Q(ctbb,wf(:,38),Q(:,42),wf(:,336))
  call vert_AV_Q(wf(:,-1),wf(:,315),wf(:,337))
  call counter_A_Q(ctbb,wf(:,41),Q(:,42),wf(:,338))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,315),Q(:,40),wf(:,339))
  call counter_A_Q(ctbb,wf(:,44),Q(:,50),wf(:,340))
  call vert_AV_Q(wf(:,-1),wf(:,301),wf(:,341))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,301),Q(:,48),wf(:,342))
  call vert_AV_Q(wf(:,8),wf(:,11),wf(:,343))
  call counter_Q_A(ctbb,wf(:,46),Q(:,9),wf(:,344))
  call prop_A_Q(wf(:,343),Q(:,54),MB,1_intkind1,wf(:,345))
  call vert_VQ_A(wf(:,11),wf(:,46),wf(:,346))
  call prop_Q_A(wf(:,346),Q(:,57),MB,1_intkind1,wf(:,347))
  call prop_Q_A(wf(:,344),Q(:,9),MB,1_intkind1,wf(:,348))
  call vert_VQ_A(wf(:,-4),wf(:,348),wf(:,349))
  call vert_VQ_A(wf(:,-5),wf(:,348),wf(:,350))
  call prop_A_Q(wf(:,181),Q(:,6),MB,1_intkind1,wf(:,351))
  call vert_AV_Q(wf(:,351),wf(:,-4),wf(:,352))
  call vert_AV_Q(wf(:,351),wf(:,-5),wf(:,353))
  call counter_Q_A(ctbb,wf(:,50),Q(:,25),wf(:,354))
  call counter_A_Q(ctbb,wf(:,53),Q(:,22),wf(:,355))
  call vert_AV_Q(wf(:,8),wf(:,21),wf(:,356))
  call counter_Q_A(ctbb,wf(:,55),Q(:,17),wf(:,357))
  call prop_A_Q(wf(:,356),Q(:,46),MB,1_intkind1,wf(:,358))
  call vert_VQ_A(wf(:,21),wf(:,55),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,57),MB,1_intkind1,wf(:,360))
  call prop_Q_A(wf(:,357),Q(:,17),MB,1_intkind1,wf(:,361))
  call vert_VQ_A(wf(:,-3),wf(:,361),wf(:,362))
  call vert_VQ_A(wf(:,-5),wf(:,361),wf(:,363))
  call vert_AV_Q(wf(:,351),wf(:,-3),wf(:,364))
  call counter_Q_A(ctbb,wf(:,58),Q(:,25),wf(:,365))
  call counter_A_Q(ctbb,wf(:,61),Q(:,14),wf(:,366))
  call vert_AV_Q(wf(:,8),wf(:,30),wf(:,367))
  call counter_Q_A(ctbb,wf(:,63),Q(:,33),wf(:,368))
  call prop_A_Q(wf(:,367),Q(:,30),MB,1_intkind1,wf(:,369))
  call vert_VQ_A(wf(:,30),wf(:,63),wf(:,370))
  call prop_Q_A(wf(:,370),Q(:,57),MB,1_intkind1,wf(:,371))
  call vert_QA_V(wf(:,0),wf(:,351),wf(:,372))
  call vert_VQ_A(wf(:,327),wf(:,0),wf(:,373))
  call counter_V_V(ctGG,wf(:,9),Q(:,7),wf(:,374))
  call counter_Q_A(ctbb,wf(:,66),Q(:,25),wf(:,375))
  call prop_Q_A(wf(:,368),Q(:,33),MB,1_intkind1,wf(:,376))
  call vert_VQ_A(wf(:,-3),wf(:,376),wf(:,377))
  call vert_VQ_A(wf(:,-4),wf(:,376),wf(:,378))
  call counter_Q_A(ctbb,wf(:,68),Q(:,41),wf(:,379))
  call vert_VQ_A(wf(:,315),wf(:,0),wf(:,380))
  call counter_Q_A(ctbb,wf(:,71),Q(:,41),wf(:,381))
  call counter_Q_A(ctbb,wf(:,73),Q(:,49),wf(:,382))
  call vert_VQ_A(wf(:,301),wf(:,0),wf(:,383))
  call vert_QS_A(gH,wf(:,348),wf(:,-2),wf(:,384))
  call vert_SA_Q(gH,wf(:,-2),wf(:,317),wf(:,385))
  call counter_Q_A(ctbb,wf(:,75),Q(:,13),wf(:,386))
  call counter_A_Q(ctbb,wf(:,77),Q(:,22),wf(:,387))
  call vert_SA_Q(gH,wf(:,-2),wf(:,333),wf(:,388))
  call counter_A_Q(ctbb,wf(:,79),Q(:,38),wf(:,389))
  call vert_QS_A(gH,wf(:,361),wf(:,-2),wf(:,390))
  call vert_SA_Q(gH,wf(:,-2),wf(:,305),wf(:,391))
  call counter_Q_A(ctbb,wf(:,81),Q(:,21),wf(:,392))
  call counter_A_Q(ctbb,wf(:,83),Q(:,14),wf(:,393))
  call vert_QS_A(gH,wf(:,376),wf(:,-2),wf(:,394))
  call counter_Q_A(ctbb,wf(:,85),Q(:,37),wf(:,395))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,30),Q(:,24),wf(:,396))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,21),Q(:,40),wf(:,397))
  call vert_UV_W(wf(:,86),Q(:,3),wf(:,11),Q(:,48),wf(:,398))
  call vert_UV_W(wf(:,116),Q(:,11),wf(:,-4),Q(:,16),wf(:,399))
  call vert_UV_W(wf(:,116),Q(:,11),wf(:,-5),Q(:,32),wf(:,400))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,114),Q(:,19),wf(:,401))
  call vert_UV_W(wf(:,114),Q(:,19),wf(:,-5),Q(:,32),wf(:,402))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,111),Q(:,35),wf(:,403))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,111),Q(:,35),wf(:,404))
  call vert_UV_W(wf(:,4),Q(:,7),wf(:,-3),Q(:,8),wf(:,405))
  call vert_UV_W(wf(:,4),Q(:,7),wf(:,-4),Q(:,16),wf(:,406))
  call vert_UV_W(wf(:,4),Q(:,7),wf(:,-5),Q(:,32),wf(:,407))
  call vert_QA_V(wf(:,26),wf(:,-1),wf(:,408))
  call vert_VQ_A(wf(:,-4),wf(:,26),wf(:,409))
  call prop_Q_A(wf(:,409),Q(:,29),MB,1_intkind1,wf(:,410))
  call vert_VQ_A(wf(:,-5),wf(:,26),wf(:,411))
  call prop_Q_A(wf(:,411),Q(:,45),MB,1_intkind1,wf(:,412))
  call vert_QA_V(wf(:,16),wf(:,-1),wf(:,413))
  call vert_VQ_A(wf(:,-3),wf(:,16),wf(:,414))
  call prop_Q_A(wf(:,414),Q(:,29),MB,1_intkind1,wf(:,415))
  call vert_VQ_A(wf(:,-5),wf(:,16),wf(:,416))
  call prop_Q_A(wf(:,416),Q(:,53),MB,1_intkind1,wf(:,417))
  call vert_QA_V(wf(:,130),wf(:,-1),wf(:,418))
  call vert_VQ_A(wf(:,-3),wf(:,130),wf(:,419))
  call prop_Q_A(wf(:,419),Q(:,45),MB,1_intkind1,wf(:,420))
  call vert_VQ_A(wf(:,-4),wf(:,130),wf(:,421))
  call prop_Q_A(wf(:,421),Q(:,53),MB,1_intkind1,wf(:,422))
  call vert_UV_W(wf(:,9),Q(:,7),wf(:,-3),Q(:,8),wf(:,423))
  call vert_UV_W(wf(:,9),Q(:,7),wf(:,-4),Q(:,16),wf(:,424))
  call vert_UV_W(wf(:,9),Q(:,7),wf(:,-5),Q(:,32),wf(:,425))
  call vert_QA_V(wf(:,0),wf(:,61),wf(:,426))
  call vert_QA_V(wf(:,0),wf(:,53),wf(:,427))
  call vert_QA_V(wf(:,0),wf(:,173),wf(:,428))
  call vert_AV_Q(wf(:,61),wf(:,-4),wf(:,429))
  call prop_A_Q(wf(:,429),Q(:,30),MB,1_intkind1,wf(:,430))
  call vert_AV_Q(wf(:,61),wf(:,-5),wf(:,431))
  call prop_A_Q(wf(:,431),Q(:,46),MB,1_intkind1,wf(:,432))
  call vert_AV_Q(wf(:,53),wf(:,-3),wf(:,433))
  call prop_A_Q(wf(:,433),Q(:,30),MB,1_intkind1,wf(:,434))
  call vert_AV_Q(wf(:,53),wf(:,-5),wf(:,435))
  call prop_A_Q(wf(:,435),Q(:,54),MB,1_intkind1,wf(:,436))
  call vert_AV_Q(wf(:,173),wf(:,-3),wf(:,437))
  call prop_A_Q(wf(:,437),Q(:,46),MB,1_intkind1,wf(:,438))
  call vert_AV_Q(wf(:,173),wf(:,-4),wf(:,439))
  call prop_A_Q(wf(:,439),Q(:,54),MB,1_intkind1,wf(:,440))
  call vert_UV_W(wf(:,200),Q(:,11),wf(:,-4),Q(:,16),wf(:,441))
  call vert_UV_W(wf(:,200),Q(:,11),wf(:,-5),Q(:,32),wf(:,442))
  call vert_QA_V(wf(:,75),wf(:,-1),wf(:,443))
  call vert_VQ_A(wf(:,-4),wf(:,75),wf(:,444))
  call prop_Q_A(wf(:,444),Q(:,29),MB,1_intkind1,wf(:,445))
  call vert_VQ_A(wf(:,-5),wf(:,75),wf(:,446))
  call prop_Q_A(wf(:,446),Q(:,45),MB,1_intkind1,wf(:,447))
  call vert_QA_V(wf(:,50),wf(:,-1),wf(:,448))
  call vert_QS_A(gH,wf(:,50),wf(:,-2),wf(:,449))
  call prop_Q_A(wf(:,449),Q(:,29),MB,1_intkind1,wf(:,450))
  call vert_VQ_A(wf(:,-5),wf(:,50),wf(:,451))
  call prop_Q_A(wf(:,451),Q(:,57),MB,1_intkind1,wf(:,452))
  call vert_QA_V(wf(:,171),wf(:,-1),wf(:,453))
  call vert_QS_A(gH,wf(:,171),wf(:,-2),wf(:,454))
  call prop_Q_A(wf(:,454),Q(:,45),MB,1_intkind1,wf(:,455))
  call vert_VQ_A(wf(:,-4),wf(:,171),wf(:,456))
  call prop_Q_A(wf(:,456),Q(:,57),MB,1_intkind1,wf(:,457))
  call vert_UV_W(wf(:,210),Q(:,11),wf(:,-4),Q(:,16),wf(:,458))
  call vert_UV_W(wf(:,210),Q(:,11),wf(:,-5),Q(:,32),wf(:,459))
  call vert_QA_V(wf(:,0),wf(:,83),wf(:,460))
  call vert_QA_V(wf(:,0),wf(:,19),wf(:,461))
  call vert_QA_V(wf(:,0),wf(:,132),wf(:,462))
  call vert_AV_Q(wf(:,83),wf(:,-4),wf(:,463))
  call prop_A_Q(wf(:,463),Q(:,30),MB,1_intkind1,wf(:,464))
  call vert_AV_Q(wf(:,83),wf(:,-5),wf(:,465))
  call prop_A_Q(wf(:,465),Q(:,46),MB,1_intkind1,wf(:,466))
  call vert_SA_Q(gH,wf(:,-2),wf(:,19),wf(:,467))
  call prop_A_Q(wf(:,467),Q(:,30),MB,1_intkind1,wf(:,468))
  call vert_AV_Q(wf(:,19),wf(:,-5),wf(:,469))
  call prop_A_Q(wf(:,469),Q(:,58),MB,1_intkind1,wf(:,470))
  call vert_SA_Q(gH,wf(:,-2),wf(:,132),wf(:,471))
  call prop_A_Q(wf(:,471),Q(:,46),MB,1_intkind1,wf(:,472))
  call vert_AV_Q(wf(:,132),wf(:,-4),wf(:,473))
  call prop_A_Q(wf(:,473),Q(:,58),MB,1_intkind1,wf(:,474))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,216),Q(:,19),wf(:,475))
  call vert_UV_W(wf(:,216),Q(:,19),wf(:,-5),Q(:,32),wf(:,476))
  call vert_QA_V(wf(:,81),wf(:,-1),wf(:,477))
  call vert_VQ_A(wf(:,-3),wf(:,81),wf(:,478))
  call prop_Q_A(wf(:,478),Q(:,29),MB,1_intkind1,wf(:,479))
  call vert_VQ_A(wf(:,-5),wf(:,81),wf(:,480))
  call prop_Q_A(wf(:,480),Q(:,53),MB,1_intkind1,wf(:,481))
  call vert_QA_V(wf(:,58),wf(:,-1),wf(:,482))
  call vert_QS_A(gH,wf(:,58),wf(:,-2),wf(:,483))
  call prop_Q_A(wf(:,483),Q(:,29),MB,1_intkind1,wf(:,484))
  call vert_VQ_A(wf(:,-5),wf(:,58),wf(:,485))
  call prop_Q_A(wf(:,485),Q(:,57),MB,1_intkind1,wf(:,486))
  call vert_QA_V(wf(:,188),wf(:,-1),wf(:,487))
  call vert_QS_A(gH,wf(:,188),wf(:,-2),wf(:,488))
  call prop_Q_A(wf(:,488),Q(:,53),MB,1_intkind1,wf(:,489))
  call vert_VQ_A(wf(:,-3),wf(:,188),wf(:,490))
  call prop_Q_A(wf(:,490),Q(:,57),MB,1_intkind1,wf(:,491))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,217),Q(:,19),wf(:,492))
  call vert_UV_W(wf(:,217),Q(:,19),wf(:,-5),Q(:,32),wf(:,493))
  call vert_QA_V(wf(:,0),wf(:,77),wf(:,494))
  call vert_QA_V(wf(:,0),wf(:,28),wf(:,495))
  call vert_QA_V(wf(:,0),wf(:,155),wf(:,496))
  call vert_AV_Q(wf(:,77),wf(:,-3),wf(:,497))
  call prop_A_Q(wf(:,497),Q(:,30),MB,1_intkind1,wf(:,498))
  call vert_AV_Q(wf(:,77),wf(:,-5),wf(:,499))
  call prop_A_Q(wf(:,499),Q(:,54),MB,1_intkind1,wf(:,500))
  call vert_SA_Q(gH,wf(:,-2),wf(:,28),wf(:,501))
  call prop_A_Q(wf(:,501),Q(:,30),MB,1_intkind1,wf(:,502))
  call vert_AV_Q(wf(:,28),wf(:,-5),wf(:,503))
  call prop_A_Q(wf(:,503),Q(:,58),MB,1_intkind1,wf(:,504))
  call vert_SA_Q(gH,wf(:,-2),wf(:,155),wf(:,505))
  call prop_A_Q(wf(:,505),Q(:,54),MB,1_intkind1,wf(:,506))
  call vert_AV_Q(wf(:,155),wf(:,-3),wf(:,507))
  call prop_A_Q(wf(:,507),Q(:,58),MB,1_intkind1,wf(:,508))
  call vert_QA_V(wf(:,66),wf(:,-1),wf(:,509))
  call vert_QA_V(wf(:,0),wf(:,35),wf(:,510))
  call vert_QS_A(gH,wf(:,66),wf(:,-2),wf(:,511))
  call prop_Q_A(wf(:,511),Q(:,29),MB,1_intkind1,wf(:,512))
  call vert_VQ_A(wf(:,-5),wf(:,66),wf(:,513))
  call prop_Q_A(wf(:,513),Q(:,57),MB,1_intkind1,wf(:,514))
  call vert_VQ_A(wf(:,33),wf(:,0),wf(:,515))
  call prop_Q_A(wf(:,515),Q(:,57),MB,1_intkind1,wf(:,516))
  call vert_SA_Q(gH,wf(:,-2),wf(:,35),wf(:,517))
  call prop_A_Q(wf(:,517),Q(:,30),MB,1_intkind1,wf(:,518))
  call vert_AV_Q(wf(:,35),wf(:,-5),wf(:,519))
  call prop_A_Q(wf(:,519),Q(:,58),MB,1_intkind1,wf(:,520))
  call vert_AV_Q(wf(:,-1),wf(:,33),wf(:,521))
  call prop_A_Q(wf(:,521),Q(:,58),MB,1_intkind1,wf(:,522))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,218),Q(:,35),wf(:,523))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,218),Q(:,35),wf(:,524))
  call vert_QA_V(wf(:,85),wf(:,-1),wf(:,525))
  call vert_VQ_A(wf(:,-3),wf(:,85),wf(:,526))
  call prop_Q_A(wf(:,526),Q(:,45),MB,1_intkind1,wf(:,527))
  call vert_VQ_A(wf(:,-4),wf(:,85),wf(:,528))
  call prop_Q_A(wf(:,528),Q(:,53),MB,1_intkind1,wf(:,529))
  call vert_QA_V(wf(:,68),wf(:,-1),wf(:,530))
  call vert_QS_A(gH,wf(:,68),wf(:,-2),wf(:,531))
  call prop_Q_A(wf(:,531),Q(:,45),MB,1_intkind1,wf(:,532))
  call vert_VQ_A(wf(:,-4),wf(:,68),wf(:,533))
  call prop_Q_A(wf(:,533),Q(:,57),MB,1_intkind1,wf(:,534))
  call vert_QA_V(wf(:,190),wf(:,-1),wf(:,535))
  call vert_QS_A(gH,wf(:,190),wf(:,-2),wf(:,536))
  call prop_Q_A(wf(:,536),Q(:,53),MB,1_intkind1,wf(:,537))
  call vert_VQ_A(wf(:,-3),wf(:,190),wf(:,538))
  call prop_Q_A(wf(:,538),Q(:,57),MB,1_intkind1,wf(:,539))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,219),Q(:,35),wf(:,540))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,219),Q(:,35),wf(:,541))
  call vert_QA_V(wf(:,0),wf(:,79),wf(:,542))
  call vert_QA_V(wf(:,0),wf(:,38),wf(:,543))
  call vert_QA_V(wf(:,0),wf(:,158),wf(:,544))
  call vert_AV_Q(wf(:,79),wf(:,-3),wf(:,545))
  call prop_A_Q(wf(:,545),Q(:,46),MB,1_intkind1,wf(:,546))
  call vert_AV_Q(wf(:,79),wf(:,-4),wf(:,547))
  call prop_A_Q(wf(:,547),Q(:,54),MB,1_intkind1,wf(:,548))
  call vert_SA_Q(gH,wf(:,-2),wf(:,38),wf(:,549))
  call prop_A_Q(wf(:,549),Q(:,46),MB,1_intkind1,wf(:,550))
  call vert_AV_Q(wf(:,38),wf(:,-4),wf(:,551))
  call prop_A_Q(wf(:,551),Q(:,58),MB,1_intkind1,wf(:,552))
  call vert_SA_Q(gH,wf(:,-2),wf(:,158),wf(:,553))
  call prop_A_Q(wf(:,553),Q(:,54),MB,1_intkind1,wf(:,554))
  call vert_AV_Q(wf(:,158),wf(:,-3),wf(:,555))
  call prop_A_Q(wf(:,555),Q(:,58),MB,1_intkind1,wf(:,556))
  call vert_QA_V(wf(:,71),wf(:,-1),wf(:,557))
  call vert_QA_V(wf(:,0),wf(:,41),wf(:,558))
  call vert_QS_A(gH,wf(:,71),wf(:,-2),wf(:,559))
  call prop_Q_A(wf(:,559),Q(:,45),MB,1_intkind1,wf(:,560))
  call vert_VQ_A(wf(:,-4),wf(:,71),wf(:,561))
  call prop_Q_A(wf(:,561),Q(:,57),MB,1_intkind1,wf(:,562))
  call vert_VQ_A(wf(:,39),wf(:,0),wf(:,563))
  call prop_Q_A(wf(:,563),Q(:,57),MB,1_intkind1,wf(:,564))
  call vert_SA_Q(gH,wf(:,-2),wf(:,41),wf(:,565))
  call prop_A_Q(wf(:,565),Q(:,46),MB,1_intkind1,wf(:,566))
  call vert_AV_Q(wf(:,41),wf(:,-4),wf(:,567))
  call prop_A_Q(wf(:,567),Q(:,58),MB,1_intkind1,wf(:,568))
  call vert_AV_Q(wf(:,-1),wf(:,39),wf(:,569))
  call prop_A_Q(wf(:,569),Q(:,58),MB,1_intkind1,wf(:,570))
  call vert_QA_V(wf(:,73),wf(:,-1),wf(:,571))
  call vert_QA_V(wf(:,0),wf(:,44),wf(:,572))
  call vert_QS_A(gH,wf(:,73),wf(:,-2),wf(:,573))
  call prop_Q_A(wf(:,573),Q(:,53),MB,1_intkind1,wf(:,574))
  call vert_VQ_A(wf(:,-3),wf(:,73),wf(:,575))
  call prop_Q_A(wf(:,575),Q(:,57),MB,1_intkind1,wf(:,576))
  call vert_VQ_A(wf(:,42),wf(:,0),wf(:,577))
  call prop_Q_A(wf(:,577),Q(:,57),MB,1_intkind1,wf(:,578))
  call vert_SA_Q(gH,wf(:,-2),wf(:,44),wf(:,579))
  call prop_A_Q(wf(:,579),Q(:,54),MB,1_intkind1,wf(:,580))
  call vert_AV_Q(wf(:,44),wf(:,-3),wf(:,581))
  call prop_A_Q(wf(:,581),Q(:,58),MB,1_intkind1,wf(:,582))
  call vert_AV_Q(wf(:,-1),wf(:,42),wf(:,583))
  call prop_A_Q(wf(:,583),Q(:,58),MB,1_intkind1,wf(:,584))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MB2)
  den(2) = 1 / (Q(5,56))
  den(4) = 1 / (Q(5,6) - MB2)
  den(6) = 1 / (Q(5,10) - MB2)
  den(7) = 1 / (Q(5,48))
  den(10) = 1 / (Q(5,21) - MB2)
  den(13) = 1 / (Q(5,26) - MB2)
  den(16) = 1 / (Q(5,18) - MB2)
  den(17) = 1 / (Q(5,40))
  den(20) = 1 / (Q(5,13) - MB2)
  den(25) = 1 / (Q(5,34) - MB2)
  den(26) = 1 / (Q(5,24))
  den(29) = 1 / (Q(5,7))
  den(35) = 1 / (Q(5,42) - MB2)
  den(42) = 1 / (Q(5,50) - MB2)
  den(45) = 1 / (Q(5,9) - MB2)
  den(48) = 1 / (Q(5,25) - MB2)
  den(51) = 1 / (Q(5,22) - MB2)
  den(54) = 1 / (Q(5,17) - MB2)
  den(59) = 1 / (Q(5,14) - MB2)
  den(62) = 1 / (Q(5,33) - MB2)
  den(69) = 1 / (Q(5,41) - MB2)
  den(77) = 1 / (Q(5,49) - MB2)
  den(85) = 1 / (Q(5,38) - MB2)
  den(93) = 1 / (Q(5,37) - MB2)
  den(106) = 1 / (Q(5,3))
  den(108) = 1 / (Q(5,36))
  den(110) = 1 / (Q(5,20))
  den(112) = 1 / (Q(5,12))
  den(114) = 1 / (Q(5,35))
  den(120) = 1 / (Q(5,19))
  den(125) = 1 / (Q(5,11))
  den(131) = 1 / (Q(5,44))
  den(136) = 1 / (Q(5,28))
  den(147) = 1 / (Q(5,58) - MB2)
  den(161) = 1 / (Q(5,57) - MB2)
  den(265) = 1 / (Q(5,53) - MB2)
  den(268) = 1 / (Q(5,15))
  den(283) = 1 / (Q(5,45) - MB2)
  den(286) = 1 / (Q(5,23))
  den(300) = 1 / (Q(5,29) - MB2)
  den(303) = 1 / (Q(5,39))
  den(335) = 1 / (Q(5,54) - MB2)
  den(352) = 1 / (Q(5,46) - MB2)
  den(368) = 1 / (Q(5,30) - MB2)
  den(455) = 1 / (Q(5,51))
  den(457) = 1 / (Q(5,43))
  den(459) = 1 / (Q(5,27))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(8) = den(1)*den(6)
  den(9) = den(7)*den(8)
  den(11) = den(1)*den(10)
  den(12) = den(6)*den(11)
  den(14) = den(6)*den(13)
  den(15) = den(1)*den(14)
  den(18) = den(1)*den(16)
  den(19) = den(17)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(16)*den(21)
  den(23) = den(13)*den(16)
  den(24) = den(1)*den(23)
  den(27) = den(1)*den(25)
  den(28) = den(26)*den(27)
  den(30) = den(1)*den(29)
  den(31) = den(26)*den(30)
  den(32) = den(13)*den(26)
  den(33) = den(1)*den(32)
  den(34) = den(21)*den(25)
  den(36) = den(25)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(17)*den(30)
  den(39) = den(17)*den(35)
  den(40) = den(1)*den(39)
  den(41) = den(7)*den(30)
  den(43) = den(7)*den(42)
  den(44) = den(1)*den(43)
  den(46) = den(4)*den(45)
  den(47) = den(7)*den(46)
  den(49) = den(45)*den(48)
  den(50) = den(4)*den(49)
  den(52) = den(4)*den(51)
  den(53) = den(45)*den(52)
  den(55) = den(4)*den(54)
  den(56) = den(17)*den(55)
  den(57) = den(48)*den(54)
  den(58) = den(4)*den(57)
  den(60) = den(4)*den(59)
  den(61) = den(54)*den(60)
  den(63) = den(4)*den(62)
  den(64) = den(26)*den(63)
  den(65) = den(4)*den(29)
  den(66) = den(26)*den(65)
  den(67) = den(26)*den(48)
  den(68) = den(4)*den(67)
  den(70) = den(62)*den(69)
  den(71) = den(4)*den(70)
  den(72) = den(60)*den(62)
  den(73) = den(17)*den(65)
  den(74) = den(17)*den(69)
  den(75) = den(4)*den(74)
  den(76) = den(7)*den(65)
  den(78) = den(7)*den(77)
  den(79) = den(4)*den(78)
  den(80) = den(20)*den(45)
  den(81) = den(16)*den(80)
  den(82) = den(16)*den(51)
  den(83) = den(45)*den(82)
  den(84) = den(25)*den(80)
  den(86) = den(25)*den(85)
  den(87) = den(45)*den(86)
  den(88) = den(43)*den(45)
  den(89) = den(10)*den(54)
  den(90) = den(6)*den(89)
  den(91) = den(6)*den(59)
  den(92) = den(54)*den(91)
  den(94) = den(62)*den(93)
  den(95) = den(6)*den(94)
  den(96) = den(62)*den(91)
  den(97) = den(6)*den(78)
  den(98) = den(25)*den(89)
  den(99) = den(54)*den(86)
  den(100) = den(39)*den(54)
  den(101) = den(16)*den(94)
  den(102) = den(62)*den(82)
  den(103) = den(16)*den(74)
  den(104) = den(32)*den(62)
  den(105) = den(25)*den(67)
  den(107) = den(2)*den(106)
  den(109) = den(106)*den(108)
  den(111) = den(106)*den(110)
  den(113) = den(106)*den(112)
  den(115) = den(106)*den(114)
  den(116) = den(26)*den(115)
  den(117) = den(2)*den(26)
  den(118) = den(106)*den(117)
  den(119) = den(26)*den(109)
  den(121) = den(106)*den(120)
  den(122) = den(17)*den(121)
  den(123) = den(2)*den(17)
  den(124) = den(106)*den(123)
  den(126) = den(106)*den(125)
  den(127) = den(7)*den(126)
  den(128) = den(2)*den(7)
  den(129) = den(106)*den(128)
  den(130) = den(108)*den(126)
  den(132) = den(108)*den(131)
  den(133) = den(106)*den(132)
  den(134) = den(17)*den(111)
  den(135) = den(110)*den(126)
  den(137) = den(110)*den(136)
  den(138) = den(106)*den(137)
  den(139) = den(7)*den(113)
  den(140) = den(112)*den(121)
  den(141) = den(112)*den(136)
  den(142) = den(106)*den(141)
  den(143) = den(1)*den(93)
  den(144) = den(6)*den(143)
  den(145) = den(6)*den(35)
  den(146) = den(1)*den(145)
  den(148) = den(2)*den(147)
  den(149) = den(1)*den(148)
  den(150) = den(2)*den(30)
  den(151) = den(16)*den(143)
  den(152) = den(16)*den(42)
  den(153) = den(1)*den(152)
  den(154) = den(11)*den(25)
  den(155) = den(25)*den(42)
  den(156) = den(1)*den(155)
  den(157) = den(45)*den(69)
  den(158) = den(4)*den(157)
  den(159) = den(4)*den(85)
  den(160) = den(45)*den(159)
  den(162) = den(2)*den(161)
  den(163) = den(4)*den(162)
  den(164) = den(2)*den(65)
  den(165) = den(54)*den(77)
  den(166) = den(4)*den(165)
  den(167) = den(54)*den(159)
  den(168) = den(62)*den(77)
  den(169) = den(4)*den(168)
  den(170) = den(52)*den(62)
  den(171) = den(16)*den(157)
  den(172) = den(45)*den(152)
  den(173) = den(16)*den(45)
  den(174) = den(108)*den(173)
  den(175) = den(25)*den(49)
  den(176) = den(45)*den(155)
  den(177) = den(45)*den(125)
  den(178) = den(7)*den(177)
  den(179) = den(108)*den(177)
  den(180) = den(85)*den(108)
  den(181) = den(45)*den(180)
  den(182) = den(25)*den(45)
  den(183) = den(110)*den(182)
  den(184) = den(110)*den(177)
  den(185) = den(51)*den(110)
  den(186) = den(45)*den(185)
  den(187) = den(6)*den(165)
  den(188) = den(54)*den(145)
  den(189) = den(6)*den(54)
  den(190) = den(108)*den(189)
  den(191) = den(6)*den(168)
  den(192) = den(14)*den(62)
  den(193) = den(6)*den(125)
  den(194) = den(7)*den(193)
  den(195) = den(108)*den(193)
  den(196) = den(93)*den(108)
  den(197) = den(6)*den(196)
  den(198) = den(6)*den(62)
  den(199) = den(110)*den(198)
  den(200) = den(110)*den(193)
  den(201) = den(10)*den(110)
  den(202) = den(6)*den(201)
  den(203) = den(25)*den(57)
  den(204) = den(36)*den(54)
  den(205) = den(54)*den(120)
  den(206) = den(17)*den(205)
  den(207) = den(108)*den(205)
  den(208) = den(54)*den(180)
  den(209) = den(16)*den(70)
  den(210) = den(23)*den(62)
  den(211) = den(16)*den(120)
  den(212) = den(17)*den(211)
  den(213) = den(108)*den(211)
  den(214) = den(16)*den(196)
  den(215) = den(62)*den(114)
  den(216) = den(26)*den(215)
  den(217) = den(25)*den(114)
  den(218) = den(26)*den(217)
  den(219) = den(67)*den(108)
  den(220) = den(26)*den(196)
  den(221) = den(110)*den(215)
  den(222) = den(62)*den(185)
  den(223) = den(110)*den(217)
  den(224) = den(25)*den(201)
  den(225) = den(74)*den(110)
  den(226) = den(17)*den(201)
  den(227) = den(25)*den(54)
  den(228) = den(112)*den(227)
  den(229) = den(112)*den(205)
  den(230) = den(59)*den(112)
  den(231) = den(54)*den(230)
  den(232) = den(16)*den(62)
  den(233) = den(112)*den(232)
  den(234) = den(112)*den(211)
  den(235) = den(20)*den(112)
  den(236) = den(16)*den(235)
  den(237) = den(112)*den(215)
  den(238) = den(62)*den(230)
  den(239) = den(112)*den(217)
  den(240) = den(25)*den(235)
  den(241) = den(78)*den(112)
  den(242) = den(7)*den(235)
  den(243) = den(26)*den(143)
  den(244) = den(1)*den(117)
  den(245) = den(11)*den(17)
  den(246) = den(1)*den(123)
  den(247) = den(7)*den(21)
  den(248) = den(1)*den(128)
  den(249) = den(7)*den(80)
  den(250) = den(17)*den(89)
  den(251) = den(26)*den(94)
  den(252) = den(4)*den(117)
  den(253) = den(26)*den(159)
  den(254) = den(4)*den(123)
  den(255) = den(17)*den(52)
  den(256) = den(4)*den(128)
  den(257) = den(7)*den(60)
  den(258) = den(7)*den(91)
  den(259) = den(17)*den(82)
  den(260) = den(26)*den(86)
  den(261) = den(6)*den(7)
  den(262) = den(147)*den(261)
  den(263) = den(1)*den(262)
  den(264) = den(1)*den(7)
  den(266) = den(264)*den(265)
  den(267) = den(6)*den(266)
  den(269) = den(8)*den(268)
  den(270) = den(7)*den(269)
  den(271) = den(1)**2
  den(272) = den(145)*den(271)
  den(273) = den(14)*den(271)
  den(274) = den(6)**2
  den(275) = den(143)*den(274)
  den(276) = den(11)*den(274)
  den(277) = den(11)*den(145)
  den(278) = den(14)*den(143)
  den(279) = den(16)*den(17)
  den(280) = den(147)*den(279)
  den(281) = den(1)*den(280)
  den(282) = den(1)*den(17)
  den(284) = den(282)*den(283)
  den(285) = den(16)*den(284)
  den(287) = den(18)*den(286)
  den(288) = den(17)*den(287)
  den(289) = den(152)*den(271)
  den(290) = den(23)*den(271)
  den(291) = den(16)**2
  den(292) = den(143)*den(291)
  den(293) = den(21)*den(291)
  den(294) = den(21)*den(152)
  den(295) = den(23)*den(143)
  den(296) = den(25)*den(26)
  den(297) = den(147)*den(296)
  den(298) = den(1)*den(297)
  den(299) = den(1)*den(26)
  den(301) = den(299)*den(300)
  den(302) = den(25)*den(301)
  den(304) = den(27)*den(303)
  den(305) = den(26)*den(304)
  den(306) = den(117)*den(271)
  den(307) = den(32)*den(271)
  den(308) = den(26)**2
  den(309) = den(143)*den(308)
  den(310) = den(30)*den(117)
  den(311) = den(32)*den(143)
  den(312) = den(30)*den(308)
  den(313) = den(155)*den(271)
  den(314) = den(36)*den(271)
  den(315) = den(25)**2
  den(316) = den(11)*den(315)
  den(317) = den(21)*den(315)
  den(318) = den(21)*den(155)
  den(319) = den(11)*den(36)
  den(320) = den(123)*den(271)
  den(321) = den(39)*den(271)
  den(322) = den(17)**2
  den(323) = den(11)*den(322)
  den(324) = den(30)*den(123)
  den(325) = den(11)*den(39)
  den(326) = den(30)*den(322)
  den(327) = den(128)*den(271)
  den(328) = den(43)*den(271)
  den(329) = den(30)*den(128)
  den(330) = den(21)*den(43)
  den(331) = den(7)**2
  den(332) = den(21)*den(331)
  den(333) = den(30)*den(331)
  den(334) = den(4)*den(7)
  den(336) = den(334)*den(335)
  den(337) = den(45)*den(336)
  den(338) = den(7)*den(45)
  den(339) = den(161)*den(338)
  den(340) = den(4)*den(339)
  den(341) = den(46)*den(268)
  den(342) = den(7)*den(341)
  den(343) = den(45)**2
  den(344) = den(159)*den(343)
  den(345) = den(52)*den(343)
  den(346) = den(4)**2
  den(347) = den(157)*den(346)
  den(348) = den(49)*den(346)
  den(349) = den(49)*den(159)
  den(350) = den(52)*den(157)
  den(351) = den(4)*den(17)
  den(353) = den(351)*den(352)
  den(354) = den(54)*den(353)
  den(355) = den(17)*den(54)
  den(356) = den(161)*den(355)
  den(357) = den(4)*den(356)
  den(358) = den(55)*den(286)
  den(359) = den(17)*den(358)
  den(360) = den(54)**2
  den(361) = den(159)*den(360)
  den(362) = den(60)*den(360)
  den(363) = den(165)*den(346)
  den(364) = den(57)*den(346)
  den(365) = den(57)*den(159)
  den(366) = den(60)*den(165)
  den(367) = den(4)*den(26)
  den(369) = den(367)*den(368)
  den(370) = den(62)*den(369)
  den(371) = den(26)*den(62)
  den(372) = den(161)*den(371)
  den(373) = den(4)*den(372)
  den(374) = den(63)*den(303)
  den(375) = den(26)*den(374)
  den(376) = den(117)*den(346)
  den(377) = den(159)*den(308)
  den(378) = den(65)*den(117)
  den(379) = den(67)*den(159)
  den(380) = den(67)*den(346)
  den(381) = den(65)*den(308)
  den(382) = den(62)**2
  den(383) = den(52)*den(382)
  den(384) = den(60)*den(382)
  den(385) = den(168)*den(346)
  den(386) = den(70)*den(346)
  den(387) = den(52)*den(70)
  den(388) = den(60)*den(168)
  den(389) = den(123)*den(346)
  den(390) = den(52)*den(322)
  den(391) = den(65)*den(123)
  den(392) = den(52)*den(74)
  den(393) = den(74)*den(346)
  den(394) = den(65)*den(322)
  den(395) = den(128)*den(346)
  den(396) = den(65)*den(128)
  den(397) = den(60)*den(78)
  den(398) = den(60)*den(331)
  den(399) = den(78)*den(346)
  den(400) = den(65)*den(331)
  den(401) = den(152)*den(343)
  den(402) = den(82)*den(343)
  den(403) = den(157)*den(291)
  den(404) = den(80)*den(291)
  den(405) = den(80)*den(152)
  den(406) = den(82)*den(157)
  den(407) = den(155)*den(343)
  den(408) = den(86)*den(343)
  den(409) = den(49)*den(315)
  den(410) = den(80)*den(315)
  den(411) = den(80)*den(155)
  den(412) = den(49)*den(86)
  den(413) = den(43)*den(343)
  den(414) = den(43)*den(80)
  den(415) = den(80)*den(331)
  den(416) = den(145)*den(360)
  den(417) = den(91)*den(360)
  den(418) = den(165)*den(274)
  den(419) = den(89)*den(274)
  den(420) = den(89)*den(145)
  den(421) = den(91)*den(165)
  den(422) = den(14)*den(382)
  den(423) = den(91)*den(382)
  den(424) = den(168)*den(274)
  den(425) = den(94)*den(274)
  den(426) = den(14)*den(94)
  den(427) = den(91)*den(168)
  den(428) = den(78)*den(91)
  den(429) = den(91)*den(331)
  den(430) = den(78)*den(274)
  den(431) = den(36)*den(360)
  den(432) = den(86)*den(360)
  den(433) = den(57)*den(315)
  den(434) = den(89)*den(315)
  den(435) = den(36)*den(89)
  den(436) = den(57)*den(86)
  den(437) = den(39)*den(360)
  den(438) = den(39)*den(89)
  den(439) = den(89)*den(322)
  den(440) = den(23)*den(382)
  den(441) = den(82)*den(382)
  den(442) = den(70)*den(291)
  den(443) = den(94)*den(291)
  den(444) = den(23)*den(94)
  den(445) = den(70)*den(82)
  den(446) = den(74)*den(82)
  den(447) = den(82)*den(322)
  den(448) = den(74)*den(291)
  den(449) = den(32)*den(382)
  den(450) = den(32)*den(94)
  den(451) = den(94)*den(308)
  den(452) = den(67)*den(86)
  den(453) = den(86)*den(308)
  den(454) = den(67)*den(315)
  den(456) = den(106)*den(455)
  den(458) = den(106)*den(457)
  den(460) = den(106)*den(459)
  den(461) = den(26)*den(106)
  den(462) = den(459)*den(461)
  den(463) = den(17)*den(106)
  den(464) = den(457)*den(463)
  den(465) = den(7)*den(106)
  den(466) = den(455)*den(465)
  den(467) = den(126)*den(459)
  den(468) = den(126)*den(457)
  den(469) = den(121)*den(459)
  den(470) = den(121)*den(455)
  den(471) = den(115)*den(457)
  den(472) = den(115)*den(455)
  den(473) = den(30)*den(268)
  den(474) = den(30)*den(286)
  den(475) = den(30)*den(303)
  den(476) = den(21)*den(268)
  den(477) = den(21)*den(300)
  den(478) = den(21)*den(283)
  den(479) = den(11)*den(286)
  den(480) = den(11)*den(300)
  den(481) = den(11)*den(265)
  den(482) = den(143)*den(303)
  den(483) = den(143)*den(283)
  den(484) = den(143)*den(265)
  den(485) = den(65)*den(268)
  den(486) = den(65)*den(286)
  den(487) = den(65)*den(303)
  den(488) = den(60)*den(268)
  den(489) = den(52)*den(286)
  den(490) = den(159)*den(303)
  den(491) = den(60)*den(368)
  den(492) = den(60)*den(352)
  den(493) = den(52)*den(368)
  den(494) = den(52)*den(335)
  den(495) = den(159)*den(352)
  den(496) = den(159)*den(335)
  den(497) = den(173)*den(459)
  den(498) = den(182)*den(457)
  den(499) = den(177)*den(459)
  den(500) = den(177)*den(457)
  den(501) = den(80)*den(268)
  den(502) = den(80)*den(300)
  den(503) = den(80)*den(283)
  den(504) = den(49)*den(459)
  den(505) = den(49)*den(300)
  den(506) = den(49)*den(161)
  den(507) = den(157)*den(457)
  den(508) = den(157)*den(283)
  den(509) = den(157)*den(161)
  den(510) = den(189)*den(459)
  den(511) = den(198)*den(457)
  den(512) = den(193)*den(459)
  den(513) = den(193)*den(457)
  den(514) = den(91)*den(268)
  den(515) = den(14)*den(459)
  den(516) = den(145)*den(457)
  den(517) = den(91)*den(368)
  den(518) = den(91)*den(352)
  den(519) = den(14)*den(368)
  den(520) = den(14)*den(147)
  den(521) = den(145)*den(352)
  den(522) = den(145)*den(147)
  den(523) = den(227)*den(455)
  den(524) = den(205)*den(459)
  den(525) = den(205)*den(455)
  den(526) = den(89)*den(286)
  den(527) = den(89)*den(300)
  den(528) = den(89)*den(265)
  den(529) = den(57)*den(459)
  den(530) = den(57)*den(300)
  den(531) = den(57)*den(161)
  den(532) = den(165)*den(455)
  den(533) = den(165)*den(265)
  den(534) = den(161)*den(165)
  den(535) = den(232)*den(455)
  den(536) = den(211)*den(459)
  den(537) = den(211)*den(455)
  den(538) = den(82)*den(286)
  den(539) = den(23)*den(459)
  den(540) = den(152)*den(455)
  den(541) = den(82)*den(368)
  den(542) = den(82)*den(335)
  den(543) = den(23)*den(368)
  den(544) = den(23)*den(147)
  den(545) = den(152)*den(335)
  den(546) = den(147)*den(152)
  den(547) = den(67)*den(459)
  den(548) = den(32)*den(459)
  den(549) = den(67)*den(300)
  den(550) = den(67)*den(161)
  den(551) = den(117)*den(161)
  den(552) = den(32)*den(368)
  den(553) = den(32)*den(147)
  den(554) = den(117)*den(147)
  den(555) = den(215)*den(457)
  den(556) = den(215)*den(455)
  den(557) = den(94)*den(303)
  den(558) = den(94)*den(283)
  den(559) = den(94)*den(265)
  den(560) = den(70)*den(457)
  den(561) = den(70)*den(283)
  den(562) = den(70)*den(161)
  den(563) = den(168)*den(455)
  den(564) = den(168)*den(265)
  den(565) = den(161)*den(168)
  den(566) = den(217)*den(457)
  den(567) = den(217)*den(455)
  den(568) = den(86)*den(303)
  den(569) = den(36)*den(457)
  den(570) = den(155)*den(455)
  den(571) = den(86)*den(352)
  den(572) = den(86)*den(335)
  den(573) = den(36)*den(352)
  den(574) = den(36)*den(147)
  den(575) = den(155)*den(335)
  den(576) = den(147)*den(155)
  den(577) = den(74)*den(457)
  den(578) = den(39)*den(457)
  den(579) = den(74)*den(283)
  den(580) = den(74)*den(161)
  den(581) = den(123)*den(161)
  den(582) = den(39)*den(352)
  den(583) = den(39)*den(147)
  den(584) = den(123)*den(147)
  den(585) = den(78)*den(455)
  den(586) = den(43)*den(455)
  den(587) = den(78)*den(265)
  den(588) = den(78)*den(161)
  den(589) = den(128)*den(161)
  den(590) = den(43)*den(335)
  den(591) = den(43)*den(147)
  den(592) = den(128)*den(147)
  den(593) = den(1)*den(6)*den(7)
  den(594) = den(1)*den(16)*den(17)
  den(595) = den(1)*den(25)*den(26)
  den(596) = den(4)*den(7)*den(45)
  den(597) = den(4)*den(17)*den(54)
  den(598) = den(4)*den(26)*den(62)
  den(599) = den(6)*den(481)
  den(600) = den(6)*den(484)
  den(601) = den(1)*den(520)
  den(602) = den(1)*den(522)
  den(603) = den(16)*den(478)
  den(604) = den(16)*den(483)
  den(605) = den(1)*den(544)
  den(606) = den(1)*den(546)
  den(607) = den(26)*den(475)
  den(608) = den(26)*den(482)
  den(609) = den(1)*den(553)
  den(610) = den(1)*den(554)
  den(611) = den(25)*den(477)
  den(612) = den(25)*den(480)
  den(613) = den(1)*den(574)
  den(614) = den(1)*den(576)
  den(615) = den(17)*den(474)
  den(616) = den(17)*den(479)
  den(617) = den(1)*den(583)
  den(618) = den(1)*den(584)
  den(619) = den(7)*den(473)
  den(620) = den(7)*den(476)
  den(621) = den(1)*den(591)
  den(622) = den(1)*den(592)
  den(623) = den(4)*den(506)
  den(624) = den(4)*den(509)
  den(625) = den(45)*den(494)
  den(626) = den(45)*den(496)
  den(627) = den(4)*den(531)
  den(628) = den(4)*den(534)
  den(629) = den(54)*den(492)
  den(630) = den(54)*den(495)
  den(631) = den(26)*den(487)
  den(632) = den(4)*den(550)
  den(633) = den(26)*den(490)
  den(634) = den(4)*den(551)
  den(635) = den(4)*den(562)
  den(636) = den(4)*den(565)
  den(637) = den(62)*den(491)
  den(638) = den(62)*den(493)
  den(639) = den(17)*den(486)
  den(640) = den(4)*den(580)
  den(641) = den(17)*den(489)
  den(642) = den(4)*den(581)
  den(643) = den(7)*den(485)
  den(644) = den(4)*den(588)
  den(645) = den(7)*den(488)
  den(646) = den(4)*den(589)
  den(647) = den(16)*den(503)
  den(648) = den(16)*den(508)
  den(649) = den(45)*den(542)
  den(650) = den(45)*den(545)
  den(651) = den(25)*den(502)
  den(652) = den(25)*den(505)
  den(653) = den(45)*den(572)
  den(654) = den(45)*den(575)
  den(655) = den(7)*den(501)
  den(656) = den(45)*den(590)
  den(657) = den(6)*den(528)
  den(658) = den(6)*den(533)
  den(659) = den(54)*den(518)
  den(660) = den(54)*den(521)
  den(661) = den(6)*den(559)
  den(662) = den(6)*den(564)
  den(663) = den(62)*den(517)
  den(664) = den(62)*den(519)
  den(665) = den(6)*den(587)
  den(666) = den(7)*den(514)
  den(667) = den(25)*den(527)
  den(668) = den(25)*den(530)
  den(669) = den(54)*den(571)
  den(670) = den(54)*den(573)
  den(671) = den(17)*den(526)
  den(672) = den(54)*den(582)
  den(673) = den(16)*den(558)
  den(674) = den(16)*den(561)
  den(675) = den(62)*den(541)
  den(676) = den(62)*den(543)
  den(677) = den(16)*den(579)
  den(678) = den(17)*den(538)
  den(679) = den(26)*den(557)
  den(680) = den(62)*den(552)
  den(681) = den(25)*den(549)
  den(682) = den(26)*den(568)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(564)

  A(1) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(3)
  A(3) = cont_VV(wf(:,4),wf(:,6)) * den(3)
  A(4) = cont_VV(wf(:,2),wf(:,9)) * den(5)
  A(5) = cont_VV(wf(:,5),wf(:,9)) * den(5)
  A(6) = cont_VV(wf(:,6),wf(:,9)) * den(5)
  A(7) = cont_VV(wf(:,11),wf(:,13)) * den(9)
  A(8) = cont_QA(wf(:,15),wf(:,16)) * den(12)
  A(9) = cont_QA(wf(:,18),wf(:,19)) * den(15)
  A(10) = cont_VV(wf(:,21),wf(:,23)) * den(19)
  A(11) = cont_QA(wf(:,25),wf(:,26)) * den(22)
  A(12) = cont_QA(wf(:,18),wf(:,28)) * den(24)
  A(13) = cont_VV(wf(:,30),wf(:,32)) * den(28)
  A(14) = cont_VV(wf(:,4),wf(:,33)) * den(31)
  A(15) = cont_QA(wf(:,18),wf(:,35)) * den(33)
  A(16) = cont_QA(wf(:,26),wf(:,36)) * den(34)
  A(17) = cont_QA(wf(:,14),wf(:,38)) * den(37)
  A(18) = cont_VV(wf(:,4),wf(:,39)) * den(38)
  A(19) = cont_QA(wf(:,14),wf(:,41)) * den(40)
  A(20) = cont_VV(wf(:,4),wf(:,42)) * den(41)
  A(21) = cont_QA(wf(:,24),wf(:,44)) * den(44)
  A(22) = cont_VV(wf(:,11),wf(:,47)) * den(47)
  A(23) = cont_QA(wf(:,49),wf(:,50)) * den(50)
  A(24) = cont_QA(wf(:,52),wf(:,53)) * den(53)
  A(25) = cont_VV(wf(:,21),wf(:,56)) * den(56)
  A(26) = cont_QA(wf(:,49),wf(:,58)) * den(58)
  A(27) = cont_QA(wf(:,60),wf(:,61)) * den(61)
  A(28) = cont_VV(wf(:,30),wf(:,64)) * den(64)
  A(29) = cont_VV(wf(:,9),wf(:,33)) * den(66)
  A(30) = cont_QA(wf(:,49),wf(:,66)) * den(68)
  A(31) = cont_QA(wf(:,51),wf(:,68)) * den(71)
  A(32) = cont_QA(wf(:,61),wf(:,69)) * den(72)
  A(33) = cont_VV(wf(:,9),wf(:,39)) * den(73)
  A(34) = cont_QA(wf(:,51),wf(:,71)) * den(75)
  A(35) = cont_VV(wf(:,9),wf(:,42)) * den(76)
  A(36) = cont_QA(wf(:,59),wf(:,73)) * den(79)
  A(37) = cont_QA(wf(:,25),wf(:,75)) * den(81)
  A(38) = cont_QA(wf(:,52),wf(:,77)) * den(83)
  A(39) = cont_QA(wf(:,36),wf(:,75)) * den(84)
  A(40) = cont_QA(wf(:,48),wf(:,79)) * den(87)
  A(41) = cont_QA(wf(:,44),wf(:,74)) * den(88)
  A(42) = cont_QA(wf(:,15),wf(:,81)) * den(90)
  A(43) = cont_QA(wf(:,60),wf(:,83)) * den(92)
  A(44) = cont_QA(wf(:,17),wf(:,85)) * den(95)
  A(45) = cont_QA(wf(:,69),wf(:,83)) * den(96)
  A(46) = cont_QA(wf(:,73),wf(:,82)) * den(97)
  A(47) = cont_QA(wf(:,37),wf(:,81)) * den(98)
  A(48) = cont_QA(wf(:,57),wf(:,79)) * den(99)
  A(49) = cont_QA(wf(:,41),wf(:,80)) * den(100)
  A(50) = cont_QA(wf(:,27),wf(:,85)) * den(101)
  A(51) = cont_QA(wf(:,67),wf(:,77)) * den(102)
  A(52) = cont_QA(wf(:,71),wf(:,76)) * den(103)
  A(53) = cont_QA(wf(:,35),wf(:,84)) * den(104)
  A(54) = cont_QA(wf(:,66),wf(:,78)) * den(105)

  A(55) = cont_VV(wf(:,2),wf(:,87)) * den(107)
  A(56) = cont_VV(wf(:,5),wf(:,87)) * den(107)
  A(57) = cont_VV(wf(:,6),wf(:,87)) * den(107)
  A(58) = cont_VV(wf(:,2),wf(:,87)) * den(107)
  A(59) = cont_VV(wf(:,5),wf(:,87)) * den(107)
  A(60) = cont_VV(wf(:,6),wf(:,87)) * den(107)
  A(61) = cont_VV(wf(:,88),wf(:,89)) * den(109)
  A(62) = cont_VV(wf(:,88),wf(:,90)) * den(109)
  A(63) = cont_VV(wf(:,88),wf(:,91)) * den(109)
  A(64) = cont_VV(wf(:,88),wf(:,89)) * den(109)
  A(65) = cont_VV(wf(:,88),wf(:,90)) * den(109)
  A(66) = cont_VV(wf(:,88),wf(:,91)) * den(109)
  A(67) = cont_VV(wf(:,92),wf(:,93)) * den(111)
  A(68) = cont_VV(wf(:,92),wf(:,94)) * den(111)
  A(69) = cont_VV(wf(:,92),wf(:,95)) * den(111)
  A(70) = cont_VV(wf(:,92),wf(:,93)) * den(111)
  A(71) = cont_VV(wf(:,92),wf(:,94)) * den(111)
  A(72) = cont_VV(wf(:,92),wf(:,95)) * den(111)
  A(73) = cont_VV(wf(:,96),wf(:,97)) * den(113)
  A(74) = cont_VV(wf(:,96),wf(:,98)) * den(113)
  A(75) = cont_VV(wf(:,96),wf(:,99)) * den(113)
  A(76) = cont_VV(wf(:,96),wf(:,97)) * den(113)
  A(77) = cont_VV(wf(:,96),wf(:,98)) * den(113)
  A(78) = cont_VV(wf(:,96),wf(:,99)) * den(113)
  A(79) = cont_VV(wf(:,4),wf(:,100)) * den(3)
  A(80) = cont_VV(wf(:,4),wf(:,101)) * den(3)
  A(81) = cont_VV(wf(:,4),wf(:,102)) * den(3)
  A(82) = cont_VV(wf(:,4),wf(:,100)) * den(3)
  A(83) = cont_VV(wf(:,4),wf(:,101)) * den(3)
  A(84) = cont_VV(wf(:,4),wf(:,102)) * den(3)
  A(85) = cont_VV(wf(:,9),wf(:,100)) * den(5)
  A(86) = cont_VV(wf(:,9),wf(:,101)) * den(5)
  A(87) = cont_VV(wf(:,9),wf(:,102)) * den(5)
  A(88) = cont_VV(wf(:,9),wf(:,100)) * den(5)
  A(89) = cont_VV(wf(:,9),wf(:,101)) * den(5)
  A(90) = cont_VV(wf(:,9),wf(:,102)) * den(5)
  A(91) = cont_VV(wf(:,2),wf(:,103)) * den(3)
  A(92) = cont_VV(wf(:,5),wf(:,103)) * den(3)
  A(93) = cont_VV(wf(:,6),wf(:,103)) * den(3)
  A(94) = cont_VV(wf(:,2),wf(:,106)) * den(5)
  A(95) = cont_VV(wf(:,5),wf(:,106)) * den(5)
  A(96) = cont_VV(wf(:,6),wf(:,106)) * den(5)
  A(97) = cont_VV(wf(:,2),wf(:,107)) * den(5)
  A(98) = cont_VV(wf(:,5),wf(:,107)) * den(5)
  A(99) = cont_VV(wf(:,6),wf(:,107)) * den(5)
  A(100) = cont_VV(wf(:,2),wf(:,110)) * den(3)
  A(101) = cont_VV(wf(:,5),wf(:,110)) * den(3)
  A(102) = cont_VV(wf(:,6),wf(:,110)) * den(3)
  A(103) = cont_VV(wf(:,111),wf(:,112)) * den(116)
  A(104) = cont_VV(wf(:,111),wf(:,112)) * den(116)
  A(105) = cont_VV(wf(:,33),wf(:,87)) * den(118)
  A(106) = cont_VV(wf(:,33),wf(:,87)) * den(118)
  A(107) = cont_VV(wf(:,30),wf(:,113)) * den(119)
  A(108) = cont_VV(wf(:,30),wf(:,113)) * den(119)
  A(109) = cont_VV(wf(:,114),wf(:,115)) * den(122)
  A(110) = cont_VV(wf(:,114),wf(:,115)) * den(122)
  A(111) = cont_VV(wf(:,39),wf(:,87)) * den(124)
  A(112) = cont_VV(wf(:,39),wf(:,87)) * den(124)
  A(113) = cont_VV(wf(:,116),wf(:,117)) * den(127)
  A(114) = cont_VV(wf(:,116),wf(:,117)) * den(127)
  A(115) = cont_VV(wf(:,42),wf(:,87)) * den(129)
  A(116) = cont_VV(wf(:,42),wf(:,87)) * den(129)
  A(117) = cont_VV(wf(:,116),wf(:,118)) * den(130)
  A(118) = cont_VV(wf(:,116),wf(:,118)) * den(130)
  A(119) = cont_VV(wf(:,114),wf(:,119)) * den(133)
  A(120) = cont_VV(wf(:,114),wf(:,119)) * den(133)
  A(121) = cont_VV(wf(:,21),wf(:,120)) * den(134)
  A(122) = cont_VV(wf(:,21),wf(:,120)) * den(134)
  A(123) = cont_VV(wf(:,116),wf(:,121)) * den(135)
  A(124) = cont_VV(wf(:,116),wf(:,121)) * den(135)
  A(125) = cont_VV(wf(:,111),wf(:,122)) * den(138)
  A(126) = cont_VV(wf(:,111),wf(:,122)) * den(138)
  A(127) = cont_VV(wf(:,11),wf(:,123)) * den(139)
  A(128) = cont_VV(wf(:,11),wf(:,123)) * den(139)
  A(129) = cont_VV(wf(:,114),wf(:,124)) * den(140)
  A(130) = cont_VV(wf(:,114),wf(:,124)) * den(140)
  A(131) = cont_VV(wf(:,111),wf(:,125)) * den(142)
  A(132) = cont_VV(wf(:,111),wf(:,125)) * den(142)
  A(133) = cont_VV(wf(:,11),wf(:,126)) * den(9)
  A(134) = cont_QA(wf(:,16),wf(:,127)) * den(12)
  A(135) = cont_QA(wf(:,19),wf(:,128)) * den(15)
  A(136) = cont_QA(wf(:,129),wf(:,130)) * den(144)
  A(137) = cont_QA(wf(:,131),wf(:,132)) * den(146)
  A(138) = cont_VV(wf(:,13),wf(:,133)) * den(9)
  A(139) = cont_VV(wf(:,21),wf(:,134)) * den(19)
  A(140) = cont_QA(wf(:,26),wf(:,135)) * den(22)
  A(141) = cont_QA(wf(:,28),wf(:,128)) * den(24)
  A(142) = cont_VV(wf(:,30),wf(:,136)) * den(28)
  A(143) = cont_VV(wf(:,4),wf(:,137)) * den(31)
  A(144) = cont_QA(wf(:,35),wf(:,128)) * den(33)
  A(145) = cont_QA(wf(:,26),wf(:,138)) * den(34)
  A(146) = cont_QA(wf(:,38),wf(:,131)) * den(37)
  A(147) = cont_VV(wf(:,4),wf(:,139)) * den(38)
  A(148) = cont_QA(wf(:,41),wf(:,131)) * den(40)
  A(149) = cont_VV(wf(:,4),wf(:,140)) * den(41)
  A(150) = cont_QA(wf(:,24),wf(:,142)) * den(44)
  A(151) = cont_QA(wf(:,144),wf(:,145)) * den(149)
  A(152) = cont_QA(wf(:,144),wf(:,147)) * den(149)
  A(153) = cont_QA(wf(:,144),wf(:,149)) * den(149)
  A(154) = cont_VV(wf(:,4),wf(:,150)) * den(150)
  A(155) = cont_VV(wf(:,4),wf(:,151)) * den(150)
  A(156) = cont_VV(wf(:,4),wf(:,152)) * den(150)
  A(157) = cont_QA(wf(:,130),wf(:,153)) * den(151)
  A(158) = cont_QA(wf(:,154),wf(:,155)) * den(153)
  A(159) = cont_VV(wf(:,23),wf(:,156)) * den(19)
  A(160) = cont_QA(wf(:,16),wf(:,157)) * den(154)
  A(161) = cont_QA(wf(:,154),wf(:,158)) * den(156)
  A(162) = cont_VV(wf(:,4),wf(:,159)) * den(41)
  A(163) = cont_QA(wf(:,44),wf(:,154)) * den(44)
  A(164) = cont_VV(wf(:,4),wf(:,160)) * den(38)
  A(165) = cont_QA(wf(:,14),wf(:,162)) * den(40)
  A(166) = cont_VV(wf(:,32),wf(:,163)) * den(28)
  A(167) = cont_VV(wf(:,4),wf(:,164)) * den(31)
  A(168) = cont_QA(wf(:,18),wf(:,166)) * den(33)
  A(169) = cont_VV(wf(:,11),wf(:,167)) * den(47)
  A(170) = cont_QA(wf(:,50),wf(:,168)) * den(50)
  A(171) = cont_QA(wf(:,53),wf(:,169)) * den(53)
  A(172) = cont_QA(wf(:,170),wf(:,171)) * den(158)
  A(173) = cont_QA(wf(:,172),wf(:,173)) * den(160)
  A(174) = cont_VV(wf(:,47),wf(:,133)) * den(47)
  A(175) = cont_VV(wf(:,21),wf(:,174)) * den(56)
  A(176) = cont_QA(wf(:,58),wf(:,168)) * den(58)
  A(177) = cont_QA(wf(:,61),wf(:,175)) * den(61)
  A(178) = cont_VV(wf(:,30),wf(:,176)) * den(64)
  A(179) = cont_VV(wf(:,9),wf(:,137)) * den(66)
  A(180) = cont_QA(wf(:,66),wf(:,168)) * den(68)
  A(181) = cont_QA(wf(:,68),wf(:,170)) * den(71)
  A(182) = cont_QA(wf(:,61),wf(:,177)) * den(72)
  A(183) = cont_VV(wf(:,9),wf(:,139)) * den(73)
  A(184) = cont_QA(wf(:,71),wf(:,170)) * den(75)
  A(185) = cont_VV(wf(:,9),wf(:,140)) * den(76)
  A(186) = cont_QA(wf(:,59),wf(:,179)) * den(79)
  A(187) = cont_QA(wf(:,181),wf(:,182)) * den(163)
  A(188) = cont_QA(wf(:,181),wf(:,184)) * den(163)
  A(189) = cont_QA(wf(:,181),wf(:,186)) * den(163)
  A(190) = cont_VV(wf(:,9),wf(:,150)) * den(164)
  A(191) = cont_VV(wf(:,9),wf(:,151)) * den(164)
  A(192) = cont_VV(wf(:,9),wf(:,152)) * den(164)
  A(193) = cont_QA(wf(:,187),wf(:,188)) * den(166)
  A(194) = cont_QA(wf(:,173),wf(:,189)) * den(167)
  A(195) = cont_VV(wf(:,56),wf(:,156)) * den(56)
  A(196) = cont_QA(wf(:,187),wf(:,190)) * den(169)
  A(197) = cont_QA(wf(:,53),wf(:,191)) * den(170)
  A(198) = cont_VV(wf(:,9),wf(:,159)) * den(76)
  A(199) = cont_QA(wf(:,73),wf(:,187)) * den(79)
  A(200) = cont_VV(wf(:,9),wf(:,160)) * den(73)
  A(201) = cont_QA(wf(:,51),wf(:,193)) * den(75)
  A(202) = cont_VV(wf(:,64),wf(:,163)) * den(64)
  A(203) = cont_VV(wf(:,9),wf(:,164)) * den(66)
  A(204) = cont_QA(wf(:,49),wf(:,195)) * den(68)
  A(205) = cont_QA(wf(:,75),wf(:,135)) * den(81)
  A(206) = cont_QA(wf(:,77),wf(:,169)) * den(83)
  A(207) = cont_QA(wf(:,75),wf(:,138)) * den(84)
  A(208) = cont_QA(wf(:,79),wf(:,172)) * den(87)
  A(209) = cont_QA(wf(:,74),wf(:,142)) * den(88)
  A(210) = cont_QA(wf(:,81),wf(:,127)) * den(90)
  A(211) = cont_QA(wf(:,83),wf(:,175)) * den(92)
  A(212) = cont_QA(wf(:,85),wf(:,129)) * den(95)
  A(213) = cont_QA(wf(:,83),wf(:,177)) * den(96)
  A(214) = cont_QA(wf(:,82),wf(:,179)) * den(97)
  A(215) = cont_QA(wf(:,81),wf(:,157)) * den(98)
  A(216) = cont_QA(wf(:,79),wf(:,189)) * den(99)
  A(217) = cont_QA(wf(:,80),wf(:,162)) * den(100)
  A(218) = cont_QA(wf(:,85),wf(:,153)) * den(101)
  A(219) = cont_QA(wf(:,77),wf(:,191)) * den(102)
  A(220) = cont_QA(wf(:,76),wf(:,193)) * den(103)
  A(221) = cont_QA(wf(:,84),wf(:,166)) * den(104)
  A(222) = cont_QA(wf(:,78),wf(:,195)) * den(105)
  A(223) = cont_QA(wf(:,171),wf(:,196)) * den(171)
  A(224) = cont_QA(wf(:,155),wf(:,197)) * den(172)
  A(225) = cont_VV(wf(:,88),wf(:,198)) * den(174)
  A(226) = cont_VV(wf(:,88),wf(:,198)) * den(174)
  A(227) = cont_QA(wf(:,50),wf(:,199)) * den(175)
  A(228) = cont_QA(wf(:,158),wf(:,197)) * den(176)
  A(229) = cont_VV(wf(:,117),wf(:,200)) * den(178)
  A(230) = cont_VV(wf(:,117),wf(:,200)) * den(178)
  A(231) = cont_QA(wf(:,44),wf(:,197)) * den(88)
  A(232) = cont_VV(wf(:,118),wf(:,200)) * den(179)
  A(233) = cont_VV(wf(:,118),wf(:,200)) * den(179)
  A(234) = cont_QA(wf(:,48),wf(:,202)) * den(181)
  A(235) = cont_QA(wf(:,48),wf(:,202)) * den(181)
  A(236) = cont_VV(wf(:,92),wf(:,203)) * den(183)
  A(237) = cont_VV(wf(:,92),wf(:,203)) * den(183)
  A(238) = cont_VV(wf(:,121),wf(:,200)) * den(184)
  A(239) = cont_VV(wf(:,121),wf(:,200)) * den(184)
  A(240) = cont_QA(wf(:,52),wf(:,205)) * den(186)
  A(241) = cont_QA(wf(:,52),wf(:,205)) * den(186)
  A(242) = cont_QA(wf(:,188),wf(:,206)) * den(187)
  A(243) = cont_QA(wf(:,132),wf(:,207)) * den(188)
  A(244) = cont_VV(wf(:,88),wf(:,208)) * den(190)
  A(245) = cont_VV(wf(:,88),wf(:,208)) * den(190)
  A(246) = cont_QA(wf(:,190),wf(:,206)) * den(191)
  A(247) = cont_QA(wf(:,19),wf(:,209)) * den(192)
  A(248) = cont_VV(wf(:,117),wf(:,210)) * den(194)
  A(249) = cont_VV(wf(:,117),wf(:,210)) * den(194)
  A(250) = cont_QA(wf(:,73),wf(:,206)) * den(97)
  A(251) = cont_VV(wf(:,118),wf(:,210)) * den(195)
  A(252) = cont_VV(wf(:,118),wf(:,210)) * den(195)
  A(253) = cont_QA(wf(:,17),wf(:,212)) * den(197)
  A(254) = cont_QA(wf(:,17),wf(:,212)) * den(197)
  A(255) = cont_VV(wf(:,92),wf(:,213)) * den(199)
  A(256) = cont_VV(wf(:,92),wf(:,213)) * den(199)
  A(257) = cont_VV(wf(:,121),wf(:,210)) * den(200)
  A(258) = cont_VV(wf(:,121),wf(:,210)) * den(200)
  A(259) = cont_QA(wf(:,15),wf(:,215)) * den(202)
  A(260) = cont_QA(wf(:,15),wf(:,215)) * den(202)
  A(261) = cont_QA(wf(:,58),wf(:,199)) * den(203)
  A(262) = cont_QA(wf(:,38),wf(:,207)) * den(204)
  A(263) = cont_VV(wf(:,115),wf(:,216)) * den(206)
  A(264) = cont_VV(wf(:,115),wf(:,216)) * den(206)
  A(265) = cont_QA(wf(:,41),wf(:,207)) * den(100)
  A(266) = cont_VV(wf(:,119),wf(:,216)) * den(207)
  A(267) = cont_VV(wf(:,119),wf(:,216)) * den(207)
  A(268) = cont_QA(wf(:,57),wf(:,202)) * den(208)
  A(269) = cont_QA(wf(:,57),wf(:,202)) * den(208)
  A(270) = cont_QA(wf(:,68),wf(:,196)) * den(209)
  A(271) = cont_QA(wf(:,28),wf(:,209)) * den(210)
  A(272) = cont_VV(wf(:,115),wf(:,217)) * den(212)
  A(273) = cont_VV(wf(:,115),wf(:,217)) * den(212)
  A(274) = cont_QA(wf(:,71),wf(:,196)) * den(103)
  A(275) = cont_VV(wf(:,119),wf(:,217)) * den(213)
  A(276) = cont_VV(wf(:,119),wf(:,217)) * den(213)
  A(277) = cont_QA(wf(:,27),wf(:,212)) * den(214)
  A(278) = cont_QA(wf(:,27),wf(:,212)) * den(214)
  A(279) = cont_VV(wf(:,112),wf(:,218)) * den(216)
  A(280) = cont_VV(wf(:,112),wf(:,218)) * den(216)
  A(281) = cont_QA(wf(:,35),wf(:,209)) * den(104)
  A(282) = cont_VV(wf(:,112),wf(:,219)) * den(218)
  A(283) = cont_VV(wf(:,112),wf(:,219)) * den(218)
  A(284) = cont_QA(wf(:,66),wf(:,199)) * den(105)
  A(285) = cont_QA(wf(:,66),wf(:,201)) * den(219)
  A(286) = cont_QA(wf(:,66),wf(:,201)) * den(219)
  A(287) = cont_QA(wf(:,34),wf(:,212)) * den(220)
  A(288) = cont_QA(wf(:,34),wf(:,212)) * den(220)
  A(289) = cont_VV(wf(:,122),wf(:,218)) * den(221)
  A(290) = cont_VV(wf(:,122),wf(:,218)) * den(221)
  A(291) = cont_QA(wf(:,67),wf(:,205)) * den(222)
  A(292) = cont_QA(wf(:,67),wf(:,205)) * den(222)
  A(293) = cont_VV(wf(:,122),wf(:,219)) * den(223)
  A(294) = cont_VV(wf(:,122),wf(:,219)) * den(223)
  A(295) = cont_QA(wf(:,37),wf(:,215)) * den(224)
  A(296) = cont_QA(wf(:,37),wf(:,215)) * den(224)
  A(297) = cont_QA(wf(:,71),wf(:,204)) * den(225)
  A(298) = cont_QA(wf(:,71),wf(:,204)) * den(225)
  A(299) = cont_QA(wf(:,40),wf(:,215)) * den(226)
  A(300) = cont_QA(wf(:,40),wf(:,215)) * den(226)
  A(301) = cont_VV(wf(:,96),wf(:,220)) * den(228)
  A(302) = cont_VV(wf(:,96),wf(:,220)) * den(228)
  A(303) = cont_VV(wf(:,124),wf(:,216)) * den(229)
  A(304) = cont_VV(wf(:,124),wf(:,216)) * den(229)
  A(305) = cont_QA(wf(:,60),wf(:,222)) * den(231)
  A(306) = cont_QA(wf(:,60),wf(:,222)) * den(231)
  A(307) = cont_VV(wf(:,96),wf(:,223)) * den(233)
  A(308) = cont_VV(wf(:,96),wf(:,223)) * den(233)
  A(309) = cont_VV(wf(:,124),wf(:,217)) * den(234)
  A(310) = cont_VV(wf(:,124),wf(:,217)) * den(234)
  A(311) = cont_QA(wf(:,25),wf(:,225)) * den(236)
  A(312) = cont_QA(wf(:,25),wf(:,225)) * den(236)
  A(313) = cont_VV(wf(:,125),wf(:,218)) * den(237)
  A(314) = cont_VV(wf(:,125),wf(:,218)) * den(237)
  A(315) = cont_QA(wf(:,69),wf(:,222)) * den(238)
  A(316) = cont_QA(wf(:,69),wf(:,222)) * den(238)
  A(317) = cont_VV(wf(:,125),wf(:,219)) * den(239)
  A(318) = cont_VV(wf(:,125),wf(:,219)) * den(239)
  A(319) = cont_QA(wf(:,36),wf(:,225)) * den(240)
  A(320) = cont_QA(wf(:,36),wf(:,225)) * den(240)
  A(321) = cont_QA(wf(:,73),wf(:,221)) * den(241)
  A(322) = cont_QA(wf(:,73),wf(:,221)) * den(241)
  A(323) = cont_QA(wf(:,43),wf(:,225)) * den(242)
  A(324) = cont_QA(wf(:,43),wf(:,225)) * den(242)
  A(325) = cont_QA(wf(:,130),wf(:,226)) * den(243)
  A(326) = cont_VV(wf(:,33),wf(:,103)) * den(244)
  A(327) = cont_VV(wf(:,30),wf(:,229)) * den(28)
  A(328) = cont_QA(wf(:,16),wf(:,230)) * den(245)
  A(329) = cont_VV(wf(:,39),wf(:,103)) * den(246)
  A(330) = cont_QA(wf(:,26),wf(:,231)) * den(247)
  A(331) = cont_VV(wf(:,42),wf(:,103)) * den(248)
  A(332) = cont_QA(wf(:,26),wf(:,232)) * den(34)
  A(333) = cont_QA(wf(:,14),wf(:,234)) * den(37)
  A(334) = cont_VV(wf(:,21),wf(:,237)) * den(19)
  A(335) = cont_QA(wf(:,26),wf(:,238)) * den(22)
  A(336) = cont_QA(wf(:,18),wf(:,240)) * den(24)
  A(337) = cont_VV(wf(:,11),wf(:,243)) * den(9)
  A(338) = cont_QA(wf(:,16),wf(:,244)) * den(12)
  A(339) = cont_QA(wf(:,18),wf(:,246)) * den(15)
  A(340) = cont_QA(wf(:,75),wf(:,231)) * den(249)
  A(341) = cont_QA(wf(:,75),wf(:,232)) * den(84)
  A(342) = cont_QA(wf(:,48),wf(:,248)) * den(87)
  A(343) = cont_QA(wf(:,75),wf(:,238)) * den(81)
  A(344) = cont_QA(wf(:,52),wf(:,250)) * den(83)
  A(345) = cont_QA(wf(:,81),wf(:,230)) * den(250)
  A(346) = cont_QA(wf(:,81),wf(:,233)) * den(98)
  A(347) = cont_QA(wf(:,57),wf(:,248)) * den(99)
  A(348) = cont_QA(wf(:,85),wf(:,226)) * den(251)
  A(349) = cont_QA(wf(:,66),wf(:,247)) * den(105)
  A(350) = cont_QA(wf(:,85),wf(:,239)) * den(101)
  A(351) = cont_QA(wf(:,67),wf(:,250)) * den(102)
  A(352) = cont_QA(wf(:,71),wf(:,249)) * den(103)
  A(353) = cont_QA(wf(:,81),wf(:,244)) * den(90)
  A(354) = cont_QA(wf(:,60),wf(:,252)) * den(92)
  A(355) = cont_QA(wf(:,85),wf(:,245)) * den(95)
  A(356) = cont_QA(wf(:,69),wf(:,252)) * den(96)
  A(357) = cont_QA(wf(:,73),wf(:,251)) * den(97)
  A(358) = cont_VV(wf(:,11),wf(:,253)) * den(47)
  A(359) = cont_QA(wf(:,50),wf(:,254)) * den(50)
  A(360) = cont_QA(wf(:,52),wf(:,256)) * den(53)
  A(361) = cont_VV(wf(:,21),wf(:,257)) * den(56)
  A(362) = cont_QA(wf(:,58),wf(:,254)) * den(58)
  A(363) = cont_QA(wf(:,60),wf(:,259)) * den(61)
  A(364) = cont_VV(wf(:,30),wf(:,260)) * den(64)
  A(365) = cont_QA(wf(:,66),wf(:,254)) * den(68)
  A(366) = cont_VV(wf(:,33),wf(:,106)) * den(66)
  A(367) = cont_QA(wf(:,68),wf(:,255)) * den(71)
  A(368) = cont_QA(wf(:,69),wf(:,259)) * den(72)
  A(369) = cont_QA(wf(:,71),wf(:,255)) * den(75)
  A(370) = cont_VV(wf(:,39),wf(:,106)) * den(73)
  A(371) = cont_QA(wf(:,73),wf(:,258)) * den(79)
  A(372) = cont_VV(wf(:,42),wf(:,106)) * den(76)
  A(373) = cont_VV(wf(:,33),wf(:,107)) * den(252)
  A(374) = cont_QA(wf(:,173),wf(:,261)) * den(253)
  A(375) = cont_VV(wf(:,30),wf(:,264)) * den(64)
  A(376) = cont_VV(wf(:,39),wf(:,107)) * den(254)
  A(377) = cont_QA(wf(:,53),wf(:,265)) * den(255)
  A(378) = cont_VV(wf(:,42),wf(:,107)) * den(256)
  A(379) = cont_QA(wf(:,61),wf(:,266)) * den(257)
  A(380) = cont_QA(wf(:,51),wf(:,268)) * den(71)
  A(381) = cont_QA(wf(:,61),wf(:,269)) * den(72)
  A(382) = cont_VV(wf(:,21),wf(:,272)) * den(56)
  A(383) = cont_QA(wf(:,49),wf(:,274)) * den(58)
  A(384) = cont_QA(wf(:,61),wf(:,275)) * den(61)
  A(385) = cont_VV(wf(:,11),wf(:,278)) * den(47)
  A(386) = cont_QA(wf(:,49),wf(:,280)) * den(50)
  A(387) = cont_QA(wf(:,53),wf(:,281)) * den(53)
  A(388) = cont_QA(wf(:,83),wf(:,266)) * den(258)
  A(389) = cont_QA(wf(:,17),wf(:,283)) * den(95)
  A(390) = cont_QA(wf(:,83),wf(:,269)) * den(96)
  A(391) = cont_QA(wf(:,15),wf(:,285)) * den(90)
  A(392) = cont_QA(wf(:,83),wf(:,275)) * den(92)
  A(393) = cont_QA(wf(:,77),wf(:,265)) * den(259)
  A(394) = cont_QA(wf(:,27),wf(:,283)) * den(101)
  A(395) = cont_QA(wf(:,77),wf(:,267)) * den(102)
  A(396) = cont_QA(wf(:,79),wf(:,261)) * den(260)
  A(397) = cont_QA(wf(:,35),wf(:,282)) * den(104)
  A(398) = cont_QA(wf(:,37),wf(:,285)) * den(98)
  A(399) = cont_QA(wf(:,79),wf(:,273)) * den(99)
  A(400) = cont_QA(wf(:,41),wf(:,284)) * den(100)
  A(401) = cont_QA(wf(:,25),wf(:,287)) * den(81)
  A(402) = cont_QA(wf(:,77),wf(:,281)) * den(83)
  A(403) = cont_QA(wf(:,36),wf(:,287)) * den(84)
  A(404) = cont_QA(wf(:,79),wf(:,279)) * den(87)
  A(405) = cont_QA(wf(:,44),wf(:,286)) * den(88)
  A(406) = cont_VV(wf(:,11),wf(:,288)) * den(9)
  A(407) = cont_QA(wf(:,15),wf(:,290)) * den(12)
  A(408) = cont_QA(wf(:,19),wf(:,291)) * den(15)
  A(409) = cont_VV(wf(:,21),wf(:,292)) * den(19)
  A(410) = cont_QA(wf(:,25),wf(:,294)) * den(22)
  A(411) = cont_QA(wf(:,28),wf(:,291)) * den(24)
  A(412) = cont_VV(wf(:,30),wf(:,295)) * den(28)
  A(413) = cont_VV(wf(:,33),wf(:,110)) * den(31)
  A(414) = cont_QA(wf(:,35),wf(:,291)) * den(33)
  A(415) = cont_QA(wf(:,36),wf(:,294)) * den(34)
  A(416) = cont_QA(wf(:,38),wf(:,289)) * den(37)
  A(417) = cont_VV(wf(:,39),wf(:,110)) * den(38)
  A(418) = cont_QA(wf(:,41),wf(:,289)) * den(40)
  A(419) = cont_VV(wf(:,42),wf(:,110)) * den(41)
  A(420) = cont_QA(wf(:,44),wf(:,293)) * den(44)
  A(421) = cont_QA(wf(:,144),wf(:,297)) * den(263)
  A(422) = cont_QA(wf(:,299),wf(:,300)) * den(267)
  A(423) = cont_VV(wf(:,13),wf(:,301)) * den(270)
  A(424) = cont_QA(wf(:,132),wf(:,303)) * den(272)
  A(425) = cont_QA(wf(:,19),wf(:,304)) * den(273)
  A(426) = cont_QA(wf(:,130),wf(:,306)) * den(275)
  A(427) = cont_QA(wf(:,16),wf(:,307)) * den(276)
  A(428) = cont_QA(wf(:,132),wf(:,308)) * den(277)
  A(429) = cont_QA(wf(:,130),wf(:,309)) * den(278)
  A(430) = cont_QA(wf(:,144),wf(:,311)) * den(281)
  A(431) = cont_QA(wf(:,313),wf(:,314)) * den(285)
  A(432) = cont_VV(wf(:,23),wf(:,315)) * den(288)
  A(433) = cont_QA(wf(:,155),wf(:,316)) * den(289)
  A(434) = cont_QA(wf(:,28),wf(:,304)) * den(290)
  A(435) = cont_QA(wf(:,130),wf(:,318)) * den(292)
  A(436) = cont_QA(wf(:,26),wf(:,319)) * den(293)
  A(437) = cont_QA(wf(:,155),wf(:,320)) * den(294)
  A(438) = cont_QA(wf(:,130),wf(:,321)) * den(295)
  A(439) = cont_QA(wf(:,144),wf(:,323)) * den(298)
  A(440) = cont_QA(wf(:,325),wf(:,326)) * den(302)
  A(441) = cont_VV(wf(:,32),wf(:,327)) * den(305)
  A(442) = cont_VV(wf(:,33),wf(:,328)) * den(306)
  A(443) = cont_QA(wf(:,35),wf(:,304)) * den(307)
  A(444) = cont_QA(wf(:,130),wf(:,329)) * den(309)
  A(445) = cont_VV(wf(:,33),wf(:,330)) * den(310)
  A(446) = cont_QA(wf(:,130),wf(:,331)) * den(311)
  A(447) = cont_VV(wf(:,4),wf(:,332)) * den(312)
  A(448) = cont_QA(wf(:,158),wf(:,316)) * den(313)
  A(449) = cont_QA(wf(:,38),wf(:,303)) * den(314)
  A(450) = cont_QA(wf(:,16),wf(:,334)) * den(316)
  A(451) = cont_QA(wf(:,26),wf(:,335)) * den(317)
  A(452) = cont_QA(wf(:,158),wf(:,320)) * den(318)
  A(453) = cont_QA(wf(:,16),wf(:,336)) * den(319)
  A(454) = cont_VV(wf(:,39),wf(:,328)) * den(320)
  A(455) = cont_QA(wf(:,41),wf(:,303)) * den(321)
  A(456) = cont_QA(wf(:,16),wf(:,337)) * den(323)
  A(457) = cont_VV(wf(:,39),wf(:,330)) * den(324)
  A(458) = cont_QA(wf(:,16),wf(:,338)) * den(325)
  A(459) = cont_VV(wf(:,4),wf(:,339)) * den(326)
  A(460) = cont_VV(wf(:,42),wf(:,328)) * den(327)
  A(461) = cont_QA(wf(:,44),wf(:,316)) * den(328)
  A(462) = cont_VV(wf(:,42),wf(:,330)) * den(329)
  A(463) = cont_QA(wf(:,26),wf(:,340)) * den(330)
  A(464) = cont_QA(wf(:,26),wf(:,341)) * den(332)
  A(465) = cont_VV(wf(:,4),wf(:,342)) * den(333)
  A(466) = cont_QA(wf(:,344),wf(:,345)) * den(337)
  A(467) = cont_QA(wf(:,181),wf(:,347)) * den(340)
  A(468) = cont_VV(wf(:,47),wf(:,301)) * den(342)
  A(469) = cont_QA(wf(:,173),wf(:,349)) * den(344)
  A(470) = cont_QA(wf(:,53),wf(:,350)) * den(345)
  A(471) = cont_QA(wf(:,171),wf(:,352)) * den(347)
  A(472) = cont_QA(wf(:,50),wf(:,353)) * den(348)
  A(473) = cont_QA(wf(:,173),wf(:,354)) * den(349)
  A(474) = cont_QA(wf(:,171),wf(:,355)) * den(350)
  A(475) = cont_QA(wf(:,357),wf(:,358)) * den(354)
  A(476) = cont_QA(wf(:,181),wf(:,360)) * den(357)
  A(477) = cont_VV(wf(:,56),wf(:,315)) * den(359)
  A(478) = cont_QA(wf(:,173),wf(:,362)) * den(361)
  A(479) = cont_QA(wf(:,61),wf(:,363)) * den(362)
  A(480) = cont_QA(wf(:,188),wf(:,364)) * den(363)
  A(481) = cont_QA(wf(:,58),wf(:,353)) * den(364)
  A(482) = cont_QA(wf(:,173),wf(:,365)) * den(365)
  A(483) = cont_QA(wf(:,188),wf(:,366)) * den(366)
  A(484) = cont_QA(wf(:,368),wf(:,369)) * den(370)
  A(485) = cont_QA(wf(:,181),wf(:,371)) * den(373)
  A(486) = cont_VV(wf(:,64),wf(:,327)) * den(375)
  A(487) = cont_VV(wf(:,33),wf(:,372)) * den(376)
  A(488) = cont_QA(wf(:,173),wf(:,373)) * den(377)
  A(489) = cont_VV(wf(:,33),wf(:,374)) * den(378)
  A(490) = cont_QA(wf(:,173),wf(:,375)) * den(379)
  A(491) = cont_QA(wf(:,66),wf(:,353)) * den(380)
  A(492) = cont_VV(wf(:,9),wf(:,332)) * den(381)
  A(493) = cont_QA(wf(:,53),wf(:,377)) * den(383)
  A(494) = cont_QA(wf(:,61),wf(:,378)) * den(384)
  A(495) = cont_QA(wf(:,190),wf(:,364)) * den(385)
  A(496) = cont_QA(wf(:,68),wf(:,352)) * den(386)
  A(497) = cont_QA(wf(:,53),wf(:,379)) * den(387)
  A(498) = cont_QA(wf(:,190),wf(:,366)) * den(388)
  A(499) = cont_VV(wf(:,39),wf(:,372)) * den(389)
  A(500) = cont_QA(wf(:,53),wf(:,380)) * den(390)
  A(501) = cont_VV(wf(:,39),wf(:,374)) * den(391)
  A(502) = cont_QA(wf(:,53),wf(:,381)) * den(392)
  A(503) = cont_QA(wf(:,71),wf(:,352)) * den(393)
  A(504) = cont_VV(wf(:,9),wf(:,339)) * den(394)
  A(505) = cont_VV(wf(:,42),wf(:,372)) * den(395)
  A(506) = cont_VV(wf(:,42),wf(:,374)) * den(396)
  A(507) = cont_QA(wf(:,61),wf(:,382)) * den(397)
  A(508) = cont_QA(wf(:,61),wf(:,383)) * den(398)
  A(509) = cont_QA(wf(:,73),wf(:,364)) * den(399)
  A(510) = cont_VV(wf(:,9),wf(:,342)) * den(400)
  A(511) = cont_QA(wf(:,155),wf(:,384)) * den(401)
  A(512) = cont_QA(wf(:,77),wf(:,350)) * den(402)
  A(513) = cont_QA(wf(:,171),wf(:,385)) * den(403)
  A(514) = cont_QA(wf(:,75),wf(:,319)) * den(404)
  A(515) = cont_QA(wf(:,155),wf(:,386)) * den(405)
  A(516) = cont_QA(wf(:,171),wf(:,387)) * den(406)
  A(517) = cont_QA(wf(:,158),wf(:,384)) * den(407)
  A(518) = cont_QA(wf(:,79),wf(:,349)) * den(408)
  A(519) = cont_QA(wf(:,50),wf(:,388)) * den(409)
  A(520) = cont_QA(wf(:,75),wf(:,335)) * den(410)
  A(521) = cont_QA(wf(:,158),wf(:,386)) * den(411)
  A(522) = cont_QA(wf(:,50),wf(:,389)) * den(412)
  A(523) = cont_QA(wf(:,44),wf(:,384)) * den(413)
  A(524) = cont_QA(wf(:,75),wf(:,340)) * den(414)
  A(525) = cont_QA(wf(:,75),wf(:,341)) * den(415)
  A(526) = cont_QA(wf(:,132),wf(:,390)) * den(416)
  A(527) = cont_QA(wf(:,83),wf(:,363)) * den(417)
  A(528) = cont_QA(wf(:,188),wf(:,391)) * den(418)
  A(529) = cont_QA(wf(:,81),wf(:,307)) * den(419)
  A(530) = cont_QA(wf(:,132),wf(:,392)) * den(420)
  A(531) = cont_QA(wf(:,188),wf(:,393)) * den(421)
  A(532) = cont_QA(wf(:,19),wf(:,394)) * den(422)
  A(533) = cont_QA(wf(:,83),wf(:,378)) * den(423)
  A(534) = cont_QA(wf(:,190),wf(:,391)) * den(424)
  A(535) = cont_QA(wf(:,85),wf(:,306)) * den(425)
  A(536) = cont_QA(wf(:,19),wf(:,395)) * den(426)
  A(537) = cont_QA(wf(:,190),wf(:,393)) * den(427)
  A(538) = cont_QA(wf(:,83),wf(:,382)) * den(428)
  A(539) = cont_QA(wf(:,83),wf(:,383)) * den(429)
  A(540) = cont_QA(wf(:,73),wf(:,391)) * den(430)
  A(541) = cont_QA(wf(:,38),wf(:,390)) * den(431)
  A(542) = cont_QA(wf(:,79),wf(:,362)) * den(432)
  A(543) = cont_QA(wf(:,58),wf(:,388)) * den(433)
  A(544) = cont_QA(wf(:,81),wf(:,334)) * den(434)
  A(545) = cont_QA(wf(:,38),wf(:,392)) * den(435)
  A(546) = cont_QA(wf(:,58),wf(:,389)) * den(436)
  A(547) = cont_QA(wf(:,41),wf(:,390)) * den(437)
  A(548) = cont_QA(wf(:,81),wf(:,338)) * den(438)
  A(549) = cont_QA(wf(:,81),wf(:,337)) * den(439)
  A(550) = cont_QA(wf(:,28),wf(:,394)) * den(440)
  A(551) = cont_QA(wf(:,77),wf(:,377)) * den(441)
  A(552) = cont_QA(wf(:,68),wf(:,385)) * den(442)
  A(553) = cont_QA(wf(:,85),wf(:,318)) * den(443)
  A(554) = cont_QA(wf(:,28),wf(:,395)) * den(444)
  A(555) = cont_QA(wf(:,68),wf(:,387)) * den(445)
  A(556) = cont_QA(wf(:,77),wf(:,381)) * den(446)
  A(557) = cont_QA(wf(:,77),wf(:,380)) * den(447)
  A(558) = cont_QA(wf(:,71),wf(:,385)) * den(448)
  A(559) = cont_QA(wf(:,35),wf(:,394)) * den(449)
  A(560) = cont_QA(wf(:,85),wf(:,331)) * den(450)
  A(561) = cont_QA(wf(:,85),wf(:,329)) * den(451)
  A(562) = cont_QA(wf(:,79),wf(:,375)) * den(452)
  A(563) = cont_QA(wf(:,79),wf(:,373)) * den(453)
  A(564) = cont_QA(wf(:,66),wf(:,388)) * den(454)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(564)
  complex(REALKIND), intent(out) :: M1(6), M2(11)

  M1(1) = (A(1)-A(2)+A(4)-A(5)+A(9)+A(14)+A(20)+A(29)+A(32)+A(35)+A(44)+A(45))*f(3)+CI*(A(7)+A(15)+A(28)+A(36)+A(46)+A(53))*f(4)
  M1(2) = (A(2)-A(3)+A(5)-A(6)+A(8)-A(18)-A(20)+A(27)-A(33)-A(35)+A(42)+A(43))*f(3)+CI*(-A(7)+A(19)+A(25)-A(36)-A(46)+A(49))*f(4)
  M1(3) = (-A(1)+A(3)-A(4)+A(6)+A(12)-A(14)+A(18)-A(29)+A(31)+A(33)+A(50)+A(51))*f(3)+CI*(A(10)-A(15)-A(28)+A(34)+A(52) &
       -A(53))*f(4)
  M1(4) = (A(2)-A(3)+A(5)-A(6)+A(11)-A(18)-A(20)+A(24)-A(33)-A(35)+A(37)+A(38))*f(3)+CI*(-A(10)+A(21)+A(22)-A(34)+A(41) &
       -A(52))*f(4)
  M1(5) = (-A(1)+A(3)-A(4)+A(6)-A(14)+A(17)+A(18)+A(26)-A(29)+A(33)+A(47)+A(48))*f(3)+CI*(A(13)-A(19)-A(25)+A(30)-A(49) &
       +A(54))*f(4)
  M1(6) = (A(1)-A(2)+A(4)-A(5)+A(14)+A(16)+A(20)+A(23)+A(29)+A(35)+A(39)+A(40))*f(3)+CI*(-A(13)-A(21)-A(22)-A(30)-A(41) &
       -A(54))*f(4)

  M2( 1) = (A(58)-A(59)+A(64)-A(65)-A(70)+A(72)+A(77)-A(78)-A(104)+A(106)-A(108)+A(114)+A(116)+A(118)+A(124)-A(126)+A(128)-A(132) &
        +A(254)+A(256)+A(316))*f(1)+CI*(A(249)+A(252)+A(258)+A(280)+A(288)+A(290)+A(314)+A(322))*f(2)+(-A(151)+A(152)-A(154) &
        +A(155)-A(187)+A(188)-A(190)+A(191)-A(425)-A(426)-A(429)-A(442)-A(445)-A(447)-A(460)-A(462)-A(465)-A(487)-A(489)-A(492) &
        -A(494)-A(495)-A(498)-A(505)-A(506)-A(510)-A(532)-A(533)-A(534)-A(535)-A(536)-A(537))*f(5)+CI*(-A(421)-A(422)-A(423) &
        -A(443)-A(444)-A(446)-A(484)-A(485)-A(486)-A(507)-A(508)-A(509)-A(538)-A(539)-A(540)-A(559)-A(560)-A(561))*f(6)+(A(91) &
        -A(92)+A(97)-A(98)+A(135)+A(136)+A(182)+A(196)+A(212)+A(213)+A(326)+A(331)+A(339)+A(355)+A(356)+A(373)+A(378)+A(381) &
        +A(389)+A(390))*f(7)+CI*(A(133)+A(144)+A(178)+A(199)+A(325)+A(337)+A(348)+A(357)+A(375)+A(379)+A(388)+A(397))*f(8)+(A(94) &
        -A(95)+A(100)-A(101)+A(246)+A(247)+A(366)+A(368)+A(372)+A(408)+A(413)+A(419))*f(9)+CI*(A(250)+A(281)+A(364)+A(371)+A(406) &
        +A(414))*f(10)+(A(143)+A(149)+A(162)+A(167)+A(179)+A(185)+A(198)+A(203))*f(11)+CI*(A(138)+A(168)+A(186)+A(202)+A(214) &
        +A(221))*f(12)+(-A(79)-A(80)-A(85)-A(86))*f(13)+2*(A(81)+A(87))*f(13)+(19*(A(82)+A(83)+A(88)+A(89))*f(14))/2._/**/REALKIND &
        +18*(-A(84)-A(90))*f(14)+(A(55)-A(56)+A(61)-A(62)-A(67)+A(69)+A(74)-A(75)-A(103)+A(105)-A(107)+A(113)+A(115)+A(117)+A(123) &
        -A(125)+A(127)-A(131)+A(253)+A(255)+A(315))*f(23)+CI*(A(248)+A(251)+A(257)+A(279)+A(287)+A(289)+A(313)+A(321))*f(24)
  M2( 2) = (A(59)-A(60)-A(64)+A(66)+A(70)-A(71)+A(76)-A(77)-A(110)-A(112)-A(114)-A(116)-A(118)-A(120)-A(122)-A(124)-A(128)-A(130) &
        +A(245)+A(260)+A(306))*f(1)+CI*(-A(249)-A(252)-A(258)+A(264)+A(267)+A(300)+A(304)-A(322))*f(2)+(-A(152)+A(153)-A(155) &
        +A(156)-A(188)+A(189)-A(191)+A(192)-A(424)-A(427)-A(428)+A(454)+A(457)+A(459)+A(460)+A(462)+A(465)-A(479)-A(480)-A(483) &
        +A(499)+A(501)+A(504)+A(505)+A(506)+A(510)-A(526)-A(527)-A(528)-A(529)-A(530)-A(531))*f(5)+CI*(A(421)+A(422)+A(423)-A(455) &
        -A(456)-A(458)-A(475)-A(476)-A(477)+A(507)+A(508)+A(509)+A(538)+A(539)+A(540)-A(547)-A(548)-A(549))*f(6)+(A(92)-A(93) &
        +A(98)-A(99)+A(134)+A(137)+A(177)+A(193)+A(210)+A(211)-A(329)-A(331)+A(338)+A(353)+A(354)-A(376)-A(378)+A(384)+A(391) &
        +A(392))*f(7)+CI*(-A(133)+A(148)+A(175)-A(199)+A(328)-A(337)+A(345)-A(357)-A(379)+A(382)-A(388)+A(400))*f(8)+(A(95)-A(96) &
        +A(101)-A(102)+A(242)+A(243)+A(363)-A(370)-A(372)+A(407)-A(417)-A(419))*f(9)+CI*(-A(250)+A(265)+A(361)-A(371)-A(406) &
        +A(418))*f(10)+(-A(147)-A(149)-A(162)-A(164)-A(183)-A(185)-A(198)-A(200))*f(11)+CI*(-A(138)+A(165)-A(186)+A(195)-A(214) &
        +A(217))*f(12)+2*(A(79)+A(85))*f(13)+(-A(80)-A(81)-A(86)-A(87))*f(13)+18*(-A(82)-A(88))*f(14)+(19*(A(83)+A(84)+A(89) &
        +A(90))*f(14))/2._/**/REALKIND+(A(56)-A(57)-A(61)+A(63)+A(67)-A(68)+A(73)-A(74)-A(109)-A(111)-A(113)-A(115)-A(117)-A(119) &
        -A(121)-A(123)-A(127)-A(129)+A(244)+A(259)+A(305))*f(23)+CI*(-A(248)-A(251)-A(257)+A(263)+A(266)+A(299)+A(303) &
        -A(321))*f(24)
  M2( 3) = (-A(58)+A(60)+A(65)-A(66)+A(71)-A(72)-A(76)+A(78)+A(104)-A(106)+A(108)+A(110)+A(112)+A(120)+A(122)+A(126)+A(130)+A(132) &
        +A(278)+A(292)+A(308))*f(1)+CI*(A(273)+A(276)-A(280)-A(288)-A(290)+A(298)+A(310)-A(314))*f(2)+(A(151)-A(153)+A(154)-A(156) &
        +A(187)-A(189)+A(190)-A(192)-A(434)-A(435)-A(438)+A(442)+A(445)+A(447)-A(454)-A(457)-A(459)+A(487)+A(489)+A(492)-A(493) &
        -A(496)-A(497)-A(499)-A(501)-A(504)-A(550)-A(551)-A(552)-A(553)-A(554)-A(555))*f(5)+CI*(-A(430)-A(431)-A(432)+A(443) &
        +A(444)+A(446)+A(484)+A(485)+A(486)-A(500)-A(502)-A(503)-A(556)-A(557)-A(558)+A(559)+A(560)+A(561))*f(6)+(-A(91)+A(93) &
        -A(97)+A(99)+A(141)+A(157)+A(181)+A(197)+A(218)+A(219)-A(326)+A(329)+A(336)+A(350)+A(351)-A(373)+A(376)+A(380)+A(394) &
        +A(395))*f(7)+CI*(A(139)-A(144)-A(178)+A(184)-A(325)+A(334)-A(348)+A(352)-A(375)+A(377)+A(393)-A(397))*f(8)+(-A(94)+A(96) &
        -A(100)+A(102)+A(270)+A(271)-A(366)+A(367)+A(370)+A(411)-A(413)+A(417))*f(9)+CI*(A(274)-A(281)-A(364)+A(369)+A(409) &
        -A(414))*f(10)+(-A(143)+A(147)+A(164)-A(167)-A(179)+A(183)+A(200)-A(203))*f(11)+CI*(A(159)-A(168)+A(201)-A(202)+A(220) &
        -A(221))*f(12)+2*(A(80)+A(86))*f(13)+(-A(79)-A(81)-A(85)-A(87))*f(13)+18*(-A(83)-A(89))*f(14)+(19*(A(82)+A(84)+A(88) &
        +A(90))*f(14))/2._/**/REALKIND+(-A(55)+A(57)+A(62)-A(63)+A(68)-A(69)-A(73)+A(75)+A(103)-A(105)+A(107)+A(109)+A(111)+A(119) &
        +A(121)+A(125)+A(129)+A(131)+A(277)+A(291)+A(307))*f(23)+CI*(A(272)+A(275)-A(279)-A(287)-A(289)+A(297)+A(309) &
        -A(313))*f(24)
  M2( 4) = (A(59)-A(60)-A(64)+A(66)+A(70)-A(71)+A(76)-A(77)-A(110)-A(112)-A(114)-A(116)-A(118)-A(120)-A(122)-A(124)-A(128)-A(130) &
        +A(226)+A(241)+A(312))*f(1)+CI*(A(230)+A(233)+A(239)-A(273)-A(276)-A(298)-A(310)+A(324))*f(2)+(-A(152)+A(153)-A(155) &
        +A(156)-A(188)+A(189)-A(191)+A(192)-A(433)-A(436)-A(437)+A(454)+A(457)+A(459)+A(460)+A(462)+A(465)-A(470)-A(471)-A(474) &
        +A(499)+A(501)+A(504)+A(505)+A(506)+A(510)-A(511)-A(512)-A(513)-A(514)-A(515)-A(516))*f(5)+CI*(A(430)+A(431)+A(432)-A(461) &
        -A(463)-A(464)-A(466)-A(467)-A(468)+A(500)+A(502)+A(503)-A(523)-A(524)-A(525)+A(556)+A(557)+A(558))*f(6)+(A(92)-A(93) &
        +A(98)-A(99)+A(140)+A(158)+A(171)+A(172)+A(205)+A(206)-A(329)-A(331)+A(335)+A(343)+A(344)-A(376)-A(378)+A(387)+A(401) &
        +A(402))*f(7)+CI*(-A(139)+A(163)+A(169)-A(184)+A(330)-A(334)+A(340)-A(352)-A(377)+A(385)-A(393)+A(405))*f(8)+(A(95)-A(96) &
        +A(101)-A(102)+A(223)+A(224)+A(360)-A(370)-A(372)+A(410)-A(417)-A(419))*f(9)+CI*(A(231)-A(274)+A(358)-A(369)-A(409) &
        +A(420))*f(10)+(-A(147)-A(149)-A(162)-A(164)-A(183)-A(185)-A(198)-A(200))*f(11)+CI*(A(150)-A(159)+A(174)-A(201)+A(209) &
        -A(220))*f(12)+2*(A(79)+A(85))*f(13)+(-A(80)-A(81)-A(86)-A(87))*f(13)+18*(-A(82)-A(88))*f(14)+(19*(A(83)+A(84)+A(89) &
        +A(90))*f(14))/2._/**/REALKIND+(A(56)-A(57)-A(61)+A(63)+A(67)-A(68)+A(73)-A(74)-A(109)-A(111)-A(113)-A(115)-A(117)-A(119) &
        -A(121)-A(123)-A(127)-A(129)+A(225)+A(240)+A(311))*f(23)+CI*(A(229)+A(232)+A(238)-A(272)-A(275)-A(297)-A(309) &
        +A(323))*f(24)
  M2( 5) = (-A(58)+A(60)+A(65)-A(66)+A(71)-A(72)-A(76)+A(78)+A(104)-A(106)+A(108)+A(110)+A(112)+A(120)+A(122)+A(126)+A(130)+A(132) &
        +A(269)+A(296)+A(302))*f(1)+CI*(-A(264)-A(267)+A(283)+A(286)+A(294)-A(300)-A(304)+A(318))*f(2)+(A(151)-A(153)+A(154) &
        -A(156)+A(187)-A(189)+A(190)-A(192)+A(442)+A(445)+A(447)-A(449)-A(450)-A(453)-A(454)-A(457)-A(459)-A(478)-A(481)-A(482) &
        +A(487)+A(489)+A(492)-A(499)-A(501)-A(504)-A(541)-A(542)-A(543)-A(544)-A(545)-A(546))*f(5)+CI*(-A(439)-A(440)-A(441) &
        +A(455)+A(456)+A(458)+A(475)+A(476)+A(477)-A(488)-A(490)-A(491)+A(547)+A(548)+A(549)-A(562)-A(563)-A(564))*f(6)+(-A(91) &
        +A(93)-A(97)+A(99)+A(146)+A(160)+A(176)+A(194)+A(215)+A(216)-A(326)+A(329)+A(333)+A(346)+A(347)-A(373)+A(376)+A(383) &
        +A(398)+A(399))*f(7)+CI*(A(142)-A(148)-A(175)+A(180)+A(327)-A(328)-A(345)+A(349)+A(374)-A(382)+A(396)-A(400))*f(8)+(-A(94) &
        +A(96)-A(100)+A(102)+A(261)+A(262)+A(362)-A(366)+A(370)-A(413)+A(416)+A(417))*f(9)+CI*(-A(265)+A(284)-A(361)+A(365)+A(412) &
        -A(418))*f(10)+(-A(143)+A(147)+A(164)-A(167)-A(179)+A(183)+A(200)-A(203))*f(11)+CI*(-A(165)+A(166)-A(195)+A(204)-A(217) &
        +A(222))*f(12)+2*(A(80)+A(86))*f(13)+(-A(79)-A(81)-A(85)-A(87))*f(13)+18*(-A(83)-A(89))*f(14)+(19*(A(82)+A(84)+A(88) &
        +A(90))*f(14))/2._/**/REALKIND+(-A(55)+A(57)+A(62)-A(63)+A(68)-A(69)-A(73)+A(75)+A(103)-A(105)+A(107)+A(109)+A(111)+A(119) &
        +A(121)+A(125)+A(129)+A(131)+A(268)+A(295)+A(301))*f(23)+CI*(-A(263)-A(266)+A(282)+A(285)+A(293)-A(299)-A(303) &
        +A(317))*f(24)
  M2( 6) = (A(58)-A(59)+A(64)-A(65)-A(70)+A(72)+A(77)-A(78)-A(104)+A(106)-A(108)+A(114)+A(116)+A(118)+A(124)-A(126)+A(128)-A(132) &
        +A(235)+A(237)+A(320))*f(1)+CI*(-A(230)-A(233)-A(239)-A(283)-A(286)-A(294)-A(318)-A(324))*f(2)+(-A(151)+A(152)-A(154) &
        +A(155)-A(187)+A(188)-A(190)+A(191)-A(442)-A(445)-A(447)-A(448)-A(451)-A(452)-A(460)-A(462)-A(465)-A(469)-A(472)-A(473) &
        -A(487)-A(489)-A(492)-A(505)-A(506)-A(510)-A(517)-A(518)-A(519)-A(520)-A(521)-A(522))*f(5)+CI*(A(439)+A(440)+A(441)+A(461) &
        +A(463)+A(464)+A(466)+A(467)+A(468)+A(488)+A(490)+A(491)+A(523)+A(524)+A(525)+A(562)+A(563)+A(564))*f(6)+(A(91)-A(92) &
        +A(97)-A(98)+A(145)+A(161)+A(170)+A(173)+A(207)+A(208)+A(326)+A(331)+A(332)+A(341)+A(342)+A(373)+A(378)+A(386)+A(403) &
        +A(404))*f(7)+CI*(-A(142)-A(163)-A(169)-A(180)-A(327)-A(330)-A(340)-A(349)-A(374)-A(385)-A(396)-A(405))*f(8)+(A(94)-A(95) &
        +A(100)-A(101)+A(227)+A(228)+A(359)+A(366)+A(372)+A(413)+A(415)+A(419))*f(9)+CI*(-A(231)-A(284)-A(358)-A(365)-A(412) &
        -A(420))*f(10)+(A(143)+A(149)+A(162)+A(167)+A(179)+A(185)+A(198)+A(203))*f(11)+CI*(-A(150)-A(166)-A(174)-A(204)-A(209) &
        -A(222))*f(12)+(-A(79)-A(80)-A(85)-A(86))*f(13)+2*(A(81)+A(87))*f(13)+(19*(A(82)+A(83)+A(88)+A(89))*f(14))/2._/**/REALKIND &
        +18*(-A(84)-A(90))*f(14)+(A(55)-A(56)+A(61)-A(62)-A(67)+A(69)+A(74)-A(75)-A(103)+A(105)-A(107)+A(113)+A(115)+A(117)+A(123) &
        -A(125)+A(127)-A(131)+A(234)+A(236)+A(319))*f(23)+CI*(-A(229)-A(232)-A(238)-A(282)-A(285)-A(293)-A(317)-A(323))*f(24)
  M2( 7) = (2*(-A(82)-A(83)-A(84)-A(88)-A(89)-A(90))*f(14))/3._/**/REALKIND
  M2( 8) = (2*(-A(82)-A(83)-A(84)-A(88)-A(89)-A(90))*f(14))/3._/**/REALKIND
  M2( 9) = (2*(-A(82)-A(83)-A(84)-A(88)-A(89)-A(90))*f(14))/3._/**/REALKIND
  M2(10) = ((-A(82)-A(83)-A(84)-A(88)-A(89)-A(90))*f(14))/3._/**/REALKIND
  M2(11) = ((-A(82)-A(83)-A(84)-A(88)-A(89)-A(90))*f(14))/3._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pphbbj_bbxhggg_1_/**/REALKIND
