
module ol_colourmatrix_pphbbj_bbbxbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  36,  12,  12,   0]
  K1( 2,:) = [  12,  36,   0,  12]
  K1( 3,:) = [  12,   0,  36,  12]
  K1( 4,:) = [   0,  12,  12,  36]
  K1( 5,:) = [  48,  16,  16,   0]
  K1( 6,:) = [  16,  48,   0,  16]
  K1( 7,:) = [  16,   0,  48,  16]
  K1( 8,:) = [   0,  16,  16,  48]
  K1( 9,:) = [   0,  16,  -2,   6]
  K1(10,:) = [  16,   0,   6,  -2]
  K1(11,:) = [  -2,   6,   0,  16]
  K1(12,:) = [   6,  -2,  16,   0]
  K1(13,:) = [  48,  16,  16,   0]
  K1(14,:) = [  16,  48,   0,  16]
  K1(15,:) = [  16,   0,  48,  16]
  K1(16,:) = [   0,  16,  16,  48]
  K1(17,:) = [   6,   2,   2,   0]
  K1(18,:) = [   2,   0,  -6, -16]
  K1(19,:) = [   2,  -6,   0, -16]
  K1(20,:) = [   0, -16, -16, -48]
  K1(21,:) = [   0,   2, -16,  -6]
  K1(22,:) = [   2,   6,   0,   2]
  K1(23,:) = [ -16,   0, -48, -16]
  K1(24,:) = [  -6,   2, -16,   0]
  K1(25,:) = [  48,  16,  16,   0]
  K1(26,:) = [  16,  48,   0,  16]
  K1(27,:) = [  16,   0,  48,  16]
  K1(28,:) = [   0,  16,  16,  48]
  K1(29,:) = [   0, -16,   2,  -6]
  K1(30,:) = [ -16, -48,   0, -16]
  K1(31,:) = [   2,   0,   6,   2]
  K1(32,:) = [  -6, -16,   2,   0]
  K1(33,:) = [ -48, -16, -16,   0]
  K1(34,:) = [ -16,   0,  -6,   2]
  K1(35,:) = [ -16,  -6,   0,   2]
  K1(36,:) = [   0,   2,   2,   6]
  K1(37,:) = [   0,  -2,  16,   6]
  K1(38,:) = [  -2,   0,   6,  16]
  K1(39,:) = [  16,   6,   0,  -2]
  K1(40,:) = [   6,  16,  -2,   0]
  K1(41,:) = [  48,  16,  16,   0]
  K1(42,:) = [  16,  48,   0,  16]
  K1(43,:) = [  16,   0,  48,  16]
  K1(44,:) = [   0,  16,  16,  48]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [ -54, -18, -18,   0]
  K1(66,:) = [ -18,   0,   0,  18]
  K1(67,:) = [ -18,   0, -54, -18]
  K1(68,:) = [   0,  18, -18,   0]
  K1(69,:) = [   0, -18,  18,   0]
  K1(70,:) = [ -18, -54,   0, -18]
  K1(71,:) = [  18,   0,   0, -18]
  K1(72,:) = [   0, -18, -18, -54]
  K1(73,:) = [ -54, -18, -18,   0]
  K1(74,:) = [ -18, -54,   0, -18]
  K1(75,:) = [ -18,   0,   0,  18]
  K1(76,:) = [   0, -18,  18,   0]
  K1(77,:) = [   0,  18, -18,   0]
  K1(78,:) = [  18,   0,   0, -18]
  K1(79,:) = [ -18,   0, -54, -18]
  K1(80,:) = [   0, -18, -18, -54]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [ 108,  36,  36,   0]
  K1(86,:) = [  36, 108,   0,  36]
  K1(87,:) = [  36,   0, 108,  36]
  K1(88,:) = [   0,  36,  36, 108]
  K1(89,:) = [   0,   0,   0,   0]
  K1(90,:) = [   0,   0,   0,   0]
  K1(91,:) = [   0,   0,   0,   0]
  K1(92,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphbbj_bbbxbxhg_1_/**/REALKIND



module ol_forced_parameters_pphbbj_bbbxbxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphbbj_bbbxbxhg_1_/**/REALKIND

module ol_loop_pphbbj_bbbxbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(23), c(29)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:471)
  ! denominators
  complex(REALKIND), save :: den(578)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(4,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 2) = (countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 3) = (CI*eQED*gQCD**3*YB)/(2._/**/REALKIND*MW*sw)
    f( 4) = (eQED*gQCD**3*YB)/(MW*sw*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f( 6) = (countertermnorm*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f( 7) = (CI*countertermnorm*ctGbb*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f( 8) = (countertermnorm*ctGbb*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*ctSbb*eQED*gQCD**5*YB)/(2._/**/REALKIND*MW*sw)
    f(10) = (countertermnorm*ctSbb*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f(11) = (countertermnorm*ctVVV*eQED*gQCD**5*YB)/(MW*sw*2._/**/REALKIND)
    f(12) = (CI*eQED*gQCD**5*integralnorm*SwB*YB)/(4._/**/REALKIND*MW*sw)
    f(13) = (CI*eQED*gQCD**5*integralnorm*SwB*YB)/(2._/**/REALKIND*MW*sw)
    f(14) = (eQED*gQCD**5*integralnorm*SwB*YB)/(MW*sw*4._/**/REALKIND)
    f(15) = (eQED*gQCD**5*integralnorm*SwB*YB)/(MW*sw*2._/**/REALKIND)
    f(16) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f(17) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw)
    f(18) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f(19) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw)
    f(20) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(21) = (countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f(22) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(23) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)

  c = [ 27*CI*f(12), 54*CI*f(12), 3*CI*f(13), 9*CI*f(13), 24*CI*f(13), 27*CI*f(13), 54*CI*f(13), 18*f(14), 54*f(14), f(15) &
    , 3*f(15), 6*f(15), 8*f(15), 9*f(15), 10*f(15), 18*f(15), 21*f(15), 24*f(15), 27*f(15), 54*f(15), 9*CI*f(16), 9*CI*f(17) &
    , 3*f(18), 9*f(18), 3*f(19), 9*f(19), 9*CI*f(22), 3*f(23), 9*f(23) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(4), M2(4)
  complex(REALKIND) :: A(428)
  ! external WFs
  call wf_Q(P(:,1), rMB, H(1), wf(:,0))
  call wf_Q(P(:,2), rMB, H(2), wf(:,-1))
  call wf_A(P(:,3), rMB, H(3), wf(:,-2))
  call wf_A(P(:,4), rMB, H(4), wf(:,-3))
  call wf_S(P(:,5), rMH, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,2))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,3))
  call prop_Q_A(wf(:,2),Q(:,18),MB,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,3),Q(:,40),MB,1_intkind1,wf(:,5))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,6))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,7))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,13),MB,1_intkind1,wf(:,9))
  call vert_QA_V(wf(:,4),wf(:,-3),wf(:,10))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,11))
  call vert_VQ_A(wf(:,-5),wf(:,-1),wf(:,12))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,13))
  call prop_Q_A(wf(:,12),Q(:,34),MB,1_intkind1,wf(:,14))
  call prop_A_Q(wf(:,13),Q(:,24),MB,1_intkind1,wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,14),wf(:,16))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,17))
  call vert_AV_Q(wf(:,15),wf(:,-5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,7),MB,1_intkind1,wf(:,19))
  call vert_QA_V(wf(:,-1),wf(:,15),wf(:,20))
  call vert_QS_A(gH,wf(:,14),wf(:,-4),wf(:,21))
  call vert_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,22))
  call vert_QS_A(gH,wf(:,0),wf(:,-4),wf(:,23))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,17),MB,1_intkind1,wf(:,25))
  call vert_VQ_A(wf(:,24),wf(:,25),wf(:,26))
  call vert_QA_V(wf(:,25),wf(:,-3),wf(:,27))
  call vert_UV_W(wf(:,24),Q(:,6),wf(:,-5),Q(:,32),wf(:,28))
  call vert_AV_Q(wf(:,-3),wf(:,24),wf(:,29))
  call vert_VQ_A(wf(:,-5),wf(:,25),wf(:,30))
  call prop_A_Q(wf(:,29),Q(:,14),MB,1_intkind1,wf(:,31))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,33),MB,1_intkind1,wf(:,33))
  call vert_VQ_A(wf(:,24),wf(:,33),wf(:,34))
  call vert_VQ_A(wf(:,24),wf(:,0),wf(:,35))
  call prop_Q_A(wf(:,35),Q(:,7),MB,1_intkind1,wf(:,36))
  call vert_QA_V(wf(:,0),wf(:,15),wf(:,37))
  call vert_QS_A(gH,wf(:,33),wf(:,-4),wf(:,38))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,39))
  call vert_AV_Q(wf(:,-2),wf(:,-5),wf(:,40))
  call prop_A_Q(wf(:,40),Q(:,36),MB,1_intkind1,wf(:,41))
  call vert_VQ_A(wf(:,39),wf(:,4),wf(:,42))
  call vert_AV_Q(wf(:,-2),wf(:,39),wf(:,43))
  call prop_A_Q(wf(:,43),Q(:,13),MB,1_intkind1,wf(:,44))
  call vert_QA_V(wf(:,4),wf(:,-2),wf(:,45))
  call vert_UV_W(wf(:,39),Q(:,9),wf(:,-5),Q(:,32),wf(:,46))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-2),wf(:,47))
  call prop_A_Q(wf(:,47),Q(:,20),MB,1_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,39),wf(:,14),wf(:,49))
  call vert_VQ_A(wf(:,39),wf(:,-1),wf(:,50))
  call vert_AV_Q(wf(:,48),wf(:,-5),wf(:,51))
  call prop_Q_A(wf(:,50),Q(:,11),MB,1_intkind1,wf(:,52))
  call vert_QA_V(wf(:,-1),wf(:,48),wf(:,53))
  call vert_SA_Q(gH,wf(:,-4),wf(:,41),wf(:,54))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,55))
  call vert_VQ_A(wf(:,55),wf(:,25),wf(:,56))
  call vert_QA_V(wf(:,25),wf(:,-2),wf(:,57))
  call vert_UV_W(wf(:,55),Q(:,10),wf(:,-5),Q(:,32),wf(:,58))
  call vert_AV_Q(wf(:,-2),wf(:,55),wf(:,59))
  call prop_A_Q(wf(:,59),Q(:,14),MB,1_intkind1,wf(:,60))
  call vert_VQ_A(wf(:,55),wf(:,33),wf(:,61))
  call vert_VQ_A(wf(:,55),wf(:,0),wf(:,62))
  call prop_Q_A(wf(:,62),Q(:,11),MB,1_intkind1,wf(:,63))
  call vert_QA_V(wf(:,0),wf(:,48),wf(:,64))
  call vert_QA_V(wf(:,14),wf(:,-3),wf(:,65))
  call vert_QA_V(wf(:,14),wf(:,-2),wf(:,66))
  call vert_QA_V(wf(:,-1),wf(:,41),wf(:,67))
  call vert_QA_V(wf(:,-1),wf(:,5),wf(:,68))
  call vert_QA_V(wf(:,33),wf(:,-2),wf(:,69))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,70))
  call vert_QA_V(wf(:,0),wf(:,41),wf(:,71))
  call vert_QA_V(wf(:,0),wf(:,5),wf(:,72))
  call counter_SG_G(wf(:,-4),wf(:,55),wf(:,73))
  call counter_SG_G(wf(:,-4),wf(:,1),wf(:,74))
  call counter_SG_G(wf(:,-4),wf(:,-5),wf(:,75))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,55),Q(:,10),wf(:,76))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,77))
  call counter_VQ_A(wf(:,-5),wf(:,4),wf(:,78))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,79))
  call counter_VQ_A(wf(:,1),wf(:,14),wf(:,80))
  call counter_AV_Q(wf(:,15),wf(:,-5),wf(:,81))
  call counter_QS_A(gH,wf(:,14),wf(:,-4),wf(:,82))
  call counter_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,83))
  call vert_AV_Q(wf(:,-3),wf(:,75),wf(:,84))
  call vert_VQ_A(wf(:,75),wf(:,-1),wf(:,85))
  call prop_Q_A(wf(:,85),Q(:,50),MB,1_intkind1,wf(:,86))
  call counter_QA_V(wf(:,4),wf(:,-3),wf(:,87))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,88))
  call prop_Q_A(wf(:,8),Q(:,50),MB,1_intkind1,wf(:,89))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,90))
  call prop_A_Q(wf(:,90),Q(:,40),MB,1_intkind1,wf(:,91))
  call prop_Q_A(wf(:,21),Q(:,50),MB,1_intkind1,wf(:,92))
  call vert_SA_Q(gH,wf(:,-4),wf(:,91),wf(:,93))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,94))
  call prop_A_Q(wf(:,94),Q(:,24),MB,1_intkind1,wf(:,95))
  call vert_AV_Q(wf(:,95),wf(:,-5),wf(:,96))
  call vert_QA_V(wf(:,-1),wf(:,95),wf(:,97))
  call counter_SG_G(wf(:,-4),wf(:,24),wf(:,98))
  call counter_SG_G(wf(:,-4),wf(:,39),wf(:,99))
  call vert_UV_W(wf(:,24),Q(:,6),wf(:,39),Q(:,9),wf(:,100))
  call counter_VQ_A(wf(:,24),wf(:,25),wf(:,101))
  call counter_UV_W(wf(:,24),Q(:,6),wf(:,-5),Q(:,32),wf(:,102))
  call counter_VQ_A(wf(:,-5),wf(:,25),wf(:,103))
  call counter_VQ_A(wf(:,24),wf(:,33),wf(:,104))
  call counter_QS_A(gH,wf(:,33),wf(:,-4),wf(:,105))
  call vert_VQ_A(wf(:,75),wf(:,0),wf(:,106))
  call prop_Q_A(wf(:,106),Q(:,49),MB,1_intkind1,wf(:,107))
  call counter_AV_Q(wf(:,-3),wf(:,24),wf(:,108))
  call prop_Q_A(wf(:,30),Q(:,49),MB,1_intkind1,wf(:,109))
  call counter_QA_V(wf(:,25),wf(:,-3),wf(:,110))
  call prop_Q_A(wf(:,38),Q(:,49),MB,1_intkind1,wf(:,111))
  call vert_QA_V(wf(:,0),wf(:,95),wf(:,112))
  call counter_VQ_A(wf(:,39),wf(:,4),wf(:,113))
  call counter_UV_W(wf(:,39),Q(:,9),wf(:,-5),Q(:,32),wf(:,114))
  call counter_VQ_A(wf(:,39),wf(:,14),wf(:,115))
  call counter_AV_Q(wf(:,48),wf(:,-5),wf(:,116))
  call counter_SA_Q(gH,wf(:,-4),wf(:,41),wf(:,117))
  call vert_AV_Q(wf(:,-2),wf(:,75),wf(:,118))
  call counter_VQ_A(wf(:,55),wf(:,25),wf(:,119))
  call counter_UV_W(wf(:,55),Q(:,10),wf(:,-5),Q(:,32),wf(:,120))
  call counter_VQ_A(wf(:,55),wf(:,33),wf(:,121))
  call counter_QA_V(wf(:,14),wf(:,-3),wf(:,122))
  call vert_QA_V(wf(:,-1),wf(:,91),wf(:,123))
  call counter_QA_V(wf(:,33),wf(:,-3),wf(:,124))
  call vert_QA_V(wf(:,0),wf(:,91),wf(:,125))
  call counter_QA_V(wf(:,4),wf(:,-2),wf(:,126))
  call counter_AV_Q(wf(:,-2),wf(:,39),wf(:,127))
  call counter_AV_Q(wf(:,-2),wf(:,-5),wf(:,128))
  call prop_A_Q(wf(:,128),Q(:,36),MB,1_intkind1,wf(:,129))
  call vert_SA_Q(gH,wf(:,-4),wf(:,129),wf(:,130))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-2),wf(:,131))
  call prop_A_Q(wf(:,131),Q(:,20),MB,1_intkind1,wf(:,132))
  call vert_AV_Q(wf(:,132),wf(:,-5),wf(:,133))
  call vert_QA_V(wf(:,-1),wf(:,132),wf(:,134))
  call counter_AV_Q(wf(:,-2),wf(:,55),wf(:,135))
  call counter_QA_V(wf(:,25),wf(:,-2),wf(:,136))
  call vert_QA_V(wf(:,0),wf(:,132),wf(:,137))
  call counter_QA_V(wf(:,14),wf(:,-2),wf(:,138))
  call vert_QA_V(wf(:,-1),wf(:,129),wf(:,139))
  call counter_QA_V(wf(:,33),wf(:,-2),wf(:,140))
  call vert_QA_V(wf(:,0),wf(:,129),wf(:,141))
  call counter_QA_V(wf(:,-1),wf(:,15),wf(:,142))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,143))
  call prop_A_Q(wf(:,18),Q(:,56),MB,1_intkind1,wf(:,144))
  call counter_VQ_A(wf(:,-5),wf(:,-1),wf(:,145))
  call prop_Q_A(wf(:,145),Q(:,34),MB,1_intkind1,wf(:,146))
  call vert_VQ_A(wf(:,1),wf(:,146),wf(:,147))
  call prop_A_Q(wf(:,22),Q(:,56),MB,1_intkind1,wf(:,148))
  call vert_QS_A(gH,wf(:,146),wf(:,-4),wf(:,149))
  call counter_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,150))
  call prop_Q_A(wf(:,150),Q(:,18),MB,1_intkind1,wf(:,151))
  call vert_VQ_A(wf(:,1),wf(:,151),wf(:,152))
  call vert_VQ_A(wf(:,-5),wf(:,151),wf(:,153))
  call vert_QA_V(wf(:,151),wf(:,-3),wf(:,154))
  call counter_QA_V(wf(:,-1),wf(:,48),wf(:,155))
  call counter_VQ_A(wf(:,39),wf(:,-1),wf(:,156))
  call prop_A_Q(wf(:,51),Q(:,52),MB,1_intkind1,wf(:,157))
  call vert_VQ_A(wf(:,39),wf(:,146),wf(:,158))
  call prop_A_Q(wf(:,54),Q(:,52),MB,1_intkind1,wf(:,159))
  call vert_VQ_A(wf(:,39),wf(:,151),wf(:,160))
  call vert_QA_V(wf(:,151),wf(:,-2),wf(:,161))
  call counter_QA_V(wf(:,-1),wf(:,41),wf(:,162))
  call counter_QA_V(wf(:,-1),wf(:,5),wf(:,163))
  call vert_QA_V(wf(:,146),wf(:,-3),wf(:,164))
  call vert_QA_V(wf(:,146),wf(:,-2),wf(:,165))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,166))
  call vert_VQ_A(wf(:,166),wf(:,25),wf(:,167))
  call vert_UV_W(wf(:,166),Q(:,10),wf(:,-5),Q(:,32),wf(:,168))
  call vert_AV_Q(wf(:,-2),wf(:,166),wf(:,169))
  call prop_A_Q(wf(:,169),Q(:,14),MB,1_intkind1,wf(:,170))
  call vert_VQ_A(wf(:,166),wf(:,33),wf(:,171))
  call vert_VQ_A(wf(:,166),wf(:,0),wf(:,172))
  call prop_Q_A(wf(:,172),Q(:,11),MB,1_intkind1,wf(:,173))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,174))
  call vert_VQ_A(wf(:,174),wf(:,25),wf(:,175))
  call vert_UV_W(wf(:,174),Q(:,6),wf(:,-5),Q(:,32),wf(:,176))
  call vert_AV_Q(wf(:,-3),wf(:,174),wf(:,177))
  call prop_A_Q(wf(:,177),Q(:,14),MB,1_intkind1,wf(:,178))
  call vert_VQ_A(wf(:,174),wf(:,33),wf(:,179))
  call vert_VQ_A(wf(:,174),wf(:,0),wf(:,180))
  call prop_Q_A(wf(:,180),Q(:,7),MB,1_intkind1,wf(:,181))
  call counter_VQ_A(wf(:,24),wf(:,0),wf(:,182))
  call counter_QA_V(wf(:,0),wf(:,15),wf(:,183))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,184))
  call prop_Q_A(wf(:,184),Q(:,33),MB,1_intkind1,wf(:,185))
  call vert_VQ_A(wf(:,24),wf(:,185),wf(:,186))
  call vert_QS_A(gH,wf(:,185),wf(:,-4),wf(:,187))
  call counter_QS_A(gH,wf(:,0),wf(:,-4),wf(:,188))
  call prop_Q_A(wf(:,188),Q(:,17),MB,1_intkind1,wf(:,189))
  call vert_VQ_A(wf(:,24),wf(:,189),wf(:,190))
  call vert_QA_V(wf(:,189),wf(:,-3),wf(:,191))
  call vert_VQ_A(wf(:,-5),wf(:,189),wf(:,192))
  call counter_VQ_A(wf(:,55),wf(:,0),wf(:,193))
  call counter_QA_V(wf(:,0),wf(:,48),wf(:,194))
  call vert_VQ_A(wf(:,55),wf(:,185),wf(:,195))
  call vert_VQ_A(wf(:,55),wf(:,189),wf(:,196))
  call vert_QA_V(wf(:,189),wf(:,-2),wf(:,197))
  call counter_QA_V(wf(:,0),wf(:,41),wf(:,198))
  call counter_QA_V(wf(:,0),wf(:,5),wf(:,199))
  call vert_QA_V(wf(:,185),wf(:,-2),wf(:,200))
  call vert_QA_V(wf(:,185),wf(:,-3),wf(:,201))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,202))
  call vert_VQ_A(wf(:,202),wf(:,4),wf(:,203))
  call vert_AV_Q(wf(:,-2),wf(:,202),wf(:,204))
  call prop_A_Q(wf(:,204),Q(:,13),MB,1_intkind1,wf(:,205))
  call vert_UV_W(wf(:,202),Q(:,9),wf(:,-5),Q(:,32),wf(:,206))
  call vert_VQ_A(wf(:,202),wf(:,14),wf(:,207))
  call vert_VQ_A(wf(:,202),wf(:,-1),wf(:,208))
  call prop_Q_A(wf(:,208),Q(:,11),MB,1_intkind1,wf(:,209))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,210))
  call vert_VQ_A(wf(:,210),wf(:,4),wf(:,211))
  call vert_AV_Q(wf(:,-3),wf(:,210),wf(:,212))
  call prop_A_Q(wf(:,212),Q(:,13),MB,1_intkind1,wf(:,213))
  call vert_UV_W(wf(:,210),Q(:,5),wf(:,-5),Q(:,32),wf(:,214))
  call vert_VQ_A(wf(:,210),wf(:,14),wf(:,215))
  call vert_VQ_A(wf(:,210),wf(:,-1),wf(:,216))
  call prop_Q_A(wf(:,216),Q(:,7),MB,1_intkind1,wf(:,217))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,218))
  call counter_V_V(ctGG,wf(:,1),Q(:,5),wf(:,219))
  call vert_AV_Q(wf(:,5),wf(:,1),wf(:,220))
  call counter_Q_A(ctbb,wf(:,4),Q(:,18),wf(:,221))
  call prop_A_Q(wf(:,220),Q(:,45),MB,1_intkind1,wf(:,222))
  call counter_A_Q(ctbb,wf(:,5),Q(:,40),wf(:,223))
  call prop_Q_A(wf(:,6),Q(:,23),MB,1_intkind1,wf(:,224))
  call vert_AV_Q(wf(:,-3),wf(:,219),wf(:,225))
  call vert_UV_W(wf(:,219),Q(:,5),wf(:,-5),Q(:,32),wf(:,226))
  call prop_Q_A(wf(:,221),Q(:,18),MB,1_intkind1,wf(:,227))
  call vert_QA_V(wf(:,227),wf(:,-3),wf(:,228))
  call vert_VQ_A(wf(:,-5),wf(:,227),wf(:,229))
  call counter_A_Q(ctbb,wf(:,9),Q(:,13),wf(:,230))
  call counter_V_V(ctGG,wf(:,10),Q(:,26),wf(:,231))
  call vert_QA_V(wf(:,14),wf(:,15),wf(:,232))
  call vert_AV_Q(wf(:,15),wf(:,1),wf(:,233))
  call counter_Q_A(ctbb,wf(:,14),Q(:,34),wf(:,234))
  call prop_A_Q(wf(:,233),Q(:,29),MB,1_intkind1,wf(:,235))
  call counter_A_Q(ctbb,wf(:,15),Q(:,24),wf(:,236))
  call prop_Q_A(wf(:,16),Q(:,39),MB,1_intkind1,wf(:,237))
  call vert_VQ_A(wf(:,219),wf(:,-1),wf(:,238))
  call prop_A_Q(wf(:,236),Q(:,24),MB,1_intkind1,wf(:,239))
  call vert_QA_V(wf(:,-1),wf(:,239),wf(:,240))
  call counter_Q_A(ctbb,wf(:,19),Q(:,7),wf(:,241))
  call counter_V_V(ctGG,wf(:,20),Q(:,26),wf(:,242))
  call vert_AV_Q(wf(:,239),wf(:,-5),wf(:,243))
  call prop_Q_A(wf(:,234),Q(:,34),MB,1_intkind1,wf(:,244))
  call vert_QS_A(gH,wf(:,244),wf(:,-4),wf(:,245))
  call prop_A_Q(wf(:,223),Q(:,40),MB,1_intkind1,wf(:,246))
  call vert_SA_Q(gH,wf(:,-4),wf(:,246),wf(:,247))
  call vert_AV_Q(wf(:,5),wf(:,24),wf(:,248))
  call counter_Q_A(ctbb,wf(:,25),Q(:,17),wf(:,249))
  call prop_A_Q(wf(:,248),Q(:,46),MB,1_intkind1,wf(:,250))
  call vert_QA_V(wf(:,25),wf(:,5),wf(:,251))
  call counter_V_V(ctGG,wf(:,24),Q(:,6),wf(:,252))
  call prop_Q_A(wf(:,26),Q(:,23),MB,1_intkind1,wf(:,253))
  call prop_Q_A(wf(:,249),Q(:,17),MB,1_intkind1,wf(:,254))
  call vert_QA_V(wf(:,254),wf(:,-3),wf(:,255))
  call vert_VQ_A(wf(:,-5),wf(:,254),wf(:,256))
  call vert_AV_Q(wf(:,-3),wf(:,252),wf(:,257))
  call vert_UV_W(wf(:,252),Q(:,6),wf(:,-5),Q(:,32),wf(:,258))
  call counter_V_V(ctGG,wf(:,27),Q(:,25),wf(:,259))
  call counter_A_Q(ctbb,wf(:,31),Q(:,14),wf(:,260))
  call vert_AV_Q(wf(:,15),wf(:,24),wf(:,261))
  call counter_Q_A(ctbb,wf(:,33),Q(:,33),wf(:,262))
  call prop_A_Q(wf(:,261),Q(:,30),MB,1_intkind1,wf(:,263))
  call vert_QA_V(wf(:,33),wf(:,15),wf(:,264))
  call prop_Q_A(wf(:,34),Q(:,39),MB,1_intkind1,wf(:,265))
  call vert_VQ_A(wf(:,252),wf(:,0),wf(:,266))
  call vert_QA_V(wf(:,0),wf(:,239),wf(:,267))
  call counter_Q_A(ctbb,wf(:,36),Q(:,7),wf(:,268))
  call counter_V_V(ctGG,wf(:,37),Q(:,25),wf(:,269))
  call prop_Q_A(wf(:,262),Q(:,33),MB,1_intkind1,wf(:,270))
  call vert_QS_A(gH,wf(:,270),wf(:,-4),wf(:,271))
  call vert_QA_V(wf(:,4),wf(:,41),wf(:,272))
  call counter_V_V(ctGG,wf(:,39),Q(:,9),wf(:,273))
  call vert_AV_Q(wf(:,41),wf(:,39),wf(:,274))
  call prop_A_Q(wf(:,274),Q(:,45),MB,1_intkind1,wf(:,275))
  call counter_A_Q(ctbb,wf(:,41),Q(:,36),wf(:,276))
  call prop_Q_A(wf(:,42),Q(:,27),MB,1_intkind1,wf(:,277))
  call vert_AV_Q(wf(:,-2),wf(:,273),wf(:,278))
  call vert_UV_W(wf(:,273),Q(:,9),wf(:,-5),Q(:,32),wf(:,279))
  call vert_QA_V(wf(:,227),wf(:,-2),wf(:,280))
  call counter_A_Q(ctbb,wf(:,44),Q(:,13),wf(:,281))
  call counter_V_V(ctGG,wf(:,45),Q(:,22),wf(:,282))
  call vert_QA_V(wf(:,14),wf(:,48),wf(:,283))
  call vert_AV_Q(wf(:,48),wf(:,39),wf(:,284))
  call prop_A_Q(wf(:,284),Q(:,29),MB,1_intkind1,wf(:,285))
  call counter_A_Q(ctbb,wf(:,48),Q(:,20),wf(:,286))
  call prop_Q_A(wf(:,49),Q(:,43),MB,1_intkind1,wf(:,287))
  call vert_VQ_A(wf(:,273),wf(:,-1),wf(:,288))
  call prop_A_Q(wf(:,286),Q(:,20),MB,1_intkind1,wf(:,289))
  call vert_QA_V(wf(:,-1),wf(:,289),wf(:,290))
  call counter_Q_A(ctbb,wf(:,52),Q(:,11),wf(:,291))
  call counter_V_V(ctGG,wf(:,53),Q(:,22),wf(:,292))
  call vert_AV_Q(wf(:,289),wf(:,-5),wf(:,293))
  call prop_A_Q(wf(:,276),Q(:,36),MB,1_intkind1,wf(:,294))
  call vert_SA_Q(gH,wf(:,-4),wf(:,294),wf(:,295))
  call vert_AV_Q(wf(:,41),wf(:,55),wf(:,296))
  call prop_A_Q(wf(:,296),Q(:,46),MB,1_intkind1,wf(:,297))
  call vert_QA_V(wf(:,25),wf(:,41),wf(:,298))
  call counter_V_V(ctGG,wf(:,55),Q(:,10),wf(:,299))
  call prop_Q_A(wf(:,56),Q(:,27),MB,1_intkind1,wf(:,300))
  call vert_QA_V(wf(:,254),wf(:,-2),wf(:,301))
  call vert_AV_Q(wf(:,-2),wf(:,299),wf(:,302))
  call vert_UV_W(wf(:,299),Q(:,10),wf(:,-5),Q(:,32),wf(:,303))
  call counter_V_V(ctGG,wf(:,57),Q(:,21),wf(:,304))
  call counter_A_Q(ctbb,wf(:,60),Q(:,14),wf(:,305))
  call vert_AV_Q(wf(:,48),wf(:,55),wf(:,306))
  call prop_A_Q(wf(:,306),Q(:,30),MB,1_intkind1,wf(:,307))
  call vert_QA_V(wf(:,33),wf(:,48),wf(:,308))
  call prop_Q_A(wf(:,61),Q(:,43),MB,1_intkind1,wf(:,309))
  call vert_VQ_A(wf(:,299),wf(:,0),wf(:,310))
  call vert_QA_V(wf(:,0),wf(:,289),wf(:,311))
  call counter_Q_A(ctbb,wf(:,63),Q(:,11),wf(:,312))
  call counter_V_V(ctGG,wf(:,64),Q(:,21),wf(:,313))
  call vert_QA_V(wf(:,244),wf(:,-2),wf(:,314))
  call vert_QA_V(wf(:,244),wf(:,-3),wf(:,315))
  call counter_V_V(ctGG,wf(:,66),Q(:,38),wf(:,316))
  call vert_QA_V(wf(:,-1),wf(:,294),wf(:,317))
  call counter_V_V(ctGG,wf(:,67),Q(:,38),wf(:,318))
  call counter_V_V(ctGG,wf(:,68),Q(:,42),wf(:,319))
  call vert_QA_V(wf(:,-1),wf(:,246),wf(:,320))
  call vert_QA_V(wf(:,270),wf(:,-2),wf(:,321))
  call vert_QA_V(wf(:,270),wf(:,-3),wf(:,322))
  call counter_V_V(ctGG,wf(:,69),Q(:,37),wf(:,323))
  call vert_QA_V(wf(:,0),wf(:,294),wf(:,324))
  call counter_V_V(ctGG,wf(:,71),Q(:,37),wf(:,325))
  call counter_V_V(ctGG,wf(:,72),Q(:,41),wf(:,326))
  call vert_QA_V(wf(:,0),wf(:,246),wf(:,327))
  call vert_QA_V(wf(:,19),wf(:,-3),wf(:,328))
  call vert_QS_A(gH,wf(:,19),wf(:,-4),wf(:,329))
  call prop_Q_A(wf(:,329),Q(:,23),MB,1_intkind1,wf(:,330))
  call vert_VQ_A(wf(:,-5),wf(:,19),wf(:,331))
  call prop_Q_A(wf(:,331),Q(:,39),MB,1_intkind1,wf(:,332))
  call vert_QA_V(wf(:,-1),wf(:,9),wf(:,333))
  call vert_SA_Q(gH,wf(:,-4),wf(:,9),wf(:,334))
  call prop_A_Q(wf(:,334),Q(:,29),MB,1_intkind1,wf(:,335))
  call vert_AV_Q(wf(:,9),wf(:,-5),wf(:,336))
  call prop_A_Q(wf(:,336),Q(:,45),MB,1_intkind1,wf(:,337))
  call vert_VQ_A(wf(:,11),wf(:,-1),wf(:,338))
  call prop_Q_A(wf(:,338),Q(:,39),MB,1_intkind1,wf(:,339))
  call vert_AV_Q(wf(:,-3),wf(:,11),wf(:,340))
  call prop_A_Q(wf(:,340),Q(:,45),MB,1_intkind1,wf(:,341))
  call vert_QA_V(wf(:,36),wf(:,-3),wf(:,342))
  call vert_QS_A(gH,wf(:,36),wf(:,-4),wf(:,343))
  call prop_Q_A(wf(:,343),Q(:,23),MB,1_intkind1,wf(:,344))
  call vert_VQ_A(wf(:,-5),wf(:,36),wf(:,345))
  call prop_Q_A(wf(:,345),Q(:,39),MB,1_intkind1,wf(:,346))
  call vert_QA_V(wf(:,0),wf(:,31),wf(:,347))
  call vert_VQ_A(wf(:,28),wf(:,0),wf(:,348))
  call prop_Q_A(wf(:,348),Q(:,39),MB,1_intkind1,wf(:,349))
  call vert_SA_Q(gH,wf(:,-4),wf(:,31),wf(:,350))
  call prop_A_Q(wf(:,350),Q(:,30),MB,1_intkind1,wf(:,351))
  call vert_AV_Q(wf(:,31),wf(:,-5),wf(:,352))
  call prop_A_Q(wf(:,352),Q(:,46),MB,1_intkind1,wf(:,353))
  call vert_AV_Q(wf(:,-3),wf(:,28),wf(:,354))
  call prop_A_Q(wf(:,354),Q(:,46),MB,1_intkind1,wf(:,355))
  call vert_QA_V(wf(:,52),wf(:,-2),wf(:,356))
  call vert_QS_A(gH,wf(:,52),wf(:,-4),wf(:,357))
  call prop_Q_A(wf(:,357),Q(:,27),MB,1_intkind1,wf(:,358))
  call vert_VQ_A(wf(:,-5),wf(:,52),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,43),MB,1_intkind1,wf(:,360))
  call vert_QA_V(wf(:,-1),wf(:,44),wf(:,361))
  call vert_SA_Q(gH,wf(:,-4),wf(:,44),wf(:,362))
  call prop_A_Q(wf(:,362),Q(:,29),MB,1_intkind1,wf(:,363))
  call vert_AV_Q(wf(:,44),wf(:,-5),wf(:,364))
  call prop_A_Q(wf(:,364),Q(:,45),MB,1_intkind1,wf(:,365))
  call vert_VQ_A(wf(:,46),wf(:,-1),wf(:,366))
  call prop_Q_A(wf(:,366),Q(:,43),MB,1_intkind1,wf(:,367))
  call vert_AV_Q(wf(:,-2),wf(:,46),wf(:,368))
  call prop_A_Q(wf(:,368),Q(:,45),MB,1_intkind1,wf(:,369))
  call vert_QA_V(wf(:,63),wf(:,-2),wf(:,370))
  call vert_QS_A(gH,wf(:,63),wf(:,-4),wf(:,371))
  call prop_Q_A(wf(:,371),Q(:,27),MB,1_intkind1,wf(:,372))
  call vert_VQ_A(wf(:,-5),wf(:,63),wf(:,373))
  call prop_Q_A(wf(:,373),Q(:,43),MB,1_intkind1,wf(:,374))
  call vert_QA_V(wf(:,0),wf(:,60),wf(:,375))
  call vert_VQ_A(wf(:,58),wf(:,0),wf(:,376))
  call prop_Q_A(wf(:,376),Q(:,43),MB,1_intkind1,wf(:,377))
  call vert_SA_Q(gH,wf(:,-4),wf(:,60),wf(:,378))
  call prop_A_Q(wf(:,378),Q(:,30),MB,1_intkind1,wf(:,379))
  call vert_AV_Q(wf(:,60),wf(:,-5),wf(:,380))
  call prop_A_Q(wf(:,380),Q(:,46),MB,1_intkind1,wf(:,381))
  call vert_AV_Q(wf(:,-2),wf(:,58),wf(:,382))
  call prop_A_Q(wf(:,382),Q(:,46),MB,1_intkind1,wf(:,383))
  call vert_VQ_A(wf(:,57),wf(:,-1),wf(:,384))
  call prop_Q_A(wf(:,384),Q(:,23),MB,1_intkind1,wf(:,385))
  call vert_AV_Q(wf(:,-3),wf(:,57),wf(:,386))
  call prop_A_Q(wf(:,386),Q(:,29),MB,1_intkind1,wf(:,387))
  call vert_UV_W(wf(:,57),Q(:,21),wf(:,-5),Q(:,32),wf(:,388))
  call vert_VQ_A(wf(:,27),wf(:,-1),wf(:,389))
  call prop_Q_A(wf(:,389),Q(:,27),MB,1_intkind1,wf(:,390))
  call vert_AV_Q(wf(:,-2),wf(:,27),wf(:,391))
  call prop_A_Q(wf(:,391),Q(:,29),MB,1_intkind1,wf(:,392))
  call vert_UV_W(wf(:,27),Q(:,25),wf(:,-5),Q(:,32),wf(:,393))
  call vert_QA_V(wf(:,109),wf(:,-2),wf(:,394))
  call vert_QA_V(wf(:,109),wf(:,-3),wf(:,395))
  call vert_VQ_A(wf(:,45),wf(:,0),wf(:,396))
  call prop_Q_A(wf(:,396),Q(:,23),MB,1_intkind1,wf(:,397))
  call vert_VQ_A(wf(:,10),wf(:,0),wf(:,398))
  call prop_Q_A(wf(:,398),Q(:,27),MB,1_intkind1,wf(:,399))
  call vert_AV_Q(wf(:,-3),wf(:,45),wf(:,400))
  call prop_A_Q(wf(:,400),Q(:,30),MB,1_intkind1,wf(:,401))
  call vert_UV_W(wf(:,45),Q(:,22),wf(:,-5),Q(:,32),wf(:,402))
  call vert_AV_Q(wf(:,-2),wf(:,10),wf(:,403))
  call prop_A_Q(wf(:,403),Q(:,30),MB,1_intkind1,wf(:,404))
  call vert_UV_W(wf(:,10),Q(:,26),wf(:,-5),Q(:,32),wf(:,405))
  call vert_QA_V(wf(:,89),wf(:,-2),wf(:,406))
  call vert_QA_V(wf(:,89),wf(:,-3),wf(:,407))
  call vert_VQ_A(wf(:,64),wf(:,-1),wf(:,408))
  call prop_Q_A(wf(:,408),Q(:,23),MB,1_intkind1,wf(:,409))
  call vert_VQ_A(wf(:,53),wf(:,0),wf(:,410))
  call prop_Q_A(wf(:,410),Q(:,23),MB,1_intkind1,wf(:,411))
  call vert_AV_Q(wf(:,-3),wf(:,64),wf(:,412))
  call prop_A_Q(wf(:,412),Q(:,29),MB,1_intkind1,wf(:,413))
  call vert_UV_W(wf(:,64),Q(:,21),wf(:,-5),Q(:,32),wf(:,414))
  call vert_QA_V(wf(:,0),wf(:,157),wf(:,415))
  call vert_AV_Q(wf(:,-3),wf(:,53),wf(:,416))
  call prop_A_Q(wf(:,416),Q(:,30),MB,1_intkind1,wf(:,417))
  call vert_UV_W(wf(:,53),Q(:,22),wf(:,-5),Q(:,32),wf(:,418))
  call vert_QA_V(wf(:,-1),wf(:,157),wf(:,419))
  call vert_VQ_A(wf(:,37),wf(:,-1),wf(:,420))
  call prop_Q_A(wf(:,420),Q(:,27),MB,1_intkind1,wf(:,421))
  call vert_VQ_A(wf(:,20),wf(:,0),wf(:,422))
  call prop_Q_A(wf(:,422),Q(:,27),MB,1_intkind1,wf(:,423))
  call vert_AV_Q(wf(:,-2),wf(:,37),wf(:,424))
  call prop_A_Q(wf(:,424),Q(:,29),MB,1_intkind1,wf(:,425))
  call vert_UV_W(wf(:,37),Q(:,25),wf(:,-5),Q(:,32),wf(:,426))
  call vert_QA_V(wf(:,0),wf(:,144),wf(:,427))
  call vert_AV_Q(wf(:,-2),wf(:,20),wf(:,428))
  call prop_A_Q(wf(:,428),Q(:,30),MB,1_intkind1,wf(:,429))
  call vert_UV_W(wf(:,20),Q(:,26),wf(:,-5),Q(:,32),wf(:,430))
  call vert_QA_V(wf(:,-1),wf(:,144),wf(:,431))
  call vert_VQ_A(wf(:,69),wf(:,-1),wf(:,432))
  call prop_Q_A(wf(:,432),Q(:,39),MB,1_intkind1,wf(:,433))
  call vert_AV_Q(wf(:,-3),wf(:,69),wf(:,434))
  call prop_A_Q(wf(:,434),Q(:,45),MB,1_intkind1,wf(:,435))
  call vert_VQ_A(wf(:,70),wf(:,-1),wf(:,436))
  call prop_Q_A(wf(:,436),Q(:,43),MB,1_intkind1,wf(:,437))
  call vert_AV_Q(wf(:,-2),wf(:,70),wf(:,438))
  call prop_A_Q(wf(:,438),Q(:,45),MB,1_intkind1,wf(:,439))
  call vert_QA_V(wf(:,111),wf(:,-2),wf(:,440))
  call vert_QA_V(wf(:,111),wf(:,-3),wf(:,441))
  call vert_VQ_A(wf(:,66),wf(:,0),wf(:,442))
  call prop_Q_A(wf(:,442),Q(:,39),MB,1_intkind1,wf(:,443))
  call vert_VQ_A(wf(:,65),wf(:,0),wf(:,444))
  call prop_Q_A(wf(:,444),Q(:,43),MB,1_intkind1,wf(:,445))
  call vert_AV_Q(wf(:,-3),wf(:,66),wf(:,446))
  call prop_A_Q(wf(:,446),Q(:,46),MB,1_intkind1,wf(:,447))
  call vert_AV_Q(wf(:,-2),wf(:,65),wf(:,448))
  call prop_A_Q(wf(:,448),Q(:,46),MB,1_intkind1,wf(:,449))
  call vert_QA_V(wf(:,92),wf(:,-2),wf(:,450))
  call vert_QA_V(wf(:,92),wf(:,-3),wf(:,451))
  call vert_VQ_A(wf(:,71),wf(:,-1),wf(:,452))
  call prop_Q_A(wf(:,452),Q(:,39),MB,1_intkind1,wf(:,453))
  call vert_VQ_A(wf(:,67),wf(:,0),wf(:,454))
  call prop_Q_A(wf(:,454),Q(:,39),MB,1_intkind1,wf(:,455))
  call vert_AV_Q(wf(:,-3),wf(:,71),wf(:,456))
  call prop_A_Q(wf(:,456),Q(:,45),MB,1_intkind1,wf(:,457))
  call vert_QA_V(wf(:,0),wf(:,159),wf(:,458))
  call vert_AV_Q(wf(:,-3),wf(:,67),wf(:,459))
  call prop_A_Q(wf(:,459),Q(:,46),MB,1_intkind1,wf(:,460))
  call vert_QA_V(wf(:,-1),wf(:,159),wf(:,461))
  call vert_VQ_A(wf(:,72),wf(:,-1),wf(:,462))
  call prop_Q_A(wf(:,462),Q(:,43),MB,1_intkind1,wf(:,463))
  call vert_VQ_A(wf(:,68),wf(:,0),wf(:,464))
  call prop_Q_A(wf(:,464),Q(:,43),MB,1_intkind1,wf(:,465))
  call vert_AV_Q(wf(:,-2),wf(:,72),wf(:,466))
  call prop_A_Q(wf(:,466),Q(:,45),MB,1_intkind1,wf(:,467))
  call vert_QA_V(wf(:,0),wf(:,148),wf(:,468))
  call vert_AV_Q(wf(:,-2),wf(:,68),wf(:,469))
  call prop_A_Q(wf(:,469),Q(:,46),MB,1_intkind1,wf(:,470))
  call vert_QA_V(wf(:,-1),wf(:,148),wf(:,471))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,18) - MB2)
  den(3) = 1 / (Q(5,40) - MB2)
  den(6) = 1 / (Q(5,13) - MB2)
  den(9) = 1 / (Q(5,26))
  den(12) = 1 / (Q(5,34) - MB2)
  den(13) = 1 / (Q(5,24) - MB2)
  den(16) = 1 / (Q(5,7) - MB2)
  den(23) = 1 / (Q(5,17) - MB2)
  den(24) = 1 / (Q(5,6))
  den(27) = 1 / (Q(5,25))
  den(30) = 1 / (Q(5,14) - MB2)
  den(33) = 1 / (Q(5,33) - MB2)
  den(42) = 1 / (Q(5,9))
  den(43) = 1 / (Q(5,36) - MB2)
  den(48) = 1 / (Q(5,22))
  den(51) = 1 / (Q(5,20) - MB2)
  den(54) = 1 / (Q(5,11) - MB2)
  den(61) = 1 / (Q(5,10))
  den(64) = 1 / (Q(5,21))
  den(78) = 1 / (Q(5,38))
  den(83) = 1 / (Q(5,42))
  den(86) = 1 / (Q(5,37))
  den(92) = 1 / (Q(5,41))
  den(107) = 1 / (Q(5,48))
  den(114) = 1 / (Q(5,50) - MB2)
  den(132) = 1 / (Q(5,49) - MB2)
  den(159) = 1 / (Q(5,56) - MB2)
  den(165) = 1 / (Q(5,52) - MB2)
  den(189) = 1 / (Q(5,58))
  den(193) = 1 / (Q(5,45) - MB2)
  den(196) = 1 / (Q(5,23) - MB2)
  den(211) = 1 / (Q(5,29) - MB2)
  den(214) = 1 / (Q(5,39) - MB2)
  den(233) = 1 / (Q(5,46) - MB2)
  den(237) = 1 / (Q(5,57))
  den(251) = 1 / (Q(5,30) - MB2)
  den(273) = 1 / (Q(5,54))
  den(279) = 1 / (Q(5,27) - MB2)
  den(295) = 1 / (Q(5,43) - MB2)
  den(316) = 1 / (Q(5,53))
  den(396) = 1 / (Q(5,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(12)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(13)*den(17)
  den(19) = den(9)*den(13)
  den(20) = den(1)*den(19)
  den(21) = den(7)*den(12)
  den(22) = den(3)*den(17)
  den(25) = den(23)*den(24)
  den(26) = den(3)*den(25)
  den(28) = den(23)*den(27)
  den(29) = den(24)*den(28)
  den(31) = den(24)*den(30)
  den(32) = den(23)*den(31)
  den(34) = den(24)*den(33)
  den(35) = den(13)*den(34)
  den(36) = den(16)*den(24)
  den(37) = den(13)*den(36)
  den(38) = den(13)*den(27)
  den(39) = den(24)*den(38)
  den(40) = den(31)*den(33)
  den(41) = den(3)*den(36)
  den(44) = den(2)*den(42)
  den(45) = den(43)*den(44)
  den(46) = den(6)*den(42)
  den(47) = den(2)*den(46)
  den(49) = den(2)*den(48)
  den(50) = den(42)*den(49)
  den(52) = den(12)*den(42)
  den(53) = den(51)*den(52)
  den(55) = den(42)*den(54)
  den(56) = den(51)*den(55)
  den(57) = den(48)*den(51)
  den(58) = den(42)*den(57)
  den(59) = den(12)*den(46)
  den(60) = den(43)*den(55)
  den(62) = den(23)*den(61)
  den(63) = den(43)*den(62)
  den(65) = den(23)*den(64)
  den(66) = den(61)*den(65)
  den(67) = den(30)*den(61)
  den(68) = den(23)*den(67)
  den(69) = den(33)*den(61)
  den(70) = den(51)*den(69)
  den(71) = den(54)*den(61)
  den(72) = den(51)*den(71)
  den(73) = den(51)*den(64)
  den(74) = den(61)*den(73)
  den(75) = den(33)*den(67)
  den(76) = den(43)*den(71)
  den(77) = den(12)*den(65)
  den(79) = den(12)*den(78)
  den(80) = den(23)*den(79)
  den(81) = den(43)*den(78)
  den(82) = den(23)*den(81)
  den(84) = den(3)*den(83)
  den(85) = den(23)*den(84)
  den(87) = den(33)*den(86)
  den(88) = den(2)*den(87)
  den(89) = den(33)*den(49)
  den(90) = den(43)*den(86)
  den(91) = den(2)*den(90)
  den(93) = den(3)*den(92)
  den(94) = den(2)*den(93)
  den(95) = den(33)*den(57)
  den(96) = den(12)*den(73)
  den(97) = den(3)*den(73)
  den(98) = den(51)*den(93)
  den(99) = den(19)*den(33)
  den(100) = den(12)*den(38)
  den(101) = den(13)*den(90)
  den(102) = den(38)*den(43)
  den(103) = den(1)*den(86)
  den(104) = den(61)*den(103)
  den(105) = den(61)*den(83)
  den(106) = den(1)*den(105)
  den(108) = den(1)*den(61)
  den(109) = den(107)*den(108)
  den(110) = den(12)*den(83)
  den(111) = den(1)*den(110)
  den(112) = den(1)*den(84)
  den(113) = den(17)*den(107)
  den(115) = den(107)*den(114)
  den(116) = den(1)*den(115)
  den(117) = den(2)*den(103)
  den(118) = den(2)*den(114)
  den(119) = den(1)*den(118)
  den(120) = den(12)*den(114)
  den(121) = den(1)*den(120)
  den(122) = den(42)*den(92)
  den(123) = den(24)*den(122)
  den(124) = den(24)*den(78)
  den(125) = den(42)*den(124)
  den(126) = den(24)*den(42)
  den(127) = den(107)*den(126)
  den(128) = den(33)*den(92)
  den(129) = den(24)*den(128)
  den(130) = den(24)*den(93)
  den(131) = den(36)*den(107)
  den(133) = den(107)*den(132)
  den(134) = den(24)*den(133)
  den(135) = den(23)*den(132)
  den(136) = den(24)*den(135)
  den(137) = den(23)*den(124)
  den(138) = den(33)*den(132)
  den(139) = den(24)*den(138)
  den(140) = den(42)*den(79)
  den(141) = den(42)*den(81)
  den(142) = den(55)*den(107)
  den(143) = den(42)*den(115)
  den(144) = den(61)*den(87)
  den(145) = den(61)*den(90)
  den(146) = den(71)*den(107)
  den(147) = den(61)*den(133)
  den(148) = den(2)*den(122)
  den(149) = den(42)*den(118)
  den(150) = den(42)*den(120)
  den(151) = den(61)*den(135)
  den(152) = den(23)*den(105)
  den(153) = den(61)*den(138)
  den(154) = den(12)*den(28)
  den(155) = den(23)*den(110)
  den(156) = den(2)*den(128)
  den(157) = den(10)*den(33)
  den(158) = den(13)*den(103)
  den(160) = den(13)*den(159)
  den(161) = den(1)*den(160)
  den(162) = den(3)*den(159)
  den(163) = den(1)*den(162)
  den(164) = den(51)*den(122)
  den(166) = den(51)*den(165)
  den(167) = den(42)*den(166)
  den(168) = den(43)*den(165)
  den(169) = den(42)*den(168)
  den(170) = den(28)*den(43)
  den(171) = den(3)*den(65)
  den(172) = den(51)*den(128)
  den(173) = den(13)*den(87)
  den(174) = den(24)*den(160)
  den(175) = den(13)*den(124)
  den(176) = den(24)*den(162)
  den(177) = den(61)*den(166)
  den(178) = den(51)*den(105)
  den(179) = den(61)*den(168)
  den(180) = den(10)*den(43)
  den(181) = den(3)*den(49)
  den(182) = den(51)*den(110)
  den(183) = den(51)*den(84)
  den(184) = den(3)*den(57)
  den(185) = den(13)*den(79)
  den(186) = den(19)*den(43)
  den(187) = den(13)*den(81)
  den(188) = den(2)*den(3)
  den(190) = den(188)*den(189)
  den(191) = den(1)*den(190)
  den(192) = den(1)*den(3)
  den(194) = den(192)*den(193)
  den(195) = den(2)*den(194)
  den(197) = den(4)*den(196)
  den(198) = den(3)*den(197)
  den(199) = den(1)**2
  den(200) = den(118)*den(199)
  den(201) = den(10)*den(199)
  den(202) = den(2)**2
  den(203) = den(103)*den(202)
  den(204) = den(7)*den(202)
  den(205) = den(7)*den(118)
  den(206) = den(10)*den(103)
  den(207) = den(12)*den(13)
  den(208) = den(189)*den(207)
  den(209) = den(1)*den(208)
  den(210) = den(1)*den(13)
  den(212) = den(210)*den(211)
  den(213) = den(12)*den(212)
  den(215) = den(14)*den(214)
  den(216) = den(13)*den(215)
  den(217) = den(160)*den(199)
  den(218) = den(19)*den(199)
  den(219) = den(13)**2
  den(220) = den(103)*den(219)
  den(221) = den(17)*den(160)
  den(222) = den(19)*den(103)
  den(223) = den(17)*den(219)
  den(224) = den(120)*den(199)
  den(225) = den(12)**2
  den(226) = den(7)*den(225)
  den(227) = den(7)*den(120)
  den(228) = den(162)*den(199)
  den(229) = den(17)*den(162)
  den(230) = den(3)**2
  den(231) = den(17)*den(230)
  den(232) = den(3)*den(24)
  den(234) = den(232)*den(233)
  den(235) = den(23)*den(234)
  den(236) = den(3)*den(23)
  den(238) = den(236)*den(237)
  den(239) = den(24)*den(238)
  den(240) = den(25)*den(196)
  den(241) = den(3)*den(240)
  den(242) = den(23)**2
  den(243) = den(124)*den(242)
  den(244) = den(31)*den(242)
  den(245) = den(24)**2
  den(246) = den(135)*den(245)
  den(247) = den(28)*den(245)
  den(248) = den(28)*den(124)
  den(249) = den(31)*den(135)
  den(250) = den(13)*den(24)
  den(252) = den(250)*den(251)
  den(253) = den(33)*den(252)
  den(254) = den(13)*den(33)
  den(255) = den(237)*den(254)
  den(256) = den(24)*den(255)
  den(257) = den(34)*den(214)
  den(258) = den(13)*den(257)
  den(259) = den(160)*den(245)
  den(260) = den(124)*den(219)
  den(261) = den(36)*den(160)
  den(262) = den(38)*den(124)
  den(263) = den(38)*den(245)
  den(264) = den(36)*den(219)
  den(265) = den(33)**2
  den(266) = den(31)*den(265)
  den(267) = den(138)*den(245)
  den(268) = den(31)*den(138)
  den(269) = den(162)*den(245)
  den(270) = den(36)*den(162)
  den(271) = den(36)*den(230)
  den(272) = den(2)*den(43)
  den(274) = den(272)*den(273)
  den(275) = den(42)*den(274)
  den(276) = den(42)*den(43)
  den(277) = den(193)*den(276)
  den(278) = den(2)*den(277)
  den(280) = den(44)*den(279)
  den(281) = den(43)*den(280)
  den(282) = den(42)**2
  den(283) = den(118)*den(282)
  den(284) = den(49)*den(282)
  den(285) = den(122)*den(202)
  den(286) = den(46)*den(202)
  den(287) = den(46)*den(118)
  den(288) = den(49)*den(122)
  den(289) = den(12)*den(51)
  den(290) = den(273)*den(289)
  den(291) = den(42)*den(290)
  den(292) = den(42)*den(51)
  den(293) = den(211)*den(292)
  den(294) = den(12)*den(293)
  den(296) = den(52)*den(295)
  den(297) = den(51)*den(296)
  den(298) = den(166)*den(282)
  den(299) = den(57)*den(282)
  den(300) = den(51)**2
  den(301) = den(122)*den(300)
  den(302) = den(55)*den(166)
  den(303) = den(57)*den(122)
  den(304) = den(55)*den(300)
  den(305) = den(120)*den(282)
  den(306) = den(46)*den(225)
  den(307) = den(46)*den(120)
  den(308) = den(168)*den(282)
  den(309) = den(55)*den(168)
  den(310) = den(43)**2
  den(311) = den(55)*den(310)
  den(312) = den(43)*den(61)
  den(313) = den(233)*den(312)
  den(314) = den(23)*den(313)
  den(315) = den(23)*den(43)
  den(317) = den(315)*den(316)
  den(318) = den(61)*den(317)
  den(319) = den(62)*den(279)
  den(320) = den(43)*den(319)
  den(321) = den(105)*den(242)
  den(322) = den(67)*den(242)
  den(323) = den(61)**2
  den(324) = den(135)*den(323)
  den(325) = den(65)*den(323)
  den(326) = den(65)*den(105)
  den(327) = den(67)*den(135)
  den(328) = den(51)*den(61)
  den(329) = den(251)*den(328)
  den(330) = den(33)*den(329)
  den(331) = den(33)*den(51)
  den(332) = den(316)*den(331)
  den(333) = den(61)*den(332)
  den(334) = den(69)*den(295)
  den(335) = den(51)*den(334)
  den(336) = den(166)*den(323)
  den(337) = den(105)*den(300)
  den(338) = den(71)*den(166)
  den(339) = den(73)*den(105)
  den(340) = den(73)*den(323)
  den(341) = den(71)*den(300)
  den(342) = den(67)*den(265)
  den(343) = den(138)*den(323)
  den(344) = den(67)*den(138)
  den(345) = den(168)*den(323)
  den(346) = den(71)*den(168)
  den(347) = den(71)*den(310)
  den(348) = den(110)*den(242)
  den(349) = den(79)*den(242)
  den(350) = den(28)*den(225)
  den(351) = den(65)*den(225)
  den(352) = den(65)*den(110)
  den(353) = den(28)*den(79)
  den(354) = den(81)*den(242)
  den(355) = den(28)*den(310)
  den(356) = den(28)*den(81)
  den(357) = den(84)*den(242)
  den(358) = den(65)*den(84)
  den(359) = den(65)*den(230)
  den(360) = den(10)*den(265)
  den(361) = den(49)*den(265)
  den(362) = den(128)*den(202)
  den(363) = den(87)*den(202)
  den(364) = den(10)*den(87)
  den(365) = den(49)*den(128)
  den(366) = den(10)*den(310)
  den(367) = den(10)*den(90)
  den(368) = den(90)*den(202)
  den(369) = den(49)*den(93)
  den(370) = den(49)*den(230)
  den(371) = den(93)*den(202)
  den(372) = den(57)*den(265)
  den(373) = den(128)*den(300)
  den(374) = den(57)*den(128)
  den(375) = den(110)*den(300)
  den(376) = den(73)*den(110)
  den(377) = den(73)*den(225)
  den(378) = den(73)*den(84)
  den(379) = den(57)*den(93)
  den(380) = den(84)*den(300)
  den(381) = den(57)*den(230)
  den(382) = den(93)*den(300)
  den(383) = den(73)*den(230)
  den(384) = den(19)*den(265)
  den(385) = den(19)*den(87)
  den(386) = den(87)*den(219)
  den(387) = den(38)*den(79)
  den(388) = den(79)*den(219)
  den(389) = den(38)*den(225)
  den(390) = den(19)*den(90)
  den(391) = den(38)*den(81)
  den(392) = den(19)*den(310)
  den(393) = den(81)*den(219)
  den(394) = den(38)*den(310)
  den(395) = den(90)*den(219)
  den(397) = den(108)*den(396)
  den(398) = den(17)*den(396)
  den(399) = den(17)*den(196)
  den(400) = den(17)*den(214)
  den(401) = den(7)*den(396)
  den(402) = den(7)*den(211)
  den(403) = den(7)*den(193)
  den(404) = den(103)*den(214)
  den(405) = den(103)*den(193)
  den(406) = den(126)*den(396)
  den(407) = den(36)*den(396)
  den(408) = den(36)*den(196)
  den(409) = den(36)*den(214)
  den(410) = den(31)*den(396)
  den(411) = den(124)*den(214)
  den(412) = den(31)*den(251)
  den(413) = den(31)*den(233)
  den(414) = den(124)*den(233)
  den(415) = den(55)*den(396)
  den(416) = den(55)*den(279)
  den(417) = den(55)*den(295)
  den(418) = den(46)*den(396)
  den(419) = den(46)*den(211)
  den(420) = den(46)*den(193)
  den(421) = den(122)*den(295)
  den(422) = den(122)*den(193)
  den(423) = den(71)*den(396)
  den(424) = den(71)*den(279)
  den(425) = den(71)*den(295)
  den(426) = den(67)*den(396)
  den(427) = den(105)*den(295)
  den(428) = den(67)*den(251)
  den(429) = den(67)*den(233)
  den(430) = den(105)*den(233)
  den(431) = den(65)*den(196)
  den(432) = den(65)*den(211)
  den(433) = den(65)*den(316)
  den(434) = den(28)*den(279)
  den(435) = den(28)*den(211)
  den(436) = den(28)*den(237)
  den(437) = den(135)*den(316)
  den(438) = den(135)*den(237)
  den(439) = den(49)*den(196)
  den(440) = den(10)*den(279)
  den(441) = den(49)*den(251)
  den(442) = den(49)*den(273)
  den(443) = den(10)*den(251)
  den(444) = den(10)*den(189)
  den(445) = den(118)*den(273)
  den(446) = den(118)*den(189)
  den(447) = den(73)*den(196)
  den(448) = den(57)*den(196)
  den(449) = den(73)*den(211)
  den(450) = den(73)*den(316)
  den(451) = den(166)*den(316)
  den(452) = den(57)*den(251)
  den(453) = den(57)*den(273)
  den(454) = den(166)*den(273)
  den(455) = den(38)*den(279)
  den(456) = den(19)*den(279)
  den(457) = den(38)*den(211)
  den(458) = den(38)*den(237)
  den(459) = den(160)*den(237)
  den(460) = den(19)*den(251)
  den(461) = den(19)*den(189)
  den(462) = den(160)*den(189)
  den(463) = den(87)*den(214)
  den(464) = den(87)*den(193)
  den(465) = den(128)*den(295)
  den(466) = den(128)*den(193)
  den(467) = den(138)*den(316)
  den(468) = den(138)*den(237)
  den(469) = den(79)*den(214)
  den(470) = den(110)*den(295)
  den(471) = den(79)*den(233)
  den(472) = den(110)*den(233)
  den(473) = den(120)*den(273)
  den(474) = den(120)*den(189)
  den(475) = den(90)*den(214)
  den(476) = den(81)*den(214)
  den(477) = den(90)*den(193)
  den(478) = den(168)*den(316)
  den(479) = den(81)*den(233)
  den(480) = den(168)*den(273)
  den(481) = den(93)*den(295)
  den(482) = den(84)*den(295)
  den(483) = den(93)*den(193)
  den(484) = den(162)*den(237)
  den(485) = den(84)*den(233)
  den(486) = den(162)*den(189)
  den(487) = den(1)*den(2)*den(3)
  den(488) = den(1)*den(12)*den(13)
  den(489) = den(3)*den(23)*den(24)
  den(490) = den(13)*den(24)*den(33)
  den(491) = den(2)*den(42)*den(43)
  den(492) = den(12)*den(42)*den(51)
  den(493) = den(23)*den(43)*den(61)
  den(494) = den(33)*den(51)*den(61)
  den(495) = den(12)*den(23)
  den(496) = den(2)*den(33)
  den(497) = den(3)*den(51)
  den(498) = den(13)*den(43)
  den(499) = den(2)*den(403)
  den(500) = den(2)*den(405)
  den(501) = den(1)*den(444)
  den(502) = den(1)*den(446)
  den(503) = den(13)*den(400)
  den(504) = den(13)*den(404)
  den(505) = den(1)*den(461)
  den(506) = den(1)*den(462)
  den(507) = den(12)*den(402)
  den(508) = den(1)*den(474)
  den(509) = den(3)*den(399)
  den(510) = den(1)*den(486)
  den(511) = den(24)*den(436)
  den(512) = den(24)*den(438)
  den(513) = den(23)*den(413)
  den(514) = den(23)*den(414)
  den(515) = den(13)*den(409)
  den(516) = den(24)*den(458)
  den(517) = den(13)*den(411)
  den(518) = den(24)*den(459)
  den(519) = den(24)*den(468)
  den(520) = den(33)*den(412)
  den(521) = den(3)*den(408)
  den(522) = den(24)*den(484)
  den(523) = den(2)*den(420)
  den(524) = den(2)*den(422)
  den(525) = den(42)*den(442)
  den(526) = den(42)*den(445)
  den(527) = den(51)*den(417)
  den(528) = den(51)*den(421)
  den(529) = den(42)*den(453)
  den(530) = den(42)*den(454)
  den(531) = den(12)*den(419)
  den(532) = den(42)*den(473)
  den(533) = den(43)*den(416)
  den(534) = den(42)*den(480)
  den(535) = den(61)*den(433)
  den(536) = den(61)*den(437)
  den(537) = den(23)*den(429)
  den(538) = den(23)*den(430)
  den(539) = den(51)*den(425)
  den(540) = den(61)*den(450)
  den(541) = den(51)*den(427)
  den(542) = den(61)*den(451)
  den(543) = den(61)*den(467)
  den(544) = den(33)*den(428)
  den(545) = den(43)*den(424)
  den(546) = den(61)*den(478)
  den(547) = den(12)*den(432)
  den(548) = den(12)*den(435)
  den(549) = den(23)*den(471)
  den(550) = den(23)*den(472)
  den(551) = den(43)*den(434)
  den(552) = den(23)*den(479)
  den(553) = den(3)*den(431)
  den(554) = den(23)*den(485)
  den(555) = den(2)*den(464)
  den(556) = den(2)*den(466)
  den(557) = den(33)*den(441)
  den(558) = den(33)*den(443)
  den(559) = den(2)*den(477)
  den(560) = den(43)*den(440)
  den(561) = den(2)*den(483)
  den(562) = den(3)*den(439)
  den(563) = den(51)*den(465)
  den(564) = den(33)*den(452)
  den(565) = den(12)*den(449)
  den(566) = den(51)*den(470)
  den(567) = den(3)*den(447)
  den(568) = den(51)*den(481)
  den(569) = den(3)*den(448)
  den(570) = den(51)*den(482)
  den(571) = den(13)*den(463)
  den(572) = den(33)*den(460)
  den(573) = den(12)*den(457)
  den(574) = den(13)*den(469)
  den(575) = den(13)*den(475)
  den(576) = den(43)*den(455)
  den(577) = den(13)*den(476)
  den(578) = den(43)*den(456)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(428)

  A(1) = cont_QA(wf(:,5),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,8),wf(:,9)) * den(8)
  A(3) = cont_VV(wf(:,10),wf(:,11)) * den(11)
  A(4) = cont_QA(wf(:,15),wf(:,16)) * den(15)
  A(5) = cont_QA(wf(:,18),wf(:,19)) * den(18)
  A(6) = cont_VV(wf(:,11),wf(:,20)) * den(20)
  A(7) = cont_QA(wf(:,9),wf(:,21)) * den(21)
  A(8) = cont_QA(wf(:,19),wf(:,22)) * den(22)
  A(9) = cont_QA(wf(:,5),wf(:,26)) * den(26)
  A(10) = cont_VV(wf(:,27),wf(:,28)) * den(29)
  A(11) = cont_QA(wf(:,30),wf(:,31)) * den(32)
  A(12) = cont_QA(wf(:,15),wf(:,34)) * den(35)
  A(13) = cont_QA(wf(:,18),wf(:,36)) * den(37)
  A(14) = cont_VV(wf(:,28),wf(:,37)) * den(39)
  A(15) = cont_QA(wf(:,31),wf(:,38)) * den(40)
  A(16) = cont_QA(wf(:,22),wf(:,36)) * den(41)
  A(17) = cont_QA(wf(:,41),wf(:,42)) * den(45)
  A(18) = cont_QA(wf(:,8),wf(:,44)) * den(47)
  A(19) = cont_VV(wf(:,45),wf(:,46)) * den(50)
  A(20) = cont_QA(wf(:,48),wf(:,49)) * den(53)
  A(21) = cont_QA(wf(:,51),wf(:,52)) * den(56)
  A(22) = cont_VV(wf(:,46),wf(:,53)) * den(58)
  A(23) = cont_QA(wf(:,21),wf(:,44)) * den(59)
  A(24) = cont_QA(wf(:,52),wf(:,54)) * den(60)
  A(25) = cont_QA(wf(:,41),wf(:,56)) * den(63)
  A(26) = cont_VV(wf(:,57),wf(:,58)) * den(66)
  A(27) = cont_QA(wf(:,30),wf(:,60)) * den(68)
  A(28) = cont_QA(wf(:,48),wf(:,61)) * den(70)
  A(29) = cont_QA(wf(:,51),wf(:,63)) * den(72)
  A(30) = cont_VV(wf(:,58),wf(:,64)) * den(74)
  A(31) = cont_QA(wf(:,38),wf(:,60)) * den(75)
  A(32) = cont_QA(wf(:,54),wf(:,63)) * den(76)
  A(33) = cont_VV(wf(:,57),wf(:,65)) * den(77)
  A(34) = cont_VV(wf(:,27),wf(:,66)) * den(80)
  A(35) = cont_VV(wf(:,27),wf(:,67)) * den(82)
  A(36) = cont_VV(wf(:,57),wf(:,68)) * den(85)
  A(37) = cont_VV(wf(:,10),wf(:,69)) * den(88)
  A(38) = cont_VV(wf(:,45),wf(:,70)) * den(89)
  A(39) = cont_VV(wf(:,10),wf(:,71)) * den(91)
  A(40) = cont_VV(wf(:,45),wf(:,72)) * den(94)
  A(41) = cont_VV(wf(:,53),wf(:,70)) * den(95)
  A(42) = cont_VV(wf(:,64),wf(:,65)) * den(96)
  A(43) = cont_VV(wf(:,64),wf(:,68)) * den(97)
  A(44) = cont_VV(wf(:,53),wf(:,72)) * den(98)
  A(45) = cont_VV(wf(:,20),wf(:,69)) * den(99)
  A(46) = cont_VV(wf(:,37),wf(:,66)) * den(100)
  A(47) = cont_VV(wf(:,20),wf(:,71)) * den(101)
  A(48) = cont_VV(wf(:,37),wf(:,67)) * den(102)

  A(49) = cont_VV(wf(:,11),wf(:,73)) * den(104)
  A(50) = cont_VV(wf(:,11),wf(:,73)) * den(104)
  A(51) = cont_VV(wf(:,58),wf(:,74)) * den(106)
  A(52) = cont_VV(wf(:,58),wf(:,74)) * den(106)
  A(53) = cont_VV(wf(:,75),wf(:,76)) * den(109)
  A(54) = cont_VV(wf(:,75),wf(:,76)) * den(109)
  A(55) = cont_QA(wf(:,5),wf(:,77)) * den(5)
  A(56) = cont_QA(wf(:,9),wf(:,78)) * den(8)
  A(57) = cont_VV(wf(:,10),wf(:,79)) * den(11)
  A(58) = cont_QA(wf(:,15),wf(:,80)) * den(15)
  A(59) = cont_QA(wf(:,19),wf(:,81)) * den(18)
  A(60) = cont_VV(wf(:,20),wf(:,79)) * den(20)
  A(61) = cont_QA(wf(:,9),wf(:,82)) * den(21)
  A(62) = cont_VV(wf(:,65),wf(:,74)) * den(111)
  A(63) = cont_VV(wf(:,65),wf(:,74)) * den(111)
  A(64) = cont_QA(wf(:,19),wf(:,83)) * den(22)
  A(65) = cont_VV(wf(:,68),wf(:,74)) * den(112)
  A(66) = cont_VV(wf(:,68),wf(:,74)) * den(112)
  A(67) = cont_QA(wf(:,19),wf(:,84)) * den(113)
  A(68) = cont_QA(wf(:,19),wf(:,84)) * den(113)
  A(69) = cont_QA(wf(:,7),wf(:,86)) * den(116)
  A(70) = cont_QA(wf(:,7),wf(:,86)) * den(116)
  A(71) = cont_VV(wf(:,11),wf(:,87)) * den(117)
  A(72) = cont_QA(wf(:,88),wf(:,89)) * den(119)
  A(73) = cont_QA(wf(:,6),wf(:,91)) * den(5)
  A(74) = cont_QA(wf(:,88),wf(:,92)) * den(121)
  A(75) = cont_QA(wf(:,19),wf(:,93)) * den(22)
  A(76) = cont_QA(wf(:,16),wf(:,95)) * den(15)
  A(77) = cont_QA(wf(:,19),wf(:,96)) * den(18)
  A(78) = cont_VV(wf(:,11),wf(:,97)) * den(20)
  A(79) = cont_VV(wf(:,46),wf(:,98)) * den(123)
  A(80) = cont_VV(wf(:,46),wf(:,98)) * den(123)
  A(81) = cont_VV(wf(:,28),wf(:,99)) * den(125)
  A(82) = cont_VV(wf(:,28),wf(:,99)) * den(125)
  A(83) = cont_VV(wf(:,75),wf(:,100)) * den(127)
  A(84) = cont_VV(wf(:,75),wf(:,100)) * den(127)
  A(85) = cont_QA(wf(:,5),wf(:,101)) * den(26)
  A(86) = cont_VV(wf(:,27),wf(:,102)) * den(29)
  A(87) = cont_QA(wf(:,31),wf(:,103)) * den(32)
  A(88) = cont_QA(wf(:,15),wf(:,104)) * den(35)
  A(89) = cont_QA(wf(:,36),wf(:,81)) * den(37)
  A(90) = cont_VV(wf(:,37),wf(:,102)) * den(39)
  A(91) = cont_VV(wf(:,70),wf(:,98)) * den(129)
  A(92) = cont_VV(wf(:,70),wf(:,98)) * den(129)
  A(93) = cont_QA(wf(:,31),wf(:,105)) * den(40)
  A(94) = cont_QA(wf(:,36),wf(:,83)) * den(41)
  A(95) = cont_VV(wf(:,72),wf(:,98)) * den(130)
  A(96) = cont_VV(wf(:,72),wf(:,98)) * den(130)
  A(97) = cont_QA(wf(:,36),wf(:,84)) * den(131)
  A(98) = cont_QA(wf(:,36),wf(:,84)) * den(131)
  A(99) = cont_QA(wf(:,29),wf(:,107)) * den(134)
  A(100) = cont_QA(wf(:,29),wf(:,107)) * den(134)
  A(101) = cont_QA(wf(:,108),wf(:,109)) * den(136)
  A(102) = cont_VV(wf(:,28),wf(:,110)) * den(137)
  A(103) = cont_QA(wf(:,26),wf(:,91)) * den(26)
  A(104) = cont_QA(wf(:,108),wf(:,111)) * den(139)
  A(105) = cont_QA(wf(:,36),wf(:,93)) * den(41)
  A(106) = cont_QA(wf(:,34),wf(:,95)) * den(35)
  A(107) = cont_QA(wf(:,36),wf(:,96)) * den(37)
  A(108) = cont_VV(wf(:,28),wf(:,112)) * den(39)
  A(109) = cont_QA(wf(:,41),wf(:,113)) * den(45)
  A(110) = cont_QA(wf(:,44),wf(:,78)) * den(47)
  A(111) = cont_VV(wf(:,45),wf(:,114)) * den(50)
  A(112) = cont_QA(wf(:,48),wf(:,115)) * den(53)
  A(113) = cont_QA(wf(:,52),wf(:,116)) * den(56)
  A(114) = cont_VV(wf(:,53),wf(:,114)) * den(58)
  A(115) = cont_QA(wf(:,44),wf(:,82)) * den(59)
  A(116) = cont_VV(wf(:,66),wf(:,99)) * den(140)
  A(117) = cont_VV(wf(:,66),wf(:,99)) * den(140)
  A(118) = cont_QA(wf(:,52),wf(:,117)) * den(60)
  A(119) = cont_VV(wf(:,67),wf(:,99)) * den(141)
  A(120) = cont_VV(wf(:,67),wf(:,99)) * den(141)
  A(121) = cont_QA(wf(:,52),wf(:,118)) * den(142)
  A(122) = cont_QA(wf(:,52),wf(:,118)) * den(142)
  A(123) = cont_QA(wf(:,43),wf(:,86)) * den(143)
  A(124) = cont_QA(wf(:,43),wf(:,86)) * den(143)
  A(125) = cont_QA(wf(:,41),wf(:,119)) * den(63)
  A(126) = cont_VV(wf(:,57),wf(:,120)) * den(66)
  A(127) = cont_QA(wf(:,60),wf(:,103)) * den(68)
  A(128) = cont_QA(wf(:,48),wf(:,121)) * den(70)
  A(129) = cont_QA(wf(:,63),wf(:,116)) * den(72)
  A(130) = cont_VV(wf(:,64),wf(:,120)) * den(74)
  A(131) = cont_VV(wf(:,69),wf(:,73)) * den(144)
  A(132) = cont_VV(wf(:,69),wf(:,73)) * den(144)
  A(133) = cont_QA(wf(:,60),wf(:,105)) * den(75)
  A(134) = cont_QA(wf(:,63),wf(:,117)) * den(76)
  A(135) = cont_VV(wf(:,71),wf(:,73)) * den(145)
  A(136) = cont_VV(wf(:,71),wf(:,73)) * den(145)
  A(137) = cont_QA(wf(:,63),wf(:,118)) * den(146)
  A(138) = cont_QA(wf(:,63),wf(:,118)) * den(146)
  A(139) = cont_QA(wf(:,59),wf(:,107)) * den(147)
  A(140) = cont_QA(wf(:,59),wf(:,107)) * den(147)
  A(141) = cont_VV(wf(:,57),wf(:,122)) * den(77)
  A(142) = cont_VV(wf(:,66),wf(:,110)) * den(80)
  A(143) = cont_VV(wf(:,67),wf(:,110)) * den(82)
  A(144) = cont_VV(wf(:,57),wf(:,123)) * den(85)
  A(145) = cont_VV(wf(:,69),wf(:,87)) * den(88)
  A(146) = cont_VV(wf(:,45),wf(:,124)) * den(89)
  A(147) = cont_VV(wf(:,71),wf(:,87)) * den(91)
  A(148) = cont_VV(wf(:,45),wf(:,125)) * den(94)
  A(149) = cont_VV(wf(:,53),wf(:,124)) * den(95)
  A(150) = cont_VV(wf(:,64),wf(:,122)) * den(96)
  A(151) = cont_VV(wf(:,64),wf(:,123)) * den(97)
  A(152) = cont_VV(wf(:,53),wf(:,125)) * den(98)
  A(153) = cont_VV(wf(:,69),wf(:,97)) * den(99)
  A(154) = cont_VV(wf(:,66),wf(:,112)) * den(100)
  A(155) = cont_VV(wf(:,71),wf(:,97)) * den(101)
  A(156) = cont_VV(wf(:,67),wf(:,112)) * den(102)
  A(157) = cont_VV(wf(:,46),wf(:,126)) * den(148)
  A(158) = cont_QA(wf(:,89),wf(:,127)) * den(149)
  A(159) = cont_QA(wf(:,42),wf(:,129)) * den(45)
  A(160) = cont_QA(wf(:,92),wf(:,127)) * den(150)
  A(161) = cont_QA(wf(:,52),wf(:,130)) * den(60)
  A(162) = cont_QA(wf(:,49),wf(:,132)) * den(53)
  A(163) = cont_QA(wf(:,52),wf(:,133)) * den(56)
  A(164) = cont_VV(wf(:,46),wf(:,134)) * den(58)
  A(165) = cont_QA(wf(:,109),wf(:,135)) * den(151)
  A(166) = cont_VV(wf(:,58),wf(:,136)) * den(152)
  A(167) = cont_QA(wf(:,56),wf(:,129)) * den(63)
  A(168) = cont_QA(wf(:,111),wf(:,135)) * den(153)
  A(169) = cont_QA(wf(:,63),wf(:,130)) * den(76)
  A(170) = cont_QA(wf(:,61),wf(:,132)) * den(70)
  A(171) = cont_QA(wf(:,63),wf(:,133)) * den(72)
  A(172) = cont_VV(wf(:,58),wf(:,137)) * den(74)
  A(173) = cont_VV(wf(:,27),wf(:,138)) * den(154)
  A(174) = cont_VV(wf(:,65),wf(:,136)) * den(155)
  A(175) = cont_VV(wf(:,68),wf(:,136)) * den(85)
  A(176) = cont_VV(wf(:,27),wf(:,139)) * den(82)
  A(177) = cont_VV(wf(:,70),wf(:,126)) * den(156)
  A(178) = cont_VV(wf(:,10),wf(:,140)) * den(157)
  A(179) = cont_VV(wf(:,72),wf(:,126)) * den(94)
  A(180) = cont_VV(wf(:,10),wf(:,141)) * den(91)
  A(181) = cont_VV(wf(:,20),wf(:,140)) * den(99)
  A(182) = cont_VV(wf(:,37),wf(:,138)) * den(100)
  A(183) = cont_VV(wf(:,37),wf(:,139)) * den(102)
  A(184) = cont_VV(wf(:,20),wf(:,141)) * den(101)
  A(185) = cont_VV(wf(:,70),wf(:,134)) * den(95)
  A(186) = cont_VV(wf(:,65),wf(:,137)) * den(96)
  A(187) = cont_VV(wf(:,72),wf(:,134)) * den(98)
  A(188) = cont_VV(wf(:,68),wf(:,137)) * den(97)
  A(189) = cont_VV(wf(:,11),wf(:,142)) * den(158)
  A(190) = cont_QA(wf(:,143),wf(:,144)) * den(161)
  A(191) = cont_QA(wf(:,15),wf(:,147)) * den(15)
  A(192) = cont_QA(wf(:,143),wf(:,148)) * den(163)
  A(193) = cont_QA(wf(:,9),wf(:,149)) * den(21)
  A(194) = cont_QA(wf(:,5),wf(:,152)) * den(5)
  A(195) = cont_QA(wf(:,9),wf(:,153)) * den(8)
  A(196) = cont_VV(wf(:,11),wf(:,154)) * den(11)
  A(197) = cont_VV(wf(:,46),wf(:,155)) * den(164)
  A(198) = cont_QA(wf(:,156),wf(:,157)) * den(167)
  A(199) = cont_QA(wf(:,48),wf(:,158)) * den(53)
  A(200) = cont_QA(wf(:,156),wf(:,159)) * den(169)
  A(201) = cont_QA(wf(:,44),wf(:,149)) * den(59)
  A(202) = cont_QA(wf(:,41),wf(:,160)) * den(45)
  A(203) = cont_QA(wf(:,44),wf(:,153)) * den(47)
  A(204) = cont_VV(wf(:,46),wf(:,161)) * den(50)
  A(205) = cont_VV(wf(:,27),wf(:,162)) * den(170)
  A(206) = cont_VV(wf(:,57),wf(:,163)) * den(171)
  A(207) = cont_VV(wf(:,57),wf(:,164)) * den(77)
  A(208) = cont_VV(wf(:,27),wf(:,165)) * den(80)
  A(209) = cont_VV(wf(:,70),wf(:,155)) * den(172)
  A(210) = cont_VV(wf(:,64),wf(:,163)) * den(97)
  A(211) = cont_VV(wf(:,72),wf(:,155)) * den(98)
  A(212) = cont_VV(wf(:,64),wf(:,164)) * den(96)
  A(213) = cont_VV(wf(:,69),wf(:,142)) * den(173)
  A(214) = cont_VV(wf(:,71),wf(:,142)) * den(101)
  A(215) = cont_VV(wf(:,37),wf(:,162)) * den(102)
  A(216) = cont_VV(wf(:,37),wf(:,165)) * den(100)
  A(217) = cont_VV(wf(:,69),wf(:,154)) * den(88)
  A(218) = cont_VV(wf(:,70),wf(:,161)) * den(89)
  A(219) = cont_VV(wf(:,71),wf(:,154)) * den(91)
  A(220) = cont_VV(wf(:,72),wf(:,161)) * den(94)
  A(221) = cont_QA(wf(:,41),wf(:,167)) * den(63)
  A(222) = cont_VV(wf(:,57),wf(:,168)) * den(66)
  A(223) = cont_QA(wf(:,30),wf(:,170)) * den(68)
  A(224) = cont_QA(wf(:,48),wf(:,171)) * den(70)
  A(225) = cont_VV(wf(:,64),wf(:,168)) * den(74)
  A(226) = cont_QA(wf(:,51),wf(:,173)) * den(72)
  A(227) = cont_QA(wf(:,38),wf(:,170)) * den(75)
  A(228) = cont_QA(wf(:,54),wf(:,173)) * den(76)
  A(229) = cont_QA(wf(:,5),wf(:,175)) * den(26)
  A(230) = cont_VV(wf(:,27),wf(:,176)) * den(29)
  A(231) = cont_QA(wf(:,30),wf(:,178)) * den(32)
  A(232) = cont_QA(wf(:,15),wf(:,179)) * den(35)
  A(233) = cont_VV(wf(:,37),wf(:,176)) * den(39)
  A(234) = cont_QA(wf(:,18),wf(:,181)) * den(37)
  A(235) = cont_QA(wf(:,38),wf(:,178)) * den(40)
  A(236) = cont_QA(wf(:,22),wf(:,181)) * den(41)
  A(237) = cont_QA(wf(:,144),wf(:,182)) * den(174)
  A(238) = cont_VV(wf(:,28),wf(:,183)) * den(175)
  A(239) = cont_QA(wf(:,15),wf(:,186)) * den(35)
  A(240) = cont_QA(wf(:,148),wf(:,182)) * den(176)
  A(241) = cont_QA(wf(:,31),wf(:,187)) * den(40)
  A(242) = cont_QA(wf(:,5),wf(:,190)) * den(26)
  A(243) = cont_VV(wf(:,28),wf(:,191)) * den(29)
  A(244) = cont_QA(wf(:,31),wf(:,192)) * den(32)
  A(245) = cont_QA(wf(:,157),wf(:,193)) * den(177)
  A(246) = cont_VV(wf(:,58),wf(:,194)) * den(178)
  A(247) = cont_QA(wf(:,48),wf(:,195)) * den(70)
  A(248) = cont_QA(wf(:,159),wf(:,193)) * den(179)
  A(249) = cont_QA(wf(:,60),wf(:,187)) * den(75)
  A(250) = cont_QA(wf(:,41),wf(:,196)) * den(63)
  A(251) = cont_VV(wf(:,58),wf(:,197)) * den(66)
  A(252) = cont_QA(wf(:,60),wf(:,192)) * den(68)
  A(253) = cont_VV(wf(:,10),wf(:,198)) * den(180)
  A(254) = cont_VV(wf(:,45),wf(:,199)) * den(181)
  A(255) = cont_VV(wf(:,10),wf(:,200)) * den(88)
  A(256) = cont_VV(wf(:,45),wf(:,201)) * den(89)
  A(257) = cont_VV(wf(:,65),wf(:,194)) * den(182)
  A(258) = cont_VV(wf(:,68),wf(:,194)) * den(183)
  A(259) = cont_VV(wf(:,53),wf(:,199)) * den(184)
  A(260) = cont_VV(wf(:,53),wf(:,201)) * den(95)
  A(261) = cont_VV(wf(:,66),wf(:,183)) * den(185)
  A(262) = cont_VV(wf(:,20),wf(:,198)) * den(186)
  A(263) = cont_VV(wf(:,67),wf(:,183)) * den(187)
  A(264) = cont_VV(wf(:,20),wf(:,200)) * den(99)
  A(265) = cont_VV(wf(:,65),wf(:,197)) * den(77)
  A(266) = cont_VV(wf(:,66),wf(:,191)) * den(80)
  A(267) = cont_VV(wf(:,67),wf(:,191)) * den(82)
  A(268) = cont_VV(wf(:,68),wf(:,197)) * den(85)
  A(269) = cont_QA(wf(:,41),wf(:,203)) * den(45)
  A(270) = cont_QA(wf(:,8),wf(:,205)) * den(47)
  A(271) = cont_VV(wf(:,45),wf(:,206)) * den(50)
  A(272) = cont_QA(wf(:,48),wf(:,207)) * den(53)
  A(273) = cont_QA(wf(:,51),wf(:,209)) * den(56)
  A(274) = cont_VV(wf(:,53),wf(:,206)) * den(58)
  A(275) = cont_QA(wf(:,21),wf(:,205)) * den(59)
  A(276) = cont_QA(wf(:,54),wf(:,209)) * den(60)
  A(277) = cont_QA(wf(:,5),wf(:,211)) * den(5)
  A(278) = cont_QA(wf(:,8),wf(:,213)) * den(8)
  A(279) = cont_VV(wf(:,10),wf(:,214)) * den(11)
  A(280) = cont_QA(wf(:,15),wf(:,215)) * den(15)
  A(281) = cont_QA(wf(:,18),wf(:,217)) * den(18)
  A(282) = cont_VV(wf(:,20),wf(:,214)) * den(20)
  A(283) = cont_QA(wf(:,21),wf(:,213)) * den(21)
  A(284) = cont_QA(wf(:,22),wf(:,217)) * den(22)
  A(285) = cont_VV(wf(:,218),wf(:,219)) * den(191)
  A(286) = cont_QA(wf(:,221),wf(:,222)) * den(195)
  A(287) = cont_QA(wf(:,223),wf(:,224)) * den(198)
  A(288) = cont_QA(wf(:,89),wf(:,225)) * den(200)
  A(289) = cont_VV(wf(:,10),wf(:,226)) * den(201)
  A(290) = cont_VV(wf(:,11),wf(:,228)) * den(203)
  A(291) = cont_QA(wf(:,9),wf(:,229)) * den(204)
  A(292) = cont_QA(wf(:,89),wf(:,230)) * den(205)
  A(293) = cont_VV(wf(:,11),wf(:,231)) * den(206)
  A(294) = cont_VV(wf(:,219),wf(:,232)) * den(209)
  A(295) = cont_QA(wf(:,234),wf(:,235)) * den(213)
  A(296) = cont_QA(wf(:,236),wf(:,237)) * den(216)
  A(297) = cont_QA(wf(:,144),wf(:,238)) * den(217)
  A(298) = cont_VV(wf(:,20),wf(:,226)) * den(218)
  A(299) = cont_VV(wf(:,11),wf(:,240)) * den(220)
  A(300) = cont_QA(wf(:,144),wf(:,241)) * den(221)
  A(301) = cont_VV(wf(:,11),wf(:,242)) * den(222)
  A(302) = cont_QA(wf(:,19),wf(:,243)) * den(223)
  A(303) = cont_QA(wf(:,92),wf(:,225)) * den(224)
  A(304) = cont_QA(wf(:,9),wf(:,245)) * den(226)
  A(305) = cont_QA(wf(:,92),wf(:,230)) * den(227)
  A(306) = cont_QA(wf(:,148),wf(:,238)) * den(228)
  A(307) = cont_QA(wf(:,148),wf(:,241)) * den(229)
  A(308) = cont_QA(wf(:,19),wf(:,247)) * den(231)
  A(309) = cont_QA(wf(:,249),wf(:,250)) * den(235)
  A(310) = cont_VV(wf(:,251),wf(:,252)) * den(239)
  A(311) = cont_QA(wf(:,223),wf(:,253)) * den(241)
  A(312) = cont_VV(wf(:,28),wf(:,255)) * den(243)
  A(313) = cont_QA(wf(:,31),wf(:,256)) * den(244)
  A(314) = cont_QA(wf(:,109),wf(:,257)) * den(246)
  A(315) = cont_VV(wf(:,27),wf(:,258)) * den(247)
  A(316) = cont_VV(wf(:,28),wf(:,259)) * den(248)
  A(317) = cont_QA(wf(:,109),wf(:,260)) * den(249)
  A(318) = cont_QA(wf(:,262),wf(:,263)) * den(253)
  A(319) = cont_VV(wf(:,252),wf(:,264)) * den(256)
  A(320) = cont_QA(wf(:,236),wf(:,265)) * den(258)
  A(321) = cont_QA(wf(:,144),wf(:,266)) * den(259)
  A(322) = cont_VV(wf(:,28),wf(:,267)) * den(260)
  A(323) = cont_QA(wf(:,144),wf(:,268)) * den(261)
  A(324) = cont_VV(wf(:,28),wf(:,269)) * den(262)
  A(325) = cont_VV(wf(:,37),wf(:,258)) * den(263)
  A(326) = cont_QA(wf(:,36),wf(:,243)) * den(264)
  A(327) = cont_QA(wf(:,31),wf(:,271)) * den(266)
  A(328) = cont_QA(wf(:,111),wf(:,257)) * den(267)
  A(329) = cont_QA(wf(:,111),wf(:,260)) * den(268)
  A(330) = cont_QA(wf(:,148),wf(:,266)) * den(269)
  A(331) = cont_QA(wf(:,148),wf(:,268)) * den(270)
  A(332) = cont_QA(wf(:,36),wf(:,247)) * den(271)
  A(333) = cont_VV(wf(:,272),wf(:,273)) * den(275)
  A(334) = cont_QA(wf(:,221),wf(:,275)) * den(278)
  A(335) = cont_QA(wf(:,276),wf(:,277)) * den(281)
  A(336) = cont_QA(wf(:,89),wf(:,278)) * den(283)
  A(337) = cont_VV(wf(:,45),wf(:,279)) * den(284)
  A(338) = cont_VV(wf(:,46),wf(:,280)) * den(285)
  A(339) = cont_QA(wf(:,44),wf(:,229)) * den(286)
  A(340) = cont_QA(wf(:,89),wf(:,281)) * den(287)
  A(341) = cont_VV(wf(:,46),wf(:,282)) * den(288)
  A(342) = cont_VV(wf(:,273),wf(:,283)) * den(291)
  A(343) = cont_QA(wf(:,234),wf(:,285)) * den(294)
  A(344) = cont_QA(wf(:,286),wf(:,287)) * den(297)
  A(345) = cont_QA(wf(:,157),wf(:,288)) * den(298)
  A(346) = cont_VV(wf(:,53),wf(:,279)) * den(299)
  A(347) = cont_VV(wf(:,46),wf(:,290)) * den(301)
  A(348) = cont_QA(wf(:,157),wf(:,291)) * den(302)
  A(349) = cont_VV(wf(:,46),wf(:,292)) * den(303)
  A(350) = cont_QA(wf(:,52),wf(:,293)) * den(304)
  A(351) = cont_QA(wf(:,92),wf(:,278)) * den(305)
  A(352) = cont_QA(wf(:,44),wf(:,245)) * den(306)
  A(353) = cont_QA(wf(:,92),wf(:,281)) * den(307)
  A(354) = cont_QA(wf(:,159),wf(:,288)) * den(308)
  A(355) = cont_QA(wf(:,159),wf(:,291)) * den(309)
  A(356) = cont_QA(wf(:,52),wf(:,295)) * den(311)
  A(357) = cont_QA(wf(:,249),wf(:,297)) * den(314)
  A(358) = cont_VV(wf(:,298),wf(:,299)) * den(318)
  A(359) = cont_QA(wf(:,276),wf(:,300)) * den(320)
  A(360) = cont_VV(wf(:,58),wf(:,301)) * den(321)
  A(361) = cont_QA(wf(:,60),wf(:,256)) * den(322)
  A(362) = cont_QA(wf(:,109),wf(:,302)) * den(324)
  A(363) = cont_VV(wf(:,57),wf(:,303)) * den(325)
  A(364) = cont_VV(wf(:,58),wf(:,304)) * den(326)
  A(365) = cont_QA(wf(:,109),wf(:,305)) * den(327)
  A(366) = cont_QA(wf(:,262),wf(:,307)) * den(330)
  A(367) = cont_VV(wf(:,299),wf(:,308)) * den(333)
  A(368) = cont_QA(wf(:,286),wf(:,309)) * den(335)
  A(369) = cont_QA(wf(:,157),wf(:,310)) * den(336)
  A(370) = cont_VV(wf(:,58),wf(:,311)) * den(337)
  A(371) = cont_QA(wf(:,157),wf(:,312)) * den(338)
  A(372) = cont_VV(wf(:,58),wf(:,313)) * den(339)
  A(373) = cont_VV(wf(:,64),wf(:,303)) * den(340)
  A(374) = cont_QA(wf(:,63),wf(:,293)) * den(341)
  A(375) = cont_QA(wf(:,60),wf(:,271)) * den(342)
  A(376) = cont_QA(wf(:,111),wf(:,302)) * den(343)
  A(377) = cont_QA(wf(:,111),wf(:,305)) * den(344)
  A(378) = cont_QA(wf(:,159),wf(:,310)) * den(345)
  A(379) = cont_QA(wf(:,159),wf(:,312)) * den(346)
  A(380) = cont_QA(wf(:,63),wf(:,295)) * den(347)
  A(381) = cont_VV(wf(:,65),wf(:,301)) * den(348)
  A(382) = cont_VV(wf(:,66),wf(:,255)) * den(349)
  A(383) = cont_VV(wf(:,27),wf(:,314)) * den(350)
  A(384) = cont_VV(wf(:,57),wf(:,315)) * den(351)
  A(385) = cont_VV(wf(:,65),wf(:,304)) * den(352)
  A(386) = cont_VV(wf(:,27),wf(:,316)) * den(353)
  A(387) = cont_VV(wf(:,67),wf(:,255)) * den(354)
  A(388) = cont_VV(wf(:,27),wf(:,317)) * den(355)
  A(389) = cont_VV(wf(:,27),wf(:,318)) * den(356)
  A(390) = cont_VV(wf(:,68),wf(:,301)) * den(357)
  A(391) = cont_VV(wf(:,57),wf(:,319)) * den(358)
  A(392) = cont_VV(wf(:,57),wf(:,320)) * den(359)
  A(393) = cont_VV(wf(:,10),wf(:,321)) * den(360)
  A(394) = cont_VV(wf(:,45),wf(:,322)) * den(361)
  A(395) = cont_VV(wf(:,70),wf(:,280)) * den(362)
  A(396) = cont_VV(wf(:,69),wf(:,228)) * den(363)
  A(397) = cont_VV(wf(:,10),wf(:,323)) * den(364)
  A(398) = cont_VV(wf(:,70),wf(:,282)) * den(365)
  A(399) = cont_VV(wf(:,10),wf(:,324)) * den(366)
  A(400) = cont_VV(wf(:,10),wf(:,325)) * den(367)
  A(401) = cont_VV(wf(:,71),wf(:,228)) * den(368)
  A(402) = cont_VV(wf(:,45),wf(:,326)) * den(369)
  A(403) = cont_VV(wf(:,45),wf(:,327)) * den(370)
  A(404) = cont_VV(wf(:,72),wf(:,280)) * den(371)
  A(405) = cont_VV(wf(:,53),wf(:,322)) * den(372)
  A(406) = cont_VV(wf(:,70),wf(:,290)) * den(373)
  A(407) = cont_VV(wf(:,70),wf(:,292)) * den(374)
  A(408) = cont_VV(wf(:,65),wf(:,311)) * den(375)
  A(409) = cont_VV(wf(:,65),wf(:,313)) * den(376)
  A(410) = cont_VV(wf(:,64),wf(:,315)) * den(377)
  A(411) = cont_VV(wf(:,68),wf(:,313)) * den(378)
  A(412) = cont_VV(wf(:,53),wf(:,326)) * den(379)
  A(413) = cont_VV(wf(:,68),wf(:,311)) * den(380)
  A(414) = cont_VV(wf(:,53),wf(:,327)) * den(381)
  A(415) = cont_VV(wf(:,72),wf(:,290)) * den(382)
  A(416) = cont_VV(wf(:,64),wf(:,320)) * den(383)
  A(417) = cont_VV(wf(:,20),wf(:,321)) * den(384)
  A(418) = cont_VV(wf(:,69),wf(:,242)) * den(385)
  A(419) = cont_VV(wf(:,69),wf(:,240)) * den(386)
  A(420) = cont_VV(wf(:,66),wf(:,269)) * den(387)
  A(421) = cont_VV(wf(:,66),wf(:,267)) * den(388)
  A(422) = cont_VV(wf(:,37),wf(:,314)) * den(389)
  A(423) = cont_VV(wf(:,20),wf(:,325)) * den(390)
  A(424) = cont_VV(wf(:,67),wf(:,269)) * den(391)
  A(425) = cont_VV(wf(:,20),wf(:,324)) * den(392)
  A(426) = cont_VV(wf(:,67),wf(:,267)) * den(393)
  A(427) = cont_VV(wf(:,37),wf(:,317)) * den(394)
  A(428) = cont_VV(wf(:,71),wf(:,240)) * den(395)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(428)
  complex(REALKIND), intent(out) :: M1(4), M2(4)

  M1(1) = ((A(25)+A(27)+A(28)+A(29)+A(31)+A(32)+A(37)+A(39)+A(45)+A(47))*f(3))/6._/**/REALKIND+((A(11)+A(12)+A(15)+A(17)+A(21) &
       +A(24)+A(35)+A(38)+A(41)+A(48))*f(3))/2._/**/REALKIND+(CI*(A(10)+A(14)-A(19)-A(22))*f(4))/2._/**/REALKIND
  M1(2) = ((-A(2)-A(4)-A(7)-A(25)-A(29)-A(32)-A(33)-A(39)-A(42)-A(47))*f(3))/2._/**/REALKIND+((-A(17)-A(18)-A(20)-A(21)-A(23) &
       -A(24)-A(34)-A(35)-A(46)-A(48))*f(3))/6._/**/REALKIND+(CI*(-A(3)-A(6)+A(26)+A(30))*f(4))/2._/**/REALKIND
  M1(3) = ((-A(9)-A(11)-A(12)-A(13)-A(15)-A(16)-A(38)-A(40)-A(41)-A(44))*f(3))/6._/**/REALKIND+((-A(1)-A(5)-A(8)-A(27)-A(28)-A(31) &
       -A(36)-A(37)-A(43)-A(45))*f(3))/2._/**/REALKIND+(CI*(A(3)+A(6)-A(26)-A(30))*f(4))/2._/**/REALKIND
  M1(4) = ((A(1)+A(2)+A(4)+A(5)+A(7)+A(8)+A(33)+A(36)+A(42)+A(43))*f(3))/6._/**/REALKIND+((A(9)+A(13)+A(16)+A(18)+A(20)+A(23) &
       +A(34)+A(40)+A(44)+A(46))*f(3))/2._/**/REALKIND+(CI*(-A(10)-A(14)+A(19)+A(22))*f(4))/2._/**/REALKIND

  M2(1) = ((A(92)+A(100)+A(120)+A(122))*f(1))/2._/**/REALKIND+((A(132)+A(136)+A(138)+A(140))*f(1))/6._/**/REALKIND+(CI*(-A(80) &
       +A(82)-A(84))*f(2))/2._/**/REALKIND+((-A(313)-A(314)-A(317)-A(318)-A(319)-A(320)-A(327)-A(328)-A(329)-A(333)-A(334)-A(335) &
       -A(345)-A(348)-A(350)-A(354)-A(355)-A(356)-A(387)-A(388)-A(389)-A(394)-A(395)-A(398)-A(405)-A(406)-A(407)-A(424)-A(426) &
       -A(427))*f(5))/2._/**/REALKIND+((-A(357)-A(358)-A(359)-A(361)-A(362)-A(365)-A(366)-A(367)-A(368)-A(369)-A(371)-A(374) &
       -A(375)-A(376)-A(377)-A(378)-A(379)-A(380)-A(393)-A(396)-A(397)-A(399)-A(400)-A(401)-A(417)-A(418)-A(419)-A(423)-A(425) &
       -A(428))*f(5))/6._/**/REALKIND+(CI*(-A(312)-A(315)-A(316)-A(322)-A(324)-A(325)+A(337)+A(338)+A(341)+A(346)+A(347) &
       +A(349))*f(6))/2._/**/REALKIND+((A(125)+A(127)+A(128)+A(129)+A(145)+A(147)+A(165)+A(167)+A(168)+A(169)+A(178)+A(180)+A(181) &
       +A(184)+A(213)+A(214)+A(221)+A(223)+A(224)+A(226)+A(227)+A(228)+A(245)+A(247)+A(248)+A(249)+A(253)+A(255)+A(262) &
       +A(264))*f(7))/6._/**/REALKIND+((A(87)+A(88)+A(101)+A(104)+A(109)+A(113)+A(143)+A(146)+A(149)+A(159)+A(161)+A(176)+A(177) &
       +A(183)+A(198)+A(200)+A(205)+A(209)+A(215)+A(231)+A(232)+A(235)+A(239)+A(241)+A(256)+A(260)+A(263)+A(269)+A(273) &
       +A(276))*f(7))/2._/**/REALKIND+(CI*(A(102)-A(157)-A(197)+A(230)+A(233)+A(238)-A(271)-A(274))*f(8))/2._/**/REALKIND+((A(133) &
       +A(134)+A(153)+A(155)+A(170)+A(171)+A(217)+A(219)+A(250)+A(252))*f(9))/6._/**/REALKIND+((A(93)+A(106)+A(118)+A(156)+A(163) &
       +A(185)+A(202)+A(218)+A(244)+A(267))*f(9))/2._/**/REALKIND+(CI*(A(108)-A(164)-A(204)+A(243))*f(10))/2._/**/REALKIND &
       +(CI*(A(86)+A(90)-A(111)-A(114))*f(11))/2._/**/REALKIND+((A(91)+A(99)+A(119)+A(121))*f(20))/2._/**/REALKIND+((A(131)+A(135) &
       +A(137)+A(139))*f(20))/6._/**/REALKIND+(CI*(-A(79)+A(81)-A(83))*f(21))/2._/**/REALKIND
  M2(2) = ((-A(117)-A(120)-A(122)-A(124))*f(1))/6._/**/REALKIND+((-A(63)-A(70)-A(136)-A(138))*f(1))/2._/**/REALKIND+(CI*(-A(50) &
       +A(52)+A(54))*f(2))/2._/**/REALKIND+((A(333)+A(334)+A(335)+A(336)+A(339)+A(340)+A(342)+A(343)+A(344)+A(345)+A(348)+A(350) &
       +A(351)+A(352)+A(353)+A(354)+A(355)+A(356)+A(382)+A(383)+A(386)+A(387)+A(388)+A(389)+A(420)+A(421)+A(422)+A(424)+A(426) &
       +A(427))*f(5))/6._/**/REALKIND+((A(288)+A(291)+A(292)+A(294)+A(295)+A(296)+A(303)+A(304)+A(305)+A(357)+A(358)+A(359)+A(369) &
       +A(371)+A(374)+A(378)+A(379)+A(380)+A(381)+A(384)+A(385)+A(399)+A(400)+A(401)+A(408)+A(409)+A(410)+A(423)+A(425) &
       +A(428))*f(5))/2._/**/REALKIND+(CI*(A(289)+A(290)+A(293)+A(298)+A(299)+A(301)-A(360)-A(363)-A(364)-A(370)-A(372) &
       -A(373))*f(6))/2._/**/REALKIND+((-A(109)-A(110)-A(112)-A(113)-A(142)-A(143)-A(158)-A(159)-A(160)-A(161)-A(173)-A(176) &
       -A(182)-A(183)-A(198)-A(199)-A(200)-A(201)-A(205)-A(208)-A(215)-A(216)-A(261)-A(263)-A(269)-A(270)-A(272)-A(273)-A(275) &
       -A(276))*f(7))/6._/**/REALKIND+((-A(56)-A(58)-A(72)-A(74)-A(125)-A(129)-A(141)-A(147)-A(150)-A(167)-A(169)-A(174)-A(180) &
       -A(184)-A(191)-A(193)-A(207)-A(212)-A(214)-A(221)-A(226)-A(228)-A(245)-A(248)-A(253)-A(257)-A(262)-A(278)-A(280) &
       -A(283))*f(7))/2._/**/REALKIND+(CI*(-A(71)+A(166)-A(189)+A(222)+A(225)+A(246)-A(279)-A(282))*f(8))/2._/**/REALKIND+((-A(61) &
       -A(76)-A(134)-A(155)-A(171)-A(186)-A(195)-A(219)-A(250)-A(265))*f(9))/2._/**/REALKIND+((-A(115)-A(118)-A(154)-A(156)-A(162) &
       -A(163)-A(202)-A(203)-A(266)-A(267))*f(9))/6._/**/REALKIND+(CI*(-A(78)+A(172)-A(196)+A(251))*f(10))/2._/**/REALKIND+(CI*( &
       -A(57)-A(60)+A(126)+A(130))*f(11))/2._/**/REALKIND+((-A(116)-A(119)-A(121)-A(123))*f(20))/6._/**/REALKIND+((-A(62)-A(69) &
       -A(135)-A(137))*f(20))/2._/**/REALKIND+(CI*(-A(49)+A(51)+A(53))*f(21))/2._/**/REALKIND
  M2(3) = ((-A(92)-A(96)-A(98)-A(100))*f(1))/6._/**/REALKIND+((-A(66)-A(68)-A(132)-A(140))*f(1))/2._/**/REALKIND+(CI*(A(50)-A(52) &
       -A(54))*f(2))/2._/**/REALKIND+((A(309)+A(310)+A(311)+A(313)+A(314)+A(317)+A(318)+A(319)+A(320)+A(321)+A(323)+A(326)+A(327) &
       +A(328)+A(329)+A(330)+A(331)+A(332)+A(394)+A(395)+A(398)+A(402)+A(403)+A(404)+A(405)+A(406)+A(407)+A(412)+A(414) &
       +A(415))*f(5))/6._/**/REALKIND+((A(285)+A(286)+A(287)+A(297)+A(300)+A(302)+A(306)+A(307)+A(308)+A(361)+A(362)+A(365)+A(366) &
       +A(367)+A(368)+A(375)+A(376)+A(377)+A(390)+A(391)+A(392)+A(393)+A(396)+A(397)+A(411)+A(413)+A(416)+A(417)+A(418) &
       +A(419))*f(5))/2._/**/REALKIND+(CI*(-A(289)-A(290)-A(293)-A(298)-A(299)-A(301)+A(360)+A(363)+A(364)+A(370)+A(372) &
       +A(373))*f(6))/2._/**/REALKIND+((-A(85)-A(87)-A(88)-A(89)-A(101)-A(103)-A(104)-A(105)-A(146)-A(148)-A(149)-A(152)-A(177) &
       -A(179)-A(209)-A(211)-A(229)-A(231)-A(232)-A(234)-A(235)-A(236)-A(237)-A(239)-A(240)-A(241)-A(254)-A(256)-A(259) &
       -A(260))*f(7))/6._/**/REALKIND+((-A(55)-A(59)-A(73)-A(75)-A(127)-A(128)-A(144)-A(145)-A(151)-A(165)-A(168)-A(175)-A(178) &
       -A(181)-A(190)-A(192)-A(206)-A(210)-A(213)-A(223)-A(224)-A(227)-A(247)-A(249)-A(255)-A(258)-A(264)-A(277)-A(281) &
       -A(284))*f(7))/2._/**/REALKIND+(CI*(A(71)-A(166)+A(189)-A(222)-A(225)-A(246)+A(279)+A(282))*f(8))/2._/**/REALKIND+((-A(93) &
       -A(94)-A(106)-A(107)-A(185)-A(187)-A(218)-A(220)-A(242)-A(244))*f(9))/6._/**/REALKIND+((-A(64)-A(77)-A(133)-A(153)-A(170) &
       -A(188)-A(194)-A(217)-A(252)-A(268))*f(9))/2._/**/REALKIND+(CI*(A(78)-A(172)+A(196)-A(251))*f(10))/2._/**/REALKIND &
       +(CI*(A(57)+A(60)-A(126)-A(130))*f(11))/2._/**/REALKIND+((-A(91)-A(95)-A(97)-A(99))*f(20))/6._/**/REALKIND+((-A(65)-A(67) &
       -A(131)-A(139))*f(20))/2._/**/REALKIND+(CI*(A(49)-A(51)-A(53))*f(21))/2._/**/REALKIND
  M2(4) = ((A(63)+A(66)+A(68)+A(70))*f(1))/6._/**/REALKIND+((A(96)+A(98)+A(117)+A(124))*f(1))/2._/**/REALKIND+(CI*(A(80)-A(82) &
       +A(84))*f(2))/2._/**/REALKIND+((-A(285)-A(286)-A(287)-A(288)-A(291)-A(292)-A(294)-A(295)-A(296)-A(297)-A(300)-A(302)-A(303) &
       -A(304)-A(305)-A(306)-A(307)-A(308)-A(381)-A(384)-A(385)-A(390)-A(391)-A(392)-A(408)-A(409)-A(410)-A(411)-A(413) &
       -A(416))*f(5))/6._/**/REALKIND+((-A(309)-A(310)-A(311)-A(321)-A(323)-A(326)-A(330)-A(331)-A(332)-A(336)-A(339)-A(340) &
       -A(342)-A(343)-A(344)-A(351)-A(352)-A(353)-A(382)-A(383)-A(386)-A(402)-A(403)-A(404)-A(412)-A(414)-A(415)-A(420)-A(421) &
       -A(422))*f(5))/2._/**/REALKIND+(CI*(A(312)+A(315)+A(316)+A(322)+A(324)+A(325)-A(337)-A(338)-A(341)-A(346)-A(347) &
       -A(349))*f(6))/2._/**/REALKIND+((A(85)+A(89)+A(103)+A(105)+A(110)+A(112)+A(142)+A(148)+A(152)+A(158)+A(160)+A(173)+A(179) &
       +A(182)+A(199)+A(201)+A(208)+A(211)+A(216)+A(229)+A(234)+A(236)+A(237)+A(240)+A(254)+A(259)+A(261)+A(270)+A(272) &
       +A(275))*f(7))/2._/**/REALKIND+((A(55)+A(56)+A(58)+A(59)+A(72)+A(73)+A(74)+A(75)+A(141)+A(144)+A(150)+A(151)+A(174)+A(175) &
       +A(190)+A(191)+A(192)+A(193)+A(206)+A(207)+A(210)+A(212)+A(257)+A(258)+A(277)+A(278)+A(280)+A(281)+A(283) &
       +A(284))*f(7))/6._/**/REALKIND+(CI*(-A(102)+A(157)+A(197)-A(230)-A(233)-A(238)+A(271)+A(274))*f(8))/2._/**/REALKIND+((A(94) &
       +A(107)+A(115)+A(154)+A(162)+A(187)+A(203)+A(220)+A(242)+A(266))*f(9))/2._/**/REALKIND+((A(61)+A(64)+A(76)+A(77)+A(186) &
       +A(188)+A(194)+A(195)+A(265)+A(268))*f(9))/6._/**/REALKIND+(CI*(-A(108)+A(164)+A(204)-A(243))*f(10))/2._/**/REALKIND+(CI*( &
       -A(86)-A(90)+A(111)+A(114))*f(11))/2._/**/REALKIND+((A(62)+A(65)+A(67)+A(69))*f(20))/6._/**/REALKIND+((A(95)+A(97)+A(116) &
       +A(123))*f(20))/2._/**/REALKIND+(CI*(A(79)-A(81)+A(83))*f(21))/2._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pphbbj_bbbxbxhg_1_/**/REALKIND
