
module ol_vamp_1_mmee_qed_el_eexmmxaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_mmee_qed_el_eexmmxaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_mmee_qed_el_eexmmxaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_mmee_qed_el_eexmmxaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_mmee_qed_el_eexmmxaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_mmee_qed_el_eexmmxaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_mmee_qed_el_eexmmxaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,2,1,16,12],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,12,2,1,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,1,2,16,12],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,1,2,12,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,12,1,2,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,12,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(6))
  call Hloop_QA_V(ntryL,G1H32(1),ex2(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,3),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H32(3),ex1(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,3))
  call Hloop_AQ_V(ntryL,G1H32(4),ex1(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,4))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,3),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(2),n2h8(2))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,6))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(3),n2h8(3))
  call Hloop_QA_V(ntryL,G2H8(1),ex2(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(1),n2h8(4))
  call Hloop_VA_Q(ntryL,G1H16(3),ex2(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(4),n2h8(5))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(2),n2h8(6))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),12,8)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(2),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),12,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(4),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(5),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(6),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(13),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(13),51,nME,G2H4(1),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-12,nME,G2H8(3),n2h8(7))
  call Hloop_AV_Q(ntryL,G2H8(3),wf4(:,3),G2H2(1),m3h4x2(:,1),heltab2x8(:,:,4))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(13),m3h2x4(:,4),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(13),51,nME,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(13),m3h2x4(:,5),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(13),51,nME,G2H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(2),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-16,nME,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(3),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(4),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(5),n2h2(3))
  call Hloop_AV_Q(ntryL,G1H8(7),ex5(:),G1H4(13),m3h2x4(:,6),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(13),51,nME,G2H4(4),n2h4(5))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-12,nME,G2H8(1),n2h8(8))
  call Hloop_QV_A(ntryL,G2H8(1),wf4(:,3),G2H2(6),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_AV_Q(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(5),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H8(12),ex5(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(2),51,nME,G2H4(6),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,3),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(7),n2h2(4))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,nME,G2H8(4),n2h8(9))
  call Hloop_QV_A(ntryL,G2H8(4),ex5(:),G2H4(7),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,3),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(8),n2h2(5))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,3),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(9),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(10),n2h2(7))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,nME,G2H4(8),n2h4(8))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(11),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(12),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(13),n2h2(9))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,3),G1H2(1),m3h4x2(:,6),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(14),n2h2(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,nME,G2H8(2),n2h8(10))
  call Hloop_AV_Q(ntryL,G2H8(2),ex5(:),G2H4(8),m3h2x4(:,10),heltab2x8(:,:,16))
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,3),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(15),n2h2(11))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,3),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(16),n2h2(12))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(13),G1H4(1),G1H4(2),G1H4(7),4)
  call HG1shiftOLR(G1H4(6),12,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(8),G1H4(11),G1H4(12),G1H4(14),G1H4(15),4)
  call HG1shiftOLR(G1H4(11),28,4)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,2),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(2),mass4set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),17,2)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(3),mass5set(:,1),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(17),12,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(3),mass4set(:,1),  & 
G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(23),28,4)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(3),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),28,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(5),mass5set(:,2),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),16,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(4),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),18,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(6),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(1),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),28,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,3),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(1))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,3),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(2),n2h1(2))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,3),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(3),n2h1(3))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,3),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(4),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(6),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(8),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,3),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,3),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,3),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,3),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(12),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(13),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(22),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(24),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),12)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),12)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,2,17,12],[nME,0,nME,nME],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,12,2,17],[nME,nME,0,nME],4,2,wf4(:,3),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,1,18,12],[nME,0,nME,nME],4,2,wf4(:,9),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,12,1,18],[nME,nME,0,nME],4,2,wf4(:,3),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[33,2,16,12],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[33,2,12,16],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[34,1,16,12],[0,nME,nME,nME],4,2,wf4(:,5),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[34,1,12,16],[0,nME,nME,nME],4,2,wf4(:,5),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,4),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,13,2,16],[nME,0,nME,nME],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,13,16],[nME,0,nME,nME],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,14,1,16],[nME,0,nME,nME],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,1,14,16],[nME,0,nME,nME],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(14))
  call Hloop_QA_V(ntryL,G1H32(1),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,7))
  call Hloop_QV_A(ntryL,G1H32(2),wf4(:,3),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(3),n2h8(11))
  call Hloop_AQ_V(ntryL,G1H32(3),ex1(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,9))
  call Hloop_AV_Q(ntryL,G1H32(4),wf4(:,3),G1H8(2),m3h4x8(:,4),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(2),44,nME,G2H8(1),n2h8(12))
  call Hloop_VA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(5),n2h8(13))
  call Hloop_VA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(6),n2h8(14))
  call Hloop_VQ_A(ntryL,G0H16(3),ex1(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(7),n2h8(15))
  call Hloop_VQ_A(ntryL,G0H16(4),ex1(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(8),n2h8(16))
  call Hloop_AQ_V(ntryL,G1H32(5),wf8(:,6),G1H4(7),m3h8x4(:,1),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,12))
  call Hloop_QA_V(ntryL,G1H32(7),wf8(:,3),G1H4(21),m3h8x4(:,2),heltab2x32(:,:,13))
  call Hloop_AQ_V(ntryL,G1H32(8),ex1(:),G1H16(4),m3h2x16(:,8),heltab2x32(:,:,14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(21)])
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(5),m3h2x4(:,11),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(5),51,nME,G2H4(1),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(4),ex5(:),G1H4(6),m3h2x4(:,12),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(6),51,nME,G2H4(3),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(6),m3h2x2(:,9),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(6),47,nME,G2H2(2),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(17),m3h2x2(:,10),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(17),47,nME,G2H2(5),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H8(5),ex5(:),G1H4(8),m3h2x4(:,13),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(8),51,nME,G2H4(4),n2h4(11))
  call Hloop_AV_Q(ntryL,G1H8(10),ex5(:),G1H4(11),m3h2x4(:,14),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(11),51,nME,G2H4(6),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,3),G1H2(28),m3h4x2(:,9),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(28),47,nME,G2H2(7),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,3),G1H2(39),m3h4x2(:,10),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(39),47,nME,G2H2(9),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(10),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(2),m3h2x2(:,12),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(13),n2h2(18))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,3),G1H2(7),m3h4x2(:,11),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(7),47,nME,G2H2(14),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,3),G1H2(8),m3h4x2(:,12),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(8),47,nME,G2H2(16),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H16(1),wf4(:,4),G1H4(16),m3h4x4(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(16),51,nME,G2H4(9),n2h4(13))
  call Hloop_QA_V(ntryL,G2H8(3),ex2(:),G2H4(10),m3h2x4(:,15),heltab2x8(:,:,27))
  call Hloop_VA_Q(ntryL,G1H16(2),wf4(:,9),G1H4(17),m3h4x4(:,2),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(17),51,nME,G2H4(11),n2h4(14))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(12),m3h2x4(:,16),heltab2x8(:,:,28))
  call Hloop_VQ_A(ntryL,G1H16(3),wf8(:,6),G1H2(12),m3h8x2(:,1),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(12),47,nME,G2H2(17),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H16(4),wf8(:,3),G1H2(13),m3h8x2(:,2),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(18),n2h2(22))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(3)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(2),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(25)])
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(5),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(8),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(15),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(37)])
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(9),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(23),G1H2(24),G1H2(29),2)
  call HG1shiftOLR(G1H2(19),16,2)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(7),mass4set(:,1),  & 
G1H4(22),G1H4(23),G1H4(4),G1H4(10),G1H4(5),4)
  call HG1shiftOLR(G1H4(23),12,4)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(26),mass4set(:,2),  & 
G1H2(30),G1H2(34),G1H2(35),G1H2(40),G1H2(41),2)
  call HG1shiftOLR(G1H2(34),1,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,3),  & 
G1H2(6),G1H2(17),G1H2(28),G1H2(39),G1H2(1),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(20),mass4set(:,1),  & 
G1H2(2),G1H2(7),G1H2(8),G1H2(12),G1H2(13),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(14),mass4set(:,1),  & 
G1H4(6),G1H4(3),G1H4(21),G1H4(8),G1H4(11),4)
  call HG1shiftOLR(G1H4(3),12,4)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(27),mass4set(:,1),  & 
G1H4(9),G1H4(7),G1H4(16),G1H4(17),G1H4(2),4)
  call HG1shiftOLR(G1H4(7),12,4)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(18),mass4set(:,1),  & 
G1H2(3),G1H2(5),G1H2(25),G1H2(16),G1H2(27),2)
  call HG1shiftOLR(G1H2(5),16,2)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(28),mass4set(:,2),  & 
G1H2(38),G1H2(4),G1H2(14),G1H2(15),G1H2(26),2)
  call HG1shiftOLR(G1H2(4),2,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(11),mass4set(:,3),  & 
G1H2(36),G1H2(37),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(37),16,2)
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(29),mass4set(:,1),  & 
G1H4(20),G1H4(13),G1H4(1),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(13),12,4)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(24),mass4set(:,1),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(49),16,2)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(5),mass4set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(28),12,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(6),mass4set(:,3),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(33),12,4)
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,3),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(25))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,3),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(26))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,3),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(27))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(10),mass4set(:,1),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(54),16,2)
  call Hloop_QV_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(13),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(30))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(13),mass4set(:,4),  & 
G1H4(12),G1H4(14),G1H4(15),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(14),12,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(6),mass4set(:,3),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(40),12,4)
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,3),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(25),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H4(25),wf4(:,3),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(26),n2h1(32))
  call Hloop_AV_Q(ntryL,G1H4(26),wf4(:,3),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(27),n2h1(33))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(16),mass4set(:,4),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(58),G1H2(59),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(17),mass4set(:,3),  & 
G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(61),16,2)
  call Hloop_AV_Q(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(28),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(29),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(30),n2h1(36))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(21),mass4set(:,1),  & 
G1H2(20),G1H2(21),G1H2(22),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(31),n2h1(37))
  call Hloop_AV_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(32),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(33),n2h1(39))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(23),mass4set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(17),mass4set(:,3),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(70),16,2)
  call Hloop_QV_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(34),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(35),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(36),n2h1(42))
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(2),mass4set(:,2),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(25),17,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(4),mass4set(:,2),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(47),18,4)
  call Hloop_QV_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(38),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(39),n2h1(45))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,3),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(40),n2h1(46))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,3),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(41),n2h1(47))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,3),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(42),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(30),ex1(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(34),ex1(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(44),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(41),ex1(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(45),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(46),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(47),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(48),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(49),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(50),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(51),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,3),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(52),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H4(3),wf4(:,3),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(53),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H4(11),wf4(:,3),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(54),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,3),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(55),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,3),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(56),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,3),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(57),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(58),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(59),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(60),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(38),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(61),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(62),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(63),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(64),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(65),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(66),n2h1(72))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,3),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(67),n2h1(73))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,3),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(68),n2h1(74))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,3),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(69),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(70),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(71),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(72),n2h1(78))
  call Hloop_QV_A(ntryL,G1H4(27),wf4(:,3),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(73),n2h1(79))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,3),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(74),n2h1(80))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,3),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(75),n2h1(81))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,3),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(76),n2h1(82))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,3),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(77),n2h1(83))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,3),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(78),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(79),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(80),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(81),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,3),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(82),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,3),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(83),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H4(38),wf4(:,3),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(84),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H4(39),wf4(:,3),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(85),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,3),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(86),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H4(43),wf4(:,3),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(87),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(88),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(89),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(90),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(91),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(92),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(93),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(94),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(95),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(96),n2h1(102))
  call Hloop_QV_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(97),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(98),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(99),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(100),n2h1(106))
  call Hloop_QV_A(ntryL,G1H2(70),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(101),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(102),n2h1(108))
  call Hloop_VQ_A(ntryL,G1H4(24),wf4(:,4),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(103),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H4(25),wf4(:,4),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(104),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(105),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H4(46),wf4(:,9),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(106),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H4(47),wf4(:,9),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(107),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H4(50),wf4(:,9),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(108),n2h1(114))
  call ol_merge_tensors(G2tensor(37),[G2tensor(2),G1tensor(9),G1tensor(2)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(3),G1tensor(36),G1tensor(6)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(7),G1tensor(12)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(10),G1tensor(27),G1tensor(14)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(11),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(14),G1tensor(20)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(19),G1tensor(30)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(22),G1tensor(32)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(76),G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(46),G1tensor(29),G1tensor(11)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(91),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(35)])
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(9),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),16)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(9),G1tensor(2),G1tensor(36),G1tensor(6))
  call G_TensorShift(G1tensor(9),28)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(26),mass4set(:,2),  & 
G1tensor(8),G1tensor(12),G1tensor(27),G1tensor(14),G1tensor(24))
  call G_TensorShift(G1tensor(12),1)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(2),mass4set(:,2),  & 
G1tensor(18),G1tensor(20),G1tensor(26),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(20),17)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(20),mass4set(:,1),  & 
G1tensor(3),G1tensor(16),G1tensor(4),G1tensor(5),G1tensor(10))
  call G_TensorShift(G1tensor(16),16)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(3),mass4set(:,1),  & 
G1tensor(29),G1tensor(11),G1tensor(15),G1tensor(17),G1tensor(21))
  call G_TensorShift(G1tensor(11),28)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(27),mass4set(:,1),  & 
G1tensor(34),G1tensor(22),G1tensor(23),G1tensor(28),G1tensor(33))
  call G_TensorShift(G1tensor(22),12)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(28),mass4set(:,2),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),2)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(4),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),18)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(29),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),12)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(5),mass4set(:,4),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),12)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(6),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),12)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(7),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),12)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(10),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),16)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(11),mass4set(:,3),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),16)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(13),mass4set(:,4),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),12)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(14),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),12)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(16),mass4set(:,4),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),16)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(17),mass4set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(18),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),16)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(21),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(23),mass4set(:,4),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),16)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(24),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(9),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(26),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(2),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(20),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(3),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(27),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(28),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(4),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(29),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(5),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(6),mass4set(:,3),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(7),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,3),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(13),mass4set(:,4),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(14),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(16),mass4set(:,4),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(17),mass4set(:,3),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(18),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(21),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(23),mass4set(:,4),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(24),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[34,12,17],[nME,nME,0],3,3,wf4(:,5),wf4(:,3),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),34,nME,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[49,2,12],[0,nME,nME],3,2,wf8(:,14),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,14),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,14,17],[nME,0,nME],3,2,wf8(:,3),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,29],[nME,0,nME],3,1,wf16(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[33,12,18],[nME,nME,0],3,3,wf4(:,8),wf4(:,3),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,6),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(2),33,nME,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,13,18],[nME,0,nME],3,2,wf8(:,6),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[50,1,12],[0,nME,nME],3,2,wf8(:,19),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,19),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,1,30],[nME,0,nME],3,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[49,2,12],[0,nME,nME],3,2,wf8(:,15),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,15),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[33,14,16],[0,nME,nME],3,2,wf4(:,8),wf8(:,3))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,7),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[45,2,16],[0,nME,nME],3,1,wf16(:,17))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,17),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[34,13,16],[0,nME,nME],3,2,wf4(:,5),wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,8),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[50,1,12],[0,nME,nME],3,2,wf8(:,20),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,20),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[46,1,16],[0,nME,nME],3,1,wf16(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,11),G0H4(2),m3h16x4(:,2),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,29],[nME,0,nME],3,1,wf16(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[45,2,16],[0,nME,nME],3,1,wf16(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,21),G0H4(3),m3h16x4(:,3),heltab2x64(:,:,34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,30],[nME,0,nME],3,1,wf16(:,23))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[46,1,16],[0,nME,nME],3,1,wf16(:,25))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,25),G0H4(4),m3h16x4(:,4),heltab2x64(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(3),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(2)])
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,3),G1H4(22),m3h4x4(:,3),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(22),46,nME,G2H4(2),n2h4(15))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(1),51,nME,G1H4(23),n2h4(16))
  call Hloop_QA_V(ntryL,G1H32(1),wf8(:,3),G1H4(5),m3h8x4(:,3),heltab2x32(:,:,15))
  call Hloop_QA_V(ntryL,G1H32(2),ex2(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,16))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,3),G1H4(6),m3h4x4(:,4),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(6),45,nME,G2H4(5),n2h4(17))
  call Hloop_AQ_V(ntryL,G1H32(3),wf8(:,6),G1H4(3),m3h8x4(:,4),heltab2x32(:,:,17))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(2),m3h2x4(:,18),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(2),51,nME,G1H4(11),n2h4(18))
  call Hloop_AQ_V(ntryL,G1H32(4),ex1(:),G1H16(4),m3h2x16(:,10),heltab2x32(:,:,18))
  call Hloop_VA_Q(ntryL,G0H16(3),wf8(:,3),G0H2(1),m3h8x2(:,3),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(42),n2h2(23))
  call Hloop_VA_Q(ntryL,G0H4(3),ex2(:),G0H2(1),m3h2x2(:,13),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(43),n2h2(24))
  call Hloop_VQ_A(ntryL,G0H16(4),wf8(:,6),G0H2(1),m3h8x2(:,4),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(44),n2h2(25))
  call Hloop_VQ_A(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,14),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(18),n2h2(26))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,11),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(6),ex1(:),G1H16(2),m3h2x16(:,12),heltab2x32(:,:,20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(55),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(56),G1H2(51),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(22),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(58),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(63),G1H2(46),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(67),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(49)])
  call Hloop_QV_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(2),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(3),n2h1(116))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,3),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(6),n2h1(117))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,3),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H2(35),ex1(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(10),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(40),ex1(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(14),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(18),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(19),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H4(37),wf4(:,3),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(22),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H4(42),wf4(:,3),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(76),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,3),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(46),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,3),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(91),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(129))
  call Hloop_VA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(103),n2h1(131))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,3),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(49),n2h1(132))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,3),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(15),n2h1(133))
  call Hloop_QV_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(55),n2h1(134))
  call Hloop_QV_A(ntryL,G1H4(34),wf4(:,3),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(61),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H4(41),wf4(:,3),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(106),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(67),n2h1(137))
  call Hloop_QV_A(ntryL,G1H2(71),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(73),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H4(26),wf4(:,4),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(85),n2h1(139))
  call Hloop_VQ_A(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(40),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H4(48),wf4(:,9),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(79),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H4(3),wf4(:,9),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(64),n2h1(142))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(2),wf4(:,4),G2tensor(82),m3h4x1(:,59),heltab2x4(:,:,73))
  call Hloop_VQ_A(ntryL,G1H16(3),wf16(:,13),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(52),n2h1(143))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(5),wf4(:,9),G2tensor(88),m3h4x1(:,60),heltab2x4(:,:,74))
  call Hloop_VA_Q(ntryL,G1H16(4),wf16(:,15),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(100),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H16(1),wf16(:,19),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(58),n2h1(145))
  call Hloop_VA_Q(ntryL,G1H16(2),wf16(:,23),G1H1(1),m3h16x1(:,4),heltab2x16(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(94),n2h1(146))
  call ol_merge_tensors(G2tensor(10),[G2tensor(68),G2tensor(38),G2tensor(24),G2tensor(4),G1tensor(47),G1tensor(27),G1tensor(9) &
    ,G1tensor(7),G0tensor(47),G0tensor(13),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(44),G2tensor(8),G1tensor(20),G1tensor(12),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(56),G2tensor(50),G2tensor(16),G2tensor(12),G1tensor(38),G1tensor(22),G1tensor(11) &
    ,G1tensor(16),G0tensor(38),G0tensor(32),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(62),G2tensor(20),G1tensor(42),G1tensor(37),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(75),G2tensor(34),G2tensor(1),G1tensor(110),G1tensor(55),G1tensor(2),G0tensor(110) &
    ,G0tensor(55),G0tensor(8)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(93),G2tensor(87),G2tensor(78),G2tensor(35),G2tensor(29),G2tensor(26),G2tensor(5) &
    ,G1tensor(95),G1tensor(60),G1tensor(17),G1tensor(36),G0tensor(95),G0tensor(60),G0tensor(29),G0tensor(9)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(52),G2tensor(72),G2tensor(42),G2tensor(36),G2tensor(9),G1tensor(115),G1tensor(65) &
    ,G1tensor(6),G0tensor(115),G0tensor(65),G0tensor(10)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(41),G2tensor(39),G2tensor(13),G1tensor(62),G1tensor(26),G1tensor(25),G0tensor(62) &
    ,G0tensor(18),G0tensor(5)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(81),G2tensor(17),G1tensor(70),G1tensor(30),G0tensor(70),G0tensor(19)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(105),G2tensor(66),G2tensor(48),G2tensor(33),G2tensor(21),G1tensor(75),G1tensor(45) &
    ,G1tensor(32),G0tensor(75),G0tensor(45),G0tensor(20)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(84),G2tensor(28),G2tensor(25),G1tensor(90),G1tensor(80),G1tensor(15),G0tensor(90) &
    ,G0tensor(80),G0tensor(28)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(100),G2tensor(60),G2tensor(54),G2tensor(30),G2tensor(27),G1tensor(100),G1tensor(85) &
    ,G1tensor(21),G0tensor(100),G0tensor(85),G0tensor(30)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(53),G2tensor(51),G2tensor(31),G1tensor(82),G1tensor(43),G1tensor(10),G0tensor(82) &
    ,G0tensor(43),G0tensor(25)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(96),G2tensor(32),G1tensor(105),G1tensor(44),G0tensor(105),G0tensor(44)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(63),G2tensor(47),G2tensor(45),G1tensor(72),G1tensor(40),G1tensor(24),G0tensor(72) &
    ,G0tensor(40),G0tensor(15)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(57),G1tensor(97),G1tensor(33),G0tensor(97),G0tensor(35)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(69),G1tensor(112),G1tensor(50),G0tensor(112),G0tensor(50)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(74),G1tensor(68),G1tensor(52),G1tensor(13),G0tensor(68),G0tensor(52),G0tensor(3)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(3),G2tensor(86),G2tensor(77),G1tensor(73),G1tensor(57),G1tensor(5),G1tensor(19) &
    ,G0tensor(73),G0tensor(57),G0tensor(24),G0tensor(4)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(80),G1tensor(67),G1tensor(14),G0tensor(67),G0tensor(14)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(83),G1tensor(103),G1tensor(77),G1tensor(4),G0tensor(103),G0tensor(77) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(89),G1tensor(87),G1tensor(23),G0tensor(87),G0tensor(33)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(91),G2tensor(101),G2tensor(92),G1tensor(92),G1tensor(49),G1tensor(28),G0tensor(92) &
    ,G0tensor(49),G0tensor(34)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(95),G1tensor(102),G1tensor(39),G0tensor(102),G0tensor(39)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(98),G1tensor(107),G1tensor(48),G0tensor(107),G0tensor(48)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(61),G1tensor(78),G1tensor(58),G1tensor(53),G0tensor(78),G0tensor(58) &
    ,G0tensor(53)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(63),G1tensor(54),G0tensor(63),G0tensor(54)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(7),G1tensor(84),G1tensor(64),G1tensor(59),G0tensor(84),G0tensor(64),G0tensor(59)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(14),G1tensor(114),G1tensor(104),G1tensor(99),G1tensor(94),G1tensor(74),G1tensor(69) &
    ,G0tensor(114),G0tensor(104),G0tensor(99),G0tensor(94),G0tensor(74),G0tensor(69)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(83),G1tensor(79),G0tensor(83),G0tensor(79)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(67),G1tensor(108),G1tensor(93),G1tensor(88),G0tensor(108),G0tensor(93) &
    ,G0tensor(88)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(98),G1tensor(89),G0tensor(98),G0tensor(89)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(113),G1tensor(109),G0tensor(113),G0tensor(109)])
  call TI_triangle_red(G2tensor(10),RedBasis(37),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nME], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(104),RedBasis(45),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nME], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(43),RedBasis(42),mass3set(:,1),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nME], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(107),RedBasis(46),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nME], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(99),RedBasis(4),mass3set(:,3),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(47),M2L1R1,[nME], &
    G0tensor(13))
  call TI_triangle_red(G2tensor(102),RedBasis(2),mass3set(:,4),G0tensor(7),G0tensor(2),G0tensor(17),G0tensor(12),M2L1R1,[nME], &
    G0tensor(38))
  call TI_triangle_red(G2tensor(58),RedBasis(1),mass3set(:,1),G0tensor(32),G0tensor(27),G0tensor(22),G0tensor(42),M2L1R1,[nME], &
    G0tensor(37))
  call TI_triangle_red(G2tensor(85),RedBasis(10),mass3set(:,1),G0tensor(110),G0tensor(55),G0tensor(8),G0tensor(95),M2L1R1,[nME], &
    G0tensor(60))
  call TI_triangle_red(G2tensor(40),RedBasis(8),mass3set(:,1),G0tensor(29),G0tensor(9),G0tensor(115),G0tensor(65),M2L1R1,[nME], &
    G0tensor(10))
  call TI_triangle_red(G2tensor(108),RedBasis(7),mass3set(:,4),G0tensor(62),G0tensor(18),G0tensor(5),G0tensor(70),M2L1R1,[nME], &
    G0tensor(19))
  call TI_triangle_red(G2tensor(90),RedBasis(14),mass3set(:,3),G0tensor(75),G0tensor(45),G0tensor(20),G0tensor(90),M2L1R1,[nME], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(94),RedBasis(13),mass3set(:,1),G0tensor(28),G0tensor(100),G0tensor(85),G0tensor(30),M2L1R1,[nME], &
    G0tensor(82))
  call TI_triangle_red(G2tensor(79),RedBasis(19),mass3set(:,1),G0tensor(43),G0tensor(25),G0tensor(105),G0tensor(44),M2L1R1,[nME], &
    G0tensor(72))
  call TI_triangle_red(G2tensor(64),RedBasis(18),mass3set(:,1),G0tensor(40),G0tensor(15),G0tensor(97),G0tensor(35),M2L1R1,[nME], &
    G0tensor(112))
  call TI_triangle_red(G2tensor(65),RedBasis(35),mass3set(:,4),G0tensor(50),G0tensor(68),G0tensor(52),G0tensor(3),M2L1R1,[nME], &
    G0tensor(73))
  call TI_triangle_red(G2tensor(59),RedBasis(38),mass3set(:,1),G0tensor(57),G0tensor(24),G0tensor(4),G0tensor(67),M2L1R1,[nME], &
    G0tensor(14))
  call TI_triangle_red(G2tensor(71),RedBasis(43),mass3set(:,1),G0tensor(103),G0tensor(77),G0tensor(23),G0tensor(87),M2L1R1,[nME], &
    G0tensor(33))
  call TI_triangle_red(G2tensor(2),RedBasis(12),mass3set(:,3),G0tensor(92),G0tensor(49),G0tensor(34),G0tensor(102),M2L1R1,[nME], &
    G0tensor(39))
  call TI_triangle_red(G2tensor(19),RedBasis(11),mass3set(:,4),G0tensor(107),G0tensor(48),G0tensor(78),G0tensor(58),M2L1R1,[nME], &
    G0tensor(53))
  call TI_triangle_red(G2tensor(11),RedBasis(36),mass3set(:,1),G0tensor(63),G0tensor(54),G0tensor(84),G0tensor(64),M2L1R1,[nME], &
    G0tensor(59))
  call TI_triangle_red(G2tensor(18),RedBasis(20),mass3set(:,3),G0tensor(114),G0tensor(104),G0tensor(99),G0tensor(94),M2L1R1,[nME], &
    G0tensor(74))
  call TI_triangle_red(G2tensor(46),RedBasis(40),mass3set(:,3),G0tensor(69),G0tensor(83),G0tensor(79),G0tensor(108),M2L1R1,[nME], &
    G0tensor(93))
  call TI_triangle_red(G2tensor(15),RedBasis(39),mass3set(:,4),G0tensor(88),G0tensor(98),G0tensor(89),G0tensor(113),M2L1R1,[nME], &
    G0tensor(109))
  call TI_triangle_red(G2tensor(103),RedBasis(41),mass3set(:,1),G0tensor(116),G0tensor(117),G0tensor(118), &
    G0tensor(119),M2L1R1,[nME],G0tensor(120))
  call TI_triangle_red(G2tensor(49),RedBasis(44),mass3set(:,3),G0tensor(121),G0tensor(122),G0tensor(123), &
    G0tensor(124),M2L1R1,[nME],G0tensor(125))
  call TI_triangle_red(G2tensor(106),RedBasis(6),mass3set(:,4),G0tensor(126),G0tensor(127),G0tensor(128), &
    G0tensor(129),M2L1R1,[nME],G0tensor(130))
  call TI_triangle_red(G2tensor(6),RedBasis(5),mass3set(:,3),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),M2L1R1,[nME], &
    G0tensor(135))
  call TI_triangle_red(G2tensor(76),RedBasis(3),mass3set(:,4),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nME],G0tensor(140))
  call TI_triangle_red(G2tensor(23),RedBasis(9),mass3set(:,4),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nME],G0tensor(145))
  call TI_triangle_red(G2tensor(22),RedBasis(15),mass3set(:,3),G0tensor(146),G0tensor(147),G0tensor(148), &
    G0tensor(149),M2L1R1,[nME],G0tensor(150))
  call TI_triangle_red(G2tensor(73),RedBasis(17),mass3set(:,4),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nME],G0tensor(155))
  call TI_triangle_red(G2tensor(37),RedBasis(16),mass3set(:,3),G0tensor(156),G0tensor(157),G0tensor(158), &
    G0tensor(159),M2L1R1,[nME],G0tensor(160))
  call TI_triangle_red(G2tensor(55),RedBasis(21),mass3set(:,3),G0tensor(161),G0tensor(162),G0tensor(163), &
    G0tensor(164),M2L1R1,[nME],G0tensor(165))
  call TI_triangle_red(G2tensor(82),RedBasis(47),mass3set(:,2),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nME],G0tensor(170))
  call TI_triangle_red(G2tensor(88),RedBasis(48),mass3set(:,2),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nME],G0tensor(175))
  call ol_merge_tensors(T0sum(24),[G0tensor(1)])
  call ol_merge_tensors(T0sum(25),[G0tensor(26)])
  call ol_merge_tensors(T0sum(26),[G0tensor(51)])
  call ol_merge_tensors(T0sum(27),[G0tensor(76)])
  call ol_merge_tensors(T0sum(28),[G0tensor(101)])
  call ol_merge_tensors(T0sum(29),[G0tensor(7)])
  call ol_merge_tensors(T0sum(30),[G0tensor(32)])
  call ol_merge_tensors(T0sum(31),[G0tensor(110)])
  call ol_merge_tensors(T0sum(32),[G0tensor(29)])
  call ol_merge_tensors(T0sum(33),[G0tensor(62)])
  call ol_merge_tensors(T0sum(34),[G0tensor(75)])
  call ol_merge_tensors(T0sum(35),[G0tensor(28)])
  call ol_merge_tensors(T0sum(36),[G0tensor(43)])
  call ol_merge_tensors(T0sum(37),[G0tensor(40)])
  call ol_merge_tensors(T0sum(38),[G0tensor(50)])
  call ol_merge_tensors(T0sum(39),[G0tensor(57)])
  call ol_merge_tensors(T0sum(40),[G0tensor(103)])
  call ol_merge_tensors(T0sum(41),[G0tensor(92)])
  call ol_merge_tensors(T0sum(42),[G0tensor(107)])
  call ol_merge_tensors(T0sum(43),[G0tensor(63)])
  call ol_merge_tensors(T0sum(44),[G0tensor(114)])
  call ol_merge_tensors(T0sum(45),[G0tensor(69)])
  call ol_merge_tensors(T0sum(46),[G0tensor(88)])
  call ol_merge_tensors(T0sum(47),[G0tensor(116)])
  call ol_merge_tensors(T0sum(48),[G0tensor(121)])
  call ol_merge_tensors(T0sum(49),[G0tensor(126)])
  call ol_merge_tensors(T0sum(50),[G0tensor(131)])
  call ol_merge_tensors(T0sum(51),[G0tensor(136)])
  call ol_merge_tensors(T0sum(52),[G0tensor(141)])
  call ol_merge_tensors(T0sum(53),[G0tensor(146)])
  call ol_merge_tensors(T0sum(54),[G0tensor(151)])
  call ol_merge_tensors(T0sum(55),[G0tensor(156)])
  call ol_merge_tensors(T0sum(56),[G0tensor(161)])
  call ol_merge_tensors(T0sum(57),[G0tensor(166)])
  call ol_merge_tensors(T0sum(58),[G0tensor(171)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[34,29],[0,nME],2,2,wf4(:,5),wf16(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[46,17],[nME,0],2,2,wf16(:,11),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,11),G0H4(1),m3h16x4(:,5),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H4(1),46,nME,G1H4(9),n2h4(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[49,14],[nME,0],2,2,wf8(:,14),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,14),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),49,nME,G1H8(11),n2h8(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[46,17],[nME,0],2,2,wf16(:,25),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,25),G0H4(2),m3h16x4(:,6),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H4(2),46,nME,G1H4(7),n2h4(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[45,18],[nME,0],2,2,wf16(:,17),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,7),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(3),45,nME,G1H4(2),n2h4(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[33,30],[0,nME],2,2,wf4(:,8),wf16(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,10),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[45,18],[nME,0],2,2,wf16(:,21),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,21),G0H4(4),m3h16x4(:,8),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(4),45,nME,G1H4(20),n2h4(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[50,13],[nME,0],2,2,wf8(:,19),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,19),G0H8(2),m3h8x8(:,6),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(2),50,nME,G1H8(12),n2h8(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[49,14],[nME,0],2,2,wf8(:,15),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,15),G0H8(3),m3h8x8(:,7),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(3),49,nME,G1H8(13),n2h8(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[33,30],[0,nME],2,2,wf4(:,8),wf16(:,23))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,11),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[34,29],[0,nME],2,2,wf4(:,5),wf16(:,19))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,12),heltab2x64(:,:,47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[50,13],[nME,0],2,2,wf8(:,20),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,20),G0H8(4),m3h8x8(:,8),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(4),50,nME,G1H8(14),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(12)])
  call Hloop_VQ_A(ntryL,G0H16(1),wf16(:,13),G0H1(1),m3h16x1(:,5),heltab2x16(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nME,G1tensor(1),n2h1(147))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(7),wf4(:,4),G1tensor(31),m3h4x1(:,61),heltab2x4(:,:,75))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(13),wf8(:,3),G1tensor(8),m3h8x1(:,1),heltab2x8(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(20),wf4(:,9),G1tensor(18),m3h4x1(:,62),heltab2x4(:,:,76))
  call Hloop_VA_Q(ntryL,G0H16(2),wf16(:,15),G0H1(1),m3h16x1(:,6),heltab2x16(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nME,G1tensor(3),n2h1(148))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(14),wf8(:,6),G1tensor(29),m3h8x1(:,2),heltab2x8(:,:,32))
  call Hloop_VA_Q(ntryL,G0H16(3),wf16(:,23),G0H1(1),m3h16x1(:,7),heltab2x16(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nME,G1tensor(34),n2h1(149))
  call Hloop_VQ_A(ntryL,G0H16(4),wf16(:,19),G0H1(1),m3h16x1(:,8),heltab2x16(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nME,G1tensor(35),n2h1(150))
  call ol_merge_tensors(G0tensor(77),[G0tensor(55),G0tensor(27),G0tensor(36),G0tensor(6)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(84),G0tensor(49),G0tensor(106),G0tensor(11)])
  call ol_merge_tensors(G0tensor(98),[G0tensor(48),G0tensor(52),G0tensor(2),G0tensor(66),G0tensor(16)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(170),G0tensor(165),G0tensor(160),G0tensor(155),G0tensor(150),G0tensor(145) &
    ,G0tensor(140),G0tensor(135),G0tensor(130),G0tensor(125),G0tensor(120),G0tensor(109),G0tensor(93),G0tensor(74),G0tensor(59) &
    ,G0tensor(53),G0tensor(39),G0tensor(33),G0tensor(14),G0tensor(73),G0tensor(112),G0tensor(72),G0tensor(82),G0tensor(80) &
    ,G0tensor(19),G0tensor(10),G0tensor(60),G0tensor(37),G0tensor(38),G0tensor(13),G0tensor(96),G0tensor(71),G0tensor(46) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(167),G0tensor(152),G0tensor(148),G0tensor(138),G0tensor(133),G0tensor(128) &
    ,G0tensor(123),G0tensor(89),G0tensor(79),G0tensor(68),G0tensor(18),G0tensor(81),G0tensor(31)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(54),G0tensor(9),G0tensor(41)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(25),G0tensor(100),G0tensor(86),G0tensor(56)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(83),G0tensor(104),G0tensor(45),G0tensor(61)])
  call ol_merge_tensors(G1tensor(29),[G0tensor(117),G0tensor(15),G0tensor(91)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(129),G0tensor(20),G0tensor(17),G0tensor(111)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(1),G0tensor(164),G0tensor(134),G0tensor(22),G0tensor(47)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(139),G0tensor(35),G0tensor(30),G0tensor(70),G0tensor(65),G0tensor(42) &
    ,G0tensor(12)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(102),G0tensor(115),G0tensor(8)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(58),G0tensor(44),G0tensor(5),G0tensor(95)])
  call ol_merge_tensors(G1tensor(34),[G1tensor(3),G0tensor(159),G0tensor(149),G0tensor(85),G0tensor(90)])
  call ol_merge_tensors(G0tensor(147),[G0tensor(94),G0tensor(97),G0tensor(105)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(119),G0tensor(113),G0tensor(64),G0tensor(87),G0tensor(67),G0tensor(3)])
  call ol_merge_tensors(G0tensor(157),[G0tensor(108),G0tensor(4)])
  call ol_merge_tensors(G0tensor(162),[G0tensor(124),G0tensor(23)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(158),G0tensor(153),G0tensor(143),G0tensor(127),G0tensor(99),G0tensor(78) &
    ,G0tensor(34)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(168)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(173)])
call TI_bubble_red(G1tensor(8),49,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(29),50,mass2set(:,1),G0tensor(51),M2L1R1,G0tensor(76))
call TI_bubble_red(G1tensor(35),34,mass2set(:,2),G0tensor(101),M2L1R1,G0tensor(7))
call TI_bubble_red(G1tensor(34),33,mass2set(:,2),G0tensor(32),M2L1R1,G0tensor(110))
call TI_bubble_red(G1tensor(31),46,mass2set(:,1),G0tensor(29),M2L1R1,G0tensor(62))
call TI_bubble_red(G1tensor(18),45,mass2set(:,1),G0tensor(75),M2L1R1,G0tensor(28))
  call ol_merge_tensors(G0tensor(28),[G0tensor(62),G0tensor(110),G0tensor(7),G0tensor(76),G0tensor(26),G0tensor(175)])
  call ol_merge_tensors(T0sum(59),[G0tensor(77)])
  call ol_merge_tensors(T0sum(60),[G0tensor(122)])
  call ol_merge_tensors(T0sum(61),[G0tensor(98)])
  call ol_merge_tensors(T0sum(62),[G0tensor(28)])
  call ol_merge_tensors(T0sum(63),[G0tensor(172)])
  call ol_merge_tensors(T0sum(64),[G0tensor(1)])
  call ol_merge_tensors(T0sum(65),[G0tensor(24)])
  call ol_merge_tensors(T0sum(66),[G0tensor(118)])
  call ol_merge_tensors(T0sum(67),[G0tensor(51)])
  call ol_merge_tensors(T0sum(68),[G0tensor(154)])
  call ol_merge_tensors(T0sum(69),[G0tensor(101)])
  call ol_merge_tensors(T0sum(70),[G0tensor(144)])
  call ol_merge_tensors(T0sum(71),[G0tensor(132)])
  call ol_merge_tensors(T0sum(72),[G0tensor(137)])
  call ol_merge_tensors(T0sum(73),[G0tensor(32)])
  call ol_merge_tensors(T0sum(74),[G0tensor(147)])
  call ol_merge_tensors(T0sum(75),[G0tensor(142)])
  call ol_merge_tensors(T0sum(76),[G0tensor(157)])
  call ol_merge_tensors(T0sum(77),[G0tensor(162)])
  call ol_merge_tensors(T0sum(78),[G0tensor(163)])
  call ol_merge_tensors(T0sum(79),[G0tensor(29)])
  call ol_merge_tensors(T0sum(80),[G0tensor(169)])
  call ol_merge_tensors(T0sum(81),[G0tensor(75)])
  call ol_merge_tensors(T0sum(82),[G0tensor(174)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 34, 35, 51 ],masses2_8,RedSet_4(5),ScalarBoxes(1))
  call compute_scalar_box([ 32, 35, 51 ],masses2_11,RedSet_4(6),ScalarBoxes(2))
  call compute_scalar_box([ 32, 34, 51 ],masses2_9,RedSet_4(7),ScalarBoxes(3))
  call compute_scalar_box([ 32, 34, 35 ],masses2_9,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 19 ],masses2_8,RedSet_4(8),ScalarBoxes(5))
  call compute_scalar_box([ 44, 46, 47 ],masses2_9,RedSet_4(9),ScalarBoxes(6))
  call compute_scalar_box([ 32, 46, 47 ],masses2_9,RedSet_4(10),ScalarBoxes(7))
  call compute_scalar_box([ 32, 44, 47 ],masses2_11,RedSet_4(11),ScalarBoxes(8))
  call compute_scalar_box([ 32, 44, 46 ],masses2_10,RedSet_4(2),ScalarBoxes(9))
  call compute_scalar_box([ 12, 14, 15 ],masses2_9,RedSet_4(12),ScalarBoxes(10))
  call compute_scalar_box([ 33, 35, 51 ],masses2_8,RedSet_4(13),ScalarBoxes(11))
  call compute_scalar_box([ 32, 33, 51 ],masses2_9,RedSet_4(14),ScalarBoxes(12))
  call compute_scalar_box([ 32, 33, 35 ],masses2_9,RedSet_4(3),ScalarBoxes(13))
  call compute_scalar_box([ 1, 3, 19 ],masses2_8,RedSet_4(15),ScalarBoxes(14))
  call compute_scalar_box([ 33, 35, 47 ],masses2_8,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 32, 35, 47 ],masses2_11,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 32, 33, 47 ],masses2_9,RedSet_4(18),ScalarBoxes(17))
  call compute_scalar_box([ 1, 3, 15 ],masses2_8,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 44, 45, 47 ],masses2_9,RedSet_4(20),ScalarBoxes(19))
  call compute_scalar_box([ 32, 45, 47 ],masses2_9,RedSet_4(21),ScalarBoxes(20))
  call compute_scalar_box([ 32, 44, 45 ],masses2_10,RedSet_4(4),ScalarBoxes(21))
  call compute_scalar_box([ 12, 13, 15 ],masses2_9,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 34, 35, 47 ],masses2_8,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 32, 34, 47 ],masses2_9,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 2, 3, 15 ],masses2_8,RedSet_4(25),ScalarBoxes(25))
! end of process


end subroutine vamp_1

end module ol_vamp_1_mmee_qed_el_eexmmxaa_1_/**/REALKIND
