
FeynArtsProcess = {F[2, {1}], -F[2, {1}]} -> {-F[2, {2}], F[2, {2}]};

SortExternal = True;

OpenLoopsModel = "QED_electronic";

CreateTopologiesOptions = {
  ExcludeTopologies -> {Snails, WFCorrectionCTs, WFCorrections, TadpoleCTs, Tadpoles},
  Adjacencies -> {3, 4}
};

InsertFieldsOptions = {
  Restrictions -> {ExcludeParticles -> {V[2 | 3 | 4 | 5], U[__], S[1 | 2 | 3], F[1, __], F[2, {2}], F[2, {3}], F[4, __], F[3, __]}},
  Model -> {"SMQCD", "SMQCDR2"},
  GenericModel -> "Lorentz",
  InsertionLevel -> {Particles}
};

UnitaryGauge = True;

ColourCorrelations = Automatic;

OTFColourCorrelations = Automatic;

SpinCorrelatedHardFactor = Automatic;

SubProcessName = Automatic;

SelectCoupling = True & ;

SelectInterference = {
  qQCD -> {0}
};

SelectTreeDiagrams = True & ;

SelectLoopDiagrams =  !(ContainsFermionLoop[##1] && NLegsOnLoop[2][##1]) && ParticlesInLoop[V[1]][##1] & ;

SelectCTDiagrams = True & ;

ReplaceOSw = False;

SetParameters = {
  nf -> 0,
  nfl -> 1,
  CKMORDER -> 0,
  nc -> 3,
  MU -> 0,
  MD -> 0,
  MS -> 0,
  MC -> 0,
  LeadingColour -> 0,
  POLSEL -> 1
};

ChannelMap = {};

Approximation = "nofermionloops";

QED = 2;

ForceLoops = Automatic;

ForceLoopsInclude = Automatic;

NonZeroHels = Null;

OnTheFlyMode = Automatic;

noQCD = False;

noEW = False;
