
! **********************************************************************
module ol_tables_storage_eeaa_qed_eexaaaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,312)
integer(intkind2), save :: heltab2x2(2,2,1172)
integer(intkind2), save :: heltab2x4(2,4,804)
integer(intkind2), save :: heltab2x8(2,8,352)
integer(intkind2), save :: heltab2x16(2,16,200)
integer(intkind2), save :: heltab2x32(2,32,120)
integer(intkind2), save :: heltab2x64(2,64,312)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(312)
integer(intkind2), save :: m3h2x1(3,1172)
integer(intkind2), save :: m3h4x1(3,150)
integer(intkind2), save :: m3h8x1(3,66)
integer(intkind2), save :: m3h16x1(3,24)
integer(intkind2), save :: m3h2x2(3,654)
integer(intkind2), save :: m3h4x2(3,42)
integer(intkind2), save :: m3h8x2(3,16)
integer(intkind2), save :: m3h2x4(3,244)
integer(intkind2), save :: m3h4x4(3,36)
integer(intkind2), save :: m3h8x4(3,8)
integer(intkind2), save :: m3h16x4(3,72)
integer(intkind2), save :: m3h2x8(3,124)
integer(intkind2), save :: m3h4x8(3,20)
integer(intkind2), save :: m3h8x8(3,72)
integer(intkind2), save :: m3h2x16(3,92)
integer(intkind2), save :: m3h4x16(3,48)
integer(intkind2), save :: m3h2x32(3,120)

integer(intkind2), save :: n2h1(1340)
integer(intkind2), save :: n2h2(544)
integer(intkind2), save :: n2h4(346)
integer(intkind2), save :: n2h8(164)
integer(intkind2), save :: n2h16(70)
integer(intkind2), save :: n2h32(120)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_eeaa_qed_eexaaaa_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_eeaa_qed_eexaaaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(1144)
  type(hol), save :: G2H2(522)
  type(hol), save :: G0H4(36)
  type(hol), save :: G1H4(483)
  type(hol), save :: G2H4(142)
  type(hol), save :: G0H8(24)
  type(hol), save :: G1H8(108)
  type(hol), save :: G2H8(48)
  type(hol), save :: G0H16(12)
  type(hol), save :: G1H16(44)
  type(hol), save :: G2H16(18)
  type(hol), save :: G0H32(1)
  type(hol), save :: G1H32(36)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(960) :: G0tensor
  type(hcl), save, dimension(960) :: G1tensor
  type(hcl), save, dimension(1062) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(248)
type (redset4),    save :: RedSet_4(274)
type (redset5),    save :: RedSet_5(108)
integer, save :: mass2set(0:1,2)
integer, save :: mass3set(0:2,4)
integer, save :: mass4set(0:3,5)
integer, save :: mass5set(0:4,5)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(2)
  integer, save :: momenta_29(2)
  integer, save :: momenta_30(2)
  integer, save :: momenta_31(2)
  integer, save :: momenta_32(2)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(3)
  integer, save :: momenta_127(3)
  integer, save :: momenta_128(3)
  integer, save :: momenta_129(3)
  integer, save :: momenta_130(3)
  integer, save :: momenta_131(3)
  integer, save :: momenta_132(3)
  integer, save :: momenta_133(3)
  integer, save :: momenta_134(3)
  integer, save :: momenta_135(3)
  integer, save :: momenta_136(3)
  integer, save :: momenta_137(3)
  integer, save :: momenta_138(3)
  integer, save :: momenta_139(3)
  integer, save :: momenta_140(3)
  integer, save :: momenta_141(3)
  integer, save :: momenta_142(3)
  integer, save :: momenta_143(3)
  integer, save :: momenta_144(3)
  integer, save :: momenta_145(3)
  integer, save :: momenta_146(3)
  integer, save :: momenta_147(3)
  integer, save :: momenta_148(3)
  integer, save :: momenta_149(3)
  integer, save :: momenta_150(3)
  integer, save :: momenta_151(3)
  integer, save :: momenta_152(3)
  integer, save :: momenta_153(3)
  integer, save :: momenta_154(3)
  integer, save :: momenta_155(3)
  integer, save :: momenta_156(3)
  integer, save :: momenta_157(3)
  integer, save :: momenta_158(3)
  integer, save :: momenta_159(3)
  integer, save :: momenta_160(3)
  integer, save :: momenta_161(3)
  integer, save :: momenta_162(3)
  integer, save :: momenta_163(3)
  integer, save :: momenta_164(3)
  integer, save :: momenta_165(3)
  integer, save :: momenta_166(3)
  integer, save :: momenta_167(3)
  integer, save :: momenta_168(3)
  integer, save :: momenta_169(3)
  integer, save :: momenta_170(3)
  integer, save :: momenta_171(3)
  integer, save :: momenta_172(3)
  integer, save :: momenta_173(3)
  integer, save :: momenta_174(3)
  integer, save :: momenta_175(3)
  integer, save :: momenta_176(3)
  integer, save :: momenta_177(3)
  integer, save :: momenta_178(3)
  integer, save :: momenta_179(3)
  integer, save :: momenta_180(3)
  integer, save :: momenta_181(3)
  integer, save :: momenta_182(3)
  integer, save :: momenta_183(3)
  integer, save :: momenta_184(3)
  integer, save :: momenta_185(3)
  integer, save :: momenta_186(3)
  integer, save :: momenta_187(3)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(4)
  integer, save :: momenta_232(4)
  integer, save :: momenta_233(4)
  integer, save :: momenta_234(4)
  integer, save :: momenta_235(4)
  integer, save :: momenta_236(4)
  integer, save :: momenta_237(4)
  integer, save :: momenta_238(4)
  integer, save :: momenta_239(4)
  integer, save :: momenta_240(4)
  integer, save :: momenta_241(4)
  integer, save :: momenta_242(4)
  integer, save :: momenta_243(4)
  integer, save :: momenta_244(4)
  integer, save :: momenta_245(4)
  integer, save :: momenta_246(4)
  integer, save :: momenta_247(4)
  integer, save :: momenta_248(4)
  integer, save :: momenta_249(4)
  integer, save :: momenta_250(4)
  integer, save :: momenta_251(4)
  integer, save :: momenta_252(4)
  integer, save :: momenta_253(4)
  integer, save :: momenta_254(4)
  integer, save :: momenta_255(4)
  integer, save :: momenta_256(4)
  integer, save :: momenta_257(4)
  integer, save :: momenta_258(4)
  integer, save :: momenta_259(4)
  integer, save :: momenta_260(4)
  integer, save :: momenta_261(4)
  integer, save :: momenta_262(4)
  integer, save :: momenta_263(4)
  integer, save :: momenta_264(4)
  integer, save :: momenta_265(4)
  integer, save :: momenta_266(4)
  integer, save :: momenta_267(4)
  integer, save :: momenta_268(4)
  integer, save :: momenta_269(4)
  integer, save :: momenta_270(4)
  integer, save :: momenta_271(4)
  integer, save :: momenta_272(4)
  integer, save :: momenta_273(4)
  integer, save :: momenta_274(4)
  integer, save :: momenta_275(4)
  integer, save :: momenta_276(4)
  integer, save :: momenta_277(4)
  integer, save :: momenta_278(4)
  integer, save :: momenta_279(4)
  integer, save :: momenta_280(4)
  integer, save :: momenta_281(4)
  integer, save :: momenta_282(4)
  integer, save :: momenta_283(4)
  integer, save :: momenta_284(4)
  integer, save :: momenta_285(4)
  integer, save :: momenta_286(4)
  integer, save :: momenta_287(4)
  integer, save :: momenta_288(4)
  integer, save :: momenta_289(4)
  integer, save :: momenta_290(4)
  integer, save :: momenta_291(4)
  integer, save :: momenta_292(4)
  integer, save :: momenta_293(4)
  integer, save :: momenta_294(4)
  integer, save :: momenta_295(4)
  integer, save :: momenta_296(4)
  integer, save :: momenta_297(4)
  integer, save :: momenta_298(4)
  integer, save :: momenta_299(4)
  integer, save :: momenta_300(4)
  integer, save :: momenta_301(4)
  integer, save :: momenta_302(4)
  integer, save :: momenta_303(4)
  integer, save :: momenta_304(4)
  integer, save :: momenta_305(4)
  integer, save :: momenta_306(4)
  integer, save :: momenta_307(4)
  integer, save :: momenta_308(4)
  integer, save :: momenta_309(4)
  integer, save :: momenta_310(4)
  integer, save :: momenta_311(4)
  integer, save :: momenta_312(4)
  integer, save :: momenta_313(4)
  integer, save :: momenta_314(4)
  integer, save :: momenta_315(4)
  integer, save :: momenta_316(4)
  integer, save :: momenta_317(4)
  integer, save :: momenta_318(4)
  integer, save :: momenta_319(4)
  integer, save :: momenta_320(4)
  integer, save :: momenta_321(4)
  integer, save :: momenta_322(4)
  integer, save :: momenta_323(4)
  integer, save :: momenta_324(4)
  integer, save :: momenta_325(4)
  integer, save :: momenta_326(4)
  integer, save :: momenta_327(4)
  integer, save :: momenta_328(4)
  integer, save :: momenta_329(4)
  integer, save :: momenta_330(4)
  integer, save :: momenta_331(4)
  integer, save :: momenta_332(4)
  integer, save :: momenta_333(4)
  integer, save :: momenta_334(4)
  integer, save :: momenta_335(4)
  integer, save :: momenta_336(4)
  integer, save :: momenta_337(4)
  integer, save :: momenta_338(4)
  integer, save :: momenta_339(4)
  integer, save :: momenta_340(4)
  integer, save :: momenta_341(4)
  integer, save :: momenta_342(4)
  integer, save :: momenta_343(4)
  integer, save :: momenta_344(4)
  integer, save :: momenta_345(4)
  integer, save :: momenta_346(4)
  integer, save :: momenta_347(4)
  integer, save :: momenta_348(4)
  integer, save :: momenta_349(4)
  integer, save :: momenta_350(4)
  integer, save :: momenta_351(4)
  integer, save :: momenta_352(4)
  integer, save :: momenta_353(4)
  integer, save :: momenta_354(4)
  integer, save :: momenta_355(4)
  integer, save :: momenta_356(4)
  integer, save :: momenta_357(4)
  integer, save :: momenta_358(4)
  integer, save :: momenta_359(4)
  integer, save :: momenta_360(4)
  integer, save :: momenta_361(4)
  integer, save :: momenta_362(4)
  integer, save :: momenta_363(4)
  integer, save :: momenta_364(4)
  integer, save :: momenta_365(4)
  integer, save :: momenta_366(4)
  integer, save :: momenta_367(4)
  integer, save :: momenta_368(4)
  integer, save :: momenta_369(4)
  integer, save :: momenta_370(4)
  integer, save :: momenta_371(4)
  integer, save :: momenta_372(4)
  integer, save :: momenta_373(4)
  integer, save :: momenta_374(4)
  integer, save :: momenta_375(4)
  integer, save :: momenta_376(4)
  integer, save :: momenta_377(4)
  integer, save :: momenta_378(4)
  integer, save :: momenta_379(4)
  integer, save :: momenta_380(5)
  integer, save :: momenta_381(5)
  integer, save :: momenta_382(5)
  integer, save :: momenta_383(5)
  integer, save :: momenta_384(5)
  integer, save :: momenta_385(5)
  integer, save :: momenta_386(5)
  integer, save :: momenta_387(5)
  integer, save :: momenta_388(5)
  integer, save :: momenta_389(5)
  integer, save :: momenta_390(5)
  integer, save :: momenta_391(5)
  integer, save :: momenta_392(5)
  integer, save :: momenta_393(5)
  integer, save :: momenta_394(5)
  integer, save :: momenta_395(5)
  integer, save :: momenta_396(5)
  integer, save :: momenta_397(5)
  integer, save :: momenta_398(5)
  integer, save :: momenta_399(5)
  integer, save :: momenta_400(5)
  integer, save :: momenta_401(5)
  integer, save :: momenta_402(5)
  integer, save :: momenta_403(5)
  integer, save :: momenta_404(5)
  integer, save :: momenta_405(5)
  integer, save :: momenta_406(5)
  integer, save :: momenta_407(5)
  integer, save :: momenta_408(5)
  integer, save :: momenta_409(5)
  integer, save :: momenta_410(5)
  integer, save :: momenta_411(5)
  integer, save :: momenta_412(5)
  integer, save :: momenta_413(5)
  integer, save :: momenta_414(5)
  integer, save :: momenta_415(5)
  integer, save :: momenta_416(5)
  integer, save :: momenta_417(5)
  integer, save :: momenta_418(5)
  integer, save :: momenta_419(5)
  integer, save :: momenta_420(5)
  integer, save :: momenta_421(5)
  integer, save :: momenta_422(5)
  integer, save :: momenta_423(5)
  integer, save :: momenta_424(5)
  integer, save :: momenta_425(5)
  integer, save :: momenta_426(5)
  integer, save :: momenta_427(5)
  integer, save :: momenta_428(5)
  integer, save :: momenta_429(5)
  integer, save :: momenta_430(5)
  integer, save :: momenta_431(5)
  integer, save :: momenta_432(5)
  integer, save :: momenta_433(5)
  integer, save :: momenta_434(5)
  integer, save :: momenta_435(5)
  integer, save :: momenta_436(5)
  integer, save :: momenta_437(5)
  integer, save :: momenta_438(5)
  integer, save :: momenta_439(5)
  integer, save :: momenta_440(5)
  integer, save :: momenta_441(5)
  integer, save :: momenta_442(5)
  integer, save :: momenta_443(5)
  integer, save :: momenta_444(5)
  integer, save :: momenta_445(5)
  integer, save :: momenta_446(5)
  integer, save :: momenta_447(5)
  integer, save :: momenta_448(5)
  integer, save :: momenta_449(5)
  integer, save :: momenta_450(5)
  integer, save :: momenta_451(5)
  integer, save :: momenta_452(5)
  integer, save :: momenta_453(5)
  integer, save :: momenta_454(5)
  integer, save :: momenta_455(5)
  integer, save :: momenta_456(5)
  integer, save :: momenta_457(5)
  integer, save :: momenta_458(5)
  integer, save :: momenta_459(5)
  integer, save :: momenta_460(5)
  integer, save :: momenta_461(5)
  integer, save :: momenta_462(5)
  integer, save :: momenta_463(5)
  integer, save :: momenta_464(5)
  integer, save :: momenta_465(5)
  integer, save :: momenta_466(5)
  integer, save :: momenta_467(5)
  integer, save :: momenta_468(5)
  integer, save :: momenta_469(5)
  integer, save :: momenta_470(5)
  integer, save :: momenta_471(5)
  integer, save :: momenta_472(5)
  integer, save :: momenta_473(5)
  integer, save :: momenta_474(5)
  integer, save :: momenta_475(5)
  integer, save :: momenta_476(5)
  integer, save :: momenta_477(5)
  integer, save :: momenta_478(6)
  integer, save :: momenta_479(6)
  integer, save :: momenta_480(6)
  integer, save :: momenta_481(6)
  integer, save :: momenta_482(6)
  integer, save :: momenta_483(6)
  integer, save :: momenta_484(6)
  integer, save :: momenta_485(6)
  integer, save :: momenta_486(6)
  integer, save :: momenta_487(6)
  integer, save :: momenta_488(6)
  integer, save :: momenta_489(6)
  integer, save :: momenta_490(6)
  integer, save :: momenta_491(6)
  integer, save :: momenta_492(6)
  integer, save :: momenta_493(6)
  integer, save :: momenta_494(6)
  integer, save :: momenta_495(6)
  integer, save :: momenta_496(6)
  integer, save :: momenta_497(6)
  integer, save :: momenta_498(6)
  integer, save :: momenta_499(6)
  integer, save :: momenta_500(6)
  integer, save :: momenta_501(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(3)
  integer, save :: masses2_5(3)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(4)
  integer, save :: masses2_9(4)
  integer, save :: masses2_10(4)
  integer, save :: masses2_11(4)
  integer, save :: masses2_12(4)
  integer, save :: masses2_13(5)
  integer, save :: masses2_14(5)
  integer, save :: masses2_15(5)
  integer, save :: masses2_16(5)
  integer, save :: masses2_17(5)
  integer, save :: masses2_18(6)
  integer, save :: masses2_19(6)
  integer, save :: masses2_20(6)

type(scalarbox), save :: ScalarBoxes(262)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(15)
integer, save :: sbarray_8(15)
integer, save :: sbarray_9(15)
integer, save :: sbarray_10(15)
integer, save :: sbarray_11(15)
integer, save :: sbarray_12(15)
integer, save :: sbarray_13(15)
integer, save :: sbarray_14(15)
integer, save :: sbarray_15(15)
integer, save :: sbarray_16(15)
integer, save :: sbarray_17(15)
integer, save :: sbarray_18(15)
integer, save :: sbarray_19(15)
integer, save :: sbarray_20(15)
integer, save :: sbarray_21(15)
integer, save :: sbarray_22(15)
integer, save :: sbarray_23(15)
integer, save :: sbarray_24(15)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)
integer, save :: sbarray_59(5)
integer, save :: sbarray_60(5)
integer, save :: sbarray_61(5)
integer, save :: sbarray_62(5)
integer, save :: sbarray_63(5)
integer, save :: sbarray_64(5)
integer, save :: sbarray_65(5)
integer, save :: sbarray_66(5)
integer, save :: sbarray_67(5)
integer, save :: sbarray_68(5)
integer, save :: sbarray_69(5)
integer, save :: sbarray_70(5)
integer, save :: sbarray_71(5)
integer, save :: sbarray_72(5)
integer, save :: sbarray_73(5)
integer, save :: sbarray_74(5)
integer, save :: sbarray_75(5)
integer, save :: sbarray_76(5)
integer, save :: sbarray_77(5)
integer, save :: sbarray_78(5)
integer, save :: sbarray_79(5)
integer, save :: sbarray_80(5)
integer, save :: sbarray_81(5)
integer, save :: sbarray_82(5)
integer, save :: sbarray_83(5)
integer, save :: sbarray_84(5)
integer, save :: sbarray_85(5)
integer, save :: sbarray_86(5)
integer, save :: sbarray_87(5)
integer, save :: sbarray_88(5)
integer, save :: sbarray_89(5)
integer, save :: sbarray_90(5)
integer, save :: sbarray_91(5)
integer, save :: sbarray_92(5)
integer, save :: sbarray_93(5)
integer, save :: sbarray_94(5)
integer, save :: sbarray_95(5)
integer, save :: sbarray_96(5)
integer, save :: sbarray_97(5)
integer, save :: sbarray_98(5)
integer, save :: sbarray_99(5)
integer, save :: sbarray_100(5)
integer, save :: sbarray_101(5)
integer, save :: sbarray_102(5)
integer, save :: sbarray_103(5)
integer, save :: sbarray_104(5)
integer, save :: sbarray_105(5)
integer, save :: sbarray_106(5)
integer, save :: sbarray_107(5)
integer, save :: sbarray_108(5)
integer, save :: sbarray_109(5)
integer, save :: sbarray_110(5)
integer, save :: sbarray_111(5)
integer, save :: sbarray_112(5)
integer, save :: sbarray_113(5)
integer, save :: sbarray_114(5)
integer, save :: sbarray_115(5)
integer, save :: sbarray_116(5)
integer, save :: sbarray_117(5)
integer, save :: sbarray_118(5)
integer, save :: sbarray_119(5)
integer, save :: sbarray_120(5)
integer, save :: sbarray_121(5)
integer, save :: sbarray_122(5)

  type(hcl), save, dimension(395) :: T0sum
  type(hcl), save, dimension(122) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eeaa_qed_eexaaaa_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,1144)
  call hol_allocation(4,15,4,2,G2H2,522)
  call hol_allocation(4,1,4,4,G0H4,36)
  call hol_allocation(4,5,4,4,G1H4,483)
  call hol_allocation(4,15,4,4,G2H4,142)
  call hol_allocation(4,1,4,8,G0H8,24)
  call hol_allocation(4,5,4,8,G1H8,108)
  call hol_allocation(4,15,4,8,G2H8,48)
  call hol_allocation(4,1,4,16,G0H16,12)
  call hol_allocation(4,5,4,16,G1H16,44)
  call hol_allocation(4,15,4,16,G2H16,18)
  call hol_allocation(4,1,4,32,G0H32,1)
  call hol_allocation(4,5,4,32,G1H32,36)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_eeaa_qed_eexaaaa_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,1,4,min(nhel,2),G0H2,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,1144)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,522)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,36)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,483)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,142)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,24)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,108)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,48)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,12)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,44)
  call hol_allocation(4,15,4,min(nhel,16),G2H16,18)
  call hol_allocation(4,1,4,min(nhel,32),G0H32,1)
  call hol_allocation(4,5,4,min(nhel,32),G1H32,36)
  call hol_allocation(4,1,4,min(nhel,64),G0H64,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,1144,dmode)
  call hol_deallocation(G2H2,522,dmode)
  call hol_deallocation(G0H4,36,dmode)
  call hol_deallocation(G1H4,483,dmode)
  call hol_deallocation(G2H4,142,dmode)
  call hol_deallocation(G0H8,24,dmode)
  call hol_deallocation(G1H8,108,dmode)
  call hol_deallocation(G2H8,48,dmode)
  call hol_deallocation(G0H16,12,dmode)
  call hol_deallocation(G1H16,44,dmode)
  call hol_deallocation(G2H16,18,dmode)
  call hol_deallocation(G0H32,1,dmode)
  call hol_deallocation(G1H32,36,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 960)
call hcl_allocation(5,G1tensor, 960)
call hcl_allocation(15,G2tensor, 1062)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 960,dmode)
call hcl_deallocation(G1tensor, 960,dmode)
call hcl_deallocation(G2tensor, 1062,dmode)

    call hcl_deallocation(T0sum,395,dmode)
  call hcl_deallocation(T1sum,122,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,395)
  call hcl_allocation(5,T1sum,122)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_eeaa_qed_eexaaaa_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_eeaa_qed_eexaaaa_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,395
    call init_hcl(T0sum(i))
  end do
  do i = 1,122
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 4)
  call scale_one_tsum(T1sum(10)%cmp, 4)
  call scale_one_tsum(T1sum(11)%cmp, 4)
  call scale_one_tsum(T1sum(12)%cmp, 4)
  call scale_one_tsum(T1sum(13)%cmp, 4)
  call scale_one_tsum(T1sum(14)%cmp, 4)
  call scale_one_tsum(T1sum(15)%cmp, 4)
  call scale_one_tsum(T1sum(16)%cmp, 4)
  call scale_one_tsum(T1sum(17)%cmp, 4)
  call scale_one_tsum(T1sum(18)%cmp, 4)
  call scale_one_tsum(T1sum(19)%cmp, 4)
  call scale_one_tsum(T1sum(20)%cmp, 4)
  call scale_one_tsum(T1sum(21)%cmp, 4)
  call scale_one_tsum(T1sum(22)%cmp, 4)
  call scale_one_tsum(T1sum(23)%cmp, 4)
  call scale_one_tsum(T1sum(24)%cmp, 4)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T1sum(47)%cmp, 2)
  call scale_one_tsum(T1sum(48)%cmp, 2)
  call scale_one_tsum(T1sum(49)%cmp, 2)
  call scale_one_tsum(T1sum(50)%cmp, 2)
  call scale_one_tsum(T1sum(51)%cmp, 2)
  call scale_one_tsum(T1sum(52)%cmp, 2)
  call scale_one_tsum(T1sum(53)%cmp, 2)
  call scale_one_tsum(T1sum(54)%cmp, 2)
  call scale_one_tsum(T1sum(55)%cmp, 2)
  call scale_one_tsum(T1sum(56)%cmp, 2)
  call scale_one_tsum(T1sum(57)%cmp, 2)
  call scale_one_tsum(T1sum(58)%cmp, 2)
  call scale_one_tsum(T1sum(59)%cmp, 2)
  call scale_one_tsum(T1sum(60)%cmp, 2)
  call scale_one_tsum(T1sum(61)%cmp, 2)
  call scale_one_tsum(T1sum(62)%cmp, 2)
  call scale_one_tsum(T1sum(63)%cmp, 2)
  call scale_one_tsum(T1sum(64)%cmp, 2)
  call scale_one_tsum(T1sum(65)%cmp, 2)
  call scale_one_tsum(T1sum(66)%cmp, 2)
  call scale_one_tsum(T1sum(67)%cmp, 2)
  call scale_one_tsum(T1sum(68)%cmp, 2)
  call scale_one_tsum(T1sum(69)%cmp, 2)
  call scale_one_tsum(T1sum(70)%cmp, 2)
  call scale_one_tsum(T1sum(71)%cmp, 2)
  call scale_one_tsum(T1sum(72)%cmp, 2)
  call scale_one_tsum(T1sum(73)%cmp, 2)
  call scale_one_tsum(T1sum(74)%cmp, 2)
  call scale_one_tsum(T1sum(75)%cmp, 2)
  call scale_one_tsum(T1sum(76)%cmp, 2)
  call scale_one_tsum(T1sum(77)%cmp, 2)
  call scale_one_tsum(T1sum(78)%cmp, 2)
  call scale_one_tsum(T1sum(79)%cmp, 2)
  call scale_one_tsum(T1sum(80)%cmp, 2)
  call scale_one_tsum(T1sum(81)%cmp, 2)
  call scale_one_tsum(T1sum(82)%cmp, 2)
  call scale_one_tsum(T1sum(83)%cmp, 2)
  call scale_one_tsum(T1sum(84)%cmp, 2)
  call scale_one_tsum(T1sum(85)%cmp, 2)
  call scale_one_tsum(T1sum(86)%cmp, 2)
  call scale_one_tsum(T1sum(87)%cmp, 2)
  call scale_one_tsum(T1sum(88)%cmp, 2)
  call scale_one_tsum(T1sum(89)%cmp, 2)
  call scale_one_tsum(T1sum(90)%cmp, 2)
  call scale_one_tsum(T1sum(91)%cmp, 2)
  call scale_one_tsum(T1sum(92)%cmp, 2)
  call scale_one_tsum(T1sum(93)%cmp, 2)
  call scale_one_tsum(T1sum(94)%cmp, 2)
  call scale_one_tsum(T1sum(95)%cmp, 2)
  call scale_one_tsum(T1sum(96)%cmp, 2)
  call scale_one_tsum(T1sum(97)%cmp, 2)
  call scale_one_tsum(T1sum(98)%cmp, 2)
  call scale_one_tsum(T1sum(99)%cmp, 2)
  call scale_one_tsum(T1sum(100)%cmp, 2)
  call scale_one_tsum(T1sum(101)%cmp, 2)
  call scale_one_tsum(T1sum(102)%cmp, 2)
  call scale_one_tsum(T1sum(103)%cmp, 2)
  call scale_one_tsum(T1sum(104)%cmp, 2)
  call scale_one_tsum(T1sum(105)%cmp, 2)
  call scale_one_tsum(T1sum(106)%cmp, 2)
  call scale_one_tsum(T1sum(107)%cmp, 2)
  call scale_one_tsum(T1sum(108)%cmp, 2)
  call scale_one_tsum(T1sum(109)%cmp, 2)
  call scale_one_tsum(T1sum(110)%cmp, 2)
  call scale_one_tsum(T1sum(111)%cmp, 2)
  call scale_one_tsum(T1sum(112)%cmp, 2)
  call scale_one_tsum(T1sum(113)%cmp, 2)
  call scale_one_tsum(T1sum(114)%cmp, 2)
  call scale_one_tsum(T1sum(115)%cmp, 2)
  call scale_one_tsum(T1sum(116)%cmp, 2)
  call scale_one_tsum(T1sum(117)%cmp, 2)
  call scale_one_tsum(T1sum(118)%cmp, 2)
  call scale_one_tsum(T1sum(119)%cmp, 2)
  call scale_one_tsum(T1sum(120)%cmp, 2)
  call scale_one_tsum(T1sum(121)%cmp, 2)
  call scale_one_tsum(T1sum(122)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, 0)
  call scale_one_tsum(T0sum(157)%cmp, 0)
  call scale_one_tsum(T0sum(158)%cmp, 0)
  call scale_one_tsum(T0sum(159)%cmp, 0)
  call scale_one_tsum(T0sum(160)%cmp, 0)
  call scale_one_tsum(T0sum(161)%cmp, 0)
  call scale_one_tsum(T0sum(162)%cmp, 0)
  call scale_one_tsum(T0sum(163)%cmp, 0)
  call scale_one_tsum(T0sum(164)%cmp, 0)
  call scale_one_tsum(T0sum(165)%cmp, 0)
  call scale_one_tsum(T0sum(166)%cmp, 0)
  call scale_one_tsum(T0sum(167)%cmp, 0)
  call scale_one_tsum(T0sum(168)%cmp, 0)
  call scale_one_tsum(T0sum(169)%cmp, 0)
  call scale_one_tsum(T0sum(170)%cmp, 0)
  call scale_one_tsum(T0sum(171)%cmp, 0)
  call scale_one_tsum(T0sum(172)%cmp, 0)
  call scale_one_tsum(T0sum(173)%cmp, 0)
  call scale_one_tsum(T0sum(174)%cmp, 0)
  call scale_one_tsum(T0sum(175)%cmp, 0)
  call scale_one_tsum(T0sum(176)%cmp, 0)
  call scale_one_tsum(T0sum(177)%cmp, 0)
  call scale_one_tsum(T0sum(178)%cmp, 0)
  call scale_one_tsum(T0sum(179)%cmp, 0)
  call scale_one_tsum(T0sum(180)%cmp, 0)
  call scale_one_tsum(T0sum(181)%cmp, 0)
  call scale_one_tsum(T0sum(182)%cmp, 0)
  call scale_one_tsum(T0sum(183)%cmp, 0)
  call scale_one_tsum(T0sum(184)%cmp, 0)
  call scale_one_tsum(T0sum(185)%cmp, 0)
  call scale_one_tsum(T0sum(186)%cmp, 0)
  call scale_one_tsum(T0sum(187)%cmp, 0)
  call scale_one_tsum(T0sum(188)%cmp, 0)
  call scale_one_tsum(T0sum(189)%cmp, 0)
  call scale_one_tsum(T0sum(190)%cmp, 0)
  call scale_one_tsum(T0sum(191)%cmp, 0)
  call scale_one_tsum(T0sum(192)%cmp, 0)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)
  call scale_one_tsum(T0sum(228)%cmp, -2)
  call scale_one_tsum(T0sum(229)%cmp, -2)
  call scale_one_tsum(T0sum(230)%cmp, -2)
  call scale_one_tsum(T0sum(231)%cmp, -2)
  call scale_one_tsum(T0sum(232)%cmp, -2)
  call scale_one_tsum(T0sum(233)%cmp, -2)
  call scale_one_tsum(T0sum(234)%cmp, -2)
  call scale_one_tsum(T0sum(235)%cmp, -2)
  call scale_one_tsum(T0sum(236)%cmp, -2)
  call scale_one_tsum(T0sum(237)%cmp, -2)
  call scale_one_tsum(T0sum(238)%cmp, -2)
  call scale_one_tsum(T0sum(239)%cmp, -2)
  call scale_one_tsum(T0sum(240)%cmp, -2)
  call scale_one_tsum(T0sum(241)%cmp, -2)
  call scale_one_tsum(T0sum(242)%cmp, -2)
  call scale_one_tsum(T0sum(243)%cmp, -2)
  call scale_one_tsum(T0sum(244)%cmp, -2)
  call scale_one_tsum(T0sum(245)%cmp, -2)
  call scale_one_tsum(T0sum(246)%cmp, -2)
  call scale_one_tsum(T0sum(247)%cmp, -2)
  call scale_one_tsum(T0sum(248)%cmp, -2)
  call scale_one_tsum(T0sum(249)%cmp, -2)
  call scale_one_tsum(T0sum(250)%cmp, -2)
  call scale_one_tsum(T0sum(251)%cmp, -2)
  call scale_one_tsum(T0sum(252)%cmp, -2)
  call scale_one_tsum(T0sum(253)%cmp, -2)
  call scale_one_tsum(T0sum(254)%cmp, -2)
  call scale_one_tsum(T0sum(255)%cmp, -2)
  call scale_one_tsum(T0sum(256)%cmp, -2)
  call scale_one_tsum(T0sum(257)%cmp, -2)
  call scale_one_tsum(T0sum(258)%cmp, -2)
  call scale_one_tsum(T0sum(259)%cmp, -2)
  call scale_one_tsum(T0sum(260)%cmp, -2)
  call scale_one_tsum(T0sum(261)%cmp, -2)
  call scale_one_tsum(T0sum(262)%cmp, -2)
  call scale_one_tsum(T0sum(263)%cmp, -2)
  call scale_one_tsum(T0sum(264)%cmp, -2)
  call scale_one_tsum(T0sum(265)%cmp, -2)
  call scale_one_tsum(T0sum(266)%cmp, -2)
  call scale_one_tsum(T0sum(267)%cmp, -2)
  call scale_one_tsum(T0sum(268)%cmp, -2)
  call scale_one_tsum(T0sum(269)%cmp, -2)
  call scale_one_tsum(T0sum(270)%cmp, -2)
  call scale_one_tsum(T0sum(271)%cmp, -2)
  call scale_one_tsum(T0sum(272)%cmp, -2)
  call scale_one_tsum(T0sum(273)%cmp, -2)
  call scale_one_tsum(T0sum(274)%cmp, -2)
  call scale_one_tsum(T0sum(275)%cmp, -2)
  call scale_one_tsum(T0sum(276)%cmp, -2)
  call scale_one_tsum(T0sum(277)%cmp, -2)
  call scale_one_tsum(T0sum(278)%cmp, -2)
  call scale_one_tsum(T0sum(279)%cmp, -2)
  call scale_one_tsum(T0sum(280)%cmp, -2)
  call scale_one_tsum(T0sum(281)%cmp, -2)
  call scale_one_tsum(T0sum(282)%cmp, -2)
  call scale_one_tsum(T0sum(283)%cmp, -2)
  call scale_one_tsum(T0sum(284)%cmp, -2)
  call scale_one_tsum(T0sum(285)%cmp, -2)
  call scale_one_tsum(T0sum(286)%cmp, -2)
  call scale_one_tsum(T0sum(287)%cmp, -2)
  call scale_one_tsum(T0sum(288)%cmp, -2)
  call scale_one_tsum(T0sum(289)%cmp, -2)
  call scale_one_tsum(T0sum(290)%cmp, -2)
  call scale_one_tsum(T0sum(291)%cmp, -2)
  call scale_one_tsum(T0sum(292)%cmp, -2)
  call scale_one_tsum(T0sum(293)%cmp, -2)
  call scale_one_tsum(T0sum(294)%cmp, -2)
  call scale_one_tsum(T0sum(295)%cmp, -2)
  call scale_one_tsum(T0sum(296)%cmp, -2)
  call scale_one_tsum(T0sum(297)%cmp, -2)
  call scale_one_tsum(T0sum(298)%cmp, -2)
  call scale_one_tsum(T0sum(299)%cmp, -2)
  call scale_one_tsum(T0sum(300)%cmp, -2)
  call scale_one_tsum(T0sum(301)%cmp, -2)
  call scale_one_tsum(T0sum(302)%cmp, -2)
  call scale_one_tsum(T0sum(303)%cmp, -2)
  call scale_one_tsum(T0sum(304)%cmp, -2)
  call scale_one_tsum(T0sum(305)%cmp, -2)
  call scale_one_tsum(T0sum(306)%cmp, -2)
  call scale_one_tsum(T0sum(307)%cmp, -2)
  call scale_one_tsum(T0sum(308)%cmp, -2)
  call scale_one_tsum(T0sum(309)%cmp, -2)
  call scale_one_tsum(T0sum(310)%cmp, -2)
  call scale_one_tsum(T0sum(311)%cmp, -2)
  call scale_one_tsum(T0sum(312)%cmp, -2)
  call scale_one_tsum(T0sum(313)%cmp, -2)
  call scale_one_tsum(T0sum(314)%cmp, -2)
  call scale_one_tsum(T0sum(315)%cmp, -2)
  call scale_one_tsum(T0sum(316)%cmp, -2)
  call scale_one_tsum(T0sum(317)%cmp, -2)
  call scale_one_tsum(T0sum(318)%cmp, -2)
  call scale_one_tsum(T0sum(319)%cmp, -2)
  call scale_one_tsum(T0sum(320)%cmp, -2)
  call scale_one_tsum(T0sum(321)%cmp, -2)
  call scale_one_tsum(T0sum(322)%cmp, -2)
  call scale_one_tsum(T0sum(323)%cmp, -2)
  call scale_one_tsum(T0sum(324)%cmp, -2)
  call scale_one_tsum(T0sum(325)%cmp, -2)
  call scale_one_tsum(T0sum(326)%cmp, -2)
  call scale_one_tsum(T0sum(327)%cmp, -2)
  call scale_one_tsum(T0sum(328)%cmp, -2)
  call scale_one_tsum(T0sum(329)%cmp, -2)
  call scale_one_tsum(T0sum(330)%cmp, -2)
  call scale_one_tsum(T0sum(331)%cmp, -2)
  call scale_one_tsum(T0sum(332)%cmp, -2)
  call scale_one_tsum(T0sum(333)%cmp, -2)
  call scale_one_tsum(T0sum(334)%cmp, -2)
  call scale_one_tsum(T0sum(335)%cmp, -2)
  call scale_one_tsum(T0sum(336)%cmp, -2)
  call scale_one_tsum(T0sum(337)%cmp, -2)
  call scale_one_tsum(T0sum(338)%cmp, -2)
  call scale_one_tsum(T0sum(339)%cmp, -2)
  call scale_one_tsum(T0sum(340)%cmp, -2)
  call scale_one_tsum(T0sum(341)%cmp, -2)
  call scale_one_tsum(T0sum(342)%cmp, -2)
  call scale_one_tsum(T0sum(343)%cmp, -2)
  call scale_one_tsum(T0sum(344)%cmp, -2)
  call scale_one_tsum(T0sum(345)%cmp, -2)
  call scale_one_tsum(T0sum(346)%cmp, -2)
  call scale_one_tsum(T0sum(347)%cmp, -2)
  call scale_one_tsum(T0sum(348)%cmp, -4)
  call scale_one_tsum(T0sum(349)%cmp, -4)
  call scale_one_tsum(T0sum(350)%cmp, -4)
  call scale_one_tsum(T0sum(351)%cmp, -4)
  call scale_one_tsum(T0sum(352)%cmp, -4)
  call scale_one_tsum(T0sum(353)%cmp, -4)
  call scale_one_tsum(T0sum(354)%cmp, -4)
  call scale_one_tsum(T0sum(355)%cmp, -4)
  call scale_one_tsum(T0sum(356)%cmp, -4)
  call scale_one_tsum(T0sum(357)%cmp, -4)
  call scale_one_tsum(T0sum(358)%cmp, -4)
  call scale_one_tsum(T0sum(359)%cmp, -4)
  call scale_one_tsum(T0sum(360)%cmp, -4)
  call scale_one_tsum(T0sum(361)%cmp, -4)
  call scale_one_tsum(T0sum(362)%cmp, -4)
  call scale_one_tsum(T0sum(363)%cmp, -4)
  call scale_one_tsum(T0sum(364)%cmp, -4)
  call scale_one_tsum(T0sum(365)%cmp, -4)
  call scale_one_tsum(T0sum(366)%cmp, -4)
  call scale_one_tsum(T0sum(367)%cmp, -4)
  call scale_one_tsum(T0sum(368)%cmp, -4)
  call scale_one_tsum(T0sum(369)%cmp, -4)
  call scale_one_tsum(T0sum(370)%cmp, -4)
  call scale_one_tsum(T0sum(371)%cmp, -4)
  call scale_one_tsum(T0sum(372)%cmp, -4)
  call scale_one_tsum(T0sum(373)%cmp, -4)
  call scale_one_tsum(T0sum(374)%cmp, -4)
  call scale_one_tsum(T0sum(375)%cmp, -4)
  call scale_one_tsum(T0sum(376)%cmp, -4)
  call scale_one_tsum(T0sum(377)%cmp, -4)
  call scale_one_tsum(T0sum(378)%cmp, -4)
  call scale_one_tsum(T0sum(379)%cmp, -4)
  call scale_one_tsum(T0sum(380)%cmp, -4)
  call scale_one_tsum(T0sum(381)%cmp, -4)
  call scale_one_tsum(T0sum(382)%cmp, -4)
  call scale_one_tsum(T0sum(383)%cmp, -4)
  call scale_one_tsum(T0sum(384)%cmp, -4)
  call scale_one_tsum(T0sum(385)%cmp, -4)
  call scale_one_tsum(T0sum(386)%cmp, -4)
  call scale_one_tsum(T0sum(387)%cmp, -4)
  call scale_one_tsum(T0sum(388)%cmp, -4)
  call scale_one_tsum(T0sum(389)%cmp, -4)
  call scale_one_tsum(T0sum(390)%cmp, -4)
  call scale_one_tsum(T0sum(391)%cmp, -4)
  call scale_one_tsum(T0sum(392)%cmp, -4)
  call scale_one_tsum(T0sum(393)%cmp, -4)
  call scale_one_tsum(T0sum(394)%cmp, -4)
  call scale_one_tsum(T0sum(395)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 33, 30 ]
  momenta_4 = [ 34, 29 ]
  momenta_5 = [ 35, 28 ]
  momenta_6 = [ 36, 27 ]
  momenta_7 = [ 37, 26 ]
  momenta_8 = [ 38, 25 ]
  momenta_9 = [ 39, 24 ]
  momenta_10 = [ 40, 23 ]
  momenta_11 = [ 41, 22 ]
  momenta_12 = [ 42, 21 ]
  momenta_13 = [ 43, 20 ]
  momenta_14 = [ 44, 19 ]
  momenta_15 = [ 45, 18 ]
  momenta_16 = [ 46, 17 ]
  momenta_17 = [ 47, 16 ]
  momenta_18 = [ 48, 15 ]
  momenta_19 = [ 49, 14 ]
  momenta_20 = [ 50, 13 ]
  momenta_21 = [ 51, 12 ]
  momenta_22 = [ 52, 11 ]
  momenta_23 = [ 53, 10 ]
  momenta_24 = [ 54, 9 ]
  momenta_25 = [ 55, 8 ]
  momenta_26 = [ 56, 7 ]
  momenta_27 = [ 57, 6 ]
  momenta_28 = [ 58, 5 ]
  momenta_29 = [ 59, 4 ]
  momenta_30 = [ 60, 3 ]
  momenta_31 = [ 61, 2 ]
  momenta_32 = [ 62, 1 ]
  momenta_33 = [ 32, 1, 30 ]
  momenta_34 = [ 32, 2, 29 ]
  momenta_35 = [ 32, 3, 28 ]
  momenta_36 = [ 32, 4, 27 ]
  momenta_37 = [ 32, 5, 26 ]
  momenta_38 = [ 32, 6, 25 ]
  momenta_39 = [ 32, 7, 24 ]
  momenta_40 = [ 32, 8, 23 ]
  momenta_41 = [ 32, 9, 22 ]
  momenta_42 = [ 32, 10, 21 ]
  momenta_43 = [ 32, 11, 20 ]
  momenta_44 = [ 32, 12, 19 ]
  momenta_45 = [ 32, 13, 18 ]
  momenta_46 = [ 32, 14, 17 ]
  momenta_47 = [ 32, 15, 16 ]
  momenta_48 = [ 32, 19, 12 ]
  momenta_49 = [ 32, 20, 11 ]
  momenta_50 = [ 32, 21, 10 ]
  momenta_51 = [ 32, 22, 9 ]
  momenta_52 = [ 32, 23, 8 ]
  momenta_53 = [ 32, 27, 4 ]
  momenta_54 = [ 33, 2, 28 ]
  momenta_55 = [ 33, 4, 26 ]
  momenta_56 = [ 33, 6, 24 ]
  momenta_57 = [ 33, 8, 22 ]
  momenta_58 = [ 33, 10, 20 ]
  momenta_59 = [ 33, 12, 18 ]
  momenta_60 = [ 33, 14, 16 ]
  momenta_61 = [ 33, 18, 12 ]
  momenta_62 = [ 33, 20, 10 ]
  momenta_63 = [ 33, 22, 8 ]
  momenta_64 = [ 33, 26, 4 ]
  momenta_65 = [ 34, 1, 28 ]
  momenta_66 = [ 34, 4, 25 ]
  momenta_67 = [ 34, 5, 24 ]
  momenta_68 = [ 34, 8, 21 ]
  momenta_69 = [ 34, 9, 20 ]
  momenta_70 = [ 34, 12, 17 ]
  momenta_71 = [ 34, 13, 16 ]
  momenta_72 = [ 34, 17, 12 ]
  momenta_73 = [ 34, 20, 9 ]
  momenta_74 = [ 34, 21, 8 ]
  momenta_75 = [ 34, 25, 4 ]
  momenta_76 = [ 35, 4, 24 ]
  momenta_77 = [ 35, 8, 20 ]
  momenta_78 = [ 35, 12, 16 ]
  momenta_79 = [ 35, 16, 12 ]
  momenta_80 = [ 35, 20, 8 ]
  momenta_81 = [ 35, 24, 4 ]
  momenta_82 = [ 36, 1, 26 ]
  momenta_83 = [ 36, 2, 25 ]
  momenta_84 = [ 36, 3, 24 ]
  momenta_85 = [ 36, 8, 19 ]
  momenta_86 = [ 36, 9, 18 ]
  momenta_87 = [ 36, 10, 17 ]
  momenta_88 = [ 36, 11, 16 ]
  momenta_89 = [ 36, 16, 11 ]
  momenta_90 = [ 36, 17, 10 ]
  momenta_91 = [ 36, 18, 9 ]
  momenta_92 = [ 36, 19, 8 ]
  momenta_93 = [ 37, 2, 24 ]
  momenta_94 = [ 37, 8, 18 ]
  momenta_95 = [ 37, 10, 16 ]
  momenta_96 = [ 37, 16, 10 ]
  momenta_97 = [ 37, 18, 8 ]
  momenta_98 = [ 38, 1, 24 ]
  momenta_99 = [ 38, 8, 17 ]
  momenta_100 = [ 38, 9, 16 ]
  momenta_101 = [ 38, 16, 9 ]
  momenta_102 = [ 38, 17, 8 ]
  momenta_103 = [ 39, 8, 16 ]
  momenta_104 = [ 39, 16, 8 ]
  momenta_105 = [ 40, 1, 22 ]
  momenta_106 = [ 40, 2, 21 ]
  momenta_107 = [ 40, 3, 20 ]
  momenta_108 = [ 40, 4, 19 ]
  momenta_109 = [ 40, 5, 18 ]
  momenta_110 = [ 40, 6, 17 ]
  momenta_111 = [ 40, 7, 16 ]
  momenta_112 = [ 40, 19, 4 ]
  momenta_113 = [ 40, 20, 3 ]
  momenta_114 = [ 40, 21, 2 ]
  momenta_115 = [ 40, 22, 1 ]
  momenta_116 = [ 41, 2, 20 ]
  momenta_117 = [ 41, 4, 18 ]
  momenta_118 = [ 41, 6, 16 ]
  momenta_119 = [ 41, 18, 4 ]
  momenta_120 = [ 41, 20, 2 ]
  momenta_121 = [ 42, 1, 20 ]
  momenta_122 = [ 42, 4, 17 ]
  momenta_123 = [ 42, 5, 16 ]
  momenta_124 = [ 42, 17, 4 ]
  momenta_125 = [ 42, 20, 1 ]
  momenta_126 = [ 43, 4, 16 ]
  momenta_127 = [ 43, 16, 4 ]
  momenta_128 = [ 44, 1, 18 ]
  momenta_129 = [ 44, 2, 17 ]
  momenta_130 = [ 44, 3, 16 ]
  momenta_131 = [ 44, 16, 3 ]
  momenta_132 = [ 44, 17, 2 ]
  momenta_133 = [ 44, 18, 1 ]
  momenta_134 = [ 45, 2, 16 ]
  momenta_135 = [ 45, 16, 2 ]
  momenta_136 = [ 46, 1, 16 ]
  momenta_137 = [ 46, 16, 1 ]
  momenta_138 = [ 48, 1, 14 ]
  momenta_139 = [ 48, 2, 13 ]
  momenta_140 = [ 48, 3, 12 ]
  momenta_141 = [ 48, 4, 11 ]
  momenta_142 = [ 48, 5, 10 ]
  momenta_143 = [ 48, 6, 9 ]
  momenta_144 = [ 48, 7, 8 ]
  momenta_145 = [ 48, 8, 7 ]
  momenta_146 = [ 48, 9, 6 ]
  momenta_147 = [ 48, 10, 5 ]
  momenta_148 = [ 48, 11, 4 ]
  momenta_149 = [ 48, 12, 3 ]
  momenta_150 = [ 48, 13, 2 ]
  momenta_151 = [ 48, 14, 1 ]
  momenta_152 = [ 49, 2, 12 ]
  momenta_153 = [ 49, 4, 10 ]
  momenta_154 = [ 49, 6, 8 ]
  momenta_155 = [ 49, 8, 6 ]
  momenta_156 = [ 49, 10, 4 ]
  momenta_157 = [ 49, 12, 2 ]
  momenta_158 = [ 50, 1, 12 ]
  momenta_159 = [ 50, 4, 9 ]
  momenta_160 = [ 50, 5, 8 ]
  momenta_161 = [ 50, 8, 5 ]
  momenta_162 = [ 50, 9, 4 ]
  momenta_163 = [ 50, 12, 1 ]
  momenta_164 = [ 51, 4, 8 ]
  momenta_165 = [ 51, 8, 4 ]
  momenta_166 = [ 52, 1, 10 ]
  momenta_167 = [ 52, 2, 9 ]
  momenta_168 = [ 52, 3, 8 ]
  momenta_169 = [ 52, 8, 3 ]
  momenta_170 = [ 52, 9, 2 ]
  momenta_171 = [ 52, 10, 1 ]
  momenta_172 = [ 53, 2, 8 ]
  momenta_173 = [ 53, 8, 2 ]
  momenta_174 = [ 54, 1, 8 ]
  momenta_175 = [ 54, 8, 1 ]
  momenta_176 = [ 56, 1, 6 ]
  momenta_177 = [ 56, 2, 5 ]
  momenta_178 = [ 56, 3, 4 ]
  momenta_179 = [ 56, 4, 3 ]
  momenta_180 = [ 56, 5, 2 ]
  momenta_181 = [ 56, 6, 1 ]
  momenta_182 = [ 57, 2, 4 ]
  momenta_183 = [ 57, 4, 2 ]
  momenta_184 = [ 58, 1, 4 ]
  momenta_185 = [ 58, 4, 1 ]
  momenta_186 = [ 60, 1, 2 ]
  momenta_187 = [ 60, 2, 1 ]
  momenta_188 = [ 32, 1, 2, 28 ]
  momenta_189 = [ 32, 1, 6, 24 ]
  momenta_190 = [ 32, 1, 10, 20 ]
  momenta_191 = [ 32, 1, 14, 16 ]
  momenta_192 = [ 32, 1, 18, 12 ]
  momenta_193 = [ 32, 1, 22, 8 ]
  momenta_194 = [ 32, 1, 26, 4 ]
  momenta_195 = [ 32, 2, 1, 28 ]
  momenta_196 = [ 32, 2, 5, 24 ]
  momenta_197 = [ 32, 2, 9, 20 ]
  momenta_198 = [ 32, 2, 13, 16 ]
  momenta_199 = [ 32, 2, 17, 12 ]
  momenta_200 = [ 32, 2, 21, 8 ]
  momenta_201 = [ 32, 2, 25, 4 ]
  momenta_202 = [ 32, 3, 4, 24 ]
  momenta_203 = [ 32, 3, 8, 20 ]
  momenta_204 = [ 32, 3, 12, 16 ]
  momenta_205 = [ 32, 3, 16, 12 ]
  momenta_206 = [ 32, 3, 20, 8 ]
  momenta_207 = [ 32, 3, 24, 4 ]
  momenta_208 = [ 32, 4, 1, 26 ]
  momenta_209 = [ 32, 4, 2, 25 ]
  momenta_210 = [ 32, 4, 3, 24 ]
  momenta_211 = [ 32, 4, 8, 19 ]
  momenta_212 = [ 32, 4, 9, 18 ]
  momenta_213 = [ 32, 4, 10, 17 ]
  momenta_214 = [ 32, 4, 11, 16 ]
  momenta_215 = [ 32, 4, 16, 11 ]
  momenta_216 = [ 32, 4, 17, 10 ]
  momenta_217 = [ 32, 4, 18, 9 ]
  momenta_218 = [ 32, 4, 19, 8 ]
  momenta_219 = [ 32, 5, 2, 24 ]
  momenta_220 = [ 32, 5, 10, 16 ]
  momenta_221 = [ 32, 5, 18, 8 ]
  momenta_222 = [ 32, 6, 1, 24 ]
  momenta_223 = [ 32, 6, 9, 16 ]
  momenta_224 = [ 32, 6, 17, 8 ]
  momenta_225 = [ 32, 7, 8, 16 ]
  momenta_226 = [ 32, 7, 16, 8 ]
  momenta_227 = [ 32, 8, 1, 22 ]
  momenta_228 = [ 32, 8, 2, 21 ]
  momenta_229 = [ 32, 8, 3, 20 ]
  momenta_230 = [ 32, 8, 4, 19 ]
  momenta_231 = [ 32, 8, 5, 18 ]
  momenta_232 = [ 32, 8, 6, 17 ]
  momenta_233 = [ 32, 8, 7, 16 ]
  momenta_234 = [ 32, 9, 2, 20 ]
  momenta_235 = [ 32, 9, 6, 16 ]
  momenta_236 = [ 32, 10, 1, 20 ]
  momenta_237 = [ 32, 10, 5, 16 ]
  momenta_238 = [ 32, 11, 4, 16 ]
  momenta_239 = [ 32, 11, 16, 4 ]
  momenta_240 = [ 32, 12, 1, 18 ]
  momenta_241 = [ 32, 12, 2, 17 ]
  momenta_242 = [ 32, 12, 3, 16 ]
  momenta_243 = [ 32, 13, 2, 16 ]
  momenta_244 = [ 32, 14, 1, 16 ]
  momenta_245 = [ 32, 19, 4, 8 ]
  momenta_246 = [ 32, 19, 8, 4 ]
  momenta_247 = [ 32, 20, 1, 10 ]
  momenta_248 = [ 32, 20, 2, 9 ]
  momenta_249 = [ 32, 20, 3, 8 ]
  momenta_250 = [ 32, 21, 2, 8 ]
  momenta_251 = [ 32, 22, 1, 8 ]
  momenta_252 = [ 33, 2, 4, 24 ]
  momenta_253 = [ 33, 2, 8, 20 ]
  momenta_254 = [ 33, 2, 12, 16 ]
  momenta_255 = [ 33, 2, 16, 12 ]
  momenta_256 = [ 33, 2, 20, 8 ]
  momenta_257 = [ 33, 2, 24, 4 ]
  momenta_258 = [ 33, 4, 8, 18 ]
  momenta_259 = [ 33, 4, 16, 10 ]
  momenta_260 = [ 33, 6, 8, 16 ]
  momenta_261 = [ 33, 6, 16, 8 ]
  momenta_262 = [ 33, 8, 4, 18 ]
  momenta_263 = [ 33, 10, 4, 16 ]
  momenta_264 = [ 33, 10, 16, 4 ]
  momenta_265 = [ 33, 18, 4, 8 ]
  momenta_266 = [ 33, 18, 8, 4 ]
  momenta_267 = [ 34, 1, 4, 24 ]
  momenta_268 = [ 34, 1, 8, 20 ]
  momenta_269 = [ 34, 1, 12, 16 ]
  momenta_270 = [ 34, 1, 16, 12 ]
  momenta_271 = [ 34, 1, 20, 8 ]
  momenta_272 = [ 34, 1, 24, 4 ]
  momenta_273 = [ 34, 4, 8, 17 ]
  momenta_274 = [ 34, 4, 16, 9 ]
  momenta_275 = [ 34, 5, 8, 16 ]
  momenta_276 = [ 34, 5, 16, 8 ]
  momenta_277 = [ 34, 8, 4, 17 ]
  momenta_278 = [ 34, 9, 4, 16 ]
  momenta_279 = [ 34, 9, 16, 4 ]
  momenta_280 = [ 34, 17, 4, 8 ]
  momenta_281 = [ 34, 17, 8, 4 ]
  momenta_282 = [ 35, 4, 8, 16 ]
  momenta_283 = [ 35, 4, 16, 8 ]
  momenta_284 = [ 35, 8, 4, 16 ]
  momenta_285 = [ 35, 8, 16, 4 ]
  momenta_286 = [ 35, 16, 4, 8 ]
  momenta_287 = [ 35, 16, 8, 4 ]
  momenta_288 = [ 36, 1, 2, 24 ]
  momenta_289 = [ 36, 1, 10, 16 ]
  momenta_290 = [ 36, 1, 18, 8 ]
  momenta_291 = [ 36, 2, 1, 24 ]
  momenta_292 = [ 36, 2, 9, 16 ]
  momenta_293 = [ 36, 2, 17, 8 ]
  momenta_294 = [ 36, 3, 8, 16 ]
  momenta_295 = [ 36, 3, 16, 8 ]
  momenta_296 = [ 36, 8, 1, 18 ]
  momenta_297 = [ 36, 8, 2, 17 ]
  momenta_298 = [ 36, 8, 3, 16 ]
  momenta_299 = [ 36, 9, 2, 16 ]
  momenta_300 = [ 36, 10, 1, 16 ]
  momenta_301 = [ 36, 16, 1, 10 ]
  momenta_302 = [ 36, 16, 2, 9 ]
  momenta_303 = [ 36, 16, 3, 8 ]
  momenta_304 = [ 36, 17, 2, 8 ]
  momenta_305 = [ 36, 18, 1, 8 ]
  momenta_306 = [ 37, 2, 8, 16 ]
  momenta_307 = [ 37, 2, 16, 8 ]
  momenta_308 = [ 38, 1, 8, 16 ]
  momenta_309 = [ 38, 1, 16, 8 ]
  momenta_310 = [ 40, 1, 2, 20 ]
  momenta_311 = [ 40, 1, 6, 16 ]
  momenta_312 = [ 40, 1, 18, 4 ]
  momenta_313 = [ 40, 2, 1, 20 ]
  momenta_314 = [ 40, 2, 5, 16 ]
  momenta_315 = [ 40, 2, 17, 4 ]
  momenta_316 = [ 40, 3, 4, 16 ]
  momenta_317 = [ 40, 3, 16, 4 ]
  momenta_318 = [ 40, 4, 1, 18 ]
  momenta_319 = [ 40, 4, 2, 17 ]
  momenta_320 = [ 40, 4, 3, 16 ]
  momenta_321 = [ 40, 4, 16, 3 ]
  momenta_322 = [ 40, 4, 17, 2 ]
  momenta_323 = [ 40, 4, 18, 1 ]
  momenta_324 = [ 40, 5, 2, 16 ]
  momenta_325 = [ 40, 6, 1, 16 ]
  momenta_326 = [ 40, 20, 1, 2 ]
  momenta_327 = [ 40, 20, 2, 1 ]
  momenta_328 = [ 41, 2, 4, 16 ]
  momenta_329 = [ 41, 2, 16, 4 ]
  momenta_330 = [ 41, 4, 16, 2 ]
  momenta_331 = [ 42, 1, 4, 16 ]
  momenta_332 = [ 42, 1, 16, 4 ]
  momenta_333 = [ 42, 4, 16, 1 ]
  momenta_334 = [ 44, 1, 2, 16 ]
  momenta_335 = [ 44, 2, 1, 16 ]
  momenta_336 = [ 44, 16, 1, 2 ]
  momenta_337 = [ 44, 16, 2, 1 ]
  momenta_338 = [ 48, 1, 2, 12 ]
  momenta_339 = [ 48, 1, 6, 8 ]
  momenta_340 = [ 48, 1, 10, 4 ]
  momenta_341 = [ 48, 2, 1, 12 ]
  momenta_342 = [ 48, 2, 5, 8 ]
  momenta_343 = [ 48, 2, 9, 4 ]
  momenta_344 = [ 48, 3, 4, 8 ]
  momenta_345 = [ 48, 3, 8, 4 ]
  momenta_346 = [ 48, 4, 1, 10 ]
  momenta_347 = [ 48, 4, 2, 9 ]
  momenta_348 = [ 48, 4, 3, 8 ]
  momenta_349 = [ 48, 4, 8, 3 ]
  momenta_350 = [ 48, 4, 9, 2 ]
  momenta_351 = [ 48, 4, 10, 1 ]
  momenta_352 = [ 48, 5, 2, 8 ]
  momenta_353 = [ 48, 6, 1, 8 ]
  momenta_354 = [ 48, 8, 1, 6 ]
  momenta_355 = [ 48, 8, 2, 5 ]
  momenta_356 = [ 48, 8, 3, 4 ]
  momenta_357 = [ 48, 8, 4, 3 ]
  momenta_358 = [ 48, 8, 5, 2 ]
  momenta_359 = [ 48, 8, 6, 1 ]
  momenta_360 = [ 48, 9, 2, 4 ]
  momenta_361 = [ 48, 10, 1, 4 ]
  momenta_362 = [ 48, 12, 1, 2 ]
  momenta_363 = [ 48, 12, 2, 1 ]
  momenta_364 = [ 49, 2, 4, 8 ]
  momenta_365 = [ 49, 2, 8, 4 ]
  momenta_366 = [ 49, 4, 8, 2 ]
  momenta_367 = [ 49, 8, 4, 2 ]
  momenta_368 = [ 50, 1, 4, 8 ]
  momenta_369 = [ 50, 1, 8, 4 ]
  momenta_370 = [ 50, 4, 8, 1 ]
  momenta_371 = [ 50, 8, 4, 1 ]
  momenta_372 = [ 52, 1, 2, 8 ]
  momenta_373 = [ 52, 2, 1, 8 ]
  momenta_374 = [ 52, 8, 1, 2 ]
  momenta_375 = [ 52, 8, 2, 1 ]
  momenta_376 = [ 56, 1, 2, 4 ]
  momenta_377 = [ 56, 2, 1, 4 ]
  momenta_378 = [ 56, 4, 1, 2 ]
  momenta_379 = [ 56, 4, 2, 1 ]
  momenta_380 = [ 32, 1, 2, 12, 16 ]
  momenta_381 = [ 32, 1, 2, 20, 8 ]
  momenta_382 = [ 32, 1, 2, 24, 4 ]
  momenta_383 = [ 32, 1, 6, 8, 16 ]
  momenta_384 = [ 32, 1, 6, 16, 8 ]
  momenta_385 = [ 32, 1, 10, 4, 16 ]
  momenta_386 = [ 32, 1, 10, 16, 4 ]
  momenta_387 = [ 32, 1, 18, 4, 8 ]
  momenta_388 = [ 32, 1, 18, 8, 4 ]
  momenta_389 = [ 32, 2, 1, 12, 16 ]
  momenta_390 = [ 32, 2, 1, 20, 8 ]
  momenta_391 = [ 32, 2, 1, 24, 4 ]
  momenta_392 = [ 32, 2, 5, 8, 16 ]
  momenta_393 = [ 32, 2, 5, 16, 8 ]
  momenta_394 = [ 32, 2, 9, 4, 16 ]
  momenta_395 = [ 32, 2, 9, 16, 4 ]
  momenta_396 = [ 32, 2, 17, 4, 8 ]
  momenta_397 = [ 32, 2, 17, 8, 4 ]
  momenta_398 = [ 32, 3, 4, 8, 16 ]
  momenta_399 = [ 32, 3, 4, 16, 8 ]
  momenta_400 = [ 32, 3, 8, 4, 16 ]
  momenta_401 = [ 32, 3, 8, 16, 4 ]
  momenta_402 = [ 32, 3, 16, 4, 8 ]
  momenta_403 = [ 32, 3, 16, 8, 4 ]
  momenta_404 = [ 32, 4, 1, 10, 16 ]
  momenta_405 = [ 32, 4, 1, 18, 8 ]
  momenta_406 = [ 32, 4, 2, 9, 16 ]
  momenta_407 = [ 32, 4, 2, 17, 8 ]
  momenta_408 = [ 32, 4, 3, 8, 16 ]
  momenta_409 = [ 32, 4, 3, 16, 8 ]
  momenta_410 = [ 32, 4, 8, 1, 18 ]
  momenta_411 = [ 32, 4, 8, 2, 17 ]
  momenta_412 = [ 32, 4, 8, 3, 16 ]
  momenta_413 = [ 32, 4, 9, 2, 16 ]
  momenta_414 = [ 32, 4, 10, 1, 16 ]
  momenta_415 = [ 32, 4, 16, 1, 10 ]
  momenta_416 = [ 32, 4, 16, 2, 9 ]
  momenta_417 = [ 32, 4, 16, 3, 8 ]
  momenta_418 = [ 32, 4, 17, 2, 8 ]
  momenta_419 = [ 32, 4, 18, 1, 8 ]
  momenta_420 = [ 32, 5, 2, 8, 16 ]
  momenta_421 = [ 32, 5, 2, 16, 8 ]
  momenta_422 = [ 32, 6, 1, 8, 16 ]
  momenta_423 = [ 32, 6, 1, 16, 8 ]
  momenta_424 = [ 32, 8, 1, 6, 16 ]
  momenta_425 = [ 32, 8, 2, 5, 16 ]
  momenta_426 = [ 32, 8, 3, 4, 16 ]
  momenta_427 = [ 32, 8, 4, 1, 18 ]
  momenta_428 = [ 32, 8, 4, 2, 17 ]
  momenta_429 = [ 32, 8, 4, 3, 16 ]
  momenta_430 = [ 32, 8, 5, 2, 16 ]
  momenta_431 = [ 32, 8, 6, 1, 16 ]
  momenta_432 = [ 32, 9, 2, 4, 16 ]
  momenta_433 = [ 32, 10, 1, 4, 16 ]
  momenta_434 = [ 32, 12, 1, 2, 16 ]
  momenta_435 = [ 32, 12, 2, 1, 16 ]
  momenta_436 = [ 32, 20, 1, 2, 8 ]
  momenta_437 = [ 32, 20, 2, 1, 8 ]
  momenta_438 = [ 33, 2, 4, 8, 16 ]
  momenta_439 = [ 33, 2, 4, 16, 8 ]
  momenta_440 = [ 33, 2, 8, 4, 16 ]
  momenta_441 = [ 33, 2, 8, 16, 4 ]
  momenta_442 = [ 33, 2, 16, 4, 8 ]
  momenta_443 = [ 33, 2, 16, 8, 4 ]
  momenta_444 = [ 34, 1, 4, 8, 16 ]
  momenta_445 = [ 34, 1, 4, 16, 8 ]
  momenta_446 = [ 34, 1, 8, 4, 16 ]
  momenta_447 = [ 34, 1, 8, 16, 4 ]
  momenta_448 = [ 34, 1, 16, 4, 8 ]
  momenta_449 = [ 34, 1, 16, 8, 4 ]
  momenta_450 = [ 36, 1, 2, 8, 16 ]
  momenta_451 = [ 36, 1, 2, 16, 8 ]
  momenta_452 = [ 36, 2, 1, 8, 16 ]
  momenta_453 = [ 36, 2, 1, 16, 8 ]
  momenta_454 = [ 36, 8, 1, 2, 16 ]
  momenta_455 = [ 36, 8, 2, 1, 16 ]
  momenta_456 = [ 36, 16, 1, 2, 8 ]
  momenta_457 = [ 36, 16, 2, 1, 8 ]
  momenta_458 = [ 40, 1, 2, 4, 16 ]
  momenta_459 = [ 40, 1, 2, 16, 4 ]
  momenta_460 = [ 40, 2, 1, 4, 16 ]
  momenta_461 = [ 40, 2, 1, 16, 4 ]
  momenta_462 = [ 40, 4, 1, 2, 16 ]
  momenta_463 = [ 40, 4, 2, 1, 16 ]
  momenta_464 = [ 40, 4, 16, 1, 2 ]
  momenta_465 = [ 40, 4, 16, 2, 1 ]
  momenta_466 = [ 48, 1, 2, 4, 8 ]
  momenta_467 = [ 48, 1, 2, 8, 4 ]
  momenta_468 = [ 48, 2, 1, 4, 8 ]
  momenta_469 = [ 48, 2, 1, 8, 4 ]
  momenta_470 = [ 48, 4, 1, 2, 8 ]
  momenta_471 = [ 48, 4, 2, 1, 8 ]
  momenta_472 = [ 48, 4, 8, 1, 2 ]
  momenta_473 = [ 48, 4, 8, 2, 1 ]
  momenta_474 = [ 48, 8, 1, 2, 4 ]
  momenta_475 = [ 48, 8, 2, 1, 4 ]
  momenta_476 = [ 48, 8, 4, 1, 2 ]
  momenta_477 = [ 48, 8, 4, 2, 1 ]
  momenta_478 = [ 32, 1, 2, 4, 8, 16 ]
  momenta_479 = [ 32, 1, 2, 4, 16, 8 ]
  momenta_480 = [ 32, 1, 2, 8, 4, 16 ]
  momenta_481 = [ 32, 1, 2, 8, 16, 4 ]
  momenta_482 = [ 32, 1, 2, 16, 4, 8 ]
  momenta_483 = [ 32, 1, 2, 16, 8, 4 ]
  momenta_484 = [ 32, 2, 1, 4, 8, 16 ]
  momenta_485 = [ 32, 2, 1, 4, 16, 8 ]
  momenta_486 = [ 32, 2, 1, 8, 4, 16 ]
  momenta_487 = [ 32, 2, 1, 8, 16, 4 ]
  momenta_488 = [ 32, 2, 1, 16, 4, 8 ]
  momenta_489 = [ 32, 2, 1, 16, 8, 4 ]
  momenta_490 = [ 32, 4, 1, 2, 8, 16 ]
  momenta_491 = [ 32, 4, 1, 2, 16, 8 ]
  momenta_492 = [ 32, 4, 2, 1, 8, 16 ]
  momenta_493 = [ 32, 4, 2, 1, 16, 8 ]
  momenta_494 = [ 32, 4, 8, 1, 2, 16 ]
  momenta_495 = [ 32, 4, 8, 2, 1, 16 ]
  momenta_496 = [ 32, 4, 16, 1, 2, 8 ]
  momenta_497 = [ 32, 4, 16, 2, 1, 8 ]
  momenta_498 = [ 32, 8, 1, 2, 4, 16 ]
  momenta_499 = [ 32, 8, 2, 1, 4, 16 ]
  momenta_500 = [ 32, 8, 4, 1, 2, 16 ]
  momenta_501 = [ 32, 8, 4, 2, 1, 16 ]

  masses2_1 = [ nME, 0 ]
  masses2_2 = [ 0, nME ]
  masses2_3 = [ nME, nME ]
  masses2_4 = [ nME, 0, nME ]
  masses2_5 = [ nME, nME, 0 ]
  masses2_6 = [ 0, nME, nME ]
  masses2_7 = [ nME, nME, nME ]
  masses2_8 = [ nME, 0, nME, nME ]
  masses2_9 = [ nME, nME, 0, nME ]
  masses2_10 = [ nME, nME, nME, 0 ]
  masses2_11 = [ 0, nME, nME, nME ]
  masses2_12 = [ nME, nME, nME, nME ]
  masses2_13 = [ nME, 0, nME, nME, nME ]
  masses2_14 = [ nME, nME, 0, nME, nME ]
  masses2_15 = [ nME, nME, nME, 0, nME ]
  masses2_16 = [ nME, nME, nME, nME, 0 ]
  masses2_17 = [ nME, nME, nME, nME, nME ]
  masses2_18 = [ nME, nME, 0, nME, nME, nME ]
  masses2_19 = [ nME, nME, nME, 0, nME, nME ]
  masses2_20 = [ nME, nME, nME, nME, 0, nME ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [1, 16, 17, 18, 19, 6, 7, 8, 9, 20, 21, 22, 23, 24, 25]
sbarray_3 = [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40]
sbarray_4 = [41, 42, 3, 43, 44, 45, 7, 46, 47, 10, 48, 49, 13, 14, 50]
sbarray_5 = [41, 51, 17, 52, 53, 45, 7, 46, 47, 20, 54, 55, 23, 24, 56]
sbarray_6 = [57, 58, 28, 59, 60, 61, 32, 62, 63, 35, 64, 65, 38, 39, 66]
sbarray_7 = [67, 68, 69, 70, 71, 72, 73, 74, 75, 10, 76, 77, 78, 79, 53]
sbarray_8 = [80, 81, 82, 83, 84, 85, 86, 87, 88, 20, 89, 90, 91, 92, 5]
sbarray_9 = [93, 94, 95, 83, 96, 97, 98, 87, 99, 35, 89, 100, 91, 101, 5]
sbarray_10 = [102, 103, 104, 105, 106, 85, 107, 108, 109, 110, 111, 112, 113, 114, 71]
sbarray_11 = [115, 116, 117, 105, 118, 97, 119, 108, 120, 121, 111, 122, 113, 123, 71]
sbarray_12 = [124, 68, 125, 126, 127, 72, 128, 129, 130, 10, 76, 77, 131, 132, 19]
sbarray_13 = [133, 81, 134, 135, 136, 85, 137, 138, 139, 20, 89, 90, 140, 141, 44]
sbarray_14 = [142, 143, 104, 144, 145, 72, 107, 146, 147, 110, 148, 149, 113, 114, 136]
sbarray_15 = [150, 151, 152, 144, 153, 154, 155, 146, 156, 157, 148, 158, 113, 159, 136]
sbarray_16 = [160, 94, 161, 135, 162, 97, 163, 138, 164, 35, 89, 100, 140, 165, 44]
sbarray_17 = [166, 167, 117, 168, 169, 170, 119, 171, 172, 121, 173, 174, 113, 123, 162]
sbarray_18 = [175, 176, 152, 168, 177, 178, 155, 171, 179, 157, 173, 180, 113, 159, 162]
sbarray_19 = [102, 181, 182, 183, 184, 85, 107, 108, 109, 185, 186, 187, 188, 189, 127]
sbarray_20 = [115, 190, 191, 183, 192, 97, 119, 108, 120, 193, 186, 194, 188, 195, 127]
sbarray_21 = [142, 196, 182, 197, 198, 72, 107, 146, 147, 185, 199, 200, 188, 189, 84]
sbarray_22 = [150, 201, 202, 197, 203, 154, 155, 146, 156, 204, 199, 205, 188, 206, 84]
sbarray_23 = [166, 207, 191, 208, 209, 170, 119, 171, 172, 193, 210, 211, 188, 195, 96]
sbarray_24 = [175, 212, 202, 208, 213, 178, 155, 171, 179, 204, 210, 214, 188, 206, 96]
sbarray_25 = [215, 216, 217, 218, 15]
sbarray_26 = [219, 216, 220, 221, 25]
sbarray_27 = [222, 223, 224, 225, 40]
sbarray_28 = [226, 227, 228, 218, 50]
sbarray_29 = [229, 227, 230, 221, 56]
sbarray_30 = [231, 232, 233, 225, 66]
sbarray_31 = [234, 235, 236, 237, 53]
sbarray_32 = [57, 238, 239, 240, 5]
sbarray_33 = [1, 2, 3, 4, 5]
sbarray_34 = [241, 242, 243, 244, 71]
sbarray_35 = [67, 68, 69, 70, 71]
sbarray_36 = [245, 246, 236, 247, 19]
sbarray_37 = [26, 248, 239, 249, 44]
sbarray_38 = [250, 251, 252, 244, 136]
sbarray_39 = [133, 81, 134, 135, 136]
sbarray_40 = [41, 42, 3, 43, 44]
sbarray_41 = [253, 254, 255, 70, 162]
sbarray_42 = [160, 94, 161, 135, 162]
sbarray_43 = [256, 242, 257, 258, 127]
sbarray_44 = [124, 68, 125, 126, 127]
sbarray_45 = [259, 251, 260, 258, 84]
sbarray_46 = [80, 81, 82, 83, 84]
sbarray_47 = [261, 254, 262, 126, 96]
sbarray_48 = [93, 94, 95, 83, 96]
sbarray_49 = [1, 6, 7, 8, 9]
sbarray_50 = [2, 6, 10, 11, 12]
sbarray_51 = [3, 7, 10, 13, 14]
sbarray_52 = [1, 16, 17, 18, 19]
sbarray_53 = [16, 6, 20, 21, 22]
sbarray_54 = [17, 7, 20, 23, 24]
sbarray_55 = [26, 27, 28, 29, 30]
sbarray_56 = [26, 31, 32, 33, 34]
sbarray_57 = [27, 31, 35, 36, 37]
sbarray_58 = [28, 32, 35, 38, 39]
sbarray_59 = [41, 45, 7, 46, 47]
sbarray_60 = [42, 45, 10, 48, 49]
sbarray_61 = [41, 51, 17, 52, 53]
sbarray_62 = [51, 45, 20, 54, 55]
sbarray_63 = [57, 58, 28, 59, 60]
sbarray_64 = [57, 61, 32, 62, 63]
sbarray_65 = [58, 61, 35, 64, 65]
sbarray_66 = [67, 72, 73, 74, 75]
sbarray_67 = [68, 72, 10, 76, 77]
sbarray_68 = [69, 73, 10, 78, 79]
sbarray_69 = [80, 85, 86, 87, 88]
sbarray_70 = [81, 85, 20, 89, 90]
sbarray_71 = [82, 86, 20, 91, 92]
sbarray_72 = [93, 97, 98, 87, 99]
sbarray_73 = [94, 97, 35, 89, 100]
sbarray_74 = [95, 98, 35, 91, 101]
sbarray_75 = [102, 103, 104, 105, 106]
sbarray_76 = [102, 85, 107, 108, 109]
sbarray_77 = [103, 85, 110, 111, 112]
sbarray_78 = [104, 107, 110, 113, 114]
sbarray_79 = [115, 116, 117, 105, 118]
sbarray_80 = [115, 97, 119, 108, 120]
sbarray_81 = [116, 97, 121, 111, 122]
sbarray_82 = [117, 119, 121, 113, 123]
sbarray_83 = [124, 72, 128, 129, 130]
sbarray_84 = [125, 128, 10, 131, 132]
sbarray_85 = [133, 85, 137, 138, 139]
sbarray_86 = [134, 137, 20, 140, 141]
sbarray_87 = [142, 143, 104, 144, 145]
sbarray_88 = [142, 72, 107, 146, 147]
sbarray_89 = [143, 72, 110, 148, 149]
sbarray_90 = [150, 151, 152, 144, 153]
sbarray_91 = [150, 154, 155, 146, 156]
sbarray_92 = [151, 154, 157, 148, 158]
sbarray_93 = [152, 155, 157, 113, 159]
sbarray_94 = [160, 97, 163, 138, 164]
sbarray_95 = [161, 163, 35, 140, 165]
sbarray_96 = [166, 167, 117, 168, 169]
sbarray_97 = [166, 170, 119, 171, 172]
sbarray_98 = [167, 170, 121, 173, 174]
sbarray_99 = [175, 176, 152, 168, 177]
sbarray_100 = [175, 178, 155, 171, 179]
sbarray_101 = [176, 178, 157, 173, 180]
sbarray_102 = [102, 181, 182, 183, 184]
sbarray_103 = [181, 85, 185, 186, 187]
sbarray_104 = [182, 107, 185, 188, 189]
sbarray_105 = [115, 190, 191, 183, 192]
sbarray_106 = [190, 97, 193, 186, 194]
sbarray_107 = [191, 119, 193, 188, 195]
sbarray_108 = [142, 196, 182, 197, 198]
sbarray_109 = [196, 72, 185, 199, 200]
sbarray_110 = [150, 201, 202, 197, 203]
sbarray_111 = [201, 154, 204, 199, 205]
sbarray_112 = [202, 155, 204, 188, 206]
sbarray_113 = [166, 207, 191, 208, 209]
sbarray_114 = [207, 170, 193, 210, 211]
sbarray_115 = [175, 212, 202, 208, 213]
sbarray_116 = [212, 178, 204, 210, 214]
sbarray_117 = [29, 33, 36, 38, 40]
sbarray_118 = [59, 62, 64, 38, 66]
sbarray_119 = [43, 46, 48, 13, 50]
sbarray_120 = [52, 46, 54, 23, 56]
sbarray_121 = [4, 8, 11, 13, 15]
sbarray_122 = [18, 8, 21, 23, 25]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_371, masses2_11, T0sum(1), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_357, masses2_12, T0sum(2), M2,[218], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_12, T0sum(3), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_370, masses2_11, T0sum(4), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_349, masses2_12, T0sum(5), M2,[221], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_12, T0sum(6), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_330, masses2_11, T0sum(7), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_321, masses2_12, T0sum(8), M2,[225], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_12, T0sum(9), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_367, masses2_11, T0sum(10), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_366, masses2_11, T0sum(11), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_333, masses2_11, T0sum(12), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_375, masses2_10, T0sum(13), M2,[229], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_355, masses2_10, T0sum(14), M2,[237], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_10, T0sum(15), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_378, masses2_10, T0sum(16), M2,[215], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_346, masses2_10, T0sum(17), M2,[240], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_10, T0sum(18), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_318, masses2_10, T0sum(19), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_377, masses2_9, T0sum(20), M2,[234], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_341, masses2_9, T0sum(21), M2,[244], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_9, T0sum(22), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_313, masses2_9, T0sum(23), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_374, masses2_10, T0sum(24), M2,[219], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_354, masses2_10, T0sum(25), M2,[247], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_10, T0sum(26), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_379, masses2_10, T0sum(27), M2,[226], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_347, masses2_10, T0sum(28), M2,[249], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_10, T0sum(29), M2,[140], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_373, masses2_9, T0sum(30), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_291, masses2_9, T0sum(31), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_319, masses2_10, T0sum(32), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_335, masses2_9, T0sum(33), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_376, masses2_9, T0sum(34), M2,[245], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_338, masses2_9, T0sum(35), M2,[258], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_9, T0sum(36), M2,[188], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_310, masses2_9, T0sum(37), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_372, masses2_9, T0sum(38), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_288, masses2_9, T0sum(39), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_334, masses2_9, T0sum(40), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_362, masses2_10, T0sum(41), M2,[216], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_240, masses2_10, T0sum(42), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_358, masses2_10, T0sum(43), M2,[217], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_231, masses2_10, T0sum(44), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_296, masses2_10, T0sum(45), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_350, masses2_10, T0sum(46), M2,[220], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_10, T0sum(47), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_337, masses2_10, T0sum(48), M2,[222], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_302, masses2_10, T0sum(49), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_327, masses2_10, T0sum(50), M2,[223], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_248, masses2_10, T0sum(51), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_323, masses2_10, T0sum(52), M2,[224], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_10, T0sum(53), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_363, masses2_10, T0sum(54), M2,[227], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_241, masses2_10, T0sum(55), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_359, masses2_10, T0sum(56), M2,[228], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_232, masses2_10, T0sum(57), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_297, masses2_10, T0sum(58), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_351, masses2_10, T0sum(59), M2,[230], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_10, T0sum(60), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_336, masses2_10, T0sum(61), M2,[231], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_301, masses2_10, T0sum(62), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_326, masses2_10, T0sum(63), M2,[232], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_247, masses2_10, T0sum(64), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_322, masses2_10, T0sum(65), M2,[233], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_10, T0sum(66), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_361, masses2_9, T0sum(67), M2,[235], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_236, masses2_9, T0sum(68), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_356, masses2_12, T0sum(69), M2,[236], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_12, T0sum(70), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_352, masses2_9, T0sum(71), M2,[238], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_9, T0sum(72), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_348, masses2_12, T0sum(73), M2,[239], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_12, T0sum(74), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_324, masses2_9, T0sum(75), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_320, masses2_12, T0sum(76), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_368, masses2_8, T0sum(77), M2,[241], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_267, masses2_8, T0sum(78), M2,[105], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_344, masses2_12, T0sum(79), M2,[242], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_12, T0sum(80), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_342, masses2_9, T0sum(81), M2,[243], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_9, T0sum(82), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_331, masses2_8, T0sum(83), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_316, masses2_12, T0sum(84), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_314, masses2_9, T0sum(85), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_360, masses2_9, T0sum(86), M2,[246], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_234, masses2_9, T0sum(87), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_353, masses2_9, T0sum(88), M2,[248], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_9, T0sum(89), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_369, masses2_8, T0sum(90), M2,[250], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_268, masses2_8, T0sum(91), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_345, masses2_12, T0sum(92), M2,[251], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_12, T0sum(93), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_343, masses2_9, T0sum(94), M2,[252], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_9, T0sum(95), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_308, masses2_8, T0sum(96), M2,[133], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_294, masses2_12, T0sum(97), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_292, masses2_9, T0sum(98), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_325, masses2_9, T0sum(99), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_332, masses2_8, T0sum(100), M2,[253], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_270, masses2_8, T0sum(101), M2,[168], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_317, masses2_12, T0sum(102), M2,[254], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_12, T0sum(103), M2,[171], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_315, masses2_9, T0sum(104), M2,[255], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_9, T0sum(105), M2,[173], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_309, masses2_8, T0sum(106), M2,[160], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_295, masses2_12, T0sum(107), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_293, masses2_9, T0sum(108), M2,[161], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_364, masses2_8, T0sum(109), M2,[256], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_252, masses2_8, T0sum(110), M2,[183], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_339, masses2_9, T0sum(111), M2,[257], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_9, T0sum(112), M2,[186], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_328, masses2_8, T0sum(113), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_311, masses2_9, T0sum(114), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_365, masses2_8, T0sum(115), M2,[259], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_253, masses2_8, T0sum(116), M2,[197], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_340, masses2_9, T0sum(117), M2,[260], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_9, T0sum(118), M2,[199], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_306, masses2_8, T0sum(119), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_289, masses2_9, T0sum(120), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_329, masses2_8, T0sum(121), M2,[261], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_255, masses2_8, T0sum(122), M2,[208], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_312, masses2_9, T0sum(123), M2,[262], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_9, T0sum(124), M2,[210], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_307, masses2_8, T0sum(125), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_290, masses2_9, T0sum(126), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_243, masses2_9, T0sum(127), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_242, masses2_12, T0sum(128), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_233, masses2_12, T0sum(129), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_299, masses2_9, T0sum(130), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_298, masses2_12, T0sum(131), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_12, T0sum(132), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_305, masses2_9, T0sum(133), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_303, masses2_12, T0sum(134), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_251, masses2_9, T0sum(135), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_249, masses2_12, T0sum(136), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_12, T0sum(137), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_244, masses2_9, T0sum(138), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_300, masses2_9, T0sum(139), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_304, masses2_9, T0sum(140), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_250, masses2_9, T0sum(141), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_238, masses2_12, T0sum(142), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_237, masses2_9, T0sum(143), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_12, T0sum(144), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_9, T0sum(145), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_12, T0sum(146), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_9, T0sum(147), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_282, masses2_12, T0sum(148), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_275, masses2_8, T0sum(149), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_269, masses2_8, T0sum(150), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_12, T0sum(151), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_9, T0sum(152), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_283, masses2_12, T0sum(153), M2,[115], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_276, masses2_8, T0sum(154), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_271, masses2_8, T0sum(155), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_12, T0sum(156), M2,[119], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_9, T0sum(157), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_235, masses2_9, T0sum(158), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_9, T0sum(159), M2,[137], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_284, masses2_12, T0sum(160), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_278, masses2_8, T0sum(161), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_285, masses2_12, T0sum(162), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_279, masses2_8, T0sum(163), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_272, masses2_8, T0sum(164), M2,[152], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_239, masses2_12, T0sum(165), M2,[154], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_12, T0sum(166), M2,[155], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_9, T0sum(167), M2,[157], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_224, masses2_9, T0sum(168), M2,[163], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_286, masses2_12, T0sum(169), M2,[166], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_280, masses2_8, T0sum(170), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_245, masses2_12, T0sum(171), M2,[170], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_287, masses2_12, T0sum(172), M2,[175], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_281, masses2_8, T0sum(173), M2,[176], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_246, masses2_12, T0sum(174), M2,[178], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_260, masses2_8, T0sum(175), M2,[181], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_254, masses2_8, T0sum(176), M2,[182], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_9, T0sum(177), M2,[185], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_261, masses2_8, T0sum(178), M2,[190], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_256, masses2_8, T0sum(179), M2,[191], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_9, T0sum(180), M2,[193], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_263, masses2_8, T0sum(181), M2,[196], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_264, masses2_8, T0sum(182), M2,[201], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_257, masses2_8, T0sum(183), M2,[202], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_9, T0sum(184), M2,[204], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_265, masses2_8, T0sum(185), M2,[207], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_266, masses2_8, T0sum(186), M2,[212], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_274, masses2_11, T0sum(187), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_259, masses2_11, T0sum(188), M2,[201], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_277, masses2_11, T0sum(189), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_273, masses2_11, T0sum(190), M2,[176], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_258, masses2_11, T0sum(191), M2,[212], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_262, masses2_11, T0sum(192), M2,[207], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_7, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_164, masses2_7, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_126, masses2_7, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_173, masses2_6, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_185, masses2_6, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_187, masses2_5, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_175, masses2_6, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_183, masses2_6, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_186, masses2_5, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_161, masses2_6, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_159, masses2_6, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_117, masses2_6, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_155, masses2_6, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_153, masses2_6, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_122, masses2_6, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_169, masses2_7, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_179, masses2_7, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_177, masses2_5, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_167, masses2_5, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_129, masses2_5, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_176, masses2_5, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_166, masses2_5, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_128, masses2_5, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_163, masses2_6, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_135, masses2_6, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_120, masses2_6, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_157, masses2_6, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_137, masses2_6, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_125, masses2_6, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_171, masses2_5, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_180, masses2_5, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_184, masses2_4, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_178, masses2_7, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_170, masses2_5, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_181, masses2_5, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_174, masses2_4, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_168, masses2_7, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_136, masses2_4, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_130, masses2_7, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_182, masses2_4, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_172, masses2_4, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_134, masses2_4, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_149, masses2_7, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_145, masses2_7, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_108, masses2_7, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_44, masses2_7, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_40, masses2_7, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_141, masses2_7, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_85, masses2_7, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_36, masses2_7, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_131, masses2_7, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_113, masses2_7, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_89, masses2_7, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_49, masses2_7, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_147, masses2_5, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_106, masses2_5, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_42, masses2_5, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_142, masses2_5, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_82, masses2_5, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_37, masses2_5, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_109, masses2_5, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_158, masses2_4, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_140, masses2_7, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_139, masses2_5, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_65, masses2_4, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_35, masses2_7, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_34, masses2_5, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_121, masses2_4, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_107, masses2_7, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_146, masses2_5, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_105, masses2_5, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_41, masses2_5, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_143, masses2_5, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_83, masses2_5, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_38, masses2_5, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_98, masses2_4, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_84, masses2_7, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_110, masses2_5, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_152, masses2_4, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_138, masses2_5, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_54, masses2_4, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_33, masses2_5, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_116, masses2_4, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_93, masses2_4, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_45, masses2_5, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_86, masses2_5, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_91, masses2_5, T0sum(279), M2)
  call TI_call_OL(0,0, momenta_51, masses2_5, T0sum(280), M2)
  call TI_call_OL(0,0, momenta_46, masses2_5, T0sum(281), M2)
  call TI_call_OL(0,0, momenta_87, masses2_5, T0sum(282), M2)
  call TI_call_OL(0,0, momenta_90, masses2_5, T0sum(283), M2)
  call TI_call_OL(0,0, momenta_50, masses2_5, T0sum(284), M2)
  call TI_call_OL(0,0, momenta_43, masses2_7, T0sum(285), M2)
  call TI_call_OL(0,0, momenta_39, masses2_7, T0sum(286), M2)
  call TI_call_OL(0,0, momenta_67, masses2_4, T0sum(287), M2)
  call TI_call_OL(0,0, momenta_69, masses2_4, T0sum(288), M2)
  call TI_call_OL(0,0, momenta_72, masses2_4, T0sum(289), M2)
  call TI_call_OL(0,0, momenta_48, masses2_7, T0sum(290), M2)
  call TI_call_OL(0,0, momenta_56, masses2_4, T0sum(291), M2)
  call TI_call_OL(0,0, momenta_58, masses2_4, T0sum(292), M2)
  call TI_call_OL(0,0, momenta_61, masses2_4, T0sum(293), M2)
  call TI_call_OL(0,0, momenta_76, masses2_7, T0sum(294), M2)
  call TI_call_OL(0,0, momenta_77, masses2_7, T0sum(295), M2)
  call TI_call_OL(0,0, momenta_79, masses2_7, T0sum(296), M2)
  call TI_call_OL(0,0, momenta_66, masses2_6, T0sum(297), M2)
  call TI_call_OL(0,0, momenta_55, masses2_6, T0sum(298), M2)
  call TI_call_OL(0,0, momenta_68, masses2_6, T0sum(299), M2)
  call TI_call_OL(0,0, momenta_57, masses2_6, T0sum(300), M2)
  call TI_call_OL(0,0, momenta_150, masses2_5, T0sum(301), M2)
  call TI_call_OL(0,0, momenta_133, masses2_5, T0sum(302), M2)
  call TI_call_OL(0,0, momenta_115, masses2_5, T0sum(303), M2)
  call TI_call_OL(0,0, momenta_151, masses2_5, T0sum(304), M2)
  call TI_call_OL(0,0, momenta_132, masses2_5, T0sum(305), M2)
  call TI_call_OL(0,0, momenta_114, masses2_5, T0sum(306), M2)
  call TI_call_OL(0,0, momenta_148, masses2_7, T0sum(307), M2)
  call TI_call_OL(0,0, momenta_144, masses2_7, T0sum(308), M2)
  call TI_call_OL(0,0, momenta_111, masses2_7, T0sum(309), M2)
  call TI_call_OL(0,0, momenta_160, masses2_4, T0sum(310), M2)
  call TI_call_OL(0,0, momenta_123, masses2_4, T0sum(311), M2)
  call TI_call_OL(0,0, momenta_162, masses2_4, T0sum(312), M2)
  call TI_call_OL(0,0, momenta_103, masses2_7, T0sum(313), M2)
  call TI_call_OL(0,0, momenta_100, masses2_4, T0sum(314), M2)
  call TI_call_OL(0,0, momenta_88, masses2_7, T0sum(315), M2)
  call TI_call_OL(0,0, momenta_127, masses2_7, T0sum(316), M2)
  call TI_call_OL(0,0, momenta_124, masses2_4, T0sum(317), M2)
  call TI_call_OL(0,0, momenta_112, masses2_7, T0sum(318), M2)
  call TI_call_OL(0,0, momenta_104, masses2_7, T0sum(319), M2)
  call TI_call_OL(0,0, momenta_102, masses2_4, T0sum(320), M2)
  call TI_call_OL(0,0, momenta_92, masses2_7, T0sum(321), M2)
  call TI_call_OL(0,0, momenta_154, masses2_4, T0sum(322), M2)
  call TI_call_OL(0,0, momenta_118, masses2_4, T0sum(323), M2)
  call TI_call_OL(0,0, momenta_156, masses2_4, T0sum(324), M2)
  call TI_call_OL(0,0, momenta_95, masses2_4, T0sum(325), M2)
  call TI_call_OL(0,0, momenta_119, masses2_4, T0sum(326), M2)
  call TI_call_OL(0,0, momenta_97, masses2_4, T0sum(327), M2)
  call TI_call_OL(0,0, momenta_47, masses2_7, T0sum(328), M2)
  call TI_call_OL(0,0, momenta_52, masses2_7, T0sum(329), M2)
  call TI_call_OL(0,0, momenta_78, masses2_7, T0sum(330), M2)
  call TI_call_OL(0,0, momenta_71, masses2_4, T0sum(331), M2)
  call TI_call_OL(0,0, momenta_80, masses2_7, T0sum(332), M2)
  call TI_call_OL(0,0, momenta_74, masses2_4, T0sum(333), M2)
  call TI_call_OL(0,0, momenta_81, masses2_7, T0sum(334), M2)
  call TI_call_OL(0,0, momenta_75, masses2_4, T0sum(335), M2)
  call TI_call_OL(0,0, momenta_53, masses2_7, T0sum(336), M2)
  call TI_call_OL(0,0, momenta_60, masses2_4, T0sum(337), M2)
  call TI_call_OL(0,0, momenta_63, masses2_4, T0sum(338), M2)
  call TI_call_OL(0,0, momenta_64, masses2_4, T0sum(339), M2)
  call TI_call_OL(0,0, momenta_101, masses2_6, T0sum(340), M2)
  call TI_call_OL(0,0, momenta_73, masses2_6, T0sum(341), M2)
  call TI_call_OL(0,0, momenta_96, masses2_6, T0sum(342), M2)
  call TI_call_OL(0,0, momenta_62, masses2_6, T0sum(343), M2)
  call TI_call_OL(0,0, momenta_70, masses2_6, T0sum(344), M2)
  call TI_call_OL(0,0, momenta_99, masses2_6, T0sum(345), M2)
  call TI_call_OL(0,0, momenta_94, masses2_6, T0sum(346), M2)
  call TI_call_OL(0,0, momenta_59, masses2_6, T0sum(347), M2)
  call TI_call_OL(0,0, momenta_25, masses2_3, T0sum(348), M2)
  call TI_call_OL(0,0, momenta_29, masses2_3, T0sum(349), M2)
  call TI_call_OL(0,0, momenta_21, masses2_3, T0sum(350), M2)
  call TI_call_OL(0,0, momenta_1, masses2_1, T0sum(351), M2)
  call TI_call_OL(0,0, momenta_17, masses2_3, T0sum(352), M2)
  call TI_call_OL(0,0, momenta_13, masses2_3, T0sum(353), M2)
  call TI_call_OL(0,0, momenta_31, masses2_2, T0sum(354), M2)
  call TI_call_OL(0,0, momenta_23, masses2_2, T0sum(355), M2)
  call TI_call_OL(0,0, momenta_32, masses2_2, T0sum(356), M2)
  call TI_call_OL(0,0, momenta_28, masses2_2, T0sum(357), M2)
  call TI_call_OL(0,0, momenta_32, masses2_1, T0sum(358), M2)
  call TI_call_OL(0,0, momenta_30, masses2_3, T0sum(359), M2)
  call TI_call_OL(0,0, momenta_24, masses2_2, T0sum(360), M2)
  call TI_call_OL(0,0, momenta_27, masses2_2, T0sum(361), M2)
  call TI_call_OL(0,0, momenta_31, masses2_1, T0sum(362), M2)
  call TI_call_OL(0,0, momenta_20, masses2_2, T0sum(363), M2)
  call TI_call_OL(0,0, momenta_15, masses2_2, T0sum(364), M2)
  call TI_call_OL(0,0, momenta_11, masses2_2, T0sum(365), M2)
  call TI_call_OL(0,0, momenta_19, masses2_2, T0sum(366), M2)
  call TI_call_OL(0,0, momenta_16, masses2_2, T0sum(367), M2)
  call TI_call_OL(0,0, momenta_12, masses2_2, T0sum(368), M2)
  call TI_call_OL(0,0, momenta_22, masses2_3, T0sum(369), M2)
  call TI_call_OL(0,0, momenta_26, masses2_3, T0sum(370), M2)
  call TI_call_OL(0,0, momenta_28, masses2_1, T0sum(371), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(372), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(373), M2)
  call TI_call_OL(0,0, momenta_14, masses2_3, T0sum(374), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(375), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(376), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(377), M2)
  call TI_call_OL(0,0, momenta_18, masses2_3, T0sum(378), M2)
  call TI_call_OL(0,0, momenta_10, masses2_3, T0sum(379), M2)
  call TI_call_OL(0,0, momenta_2, masses2_3, T0sum(380), M2)
  call TI_call_OL(0,0, momenta_6, masses2_3, T0sum(381), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(382), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(383), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(384), M2)
  call TI_call_OL(0,0, momenta_5, masses2_3, T0sum(385), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(386), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(387), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(388), M2)
  call TI_call_OL(0,0, momenta_9, masses2_3, T0sum(389), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(390), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(391), M2)
  call TI_call_OL(0,0, momenta_8, masses2_2, T0sum(392), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(393), M2)
  call TI_call_OL(0,0, momenta_7, masses2_2, T0sum(394), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(395), M2)

  call TI_call_OL(0,1, momenta_500, masses2_20, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_494, masses2_20, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_497, masses2_20, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_501, masses2_20, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_495, masses2_20, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_496, masses2_20, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_499, masses2_19, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_490, masses2_19, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_491, masses2_19, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_484, masses2_18, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_485, masses2_18, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_498, masses2_19, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_492, masses2_19, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_486, masses2_18, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_487, masses2_18, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_493, masses2_19, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_488, masses2_18, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_489, masses2_18, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_478, masses2_18, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_479, masses2_18, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_480, masses2_18, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_481, masses2_18, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_482, masses2_18, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_483, masses2_18, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_476, masses2_16, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_472, masses2_16, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_465, masses2_16, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_477, masses2_16, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_473, masses2_16, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_464, masses2_16, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_475, masses2_15, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_470, masses2_15, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_462, masses2_15, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_468, masses2_14, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_460, masses2_14, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_474, masses2_15, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_471, masses2_15, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_469, masses2_14, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_452, masses2_14, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_463, masses2_15, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_461, masses2_14, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_453, masses2_14, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_466, masses2_14, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_458, masses2_14, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_467, masses2_14, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_450, masses2_14, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_459, masses2_14, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_451, masses2_14, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_434, masses2_15, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_430, masses2_15, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_429, masses2_17, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_454, masses2_15, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_413, masses2_15, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_412, masses2_17, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_457, masses2_15, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_437, masses2_15, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_419, masses2_15, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_417, masses2_17, T1sum(58), M2,sbarray_58, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_435, masses2_15, T1sum(59), M2,sbarray_59, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_431, masses2_15, T1sum(60), M2,sbarray_60, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_455, masses2_15, T1sum(61), M2,sbarray_61, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_414, masses2_15, T1sum(62), M2,sbarray_62, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_456, masses2_15, T1sum(63), M2,sbarray_63, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_436, masses2_15, T1sum(64), M2,sbarray_64, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_418, masses2_15, T1sum(65), M2,sbarray_65, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_433, masses2_14, T1sum(66), M2,sbarray_66, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_426, masses2_17, T1sum(67), M2,sbarray_67, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_425, masses2_15, T1sum(68), M2,sbarray_68, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_420, masses2_14, T1sum(69), M2,sbarray_69, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_408, masses2_17, T1sum(70), M2,sbarray_70, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_404, masses2_15, T1sum(71), M2,sbarray_71, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_421, masses2_14, T1sum(72), M2,sbarray_72, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_409, masses2_17, T1sum(73), M2,sbarray_73, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_405, masses2_15, T1sum(74), M2,sbarray_74, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_444, masses2_13, T1sum(75), M2,sbarray_75, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_398, masses2_17, T1sum(76), M2,sbarray_76, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_392, masses2_14, T1sum(77), M2,sbarray_77, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_389, masses2_14, T1sum(78), M2,sbarray_78, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_445, masses2_13, T1sum(79), M2,sbarray_79, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_399, masses2_17, T1sum(80), M2,sbarray_80, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_393, masses2_14, T1sum(81), M2,sbarray_81, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_390, masses2_14, T1sum(82), M2,sbarray_82, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_432, masses2_14, T1sum(83), M2,sbarray_83, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_424, masses2_15, T1sum(84), M2,sbarray_84, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_422, masses2_14, T1sum(85), M2,sbarray_85, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_406, masses2_15, T1sum(86), M2,sbarray_86, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_446, masses2_13, T1sum(87), M2,sbarray_87, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_400, masses2_17, T1sum(88), M2,sbarray_88, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_394, masses2_14, T1sum(89), M2,sbarray_89, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_447, masses2_13, T1sum(90), M2,sbarray_90, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_401, masses2_17, T1sum(91), M2,sbarray_91, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_395, masses2_14, T1sum(92), M2,sbarray_92, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_391, masses2_14, T1sum(93), M2,sbarray_93, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_423, masses2_14, T1sum(94), M2,sbarray_94, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_407, masses2_15, T1sum(95), M2,sbarray_95, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_448, masses2_13, T1sum(96), M2,sbarray_96, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_402, masses2_17, T1sum(97), M2,sbarray_97, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_396, masses2_14, T1sum(98), M2,sbarray_98, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_449, masses2_13, T1sum(99), M2,sbarray_99, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_403, masses2_17, T1sum(100), M2,sbarray_100, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_397, masses2_14, T1sum(101), M2,sbarray_101, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_438, masses2_13, T1sum(102), M2,sbarray_102, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_383, masses2_14, T1sum(103), M2,sbarray_103, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_380, masses2_14, T1sum(104), M2,sbarray_104, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_439, masses2_13, T1sum(105), M2,sbarray_105, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_384, masses2_14, T1sum(106), M2,sbarray_106, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_381, masses2_14, T1sum(107), M2,sbarray_107, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_440, masses2_13, T1sum(108), M2,sbarray_108, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_385, masses2_14, T1sum(109), M2,sbarray_109, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_441, masses2_13, T1sum(110), M2,sbarray_110, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_386, masses2_14, T1sum(111), M2,sbarray_111, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_382, masses2_14, T1sum(112), M2,sbarray_112, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_442, masses2_13, T1sum(113), M2,sbarray_113, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_387, masses2_14, T1sum(114), M2,sbarray_114, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_443, masses2_13, T1sum(115), M2,sbarray_115, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_388, masses2_14, T1sum(116), M2,sbarray_116, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_416, masses2_16, T1sum(117), M2,sbarray_117, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_415, masses2_16, T1sum(118), M2,sbarray_118, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_428, masses2_16, T1sum(119), M2,sbarray_119, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_411, masses2_16, T1sum(120), M2,sbarray_120, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_427, masses2_16, T1sum(121), M2,sbarray_121, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_410, masses2_16, T1sum(122), M2,sbarray_122, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_eeaa_qed_eexaaaa_1_/**/REALKIND
