
module ol_vamp_1_eeaa_qed_eexaaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeaa_qed_eexaaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeaa_qed_eexaaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeaa_qed_eexaaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_eeaa_qed_eexaaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeaa_qed_eexaaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_qed_eexaaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(24),n2h32(24))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,nME,G2H16(3),n2h16(3))
  call Hloop_AV_Q(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(4),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex4(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(3),40,nME,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),36,nME,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(9),ex3(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,nME,G2H16(7),n2h16(7))
  call Hloop_QV_A(ntryL,G1H32(10),ex3(:),G1H16(3),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),36,nME,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex2(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(13),ex4(:),G1H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),40,nME,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,nME,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,nME,G2H16(11),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(5),36,nME,G2H16(12),n2h16(12))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(10),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(11),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(12),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(4),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(5),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(5),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(3),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(25),G1H16(26),G1H16(27),G1H16(28),16)
  call HG1shiftOLR(G1H16(24),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(8),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(9),n2h8(4))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(29),G1H16(30),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex2(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(33),G1H16(34),G1H16(35),G1H16(36),G1H16(37),G1H16(38),16)
  call HG1shiftOLR(G1H16(34),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(6),mass5set(:,1),  & 
G1H16(39),G1H16(40),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(40),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(11),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(12),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(13),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(14),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(15),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(16),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(17),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(18),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(13),ex3(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(19),n2h8(13))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-16,nME,G2H16(1),n2h16(13))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AV_Q(ntryL,G1H16(16),ex3(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(21),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(22),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(18),ex3(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(23),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(24),n2h8(17))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,nME,G2H16(2),n2h16(14))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AV_Q(ntryL,G1H16(20),ex4(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(26),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(21),ex4(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(27),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(22),ex4(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(28),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(29),n2h8(21))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(24),-8,nME,G2H16(3),n2h16(15))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QV_A(ntryL,G1H16(26),ex5(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(31),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(27),ex5(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(32),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(33),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(34),n2h8(25))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,nME,G2H16(4),n2h16(16))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(36),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(31),ex3(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(37),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(32),ex3(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(38),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(33),ex4(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(39),n2h8(29))
call HGT_OLR(G1H16(34),1,1,16)
call HGT_invQ_OLR(G1H16(34),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(34),-16,nME,G2H16(5),n2h16(17))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(40),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QV_A(ntryL,G1H16(36),ex4(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(41),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(37),ex4(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(42),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(38),ex4(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(43),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H16(39),ex5(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(44),n2h8(33))
call HGT_OLR(G1H16(40),1,1,16)
call HGT_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(40),-8,nME,G2H16(6),n2h16(18))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AV_Q(ntryL,G1H16(42),ex5(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(46),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(47),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(44),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(48),n2h8(36))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(7),mass5set(:,2),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(8),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(8),mass5set(:,2),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(9),mass5set(:,3),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(9),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(10),mass5set(:,2),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(11),mass5set(:,2),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(12),mass5set(:,3),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(12),mass5set(:,3),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),4,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(11),mass5set(:,2),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(13),mass5set(:,3),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(13),mass5set(:,3),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(14),mass5set(:,3),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(14),mass5set(:,3),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(15),mass5set(:,3),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(15),mass5set(:,3),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(16),mass5set(:,3),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(16),mass5set(:,3),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),4,8)
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(23),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(24),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(27),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(29),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(32),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(33),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(34),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(37),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(38),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(42),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(43),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(47),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(48),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(19),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,nME,G2H8(1),n2h8(37))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(21),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(22),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(23),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-16,nME,G2H8(2),n2h8(38))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(25),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(26),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(27),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-8,nME,G2H8(3),n2h8(39))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(29),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(30),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(19),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(31),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,nME,G2H8(4),n2h8(40))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QV_A(ntryL,G1H8(23),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(33),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(24),ex3(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(34),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(35),n2h4(13))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-8,nME,G2H8(5),n2h8(41))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(37),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(38),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(31),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(39),n2h4(16))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-16,nME,G2H8(6),n2h8(42))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(41),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(36),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(42),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(37),ex1(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(43),n2h4(19))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-16,nME,G2H8(7),n2h8(43))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(45),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(46),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(43),ex4(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(47),n2h4(22))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,nME,G2H8(8),n2h8(44))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(47),ex4(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(49),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(48),ex4(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(50),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(51),n2h4(25))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-4,nME,G2H8(9),n2h8(45))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(53),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(54),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(55),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(55),n2h4(28))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-8,nME,G2H8(10),n2h8(46))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G1H8(59),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(57),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(60),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(58),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(59),n2h4(31))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,nME,G2H8(11),n2h8(47))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(61),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(66),ex5(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(62),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(63),n2h4(34))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-4,nME,G2H8(12),n2h8(48))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(65),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(66),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(73),ex3(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(67),n2h4(37))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-16,nME,G2H8(13),n2h8(49))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_AV_Q(ntryL,G1H8(77),ex3(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(69),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(78),ex3(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(70),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(71),n2h4(40))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-8,nME,G2H8(14),n2h8(50))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AV_Q(ntryL,G1H8(83),ex3(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(73),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(74),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(85),ex4(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(75),n2h4(43))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-16,nME,G2H8(15),n2h8(51))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AV_Q(ntryL,G1H8(89),ex4(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(77),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(90),ex4(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(78),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(91),ex4(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(79),n2h4(46))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-4,nME,G2H8(16),n2h8(52))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(81),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(82),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(97),ex5(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(83),n2h4(49))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-8,nME,G2H8(17),n2h8(53))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(101),ex5(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(85),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(102),ex5(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(86),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(87),n2h4(52))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-4,nME,G2H8(18),n2h8(54))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(89),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(90),n2h4(54))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(17),mass5set(:,4),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(18),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(19),mass5set(:,4),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(17),mass5set(:,4),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(18),mass5set(:,4),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(19),mass5set(:,4),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(7),mass5set(:,2),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(20),mass5set(:,2),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(8),mass5set(:,2),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(21),mass5set(:,2),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(8),mass5set(:,2),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(22),mass5set(:,2),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(9),mass5set(:,3),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(23),mass5set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(9),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(24),mass5set(:,3),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(10),mass5set(:,2),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(25),mass5set(:,2),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(11),mass5set(:,2),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(26),mass5set(:,2),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(12),mass5set(:,3),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(23),mass5set(:,3),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),16,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(12),mass5set(:,3),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),4,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(27),mass5set(:,3),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(11),mass5set(:,2),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(28),mass5set(:,2),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(13),mass5set(:,3),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(24),mass5set(:,3),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(13),mass5set(:,3),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(27),mass5set(:,3),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(14),mass5set(:,3),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(29),mass5set(:,3),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(14),mass5set(:,3),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(30),mass5set(:,3),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),8,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(15),mass5set(:,3),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),16,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(29),mass5set(:,3),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(15),mass5set(:,3),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),4,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(31),mass5set(:,3),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),4,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(16),mass5set(:,3),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),8,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(30),mass5set(:,3),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(16),mass5set(:,3),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),4,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(31),mass5set(:,3),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),4,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(211),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(282)])
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nME,G2H4(1),n2h4(55))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(3),n2h2(2))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,nME,G2H4(3),n2h4(56))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(5),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(6),n2h2(4))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-16,nME,G2H4(4),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(8),n2h2(5))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,nME,G2H4(6),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(10),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(25),ex1(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(11),n2h2(7))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(26),-8,nME,G2H4(7),n2h4(59))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(13),n2h2(8))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-8,nME,G2H4(9),n2h4(60))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(36),ex1(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(15),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(16),n2h2(10))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-16,nME,G2H4(10),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(18),n2h2(11))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-16,nME,G2H4(12),n2h4(62))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VQ_A(ntryL,G1H4(48),ex1(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(20),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(21),n2h2(13))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-16,nME,G2H4(13),n2h4(63))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(23),n2h2(14))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,nME,G2H4(15),n2h4(64))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(60),ex1(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(25),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(61),ex2(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(26),n2h2(16))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(62),-8,nME,G2H4(16),n2h4(65))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VA_Q(ntryL,G1H4(67),ex2(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(28),n2h2(17))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-8,nME,G2H4(18),n2h4(66))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VA_Q(ntryL,G1H4(72),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(30),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(73),ex3(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(31),n2h2(19))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,nME,G2H4(19),n2h4(67))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QV_A(ntryL,G1H4(79),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(33),n2h2(20))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-16,nME,G2H4(22),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(35),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(36),n2h2(22))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-16,nME,G2H4(23),n2h4(69))
  call Hloop_QV_A(ntryL,G2H4(23),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AV_Q(ntryL,G1H4(91),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(38),n2h2(23))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(92),-16,nME,G2H4(26),n2h4(70))
  call Hloop_QV_A(ntryL,G2H4(26),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AV_Q(ntryL,G1H4(96),ex4(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(40),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(97),ex5(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(41),n2h2(25))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(98),-8,nME,G2H4(27),n2h4(71))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AV_Q(ntryL,G1H4(103),ex5(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(43),n2h2(26))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-8,nME,G2H4(30),n2h4(72))
  call Hloop_QV_A(ntryL,G2H4(30),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AV_Q(ntryL,G1H4(108),ex5(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(45),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(46),n2h2(28))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(110),-16,nME,G2H4(31),n2h4(73))
  call Hloop_AV_Q(ntryL,G2H4(31),ex5(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QV_A(ntryL,G1H4(115),ex4(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(48),n2h2(29))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-16,nME,G2H4(34),n2h4(74))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QV_A(ntryL,G1H4(120),ex4(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(50),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(121),ex5(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(51),n2h2(31))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(122),-8,nME,G2H4(35),n2h4(75))
  call Hloop_AV_Q(ntryL,G2H4(35),ex4(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QV_A(ntryL,G1H4(127),ex5(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(53),n2h2(32))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(128),-8,nME,G2H4(38),n2h4(76))
  call Hloop_AV_Q(ntryL,G2H4(38),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(132),ex5(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(55),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(133),ex3(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(56),n2h2(34))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-16,nME,G2H4(39),n2h4(77))
  call Hloop_QV_A(ntryL,G2H4(39),ex5(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AV_Q(ntryL,G1H4(139),ex3(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(58),n2h2(35))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-16,nME,G2H4(42),n2h4(78))
  call Hloop_QV_A(ntryL,G2H4(42),ex5(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(144),ex3(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(60),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(145),ex4(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(61),n2h2(37))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-16,nME,G2H4(43),n2h4(79))
  call Hloop_AV_Q(ntryL,G2H4(43),ex5(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(63),n2h2(38))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(152),-16,nME,G2H4(46),n2h4(80))
  call Hloop_AV_Q(ntryL,G2H4(46),ex5(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(156),ex4(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(65),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(157),ex3(:),G1H2(1),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(66),n2h2(40))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(158),-16,nME,G2H4(47),n2h4(81))
  call Hloop_AV_Q(ntryL,G2H4(47),ex5(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(68),n2h2(41))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(164),-16,nME,G2H4(50),n2h4(82))
  call Hloop_AV_Q(ntryL,G2H4(50),ex5(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_QV_A(ntryL,G1H4(168),ex3(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(70),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(71),n2h2(43))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-4,nME,G2H4(51),n2h4(83))
  call Hloop_AV_Q(ntryL,G2H4(51),ex3(:),G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QV_A(ntryL,G1H4(175),ex5(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(73),n2h2(44))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-4,nME,G2H4(54),n2h4(84))
  call Hloop_AV_Q(ntryL,G2H4(54),ex3(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(180),ex5(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(75),n2h2(45))
  call Hloop_QV_A(ntryL,G1H4(181),ex5(:),G1H2(1),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(76),n2h2(46))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-8,nME,G2H4(55),n2h4(85))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QV_A(ntryL,G1H4(187),ex5(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(78),n2h2(47))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-8,nME,G2H4(58),n2h4(86))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QV_A(ntryL,G1H4(192),ex5(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(80),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(193),ex3(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(81),n2h2(49))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-8,nME,G2H4(59),n2h4(87))
  call Hloop_AV_Q(ntryL,G2H4(59),ex4(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(199),ex3(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(83),n2h2(50))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(200),-8,nME,G2H4(62),n2h4(88))
  call Hloop_AV_Q(ntryL,G2H4(62),ex4(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(204),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(85),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(205),ex4(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(86),n2h2(52))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(206),-4,nME,G2H4(63),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(63),ex3(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QV_A(ntryL,G1H4(211),ex4(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(88),n2h2(53))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(212),-4,nME,G2H4(66),n2h4(90))
  call Hloop_AV_Q(ntryL,G2H4(66),ex3(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QV_A(ntryL,G1H4(216),ex4(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(90),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(217),ex4(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(91),n2h2(55))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(218),-16,nME,G2H4(67),n2h4(91))
  call Hloop_QV_A(ntryL,G2H4(67),ex5(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(223),ex4(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(93),n2h2(56))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(224),-16,nME,G2H4(70),n2h4(92))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AV_Q(ntryL,G1H4(228),ex4(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(95),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H4(229),ex5(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(96),n2h2(58))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(230),-8,nME,G2H4(71),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(71),ex4(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AV_Q(ntryL,G1H4(235),ex5(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(98),n2h2(59))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(236),-8,nME,G2H4(74),n2h4(94))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AV_Q(ntryL,G1H4(240),ex5(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(100),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(241),ex3(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(101),n2h2(61))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(242),-16,nME,G2H4(75),n2h4(95))
  call Hloop_QV_A(ntryL,G2H4(75),ex5(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AV_Q(ntryL,G1H4(247),ex3(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(103),n2h2(62))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(248),-16,nME,G2H4(78),n2h4(96))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AV_Q(ntryL,G1H4(252),ex3(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(105),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(253),ex5(:),G1H2(1),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(106),n2h2(64))
call HGT_OLR(G1H4(254),1,1,4)
call HGT_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(254),-4,nME,G2H4(79),n2h4(97))
  call Hloop_QV_A(ntryL,G2H4(79),ex3(:),G2H2(107),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AV_Q(ntryL,G1H4(259),ex5(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(108),n2h2(65))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(260),-4,nME,G2H4(82),n2h4(98))
  call Hloop_QV_A(ntryL,G2H4(82),ex3(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AV_Q(ntryL,G1H4(264),ex5(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(110),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(265),ex3(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(111),n2h2(67))
call HGT_OLR(G1H4(266),1,1,4)
call HGT_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(266),-8,nME,G2H4(83),n2h4(99))
  call Hloop_QV_A(ntryL,G2H4(83),ex4(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AV_Q(ntryL,G1H4(271),ex3(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(113),n2h2(68))
call HGT_OLR(G1H4(272),1,1,4)
call HGT_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(272),-8,nME,G2H4(86),n2h4(100))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AV_Q(ntryL,G1H4(276),ex3(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(115),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(277),ex4(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(116),n2h2(70))
call HGT_OLR(G1H4(278),1,1,4)
call HGT_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(278),-4,nME,G2H4(87),n2h4(101))
  call Hloop_QV_A(ntryL,G2H4(87),ex3(:),G2H2(117),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_AV_Q(ntryL,G1H4(283),ex4(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(118),n2h2(71))
call HGT_OLR(G1H4(284),1,1,4)
call HGT_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(284),-4,nME,G2H4(90),n2h4(102))
  call Hloop_QV_A(ntryL,G2H4(90),ex3(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AV_Q(ntryL,G1H4(288),ex4(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(120),n2h2(72))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(5),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(6),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(7),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(8),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(8),mass5set(:,2),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(9),mass5set(:,3),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(9),mass5set(:,3),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(10),mass5set(:,2),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(11),mass5set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(12),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(12),mass5set(:,3),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(11),mass5set(:,2),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(13),mass5set(:,3),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(13),mass5set(:,3),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(14),mass5set(:,3),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(14),mass5set(:,3),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(15),mass5set(:,3),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(106),RedSet_5(15),mass5set(:,3),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(16),mass5set(:,3),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(16),mass5set(:,3),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),4,2)
  call Hloop_AV_Q(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(1))
  call Hloop_AV_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(2),n2h1(2))
  call Hloop_AV_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(4),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(6),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(8),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(12),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(13),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(18),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(19),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(22),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(36),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(37))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(38),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(39),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(40),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(41),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(42),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(44),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(45),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(46),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(47),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(48),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(8),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(8),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(9),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(9),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(10),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(11),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(12),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(12),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(11),mass5set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(13),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(13),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(14),mass5set(:,3),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(14),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(15),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(15),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(16),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(16),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,5,2,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,2,5,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,5,2,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,8,5,2,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(28))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,2,5,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(29))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,2,5,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(30))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,6,1,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,8,1,6,16],[nME,nME,0,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(32))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,6,1,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,6,1,16],[nME,nME,0,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(34))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,6,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,6,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,9,2,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,2,9,16],[nME,nME,0,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(38))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,16,2,9],[nME,nME,nME,0,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,9,2,16],[nME,nME,0,nME,nME],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,2,9,16,4],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,9,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(18),n2h32(42))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,10,1,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,1,10,16],[nME,nME,0,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(20),n2h32(44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,16,1,10],[nME,nME,nME,0,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,10,1,16],[nME,nME,0,nME,nME],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(22),n2h32(46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,10,16,4],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(23),n2h32(47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,10,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(24),n2h32(48))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,8,4,2,17],[nME,nME,nME,0,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(25),n2h32(49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,2,17,8],[nME,nME,0,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(26),n2h32(50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,8,2,17],[nME,nME,nME,0,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(27),n2h32(51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,17,2,8],[nME,nME,0,nME,nME],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(28),n2h32(52))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,2,17,8,4],[nME,0,nME,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(29),n2h32(53))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,2,17,4,8],[nME,0,nME,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(30),n2h32(54))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,8,4,1,18],[nME,nME,nME,0,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(31),n2h32(55))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,1,18,8],[nME,nME,0,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(32),n2h32(56))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,8,1,18],[nME,nME,nME,0,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(33),n2h32(57))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,4,18,1,8],[nME,nME,0,nME,nME],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(34),n2h32(58))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,18,8,4],[nME,0,nME,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(35),n2h32(59))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,1,18,4,8],[nME,0,nME,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(36),n2h32(60))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[33,2,4,8,16],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,61))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[33,2,4,16,8],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[33,2,8,4,16],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[33,2,8,16,4],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(4),m3h4x16(:,4),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[33,2,16,4,8],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(5),m3h4x16(:,5),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[33,2,16,8,4],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(6),m3h4x16(:,6),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[34,1,4,8,16],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,7),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[34,1,4,16,8],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,8),heltab2x64(:,:,68))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[34,1,8,4,16],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,9),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[34,1,8,16,4],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,10),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[34,1,16,4,8],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(11),m3h4x16(:,11),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[34,1,16,8,4],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,12),heltab2x64(:,:,72))
  call Hloop_AV_Q(ntryL,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(19),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(19),ex4(:),G1H8(2),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(2),44,nME,G2H8(22),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(5),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(5),52,nME,G2H8(23),n2h8(57))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(6),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(6),44,nME,G2H8(24),n2h8(58))
  call Hloop_QV_A(ntryL,G1H16(35),ex4(:),G1H8(7),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(7),44,nME,G2H8(27),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(41),ex5(:),G1H8(8),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(8),52,nME,G2H8(28),n2h8(60))
  call Hloop_AQ_V(ntryL,G1H32(1),wf4(:,3),G1H8(11),m3h4x8(:,1),heltab2x32(:,:,25))
  call Hloop_QV_A(ntryL,G1H32(2),ex4(:),G1H16(5),m3h2x16(:,25),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(5),40,nME,G2H16(7),n2h16(19))
  call Hloop_AQ_V(ntryL,G1H32(3),wf4(:,3),G1H8(12),m3h4x8(:,2),heltab2x32(:,:,27))
  call Hloop_AV_Q(ntryL,G1H32(4),ex4(:),G1H16(6),m3h2x16(:,26),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H16(6),40,nME,G2H16(8),n2h16(20))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(7),m3h2x16(:,27),heltab2x32(:,:,29))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(8),m3h2x16(:,28),heltab2x32(:,:,30))
  call Hloop_QA_V(ntryL,G1H32(7),wf4(:,12),G1H8(13),m3h4x8(:,3),heltab2x32(:,:,31))
  call Hloop_AV_Q(ntryL,G1H32(8),ex4(:),G1H16(9),m3h2x16(:,29),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H16(9),40,nME,G2H16(9),n2h16(21))
  call Hloop_QA_V(ntryL,G1H32(9),wf4(:,12),G1H8(14),m3h4x8(:,4),heltab2x32(:,:,33))
  call Hloop_QV_A(ntryL,G1H32(10),ex4(:),G1H16(10),m3h2x16(:,30),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(10),40,nME,G2H16(10),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H32(11),ex1(:),G1H16(11),m3h2x16(:,31),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(12),m3h2x16(:,32),heltab2x32(:,:,36))
  call Hloop_AQ_V(ntryL,G1H32(13),wf4(:,11),G1H8(17),m3h4x8(:,5),heltab2x32(:,:,37))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(13),m3h2x16(:,33),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(13),36,nME,G2H16(11),n2h16(23))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(14),m3h2x16(:,34),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H16(14),36,nME,G2H16(12),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(16),m3h2x16(:,35),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H16(16),36,nME,G2H16(1),n2h16(25))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(17),m3h2x16(:,36),heltab2x32(:,:,41))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(18),m3h2x16(:,37),heltab2x32(:,:,42))
  call Hloop_QA_V(ntryL,G1H32(19),wf4(:,4),G1H8(18),m3h4x8(:,6),heltab2x32(:,:,43))
  call Hloop_AV_Q(ntryL,G1H32(20),ex3(:),G1H16(1),m3h2x16(:,38),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(2),n2h16(26))
  call Hloop_AV_Q(ntryL,G1H32(21),ex3(:),G1H16(2),m3h2x16(:,39),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H16(2),36,nME,G2H16(3),n2h16(27))
  call Hloop_QV_A(ntryL,G1H32(22),ex3(:),G1H16(20),m3h2x16(:,40),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(20),36,nME,G2H16(4),n2h16(28))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(21),m3h2x16(:,41),heltab2x32(:,:,47))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(22),m3h2x16(:,42),heltab2x32(:,:,48))
  call Hloop_QV_A(ntryL,G1H32(25),ex4(:),G1H16(23),m3h2x16(:,43),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(23),40,nME,G2H16(5),n2h16(29))
  call Hloop_QV_A(ntryL,G1H32(26),ex3(:),G1H16(24),m3h2x16(:,44),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H16(24),36,nME,G2H16(6),n2h16(30))
  call Hloop_QV_A(ntryL,G1H32(27),ex3(:),G1H16(26),m3h2x16(:,45),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(26),36,nME,G2H16(13),n2h16(31))
  call Hloop_AV_Q(ntryL,G1H32(28),ex3(:),G1H16(27),m3h2x16(:,46),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(27),36,nME,G2H16(14),n2h16(32))
  call Hloop_QA_V(ntryL,G1H32(29),ex2(:),G1H16(28),m3h2x16(:,47),heltab2x32(:,:,53))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(3),m3h2x16(:,48),heltab2x32(:,:,54))
  call Hloop_AV_Q(ntryL,G1H32(31),ex4(:),G1H16(4),m3h2x16(:,49),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H16(4),40,nME,G2H16(15),n2h16(33))
  call Hloop_AV_Q(ntryL,G1H32(32),ex3(:),G1H16(30),m3h2x16(:,50),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(30),36,nME,G2H16(16),n2h16(34))
  call Hloop_AV_Q(ntryL,G1H32(33),ex3(:),G1H16(31),m3h2x16(:,51),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(31),36,nME,G2H16(17),n2h16(35))
  call Hloop_QV_A(ntryL,G1H32(34),ex3(:),G1H16(32),m3h2x16(:,52),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H16(32),36,nME,G2H16(18),n2h16(36))
  call Hloop_AQ_V(ntryL,G1H32(35),ex1(:),G1H16(33),m3h2x16(:,53),heltab2x32(:,:,59))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(34),m3h2x16(:,54),heltab2x32(:,:,60))
  call Hloop_VA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(19),n2h8(61))
  call Hloop_VA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(20),n2h8(62))
  call Hloop_VA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(23),n2h8(63))
  call Hloop_VA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(24),n2h8(64))
  call Hloop_VA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(25),n2h8(65))
  call Hloop_VA_Q(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(26),n2h8(66))
  call Hloop_VQ_A(ntryL,G0H16(7),ex1(:),G0H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(29),n2h8(67))
  call Hloop_VQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(30),n2h8(68))
  call Hloop_VQ_A(ntryL,G0H16(9),ex1(:),G0H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(31),n2h8(69))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(32),n2h8(70))
  call Hloop_VQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(35),n2h8(71))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(36),n2h8(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G2H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(105)])
call HGT_OLR(G2H8(20),1,1,8)
call HGT_invQ_OLR(G2H8(20),2,5,8)
call HGT_OLR(G2H8(20),6,15,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(32),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(38),2,8)
  call Hloop_AQ_V(ntryL,G2H8(26),ex1(:),G2H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
call HGT_OLR(G2H8(25),1,1,8)
call HGT_invQ_OLR(G2H8(25),2,5,8)
call HGT_OLR(G2H8(25),6,15,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(33),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(48),2,8)
call HGT_OLR(G2H8(30),1,1,8)
call HGT_invQ_OLR(G2H8(30),2,5,8)
call HGT_OLR(G2H8(30),6,15,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(34),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(56),1,8)
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(3),m3h2x4(:,92),heltab2x8(:,:,92))
call HGT_OLR(G2H8(35),1,1,8)
call HGT_invQ_OLR(G2H8(35),2,5,8)
call HGT_OLR(G2H8(35),6,15,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(35),mass5set(:,1),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(66),1,8)
  call Hloop_QA_V(ntryL,G2H8(41),ex2(:),G2H4(4),m3h2x4(:,93),heltab2x8(:,:,93))
call HGT_OLR(G2H8(40),1,1,8)
call HGT_invQ_OLR(G2H8(40),2,5,8)
call HGT_OLR(G2H8(40),6,15,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(36),mass5set(:,1),  & 
G1H8(73),G1H8(74),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(74),1,8)
call HGT_OLR(G2H8(45),1,1,8)
call HGT_invQ_OLR(G2H8(45),2,5,8)
call HGT_OLR(G2H8(45),6,15,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(37),mass5set(:,1),  & 
G1H8(83),G1H8(84),G1H8(85),G1H8(86),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(84),2,8)
  call Hloop_AQ_V(ntryL,G2H8(46),ex1(:),G2H4(6),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(6),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(6),43,nME,G2H4(7),n2h4(103))
  call Hloop_VQ_A(ntryL,G1H8(18),ex1(:),G1H4(18),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(18),43,nME,G2H4(9),n2h4(104))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(30),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(30),39,nME,G2H4(10),n2h4(105))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(42),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(42),39,nME,G2H4(12),n2h4(106))
  call Hloop_VA_Q(ntryL,G1H8(15),ex2(:),G1H4(54),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(54),39,nME,G2H4(13),n2h4(107))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(66),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(66),39,nME,G2H4(15),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(78),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(78),39,nME,G2H4(16),n2h4(109))
  call Hloop_QV_A(ntryL,G1H8(22),ex3(:),G1H4(90),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(90),39,nME,G2H4(18),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(102),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(102),39,nME,G2H4(19),n2h4(111))
  call Hloop_QV_A(ntryL,G1H8(28),ex3(:),G1H4(114),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(114),39,nME,G2H4(22),n2h4(112))
  call Hloop_VA_Q(ntryL,G1H8(33),ex2(:),G1H4(126),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(126),43,nME,G2H4(23),n2h4(113))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(138),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(138),43,nME,G2H4(26),n2h4(114))
  call Hloop_VQ_A(ntryL,G1H8(39),ex1(:),G1H4(150),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(150),39,nME,G2H4(27),n2h4(115))
  call Hloop_VQ_A(ntryL,G1H8(13),ex1(:),G1H4(162),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(162),39,nME,G2H4(30),n2h4(116))
  call Hloop_QV_A(ntryL,G1H8(31),ex4(:),G1H4(174),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(174),43,nME,G2H4(31),n2h4(117))
  call Hloop_QV_A(ntryL,G1H8(46),ex4(:),G1H4(186),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(186),43,nME,G2H4(34),n2h4(118))
  call Hloop_QV_A(ntryL,G1H8(32),ex4(:),G1H4(198),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(198),43,nME,G2H4(35),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(52),ex4(:),G1H4(210),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(210),43,nME,G2H4(38),n2h4(120))
  call Hloop_VQ_A(ntryL,G1H8(57),ex1(:),G1H4(222),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(222),39,nME,G2H4(39),n2h4(121))
  call Hloop_VQ_A(ntryL,G1H8(14),ex1(:),G1H4(234),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(234),39,nME,G2H4(42),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(35),ex5(:),G1H4(246),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(246),51,nME,G2H4(43),n2h4(123))
  call Hloop_QV_A(ntryL,G1H8(64),ex5(:),G1H4(258),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(258),51,nME,G2H4(46),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(36),ex5(:),G1H4(270),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(270),51,nME,G2H4(47),n2h4(125))
  call Hloop_QV_A(ntryL,G1H8(70),ex5(:),G1H4(282),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(282),51,nME,G2H4(50),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H8(19),ex3(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(51),n2h4(127))
  call Hloop_AV_Q(ntryL,G1H8(76),ex3(:),G1H4(2),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(2),39,nME,G2H4(54),n2h4(128))
  call Hloop_AV_Q(ntryL,G1H8(20),ex3(:),G1H4(7),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(7),39,nME,G2H4(55),n2h4(129))
  call Hloop_AV_Q(ntryL,G1H8(82),ex3(:),G1H4(8),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(8),39,nME,G2H4(58),n2h4(130))
  call Hloop_AV_Q(ntryL,G1H8(23),ex4(:),G1H4(12),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(12),43,nME,G2H4(59),n2h4(131))
  call Hloop_AV_Q(ntryL,G1H8(88),ex4(:),G1H4(13),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(62),n2h4(132))
  call Hloop_AV_Q(ntryL,G1H8(24),ex4(:),G1H4(14),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(14),43,nME,G2H4(63),n2h4(133))
  call Hloop_AV_Q(ntryL,G1H8(94),ex4(:),G1H4(19),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(19),43,nME,G2H4(66),n2h4(134))
  call Hloop_AV_Q(ntryL,G1H8(25),ex5(:),G1H4(20),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(20),51,nME,G2H4(67),n2h4(135))
  call Hloop_AV_Q(ntryL,G1H8(100),ex5(:),G1H4(24),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(24),51,nME,G2H4(70),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H8(26),ex5(:),G1H4(25),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(25),51,nME,G2H4(71),n2h4(137))
  call Hloop_AV_Q(ntryL,G1H8(106),ex5(:),G1H4(26),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(26),51,nME,G2H4(74),n2h4(138))
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(75),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(78),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(79),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_QA_V(ntryL,G2H8(24),ex2(:),G2H4(82),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(83),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(86),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_QA_V(ntryL,G2H16(7),ex2(:),G2H8(29),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G2H16(8),wf4(:,3),G2H4(87),m3h4x4(:,1),heltab2x16(:,:,68))
  call Hloop_VQ_A(ntryL,G1H16(7),wf4(:,3),G1H4(31),m3h4x4(:,2),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(31),39,nME,G2H4(90),n2h4(139))
  call Hloop_VQ_A(ntryL,G1H16(8),wf4(:,3),G1H4(32),m3h4x4(:,3),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(32),39,nME,G2H4(91),n2h4(140))
  call Hloop_AQ_V(ntryL,G2H16(9),ex1(:),G2H8(32),m3h2x8(:,68),heltab2x16(:,:,71))
  call Hloop_QA_V(ntryL,G2H16(10),wf4(:,12),G2H4(92),m3h4x4(:,4),heltab2x16(:,:,72))
  call Hloop_VA_Q(ntryL,G1H16(11),wf4(:,12),G1H4(36),m3h4x4(:,5),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(36),39,nME,G2H4(93),n2h4(141))
  call Hloop_VA_Q(ntryL,G1H16(12),wf4(:,12),G1H4(37),m3h4x4(:,6),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(37),39,nME,G2H4(94),n2h4(142))
  call Hloop_QA_V(ntryL,G2H16(11),ex2(:),G2H8(33),m3h2x8(:,69),heltab2x16(:,:,75))
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(3),mass5set(:,1),  & 
G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(42),16)
  call HG1shiftOLR(G1H16(37),9,16)
  call Hloop_AQ_V(ntryL,G2H16(1),wf4(:,11),G2H4(95),m3h4x4(:,7),heltab2x16(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(17),wf4(:,11),G1H4(38),m3h4x4(:,8),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(38),43,nME,G2H4(96),n2h4(143))
  call Hloop_VQ_A(ntryL,G1H16(18),wf4(:,11),G1H4(43),m3h4x4(:,9),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(43),43,nME,G2H4(97),n2h4(144))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(34),m3h2x8(:,70),heltab2x16(:,:,79))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(6),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(15),G1H16(19),G1H16(25),G1H16(29),16)
  call HG1shiftOLR(G1H16(44),10,16)
  call Hloop_QA_V(ntryL,G2H16(4),wf4(:,4),G2H4(98),m3h4x4(:,10),heltab2x16(:,:,80))
  call Hloop_VA_Q(ntryL,G1H16(21),wf4(:,4),G1H4(44),m3h4x4(:,11),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(44),43,nME,G2H4(99),n2h4(145))
  call Hloop_VA_Q(ntryL,G1H16(22),wf4(:,4),G1H4(48),m3h4x4(:,12),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(48),43,nME,G2H4(100),n2h4(146))
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(4),mass5set(:,1),  & 
G1H16(35),G1H16(41),G1H16(5),G1H16(6),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(41),17,16)
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(37),m3h2x8(:,71),heltab2x16(:,:,83))
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(5),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(16),G1H16(1),G1H16(2),G1H16(20),16)
  call HG1shiftOLR(G1H16(14),17,16)
  call Hloop_AQ_V(ntryL,G2H16(14),wf4(:,14),G2H4(101),m3h4x4(:,13),heltab2x16(:,:,84))
  call Hloop_VQ_A(ntryL,G1H16(28),wf4(:,14),G1H4(49),m3h4x4(:,14),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(49),51,nME,G2H4(102),n2h4(147))
  call Hloop_VQ_A(ntryL,G1H16(3),wf4(:,14),G1H4(50),m3h4x4(:,15),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(50),51,nME,G2H4(103),n2h4(148))
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(1),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(26),G1H16(27),G1H16(4),G1H16(30),16)
  call HG1shiftOLR(G1H16(24),18,16)
  call Hloop_AQ_V(ntryL,G2H16(16),ex1(:),G2H8(38),m3h2x8(:,72),heltab2x16(:,:,87))
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(2),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(7),G1H16(8),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(32),18,16)
  call Hloop_QA_V(ntryL,G2H16(18),wf4(:,6),G2H4(104),m3h4x4(:,16),heltab2x16(:,:,88))
  call Hloop_VA_Q(ntryL,G1H16(33),wf4(:,6),G1H4(55),m3h4x4(:,17),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(55),51,nME,G2H4(105),n2h4(149))
  call Hloop_VA_Q(ntryL,G1H16(34),wf4(:,6),G1H4(56),m3h4x4(:,18),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(56),51,nME,G2H4(106),n2h4(150))
  call Hloop_AV_Q(ntryL,G1H8(37),ex3(:),G1H4(60),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(60),60,nME,G2H4(107),n2h4(151))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-2,nME,G2H8(39),n2h8(73))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(108),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_AV_Q(ntryL,G1H8(42),ex3(:),G1H4(61),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(61),60,nME,G2H4(109),n2h4(152))
  call Hloop_AV_Q(ntryL,G1H8(43),ex3(:),G1H4(62),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(62),60,nME,G2H4(110),n2h4(153))
  call Hloop_AV_Q(ntryL,G1H8(44),ex3(:),G1H4(67),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(67),60,nME,G2H4(111),n2h4(154))
  call Hloop_AV_Q(ntryL,G1H8(47),ex4(:),G1H4(68),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(68),60,nME,G2H4(112),n2h4(155))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-2,nME,G2H8(42),n2h8(74))
  call Hloop_QA_V(ntryL,G2H8(42),ex2(:),G2H4(113),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_AV_Q(ntryL,G1H8(50),ex4(:),G1H4(72),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(72),60,nME,G2H4(114),n2h4(156))
  call Hloop_AV_Q(ntryL,G1H8(53),ex4(:),G1H4(73),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(73),60,nME,G2H4(115),n2h4(157))
  call Hloop_AV_Q(ntryL,G1H8(54),ex4(:),G1H4(74),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(74),60,nME,G2H4(116),n2h4(158))
  call Hloop_QV_A(ntryL,G1H8(55),ex5(:),G1H4(79),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(79),60,nME,G2H4(117),n2h4(159))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-1,nME,G2H8(43),n2h8(75))
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(118),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_QV_A(ntryL,G1H8(60),ex5(:),G1H4(80),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(80),60,nME,G2H4(119),n2h4(160))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(84),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(84),60,nME,G2H4(120),n2h4(161))
  call Hloop_QV_A(ntryL,G1H8(62),ex5(:),G1H4(85),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(85),60,nME,G2H4(121),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(65),ex3(:),G1H4(86),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(86),60,nME,G2H4(122),n2h4(163))
call HGT_OLR(G1H8(66),1,1,8)
call HGT_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(66),-1,nME,G2H8(44),n2h8(76))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(123),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_QV_A(ntryL,G1H8(68),ex3(:),G1H4(91),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(91),60,nME,G2H4(124),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(71),ex3(:),G1H4(92),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(92),60,nME,G2H4(125),n2h4(165))
  call Hloop_QV_A(ntryL,G1H8(72),ex3(:),G1H4(96),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(96),60,nME,G2H4(126),n2h4(166))
  call Hloop_QV_A(ntryL,G1H8(73),ex4(:),G1H4(97),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(97),60,nME,G2H4(127),n2h4(167))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-1,nME,G2H8(47),n2h8(77))
  call Hloop_AQ_V(ntryL,G2H8(47),ex1(:),G2H4(128),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_QV_A(ntryL,G1H8(78),ex4(:),G1H4(98),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(98),60,nME,G2H4(129),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(79),ex4(:),G1H4(103),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(103),60,nME,G2H4(130),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(80),ex4(:),G1H4(104),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(104),60,nME,G2H4(131),n2h4(170))
  call Hloop_AV_Q(ntryL,G1H8(83),ex5(:),G1H4(108),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(108),60,nME,G2H4(132),n2h4(171))
call HGT_OLR(G1H8(84),1,1,8)
call HGT_invQ_OLR(G1H8(84),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(84),-2,nME,G2H8(48),n2h8(78))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(133),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_AV_Q(ntryL,G1H8(86),ex5(:),G1H4(109),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(109),60,nME,G2H4(134),n2h4(172))
  call Hloop_AV_Q(ntryL,G1H8(89),ex5(:),G1H4(110),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(110),60,nME,G2H4(135),n2h4(173))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(115),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(115),60,nME,G2H4(136),n2h4(174))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(91),m3h2x8(:,73),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(91),52,nME,G2H8(1),n2h8(79))
call HGT_OLR(G1H16(37),1,1,16)
call HGT_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(37),-9,nME,G2H16(7),n2h16(37))
  call Hloop_AQ_V(ntryL,G2H16(7),wf4(:,11),G2H4(137),m3h4x4(:,19),heltab2x16(:,:,92))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(92),m3h2x8(:,74),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(92),52,nME,G2H8(2),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(95),m3h2x8(:,75),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(95),52,nME,G2H8(3),n2h8(81))
  call Hloop_QV_A(ntryL,G1H16(42),ex5(:),G1H8(96),m3h2x8(:,76),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(96),52,nME,G2H8(4),n2h8(82))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(97),m3h2x8(:,77),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(97),52,nME,G2H8(5),n2h8(83))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(44),-10,nME,G2H16(8),n2h16(38))
  call Hloop_QA_V(ntryL,G2H16(8),wf4(:,4),G2H4(138),m3h4x4(:,20),heltab2x16(:,:,97))
  call Hloop_AV_Q(ntryL,G1H16(19),ex5(:),G1H8(98),m3h2x8(:,78),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(98),52,nME,G2H8(6),n2h8(84))
  call Hloop_AV_Q(ntryL,G1H16(25),ex5(:),G1H8(101),m3h2x8(:,79),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(101),52,nME,G2H8(7),n2h8(85))
  call Hloop_AV_Q(ntryL,G1H16(29),ex5(:),G1H8(102),m3h2x8(:,80),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(102),52,nME,G2H8(8),n2h8(86))
  call Hloop_QV_A(ntryL,G1H16(35),ex3(:),G1H8(103),m3h2x8(:,81),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(103),44,nME,G2H8(9),n2h8(87))
call HGT_OLR(G1H16(41),1,1,16)
call HGT_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(41),-17,nME,G2H16(9),n2h16(39))
  call Hloop_AQ_V(ntryL,G2H16(9),wf4(:,14),G2H4(139),m3h4x4(:,21),heltab2x16(:,:,102))
  call Hloop_QV_A(ntryL,G1H16(6),ex3(:),G1H8(104),m3h2x8(:,82),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(104),44,nME,G2H8(10),n2h8(88))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(107),m3h2x8(:,83),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(107),44,nME,G2H8(11),n2h8(89))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(108),m3h2x8(:,84),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(108),44,nME,G2H8(12),n2h8(90))
  call Hloop_QV_A(ntryL,G1H16(13),ex4(:),G1H8(1),m3h2x8(:,85),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(13),n2h8(91))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-17,nME,G2H16(10),n2h16(40))
  call Hloop_AQ_V(ntryL,G2H16(10),wf4(:,14),G2H4(140),m3h4x4(:,22),heltab2x16(:,:,107))
  call Hloop_QV_A(ntryL,G1H16(1),ex4(:),G1H8(2),m3h2x8(:,86),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(2),44,nME,G2H8(14),n2h8(92))
  call Hloop_QV_A(ntryL,G1H16(2),ex4(:),G1H8(5),m3h2x8(:,87),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(5),44,nME,G2H8(15),n2h8(93))
  call Hloop_QV_A(ntryL,G1H16(20),ex4(:),G1H8(6),m3h2x8(:,88),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(6),44,nME,G2H8(16),n2h8(94))
  call Hloop_AV_Q(ntryL,G1H16(23),ex3(:),G1H8(7),m3h2x8(:,89),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(7),44,nME,G2H8(17),n2h8(95))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(24),-18,nME,G2H16(11),n2h16(41))
  call Hloop_QA_V(ntryL,G2H16(11),wf4(:,6),G2H4(141),m3h4x4(:,23),heltab2x16(:,:,112))
  call Hloop_AV_Q(ntryL,G1H16(27),ex3(:),G1H8(8),m3h2x8(:,90),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(8),44,nME,G2H8(18),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,91),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(4),44,nME,G2H8(21),n2h8(97))
  call Hloop_AV_Q(ntryL,G1H16(30),ex3(:),G1H8(10),m3h2x8(:,92),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(10),44,nME,G2H8(36),n2h8(98))
  call Hloop_AV_Q(ntryL,G1H16(31),ex4(:),G1H8(16),m3h2x8(:,93),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(16),44,nME,G2H8(20),n2h8(99))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-18,nME,G2H16(12),n2h16(42))
  call Hloop_QA_V(ntryL,G2H16(12),wf4(:,6),G2H4(142),m3h4x4(:,24),heltab2x16(:,:,117))
  call Hloop_AV_Q(ntryL,G1H16(8),ex4(:),G1H8(21),m3h2x8(:,94),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H8(21),44,nME,G2H8(26),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H16(11),ex4(:),G1H8(27),m3h2x8(:,95),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(27),44,nME,G2H8(25),n2h8(101))
  call Hloop_AV_Q(ntryL,G1H16(12),ex4(:),G1H8(34),m3h2x8(:,96),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(34),44,nME,G2H8(30),n2h8(102))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G2H4(8),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(11),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(14),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G2H4(17),G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G1H4(3)])
call HGT_OLR(G2H4(28),1,1,4)
call HGT_invQ_OLR(G2H4(28),2,5,4)
call HGT_OLR(G2H4(28),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(33),G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(75)])
call HGT_OLR(G2H4(36),1,1,4)
call HGT_invQ_OLR(G2H4(36),2,5,4)
call HGT_OLR(G2H4(36),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(37),G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(49),G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(147)])
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(53),G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G1H4(39)])
call HGT_OLR(G2H4(56),1,1,4)
call HGT_invQ_OLR(G2H4(56),2,5,4)
call HGT_OLR(G2H4(56),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G2H4(61),G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(183)])
call HGT_OLR(G2H4(64),1,1,4)
call HGT_invQ_OLR(G2H4(64),2,5,4)
call HGT_OLR(G2H4(64),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(65),G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(69),G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(135)])
call HGT_OLR(G2H4(72),1,1,4)
call HGT_invQ_OLR(G2H4(72),2,5,4)
call HGT_OLR(G2H4(72),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(73),G1H4(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(77),G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(87)])
call HGT_OLR(G2H4(80),1,1,4)
call HGT_invQ_OLR(G2H4(80),2,5,4)
call HGT_OLR(G2H4(80),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(81),G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G2H4(85),G1H4(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(99)])
call HGT_OLR(G2H4(88),1,1,4)
call HGT_invQ_OLR(G2H4(88),2,5,4)
call HGT_OLR(G2H4(88),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(105),[G2H4(89),G1H4(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(16),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(52),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G1H4(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G1H4(280)])
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(38),mass5set(:,2),  & 
G1H4(116),G1H4(120),G1H4(121),G1H4(122),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(120),16,4)
  call Hotf_5pt_reduction(G2H4(95),RedSet_5(39),mass5set(:,2),  & 
G1H4(132),G1H4(133),G1H4(134),G1H4(139),G1H4(140),G1H4(144),4)
  call HG1shiftOLR(G1H4(133),16,4)
  call Hotf_5pt_reduction(G2H4(104),RedSet_5(40),mass5set(:,2),  & 
G1H4(145),G1H4(146),G1H4(151),G1H4(152),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(41),mass5set(:,2),  & 
G1H4(158),G1H4(163),G1H4(164),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(163),16,4)
  call Hotf_5pt_reduction(G2H4(98),RedSet_5(42),mass5set(:,2),  & 
G1H4(175),G1H4(176),G1H4(180),G1H4(181),G1H4(182),G1H4(187),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(101),RedSet_5(43),mass5set(:,2),  & 
G1H4(188),G1H4(192),G1H4(193),G1H4(194),G1H4(199),G1H4(200),4)
  call HG1shiftOLR(G1H4(192),8,4)
call HGT_OLR(G2H4(20),1,1,4)
call HGT_invQ_OLR(G2H4(20),2,5,4)
call HGT_OLR(G2H4(20),6,15,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(44),mass5set(:,2),  & 
G1H4(204),G1H4(205),G1H4(206),G1H4(211),G1H4(212),G1H4(216),4)
  call HG1shiftOLR(G1H4(205),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(45),mass5set(:,4),  & 
G1H4(217),G1H4(218),G1H4(223),G1H4(224),G1H4(228),G1H4(229),4)
  call HG1shiftOLR(G1H4(218),16,4)
call HGT_OLR(G2H4(24),1,1,4)
call HGT_invQ_OLR(G2H4(24),2,5,4)
call HGT_OLR(G2H4(24),6,15,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(46),mass5set(:,2),  & 
G1H4(230),G1H4(235),G1H4(236),G1H4(240),G1H4(241),G1H4(242),4)
  call HG1shiftOLR(G1H4(235),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(47),mass5set(:,4),  & 
G1H4(247),G1H4(248),G1H4(252),G1H4(253),G1H4(254),G1H4(259),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(48),mass5set(:,2),  & 
G1H4(260),G1H4(264),G1H4(265),G1H4(266),G1H4(271),G1H4(272),4)
  call HG1shiftOLR(G1H4(264),16,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(49),mass5set(:,4),  & 
G1H4(276),G1H4(277),G1H4(278),G1H4(283),G1H4(284),G1H4(288),4)
  call HG1shiftOLR(G1H4(277),8,4)
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(50),mass5set(:,3),  & 
G1H4(6),G1H4(18),G1H4(30),G1H4(42),G1H4(54),G1H4(66),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(51),mass5set(:,3),  & 
G1H4(78),G1H4(90),G1H4(102),G1H4(114),G1H4(126),G1H4(138),4)
  call HG1shiftOLR(G1H4(90),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(52),mass5set(:,3),  & 
G1H4(150),G1H4(162),G1H4(174),G1H4(186),G1H4(198),G1H4(210),4)
  call HG1shiftOLR(G1H4(162),16,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(53),mass5set(:,3),  & 
G1H4(222),G1H4(234),G1H4(246),G1H4(258),G1H4(270),G1H4(282),4)
  call HG1shiftOLR(G1H4(234),8,4)
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(54),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(7),G1H4(8),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(45),mass5set(:,4),  & 
G1H4(14),G1H4(19),G1H4(20),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(19),16,4)
call HGT_OLR(G2H4(44),1,1,4)
call HGT_invQ_OLR(G2H4(44),2,5,4)
call HGT_OLR(G2H4(44),6,15,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(55),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(36),G1H4(37),G1H4(38),G1H4(43),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(47),mass5set(:,4),  & 
G1H4(44),G1H4(48),G1H4(49),G1H4(50),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(48),16,4)
call HGT_OLR(G2H4(48),1,1,4)
call HGT_invQ_OLR(G2H4(48),2,5,4)
call HGT_OLR(G2H4(48),6,15,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(56),mass5set(:,3),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(67),G1H4(68),G1H4(72),4)
  call HG1shiftOLR(G1H4(61),4,4)
  call Hotf_5pt_reduction(G2H4(97),RedSet_5(57),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(79),G1H4(80),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(58),mass5set(:,3),  & 
G1H4(86),G1H4(91),G1H4(92),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(91),16,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(59),mass5set(:,3),  & 
G1H4(103),G1H4(104),G1H4(108),G1H4(109),G1H4(110),G1H4(115),4)
  call HG1shiftOLR(G1H4(104),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(60),mass5set(:,2),  & 
G1H4(5),G1H4(17),G1H4(29),G1H4(41),G1H4(53),G1H4(65),4)
  call HG1shiftOLR(G1H4(17),16,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(49),mass5set(:,4),  & 
G1H4(77),G1H4(89),G1H4(3),G1H4(101),G1H4(113),G1H4(75),4)
  call HG1shiftOLR(G1H4(89),8,4)
call HGT_OLR(G2H4(60),1,1,4)
call HGT_invQ_OLR(G2H4(60),2,5,4)
call HGT_OLR(G2H4(60),6,15,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(61),mass5set(:,3),  & 
G1H4(125),G1H4(137),G1H4(149),G1H4(161),G1H4(147),G1H4(173),4)
  call HG1shiftOLR(G1H4(137),4,4)
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(62),mass5set(:,3),  & 
G1H4(39),G1H4(185),G1H4(197),G1H4(183),G1H4(209),G1H4(221),4)
  call HG1shiftOLR(G1H4(185),8,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(63),mass5set(:,3),  & 
G1H4(135),G1H4(233),G1H4(245),G1H4(87),G1H4(257),G1H4(269),4)
  call HG1shiftOLR(G1H4(233),8,4)
  call Hotf_5pt_reduction(G2H4(102),RedSet_5(64),mass5set(:,3),  & 
G1H4(99),G1H4(281),G1H4(16),G1H4(4),G1H4(10),G1H4(15),4)
  call HG1shiftOLR(G1H4(281),4,4)
call HGT_OLR(G2H4(68),1,1,4)
call HGT_invQ_OLR(G2H4(68),2,5,4)
call HGT_OLR(G2H4(68),6,15,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(65),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(52),G1H4(40),G1H4(46),G1H4(51),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(66),mass5set(:,3),  & 
G1H4(63),G1H4(64),G1H4(76),G1H4(88),G1H4(100),G1H4(111),4)
  call HG1shiftOLR(G1H4(64),16,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(67),mass5set(:,3),  & 
G1H4(112),G1H4(123),G1H4(124),G1H4(136),G1H4(148),G1H4(159),4)
  call HG1shiftOLR(G1H4(123),16,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(68),mass5set(:,3),  & 
G1H4(160),G1H4(171),G1H4(172),G1H4(184),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(171),8,4)
call HGT_OLR(G2H4(76),1,1,4)
call HGT_invQ_OLR(G2H4(76),2,5,4)
call HGT_OLR(G2H4(76),6,15,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(69),mass5set(:,3),  & 
G1H4(207),G1H4(208),G1H4(219),G1H4(220),G1H4(231),G1H4(232),4)
  call HG1shiftOLR(G1H4(208),4,4)
  call Hotf_5pt_reduction(G2H4(100),RedSet_5(70),mass5set(:,3),  & 
G1H4(243),G1H4(244),G1H4(255),G1H4(256),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(244),16,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(71),mass5set(:,3),  & 
G1H4(279),G1H4(280),G1H4(289),G1H4(290),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(280),16,4)
  call Hotf_5pt_reduction(G2H4(99),RedSet_5(72),mass5set(:,3),  & 
G1H4(293),G1H4(294),G1H4(295),G1H4(296),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(294),4,4)
call HGT_OLR(G2H4(84),1,1,4)
call HGT_invQ_OLR(G2H4(84),2,5,4)
call HGT_OLR(G2H4(84),6,15,4)
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(73),mass5set(:,3),  & 
G1H4(299),G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(300),4,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(74),mass5set(:,3),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),8,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(75),mass5set(:,3),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),8,4)
  call Hotf_5pt_reduction(G2H4(105),RedSet_5(76),mass5set(:,3),  & 
G1H4(317),G1H4(318),G1H4(319),G1H4(320),G1H4(321),G1H4(322),4)
  call HG1shiftOLR(G1H4(318),4,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(77),mass5set(:,2),  & 
G1H4(323),G1H4(324),G1H4(325),G1H4(326),G1H4(327),G1H4(328),4)
  call HG1shiftOLR(G1H4(324),16,4)
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(1),n2h2(73))
  call Hloop_VA_Q(ntryL,G1H4(22),ex2(:),G1H2(2),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(6),n2h2(74))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(7),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(11),n2h2(75))
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(78),mass5set(:,2),  & 
G1H4(9),G1H4(22),G1H4(11),G1H4(329),G1H4(330),G1H4(331),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(8),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(16),n2h2(76))
  call Hloop_VA_Q(ntryL,G1H4(23),ex2(:),G1H2(13),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(21),n2h2(77))
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(79),mass5set(:,2),  & 
G1H4(21),G1H4(23),G1H4(332),G1H4(333),G1H4(334),G1H4(335),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(80),mass5set(:,2),  & 
G1H4(336),G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),4)
  call HG1shiftOLR(G1H4(337),8,4)
  call Hloop_VQ_A(ntryL,G1H4(33),ex1(:),G1H2(14),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(14),55,nME,G2H2(26),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(34),ex1(:),G1H2(19),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(19),55,nME,G2H2(31),n2h2(79))
  call Hloop_VQ_A(ntryL,G1H4(35),ex1(:),G1H2(20),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(20),55,nME,G2H2(36),n2h2(80))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(81),mass5set(:,2),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(342),G1H4(343),G1H4(344),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(25),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(25),47,nME,G2H2(41),n2h2(81))
  call Hloop_VQ_A(ntryL,G1H4(58),ex1(:),G1H2(26),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(26),47,nME,G2H2(46),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(47),ex1(:),G1H2(31),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(31),47,nME,G2H2(51),n2h2(83))
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(82),mass5set(:,2),  & 
G1H4(45),G1H4(58),G1H4(47),G1H4(345),G1H4(346),G1H4(347),4)
  call HG1shiftOLR(G1H4(58),16,4)
  call Hloop_VQ_A(ntryL,G1H4(57),ex1(:),G1H2(32),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(32),47,nME,G2H2(56),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(59),ex1(:),G1H2(37),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(37),47,nME,G2H2(61),n2h2(85))
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(83),mass5set(:,2),  & 
G1H4(57),G1H4(59),G1H4(348),G1H4(349),G1H4(350),G1H4(351),4)
  call HG1shiftOLR(G1H4(59),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(84),mass5set(:,2),  & 
G1H4(352),G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),4)
  call HG1shiftOLR(G1H4(353),8,4)
  call Hloop_VA_Q(ntryL,G1H4(69),ex2(:),G1H2(38),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(38),55,nME,G2H2(66),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(70),ex2(:),G1H2(43),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(43),55,nME,G2H2(71),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(71),ex2(:),G1H2(44),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(44),55,nME,G2H2(76),n2h2(88))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(85),mass5set(:,3),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(70),16,4)
  call Hloop_QV_A(ntryL,G1H4(81),ex3(:),G1H2(49),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(81),n2h2(89))
  call Hloop_QV_A(ntryL,G1H4(82),ex3(:),G1H2(50),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(86),n2h2(90))
  call Hloop_QV_A(ntryL,G1H4(83),ex3(:),G1H2(55),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(55),47,nME,G2H2(91),n2h2(91))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(86),mass5set(:,3),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(361),G1H4(362),G1H4(363),4)
  call HG1shiftOLR(G1H4(82),16,4)
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(56),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(56),47,nME,G2H2(96),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H4(94),ex4(:),G1H2(61),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(61),47,nME,G2H2(101),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(95),ex4(:),G1H2(62),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(62),47,nME,G2H2(106),n2h2(94))
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(87),mass5set(:,3),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(94),8,4)
  call Hloop_AV_Q(ntryL,G1H4(105),ex5(:),G1H2(67),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(67),55,nME,G2H2(111),n2h2(95))
  call Hloop_AV_Q(ntryL,G1H4(106),ex5(:),G1H2(68),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(68),55,nME,G2H2(116),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H4(107),ex5(:),G1H2(73),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(73),55,nME,G2H2(121),n2h2(97))
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(88),mass5set(:,5),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(367),G1H4(368),G1H4(369),4)
  call HG1shiftOLR(G1H4(106),16,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(89),mass5set(:,4),  & 
G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),G1H4(375),4)
  call HG1shiftOLR(G1H4(371),16,4)
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(74),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(74),47,nME,G2H2(122),n2h2(98))
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(79),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(79),47,nME,G2H2(123),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(119),ex4(:),G1H2(80),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(80),47,nME,G2H2(124),n2h2(100))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(90),mass5set(:,5),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(118),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(91),mass5set(:,4),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),8,4)
  call Hloop_QV_A(ntryL,G1H4(129),ex5(:),G1H2(85),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(85),55,nME,G2H2(125),n2h2(101))
  call Hloop_QV_A(ntryL,G1H4(130),ex5(:),G1H2(86),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(86),55,nME,G2H2(126),n2h2(102))
  call Hloop_QV_A(ntryL,G1H4(131),ex5(:),G1H2(91),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(91),55,nME,G2H2(127),n2h2(103))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(92),mass5set(:,3),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(385),G1H4(386),G1H4(387),4)
  call HG1shiftOLR(G1H4(130),16,4)
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(92),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(128),n2h2(104))
  call Hloop_AV_Q(ntryL,G1H4(142),ex3(:),G1H2(97),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(97),47,nME,G2H2(129),n2h2(105))
  call Hloop_AV_Q(ntryL,G1H4(143),ex3(:),G1H2(98),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(98),47,nME,G2H2(130),n2h2(106))
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(93),mass5set(:,3),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(142),16,4)
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(103),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(103),47,nME,G2H2(131),n2h2(107))
  call Hloop_QV_A(ntryL,G1H4(154),ex4(:),G1H2(104),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(104),47,nME,G2H2(132),n2h2(108))
  call Hloop_QV_A(ntryL,G1H4(155),ex4(:),G1H2(109),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(109),47,nME,G2H2(133),n2h2(109))
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(94),mass5set(:,5),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(391),G1H4(392),G1H4(393),4)
  call HG1shiftOLR(G1H4(154),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(95),mass5set(:,4),  & 
G1H4(394),G1H4(395),G1H4(396),G1H4(397),G1H4(398),G1H4(399),4)
  call HG1shiftOLR(G1H4(395),16,4)
  call Hloop_QV_A(ntryL,G1H4(165),ex3(:),G1H2(110),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(110),47,nME,G2H2(134),n2h2(110))
  call Hloop_QV_A(ntryL,G1H4(166),ex3(:),G1H2(115),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(115),47,nME,G2H2(135),n2h2(111))
  call Hloop_QV_A(ntryL,G1H4(167),ex3(:),G1H2(116),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(116),47,nME,G2H2(136),n2h2(112))
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(96),mass5set(:,5),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(400),G1H4(401),G1H4(402),4)
  call HG1shiftOLR(G1H4(166),4,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(97),mass5set(:,4),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),4,4)
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(121),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(121),59,nME,G2H2(137),n2h2(113))
  call Hloop_QV_A(ntryL,G1H4(178),ex5(:),G1H2(122),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_Q_A(ntryL,G1H2(122),59,nME,G2H2(138),n2h2(114))
  call Hloop_QV_A(ntryL,G1H4(179),ex5(:),G1H2(127),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(127),59,nME,G2H2(139),n2h2(115))
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(98),mass5set(:,3),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(409),G1H4(410),G1H4(411),4)
  call HG1shiftOLR(G1H4(178),8,4)
  call Hloop_QV_A(ntryL,G1H4(189),ex5(:),G1H2(128),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(128),55,nME,G2H2(140),n2h2(116))
  call Hloop_QV_A(ntryL,G1H4(190),ex5(:),G1H2(133),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(133),55,nME,G2H2(141),n2h2(117))
  call Hloop_QV_A(ntryL,G1H4(191),ex5(:),G1H2(134),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(134),55,nME,G2H2(142),n2h2(118))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(99),mass5set(:,5),  & 
G1H4(189),G1H4(190),G1H4(191),G1H4(412),G1H4(413),G1H4(414),4)
  call HG1shiftOLR(G1H4(190),8,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(100),mass5set(:,4),  & 
G1H4(415),G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(416),8,4)
  call Hloop_QV_A(ntryL,G1H4(201),ex3(:),G1H2(139),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(139),55,nME,G2H2(143),n2h2(119))
  call Hloop_QV_A(ntryL,G1H4(202),ex3(:),G1H2(140),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(140),55,nME,G2H2(144),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(203),ex3(:),G1H2(1),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(145),n2h2(121))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(101),mass5set(:,5),  & 
G1H4(201),G1H4(202),G1H4(203),G1H4(421),G1H4(422),G1H4(423),4)
  call HG1shiftOLR(G1H4(202),4,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(102),mass5set(:,4),  & 
G1H4(424),G1H4(425),G1H4(426),G1H4(427),G1H4(428),G1H4(429),4)
  call HG1shiftOLR(G1H4(425),4,4)
  call Hloop_QV_A(ntryL,G1H4(213),ex4(:),G1H2(2),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(2),59,nME,G2H2(146),n2h2(122))
  call Hloop_QV_A(ntryL,G1H4(214),ex4(:),G1H2(7),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(7),59,nME,G2H2(147),n2h2(123))
  call Hloop_QV_A(ntryL,G1H4(215),ex4(:),G1H2(8),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(8),59,nME,G2H2(148),n2h2(124))
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(103),mass5set(:,5),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(214),16,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(89),mass5set(:,4),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),16,4)
  call Hloop_AV_Q(ntryL,G1H4(225),ex4(:),G1H2(13),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(149),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H4(226),ex4(:),G1H2(14),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(150),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H4(227),ex4(:),G1H2(19),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(19),47,nME,G2H2(151),n2h2(127))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(104),mass5set(:,5),  & 
G1H4(225),G1H4(226),G1H4(227),G1H4(439),G1H4(440),G1H4(441),4)
  call HG1shiftOLR(G1H4(226),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(91),mass5set(:,4),  & 
G1H4(442),G1H4(443),G1H4(444),G1H4(445),G1H4(446),G1H4(447),4)
  call HG1shiftOLR(G1H4(443),8,4)
  call Hloop_AV_Q(ntryL,G1H4(237),ex5(:),G1H2(20),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(20),55,nME,G2H2(152),n2h2(128))
  call Hloop_AV_Q(ntryL,G1H4(238),ex5(:),G1H2(25),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(25),55,nME,G2H2(153),n2h2(129))
  call Hloop_AV_Q(ntryL,G1H4(239),ex5(:),G1H2(26),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(26),55,nME,G2H2(154),n2h2(130))
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(105),mass5set(:,5),  & 
G1H4(237),G1H4(238),G1H4(239),G1H4(448),G1H4(449),G1H4(450),4)
  call HG1shiftOLR(G1H4(238),16,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(95),mass5set(:,4),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),16,4)
  call Hloop_AV_Q(ntryL,G1H4(249),ex3(:),G1H2(31),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(31),47,nME,G2H2(155),n2h2(131))
  call Hloop_AV_Q(ntryL,G1H4(250),ex3(:),G1H2(32),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(32),47,nME,G2H2(156),n2h2(132))
  call Hloop_AV_Q(ntryL,G1H4(251),ex3(:),G1H2(37),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(37),47,nME,G2H2(157),n2h2(133))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(106),mass5set(:,5),  & 
G1H4(249),G1H4(250),G1H4(251),G1H4(457),G1H4(458),G1H4(459),4)
  call HG1shiftOLR(G1H4(250),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(97),mass5set(:,4),  & 
G1H4(460),G1H4(461),G1H4(462),G1H4(463),G1H4(464),G1H4(465),4)
  call HG1shiftOLR(G1H4(461),4,4)
  call Hloop_AV_Q(ntryL,G1H4(261),ex5(:),G1H2(38),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(38),59,nME,G2H2(158),n2h2(134))
  call Hloop_AV_Q(ntryL,G1H4(262),ex5(:),G1H2(43),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_A_Q(ntryL,G1H2(43),59,nME,G2H2(159),n2h2(135))
  call Hloop_AV_Q(ntryL,G1H4(263),ex5(:),G1H2(44),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(44),59,nME,G2H2(160),n2h2(136))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(107),mass5set(:,5),  & 
G1H4(261),G1H4(262),G1H4(263),G1H4(466),G1H4(467),G1H4(468),4)
  call HG1shiftOLR(G1H4(262),8,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(100),mass5set(:,4),  & 
G1H4(469),G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),4)
  call HG1shiftOLR(G1H4(470),8,4)
  call Hloop_AV_Q(ntryL,G1H4(273),ex3(:),G1H2(49),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(161),n2h2(137))
  call Hloop_AV_Q(ntryL,G1H4(274),ex3(:),G1H2(50),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(50),55,nME,G2H2(162),n2h2(138))
  call Hloop_AV_Q(ntryL,G1H4(275),ex3(:),G1H2(55),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(55),55,nME,G2H2(163),n2h2(139))
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(108),mass5set(:,5),  & 
G1H4(273),G1H4(274),G1H4(275),G1H4(475),G1H4(476),G1H4(477),4)
  call HG1shiftOLR(G1H4(274),4,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(102),mass5set(:,4),  & 
G1H4(478),G1H4(479),G1H4(480),G1H4(481),G1H4(482),G1H4(483),4)
  call HG1shiftOLR(G1H4(479),4,4)
  call Hloop_AV_Q(ntryL,G1H4(285),ex4(:),G1H2(56),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(56),59,nME,G2H2(164),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H4(286),ex4(:),G1H2(61),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(61),59,nME,G2H2(165),n2h2(141))
  call Hloop_AV_Q(ntryL,G1H4(287),ex4(:),G1H2(62),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(62),59,nME,G2H2(166),n2h2(142))
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(20),mass5set(:,2),  & 
G1H8(40),G1H8(45),G1H8(51),G1H8(58),G1H8(63),G1H8(69),8)
  call HG1shiftOLR(G1H8(45),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(25),mass5set(:,2),  & 
G1H8(75),G1H8(81),G1H8(87),G1H8(93),G1H8(99),G1H8(105),8)
  call HG1shiftOLR(G1H8(81),16,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(26),mass5set(:,2),  & 
G1H8(3),G1H8(18),G1H8(9),G1H8(11),G1H8(15),G1H8(12),8)
  call HG1shiftOLR(G1H8(18),16,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(21),mass5set(:,2),  & 
G1H8(29),G1H8(22),G1H8(30),G1H8(28),G1H8(33),G1H8(17),8)
  call HG1shiftOLR(G1H8(22),16,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(28),mass5set(:,2),  & 
G1H8(39),G1H8(13),G1H8(31),G1H8(46),G1H8(32),G1H8(52),8)
  call HG1shiftOLR(G1H8(13),8,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(22),mass5set(:,2),  & 
G1H8(57),G1H8(14),G1H8(35),G1H8(64),G1H8(36),G1H8(70),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hloop_AQ_V(ntryL,G2H4(107),ex1(:),G2H2(167),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_AQ_V(ntryL,G2H4(110),ex1(:),G2H2(168),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_AQ_V(ntryL,G2H4(111),ex1(:),G2H2(169),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_AQ_V(ntryL,G2H4(112),ex1(:),G2H2(170),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_AQ_V(ntryL,G2H4(115),ex1(:),G2H2(171),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_AQ_V(ntryL,G2H4(116),ex1(:),G2H2(172),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_QA_V(ntryL,G2H4(117),ex2(:),G2H2(173),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_QA_V(ntryL,G2H4(120),ex2(:),G2H2(174),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_QA_V(ntryL,G2H4(121),ex2(:),G2H2(175),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_QA_V(ntryL,G2H4(122),ex2(:),G2H2(176),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_QA_V(ntryL,G2H4(125),ex2(:),G2H2(177),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_QA_V(ntryL,G2H4(126),ex2(:),G2H2(178),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_QA_V(ntryL,G2H4(127),ex2(:),G2H2(179),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_QA_V(ntryL,G2H4(130),ex2(:),G2H2(180),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_QA_V(ntryL,G2H4(131),ex2(:),G2H2(181),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_AQ_V(ntryL,G2H4(132),ex1(:),G2H2(182),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_AQ_V(ntryL,G2H4(135),ex1(:),G2H2(183),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_AQ_V(ntryL,G2H4(136),ex1(:),G2H2(184),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_QA_V(ntryL,G2H8(1),ex2(:),G2H4(2),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_QA_V(ntryL,G2H8(3),ex2(:),G2H4(5),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(8),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(11),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(14),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(17),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(75),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_QA_V(ntryL,G2H8(11),ex2(:),G2H4(33),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_QA_V(ntryL,G2H8(12),ex2(:),G2H4(7),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(37),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(49),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_QA_V(ntryL,G2H8(16),ex2(:),G2H4(27),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(53),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_AQ_V(ntryL,G2H8(21),ex1(:),G2H4(82),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_AQ_V(ntryL,G2H8(36),ex1(:),G2H4(61),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_AQ_V(ntryL,G2H8(20),ex1(:),G2H4(39),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_AQ_V(ntryL,G2H8(25),ex1(:),G2H4(65),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_AQ_V(ntryL,G2H8(30),ex1(:),G2H4(69),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_VA_Q(ntryL,G1H4(116),ex2(:),G1H2(67),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(67),47,nME,G2H2(185),n2h2(143))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(120),-16,nME,G2H4(23),n2h4(175))
  call Hloop_QV_A(ntryL,G2H4(23),ex5(:),G2H2(186),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_VA_Q(ntryL,G1H4(127),ex2(:),G1H2(68),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(68),47,nME,G2H2(187),n2h2(144))
  call Hloop_VA_Q(ntryL,G1H4(128),ex2(:),G1H2(73),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(73),47,nME,G2H2(188),n2h2(145))
  call Hloop_VA_Q(ntryL,G1H4(132),ex2(:),G1H2(74),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(74),47,nME,G2H2(189),n2h2(146))
call HGT_OLR(G1H4(133),1,1,4)
call HGT_invQ_OLR(G1H4(133),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(133),-16,nME,G2H4(73),n2h4(176))
  call Hloop_QV_A(ntryL,G2H4(73),ex5(:),G2H2(190),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_VA_Q(ntryL,G1H4(140),ex2(:),G1H2(79),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(79),47,nME,G2H2(191),n2h2(147))
  call Hloop_VA_Q(ntryL,G1H4(144),ex2(:),G1H2(80),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(80),47,nME,G2H2(192),n2h2(148))
  call Hloop_VQ_A(ntryL,G1H4(145),ex1(:),G1H2(85),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(85),55,nME,G2H2(193),n2h2(149))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-8,nME,G2H4(77),n2h4(177))
  call Hloop_AV_Q(ntryL,G2H4(77),ex4(:),G2H2(194),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_VQ_A(ntryL,G1H4(156),ex1(:),G1H2(86),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(86),55,nME,G2H2(195),n2h2(150))
  call Hloop_VQ_A(ntryL,G1H4(157),ex1(:),G1H2(91),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(91),55,nME,G2H2(196),n2h2(151))
  call Hloop_VQ_A(ntryL,G1H4(158),ex1(:),G1H2(92),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(92),47,nME,G2H2(197),n2h2(152))
call HGT_OLR(G1H4(163),1,1,4)
call HGT_invQ_OLR(G1H4(163),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(163),-16,nME,G2H4(10),n2h4(178))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(198),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VQ_A(ntryL,G1H4(169),ex1(:),G1H2(97),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(97),47,nME,G2H2(199),n2h2(153))
  call Hloop_VQ_A(ntryL,G1H4(170),ex1(:),G1H2(98),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(98),47,nME,G2H2(200),n2h2(154))
  call Hloop_VQ_A(ntryL,G1H4(175),ex1(:),G1H2(103),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(103),47,nME,G2H2(201),n2h2(155))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-16,nME,G2H4(81),n2h4(179))
  call Hloop_AV_Q(ntryL,G2H4(81),ex5(:),G2H2(202),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_VQ_A(ntryL,G1H4(182),ex1(:),G1H2(104),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(104),47,nME,G2H2(203),n2h2(156))
  call Hloop_VQ_A(ntryL,G1H4(187),ex1(:),G1H2(109),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(109),47,nME,G2H2(204),n2h2(157))
  call Hloop_VA_Q(ntryL,G1H4(188),ex2(:),G1H2(110),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(110),55,nME,G2H2(205),n2h2(158))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(192),-8,nME,G2H4(85),n2h4(180))
  call Hloop_QV_A(ntryL,G2H4(85),ex4(:),G2H2(206),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_VA_Q(ntryL,G1H4(199),ex2(:),G1H2(115),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(115),55,nME,G2H2(207),n2h2(159))
  call Hloop_VA_Q(ntryL,G1H4(200),ex2(:),G1H2(116),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_A_Q(ntryL,G1H2(116),55,nME,G2H2(208),n2h2(160))
  call Hloop_VQ_A(ntryL,G1H4(204),ex1(:),G1H2(121),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(121),59,nME,G2H2(209),n2h2(161))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(205),-4,nME,G2H4(13),n2h4(181))
  call Hloop_AV_Q(ntryL,G2H4(13),ex3(:),G2H2(210),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_VQ_A(ntryL,G1H4(212),ex1(:),G1H2(122),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(122),59,nME,G2H2(211),n2h2(162))
  call Hloop_VQ_A(ntryL,G1H4(216),ex1(:),G1H2(127),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(127),59,nME,G2H2(212),n2h2(163))
  call Hloop_QV_A(ntryL,G1H4(217),ex3(:),G1H2(128),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(128),47,nME,G2H2(213),n2h2(164))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-16,nME,G2H4(89),n2h4(182))
  call Hloop_AV_Q(ntryL,G2H4(89),ex5(:),G2H2(214),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_QV_A(ntryL,G1H4(228),ex3(:),G1H2(133),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(133),47,nME,G2H2(215),n2h2(165))
  call Hloop_QV_A(ntryL,G1H4(229),ex3(:),G1H2(134),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(134),47,nME,G2H2(216),n2h2(166))
  call Hloop_VA_Q(ntryL,G1H4(230),ex2(:),G1H2(139),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(139),55,nME,G2H2(217),n2h2(167))
call HGT_OLR(G1H4(235),1,1,4)
call HGT_invQ_OLR(G1H4(235),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(235),-8,nME,G2H4(87),n2h4(183))
  call Hloop_QV_A(ntryL,G2H4(87),ex4(:),G2H2(218),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_VA_Q(ntryL,G1H4(241),ex2(:),G1H2(140),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(140),55,nME,G2H2(219),n2h2(168))
  call Hloop_VA_Q(ntryL,G1H4(242),ex2(:),G1H2(1),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(220),n2h2(169))
  call Hloop_AV_Q(ntryL,G1H4(247),ex4(:),G1H2(2),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(221),n2h2(170))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(248),-16,nME,G2H4(95),n2h4(184))
  call Hloop_QV_A(ntryL,G2H4(95),ex5(:),G2H2(222),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_AV_Q(ntryL,G1H4(254),ex4(:),G1H2(7),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(223),n2h2(171))
  call Hloop_AV_Q(ntryL,G1H4(259),ex4(:),G1H2(8),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(224),n2h2(172))
  call Hloop_VA_Q(ntryL,G1H4(260),ex2(:),G1H2(13),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(225),n2h2(173))
call HGT_OLR(G1H4(264),1,1,4)
call HGT_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(264),-16,nME,G2H4(104),n2h4(185))
  call Hloop_QV_A(ntryL,G2H4(104),ex5(:),G2H2(226),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_VA_Q(ntryL,G1H4(271),ex2(:),G1H2(14),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(227),n2h2(174))
  call Hloop_VA_Q(ntryL,G1H4(272),ex2(:),G1H2(19),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(19),47,nME,G2H2(228),n2h2(175))
  call Hloop_AV_Q(ntryL,G1H4(276),ex5(:),G1H2(20),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(20),55,nME,G2H2(229),n2h2(176))
call HGT_OLR(G1H4(277),1,1,4)
call HGT_invQ_OLR(G1H4(277),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(277),-8,nME,G2H4(92),n2h4(186))
  call Hloop_QV_A(ntryL,G2H4(92),ex4(:),G2H2(230),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_AV_Q(ntryL,G1H4(284),ex5(:),G1H2(25),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(25),55,nME,G2H2(231),n2h2(177))
  call Hloop_AV_Q(ntryL,G1H4(288),ex5(:),G1H2(26),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(26),55,nME,G2H2(232),n2h2(178))
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(31),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(31),55,nME,G2H2(233),n2h2(179))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-8,nME,G2H4(98),n2h4(187))
  call Hloop_AV_Q(ntryL,G2H4(98),ex4(:),G2H2(234),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_QV_A(ntryL,G1H4(54),ex3(:),G1H2(32),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(32),55,nME,G2H2(235),n2h2(180))
  call Hloop_QV_A(ntryL,G1H4(66),ex3(:),G1H2(37),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(37),55,nME,G2H2(236),n2h2(181))
  call Hloop_QV_A(ntryL,G1H4(78),ex4(:),G1H2(38),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(38),47,nME,G2H2(237),n2h2(182))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(90),-16,nME,G2H4(101),n2h4(188))
  call Hloop_AV_Q(ntryL,G2H4(101),ex5(:),G2H2(238),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_QV_A(ntryL,G1H4(126),ex4(:),G1H2(43),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(43),47,nME,G2H2(239),n2h2(183))
  call Hloop_QV_A(ntryL,G1H4(138),ex4(:),G1H2(44),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_Q_A(ntryL,G1H2(44),47,nME,G2H2(240),n2h2(184))
  call Hloop_QV_A(ntryL,G1H4(150),ex3(:),G1H2(49),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(241),n2h2(185))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(162),-16,nME,G2H4(20),n2h4(189))
  call Hloop_AV_Q(ntryL,G2H4(20),ex5(:),G2H2(242),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_QV_A(ntryL,G1H4(198),ex3(:),G1H2(50),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(243),n2h2(186))
  call Hloop_QV_A(ntryL,G1H4(210),ex3(:),G1H2(55),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(55),47,nME,G2H2(244),n2h2(187))
  call Hloop_QV_A(ntryL,G1H4(222),ex5(:),G1H2(56),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(56),55,nME,G2H2(245),n2h2(188))
call HGT_OLR(G1H4(234),1,1,4)
call HGT_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(234),-8,nME,G2H4(21),n2h4(190))
  call Hloop_AV_Q(ntryL,G2H4(21),ex4(:),G2H2(246),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_QV_A(ntryL,G1H4(270),ex5(:),G1H2(61),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(61),55,nME,G2H2(247),n2h2(189))
  call Hloop_QV_A(ntryL,G1H4(282),ex5(:),G1H2(62),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(62),55,nME,G2H2(248),n2h2(190))
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(67),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(67),59,nME,G2H2(249),n2h2(191))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-4,nME,G2H4(24),n2h4(191))
  call Hloop_QV_A(ntryL,G2H4(24),ex3(:),G2H2(250),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(68),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(68),59,nME,G2H2(251),n2h2(192))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(73),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_A_Q(ntryL,G1H2(73),59,nME,G2H2(252),n2h2(193))
  call Hloop_AV_Q(ntryL,G1H4(14),ex3(:),G1H2(74),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_A_Q(ntryL,G1H2(74),47,nME,G2H2(253),n2h2(194))
call HGT_OLR(G1H4(19),1,1,4)
call HGT_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(19),-16,nME,G2H4(25),n2h4(192))
  call Hloop_QV_A(ntryL,G2H4(25),ex5(:),G2H2(254),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_AV_Q(ntryL,G1H4(25),ex3(:),G1H2(79),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_A_Q(ntryL,G1H2(79),47,nME,G2H2(255),n2h2(195))
  call Hloop_AV_Q(ntryL,G1H4(26),ex3(:),G1H2(80),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_A_Q(ntryL,G1H2(80),47,nME,G2H2(256),n2h2(196))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(85),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(85),55,nME,G2H2(257),n2h2(197))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-8,nME,G2H4(28),n2h4(193))
  call Hloop_AV_Q(ntryL,G2H4(28),ex4(:),G2H2(258),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_VQ_A(ntryL,G1H4(38),ex1(:),G1H2(86),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(86),55,nME,G2H2(259),n2h2(198))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(91),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(91),55,nME,G2H2(260),n2h2(199))
  call Hloop_QV_A(ntryL,G1H4(44),ex4(:),G1H2(92),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(92),47,nME,G2H2(261),n2h2(200))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(48),-16,nME,G2H4(29),n2h4(194))
  call Hloop_AV_Q(ntryL,G2H4(29),ex5(:),G2H2(262),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_QV_A(ntryL,G1H4(55),ex4(:),G1H2(97),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(97),47,nME,G2H2(263),n2h2(201))
  call Hloop_QV_A(ntryL,G1H4(56),ex4(:),G1H2(98),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(98),47,nME,G2H2(264),n2h2(202))
  call Hloop_QV_A(ntryL,G1H4(60),ex4(:),G1H2(103),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(103),59,nME,G2H2(265),n2h2(203))
call HGT_OLR(G1H4(61),1,1,4)
call HGT_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(61),-4,nME,G2H4(32),n2h4(195))
  call Hloop_AV_Q(ntryL,G2H4(32),ex3(:),G2H2(266),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_QV_A(ntryL,G1H4(68),ex4(:),G1H2(104),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(104),59,nME,G2H2(267),n2h2(204))
  call Hloop_QV_A(ntryL,G1H4(72),ex4(:),G1H2(109),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(109),59,nME,G2H2(268),n2h2(205))
  call Hloop_QV_A(ntryL,G1H4(73),ex3(:),G1H2(110),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(110),47,nME,G2H2(269),n2h2(206))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,nME,G2H4(91),n2h4(196))
  call Hloop_AV_Q(ntryL,G2H4(91),ex5(:),G2H2(270),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(115),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(115),47,nME,G2H2(271),n2h2(207))
  call Hloop_QV_A(ntryL,G1H4(85),ex3(:),G1H2(116),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(116),47,nME,G2H2(272),n2h2(208))
  call Hloop_QV_A(ntryL,G1H4(86),ex4(:),G1H2(121),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(121),47,nME,G2H2(273),n2h2(209))
call HGT_OLR(G1H4(91),1,1,4)
call HGT_invQ_OLR(G1H4(91),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(91),-16,nME,G2H4(36),n2h4(197))
  call Hloop_AV_Q(ntryL,G2H4(36),ex5(:),G2H2(274),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_QV_A(ntryL,G1H4(97),ex4(:),G1H2(122),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(122),47,nME,G2H2(275),n2h2(210))
  call Hloop_QV_A(ntryL,G1H4(98),ex4(:),G1H2(127),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(127),47,nME,G2H2(276),n2h2(211))
  call Hloop_QV_A(ntryL,G1H4(103),ex5(:),G1H2(128),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(128),59,nME,G2H2(277),n2h2(212))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(104),-4,nME,G2H4(90),n2h4(198))
  call Hloop_AV_Q(ntryL,G2H4(90),ex3(:),G2H2(278),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_QV_A(ntryL,G1H4(110),ex5(:),G1H2(133),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(133),59,nME,G2H2(279),n2h2(213))
  call Hloop_QV_A(ntryL,G1H4(115),ex5(:),G1H2(134),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(134),59,nME,G2H2(280),n2h2(214))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(139),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(139),47,nME,G2H2(281),n2h2(215))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(17),-16,nME,G2H4(40),n2h4(199))
  call Hloop_AV_Q(ntryL,G2H4(40),ex5(:),G2H2(282),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_VQ_A(ntryL,G1H4(53),ex1(:),G1H2(140),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(140),47,nME,G2H2(283),n2h2(216))
  call Hloop_VQ_A(ntryL,G1H4(65),ex1(:),G1H2(1),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(284),n2h2(217))
  call Hloop_QV_A(ntryL,G1H4(77),ex5(:),G1H2(2),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(2),55,nME,G2H2(285),n2h2(218))
call HGT_OLR(G1H4(89),1,1,4)
call HGT_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(89),-8,nME,G2H4(41),n2h4(200))
  call Hloop_AV_Q(ntryL,G2H4(41),ex4(:),G2H2(286),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_QV_A(ntryL,G1H4(113),ex5(:),G1H2(7),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(7),55,nME,G2H2(287),n2h2(219))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(8),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(8),55,nME,G2H2(288),n2h2(220))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(13),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(13),59,nME,G2H2(289),n2h2(221))
call HGT_OLR(G1H4(137),1,1,4)
call HGT_invQ_OLR(G1H4(137),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(137),-4,nME,G2H4(44),n2h4(201))
  call Hloop_AV_Q(ntryL,G2H4(44),ex3(:),G2H2(290),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_QV_A(ntryL,G1H4(147),ex5(:),G1H2(14),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(14),59,nME,G2H2(291),n2h2(222))
  call Hloop_QV_A(ntryL,G1H4(173),ex5(:),G1H2(19),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(19),59,nME,G2H2(292),n2h2(223))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(20),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_Q_A(ntryL,G1H2(20),55,nME,G2H2(293),n2h2(224))
call HGT_OLR(G1H4(185),1,1,4)
call HGT_invQ_OLR(G1H4(185),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(185),-8,nME,G2H4(45),n2h4(202))
  call Hloop_AV_Q(ntryL,G2H4(45),ex4(:),G2H2(294),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_QV_A(ntryL,G1H4(209),ex3(:),G1H2(25),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(25),55,nME,G2H2(295),n2h2(225))
  call Hloop_QV_A(ntryL,G1H4(221),ex3(:),G1H2(26),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_Q_A(ntryL,G1H2(26),55,nME,G2H2(296),n2h2(226))
  call Hloop_QV_A(ntryL,G1H4(135),ex5(:),G1H2(31),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(31),55,nME,G2H2(297),n2h2(227))
call HGT_OLR(G1H4(233),1,1,4)
call HGT_invQ_OLR(G1H4(233),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(233),-8,nME,G2H4(48),n2h4(203))
  call Hloop_AV_Q(ntryL,G2H4(48),ex4(:),G2H2(298),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_QV_A(ntryL,G1H4(257),ex5(:),G1H2(32),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(32),55,nME,G2H2(299),n2h2(228))
  call Hloop_QV_A(ntryL,G1H4(269),ex5(:),G1H2(37),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(37),55,nME,G2H2(300),n2h2(229))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(38),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(38),59,nME,G2H2(301),n2h2(230))
call HGT_OLR(G1H4(281),1,1,4)
call HGT_invQ_OLR(G1H4(281),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(281),-4,nME,G2H4(97),n2h4(204))
  call Hloop_AV_Q(ntryL,G2H4(97),ex3(:),G2H2(302),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_QV_A(ntryL,G1H4(10),ex4(:),G1H2(43),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(43),59,nME,G2H2(303),n2h2(231))
  call Hloop_QV_A(ntryL,G1H4(15),ex4(:),G1H2(44),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_Q_A(ntryL,G1H2(44),59,nME,G2H2(304),n2h2(232))
  call Hloop_AV_Q(ntryL,G1H4(27),ex3(:),G1H2(49),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(305),n2h2(233))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-8,nME,G2H4(52),n2h4(205))
  call Hloop_QV_A(ntryL,G2H4(52),ex4(:),G2H2(306),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_AV_Q(ntryL,G1H4(46),ex3(:),G1H2(50),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_A_Q(ntryL,G1H2(50),55,nME,G2H2(307),n2h2(234))
  call Hloop_AV_Q(ntryL,G1H4(51),ex3(:),G1H2(55),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_A_Q(ntryL,G1H2(55),55,nME,G2H2(308),n2h2(235))
  call Hloop_AV_Q(ntryL,G1H4(63),ex4(:),G1H2(56),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G1H2(56),47,nME,G2H2(309),n2h2(236))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(64),-16,nME,G2H4(96),n2h4(206))
  call Hloop_QV_A(ntryL,G2H4(96),ex5(:),G2H2(310),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_AV_Q(ntryL,G1H4(100),ex4(:),G1H2(61),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(61),47,nME,G2H2(311),n2h2(237))
  call Hloop_AV_Q(ntryL,G1H4(111),ex4(:),G1H2(62),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_A_Q(ntryL,G1H2(62),47,nME,G2H2(312),n2h2(238))
  call Hloop_AV_Q(ntryL,G1H4(112),ex3(:),G1H2(67),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(67),47,nME,G2H2(313),n2h2(239))
call HGT_OLR(G1H4(123),1,1,4)
call HGT_invQ_OLR(G1H4(123),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(123),-16,nME,G2H4(56),n2h4(207))
  call Hloop_QV_A(ntryL,G2H4(56),ex5(:),G2H2(314),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_AV_Q(ntryL,G1H4(148),ex3(:),G1H2(68),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_A_Q(ntryL,G1H2(68),47,nME,G2H2(315),n2h2(240))
  call Hloop_AV_Q(ntryL,G1H4(159),ex3(:),G1H2(73),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_A_Q(ntryL,G1H2(73),47,nME,G2H2(316),n2h2(241))
  call Hloop_AV_Q(ntryL,G1H4(160),ex5(:),G1H2(74),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_A_Q(ntryL,G1H2(74),55,nME,G2H2(317),n2h2(242))
call HGT_OLR(G1H4(171),1,1,4)
call HGT_invQ_OLR(G1H4(171),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(171),-8,nME,G2H4(57),n2h4(208))
  call Hloop_QV_A(ntryL,G2H4(57),ex4(:),G2H2(318),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_AV_Q(ntryL,G1H4(195),ex5(:),G1H2(79),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(79),55,nME,G2H2(319),n2h2(243))
  call Hloop_AV_Q(ntryL,G1H4(196),ex5(:),G1H2(80),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(80),55,nME,G2H2(320),n2h2(244))
  call Hloop_AV_Q(ntryL,G1H4(207),ex4(:),G1H2(85),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_A_Q(ntryL,G1H2(85),59,nME,G2H2(321),n2h2(245))
call HGT_OLR(G1H4(208),1,1,4)
call HGT_invQ_OLR(G1H4(208),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(208),-4,nME,G2H4(60),n2h4(209))
  call Hloop_QV_A(ntryL,G2H4(60),ex3(:),G2H2(322),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_AV_Q(ntryL,G1H4(231),ex4(:),G1H2(86),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(86),59,nME,G2H2(323),n2h2(246))
  call Hloop_AV_Q(ntryL,G1H4(232),ex4(:),G1H2(91),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_A_Q(ntryL,G1H2(91),59,nME,G2H2(324),n2h2(247))
  call Hloop_AV_Q(ntryL,G1H4(243),ex3(:),G1H2(92),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(325),n2h2(248))
call HGT_OLR(G1H4(244),1,1,4)
call HGT_invQ_OLR(G1H4(244),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(244),-16,nME,G2H4(103),n2h4(210))
  call Hloop_QV_A(ntryL,G2H4(103),ex5(:),G2H2(326),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_AV_Q(ntryL,G1H4(267),ex3(:),G1H2(97),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(97),47,nME,G2H2(327),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H4(268),ex3(:),G1H2(98),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(98),47,nME,G2H2(328),n2h2(250))
  call Hloop_AV_Q(ntryL,G1H4(279),ex4(:),G1H2(103),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(103),47,nME,G2H2(329),n2h2(251))
call HGT_OLR(G1H4(280),1,1,4)
call HGT_invQ_OLR(G1H4(280),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(280),-16,nME,G2H4(64),n2h4(211))
  call Hloop_QV_A(ntryL,G2H4(64),ex5(:),G2H2(330),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_AV_Q(ntryL,G1H4(291),ex4(:),G1H2(104),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(104),47,nME,G2H2(331),n2h2(252))
  call Hloop_AV_Q(ntryL,G1H4(292),ex4(:),G1H2(109),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_A_Q(ntryL,G1H2(109),47,nME,G2H2(332),n2h2(253))
  call Hloop_AV_Q(ntryL,G1H4(293),ex5(:),G1H2(110),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(110),59,nME,G2H2(333),n2h2(254))
call HGT_OLR(G1H4(294),1,1,4)
call HGT_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(294),-4,nME,G2H4(102),n2h4(212))
  call Hloop_QV_A(ntryL,G2H4(102),ex3(:),G2H2(334),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_AV_Q(ntryL,G1H4(297),ex5(:),G1H2(115),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_A_Q(ntryL,G1H2(115),59,nME,G2H2(335),n2h2(255))
  call Hloop_AV_Q(ntryL,G1H4(298),ex5(:),G1H2(116),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_A_Q(ntryL,G1H2(116),59,nME,G2H2(336),n2h2(256))
  call Hloop_AV_Q(ntryL,G1H4(299),ex5(:),G1H2(121),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_A_Q(ntryL,G1H2(121),59,nME,G2H2(337),n2h2(257))
call HGT_OLR(G1H4(300),1,1,4)
call HGT_invQ_OLR(G1H4(300),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(300),-4,nME,G2H4(68),n2h4(213))
  call Hloop_QV_A(ntryL,G2H4(68),ex3(:),G2H2(338),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_AV_Q(ntryL,G1H4(303),ex5(:),G1H2(122),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(122),59,nME,G2H2(339),n2h2(258))
  call Hloop_AV_Q(ntryL,G1H4(304),ex5(:),G1H2(127),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(127),59,nME,G2H2(340),n2h2(259))
  call Hloop_AV_Q(ntryL,G1H4(305),ex3(:),G1H2(128),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(128),55,nME,G2H2(341),n2h2(260))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(306),-8,nME,G2H4(94),n2h4(214))
  call Hloop_QV_A(ntryL,G2H4(94),ex4(:),G2H2(342),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_AV_Q(ntryL,G1H4(309),ex3(:),G1H2(133),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(133),55,nME,G2H2(343),n2h2(261))
  call Hloop_AV_Q(ntryL,G1H4(310),ex3(:),G1H2(134),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(134),55,nME,G2H2(344),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H4(311),ex5(:),G1H2(139),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(139),55,nME,G2H2(345),n2h2(263))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(312),-8,nME,G2H4(72),n2h4(215))
  call Hloop_QV_A(ntryL,G2H4(72),ex4(:),G2H2(346),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_AV_Q(ntryL,G1H4(315),ex5(:),G1H2(140),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(140),55,nME,G2H2(347),n2h2(264))
  call Hloop_AV_Q(ntryL,G1H4(316),ex5(:),G1H2(1),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(348),n2h2(265))
  call Hloop_AV_Q(ntryL,G1H4(317),ex4(:),G1H2(2),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(2),59,nME,G2H2(349),n2h2(266))
call HGT_OLR(G1H4(318),1,1,4)
call HGT_invQ_OLR(G1H4(318),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(318),-4,nME,G2H4(93),n2h4(216))
  call Hloop_QV_A(ntryL,G2H4(93),ex3(:),G2H2(350),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_AV_Q(ntryL,G1H4(321),ex4(:),G1H2(7),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(7),59,nME,G2H2(351),n2h2(267))
  call Hloop_AV_Q(ntryL,G1H4(322),ex4(:),G1H2(8),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(8),59,nME,G2H2(352),n2h2(268))
  call Hloop_VA_Q(ntryL,G1H4(323),ex2(:),G1H2(13),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(353),n2h2(269))
call HGT_OLR(G1H4(324),1,1,4)
call HGT_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(324),-16,nME,G2H4(76),n2h4(217))
  call Hloop_QV_A(ntryL,G2H4(76),ex5(:),G2H2(354),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_VA_Q(ntryL,G1H4(327),ex2(:),G1H2(14),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(355),n2h2(270))
  call Hloop_VA_Q(ntryL,G1H4(328),ex2(:),G1H2(19),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(19),47,nME,G2H2(356),n2h2(271))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(20),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(20),47,nME,G2H2(357),n2h2(272))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-16,nME,G2H4(100),n2h4(218))
  call Hloop_QV_A(ntryL,G2H4(100),ex5(:),G2H2(358),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_VA_Q(ntryL,G1H4(330),ex2(:),G1H2(25),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(25),47,nME,G2H2(359),n2h2(273))
  call Hloop_VA_Q(ntryL,G1H4(331),ex2(:),G1H2(26),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_A_Q(ntryL,G1H2(26),47,nME,G2H2(360),n2h2(274))
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(31),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_Q_A(ntryL,G1H2(31),55,nME,G2H2(361),n2h2(275))
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(23),-8,nME,G2H4(80),n2h4(219))
  call Hloop_AV_Q(ntryL,G2H4(80),ex4(:),G2H2(362),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_VQ_A(ntryL,G1H4(334),ex1(:),G1H2(32),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G1H2(32),55,nME,G2H2(363),n2h2(276))
  call Hloop_VQ_A(ntryL,G1H4(335),ex1(:),G1H2(37),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_Q_A(ntryL,G1H2(37),55,nME,G2H2(364),n2h2(277))
  call Hloop_VQ_A(ntryL,G1H4(336),ex1(:),G1H2(38),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(38),55,nME,G2H2(365),n2h2(278))
call HGT_OLR(G1H4(337),1,1,4)
call HGT_invQ_OLR(G1H4(337),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(337),-8,nME,G2H4(99),n2h4(220))
  call Hloop_AV_Q(ntryL,G2H4(99),ex4(:),G2H2(366),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_VQ_A(ntryL,G1H4(340),ex1(:),G1H2(43),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(43),55,nME,G2H2(367),n2h2(279))
  call Hloop_VQ_A(ntryL,G1H4(341),ex1(:),G1H2(44),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_Q_A(ntryL,G1H2(44),55,nME,G2H2(368),n2h2(280))
  call Hloop_VQ_A(ntryL,G1H4(33),ex1(:),G1H2(49),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(369),n2h2(281))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-16,nME,G2H4(84),n2h4(221))
  call Hloop_AV_Q(ntryL,G2H4(84),ex5(:),G2H2(370),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_VQ_A(ntryL,G1H4(343),ex1(:),G1H2(50),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(371),n2h2(282))
  call Hloop_VQ_A(ntryL,G1H4(344),ex1(:),G1H2(55),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(55),47,nME,G2H2(372),n2h2(283))
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(56),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_Q_A(ntryL,G1H2(56),47,nME,G2H2(373),n2h2(284))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-16,nME,G2H4(106),n2h4(222))
  call Hloop_AV_Q(ntryL,G2H4(106),ex5(:),G2H2(374),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_VQ_A(ntryL,G1H4(346),ex1(:),G1H2(61),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(61),47,nME,G2H2(375),n2h2(285))
  call Hloop_VQ_A(ntryL,G1H4(347),ex1(:),G1H2(62),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(62),47,nME,G2H2(376),n2h2(286))
  call Hloop_VA_Q(ntryL,G1H4(57),ex2(:),G1H2(67),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_A_Q(ntryL,G1H2(67),55,nME,G2H2(377),n2h2(287))
call HGT_OLR(G1H4(59),1,1,4)
call HGT_invQ_OLR(G1H4(59),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(59),-8,nME,G2H4(88),n2h4(223))
  call Hloop_QV_A(ntryL,G2H4(88),ex4(:),G2H2(378),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_VA_Q(ntryL,G1H4(350),ex2(:),G1H2(68),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_A_Q(ntryL,G1H2(68),55,nME,G2H2(379),n2h2(288))
  call Hloop_VA_Q(ntryL,G1H4(351),ex2(:),G1H2(73),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(73),55,nME,G2H2(380),n2h2(289))
  call Hloop_VA_Q(ntryL,G1H4(352),ex2(:),G1H2(74),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(74),55,nME,G2H2(381),n2h2(290))
call HGT_OLR(G1H4(353),1,1,4)
call HGT_invQ_OLR(G1H4(353),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(353),-8,nME,G2H4(105),n2h4(224))
  call Hloop_QV_A(ntryL,G2H4(105),ex4(:),G2H2(382),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_VA_Q(ntryL,G1H4(356),ex2(:),G1H2(79),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G1H2(79),55,nME,G2H2(383),n2h2(291))
  call Hloop_VA_Q(ntryL,G1H4(357),ex2(:),G1H2(80),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(80),55,nME,G2H2(384),n2h2(292))
  call Hloop_QV_A(ntryL,G1H4(69),ex3(:),G1H2(85),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(85),47,nME,G2H2(385),n2h2(293))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-16,nME,G2H4(1),n2h4(225))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(386),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_QV_A(ntryL,G1H4(359),ex3(:),G1H2(86),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(86),47,nME,G2H2(387),n2h2(294))
  call Hloop_QV_A(ntryL,G1H4(360),ex3(:),G1H2(91),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(91),47,nME,G2H2(388),n2h2(295))
  call Hloop_AV_Q(ntryL,G1H4(81),ex4(:),G1H2(92),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(389),n2h2(296))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-16,nME,G2H4(78),n2h4(226))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(390),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_AV_Q(ntryL,G1H4(362),ex4(:),G1H2(97),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_A_Q(ntryL,G1H2(97),47,nME,G2H2(391),n2h2(297))
  call Hloop_AV_Q(ntryL,G1H4(363),ex4(:),G1H2(98),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(98),47,nME,G2H2(392),n2h2(298))
  call Hloop_AV_Q(ntryL,G1H4(93),ex5(:),G1H2(103),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_A_Q(ntryL,G1H2(103),55,nME,G2H2(393),n2h2(299))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-8,nME,G2H4(79),n2h4(227))
  call Hloop_QV_A(ntryL,G2H4(79),ex4(:),G2H2(394),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_AV_Q(ntryL,G1H4(365),ex5(:),G1H2(104),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(104),55,nME,G2H2(395),n2h2(300))
  call Hloop_AV_Q(ntryL,G1H4(366),ex5(:),G1H2(109),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(109),55,nME,G2H2(396),n2h2(301))
  call Hloop_QV_A(ntryL,G1H4(105),ex4(:),G1H2(110),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(110),47,nME,G2H2(397),n2h2(302))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(106),-16,nME,G2H4(3),n2h4(228))
  call Hloop_AV_Q(ntryL,G2H4(3),ex5(:),G2H2(398),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_QV_A(ntryL,G1H4(368),ex4(:),G1H2(115),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(115),47,nME,G2H2(399),n2h2(303))
  call Hloop_QV_A(ntryL,G1H4(369),ex4(:),G1H2(116),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_Q_A(ntryL,G1H2(116),47,nME,G2H2(400),n2h2(304))
  call Hloop_QV_A(ntryL,G1H4(370),ex4(:),G1H2(121),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(121),47,nME,G2H2(401),n2h2(305))
call HGT_OLR(G1H4(371),1,1,4)
call HGT_invQ_OLR(G1H4(371),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(371),-16,nME,G2H4(4),n2h4(229))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(402),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_QV_A(ntryL,G1H4(374),ex4(:),G1H2(122),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(122),47,nME,G2H2(403),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(375),ex4(:),G1H2(127),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(127),47,nME,G2H2(404),n2h2(307))
  call Hloop_QV_A(ntryL,G1H4(117),ex5(:),G1H2(128),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(128),55,nME,G2H2(405),n2h2(308))
call HGT_OLR(G1H4(118),1,1,4)
call HGT_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(118),-8,nME,G2H4(83),n2h4(230))
  call Hloop_AV_Q(ntryL,G2H4(83),ex4(:),G2H2(406),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_QV_A(ntryL,G1H4(377),ex5(:),G1H2(133),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_Q_A(ntryL,G1H2(133),55,nME,G2H2(407),n2h2(309))
  call Hloop_QV_A(ntryL,G1H4(378),ex5(:),G1H2(134),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(134),55,nME,G2H2(408),n2h2(310))
  call Hloop_QV_A(ntryL,G1H4(379),ex5(:),G1H2(139),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_Q_A(ntryL,G1H2(139),55,nME,G2H2(409),n2h2(311))
call HGT_OLR(G1H4(380),1,1,4)
call HGT_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(380),-8,nME,G2H4(86),n2h4(231))
  call Hloop_AV_Q(ntryL,G2H4(86),ex4(:),G2H2(410),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_QV_A(ntryL,G1H4(383),ex5(:),G1H2(140),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(140),55,nME,G2H2(411),n2h2(312))
  call Hloop_QV_A(ntryL,G1H4(384),ex5(:),G1H2(1),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(412),n2h2(313))
  call Hloop_AV_Q(ntryL,G1H4(129),ex3(:),G1H2(2),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(413),n2h2(314))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(130),-16,nME,G2H4(6),n2h4(232))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(414),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_AV_Q(ntryL,G1H4(386),ex3(:),G1H2(7),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(415),n2h2(315))
  call Hloop_AV_Q(ntryL,G1H4(387),ex3(:),G1H2(8),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(416),n2h2(316))
  call Hloop_QV_A(ntryL,G1H4(141),ex4(:),G1H2(13),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_Q_A(ntryL,G1H2(13),47,nME,G2H2(417),n2h2(317))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(142),-16,nME,G2H4(9),n2h4(233))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(418),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_QV_A(ntryL,G1H4(389),ex4(:),G1H2(14),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_Q_A(ntryL,G1H2(14),47,nME,G2H2(419),n2h2(318))
  call Hloop_QV_A(ntryL,G1H4(390),ex4(:),G1H2(19),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hloop_Q_A(ntryL,G1H2(19),47,nME,G2H2(420),n2h2(319))
  call Hloop_QV_A(ntryL,G1H4(153),ex3(:),G1H2(20),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_Q_A(ntryL,G1H2(20),47,nME,G2H2(421),n2h2(320))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(154),-16,nME,G2H4(12),n2h4(234))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(422),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_QV_A(ntryL,G1H4(392),ex3(:),G1H2(25),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_Q_A(ntryL,G1H2(25),47,nME,G2H2(423),n2h2(321))
  call Hloop_QV_A(ntryL,G1H4(393),ex3(:),G1H2(26),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_Q_A(ntryL,G1H2(26),47,nME,G2H2(424),n2h2(322))
  call Hloop_QV_A(ntryL,G1H4(394),ex3(:),G1H2(31),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_Q_A(ntryL,G1H2(31),47,nME,G2H2(425),n2h2(323))
call HGT_OLR(G1H4(395),1,1,4)
call HGT_invQ_OLR(G1H4(395),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(395),-16,nME,G2H4(15),n2h4(235))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(426),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_QV_A(ntryL,G1H4(398),ex3(:),G1H2(32),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(32),47,nME,G2H2(427),n2h2(324))
  call Hloop_QV_A(ntryL,G1H4(399),ex3(:),G1H2(37),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(37),47,nME,G2H2(428),n2h2(325))
  call Hloop_QV_A(ntryL,G1H4(165),ex5(:),G1H2(38),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_Q_A(ntryL,G1H2(38),59,nME,G2H2(429),n2h2(326))
call HGT_OLR(G1H4(166),1,1,4)
call HGT_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(166),-4,nME,G2H4(16),n2h4(236))
  call Hloop_AV_Q(ntryL,G2H4(16),ex3(:),G2H2(430),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_QV_A(ntryL,G1H4(401),ex5(:),G1H2(43),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(43),59,nME,G2H2(431),n2h2(327))
  call Hloop_QV_A(ntryL,G1H4(402),ex5(:),G1H2(44),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_Q_A(ntryL,G1H2(44),59,nME,G2H2(432),n2h2(328))
  call Hloop_QV_A(ntryL,G1H4(403),ex5(:),G1H2(49),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(49),59,nME,G2H2(433),n2h2(329))
call HGT_OLR(G1H4(404),1,1,4)
call HGT_invQ_OLR(G1H4(404),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(404),-4,nME,G2H4(18),n2h4(237))
  call Hloop_AV_Q(ntryL,G2H4(18),ex3(:),G2H2(434),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_QV_A(ntryL,G1H4(407),ex5(:),G1H2(50),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_Q_A(ntryL,G1H2(50),59,nME,G2H2(435),n2h2(330))
  call Hloop_QV_A(ntryL,G1H4(408),ex5(:),G1H2(55),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_Q_A(ntryL,G1H2(55),59,nME,G2H2(436),n2h2(331))
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(56),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_Q_A(ntryL,G1H2(56),55,nME,G2H2(437),n2h2(332))
call HGT_OLR(G1H4(178),1,1,4)
call HGT_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(178),-8,nME,G2H4(19),n2h4(238))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(438),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_QV_A(ntryL,G1H4(410),ex5(:),G1H2(61),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_Q_A(ntryL,G1H2(61),55,nME,G2H2(439),n2h2(333))
  call Hloop_QV_A(ntryL,G1H4(411),ex5(:),G1H2(62),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_Q_A(ntryL,G1H2(62),55,nME,G2H2(440),n2h2(334))
  call Hloop_QV_A(ntryL,G1H4(189),ex3(:),G1H2(67),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(67),55,nME,G2H2(441),n2h2(335))
call HGT_OLR(G1H4(190),1,1,4)
call HGT_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(190),-8,nME,G2H4(22),n2h4(239))
  call Hloop_AV_Q(ntryL,G2H4(22),ex4(:),G2H2(442),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_QV_A(ntryL,G1H4(413),ex3(:),G1H2(68),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_Q_A(ntryL,G1H2(68),55,nME,G2H2(443),n2h2(336))
  call Hloop_QV_A(ntryL,G1H4(414),ex3(:),G1H2(73),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_Q_A(ntryL,G1H2(73),55,nME,G2H2(444),n2h2(337))
  call Hloop_QV_A(ntryL,G1H4(415),ex3(:),G1H2(74),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G1H2(74),55,nME,G2H2(445),n2h2(338))
call HGT_OLR(G1H4(416),1,1,4)
call HGT_invQ_OLR(G1H4(416),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(416),-8,nME,G2H4(26),n2h4(240))
  call Hloop_AV_Q(ntryL,G2H4(26),ex4(:),G2H2(446),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_QV_A(ntryL,G1H4(419),ex3(:),G1H2(79),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_Q_A(ntryL,G1H2(79),55,nME,G2H2(447),n2h2(339))
  call Hloop_QV_A(ntryL,G1H4(420),ex3(:),G1H2(80),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_Q_A(ntryL,G1H2(80),55,nME,G2H2(448),n2h2(340))
  call Hloop_QV_A(ntryL,G1H4(201),ex4(:),G1H2(85),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_Q_A(ntryL,G1H2(85),59,nME,G2H2(449),n2h2(341))
call HGT_OLR(G1H4(202),1,1,4)
call HGT_invQ_OLR(G1H4(202),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(202),-4,nME,G2H4(30),n2h4(241))
  call Hloop_AV_Q(ntryL,G2H4(30),ex3(:),G2H2(450),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_QV_A(ntryL,G1H4(422),ex4(:),G1H2(86),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_Q_A(ntryL,G1H2(86),59,nME,G2H2(451),n2h2(342))
  call Hloop_QV_A(ntryL,G1H4(423),ex4(:),G1H2(91),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_Q_A(ntryL,G1H2(91),59,nME,G2H2(452),n2h2(343))
  call Hloop_QV_A(ntryL,G1H4(424),ex4(:),G1H2(92),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_Q_A(ntryL,G1H2(92),59,nME,G2H2(453),n2h2(344))
call HGT_OLR(G1H4(425),1,1,4)
call HGT_invQ_OLR(G1H4(425),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(425),-4,nME,G2H4(31),n2h4(242))
  call Hloop_AV_Q(ntryL,G2H4(31),ex3(:),G2H2(454),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_QV_A(ntryL,G1H4(428),ex4(:),G1H2(97),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(97),59,nME,G2H2(455),n2h2(345))
  call Hloop_QV_A(ntryL,G1H4(429),ex4(:),G1H2(98),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_Q_A(ntryL,G1H2(98),59,nME,G2H2(456),n2h2(346))
  call Hloop_AV_Q(ntryL,G1H4(213),ex4(:),G1H2(103),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_A_Q(ntryL,G1H2(103),47,nME,G2H2(457),n2h2(347))
call HGT_OLR(G1H4(214),1,1,4)
call HGT_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(214),-16,nME,G2H4(34),n2h4(243))
  call Hloop_QV_A(ntryL,G2H4(34),ex5(:),G2H2(458),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_AV_Q(ntryL,G1H4(431),ex4(:),G1H2(104),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_A_Q(ntryL,G1H2(104),47,nME,G2H2(459),n2h2(348))
  call Hloop_AV_Q(ntryL,G1H4(432),ex4(:),G1H2(109),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_A_Q(ntryL,G1H2(109),47,nME,G2H2(460),n2h2(349))
  call Hloop_AV_Q(ntryL,G1H4(433),ex4(:),G1H2(110),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_A_Q(ntryL,G1H2(110),47,nME,G2H2(461),n2h2(350))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(434),-16,nME,G2H4(35),n2h4(244))
  call Hloop_QV_A(ntryL,G2H4(35),ex5(:),G2H2(462),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_AV_Q(ntryL,G1H4(437),ex4(:),G1H2(115),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_A_Q(ntryL,G1H2(115),47,nME,G2H2(463),n2h2(351))
  call Hloop_AV_Q(ntryL,G1H4(438),ex4(:),G1H2(116),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_A_Q(ntryL,G1H2(116),47,nME,G2H2(464),n2h2(352))
  call Hloop_AV_Q(ntryL,G1H4(225),ex5(:),G1H2(121),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_A_Q(ntryL,G1H2(121),55,nME,G2H2(465),n2h2(353))
call HGT_OLR(G1H4(226),1,1,4)
call HGT_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(226),-8,nME,G2H4(38),n2h4(245))
  call Hloop_QV_A(ntryL,G2H4(38),ex4(:),G2H2(466),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_AV_Q(ntryL,G1H4(440),ex5(:),G1H2(122),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_A_Q(ntryL,G1H2(122),55,nME,G2H2(467),n2h2(354))
  call Hloop_AV_Q(ntryL,G1H4(441),ex5(:),G1H2(127),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_A_Q(ntryL,G1H2(127),55,nME,G2H2(468),n2h2(355))
  call Hloop_AV_Q(ntryL,G1H4(442),ex5(:),G1H2(128),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_A_Q(ntryL,G1H2(128),55,nME,G2H2(469),n2h2(356))
call HGT_OLR(G1H4(443),1,1,4)
call HGT_invQ_OLR(G1H4(443),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(443),-8,nME,G2H4(42),n2h4(246))
  call Hloop_QV_A(ntryL,G2H4(42),ex4(:),G2H2(470),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_AV_Q(ntryL,G1H4(446),ex5(:),G1H2(133),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(133),55,nME,G2H2(471),n2h2(357))
  call Hloop_AV_Q(ntryL,G1H4(447),ex5(:),G1H2(134),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_A_Q(ntryL,G1H2(134),55,nME,G2H2(472),n2h2(358))
  call Hloop_AV_Q(ntryL,G1H4(237),ex3(:),G1H2(139),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_A_Q(ntryL,G1H2(139),47,nME,G2H2(473),n2h2(359))
call HGT_OLR(G1H4(238),1,1,4)
call HGT_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(238),-16,nME,G2H4(43),n2h4(247))
  call Hloop_QV_A(ntryL,G2H4(43),ex5(:),G2H2(474),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_AV_Q(ntryL,G1H4(449),ex3(:),G1H2(140),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(140),47,nME,G2H2(475),n2h2(360))
  call Hloop_AV_Q(ntryL,G1H4(450),ex3(:),G1H2(1),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(476),n2h2(361))
  call Hloop_AV_Q(ntryL,G1H4(451),ex3(:),G1H2(2),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(477),n2h2(362))
call HGT_OLR(G1H4(452),1,1,4)
call HGT_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(452),-16,nME,G2H4(46),n2h4(248))
  call Hloop_QV_A(ntryL,G2H4(46),ex5(:),G2H2(478),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_AV_Q(ntryL,G1H4(455),ex3(:),G1H2(7),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(479),n2h2(363))
  call Hloop_AV_Q(ntryL,G1H4(456),ex3(:),G1H2(8),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(480),n2h2(364))
  call Hloop_AV_Q(ntryL,G1H4(249),ex5(:),G1H2(13),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(13),59,nME,G2H2(481),n2h2(365))
call HGT_OLR(G1H4(250),1,1,4)
call HGT_invQ_OLR(G1H4(250),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(250),-4,nME,G2H4(47),n2h4(249))
  call Hloop_QV_A(ntryL,G2H4(47),ex3(:),G2H2(482),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_AV_Q(ntryL,G1H4(458),ex5(:),G1H2(14),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_A_Q(ntryL,G1H2(14),59,nME,G2H2(483),n2h2(366))
  call Hloop_AV_Q(ntryL,G1H4(459),ex5(:),G1H2(19),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_A_Q(ntryL,G1H2(19),59,nME,G2H2(484),n2h2(367))
  call Hloop_AV_Q(ntryL,G1H4(460),ex5(:),G1H2(20),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_A_Q(ntryL,G1H2(20),59,nME,G2H2(485),n2h2(368))
call HGT_OLR(G1H4(461),1,1,4)
call HGT_invQ_OLR(G1H4(461),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(461),-4,nME,G2H4(50),n2h4(250))
  call Hloop_QV_A(ntryL,G2H4(50),ex3(:),G2H2(486),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_AV_Q(ntryL,G1H4(464),ex5(:),G1H2(25),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_A_Q(ntryL,G1H2(25),59,nME,G2H2(487),n2h2(369))
  call Hloop_AV_Q(ntryL,G1H4(465),ex5(:),G1H2(26),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_A_Q(ntryL,G1H2(26),59,nME,G2H2(488),n2h2(370))
  call Hloop_AV_Q(ntryL,G1H4(261),ex3(:),G1H2(31),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_A_Q(ntryL,G1H2(31),55,nME,G2H2(489),n2h2(371))
call HGT_OLR(G1H4(262),1,1,4)
call HGT_invQ_OLR(G1H4(262),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(262),-8,nME,G2H4(51),n2h4(251))
  call Hloop_QV_A(ntryL,G2H4(51),ex4(:),G2H2(490),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_AV_Q(ntryL,G1H4(467),ex3(:),G1H2(32),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_A_Q(ntryL,G1H2(32),55,nME,G2H2(491),n2h2(372))
  call Hloop_AV_Q(ntryL,G1H4(468),ex3(:),G1H2(37),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_A_Q(ntryL,G1H2(37),55,nME,G2H2(492),n2h2(373))
  call Hloop_AV_Q(ntryL,G1H4(469),ex3(:),G1H2(38),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_A_Q(ntryL,G1H2(38),55,nME,G2H2(493),n2h2(374))
call HGT_OLR(G1H4(470),1,1,4)
call HGT_invQ_OLR(G1H4(470),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(470),-8,nME,G2H4(54),n2h4(252))
  call Hloop_QV_A(ntryL,G2H4(54),ex4(:),G2H2(494),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_AV_Q(ntryL,G1H4(473),ex3(:),G1H2(43),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_A_Q(ntryL,G1H2(43),55,nME,G2H2(495),n2h2(375))
  call Hloop_AV_Q(ntryL,G1H4(474),ex3(:),G1H2(44),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_A_Q(ntryL,G1H2(44),55,nME,G2H2(496),n2h2(376))
  call Hloop_AV_Q(ntryL,G1H4(273),ex4(:),G1H2(49),m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_A_Q(ntryL,G1H2(49),59,nME,G2H2(497),n2h2(377))
call HGT_OLR(G1H4(274),1,1,4)
call HGT_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(274),-4,nME,G2H4(55),n2h4(253))
  call Hloop_QV_A(ntryL,G2H4(55),ex3(:),G2H2(498),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_AV_Q(ntryL,G1H4(476),ex4(:),G1H2(50),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_A_Q(ntryL,G1H2(50),59,nME,G2H2(499),n2h2(378))
  call Hloop_AV_Q(ntryL,G1H4(477),ex4(:),G1H2(55),m3h2x2(:,524),heltab2x4(:,:,524))
  call Hloop_A_Q(ntryL,G1H2(55),59,nME,G2H2(500),n2h2(379))
  call Hloop_AV_Q(ntryL,G1H4(478),ex4(:),G1H2(56),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_A_Q(ntryL,G1H2(56),59,nME,G2H2(501),n2h2(380))
call HGT_OLR(G1H4(479),1,1,4)
call HGT_invQ_OLR(G1H4(479),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(479),-4,nME,G2H4(58),n2h4(254))
  call Hloop_QV_A(ntryL,G2H4(58),ex3(:),G2H2(502),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_AV_Q(ntryL,G1H4(482),ex4(:),G1H2(61),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_A_Q(ntryL,G1H2(61),59,nME,G2H2(503),n2h2(381))
  call Hloop_AV_Q(ntryL,G1H4(483),ex4(:),G1H2(62),m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_A_Q(ntryL,G1H2(62),59,nME,G2H2(504),n2h2(382))
  call Hloop_VQ_A(ntryL,G1H8(40),wf4(:,3),G1H2(67),m3h4x2(:,1),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(67),47,nME,G2H2(505),n2h2(383))
call HGT_OLR(G1H8(45),1,1,8)
call HGT_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(45),-16,nME,G2H8(31),n2h8(103))
  call Hloop_AV_Q(ntryL,G2H8(31),ex5(:),G2H4(59),m3h2x4(:,185),heltab2x8(:,:,186))
  call Hloop_VQ_A(ntryL,G1H8(63),wf4(:,3),G1H2(68),m3h4x2(:,2),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(68),47,nME,G2H2(506),n2h2(384))
  call Hloop_VQ_A(ntryL,G1H8(69),wf4(:,3),G1H2(73),m3h4x2(:,3),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(73),47,nME,G2H2(507),n2h2(385))
  call Hloop_VA_Q(ntryL,G1H8(75),wf4(:,12),G1H2(74),m3h4x2(:,4),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(74),47,nME,G2H2(508),n2h2(386))
call HGT_OLR(G1H8(81),1,1,8)
call HGT_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(81),-16,nME,G2H8(35),n2h8(104))
  call Hloop_QV_A(ntryL,G2H8(35),ex5(:),G2H4(62),m3h2x4(:,186),heltab2x8(:,:,190))
  call Hloop_VA_Q(ntryL,G1H8(99),wf4(:,12),G1H2(79),m3h4x2(:,5),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(79),47,nME,G2H2(509),n2h2(387))
  call Hloop_VA_Q(ntryL,G1H8(105),wf4(:,12),G1H2(80),m3h4x2(:,6),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(80),47,nME,G2H2(510),n2h2(388))
  call Hloop_VQ_A(ntryL,G1H8(3),wf4(:,11),G1H2(85),m3h4x2(:,7),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(85),47,nME,G2H2(511),n2h2(389))
call HGT_OLR(G1H8(18),1,1,8)
call HGT_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(18),-16,nME,G2H8(41),n2h8(105))
  call Hloop_AV_Q(ntryL,G2H8(41),ex5(:),G2H4(63),m3h2x4(:,187),heltab2x8(:,:,194))
  call Hloop_VQ_A(ntryL,G1H8(15),wf4(:,11),G1H2(86),m3h4x2(:,8),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(86),47,nME,G2H2(512),n2h2(390))
  call Hloop_VQ_A(ntryL,G1H8(12),wf4(:,11),G1H2(91),m3h4x2(:,9),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(91),47,nME,G2H2(513),n2h2(391))
  call Hloop_VA_Q(ntryL,G1H8(29),wf4(:,4),G1H2(92),m3h4x2(:,10),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(514),n2h2(392))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-16,nME,G2H8(40),n2h8(106))
  call Hloop_QV_A(ntryL,G2H8(40),ex5(:),G2H4(66),m3h2x4(:,188),heltab2x8(:,:,198))
  call Hloop_VA_Q(ntryL,G1H8(33),wf4(:,4),G1H2(97),m3h4x2(:,11),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(97),47,nME,G2H2(515),n2h2(393))
  call Hloop_VA_Q(ntryL,G1H8(17),wf4(:,4),G1H2(98),m3h4x2(:,12),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(98),47,nME,G2H2(516),n2h2(394))
  call Hloop_VQ_A(ntryL,G1H8(39),wf4(:,14),G1H2(103),m3h4x2(:,13),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(103),55,nME,G2H2(517),n2h2(395))
call HGT_OLR(G1H8(13),1,1,8)
call HGT_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(13),-8,nME,G2H8(45),n2h8(107))
  call Hloop_AV_Q(ntryL,G2H8(45),ex4(:),G2H4(67),m3h2x4(:,189),heltab2x8(:,:,202))
  call Hloop_VQ_A(ntryL,G1H8(32),wf4(:,14),G1H2(104),m3h4x2(:,14),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(104),55,nME,G2H2(518),n2h2(396))
  call Hloop_VQ_A(ntryL,G1H8(52),wf4(:,14),G1H2(109),m3h4x2(:,15),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(109),55,nME,G2H2(519),n2h2(397))
  call Hloop_VA_Q(ntryL,G1H8(57),wf4(:,6),G1H2(110),m3h4x2(:,16),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(110),55,nME,G2H2(520),n2h2(398))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-8,nME,G2H8(46),n2h8(108))
  call Hloop_QV_A(ntryL,G2H8(46),ex4(:),G2H4(70),m3h2x4(:,190),heltab2x8(:,:,206))
  call Hloop_VA_Q(ntryL,G1H8(36),wf4(:,6),G1H2(115),m3h4x2(:,17),heltab2x8(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(115),55,nME,G2H2(521),n2h2(399))
  call Hloop_VA_Q(ntryL,G1H8(70),wf4(:,6),G1H2(116),m3h4x2(:,18),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(116),55,nME,G2H2(522),n2h2(400))
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(6)])
call HGT_OLR(G2H2(4),1,1,2)
call HGT_invQ_OLR(G2H2(4),2,5,2)
call HGT_OLR(G2H2(4),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(169)])
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(12)])
call HGT_OLR(G2H2(9),1,1,2)
call HGT_invQ_OLR(G2H2(9),2,5,2)
call HGT_OLR(G2H2(9),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(172)])
call HGT_OLR(G2H2(12),1,1,2)
call HGT_invQ_OLR(G2H2(12),2,5,2)
call HGT_OLR(G2H2(12),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(18)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(175)])
call HGT_OLR(G2H2(17),1,1,2)
call HGT_invQ_OLR(G2H2(17),2,5,2)
call HGT_OLR(G2H2(17),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(24)])
call HGT_OLR(G2H2(19),1,1,2)
call HGT_invQ_OLR(G2H2(19),2,5,2)
call HGT_OLR(G2H2(19),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(178)])
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(30)])
call HGT_OLR(G2H2(24),1,1,2)
call HGT_invQ_OLR(G2H2(24),2,5,2)
call HGT_OLR(G2H2(24),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(181)])
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(36)])
call HGT_OLR(G2H2(29),1,1,2)
call HGT_invQ_OLR(G2H2(29),2,5,2)
call HGT_OLR(G2H2(29),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(184)])
call HGT_OLR(G2H2(32),1,1,2)
call HGT_invQ_OLR(G2H2(32),2,5,2)
call HGT_OLR(G2H2(32),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(505),[G2H2(33),G1H2(42)])
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(507),[G2H2(35)])
call HGT_OLR(G2H2(37),1,1,2)
call HGT_invQ_OLR(G2H2(37),2,5,2)
call HGT_OLR(G2H2(37),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(514),[G2H2(38),G1H2(48)])
call HGT_OLR(G2H2(39),1,1,2)
call HGT_invQ_OLR(G2H2(39),2,5,2)
call HGT_OLR(G2H2(39),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(516),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G1H2(3)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(520),[G2H2(43),G1H2(54)])
call HGT_OLR(G2H2(44),1,1,2)
call HGT_invQ_OLR(G2H2(44),2,5,2)
call HGT_OLR(G2H2(44),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(522),[G2H2(45)])
call HGT_OLR(G2H2(47),1,1,2)
call HGT_invQ_OLR(G2H2(47),2,5,2)
call HGT_OLR(G2H2(47),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(48),G1H2(84),G1H2(60)])
call HGT_OLR(G2H2(49),1,1,2)
call HGT_invQ_OLR(G2H2(49),2,5,2)
call HGT_OLR(G2H2(49),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G1H2(39)])
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(53),G1H2(102),G1H2(66)])
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(55)])
call HGT_OLR(G2H2(57),1,1,2)
call HGT_invQ_OLR(G2H2(57),2,5,2)
call HGT_OLR(G2H2(57),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(508),[G2H2(58),G1H2(72)])
call HGT_OLR(G2H2(59),1,1,2)
call HGT_invQ_OLR(G2H2(59),2,5,2)
call HGT_OLR(G2H2(59),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(510),[G2H2(60)])
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(511),[G2H2(63),G1H2(78)])
call HGT_OLR(G2H2(64),1,1,2)
call HGT_invQ_OLR(G2H2(64),2,5,2)
call HGT_OLR(G2H2(64),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(513),[G2H2(65)])
call HGT_OLR(G2H2(67),1,1,2)
call HGT_invQ_OLR(G2H2(67),2,5,2)
call HGT_OLR(G2H2(67),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(265)])
call HGT_OLR(G2H2(69),1,1,2)
call HGT_invQ_OLR(G2H2(69),2,5,2)
call HGT_OLR(G2H2(69),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G1H2(75)])
call HGT_OLR(G2H2(72),1,1,2)
call HGT_invQ_OLR(G2H2(72),2,5,2)
call HGT_OLR(G2H2(72),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(73),G1H2(108),G1H2(90)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(281),[G1H2(21)])
call HGT_OLR(G2H2(77),1,1,2)
call HGT_invQ_OLR(G2H2(77),2,5,2)
call HGT_OLR(G2H2(77),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(517),[G2H2(78),G1H2(96)])
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(519),[G2H2(80)])
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(289)])
call HGT_OLR(G2H2(84),1,1,2)
call HGT_invQ_OLR(G2H2(84),2,5,2)
call HGT_OLR(G2H2(84),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G1H2(93)])
call HGT_OLR(G2H2(87),1,1,2)
call HGT_invQ_OLR(G2H2(87),2,5,2)
call HGT_OLR(G2H2(87),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(297)])
call HGT_OLR(G2H2(89),1,1,2)
call HGT_invQ_OLR(G2H2(89),2,5,2)
call HGT_OLR(G2H2(89),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(300)])
call HGT_OLR(G2H2(92),1,1,2)
call HGT_invQ_OLR(G2H2(92),2,5,2)
call HGT_OLR(G2H2(92),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(93),G1H2(126),G1H2(114)])
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(313),[G1H2(69)])
call HGT_OLR(G2H2(97),1,1,2)
call HGT_invQ_OLR(G2H2(97),2,5,2)
call HGT_OLR(G2H2(97),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(98),G1H2(138),G1H2(120)])
call HGT_OLR(G2H2(99),1,1,2)
call HGT_invQ_OLR(G2H2(99),2,5,2)
call HGT_OLR(G2H2(99),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(100)])
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(321)])
call HGT_OLR(G2H2(104),1,1,2)
call HGT_invQ_OLR(G2H2(104),2,5,2)
call HGT_OLR(G2H2(104),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(329),[G1H2(45)])
call HGT_OLR(G2H2(107),1,1,2)
call HGT_invQ_OLR(G2H2(107),2,5,2)
call HGT_OLR(G2H2(107),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(108),G1H2(144),G1H2(132)])
call HGT_OLR(G2H2(109),1,1,2)
call HGT_invQ_OLR(G2H2(109),2,5,2)
call HGT_OLR(G2H2(109),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(110)])
call HGT_OLR(G2H2(112),1,1,2)
call HGT_invQ_OLR(G2H2(112),2,5,2)
call HGT_OLR(G2H2(112),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(337)])
call HGT_OLR(G2H2(114),1,1,2)
call HGT_invQ_OLR(G2H2(114),2,5,2)
call HGT_OLR(G2H2(114),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(345),[G1H2(51)])
call HGT_OLR(G2H2(117),1,1,2)
call HGT_invQ_OLR(G2H2(117),2,5,2)
call HGT_OLR(G2H2(117),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(345)])
call HGT_OLR(G2H2(119),1,1,2)
call HGT_invQ_OLR(G2H2(119),2,5,2)
call HGT_OLR(G2H2(119),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G2H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(353),[G1H2(10),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(185),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(357),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(361),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(365),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(369),[G1H2(28),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(373),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(377),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(381),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(385),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(389),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(393),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(229),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(397),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(401),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(409),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(413),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(253),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(417),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(421),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(425),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(429),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(433),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(437),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(441),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(445),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(293),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(449),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(301),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(457),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(461),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(309),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(465),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(469),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(317),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(473),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(477),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(325),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(481),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(485),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(333),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(489),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(493),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(341),[G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(497),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(501),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(349),[G1H2(143)])
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(32),mass5set(:,1),  & 
G1H2(121),G1H2(122),G1H2(127),G1H2(128),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(122),2,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(17),mass5set(:,4),  & 
G1H2(139),G1H2(140),G1H2(1),G1H2(2),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(140),16,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(215),mass4set(:,1),  & 
G1H2(13),G1H2(14),G1H2(19),G1H2(20),G1H2(25),2)
  call HG1shiftOLR(G1H2(14),3,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(13),mass4set(:,1),  & 
G1H2(26),G1H2(31),G1H2(32),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(31),19,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(33),mass5set(:,1),  & 
G1H2(43),G1H2(44),G1H2(49),G1H2(50),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(44),2,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(18),mass5set(:,4),  & 
G1H2(61),G1H2(62),G1H2(67),G1H2(68),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(216),mass4set(:,1),  & 
G1H2(79),G1H2(80),G1H2(85),G1H2(86),G1H2(91),2)
  call HG1shiftOLR(G1H2(80),3,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(23),mass4set(:,1),  & 
G1H2(92),G1H2(97),G1H2(98),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(97),19,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(34),mass5set(:,1),  & 
G1H2(109),G1H2(110),G1H2(115),G1H2(116),G1H2(6),G1H2(12),2)
  call HG1shiftOLR(G1H2(110),1,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(19),mass5set(:,4),  & 
G1H2(18),G1H2(24),G1H2(30),G1H2(36),G1H2(42),G1H2(48),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(217),mass4set(:,1),  & 
G1H2(3),G1H2(54),G1H2(84),G1H2(60),G1H2(39),2)
  call HG1shiftOLR(G1H2(54),3,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(38),mass4set(:,1),  & 
G1H2(102),G1H2(66),G1H2(72),G1H2(78),G1H2(75),2)
  call HG1shiftOLR(G1H2(66),11,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(35),mass5set(:,1),  & 
G1H2(108),G1H2(90),G1H2(21),G1H2(96),G1H2(93),G1H2(126),2)
  call HG1shiftOLR(G1H2(90),1,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(17),mass5set(:,4),  & 
G1H2(114),G1H2(69),G1H2(138),G1H2(120),G1H2(45),G1H2(144),2)
  call HG1shiftOLR(G1H2(69),16,2)
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(215),mass4set(:,1),  & 
G1H2(132),G1H2(51),G1H2(10),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(51),3,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(13),mass4set(:,1),  & 
G1H2(9),G1H2(11),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(11),19,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(36),mass5set(:,1),  & 
G1H2(28),G1H2(22),G1H2(23),G1H2(27),G1H2(29),G1H2(33),2)
  call HG1shiftOLR(G1H2(22),1,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(18),mass5set(:,4),  & 
G1H2(34),G1H2(35),G1H2(40),G1H2(41),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(216),mass4set(:,1),  & 
G1H2(52),G1H2(53),G1H2(57),G1H2(58),G1H2(59),2)
  call HG1shiftOLR(G1H2(53),3,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(23),mass4set(:,1),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(70),G1H2(71),2)
  call HG1shiftOLR(G1H2(64),19,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(37),mass5set(:,1),  & 
G1H2(76),G1H2(77),G1H2(81),G1H2(82),G1H2(83),G1H2(87),2)
  call HG1shiftOLR(G1H2(77),2,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(19),mass5set(:,4),  & 
G1H2(88),G1H2(89),G1H2(94),G1H2(95),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(89),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(217),mass4set(:,1),  & 
G1H2(101),G1H2(105),G1H2(106),G1H2(107),G1H2(111),2)
  call HG1shiftOLR(G1H2(105),3,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(38),mass4set(:,1),  & 
G1H2(112),G1H2(113),G1H2(117),G1H2(118),G1H2(119),2)
  call HG1shiftOLR(G1H2(113),11,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(44),mass5set(:,2),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(129),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(124),4,2)
  call Hotf_5pt_reduction(G2H2(505),RedSet_5(20),mass5set(:,2),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(136),16,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(218),mass4set(:,2),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(146),5,2)
  call Hotf_4pt_reduction(G2H2(507),RedSet_4(78),mass4set(:,2),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(151),21,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(46),mass5set(:,2),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hotf_5pt_reduction(G2H2(514),RedSet_5(21),mass5set(:,2),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),16,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(219),mass4set(:,2),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),10,2)
  call Hotf_4pt_reduction(G2H2(516),RedSet_4(91),mass4set(:,2),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(173),26,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(48),mass5set(:,2),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),16,2)
  call Hotf_5pt_reduction(G2H2(520),RedSet_5(22),mass5set(:,2),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(4),mass4set(:,2),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),18,2)
  call Hotf_4pt_reduction(G2H2(522),RedSet_4(91),mass4set(:,2),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),26,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(50),mass5set(:,3),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(23),mass5set(:,3),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),16,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(220),mass4set(:,3),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(212),12,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(113),mass4set(:,3),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(217),28,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(52),mass5set(:,3),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),16,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(24),mass5set(:,3),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(70),mass4set(:,3),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),2)
  call HG1shiftOLR(G1H2(234),20,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(113),mass4set(:,3),  & 
G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(239),28,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(54),mass5set(:,2),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),G1H2(248),2)
  call HG1shiftOLR(G1H2(244),4,2)
  call Hotf_5pt_reduction(G2H2(508),RedSet_5(25),mass5set(:,2),  & 
G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(250),16,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(221),mass4set(:,2),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(256),6,2)
  call Hotf_4pt_reduction(G2H2(510),RedSet_4(131),mass4set(:,2),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(261),22,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(55),mass5set(:,2),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),8,2)
  call Hotf_5pt_reduction(G2H2(511),RedSet_5(26),mass5set(:,2),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),16,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(222),mass4set(:,2),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),2)
  call HG1shiftOLR(G1H2(278),9,2)
  call Hotf_4pt_reduction(G2H2(513),RedSet_4(140),mass4set(:,2),  & 
G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(283),25,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(56),mass5set(:,3),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),4,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(220),mass4set(:,3),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),2)
  call HG1shiftOLR(G1H2(294),12,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(58),mass5set(:,3),  & 
G1H2(298),G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),2)
  call HG1shiftOLR(G1H2(299),16,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(27),mass5set(:,3),  & 
G1H2(304),G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),2)
  call HG1shiftOLR(G1H2(305),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(135),mass4set(:,3),  & 
G1H2(310),G1H2(311),G1H2(312),G1H2(313),G1H2(314),2)
  call HG1shiftOLR(G1H2(311),24,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(113),mass4set(:,3),  & 
G1H2(315),G1H2(316),G1H2(317),G1H2(318),G1H2(319),2)
  call HG1shiftOLR(G1H2(316),28,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(60),mass5set(:,2),  & 
G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),G1H2(325),2)
  call HG1shiftOLR(G1H2(321),16,2)
  call Hotf_5pt_reduction(G2H2(517),RedSet_5(28),mass5set(:,2),  & 
G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(327),8,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(43),mass4set(:,2),  & 
G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(333),17,2)
  call Hotf_4pt_reduction(G2H2(519),RedSet_4(140),mass4set(:,2),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),2)
  call HG1shiftOLR(G1H2(338),25,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(61),mass5set(:,3),  & 
G1H2(342),G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),2)
  call HG1shiftOLR(G1H2(343),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(70),mass4set(:,3),  & 
G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(349),20,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(63),mass5set(:,3),  & 
G1H2(353),G1H2(354),G1H2(355),G1H2(356),G1H2(357),G1H2(358),2)
  call HG1shiftOLR(G1H2(354),8,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(135),mass4set(:,3),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),2)
  call HG1shiftOLR(G1H2(360),24,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(65),mass5set(:,3),  & 
G1H2(364),G1H2(365),G1H2(366),G1H2(367),G1H2(368),G1H2(369),2)
  call HG1shiftOLR(G1H2(365),8,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(29),mass5set(:,3),  & 
G1H2(370),G1H2(371),G1H2(372),G1H2(373),G1H2(374),G1H2(375),2)
  call HG1shiftOLR(G1H2(371),16,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(223),mass4set(:,3),  & 
G1H2(376),G1H2(377),G1H2(378),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(377),12,2)
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(188),mass4set(:,3),  & 
G1H2(381),G1H2(382),G1H2(383),G1H2(384),G1H2(385),2)
  call HG1shiftOLR(G1H2(382),28,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(67),mass5set(:,3),  & 
G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),G1H2(391),2)
  call HG1shiftOLR(G1H2(387),16,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(30),mass5set(:,3),  & 
G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),G1H2(397),2)
  call HG1shiftOLR(G1H2(393),8,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(126),mass4set(:,3),  & 
G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(399),20,2)
  call Hotf_4pt_reduction(G2H2(115),RedSet_4(188),mass4set(:,3),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),2)
  call HG1shiftOLR(G1H2(404),28,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(69),mass5set(:,3),  & 
G1H2(408),G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),2)
  call HG1shiftOLR(G1H2(409),4,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(223),mass4set(:,3),  & 
G1H2(414),G1H2(415),G1H2(416),G1H2(417),G1H2(418),2)
  call HG1shiftOLR(G1H2(415),12,2)
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(71),mass5set(:,3),  & 
G1H2(419),G1H2(420),G1H2(421),G1H2(422),G1H2(423),G1H2(424),2)
  call HG1shiftOLR(G1H2(420),16,2)
  call Hotf_5pt_reduction(G2H2(118),RedSet_5(31),mass5set(:,3),  & 
G1H2(425),G1H2(426),G1H2(427),G1H2(428),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(426),4,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(83),mass4set(:,3),  & 
G1H2(431),G1H2(432),G1H2(433),G1H2(434),G1H2(435),2)
  call HG1shiftOLR(G1H2(432),24,2)
  call Hotf_4pt_reduction(G2H2(120),RedSet_4(188),mass4set(:,3),  & 
G1H2(436),G1H2(437),G1H2(438),G1H2(439),G1H2(440),2)
  call HG1shiftOLR(G1H2(437),28,2)
  call Hotf_5pt_reduction(G2H2(112),RedSet_5(73),mass5set(:,3),  & 
G1H2(441),G1H2(442),G1H2(443),G1H2(444),G1H2(445),G1H2(446),2)
  call HG1shiftOLR(G1H2(442),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(126),mass4set(:,3),  & 
G1H2(447),G1H2(448),G1H2(449),G1H2(450),G1H2(451),2)
  call HG1shiftOLR(G1H2(448),20,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(75),mass5set(:,3),  & 
G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),G1H2(457),2)
  call HG1shiftOLR(G1H2(453),8,2)
  call Hotf_4pt_reduction(G2H2(119),RedSet_4(83),mass4set(:,3),  & 
G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(459),24,2)
  call Hotf_5pt_reduction(G2H2(353),RedSet_5(77),mass5set(:,2),  & 
G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(464),16,2)
  call Hotf_5pt_reduction(G2H2(185),RedSet_5(38),mass5set(:,2),  & 
G1H2(469),G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(470),16,2)
  call Hotf_5pt_reduction(G2H2(357),RedSet_5(78),mass5set(:,2),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),16,2)
  call Hotf_5pt_reduction(G2H2(189),RedSet_5(39),mass5set(:,2),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(482),16,2)
  call Hotf_5pt_reduction(G2H2(361),RedSet_5(79),mass5set(:,2),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),8,2)
  call Hotf_5pt_reduction(G2H2(365),RedSet_5(80),mass5set(:,2),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(494),8,2)
  call Hotf_5pt_reduction(G2H2(193),RedSet_5(40),mass5set(:,2),  & 
G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),G1H2(504),2)
  call HG1shiftOLR(G1H2(500),8,2)
  call Hotf_5pt_reduction(G2H2(369),RedSet_5(81),mass5set(:,2),  & 
G1H2(505),G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),2)
  call HG1shiftOLR(G1H2(506),16,2)
  call Hotf_5pt_reduction(G2H2(197),RedSet_5(41),mass5set(:,2),  & 
G1H2(511),G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),2)
  call HG1shiftOLR(G1H2(512),16,2)
  call Hotf_5pt_reduction(G2H2(373),RedSet_5(82),mass5set(:,2),  & 
G1H2(517),G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),2)
  call HG1shiftOLR(G1H2(518),16,2)
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(42),mass5set(:,2),  & 
G1H2(523),G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(524),16,2)
  call Hotf_5pt_reduction(G2H2(377),RedSet_5(83),mass5set(:,2),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(530),8,2)
  call Hotf_5pt_reduction(G2H2(381),RedSet_5(84),mass5set(:,2),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),2)
  call HG1shiftOLR(G1H2(536),8,2)
  call Hotf_5pt_reduction(G2H2(205),RedSet_5(43),mass5set(:,2),  & 
G1H2(541),G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(542),8,2)
  call Hotf_5pt_reduction(G2H2(385),RedSet_5(85),mass5set(:,3),  & 
G1H2(547),G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),2)
  call HG1shiftOLR(G1H2(548),16,2)
  call Hotf_5pt_reduction(G2H2(213),RedSet_5(45),mass5set(:,4),  & 
G1H2(553),G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),2)
  call HG1shiftOLR(G1H2(554),16,2)
  call Hotf_5pt_reduction(G2H2(389),RedSet_5(86),mass5set(:,3),  & 
G1H2(559),G1H2(560),G1H2(561),G1H2(562),G1H2(563),G1H2(564),2)
  call HG1shiftOLR(G1H2(560),16,2)
  call Hotf_5pt_reduction(G2H2(221),RedSet_5(47),mass5set(:,4),  & 
G1H2(565),G1H2(566),G1H2(567),G1H2(568),G1H2(569),G1H2(570),2)
  call HG1shiftOLR(G1H2(566),16,2)
  call Hotf_5pt_reduction(G2H2(393),RedSet_5(87),mass5set(:,3),  & 
G1H2(571),G1H2(572),G1H2(573),G1H2(574),G1H2(575),G1H2(576),2)
  call HG1shiftOLR(G1H2(572),8,2)
  call Hotf_5pt_reduction(G2H2(229),RedSet_5(49),mass5set(:,4),  & 
G1H2(577),G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),2)
  call HG1shiftOLR(G1H2(578),8,2)
  call Hotf_5pt_reduction(G2H2(397),RedSet_5(88),mass5set(:,5),  & 
G1H2(583),G1H2(584),G1H2(585),G1H2(586),G1H2(587),G1H2(588),2)
  call HG1shiftOLR(G1H2(584),16,2)
  call Hotf_5pt_reduction(G2H2(401),RedSet_5(89),mass5set(:,4),  & 
G1H2(589),G1H2(590),G1H2(591),G1H2(592),G1H2(593),G1H2(594),2)
  call HG1shiftOLR(G1H2(590),16,2)
  call Hotf_5pt_reduction(G2H2(237),RedSet_5(51),mass5set(:,3),  & 
G1H2(595),G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),2)
  call HG1shiftOLR(G1H2(596),16,2)
  call Hotf_5pt_reduction(G2H2(405),RedSet_5(90),mass5set(:,5),  & 
G1H2(601),G1H2(602),G1H2(603),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(602),8,2)
  call Hotf_5pt_reduction(G2H2(409),RedSet_5(91),mass5set(:,4),  & 
G1H2(607),G1H2(608),G1H2(609),G1H2(610),G1H2(611),G1H2(612),2)
  call HG1shiftOLR(G1H2(608),8,2)
  call Hotf_5pt_reduction(G2H2(245),RedSet_5(53),mass5set(:,3),  & 
G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(614),8,2)
  call Hotf_5pt_reduction(G2H2(413),RedSet_5(92),mass5set(:,3),  & 
G1H2(619),G1H2(620),G1H2(621),G1H2(622),G1H2(623),G1H2(624),2)
  call HG1shiftOLR(G1H2(620),16,2)
  call Hotf_5pt_reduction(G2H2(253),RedSet_5(45),mass5set(:,4),  & 
G1H2(625),G1H2(626),G1H2(627),G1H2(628),G1H2(629),G1H2(630),2)
  call HG1shiftOLR(G1H2(626),16,2)
  call Hotf_5pt_reduction(G2H2(417),RedSet_5(93),mass5set(:,3),  & 
G1H2(631),G1H2(632),G1H2(633),G1H2(634),G1H2(635),G1H2(636),2)
  call HG1shiftOLR(G1H2(632),16,2)
  call Hotf_5pt_reduction(G2H2(261),RedSet_5(47),mass5set(:,4),  & 
G1H2(637),G1H2(638),G1H2(639),G1H2(640),G1H2(641),G1H2(642),2)
  call HG1shiftOLR(G1H2(638),16,2)
  call Hotf_5pt_reduction(G2H2(421),RedSet_5(94),mass5set(:,5),  & 
G1H2(643),G1H2(644),G1H2(645),G1H2(646),G1H2(647),G1H2(648),2)
  call HG1shiftOLR(G1H2(644),16,2)
  call Hotf_5pt_reduction(G2H2(425),RedSet_5(95),mass5set(:,4),  & 
G1H2(649),G1H2(650),G1H2(651),G1H2(652),G1H2(653),G1H2(654),2)
  call HG1shiftOLR(G1H2(650),16,2)
  call Hotf_5pt_reduction(G2H2(269),RedSet_5(57),mass5set(:,3),  & 
G1H2(655),G1H2(656),G1H2(657),G1H2(658),G1H2(659),G1H2(660),2)
  call HG1shiftOLR(G1H2(656),16,2)
  call Hotf_5pt_reduction(G2H2(429),RedSet_5(96),mass5set(:,5),  & 
G1H2(661),G1H2(662),G1H2(663),G1H2(664),G1H2(665),G1H2(666),2)
  call HG1shiftOLR(G1H2(662),4,2)
  call Hotf_5pt_reduction(G2H2(433),RedSet_5(97),mass5set(:,4),  & 
G1H2(667),G1H2(668),G1H2(669),G1H2(670),G1H2(671),G1H2(672),2)
  call HG1shiftOLR(G1H2(668),4,2)
  call Hotf_5pt_reduction(G2H2(277),RedSet_5(59),mass5set(:,3),  & 
G1H2(673),G1H2(674),G1H2(675),G1H2(676),G1H2(677),G1H2(678),2)
  call HG1shiftOLR(G1H2(674),4,2)
  call Hotf_5pt_reduction(G2H2(437),RedSet_5(98),mass5set(:,3),  & 
G1H2(679),G1H2(680),G1H2(681),G1H2(682),G1H2(683),G1H2(684),2)
  call HG1shiftOLR(G1H2(680),8,2)
  call Hotf_5pt_reduction(G2H2(285),RedSet_5(49),mass5set(:,4),  & 
G1H2(685),G1H2(686),G1H2(687),G1H2(688),G1H2(689),G1H2(690),2)
  call HG1shiftOLR(G1H2(686),8,2)
  call Hotf_5pt_reduction(G2H2(441),RedSet_5(99),mass5set(:,5),  & 
G1H2(691),G1H2(692),G1H2(693),G1H2(694),G1H2(695),G1H2(696),2)
  call HG1shiftOLR(G1H2(692),8,2)
  call Hotf_5pt_reduction(G2H2(445),RedSet_5(100),mass5set(:,4),  & 
G1H2(697),G1H2(698),G1H2(699),G1H2(700),G1H2(701),G1H2(702),2)
  call HG1shiftOLR(G1H2(698),8,2)
  call Hotf_5pt_reduction(G2H2(293),RedSet_5(62),mass5set(:,3),  & 
G1H2(703),G1H2(704),G1H2(705),G1H2(706),G1H2(707),G1H2(708),2)
  call HG1shiftOLR(G1H2(704),8,2)
  call Hotf_5pt_reduction(G2H2(449),RedSet_5(101),mass5set(:,5),  & 
G1H2(709),G1H2(710),G1H2(711),G1H2(712),G1H2(713),G1H2(714),2)
  call HG1shiftOLR(G1H2(710),4,2)
  call Hotf_5pt_reduction(G2H2(453),RedSet_5(102),mass5set(:,4),  & 
G1H2(715),G1H2(716),G1H2(717),G1H2(718),G1H2(719),G1H2(720),2)
  call HG1shiftOLR(G1H2(716),4,2)
  call Hotf_5pt_reduction(G2H2(301),RedSet_5(64),mass5set(:,3),  & 
G1H2(721),G1H2(722),G1H2(723),G1H2(724),G1H2(725),G1H2(726),2)
  call HG1shiftOLR(G1H2(722),4,2)
  call Hotf_5pt_reduction(G2H2(457),RedSet_5(103),mass5set(:,5),  & 
G1H2(727),G1H2(728),G1H2(729),G1H2(730),G1H2(731),G1H2(732),2)
  call HG1shiftOLR(G1H2(728),16,2)
  call Hotf_5pt_reduction(G2H2(461),RedSet_5(89),mass5set(:,4),  & 
G1H2(733),G1H2(734),G1H2(735),G1H2(736),G1H2(737),G1H2(738),2)
  call HG1shiftOLR(G1H2(734),16,2)
  call Hotf_5pt_reduction(G2H2(309),RedSet_5(66),mass5set(:,3),  & 
G1H2(739),G1H2(740),G1H2(741),G1H2(742),G1H2(743),G1H2(744),2)
  call HG1shiftOLR(G1H2(740),16,2)
  call Hotf_5pt_reduction(G2H2(465),RedSet_5(104),mass5set(:,5),  & 
G1H2(745),G1H2(746),G1H2(747),G1H2(748),G1H2(749),G1H2(750),2)
  call HG1shiftOLR(G1H2(746),8,2)
  call Hotf_5pt_reduction(G2H2(469),RedSet_5(91),mass5set(:,4),  & 
G1H2(751),G1H2(752),G1H2(753),G1H2(754),G1H2(755),G1H2(756),2)
  call HG1shiftOLR(G1H2(752),8,2)
  call Hotf_5pt_reduction(G2H2(317),RedSet_5(68),mass5set(:,3),  & 
G1H2(757),G1H2(758),G1H2(759),G1H2(760),G1H2(761),G1H2(762),2)
  call HG1shiftOLR(G1H2(758),8,2)
  call Hotf_5pt_reduction(G2H2(473),RedSet_5(105),mass5set(:,5),  & 
G1H2(763),G1H2(764),G1H2(765),G1H2(766),G1H2(767),G1H2(768),2)
  call HG1shiftOLR(G1H2(764),16,2)
  call Hotf_5pt_reduction(G2H2(477),RedSet_5(95),mass5set(:,4),  & 
G1H2(769),G1H2(770),G1H2(771),G1H2(772),G1H2(773),G1H2(774),2)
  call HG1shiftOLR(G1H2(770),16,2)
  call Hotf_5pt_reduction(G2H2(325),RedSet_5(70),mass5set(:,3),  & 
G1H2(775),G1H2(776),G1H2(777),G1H2(778),G1H2(779),G1H2(780),2)
  call HG1shiftOLR(G1H2(776),16,2)
  call Hotf_5pt_reduction(G2H2(481),RedSet_5(106),mass5set(:,5),  & 
G1H2(781),G1H2(782),G1H2(783),G1H2(784),G1H2(785),G1H2(786),2)
  call HG1shiftOLR(G1H2(782),4,2)
  call Hotf_5pt_reduction(G2H2(485),RedSet_5(97),mass5set(:,4),  & 
G1H2(787),G1H2(788),G1H2(789),G1H2(790),G1H2(791),G1H2(792),2)
  call HG1shiftOLR(G1H2(788),4,2)
  call Hotf_5pt_reduction(G2H2(333),RedSet_5(72),mass5set(:,3),  & 
G1H2(793),G1H2(794),G1H2(795),G1H2(796),G1H2(797),G1H2(798),2)
  call HG1shiftOLR(G1H2(794),4,2)
  call Hotf_5pt_reduction(G2H2(489),RedSet_5(107),mass5set(:,5),  & 
G1H2(799),G1H2(800),G1H2(801),G1H2(802),G1H2(803),G1H2(804),2)
  call HG1shiftOLR(G1H2(800),8,2)
  call Hotf_5pt_reduction(G2H2(493),RedSet_5(100),mass5set(:,4),  & 
G1H2(805),G1H2(806),G1H2(807),G1H2(808),G1H2(809),G1H2(810),2)
  call HG1shiftOLR(G1H2(806),8,2)
  call Hotf_5pt_reduction(G2H2(341),RedSet_5(74),mass5set(:,3),  & 
G1H2(811),G1H2(812),G1H2(813),G1H2(814),G1H2(815),G1H2(816),2)
  call HG1shiftOLR(G1H2(812),8,2)
  call Hotf_5pt_reduction(G2H2(497),RedSet_5(108),mass5set(:,5),  & 
G1H2(817),G1H2(818),G1H2(819),G1H2(820),G1H2(821),G1H2(822),2)
  call HG1shiftOLR(G1H2(818),4,2)
  call Hotf_5pt_reduction(G2H2(501),RedSet_5(102),mass5set(:,4),  & 
G1H2(823),G1H2(824),G1H2(825),G1H2(826),G1H2(827),G1H2(828),2)
  call HG1shiftOLR(G1H2(824),4,2)
  call Hotf_5pt_reduction(G2H2(349),RedSet_5(76),mass5set(:,3),  & 
G1H2(829),G1H2(830),G1H2(831),G1H2(832),G1H2(833),G1H2(834),2)
  call HG1shiftOLR(G1H2(830),4,2)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(3),mass5set(:,1),  & 
G1H4(285),G1H4(286),G1H4(287),G1H4(116),G1H4(120),G1H4(127),4)
  call HG1shiftOLR(G1H4(286),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(38),mass4set(:,1),  & 
G1H4(128),G1H4(132),G1H4(133),G1H4(140),G1H4(144),4)
  call HG1shiftOLR(G1H4(132),11,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(6),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(156),G1H4(157),G1H4(158),G1H4(163),4)
  call HG1shiftOLR(G1H4(146),10,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(38),mass4set(:,1),  & 
G1H4(169),G1H4(170),G1H4(175),G1H4(176),G1H4(182),4)
  call HG1shiftOLR(G1H4(170),11,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(4),mass5set(:,1),  & 
G1H4(187),G1H4(188),G1H4(192),G1H4(199),G1H4(200),G1H4(204),4)
  call HG1shiftOLR(G1H4(188),17,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(13),mass4set(:,1),  & 
G1H4(205),G1H4(212),G1H4(216),G1H4(217),G1H4(218),4)
  call HG1shiftOLR(G1H4(212),19,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(5),mass5set(:,1),  & 
G1H4(228),G1H4(229),G1H4(230),G1H4(235),G1H4(241),G1H4(242),4)
  call HG1shiftOLR(G1H4(229),17,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(23),mass4set(:,1),  & 
G1H4(247),G1H4(248),G1H4(254),G1H4(259),G1H4(260),4)
  call HG1shiftOLR(G1H4(248),19,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(1),mass5set(:,1),  & 
G1H4(264),G1H4(271),G1H4(272),G1H4(276),G1H4(277),G1H4(284),4)
  call HG1shiftOLR(G1H4(271),18,4)
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(13),mass4set(:,1),  & 
G1H4(288),G1H4(6),G1H4(18),G1H4(54),G1H4(66),4)
  call HG1shiftOLR(G1H4(6),19,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(2),mass5set(:,1),  & 
G1H4(78),G1H4(90),G1H4(126),G1H4(138),G1H4(150),G1H4(162),4)
  call HG1shiftOLR(G1H4(90),18,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(23),mass4set(:,1),  & 
G1H4(198),G1H4(210),G1H4(222),G1H4(234),G1H4(270),4)
  call HG1shiftOLR(G1H4(210),19,4)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(11),mass4set(:,2),  & 
G1H2(835),G1H2(836),G1H2(837),G1H2(838),G1H2(839),2)
  call HG1shiftOLR(G1H2(836),18,2)
  call Hotf_4pt_reduction(G2H2(192),RedSet_4(21),mass4set(:,2),  & 
G1H2(840),G1H2(841),G1H2(842),G1H2(843),G1H2(844),2)
  call HG1shiftOLR(G1H2(841),18,2)
  call Hotf_4pt_reduction(G2H2(196),RedSet_4(36),mass4set(:,2),  & 
G1H2(845),G1H2(846),G1H2(847),G1H2(848),G1H2(849),2)
  call HG1shiftOLR(G1H2(846),9,2)
  call Hotf_4pt_reduction(G2H2(200),RedSet_4(48),mass4set(:,2),  & 
G1H2(850),G1H2(851),G1H2(852),G1H2(853),G1H2(854),2)
  call HG1shiftOLR(G1H2(851),17,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(54),mass4set(:,2),  & 
G1H2(855),G1H2(856),G1H2(857),G1H2(858),G1H2(859),2)
  call HG1shiftOLR(G1H2(856),17,2)
  call Hotf_4pt_reduction(G2H2(208),RedSet_4(64),mass4set(:,2),  & 
G1H2(860),G1H2(861),G1H2(862),G1H2(863),G1H2(864),2)
  call HG1shiftOLR(G1H2(861),10,2)
  call Hotf_4pt_reduction(G2H2(216),RedSet_4(76),mass4set(:,1),  & 
G1H2(865),G1H2(866),G1H2(867),G1H2(868),G1H2(869),2)
  call HG1shiftOLR(G1H2(866),20,2)
  call Hotf_4pt_reduction(G2H2(224),RedSet_4(89),mass4set(:,1),  & 
G1H2(870),G1H2(871),G1H2(872),G1H2(873),G1H2(874),2)
  call HG1shiftOLR(G1H2(871),24,2)
  call Hotf_4pt_reduction(G2H2(232),RedSet_4(89),mass4set(:,1),  & 
G1H2(875),G1H2(876),G1H2(877),G1H2(878),G1H2(879),2)
  call HG1shiftOLR(G1H2(876),24,2)
  call Hotf_4pt_reduction(G2H2(240),RedSet_4(111),mass4set(:,3),  & 
G1H2(880),G1H2(881),G1H2(882),G1H2(883),G1H2(884),2)
  call HG1shiftOLR(G1H2(881),24,2)
  call Hotf_4pt_reduction(G2H2(248),RedSet_4(111),mass4set(:,3),  & 
G1H2(885),G1H2(886),G1H2(887),G1H2(888),G1H2(889),2)
  call HG1shiftOLR(G1H2(886),24,2)
  call Hotf_4pt_reduction(G2H2(256),RedSet_4(76),mass4set(:,1),  & 
G1H2(890),G1H2(891),G1H2(892),G1H2(893),G1H2(894),2)
  call HG1shiftOLR(G1H2(891),20,2)
  call Hotf_4pt_reduction(G2H2(264),RedSet_4(89),mass4set(:,1),  & 
G1H2(895),G1H2(896),G1H2(897),G1H2(898),G1H2(899),2)
  call HG1shiftOLR(G1H2(896),24,2)
  call Hotf_4pt_reduction(G2H2(272),RedSet_4(148),mass4set(:,3),  & 
G1H2(900),G1H2(901),G1H2(902),G1H2(903),G1H2(904),2)
  call HG1shiftOLR(G1H2(901),20,2)
  call Hotf_4pt_reduction(G2H2(280),RedSet_4(148),mass4set(:,3),  & 
G1H2(905),G1H2(906),G1H2(907),G1H2(908),G1H2(909),2)
  call HG1shiftOLR(G1H2(906),20,2)
  call Hotf_4pt_reduction(G2H2(288),RedSet_4(89),mass4set(:,1),  & 
G1H2(910),G1H2(911),G1H2(912),G1H2(913),G1H2(914),2)
  call HG1shiftOLR(G1H2(911),24,2)
  call Hotf_4pt_reduction(G2H2(296),RedSet_4(173),mass4set(:,3),  & 
G1H2(915),G1H2(916),G1H2(917),G1H2(918),G1H2(919),2)
  call HG1shiftOLR(G1H2(916),12,2)
  call Hotf_4pt_reduction(G2H2(304),RedSet_4(173),mass4set(:,3),  & 
G1H2(920),G1H2(921),G1H2(922),G1H2(923),G1H2(924),2)
  call HG1shiftOLR(G1H2(921),12,2)
  call Hotf_4pt_reduction(G2H2(312),RedSet_4(186),mass4set(:,3),  & 
G1H2(925),G1H2(926),G1H2(927),G1H2(928),G1H2(929),2)
  call HG1shiftOLR(G1H2(926),24,2)
  call Hotf_4pt_reduction(G2H2(320),RedSet_4(186),mass4set(:,3),  & 
G1H2(930),G1H2(931),G1H2(932),G1H2(933),G1H2(934),2)
  call HG1shiftOLR(G1H2(931),24,2)
  call Hotf_4pt_reduction(G2H2(328),RedSet_4(199),mass4set(:,3),  & 
G1H2(935),G1H2(936),G1H2(937),G1H2(938),G1H2(939),2)
  call HG1shiftOLR(G1H2(936),20,2)
  call Hotf_4pt_reduction(G2H2(336),RedSet_4(199),mass4set(:,3),  & 
G1H2(940),G1H2(941),G1H2(942),G1H2(943),G1H2(944),2)
  call HG1shiftOLR(G1H2(941),20,2)
  call Hotf_4pt_reduction(G2H2(344),RedSet_4(210),mass4set(:,3),  & 
G1H2(945),G1H2(946),G1H2(947),G1H2(948),G1H2(949),2)
  call HG1shiftOLR(G1H2(946),12,2)
  call Hotf_4pt_reduction(G2H2(352),RedSet_4(210),mass4set(:,3),  & 
G1H2(950),G1H2(951),G1H2(952),G1H2(953),G1H2(954),2)
  call HG1shiftOLR(G1H2(951),12,2)
  call Hotf_4pt_reduction(G2H2(356),RedSet_4(8),mass4set(:,2),  & 
G1H2(955),G1H2(956),G1H2(957),G1H2(958),G1H2(959),2)
  call HG1shiftOLR(G1H2(956),18,2)
  call Hotf_4pt_reduction(G2H2(360),RedSet_4(18),mass4set(:,2),  & 
G1H2(960),G1H2(961),G1H2(962),G1H2(963),G1H2(964),2)
  call HG1shiftOLR(G1H2(961),18,2)
  call Hotf_4pt_reduction(G2H2(364),RedSet_4(29),mass4set(:,2),  & 
G1H2(965),G1H2(966),G1H2(967),G1H2(968),G1H2(969),2)
  call HG1shiftOLR(G1H2(966),9,2)
  call Hotf_4pt_reduction(G2H2(368),RedSet_4(33),mass4set(:,2),  & 
G1H2(970),G1H2(971),G1H2(972),G1H2(973),G1H2(974),2)
  call HG1shiftOLR(G1H2(971),9,2)
  call Hotf_4pt_reduction(G2H2(372),RedSet_4(46),mass4set(:,2),  & 
G1H2(975),G1H2(976),G1H2(977),G1H2(978),G1H2(979),2)
  call HG1shiftOLR(G1H2(976),17,2)
  call Hotf_4pt_reduction(G2H2(376),RedSet_4(52),mass4set(:,2),  & 
G1H2(980),G1H2(981),G1H2(982),G1H2(983),G1H2(984),2)
  call HG1shiftOLR(G1H2(981),17,2)
  call Hotf_4pt_reduction(G2H2(380),RedSet_4(59),mass4set(:,2),  & 
G1H2(985),G1H2(986),G1H2(987),G1H2(988),G1H2(989),2)
  call HG1shiftOLR(G1H2(986),10,2)
  call Hotf_4pt_reduction(G2H2(384),RedSet_4(62),mass4set(:,2),  & 
G1H2(990),G1H2(991),G1H2(992),G1H2(993),G1H2(994),2)
  call HG1shiftOLR(G1H2(991),10,2)
  call Hotf_4pt_reduction(G2H2(388),RedSet_4(74),mass4set(:,3),  & 
G1H2(995),G1H2(996),G1H2(997),G1H2(998),G1H2(999),2)
  call HG1shiftOLR(G1H2(996),20,2)
  call Hotf_4pt_reduction(G2H2(392),RedSet_4(87),mass4set(:,3),  & 
G1H2(1000),G1H2(1001),G1H2(1002),G1H2(1003),G1H2(1004),2)
  call HG1shiftOLR(G1H2(1001),24,2)
  call Hotf_4pt_reduction(G2H2(396),RedSet_4(87),mass4set(:,3),  & 
G1H2(1005),G1H2(1006),G1H2(1007),G1H2(1008),G1H2(1009),2)
  call HG1shiftOLR(G1H2(1006),24,2)
  call Hotf_4pt_reduction(G2H2(400),RedSet_4(105),mass4set(:,4),  & 
G1H2(1010),G1H2(1011),G1H2(1012),G1H2(1013),G1H2(1014),2)
  call HG1shiftOLR(G1H2(1011),24,2)
  call Hotf_4pt_reduction(G2H2(404),RedSet_4(108),mass4set(:,1),  & 
G1H2(1015),G1H2(1016),G1H2(1017),G1H2(1018),G1H2(1019),2)
  call HG1shiftOLR(G1H2(1016),24,2)
  call Hotf_4pt_reduction(G2H2(408),RedSet_4(105),mass4set(:,4),  & 
G1H2(1020),G1H2(1021),G1H2(1022),G1H2(1023),G1H2(1024),2)
  call HG1shiftOLR(G1H2(1021),24,2)
  call Hotf_4pt_reduction(G2H2(412),RedSet_4(108),mass4set(:,1),  & 
G1H2(1025),G1H2(1026),G1H2(1027),G1H2(1028),G1H2(1029),2)
  call HG1shiftOLR(G1H2(1026),24,2)
  call Hotf_4pt_reduction(G2H2(416),RedSet_4(129),mass4set(:,3),  & 
G1H2(1030),G1H2(1031),G1H2(1032),G1H2(1033),G1H2(1034),2)
  call HG1shiftOLR(G1H2(1031),20,2)
  call Hotf_4pt_reduction(G2H2(420),RedSet_4(138),mass4set(:,3),  & 
G1H2(1035),G1H2(1036),G1H2(1037),G1H2(1038),G1H2(1039),2)
  call HG1shiftOLR(G1H2(1036),24,2)
  call Hotf_4pt_reduction(G2H2(424),RedSet_4(144),mass4set(:,4),  & 
G1H2(1040),G1H2(1041),G1H2(1042),G1H2(1043),G1H2(1044),2)
  call HG1shiftOLR(G1H2(1041),20,2)
  call Hotf_4pt_reduction(G2H2(428),RedSet_4(146),mass4set(:,1),  & 
G1H2(1045),G1H2(1046),G1H2(1047),G1H2(1048),G1H2(1049),2)
  call HG1shiftOLR(G1H2(1046),20,2)
  call Hotf_4pt_reduction(G2H2(432),RedSet_4(144),mass4set(:,4),  & 
G1H2(1050),G1H2(1051),G1H2(1052),G1H2(1053),G1H2(1054),2)
  call HG1shiftOLR(G1H2(1051),20,2)
  call Hotf_4pt_reduction(G2H2(436),RedSet_4(146),mass4set(:,1),  & 
G1H2(1055),G1H2(1056),G1H2(1057),G1H2(1058),G1H2(1059),2)
  call HG1shiftOLR(G1H2(1056),20,2)
  call Hotf_4pt_reduction(G2H2(440),RedSet_4(138),mass4set(:,3),  & 
G1H2(1060),G1H2(1061),G1H2(1062),G1H2(1063),G1H2(1064),2)
  call HG1shiftOLR(G1H2(1061),24,2)
  call Hotf_4pt_reduction(G2H2(444),RedSet_4(168),mass4set(:,4),  & 
G1H2(1065),G1H2(1066),G1H2(1067),G1H2(1068),G1H2(1069),2)
  call HG1shiftOLR(G1H2(1066),12,2)
  call Hotf_4pt_reduction(G2H2(448),RedSet_4(171),mass4set(:,1),  & 
G1H2(1070),G1H2(1071),G1H2(1072),G1H2(1073),G1H2(1074),2)
  call HG1shiftOLR(G1H2(1071),12,2)
  call Hotf_4pt_reduction(G2H2(452),RedSet_4(168),mass4set(:,4),  & 
G1H2(1075),G1H2(1076),G1H2(1077),G1H2(1078),G1H2(1079),2)
  call HG1shiftOLR(G1H2(1076),12,2)
  call Hotf_4pt_reduction(G2H2(456),RedSet_4(171),mass4set(:,1),  & 
G1H2(1080),G1H2(1081),G1H2(1082),G1H2(1083),G1H2(1084),2)
  call HG1shiftOLR(G1H2(1081),12,2)
  call Hotf_4pt_reduction(G2H2(460),RedSet_4(183),mass4set(:,4),  & 
G1H2(1085),G1H2(1086),G1H2(1087),G1H2(1088),G1H2(1089),2)
  call HG1shiftOLR(G1H2(1086),24,2)
  call Hotf_4pt_reduction(G2H2(464),RedSet_4(108),mass4set(:,1),  & 
G1H2(1090),G1H2(1091),G1H2(1092),G1H2(1093),G1H2(1094),2)
  call HG1shiftOLR(G1H2(1091),24,2)
  call Hotf_4pt_reduction(G2H2(468),RedSet_4(183),mass4set(:,4),  & 
G1H2(1095),G1H2(1096),G1H2(1097),G1H2(1098),G1H2(1099),2)
  call HG1shiftOLR(G1H2(1096),24,2)
  call Hotf_4pt_reduction(G2H2(472),RedSet_4(108),mass4set(:,1),  & 
G1H2(1100),G1H2(1101),G1H2(1102),G1H2(1103),G1H2(1104),2)
  call HG1shiftOLR(G1H2(1101),24,2)
  call Hotf_4pt_reduction(G2H2(476),RedSet_4(197),mass4set(:,4),  & 
G1H2(1105),G1H2(1106),G1H2(1107),G1H2(1108),G1H2(1109),2)
  call HG1shiftOLR(G1H2(1106),20,2)
  call Hotf_4pt_reduction(G2H2(480),RedSet_4(146),mass4set(:,1),  & 
G1H2(1110),G1H2(1111),G1H2(1112),G1H2(1113),G1H2(1114),2)
  call HG1shiftOLR(G1H2(1111),20,2)
  call Hotf_4pt_reduction(G2H2(484),RedSet_4(197),mass4set(:,4),  & 
G1H2(1115),G1H2(1116),G1H2(1117),G1H2(1118),G1H2(1119),2)
  call HG1shiftOLR(G1H2(1116),20,2)
  call Hotf_4pt_reduction(G2H2(488),RedSet_4(146),mass4set(:,1),  & 
G1H2(1120),G1H2(1121),G1H2(1122),G1H2(1123),G1H2(1124),2)
  call HG1shiftOLR(G1H2(1121),20,2)
  call Hotf_4pt_reduction(G2H2(492),RedSet_4(208),mass4set(:,4),  & 
G1H2(1125),G1H2(1126),G1H2(1127),G1H2(1128),G1H2(1129),2)
  call HG1shiftOLR(G1H2(1126),12,2)
  call Hotf_4pt_reduction(G2H2(496),RedSet_4(171),mass4set(:,1),  & 
G1H2(1130),G1H2(1131),G1H2(1132),G1H2(1133),G1H2(1134),2)
  call HG1shiftOLR(G1H2(1131),12,2)
  call Hotf_4pt_reduction(G2H2(500),RedSet_4(208),mass4set(:,4),  & 
G1H2(1135),G1H2(1136),G1H2(1137),G1H2(1138),G1H2(1139),2)
  call HG1shiftOLR(G1H2(1136),12,2)
  call Hotf_4pt_reduction(G2H2(504),RedSet_4(171),mass4set(:,1),  & 
G1H2(1140),G1H2(1141),G1H2(1142),G1H2(1143),G1H2(1144),2)
  call HG1shiftOLR(G1H2(1141),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(92),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(238),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(260),[G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(277),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(282),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(293),[G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(315),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(332),[G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(337),[G1H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(348),[G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(359),[G1H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(376),[G1H2(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(381),[G1H2(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(398),[G1H2(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(403),[G1H2(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(414),[G1H2(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(431),[G1H2(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(436),[G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(447),[G1H2(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(458),[G1H2(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(955),[G1H2(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(835),[G1H2(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(960),[G1H2(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(840),[G1H2(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(965),[G1H2(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(970),[G1H2(498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(845),[G1H2(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(975),[G1H2(510)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(850),[G1H2(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(980),[G1H2(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(855),[G1H2(528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(985),[G1H2(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(990),[G1H2(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(860),[G1H2(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(995),[G1H2(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(865),[G1H2(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1000),[G1H2(564)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(870),[G1H2(570)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1005),[G1H2(576)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(875),[G1H2(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1010),[G1H2(588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1015),[G1H2(594)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(880),[G1H2(600)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1020),[G1H2(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1025),[G1H2(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(885),[G1H2(618)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1030),[G1H2(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(890),[G1H2(630)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1035),[G1H2(636)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(895),[G1H2(642)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1040),[G1H2(648)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1045),[G1H2(654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(900),[G1H2(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1050),[G1H2(666)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1055),[G1H2(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(905),[G1H2(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1060),[G1H2(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(910),[G1H2(690)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1065),[G1H2(696)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1070),[G1H2(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(915),[G1H2(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1075),[G1H2(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1080),[G1H2(720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(920),[G1H2(726)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1085),[G1H2(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1090),[G1H2(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(925),[G1H2(744)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1095),[G1H2(750)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1100),[G1H2(756)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(930),[G1H2(762)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1105),[G1H2(768)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1110),[G1H2(774)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(935),[G1H2(780)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1115),[G1H2(786)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1120),[G1H2(792)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(940),[G1H2(798)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1125),[G1H2(804)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1130),[G1H2(810)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(945),[G1H2(816)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1135),[G1H2(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1140),[G1H2(828)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(950),[G1H2(834)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(288),[G1H4(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(162)])
  call Hloop_VA_Q(ntryL,G1H2(121),ex2(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(122),ex2(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(3),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(9),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(13),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(15),n2h1(56))
  call Hloop_VA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H2(44),ex2(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(19),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(79),ex2(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(25),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(92),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(27),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(29),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(31),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(109),ex1(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(33),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(110),ex1(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(35),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(3),ex1(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(39),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(41),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(54),ex1(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(45),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,nME,G2tensor(47),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(108),ex1(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(49),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(90),ex1(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(50),n2h1(74))
  call Hloop_VQ_A(ntryL,G1H2(132),ex1(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(51),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(114),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(52),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(53),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(54),n2h1(78))
  call Hloop_VQ_A(ntryL,G1H2(51),ex1(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(55),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(56),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(28),ex1(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(57),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(22),ex1(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(58),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(52),ex1(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(59),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(60),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(61),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(62),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(53),ex1(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(63),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(64),n2h1(88))
  call Hloop_VA_Q(ntryL,G1H2(76),ex2(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(65),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(77),ex2(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(66),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(67),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(68),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(69),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(70),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(105),ex2(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(71),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,nME,G2tensor(72),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(123),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(73),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(74),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(75),n2h1(99))
  call Hloop_QV_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(76),n2h1(100))
  call Hloop_QV_A(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(77),n2h1(101))
  call Hloop_QV_A(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(78),n2h1(102))
  call Hloop_QV_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nME,G2tensor(79),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(151),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,nME,G2tensor(80),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(81),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(82),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(83),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(161),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(84),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(85),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(172),ex5(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(86),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(87),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(173),ex5(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(88),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H2(177),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(89),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(178),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(90),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(189),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(91),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(92),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(93),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(94),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(190),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(95),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(96),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(97),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(98),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(99),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(100),n2h1(124))
  call Hloop_QV_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(101),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(102),n2h1(126))
  call Hloop_QV_A(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(103),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(217),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(104),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(221),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(105),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(106),n2h1(130))
  call Hloop_QV_A(ntryL,G1H2(233),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(107),n2h1(131))
  call Hloop_QV_A(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(108),n2h1(132))
  call Hloop_QV_A(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(109),n2h1(133))
  call Hloop_QV_A(ntryL,G1H2(238),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(110),n2h1(134))
  call Hloop_QV_A(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(111),n2h1(135))
  call Hloop_QV_A(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(112),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(243),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(113),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(114),n2h1(138))
  call Hloop_AV_Q(ntryL,G1H2(255),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(115),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H2(249),ex5(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(116),n2h1(140))
  call Hloop_AV_Q(ntryL,G1H2(250),ex5(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(117),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(260),ex5(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(118),n2h1(142))
  call Hloop_AV_Q(ntryL,G1H2(256),ex3(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nME,G2tensor(119),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(261),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,nME,G2tensor(120),n2h1(144))
  call Hloop_QV_A(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(121),n2h1(145))
  call Hloop_QV_A(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(122),n2h1(146))
  call Hloop_QV_A(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(123),n2h1(147))
  call Hloop_QV_A(ntryL,G1H2(271),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(124),n2h1(148))
  call Hloop_QV_A(ntryL,G1H2(272),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(125),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(282),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(126),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(278),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(127),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(128),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(287),ex3(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(129),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(288),ex3(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(130),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(293),ex3(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(131),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(294),ex3(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(132),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(298),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(133),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(299),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(134),n2h1(158))
  call Hloop_QV_A(ntryL,G1H2(310),ex5(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(135),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(304),ex3(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(136),n2h1(160))
  call Hloop_QV_A(ntryL,G1H2(305),ex3(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(137),n2h1(161))
  call Hloop_QV_A(ntryL,G1H2(315),ex3(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(138),n2h1(162))
  call Hloop_QV_A(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(139),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(316),ex3(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(140),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(141),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(321),ex5(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(142),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(332),ex5(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(143),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(326),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(144),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(327),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(145),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(337),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(146),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(333),ex5(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(147),n2h1(171))
  call Hloop_QV_A(ntryL,G1H2(338),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(148),n2h1(172))
  call Hloop_QV_A(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(149),n2h1(173))
  call Hloop_QV_A(ntryL,G1H2(343),ex3(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(150),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(348),ex3(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(151),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(349),ex3(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(152),n2h1(176))
  call Hloop_QV_A(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(153),n2h1(177))
  call Hloop_QV_A(ntryL,G1H2(354),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(154),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(359),ex4(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(155),n2h1(179))
  call Hloop_QV_A(ntryL,G1H2(360),ex4(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(156),n2h1(180))
  call Hloop_AV_Q(ntryL,G1H2(364),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(157),n2h1(181))
  call Hloop_AV_Q(ntryL,G1H2(365),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(158),n2h1(182))
  call Hloop_AV_Q(ntryL,G1H2(376),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(159),n2h1(183))
  call Hloop_AV_Q(ntryL,G1H2(370),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(160),n2h1(184))
  call Hloop_AV_Q(ntryL,G1H2(371),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(161),n2h1(185))
  call Hloop_AV_Q(ntryL,G1H2(381),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(162),n2h1(186))
  call Hloop_AV_Q(ntryL,G1H2(377),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(163),n2h1(187))
  call Hloop_AV_Q(ntryL,G1H2(382),ex5(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(164),n2h1(188))
  call Hloop_AV_Q(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(165),n2h1(189))
  call Hloop_AV_Q(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(166),n2h1(190))
  call Hloop_AV_Q(ntryL,G1H2(398),ex5(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(167),n2h1(191))
  call Hloop_AV_Q(ntryL,G1H2(392),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(168),n2h1(192))
  call Hloop_AV_Q(ntryL,G1H2(393),ex4(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(169),n2h1(193))
  call Hloop_AV_Q(ntryL,G1H2(403),ex4(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(170),n2h1(194))
  call Hloop_AV_Q(ntryL,G1H2(399),ex5(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(171),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H2(404),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(172),n2h1(196))
  call Hloop_AV_Q(ntryL,G1H2(408),ex3(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(173),n2h1(197))
  call Hloop_AV_Q(ntryL,G1H2(409),ex3(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(174),n2h1(198))
  call Hloop_AV_Q(ntryL,G1H2(414),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(175),n2h1(199))
  call Hloop_AV_Q(ntryL,G1H2(415),ex3(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(176),n2h1(200))
  call Hloop_AV_Q(ntryL,G1H2(419),ex5(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(177),n2h1(201))
  call Hloop_AV_Q(ntryL,G1H2(420),ex5(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(178),n2h1(202))
  call Hloop_AV_Q(ntryL,G1H2(431),ex5(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(179),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H2(425),ex3(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(180),n2h1(204))
  call Hloop_AV_Q(ntryL,G1H2(426),ex3(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(181),n2h1(205))
  call Hloop_AV_Q(ntryL,G1H2(436),ex3(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(182),n2h1(206))
  call Hloop_AV_Q(ntryL,G1H2(432),ex5(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(183),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(437),ex3(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(184),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(441),ex3(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(185),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(442),ex3(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(186),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(447),ex3(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(187),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(448),ex3(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(188),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(452),ex4(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(189),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(453),ex4(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(190),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(458),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(191),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(459),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(192),n2h1(216))
  call Hloop_AV_Q(ntryL,G1H2(463),ex5(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(193),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(464),ex5(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(194),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(955),ex5(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(195),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(469),ex5(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(196),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H2(470),ex5(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(197),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H2(835),ex5(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(198),n2h1(222))
  call Hloop_AV_Q(ntryL,G1H2(475),ex5(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(199),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(200),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(960),ex5(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(201),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(481),ex5(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(202),n2h1(226))
  call Hloop_AV_Q(ntryL,G1H2(482),ex5(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(203),n2h1(227))
  call Hloop_AV_Q(ntryL,G1H2(840),ex5(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(204),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(487),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(205),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(488),ex4(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(206),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(965),ex4(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(207),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(493),ex4(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(208),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(494),ex4(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(209),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(970),ex4(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(210),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(499),ex4(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(211),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(500),ex4(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(212),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(845),ex4(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(213),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(505),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(214),n2h1(238))
  call Hloop_QV_A(ntryL,G1H2(506),ex5(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(215),n2h1(239))
  call Hloop_QV_A(ntryL,G1H2(975),ex5(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(216),n2h1(240))
  call Hloop_QV_A(ntryL,G1H2(511),ex5(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(217),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(512),ex5(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(218),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(850),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(219),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(517),ex5(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(220),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(518),ex5(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(221),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(980),ex5(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(222),n2h1(246))
  call Hloop_QV_A(ntryL,G1H2(523),ex5(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(223),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(524),ex5(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(224),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(855),ex5(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(225),n2h1(249))
  call Hloop_AV_Q(ntryL,G1H2(529),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(226),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(530),ex4(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(227),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(985),ex4(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(228),n2h1(252))
  call Hloop_AV_Q(ntryL,G1H2(535),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(229),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(536),ex4(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(230),n2h1(254))
  call Hloop_AV_Q(ntryL,G1H2(990),ex4(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(231),n2h1(255))
  call Hloop_AV_Q(ntryL,G1H2(541),ex4(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(232),n2h1(256))
  call Hloop_AV_Q(ntryL,G1H2(542),ex4(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(233),n2h1(257))
  call Hloop_AV_Q(ntryL,G1H2(860),ex4(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(234),n2h1(258))
  call Hloop_QV_A(ntryL,G1H2(547),ex5(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(235),n2h1(259))
  call Hloop_QV_A(ntryL,G1H2(548),ex5(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(236),n2h1(260))
  call Hloop_QV_A(ntryL,G1H2(995),ex5(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(237),n2h1(261))
  call Hloop_QV_A(ntryL,G1H2(553),ex5(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(238),n2h1(262))
  call Hloop_QV_A(ntryL,G1H2(554),ex5(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(239),n2h1(263))
  call Hloop_QV_A(ntryL,G1H2(865),ex5(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(240),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(559),ex5(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(241),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(560),ex5(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(242),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(1000),ex5(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(243),n2h1(267))
  call Hloop_AV_Q(ntryL,G1H2(565),ex5(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(244),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H2(566),ex5(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(245),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(870),ex5(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(246),n2h1(270))
  call Hloop_AV_Q(ntryL,G1H2(571),ex4(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(247),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(572),ex4(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(248),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(1005),ex4(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(249),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(577),ex4(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(250),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(578),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(251),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(875),ex4(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(252),n2h1(276))
  call Hloop_QV_A(ntryL,G1H2(583),ex5(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(253),n2h1(277))
  call Hloop_QV_A(ntryL,G1H2(584),ex5(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(254),n2h1(278))
  call Hloop_QV_A(ntryL,G1H2(1010),ex5(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(255),n2h1(279))
  call Hloop_QV_A(ntryL,G1H2(589),ex5(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(256),n2h1(280))
  call Hloop_QV_A(ntryL,G1H2(590),ex5(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(257),n2h1(281))
  call Hloop_QV_A(ntryL,G1H2(1015),ex5(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(258),n2h1(282))
  call Hloop_QV_A(ntryL,G1H2(595),ex5(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(259),n2h1(283))
  call Hloop_QV_A(ntryL,G1H2(596),ex5(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(260),n2h1(284))
  call Hloop_QV_A(ntryL,G1H2(880),ex5(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(261),n2h1(285))
  call Hloop_QV_A(ntryL,G1H2(601),ex4(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(262),n2h1(286))
  call Hloop_QV_A(ntryL,G1H2(602),ex4(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(263),n2h1(287))
  call Hloop_QV_A(ntryL,G1H2(1020),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(264),n2h1(288))
  call Hloop_QV_A(ntryL,G1H2(607),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(265),n2h1(289))
  call Hloop_QV_A(ntryL,G1H2(608),ex4(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(266),n2h1(290))
  call Hloop_QV_A(ntryL,G1H2(1025),ex4(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(267),n2h1(291))
  call Hloop_QV_A(ntryL,G1H2(613),ex4(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(268),n2h1(292))
  call Hloop_QV_A(ntryL,G1H2(614),ex4(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(269),n2h1(293))
  call Hloop_QV_A(ntryL,G1H2(885),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(270),n2h1(294))
  call Hloop_AV_Q(ntryL,G1H2(619),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(271),n2h1(295))
  call Hloop_AV_Q(ntryL,G1H2(620),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(272),n2h1(296))
  call Hloop_AV_Q(ntryL,G1H2(1030),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(273),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(625),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(274),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H2(626),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(275),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(890),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(276),n2h1(300))
  call Hloop_QV_A(ntryL,G1H2(631),ex5(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(277),n2h1(301))
  call Hloop_QV_A(ntryL,G1H2(632),ex5(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(278),n2h1(302))
  call Hloop_QV_A(ntryL,G1H2(1035),ex5(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(279),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(637),ex5(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(280),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(638),ex5(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(281),n2h1(305))
  call Hloop_QV_A(ntryL,G1H2(895),ex5(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(282),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(643),ex5(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(283),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(644),ex5(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(284),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(1040),ex5(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(285),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(649),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(286),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(650),ex5(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(287),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(1045),ex5(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(288),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(655),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(289),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(656),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(290),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(900),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(291),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(661),ex3(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(292),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(662),ex3(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(293),n2h1(317))
  call Hloop_QV_A(ntryL,G1H2(1050),ex3(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(294),n2h1(318))
  call Hloop_QV_A(ntryL,G1H2(667),ex3(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(295),n2h1(319))
  call Hloop_QV_A(ntryL,G1H2(668),ex3(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(296),n2h1(320))
  call Hloop_QV_A(ntryL,G1H2(1055),ex3(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(297),n2h1(321))
  call Hloop_QV_A(ntryL,G1H2(673),ex3(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(298),n2h1(322))
  call Hloop_QV_A(ntryL,G1H2(674),ex3(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(299),n2h1(323))
  call Hloop_QV_A(ntryL,G1H2(905),ex3(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(300),n2h1(324))
  call Hloop_QV_A(ntryL,G1H2(679),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(301),n2h1(325))
  call Hloop_QV_A(ntryL,G1H2(680),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(302),n2h1(326))
  call Hloop_QV_A(ntryL,G1H2(1060),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(303),n2h1(327))
  call Hloop_QV_A(ntryL,G1H2(685),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(304),n2h1(328))
  call Hloop_QV_A(ntryL,G1H2(686),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(305),n2h1(329))
  call Hloop_QV_A(ntryL,G1H2(910),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(306),n2h1(330))
  call Hloop_QV_A(ntryL,G1H2(691),ex4(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(307),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(692),ex4(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(308),n2h1(332))
  call Hloop_QV_A(ntryL,G1H2(1065),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(309),n2h1(333))
  call Hloop_QV_A(ntryL,G1H2(697),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(310),n2h1(334))
  call Hloop_QV_A(ntryL,G1H2(698),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(311),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(1070),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(312),n2h1(336))
  call Hloop_QV_A(ntryL,G1H2(703),ex4(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(313),n2h1(337))
  call Hloop_QV_A(ntryL,G1H2(704),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(314),n2h1(338))
  call Hloop_QV_A(ntryL,G1H2(915),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(315),n2h1(339))
  call Hloop_QV_A(ntryL,G1H2(709),ex3(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(316),n2h1(340))
  call Hloop_QV_A(ntryL,G1H2(710),ex3(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(317),n2h1(341))
  call Hloop_QV_A(ntryL,G1H2(1075),ex3(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(318),n2h1(342))
  call Hloop_QV_A(ntryL,G1H2(715),ex3(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(319),n2h1(343))
  call Hloop_QV_A(ntryL,G1H2(716),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(320),n2h1(344))
  call Hloop_QV_A(ntryL,G1H2(1080),ex3(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(321),n2h1(345))
  call Hloop_QV_A(ntryL,G1H2(721),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(322),n2h1(346))
  call Hloop_QV_A(ntryL,G1H2(722),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(323),n2h1(347))
  call Hloop_QV_A(ntryL,G1H2(920),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(324),n2h1(348))
  call Hloop_AV_Q(ntryL,G1H2(727),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(325),n2h1(349))
  call Hloop_AV_Q(ntryL,G1H2(728),ex5(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(326),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(1085),ex5(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(327),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(733),ex5(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(328),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(734),ex5(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(329),n2h1(353))
  call Hloop_AV_Q(ntryL,G1H2(1090),ex5(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(330),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H2(739),ex5(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(331),n2h1(355))
  call Hloop_AV_Q(ntryL,G1H2(740),ex5(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(332),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H2(925),ex5(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(333),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H2(745),ex4(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(334),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(746),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(335),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H2(1095),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(336),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H2(751),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(337),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H2(752),ex4(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(338),n2h1(362))
  call Hloop_AV_Q(ntryL,G1H2(1100),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(339),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H2(757),ex4(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(340),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H2(758),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(341),n2h1(365))
  call Hloop_AV_Q(ntryL,G1H2(930),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(342),n2h1(366))
  call Hloop_AV_Q(ntryL,G1H2(763),ex5(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(343),n2h1(367))
  call Hloop_AV_Q(ntryL,G1H2(764),ex5(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(344),n2h1(368))
  call Hloop_AV_Q(ntryL,G1H2(1105),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(345),n2h1(369))
  call Hloop_AV_Q(ntryL,G1H2(769),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(346),n2h1(370))
  call Hloop_AV_Q(ntryL,G1H2(770),ex5(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(347),n2h1(371))
  call Hloop_AV_Q(ntryL,G1H2(1110),ex5(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(348),n2h1(372))
  call Hloop_AV_Q(ntryL,G1H2(775),ex5(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(349),n2h1(373))
  call Hloop_AV_Q(ntryL,G1H2(776),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(350),n2h1(374))
  call Hloop_AV_Q(ntryL,G1H2(935),ex5(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(351),n2h1(375))
  call Hloop_AV_Q(ntryL,G1H2(781),ex3(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(352),n2h1(376))
  call Hloop_AV_Q(ntryL,G1H2(782),ex3(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(353),n2h1(377))
  call Hloop_AV_Q(ntryL,G1H2(1115),ex3(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(354),n2h1(378))
  call Hloop_AV_Q(ntryL,G1H2(787),ex3(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(355),n2h1(379))
  call Hloop_AV_Q(ntryL,G1H2(788),ex3(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(356),n2h1(380))
  call Hloop_AV_Q(ntryL,G1H2(1120),ex3(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(357),n2h1(381))
  call Hloop_AV_Q(ntryL,G1H2(793),ex3(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(358),n2h1(382))
  call Hloop_AV_Q(ntryL,G1H2(794),ex3(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(359),n2h1(383))
  call Hloop_AV_Q(ntryL,G1H2(940),ex3(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(360),n2h1(384))
  call Hloop_AV_Q(ntryL,G1H2(799),ex4(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(361),n2h1(385))
  call Hloop_AV_Q(ntryL,G1H2(800),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(362),n2h1(386))
  call Hloop_AV_Q(ntryL,G1H2(1125),ex4(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(363),n2h1(387))
  call Hloop_AV_Q(ntryL,G1H2(805),ex4(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(364),n2h1(388))
  call Hloop_AV_Q(ntryL,G1H2(806),ex4(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(365),n2h1(389))
  call Hloop_AV_Q(ntryL,G1H2(1130),ex4(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(366),n2h1(390))
  call Hloop_AV_Q(ntryL,G1H2(811),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(367),n2h1(391))
  call Hloop_AV_Q(ntryL,G1H2(812),ex4(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(368),n2h1(392))
  call Hloop_AV_Q(ntryL,G1H2(945),ex4(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(369),n2h1(393))
  call Hloop_AV_Q(ntryL,G1H2(817),ex3(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(370),n2h1(394))
  call Hloop_AV_Q(ntryL,G1H2(818),ex3(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(371),n2h1(395))
  call Hloop_AV_Q(ntryL,G1H2(1135),ex3(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(372),n2h1(396))
  call Hloop_AV_Q(ntryL,G1H2(823),ex3(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(373),n2h1(397))
  call Hloop_AV_Q(ntryL,G1H2(824),ex3(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(374),n2h1(398))
  call Hloop_AV_Q(ntryL,G1H2(1140),ex3(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(375),n2h1(399))
  call Hloop_AV_Q(ntryL,G1H2(829),ex3(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(376),n2h1(400))
  call Hloop_AV_Q(ntryL,G1H2(830),ex3(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(377),n2h1(401))
  call Hloop_AV_Q(ntryL,G1H2(950),ex3(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(378),n2h1(402))
  call Hloop_VQ_A(ntryL,G1H4(285),wf4(:,11),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(379),n2h1(403))
  call Hloop_VQ_A(ntryL,G1H4(286),wf4(:,11),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(380),n2h1(404))
  call Hloop_VQ_A(ntryL,G1H4(128),wf4(:,11),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(381),n2h1(405))
  call Hloop_VQ_A(ntryL,G1H4(132),wf4(:,11),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,nME,G2tensor(382),n2h1(406))
  call Hloop_VA_Q(ntryL,G1H4(145),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(383),n2h1(407))
  call Hloop_VA_Q(ntryL,G1H4(146),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(384),n2h1(408))
  call Hloop_VA_Q(ntryL,G1H4(169),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(385),n2h1(409))
  call Hloop_VA_Q(ntryL,G1H4(170),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,nME,G2tensor(386),n2h1(410))
  call Hloop_VQ_A(ntryL,G1H4(187),wf4(:,14),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(387),n2h1(411))
  call Hloop_VQ_A(ntryL,G1H4(188),wf4(:,14),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,538))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(388),n2h1(412))
  call Hloop_VQ_A(ntryL,G1H4(205),wf4(:,14),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(389),n2h1(413))
  call Hloop_VQ_A(ntryL,G1H4(212),wf4(:,14),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(390),n2h1(414))
  call Hloop_VQ_A(ntryL,G1H4(228),wf4(:,14),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(391),n2h1(415))
  call Hloop_VQ_A(ntryL,G1H4(229),wf4(:,14),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(392),n2h1(416))
  call Hloop_VQ_A(ntryL,G1H4(247),wf4(:,14),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(393),n2h1(417))
  call Hloop_VQ_A(ntryL,G1H4(248),wf4(:,14),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(394),n2h1(418))
  call Hloop_VA_Q(ntryL,G1H4(264),wf4(:,6),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(395),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H4(271),wf4(:,6),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(396),n2h1(420))
  call Hloop_VA_Q(ntryL,G1H4(288),wf4(:,6),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(397),n2h1(421))
  call Hloop_VA_Q(ntryL,G1H4(6),wf4(:,6),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(398),n2h1(422))
  call Hloop_VA_Q(ntryL,G1H4(78),wf4(:,6),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(399),n2h1(423))
  call Hloop_VA_Q(ntryL,G1H4(90),wf4(:,6),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(400),n2h1(424))
  call Hloop_VA_Q(ntryL,G1H4(198),wf4(:,6),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(401),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H4(210),wf4(:,6),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(402),n2h1(426))
  call Hloop_AV_Q(ntryL,G1H2(836),ex5(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(403),n2h1(427))
  call Hloop_AV_Q(ntryL,G1H2(841),ex5(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(404),n2h1(428))
  call Hloop_QV_A(ntryL,G1H2(846),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(405),n2h1(429))
  call Hloop_QV_A(ntryL,G1H2(851),ex5(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(406),n2h1(430))
  call Hloop_QV_A(ntryL,G1H2(856),ex5(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(407),n2h1(431))
  call Hloop_AV_Q(ntryL,G1H2(861),ex4(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(408),n2h1(432))
  call Hloop_QV_A(ntryL,G1H2(866),ex5(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(409),n2h1(433))
  call Hloop_AV_Q(ntryL,G1H2(871),ex5(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(410),n2h1(434))
  call Hloop_AV_Q(ntryL,G1H2(876),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(411),n2h1(435))
  call Hloop_QV_A(ntryL,G1H2(881),ex5(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(412),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(886),ex4(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(413),n2h1(437))
  call Hloop_AV_Q(ntryL,G1H2(891),ex5(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(414),n2h1(438))
  call Hloop_QV_A(ntryL,G1H2(896),ex5(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(415),n2h1(439))
  call Hloop_QV_A(ntryL,G1H2(901),ex5(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(416),n2h1(440))
  call Hloop_QV_A(ntryL,G1H2(906),ex3(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(417),n2h1(441))
  call Hloop_QV_A(ntryL,G1H2(911),ex4(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(418),n2h1(442))
  call Hloop_QV_A(ntryL,G1H2(916),ex4(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(419),n2h1(443))
  call Hloop_QV_A(ntryL,G1H2(921),ex3(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(420),n2h1(444))
  call Hloop_AV_Q(ntryL,G1H2(926),ex5(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(421),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H2(931),ex4(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(422),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(936),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(423),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H2(941),ex3(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(424),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H2(946),ex4(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(425),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H2(951),ex3(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(426),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H2(956),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(427),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H2(961),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(428),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(966),ex4(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(429),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(971),ex4(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(430),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(976),ex5(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(431),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(981),ex5(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(432),n2h1(456))
  call Hloop_AV_Q(ntryL,G1H2(986),ex4(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(433),n2h1(457))
  call Hloop_AV_Q(ntryL,G1H2(991),ex4(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(434),n2h1(458))
  call Hloop_QV_A(ntryL,G1H2(996),ex5(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(435),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(1001),ex5(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(436),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H2(1006),ex4(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(437),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(1011),ex5(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(438),n2h1(462))
  call Hloop_QV_A(ntryL,G1H2(1016),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(439),n2h1(463))
  call Hloop_QV_A(ntryL,G1H2(1021),ex4(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(440),n2h1(464))
  call Hloop_QV_A(ntryL,G1H2(1026),ex4(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(441),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H2(1031),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(442),n2h1(466))
  call Hloop_QV_A(ntryL,G1H2(1036),ex5(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(443),n2h1(467))
  call Hloop_QV_A(ntryL,G1H2(1041),ex5(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(444),n2h1(468))
  call Hloop_QV_A(ntryL,G1H2(1046),ex5(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(445),n2h1(469))
  call Hloop_QV_A(ntryL,G1H2(1051),ex3(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(446),n2h1(470))
  call Hloop_QV_A(ntryL,G1H2(1056),ex3(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(447),n2h1(471))
  call Hloop_QV_A(ntryL,G1H2(1061),ex4(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(448),n2h1(472))
  call Hloop_QV_A(ntryL,G1H2(1066),ex4(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(449),n2h1(473))
  call Hloop_QV_A(ntryL,G1H2(1071),ex4(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(450),n2h1(474))
  call Hloop_QV_A(ntryL,G1H2(1076),ex3(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(451),n2h1(475))
  call Hloop_QV_A(ntryL,G1H2(1081),ex3(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(452),n2h1(476))
  call Hloop_AV_Q(ntryL,G1H2(1086),ex5(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(453),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H2(1091),ex5(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(454),n2h1(478))
  call Hloop_AV_Q(ntryL,G1H2(1096),ex4(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(455),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H2(1101),ex4(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(456),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H2(1106),ex5(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(457),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H2(1111),ex5(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(458),n2h1(482))
  call Hloop_AV_Q(ntryL,G1H2(1116),ex3(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(459),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H2(1121),ex3(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(460),n2h1(484))
  call Hloop_AV_Q(ntryL,G1H2(1126),ex4(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(461),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H2(1131),ex4(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(462),n2h1(486))
  call Hloop_AV_Q(ntryL,G1H2(1136),ex3(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(463),n2h1(487))
  call Hloop_AV_Q(ntryL,G1H2(1141),ex3(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(464),n2h1(488))
  call ol_merge_tensors(G2tensor(1),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(12),G1tensor(32)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(14),G1tensor(38)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(16),G1tensor(44)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(18),G1tensor(50),G1tensor(3)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(20),G1tensor(56)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(22),G1tensor(62),G1tensor(39)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(24),G1tensor(68)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(26),G1tensor(74)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(28),G1tensor(80)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(30),G1tensor(86),G1tensor(75)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(32),G1tensor(92),G1tensor(21)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(34),G1tensor(98)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(36),G1tensor(104),G1tensor(93)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(38),G1tensor(110)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(40),G1tensor(116),G1tensor(69)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(42),G1tensor(122)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(44),G1tensor(128),G1tensor(45)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(46),G1tensor(134)])
  call ol_merge_tensors(G2tensor(189),[G2tensor(48),G1tensor(140),G1tensor(51)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(10),G1tensor(4)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(7),G1tensor(24),G1tensor(6)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(23),G1tensor(30),G1tensor(12)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(39),G1tensor(36),G1tensor(18)])
  call ol_merge_tensors(G2tensor(214),[G1tensor(28),G1tensor(22)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(220),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(223),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(226),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(229),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(232),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(235),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(238),G1tensor(71),G1tensor(41)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(241),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(280),[G2tensor(244),G1tensor(77),G1tensor(47)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(247),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(304),[G2tensor(250),G1tensor(95),G1tensor(53)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(253),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(328),[G2tensor(256),G1tensor(112),G1tensor(58)])
  call ol_merge_tensors(G2tensor(259),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(84),G1tensor(60)])
  call ol_merge_tensors(G2tensor(262),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(337),[G2tensor(265),G1tensor(118),G1tensor(64)])
  call ol_merge_tensors(G2tensor(268),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(102),G1tensor(66)])
  call ol_merge_tensors(G2tensor(271),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(277),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(283),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(286),G1tensor(124),G1tensor(82)])
  call ol_merge_tensors(G2tensor(289),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(292),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(355),[G2tensor(295),G1tensor(130),G1tensor(88)])
  call ol_merge_tensors(G2tensor(298),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(108),G1tensor(90)])
  call ol_merge_tensors(G2tensor(301),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(144),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(307),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(364),[G2tensor(310),G1tensor(136),G1tensor(100)])
  call ol_merge_tensors(G2tensor(313),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(316),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(319),G1tensor(142),G1tensor(106)])
  call ol_merge_tensors(G2tensor(322),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(325),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(331),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(126),G1tensor(114)])
  call ol_merge_tensors(G2tensor(334),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(340),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(168),[G1tensor(138),G1tensor(120)])
  call ol_merge_tensors(G2tensor(343),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(349),[G1tensor(125)])
  call ol_merge_tensors(G2tensor(352),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(358),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(180),[G1tensor(144),G1tensor(132)])
  call ol_merge_tensors(G2tensor(361),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(367),[G1tensor(137)])
  call ol_merge_tensors(G2tensor(370),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(376),[G1tensor(143)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(32),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(33),mass5set(:,1),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),2)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(34),mass5set(:,1),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),1)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(35),mass5set(:,1),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),1)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(36),mass5set(:,1),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),1)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(37),mass5set(:,1),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(3),G1tensor(56),G1tensor(62))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(44),mass5set(:,2),  & 
G1tensor(39),G1tensor(68),G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(75))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(46),mass5set(:,2),  & 
G1tensor(92),G1tensor(21),G1tensor(98),G1tensor(104),G1tensor(93),G1tensor(110))
  call G_TensorShift(G1tensor(21),8)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(48),mass5set(:,2),  & 
G1tensor(116),G1tensor(69),G1tensor(122),G1tensor(128),G1tensor(45),G1tensor(134))
  call G_TensorShift(G1tensor(69),16)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(50),mass5set(:,3),  & 
G1tensor(140),G1tensor(51),G1tensor(10),G1tensor(4),G1tensor(5),G1tensor(24))
  call G_TensorShift(G1tensor(51),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(52),mass5set(:,3),  & 
G1tensor(6),G1tensor(9),G1tensor(11),G1tensor(30),G1tensor(12),G1tensor(15))
  call G_TensorShift(G1tensor(9),16)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(54),mass5set(:,2),  & 
G1tensor(16),G1tensor(17),G1tensor(36),G1tensor(18),G1tensor(28),G1tensor(22))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(55),mass5set(:,2),  & 
G1tensor(23),G1tensor(27),G1tensor(29),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(27),8)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(56),mass5set(:,3),  & 
G1tensor(40),G1tensor(71),G1tensor(41),G1tensor(42),G1tensor(46),G1tensor(77))
  call G_TensorShift(G1tensor(71),4)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(58),mass5set(:,3),  & 
G1tensor(47),G1tensor(48),G1tensor(52),G1tensor(95),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(48),16)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(60),mass5set(:,2),  & 
G1tensor(57),G1tensor(112),G1tensor(58),G1tensor(59),G1tensor(84),G1tensor(60))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(61),mass5set(:,3),  & 
G1tensor(63),G1tensor(118),G1tensor(64),G1tensor(65),G1tensor(102),G1tensor(66))
  call G_TensorShift(G1tensor(118),4)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(63),mass5set(:,3),  & 
G1tensor(70),G1tensor(72),G1tensor(76),G1tensor(78),G1tensor(81),G1tensor(124))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(65),mass5set(:,3),  & 
G1tensor(82),G1tensor(83),G1tensor(87),G1tensor(130),G1tensor(88),G1tensor(89))
  call G_TensorShift(G1tensor(83),8)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(67),mass5set(:,3),  & 
G1tensor(108),G1tensor(90),G1tensor(94),G1tensor(96),G1tensor(99),G1tensor(136))
  call G_TensorShift(G1tensor(90),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(69),mass5set(:,3),  & 
G1tensor(100),G1tensor(101),G1tensor(105),G1tensor(142),G1tensor(106),G1tensor(107))
  call G_TensorShift(G1tensor(101),4)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(71),mass5set(:,3),  & 
G1tensor(111),G1tensor(113),G1tensor(126),G1tensor(114),G1tensor(117),G1tensor(119))
  call G_TensorShift(G1tensor(113),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(73),mass5set(:,3),  & 
G1tensor(138),G1tensor(120),G1tensor(123),G1tensor(125),G1tensor(129),G1tensor(131))
  call G_TensorShift(G1tensor(120),4)
  call Hotf_5pt_reduction_last(G2tensor(189),RedSet_5(75),mass5set(:,3),  & 
G1tensor(144),G1tensor(132),G1tensor(135),G1tensor(137),G1tensor(141),G1tensor(143))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(77),mass5set(:,2),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(38),mass5set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(17),mass5set(:,4),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(78),mass5set(:,2),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(202),RedSet_5(39),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(18),mass5set(:,4),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(79),mass5set(:,2),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(208),RedSet_5(80),mass5set(:,2),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(40),mass5set(:,2),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(19),mass5set(:,4),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(214),RedSet_5(81),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(41),mass5set(:,2),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(220),RedSet_5(82),mass5set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(42),mass5set(:,2),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(226),RedSet_5(83),mass5set(:,2),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(84),mass5set(:,2),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(232),RedSet_5(43),mass5set(:,2),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(235),RedSet_5(85),mass5set(:,3),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(274),RedSet_5(45),mass5set(:,4),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(20),mass5set(:,2),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(86),mass5set(:,3),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(280),RedSet_5(47),mass5set(:,4),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(21),mass5set(:,2),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(87),mass5set(:,3),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(304),RedSet_5(49),mass5set(:,4),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(22),mass5set(:,2),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(253),RedSet_5(88),mass5set(:,5),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(328),RedSet_5(89),mass5set(:,4),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(51),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(23),mass5set(:,3),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(262),RedSet_5(90),mass5set(:,5),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),8)
  call Hotf_5pt_reduction_last(G2tensor(337),RedSet_5(91),mass5set(:,4),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(268),RedSet_5(53),mass5set(:,3),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(24),mass5set(:,3),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(92),mass5set(:,3),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(116),RedSet_5(25),mass5set(:,2),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(277),RedSet_5(93),mass5set(:,3),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(26),mass5set(:,2),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(283),RedSet_5(94),mass5set(:,5),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(346),RedSet_5(95),mass5set(:,4),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(289),RedSet_5(57),mass5set(:,3),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(292),RedSet_5(96),mass5set(:,5),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_5pt_reduction_last(G2tensor(355),RedSet_5(97),mass5set(:,4),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),4)
  call Hotf_5pt_reduction_last(G2tensor(298),RedSet_5(59),mass5set(:,3),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),4)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(27),mass5set(:,3),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),4)
  call Hotf_5pt_reduction_last(G2tensor(301),RedSet_5(98),mass5set(:,3),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),8)
  call Hotf_5pt_reduction_last(G2tensor(144),RedSet_5(28),mass5set(:,2),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),8)
  call Hotf_5pt_reduction_last(G2tensor(307),RedSet_5(99),mass5set(:,5),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),8)
  call Hotf_5pt_reduction_last(G2tensor(364),RedSet_5(100),mass5set(:,4),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_5pt_reduction_last(G2tensor(313),RedSet_5(62),mass5set(:,3),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),8)
  call Hotf_5pt_reduction_last(G2tensor(316),RedSet_5(101),mass5set(:,5),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),4)
  call Hotf_5pt_reduction_last(G2tensor(373),RedSet_5(102),mass5set(:,4),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_5pt_reduction_last(G2tensor(322),RedSet_5(64),mass5set(:,3),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),4)
  call Hotf_5pt_reduction_last(G2tensor(325),RedSet_5(103),mass5set(:,5),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(331),RedSet_5(66),mass5set(:,3),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(29),mass5set(:,3),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(334),RedSet_5(104),mass5set(:,5),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(340),RedSet_5(68),mass5set(:,3),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),8)
  call Hotf_5pt_reduction_last(G2tensor(168),RedSet_5(30),mass5set(:,3),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),8)
  call Hotf_5pt_reduction_last(G2tensor(343),RedSet_5(105),mass5set(:,5),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),16)
  call Hotf_5pt_reduction_last(G2tensor(349),RedSet_5(70),mass5set(:,3),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),16)
  call Hotf_5pt_reduction_last(G2tensor(352),RedSet_5(106),mass5set(:,5),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),4)
  call Hotf_5pt_reduction_last(G2tensor(358),RedSet_5(72),mass5set(:,3),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),4)
  call Hotf_5pt_reduction_last(G2tensor(180),RedSet_5(31),mass5set(:,3),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),4)
  call Hotf_5pt_reduction_last(G2tensor(361),RedSet_5(107),mass5set(:,5),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),8)
  call Hotf_5pt_reduction_last(G2tensor(367),RedSet_5(74),mass5set(:,3),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),8)
  call Hotf_5pt_reduction_last(G2tensor(370),RedSet_5(108),mass5set(:,5),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),4)
  call Hotf_5pt_reduction_last(G2tensor(376),RedSet_5(76),mass5set(:,3),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),4)
  call Hotf_5pt_reduction_last(G2tensor(379),RedSet_5(3),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),9)
  call Hotf_5pt_reduction_last(G2tensor(383),RedSet_5(6),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),10)
  call Hotf_5pt_reduction_last(G2tensor(387),RedSet_5(4),mass5set(:,1),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),17)
  call Hotf_5pt_reduction_last(G2tensor(391),RedSet_5(5),mass5set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),17)
  call Hotf_5pt_reduction_last(G2tensor(395),RedSet_5(1),mass5set(:,1),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),18)
  call Hotf_5pt_reduction_last(G2tensor(399),RedSet_5(2),mass5set(:,1),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),18)
  call ol_merge_tensors(T1sum(25),[G1tensor(1)])
  call ol_merge_tensors(T1sum(26),[G1tensor(37)])
  call ol_merge_tensors(T1sum(27),[G1tensor(73)])
  call ol_merge_tensors(T1sum(28),[G1tensor(109)])
  call ol_merge_tensors(T1sum(29),[G1tensor(2)])
  call ol_merge_tensors(T1sum(30),[G1tensor(38)])
  call ol_merge_tensors(T1sum(31),[G1tensor(39)])
  call ol_merge_tensors(T1sum(32),[G1tensor(92)])
  call ol_merge_tensors(T1sum(33),[G1tensor(116)])
  call ol_merge_tensors(T1sum(34),[G1tensor(140)])
  call ol_merge_tensors(T1sum(35),[G1tensor(6)])
  call ol_merge_tensors(T1sum(36),[G1tensor(16)])
  call ol_merge_tensors(T1sum(37),[G1tensor(23)])
  call ol_merge_tensors(T1sum(38),[G1tensor(40)])
  call ol_merge_tensors(T1sum(39),[G1tensor(47)])
  call ol_merge_tensors(T1sum(40),[G1tensor(57)])
  call ol_merge_tensors(T1sum(41),[G1tensor(63)])
  call ol_merge_tensors(T1sum(42),[G1tensor(70)])
  call ol_merge_tensors(T1sum(43),[G1tensor(82)])
  call ol_merge_tensors(T1sum(44),[G1tensor(108)])
  call ol_merge_tensors(T1sum(45),[G1tensor(100)])
  call ol_merge_tensors(T1sum(46),[G1tensor(111)])
  call ol_merge_tensors(T1sum(47),[G1tensor(138)])
  call ol_merge_tensors(T1sum(48),[G1tensor(144)])
  call ol_merge_tensors(T1sum(49),[G1tensor(145)])
  call ol_merge_tensors(T1sum(50),[G1tensor(151)])
  call ol_merge_tensors(T1sum(51),[G1tensor(157)])
  call ol_merge_tensors(T1sum(52),[G1tensor(163)])
  call ol_merge_tensors(T1sum(53),[G1tensor(169)])
  call ol_merge_tensors(T1sum(54),[G1tensor(175)])
  call ol_merge_tensors(T1sum(55),[G1tensor(181)])
  call ol_merge_tensors(T1sum(56),[G1tensor(187)])
  call ol_merge_tensors(T1sum(57),[G1tensor(193)])
  call ol_merge_tensors(T1sum(58),[G1tensor(199)])
  call ol_merge_tensors(T1sum(59),[G1tensor(205)])
  call ol_merge_tensors(T1sum(60),[G1tensor(211)])
  call ol_merge_tensors(T1sum(61),[G1tensor(217)])
  call ol_merge_tensors(T1sum(62),[G1tensor(223)])
  call ol_merge_tensors(T1sum(63),[G1tensor(229)])
  call ol_merge_tensors(T1sum(64),[G1tensor(235)])
  call ol_merge_tensors(T1sum(65),[G1tensor(241)])
  call ol_merge_tensors(T1sum(66),[G1tensor(247)])
  call ol_merge_tensors(T1sum(67),[G1tensor(253)])
  call ol_merge_tensors(T1sum(68),[G1tensor(259)])
  call ol_merge_tensors(T1sum(69),[G1tensor(265)])
  call ol_merge_tensors(T1sum(70),[G1tensor(271)])
  call ol_merge_tensors(T1sum(71),[G1tensor(277)])
  call ol_merge_tensors(T1sum(72),[G1tensor(283)])
  call ol_merge_tensors(T1sum(73),[G1tensor(289)])
  call ol_merge_tensors(T1sum(74),[G1tensor(295)])
  call ol_merge_tensors(T1sum(75),[G1tensor(301)])
  call ol_merge_tensors(T1sum(76),[G1tensor(307)])
  call ol_merge_tensors(T1sum(77),[G1tensor(313)])
  call ol_merge_tensors(T1sum(78),[G1tensor(319)])
  call ol_merge_tensors(T1sum(79),[G1tensor(325)])
  call ol_merge_tensors(T1sum(80),[G1tensor(331)])
  call ol_merge_tensors(T1sum(81),[G1tensor(337)])
  call ol_merge_tensors(T1sum(82),[G1tensor(343)])
  call ol_merge_tensors(T1sum(83),[G1tensor(349)])
  call ol_merge_tensors(T1sum(84),[G1tensor(355)])
  call ol_merge_tensors(T1sum(85),[G1tensor(361)])
  call ol_merge_tensors(T1sum(86),[G1tensor(367)])
  call ol_merge_tensors(T1sum(87),[G1tensor(373)])
  call ol_merge_tensors(T1sum(88),[G1tensor(379)])
  call ol_merge_tensors(T1sum(89),[G1tensor(385)])
  call ol_merge_tensors(T1sum(90),[G1tensor(391)])
  call ol_merge_tensors(T1sum(91),[G1tensor(397)])
  call ol_merge_tensors(T1sum(92),[G1tensor(403)])
  call ol_merge_tensors(T1sum(93),[G1tensor(409)])
  call ol_merge_tensors(T1sum(94),[G1tensor(415)])
  call ol_merge_tensors(T1sum(95),[G1tensor(421)])
  call ol_merge_tensors(T1sum(96),[G1tensor(427)])
  call ol_merge_tensors(T1sum(97),[G1tensor(433)])
  call ol_merge_tensors(T1sum(98),[G1tensor(439)])
  call ol_merge_tensors(T1sum(99),[G1tensor(445)])
  call ol_merge_tensors(T1sum(100),[G1tensor(451)])
  call ol_merge_tensors(T1sum(101),[G1tensor(457)])
  call ol_merge_tensors(T1sum(102),[G1tensor(463)])
  call ol_merge_tensors(T1sum(103),[G1tensor(469)])
  call ol_merge_tensors(T1sum(104),[G1tensor(475)])
  call ol_merge_tensors(T1sum(105),[G1tensor(481)])
  call ol_merge_tensors(T1sum(106),[G1tensor(487)])
  call ol_merge_tensors(T1sum(107),[G1tensor(493)])
  call ol_merge_tensors(T1sum(108),[G1tensor(499)])
  call ol_merge_tensors(T1sum(109),[G1tensor(505)])
  call ol_merge_tensors(T1sum(110),[G1tensor(511)])
  call ol_merge_tensors(T1sum(111),[G1tensor(517)])
  call ol_merge_tensors(T1sum(112),[G1tensor(523)])
  call ol_merge_tensors(T1sum(113),[G1tensor(529)])
  call ol_merge_tensors(T1sum(114),[G1tensor(535)])
  call ol_merge_tensors(T1sum(115),[G1tensor(541)])
  call ol_merge_tensors(T1sum(116),[G1tensor(547)])
  call ol_merge_tensors(T1sum(117),[G1tensor(553)])
  call ol_merge_tensors(T1sum(118),[G1tensor(559)])
  call ol_merge_tensors(T1sum(119),[G1tensor(565)])
  call ol_merge_tensors(T1sum(120),[G1tensor(571)])
  call ol_merge_tensors(T1sum(121),[G1tensor(577)])
  call ol_merge_tensors(T1sum(122),[G1tensor(583)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,10,5,16],[nME,0,nME,nME],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(61))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(241)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,5,10,16],[nME,0,nME,nME],4,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,8,5,18],[nME,nME,0,nME],4,2,wf4(:,3),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(242)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,5,18,8],[nME,0,nME,nME],4,2,wf4(:,3),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[34,5,8,16],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[34,5,16,8],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,14),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,13,2,16],[nME,0,nME,nME],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,2,13,16],[nME,0,nME,nME],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,8,2,21],[nME,nME,0,nME],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,2,21,8],[nME,0,nME,nME],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,82))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(68))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[37,2,8,16],[0,nME,nME,nME],4,1,wf8(:,56))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,56),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[37,2,16,8],[0,nME,nME,nME],4,1,wf8(:,56))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,56),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,6,9,16],[nME,0,nME,nME],4,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,9,6,16],[nME,0,nME,nME],4,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,6,17,8],[nME,0,nME,nME],4,2,wf4(:,12),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(245)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,8,6,17],[nME,nME,0,nME],4,2,wf4(:,12),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,72),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[33,6,16,8],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(3),m3h4x16(:,15),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[33,6,8,16],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(4),m3h4x16(:,16),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,14,1,16],[nME,0,nME,nME],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,14,16],[nME,0,nME,nME],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(74))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,8,1,22],[nME,nME,0,nME],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,1,22,8],[nME,0,nME,nME],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(76))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[38,1,8,16],[0,nME,nME,nME],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[38,1,16,8],[0,nME,nME,nME],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,9,18],[nME,nME,0,nME],4,2,wf4(:,11),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,18,9],[nME,nME,0,nME],4,2,wf4(:,6),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,98))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(18),n2h32(78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[34,9,4,16],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,17),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[34,4,16,9],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,18),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(6),34,nME,G1H16(17),n2h16(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,13,2,16],[nME,0,nME,nME],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(79))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,2,13,16],[nME,0,nME,nME],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,102))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(20),n2h32(80))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,2,25],[nME,nME,0,nME],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(81))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,2,25,4],[nME,0,nME,nME],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(22),n2h32(82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[41,2,4,16],[0,nME,nME,nME],4,1,wf8(:,69))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,69),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[41,2,16,4],[0,nME,nME,nME],4,1,wf8(:,69))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,69),G0H8(6),m3h8x8(:,6),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,17,10],[nME,nME,0,nME],4,2,wf4(:,14),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(23),n2h32(83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,4,10,17],[nME,nME,0,nME],4,2,wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,108))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(24),n2h32(84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[33,4,16,10],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(7),m3h4x16(:,19),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G0H16(7),33,nME,G1H16(18),n2h16(44))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[33,10,4,16],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(8),m3h4x16(:,20),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,14,1,16],[nME,0,nME,nME],4,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(25),n2h32(85))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,1,14,16],[nME,0,nME,nME],4,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(26),n2h32(86))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,4,1,26],[nME,nME,0,nME],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(27),n2h32(87))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,1,26,4],[nME,0,nME,nME],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(28),n2h32(88))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[42,1,4,16],[0,nME,nME,nME],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,58),G0H8(7),m3h8x8(:,7),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[42,1,16,4],[0,nME,nME,nME],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,58),G0H8(8),m3h8x8(:,8),heltab2x64(:,:,116))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[34,8,4,17],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,21),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(9),34,nME,G1H16(21),n2h16(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[34,4,8,17],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,22),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(10),34,nME,G1H16(22),n2h16(46))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,8,2,21],[nME,nME,0,nME],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(29),n2h32(89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,2,21,8],[nME,0,nME,nME],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(30),n2h32(90))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,4,2,25],[nME,nME,0,nME],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(31),n2h32(91))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,2,25,4],[nME,0,nME,nME],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(32),n2h32(92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[49,2,4,8],[0,nME,nME,nME],4,1,wf8(:,75))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,75),G0H8(9),m3h8x8(:,9),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[49,2,8,4],[0,nME,nME,nME],4,1,wf8(:,75))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,75),G0H8(10),m3h8x8(:,10),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[33,4,8,18],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(11),m3h4x16(:,23),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(11),33,nME,G1H16(28),n2h16(47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[33,8,4,18],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(12),m3h4x16(:,24),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(12),33,nME,G1H16(3),n2h16(48))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,8,1,22],[nME,nME,0,nME],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(33),n2h32(93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,22,8],[nME,0,nME,nME],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(34),n2h32(94))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,1,26],[nME,nME,0,nME],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(35),n2h32(95))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,1,26,4],[nME,0,nME,nME],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,96),heltab2x64(:,:,130))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(36),n2h32(96))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[50,1,4,8],[0,nME,nME,nME],4,1,wf8(:,63))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,63),G0H8(11),m3h8x8(:,11),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[50,1,8,4],[0,nME,nME,nME],4,1,wf8(:,63))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,63),G0H8(12),m3h8x8(:,12),heltab2x64(:,:,132))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[37,2,8,16],[0,nME,nME,nME],4,1,wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,40),G0H8(13),m3h8x8(:,13),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[37,2,16,8],[0,nME,nME,nME],4,1,wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,40),G0H8(14),m3h8x8(:,14),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[41,2,4,16],[0,nME,nME,nME],4,1,wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,27),G0H8(15),m3h8x8(:,15),heltab2x64(:,:,135))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[41,2,16,4],[0,nME,nME,nME],4,1,wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,27),G0H8(16),m3h8x8(:,16),heltab2x64(:,:,136))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[49,2,4,8],[0,nME,nME,nME],4,1,wf8(:,77))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,77),G0H8(17),m3h8x8(:,17),heltab2x64(:,:,137))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[49,2,8,4],[0,nME,nME,nME],4,1,wf8(:,77))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,77),G0H8(18),m3h8x8(:,18),heltab2x64(:,:,138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[38,1,8,16],[0,nME,nME,nME],4,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,34),G0H8(19),m3h8x8(:,19),heltab2x64(:,:,139))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[38,1,16,8],[0,nME,nME,nME],4,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,34),G0H8(20),m3h8x8(:,20),heltab2x64(:,:,140))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[42,1,4,16],[0,nME,nME,nME],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,14),G0H8(21),m3h8x8(:,21),heltab2x64(:,:,141))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[42,1,16,4],[0,nME,nME,nME],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,14),G0H8(22),m3h8x8(:,22),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[50,1,4,8],[0,nME,nME,nME],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(23),m3h8x8(:,23),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[50,1,8,4],[0,nME,nME,nME],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(24),m3h8x8(:,24),heltab2x64(:,:,144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(12)])
  call Hloop_AV_Q(ntryL,G1H8(41),ex3(:),G1H4(282),m3h2x4(:,191),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(282),60,nME,G2H4(71),n2h4(255))
  call Hloop_AV_Q(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,192),heltab2x8(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(1),60,nME,G2H4(74),n2h4(256))
  call Hloop_QV_A(ntryL,G1H8(59),ex5(:),G1H4(2),m3h2x4(:,193),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(2),60,nME,G2H4(107),n2h4(257))
  call Hloop_QV_A(ntryL,G1H8(67),ex3(:),G1H4(12),m3h2x4(:,194),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(12),60,nME,G2H4(110),n2h4(258))
  call Hloop_QV_A(ntryL,G1H8(77),ex4(:),G1H4(13),m3h2x4(:,195),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(13),60,nME,G2H4(111),n2h4(259))
  call Hloop_AV_Q(ntryL,G1H8(85),ex5(:),G1H4(14),m3h2x4(:,196),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(14),60,nME,G2H4(112),n2h4(260))
  call Hloop_QV_A(ntryL,G1H16(38),ex5(:),G1H8(19),m3h2x8(:,97),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(19),52,nME,G2H8(19),n2h8(109))
  call Hloop_AV_Q(ntryL,G1H16(15),ex5(:),G1H8(76),m3h2x8(:,98),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(76),52,nME,G2H8(22),n2h8(110))
  call Hloop_QV_A(ntryL,G1H16(5),ex3(:),G1H8(20),m3h2x8(:,99),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(20),44,nME,G2H8(23),n2h8(111))
  call Hloop_QV_A(ntryL,G1H16(16),ex4(:),G1H8(82),m3h2x8(:,100),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(82),44,nME,G2H8(24),n2h8(112))
  call Hloop_AV_Q(ntryL,G1H16(26),ex3(:),G1H8(23),m3h2x8(:,101),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(23),44,nME,G2H8(27),n2h8(113))
  call Hloop_AV_Q(ntryL,G1H16(7),ex4(:),G1H8(88),m3h2x8(:,102),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(88),44,nME,G2H8(28),n2h8(114))
  call Hloop_QA_V(ntryL,G1H32(1),wf4(:,4),G1H8(24),m3h4x8(:,7),heltab2x32(:,:,61))
  call Hloop_AQ_V(ntryL,G1H32(2),wf4(:,3),G1H8(94),m3h4x8(:,8),heltab2x32(:,:,62))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(33),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H16(33),40,nME,G2H16(1),n2h16(49))
  call Hloop_AQ_V(ntryL,G1H32(4),wf4(:,3),G1H8(25),m3h4x8(:,9),heltab2x32(:,:,64))
  call Hloop_VQ_A(ntryL,G0H16(1),wf4(:,3),G0H4(1),m3h4x4(:,25),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),39,nME,G1H4(19),n2h4(261))
  call Hloop_VQ_A(ntryL,G0H16(2),wf4(:,3),G0H4(1),m3h4x4(:,26),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(1),39,nME,G1H4(25),n2h4(262))
  call Hloop_AQ_V(ntryL,G1H32(5),wf8(:,9),G1H4(26),m3h8x4(:,1),heltab2x32(:,:,65))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(34),m3h2x16(:,56),heltab2x32(:,:,66))
  call Hloop_QV_A(ntryL,G1H32(7),ex4(:),G1H16(36),m3h2x16(:,57),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H16(36),40,nME,G2H16(2),n2h16(50))
  call Hloop_QA_V(ntryL,G1H32(8),ex2(:),G1H16(37),m3h2x16(:,58),heltab2x32(:,:,68))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,197),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G0H4(1),39,nME,G1H4(31),n2h4(263))
  call Hloop_VA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),m3h2x4(:,198),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(1),39,nME,G1H4(32),n2h4(264))
  call Hloop_QA_V(ntryL,G1H32(9),wf4(:,12),G1H8(100),m3h4x8(:,10),heltab2x32(:,:,69))
  call Hloop_AQ_V(ntryL,G1H32(10),wf4(:,11),G1H8(26),m3h4x8(:,11),heltab2x32(:,:,70))
  call Hloop_QA_V(ntryL,G1H32(11),wf4(:,12),G1H8(106),m3h4x8(:,12),heltab2x32(:,:,71))
  call Hloop_QV_A(ntryL,G1H32(12),ex4(:),G1H16(39),m3h2x16(:,59),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(39),40,nME,G2H16(3),n2h16(51))
  call Hloop_VA_Q(ntryL,G0H16(3),wf4(:,12),G0H4(1),m3h4x4(:,27),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(1),39,nME,G1H4(38),n2h4(265))
  call Hloop_VA_Q(ntryL,G0H16(4),wf4(:,12),G0H4(1),m3h4x4(:,28),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G0H4(1),39,nME,G1H4(43),n2h4(266))
  call Hloop_QA_V(ntryL,G1H32(13),wf8(:,25),G1H4(44),m3h8x4(:,2),heltab2x32(:,:,73))
  call Hloop_AQ_V(ntryL,G1H32(14),ex1(:),G1H16(40),m3h2x16(:,60),heltab2x32(:,:,74))
  call Hloop_AV_Q(ntryL,G1H32(15),ex4(:),G1H16(42),m3h2x16(:,61),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G1H16(42),40,nME,G2H16(4),n2h16(52))
  call Hloop_AQ_V(ntryL,G1H32(16),ex1(:),G1H16(43),m3h2x16(:,62),heltab2x32(:,:,76))
  call Hloop_VQ_A(ntryL,G0H8(19),ex1(:),G0H4(1),m3h2x4(:,199),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(1),39,nME,G1H4(48),n2h4(267))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),m3h2x4(:,200),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G0H4(1),39,nME,G1H4(55),n2h4(268))
  call Hloop_AV_Q(ntryL,G1H32(17),ex3(:),G1H16(44),m3h2x16(:,63),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H16(44),36,nME,G2H16(5),n2h16(53))
  call Hloop_QV_A(ntryL,G1H32(18),ex3(:),G1H16(19),m3h2x16(:,64),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(19),36,nME,G2H16(6),n2h16(54))
  call Hloop_VQ_A(ntryL,G0H16(5),wf4(:,11),G0H4(1),m3h4x4(:,29),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(1),43,nME,G1H4(56),n2h4(269))
  call Hloop_AV_Q(ntryL,G1H16(17),ex3(:),G1H8(37),m3h2x8(:,103),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(37),38,nME,G2H8(39),n2h8(115))
  call Hloop_AQ_V(ntryL,G1H32(19),wf8(:,30),G1H4(60),m3h8x4(:,3),heltab2x32(:,:,79))
  call Hloop_QA_V(ntryL,G1H32(20),ex2(:),G1H16(25),m3h2x16(:,65),heltab2x32(:,:,80))
  call Hloop_QV_A(ntryL,G1H32(21),ex3(:),G1H16(29),m3h2x16(:,66),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(29),36,nME,G2H16(13),n2h16(55))
  call Hloop_QA_V(ntryL,G1H32(22),ex2(:),G1H16(35),m3h2x16(:,67),heltab2x32(:,:,82))
  call Hloop_VA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),m3h2x4(:,201),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(1),43,nME,G1H4(61),n2h4(270))
  call Hloop_VA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),m3h2x4(:,202),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(1),43,nME,G1H4(68),n2h4(271))
  call Hloop_AV_Q(ntryL,G1H32(23),ex3(:),G1H16(41),m3h2x16(:,68),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(41),36,nME,G2H16(14),n2h16(56))
  call Hloop_QV_A(ntryL,G1H32(24),ex3(:),G1H16(6),m3h2x16(:,69),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(6),36,nME,G2H16(15),n2h16(57))
  call Hloop_QV_A(ntryL,G1H16(18),ex3(:),G1H8(38),m3h2x8(:,104),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G1H8(38),37,nME,G2H8(42),n2h8(116))
  call Hloop_VA_Q(ntryL,G0H16(8),wf4(:,4),G0H4(1),m3h4x4(:,30),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H4(1),43,nME,G1H4(72),n2h4(272))
  call Hloop_QA_V(ntryL,G1H32(25),wf8(:,38),G1H4(73),m3h8x4(:,4),heltab2x32(:,:,85))
  call Hloop_AQ_V(ntryL,G1H32(26),ex1(:),G1H16(9),m3h2x16(:,70),heltab2x32(:,:,86))
  call Hloop_AV_Q(ntryL,G1H32(27),ex3(:),G1H16(10),m3h2x16(:,71),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(10),36,nME,G2H16(16),n2h16(58))
  call Hloop_AQ_V(ntryL,G1H32(28),ex1(:),G1H16(13),m3h2x16(:,72),heltab2x32(:,:,88))
  call Hloop_VQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),m3h2x4(:,203),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G0H4(1),43,nME,G1H4(74),n2h4(273))
  call Hloop_VQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),m3h2x4(:,204),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(1),43,nME,G1H4(84),n2h4(274))
  call Hloop_AV_Q(ntryL,G1H16(21),ex4(:),G1H8(42),m3h2x8(:,105),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(42),42,nME,G2H8(43),n2h8(117))
  call Hloop_AV_Q(ntryL,G1H16(22),ex3(:),G1H8(43),m3h2x8(:,106),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(43),38,nME,G2H8(44),n2h8(118))
  call Hloop_QV_A(ntryL,G1H32(29),ex4(:),G1H16(14),m3h2x16(:,73),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(14),40,nME,G2H16(17),n2h16(59))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(1),m3h2x16(:,74),heltab2x32(:,:,90))
  call Hloop_QV_A(ntryL,G1H32(31),ex3(:),G1H16(2),m3h2x16(:,75),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H16(2),36,nME,G2H16(18),n2h16(60))
  call Hloop_QA_V(ntryL,G1H32(32),ex2(:),G1H16(20),m3h2x16(:,76),heltab2x32(:,:,92))
  call Hloop_VA_Q(ntryL,G0H8(17),ex2(:),G0H4(1),m3h2x4(:,205),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(1),51,nME,G1H4(85),n2h4(275))
  call Hloop_VA_Q(ntryL,G0H8(18),ex2(:),G0H4(1),m3h2x4(:,206),heltab2x8(:,:,224))
  call Hloop_A_Q(ntryL,G0H4(1),51,nME,G1H4(86),n2h4(276))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(44),m3h2x8(:,107),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(44),37,nME,G2H8(47),n2h8(119))
  call Hloop_QV_A(ntryL,G1H16(3),ex4(:),G1H8(47),m3h2x8(:,108),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(47),41,nME,G2H8(48),n2h8(120))
  call Hloop_AV_Q(ntryL,G1H32(33),ex4(:),G1H16(23),m3h2x16(:,77),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H16(23),40,nME,G2H16(7),n2h16(61))
  call Hloop_AQ_V(ntryL,G1H32(34),ex1(:),G1H16(24),m3h2x16(:,78),heltab2x32(:,:,94))
  call Hloop_AV_Q(ntryL,G1H32(35),ex3(:),G1H16(27),m3h2x16(:,79),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G1H16(27),36,nME,G2H16(8),n2h16(62))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(4),m3h2x16(:,80),heltab2x32(:,:,96))
  call Hloop_VQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),m3h2x4(:,207),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(1),51,nME,G1H4(91),n2h4(277))
  call Hloop_VQ_A(ntryL,G0H8(24),ex1(:),G0H4(1),m3h2x4(:,208),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G0H4(1),51,nME,G1H4(97),n2h4(278))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(114),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(139),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(129),[G2H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G2H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G2H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(266),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(26),G1H4(326),G1H4(139),G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(329),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(333),[G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(339),[G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(44),G1H4(342),G1H4(181),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(345),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(349),[G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(355),[G1H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(397),[G1H4(358),G1H4(80),G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(354),[G1H4(348),G1H4(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(290),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(436),[G1H4(361),G1H4(88),G1H4(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(325),G1H4(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(314),[G1H4(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(445),[G1H4(364),G1H4(184),G1H4(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(367),G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(388),[G1H4(373),G1H4(50),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(71),G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(376),G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(409),[G1H4(382),G1H4(101),G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(454),[G1H4(385),G1H4(256),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(338),[G1H4(332),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(391),G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(143),G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(400),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(406),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(35),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(418),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(179),G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(421),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(427),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(430),G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(131),G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(439),G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(448),G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(83),G1H4(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(457),[G1H4(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(463),[G1H4(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(466),[G1H4(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(472),[G1H4(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(95),G1H4(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(475),[G1H4(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(481),[G1H4(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(372),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(381),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(405),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(417),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(426),[G1H4(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(435),[G1H4(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(444),[G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(453),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(462),[G1H4(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(471),[G1H4(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(480),[G1H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(64)])
call HGT_lower_alpha_w2_OLR(G2H4(141),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(141),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(141),6,15,4)
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(263),mass4set(:,5),  & 
G1H4(98),G1H4(103),G1H4(104),G1H4(110),G1H4(115),4)
  call HG1shiftOLR(G1H4(103),1,4)
  call Hloop_AQ_V(ntryL,G2H4(114),ex1(:),G2H2(167),m3h2x2(:,529),heltab2x4(:,:,553))
call HGT_lower_alpha_w2_OLR(G2H4(142),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(142),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(142),6,15,4)
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(264),mass4set(:,5),  & 
G1H4(5),G1H4(17),G1H4(53),G1H4(65),G1H4(77),4)
  call HG1shiftOLR(G1H4(17),1,4)
call HGT_lower_alpha_w2_OLR(G2H4(137),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(137),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(137),6,15,4)
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(265),mass4set(:,5),  & 
G1H4(89),G1H4(113),G1H4(75),G1H4(125),G1H4(137),4)
  call HG1shiftOLR(G1H4(113),2,4)
  call Hloop_QA_V(ntryL,G2H4(119),ex2(:),G2H2(169),m3h2x2(:,530),heltab2x4(:,:,554))
call HGT_lower_alpha_w2_OLR(G2H4(139),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(139),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(139),6,15,4)
  call Hotf_4pt_reduction(G2H4(139),RedSet_4(266),mass4set(:,5),  & 
G1H4(147),G1H4(173),G1H4(39),G1H4(185),G1H4(209),4)
  call HG1shiftOLR(G1H4(173),2,4)
  call Hloop_QA_V(ntryL,G2H4(129),ex2(:),G2H2(170),m3h2x2(:,531),heltab2x4(:,:,555))
call HGT_lower_alpha_w2_OLR(G2H4(140),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(140),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(140),6,15,4)
  call Hotf_4pt_reduction(G2H4(140),RedSet_4(267),mass4set(:,5),  & 
G1H4(221),G1H4(135),G1H4(233),G1H4(257),G1H4(269),4)
  call HG1shiftOLR(G1H4(135),2,4)
call HGT_lower_alpha_w2_OLR(G2H4(138),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(138),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(138),6,15,4)
  call Hotf_4pt_reduction(G2H4(138),RedSet_4(268),mass4set(:,5),  & 
G1H4(99),G1H4(281),G1H4(10),G1H4(15),G1H4(27),4)
  call HG1shiftOLR(G1H4(281),1,4)
  call Hloop_AQ_V(ntryL,G2H4(134),ex1(:),G2H2(172),m3h2x2(:,532),heltab2x4(:,:,556))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(115),m3h2x4(:,209),heltab2x8(:,:,227))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(116),m3h2x4(:,210),heltab2x8(:,:,228))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(117),m3h2x4(:,211),heltab2x8(:,:,229))
  call Hloop_AQ_V(ntryL,G2H8(26),ex1(:),G2H4(120),m3h2x4(:,212),heltab2x8(:,:,230))
  call Hloop_VA_Q(ntryL,G1H4(266),ex2(:),G1H2(134),m3h2x2(:,533),heltab2x4(:,:,557))
  call Hloop_A_Q(ntryL,G1H2(134),47,nME,G2H2(173),n2h2(401))
  call Hloop_VA_Q(ntryL,G1H4(60),ex2(:),G1H2(8),m3h2x2(:,534),heltab2x4(:,:,558))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(175),n2h2(402))
  call Hloop_VA_Q(ntryL,G1H4(329),ex2(:),G1H2(56),m3h2x2(:,535),heltab2x4(:,:,559))
  call Hloop_A_Q(ntryL,G1H2(56),47,nME,G2H2(176),n2h2(403))
  call Hloop_VQ_A(ntryL,G1H4(333),ex1(:),G1H2(74),m3h2x2(:,536),heltab2x4(:,:,560))
  call Hloop_Q_A(ntryL,G1H2(74),55,nME,G2H2(178),n2h2(404))
  call Hloop_VQ_A(ntryL,G1H4(339),ex1(:),G1H2(12),m3h2x2(:,537),heltab2x4(:,:,561))
  call Hloop_Q_A(ntryL,G1H2(12),55,nME,G2H2(179),n2h2(405))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(48),m3h2x2(:,538),heltab2x4(:,:,562))
  call Hloop_Q_A(ntryL,G1H2(48),47,nME,G2H2(181),n2h2(406))
  call Hloop_VQ_A(ntryL,G1H4(73),ex1(:),G1H2(126),m3h2x2(:,539),heltab2x4(:,:,563))
  call Hloop_Q_A(ntryL,G1H2(126),47,nME,G2H2(182),n2h2(407))
  call Hloop_VQ_A(ntryL,G1H4(345),ex1(:),G1H2(144),m3h2x2(:,540),heltab2x4(:,:,564))
  call Hloop_Q_A(ntryL,G1H2(144),47,nME,G2H2(184),n2h2(408))
  call Hloop_VA_Q(ntryL,G1H4(349),ex2(:),G1H2(33),m3h2x2(:,541),heltab2x4(:,:,565))
  call Hloop_A_Q(ntryL,G1H2(33),55,nME,G2H2(209),n2h2(409))
  call Hloop_VA_Q(ntryL,G1H4(355),ex2(:),G1H2(47),m3h2x2(:,542),heltab2x4(:,:,566))
  call Hloop_A_Q(ntryL,G1H2(47),55,nME,G2H2(33),n2h2(410))
  call Hloop_VQ_A(ntryL,G1H4(206),ex1(:),G1H2(87),m3h2x2(:,543),heltab2x4(:,:,567))
  call Hloop_Q_A(ntryL,G1H2(87),59,nME,G2H2(212),n2h2(411))
  call Hloop_VQ_A(ntryL,G1H4(211),ex1(:),G1H2(100),m3h2x2(:,544),heltab2x4(:,:,568))
  call Hloop_Q_A(ntryL,G1H2(100),59,nME,G2H2(35),n2h2(412))
  call Hloop_QV_A(ntryL,G1H4(186),ex3(:),G1H2(131),m3h2x2(:,545),heltab2x4(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(131),47,nME,G2H2(217),n2h2(413))
  call Hloop_QV_A(ntryL,G1H4(397),ex3(:),G1H2(143),m3h2x2(:,546),heltab2x4(:,:,570))
  call Hloop_Q_A(ntryL,G1H2(143),47,nME,G2H2(38),n2h2(414))
  call Hloop_VA_Q(ntryL,G1H4(354),ex2(:),G1H2(160),m3h2x2(:,547),heltab2x4(:,:,571))
  call Hloop_A_Q(ntryL,G1H2(160),55,nME,G2H2(220),n2h2(415))
  call Hloop_VA_Q(ntryL,G1H4(240),ex2(:),G1H2(166),m3h2x2(:,548),heltab2x4(:,:,572))
  call Hloop_A_Q(ntryL,G1H2(166),55,nME,G2H2(40),n2h2(416))
  call Hloop_AV_Q(ntryL,G1H4(290),ex4(:),G1H2(182),m3h2x2(:,549),heltab2x4(:,:,573))
  call Hloop_A_Q(ntryL,G1H2(182),47,nME,G2H2(225),n2h2(417))
  call Hloop_AV_Q(ntryL,G1H4(436),ex4(:),G1H2(188),m3h2x2(:,550),heltab2x4(:,:,574))
  call Hloop_A_Q(ntryL,G1H2(188),47,nME,G2H2(43),n2h2(418))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(204),m3h2x2(:,551),heltab2x4(:,:,575))
  call Hloop_A_Q(ntryL,G1H2(204),47,nME,G2H2(228),n2h2(419))
  call Hloop_AV_Q(ntryL,G1H4(314),ex5(:),G1H2(210),m3h2x2(:,552),heltab2x4(:,:,576))
  call Hloop_A_Q(ntryL,G1H2(210),55,nME,G2H2(45),n2h2(420))
  call Hloop_AV_Q(ntryL,G1H4(445),ex5(:),G1H2(226),m3h2x2(:,553),heltab2x4(:,:,577))
  call Hloop_A_Q(ntryL,G1H2(226),55,nME,G2H2(233),n2h2(421))
  call Hloop_QV_A(ntryL,G1H4(91),ex3(:),G1H2(232),m3h2x2(:,554),heltab2x4(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(232),55,nME,G2H2(48),n2h2(422))
  call Hloop_QV_A(ntryL,G1H4(42),ex3(:),G1H2(248),m3h2x2(:,555),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(248),55,nME,G2H2(236),n2h2(423))
  call Hloop_QV_A(ntryL,G1H4(19),ex4(:),G1H2(254),m3h2x2(:,556),heltab2x4(:,:,580))
  call Hloop_Q_A(ntryL,G1H2(254),47,nME,G2H2(50),n2h2(424))
  call Hloop_QV_A(ntryL,G1H4(388),ex4(:),G1H2(270),m3h2x2(:,557),heltab2x4(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(270),47,nME,G2H2(241),n2h2(425))
  call Hloop_QV_A(ntryL,G1H4(74),ex3(:),G1H2(276),m3h2x2(:,558),heltab2x4(:,:,582))
  call Hloop_Q_A(ntryL,G1H2(276),47,nME,G2H2(53),n2h2(426))
  call Hloop_QV_A(ntryL,G1H4(25),ex5(:),G1H2(292),m3h2x2(:,559),heltab2x4(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(292),55,nME,G2H2(244),n2h2(427))
  call Hloop_QV_A(ntryL,G1H4(409),ex5(:),G1H2(303),m3h2x2(:,560),heltab2x4(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(303),55,nME,G2H2(55),n2h2(428))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(309),m3h2x2(:,561),heltab2x4(:,:,585))
  call Hloop_A_Q(ntryL,G1H2(309),59,nME,G2H2(249),n2h2(429))
  call Hloop_VA_Q(ntryL,G1H4(8),ex2(:),G1H2(325),m3h2x2(:,562),heltab2x4(:,:,586))
  call Hloop_A_Q(ntryL,G1H2(325),59,nME,G2H2(58),n2h2(430))
  call Hloop_AV_Q(ntryL,G1H4(136),ex3(:),G1H2(331),m3h2x2(:,563),heltab2x4(:,:,587))
  call Hloop_A_Q(ntryL,G1H2(331),47,nME,G2H2(252),n2h2(431))
  call Hloop_AV_Q(ntryL,G1H4(454),ex3(:),G1H2(347),m3h2x2(:,564),heltab2x4(:,:,588))
  call Hloop_A_Q(ntryL,G1H2(347),47,nME,G2H2(60),n2h2(432))
  call Hloop_VQ_A(ntryL,G1H4(338),ex1(:),G1H2(358),m3h2x2(:,565),heltab2x4(:,:,589))
  call Hloop_Q_A(ntryL,G1H2(358),55,nME,G2H2(257),n2h2(433))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(369),m3h2x2(:,566),heltab2x4(:,:,590))
  call Hloop_Q_A(ntryL,G1H2(369),55,nME,G2H2(63),n2h2(434))
  call Hloop_QV_A(ntryL,G1H4(96),ex4(:),G1H2(375),m3h2x2(:,567),heltab2x4(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(375),47,nME,G2H2(260),n2h2(435))
  call Hloop_QV_A(ntryL,G1H4(97),ex4(:),G1H2(391),m3h2x2(:,568),heltab2x4(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(391),59,nME,G2H2(65),n2h2(436))
  call Hloop_QV_A(ntryL,G1H4(67),ex4(:),G1H2(397),m3h2x2(:,569),heltab2x4(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(397),59,nME,G2H2(265),n2h2(437))
  call Hloop_QV_A(ntryL,G1H4(56),ex3(:),G1H2(413),m3h2x2(:,570),heltab2x4(:,:,594))
  call Hloop_Q_A(ntryL,G1H2(413),47,nME,G2H2(268),n2h2(438))
  call Hloop_QV_A(ntryL,G1H4(48),ex4(:),G1H2(424),m3h2x2(:,571),heltab2x4(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(424),47,nME,G2H2(273),n2h2(439))
  call Hloop_QV_A(ntryL,G1H4(400),ex5(:),G1H2(430),m3h2x2(:,572),heltab2x4(:,:,596))
  call Hloop_Q_A(ntryL,G1H2(430),59,nME,G2H2(73),n2h2(440))
  call Hloop_QV_A(ntryL,G1H4(406),ex5(:),G1H2(446),m3h2x2(:,573),heltab2x4(:,:,597))
  call Hloop_Q_A(ntryL,G1H2(446),59,nME,G2H2(276),n2h2(441))
  call Hloop_VQ_A(ntryL,G1H4(47),ex1(:),G1H2(457),m3h2x2(:,574),heltab2x4(:,:,598))
  call Hloop_Q_A(ntryL,G1H2(457),47,nME,G2H2(75),n2h2(442))
  call Hloop_QV_A(ntryL,G1H4(87),ex5(:),G1H2(468),m3h2x2(:,575),heltab2x4(:,:,599))
  call Hloop_Q_A(ntryL,G1H2(468),55,nME,G2H2(281),n2h2(443))
  call Hloop_QV_A(ntryL,G1H4(84),ex5(:),G1H2(474),m3h2x2(:,576),heltab2x4(:,:,600))
  call Hloop_Q_A(ntryL,G1H2(474),59,nME,G2H2(78),n2h2(444))
  call Hloop_QV_A(ntryL,G1H4(161),ex5(:),G1H2(480),m3h2x2(:,577),heltab2x4(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(480),59,nME,G2H2(284),n2h2(445))
  call Hloop_QV_A(ntryL,G1H4(412),ex3(:),G1H2(486),m3h2x2(:,578),heltab2x4(:,:,602))
  call Hloop_Q_A(ntryL,G1H2(486),55,nME,G2H2(80),n2h2(446))
  call Hloop_QV_A(ntryL,G1H4(418),ex3(:),G1H2(492),m3h2x2(:,579),heltab2x4(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(492),55,nME,G2H2(289),n2h2(447))
  call Hloop_QV_A(ntryL,G1H4(55),ex5(:),G1H2(498),m3h2x2(:,580),heltab2x4(:,:,604))
  call Hloop_Q_A(ntryL,G1H2(498),55,nME,G2H2(292),n2h2(448))
  call Hloop_QV_A(ntryL,G1H4(421),ex4(:),G1H2(504),m3h2x2(:,581),heltab2x4(:,:,605))
  call Hloop_Q_A(ntryL,G1H2(504),59,nME,G2H2(297),n2h2(449))
  call Hloop_QV_A(ntryL,G1H4(427),ex4(:),G1H2(510),m3h2x2(:,582),heltab2x4(:,:,606))
  call Hloop_Q_A(ntryL,G1H2(510),59,nME,G2H2(300),n2h2(450))
  call Hloop_AV_Q(ntryL,G1H4(85),ex3(:),G1H2(516),m3h2x2(:,583),heltab2x4(:,:,607))
  call Hloop_A_Q(ntryL,G1H2(516),55,nME,G2H2(305),n2h2(451))
  call Hloop_AV_Q(ntryL,G1H4(40),ex3(:),G1H2(522),m3h2x2(:,584),heltab2x4(:,:,608))
  call Hloop_A_Q(ntryL,G1H2(522),55,nME,G2H2(93),n2h2(452))
  call Hloop_AV_Q(ntryL,G1H4(43),ex4(:),G1H2(528),m3h2x2(:,585),heltab2x4(:,:,609))
  call Hloop_A_Q(ntryL,G1H2(528),47,nME,G2H2(308),n2h2(453))
  call Hloop_AV_Q(ntryL,G1H4(61),ex3(:),G1H2(534),m3h2x2(:,586),heltab2x4(:,:,610))
  call Hloop_A_Q(ntryL,G1H2(534),47,nME,G2H2(95),n2h2(454))
  call Hloop_AV_Q(ntryL,G1H4(38),ex5(:),G1H2(540),m3h2x2(:,587),heltab2x4(:,:,611))
  call Hloop_A_Q(ntryL,G1H2(540),55,nME,G2H2(313),n2h2(455))
  call Hloop_AV_Q(ntryL,G1H4(86),ex4(:),G1H2(546),m3h2x2(:,588),heltab2x4(:,:,612))
  call Hloop_A_Q(ntryL,G1H2(546),59,nME,G2H2(98),n2h2(456))
  call Hloop_AV_Q(ntryL,G1H4(220),ex4(:),G1H2(552),m3h2x2(:,589),heltab2x4(:,:,613))
  call Hloop_A_Q(ntryL,G1H2(552),59,nME,G2H2(316),n2h2(457))
  call Hloop_AV_Q(ntryL,G1H4(72),ex3(:),G1H2(558),m3h2x2(:,590),heltab2x4(:,:,614))
  call Hloop_A_Q(ntryL,G1H2(558),47,nME,G2H2(100),n2h2(458))
  call Hloop_AV_Q(ntryL,G1H4(31),ex4(:),G1H2(564),m3h2x2(:,591),heltab2x4(:,:,615))
  call Hloop_A_Q(ntryL,G1H2(564),47,nME,G2H2(321),n2h2(459))
  call Hloop_AV_Q(ntryL,G1H4(457),ex5(:),G1H2(570),m3h2x2(:,592),heltab2x4(:,:,616))
  call Hloop_A_Q(ntryL,G1H2(570),59,nME,G2H2(324),n2h2(460))
  call Hloop_AV_Q(ntryL,G1H4(463),ex5(:),G1H2(576),m3h2x2(:,593),heltab2x4(:,:,617))
  call Hloop_A_Q(ntryL,G1H2(576),59,nME,G2H2(329),n2h2(461))
  call Hloop_AV_Q(ntryL,G1H4(68),ex5(:),G1H2(582),m3h2x2(:,594),heltab2x4(:,:,618))
  call Hloop_A_Q(ntryL,G1H2(582),59,nME,G2H2(108),n2h2(462))
  call Hloop_AV_Q(ntryL,G1H4(302),ex5(:),G1H2(588),m3h2x2(:,595),heltab2x4(:,:,619))
  call Hloop_A_Q(ntryL,G1H2(588),59,nME,G2H2(332),n2h2(463))
  call Hloop_AV_Q(ntryL,G1H4(466),ex3(:),G1H2(594),m3h2x2(:,596),heltab2x4(:,:,620))
  call Hloop_A_Q(ntryL,G1H2(594),55,nME,G2H2(110),n2h2(464))
  call Hloop_AV_Q(ntryL,G1H4(472),ex3(:),G1H2(600),m3h2x2(:,597),heltab2x4(:,:,621))
  call Hloop_A_Q(ntryL,G1H2(600),55,nME,G2H2(337),n2h2(465))
  call Hloop_AV_Q(ntryL,G1H4(32),ex5(:),G1H2(606),m3h2x2(:,598),heltab2x4(:,:,622))
  call Hloop_A_Q(ntryL,G1H2(606),55,nME,G2H2(340),n2h2(466))
  call Hloop_AV_Q(ntryL,G1H4(475),ex4(:),G1H2(612),m3h2x2(:,599),heltab2x4(:,:,623))
  call Hloop_A_Q(ntryL,G1H2(612),59,nME,G2H2(345),n2h2(467))
  call Hloop_AV_Q(ntryL,G1H4(481),ex4(:),G1H2(618),m3h2x2(:,600),heltab2x4(:,:,624))
  call Hloop_A_Q(ntryL,G1H2(618),59,nME,G2H2(348),n2h2(468))
  call Hloop_QV_A(ntryL,G1H4(372),ex4(:),G1H2(624),m3h2x2(:,601),heltab2x4(:,:,625))
  call Hloop_Q_A(ntryL,G1H2(624),47,nME,G2H2(2),n2h2(469))
  call Hloop_QV_A(ntryL,G1H4(381),ex5(:),G1H2(630),m3h2x2(:,602),heltab2x4(:,:,626))
  call Hloop_Q_A(ntryL,G1H2(630),55,nME,G2H2(3),n2h2(470))
  call Hloop_QV_A(ntryL,G1H4(396),ex3(:),G1H2(636),m3h2x2(:,603),heltab2x4(:,:,627))
  call Hloop_Q_A(ntryL,G1H2(636),47,nME,G2H2(4),n2h2(471))
  call Hloop_QV_A(ntryL,G1H4(405),ex5(:),G1H2(642),m3h2x2(:,604),heltab2x4(:,:,628))
  call Hloop_Q_A(ntryL,G1H2(642),59,nME,G2H2(5),n2h2(472))
  call Hloop_QV_A(ntryL,G1H4(417),ex3(:),G1H2(648),m3h2x2(:,605),heltab2x4(:,:,629))
  call Hloop_Q_A(ntryL,G1H2(648),55,nME,G2H2(7),n2h2(473))
  call Hloop_QV_A(ntryL,G1H4(426),ex4(:),G1H2(654),m3h2x2(:,606),heltab2x4(:,:,630))
  call Hloop_Q_A(ntryL,G1H2(654),59,nME,G2H2(8),n2h2(474))
  call Hloop_AV_Q(ntryL,G1H4(435),ex4(:),G1H2(660),m3h2x2(:,607),heltab2x4(:,:,631))
  call Hloop_A_Q(ntryL,G1H2(660),47,nME,G2H2(9),n2h2(475))
  call Hloop_AV_Q(ntryL,G1H4(444),ex5(:),G1H2(666),m3h2x2(:,608),heltab2x4(:,:,632))
  call Hloop_A_Q(ntryL,G1H2(666),55,nME,G2H2(10),n2h2(476))
  call Hloop_AV_Q(ntryL,G1H4(453),ex3(:),G1H2(672),m3h2x2(:,609),heltab2x4(:,:,633))
  call Hloop_A_Q(ntryL,G1H2(672),47,nME,G2H2(12),n2h2(477))
  call Hloop_AV_Q(ntryL,G1H4(462),ex5(:),G1H2(678),m3h2x2(:,610),heltab2x4(:,:,634))
  call Hloop_A_Q(ntryL,G1H2(678),59,nME,G2H2(13),n2h2(478))
  call Hloop_AV_Q(ntryL,G1H4(471),ex3(:),G1H2(684),m3h2x2(:,611),heltab2x4(:,:,635))
  call Hloop_A_Q(ntryL,G1H2(684),55,nME,G2H2(14),n2h2(479))
  call Hloop_AV_Q(ntryL,G1H4(480),ex4(:),G1H2(690),m3h2x2(:,612),heltab2x4(:,:,636))
  call Hloop_A_Q(ntryL,G1H2(690),59,nME,G2H2(15),n2h2(480))
  call Hloop_VQ_A(ntryL,G1H8(51),wf4(:,3),G1H2(696),m3h4x2(:,19),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(696),47,nME,G2H2(17),n2h2(481))
  call Hloop_VQ_A(ntryL,G1H8(24),wf4(:,3),G1H2(702),m3h4x2(:,20),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(702),47,nME,G2H2(18),n2h2(482))
  call Hloop_VA_Q(ntryL,G1H8(87),wf4(:,12),G1H2(708),m3h4x2(:,21),heltab2x8(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(708),47,nME,G2H2(19),n2h2(483))
  call Hloop_VA_Q(ntryL,G1H8(26),wf4(:,12),G1H2(714),m3h4x2(:,22),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(714),47,nME,G2H2(20),n2h2(484))
  call Hloop_VQ_A(ntryL,G1H8(9),wf4(:,11),G1H2(720),m3h4x2(:,23),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(720),47,nME,G2H2(22),n2h2(485))
  call Hloop_VQ_A(ntryL,G1H8(100),wf4(:,11),G1H2(726),m3h4x2(:,24),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(726),47,nME,G2H2(23),n2h2(486))
  call Hloop_VA_Q(ntryL,G1H8(30),wf4(:,4),G1H2(732),m3h4x2(:,25),heltab2x8(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(732),47,nME,G2H2(24),n2h2(487))
  call Hloop_VA_Q(ntryL,G1H8(94),wf4(:,4),G1H2(738),m3h4x2(:,26),heltab2x8(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(738),47,nME,G2H2(25),n2h2(488))
  call Hloop_VQ_A(ntryL,G1H8(31),wf4(:,14),G1H2(744),m3h4x2(:,27),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(744),55,nME,G2H2(27),n2h2(489))
  call Hloop_VQ_A(ntryL,G1H8(106),wf4(:,14),G1H2(750),m3h4x2(:,28),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(750),55,nME,G2H2(28),n2h2(490))
  call Hloop_VA_Q(ntryL,G1H8(35),wf4(:,6),G1H2(756),m3h4x2(:,29),heltab2x8(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(756),55,nME,G2H2(29),n2h2(491))
  call Hloop_VA_Q(ntryL,G1H8(25),wf4(:,6),G1H2(762),m3h4x2(:,30),heltab2x8(:,:,242))
  call Hloop_A_Q(ntryL,G1H2(762),55,nME,G2H2(30),n2h2(492))
  call Hloop_AQ_V(ntryL,G2H4(71),ex1(:),G2H2(32),m3h2x2(:,613),heltab2x4(:,:,637))
  call Hloop_AQ_V(ntryL,G2H4(74),ex1(:),G2H2(505),m3h2x2(:,614),heltab2x4(:,:,638))
  call Hloop_QA_V(ntryL,G2H4(107),ex2(:),G2H2(34),m3h2x2(:,615),heltab2x4(:,:,639))
  call Hloop_QA_V(ntryL,G2H4(110),ex2(:),G2H2(507),m3h2x2(:,616),heltab2x4(:,:,640))
  call Hloop_QA_V(ntryL,G2H4(111),ex2(:),G2H2(37),m3h2x2(:,617),heltab2x4(:,:,641))
  call Hloop_AQ_V(ntryL,G2H4(112),ex1(:),G2H2(514),m3h2x2(:,618),heltab2x4(:,:,642))
  call Hloop_QA_V(ntryL,G2H8(19),ex2(:),G2H4(121),m3h2x4(:,213),heltab2x8(:,:,243))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(122),m3h2x4(:,214),heltab2x8(:,:,244))
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(125),m3h2x4(:,215),heltab2x8(:,:,245))
  call Hloop_QA_V(ntryL,G2H8(24),ex2(:),G2H4(126),m3h2x4(:,216),heltab2x8(:,:,246))
  call Hloop_AQ_V(ntryL,G2H8(27),ex1(:),G2H4(127),m3h2x4(:,217),heltab2x8(:,:,247))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(130),m3h2x4(:,218),heltab2x8(:,:,248))
  call Hloop_AQ_V(ntryL,G2H16(1),wf4(:,3),G2H4(131),m3h4x4(:,31),heltab2x16(:,:,139))
  call Hloop_VQ_A(ntryL,G1H16(34),wf8(:,9),G1H2(768),m3h8x2(:,1),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(768),47,nME,G2H2(39),n2h2(493))
  call Hloop_QA_V(ntryL,G2H16(2),ex2(:),G2H8(29),m3h2x8(:,109),heltab2x16(:,:,141))
  call Hloop_VQ_A(ntryL,G1H16(37),wf8(:,3),G1H2(774),m3h8x2(:,2),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(774),55,nME,G2H2(516),n2h2(494))
  call Hloop_QA_V(ntryL,G2H16(3),wf4(:,12),G2H4(132),m3h4x4(:,32),heltab2x16(:,:,143))
  call Hloop_VA_Q(ntryL,G1H16(40),wf8(:,25),G1H2(780),m3h8x2(:,3),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(780),47,nME,G2H2(42),n2h2(495))
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(32),m3h2x8(:,110),heltab2x16(:,:,145))
  call Hloop_VA_Q(ntryL,G1H16(43),wf8(:,20),G1H2(786),m3h8x2(:,4),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(786),55,nME,G2H2(520),n2h2(496))
  call Hloop_AQ_V(ntryL,G2H16(5),wf4(:,11),G2H4(135),m3h4x4(:,33),heltab2x16(:,:,147))
  call Hloop_QA_V(ntryL,G2H16(6),wf4(:,6),G2H4(136),m3h4x4(:,34),heltab2x16(:,:,148))
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(269),mass4set(:,5),  & 
G1H8(48),G1H8(50),G1H8(53),G1H8(54),G1H8(55),8)
  call HG1shiftOLR(G1H8(50),9,8)
  call Hloop_VQ_A(ntryL,G1H16(25),wf8(:,30),G1H2(792),m3h8x2(:,5),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(792),47,nME,G2H2(44),n2h2(497))
  call Hloop_QA_V(ntryL,G2H16(13),ex2(:),G2H8(33),m3h2x8(:,111),heltab2x16(:,:,150))
  call Hloop_VQ_A(ntryL,G1H16(35),wf8(:,17),G1H2(798),m3h8x2(:,6),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(798),59,nME,G2H2(522),n2h2(498))
  call Hloop_AQ_V(ntryL,G2H16(14),wf4(:,14),G2H4(23),m3h4x4(:,35),heltab2x16(:,:,152))
  call Hloop_QA_V(ntryL,G2H16(15),wf4(:,4),G2H4(73),m3h4x4(:,36),heltab2x16(:,:,153))
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(270),mass4set(:,5),  & 
G1H8(56),G1H8(60),G1H8(61),G1H8(62),G1H8(65),8)
  call HG1shiftOLR(G1H8(60),10,8)
  call Hloop_VA_Q(ntryL,G1H16(9),wf8(:,38),G1H2(804),m3h8x2(:,7),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(804),47,nME,G2H2(47),n2h2(499))
  call Hloop_AQ_V(ntryL,G2H16(16),ex1(:),G2H8(34),m3h2x8(:,112),heltab2x16(:,:,155))
  call Hloop_VA_Q(ntryL,G1H16(13),wf8(:,6),G1H2(810),m3h8x2(:,8),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(810),59,nME,G2H2(68),n2h2(500))
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(271),mass4set(:,5),  & 
G1H8(66),G1H8(68),G1H8(71),G1H8(72),G1H8(73),8)
  call HG1shiftOLR(G1H8(68),17,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(272),mass4set(:,5),  & 
G1H8(74),G1H8(78),G1H8(79),G1H8(80),G1H8(83),8)
  call HG1shiftOLR(G1H8(78),17,8)
  call Hloop_QA_V(ntryL,G2H16(17),ex2(:),G2H8(37),m3h2x8(:,113),heltab2x16(:,:,157))
  call Hloop_VQ_A(ntryL,G1H16(1),wf8(:,36),G1H2(816),m3h8x2(:,9),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(816),55,nME,G2H2(49),n2h2(501))
  call Hloop_QA_V(ntryL,G2H16(18),ex2(:),G2H8(38),m3h2x8(:,114),heltab2x16(:,:,159))
  call Hloop_VQ_A(ntryL,G1H16(20),wf8(:,22),G1H2(822),m3h8x2(:,10),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(822),59,nME,G2H2(70),n2h2(502))
  call Hotf_4pt_reduction(G2H8(47),RedSet_4(273),mass4set(:,5),  & 
G1H8(84),G1H8(86),G1H8(89),G1H8(90),G1H8(91),8)
  call HG1shiftOLR(G1H8(86),18,8)
  call Hotf_4pt_reduction(G2H8(48),RedSet_4(274),mass4set(:,5),  & 
G1H8(92),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(95),18,8)
  call Hloop_AQ_V(ntryL,G2H16(7),ex1(:),G2H8(1),m3h2x8(:,115),heltab2x16(:,:,161))
  call Hloop_VA_Q(ntryL,G1H16(24),wf8(:,32),G1H2(828),m3h8x2(:,11),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(828),55,nME,G2H2(52),n2h2(503))
  call Hloop_AQ_V(ntryL,G2H16(8),ex1(:),G2H8(3),m3h2x8(:,116),heltab2x16(:,:,163))
  call Hloop_VA_Q(ntryL,G1H16(4),wf8(:,11),G1H2(834),m3h8x2(:,12),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(834),59,nME,G2H2(83),n2h2(504))
  call Hloop_AV_Q(ntryL,G1H4(98),ex3(:),G1H2(121),m3h2x2(:,619),heltab2x4(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(121),62,nME,G2H2(54),n2h2(505))
call HGT_raise_alpha_OLR(G1H4(103),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(103),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(103),ex1(:),G1H2(122),m3h2x2(:,620),heltab2x4(:,:,644))
  call Hloop_AV_Q(ntryL,G1H4(110),ex3(:),G1H2(13),m3h2x2(:,621),heltab2x4(:,:,645))
  call Hloop_A_Q(ntryL,G1H2(13),62,nME,G2H2(85),n2h2(506))
  call Hloop_AV_Q(ntryL,G1H4(115),ex3(:),G1H2(139),m3h2x2(:,622),heltab2x4(:,:,646))
  call Hloop_A_Q(ntryL,G1H2(139),62,nME,G2H2(57),n2h2(507))
  call Hloop_AV_Q(ntryL,G1H4(5),ex4(:),G1H2(140),m3h2x2(:,623),heltab2x4(:,:,647))
  call Hloop_A_Q(ntryL,G1H2(140),62,nME,G2H2(508),n2h2(508))
call HGT_raise_alpha_OLR(G1H4(17),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(17),ex1(:),G1H2(26),m3h2x2(:,624),heltab2x4(:,:,648))
  call Hloop_AV_Q(ntryL,G1H4(65),ex4(:),G1H2(14),m3h2x2(:,625),heltab2x4(:,:,649))
  call Hloop_A_Q(ntryL,G1H2(14),62,nME,G2H2(59),n2h2(509))
  call Hloop_AV_Q(ntryL,G1H4(77),ex4(:),G1H2(31),m3h2x2(:,626),heltab2x4(:,:,650))
  call Hloop_A_Q(ntryL,G1H2(31),62,nME,G2H2(510),n2h2(510))
  call Hloop_QV_A(ntryL,G1H4(89),ex5(:),G1H2(43),m3h2x2(:,627),heltab2x4(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(43),61,nME,G2H2(62),n2h2(511))
call HGT_raise_alpha_OLR(G1H4(113),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(113),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(113),ex2(:),G1H2(44),m3h2x2(:,628),heltab2x4(:,:,652))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(79),m3h2x2(:,629),heltab2x4(:,:,653))
  call Hloop_Q_A(ntryL,G1H2(79),61,nME,G2H2(511),n2h2(512))
  call Hloop_QV_A(ntryL,G1H4(137),ex5(:),G1H2(61),m3h2x2(:,630),heltab2x4(:,:,654))
  call Hloop_Q_A(ntryL,G1H2(61),61,nME,G2H2(64),n2h2(513))
  call Hloop_QV_A(ntryL,G1H4(147),ex3(:),G1H2(62),m3h2x2(:,631),heltab2x4(:,:,655))
  call Hloop_Q_A(ntryL,G1H2(62),61,nME,G2H2(513),n2h2(514))
call HGT_raise_alpha_OLR(G1H4(173),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(173),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(173),ex2(:),G1H2(92),m3h2x2(:,632),heltab2x4(:,:,656))
  call Hloop_QV_A(ntryL,G1H4(185),ex3(:),G1H2(80),m3h2x2(:,633),heltab2x4(:,:,657))
  call Hloop_Q_A(ntryL,G1H2(80),61,nME,G2H2(67),n2h2(515))
  call Hloop_QV_A(ntryL,G1H4(209),ex3(:),G1H2(97),m3h2x2(:,634),heltab2x4(:,:,658))
  call Hloop_Q_A(ntryL,G1H2(97),61,nME,G2H2(69),n2h2(516))
  call Hloop_QV_A(ntryL,G1H4(221),ex4(:),G1H2(109),m3h2x2(:,635),heltab2x4(:,:,659))
  call Hloop_Q_A(ntryL,G1H2(109),61,nME,G2H2(72),n2h2(517))
call HGT_raise_alpha_OLR(G1H4(135),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(135),ex2(:),G1H2(110),m3h2x2(:,636),heltab2x4(:,:,660))
  call Hloop_QV_A(ntryL,G1H4(257),ex4(:),G1H2(3),m3h2x2(:,637),heltab2x4(:,:,661))
  call Hloop_Q_A(ntryL,G1H2(3),61,nME,G2H2(88),n2h2(518))
  call Hloop_QV_A(ntryL,G1H4(269),ex4(:),G1H2(18),m3h2x2(:,638),heltab2x4(:,:,662))
  call Hloop_Q_A(ntryL,G1H2(18),61,nME,G2H2(74),n2h2(519))
  call Hloop_AV_Q(ntryL,G1H4(99),ex5(:),G1H2(24),m3h2x2(:,639),heltab2x4(:,:,663))
  call Hloop_A_Q(ntryL,G1H2(24),62,nME,G2H2(90),n2h2(520))
call HGT_raise_alpha_OLR(G1H4(281),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(281),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(281),ex1(:),G1H2(102),m3h2x2(:,640),heltab2x4(:,:,664))
  call Hloop_AV_Q(ntryL,G1H4(15),ex5(:),G1H2(54),m3h2x2(:,641),heltab2x4(:,:,665))
  call Hloop_A_Q(ntryL,G1H2(54),62,nME,G2H2(77),n2h2(521))
  call Hloop_AV_Q(ntryL,G1H4(27),ex5(:),G1H2(66),m3h2x2(:,642),heltab2x4(:,:,666))
  call Hloop_A_Q(ntryL,G1H2(66),62,nME,G2H2(517),n2h2(522))
  call Hloop_AV_Q(ntryL,G1H8(48),ex5(:),G1H4(28),m3h2x4(:,219),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(28),54,nME,G2H4(77),n2h4(285))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),wf4(:,11),G1H2(108),m3h4x2(:,31),heltab2x8(:,:,250))
  call Hloop_AV_Q(ntryL,G1H8(54),ex5(:),G1H4(46),m3h2x4(:,220),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(46),54,nME,G2H4(10),n2h4(286))
  call Hloop_AV_Q(ntryL,G1H8(55),ex5(:),G1H4(51),m3h2x4(:,221),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(51),54,nME,G2H4(81),n2h4(287))
  call Hloop_QV_A(ntryL,G1H8(56),ex5(:),G1H4(63),m3h2x4(:,222),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(63),53,nME,G2H4(85),n2h4(288))
call HGT_raise_alpha_OLR(G1H8(60),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(60),wf4(:,4),G1H2(90),m3h4x2(:,32),heltab2x8(:,:,254))
  call Hloop_QV_A(ntryL,G1H8(62),ex5(:),G1H4(64),m3h2x4(:,223),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(64),53,nME,G2H4(13),n2h4(289))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(100),m3h2x4(:,224),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G1H4(100),53,nME,G2H4(89),n2h4(290))
  call Hloop_AV_Q(ntryL,G1H8(66),ex3(:),G1H4(111),m3h2x4(:,225),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(111),46,nME,G2H4(87),n2h4(291))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(68),wf4(:,14),G1H2(132),m3h4x2(:,33),heltab2x8(:,:,258))
  call Hloop_AV_Q(ntryL,G1H8(72),ex3(:),G1H4(112),m3h2x4(:,226),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(112),46,nME,G2H4(95),n2h4(292))
  call Hloop_AV_Q(ntryL,G1H8(73),ex3(:),G1H4(123),m3h2x4(:,227),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(123),46,nME,G2H4(104),n2h4(293))
  call Hloop_AV_Q(ntryL,G1H8(74),ex4(:),G1H4(148),m3h2x4(:,228),heltab2x8(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(148),46,nME,G2H4(92),n2h4(294))
call HGT_raise_alpha_OLR(G1H8(78),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(78),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(78),wf4(:,14),G1H2(114),m3h4x2(:,34),heltab2x8(:,:,262))
  call Hloop_AV_Q(ntryL,G1H8(80),ex4(:),G1H4(159),m3h2x4(:,229),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(159),46,nME,G2H4(98),n2h4(295))
  call Hloop_AV_Q(ntryL,G1H8(83),ex4(:),G1H4(160),m3h2x4(:,230),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(160),46,nME,G2H4(101),n2h4(296))
  call Hloop_QV_A(ntryL,G1H8(84),ex4(:),G1H4(171),m3h2x4(:,231),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(171),45,nME,G2H4(20),n2h4(297))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),wf4(:,6),G1H2(69),m3h4x2(:,35),heltab2x8(:,:,266))
  call Hloop_QV_A(ntryL,G1H8(90),ex4(:),G1H4(195),m3h2x4(:,232),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(195),45,nME,G2H4(21),n2h4(298))
  call Hloop_QV_A(ntryL,G1H8(91),ex4(:),G1H4(196),m3h2x4(:,233),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(196),45,nME,G2H4(24),n2h4(299))
  call Hloop_QV_A(ntryL,G1H8(92),ex3(:),G1H4(207),m3h2x4(:,234),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(207),45,nME,G2H4(25),n2h4(300))
call HGT_raise_alpha_OLR(G1H8(95),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(95),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(95),wf4(:,6),G1H2(9),m3h4x2(:,36),heltab2x8(:,:,270))
  call Hloop_QV_A(ntryL,G1H8(97),ex3(:),G1H4(208),m3h2x4(:,235),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(208),45,nME,G2H4(28),n2h4(301))
  call Hloop_QV_A(ntryL,G1H8(98),ex3(:),G1H4(231),m3h2x4(:,236),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(231),45,nME,G2H4(29),n2h4(302))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G2H2(1),G1H2(181),G1H2(1)])
call HGT_OLR(G2H2(230),1,1,2)
call HGT_invQ_OLR(G2H2(230),2,5,2)
call HGT_OLR(G2H2(230),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(230),[G2H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(355),[G2H2(6),G1H2(467),G1H2(68),G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(509),[G2H2(255),G2H2(187),G2H2(130),G2H2(11),G1H2(629) &
    ,G1H2(473),G1H2(253),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(359),[G2H2(16),G1H2(479),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(515),[G2H2(223),G2H2(191),G2H2(106),G2H2(21),G1H2(569) &
    ,G1H2(485),G1H2(165),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(363),[G2H2(26),G1H2(491),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(367),[G2H2(31),G1H2(497),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(518),[G2H2(287),G2H2(195),G2H2(142),G2H2(36),G1H2(689) &
    ,G1H2(503),G1H2(330),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(283),[G2H2(41),G1H2(324),G1H2(138)])
call HGT_OLR(G2H2(286),1,1,2)
call HGT_invQ_OLR(G2H2(286),2,5,2)
call HGT_OLR(G2H2(286),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G2H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(371),[G2H2(46),G1H2(509),G1H2(41),G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(506),[G2H2(215),G2H2(199),G2H2(91),G2H2(51),G1H2(557) &
    ,G1H2(515),G1H2(142),G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(375),[G2H2(56),G1H2(521),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(512),[G2H2(263),G2H2(203),G2H2(133),G2H2(61),G1H2(641) &
    ,G1H2(527),G1H2(275),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(379),[G2H2(66),G1H2(533),G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(383),[G2H2(71),G1H2(539),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(521),[G2H2(231),G2H2(207),G2H2(121),G2H2(76),G1H2(581) &
    ,G1H2(545),G1H2(187),G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(243),G2H2(81),G1H2(225),G1H2(137)])
call HGT_OLR(G2H2(246),1,1,2)
call HGT_invQ_OLR(G2H2(246),2,5,2)
call HGT_OLR(G2H2(246),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(387),G2H2(86),G1H2(551),G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(331),G2H2(96),G1H2(423),G1H2(163)])
call HGT_OLR(G2H2(334),1,1,2)
call HGT_invQ_OLR(G2H2(334),2,5,2)
call HGT_OLR(G2H2(334),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(334),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(391),G2H2(101),G1H2(563),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(347),G2H2(111),G1H2(456),G1H2(185)])
call HGT_OLR(G2H2(350),1,1,2)
call HGT_invQ_OLR(G2H2(350),2,5,2)
call HGT_OLR(G2H2(350),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(350),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(395),G2H2(116),G1H2(575),G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(423),[G2H2(399),G2H2(134),G2H2(122),G1H2(647),G1H2(587) &
    ,G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G2H2(403),G2H2(135),G2H2(123),G1H2(653),G1H2(593) &
    ,G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(39),G2H2(271),G2H2(239),G2H2(136),G2H2(124) &
    ,G1H2(659),G1H2(599),G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(443),[G2H2(407),G2H2(143),G2H2(125),G1H2(695),G1H2(605) &
    ,G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(447),[G2H2(411),G2H2(144),G2H2(126),G1H2(701),G1H2(611) &
    ,G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(516),G2H2(295),G2H2(247),G2H2(145),G2H2(127) &
    ,G1H2(707),G1H2(617),G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(315),G2H2(128),G1H2(390),G1H2(251)])
call HGT_OLR(G2H2(318),1,1,2)
call HGT_invQ_OLR(G2H2(318),2,5,2)
call HGT_OLR(G2H2(318),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(318),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(415),G2H2(129),G1H2(623),G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(275),G2H2(131),G1H2(302),G1H2(273)])
call HGT_OLR(G2H2(278),1,1,2)
call HGT_invQ_OLR(G2H2(278),2,5,2)
call HGT_OLR(G2H2(278),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(278),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(419),G2H2(132),G1H2(635),G1H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(451),[G2H2(431),G2H2(146),G2H2(137),G1H2(713),G1H2(665) &
    ,G1H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(455),[G2H2(435),G2H2(147),G2H2(138),G1H2(719),G1H2(671) &
    ,G1H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(522),G2H2(303),G2H2(279),G2H2(148),G2H2(139) &
    ,G1H2(725),G1H2(677),G1H2(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(299),G2H2(140),G1H2(357),G1H2(328)])
call HGT_OLR(G2H2(302),1,1,2)
call HGT_invQ_OLR(G2H2(302),2,5,2)
call HGT_OLR(G2H2(302),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(302),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(439),G2H2(141),G1H2(683),G1H2(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(475),[G2H2(459),G2H2(155),G2H2(149),G1H2(767),G1H2(731) &
    ,G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(479),[G2H2(463),G2H2(156),G2H2(150),G1H2(773),G1H2(737) &
    ,G1H2(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(42),G2H2(327),G2H2(311),G2H2(157),G2H2(151) &
    ,G1H2(779),G1H2(743),G1H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(491),[G2H2(467),G2H2(161),G2H2(152),G1H2(803),G1H2(749) &
    ,G1H2(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(495),[G2H2(471),G2H2(162),G2H2(153),G1H2(809),G1H2(755) &
    ,G1H2(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(520),G2H2(343),G2H2(319),G2H2(163),G2H2(154) &
    ,G1H2(815),G1H2(761),G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(499),[G2H2(483),G2H2(164),G2H2(158),G1H2(821),G1H2(785) &
    ,G1H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(503),[G2H2(487),G2H2(165),G2H2(159),G1H2(827),G1H2(791) &
    ,G1H2(428)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(68),G2H2(351),G2H2(335),G2H2(166),G2H2(160) &
    ,G1H2(833),G1H2(797),G1H2(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G1H2(133)])
call HGT_OLR(G2H2(186),1,1,2)
call HGT_invQ_OLR(G2H2(186),2,5,2)
call HGT_OLR(G2H2(186),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G2H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(55)])
call HGT_OLR(G2H2(190),1,1,2)
call HGT_invQ_OLR(G2H2(190),2,5,2)
call HGT_OLR(G2H2(190),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G2H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G1H2(6)])
call HGT_OLR(G2H2(194),1,1,2)
call HGT_invQ_OLR(G2H2(194),2,5,2)
call HGT_OLR(G2H2(194),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G2H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G1H2(93)])
call HGT_OLR(G2H2(198),1,1,2)
call HGT_invQ_OLR(G2H2(198),2,5,2)
call HGT_OLR(G2H2(198),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G2H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G1H2(29)])
call HGT_OLR(G2H2(202),1,1,2)
call HGT_invQ_OLR(G2H2(202),2,5,2)
call HGT_OLR(G2H2(202),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(202),[G2H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(83)])
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(206),[G2H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(5),G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(14),G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(33),G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(49),G1H4(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G2H4(82),G1H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G2H4(65),G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(374),[G2H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(23)])
call HGT_OLR(G2H2(374),1,1,2)
call HGT_invQ_OLR(G2H2(374),2,5,2)
call HGT_OLR(G2H2(374),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(374),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(211),[G1H2(130)])
call HGT_OLR(G2H2(214),1,1,2)
call HGT_invQ_OLR(G2H2(214),2,5,2)
call HGT_OLR(G2H2(214),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G2H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(127)])
call HGT_OLR(G2H2(226),1,1,2)
call HGT_invQ_OLR(G2H2(226),2,5,2)
call HGT_OLR(G2H2(226),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G1H2(159)])
call HGT_OLR(G2H2(222),1,1,2)
call HGT_invQ_OLR(G2H2(222),2,5,2)
call HGT_OLR(G2H2(222),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G2H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(212),[G1H2(125)])
call HGT_OLR(G2H2(242),1,1,2)
call HGT_invQ_OLR(G2H2(242),2,5,2)
call HGT_OLR(G2H2(242),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G2H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(235),[G1H2(203)])
call HGT_OLR(G2H2(238),1,1,2)
call HGT_invQ_OLR(G2H2(238),2,5,2)
call HGT_OLR(G2H2(238),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G2H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(358),[G2H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(505),[G1H2(49)])
call HGT_OLR(G2H2(358),1,1,2)
call HGT_invQ_OLR(G2H2(358),2,5,2)
call HGT_OLR(G2H2(358),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(358),[G2H2(505)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(251),[G1H2(247)])
call HGT_OLR(G2H2(254),1,1,2)
call HGT_invQ_OLR(G2H2(254),2,5,2)
call HGT_OLR(G2H2(254),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G2H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G2H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(507),[G1H2(21)])
call HGT_OLR(G2H2(282),1,1,2)
call HGT_invQ_OLR(G2H2(282),2,5,2)
call HGT_OLR(G2H2(282),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G2H2(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(259),[G1H2(269)])
call HGT_OLR(G2H2(262),1,1,2)
call HGT_invQ_OLR(G2H2(262),2,5,2)
call HGT_OLR(G2H2(262),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(262),[G2H2(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G2H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(257),[G1H2(495),G1H2(489),G1H2(267)])
call HGT_OLR(G2H2(274),1,1,2)
call HGT_invQ_OLR(G2H2(274),2,5,2)
call HGT_OLR(G2H2(274),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G2H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(267),[G1H2(291)])
call HGT_OLR(G2H2(270),1,1,2)
call HGT_invQ_OLR(G2H2(270),2,5,2)
call HGT_OLR(G2H2(270),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(270),[G2H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(298),[G2H2(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(519),G1H2(507),G1H2(322)])
call HGT_OLR(G2H2(298),1,1,2)
call HGT_invQ_OLR(G2H2(298),2,5,2)
call HGT_OLR(G2H2(298),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(298),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G1H2(346)])
call HGT_OLR(G2H2(294),1,1,2)
call HGT_invQ_OLR(G2H2(294),2,5,2)
call HGT_OLR(G2H2(294),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G2H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(314),[G2H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(249),[G1H2(245)])
call HGT_OLR(G2H2(314),1,1,2)
call HGT_invQ_OLR(G2H2(314),2,5,2)
call HGT_OLR(G2H2(314),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(314),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G1H2(368)])
call HGT_OLR(G2H2(310),1,1,2)
call HGT_invQ_OLR(G2H2(310),2,5,2)
call HGT_OLR(G2H2(310),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(310),[G2H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(330),[G2H2(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(220),[G1H2(537),G1H2(531),G1H2(157)])
call HGT_OLR(G2H2(330),1,1,2)
call HGT_invQ_OLR(G2H2(330),2,5,2)
call HGT_OLR(G2H2(330),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(330),[G2H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(323),[G1H2(412)])
call HGT_OLR(G2H2(326),1,1,2)
call HGT_invQ_OLR(G2H2(326),2,5,2)
call HGT_OLR(G2H2(326),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(326),[G2H2(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(346),[G2H2(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G1H2(477),G1H2(465),G1H2(179)])
call HGT_OLR(G2H2(346),1,1,2)
call HGT_invQ_OLR(G2H2(346),2,5,2)
call HGT_OLR(G2H2(346),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(346),[G2H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(339),[G1H2(445)])
call HGT_OLR(G2H2(342),1,1,2)
call HGT_invQ_OLR(G2H2(342),2,5,2)
call HGT_OLR(G2H2(342),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(342),[G2H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(50),G1H2(128)])
call HGT_OLR(G2H2(354),1,1,2)
call HGT_invQ_OLR(G2H2(354),2,5,2)
call HGT_OLR(G2H2(354),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(354),[G2H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(115)])
call HGT_OLR(G2H2(362),1,1,2)
call HGT_invQ_OLR(G2H2(362),2,5,2)
call HGT_OLR(G2H2(362),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(362),[G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G1H2(116)])
call HGT_OLR(G2H2(366),1,1,2)
call HGT_invQ_OLR(G2H2(366),2,5,2)
call HGT_OLR(G2H2(366),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(366),[G2H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G1H2(27),G1H2(96)])
call HGT_OLR(G2H2(370),1,1,2)
call HGT_invQ_OLR(G2H2(370),2,5,2)
call HGT_OLR(G2H2(370),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(370),[G2H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(514),[G1H2(81)])
call HGT_OLR(G2H2(378),1,1,2)
call HGT_invQ_OLR(G2H2(378),2,5,2)
call HGT_OLR(G2H2(378),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(378),[G2H2(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G1H2(82)])
call HGT_OLR(G2H2(382),1,1,2)
call HGT_invQ_OLR(G2H2(382),2,5,2)
call HGT_OLR(G2H2(382),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(382),[G2H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(129)])
call HGT_OLR(G2H2(386),1,1,2)
call HGT_invQ_OLR(G2H2(386),2,5,2)
call HGT_OLR(G2H2(386),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(386),[G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(158)])
call HGT_OLR(G2H2(390),1,1,2)
call HGT_invQ_OLR(G2H2(390),2,5,2)
call HGT_OLR(G2H2(390),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(390),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G1H2(471),G1H2(180)])
call HGT_OLR(G2H2(394),1,1,2)
call HGT_invQ_OLR(G2H2(394),2,5,2)
call HGT_OLR(G2H2(394),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(394),[G2H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(201)])
call HGT_OLR(G2H2(398),1,1,2)
call HGT_invQ_OLR(G2H2(398),2,5,2)
call HGT_OLR(G2H2(398),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(398),[G2H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G1H2(202)])
call HGT_OLR(G2H2(402),1,1,2)
call HGT_invQ_OLR(G2H2(402),2,5,2)
call HGT_OLR(G2H2(402),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(402),[G2H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(549),G1H2(223)])
call HGT_OLR(G2H2(406),1,1,2)
call HGT_invQ_OLR(G2H2(406),2,5,2)
call HGT_OLR(G2H2(406),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(406),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(217),[G1H2(555),G1H2(224)])
call HGT_OLR(G2H2(410),1,1,2)
call HGT_invQ_OLR(G2H2(410),2,5,2)
call HGT_OLR(G2H2(410),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(410),[G2H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G1H2(246)])
call HGT_OLR(G2H2(414),1,1,2)
call HGT_invQ_OLR(G2H2(414),2,5,2)
call HGT_OLR(G2H2(414),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(414),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(268)])
call HGT_OLR(G2H2(418),1,1,2)
call HGT_invQ_OLR(G2H2(418),2,5,2)
call HGT_OLR(G2H2(418),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(418),[G2H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(289)])
call HGT_OLR(G2H2(422),1,1,2)
call HGT_invQ_OLR(G2H2(422),2,5,2)
call HGT_OLR(G2H2(422),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(422),[G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(265),[G1H2(290)])
call HGT_OLR(G2H2(426),1,1,2)
call HGT_invQ_OLR(G2H2(426),2,5,2)
call HGT_OLR(G2H2(426),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(426),[G2H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G1H2(633),G1H2(300)])
call HGT_OLR(G2H2(430),1,1,2)
call HGT_invQ_OLR(G2H2(430),2,5,2)
call HGT_OLR(G2H2(430),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(260),[G1H2(639),G1H2(301)])
call HGT_OLR(G2H2(434),1,1,2)
call HGT_invQ_OLR(G2H2(434),2,5,2)
call HGT_OLR(G2H2(434),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(434),[G2H2(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G1H2(513),G1H2(323)])
call HGT_OLR(G2H2(438),1,1,2)
call HGT_invQ_OLR(G2H2(438),2,5,2)
call HGT_OLR(G2H2(438),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(344)])
call HGT_OLR(G2H2(442),1,1,2)
call HGT_invQ_OLR(G2H2(442),2,5,2)
call HGT_OLR(G2H2(442),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(442),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G1H2(345)])
call HGT_OLR(G2H2(446),1,1,2)
call HGT_invQ_OLR(G2H2(446),2,5,2)
call HGT_OLR(G2H2(446),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(446),[G2H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(292),[G1H2(681),G1H2(355)])
call HGT_OLR(G2H2(450),1,1,2)
call HGT_invQ_OLR(G2H2(450),2,5,2)
call HGT_OLR(G2H2(450),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(450),[G2H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(281),[G1H2(687),G1H2(356)])
call HGT_OLR(G2H2(454),1,1,2)
call HGT_invQ_OLR(G2H2(454),2,5,2)
call HGT_OLR(G2H2(454),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(454),[G2H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(305),[G1H2(366)])
call HGT_OLR(G2H2(458),1,1,2)
call HGT_invQ_OLR(G2H2(458),2,5,2)
call HGT_OLR(G2H2(458),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(458),[G2H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(367)])
call HGT_OLR(G2H2(462),1,1,2)
call HGT_invQ_OLR(G2H2(462),2,5,2)
call HGT_OLR(G2H2(462),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(462),[G2H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G1H2(621),G1H2(388)])
call HGT_OLR(G2H2(466),1,1,2)
call HGT_invQ_OLR(G2H2(466),2,5,2)
call HGT_OLR(G2H2(466),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(466),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(252),[G1H2(627),G1H2(389)])
call HGT_OLR(G2H2(470),1,1,2)
call HGT_invQ_OLR(G2H2(470),2,5,2)
call HGT_OLR(G2H2(470),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(470),[G2H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G1H2(410)])
call HGT_OLR(G2H2(474),1,1,2)
call HGT_invQ_OLR(G2H2(474),2,5,2)
call HGT_OLR(G2H2(474),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(474),[G2H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(316),[G1H2(411)])
call HGT_OLR(G2H2(478),1,1,2)
call HGT_invQ_OLR(G2H2(478),2,5,2)
call HGT_OLR(G2H2(478),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(478),[G2H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(321),[G1H2(561),G1H2(421)])
call HGT_OLR(G2H2(482),1,1,2)
call HGT_invQ_OLR(G2H2(482),2,5,2)
call HGT_OLR(G2H2(482),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(482),[G2H2(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G1H2(567),G1H2(422)])
call HGT_OLR(G2H2(486),1,1,2)
call HGT_invQ_OLR(G2H2(486),2,5,2)
call HGT_OLR(G2H2(486),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(486),[G2H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(443)])
call HGT_OLR(G2H2(490),1,1,2)
call HGT_invQ_OLR(G2H2(490),2,5,2)
call HGT_OLR(G2H2(490),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(490),[G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(332),[G1H2(444)])
call HGT_OLR(G2H2(494),1,1,2)
call HGT_invQ_OLR(G2H2(494),2,5,2)
call HGT_OLR(G2H2(494),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(494),[G2H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(340),[G1H2(573),G1H2(454)])
call HGT_OLR(G2H2(498),1,1,2)
call HGT_invQ_OLR(G2H2(498),2,5,2)
call HGT_OLR(G2H2(498),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(498),[G2H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(579),G1H2(455)])
call HGT_OLR(G2H2(502),1,1,2)
call HGT_invQ_OLR(G2H2(502),2,5,2)
call HGT_OLR(G2H2(502),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(502),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(125),[G1H4(192)])
call HGT_OLR(G2H4(67),1,1,4)
call HGT_invQ_OLR(G2H4(67),2,5,4)
call HGT_OLR(G2H4(67),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G1H4(272)])
call HGT_OLR(G2H4(70),1,1,4)
call HGT_invQ_OLR(G2H4(70),2,5,4)
call HGT_OLR(G2H4(70),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(193),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(959),[G1H2(103),G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(894),[G1H2(839),G1H2(264),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(964),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(874),[G1H2(844),G1H2(176),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(969),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(974),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(914),[G1H2(849),G1H2(341),G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(336),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(979),[G1H2(70),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(869),[G1H2(854),G1H2(154),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(984),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(899),[G1H2(859),G1H2(286),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(989),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(994),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(879),[G1H2(864),G1H2(198),G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(237),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(999),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(992),[G1H2(987),G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(435),[G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1004),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(962),[G1H2(957),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(837),[G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(462),[G1H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1009),[G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1044),[G1H2(1014),G1H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1049),[G1H2(1019),G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(904),[G1H2(884),G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(997),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(867),[G1H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1069),[G1H2(1024),G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1074),[G1H2(1029),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(919),[G1H2(889),G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(402),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1034),[G1H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(972),[G1H2(967),G1H2(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(314),[G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1039),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1037),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(897),[G1H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1079),[G1H2(1054),G1H2(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1084),[G1H2(1059),G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(924),[G1H2(909),G1H2(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(982),[G1H2(977),G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(852),[G1H2(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(363),[G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1064),[G1H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1062),[G1H2(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(912),[G1H2(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1109),[G1H2(1089),G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1114),[G1H2(1094),G1H2(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(939),[G1H2(929),G1H2(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1032),[G1H2(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(892),[G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1129),[G1H2(1099),G1H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1134),[G1H2(1104),G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(949),[G1H2(934),G1H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1002),[G1H2(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(872),[G1H2(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1139),[G1H2(1119),G1H2(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1144),[G1H2(1124),G1H2(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(954),[G1H2(944),G1H2(440)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1007),[G1H2(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(877),[G1H2(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G1H2(484),G1H2(472),G1H2(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G1H2(483),G1H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G1H2(501),G1H2(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G1H2(502),G1H2(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(182),[G1H2(526),G1H2(514),G1H2(508)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G1H2(525),G1H2(520)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(209),[G1H2(543),G1H2(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(544),G1H2(538)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(658),G1H2(652),G1H2(556),G1H2(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(742),G1H2(736),G1H2(568),G1H2(562)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G1H2(760),G1H2(754),G1H2(580),G1H2(574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(591),G1H2(585)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(597),G1H2(586)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G1H2(640),G1H2(634),G1H2(598),G1H2(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(609),G1H2(603)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G1H2(615),G1H2(604)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(688),G1H2(682),G1H2(616),G1H2(610)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(778),G1H2(772),G1H2(628),G1H2(622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(651),G1H2(645)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(268),[G1H2(657),G1H2(646)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(669),G1H2(663)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G1H2(675),G1H2(664)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(276),[G1H2(676),G1H2(670)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(699),G1H2(693)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(705),G1H2(694)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G1H2(706),G1H2(700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(717),G1H2(711)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G1H2(723),G1H2(712)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(300),[G1H2(724),G1H2(718)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(735),G1H2(729)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(308),[G1H2(741),G1H2(730)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(753),G1H2(747)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(313),[G1H2(759),G1H2(748)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(771),G1H2(765)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(777),G1H2(766)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(789),G1H2(783)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(324),[G1H2(795),G1H2(784)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(329),[G1H2(796),G1H2(790)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(807),G1H2(801)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G1H2(813),G1H2(802)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(337),[G1H2(814),G1H2(808)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(825),G1H2(819)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(345),[G1H2(831),G1H2(820)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(348),[G1H2(832),G1H2(826)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G1H4(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(117),[G1H4(235),G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G1H4(138),G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(958),[G1H2(843),G1H2(838)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(963),[G1H2(842)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(968),[G1H2(847)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(973),[G1H2(848)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(978),[G1H2(858),G1H2(853)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(983),[G1H2(857)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(988),[G1H2(862)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(993),[G1H2(863)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1048),[G1H2(998),G1H2(903),G1H2(868)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1093),[G1H2(1003),G1H2(928),G1H2(873)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1103),[G1H2(1008),G1H2(933),G1H2(878)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1013),[G1H2(882)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1038),[G1H2(1018),G1H2(898),G1H2(883)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1023),[G1H2(887)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1063),[G1H2(1028),G1H2(913),G1H2(888)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1113),[G1H2(1033),G1H2(938),G1H2(893)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1043),[G1H2(902)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1053),[G1H2(907)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1058),[G1H2(908)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1068),[G1H2(917)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1073),[G1H2(918)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1078),[G1H2(922)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1083),[G1H2(923)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1088),[G1H2(927)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1098),[G1H2(932)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1108),[G1H2(937)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1118),[G1H2(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1123),[G1H2(943)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1128),[G1H2(947)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1133),[G1H2(948)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1138),[G1H2(952)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1143),[G1H2(953)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1017),[G1H2(1012)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1027),[G1H2(1022)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1047),[G1H2(1042)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1057),[G1H2(1052)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1072),[G1H2(1067)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1082),[G1H2(1077)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1092),[G1H2(1087)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1102),[G1H2(1097)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1112),[G1H2(1107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1122),[G1H2(1117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1132),[G1H2(1127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1142),[G1H2(1137)])
  call Hotf_4pt_reduction(G2H2(230),RedSet_4(3),mass4set(:,1),  & 
G1H2(51),G1H2(11),G1H2(28),G1H2(22),G1H2(52),2)
  call HG1shiftOLR(G1H2(11),16,2)
  call Hotf_4pt_reduction(G2H2(355),RedSet_4(7),mass4set(:,1),  & 
G1H2(34),G1H2(35),G1H2(63),G1H2(53),G1H2(64),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(509),RedSet_4(10),mass4set(:,1),  & 
G1H2(76),G1H2(77),G1H2(101),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(77),16,2)
  call Hotf_4pt_reduction(G2H2(359),RedSet_4(17),mass4set(:,1),  & 
G1H2(112),G1H2(105),G1H2(113),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(105),16,2)
  call Hotf_4pt_reduction(G2H2(515),RedSet_4(20),mass4set(:,1),  & 
G1H2(145),G1H2(135),G1H2(136),G1H2(150),G1H2(146),2)
  call HG1shiftOLR(G1H2(135),16,2)
  call Hotf_4pt_reduction(G2H2(363),RedSet_4(28),mass4set(:,1),  & 
G1H2(151),G1H2(155),G1H2(156),G1H2(167),G1H2(161),2)
  call HG1shiftOLR(G1H2(155),8,2)
  call Hotf_4pt_reduction(G2H2(367),RedSet_4(32),mass4set(:,1),  & 
G1H2(162),G1H2(172),G1H2(168),G1H2(173),G1H2(177),2)
  call HG1shiftOLR(G1H2(172),8,2)
  call Hotf_4pt_reduction(G2H2(518),RedSet_4(35),mass4set(:,1),  & 
G1H2(178),G1H2(189),G1H2(183),G1H2(184),G1H2(194),2)
  call HG1shiftOLR(G1H2(189),8,2)
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(3),mass4set(:,1),  & 
G1H2(190),G1H2(195),G1H2(199),G1H2(200),G1H2(211),2)
  call HG1shiftOLR(G1H2(195),16,2)
  call Hotf_4pt_reduction(G2H2(371),RedSet_4(7),mass4set(:,1),  & 
G1H2(205),G1H2(206),G1H2(216),G1H2(212),G1H2(217),2)
  call HG1shiftOLR(G1H2(206),16,2)
  call Hotf_4pt_reduction(G2H2(506),RedSet_4(10),mass4set(:,1),  & 
G1H2(221),G1H2(222),G1H2(233),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(222),16,2)
  call Hotf_4pt_reduction(G2H2(375),RedSet_4(17),mass4set(:,1),  & 
G1H2(238),G1H2(234),G1H2(239),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(234),16,2)
  call Hotf_4pt_reduction(G2H2(512),RedSet_4(20),mass4set(:,1),  & 
G1H2(255),G1H2(249),G1H2(250),G1H2(260),G1H2(256),2)
  call HG1shiftOLR(G1H2(249),16,2)
  call Hotf_4pt_reduction(G2H2(379),RedSet_4(28),mass4set(:,1),  & 
G1H2(261),G1H2(265),G1H2(266),G1H2(277),G1H2(271),2)
  call HG1shiftOLR(G1H2(265),8,2)
  call Hotf_4pt_reduction(G2H2(383),RedSet_4(32),mass4set(:,1),  & 
G1H2(272),G1H2(282),G1H2(278),G1H2(283),G1H2(287),2)
  call HG1shiftOLR(G1H2(282),8,2)
  call Hotf_4pt_reduction(G2H2(521),RedSet_4(35),mass4set(:,1),  & 
G1H2(288),G1H2(293),G1H2(294),G1H2(298),G1H2(299),2)
  call HG1shiftOLR(G1H2(293),8,2)
  call Hotf_4pt_reduction(G2H2(246),RedSet_4(69),mass4set(:,3),  & 
G1H2(310),G1H2(304),G1H2(305),G1H2(315),G1H2(311),2)
  call HG1shiftOLR(G1H2(304),16,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(73),mass4set(:,3),  & 
G1H2(316),G1H2(320),G1H2(321),G1H2(332),G1H2(326),2)
  call HG1shiftOLR(G1H2(320),16,2)
  call Hotf_4pt_reduction(G2H2(334),RedSet_4(82),mass4set(:,3),  & 
G1H2(327),G1H2(337),G1H2(333),G1H2(338),G1H2(342),2)
  call HG1shiftOLR(G1H2(337),16,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(86),mass4set(:,3),  & 
G1H2(343),G1H2(348),G1H2(349),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(348),16,2)
  call Hotf_4pt_reduction(G2H2(350),RedSet_4(95),mass4set(:,3),  & 
G1H2(359),G1H2(360),G1H2(364),G1H2(365),G1H2(376),2)
  call HG1shiftOLR(G1H2(360),8,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(98),mass4set(:,3),  & 
G1H2(370),G1H2(371),G1H2(381),G1H2(377),G1H2(382),2)
  call HG1shiftOLR(G1H2(371),8,2)
  call Hotf_4pt_reduction(G2H2(423),RedSet_4(104),mass4set(:,4),  & 
G1H2(386),G1H2(387),G1H2(398),G1H2(392),G1H2(393),2)
  call HG1shiftOLR(G1H2(387),16,2)
  call Hotf_4pt_reduction(G2H2(427),RedSet_4(107),mass4set(:,1),  & 
G1H2(403),G1H2(399),G1H2(404),G1H2(408),G1H2(409),2)
  call HG1shiftOLR(G1H2(399),16,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(110),mass4set(:,3),  & 
G1H2(414),G1H2(415),G1H2(419),G1H2(420),G1H2(431),2)
  call HG1shiftOLR(G1H2(415),16,2)
  call Hotf_4pt_reduction(G2H2(443),RedSet_4(117),mass4set(:,4),  & 
G1H2(425),G1H2(426),G1H2(436),G1H2(432),G1H2(437),2)
  call HG1shiftOLR(G1H2(426),8,2)
  call Hotf_4pt_reduction(G2H2(447),RedSet_4(119),mass4set(:,1),  & 
G1H2(441),G1H2(442),G1H2(447),G1H2(448),G1H2(452),2)
  call HG1shiftOLR(G1H2(442),8,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(121),mass4set(:,3),  & 
G1H2(453),G1H2(458),G1H2(459),G1H2(463),G1H2(464),2)
  call HG1shiftOLR(G1H2(458),8,2)
  call Hotf_4pt_reduction(G2H2(318),RedSet_4(125),mass4set(:,3),  & 
G1H2(955),G1H2(469),G1H2(470),G1H2(835),G1H2(475),2)
  call HG1shiftOLR(G1H2(469),16,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(128),mass4set(:,3),  & 
G1H2(476),G1H2(960),G1H2(481),G1H2(482),G1H2(840),2)
  call HG1shiftOLR(G1H2(960),16,2)
  call Hotf_4pt_reduction(G2H2(278),RedSet_4(134),mass4set(:,3),  & 
G1H2(487),G1H2(488),G1H2(965),G1H2(493),G1H2(494),2)
  call HG1shiftOLR(G1H2(488),16,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(137),mass4set(:,3),  & 
G1H2(970),G1H2(499),G1H2(500),G1H2(845),G1H2(505),2)
  call HG1shiftOLR(G1H2(499),16,2)
  call Hotf_4pt_reduction(G2H2(451),RedSet_4(152),mass4set(:,4),  & 
G1H2(506),G1H2(975),G1H2(511),G1H2(512),G1H2(850),2)
  call HG1shiftOLR(G1H2(975),4,2)
  call Hotf_4pt_reduction(G2H2(455),RedSet_4(155),mass4set(:,1),  & 
G1H2(517),G1H2(518),G1H2(980),G1H2(523),G1H2(524),2)
  call HG1shiftOLR(G1H2(518),4,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(157),mass4set(:,3),  & 
G1H2(855),G1H2(529),G1H2(530),G1H2(985),G1H2(535),2)
  call HG1shiftOLR(G1H2(529),4,2)
  call Hotf_4pt_reduction(G2H2(302),RedSet_4(161),mass4set(:,3),  & 
G1H2(536),G1H2(990),G1H2(541),G1H2(542),G1H2(860),2)
  call HG1shiftOLR(G1H2(990),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(163),mass4set(:,3),  & 
G1H2(547),G1H2(548),G1H2(995),G1H2(553),G1H2(554),2)
  call HG1shiftOLR(G1H2(548),8,2)
  call Hotf_4pt_reduction(G2H2(475),RedSet_4(182),mass4set(:,4),  & 
G1H2(865),G1H2(559),G1H2(560),G1H2(1000),G1H2(565),2)
  call HG1shiftOLR(G1H2(559),16,2)
  call Hotf_4pt_reduction(G2H2(479),RedSet_4(107),mass4set(:,1),  & 
G1H2(566),G1H2(870),G1H2(571),G1H2(572),G1H2(1005),2)
  call HG1shiftOLR(G1H2(870),16,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(185),mass4set(:,3),  & 
G1H2(577),G1H2(578),G1H2(875),G1H2(583),G1H2(584),2)
  call HG1shiftOLR(G1H2(578),16,2)
  call Hotf_4pt_reduction(G2H2(491),RedSet_4(191),mass4set(:,4),  & 
G1H2(1010),G1H2(589),G1H2(590),G1H2(1015),G1H2(595),2)
  call HG1shiftOLR(G1H2(589),8,2)
  call Hotf_4pt_reduction(G2H2(495),RedSet_4(119),mass4set(:,1),  & 
G1H2(596),G1H2(880),G1H2(601),G1H2(602),G1H2(1020),2)
  call HG1shiftOLR(G1H2(880),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(193),mass4set(:,3),  & 
G1H2(607),G1H2(608),G1H2(1025),G1H2(613),G1H2(614),2)
  call HG1shiftOLR(G1H2(608),8,2)
  call Hotf_4pt_reduction(G2H2(499),RedSet_4(202),mass4set(:,4),  & 
G1H2(885),G1H2(619),G1H2(620),G1H2(1030),G1H2(625),2)
  call HG1shiftOLR(G1H2(619),4,2)
  call Hotf_4pt_reduction(G2H2(503),RedSet_4(155),mass4set(:,1),  & 
G1H2(626),G1H2(890),G1H2(631),G1H2(632),G1H2(1035),2)
  call HG1shiftOLR(G1H2(890),4,2)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(204),mass4set(:,3),  & 
G1H2(637),G1H2(638),G1H2(895),G1H2(643),G1H2(644),2)
  call HG1shiftOLR(G1H2(638),4,2)
  call Hotf_4pt_reduction(G2H2(186),RedSet_4(226),mass4set(:,2),  & 
G1H2(1040),G1H2(649),G1H2(650),G1H2(1045),G1H2(655),2)
  call HG1shiftOLR(G1H2(649),2,2)
  call Hotf_4pt_reduction(G2H2(190),RedSet_4(228),mass4set(:,2),  & 
G1H2(656),G1H2(900),G1H2(661),G1H2(662),G1H2(1050),2)
  call HG1shiftOLR(G1H2(900),2,2)
  call Hotf_4pt_reduction(G2H2(194),RedSet_4(231),mass4set(:,2),  & 
G1H2(667),G1H2(668),G1H2(1055),G1H2(673),G1H2(674),2)
  call HG1shiftOLR(G1H2(668),1,2)
  call Hotf_4pt_reduction(G2H2(198),RedSet_4(234),mass4set(:,2),  & 
G1H2(905),G1H2(679),G1H2(680),G1H2(1060),G1H2(685),2)
  call HG1shiftOLR(G1H2(679),1,2)
  call Hotf_4pt_reduction(G2H2(202),RedSet_4(236),mass4set(:,2),  & 
G1H2(686),G1H2(910),G1H2(691),G1H2(692),G1H2(1065),2)
  call HG1shiftOLR(G1H2(910),1,2)
  call Hotf_4pt_reduction(G2H2(206),RedSet_4(239),mass4set(:,2),  & 
G1H2(697),G1H2(698),G1H2(1070),G1H2(703),G1H2(704),2)
  call HG1shiftOLR(G1H2(698),2,2)
  call Hotf_4pt_reduction(G2H4(136),RedSet_4(36),mass4set(:,2),  & 
G1H4(232),G1H4(243),G1H4(244),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(243),9,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(64),mass4set(:,2),  & 
G1H4(279),G1H4(280),G1H4(291),G1H4(292),G1H4(293),4)
  call HG1shiftOLR(G1H4(280),10,4)
  call Hotf_4pt_reduction(G2H4(132),RedSet_4(48),mass4set(:,2),  & 
G1H4(294),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(297),17,4)
  call Hotf_4pt_reduction(G2H4(73),RedSet_4(54),mass4set(:,2),  & 
G1H4(303),G1H4(304),G1H4(305),G1H4(306),G1H4(309),4)
  call HG1shiftOLR(G1H4(304),17,4)
  call Hotf_4pt_reduction(G2H4(131),RedSet_4(11),mass4set(:,2),  & 
G1H4(310),G1H4(311),G1H4(312),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(311),18,4)
  call Hotf_4pt_reduction(G2H4(135),RedSet_4(21),mass4set(:,2),  & 
G1H4(317),G1H4(318),G1H4(321),G1H4(322),G1H4(323),4)
  call HG1shiftOLR(G1H4(318),18,4)
  call Hotf_4pt_reduction(G2H2(374),RedSet_4(235),mass4set(:,2),  & 
G1H2(915),G1H2(709),G1H2(710),G1H2(1075),G1H2(715),2)
  call HG1shiftOLR(G1H2(709),1,2)
  call Hotf_4pt_reduction(G2H2(214),RedSet_4(242),mass4set(:,1),  & 
G1H2(716),G1H2(1080),G1H2(721),G1H2(722),G1H2(920),2)
  call HG1shiftOLR(G1H2(1080),4,2)
  call Hotf_4pt_reduction(G2H2(226),RedSet_4(224),mass4set(:,2),  & 
G1H2(727),G1H2(728),G1H2(1085),G1H2(733),G1H2(734),2)
  call HG1shiftOLR(G1H2(728),2,2)
  call Hotf_4pt_reduction(G2H2(222),RedSet_4(244),mass4set(:,1),  & 
G1H2(1090),G1H2(739),G1H2(740),G1H2(925),G1H2(745),2)
  call HG1shiftOLR(G1H2(739),8,2)
  call Hotf_4pt_reduction(G2H2(242),RedSet_4(240),mass4set(:,3),  & 
G1H2(746),G1H2(1095),G1H2(751),G1H2(752),G1H2(1100),2)
  call HG1shiftOLR(G1H2(1095),4,2)
  call Hotf_4pt_reduction(G2H2(238),RedSet_4(247),mass4set(:,3),  & 
G1H2(757),G1H2(758),G1H2(930),G1H2(763),G1H2(764),2)
  call HG1shiftOLR(G1H2(758),8,2)
  call Hotf_4pt_reduction(G2H2(358),RedSet_4(227),mass4set(:,2),  & 
G1H2(1105),G1H2(769),G1H2(770),G1H2(1110),G1H2(775),2)
  call HG1shiftOLR(G1H2(769),2,2)
  call Hotf_4pt_reduction(G2H2(254),RedSet_4(242),mass4set(:,1),  & 
G1H2(776),G1H2(935),G1H2(781),G1H2(782),G1H2(1115),2)
  call HG1shiftOLR(G1H2(935),4,2)
  call Hotf_4pt_reduction(G2H2(282),RedSet_4(232),mass4set(:,2),  & 
G1H2(787),G1H2(788),G1H2(1120),G1H2(793),G1H2(794),2)
  call HG1shiftOLR(G1H2(788),1,2)
  call Hotf_4pt_reduction(G2H2(262),RedSet_4(244),mass4set(:,1),  & 
G1H2(940),G1H2(799),G1H2(800),G1H2(1125),G1H2(805),2)
  call HG1shiftOLR(G1H2(799),8,2)
  call Hotf_4pt_reduction(G2H2(274),RedSet_4(26),mass4set(:,3),  & 
G1H2(806),G1H2(1130),G1H2(811),G1H2(812),G1H2(945),2)
  call HG1shiftOLR(G1H2(1130),8,2)
  call Hotf_4pt_reduction(G2H2(270),RedSet_4(253),mass4set(:,3),  & 
G1H2(817),G1H2(818),G1H2(1135),G1H2(823),G1H2(824),2)
  call HG1shiftOLR(G1H2(818),4,2)
  call Hotf_4pt_reduction(G2H2(298),RedSet_4(41),mass4set(:,3),  & 
G1H2(1140),G1H2(829),G1H2(830),G1H2(950),G1H2(836),2)
  call HG1shiftOLR(G1H2(829),16,2)
  call Hotf_4pt_reduction(G2H2(294),RedSet_4(256),mass4set(:,3),  & 
G1H2(841),G1H2(846),G1H2(851),G1H2(856),G1H2(861),2)
  call HG1shiftOLR(G1H2(846),4,2)
  call Hotf_4pt_reduction(G2H2(314),RedSet_4(248),mass4set(:,3),  & 
G1H2(866),G1H2(871),G1H2(876),G1H2(881),G1H2(886),2)
  call HG1shiftOLR(G1H2(871),4,2)
  call Hotf_4pt_reduction(G2H2(310),RedSet_4(258),mass4set(:,3),  & 
G1H2(891),G1H2(896),G1H2(901),G1H2(906),G1H2(911),2)
  call HG1shiftOLR(G1H2(896),8,2)
  call Hotf_4pt_reduction(G2H2(330),RedSet_4(57),mass4set(:,3),  & 
G1H2(916),G1H2(921),G1H2(926),G1H2(931),G1H2(936),2)
  call HG1shiftOLR(G1H2(921),8,2)
  call Hotf_4pt_reduction(G2H2(326),RedSet_4(260),mass4set(:,3),  & 
G1H2(941),G1H2(946),G1H2(951),G1H2(956),G1H2(961),2)
  call HG1shiftOLR(G1H2(946),4,2)
  call Hotf_4pt_reduction(G2H2(346),RedSet_4(1),mass4set(:,3),  & 
G1H2(966),G1H2(971),G1H2(976),G1H2(981),G1H2(986),2)
  call HG1shiftOLR(G1H2(971),16,2)
  call Hotf_4pt_reduction(G2H2(342),RedSet_4(262),mass4set(:,3),  & 
G1H2(991),G1H2(996),G1H2(1001),G1H2(1006),G1H2(1011),2)
  call HG1shiftOLR(G1H2(996),4,2)
  call Hotf_4pt_reduction(G2H2(354),RedSet_4(225),mass4set(:,2),  & 
G1H2(1016),G1H2(1021),G1H2(1026),G1H2(1031),G1H2(1036),2)
  call HG1shiftOLR(G1H2(1021),2,2)
  call Hotf_4pt_reduction(G2H2(362),RedSet_4(229),mass4set(:,2),  & 
G1H2(1041),G1H2(1046),G1H2(1051),G1H2(1056),G1H2(1061),2)
  call HG1shiftOLR(G1H2(1046),1,2)
  call Hotf_4pt_reduction(G2H2(366),RedSet_4(230),mass4set(:,2),  & 
G1H2(1066),G1H2(1071),G1H2(1076),G1H2(1081),G1H2(1086),2)
  call HG1shiftOLR(G1H2(1071),1,2)
  call Hotf_4pt_reduction(G2H2(370),RedSet_4(233),mass4set(:,2),  & 
G1H2(1091),G1H2(1096),G1H2(1101),G1H2(1106),G1H2(1111),2)
  call HG1shiftOLR(G1H2(1096),1,2)
  call Hotf_4pt_reduction(G2H2(378),RedSet_4(237),mass4set(:,2),  & 
G1H2(1116),G1H2(1121),G1H2(1126),G1H2(1131),G1H2(1136),2)
  call HG1shiftOLR(G1H2(1121),2,2)
  call Hotf_4pt_reduction(G2H2(382),RedSet_4(238),mass4set(:,2),  & 
G1H2(1141),G1H2(134),G1H2(8),G1H2(56),G1H2(74),2)
  call HG1shiftOLR(G1H2(134),2,2)
  call Hotf_4pt_reduction(G2H2(386),RedSet_4(241),mass4set(:,3),  & 
G1H2(12),G1H2(48),G1H2(126),G1H2(144),G1H2(33),2)
  call HG1shiftOLR(G1H2(48),4,2)
  call Hotf_4pt_reduction(G2H2(390),RedSet_4(243),mass4set(:,3),  & 
G1H2(47),G1H2(87),G1H2(100),G1H2(131),G1H2(143),2)
  call HG1shiftOLR(G1H2(87),8,2)
  call Hotf_4pt_reduction(G2H2(394),RedSet_4(2),mass4set(:,3),  & 
G1H2(160),G1H2(166),G1H2(182),G1H2(188),G1H2(204),2)
  call HG1shiftOLR(G1H2(166),16,2)
  call Hotf_4pt_reduction(G2H2(398),RedSet_4(245),mass4set(:,4),  & 
G1H2(210),G1H2(226),G1H2(232),G1H2(248),G1H2(254),2)
  call HG1shiftOLR(G1H2(226),8,2)
  call Hotf_4pt_reduction(G2H2(402),RedSet_4(246),mass4set(:,1),  & 
G1H2(270),G1H2(276),G1H2(292),G1H2(303),G1H2(309),2)
  call HG1shiftOLR(G1H2(276),8,2)
  call Hotf_4pt_reduction(G2H2(406),RedSet_4(67),mass4set(:,4),  & 
G1H2(325),G1H2(331),G1H2(347),G1H2(358),G1H2(369),2)
  call HG1shiftOLR(G1H2(331),16,2)
  call Hotf_4pt_reduction(G2H2(410),RedSet_4(68),mass4set(:,1),  & 
G1H2(375),G1H2(391),G1H2(397),G1H2(413),G1H2(424),2)
  call HG1shiftOLR(G1H2(391),16,2)
  call Hotf_4pt_reduction(G2H2(414),RedSet_4(249),mass4set(:,3),  & 
G1H2(430),G1H2(446),G1H2(457),G1H2(468),G1H2(474),2)
  call HG1shiftOLR(G1H2(446),4,2)
  call Hotf_4pt_reduction(G2H2(418),RedSet_4(250),mass4set(:,3),  & 
G1H2(480),G1H2(486),G1H2(492),G1H2(498),G1H2(504),2)
  call HG1shiftOLR(G1H2(486),8,2)
  call Hotf_4pt_reduction(G2H2(422),RedSet_4(251),mass4set(:,4),  & 
G1H2(510),G1H2(516),G1H2(522),G1H2(528),G1H2(534),2)
  call HG1shiftOLR(G1H2(516),4,2)
  call Hotf_4pt_reduction(G2H2(426),RedSet_4(252),mass4set(:,1),  & 
G1H2(540),G1H2(546),G1H2(552),G1H2(558),G1H2(564),2)
  call HG1shiftOLR(G1H2(546),4,2)
  call Hotf_4pt_reduction(G2H2(430),RedSet_4(133),mass4set(:,4),  & 
G1H2(570),G1H2(576),G1H2(582),G1H2(588),G1H2(594),2)
  call HG1shiftOLR(G1H2(576),16,2)
  call Hotf_4pt_reduction(G2H2(434),RedSet_4(81),mass4set(:,1),  & 
G1H2(600),G1H2(606),G1H2(612),G1H2(618),G1H2(624),2)
  call HG1shiftOLR(G1H2(606),16,2)
  call Hotf_4pt_reduction(G2H2(438),RedSet_4(42),mass4set(:,3),  & 
G1H2(630),G1H2(636),G1H2(642),G1H2(648),G1H2(654),2)
  call HG1shiftOLR(G1H2(636),16,2)
  call Hotf_4pt_reduction(G2H2(442),RedSet_4(254),mass4set(:,4),  & 
G1H2(660),G1H2(666),G1H2(672),G1H2(678),G1H2(684),2)
  call HG1shiftOLR(G1H2(666),4,2)
  call Hotf_4pt_reduction(G2H2(446),RedSet_4(255),mass4set(:,1),  & 
G1H2(690),G1H2(696),G1H2(702),G1H2(708),G1H2(714),2)
  call HG1shiftOLR(G1H2(696),4,2)
  call Hotf_4pt_reduction(G2H2(450),RedSet_4(160),mass4set(:,4),  & 
G1H2(720),G1H2(726),G1H2(732),G1H2(738),G1H2(744),2)
  call HG1shiftOLR(G1H2(726),8,2)
  call Hotf_4pt_reduction(G2H2(454),RedSet_4(94),mass4set(:,1),  & 
G1H2(750),G1H2(756),G1H2(762),G1H2(768),G1H2(774),2)
  call HG1shiftOLR(G1H2(756),8,2)
  call Hotf_4pt_reduction(G2H2(458),RedSet_4(257),mass4set(:,4),  & 
G1H2(780),G1H2(786),G1H2(792),G1H2(798),G1H2(804),2)
  call HG1shiftOLR(G1H2(786),8,2)
  call Hotf_4pt_reduction(G2H2(462),RedSet_4(246),mass4set(:,1),  & 
G1H2(810),G1H2(816),G1H2(822),G1H2(828),G1H2(834),2)
  call HG1shiftOLR(G1H2(816),8,2)
  call Hotf_4pt_reduction(G2H2(466),RedSet_4(124),mass4set(:,4),  & 
G1H2(121),G1H2(13),G1H2(139),G1H2(140),G1H2(14),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hotf_4pt_reduction(G2H2(470),RedSet_4(68),mass4set(:,1),  & 
G1H2(31),G1H2(43),G1H2(79),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(43),16,2)
  call Hotf_4pt_reduction(G2H2(474),RedSet_4(259),mass4set(:,4),  & 
G1H2(80),G1H2(97),G1H2(109),G1H2(3),G1H2(18),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hotf_4pt_reduction(G2H2(478),RedSet_4(252),mass4set(:,1),  & 
G1H2(24),G1H2(54),G1H2(66),G1H2(181),G1H2(1),2)
  call HG1shiftOLR(G1H2(54),4,2)
  call Hotf_4pt_reduction(G2H2(482),RedSet_4(80),mass4set(:,4),  & 
G1H2(467),G1H2(68),G1H2(2),G1H2(629),G1H2(473),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_4pt_reduction(G2H2(486),RedSet_4(81),mass4set(:,1),  & 
G1H2(253),G1H2(7),G1H2(479),G1H2(67),G1H2(569),2)
  call HG1shiftOLR(G1H2(7),16,2)
  call Hotf_4pt_reduction(G2H2(490),RedSet_4(261),mass4set(:,4),  & 
G1H2(485),G1H2(165),G1H2(73),G1H2(491),G1H2(30),2)
  call HG1shiftOLR(G1H2(165),4,2)
  call Hotf_4pt_reduction(G2H2(494),RedSet_4(255),mass4set(:,1),  & 
G1H2(497),G1H2(36),G1H2(689),G1H2(503),G1H2(330),2)
  call HG1shiftOLR(G1H2(36),4,2)
  call Hotf_4pt_reduction(G2H2(498),RedSet_4(93),mass4set(:,4),  & 
G1H2(42),G1H2(324),G1H2(138),G1H2(509),G1H2(41),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_4pt_reduction(G2H2(502),RedSet_4(94),mass4set(:,1),  & 
G1H2(120),G1H2(557),G1H2(515),G1H2(142),G1H2(45),2)
  call HG1shiftOLR(G1H2(557),8,2)
call HGT_OLR(G2H4(59),1,1,4)
call HGT_invQ_OLR(G2H4(59),2,5,4)
call HGT_OLR(G2H4(59),6,15,4)
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(218),mass4set(:,2),  & 
G1H4(324),G1H4(327),G1H4(328),G1H4(9),G1H4(22),4)
  call HG1shiftOLR(G1H4(327),5,4)
call HGT_OLR(G2H4(62),1,1,4)
call HGT_invQ_OLR(G2H4(62),2,5,4)
call HGT_OLR(G2H4(62),6,15,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(221),mass4set(:,2),  & 
G1H4(330),G1H4(331),G1H4(21),G1H4(23),G1H4(334),4)
  call HG1shiftOLR(G1H4(331),6,4)
call HGT_OLR(G2H4(63),1,1,4)
call HGT_invQ_OLR(G2H4(63),2,5,4)
call HGT_OLR(G2H4(63),6,15,4)
  call Hotf_4pt_reduction(G2H4(63),RedSet_4(222),mass4set(:,2),  & 
G1H4(335),G1H4(336),G1H4(337),G1H4(340),G1H4(341),4)
  call HG1shiftOLR(G1H4(336),9,4)
call HGT_OLR(G2H4(66),1,1,4)
call HGT_invQ_OLR(G2H4(66),2,5,4)
call HGT_OLR(G2H4(66),6,15,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(219),mass4set(:,2),  & 
G1H4(33),G1H4(34),G1H4(343),G1H4(344),G1H4(45),4)
  call HG1shiftOLR(G1H4(34),10,4)
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(43),mass4set(:,2),  & 
G1H4(58),G1H4(346),G1H4(347),G1H4(57),G1H4(59),4)
  call HG1shiftOLR(G1H4(346),17,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(4),mass4set(:,2),  & 
G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(356),4)
  call HG1shiftOLR(G1H4(351),18,4)
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(2),n2h1(489))
  call Hloop_VA_Q(ntryL,G1H2(86),ex2(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(4),n2h1(490))
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(6),n2h1(491))
  call Hloop_AV_Q(ntryL,G1H2(193),ex5(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(8),n2h1(492))
  call Hloop_AV_Q(ntryL,G1H2(959),ex5(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(10),n2h1(493))
  call Hloop_AV_Q(ntryL,G1H2(894),ex5(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(12),n2h1(494))
  call Hloop_VA_Q(ntryL,G1H2(85),ex2(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(14),n2h1(495))
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(16),n2h1(496))
  call Hloop_AV_Q(ntryL,G1H2(964),ex5(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(18),n2h1(497))
  call Hloop_AV_Q(ntryL,G1H2(874),ex5(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(20),n2h1(498))
  call Hloop_VQ_A(ntryL,G1H2(84),ex1(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(22),n2h1(499))
  call Hloop_VQ_A(ntryL,G1H2(60),ex1(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(24),n2h1(500))
  call Hloop_VQ_A(ntryL,G1H2(39),ex1(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(26),n2h1(501))
  call Hloop_QV_A(ntryL,G1H2(969),ex4(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(28),n2h1(502))
  call Hloop_QV_A(ntryL,G1H2(974),ex4(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(30),n2h1(503))
  call Hloop_QV_A(ntryL,G1H2(914),ex4(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(32),n2h1(504))
  call Hloop_VQ_A(ntryL,G1H2(10),ex1(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(34),n2h1(505))
  call Hloop_VQ_A(ntryL,G1H2(58),ex1(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(36),n2h1(506))
  call Hloop_VQ_A(ntryL,G1H2(5),ex1(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(38),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(336),ex5(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(40),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(979),ex5(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(42),n2h1(509))
  call Hloop_QV_A(ntryL,G1H2(869),ex5(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(44),n2h1(510))
  call Hloop_VQ_A(ntryL,G1H2(57),ex1(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(46),n2h1(511))
  call Hloop_VQ_A(ntryL,G1H2(59),ex1(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(48),n2h1(512))
  call Hloop_QV_A(ntryL,G1H2(984),ex5(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(513))
  call Hloop_QV_A(ntryL,G1H2(899),ex5(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(514))
  call Hloop_VA_Q(ntryL,G1H2(106),ex2(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(39),n2h1(515))
  call Hloop_VA_Q(ntryL,G1H2(107),ex2(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(238),n2h1(516))
  call Hloop_VA_Q(ntryL,G1H2(111),ex2(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(244),n2h1(517))
  call Hloop_AV_Q(ntryL,G1H2(989),ex4(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(250),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H2(994),ex4(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(256),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(879),ex4(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(265),n2h1(520))
  call Hloop_QV_A(ntryL,G1H2(147),ex3(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(286),n2h1(521))
  call Hloop_QV_A(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(295),n2h1(522))
  call Hloop_QV_A(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(310),n2h1(523))
  call Hloop_QV_A(ntryL,G1H2(237),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(319),n2h1(524))
  call Hloop_QV_A(ntryL,G1H2(999),ex5(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(525))
  call Hloop_AV_Q(ntryL,G1H2(992),ex4(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(526))
  call Hloop_AV_Q(ntryL,G1H2(170),ex4(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(33),n2h1(527))
  call Hloop_AV_Q(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(49),n2h1(528))
  call Hloop_AV_Q(ntryL,G1H2(435),ex5(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(57),n2h1(529))
  call Hloop_AV_Q(ntryL,G1H2(1004),ex5(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(65),n2h1(530))
  call Hloop_AV_Q(ntryL,G1H2(962),ex5(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(73),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H2(837),ex5(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(81),n2h1(532))
  call Hloop_AV_Q(ntryL,G1H2(462),ex4(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(89),n2h1(533))
  call Hloop_AV_Q(ntryL,G1H2(1009),ex4(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(97),n2h1(534))
  call Hloop_QV_A(ntryL,G1H2(213),ex4(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(105),n2h1(535))
  call Hloop_QV_A(ntryL,G1H2(214),ex4(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(113),n2h1(536))
  call Hloop_QV_A(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(121),n2h1(537))
  call Hloop_QV_A(ntryL,G1H2(1044),ex5(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(129),n2h1(538))
  call Hloop_QV_A(ntryL,G1H2(1049),ex5(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(133),n2h1(539))
  call Hloop_QV_A(ntryL,G1H2(904),ex5(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(141),n2h1(540))
  call Hloop_QV_A(ntryL,G1H2(997),ex5(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(149),n2h1(541))
  call Hloop_QV_A(ntryL,G1H2(867),ex5(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(153),n2h1(542))
  call Hloop_QV_A(ntryL,G1H2(1069),ex4(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(157),n2h1(543))
  call Hloop_QV_A(ntryL,G1H2(1074),ex4(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(165),n2h1(544))
  call Hloop_QV_A(ntryL,G1H2(919),ex4(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(173),n2h1(545))
  call Hloop_AV_Q(ntryL,G1H2(257),ex3(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(177),n2h1(546))
  call Hloop_AV_Q(ntryL,G1H2(258),ex3(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(185),n2h1(547))
  call Hloop_AV_Q(ntryL,G1H2(259),ex3(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(189),n2h1(548))
  call Hloop_AV_Q(ntryL,G1H2(402),ex5(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(193),n2h1(549))
  call Hloop_AV_Q(ntryL,G1H2(1034),ex5(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(196),n2h1(550))
  call Hloop_QV_A(ntryL,G1H2(972),ex4(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(52),n2h1(551))
  call Hloop_QV_A(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(199),n2h1(552))
  call Hloop_QV_A(ntryL,G1H2(281),ex4(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(202),n2h1(553))
  call Hloop_QV_A(ntryL,G1H2(314),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(60),n2h1(554))
  call Hloop_QV_A(ntryL,G1H2(1039),ex5(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(205),n2h1(555))
  call Hloop_QV_A(ntryL,G1H2(295),ex3(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(208),n2h1(556))
  call Hloop_QV_A(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(211),n2h1(557))
  call Hloop_QV_A(ntryL,G1H2(297),ex3(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(68),n2h1(558))
  call Hloop_QV_A(ntryL,G1H2(1037),ex5(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(214),n2h1(559))
  call Hloop_QV_A(ntryL,G1H2(897),ex5(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(217),n2h1(560))
  call Hloop_QV_A(ntryL,G1H2(1079),ex3(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(220),n2h1(561))
  call Hloop_QV_A(ntryL,G1H2(1084),ex3(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(223),n2h1(562))
  call Hloop_QV_A(ntryL,G1H2(924),ex3(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(226),n2h1(563))
  call Hloop_QV_A(ntryL,G1H2(982),ex5(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(229),n2h1(564))
  call Hloop_QV_A(ntryL,G1H2(852),ex5(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(232),n2h1(565))
  call Hloop_QV_A(ntryL,G1H2(363),ex4(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(235),n2h1(566))
  call Hloop_QV_A(ntryL,G1H2(1064),ex4(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(274),n2h1(567))
  call Hloop_QV_A(ntryL,G1H2(350),ex3(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(76),n2h1(568))
  call Hloop_QV_A(ntryL,G1H2(351),ex3(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(241),n2h1(569))
  call Hloop_QV_A(ntryL,G1H2(352),ex3(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(280),n2h1(570))
  call Hloop_QV_A(ntryL,G1H2(1062),ex4(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(84),n2h1(571))
  call Hloop_QV_A(ntryL,G1H2(912),ex4(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(247),n2h1(572))
  call Hloop_AV_Q(ntryL,G1H2(378),ex4(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(304),n2h1(573))
  call Hloop_AV_Q(ntryL,G1H2(379),ex4(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(92),n2h1(574))
  call Hloop_AV_Q(ntryL,G1H2(380),ex4(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(253),n2h1(575))
  call Hloop_AV_Q(ntryL,G1H2(1109),ex5(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(328),n2h1(576))
  call Hloop_AV_Q(ntryL,G1H2(1114),ex5(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(259),n2h1(577))
  call Hloop_AV_Q(ntryL,G1H2(939),ex5(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(100),n2h1(578))
  call Hloop_AV_Q(ntryL,G1H2(1032),ex5(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(262),n2h1(579))
  call Hloop_AV_Q(ntryL,G1H2(892),ex5(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(337),n2h1(580))
  call Hloop_AV_Q(ntryL,G1H2(1129),ex4(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(268),n2h1(581))
  call Hloop_AV_Q(ntryL,G1H2(1134),ex4(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(108),n2h1(582))
  call Hloop_AV_Q(ntryL,G1H2(949),ex4(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(271),n2h1(583))
  call Hloop_AV_Q(ntryL,G1H2(416),ex3(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(116),n2h1(584))
  call Hloop_AV_Q(ntryL,G1H2(417),ex3(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(277),n2h1(585))
  call Hloop_AV_Q(ntryL,G1H2(418),ex3(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(124),n2h1(586))
  call Hloop_AV_Q(ntryL,G1H2(1002),ex5(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(283),n2h1(587))
  call Hloop_AV_Q(ntryL,G1H2(872),ex5(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(346),n2h1(588))
  call Hloop_AV_Q(ntryL,G1H2(1139),ex3(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(289),n2h1(589))
  call Hloop_AV_Q(ntryL,G1H2(1144),ex3(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(292),n2h1(590))
  call Hloop_AV_Q(ntryL,G1H2(954),ex3(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(355),n2h1(591))
  call Hloop_AV_Q(ntryL,G1H2(449),ex3(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(298),n2h1(592))
  call Hloop_AV_Q(ntryL,G1H2(450),ex3(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(136),n2h1(593))
  call Hloop_AV_Q(ntryL,G1H2(451),ex3(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(301),n2h1(594))
  call Hloop_AV_Q(ntryL,G1H2(1007),ex4(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(144),n2h1(595))
  call Hloop_AV_Q(ntryL,G1H2(877),ex4(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(307),n2h1(596))
  call Hotf_4pt_reduction(G2H2(175),RedSet_4(6),mass4set(:,3),  & 
G1H2(521),G1H2(40),G1H2(641),G1H2(527),G1H2(275),2)
  call HG1shiftOLR(G1H2(40),16,2)
  call Hotf_4pt_reduction(G2H2(176),RedSet_4(16),mass4set(:,3),  & 
G1H2(46),G1H2(533),G1H2(94),G1H2(539),G1H2(95),2)
  call HG1shiftOLR(G1H2(533),16,2)
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(27),mass4set(:,3),  & 
G1H2(581),G1H2(545),G1H2(187),G1H2(99),G1H2(225),2)
  call HG1shiftOLR(G1H2(545),8,2)
  call Hotf_4pt_reduction(G2H2(179),RedSet_4(31),mass4set(:,3),  & 
G1H2(137),G1H2(551),G1H2(141),G1H2(423),G1H2(163),2)
  call HG1shiftOLR(G1H2(551),8,2)
  call Hotf_4pt_reduction(G2H2(182),RedSet_4(45),mass4set(:,3),  & 
G1H2(563),G1H2(164),G1H2(456),G1H2(185),G1H2(575),2)
  call HG1shiftOLR(G1H2(164),16,2)
  call Hotf_4pt_reduction(G2H2(184),RedSet_4(51),mass4set(:,3),  & 
G1H2(186),G1H2(647),G1H2(587),G1H2(207),G1H2(653),2)
  call HG1shiftOLR(G1H2(647),16,2)
  call Hotf_4pt_reduction(G2H2(209),RedSet_4(58),mass4set(:,3),  & 
G1H2(593),G1H2(208),G1H2(659),G1H2(599),G1H2(209),2)
  call HG1shiftOLR(G1H2(208),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(61),mass4set(:,3),  & 
G1H2(695),G1H2(605),G1H2(229),G1H2(701),G1H2(611),2)
  call HG1shiftOLR(G1H2(605),8,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(72),mass4set(:,1),  & 
G1H2(230),G1H2(707),G1H2(617),G1H2(231),G1H2(390),2)
  call HG1shiftOLR(G1H2(707),16,2)
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(85),mass4set(:,1),  & 
G1H2(251),G1H2(623),G1H2(252),G1H2(302),G1H2(273),2)
  call HG1shiftOLR(G1H2(623),16,2)
  call Hotf_4pt_reduction(G2H2(233),RedSet_4(97),mass4set(:,1),  & 
G1H2(635),G1H2(274),G1H2(713),G1H2(665),G1H2(306),2)
  call HG1shiftOLR(G1H2(274),8,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(102),mass4set(:,1),  & 
G1H2(719),G1H2(671),G1H2(307),G1H2(725),G1H2(677),2)
  call HG1shiftOLR(G1H2(671),16,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(103),mass4set(:,4),  & 
G1H2(308),G1H2(357),G1H2(328),G1H2(683),G1H2(329),2)
  call HG1shiftOLR(G1H2(357),16,2)
  call Hotf_4pt_reduction(G2H2(241),RedSet_4(85),mass4set(:,1),  & 
G1H2(767),G1H2(731),G1H2(372),G1H2(773),G1H2(737),2)
  call HG1shiftOLR(G1H2(731),16,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(115),mass4set(:,1),  & 
G1H2(373),G1H2(779),G1H2(743),G1H2(374),G1H2(803),2)
  call HG1shiftOLR(G1H2(779),8,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(116),mass4set(:,4),  & 
G1H2(749),G1H2(394),G1H2(809),G1H2(755),G1H2(395),2)
  call HG1shiftOLR(G1H2(394),8,2)
  call Hotf_4pt_reduction(G2H2(55),RedSet_4(97),mass4set(:,1),  & 
G1H2(815),G1H2(761),G1H2(396),G1H2(821),G1H2(785),2)
  call HG1shiftOLR(G1H2(761),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(72),mass4set(:,1),  & 
G1H2(427),G1H2(827),G1H2(791),G1H2(428),G1H2(833),2)
  call HG1shiftOLR(G1H2(827),16,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(142),mass4set(:,1),  & 
G1H2(797),G1H2(429),G1H2(133),G1H2(55),G1H2(6),2)
  call HG1shiftOLR(G1H2(429),16,2)
  call Hotf_4pt_reduction(G2H2(268),RedSet_4(143),mass4set(:,4),  & 
G1H2(93),G1H2(29),G1H2(83),G1H2(23),G1H2(130),2)
  call HG1shiftOLR(G1H2(29),16,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(150),mass4set(:,1),  & 
G1H2(127),G1H2(159),G1H2(125),G1H2(203),G1H2(49),2)
  call HG1shiftOLR(G1H2(159),4,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(151),mass4set(:,4),  & 
G1H2(247),G1H2(21),G1H2(269),G1H2(495),G1H2(489),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hotf_4pt_reduction(G2H2(276),RedSet_4(154),mass4set(:,1),  & 
G1H2(267),G1H2(291),G1H2(519),G1H2(507),G1H2(322),2)
  call HG1shiftOLR(G1H2(291),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(166),mass4set(:,1),  & 
G1H2(346),G1H2(245),G1H2(368),G1H2(537),G1H2(531),2)
  call HG1shiftOLR(G1H2(245),8,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(167),mass4set(:,4),  & 
G1H2(157),G1H2(412),G1H2(477),G1H2(465),G1H2(179),2)
  call HG1shiftOLR(G1H2(412),8,2)
  call Hotf_4pt_reduction(G2H2(289),RedSet_4(170),mass4set(:,1),  & 
G1H2(445),G1H2(50),G1H2(128),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(175),mass4set(:,1),  & 
G1H2(27),G1H2(96),G1H2(81),G1H2(82),G1H2(129),2)
  call HG1shiftOLR(G1H2(96),4,2)
  call Hotf_4pt_reduction(G2H2(297),RedSet_4(176),mass4set(:,4),  & 
G1H2(158),G1H2(471),G1H2(180),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(471),4,2)
  call Hotf_4pt_reduction(G2H2(300),RedSet_4(178),mass4set(:,1),  & 
G1H2(549),G1H2(223),G1H2(555),G1H2(224),G1H2(246),2)
  call HG1shiftOLR(G1H2(223),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(102),mass4set(:,1),  & 
G1H2(268),G1H2(289),G1H2(290),G1H2(633),G1H2(300),2)
  call HG1shiftOLR(G1H2(289),16,2)
  call Hotf_4pt_reduction(G2H2(308),RedSet_4(181),mass4set(:,4),  & 
G1H2(639),G1H2(301),G1H2(513),G1H2(323),G1H2(344),2)
  call HG1shiftOLR(G1H2(301),16,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(115),mass4set(:,1),  & 
G1H2(345),G1H2(681),G1H2(355),G1H2(687),G1H2(356),2)
  call HG1shiftOLR(G1H2(681),8,2)
  call Hotf_4pt_reduction(G2H2(313),RedSet_4(190),mass4set(:,4),  & 
G1H2(366),G1H2(367),G1H2(621),G1H2(388),G1H2(627),2)
  call HG1shiftOLR(G1H2(367),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(142),mass4set(:,1),  & 
G1H2(389),G1H2(410),G1H2(411),G1H2(561),G1H2(421),2)
  call HG1shiftOLR(G1H2(410),16,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(196),mass4set(:,4),  & 
G1H2(567),G1H2(422),G1H2(443),G1H2(444),G1H2(573),2)
  call HG1shiftOLR(G1H2(422),16,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(150),mass4set(:,1),  & 
G1H2(454),G1H2(579),G1H2(455),G1H2(20),G1H2(32),2)
  call HG1shiftOLR(G1H2(579),4,2)
  call Hotf_4pt_reduction(G2H2(324),RedSet_4(201),mass4set(:,4),  & 
G1H2(103),G1H2(37),G1H2(839),G1H2(264),G1H2(38),2)
  call HG1shiftOLR(G1H2(37),4,2)
  call Hotf_4pt_reduction(G2H2(329),RedSet_4(154),mass4set(:,1),  & 
G1H2(98),G1H2(844),G1H2(176),G1H2(104),G1H2(72),2)
  call HG1shiftOLR(G1H2(844),4,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(166),mass4set(:,1),  & 
G1H2(78),G1H2(849),G1H2(341),G1H2(75),G1H2(4),2)
  call HG1shiftOLR(G1H2(849),8,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(207),mass4set(:,4),  & 
G1H2(15),G1H2(70),G1H2(16),G1H2(854),G1H2(154),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_4pt_reduction(G2H2(337),RedSet_4(170),mass4set(:,1),  & 
G1H2(17),G1H2(65),G1H2(859),G1H2(286),G1H2(71),2)
  call HG1shiftOLR(G1H2(65),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(175),mass4set(:,1),  & 
G1H2(117),G1H2(118),G1H2(864),G1H2(198),G1H2(119),2)
  call HG1shiftOLR(G1H2(118),4,2)
  call Hotf_4pt_reduction(G2H2(345),RedSet_4(212),mass4set(:,4),  & 
G1H2(152),G1H2(153),G1H2(987),G1H2(169),G1H2(174),2)
  call HG1shiftOLR(G1H2(153),4,2)
  call Hotf_4pt_reduction(G2H2(348),RedSet_4(178),mass4set(:,1),  & 
G1H2(175),G1H2(957),G1H2(191),G1H2(192),G1H2(196),2)
  call HG1shiftOLR(G1H2(957),4,2)
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(29),mass4set(:,2),  & 
G1H4(357),G1H4(69),G1H4(70),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(69),9,4)
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(33),mass4set(:,2),  & 
G1H4(81),G1H4(82),G1H4(362),G1H4(363),G1H4(93),4)
  call HG1shiftOLR(G1H4(82),9,4)
  call Hloop_VQ_A(ntryL,G1H4(133),wf4(:,11),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(364),n2h1(597))
  call Hloop_VQ_A(ntryL,G1H4(140),wf4(:,11),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,668))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(313),n2h1(598))
  call Hloop_VQ_A(ntryL,G1H4(144),wf4(:,11),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(316),n2h1(599))
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(59),mass4set(:,2),  & 
G1H4(94),G1H4(365),G1H4(366),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(365),10,4)
  call Hotf_4pt_reduction(G2H4(116),RedSet_4(62),mass4set(:,2),  & 
G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(374),4)
  call HG1shiftOLR(G1H4(369),10,4)
  call Hloop_VA_Q(ntryL,G1H4(175),wf4(:,4),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,670))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(373),n2h1(600))
  call Hloop_VA_Q(ntryL,G1H4(176),wf4(:,4),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,671))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(322),n2h1(601))
  call Hloop_VA_Q(ntryL,G1H4(182),wf4(:,4),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,672))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(325),n2h1(602))
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(46),mass4set(:,2),  & 
G1H4(375),G1H4(117),G1H4(118),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(117),17,4)
  call Hloop_VQ_A(ntryL,G1H4(216),wf4(:,14),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,673))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(331),n2h1(603))
  call Hloop_VQ_A(ntryL,G1H4(259),wf4(:,14),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(160),n2h1(604))
  call Hloop_VQ_A(ntryL,G1H4(218),wf4(:,14),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,675))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(334),n2h1(605))
  call Hotf_4pt_reduction(G2H4(126),RedSet_4(52),mass4set(:,2),  & 
G1H4(379),G1H4(380),G1H4(383),G1H4(384),G1H4(129),4)
  call HG1shiftOLR(G1H4(380),17,4)
  call Hloop_VQ_A(ntryL,G1H4(254),wf4(:,14),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,676))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(340),n2h1(606))
  call Hloop_VQ_A(ntryL,G1H4(260),wf4(:,14),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(168),n2h1(607))
  call Hotf_4pt_reduction(G2H4(120),RedSet_4(8),mass4set(:,2),  & 
G1H4(130),G1H4(386),G1H4(387),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(386),18,4)
  call Hloop_VA_Q(ntryL,G1H4(18),wf4(:,6),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,678))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(343),n2h1(608))
  call Hloop_VA_Q(ntryL,G1H4(234),wf4(:,6),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,679))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(349),n2h1(609))
  call Hloop_VA_Q(ntryL,G1H4(66),wf4(:,6),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,680))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(352),n2h1(610))
  call Hotf_4pt_reduction(G2H4(130),RedSet_4(18),mass4set(:,2),  & 
G1H4(389),G1H4(390),G1H4(153),G1H4(154),G1H4(392),4)
  call HG1shiftOLR(G1H4(390),18,4)
  call Hloop_VA_Q(ntryL,G1H4(222),wf4(:,6),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,681))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(358),n2h1(611))
  call Hloop_VA_Q(ntryL,G1H4(270),wf4(:,6),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,682))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(180),n2h1(612))
  call Hloop_AV_Q(ntryL,G1H2(958),ex5(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(361),n2h1(613))
  call Hloop_AV_Q(ntryL,G1H2(963),ex5(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(367),n2h1(614))
  call Hloop_QV_A(ntryL,G1H2(968),ex4(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(370),n2h1(615))
  call Hloop_QV_A(ntryL,G1H2(973),ex4(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(376),n2h1(616))
  call Hloop_QV_A(ntryL,G1H2(978),ex5(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(379),n2h1(617))
  call Hloop_QV_A(ntryL,G1H2(983),ex5(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(383),n2h1(618))
  call Hloop_AV_Q(ntryL,G1H2(988),ex4(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(387),n2h1(619))
  call Hloop_AV_Q(ntryL,G1H2(993),ex4(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(391),n2h1(620))
  call Hloop_QV_A(ntryL,G1H2(1048),ex5(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(395),n2h1(621))
  call Hloop_AV_Q(ntryL,G1H2(1093),ex5(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(399),n2h1(622))
  call Hloop_AV_Q(ntryL,G1H2(1103),ex4(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(465),n2h1(623))
  call Hloop_QV_A(ntryL,G1H2(1013),ex5(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(466),n2h1(624))
  call Hloop_QV_A(ntryL,G1H2(1038),ex5(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(467),n2h1(625))
  call Hloop_QV_A(ntryL,G1H2(1023),ex4(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(468),n2h1(626))
  call Hloop_QV_A(ntryL,G1H2(1063),ex4(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(469),n2h1(627))
  call Hloop_AV_Q(ntryL,G1H2(1113),ex5(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(470),n2h1(628))
  call Hloop_QV_A(ntryL,G1H2(1043),ex5(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(471),n2h1(629))
  call Hloop_QV_A(ntryL,G1H2(1053),ex3(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(472),n2h1(630))
  call Hloop_QV_A(ntryL,G1H2(1058),ex3(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(473),n2h1(631))
  call Hloop_QV_A(ntryL,G1H2(1068),ex4(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(474),n2h1(632))
  call Hloop_QV_A(ntryL,G1H2(1073),ex4(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(475),n2h1(633))
  call Hloop_QV_A(ntryL,G1H2(1078),ex3(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(476),n2h1(634))
  call Hloop_QV_A(ntryL,G1H2(1083),ex3(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(477),n2h1(635))
  call Hloop_AV_Q(ntryL,G1H2(1088),ex5(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(478),n2h1(636))
  call Hloop_AV_Q(ntryL,G1H2(1098),ex4(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(479),n2h1(637))
  call Hloop_AV_Q(ntryL,G1H2(1108),ex5(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(480),n2h1(638))
  call Hloop_AV_Q(ntryL,G1H2(1118),ex3(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(481),n2h1(639))
  call Hloop_AV_Q(ntryL,G1H2(1123),ex3(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(482),n2h1(640))
  call Hloop_AV_Q(ntryL,G1H2(1128),ex4(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(483),n2h1(641))
  call Hloop_AV_Q(ntryL,G1H2(1133),ex4(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(484),n2h1(642))
  call Hloop_AV_Q(ntryL,G1H2(1138),ex3(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(485),n2h1(643))
  call Hloop_AV_Q(ntryL,G1H2(1143),ex3(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(486),n2h1(644))
  call Hloop_QV_A(ntryL,G1H2(1017),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(487),n2h1(645))
  call Hloop_QV_A(ntryL,G1H2(1027),ex4(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(488),n2h1(646))
  call Hloop_QV_A(ntryL,G1H2(1047),ex5(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(489),n2h1(647))
  call Hloop_QV_A(ntryL,G1H2(1057),ex3(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(490),n2h1(648))
  call Hloop_QV_A(ntryL,G1H2(1072),ex4(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(491),n2h1(649))
  call Hloop_QV_A(ntryL,G1H2(1082),ex3(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(492),n2h1(650))
  call Hloop_AV_Q(ntryL,G1H2(1092),ex5(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(493),n2h1(651))
  call Hloop_AV_Q(ntryL,G1H2(1102),ex4(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(494),n2h1(652))
  call Hloop_AV_Q(ntryL,G1H2(1112),ex5(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(495),n2h1(653))
  call Hloop_AV_Q(ntryL,G1H2(1122),ex3(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(496),n2h1(654))
  call Hloop_AV_Q(ntryL,G1H2(1132),ex4(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(497),n2h1(655))
  call Hloop_AV_Q(ntryL,G1H2(1142),ex3(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(498),n2h1(656))
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(78),mass4set(:,2),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(107),8)
  call HG1shiftOLR(G1H8(102),21,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(131),mass4set(:,2),  & 
G1H8(108),G1H8(1),G1H8(2),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(1),22,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(140),mass4set(:,2),  & 
G1H8(7),G1H8(8),G1H8(4),G1H8(10),G1H8(16),8)
  call HG1shiftOLR(G1H8(8),25,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(91),mass4set(:,2),  & 
G1H8(21),G1H8(27),G1H8(34),G1H8(40),G1H8(45),8)
  call HG1shiftOLR(G1H8(27),26,8)
  call Hotf_4pt_reduction(G2H8(37),RedSet_4(78),mass4set(:,2),  & 
G1H8(63),G1H8(69),G1H8(75),G1H8(81),G1H8(99),8)
  call HG1shiftOLR(G1H8(69),21,8)
  call Hotf_4pt_reduction(G2H8(38),RedSet_4(140),mass4set(:,2),  & 
G1H8(105),G1H8(3),G1H8(18),G1H8(15),G1H8(12),8)
  call HG1shiftOLR(G1H8(3),25,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(131),mass4set(:,2),  & 
G1H8(29),G1H8(22),G1H8(33),G1H8(17),G1H8(39),8)
  call HG1shiftOLR(G1H8(22),22,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(91),mass4set(:,2),  & 
G1H8(13),G1H8(32),G1H8(52),G1H8(57),G1H8(14),8)
  call HG1shiftOLR(G1H8(32),26,8)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(54),ex1(:),G2tensor(499),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(57),ex1(:),G2tensor(500),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(508),ex1(:),G2tensor(501),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(510),ex1(:),G2tensor(502),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex2(:),G2tensor(503),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex2(:),G2tensor(504),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(513),ex2(:),G2tensor(505),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex2(:),G2tensor(506),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(72),ex2(:),G2tensor(507),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(74),ex2(:),G2tensor(508),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex1(:),G2tensor(509),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(517),ex1(:),G2tensor(510),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(77),wf4(:,11),G2tensor(511),m3h4x1(:,41),heltab2x4(:,:,683))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(81),wf4(:,11),G2tensor(512),m3h4x1(:,42),heltab2x4(:,:,684))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(85),wf4(:,4),G2tensor(513),m3h4x1(:,43),heltab2x4(:,:,685))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(89),wf4(:,4),G2tensor(514),m3h4x1(:,44),heltab2x4(:,:,686))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(87),wf4(:,14),G2tensor(515),m3h4x1(:,45),heltab2x4(:,:,687))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(104),wf4(:,14),G2tensor(516),m3h4x1(:,46),heltab2x4(:,:,688))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(92),wf4(:,14),G2tensor(517),m3h4x1(:,47),heltab2x4(:,:,689))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(101),wf4(:,14),G2tensor(518),m3h4x1(:,48),heltab2x4(:,:,690))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(20),wf4(:,6),G2tensor(519),m3h4x1(:,49),heltab2x4(:,:,691))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(24),wf4(:,6),G2tensor(520),m3h4x1(:,50),heltab2x4(:,:,692))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(25),wf4(:,6),G2tensor(521),m3h4x1(:,51),heltab2x4(:,:,693))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(29),wf4(:,6),G2tensor(522),m3h4x1(:,52),heltab2x4(:,:,694))
  call Hloop_AV_Q(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(523),n2h1(657))
  call Hloop_AV_Q(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(524),n2h1(658))
  call Hloop_AV_Q(ntryL,G1H2(52),ex5(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(525),n2h1(659))
  call Hloop_AV_Q(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(526),n2h1(660))
  call Hloop_AV_Q(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(527),n2h1(661))
  call Hloop_AV_Q(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(528),n2h1(662))
  call Hloop_AV_Q(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(529),n2h1(663))
  call Hloop_AV_Q(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(530),n2h1(664))
  call Hloop_AV_Q(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(531),n2h1(665))
  call Hloop_AV_Q(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(532),n2h1(666))
  call Hloop_AV_Q(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(533),n2h1(667))
  call Hloop_AV_Q(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(534),n2h1(668))
  call Hloop_AV_Q(ntryL,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(535),n2h1(669))
  call Hloop_AV_Q(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(536),n2h1(670))
  call Hloop_AV_Q(ntryL,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(537),n2h1(671))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(538),n2h1(672))
  call Hloop_QV_A(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(539),n2h1(673))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(540),n2h1(674))
  call Hloop_QV_A(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(541),n2h1(675))
  call Hloop_QV_A(ntryL,G1H2(172),ex4(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(542),n2h1(676))
  call Hloop_QV_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(543),n2h1(677))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(544),n2h1(678))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(545),n2h1(679))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(546),n2h1(680))
  call Hloop_QV_A(ntryL,G1H2(190),ex5(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(547),n2h1(681))
  call Hloop_QV_A(ntryL,G1H2(195),ex5(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(548),n2h1(682))
  call Hloop_QV_A(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(549),n2h1(683))
  call Hloop_QV_A(ntryL,G1H2(205),ex5(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(550),n2h1(684))
  call Hloop_QV_A(ntryL,G1H2(206),ex5(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(551),n2h1(685))
  call Hloop_QV_A(ntryL,G1H2(217),ex5(:),G1H1(1),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(552),n2h1(686))
  call Hloop_QV_A(ntryL,G1H2(221),ex5(:),G1H1(1),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(553),n2h1(687))
  call Hloop_QV_A(ntryL,G1H2(222),ex5(:),G1H1(1),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(554),n2h1(688))
  call Hloop_QV_A(ntryL,G1H2(228),ex5(:),G1H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(555),n2h1(689))
  call Hloop_QV_A(ntryL,G1H2(238),ex5(:),G1H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(556),n2h1(690))
  call Hloop_QV_A(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(557),n2h1(691))
  call Hloop_QV_A(ntryL,G1H2(244),ex5(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(558),n2h1(692))
  call Hloop_QV_A(ntryL,G1H2(255),ex5(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(559),n2h1(693))
  call Hloop_QV_A(ntryL,G1H2(249),ex5(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(560),n2h1(694))
  call Hloop_QV_A(ntryL,G1H2(256),ex5(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(561),n2h1(695))
  call Hloop_AV_Q(ntryL,G1H2(261),ex4(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(562),n2h1(696))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(563),n2h1(697))
  call Hloop_AV_Q(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(564),n2h1(698))
  call Hloop_AV_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(565),n2h1(699))
  call Hloop_AV_Q(ntryL,G1H2(282),ex4(:),G1H1(1),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(566),n2h1(700))
  call Hloop_AV_Q(ntryL,G1H2(287),ex4(:),G1H1(1),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(567),n2h1(701))
  call Hloop_AV_Q(ntryL,G1H2(288),ex4(:),G1H1(1),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(568),n2h1(702))
  call Hloop_AV_Q(ntryL,G1H2(293),ex4(:),G1H1(1),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(569),n2h1(703))
  call Hloop_AV_Q(ntryL,G1H2(299),ex4(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(570),n2h1(704))
  call Hloop_QV_A(ntryL,G1H2(310),ex5(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(571),n2h1(705))
  call Hloop_QV_A(ntryL,G1H2(304),ex5(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(572),n2h1(706))
  call Hloop_QV_A(ntryL,G1H2(311),ex5(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(573),n2h1(707))
  call Hloop_QV_A(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(574),n2h1(708))
  call Hloop_QV_A(ntryL,G1H2(320),ex5(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(575),n2h1(709))
  call Hloop_QV_A(ntryL,G1H2(326),ex5(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(576),n2h1(710))
  call Hloop_AV_Q(ntryL,G1H2(327),ex5(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(577),n2h1(711))
  call Hloop_AV_Q(ntryL,G1H2(337),ex5(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(578),n2h1(712))
  call Hloop_AV_Q(ntryL,G1H2(342),ex5(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(579),n2h1(713))
  call Hloop_AV_Q(ntryL,G1H2(343),ex5(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(580),n2h1(714))
  call Hloop_AV_Q(ntryL,G1H2(348),ex5(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(581),n2h1(715))
  call Hloop_AV_Q(ntryL,G1H2(354),ex5(:),G1H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(582),n2h1(716))
  call Hloop_AV_Q(ntryL,G1H2(359),ex4(:),G1H1(1),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(583),n2h1(717))
  call Hloop_AV_Q(ntryL,G1H2(360),ex4(:),G1H1(1),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(584),n2h1(718))
  call Hloop_AV_Q(ntryL,G1H2(376),ex4(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(585),n2h1(719))
  call Hloop_AV_Q(ntryL,G1H2(370),ex4(:),G1H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(586),n2h1(720))
  call Hloop_AV_Q(ntryL,G1H2(371),ex4(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(587),n2h1(721))
  call Hloop_AV_Q(ntryL,G1H2(382),ex4(:),G1H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(588),n2h1(722))
  call Hloop_QV_A(ntryL,G1H2(386),ex5(:),G1H1(1),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(589),n2h1(723))
  call Hloop_QV_A(ntryL,G1H2(387),ex5(:),G1H1(1),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(590),n2h1(724))
  call Hloop_QV_A(ntryL,G1H2(393),ex5(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(591),n2h1(725))
  call Hloop_QV_A(ntryL,G1H2(403),ex5(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(592),n2h1(726))
  call Hloop_QV_A(ntryL,G1H2(399),ex5(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(593),n2h1(727))
  call Hloop_QV_A(ntryL,G1H2(409),ex5(:),G1H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(594),n2h1(728))
  call Hloop_QV_A(ntryL,G1H2(414),ex5(:),G1H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(595),n2h1(729))
  call Hloop_QV_A(ntryL,G1H2(415),ex5(:),G1H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(596),n2h1(730))
  call Hloop_QV_A(ntryL,G1H2(431),ex5(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(597),n2h1(731))
  call Hloop_QV_A(ntryL,G1H2(425),ex4(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(598),n2h1(732))
  call Hloop_QV_A(ntryL,G1H2(426),ex4(:),G1H1(1),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(599),n2h1(733))
  call Hloop_QV_A(ntryL,G1H2(437),ex4(:),G1H1(1),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(600),n2h1(734))
  call Hloop_QV_A(ntryL,G1H2(441),ex4(:),G1H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(601),n2h1(735))
  call Hloop_QV_A(ntryL,G1H2(442),ex4(:),G1H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(602),n2h1(736))
  call Hloop_QV_A(ntryL,G1H2(452),ex4(:),G1H1(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(603),n2h1(737))
  call Hloop_QV_A(ntryL,G1H2(453),ex4(:),G1H1(1),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(604),n2h1(738))
  call Hloop_QV_A(ntryL,G1H2(458),ex4(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(605),n2h1(739))
  call Hloop_QV_A(ntryL,G1H2(464),ex4(:),G1H1(1),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(606),n2h1(740))
  call Hloop_AV_Q(ntryL,G1H2(955),ex5(:),G1H1(1),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(607),n2h1(741))
  call Hloop_AV_Q(ntryL,G1H2(469),ex5(:),G1H1(1),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(608),n2h1(742))
  call Hloop_AV_Q(ntryL,G1H2(475),ex5(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(609),n2h1(743))
  call Hloop_AV_Q(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(610),n2h1(744))
  call Hloop_AV_Q(ntryL,G1H2(960),ex5(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(611),n2h1(745))
  call Hloop_AV_Q(ntryL,G1H2(840),ex5(:),G1H1(1),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(612),n2h1(746))
  call Hloop_QV_A(ntryL,G1H2(487),ex5(:),G1H1(1),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(613),n2h1(747))
  call Hloop_QV_A(ntryL,G1H2(488),ex5(:),G1H1(1),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(614),n2h1(748))
  call Hloop_QV_A(ntryL,G1H2(494),ex5(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(615),n2h1(749))
  call Hloop_QV_A(ntryL,G1H2(970),ex5(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(616),n2h1(750))
  call Hloop_QV_A(ntryL,G1H2(499),ex5(:),G1H1(1),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(617),n2h1(751))
  call Hloop_QV_A(ntryL,G1H2(505),ex5(:),G1H1(1),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(618),n2h1(752))
  call Hloop_QV_A(ntryL,G1H2(506),ex3(:),G1H1(1),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(619),n2h1(753))
  call Hloop_QV_A(ntryL,G1H2(975),ex3(:),G1H1(1),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(620),n2h1(754))
  call Hloop_QV_A(ntryL,G1H2(850),ex3(:),G1H1(1),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(621),n2h1(755))
  call Hloop_QV_A(ntryL,G1H2(517),ex3(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(622),n2h1(756))
  call Hloop_QV_A(ntryL,G1H2(518),ex3(:),G1H1(1),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(623),n2h1(757))
  call Hloop_QV_A(ntryL,G1H2(524),ex3(:),G1H1(1),m3h2x1(:,730),heltab2x2(:,:,730))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(624),n2h1(758))
  call Hloop_QV_A(ntryL,G1H2(855),ex3(:),G1H1(1),m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(625),n2h1(759))
  call Hloop_QV_A(ntryL,G1H2(529),ex3(:),G1H1(1),m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(626),n2h1(760))
  call Hloop_QV_A(ntryL,G1H2(535),ex3(:),G1H1(1),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(627),n2h1(761))
  call Hloop_QV_A(ntryL,G1H2(536),ex4(:),G1H1(1),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(628),n2h1(762))
  call Hloop_QV_A(ntryL,G1H2(990),ex4(:),G1H1(1),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(629),n2h1(763))
  call Hloop_QV_A(ntryL,G1H2(860),ex4(:),G1H1(1),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(630),n2h1(764))
  call Hloop_QV_A(ntryL,G1H2(547),ex4(:),G1H1(1),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(631),n2h1(765))
  call Hloop_QV_A(ntryL,G1H2(548),ex4(:),G1H1(1),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(632),n2h1(766))
  call Hloop_QV_A(ntryL,G1H2(554),ex4(:),G1H1(1),m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(633),n2h1(767))
  call Hloop_AV_Q(ntryL,G1H2(865),ex5(:),G1H1(1),m3h2x1(:,740),heltab2x2(:,:,740))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(634),n2h1(768))
  call Hloop_AV_Q(ntryL,G1H2(559),ex5(:),G1H1(1),m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(635),n2h1(769))
  call Hloop_AV_Q(ntryL,G1H2(565),ex5(:),G1H1(1),m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(636),n2h1(770))
  call Hloop_AV_Q(ntryL,G1H2(566),ex5(:),G1H1(1),m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(637),n2h1(771))
  call Hloop_AV_Q(ntryL,G1H2(870),ex5(:),G1H1(1),m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(638),n2h1(772))
  call Hloop_AV_Q(ntryL,G1H2(1005),ex5(:),G1H1(1),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(639),n2h1(773))
  call Hloop_AV_Q(ntryL,G1H2(577),ex5(:),G1H1(1),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(640),n2h1(774))
  call Hloop_AV_Q(ntryL,G1H2(578),ex5(:),G1H1(1),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(641),n2h1(775))
  call Hloop_AV_Q(ntryL,G1H2(584),ex5(:),G1H1(1),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(642),n2h1(776))
  call Hloop_AV_Q(ntryL,G1H2(1010),ex4(:),G1H1(1),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(643),n2h1(777))
  call Hloop_AV_Q(ntryL,G1H2(589),ex4(:),G1H1(1),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(644),n2h1(778))
  call Hloop_AV_Q(ntryL,G1H2(595),ex4(:),G1H1(1),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(645),n2h1(779))
  call Hloop_AV_Q(ntryL,G1H2(596),ex4(:),G1H1(1),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(646),n2h1(780))
  call Hloop_AV_Q(ntryL,G1H2(880),ex4(:),G1H1(1),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(647),n2h1(781))
  call Hloop_AV_Q(ntryL,G1H2(1020),ex4(:),G1H1(1),m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(648),n2h1(782))
  call Hloop_AV_Q(ntryL,G1H2(607),ex4(:),G1H1(1),m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(649),n2h1(783))
  call Hloop_AV_Q(ntryL,G1H2(608),ex4(:),G1H1(1),m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(650),n2h1(784))
  call Hloop_AV_Q(ntryL,G1H2(614),ex4(:),G1H1(1),m3h2x1(:,757),heltab2x2(:,:,757))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(651),n2h1(785))
  call Hloop_AV_Q(ntryL,G1H2(885),ex3(:),G1H1(1),m3h2x1(:,758),heltab2x2(:,:,758))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(652),n2h1(786))
  call Hloop_AV_Q(ntryL,G1H2(619),ex3(:),G1H1(1),m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(653),n2h1(787))
  call Hloop_AV_Q(ntryL,G1H2(625),ex3(:),G1H1(1),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(654),n2h1(788))
  call Hloop_AV_Q(ntryL,G1H2(626),ex3(:),G1H1(1),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(655),n2h1(789))
  call Hloop_AV_Q(ntryL,G1H2(890),ex3(:),G1H1(1),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(656),n2h1(790))
  call Hloop_AV_Q(ntryL,G1H2(1035),ex3(:),G1H1(1),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(657),n2h1(791))
  call Hloop_AV_Q(ntryL,G1H2(637),ex3(:),G1H1(1),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(658),n2h1(792))
  call Hloop_AV_Q(ntryL,G1H2(638),ex3(:),G1H1(1),m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(659),n2h1(793))
  call Hloop_AV_Q(ntryL,G1H2(644),ex3(:),G1H1(1),m3h2x1(:,766),heltab2x2(:,:,766))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(660),n2h1(794))
  call Hloop_VA_Q(ntryL,G1H2(1040),ex2(:),G1H1(1),m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(661),n2h1(795))
  call Hloop_VA_Q(ntryL,G1H2(649),ex2(:),G1H1(1),m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(662),n2h1(796))
  call Hloop_VA_Q(ntryL,G1H2(655),ex2(:),G1H1(1),m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(663),n2h1(797))
  call Hloop_VA_Q(ntryL,G1H2(656),ex2(:),G1H1(1),m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(664),n2h1(798))
  call Hloop_VA_Q(ntryL,G1H2(900),ex2(:),G1H1(1),m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(665),n2h1(799))
  call Hloop_VA_Q(ntryL,G1H2(1050),ex2(:),G1H1(1),m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(666),n2h1(800))
  call Hloop_VQ_A(ntryL,G1H2(667),ex1(:),G1H1(1),m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(667),n2h1(801))
  call Hloop_VQ_A(ntryL,G1H2(668),ex1(:),G1H1(1),m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(668),n2h1(802))
  call Hloop_VQ_A(ntryL,G1H2(674),ex1(:),G1H1(1),m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(669),n2h1(803))
  call Hloop_VQ_A(ntryL,G1H2(905),ex1(:),G1H1(1),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(670),n2h1(804))
  call Hloop_VQ_A(ntryL,G1H2(679),ex1(:),G1H1(1),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(671),n2h1(805))
  call Hloop_VQ_A(ntryL,G1H2(685),ex1(:),G1H1(1),m3h2x1(:,778),heltab2x2(:,:,778))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(672),n2h1(806))
  call Hloop_VQ_A(ntryL,G1H2(686),ex1(:),G1H1(1),m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(673),n2h1(807))
  call Hloop_VQ_A(ntryL,G1H2(910),ex1(:),G1H1(1),m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(674),n2h1(808))
  call Hloop_VQ_A(ntryL,G1H2(1065),ex1(:),G1H1(1),m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(675),n2h1(809))
  call Hloop_VA_Q(ntryL,G1H2(697),ex2(:),G1H1(1),m3h2x1(:,782),heltab2x2(:,:,782))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(676),n2h1(810))
  call Hloop_VA_Q(ntryL,G1H2(698),ex2(:),G1H1(1),m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(677),n2h1(811))
  call Hloop_VA_Q(ntryL,G1H2(704),ex2(:),G1H1(1),m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(678),n2h1(812))
  call Hloop_VQ_A(ntryL,G1H4(232),wf4(:,11),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(679),n2h1(813))
  call Hloop_VQ_A(ntryL,G1H4(243),wf4(:,11),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(680),n2h1(814))
  call Hloop_VQ_A(ntryL,G1H4(268),wf4(:,11),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,697))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(681),n2h1(815))
  call Hloop_VA_Q(ntryL,G1H4(279),wf4(:,4),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(682),n2h1(816))
  call Hloop_VA_Q(ntryL,G1H4(280),wf4(:,4),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,699))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(683),n2h1(817))
  call Hloop_VA_Q(ntryL,G1H4(293),wf4(:,4),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,700))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(684),n2h1(818))
  call Hloop_VQ_A(ntryL,G1H4(294),wf4(:,14),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,701))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(685),n2h1(819))
  call Hloop_VQ_A(ntryL,G1H4(297),wf4(:,14),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(686),n2h1(820))
  call Hloop_VQ_A(ntryL,G1H4(300),wf4(:,14),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,703))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(687),n2h1(821))
  call Hloop_VQ_A(ntryL,G1H4(303),wf4(:,14),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,704))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(688),n2h1(822))
  call Hloop_VQ_A(ntryL,G1H4(304),wf4(:,14),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,705))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(689),n2h1(823))
  call Hloop_VQ_A(ntryL,G1H4(309),wf4(:,14),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,706))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(690),n2h1(824))
  call Hloop_VA_Q(ntryL,G1H4(310),wf4(:,6),G1H1(1),m3h4x1(:,65),heltab2x4(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(691),n2h1(825))
  call Hloop_VA_Q(ntryL,G1H4(311),wf4(:,6),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,708))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(692),n2h1(826))
  call Hloop_VA_Q(ntryL,G1H4(316),wf4(:,6),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,709))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(693),n2h1(827))
  call Hloop_VA_Q(ntryL,G1H4(317),wf4(:,6),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,710))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(694),n2h1(828))
  call Hloop_VA_Q(ntryL,G1H4(318),wf4(:,6),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,711))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(695),n2h1(829))
  call Hloop_VA_Q(ntryL,G1H4(323),wf4(:,6),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,712))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(696),n2h1(830))
  call Hloop_VQ_A(ntryL,G1H2(915),ex1(:),G1H1(1),m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(697),n2h1(831))
  call Hloop_VQ_A(ntryL,G1H2(709),ex1(:),G1H1(1),m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(698),n2h1(832))
  call Hloop_VQ_A(ntryL,G1H2(715),ex1(:),G1H1(1),m3h2x1(:,787),heltab2x2(:,:,787))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(699),n2h1(833))
  call Hloop_QV_A(ntryL,G1H2(716),ex3(:),G1H1(1),m3h2x1(:,788),heltab2x2(:,:,788))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(700),n2h1(834))
  call Hloop_QV_A(ntryL,G1H2(1080),ex3(:),G1H1(1),m3h2x1(:,789),heltab2x2(:,:,789))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(701),n2h1(835))
  call Hloop_QV_A(ntryL,G1H2(920),ex3(:),G1H1(1),m3h2x1(:,790),heltab2x2(:,:,790))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(702),n2h1(836))
  call Hloop_VA_Q(ntryL,G1H2(727),ex2(:),G1H1(1),m3h2x1(:,791),heltab2x2(:,:,791))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(703),n2h1(837))
  call Hloop_VA_Q(ntryL,G1H2(728),ex2(:),G1H1(1),m3h2x1(:,792),heltab2x2(:,:,792))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(704),n2h1(838))
  call Hloop_VA_Q(ntryL,G1H2(734),ex2(:),G1H1(1),m3h2x1(:,793),heltab2x2(:,:,793))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(705),n2h1(839))
  call Hloop_AV_Q(ntryL,G1H2(1090),ex4(:),G1H1(1),m3h2x1(:,794),heltab2x2(:,:,794))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(706),n2h1(840))
  call Hloop_AV_Q(ntryL,G1H2(739),ex4(:),G1H1(1),m3h2x1(:,795),heltab2x2(:,:,795))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(707),n2h1(841))
  call Hloop_AV_Q(ntryL,G1H2(745),ex4(:),G1H1(1),m3h2x1(:,796),heltab2x2(:,:,796))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(708),n2h1(842))
  call Hloop_QV_A(ntryL,G1H2(746),ex3(:),G1H1(1),m3h2x1(:,797),heltab2x2(:,:,797))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(709),n2h1(843))
  call Hloop_QV_A(ntryL,G1H2(1095),ex3(:),G1H1(1),m3h2x1(:,798),heltab2x2(:,:,798))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(710),n2h1(844))
  call Hloop_QV_A(ntryL,G1H2(1100),ex3(:),G1H1(1),m3h2x1(:,799),heltab2x2(:,:,799))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(711),n2h1(845))
  call Hloop_QV_A(ntryL,G1H2(757),ex4(:),G1H1(1),m3h2x1(:,800),heltab2x2(:,:,800))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(712),n2h1(846))
  call Hloop_QV_A(ntryL,G1H2(758),ex4(:),G1H1(1),m3h2x1(:,801),heltab2x2(:,:,801))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(713),n2h1(847))
  call Hloop_QV_A(ntryL,G1H2(764),ex4(:),G1H1(1),m3h2x1(:,802),heltab2x2(:,:,802))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(714),n2h1(848))
  call Hloop_VA_Q(ntryL,G1H2(1105),ex2(:),G1H1(1),m3h2x1(:,803),heltab2x2(:,:,803))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(715),n2h1(849))
  call Hloop_VA_Q(ntryL,G1H2(769),ex2(:),G1H1(1),m3h2x1(:,804),heltab2x2(:,:,804))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(716),n2h1(850))
  call Hloop_VA_Q(ntryL,G1H2(775),ex2(:),G1H1(1),m3h2x1(:,805),heltab2x2(:,:,805))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(717),n2h1(851))
  call Hloop_AV_Q(ntryL,G1H2(776),ex3(:),G1H1(1),m3h2x1(:,806),heltab2x2(:,:,806))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(718),n2h1(852))
  call Hloop_AV_Q(ntryL,G1H2(935),ex3(:),G1H1(1),m3h2x1(:,807),heltab2x2(:,:,807))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(719),n2h1(853))
  call Hloop_AV_Q(ntryL,G1H2(1115),ex3(:),G1H1(1),m3h2x1(:,808),heltab2x2(:,:,808))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(720),n2h1(854))
  call Hloop_VQ_A(ntryL,G1H2(787),ex1(:),G1H1(1),m3h2x1(:,809),heltab2x2(:,:,809))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(721),n2h1(855))
  call Hloop_VQ_A(ntryL,G1H2(788),ex1(:),G1H1(1),m3h2x1(:,810),heltab2x2(:,:,810))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(722),n2h1(856))
  call Hloop_VQ_A(ntryL,G1H2(794),ex1(:),G1H1(1),m3h2x1(:,811),heltab2x2(:,:,811))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(723),n2h1(857))
  call Hloop_QV_A(ntryL,G1H2(940),ex4(:),G1H1(1),m3h2x1(:,812),heltab2x2(:,:,812))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(724),n2h1(858))
  call Hloop_QV_A(ntryL,G1H2(799),ex4(:),G1H1(1),m3h2x1(:,813),heltab2x2(:,:,813))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(725),n2h1(859))
  call Hloop_QV_A(ntryL,G1H2(805),ex4(:),G1H1(1),m3h2x1(:,814),heltab2x2(:,:,814))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(726),n2h1(860))
  call Hloop_QV_A(ntryL,G1H2(806),ex4(:),G1H1(1),m3h2x1(:,815),heltab2x2(:,:,815))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(727),n2h1(861))
  call Hloop_QV_A(ntryL,G1H2(1130),ex4(:),G1H1(1),m3h2x1(:,816),heltab2x2(:,:,816))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(728),n2h1(862))
  call Hloop_QV_A(ntryL,G1H2(945),ex4(:),G1H1(1),m3h2x1(:,817),heltab2x2(:,:,817))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(729),n2h1(863))
  call Hloop_QV_A(ntryL,G1H2(817),ex3(:),G1H1(1),m3h2x1(:,818),heltab2x2(:,:,818))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(730),n2h1(864))
  call Hloop_QV_A(ntryL,G1H2(818),ex3(:),G1H1(1),m3h2x1(:,819),heltab2x2(:,:,819))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(731),n2h1(865))
  call Hloop_QV_A(ntryL,G1H2(824),ex3(:),G1H1(1),m3h2x1(:,820),heltab2x2(:,:,820))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(732),n2h1(866))
  call Hloop_QV_A(ntryL,G1H2(1140),ex5(:),G1H1(1),m3h2x1(:,821),heltab2x2(:,:,821))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(733),n2h1(867))
  call Hloop_QV_A(ntryL,G1H2(829),ex5(:),G1H1(1),m3h2x1(:,822),heltab2x2(:,:,822))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(734),n2h1(868))
  call Hloop_QV_A(ntryL,G1H2(836),ex5(:),G1H1(1),m3h2x1(:,823),heltab2x2(:,:,823))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(735),n2h1(869))
  call Hloop_QV_A(ntryL,G1H2(841),ex3(:),G1H1(1),m3h2x1(:,824),heltab2x2(:,:,824))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(736),n2h1(870))
  call Hloop_QV_A(ntryL,G1H2(846),ex3(:),G1H1(1),m3h2x1(:,825),heltab2x2(:,:,825))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(737),n2h1(871))
  call Hloop_QV_A(ntryL,G1H2(861),ex3(:),G1H1(1),m3h2x1(:,826),heltab2x2(:,:,826))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(738),n2h1(872))
  call Hloop_AV_Q(ntryL,G1H2(866),ex3(:),G1H1(1),m3h2x1(:,827),heltab2x2(:,:,827))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(739),n2h1(873))
  call Hloop_AV_Q(ntryL,G1H2(871),ex3(:),G1H1(1),m3h2x1(:,828),heltab2x2(:,:,828))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(740),n2h1(874))
  call Hloop_AV_Q(ntryL,G1H2(886),ex3(:),G1H1(1),m3h2x1(:,829),heltab2x2(:,:,829))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(741),n2h1(875))
  call Hloop_AV_Q(ntryL,G1H2(891),ex4(:),G1H1(1),m3h2x1(:,830),heltab2x2(:,:,830))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(742),n2h1(876))
  call Hloop_AV_Q(ntryL,G1H2(896),ex4(:),G1H1(1),m3h2x1(:,831),heltab2x2(:,:,831))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(743),n2h1(877))
  call Hloop_AV_Q(ntryL,G1H2(911),ex4(:),G1H1(1),m3h2x1(:,832),heltab2x2(:,:,832))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(744),n2h1(878))
  call Hloop_AV_Q(ntryL,G1H2(916),ex4(:),G1H1(1),m3h2x1(:,833),heltab2x2(:,:,833))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(745),n2h1(879))
  call Hloop_AV_Q(ntryL,G1H2(921),ex4(:),G1H1(1),m3h2x1(:,834),heltab2x2(:,:,834))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(746),n2h1(880))
  call Hloop_AV_Q(ntryL,G1H2(936),ex4(:),G1H1(1),m3h2x1(:,835),heltab2x2(:,:,835))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(747),n2h1(881))
  call Hloop_AV_Q(ntryL,G1H2(941),ex3(:),G1H1(1),m3h2x1(:,836),heltab2x2(:,:,836))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(748),n2h1(882))
  call Hloop_AV_Q(ntryL,G1H2(946),ex3(:),G1H1(1),m3h2x1(:,837),heltab2x2(:,:,837))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(749),n2h1(883))
  call Hloop_AV_Q(ntryL,G1H2(961),ex3(:),G1H1(1),m3h2x1(:,838),heltab2x2(:,:,838))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(750),n2h1(884))
  call Hloop_AV_Q(ntryL,G1H2(966),ex5(:),G1H1(1),m3h2x1(:,839),heltab2x2(:,:,839))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(751),n2h1(885))
  call Hloop_AV_Q(ntryL,G1H2(971),ex5(:),G1H1(1),m3h2x1(:,840),heltab2x2(:,:,840))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(752),n2h1(886))
  call Hloop_AV_Q(ntryL,G1H2(986),ex5(:),G1H1(1),m3h2x1(:,841),heltab2x2(:,:,841))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(753),n2h1(887))
  call Hloop_AV_Q(ntryL,G1H2(991),ex3(:),G1H1(1),m3h2x1(:,842),heltab2x2(:,:,842))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(754),n2h1(888))
  call Hloop_AV_Q(ntryL,G1H2(996),ex3(:),G1H1(1),m3h2x1(:,843),heltab2x2(:,:,843))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(755),n2h1(889))
  call Hloop_AV_Q(ntryL,G1H2(1011),ex3(:),G1H1(1),m3h2x1(:,844),heltab2x2(:,:,844))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(756),n2h1(890))
  call Hloop_VA_Q(ntryL,G1H2(1016),ex2(:),G1H1(1),m3h2x1(:,845),heltab2x2(:,:,845))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(757),n2h1(891))
  call Hloop_VA_Q(ntryL,G1H2(1021),ex2(:),G1H1(1),m3h2x1(:,846),heltab2x2(:,:,846))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(758),n2h1(892))
  call Hloop_VA_Q(ntryL,G1H2(1036),ex2(:),G1H1(1),m3h2x1(:,847),heltab2x2(:,:,847))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(759),n2h1(893))
  call Hloop_VQ_A(ntryL,G1H2(1041),ex1(:),G1H1(1),m3h2x1(:,848),heltab2x2(:,:,848))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(760),n2h1(894))
  call Hloop_VQ_A(ntryL,G1H2(1046),ex1(:),G1H1(1),m3h2x1(:,849),heltab2x2(:,:,849))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(761),n2h1(895))
  call Hloop_VQ_A(ntryL,G1H2(1061),ex1(:),G1H1(1),m3h2x1(:,850),heltab2x2(:,:,850))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(762),n2h1(896))
  call Hloop_VQ_A(ntryL,G1H2(1066),ex1(:),G1H1(1),m3h2x1(:,851),heltab2x2(:,:,851))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(763),n2h1(897))
  call Hloop_VQ_A(ntryL,G1H2(1071),ex1(:),G1H1(1),m3h2x1(:,852),heltab2x2(:,:,852))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(764),n2h1(898))
  call Hloop_VQ_A(ntryL,G1H2(1086),ex1(:),G1H1(1),m3h2x1(:,853),heltab2x2(:,:,853))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(765),n2h1(899))
  call Hloop_VQ_A(ntryL,G1H2(1091),ex1(:),G1H1(1),m3h2x1(:,854),heltab2x2(:,:,854))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(766),n2h1(900))
  call Hloop_VQ_A(ntryL,G1H2(1096),ex1(:),G1H1(1),m3h2x1(:,855),heltab2x2(:,:,855))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(767),n2h1(901))
  call Hloop_VQ_A(ntryL,G1H2(1111),ex1(:),G1H1(1),m3h2x1(:,856),heltab2x2(:,:,856))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(768),n2h1(902))
  call Hloop_VA_Q(ntryL,G1H2(1116),ex2(:),G1H1(1),m3h2x1(:,857),heltab2x2(:,:,857))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(769),n2h1(903))
  call Hloop_VA_Q(ntryL,G1H2(1121),ex2(:),G1H1(1),m3h2x1(:,858),heltab2x2(:,:,858))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(770),n2h1(904))
  call Hloop_VA_Q(ntryL,G1H2(1136),ex2(:),G1H1(1),m3h2x1(:,859),heltab2x2(:,:,859))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(771),n2h1(905))
  call Hloop_VA_Q(ntryL,G1H2(1141),ex2(:),G1H1(1),m3h2x1(:,860),heltab2x2(:,:,860))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(772),n2h1(906))
  call Hloop_VA_Q(ntryL,G1H2(134),ex2(:),G1H1(1),m3h2x1(:,861),heltab2x2(:,:,861))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(773),n2h1(907))
  call Hloop_VA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,862),heltab2x2(:,:,862))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(774),n2h1(908))
  call Hloop_QV_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,863),heltab2x2(:,:,863))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(775),n2h1(909))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,864),heltab2x2(:,:,864))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(776),n2h1(910))
  call Hloop_QV_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,865),heltab2x2(:,:,865))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(777),n2h1(911))
  call Hloop_AV_Q(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,866),heltab2x2(:,:,866))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(778),n2h1(912))
  call Hloop_AV_Q(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,867),heltab2x2(:,:,867))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(779),n2h1(913))
  call Hloop_AV_Q(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,868),heltab2x2(:,:,868))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(780),n2h1(914))
  call Hloop_AV_Q(ntryL,G1H2(160),ex5(:),G1H1(1),m3h2x1(:,869),heltab2x2(:,:,869))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(781),n2h1(915))
  call Hloop_AV_Q(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,870),heltab2x2(:,:,870))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(782),n2h1(916))
  call Hloop_AV_Q(ntryL,G1H2(204),ex5(:),G1H1(1),m3h2x1(:,871),heltab2x2(:,:,871))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(783),n2h1(917))
  call Hloop_QV_A(ntryL,G1H2(210),ex4(:),G1H1(1),m3h2x1(:,872),heltab2x2(:,:,872))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(784),n2h1(918))
  call Hloop_QV_A(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,873),heltab2x2(:,:,873))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(785),n2h1(919))
  call Hloop_QV_A(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,874),heltab2x2(:,:,874))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(786),n2h1(920))
  call Hloop_QV_A(ntryL,G1H2(270),ex4(:),G1H1(1),m3h2x1(:,875),heltab2x2(:,:,875))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(787),n2h1(921))
  call Hloop_QV_A(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,876),heltab2x2(:,:,876))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(788),n2h1(922))
  call Hloop_QV_A(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,877),heltab2x2(:,:,877))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(789),n2h1(923))
  call Hloop_QV_A(ntryL,G1H2(325),ex5(:),G1H1(1),m3h2x1(:,878),heltab2x2(:,:,878))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(790),n2h1(924))
  call Hloop_QV_A(ntryL,G1H2(331),ex5(:),G1H1(1),m3h2x1(:,879),heltab2x2(:,:,879))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(791),n2h1(925))
  call Hloop_QV_A(ntryL,G1H2(369),ex5(:),G1H1(1),m3h2x1(:,880),heltab2x2(:,:,880))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(792),n2h1(926))
  call Hloop_QV_A(ntryL,G1H2(375),ex5(:),G1H1(1),m3h2x1(:,881),heltab2x2(:,:,881))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(793),n2h1(927))
  call Hloop_QV_A(ntryL,G1H2(391),ex5(:),G1H1(1),m3h2x1(:,882),heltab2x2(:,:,882))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(794),n2h1(928))
  call Hloop_QV_A(ntryL,G1H2(424),ex5(:),G1H1(1),m3h2x1(:,883),heltab2x2(:,:,883))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(795),n2h1(929))
  call Hloop_AV_Q(ntryL,G1H2(430),ex3(:),G1H1(1),m3h2x1(:,884),heltab2x2(:,:,884))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(796),n2h1(930))
  call Hloop_AV_Q(ntryL,G1H2(446),ex3(:),G1H1(1),m3h2x1(:,885),heltab2x2(:,:,885))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(797),n2h1(931))
  call Hloop_AV_Q(ntryL,G1H2(474),ex3(:),G1H1(1),m3h2x1(:,886),heltab2x2(:,:,886))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(798),n2h1(932))
  call Hloop_QV_A(ntryL,G1H2(480),ex4(:),G1H1(1),m3h2x1(:,887),heltab2x2(:,:,887))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(799),n2h1(933))
  call Hloop_QV_A(ntryL,G1H2(486),ex4(:),G1H1(1),m3h2x1(:,888),heltab2x2(:,:,888))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(800),n2h1(934))
  call Hloop_QV_A(ntryL,G1H2(504),ex4(:),G1H1(1),m3h2x1(:,889),heltab2x2(:,:,889))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(801),n2h1(935))
  call Hloop_QV_A(ntryL,G1H2(510),ex3(:),G1H1(1),m3h2x1(:,890),heltab2x2(:,:,890))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(802),n2h1(936))
  call Hloop_QV_A(ntryL,G1H2(516),ex3(:),G1H1(1),m3h2x1(:,891),heltab2x2(:,:,891))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(803),n2h1(937))
  call Hloop_QV_A(ntryL,G1H2(534),ex3(:),G1H1(1),m3h2x1(:,892),heltab2x2(:,:,892))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(804),n2h1(938))
  call Hloop_QV_A(ntryL,G1H2(540),ex3(:),G1H1(1),m3h2x1(:,893),heltab2x2(:,:,893))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(805),n2h1(939))
  call Hloop_QV_A(ntryL,G1H2(546),ex3(:),G1H1(1),m3h2x1(:,894),heltab2x2(:,:,894))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(806),n2h1(940))
  call Hloop_QV_A(ntryL,G1H2(564),ex3(:),G1H1(1),m3h2x1(:,895),heltab2x2(:,:,895))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(807),n2h1(941))
  call Hloop_QV_A(ntryL,G1H2(570),ex5(:),G1H1(1),m3h2x1(:,896),heltab2x2(:,:,896))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(808),n2h1(942))
  call Hloop_QV_A(ntryL,G1H2(576),ex5(:),G1H1(1),m3h2x1(:,897),heltab2x2(:,:,897))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(809),n2h1(943))
  call Hloop_QV_A(ntryL,G1H2(594),ex5(:),G1H1(1),m3h2x1(:,898),heltab2x2(:,:,898))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(810),n2h1(944))
  call Hloop_QV_A(ntryL,G1H2(600),ex5(:),G1H1(1),m3h2x1(:,899),heltab2x2(:,:,899))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(811),n2h1(945))
  call Hloop_QV_A(ntryL,G1H2(606),ex5(:),G1H1(1),m3h2x1(:,900),heltab2x2(:,:,900))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(812),n2h1(946))
  call Hloop_QV_A(ntryL,G1H2(624),ex5(:),G1H1(1),m3h2x1(:,901),heltab2x2(:,:,901))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(813),n2h1(947))
  call Hloop_QV_A(ntryL,G1H2(630),ex5(:),G1H1(1),m3h2x1(:,902),heltab2x2(:,:,902))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(814),n2h1(948))
  call Hloop_QV_A(ntryL,G1H2(636),ex5(:),G1H1(1),m3h2x1(:,903),heltab2x2(:,:,903))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(815),n2h1(949))
  call Hloop_QV_A(ntryL,G1H2(654),ex5(:),G1H1(1),m3h2x1(:,904),heltab2x2(:,:,904))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(816),n2h1(950))
  call Hloop_QV_A(ntryL,G1H2(660),ex3(:),G1H1(1),m3h2x1(:,905),heltab2x2(:,:,905))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(817),n2h1(951))
  call Hloop_QV_A(ntryL,G1H2(666),ex3(:),G1H1(1),m3h2x1(:,906),heltab2x2(:,:,906))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(818),n2h1(952))
  call Hloop_QV_A(ntryL,G1H2(684),ex3(:),G1H1(1),m3h2x1(:,907),heltab2x2(:,:,907))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(819),n2h1(953))
  call Hloop_QV_A(ntryL,G1H2(690),ex3(:),G1H1(1),m3h2x1(:,908),heltab2x2(:,:,908))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(820),n2h1(954))
  call Hloop_QV_A(ntryL,G1H2(696),ex3(:),G1H1(1),m3h2x1(:,909),heltab2x2(:,:,909))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(821),n2h1(955))
  call Hloop_QV_A(ntryL,G1H2(714),ex3(:),G1H1(1),m3h2x1(:,910),heltab2x2(:,:,910))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(822),n2h1(956))
  call Hloop_QV_A(ntryL,G1H2(720),ex4(:),G1H1(1),m3h2x1(:,911),heltab2x2(:,:,911))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(823),n2h1(957))
  call Hloop_QV_A(ntryL,G1H2(726),ex4(:),G1H1(1),m3h2x1(:,912),heltab2x2(:,:,912))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(824),n2h1(958))
  call Hloop_QV_A(ntryL,G1H2(744),ex4(:),G1H1(1),m3h2x1(:,913),heltab2x2(:,:,913))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(825),n2h1(959))
  call Hloop_QV_A(ntryL,G1H2(750),ex4(:),G1H1(1),m3h2x1(:,914),heltab2x2(:,:,914))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(826),n2h1(960))
  call Hloop_QV_A(ntryL,G1H2(756),ex4(:),G1H1(1),m3h2x1(:,915),heltab2x2(:,:,915))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(827),n2h1(961))
  call Hloop_QV_A(ntryL,G1H2(774),ex4(:),G1H1(1),m3h2x1(:,916),heltab2x2(:,:,916))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(828),n2h1(962))
  call Hloop_AV_Q(ntryL,G1H2(780),ex4(:),G1H1(1),m3h2x1(:,917),heltab2x2(:,:,917))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(829),n2h1(963))
  call Hloop_AV_Q(ntryL,G1H2(786),ex4(:),G1H1(1),m3h2x1(:,918),heltab2x2(:,:,918))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(830),n2h1(964))
  call Hloop_AV_Q(ntryL,G1H2(804),ex4(:),G1H1(1),m3h2x1(:,919),heltab2x2(:,:,919))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(831),n2h1(965))
  call Hloop_AV_Q(ntryL,G1H2(810),ex4(:),G1H1(1),m3h2x1(:,920),heltab2x2(:,:,920))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(832),n2h1(966))
  call Hloop_AV_Q(ntryL,G1H2(816),ex4(:),G1H1(1),m3h2x1(:,921),heltab2x2(:,:,921))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(833),n2h1(967))
  call Hloop_AV_Q(ntryL,G1H2(834),ex4(:),G1H1(1),m3h2x1(:,922),heltab2x2(:,:,922))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(834),n2h1(968))
  call Hloop_AV_Q(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,923),heltab2x2(:,:,923))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(835),n2h1(969))
  call Hloop_AV_Q(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,924),heltab2x2(:,:,924))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(836),n2h1(970))
  call Hloop_AV_Q(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,925),heltab2x2(:,:,925))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(837),n2h1(971))
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,926),heltab2x2(:,:,926))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(838),n2h1(972))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,927),heltab2x2(:,:,927))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(839),n2h1(973))
  call Hloop_AV_Q(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,928),heltab2x2(:,:,928))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(840),n2h1(974))
  call Hloop_AV_Q(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,929),heltab2x2(:,:,929))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(841),n2h1(975))
  call Hloop_AV_Q(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,930),heltab2x2(:,:,930))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(842),n2h1(976))
  call Hloop_AV_Q(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,931),heltab2x2(:,:,931))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(843),n2h1(977))
  call Hloop_AV_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,932),heltab2x2(:,:,932))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(844),n2h1(978))
  call Hloop_AV_Q(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,933),heltab2x2(:,:,933))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(845),n2h1(979))
  call Hloop_AV_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,934),heltab2x2(:,:,934))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(846),n2h1(980))
  call Hloop_AV_Q(ntryL,G1H2(467),ex5(:),G1H1(1),m3h2x1(:,935),heltab2x2(:,:,935))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(847),n2h1(981))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,936),heltab2x2(:,:,936))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(848),n2h1(982))
  call Hloop_AV_Q(ntryL,G1H2(473),ex5(:),G1H1(1),m3h2x1(:,937),heltab2x2(:,:,937))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(849),n2h1(983))
  call Hloop_AV_Q(ntryL,G1H2(253),ex5(:),G1H1(1),m3h2x1(:,938),heltab2x2(:,:,938))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(850),n2h1(984))
  call Hloop_AV_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,939),heltab2x2(:,:,939))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(851),n2h1(985))
  call Hloop_AV_Q(ntryL,G1H2(569),ex5(:),G1H1(1),m3h2x1(:,940),heltab2x2(:,:,940))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(852),n2h1(986))
  call Hloop_AV_Q(ntryL,G1H2(485),ex3(:),G1H1(1),m3h2x1(:,941),heltab2x2(:,:,941))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(853),n2h1(987))
  call Hloop_AV_Q(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,942),heltab2x2(:,:,942))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(854),n2h1(988))
  call Hloop_AV_Q(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,943),heltab2x2(:,:,943))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(855),n2h1(989))
  call Hloop_AV_Q(ntryL,G1H2(497),ex3(:),G1H1(1),m3h2x1(:,944),heltab2x2(:,:,944))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(856),n2h1(990))
  call Hloop_AV_Q(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,945),heltab2x2(:,:,945))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(857),n2h1(991))
  call Hloop_AV_Q(ntryL,G1H2(330),ex3(:),G1H1(1),m3h2x1(:,946),heltab2x2(:,:,946))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(858),n2h1(992))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,947),heltab2x2(:,:,947))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(859),n2h1(993))
  call Hloop_AV_Q(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,948),heltab2x2(:,:,948))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(860),n2h1(994))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,949),heltab2x2(:,:,949))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(861),n2h1(995))
  call Hloop_AV_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,950),heltab2x2(:,:,950))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(862),n2h1(996))
  call Hloop_AV_Q(ntryL,G1H2(557),ex4(:),G1H1(1),m3h2x1(:,951),heltab2x2(:,:,951))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(863),n2h1(997))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,952),heltab2x2(:,:,952))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(864),n2h1(998))
  call Hloop_VQ_A(ntryL,G1H4(324),wf4(:,3),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,713))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(865),n2h1(999))
  call Hloop_VQ_A(ntryL,G1H4(327),wf4(:,3),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,714))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nME,G2tensor(866),n2h1(1000))
  call Hloop_VQ_A(ntryL,G1H4(22),wf4(:,3),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,715))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(867),n2h1(1001))
  call Hloop_VA_Q(ntryL,G1H4(330),wf4(:,12),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,716))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(868),n2h1(1002))
  call Hloop_VA_Q(ntryL,G1H4(331),wf4(:,12),G1H1(1),m3h4x1(:,75),heltab2x4(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nME,G2tensor(869),n2h1(1003))
  call Hloop_VA_Q(ntryL,G1H4(334),wf4(:,12),G1H1(1),m3h4x1(:,76),heltab2x4(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(870),n2h1(1004))
  call Hloop_VQ_A(ntryL,G1H4(335),wf4(:,11),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,719))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(871),n2h1(1005))
  call Hloop_VQ_A(ntryL,G1H4(336),wf4(:,11),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,720))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(872),n2h1(1006))
  call Hloop_VQ_A(ntryL,G1H4(341),wf4(:,11),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,721))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(873),n2h1(1007))
  call Hloop_VA_Q(ntryL,G1H4(33),wf4(:,4),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,722))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(874),n2h1(1008))
  call Hloop_VA_Q(ntryL,G1H4(34),wf4(:,4),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,723))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(875),n2h1(1009))
  call Hloop_VA_Q(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,724))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(876),n2h1(1010))
  call Hloop_VQ_A(ntryL,G1H4(58),wf4(:,14),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,725))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(877),n2h1(1011))
  call Hloop_VQ_A(ntryL,G1H4(346),wf4(:,14),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,726))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(878),n2h1(1012))
  call Hloop_VQ_A(ntryL,G1H4(59),wf4(:,14),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,727))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(879),n2h1(1013))
  call Hloop_VA_Q(ntryL,G1H4(350),wf4(:,6),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(880),n2h1(1014))
  call Hloop_VA_Q(ntryL,G1H4(351),wf4(:,6),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,729))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(881),n2h1(1015))
  call Hloop_VA_Q(ntryL,G1H4(356),wf4(:,6),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,730))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(882),n2h1(1016))
  call Hloop_AV_Q(ntryL,G1H2(521),ex5(:),G1H1(1),m3h2x1(:,953),heltab2x2(:,:,953))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(883),n2h1(1017))
  call Hloop_AV_Q(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,954),heltab2x2(:,:,954))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(884),n2h1(1018))
  call Hloop_AV_Q(ntryL,G1H2(275),ex5(:),G1H1(1),m3h2x1(:,955),heltab2x2(:,:,955))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(885),n2h1(1019))
  call Hloop_AV_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,956),heltab2x2(:,:,956))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(886),n2h1(1020))
  call Hloop_AV_Q(ntryL,G1H2(533),ex5(:),G1H1(1),m3h2x1(:,957),heltab2x2(:,:,957))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(887),n2h1(1021))
  call Hloop_AV_Q(ntryL,G1H2(95),ex5(:),G1H1(1),m3h2x1(:,958),heltab2x2(:,:,958))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(888),n2h1(1022))
  call Hloop_QV_A(ntryL,G1H2(581),ex4(:),G1H1(1),m3h2x1(:,959),heltab2x2(:,:,959))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(889),n2h1(1023))
  call Hloop_QV_A(ntryL,G1H2(545),ex4(:),G1H1(1),m3h2x1(:,960),heltab2x2(:,:,960))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(890),n2h1(1024))
  call Hloop_QV_A(ntryL,G1H2(225),ex4(:),G1H1(1),m3h2x1(:,961),heltab2x2(:,:,961))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(891),n2h1(1025))
  call Hloop_QV_A(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,962),heltab2x2(:,:,962))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(892),n2h1(1026))
  call Hloop_QV_A(ntryL,G1H2(551),ex4(:),G1H1(1),m3h2x1(:,963),heltab2x2(:,:,963))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(893),n2h1(1027))
  call Hloop_QV_A(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,964),heltab2x2(:,:,964))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(894),n2h1(1028))
  call Hloop_QV_A(ntryL,G1H2(563),ex5(:),G1H1(1),m3h2x1(:,965),heltab2x2(:,:,965))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(895),n2h1(1029))
  call Hloop_QV_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,966),heltab2x2(:,:,966))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(896),n2h1(1030))
  call Hloop_QV_A(ntryL,G1H2(575),ex5(:),G1H1(1),m3h2x1(:,967),heltab2x2(:,:,967))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(897),n2h1(1031))
  call Hloop_QV_A(ntryL,G1H2(186),ex5(:),G1H1(1),m3h2x1(:,968),heltab2x2(:,:,968))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(898),n2h1(1032))
  call Hloop_QV_A(ntryL,G1H2(647),ex5(:),G1H1(1),m3h2x1(:,969),heltab2x2(:,:,969))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(899),n2h1(1033))
  call Hloop_QV_A(ntryL,G1H2(653),ex5(:),G1H1(1),m3h2x1(:,970),heltab2x2(:,:,970))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(900),n2h1(1034))
  call Hloop_AV_Q(ntryL,G1H2(593),ex4(:),G1H1(1),m3h2x1(:,971),heltab2x2(:,:,971))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(901),n2h1(1035))
  call Hloop_AV_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,972),heltab2x2(:,:,972))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(902),n2h1(1036))
  call Hloop_AV_Q(ntryL,G1H2(209),ex4(:),G1H1(1),m3h2x1(:,973),heltab2x2(:,:,973))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(903),n2h1(1037))
  call Hloop_AV_Q(ntryL,G1H2(695),ex4(:),G1H1(1),m3h2x1(:,974),heltab2x2(:,:,974))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(904),n2h1(1038))
  call Hloop_AV_Q(ntryL,G1H2(605),ex4(:),G1H1(1),m3h2x1(:,975),heltab2x2(:,:,975))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(905),n2h1(1039))
  call Hloop_AV_Q(ntryL,G1H2(611),ex4(:),G1H1(1),m3h2x1(:,976),heltab2x2(:,:,976))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(906),n2h1(1040))
  call Hloop_QV_A(ntryL,G1H2(230),ex5(:),G1H1(1),m3h2x1(:,977),heltab2x2(:,:,977))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(907),n2h1(1041))
  call Hloop_QV_A(ntryL,G1H2(707),ex5(:),G1H1(1),m3h2x1(:,978),heltab2x2(:,:,978))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(908),n2h1(1042))
  call Hloop_QV_A(ntryL,G1H2(390),ex5(:),G1H1(1),m3h2x1(:,979),heltab2x2(:,:,979))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(909),n2h1(1043))
  call Hloop_AV_Q(ntryL,G1H2(251),ex5(:),G1H1(1),m3h2x1(:,980),heltab2x2(:,:,980))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(910),n2h1(1044))
  call Hloop_AV_Q(ntryL,G1H2(623),ex5(:),G1H1(1),m3h2x1(:,981),heltab2x2(:,:,981))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(911),n2h1(1045))
  call Hloop_AV_Q(ntryL,G1H2(273),ex5(:),G1H1(1),m3h2x1(:,982),heltab2x2(:,:,982))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(912),n2h1(1046))
  call Hloop_AV_Q(ntryL,G1H2(635),ex4(:),G1H1(1),m3h2x1(:,983),heltab2x2(:,:,983))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(913),n2h1(1047))
  call Hloop_AV_Q(ntryL,G1H2(274),ex4(:),G1H1(1),m3h2x1(:,984),heltab2x2(:,:,984))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(914),n2h1(1048))
  call Hloop_AV_Q(ntryL,G1H2(306),ex4(:),G1H1(1),m3h2x1(:,985),heltab2x2(:,:,985))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(915),n2h1(1049))
  call Hloop_QV_A(ntryL,G1H2(719),ex5(:),G1H1(1),m3h2x1(:,986),heltab2x2(:,:,986))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(916),n2h1(1050))
  call Hloop_QV_A(ntryL,G1H2(671),ex5(:),G1H1(1),m3h2x1(:,987),heltab2x2(:,:,987))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(917),n2h1(1051))
  call Hloop_QV_A(ntryL,G1H2(677),ex5(:),G1H1(1),m3h2x1(:,988),heltab2x2(:,:,988))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(918),n2h1(1052))
  call Hloop_QV_A(ntryL,G1H2(308),ex5(:),G1H1(1),m3h2x1(:,989),heltab2x2(:,:,989))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(919),n2h1(1053))
  call Hloop_QV_A(ntryL,G1H2(357),ex5(:),G1H1(1),m3h2x1(:,990),heltab2x2(:,:,990))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(920),n2h1(1054))
  call Hloop_QV_A(ntryL,G1H2(329),ex5(:),G1H1(1),m3h2x1(:,991),heltab2x2(:,:,991))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(921),n2h1(1055))
  call Hloop_QV_A(ntryL,G1H2(767),ex5(:),G1H1(1),m3h2x1(:,992),heltab2x2(:,:,992))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(922),n2h1(1056))
  call Hloop_QV_A(ntryL,G1H2(731),ex5(:),G1H1(1),m3h2x1(:,993),heltab2x2(:,:,993))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(923),n2h1(1057))
  call Hloop_QV_A(ntryL,G1H2(737),ex5(:),G1H1(1),m3h2x1(:,994),heltab2x2(:,:,994))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(924),n2h1(1058))
  call Hloop_QV_A(ntryL,G1H2(373),ex4(:),G1H1(1),m3h2x1(:,995),heltab2x2(:,:,995))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(925),n2h1(1059))
  call Hloop_QV_A(ntryL,G1H2(779),ex4(:),G1H1(1),m3h2x1(:,996),heltab2x2(:,:,996))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(926),n2h1(1060))
  call Hloop_QV_A(ntryL,G1H2(803),ex4(:),G1H1(1),m3h2x1(:,997),heltab2x2(:,:,997))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(927),n2h1(1061))
  call Hloop_QV_A(ntryL,G1H2(749),ex4(:),G1H1(1),m3h2x1(:,998),heltab2x2(:,:,998))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(928),n2h1(1062))
  call Hloop_QV_A(ntryL,G1H2(394),ex4(:),G1H1(1),m3h2x1(:,999),heltab2x2(:,:,999))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(929),n2h1(1063))
  call Hloop_QV_A(ntryL,G1H2(395),ex4(:),G1H1(1),m3h2x1(:,1000),heltab2x2(:,:,1000))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(930),n2h1(1064))
  call Hloop_QV_A(ntryL,G1H2(815),ex4(:),G1H1(1),m3h2x1(:,1001),heltab2x2(:,:,1001))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(931),n2h1(1065))
  call Hloop_QV_A(ntryL,G1H2(761),ex4(:),G1H1(1),m3h2x1(:,1002),heltab2x2(:,:,1002))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(932),n2h1(1066))
  call Hloop_QV_A(ntryL,G1H2(785),ex4(:),G1H1(1),m3h2x1(:,1003),heltab2x2(:,:,1003))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(933),n2h1(1067))
  call Hloop_AV_Q(ntryL,G1H2(427),ex5(:),G1H1(1),m3h2x1(:,1004),heltab2x2(:,:,1004))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(934),n2h1(1068))
  call Hloop_AV_Q(ntryL,G1H2(827),ex5(:),G1H1(1),m3h2x1(:,1005),heltab2x2(:,:,1005))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(935),n2h1(1069))
  call Hloop_AV_Q(ntryL,G1H2(833),ex5(:),G1H1(1),m3h2x1(:,1006),heltab2x2(:,:,1006))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(936),n2h1(1070))
  call Hloop_QV_A(ntryL,G1H2(797),ex5(:),G1H1(1),m3h2x1(:,1007),heltab2x2(:,:,1007))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(937),n2h1(1071))
  call Hloop_QV_A(ntryL,G1H2(429),ex5(:),G1H1(1),m3h2x1(:,1008),heltab2x2(:,:,1008))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(938),n2h1(1072))
  call Hloop_QV_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,1009),heltab2x2(:,:,1009))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(939),n2h1(1073))
  call Hloop_QV_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,1010),heltab2x2(:,:,1010))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(940),n2h1(1074))
  call Hloop_QV_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,1011),heltab2x2(:,:,1011))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(941),n2h1(1075))
  call Hloop_QV_A(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,1012),heltab2x2(:,:,1012))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(942),n2h1(1076))
  call Hloop_QV_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,1013),heltab2x2(:,:,1013))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(943),n2h1(1077))
  call Hloop_QV_A(ntryL,G1H2(159),ex3(:),G1H1(1),m3h2x1(:,1014),heltab2x2(:,:,1014))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(944),n2h1(1078))
  call Hloop_QV_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,1015),heltab2x2(:,:,1015))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(945),n2h1(1079))
  call Hloop_QV_A(ntryL,G1H2(247),ex3(:),G1H1(1),m3h2x1(:,1016),heltab2x2(:,:,1016))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(946),n2h1(1080))
  call Hloop_QV_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,1017),heltab2x2(:,:,1017))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(947),n2h1(1081))
  call Hloop_QV_A(ntryL,G1H2(489),ex3(:),G1H1(1),m3h2x1(:,1018),heltab2x2(:,:,1018))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(948),n2h1(1082))
  call Hloop_QV_A(ntryL,G1H2(267),ex3(:),G1H1(1),m3h2x1(:,1019),heltab2x2(:,:,1019))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(949),n2h1(1083))
  call Hloop_QV_A(ntryL,G1H2(291),ex3(:),G1H1(1),m3h2x1(:,1020),heltab2x2(:,:,1020))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(950),n2h1(1084))
  call Hloop_QV_A(ntryL,G1H2(322),ex3(:),G1H1(1),m3h2x1(:,1021),heltab2x2(:,:,1021))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(951),n2h1(1085))
  call Hloop_QV_A(ntryL,G1H2(346),ex4(:),G1H1(1),m3h2x1(:,1022),heltab2x2(:,:,1022))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(952),n2h1(1086))
  call Hloop_QV_A(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,1023),heltab2x2(:,:,1023))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(953),n2h1(1087))
  call Hloop_QV_A(ntryL,G1H2(531),ex4(:),G1H1(1),m3h2x1(:,1024),heltab2x2(:,:,1024))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(954),n2h1(1088))
  call Hloop_QV_A(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,1025),heltab2x2(:,:,1025))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(955),n2h1(1089))
  call Hloop_QV_A(ntryL,G1H2(412),ex4(:),G1H1(1),m3h2x1(:,1026),heltab2x2(:,:,1026))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(956),n2h1(1090))
  call Hloop_QV_A(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,1027),heltab2x2(:,:,1027))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(957),n2h1(1091))
  call Hloop_QV_A(ntryL,G1H2(445),ex4(:),G1H1(1),m3h2x1(:,1028),heltab2x2(:,:,1028))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(958),n2h1(1092))
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,1029),heltab2x2(:,:,1029))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(959),n2h1(1093))
  call Hloop_QV_A(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,1030),heltab2x2(:,:,1030))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(960),n2h1(1094))
  call Hloop_QV_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,1031),heltab2x2(:,:,1031))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(961),n2h1(1095))
  call Hloop_QV_A(ntryL,G1H2(96),ex3(:),G1H1(1),m3h2x1(:,1032),heltab2x2(:,:,1032))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(962),n2h1(1096))
  call Hloop_QV_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,1033),heltab2x2(:,:,1033))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(963),n2h1(1097))
  call Hloop_QV_A(ntryL,G1H2(158),ex3(:),G1H1(1),m3h2x1(:,1034),heltab2x2(:,:,1034))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(964),n2h1(1098))
  call Hloop_QV_A(ntryL,G1H2(471),ex3(:),G1H1(1),m3h2x1(:,1035),heltab2x2(:,:,1035))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(965),n2h1(1099))
  call Hloop_QV_A(ntryL,G1H2(202),ex3(:),G1H1(1),m3h2x1(:,1036),heltab2x2(:,:,1036))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(966),n2h1(1100))
  call Hloop_QV_A(ntryL,G1H2(549),ex3(:),G1H1(1),m3h2x1(:,1037),heltab2x2(:,:,1037))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(967),n2h1(1101))
  call Hloop_QV_A(ntryL,G1H2(223),ex3(:),G1H1(1),m3h2x1(:,1038),heltab2x2(:,:,1038))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(968),n2h1(1102))
  call Hloop_QV_A(ntryL,G1H2(246),ex3(:),G1H1(1),m3h2x1(:,1039),heltab2x2(:,:,1039))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(969),n2h1(1103))
  call Hloop_AV_Q(ntryL,G1H2(268),ex5(:),G1H1(1),m3h2x1(:,1040),heltab2x2(:,:,1040))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(970),n2h1(1104))
  call Hloop_AV_Q(ntryL,G1H2(289),ex5(:),G1H1(1),m3h2x1(:,1041),heltab2x2(:,:,1041))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(971),n2h1(1105))
  call Hloop_AV_Q(ntryL,G1H2(300),ex5(:),G1H1(1),m3h2x1(:,1042),heltab2x2(:,:,1042))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(972),n2h1(1106))
  call Hloop_AV_Q(ntryL,G1H2(639),ex5(:),G1H1(1),m3h2x1(:,1043),heltab2x2(:,:,1043))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(973),n2h1(1107))
  call Hloop_AV_Q(ntryL,G1H2(301),ex5(:),G1H1(1),m3h2x1(:,1044),heltab2x2(:,:,1044))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(974),n2h1(1108))
  call Hloop_AV_Q(ntryL,G1H2(344),ex5(:),G1H1(1),m3h2x1(:,1045),heltab2x2(:,:,1045))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(975),n2h1(1109))
  call Hloop_AV_Q(ntryL,G1H2(345),ex4(:),G1H1(1),m3h2x1(:,1046),heltab2x2(:,:,1046))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(976),n2h1(1110))
  call Hloop_AV_Q(ntryL,G1H2(681),ex4(:),G1H1(1),m3h2x1(:,1047),heltab2x2(:,:,1047))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(977),n2h1(1111))
  call Hloop_AV_Q(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,1048),heltab2x2(:,:,1048))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(978),n2h1(1112))
  call Hloop_AV_Q(ntryL,G1H2(366),ex4(:),G1H1(1),m3h2x1(:,1049),heltab2x2(:,:,1049))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(979),n2h1(1113))
  call Hloop_AV_Q(ntryL,G1H2(367),ex4(:),G1H1(1),m3h2x1(:,1050),heltab2x2(:,:,1050))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(980),n2h1(1114))
  call Hloop_AV_Q(ntryL,G1H2(627),ex4(:),G1H1(1),m3h2x1(:,1051),heltab2x2(:,:,1051))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(981),n2h1(1115))
  call Hloop_AV_Q(ntryL,G1H2(389),ex5(:),G1H1(1),m3h2x1(:,1052),heltab2x2(:,:,1052))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(982),n2h1(1116))
  call Hloop_AV_Q(ntryL,G1H2(410),ex5(:),G1H1(1),m3h2x1(:,1053),heltab2x2(:,:,1053))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(983),n2h1(1117))
  call Hloop_AV_Q(ntryL,G1H2(421),ex5(:),G1H1(1),m3h2x1(:,1054),heltab2x2(:,:,1054))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(984),n2h1(1118))
  call Hloop_AV_Q(ntryL,G1H2(567),ex5(:),G1H1(1),m3h2x1(:,1055),heltab2x2(:,:,1055))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(985),n2h1(1119))
  call Hloop_AV_Q(ntryL,G1H2(422),ex5(:),G1H1(1),m3h2x1(:,1056),heltab2x2(:,:,1056))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(986),n2h1(1120))
  call Hloop_AV_Q(ntryL,G1H2(573),ex5(:),G1H1(1),m3h2x1(:,1057),heltab2x2(:,:,1057))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(987),n2h1(1121))
  call Hloop_AV_Q(ntryL,G1H2(454),ex3(:),G1H1(1),m3h2x1(:,1058),heltab2x2(:,:,1058))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(988),n2h1(1122))
  call Hloop_AV_Q(ntryL,G1H2(579),ex3(:),G1H1(1),m3h2x1(:,1059),heltab2x2(:,:,1059))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(989),n2h1(1123))
  call Hloop_AV_Q(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,1060),heltab2x2(:,:,1060))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(990),n2h1(1124))
  call Hloop_AV_Q(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,1061),heltab2x2(:,:,1061))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(991),n2h1(1125))
  call Hloop_AV_Q(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,1062),heltab2x2(:,:,1062))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(992),n2h1(1126))
  call Hloop_AV_Q(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,1063),heltab2x2(:,:,1063))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(993),n2h1(1127))
  call Hloop_AV_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,1064),heltab2x2(:,:,1064))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(994),n2h1(1128))
  call Hloop_AV_Q(ntryL,G1H2(844),ex3(:),G1H1(1),m3h2x1(:,1065),heltab2x2(:,:,1065))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(995),n2h1(1129))
  call Hloop_AV_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,1066),heltab2x2(:,:,1066))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(996),n2h1(1130))
  call Hloop_AV_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,1067),heltab2x2(:,:,1067))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(997),n2h1(1131))
  call Hloop_AV_Q(ntryL,G1H2(849),ex4(:),G1H1(1),m3h2x1(:,1068),heltab2x2(:,:,1068))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(998),n2h1(1132))
  call Hloop_AV_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,1069),heltab2x2(:,:,1069))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(999),n2h1(1133))
  call Hloop_AV_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,1070),heltab2x2(:,:,1070))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1000),n2h1(1134))
  call Hloop_AV_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,1071),heltab2x2(:,:,1071))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(1001),n2h1(1135))
  call Hloop_AV_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,1072),heltab2x2(:,:,1072))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1002),n2h1(1136))
  call Hloop_AV_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,1073),heltab2x2(:,:,1073))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1003),n2h1(1137))
  call Hloop_AV_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,1074),heltab2x2(:,:,1074))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(1004),n2h1(1138))
  call Hloop_AV_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,1075),heltab2x2(:,:,1075))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1005),n2h1(1139))
  call Hloop_AV_Q(ntryL,G1H2(117),ex3(:),G1H1(1),m3h2x1(:,1076),heltab2x2(:,:,1076))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1006),n2h1(1140))
  call Hloop_AV_Q(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,1077),heltab2x2(:,:,1077))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(1007),n2h1(1141))
  call Hloop_AV_Q(ntryL,G1H2(119),ex3(:),G1H1(1),m3h2x1(:,1078),heltab2x2(:,:,1078))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1008),n2h1(1142))
  call Hloop_AV_Q(ntryL,G1H2(152),ex3(:),G1H1(1),m3h2x1(:,1079),heltab2x2(:,:,1079))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1009),n2h1(1143))
  call Hloop_AV_Q(ntryL,G1H2(153),ex3(:),G1H1(1),m3h2x1(:,1080),heltab2x2(:,:,1080))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(1010),n2h1(1144))
  call Hloop_AV_Q(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,1081),heltab2x2(:,:,1081))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1011),n2h1(1145))
  call Hloop_AV_Q(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,1082),heltab2x2(:,:,1082))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1012),n2h1(1146))
  call Hloop_AV_Q(ntryL,G1H2(957),ex3(:),G1H1(1),m3h2x1(:,1083),heltab2x2(:,:,1083))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(1013),n2h1(1147))
  call Hloop_AV_Q(ntryL,G1H2(196),ex3(:),G1H1(1),m3h2x1(:,1084),heltab2x2(:,:,1084))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1014),n2h1(1148))
  call Hloop_VQ_A(ntryL,G1H4(357),wf4(:,11),G1H1(1),m3h4x1(:,89),heltab2x4(:,:,731))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1015),n2h1(1149))
  call Hloop_VQ_A(ntryL,G1H4(69),wf4(:,11),G1H1(1),m3h4x1(:,90),heltab2x4(:,:,732))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(1016),n2h1(1150))
  call Hloop_VQ_A(ntryL,G1H4(360),wf4(:,11),G1H1(1),m3h4x1(:,91),heltab2x4(:,:,733))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1017),n2h1(1151))
  call Hloop_VQ_A(ntryL,G1H4(81),wf4(:,11),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,734))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1018),n2h1(1152))
  call Hloop_VQ_A(ntryL,G1H4(82),wf4(:,11),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,735))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(1019),n2h1(1153))
  call Hloop_VQ_A(ntryL,G1H4(93),wf4(:,11),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,736))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1020),n2h1(1154))
  call Hloop_VA_Q(ntryL,G1H4(94),wf4(:,4),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,737))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1021),n2h1(1155))
  call Hloop_VA_Q(ntryL,G1H4(365),wf4(:,4),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,738))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(1022),n2h1(1156))
  call Hloop_VA_Q(ntryL,G1H4(106),wf4(:,4),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,739))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1023),n2h1(1157))
  call Hloop_VA_Q(ntryL,G1H4(368),wf4(:,4),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,740))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1024),n2h1(1158))
  call Hloop_VA_Q(ntryL,G1H4(369),wf4(:,4),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,741))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(1025),n2h1(1159))
  call Hloop_VA_Q(ntryL,G1H4(374),wf4(:,4),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,742))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1026),n2h1(1160))
  call Hloop_VQ_A(ntryL,G1H4(375),wf4(:,14),G1H1(1),m3h4x1(:,101),heltab2x4(:,:,743))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1027),n2h1(1161))
  call Hloop_VQ_A(ntryL,G1H4(117),wf4(:,14),G1H1(1),m3h4x1(:,102),heltab2x4(:,:,744))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(1028),n2h1(1162))
  call Hloop_VQ_A(ntryL,G1H4(378),wf4(:,14),G1H1(1),m3h4x1(:,103),heltab2x4(:,:,745))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1029),n2h1(1163))
  call Hloop_VQ_A(ntryL,G1H4(379),wf4(:,14),G1H1(1),m3h4x1(:,104),heltab2x4(:,:,746))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1030),n2h1(1164))
  call Hloop_VQ_A(ntryL,G1H4(380),wf4(:,14),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,747))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(1031),n2h1(1165))
  call Hloop_VQ_A(ntryL,G1H4(129),wf4(:,14),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,748))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1032),n2h1(1166))
  call Hloop_VA_Q(ntryL,G1H4(130),wf4(:,6),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,749))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1033),n2h1(1167))
  call Hloop_VA_Q(ntryL,G1H4(386),wf4(:,6),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,750))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(1034),n2h1(1168))
  call Hloop_VA_Q(ntryL,G1H4(142),wf4(:,6),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,751))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1035),n2h1(1169))
  call Hloop_VA_Q(ntryL,G1H4(389),wf4(:,6),G1H1(1),m3h4x1(:,110),heltab2x4(:,:,752))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1036),n2h1(1170))
  call Hloop_VA_Q(ntryL,G1H4(390),wf4(:,6),G1H1(1),m3h4x1(:,111),heltab2x4(:,:,753))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(1037),n2h1(1171))
  call Hloop_VA_Q(ntryL,G1H4(392),wf4(:,6),G1H1(1),m3h4x1(:,112),heltab2x4(:,:,754))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1038),n2h1(1172))
  call Hloop_VQ_A(ntryL,G1H8(101),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1039),n2h1(1173))
  call Hloop_VQ_A(ntryL,G1H8(102),wf8(:,3),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,nME,G2tensor(1040),n2h1(1174))
  call Hloop_VQ_A(ntryL,G1H8(107),wf8(:,3),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1041),n2h1(1175))
  call Hloop_VA_Q(ntryL,G1H8(108),wf8(:,20),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1042),n2h1(1176))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,20),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,nME,G2tensor(1043),n2h1(1177))
  call Hloop_VA_Q(ntryL,G1H8(6),wf8(:,20),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1044),n2h1(1178))
  call Hloop_VQ_A(ntryL,G1H8(7),wf8(:,17),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1045),n2h1(1179))
  call Hloop_VQ_A(ntryL,G1H8(8),wf8(:,17),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(1046),n2h1(1180))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,17),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1047),n2h1(1181))
  call Hloop_VA_Q(ntryL,G1H8(21),wf8(:,6),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1048),n2h1(1182))
  call Hloop_VA_Q(ntryL,G1H8(27),wf8(:,6),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(1049),n2h1(1183))
  call Hloop_VA_Q(ntryL,G1H8(45),wf8(:,6),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1050),n2h1(1184))
  call Hloop_VQ_A(ntryL,G1H8(63),wf8(:,36),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1051),n2h1(1185))
  call Hloop_VQ_A(ntryL,G1H8(69),wf8(:,36),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,nME,G2tensor(1052),n2h1(1186))
  call Hloop_VQ_A(ntryL,G1H8(99),wf8(:,36),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1053),n2h1(1187))
  call Hloop_VQ_A(ntryL,G1H8(105),wf8(:,22),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1054),n2h1(1188))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,22),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(1055),n2h1(1189))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,22),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1056),n2h1(1190))
  call Hloop_VA_Q(ntryL,G1H8(29),wf8(:,32),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1057),n2h1(1191))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,32),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,nME,G2tensor(1058),n2h1(1192))
  call Hloop_VA_Q(ntryL,G1H8(39),wf8(:,32),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1059),n2h1(1193))
  call Hloop_VA_Q(ntryL,G1H8(13),wf8(:,11),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1060),n2h1(1194))
  call Hloop_VA_Q(ntryL,G1H8(32),wf8(:,11),G1H1(1),m3h8x1(:,23),heltab2x8(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(1061),n2h1(1195))
  call Hloop_VA_Q(ntryL,G1H8(14),wf8(:,11),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1062),n2h1(1196))
  call ol_merge_tensors(G2tensor(499),[G2tensor(396),G2tensor(3),G1tensor(578),G1tensor(7)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(51),G2tensor(9),G2tensor(5),G1tensor(158),G1tensor(139),G1tensor(31)])
  call ol_merge_tensors(G2tensor(397),[G2tensor(389),G2tensor(54),G2tensor(11),G1tensor(582),G1tensor(570),G1tensor(162)])
  call ol_merge_tensors(G2tensor(501),[G2tensor(400),G2tensor(19),G1tensor(584),G1tensor(43)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(59),G2tensor(25),G2tensor(21),G1tensor(176),G1tensor(32),G1tensor(67)])
  call ol_merge_tensors(G2tensor(401),[G2tensor(393),G2tensor(62),G2tensor(27),G1tensor(588),G1tensor(576),G1tensor(180)])
  call ol_merge_tensors(G2tensor(503),[G2tensor(380),G2tensor(35),G1tensor(554),G1tensor(79)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(67),G2tensor(41),G2tensor(37),G1tensor(200),G1tensor(62),G1tensor(103)])
  call ol_merge_tensors(G2tensor(385),[G2tensor(381),G2tensor(70),G2tensor(43),G1tensor(564),G1tensor(558),G1tensor(204)])
  call ol_merge_tensors(G2tensor(505),[G2tensor(388),G2tensor(50),G1tensor(566),G1tensor(115)])
  call ol_merge_tensors(G2tensor(507),[G2tensor(392),G2tensor(58),G1tensor(572),G1tensor(8)])
  call ol_merge_tensors(G2tensor(509),[G2tensor(384),G2tensor(66),G1tensor(560),G1tensor(44)])
  call ol_merge_tensors(G2tensor(697),[G2tensor(221),G2tensor(74),G1tensor(218),G1tensor(68),G1tensor(14)])
  call ol_merge_tensors(G2tensor(865),[G2tensor(77),G2tensor(75),G1tensor(260),G1tensor(75)])
  call ol_merge_tensors(G2tensor(1051),[G2tensor(1039),G2tensor(78),G1tensor(264)])
  call ol_merge_tensors(G2tensor(703),[G2tensor(90),G2tensor(82),G1tensor(69),G1tensor(21),G1tensor(13)])
  call ol_merge_tensors(G2tensor(874),[G2tensor(85),G2tensor(83),G1tensor(278),G1tensor(110)])
  call ol_merge_tensors(G2tensor(1060),[G2tensor(1048),G2tensor(94),G2tensor(86),G1tensor(300),G1tensor(282)])
  call ol_merge_tensors(G2tensor(880),[G2tensor(93),G2tensor(91),G1tensor(579),G1tensor(296),G1tensor(134)])
  call ol_merge_tensors(G2tensor(709),[G2tensor(106),G2tensor(98),G1tensor(9),G1tensor(51),G1tensor(74)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(101),G2tensor(99),G1tensor(320),G1tensor(77),G1tensor(24)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(110),G2tensor(102),G1tensor(414),G1tensor(348),G1tensor(324)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(109),G2tensor(107),G1tensor(344),G1tensor(66),G1tensor(15)])
  call ol_merge_tensors(G2tensor(715),[G2tensor(200),G2tensor(114),G1tensor(164),G1tensor(17),G1tensor(49)])
  call ol_merge_tensors(G2tensor(868),[G2tensor(117),G2tensor(115),G1tensor(356),G1tensor(22)])
  call ol_merge_tensors(G2tensor(1057),[G2tensor(1042),G2tensor(118),G1tensor(360)])
  call ol_merge_tensors(G2tensor(721),[G2tensor(142),G2tensor(122),G1tensor(112),G1tensor(27),G1tensor(121)])
  call ol_merge_tensors(G2tensor(871),[G2tensor(125),G2tensor(123),G1tensor(368),G1tensor(35)])
  call ol_merge_tensors(G2tensor(1054),[G2tensor(1045),G2tensor(146),G2tensor(126),G1tensor(426),G1tensor(372)])
  call ol_merge_tensors(G2tensor(727),[G2tensor(134),G2tensor(130),G1tensor(189),G1tensor(183),G1tensor(48),G1tensor(71) &
    ,G1tensor(29)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(137),G2tensor(135),G1tensor(410),G1tensor(124),G1tensor(54)])
  call ol_merge_tensors(G2tensor(877),[G2tensor(145),G2tensor(143),G1tensor(567),G1tensor(422),G1tensor(60)])
  call ol_merge_tensors(G2tensor(733),[G2tensor(154),G2tensor(150),G1tensor(219),G1tensor(207),G1tensor(72),G1tensor(118) &
    ,G1tensor(58)])
  call ol_merge_tensors(G2tensor(739),[G2tensor(166),G2tensor(158),G1tensor(90),G1tensor(83),G1tensor(36)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(161),G2tensor(159),G1tensor(476),G1tensor(107),G1tensor(89)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(170),G2tensor(162),G1tensor(528),G1tensor(498),G1tensor(480)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(169),G2tensor(167),G1tensor(494),G1tensor(131),G1tensor(136)])
  call ol_merge_tensors(G2tensor(745),[G2tensor(178),G2tensor(174),G1tensor(237),G1tensor(231),G1tensor(113),G1tensor(101) &
    ,G1tensor(98)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(181),G2tensor(179),G1tensor(524),G1tensor(143),G1tensor(119)])
  call ol_merge_tensors(G2tensor(751),[G2tensor(190),G2tensor(186),G1tensor(165),G1tensor(147),G1tensor(132),G1tensor(120) &
    ,G1tensor(122)])
  call ol_merge_tensors(G2tensor(757),[G2tensor(194),G1tensor(146),G1tensor(55),G1tensor(19)])
  call ol_merge_tensors(G2tensor(1033),[G2tensor(195),G1tensor(586),G1tensor(580),G1tensor(150)])
  call ol_merge_tensors(G2tensor(661),[G2tensor(197),G1tensor(152),G1tensor(25)])
  call ol_merge_tensors(G2tensor(691),[G2tensor(198),G1tensor(581),G1tensor(156)])
  call ol_merge_tensors(G2tensor(1036),[G2tensor(201),G1tensor(585),G1tensor(168)])
  call ol_merge_tensors(G2tensor(664),[G2tensor(203),G1tensor(170),G1tensor(61)])
  call ol_merge_tensors(G2tensor(694),[G2tensor(204),G1tensor(587),G1tensor(174)])
  call ol_merge_tensors(G2tensor(760),[G2tensor(206),G1tensor(182),G1tensor(85)])
  call ol_merge_tensors(G2tensor(1015),[G2tensor(207),G1tensor(555),G1tensor(186)])
  call ol_merge_tensors(G2tensor(763),[G2tensor(209),G1tensor(188),G1tensor(91)])
  call ol_merge_tensors(G2tensor(1018),[G2tensor(210),G1tensor(556),G1tensor(192)])
  call ol_merge_tensors(G2tensor(667),[G2tensor(212),G1tensor(194),G1tensor(97)])
  call ol_merge_tensors(G2tensor(679),[G2tensor(213),G1tensor(557),G1tensor(198)])
  call ol_merge_tensors(G2tensor(766),[G2tensor(215),G1tensor(206),G1tensor(20),G1tensor(127)])
  call ol_merge_tensors(G2tensor(1027),[G2tensor(216),G1tensor(574),G1tensor(568),G1tensor(210)])
  call ol_merge_tensors(G2tensor(670),[G2tensor(218),G1tensor(212),G1tensor(133)])
  call ol_merge_tensors(G2tensor(685),[G2tensor(219),G1tensor(569),G1tensor(216)])
  call ol_merge_tensors(G2tensor(1030),[G2tensor(222),G1tensor(573),G1tensor(222)])
  call ol_merge_tensors(G2tensor(673),[G2tensor(224),G1tensor(224),G1tensor(26)])
  call ol_merge_tensors(G2tensor(688),[G2tensor(225),G1tensor(575),G1tensor(228)])
  call ol_merge_tensors(G2tensor(769),[G2tensor(227),G1tensor(230),G1tensor(50)])
  call ol_merge_tensors(G2tensor(1021),[G2tensor(228),G1tensor(561),G1tensor(234)])
  call ol_merge_tensors(G2tensor(772),[G2tensor(230),G1tensor(236),G1tensor(3)])
  call ol_merge_tensors(G2tensor(1024),[G2tensor(231),G1tensor(562),G1tensor(240)])
  call ol_merge_tensors(G2tensor(676),[G2tensor(233),G1tensor(242),G1tensor(56)])
  call ol_merge_tensors(G2tensor(682),[G2tensor(234),G1tensor(563),G1tensor(246)])
  call ol_merge_tensors(G2tensor(775),[G2tensor(236),G1tensor(248),G1tensor(80)])
  call ol_merge_tensors(G2tensor(237),[G1tensor(252)])
  call ol_merge_tensors(G2tensor(718),[G2tensor(700),G2tensor(275),G2tensor(239),G1tensor(254),G1tensor(28),G1tensor(86)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(240),G1tensor(258)])
  call ol_merge_tensors(G2tensor(778),[G2tensor(242),G1tensor(266),G1tensor(104)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(243),G1tensor(288),G1tensor(270)])
  call ol_merge_tensors(G2tensor(724),[G2tensor(706),G2tensor(281),G2tensor(245),G1tensor(272),G1tensor(34),G1tensor(93)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(282),G2tensor(252),G2tensor(246),G1tensor(294),G1tensor(276)])
  call ol_merge_tensors(G2tensor(781),[G2tensor(248),G1tensor(284),G1tensor(153),G1tensor(128)])
  call ol_merge_tensors(G2tensor(547),[G2tensor(523),G2tensor(305),G2tensor(251),G1tensor(290),G1tensor(159),G1tensor(84) &
    ,G1tensor(45)])
  call ol_merge_tensors(G2tensor(784),[G2tensor(254),G1tensor(302),G1tensor(10)])
  call ol_merge_tensors(G2tensor(264),[G2tensor(255),G1tensor(330),G1tensor(306)])
  call ol_merge_tensors(G2tensor(832),[G2tensor(787),G2tensor(329),G2tensor(257),G1tensor(308),G1tensor(130),G1tensor(4)])
  call ol_merge_tensors(G2tensor(339),[G2tensor(330),G2tensor(267),G2tensor(258),G1tensor(336),G1tensor(312)])
  call ol_merge_tensors(G2tensor(712),[G2tensor(260),G1tensor(314),G1tensor(5)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(261),G1tensor(342),G1tensor(318)])
  call ol_merge_tensors(G2tensor(790),[G2tensor(263),G1tensor(326),G1tensor(249),G1tensor(11)])
  call ol_merge_tensors(G2tensor(838),[G2tensor(793),G2tensor(338),G2tensor(266),G1tensor(332),G1tensor(255),G1tensor(96) &
    ,G1tensor(30)])
  call ol_merge_tensors(G2tensor(571),[G2tensor(269),G1tensor(338),G1tensor(261),G1tensor(12)])
  call ol_merge_tensors(G2tensor(796),[G2tensor(272),G1tensor(350),G1tensor(18)])
  call ol_merge_tensors(G2tensor(273),[G1tensor(354)])
  call ol_merge_tensors(G2tensor(799),[G2tensor(278),G1tensor(362),G1tensor(33)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(279),G1tensor(420),G1tensor(366)])
  call ol_merge_tensors(G2tensor(802),[G2tensor(284),G1tensor(374),G1tensor(41)])
  call ol_merge_tensors(G2tensor(294),[G2tensor(285),G1tensor(396),G1tensor(378)])
  call ol_merge_tensors(G2tensor(844),[G2tensor(805),G2tensor(347),G2tensor(287),G1tensor(380),G1tensor(142),G1tensor(42)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(348),G2tensor(297),G2tensor(288),G1tensor(402),G1tensor(384)])
  call ol_merge_tensors(G2tensor(730),[G2tensor(290),G1tensor(386),G1tensor(46)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(291),G1tensor(408),G1tensor(390)])
  call ol_merge_tensors(G2tensor(808),[G2tensor(293),G1tensor(392),G1tensor(363),G1tensor(52)])
  call ol_merge_tensors(G2tensor(850),[G2tensor(811),G2tensor(356),G2tensor(296),G1tensor(398),G1tensor(273),G1tensor(114) &
    ,G1tensor(95)])
  call ol_merge_tensors(G2tensor(613),[G2tensor(299),G1tensor(404),G1tensor(369),G1tensor(53)])
  call ol_merge_tensors(G2tensor(814),[G2tensor(302),G1tensor(416),G1tensor(213),G1tensor(59)])
  call ol_merge_tensors(G2tensor(817),[G2tensor(308),G1tensor(428),G1tensor(64)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(309),G1tensor(450),G1tensor(432)])
  call ol_merge_tensors(G2tensor(856),[G2tensor(820),G2tensor(365),G2tensor(311),G1tensor(434),G1tensor(125),G1tensor(65)])
  call ol_merge_tensors(G2tensor(375),[G2tensor(366),G2tensor(321),G2tensor(312),G1tensor(456),G1tensor(438)])
  call ol_merge_tensors(G2tensor(736),[G2tensor(314),G1tensor(440),G1tensor(102)])
  call ol_merge_tensors(G2tensor(324),[G2tensor(315),G1tensor(462),G1tensor(444)])
  call ol_merge_tensors(G2tensor(823),[G2tensor(317),G1tensor(446),G1tensor(417),G1tensor(76)])
  call ol_merge_tensors(G2tensor(862),[G2tensor(826),G2tensor(374),G2tensor(320),G1tensor(452),G1tensor(291),G1tensor(137) &
    ,G1tensor(78)])
  call ol_merge_tensors(G2tensor(628),[G2tensor(323),G1tensor(458),G1tensor(423),G1tensor(81)])
  call ol_merge_tensors(G2tensor(829),[G2tensor(326),G1tensor(464),G1tensor(87)])
  call ol_merge_tensors(G2tensor(336),[G2tensor(327),G1tensor(486),G1tensor(468)])
  call ol_merge_tensors(G2tensor(742),[G2tensor(332),G1tensor(470),G1tensor(88)])
  call ol_merge_tensors(G2tensor(342),[G2tensor(333),G1tensor(492),G1tensor(474)])
  call ol_merge_tensors(G2tensor(835),[G2tensor(335),G1tensor(482),G1tensor(351),G1tensor(94)])
  call ol_merge_tensors(G2tensor(607),[G2tensor(341),G1tensor(488),G1tensor(357),G1tensor(99)])
  call ol_merge_tensors(G2tensor(841),[G2tensor(344),G1tensor(500),G1tensor(105)])
  call ol_merge_tensors(G2tensor(354),[G2tensor(345),G1tensor(516),G1tensor(504)])
  call ol_merge_tensors(G2tensor(748),[G2tensor(350),G1tensor(506),G1tensor(106)])
  call ol_merge_tensors(G2tensor(360),[G2tensor(351),G1tensor(522),G1tensor(510)])
  call ol_merge_tensors(G2tensor(847),[G2tensor(353),G1tensor(512),G1tensor(267),G1tensor(126)])
  call ol_merge_tensors(G2tensor(577),[G2tensor(359),G1tensor(518),G1tensor(279),G1tensor(117)])
  call ol_merge_tensors(G2tensor(853),[G2tensor(362),G1tensor(530),G1tensor(123)])
  call ol_merge_tensors(G2tensor(372),[G2tensor(363),G1tensor(546),G1tensor(534)])
  call ol_merge_tensors(G2tensor(754),[G2tensor(368),G1tensor(536),G1tensor(129)])
  call ol_merge_tensors(G2tensor(378),[G2tensor(369),G1tensor(552),G1tensor(540)])
  call ol_merge_tensors(G2tensor(859),[G2tensor(371),G1tensor(542),G1tensor(285),G1tensor(135)])
  call ol_merge_tensors(G2tensor(583),[G2tensor(377),G1tensor(548),G1tensor(297),G1tensor(141)])
  call ol_merge_tensors(G2tensor(883),[G1tensor(172),G1tensor(154),G1tensor(148)])
  call ol_merge_tensors(G2tensor(550),[G2tensor(526),G1tensor(209),G1tensor(178),G1tensor(160),G1tensor(149)])
  call ol_merge_tensors(G2tensor(553),[G2tensor(529),G1tensor(359),G1tensor(263),G1tensor(257),G1tensor(215),G1tensor(161) &
    ,G1tensor(155)])
  call ol_merge_tensors(G2tensor(886),[G1tensor(171),G1tensor(166)])
  call ol_merge_tensors(G2tensor(556),[G2tensor(532),G1tensor(221),G1tensor(177),G1tensor(167)])
  call ol_merge_tensors(G2tensor(559),[G2tensor(535),G1tensor(371),G1tensor(281),G1tensor(275),G1tensor(227),G1tensor(179) &
    ,G1tensor(173)])
  call ol_merge_tensors(G2tensor(889),[G1tensor(195),G1tensor(184)])
  call ol_merge_tensors(G2tensor(562),[G2tensor(538),G1tensor(233),G1tensor(201),G1tensor(185)])
  call ol_merge_tensors(G2tensor(892),[G1tensor(196),G1tensor(190)])
  call ol_merge_tensors(G2tensor(565),[G2tensor(541),G1tensor(239),G1tensor(202),G1tensor(191)])
  call ol_merge_tensors(G2tensor(568),[G2tensor(544),G1tensor(425),G1tensor(299),G1tensor(293),G1tensor(245),G1tensor(203) &
    ,G1tensor(197)])
  call ol_merge_tensors(G2tensor(895),[G1tensor(226),G1tensor(214),G1tensor(208)])
  call ol_merge_tensors(G2tensor(898),[G1tensor(225),G1tensor(220)])
  call ol_merge_tensors(G2tensor(901),[G1tensor(243),G1tensor(232)])
  call ol_merge_tensors(G2tensor(904),[G1tensor(244),G1tensor(238)])
  call ol_merge_tensors(G2tensor(934),[G2tensor(907),G1tensor(508),G1tensor(388),G1tensor(382),G1tensor(352),G1tensor(256) &
    ,G1tensor(250)])
  call ol_merge_tensors(G2tensor(574),[G1tensor(262),G1tensor(251)])
  call ol_merge_tensors(G2tensor(922),[G2tensor(910),G1tensor(472),G1tensor(364),G1tensor(316),G1tensor(310),G1tensor(274) &
    ,G1tensor(268)])
  call ol_merge_tensors(G2tensor(580),[G1tensor(280),G1tensor(269)])
  call ol_merge_tensors(G2tensor(931),[G2tensor(913),G1tensor(490),G1tensor(418),G1tensor(340),G1tensor(334),G1tensor(292) &
    ,G1tensor(286)])
  call ol_merge_tensors(G2tensor(586),[G1tensor(298),G1tensor(287)])
  call ol_merge_tensors(G2tensor(970),[G2tensor(916),G1tensor(465),G1tensor(309),G1tensor(303)])
  call ol_merge_tensors(G2tensor(919),[G1tensor(315),G1tensor(304)])
  call ol_merge_tensors(G2tensor(589),[G1tensor(377),G1tensor(321),G1tensor(305)])
  call ol_merge_tensors(G2tensor(637),[G2tensor(592),G1tensor(478),G1tensor(383),G1tensor(322),G1tensor(311)])
  call ol_merge_tensors(G2tensor(595),[G1tensor(389),G1tensor(323),G1tensor(317)])
  call ol_merge_tensors(G2tensor(976),[G2tensor(925),G1tensor(483),G1tensor(333),G1tensor(327)])
  call ol_merge_tensors(G2tensor(928),[G1tensor(339),G1tensor(328)])
  call ol_merge_tensors(G2tensor(598),[G1tensor(431),G1tensor(345),G1tensor(329)])
  call ol_merge_tensors(G2tensor(646),[G2tensor(601),G1tensor(496),G1tensor(437),G1tensor(346),G1tensor(335)])
  call ol_merge_tensors(G2tensor(604),[G1tensor(443),G1tensor(347),G1tensor(341)])
  call ol_merge_tensors(G2tensor(610),[G1tensor(358),G1tensor(353)])
  call ol_merge_tensors(G2tensor(616),[G1tensor(370),G1tensor(365)])
  call ol_merge_tensors(G2tensor(982),[G2tensor(937),G1tensor(501),G1tensor(381),G1tensor(375)])
  call ol_merge_tensors(G2tensor(940),[G1tensor(387),G1tensor(376)])
  call ol_merge_tensors(G2tensor(988),[G2tensor(943),G1tensor(513),G1tensor(399),G1tensor(393)])
  call ol_merge_tensors(G2tensor(946),[G1tensor(405),G1tensor(394)])
  call ol_merge_tensors(G2tensor(619),[G1tensor(449),G1tensor(411),G1tensor(395)])
  call ol_merge_tensors(G2tensor(994),[G2tensor(949),G1tensor(520),G1tensor(406),G1tensor(400)])
  call ol_merge_tensors(G2tensor(655),[G2tensor(622),G1tensor(526),G1tensor(455),G1tensor(412),G1tensor(401)])
  call ol_merge_tensors(G2tensor(625),[G1tensor(461),G1tensor(413),G1tensor(407)])
  call ol_merge_tensors(G2tensor(631),[G1tensor(424),G1tensor(419)])
  call ol_merge_tensors(G2tensor(997),[G2tensor(952),G1tensor(531),G1tensor(435),G1tensor(429)])
  call ol_merge_tensors(G2tensor(955),[G1tensor(441),G1tensor(430)])
  call ol_merge_tensors(G2tensor(1003),[G2tensor(958),G1tensor(538),G1tensor(442),G1tensor(436)])
  call ol_merge_tensors(G2tensor(1006),[G2tensor(961),G1tensor(543),G1tensor(453),G1tensor(447)])
  call ol_merge_tensors(G2tensor(964),[G1tensor(459),G1tensor(448)])
  call ol_merge_tensors(G2tensor(1012),[G2tensor(967),G1tensor(550),G1tensor(460),G1tensor(454)])
  call ol_merge_tensors(G2tensor(973),[G1tensor(471),G1tensor(466)])
  call ol_merge_tensors(G2tensor(634),[G1tensor(503),G1tensor(477),G1tensor(467)])
  call ol_merge_tensors(G2tensor(640),[G1tensor(509),G1tensor(479),G1tensor(473)])
  call ol_merge_tensors(G2tensor(979),[G1tensor(489),G1tensor(484)])
  call ol_merge_tensors(G2tensor(643),[G1tensor(533),G1tensor(495),G1tensor(485)])
  call ol_merge_tensors(G2tensor(649),[G1tensor(539),G1tensor(497),G1tensor(491)])
  call ol_merge_tensors(G2tensor(985),[G1tensor(507),G1tensor(502)])
  call ol_merge_tensors(G2tensor(991),[G1tensor(519),G1tensor(514)])
  call ol_merge_tensors(G2tensor(652),[G1tensor(545),G1tensor(525),G1tensor(515)])
  call ol_merge_tensors(G2tensor(658),[G1tensor(551),G1tensor(527),G1tensor(521)])
  call ol_merge_tensors(G2tensor(1000),[G1tensor(537),G1tensor(532)])
  call ol_merge_tensors(G2tensor(1009),[G1tensor(549),G1tensor(544)])
  call Hotf_4pt_reduction_last(G2tensor(499),RedSet_4(263),mass4set(:,5),  & 
G1tensor(1),G1tensor(37),G1tensor(73),G1tensor(109),G1tensor(2))
  call G_TensorShift(G1tensor(37),1)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(215),mass4set(:,1),  & 
G1tensor(38),G1tensor(39),G1tensor(92),G1tensor(116),G1tensor(140))
  call G_TensorShift(G1tensor(39),3)
  call Hotf_4pt_reduction_last(G2tensor(397),RedSet_4(13),mass4set(:,1),  & 
G1tensor(6),G1tensor(16),G1tensor(23),G1tensor(40),G1tensor(47))
  call G_TensorShift(G1tensor(16),19)
  call Hotf_4pt_reduction_last(G2tensor(501),RedSet_4(264),mass4set(:,5),  & 
G1tensor(57),G1tensor(63),G1tensor(70),G1tensor(82),G1tensor(108))
  call G_TensorShift(G1tensor(63),1)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(216),mass4set(:,1),  & 
G1tensor(100),G1tensor(111),G1tensor(138),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(111),3)
  call Hotf_4pt_reduction_last(G2tensor(401),RedSet_4(23),mass4set(:,1),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),19)
  call Hotf_4pt_reduction_last(G2tensor(503),RedSet_4(265),mass4set(:,5),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),2)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(217),mass4set(:,1),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),3)
  call Hotf_4pt_reduction_last(G2tensor(385),RedSet_4(38),mass4set(:,1),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),11)
  call Hotf_4pt_reduction_last(G2tensor(505),RedSet_4(266),mass4set(:,5),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),2)
  call Hotf_4pt_reduction_last(G2tensor(507),RedSet_4(267),mass4set(:,5),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),2)
  call Hotf_4pt_reduction_last(G2tensor(509),RedSet_4(268),mass4set(:,5),  & 
G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(337),1)
  call Hotf_4pt_reduction_last(G2tensor(697),RedSet_4(235),mass4set(:,2),  & 
G1tensor(361),G1tensor(367),G1tensor(373),G1tensor(379),G1tensor(385))
  call G_TensorShift(G1tensor(367),1)
  call Hotf_4pt_reduction_last(G2tensor(865),RedSet_4(218),mass4set(:,2),  & 
G1tensor(391),G1tensor(397),G1tensor(403),G1tensor(409),G1tensor(415))
  call G_TensorShift(G1tensor(397),5)
  call Hotf_4pt_reduction_last(G2tensor(1051),RedSet_4(78),mass4set(:,2),  & 
G1tensor(421),G1tensor(427),G1tensor(433),G1tensor(439),G1tensor(445))
  call G_TensorShift(G1tensor(427),21)
  call Hotf_4pt_reduction_last(G2tensor(703),RedSet_4(224),mass4set(:,2),  & 
G1tensor(451),G1tensor(457),G1tensor(463),G1tensor(469),G1tensor(475))
  call G_TensorShift(G1tensor(457),2)
  call Hotf_4pt_reduction_last(G2tensor(874),RedSet_4(219),mass4set(:,2),  & 
G1tensor(481),G1tensor(487),G1tensor(493),G1tensor(499),G1tensor(505))
  call G_TensorShift(G1tensor(487),10)
  call Hotf_4pt_reduction_last(G2tensor(1060),RedSet_4(91),mass4set(:,2),  & 
G1tensor(511),G1tensor(517),G1tensor(523),G1tensor(529),G1tensor(535))
  call G_TensorShift(G1tensor(517),26)
  call Hotf_4pt_reduction_last(G2tensor(880),RedSet_4(4),mass4set(:,2),  & 
G1tensor(541),G1tensor(547),G1tensor(553),G1tensor(559),G1tensor(565))
  call G_TensorShift(G1tensor(547),18)
  call Hotf_4pt_reduction_last(G2tensor(709),RedSet_4(240),mass4set(:,3),  & 
G1tensor(571),G1tensor(577),G1tensor(583),G1tensor(578),G1tensor(7))
  call G_TensorShift(G1tensor(577),4)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(220),mass4set(:,3),  & 
G1tensor(158),G1tensor(139),G1tensor(31),G1tensor(582),G1tensor(570))
  call G_TensorShift(G1tensor(139),12)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(113),mass4set(:,3),  & 
G1tensor(162),G1tensor(584),G1tensor(43),G1tensor(176),G1tensor(32))
  call G_TensorShift(G1tensor(584),28)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(70),mass4set(:,3),  & 
G1tensor(67),G1tensor(588),G1tensor(576),G1tensor(180),G1tensor(554))
  call G_TensorShift(G1tensor(588),20)
  call Hotf_4pt_reduction_last(G2tensor(715),RedSet_4(227),mass4set(:,2),  & 
G1tensor(79),G1tensor(200),G1tensor(62),G1tensor(103),G1tensor(564))
  call G_TensorShift(G1tensor(200),2)
  call Hotf_4pt_reduction_last(G2tensor(868),RedSet_4(221),mass4set(:,2),  & 
G1tensor(558),G1tensor(204),G1tensor(566),G1tensor(115),G1tensor(572))
  call G_TensorShift(G1tensor(204),6)
  call Hotf_4pt_reduction_last(G2tensor(1057),RedSet_4(131),mass4set(:,2),  & 
G1tensor(8),G1tensor(560),G1tensor(44),G1tensor(218),G1tensor(68))
  call G_TensorShift(G1tensor(560),22)
  call Hotf_4pt_reduction_last(G2tensor(721),RedSet_4(232),mass4set(:,2),  & 
G1tensor(14),G1tensor(260),G1tensor(75),G1tensor(264),G1tensor(69))
  call G_TensorShift(G1tensor(260),1)
  call Hotf_4pt_reduction_last(G2tensor(871),RedSet_4(222),mass4set(:,2),  & 
G1tensor(21),G1tensor(13),G1tensor(278),G1tensor(110),G1tensor(300))
  call G_TensorShift(G1tensor(13),9)
  call Hotf_4pt_reduction_last(G2tensor(1054),RedSet_4(140),mass4set(:,2),  & 
G1tensor(282),G1tensor(579),G1tensor(296),G1tensor(134),G1tensor(9))
  call G_TensorShift(G1tensor(579),25)
  call Hotf_4pt_reduction_last(G2tensor(727),RedSet_4(26),mass4set(:,3),  & 
G1tensor(51),G1tensor(74),G1tensor(320),G1tensor(77),G1tensor(24))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(135),mass4set(:,3),  & 
G1tensor(414),G1tensor(348),G1tensor(324),G1tensor(344),G1tensor(66))
  call G_TensorShift(G1tensor(348),24)
  call Hotf_4pt_reduction_last(G2tensor(877),RedSet_4(43),mass4set(:,2),  & 
G1tensor(15),G1tensor(164),G1tensor(17),G1tensor(49),G1tensor(356))
  call G_TensorShift(G1tensor(164),17)
  call Hotf_4pt_reduction_last(G2tensor(733),RedSet_4(41),mass4set(:,3),  & 
G1tensor(22),G1tensor(360),G1tensor(112),G1tensor(27),G1tensor(121))
  call G_TensorShift(G1tensor(360),16)
  call Hotf_4pt_reduction_last(G2tensor(739),RedSet_4(248),mass4set(:,3),  & 
G1tensor(368),G1tensor(35),G1tensor(426),G1tensor(372),G1tensor(189))
  call G_TensorShift(G1tensor(35),4)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(223),mass4set(:,3),  & 
G1tensor(183),G1tensor(48),G1tensor(71),G1tensor(29),G1tensor(410))
  call G_TensorShift(G1tensor(48),12)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(188),mass4set(:,3),  & 
G1tensor(124),G1tensor(54),G1tensor(567),G1tensor(422),G1tensor(60))
  call G_TensorShift(G1tensor(54),28)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(126),mass4set(:,3),  & 
G1tensor(219),G1tensor(207),G1tensor(72),G1tensor(118),G1tensor(58))
  call G_TensorShift(G1tensor(207),20)
  call Hotf_4pt_reduction_last(G2tensor(745),RedSet_4(57),mass4set(:,3),  & 
G1tensor(90),G1tensor(83),G1tensor(36),G1tensor(476),G1tensor(107))
  call G_TensorShift(G1tensor(83),8)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(83),mass4set(:,3),  & 
G1tensor(89),G1tensor(528),G1tensor(498),G1tensor(480),G1tensor(494))
  call G_TensorShift(G1tensor(528),24)
  call Hotf_4pt_reduction_last(G2tensor(751),RedSet_4(1),mass4set(:,3),  & 
G1tensor(131),G1tensor(136),G1tensor(237),G1tensor(231),G1tensor(113))
  call G_TensorShift(G1tensor(136),16)
  call Hotf_4pt_reduction_last(G2tensor(757),RedSet_4(225),mass4set(:,2),  & 
G1tensor(101),G1tensor(98),G1tensor(524),G1tensor(143),G1tensor(119))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_4pt_reduction_last(G2tensor(1033),RedSet_4(8),mass4set(:,2),  & 
G1tensor(165),G1tensor(147),G1tensor(132),G1tensor(120),G1tensor(122))
  call G_TensorShift(G1tensor(147),18)
  call Hotf_4pt_reduction_last(G2tensor(661),RedSet_4(226),mass4set(:,2),  & 
G1tensor(146),G1tensor(55),G1tensor(19),G1tensor(586),G1tensor(580))
  call G_TensorShift(G1tensor(55),2)
  call Hotf_4pt_reduction_last(G2tensor(691),RedSet_4(11),mass4set(:,2),  & 
G1tensor(150),G1tensor(152),G1tensor(25),G1tensor(581),G1tensor(156))
  call G_TensorShift(G1tensor(152),18)
  call Hotf_4pt_reduction_last(G2tensor(1036),RedSet_4(18),mass4set(:,2),  & 
G1tensor(585),G1tensor(168),G1tensor(170),G1tensor(61),G1tensor(587))
  call G_TensorShift(G1tensor(168),18)
  call Hotf_4pt_reduction_last(G2tensor(664),RedSet_4(228),mass4set(:,2),  & 
G1tensor(174),G1tensor(182),G1tensor(85),G1tensor(555),G1tensor(186))
  call G_TensorShift(G1tensor(182),2)
  call Hotf_4pt_reduction_last(G2tensor(694),RedSet_4(21),mass4set(:,2),  & 
G1tensor(188),G1tensor(91),G1tensor(556),G1tensor(192),G1tensor(194))
  call G_TensorShift(G1tensor(91),18)
  call Hotf_4pt_reduction_last(G2tensor(760),RedSet_4(229),mass4set(:,2),  & 
G1tensor(97),G1tensor(557),G1tensor(198),G1tensor(206),G1tensor(20))
  call G_TensorShift(G1tensor(557),1)
  call Hotf_4pt_reduction_last(G2tensor(1015),RedSet_4(29),mass4set(:,2),  & 
G1tensor(127),G1tensor(574),G1tensor(568),G1tensor(210),G1tensor(212))
  call G_TensorShift(G1tensor(574),9)
  call Hotf_4pt_reduction_last(G2tensor(763),RedSet_4(230),mass4set(:,2),  & 
G1tensor(133),G1tensor(569),G1tensor(216),G1tensor(573),G1tensor(222))
  call G_TensorShift(G1tensor(569),1)
  call Hotf_4pt_reduction_last(G2tensor(1018),RedSet_4(33),mass4set(:,2),  & 
G1tensor(224),G1tensor(26),G1tensor(575),G1tensor(228),G1tensor(230))
  call G_TensorShift(G1tensor(26),9)
  call Hotf_4pt_reduction_last(G2tensor(667),RedSet_4(231),mass4set(:,2),  & 
G1tensor(50),G1tensor(561),G1tensor(234),G1tensor(236),G1tensor(3))
  call G_TensorShift(G1tensor(561),1)
  call Hotf_4pt_reduction_last(G2tensor(679),RedSet_4(36),mass4set(:,2),  & 
G1tensor(562),G1tensor(240),G1tensor(242),G1tensor(56),G1tensor(563))
  call G_TensorShift(G1tensor(240),9)
  call Hotf_4pt_reduction_last(G2tensor(766),RedSet_4(233),mass4set(:,2),  & 
G1tensor(246),G1tensor(248),G1tensor(80),G1tensor(252),G1tensor(254))
  call G_TensorShift(G1tensor(248),1)
  call Hotf_4pt_reduction_last(G2tensor(1027),RedSet_4(46),mass4set(:,2),  & 
G1tensor(28),G1tensor(86),G1tensor(258),G1tensor(266),G1tensor(104))
  call G_TensorShift(G1tensor(86),17)
  call Hotf_4pt_reduction_last(G2tensor(670),RedSet_4(234),mass4set(:,2),  & 
G1tensor(288),G1tensor(270),G1tensor(272),G1tensor(34),G1tensor(93))
  call G_TensorShift(G1tensor(270),1)
  call Hotf_4pt_reduction_last(G2tensor(685),RedSet_4(48),mass4set(:,2),  & 
G1tensor(294),G1tensor(276),G1tensor(284),G1tensor(153),G1tensor(128))
  call G_TensorShift(G1tensor(276),17)
  call Hotf_4pt_reduction_last(G2tensor(1030),RedSet_4(52),mass4set(:,2),  & 
G1tensor(290),G1tensor(159),G1tensor(84),G1tensor(45),G1tensor(302))
  call G_TensorShift(G1tensor(159),17)
  call Hotf_4pt_reduction_last(G2tensor(673),RedSet_4(236),mass4set(:,2),  & 
G1tensor(10),G1tensor(330),G1tensor(306),G1tensor(308),G1tensor(130))
  call G_TensorShift(G1tensor(330),1)
  call Hotf_4pt_reduction_last(G2tensor(688),RedSet_4(54),mass4set(:,2),  & 
G1tensor(4),G1tensor(336),G1tensor(312),G1tensor(314),G1tensor(5))
  call G_TensorShift(G1tensor(336),17)
  call Hotf_4pt_reduction_last(G2tensor(769),RedSet_4(237),mass4set(:,2),  & 
G1tensor(342),G1tensor(318),G1tensor(326),G1tensor(249),G1tensor(11))
  call G_TensorShift(G1tensor(318),2)
  call Hotf_4pt_reduction_last(G2tensor(1021),RedSet_4(59),mass4set(:,2),  & 
G1tensor(332),G1tensor(255),G1tensor(96),G1tensor(30),G1tensor(338))
  call G_TensorShift(G1tensor(255),10)
  call Hotf_4pt_reduction_last(G2tensor(772),RedSet_4(238),mass4set(:,2),  & 
G1tensor(261),G1tensor(12),G1tensor(350),G1tensor(18),G1tensor(354))
  call G_TensorShift(G1tensor(12),2)
  call Hotf_4pt_reduction_last(G2tensor(1024),RedSet_4(62),mass4set(:,2),  & 
G1tensor(362),G1tensor(33),G1tensor(420),G1tensor(366),G1tensor(374))
  call G_TensorShift(G1tensor(33),10)
  call Hotf_4pt_reduction_last(G2tensor(676),RedSet_4(239),mass4set(:,2),  & 
G1tensor(41),G1tensor(396),G1tensor(378),G1tensor(380),G1tensor(142))
  call G_TensorShift(G1tensor(396),2)
  call Hotf_4pt_reduction_last(G2tensor(682),RedSet_4(64),mass4set(:,2),  & 
G1tensor(42),G1tensor(402),G1tensor(384),G1tensor(386),G1tensor(46))
  call G_TensorShift(G1tensor(402),10)
  call Hotf_4pt_reduction_last(G2tensor(775),RedSet_4(241),mass4set(:,3),  & 
G1tensor(408),G1tensor(390),G1tensor(392),G1tensor(363),G1tensor(52))
  call G_TensorShift(G1tensor(390),4)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(74),mass4set(:,3),  & 
G1tensor(398),G1tensor(273),G1tensor(114),G1tensor(95),G1tensor(404))
  call G_TensorShift(G1tensor(273),20)
  call Hotf_4pt_reduction_last(G2tensor(718),RedSet_4(242),mass4set(:,1),  & 
G1tensor(369),G1tensor(53),G1tensor(416),G1tensor(213),G1tensor(59))
  call G_TensorShift(G1tensor(53),4)
  call Hotf_4pt_reduction_last(G2tensor(276),RedSet_4(76),mass4set(:,1),  & 
G1tensor(428),G1tensor(64),G1tensor(450),G1tensor(432),G1tensor(434))
  call G_TensorShift(G1tensor(64),20)
  call Hotf_4pt_reduction_last(G2tensor(778),RedSet_4(243),mass4set(:,3),  & 
G1tensor(125),G1tensor(65),G1tensor(456),G1tensor(438),G1tensor(440))
  call G_TensorShift(G1tensor(65),8)
  call Hotf_4pt_reduction_last(G2tensor(249),RedSet_4(87),mass4set(:,3),  & 
G1tensor(102),G1tensor(462),G1tensor(444),G1tensor(446),G1tensor(417))
  call G_TensorShift(G1tensor(462),24)
  call Hotf_4pt_reduction_last(G2tensor(724),RedSet_4(244),mass4set(:,1),  & 
G1tensor(76),G1tensor(452),G1tensor(291),G1tensor(137),G1tensor(78))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(89),mass4set(:,1),  & 
G1tensor(458),G1tensor(423),G1tensor(81),G1tensor(464),G1tensor(87))
  call G_TensorShift(G1tensor(423),24)
  call Hotf_4pt_reduction_last(G2tensor(781),RedSet_4(2),mass4set(:,3),  & 
G1tensor(486),G1tensor(468),G1tensor(470),G1tensor(88),G1tensor(492))
  call G_TensorShift(G1tensor(468),16)
  call Hotf_4pt_reduction_last(G2tensor(547),RedSet_4(3),mass4set(:,1),  & 
G1tensor(474),G1tensor(482),G1tensor(351),G1tensor(94),G1tensor(488))
  call G_TensorShift(G1tensor(482),16)
  call Hotf_4pt_reduction_last(G2tensor(784),RedSet_4(245),mass4set(:,4),  & 
G1tensor(357),G1tensor(99),G1tensor(500),G1tensor(105),G1tensor(516))
  call G_TensorShift(G1tensor(99),8)
  call Hotf_4pt_reduction_last(G2tensor(264),RedSet_4(105),mass4set(:,4),  & 
G1tensor(504),G1tensor(506),G1tensor(106),G1tensor(522),G1tensor(510))
  call G_TensorShift(G1tensor(506),24)
  call Hotf_4pt_reduction_last(G2tensor(832),RedSet_4(246),mass4set(:,1),  & 
G1tensor(512),G1tensor(267),G1tensor(126),G1tensor(518),G1tensor(279))
  call G_TensorShift(G1tensor(267),8)
  call Hotf_4pt_reduction_last(G2tensor(339),RedSet_4(108),mass4set(:,1),  & 
G1tensor(117),G1tensor(530),G1tensor(123),G1tensor(546),G1tensor(534))
  call G_TensorShift(G1tensor(530),24)
  call Hotf_4pt_reduction_last(G2tensor(712),RedSet_4(247),mass4set(:,3),  & 
G1tensor(536),G1tensor(129),G1tensor(552),G1tensor(540),G1tensor(542))
  call G_TensorShift(G1tensor(129),8)
  call Hotf_4pt_reduction_last(G2tensor(270),RedSet_4(111),mass4set(:,3),  & 
G1tensor(285),G1tensor(135),G1tensor(548),G1tensor(297),G1tensor(141))
  call G_TensorShift(G1tensor(135),24)
  call Hotf_4pt_reduction_last(G2tensor(790),RedSet_4(67),mass4set(:,4),  & 
G1tensor(172),G1tensor(154),G1tensor(148),G1tensor(209),G1tensor(178))
  call G_TensorShift(G1tensor(154),16)
  call Hotf_4pt_reduction_last(G2tensor(838),RedSet_4(68),mass4set(:,1),  & 
G1tensor(160),G1tensor(149),G1tensor(359),G1tensor(263),G1tensor(257))
  call G_TensorShift(G1tensor(149),16)
  call Hotf_4pt_reduction_last(G2tensor(571),RedSet_4(69),mass4set(:,3),  & 
G1tensor(215),G1tensor(161),G1tensor(155),G1tensor(171),G1tensor(166))
  call G_TensorShift(G1tensor(161),16)
  call Hotf_4pt_reduction_last(G2tensor(796),RedSet_4(249),mass4set(:,3),  & 
G1tensor(221),G1tensor(177),G1tensor(167),G1tensor(371),G1tensor(281))
  call G_TensorShift(G1tensor(177),4)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(129),mass4set(:,3),  & 
G1tensor(275),G1tensor(227),G1tensor(179),G1tensor(173),G1tensor(195))
  call G_TensorShift(G1tensor(227),20)
  call Hotf_4pt_reduction_last(G2tensor(799),RedSet_4(250),mass4set(:,3),  & 
G1tensor(184),G1tensor(233),G1tensor(201),G1tensor(185),G1tensor(196))
  call G_TensorShift(G1tensor(233),8)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(138),mass4set(:,3),  & 
G1tensor(190),G1tensor(239),G1tensor(202),G1tensor(191),G1tensor(425))
  call G_TensorShift(G1tensor(239),24)
  call Hotf_4pt_reduction_last(G2tensor(802),RedSet_4(251),mass4set(:,4),  & 
G1tensor(299),G1tensor(293),G1tensor(245),G1tensor(203),G1tensor(197))
  call G_TensorShift(G1tensor(293),4)
  call Hotf_4pt_reduction_last(G2tensor(294),RedSet_4(144),mass4set(:,4),  & 
G1tensor(226),G1tensor(214),G1tensor(208),G1tensor(225),G1tensor(220))
  call G_TensorShift(G1tensor(214),20)
  call Hotf_4pt_reduction_last(G2tensor(844),RedSet_4(252),mass4set(:,1),  & 
G1tensor(243),G1tensor(232),G1tensor(244),G1tensor(238),G1tensor(508))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(357),RedSet_4(146),mass4set(:,1),  & 
G1tensor(388),G1tensor(382),G1tensor(352),G1tensor(256),G1tensor(250))
  call G_TensorShift(G1tensor(382),20)
  call Hotf_4pt_reduction_last(G2tensor(730),RedSet_4(253),mass4set(:,3),  & 
G1tensor(262),G1tensor(251),G1tensor(472),G1tensor(364),G1tensor(316))
  call G_TensorShift(G1tensor(251),4)
  call Hotf_4pt_reduction_last(G2tensor(300),RedSet_4(148),mass4set(:,3),  & 
G1tensor(310),G1tensor(274),G1tensor(268),G1tensor(280),G1tensor(269))
  call G_TensorShift(G1tensor(274),20)
  call Hotf_4pt_reduction_last(G2tensor(808),RedSet_4(133),mass4set(:,4),  & 
G1tensor(490),G1tensor(418),G1tensor(340),G1tensor(334),G1tensor(292))
  call G_TensorShift(G1tensor(418),16)
  call Hotf_4pt_reduction_last(G2tensor(850),RedSet_4(81),mass4set(:,1),  & 
G1tensor(286),G1tensor(298),G1tensor(287),G1tensor(465),G1tensor(309))
  call G_TensorShift(G1tensor(298),16)
  call Hotf_4pt_reduction_last(G2tensor(613),RedSet_4(134),mass4set(:,3),  & 
G1tensor(303),G1tensor(315),G1tensor(304),G1tensor(377),G1tensor(321))
  call G_TensorShift(G1tensor(315),16)
  call Hotf_4pt_reduction_last(G2tensor(814),RedSet_4(42),mass4set(:,3),  & 
G1tensor(305),G1tensor(478),G1tensor(383),G1tensor(322),G1tensor(311))
  call G_TensorShift(G1tensor(478),16)
  call Hotf_4pt_reduction_last(G2tensor(817),RedSet_4(254),mass4set(:,4),  & 
G1tensor(389),G1tensor(323),G1tensor(317),G1tensor(483),G1tensor(333))
  call G_TensorShift(G1tensor(323),4)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(168),mass4set(:,4),  & 
G1tensor(327),G1tensor(339),G1tensor(328),G1tensor(431),G1tensor(345))
  call G_TensorShift(G1tensor(339),12)
  call Hotf_4pt_reduction_last(G2tensor(856),RedSet_4(255),mass4set(:,1),  & 
G1tensor(329),G1tensor(496),G1tensor(437),G1tensor(346),G1tensor(335))
  call G_TensorShift(G1tensor(496),4)
  call Hotf_4pt_reduction_last(G2tensor(375),RedSet_4(171),mass4set(:,1),  & 
G1tensor(443),G1tensor(347),G1tensor(341),G1tensor(358),G1tensor(353))
  call G_TensorShift(G1tensor(347),12)
  call Hotf_4pt_reduction_last(G2tensor(736),RedSet_4(256),mass4set(:,3),  & 
G1tensor(370),G1tensor(365),G1tensor(501),G1tensor(381),G1tensor(375))
  call G_TensorShift(G1tensor(365),4)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(173),mass4set(:,3),  & 
G1tensor(387),G1tensor(376),G1tensor(513),G1tensor(399),G1tensor(393))
  call G_TensorShift(G1tensor(376),12)
  call Hotf_4pt_reduction_last(G2tensor(823),RedSet_4(160),mass4set(:,4),  & 
G1tensor(405),G1tensor(394),G1tensor(449),G1tensor(411),G1tensor(395))
  call G_TensorShift(G1tensor(394),8)
  call Hotf_4pt_reduction_last(G2tensor(862),RedSet_4(94),mass4set(:,1),  & 
G1tensor(520),G1tensor(406),G1tensor(400),G1tensor(526),G1tensor(455))
  call G_TensorShift(G1tensor(406),8)
  call Hotf_4pt_reduction_last(G2tensor(628),RedSet_4(161),mass4set(:,3),  & 
G1tensor(412),G1tensor(401),G1tensor(461),G1tensor(413),G1tensor(407))
  call G_TensorShift(G1tensor(401),8)
  call Hotf_4pt_reduction_last(G2tensor(829),RedSet_4(257),mass4set(:,4),  & 
G1tensor(424),G1tensor(419),G1tensor(531),G1tensor(435),G1tensor(429))
  call G_TensorShift(G1tensor(419),8)
  call Hotf_4pt_reduction_last(G2tensor(336),RedSet_4(183),mass4set(:,4),  & 
G1tensor(441),G1tensor(430),G1tensor(538),G1tensor(442),G1tensor(436))
  call G_TensorShift(G1tensor(430),24)
  call Hotf_4pt_reduction_last(G2tensor(742),RedSet_4(258),mass4set(:,3),  & 
G1tensor(543),G1tensor(453),G1tensor(447),G1tensor(459),G1tensor(448))
  call G_TensorShift(G1tensor(453),8)
  call Hotf_4pt_reduction_last(G2tensor(342),RedSet_4(186),mass4set(:,3),  & 
G1tensor(550),G1tensor(460),G1tensor(454),G1tensor(471),G1tensor(466))
  call G_TensorShift(G1tensor(460),24)
  call Hotf_4pt_reduction_last(G2tensor(835),RedSet_4(124),mass4set(:,4),  & 
G1tensor(503),G1tensor(477),G1tensor(467),G1tensor(509),G1tensor(479))
  call G_TensorShift(G1tensor(477),16)
  call Hotf_4pt_reduction_last(G2tensor(607),RedSet_4(125),mass4set(:,3),  & 
G1tensor(473),G1tensor(489),G1tensor(484),G1tensor(533),G1tensor(495))
  call G_TensorShift(G1tensor(489),16)
  call Hotf_4pt_reduction_last(G2tensor(841),RedSet_4(259),mass4set(:,4),  & 
G1tensor(485),G1tensor(539),G1tensor(497),G1tensor(491),G1tensor(507))
  call G_TensorShift(G1tensor(539),4)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(197),mass4set(:,4),  & 
G1tensor(502),G1tensor(519),G1tensor(514),G1tensor(545),G1tensor(525))
  call G_TensorShift(G1tensor(519),20)
  call Hotf_4pt_reduction_last(G2tensor(748),RedSet_4(260),mass4set(:,3),  & 
G1tensor(515),G1tensor(551),G1tensor(527),G1tensor(521),G1tensor(537))
  call G_TensorShift(G1tensor(551),4)
  call Hotf_4pt_reduction_last(G2tensor(360),RedSet_4(199),mass4set(:,3),  & 
G1tensor(532),G1tensor(549),G1tensor(544),G1tensor(589),G1tensor(590))
  call G_TensorShift(G1tensor(549),20)
  call Hotf_4pt_reduction_last(G2tensor(847),RedSet_4(80),mass4set(:,4),  & 
G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595))
  call G_TensorShift(G1tensor(592),16)
  call Hotf_4pt_reduction_last(G2tensor(577),RedSet_4(82),mass4set(:,3),  & 
G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(597),16)
  call Hotf_4pt_reduction_last(G2tensor(853),RedSet_4(261),mass4set(:,4),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(602),4)
  call Hotf_4pt_reduction_last(G2tensor(372),RedSet_4(208),mass4set(:,4),  & 
G1tensor(606),G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610))
  call G_TensorShift(G1tensor(607),12)
  call Hotf_4pt_reduction_last(G2tensor(754),RedSet_4(262),mass4set(:,3),  & 
G1tensor(611),G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615))
  call G_TensorShift(G1tensor(612),4)
  call Hotf_4pt_reduction_last(G2tensor(378),RedSet_4(210),mass4set(:,3),  & 
G1tensor(616),G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620))
  call G_TensorShift(G1tensor(617),12)
  call Hotf_4pt_reduction_last(G2tensor(859),RedSet_4(93),mass4set(:,4),  & 
G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625))
  call G_TensorShift(G1tensor(622),8)
  call Hotf_4pt_reduction_last(G2tensor(583),RedSet_4(95),mass4set(:,3),  & 
G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(627),8)
  call Hotf_4pt_reduction_last(G2tensor(883),RedSet_4(6),mass4set(:,3),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_4pt_reduction_last(G2tensor(550),RedSet_4(7),mass4set(:,1),  & 
G1tensor(636),G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640))
  call G_TensorShift(G1tensor(637),16)
  call Hotf_4pt_reduction_last(G2tensor(553),RedSet_4(10),mass4set(:,1),  & 
G1tensor(641),G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645))
  call G_TensorShift(G1tensor(642),16)
  call Hotf_4pt_reduction_last(G2tensor(886),RedSet_4(16),mass4set(:,3),  & 
G1tensor(646),G1tensor(647),G1tensor(648),G1tensor(649),G1tensor(650))
  call G_TensorShift(G1tensor(647),16)
  call Hotf_4pt_reduction_last(G2tensor(556),RedSet_4(17),mass4set(:,1),  & 
G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654),G1tensor(655))
  call G_TensorShift(G1tensor(652),16)
  call Hotf_4pt_reduction_last(G2tensor(559),RedSet_4(20),mass4set(:,1),  & 
G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(657),16)
  call Hotf_4pt_reduction_last(G2tensor(889),RedSet_4(27),mass4set(:,3),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665))
  call G_TensorShift(G1tensor(662),8)
  call Hotf_4pt_reduction_last(G2tensor(562),RedSet_4(28),mass4set(:,1),  & 
G1tensor(666),G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670))
  call G_TensorShift(G1tensor(667),8)
  call Hotf_4pt_reduction_last(G2tensor(892),RedSet_4(31),mass4set(:,3),  & 
G1tensor(671),G1tensor(672),G1tensor(673),G1tensor(674),G1tensor(675))
  call G_TensorShift(G1tensor(672),8)
  call Hotf_4pt_reduction_last(G2tensor(565),RedSet_4(32),mass4set(:,1),  & 
G1tensor(676),G1tensor(677),G1tensor(678),G1tensor(679),G1tensor(680))
  call G_TensorShift(G1tensor(677),8)
  call Hotf_4pt_reduction_last(G2tensor(568),RedSet_4(35),mass4set(:,1),  & 
G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684),G1tensor(685))
  call G_TensorShift(G1tensor(682),8)
  call Hotf_4pt_reduction_last(G2tensor(895),RedSet_4(45),mass4set(:,3),  & 
G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(687),16)
  call Hotf_4pt_reduction_last(G2tensor(898),RedSet_4(51),mass4set(:,3),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695))
  call G_TensorShift(G1tensor(692),16)
  call Hotf_4pt_reduction_last(G2tensor(901),RedSet_4(58),mass4set(:,3),  & 
G1tensor(696),G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700))
  call G_TensorShift(G1tensor(697),8)
  call Hotf_4pt_reduction_last(G2tensor(904),RedSet_4(61),mass4set(:,3),  & 
G1tensor(701),G1tensor(702),G1tensor(703),G1tensor(704),G1tensor(705))
  call G_TensorShift(G1tensor(702),8)
  call Hotf_4pt_reduction_last(G2tensor(934),RedSet_4(72),mass4set(:,1),  & 
G1tensor(706),G1tensor(707),G1tensor(708),G1tensor(709),G1tensor(710))
  call G_TensorShift(G1tensor(707),16)
  call Hotf_4pt_reduction_last(G2tensor(574),RedSet_4(73),mass4set(:,3),  & 
G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714),G1tensor(715))
  call G_TensorShift(G1tensor(712),16)
  call Hotf_4pt_reduction_last(G2tensor(922),RedSet_4(85),mass4set(:,1),  & 
G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(717),16)
  call Hotf_4pt_reduction_last(G2tensor(580),RedSet_4(86),mass4set(:,3),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_4pt_reduction_last(G2tensor(931),RedSet_4(97),mass4set(:,1),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),8)
  call Hotf_4pt_reduction_last(G2tensor(586),RedSet_4(98),mass4set(:,3),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),8)
  call Hotf_4pt_reduction_last(G2tensor(970),RedSet_4(102),mass4set(:,1),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),16)
  call Hotf_4pt_reduction_last(G2tensor(919),RedSet_4(103),mass4set(:,4),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),16)
  call Hotf_4pt_reduction_last(G2tensor(589),RedSet_4(104),mass4set(:,4),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),16)
  call Hotf_4pt_reduction_last(G2tensor(637),RedSet_4(107),mass4set(:,1),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),16)
  call Hotf_4pt_reduction_last(G2tensor(595),RedSet_4(110),mass4set(:,3),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),16)
  call Hotf_4pt_reduction_last(G2tensor(976),RedSet_4(115),mass4set(:,1),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),8)
  call Hotf_4pt_reduction_last(G2tensor(928),RedSet_4(116),mass4set(:,4),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),8)
  call Hotf_4pt_reduction_last(G2tensor(598),RedSet_4(117),mass4set(:,4),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),8)
  call Hotf_4pt_reduction_last(G2tensor(646),RedSet_4(119),mass4set(:,1),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),8)
  call Hotf_4pt_reduction_last(G2tensor(604),RedSet_4(121),mass4set(:,3),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),8)
  call Hotf_4pt_reduction_last(G2tensor(610),RedSet_4(128),mass4set(:,3),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),16)
  call Hotf_4pt_reduction_last(G2tensor(616),RedSet_4(137),mass4set(:,3),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),16)
  call Hotf_4pt_reduction_last(G2tensor(982),RedSet_4(142),mass4set(:,1),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),16)
  call Hotf_4pt_reduction_last(G2tensor(940),RedSet_4(143),mass4set(:,4),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),16)
  call Hotf_4pt_reduction_last(G2tensor(988),RedSet_4(150),mass4set(:,1),  & 
G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(807),4)
  call Hotf_4pt_reduction_last(G2tensor(946),RedSet_4(151),mass4set(:,4),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815))
  call G_TensorShift(G1tensor(812),4)
  call Hotf_4pt_reduction_last(G2tensor(619),RedSet_4(152),mass4set(:,4),  & 
G1tensor(816),G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820))
  call G_TensorShift(G1tensor(817),4)
  call Hotf_4pt_reduction_last(G2tensor(994),RedSet_4(154),mass4set(:,1),  & 
G1tensor(821),G1tensor(822),G1tensor(823),G1tensor(824),G1tensor(825))
  call G_TensorShift(G1tensor(822),4)
  call Hotf_4pt_reduction_last(G2tensor(655),RedSet_4(155),mass4set(:,1),  & 
G1tensor(826),G1tensor(827),G1tensor(828),G1tensor(829),G1tensor(830))
  call G_TensorShift(G1tensor(827),4)
  call Hotf_4pt_reduction_last(G2tensor(625),RedSet_4(157),mass4set(:,3),  & 
G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834),G1tensor(835))
  call G_TensorShift(G1tensor(832),4)
  call Hotf_4pt_reduction_last(G2tensor(631),RedSet_4(163),mass4set(:,3),  & 
G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(837),8)
  call Hotf_4pt_reduction_last(G2tensor(997),RedSet_4(166),mass4set(:,1),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845))
  call G_TensorShift(G1tensor(842),8)
  call Hotf_4pt_reduction_last(G2tensor(955),RedSet_4(167),mass4set(:,4),  & 
G1tensor(846),G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850))
  call G_TensorShift(G1tensor(847),8)
  call Hotf_4pt_reduction_last(G2tensor(1003),RedSet_4(170),mass4set(:,1),  & 
G1tensor(851),G1tensor(852),G1tensor(853),G1tensor(854),G1tensor(855))
  call G_TensorShift(G1tensor(852),8)
  call Hotf_4pt_reduction_last(G2tensor(1006),RedSet_4(175),mass4set(:,1),  & 
G1tensor(856),G1tensor(857),G1tensor(858),G1tensor(859),G1tensor(860))
  call G_TensorShift(G1tensor(857),4)
  call Hotf_4pt_reduction_last(G2tensor(964),RedSet_4(176),mass4set(:,4),  & 
G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864),G1tensor(865))
  call G_TensorShift(G1tensor(862),4)
  call Hotf_4pt_reduction_last(G2tensor(1012),RedSet_4(178),mass4set(:,1),  & 
G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(867),4)
  call Hotf_4pt_reduction_last(G2tensor(973),RedSet_4(181),mass4set(:,4),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875))
  call G_TensorShift(G1tensor(872),16)
  call Hotf_4pt_reduction_last(G2tensor(634),RedSet_4(182),mass4set(:,4),  & 
G1tensor(876),G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880))
  call G_TensorShift(G1tensor(877),16)
  call Hotf_4pt_reduction_last(G2tensor(640),RedSet_4(185),mass4set(:,3),  & 
G1tensor(881),G1tensor(882),G1tensor(883),G1tensor(884),G1tensor(885))
  call G_TensorShift(G1tensor(882),16)
  call Hotf_4pt_reduction_last(G2tensor(979),RedSet_4(190),mass4set(:,4),  & 
G1tensor(886),G1tensor(887),G1tensor(888),G1tensor(889),G1tensor(890))
  call G_TensorShift(G1tensor(887),8)
  call Hotf_4pt_reduction_last(G2tensor(643),RedSet_4(191),mass4set(:,4),  & 
G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894),G1tensor(895))
  call G_TensorShift(G1tensor(892),8)
  call Hotf_4pt_reduction_last(G2tensor(649),RedSet_4(193),mass4set(:,3),  & 
G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(897),8)
  call Hotf_4pt_reduction_last(G2tensor(985),RedSet_4(196),mass4set(:,4),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905))
  call G_TensorShift(G1tensor(902),16)
  call Hotf_4pt_reduction_last(G2tensor(991),RedSet_4(201),mass4set(:,4),  & 
G1tensor(906),G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910))
  call G_TensorShift(G1tensor(907),4)
  call Hotf_4pt_reduction_last(G2tensor(652),RedSet_4(202),mass4set(:,4),  & 
G1tensor(911),G1tensor(912),G1tensor(913),G1tensor(914),G1tensor(915))
  call G_TensorShift(G1tensor(912),4)
  call Hotf_4pt_reduction_last(G2tensor(658),RedSet_4(204),mass4set(:,3),  & 
G1tensor(916),G1tensor(917),G1tensor(918),G1tensor(919),G1tensor(920))
  call G_TensorShift(G1tensor(917),4)
  call Hotf_4pt_reduction_last(G2tensor(1000),RedSet_4(207),mass4set(:,4),  & 
G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924),G1tensor(925))
  call G_TensorShift(G1tensor(922),8)
  call Hotf_4pt_reduction_last(G2tensor(1009),RedSet_4(212),mass4set(:,4),  & 
G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(927),4)
  call Hotf_4pt_reduction_last(G2tensor(511),RedSet_4(269),mass4set(:,5),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935))
  call G_TensorShift(G1tensor(932),9)
  call Hotf_4pt_reduction_last(G2tensor(513),RedSet_4(270),mass4set(:,5),  & 
G1tensor(936),G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940))
  call G_TensorShift(G1tensor(937),10)
  call Hotf_4pt_reduction_last(G2tensor(515),RedSet_4(271),mass4set(:,5),  & 
G1tensor(941),G1tensor(942),G1tensor(943),G1tensor(944),G1tensor(945))
  call G_TensorShift(G1tensor(942),17)
  call Hotf_4pt_reduction_last(G2tensor(517),RedSet_4(272),mass4set(:,5),  & 
G1tensor(946),G1tensor(947),G1tensor(948),G1tensor(949),G1tensor(950))
  call G_TensorShift(G1tensor(947),17)
  call Hotf_4pt_reduction_last(G2tensor(519),RedSet_4(273),mass4set(:,5),  & 
G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954),G1tensor(955))
  call G_TensorShift(G1tensor(952),18)
  call Hotf_4pt_reduction_last(G2tensor(521),RedSet_4(274),mass4set(:,5),  & 
G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(957),18)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(263),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(215),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(13),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(264),mass4set(:,5),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(100),RedSet_4(216),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(23),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(265),mass4set(:,5),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(217),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(38),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(266),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(267),mass4set(:,5),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(268),mass4set(:,5),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(235),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(218),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(78),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(224),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(219),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(91),mass4set(:,2),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(4),mass4set(:,2),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(571),RedSet_4(240),mass4set(:,3),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(220),mass4set(:,3),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(113),mass4set(:,3),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(67),RedSet_4(70),mass4set(:,3),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(79),RedSet_4(227),mass4set(:,2),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(558),RedSet_4(221),mass4set(:,2),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(131),mass4set(:,2),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(232),mass4set(:,2),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(222),mass4set(:,2),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(282),RedSet_4(140),mass4set(:,2),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(26),mass4set(:,3),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(414),RedSet_4(135),mass4set(:,3),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(43),mass4set(:,2),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(41),mass4set(:,3),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(248),mass4set(:,3),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(183),RedSet_4(223),mass4set(:,3),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(124),RedSet_4(188),mass4set(:,3),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(126),mass4set(:,3),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(57),mass4set(:,3),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(89),RedSet_4(83),mass4set(:,3),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(1),mass4set(:,3),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(225),mass4set(:,2),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(165),RedSet_4(8),mass4set(:,2),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(226),mass4set(:,2),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(11),mass4set(:,2),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(585),RedSet_4(18),mass4set(:,2),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(228),mass4set(:,2),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(188),RedSet_4(21),mass4set(:,2),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(97),RedSet_4(229),mass4set(:,2),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(127),RedSet_4(29),mass4set(:,2),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(133),RedSet_4(230),mass4set(:,2),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(224),RedSet_4(33),mass4set(:,2),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(231),mass4set(:,2),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(562),RedSet_4(36),mass4set(:,2),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(233),mass4set(:,2),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(46),mass4set(:,2),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(234),mass4set(:,2),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(294),RedSet_4(48),mass4set(:,2),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(290),RedSet_4(52),mass4set(:,2),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(236),mass4set(:,2),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(54),mass4set(:,2),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(342),RedSet_4(237),mass4set(:,2),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(59),mass4set(:,2),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(238),mass4set(:,2),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(362),RedSet_4(62),mass4set(:,2),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(239),mass4set(:,2),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(64),mass4set(:,2),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(241),mass4set(:,3),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(74),mass4set(:,3),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(369),RedSet_4(242),mass4set(:,1),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(76),mass4set(:,1),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(125),RedSet_4(243),mass4set(:,3),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(87),mass4set(:,3),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(244),mass4set(:,1),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(89),mass4set(:,1),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(2),mass4set(:,3),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(474),RedSet_4(3),mass4set(:,1),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(357),RedSet_4(245),mass4set(:,4),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(504),RedSet_4(105),mass4set(:,4),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(512),RedSet_4(246),mass4set(:,1),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(108),mass4set(:,1),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(536),RedSet_4(247),mass4set(:,3),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(285),RedSet_4(111),mass4set(:,3),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(172),RedSet_4(67),mass4set(:,4),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(160),RedSet_4(68),mass4set(:,1),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(215),RedSet_4(69),mass4set(:,3),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(249),mass4set(:,3),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(275),RedSet_4(129),mass4set(:,3),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(184),RedSet_4(250),mass4set(:,3),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(138),mass4set(:,3),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(299),RedSet_4(251),mass4set(:,4),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(144),mass4set(:,4),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(243),RedSet_4(252),mass4set(:,1),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(146),mass4set(:,1),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(262),RedSet_4(253),mass4set(:,3),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(310),RedSet_4(148),mass4set(:,3),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(490),RedSet_4(133),mass4set(:,4),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(81),mass4set(:,1),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(303),RedSet_4(134),mass4set(:,3),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(305),RedSet_4(42),mass4set(:,3),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(389),RedSet_4(254),mass4set(:,4),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(327),RedSet_4(168),mass4set(:,4),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(329),RedSet_4(255),mass4set(:,1),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(443),RedSet_4(171),mass4set(:,1),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(370),RedSet_4(256),mass4set(:,3),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(387),RedSet_4(173),mass4set(:,3),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(405),RedSet_4(160),mass4set(:,4),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(520),RedSet_4(94),mass4set(:,1),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(412),RedSet_4(161),mass4set(:,3),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(424),RedSet_4(257),mass4set(:,4),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(183),mass4set(:,4),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(543),RedSet_4(258),mass4set(:,3),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(550),RedSet_4(186),mass4set(:,3),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(503),RedSet_4(124),mass4set(:,4),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(473),RedSet_4(125),mass4set(:,3),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(485),RedSet_4(259),mass4set(:,4),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(502),RedSet_4(197),mass4set(:,4),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(515),RedSet_4(260),mass4set(:,3),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(532),RedSet_4(199),mass4set(:,3),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(591),RedSet_4(80),mass4set(:,4),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(596),RedSet_4(82),mass4set(:,3),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(601),RedSet_4(261),mass4set(:,4),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(606),RedSet_4(208),mass4set(:,4),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(611),RedSet_4(262),mass4set(:,3),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(616),RedSet_4(210),mass4set(:,3),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(93),mass4set(:,4),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(626),RedSet_4(95),mass4set(:,3),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(6),mass4set(:,3),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(636),RedSet_4(7),mass4set(:,1),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(641),RedSet_4(10),mass4set(:,1),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(16),mass4set(:,3),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(651),RedSet_4(17),mass4set(:,1),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(656),RedSet_4(20),mass4set(:,1),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(27),mass4set(:,3),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(666),RedSet_4(28),mass4set(:,1),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(671),RedSet_4(31),mass4set(:,3),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(676),RedSet_4(32),mass4set(:,1),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(681),RedSet_4(35),mass4set(:,1),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(686),RedSet_4(45),mass4set(:,3),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(51),mass4set(:,3),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(696),RedSet_4(58),mass4set(:,3),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(701),RedSet_4(61),mass4set(:,3),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(706),RedSet_4(72),mass4set(:,1),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(711),RedSet_4(73),mass4set(:,3),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(716),RedSet_4(85),mass4set(:,1),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(86),mass4set(:,3),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(97),mass4set(:,1),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(731),RedSet_4(98),mass4set(:,3),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(736),RedSet_4(102),mass4set(:,1),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(741),RedSet_4(103),mass4set(:,4),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(746),RedSet_4(104),mass4set(:,4),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(751),RedSet_4(107),mass4set(:,1),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(756),RedSet_4(110),mass4set(:,3),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(761),RedSet_4(115),mass4set(:,1),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(766),RedSet_4(116),mass4set(:,4),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(771),RedSet_4(117),mass4set(:,4),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(776),RedSet_4(119),mass4set(:,1),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(781),RedSet_4(121),mass4set(:,3),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(786),RedSet_4(128),mass4set(:,3),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(791),RedSet_4(137),mass4set(:,3),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(796),RedSet_4(142),mass4set(:,1),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(801),RedSet_4(143),mass4set(:,4),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(806),RedSet_4(150),mass4set(:,1),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(811),RedSet_4(151),mass4set(:,4),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(816),RedSet_4(152),mass4set(:,4),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(821),RedSet_4(154),mass4set(:,1),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(826),RedSet_4(155),mass4set(:,1),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(831),RedSet_4(157),mass4set(:,3),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(836),RedSet_4(163),mass4set(:,3),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(841),RedSet_4(166),mass4set(:,1),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call Hotf_4pt_reduction_last(G1tensor(846),RedSet_4(167),mass4set(:,4),  & 
G0tensor(846),G0tensor(847),G0tensor(848),G0tensor(849),G0tensor(850))
  call Hotf_4pt_reduction_last(G1tensor(851),RedSet_4(170),mass4set(:,1),  & 
G0tensor(851),G0tensor(852),G0tensor(853),G0tensor(854),G0tensor(855))
  call Hotf_4pt_reduction_last(G1tensor(856),RedSet_4(175),mass4set(:,1),  & 
G0tensor(856),G0tensor(857),G0tensor(858),G0tensor(859),G0tensor(860))
  call Hotf_4pt_reduction_last(G1tensor(861),RedSet_4(176),mass4set(:,4),  & 
G0tensor(861),G0tensor(862),G0tensor(863),G0tensor(864),G0tensor(865))
  call Hotf_4pt_reduction_last(G1tensor(866),RedSet_4(178),mass4set(:,1),  & 
G0tensor(866),G0tensor(867),G0tensor(868),G0tensor(869),G0tensor(870))
  call Hotf_4pt_reduction_last(G1tensor(871),RedSet_4(181),mass4set(:,4),  & 
G0tensor(871),G0tensor(872),G0tensor(873),G0tensor(874),G0tensor(875))
  call Hotf_4pt_reduction_last(G1tensor(876),RedSet_4(182),mass4set(:,4),  & 
G0tensor(876),G0tensor(877),G0tensor(878),G0tensor(879),G0tensor(880))
  call Hotf_4pt_reduction_last(G1tensor(881),RedSet_4(185),mass4set(:,3),  & 
G0tensor(881),G0tensor(882),G0tensor(883),G0tensor(884),G0tensor(885))
  call Hotf_4pt_reduction_last(G1tensor(886),RedSet_4(190),mass4set(:,4),  & 
G0tensor(886),G0tensor(887),G0tensor(888),G0tensor(889),G0tensor(890))
  call Hotf_4pt_reduction_last(G1tensor(891),RedSet_4(191),mass4set(:,4),  & 
G0tensor(891),G0tensor(892),G0tensor(893),G0tensor(894),G0tensor(895))
  call Hotf_4pt_reduction_last(G1tensor(896),RedSet_4(193),mass4set(:,3),  & 
G0tensor(896),G0tensor(897),G0tensor(898),G0tensor(899),G0tensor(900))
  call Hotf_4pt_reduction_last(G1tensor(901),RedSet_4(196),mass4set(:,4),  & 
G0tensor(901),G0tensor(902),G0tensor(903),G0tensor(904),G0tensor(905))
  call Hotf_4pt_reduction_last(G1tensor(906),RedSet_4(201),mass4set(:,4),  & 
G0tensor(906),G0tensor(907),G0tensor(908),G0tensor(909),G0tensor(910))
  call Hotf_4pt_reduction_last(G1tensor(911),RedSet_4(202),mass4set(:,4),  & 
G0tensor(911),G0tensor(912),G0tensor(913),G0tensor(914),G0tensor(915))
  call Hotf_4pt_reduction_last(G1tensor(916),RedSet_4(204),mass4set(:,3),  & 
G0tensor(916),G0tensor(917),G0tensor(918),G0tensor(919),G0tensor(920))
  call Hotf_4pt_reduction_last(G1tensor(921),RedSet_4(207),mass4set(:,4),  & 
G0tensor(921),G0tensor(922),G0tensor(923),G0tensor(924),G0tensor(925))
  call Hotf_4pt_reduction_last(G1tensor(926),RedSet_4(212),mass4set(:,4),  & 
G0tensor(926),G0tensor(927),G0tensor(928),G0tensor(929),G0tensor(930))
  call Hotf_4pt_reduction_last(G1tensor(931),RedSet_4(269),mass4set(:,5),  & 
G0tensor(931),G0tensor(932),G0tensor(933),G0tensor(934),G0tensor(935))
  call Hotf_4pt_reduction_last(G1tensor(936),RedSet_4(270),mass4set(:,5),  & 
G0tensor(936),G0tensor(937),G0tensor(938),G0tensor(939),G0tensor(940))
  call Hotf_4pt_reduction_last(G1tensor(941),RedSet_4(271),mass4set(:,5),  & 
G0tensor(941),G0tensor(942),G0tensor(943),G0tensor(944),G0tensor(945))
  call Hotf_4pt_reduction_last(G1tensor(946),RedSet_4(272),mass4set(:,5),  & 
G0tensor(946),G0tensor(947),G0tensor(948),G0tensor(949),G0tensor(950))
  call Hotf_4pt_reduction_last(G1tensor(951),RedSet_4(273),mass4set(:,5),  & 
G0tensor(951),G0tensor(952),G0tensor(953),G0tensor(954),G0tensor(955))
  call Hotf_4pt_reduction_last(G1tensor(956),RedSet_4(274),mass4set(:,5),  & 
G0tensor(956),G0tensor(957),G0tensor(958),G0tensor(959),G0tensor(960))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  call ol_merge_tensors(T0sum(170),[G0tensor(846)])
  call ol_merge_tensors(T0sum(171),[G0tensor(851)])
  call ol_merge_tensors(T0sum(172),[G0tensor(856)])
  call ol_merge_tensors(T0sum(173),[G0tensor(861)])
  call ol_merge_tensors(T0sum(174),[G0tensor(866)])
  call ol_merge_tensors(T0sum(175),[G0tensor(871)])
  call ol_merge_tensors(T0sum(176),[G0tensor(876)])
  call ol_merge_tensors(T0sum(177),[G0tensor(881)])
  call ol_merge_tensors(T0sum(178),[G0tensor(886)])
  call ol_merge_tensors(T0sum(179),[G0tensor(891)])
  call ol_merge_tensors(T0sum(180),[G0tensor(896)])
  call ol_merge_tensors(T0sum(181),[G0tensor(901)])
  call ol_merge_tensors(T0sum(182),[G0tensor(906)])
  call ol_merge_tensors(T0sum(183),[G0tensor(911)])
  call ol_merge_tensors(T0sum(184),[G0tensor(916)])
  call ol_merge_tensors(T0sum(185),[G0tensor(921)])
  call ol_merge_tensors(T0sum(186),[G0tensor(926)])
  call ol_merge_tensors(T0sum(187),[G0tensor(931)])
  call ol_merge_tensors(T0sum(188),[G0tensor(936)])
  call ol_merge_tensors(T0sum(189),[G0tensor(941)])
  call ol_merge_tensors(T0sum(190),[G0tensor(946)])
  call ol_merge_tensors(T0sum(191),[G0tensor(951)])
  call ol_merge_tensors(T0sum(192),[G0tensor(956)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,10,21],[nME,0,nME],3,2,wf4(:,4),wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,145))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(97))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[37,10,16],[0,nME,nME],3,2,wf8(:,56),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,56),G0H8(1),m3h8x8(:,25),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,5,26],[nME,0,nME],3,2,wf4(:,3),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,98),heltab2x64(:,:,147))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(98))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[42,5,16],[0,nME,nME],3,2,wf8(:,58),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,58),G0H8(2),m3h8x8(:,26),heltab2x64(:,:,148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,13,18],[nME,0,nME],3,2,wf8(:,9),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,149))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(99))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[37,8,18],[nME,nME,0],3,2,wf8(:,56),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,56),G0H8(3),m3h8x8(:,27),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(3),37,nME,G1H8(36),n2h8(127))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,5,26],[nME,0,nME],3,2,wf4(:,3),wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(100))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[50,5,8],[0,nME,nME],3,2,wf8(:,63),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,63),G0H8(4),m3h8x8(:,28),heltab2x64(:,:,152))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[34,13,16],[0,nME,nME],3,2,wf4(:,8),wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,25),heltab2x64(:,:,153))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[34,8,21],[nME,nME,0],3,2,wf4(:,8),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,26),heltab2x64(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(7),34,nME,G1H16(30),n2h16(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[42,5,16],[0,nME,nME],3,2,wf8(:,14),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,14),G0H8(5),m3h8x8(:,29),heltab2x64(:,:,155))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[50,5,8],[0,nME,nME],3,2,wf8(:,65),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(6),m3h8x8(:,30),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,2,29],[nME,0,nME],3,1,wf16(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,101),heltab2x64(:,:,157))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(188)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[45,2,16],[0,nME,nME],3,1,wf16(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,4),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,2,29],[nME,0,nME],3,1,wf16(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,159))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(102))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(191)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[53,2,8],[0,nME,nME],3,1,wf16(:,8))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,8),G0H4(2),m3h16x4(:,2),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[45,2,16],[0,nME,nME],3,1,wf16(:,10))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,10),G0H4(3),m3h16x4(:,3),heltab2x64(:,:,161))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(193)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[53,2,8],[0,nME,nME],3,1,wf16(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,12),G0H4(4),m3h16x4(:,4),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,6,25],[nME,0,nME],3,2,wf4(:,12),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,163))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(103))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[41,6,16],[0,nME,nME],3,2,wf8(:,69),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,69),G0H8(7),m3h8x8(:,31),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,9,22],[nME,0,nME],3,2,wf4(:,11),wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,104),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(104))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[38,9,16],[0,nME,nME],3,2,wf8(:,71),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(8),m3h8x8(:,32),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,6,25],[nME,0,nME],3,2,wf4(:,12),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,167))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[49,6,8],[0,nME,nME],3,2,wf8(:,75),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,75),G0H8(9),m3h8x8(:,33),heltab2x64(:,:,168))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,14,17],[nME,0,nME],3,2,wf8(:,25),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,106),heltab2x64(:,:,169))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(106))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[38,8,17],[nME,nME,0],3,2,wf8(:,71),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,71),G0H8(10),m3h8x8(:,34),heltab2x64(:,:,170))
  call Hloop_A_Q(ntryL,G0H8(10),38,nME,G1H8(70),n2h8(128))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[41,6,16],[0,nME,nME],3,2,wf8(:,27),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,27),G0H8(11),m3h8x8(:,35),heltab2x64(:,:,171))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[49,6,8],[0,nME,nME],3,2,wf8(:,77),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,77),G0H8(12),m3h8x8(:,36),heltab2x64(:,:,172))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[33,14,16],[0,nME,nME],3,2,wf4(:,16),wf8(:,25))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(9),m3h4x16(:,27),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[33,8,22],[nME,nME,0],3,2,wf4(:,16),wf8(:,20))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(10),m3h4x16(:,28),heltab2x64(:,:,174))
  call Hloop_Q_A(ntryL,G0H16(10),33,nME,G1H16(31),n2h16(64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(195)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,1,30],[nME,0,nME],3,1,wf16(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(107))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(197)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[46,1,16],[0,nME,nME],3,1,wf16(:,16))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,16),G0H4(5),m3h16x4(:,5),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(198)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,1,30],[nME,0,nME],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,108),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(108))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[54,1,8],[0,nME,nME],3,1,wf16(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,20),G0H4(6),m3h16x4(:,6),heltab2x64(:,:,178))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[46,1,16],[0,nME,nME],3,1,wf16(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,22),G0H4(7),m3h16x4(:,7),heltab2x64(:,:,179))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[54,1,8],[0,nME,nME],3,1,wf16(:,24))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,24),G0H4(8),m3h16x4(:,8),heltab2x64(:,:,180))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,13,18],[nME,0,nME],3,2,wf8(:,30),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,109),heltab2x64(:,:,181))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[41,4,18],[nME,nME,0],3,2,wf8(:,69),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,69),G0H8(13),m3h8x8(:,37),heltab2x64(:,:,182))
  call Hloop_Q_A(ntryL,G0H8(13),41,nME,G1H8(41),n2h8(129))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,9,22],[nME,0,nME],3,2,wf4(:,11),wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,110),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(110))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[50,4,9],[nME,nME,0],3,2,wf8(:,63),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,63),G0H8(14),m3h8x8(:,38),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(14),50,nME,G1H8(49),n2h8(130))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[34,13,16],[0,nME,nME],3,2,wf4(:,8),wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(11),m3h4x16(:,29),heltab2x64(:,:,185))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[34,4,25],[nME,nME,0],3,2,wf4(:,8),wf8(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,30),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H16(12),34,nME,G1H16(32),n2h16(65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[38,9,16],[0,nME,nME],3,2,wf8(:,34),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,34),G0H8(19),m3h8x8(:,39),heltab2x64(:,:,187))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[50,4,9],[nME,nME,0],3,2,wf8(:,65),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,65),G0H8(20),m3h8x8(:,40),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(20),50,nME,G1H8(59),n2h8(131))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,2,29],[nME,0,nME],3,1,wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,189))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[45,2,16],[0,nME,nME],3,1,wf16(:,28))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,28),G0H4(9),m3h16x4(:,9),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,2,29],[nME,0,nME],3,1,wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,191))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(112))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[57,2,4],[0,nME,nME],3,1,wf16(:,32))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,32),G0H4(10),m3h16x4(:,10),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[45,2,16],[0,nME,nME],3,1,wf16(:,34))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,34),G0H4(11),m3h16x4(:,11),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[57,2,4],[0,nME,nME],3,1,wf16(:,36))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,36),G0H4(12),m3h16x4(:,12),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,10,21],[nME,0,nME],3,2,wf4(:,4),wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(113))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[49,4,10],[nME,nME,0],3,2,wf8(:,75),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,75),G0H8(15),m3h8x8(:,41),heltab2x64(:,:,196))
  call Hloop_Q_A(ntryL,G0H8(15),49,nME,G1H8(67),n2h8(132))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,14,17],[nME,0,nME],3,2,wf8(:,38),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,114),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(18),n2h32(114))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[42,4,17],[nME,nME,0],3,2,wf8(:,58),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,58),G0H8(16),m3h8x8(:,42),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G0H8(16),42,nME,G1H8(77),n2h8(133))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[37,10,16],[0,nME,nME],3,2,wf8(:,40),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,40),G0H8(21),m3h8x8(:,43),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[49,4,10],[nME,nME,0],3,2,wf8(:,77),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,77),G0H8(22),m3h8x8(:,44),heltab2x64(:,:,200))
  call Hloop_Q_A(ntryL,G0H8(22),49,nME,G1H8(85),n2h8(134))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[33,14,16],[0,nME,nME],3,2,wf4(:,16),wf8(:,38))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,201))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[33,4,26],[nME,nME,0],3,2,wf4(:,16),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(2),m3h4x16(:,32),heltab2x64(:,:,202))
  call Hloop_Q_A(ntryL,G0H16(2),33,nME,G1H16(8),n2h16(66))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,1,30],[nME,0,nME],3,1,wf16(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[46,1,16],[0,nME,nME],3,1,wf16(:,40))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,40),G0H4(13),m3h16x4(:,13),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(212)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,1,30],[nME,0,nME],3,1,wf16(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,116),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(20),n2h32(116))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[58,1,4],[0,nME,nME],3,1,wf16(:,44))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,44),G0H4(14),m3h16x4(:,14),heltab2x64(:,:,206))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[46,1,16],[0,nME,nME],3,1,wf16(:,46))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,46),G0H4(15),m3h16x4(:,15),heltab2x64(:,:,207))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(216)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[58,1,4],[0,nME,nME],3,1,wf16(:,48))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,48),G0H4(16),m3h16x4(:,16),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[34,8,21],[nME,nME,0],3,2,wf4(:,8),wf8(:,36))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(3),m3h4x16(:,33),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(3),34,nME,G1H16(11),n2h16(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[34,4,25],[nME,nME,0],3,2,wf4(:,8),wf8(:,22))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,34),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(4),34,nME,G1H16(12),n2h16(68))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[38,8,17],[nME,nME,0],3,2,wf8(:,34),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,34),G0H8(17),m3h8x8(:,45),heltab2x64(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(17),38,nME,G1H8(19),n2h8(135))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[42,4,17],[nME,nME,0],3,2,wf8(:,14),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,14),G0H8(18),m3h8x8(:,46),heltab2x64(:,:,212))
  call Hloop_A_Q(ntryL,G0H8(18),42,nME,G1H8(76),n2h8(136))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,29],[nME,0,nME],3,1,wf16(:,50))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,213))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(117))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[53,2,8],[0,nME,nME],3,1,wf16(:,52))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,52),G0H4(17),m3h16x4(:,17),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,29],[nME,0,nME],3,1,wf16(:,54))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,118),heltab2x64(:,:,215))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(22),n2h32(118))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[57,2,4],[0,nME,nME],3,1,wf16(:,56))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,56),G0H4(18),m3h16x4(:,18),heltab2x64(:,:,216))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[53,2,8],[0,nME,nME],3,1,wf16(:,58))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,58),G0H4(19),m3h16x4(:,19),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[57,2,4],[0,nME,nME],3,1,wf16(:,60))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,60),G0H4(20),m3h16x4(:,20),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[37,8,18],[nME,nME,0],3,2,wf8(:,40),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,40),G0H8(23),m3h8x8(:,47),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G0H8(23),37,nME,G1H8(20),n2h8(137))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[41,4,18],[nME,nME,0],3,2,wf8(:,27),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,27),G0H8(24),m3h8x8(:,48),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G0H8(24),41,nME,G1H8(82),n2h8(138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[33,8,22],[nME,nME,0],3,2,wf4(:,16),wf8(:,32))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(5),m3h4x16(:,35),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H16(5),33,nME,G1H16(38),n2h16(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[33,4,26],[nME,nME,0],3,2,wf4(:,16),wf8(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(8),m3h4x16(:,36),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H16(8),33,nME,G1H16(15),n2h16(70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,1,30],[nME,0,nME],3,1,wf16(:,62))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(23),n2h32(119))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(224)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[54,1,8],[0,nME,nME],3,1,wf16(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,64),G0H4(21),m3h16x4(:,21),heltab2x64(:,:,224))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(225)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,1,30],[nME,0,nME],3,1,wf16(:,66))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(24),n2h32(120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(226)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[58,1,4],[0,nME,nME],3,1,wf16(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,68),G0H4(22),m3h16x4(:,22),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[54,1,8],[0,nME,nME],3,1,wf16(:,70))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,70),G0H4(23),m3h16x4(:,23),heltab2x64(:,:,227))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[58,1,4],[0,nME,nME],3,1,wf16(:,72))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,72),G0H4(24),m3h16x4(:,24),heltab2x64(:,:,228))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[45,2,16],[0,nME,nME],3,1,wf16(:,74))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,74),G0H4(25),m3h16x4(:,25),heltab2x64(:,:,229))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[53,2,8],[0,nME,nME],3,1,wf16(:,76))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,76),G0H4(26),m3h16x4(:,26),heltab2x64(:,:,230))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[45,2,16],[0,nME,nME],3,1,wf16(:,78))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,78),G0H4(27),m3h16x4(:,27),heltab2x64(:,:,231))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[57,2,4],[0,nME,nME],3,1,wf16(:,80))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,80),G0H4(28),m3h16x4(:,28),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[53,2,8],[0,nME,nME],3,1,wf16(:,82))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,82),G0H4(29),m3h16x4(:,29),heltab2x64(:,:,233))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[57,2,4],[0,nME,nME],3,1,wf16(:,84))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,84),G0H4(30),m3h16x4(:,30),heltab2x64(:,:,234))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[46,1,16],[0,nME,nME],3,1,wf16(:,86))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,86),G0H4(31),m3h16x4(:,31),heltab2x64(:,:,235))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[54,1,8],[0,nME,nME],3,1,wf16(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,88),G0H4(32),m3h16x4(:,32),heltab2x64(:,:,236))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[46,1,16],[0,nME,nME],3,1,wf16(:,90))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,90),G0H4(33),m3h16x4(:,33),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(238)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[58,1,4],[0,nME,nME],3,1,wf16(:,92))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,92),G0H4(34),m3h16x4(:,34),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[54,1,8],[0,nME,nME],3,1,wf16(:,94))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,94),G0H4(35),m3h16x4(:,35),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[58,1,4],[0,nME,nME],3,1,wf16(:,96))
  call Hloop_QA_V(ntryL,G0H64(1),wf16(:,96),G0H4(36),m3h16x4(:,36),heltab2x64(:,:,240))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(77),G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(70),G1H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(36),G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(41),G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(27),[G0H4(25),G0H4(11),G0H4(9),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(26),G0H4(19),G0H4(17),G0H4(4),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(33),[G0H4(31),G0H4(15),G0H4(13),G0H4(7),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(35),[G0H4(32),G0H4(23),G0H4(21),G0H4(8),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(30),[G0H4(28),G0H4(20),G0H4(18),G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(36),[G0H4(34),G0H4(24),G0H4(22),G0H4(16),G0H4(14)])
  call Hloop_AV_Q(ntryL,G1H4(104),ex3(:),G1H2(197),m3h2x2(:,643),heltab2x4(:,:,755))
  call Hloop_A_Q(ntryL,G1H2(197),62,nME,G2H2(79),n2h2(523))
  call Hloop_AV_Q(ntryL,G1H4(53),ex4(:),G1H2(1014),m3h2x2(:,644),heltab2x4(:,:,756))
  call Hloop_A_Q(ntryL,G1H2(1014),62,nME,G2H2(519),n2h2(524))
  call Hloop_QV_A(ntryL,G1H4(75),ex5(:),G1H2(218),m3h2x2(:,645),heltab2x4(:,:,757))
  call Hloop_Q_A(ntryL,G1H2(218),61,nME,G2H2(82),n2h2(525))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(1019),m3h2x2(:,646),heltab2x4(:,:,758))
  call Hloop_Q_A(ntryL,G1H2(1019),61,nME,G2H2(84),n2h2(526))
  call Hloop_QV_A(ntryL,G1H4(233),ex4(:),G1H2(219),m3h2x2(:,647),heltab2x4(:,:,759))
  call Hloop_Q_A(ntryL,G1H2(219),61,nME,G2H2(87),n2h2(527))
  call Hloop_AV_Q(ntryL,G1H4(10),ex5(:),G1H2(884),m3h2x2(:,648),heltab2x4(:,:,760))
  call Hloop_A_Q(ntryL,G1H2(884),62,nME,G2H2(89),n2h2(528))
  call Hloop_AV_Q(ntryL,G1H8(53),ex5(:),G1H4(393),m3h2x4(:,237),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(393),54,nME,G2H4(32),n2h4(303))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(394),m3h2x4(:,238),heltab2x8(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(394),53,nME,G2H4(91),n2h4(304))
  call Hloop_AV_Q(ntryL,G1H8(76),ex3(:),G1H4(395),m3h2x4(:,239),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(395),46,nME,G2H4(36),n2h4(305))
  call Hloop_AV_Q(ntryL,G1H8(19),ex4(:),G1H4(398),m3h2x4(:,240),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(398),46,nME,G2H4(90),n2h4(306))
  call Hloop_QV_A(ntryL,G1H8(20),ex4(:),G1H4(399),m3h2x4(:,241),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G1H4(399),45,nME,G2H4(40),n2h4(307))
  call Hloop_QV_A(ntryL,G1H8(82),ex3(:),G1H4(165),m3h2x4(:,242),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(165),45,nME,G2H4(41),n2h4(308))
  call Hloop_QA_V(ntryL,G1H32(1),wf4(:,4),G1H8(23),m3h4x8(:,13),heltab2x32(:,:,97))
  call Hloop_VA_Q(ntryL,G0H8(21),wf4(:,4),G0H2(1),m3h4x2(:,37),heltab2x8(:,:,303))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(220),n2h2(529))
  call Hloop_AQ_V(ntryL,G1H32(2),wf4(:,3),G1H8(88),m3h4x8(:,14),heltab2x32(:,:,98))
  call Hloop_VQ_A(ntryL,G0H8(5),wf4(:,3),G0H2(1),m3h4x2(:,38),heltab2x8(:,:,304))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(235),n2h2(530))
  call Hloop_AQ_V(ntryL,G1H32(3),wf8(:,9),G1H4(166),m3h8x4(:,5),heltab2x32(:,:,99))
  call Hloop_AQ_V(ntryL,G1H32(4),wf4(:,3),G1H8(37),m3h4x8(:,15),heltab2x32(:,:,100))
  call Hloop_VQ_A(ntryL,G0H8(6),wf4(:,3),G0H2(1),m3h4x2(:,39),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(236),n2h2(531))
  call Hloop_VQ_A(ntryL,G0H16(6),wf8(:,9),G0H2(1),m3h8x2(:,13),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(1024),n2h2(532))
  call Hloop_AV_Q(ntryL,G1H16(30),ex4(:),G1H8(38),m3h2x8(:,117),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(38),42,nME,G2H8(4),n2h8(139))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(5),m3h2x16(:,81),heltab2x32(:,:,101))
  call Hloop_VA_Q(ntryL,G0H4(27),ex2(:),G0H2(1),m3h2x2(:,649),heltab2x4(:,:,761))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(240),n2h2(533))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(16),m3h2x16(:,82),heltab2x32(:,:,102))
  call Hloop_VA_Q(ntryL,G0H4(29),ex2(:),G0H2(1),m3h2x2(:,650),heltab2x4(:,:,762))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(1029),n2h2(534))
  call Hloop_QA_V(ntryL,G1H32(7),wf4(:,12),G1H8(42),m3h4x8(:,16),heltab2x32(:,:,103))
  call Hloop_VA_Q(ntryL,G0H8(11),wf4(:,12),G0H2(1),m3h4x2(:,40),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(241),n2h2(535))
  call Hloop_AQ_V(ntryL,G1H32(8),wf4(:,11),G1H8(43),m3h4x8(:,17),heltab2x32(:,:,104))
  call Hloop_VQ_A(ntryL,G0H8(19),wf4(:,11),G0H2(1),m3h4x2(:,41),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(889),n2h2(536))
  call Hloop_QA_V(ntryL,G1H32(9),wf4(:,12),G1H8(44),m3h4x8(:,18),heltab2x32(:,:,105))
  call Hloop_VA_Q(ntryL,G0H8(12),wf4(:,12),G0H2(1),m3h4x2(:,42),heltab2x8(:,:,308))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(242),n2h2(537))
  call Hloop_QA_V(ntryL,G1H32(10),wf8(:,25),G1H4(401),m3h8x4(:,6),heltab2x32(:,:,106))
  call Hloop_VA_Q(ntryL,G0H16(9),wf8(:,25),G0H2(1),m3h8x2(:,14),heltab2x16(:,:,167))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(262),n2h2(538))
  call Hloop_QV_A(ntryL,G1H16(31),ex4(:),G1H8(47),m3h2x8(:,118),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(47),41,nME,G2H8(5),n2h8(140))
  call Hloop_AQ_V(ntryL,G1H32(11),ex1(:),G1H16(26),m3h2x16(:,83),heltab2x32(:,:,107))
  call Hloop_VQ_A(ntryL,G0H4(33),ex1(:),G0H2(1),m3h2x2(:,651),heltab2x4(:,:,763))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(263),n2h2(539))
  call Hloop_AQ_V(ntryL,G1H32(12),ex1(:),G1H16(7),m3h2x16(:,84),heltab2x32(:,:,108))
  call Hloop_VQ_A(ntryL,G0H4(35),ex1(:),G0H2(1),m3h2x2(:,652),heltab2x4(:,:,764))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(967),n2h2(540))
  call Hloop_AQ_V(ntryL,G1H32(13),wf8(:,30),G1H4(402),m3h8x4(:,7),heltab2x32(:,:,109))
  call Hloop_AQ_V(ntryL,G1H32(14),wf4(:,11),G1H8(58),m3h4x8(:,19),heltab2x32(:,:,110))
  call Hloop_AV_Q(ntryL,G1H8(59),ex3(:),G1H4(403),m3h2x4(:,243),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G1H4(403),54,nME,G2H4(44),n2h4(309))
  call Hloop_VQ_A(ntryL,G0H16(11),wf8(:,30),G0H2(1),m3h8x2(:,15),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(279),n2h2(541))
  call Hloop_AV_Q(ntryL,G1H16(32),ex3(:),G1H8(93),m3h2x8(:,119),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(93),38,nME,G2H8(7),n2h8(141))
  call Hloop_QA_V(ntryL,G1H32(15),ex2(:),G1H16(33),m3h2x16(:,85),heltab2x32(:,:,111))
  call Hloop_QA_V(ntryL,G1H32(16),ex2(:),G1H16(36),m3h2x16(:,86),heltab2x32(:,:,112))
  call Hloop_VA_Q(ntryL,G0H4(30),ex2(:),G0H2(1),m3h2x2(:,653),heltab2x4(:,:,765))
  call Hloop_A_Q(ntryL,G0H2(1),59,nME,G1H2(284),n2h2(542))
  call Hloop_QA_V(ntryL,G1H32(17),wf4(:,4),G1H8(11),m3h4x8(:,20),heltab2x32(:,:,113))
  call Hloop_QV_A(ntryL,G1H8(85),ex3(:),G1H4(404),m3h2x4(:,244),heltab2x8(:,:,310))
  call Hloop_Q_A(ntryL,G1H4(404),53,nME,G2H4(45),n2h4(310))
  call Hloop_QA_V(ntryL,G1H32(18),wf8(:,38),G1H4(407),m3h8x4(:,8),heltab2x32(:,:,114))
  call Hloop_VA_Q(ntryL,G0H16(1),wf8(:,38),G0H2(1),m3h8x2(:,16),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(285),n2h2(543))
  call Hloop_QV_A(ntryL,G1H16(8),ex3(:),G1H8(28),m3h2x8(:,120),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H8(28),37,nME,G2H8(8),n2h8(142))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(39),m3h2x16(:,87),heltab2x32(:,:,115))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(42),m3h2x16(:,88),heltab2x32(:,:,116))
  call Hloop_VQ_A(ntryL,G0H4(36),ex1(:),G0H2(1),m3h2x2(:,654),heltab2x4(:,:,766))
  call Hloop_Q_A(ntryL,G0H2(1),59,nME,G1H2(312),n2h2(544))
  call Hloop_AV_Q(ntryL,G1H16(11),ex4(:),G1H8(46),m3h2x8(:,121),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(46),42,nME,G2H8(9),n2h8(143))
  call Hloop_AV_Q(ntryL,G1H16(12),ex3(:),G1H8(64),m3h2x8(:,122),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(64),38,nME,G2H8(11),n2h8(144))
  call Hloop_QA_V(ntryL,G1H32(21),ex2(:),G1H16(44),m3h2x16(:,89),heltab2x32(:,:,117))
  call Hloop_QA_V(ntryL,G1H32(22),ex2(:),G1H16(19),m3h2x16(:,90),heltab2x32(:,:,118))
  call Hloop_QV_A(ntryL,G1H16(38),ex4(:),G1H8(51),m3h2x8(:,123),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H8(51),41,nME,G2H8(12),n2h8(145))
  call Hloop_QV_A(ntryL,G1H16(15),ex3(:),G1H8(24),m3h2x8(:,124),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(24),37,nME,G2H8(13),n2h8(146))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(17),m3h2x16(:,91),heltab2x32(:,:,119))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(29),m3h2x16(:,92),heltab2x32(:,:,120))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(987),G1H2(864),G1H2(66),G1H2(109)])
call HGT_w2_OLR(G1H2(132),1,1,2)
call HGT_w2_invQ_OLR(G1H2(132),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(859),[G1H2(16),G1H2(341),G1H2(822),G1H2(792)])
call HGT_w2_OLR(G1H2(114),1,1,2)
call HGT_w2_invQ_OLR(G1H2(114),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(859)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(133),G1H2(617),G1H2(397),G1H2(347)])
call HGT_w2_OLR(G1H2(90),1,1,2)
call HGT_w2_invQ_OLR(G1H2(90),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(555),[G1H2(180),G1H2(81),G1H2(552),G1H2(522)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(477),G1H2(368),G1H2(292),G1H2(232)])
call HGT_w2_OLR(G1H2(69),1,1,2)
call HGT_w2_invQ_OLR(G1H2(69),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(443),[G1H2(411),G1H2(791),G1H2(79),G1H2(139)])
call HGT_w2_OLR(G1H2(108),1,1,2)
call HGT_w2_invQ_OLR(G1H2(108),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(981),[G1H2(113),G1H2(63),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(61),[G1H2(188),G1H2(835),G1H2(101),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(428),[G1H2(302),G1H2(527),G1H2(583),G1H2(572),G1H2(482) &
    ,G1H2(353),G1H2(150),G1H2(88),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(539),[G1H2(67),G1H2(338),G1H2(136),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(812),[G1H2(800),G1H2(168),G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(768),G1H2(542),G1H2(183),G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(821),G1H2(423),G1H2(553),G1H2(463),G1H2(448) &
    ,G1H2(184),G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(950),[G1H2(239),G1H2(216),G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(648),[G1H2(413),G1H2(315),G1H2(233),G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(773),[G1H2(231),G1H2(185),G1H2(845),G1H2(420),G1H2(408) &
    ,G1H2(332),G1H2(260),G1H2(227),G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(618),G1H2(493),G1H2(250),G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(931),[G1H2(740),G1H2(278),G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(599),[G1H2(142),G1H2(365),G1H2(294),G1H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(665),G1H2(701),G1H2(613),G1H2(602),G1H2(377) &
    ,G1H2(298),G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(235),[G1H2(358),G1H2(321),G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(220),[G1H2(629),G1H2(349),G1H2(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(509),[G1H2(381),G1H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(725),G1H2(404),G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(1024),G1H2(23),G1H2(683),G1H2(419) &
    ,G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(537),[G1H2(374),G1H2(447),G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(465),[G1H2(755),G1H2(459),G1H2(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(241),[G1H2(140),G1H2(481),G1H2(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(889),[G1H2(588),G1H2(500),G1H2(965)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(82),[G1H2(203),G1H2(980),G1H2(511)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(495),G1H2(530),G1H2(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(224),[G1H2(507),G1H2(985),G1H2(523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(738),[G1H2(995),G1H2(541)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(561),[G1H2(633),G1H2(571),G1H2(560)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(262),G1H2(444),G1H2(323),G1H2(875) &
    ,G1H2(1000)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(687),G1H2(601),G1H2(590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(854),[G1H2(388),G1H2(1025),G1H2(1015)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(198),[G1H2(20),G1H2(631),G1H2(620)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(264),G1H2(895),G1H2(1030)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(104),G1H2(643),G1H2(632)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(733),[G1H2(650)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1031),[G1H2(662),G1H2(1045)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1110),[G1H2(661)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1056),[G1H2(1055)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1081),[G1H2(673)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(793),[G1H2(680)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1106),[G1H2(692),G1H2(1060)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1075),[G1H2(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1131),[G1H2(1070)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(56),[G1H2(703)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(359),[G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(363),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(371),[G1H4(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(401),G1H4(377),G1H4(306),G1H4(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(384),[G1H4(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(353),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(402),[G1H4(166),G1H4(141),G1H4(322),G1H4(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1101),[G1H2(1076),G1H2(1051),G1H2(1120),G1H2(710)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(752),[G1H2(721)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(558),[G1H2(144),G1H2(823),G1H2(722)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(1126),G1H2(1026),G1H2(770),G1H2(1085)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(828),[G1H2(131),G1H2(906),G1H2(925)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(126),G1H2(751)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(236),[G1H2(248),G1H2(930)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(498),[G1H2(303),G1H2(1125),G1H2(763)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(881),[G1H2(781)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(181),[G1H2(468),G1H2(956),G1H2(782)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(967),[G1H2(141),G1H2(187),G1H2(492),G1H2(811)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(528),[G1H2(1135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(587),G1H2(456),G1H2(642),G1H2(830)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(678),[G1H2(851)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(708),[G1H2(856)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(284),[G1H2(457),G1H2(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(242),[G1H2(798),G1H2(901)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1029),[G1H2(229),G1H2(659),G1H2(100),G1H2(926)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(951)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(240),[G1H2(94),G1H2(641),G1H2(182),G1H2(976)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(491),[G1H2(1001)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(1006)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(372),[G1H2(328),G1H2(307),G1H2(612),G1H2(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(519),[G1H2(269),G1H2(125),G1H2(702),G1H2(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(396),[G1H2(809),G1H2(743),G1H2(762),G1H2(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(513),[G1H2(290),G1H2(252),G1H2(479),G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(176),[G1H2(839),G1H2(455),G1H2(689),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(621),[G1H2(355),G1H2(713),G1H2(515),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(362),[G1H4(70),G1H4(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(370),[G1H4(366),G1H4(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(383),[G1H4(118),G1H4(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(387),G1H4(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(57)])
  call Hloop_AV_Q(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,1085),heltab2x2(:,:,1085))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(396),n2h1(1197))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(59),ex1(:),G2tensor(3),m3h2x1(:,1086),heltab2x2(:,:,1086))
  call Hloop_AV_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,1087),heltab2x2(:,:,1087))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(51),n2h1(1198))
  call Hloop_QV_A(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,1088),heltab2x2(:,:,1088))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(1199))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(511),ex2(:),G2tensor(5),m3h2x1(:,1089),heltab2x2(:,:,1089))
  call Hloop_QV_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,1090),heltab2x2(:,:,1090))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(389),n2h1(1200))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(88),ex2(:),G2tensor(54),m3h2x1(:,1091),heltab2x2(:,:,1091))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,1092),heltab2x2(:,:,1092))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(1201))
  call Hloop_AV_Q(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,1093),heltab2x2(:,:,1093))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(400),n2h1(1202))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(77),ex1(:),G2tensor(19),m3h2x1(:,1094),heltab2x2(:,:,1094))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(10),wf4(:,11),G2tensor(59),m3h4x1(:,113),heltab2x4(:,:,767))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(13),wf4(:,4),G2tensor(25),m3h4x1(:,114),heltab2x4(:,:,768))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(98),wf4(:,14),G2tensor(21),m3h4x1(:,115),heltab2x4(:,:,769))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(28),wf4(:,6),G2tensor(393),m3h4x1(:,116),heltab2x4(:,:,770))
  call Hloop_AV_Q(ntryL,G1H2(981),ex5(:),G1H1(1),m3h2x1(:,1095),heltab2x2(:,:,1095))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(62),n2h1(1203))
  call Hloop_AV_Q(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,1096),heltab2x2(:,:,1096))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(27),n2h1(1204))
  call Hloop_AV_Q(ntryL,G1H2(428),ex5(:),G1H1(1),m3h2x1(:,1097),heltab2x2(:,:,1097))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(380),n2h1(1205))
  call Hloop_AV_Q(ntryL,G1H2(539),ex5(:),G1H1(1),m3h2x1(:,1098),heltab2x2(:,:,1098))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(35),n2h1(1206))
  call Hloop_QV_A(ntryL,G1H2(812),ex4(:),G1H1(1),m3h2x1(:,1099),heltab2x2(:,:,1099))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(67),n2h1(1207))
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,1100),heltab2x2(:,:,1100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(41),n2h1(1208))
  call Hloop_QV_A(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,1101),heltab2x2(:,:,1101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(1209))
  call Hloop_QV_A(ntryL,G1H2(950),ex5(:),G1H1(1),m3h2x1(:,1102),heltab2x2(:,:,1102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(381),n2h1(1210))
  call Hloop_QV_A(ntryL,G1H2(648),ex5(:),G1H1(1),m3h2x1(:,1103),heltab2x2(:,:,1103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(70),n2h1(1211))
  call Hloop_QV_A(ntryL,G1H2(773),ex5(:),G1H1(1),m3h2x1(:,1104),heltab2x2(:,:,1104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(1212))
  call Hloop_QV_A(ntryL,G1H2(207),ex5(:),G1H1(1),m3h2x1(:,1105),heltab2x2(:,:,1105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(388),n2h1(1213))
  call Hloop_AV_Q(ntryL,G1H2(931),ex4(:),G1H1(1),m3h2x1(:,1106),heltab2x2(:,:,1106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(50),n2h1(1214))
  call Hloop_AV_Q(ntryL,G1H2(599),ex4(:),G1H1(1),m3h2x1(:,1107),heltab2x2(:,:,1107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(392),n2h1(1215))
  call Hloop_AV_Q(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,1108),heltab2x2(:,:,1108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(58),n2h1(1216))
  call Hloop_QV_A(ntryL,G1H2(235),ex5(:),G1H1(1),m3h2x1(:,1109),heltab2x2(:,:,1109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(384),n2h1(1217))
  call Hloop_AV_Q(ntryL,G1H2(220),ex5(:),G1H1(1),m3h2x1(:,1110),heltab2x2(:,:,1110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(66),n2h1(1218))
  call Hloop_AV_Q(ntryL,G1H2(509),ex4(:),G1H1(1),m3h2x1(:,1111),heltab2x2(:,:,1111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(221),n2h1(1219))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,1112),heltab2x2(:,:,1112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(74),n2h1(1220))
  call Hloop_QV_A(ntryL,G1H2(279),ex5(:),G1H1(1),m3h2x1(:,1113),heltab2x2(:,:,1113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(77),n2h1(1221))
  call Hloop_QV_A(ntryL,G1H2(537),ex4(:),G1H1(1),m3h2x1(:,1114),heltab2x2(:,:,1114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(75),n2h1(1222))
  call Hloop_QV_A(ntryL,G1H2(465),ex4(:),G1H1(1),m3h2x1(:,1115),heltab2x2(:,:,1115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1039),n2h1(1223))
  call Hloop_AV_Q(ntryL,G1H2(241),ex5(:),G1H1(1),m3h2x1(:,1116),heltab2x2(:,:,1116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(78),n2h1(1224))
  call Hloop_QV_A(ntryL,G1H2(889),ex5(:),G1H1(1),m3h2x1(:,1117),heltab2x2(:,:,1117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(90),n2h1(1225))
  call Hloop_QV_A(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,1118),heltab2x2(:,:,1118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(82),n2h1(1226))
  call Hloop_QV_A(ntryL,G1H2(201),ex3(:),G1H1(1),m3h2x1(:,1119),heltab2x2(:,:,1119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(85),n2h1(1227))
  call Hloop_QV_A(ntryL,G1H2(224),ex3(:),G1H1(1),m3h2x1(:,1120),heltab2x2(:,:,1120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(83),n2h1(1228))
  call Hloop_QV_A(ntryL,G1H2(738),ex4(:),G1H1(1),m3h2x1(:,1121),heltab2x2(:,:,1121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1048),n2h1(1229))
  call Hloop_AV_Q(ntryL,G1H2(561),ex5(:),G1H1(1),m3h2x1(:,1122),heltab2x2(:,:,1122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(94),n2h1(1230))
  call Hloop_AV_Q(ntryL,G1H2(285),ex5(:),G1H1(1),m3h2x1(:,1123),heltab2x2(:,:,1123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(86),n2h1(1231))
  call Hloop_AV_Q(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,1124),heltab2x2(:,:,1124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(93),n2h1(1232))
  call Hloop_AV_Q(ntryL,G1H2(854),ex4(:),G1H1(1),m3h2x1(:,1125),heltab2x2(:,:,1125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(91),n2h1(1233))
  call Hloop_AV_Q(ntryL,G1H2(198),ex3(:),G1H1(1),m3h2x1(:,1126),heltab2x2(:,:,1126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(106),n2h1(1234))
  call Hloop_AV_Q(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,1127),heltab2x2(:,:,1127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(98),n2h1(1235))
  call Hloop_AV_Q(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,1128),heltab2x2(:,:,1128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(101),n2h1(1236))
  call Hloop_VA_Q(ntryL,G1H2(733),ex2(:),G1H1(1),m3h2x1(:,1129),heltab2x2(:,:,1129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(99),n2h1(1237))
  call Hloop_VA_Q(ntryL,G1H2(1031),ex2(:),G1H1(1),m3h2x1(:,1130),heltab2x2(:,:,1130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(110),n2h1(1238))
  call Hloop_VA_Q(ntryL,G1H2(1110),ex2(:),G1H1(1),m3h2x1(:,1131),heltab2x2(:,:,1131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(102),n2h1(1239))
  call Hloop_VQ_A(ntryL,G1H2(1056),ex1(:),G1H1(1),m3h2x1(:,1132),heltab2x2(:,:,1132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(109),n2h1(1240))
  call Hloop_VQ_A(ntryL,G1H2(1081),ex1(:),G1H1(1),m3h2x1(:,1133),heltab2x2(:,:,1133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(107),n2h1(1241))
  call Hloop_VQ_A(ntryL,G1H2(793),ex1(:),G1H1(1),m3h2x1(:,1134),heltab2x2(:,:,1134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(200),n2h1(1242))
  call Hloop_VQ_A(ntryL,G1H2(1106),ex1(:),G1H1(1),m3h2x1(:,1135),heltab2x2(:,:,1135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(114),n2h1(1243))
  call Hloop_VQ_A(ntryL,G1H2(1075),ex1(:),G1H1(1),m3h2x1(:,1136),heltab2x2(:,:,1136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(117),n2h1(1244))
  call Hloop_VA_Q(ntryL,G1H2(1131),ex2(:),G1H1(1),m3h2x1(:,1137),heltab2x2(:,:,1137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(115),n2h1(1245))
  call Hloop_VA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),m3h2x1(:,1138),heltab2x2(:,:,1138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1042),n2h1(1246))
  call Hloop_VQ_A(ntryL,G1H4(359),wf4(:,11),G1H1(1),m3h4x1(:,117),heltab2x4(:,:,771))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(118),n2h1(1247))
  call Hloop_VQ_A(ntryL,G1H4(363),wf4(:,11),G1H1(1),m3h4x1(:,118),heltab2x4(:,:,772))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(142),n2h1(1248))
  call Hloop_VA_Q(ntryL,G1H4(105),wf4(:,4),G1H1(1),m3h4x1(:,119),heltab2x4(:,:,773))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(122),n2h1(1249))
  call Hloop_VA_Q(ntryL,G1H4(371),wf4(:,4),G1H1(1),m3h4x1(:,120),heltab2x4(:,:,774))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(125),n2h1(1250))
  call Hloop_VQ_A(ntryL,G1H4(57),wf4(:,14),G1H1(1),m3h4x1(:,121),heltab2x4(:,:,775))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(123),n2h1(1251))
  call Hloop_VQ_A(ntryL,G1H4(407),wf4(:,14),G1H1(1),m3h4x1(:,122),heltab2x4(:,:,776))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1045),n2h1(1252))
  call Hloop_VQ_A(ntryL,G1H4(384),wf4(:,14),G1H1(1),m3h4x1(:,123),heltab2x4(:,:,777))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(146),n2h1(1253))
  call Hloop_VA_Q(ntryL,G1H4(353),wf4(:,6),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,778))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(126),n2h1(1254))
  call Hloop_VA_Q(ntryL,G1H4(402),wf4(:,6),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,779))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(134),n2h1(1255))
  call Hloop_VA_Q(ntryL,G1H4(154),wf4(:,6),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,780))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(130),n2h1(1256))
  call Hloop_VQ_A(ntryL,G1H2(1101),ex1(:),G1H1(1),m3h2x1(:,1139),heltab2x2(:,:,1139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(137),n2h1(1257))
  call Hloop_QV_A(ntryL,G1H2(752),ex3(:),G1H1(1),m3h2x1(:,1140),heltab2x2(:,:,1140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(135),n2h1(1258))
  call Hloop_QV_A(ntryL,G1H2(558),ex3(:),G1H1(1),m3h2x1(:,1141),heltab2x2(:,:,1141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(145),n2h1(1259))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,1142),heltab2x2(:,:,1142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(143),n2h1(1260))
  call Hloop_AV_Q(ntryL,G1H2(828),ex4(:),G1H1(1),m3h2x1(:,1143),heltab2x2(:,:,1143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(154),n2h1(1261))
  call Hloop_QV_A(ntryL,G1H2(312),ex3(:),G1H1(1),m3h2x1(:,1144),heltab2x2(:,:,1144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(150),n2h1(1262))
  call Hloop_QV_A(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,1145),heltab2x2(:,:,1145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(166),n2h1(1263))
  call Hloop_QV_A(ntryL,G1H2(498),ex4(:),G1H1(1),m3h2x1(:,1146),heltab2x2(:,:,1146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(158),n2h1(1264))
  call Hloop_AV_Q(ntryL,G1H2(881),ex3(:),G1H1(1),m3h2x1(:,1147),heltab2x2(:,:,1147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(161),n2h1(1265))
  call Hloop_AV_Q(ntryL,G1H2(181),ex3(:),G1H1(1),m3h2x1(:,1148),heltab2x2(:,:,1148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(159),n2h1(1266))
  call Hloop_QV_A(ntryL,G1H2(967),ex4(:),G1H1(1),m3h2x1(:,1149),heltab2x2(:,:,1149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(170),n2h1(1267))
  call Hloop_QV_A(ntryL,G1H2(528),ex3(:),G1H1(1),m3h2x1(:,1150),heltab2x2(:,:,1150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(162),n2h1(1268))
  call Hloop_QV_A(ntryL,G1H2(263),ex5(:),G1H1(1),m3h2x1(:,1151),heltab2x2(:,:,1151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(169),n2h1(1269))
  call Hloop_QV_A(ntryL,G1H2(678),ex3(:),G1H1(1),m3h2x1(:,1152),heltab2x2(:,:,1152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(167),n2h1(1270))
  call Hloop_QV_A(ntryL,G1H2(708),ex3(:),G1H1(1),m3h2x1(:,1153),heltab2x2(:,:,1153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(178),n2h1(1271))
  call Hloop_AV_Q(ntryL,G1H2(284),ex3(:),G1H1(1),m3h2x1(:,1154),heltab2x2(:,:,1154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(174),n2h1(1272))
  call Hloop_AV_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,1155),heltab2x2(:,:,1155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(181),n2h1(1273))
  call Hloop_AV_Q(ntryL,G1H2(1029),ex4(:),G1H1(1),m3h2x1(:,1156),heltab2x2(:,:,1156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(179),n2h1(1274))
  call Hloop_AV_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,1157),heltab2x2(:,:,1157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(190),n2h1(1275))
  call Hloop_AV_Q(ntryL,G1H2(240),ex5(:),G1H1(1),m3h2x1(:,1158),heltab2x2(:,:,1158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(186),n2h1(1276))
  call Hloop_AV_Q(ntryL,G1H2(491),ex3(:),G1H1(1),m3h2x1(:,1159),heltab2x2(:,:,1159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(194),n2h1(1277))
  call Hloop_AV_Q(ntryL,G1H2(503),ex3(:),G1H1(1),m3h2x1(:,1160),heltab2x2(:,:,1160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(195),n2h1(1278))
  call Hloop_QV_A(ntryL,G1H2(372),ex5(:),G1H1(1),m3h2x1(:,1161),heltab2x2(:,:,1161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(197),n2h1(1279))
  call Hloop_QV_A(ntryL,G1H2(519),ex3(:),G1H1(1),m3h2x1(:,1162),heltab2x2(:,:,1162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(198),n2h1(1280))
  call Hloop_QV_A(ntryL,G1H2(396),ex4(:),G1H1(1),m3h2x1(:,1163),heltab2x2(:,:,1163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(201),n2h1(1281))
  call Hloop_AV_Q(ntryL,G1H2(513),ex5(:),G1H1(1),m3h2x1(:,1164),heltab2x2(:,:,1164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(203),n2h1(1282))
  call Hloop_AV_Q(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,1165),heltab2x2(:,:,1165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(204),n2h1(1283))
  call Hloop_AV_Q(ntryL,G1H2(621),ex4(:),G1H1(1),m3h2x1(:,1166),heltab2x2(:,:,1166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(206),n2h1(1284))
  call Hloop_VQ_A(ntryL,G1H4(328),wf4(:,3),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,781))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(207),n2h1(1285))
  call Hloop_VQ_A(ntryL,G1H4(9),wf4(:,3),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,782))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(209),n2h1(1286))
  call Hloop_VA_Q(ntryL,G1H4(21),wf4(:,12),G1H1(1),m3h4x1(:,129),heltab2x4(:,:,783))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(210),n2h1(1287))
  call Hloop_VA_Q(ntryL,G1H4(23),wf4(:,12),G1H1(1),m3h4x1(:,130),heltab2x4(:,:,784))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(212),n2h1(1288))
  call Hloop_VQ_A(ntryL,G1H4(362),wf4(:,11),G1H1(1),m3h4x1(:,131),heltab2x4(:,:,785))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(213),n2h1(1289))
  call Hloop_VQ_A(ntryL,G1H4(340),wf4(:,11),G1H1(1),m3h4x1(:,132),heltab2x4(:,:,786))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(215),n2h1(1290))
  call Hloop_VA_Q(ntryL,G1H4(370),wf4(:,4),G1H1(1),m3h4x1(:,133),heltab2x4(:,:,787))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(216),n2h1(1291))
  call Hloop_VA_Q(ntryL,G1H4(344),wf4(:,4),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,788))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(218),n2h1(1292))
  call Hloop_VQ_A(ntryL,G1H4(383),wf4(:,14),G1H1(1),m3h4x1(:,135),heltab2x4(:,:,789))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(219),n2h1(1293))
  call Hloop_VA_Q(ntryL,G1H4(153),wf4(:,6),G1H1(1),m3h4x1(:,136),heltab2x4(:,:,790))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(222),n2h1(1294))
  call Hloop_VQ_A(ntryL,G1H8(103),wf8(:,3),G1H1(1),m3h8x1(:,25),heltab2x8(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(224),n2h1(1295))
  call Hloop_VQ_A(ntryL,G1H8(23),wf8(:,3),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(225),n2h1(1296))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,20),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(227),n2h1(1297))
  call Hloop_VA_Q(ntryL,G1H8(43),wf8(:,20),G1H1(1),m3h8x1(:,28),heltab2x8(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(228),n2h1(1298))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,17),G1H1(1),m3h8x1(:,29),heltab2x8(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(230),n2h1(1299))
  call Hloop_VQ_A(ntryL,G1H8(42),wf8(:,17),G1H1(1),m3h8x1(:,30),heltab2x8(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(231),n2h1(1300))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,6),G1H1(1),m3h8x1(:,31),heltab2x8(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(233),n2h1(1301))
  call Hloop_VA_Q(ntryL,G1H8(88),wf8(:,6),G1H1(1),m3h8x1(:,32),heltab2x8(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(234),n2h1(1302))
  call Hloop_VQ_A(ntryL,G1H8(75),wf8(:,36),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(236),n2h1(1303))
  call Hloop_VQ_A(ntryL,G1H8(11),wf8(:,36),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(700),n2h1(1304))
  call Hloop_VQ_A(ntryL,G1H8(18),wf8(:,22),G1H1(1),m3h8x1(:,35),heltab2x8(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(275),n2h1(1305))
  call Hloop_VQ_A(ntryL,G1H8(44),wf8(:,22),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(239),n2h1(1306))
  call Hloop_VA_Q(ntryL,G1H8(33),wf8(:,32),G1H1(1),m3h8x1(:,37),heltab2x8(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(240),n2h1(1307))
  call Hloop_VA_Q(ntryL,G1H8(58),wf8(:,32),G1H1(1),m3h8x1(:,38),heltab2x8(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(242),n2h1(1308))
  call Hloop_VA_Q(ntryL,G1H8(52),wf8(:,11),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(243),n2h1(1309))
  call Hloop_VA_Q(ntryL,G1H8(37),wf8(:,11),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(706),n2h1(1310))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex1(:),G2tensor(281),m3h2x1(:,1167),heltab2x2(:,:,1167))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(519),ex1(:),G2tensor(245),m3h2x1(:,1168),heltab2x2(:,:,1168))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(82),ex2(:),G2tensor(282),m3h2x1(:,1169),heltab2x2(:,:,1169))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(84),ex2(:),G2tensor(252),m3h2x1(:,1170),heltab2x2(:,:,1170))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex2(:),G2tensor(246),m3h2x1(:,1171),heltab2x2(:,:,1171))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(89),ex1(:),G2tensor(248),m3h2x1(:,1172),heltab2x2(:,:,1172))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(32),wf4(:,11),G2tensor(523),m3h4x1(:,137),heltab2x4(:,:,791))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(91),wf4(:,4),G2tensor(305),m3h4x1(:,138),heltab2x4(:,:,792))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(36),wf4(:,14),G2tensor(251),m3h4x1(:,139),heltab2x4(:,:,793))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(90),wf4(:,14),G2tensor(254),m3h4x1(:,140),heltab2x4(:,:,794))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(40),wf4(:,6),G2tensor(255),m3h4x1(:,141),heltab2x4(:,:,795))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(41),wf4(:,6),G2tensor(787),m3h4x1(:,142),heltab2x4(:,:,796))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,3),G2tensor(329),m3h8x1(:,41),heltab2x8(:,:,327))
  call Hloop_VQ_A(ntryL,G1H16(5),wf16(:,2),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(257),n2h1(1311))
  call Hloop_VQ_A(ntryL,G1H16(16),wf16(:,6),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(330),n2h1(1312))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,20),G2tensor(267),m3h8x1(:,42),heltab2x8(:,:,328))
  call Hloop_VA_Q(ntryL,G1H16(26),wf16(:,14),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(258),n2h1(1313))
  call Hloop_VA_Q(ntryL,G1H16(7),wf16(:,18),G1H1(1),m3h16x1(:,4),heltab2x16(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(260),n2h1(1314))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(44),wf4(:,11),G2tensor(261),m3h4x1(:,143),heltab2x4(:,:,797))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(7),wf8(:,17),G2tensor(263),m3h8x1(:,43),heltab2x8(:,:,329))
  call Hloop_VQ_A(ntryL,G1H16(33),wf16(:,26),G1H1(1),m3h16x1(:,5),heltab2x16(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(793),n2h1(1315))
  call Hloop_VQ_A(ntryL,G1H16(36),wf16(:,30),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(338),n2h1(1316))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(45),wf4(:,4),G2tensor(266),m3h4x1(:,144),heltab2x4(:,:,798))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,6),G2tensor(269),m3h8x1(:,44),heltab2x8(:,:,330))
  call Hloop_VA_Q(ntryL,G1H16(39),wf16(:,38),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(272),n2h1(1317))
  call Hloop_VA_Q(ntryL,G1H16(42),wf16(:,42),G1H1(1),m3h16x1(:,8),heltab2x16(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(278),n2h1(1318))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(9),wf8(:,36),G2tensor(279),m3h8x1(:,45),heltab2x8(:,:,331))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(11),wf8(:,22),G2tensor(284),m3h8x1(:,46),heltab2x8(:,:,332))
  call Hloop_VQ_A(ntryL,G1H16(44),wf16(:,50),G1H1(1),m3h16x1(:,9),heltab2x16(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(285),n2h1(1319))
  call Hloop_VQ_A(ntryL,G1H16(19),wf16(:,54),G1H1(1),m3h16x1(:,10),heltab2x16(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(805),n2h1(1320))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(12),wf8(:,32),G2tensor(347),m3h8x1(:,47),heltab2x8(:,:,333))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(13),wf8(:,11),G2tensor(287),m3h8x1(:,48),heltab2x8(:,:,334))
  call Hloop_VA_Q(ntryL,G1H16(17),wf16(:,62),G1H1(1),m3h16x1(:,11),heltab2x16(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(348),n2h1(1321))
  call Hloop_VA_Q(ntryL,G1H16(29),wf16(:,66),G1H1(1),m3h16x1(:,12),heltab2x16(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(297),n2h1(1322))
  call ol_merge_tensors(G2tensor(389),[G2tensor(396),G2tensor(983),G2tensor(938),G2tensor(398),G2tensor(390),G2tensor(56) &
    ,G2tensor(55),G2tensor(15),G2tensor(13),G1tensor(957),G1tensor(942),G1tensor(928),G1tensor(868),G1tensor(863),G1tensor(858) &
    ,G1tensor(797),G1tensor(497),G1tensor(244),G1tensor(245),G1tensor(277),G1tensor(16),G1tensor(39),G1tensor(37),G0tensor(957) &
    ,G0tensor(942),G0tensor(928),G0tensor(868),G0tensor(863),G0tensor(858),G0tensor(797),G0tensor(573),G0tensor(458),G0tensor(448) &
    ,G0tensor(47),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(51),G2tensor(971),G2tensor(917),G2tensor(402),G2tensor(394),G2tensor(64) &
    ,G2tensor(63),G2tensor(31),G2tensor(29),G1tensor(952),G1tensor(947),G1tensor(923),G1tensor(853),G1tensor(848),G1tensor(843) &
    ,G1tensor(737),G1tensor(531),G1tensor(126),G1tensor(500),G1tensor(307),G1tensor(157),G1tensor(111),G1tensor(63),G0tensor(952) &
    ,G0tensor(947),G0tensor(923),G0tensor(853),G0tensor(848),G0tensor(843),G0tensor(737),G0tensor(543),G0tensor(393),G0tensor(383) &
    ,G0tensor(52),G0tensor(27),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G2tensor(400),[G2tensor(9),G2tensor(977),G2tensor(926),G2tensor(386),G2tensor(382),G2tensor(72) &
    ,G2tensor(71),G2tensor(47),G2tensor(45),G1tensor(937),G1tensor(932),G1tensor(903),G1tensor(803),G1tensor(798),G1tensor(762) &
    ,G1tensor(708),G1tensor(467),G1tensor(359),G1tensor(148),G1tensor(337),G1tensor(247),G1tensor(217),G1tensor(187),G0tensor(937) &
    ,G0tensor(932),G0tensor(903),G0tensor(803),G0tensor(798),G0tensor(762),G0tensor(708),G0tensor(563),G0tensor(418),G0tensor(413) &
    ,G0tensor(57),G0tensor(42),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(1052),G2tensor(1040),G2tensor(1031),G2tensor(866),G2tensor(698),G2tensor(432) &
    ,G2tensor(80),G2tensor(79),G1tensor(159),G1tensor(427),G1tensor(397),G1tensor(367),G1tensor(313),G0tensor(287),G0tensor(72) &
    ,G0tensor(67),G0tensor(62),G0tensor(53)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(1061),G2tensor(1049),G2tensor(881),G2tensor(875),G2tensor(704),G2tensor(96) &
    ,G2tensor(95),G2tensor(88),G2tensor(87),G1tensor(547),G1tensor(517),G1tensor(487),G1tensor(457),G1tensor(73),G0tensor(92) &
    ,G0tensor(87),G0tensor(82),G0tensor(77),G0tensor(3)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(734),G2tensor(728),G2tensor(710),G2tensor(156),G2tensor(152),G2tensor(140) &
    ,G2tensor(139),G2tensor(132),G2tensor(112),G2tensor(111),G2tensor(104),G2tensor(103),G1tensor(80),G1tensor(216),G1tensor(198) &
    ,G1tensor(360),G1tensor(348),G1tensor(74),G1tensor(75),G1tensor(588),G1tensor(584),G1tensor(139),G1tensor(577),G1tensor(373) &
    ,G0tensor(268),G0tensor(248),G0tensor(238),G0tensor(162),G0tensor(152),G0tensor(147),G0tensor(133),G0tensor(112),G0tensor(107) &
    ,G0tensor(102),G0tensor(97),G0tensor(63)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(1058),G2tensor(1043),G2tensor(1037),G2tensor(869),G2tensor(716),G2tensor(428) &
    ,G2tensor(120),G2tensor(119),G1tensor(168),G1tensor(560),G1tensor(204),G1tensor(200),G1tensor(70),G0tensor(222),G0tensor(127) &
    ,G0tensor(122),G0tensor(117),G0tensor(18)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(1055),G2tensor(1046),G2tensor(878),G2tensor(872),G2tensor(722),G2tensor(148) &
    ,G2tensor(147),G2tensor(128),G2tensor(127),G1tensor(164),G1tensor(579),G1tensor(13),G1tensor(260),G1tensor(283),G0tensor(157) &
    ,G0tensor(142),G0tensor(137),G0tensor(132),G0tensor(48)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(752),G2tensor(746),G2tensor(740),G2tensor(192),G2tensor(188),G2tensor(184) &
    ,G2tensor(183),G2tensor(176),G2tensor(172),G2tensor(171),G2tensor(164),G2tensor(163),G1tensor(350),G1tensor(326),G1tensor(524) &
    ,G1tensor(136),G1tensor(528),G1tensor(83),G1tensor(207),G1tensor(54),G1tensor(48),G1tensor(35),G1tensor(62),G1tensor(463) &
    ,G0tensor(313),G0tensor(303),G0tensor(203),G0tensor(197),G0tensor(192),G0tensor(187),G0tensor(182),G0tensor(177),G0tensor(172) &
    ,G0tensor(167),G0tensor(118),G0tensor(78)])
  call ol_merge_tensors(G2tensor(692),[G2tensor(662),G2tensor(500),G2tensor(403),G1tensor(152),G1tensor(55),G1tensor(2) &
    ,G0tensor(217),G0tensor(212),G0tensor(5)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(695),G2tensor(665),G2tensor(502),G2tensor(404),G1tensor(91),G1tensor(182) &
    ,G1tensor(108),G0tensor(232),G0tensor(227),G0tensor(20)])
  call ol_merge_tensors(G2tensor(787),[G2tensor(680),G2tensor(668),G2tensor(504),G2tensor(405),G1tensor(958),G1tensor(240) &
    ,G1tensor(561),G1tensor(205),G0tensor(958),G0tensor(262),G0tensor(257),G0tensor(35)])
  call ol_merge_tensors(G2tensor(686),[G2tensor(671),G2tensor(506),G2tensor(406),G1tensor(276),G1tensor(270),G1tensor(295) &
    ,G0tensor(282),G0tensor(277),G0tensor(50)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(689),G2tensor(674),G2tensor(508),G2tensor(407),G1tensor(336),G1tensor(330) &
    ,G1tensor(325),G0tensor(297),G0tensor(292),G0tensor(55)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(683),G2tensor(677),G2tensor(510),G2tensor(408),G1tensor(943),G1tensor(402) &
    ,G1tensor(396),G1tensor(355),G0tensor(943),G0tensor(327),G0tensor(322),G0tensor(60)])
  call ol_merge_tensors(G2tensor(719),[G2tensor(717),G2tensor(701),G2tensor(699),G2tensor(557),G2tensor(533),G2tensor(46) &
    ,G2tensor(14),G2tensor(414),G2tensor(409),G1tensor(652),G1tensor(64),G1tensor(53),G1tensor(564),G1tensor(385),G1tensor(138) &
    ,G0tensor(652),G0tensor(347),G0tensor(342),G0tensor(120),G0tensor(65),G0tensor(23)])
  call ol_merge_tensors(G2tensor(725),[G2tensor(723),G2tensor(707),G2tensor(705),G2tensor(548),G2tensor(524),G2tensor(34) &
    ,G2tensor(2),G2tensor(418),G2tensor(415),G2tensor(411),G2tensor(410),G1tensor(482),G1tensor(423),G1tensor(452),G1tensor(69) &
    ,G1tensor(475),G1tensor(92),G0tensor(377),G0tensor(367),G0tensor(362),G0tensor(135),G0tensor(80),G0tensor(8)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(713),G2tensor(711),G2tensor(572),G2tensor(286),G2tensor(413),G2tensor(412) &
    ,G1tensor(161),G1tensor(135),G1tensor(129),G1tensor(7),G1tensor(403),G0tensor(422),G0tensor(407),G0tensor(402),G0tensor(100) &
    ,G0tensor(68)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(731),G2tensor(729),G2tensor(614),G2tensor(52),G2tensor(417),G2tensor(416) &
    ,G1tensor(315),G1tensor(274),G1tensor(251),G1tensor(575),G1tensor(568),G1tensor(24),G1tensor(278),G0tensor(487),G0tensor(472) &
    ,G0tensor(467),G0tensor(253),G0tensor(243),G0tensor(150),G0tensor(138)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(737),G2tensor(735),G2tensor(629),G2tensor(229),G2tensor(420),G2tensor(419) &
    ,G1tensor(401),G1tensor(376),G1tensor(365),G1tensor(84),G1tensor(258),G1tensor(121),G1tensor(17),G0tensor(537),G0tensor(522) &
    ,G0tensor(517),G0tensor(288),G0tensor(273),G0tensor(165),G0tensor(158)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(743),G2tensor(741),G2tensor(608),G2tensor(177),G2tensor(422),G2tensor(421) &
    ,G1tensor(489),G1tensor(460),G1tensor(453),G1tensor(189),G1tensor(566),G0tensor(567),G0tensor(557),G0tensor(552),G0tensor(170) &
    ,G0tensor(123)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(749),G2tensor(747),G2tensor(578),G2tensor(17),G2tensor(424),G2tensor(423) &
    ,G1tensor(597),G1tensor(549),G1tensor(551),G1tensor(420),G1tensor(96),G1tensor(107),G1tensor(493),G0tensor(597),G0tensor(587) &
    ,G0tensor(582),G0tensor(318),G0tensor(308),G0tensor(190),G0tensor(83)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(755),G2tensor(753),G2tensor(584),G2tensor(73),G2tensor(426),G2tensor(425) &
    ,G1tensor(627),G1tensor(617),G1tensor(612),G1tensor(170),G1tensor(132),G1tensor(113),G1tensor(553),G0tensor(627),G0tensor(617) &
    ,G0tensor(612),G0tensor(223),G0tensor(208),G0tensor(200),G0tensor(93)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(1034),G2tensor(758),G2tensor(427),G1tensor(147),G1tensor(98),G1tensor(82) &
    ,G1tensor(109),G0tensor(207),G0tensor(202),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(1016),G2tensor(761),G2tensor(429),G1tensor(574),G1tensor(557),G1tensor(193) &
    ,G0tensor(242),G0tensor(237),G0tensor(33)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(1019),G2tensor(764),G2tensor(430),G1tensor(26),G1tensor(569),G1tensor(199) &
    ,G0tensor(252),G0tensor(247),G0tensor(34)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(1028),G2tensor(767),G2tensor(431),G1tensor(86),G1tensor(248),G1tensor(319) &
    ,G1tensor(289),G0tensor(272),G0tensor(267),G0tensor(54),G0tensor(49)])
  call ol_merge_tensors(G2tensor(248),[G2tensor(1022),G2tensor(770),G2tensor(433),G1tensor(255),G1tensor(318),G1tensor(343) &
    ,G0tensor(307),G0tensor(302),G0tensor(58)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(1025),G2tensor(773),G2tensor(434),G1tensor(33),G1tensor(12),G1tensor(349) &
    ,G0tensor(317),G0tensor(312),G0tensor(59)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(899),G2tensor(776),G2tensor(435),G1tensor(692),G1tensor(273),G1tensor(390) &
    ,G1tensor(306),G1tensor(379),G0tensor(692),G0tensor(337),G0tensor(332),G0tensor(293),G0tensor(64)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(782),G2tensor(779),G2tensor(437),G2tensor(436),G1tensor(468),G1tensor(462) &
    ,G1tensor(65),G1tensor(19),G1tensor(469),G0tensor(372),G0tensor(357),G0tensor(352),G0tensor(213),G0tensor(79)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(791),G2tensor(785),G2tensor(440),G2tensor(438),G1tensor(154),G1tensor(506) &
    ,G1tensor(99),G1tensor(392),G1tensor(583),G0tensor(412),G0tensor(387),G0tensor(382),G0tensor(333),G0tensor(98)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(135),G2tensor(839),G2tensor(833),G2tensor(794),G2tensor(788),G2tensor(456) &
    ,G2tensor(454),G2tensor(441),G2tensor(439),G1tensor(149),G1tensor(530),G1tensor(267),G1tensor(416),G1tensor(372),G1tensor(578) &
    ,G0tensor(417),G0tensor(397),G0tensor(392),G0tensor(343),G0tensor(169),G0tensor(99)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(887),G2tensor(797),G2tensor(442),G1tensor(647),G1tensor(227),G1tensor(177) &
    ,G1tensor(85),G1tensor(103),G0tensor(647),G0tensor(432),G0tensor(427),G0tensor(228),G0tensor(119)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(815),G2tensor(800),G2tensor(448),G2tensor(443),G1tensor(478),G1tensor(239) &
    ,G1tensor(233),G1tensor(272),G1tensor(264),G0tensor(492),G0tensor(442),G0tensor(437),G0tensor(278),G0tensor(134)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(809),G2tensor(803),G2tensor(446),G2tensor(444),G1tensor(673),G1tensor(663) &
    ,G1tensor(418),G1tensor(214),G1tensor(293),G1tensor(201),G1tensor(320),G0tensor(673),G0tensor(663),G0tensor(477),G0tensor(452) &
    ,G0tensor(447),G0tensor(438),G0tensor(148)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(67),G2tensor(851),G2tensor(845),G2tensor(812),G2tensor(806),G2tensor(460) &
    ,G2tensor(458),G2tensor(447),G2tensor(445),G1tensor(678),G1tensor(668),G1tensor(298),G1tensor(382),G1tensor(232),G1tensor(291) &
    ,G1tensor(476),G1tensor(77),G0tensor(678),G0tensor(668),G0tensor(482),G0tensor(462),G0tensor(457),G0tensor(363),G0tensor(189) &
    ,G0tensor(149)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(824),G2tensor(818),G2tensor(451),G2tensor(449),G1tensor(693),G1tensor(688) &
    ,G1tensor(394),G1tensor(339),G1tensor(323),G1tensor(383),G1tensor(112),G0tensor(693),G0tensor(688),G0tensor(527),G0tensor(502) &
    ,G0tensor(497),G0tensor(493),G0tensor(163)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(62),G2tensor(863),G2tensor(857),G2tensor(827),G2tensor(821),G2tensor(464) &
    ,G2tensor(462),G2tensor(452),G2tensor(450),G1tensor(653),G1tensor(638),G1tensor(406),G1tensor(347),G1tensor(496),G1tensor(351) &
    ,G1tensor(231),G1tensor(27),G0tensor(653),G0tensor(638),G0tensor(532),G0tensor(512),G0tensor(507),G0tensor(378),G0tensor(199) &
    ,G0tensor(164)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(836),G2tensor(830),G2tensor(455),G2tensor(453),G1tensor(477),G1tensor(430) &
    ,G1tensor(419),G1tensor(167),G1tensor(426),G0tensor(562),G0tensor(547),G0tensor(542),G0tensor(428),G0tensor(168)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(848),G2tensor(842),G2tensor(459),G2tensor(457),G1tensor(703),G1tensor(698) &
    ,G1tensor(592),G1tensor(519),G1tensor(539),G1tensor(456),G1tensor(36),G0tensor(703),G0tensor(698),G0tensor(592),G0tensor(577) &
    ,G0tensor(572),G0tensor(353),G0tensor(188)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(860),G2tensor(854),G2tensor(463),G2tensor(461),G1tensor(648),G1tensor(633) &
    ,G1tensor(622),G1tensor(607),G1tensor(602),G1tensor(470),G1tensor(237),G0tensor(648),G0tensor(633),G0tensor(622),G0tensor(607) &
    ,G0tensor(602),G0tensor(373),G0tensor(198)])
  call ol_merge_tensors(G2tensor(768),[G2tensor(759),G2tensor(551),G2tensor(527),G2tensor(36),G2tensor(4),G1tensor(637) &
    ,G1tensor(254),G1tensor(119),G1tensor(144),G1tensor(116),G0tensor(637),G0tensor(270),G0tensor(205),G0tensor(24),G0tensor(9)])
  call ol_merge_tensors(G2tensor(870),[G2tensor(867),G2tensor(720),G2tensor(702),G2tensor(672),G2tensor(663),G2tensor(554) &
    ,G2tensor(530),G2tensor(189),G2tensor(310),G2tensor(38),G2tensor(6),G1tensor(642),G1tensor(59),G1tensor(93),G1tensor(580) &
    ,G1tensor(572),G1tensor(415),G1tensor(140),G0tensor(642),G0tensor(345),G0tensor(280),G0tensor(215),G0tensor(125),G0tensor(70) &
    ,G0tensor(10)])
  call ol_merge_tensors(G2tensor(882),[G2tensor(879),G2tensor(678),G2tensor(669),G2tensor(569),G2tensor(549),G2tensor(545) &
    ,G2tensor(525),G2tensor(343),G2tensor(331),G2tensor(244),G2tensor(40),G2tensor(26),G2tensor(8),G1tensor(682),G1tensor(488) &
    ,G1tensor(142),G1tensor(3),G1tensor(356),G1tensor(565),G1tensor(235),G1tensor(23),G0tensor(682),G0tensor(380),G0tensor(325) &
    ,G0tensor(260),G0tensor(160),G0tensor(95),G0tensor(40),G0tensor(13)])
  call ol_merge_tensors(G2tensor(1035),[G2tensor(1029),G2tensor(552),G2tensor(528),G2tensor(349),G2tensor(160),G2tensor(42) &
    ,G2tensor(10),G1tensor(640),G1tensor(104),G1tensor(122),G1tensor(169),G1tensor(40),G0tensor(640),G0tensor(275),G0tensor(210) &
    ,G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G2tensor(1059),[G2tensor(1053),G2tensor(1044),G2tensor(1041),G2tensor(693),G2tensor(687),G2tensor(555) &
    ,G2tensor(531),G2tensor(352),G2tensor(334),G2tensor(44),G2tensor(12),G1tensor(645),G1tensor(434),G1tensor(128),G1tensor(156) &
    ,G1tensor(68),G1tensor(445),G1tensor(47),G0tensor(645),G0tensor(350),G0tensor(285),G0tensor(220),G0tensor(130),G0tensor(75) &
    ,G0tensor(15)])
  call ol_merge_tensors(G2tensor(876),[G2tensor(873),G2tensor(726),G2tensor(708),G2tensor(675),G2tensor(666),G2tensor(560) &
    ,G2tensor(536),G2tensor(202),G2tensor(49),G2tensor(48),G2tensor(16),G1tensor(657),G1tensor(78),G1tensor(130),G1tensor(186) &
    ,G1tensor(300),G1tensor(505),G1tensor(145),G0tensor(657),G0tensor(365),G0tensor(295),G0tensor(230),G0tensor(140),G0tensor(85) &
    ,G0tensor(25)])
  call ol_merge_tensors(G2tensor(1038),[G2tensor(1032),G2tensor(558),G2tensor(534),G2tensor(358),G2tensor(340),G2tensor(7) &
    ,G2tensor(18),G1tensor(655),G1tensor(302),G1tensor(587),G1tensor(163),G0tensor(655),G0tensor(290),G0tensor(225) &
    ,G0tensor(28)])
  call ol_merge_tensors(G2tensor(1062),[G2tensor(1056),G2tensor(1050),G2tensor(1047),G2tensor(696),G2tensor(690),G2tensor(684) &
    ,G2tensor(681),G2tensor(570),G2tensor(561),G2tensor(546),G2tensor(537),G2tensor(180),G2tensor(168),G2tensor(325),G2tensor(316) &
    ,G2tensor(265),G2tensor(23),G2tensor(32),G2tensor(20),G1tensor(685),G1tensor(660),G1tensor(87),G1tensor(46),G1tensor(5) &
    ,G1tensor(563),G1tensor(194),G1tensor(9),G1tensor(535),G1tensor(265),G1tensor(175),G0tensor(685),G0tensor(660),G0tensor(370) &
    ,G0tensor(330),G0tensor(300),G0tensor(265),G0tensor(235),G0tensor(145),G0tensor(90),G0tensor(45),G0tensor(30)])
  call ol_merge_tensors(G2tensor(771),[G2tensor(762),G2tensor(563),G2tensor(539),G2tensor(39),G2tensor(22),G1tensor(667) &
    ,G1tensor(11),G1tensor(20),G1tensor(223),G0tensor(667),G0tensor(305),G0tensor(240),G0tensor(38)])
  call ol_merge_tensors(G2tensor(774),[G2tensor(765),G2tensor(566),G2tensor(542),G2tensor(238),G2tensor(24),G1tensor(677) &
    ,G1tensor(354),G1tensor(222),G1tensor(229),G0tensor(677),G0tensor(315),G0tensor(250),G0tensor(39)])
  call ol_merge_tensors(G2tensor(1023),[G2tensor(1017),G2tensor(564),G2tensor(540),G2tensor(373),G2tensor(364),G2tensor(250) &
    ,G2tensor(28),G1tensor(670),G1tensor(338),G1tensor(212),G1tensor(253),G0tensor(670),G0tensor(310),G0tensor(245) &
    ,G0tensor(43)])
  call ol_merge_tensors(G2tensor(1026),[G2tensor(1020),G2tensor(567),G2tensor(543),G2tensor(322),G2tensor(313),G2tensor(256) &
    ,G2tensor(30),G1tensor(680),G1tensor(374),G1tensor(230),G1tensor(259),G0tensor(680),G0tensor(320),G0tensor(255) &
    ,G0tensor(44)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(777),G2tensor(575),G2tensor(295),G1tensor(712),G1tensor(52),G1tensor(409) &
    ,G0tensor(712),G0tensor(335),G0tensor(69)])
  call ol_merge_tensors(G2tensor(236),[G2tensor(224),G2tensor(738),G2tensor(605),G2tensor(573),G2tensor(280),G2tensor(319) &
    ,G1tensor(782),G1tensor(375),G1tensor(166),G1tensor(554),G1tensor(433),G0tensor(782),G0tensor(520),G0tensor(425),G0tensor(115) &
    ,G0tensor(73)])
  call ol_merge_tensors(G2tensor(700),[G2tensor(225),G2tensor(576),G2tensor(1),G1tensor(715),G1tensor(404),G1tensor(439) &
    ,G0tensor(715),G0tensor(340),G0tensor(74)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(780),G2tensor(581),G2tensor(33),G1tensor(722),G1tensor(440),G1tensor(499) &
    ,G0tensor(722),G0tensor(355),G0tensor(84)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(233),G2tensor(659),G2tensor(585),G2tensor(579),G2tensor(89),G2tensor(57) &
    ,G1tensor(917),G1tensor(630),G1tensor(600),G1tensor(494),G1tensor(523),G0tensor(917),G0tensor(630),G0tensor(600),G0tensor(195) &
    ,G0tensor(88)])
  call ol_merge_tensors(G2tensor(706),[G2tensor(234),G2tensor(588),G2tensor(582),G2tensor(97),G2tensor(65),G1tensor(735) &
    ,G1tensor(725),G1tensor(417),G1tensor(529),G0tensor(735),G0tensor(725),G0tensor(360),G0tensor(89)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(783),G2tensor(587),G2tensor(81),G1tensor(732),G1tensor(492),G1tensor(25) &
    ,G1tensor(559),G0tensor(732),G0tensor(375),G0tensor(218),G0tensor(94)])
  call ol_merge_tensors(G2tensor(804),[G2tensor(786),G2tensor(590),G2tensor(208),G2tensor(105),G1tensor(747),G1tensor(197) &
    ,G1tensor(516),G1tensor(31),G0tensor(747),G0tensor(450),G0tensor(385),G0tensor(103)])
  call ol_merge_tensors(G2tensor(846),[G2tensor(834),G2tensor(807),G2tensor(789),G2tensor(638),G2tensor(593),G2tensor(277) &
    ,G2tensor(92),G2tensor(211),G2tensor(113),G1tensor(752),G1tensor(508),G1tensor(279),G1tensor(29),G1tensor(582),G0tensor(752) &
    ,G0tensor(460),G0tensor(395),G0tensor(174),G0tensor(104)])
  call ol_merge_tensors(G2tensor(732),[G2tensor(714),G2tensor(596),G2tensor(68),G2tensor(121),G1tensor(757),G1tensor(316) &
    ,G1tensor(542),G1tensor(570),G0tensor(757),G0tensor(470),G0tensor(405),G0tensor(105)])
  call ol_merge_tensors(G2tensor(621),[G2tensor(600),G2tensor(591),G2tensor(220),G2tensor(157),G2tensor(129),G1tensor(820) &
    ,G1tensor(775),G1tensor(750),G1tensor(345),G1tensor(220),G1tensor(510),G1tensor(43),G0tensor(820),G0tensor(775),G0tensor(750) &
    ,G0tensor(505),G0tensor(455),G0tensor(390),G0tensor(108)])
  call ol_merge_tensors(G2tensor(657),[G2tensor(648),G2tensor(639),G2tensor(624),G2tensor(603),G2tensor(594),G2tensor(292) &
    ,G2tensor(108),G2tensor(259),G2tensor(223),G2tensor(165),G2tensor(133),G1tensor(830),G1tensor(780),G1tensor(755),G1tensor(353) &
    ,G1tensor(250),G1tensor(534),G1tensor(422),G1tensor(176),G0tensor(830),G0tensor(780),G0tensor(755),G0tensor(515),G0tensor(465) &
    ,G0tensor(400),G0tensor(179),G0tensor(109)])
  call ol_merge_tensors(G2tensor(805),[G2tensor(285),G2tensor(338),G2tensor(793),G2tensor(330),G2tensor(257),G2tensor(627) &
    ,G2tensor(606),G2tensor(597),G2tensor(226),G2tensor(173),G2tensor(141),G1tensor(835),G1tensor(785),G1tensor(760),G1tensor(393) &
    ,G1tensor(269),G1tensor(141),G1tensor(32),G0tensor(835),G0tensor(785),G0tensor(760),G0tensor(525),G0tensor(475),G0tensor(410) &
    ,G0tensor(110)])
  call ol_merge_tensors(G2tensor(819),[G2tensor(792),G2tensor(599),G2tensor(76),G2tensor(149),G1tensor(772),G1tensor(333) &
    ,G1tensor(178),G1tensor(114),G1tensor(576),G0tensor(772),G0tensor(500),G0tensor(415),G0tensor(338),G0tensor(113)])
  call ol_merge_tensors(G2tensor(858),[G2tensor(840),G2tensor(822),G2tensor(795),G2tensor(647),G2tensor(602),G2tensor(136) &
    ,G2tensor(337),G2tensor(241),G2tensor(153),G1tensor(777),G1tensor(335),G1tensor(257),G1tensor(450),G1tensor(118),G1tensor(180) &
    ,G0tensor(777),G0tensor(510),G0tensor(420),G0tensor(348),G0tensor(184),G0tensor(114)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(798),G2tensor(611),G2tensor(185),G1tensor(787),G1tensor(281),G1tensor(115) &
    ,G0tensor(787),G0tensor(430),G0tensor(124)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(227),G2tensor(756),G2tensor(650),G2tensor(609),G2tensor(301),G2tensor(193) &
    ,G1tensor(897),G1tensor(615),G1tensor(495),G1tensor(58),G1tensor(44),G0tensor(897),G0tensor(615),G0tensor(570),G0tensor(185) &
    ,G0tensor(128)])
  call ol_merge_tensors(G2tensor(242),[G2tensor(228),G2tensor(612),G2tensor(196),G1tensor(790),G1tensor(195),G1tensor(218) &
    ,G0tensor(790),G0tensor(435),G0tensor(129)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(801),G2tensor(617),G2tensor(199),G1tensor(792),G1tensor(196),G1tensor(110) &
    ,G0tensor(792),G0tensor(440),G0tensor(139)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(230),G2tensor(630),G2tensor(626),G2tensor(615),G2tensor(235),G2tensor(60) &
    ,G1tensor(832),G1tensor(407),G1tensor(321),G1tensor(66),G1tensor(296),G0tensor(832),G0tensor(540),G0tensor(490),G0tensor(155) &
    ,G0tensor(143)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(231),G2tensor(633),G2tensor(618),G2tensor(274),G2tensor(205),G1tensor(840) &
    ,G1tensor(795),G1tensor(425),G1tensor(134),G0tensor(840),G0tensor(795),G0tensor(445),G0tensor(144)])
  call ol_merge_tensors(G2tensor(825),[G2tensor(810),G2tensor(620),G2tensor(84),G2tensor(214),G1tensor(817),G1tensor(395) &
    ,G1tensor(292),G1tensor(202),G1tensor(324),G0tensor(817),G0tensor(530),G0tensor(480),G0tensor(443),G0tensor(153)])
  call ol_merge_tensors(G2tensor(864),[G2tensor(852),G2tensor(828),G2tensor(813),G2tensor(656),G2tensor(623),G2tensor(307) &
    ,G2tensor(346),G2tensor(247),G2tensor(217),G1tensor(827),G1tensor(455),G1tensor(309),G1tensor(81),G1tensor(480),G1tensor(344) &
    ,G0tensor(827),G0tensor(535),G0tensor(485),G0tensor(368),G0tensor(194),G0tensor(154)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(816),G2tensor(632),G2tensor(232),G1tensor(837),G1tensor(311),G1tensor(284) &
    ,G1tensor(49),G0tensor(837),G0tensor(495),G0tensor(283),G0tensor(159)])
  call ol_merge_tensors(G2tensor(843),[G2tensor(831),G2tensor(635),G2tensor(116),G2tensor(304),G1tensor(877),G1tensor(507) &
    ,G1tensor(429),G1tensor(71),G0tensor(877),G0tensor(575),G0tensor(545),G0tensor(173)])



end subroutine vamp_1

end module ol_vamp_1_eeaa_qed_eexaaaa_1_/**/REALKIND
