
module ol_vamp_1_eeaa_lew_eexaaaa_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeaa_lew_eexaaaa_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeaa_lew_eexaaaa_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeaa_lew_eexaaaa_4_/**/DREALKIND
  use ol_tensor_sum_storage_eeaa_lew_eexaaaa_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeaa_lew_eexaaaa_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_lew_eexaaaa_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(18),n2h32(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(20),n2h32(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(22),n2h32(22))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(23),n2h32(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(24),n2h32(24))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H32(2),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),40,nME,G2H16(3),n2h16(3))
  call Hloop_AV_Q(ntryL,G1H32(4),ex3(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(4),n2h16(4))
  call Hloop_QA_V(ntryL,G1H32(5),ex2(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_QA_V(ntryL,G1H32(6),ex2(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex4(:),G1H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(3),40,nME,G2H16(5),n2h16(5))
  call Hloop_QV_A(ntryL,G1H32(8),ex3(:),G1H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(3),36,nME,G2H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(9),ex3(:),G1H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,nME,G2H16(7),n2h16(7))
  call Hloop_QV_A(ntryL,G1H32(10),ex3(:),G1H16(3),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(3),36,nME,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex2(:),G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_QV_A(ntryL,G1H32(13),ex4(:),G1H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),40,nME,G2H16(9),n2h16(9))
  call Hloop_QV_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,nME,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,nME,G2H16(11),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(5),36,nME,G2H16(12),n2h16(12))
  call Hloop_QA_V(ntryL,G1H32(17),ex2(:),G1H16(5),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_QA_V(ntryL,G1H32(18),ex2(:),G1H16(6),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_AQ_V(ntryL,G1H32(19),ex1(:),G1H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_AQ_V(ntryL,G1H32(20),ex1(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_AQ_V(ntryL,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(10),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(11),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(12),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hloop_AQ_V(ntryL,G2H16(4),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(4),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(5),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(5),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(3),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(25),G1H16(26),G1H16(27),G1H16(28),16)
  call HG1shiftOLR(G1H16(24),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(8),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(9),n2h8(4))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(4),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(29),G1H16(30),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hloop_QA_V(ntryL,G2H16(10),ex2(:),G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(5),mass5set(:,1),  & 
G1H16(33),G1H16(34),G1H16(35),G1H16(36),G1H16(37),G1H16(38),16)
  call HG1shiftOLR(G1H16(34),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(6),mass5set(:,1),  & 
G1H16(39),G1H16(40),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(40),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(11),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,nME,G2H8(12),n2h8(6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(13),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(14),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(15),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(16),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(17),n2h8(11))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),35,nME,G2H8(18),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(13),ex3(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(19),n2h8(13))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-16,nME,G2H16(1),n2h16(13))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AV_Q(ntryL,G1H16(16),ex3(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(21),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(22),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(18),ex3(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(23),n2h8(16))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(24),n2h8(17))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,nME,G2H16(2),n2h16(14))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AV_Q(ntryL,G1H16(20),ex4(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(26),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(21),ex4(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(27),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(22),ex4(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(28),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(23),ex5(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(29),n2h8(21))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(24),-8,nME,G2H16(3),n2h16(15))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QV_A(ntryL,G1H16(26),ex5(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(31),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(27),ex5(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(32),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),52,nME,G2H8(33),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(34),n2h8(25))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,nME,G2H16(4),n2h16(16))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(36),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(31),ex3(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(37),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(32),ex3(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(38),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(33),ex4(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(39),n2h8(29))
call HGT_OLR(G1H16(34),1,1,16)
call HGT_invQ_OLR(G1H16(34),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(34),-16,nME,G2H16(5),n2h16(17))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(40),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QV_A(ntryL,G1H16(36),ex4(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(41),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(37),ex4(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(42),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(38),ex4(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(43),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H16(39),ex5(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(44),n2h8(33))
call HGT_OLR(G1H16(40),1,1,16)
call HGT_invQ_OLR(G1H16(40),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(40),-8,nME,G2H16(6),n2h16(18))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AV_Q(ntryL,G1H16(42),ex5(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(46),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(47),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(44),ex5(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(1),52,nME,G2H8(48),n2h8(36))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(7),mass5set(:,2),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(8),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(8),mass5set(:,2),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(9),mass5set(:,3),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(9),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(10),mass5set(:,2),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(11),mass5set(:,2),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(12),mass5set(:,3),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(12),mass5set(:,3),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),4,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(11),mass5set(:,2),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(13),mass5set(:,3),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(13),mass5set(:,3),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(14),mass5set(:,3),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(14),mass5set(:,3),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(15),mass5set(:,3),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(15),mass5set(:,3),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(16),mass5set(:,3),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(16),mass5set(:,3),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),4,8)
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(23),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(24),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(27),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(29),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(32),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(33),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(34),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(37),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(38),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(42),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(43),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(47),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(48),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(19),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,nME,G2H8(1),n2h8(37))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(21),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(22),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(23),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-16,nME,G2H8(2),n2h8(38))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(25),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(26),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(27),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-8,nME,G2H8(3),n2h8(39))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(29),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(30),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(19),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(31),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,nME,G2H8(4),n2h8(40))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QV_A(ntryL,G1H8(23),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(33),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(24),ex3(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(34),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(35),n2h4(13))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-8,nME,G2H8(5),n2h8(41))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(37),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(38),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(31),ex2(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(39),n2h4(16))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-16,nME,G2H8(6),n2h8(42))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(41),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(36),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(42),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(37),ex1(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(43),n2h4(19))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-16,nME,G2H8(7),n2h8(43))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(45),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(46),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(43),ex4(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(47),n2h4(22))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,nME,G2H8(8),n2h8(44))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QV_A(ntryL,G1H8(47),ex4(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(49),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(48),ex4(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(50),n2h4(24))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(51),n2h4(25))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-4,nME,G2H8(9),n2h8(45))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(53),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(54),ex4(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(54),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(55),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(55),n2h4(28))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-8,nME,G2H8(10),n2h8(46))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G1H8(59),ex1(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(57),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(60),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(58),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(59),n2h4(31))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,nME,G2H8(11),n2h8(47))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(65),ex5(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(61),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(66),ex5(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(62),n2h4(33))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(63),n2h4(34))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-4,nME,G2H8(12),n2h8(48))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(65),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),51,nME,G2H4(66),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(73),ex3(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(67),n2h4(37))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-16,nME,G2H8(13),n2h8(49))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_AV_Q(ntryL,G1H8(77),ex3(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(69),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(78),ex3(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(70),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(71),n2h4(40))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-8,nME,G2H8(14),n2h8(50))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AV_Q(ntryL,G1H8(83),ex3(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(73),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(84),ex3(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(74),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(85),ex4(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(75),n2h4(43))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-16,nME,G2H8(15),n2h8(51))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AV_Q(ntryL,G1H8(89),ex4(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(77),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(90),ex4(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(78),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(91),ex4(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(79),n2h4(46))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-4,nME,G2H8(16),n2h8(52))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(95),ex4(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(81),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),43,nME,G2H4(82),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(97),ex5(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(83),n2h4(49))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-8,nME,G2H8(17),n2h8(53))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AV_Q(ntryL,G1H8(101),ex5(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(85),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(102),ex5(:),G1H4(1),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(86),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(87),n2h4(52))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-4,nME,G2H8(18),n2h8(54))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_AV_Q(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(89),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(1),51,nME,G2H4(90),n2h4(54))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(17),mass5set(:,4),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(18),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(19),mass5set(:,4),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(17),mass5set(:,4),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(18),mass5set(:,4),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(19),mass5set(:,4),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(7),mass5set(:,2),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(20),mass5set(:,2),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(8),mass5set(:,2),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(21),mass5set(:,2),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(8),mass5set(:,2),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(22),mass5set(:,2),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(9),mass5set(:,3),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(23),mass5set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(9),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(24),mass5set(:,3),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(10),mass5set(:,2),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(25),mass5set(:,2),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(11),mass5set(:,2),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),16,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(26),mass5set(:,2),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(12),mass5set(:,3),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(23),mass5set(:,3),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),16,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(12),mass5set(:,3),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),4,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(27),mass5set(:,3),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(11),mass5set(:,2),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(28),mass5set(:,2),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(13),mass5set(:,3),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(24),mass5set(:,3),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(13),mass5set(:,3),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(27),mass5set(:,3),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(14),mass5set(:,3),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(29),mass5set(:,3),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(14),mass5set(:,3),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(30),mass5set(:,3),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),8,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(15),mass5set(:,3),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),16,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(29),mass5set(:,3),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(15),mass5set(:,3),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),4,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(31),mass5set(:,3),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),4,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(16),mass5set(:,3),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),8,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(30),mass5set(:,3),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),8,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(16),mass5set(:,3),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),4,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(31),mass5set(:,3),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),4,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(211),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(282)])
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nME,G2H4(1),n2h4(55))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(3),n2h2(2))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,nME,G2H4(3),n2h4(56))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(5),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(6),n2h2(4))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-16,nME,G2H4(4),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(8),n2h2(5))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,nME,G2H4(6),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(10),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(25),ex1(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(11),n2h2(7))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(26),-8,nME,G2H4(7),n2h4(59))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(13),n2h2(8))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-8,nME,G2H4(9),n2h4(60))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(36),ex1(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(15),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(16),n2h2(10))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-16,nME,G2H4(10),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(18),n2h2(11))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-16,nME,G2H4(12),n2h4(62))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VQ_A(ntryL,G1H4(48),ex1(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(20),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(21),n2h2(13))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-16,nME,G2H4(13),n2h4(63))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(23),n2h2(14))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,nME,G2H4(15),n2h4(64))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VQ_A(ntryL,G1H4(60),ex1(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(25),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(61),ex2(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(26),n2h2(16))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(62),-8,nME,G2H4(16),n2h4(65))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VA_Q(ntryL,G1H4(67),ex2(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(28),n2h2(17))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-8,nME,G2H4(18),n2h4(66))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VA_Q(ntryL,G1H4(72),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(30),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(73),ex3(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(31),n2h2(19))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-16,nME,G2H4(19),n2h4(67))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QV_A(ntryL,G1H4(79),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(33),n2h2(20))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-16,nME,G2H4(22),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(35),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(36),n2h2(22))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-16,nME,G2H4(23),n2h4(69))
  call Hloop_QV_A(ntryL,G2H4(23),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AV_Q(ntryL,G1H4(91),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(38),n2h2(23))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(92),-16,nME,G2H4(26),n2h4(70))
  call Hloop_QV_A(ntryL,G2H4(26),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AV_Q(ntryL,G1H4(96),ex4(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(40),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(97),ex5(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(41),n2h2(25))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(98),-8,nME,G2H4(27),n2h4(71))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AV_Q(ntryL,G1H4(103),ex5(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(43),n2h2(26))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-8,nME,G2H4(30),n2h4(72))
  call Hloop_QV_A(ntryL,G2H4(30),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AV_Q(ntryL,G1H4(108),ex5(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(45),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(46),n2h2(28))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(110),-16,nME,G2H4(31),n2h4(73))
  call Hloop_AV_Q(ntryL,G2H4(31),ex5(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QV_A(ntryL,G1H4(115),ex4(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(48),n2h2(29))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-16,nME,G2H4(34),n2h4(74))
  call Hloop_AV_Q(ntryL,G2H4(34),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QV_A(ntryL,G1H4(120),ex4(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(50),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(121),ex5(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(51),n2h2(31))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(122),-8,nME,G2H4(35),n2h4(75))
  call Hloop_AV_Q(ntryL,G2H4(35),ex4(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QV_A(ntryL,G1H4(127),ex5(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(53),n2h2(32))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(128),-8,nME,G2H4(38),n2h4(76))
  call Hloop_AV_Q(ntryL,G2H4(38),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(132),ex5(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(55),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(133),ex3(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(56),n2h2(34))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-16,nME,G2H4(39),n2h4(77))
  call Hloop_QV_A(ntryL,G2H4(39),ex5(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AV_Q(ntryL,G1H4(139),ex3(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(58),n2h2(35))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-16,nME,G2H4(42),n2h4(78))
  call Hloop_QV_A(ntryL,G2H4(42),ex5(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(144),ex3(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(60),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(145),ex4(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(61),n2h2(37))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-16,nME,G2H4(43),n2h4(79))
  call Hloop_AV_Q(ntryL,G2H4(43),ex5(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(63),n2h2(38))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(152),-16,nME,G2H4(46),n2h4(80))
  call Hloop_AV_Q(ntryL,G2H4(46),ex5(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(156),ex4(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(65),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(157),ex3(:),G1H2(1),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(66),n2h2(40))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(158),-16,nME,G2H4(47),n2h4(81))
  call Hloop_AV_Q(ntryL,G2H4(47),ex5(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(68),n2h2(41))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(164),-16,nME,G2H4(50),n2h4(82))
  call Hloop_AV_Q(ntryL,G2H4(50),ex5(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_QV_A(ntryL,G1H4(168),ex3(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(70),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(71),n2h2(43))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-4,nME,G2H4(51),n2h4(83))
  call Hloop_AV_Q(ntryL,G2H4(51),ex3(:),G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QV_A(ntryL,G1H4(175),ex5(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(73),n2h2(44))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-4,nME,G2H4(54),n2h4(84))
  call Hloop_AV_Q(ntryL,G2H4(54),ex3(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(180),ex5(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(75),n2h2(45))
  call Hloop_QV_A(ntryL,G1H4(181),ex5(:),G1H2(1),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(76),n2h2(46))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-8,nME,G2H4(55),n2h4(85))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QV_A(ntryL,G1H4(187),ex5(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(78),n2h2(47))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-8,nME,G2H4(58),n2h4(86))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QV_A(ntryL,G1H4(192),ex5(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(80),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(193),ex3(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(81),n2h2(49))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-8,nME,G2H4(59),n2h4(87))
  call Hloop_AV_Q(ntryL,G2H4(59),ex4(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(199),ex3(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(83),n2h2(50))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(200),-8,nME,G2H4(62),n2h4(88))
  call Hloop_AV_Q(ntryL,G2H4(62),ex4(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(204),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(1),55,nME,G2H2(85),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(205),ex4(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(86),n2h2(52))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(206),-4,nME,G2H4(63),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(63),ex3(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QV_A(ntryL,G1H4(211),ex4(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(88),n2h2(53))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(212),-4,nME,G2H4(66),n2h4(90))
  call Hloop_AV_Q(ntryL,G2H4(66),ex3(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QV_A(ntryL,G1H4(216),ex4(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(1),59,nME,G2H2(90),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(217),ex4(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(91),n2h2(55))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(218),-16,nME,G2H4(67),n2h4(91))
  call Hloop_QV_A(ntryL,G2H4(67),ex5(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(223),ex4(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(93),n2h2(56))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(224),-16,nME,G2H4(70),n2h4(92))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AV_Q(ntryL,G1H4(228),ex4(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(95),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H4(229),ex5(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(96),n2h2(58))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(230),-8,nME,G2H4(71),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(71),ex4(:),G2H2(97),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AV_Q(ntryL,G1H4(235),ex5(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(98),n2h2(59))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(236),-8,nME,G2H4(74),n2h4(94))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(99),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AV_Q(ntryL,G1H4(240),ex5(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(100),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(241),ex3(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(101),n2h2(61))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(242),-16,nME,G2H4(75),n2h4(95))
  call Hloop_QV_A(ntryL,G2H4(75),ex5(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AV_Q(ntryL,G1H4(247),ex3(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(103),n2h2(62))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(248),-16,nME,G2H4(78),n2h4(96))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AV_Q(ntryL,G1H4(252),ex3(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(105),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(253),ex5(:),G1H2(1),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(106),n2h2(64))
call HGT_OLR(G1H4(254),1,1,4)
call HGT_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(254),-4,nME,G2H4(79),n2h4(97))
  call Hloop_QV_A(ntryL,G2H4(79),ex3(:),G2H2(107),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AV_Q(ntryL,G1H4(259),ex5(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(108),n2h2(65))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(260),-4,nME,G2H4(82),n2h4(98))
  call Hloop_QV_A(ntryL,G2H4(82),ex3(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_AV_Q(ntryL,G1H4(264),ex5(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(110),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(265),ex3(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(111),n2h2(67))
call HGT_OLR(G1H4(266),1,1,4)
call HGT_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(266),-8,nME,G2H4(83),n2h4(99))
  call Hloop_QV_A(ntryL,G2H4(83),ex4(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AV_Q(ntryL,G1H4(271),ex3(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(113),n2h2(68))
call HGT_OLR(G1H4(272),1,1,4)
call HGT_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(272),-8,nME,G2H4(86),n2h4(100))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AV_Q(ntryL,G1H4(276),ex3(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(115),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(277),ex4(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(116),n2h2(70))
call HGT_OLR(G1H4(278),1,1,4)
call HGT_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(278),-4,nME,G2H4(87),n2h4(101))
  call Hloop_QV_A(ntryL,G2H4(87),ex3(:),G2H2(117),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_AV_Q(ntryL,G1H4(283),ex4(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(118),n2h2(71))
call HGT_OLR(G1H4(284),1,1,4)
call HGT_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(284),-4,nME,G2H4(90),n2h4(102))
  call Hloop_QV_A(ntryL,G2H4(90),ex3(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AV_Q(ntryL,G1H4(288),ex4(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(1),59,nME,G2H2(120),n2h2(72))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(5),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(6),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(7),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(8),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(8),mass5set(:,2),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(9),mass5set(:,3),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(9),mass5set(:,3),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(10),mass5set(:,2),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(11),mass5set(:,2),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(12),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),16,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(12),mass5set(:,3),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(11),mass5set(:,2),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(13),mass5set(:,3),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(13),mass5set(:,3),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(14),mass5set(:,3),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),16,2)
  call Hotf_5pt_reduction(G2H2(96),RedSet_5(14),mass5set(:,3),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(15),mass5set(:,3),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),16,2)
  call Hotf_5pt_reduction(G2H2(106),RedSet_5(15),mass5set(:,3),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(16),mass5set(:,3),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(16),mass5set(:,3),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),4,2)
  call Hloop_AV_Q(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(1))
  call Hloop_AV_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(2),n2h1(2))
  call Hloop_AV_Q(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(4),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(6),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(8),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(12),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(13),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(18),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(19),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(22),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(79),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(80),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(36),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H2(109),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(37),n2h1(37))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(38),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(39),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(40),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(41),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(42),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(43),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(44),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(45),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(46),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(47),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(48),n2h1(48))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(8),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(8),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(9),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(9),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(10),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(11),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(12),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(12),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(11),mass5set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(13),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(13),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(14),mass5set(:,3),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(14),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(15),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(15),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(16),mass5set(:,3),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(16),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,3,16,4,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(25))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,3,16,4,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(2),n2h32(26))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,16,4,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(3),n2h32(27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,3,16,4,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(4),n2h32(28))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(29))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(30))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(31))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(8),n2h32(32))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,3,8,4,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(33))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,3,8,4,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(10),n2h32(34))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,3,8,4,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(35))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,3,8,4,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(12),n2h32(36))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(13),n2h32(37))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(14),n2h32(38))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(39))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(16),n2h32(40))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,3,16,8,4],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(41))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,3,16,8,4],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(18),n2h32(42))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,3,16,8,4],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(43))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,3,16,8,4],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(20),n2h32(44))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(21),n2h32(45))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(22),n2h32(46))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(47))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(48))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,8,3,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(25),n2h32(49))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,8,3,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(26),n2h32(50))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,8,3,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(27),n2h32(51))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,8,3,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(28),n2h32(52))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(53))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(30),n2h32(54))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(55))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(32),n2h32(56))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,3,4,8,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(33),n2h32(57))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,3,4,8,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(34),n2h32(58))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,3,4,8,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(35),n2h32(59))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,3,4,8,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(36),n2h32(60))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(37),n2h32(61))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(38),n2h32(62))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(63))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(40),n2h32(64))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,8,4,3,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(41),n2h32(65))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,8,4,3,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,66),heltab2x64(:,:,66))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(42),n2h32(66))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,8,4,3,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(43),n2h32(67))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,8,4,3,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(44),n2h32(68))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(69))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(46),n2h32(70))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(71))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,72),heltab2x64(:,:,72))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(72))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,3,8,16,4],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(49),n2h32(73))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,3,8,16,4],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(50),n2h32(74))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,8,16,4],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(51),n2h32(75))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,8,16,4],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(52),n2h32(76))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(53),n2h32(77))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(54),n2h32(78))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(55),n2h32(79))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(56),n2h32(80))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,4,16,3,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(57),n2h32(81))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,4,16,3,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(58),n2h32(82))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,4,16,3,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(59),n2h32(83))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,4,16,3,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(60),n2h32(84))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(61),n2h32(85))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(62),n2h32(86))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(87))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,88))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(64),n2h32(88))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,3,4,16,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(65),n2h32(89))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,3,4,16,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(66),n2h32(90))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,3,4,16,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(67),n2h32(91))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,3,4,16,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(68),n2h32(92))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(93))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(70),n2h32(94))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(95))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(72),n2h32(96))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,8,3,4,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(73),n2h32(97))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,8,3,4,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,98),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(74),n2h32(98))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,8,3,4,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(75),n2h32(99))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,8,3,4,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(76),n2h32(100))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(77),n2h32(101))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(78),n2h32(102))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,103),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(79),n2h32(103))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(80),n2h32(104))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,3,16,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(81),n2h32(105))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,3,16,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(82),n2h32(106))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,3,16,8],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,107),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(83),n2h32(107))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,4,3,16,8],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(84),n2h32(108))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(85),n2h32(109))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(86),n2h32(110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(87),n2h32(111))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(88),n2h32(112))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,4,3,8,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(89),n2h32(113))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,4,3,8,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(90),n2h32(114))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,4,3,8,16],[nME,nME,nME,nME,nME],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,115),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(91),n2h32(115))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,4,3,8,16],[nMM,nMM,nMM,nMM,nMM],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(92),n2h32(116))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(93),n2h32(117))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(94),n2h32(118))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(95),n2h32(119))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(185)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(96),n2h32(120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,5,2,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(97),n2h32(121))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,8,2,5,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(98),n2h32(122))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,5,2,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(99),n2h32(123))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,8,5,2,16],[nME,nME,0,nME,nME],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,124),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(100),n2h32(124))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,2,5,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,125),heltab2x64(:,:,125))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(101),n2h32(125))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,2,5,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,126),heltab2x64(:,:,126))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(102),n2h32(126))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,6,1,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,127),heltab2x64(:,:,127))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(103),n2h32(127))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,8,1,6,16],[nME,nME,0,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,128),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(104),n2h32(128))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,6,1,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,129),heltab2x64(:,:,129))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(105),n2h32(129))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,8,6,1,16],[nME,nME,0,nME,nME],5,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,130),heltab2x64(:,:,130))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(106),n2h32(130))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,1,6,16,8],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,131),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(107),n2h32(131))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,1,6,8,16],[nME,0,nME,nME,nME],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,132),heltab2x64(:,:,132))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(108),n2h32(132))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,9,2,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,133),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(109),n2h32(133))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,4,2,9,16],[nME,nME,0,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,134),heltab2x64(:,:,134))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(110),n2h32(134))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,16,2,9],[nME,nME,nME,0,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,135),heltab2x64(:,:,135))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(111),n2h32(135))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,9,2,16],[nME,nME,0,nME,nME],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,136),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(112),n2h32(136))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,2,9,16,4],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,137),heltab2x64(:,:,137))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(113),n2h32(137))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,2,9,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,138),heltab2x64(:,:,138))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(114),n2h32(138))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,10,1,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(115),n2h32(139))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,4,1,10,16],[nME,nME,0,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(116),n2h32(140))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,4,16,1,10],[nME,nME,nME,0,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,141),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(117),n2h32(141))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,4,10,1,16],[nME,nME,0,nME,nME],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,142),heltab2x64(:,:,142))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(118),n2h32(142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,1,10,16,4],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(119),n2h32(143))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,1,10,4,16],[nME,0,nME,nME,nME],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(120),n2h32(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,8,4,2,17],[nME,nME,nME,0,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(121),n2h32(145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,4,2,17,8],[nME,nME,0,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(122),n2h32(146))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,4,8,2,17],[nME,nME,nME,0,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,147),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(123),n2h32(147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,4,17,2,8],[nME,nME,0,nME,nME],5,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(124),n2h32(148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,2,17,8,4],[nME,0,nME,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(125),n2h32(149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,2,17,4,8],[nME,0,nME,nME,nME],5,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,150),heltab2x64(:,:,150))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(126),n2h32(150))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,8,4,1,18],[nME,nME,nME,0,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,151),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(127),n2h32(151))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,4,1,18,8],[nME,nME,0,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,152),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(128),n2h32(152))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,4,8,1,18],[nME,nME,nME,0,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,153),heltab2x64(:,:,153))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(129),n2h32(153))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,4,18,1,8],[nME,nME,0,nME,nME],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,154),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(130),n2h32(154))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,1,18,8,4],[nME,0,nME,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,155),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(131),n2h32(155))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,1,18,4,8],[nME,0,nME,nME,nME],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,156),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(132),n2h32(156))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[33,2,4,8,16],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[33,2,4,16,8],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(2),m3h4x16(:,2),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[33,2,8,4,16],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(3),m3h4x16(:,3),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[33,2,8,16,4],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(4),m3h4x16(:,4),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[33,2,16,4,8],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(5),m3h4x16(:,5),heltab2x64(:,:,161))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[33,2,16,8,4],[0,nME,nME,nME,nME],5,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(6),m3h4x16(:,6),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[34,1,4,8,16],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,7),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[34,1,4,16,8],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,8),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[34,1,8,4,16],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,9),heltab2x64(:,:,165))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[34,1,8,16,4],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,10),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[34,1,16,4,8],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(11),m3h4x16(:,11),heltab2x64(:,:,167))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[34,1,16,8,4],[0,nME,nME,nME,nME],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(12),m3h4x16(:,12),heltab2x64(:,:,168))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(15),[G1H32(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(16),[G1H32(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(23),[G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(31),[G1H32(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(32),[G1H32(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(39),[G1H32(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(40),[G1H32(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(47),[G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(48),[G1H32(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(55),[G1H32(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(56),[G1H32(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(63),[G1H32(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(64),[G1H32(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(71),[G1H32(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(72),[G1H32(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(79),[G1H32(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(80),[G1H32(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(87),[G1H32(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(88),[G1H32(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(95),[G1H32(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(96),[G1H32(94)])
  call Hloop_AV_Q(ntryL,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(1),44,nME,G2H8(19),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(19),ex4(:),G1H8(2),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(2),44,nME,G2H8(22),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(5),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(5),52,nME,G2H8(23),n2h8(57))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(6),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(6),44,nME,G2H8(24),n2h8(58))
  call Hloop_QV_A(ntryL,G1H16(35),ex4(:),G1H8(7),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(7),44,nME,G2H8(27),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(41),ex5(:),G1H8(8),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(8),52,nME,G2H8(28),n2h8(60))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,49),G1H8(11),m3h4x8(:,1),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(11),35,nME,G2H8(29),n2h8(61))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,49),G1H8(12),m3h4x8(:,2),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(12),35,nMM,G2H8(32),n2h8(62))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,49),G1H8(13),m3h4x8(:,3),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(33),n2h8(63))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,49),G1H8(14),m3h4x8(:,4),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(14),35,nMM,G2H8(34),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H32(7),wf4(:,49),G1H8(17),m3h4x8(:,5),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(17),35,0,G2H8(37),n2h8(65))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,49),G1H8(18),m3h4x8(:,6),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(18),35,0,G2H8(38),n2h8(66))
  call Hloop_QV_A(ntryL,G1H32(9),wf4(:,49),G1H8(19),m3h4x8(:,7),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(19),35,nME,G2H8(39),n2h8(67))
  call Hloop_QV_A(ntryL,G1H32(10),wf4(:,49),G1H8(20),m3h4x8(:,8),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(20),35,nMM,G2H8(42),n2h8(68))
  call Hloop_AV_Q(ntryL,G1H32(11),wf4(:,49),G1H8(23),m3h4x8(:,9),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(23),35,nME,G2H8(43),n2h8(69))
  call Hloop_AV_Q(ntryL,G1H32(12),wf4(:,49),G1H8(24),m3h4x8(:,10),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(24),35,nMM,G2H8(44),n2h8(70))
  call Hloop_QV_A(ntryL,G1H32(15),wf4(:,49),G1H8(25),m3h4x8(:,11),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(25),35,0,G2H8(47),n2h8(71))
  call Hloop_AV_Q(ntryL,G1H32(16),wf4(:,49),G1H8(26),m3h4x8(:,12),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(26),35,0,G2H8(48),n2h8(72))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,49),G1H8(29),m3h4x8(:,13),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(29),35,nME,G2H8(1),n2h8(73))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,49),G1H8(30),m3h4x8(:,14),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(30),35,nMM,G2H8(2),n2h8(74))
  call Hloop_AV_Q(ntryL,G1H32(19),wf4(:,49),G1H8(31),m3h4x8(:,15),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(31),35,nME,G2H8(3),n2h8(75))
  call Hloop_AV_Q(ntryL,G1H32(20),wf4(:,49),G1H8(32),m3h4x8(:,16),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(32),35,nMM,G2H8(4),n2h8(76))
  call Hloop_QV_A(ntryL,G1H32(23),wf4(:,49),G1H8(35),m3h4x8(:,17),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(35),35,0,G2H8(5),n2h8(77))
  call Hloop_AV_Q(ntryL,G1H32(24),wf4(:,49),G1H8(36),m3h4x8(:,18),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(36),35,0,G2H8(6),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H32(25),ex3(:),G1H16(5),m3h2x16(:,25),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H16(5),36,nME,G2H16(7),n2h16(19))
  call Hloop_AV_Q(ntryL,G1H32(26),ex3(:),G1H16(6),m3h2x16(:,26),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G1H16(6),36,nMM,G2H16(8),n2h16(20))
  call Hloop_QV_A(ntryL,G1H32(27),ex3(:),G1H16(7),m3h2x16(:,27),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(7),36,nME,G2H16(9),n2h16(21))
  call Hloop_QV_A(ntryL,G1H32(28),ex3(:),G1H16(8),m3h2x16(:,28),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(8),36,nMM,G2H16(10),n2h16(22))
  call Hloop_AV_Q(ntryL,G1H32(31),ex3(:),G1H16(9),m3h2x16(:,29),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H16(9),36,0,G2H16(11),n2h16(23))
  call Hloop_QV_A(ntryL,G1H32(32),ex3(:),G1H16(10),m3h2x16(:,30),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(10),36,0,G2H16(12),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H32(33),wf4(:,49),G1H8(37),m3h4x8(:,19),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(37),35,nME,G2H8(7),n2h8(79))
  call Hloop_AV_Q(ntryL,G1H32(34),wf4(:,49),G1H8(38),m3h4x8(:,20),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(38),35,nMM,G2H8(8),n2h8(80))
  call Hloop_QV_A(ntryL,G1H32(35),wf4(:,49),G1H8(41),m3h4x8(:,21),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(41),35,nME,G2H8(9),n2h8(81))
  call Hloop_QV_A(ntryL,G1H32(36),wf4(:,49),G1H8(42),m3h4x8(:,22),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(42),35,nMM,G2H8(10),n2h8(82))
  call Hloop_AV_Q(ntryL,G1H32(39),wf4(:,49),G1H8(43),m3h4x8(:,23),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(43),35,0,G2H8(11),n2h8(83))
  call Hloop_QV_A(ntryL,G1H32(40),wf4(:,49),G1H8(44),m3h4x8(:,24),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(44),35,0,G2H8(12),n2h8(84))
  call Hloop_QV_A(ntryL,G1H32(41),ex4(:),G1H16(11),m3h2x16(:,31),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(11),40,nME,G2H16(1),n2h16(25))
  call Hloop_QV_A(ntryL,G1H32(42),ex4(:),G1H16(12),m3h2x16(:,32),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(12),40,nMM,G2H16(2),n2h16(26))
  call Hloop_AV_Q(ntryL,G1H32(43),ex4(:),G1H16(13),m3h2x16(:,33),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(13),40,nME,G2H16(3),n2h16(27))
  call Hloop_AV_Q(ntryL,G1H32(44),ex4(:),G1H16(14),m3h2x16(:,34),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H16(14),40,nMM,G2H16(4),n2h16(28))
  call Hloop_QV_A(ntryL,G1H32(47),ex4(:),G1H16(16),m3h2x16(:,35),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(16),40,0,G2H16(5),n2h16(29))
  call Hloop_AV_Q(ntryL,G1H32(48),ex4(:),G1H16(17),m3h2x16(:,36),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H16(17),40,0,G2H16(6),n2h16(30))
  call Hloop_QV_A(ntryL,G1H32(49),wf4(:,49),G1H8(47),m3h4x8(:,25),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(47),35,nME,G2H8(13),n2h8(85))
  call Hloop_QV_A(ntryL,G1H32(50),wf4(:,49),G1H8(48),m3h4x8(:,26),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(48),35,nMM,G2H8(14),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H32(51),wf4(:,49),G1H8(49),m3h4x8(:,27),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(49),35,nME,G2H8(15),n2h8(87))
  call Hloop_AV_Q(ntryL,G1H32(52),wf4(:,49),G1H8(50),m3h4x8(:,28),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(50),35,nMM,G2H8(16),n2h8(88))
  call Hloop_QV_A(ntryL,G1H32(55),wf4(:,49),G1H8(53),m3h4x8(:,29),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(53),35,0,G2H8(17),n2h8(89))
  call Hloop_AV_Q(ntryL,G1H32(56),wf4(:,49),G1H8(54),m3h4x8(:,30),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(54),35,0,G2H8(18),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H32(57),ex3(:),G1H16(18),m3h2x16(:,37),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(18),36,nME,G2H16(13),n2h16(31))
  call Hloop_AV_Q(ntryL,G1H32(58),ex3(:),G1H16(1),m3h2x16(:,38),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMM,G2H16(14),n2h16(32))
  call Hloop_QV_A(ntryL,G1H32(59),ex3(:),G1H16(2),m3h2x16(:,39),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(2),36,nME,G2H16(15),n2h16(33))
  call Hloop_QV_A(ntryL,G1H32(60),ex3(:),G1H16(20),m3h2x16(:,40),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H16(20),36,nMM,G2H16(16),n2h16(34))
  call Hloop_AV_Q(ntryL,G1H32(63),ex3(:),G1H16(21),m3h2x16(:,41),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G1H16(21),36,0,G2H16(17),n2h16(35))
  call Hloop_QV_A(ntryL,G1H32(64),ex3(:),G1H16(22),m3h2x16(:,42),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H16(22),36,0,G2H16(18),n2h16(36))
  call Hloop_AV_Q(ntryL,G1H32(65),wf4(:,49),G1H8(55),m3h4x8(:,31),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(55),35,nME,G2H8(49),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H32(66),wf4(:,49),G1H8(56),m3h4x8(:,32),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(56),35,nMM,G2H8(50),n2h8(92))
  call Hloop_QV_A(ntryL,G1H32(67),wf4(:,49),G1H8(59),m3h4x8(:,33),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(59),35,nME,G2H8(51),n2h8(93))
  call Hloop_QV_A(ntryL,G1H32(68),wf4(:,49),G1H8(60),m3h4x8(:,34),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(60),35,nMM,G2H8(52),n2h8(94))
  call Hloop_AV_Q(ntryL,G1H32(71),wf4(:,49),G1H8(61),m3h4x8(:,35),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(61),35,0,G2H8(53),n2h8(95))
  call Hloop_QV_A(ntryL,G1H32(72),wf4(:,49),G1H8(62),m3h4x8(:,36),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(62),35,0,G2H8(54),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H32(73),ex4(:),G1H16(23),m3h2x16(:,43),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G1H16(23),40,nME,G2H16(19),n2h16(37))
  call Hloop_AV_Q(ntryL,G1H32(74),ex4(:),G1H16(24),m3h2x16(:,44),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G1H16(24),40,nMM,G2H16(20),n2h16(38))
  call Hloop_QV_A(ntryL,G1H32(75),ex4(:),G1H16(26),m3h2x16(:,45),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(26),40,nME,G2H16(21),n2h16(39))
  call Hloop_QV_A(ntryL,G1H32(76),ex4(:),G1H16(27),m3h2x16(:,46),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G1H16(27),40,nMM,G2H16(22),n2h16(40))
  call Hloop_AV_Q(ntryL,G1H32(79),ex4(:),G1H16(28),m3h2x16(:,47),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G1H16(28),40,0,G2H16(23),n2h16(41))
  call Hloop_QV_A(ntryL,G1H32(80),ex4(:),G1H16(3),m3h2x16(:,48),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H16(3),40,0,G2H16(24),n2h16(42))
  call Hloop_QV_A(ntryL,G1H32(81),ex3(:),G1H16(4),m3h2x16(:,49),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(4),36,nME,G2H16(25),n2h16(43))
  call Hloop_QV_A(ntryL,G1H32(82),ex3(:),G1H16(30),m3h2x16(:,50),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H16(30),36,nMM,G2H16(26),n2h16(44))
  call Hloop_AV_Q(ntryL,G1H32(83),ex3(:),G1H16(31),m3h2x16(:,51),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G1H16(31),36,nME,G2H16(27),n2h16(45))
  call Hloop_AV_Q(ntryL,G1H32(84),ex3(:),G1H16(32),m3h2x16(:,52),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G1H16(32),36,nMM,G2H16(28),n2h16(46))
  call Hloop_QV_A(ntryL,G1H32(87),ex3(:),G1H16(33),m3h2x16(:,53),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H16(33),36,0,G2H16(29),n2h16(47))
  call Hloop_AV_Q(ntryL,G1H32(88),ex3(:),G1H16(34),m3h2x16(:,54),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G1H16(34),36,0,G2H16(30),n2h16(48))
  call Hloop_QV_A(ntryL,G1H32(89),ex3(:),G1H16(36),m3h2x16(:,55),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H16(36),36,nME,G2H16(31),n2h16(49))
  call Hloop_QV_A(ntryL,G1H32(90),ex3(:),G1H16(37),m3h2x16(:,56),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G1H16(37),36,nMM,G2H16(32),n2h16(50))
  call Hloop_AV_Q(ntryL,G1H32(91),ex3(:),G1H16(38),m3h2x16(:,57),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G1H16(38),36,nME,G2H16(33),n2h16(51))
  call Hloop_AV_Q(ntryL,G1H32(92),ex3(:),G1H16(39),m3h2x16(:,58),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H16(39),36,nMM,G2H16(34),n2h16(52))
  call Hloop_QV_A(ntryL,G1H32(95),ex3(:),G1H16(40),m3h2x16(:,59),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H16(40),36,0,G2H16(35),n2h16(53))
  call Hloop_AV_Q(ntryL,G1H32(96),ex3(:),G1H16(42),m3h2x16(:,60),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H16(42),36,0,G2H16(36),n2h16(54))
  call Hloop_AQ_V(ntryL,G1H32(97),wf4(:,3),G1H8(65),m3h4x8(:,37),heltab2x32(:,:,97))
  call Hloop_QV_A(ntryL,G1H32(98),ex4(:),G1H16(43),m3h2x16(:,61),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(43),40,nME,G2H16(37),n2h16(55))
  call Hloop_AQ_V(ntryL,G1H32(99),wf4(:,3),G1H8(66),m3h4x8(:,38),heltab2x32(:,:,99))
  call Hloop_AV_Q(ntryL,G1H32(100),ex4(:),G1H16(44),m3h2x16(:,62),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G1H16(44),40,nME,G2H16(38),n2h16(56))
  call Hloop_QA_V(ntryL,G1H32(101),ex2(:),G1H16(15),m3h2x16(:,63),heltab2x32(:,:,101))
  call Hloop_QA_V(ntryL,G1H32(102),ex2(:),G1H16(19),m3h2x16(:,64),heltab2x32(:,:,102))
  call Hloop_QA_V(ntryL,G1H32(103),wf4(:,12),G1H8(67),m3h4x8(:,39),heltab2x32(:,:,103))
  call Hloop_AV_Q(ntryL,G1H32(104),ex4(:),G1H16(25),m3h2x16(:,65),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G1H16(25),40,nME,G2H16(39),n2h16(57))
  call Hloop_QA_V(ntryL,G1H32(105),wf4(:,12),G1H8(68),m3h4x8(:,40),heltab2x32(:,:,105))
  call Hloop_QV_A(ntryL,G1H32(106),ex4(:),G1H16(29),m3h2x16(:,66),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G1H16(29),40,nME,G2H16(40),n2h16(58))
  call Hloop_AQ_V(ntryL,G1H32(107),ex1(:),G1H16(35),m3h2x16(:,67),heltab2x32(:,:,107))
  call Hloop_AQ_V(ntryL,G1H32(108),ex1(:),G1H16(41),m3h2x16(:,68),heltab2x32(:,:,108))
  call Hloop_AQ_V(ntryL,G1H32(109),wf4(:,11),G1H8(71),m3h4x8(:,41),heltab2x32(:,:,109))
  call Hloop_QV_A(ntryL,G1H32(110),ex3(:),G1H16(5),m3h2x16(:,69),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G1H16(5),36,nME,G2H16(41),n2h16(59))
  call Hloop_QV_A(ntryL,G1H32(111),ex3(:),G1H16(6),m3h2x16(:,70),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(6),36,nME,G2H16(42),n2h16(60))
  call Hloop_AV_Q(ntryL,G1H32(112),ex3(:),G1H16(7),m3h2x16(:,71),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H16(7),36,nME,G2H16(43),n2h16(61))
  call Hloop_QA_V(ntryL,G1H32(113),ex2(:),G1H16(8),m3h2x16(:,72),heltab2x32(:,:,113))
  call Hloop_QA_V(ntryL,G1H32(114),ex2(:),G1H16(9),m3h2x16(:,73),heltab2x32(:,:,114))
  call Hloop_QA_V(ntryL,G1H32(115),wf4(:,4),G1H8(72),m3h4x8(:,42),heltab2x32(:,:,115))
  call Hloop_AV_Q(ntryL,G1H32(116),ex3(:),G1H16(10),m3h2x16(:,74),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G1H16(10),36,nME,G2H16(44),n2h16(62))
  call Hloop_AV_Q(ntryL,G1H32(117),ex3(:),G1H16(11),m3h2x16(:,75),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G1H16(11),36,nME,G2H16(45),n2h16(63))
  call Hloop_QV_A(ntryL,G1H32(118),ex3(:),G1H16(12),m3h2x16(:,76),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H16(12),36,nME,G2H16(46),n2h16(64))
  call Hloop_AQ_V(ntryL,G1H32(119),ex1(:),G1H16(13),m3h2x16(:,77),heltab2x32(:,:,119))
  call Hloop_AQ_V(ntryL,G1H32(120),ex1(:),G1H16(14),m3h2x16(:,78),heltab2x32(:,:,120))
  call Hloop_QV_A(ntryL,G1H32(121),ex4(:),G1H16(16),m3h2x16(:,79),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G1H16(16),40,nME,G2H16(47),n2h16(65))
  call Hloop_QV_A(ntryL,G1H32(122),ex3(:),G1H16(17),m3h2x16(:,80),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G1H16(17),36,nME,G2H16(48),n2h16(66))
  call Hloop_QV_A(ntryL,G1H32(123),ex3(:),G1H16(18),m3h2x16(:,81),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G1H16(18),36,nME,G2H16(49),n2h16(67))
  call Hloop_AV_Q(ntryL,G1H32(124),ex3(:),G1H16(1),m3h2x16(:,82),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G1H16(1),36,nME,G2H16(50),n2h16(68))
  call Hloop_QA_V(ntryL,G1H32(125),ex2(:),G1H16(2),m3h2x16(:,83),heltab2x32(:,:,125))
  call Hloop_QA_V(ntryL,G1H32(126),ex2(:),G1H16(20),m3h2x16(:,84),heltab2x32(:,:,126))
  call Hloop_AV_Q(ntryL,G1H32(127),ex4(:),G1H16(21),m3h2x16(:,85),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G1H16(21),40,nME,G2H16(51),n2h16(69))
  call Hloop_AV_Q(ntryL,G1H32(128),ex3(:),G1H16(22),m3h2x16(:,86),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G1H16(22),36,nME,G2H16(52),n2h16(70))
  call Hloop_AV_Q(ntryL,G1H32(129),ex3(:),G1H16(23),m3h2x16(:,87),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G1H16(23),36,nME,G2H16(53),n2h16(71))
  call Hloop_QV_A(ntryL,G1H32(130),ex3(:),G1H16(24),m3h2x16(:,88),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(24),36,nME,G2H16(54),n2h16(72))
  call Hloop_AQ_V(ntryL,G1H32(131),ex1(:),G1H16(26),m3h2x16(:,89),heltab2x32(:,:,131))
  call Hloop_AQ_V(ntryL,G1H32(132),ex1(:),G1H16(27),m3h2x16(:,90),heltab2x32(:,:,132))
  call Hloop_VA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(73),n2h8(97))
  call Hloop_VA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(74),n2h8(98))
  call Hloop_VA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(77),n2h8(99))
  call Hloop_VA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(78),n2h8(100))
  call Hloop_VA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(79),n2h8(101))
  call Hloop_VA_Q(ntryL,G0H16(6),ex2(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),35,nME,G1H8(80),n2h8(102))
  call Hloop_VQ_A(ntryL,G0H16(7),ex1(:),G0H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(83),n2h8(103))
  call Hloop_VQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(84),n2h8(104))
  call Hloop_VQ_A(ntryL,G0H16(9),ex1(:),G0H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(85),n2h8(105))
  call Hloop_VQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(86),n2h8(106))
  call Hloop_VQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(89),n2h8(107))
  call Hloop_VQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),35,nME,G1H8(90),n2h8(108))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G2H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(67),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G1H8(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(106)])
call HGT_OLR(G2H8(20),1,1,8)
call HGT_invQ_OLR(G2H8(20),2,5,8)
call HGT_OLR(G2H8(20),6,15,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(32),mass5set(:,1),  & 
G1H8(91),G1H8(92),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(92),2,8)
  call Hloop_AQ_V(ntryL,G2H8(26),ex1(:),G2H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
call HGT_OLR(G2H8(25),1,1,8)
call HGT_invQ_OLR(G2H8(25),2,5,8)
call HGT_OLR(G2H8(25),6,15,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(33),mass5set(:,1),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(102),2,8)
call HGT_OLR(G2H8(30),1,1,8)
call HGT_invQ_OLR(G2H8(30),2,5,8)
call HGT_OLR(G2H8(30),6,15,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(34),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(2),1,8)
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(3),m3h2x4(:,92),heltab2x8(:,:,92))
call HGT_OLR(G2H8(35),1,1,8)
call HGT_invQ_OLR(G2H8(35),2,5,8)
call HGT_OLR(G2H8(35),6,15,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(35),mass5set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(12),1,8)
  call Hloop_QA_V(ntryL,G2H8(41),ex2(:),G2H4(4),m3h2x4(:,93),heltab2x8(:,:,93))
call HGT_OLR(G2H8(40),1,1,8)
call HGT_invQ_OLR(G2H8(40),2,5,8)
call HGT_OLR(G2H8(40),6,15,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(36),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(20),1,8)
call HGT_OLR(G2H8(45),1,1,8)
call HGT_invQ_OLR(G2H8(45),2,5,8)
call HGT_OLR(G2H8(45),6,15,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(37),mass5set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(30),2,8)
  call Hloop_AQ_V(ntryL,G2H8(46),ex1(:),G2H4(6),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(6),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(6),43,nME,G2H4(7),n2h4(103))
  call Hloop_VQ_A(ntryL,G1H8(72),ex1(:),G1H4(18),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(18),43,nME,G2H4(9),n2h4(104))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(30),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(30),39,nME,G2H4(10),n2h4(105))
  call Hloop_VA_Q(ntryL,G1H8(65),ex2(:),G1H4(42),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(42),39,nME,G2H4(12),n2h4(106))
  call Hloop_VA_Q(ntryL,G1H8(15),ex2(:),G1H4(54),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(54),39,nME,G2H4(13),n2h4(107))
  call Hloop_VA_Q(ntryL,G1H8(66),ex2(:),G1H4(66),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(66),39,nME,G2H4(15),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(83),ex3(:),G1H4(78),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(78),39,nME,G2H4(16),n2h4(109))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(38),mass5set(:,4),  & 
G1H8(37),G1H8(38),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hloop_QV_A(ntryL,G1H8(84),ex3(:),G1H4(90),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(90),39,nME,G2H4(18),n2h4(110))
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(39),mass5set(:,4),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(48),8,8)
  call Hloop_VA_Q(ntryL,G1H8(33),ex2(:),G1H4(102),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(102),43,nME,G2H4(19),n2h4(111))
  call Hloop_VA_Q(ntryL,G1H8(71),ex2(:),G1H4(114),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(114),43,nME,G2H4(22),n2h4(112))
  call Hloop_VQ_A(ntryL,G1H8(39),ex1(:),G1H4(126),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(126),39,nME,G2H4(23),n2h4(113))
  call Hloop_VQ_A(ntryL,G1H8(67),ex1(:),G1H4(138),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(138),39,nME,G2H4(26),n2h4(114))
  call Hloop_QV_A(ntryL,G1H8(85),ex4(:),G1H4(150),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(150),43,nME,G2H4(27),n2h4(115))
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(40),mass5set(:,4),  & 
G1H8(55),G1H8(56),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(56),16,8)
  call Hloop_QV_A(ntryL,G1H8(86),ex4(:),G1H4(162),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(162),43,nME,G2H4(30),n2h4(116))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(41),mass5set(:,4),  & 
G1H8(4),G1H8(10),G1H8(16),G1H8(21),G1H8(22),G1H8(27),8)
  call HG1shiftOLR(G1H8(10),4,8)
  call Hloop_VQ_A(ntryL,G1H8(57),ex1(:),G1H4(174),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(174),39,nME,G2H4(31),n2h4(117))
  call Hloop_VQ_A(ntryL,G1H8(68),ex1(:),G1H4(186),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(186),39,nME,G2H4(34),n2h4(118))
  call Hloop_QV_A(ntryL,G1H8(89),ex5(:),G1H4(198),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(198),51,nME,G2H4(35),n2h4(119))
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(42),mass5set(:,4),  & 
G1H8(28),G1H8(34),G1H8(40),G1H8(45),G1H8(46),G1H8(51),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hloop_QV_A(ntryL,G1H8(90),ex5(:),G1H4(210),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(210),51,nME,G2H4(38),n2h4(120))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(43),mass5set(:,4),  & 
G1H8(52),G1H8(58),G1H8(63),G1H8(64),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(58),4,8)
  call Hloop_AV_Q(ntryL,G1H8(73),ex3(:),G1H4(222),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(222),39,nME,G2H4(39),n2h4(121))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(38),mass5set(:,4),  & 
G1H8(75),G1H8(76),G1H8(81),G1H8(82),G1H8(87),G1H8(88),8)
  call HG1shiftOLR(G1H8(76),16,8)
  call Hloop_AV_Q(ntryL,G1H8(74),ex3(:),G1H4(234),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(234),39,nME,G2H4(42),n2h4(122))
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(39),mass5set(:,4),  & 
G1H8(93),G1H8(94),G1H8(99),G1H8(100),G1H8(105),G1H8(106),8)
  call HG1shiftOLR(G1H8(94),8,8)
  call Hloop_AV_Q(ntryL,G1H8(77),ex4(:),G1H4(246),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(246),43,nME,G2H4(43),n2h4(123))
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(40),mass5set(:,4),  & 
G1H8(3),G1H8(72),G1H8(9),G1H8(65),G1H8(15),G1H8(66),8)
  call HG1shiftOLR(G1H8(72),16,8)
  call Hloop_AV_Q(ntryL,G1H8(78),ex4(:),G1H4(258),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(258),43,nME,G2H4(46),n2h4(124))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(41),mass5set(:,4),  & 
G1H8(83),G1H8(84),G1H8(33),G1H8(71),G1H8(39),G1H8(67),8)
  call HG1shiftOLR(G1H8(84),4,8)
  call Hloop_AV_Q(ntryL,G1H8(79),ex5(:),G1H4(270),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(270),51,nME,G2H4(47),n2h4(125))
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(42),mass5set(:,4),  & 
G1H8(85),G1H8(86),G1H8(57),G1H8(68),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hloop_AV_Q(ntryL,G1H8(80),ex5(:),G1H4(282),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(282),51,nME,G2H4(50),n2h4(126))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(43),mass5set(:,4),  & 
G1H8(73),G1H8(74),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(74),4,8)
  call Hloop_AQ_V(ntryL,G2H8(19),ex1(:),G2H4(51),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_AQ_V(ntryL,G2H8(22),ex1(:),G2H4(54),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(55),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_QA_V(ntryL,G2H8(24),ex2(:),G2H4(58),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(59),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_AQ_V(ntryL,G2H8(28),ex1(:),G2H4(62),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(42),mass5set(:,5),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(42),mass5set(:,5),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),8,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(42),mass5set(:,6),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(42),mass5set(:,6),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(40),mass5set(:,5),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),16,8)
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(40),mass5set(:,5),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),16,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(40),mass5set(:,6),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),16,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(40),mass5set(:,6),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(43),mass5set(:,5),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),4,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(43),mass5set(:,5),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),4,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(43),mass5set(:,6),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),4,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(43),mass5set(:,6),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),4,8)
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(18),mass5set(:,4),  & 
G1H16(28),G1H16(3),G1H16(4),G1H16(30),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(3),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(18),mass5set(:,5),  & 
G1H16(33),G1H16(34),G1H16(36),G1H16(37),G1H16(38),G1H16(39),16)
  call HG1shiftOLR(G1H16(34),16,16)
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(18),mass5set(:,4),  & 
G1H16(40),G1H16(42),G1H16(43),G1H16(44),G1H16(25),G1H16(29),16)
  call HG1shiftOLR(G1H16(42),16,16)
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(18),mass5set(:,5),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(6),16,16)
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(18),mass5set(:,6),  & 
G1H16(16),G1H16(17),G1H16(18),G1H16(1),G1H16(21),G1H16(22),16)
  call HG1shiftOLR(G1H16(17),16,16)
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(18),mass5set(:,6),  & 
G1H16(23),G1H16(24),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(24),16,16)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(38),mass5set(:,5),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(38),mass5set(:,5),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),16,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(38),mass5set(:,6),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),16,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(38),mass5set(:,6),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),16,8)
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(17),mass5set(:,4),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),16,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(17),mass5set(:,5),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),16,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(17),mass5set(:,4),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
  call HG1shiftOLR(G1H16(62),16,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(17),mass5set(:,5),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),16,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(17),mass5set(:,6),  & 
G1H16(73),G1H16(74),G1H16(75),G1H16(76),G1H16(77),G1H16(78),16)
  call HG1shiftOLR(G1H16(74),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(17),mass5set(:,6),  & 
G1H16(79),G1H16(80),G1H16(81),G1H16(82),G1H16(83),G1H16(84),16)
  call HG1shiftOLR(G1H16(80),16,16)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(41),mass5set(:,5),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),4,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(41),mass5set(:,5),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(41),mass5set(:,6),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),4,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(41),mass5set(:,6),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),4,8)
  call Hotf_5pt_reduction(G2H16(13),RedSet_5(19),mass5set(:,4),  & 
G1H16(85),G1H16(86),G1H16(87),G1H16(88),G1H16(89),G1H16(90),16)
  call HG1shiftOLR(G1H16(86),8,16)
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(19),mass5set(:,5),  & 
G1H16(91),G1H16(92),G1H16(93),G1H16(94),G1H16(95),G1H16(96),16)
  call HG1shiftOLR(G1H16(92),8,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(19),mass5set(:,4),  & 
G1H16(97),G1H16(98),G1H16(99),G1H16(100),G1H16(101),G1H16(102),16)
  call HG1shiftOLR(G1H16(98),8,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(19),mass5set(:,5),  & 
G1H16(103),G1H16(104),G1H16(105),G1H16(106),G1H16(107),G1H16(108),16)
  call HG1shiftOLR(G1H16(104),8,16)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(19),mass5set(:,6),  & 
G1H16(109),G1H16(110),G1H16(111),G1H16(112),G1H16(113),G1H16(114),16)
  call HG1shiftOLR(G1H16(110),8,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(19),mass5set(:,6),  & 
G1H16(115),G1H16(116),G1H16(117),G1H16(118),G1H16(119),G1H16(120),16)
  call HG1shiftOLR(G1H16(116),8,16)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(39),mass5set(:,5),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(39),mass5set(:,5),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(39),mass5set(:,6),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(39),mass5set(:,6),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(44),mass5set(:,4),  & 
G1H16(121),G1H16(122),G1H16(123),G1H16(124),G1H16(125),G1H16(126),16)
  call HG1shiftOLR(G1H16(122),16,16)
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(44),mass5set(:,5),  & 
G1H16(127),G1H16(128),G1H16(129),G1H16(130),G1H16(131),G1H16(132),16)
  call HG1shiftOLR(G1H16(128),16,16)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(44),mass5set(:,4),  & 
G1H16(133),G1H16(134),G1H16(135),G1H16(136),G1H16(137),G1H16(138),16)
  call HG1shiftOLR(G1H16(134),16,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(44),mass5set(:,5),  & 
G1H16(139),G1H16(140),G1H16(141),G1H16(142),G1H16(143),G1H16(144),16)
  call HG1shiftOLR(G1H16(140),16,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(44),mass5set(:,6),  & 
G1H16(145),G1H16(146),G1H16(147),G1H16(148),G1H16(149),G1H16(150),16)
  call HG1shiftOLR(G1H16(146),16,16)
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(44),mass5set(:,6),  & 
G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),G1H16(156),16)
  call HG1shiftOLR(G1H16(152),16,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(45),mass5set(:,4),  & 
G1H16(157),G1H16(158),G1H16(159),G1H16(160),G1H16(161),G1H16(162),16)
  call HG1shiftOLR(G1H16(158),8,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(45),mass5set(:,5),  & 
G1H16(163),G1H16(164),G1H16(165),G1H16(166),G1H16(167),G1H16(168),16)
  call HG1shiftOLR(G1H16(164),8,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(45),mass5set(:,4),  & 
G1H16(169),G1H16(170),G1H16(171),G1H16(172),G1H16(173),G1H16(174),16)
  call HG1shiftOLR(G1H16(170),8,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(45),mass5set(:,5),  & 
G1H16(175),G1H16(176),G1H16(177),G1H16(178),G1H16(179),G1H16(180),16)
  call HG1shiftOLR(G1H16(176),8,16)
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(45),mass5set(:,6),  & 
G1H16(181),G1H16(182),G1H16(183),G1H16(184),G1H16(185),G1H16(186),16)
  call HG1shiftOLR(G1H16(182),8,16)
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(45),mass5set(:,6),  & 
G1H16(187),G1H16(188),G1H16(189),G1H16(190),G1H16(191),G1H16(192),16)
  call HG1shiftOLR(G1H16(188),8,16)
  call Hotf_5pt_reduction(G2H16(31),RedSet_5(46),mass5set(:,4),  & 
G1H16(193),G1H16(194),G1H16(195),G1H16(196),G1H16(197),G1H16(198),16)
  call HG1shiftOLR(G1H16(194),16,16)
  call Hotf_5pt_reduction(G2H16(32),RedSet_5(46),mass5set(:,5),  & 
G1H16(199),G1H16(200),G1H16(201),G1H16(202),G1H16(203),G1H16(204),16)
  call HG1shiftOLR(G1H16(200),16,16)
  call Hotf_5pt_reduction(G2H16(33),RedSet_5(46),mass5set(:,4),  & 
G1H16(205),G1H16(206),G1H16(207),G1H16(208),G1H16(209),G1H16(210),16)
  call HG1shiftOLR(G1H16(206),16,16)
  call Hotf_5pt_reduction(G2H16(34),RedSet_5(46),mass5set(:,5),  & 
G1H16(211),G1H16(212),G1H16(213),G1H16(214),G1H16(215),G1H16(216),16)
  call HG1shiftOLR(G1H16(212),16,16)
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(46),mass5set(:,6),  & 
G1H16(217),G1H16(218),G1H16(219),G1H16(220),G1H16(221),G1H16(222),16)
  call HG1shiftOLR(G1H16(218),16,16)
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(46),mass5set(:,6),  & 
G1H16(223),G1H16(224),G1H16(225),G1H16(226),G1H16(227),G1H16(228),16)
  call HG1shiftOLR(G1H16(224),16,16)
  call Hloop_QA_V(ntryL,G2H16(37),ex2(:),G2H8(21),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G2H16(38),wf4(:,3),G2H4(63),m3h4x4(:,1),heltab2x16(:,:,68))
  call Hloop_VQ_A(ntryL,G1H16(15),wf4(:,3),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),39,nME,G2H4(66),n2h4(127))
  call Hloop_VQ_A(ntryL,G1H16(19),wf4(:,3),G1H4(2),m3h4x4(:,3),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(2),39,nME,G2H4(67),n2h4(128))
  call Hloop_AQ_V(ntryL,G2H16(39),ex1(:),G2H8(36),m3h2x8(:,68),heltab2x16(:,:,71))
  call Hloop_QA_V(ntryL,G2H16(40),wf4(:,12),G2H4(70),m3h4x4(:,4),heltab2x16(:,:,72))
  call Hloop_VA_Q(ntryL,G1H16(35),wf4(:,12),G1H4(7),m3h4x4(:,5),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(7),39,nME,G2H4(71),n2h4(129))
  call Hloop_VA_Q(ntryL,G1H16(41),wf4(:,12),G1H4(8),m3h4x4(:,6),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(8),39,nME,G2H4(74),n2h4(130))
  call Hloop_QA_V(ntryL,G2H16(41),ex2(:),G2H8(20),m3h2x8(:,69),heltab2x16(:,:,75))
  call Hotf_5pt_reduction(G2H16(42),RedSet_5(3),mass5set(:,1),  & 
G1H16(15),G1H16(19),G1H16(35),G1H16(41),G1H16(229),G1H16(230),16)
  call HG1shiftOLR(G1H16(19),9,16)
  call Hloop_AQ_V(ntryL,G2H16(43),wf4(:,11),G2H4(75),m3h4x4(:,7),heltab2x16(:,:,76))
  call Hloop_VQ_A(ntryL,G1H16(8),wf4(:,11),G1H4(12),m3h4x4(:,8),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(12),43,nME,G2H4(78),n2h4(131))
  call Hloop_VQ_A(ntryL,G1H16(9),wf4(:,11),G1H4(13),m3h4x4(:,9),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(13),43,nME,G2H4(79),n2h4(132))
  call Hloop_AQ_V(ntryL,G2H16(44),ex1(:),G2H8(26),m3h2x8(:,70),heltab2x16(:,:,79))
  call Hotf_5pt_reduction(G2H16(45),RedSet_5(6),mass5set(:,1),  & 
G1H16(8),G1H16(9),G1H16(231),G1H16(232),G1H16(233),G1H16(234),16)
  call HG1shiftOLR(G1H16(9),10,16)
  call Hloop_QA_V(ntryL,G2H16(46),wf4(:,4),G2H4(82),m3h4x4(:,10),heltab2x16(:,:,80))
  call Hloop_VA_Q(ntryL,G1H16(13),wf4(:,4),G1H4(14),m3h4x4(:,11),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(14),43,nME,G2H4(83),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H16(14),wf4(:,4),G1H4(19),m3h4x4(:,12),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(19),43,nME,G2H4(86),n2h4(134))
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(4),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(235),G1H16(236),G1H16(237),G1H16(238),16)
  call HG1shiftOLR(G1H16(14),17,16)
  call Hloop_QA_V(ntryL,G2H16(48),ex2(:),G2H8(25),m3h2x8(:,71),heltab2x16(:,:,83))
  call Hotf_5pt_reduction(G2H16(49),RedSet_5(5),mass5set(:,1),  & 
G1H16(239),G1H16(240),G1H16(241),G1H16(242),G1H16(243),G1H16(244),16)
  call HG1shiftOLR(G1H16(240),17,16)
  call Hloop_AQ_V(ntryL,G2H16(50),wf4(:,14),G2H4(87),m3h4x4(:,13),heltab2x16(:,:,84))
  call Hloop_VQ_A(ntryL,G1H16(2),wf4(:,14),G1H4(20),m3h4x4(:,14),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(20),51,nME,G2H4(90),n2h4(135))
  call Hloop_VQ_A(ntryL,G1H16(20),wf4(:,14),G1H4(24),m3h4x4(:,15),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(24),51,nME,G2H4(91),n2h4(136))
  call Hotf_5pt_reduction(G2H16(51),RedSet_5(1),mass5set(:,1),  & 
G1H16(2),G1H16(20),G1H16(245),G1H16(246),G1H16(247),G1H16(248),16)
  call HG1shiftOLR(G1H16(20),18,16)
  call Hloop_AQ_V(ntryL,G2H16(52),ex1(:),G2H8(30),m3h2x8(:,72),heltab2x16(:,:,87))
  call Hotf_5pt_reduction(G2H16(53),RedSet_5(2),mass5set(:,1),  & 
G1H16(249),G1H16(250),G1H16(251),G1H16(252),G1H16(253),G1H16(254),16)
  call HG1shiftOLR(G1H16(250),18,16)
  call Hloop_QA_V(ntryL,G2H16(54),wf4(:,6),G2H4(92),m3h4x4(:,16),heltab2x16(:,:,88))
  call Hloop_VA_Q(ntryL,G1H16(26),wf4(:,6),G1H4(25),m3h4x4(:,17),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(25),51,nME,G2H4(93),n2h4(137))
  call Hloop_VA_Q(ntryL,G1H16(27),wf4(:,6),G1H4(26),m3h4x4(:,18),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(26),51,nME,G2H4(94),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H8(91),ex3(:),G1H4(31),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(31),60,nME,G2H4(95),n2h4(139))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-2,nME,G2H8(31),n2h8(109))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(96),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_AV_Q(ntryL,G1H8(96),ex3(:),G1H4(32),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(32),60,nME,G2H4(97),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H8(97),ex3(:),G1H4(36),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(36),60,nME,G2H4(98),n2h4(141))
  call Hloop_AV_Q(ntryL,G1H8(98),ex3(:),G1H4(37),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(37),60,nME,G2H4(99),n2h4(142))
  call Hloop_AV_Q(ntryL,G1H8(101),ex4(:),G1H4(38),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(38),60,nME,G2H4(100),n2h4(143))
call HGT_OLR(G1H8(102),1,1,8)
call HGT_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(102),-2,nME,G2H8(35),n2h8(110))
  call Hloop_QA_V(ntryL,G2H8(35),ex2(:),G2H4(101),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_AV_Q(ntryL,G1H8(104),ex4(:),G1H4(43),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(43),60,nME,G2H4(102),n2h4(144))
  call Hloop_AV_Q(ntryL,G1H8(107),ex4(:),G1H4(44),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(44),60,nME,G2H4(103),n2h4(145))
  call Hloop_AV_Q(ntryL,G1H8(108),ex4(:),G1H4(48),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(48),60,nME,G2H4(104),n2h4(146))
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(49),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(49),60,nME,G2H4(105),n2h4(147))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-1,nME,G2H8(41),n2h8(111))
  call Hloop_AQ_V(ntryL,G2H8(41),ex1(:),G2H4(106),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_QV_A(ntryL,G1H8(6),ex5(:),G1H4(50),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(50),60,nME,G2H4(107),n2h4(148))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(55),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(55),60,nME,G2H4(108),n2h4(149))
  call Hloop_QV_A(ntryL,G1H8(8),ex5(:),G1H4(56),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(56),60,nME,G2H4(109),n2h4(150))
  call Hloop_QV_A(ntryL,G1H8(11),ex3(:),G1H4(60),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(60),60,nME,G2H4(110),n2h4(151))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(12),-1,nME,G2H8(40),n2h8(112))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(111),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_QV_A(ntryL,G1H8(14),ex3(:),G1H4(61),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(61),60,nME,G2H4(112),n2h4(152))
  call Hloop_QV_A(ntryL,G1H8(17),ex3(:),G1H4(62),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(62),60,nME,G2H4(113),n2h4(153))
  call Hloop_QV_A(ntryL,G1H8(18),ex3(:),G1H4(67),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(67),60,nME,G2H4(114),n2h4(154))
  call Hloop_QV_A(ntryL,G1H8(19),ex4(:),G1H4(68),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(68),60,nME,G2H4(115),n2h4(155))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-1,nME,G2H8(45),n2h8(113))
  call Hloop_AQ_V(ntryL,G2H8(45),ex1(:),G2H4(116),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(24),ex4(:),G1H4(72),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(72),60,nME,G2H4(117),n2h4(156))
  call Hloop_QV_A(ntryL,G1H8(25),ex4(:),G1H4(73),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(73),60,nME,G2H4(118),n2h4(157))
  call Hloop_QV_A(ntryL,G1H8(26),ex4(:),G1H4(74),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(74),60,nME,G2H4(119),n2h4(158))
  call Hloop_AV_Q(ntryL,G1H8(29),ex5(:),G1H4(79),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(79),60,nME,G2H4(120),n2h4(159))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(30),-2,nME,G2H8(46),n2h8(114))
  call Hloop_QA_V(ntryL,G2H8(46),ex2(:),G2H4(121),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AV_Q(ntryL,G1H8(32),ex5(:),G1H4(80),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(80),60,nME,G2H4(122),n2h4(160))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(84),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(84),60,nME,G2H4(123),n2h4(161))
  call Hloop_AV_Q(ntryL,G1H8(36),ex5(:),G1H4(85),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(85),60,nME,G2H4(124),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(37),ex3(:),G1H4(86),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(86),39,nME,G2H4(125),n2h4(163))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-16,nME,G2H8(9),n2h8(115))
  call Hloop_AV_Q(ntryL,G2H8(9),ex5(:),G2H4(126),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_QV_A(ntryL,G1H8(42),ex3(:),G1H4(91),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(91),39,nME,G2H4(127),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(43),ex3(:),G1H4(92),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(92),39,nME,G2H4(128),n2h4(165))
  call Hloop_QV_A(ntryL,G1H8(44),ex3(:),G1H4(96),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(96),39,nME,G2H4(129),n2h4(166))
  call Hloop_QV_A(ntryL,G1H8(47),ex3(:),G1H4(97),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(97),39,nME,G2H4(130),n2h4(167))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(48),-8,nME,G2H8(51),n2h8(116))
  call Hloop_AV_Q(ntryL,G2H8(51),ex4(:),G2H4(131),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_QV_A(ntryL,G1H8(50),ex3(:),G1H4(98),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(98),39,nME,G2H4(132),n2h4(168))
  call Hloop_QV_A(ntryL,G1H8(53),ex3(:),G1H4(103),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(103),39,nME,G2H4(133),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(54),ex3(:),G1H4(104),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(104),39,nME,G2H4(134),n2h4(170))
  call Hloop_QV_A(ntryL,G1H8(55),ex4(:),G1H4(108),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(108),43,nME,G2H4(135),n2h4(171))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-16,nME,G2H8(39),n2h8(117))
  call Hloop_AV_Q(ntryL,G2H8(39),ex5(:),G2H4(136),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_QV_A(ntryL,G1H8(60),ex4(:),G1H4(109),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(109),43,nME,G2H4(137),n2h4(172))
  call Hloop_QV_A(ntryL,G1H8(61),ex4(:),G1H4(110),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(110),43,nME,G2H4(138),n2h4(173))
  call Hloop_QV_A(ntryL,G1H8(62),ex4(:),G1H4(115),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(115),43,nME,G2H4(139),n2h4(174))
  call Hloop_QV_A(ntryL,G1H8(4),ex4(:),G1H4(116),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(116),43,nME,G2H4(140),n2h4(175))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(10),-4,nME,G2H8(13),n2h8(118))
  call Hloop_AV_Q(ntryL,G2H8(13),ex3(:),G2H4(141),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_QV_A(ntryL,G1H8(21),ex4(:),G1H4(120),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(120),43,nME,G2H4(142),n2h4(176))
  call Hloop_QV_A(ntryL,G1H8(22),ex4(:),G1H4(121),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(121),43,nME,G2H4(143),n2h4(177))
  call Hloop_QV_A(ntryL,G1H8(27),ex4(:),G1H4(122),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(122),43,nME,G2H4(144),n2h4(178))
  call Hloop_QV_A(ntryL,G1H8(28),ex5(:),G1H4(127),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(127),51,nME,G2H4(145),n2h4(179))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(34),-8,nME,G2H8(33),n2h8(119))
  call Hloop_AV_Q(ntryL,G2H8(33),ex4(:),G2H4(146),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_QV_A(ntryL,G1H8(45),ex5(:),G1H4(128),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(128),51,nME,G2H4(147),n2h4(180))
  call Hloop_QV_A(ntryL,G1H8(46),ex5(:),G1H4(132),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(132),51,nME,G2H4(148),n2h4(181))
  call Hloop_QV_A(ntryL,G1H8(51),ex5(:),G1H4(133),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(133),51,nME,G2H4(149),n2h4(182))
  call Hloop_QV_A(ntryL,G1H8(52),ex5(:),G1H4(134),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(134),51,nME,G2H4(150),n2h4(183))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(58),-4,nME,G2H8(1),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(1),ex3(:),G2H4(151),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QV_A(ntryL,G1H8(64),ex5(:),G1H4(139),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(139),51,nME,G2H4(152),n2h4(184))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(140),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(140),51,nME,G2H4(153),n2h4(185))
  call Hloop_QV_A(ntryL,G1H8(70),ex5(:),G1H4(144),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(144),51,nME,G2H4(154),n2h4(186))
  call Hloop_AV_Q(ntryL,G1H8(75),ex3(:),G1H4(145),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(145),39,nME,G2H4(155),n2h4(187))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(76),-16,nME,G2H8(7),n2h8(121))
  call Hloop_QV_A(ntryL,G2H8(7),ex5(:),G2H4(156),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_AV_Q(ntryL,G1H8(82),ex3(:),G1H4(146),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(146),39,nME,G2H4(157),n2h4(188))
  call Hloop_AV_Q(ntryL,G1H8(87),ex3(:),G1H4(151),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(151),39,nME,G2H4(158),n2h4(189))
  call Hloop_AV_Q(ntryL,G1H8(88),ex3(:),G1H4(152),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(152),39,nME,G2H4(159),n2h4(190))
  call Hloop_AV_Q(ntryL,G1H8(93),ex3(:),G1H4(156),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(156),39,nME,G2H4(160),n2h4(191))
call HGT_OLR(G1H8(94),1,1,8)
call HGT_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(94),-8,nME,G2H8(49),n2h8(122))
  call Hloop_QV_A(ntryL,G2H8(49),ex4(:),G2H4(161),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_AV_Q(ntryL,G1H8(100),ex3(:),G1H4(157),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(157),39,nME,G2H4(162),n2h4(192))
  call Hloop_AV_Q(ntryL,G1H8(105),ex3(:),G1H4(158),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(158),39,nME,G2H4(163),n2h4(193))
  call Hloop_AV_Q(ntryL,G1H8(106),ex3(:),G1H4(163),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(163),39,nME,G2H4(164),n2h4(194))
  call Hloop_AV_Q(ntryL,G1H8(3),ex4(:),G1H4(164),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(164),43,nME,G2H4(165),n2h4(195))
call HGT_OLR(G1H8(72),1,1,8)
call HGT_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(72),-16,nME,G2H8(43),n2h8(123))
  call Hloop_QV_A(ntryL,G2H8(43),ex5(:),G2H4(166),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_AV_Q(ntryL,G1H8(65),ex4(:),G1H4(168),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(168),43,nME,G2H4(167),n2h4(196))
  call Hloop_AV_Q(ntryL,G1H8(15),ex4(:),G1H4(169),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(169),43,nME,G2H4(168),n2h4(197))
  call Hloop_AV_Q(ntryL,G1H8(66),ex4(:),G1H4(170),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(170),43,nME,G2H4(169),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H8(83),ex4(:),G1H4(175),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(175),43,nME,G2H4(170),n2h4(199))
call HGT_OLR(G1H8(84),1,1,8)
call HGT_invQ_OLR(G1H8(84),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(84),-4,nME,G2H8(15),n2h8(124))
  call Hloop_QV_A(ntryL,G2H8(15),ex3(:),G2H4(171),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_AV_Q(ntryL,G1H8(71),ex4(:),G1H4(176),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(176),43,nME,G2H4(172),n2h4(200))
  call Hloop_AV_Q(ntryL,G1H8(39),ex4(:),G1H4(180),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(180),43,nME,G2H4(173),n2h4(201))
  call Hloop_AV_Q(ntryL,G1H8(67),ex4(:),G1H4(181),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(181),43,nME,G2H4(174),n2h4(202))
  call Hloop_AV_Q(ntryL,G1H8(85),ex5(:),G1H4(182),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(182),51,nME,G2H4(175),n2h4(203))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,nME,G2H8(29),n2h8(125))
  call Hloop_QV_A(ntryL,G2H8(29),ex4(:),G2H4(176),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_AV_Q(ntryL,G1H8(68),ex5(:),G1H4(187),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(187),51,nME,G2H4(177),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H8(89),ex5(:),G1H4(188),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(188),51,nME,G2H4(178),n2h4(205))
  call Hloop_AV_Q(ntryL,G1H8(90),ex5(:),G1H4(192),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(192),51,nME,G2H4(179),n2h4(206))
  call Hloop_AV_Q(ntryL,G1H8(73),ex5(:),G1H4(193),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(193),51,nME,G2H4(180),n2h4(207))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-4,nME,G2H8(3),n2h8(126))
  call Hloop_QV_A(ntryL,G2H8(3),ex3(:),G2H4(181),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_AV_Q(ntryL,G1H8(78),ex5(:),G1H4(194),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H4(194),51,nME,G2H4(182),n2h4(208))
  call Hloop_AV_Q(ntryL,G1H8(79),ex5(:),G1H4(199),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H4(199),51,nME,G2H4(183),n2h4(209))
  call Hloop_AV_Q(ntryL,G1H8(80),ex5(:),G1H4(200),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(200),51,nME,G2H4(184),n2h4(210))
  call Hloop_AV_Q(ntryL,G1H8(109),ex5(:),G1H4(204),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(204),51,nMM,G2H4(185),n2h4(211))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-8,nMM,G2H8(19),n2h8(127))
  call Hloop_QV_A(ntryL,G2H8(19),ex4(:),G2H4(186),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_AV_Q(ntryL,G1H8(112),ex5(:),G1H4(205),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(205),51,nMM,G2H4(187),n2h4(212))
  call Hloop_AV_Q(ntryL,G1H8(113),ex5(:),G1H4(206),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(206),51,nMM,G2H4(188),n2h4(213))
  call Hloop_AV_Q(ntryL,G1H8(114),ex5(:),G1H4(211),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(211),51,nMM,G2H4(189),n2h4(214))
  call Hloop_QV_A(ntryL,G1H8(115),ex5(:),G1H4(212),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(212),51,nMM,G2H4(190),n2h4(215))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(116),-8,nMM,G2H8(22),n2h8(128))
  call Hloop_AV_Q(ntryL,G2H8(22),ex4(:),G2H4(191),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_QV_A(ntryL,G1H8(118),ex5(:),G1H4(216),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(216),51,nMM,G2H4(192),n2h4(216))
  call Hloop_QV_A(ntryL,G1H8(119),ex5(:),G1H4(217),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(217),51,nMM,G2H4(193),n2h4(217))
  call Hloop_QV_A(ntryL,G1H8(120),ex5(:),G1H4(218),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(218),51,nMM,G2H4(194),n2h4(218))
  call Hloop_AV_Q(ntryL,G1H8(121),ex5(:),G1H4(223),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(223),51,0,G2H4(195),n2h4(219))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(122),-8,0,G2H8(23),n2h8(129))
  call Hloop_QV_A(ntryL,G2H8(23),ex4(:),G2H4(196),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_AV_Q(ntryL,G1H8(124),ex5(:),G1H4(224),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_A_Q(ntryL,G1H4(224),51,0,G2H4(197),n2h4(220))
  call Hloop_AV_Q(ntryL,G1H8(125),ex5(:),G1H4(228),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(228),51,0,G2H4(198),n2h4(221))
  call Hloop_AV_Q(ntryL,G1H8(126),ex5(:),G1H4(229),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(229),51,0,G2H4(199),n2h4(222))
  call Hloop_QV_A(ntryL,G1H8(127),ex5(:),G1H4(230),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(230),51,0,G2H4(200),n2h4(223))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-8,0,G2H8(24),n2h8(130))
  call Hloop_AV_Q(ntryL,G2H8(24),ex4(:),G2H4(201),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_QV_A(ntryL,G1H8(130),ex5(:),G1H4(235),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(235),51,0,G2H4(202),n2h4(224))
  call Hloop_QV_A(ntryL,G1H8(131),ex5(:),G1H4(236),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(236),51,0,G2H4(203),n2h4(225))
  call Hloop_QV_A(ntryL,G1H8(132),ex5(:),G1H4(240),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H4(240),51,0,G2H4(204),n2h4(226))
  call Hloop_QV_A(ntryL,G1H8(133),ex4(:),G1H4(241),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(241),43,nMM,G2H4(205),n2h4(227))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(134),-16,nMM,G2H8(27),n2h8(131))
  call Hloop_AV_Q(ntryL,G2H8(27),ex5(:),G2H4(206),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_QV_A(ntryL,G1H8(136),ex4(:),G1H4(242),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(242),43,nMM,G2H4(207),n2h4(228))
  call Hloop_QV_A(ntryL,G1H8(137),ex4(:),G1H4(247),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(247),43,nMM,G2H4(208),n2h4(229))
  call Hloop_QV_A(ntryL,G1H8(138),ex4(:),G1H4(248),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(248),43,nMM,G2H4(209),n2h4(230))
  call Hloop_AV_Q(ntryL,G1H8(139),ex4(:),G1H4(252),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(252),43,nMM,G2H4(210),n2h4(231))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-16,nMM,G2H8(28),n2h8(132))
  call Hloop_QV_A(ntryL,G2H8(28),ex5(:),G2H4(211),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_AV_Q(ntryL,G1H8(142),ex4(:),G1H4(253),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_A_Q(ntryL,G1H4(253),43,nMM,G2H4(212),n2h4(232))
  call Hloop_AV_Q(ntryL,G1H8(143),ex4(:),G1H4(254),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_A_Q(ntryL,G1H4(254),43,nMM,G2H4(213),n2h4(233))
  call Hloop_AV_Q(ntryL,G1H8(144),ex4(:),G1H4(259),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(259),43,nMM,G2H4(214),n2h4(234))
  call Hloop_QV_A(ntryL,G1H8(145),ex4(:),G1H4(260),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(260),43,0,G2H4(215),n2h4(235))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(146),-16,0,G2H8(32),n2h8(133))
  call Hloop_AV_Q(ntryL,G2H8(32),ex5(:),G2H4(216),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_QV_A(ntryL,G1H8(148),ex4(:),G1H4(264),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(264),43,0,G2H4(217),n2h4(236))
  call Hloop_QV_A(ntryL,G1H8(149),ex4(:),G1H4(265),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(265),43,0,G2H4(218),n2h4(237))
  call Hloop_QV_A(ntryL,G1H8(150),ex4(:),G1H4(266),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(266),43,0,G2H4(219),n2h4(238))
  call Hloop_AV_Q(ntryL,G1H8(151),ex4(:),G1H4(271),m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H4(271),43,0,G2H4(220),n2h4(239))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(152),-16,0,G2H8(34),n2h8(134))
  call Hloop_QV_A(ntryL,G2H8(34),ex5(:),G2H4(221),m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_AV_Q(ntryL,G1H8(154),ex4(:),G1H4(272),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(272),43,0,G2H4(222),n2h4(240))
  call Hloop_AV_Q(ntryL,G1H8(155),ex4(:),G1H4(276),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(276),43,0,G2H4(223),n2h4(241))
  call Hloop_AV_Q(ntryL,G1H8(156),ex4(:),G1H4(277),m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(277),43,0,G2H4(224),n2h4(242))
  call Hloop_QV_A(ntryL,G1H8(157),ex5(:),G1H4(278),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(278),51,nMM,G2H4(225),n2h4(243))
call HGT_OLR(G1H8(158),1,1,8)
call HGT_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(158),-4,nMM,G2H8(37),n2h8(135))
  call Hloop_AV_Q(ntryL,G2H8(37),ex3(:),G2H4(226),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_QV_A(ntryL,G1H8(160),ex5(:),G1H4(283),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(283),51,nMM,G2H4(227),n2h4(244))
  call Hloop_QV_A(ntryL,G1H8(161),ex5(:),G1H4(284),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(284),51,nMM,G2H4(228),n2h4(245))
  call Hloop_QV_A(ntryL,G1H8(162),ex5(:),G1H4(288),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G1H4(288),51,nMM,G2H4(229),n2h4(246))
  call Hloop_AV_Q(ntryL,G1H8(163),ex5(:),G1H4(6),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(6),51,nMM,G2H4(230),n2h4(247))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(164),-4,nMM,G2H8(38),n2h8(136))
  call Hloop_QV_A(ntryL,G2H8(38),ex3(:),G2H4(231),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_AV_Q(ntryL,G1H8(166),ex5(:),G1H4(18),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(18),51,nMM,G2H4(232),n2h4(248))
  call Hloop_AV_Q(ntryL,G1H8(167),ex5(:),G1H4(30),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(30),51,nMM,G2H4(233),n2h4(249))
  call Hloop_AV_Q(ntryL,G1H8(168),ex5(:),G1H4(42),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(42),51,nMM,G2H4(234),n2h4(250))
  call Hloop_QV_A(ntryL,G1H8(169),ex5(:),G1H4(54),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(54),51,0,G2H4(235),n2h4(251))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(170),-4,0,G2H8(42),n2h8(137))
  call Hloop_AV_Q(ntryL,G2H8(42),ex3(:),G2H4(236),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_QV_A(ntryL,G1H8(172),ex5(:),G1H4(66),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(66),51,0,G2H4(237),n2h4(252))
  call Hloop_QV_A(ntryL,G1H8(173),ex5(:),G1H4(78),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(78),51,0,G2H4(238),n2h4(253))
  call Hloop_QV_A(ntryL,G1H8(174),ex5(:),G1H4(90),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(90),51,0,G2H4(239),n2h4(254))
  call Hloop_AV_Q(ntryL,G1H8(175),ex5(:),G1H4(102),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G1H4(102),51,0,G2H4(240),n2h4(255))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-4,0,G2H8(44),n2h8(138))
  call Hloop_QV_A(ntryL,G2H8(44),ex3(:),G2H4(241),m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_AV_Q(ntryL,G1H8(178),ex5(:),G1H4(114),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G1H4(114),51,0,G2H4(242),n2h4(256))
  call Hloop_AV_Q(ntryL,G1H8(179),ex5(:),G1H4(126),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G1H4(126),51,0,G2H4(243),n2h4(257))
  call Hloop_AV_Q(ntryL,G1H8(180),ex5(:),G1H4(138),m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G1H4(138),51,0,G2H4(244),n2h4(258))
  call Hloop_AV_Q(ntryL,G1H16(28),ex4(:),G1H8(91),m3h2x8(:,73),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(91),44,nME,G2H8(47),n2h8(139))
call HGT_OLR(G1H16(3),1,1,16)
call HGT_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(3),-16,nME,G2H16(7),n2h16(73))
  call Hloop_QV_A(ntryL,G2H16(7),ex5(:),G2H8(48),m3h2x8(:,74),heltab2x16(:,:,92))
  call Hloop_AV_Q(ntryL,G1H16(30),ex4(:),G1H8(92),m3h2x8(:,75),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(92),44,nME,G2H8(2),n2h8(140))
  call Hloop_AV_Q(ntryL,G1H16(31),ex4(:),G1H8(96),m3h2x8(:,76),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(96),44,nME,G2H8(4),n2h8(141))
  call Hloop_AV_Q(ntryL,G1H16(32),ex4(:),G1H8(97),m3h2x8(:,77),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(97),44,nME,G2H8(5),n2h8(142))
  call Hloop_AV_Q(ntryL,G1H16(33),ex4(:),G1H8(98),m3h2x8(:,78),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(98),44,nMM,G2H8(6),n2h8(143))
call HGT_OLR(G1H16(34),1,1,16)
call HGT_invQ_OLR(G1H16(34),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(34),-16,nMM,G2H16(8),n2h16(74))
  call Hloop_QV_A(ntryL,G2H16(8),ex5(:),G2H8(8),m3h2x8(:,79),heltab2x16(:,:,97))
  call Hloop_AV_Q(ntryL,G1H16(37),ex4(:),G1H8(101),m3h2x8(:,80),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H8(101),44,nMM,G2H8(10),n2h8(144))
  call Hloop_AV_Q(ntryL,G1H16(38),ex4(:),G1H8(102),m3h2x8(:,81),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(102),44,nMM,G2H8(11),n2h8(145))
  call Hloop_AV_Q(ntryL,G1H16(39),ex4(:),G1H8(104),m3h2x8(:,82),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(104),44,nMM,G2H8(12),n2h8(146))
  call Hloop_QV_A(ntryL,G1H16(40),ex4(:),G1H8(107),m3h2x8(:,83),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(107),44,nME,G2H8(14),n2h8(147))
call HGT_OLR(G1H16(42),1,1,16)
call HGT_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(42),-16,nME,G2H16(9),n2h16(75))
  call Hloop_AV_Q(ntryL,G2H16(9),ex5(:),G2H8(16),m3h2x8(:,84),heltab2x16(:,:,102))
  call Hloop_QV_A(ntryL,G1H16(44),ex4(:),G1H8(108),m3h2x8(:,85),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(108),44,nME,G2H8(17),n2h8(148))
  call Hloop_QV_A(ntryL,G1H16(25),ex4(:),G1H8(1),m3h2x8(:,86),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(1),44,nME,G2H8(18),n2h8(149))
  call Hloop_QV_A(ntryL,G1H16(29),ex4(:),G1H8(2),m3h2x8(:,87),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(2),44,nME,G2H8(50),n2h8(150))
  call Hloop_QV_A(ntryL,G1H16(5),ex4(:),G1H8(6),m3h2x8(:,88),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(6),44,nMM,G2H8(52),n2h8(151))
call HGT_OLR(G1H16(6),1,1,16)
call HGT_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(6),-16,nMM,G2H16(10),n2h16(76))
  call Hloop_AV_Q(ntryL,G2H16(10),ex5(:),G2H8(53),m3h2x8(:,89),heltab2x16(:,:,107))
  call Hloop_QV_A(ntryL,G1H16(10),ex4(:),G1H8(7),m3h2x8(:,90),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(7),44,nMM,G2H8(54),n2h8(152))
  call Hloop_QV_A(ntryL,G1H16(11),ex4(:),G1H8(8),m3h2x8(:,91),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(8),44,nMM,G2H8(31),n2h8(153))
  call Hloop_QV_A(ntryL,G1H16(12),ex4(:),G1H8(11),m3h2x8(:,92),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(11),44,nMM,G2H8(35),n2h8(154))
  call Hloop_AV_Q(ntryL,G1H16(16),ex4(:),G1H8(12),m3h2x8(:,93),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(12),44,0,G2H8(41),n2h8(155))
call HGT_OLR(G1H16(17),1,1,16)
call HGT_invQ_OLR(G1H16(17),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(17),-16,0,G2H16(11),n2h16(77))
  call Hloop_QV_A(ntryL,G2H16(11),ex5(:),G2H8(40),m3h2x8(:,94),heltab2x16(:,:,112))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(14),m3h2x8(:,95),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G1H8(14),44,0,G2H8(45),n2h8(156))
  call Hloop_AV_Q(ntryL,G1H16(21),ex4(:),G1H8(17),m3h2x8(:,96),heltab2x16(:,:,114))
  call Hloop_A_Q(ntryL,G1H8(17),44,0,G2H8(46),n2h8(157))
  call Hloop_AV_Q(ntryL,G1H16(22),ex4(:),G1H8(18),m3h2x8(:,97),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(9),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(23),ex4(:),G1H8(19),m3h2x8(:,98),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(19),44,0,G2H8(51),n2h8(159))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(24),-16,0,G2H16(12),n2h16(78))
  call Hloop_AV_Q(ntryL,G2H16(12),ex5(:),G2H8(39),m3h2x8(:,99),heltab2x16(:,:,117))
  call Hloop_QV_A(ntryL,G1H16(46),ex4(:),G1H8(20),m3h2x8(:,100),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(20),44,0,G2H8(13),n2h8(160))
  call Hloop_QV_A(ntryL,G1H16(47),ex4(:),G1H8(24),m3h2x8(:,101),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(24),44,0,G2H8(33),n2h8(161))
  call Hloop_QV_A(ntryL,G1H16(48),ex4(:),G1H8(25),m3h2x8(:,102),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(25),44,0,G2H8(1),n2h8(162))
  call Hloop_AV_Q(ntryL,G1H8(181),ex3(:),G1H4(150),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(150),39,nMM,G2H4(245),n2h4(259))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(182),-16,nMM,G2H8(7),n2h8(163))
  call Hloop_QV_A(ntryL,G2H8(7),ex5(:),G2H4(246),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_AV_Q(ntryL,G1H8(184),ex3(:),G1H4(162),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_A_Q(ntryL,G1H4(162),39,nMM,G2H4(247),n2h4(260))
  call Hloop_AV_Q(ntryL,G1H8(185),ex3(:),G1H4(174),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_A_Q(ntryL,G1H4(174),39,nMM,G2H4(248),n2h4(261))
  call Hloop_AV_Q(ntryL,G1H8(186),ex3(:),G1H4(186),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(186),39,nMM,G2H4(249),n2h4(262))
  call Hloop_QV_A(ntryL,G1H8(187),ex3(:),G1H4(198),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(198),39,nMM,G2H4(250),n2h4(263))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(188),-16,nMM,G2H8(49),n2h8(164))
  call Hloop_AV_Q(ntryL,G2H8(49),ex5(:),G2H4(251),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_QV_A(ntryL,G1H8(190),ex3(:),G1H4(210),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(210),39,nMM,G2H4(252),n2h4(264))
  call Hloop_QV_A(ntryL,G1H8(191),ex3(:),G1H4(222),m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(222),39,nMM,G2H4(253),n2h4(265))
  call Hloop_QV_A(ntryL,G1H8(192),ex3(:),G1H4(234),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G1H4(234),39,nMM,G2H4(254),n2h4(266))
  call Hloop_AV_Q(ntryL,G1H8(193),ex3(:),G1H4(246),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(246),39,0,G2H4(255),n2h4(267))
call HGT_OLR(G1H8(194),1,1,8)
call HGT_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(194),-16,0,G2H8(43),n2h8(165))
  call Hloop_QV_A(ntryL,G2H8(43),ex5(:),G2H4(256),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_AV_Q(ntryL,G1H8(196),ex3(:),G1H4(258),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(258),39,0,G2H4(257),n2h4(268))
  call Hloop_AV_Q(ntryL,G1H8(197),ex3(:),G1H4(270),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(270),39,0,G2H4(258),n2h4(269))
  call Hloop_AV_Q(ntryL,G1H8(198),ex3(:),G1H4(282),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(282),39,0,G2H4(259),n2h4(270))
  call Hloop_QV_A(ntryL,G1H8(199),ex3(:),G1H4(1),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(260),n2h4(271))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(200),-16,0,G2H8(15),n2h8(166))
  call Hloop_AV_Q(ntryL,G2H8(15),ex5(:),G2H4(261),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_QV_A(ntryL,G1H8(202),ex3(:),G1H4(2),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(262),n2h4(272))
  call Hloop_QV_A(ntryL,G1H8(203),ex3(:),G1H4(7),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(7),39,0,G2H4(263),n2h4(273))
  call Hloop_QV_A(ntryL,G1H8(204),ex3(:),G1H4(8),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(8),39,0,G2H4(264),n2h4(274))
  call Hloop_QV_A(ntryL,G1H16(49),ex3(:),G1H8(26),m3h2x8(:,103),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(26),44,nME,G2H8(29),n2h8(167))
call HGT_OLR(G1H16(50),1,1,16)
call HGT_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(50),-16,nME,G2H16(1),n2h16(79))
  call Hloop_AV_Q(ntryL,G2H16(1),ex5(:),G2H8(3),m3h2x8(:,104),heltab2x16(:,:,122))
  call Hloop_QV_A(ntryL,G1H16(52),ex3(:),G1H8(29),m3h2x8(:,105),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H8(29),44,nME,G2H8(19),n2h8(168))
  call Hloop_QV_A(ntryL,G1H16(53),ex3(:),G1H8(30),m3h2x8(:,106),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(30),44,nME,G2H8(22),n2h8(169))
  call Hloop_QV_A(ntryL,G1H16(54),ex3(:),G1H8(32),m3h2x8(:,107),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H8(32),44,nME,G2H8(23),n2h8(170))
  call Hloop_QV_A(ntryL,G1H16(55),ex3(:),G1H8(35),m3h2x8(:,108),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(35),44,nMM,G2H8(24),n2h8(171))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(56),-16,nMM,G2H16(2),n2h16(80))
  call Hloop_AV_Q(ntryL,G2H16(2),ex5(:),G2H8(27),m3h2x8(:,109),heltab2x16(:,:,127))
  call Hloop_QV_A(ntryL,G1H16(58),ex3(:),G1H8(36),m3h2x8(:,110),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H8(36),44,nMM,G2H8(28),n2h8(172))
  call Hloop_QV_A(ntryL,G1H16(59),ex3(:),G1H8(37),m3h2x8(:,111),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(37),44,nMM,G2H8(32),n2h8(173))
  call Hloop_QV_A(ntryL,G1H16(60),ex3(:),G1H8(38),m3h2x8(:,112),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(38),44,nMM,G2H8(34),n2h8(174))
  call Hloop_AV_Q(ntryL,G1H16(61),ex3(:),G1H8(42),m3h2x8(:,113),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H8(42),44,nME,G2H8(37),n2h8(175))
call HGT_OLR(G1H16(62),1,1,16)
call HGT_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(62),-16,nME,G2H16(3),n2h16(81))
  call Hloop_QV_A(ntryL,G2H16(3),ex5(:),G2H8(38),m3h2x8(:,114),heltab2x16(:,:,132))
  call Hloop_AV_Q(ntryL,G1H16(64),ex3(:),G1H8(43),m3h2x8(:,115),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H8(43),44,nME,G2H8(42),n2h8(176))
  call Hloop_AV_Q(ntryL,G1H16(65),ex3(:),G1H8(44),m3h2x8(:,116),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(44),44,nME,G2H8(44),n2h8(177))
  call Hloop_AV_Q(ntryL,G1H16(66),ex3(:),G1H8(47),m3h2x8(:,117),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(7),n2h8(178))
  call Hloop_AV_Q(ntryL,G1H16(67),ex3(:),G1H8(48),m3h2x8(:,118),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(48),44,nMM,G2H8(49),n2h8(179))
call HGT_OLR(G1H16(68),1,1,16)
call HGT_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(68),-16,nMM,G2H16(4),n2h16(82))
  call Hloop_QV_A(ntryL,G2H16(4),ex5(:),G2H8(43),m3h2x8(:,119),heltab2x16(:,:,137))
  call Hloop_AV_Q(ntryL,G1H16(70),ex3(:),G1H8(50),m3h2x8(:,120),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H8(50),44,nMM,G2H8(15),n2h8(180))
  call Hloop_AV_Q(ntryL,G1H16(71),ex3(:),G1H8(53),m3h2x8(:,121),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(53),44,nMM,G2H8(55),n2h8(181))
  call Hloop_AV_Q(ntryL,G1H16(72),ex3(:),G1H8(54),m3h2x8(:,122),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G1H8(54),44,nMM,G2H8(56),n2h8(182))
  call Hloop_QV_A(ntryL,G1H16(73),ex3(:),G1H8(55),m3h2x8(:,123),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(55),44,0,G2H8(57),n2h8(183))
call HGT_OLR(G1H16(74),1,1,16)
call HGT_invQ_OLR(G1H16(74),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(74),-16,0,G2H16(5),n2h16(83))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(58),m3h2x8(:,124),heltab2x16(:,:,142))
  call Hloop_QV_A(ntryL,G1H16(76),ex3(:),G1H8(56),m3h2x8(:,125),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(56),44,0,G2H8(59),n2h8(184))
  call Hloop_QV_A(ntryL,G1H16(77),ex3(:),G1H8(60),m3h2x8(:,126),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(60),44,0,G2H8(60),n2h8(185))
  call Hloop_QV_A(ntryL,G1H16(78),ex3(:),G1H8(61),m3h2x8(:,127),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(61),44,0,G2H8(61),n2h8(186))
  call Hloop_AV_Q(ntryL,G1H16(79),ex3(:),G1H8(62),m3h2x8(:,128),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H8(62),44,0,G2H8(62),n2h8(187))
call HGT_OLR(G1H16(80),1,1,16)
call HGT_invQ_OLR(G1H16(80),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(80),-16,0,G2H16(6),n2h16(84))
  call Hloop_QV_A(ntryL,G2H16(6),ex5(:),G2H8(63),m3h2x8(:,129),heltab2x16(:,:,147))
  call Hloop_AV_Q(ntryL,G1H16(82),ex3(:),G1H8(4),m3h2x8(:,130),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H8(4),44,0,G2H8(64),n2h8(188))
  call Hloop_AV_Q(ntryL,G1H16(83),ex3(:),G1H8(10),m3h2x8(:,131),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G1H8(10),44,0,G2H8(65),n2h8(189))
  call Hloop_AV_Q(ntryL,G1H16(84),ex3(:),G1H8(21),m3h2x8(:,132),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G1H8(21),44,0,G2H8(66),n2h8(190))
  call Hloop_QV_A(ntryL,G1H8(205),ex4(:),G1H4(12),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(12),43,nMM,G2H4(265),n2h4(275))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(206),-4,nMM,G2H8(67),n2h8(191))
  call Hloop_AV_Q(ntryL,G2H8(67),ex3(:),G2H4(266),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_QV_A(ntryL,G1H8(208),ex4(:),G1H4(13),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(13),43,nMM,G2H4(267),n2h4(276))
  call Hloop_QV_A(ntryL,G1H8(209),ex4(:),G1H4(14),m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(14),43,nMM,G2H4(268),n2h4(277))
  call Hloop_QV_A(ntryL,G1H8(210),ex4(:),G1H4(19),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(19),43,nMM,G2H4(269),n2h4(278))
  call Hloop_AV_Q(ntryL,G1H8(211),ex4(:),G1H4(20),m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(20),43,nMM,G2H4(270),n2h4(279))
call HGT_OLR(G1H8(212),1,1,8)
call HGT_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(212),-4,nMM,G2H8(67),n2h8(192))
  call Hloop_QV_A(ntryL,G2H8(67),ex3(:),G2H4(271),m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_AV_Q(ntryL,G1H8(214),ex4(:),G1H4(24),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(24),43,nMM,G2H4(272),n2h4(280))
  call Hloop_AV_Q(ntryL,G1H8(215),ex4(:),G1H4(25),m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(25),43,nMM,G2H4(273),n2h4(281))
  call Hloop_AV_Q(ntryL,G1H8(216),ex4(:),G1H4(26),m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(26),43,nMM,G2H4(274),n2h4(282))
  call Hloop_QV_A(ntryL,G1H8(217),ex4(:),G1H4(31),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(31),43,0,G2H4(275),n2h4(283))
call HGT_OLR(G1H8(218),1,1,8)
call HGT_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(218),-4,0,G2H8(67),n2h8(193))
  call Hloop_AV_Q(ntryL,G2H8(67),ex3(:),G2H4(276),m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_QV_A(ntryL,G1H8(220),ex4(:),G1H4(32),m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G1H4(32),43,0,G2H4(277),n2h4(284))
  call Hloop_QV_A(ntryL,G1H8(221),ex4(:),G1H4(36),m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(36),43,0,G2H4(278),n2h4(285))
  call Hloop_QV_A(ntryL,G1H8(222),ex4(:),G1H4(37),m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(37),43,0,G2H4(279),n2h4(286))
  call Hloop_AV_Q(ntryL,G1H8(223),ex4(:),G1H4(38),m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G1H4(38),43,0,G2H4(280),n2h4(287))
call HGT_OLR(G1H8(224),1,1,8)
call HGT_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(224),-4,0,G2H8(67),n2h8(194))
  call Hloop_QV_A(ntryL,G2H8(67),ex3(:),G2H4(281),m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_AV_Q(ntryL,G1H8(226),ex4(:),G1H4(43),m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_A_Q(ntryL,G1H4(43),43,0,G2H4(282),n2h4(288))
  call Hloop_AV_Q(ntryL,G1H8(227),ex4(:),G1H4(44),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(44),43,0,G2H4(283),n2h4(289))
  call Hloop_AV_Q(ntryL,G1H8(228),ex4(:),G1H4(48),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(48),43,0,G2H4(284),n2h4(290))
  call Hloop_AV_Q(ntryL,G1H16(85),ex5(:),G1H8(22),m3h2x8(:,133),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(22),52,nME,G2H8(67),n2h8(195))
call HGT_OLR(G1H16(86),1,1,16)
call HGT_invQ_OLR(G1H16(86),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(86),-8,nME,G2H16(13),n2h16(85))
  call Hloop_QV_A(ntryL,G2H16(13),ex4(:),G2H8(68),m3h2x8(:,134),heltab2x16(:,:,152))
  call Hloop_AV_Q(ntryL,G1H16(88),ex5(:),G1H8(27),m3h2x8(:,135),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(27),52,nME,G2H8(69),n2h8(196))
  call Hloop_AV_Q(ntryL,G1H16(89),ex5(:),G1H8(28),m3h2x8(:,136),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H8(28),52,nME,G2H8(70),n2h8(197))
  call Hloop_AV_Q(ntryL,G1H16(90),ex5(:),G1H8(34),m3h2x8(:,137),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G1H8(34),52,nME,G2H8(71),n2h8(198))
  call Hloop_AV_Q(ntryL,G1H16(91),ex5(:),G1H8(45),m3h2x8(:,138),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(45),52,nMM,G2H8(72),n2h8(199))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(92),-8,nMM,G2H16(14),n2h16(86))
  call Hloop_QV_A(ntryL,G2H16(14),ex4(:),G2H8(73),m3h2x8(:,139),heltab2x16(:,:,157))
  call Hloop_AV_Q(ntryL,G1H16(94),ex5(:),G1H8(46),m3h2x8(:,140),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H8(46),52,nMM,G2H8(74),n2h8(200))
  call Hloop_AV_Q(ntryL,G1H16(95),ex5(:),G1H8(51),m3h2x8(:,141),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G1H8(51),52,nMM,G2H8(75),n2h8(201))
  call Hloop_AV_Q(ntryL,G1H16(96),ex5(:),G1H8(52),m3h2x8(:,142),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H8(52),52,nMM,G2H8(76),n2h8(202))
  call Hloop_QV_A(ntryL,G1H16(97),ex5(:),G1H8(58),m3h2x8(:,143),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(58),52,nME,G2H8(77),n2h8(203))
call HGT_OLR(G1H16(98),1,1,16)
call HGT_invQ_OLR(G1H16(98),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(98),-8,nME,G2H16(15),n2h16(87))
  call Hloop_AV_Q(ntryL,G2H16(15),ex4(:),G2H8(78),m3h2x8(:,144),heltab2x16(:,:,162))
  call Hloop_QV_A(ntryL,G1H16(100),ex5(:),G1H8(64),m3h2x8(:,145),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(64),52,nME,G2H8(79),n2h8(204))
  call Hloop_QV_A(ntryL,G1H16(101),ex5(:),G1H8(69),m3h2x8(:,146),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H8(69),52,nME,G2H8(80),n2h8(205))
  call Hloop_QV_A(ntryL,G1H16(102),ex5(:),G1H8(70),m3h2x8(:,147),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H8(70),52,nME,G2H8(81),n2h8(206))
  call Hloop_QV_A(ntryL,G1H16(103),ex5(:),G1H8(75),m3h2x8(:,148),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H8(75),52,nMM,G2H8(82),n2h8(207))
call HGT_OLR(G1H16(104),1,1,16)
call HGT_invQ_OLR(G1H16(104),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(104),-8,nMM,G2H16(16),n2h16(88))
  call Hloop_AV_Q(ntryL,G2H16(16),ex4(:),G2H8(83),m3h2x8(:,149),heltab2x16(:,:,167))
  call Hloop_QV_A(ntryL,G1H16(106),ex5(:),G1H8(76),m3h2x8(:,150),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(76),52,nMM,G2H8(84),n2h8(208))
  call Hloop_QV_A(ntryL,G1H16(107),ex5(:),G1H8(82),m3h2x8(:,151),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(82),52,nMM,G2H8(85),n2h8(209))
  call Hloop_QV_A(ntryL,G1H16(108),ex5(:),G1H8(87),m3h2x8(:,152),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(87),52,nMM,G2H8(86),n2h8(210))
  call Hloop_AV_Q(ntryL,G1H16(109),ex5(:),G1H8(88),m3h2x8(:,153),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H8(88),52,0,G2H8(87),n2h8(211))
call HGT_OLR(G1H16(110),1,1,16)
call HGT_invQ_OLR(G1H16(110),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(110),-8,0,G2H16(17),n2h16(89))
  call Hloop_QV_A(ntryL,G2H16(17),ex4(:),G2H8(88),m3h2x8(:,154),heltab2x16(:,:,172))
  call Hloop_AV_Q(ntryL,G1H16(112),ex5(:),G1H8(93),m3h2x8(:,155),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H8(93),52,0,G2H8(89),n2h8(212))
  call Hloop_AV_Q(ntryL,G1H16(113),ex5(:),G1H8(94),m3h2x8(:,156),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(94),52,0,G2H8(90),n2h8(213))
  call Hloop_AV_Q(ntryL,G1H16(114),ex5(:),G1H8(100),m3h2x8(:,157),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(100),52,0,G2H8(91),n2h8(214))
  call Hloop_QV_A(ntryL,G1H16(115),ex5(:),G1H8(105),m3h2x8(:,158),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(105),52,0,G2H8(92),n2h8(215))
call HGT_OLR(G1H16(116),1,1,16)
call HGT_invQ_OLR(G1H16(116),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(116),-8,0,G2H16(18),n2h16(90))
  call Hloop_AV_Q(ntryL,G2H16(18),ex4(:),G2H8(93),m3h2x8(:,159),heltab2x16(:,:,177))
  call Hloop_QV_A(ntryL,G1H16(118),ex5(:),G1H8(106),m3h2x8(:,160),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H8(106),52,0,G2H8(94),n2h8(216))
  call Hloop_QV_A(ntryL,G1H16(119),ex5(:),G1H8(3),m3h2x8(:,161),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H8(3),52,0,G2H8(95),n2h8(217))
  call Hloop_QV_A(ntryL,G1H16(120),ex5(:),G1H8(72),m3h2x8(:,162),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(72),52,0,G2H8(96),n2h8(218))
  call Hloop_AV_Q(ntryL,G1H8(229),ex3(:),G1H4(49),m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_A_Q(ntryL,G1H4(49),39,nMM,G2H4(285),n2h4(291))
call HGT_OLR(G1H8(230),1,1,8)
call HGT_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(230),-8,nMM,G2H8(97),n2h8(219))
  call Hloop_QV_A(ntryL,G2H8(97),ex4(:),G2H4(286),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_AV_Q(ntryL,G1H8(232),ex3(:),G1H4(50),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_A_Q(ntryL,G1H4(50),39,nMM,G2H4(287),n2h4(292))
  call Hloop_AV_Q(ntryL,G1H8(233),ex3(:),G1H4(55),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_A_Q(ntryL,G1H4(55),39,nMM,G2H4(288),n2h4(293))
  call Hloop_AV_Q(ntryL,G1H8(234),ex3(:),G1H4(56),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(56),39,nMM,G2H4(289),n2h4(294))
  call Hloop_QV_A(ntryL,G1H8(235),ex3(:),G1H4(60),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(60),39,nMM,G2H4(290),n2h4(295))
call HGT_OLR(G1H8(236),1,1,8)
call HGT_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(236),-8,nMM,G2H8(97),n2h8(220))
  call Hloop_AV_Q(ntryL,G2H8(97),ex4(:),G2H4(291),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_QV_A(ntryL,G1H8(238),ex3(:),G1H4(61),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_Q_A(ntryL,G1H4(61),39,nMM,G2H4(292),n2h4(296))
  call Hloop_QV_A(ntryL,G1H8(239),ex3(:),G1H4(62),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(62),39,nMM,G2H4(293),n2h4(297))
  call Hloop_QV_A(ntryL,G1H8(240),ex3(:),G1H4(67),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(67),39,nMM,G2H4(294),n2h4(298))
  call Hloop_AV_Q(ntryL,G1H8(241),ex3(:),G1H4(68),m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(68),39,0,G2H4(295),n2h4(299))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(242),-8,0,G2H8(97),n2h8(221))
  call Hloop_QV_A(ntryL,G2H8(97),ex4(:),G2H4(296),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_AV_Q(ntryL,G1H8(244),ex3(:),G1H4(72),m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_A_Q(ntryL,G1H4(72),39,0,G2H4(297),n2h4(300))
  call Hloop_AV_Q(ntryL,G1H8(245),ex3(:),G1H4(73),m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(73),39,0,G2H4(298),n2h4(301))
  call Hloop_AV_Q(ntryL,G1H8(246),ex3(:),G1H4(74),m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(74),39,0,G2H4(299),n2h4(302))
  call Hloop_QV_A(ntryL,G1H8(247),ex3(:),G1H4(79),m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G1H4(79),39,0,G2H4(300),n2h4(303))
call HGT_OLR(G1H8(248),1,1,8)
call HGT_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(248),-8,0,G2H8(97),n2h8(222))
  call Hloop_AV_Q(ntryL,G2H8(97),ex4(:),G2H4(301),m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_QV_A(ntryL,G1H8(250),ex3(:),G1H4(80),m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G1H4(80),39,0,G2H4(302),n2h4(304))
  call Hloop_QV_A(ntryL,G1H8(251),ex3(:),G1H4(84),m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(84),39,0,G2H4(303),n2h4(305))
  call Hloop_QV_A(ntryL,G1H8(252),ex3(:),G1H4(85),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_Q_A(ntryL,G1H4(85),39,0,G2H4(304),n2h4(306))
  call Hloop_AV_Q(ntryL,G1H16(121),wf4(:,49),G1H4(86),m3h4x4(:,19),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(86),43,nME,G2H4(305),n2h4(307))
call HGT_OLR(G1H16(122),1,1,16)
call HGT_invQ_OLR(G1H16(122),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(122),-16,nME,G2H16(19),n2h16(91))
  call Hloop_QV_A(ntryL,G2H16(19),ex5(:),G2H8(97),m3h2x8(:,163),heltab2x16(:,:,182))
  call Hloop_AV_Q(ntryL,G1H16(124),wf4(:,49),G1H4(91),m3h4x4(:,20),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(91),43,nME,G2H4(306),n2h4(308))
  call Hloop_AV_Q(ntryL,G1H16(125),wf4(:,49),G1H4(92),m3h4x4(:,21),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(92),43,nME,G2H4(307),n2h4(309))
  call Hloop_AV_Q(ntryL,G1H16(126),wf4(:,49),G1H4(96),m3h4x4(:,22),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(96),43,nME,G2H4(308),n2h4(310))
  call Hloop_AV_Q(ntryL,G1H16(127),wf4(:,49),G1H4(97),m3h4x4(:,23),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(97),43,nMM,G2H4(309),n2h4(311))
call HGT_OLR(G1H16(128),1,1,16)
call HGT_invQ_OLR(G1H16(128),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(128),-16,nMM,G2H16(20),n2h16(92))
  call Hloop_QV_A(ntryL,G2H16(20),ex5(:),G2H8(98),m3h2x8(:,164),heltab2x16(:,:,187))
  call Hloop_AV_Q(ntryL,G1H16(130),wf4(:,49),G1H4(98),m3h4x4(:,24),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(98),43,nMM,G2H4(310),n2h4(312))
  call Hloop_AV_Q(ntryL,G1H16(131),wf4(:,49),G1H4(103),m3h4x4(:,25),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(103),43,nMM,G2H4(311),n2h4(313))
  call Hloop_AV_Q(ntryL,G1H16(132),wf4(:,49),G1H4(104),m3h4x4(:,26),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(104),43,nMM,G2H4(312),n2h4(314))
  call Hloop_QV_A(ntryL,G1H16(133),wf4(:,49),G1H4(108),m3h4x4(:,27),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(108),43,nME,G2H4(313),n2h4(315))
call HGT_OLR(G1H16(134),1,1,16)
call HGT_invQ_OLR(G1H16(134),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(134),-16,nME,G2H16(21),n2h16(93))
  call Hloop_AV_Q(ntryL,G2H16(21),ex5(:),G2H8(99),m3h2x8(:,165),heltab2x16(:,:,192))
  call Hloop_QV_A(ntryL,G1H16(136),wf4(:,49),G1H4(109),m3h4x4(:,28),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(109),43,nME,G2H4(314),n2h4(316))
  call Hloop_QV_A(ntryL,G1H16(137),wf4(:,49),G1H4(110),m3h4x4(:,29),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(110),43,nME,G2H4(315),n2h4(317))
  call Hloop_QV_A(ntryL,G1H16(138),wf4(:,49),G1H4(115),m3h4x4(:,30),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(115),43,nME,G2H4(316),n2h4(318))
  call Hloop_QV_A(ntryL,G1H16(139),wf4(:,49),G1H4(116),m3h4x4(:,31),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(116),43,nMM,G2H4(317),n2h4(319))
call HGT_OLR(G1H16(140),1,1,16)
call HGT_invQ_OLR(G1H16(140),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(140),-16,nMM,G2H16(22),n2h16(94))
  call Hloop_AV_Q(ntryL,G2H16(22),ex5(:),G2H8(100),m3h2x8(:,166),heltab2x16(:,:,197))
  call Hloop_QV_A(ntryL,G1H16(142),wf4(:,49),G1H4(120),m3h4x4(:,32),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(120),43,nMM,G2H4(318),n2h4(320))
  call Hloop_QV_A(ntryL,G1H16(143),wf4(:,49),G1H4(121),m3h4x4(:,33),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(121),43,nMM,G2H4(319),n2h4(321))
  call Hloop_QV_A(ntryL,G1H16(144),wf4(:,49),G1H4(122),m3h4x4(:,34),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(122),43,nMM,G2H4(320),n2h4(322))
  call Hloop_AV_Q(ntryL,G1H16(145),wf4(:,49),G1H4(127),m3h4x4(:,35),heltab2x16(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(127),43,0,G2H4(321),n2h4(323))
call HGT_OLR(G1H16(146),1,1,16)
call HGT_invQ_OLR(G1H16(146),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(146),-16,0,G2H16(23),n2h16(95))
  call Hloop_QV_A(ntryL,G2H16(23),ex5(:),G2H8(101),m3h2x8(:,167),heltab2x16(:,:,202))
  call Hloop_AV_Q(ntryL,G1H16(148),wf4(:,49),G1H4(128),m3h4x4(:,36),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(128),43,0,G2H4(322),n2h4(324))
  call Hloop_AV_Q(ntryL,G1H16(149),wf4(:,49),G1H4(132),m3h4x4(:,37),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(132),43,0,G2H4(323),n2h4(325))
  call Hloop_AV_Q(ntryL,G1H16(150),wf4(:,49),G1H4(133),m3h4x4(:,38),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(133),43,0,G2H4(324),n2h4(326))
  call Hloop_QV_A(ntryL,G1H16(151),wf4(:,49),G1H4(134),m3h4x4(:,39),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(134),43,0,G2H4(325),n2h4(327))
call HGT_OLR(G1H16(152),1,1,16)
call HGT_invQ_OLR(G1H16(152),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(152),-16,0,G2H16(24),n2h16(96))
  call Hloop_AV_Q(ntryL,G2H16(24),ex5(:),G2H8(102),m3h2x8(:,168),heltab2x16(:,:,207))
  call Hloop_QV_A(ntryL,G1H16(154),wf4(:,49),G1H4(139),m3h4x4(:,40),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(139),43,0,G2H4(326),n2h4(328))
  call Hloop_QV_A(ntryL,G1H16(155),wf4(:,49),G1H4(140),m3h4x4(:,41),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(140),43,0,G2H4(327),n2h4(329))
  call Hloop_QV_A(ntryL,G1H16(156),wf4(:,49),G1H4(144),m3h4x4(:,42),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(144),43,0,G2H4(328),n2h4(330))
  call Hloop_QV_A(ntryL,G1H16(157),wf4(:,49),G1H4(145),m3h4x4(:,43),heltab2x16(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(145),39,nME,G2H4(329),n2h4(331))
call HGT_OLR(G1H16(158),1,1,16)
call HGT_invQ_OLR(G1H16(158),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(158),-8,nME,G2H16(25),n2h16(97))
  call Hloop_AV_Q(ntryL,G2H16(25),ex4(:),G2H8(103),m3h2x8(:,169),heltab2x16(:,:,212))
  call Hloop_QV_A(ntryL,G1H16(160),wf4(:,49),G1H4(146),m3h4x4(:,44),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(146),39,nME,G2H4(330),n2h4(332))
  call Hloop_QV_A(ntryL,G1H16(161),wf4(:,49),G1H4(151),m3h4x4(:,45),heltab2x16(:,:,214))
  call Hloop_Q_A(ntryL,G1H4(151),39,nME,G2H4(331),n2h4(333))
  call Hloop_QV_A(ntryL,G1H16(162),wf4(:,49),G1H4(152),m3h4x4(:,46),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(152),39,nME,G2H4(332),n2h4(334))
  call Hloop_QV_A(ntryL,G1H16(163),wf4(:,49),G1H4(156),m3h4x4(:,47),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(156),39,nMM,G2H4(333),n2h4(335))
call HGT_OLR(G1H16(164),1,1,16)
call HGT_invQ_OLR(G1H16(164),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(164),-8,nMM,G2H16(26),n2h16(98))
  call Hloop_AV_Q(ntryL,G2H16(26),ex4(:),G2H8(104),m3h2x8(:,170),heltab2x16(:,:,217))
  call Hloop_QV_A(ntryL,G1H16(166),wf4(:,49),G1H4(157),m3h4x4(:,48),heltab2x16(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(157),39,nMM,G2H4(334),n2h4(336))
  call Hloop_QV_A(ntryL,G1H16(167),wf4(:,49),G1H4(158),m3h4x4(:,49),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(158),39,nMM,G2H4(335),n2h4(337))
  call Hloop_QV_A(ntryL,G1H16(168),wf4(:,49),G1H4(163),m3h4x4(:,50),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(163),39,nMM,G2H4(336),n2h4(338))
  call Hloop_AV_Q(ntryL,G1H16(169),wf4(:,49),G1H4(164),m3h4x4(:,51),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(164),39,nME,G2H4(337),n2h4(339))
call HGT_OLR(G1H16(170),1,1,16)
call HGT_invQ_OLR(G1H16(170),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(170),-8,nME,G2H16(27),n2h16(99))
  call Hloop_QV_A(ntryL,G2H16(27),ex4(:),G2H8(105),m3h2x8(:,171),heltab2x16(:,:,222))
  call Hloop_AV_Q(ntryL,G1H16(172),wf4(:,49),G1H4(168),m3h4x4(:,52),heltab2x16(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(168),39,nME,G2H4(338),n2h4(340))
  call Hloop_AV_Q(ntryL,G1H16(173),wf4(:,49),G1H4(169),m3h4x4(:,53),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(169),39,nME,G2H4(339),n2h4(341))
  call Hloop_AV_Q(ntryL,G1H16(174),wf4(:,49),G1H4(170),m3h4x4(:,54),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(170),39,nME,G2H4(340),n2h4(342))
  call Hloop_AV_Q(ntryL,G1H16(175),wf4(:,49),G1H4(175),m3h4x4(:,55),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(175),39,nMM,G2H4(341),n2h4(343))
call HGT_OLR(G1H16(176),1,1,16)
call HGT_invQ_OLR(G1H16(176),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(176),-8,nMM,G2H16(28),n2h16(100))
  call Hloop_QV_A(ntryL,G2H16(28),ex4(:),G2H8(106),m3h2x8(:,172),heltab2x16(:,:,227))
  call Hloop_AV_Q(ntryL,G1H16(178),wf4(:,49),G1H4(176),m3h4x4(:,56),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(176),39,nMM,G2H4(342),n2h4(344))
  call Hloop_AV_Q(ntryL,G1H16(179),wf4(:,49),G1H4(180),m3h4x4(:,57),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(180),39,nMM,G2H4(343),n2h4(345))
  call Hloop_AV_Q(ntryL,G1H16(180),wf4(:,49),G1H4(181),m3h4x4(:,58),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(181),39,nMM,G2H4(344),n2h4(346))
  call Hloop_QV_A(ntryL,G1H16(181),wf4(:,49),G1H4(182),m3h4x4(:,59),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(182),39,0,G2H4(345),n2h4(347))
call HGT_OLR(G1H16(182),1,1,16)
call HGT_invQ_OLR(G1H16(182),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(182),-8,0,G2H16(29),n2h16(101))
  call Hloop_AV_Q(ntryL,G2H16(29),ex4(:),G2H8(107),m3h2x8(:,173),heltab2x16(:,:,232))
  call Hloop_QV_A(ntryL,G1H16(184),wf4(:,49),G1H4(187),m3h4x4(:,60),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(187),39,0,G2H4(346),n2h4(348))
  call Hloop_QV_A(ntryL,G1H16(185),wf4(:,49),G1H4(188),m3h4x4(:,61),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H4(188),39,0,G2H4(347),n2h4(349))
  call Hloop_QV_A(ntryL,G1H16(186),wf4(:,49),G1H4(192),m3h4x4(:,62),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(192),39,0,G2H4(348),n2h4(350))
  call Hloop_AV_Q(ntryL,G1H16(187),wf4(:,49),G1H4(193),m3h4x4(:,63),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(193),39,0,G2H4(349),n2h4(351))
call HGT_OLR(G1H16(188),1,1,16)
call HGT_invQ_OLR(G1H16(188),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(188),-8,0,G2H16(30),n2h16(102))
  call Hloop_QV_A(ntryL,G2H16(30),ex4(:),G2H8(108),m3h2x8(:,174),heltab2x16(:,:,237))
  call Hloop_AV_Q(ntryL,G1H16(190),wf4(:,49),G1H4(194),m3h4x4(:,64),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(194),39,0,G2H4(350),n2h4(352))
  call Hloop_AV_Q(ntryL,G1H16(191),wf4(:,49),G1H4(199),m3h4x4(:,65),heltab2x16(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(199),39,0,G2H4(351),n2h4(353))
  call Hloop_AV_Q(ntryL,G1H16(192),wf4(:,49),G1H4(200),m3h4x4(:,66),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(200),39,0,G2H4(352),n2h4(354))
  call Hloop_QV_A(ntryL,G1H16(193),wf4(:,49),G1H4(204),m3h4x4(:,67),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(204),39,nME,G2H4(353),n2h4(355))
call HGT_OLR(G1H16(194),1,1,16)
call HGT_invQ_OLR(G1H16(194),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(194),-16,nME,G2H16(31),n2h16(103))
  call Hloop_AV_Q(ntryL,G2H16(31),ex5(:),G2H8(109),m3h2x8(:,175),heltab2x16(:,:,242))
  call Hloop_QV_A(ntryL,G1H16(196),wf4(:,49),G1H4(205),m3h4x4(:,68),heltab2x16(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(205),39,nME,G2H4(354),n2h4(356))
  call Hloop_QV_A(ntryL,G1H16(197),wf4(:,49),G1H4(206),m3h4x4(:,69),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(206),39,nME,G2H4(355),n2h4(357))
  call Hloop_QV_A(ntryL,G1H16(198),wf4(:,49),G1H4(211),m3h4x4(:,70),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(211),39,nME,G2H4(356),n2h4(358))
  call Hloop_QV_A(ntryL,G1H16(199),wf4(:,49),G1H4(212),m3h4x4(:,71),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(212),39,nMM,G2H4(357),n2h4(359))
call HGT_OLR(G1H16(200),1,1,16)
call HGT_invQ_OLR(G1H16(200),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(200),-16,nMM,G2H16(32),n2h16(104))
  call Hloop_AV_Q(ntryL,G2H16(32),ex5(:),G2H8(110),m3h2x8(:,176),heltab2x16(:,:,247))
  call Hloop_QV_A(ntryL,G1H16(202),wf4(:,49),G1H4(216),m3h4x4(:,72),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(216),39,nMM,G2H4(358),n2h4(360))
  call Hloop_QV_A(ntryL,G1H16(203),wf4(:,49),G1H4(217),m3h4x4(:,73),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(217),39,nMM,G2H4(359),n2h4(361))
  call Hloop_QV_A(ntryL,G1H16(204),wf4(:,49),G1H4(218),m3h4x4(:,74),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(218),39,nMM,G2H4(360),n2h4(362))
  call Hloop_AV_Q(ntryL,G1H16(205),wf4(:,49),G1H4(223),m3h4x4(:,75),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(223),39,nME,G2H4(361),n2h4(363))
call HGT_OLR(G1H16(206),1,1,16)
call HGT_invQ_OLR(G1H16(206),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(206),-16,nME,G2H16(33),n2h16(105))
  call Hloop_QV_A(ntryL,G2H16(33),ex5(:),G2H8(111),m3h2x8(:,177),heltab2x16(:,:,252))
  call Hloop_AV_Q(ntryL,G1H16(208),wf4(:,49),G1H4(224),m3h4x4(:,76),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(224),39,nME,G2H4(362),n2h4(364))
  call Hloop_AV_Q(ntryL,G1H16(209),wf4(:,49),G1H4(228),m3h4x4(:,77),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(228),39,nME,G2H4(363),n2h4(365))
  call Hloop_AV_Q(ntryL,G1H16(210),wf4(:,49),G1H4(229),m3h4x4(:,78),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(229),39,nME,G2H4(364),n2h4(366))
  call Hloop_AV_Q(ntryL,G1H16(211),wf4(:,49),G1H4(230),m3h4x4(:,79),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(230),39,nMM,G2H4(365),n2h4(367))
call HGT_OLR(G1H16(212),1,1,16)
call HGT_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(212),-16,nMM,G2H16(34),n2h16(106))
  call Hloop_QV_A(ntryL,G2H16(34),ex5(:),G2H8(112),m3h2x8(:,178),heltab2x16(:,:,257))
  call Hloop_AV_Q(ntryL,G1H16(214),wf4(:,49),G1H4(235),m3h4x4(:,80),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(235),39,nMM,G2H4(366),n2h4(368))
  call Hloop_AV_Q(ntryL,G1H16(215),wf4(:,49),G1H4(236),m3h4x4(:,81),heltab2x16(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(236),39,nMM,G2H4(367),n2h4(369))
  call Hloop_AV_Q(ntryL,G1H16(216),wf4(:,49),G1H4(240),m3h4x4(:,82),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(240),39,nMM,G2H4(368),n2h4(370))
  call Hloop_QV_A(ntryL,G1H16(217),wf4(:,49),G1H4(241),m3h4x4(:,83),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(241),39,0,G2H4(369),n2h4(371))
call HGT_OLR(G1H16(218),1,1,16)
call HGT_invQ_OLR(G1H16(218),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(218),-16,0,G2H16(35),n2h16(107))
  call Hloop_AV_Q(ntryL,G2H16(35),ex5(:),G2H8(113),m3h2x8(:,179),heltab2x16(:,:,262))
  call Hloop_QV_A(ntryL,G1H16(220),wf4(:,49),G1H4(242),m3h4x4(:,84),heltab2x16(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(242),39,0,G2H4(370),n2h4(372))
  call Hloop_QV_A(ntryL,G1H16(221),wf4(:,49),G1H4(247),m3h4x4(:,85),heltab2x16(:,:,264))
  call Hloop_Q_A(ntryL,G1H4(247),39,0,G2H4(371),n2h4(373))
  call Hloop_QV_A(ntryL,G1H16(222),wf4(:,49),G1H4(248),m3h4x4(:,86),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(248),39,0,G2H4(372),n2h4(374))
  call Hloop_AV_Q(ntryL,G1H16(223),wf4(:,49),G1H4(252),m3h4x4(:,87),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G1H4(252),39,0,G2H4(373),n2h4(375))
call HGT_OLR(G1H16(224),1,1,16)
call HGT_invQ_OLR(G1H16(224),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(224),-16,0,G2H16(36),n2h16(108))
  call Hloop_QV_A(ntryL,G2H16(36),ex5(:),G2H8(114),m3h2x8(:,180),heltab2x16(:,:,267))
  call Hloop_AV_Q(ntryL,G1H16(226),wf4(:,49),G1H4(253),m3h4x4(:,88),heltab2x16(:,:,268))
  call Hloop_A_Q(ntryL,G1H4(253),39,0,G2H4(374),n2h4(376))
  call Hloop_AV_Q(ntryL,G1H16(227),wf4(:,49),G1H4(254),m3h4x4(:,89),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G1H4(254),39,0,G2H4(375),n2h4(377))
  call Hloop_AV_Q(ntryL,G1H16(228),wf4(:,49),G1H4(259),m3h4x4(:,90),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G1H4(259),39,0,G2H4(376),n2h4(378))
  call Hloop_QV_A(ntryL,G1H16(15),ex5(:),G1H8(65),m3h2x8(:,181),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H8(65),52,nME,G2H8(115),n2h8(223))
call HGT_OLR(G1H16(19),1,1,16)
call HGT_invQ_OLR(G1H16(19),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(19),-9,nME,G2H16(37),n2h16(109))
  call Hloop_AQ_V(ntryL,G2H16(37),wf4(:,11),G2H4(377),m3h4x4(:,91),heltab2x16(:,:,272))
  call Hloop_QV_A(ntryL,G1H16(41),ex5(:),G1H8(15),m3h2x8(:,182),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G1H8(15),52,nME,G2H8(116),n2h8(224))
  call Hloop_QV_A(ntryL,G1H16(229),ex5(:),G1H8(66),m3h2x8(:,183),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G1H8(66),52,nME,G2H8(117),n2h8(225))
  call Hloop_QV_A(ntryL,G1H16(230),ex5(:),G1H8(83),m3h2x8(:,184),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G1H8(83),52,nME,G2H8(118),n2h8(226))
  call Hloop_AV_Q(ntryL,G1H16(8),ex5(:),G1H8(84),m3h2x8(:,185),heltab2x16(:,:,276))
  call Hloop_A_Q(ntryL,G1H8(84),52,nME,G2H8(119),n2h8(227))
call HGT_OLR(G1H16(9),1,1,16)
call HGT_invQ_OLR(G1H16(9),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(9),-10,nME,G2H16(38),n2h16(110))
  call Hloop_QA_V(ntryL,G2H16(38),wf4(:,4),G2H4(378),m3h4x4(:,92),heltab2x16(:,:,277))
  call Hloop_AV_Q(ntryL,G1H16(232),ex5(:),G1H8(71),m3h2x8(:,186),heltab2x16(:,:,278))
  call Hloop_A_Q(ntryL,G1H8(71),52,nME,G2H8(120),n2h8(228))
  call Hloop_AV_Q(ntryL,G1H16(233),ex5(:),G1H8(39),m3h2x8(:,187),heltab2x16(:,:,279))
  call Hloop_A_Q(ntryL,G1H8(39),52,nME,G2H8(121),n2h8(229))
  call Hloop_AV_Q(ntryL,G1H16(234),ex5(:),G1H8(67),m3h2x8(:,188),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H8(67),52,nME,G2H8(122),n2h8(230))
  call Hloop_QV_A(ntryL,G1H16(13),ex3(:),G1H8(85),m3h2x8(:,189),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(85),44,nME,G2H8(123),n2h8(231))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-17,nME,G2H16(39),n2h16(111))
  call Hloop_AQ_V(ntryL,G2H16(39),wf4(:,14),G2H4(379),m3h4x4(:,93),heltab2x16(:,:,282))
  call Hloop_QV_A(ntryL,G1H16(236),ex3(:),G1H8(86),m3h2x8(:,190),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H8(86),44,nME,G2H8(124),n2h8(232))
  call Hloop_QV_A(ntryL,G1H16(237),ex3(:),G1H8(68),m3h2x8(:,191),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G1H8(68),44,nME,G2H8(125),n2h8(233))
  call Hloop_QV_A(ntryL,G1H16(238),ex3(:),G1H8(89),m3h2x8(:,192),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H8(89),44,nME,G2H8(126),n2h8(234))
  call Hloop_QV_A(ntryL,G1H16(239),ex4(:),G1H8(90),m3h2x8(:,193),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H8(90),44,nME,G2H8(127),n2h8(235))
call HGT_OLR(G1H16(240),1,1,16)
call HGT_invQ_OLR(G1H16(240),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(240),-17,nME,G2H16(40),n2h16(112))
  call Hloop_AQ_V(ntryL,G2H16(40),wf4(:,14),G2H4(380),m3h4x4(:,94),heltab2x16(:,:,287))
  call Hloop_QV_A(ntryL,G1H16(242),ex4(:),G1H8(73),m3h2x8(:,194),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H8(73),44,nME,G2H8(128),n2h8(236))
  call Hloop_QV_A(ntryL,G1H16(243),ex4(:),G1H8(74),m3h2x8(:,195),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H8(74),44,nME,G2H8(129),n2h8(237))
  call Hloop_QV_A(ntryL,G1H16(244),ex4(:),G1H8(78),m3h2x8(:,196),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H8(78),44,nME,G2H8(130),n2h8(238))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(79),m3h2x8(:,197),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H8(79),44,nME,G2H8(131),n2h8(239))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-18,nME,G2H16(41),n2h16(113))
  call Hloop_QA_V(ntryL,G2H16(41),wf4(:,6),G2H4(381),m3h4x4(:,95),heltab2x16(:,:,292))
  call Hloop_AV_Q(ntryL,G1H16(246),ex3(:),G1H8(80),m3h2x8(:,198),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H8(80),44,nME,G2H8(132),n2h8(240))
  call Hloop_AV_Q(ntryL,G1H16(247),ex3(:),G1H8(109),m3h2x8(:,199),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G1H8(109),44,nME,G2H8(133),n2h8(241))
  call Hloop_AV_Q(ntryL,G1H16(248),ex3(:),G1H8(110),m3h2x8(:,200),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H8(110),44,nME,G2H8(134),n2h8(242))
  call Hloop_AV_Q(ntryL,G1H16(249),ex4(:),G1H8(112),m3h2x8(:,201),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H8(112),44,nME,G2H8(135),n2h8(243))
call HGT_OLR(G1H16(250),1,1,16)
call HGT_invQ_OLR(G1H16(250),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(250),-18,nME,G2H16(42),n2h16(114))
  call Hloop_QA_V(ntryL,G2H16(42),wf4(:,6),G2H4(382),m3h4x4(:,96),heltab2x16(:,:,297))
  call Hloop_AV_Q(ntryL,G1H16(252),ex4(:),G1H8(113),m3h2x8(:,202),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H8(113),44,nME,G2H8(136),n2h8(244))
  call Hloop_AV_Q(ntryL,G1H16(253),ex4(:),G1H8(114),m3h2x8(:,203),heltab2x16(:,:,299))
  call Hloop_A_Q(ntryL,G1H8(114),44,nME,G2H8(137),n2h8(245))
  call Hloop_AV_Q(ntryL,G1H16(254),ex4(:),G1H8(115),m3h2x8(:,204),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H8(115),44,nME,G2H8(138),n2h8(246))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(8),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(11),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(14),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(17),G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(313),[G2H4(21),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(361),[G2H4(25),G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(3)])
call HGT_OLR(G2H4(28),1,1,4)
call HGT_invQ_OLR(G2H4(28),2,5,4)
call HGT_OLR(G2H4(28),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(337),[G2H4(29),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(33),G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(75)])
call HGT_OLR(G2H4(36),1,1,4)
call HGT_invQ_OLR(G2H4(36),2,5,4)
call HGT_OLR(G2H4(36),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(37),G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(305),[G2H4(41),G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(353),[G2H4(45),G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G2H4(49),G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(147)])
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(53),G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G1H4(39)])
call HGT_OLR(G2H4(56),1,1,4)
call HGT_invQ_OLR(G2H4(56),2,5,4)
call HGT_OLR(G2H4(56),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(329),[G2H4(57),G1H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(61),G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(183)])
call HGT_OLR(G2H4(64),1,1,4)
call HGT_invQ_OLR(G2H4(64),2,5,4)
call HGT_OLR(G2H4(64),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(65),G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(69),G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(135)])
call HGT_OLR(G2H4(72),1,1,4)
call HGT_invQ_OLR(G2H4(72),2,5,4)
call HGT_OLR(G2H4(72),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(73),G1H4(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G2H4(77),G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(87)])
call HGT_OLR(G2H4(80),1,1,4)
call HGT_invQ_OLR(G2H4(80),2,5,4)
call HGT_OLR(G2H4(80),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(81),G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(85),G1H4(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(99)])
call HGT_OLR(G2H4(88),1,1,4)
call HGT_invQ_OLR(G2H4(88),2,5,4)
call HGT_OLR(G2H4(88),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(89),G1H4(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(16),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(52),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(315),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(363),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(339),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(125),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(128),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(307),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(355),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(331),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(153),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(158),[G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(160),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(163),[G1H4(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(165),[G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(168),[G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(170),[G1H4(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(173),[G1H4(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(175),[G1H4(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(178),[G1H4(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(180),[G1H4(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(183),[G1H4(286)])
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(47),mass5set(:,2),  & 
G1H4(260),G1H4(264),G1H4(265),G1H4(266),G1H4(271),G1H4(272),4)
  call HG1shiftOLR(G1H4(264),16,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(48),mass5set(:,2),  & 
G1H4(276),G1H4(277),G1H4(278),G1H4(283),G1H4(284),G1H4(288),4)
  call HG1shiftOLR(G1H4(277),16,4)
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(49),mass5set(:,2),  & 
G1H4(6),G1H4(18),G1H4(30),G1H4(42),G1H4(54),G1H4(66),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(50),mass5set(:,2),  & 
G1H4(78),G1H4(90),G1H4(102),G1H4(114),G1H4(126),G1H4(138),4)
  call HG1shiftOLR(G1H4(90),16,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(51),mass5set(:,2),  & 
G1H4(150),G1H4(162),G1H4(174),G1H4(186),G1H4(198),G1H4(210),4)
  call HG1shiftOLR(G1H4(162),16,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(52),mass5set(:,2),  & 
G1H4(222),G1H4(234),G1H4(246),G1H4(258),G1H4(270),G1H4(282),4)
  call HG1shiftOLR(G1H4(234),8,4)
call HGT_OLR(G2H4(20),1,1,4)
call HGT_invQ_OLR(G2H4(20),2,5,4)
call HGT_OLR(G2H4(20),6,15,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(53),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(7),G1H4(8),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(313),RedSet_5(44),mass5set(:,4),  & 
G1H4(14),G1H4(19),G1H4(20),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(19),16,4)
call HGT_OLR(G2H4(24),1,1,4)
call HGT_invQ_OLR(G2H4(24),2,5,4)
call HGT_OLR(G2H4(24),6,15,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(54),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(36),G1H4(37),G1H4(38),G1H4(43),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(361),RedSet_5(46),mass5set(:,4),  & 
G1H4(44),G1H4(48),G1H4(49),G1H4(50),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(48),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(55),mass5set(:,2),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(67),G1H4(68),G1H4(72),4)
  call HG1shiftOLR(G1H4(61),16,4)
  call Hotf_5pt_reduction(G2H4(337),RedSet_5(45),mass5set(:,4),  & 
G1H4(73),G1H4(74),G1H4(79),G1H4(80),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(74),8,4)
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(56),mass5set(:,3),  & 
G1H4(86),G1H4(91),G1H4(92),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(91),8,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(57),mass5set(:,3),  & 
G1H4(103),G1H4(104),G1H4(108),G1H4(109),G1H4(110),G1H4(115),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(58),mass5set(:,3),  & 
G1H4(116),G1H4(120),G1H4(121),G1H4(122),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(120),16,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(59),mass5set(:,3),  & 
G1H4(132),G1H4(133),G1H4(134),G1H4(139),G1H4(140),G1H4(144),4)
  call HG1shiftOLR(G1H4(133),8,4)
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(60),mass5set(:,2),  & 
G1H4(145),G1H4(146),G1H4(151),G1H4(152),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hotf_5pt_reduction(G2H4(305),RedSet_5(44),mass5set(:,4),  & 
G1H4(158),G1H4(163),G1H4(164),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(163),16,4)
call HGT_OLR(G2H4(44),1,1,4)
call HGT_invQ_OLR(G2H4(44),2,5,4)
call HGT_OLR(G2H4(44),6,15,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(61),mass5set(:,2),  & 
G1H4(175),G1H4(176),G1H4(180),G1H4(181),G1H4(182),G1H4(187),4)
  call HG1shiftOLR(G1H4(176),8,4)
  call Hotf_5pt_reduction(G2H4(353),RedSet_5(46),mass5set(:,4),  & 
G1H4(188),G1H4(192),G1H4(193),G1H4(194),G1H4(199),G1H4(200),4)
  call HG1shiftOLR(G1H4(192),16,4)
call HGT_OLR(G2H4(48),1,1,4)
call HGT_invQ_OLR(G2H4(48),2,5,4)
call HGT_OLR(G2H4(48),6,15,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(62),mass5set(:,3),  & 
G1H4(204),G1H4(205),G1H4(206),G1H4(211),G1H4(212),G1H4(216),4)
  call HG1shiftOLR(G1H4(205),4,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(63),mass5set(:,3),  & 
G1H4(217),G1H4(218),G1H4(223),G1H4(224),G1H4(228),G1H4(229),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(64),mass5set(:,3),  & 
G1H4(230),G1H4(235),G1H4(236),G1H4(240),G1H4(241),G1H4(242),4)
  call HG1shiftOLR(G1H4(235),16,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(65),mass5set(:,3),  & 
G1H4(247),G1H4(248),G1H4(252),G1H4(253),G1H4(254),G1H4(259),4)
  call HG1shiftOLR(G1H4(248),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(66),mass5set(:,2),  & 
G1H4(5),G1H4(17),G1H4(29),G1H4(41),G1H4(53),G1H4(65),4)
  call HG1shiftOLR(G1H4(17),16,4)
  call Hotf_5pt_reduction(G2H4(329),RedSet_5(45),mass5set(:,4),  & 
G1H4(77),G1H4(89),G1H4(3),G1H4(101),G1H4(113),G1H4(75),4)
  call HG1shiftOLR(G1H4(89),8,4)
call HGT_OLR(G2H4(60),1,1,4)
call HGT_invQ_OLR(G2H4(60),2,5,4)
call HGT_OLR(G2H4(60),6,15,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(67),mass5set(:,3),  & 
G1H4(125),G1H4(137),G1H4(149),G1H4(161),G1H4(147),G1H4(173),4)
  call HG1shiftOLR(G1H4(137),4,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(68),mass5set(:,3),  & 
G1H4(39),G1H4(185),G1H4(197),G1H4(183),G1H4(209),G1H4(221),4)
  call HG1shiftOLR(G1H4(185),8,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(69),mass5set(:,3),  & 
G1H4(135),G1H4(233),G1H4(245),G1H4(87),G1H4(257),G1H4(269),4)
  call HG1shiftOLR(G1H4(233),8,4)
  call Hotf_5pt_reduction(G2H4(90),RedSet_5(70),mass5set(:,3),  & 
G1H4(99),G1H4(281),G1H4(16),G1H4(4),G1H4(10),G1H4(15),4)
  call HG1shiftOLR(G1H4(281),4,4)
call HGT_OLR(G2H4(68),1,1,4)
call HGT_invQ_OLR(G2H4(68),2,5,4)
call HGT_OLR(G2H4(68),6,15,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(71),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(52),G1H4(40),G1H4(46),G1H4(51),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(72),mass5set(:,3),  & 
G1H4(63),G1H4(64),G1H4(76),G1H4(83),G1H4(88),G1H4(95),4)
  call HG1shiftOLR(G1H4(64),16,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(73),mass5set(:,3),  & 
G1H4(100),G1H4(107),G1H4(111),G1H4(112),G1H4(118),G1H4(123),4)
  call HG1shiftOLR(G1H4(107),16,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(74),mass5set(:,3),  & 
G1H4(124),G1H4(130),G1H4(136),G1H4(143),G1H4(148),G1H4(155),4)
  call HG1shiftOLR(G1H4(130),8,4)
call HGT_OLR(G2H4(76),1,1,4)
call HGT_invQ_OLR(G2H4(76),2,5,4)
call HGT_OLR(G2H4(76),6,15,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(75),mass5set(:,3),  & 
G1H4(159),G1H4(160),G1H4(166),G1H4(171),G1H4(172),G1H4(178),4)
  call HG1shiftOLR(G1H4(160),4,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(76),mass5set(:,3),  & 
G1H4(184),G1H4(191),G1H4(195),G1H4(196),G1H4(202),G1H4(207),4)
  call HG1shiftOLR(G1H4(191),16,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(77),mass5set(:,3),  & 
G1H4(208),G1H4(214),G1H4(219),G1H4(220),G1H4(226),G1H4(231),4)
  call HG1shiftOLR(G1H4(214),16,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(78),mass5set(:,3),  & 
G1H4(232),G1H4(238),G1H4(243),G1H4(244),G1H4(250),G1H4(255),4)
  call HG1shiftOLR(G1H4(238),4,4)
call HGT_OLR(G2H4(84),1,1,4)
call HGT_invQ_OLR(G2H4(84),2,5,4)
call HGT_OLR(G2H4(84),6,15,4)
  call Hotf_5pt_reduction(G2H4(84),RedSet_5(79),mass5set(:,3),  & 
G1H4(256),G1H4(262),G1H4(267),G1H4(268),G1H4(274),G1H4(279),4)
  call HG1shiftOLR(G1H4(262),4,4)
  call Hotf_5pt_reduction(G2H4(94),RedSet_5(80),mass5set(:,3),  & 
G1H4(280),G1H4(286),G1H4(289),G1H4(290),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(286),8,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(81),mass5set(:,3),  & 
G1H4(293),G1H4(294),G1H4(295),G1H4(296),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(294),8,4)
  call Hotf_5pt_reduction(G2H4(93),RedSet_5(82),mass5set(:,3),  & 
G1H4(299),G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(300),4,4)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(83),mass5set(:,2),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),16,4)
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(1),n2h2(73))
  call Hloop_VA_Q(ntryL,G1H4(22),ex2(:),G1H2(2),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(6),n2h2(74))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(7),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(11),n2h2(75))
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(84),mass5set(:,2),  & 
G1H4(9),G1H4(22),G1H4(11),G1H4(311),G1H4(312),G1H4(313),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(8),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(16),n2h2(76))
  call Hloop_VA_Q(ntryL,G1H4(23),ex2(:),G1H2(13),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(21),n2h2(77))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(85),mass5set(:,2),  & 
G1H4(21),G1H4(23),G1H4(314),G1H4(315),G1H4(316),G1H4(317),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(86),mass5set(:,2),  & 
G1H4(318),G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),4)
  call HG1shiftOLR(G1H4(319),8,4)
  call Hloop_VQ_A(ntryL,G1H4(33),ex1(:),G1H2(14),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(14),55,nME,G2H2(26),n2h2(78))
  call Hloop_VQ_A(ntryL,G1H4(34),ex1(:),G1H2(19),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(19),55,nME,G2H2(31),n2h2(79))
  call Hloop_VQ_A(ntryL,G1H4(35),ex1(:),G1H2(20),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(20),55,nME,G2H2(36),n2h2(80))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(87),mass5set(:,2),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(324),G1H4(325),G1H4(326),4)
  call HG1shiftOLR(G1H4(34),16,4)
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(25),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(25),47,nME,G2H2(41),n2h2(81))
  call Hloop_VQ_A(ntryL,G1H4(58),ex1(:),G1H2(26),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(26),47,nME,G2H2(46),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(47),ex1(:),G1H2(31),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(31),47,nME,G2H2(51),n2h2(83))
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(88),mass5set(:,2),  & 
G1H4(45),G1H4(58),G1H4(47),G1H4(327),G1H4(328),G1H4(329),4)
  call HG1shiftOLR(G1H4(58),16,4)
  call Hloop_VQ_A(ntryL,G1H4(57),ex1(:),G1H2(32),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(32),47,nME,G2H2(56),n2h2(84))
  call Hloop_VQ_A(ntryL,G1H4(59),ex1(:),G1H2(37),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(37),47,nME,G2H2(61),n2h2(85))
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(89),mass5set(:,2),  & 
G1H4(57),G1H4(59),G1H4(330),G1H4(331),G1H4(332),G1H4(333),4)
  call HG1shiftOLR(G1H4(59),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(90),mass5set(:,2),  & 
G1H4(334),G1H4(335),G1H4(336),G1H4(337),G1H4(338),G1H4(339),4)
  call HG1shiftOLR(G1H4(335),8,4)
  call Hloop_VA_Q(ntryL,G1H4(69),ex2(:),G1H2(38),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(38),55,nME,G2H2(66),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(70),ex2(:),G1H2(43),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(43),55,nME,G2H2(71),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(71),ex2(:),G1H2(44),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(44),55,nME,G2H2(76),n2h2(88))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(91),mass5set(:,3),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(70),16,4)
  call Hloop_QV_A(ntryL,G1H4(81),ex3(:),G1H2(49),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(81),n2h2(89))
  call Hloop_QV_A(ntryL,G1H4(82),ex3(:),G1H2(50),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(86),n2h2(90))
  call Hotf_4pt_reduction(G2H4(315),RedSet_4(10),mass4set(:,1),  & 
G1H4(81),G1H4(82),G1H4(343),G1H4(344),G1H4(345),G0H4(1),4)
  call HG1shiftOLR(G1H4(82),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(92),mass5set(:,3),  & 
G1H4(346),G1H4(347),G1H4(348),G1H4(349),G1H4(350),G1H4(351),4)
  call HG1shiftOLR(G1H4(347),16,4)
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(55),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(55),47,nME,G2H2(91),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(94),ex4(:),G1H2(56),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(56),47,nME,G2H2(96),n2h2(92))
  call Hotf_4pt_reduction(G2H4(363),RedSet_4(20),mass4set(:,1),  & 
G1H4(93),G1H4(94),G1H4(352),G1H4(353),G1H4(354),G0H4(2),4)
  call HG1shiftOLR(G1H4(94),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(93),mass5set(:,3),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),8,4)
  call Hloop_AV_Q(ntryL,G1H4(105),ex5(:),G1H2(61),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(61),55,nME,G2H2(101),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(106),ex5(:),G1H2(62),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(62),55,nME,G2H2(106),n2h2(94))
  call Hotf_4pt_reduction(G2H4(339),RedSet_4(35),mass4set(:,1),  & 
G1H4(105),G1H4(106),G1H4(361),G1H4(362),G1H4(363),G0H4(3),4)
  call HG1shiftOLR(G1H4(106),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(94),mass5set(:,7),  & 
G1H4(364),G1H4(365),G1H4(366),G1H4(367),G1H4(368),G1H4(369),4)
  call HG1shiftOLR(G1H4(365),16,4)
  call Hotf_5pt_reduction(G2H4(125),RedSet_5(38),mass5set(:,4),  & 
G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),G1H4(375),4)
  call HG1shiftOLR(G1H4(371),16,4)
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(67),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(67),47,nME,G2H2(111),n2h2(95))
  call Hotf_4pt_reduction(G2H4(128),RedSet_4(107),mass4set(:,1),  & 
G1H4(117),G1H4(376),G1H4(377),G1H4(378),G1H4(379),G0H4(4),4)
  call HG1shiftOLR(G1H4(376),16,4)
  call Hloop_QV_A(ntryL,G1H4(119),ex4(:),G1H2(68),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(68),47,nME,G2H2(116),n2h2(96))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(95),mass5set(:,7),  & 
G1H4(119),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),8,4)
  call Hotf_5pt_reduction(G2H4(130),RedSet_5(39),mass5set(:,4),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),8,4)
  call Hloop_QV_A(ntryL,G1H4(129),ex5(:),G1H2(73),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(73),55,nME,G2H2(121),n2h2(97))
  call Hotf_4pt_reduction(G2H4(133),RedSet_4(119),mass4set(:,1),  & 
G1H4(129),G1H4(391),G1H4(392),G1H4(393),G1H4(394),G0H4(5),4)
  call HG1shiftOLR(G1H4(391),8,4)
  call Hloop_QV_A(ntryL,G1H4(131),ex5(:),G1H2(74),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(74),55,nME,G2H2(122),n2h2(98))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(96),mass5set(:,3),  & 
G1H4(131),G1H4(395),G1H4(396),G1H4(397),G1H4(398),G1H4(399),4)
  call HG1shiftOLR(G1H4(395),16,4)
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(79),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(79),47,nME,G2H2(123),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H4(142),ex3(:),G1H2(80),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(80),47,nME,G2H2(124),n2h2(100))
  call Hotf_4pt_reduction(G2H4(307),RedSet_4(10),mass4set(:,1),  & 
G1H4(141),G1H4(142),G1H4(400),G1H4(401),G1H4(402),G0H4(6),4)
  call HG1shiftOLR(G1H4(142),16,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(97),mass5set(:,3),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),16,4)
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(85),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(85),47,nME,G2H2(125),n2h2(101))
  call Hloop_QV_A(ntryL,G1H4(154),ex4(:),G1H2(86),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(86),47,nME,G2H2(126),n2h2(102))
  call Hotf_4pt_reduction(G2H4(355),RedSet_4(20),mass4set(:,1),  & 
G1H4(153),G1H4(154),G1H4(409),G1H4(410),G1H4(411),G0H4(7),4)
  call HG1shiftOLR(G1H4(154),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(98),mass5set(:,7),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),G1H4(417),4)
  call HG1shiftOLR(G1H4(413),16,4)
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(40),mass5set(:,4),  & 
G1H4(418),G1H4(419),G1H4(420),G1H4(421),G1H4(422),G1H4(423),4)
  call HG1shiftOLR(G1H4(419),16,4)
  call Hloop_QV_A(ntryL,G1H4(165),ex3(:),G1H2(91),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(91),47,nME,G2H2(127),n2h2(103))
  call Hotf_4pt_reduction(G2H4(138),RedSet_4(107),mass4set(:,1),  & 
G1H4(165),G1H4(424),G1H4(425),G1H4(426),G1H4(427),G0H4(8),4)
  call HG1shiftOLR(G1H4(424),16,4)
  call Hloop_QV_A(ntryL,G1H4(167),ex3(:),G1H2(92),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(92),47,nME,G2H2(128),n2h2(104))
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(99),mass5set(:,7),  & 
G1H4(167),G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(428),4,4)
  call Hotf_5pt_reduction(G2H4(140),RedSet_5(41),mass5set(:,4),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),4,4)
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(97),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(97),59,nME,G2H2(129),n2h2(105))
  call Hotf_4pt_reduction(G2H4(143),RedSet_4(155),mass4set(:,1),  & 
G1H4(177),G1H4(439),G1H4(440),G1H4(441),G1H4(442),G0H4(9),4)
  call HG1shiftOLR(G1H4(439),4,4)
  call Hloop_QV_A(ntryL,G1H4(179),ex5(:),G1H2(98),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(98),59,nME,G2H2(130),n2h2(106))
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(100),mass5set(:,3),  & 
G1H4(179),G1H4(443),G1H4(444),G1H4(445),G1H4(446),G1H4(447),4)
  call HG1shiftOLR(G1H4(443),8,4)
  call Hloop_QV_A(ntryL,G1H4(189),ex5(:),G1H2(103),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(103),55,nME,G2H2(131),n2h2(107))
  call Hloop_QV_A(ntryL,G1H4(190),ex5(:),G1H2(104),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(104),55,nME,G2H2(132),n2h2(108))
  call Hotf_4pt_reduction(G2H4(331),RedSet_4(35),mass4set(:,1),  & 
G1H4(189),G1H4(190),G1H4(448),G1H4(449),G1H4(450),G0H4(10),4)
  call HG1shiftOLR(G1H4(190),8,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(101),mass5set(:,7),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),8,4)
  call Hotf_5pt_reduction(G2H4(145),RedSet_5(42),mass5set(:,4),  & 
G1H4(457),G1H4(458),G1H4(459),G1H4(460),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(458),8,4)
  call Hloop_QV_A(ntryL,G1H4(201),ex3(:),G1H2(109),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(109),55,nME,G2H2(133),n2h2(109))
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(119),mass4set(:,1),  & 
G1H4(201),G1H4(463),G1H4(464),G1H4(465),G1H4(466),G0H4(11),4)
  call HG1shiftOLR(G1H4(463),8,4)
  call Hloop_QV_A(ntryL,G1H4(203),ex3(:),G1H2(110),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(110),55,nME,G2H2(134),n2h2(110))
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(102),mass5set(:,7),  & 
G1H4(203),G1H4(467),G1H4(468),G1H4(469),G1H4(470),G1H4(471),4)
  call HG1shiftOLR(G1H4(467),4,4)
  call Hotf_5pt_reduction(G2H4(150),RedSet_5(43),mass5set(:,4),  & 
G1H4(472),G1H4(473),G1H4(474),G1H4(475),G1H4(476),G1H4(477),4)
  call HG1shiftOLR(G1H4(473),4,4)
  call Hloop_QV_A(ntryL,G1H4(213),ex4(:),G1H2(115),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(115),59,nME,G2H2(135),n2h2(111))
  call Hotf_4pt_reduction(G2H4(153),RedSet_4(155),mass4set(:,1),  & 
G1H4(213),G1H4(478),G1H4(479),G1H4(480),G1H4(481),G0H4(12),4)
  call HG1shiftOLR(G1H4(478),4,4)
  call Hloop_QV_A(ntryL,G1H4(215),ex4(:),G1H2(116),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(116),59,nME,G2H2(136),n2h2(112))
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(103),mass5set(:,7),  & 
G1H4(215),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),16,4)
  call Hotf_5pt_reduction(G2H4(155),RedSet_5(38),mass5set(:,4),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G1H4(492),4)
  call HG1shiftOLR(G1H4(488),16,4)
  call Hloop_AV_Q(ntryL,G1H4(225),ex4(:),G1H2(121),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(121),47,nME,G2H2(137),n2h2(113))
  call Hotf_4pt_reduction(G2H4(158),RedSet_4(107),mass4set(:,1),  & 
G1H4(225),G1H4(493),G1H4(494),G1H4(495),G1H4(496),G0H4(13),4)
  call HG1shiftOLR(G1H4(493),16,4)
  call Hloop_AV_Q(ntryL,G1H4(227),ex4(:),G1H2(122),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(122),47,nME,G2H2(138),n2h2(114))
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(104),mass5set(:,7),  & 
G1H4(227),G1H4(497),G1H4(498),G1H4(499),G1H4(500),G1H4(501),4)
  call HG1shiftOLR(G1H4(497),8,4)
  call Hotf_5pt_reduction(G2H4(160),RedSet_5(39),mass5set(:,4),  & 
G1H4(502),G1H4(503),G1H4(504),G1H4(505),G1H4(506),G1H4(507),4)
  call HG1shiftOLR(G1H4(503),8,4)
  call Hloop_AV_Q(ntryL,G1H4(237),ex5(:),G1H2(127),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(127),55,nME,G2H2(139),n2h2(115))
  call Hotf_4pt_reduction(G2H4(163),RedSet_4(119),mass4set(:,1),  & 
G1H4(237),G1H4(508),G1H4(509),G1H4(510),G1H4(511),G0H4(14),4)
  call HG1shiftOLR(G1H4(508),8,4)
  call Hloop_AV_Q(ntryL,G1H4(239),ex5(:),G1H2(128),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(128),55,nME,G2H2(140),n2h2(116))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(105),mass5set(:,7),  & 
G1H4(239),G1H4(512),G1H4(513),G1H4(514),G1H4(515),G1H4(516),4)
  call HG1shiftOLR(G1H4(512),16,4)
  call Hotf_5pt_reduction(G2H4(165),RedSet_5(40),mass5set(:,4),  & 
G1H4(517),G1H4(518),G1H4(519),G1H4(520),G1H4(521),G1H4(522),4)
  call HG1shiftOLR(G1H4(518),16,4)
  call Hloop_AV_Q(ntryL,G1H4(249),ex3(:),G1H2(133),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(133),47,nME,G2H2(141),n2h2(117))
  call Hotf_4pt_reduction(G2H4(168),RedSet_4(107),mass4set(:,1),  & 
G1H4(249),G1H4(523),G1H4(524),G1H4(525),G1H4(526),G0H4(15),4)
  call HG1shiftOLR(G1H4(523),16,4)
  call Hloop_AV_Q(ntryL,G1H4(251),ex3(:),G1H2(134),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(134),47,nME,G2H2(142),n2h2(118))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(106),mass5set(:,7),  & 
G1H4(251),G1H4(527),G1H4(528),G1H4(529),G1H4(530),G1H4(531),4)
  call HG1shiftOLR(G1H4(527),4,4)
  call Hotf_5pt_reduction(G2H4(170),RedSet_5(41),mass5set(:,4),  & 
G1H4(532),G1H4(533),G1H4(534),G1H4(535),G1H4(536),G1H4(537),4)
  call HG1shiftOLR(G1H4(533),4,4)
  call Hloop_AV_Q(ntryL,G1H4(261),ex5(:),G1H2(139),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(139),59,nME,G2H2(143),n2h2(119))
  call Hotf_4pt_reduction(G2H4(173),RedSet_4(155),mass4set(:,1),  & 
G1H4(261),G1H4(538),G1H4(539),G1H4(540),G1H4(541),G0H4(16),4)
  call HG1shiftOLR(G1H4(538),4,4)
  call Hloop_AV_Q(ntryL,G1H4(263),ex5(:),G1H2(140),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(140),59,nME,G2H2(144),n2h2(120))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(107),mass5set(:,7),  & 
G1H4(263),G1H4(542),G1H4(543),G1H4(544),G1H4(545),G1H4(546),4)
  call HG1shiftOLR(G1H4(542),8,4)
  call Hotf_5pt_reduction(G2H4(175),RedSet_5(42),mass5set(:,4),  & 
G1H4(547),G1H4(548),G1H4(549),G1H4(550),G1H4(551),G1H4(552),4)
  call HG1shiftOLR(G1H4(548),8,4)
  call Hloop_AV_Q(ntryL,G1H4(273),ex3(:),G1H2(1),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(145),n2h2(121))
  call Hotf_4pt_reduction(G2H4(178),RedSet_4(119),mass4set(:,1),  & 
G1H4(273),G1H4(553),G1H4(554),G1H4(555),G1H4(556),G0H4(17),4)
  call HG1shiftOLR(G1H4(553),8,4)
  call Hloop_AV_Q(ntryL,G1H4(275),ex3(:),G1H2(2),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(2),55,nME,G2H2(146),n2h2(122))
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(108),mass5set(:,7),  & 
G1H4(275),G1H4(557),G1H4(558),G1H4(559),G1H4(560),G1H4(561),4)
  call HG1shiftOLR(G1H4(557),4,4)
  call Hotf_5pt_reduction(G2H4(180),RedSet_5(43),mass5set(:,4),  & 
G1H4(562),G1H4(563),G1H4(564),G1H4(565),G1H4(566),G1H4(567),4)
  call HG1shiftOLR(G1H4(563),4,4)
  call Hloop_AV_Q(ntryL,G1H4(285),ex4(:),G1H2(7),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(7),59,nME,G2H2(147),n2h2(123))
  call Hotf_4pt_reduction(G2H4(183),RedSet_4(155),mass4set(:,1),  & 
G1H4(285),G1H4(568),G1H4(569),G1H4(570),G1H4(571),G0H4(18),4)
  call HG1shiftOLR(G1H4(568),4,4)
  call Hloop_AV_Q(ntryL,G1H4(287),ex4(:),G1H2(8),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(8),59,nME,G2H2(148),n2h2(124))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(20),mass5set(:,2),  & 
G1H8(116),G1H8(118),G1H8(119),G1H8(120),G1H8(121),G1H8(122),8)
  call HG1shiftOLR(G1H8(118),16,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(25),mass5set(:,2),  & 
G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),G1H8(130),8)
  call HG1shiftOLR(G1H8(125),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(26),mass5set(:,2),  & 
G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(136),G1H8(137),8)
  call HG1shiftOLR(G1H8(132),16,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(21),mass5set(:,2),  & 
G1H8(138),G1H8(139),G1H8(140),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(139),16,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(28),mass5set(:,2),  & 
G1H8(145),G1H8(146),G1H8(148),G1H8(149),G1H8(150),G1H8(151),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(22),mass5set(:,2),  & 
G1H8(152),G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),8)
  call HG1shiftOLR(G1H8(154),8,8)
  call Hloop_AQ_V(ntryL,G2H4(95),ex1(:),G2H2(149),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_AQ_V(ntryL,G2H4(98),ex1(:),G2H2(150),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_AQ_V(ntryL,G2H4(99),ex1(:),G2H2(151),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_AQ_V(ntryL,G2H4(100),ex1(:),G2H2(152),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_AQ_V(ntryL,G2H4(103),ex1(:),G2H2(153),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_AQ_V(ntryL,G2H4(104),ex1(:),G2H2(154),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_QA_V(ntryL,G2H4(105),ex2(:),G2H2(155),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_QA_V(ntryL,G2H4(108),ex2(:),G2H2(156),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_QA_V(ntryL,G2H4(109),ex2(:),G2H2(157),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_QA_V(ntryL,G2H4(110),ex2(:),G2H2(158),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_QA_V(ntryL,G2H4(113),ex2(:),G2H2(159),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_QA_V(ntryL,G2H4(114),ex2(:),G2H2(160),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_QA_V(ntryL,G2H4(115),ex2(:),G2H2(161),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_QA_V(ntryL,G2H4(118),ex2(:),G2H2(162),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_QA_V(ntryL,G2H4(119),ex2(:),G2H2(163),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_AQ_V(ntryL,G2H4(120),ex1(:),G2H2(164),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_AQ_V(ntryL,G2H4(123),ex1(:),G2H2(165),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_AQ_V(ntryL,G2H4(124),ex1(:),G2H2(166),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(108),mass4set(:,1),  & 
G1H4(287),G1H4(572),G1H4(573),G1H4(574),G1H4(575),G0H4(19),4)
  call HG1shiftOLR(G1H4(572),24,4)
  call Hotf_4pt_reduction(G2H4(134),RedSet_4(108),mass4set(:,1),  & 
G1H4(576),G1H4(577),G1H4(578),G1H4(579),G1H4(580),G0H4(20),4)
  call HG1shiftOLR(G1H4(577),24,4)
  call Hotf_4pt_reduction(G2H4(139),RedSet_4(146),mass4set(:,1),  & 
G1H4(581),G1H4(582),G1H4(583),G1H4(584),G1H4(585),G0H4(21),4)
  call HG1shiftOLR(G1H4(582),20,4)
  call Hotf_4pt_reduction(G2H4(144),RedSet_4(146),mass4set(:,1),  & 
G1H4(586),G1H4(587),G1H4(588),G1H4(589),G1H4(590),G0H4(22),4)
  call HG1shiftOLR(G1H4(587),20,4)
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(171),mass4set(:,1),  & 
G1H4(591),G1H4(592),G1H4(593),G1H4(594),G1H4(595),G0H4(23),4)
  call HG1shiftOLR(G1H4(592),12,4)
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(171),mass4set(:,1),  & 
G1H4(596),G1H4(597),G1H4(598),G1H4(599),G1H4(600),G0H4(24),4)
  call HG1shiftOLR(G1H4(597),12,4)
  call Hotf_4pt_reduction(G2H4(159),RedSet_4(108),mass4set(:,1),  & 
G1H4(601),G1H4(602),G1H4(603),G1H4(604),G1H4(605),G0H4(25),4)
  call HG1shiftOLR(G1H4(602),24,4)
  call Hotf_4pt_reduction(G2H4(164),RedSet_4(108),mass4set(:,1),  & 
G1H4(606),G1H4(607),G1H4(608),G1H4(609),G1H4(610),G0H4(26),4)
  call HG1shiftOLR(G1H4(607),24,4)
  call Hotf_4pt_reduction(G2H4(169),RedSet_4(146),mass4set(:,1),  & 
G1H4(611),G1H4(612),G1H4(613),G1H4(614),G1H4(615),G0H4(27),4)
  call HG1shiftOLR(G1H4(612),20,4)
  call Hotf_4pt_reduction(G2H4(174),RedSet_4(146),mass4set(:,1),  & 
G1H4(616),G1H4(617),G1H4(618),G1H4(619),G1H4(620),G0H4(28),4)
  call HG1shiftOLR(G1H4(617),20,4)
  call Hotf_4pt_reduction(G2H4(179),RedSet_4(171),mass4set(:,1),  & 
G1H4(621),G1H4(622),G1H4(623),G1H4(624),G1H4(625),G0H4(29),4)
  call HG1shiftOLR(G1H4(622),12,4)
  call Hotf_4pt_reduction(G2H4(184),RedSet_4(171),mass4set(:,1),  & 
G1H4(626),G1H4(627),G1H4(628),G1H4(629),G1H4(630),G0H4(30),4)
  call HG1shiftOLR(G1H4(627),12,4)
  call Hotf_5pt_reduction(G2H4(185),RedSet_5(42),mass5set(:,5),  & 
G1H4(631),G1H4(632),G1H4(633),G1H4(634),G1H4(635),G1H4(636),4)
  call HG1shiftOLR(G1H4(632),8,4)
  call Hotf_4pt_reduction(G2H4(188),RedSet_4(119),mass4set(:,2),  & 
G1H4(637),G1H4(638),G1H4(639),G1H4(640),G1H4(641),G0H4(31),4)
  call HG1shiftOLR(G1H4(638),8,4)
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(171),mass4set(:,2),  & 
G1H4(642),G1H4(643),G1H4(644),G1H4(645),G1H4(646),G0H4(32),4)
  call HG1shiftOLR(G1H4(643),12,4)
  call Hotf_5pt_reduction(G2H4(190),RedSet_5(42),mass5set(:,5),  & 
G1H4(647),G1H4(648),G1H4(649),G1H4(650),G1H4(651),G1H4(652),4)
  call HG1shiftOLR(G1H4(648),8,4)
  call Hotf_4pt_reduction(G2H4(193),RedSet_4(119),mass4set(:,2),  & 
G1H4(653),G1H4(654),G1H4(655),G1H4(656),G1H4(657),G0H4(33),4)
  call HG1shiftOLR(G1H4(654),8,4)
  call Hotf_4pt_reduction(G2H4(194),RedSet_4(171),mass4set(:,2),  & 
G1H4(658),G1H4(659),G1H4(660),G1H4(661),G1H4(662),G0H4(34),4)
  call HG1shiftOLR(G1H4(659),12,4)
  call Hotf_5pt_reduction(G2H4(195),RedSet_5(42),mass5set(:,6),  & 
G1H4(663),G1H4(664),G1H4(665),G1H4(666),G1H4(667),G1H4(668),4)
  call HG1shiftOLR(G1H4(664),8,4)
  call Hotf_4pt_reduction(G2H4(198),RedSet_4(119),mass4set(:,3),  & 
G1H4(669),G1H4(670),G1H4(671),G1H4(672),G1H4(673),G0H4(35),4)
  call HG1shiftOLR(G1H4(670),8,4)
  call Hotf_4pt_reduction(G2H4(199),RedSet_4(171),mass4set(:,3),  & 
G1H4(674),G1H4(675),G1H4(676),G1H4(677),G1H4(678),G0H4(36),4)
  call HG1shiftOLR(G1H4(675),12,4)
  call Hotf_5pt_reduction(G2H4(200),RedSet_5(42),mass5set(:,6),  & 
G1H4(679),G1H4(680),G1H4(681),G1H4(682),G1H4(683),G1H4(684),4)
  call HG1shiftOLR(G1H4(680),8,4)
  call Hotf_4pt_reduction(G2H4(203),RedSet_4(119),mass4set(:,3),  & 
G1H4(685),G1H4(686),G1H4(687),G1H4(688),G1H4(689),G0H4(37),4)
  call HG1shiftOLR(G1H4(686),8,4)
  call Hotf_4pt_reduction(G2H4(204),RedSet_4(171),mass4set(:,3),  & 
G1H4(690),G1H4(691),G1H4(692),G1H4(693),G1H4(694),G0H4(38),4)
  call HG1shiftOLR(G1H4(691),12,4)
  call Hotf_5pt_reduction(G2H4(205),RedSet_5(40),mass5set(:,5),  & 
G1H4(695),G1H4(696),G1H4(697),G1H4(698),G1H4(699),G1H4(700),4)
  call HG1shiftOLR(G1H4(696),16,4)
  call Hotf_4pt_reduction(G2H4(208),RedSet_4(107),mass4set(:,2),  & 
G1H4(701),G1H4(702),G1H4(703),G1H4(704),G1H4(705),G0H4(39),4)
  call HG1shiftOLR(G1H4(702),16,4)
  call Hotf_4pt_reduction(G2H4(209),RedSet_4(146),mass4set(:,2),  & 
G1H4(706),G1H4(707),G1H4(708),G1H4(709),G1H4(710),G0H4(40),4)
  call HG1shiftOLR(G1H4(707),20,4)
  call Hotf_5pt_reduction(G2H4(210),RedSet_5(40),mass5set(:,5),  & 
G1H4(711),G1H4(712),G1H4(713),G1H4(714),G1H4(715),G1H4(716),4)
  call HG1shiftOLR(G1H4(712),16,4)
  call Hotf_4pt_reduction(G2H4(213),RedSet_4(107),mass4set(:,2),  & 
G1H4(717),G1H4(718),G1H4(719),G1H4(720),G1H4(721),G0H4(41),4)
  call HG1shiftOLR(G1H4(718),16,4)
  call Hotf_4pt_reduction(G2H4(214),RedSet_4(146),mass4set(:,2),  & 
G1H4(722),G1H4(723),G1H4(724),G1H4(725),G1H4(726),G0H4(42),4)
  call HG1shiftOLR(G1H4(723),20,4)
  call Hotf_5pt_reduction(G2H4(215),RedSet_5(40),mass5set(:,6),  & 
G1H4(727),G1H4(728),G1H4(729),G1H4(730),G1H4(731),G1H4(732),4)
  call HG1shiftOLR(G1H4(728),16,4)
  call Hotf_4pt_reduction(G2H4(218),RedSet_4(107),mass4set(:,3),  & 
G1H4(733),G1H4(734),G1H4(735),G1H4(736),G1H4(737),G0H4(43),4)
  call HG1shiftOLR(G1H4(734),16,4)
  call Hotf_4pt_reduction(G2H4(219),RedSet_4(146),mass4set(:,3),  & 
G1H4(738),G1H4(739),G1H4(740),G1H4(741),G1H4(742),G0H4(44),4)
  call HG1shiftOLR(G1H4(739),20,4)
  call Hotf_5pt_reduction(G2H4(220),RedSet_5(40),mass5set(:,6),  & 
G1H4(743),G1H4(744),G1H4(745),G1H4(746),G1H4(747),G1H4(748),4)
  call HG1shiftOLR(G1H4(744),16,4)
  call Hotf_4pt_reduction(G2H4(223),RedSet_4(107),mass4set(:,3),  & 
G1H4(749),G1H4(750),G1H4(751),G1H4(752),G1H4(753),G0H4(45),4)
  call HG1shiftOLR(G1H4(750),16,4)
  call Hotf_4pt_reduction(G2H4(224),RedSet_4(146),mass4set(:,3),  & 
G1H4(754),G1H4(755),G1H4(756),G1H4(757),G1H4(758),G0H4(46),4)
  call HG1shiftOLR(G1H4(755),20,4)
  call Hotf_5pt_reduction(G2H4(225),RedSet_5(43),mass5set(:,5),  & 
G1H4(759),G1H4(760),G1H4(761),G1H4(762),G1H4(763),G1H4(764),4)
  call HG1shiftOLR(G1H4(760),4,4)
  call Hotf_4pt_reduction(G2H4(228),RedSet_4(155),mass4set(:,2),  & 
G1H4(765),G1H4(766),G1H4(767),G1H4(768),G1H4(769),G0H4(47),4)
  call HG1shiftOLR(G1H4(766),4,4)
  call Hotf_4pt_reduction(G2H4(229),RedSet_4(171),mass4set(:,2),  & 
G1H4(770),G1H4(771),G1H4(772),G1H4(773),G1H4(774),G0H4(48),4)
  call HG1shiftOLR(G1H4(771),12,4)
  call Hotf_5pt_reduction(G2H4(230),RedSet_5(43),mass5set(:,5),  & 
G1H4(775),G1H4(776),G1H4(777),G1H4(778),G1H4(779),G1H4(780),4)
  call HG1shiftOLR(G1H4(776),4,4)
  call Hotf_4pt_reduction(G2H4(233),RedSet_4(155),mass4set(:,2),  & 
G1H4(781),G1H4(782),G1H4(783),G1H4(784),G1H4(785),G0H4(49),4)
  call HG1shiftOLR(G1H4(782),4,4)
  call Hotf_4pt_reduction(G2H4(234),RedSet_4(171),mass4set(:,2),  & 
G1H4(786),G1H4(787),G1H4(788),G1H4(789),G1H4(790),G0H4(50),4)
  call HG1shiftOLR(G1H4(787),12,4)
  call Hotf_5pt_reduction(G2H4(235),RedSet_5(43),mass5set(:,6),  & 
G1H4(791),G1H4(792),G1H4(793),G1H4(794),G1H4(795),G1H4(796),4)
  call HG1shiftOLR(G1H4(792),4,4)
  call Hotf_4pt_reduction(G2H4(238),RedSet_4(155),mass4set(:,3),  & 
G1H4(797),G1H4(798),G1H4(799),G1H4(800),G1H4(801),G0H4(51),4)
  call HG1shiftOLR(G1H4(798),4,4)
  call Hotf_4pt_reduction(G2H4(239),RedSet_4(171),mass4set(:,3),  & 
G1H4(802),G1H4(803),G1H4(804),G1H4(805),G1H4(806),G0H4(52),4)
  call HG1shiftOLR(G1H4(803),12,4)
  call Hotf_5pt_reduction(G2H4(240),RedSet_5(43),mass5set(:,6),  & 
G1H4(807),G1H4(808),G1H4(809),G1H4(810),G1H4(811),G1H4(812),4)
  call HG1shiftOLR(G1H4(808),4,4)
  call Hotf_4pt_reduction(G2H4(243),RedSet_4(155),mass4set(:,3),  & 
G1H4(813),G1H4(814),G1H4(815),G1H4(816),G1H4(817),G0H4(53),4)
  call HG1shiftOLR(G1H4(814),4,4)
  call Hotf_4pt_reduction(G2H4(244),RedSet_4(171),mass4set(:,3),  & 
G1H4(818),G1H4(819),G1H4(820),G1H4(821),G1H4(822),G0H4(54),4)
  call HG1shiftOLR(G1H4(819),12,4)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(18),mass5set(:,4),  & 
G1H8(160),G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(166),8)
  call HG1shiftOLR(G1H8(161),16,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(20),mass4set(:,1),  & 
G1H8(167),G1H8(168),G1H8(169),G1H8(170),G1H8(172),G0H8(1),8)
  call HG1shiftOLR(G1H8(168),16,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(23),mass4set(:,1),  & 
G1H8(173),G1H8(174),G1H8(175),G1H8(176),G1H8(178),G0H8(2),8)
  call HG1shiftOLR(G1H8(174),19,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(18),mass5set(:,5),  & 
G1H8(179),G1H8(180),G1H8(91),G1H8(92),G1H8(96),G1H8(97),8)
  call HG1shiftOLR(G1H8(180),16,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(20),mass4set(:,2),  & 
G1H8(98),G1H8(101),G1H8(102),G1H8(104),G1H8(107),G0H8(3),8)
  call HG1shiftOLR(G1H8(101),16,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(23),mass4set(:,2),  & 
G1H8(108),G1H8(1),G1H8(2),G1H8(6),G1H8(7),G0H8(4),8)
  call HG1shiftOLR(G1H8(1),19,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(18),mass5set(:,4),  & 
G1H8(8),G1H8(11),G1H8(12),G1H8(14),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(11),16,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(20),mass4set(:,1),  & 
G1H8(19),G1H8(20),G1H8(24),G1H8(25),G1H8(181),G0H8(5),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_4pt_reduction(G2H8(50),RedSet_4(23),mass4set(:,1),  & 
G1H8(182),G1H8(184),G1H8(185),G1H8(186),G1H8(187),G0H8(6),8)
  call HG1shiftOLR(G1H8(184),19,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(18),mass5set(:,5),  & 
G1H8(188),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
  call HG1shiftOLR(G1H8(190),16,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(20),mass4set(:,2),  & 
G1H8(196),G1H8(197),G1H8(198),G1H8(199),G1H8(200),G0H8(7),8)
  call HG1shiftOLR(G1H8(197),16,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(23),mass4set(:,2),  & 
G1H8(202),G1H8(203),G1H8(204),G1H8(26),G1H8(29),G0H8(8),8)
  call HG1shiftOLR(G1H8(203),19,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(18),mass5set(:,6),  & 
G1H8(30),G1H8(32),G1H8(35),G1H8(36),G1H8(37),G1H8(38),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(20),mass4set(:,3),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(47),G1H8(48),G0H8(9),8)
  call HG1shiftOLR(G1H8(43),16,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(23),mass4set(:,3),  & 
G1H8(50),G1H8(53),G1H8(54),G1H8(55),G1H8(56),G0H8(10),8)
  call HG1shiftOLR(G1H8(53),19,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(18),mass5set(:,6),  & 
G1H8(60),G1H8(61),G1H8(62),G1H8(4),G1H8(10),G1H8(21),8)
  call HG1shiftOLR(G1H8(61),16,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(20),mass4set(:,3),  & 
G1H8(205),G1H8(206),G1H8(208),G1H8(209),G1H8(210),G0H8(11),8)
  call HG1shiftOLR(G1H8(206),16,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(23),mass4set(:,3),  & 
G1H8(211),G1H8(212),G1H8(214),G1H8(215),G1H8(216),G0H8(12),8)
  call HG1shiftOLR(G1H8(212),19,8)
  call Hotf_5pt_reduction(G2H4(245),RedSet_5(38),mass5set(:,5),  & 
G1H4(823),G1H4(824),G1H4(825),G1H4(826),G1H4(827),G1H4(828),4)
  call HG1shiftOLR(G1H4(824),16,4)
  call Hotf_4pt_reduction(G2H4(248),RedSet_4(107),mass4set(:,2),  & 
G1H4(829),G1H4(830),G1H4(831),G1H4(832),G1H4(833),G0H4(55),4)
  call HG1shiftOLR(G1H4(830),16,4)
  call Hotf_4pt_reduction(G2H4(249),RedSet_4(108),mass4set(:,2),  & 
G1H4(834),G1H4(835),G1H4(836),G1H4(837),G1H4(838),G0H4(56),4)
  call HG1shiftOLR(G1H4(835),24,4)
  call Hotf_5pt_reduction(G2H4(250),RedSet_5(38),mass5set(:,5),  & 
G1H4(839),G1H4(840),G1H4(841),G1H4(842),G1H4(843),G1H4(844),4)
  call HG1shiftOLR(G1H4(840),16,4)
  call Hotf_4pt_reduction(G2H4(253),RedSet_4(107),mass4set(:,2),  & 
G1H4(845),G1H4(846),G1H4(847),G1H4(848),G1H4(849),G0H4(57),4)
  call HG1shiftOLR(G1H4(846),16,4)
  call Hotf_4pt_reduction(G2H4(254),RedSet_4(108),mass4set(:,2),  & 
G1H4(850),G1H4(851),G1H4(852),G1H4(853),G1H4(854),G0H4(58),4)
  call HG1shiftOLR(G1H4(851),24,4)
  call Hotf_5pt_reduction(G2H4(255),RedSet_5(38),mass5set(:,6),  & 
G1H4(855),G1H4(856),G1H4(857),G1H4(858),G1H4(859),G1H4(860),4)
  call HG1shiftOLR(G1H4(856),16,4)
  call Hotf_4pt_reduction(G2H4(258),RedSet_4(107),mass4set(:,3),  & 
G1H4(861),G1H4(862),G1H4(863),G1H4(864),G1H4(865),G0H4(59),4)
  call HG1shiftOLR(G1H4(862),16,4)
  call Hotf_4pt_reduction(G2H4(259),RedSet_4(108),mass4set(:,3),  & 
G1H4(866),G1H4(867),G1H4(868),G1H4(869),G1H4(870),G0H4(60),4)
  call HG1shiftOLR(G1H4(867),24,4)
  call Hotf_5pt_reduction(G2H4(260),RedSet_5(38),mass5set(:,6),  & 
G1H4(871),G1H4(872),G1H4(873),G1H4(874),G1H4(875),G1H4(876),4)
  call HG1shiftOLR(G1H4(872),16,4)
  call Hotf_4pt_reduction(G2H4(263),RedSet_4(107),mass4set(:,3),  & 
G1H4(877),G1H4(878),G1H4(879),G1H4(880),G1H4(881),G0H4(61),4)
  call HG1shiftOLR(G1H4(878),16,4)
  call Hotf_4pt_reduction(G2H4(264),RedSet_4(108),mass4set(:,3),  & 
G1H4(882),G1H4(883),G1H4(884),G1H4(885),G1H4(886),G0H4(62),4)
  call HG1shiftOLR(G1H4(883),24,4)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(17),mass5set(:,4),  & 
G1H8(217),G1H8(218),G1H8(220),G1H8(221),G1H8(222),G1H8(223),8)
  call HG1shiftOLR(G1H8(218),16,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(10),mass4set(:,1),  & 
G1H8(224),G1H8(226),G1H8(227),G1H8(228),G1H8(22),G0H8(13),8)
  call HG1shiftOLR(G1H8(226),16,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(13),mass4set(:,1),  & 
G1H8(27),G1H8(28),G1H8(34),G1H8(45),G1H8(46),G0H8(14),8)
  call HG1shiftOLR(G1H8(28),19,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(17),mass5set(:,5),  & 
G1H8(51),G1H8(52),G1H8(58),G1H8(64),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(52),16,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(10),mass4set(:,2),  & 
G1H8(75),G1H8(76),G1H8(82),G1H8(87),G1H8(88),G0H8(15),8)
  call HG1shiftOLR(G1H8(76),16,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(13),mass4set(:,2),  & 
G1H8(93),G1H8(94),G1H8(100),G1H8(105),G1H8(106),G0H8(16),8)
  call HG1shiftOLR(G1H8(94),19,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(17),mass5set(:,4),  & 
G1H8(3),G1H8(72),G1H8(229),G1H8(230),G1H8(232),G1H8(233),8)
  call HG1shiftOLR(G1H8(72),16,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(10),mass4set(:,1),  & 
G1H8(234),G1H8(235),G1H8(236),G1H8(238),G1H8(239),G0H8(17),8)
  call HG1shiftOLR(G1H8(235),16,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(13),mass4set(:,1),  & 
G1H8(240),G1H8(241),G1H8(242),G1H8(244),G1H8(245),G0H8(18),8)
  call HG1shiftOLR(G1H8(241),19,8)
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(17),mass5set(:,5),  & 
G1H8(246),G1H8(247),G1H8(248),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(247),16,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(10),mass4set(:,2),  & 
G1H8(65),G1H8(15),G1H8(66),G1H8(83),G1H8(84),G0H8(19),8)
  call HG1shiftOLR(G1H8(15),16,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(13),mass4set(:,2),  & 
G1H8(71),G1H8(39),G1H8(67),G1H8(85),G1H8(86),G0H8(20),8)
  call HG1shiftOLR(G1H8(39),19,8)
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(17),mass5set(:,6),  & 
G1H8(68),G1H8(89),G1H8(90),G1H8(73),G1H8(74),G1H8(78),8)
  call HG1shiftOLR(G1H8(89),16,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(10),mass4set(:,3),  & 
G1H8(79),G1H8(80),G1H8(109),G1H8(110),G1H8(112),G0H8(21),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(13),mass4set(:,3),  & 
G1H8(113),G1H8(114),G1H8(115),G1H8(253),G1H8(254),G0H8(22),8)
  call HG1shiftOLR(G1H8(114),19,8)
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(17),mass5set(:,6),  & 
G1H8(255),G1H8(256),G1H8(257),G1H8(258),G1H8(259),G1H8(260),8)
  call HG1shiftOLR(G1H8(256),16,8)
  call Hotf_4pt_reduction(G2H8(65),RedSet_4(10),mass4set(:,3),  & 
G1H8(261),G1H8(262),G1H8(263),G1H8(264),G1H8(265),G0H8(23),8)
  call HG1shiftOLR(G1H8(262),16,8)
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(13),mass4set(:,3),  & 
G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),G0H8(24),8)
  call HG1shiftOLR(G1H8(267),19,8)
  call Hotf_5pt_reduction(G2H4(265),RedSet_5(41),mass5set(:,5),  & 
G1H4(887),G1H4(888),G1H4(889),G1H4(890),G1H4(891),G1H4(892),4)
  call HG1shiftOLR(G1H4(888),4,4)
  call Hotf_4pt_reduction(G2H4(268),RedSet_4(155),mass4set(:,2),  & 
G1H4(893),G1H4(894),G1H4(895),G1H4(896),G1H4(897),G0H4(63),4)
  call HG1shiftOLR(G1H4(894),4,4)
  call Hotf_4pt_reduction(G2H4(269),RedSet_4(146),mass4set(:,2),  & 
G1H4(898),G1H4(899),G1H4(900),G1H4(901),G1H4(902),G0H4(64),4)
  call HG1shiftOLR(G1H4(899),20,4)
  call Hotf_5pt_reduction(G2H4(270),RedSet_5(41),mass5set(:,5),  & 
G1H4(903),G1H4(904),G1H4(905),G1H4(906),G1H4(907),G1H4(908),4)
  call HG1shiftOLR(G1H4(904),4,4)
  call Hotf_4pt_reduction(G2H4(273),RedSet_4(155),mass4set(:,2),  & 
G1H4(909),G1H4(910),G1H4(911),G1H4(912),G1H4(913),G0H4(65),4)
  call HG1shiftOLR(G1H4(910),4,4)
  call Hotf_4pt_reduction(G2H4(274),RedSet_4(146),mass4set(:,2),  & 
G1H4(914),G1H4(915),G1H4(916),G1H4(917),G1H4(918),G0H4(66),4)
  call HG1shiftOLR(G1H4(915),20,4)
  call Hotf_5pt_reduction(G2H4(275),RedSet_5(41),mass5set(:,6),  & 
G1H4(919),G1H4(920),G1H4(921),G1H4(922),G1H4(923),G1H4(924),4)
  call HG1shiftOLR(G1H4(920),4,4)
  call Hotf_4pt_reduction(G2H4(278),RedSet_4(155),mass4set(:,3),  & 
G1H4(925),G1H4(926),G1H4(927),G1H4(928),G1H4(929),G0H4(67),4)
  call HG1shiftOLR(G1H4(926),4,4)
  call Hotf_4pt_reduction(G2H4(279),RedSet_4(146),mass4set(:,3),  & 
G1H4(930),G1H4(931),G1H4(932),G1H4(933),G1H4(934),G0H4(68),4)
  call HG1shiftOLR(G1H4(931),20,4)
  call Hotf_5pt_reduction(G2H4(280),RedSet_5(41),mass5set(:,6),  & 
G1H4(935),G1H4(936),G1H4(937),G1H4(938),G1H4(939),G1H4(940),4)
  call HG1shiftOLR(G1H4(936),4,4)
  call Hotf_4pt_reduction(G2H4(283),RedSet_4(155),mass4set(:,3),  & 
G1H4(941),G1H4(942),G1H4(943),G1H4(944),G1H4(945),G0H4(69),4)
  call HG1shiftOLR(G1H4(942),4,4)
  call Hotf_4pt_reduction(G2H4(284),RedSet_4(146),mass4set(:,3),  & 
G1H4(946),G1H4(947),G1H4(948),G1H4(949),G1H4(950),G0H4(70),4)
  call HG1shiftOLR(G1H4(947),20,4)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(19),mass5set(:,4),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),8,8)
  call Hotf_4pt_reduction(G2H8(70),RedSet_4(35),mass4set(:,1),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G0H8(25),8)
  call HG1shiftOLR(G1H8(278),8,8)
  call Hotf_4pt_reduction(G2H8(71),RedSet_4(38),mass4set(:,1),  & 
G1H8(282),G1H8(283),G1H8(284),G1H8(285),G1H8(286),G0H8(26),8)
  call HG1shiftOLR(G1H8(283),11,8)
  call Hotf_5pt_reduction(G2H8(72),RedSet_5(19),mass5set(:,5),  & 
G1H8(287),G1H8(288),G1H8(289),G1H8(290),G1H8(291),G1H8(292),8)
  call HG1shiftOLR(G1H8(288),8,8)
  call Hotf_4pt_reduction(G2H8(75),RedSet_4(35),mass4set(:,2),  & 
G1H8(293),G1H8(294),G1H8(295),G1H8(296),G1H8(297),G0H8(27),8)
  call HG1shiftOLR(G1H8(294),8,8)
  call Hotf_4pt_reduction(G2H8(76),RedSet_4(38),mass4set(:,2),  & 
G1H8(298),G1H8(299),G1H8(300),G1H8(301),G1H8(302),G0H8(28),8)
  call HG1shiftOLR(G1H8(299),11,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(19),mass5set(:,4),  & 
G1H8(303),G1H8(304),G1H8(305),G1H8(306),G1H8(307),G1H8(308),8)
  call HG1shiftOLR(G1H8(304),8,8)
  call Hotf_4pt_reduction(G2H8(80),RedSet_4(35),mass4set(:,1),  & 
G1H8(309),G1H8(310),G1H8(311),G1H8(312),G1H8(313),G0H8(29),8)
  call HG1shiftOLR(G1H8(310),8,8)
  call Hotf_4pt_reduction(G2H8(81),RedSet_4(38),mass4set(:,1),  & 
G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),G0H8(30),8)
  call HG1shiftOLR(G1H8(315),11,8)
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(19),mass5set(:,5),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),8,8)
  call Hotf_4pt_reduction(G2H8(85),RedSet_4(35),mass4set(:,2),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G0H8(31),8)
  call HG1shiftOLR(G1H8(326),8,8)
  call Hotf_4pt_reduction(G2H8(86),RedSet_4(38),mass4set(:,2),  & 
G1H8(330),G1H8(331),G1H8(332),G1H8(333),G1H8(334),G0H8(32),8)
  call HG1shiftOLR(G1H8(331),11,8)
  call Hotf_5pt_reduction(G2H8(87),RedSet_5(19),mass5set(:,6),  & 
G1H8(335),G1H8(336),G1H8(337),G1H8(338),G1H8(339),G1H8(340),8)
  call HG1shiftOLR(G1H8(336),8,8)
  call Hotf_4pt_reduction(G2H8(90),RedSet_4(35),mass4set(:,3),  & 
G1H8(341),G1H8(342),G1H8(343),G1H8(344),G1H8(345),G0H8(33),8)
  call HG1shiftOLR(G1H8(342),8,8)
  call Hotf_4pt_reduction(G2H8(91),RedSet_4(38),mass4set(:,3),  & 
G1H8(346),G1H8(347),G1H8(348),G1H8(349),G1H8(350),G0H8(34),8)
  call HG1shiftOLR(G1H8(347),11,8)
  call Hotf_5pt_reduction(G2H8(92),RedSet_5(19),mass5set(:,6),  & 
G1H8(351),G1H8(352),G1H8(353),G1H8(354),G1H8(355),G1H8(356),8)
  call HG1shiftOLR(G1H8(352),8,8)
  call Hotf_4pt_reduction(G2H8(95),RedSet_4(35),mass4set(:,3),  & 
G1H8(357),G1H8(358),G1H8(359),G1H8(360),G1H8(361),G0H8(35),8)
  call HG1shiftOLR(G1H8(358),8,8)
  call Hotf_4pt_reduction(G2H8(96),RedSet_4(38),mass4set(:,3),  & 
G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),G0H8(36),8)
  call HG1shiftOLR(G1H8(363),11,8)
  call Hotf_5pt_reduction(G2H4(285),RedSet_5(39),mass5set(:,5),  & 
G1H4(951),G1H4(952),G1H4(953),G1H4(954),G1H4(955),G1H4(956),4)
  call HG1shiftOLR(G1H4(952),8,4)
  call Hotf_4pt_reduction(G2H4(288),RedSet_4(119),mass4set(:,2),  & 
G1H4(957),G1H4(958),G1H4(959),G1H4(960),G1H4(961),G0H4(71),4)
  call HG1shiftOLR(G1H4(958),8,4)
  call Hotf_4pt_reduction(G2H4(289),RedSet_4(108),mass4set(:,2),  & 
G1H4(962),G1H4(963),G1H4(964),G1H4(965),G1H4(966),G0H4(72),4)
  call HG1shiftOLR(G1H4(963),24,4)
  call Hotf_5pt_reduction(G2H4(290),RedSet_5(39),mass5set(:,5),  & 
G1H4(967),G1H4(968),G1H4(969),G1H4(970),G1H4(971),G1H4(972),4)
  call HG1shiftOLR(G1H4(968),8,4)
  call Hotf_4pt_reduction(G2H4(293),RedSet_4(119),mass4set(:,2),  & 
G1H4(973),G1H4(974),G1H4(975),G1H4(976),G1H4(977),G0H4(73),4)
  call HG1shiftOLR(G1H4(974),8,4)
  call Hotf_4pt_reduction(G2H4(294),RedSet_4(108),mass4set(:,2),  & 
G1H4(978),G1H4(979),G1H4(980),G1H4(981),G1H4(982),G0H4(74),4)
  call HG1shiftOLR(G1H4(979),24,4)
  call Hotf_5pt_reduction(G2H4(295),RedSet_5(39),mass5set(:,6),  & 
G1H4(983),G1H4(984),G1H4(985),G1H4(986),G1H4(987),G1H4(988),4)
  call HG1shiftOLR(G1H4(984),8,4)
  call Hotf_4pt_reduction(G2H4(298),RedSet_4(119),mass4set(:,3),  & 
G1H4(989),G1H4(990),G1H4(991),G1H4(992),G1H4(993),G0H4(75),4)
  call HG1shiftOLR(G1H4(990),8,4)
  call Hotf_4pt_reduction(G2H4(299),RedSet_4(108),mass4set(:,3),  & 
G1H4(994),G1H4(995),G1H4(996),G1H4(997),G1H4(998),G0H4(76),4)
  call HG1shiftOLR(G1H4(995),24,4)
  call Hotf_5pt_reduction(G2H4(300),RedSet_5(39),mass5set(:,6),  & 
G1H4(999),G1H4(1000),G1H4(1001),G1H4(1002),G1H4(1003),G1H4(1004),4)
  call HG1shiftOLR(G1H4(1000),8,4)
  call Hotf_4pt_reduction(G2H4(303),RedSet_4(119),mass4set(:,3),  & 
G1H4(1005),G1H4(1006),G1H4(1007),G1H4(1008),G1H4(1009),G0H4(77),4)
  call HG1shiftOLR(G1H4(1006),8,4)
  call Hotf_4pt_reduction(G2H4(304),RedSet_4(108),mass4set(:,3),  & 
G1H4(1010),G1H4(1011),G1H4(1012),G1H4(1013),G1H4(1014),G0H4(78),4)
  call HG1shiftOLR(G1H4(1011),24,4)
  call Hotf_4pt_reduction(G2H4(308),RedSet_4(76),mass4set(:,1),  & 
G1H4(1015),G1H4(1016),G1H4(1017),G1H4(1018),G1H4(1019),G0H4(79),4)
  call HG1shiftOLR(G1H4(1016),20,4)
  call Hotf_5pt_reduction(G2H4(309),RedSet_5(44),mass5set(:,5),  & 
G1H4(1020),G1H4(1021),G1H4(1022),G1H4(1023),G1H4(1024),G1H4(1025),4)
  call HG1shiftOLR(G1H4(1021),16,4)
  call Hotf_4pt_reduction(G2H4(311),RedSet_4(10),mass4set(:,2),  & 
G1H4(1026),G1H4(1027),G1H4(1028),G1H4(1029),G1H4(1030),G0H4(80),4)
  call HG1shiftOLR(G1H4(1027),16,4)
  call Hotf_4pt_reduction(G2H4(312),RedSet_4(76),mass4set(:,2),  & 
G1H4(1031),G1H4(1032),G1H4(1033),G1H4(1034),G1H4(1035),G0H4(81),4)
  call HG1shiftOLR(G1H4(1032),20,4)
  call Hotf_4pt_reduction(G2H4(316),RedSet_4(76),mass4set(:,1),  & 
G1H4(1036),G1H4(1037),G1H4(1038),G1H4(1039),G1H4(1040),G0H4(82),4)
  call HG1shiftOLR(G1H4(1037),20,4)
  call Hotf_5pt_reduction(G2H4(317),RedSet_5(44),mass5set(:,5),  & 
G1H4(1041),G1H4(1042),G1H4(1043),G1H4(1044),G1H4(1045),G1H4(1046),4)
  call HG1shiftOLR(G1H4(1042),16,4)
  call Hotf_4pt_reduction(G2H4(319),RedSet_4(10),mass4set(:,2),  & 
G1H4(1047),G1H4(1048),G1H4(1049),G1H4(1050),G1H4(1051),G0H4(83),4)
  call HG1shiftOLR(G1H4(1048),16,4)
  call Hotf_4pt_reduction(G2H4(320),RedSet_4(76),mass4set(:,2),  & 
G1H4(1052),G1H4(1053),G1H4(1054),G1H4(1055),G1H4(1056),G0H4(84),4)
  call HG1shiftOLR(G1H4(1053),20,4)
  call Hotf_5pt_reduction(G2H4(321),RedSet_5(44),mass5set(:,6),  & 
G1H4(1057),G1H4(1058),G1H4(1059),G1H4(1060),G1H4(1061),G1H4(1062),4)
  call HG1shiftOLR(G1H4(1058),16,4)
  call Hotf_4pt_reduction(G2H4(323),RedSet_4(10),mass4set(:,3),  & 
G1H4(1063),G1H4(1064),G1H4(1065),G1H4(1066),G1H4(1067),G0H4(85),4)
  call HG1shiftOLR(G1H4(1064),16,4)
  call Hotf_4pt_reduction(G2H4(324),RedSet_4(76),mass4set(:,3),  & 
G1H4(1068),G1H4(1069),G1H4(1070),G1H4(1071),G1H4(1072),G0H4(86),4)
  call HG1shiftOLR(G1H4(1069),20,4)
  call Hotf_5pt_reduction(G2H4(325),RedSet_5(44),mass5set(:,6),  & 
G1H4(1073),G1H4(1074),G1H4(1075),G1H4(1076),G1H4(1077),G1H4(1078),4)
  call HG1shiftOLR(G1H4(1074),16,4)
  call Hotf_4pt_reduction(G2H4(327),RedSet_4(10),mass4set(:,3),  & 
G1H4(1079),G1H4(1080),G1H4(1081),G1H4(1082),G1H4(1083),G0H4(87),4)
  call HG1shiftOLR(G1H4(1080),16,4)
  call Hotf_4pt_reduction(G2H4(328),RedSet_4(76),mass4set(:,3),  & 
G1H4(1084),G1H4(1085),G1H4(1086),G1H4(1087),G1H4(1088),G0H4(88),4)
  call HG1shiftOLR(G1H4(1085),20,4)
  call Hotf_4pt_reduction(G2H4(332),RedSet_4(89),mass4set(:,1),  & 
G1H4(1089),G1H4(1090),G1H4(1091),G1H4(1092),G1H4(1093),G0H4(89),4)
  call HG1shiftOLR(G1H4(1090),24,4)
  call Hotf_5pt_reduction(G2H4(333),RedSet_5(45),mass5set(:,5),  & 
G1H4(1094),G1H4(1095),G1H4(1096),G1H4(1097),G1H4(1098),G1H4(1099),4)
  call HG1shiftOLR(G1H4(1095),8,4)
  call Hotf_4pt_reduction(G2H4(335),RedSet_4(35),mass4set(:,2),  & 
G1H4(1100),G1H4(1101),G1H4(1102),G1H4(1103),G1H4(1104),G0H4(90),4)
  call HG1shiftOLR(G1H4(1101),8,4)
  call Hotf_4pt_reduction(G2H4(336),RedSet_4(89),mass4set(:,2),  & 
G1H4(1105),G1H4(1106),G1H4(1107),G1H4(1108),G1H4(1109),G0H4(91),4)
  call HG1shiftOLR(G1H4(1106),24,4)
  call Hotf_4pt_reduction(G2H4(340),RedSet_4(89),mass4set(:,1),  & 
G1H4(1110),G1H4(1111),G1H4(1112),G1H4(1113),G1H4(1114),G0H4(92),4)
  call HG1shiftOLR(G1H4(1111),24,4)
  call Hotf_5pt_reduction(G2H4(341),RedSet_5(45),mass5set(:,5),  & 
G1H4(1115),G1H4(1116),G1H4(1117),G1H4(1118),G1H4(1119),G1H4(1120),4)
  call HG1shiftOLR(G1H4(1116),8,4)
  call Hotf_4pt_reduction(G2H4(343),RedSet_4(35),mass4set(:,2),  & 
G1H4(1121),G1H4(1122),G1H4(1123),G1H4(1124),G1H4(1125),G0H4(93),4)
  call HG1shiftOLR(G1H4(1122),8,4)
  call Hotf_4pt_reduction(G2H4(344),RedSet_4(89),mass4set(:,2),  & 
G1H4(1126),G1H4(1127),G1H4(1128),G1H4(1129),G1H4(1130),G0H4(94),4)
  call HG1shiftOLR(G1H4(1127),24,4)
  call Hotf_5pt_reduction(G2H4(345),RedSet_5(45),mass5set(:,6),  & 
G1H4(1131),G1H4(1132),G1H4(1133),G1H4(1134),G1H4(1135),G1H4(1136),4)
  call HG1shiftOLR(G1H4(1132),8,4)
  call Hotf_4pt_reduction(G2H4(347),RedSet_4(35),mass4set(:,3),  & 
G1H4(1137),G1H4(1138),G1H4(1139),G1H4(1140),G1H4(1141),G0H4(95),4)
  call HG1shiftOLR(G1H4(1138),8,4)
  call Hotf_4pt_reduction(G2H4(348),RedSet_4(89),mass4set(:,3),  & 
G1H4(1142),G1H4(1143),G1H4(1144),G1H4(1145),G1H4(1146),G0H4(96),4)
  call HG1shiftOLR(G1H4(1143),24,4)
  call Hotf_5pt_reduction(G2H4(349),RedSet_5(45),mass5set(:,6),  & 
G1H4(1147),G1H4(1148),G1H4(1149),G1H4(1150),G1H4(1151),G1H4(1152),4)
  call HG1shiftOLR(G1H4(1148),8,4)
  call Hotf_4pt_reduction(G2H4(351),RedSet_4(35),mass4set(:,3),  & 
G1H4(1153),G1H4(1154),G1H4(1155),G1H4(1156),G1H4(1157),G0H4(97),4)
  call HG1shiftOLR(G1H4(1154),8,4)
  call Hotf_4pt_reduction(G2H4(352),RedSet_4(89),mass4set(:,3),  & 
G1H4(1158),G1H4(1159),G1H4(1160),G1H4(1161),G1H4(1162),G0H4(98),4)
  call HG1shiftOLR(G1H4(1159),24,4)
  call Hotf_4pt_reduction(G2H4(356),RedSet_4(89),mass4set(:,1),  & 
G1H4(1163),G1H4(1164),G1H4(1165),G1H4(1166),G1H4(1167),G0H4(99),4)
  call HG1shiftOLR(G1H4(1164),24,4)
  call Hotf_5pt_reduction(G2H4(357),RedSet_5(46),mass5set(:,5),  & 
G1H4(1168),G1H4(1169),G1H4(1170),G1H4(1171),G1H4(1172),G1H4(1173),4)
  call HG1shiftOLR(G1H4(1169),16,4)
  call Hotf_4pt_reduction(G2H4(359),RedSet_4(20),mass4set(:,2),  & 
G1H4(1174),G1H4(1175),G1H4(1176),G1H4(1177),G1H4(1178),G0H4(100),4)
  call HG1shiftOLR(G1H4(1175),16,4)
  call Hotf_4pt_reduction(G2H4(360),RedSet_4(89),mass4set(:,2),  & 
G1H4(1179),G1H4(1180),G1H4(1181),G1H4(1182),G1H4(1183),G0H4(101),4)
  call HG1shiftOLR(G1H4(1180),24,4)
  call Hotf_4pt_reduction(G2H4(364),RedSet_4(89),mass4set(:,1),  & 
G1H4(1184),G1H4(1185),G1H4(1186),G1H4(1187),G1H4(1188),G0H4(102),4)
  call HG1shiftOLR(G1H4(1185),24,4)
  call Hotf_5pt_reduction(G2H4(365),RedSet_5(46),mass5set(:,5),  & 
G1H4(1189),G1H4(1190),G1H4(1191),G1H4(1192),G1H4(1193),G1H4(1194),4)
  call HG1shiftOLR(G1H4(1190),16,4)
  call Hotf_4pt_reduction(G2H4(367),RedSet_4(20),mass4set(:,2),  & 
G1H4(1195),G1H4(1196),G1H4(1197),G1H4(1198),G1H4(1199),G0H4(103),4)
  call HG1shiftOLR(G1H4(1196),16,4)
  call Hotf_4pt_reduction(G2H4(368),RedSet_4(89),mass4set(:,2),  & 
G1H4(1200),G1H4(1201),G1H4(1202),G1H4(1203),G1H4(1204),G0H4(104),4)
  call HG1shiftOLR(G1H4(1201),24,4)
  call Hotf_5pt_reduction(G2H4(369),RedSet_5(46),mass5set(:,6),  & 
G1H4(1205),G1H4(1206),G1H4(1207),G1H4(1208),G1H4(1209),G1H4(1210),4)
  call HG1shiftOLR(G1H4(1206),16,4)
  call Hotf_4pt_reduction(G2H4(371),RedSet_4(20),mass4set(:,3),  & 
G1H4(1211),G1H4(1212),G1H4(1213),G1H4(1214),G1H4(1215),G0H4(105),4)
  call HG1shiftOLR(G1H4(1212),16,4)
  call Hotf_4pt_reduction(G2H4(372),RedSet_4(89),mass4set(:,3),  & 
G1H4(1216),G1H4(1217),G1H4(1218),G1H4(1219),G1H4(1220),G0H4(106),4)
  call HG1shiftOLR(G1H4(1217),24,4)
  call Hotf_5pt_reduction(G2H4(373),RedSet_5(46),mass5set(:,6),  & 
G1H4(1221),G1H4(1222),G1H4(1223),G1H4(1224),G1H4(1225),G1H4(1226),4)
  call HG1shiftOLR(G1H4(1222),16,4)
  call Hotf_4pt_reduction(G2H4(375),RedSet_4(20),mass4set(:,3),  & 
G1H4(1227),G1H4(1228),G1H4(1229),G1H4(1230),G1H4(1231),G0H4(107),4)
  call HG1shiftOLR(G1H4(1228),16,4)
  call Hotf_4pt_reduction(G2H4(376),RedSet_4(89),mass4set(:,3),  & 
G1H4(1232),G1H4(1233),G1H4(1234),G1H4(1235),G1H4(1236),G0H4(108),4)
  call HG1shiftOLR(G1H4(1233),24,4)
  call Hloop_QA_V(ntryL,G2H8(115),ex2(:),G2H4(2),m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_QA_V(ntryL,G2H8(117),ex2(:),G2H4(5),m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_QA_V(ntryL,G2H8(118),ex2(:),G2H4(8),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_AQ_V(ntryL,G2H8(119),ex1(:),G2H4(11),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_AQ_V(ntryL,G2H8(121),ex1(:),G2H4(14),m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_AQ_V(ntryL,G2H8(122),ex1(:),G2H4(17),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_QA_V(ntryL,G2H8(123),ex2(:),G2H4(21),m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_QA_V(ntryL,G2H8(125),ex2(:),G2H4(25),m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_QA_V(ntryL,G2H8(126),ex2(:),G2H4(51),m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_QA_V(ntryL,G2H8(127),ex2(:),G2H4(29),m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_QA_V(ntryL,G2H8(129),ex2(:),G2H4(33),m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_QA_V(ntryL,G2H8(130),ex2(:),G2H4(7),m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_AQ_V(ntryL,G2H8(131),ex1(:),G2H4(37),m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_AQ_V(ntryL,G2H8(133),ex1(:),G2H4(41),m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_AQ_V(ntryL,G2H8(134),ex1(:),G2H4(45),m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_AQ_V(ntryL,G2H8(135),ex1(:),G2H4(49),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_AQ_V(ntryL,G2H8(137),ex1(:),G2H4(23),m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_AQ_V(ntryL,G2H8(138),ex1(:),G2H4(53),m3h2x4(:,352),heltab2x8(:,:,352))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1036),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1184),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1110),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1015),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1163),[G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(189),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1089),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(576),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(581),[G1H4(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(586),[G1H4(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(591),[G1H4(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(213),[G1H4(476)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(596),[G1H4(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(225),[G1H4(491)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(601),[G1H4(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(506)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(606),[G1H4(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(249),[G1H4(521)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(611),[G1H4(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(261),[G1H4(536)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(616),[G1H4(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(273),[G1H4(551)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(621),[G1H4(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(285),[G1H4(566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(626),[G1H4(567)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(637),[G1H4(635)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(642),[G1H4(636)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(653),[G1H4(651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(658),[G1H4(652)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(669),[G1H4(667)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(674),[G1H4(668)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(685),[G1H4(683)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(690),[G1H4(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(701),[G1H4(699)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(706),[G1H4(700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(717),[G1H4(715)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(722),[G1H4(716)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(733),[G1H4(731)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(738),[G1H4(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(749),[G1H4(747)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(754),[G1H4(748)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(765),[G1H4(763)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(770),[G1H4(764)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(781),[G1H4(779)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(786),[G1H4(780)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(797),[G1H4(795)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(802),[G1H4(796)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(813),[G1H4(811)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(818),[G1H4(812)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(182),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(196),[G1H8(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(202),[G1H8(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(205),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(211),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(829),[G1H4(827)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(834),[G1H4(828)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(845),[G1H4(843)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(850),[G1H4(844)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(861),[G1H4(859)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(866),[G1H4(860)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(877),[G1H4(875)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(882),[G1H4(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(224),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(93),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(234),[G1H8(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(240),[G1H8(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(113),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(261),[G1H8(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(266),[G1H8(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(893),[G1H4(891)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(898),[G1H4(892)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(909),[G1H4(907)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(914),[G1H4(908)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(925),[G1H4(923)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(930),[G1H4(924)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(941),[G1H4(939)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(946),[G1H4(940)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(277),[G1H8(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(282),[G1H8(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(293),[G1H8(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(298),[G1H8(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(309),[G1H8(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(314),[G1H8(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(325),[G1H8(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(330),[G1H8(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(341),[G1H8(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(346),[G1H8(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(357),[G1H8(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(362),[G1H8(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(957),[G1H4(955)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(962),[G1H4(956)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(973),[G1H4(971)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(978),[G1H4(972)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(989),[G1H4(987)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(994),[G1H4(988)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1005),[G1H4(1003)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1010),[G1H4(1004)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1026),[G1H4(1024)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1031),[G1H4(1025)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1047),[G1H4(1045)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1052),[G1H4(1046)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1063),[G1H4(1061)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1068),[G1H4(1062)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1079),[G1H4(1077)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1084),[G1H4(1078)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1100),[G1H4(1098)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1105),[G1H4(1099)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1121),[G1H4(1119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1126),[G1H4(1120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1137),[G1H4(1135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1142),[G1H4(1136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1153),[G1H4(1151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1158),[G1H4(1152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1174),[G1H4(1172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1179),[G1H4(1173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1195),[G1H4(1193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1200),[G1H4(1194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1211),[G1H4(1209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1216),[G1H4(1210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1227),[G1H4(1225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1232),[G1H4(1226)])
  call Hloop_VA_Q(ntryL,G1H4(260),ex2(:),G1H2(13),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(167),n2h2(125))
call HGT_OLR(G1H4(264),1,1,4)
call HGT_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(264),-16,nME,G2H4(58),n2h4(379))
  call Hloop_QV_A(ntryL,G2H4(58),ex5(:),G2H2(168),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_VA_Q(ntryL,G1H4(271),ex2(:),G1H2(14),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(169),n2h2(126))
  call Hloop_VA_Q(ntryL,G1H4(272),ex2(:),G1H2(19),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(19),47,nME,G2H2(170),n2h2(127))
  call Hloop_VA_Q(ntryL,G1H4(276),ex2(:),G1H2(20),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(20),47,nME,G2H2(171),n2h2(128))
call HGT_OLR(G1H4(277),1,1,4)
call HGT_invQ_OLR(G1H4(277),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(277),-16,nME,G2H4(57),n2h4(380))
  call Hloop_QV_A(ntryL,G2H4(57),ex5(:),G2H2(172),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_VA_Q(ntryL,G1H4(284),ex2(:),G1H2(25),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(25),47,nME,G2H2(173),n2h2(129))
  call Hloop_VA_Q(ntryL,G1H4(288),ex2(:),G1H2(26),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(26),47,nME,G2H2(174),n2h2(130))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(31),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(31),55,nME,G2H2(175),n2h2(131))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-8,nME,G2H4(61),n2h4(381))
  call Hloop_AV_Q(ntryL,G2H4(61),ex4(:),G2H2(176),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(32),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(32),55,nME,G2H2(177),n2h2(132))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(37),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(37),55,nME,G2H2(178),n2h2(133))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(38),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(38),47,nME,G2H2(179),n2h2(134))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(90),-16,nME,G2H4(31),n2h4(382))
  call Hloop_AV_Q(ntryL,G2H4(31),ex5(:),G2H2(180),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_VQ_A(ntryL,G1H4(126),ex1(:),G1H2(43),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(43),47,nME,G2H2(181),n2h2(135))
  call Hloop_VQ_A(ntryL,G1H4(138),ex1(:),G1H2(44),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(44),47,nME,G2H2(182),n2h2(136))
  call Hloop_VQ_A(ntryL,G1H4(150),ex1(:),G1H2(49),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(183),n2h2(137))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(162),-16,nME,G2H4(65),n2h4(383))
  call Hloop_AV_Q(ntryL,G2H4(65),ex5(:),G2H2(184),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_VQ_A(ntryL,G1H4(198),ex1(:),G1H2(50),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(185),n2h2(138))
  call Hloop_VQ_A(ntryL,G1H4(210),ex1(:),G1H2(55),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(55),47,nME,G2H2(186),n2h2(139))
  call Hloop_VA_Q(ntryL,G1H4(222),ex2(:),G1H2(56),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(56),55,nME,G2H2(187),n2h2(140))
call HGT_OLR(G1H4(234),1,1,4)
call HGT_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(234),-8,nME,G2H4(69),n2h4(384))
  call Hloop_QV_A(ntryL,G2H4(69),ex4(:),G2H2(188),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_VA_Q(ntryL,G1H4(270),ex2(:),G1H2(61),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(61),55,nME,G2H2(189),n2h2(141))
  call Hloop_VA_Q(ntryL,G1H4(282),ex2(:),G1H2(62),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(62),55,nME,G2H2(190),n2h2(142))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(67),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(67),59,nME,G2H2(191),n2h2(143))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-4,nME,G2H4(19),n2h4(385))
  call Hloop_AV_Q(ntryL,G2H4(19),ex3(:),G2H2(192),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_VQ_A(ntryL,G1H4(12),ex1(:),G1H2(68),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(68),59,nME,G2H2(193),n2h2(144))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(73),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(73),59,nME,G2H2(194),n2h2(145))
  call Hloop_QV_A(ntryL,G1H4(14),ex3(:),G1H2(74),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(74),47,nME,G2H2(195),n2h2(146))
call HGT_OLR(G1H4(19),1,1,4)
call HGT_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(19),-16,nME,G2H4(73),n2h4(386))
  call Hloop_AV_Q(ntryL,G2H4(73),ex5(:),G2H2(196),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_QV_A(ntryL,G1H4(81),ex3(:),G1H2(79),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(79),47,nME,G2H2(197),n2h2(147))
  call Hloop_QV_A(ntryL,G1H4(1036),ex3(:),G1H2(80),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_Q_A(ntryL,G1H2(80),47,nME,G2H2(198),n2h2(148))
  call Hloop_VA_Q(ntryL,G1H4(31),ex2(:),G1H2(85),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(85),55,nME,G2H2(199),n2h2(149))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-8,nME,G2H4(77),n2h4(387))
  call Hloop_QV_A(ntryL,G2H4(77),ex4(:),G2H2(200),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(86),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(86),55,nME,G2H2(201),n2h2(150))
  call Hloop_VA_Q(ntryL,G1H4(43),ex2(:),G1H2(91),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(91),55,nME,G2H2(202),n2h2(151))
  call Hloop_AV_Q(ntryL,G1H4(44),ex4(:),G1H2(92),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(203),n2h2(152))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-16,nME,G2H4(10),n2h4(388))
  call Hloop_QV_A(ntryL,G2H4(10),ex5(:),G2H2(204),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(97),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(97),47,nME,G2H2(205),n2h2(153))
  call Hloop_AV_Q(ntryL,G1H4(1184),ex4(:),G1H2(98),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(98),47,nME,G2H2(206),n2h2(154))
  call Hloop_VA_Q(ntryL,G1H4(60),ex2(:),G1H2(103),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(103),47,nME,G2H2(207),n2h2(155))
call HGT_OLR(G1H4(61),1,1,4)
call HGT_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(61),-16,nME,G2H4(81),n2h4(389))
  call Hloop_QV_A(ntryL,G2H4(81),ex5(:),G2H2(208),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_VA_Q(ntryL,G1H4(68),ex2(:),G1H2(104),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(104),47,nME,G2H2(209),n2h2(156))
  call Hloop_VA_Q(ntryL,G1H4(72),ex2(:),G1H2(109),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(109),47,nME,G2H2(210),n2h2(157))
  call Hloop_AV_Q(ntryL,G1H4(73),ex5(:),G1H2(110),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(110),55,nME,G2H2(211),n2h2(158))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-8,nME,G2H4(85),n2h4(390))
  call Hloop_QV_A(ntryL,G2H4(85),ex4(:),G2H2(212),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_AV_Q(ntryL,G1H4(105),ex5(:),G1H2(115),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(115),55,nME,G2H2(213),n2h2(159))
  call Hloop_AV_Q(ntryL,G1H4(1110),ex5(:),G1H2(116),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_A_Q(ntryL,G1H2(116),55,nME,G2H2(214),n2h2(160))
  call Hloop_QV_A(ntryL,G1H4(86),ex3(:),G1H2(121),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(121),55,nME,G2H2(215),n2h2(161))
call HGT_OLR(G1H4(91),1,1,4)
call HGT_invQ_OLR(G1H4(91),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(91),-8,nME,G2H4(13),n2h4(391))
  call Hloop_AV_Q(ntryL,G2H4(13),ex4(:),G2H2(216),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_QV_A(ntryL,G1H4(97),ex3(:),G1H2(122),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(122),55,nME,G2H2(217),n2h2(162))
  call Hloop_QV_A(ntryL,G1H4(98),ex3(:),G1H2(127),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(127),55,nME,G2H2(218),n2h2(163))
  call Hloop_QV_A(ntryL,G1H4(103),ex4(:),G1H2(128),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(128),47,nME,G2H2(219),n2h2(164))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(104),-16,nME,G2H4(89),n2h4(392))
  call Hloop_AV_Q(ntryL,G2H4(89),ex5(:),G2H2(220),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_QV_A(ntryL,G1H4(110),ex4(:),G1H2(133),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(133),47,nME,G2H2(221),n2h2(165))
  call Hloop_QV_A(ntryL,G1H4(115),ex4(:),G1H2(134),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(134),47,nME,G2H2(222),n2h2(166))
  call Hloop_QV_A(ntryL,G1H4(116),ex3(:),G1H2(139),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(139),47,nME,G2H2(223),n2h2(167))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(120),-16,nME,G2H4(63),n2h4(393))
  call Hloop_AV_Q(ntryL,G2H4(63),ex5(:),G2H2(224),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_QV_A(ntryL,G1H4(127),ex3(:),G1H2(140),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(140),47,nME,G2H2(225),n2h2(168))
  call Hloop_QV_A(ntryL,G1H4(128),ex3(:),G1H2(1),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(226),n2h2(169))
  call Hloop_QV_A(ntryL,G1H4(132),ex5(:),G1H2(2),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(2),55,nME,G2H2(227),n2h2(170))
call HGT_OLR(G1H4(133),1,1,4)
call HGT_invQ_OLR(G1H4(133),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(133),-8,nME,G2H4(75),n2h4(394))
  call Hloop_AV_Q(ntryL,G2H4(75),ex4(:),G2H2(228),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_QV_A(ntryL,G1H4(140),ex5(:),G1H2(7),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(7),55,nME,G2H2(229),n2h2(171))
  call Hloop_QV_A(ntryL,G1H4(144),ex5(:),G1H2(8),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(8),55,nME,G2H2(230),n2h2(172))
  call Hloop_VA_Q(ntryL,G1H4(145),ex2(:),G1H2(13),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(13),59,nME,G2H2(231),n2h2(173))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-4,nME,G2H4(92),n2h4(395))
  call Hloop_QV_A(ntryL,G2H4(92),ex3(:),G2H2(232),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_VA_Q(ntryL,G1H4(156),ex2(:),G1H2(14),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(14),59,nME,G2H2(233),n2h2(174))
  call Hloop_VA_Q(ntryL,G1H4(157),ex2(:),G1H2(19),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(19),59,nME,G2H2(234),n2h2(175))
  call Hloop_AV_Q(ntryL,G1H4(158),ex3(:),G1H2(20),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(20),47,nME,G2H2(235),n2h2(176))
call HGT_OLR(G1H4(163),1,1,4)
call HGT_invQ_OLR(G1H4(163),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(163),-16,nME,G2H4(70),n2h4(396))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(236),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(25),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_A_Q(ntryL,G1H2(25),47,nME,G2H2(237),n2h2(177))
  call Hloop_AV_Q(ntryL,G1H4(1015),ex3(:),G1H2(26),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(26),47,nME,G2H2(238),n2h2(178))
  call Hloop_VQ_A(ntryL,G1H4(175),ex1(:),G1H2(31),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(31),55,nME,G2H2(239),n2h2(179))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-8,nME,G2H4(82),n2h4(397))
  call Hloop_AV_Q(ntryL,G2H4(82),ex4(:),G2H2(240),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_VQ_A(ntryL,G1H4(182),ex1(:),G1H2(32),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(32),55,nME,G2H2(241),n2h2(180))
  call Hloop_VQ_A(ntryL,G1H4(187),ex1(:),G1H2(37),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(37),55,nME,G2H2(242),n2h2(181))
  call Hloop_QV_A(ntryL,G1H4(188),ex4(:),G1H2(38),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(38),47,nME,G2H2(243),n2h2(182))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(192),-16,nME,G2H4(87),n2h4(398))
  call Hloop_AV_Q(ntryL,G2H4(87),ex5(:),G2H2(244),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(43),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(43),47,nME,G2H2(245),n2h2(183))
  call Hloop_QV_A(ntryL,G1H4(1163),ex4(:),G1H2(44),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(44),47,nME,G2H2(246),n2h2(184))
  call Hloop_QV_A(ntryL,G1H4(204),ex4(:),G1H2(49),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(49),59,nME,G2H2(247),n2h2(185))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(205),-4,nME,G2H4(20),n2h4(399))
  call Hloop_AV_Q(ntryL,G2H4(20),ex3(:),G2H2(248),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_QV_A(ntryL,G1H4(212),ex4(:),G1H2(50),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(50),59,nME,G2H2(249),n2h2(186))
  call Hloop_QV_A(ntryL,G1H4(216),ex4(:),G1H2(55),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(55),59,nME,G2H2(250),n2h2(187))
  call Hloop_QV_A(ntryL,G1H4(217),ex3(:),G1H2(56),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(56),47,nME,G2H2(251),n2h2(188))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-16,nME,G2H4(313),n2h4(400))
  call Hloop_AV_Q(ntryL,G2H4(313),ex5(:),G2H2(252),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_QV_A(ntryL,G1H4(228),ex3(:),G1H2(61),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(61),47,nME,G2H2(253),n2h2(189))
  call Hloop_QV_A(ntryL,G1H4(229),ex3(:),G1H2(62),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(62),47,nME,G2H2(254),n2h2(190))
  call Hloop_QV_A(ntryL,G1H4(230),ex4(:),G1H2(67),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(67),47,nME,G2H2(255),n2h2(191))
call HGT_OLR(G1H4(235),1,1,4)
call HGT_invQ_OLR(G1H4(235),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(235),-16,nME,G2H4(24),n2h4(401))
  call Hloop_AV_Q(ntryL,G2H4(24),ex5(:),G2H2(256),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_QV_A(ntryL,G1H4(241),ex4(:),G1H2(68),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(68),47,nME,G2H2(257),n2h2(192))
  call Hloop_QV_A(ntryL,G1H4(242),ex4(:),G1H2(73),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(73),47,nME,G2H2(258),n2h2(193))
  call Hloop_QV_A(ntryL,G1H4(247),ex5(:),G1H2(74),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(74),59,nME,G2H2(259),n2h2(194))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(248),-4,nME,G2H4(361),n2h4(402))
  call Hloop_AV_Q(ntryL,G2H4(361),ex3(:),G2H2(260),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_QV_A(ntryL,G1H4(254),ex5(:),G1H2(79),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(79),59,nME,G2H2(261),n2h2(195))
  call Hloop_QV_A(ntryL,G1H4(259),ex5(:),G1H2(80),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(80),59,nME,G2H2(262),n2h2(196))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(85),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(85),47,nME,G2H2(263),n2h2(197))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(17),-16,nME,G2H4(28),n2h4(403))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(264),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_VQ_A(ntryL,G1H4(53),ex1(:),G1H2(86),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(86),47,nME,G2H2(265),n2h2(198))
  call Hloop_VQ_A(ntryL,G1H4(65),ex1(:),G1H2(91),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_Q_A(ntryL,G1H2(91),47,nME,G2H2(266),n2h2(199))
  call Hloop_QV_A(ntryL,G1H4(77),ex5(:),G1H2(92),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(92),55,nME,G2H2(267),n2h2(200))
call HGT_OLR(G1H4(89),1,1,4)
call HGT_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(89),-8,nME,G2H4(337),n2h4(404))
  call Hloop_AV_Q(ntryL,G2H4(337),ex4(:),G2H2(268),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_QV_A(ntryL,G1H4(189),ex5(:),G1H2(97),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(97),55,nME,G2H2(269),n2h2(201))
  call Hloop_QV_A(ntryL,G1H4(1089),ex5(:),G1H2(98),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(98),55,nME,G2H2(270),n2h2(202))
  call Hloop_QV_A(ntryL,G1H4(125),ex5(:),G1H2(103),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(103),59,nME,G2H2(271),n2h2(203))
call HGT_OLR(G1H4(137),1,1,4)
call HGT_invQ_OLR(G1H4(137),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(137),-4,nME,G2H4(32),n2h4(405))
  call Hloop_AV_Q(ntryL,G2H4(32),ex3(:),G2H2(272),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_QV_A(ntryL,G1H4(147),ex5(:),G1H2(104),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(104),59,nME,G2H2(273),n2h2(204))
  call Hloop_QV_A(ntryL,G1H4(173),ex5(:),G1H2(109),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(109),59,nME,G2H2(274),n2h2(205))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(110),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(110),55,nME,G2H2(275),n2h2(206))
call HGT_OLR(G1H4(185),1,1,4)
call HGT_invQ_OLR(G1H4(185),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(185),-8,nME,G2H4(67),n2h4(406))
  call Hloop_AV_Q(ntryL,G2H4(67),ex4(:),G2H2(276),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_QV_A(ntryL,G1H4(209),ex3(:),G1H2(115),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(115),55,nME,G2H2(277),n2h2(207))
  call Hloop_QV_A(ntryL,G1H4(221),ex3(:),G1H2(116),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_Q_A(ntryL,G1H2(116),55,nME,G2H2(278),n2h2(208))
  call Hloop_QV_A(ntryL,G1H4(135),ex5(:),G1H2(121),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(121),55,nME,G2H2(279),n2h2(209))
call HGT_OLR(G1H4(233),1,1,4)
call HGT_invQ_OLR(G1H4(233),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(233),-8,nME,G2H4(36),n2h4(407))
  call Hloop_AV_Q(ntryL,G2H4(36),ex4(:),G2H2(280),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_QV_A(ntryL,G1H4(257),ex5(:),G1H2(122),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(122),55,nME,G2H2(281),n2h2(210))
  call Hloop_QV_A(ntryL,G1H4(269),ex5(:),G1H2(127),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_Q_A(ntryL,G1H2(127),55,nME,G2H2(282),n2h2(211))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(128),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(128),59,nME,G2H2(283),n2h2(212))
call HGT_OLR(G1H4(281),1,1,4)
call HGT_invQ_OLR(G1H4(281),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(281),-4,nME,G2H4(66),n2h4(408))
  call Hloop_AV_Q(ntryL,G2H4(66),ex3(:),G2H2(284),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_QV_A(ntryL,G1H4(10),ex4(:),G1H2(133),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(133),59,nME,G2H2(285),n2h2(213))
  call Hloop_QV_A(ntryL,G1H4(15),ex4(:),G1H2(134),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_Q_A(ntryL,G1H2(134),59,nME,G2H2(286),n2h2(214))
  call Hloop_AV_Q(ntryL,G1H4(27),ex3(:),G1H2(139),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G1H2(139),55,nME,G2H2(287),n2h2(215))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-8,nME,G2H4(40),n2h4(409))
  call Hloop_QV_A(ntryL,G2H4(40),ex4(:),G2H2(288),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_AV_Q(ntryL,G1H4(46),ex3(:),G1H2(140),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(140),55,nME,G2H2(289),n2h2(216))
  call Hloop_AV_Q(ntryL,G1H4(51),ex3(:),G1H2(1),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(290),n2h2(217))
  call Hloop_AV_Q(ntryL,G1H4(63),ex4(:),G1H2(2),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(291),n2h2(218))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(64),-16,nME,G2H4(305),n2h4(410))
  call Hloop_QV_A(ntryL,G2H4(305),ex5(:),G2H2(292),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_AV_Q(ntryL,G1H4(88),ex4(:),G1H2(7),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(7),47,nME,G2H2(293),n2h2(219))
  call Hloop_AV_Q(ntryL,G1H4(95),ex4(:),G1H2(8),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(294),n2h2(220))
  call Hloop_AV_Q(ntryL,G1H4(100),ex3(:),G1H2(13),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(295),n2h2(221))
call HGT_OLR(G1H4(107),1,1,4)
call HGT_invQ_OLR(G1H4(107),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(107),-16,nME,G2H4(44),n2h4(411))
  call Hloop_QV_A(ntryL,G2H4(44),ex5(:),G2H2(296),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_AV_Q(ntryL,G1H4(118),ex3(:),G1H2(14),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(297),n2h2(222))
  call Hloop_AV_Q(ntryL,G1H4(123),ex3(:),G1H2(19),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(19),47,nME,G2H2(298),n2h2(223))
  call Hloop_AV_Q(ntryL,G1H4(124),ex5(:),G1H2(20),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_A_Q(ntryL,G1H2(20),55,nME,G2H2(299),n2h2(224))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(130),-8,nME,G2H4(353),n2h4(412))
  call Hloop_QV_A(ntryL,G2H4(353),ex4(:),G2H2(300),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_AV_Q(ntryL,G1H4(148),ex5(:),G1H2(25),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_A_Q(ntryL,G1H2(25),55,nME,G2H2(301),n2h2(225))
  call Hloop_AV_Q(ntryL,G1H4(155),ex5(:),G1H2(26),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(26),55,nME,G2H2(302),n2h2(226))
  call Hloop_AV_Q(ntryL,G1H4(159),ex4(:),G1H2(31),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(31),59,nME,G2H2(303),n2h2(227))
call HGT_OLR(G1H4(160),1,1,4)
call HGT_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(160),-4,nME,G2H4(48),n2h4(413))
  call Hloop_QV_A(ntryL,G2H4(48),ex3(:),G2H2(304),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_AV_Q(ntryL,G1H4(172),ex4(:),G1H2(32),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(32),59,nME,G2H2(305),n2h2(228))
  call Hloop_AV_Q(ntryL,G1H4(178),ex4(:),G1H2(37),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G1H2(37),59,nME,G2H2(306),n2h2(229))
  call Hloop_AV_Q(ntryL,G1H4(184),ex3(:),G1H2(38),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_A_Q(ntryL,G1H2(38),47,nME,G2H2(307),n2h2(230))
call HGT_OLR(G1H4(191),1,1,4)
call HGT_invQ_OLR(G1H4(191),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(191),-16,nME,G2H4(79),n2h4(414))
  call Hloop_QV_A(ntryL,G2H4(79),ex5(:),G2H2(308),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_AV_Q(ntryL,G1H4(202),ex3(:),G1H2(43),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G1H2(43),47,nME,G2H2(309),n2h2(231))
  call Hloop_AV_Q(ntryL,G1H4(207),ex3(:),G1H2(44),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_A_Q(ntryL,G1H2(44),47,nME,G2H2(310),n2h2(232))
  call Hloop_AV_Q(ntryL,G1H4(208),ex4(:),G1H2(49),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(311),n2h2(233))
call HGT_OLR(G1H4(214),1,1,4)
call HGT_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(214),-16,nME,G2H4(52),n2h4(415))
  call Hloop_QV_A(ntryL,G2H4(52),ex5(:),G2H2(312),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_AV_Q(ntryL,G1H4(226),ex4(:),G1H2(50),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(50),47,nME,G2H2(313),n2h2(234))
  call Hloop_AV_Q(ntryL,G1H4(231),ex4(:),G1H2(55),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(55),47,nME,G2H2(314),n2h2(235))
  call Hloop_AV_Q(ntryL,G1H4(232),ex5(:),G1H2(56),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_A_Q(ntryL,G1H2(56),59,nME,G2H2(315),n2h2(236))
call HGT_OLR(G1H4(238),1,1,4)
call HGT_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(238),-4,nME,G2H4(78),n2h4(416))
  call Hloop_QV_A(ntryL,G2H4(78),ex3(:),G2H2(316),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_AV_Q(ntryL,G1H4(250),ex5(:),G1H2(61),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_A_Q(ntryL,G1H2(61),59,nME,G2H2(317),n2h2(237))
  call Hloop_AV_Q(ntryL,G1H4(255),ex5(:),G1H2(62),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_A_Q(ntryL,G1H2(62),59,nME,G2H2(318),n2h2(238))
  call Hloop_AV_Q(ntryL,G1H4(256),ex5(:),G1H2(67),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(67),59,nME,G2H2(319),n2h2(239))
call HGT_OLR(G1H4(262),1,1,4)
call HGT_invQ_OLR(G1H4(262),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(262),-4,nME,G2H4(56),n2h4(417))
  call Hloop_QV_A(ntryL,G2H4(56),ex3(:),G2H2(320),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_AV_Q(ntryL,G1H4(274),ex5(:),G1H2(68),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_A_Q(ntryL,G1H2(68),59,nME,G2H2(321),n2h2(240))
  call Hloop_AV_Q(ntryL,G1H4(279),ex5(:),G1H2(73),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_A_Q(ntryL,G1H2(73),59,nME,G2H2(322),n2h2(241))
  call Hloop_AV_Q(ntryL,G1H4(280),ex3(:),G1H2(74),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(74),55,nME,G2H2(323),n2h2(242))
call HGT_OLR(G1H4(286),1,1,4)
call HGT_invQ_OLR(G1H4(286),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(286),-8,nME,G2H4(329),n2h4(418))
  call Hloop_QV_A(ntryL,G2H4(329),ex4(:),G2H2(324),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_AV_Q(ntryL,G1H4(291),ex3(:),G1H2(79),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(79),55,nME,G2H2(325),n2h2(243))
  call Hloop_AV_Q(ntryL,G1H4(292),ex3(:),G1H2(80),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(80),55,nME,G2H2(326),n2h2(244))
  call Hloop_AV_Q(ntryL,G1H4(293),ex5(:),G1H2(85),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_A_Q(ntryL,G1H2(85),55,nME,G2H2(327),n2h2(245))
call HGT_OLR(G1H4(294),1,1,4)
call HGT_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(294),-8,nME,G2H4(60),n2h4(419))
  call Hloop_QV_A(ntryL,G2H4(60),ex4(:),G2H2(328),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_AV_Q(ntryL,G1H4(297),ex5(:),G1H2(86),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G1H2(86),55,nME,G2H2(329),n2h2(246))
  call Hloop_AV_Q(ntryL,G1H4(298),ex5(:),G1H2(91),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(91),55,nME,G2H2(330),n2h2(247))
  call Hloop_AV_Q(ntryL,G1H4(299),ex4(:),G1H2(92),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(92),59,nME,G2H2(331),n2h2(248))
call HGT_OLR(G1H4(300),1,1,4)
call HGT_invQ_OLR(G1H4(300),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(300),-4,nME,G2H4(91),n2h4(420))
  call Hloop_QV_A(ntryL,G2H4(91),ex3(:),G2H2(332),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_AV_Q(ntryL,G1H4(303),ex4(:),G1H2(97),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(97),59,nME,G2H2(333),n2h2(249))
  call Hloop_AV_Q(ntryL,G1H4(304),ex4(:),G1H2(98),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(98),59,nME,G2H2(334),n2h2(250))
  call Hloop_VA_Q(ntryL,G1H4(305),ex2(:),G1H2(103),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_A_Q(ntryL,G1H2(103),47,nME,G2H2(335),n2h2(251))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(306),-16,nME,G2H4(64),n2h4(421))
  call Hloop_QV_A(ntryL,G2H4(64),ex5(:),G2H2(336),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_VA_Q(ntryL,G1H4(309),ex2(:),G1H2(104),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_A_Q(ntryL,G1H2(104),47,nME,G2H2(337),n2h2(252))
  call Hloop_VA_Q(ntryL,G1H4(310),ex2(:),G1H2(109),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(109),47,nME,G2H2(338),n2h2(253))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(110),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(110),47,nME,G2H2(339),n2h2(254))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-16,nME,G2H4(90),n2h4(422))
  call Hloop_QV_A(ntryL,G2H4(90),ex5(:),G2H2(340),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_VA_Q(ntryL,G1H4(312),ex2(:),G1H2(115),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(115),47,nME,G2H2(341),n2h2(255))
  call Hloop_VA_Q(ntryL,G1H4(313),ex2(:),G1H2(116),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(116),47,nME,G2H2(342),n2h2(256))
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(121),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(121),55,nME,G2H2(343),n2h2(257))
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(23),-8,nME,G2H4(68),n2h4(423))
  call Hloop_AV_Q(ntryL,G2H4(68),ex4(:),G2H2(344),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_VQ_A(ntryL,G1H4(316),ex1(:),G1H2(122),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(122),55,nME,G2H2(345),n2h2(258))
  call Hloop_VQ_A(ntryL,G1H4(317),ex1(:),G1H2(127),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_Q_A(ntryL,G1H2(127),55,nME,G2H2(346),n2h2(259))
  call Hloop_VQ_A(ntryL,G1H4(318),ex1(:),G1H2(128),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(128),55,nME,G2H2(347),n2h2(260))
call HGT_OLR(G1H4(319),1,1,4)
call HGT_invQ_OLR(G1H4(319),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(319),-8,nME,G2H4(74),n2h4(424))
  call Hloop_AV_Q(ntryL,G2H4(74),ex4(:),G2H2(348),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_VQ_A(ntryL,G1H4(322),ex1(:),G1H2(133),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_Q_A(ntryL,G1H2(133),55,nME,G2H2(349),n2h2(261))
  call Hloop_VQ_A(ntryL,G1H4(323),ex1(:),G1H2(134),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_Q_A(ntryL,G1H2(134),55,nME,G2H2(350),n2h2(262))
  call Hloop_VQ_A(ntryL,G1H4(33),ex1(:),G1H2(139),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(139),47,nME,G2H2(351),n2h2(263))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-16,nME,G2H4(72),n2h4(425))
  call Hloop_AV_Q(ntryL,G2H4(72),ex5(:),G2H2(352),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_VQ_A(ntryL,G1H4(325),ex1(:),G1H2(140),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(140),47,nME,G2H2(353),n2h2(264))
  call Hloop_VQ_A(ntryL,G1H4(326),ex1(:),G1H2(1),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(354),n2h2(265))
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(2),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(2),47,nME,G2H2(355),n2h2(266))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-16,nME,G2H4(71),n2h4(426))
  call Hloop_AV_Q(ntryL,G2H4(71),ex5(:),G2H2(356),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_VQ_A(ntryL,G1H4(328),ex1(:),G1H2(7),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_Q_A(ntryL,G1H2(7),47,nME,G2H2(357),n2h2(267))
  call Hloop_VQ_A(ntryL,G1H4(329),ex1(:),G1H2(8),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_Q_A(ntryL,G1H2(8),47,nME,G2H2(358),n2h2(268))
  call Hloop_VA_Q(ntryL,G1H4(57),ex2(:),G1H2(13),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(13),55,nME,G2H2(359),n2h2(269))
call HGT_OLR(G1H4(59),1,1,4)
call HGT_invQ_OLR(G1H4(59),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(59),-8,nME,G2H4(76),n2h4(427))
  call Hloop_QV_A(ntryL,G2H4(76),ex4(:),G2H2(360),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_VA_Q(ntryL,G1H4(332),ex2(:),G1H2(14),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(14),55,nME,G2H2(361),n2h2(270))
  call Hloop_VA_Q(ntryL,G1H4(333),ex2(:),G1H2(19),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_A_Q(ntryL,G1H2(19),55,nME,G2H2(362),n2h2(271))
  call Hloop_VA_Q(ntryL,G1H4(334),ex2(:),G1H2(20),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_A_Q(ntryL,G1H2(20),55,nME,G2H2(363),n2h2(272))
call HGT_OLR(G1H4(335),1,1,4)
call HGT_invQ_OLR(G1H4(335),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(335),-8,nME,G2H4(86),n2h4(428))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(364),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_VA_Q(ntryL,G1H4(338),ex2(:),G1H2(25),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_A_Q(ntryL,G1H2(25),55,nME,G2H2(365),n2h2(273))
  call Hloop_VA_Q(ntryL,G1H4(339),ex2(:),G1H2(26),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_A_Q(ntryL,G1H2(26),55,nME,G2H2(366),n2h2(274))
  call Hloop_QV_A(ntryL,G1H4(69),ex3(:),G1H2(31),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(31),47,nME,G2H2(367),n2h2(275))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-16,nME,G2H4(80),n2h4(429))
  call Hloop_AV_Q(ntryL,G2H4(80),ex5(:),G2H2(368),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_QV_A(ntryL,G1H4(341),ex3(:),G1H2(32),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(32),47,nME,G2H2(369),n2h2(276))
  call Hloop_QV_A(ntryL,G1H4(342),ex3(:),G1H2(37),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(37),47,nME,G2H2(370),n2h2(277))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-16,nME,G2H4(83),n2h4(430))
  call Hloop_AV_Q(ntryL,G2H4(83),ex5(:),G2H2(371),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_QV_A(ntryL,G1H4(345),ex3(:),G1H2(38),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(38),47,nME,G2H2(372),n2h2(278))
  call Hloop_QV_A(ntryL,G0H4(1),ex3(:),G0H2(1),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(43),n2h2(279))
  call Hloop_AV_Q(ntryL,G1H4(346),ex4(:),G1H2(44),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_A_Q(ntryL,G1H2(44),47,nME,G2H2(373),n2h2(280))
call HGT_OLR(G1H4(347),1,1,4)
call HGT_invQ_OLR(G1H4(347),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(347),-16,nME,G2H4(84),n2h4(431))
  call Hloop_QV_A(ntryL,G2H4(84),ex5(:),G2H2(374),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_AV_Q(ntryL,G1H4(350),ex4(:),G1H2(49),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(375),n2h2(281))
  call Hloop_AV_Q(ntryL,G1H4(351),ex4(:),G1H2(50),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_A_Q(ntryL,G1H2(50),47,nME,G2H2(376),n2h2(282))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-16,nME,G2H4(94),n2h4(432))
  call Hloop_QV_A(ntryL,G2H4(94),ex5(:),G2H2(377),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_AV_Q(ntryL,G1H4(354),ex4(:),G1H2(55),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_A_Q(ntryL,G1H2(55),47,nME,G2H2(378),n2h2(283))
  call Hloop_AV_Q(ntryL,G0H4(2),ex4(:),G0H2(1),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(56),n2h2(284))
  call Hloop_AV_Q(ntryL,G1H4(355),ex5(:),G1H2(61),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_A_Q(ntryL,G1H2(61),55,nME,G2H2(379),n2h2(285))
call HGT_OLR(G1H4(356),1,1,4)
call HGT_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(356),-8,nME,G2H4(88),n2h4(433))
  call Hloop_QV_A(ntryL,G2H4(88),ex4(:),G2H2(380),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_AV_Q(ntryL,G1H4(359),ex5(:),G1H2(62),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G1H2(62),55,nME,G2H2(381),n2h2(286))
  call Hloop_AV_Q(ntryL,G1H4(360),ex5(:),G1H2(67),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(67),55,nME,G2H2(382),n2h2(287))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(106),-8,nME,G2H4(93),n2h4(434))
  call Hloop_QV_A(ntryL,G2H4(93),ex4(:),G2H2(383),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_AV_Q(ntryL,G1H4(363),ex5(:),G1H2(68),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(68),55,nME,G2H2(384),n2h2(288))
  call Hloop_AV_Q(ntryL,G0H4(3),ex5(:),G0H2(1),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(73),n2h2(289))
  call Hloop_QV_A(ntryL,G1H4(364),ex4(:),G1H2(74),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(74),47,nME,G2H2(385),n2h2(290))
call HGT_OLR(G1H4(365),1,1,4)
call HGT_invQ_OLR(G1H4(365),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(365),-16,nME,G2H4(1),n2h4(435))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(386),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_QV_A(ntryL,G1H4(368),ex4(:),G1H2(79),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(79),47,nME,G2H2(387),n2h2(291))
  call Hloop_QV_A(ntryL,G1H4(369),ex4(:),G1H2(80),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(80),47,nME,G2H2(388),n2h2(292))
  call Hloop_QV_A(ntryL,G1H4(370),ex4(:),G1H2(85),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_Q_A(ntryL,G1H2(85),47,nME,G2H2(389),n2h2(293))
call HGT_OLR(G1H4(371),1,1,4)
call HGT_invQ_OLR(G1H4(371),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(371),-16,nME,G2H4(54),n2h4(436))
  call Hloop_AV_Q(ntryL,G2H4(54),ex5(:),G2H2(390),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(86),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(86),47,nME,G2H2(391),n2h2(294))
  call Hloop_QV_A(ntryL,G1H4(287),ex4(:),G1H2(91),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(91),47,nME,G2H2(392),n2h2(295))
call HGT_OLR(G1H4(376),1,1,4)
call HGT_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(376),-16,nME,G2H4(55),n2h4(437))
  call Hloop_AV_Q(ntryL,G2H4(55),ex5(:),G2H2(393),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_QV_A(ntryL,G1H4(379),ex4(:),G1H2(92),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(92),47,nME,G2H2(394),n2h2(296))
  call Hloop_QV_A(ntryL,G0H4(4),ex4(:),G0H2(1),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(97),n2h2(297))
  call Hloop_QV_A(ntryL,G1H4(119),ex5(:),G1H2(98),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(98),55,nME,G2H2(395),n2h2(298))
call HGT_OLR(G1H4(380),1,1,4)
call HGT_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(380),-8,nME,G2H4(3),n2h4(438))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(396),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_QV_A(ntryL,G1H4(383),ex5(:),G1H2(103),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(103),55,nME,G2H2(397),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(384),ex5(:),G1H2(104),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(104),55,nME,G2H2(398),n2h2(300))
  call Hloop_QV_A(ntryL,G1H4(385),ex5(:),G1H2(109),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(109),55,nME,G2H2(399),n2h2(301))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(386),-8,nME,G2H4(4),n2h4(439))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(400),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_QV_A(ntryL,G1H4(129),ex5(:),G1H2(110),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(110),55,nME,G2H2(401),n2h2(302))
  call Hloop_QV_A(ntryL,G1H4(576),ex5(:),G1H2(115),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(115),55,nME,G2H2(402),n2h2(303))
call HGT_OLR(G1H4(391),1,1,4)
call HGT_invQ_OLR(G1H4(391),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(391),-8,nME,G2H4(59),n2h4(440))
  call Hloop_AV_Q(ntryL,G2H4(59),ex4(:),G2H2(403),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_QV_A(ntryL,G1H4(394),ex5(:),G1H2(116),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(116),55,nME,G2H2(404),n2h2(304))
  call Hloop_QV_A(ntryL,G0H4(5),ex5(:),G0H2(1),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(121),n2h2(305))
  call Hloop_AV_Q(ntryL,G1H4(131),ex3(:),G1H2(122),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_A_Q(ntryL,G1H2(122),47,nME,G2H2(405),n2h2(306))
call HGT_OLR(G1H4(395),1,1,4)
call HGT_invQ_OLR(G1H4(395),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(395),-16,nME,G2H4(62),n2h4(441))
  call Hloop_QV_A(ntryL,G2H4(62),ex5(:),G2H2(406),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_AV_Q(ntryL,G1H4(398),ex3(:),G1H2(127),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_A_Q(ntryL,G1H2(127),47,nME,G2H2(407),n2h2(307))
  call Hloop_AV_Q(ntryL,G1H4(399),ex3(:),G1H2(128),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(128),47,nME,G2H2(408),n2h2(308))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(142),-16,nME,G2H4(6),n2h4(442))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(409),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_AV_Q(ntryL,G1H4(402),ex3(:),G1H2(133),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(133),47,nME,G2H2(410),n2h2(309))
  call Hloop_AV_Q(ntryL,G0H4(6),ex3(:),G0H2(1),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(134),n2h2(310))
  call Hloop_QV_A(ntryL,G1H4(403),ex4(:),G1H2(139),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_Q_A(ntryL,G1H2(139),47,nME,G2H2(411),n2h2(311))
call HGT_OLR(G1H4(404),1,1,4)
call HGT_invQ_OLR(G1H4(404),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(404),-16,nME,G2H4(9),n2h4(443))
  call Hloop_AV_Q(ntryL,G2H4(9),ex5(:),G2H2(412),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_QV_A(ntryL,G1H4(407),ex4(:),G1H2(140),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_Q_A(ntryL,G1H2(140),47,nME,G2H2(413),n2h2(312))
  call Hloop_QV_A(ntryL,G1H4(408),ex4(:),G1H2(1),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(414),n2h2(313))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(154),-16,nME,G2H4(315),n2h4(444))
  call Hloop_AV_Q(ntryL,G2H4(315),ex5(:),G2H2(415),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_QV_A(ntryL,G1H4(411),ex4(:),G1H2(2),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_Q_A(ntryL,G1H2(2),47,nME,G2H2(416),n2h2(314))
  call Hloop_QV_A(ntryL,G0H4(7),ex4(:),G0H2(1),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(7),n2h2(315))
  call Hloop_QV_A(ntryL,G1H4(412),ex3(:),G1H2(8),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_Q_A(ntryL,G1H2(8),47,nME,G2H2(417),n2h2(316))
call HGT_OLR(G1H4(413),1,1,4)
call HGT_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(413),-16,nME,G2H4(12),n2h4(445))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(418),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_QV_A(ntryL,G1H4(416),ex3(:),G1H2(13),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_Q_A(ntryL,G1H2(13),47,nME,G2H2(419),n2h2(317))
  call Hloop_QV_A(ntryL,G1H4(417),ex3(:),G1H2(14),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(14),47,nME,G2H2(420),n2h2(318))
  call Hloop_QV_A(ntryL,G1H4(418),ex3(:),G1H2(19),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(19),47,nME,G2H2(421),n2h2(319))
call HGT_OLR(G1H4(419),1,1,4)
call HGT_invQ_OLR(G1H4(419),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(419),-16,nME,G2H4(363),n2h4(446))
  call Hloop_AV_Q(ntryL,G2H4(363),ex5(:),G2H2(422),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_QV_A(ntryL,G1H4(165),ex3(:),G1H2(20),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(20),47,nME,G2H2(423),n2h2(320))
  call Hloop_QV_A(ntryL,G1H4(581),ex3(:),G1H2(25),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(25),47,nME,G2H2(424),n2h2(321))
call HGT_OLR(G1H4(424),1,1,4)
call HGT_invQ_OLR(G1H4(424),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(424),-16,nME,G2H4(15),n2h4(447))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(425),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_QV_A(ntryL,G1H4(427),ex3(:),G1H2(26),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(26),47,nME,G2H2(426),n2h2(322))
  call Hloop_QV_A(ntryL,G0H4(8),ex3(:),G0H2(1),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(31),n2h2(323))
  call Hloop_QV_A(ntryL,G1H4(167),ex5(:),G1H2(32),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_Q_A(ntryL,G1H2(32),59,nME,G2H2(427),n2h2(324))
call HGT_OLR(G1H4(428),1,1,4)
call HGT_invQ_OLR(G1H4(428),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(428),-4,nME,G2H4(339),n2h4(448))
  call Hloop_AV_Q(ntryL,G2H4(339),ex3(:),G2H2(428),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_QV_A(ntryL,G1H4(431),ex5(:),G1H2(37),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_Q_A(ntryL,G1H2(37),59,nME,G2H2(429),n2h2(325))
  call Hloop_QV_A(ntryL,G1H4(432),ex5(:),G1H2(38),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_Q_A(ntryL,G1H2(38),59,nME,G2H2(430),n2h2(326))
  call Hloop_QV_A(ntryL,G1H4(433),ex5(:),G1H2(44),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_Q_A(ntryL,G1H2(44),59,nME,G2H2(431),n2h2(327))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(434),-4,nME,G2H4(16),n2h4(449))
  call Hloop_AV_Q(ntryL,G2H4(16),ex3(:),G2H2(432),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_QV_A(ntryL,G1H4(177),ex5(:),G1H2(49),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(49),59,nME,G2H2(433),n2h2(328))
  call Hloop_QV_A(ntryL,G1H4(586),ex5(:),G1H2(50),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_Q_A(ntryL,G1H2(50),59,nME,G2H2(434),n2h2(329))
call HGT_OLR(G1H4(439),1,1,4)
call HGT_invQ_OLR(G1H4(439),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(439),-4,nME,G2H4(125),n2h4(450))
  call Hloop_AV_Q(ntryL,G2H4(125),ex3(:),G2H2(435),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_QV_A(ntryL,G1H4(442),ex5(:),G1H2(55),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_Q_A(ntryL,G1H2(55),59,nME,G2H2(436),n2h2(330))
  call Hloop_QV_A(ntryL,G0H4(9),ex5(:),G0H2(1),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G0H2(1),59,nME,G1H2(61),n2h2(331))
  call Hloop_QV_A(ntryL,G1H4(179),ex5(:),G1H2(62),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_Q_A(ntryL,G1H2(62),55,nME,G2H2(437),n2h2(332))
call HGT_OLR(G1H4(443),1,1,4)
call HGT_invQ_OLR(G1H4(443),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(443),-8,nME,G2H4(128),n2h4(451))
  call Hloop_AV_Q(ntryL,G2H4(128),ex4(:),G2H2(438),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_QV_A(ntryL,G1H4(446),ex5(:),G1H2(67),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_Q_A(ntryL,G1H2(67),55,nME,G2H2(439),n2h2(333))
  call Hloop_QV_A(ntryL,G1H4(447),ex5(:),G1H2(68),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_Q_A(ntryL,G1H2(68),55,nME,G2H2(440),n2h2(334))
call HGT_OLR(G1H4(190),1,1,4)
call HGT_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(190),-8,nME,G2H4(18),n2h4(452))
  call Hloop_AV_Q(ntryL,G2H4(18),ex4(:),G2H2(441),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_QV_A(ntryL,G1H4(450),ex5(:),G1H2(74),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_Q_A(ntryL,G1H2(74),55,nME,G2H2(442),n2h2(335))
  call Hloop_QV_A(ntryL,G0H4(10),ex5(:),G0H2(1),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(79),n2h2(336))
  call Hloop_QV_A(ntryL,G1H4(451),ex3(:),G1H2(80),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_Q_A(ntryL,G1H2(80),55,nME,G2H2(443),n2h2(337))
call HGT_OLR(G1H4(452),1,1,4)
call HGT_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(452),-8,nME,G2H4(130),n2h4(453))
  call Hloop_AV_Q(ntryL,G2H4(130),ex4(:),G2H2(444),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_QV_A(ntryL,G1H4(455),ex3(:),G1H2(85),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(85),55,nME,G2H2(445),n2h2(338))
  call Hloop_QV_A(ntryL,G1H4(456),ex3(:),G1H2(86),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_Q_A(ntryL,G1H2(86),55,nME,G2H2(446),n2h2(339))
  call Hloop_QV_A(ntryL,G1H4(457),ex3(:),G1H2(91),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_Q_A(ntryL,G1H2(91),55,nME,G2H2(447),n2h2(340))
call HGT_OLR(G1H4(458),1,1,4)
call HGT_invQ_OLR(G1H4(458),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(458),-8,nME,G2H4(133),n2h4(454))
  call Hloop_AV_Q(ntryL,G2H4(133),ex4(:),G2H2(448),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_QV_A(ntryL,G1H4(201),ex3(:),G1H2(92),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(92),55,nME,G2H2(449),n2h2(341))
  call Hloop_QV_A(ntryL,G1H4(591),ex3(:),G1H2(98),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_Q_A(ntryL,G1H2(98),55,nME,G2H2(450),n2h2(342))
call HGT_OLR(G1H4(463),1,1,4)
call HGT_invQ_OLR(G1H4(463),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(463),-8,nME,G2H4(22),n2h4(455))
  call Hloop_AV_Q(ntryL,G2H4(22),ex4(:),G2H2(451),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_QV_A(ntryL,G1H4(466),ex3(:),G1H2(103),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(103),55,nME,G2H2(452),n2h2(343))
  call Hloop_QV_A(ntryL,G0H4(11),ex3(:),G0H2(1),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(104),n2h2(344))
  call Hloop_QV_A(ntryL,G1H4(203),ex4(:),G1H2(109),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_Q_A(ntryL,G1H2(109),59,nME,G2H2(453),n2h2(345))
call HGT_OLR(G1H4(467),1,1,4)
call HGT_invQ_OLR(G1H4(467),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(467),-4,nME,G2H4(307),n2h4(456))
  call Hloop_AV_Q(ntryL,G2H4(307),ex3(:),G2H2(454),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_QV_A(ntryL,G1H4(470),ex4(:),G1H2(110),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_Q_A(ntryL,G1H2(110),59,nME,G2H2(455),n2h2(346))
  call Hloop_QV_A(ntryL,G1H4(471),ex4(:),G1H2(115),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_Q_A(ntryL,G1H2(115),59,nME,G2H2(456),n2h2(347))
  call Hloop_QV_A(ntryL,G1H4(472),ex4(:),G1H2(116),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_Q_A(ntryL,G1H2(116),59,nME,G2H2(457),n2h2(348))
call HGT_OLR(G1H4(473),1,1,4)
call HGT_invQ_OLR(G1H4(473),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(473),-4,nME,G2H4(26),n2h4(457))
  call Hloop_AV_Q(ntryL,G2H4(26),ex3(:),G2H2(458),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_QV_A(ntryL,G1H4(213),ex4(:),G1H2(122),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_Q_A(ntryL,G1H2(122),59,nME,G2H2(459),n2h2(349))
  call Hloop_QV_A(ntryL,G1H4(596),ex4(:),G1H2(127),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_Q_A(ntryL,G1H2(127),59,nME,G2H2(460),n2h2(350))
call HGT_OLR(G1H4(478),1,1,4)
call HGT_invQ_OLR(G1H4(478),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(478),-4,nME,G2H4(355),n2h4(458))
  call Hloop_AV_Q(ntryL,G2H4(355),ex3(:),G2H2(461),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_QV_A(ntryL,G1H4(481),ex4(:),G1H2(128),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(128),59,nME,G2H2(462),n2h2(351))
  call Hloop_QV_A(ntryL,G0H4(12),ex4(:),G0H2(1),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_Q_A(ntryL,G0H2(1),59,nME,G1H2(133),n2h2(352))
  call Hloop_AV_Q(ntryL,G1H4(215),ex4(:),G1H2(139),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(139),47,nME,G2H2(463),n2h2(353))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(482),-16,nME,G2H4(27),n2h4(459))
  call Hloop_QV_A(ntryL,G2H4(27),ex5(:),G2H2(464),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_AV_Q(ntryL,G1H4(485),ex4(:),G1H2(140),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_A_Q(ntryL,G1H2(140),47,nME,G2H2(465),n2h2(354))
  call Hloop_AV_Q(ntryL,G1H4(486),ex4(:),G1H2(1),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_A_Q(ntryL,G1H2(1),47,nME,G2H2(466),n2h2(355))
  call Hloop_AV_Q(ntryL,G1H4(487),ex4(:),G1H2(2),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(2),47,nME,G2H2(467),n2h2(356))
call HGT_OLR(G1H4(488),1,1,4)
call HGT_invQ_OLR(G1H4(488),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(488),-16,nME,G2H4(135),n2h4(460))
  call Hloop_QV_A(ntryL,G2H4(135),ex5(:),G2H2(468),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_AV_Q(ntryL,G1H4(225),ex4(:),G1H2(8),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(8),47,nME,G2H2(469),n2h2(357))
  call Hloop_AV_Q(ntryL,G1H4(601),ex4(:),G1H2(13),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_A_Q(ntryL,G1H2(13),47,nME,G2H2(470),n2h2(358))
call HGT_OLR(G1H4(493),1,1,4)
call HGT_invQ_OLR(G1H4(493),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(493),-16,nME,G2H4(138),n2h4(461))
  call Hloop_QV_A(ntryL,G2H4(138),ex5(:),G2H2(471),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_AV_Q(ntryL,G1H4(496),ex4(:),G1H2(14),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_A_Q(ntryL,G1H2(14),47,nME,G2H2(472),n2h2(359))
  call Hloop_AV_Q(ntryL,G0H4(13),ex4(:),G0H2(1),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(19),n2h2(360))
  call Hloop_AV_Q(ntryL,G1H4(227),ex5(:),G1H2(20),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_A_Q(ntryL,G1H2(20),55,nME,G2H2(473),n2h2(361))
call HGT_OLR(G1H4(497),1,1,4)
call HGT_invQ_OLR(G1H4(497),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(497),-8,nME,G2H4(30),n2h4(462))
  call Hloop_QV_A(ntryL,G2H4(30),ex4(:),G2H2(474),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_AV_Q(ntryL,G1H4(500),ex5(:),G1H2(25),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_A_Q(ntryL,G1H2(25),55,nME,G2H2(475),n2h2(362))
  call Hloop_AV_Q(ntryL,G1H4(501),ex5(:),G1H2(26),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_A_Q(ntryL,G1H2(26),55,nME,G2H2(476),n2h2(363))
  call Hloop_AV_Q(ntryL,G1H4(502),ex5(:),G1H2(32),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_A_Q(ntryL,G1H2(32),55,nME,G2H2(477),n2h2(364))
call HGT_OLR(G1H4(503),1,1,4)
call HGT_invQ_OLR(G1H4(503),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(503),-8,nME,G2H4(140),n2h4(463))
  call Hloop_QV_A(ntryL,G2H4(140),ex4(:),G2H2(478),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_AV_Q(ntryL,G1H4(237),ex5(:),G1H2(37),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_A_Q(ntryL,G1H2(37),55,nME,G2H2(479),n2h2(365))
  call Hloop_AV_Q(ntryL,G1H4(606),ex5(:),G1H2(38),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_A_Q(ntryL,G1H2(38),55,nME,G2H2(480),n2h2(366))
call HGT_OLR(G1H4(508),1,1,4)
call HGT_invQ_OLR(G1H4(508),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(508),-8,nME,G2H4(143),n2h4(464))
  call Hloop_QV_A(ntryL,G2H4(143),ex4(:),G2H2(481),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_AV_Q(ntryL,G1H4(511),ex5(:),G1H2(44),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_A_Q(ntryL,G1H2(44),55,nME,G2H2(482),n2h2(367))
  call Hloop_AV_Q(ntryL,G0H4(14),ex5(:),G0H2(1),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(49),n2h2(368))
  call Hloop_AV_Q(ntryL,G1H4(239),ex3(:),G1H2(50),m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_A_Q(ntryL,G1H2(50),47,nME,G2H2(483),n2h2(369))
call HGT_OLR(G1H4(512),1,1,4)
call HGT_invQ_OLR(G1H4(512),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(512),-16,nME,G2H4(34),n2h4(465))
  call Hloop_QV_A(ntryL,G2H4(34),ex5(:),G2H2(484),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_AV_Q(ntryL,G1H4(515),ex3(:),G1H2(55),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_A_Q(ntryL,G1H2(55),47,nME,G2H2(485),n2h2(370))
  call Hloop_AV_Q(ntryL,G1H4(516),ex3(:),G1H2(62),m3h2x2(:,524),heltab2x4(:,:,524))
  call Hloop_A_Q(ntryL,G1H2(62),47,nME,G2H2(486),n2h2(371))
  call Hloop_AV_Q(ntryL,G1H4(517),ex3(:),G1H2(67),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_A_Q(ntryL,G1H2(67),47,nME,G2H2(487),n2h2(372))
call HGT_OLR(G1H4(518),1,1,4)
call HGT_invQ_OLR(G1H4(518),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(518),-16,nME,G2H4(331),n2h4(466))
  call Hloop_QV_A(ntryL,G2H4(331),ex5(:),G2H2(488),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_AV_Q(ntryL,G1H4(249),ex3(:),G1H2(68),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_A_Q(ntryL,G1H2(68),47,nME,G2H2(489),n2h2(373))
  call Hloop_AV_Q(ntryL,G1H4(611),ex3(:),G1H2(74),m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_A_Q(ntryL,G1H2(74),47,nME,G2H2(490),n2h2(374))
call HGT_OLR(G1H4(523),1,1,4)
call HGT_invQ_OLR(G1H4(523),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(523),-16,nME,G2H4(35),n2h4(467))
  call Hloop_QV_A(ntryL,G2H4(35),ex5(:),G2H2(491),m3h2x2(:,529),heltab2x4(:,:,529))
  call Hloop_AV_Q(ntryL,G1H4(526),ex3(:),G1H2(80),m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_A_Q(ntryL,G1H2(80),47,nME,G2H2(492),n2h2(375))
  call Hloop_AV_Q(ntryL,G0H4(15),ex3(:),G0H2(1),m3h2x2(:,531),heltab2x4(:,:,531))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(85),n2h2(376))
  call Hloop_AV_Q(ntryL,G1H4(251),ex5(:),G1H2(86),m3h2x2(:,532),heltab2x4(:,:,532))
  call Hloop_A_Q(ntryL,G1H2(86),59,nME,G2H2(493),n2h2(377))
call HGT_OLR(G1H4(527),1,1,4)
call HGT_invQ_OLR(G1H4(527),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(527),-4,nME,G2H4(145),n2h4(468))
  call Hloop_QV_A(ntryL,G2H4(145),ex3(:),G2H2(494),m3h2x2(:,533),heltab2x4(:,:,533))
  call Hloop_AV_Q(ntryL,G1H4(530),ex5(:),G1H2(91),m3h2x2(:,534),heltab2x4(:,:,534))
  call Hloop_A_Q(ntryL,G1H2(91),59,nME,G2H2(495),n2h2(378))
  call Hloop_AV_Q(ntryL,G1H4(531),ex5(:),G1H2(92),m3h2x2(:,535),heltab2x4(:,:,535))
  call Hloop_A_Q(ntryL,G1H2(92),59,nME,G2H2(496),n2h2(379))
  call Hloop_AV_Q(ntryL,G1H4(532),ex5(:),G1H2(98),m3h2x2(:,536),heltab2x4(:,:,536))
  call Hloop_A_Q(ntryL,G1H2(98),59,nME,G2H2(497),n2h2(380))
call HGT_OLR(G1H4(533),1,1,4)
call HGT_invQ_OLR(G1H4(533),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(533),-4,nME,G2H4(148),n2h4(469))
  call Hloop_QV_A(ntryL,G2H4(148),ex3(:),G2H2(498),m3h2x2(:,537),heltab2x4(:,:,537))
  call Hloop_AV_Q(ntryL,G1H4(261),ex5(:),G1H2(103),m3h2x2(:,538),heltab2x4(:,:,538))
  call Hloop_A_Q(ntryL,G1H2(103),59,nME,G2H2(499),n2h2(381))
  call Hloop_AV_Q(ntryL,G1H4(616),ex5(:),G1H2(109),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_A_Q(ntryL,G1H2(109),59,nME,G2H2(500),n2h2(382))
call HGT_OLR(G1H4(538),1,1,4)
call HGT_invQ_OLR(G1H4(538),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(538),-4,nME,G2H4(38),n2h4(470))
  call Hloop_QV_A(ntryL,G2H4(38),ex3(:),G2H2(501),m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_AV_Q(ntryL,G1H4(541),ex5(:),G1H2(110),m3h2x2(:,541),heltab2x4(:,:,541))
  call Hloop_A_Q(ntryL,G1H2(110),59,nME,G2H2(502),n2h2(383))
  call Hloop_AV_Q(ntryL,G0H4(16),ex5(:),G0H2(1),m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_A_Q(ntryL,G0H2(1),59,nME,G1H2(115),n2h2(384))
  call Hloop_AV_Q(ntryL,G1H4(263),ex3(:),G1H2(116),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_A_Q(ntryL,G1H2(116),55,nME,G2H2(503),n2h2(385))
call HGT_OLR(G1H4(542),1,1,4)
call HGT_invQ_OLR(G1H4(542),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(542),-8,nME,G2H4(150),n2h4(471))
  call Hloop_QV_A(ntryL,G2H4(150),ex4(:),G2H2(504),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_AV_Q(ntryL,G1H4(545),ex3(:),G1H2(122),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_A_Q(ntryL,G1H2(122),55,nME,G2H2(505),n2h2(386))
  call Hloop_AV_Q(ntryL,G1H4(546),ex3(:),G1H2(127),m3h2x2(:,546),heltab2x4(:,:,546))
  call Hloop_A_Q(ntryL,G1H2(127),55,nME,G2H2(506),n2h2(387))
  call Hloop_AV_Q(ntryL,G1H4(547),ex3(:),G1H2(128),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_A_Q(ntryL,G1H2(128),55,nME,G2H2(507),n2h2(388))
call HGT_OLR(G1H4(548),1,1,4)
call HGT_invQ_OLR(G1H4(548),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(548),-8,nME,G2H4(153),n2h4(472))
  call Hloop_QV_A(ntryL,G2H4(153),ex4(:),G2H2(508),m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_AV_Q(ntryL,G1H4(273),ex3(:),G1H2(139),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_A_Q(ntryL,G1H2(139),55,nME,G2H2(509),n2h2(389))
  call Hloop_AV_Q(ntryL,G1H4(621),ex3(:),G1H2(140),m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_A_Q(ntryL,G1H2(140),55,nME,G2H2(510),n2h2(390))
call HGT_OLR(G1H4(553),1,1,4)
call HGT_invQ_OLR(G1H4(553),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(553),-8,nME,G2H4(39),n2h4(473))
  call Hloop_QV_A(ntryL,G2H4(39),ex4(:),G2H2(511),m3h2x2(:,551),heltab2x4(:,:,551))
  call Hloop_AV_Q(ntryL,G1H4(556),ex3(:),G1H2(1),m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_A_Q(ntryL,G1H2(1),55,nME,G2H2(512),n2h2(391))
  call Hloop_AV_Q(ntryL,G0H4(17),ex3(:),G0H2(1),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(2),n2h2(392))
  call Hloop_AV_Q(ntryL,G1H4(275),ex4(:),G1H2(8),m3h2x2(:,554),heltab2x4(:,:,554))
  call Hloop_A_Q(ntryL,G1H2(8),59,nME,G2H2(513),n2h2(393))
call HGT_OLR(G1H4(557),1,1,4)
call HGT_invQ_OLR(G1H4(557),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(557),-4,nME,G2H4(155),n2h4(474))
  call Hloop_QV_A(ntryL,G2H4(155),ex3(:),G2H2(514),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_AV_Q(ntryL,G1H4(560),ex4(:),G1H2(13),m3h2x2(:,556),heltab2x4(:,:,556))
  call Hloop_A_Q(ntryL,G1H2(13),59,nME,G2H2(515),n2h2(394))
  call Hloop_AV_Q(ntryL,G1H4(561),ex4(:),G1H2(14),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_A_Q(ntryL,G1H2(14),59,nME,G2H2(516),n2h2(395))
  call Hloop_AV_Q(ntryL,G1H4(562),ex4(:),G1H2(20),m3h2x2(:,558),heltab2x4(:,:,558))
  call Hloop_A_Q(ntryL,G1H2(20),59,nME,G2H2(517),n2h2(396))
call HGT_OLR(G1H4(563),1,1,4)
call HGT_invQ_OLR(G1H4(563),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(563),-4,nME,G2H4(158),n2h4(475))
  call Hloop_QV_A(ntryL,G2H4(158),ex3(:),G2H2(518),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_AV_Q(ntryL,G1H4(285),ex4(:),G1H2(25),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_A_Q(ntryL,G1H2(25),59,nME,G2H2(519),n2h2(397))
  call Hloop_AV_Q(ntryL,G1H4(626),ex4(:),G1H2(26),m3h2x2(:,561),heltab2x4(:,:,561))
  call Hloop_A_Q(ntryL,G1H2(26),59,nME,G2H2(520),n2h2(398))
call HGT_OLR(G1H4(568),1,1,4)
call HGT_invQ_OLR(G1H4(568),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(568),-4,nME,G2H4(42),n2h4(476))
  call Hloop_QV_A(ntryL,G2H4(42),ex3(:),G2H2(521),m3h2x2(:,562),heltab2x4(:,:,562))
  call Hloop_AV_Q(ntryL,G1H4(571),ex4(:),G1H2(32),m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_A_Q(ntryL,G1H2(32),59,nME,G2H2(522),n2h2(399))
  call Hloop_AV_Q(ntryL,G0H4(18),ex4(:),G0H2(1),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_A_Q(ntryL,G0H2(1),59,nME,G1H2(37),n2h2(400))
  call Hloop_VQ_A(ntryL,G1H8(116),wf4(:,3),G1H2(38),m3h4x2(:,1),heltab2x8(:,:,353))
  call Hloop_Q_A(ntryL,G1H2(38),47,nME,G2H2(523),n2h2(401))
call HGT_OLR(G1H8(118),1,1,8)
call HGT_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(118),-16,nME,G2H8(21),n2h8(247))
  call Hloop_AV_Q(ntryL,G2H8(21),ex5(:),G2H4(160),m3h2x4(:,353),heltab2x8(:,:,354))
  call Hloop_VQ_A(ntryL,G1H8(121),wf4(:,3),G1H2(44),m3h4x2(:,2),heltab2x8(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(44),47,nME,G2H2(524),n2h2(402))
  call Hloop_VQ_A(ntryL,G1H8(122),wf4(:,3),G1H2(50),m3h4x2(:,3),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G1H2(50),47,nME,G2H2(525),n2h2(403))
  call Hloop_VA_Q(ntryL,G1H8(124),wf4(:,12),G1H2(55),m3h4x2(:,4),heltab2x8(:,:,357))
  call Hloop_A_Q(ntryL,G1H2(55),47,nME,G2H2(526),n2h2(404))
call HGT_OLR(G1H8(125),1,1,8)
call HGT_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(125),-16,nME,G2H8(36),n2h8(248))
  call Hloop_QV_A(ntryL,G2H8(36),ex5(:),G2H4(163),m3h2x4(:,354),heltab2x8(:,:,358))
  call Hloop_VA_Q(ntryL,G1H8(128),wf4(:,12),G1H2(62),m3h4x2(:,5),heltab2x8(:,:,359))
  call Hloop_A_Q(ntryL,G1H2(62),47,nME,G2H2(527),n2h2(405))
  call Hloop_VA_Q(ntryL,G1H8(130),wf4(:,12),G1H2(67),m3h4x2(:,6),heltab2x8(:,:,360))
  call Hloop_A_Q(ntryL,G1H2(67),47,nME,G2H2(528),n2h2(406))
  call Hloop_VQ_A(ntryL,G1H8(131),wf4(:,11),G1H2(68),m3h4x2(:,7),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(68),47,nME,G2H2(529),n2h2(407))
call HGT_OLR(G1H8(132),1,1,8)
call HGT_invQ_OLR(G1H8(132),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(132),-16,nME,G2H8(20),n2h8(249))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(43),m3h2x4(:,355),heltab2x8(:,:,362))
  call Hloop_VQ_A(ntryL,G1H8(136),wf4(:,11),G1H2(74),m3h4x2(:,8),heltab2x8(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(74),47,nME,G2H2(530),n2h2(408))
  call Hloop_VQ_A(ntryL,G1H8(137),wf4(:,11),G1H2(80),m3h4x2(:,9),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G1H2(80),47,nME,G2H2(531),n2h2(409))
  call Hloop_VA_Q(ntryL,G1H8(138),wf4(:,4),G1H2(86),m3h4x2(:,10),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(86),47,nME,G2H2(532),n2h2(410))
call HGT_OLR(G1H8(139),1,1,8)
call HGT_invQ_OLR(G1H8(139),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(139),-16,nME,G2H8(26),n2h8(250))
  call Hloop_QV_A(ntryL,G2H8(26),ex5(:),G2H4(165),m3h2x4(:,356),heltab2x8(:,:,366))
  call Hloop_VA_Q(ntryL,G1H8(143),wf4(:,4),G1H2(91),m3h4x2(:,11),heltab2x8(:,:,367))
  call Hloop_A_Q(ntryL,G1H2(91),47,nME,G2H2(533),n2h2(411))
  call Hloop_VA_Q(ntryL,G1H8(144),wf4(:,4),G1H2(92),m3h4x2(:,12),heltab2x8(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(92),47,nME,G2H2(534),n2h2(412))
  call Hloop_VQ_A(ntryL,G1H8(145),wf4(:,14),G1H2(98),m3h4x2(:,13),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(98),55,nME,G2H2(535),n2h2(413))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(146),-8,nME,G2H8(25),n2h8(251))
  call Hloop_AV_Q(ntryL,G2H8(25),ex4(:),G2H4(168),m3h2x4(:,357),heltab2x8(:,:,370))
  call Hloop_VQ_A(ntryL,G1H8(150),wf4(:,14),G1H2(103),m3h4x2(:,14),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(103),55,nME,G2H2(536),n2h2(414))
  call Hloop_VQ_A(ntryL,G1H8(151),wf4(:,14),G1H2(109),m3h4x2(:,15),heltab2x8(:,:,372))
  call Hloop_Q_A(ntryL,G1H2(109),55,nME,G2H2(537),n2h2(415))
  call Hloop_VA_Q(ntryL,G1H8(152),wf4(:,6),G1H2(110),m3h4x2(:,16),heltab2x8(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(110),55,nME,G2H2(538),n2h2(416))
call HGT_OLR(G1H8(154),1,1,8)
call HGT_invQ_OLR(G1H8(154),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(154),-8,nME,G2H8(30),n2h8(252))
  call Hloop_QV_A(ntryL,G2H8(30),ex4(:),G2H4(46),m3h2x4(:,358),heltab2x8(:,:,374))
  call Hloop_VA_Q(ntryL,G1H8(157),wf4(:,6),G1H2(116),m3h4x2(:,17),heltab2x8(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(116),55,nME,G2H2(539),n2h2(417))
  call Hloop_VA_Q(ntryL,G1H8(158),wf4(:,6),G1H2(122),m3h4x2(:,18),heltab2x8(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(122),55,nME,G2H2(540),n2h2(418))
call HGT_OLR(G1H4(572),1,1,4)
call HGT_invQ_OLR(G1H4(572),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(572),-24,nME,G2H4(170),n2h4(477))
  call Hloop_AV_Q(ntryL,G2H4(170),ex5(:),G2H2(541),m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_QV_A(ntryL,G1H4(575),ex4(:),G1H2(127),m3h2x2(:,566),heltab2x4(:,:,566))
  call Hloop_Q_A(ntryL,G1H2(127),47,nME,G2H2(542),n2h2(419))
  call Hloop_QV_A(ntryL,G0H4(19),ex4(:),G0H2(1),m3h2x2(:,567),heltab2x4(:,:,567))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(128),n2h2(420))
call HGT_OLR(G1H4(577),1,1,4)
call HGT_invQ_OLR(G1H4(577),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(577),-24,nME,G2H4(173),n2h4(478))
  call Hloop_AV_Q(ntryL,G2H4(173),ex4(:),G2H2(543),m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_QV_A(ntryL,G1H4(580),ex5(:),G1H2(139),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(139),55,nME,G2H2(544),n2h2(421))
  call Hloop_QV_A(ntryL,G0H4(20),ex5(:),G0H2(1),m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(140),n2h2(422))
call HGT_OLR(G1H4(582),1,1,4)
call HGT_invQ_OLR(G1H4(582),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(582),-20,nME,G2H4(47),n2h4(479))
  call Hloop_AV_Q(ntryL,G2H4(47),ex5(:),G2H2(545),m3h2x2(:,571),heltab2x4(:,:,571))
  call Hloop_QV_A(ntryL,G1H4(585),ex3(:),G1H2(1),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(1),47,nME,G2H2(546),n2h2(423))
  call Hloop_QV_A(ntryL,G0H4(21),ex3(:),G0H2(1),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(8),n2h2(424))
call HGT_OLR(G1H4(587),1,1,4)
call HGT_invQ_OLR(G1H4(587),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(587),-20,nME,G2H4(175),n2h4(480))
  call Hloop_AV_Q(ntryL,G2H4(175),ex3(:),G2H2(547),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_QV_A(ntryL,G1H4(590),ex5(:),G1H2(13),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(13),59,nME,G2H2(548),n2h2(425))
  call Hloop_QV_A(ntryL,G0H4(22),ex5(:),G0H2(1),m3h2x2(:,576),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G0H2(1),59,nME,G1H2(14),n2h2(426))
call HGT_OLR(G1H4(592),1,1,4)
call HGT_invQ_OLR(G1H4(592),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(592),-12,nME,G2H4(178),n2h4(481))
  call Hloop_AV_Q(ntryL,G2H4(178),ex4(:),G2H2(549),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_QV_A(ntryL,G1H4(595),ex3(:),G1H2(20),m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(20),55,nME,G2H2(550),n2h2(427))
  call Hloop_QV_A(ntryL,G0H4(23),ex3(:),G0H2(1),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(25),n2h2(428))
call HGT_OLR(G1H4(597),1,1,4)
call HGT_invQ_OLR(G1H4(597),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(597),-12,nME,G2H4(50),n2h4(482))
  call Hloop_AV_Q(ntryL,G2H4(50),ex3(:),G2H2(551),m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_QV_A(ntryL,G1H4(600),ex4(:),G1H2(26),m3h2x2(:,581),heltab2x4(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(26),59,nME,G2H2(552),n2h2(429))
  call Hloop_QV_A(ntryL,G0H4(24),ex4(:),G0H2(1),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_Q_A(ntryL,G0H2(1),59,nME,G1H2(32),n2h2(430))
call HGT_OLR(G1H4(602),1,1,4)
call HGT_invQ_OLR(G1H4(602),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(602),-24,nME,G2H4(180),n2h4(483))
  call Hloop_QV_A(ntryL,G2H4(180),ex5(:),G2H2(553),m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_AV_Q(ntryL,G1H4(605),ex4(:),G1H2(38),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_A_Q(ntryL,G1H2(38),47,nME,G2H2(554),n2h2(431))
  call Hloop_AV_Q(ntryL,G0H4(25),ex4(:),G0H2(1),m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(44),n2h2(432))
call HGT_OLR(G1H4(607),1,1,4)
call HGT_invQ_OLR(G1H4(607),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(607),-24,nME,G2H4(183),n2h4(484))
  call Hloop_QV_A(ntryL,G2H4(183),ex4(:),G2H2(555),m3h2x2(:,586),heltab2x4(:,:,586))
  call Hloop_AV_Q(ntryL,G1H4(610),ex5(:),G1H2(50),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_A_Q(ntryL,G1H2(50),55,nME,G2H2(556),n2h2(433))
  call Hloop_AV_Q(ntryL,G0H4(26),ex5(:),G0H2(1),m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(55),n2h2(434))
call HGT_OLR(G1H4(612),1,1,4)
call HGT_invQ_OLR(G1H4(612),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(612),-20,nME,G2H4(95),n2h4(485))
  call Hloop_QV_A(ntryL,G2H4(95),ex5(:),G2H2(557),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_AV_Q(ntryL,G1H4(615),ex3(:),G1H2(62),m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_A_Q(ntryL,G1H2(62),47,nME,G2H2(558),n2h2(435))
  call Hloop_AV_Q(ntryL,G0H4(27),ex3(:),G0H2(1),m3h2x2(:,591),heltab2x4(:,:,591))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(67),n2h2(436))
call HGT_OLR(G1H4(617),1,1,4)
call HGT_invQ_OLR(G1H4(617),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(617),-20,nME,G2H4(98),n2h4(486))
  call Hloop_QV_A(ntryL,G2H4(98),ex3(:),G2H2(559),m3h2x2(:,592),heltab2x4(:,:,592))
  call Hloop_AV_Q(ntryL,G1H4(620),ex5(:),G1H2(68),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_A_Q(ntryL,G1H2(68),59,nME,G2H2(560),n2h2(437))
  call Hloop_AV_Q(ntryL,G0H4(28),ex5(:),G0H2(1),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_A_Q(ntryL,G0H2(1),59,nME,G1H2(74),n2h2(438))
call HGT_OLR(G1H4(622),1,1,4)
call HGT_invQ_OLR(G1H4(622),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(622),-12,nME,G2H4(99),n2h4(487))
  call Hloop_QV_A(ntryL,G2H4(99),ex4(:),G2H2(561),m3h2x2(:,595),heltab2x4(:,:,595))
  call Hloop_AV_Q(ntryL,G1H4(625),ex3(:),G1H2(80),m3h2x2(:,596),heltab2x4(:,:,596))
  call Hloop_A_Q(ntryL,G1H2(80),55,nME,G2H2(562),n2h2(439))
  call Hloop_AV_Q(ntryL,G0H4(29),ex3(:),G0H2(1),m3h2x2(:,597),heltab2x4(:,:,597))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(86),n2h2(440))
call HGT_OLR(G1H4(627),1,1,4)
call HGT_invQ_OLR(G1H4(627),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(627),-12,nME,G2H4(100),n2h4(488))
  call Hloop_QV_A(ntryL,G2H4(100),ex3(:),G2H2(563),m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_AV_Q(ntryL,G1H4(630),ex4(:),G1H2(91),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_A_Q(ntryL,G1H2(91),59,nME,G2H2(564),n2h2(441))
  call Hloop_AV_Q(ntryL,G0H4(30),ex4(:),G0H2(1),m3h2x2(:,600),heltab2x4(:,:,600))
  call Hloop_A_Q(ntryL,G0H2(1),59,nME,G1H2(92),n2h2(442))
  call Hloop_AV_Q(ntryL,G1H4(631),ex3(:),G1H2(98),m3h2x2(:,601),heltab2x4(:,:,601))
  call Hloop_A_Q(ntryL,G1H2(98),55,nMM,G2H2(565),n2h2(443))
call HGT_OLR(G1H4(632),1,1,4)
call HGT_invQ_OLR(G1H4(632),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(632),-8,nMM,G2H4(103),n2h4(489))
  call Hloop_QV_A(ntryL,G2H4(103),ex4(:),G2H2(566),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_AV_Q(ntryL,G1H4(637),ex3(:),G1H2(103),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_A_Q(ntryL,G1H2(103),55,nMM,G2H2(567),n2h2(444))
  call Hloop_AV_Q(ntryL,G1H4(642),ex3(:),G1H2(109),m3h2x2(:,604),heltab2x4(:,:,604))
  call Hloop_A_Q(ntryL,G1H2(109),55,nMM,G2H2(568),n2h2(445))
call HGT_OLR(G1H4(638),1,1,4)
call HGT_invQ_OLR(G1H4(638),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(638),-8,nMM,G2H4(104),n2h4(490))
  call Hloop_QV_A(ntryL,G2H4(104),ex4(:),G2H2(569),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_AV_Q(ntryL,G1H4(641),ex3(:),G1H2(110),m3h2x2(:,606),heltab2x4(:,:,606))
  call Hloop_A_Q(ntryL,G1H2(110),55,nMM,G2H2(570),n2h2(446))
  call Hloop_AV_Q(ntryL,G0H4(31),ex3(:),G0H2(1),m3h2x2(:,607),heltab2x4(:,:,607))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(116),n2h2(447))
call HGT_OLR(G1H4(643),1,1,4)
call HGT_invQ_OLR(G1H4(643),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(643),-12,nMM,G2H4(105),n2h4(491))
  call Hloop_QV_A(ntryL,G2H4(105),ex4(:),G2H2(571),m3h2x2(:,608),heltab2x4(:,:,608))
  call Hloop_AV_Q(ntryL,G1H4(646),ex3(:),G1H2(122),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_A_Q(ntryL,G1H2(122),55,nMM,G2H2(572),n2h2(448))
  call Hloop_AV_Q(ntryL,G0H4(32),ex3(:),G0H2(1),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(127),n2h2(449))
  call Hloop_QV_A(ntryL,G1H4(647),ex3(:),G1H2(139),m3h2x2(:,611),heltab2x4(:,:,611))
  call Hloop_Q_A(ntryL,G1H2(139),55,nMM,G2H2(573),n2h2(450))
call HGT_OLR(G1H4(648),1,1,4)
call HGT_invQ_OLR(G1H4(648),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(648),-8,nMM,G2H4(108),n2h4(492))
  call Hloop_AV_Q(ntryL,G2H4(108),ex4(:),G2H2(574),m3h2x2(:,612),heltab2x4(:,:,612))
  call Hloop_QV_A(ntryL,G1H4(653),ex3(:),G1H2(1),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMM,G2H2(575),n2h2(451))
  call Hloop_QV_A(ntryL,G1H4(658),ex3(:),G1H2(13),m3h2x2(:,614),heltab2x4(:,:,614))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMM,G2H2(576),n2h2(452))
call HGT_OLR(G1H4(654),1,1,4)
call HGT_invQ_OLR(G1H4(654),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(654),-8,nMM,G2H4(109),n2h4(493))
  call Hloop_AV_Q(ntryL,G2H4(109),ex4(:),G2H2(577),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_QV_A(ntryL,G1H4(657),ex3(:),G1H2(20),m3h2x2(:,616),heltab2x4(:,:,616))
  call Hloop_Q_A(ntryL,G1H2(20),55,nMM,G2H2(578),n2h2(453))
  call Hloop_QV_A(ntryL,G0H4(33),ex3(:),G0H2(1),m3h2x2(:,617),heltab2x4(:,:,617))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(26),n2h2(454))
call HGT_OLR(G1H4(659),1,1,4)
call HGT_invQ_OLR(G1H4(659),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(659),-12,nMM,G2H4(110),n2h4(494))
  call Hloop_AV_Q(ntryL,G2H4(110),ex4(:),G2H2(579),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_QV_A(ntryL,G1H4(662),ex3(:),G1H2(38),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_Q_A(ntryL,G1H2(38),55,nMM,G2H2(580),n2h2(455))
  call Hloop_QV_A(ntryL,G0H4(34),ex3(:),G0H2(1),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(50),n2h2(456))
  call Hloop_AV_Q(ntryL,G1H4(663),ex3(:),G1H2(62),m3h2x2(:,621),heltab2x4(:,:,621))
  call Hloop_A_Q(ntryL,G1H2(62),55,0,G2H2(581),n2h2(457))
call HGT_OLR(G1H4(664),1,1,4)
call HGT_invQ_OLR(G1H4(664),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(664),-8,0,G2H4(113),n2h4(495))
  call Hloop_QV_A(ntryL,G2H4(113),ex4(:),G2H2(582),m3h2x2(:,622),heltab2x4(:,:,622))
  call Hloop_AV_Q(ntryL,G1H4(669),ex3(:),G1H2(68),m3h2x2(:,623),heltab2x4(:,:,623))
  call Hloop_A_Q(ntryL,G1H2(68),55,0,G2H2(583),n2h2(458))
  call Hloop_AV_Q(ntryL,G1H4(674),ex3(:),G1H2(80),m3h2x2(:,624),heltab2x4(:,:,624))
  call Hloop_A_Q(ntryL,G1H2(80),55,0,G2H2(584),n2h2(459))
call HGT_OLR(G1H4(670),1,1,4)
call HGT_invQ_OLR(G1H4(670),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(670),-8,0,G2H4(114),n2h4(496))
  call Hloop_QV_A(ntryL,G2H4(114),ex4(:),G2H2(585),m3h2x2(:,625),heltab2x4(:,:,625))
  call Hloop_AV_Q(ntryL,G1H4(673),ex3(:),G1H2(91),m3h2x2(:,626),heltab2x4(:,:,626))
  call Hloop_A_Q(ntryL,G1H2(91),55,0,G2H2(586),n2h2(460))
  call Hloop_AV_Q(ntryL,G0H4(35),ex3(:),G0H2(1),m3h2x2(:,627),heltab2x4(:,:,627))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(98),n2h2(461))
call HGT_OLR(G1H4(675),1,1,4)
call HGT_invQ_OLR(G1H4(675),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(675),-12,0,G2H4(115),n2h4(497))
  call Hloop_QV_A(ntryL,G2H4(115),ex4(:),G2H2(587),m3h2x2(:,628),heltab2x4(:,:,628))
  call Hloop_AV_Q(ntryL,G1H4(678),ex3(:),G1H2(103),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_A_Q(ntryL,G1H2(103),55,0,G2H2(588),n2h2(462))
  call Hloop_AV_Q(ntryL,G0H4(36),ex3(:),G0H2(1),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(109),n2h2(463))
  call Hloop_QV_A(ntryL,G1H4(679),ex3(:),G1H2(110),m3h2x2(:,631),heltab2x4(:,:,631))
  call Hloop_Q_A(ntryL,G1H2(110),55,0,G2H2(589),n2h2(464))
call HGT_OLR(G1H4(680),1,1,4)
call HGT_invQ_OLR(G1H4(680),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(680),-8,0,G2H4(118),n2h4(498))
  call Hloop_AV_Q(ntryL,G2H4(118),ex4(:),G2H2(590),m3h2x2(:,632),heltab2x4(:,:,632))
  call Hloop_QV_A(ntryL,G1H4(685),ex3(:),G1H2(122),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_Q_A(ntryL,G1H2(122),55,0,G2H2(591),n2h2(465))
  call Hloop_QV_A(ntryL,G1H4(690),ex3(:),G1H2(139),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_Q_A(ntryL,G1H2(139),55,0,G2H2(592),n2h2(466))
call HGT_OLR(G1H4(686),1,1,4)
call HGT_invQ_OLR(G1H4(686),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(686),-8,0,G2H4(119),n2h4(499))
  call Hloop_AV_Q(ntryL,G2H4(119),ex4(:),G2H2(593),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_QV_A(ntryL,G1H4(689),ex3(:),G1H2(1),m3h2x2(:,636),heltab2x4(:,:,636))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(594),n2h2(467))
  call Hloop_QV_A(ntryL,G0H4(37),ex3(:),G0H2(1),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(13),n2h2(468))
call HGT_OLR(G1H4(691),1,1,4)
call HGT_invQ_OLR(G1H4(691),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(691),-12,0,G2H4(120),n2h4(500))
  call Hloop_AV_Q(ntryL,G2H4(120),ex4(:),G2H2(595),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_QV_A(ntryL,G1H4(694),ex3(:),G1H2(20),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(596),n2h2(469))
  call Hloop_QV_A(ntryL,G0H4(38),ex3(:),G0H2(1),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(38),n2h2(470))
  call Hloop_QV_A(ntryL,G1H4(695),ex3(:),G1H2(62),m3h2x2(:,641),heltab2x4(:,:,641))
  call Hloop_Q_A(ntryL,G1H2(62),47,nMM,G2H2(597),n2h2(471))
call HGT_OLR(G1H4(696),1,1,4)
call HGT_invQ_OLR(G1H4(696),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(696),-16,nMM,G2H4(123),n2h4(501))
  call Hloop_AV_Q(ntryL,G2H4(123),ex5(:),G2H2(598),m3h2x2(:,642),heltab2x4(:,:,642))
  call Hloop_QV_A(ntryL,G1H4(701),ex3(:),G1H2(68),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_Q_A(ntryL,G1H2(68),47,nMM,G2H2(599),n2h2(472))
  call Hloop_QV_A(ntryL,G1H4(706),ex3(:),G1H2(80),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_Q_A(ntryL,G1H2(80),47,nMM,G2H2(600),n2h2(473))
call HGT_OLR(G1H4(702),1,1,4)
call HGT_invQ_OLR(G1H4(702),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(702),-16,nMM,G2H4(124),n2h4(502))
  call Hloop_AV_Q(ntryL,G2H4(124),ex5(:),G2H2(601),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_QV_A(ntryL,G1H4(705),ex3(:),G1H2(91),m3h2x2(:,646),heltab2x4(:,:,646))
  call Hloop_Q_A(ntryL,G1H2(91),47,nMM,G2H2(602),n2h2(474))
  call Hloop_QV_A(ntryL,G0H4(39),ex3(:),G0H2(1),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(103),n2h2(475))
call HGT_OLR(G1H4(707),1,1,4)
call HGT_invQ_OLR(G1H4(707),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(707),-20,nMM,G2H4(129),n2h4(503))
  call Hloop_AV_Q(ntryL,G2H4(129),ex5(:),G2H2(603),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_QV_A(ntryL,G1H4(710),ex3(:),G1H2(110),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_Q_A(ntryL,G1H2(110),47,nMM,G2H2(604),n2h2(476))
  call Hloop_QV_A(ntryL,G0H4(40),ex3(:),G0H2(1),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(122),n2h2(477))
  call Hloop_AV_Q(ntryL,G1H4(711),ex3(:),G1H2(139),m3h2x2(:,651),heltab2x4(:,:,651))
  call Hloop_A_Q(ntryL,G1H2(139),47,nMM,G2H2(605),n2h2(478))
call HGT_OLR(G1H4(712),1,1,4)
call HGT_invQ_OLR(G1H4(712),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(712),-16,nMM,G2H4(134),n2h4(504))
  call Hloop_QV_A(ntryL,G2H4(134),ex5(:),G2H2(606),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_AV_Q(ntryL,G1H4(717),ex3(:),G1H2(1),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMM,G2H2(607),n2h2(479))
  call Hloop_AV_Q(ntryL,G1H4(722),ex3(:),G1H2(20),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_A_Q(ntryL,G1H2(20),47,nMM,G2H2(608),n2h2(480))
call HGT_OLR(G1H4(718),1,1,4)
call HGT_invQ_OLR(G1H4(718),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(718),-16,nMM,G2H4(139),n2h4(505))
  call Hloop_QV_A(ntryL,G2H4(139),ex5(:),G2H2(609),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_AV_Q(ntryL,G1H4(721),ex3(:),G1H2(62),m3h2x2(:,656),heltab2x4(:,:,656))
  call Hloop_A_Q(ntryL,G1H2(62),47,nMM,G2H2(610),n2h2(481))
  call Hloop_AV_Q(ntryL,G0H4(41),ex3(:),G0H2(1),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(68),n2h2(482))
call HGT_OLR(G1H4(723),1,1,4)
call HGT_invQ_OLR(G1H4(723),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(723),-20,nMM,G2H4(144),n2h4(506))
  call Hloop_QV_A(ntryL,G2H4(144),ex5(:),G2H2(611),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_AV_Q(ntryL,G1H4(726),ex3(:),G1H2(80),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_A_Q(ntryL,G1H2(80),47,nMM,G2H2(612),n2h2(483))
  call Hloop_AV_Q(ntryL,G0H4(42),ex3(:),G0H2(1),m3h2x2(:,660),heltab2x4(:,:,660))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(91),n2h2(484))
  call Hloop_QV_A(ntryL,G1H4(727),ex3(:),G1H2(110),m3h2x2(:,661),heltab2x4(:,:,661))
  call Hloop_Q_A(ntryL,G1H2(110),47,0,G2H2(613),n2h2(485))
call HGT_OLR(G1H4(728),1,1,4)
call HGT_invQ_OLR(G1H4(728),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(728),-16,0,G2H4(149),n2h4(507))
  call Hloop_AV_Q(ntryL,G2H4(149),ex5(:),G2H2(614),m3h2x2(:,662),heltab2x4(:,:,662))
  call Hloop_QV_A(ntryL,G1H4(733),ex3(:),G1H2(139),m3h2x2(:,663),heltab2x4(:,:,663))
  call Hloop_Q_A(ntryL,G1H2(139),47,0,G2H2(615),n2h2(486))
  call Hloop_QV_A(ntryL,G1H4(738),ex3(:),G1H2(1),m3h2x2(:,664),heltab2x4(:,:,664))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(616),n2h2(487))
call HGT_OLR(G1H4(734),1,1,4)
call HGT_invQ_OLR(G1H4(734),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(734),-16,0,G2H4(154),n2h4(508))
  call Hloop_AV_Q(ntryL,G2H4(154),ex5(:),G2H2(617),m3h2x2(:,665),heltab2x4(:,:,665))
  call Hloop_QV_A(ntryL,G1H4(737),ex3(:),G1H2(20),m3h2x2(:,666),heltab2x4(:,:,666))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(618),n2h2(488))
  call Hloop_QV_A(ntryL,G0H4(43),ex3(:),G0H2(1),m3h2x2(:,667),heltab2x4(:,:,667))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(62),n2h2(489))
call HGT_OLR(G1H4(739),1,1,4)
call HGT_invQ_OLR(G1H4(739),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(739),-20,0,G2H4(159),n2h4(509))
  call Hloop_AV_Q(ntryL,G2H4(159),ex5(:),G2H2(619),m3h2x2(:,668),heltab2x4(:,:,668))
  call Hloop_QV_A(ntryL,G1H4(742),ex3(:),G1H2(80),m3h2x2(:,669),heltab2x4(:,:,669))
  call Hloop_Q_A(ntryL,G1H2(80),47,0,G2H2(620),n2h2(490))
  call Hloop_QV_A(ntryL,G0H4(44),ex3(:),G0H2(1),m3h2x2(:,670),heltab2x4(:,:,670))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(110),n2h2(491))
  call Hloop_AV_Q(ntryL,G1H4(743),ex3(:),G1H2(139),m3h2x2(:,671),heltab2x4(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(139),47,0,G2H2(621),n2h2(492))
call HGT_OLR(G1H4(744),1,1,4)
call HGT_invQ_OLR(G1H4(744),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(744),-16,0,G2H4(164),n2h4(510))
  call Hloop_QV_A(ntryL,G2H4(164),ex5(:),G2H2(622),m3h2x2(:,672),heltab2x4(:,:,672))
  call Hloop_AV_Q(ntryL,G1H4(749),ex3(:),G1H2(1),m3h2x2(:,673),heltab2x4(:,:,673))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(623),n2h2(493))
  call Hloop_AV_Q(ntryL,G1H4(754),ex3(:),G1H2(20),m3h2x2(:,674),heltab2x4(:,:,674))
  call Hloop_A_Q(ntryL,G1H2(20),47,0,G2H2(624),n2h2(494))
call HGT_OLR(G1H4(750),1,1,4)
call HGT_invQ_OLR(G1H4(750),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(750),-16,0,G2H4(169),n2h4(511))
  call Hloop_QV_A(ntryL,G2H4(169),ex5(:),G2H2(625),m3h2x2(:,675),heltab2x4(:,:,675))
  call Hloop_AV_Q(ntryL,G1H4(753),ex3(:),G1H2(80),m3h2x2(:,676),heltab2x4(:,:,676))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(626),n2h2(495))
  call Hloop_AV_Q(ntryL,G0H4(45),ex3(:),G0H2(1),m3h2x2(:,677),heltab2x4(:,:,677))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(139),n2h2(496))
call HGT_OLR(G1H4(755),1,1,4)
call HGT_invQ_OLR(G1H4(755),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(755),-20,0,G2H4(174),n2h4(512))
  call Hloop_QV_A(ntryL,G2H4(174),ex5(:),G2H2(627),m3h2x2(:,678),heltab2x4(:,:,678))
  call Hloop_AV_Q(ntryL,G1H4(758),ex3(:),G1H2(1),m3h2x2(:,679),heltab2x4(:,:,679))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(628),n2h2(497))
  call Hloop_AV_Q(ntryL,G0H4(46),ex3(:),G0H2(1),m3h2x2(:,680),heltab2x4(:,:,680))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(20),n2h2(498))
  call Hloop_QV_A(ntryL,G1H4(759),ex4(:),G1H2(80),m3h2x2(:,681),heltab2x4(:,:,681))
  call Hloop_Q_A(ntryL,G1H2(80),59,nMM,G2H2(629),n2h2(499))
call HGT_OLR(G1H4(760),1,1,4)
call HGT_invQ_OLR(G1H4(760),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(760),-4,nMM,G2H4(179),n2h4(513))
  call Hloop_AV_Q(ntryL,G2H4(179),ex3(:),G2H2(630),m3h2x2(:,682),heltab2x4(:,:,682))
  call Hloop_QV_A(ntryL,G1H4(765),ex4(:),G1H2(1),m3h2x2(:,683),heltab2x4(:,:,683))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMM,G2H2(631),n2h2(500))
  call Hloop_QV_A(ntryL,G1H4(770),ex4(:),G1H2(80),m3h2x2(:,684),heltab2x4(:,:,684))
  call Hloop_Q_A(ntryL,G1H2(80),59,nMM,G2H2(632),n2h2(501))
call HGT_OLR(G1H4(766),1,1,4)
call HGT_invQ_OLR(G1H4(766),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(766),-4,nMM,G2H4(184),n2h4(514))
  call Hloop_AV_Q(ntryL,G2H4(184),ex3(:),G2H2(633),m3h2x2(:,685),heltab2x4(:,:,685))
  call Hloop_QV_A(ntryL,G1H4(769),ex4(:),G1H2(1),m3h2x2(:,686),heltab2x4(:,:,686))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMM,G2H2(634),n2h2(502))
  call Hloop_QV_A(ntryL,G0H4(47),ex4(:),G0H2(1),m3h2x2(:,687),heltab2x4(:,:,687))
  call Hloop_Q_A(ntryL,G0H2(1),59,nMM,G1H2(80),n2h2(503))
call HGT_OLR(G1H4(771),1,1,4)
call HGT_invQ_OLR(G1H4(771),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(771),-12,nMM,G2H4(185),n2h4(515))
  call Hloop_AV_Q(ntryL,G2H4(185),ex3(:),G2H2(635),m3h2x2(:,688),heltab2x4(:,:,688))
  call Hloop_QV_A(ntryL,G1H4(774),ex4(:),G1H2(1),m3h2x2(:,689),heltab2x4(:,:,689))
  call Hloop_Q_A(ntryL,G1H2(1),59,nMM,G2H2(636),n2h2(504))
  call Hloop_QV_A(ntryL,G0H4(48),ex4(:),G0H2(1),m3h2x2(:,690),heltab2x4(:,:,690))
  call Hloop_Q_A(ntryL,G0H2(1),59,nMM,G1H2(1),n2h2(505))
  call Hloop_AV_Q(ntryL,G1H4(775),ex4(:),G1H2(145),m3h2x2(:,691),heltab2x4(:,:,691))
  call Hloop_A_Q(ntryL,G1H2(145),59,nMM,G2H2(637),n2h2(506))
call HGT_OLR(G1H4(776),1,1,4)
call HGT_invQ_OLR(G1H4(776),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(776),-4,nMM,G2H4(188),n2h4(516))
  call Hloop_QV_A(ntryL,G2H4(188),ex3(:),G2H2(638),m3h2x2(:,692),heltab2x4(:,:,692))
  call Hloop_AV_Q(ntryL,G1H4(781),ex4(:),G1H2(145),m3h2x2(:,693),heltab2x4(:,:,693))
  call Hloop_A_Q(ntryL,G1H2(145),59,nMM,G2H2(639),n2h2(507))
  call Hloop_AV_Q(ntryL,G1H4(786),ex4(:),G1H2(145),m3h2x2(:,694),heltab2x4(:,:,694))
  call Hloop_A_Q(ntryL,G1H2(145),59,nMM,G2H2(640),n2h2(508))
call HGT_OLR(G1H4(782),1,1,4)
call HGT_invQ_OLR(G1H4(782),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(782),-4,nMM,G2H4(189),n2h4(517))
  call Hloop_QV_A(ntryL,G2H4(189),ex3(:),G2H2(641),m3h2x2(:,695),heltab2x4(:,:,695))
  call Hloop_AV_Q(ntryL,G1H4(785),ex4(:),G1H2(145),m3h2x2(:,696),heltab2x4(:,:,696))
  call Hloop_A_Q(ntryL,G1H2(145),59,nMM,G2H2(642),n2h2(509))
  call Hloop_AV_Q(ntryL,G0H4(49),ex4(:),G0H2(1),m3h2x2(:,697),heltab2x4(:,:,697))
  call Hloop_A_Q(ntryL,G0H2(1),59,nMM,G1H2(145),n2h2(510))
call HGT_OLR(G1H4(787),1,1,4)
call HGT_invQ_OLR(G1H4(787),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(787),-12,nMM,G2H4(190),n2h4(518))
  call Hloop_QV_A(ntryL,G2H4(190),ex3(:),G2H2(643),m3h2x2(:,698),heltab2x4(:,:,698))
  call Hloop_AV_Q(ntryL,G1H4(790),ex4(:),G1H2(146),m3h2x2(:,699),heltab2x4(:,:,699))
  call Hloop_A_Q(ntryL,G1H2(146),59,nMM,G2H2(644),n2h2(511))
  call Hloop_AV_Q(ntryL,G0H4(50),ex4(:),G0H2(1),m3h2x2(:,700),heltab2x4(:,:,700))
  call Hloop_A_Q(ntryL,G0H2(1),59,nMM,G1H2(146),n2h2(512))
  call Hloop_QV_A(ntryL,G1H4(791),ex4(:),G1H2(147),m3h2x2(:,701),heltab2x4(:,:,701))
  call Hloop_Q_A(ntryL,G1H2(147),59,0,G2H2(645),n2h2(513))
call HGT_OLR(G1H4(792),1,1,4)
call HGT_invQ_OLR(G1H4(792),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(792),-4,0,G2H4(193),n2h4(519))
  call Hloop_AV_Q(ntryL,G2H4(193),ex3(:),G2H2(646),m3h2x2(:,702),heltab2x4(:,:,702))
  call Hloop_QV_A(ntryL,G1H4(797),ex4(:),G1H2(147),m3h2x2(:,703),heltab2x4(:,:,703))
  call Hloop_Q_A(ntryL,G1H2(147),59,0,G2H2(647),n2h2(514))
  call Hloop_QV_A(ntryL,G1H4(802),ex4(:),G1H2(147),m3h2x2(:,704),heltab2x4(:,:,704))
  call Hloop_Q_A(ntryL,G1H2(147),59,0,G2H2(648),n2h2(515))
call HGT_OLR(G1H4(798),1,1,4)
call HGT_invQ_OLR(G1H4(798),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(798),-4,0,G2H4(194),n2h4(520))
  call Hloop_AV_Q(ntryL,G2H4(194),ex3(:),G2H2(649),m3h2x2(:,705),heltab2x4(:,:,705))
  call Hloop_QV_A(ntryL,G1H4(801),ex4(:),G1H2(147),m3h2x2(:,706),heltab2x4(:,:,706))
  call Hloop_Q_A(ntryL,G1H2(147),59,0,G2H2(650),n2h2(516))
  call Hloop_QV_A(ntryL,G0H4(51),ex4(:),G0H2(1),m3h2x2(:,707),heltab2x4(:,:,707))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(147),n2h2(517))
call HGT_OLR(G1H4(803),1,1,4)
call HGT_invQ_OLR(G1H4(803),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(803),-12,0,G2H4(195),n2h4(521))
  call Hloop_AV_Q(ntryL,G2H4(195),ex3(:),G2H2(651),m3h2x2(:,708),heltab2x4(:,:,708))
  call Hloop_QV_A(ntryL,G1H4(806),ex4(:),G1H2(148),m3h2x2(:,709),heltab2x4(:,:,709))
  call Hloop_Q_A(ntryL,G1H2(148),59,0,G2H2(652),n2h2(518))
  call Hloop_QV_A(ntryL,G0H4(52),ex4(:),G0H2(1),m3h2x2(:,710),heltab2x4(:,:,710))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(148),n2h2(519))
  call Hloop_AV_Q(ntryL,G1H4(807),ex4(:),G1H2(149),m3h2x2(:,711),heltab2x4(:,:,711))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(653),n2h2(520))
call HGT_OLR(G1H4(808),1,1,4)
call HGT_invQ_OLR(G1H4(808),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(808),-4,0,G2H4(198),n2h4(522))
  call Hloop_QV_A(ntryL,G2H4(198),ex3(:),G2H2(654),m3h2x2(:,712),heltab2x4(:,:,712))
  call Hloop_AV_Q(ntryL,G1H4(813),ex4(:),G1H2(149),m3h2x2(:,713),heltab2x4(:,:,713))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(655),n2h2(521))
  call Hloop_AV_Q(ntryL,G1H4(818),ex4(:),G1H2(149),m3h2x2(:,714),heltab2x4(:,:,714))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(656),n2h2(522))
call HGT_OLR(G1H4(814),1,1,4)
call HGT_invQ_OLR(G1H4(814),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(814),-4,0,G2H4(199),n2h4(523))
  call Hloop_QV_A(ntryL,G2H4(199),ex3(:),G2H2(657),m3h2x2(:,715),heltab2x4(:,:,715))
  call Hloop_AV_Q(ntryL,G1H4(817),ex4(:),G1H2(149),m3h2x2(:,716),heltab2x4(:,:,716))
  call Hloop_A_Q(ntryL,G1H2(149),59,0,G2H2(658),n2h2(523))
  call Hloop_AV_Q(ntryL,G0H4(53),ex4(:),G0H2(1),m3h2x2(:,717),heltab2x4(:,:,717))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(149),n2h2(524))
call HGT_OLR(G1H4(819),1,1,4)
call HGT_invQ_OLR(G1H4(819),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(819),-12,0,G2H4(200),n2h4(524))
  call Hloop_QV_A(ntryL,G2H4(200),ex3(:),G2H2(659),m3h2x2(:,718),heltab2x4(:,:,718))
  call Hloop_AV_Q(ntryL,G1H4(822),ex4(:),G1H2(150),m3h2x2(:,719),heltab2x4(:,:,719))
  call Hloop_A_Q(ntryL,G1H2(150),59,0,G2H2(660),n2h2(525))
  call Hloop_AV_Q(ntryL,G0H4(54),ex4(:),G0H2(1),m3h2x2(:,720),heltab2x4(:,:,720))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(150),n2h2(526))
  call Hloop_AV_Q(ntryL,G1H8(160),wf4(:,49),G1H2(151),m3h4x2(:,19),heltab2x8(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(151),47,nME,G2H2(661),n2h2(527))
call HGT_OLR(G1H8(161),1,1,8)
call HGT_invQ_OLR(G1H8(161),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(161),-16,nME,G2H8(47),n2h8(253))
  call Hloop_QV_A(ntryL,G2H8(47),ex5(:),G2H4(203),m3h2x4(:,359),heltab2x8(:,:,378))
  call Hloop_AV_Q(ntryL,G1H8(167),wf4(:,49),G1H2(151),m3h4x2(:,20),heltab2x8(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(151),47,nME,G2H2(662),n2h2(528))
  call Hloop_AV_Q(ntryL,G1H8(173),wf4(:,49),G1H2(151),m3h4x2(:,21),heltab2x8(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(151),47,nME,G2H2(663),n2h2(529))
call HGT_OLR(G1H8(168),1,1,8)
call HGT_invQ_OLR(G1H8(168),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(168),-16,nME,G2H8(4),n2h8(254))
  call Hloop_QV_A(ntryL,G2H8(4),ex5(:),G2H4(204),m3h2x4(:,360),heltab2x8(:,:,381))
  call Hloop_AV_Q(ntryL,G1H8(172),wf4(:,49),G1H2(151),m3h4x2(:,22),heltab2x8(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(151),47,nME,G2H2(664),n2h2(530))
  call Hloop_AV_Q(ntryL,G0H8(1),wf4(:,49),G0H2(1),m3h4x2(:,23),heltab2x8(:,:,383))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(151),n2h2(531))
call HGT_OLR(G1H8(174),1,1,8)
call HGT_invQ_OLR(G1H8(174),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(174),-19,nME,G2H8(5),n2h8(255))
  call Hloop_QV_A(ntryL,G2H8(5),ex5(:),G2H4(205),m3h2x4(:,361),heltab2x8(:,:,384))
  call Hloop_AV_Q(ntryL,G1H8(178),wf4(:,49),G1H2(152),m3h4x2(:,24),heltab2x8(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(152),47,nME,G2H2(665),n2h2(532))
  call Hloop_AV_Q(ntryL,G0H8(2),wf4(:,49),G0H2(1),m3h4x2(:,25),heltab2x8(:,:,386))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(152),n2h2(533))
  call Hloop_AV_Q(ntryL,G1H8(179),wf4(:,49),G1H2(153),m3h4x2(:,26),heltab2x8(:,:,387))
  call Hloop_A_Q(ntryL,G1H2(153),47,nMM,G2H2(666),n2h2(534))
call HGT_OLR(G1H8(180),1,1,8)
call HGT_invQ_OLR(G1H8(180),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(180),-16,nMM,G2H8(6),n2h8(256))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(208),m3h2x4(:,362),heltab2x8(:,:,388))
  call Hloop_AV_Q(ntryL,G1H8(98),wf4(:,49),G1H2(153),m3h4x2(:,27),heltab2x8(:,:,389))
  call Hloop_A_Q(ntryL,G1H2(153),47,nMM,G2H2(667),n2h2(535))
  call Hloop_AV_Q(ntryL,G1H8(108),wf4(:,49),G1H2(153),m3h4x2(:,28),heltab2x8(:,:,390))
  call Hloop_A_Q(ntryL,G1H2(153),47,nMM,G2H2(668),n2h2(536))
call HGT_OLR(G1H8(101),1,1,8)
call HGT_invQ_OLR(G1H8(101),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(101),-16,nMM,G2H8(11),n2h8(257))
  call Hloop_QV_A(ntryL,G2H8(11),ex5(:),G2H4(209),m3h2x4(:,363),heltab2x8(:,:,391))
  call Hloop_AV_Q(ntryL,G1H8(107),wf4(:,49),G1H2(153),m3h4x2(:,29),heltab2x8(:,:,392))
  call Hloop_A_Q(ntryL,G1H2(153),47,nMM,G2H2(669),n2h2(537))
  call Hloop_AV_Q(ntryL,G0H8(3),wf4(:,49),G0H2(1),m3h4x2(:,30),heltab2x8(:,:,393))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(153),n2h2(538))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-19,nMM,G2H8(12),n2h8(258))
  call Hloop_QV_A(ntryL,G2H8(12),ex5(:),G2H4(210),m3h2x4(:,364),heltab2x8(:,:,394))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,49),G1H2(154),m3h4x2(:,31),heltab2x8(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(154),47,nMM,G2H2(670),n2h2(539))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,49),G0H2(1),m3h4x2(:,32),heltab2x8(:,:,396))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(154),n2h2(540))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,49),G1H2(155),m3h4x2(:,33),heltab2x8(:,:,397))
  call Hloop_Q_A(ntryL,G1H2(155),47,nME,G2H2(671),n2h2(541))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(11),-16,nME,G2H8(14),n2h8(259))
  call Hloop_AV_Q(ntryL,G2H8(14),ex5(:),G2H4(213),m3h2x4(:,365),heltab2x8(:,:,398))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,49),G1H2(155),m3h4x2(:,34),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(155),47,nME,G2H2(672),n2h2(542))
  call Hloop_QV_A(ntryL,G1H8(182),wf4(:,49),G1H2(155),m3h4x2(:,35),heltab2x8(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(155),47,nME,G2H2(673),n2h2(543))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,nME,G2H8(18),n2h8(260))
  call Hloop_AV_Q(ntryL,G2H8(18),ex5(:),G2H4(214),m3h2x4(:,366),heltab2x8(:,:,401))
  call Hloop_QV_A(ntryL,G1H8(181),wf4(:,49),G1H2(155),m3h4x2(:,36),heltab2x8(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(155),47,nME,G2H2(674),n2h2(544))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,49),G0H2(1),m3h4x2(:,37),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(155),n2h2(545))
call HGT_OLR(G1H8(184),1,1,8)
call HGT_invQ_OLR(G1H8(184),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(184),-19,nME,G2H8(50),n2h8(261))
  call Hloop_AV_Q(ntryL,G2H8(50),ex5(:),G2H4(215),m3h2x4(:,367),heltab2x8(:,:,404))
  call Hloop_QV_A(ntryL,G1H8(187),wf4(:,49),G1H2(156),m3h4x2(:,38),heltab2x8(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(156),47,nME,G2H2(675),n2h2(546))
  call Hloop_QV_A(ntryL,G0H8(6),wf4(:,49),G0H2(1),m3h4x2(:,39),heltab2x8(:,:,406))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(156),n2h2(547))
  call Hloop_QV_A(ntryL,G1H8(188),wf4(:,49),G1H2(157),m3h4x2(:,40),heltab2x8(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(157),47,nMM,G2H2(676),n2h2(548))
call HGT_OLR(G1H8(190),1,1,8)
call HGT_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(190),-16,nMM,G2H8(52),n2h8(262))
  call Hloop_AV_Q(ntryL,G2H8(52),ex5(:),G2H4(218),m3h2x4(:,368),heltab2x8(:,:,408))
  call Hloop_QV_A(ntryL,G1H8(196),wf4(:,49),G1H2(157),m3h4x2(:,41),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(157),47,nMM,G2H2(677),n2h2(549))
  call Hloop_QV_A(ntryL,G1H8(202),wf4(:,49),G1H2(157),m3h4x2(:,42),heltab2x8(:,:,410))
  call Hloop_Q_A(ntryL,G1H2(157),47,nMM,G2H2(678),n2h2(550))
call HGT_OLR(G1H8(197),1,1,8)
call HGT_invQ_OLR(G1H8(197),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(197),-16,nMM,G2H8(31),n2h8(263))
  call Hloop_AV_Q(ntryL,G2H8(31),ex5(:),G2H4(219),m3h2x4(:,369),heltab2x8(:,:,411))
  call Hloop_QV_A(ntryL,G1H8(200),wf4(:,49),G1H2(157),m3h4x2(:,43),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(157),47,nMM,G2H2(679),n2h2(551))
  call Hloop_QV_A(ntryL,G0H8(7),wf4(:,49),G0H2(1),m3h4x2(:,44),heltab2x8(:,:,413))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(157),n2h2(552))
call HGT_OLR(G1H8(203),1,1,8)
call HGT_invQ_OLR(G1H8(203),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(203),-19,nMM,G2H8(35),n2h8(264))
  call Hloop_AV_Q(ntryL,G2H8(35),ex5(:),G2H4(220),m3h2x4(:,370),heltab2x8(:,:,414))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,49),G1H2(158),m3h4x2(:,45),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(158),47,nMM,G2H2(680),n2h2(553))
  call Hloop_QV_A(ntryL,G0H8(8),wf4(:,49),G0H2(1),m3h4x2(:,46),heltab2x8(:,:,416))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(158),n2h2(554))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,49),G1H2(159),m3h4x2(:,47),heltab2x8(:,:,417))
  call Hloop_A_Q(ntryL,G1H2(159),47,0,G2H2(681),n2h2(555))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-16,0,G2H8(41),n2h8(265))
  call Hloop_QV_A(ntryL,G2H8(41),ex5(:),G2H4(223),m3h2x4(:,371),heltab2x8(:,:,418))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,49),G1H2(159),m3h4x2(:,48),heltab2x8(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(159),47,0,G2H2(682),n2h2(556))
  call Hloop_AV_Q(ntryL,G1H8(50),wf4(:,49),G1H2(159),m3h4x2(:,49),heltab2x8(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(159),47,0,G2H2(683),n2h2(557))
call HGT_OLR(G1H8(43),1,1,8)
call HGT_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(43),-16,0,G2H8(46),n2h8(266))
  call Hloop_QV_A(ntryL,G2H8(46),ex5(:),G2H4(224),m3h2x4(:,372),heltab2x8(:,:,421))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,49),G1H2(159),m3h4x2(:,50),heltab2x8(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(159),47,0,G2H2(684),n2h2(558))
  call Hloop_AV_Q(ntryL,G0H8(9),wf4(:,49),G0H2(1),m3h4x2(:,51),heltab2x8(:,:,423))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(159),n2h2(559))
call HGT_OLR(G1H8(53),1,1,8)
call HGT_invQ_OLR(G1H8(53),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(53),-19,0,G2H8(9),n2h8(267))
  call Hloop_QV_A(ntryL,G2H8(9),ex5(:),G2H4(225),m3h2x4(:,373),heltab2x8(:,:,424))
  call Hloop_AV_Q(ntryL,G1H8(56),wf4(:,49),G1H2(160),m3h4x2(:,52),heltab2x8(:,:,425))
  call Hloop_A_Q(ntryL,G1H2(160),47,0,G2H2(685),n2h2(560))
  call Hloop_AV_Q(ntryL,G0H8(10),wf4(:,49),G0H2(1),m3h4x2(:,53),heltab2x8(:,:,426))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(160),n2h2(561))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,49),G1H2(161),m3h4x2(:,54),heltab2x8(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(161),47,0,G2H2(686),n2h2(562))
call HGT_OLR(G1H8(61),1,1,8)
call HGT_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(61),-16,0,G2H8(51),n2h8(268))
  call Hloop_AV_Q(ntryL,G2H8(51),ex5(:),G2H4(228),m3h2x4(:,374),heltab2x8(:,:,428))
  call Hloop_QV_A(ntryL,G1H8(205),wf4(:,49),G1H2(161),m3h4x2(:,55),heltab2x8(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(161),47,0,G2H2(687),n2h2(563))
  call Hloop_QV_A(ntryL,G1H8(211),wf4(:,49),G1H2(161),m3h4x2(:,56),heltab2x8(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(161),47,0,G2H2(688),n2h2(564))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(206),-16,0,G2H8(33),n2h8(269))
  call Hloop_AV_Q(ntryL,G2H8(33),ex5(:),G2H4(229),m3h2x4(:,375),heltab2x8(:,:,431))
  call Hloop_QV_A(ntryL,G1H8(210),wf4(:,49),G1H2(161),m3h4x2(:,57),heltab2x8(:,:,432))
  call Hloop_Q_A(ntryL,G1H2(161),47,0,G2H2(689),n2h2(565))
  call Hloop_QV_A(ntryL,G0H8(11),wf4(:,49),G0H2(1),m3h4x2(:,58),heltab2x8(:,:,433))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(161),n2h2(566))
call HGT_OLR(G1H8(212),1,1,8)
call HGT_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(212),-19,0,G2H8(1),n2h8(270))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(230),m3h2x4(:,376),heltab2x8(:,:,434))
  call Hloop_QV_A(ntryL,G1H8(216),wf4(:,49),G1H2(162),m3h4x2(:,59),heltab2x8(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(162),47,0,G2H2(690),n2h2(567))
  call Hloop_QV_A(ntryL,G0H8(12),wf4(:,49),G0H2(1),m3h4x2(:,60),heltab2x8(:,:,436))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(162),n2h2(568))
  call Hloop_AV_Q(ntryL,G1H4(823),ex4(:),G1H2(163),m3h2x2(:,721),heltab2x4(:,:,721))
  call Hloop_A_Q(ntryL,G1H2(163),47,nMM,G2H2(691),n2h2(569))
call HGT_OLR(G1H4(824),1,1,4)
call HGT_invQ_OLR(G1H4(824),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(824),-16,nMM,G2H4(233),n2h4(525))
  call Hloop_QV_A(ntryL,G2H4(233),ex5(:),G2H2(692),m3h2x2(:,722),heltab2x4(:,:,722))
  call Hloop_AV_Q(ntryL,G1H4(829),ex4(:),G1H2(163),m3h2x2(:,723),heltab2x4(:,:,723))
  call Hloop_A_Q(ntryL,G1H2(163),47,nMM,G2H2(693),n2h2(570))
  call Hloop_AV_Q(ntryL,G1H4(834),ex4(:),G1H2(163),m3h2x2(:,724),heltab2x4(:,:,724))
  call Hloop_A_Q(ntryL,G1H2(163),47,nMM,G2H2(694),n2h2(571))
call HGT_OLR(G1H4(830),1,1,4)
call HGT_invQ_OLR(G1H4(830),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(830),-16,nMM,G2H4(234),n2h4(526))
  call Hloop_QV_A(ntryL,G2H4(234),ex5(:),G2H2(695),m3h2x2(:,725),heltab2x4(:,:,725))
  call Hloop_AV_Q(ntryL,G1H4(833),ex4(:),G1H2(163),m3h2x2(:,726),heltab2x4(:,:,726))
  call Hloop_A_Q(ntryL,G1H2(163),47,nMM,G2H2(696),n2h2(572))
  call Hloop_AV_Q(ntryL,G0H4(55),ex4(:),G0H2(1),m3h2x2(:,727),heltab2x4(:,:,727))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(163),n2h2(573))
call HGT_OLR(G1H4(835),1,1,4)
call HGT_invQ_OLR(G1H4(835),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(835),-24,nMM,G2H4(235),n2h4(527))
  call Hloop_QV_A(ntryL,G2H4(235),ex5(:),G2H2(697),m3h2x2(:,728),heltab2x4(:,:,728))
  call Hloop_AV_Q(ntryL,G1H4(838),ex4(:),G1H2(164),m3h2x2(:,729),heltab2x4(:,:,729))
  call Hloop_A_Q(ntryL,G1H2(164),47,nMM,G2H2(698),n2h2(574))
  call Hloop_AV_Q(ntryL,G0H4(56),ex4(:),G0H2(1),m3h2x2(:,730),heltab2x4(:,:,730))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(164),n2h2(575))
  call Hloop_QV_A(ntryL,G1H4(839),ex4(:),G1H2(165),m3h2x2(:,731),heltab2x4(:,:,731))
  call Hloop_Q_A(ntryL,G1H2(165),47,nMM,G2H2(699),n2h2(576))
call HGT_OLR(G1H4(840),1,1,4)
call HGT_invQ_OLR(G1H4(840),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(840),-16,nMM,G2H4(238),n2h4(528))
  call Hloop_AV_Q(ntryL,G2H4(238),ex5(:),G2H2(700),m3h2x2(:,732),heltab2x4(:,:,732))
  call Hloop_QV_A(ntryL,G1H4(845),ex4(:),G1H2(165),m3h2x2(:,733),heltab2x4(:,:,733))
  call Hloop_Q_A(ntryL,G1H2(165),47,nMM,G2H2(701),n2h2(577))
  call Hloop_QV_A(ntryL,G1H4(850),ex4(:),G1H2(165),m3h2x2(:,734),heltab2x4(:,:,734))
  call Hloop_Q_A(ntryL,G1H2(165),47,nMM,G2H2(702),n2h2(578))
call HGT_OLR(G1H4(846),1,1,4)
call HGT_invQ_OLR(G1H4(846),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(846),-16,nMM,G2H4(239),n2h4(529))
  call Hloop_AV_Q(ntryL,G2H4(239),ex5(:),G2H2(703),m3h2x2(:,735),heltab2x4(:,:,735))
  call Hloop_QV_A(ntryL,G1H4(849),ex4(:),G1H2(165),m3h2x2(:,736),heltab2x4(:,:,736))
  call Hloop_Q_A(ntryL,G1H2(165),47,nMM,G2H2(704),n2h2(579))
  call Hloop_QV_A(ntryL,G0H4(57),ex4(:),G0H2(1),m3h2x2(:,737),heltab2x4(:,:,737))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(165),n2h2(580))
call HGT_OLR(G1H4(851),1,1,4)
call HGT_invQ_OLR(G1H4(851),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(851),-24,nMM,G2H4(240),n2h4(530))
  call Hloop_AV_Q(ntryL,G2H4(240),ex5(:),G2H2(705),m3h2x2(:,738),heltab2x4(:,:,738))
  call Hloop_QV_A(ntryL,G1H4(854),ex4(:),G1H2(166),m3h2x2(:,739),heltab2x4(:,:,739))
  call Hloop_Q_A(ntryL,G1H2(166),47,nMM,G2H2(706),n2h2(581))
  call Hloop_QV_A(ntryL,G0H4(58),ex4(:),G0H2(1),m3h2x2(:,740),heltab2x4(:,:,740))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(166),n2h2(582))
  call Hloop_AV_Q(ntryL,G1H4(855),ex4(:),G1H2(167),m3h2x2(:,741),heltab2x4(:,:,741))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(707),n2h2(583))
call HGT_OLR(G1H4(856),1,1,4)
call HGT_invQ_OLR(G1H4(856),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(856),-16,0,G2H4(243),n2h4(531))
  call Hloop_QV_A(ntryL,G2H4(243),ex5(:),G2H2(708),m3h2x2(:,742),heltab2x4(:,:,742))
  call Hloop_AV_Q(ntryL,G1H4(861),ex4(:),G1H2(167),m3h2x2(:,743),heltab2x4(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(709),n2h2(584))
  call Hloop_AV_Q(ntryL,G1H4(866),ex4(:),G1H2(167),m3h2x2(:,744),heltab2x4(:,:,744))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(710),n2h2(585))
call HGT_OLR(G1H4(862),1,1,4)
call HGT_invQ_OLR(G1H4(862),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(862),-16,0,G2H4(244),n2h4(532))
  call Hloop_QV_A(ntryL,G2H4(244),ex5(:),G2H2(711),m3h2x2(:,745),heltab2x4(:,:,745))
  call Hloop_AV_Q(ntryL,G1H4(865),ex4(:),G1H2(167),m3h2x2(:,746),heltab2x4(:,:,746))
  call Hloop_A_Q(ntryL,G1H2(167),47,0,G2H2(712),n2h2(586))
  call Hloop_AV_Q(ntryL,G0H4(59),ex4(:),G0H2(1),m3h2x2(:,747),heltab2x4(:,:,747))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(167),n2h2(587))
call HGT_OLR(G1H4(867),1,1,4)
call HGT_invQ_OLR(G1H4(867),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(867),-24,0,G2H4(245),n2h4(533))
  call Hloop_QV_A(ntryL,G2H4(245),ex5(:),G2H2(713),m3h2x2(:,748),heltab2x4(:,:,748))
  call Hloop_AV_Q(ntryL,G1H4(870),ex4(:),G1H2(168),m3h2x2(:,749),heltab2x4(:,:,749))
  call Hloop_A_Q(ntryL,G1H2(168),47,0,G2H2(714),n2h2(588))
  call Hloop_AV_Q(ntryL,G0H4(60),ex4(:),G0H2(1),m3h2x2(:,750),heltab2x4(:,:,750))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(168),n2h2(589))
  call Hloop_QV_A(ntryL,G1H4(871),ex4(:),G1H2(169),m3h2x2(:,751),heltab2x4(:,:,751))
  call Hloop_Q_A(ntryL,G1H2(169),47,0,G2H2(715),n2h2(590))
call HGT_OLR(G1H4(872),1,1,4)
call HGT_invQ_OLR(G1H4(872),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(872),-16,0,G2H4(248),n2h4(534))
  call Hloop_AV_Q(ntryL,G2H4(248),ex5(:),G2H2(716),m3h2x2(:,752),heltab2x4(:,:,752))
  call Hloop_QV_A(ntryL,G1H4(877),ex4(:),G1H2(169),m3h2x2(:,753),heltab2x4(:,:,753))
  call Hloop_Q_A(ntryL,G1H2(169),47,0,G2H2(717),n2h2(591))
  call Hloop_QV_A(ntryL,G1H4(882),ex4(:),G1H2(169),m3h2x2(:,754),heltab2x4(:,:,754))
  call Hloop_Q_A(ntryL,G1H2(169),47,0,G2H2(718),n2h2(592))
call HGT_OLR(G1H4(878),1,1,4)
call HGT_invQ_OLR(G1H4(878),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(878),-16,0,G2H4(249),n2h4(535))
  call Hloop_AV_Q(ntryL,G2H4(249),ex5(:),G2H2(719),m3h2x2(:,755),heltab2x4(:,:,755))
  call Hloop_QV_A(ntryL,G1H4(881),ex4(:),G1H2(169),m3h2x2(:,756),heltab2x4(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(169),47,0,G2H2(720),n2h2(593))
  call Hloop_QV_A(ntryL,G0H4(61),ex4(:),G0H2(1),m3h2x2(:,757),heltab2x4(:,:,757))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(169),n2h2(594))
call HGT_OLR(G1H4(883),1,1,4)
call HGT_invQ_OLR(G1H4(883),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(883),-24,0,G2H4(250),n2h4(536))
  call Hloop_AV_Q(ntryL,G2H4(250),ex5(:),G2H2(721),m3h2x2(:,758),heltab2x4(:,:,758))
  call Hloop_QV_A(ntryL,G1H4(886),ex4(:),G1H2(170),m3h2x2(:,759),heltab2x4(:,:,759))
  call Hloop_Q_A(ntryL,G1H2(170),47,0,G2H2(722),n2h2(595))
  call Hloop_QV_A(ntryL,G0H4(62),ex4(:),G0H2(1),m3h2x2(:,760),heltab2x4(:,:,760))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(170),n2h2(596))
  call Hloop_QV_A(ntryL,G1H8(217),wf4(:,49),G1H2(171),m3h4x2(:,61),heltab2x8(:,:,437))
  call Hloop_Q_A(ntryL,G1H2(171),47,nME,G2H2(723),n2h2(597))
call HGT_OLR(G1H8(218),1,1,8)
call HGT_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(218),-16,nME,G2H8(29),n2h8(271))
  call Hloop_AV_Q(ntryL,G2H8(29),ex5(:),G2H4(253),m3h2x4(:,377),heltab2x8(:,:,438))
  call Hloop_QV_A(ntryL,G1H8(224),wf4(:,49),G1H2(171),m3h4x2(:,62),heltab2x8(:,:,439))
  call Hloop_Q_A(ntryL,G1H2(171),47,nME,G2H2(724),n2h2(598))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,49),G1H2(171),m3h4x2(:,63),heltab2x8(:,:,440))
  call Hloop_Q_A(ntryL,G1H2(171),47,nME,G2H2(725),n2h2(599))
call HGT_OLR(G1H8(226),1,1,8)
call HGT_invQ_OLR(G1H8(226),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(226),-16,nME,G2H8(22),n2h8(272))
  call Hloop_AV_Q(ntryL,G2H8(22),ex5(:),G2H4(254),m3h2x4(:,378),heltab2x8(:,:,441))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,49),G1H2(171),m3h4x2(:,64),heltab2x8(:,:,442))
  call Hloop_Q_A(ntryL,G1H2(171),47,nME,G2H2(726),n2h2(600))
  call Hloop_QV_A(ntryL,G0H8(13),wf4(:,49),G0H2(1),m3h4x2(:,65),heltab2x8(:,:,443))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(171),n2h2(601))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(28),-19,nME,G2H8(23),n2h8(273))
  call Hloop_AV_Q(ntryL,G2H8(23),ex5(:),G2H4(255),m3h2x4(:,379),heltab2x8(:,:,444))
  call Hloop_QV_A(ntryL,G1H8(46),wf4(:,49),G1H2(172),m3h4x2(:,66),heltab2x8(:,:,445))
  call Hloop_Q_A(ntryL,G1H2(172),47,nME,G2H2(727),n2h2(602))
  call Hloop_QV_A(ntryL,G0H8(14),wf4(:,49),G0H2(1),m3h4x2(:,67),heltab2x8(:,:,446))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(172),n2h2(603))
  call Hloop_QV_A(ntryL,G1H8(51),wf4(:,49),G1H2(173),m3h4x2(:,68),heltab2x8(:,:,447))
  call Hloop_Q_A(ntryL,G1H2(173),47,nMM,G2H2(728),n2h2(604))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(52),-16,nMM,G2H8(24),n2h8(274))
  call Hloop_AV_Q(ntryL,G2H8(24),ex5(:),G2H4(258),m3h2x4(:,380),heltab2x8(:,:,448))
  call Hloop_QV_A(ntryL,G1H8(75),wf4(:,49),G1H2(173),m3h4x2(:,69),heltab2x8(:,:,449))
  call Hloop_Q_A(ntryL,G1H2(173),47,nMM,G2H2(729),n2h2(605))
  call Hloop_QV_A(ntryL,G1H8(93),wf4(:,49),G1H2(173),m3h4x2(:,70),heltab2x8(:,:,450))
  call Hloop_Q_A(ntryL,G1H2(173),47,nMM,G2H2(730),n2h2(606))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(76),-16,nMM,G2H8(32),n2h8(275))
  call Hloop_AV_Q(ntryL,G2H8(32),ex5(:),G2H4(259),m3h2x4(:,381),heltab2x8(:,:,451))
  call Hloop_QV_A(ntryL,G1H8(88),wf4(:,49),G1H2(173),m3h4x2(:,71),heltab2x8(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(173),47,nMM,G2H2(731),n2h2(607))
  call Hloop_QV_A(ntryL,G0H8(15),wf4(:,49),G0H2(1),m3h4x2(:,72),heltab2x8(:,:,453))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(173),n2h2(608))
call HGT_OLR(G1H8(94),1,1,8)
call HGT_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(94),-19,nMM,G2H8(34),n2h8(276))
  call Hloop_AV_Q(ntryL,G2H8(34),ex5(:),G2H4(260),m3h2x4(:,382),heltab2x8(:,:,454))
  call Hloop_QV_A(ntryL,G1H8(106),wf4(:,49),G1H2(174),m3h4x2(:,73),heltab2x8(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(174),47,nMM,G2H2(732),n2h2(609))
  call Hloop_QV_A(ntryL,G0H8(16),wf4(:,49),G0H2(1),m3h4x2(:,74),heltab2x8(:,:,456))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(174),n2h2(610))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,49),G1H2(175),m3h4x2(:,75),heltab2x8(:,:,457))
  call Hloop_A_Q(ntryL,G1H2(175),47,nME,G2H2(733),n2h2(611))
call HGT_OLR(G1H8(72),1,1,8)
call HGT_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(72),-16,nME,G2H8(37),n2h8(277))
  call Hloop_QV_A(ntryL,G2H8(37),ex5(:),G2H4(263),m3h2x4(:,383),heltab2x8(:,:,458))
  call Hloop_AV_Q(ntryL,G1H8(234),wf4(:,49),G1H2(175),m3h4x2(:,76),heltab2x8(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(175),47,nME,G2H2(734),n2h2(612))
  call Hloop_AV_Q(ntryL,G1H8(240),wf4(:,49),G1H2(175),m3h4x2(:,77),heltab2x8(:,:,460))
  call Hloop_A_Q(ntryL,G1H2(175),47,nME,G2H2(735),n2h2(613))
call HGT_OLR(G1H8(235),1,1,8)
call HGT_invQ_OLR(G1H8(235),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(235),-16,nME,G2H8(44),n2h8(278))
  call Hloop_QV_A(ntryL,G2H8(44),ex5(:),G2H4(264),m3h2x4(:,384),heltab2x8(:,:,461))
  call Hloop_AV_Q(ntryL,G1H8(239),wf4(:,49),G1H2(175),m3h4x2(:,78),heltab2x8(:,:,462))
  call Hloop_A_Q(ntryL,G1H2(175),47,nME,G2H2(736),n2h2(614))
  call Hloop_AV_Q(ntryL,G0H8(17),wf4(:,49),G0H2(1),m3h4x2(:,79),heltab2x8(:,:,463))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(175),n2h2(615))
call HGT_OLR(G1H8(241),1,1,8)
call HGT_invQ_OLR(G1H8(241),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(241),-19,nME,G2H8(7),n2h8(279))
  call Hloop_QV_A(ntryL,G2H8(7),ex5(:),G2H4(265),m3h2x4(:,385),heltab2x8(:,:,464))
  call Hloop_AV_Q(ntryL,G1H8(245),wf4(:,49),G1H2(176),m3h4x2(:,80),heltab2x8(:,:,465))
  call Hloop_A_Q(ntryL,G1H2(176),47,nME,G2H2(737),n2h2(616))
  call Hloop_AV_Q(ntryL,G0H8(18),wf4(:,49),G0H2(1),m3h4x2(:,81),heltab2x8(:,:,466))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(176),n2h2(617))
  call Hloop_AV_Q(ntryL,G1H8(246),wf4(:,49),G1H2(177),m3h4x2(:,82),heltab2x8(:,:,467))
  call Hloop_A_Q(ntryL,G1H2(177),47,nMM,G2H2(738),n2h2(618))
call HGT_OLR(G1H8(247),1,1,8)
call HGT_invQ_OLR(G1H8(247),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(247),-16,nMM,G2H8(49),n2h8(280))
  call Hloop_QV_A(ntryL,G2H8(49),ex5(:),G2H4(268),m3h2x4(:,386),heltab2x8(:,:,468))
  call Hloop_AV_Q(ntryL,G1H8(65),wf4(:,49),G1H2(177),m3h4x2(:,83),heltab2x8(:,:,469))
  call Hloop_A_Q(ntryL,G1H2(177),47,nMM,G2H2(739),n2h2(619))
  call Hloop_AV_Q(ntryL,G1H8(71),wf4(:,49),G1H2(177),m3h4x2(:,84),heltab2x8(:,:,470))
  call Hloop_A_Q(ntryL,G1H2(177),47,nMM,G2H2(740),n2h2(620))
call HGT_OLR(G1H8(15),1,1,8)
call HGT_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(15),-16,nMM,G2H8(55),n2h8(281))
  call Hloop_QV_A(ntryL,G2H8(55),ex5(:),G2H4(269),m3h2x4(:,387),heltab2x8(:,:,471))
  call Hloop_AV_Q(ntryL,G1H8(84),wf4(:,49),G1H2(177),m3h4x2(:,85),heltab2x8(:,:,472))
  call Hloop_A_Q(ntryL,G1H2(177),47,nMM,G2H2(741),n2h2(621))
  call Hloop_AV_Q(ntryL,G0H8(19),wf4(:,49),G0H2(1),m3h4x2(:,86),heltab2x8(:,:,473))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(177),n2h2(622))
call HGT_OLR(G1H8(39),1,1,8)
call HGT_invQ_OLR(G1H8(39),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(39),-19,nMM,G2H8(56),n2h8(282))
  call Hloop_QV_A(ntryL,G2H8(56),ex5(:),G2H4(270),m3h2x4(:,388),heltab2x8(:,:,474))
  call Hloop_AV_Q(ntryL,G1H8(86),wf4(:,49),G1H2(178),m3h4x2(:,87),heltab2x8(:,:,475))
  call Hloop_A_Q(ntryL,G1H2(178),47,nMM,G2H2(742),n2h2(623))
  call Hloop_AV_Q(ntryL,G0H8(20),wf4(:,49),G0H2(1),m3h4x2(:,88),heltab2x8(:,:,476))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(178),n2h2(624))
  call Hloop_QV_A(ntryL,G1H8(68),wf4(:,49),G1H2(179),m3h4x2(:,89),heltab2x8(:,:,477))
  call Hloop_Q_A(ntryL,G1H2(179),47,0,G2H2(743),n2h2(625))
call HGT_OLR(G1H8(89),1,1,8)
call HGT_invQ_OLR(G1H8(89),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(89),-16,0,G2H8(57),n2h8(283))
  call Hloop_AV_Q(ntryL,G2H8(57),ex5(:),G2H4(273),m3h2x4(:,389),heltab2x8(:,:,478))
  call Hloop_QV_A(ntryL,G1H8(79),wf4(:,49),G1H2(179),m3h4x2(:,90),heltab2x8(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(179),47,0,G2H2(744),n2h2(626))
  call Hloop_QV_A(ntryL,G1H8(113),wf4(:,49),G1H2(179),m3h4x2(:,91),heltab2x8(:,:,480))
  call Hloop_Q_A(ntryL,G1H2(179),47,0,G2H2(745),n2h2(627))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-16,0,G2H8(60),n2h8(284))
  call Hloop_AV_Q(ntryL,G2H8(60),ex5(:),G2H4(274),m3h2x4(:,390),heltab2x8(:,:,481))
  call Hloop_QV_A(ntryL,G1H8(112),wf4(:,49),G1H2(179),m3h4x2(:,92),heltab2x8(:,:,482))
  call Hloop_Q_A(ntryL,G1H2(179),47,0,G2H2(746),n2h2(628))
  call Hloop_QV_A(ntryL,G0H8(21),wf4(:,49),G0H2(1),m3h4x2(:,93),heltab2x8(:,:,483))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(179),n2h2(629))
call HGT_OLR(G1H8(114),1,1,8)
call HGT_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(114),-19,0,G2H8(61),n2h8(285))
  call Hloop_AV_Q(ntryL,G2H8(61),ex5(:),G2H4(275),m3h2x4(:,391),heltab2x8(:,:,484))
  call Hloop_QV_A(ntryL,G1H8(254),wf4(:,49),G1H2(180),m3h4x2(:,94),heltab2x8(:,:,485))
  call Hloop_Q_A(ntryL,G1H2(180),47,0,G2H2(747),n2h2(630))
  call Hloop_QV_A(ntryL,G0H8(22),wf4(:,49),G0H2(1),m3h4x2(:,95),heltab2x8(:,:,486))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(180),n2h2(631))
  call Hloop_AV_Q(ntryL,G1H8(255),wf4(:,49),G1H2(181),m3h4x2(:,96),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G1H2(181),47,0,G2H2(748),n2h2(632))
call HGT_OLR(G1H8(256),1,1,8)
call HGT_invQ_OLR(G1H8(256),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(256),-16,0,G2H8(62),n2h8(286))
  call Hloop_QV_A(ntryL,G2H8(62),ex5(:),G2H4(278),m3h2x4(:,392),heltab2x8(:,:,488))
  call Hloop_AV_Q(ntryL,G1H8(261),wf4(:,49),G1H2(181),m3h4x2(:,97),heltab2x8(:,:,489))
  call Hloop_A_Q(ntryL,G1H2(181),47,0,G2H2(749),n2h2(633))
  call Hloop_AV_Q(ntryL,G1H8(266),wf4(:,49),G1H2(181),m3h4x2(:,98),heltab2x8(:,:,490))
  call Hloop_A_Q(ntryL,G1H2(181),47,0,G2H2(750),n2h2(634))
call HGT_OLR(G1H8(262),1,1,8)
call HGT_invQ_OLR(G1H8(262),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(262),-16,0,G2H8(65),n2h8(287))
  call Hloop_QV_A(ntryL,G2H8(65),ex5(:),G2H4(279),m3h2x4(:,393),heltab2x8(:,:,491))
  call Hloop_AV_Q(ntryL,G1H8(265),wf4(:,49),G1H2(181),m3h4x2(:,99),heltab2x8(:,:,492))
  call Hloop_A_Q(ntryL,G1H2(181),47,0,G2H2(751),n2h2(635))
  call Hloop_AV_Q(ntryL,G0H8(23),wf4(:,49),G0H2(1),m3h4x2(:,100),heltab2x8(:,:,493))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(181),n2h2(636))
call HGT_OLR(G1H8(267),1,1,8)
call HGT_invQ_OLR(G1H8(267),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(267),-19,0,G2H8(66),n2h8(288))
  call Hloop_QV_A(ntryL,G2H8(66),ex5(:),G2H4(280),m3h2x4(:,394),heltab2x8(:,:,494))
  call Hloop_AV_Q(ntryL,G1H8(270),wf4(:,49),G1H2(182),m3h4x2(:,101),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(182),47,0,G2H2(752),n2h2(637))
  call Hloop_AV_Q(ntryL,G0H8(24),wf4(:,49),G0H2(1),m3h4x2(:,102),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(182),n2h2(638))
  call Hloop_QV_A(ntryL,G1H4(887),ex5(:),G1H2(183),m3h2x2(:,761),heltab2x4(:,:,761))
  call Hloop_Q_A(ntryL,G1H2(183),59,nMM,G2H2(753),n2h2(639))
call HGT_OLR(G1H4(888),1,1,4)
call HGT_invQ_OLR(G1H4(888),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(888),-4,nMM,G2H4(283),n2h4(537))
  call Hloop_AV_Q(ntryL,G2H4(283),ex3(:),G2H2(754),m3h2x2(:,762),heltab2x4(:,:,762))
  call Hloop_QV_A(ntryL,G1H4(893),ex5(:),G1H2(183),m3h2x2(:,763),heltab2x4(:,:,763))
  call Hloop_Q_A(ntryL,G1H2(183),59,nMM,G2H2(755),n2h2(640))
  call Hloop_QV_A(ntryL,G1H4(898),ex5(:),G1H2(183),m3h2x2(:,764),heltab2x4(:,:,764))
  call Hloop_Q_A(ntryL,G1H2(183),59,nMM,G2H2(756),n2h2(641))
call HGT_OLR(G1H4(894),1,1,4)
call HGT_invQ_OLR(G1H4(894),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(894),-4,nMM,G2H4(284),n2h4(538))
  call Hloop_AV_Q(ntryL,G2H4(284),ex3(:),G2H2(757),m3h2x2(:,765),heltab2x4(:,:,765))
  call Hloop_QV_A(ntryL,G1H4(897),ex5(:),G1H2(183),m3h2x2(:,766),heltab2x4(:,:,766))
  call Hloop_Q_A(ntryL,G1H2(183),59,nMM,G2H2(758),n2h2(642))
  call Hloop_QV_A(ntryL,G0H4(63),ex5(:),G0H2(1),m3h2x2(:,767),heltab2x4(:,:,767))
  call Hloop_Q_A(ntryL,G0H2(1),59,nMM,G1H2(183),n2h2(643))
call HGT_OLR(G1H4(899),1,1,4)
call HGT_invQ_OLR(G1H4(899),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(899),-20,nMM,G2H4(285),n2h4(539))
  call Hloop_AV_Q(ntryL,G2H4(285),ex3(:),G2H2(759),m3h2x2(:,768),heltab2x4(:,:,768))
  call Hloop_QV_A(ntryL,G1H4(902),ex5(:),G1H2(184),m3h2x2(:,769),heltab2x4(:,:,769))
  call Hloop_Q_A(ntryL,G1H2(184),59,nMM,G2H2(760),n2h2(644))
  call Hloop_QV_A(ntryL,G0H4(64),ex5(:),G0H2(1),m3h2x2(:,770),heltab2x4(:,:,770))
  call Hloop_Q_A(ntryL,G0H2(1),59,nMM,G1H2(184),n2h2(645))
  call Hloop_AV_Q(ntryL,G1H4(903),ex5(:),G1H2(185),m3h2x2(:,771),heltab2x4(:,:,771))
  call Hloop_A_Q(ntryL,G1H2(185),59,nMM,G2H2(761),n2h2(646))
call HGT_OLR(G1H4(904),1,1,4)
call HGT_invQ_OLR(G1H4(904),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(904),-4,nMM,G2H4(288),n2h4(540))
  call Hloop_QV_A(ntryL,G2H4(288),ex3(:),G2H2(762),m3h2x2(:,772),heltab2x4(:,:,772))
  call Hloop_AV_Q(ntryL,G1H4(909),ex5(:),G1H2(185),m3h2x2(:,773),heltab2x4(:,:,773))
  call Hloop_A_Q(ntryL,G1H2(185),59,nMM,G2H2(763),n2h2(647))
  call Hloop_AV_Q(ntryL,G1H4(914),ex5(:),G1H2(185),m3h2x2(:,774),heltab2x4(:,:,774))
  call Hloop_A_Q(ntryL,G1H2(185),59,nMM,G2H2(764),n2h2(648))
call HGT_OLR(G1H4(910),1,1,4)
call HGT_invQ_OLR(G1H4(910),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(910),-4,nMM,G2H4(289),n2h4(541))
  call Hloop_QV_A(ntryL,G2H4(289),ex3(:),G2H2(765),m3h2x2(:,775),heltab2x4(:,:,775))
  call Hloop_AV_Q(ntryL,G1H4(913),ex5(:),G1H2(185),m3h2x2(:,776),heltab2x4(:,:,776))
  call Hloop_A_Q(ntryL,G1H2(185),59,nMM,G2H2(766),n2h2(649))
  call Hloop_AV_Q(ntryL,G0H4(65),ex5(:),G0H2(1),m3h2x2(:,777),heltab2x4(:,:,777))
  call Hloop_A_Q(ntryL,G0H2(1),59,nMM,G1H2(185),n2h2(650))
call HGT_OLR(G1H4(915),1,1,4)
call HGT_invQ_OLR(G1H4(915),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(915),-20,nMM,G2H4(290),n2h4(542))
  call Hloop_QV_A(ntryL,G2H4(290),ex3(:),G2H2(767),m3h2x2(:,778),heltab2x4(:,:,778))
  call Hloop_AV_Q(ntryL,G1H4(918),ex5(:),G1H2(186),m3h2x2(:,779),heltab2x4(:,:,779))
  call Hloop_A_Q(ntryL,G1H2(186),59,nMM,G2H2(768),n2h2(651))
  call Hloop_AV_Q(ntryL,G0H4(66),ex5(:),G0H2(1),m3h2x2(:,780),heltab2x4(:,:,780))
  call Hloop_A_Q(ntryL,G0H2(1),59,nMM,G1H2(186),n2h2(652))
  call Hloop_QV_A(ntryL,G1H4(919),ex5(:),G1H2(187),m3h2x2(:,781),heltab2x4(:,:,781))
  call Hloop_Q_A(ntryL,G1H2(187),59,0,G2H2(769),n2h2(653))
call HGT_OLR(G1H4(920),1,1,4)
call HGT_invQ_OLR(G1H4(920),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(920),-4,0,G2H4(293),n2h4(543))
  call Hloop_AV_Q(ntryL,G2H4(293),ex3(:),G2H2(770),m3h2x2(:,782),heltab2x4(:,:,782))
  call Hloop_QV_A(ntryL,G1H4(925),ex5(:),G1H2(187),m3h2x2(:,783),heltab2x4(:,:,783))
  call Hloop_Q_A(ntryL,G1H2(187),59,0,G2H2(771),n2h2(654))
  call Hloop_QV_A(ntryL,G1H4(930),ex5(:),G1H2(187),m3h2x2(:,784),heltab2x4(:,:,784))
  call Hloop_Q_A(ntryL,G1H2(187),59,0,G2H2(772),n2h2(655))
call HGT_OLR(G1H4(926),1,1,4)
call HGT_invQ_OLR(G1H4(926),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(926),-4,0,G2H4(294),n2h4(544))
  call Hloop_AV_Q(ntryL,G2H4(294),ex3(:),G2H2(773),m3h2x2(:,785),heltab2x4(:,:,785))
  call Hloop_QV_A(ntryL,G1H4(929),ex5(:),G1H2(187),m3h2x2(:,786),heltab2x4(:,:,786))
  call Hloop_Q_A(ntryL,G1H2(187),59,0,G2H2(774),n2h2(656))
  call Hloop_QV_A(ntryL,G0H4(67),ex5(:),G0H2(1),m3h2x2(:,787),heltab2x4(:,:,787))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(187),n2h2(657))
call HGT_OLR(G1H4(931),1,1,4)
call HGT_invQ_OLR(G1H4(931),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(931),-20,0,G2H4(295),n2h4(545))
  call Hloop_AV_Q(ntryL,G2H4(295),ex3(:),G2H2(775),m3h2x2(:,788),heltab2x4(:,:,788))
  call Hloop_QV_A(ntryL,G1H4(934),ex5(:),G1H2(188),m3h2x2(:,789),heltab2x4(:,:,789))
  call Hloop_Q_A(ntryL,G1H2(188),59,0,G2H2(776),n2h2(658))
  call Hloop_QV_A(ntryL,G0H4(68),ex5(:),G0H2(1),m3h2x2(:,790),heltab2x4(:,:,790))
  call Hloop_Q_A(ntryL,G0H2(1),59,0,G1H2(188),n2h2(659))
  call Hloop_AV_Q(ntryL,G1H4(935),ex5(:),G1H2(189),m3h2x2(:,791),heltab2x4(:,:,791))
  call Hloop_A_Q(ntryL,G1H2(189),59,0,G2H2(777),n2h2(660))
call HGT_OLR(G1H4(936),1,1,4)
call HGT_invQ_OLR(G1H4(936),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(936),-4,0,G2H4(298),n2h4(546))
  call Hloop_QV_A(ntryL,G2H4(298),ex3(:),G2H2(778),m3h2x2(:,792),heltab2x4(:,:,792))
  call Hloop_AV_Q(ntryL,G1H4(941),ex5(:),G1H2(189),m3h2x2(:,793),heltab2x4(:,:,793))
  call Hloop_A_Q(ntryL,G1H2(189),59,0,G2H2(779),n2h2(661))
  call Hloop_AV_Q(ntryL,G1H4(946),ex5(:),G1H2(189),m3h2x2(:,794),heltab2x4(:,:,794))
  call Hloop_A_Q(ntryL,G1H2(189),59,0,G2H2(780),n2h2(662))
call HGT_OLR(G1H4(942),1,1,4)
call HGT_invQ_OLR(G1H4(942),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(942),-4,0,G2H4(299),n2h4(547))
  call Hloop_QV_A(ntryL,G2H4(299),ex3(:),G2H2(781),m3h2x2(:,795),heltab2x4(:,:,795))
  call Hloop_AV_Q(ntryL,G1H4(945),ex5(:),G1H2(189),m3h2x2(:,796),heltab2x4(:,:,796))
  call Hloop_A_Q(ntryL,G1H2(189),59,0,G2H2(782),n2h2(663))
  call Hloop_AV_Q(ntryL,G0H4(69),ex5(:),G0H2(1),m3h2x2(:,797),heltab2x4(:,:,797))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(189),n2h2(664))
call HGT_OLR(G1H4(947),1,1,4)
call HGT_invQ_OLR(G1H4(947),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(947),-20,0,G2H4(300),n2h4(548))
  call Hloop_QV_A(ntryL,G2H4(300),ex3(:),G2H2(783),m3h2x2(:,798),heltab2x4(:,:,798))
  call Hloop_AV_Q(ntryL,G1H4(950),ex5(:),G1H2(190),m3h2x2(:,799),heltab2x4(:,:,799))
  call Hloop_A_Q(ntryL,G1H2(190),59,0,G2H2(784),n2h2(665))
  call Hloop_AV_Q(ntryL,G0H4(70),ex5(:),G0H2(1),m3h2x2(:,800),heltab2x4(:,:,800))
  call Hloop_A_Q(ntryL,G0H2(1),59,0,G1H2(190),n2h2(666))
  call Hloop_AV_Q(ntryL,G1H8(271),wf4(:,49),G1H2(191),m3h4x2(:,103),heltab2x8(:,:,497))
  call Hloop_A_Q(ntryL,G1H2(191),55,nME,G2H2(785),n2h2(667))
call HGT_OLR(G1H8(272),1,1,8)
call HGT_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(272),-8,nME,G2H8(67),n2h8(289))
  call Hloop_QV_A(ntryL,G2H8(67),ex4(:),G2H4(303),m3h2x4(:,395),heltab2x8(:,:,498))
  call Hloop_AV_Q(ntryL,G1H8(277),wf4(:,49),G1H2(191),m3h4x2(:,104),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(191),55,nME,G2H2(786),n2h2(668))
  call Hloop_AV_Q(ntryL,G1H8(282),wf4(:,49),G1H2(191),m3h4x2(:,105),heltab2x8(:,:,500))
  call Hloop_A_Q(ntryL,G1H2(191),55,nME,G2H2(787),n2h2(669))
call HGT_OLR(G1H8(278),1,1,8)
call HGT_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(278),-8,nME,G2H8(70),n2h8(290))
  call Hloop_QV_A(ntryL,G2H8(70),ex4(:),G2H4(304),m3h2x4(:,396),heltab2x8(:,:,501))
  call Hloop_AV_Q(ntryL,G1H8(281),wf4(:,49),G1H2(191),m3h4x2(:,106),heltab2x8(:,:,502))
  call Hloop_A_Q(ntryL,G1H2(191),55,nME,G2H2(788),n2h2(670))
  call Hloop_AV_Q(ntryL,G0H8(25),wf4(:,49),G0H2(1),m3h4x2(:,107),heltab2x8(:,:,503))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(191),n2h2(671))
call HGT_OLR(G1H8(283),1,1,8)
call HGT_invQ_OLR(G1H8(283),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(283),-11,nME,G2H8(71),n2h8(291))
  call Hloop_QV_A(ntryL,G2H8(71),ex4(:),G2H4(308),m3h2x4(:,397),heltab2x8(:,:,504))
  call Hloop_AV_Q(ntryL,G1H8(286),wf4(:,49),G1H2(192),m3h4x2(:,108),heltab2x8(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(192),55,nME,G2H2(789),n2h2(672))
  call Hloop_AV_Q(ntryL,G0H8(26),wf4(:,49),G0H2(1),m3h4x2(:,109),heltab2x8(:,:,506))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(192),n2h2(673))
  call Hloop_AV_Q(ntryL,G1H8(287),wf4(:,49),G1H2(193),m3h4x2(:,110),heltab2x8(:,:,507))
  call Hloop_A_Q(ntryL,G1H2(193),55,nMM,G2H2(790),n2h2(674))
call HGT_OLR(G1H8(288),1,1,8)
call HGT_invQ_OLR(G1H8(288),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(288),-8,nMM,G2H8(72),n2h8(292))
  call Hloop_QV_A(ntryL,G2H8(72),ex4(:),G2H4(309),m3h2x4(:,398),heltab2x8(:,:,508))
  call Hloop_AV_Q(ntryL,G1H8(293),wf4(:,49),G1H2(193),m3h4x2(:,111),heltab2x8(:,:,509))
  call Hloop_A_Q(ntryL,G1H2(193),55,nMM,G2H2(791),n2h2(675))
  call Hloop_AV_Q(ntryL,G1H8(298),wf4(:,49),G1H2(193),m3h4x2(:,112),heltab2x8(:,:,510))
  call Hloop_A_Q(ntryL,G1H2(193),55,nMM,G2H2(792),n2h2(676))
call HGT_OLR(G1H8(294),1,1,8)
call HGT_invQ_OLR(G1H8(294),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(294),-8,nMM,G2H8(75),n2h8(293))
  call Hloop_QV_A(ntryL,G2H8(75),ex4(:),G2H4(311),m3h2x4(:,399),heltab2x8(:,:,511))
  call Hloop_AV_Q(ntryL,G1H8(297),wf4(:,49),G1H2(193),m3h4x2(:,113),heltab2x8(:,:,512))
  call Hloop_A_Q(ntryL,G1H2(193),55,nMM,G2H2(793),n2h2(677))
  call Hloop_AV_Q(ntryL,G0H8(27),wf4(:,49),G0H2(1),m3h4x2(:,114),heltab2x8(:,:,513))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(193),n2h2(678))
call HGT_OLR(G1H8(299),1,1,8)
call HGT_invQ_OLR(G1H8(299),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(299),-11,nMM,G2H8(76),n2h8(294))
  call Hloop_QV_A(ntryL,G2H8(76),ex4(:),G2H4(312),m3h2x4(:,400),heltab2x8(:,:,514))
  call Hloop_AV_Q(ntryL,G1H8(302),wf4(:,49),G1H2(194),m3h4x2(:,115),heltab2x8(:,:,515))
  call Hloop_A_Q(ntryL,G1H2(194),55,nMM,G2H2(794),n2h2(679))
  call Hloop_AV_Q(ntryL,G0H8(28),wf4(:,49),G0H2(1),m3h4x2(:,116),heltab2x8(:,:,516))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(194),n2h2(680))
  call Hloop_QV_A(ntryL,G1H8(303),wf4(:,49),G1H2(195),m3h4x2(:,117),heltab2x8(:,:,517))
  call Hloop_Q_A(ntryL,G1H2(195),55,nME,G2H2(795),n2h2(681))
call HGT_OLR(G1H8(304),1,1,8)
call HGT_invQ_OLR(G1H8(304),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(304),-8,nME,G2H8(77),n2h8(295))
  call Hloop_AV_Q(ntryL,G2H8(77),ex4(:),G2H4(316),m3h2x4(:,401),heltab2x8(:,:,518))
  call Hloop_QV_A(ntryL,G1H8(309),wf4(:,49),G1H2(195),m3h4x2(:,118),heltab2x8(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(195),55,nME,G2H2(796),n2h2(682))
  call Hloop_QV_A(ntryL,G1H8(314),wf4(:,49),G1H2(195),m3h4x2(:,119),heltab2x8(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(195),55,nME,G2H2(797),n2h2(683))
call HGT_OLR(G1H8(310),1,1,8)
call HGT_invQ_OLR(G1H8(310),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(310),-8,nME,G2H8(80),n2h8(296))
  call Hloop_AV_Q(ntryL,G2H8(80),ex4(:),G2H4(317),m3h2x4(:,402),heltab2x8(:,:,521))
  call Hloop_QV_A(ntryL,G1H8(313),wf4(:,49),G1H2(195),m3h4x2(:,120),heltab2x8(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(195),55,nME,G2H2(798),n2h2(684))
  call Hloop_QV_A(ntryL,G0H8(29),wf4(:,49),G0H2(1),m3h4x2(:,121),heltab2x8(:,:,523))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(195),n2h2(685))
call HGT_OLR(G1H8(315),1,1,8)
call HGT_invQ_OLR(G1H8(315),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(315),-11,nME,G2H8(81),n2h8(297))
  call Hloop_AV_Q(ntryL,G2H8(81),ex4(:),G2H4(319),m3h2x4(:,403),heltab2x8(:,:,524))
  call Hloop_QV_A(ntryL,G1H8(318),wf4(:,49),G1H2(196),m3h4x2(:,122),heltab2x8(:,:,525))
  call Hloop_Q_A(ntryL,G1H2(196),55,nME,G2H2(799),n2h2(686))
  call Hloop_QV_A(ntryL,G0H8(30),wf4(:,49),G0H2(1),m3h4x2(:,123),heltab2x8(:,:,526))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(196),n2h2(687))
  call Hloop_QV_A(ntryL,G1H8(319),wf4(:,49),G1H2(197),m3h4x2(:,124),heltab2x8(:,:,527))
  call Hloop_Q_A(ntryL,G1H2(197),55,nMM,G2H2(800),n2h2(688))
call HGT_OLR(G1H8(320),1,1,8)
call HGT_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(320),-8,nMM,G2H8(82),n2h8(298))
  call Hloop_AV_Q(ntryL,G2H8(82),ex4(:),G2H4(320),m3h2x4(:,404),heltab2x8(:,:,528))
  call Hloop_QV_A(ntryL,G1H8(325),wf4(:,49),G1H2(197),m3h4x2(:,125),heltab2x8(:,:,529))
  call Hloop_Q_A(ntryL,G1H2(197),55,nMM,G2H2(801),n2h2(689))
  call Hloop_QV_A(ntryL,G1H8(330),wf4(:,49),G1H2(197),m3h4x2(:,126),heltab2x8(:,:,530))
  call Hloop_Q_A(ntryL,G1H2(197),55,nMM,G2H2(802),n2h2(690))
call HGT_OLR(G1H8(326),1,1,8)
call HGT_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(326),-8,nMM,G2H8(85),n2h8(299))
  call Hloop_AV_Q(ntryL,G2H8(85),ex4(:),G2H4(321),m3h2x4(:,405),heltab2x8(:,:,531))
  call Hloop_QV_A(ntryL,G1H8(329),wf4(:,49),G1H2(197),m3h4x2(:,127),heltab2x8(:,:,532))
  call Hloop_Q_A(ntryL,G1H2(197),55,nMM,G2H2(803),n2h2(691))
  call Hloop_QV_A(ntryL,G0H8(31),wf4(:,49),G0H2(1),m3h4x2(:,128),heltab2x8(:,:,533))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(197),n2h2(692))
call HGT_OLR(G1H8(331),1,1,8)
call HGT_invQ_OLR(G1H8(331),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(331),-11,nMM,G2H8(86),n2h8(300))
  call Hloop_AV_Q(ntryL,G2H8(86),ex4(:),G2H4(323),m3h2x4(:,406),heltab2x8(:,:,534))
  call Hloop_QV_A(ntryL,G1H8(334),wf4(:,49),G1H2(198),m3h4x2(:,129),heltab2x8(:,:,535))
  call Hloop_Q_A(ntryL,G1H2(198),55,nMM,G2H2(804),n2h2(693))
  call Hloop_QV_A(ntryL,G0H8(32),wf4(:,49),G0H2(1),m3h4x2(:,130),heltab2x8(:,:,536))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(198),n2h2(694))
  call Hloop_AV_Q(ntryL,G1H8(335),wf4(:,49),G1H2(199),m3h4x2(:,131),heltab2x8(:,:,537))
  call Hloop_A_Q(ntryL,G1H2(199),55,0,G2H2(805),n2h2(695))
call HGT_OLR(G1H8(336),1,1,8)
call HGT_invQ_OLR(G1H8(336),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(336),-8,0,G2H8(87),n2h8(301))
  call Hloop_QV_A(ntryL,G2H8(87),ex4(:),G2H4(324),m3h2x4(:,407),heltab2x8(:,:,538))
  call Hloop_AV_Q(ntryL,G1H8(341),wf4(:,49),G1H2(199),m3h4x2(:,132),heltab2x8(:,:,539))
  call Hloop_A_Q(ntryL,G1H2(199),55,0,G2H2(806),n2h2(696))
  call Hloop_AV_Q(ntryL,G1H8(346),wf4(:,49),G1H2(199),m3h4x2(:,133),heltab2x8(:,:,540))
  call Hloop_A_Q(ntryL,G1H2(199),55,0,G2H2(807),n2h2(697))
call HGT_OLR(G1H8(342),1,1,8)
call HGT_invQ_OLR(G1H8(342),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(342),-8,0,G2H8(90),n2h8(302))
  call Hloop_QV_A(ntryL,G2H8(90),ex4(:),G2H4(325),m3h2x4(:,408),heltab2x8(:,:,541))
  call Hloop_AV_Q(ntryL,G1H8(345),wf4(:,49),G1H2(199),m3h4x2(:,134),heltab2x8(:,:,542))
  call Hloop_A_Q(ntryL,G1H2(199),55,0,G2H2(808),n2h2(698))
  call Hloop_AV_Q(ntryL,G0H8(33),wf4(:,49),G0H2(1),m3h4x2(:,135),heltab2x8(:,:,543))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(199),n2h2(699))
call HGT_OLR(G1H8(347),1,1,8)
call HGT_invQ_OLR(G1H8(347),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(347),-11,0,G2H8(91),n2h8(303))
  call Hloop_QV_A(ntryL,G2H8(91),ex4(:),G2H4(327),m3h2x4(:,409),heltab2x8(:,:,544))
  call Hloop_AV_Q(ntryL,G1H8(350),wf4(:,49),G1H2(200),m3h4x2(:,136),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H2(200),55,0,G2H2(809),n2h2(700))
  call Hloop_AV_Q(ntryL,G0H8(34),wf4(:,49),G0H2(1),m3h4x2(:,137),heltab2x8(:,:,546))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(200),n2h2(701))
  call Hloop_QV_A(ntryL,G1H8(351),wf4(:,49),G1H2(201),m3h4x2(:,138),heltab2x8(:,:,547))
  call Hloop_Q_A(ntryL,G1H2(201),55,0,G2H2(810),n2h2(702))
call HGT_OLR(G1H8(352),1,1,8)
call HGT_invQ_OLR(G1H8(352),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(352),-8,0,G2H8(92),n2h8(304))
  call Hloop_AV_Q(ntryL,G2H8(92),ex4(:),G2H4(328),m3h2x4(:,410),heltab2x8(:,:,548))
  call Hloop_QV_A(ntryL,G1H8(357),wf4(:,49),G1H2(201),m3h4x2(:,139),heltab2x8(:,:,549))
  call Hloop_Q_A(ntryL,G1H2(201),55,0,G2H2(811),n2h2(703))
  call Hloop_QV_A(ntryL,G1H8(362),wf4(:,49),G1H2(201),m3h4x2(:,140),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H2(201),55,0,G2H2(812),n2h2(704))
call HGT_OLR(G1H8(358),1,1,8)
call HGT_invQ_OLR(G1H8(358),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(358),-8,0,G2H8(95),n2h8(305))
  call Hloop_AV_Q(ntryL,G2H8(95),ex4(:),G2H4(332),m3h2x4(:,411),heltab2x8(:,:,551))
  call Hloop_QV_A(ntryL,G1H8(361),wf4(:,49),G1H2(201),m3h4x2(:,141),heltab2x8(:,:,552))
  call Hloop_Q_A(ntryL,G1H2(201),55,0,G2H2(813),n2h2(705))
  call Hloop_QV_A(ntryL,G0H8(35),wf4(:,49),G0H2(1),m3h4x2(:,142),heltab2x8(:,:,553))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(201),n2h2(706))
call HGT_OLR(G1H8(363),1,1,8)
call HGT_invQ_OLR(G1H8(363),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(363),-11,0,G2H8(96),n2h8(306))
  call Hloop_AV_Q(ntryL,G2H8(96),ex4(:),G2H4(333),m3h2x4(:,412),heltab2x8(:,:,554))
  call Hloop_QV_A(ntryL,G1H8(366),wf4(:,49),G1H2(202),m3h4x2(:,143),heltab2x8(:,:,555))
  call Hloop_Q_A(ntryL,G1H2(202),55,0,G2H2(814),n2h2(707))
  call Hloop_QV_A(ntryL,G0H8(36),wf4(:,49),G0H2(1),m3h4x2(:,144),heltab2x8(:,:,556))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(202),n2h2(708))
  call Hloop_AV_Q(ntryL,G1H4(951),ex5(:),G1H2(203),m3h2x2(:,801),heltab2x4(:,:,801))
  call Hloop_A_Q(ntryL,G1H2(203),55,nMM,G2H2(815),n2h2(709))
call HGT_OLR(G1H4(952),1,1,4)
call HGT_invQ_OLR(G1H4(952),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(952),-8,nMM,G2H4(335),n2h4(549))
  call Hloop_QV_A(ntryL,G2H4(335),ex4(:),G2H2(816),m3h2x2(:,802),heltab2x4(:,:,802))
  call Hloop_AV_Q(ntryL,G1H4(957),ex5(:),G1H2(203),m3h2x2(:,803),heltab2x4(:,:,803))
  call Hloop_A_Q(ntryL,G1H2(203),55,nMM,G2H2(817),n2h2(710))
  call Hloop_AV_Q(ntryL,G1H4(962),ex5(:),G1H2(203),m3h2x2(:,804),heltab2x4(:,:,804))
  call Hloop_A_Q(ntryL,G1H2(203),55,nMM,G2H2(818),n2h2(711))
call HGT_OLR(G1H4(958),1,1,4)
call HGT_invQ_OLR(G1H4(958),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(958),-8,nMM,G2H4(336),n2h4(550))
  call Hloop_QV_A(ntryL,G2H4(336),ex4(:),G2H2(819),m3h2x2(:,805),heltab2x4(:,:,805))
  call Hloop_AV_Q(ntryL,G1H4(961),ex5(:),G1H2(203),m3h2x2(:,806),heltab2x4(:,:,806))
  call Hloop_A_Q(ntryL,G1H2(203),55,nMM,G2H2(820),n2h2(712))
  call Hloop_AV_Q(ntryL,G0H4(71),ex5(:),G0H2(1),m3h2x2(:,807),heltab2x4(:,:,807))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(203),n2h2(713))
call HGT_OLR(G1H4(963),1,1,4)
call HGT_invQ_OLR(G1H4(963),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(963),-24,nMM,G2H4(340),n2h4(551))
  call Hloop_QV_A(ntryL,G2H4(340),ex4(:),G2H2(821),m3h2x2(:,808),heltab2x4(:,:,808))
  call Hloop_AV_Q(ntryL,G1H4(966),ex5(:),G1H2(204),m3h2x2(:,809),heltab2x4(:,:,809))
  call Hloop_A_Q(ntryL,G1H2(204),55,nMM,G2H2(822),n2h2(714))
  call Hloop_AV_Q(ntryL,G0H4(72),ex5(:),G0H2(1),m3h2x2(:,810),heltab2x4(:,:,810))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(204),n2h2(715))
  call Hloop_QV_A(ntryL,G1H4(967),ex5(:),G1H2(205),m3h2x2(:,811),heltab2x4(:,:,811))
  call Hloop_Q_A(ntryL,G1H2(205),55,nMM,G2H2(823),n2h2(716))
call HGT_OLR(G1H4(968),1,1,4)
call HGT_invQ_OLR(G1H4(968),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(968),-8,nMM,G2H4(341),n2h4(552))
  call Hloop_AV_Q(ntryL,G2H4(341),ex4(:),G2H2(824),m3h2x2(:,812),heltab2x4(:,:,812))
  call Hloop_QV_A(ntryL,G1H4(973),ex5(:),G1H2(205),m3h2x2(:,813),heltab2x4(:,:,813))
  call Hloop_Q_A(ntryL,G1H2(205),55,nMM,G2H2(825),n2h2(717))
  call Hloop_QV_A(ntryL,G1H4(978),ex5(:),G1H2(205),m3h2x2(:,814),heltab2x4(:,:,814))
  call Hloop_Q_A(ntryL,G1H2(205),55,nMM,G2H2(826),n2h2(718))
call HGT_OLR(G1H4(974),1,1,4)
call HGT_invQ_OLR(G1H4(974),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(974),-8,nMM,G2H4(343),n2h4(553))
  call Hloop_AV_Q(ntryL,G2H4(343),ex4(:),G2H2(827),m3h2x2(:,815),heltab2x4(:,:,815))
  call Hloop_QV_A(ntryL,G1H4(977),ex5(:),G1H2(205),m3h2x2(:,816),heltab2x4(:,:,816))
  call Hloop_Q_A(ntryL,G1H2(205),55,nMM,G2H2(828),n2h2(719))
  call Hloop_QV_A(ntryL,G0H4(73),ex5(:),G0H2(1),m3h2x2(:,817),heltab2x4(:,:,817))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(205),n2h2(720))
call HGT_OLR(G1H4(979),1,1,4)
call HGT_invQ_OLR(G1H4(979),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(979),-24,nMM,G2H4(344),n2h4(554))
  call Hloop_AV_Q(ntryL,G2H4(344),ex4(:),G2H2(829),m3h2x2(:,818),heltab2x4(:,:,818))
  call Hloop_QV_A(ntryL,G1H4(982),ex5(:),G1H2(206),m3h2x2(:,819),heltab2x4(:,:,819))
  call Hloop_Q_A(ntryL,G1H2(206),55,nMM,G2H2(830),n2h2(721))
  call Hloop_QV_A(ntryL,G0H4(74),ex5(:),G0H2(1),m3h2x2(:,820),heltab2x4(:,:,820))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(206),n2h2(722))
  call Hloop_AV_Q(ntryL,G1H4(983),ex5(:),G1H2(207),m3h2x2(:,821),heltab2x4(:,:,821))
  call Hloop_A_Q(ntryL,G1H2(207),55,0,G2H2(831),n2h2(723))
call HGT_OLR(G1H4(984),1,1,4)
call HGT_invQ_OLR(G1H4(984),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(984),-8,0,G2H4(345),n2h4(555))
  call Hloop_QV_A(ntryL,G2H4(345),ex4(:),G2H2(832),m3h2x2(:,822),heltab2x4(:,:,822))
  call Hloop_AV_Q(ntryL,G1H4(989),ex5(:),G1H2(207),m3h2x2(:,823),heltab2x4(:,:,823))
  call Hloop_A_Q(ntryL,G1H2(207),55,0,G2H2(833),n2h2(724))
  call Hloop_AV_Q(ntryL,G1H4(994),ex5(:),G1H2(207),m3h2x2(:,824),heltab2x4(:,:,824))
  call Hloop_A_Q(ntryL,G1H2(207),55,0,G2H2(834),n2h2(725))
call HGT_OLR(G1H4(990),1,1,4)
call HGT_invQ_OLR(G1H4(990),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(990),-8,0,G2H4(347),n2h4(556))
  call Hloop_QV_A(ntryL,G2H4(347),ex4(:),G2H2(835),m3h2x2(:,825),heltab2x4(:,:,825))
  call Hloop_AV_Q(ntryL,G1H4(993),ex5(:),G1H2(207),m3h2x2(:,826),heltab2x4(:,:,826))
  call Hloop_A_Q(ntryL,G1H2(207),55,0,G2H2(836),n2h2(726))
  call Hloop_AV_Q(ntryL,G0H4(75),ex5(:),G0H2(1),m3h2x2(:,827),heltab2x4(:,:,827))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(207),n2h2(727))
call HGT_OLR(G1H4(995),1,1,4)
call HGT_invQ_OLR(G1H4(995),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(995),-24,0,G2H4(348),n2h4(557))
  call Hloop_QV_A(ntryL,G2H4(348),ex4(:),G2H2(837),m3h2x2(:,828),heltab2x4(:,:,828))
  call Hloop_AV_Q(ntryL,G1H4(998),ex5(:),G1H2(208),m3h2x2(:,829),heltab2x4(:,:,829))
  call Hloop_A_Q(ntryL,G1H2(208),55,0,G2H2(838),n2h2(728))
  call Hloop_AV_Q(ntryL,G0H4(76),ex5(:),G0H2(1),m3h2x2(:,830),heltab2x4(:,:,830))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(208),n2h2(729))
  call Hloop_QV_A(ntryL,G1H4(999),ex5(:),G1H2(209),m3h2x2(:,831),heltab2x4(:,:,831))
  call Hloop_Q_A(ntryL,G1H2(209),55,0,G2H2(839),n2h2(730))
call HGT_OLR(G1H4(1000),1,1,4)
call HGT_invQ_OLR(G1H4(1000),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1000),-8,0,G2H4(349),n2h4(558))
  call Hloop_AV_Q(ntryL,G2H4(349),ex4(:),G2H2(840),m3h2x2(:,832),heltab2x4(:,:,832))
  call Hloop_QV_A(ntryL,G1H4(1005),ex5(:),G1H2(209),m3h2x2(:,833),heltab2x4(:,:,833))
  call Hloop_Q_A(ntryL,G1H2(209),55,0,G2H2(841),n2h2(731))
  call Hloop_QV_A(ntryL,G1H4(1010),ex5(:),G1H2(209),m3h2x2(:,834),heltab2x4(:,:,834))
  call Hloop_Q_A(ntryL,G1H2(209),55,0,G2H2(842),n2h2(732))
call HGT_OLR(G1H4(1006),1,1,4)
call HGT_invQ_OLR(G1H4(1006),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1006),-8,0,G2H4(351),n2h4(559))
  call Hloop_AV_Q(ntryL,G2H4(351),ex4(:),G2H2(843),m3h2x2(:,835),heltab2x4(:,:,835))
  call Hloop_QV_A(ntryL,G1H4(1009),ex5(:),G1H2(209),m3h2x2(:,836),heltab2x4(:,:,836))
  call Hloop_Q_A(ntryL,G1H2(209),55,0,G2H2(844),n2h2(733))
  call Hloop_QV_A(ntryL,G0H4(77),ex5(:),G0H2(1),m3h2x2(:,837),heltab2x4(:,:,837))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(209),n2h2(734))
call HGT_OLR(G1H4(1011),1,1,4)
call HGT_invQ_OLR(G1H4(1011),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1011),-24,0,G2H4(352),n2h4(560))
  call Hloop_AV_Q(ntryL,G2H4(352),ex4(:),G2H2(845),m3h2x2(:,838),heltab2x4(:,:,838))
  call Hloop_QV_A(ntryL,G1H4(1014),ex5(:),G1H2(210),m3h2x2(:,839),heltab2x4(:,:,839))
  call Hloop_Q_A(ntryL,G1H2(210),55,0,G2H2(846),n2h2(735))
  call Hloop_QV_A(ntryL,G0H4(78),ex5(:),G0H2(1),m3h2x2(:,840),heltab2x4(:,:,840))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(210),n2h2(736))
call HGT_OLR(G1H4(1016),1,1,4)
call HGT_invQ_OLR(G1H4(1016),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1016),-20,nME,G2H4(356),n2h4(561))
  call Hloop_QV_A(ntryL,G2H4(356),ex5(:),G2H2(847),m3h2x2(:,841),heltab2x4(:,:,841))
  call Hloop_AV_Q(ntryL,G1H4(1019),ex3(:),G1H2(211),m3h2x2(:,842),heltab2x4(:,:,842))
  call Hloop_A_Q(ntryL,G1H2(211),47,nME,G2H2(848),n2h2(737))
  call Hloop_AV_Q(ntryL,G0H4(79),ex3(:),G0H2(1),m3h2x2(:,843),heltab2x4(:,:,843))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(211),n2h2(738))
  call Hloop_AV_Q(ntryL,G1H4(1020),ex3(:),G1H2(212),m3h2x2(:,844),heltab2x4(:,:,844))
  call Hloop_A_Q(ntryL,G1H2(212),47,nMM,G2H2(849),n2h2(739))
call HGT_OLR(G1H4(1021),1,1,4)
call HGT_invQ_OLR(G1H4(1021),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1021),-16,nMM,G2H4(357),n2h4(562))
  call Hloop_QV_A(ntryL,G2H4(357),ex5(:),G2H2(850),m3h2x2(:,845),heltab2x4(:,:,845))
  call Hloop_AV_Q(ntryL,G1H4(1026),ex3(:),G1H2(212),m3h2x2(:,846),heltab2x4(:,:,846))
  call Hloop_A_Q(ntryL,G1H2(212),47,nMM,G2H2(851),n2h2(740))
  call Hloop_AV_Q(ntryL,G1H4(1031),ex3(:),G1H2(212),m3h2x2(:,847),heltab2x4(:,:,847))
  call Hloop_A_Q(ntryL,G1H2(212),47,nMM,G2H2(852),n2h2(741))
call HGT_OLR(G1H4(1027),1,1,4)
call HGT_invQ_OLR(G1H4(1027),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1027),-16,nMM,G2H4(359),n2h4(563))
  call Hloop_QV_A(ntryL,G2H4(359),ex5(:),G2H2(853),m3h2x2(:,848),heltab2x4(:,:,848))
  call Hloop_AV_Q(ntryL,G1H4(1030),ex3(:),G1H2(212),m3h2x2(:,849),heltab2x4(:,:,849))
  call Hloop_A_Q(ntryL,G1H2(212),47,nMM,G2H2(854),n2h2(742))
  call Hloop_AV_Q(ntryL,G0H4(80),ex3(:),G0H2(1),m3h2x2(:,850),heltab2x4(:,:,850))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(212),n2h2(743))
call HGT_OLR(G1H4(1032),1,1,4)
call HGT_invQ_OLR(G1H4(1032),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1032),-20,nMM,G2H4(360),n2h4(564))
  call Hloop_QV_A(ntryL,G2H4(360),ex5(:),G2H2(855),m3h2x2(:,851),heltab2x4(:,:,851))
  call Hloop_AV_Q(ntryL,G1H4(1035),ex3(:),G1H2(213),m3h2x2(:,852),heltab2x4(:,:,852))
  call Hloop_A_Q(ntryL,G1H2(213),47,nMM,G2H2(856),n2h2(744))
  call Hloop_AV_Q(ntryL,G0H4(81),ex3(:),G0H2(1),m3h2x2(:,853),heltab2x4(:,:,853))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(213),n2h2(745))
call HGT_OLR(G1H4(1037),1,1,4)
call HGT_invQ_OLR(G1H4(1037),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1037),-20,nME,G2H4(364),n2h4(565))
  call Hloop_AV_Q(ntryL,G2H4(364),ex5(:),G2H2(857),m3h2x2(:,854),heltab2x4(:,:,854))
  call Hloop_QV_A(ntryL,G1H4(1040),ex3(:),G1H2(214),m3h2x2(:,855),heltab2x4(:,:,855))
  call Hloop_Q_A(ntryL,G1H2(214),47,nME,G2H2(858),n2h2(746))
  call Hloop_QV_A(ntryL,G0H4(82),ex3(:),G0H2(1),m3h2x2(:,856),heltab2x4(:,:,856))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(214),n2h2(747))
  call Hloop_QV_A(ntryL,G1H4(1041),ex3(:),G1H2(215),m3h2x2(:,857),heltab2x4(:,:,857))
  call Hloop_Q_A(ntryL,G1H2(215),47,nMM,G2H2(859),n2h2(748))
call HGT_OLR(G1H4(1042),1,1,4)
call HGT_invQ_OLR(G1H4(1042),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1042),-16,nMM,G2H4(365),n2h4(566))
  call Hloop_AV_Q(ntryL,G2H4(365),ex5(:),G2H2(860),m3h2x2(:,858),heltab2x4(:,:,858))
  call Hloop_QV_A(ntryL,G1H4(1047),ex3(:),G1H2(215),m3h2x2(:,859),heltab2x4(:,:,859))
  call Hloop_Q_A(ntryL,G1H2(215),47,nMM,G2H2(861),n2h2(749))
  call Hloop_QV_A(ntryL,G1H4(1052),ex3(:),G1H2(215),m3h2x2(:,860),heltab2x4(:,:,860))
  call Hloop_Q_A(ntryL,G1H2(215),47,nMM,G2H2(862),n2h2(750))
call HGT_OLR(G1H4(1048),1,1,4)
call HGT_invQ_OLR(G1H4(1048),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1048),-16,nMM,G2H4(367),n2h4(567))
  call Hloop_AV_Q(ntryL,G2H4(367),ex5(:),G2H2(863),m3h2x2(:,861),heltab2x4(:,:,861))
  call Hloop_QV_A(ntryL,G1H4(1051),ex3(:),G1H2(215),m3h2x2(:,862),heltab2x4(:,:,862))
  call Hloop_Q_A(ntryL,G1H2(215),47,nMM,G2H2(864),n2h2(751))
  call Hloop_QV_A(ntryL,G0H4(83),ex3(:),G0H2(1),m3h2x2(:,863),heltab2x4(:,:,863))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(215),n2h2(752))
call HGT_OLR(G1H4(1053),1,1,4)
call HGT_invQ_OLR(G1H4(1053),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1053),-20,nMM,G2H4(368),n2h4(568))
  call Hloop_AV_Q(ntryL,G2H4(368),ex5(:),G2H2(865),m3h2x2(:,864),heltab2x4(:,:,864))
  call Hloop_QV_A(ntryL,G1H4(1056),ex3(:),G1H2(216),m3h2x2(:,865),heltab2x4(:,:,865))
  call Hloop_Q_A(ntryL,G1H2(216),47,nMM,G2H2(866),n2h2(753))
  call Hloop_QV_A(ntryL,G0H4(84),ex3(:),G0H2(1),m3h2x2(:,866),heltab2x4(:,:,866))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(216),n2h2(754))
  call Hloop_AV_Q(ntryL,G1H4(1057),ex3(:),G1H2(217),m3h2x2(:,867),heltab2x4(:,:,867))
  call Hloop_A_Q(ntryL,G1H2(217),47,0,G2H2(867),n2h2(755))
call HGT_OLR(G1H4(1058),1,1,4)
call HGT_invQ_OLR(G1H4(1058),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1058),-16,0,G2H4(369),n2h4(569))
  call Hloop_QV_A(ntryL,G2H4(369),ex5(:),G2H2(868),m3h2x2(:,868),heltab2x4(:,:,868))
  call Hloop_AV_Q(ntryL,G1H4(1063),ex3(:),G1H2(217),m3h2x2(:,869),heltab2x4(:,:,869))
  call Hloop_A_Q(ntryL,G1H2(217),47,0,G2H2(869),n2h2(756))
  call Hloop_AV_Q(ntryL,G1H4(1068),ex3(:),G1H2(217),m3h2x2(:,870),heltab2x4(:,:,870))
  call Hloop_A_Q(ntryL,G1H2(217),47,0,G2H2(870),n2h2(757))
call HGT_OLR(G1H4(1064),1,1,4)
call HGT_invQ_OLR(G1H4(1064),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1064),-16,0,G2H4(371),n2h4(570))
  call Hloop_QV_A(ntryL,G2H4(371),ex5(:),G2H2(871),m3h2x2(:,871),heltab2x4(:,:,871))
  call Hloop_AV_Q(ntryL,G1H4(1067),ex3(:),G1H2(217),m3h2x2(:,872),heltab2x4(:,:,872))
  call Hloop_A_Q(ntryL,G1H2(217),47,0,G2H2(872),n2h2(758))
  call Hloop_AV_Q(ntryL,G0H4(85),ex3(:),G0H2(1),m3h2x2(:,873),heltab2x4(:,:,873))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(217),n2h2(759))
call HGT_OLR(G1H4(1069),1,1,4)
call HGT_invQ_OLR(G1H4(1069),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1069),-20,0,G2H4(372),n2h4(571))
  call Hloop_QV_A(ntryL,G2H4(372),ex5(:),G2H2(873),m3h2x2(:,874),heltab2x4(:,:,874))
  call Hloop_AV_Q(ntryL,G1H4(1072),ex3(:),G1H2(218),m3h2x2(:,875),heltab2x4(:,:,875))
  call Hloop_A_Q(ntryL,G1H2(218),47,0,G2H2(874),n2h2(760))
  call Hloop_AV_Q(ntryL,G0H4(86),ex3(:),G0H2(1),m3h2x2(:,876),heltab2x4(:,:,876))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(218),n2h2(761))
  call Hloop_QV_A(ntryL,G1H4(1073),ex3(:),G1H2(219),m3h2x2(:,877),heltab2x4(:,:,877))
  call Hloop_Q_A(ntryL,G1H2(219),47,0,G2H2(875),n2h2(762))
call HGT_OLR(G1H4(1074),1,1,4)
call HGT_invQ_OLR(G1H4(1074),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1074),-16,0,G2H4(373),n2h4(572))
  call Hloop_AV_Q(ntryL,G2H4(373),ex5(:),G2H2(876),m3h2x2(:,878),heltab2x4(:,:,878))
  call Hloop_QV_A(ntryL,G1H4(1079),ex3(:),G1H2(219),m3h2x2(:,879),heltab2x4(:,:,879))
  call Hloop_Q_A(ntryL,G1H2(219),47,0,G2H2(877),n2h2(763))
  call Hloop_QV_A(ntryL,G1H4(1084),ex3(:),G1H2(219),m3h2x2(:,880),heltab2x4(:,:,880))
  call Hloop_Q_A(ntryL,G1H2(219),47,0,G2H2(878),n2h2(764))
call HGT_OLR(G1H4(1080),1,1,4)
call HGT_invQ_OLR(G1H4(1080),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1080),-16,0,G2H4(375),n2h4(573))
  call Hloop_AV_Q(ntryL,G2H4(375),ex5(:),G2H2(879),m3h2x2(:,881),heltab2x4(:,:,881))
  call Hloop_QV_A(ntryL,G1H4(1083),ex3(:),G1H2(219),m3h2x2(:,882),heltab2x4(:,:,882))
  call Hloop_Q_A(ntryL,G1H2(219),47,0,G2H2(880),n2h2(765))
  call Hloop_QV_A(ntryL,G0H4(87),ex3(:),G0H2(1),m3h2x2(:,883),heltab2x4(:,:,883))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(219),n2h2(766))
call HGT_OLR(G1H4(1085),1,1,4)
call HGT_invQ_OLR(G1H4(1085),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1085),-20,0,G2H4(376),n2h4(574))
  call Hloop_AV_Q(ntryL,G2H4(376),ex5(:),G2H2(881),m3h2x2(:,884),heltab2x4(:,:,884))
  call Hloop_QV_A(ntryL,G1H4(1088),ex3(:),G1H2(220),m3h2x2(:,885),heltab2x4(:,:,885))
  call Hloop_Q_A(ntryL,G1H2(220),47,0,G2H2(882),n2h2(767))
  call Hloop_QV_A(ntryL,G0H4(88),ex3(:),G0H2(1),m3h2x2(:,886),heltab2x4(:,:,886))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(220),n2h2(768))
call HGT_OLR(G1H4(1090),1,1,4)
call HGT_invQ_OLR(G1H4(1090),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1090),-24,nME,G2H4(58),n2h4(575))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(883),m3h2x2(:,887),heltab2x4(:,:,887))
  call Hloop_QV_A(ntryL,G1H4(1093),ex5(:),G1H2(221),m3h2x2(:,888),heltab2x4(:,:,888))
  call Hloop_Q_A(ntryL,G1H2(221),55,nME,G2H2(884),n2h2(769))
  call Hloop_QV_A(ntryL,G0H4(89),ex5(:),G0H2(1),m3h2x2(:,889),heltab2x4(:,:,889))
  call Hloop_Q_A(ntryL,G0H2(1),55,nME,G1H2(221),n2h2(770))
  call Hloop_QV_A(ntryL,G1H4(1094),ex5(:),G1H2(222),m3h2x2(:,890),heltab2x4(:,:,890))
  call Hloop_Q_A(ntryL,G1H2(222),55,nMM,G2H2(885),n2h2(771))
call HGT_OLR(G1H4(1095),1,1,4)
call HGT_invQ_OLR(G1H4(1095),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1095),-8,nMM,G2H4(57),n2h4(576))
  call Hloop_AV_Q(ntryL,G2H4(57),ex4(:),G2H2(886),m3h2x2(:,891),heltab2x4(:,:,891))
  call Hloop_QV_A(ntryL,G1H4(1100),ex5(:),G1H2(222),m3h2x2(:,892),heltab2x4(:,:,892))
  call Hloop_Q_A(ntryL,G1H2(222),55,nMM,G2H2(887),n2h2(772))
  call Hloop_QV_A(ntryL,G1H4(1105),ex5(:),G1H2(222),m3h2x2(:,893),heltab2x4(:,:,893))
  call Hloop_Q_A(ntryL,G1H2(222),55,nMM,G2H2(888),n2h2(773))
call HGT_OLR(G1H4(1101),1,1,4)
call HGT_invQ_OLR(G1H4(1101),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1101),-8,nMM,G2H4(61),n2h4(577))
  call Hloop_AV_Q(ntryL,G2H4(61),ex4(:),G2H2(889),m3h2x2(:,894),heltab2x4(:,:,894))
  call Hloop_QV_A(ntryL,G1H4(1104),ex5(:),G1H2(222),m3h2x2(:,895),heltab2x4(:,:,895))
  call Hloop_Q_A(ntryL,G1H2(222),55,nMM,G2H2(890),n2h2(774))
  call Hloop_QV_A(ntryL,G0H4(90),ex5(:),G0H2(1),m3h2x2(:,896),heltab2x4(:,:,896))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(222),n2h2(775))
call HGT_OLR(G1H4(1106),1,1,4)
call HGT_invQ_OLR(G1H4(1106),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1106),-24,nMM,G2H4(31),n2h4(578))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(891),m3h2x2(:,897),heltab2x4(:,:,897))
  call Hloop_QV_A(ntryL,G1H4(1109),ex5(:),G1H2(223),m3h2x2(:,898),heltab2x4(:,:,898))
  call Hloop_Q_A(ntryL,G1H2(223),55,nMM,G2H2(892),n2h2(776))
  call Hloop_QV_A(ntryL,G0H4(91),ex5(:),G0H2(1),m3h2x2(:,899),heltab2x4(:,:,899))
  call Hloop_Q_A(ntryL,G0H2(1),55,nMM,G1H2(223),n2h2(777))
call HGT_OLR(G1H4(1111),1,1,4)
call HGT_invQ_OLR(G1H4(1111),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1111),-24,nME,G2H4(65),n2h4(579))
  call Hloop_QV_A(ntryL,G2H4(65),ex4(:),G2H2(893),m3h2x2(:,900),heltab2x4(:,:,900))
  call Hloop_AV_Q(ntryL,G1H4(1114),ex5(:),G1H2(224),m3h2x2(:,901),heltab2x4(:,:,901))
  call Hloop_A_Q(ntryL,G1H2(224),55,nME,G2H2(894),n2h2(778))
  call Hloop_AV_Q(ntryL,G0H4(92),ex5(:),G0H2(1),m3h2x2(:,902),heltab2x4(:,:,902))
  call Hloop_A_Q(ntryL,G0H2(1),55,nME,G1H2(224),n2h2(779))
  call Hloop_AV_Q(ntryL,G1H4(1115),ex5(:),G1H2(225),m3h2x2(:,903),heltab2x4(:,:,903))
  call Hloop_A_Q(ntryL,G1H2(225),55,nMM,G2H2(895),n2h2(780))
call HGT_OLR(G1H4(1116),1,1,4)
call HGT_invQ_OLR(G1H4(1116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1116),-8,nMM,G2H4(69),n2h4(580))
  call Hloop_QV_A(ntryL,G2H4(69),ex4(:),G2H2(896),m3h2x2(:,904),heltab2x4(:,:,904))
  call Hloop_AV_Q(ntryL,G1H4(1121),ex5(:),G1H2(225),m3h2x2(:,905),heltab2x4(:,:,905))
  call Hloop_A_Q(ntryL,G1H2(225),55,nMM,G2H2(897),n2h2(781))
  call Hloop_AV_Q(ntryL,G1H4(1126),ex5(:),G1H2(225),m3h2x2(:,906),heltab2x4(:,:,906))
  call Hloop_A_Q(ntryL,G1H2(225),55,nMM,G2H2(898),n2h2(782))
call HGT_OLR(G1H4(1122),1,1,4)
call HGT_invQ_OLR(G1H4(1122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1122),-8,nMM,G2H4(19),n2h4(581))
  call Hloop_QV_A(ntryL,G2H4(19),ex4(:),G2H2(899),m3h2x2(:,907),heltab2x4(:,:,907))
  call Hloop_AV_Q(ntryL,G1H4(1125),ex5(:),G1H2(225),m3h2x2(:,908),heltab2x4(:,:,908))
  call Hloop_A_Q(ntryL,G1H2(225),55,nMM,G2H2(900),n2h2(783))
  call Hloop_AV_Q(ntryL,G0H4(93),ex5(:),G0H2(1),m3h2x2(:,909),heltab2x4(:,:,909))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(225),n2h2(784))
call HGT_OLR(G1H4(1127),1,1,4)
call HGT_invQ_OLR(G1H4(1127),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1127),-24,nMM,G2H4(73),n2h4(582))
  call Hloop_QV_A(ntryL,G2H4(73),ex4(:),G2H2(901),m3h2x2(:,910),heltab2x4(:,:,910))
  call Hloop_AV_Q(ntryL,G1H4(1130),ex5(:),G1H2(226),m3h2x2(:,911),heltab2x4(:,:,911))
  call Hloop_A_Q(ntryL,G1H2(226),55,nMM,G2H2(902),n2h2(785))
  call Hloop_AV_Q(ntryL,G0H4(94),ex5(:),G0H2(1),m3h2x2(:,912),heltab2x4(:,:,912))
  call Hloop_A_Q(ntryL,G0H2(1),55,nMM,G1H2(226),n2h2(786))
  call Hloop_QV_A(ntryL,G1H4(1131),ex5(:),G1H2(227),m3h2x2(:,913),heltab2x4(:,:,913))
  call Hloop_Q_A(ntryL,G1H2(227),55,0,G2H2(903),n2h2(787))
call HGT_OLR(G1H4(1132),1,1,4)
call HGT_invQ_OLR(G1H4(1132),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1132),-8,0,G2H4(77),n2h4(583))
  call Hloop_AV_Q(ntryL,G2H4(77),ex4(:),G2H2(904),m3h2x2(:,914),heltab2x4(:,:,914))
  call Hloop_QV_A(ntryL,G1H4(1137),ex5(:),G1H2(227),m3h2x2(:,915),heltab2x4(:,:,915))
  call Hloop_Q_A(ntryL,G1H2(227),55,0,G2H2(905),n2h2(788))
  call Hloop_QV_A(ntryL,G1H4(1142),ex5(:),G1H2(227),m3h2x2(:,916),heltab2x4(:,:,916))
  call Hloop_Q_A(ntryL,G1H2(227),55,0,G2H2(906),n2h2(789))
call HGT_OLR(G1H4(1138),1,1,4)
call HGT_invQ_OLR(G1H4(1138),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1138),-8,0,G2H4(10),n2h4(584))
  call Hloop_AV_Q(ntryL,G2H4(10),ex4(:),G2H2(907),m3h2x2(:,917),heltab2x4(:,:,917))
  call Hloop_QV_A(ntryL,G1H4(1141),ex5(:),G1H2(227),m3h2x2(:,918),heltab2x4(:,:,918))
  call Hloop_Q_A(ntryL,G1H2(227),55,0,G2H2(908),n2h2(790))
  call Hloop_QV_A(ntryL,G0H4(95),ex5(:),G0H2(1),m3h2x2(:,919),heltab2x4(:,:,919))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(227),n2h2(791))
call HGT_OLR(G1H4(1143),1,1,4)
call HGT_invQ_OLR(G1H4(1143),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1143),-24,0,G2H4(81),n2h4(585))
  call Hloop_AV_Q(ntryL,G2H4(81),ex4(:),G2H2(909),m3h2x2(:,920),heltab2x4(:,:,920))
  call Hloop_QV_A(ntryL,G1H4(1146),ex5(:),G1H2(228),m3h2x2(:,921),heltab2x4(:,:,921))
  call Hloop_Q_A(ntryL,G1H2(228),55,0,G2H2(910),n2h2(792))
  call Hloop_QV_A(ntryL,G0H4(96),ex5(:),G0H2(1),m3h2x2(:,922),heltab2x4(:,:,922))
  call Hloop_Q_A(ntryL,G0H2(1),55,0,G1H2(228),n2h2(793))
  call Hloop_AV_Q(ntryL,G1H4(1147),ex5(:),G1H2(229),m3h2x2(:,923),heltab2x4(:,:,923))
  call Hloop_A_Q(ntryL,G1H2(229),55,0,G2H2(911),n2h2(794))
call HGT_OLR(G1H4(1148),1,1,4)
call HGT_invQ_OLR(G1H4(1148),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1148),-8,0,G2H4(85),n2h4(586))
  call Hloop_QV_A(ntryL,G2H4(85),ex4(:),G2H2(912),m3h2x2(:,924),heltab2x4(:,:,924))
  call Hloop_AV_Q(ntryL,G1H4(1153),ex5(:),G1H2(229),m3h2x2(:,925),heltab2x4(:,:,925))
  call Hloop_A_Q(ntryL,G1H2(229),55,0,G2H2(913),n2h2(795))
  call Hloop_AV_Q(ntryL,G1H4(1158),ex5(:),G1H2(229),m3h2x2(:,926),heltab2x4(:,:,926))
  call Hloop_A_Q(ntryL,G1H2(229),55,0,G2H2(914),n2h2(796))
call HGT_OLR(G1H4(1154),1,1,4)
call HGT_invQ_OLR(G1H4(1154),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1154),-8,0,G2H4(13),n2h4(587))
  call Hloop_QV_A(ntryL,G2H4(13),ex4(:),G2H2(915),m3h2x2(:,927),heltab2x4(:,:,927))
  call Hloop_AV_Q(ntryL,G1H4(1157),ex5(:),G1H2(229),m3h2x2(:,928),heltab2x4(:,:,928))
  call Hloop_A_Q(ntryL,G1H2(229),55,0,G2H2(916),n2h2(797))
  call Hloop_AV_Q(ntryL,G0H4(97),ex5(:),G0H2(1),m3h2x2(:,929),heltab2x4(:,:,929))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(229),n2h2(798))
call HGT_OLR(G1H4(1159),1,1,4)
call HGT_invQ_OLR(G1H4(1159),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1159),-24,0,G2H4(89),n2h4(588))
  call Hloop_QV_A(ntryL,G2H4(89),ex4(:),G2H2(917),m3h2x2(:,930),heltab2x4(:,:,930))
  call Hloop_AV_Q(ntryL,G1H4(1162),ex5(:),G1H2(230),m3h2x2(:,931),heltab2x4(:,:,931))
  call Hloop_A_Q(ntryL,G1H2(230),55,0,G2H2(918),n2h2(799))
  call Hloop_AV_Q(ntryL,G0H4(98),ex5(:),G0H2(1),m3h2x2(:,932),heltab2x4(:,:,932))
  call Hloop_A_Q(ntryL,G0H2(1),55,0,G1H2(230),n2h2(800))
call HGT_OLR(G1H4(1164),1,1,4)
call HGT_invQ_OLR(G1H4(1164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1164),-24,nME,G2H4(63),n2h4(589))
  call Hloop_AV_Q(ntryL,G2H4(63),ex5(:),G2H2(919),m3h2x2(:,933),heltab2x4(:,:,933))
  call Hloop_QV_A(ntryL,G1H4(1167),ex4(:),G1H2(231),m3h2x2(:,934),heltab2x4(:,:,934))
  call Hloop_Q_A(ntryL,G1H2(231),47,nME,G2H2(920),n2h2(801))
  call Hloop_QV_A(ntryL,G0H4(99),ex4(:),G0H2(1),m3h2x2(:,935),heltab2x4(:,:,935))
  call Hloop_Q_A(ntryL,G0H2(1),47,nME,G1H2(231),n2h2(802))
  call Hloop_QV_A(ntryL,G1H4(1168),ex4(:),G1H2(232),m3h2x2(:,936),heltab2x4(:,:,936))
  call Hloop_Q_A(ntryL,G1H2(232),47,nMM,G2H2(921),n2h2(803))
call HGT_OLR(G1H4(1169),1,1,4)
call HGT_invQ_OLR(G1H4(1169),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1169),-16,nMM,G2H4(75),n2h4(590))
  call Hloop_AV_Q(ntryL,G2H4(75),ex5(:),G2H2(922),m3h2x2(:,937),heltab2x4(:,:,937))
  call Hloop_QV_A(ntryL,G1H4(1174),ex4(:),G1H2(232),m3h2x2(:,938),heltab2x4(:,:,938))
  call Hloop_Q_A(ntryL,G1H2(232),47,nMM,G2H2(923),n2h2(804))
  call Hloop_QV_A(ntryL,G1H4(1179),ex4(:),G1H2(232),m3h2x2(:,939),heltab2x4(:,:,939))
  call Hloop_Q_A(ntryL,G1H2(232),47,nMM,G2H2(924),n2h2(805))
call HGT_OLR(G1H4(1175),1,1,4)
call HGT_invQ_OLR(G1H4(1175),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1175),-16,nMM,G2H4(92),n2h4(591))
  call Hloop_AV_Q(ntryL,G2H4(92),ex5(:),G2H2(925),m3h2x2(:,940),heltab2x4(:,:,940))
  call Hloop_QV_A(ntryL,G1H4(1178),ex4(:),G1H2(232),m3h2x2(:,941),heltab2x4(:,:,941))
  call Hloop_Q_A(ntryL,G1H2(232),47,nMM,G2H2(926),n2h2(806))
  call Hloop_QV_A(ntryL,G0H4(100),ex4(:),G0H2(1),m3h2x2(:,942),heltab2x4(:,:,942))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(232),n2h2(807))
call HGT_OLR(G1H4(1180),1,1,4)
call HGT_invQ_OLR(G1H4(1180),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1180),-24,nMM,G2H4(70),n2h4(592))
  call Hloop_AV_Q(ntryL,G2H4(70),ex5(:),G2H2(927),m3h2x2(:,943),heltab2x4(:,:,943))
  call Hloop_QV_A(ntryL,G1H4(1183),ex4(:),G1H2(233),m3h2x2(:,944),heltab2x4(:,:,944))
  call Hloop_Q_A(ntryL,G1H2(233),47,nMM,G2H2(928),n2h2(808))
  call Hloop_QV_A(ntryL,G0H4(101),ex4(:),G0H2(1),m3h2x2(:,945),heltab2x4(:,:,945))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMM,G1H2(233),n2h2(809))
call HGT_OLR(G1H4(1185),1,1,4)
call HGT_invQ_OLR(G1H4(1185),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1185),-24,nME,G2H4(82),n2h4(593))
  call Hloop_QV_A(ntryL,G2H4(82),ex5(:),G2H2(929),m3h2x2(:,946),heltab2x4(:,:,946))
  call Hloop_AV_Q(ntryL,G1H4(1188),ex4(:),G1H2(234),m3h2x2(:,947),heltab2x4(:,:,947))
  call Hloop_A_Q(ntryL,G1H2(234),47,nME,G2H2(930),n2h2(810))
  call Hloop_AV_Q(ntryL,G0H4(102),ex4(:),G0H2(1),m3h2x2(:,948),heltab2x4(:,:,948))
  call Hloop_A_Q(ntryL,G0H2(1),47,nME,G1H2(234),n2h2(811))
  call Hloop_AV_Q(ntryL,G1H4(1189),ex4(:),G1H2(235),m3h2x2(:,949),heltab2x4(:,:,949))
  call Hloop_A_Q(ntryL,G1H2(235),47,nMM,G2H2(931),n2h2(812))
call HGT_OLR(G1H4(1190),1,1,4)
call HGT_invQ_OLR(G1H4(1190),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1190),-16,nMM,G2H4(87),n2h4(594))
  call Hloop_QV_A(ntryL,G2H4(87),ex5(:),G2H2(932),m3h2x2(:,950),heltab2x4(:,:,950))
  call Hloop_AV_Q(ntryL,G1H4(1195),ex4(:),G1H2(235),m3h2x2(:,951),heltab2x4(:,:,951))
  call Hloop_A_Q(ntryL,G1H2(235),47,nMM,G2H2(933),n2h2(813))
  call Hloop_AV_Q(ntryL,G1H4(1200),ex4(:),G1H2(235),m3h2x2(:,952),heltab2x4(:,:,952))
  call Hloop_A_Q(ntryL,G1H2(235),47,nMM,G2H2(934),n2h2(814))
call HGT_OLR(G1H4(1196),1,1,4)
call HGT_invQ_OLR(G1H4(1196),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1196),-16,nMM,G2H4(20),n2h4(595))
  call Hloop_QV_A(ntryL,G2H4(20),ex5(:),G2H2(935),m3h2x2(:,953),heltab2x4(:,:,953))
  call Hloop_AV_Q(ntryL,G1H4(1199),ex4(:),G1H2(235),m3h2x2(:,954),heltab2x4(:,:,954))
  call Hloop_A_Q(ntryL,G1H2(235),47,nMM,G2H2(936),n2h2(815))
  call Hloop_AV_Q(ntryL,G0H4(103),ex4(:),G0H2(1),m3h2x2(:,955),heltab2x4(:,:,955))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(235),n2h2(816))
call HGT_OLR(G1H4(1201),1,1,4)
call HGT_invQ_OLR(G1H4(1201),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1201),-24,nMM,G2H4(313),n2h4(596))
  call Hloop_QV_A(ntryL,G2H4(313),ex5(:),G2H2(937),m3h2x2(:,956),heltab2x4(:,:,956))
  call Hloop_AV_Q(ntryL,G1H4(1204),ex4(:),G1H2(236),m3h2x2(:,957),heltab2x4(:,:,957))
  call Hloop_A_Q(ntryL,G1H2(236),47,nMM,G2H2(938),n2h2(817))
  call Hloop_AV_Q(ntryL,G0H4(104),ex4(:),G0H2(1),m3h2x2(:,958),heltab2x4(:,:,958))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMM,G1H2(236),n2h2(818))
  call Hloop_QV_A(ntryL,G1H4(1205),ex4(:),G1H2(237),m3h2x2(:,959),heltab2x4(:,:,959))
  call Hloop_Q_A(ntryL,G1H2(237),47,0,G2H2(939),n2h2(819))
call HGT_OLR(G1H4(1206),1,1,4)
call HGT_invQ_OLR(G1H4(1206),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1206),-16,0,G2H4(24),n2h4(597))
  call Hloop_AV_Q(ntryL,G2H4(24),ex5(:),G2H2(940),m3h2x2(:,960),heltab2x4(:,:,960))
  call Hloop_QV_A(ntryL,G1H4(1211),ex4(:),G1H2(237),m3h2x2(:,961),heltab2x4(:,:,961))
  call Hloop_Q_A(ntryL,G1H2(237),47,0,G2H2(941),n2h2(820))
  call Hloop_QV_A(ntryL,G1H4(1216),ex4(:),G1H2(237),m3h2x2(:,962),heltab2x4(:,:,962))
  call Hloop_Q_A(ntryL,G1H2(237),47,0,G2H2(942),n2h2(821))
call HGT_OLR(G1H4(1212),1,1,4)
call HGT_invQ_OLR(G1H4(1212),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1212),-16,0,G2H4(361),n2h4(598))
  call Hloop_AV_Q(ntryL,G2H4(361),ex5(:),G2H2(943),m3h2x2(:,963),heltab2x4(:,:,963))
  call Hloop_QV_A(ntryL,G1H4(1215),ex4(:),G1H2(237),m3h2x2(:,964),heltab2x4(:,:,964))
  call Hloop_Q_A(ntryL,G1H2(237),47,0,G2H2(944),n2h2(822))
  call Hloop_QV_A(ntryL,G0H4(105),ex4(:),G0H2(1),m3h2x2(:,965),heltab2x4(:,:,965))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(237),n2h2(823))
call HGT_OLR(G1H4(1217),1,1,4)
call HGT_invQ_OLR(G1H4(1217),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1217),-24,0,G2H4(28),n2h4(599))
  call Hloop_AV_Q(ntryL,G2H4(28),ex5(:),G2H2(945),m3h2x2(:,966),heltab2x4(:,:,966))
  call Hloop_QV_A(ntryL,G1H4(1220),ex4(:),G1H2(238),m3h2x2(:,967),heltab2x4(:,:,967))
  call Hloop_Q_A(ntryL,G1H2(238),47,0,G2H2(946),n2h2(824))
  call Hloop_QV_A(ntryL,G0H4(106),ex4(:),G0H2(1),m3h2x2(:,968),heltab2x4(:,:,968))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(238),n2h2(825))
  call Hloop_AV_Q(ntryL,G1H4(1221),ex4(:),G1H2(239),m3h2x2(:,969),heltab2x4(:,:,969))
  call Hloop_A_Q(ntryL,G1H2(239),47,0,G2H2(947),n2h2(826))
call HGT_OLR(G1H4(1222),1,1,4)
call HGT_invQ_OLR(G1H4(1222),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1222),-16,0,G2H4(337),n2h4(600))
  call Hloop_QV_A(ntryL,G2H4(337),ex5(:),G2H2(948),m3h2x2(:,970),heltab2x4(:,:,970))
  call Hloop_AV_Q(ntryL,G1H4(1227),ex4(:),G1H2(239),m3h2x2(:,971),heltab2x4(:,:,971))
  call Hloop_A_Q(ntryL,G1H2(239),47,0,G2H2(949),n2h2(827))
  call Hloop_AV_Q(ntryL,G1H4(1232),ex4(:),G1H2(239),m3h2x2(:,972),heltab2x4(:,:,972))
  call Hloop_A_Q(ntryL,G1H2(239),47,0,G2H2(950),n2h2(828))
call HGT_OLR(G1H4(1228),1,1,4)
call HGT_invQ_OLR(G1H4(1228),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1228),-16,0,G2H4(32),n2h4(601))
  call Hloop_QV_A(ntryL,G2H4(32),ex5(:),G2H2(951),m3h2x2(:,973),heltab2x4(:,:,973))
  call Hloop_AV_Q(ntryL,G1H4(1231),ex4(:),G1H2(239),m3h2x2(:,974),heltab2x4(:,:,974))
  call Hloop_A_Q(ntryL,G1H2(239),47,0,G2H2(952),n2h2(829))
  call Hloop_AV_Q(ntryL,G0H4(107),ex4(:),G0H2(1),m3h2x2(:,975),heltab2x4(:,:,975))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(239),n2h2(830))
call HGT_OLR(G1H4(1233),1,1,4)
call HGT_invQ_OLR(G1H4(1233),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1233),-24,0,G2H4(67),n2h4(602))
  call Hloop_QV_A(ntryL,G2H4(67),ex5(:),G2H2(953),m3h2x2(:,976),heltab2x4(:,:,976))
  call Hloop_AV_Q(ntryL,G1H4(1236),ex4(:),G1H2(240),m3h2x2(:,977),heltab2x4(:,:,977))
  call Hloop_A_Q(ntryL,G1H2(240),47,0,G2H2(954),n2h2(831))
  call Hloop_AV_Q(ntryL,G0H4(108),ex4(:),G0H2(1),m3h2x2(:,978),heltab2x4(:,:,978))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(240),n2h2(832))
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(733),[G2H2(3),G1H2(6)])
call HGT_OLR(G2H2(4),1,1,2)
call HGT_invQ_OLR(G2H2(4),2,5,2)
call HGT_OLR(G2H2(4),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(735),[G2H2(5)])
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(661),[G2H2(8),G1H2(12)])
call HGT_OLR(G2H2(9),1,1,2)
call HGT_invQ_OLR(G2H2(9),2,5,2)
call HGT_OLR(G2H2(9),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(663),[G2H2(10)])
call HGT_OLR(G2H2(12),1,1,2)
call HGT_invQ_OLR(G2H2(12),2,5,2)
call HGT_OLR(G2H2(12),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(795),[G2H2(13),G1H2(18)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(797),[G2H2(15)])
call HGT_OLR(G2H2(17),1,1,2)
call HGT_invQ_OLR(G2H2(17),2,5,2)
call HGT_OLR(G2H2(17),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(723),[G2H2(18),G1H2(24)])
call HGT_OLR(G2H2(19),1,1,2)
call HGT_invQ_OLR(G2H2(19),2,5,2)
call HGT_OLR(G2H2(19),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(725),[G2H2(20)])
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(671),[G2H2(23),G1H2(30)])
call HGT_OLR(G2H2(24),1,1,2)
call HGT_invQ_OLR(G2H2(24),2,5,2)
call HGT_OLR(G2H2(24),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(673),[G2H2(25)])
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(785),[G2H2(28),G1H2(36)])
call HGT_OLR(G2H2(29),1,1,2)
call HGT_invQ_OLR(G2H2(29),2,5,2)
call HGT_OLR(G2H2(29),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(787),[G2H2(30)])
call HGT_OLR(G2H2(32),1,1,2)
call HGT_invQ_OLR(G2H2(32),2,5,2)
call HGT_OLR(G2H2(32),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(523),[G2H2(33),G1H2(42)])
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(525),[G2H2(35)])
call HGT_OLR(G2H2(37),1,1,2)
call HGT_invQ_OLR(G2H2(37),2,5,2)
call HGT_OLR(G2H2(37),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(532),[G2H2(38),G1H2(48)])
call HGT_OLR(G2H2(39),1,1,2)
call HGT_invQ_OLR(G2H2(39),2,5,2)
call HGT_OLR(G2H2(39),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(534),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(207),[G1H2(3)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(538),[G2H2(43),G1H2(54)])
call HGT_OLR(G2H2(44),1,1,2)
call HGT_invQ_OLR(G2H2(44),2,5,2)
call HGT_OLR(G2H2(44),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(540),[G2H2(45)])
call HGT_OLR(G2H2(47),1,1,2)
call HGT_invQ_OLR(G2H2(47),2,5,2)
call HGT_OLR(G2H2(47),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(48),G1H2(84),G1H2(60)])
call HGT_OLR(G2H2(49),1,1,2)
call HGT_invQ_OLR(G2H2(49),2,5,2)
call HGT_OLR(G2H2(49),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(223),[G1H2(39)])
call HGT_OLR(G2H2(52),1,1,2)
call HGT_invQ_OLR(G2H2(52),2,5,2)
call HGT_OLR(G2H2(52),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(53),G1H2(102),G1H2(66)])
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(55)])
call HGT_OLR(G2H2(57),1,1,2)
call HGT_invQ_OLR(G2H2(57),2,5,2)
call HGT_OLR(G2H2(57),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(526),[G2H2(58),G1H2(72)])
call HGT_OLR(G2H2(59),1,1,2)
call HGT_invQ_OLR(G2H2(59),2,5,2)
call HGT_OLR(G2H2(59),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(528),[G2H2(60)])
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(529),[G2H2(63),G1H2(78)])
call HGT_OLR(G2H2(64),1,1,2)
call HGT_invQ_OLR(G2H2(64),2,5,2)
call HGT_OLR(G2H2(64),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(531),[G2H2(65)])
call HGT_OLR(G2H2(67),1,1,2)
call HGT_invQ_OLR(G2H2(67),2,5,2)
call HGT_OLR(G2H2(67),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(247)])
call HGT_OLR(G2H2(69),1,1,2)
call HGT_invQ_OLR(G2H2(69),2,5,2)
call HGT_OLR(G2H2(69),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(255),[G1H2(75)])
call HGT_OLR(G2H2(72),1,1,2)
call HGT_invQ_OLR(G2H2(72),2,5,2)
call HGT_OLR(G2H2(72),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(73),G1H2(108),G1H2(90)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(263),[G1H2(21)])
call HGT_OLR(G2H2(77),1,1,2)
call HGT_invQ_OLR(G2H2(77),2,5,2)
call HGT_OLR(G2H2(77),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(535),[G2H2(78),G1H2(96)])
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(537),[G2H2(80)])
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(271)])
call HGT_OLR(G2H2(84),1,1,2)
call HGT_invQ_OLR(G2H2(84),2,5,2)
call HGT_OLR(G2H2(84),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(279),[G1H2(93)])
call HGT_OLR(G2H2(87),1,1,2)
call HGT_invQ_OLR(G2H2(87),2,5,2)
call HGT_OLR(G2H2(87),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(279)])
call HGT_OLR(G2H2(89),1,1,2)
call HGT_invQ_OLR(G2H2(89),2,5,2)
call HGT_OLR(G2H2(89),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(282)])
call HGT_OLR(G2H2(92),1,1,2)
call HGT_invQ_OLR(G2H2(92),2,5,2)
call HGT_OLR(G2H2(92),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(93),G1H2(126),G1H2(114)])
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(295),[G1H2(69)])
call HGT_OLR(G2H2(97),1,1,2)
call HGT_invQ_OLR(G2H2(97),2,5,2)
call HGT_OLR(G2H2(97),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(98),G1H2(138),G1H2(120)])
call HGT_OLR(G2H2(99),1,1,2)
call HGT_invQ_OLR(G2H2(99),2,5,2)
call HGT_OLR(G2H2(99),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(100)])
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(303)])
call HGT_OLR(G2H2(104),1,1,2)
call HGT_invQ_OLR(G2H2(104),2,5,2)
call HGT_OLR(G2H2(104),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(311),[G1H2(45)])
call HGT_OLR(G2H2(107),1,1,2)
call HGT_invQ_OLR(G2H2(107),2,5,2)
call HGT_OLR(G2H2(107),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(108),G1H2(144),G1H2(132)])
call HGT_OLR(G2H2(109),1,1,2)
call HGT_invQ_OLR(G2H2(109),2,5,2)
call HGT_OLR(G2H2(109),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(314)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(110)])
call HGT_OLR(G2H2(112),1,1,2)
call HGT_invQ_OLR(G2H2(112),2,5,2)
call HGT_OLR(G2H2(112),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(319)])
call HGT_OLR(G2H2(114),1,1,2)
call HGT_invQ_OLR(G2H2(114),2,5,2)
call HGT_OLR(G2H2(114),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(327),[G1H2(51)])
call HGT_OLR(G2H2(117),1,1,2)
call HGT_invQ_OLR(G2H2(117),2,5,2)
call HGT_OLR(G2H2(117),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(327)])
call HGT_OLR(G2H2(119),1,1,2)
call HGT_invQ_OLR(G2H2(119),2,5,2)
call HGT_OLR(G2H2(119),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G2H2(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(335),[G1H2(10),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(339),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(343),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(347),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(351),[G1H2(28),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(355),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(359),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(363),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(367),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(373),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(203),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(379),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(211),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(385),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(389),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(395),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(399),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(235),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(411),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(417),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(421),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(251),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(431),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(259),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(437),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(267),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(443),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(447),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(275),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(457),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(283),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(463),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(467),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(473),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(477),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(299),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(483),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(487),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(493),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(497),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(315),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(503),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(507),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(323),[G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(513),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(517),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(331),[G1H2(143)])
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(32),mass5set(:,1),  & 
G1H2(6),G1H2(12),G1H2(18),G1H2(24),G1H2(30),G1H2(36),2)
  call HG1shiftOLR(G1H2(12),2,2)
  call Hotf_5pt_reduction(G2H2(733),RedSet_5(17),mass5set(:,4),  & 
G1H2(42),G1H2(48),G1H2(3),G1H2(54),G1H2(84),G1H2(60),2)
  call HG1shiftOLR(G1H2(48),16,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(215),mass4set(:,1),  & 
G1H2(39),G1H2(102),G1H2(66),G1H2(72),G1H2(78),2)
  call HG1shiftOLR(G1H2(102),3,2)
  call Hotf_4pt_reduction(G2H2(735),RedSet_4(13),mass4set(:,1),  & 
G1H2(75),G1H2(108),G1H2(90),G1H2(21),G1H2(96),2)
  call HG1shiftOLR(G1H2(108),19,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(33),mass5set(:,1),  & 
G1H2(93),G1H2(126),G1H2(114),G1H2(69),G1H2(138),G1H2(120),2)
  call HG1shiftOLR(G1H2(126),2,2)
  call Hotf_5pt_reduction(G2H2(661),RedSet_5(18),mass5set(:,4),  & 
G1H2(45),G1H2(144),G1H2(132),G1H2(51),G1H2(10),G1H2(4),2)
  call HG1shiftOLR(G1H2(144),16,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(216),mass4set(:,1),  & 
G1H2(5),G1H2(9),G1H2(11),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(9),3,2)
  call Hotf_4pt_reduction(G2H2(663),RedSet_4(23),mass4set(:,1),  & 
G1H2(17),G1H2(28),G1H2(22),G1H2(23),G1H2(27),2)
  call HG1shiftOLR(G1H2(28),19,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(34),mass5set(:,1),  & 
G1H2(29),G1H2(33),G1H2(34),G1H2(35),G1H2(40),G1H2(41),2)
  call HG1shiftOLR(G1H2(33),1,2)
  call Hotf_5pt_reduction(G2H2(795),RedSet_5(19),mass5set(:,4),  & 
G1H2(46),G1H2(47),G1H2(52),G1H2(53),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(47),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(217),mass4set(:,1),  & 
G1H2(59),G1H2(63),G1H2(64),G1H2(65),G1H2(70),2)
  call HG1shiftOLR(G1H2(63),3,2)
  call Hotf_4pt_reduction(G2H2(797),RedSet_4(38),mass4set(:,1),  & 
G1H2(71),G1H2(76),G1H2(77),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(76),11,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(35),mass5set(:,1),  & 
G1H2(83),G1H2(87),G1H2(88),G1H2(89),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(87),1,2)
  call Hotf_5pt_reduction(G2H2(723),RedSet_5(17),mass5set(:,4),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(105),G1H2(106),G1H2(107),2)
  call HG1shiftOLR(G1H2(100),16,2)
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(215),mass4set(:,1),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(112),3,2)
  call Hotf_4pt_reduction(G2H2(725),RedSet_4(13),mass4set(:,1),  & 
G1H2(119),G1H2(123),G1H2(124),G1H2(125),G1H2(129),2)
  call HG1shiftOLR(G1H2(123),19,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(36),mass5set(:,1),  & 
G1H2(130),G1H2(131),G1H2(135),G1H2(136),G1H2(137),G1H2(141),2)
  call HG1shiftOLR(G1H2(131),1,2)
  call Hotf_5pt_reduction(G2H2(671),RedSet_5(18),mass5set(:,4),  & 
G1H2(142),G1H2(143),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(143),16,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(216),mass4set(:,1),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),2)
  call HG1shiftOLR(G1H2(246),3,2)
  call Hotf_4pt_reduction(G2H2(673),RedSet_4(23),mass4set(:,1),  & 
G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(251),19,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(37),mass5set(:,1),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),G1H2(260),2)
  call HG1shiftOLR(G1H2(256),2,2)
  call Hotf_5pt_reduction(G2H2(785),RedSet_5(19),mass5set(:,4),  & 
G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),G1H2(266),2)
  call HG1shiftOLR(G1H2(262),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(217),mass4set(:,1),  & 
G1H2(267),G1H2(268),G1H2(269),G1H2(270),G1H2(271),2)
  call HG1shiftOLR(G1H2(268),3,2)
  call Hotf_4pt_reduction(G2H2(787),RedSet_4(38),mass4set(:,1),  & 
G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(273),11,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(53),mass5set(:,2),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),4,2)
  call Hotf_5pt_reduction(G2H2(523),RedSet_5(20),mass5set(:,2),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),16,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(218),mass4set(:,4),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),2)
  call HG1shiftOLR(G1H2(290),5,2)
  call Hotf_4pt_reduction(G2H2(525),RedSet_4(78),mass4set(:,4),  & 
G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(295),21,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(54),mass5set(:,2),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),2)
  call HG1shiftOLR(G1H2(300),8,2)
  call Hotf_5pt_reduction(G2H2(532),RedSet_5(21),mass5set(:,2),  & 
G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(306),16,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(219),mass4set(:,4),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),2)
  call HG1shiftOLR(G1H2(312),10,2)
  call Hotf_4pt_reduction(G2H2(534),RedSet_4(91),mass4set(:,4),  & 
G1H2(316),G1H2(317),G1H2(318),G1H2(319),G1H2(320),2)
  call HG1shiftOLR(G1H2(317),26,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(55),mass5set(:,2),  & 
G1H2(321),G1H2(322),G1H2(323),G1H2(324),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(322),16,2)
  call Hotf_5pt_reduction(G2H2(538),RedSet_5(22),mass5set(:,2),  & 
G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),G1H2(332),2)
  call HG1shiftOLR(G1H2(328),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(4),mass4set(:,4),  & 
G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(334),18,2)
  call Hotf_4pt_reduction(G2H2(540),RedSet_4(91),mass4set(:,4),  & 
G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(339),26,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(56),mass5set(:,3),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),8,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(23),mass5set(:,3),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),16,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(220),mass4set(:,5),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),2)
  call HG1shiftOLR(G1H2(356),12,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(113),mass4set(:,5),  & 
G1H2(360),G1H2(361),G1H2(362),G1H2(363),G1H2(364),2)
  call HG1shiftOLR(G1H2(361),28,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(58),mass5set(:,3),  & 
G1H2(365),G1H2(366),G1H2(367),G1H2(368),G1H2(369),G1H2(370),2)
  call HG1shiftOLR(G1H2(366),16,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(24),mass5set(:,3),  & 
G1H2(371),G1H2(372),G1H2(373),G1H2(374),G1H2(375),G1H2(376),2)
  call HG1shiftOLR(G1H2(372),8,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(70),mass4set(:,5),  & 
G1H2(377),G1H2(378),G1H2(379),G1H2(380),G1H2(381),2)
  call HG1shiftOLR(G1H2(378),20,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(113),mass4set(:,5),  & 
G1H2(382),G1H2(383),G1H2(384),G1H2(385),G1H2(386),2)
  call HG1shiftOLR(G1H2(383),28,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(60),mass5set(:,2),  & 
G1H2(387),G1H2(388),G1H2(389),G1H2(390),G1H2(391),G1H2(392),2)
  call HG1shiftOLR(G1H2(388),4,2)
  call Hotf_5pt_reduction(G2H2(526),RedSet_5(25),mass5set(:,2),  & 
G1H2(393),G1H2(394),G1H2(395),G1H2(396),G1H2(397),G1H2(398),2)
  call HG1shiftOLR(G1H2(394),16,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(221),mass4set(:,4),  & 
G1H2(399),G1H2(400),G1H2(401),G1H2(402),G1H2(403),2)
  call HG1shiftOLR(G1H2(400),6,2)
  call Hotf_4pt_reduction(G2H2(528),RedSet_4(131),mass4set(:,4),  & 
G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(405),22,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(61),mass5set(:,2),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),8,2)
  call Hotf_5pt_reduction(G2H2(529),RedSet_5(26),mass5set(:,2),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),16,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(222),mass4set(:,4),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),2)
  call HG1shiftOLR(G1H2(422),9,2)
  call Hotf_4pt_reduction(G2H2(531),RedSet_4(140),mass4set(:,4),  & 
G1H2(426),G1H2(427),G1H2(428),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(427),25,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(62),mass5set(:,3),  & 
G1H2(431),G1H2(432),G1H2(433),G1H2(434),G1H2(435),G1H2(436),2)
  call HG1shiftOLR(G1H2(432),4,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(220),mass4set(:,5),  & 
G1H2(437),G1H2(438),G1H2(439),G1H2(440),G1H2(441),2)
  call HG1shiftOLR(G1H2(438),12,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(64),mass5set(:,3),  & 
G1H2(442),G1H2(443),G1H2(444),G1H2(445),G1H2(446),G1H2(447),2)
  call HG1shiftOLR(G1H2(443),16,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(27),mass5set(:,3),  & 
G1H2(448),G1H2(449),G1H2(450),G1H2(451),G1H2(452),G1H2(453),2)
  call HG1shiftOLR(G1H2(449),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(135),mass4set(:,5),  & 
G1H2(454),G1H2(455),G1H2(456),G1H2(457),G1H2(458),2)
  call HG1shiftOLR(G1H2(455),24,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(113),mass4set(:,5),  & 
G1H2(459),G1H2(460),G1H2(461),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(460),28,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(66),mass5set(:,2),  & 
G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),G1H2(469),2)
  call HG1shiftOLR(G1H2(465),16,2)
  call Hotf_5pt_reduction(G2H2(535),RedSet_5(28),mass5set(:,2),  & 
G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),G1H2(475),2)
  call HG1shiftOLR(G1H2(471),8,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(43),mass4set(:,4),  & 
G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(477),17,2)
  call Hotf_4pt_reduction(G2H2(537),RedSet_4(140),mass4set(:,4),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),2)
  call HG1shiftOLR(G1H2(482),25,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(67),mass5set(:,3),  & 
G1H2(486),G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),2)
  call HG1shiftOLR(G1H2(487),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(70),mass4set(:,5),  & 
G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(493),20,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(69),mass5set(:,3),  & 
G1H2(497),G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(498),8,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(135),mass4set(:,5),  & 
G1H2(503),G1H2(504),G1H2(505),G1H2(506),G1H2(507),2)
  call HG1shiftOLR(G1H2(504),24,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(71),mass5set(:,3),  & 
G1H2(508),G1H2(509),G1H2(510),G1H2(511),G1H2(512),G1H2(513),2)
  call HG1shiftOLR(G1H2(509),8,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(29),mass5set(:,3),  & 
G1H2(514),G1H2(515),G1H2(516),G1H2(517),G1H2(518),G1H2(519),2)
  call HG1shiftOLR(G1H2(515),16,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(223),mass4set(:,5),  & 
G1H2(520),G1H2(521),G1H2(522),G1H2(523),G1H2(524),2)
  call HG1shiftOLR(G1H2(521),12,2)
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(188),mass4set(:,5),  & 
G1H2(525),G1H2(526),G1H2(527),G1H2(528),G1H2(529),2)
  call HG1shiftOLR(G1H2(526),28,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(73),mass5set(:,3),  & 
G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),G1H2(535),2)
  call HG1shiftOLR(G1H2(531),16,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(30),mass5set(:,3),  & 
G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),G1H2(541),2)
  call HG1shiftOLR(G1H2(537),8,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(126),mass4set(:,5),  & 
G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(543),20,2)
  call Hotf_4pt_reduction(G2H2(115),RedSet_4(188),mass4set(:,5),  & 
G1H2(547),G1H2(548),G1H2(549),G1H2(550),G1H2(551),2)
  call HG1shiftOLR(G1H2(548),28,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(75),mass5set(:,3),  & 
G1H2(552),G1H2(553),G1H2(554),G1H2(555),G1H2(556),G1H2(557),2)
  call HG1shiftOLR(G1H2(553),4,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(223),mass4set(:,5),  & 
G1H2(558),G1H2(559),G1H2(560),G1H2(561),G1H2(562),2)
  call HG1shiftOLR(G1H2(559),12,2)
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(77),mass5set(:,3),  & 
G1H2(563),G1H2(564),G1H2(565),G1H2(566),G1H2(567),G1H2(568),2)
  call HG1shiftOLR(G1H2(564),16,2)
  call Hotf_5pt_reduction(G2H2(118),RedSet_5(31),mass5set(:,3),  & 
G1H2(569),G1H2(570),G1H2(571),G1H2(572),G1H2(573),G1H2(574),2)
  call HG1shiftOLR(G1H2(570),4,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(83),mass4set(:,5),  & 
G1H2(575),G1H2(576),G1H2(577),G1H2(578),G1H2(579),2)
  call HG1shiftOLR(G1H2(576),24,2)
  call Hotf_4pt_reduction(G2H2(120),RedSet_4(188),mass4set(:,5),  & 
G1H2(580),G1H2(581),G1H2(582),G1H2(583),G1H2(584),2)
  call HG1shiftOLR(G1H2(581),28,2)
  call Hotf_5pt_reduction(G2H2(112),RedSet_5(79),mass5set(:,3),  & 
G1H2(585),G1H2(586),G1H2(587),G1H2(588),G1H2(589),G1H2(590),2)
  call HG1shiftOLR(G1H2(586),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(126),mass4set(:,5),  & 
G1H2(591),G1H2(592),G1H2(593),G1H2(594),G1H2(595),2)
  call HG1shiftOLR(G1H2(592),20,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(81),mass5set(:,3),  & 
G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),G1H2(601),2)
  call HG1shiftOLR(G1H2(597),8,2)
  call Hotf_4pt_reduction(G2H2(119),RedSet_4(83),mass4set(:,5),  & 
G1H2(602),G1H2(603),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(603),24,2)
  call Hotf_5pt_reduction(G2H2(335),RedSet_5(83),mass5set(:,2),  & 
G1H2(607),G1H2(608),G1H2(609),G1H2(610),G1H2(611),G1H2(612),2)
  call HG1shiftOLR(G1H2(608),16,2)
  call Hotf_5pt_reduction(G2H2(167),RedSet_5(47),mass5set(:,2),  & 
G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(614),16,2)
  call Hotf_5pt_reduction(G2H2(339),RedSet_5(84),mass5set(:,2),  & 
G1H2(619),G1H2(620),G1H2(621),G1H2(622),G1H2(623),G1H2(624),2)
  call HG1shiftOLR(G1H2(620),16,2)
  call Hotf_5pt_reduction(G2H2(171),RedSet_5(48),mass5set(:,2),  & 
G1H2(625),G1H2(626),G1H2(627),G1H2(628),G1H2(629),G1H2(630),2)
  call HG1shiftOLR(G1H2(626),16,2)
  call Hotf_5pt_reduction(G2H2(343),RedSet_5(85),mass5set(:,2),  & 
G1H2(631),G1H2(632),G1H2(633),G1H2(634),G1H2(635),G1H2(636),2)
  call HG1shiftOLR(G1H2(632),8,2)
  call Hotf_5pt_reduction(G2H2(347),RedSet_5(86),mass5set(:,2),  & 
G1H2(637),G1H2(638),G1H2(639),G1H2(640),G1H2(641),G1H2(642),2)
  call HG1shiftOLR(G1H2(638),8,2)
  call Hotf_5pt_reduction(G2H2(175),RedSet_5(49),mass5set(:,2),  & 
G1H2(643),G1H2(644),G1H2(645),G1H2(646),G1H2(647),G1H2(648),2)
  call HG1shiftOLR(G1H2(644),8,2)
  call Hotf_5pt_reduction(G2H2(351),RedSet_5(87),mass5set(:,2),  & 
G1H2(649),G1H2(650),G1H2(651),G1H2(652),G1H2(653),G1H2(654),2)
  call HG1shiftOLR(G1H2(650),16,2)
  call Hotf_5pt_reduction(G2H2(179),RedSet_5(50),mass5set(:,2),  & 
G1H2(655),G1H2(656),G1H2(657),G1H2(658),G1H2(659),G1H2(660),2)
  call HG1shiftOLR(G1H2(656),16,2)
  call Hotf_5pt_reduction(G2H2(355),RedSet_5(88),mass5set(:,2),  & 
G1H2(661),G1H2(662),G1H2(663),G1H2(664),G1H2(665),G1H2(666),2)
  call HG1shiftOLR(G1H2(662),16,2)
  call Hotf_5pt_reduction(G2H2(183),RedSet_5(51),mass5set(:,2),  & 
G1H2(667),G1H2(668),G1H2(669),G1H2(670),G1H2(671),G1H2(672),2)
  call HG1shiftOLR(G1H2(668),16,2)
  call Hotf_5pt_reduction(G2H2(359),RedSet_5(89),mass5set(:,2),  & 
G1H2(673),G1H2(674),G1H2(675),G1H2(676),G1H2(677),G1H2(678),2)
  call HG1shiftOLR(G1H2(674),8,2)
  call Hotf_5pt_reduction(G2H2(363),RedSet_5(90),mass5set(:,2),  & 
G1H2(679),G1H2(680),G1H2(681),G1H2(682),G1H2(683),G1H2(684),2)
  call HG1shiftOLR(G1H2(680),8,2)
  call Hotf_5pt_reduction(G2H2(187),RedSet_5(52),mass5set(:,2),  & 
G1H2(685),G1H2(686),G1H2(687),G1H2(688),G1H2(689),G1H2(690),2)
  call HG1shiftOLR(G1H2(686),8,2)
  call Hotf_5pt_reduction(G2H2(367),RedSet_5(91),mass5set(:,3),  & 
G1H2(691),G1H2(692),G1H2(693),G1H2(694),G1H2(695),G1H2(696),2)
  call HG1shiftOLR(G1H2(692),16,2)
  call Hotf_5pt_reduction(G2H2(195),RedSet_5(44),mass5set(:,4),  & 
G1H2(697),G1H2(698),G1H2(699),G1H2(700),G1H2(701),G1H2(702),2)
  call HG1shiftOLR(G1H2(698),16,2)
  call Hotf_5pt_reduction(G2H2(373),RedSet_5(92),mass5set(:,3),  & 
G1H2(703),G1H2(704),G1H2(705),G1H2(706),G1H2(707),G1H2(708),2)
  call HG1shiftOLR(G1H2(704),16,2)
  call Hotf_5pt_reduction(G2H2(203),RedSet_5(46),mass5set(:,4),  & 
G1H2(709),G1H2(710),G1H2(711),G1H2(712),G1H2(713),G1H2(714),2)
  call HG1shiftOLR(G1H2(710),16,2)
  call Hotf_5pt_reduction(G2H2(379),RedSet_5(93),mass5set(:,3),  & 
G1H2(715),G1H2(716),G1H2(717),G1H2(718),G1H2(719),G1H2(720),2)
  call HG1shiftOLR(G1H2(716),8,2)
  call Hotf_5pt_reduction(G2H2(211),RedSet_5(45),mass5set(:,4),  & 
G1H2(721),G1H2(722),G1H2(723),G1H2(724),G1H2(725),G1H2(726),2)
  call HG1shiftOLR(G1H2(722),8,2)
  call Hotf_5pt_reduction(G2H2(385),RedSet_5(94),mass5set(:,7),  & 
G1H2(727),G1H2(728),G1H2(729),G1H2(730),G1H2(731),G1H2(732),2)
  call HG1shiftOLR(G1H2(728),16,2)
  call Hotf_5pt_reduction(G2H2(389),RedSet_5(38),mass5set(:,4),  & 
G1H2(733),G1H2(734),G1H2(735),G1H2(736),G1H2(737),G1H2(738),2)
  call HG1shiftOLR(G1H2(734),16,2)
  call Hotf_5pt_reduction(G2H2(219),RedSet_5(57),mass5set(:,3),  & 
G1H2(739),G1H2(740),G1H2(741),G1H2(742),G1H2(743),G1H2(744),2)
  call HG1shiftOLR(G1H2(740),16,2)
  call Hotf_5pt_reduction(G2H2(395),RedSet_5(95),mass5set(:,7),  & 
G1H2(745),G1H2(746),G1H2(747),G1H2(748),G1H2(749),G1H2(750),2)
  call HG1shiftOLR(G1H2(746),8,2)
  call Hotf_5pt_reduction(G2H2(399),RedSet_5(39),mass5set(:,4),  & 
G1H2(751),G1H2(752),G1H2(753),G1H2(754),G1H2(755),G1H2(756),2)
  call HG1shiftOLR(G1H2(752),8,2)
  call Hotf_5pt_reduction(G2H2(227),RedSet_5(59),mass5set(:,3),  & 
G1H2(757),G1H2(758),G1H2(759),G1H2(760),G1H2(761),G1H2(762),2)
  call HG1shiftOLR(G1H2(758),8,2)
  call Hotf_5pt_reduction(G2H2(405),RedSet_5(96),mass5set(:,3),  & 
G1H2(763),G1H2(764),G1H2(765),G1H2(766),G1H2(767),G1H2(768),2)
  call HG1shiftOLR(G1H2(764),16,2)
  call Hotf_5pt_reduction(G2H2(235),RedSet_5(44),mass5set(:,4),  & 
G1H2(769),G1H2(770),G1H2(771),G1H2(772),G1H2(773),G1H2(774),2)
  call HG1shiftOLR(G1H2(770),16,2)
  call Hotf_5pt_reduction(G2H2(411),RedSet_5(97),mass5set(:,3),  & 
G1H2(775),G1H2(776),G1H2(777),G1H2(778),G1H2(779),G1H2(780),2)
  call HG1shiftOLR(G1H2(776),16,2)
  call Hotf_5pt_reduction(G2H2(243),RedSet_5(46),mass5set(:,4),  & 
G1H2(781),G1H2(782),G1H2(783),G1H2(784),G1H2(785),G1H2(786),2)
  call HG1shiftOLR(G1H2(782),16,2)
  call Hotf_5pt_reduction(G2H2(417),RedSet_5(98),mass5set(:,7),  & 
G1H2(787),G1H2(788),G1H2(789),G1H2(790),G1H2(791),G1H2(792),2)
  call HG1shiftOLR(G1H2(788),16,2)
  call Hotf_5pt_reduction(G2H2(421),RedSet_5(40),mass5set(:,4),  & 
G1H2(793),G1H2(794),G1H2(795),G1H2(796),G1H2(797),G1H2(798),2)
  call HG1shiftOLR(G1H2(794),16,2)
  call Hotf_5pt_reduction(G2H2(251),RedSet_5(63),mass5set(:,3),  & 
G1H2(799),G1H2(800),G1H2(801),G1H2(802),G1H2(803),G1H2(804),2)
  call HG1shiftOLR(G1H2(800),16,2)
  call Hotf_5pt_reduction(G2H2(427),RedSet_5(99),mass5set(:,7),  & 
G1H2(805),G1H2(806),G1H2(807),G1H2(808),G1H2(809),G1H2(810),2)
  call HG1shiftOLR(G1H2(806),4,2)
  call Hotf_5pt_reduction(G2H2(431),RedSet_5(41),mass5set(:,4),  & 
G1H2(811),G1H2(812),G1H2(813),G1H2(814),G1H2(815),G1H2(816),2)
  call HG1shiftOLR(G1H2(812),4,2)
  call Hotf_5pt_reduction(G2H2(259),RedSet_5(65),mass5set(:,3),  & 
G1H2(817),G1H2(818),G1H2(819),G1H2(820),G1H2(821),G1H2(822),2)
  call HG1shiftOLR(G1H2(818),4,2)
  call Hotf_5pt_reduction(G2H2(437),RedSet_5(100),mass5set(:,3),  & 
G1H2(823),G1H2(824),G1H2(825),G1H2(826),G1H2(827),G1H2(828),2)
  call HG1shiftOLR(G1H2(824),8,2)
  call Hotf_5pt_reduction(G2H2(267),RedSet_5(45),mass5set(:,4),  & 
G1H2(829),G1H2(830),G1H2(831),G1H2(832),G1H2(833),G1H2(834),2)
  call HG1shiftOLR(G1H2(830),8,2)
  call Hotf_5pt_reduction(G2H2(443),RedSet_5(101),mass5set(:,7),  & 
G1H2(835),G1H2(836),G1H2(837),G1H2(838),G1H2(839),G1H2(840),2)
  call HG1shiftOLR(G1H2(836),8,2)
  call Hotf_5pt_reduction(G2H2(447),RedSet_5(42),mass5set(:,4),  & 
G1H2(841),G1H2(842),G1H2(843),G1H2(844),G1H2(845),G1H2(846),2)
  call HG1shiftOLR(G1H2(842),8,2)
  call Hotf_5pt_reduction(G2H2(275),RedSet_5(68),mass5set(:,3),  & 
G1H2(847),G1H2(848),G1H2(849),G1H2(850),G1H2(851),G1H2(852),2)
  call HG1shiftOLR(G1H2(848),8,2)
  call Hotf_5pt_reduction(G2H2(453),RedSet_5(102),mass5set(:,7),  & 
G1H2(853),G1H2(854),G1H2(855),G1H2(856),G1H2(857),G1H2(858),2)
  call HG1shiftOLR(G1H2(854),4,2)
  call Hotf_5pt_reduction(G2H2(457),RedSet_5(43),mass5set(:,4),  & 
G1H2(859),G1H2(860),G1H2(861),G1H2(862),G1H2(863),G1H2(864),2)
  call HG1shiftOLR(G1H2(860),4,2)
  call Hotf_5pt_reduction(G2H2(283),RedSet_5(70),mass5set(:,3),  & 
G1H2(865),G1H2(866),G1H2(867),G1H2(868),G1H2(869),G1H2(870),2)
  call HG1shiftOLR(G1H2(866),4,2)
  call Hotf_5pt_reduction(G2H2(463),RedSet_5(103),mass5set(:,7),  & 
G1H2(871),G1H2(872),G1H2(873),G1H2(874),G1H2(875),G1H2(876),2)
  call HG1shiftOLR(G1H2(872),16,2)
  call Hotf_5pt_reduction(G2H2(467),RedSet_5(38),mass5set(:,4),  & 
G1H2(877),G1H2(878),G1H2(879),G1H2(880),G1H2(881),G1H2(882),2)
  call HG1shiftOLR(G1H2(878),16,2)
  call Hotf_5pt_reduction(G2H2(291),RedSet_5(72),mass5set(:,3),  & 
G1H2(883),G1H2(884),G1H2(885),G1H2(886),G1H2(887),G1H2(888),2)
  call HG1shiftOLR(G1H2(884),16,2)
  call Hotf_5pt_reduction(G2H2(473),RedSet_5(104),mass5set(:,7),  & 
G1H2(889),G1H2(890),G1H2(891),G1H2(892),G1H2(893),G1H2(894),2)
  call HG1shiftOLR(G1H2(890),8,2)
  call Hotf_5pt_reduction(G2H2(477),RedSet_5(39),mass5set(:,4),  & 
G1H2(895),G1H2(896),G1H2(897),G1H2(898),G1H2(899),G1H2(900),2)
  call HG1shiftOLR(G1H2(896),8,2)
  call Hotf_5pt_reduction(G2H2(299),RedSet_5(74),mass5set(:,3),  & 
G1H2(901),G1H2(902),G1H2(903),G1H2(904),G1H2(905),G1H2(906),2)
  call HG1shiftOLR(G1H2(902),8,2)
  call Hotf_5pt_reduction(G2H2(483),RedSet_5(105),mass5set(:,7),  & 
G1H2(907),G1H2(908),G1H2(909),G1H2(910),G1H2(911),G1H2(912),2)
  call HG1shiftOLR(G1H2(908),16,2)
  call Hotf_5pt_reduction(G2H2(487),RedSet_5(40),mass5set(:,4),  & 
G1H2(913),G1H2(914),G1H2(915),G1H2(916),G1H2(917),G1H2(918),2)
  call HG1shiftOLR(G1H2(914),16,2)
  call Hotf_5pt_reduction(G2H2(307),RedSet_5(76),mass5set(:,3),  & 
G1H2(919),G1H2(920),G1H2(921),G1H2(922),G1H2(923),G1H2(924),2)
  call HG1shiftOLR(G1H2(920),16,2)
  call Hotf_5pt_reduction(G2H2(493),RedSet_5(106),mass5set(:,7),  & 
G1H2(925),G1H2(926),G1H2(927),G1H2(928),G1H2(929),G1H2(930),2)
  call HG1shiftOLR(G1H2(926),4,2)
  call Hotf_5pt_reduction(G2H2(497),RedSet_5(41),mass5set(:,4),  & 
G1H2(931),G1H2(932),G1H2(933),G1H2(934),G1H2(935),G1H2(936),2)
  call HG1shiftOLR(G1H2(932),4,2)
  call Hotf_5pt_reduction(G2H2(315),RedSet_5(78),mass5set(:,3),  & 
G1H2(937),G1H2(938),G1H2(939),G1H2(940),G1H2(941),G1H2(942),2)
  call HG1shiftOLR(G1H2(938),4,2)
  call Hotf_5pt_reduction(G2H2(503),RedSet_5(107),mass5set(:,7),  & 
G1H2(943),G1H2(944),G1H2(945),G1H2(946),G1H2(947),G1H2(948),2)
  call HG1shiftOLR(G1H2(944),8,2)
  call Hotf_5pt_reduction(G2H2(507),RedSet_5(42),mass5set(:,4),  & 
G1H2(949),G1H2(950),G1H2(951),G1H2(952),G1H2(953),G1H2(954),2)
  call HG1shiftOLR(G1H2(950),8,2)
  call Hotf_5pt_reduction(G2H2(323),RedSet_5(80),mass5set(:,3),  & 
G1H2(955),G1H2(956),G1H2(957),G1H2(958),G1H2(959),G1H2(960),2)
  call HG1shiftOLR(G1H2(956),8,2)
  call Hotf_5pt_reduction(G2H2(513),RedSet_5(108),mass5set(:,7),  & 
G1H2(961),G1H2(962),G1H2(963),G1H2(964),G1H2(965),G1H2(966),2)
  call HG1shiftOLR(G1H2(962),4,2)
  call Hotf_5pt_reduction(G2H2(517),RedSet_5(43),mass5set(:,4),  & 
G1H2(967),G1H2(968),G1H2(969),G1H2(970),G1H2(971),G1H2(972),2)
  call HG1shiftOLR(G1H2(968),4,2)
  call Hotf_5pt_reduction(G2H2(331),RedSet_5(82),mass5set(:,3),  & 
G1H2(973),G1H2(974),G1H2(975),G1H2(976),G1H2(977),G1H2(978),2)
  call HG1shiftOLR(G1H2(974),4,2)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(3),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(55),G1H4(56),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(26),9,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(38),mass4set(:,1),  & 
G1H4(169),G1H4(170),G1H4(199),G1H4(200),G1H4(113),4)
  call HG1shiftOLR(G1H4(170),11,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(6),mass5set(:,1),  & 
G1H4(75),G1H4(374),G1H4(375),G1H4(389),G1H4(390),G1H4(422),4)
  call HG1shiftOLR(G1H4(374),10,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(38),mass4set(:,1),  & 
G1H4(423),G1H4(437),G1H4(438),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(437),11,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(4),mass5set(:,1),  & 
G1H4(476),G1H4(477),G1H4(491),G1H4(492),G1H4(506),G1H4(507),4)
  call HG1shiftOLR(G1H4(477),17,4)
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(13),mass4set(:,1),  & 
G1H4(521),G1H4(522),G1H4(536),G1H4(537),G1H4(551),4)
  call HG1shiftOLR(G1H4(522),19,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(5),mass5set(:,1),  & 
G1H4(552),G1H4(566),G1H4(567),G1H4(635),G1H4(636),G1H4(651),4)
  call HG1shiftOLR(G1H4(566),17,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(23),mass4set(:,1),  & 
G1H4(652),G1H4(667),G1H4(668),G1H4(683),G1H4(684),4)
  call HG1shiftOLR(G1H4(667),19,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(1),mass5set(:,1),  & 
G1H4(699),G1H4(700),G1H4(715),G1H4(716),G1H4(731),G1H4(732),4)
  call HG1shiftOLR(G1H4(700),18,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(13),mass4set(:,1),  & 
G1H4(747),G1H4(748),G1H4(763),G1H4(764),G1H4(779),4)
  call HG1shiftOLR(G1H4(748),19,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(2),mass5set(:,1),  & 
G1H4(780),G1H4(795),G1H4(796),G1H4(811),G1H4(812),G1H4(827),4)
  call HG1shiftOLR(G1H4(795),18,4)
  call Hotf_4pt_reduction(G2H4(53),RedSet_4(23),mass4set(:,1),  & 
G1H4(828),G1H4(843),G1H4(844),G1H4(859),G1H4(860),4)
  call HG1shiftOLR(G1H4(843),19,4)
  call Hotf_4pt_reduction(G2H2(170),RedSet_4(11),mass4set(:,4),  & 
G1H2(979),G1H2(980),G1H2(981),G1H2(982),G1H2(983),2)
  call HG1shiftOLR(G1H2(980),18,2)
  call Hotf_4pt_reduction(G2H2(174),RedSet_4(21),mass4set(:,4),  & 
G1H2(984),G1H2(985),G1H2(986),G1H2(987),G1H2(988),2)
  call HG1shiftOLR(G1H2(985),18,2)
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(36),mass4set(:,4),  & 
G1H2(989),G1H2(990),G1H2(991),G1H2(992),G1H2(993),2)
  call HG1shiftOLR(G1H2(990),9,2)
  call Hotf_4pt_reduction(G2H2(182),RedSet_4(48),mass4set(:,4),  & 
G1H2(994),G1H2(995),G1H2(996),G1H2(997),G1H2(998),2)
  call HG1shiftOLR(G1H2(995),17,2)
  call Hotf_4pt_reduction(G2H2(186),RedSet_4(54),mass4set(:,4),  & 
G1H2(999),G1H2(1000),G1H2(1001),G1H2(1002),G1H2(1003),2)
  call HG1shiftOLR(G1H2(1000),17,2)
  call Hotf_4pt_reduction(G2H2(190),RedSet_4(64),mass4set(:,4),  & 
G1H2(1004),G1H2(1005),G1H2(1006),G1H2(1007),G1H2(1008),2)
  call HG1shiftOLR(G1H2(1005),10,2)
  call Hotf_4pt_reduction(G2H2(198),RedSet_4(76),mass4set(:,1),  & 
G1H2(1009),G1H2(1010),G1H2(1011),G1H2(1012),G1H2(1013),2)
  call HG1shiftOLR(G1H2(1010),20,2)
  call Hotf_4pt_reduction(G2H2(206),RedSet_4(89),mass4set(:,1),  & 
G1H2(1014),G1H2(1015),G1H2(1016),G1H2(1017),G1H2(1018),2)
  call HG1shiftOLR(G1H2(1015),24,2)
  call Hotf_4pt_reduction(G2H2(214),RedSet_4(89),mass4set(:,1),  & 
G1H2(1019),G1H2(1020),G1H2(1021),G1H2(1022),G1H2(1023),2)
  call HG1shiftOLR(G1H2(1020),24,2)
  call Hotf_4pt_reduction(G2H2(222),RedSet_4(111),mass4set(:,5),  & 
G1H2(1024),G1H2(1025),G1H2(1026),G1H2(1027),G1H2(1028),2)
  call HG1shiftOLR(G1H2(1025),24,2)
  call Hotf_4pt_reduction(G2H2(230),RedSet_4(111),mass4set(:,5),  & 
G1H2(1029),G1H2(1030),G1H2(1031),G1H2(1032),G1H2(1033),2)
  call HG1shiftOLR(G1H2(1030),24,2)
  call Hotf_4pt_reduction(G2H2(238),RedSet_4(76),mass4set(:,1),  & 
G1H2(1034),G1H2(1035),G1H2(1036),G1H2(1037),G1H2(1038),2)
  call HG1shiftOLR(G1H2(1035),20,2)
  call Hotf_4pt_reduction(G2H2(246),RedSet_4(89),mass4set(:,1),  & 
G1H2(1039),G1H2(1040),G1H2(1041),G1H2(1042),G1H2(1043),2)
  call HG1shiftOLR(G1H2(1040),24,2)
  call Hotf_4pt_reduction(G2H2(254),RedSet_4(148),mass4set(:,5),  & 
G1H2(1044),G1H2(1045),G1H2(1046),G1H2(1047),G1H2(1048),2)
  call HG1shiftOLR(G1H2(1045),20,2)
  call Hotf_4pt_reduction(G2H2(262),RedSet_4(148),mass4set(:,5),  & 
G1H2(1049),G1H2(1050),G1H2(1051),G1H2(1052),G1H2(1053),2)
  call HG1shiftOLR(G1H2(1050),20,2)
  call Hotf_4pt_reduction(G2H2(270),RedSet_4(89),mass4set(:,1),  & 
G1H2(1054),G1H2(1055),G1H2(1056),G1H2(1057),G1H2(1058),2)
  call HG1shiftOLR(G1H2(1055),24,2)
  call Hotf_4pt_reduction(G2H2(278),RedSet_4(173),mass4set(:,5),  & 
G1H2(1059),G1H2(1060),G1H2(1061),G1H2(1062),G1H2(1063),2)
  call HG1shiftOLR(G1H2(1060),12,2)
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(173),mass4set(:,5),  & 
G1H2(1064),G1H2(1065),G1H2(1066),G1H2(1067),G1H2(1068),2)
  call HG1shiftOLR(G1H2(1065),12,2)
  call Hotf_4pt_reduction(G2H2(294),RedSet_4(186),mass4set(:,5),  & 
G1H2(1069),G1H2(1070),G1H2(1071),G1H2(1072),G1H2(1073),2)
  call HG1shiftOLR(G1H2(1070),24,2)
  call Hotf_4pt_reduction(G2H2(302),RedSet_4(186),mass4set(:,5),  & 
G1H2(1074),G1H2(1075),G1H2(1076),G1H2(1077),G1H2(1078),2)
  call HG1shiftOLR(G1H2(1075),24,2)
  call Hotf_4pt_reduction(G2H2(310),RedSet_4(199),mass4set(:,5),  & 
G1H2(1079),G1H2(1080),G1H2(1081),G1H2(1082),G1H2(1083),2)
  call HG1shiftOLR(G1H2(1080),20,2)
  call Hotf_4pt_reduction(G2H2(318),RedSet_4(199),mass4set(:,5),  & 
G1H2(1084),G1H2(1085),G1H2(1086),G1H2(1087),G1H2(1088),2)
  call HG1shiftOLR(G1H2(1085),20,2)
  call Hotf_4pt_reduction(G2H2(326),RedSet_4(210),mass4set(:,5),  & 
G1H2(1089),G1H2(1090),G1H2(1091),G1H2(1092),G1H2(1093),2)
  call HG1shiftOLR(G1H2(1090),12,2)
  call Hotf_4pt_reduction(G2H2(334),RedSet_4(210),mass4set(:,5),  & 
G1H2(1094),G1H2(1095),G1H2(1096),G1H2(1097),G1H2(1098),2)
  call HG1shiftOLR(G1H2(1095),12,2)
  call Hotf_4pt_reduction(G2H2(338),RedSet_4(8),mass4set(:,4),  & 
G1H2(1099),G1H2(1100),G1H2(1101),G1H2(1102),G1H2(1103),2)
  call HG1shiftOLR(G1H2(1100),18,2)
  call Hotf_4pt_reduction(G2H2(342),RedSet_4(18),mass4set(:,4),  & 
G1H2(1104),G1H2(1105),G1H2(1106),G1H2(1107),G1H2(1108),2)
  call HG1shiftOLR(G1H2(1105),18,2)
  call Hotf_4pt_reduction(G2H2(346),RedSet_4(29),mass4set(:,4),  & 
G1H2(1109),G1H2(1110),G1H2(1111),G1H2(1112),G1H2(1113),2)
  call HG1shiftOLR(G1H2(1110),9,2)
  call Hotf_4pt_reduction(G2H2(350),RedSet_4(33),mass4set(:,4),  & 
G1H2(1114),G1H2(1115),G1H2(1116),G1H2(1117),G1H2(1118),2)
  call HG1shiftOLR(G1H2(1115),9,2)
  call Hotf_4pt_reduction(G2H2(354),RedSet_4(46),mass4set(:,4),  & 
G1H2(1119),G1H2(1120),G1H2(1121),G1H2(1122),G1H2(1123),2)
  call HG1shiftOLR(G1H2(1120),17,2)
  call Hotf_4pt_reduction(G2H2(358),RedSet_4(52),mass4set(:,4),  & 
G1H2(1124),G1H2(1125),G1H2(1126),G1H2(1127),G1H2(1128),2)
  call HG1shiftOLR(G1H2(1125),17,2)
  call Hotf_4pt_reduction(G2H2(362),RedSet_4(59),mass4set(:,4),  & 
G1H2(1129),G1H2(1130),G1H2(1131),G1H2(1132),G1H2(1133),2)
  call HG1shiftOLR(G1H2(1130),10,2)
  call Hotf_4pt_reduction(G2H2(366),RedSet_4(62),mass4set(:,4),  & 
G1H2(1134),G1H2(1135),G1H2(1136),G1H2(1137),G1H2(1138),2)
  call HG1shiftOLR(G1H2(1135),10,2)
  call Hotf_4pt_reduction(G2H2(370),RedSet_4(74),mass4set(:,5),  & 
G1H2(1139),G1H2(1140),G1H2(1141),G1H2(1142),G1H2(1143),2)
  call HG1shiftOLR(G1H2(1140),20,2)
  call Hotf_4pt_reduction(G2H2(376),RedSet_4(87),mass4set(:,5),  & 
G1H2(1144),G1H2(1145),G1H2(1146),G1H2(1147),G1H2(1148),2)
  call HG1shiftOLR(G1H2(1145),24,2)
  call Hotf_4pt_reduction(G2H2(382),RedSet_4(87),mass4set(:,5),  & 
G1H2(1149),G1H2(1150),G1H2(1151),G1H2(1152),G1H2(1153),2)
  call HG1shiftOLR(G1H2(1150),24,2)
  call Hotf_4pt_reduction(G2H2(388),RedSet_4(105),mass4set(:,6),  & 
G1H2(1154),G1H2(1155),G1H2(1156),G1H2(1157),G1H2(1158),2)
  call HG1shiftOLR(G1H2(1155),24,2)
  call Hotf_4pt_reduction(G2H2(392),RedSet_4(108),mass4set(:,1),  & 
G1H2(1159),G1H2(1160),G1H2(1161),G1H2(1162),G1H2(1163),2)
  call HG1shiftOLR(G1H2(1160),24,2)
  call Hotf_4pt_reduction(G2H2(398),RedSet_4(105),mass4set(:,6),  & 
G1H2(1164),G1H2(1165),G1H2(1166),G1H2(1167),G1H2(1168),2)
  call HG1shiftOLR(G1H2(1165),24,2)
  call Hotf_4pt_reduction(G2H2(402),RedSet_4(108),mass4set(:,1),  & 
G1H2(1169),G1H2(1170),G1H2(1171),G1H2(1172),G1H2(1173),2)
  call HG1shiftOLR(G1H2(1170),24,2)
  call Hotf_4pt_reduction(G2H2(408),RedSet_4(129),mass4set(:,5),  & 
G1H2(1174),G1H2(1175),G1H2(1176),G1H2(1177),G1H2(1178),2)
  call HG1shiftOLR(G1H2(1175),20,2)
  call Hotf_4pt_reduction(G2H2(414),RedSet_4(138),mass4set(:,5),  & 
G1H2(1179),G1H2(1180),G1H2(1181),G1H2(1182),G1H2(1183),2)
  call HG1shiftOLR(G1H2(1180),24,2)
  call Hotf_4pt_reduction(G2H2(420),RedSet_4(144),mass4set(:,6),  & 
G1H2(1184),G1H2(1185),G1H2(1186),G1H2(1187),G1H2(1188),2)
  call HG1shiftOLR(G1H2(1185),20,2)
  call Hotf_4pt_reduction(G2H2(424),RedSet_4(146),mass4set(:,1),  & 
G1H2(1189),G1H2(1190),G1H2(1191),G1H2(1192),G1H2(1193),2)
  call HG1shiftOLR(G1H2(1190),20,2)
  call Hotf_4pt_reduction(G2H2(430),RedSet_4(144),mass4set(:,6),  & 
G1H2(1194),G1H2(1195),G1H2(1196),G1H2(1197),G1H2(1198),2)
  call HG1shiftOLR(G1H2(1195),20,2)
  call Hotf_4pt_reduction(G2H2(434),RedSet_4(146),mass4set(:,1),  & 
G1H2(1199),G1H2(1200),G1H2(1201),G1H2(1202),G1H2(1203),2)
  call HG1shiftOLR(G1H2(1200),20,2)
  call Hotf_4pt_reduction(G2H2(440),RedSet_4(138),mass4set(:,5),  & 
G1H2(1204),G1H2(1205),G1H2(1206),G1H2(1207),G1H2(1208),2)
  call HG1shiftOLR(G1H2(1205),24,2)
  call Hotf_4pt_reduction(G2H2(446),RedSet_4(168),mass4set(:,6),  & 
G1H2(1209),G1H2(1210),G1H2(1211),G1H2(1212),G1H2(1213),2)
  call HG1shiftOLR(G1H2(1210),12,2)
  call Hotf_4pt_reduction(G2H2(450),RedSet_4(171),mass4set(:,1),  & 
G1H2(1214),G1H2(1215),G1H2(1216),G1H2(1217),G1H2(1218),2)
  call HG1shiftOLR(G1H2(1215),12,2)
  call Hotf_4pt_reduction(G2H2(456),RedSet_4(168),mass4set(:,6),  & 
G1H2(1219),G1H2(1220),G1H2(1221),G1H2(1222),G1H2(1223),2)
  call HG1shiftOLR(G1H2(1220),12,2)
  call Hotf_4pt_reduction(G2H2(460),RedSet_4(171),mass4set(:,1),  & 
G1H2(1224),G1H2(1225),G1H2(1226),G1H2(1227),G1H2(1228),2)
  call HG1shiftOLR(G1H2(1225),12,2)
  call Hotf_4pt_reduction(G2H2(466),RedSet_4(183),mass4set(:,6),  & 
G1H2(1229),G1H2(1230),G1H2(1231),G1H2(1232),G1H2(1233),2)
  call HG1shiftOLR(G1H2(1230),24,2)
  call Hotf_4pt_reduction(G2H2(470),RedSet_4(108),mass4set(:,1),  & 
G1H2(1234),G1H2(1235),G1H2(1236),G1H2(1237),G1H2(1238),2)
  call HG1shiftOLR(G1H2(1235),24,2)
  call Hotf_4pt_reduction(G2H2(476),RedSet_4(183),mass4set(:,6),  & 
G1H2(1239),G1H2(1240),G1H2(1241),G1H2(1242),G1H2(1243),2)
  call HG1shiftOLR(G1H2(1240),24,2)
  call Hotf_4pt_reduction(G2H2(480),RedSet_4(108),mass4set(:,1),  & 
G1H2(1244),G1H2(1245),G1H2(1246),G1H2(1247),G1H2(1248),2)
  call HG1shiftOLR(G1H2(1245),24,2)
  call Hotf_4pt_reduction(G2H2(486),RedSet_4(197),mass4set(:,6),  & 
G1H2(1249),G1H2(1250),G1H2(1251),G1H2(1252),G1H2(1253),2)
  call HG1shiftOLR(G1H2(1250),20,2)
  call Hotf_4pt_reduction(G2H2(490),RedSet_4(146),mass4set(:,1),  & 
G1H2(1254),G1H2(1255),G1H2(1256),G1H2(1257),G1H2(1258),2)
  call HG1shiftOLR(G1H2(1255),20,2)
  call Hotf_4pt_reduction(G2H2(496),RedSet_4(197),mass4set(:,6),  & 
G1H2(1259),G1H2(1260),G1H2(1261),G1H2(1262),G1H2(1263),2)
  call HG1shiftOLR(G1H2(1260),20,2)
  call Hotf_4pt_reduction(G2H2(500),RedSet_4(146),mass4set(:,1),  & 
G1H2(1264),G1H2(1265),G1H2(1266),G1H2(1267),G1H2(1268),2)
  call HG1shiftOLR(G1H2(1265),20,2)
  call Hotf_4pt_reduction(G2H2(506),RedSet_4(208),mass4set(:,6),  & 
G1H2(1269),G1H2(1270),G1H2(1271),G1H2(1272),G1H2(1273),2)
  call HG1shiftOLR(G1H2(1270),12,2)
  call Hotf_4pt_reduction(G2H2(510),RedSet_4(171),mass4set(:,1),  & 
G1H2(1274),G1H2(1275),G1H2(1276),G1H2(1277),G1H2(1278),2)
  call HG1shiftOLR(G1H2(1275),12,2)
  call Hotf_4pt_reduction(G2H2(516),RedSet_4(208),mass4set(:,6),  & 
G1H2(1279),G1H2(1280),G1H2(1281),G1H2(1282),G1H2(1283),2)
  call HG1shiftOLR(G1H2(1280),12,2)
  call Hotf_4pt_reduction(G2H2(520),RedSet_4(171),mass4set(:,1),  & 
G1H2(1284),G1H2(1285),G1H2(1286),G1H2(1287),G1H2(1288),2)
  call HG1shiftOLR(G1H2(1285),12,2)
  call Hloop_QV_A(ntryL,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(1),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(3),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(5),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(7),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(9),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(11),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(13),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(15),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(17),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(19),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(21),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(23),n2h1(60))
  call Hotf_5pt_reduction(G2H2(565),RedSet_5(42),mass5set(:,5),  & 
G1H2(128),G1H2(140),G1H2(8),G1H2(14),G1H2(25),G1H2(32),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_4pt_reduction(G2H2(568),RedSet_4(171),mass4set(:,2),  & 
G1H2(44),G1H2(55),G1H2(67),G1H2(74),G1H2(86),2)
  call HG1shiftOLR(G1H2(55),12,2)
  call Hloop_AV_Q(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(25),n2h1(61))
  call Hotf_5pt_reduction(G2H2(573),RedSet_5(42),mass5set(:,5),  & 
G1H2(92),G1H2(127),G1H2(1289),G1H2(1290),G1H2(1291),G1H2(1292),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hotf_4pt_reduction(G2H2(576),RedSet_4(171),mass4set(:,2),  & 
G1H2(1293),G1H2(1294),G1H2(1295),G1H2(1296),G1H2(1297),2)
  call HG1shiftOLR(G1H2(1294),12,2)
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(27),n2h1(62))
  call Hotf_5pt_reduction(G2H2(581),RedSet_5(42),mass5set(:,6),  & 
G1H2(50),G1H2(1298),G1H2(1299),G1H2(1300),G1H2(1301),G1H2(1302),2)
  call HG1shiftOLR(G1H2(1298),8,2)
  call Hotf_4pt_reduction(G2H2(584),RedSet_4(171),mass4set(:,3),  & 
G1H2(1303),G1H2(1304),G1H2(1305),G1H2(1306),G1H2(1307),2)
  call HG1shiftOLR(G1H2(1304),12,2)
  call Hloop_AV_Q(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(63))
  call Hotf_5pt_reduction(G2H2(589),RedSet_5(42),mass5set(:,6),  & 
G1H2(109),G1H2(1308),G1H2(1309),G1H2(1310),G1H2(1311),G1H2(1312),2)
  call HG1shiftOLR(G1H2(1308),8,2)
  call Hotf_4pt_reduction(G2H2(592),RedSet_4(171),mass4set(:,3),  & 
G1H2(1313),G1H2(1314),G1H2(1315),G1H2(1316),G1H2(1317),2)
  call HG1shiftOLR(G1H2(1314),12,2)
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(64))
  call Hotf_5pt_reduction(G2H2(597),RedSet_5(40),mass5set(:,5),  & 
G1H2(38),G1H2(1318),G1H2(1319),G1H2(1320),G1H2(1321),G1H2(1322),2)
  call HG1shiftOLR(G1H2(1318),16,2)
  call Hotf_4pt_reduction(G2H2(600),RedSet_4(146),mass4set(:,2),  & 
G1H2(1323),G1H2(1324),G1H2(1325),G1H2(1326),G1H2(1327),2)
  call HG1shiftOLR(G1H2(1324),20,2)
  call Hloop_QV_A(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(33),n2h1(65))
  call Hotf_5pt_reduction(G2H2(605),RedSet_5(40),mass5set(:,5),  & 
G1H2(122),G1H2(1328),G1H2(1329),G1H2(1330),G1H2(1331),G1H2(1332),2)
  call HG1shiftOLR(G1H2(1328),16,2)
  call Hotf_4pt_reduction(G2H2(608),RedSet_4(146),mass4set(:,2),  & 
G1H2(1333),G1H2(1334),G1H2(1335),G1H2(1336),G1H2(1337),2)
  call HG1shiftOLR(G1H2(1334),20,2)
  call Hloop_AV_Q(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(35),n2h1(66))
  call Hotf_5pt_reduction(G2H2(613),RedSet_5(40),mass5set(:,6),  & 
G1H2(91),G1H2(1338),G1H2(1339),G1H2(1340),G1H2(1341),G1H2(1342),2)
  call HG1shiftOLR(G1H2(1338),16,2)
  call Hotf_4pt_reduction(G2H2(616),RedSet_4(146),mass4set(:,3),  & 
G1H2(1343),G1H2(1344),G1H2(1345),G1H2(1346),G1H2(1347),2)
  call HG1shiftOLR(G1H2(1344),20,2)
  call Hloop_QV_A(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(67))
  call Hotf_5pt_reduction(G2H2(621),RedSet_5(40),mass5set(:,6),  & 
G1H2(110),G1H2(1348),G1H2(1349),G1H2(1350),G1H2(1351),G1H2(1352),2)
  call HG1shiftOLR(G1H2(1348),16,2)
  call Hotf_4pt_reduction(G2H2(624),RedSet_4(146),mass4set(:,3),  & 
G1H2(1353),G1H2(1354),G1H2(1355),G1H2(1356),G1H2(1357),2)
  call HG1shiftOLR(G1H2(1354),20,2)
  call Hloop_AV_Q(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(68))
  call Hotf_5pt_reduction(G2H2(629),RedSet_5(43),mass5set(:,5),  & 
G1H2(20),G1H2(1358),G1H2(1359),G1H2(1360),G1H2(1361),G1H2(1362),2)
  call HG1shiftOLR(G1H2(1358),4,2)
  call Hotf_4pt_reduction(G2H2(632),RedSet_4(171),mass4set(:,2),  & 
G1H2(1363),G1H2(1364),G1H2(1365),G1H2(1366),G1H2(1367),2)
  call HG1shiftOLR(G1H2(1364),12,2)
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(41),n2h1(69))
  call Hotf_5pt_reduction(G2H2(637),RedSet_5(43),mass5set(:,5),  & 
G1H2(1),G1H2(1368),G1H2(1369),G1H2(1370),G1H2(1371),G1H2(1372),2)
  call HG1shiftOLR(G1H2(1368),4,2)
  call Hotf_4pt_reduction(G2H2(640),RedSet_4(171),mass4set(:,2),  & 
G1H2(1373),G1H2(1374),G1H2(1375),G1H2(1376),G1H2(1377),2)
  call HG1shiftOLR(G1H2(1374),12,2)
  call Hloop_AV_Q(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(43),n2h1(70))
  call Hotf_5pt_reduction(G2H2(645),RedSet_5(43),mass5set(:,6),  & 
G1H2(146),G1H2(1378),G1H2(1379),G1H2(1380),G1H2(1381),G1H2(1382),2)
  call HG1shiftOLR(G1H2(1378),4,2)
  call Hotf_4pt_reduction(G2H2(648),RedSet_4(171),mass4set(:,3),  & 
G1H2(1383),G1H2(1384),G1H2(1385),G1H2(1386),G1H2(1387),2)
  call HG1shiftOLR(G1H2(1384),12,2)
  call Hloop_QV_A(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(71))
  call Hotf_5pt_reduction(G2H2(653),RedSet_5(43),mass5set(:,6),  & 
G1H2(148),G1H2(1388),G1H2(1389),G1H2(1390),G1H2(1391),G1H2(1392),2)
  call HG1shiftOLR(G1H2(1388),4,2)
  call Hotf_4pt_reduction(G2H2(656),RedSet_4(171),mass4set(:,3),  & 
G1H2(1393),G1H2(1394),G1H2(1395),G1H2(1396),G1H2(1397),2)
  call HG1shiftOLR(G1H2(1394),12,2)
  call Hloop_AV_Q(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(49),n2h1(73))
  call Hotf_5pt_reduction(G2H2(666),RedSet_5(18),mass5set(:,5),  & 
G1H2(150),G1H2(152),G1H2(1398),G1H2(1399),G1H2(1400),G1H2(1401),2)
  call HG1shiftOLR(G1H2(152),16,2)
  call Hotf_4pt_reduction(G2H2(668),RedSet_4(23),mass4set(:,2),  & 
G1H2(1402),G1H2(1403),G1H2(1404),G1H2(1405),G1H2(1406),2)
  call HG1shiftOLR(G1H2(1403),19,2)
  call Hloop_AV_Q(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(50),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(156),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(51),n2h1(75))
  call Hotf_5pt_reduction(G2H2(676),RedSet_5(18),mass5set(:,5),  & 
G1H2(154),G1H2(156),G1H2(1407),G1H2(1408),G1H2(1409),G1H2(1410),2)
  call HG1shiftOLR(G1H2(156),16,2)
  call Hotf_4pt_reduction(G2H2(678),RedSet_4(23),mass4set(:,2),  & 
G1H2(1411),G1H2(1412),G1H2(1413),G1H2(1414),G1H2(1415),2)
  call HG1shiftOLR(G1H2(1412),19,2)
  call Hloop_QV_A(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(52),n2h1(76))
  call Hotf_5pt_reduction(G2H2(681),RedSet_5(18),mass5set(:,6),  & 
G1H2(158),G1H2(1416),G1H2(1417),G1H2(1418),G1H2(1419),G1H2(1420),2)
  call HG1shiftOLR(G1H2(1416),16,2)
  call Hotf_4pt_reduction(G2H2(683),RedSet_4(23),mass4set(:,3),  & 
G1H2(1421),G1H2(1422),G1H2(1423),G1H2(1424),G1H2(1425),2)
  call HG1shiftOLR(G1H2(1422),19,2)
  call Hloop_AV_Q(ntryL,G1H2(160),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(77))
  call Hotf_5pt_reduction(G2H2(686),RedSet_5(18),mass5set(:,6),  & 
G1H2(160),G1H2(1426),G1H2(1427),G1H2(1428),G1H2(1429),G1H2(1430),2)
  call HG1shiftOLR(G1H2(1426),16,2)
  call Hotf_4pt_reduction(G2H2(688),RedSet_4(23),mass4set(:,3),  & 
G1H2(1431),G1H2(1432),G1H2(1433),G1H2(1434),G1H2(1435),2)
  call HG1shiftOLR(G1H2(1432),19,2)
  call Hloop_QV_A(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(78))
  call Hotf_5pt_reduction(G2H2(691),RedSet_5(38),mass5set(:,5),  & 
G1H2(162),G1H2(1436),G1H2(1437),G1H2(1438),G1H2(1439),G1H2(1440),2)
  call HG1shiftOLR(G1H2(1436),16,2)
  call Hotf_4pt_reduction(G2H2(694),RedSet_4(108),mass4set(:,2),  & 
G1H2(1441),G1H2(1442),G1H2(1443),G1H2(1444),G1H2(1445),2)
  call HG1shiftOLR(G1H2(1442),24,2)
  call Hloop_AV_Q(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(55),n2h1(79))
  call Hotf_5pt_reduction(G2H2(699),RedSet_5(38),mass5set(:,5),  & 
G1H2(164),G1H2(1446),G1H2(1447),G1H2(1448),G1H2(1449),G1H2(1450),2)
  call HG1shiftOLR(G1H2(1446),16,2)
  call Hotf_4pt_reduction(G2H2(702),RedSet_4(108),mass4set(:,2),  & 
G1H2(1451),G1H2(1452),G1H2(1453),G1H2(1454),G1H2(1455),2)
  call HG1shiftOLR(G1H2(1452),24,2)
  call Hloop_QV_A(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(56),n2h1(80))
  call Hotf_5pt_reduction(G2H2(707),RedSet_5(38),mass5set(:,6),  & 
G1H2(166),G1H2(1456),G1H2(1457),G1H2(1458),G1H2(1459),G1H2(1460),2)
  call HG1shiftOLR(G1H2(1456),16,2)
  call Hotf_4pt_reduction(G2H2(710),RedSet_4(108),mass4set(:,3),  & 
G1H2(1461),G1H2(1462),G1H2(1463),G1H2(1464),G1H2(1465),2)
  call HG1shiftOLR(G1H2(1462),24,2)
  call Hloop_AV_Q(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(81))
  call Hotf_5pt_reduction(G2H2(715),RedSet_5(38),mass5set(:,6),  & 
G1H2(168),G1H2(1466),G1H2(1467),G1H2(1468),G1H2(1469),G1H2(1470),2)
  call HG1shiftOLR(G1H2(1466),16,2)
  call Hotf_4pt_reduction(G2H2(718),RedSet_4(108),mass4set(:,3),  & 
G1H2(1471),G1H2(1472),G1H2(1473),G1H2(1474),G1H2(1475),2)
  call HG1shiftOLR(G1H2(1472),24,2)
  call Hloop_QV_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(172),ex5(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(59),n2h1(83))
  call Hotf_5pt_reduction(G2H2(728),RedSet_5(17),mass5set(:,5),  & 
G1H2(170),G1H2(172),G1H2(1476),G1H2(1477),G1H2(1478),G1H2(1479),2)
  call HG1shiftOLR(G1H2(172),16,2)
  call Hotf_4pt_reduction(G2H2(730),RedSet_4(13),mass4set(:,2),  & 
G1H2(1480),G1H2(1481),G1H2(1482),G1H2(1483),G1H2(1484),2)
  call HG1shiftOLR(G1H2(1481),19,2)
  call Hloop_QV_A(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(60),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(61),n2h1(85))
  call Hotf_5pt_reduction(G2H2(738),RedSet_5(17),mass5set(:,5),  & 
G1H2(174),G1H2(176),G1H2(1485),G1H2(1486),G1H2(1487),G1H2(1488),2)
  call HG1shiftOLR(G1H2(176),16,2)
  call Hotf_4pt_reduction(G2H2(740),RedSet_4(13),mass4set(:,2),  & 
G1H2(1489),G1H2(1490),G1H2(1491),G1H2(1492),G1H2(1493),2)
  call HG1shiftOLR(G1H2(1490),19,2)
  call Hloop_AV_Q(ntryL,G1H2(178),ex5(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(62),n2h1(86))
  call Hotf_5pt_reduction(G2H2(743),RedSet_5(17),mass5set(:,6),  & 
G1H2(178),G1H2(1494),G1H2(1495),G1H2(1496),G1H2(1497),G1H2(1498),2)
  call HG1shiftOLR(G1H2(1494),16,2)
  call Hotf_4pt_reduction(G2H2(745),RedSet_4(13),mass4set(:,3),  & 
G1H2(1499),G1H2(1500),G1H2(1501),G1H2(1502),G1H2(1503),2)
  call HG1shiftOLR(G1H2(1500),19,2)
  call Hloop_QV_A(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(87))
  call Hotf_5pt_reduction(G2H2(748),RedSet_5(17),mass5set(:,6),  & 
G1H2(180),G1H2(1504),G1H2(1505),G1H2(1506),G1H2(1507),G1H2(1508),2)
  call HG1shiftOLR(G1H2(1504),16,2)
  call Hotf_4pt_reduction(G2H2(750),RedSet_4(13),mass4set(:,3),  & 
G1H2(1509),G1H2(1510),G1H2(1511),G1H2(1512),G1H2(1513),2)
  call HG1shiftOLR(G1H2(1510),19,2)
  call Hloop_AV_Q(ntryL,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(88))
  call Hotf_5pt_reduction(G2H2(753),RedSet_5(41),mass5set(:,5),  & 
G1H2(182),G1H2(1514),G1H2(1515),G1H2(1516),G1H2(1517),G1H2(1518),2)
  call HG1shiftOLR(G1H2(1514),4,2)
  call Hotf_4pt_reduction(G2H2(756),RedSet_4(146),mass4set(:,2),  & 
G1H2(1519),G1H2(1520),G1H2(1521),G1H2(1522),G1H2(1523),2)
  call HG1shiftOLR(G1H2(1520),20,2)
  call Hloop_QV_A(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(65),n2h1(89))
  call Hotf_5pt_reduction(G2H2(761),RedSet_5(41),mass5set(:,5),  & 
G1H2(184),G1H2(1524),G1H2(1525),G1H2(1526),G1H2(1527),G1H2(1528),2)
  call HG1shiftOLR(G1H2(1524),4,2)
  call Hotf_4pt_reduction(G2H2(764),RedSet_4(146),mass4set(:,2),  & 
G1H2(1529),G1H2(1530),G1H2(1531),G1H2(1532),G1H2(1533),2)
  call HG1shiftOLR(G1H2(1530),20,2)
  call Hloop_AV_Q(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(66),n2h1(90))
  call Hotf_5pt_reduction(G2H2(769),RedSet_5(41),mass5set(:,6),  & 
G1H2(186),G1H2(1534),G1H2(1535),G1H2(1536),G1H2(1537),G1H2(1538),2)
  call HG1shiftOLR(G1H2(1534),4,2)
  call Hotf_4pt_reduction(G2H2(772),RedSet_4(146),mass4set(:,3),  & 
G1H2(1539),G1H2(1540),G1H2(1541),G1H2(1542),G1H2(1543),2)
  call HG1shiftOLR(G1H2(1540),20,2)
  call Hloop_QV_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(91))
  call Hotf_5pt_reduction(G2H2(777),RedSet_5(41),mass5set(:,6),  & 
G1H2(188),G1H2(1544),G1H2(1545),G1H2(1546),G1H2(1547),G1H2(1548),2)
  call HG1shiftOLR(G1H2(1544),4,2)
  call Hotf_4pt_reduction(G2H2(780),RedSet_4(146),mass4set(:,3),  & 
G1H2(1549),G1H2(1550),G1H2(1551),G1H2(1552),G1H2(1553),2)
  call HG1shiftOLR(G1H2(1550),20,2)
  call Hloop_AV_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(69),n2h1(93))
  call Hotf_5pt_reduction(G2H2(790),RedSet_5(19),mass5set(:,5),  & 
G1H2(190),G1H2(192),G1H2(1554),G1H2(1555),G1H2(1556),G1H2(1557),2)
  call HG1shiftOLR(G1H2(192),8,2)
  call Hotf_4pt_reduction(G2H2(792),RedSet_4(38),mass4set(:,2),  & 
G1H2(1558),G1H2(1559),G1H2(1560),G1H2(1561),G1H2(1562),2)
  call HG1shiftOLR(G1H2(1559),11,2)
  call Hloop_AV_Q(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(70),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(71),n2h1(95))
  call Hotf_5pt_reduction(G2H2(800),RedSet_5(19),mass5set(:,5),  & 
G1H2(194),G1H2(196),G1H2(1563),G1H2(1564),G1H2(1565),G1H2(1566),2)
  call HG1shiftOLR(G1H2(196),8,2)
  call Hotf_4pt_reduction(G2H2(802),RedSet_4(38),mass4set(:,2),  & 
G1H2(1567),G1H2(1568),G1H2(1569),G1H2(1570),G1H2(1571),2)
  call HG1shiftOLR(G1H2(1568),11,2)
  call Hloop_QV_A(ntryL,G1H2(198),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(72),n2h1(96))
  call Hotf_5pt_reduction(G2H2(805),RedSet_5(19),mass5set(:,6),  & 
G1H2(198),G1H2(1572),G1H2(1573),G1H2(1574),G1H2(1575),G1H2(1576),2)
  call HG1shiftOLR(G1H2(1572),8,2)
  call Hotf_4pt_reduction(G2H2(807),RedSet_4(38),mass4set(:,3),  & 
G1H2(1577),G1H2(1578),G1H2(1579),G1H2(1580),G1H2(1581),2)
  call HG1shiftOLR(G1H2(1578),11,2)
  call Hloop_AV_Q(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(97))
  call Hotf_5pt_reduction(G2H2(810),RedSet_5(19),mass5set(:,6),  & 
G1H2(200),G1H2(1582),G1H2(1583),G1H2(1584),G1H2(1585),G1H2(1586),2)
  call HG1shiftOLR(G1H2(1582),8,2)
  call Hotf_4pt_reduction(G2H2(812),RedSet_4(38),mass4set(:,3),  & 
G1H2(1587),G1H2(1588),G1H2(1589),G1H2(1590),G1H2(1591),2)
  call HG1shiftOLR(G1H2(1588),11,2)
  call Hloop_QV_A(ntryL,G1H2(202),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(98))
  call Hotf_5pt_reduction(G2H2(815),RedSet_5(39),mass5set(:,5),  & 
G1H2(202),G1H2(1592),G1H2(1593),G1H2(1594),G1H2(1595),G1H2(1596),2)
  call HG1shiftOLR(G1H2(1592),8,2)
  call Hotf_4pt_reduction(G2H2(818),RedSet_4(108),mass4set(:,2),  & 
G1H2(1597),G1H2(1598),G1H2(1599),G1H2(1600),G1H2(1601),2)
  call HG1shiftOLR(G1H2(1598),24,2)
  call Hloop_AV_Q(ntryL,G1H2(204),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(75),n2h1(99))
  call Hotf_5pt_reduction(G2H2(823),RedSet_5(39),mass5set(:,5),  & 
G1H2(204),G1H2(1602),G1H2(1603),G1H2(1604),G1H2(1605),G1H2(1606),2)
  call HG1shiftOLR(G1H2(1602),8,2)
  call Hotf_4pt_reduction(G2H2(826),RedSet_4(108),mass4set(:,2),  & 
G1H2(1607),G1H2(1608),G1H2(1609),G1H2(1610),G1H2(1611),2)
  call HG1shiftOLR(G1H2(1608),24,2)
  call Hloop_QV_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(76),n2h1(100))
  call Hotf_5pt_reduction(G2H2(831),RedSet_5(39),mass5set(:,6),  & 
G1H2(206),G1H2(1612),G1H2(1613),G1H2(1614),G1H2(1615),G1H2(1616),2)
  call HG1shiftOLR(G1H2(1612),8,2)
  call Hotf_4pt_reduction(G2H2(834),RedSet_4(108),mass4set(:,3),  & 
G1H2(1617),G1H2(1618),G1H2(1619),G1H2(1620),G1H2(1621),2)
  call HG1shiftOLR(G1H2(1618),24,2)
  call Hloop_AV_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(101))
  call Hotf_5pt_reduction(G2H2(839),RedSet_5(39),mass5set(:,6),  & 
G1H2(208),G1H2(1622),G1H2(1623),G1H2(1624),G1H2(1625),G1H2(1626),2)
  call HG1shiftOLR(G1H2(1622),8,2)
  call Hotf_4pt_reduction(G2H2(842),RedSet_4(108),mass4set(:,3),  & 
G1H2(1627),G1H2(1628),G1H2(1629),G1H2(1630),G1H2(1631),2)
  call HG1shiftOLR(G1H2(1628),24,2)
  call Hloop_QV_A(ntryL,G1H2(210),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(79),n2h1(103))
  call Hotf_5pt_reduction(G2H2(849),RedSet_5(44),mass5set(:,5),  & 
G1H2(210),G1H2(211),G1H2(1632),G1H2(1633),G1H2(1634),G1H2(1635),2)
  call HG1shiftOLR(G1H2(211),16,2)
  call Hotf_4pt_reduction(G2H2(852),RedSet_4(76),mass4set(:,2),  & 
G1H2(1636),G1H2(1637),G1H2(1638),G1H2(1639),G1H2(1640),2)
  call HG1shiftOLR(G1H2(1637),20,2)
  call Hloop_AV_Q(ntryL,G1H2(213),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(80),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(214),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(81),n2h1(105))
  call Hotf_5pt_reduction(G2H2(859),RedSet_5(44),mass5set(:,5),  & 
G1H2(213),G1H2(214),G1H2(1641),G1H2(1642),G1H2(1643),G1H2(1644),2)
  call HG1shiftOLR(G1H2(214),16,2)
  call Hotf_4pt_reduction(G2H2(862),RedSet_4(76),mass4set(:,2),  & 
G1H2(1645),G1H2(1646),G1H2(1647),G1H2(1648),G1H2(1649),2)
  call HG1shiftOLR(G1H2(1646),20,2)
  call Hloop_QV_A(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(82),n2h1(106))
  call Hotf_5pt_reduction(G2H2(867),RedSet_5(44),mass5set(:,6),  & 
G1H2(216),G1H2(1650),G1H2(1651),G1H2(1652),G1H2(1653),G1H2(1654),2)
  call HG1shiftOLR(G1H2(1650),16,2)
  call Hotf_4pt_reduction(G2H2(870),RedSet_4(76),mass4set(:,3),  & 
G1H2(1655),G1H2(1656),G1H2(1657),G1H2(1658),G1H2(1659),2)
  call HG1shiftOLR(G1H2(1656),20,2)
  call Hloop_AV_Q(ntryL,G1H2(218),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(107))
  call Hotf_5pt_reduction(G2H2(875),RedSet_5(44),mass5set(:,6),  & 
G1H2(218),G1H2(1660),G1H2(1661),G1H2(1662),G1H2(1663),G1H2(1664),2)
  call HG1shiftOLR(G1H2(1660),16,2)
  call Hotf_4pt_reduction(G2H2(878),RedSet_4(76),mass4set(:,3),  & 
G1H2(1665),G1H2(1666),G1H2(1667),G1H2(1668),G1H2(1669),2)
  call HG1shiftOLR(G1H2(1666),20,2)
  call Hloop_QV_A(ntryL,G1H2(220),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(85),n2h1(109))
  call Hotf_5pt_reduction(G2H2(885),RedSet_5(45),mass5set(:,5),  & 
G1H2(220),G1H2(221),G1H2(1670),G1H2(1671),G1H2(1672),G1H2(1673),2)
  call HG1shiftOLR(G1H2(221),8,2)
  call Hotf_4pt_reduction(G2H2(888),RedSet_4(89),mass4set(:,2),  & 
G1H2(1674),G1H2(1675),G1H2(1676),G1H2(1677),G1H2(1678),2)
  call HG1shiftOLR(G1H2(1675),24,2)
  call Hloop_QV_A(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(86),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(87),n2h1(111))
  call Hotf_5pt_reduction(G2H2(895),RedSet_5(45),mass5set(:,5),  & 
G1H2(223),G1H2(224),G1H2(1679),G1H2(1680),G1H2(1681),G1H2(1682),2)
  call HG1shiftOLR(G1H2(224),8,2)
  call Hotf_4pt_reduction(G2H2(898),RedSet_4(89),mass4set(:,2),  & 
G1H2(1683),G1H2(1684),G1H2(1685),G1H2(1686),G1H2(1687),2)
  call HG1shiftOLR(G1H2(1684),24,2)
  call Hloop_AV_Q(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(88),n2h1(112))
  call Hotf_5pt_reduction(G2H2(903),RedSet_5(45),mass5set(:,6),  & 
G1H2(226),G1H2(1688),G1H2(1689),G1H2(1690),G1H2(1691),G1H2(1692),2)
  call HG1shiftOLR(G1H2(1688),8,2)
  call Hotf_4pt_reduction(G2H2(906),RedSet_4(89),mass4set(:,3),  & 
G1H2(1693),G1H2(1694),G1H2(1695),G1H2(1696),G1H2(1697),2)
  call HG1shiftOLR(G1H2(1694),24,2)
  call Hloop_QV_A(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(113))
  call Hotf_5pt_reduction(G2H2(911),RedSet_5(45),mass5set(:,6),  & 
G1H2(228),G1H2(1698),G1H2(1699),G1H2(1700),G1H2(1701),G1H2(1702),2)
  call HG1shiftOLR(G1H2(1698),8,2)
  call Hotf_4pt_reduction(G2H2(914),RedSet_4(89),mass4set(:,3),  & 
G1H2(1703),G1H2(1704),G1H2(1705),G1H2(1706),G1H2(1707),2)
  call HG1shiftOLR(G1H2(1704),24,2)
  call Hloop_AV_Q(ntryL,G1H2(230),ex4(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(231),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(91),n2h1(115))
  call Hotf_5pt_reduction(G2H2(921),RedSet_5(46),mass5set(:,5),  & 
G1H2(230),G1H2(231),G1H2(1708),G1H2(1709),G1H2(1710),G1H2(1711),2)
  call HG1shiftOLR(G1H2(231),16,2)
  call Hotf_4pt_reduction(G2H2(924),RedSet_4(89),mass4set(:,2),  & 
G1H2(1712),G1H2(1713),G1H2(1714),G1H2(1715),G1H2(1716),2)
  call HG1shiftOLR(G1H2(1713),24,2)
  call Hloop_QV_A(ntryL,G1H2(233),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(92),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(93),n2h1(117))
  call Hotf_5pt_reduction(G2H2(931),RedSet_5(46),mass5set(:,5),  & 
G1H2(233),G1H2(234),G1H2(1717),G1H2(1718),G1H2(1719),G1H2(1720),2)
  call HG1shiftOLR(G1H2(234),16,2)
  call Hotf_4pt_reduction(G2H2(934),RedSet_4(89),mass4set(:,2),  & 
G1H2(1721),G1H2(1722),G1H2(1723),G1H2(1724),G1H2(1725),2)
  call HG1shiftOLR(G1H2(1722),24,2)
  call Hloop_AV_Q(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(94),n2h1(118))
  call Hotf_5pt_reduction(G2H2(939),RedSet_5(46),mass5set(:,6),  & 
G1H2(236),G1H2(1726),G1H2(1727),G1H2(1728),G1H2(1729),G1H2(1730),2)
  call HG1shiftOLR(G1H2(1726),16,2)
  call Hotf_4pt_reduction(G2H2(942),RedSet_4(89),mass4set(:,3),  & 
G1H2(1731),G1H2(1732),G1H2(1733),G1H2(1734),G1H2(1735),2)
  call HG1shiftOLR(G1H2(1732),24,2)
  call Hloop_QV_A(ntryL,G1H2(238),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(119))
  call Hotf_5pt_reduction(G2H2(947),RedSet_5(46),mass5set(:,6),  & 
G1H2(238),G1H2(1736),G1H2(1737),G1H2(1738),G1H2(1739),G1H2(1740),2)
  call HG1shiftOLR(G1H2(1736),16,2)
  call Hotf_4pt_reduction(G2H2(950),RedSet_4(89),mass4set(:,3),  & 
G1H2(1741),G1H2(1742),G1H2(1743),G1H2(1744),G1H2(1745),2)
  call HG1shiftOLR(G1H2(1742),24,2)
  call Hloop_AV_Q(ntryL,G1H2(240),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(120))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(245),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(267),[G1H2(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(272),[G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(289),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(311),[G1H2(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(316),[G1H2(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(333),[G1H2(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(338),[G1H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(355),[G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(360),[G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(377),[G1H2(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(382),[G1H2(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(399),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(421),[G1H2(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(426),[G1H2(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(437),[G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(454),[G1H2(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(459),[G1H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(476),[G1H2(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(481),[G1H2(475)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(492),[G1H2(491)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(520),[G1H2(513)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(525),[G1H2(519)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(542),[G1H2(535)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(547),[G1H2(541)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(558),[G1H2(557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(575),[G1H2(568)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(580),[G1H2(574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(591),[G1H2(590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(602),[G1H2(601)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1099),[G1H2(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(979),[G1H2(618)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1104),[G1H2(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(984),[G1H2(630)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1109),[G1H2(636)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1114),[G1H2(642)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(989),[G1H2(648)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1119),[G1H2(654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(994),[G1H2(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1124),[G1H2(666)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(999),[G1H2(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1129),[G1H2(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1134),[G1H2(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1004),[G1H2(690)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1139),[G1H2(696)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1009),[G1H2(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1144),[G1H2(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1014),[G1H2(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1149),[G1H2(720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1019),[G1H2(726)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1154),[G1H2(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1159),[G1H2(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1024),[G1H2(744)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1164),[G1H2(750)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1169),[G1H2(756)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1029),[G1H2(762)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1174),[G1H2(768)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1034),[G1H2(774)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1179),[G1H2(780)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1039),[G1H2(786)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1184),[G1H2(792)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1189),[G1H2(798)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1044),[G1H2(804)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1194),[G1H2(810)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1199),[G1H2(816)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1049),[G1H2(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1204),[G1H2(828)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1054),[G1H2(834)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1209),[G1H2(840)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1214),[G1H2(846)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1059),[G1H2(852)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1219),[G1H2(858)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1224),[G1H2(864)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1064),[G1H2(870)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1229),[G1H2(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1234),[G1H2(882)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1069),[G1H2(888)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1239),[G1H2(894)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1244),[G1H2(900)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1074),[G1H2(906)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1249),[G1H2(912)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1254),[G1H2(918)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1079),[G1H2(924)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1259),[G1H2(930)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1264),[G1H2(936)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1084),[G1H2(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1269),[G1H2(948)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1274),[G1H2(954)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1089),[G1H2(960)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1279),[G1H2(966)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1284),[G1H2(972)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1094),[G1H2(978)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(423),[G1H4(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(521),[G1H4(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(652),[G1H4(651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(747),[G1H4(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(828),[G1H4(827)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1293),[G1H2(1292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1303),[G1H2(1302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1313),[G1H2(1312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1323),[G1H2(1322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1333),[G1H2(1332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1343),[G1H2(1342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1353),[G1H2(1352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1363),[G1H2(1362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1373),[G1H2(1372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1383),[G1H2(1382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1393),[G1H2(1392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1402),[G1H2(1401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1411),[G1H2(1410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1421),[G1H2(1420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1431),[G1H2(1430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1441),[G1H2(1440)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1451),[G1H2(1450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1461),[G1H2(1460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1471),[G1H2(1470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1480),[G1H2(1479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1489),[G1H2(1488)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1499),[G1H2(1498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1509),[G1H2(1508)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1519),[G1H2(1518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1529),[G1H2(1528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1539),[G1H2(1538)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1549),[G1H2(1548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1558),[G1H2(1557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1567),[G1H2(1566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1577),[G1H2(1576)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1587),[G1H2(1586)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1597),[G1H2(1596)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1607),[G1H2(1606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1617),[G1H2(1616)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1627),[G1H2(1626)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1636),[G1H2(1635)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1645),[G1H2(1644)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1655),[G1H2(1654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1665),[G1H2(1664)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1674),[G1H2(1673)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1683),[G1H2(1682)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1693),[G1H2(1692)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1703),[G1H2(1702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1712),[G1H2(1711)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1721),[G1H2(1720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1731),[G1H2(1730)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1741),[G1H2(1740)])
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(97),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(98),n2h1(122))
  call Hloop_VA_Q(ntryL,G1H2(39),ex2(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(99),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(100),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(101),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(102),n2h1(126))
  call Hloop_VA_Q(ntryL,G1H2(102),ex2(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(103),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(108),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(104),n2h1(128))
  call Hloop_VA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(105),n2h1(129))
  call Hloop_VA_Q(ntryL,G1H2(126),ex2(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(106),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(107),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(108),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(144),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(109),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(110),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(111),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(112),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(29),ex1(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(113),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(33),ex1(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(114),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(59),ex1(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(115),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(116),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(117),n2h1(141))
  call Hloop_QV_A(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(118),n2h1(142))
  call Hloop_VQ_A(ntryL,G1H2(63),ex1(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(119),n2h1(143))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,nME,G2tensor(120),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H2(83),ex1(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(121),n2h1(145))
  call Hloop_VQ_A(ntryL,G1H2(87),ex1(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(122),n2h1(146))
  call Hloop_VQ_A(ntryL,G1H2(111),ex1(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(123),n2h1(147))
  call Hloop_QV_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(124),n2h1(148))
  call Hloop_QV_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(125),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(119),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(126),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(112),ex1(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(127),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(128),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(130),ex1(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(129),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(131),ex1(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(130),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H2(245),ex1(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(131),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(132),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(143),ex5(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(133),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(250),ex5(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(134),n2h1(158))
  call Hloop_VQ_A(ntryL,G1H2(246),ex1(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,nME,G2tensor(135),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(251),ex5(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(136),n2h1(160))
  call Hloop_VA_Q(ntryL,G1H2(255),ex2(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(137),n2h1(161))
  call Hloop_VA_Q(ntryL,G1H2(256),ex2(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(138),n2h1(162))
  call Hloop_VA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(139),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(261),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(140),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(262),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(141),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(142),n2h1(166))
  call Hloop_VA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,nME,G2tensor(143),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H2(273),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,nME,G2tensor(144),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(277),ex3(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(145),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(278),ex3(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(146),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(289),ex3(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(147),n2h1(171))
  call Hloop_QV_A(ntryL,G1H2(283),ex5(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(148),n2h1(172))
  call Hloop_QV_A(ntryL,G1H2(284),ex5(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(149),n2h1(173))
  call Hloop_QV_A(ntryL,G1H2(294),ex5(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(150),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(290),ex3(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nME,G2tensor(151),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(295),ex5(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),21,nME,G2tensor(152),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H2(299),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(153),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(300),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(154),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H2(311),ex4(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(155),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H2(305),ex5(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(156),n2h1(180))
  call Hloop_AV_Q(ntryL,G1H2(306),ex5(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(157),n2h1(181))
  call Hloop_AV_Q(ntryL,G1H2(316),ex5(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(158),n2h1(182))
  call Hloop_AV_Q(ntryL,G1H2(312),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(159),n2h1(183))
  call Hloop_AV_Q(ntryL,G1H2(317),ex5(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(160),n2h1(184))
  call Hloop_AV_Q(ntryL,G1H2(321),ex5(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(161),n2h1(185))
  call Hloop_AV_Q(ntryL,G1H2(322),ex5(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(162),n2h1(186))
  call Hloop_AV_Q(ntryL,G1H2(333),ex5(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(163),n2h1(187))
  call Hloop_AV_Q(ntryL,G1H2(327),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(164),n2h1(188))
  call Hloop_AV_Q(ntryL,G1H2(328),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(165),n2h1(189))
  call Hloop_AV_Q(ntryL,G1H2(338),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(166),n2h1(190))
  call Hloop_AV_Q(ntryL,G1H2(334),ex5(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(167),n2h1(191))
  call Hloop_AV_Q(ntryL,G1H2(339),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),26,nME,G2tensor(168),n2h1(192))
  call Hloop_QV_A(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(169),n2h1(193))
  call Hloop_QV_A(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(170),n2h1(194))
  call Hloop_QV_A(ntryL,G1H2(355),ex4(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(171),n2h1(195))
  call Hloop_QV_A(ntryL,G1H2(349),ex5(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(172),n2h1(196))
  call Hloop_QV_A(ntryL,G1H2(350),ex5(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(173),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(360),ex5(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(174),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(175),n2h1(199))
  call Hloop_QV_A(ntryL,G1H2(361),ex5(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(176),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(365),ex5(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(177),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(366),ex5(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(178),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(377),ex5(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(179),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(371),ex4(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(180),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(372),ex4(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(181),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(382),ex4(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(182),n2h1(206))
  call Hloop_QV_A(ntryL,G1H2(378),ex5(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(183),n2h1(207))
  call Hloop_QV_A(ntryL,G1H2(383),ex4(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(184),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(387),ex3(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(185),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(388),ex3(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(186),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(399),ex3(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(187),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(393),ex5(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(188),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(394),ex5(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(189),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(404),ex5(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(190),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(400),ex3(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nME,G2tensor(191),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(405),ex5(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),22,nME,G2tensor(192),n2h1(216))
  call Hloop_QV_A(ntryL,G1H2(409),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(193),n2h1(217))
  call Hloop_QV_A(ntryL,G1H2(410),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(194),n2h1(218))
  call Hloop_QV_A(ntryL,G1H2(421),ex4(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(195),n2h1(219))
  call Hloop_QV_A(ntryL,G1H2(415),ex5(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(196),n2h1(220))
  call Hloop_QV_A(ntryL,G1H2(416),ex5(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(197),n2h1(221))
  call Hloop_QV_A(ntryL,G1H2(426),ex5(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(198),n2h1(222))
  call Hloop_QV_A(ntryL,G1H2(422),ex4(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(199),n2h1(223))
  call Hloop_QV_A(ntryL,G1H2(427),ex5(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(200),n2h1(224))
  call Hloop_QV_A(ntryL,G1H2(431),ex3(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(201),n2h1(225))
  call Hloop_QV_A(ntryL,G1H2(432),ex3(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(202),n2h1(226))
  call Hloop_QV_A(ntryL,G1H2(437),ex3(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(203),n2h1(227))
  call Hloop_QV_A(ntryL,G1H2(438),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(204),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(442),ex5(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(205),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(443),ex5(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(206),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(454),ex5(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(207),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(448),ex3(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(208),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(449),ex3(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(209),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(459),ex3(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(210),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(455),ex5(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(211),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(460),ex3(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nME,G2tensor(212),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(464),ex5(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(213),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(465),ex5(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(214),n2h1(238))
  call Hloop_QV_A(ntryL,G1H2(476),ex5(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(215),n2h1(239))
  call Hloop_QV_A(ntryL,G1H2(470),ex4(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(216),n2h1(240))
  call Hloop_QV_A(ntryL,G1H2(471),ex4(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(217),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(481),ex4(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(218),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(477),ex5(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(219),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(482),ex4(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),25,nME,G2tensor(220),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(486),ex3(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(221),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(487),ex3(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(222),n2h1(246))
  call Hloop_QV_A(ntryL,G1H2(492),ex3(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(223),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(493),ex3(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(224),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(497),ex4(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(225),n2h1(249))
  call Hloop_QV_A(ntryL,G1H2(498),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(226),n2h1(250))
  call Hloop_QV_A(ntryL,G1H2(503),ex4(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(227),n2h1(251))
  call Hloop_QV_A(ntryL,G1H2(504),ex4(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(228),n2h1(252))
  call Hloop_AV_Q(ntryL,G1H2(508),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(229),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(509),ex4(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(230),n2h1(254))
  call Hloop_AV_Q(ntryL,G1H2(520),ex4(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(231),n2h1(255))
  call Hloop_AV_Q(ntryL,G1H2(514),ex5(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(232),n2h1(256))
  call Hloop_AV_Q(ntryL,G1H2(515),ex5(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(233),n2h1(257))
  call Hloop_AV_Q(ntryL,G1H2(525),ex5(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(234),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(521),ex4(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(235),n2h1(259))
  call Hloop_AV_Q(ntryL,G1H2(526),ex5(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(236),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H2(530),ex5(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(237),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(531),ex5(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(238),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(542),ex5(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(239),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(536),ex4(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(240),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(537),ex4(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(241),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(547),ex4(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(242),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(543),ex5(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(243),n2h1(267))
  call Hloop_AV_Q(ntryL,G1H2(548),ex4(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(244),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H2(552),ex3(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(245),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(553),ex3(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(246),n2h1(270))
  call Hloop_AV_Q(ntryL,G1H2(558),ex3(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(247),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(559),ex3(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(248),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(563),ex5(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(249),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(564),ex5(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(250),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(575),ex5(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(251),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(569),ex3(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(252),n2h1(276))
  call Hloop_AV_Q(ntryL,G1H2(570),ex3(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(253),n2h1(277))
  call Hloop_AV_Q(ntryL,G1H2(580),ex3(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(254),n2h1(278))
  call Hloop_AV_Q(ntryL,G1H2(576),ex5(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(255),n2h1(279))
  call Hloop_AV_Q(ntryL,G1H2(581),ex3(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),28,nME,G2tensor(256),n2h1(280))
  call Hloop_AV_Q(ntryL,G1H2(585),ex3(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(257),n2h1(281))
  call Hloop_AV_Q(ntryL,G1H2(586),ex3(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(258),n2h1(282))
  call Hloop_AV_Q(ntryL,G1H2(591),ex3(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(259),n2h1(283))
  call Hloop_AV_Q(ntryL,G1H2(592),ex3(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(260),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(596),ex4(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(261),n2h1(285))
  call Hloop_AV_Q(ntryL,G1H2(597),ex4(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(262),n2h1(286))
  call Hloop_AV_Q(ntryL,G1H2(602),ex4(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(263),n2h1(287))
  call Hloop_AV_Q(ntryL,G1H2(603),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(264),n2h1(288))
  call Hloop_AV_Q(ntryL,G1H2(607),ex5(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(265),n2h1(289))
  call Hloop_AV_Q(ntryL,G1H2(608),ex5(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(266),n2h1(290))
  call Hloop_AV_Q(ntryL,G1H2(1099),ex5(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(267),n2h1(291))
  call Hloop_AV_Q(ntryL,G1H2(613),ex5(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(268),n2h1(292))
  call Hloop_AV_Q(ntryL,G1H2(614),ex5(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(269),n2h1(293))
  call Hloop_AV_Q(ntryL,G1H2(979),ex5(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(270),n2h1(294))
  call Hloop_AV_Q(ntryL,G1H2(619),ex5(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(271),n2h1(295))
  call Hloop_AV_Q(ntryL,G1H2(620),ex5(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(272),n2h1(296))
  call Hloop_AV_Q(ntryL,G1H2(1104),ex5(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(273),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(625),ex5(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(274),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H2(626),ex5(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(275),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(984),ex5(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(276),n2h1(300))
  call Hloop_QV_A(ntryL,G1H2(631),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(277),n2h1(301))
  call Hloop_QV_A(ntryL,G1H2(632),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(278),n2h1(302))
  call Hloop_QV_A(ntryL,G1H2(1109),ex4(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(279),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(637),ex4(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(280),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(638),ex4(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(281),n2h1(305))
  call Hloop_QV_A(ntryL,G1H2(1114),ex4(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(282),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(643),ex4(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(283),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(644),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(284),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(989),ex4(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(285),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(649),ex5(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(286),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(650),ex5(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(287),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(1119),ex5(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(288),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(655),ex5(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(289),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(656),ex5(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(290),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(994),ex5(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(291),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(661),ex5(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(292),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(662),ex5(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(293),n2h1(317))
  call Hloop_QV_A(ntryL,G1H2(1124),ex5(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(294),n2h1(318))
  call Hloop_QV_A(ntryL,G1H2(667),ex5(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(295),n2h1(319))
  call Hloop_QV_A(ntryL,G1H2(668),ex5(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(296),n2h1(320))
  call Hloop_QV_A(ntryL,G1H2(999),ex5(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(297),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(673),ex4(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(298),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(674),ex4(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(299),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(1129),ex4(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(300),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(679),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(301),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H2(680),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(302),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(1134),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(303),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(685),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(304),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(686),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(305),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(1004),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(306),n2h1(330))
  call Hloop_QV_A(ntryL,G1H2(691),ex5(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(307),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(692),ex5(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(308),n2h1(332))
  call Hloop_QV_A(ntryL,G1H2(1139),ex5(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(309),n2h1(333))
  call Hloop_QV_A(ntryL,G1H2(697),ex5(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(310),n2h1(334))
  call Hloop_QV_A(ntryL,G1H2(698),ex5(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(311),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(1009),ex5(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(312),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H2(703),ex5(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(313),n2h1(337))
  call Hloop_AV_Q(ntryL,G1H2(704),ex5(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(314),n2h1(338))
  call Hloop_AV_Q(ntryL,G1H2(1144),ex5(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(315),n2h1(339))
  call Hloop_AV_Q(ntryL,G1H2(709),ex5(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(316),n2h1(340))
  call Hloop_AV_Q(ntryL,G1H2(710),ex5(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(317),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(1014),ex5(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(318),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(715),ex4(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(319),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(716),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(320),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(1149),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(321),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(721),ex4(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(322),n2h1(346))
  call Hloop_AV_Q(ntryL,G1H2(722),ex4(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(323),n2h1(347))
  call Hloop_AV_Q(ntryL,G1H2(1019),ex4(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(324),n2h1(348))
  call Hloop_QV_A(ntryL,G1H2(727),ex5(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(325),n2h1(349))
  call Hloop_QV_A(ntryL,G1H2(728),ex5(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(326),n2h1(350))
  call Hloop_QV_A(ntryL,G1H2(1154),ex5(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(327),n2h1(351))
  call Hloop_QV_A(ntryL,G1H2(733),ex5(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(328),n2h1(352))
  call Hloop_QV_A(ntryL,G1H2(734),ex5(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(329),n2h1(353))
  call Hloop_QV_A(ntryL,G1H2(1159),ex5(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(330),n2h1(354))
  call Hloop_QV_A(ntryL,G1H2(739),ex5(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(331),n2h1(355))
  call Hloop_QV_A(ntryL,G1H2(740),ex5(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(332),n2h1(356))
  call Hloop_QV_A(ntryL,G1H2(1024),ex5(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(333),n2h1(357))
  call Hloop_QV_A(ntryL,G1H2(745),ex4(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(334),n2h1(358))
  call Hloop_QV_A(ntryL,G1H2(746),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(335),n2h1(359))
  call Hloop_QV_A(ntryL,G1H2(1164),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(336),n2h1(360))
  call Hloop_QV_A(ntryL,G1H2(751),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(337),n2h1(361))
  call Hloop_QV_A(ntryL,G1H2(752),ex4(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(338),n2h1(362))
  call Hloop_QV_A(ntryL,G1H2(1169),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(339),n2h1(363))
  call Hloop_QV_A(ntryL,G1H2(757),ex4(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(340),n2h1(364))
  call Hloop_QV_A(ntryL,G1H2(758),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(341),n2h1(365))
  call Hloop_QV_A(ntryL,G1H2(1029),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(342),n2h1(366))
  call Hloop_AV_Q(ntryL,G1H2(763),ex5(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(343),n2h1(367))
  call Hloop_AV_Q(ntryL,G1H2(764),ex5(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(344),n2h1(368))
  call Hloop_AV_Q(ntryL,G1H2(1174),ex5(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(345),n2h1(369))
  call Hloop_AV_Q(ntryL,G1H2(769),ex5(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(346),n2h1(370))
  call Hloop_AV_Q(ntryL,G1H2(770),ex5(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(347),n2h1(371))
  call Hloop_AV_Q(ntryL,G1H2(1034),ex5(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(348),n2h1(372))
  call Hloop_QV_A(ntryL,G1H2(775),ex5(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(349),n2h1(373))
  call Hloop_QV_A(ntryL,G1H2(776),ex5(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(350),n2h1(374))
  call Hloop_QV_A(ntryL,G1H2(1179),ex5(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(351),n2h1(375))
  call Hloop_QV_A(ntryL,G1H2(781),ex5(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(352),n2h1(376))
  call Hloop_QV_A(ntryL,G1H2(782),ex5(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(353),n2h1(377))
  call Hloop_QV_A(ntryL,G1H2(1039),ex5(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(354),n2h1(378))
  call Hloop_QV_A(ntryL,G1H2(787),ex5(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(355),n2h1(379))
  call Hloop_QV_A(ntryL,G1H2(788),ex5(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(356),n2h1(380))
  call Hloop_QV_A(ntryL,G1H2(1184),ex5(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(357),n2h1(381))
  call Hloop_QV_A(ntryL,G1H2(793),ex5(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(358),n2h1(382))
  call Hloop_QV_A(ntryL,G1H2(794),ex5(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(359),n2h1(383))
  call Hloop_QV_A(ntryL,G1H2(1189),ex5(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(360),n2h1(384))
  call Hloop_QV_A(ntryL,G1H2(799),ex5(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(361),n2h1(385))
  call Hloop_QV_A(ntryL,G1H2(800),ex5(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nME,G2tensor(362),n2h1(386))
  call Hloop_QV_A(ntryL,G1H2(1044),ex5(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(363),n2h1(387))
  call Hloop_QV_A(ntryL,G1H2(805),ex3(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(364),n2h1(388))
  call Hloop_QV_A(ntryL,G1H2(806),ex3(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(365),n2h1(389))
  call Hloop_QV_A(ntryL,G1H2(1194),ex3(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(366),n2h1(390))
  call Hloop_QV_A(ntryL,G1H2(811),ex3(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(367),n2h1(391))
  call Hloop_QV_A(ntryL,G1H2(812),ex3(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(368),n2h1(392))
  call Hloop_QV_A(ntryL,G1H2(1199),ex3(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(369),n2h1(393))
  call Hloop_QV_A(ntryL,G1H2(817),ex3(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(370),n2h1(394))
  call Hloop_QV_A(ntryL,G1H2(818),ex3(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(371),n2h1(395))
  call Hloop_QV_A(ntryL,G1H2(1049),ex3(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(372),n2h1(396))
  call Hloop_QV_A(ntryL,G1H2(823),ex4(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(373),n2h1(397))
  call Hloop_QV_A(ntryL,G1H2(824),ex4(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(374),n2h1(398))
  call Hloop_QV_A(ntryL,G1H2(1204),ex4(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(375),n2h1(399))
  call Hloop_QV_A(ntryL,G1H2(829),ex4(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(376),n2h1(400))
  call Hloop_QV_A(ntryL,G1H2(830),ex4(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(377),n2h1(401))
  call Hloop_QV_A(ntryL,G1H2(1054),ex4(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(378),n2h1(402))
  call Hloop_QV_A(ntryL,G1H2(835),ex4(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(379),n2h1(403))
  call Hloop_QV_A(ntryL,G1H2(836),ex4(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(380),n2h1(404))
  call Hloop_QV_A(ntryL,G1H2(1209),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(381),n2h1(405))
  call Hloop_QV_A(ntryL,G1H2(841),ex4(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(382),n2h1(406))
  call Hloop_QV_A(ntryL,G1H2(842),ex4(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(383),n2h1(407))
  call Hloop_QV_A(ntryL,G1H2(1214),ex4(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(384),n2h1(408))
  call Hloop_QV_A(ntryL,G1H2(847),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(385),n2h1(409))
  call Hloop_QV_A(ntryL,G1H2(848),ex4(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(386),n2h1(410))
  call Hloop_QV_A(ntryL,G1H2(1059),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(387),n2h1(411))
  call Hloop_QV_A(ntryL,G1H2(853),ex3(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(388),n2h1(412))
  call Hloop_QV_A(ntryL,G1H2(854),ex3(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(389),n2h1(413))
  call Hloop_QV_A(ntryL,G1H2(1219),ex3(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(390),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(859),ex3(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(391),n2h1(415))
  call Hloop_QV_A(ntryL,G1H2(860),ex3(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(392),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(1224),ex3(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(393),n2h1(417))
  call Hloop_QV_A(ntryL,G1H2(865),ex3(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(394),n2h1(418))
  call Hloop_QV_A(ntryL,G1H2(866),ex3(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(395),n2h1(419))
  call Hloop_QV_A(ntryL,G1H2(1064),ex3(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(396),n2h1(420))
  call Hloop_AV_Q(ntryL,G1H2(871),ex5(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(397),n2h1(421))
  call Hloop_AV_Q(ntryL,G1H2(872),ex5(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(398),n2h1(422))
  call Hloop_AV_Q(ntryL,G1H2(1229),ex5(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(399),n2h1(423))
  call Hloop_AV_Q(ntryL,G1H2(877),ex5(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(400),n2h1(424))
  call Hloop_AV_Q(ntryL,G1H2(878),ex5(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(401),n2h1(425))
  call Hloop_AV_Q(ntryL,G1H2(1234),ex5(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(402),n2h1(426))
  call Hloop_AV_Q(ntryL,G1H2(883),ex5(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(403),n2h1(427))
  call Hloop_AV_Q(ntryL,G1H2(884),ex5(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(404),n2h1(428))
  call Hloop_AV_Q(ntryL,G1H2(1069),ex5(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(405),n2h1(429))
  call Hloop_AV_Q(ntryL,G1H2(889),ex4(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(406),n2h1(430))
  call Hloop_AV_Q(ntryL,G1H2(890),ex4(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(407),n2h1(431))
  call Hloop_AV_Q(ntryL,G1H2(1239),ex4(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(408),n2h1(432))
  call Hloop_AV_Q(ntryL,G1H2(895),ex4(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(409),n2h1(433))
  call Hloop_AV_Q(ntryL,G1H2(896),ex4(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(410),n2h1(434))
  call Hloop_AV_Q(ntryL,G1H2(1244),ex4(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(411),n2h1(435))
  call Hloop_AV_Q(ntryL,G1H2(901),ex4(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(412),n2h1(436))
  call Hloop_AV_Q(ntryL,G1H2(902),ex4(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(413),n2h1(437))
  call Hloop_AV_Q(ntryL,G1H2(1074),ex4(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(414),n2h1(438))
  call Hloop_AV_Q(ntryL,G1H2(907),ex5(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(415),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H2(908),ex5(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(416),n2h1(440))
  call Hloop_AV_Q(ntryL,G1H2(1249),ex5(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(417),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H2(913),ex5(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(418),n2h1(442))
  call Hloop_AV_Q(ntryL,G1H2(914),ex5(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(419),n2h1(443))
  call Hloop_AV_Q(ntryL,G1H2(1254),ex5(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(420),n2h1(444))
  call Hloop_AV_Q(ntryL,G1H2(919),ex5(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(421),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H2(920),ex5(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nME,G2tensor(422),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(1079),ex5(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(423),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H2(925),ex3(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(424),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H2(926),ex3(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(425),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H2(1259),ex3(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(426),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H2(931),ex3(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(427),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H2(932),ex3(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(428),n2h1(452))
  call Hloop_AV_Q(ntryL,G1H2(1264),ex3(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(429),n2h1(453))
  call Hloop_AV_Q(ntryL,G1H2(937),ex3(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(430),n2h1(454))
  call Hloop_AV_Q(ntryL,G1H2(938),ex3(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(431),n2h1(455))
  call Hloop_AV_Q(ntryL,G1H2(1084),ex3(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(432),n2h1(456))
  call Hloop_AV_Q(ntryL,G1H2(943),ex4(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(433),n2h1(457))
  call Hloop_AV_Q(ntryL,G1H2(944),ex4(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(434),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H2(1269),ex4(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(435),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(949),ex4(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(436),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H2(950),ex4(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(437),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H2(1274),ex4(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(438),n2h1(462))
  call Hloop_AV_Q(ntryL,G1H2(955),ex4(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(439),n2h1(463))
  call Hloop_AV_Q(ntryL,G1H2(956),ex4(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(440),n2h1(464))
  call Hloop_AV_Q(ntryL,G1H2(1089),ex4(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(441),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H2(961),ex3(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(442),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H2(962),ex3(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(443),n2h1(467))
  call Hloop_AV_Q(ntryL,G1H2(1279),ex3(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(444),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H2(967),ex3(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(445),n2h1(469))
  call Hloop_AV_Q(ntryL,G1H2(968),ex3(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(446),n2h1(470))
  call Hloop_AV_Q(ntryL,G1H2(1284),ex3(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(447),n2h1(471))
  call Hloop_AV_Q(ntryL,G1H2(973),ex3(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(448),n2h1(472))
  call Hloop_AV_Q(ntryL,G1H2(974),ex3(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(449),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H2(1094),ex3(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(450),n2h1(474))
  call Hloop_VQ_A(ntryL,G1H4(25),wf4(:,11),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,979))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(451),n2h1(475))
  call Hloop_VQ_A(ntryL,G1H4(26),wf4(:,11),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,980))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(452),n2h1(476))
  call Hloop_VQ_A(ntryL,G1H4(169),wf4(:,11),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,981))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(453),n2h1(477))
  call Hloop_VQ_A(ntryL,G1H4(170),wf4(:,11),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,982))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,nME,G2tensor(454),n2h1(478))
  call Hloop_VA_Q(ntryL,G1H4(75),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,983))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(455),n2h1(479))
  call Hloop_VA_Q(ntryL,G1H4(374),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,984))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(456),n2h1(480))
  call Hloop_VA_Q(ntryL,G1H4(423),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,985))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(457),n2h1(481))
  call Hloop_VA_Q(ntryL,G1H4(437),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,986))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,nME,G2tensor(458),n2h1(482))
  call Hloop_VQ_A(ntryL,G1H4(476),wf4(:,14),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,987))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(459),n2h1(483))
  call Hloop_VQ_A(ntryL,G1H4(477),wf4(:,14),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,988))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(460),n2h1(484))
  call Hloop_VQ_A(ntryL,G1H4(521),wf4(:,14),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,989))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(461),n2h1(485))
  call Hloop_VQ_A(ntryL,G1H4(522),wf4(:,14),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,990))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(462),n2h1(486))
  call Hloop_VQ_A(ntryL,G1H4(552),wf4(:,14),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,991))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(463),n2h1(487))
  call Hloop_VQ_A(ntryL,G1H4(566),wf4(:,14),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,992))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(464),n2h1(488))
  call Hloop_VQ_A(ntryL,G1H4(652),wf4(:,14),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,993))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nME,G2tensor(465),n2h1(489))
  call Hloop_VQ_A(ntryL,G1H4(667),wf4(:,14),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,994))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nME,G2tensor(466),n2h1(490))
  call Hloop_VA_Q(ntryL,G1H4(699),wf4(:,6),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,995))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(467),n2h1(491))
  call Hloop_VA_Q(ntryL,G1H4(700),wf4(:,6),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,996))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(468),n2h1(492))
  call Hloop_VA_Q(ntryL,G1H4(747),wf4(:,6),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,997))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(469),n2h1(493))
  call Hloop_VA_Q(ntryL,G1H4(748),wf4(:,6),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,998))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(470),n2h1(494))
  call Hloop_VA_Q(ntryL,G1H4(780),wf4(:,6),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,999))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(471),n2h1(495))
  call Hloop_VA_Q(ntryL,G1H4(795),wf4(:,6),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,1000))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(472),n2h1(496))
  call Hloop_VA_Q(ntryL,G1H4(828),wf4(:,6),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,1001))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nME,G2tensor(473),n2h1(497))
  call Hloop_VA_Q(ntryL,G1H4(843),wf4(:,6),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,1002))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nME,G2tensor(474),n2h1(498))
  call Hloop_AV_Q(ntryL,G1H2(980),ex5(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(475),n2h1(499))
  call Hloop_AV_Q(ntryL,G1H2(985),ex5(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(476),n2h1(500))
  call Hloop_QV_A(ntryL,G1H2(990),ex4(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(477),n2h1(501))
  call Hloop_QV_A(ntryL,G1H2(995),ex5(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(478),n2h1(502))
  call Hloop_QV_A(ntryL,G1H2(1000),ex5(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(479),n2h1(503))
  call Hloop_AV_Q(ntryL,G1H2(1005),ex4(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(480),n2h1(504))
  call Hloop_QV_A(ntryL,G1H2(1010),ex5(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(481),n2h1(505))
  call Hloop_AV_Q(ntryL,G1H2(1015),ex5(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(482),n2h1(506))
  call Hloop_AV_Q(ntryL,G1H2(1020),ex4(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(483),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(1025),ex5(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(484),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(1030),ex4(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(485),n2h1(509))
  call Hloop_AV_Q(ntryL,G1H2(1035),ex5(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(486),n2h1(510))
  call Hloop_QV_A(ntryL,G1H2(1040),ex5(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(487),n2h1(511))
  call Hloop_QV_A(ntryL,G1H2(1045),ex5(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(488),n2h1(512))
  call Hloop_QV_A(ntryL,G1H2(1050),ex3(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(489),n2h1(513))
  call Hloop_QV_A(ntryL,G1H2(1055),ex4(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(490),n2h1(514))
  call Hloop_QV_A(ntryL,G1H2(1060),ex4(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(491),n2h1(515))
  call Hloop_QV_A(ntryL,G1H2(1065),ex3(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(492),n2h1(516))
  call Hloop_AV_Q(ntryL,G1H2(1070),ex5(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(493),n2h1(517))
  call Hloop_AV_Q(ntryL,G1H2(1075),ex4(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(494),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H2(1080),ex5(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(495),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(1085),ex3(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(496),n2h1(520))
  call Hloop_AV_Q(ntryL,G1H2(1090),ex4(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(497),n2h1(521))
  call Hloop_AV_Q(ntryL,G1H2(1095),ex3(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(498),n2h1(522))
  call Hloop_AV_Q(ntryL,G1H2(1100),ex5(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(499),n2h1(523))
  call Hloop_AV_Q(ntryL,G1H2(1105),ex5(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),18,nME,G2tensor(500),n2h1(524))
  call Hloop_QV_A(ntryL,G1H2(1110),ex4(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(501),n2h1(525))
  call Hloop_QV_A(ntryL,G1H2(1115),ex4(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(502),n2h1(526))
  call Hloop_QV_A(ntryL,G1H2(1120),ex5(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(503),n2h1(527))
  call Hloop_QV_A(ntryL,G1H2(1125),ex5(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nME,G2tensor(504),n2h1(528))
  call Hloop_AV_Q(ntryL,G1H2(1130),ex4(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(505),n2h1(529))
  call Hloop_AV_Q(ntryL,G1H2(1135),ex4(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(506),n2h1(530))
  call Hloop_QV_A(ntryL,G1H2(1140),ex5(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(507),n2h1(531))
  call Hloop_AV_Q(ntryL,G1H2(1145),ex5(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(508),n2h1(532))
  call Hloop_AV_Q(ntryL,G1H2(1150),ex4(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(509),n2h1(533))
  call Hloop_QV_A(ntryL,G1H2(1155),ex5(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(510),n2h1(534))
  call Hloop_QV_A(ntryL,G1H2(1160),ex5(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(511),n2h1(535))
  call Hloop_QV_A(ntryL,G1H2(1165),ex4(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(512),n2h1(536))
  call Hloop_QV_A(ntryL,G1H2(1170),ex4(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(513),n2h1(537))
  call Hloop_AV_Q(ntryL,G1H2(1175),ex5(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(514),n2h1(538))
  call Hloop_QV_A(ntryL,G1H2(1180),ex5(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(515),n2h1(539))
  call Hloop_QV_A(ntryL,G1H2(1185),ex5(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(516),n2h1(540))
  call Hloop_QV_A(ntryL,G1H2(1190),ex5(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(517),n2h1(541))
  call Hloop_QV_A(ntryL,G1H2(1195),ex3(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(518),n2h1(542))
  call Hloop_QV_A(ntryL,G1H2(1200),ex3(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nME,G2tensor(519),n2h1(543))
  call Hloop_QV_A(ntryL,G1H2(1205),ex4(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nME,G2tensor(520),n2h1(544))
  call Hloop_QV_A(ntryL,G1H2(1210),ex4(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(521),n2h1(545))
  call Hloop_QV_A(ntryL,G1H2(1215),ex4(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(522),n2h1(546))
  call Hloop_QV_A(ntryL,G1H2(1220),ex3(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(523),n2h1(547))
  call Hloop_QV_A(ntryL,G1H2(1225),ex3(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(524),n2h1(548))
  call Hloop_AV_Q(ntryL,G1H2(1230),ex5(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(525),n2h1(549))
  call Hloop_AV_Q(ntryL,G1H2(1235),ex5(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(526),n2h1(550))
  call Hloop_AV_Q(ntryL,G1H2(1240),ex4(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(527),n2h1(551))
  call Hloop_AV_Q(ntryL,G1H2(1245),ex4(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nME,G2tensor(528),n2h1(552))
  call Hloop_AV_Q(ntryL,G1H2(1250),ex5(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(529),n2h1(553))
  call Hloop_AV_Q(ntryL,G1H2(1255),ex5(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(530),n2h1(554))
  call Hloop_AV_Q(ntryL,G1H2(1260),ex3(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(531),n2h1(555))
  call Hloop_AV_Q(ntryL,G1H2(1265),ex3(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nME,G2tensor(532),n2h1(556))
  call Hloop_AV_Q(ntryL,G1H2(1270),ex4(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(533),n2h1(557))
  call Hloop_AV_Q(ntryL,G1H2(1275),ex4(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(534),n2h1(558))
  call Hloop_AV_Q(ntryL,G1H2(1280),ex3(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(535),n2h1(559))
  call Hloop_AV_Q(ntryL,G1H2(1285),ex3(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(536),n2h1(560))
  call Hloop_AV_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(537),n2h1(561))
  call Hloop_AV_Q(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(538),n2h1(562))
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(539),n2h1(563))
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMM,G2tensor(540),n2h1(564))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(541),n2h1(565))
  call Hloop_QV_A(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(542),n2h1(566))
  call Hloop_QV_A(ntryL,G1H2(1293),ex4(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(543),n2h1(567))
  call Hloop_QV_A(ntryL,G1H2(1294),ex4(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMM,G2tensor(544),n2h1(568))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(545),n2h1(569))
  call Hloop_AV_Q(ntryL,G1H2(1298),ex4(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(546),n2h1(570))
  call Hloop_AV_Q(ntryL,G1H2(1303),ex4(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(547),n2h1(571))
  call Hloop_AV_Q(ntryL,G1H2(1304),ex4(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(548),n2h1(572))
  call Hloop_QV_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(549),n2h1(573))
  call Hloop_QV_A(ntryL,G1H2(1308),ex4(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(550),n2h1(574))
  call Hloop_QV_A(ntryL,G1H2(1313),ex4(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(551),n2h1(575))
  call Hloop_QV_A(ntryL,G1H2(1314),ex4(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(552),n2h1(576))
  call Hloop_QV_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(553),n2h1(577))
  call Hloop_QV_A(ntryL,G1H2(1318),ex5(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(554),n2h1(578))
  call Hloop_QV_A(ntryL,G1H2(1323),ex5(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(555),n2h1(579))
  call Hloop_QV_A(ntryL,G1H2(1324),ex5(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(556),n2h1(580))
  call Hloop_AV_Q(ntryL,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(557),n2h1(581))
  call Hloop_AV_Q(ntryL,G1H2(1328),ex5(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(558),n2h1(582))
  call Hloop_AV_Q(ntryL,G1H2(1333),ex5(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(559),n2h1(583))
  call Hloop_AV_Q(ntryL,G1H2(1334),ex5(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(560),n2h1(584))
  call Hloop_QV_A(ntryL,G1H2(91),ex5(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(561),n2h1(585))
  call Hloop_QV_A(ntryL,G1H2(1338),ex5(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(562),n2h1(586))
  call Hloop_QV_A(ntryL,G1H2(1343),ex5(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(563),n2h1(587))
  call Hloop_QV_A(ntryL,G1H2(1344),ex5(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(564),n2h1(588))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(565),n2h1(589))
  call Hloop_AV_Q(ntryL,G1H2(1348),ex5(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(566),n2h1(590))
  call Hloop_AV_Q(ntryL,G1H2(1353),ex5(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(567),n2h1(591))
  call Hloop_AV_Q(ntryL,G1H2(1354),ex5(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(568),n2h1(592))
  call Hloop_QV_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(569),n2h1(593))
  call Hloop_QV_A(ntryL,G1H2(1358),ex3(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(570),n2h1(594))
  call Hloop_QV_A(ntryL,G1H2(1363),ex3(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(571),n2h1(595))
  call Hloop_QV_A(ntryL,G1H2(1364),ex3(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMM,G2tensor(572),n2h1(596))
  call Hloop_AV_Q(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(573),n2h1(597))
  call Hloop_AV_Q(ntryL,G1H2(1368),ex3(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(574),n2h1(598))
  call Hloop_AV_Q(ntryL,G1H2(1373),ex3(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(575),n2h1(599))
  call Hloop_AV_Q(ntryL,G1H2(1374),ex3(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMM,G2tensor(576),n2h1(600))
  call Hloop_QV_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(577),n2h1(601))
  call Hloop_QV_A(ntryL,G1H2(1378),ex3(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(578),n2h1(602))
  call Hloop_QV_A(ntryL,G1H2(1383),ex3(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(579),n2h1(603))
  call Hloop_QV_A(ntryL,G1H2(1384),ex3(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(580),n2h1(604))
  call Hloop_AV_Q(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(581),n2h1(605))
  call Hloop_AV_Q(ntryL,G1H2(1388),ex3(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(582),n2h1(606))
  call Hloop_AV_Q(ntryL,G1H2(1393),ex3(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(583),n2h1(607))
  call Hloop_AV_Q(ntryL,G1H2(1394),ex3(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(584),n2h1(608))
  call Hloop_AV_Q(ntryL,G1H2(150),ex5(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(585),n2h1(609))
  call Hloop_AV_Q(ntryL,G1H2(152),ex5(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(586),n2h1(610))
  call Hloop_AV_Q(ntryL,G1H2(1402),ex5(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(587),n2h1(611))
  call Hloop_AV_Q(ntryL,G1H2(1403),ex5(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nMM,G2tensor(588),n2h1(612))
  call Hloop_QV_A(ntryL,G1H2(154),ex5(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(589),n2h1(613))
  call Hloop_QV_A(ntryL,G1H2(156),ex5(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(590),n2h1(614))
  call Hloop_QV_A(ntryL,G1H2(1411),ex5(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(591),n2h1(615))
  call Hloop_QV_A(ntryL,G1H2(1412),ex5(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nMM,G2tensor(592),n2h1(616))
  call Hloop_AV_Q(ntryL,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(593),n2h1(617))
  call Hloop_AV_Q(ntryL,G1H2(1416),ex5(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(594),n2h1(618))
  call Hloop_AV_Q(ntryL,G1H2(1421),ex5(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(595),n2h1(619))
  call Hloop_AV_Q(ntryL,G1H2(1422),ex5(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(596),n2h1(620))
  call Hloop_QV_A(ntryL,G1H2(160),ex5(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(597),n2h1(621))
  call Hloop_QV_A(ntryL,G1H2(1426),ex5(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(598),n2h1(622))
  call Hloop_QV_A(ntryL,G1H2(1431),ex5(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(599),n2h1(623))
  call Hloop_QV_A(ntryL,G1H2(1432),ex5(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(600),n2h1(624))
  call Hloop_AV_Q(ntryL,G1H2(162),ex5(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(601),n2h1(625))
  call Hloop_AV_Q(ntryL,G1H2(1436),ex5(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(602),n2h1(626))
  call Hloop_AV_Q(ntryL,G1H2(1441),ex5(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(603),n2h1(627))
  call Hloop_AV_Q(ntryL,G1H2(1442),ex5(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(604),n2h1(628))
  call Hloop_QV_A(ntryL,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(605),n2h1(629))
  call Hloop_QV_A(ntryL,G1H2(1446),ex5(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(606),n2h1(630))
  call Hloop_QV_A(ntryL,G1H2(1451),ex5(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(607),n2h1(631))
  call Hloop_QV_A(ntryL,G1H2(1452),ex5(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(608),n2h1(632))
  call Hloop_AV_Q(ntryL,G1H2(166),ex5(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(609),n2h1(633))
  call Hloop_AV_Q(ntryL,G1H2(1456),ex5(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(610),n2h1(634))
  call Hloop_AV_Q(ntryL,G1H2(1461),ex5(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(611),n2h1(635))
  call Hloop_AV_Q(ntryL,G1H2(1462),ex5(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(612),n2h1(636))
  call Hloop_QV_A(ntryL,G1H2(168),ex5(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(613),n2h1(637))
  call Hloop_QV_A(ntryL,G1H2(1466),ex5(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(614),n2h1(638))
  call Hloop_QV_A(ntryL,G1H2(1471),ex5(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(615),n2h1(639))
  call Hloop_QV_A(ntryL,G1H2(1472),ex5(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(616),n2h1(640))
  call Hloop_QV_A(ntryL,G1H2(170),ex5(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(617),n2h1(641))
  call Hloop_QV_A(ntryL,G1H2(172),ex5(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(618),n2h1(642))
  call Hloop_QV_A(ntryL,G1H2(1480),ex5(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(619),n2h1(643))
  call Hloop_QV_A(ntryL,G1H2(1481),ex5(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,nMM,G2tensor(620),n2h1(644))
  call Hloop_AV_Q(ntryL,G1H2(174),ex5(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(621),n2h1(645))
  call Hloop_AV_Q(ntryL,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(622),n2h1(646))
  call Hloop_AV_Q(ntryL,G1H2(1489),ex5(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(623),n2h1(647))
  call Hloop_AV_Q(ntryL,G1H2(1490),ex5(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nMM,G2tensor(624),n2h1(648))
  call Hloop_QV_A(ntryL,G1H2(178),ex5(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(625),n2h1(649))
  call Hloop_QV_A(ntryL,G1H2(1494),ex5(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(626),n2h1(650))
  call Hloop_QV_A(ntryL,G1H2(1499),ex5(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(627),n2h1(651))
  call Hloop_QV_A(ntryL,G1H2(1500),ex5(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(628),n2h1(652))
  call Hloop_AV_Q(ntryL,G1H2(180),ex5(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(629),n2h1(653))
  call Hloop_AV_Q(ntryL,G1H2(1504),ex5(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(630),n2h1(654))
  call Hloop_AV_Q(ntryL,G1H2(1509),ex5(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(631),n2h1(655))
  call Hloop_AV_Q(ntryL,G1H2(1510),ex5(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(632),n2h1(656))
  call Hloop_QV_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(633),n2h1(657))
  call Hloop_QV_A(ntryL,G1H2(1514),ex3(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(634),n2h1(658))
  call Hloop_QV_A(ntryL,G1H2(1519),ex3(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(635),n2h1(659))
  call Hloop_QV_A(ntryL,G1H2(1520),ex3(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(636),n2h1(660))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(637),n2h1(661))
  call Hloop_AV_Q(ntryL,G1H2(1524),ex3(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(638),n2h1(662))
  call Hloop_AV_Q(ntryL,G1H2(1529),ex3(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(639),n2h1(663))
  call Hloop_AV_Q(ntryL,G1H2(1530),ex3(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(640),n2h1(664))
  call Hloop_QV_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(641),n2h1(665))
  call Hloop_QV_A(ntryL,G1H2(1534),ex3(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(642),n2h1(666))
  call Hloop_QV_A(ntryL,G1H2(1539),ex3(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(643),n2h1(667))
  call Hloop_QV_A(ntryL,G1H2(1540),ex3(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(644),n2h1(668))
  call Hloop_AV_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(645),n2h1(669))
  call Hloop_AV_Q(ntryL,G1H2(1544),ex3(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(646),n2h1(670))
  call Hloop_AV_Q(ntryL,G1H2(1549),ex3(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(647),n2h1(671))
  call Hloop_AV_Q(ntryL,G1H2(1550),ex3(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(648),n2h1(672))
  call Hloop_AV_Q(ntryL,G1H2(190),ex4(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(649),n2h1(673))
  call Hloop_AV_Q(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(650),n2h1(674))
  call Hloop_AV_Q(ntryL,G1H2(1558),ex4(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(651),n2h1(675))
  call Hloop_AV_Q(ntryL,G1H2(1559),ex4(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,nMM,G2tensor(652),n2h1(676))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(653),n2h1(677))
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(654),n2h1(678))
  call Hloop_QV_A(ntryL,G1H2(1567),ex4(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(655),n2h1(679))
  call Hloop_QV_A(ntryL,G1H2(1568),ex4(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,nMM,G2tensor(656),n2h1(680))
  call Hloop_AV_Q(ntryL,G1H2(198),ex4(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(657),n2h1(681))
  call Hloop_AV_Q(ntryL,G1H2(1572),ex4(:),G1H1(1),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(658),n2h1(682))
  call Hloop_AV_Q(ntryL,G1H2(1577),ex4(:),G1H1(1),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(659),n2h1(683))
  call Hloop_AV_Q(ntryL,G1H2(1578),ex4(:),G1H1(1),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),11,0,G2tensor(660),n2h1(684))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(661),n2h1(685))
  call Hloop_QV_A(ntryL,G1H2(1582),ex4(:),G1H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(662),n2h1(686))
  call Hloop_QV_A(ntryL,G1H2(1587),ex4(:),G1H1(1),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(663),n2h1(687))
  call Hloop_QV_A(ntryL,G1H2(1588),ex4(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),11,0,G2tensor(664),n2h1(688))
  call Hloop_AV_Q(ntryL,G1H2(202),ex4(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(665),n2h1(689))
  call Hloop_AV_Q(ntryL,G1H2(1592),ex4(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(666),n2h1(690))
  call Hloop_AV_Q(ntryL,G1H2(1597),ex4(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(667),n2h1(691))
  call Hloop_AV_Q(ntryL,G1H2(1598),ex4(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(668),n2h1(692))
  call Hloop_QV_A(ntryL,G1H2(204),ex4(:),G1H1(1),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(669),n2h1(693))
  call Hloop_QV_A(ntryL,G1H2(1602),ex4(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(670),n2h1(694))
  call Hloop_QV_A(ntryL,G1H2(1607),ex4(:),G1H1(1),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(671),n2h1(695))
  call Hloop_QV_A(ntryL,G1H2(1608),ex4(:),G1H1(1),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(672),n2h1(696))
  call Hloop_AV_Q(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(673),n2h1(697))
  call Hloop_AV_Q(ntryL,G1H2(1612),ex4(:),G1H1(1),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(674),n2h1(698))
  call Hloop_AV_Q(ntryL,G1H2(1617),ex4(:),G1H1(1),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(675),n2h1(699))
  call Hloop_AV_Q(ntryL,G1H2(1618),ex4(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(676),n2h1(700))
  call Hloop_QV_A(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(677),n2h1(701))
  call Hloop_QV_A(ntryL,G1H2(1622),ex4(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(678),n2h1(702))
  call Hloop_QV_A(ntryL,G1H2(1627),ex4(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(679),n2h1(703))
  call Hloop_QV_A(ntryL,G1H2(1628),ex4(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(680),n2h1(704))
  call Hloop_AV_Q(ntryL,G1H2(210),ex5(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(681),n2h1(705))
  call Hloop_AV_Q(ntryL,G1H2(211),ex5(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(682),n2h1(706))
  call Hloop_AV_Q(ntryL,G1H2(1636),ex5(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(683),n2h1(707))
  call Hloop_AV_Q(ntryL,G1H2(1637),ex5(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(684),n2h1(708))
  call Hloop_QV_A(ntryL,G1H2(213),ex5(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(685),n2h1(709))
  call Hloop_QV_A(ntryL,G1H2(214),ex5(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(686),n2h1(710))
  call Hloop_QV_A(ntryL,G1H2(1645),ex5(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(687),n2h1(711))
  call Hloop_QV_A(ntryL,G1H2(1646),ex5(:),G1H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nMM,G2tensor(688),n2h1(712))
  call Hloop_AV_Q(ntryL,G1H2(216),ex5(:),G1H1(1),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(689),n2h1(713))
  call Hloop_AV_Q(ntryL,G1H2(1650),ex5(:),G1H1(1),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(690),n2h1(714))
  call Hloop_AV_Q(ntryL,G1H2(1655),ex5(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(691),n2h1(715))
  call Hloop_AV_Q(ntryL,G1H2(1656),ex5(:),G1H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),20,0,G2tensor(692),n2h1(716))
  call Hloop_QV_A(ntryL,G1H2(218),ex5(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(693),n2h1(717))
  call Hloop_QV_A(ntryL,G1H2(1660),ex5(:),G1H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(694),n2h1(718))
  call Hloop_QV_A(ntryL,G1H2(1665),ex5(:),G1H1(1),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(695),n2h1(719))
  call Hloop_QV_A(ntryL,G1H2(1666),ex5(:),G1H1(1),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(696),n2h1(720))
  call Hloop_QV_A(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(697),n2h1(721))
  call Hloop_QV_A(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(698),n2h1(722))
  call Hloop_QV_A(ntryL,G1H2(1674),ex4(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(699),n2h1(723))
  call Hloop_QV_A(ntryL,G1H2(1675),ex4(:),G1H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(700),n2h1(724))
  call Hloop_AV_Q(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(701),n2h1(725))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(702),n2h1(726))
  call Hloop_AV_Q(ntryL,G1H2(1683),ex4(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(703),n2h1(727))
  call Hloop_AV_Q(ntryL,G1H2(1684),ex4(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(704),n2h1(728))
  call Hloop_QV_A(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(705),n2h1(729))
  call Hloop_QV_A(ntryL,G1H2(1688),ex4(:),G1H1(1),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(706),n2h1(730))
  call Hloop_QV_A(ntryL,G1H2(1693),ex4(:),G1H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(707),n2h1(731))
  call Hloop_QV_A(ntryL,G1H2(1694),ex4(:),G1H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(708),n2h1(732))
  call Hloop_AV_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(709),n2h1(733))
  call Hloop_AV_Q(ntryL,G1H2(1698),ex4(:),G1H1(1),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(710),n2h1(734))
  call Hloop_AV_Q(ntryL,G1H2(1703),ex4(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(711),n2h1(735))
  call Hloop_AV_Q(ntryL,G1H2(1704),ex4(:),G1H1(1),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(712),n2h1(736))
  call Hloop_QV_A(ntryL,G1H2(230),ex5(:),G1H1(1),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(713),n2h1(737))
  call Hloop_QV_A(ntryL,G1H2(231),ex5(:),G1H1(1),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(714),n2h1(738))
  call Hloop_QV_A(ntryL,G1H2(1712),ex5(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(715),n2h1(739))
  call Hloop_QV_A(ntryL,G1H2(1713),ex5(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(716),n2h1(740))
  call Hloop_AV_Q(ntryL,G1H2(233),ex5(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(717),n2h1(741))
  call Hloop_AV_Q(ntryL,G1H2(234),ex5(:),G1H1(1),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMM,G2tensor(718),n2h1(742))
  call Hloop_AV_Q(ntryL,G1H2(1721),ex5(:),G1H1(1),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMM,G2tensor(719),n2h1(743))
  call Hloop_AV_Q(ntryL,G1H2(1722),ex5(:),G1H1(1),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMM,G2tensor(720),n2h1(744))
  call Hloop_QV_A(ntryL,G1H2(236),ex5(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(721),n2h1(745))
  call Hloop_QV_A(ntryL,G1H2(1726),ex5(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(722),n2h1(746))
  call Hloop_QV_A(ntryL,G1H2(1731),ex5(:),G1H1(1),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(723),n2h1(747))
  call Hloop_QV_A(ntryL,G1H2(1732),ex5(:),G1H1(1),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(724),n2h1(748))
  call Hloop_AV_Q(ntryL,G1H2(238),ex5(:),G1H1(1),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(725),n2h1(749))
  call Hloop_AV_Q(ntryL,G1H2(1736),ex5(:),G1H1(1),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(726),n2h1(750))
  call Hloop_AV_Q(ntryL,G1H2(1741),ex5(:),G1H1(1),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(727),n2h1(751))
  call Hloop_AV_Q(ntryL,G1H2(1742),ex5(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(728),n2h1(752))
  call ol_merge_tensors(G2tensor(97),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(12),G1tensor(32)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(14),G1tensor(38)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(16),G1tensor(44)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(18),G1tensor(50),G1tensor(3)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(20),G1tensor(56)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(22),G1tensor(62),G1tensor(39)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(24),G1tensor(68)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(26),G1tensor(74)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(28),G1tensor(80)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(30),G1tensor(86),G1tensor(75)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(32),G1tensor(92),G1tensor(21)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(34),G1tensor(98)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(36),G1tensor(104),G1tensor(93)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(38),G1tensor(110)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(40),G1tensor(116),G1tensor(69)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(42),G1tensor(122)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(44),G1tensor(128),G1tensor(45)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(46),G1tensor(134)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(48),G1tensor(140),G1tensor(51)])
  call ol_merge_tensors(G2tensor(265),[G1tensor(10),G1tensor(4)])
  call ol_merge_tensors(G2tensor(268),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(100),G1tensor(24),G1tensor(6)])
  call ol_merge_tensors(G2tensor(271),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(274),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(108),G1tensor(30),G1tensor(12)])
  call ol_merge_tensors(G2tensor(277),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(280),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(283),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(116),G1tensor(36),G1tensor(18)])
  call ol_merge_tensors(G2tensor(286),[G1tensor(28),G1tensor(22)])
  call ol_merge_tensors(G2tensor(289),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(292),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(295),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(298),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(301),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(304),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(307),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(310),G1tensor(71),G1tensor(41)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(313),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(352),[G2tensor(316),G1tensor(77),G1tensor(47)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(319),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(376),[G2tensor(322),G1tensor(95),G1tensor(53)])
  call ol_merge_tensors(G2tensor(164),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(325),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(400),[G2tensor(328),G1tensor(112),G1tensor(58)])
  call ol_merge_tensors(G2tensor(331),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(84),G1tensor(60)])
  call ol_merge_tensors(G2tensor(334),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(409),[G2tensor(337),G1tensor(118),G1tensor(64)])
  call ol_merge_tensors(G2tensor(340),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(180),[G1tensor(102),G1tensor(66)])
  call ol_merge_tensors(G2tensor(343),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(188),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(349),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(355),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(418),[G2tensor(358),G1tensor(124),G1tensor(82)])
  call ol_merge_tensors(G2tensor(361),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(364),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(427),[G2tensor(367),G1tensor(130),G1tensor(88)])
  call ol_merge_tensors(G2tensor(370),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(108),G1tensor(90)])
  call ol_merge_tensors(G2tensor(373),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(216),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(379),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(436),[G2tensor(382),G1tensor(136),G1tensor(100)])
  call ol_merge_tensors(G2tensor(385),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(388),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(391),G1tensor(142),G1tensor(106)])
  call ol_merge_tensors(G2tensor(394),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(397),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(403),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(232),[G1tensor(126),G1tensor(114)])
  call ol_merge_tensors(G2tensor(406),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(412),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(138),G1tensor(120)])
  call ol_merge_tensors(G2tensor(415),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(421),[G1tensor(125)])
  call ol_merge_tensors(G2tensor(424),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(430),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(252),[G1tensor(144),G1tensor(132)])
  call ol_merge_tensors(G2tensor(433),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(439),[G1tensor(137)])
  call ol_merge_tensors(G2tensor(442),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(448),[G1tensor(143)])
  call ol_merge_tensors(G2tensor(541),[G2tensor(537)])
  call ol_merge_tensors(G2tensor(549),[G2tensor(545)])
  call ol_merge_tensors(G2tensor(557),[G2tensor(553)])
  call ol_merge_tensors(G2tensor(565),[G2tensor(561)])
  call ol_merge_tensors(G2tensor(573),[G2tensor(569)])
  call ol_merge_tensors(G2tensor(581),[G2tensor(577)])
  call ol_merge_tensors(G2tensor(589),[G2tensor(585)])
  call ol_merge_tensors(G2tensor(597),[G2tensor(593)])
  call ol_merge_tensors(G2tensor(605),[G2tensor(601)])
  call ol_merge_tensors(G2tensor(613),[G2tensor(609)])
  call ol_merge_tensors(G2tensor(621),[G2tensor(617)])
  call ol_merge_tensors(G2tensor(629),[G2tensor(625)])
  call ol_merge_tensors(G2tensor(637),[G2tensor(633)])
  call ol_merge_tensors(G2tensor(645),[G2tensor(641)])
  call ol_merge_tensors(G2tensor(653),[G2tensor(649)])
  call ol_merge_tensors(G2tensor(661),[G2tensor(657)])
  call ol_merge_tensors(G2tensor(669),[G2tensor(665)])
  call ol_merge_tensors(G2tensor(677),[G2tensor(673)])
  call ol_merge_tensors(G2tensor(685),[G2tensor(681)])
  call ol_merge_tensors(G2tensor(693),[G2tensor(689)])
  call ol_merge_tensors(G2tensor(701),[G2tensor(697)])
  call ol_merge_tensors(G2tensor(709),[G2tensor(705)])
  call ol_merge_tensors(G2tensor(717),[G2tensor(713)])
  call ol_merge_tensors(G2tensor(725),[G2tensor(721)])
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(32),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(33),mass5set(:,1),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),2)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(34),mass5set(:,1),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103))
  call G_TensorShift(G1tensor(79),1)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(35),mass5set(:,1),  & 
G1tensor(109),G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(115),1)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(36),mass5set(:,1),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),1)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(37),mass5set(:,1),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(3),G1tensor(56),G1tensor(62))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(53),mass5set(:,2),  & 
G1tensor(39),G1tensor(68),G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(75))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(54),mass5set(:,2),  & 
G1tensor(92),G1tensor(21),G1tensor(98),G1tensor(104),G1tensor(93),G1tensor(110))
  call G_TensorShift(G1tensor(21),8)
  call Hotf_5pt_reduction_last(G2tensor(161),RedSet_5(55),mass5set(:,2),  & 
G1tensor(116),G1tensor(69),G1tensor(122),G1tensor(128),G1tensor(45),G1tensor(134))
  call G_TensorShift(G1tensor(69),16)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(56),mass5set(:,3),  & 
G1tensor(140),G1tensor(51),G1tensor(10),G1tensor(4),G1tensor(5),G1tensor(24))
  call G_TensorShift(G1tensor(51),8)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(58),mass5set(:,3),  & 
G1tensor(6),G1tensor(9),G1tensor(11),G1tensor(30),G1tensor(12),G1tensor(15))
  call G_TensorShift(G1tensor(9),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(60),mass5set(:,2),  & 
G1tensor(16),G1tensor(17),G1tensor(36),G1tensor(18),G1tensor(28),G1tensor(22))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(61),mass5set(:,2),  & 
G1tensor(23),G1tensor(27),G1tensor(29),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(27),8)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(62),mass5set(:,3),  & 
G1tensor(40),G1tensor(71),G1tensor(41),G1tensor(42),G1tensor(46),G1tensor(77))
  call G_TensorShift(G1tensor(71),4)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(64),mass5set(:,3),  & 
G1tensor(47),G1tensor(48),G1tensor(52),G1tensor(95),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(48),16)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(66),mass5set(:,2),  & 
G1tensor(57),G1tensor(112),G1tensor(58),G1tensor(59),G1tensor(84),G1tensor(60))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(67),mass5set(:,3),  & 
G1tensor(63),G1tensor(118),G1tensor(64),G1tensor(65),G1tensor(102),G1tensor(66))
  call G_TensorShift(G1tensor(118),4)
  call Hotf_5pt_reduction_last(G2tensor(225),RedSet_5(69),mass5set(:,3),  & 
G1tensor(70),G1tensor(72),G1tensor(76),G1tensor(78),G1tensor(81),G1tensor(124))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(71),mass5set(:,3),  & 
G1tensor(82),G1tensor(83),G1tensor(87),G1tensor(130),G1tensor(88),G1tensor(89))
  call G_TensorShift(G1tensor(83),8)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(73),mass5set(:,3),  & 
G1tensor(108),G1tensor(90),G1tensor(94),G1tensor(96),G1tensor(99),G1tensor(136))
  call G_TensorShift(G1tensor(90),16)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(75),mass5set(:,3),  & 
G1tensor(100),G1tensor(101),G1tensor(105),G1tensor(142),G1tensor(106),G1tensor(107))
  call G_TensorShift(G1tensor(101),4)
  call Hotf_5pt_reduction_last(G2tensor(249),RedSet_5(77),mass5set(:,3),  & 
G1tensor(111),G1tensor(113),G1tensor(126),G1tensor(114),G1tensor(117),G1tensor(119))
  call G_TensorShift(G1tensor(113),16)
  call Hotf_5pt_reduction_last(G2tensor(257),RedSet_5(79),mass5set(:,3),  & 
G1tensor(138),G1tensor(120),G1tensor(123),G1tensor(125),G1tensor(129),G1tensor(131))
  call G_TensorShift(G1tensor(120),4)
  call Hotf_5pt_reduction_last(G2tensor(261),RedSet_5(81),mass5set(:,3),  & 
G1tensor(144),G1tensor(132),G1tensor(135),G1tensor(137),G1tensor(141),G1tensor(143))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(83),mass5set(:,2),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(268),RedSet_5(47),mass5set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(17),mass5set(:,4),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(84),mass5set(:,2),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(274),RedSet_5(48),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(132),RedSet_5(18),mass5set(:,4),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(277),RedSet_5(85),mass5set(:,2),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(280),RedSet_5(86),mass5set(:,2),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(283),RedSet_5(49),mass5set(:,2),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(19),mass5set(:,4),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(286),RedSet_5(87),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(289),RedSet_5(50),mass5set(:,2),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(292),RedSet_5(88),mass5set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(295),RedSet_5(51),mass5set(:,2),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(298),RedSet_5(89),mass5set(:,2),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(301),RedSet_5(90),mass5set(:,2),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(304),RedSet_5(52),mass5set(:,2),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(307),RedSet_5(91),mass5set(:,3),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(346),RedSet_5(44),mass5set(:,4),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(20),mass5set(:,2),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(313),RedSet_5(92),mass5set(:,3),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(352),RedSet_5(46),mass5set(:,4),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(21),mass5set(:,2),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(319),RedSet_5(93),mass5set(:,3),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(376),RedSet_5(45),mass5set(:,4),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(164),RedSet_5(22),mass5set(:,2),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(325),RedSet_5(94),mass5set(:,7),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),16)
  call Hotf_5pt_reduction_last(G2tensor(400),RedSet_5(38),mass5set(:,4),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),16)
  call Hotf_5pt_reduction_last(G2tensor(331),RedSet_5(57),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(23),mass5set(:,3),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),16)
  call Hotf_5pt_reduction_last(G2tensor(334),RedSet_5(95),mass5set(:,7),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),8)
  call Hotf_5pt_reduction_last(G2tensor(409),RedSet_5(39),mass5set(:,4),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_5pt_reduction_last(G2tensor(340),RedSet_5(59),mass5set(:,3),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_5pt_reduction_last(G2tensor(180),RedSet_5(24),mass5set(:,3),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_5pt_reduction_last(G2tensor(343),RedSet_5(96),mass5set(:,3),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),16)
  call Hotf_5pt_reduction_last(G2tensor(188),RedSet_5(25),mass5set(:,2),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(349),RedSet_5(97),mass5set(:,3),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),16)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(26),mass5set(:,2),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(355),RedSet_5(98),mass5set(:,7),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(418),RedSet_5(40),mass5set(:,4),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(361),RedSet_5(63),mass5set(:,3),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(364),RedSet_5(99),mass5set(:,7),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_5pt_reduction_last(G2tensor(427),RedSet_5(41),mass5set(:,4),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),4)
  call Hotf_5pt_reduction_last(G2tensor(370),RedSet_5(65),mass5set(:,3),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),4)
  call Hotf_5pt_reduction_last(G2tensor(208),RedSet_5(27),mass5set(:,3),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),4)
  call Hotf_5pt_reduction_last(G2tensor(373),RedSet_5(100),mass5set(:,3),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),8)
  call Hotf_5pt_reduction_last(G2tensor(216),RedSet_5(28),mass5set(:,2),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),8)
  call Hotf_5pt_reduction_last(G2tensor(379),RedSet_5(101),mass5set(:,7),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),8)
  call Hotf_5pt_reduction_last(G2tensor(436),RedSet_5(42),mass5set(:,4),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_5pt_reduction_last(G2tensor(385),RedSet_5(68),mass5set(:,3),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),8)
  call Hotf_5pt_reduction_last(G2tensor(388),RedSet_5(102),mass5set(:,7),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),4)
  call Hotf_5pt_reduction_last(G2tensor(445),RedSet_5(43),mass5set(:,4),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_5pt_reduction_last(G2tensor(394),RedSet_5(70),mass5set(:,3),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),4)
  call Hotf_5pt_reduction_last(G2tensor(397),RedSet_5(103),mass5set(:,7),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),16)
  call Hotf_5pt_reduction_last(G2tensor(403),RedSet_5(72),mass5set(:,3),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),16)
  call Hotf_5pt_reduction_last(G2tensor(232),RedSet_5(29),mass5set(:,3),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),16)
  call Hotf_5pt_reduction_last(G2tensor(406),RedSet_5(104),mass5set(:,7),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(412),RedSet_5(74),mass5set(:,3),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),8)
  call Hotf_5pt_reduction_last(G2tensor(240),RedSet_5(30),mass5set(:,3),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),8)
  call Hotf_5pt_reduction_last(G2tensor(415),RedSet_5(105),mass5set(:,7),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),16)
  call Hotf_5pt_reduction_last(G2tensor(421),RedSet_5(76),mass5set(:,3),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),16)
  call Hotf_5pt_reduction_last(G2tensor(424),RedSet_5(106),mass5set(:,7),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),4)
  call Hotf_5pt_reduction_last(G2tensor(430),RedSet_5(78),mass5set(:,3),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),4)
  call Hotf_5pt_reduction_last(G2tensor(252),RedSet_5(31),mass5set(:,3),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),4)
  call Hotf_5pt_reduction_last(G2tensor(433),RedSet_5(107),mass5set(:,7),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),8)
  call Hotf_5pt_reduction_last(G2tensor(439),RedSet_5(80),mass5set(:,3),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),8)
  call Hotf_5pt_reduction_last(G2tensor(442),RedSet_5(108),mass5set(:,7),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),4)
  call Hotf_5pt_reduction_last(G2tensor(448),RedSet_5(82),mass5set(:,3),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),4)
  call Hotf_5pt_reduction_last(G2tensor(451),RedSet_5(3),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),9)
  call Hotf_5pt_reduction_last(G2tensor(455),RedSet_5(6),mass5set(:,1),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),10)
  call Hotf_5pt_reduction_last(G2tensor(459),RedSet_5(4),mass5set(:,1),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),17)
  call Hotf_5pt_reduction_last(G2tensor(463),RedSet_5(5),mass5set(:,1),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),17)
  call Hotf_5pt_reduction_last(G2tensor(467),RedSet_5(1),mass5set(:,1),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),18)
  call Hotf_5pt_reduction_last(G2tensor(471),RedSet_5(2),mass5set(:,1),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),18)
  call Hotf_5pt_reduction_last(G2tensor(541),RedSet_5(42),mass5set(:,5),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),8)
  call Hotf_5pt_reduction_last(G2tensor(549),RedSet_5(42),mass5set(:,6),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),8)
  call Hotf_5pt_reduction_last(G2tensor(557),RedSet_5(40),mass5set(:,5),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_5pt_reduction_last(G2tensor(565),RedSet_5(40),mass5set(:,6),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),16)
  call Hotf_5pt_reduction_last(G2tensor(573),RedSet_5(43),mass5set(:,5),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),4)
  call Hotf_5pt_reduction_last(G2tensor(581),RedSet_5(43),mass5set(:,6),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),4)
  call Hotf_5pt_reduction_last(G2tensor(589),RedSet_5(18),mass5set(:,5),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),16)
  call Hotf_5pt_reduction_last(G2tensor(597),RedSet_5(18),mass5set(:,6),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_5pt_reduction_last(G2tensor(605),RedSet_5(38),mass5set(:,5),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),16)
  call Hotf_5pt_reduction_last(G2tensor(613),RedSet_5(38),mass5set(:,6),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_5pt_reduction_last(G2tensor(621),RedSet_5(17),mass5set(:,5),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),16)
  call Hotf_5pt_reduction_last(G2tensor(629),RedSet_5(17),mass5set(:,6),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),16)
  call Hotf_5pt_reduction_last(G2tensor(637),RedSet_5(41),mass5set(:,5),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),4)
  call Hotf_5pt_reduction_last(G2tensor(645),RedSet_5(41),mass5set(:,6),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),4)
  call Hotf_5pt_reduction_last(G2tensor(653),RedSet_5(19),mass5set(:,5),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),8)
  call Hotf_5pt_reduction_last(G2tensor(661),RedSet_5(19),mass5set(:,6),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),8)
  call Hotf_5pt_reduction_last(G2tensor(669),RedSet_5(39),mass5set(:,5),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),8)
  call Hotf_5pt_reduction_last(G2tensor(677),RedSet_5(39),mass5set(:,6),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),8)
  call Hotf_5pt_reduction_last(G2tensor(685),RedSet_5(44),mass5set(:,5),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),16)
  call Hotf_5pt_reduction_last(G2tensor(693),RedSet_5(44),mass5set(:,6),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(701),RedSet_5(45),mass5set(:,5),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),8)
  call Hotf_5pt_reduction_last(G2tensor(709),RedSet_5(45),mass5set(:,6),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),8)
  call Hotf_5pt_reduction_last(G2tensor(717),RedSet_5(46),mass5set(:,5),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_5pt_reduction_last(G2tensor(725),RedSet_5(46),mass5set(:,6),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),16)
  call ol_merge_tensors(T1sum(25),[G1tensor(1)])
  call ol_merge_tensors(T1sum(26),[G1tensor(37)])
  call ol_merge_tensors(T1sum(27),[G1tensor(73)])
  call ol_merge_tensors(T1sum(28),[G1tensor(109)])
  call ol_merge_tensors(T1sum(29),[G1tensor(2)])
  call ol_merge_tensors(T1sum(30),[G1tensor(38)])
  call ol_merge_tensors(T1sum(31),[G1tensor(39)])
  call ol_merge_tensors(T1sum(32),[G1tensor(92)])
  call ol_merge_tensors(T1sum(33),[G1tensor(116)])
  call ol_merge_tensors(T1sum(34),[G1tensor(140)])
  call ol_merge_tensors(T1sum(35),[G1tensor(6)])
  call ol_merge_tensors(T1sum(36),[G1tensor(16)])
  call ol_merge_tensors(T1sum(37),[G1tensor(23)])
  call ol_merge_tensors(T1sum(38),[G1tensor(40)])
  call ol_merge_tensors(T1sum(39),[G1tensor(47)])
  call ol_merge_tensors(T1sum(40),[G1tensor(57)])
  call ol_merge_tensors(T1sum(41),[G1tensor(63)])
  call ol_merge_tensors(T1sum(42),[G1tensor(70)])
  call ol_merge_tensors(T1sum(43),[G1tensor(82)])
  call ol_merge_tensors(T1sum(44),[G1tensor(108)])
  call ol_merge_tensors(T1sum(45),[G1tensor(100)])
  call ol_merge_tensors(T1sum(46),[G1tensor(111)])
  call ol_merge_tensors(T1sum(47),[G1tensor(138)])
  call ol_merge_tensors(T1sum(48),[G1tensor(144)])
  call ol_merge_tensors(T1sum(49),[G1tensor(145)])
  call ol_merge_tensors(T1sum(50),[G1tensor(151)])
  call ol_merge_tensors(T1sum(51),[G1tensor(157)])
  call ol_merge_tensors(T1sum(52),[G1tensor(163)])
  call ol_merge_tensors(T1sum(53),[G1tensor(169)])
  call ol_merge_tensors(T1sum(54),[G1tensor(175)])
  call ol_merge_tensors(T1sum(55),[G1tensor(181)])
  call ol_merge_tensors(T1sum(56),[G1tensor(187)])
  call ol_merge_tensors(T1sum(57),[G1tensor(193)])
  call ol_merge_tensors(T1sum(58),[G1tensor(199)])
  call ol_merge_tensors(T1sum(59),[G1tensor(205)])
  call ol_merge_tensors(T1sum(60),[G1tensor(211)])
  call ol_merge_tensors(T1sum(61),[G1tensor(217)])
  call ol_merge_tensors(T1sum(62),[G1tensor(223)])
  call ol_merge_tensors(T1sum(63),[G1tensor(229)])
  call ol_merge_tensors(T1sum(64),[G1tensor(235)])
  call ol_merge_tensors(T1sum(65),[G1tensor(241)])
  call ol_merge_tensors(T1sum(66),[G1tensor(247)])
  call ol_merge_tensors(T1sum(67),[G1tensor(253)])
  call ol_merge_tensors(T1sum(68),[G1tensor(259)])
  call ol_merge_tensors(T1sum(69),[G1tensor(265)])
  call ol_merge_tensors(T1sum(70),[G1tensor(271)])
  call ol_merge_tensors(T1sum(71),[G1tensor(277)])
  call ol_merge_tensors(T1sum(72),[G1tensor(283)])
  call ol_merge_tensors(T1sum(73),[G1tensor(289)])
  call ol_merge_tensors(T1sum(74),[G1tensor(295)])
  call ol_merge_tensors(T1sum(75),[G1tensor(301)])
  call ol_merge_tensors(T1sum(76),[G1tensor(307)])
  call ol_merge_tensors(T1sum(77),[G1tensor(313)])
  call ol_merge_tensors(T1sum(78),[G1tensor(319)])
  call ol_merge_tensors(T1sum(79),[G1tensor(325)])
  call ol_merge_tensors(T1sum(80),[G1tensor(331)])
  call ol_merge_tensors(T1sum(81),[G1tensor(337)])
  call ol_merge_tensors(T1sum(82),[G1tensor(343)])
  call ol_merge_tensors(T1sum(83),[G1tensor(349)])
  call ol_merge_tensors(T1sum(84),[G1tensor(355)])
  call ol_merge_tensors(T1sum(85),[G1tensor(361)])
  call ol_merge_tensors(T1sum(86),[G1tensor(367)])
  call ol_merge_tensors(T1sum(87),[G1tensor(373)])
  call ol_merge_tensors(T1sum(88),[G1tensor(379)])
  call ol_merge_tensors(T1sum(89),[G1tensor(385)])
  call ol_merge_tensors(T1sum(90),[G1tensor(391)])
  call ol_merge_tensors(T1sum(91),[G1tensor(397)])
  call ol_merge_tensors(T1sum(92),[G1tensor(403)])
  call ol_merge_tensors(T1sum(93),[G1tensor(409)])
  call ol_merge_tensors(T1sum(94),[G1tensor(415)])
  call ol_merge_tensors(T1sum(95),[G1tensor(421)])
  call ol_merge_tensors(T1sum(96),[G1tensor(427)])
  call ol_merge_tensors(T1sum(97),[G1tensor(433)])
  call ol_merge_tensors(T1sum(98),[G1tensor(439)])
  call ol_merge_tensors(T1sum(99),[G1tensor(445)])
  call ol_merge_tensors(T1sum(100),[G1tensor(451)])
  call ol_merge_tensors(T1sum(101),[G1tensor(457)])
  call ol_merge_tensors(T1sum(102),[G1tensor(463)])
  call ol_merge_tensors(T1sum(103),[G1tensor(469)])
  call ol_merge_tensors(T1sum(104),[G1tensor(475)])
  call ol_merge_tensors(T1sum(105),[G1tensor(481)])
  call ol_merge_tensors(T1sum(106),[G1tensor(487)])
  call ol_merge_tensors(T1sum(107),[G1tensor(493)])
  call ol_merge_tensors(T1sum(108),[G1tensor(499)])
  call ol_merge_tensors(T1sum(109),[G1tensor(505)])
  call ol_merge_tensors(T1sum(110),[G1tensor(511)])
  call ol_merge_tensors(T1sum(111),[G1tensor(517)])
  call ol_merge_tensors(T1sum(112),[G1tensor(523)])
  call ol_merge_tensors(T1sum(113),[G1tensor(529)])
  call ol_merge_tensors(T1sum(114),[G1tensor(535)])
  call ol_merge_tensors(T1sum(115),[G1tensor(541)])
  call ol_merge_tensors(T1sum(116),[G1tensor(547)])
  call ol_merge_tensors(T1sum(117),[G1tensor(553)])
  call ol_merge_tensors(T1sum(118),[G1tensor(559)])
  call ol_merge_tensors(T1sum(119),[G1tensor(565)])
  call ol_merge_tensors(T1sum(120),[G1tensor(571)])
  call ol_merge_tensors(T1sum(121),[G1tensor(577)])
  call ol_merge_tensors(T1sum(122),[G1tensor(583)])
  call ol_merge_tensors(T1sum(123),[G1tensor(589)])
  call ol_merge_tensors(T1sum(124),[G1tensor(595)])
  call ol_merge_tensors(T1sum(125),[G1tensor(601)])
  call ol_merge_tensors(T1sum(126),[G1tensor(607)])
  call ol_merge_tensors(T1sum(127),[G1tensor(613)])
  call ol_merge_tensors(T1sum(128),[G1tensor(619)])
  call ol_merge_tensors(T1sum(129),[G1tensor(625)])
  call ol_merge_tensors(T1sum(130),[G1tensor(631)])
  call ol_merge_tensors(T1sum(131),[G1tensor(637)])
  call ol_merge_tensors(T1sum(132),[G1tensor(643)])
  call ol_merge_tensors(T1sum(133),[G1tensor(649)])
  call ol_merge_tensors(T1sum(134),[G1tensor(655)])
  call ol_merge_tensors(T1sum(135),[G1tensor(661)])
  call ol_merge_tensors(T1sum(136),[G1tensor(667)])
  call ol_merge_tensors(T1sum(137),[G1tensor(673)])
  call ol_merge_tensors(T1sum(138),[G1tensor(679)])
  call ol_merge_tensors(T1sum(139),[G1tensor(685)])
  call ol_merge_tensors(T1sum(140),[G1tensor(691)])
  call ol_merge_tensors(T1sum(141),[G1tensor(697)])
  call ol_merge_tensors(T1sum(142),[G1tensor(703)])
  call ol_merge_tensors(T1sum(143),[G1tensor(709)])
  call ol_merge_tensors(T1sum(144),[G1tensor(715)])
  call ol_merge_tensors(T1sum(145),[G1tensor(721)])
  call ol_merge_tensors(T1sum(146),[G1tensor(727)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,10,5,16],[nME,0,nME,nME],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,157),heltab2x64(:,:,169))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(186)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,5,10,16],[nME,0,nME,nME],4,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,158),heltab2x64(:,:,170))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(6),n2h32(158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,8,5,18],[nME,nME,0,nME],4,2,wf4(:,3),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,159),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(13),n2h32(159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(189)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,5,18,8],[nME,0,nME,nME],4,2,wf4(:,3),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,160),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(14),n2h32(160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[34,5,8,16],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,173))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(192)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[34,5,16,8],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(2),m3h4x16(:,14),heltab2x64(:,:,174))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,7,16,8],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,161),heltab2x64(:,:,175))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(21),n2h32(161))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,7,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,162),heltab2x64(:,:,176))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(22),n2h32(162))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,7,16,8],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,163),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(29),n2h32(163))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,7,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,164),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(30),n2h32(164))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,7,16,8],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,165),heltab2x64(:,:,179))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(37),n2h32(165))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,7,16,8],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,166),heltab2x64(:,:,180))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(38),n2h32(166))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,7,16,8],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,167),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(167))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,7,16,8],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,168),heltab2x64(:,:,182))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(46),n2h32(168))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,7,8,16],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,169),heltab2x64(:,:,183))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(53),n2h32(169))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,7,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,170),heltab2x64(:,:,184))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(54),n2h32(170))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,7,8,16],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,171),heltab2x64(:,:,185))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(61),n2h32(171))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,7,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,172),heltab2x64(:,:,186))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(62),n2h32(172))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,7,8,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,173),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(69),n2h32(173))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,7,8,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,174),heltab2x64(:,:,188))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(70),n2h32(174))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,7,8,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,175),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(77),n2h32(175))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,7,8,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,176),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(78),n2h32(176))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,8,7,16],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,177),heltab2x64(:,:,191))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(85),n2h32(177))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,8,7,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,178),heltab2x64(:,:,192))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(86),n2h32(178))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,8,7,16],[nME,nME,nME,nME],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,179),heltab2x64(:,:,193))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(93),n2h32(179))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,8,7,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,180),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(94),n2h32(180))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,8,7,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,181),heltab2x64(:,:,195))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(1),n2h32(181))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,8,7,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,182),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(182))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,8,7,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,183),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(183))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(196)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,8,7,16],[0,0,0,0],4,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,184),heltab2x64(:,:,198))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(4),n2h32(184))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,13,2,16],[nME,0,nME,nME],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,185),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(7),n2h32(185))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,2,13,16],[nME,0,nME,nME],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,186),heltab2x64(:,:,200))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(8),n2h32(186))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,8,2,21],[nME,nME,0,nME],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,187),heltab2x64(:,:,201))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(9),n2h32(187))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,2,21,8],[nME,0,nME,nME],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,188),heltab2x64(:,:,202))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(10),n2h32(188))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[37,2,8,16],[0,nME,nME,nME],4,1,wf8(:,56))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,56),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[37,2,16,8],[0,nME,nME,nME],4,1,wf8(:,56))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,56),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,6,9,16],[nME,0,nME,nME],4,2,wf4(:,12),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,189),heltab2x64(:,:,205))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(11),n2h32(189))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(209)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,9,6,16],[nME,0,nME,nME],4,2,wf4(:,11),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,190),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(12),n2h32(190))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,6,17,8],[nME,0,nME,nME],4,2,wf4(:,12),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,191),heltab2x64(:,:,207))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(15),n2h32(191))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,8,6,17],[nME,nME,0,nME],4,2,wf4(:,12),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,192),heltab2x64(:,:,208))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(16),n2h32(192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[33,6,16,8],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(3),m3h4x16(:,15),heltab2x64(:,:,209))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[33,6,8,16],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(4),m3h4x16(:,16),heltab2x64(:,:,210))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,7,16,8],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,193),heltab2x64(:,:,211))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(17),n2h32(193))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,7,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,194),heltab2x64(:,:,212))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(18),n2h32(194))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,7,16,8],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,195),heltab2x64(:,:,213))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(19),n2h32(195))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,7,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,196),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(20),n2h32(196))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,7,16,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,197),heltab2x64(:,:,215))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(197))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,7,16,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,198),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(24),n2h32(198))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,7,16,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,199),heltab2x64(:,:,217))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(25),n2h32(199))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,7,16,8],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,200),heltab2x64(:,:,218))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(26),n2h32(200))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,7,8,16],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,201),heltab2x64(:,:,219))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(27),n2h32(201))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,7,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,202),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(28),n2h32(202))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,7,8,16],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,203),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(31),n2h32(203))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,7,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,204),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(32),n2h32(204))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,7,8,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,205),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(33),n2h32(205))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,7,8,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,206),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(34),n2h32(206))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,7,8,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,207),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(207))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,7,8,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,208),heltab2x64(:,:,226))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(36),n2h32(208))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,8,7,16],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,209),heltab2x64(:,:,227))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(39),n2h32(209))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,8,7,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,210),heltab2x64(:,:,228))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(40),n2h32(210))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,8,7,16],[nME,nME,nME,nME],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,211),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(41),n2h32(211))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,8,7,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,212),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(42),n2h32(212))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,8,7,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,213),heltab2x64(:,:,231))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(43),n2h32(213))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,8,7,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,214),heltab2x64(:,:,232))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(44),n2h32(214))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,8,7,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,215),heltab2x64(:,:,233))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(47),n2h32(215))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(215)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,8,7,16],[0,0,0,0],4,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,216),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(48),n2h32(216))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,14,1,16],[nME,0,nME,nME],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,217),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(49),n2h32(217))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,1,14,16],[nME,0,nME,nME],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,218),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(50),n2h32(218))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,8,1,22],[nME,nME,0,nME],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,219),heltab2x64(:,:,237))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(51),n2h32(219))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,1,22,8],[nME,0,nME,nME],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,220),heltab2x64(:,:,238))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(52),n2h32(220))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[38,1,8,16],[0,nME,nME,nME],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[38,1,16,8],[0,nME,nME,nME],4,1,wf8(:,71))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,71),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,240))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,4,9,18],[nME,nME,0,nME],4,2,wf4(:,11),wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,221),heltab2x64(:,:,241))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(55),n2h32(221))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,4,18,9],[nME,nME,0,nME],4,2,wf4(:,6),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,222),heltab2x64(:,:,242))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(56),n2h32(222))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[34,9,4,16],[0,nME,nME,nME],4,2,wf4(:,8),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,17),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[34,4,16,9],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,18),heltab2x64(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(6),34,nME,G1H16(26),n2h16(115))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,4,16,11],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,223),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(57),n2h32(223))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,4,16,11],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,224),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(58),n2h32(224))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,4,16,11],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,225),heltab2x64(:,:,247))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(59),n2h32(225))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,4,16,11],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,226),heltab2x64(:,:,248))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(60),n2h32(226))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,4,16,11],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,227),heltab2x64(:,:,249))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(227))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,4,16,11],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,228),heltab2x64(:,:,250))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(64),n2h32(228))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,4,16,11],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,229),heltab2x64(:,:,251))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(65),n2h32(229))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,4,16,11],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,230),heltab2x64(:,:,252))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(66),n2h32(230))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,11,4,16],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,231),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(67),n2h32(231))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,11,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,232),heltab2x64(:,:,254))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(68),n2h32(232))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,11,4,16],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,233),heltab2x64(:,:,255))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(71),n2h32(233))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,11,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,234),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(72),n2h32(234))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,11,4,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,235),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(73),n2h32(235))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,11,4,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,236),heltab2x64(:,:,258))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(74),n2h32(236))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,11,4,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,237),heltab2x64(:,:,259))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(75),n2h32(237))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,11,4,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,238),heltab2x64(:,:,260))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(76),n2h32(238))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,4,11,16],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,239),heltab2x64(:,:,261))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(79),n2h32(239))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,4,11,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,240),heltab2x64(:,:,262))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(80),n2h32(240))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,4,11,16],[nME,nME,nME,nME],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,241),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(81),n2h32(241))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,4,11,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,242),heltab2x64(:,:,264))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(82),n2h32(242))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,4,11,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,243),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(83),n2h32(243))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,4,11,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,244),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(84),n2h32(244))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,4,11,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,245),heltab2x64(:,:,267))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(87),n2h32(245))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,4,11,16],[0,0,0,0],4,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,246),heltab2x64(:,:,268))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(88),n2h32(246))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,13,2,16],[nME,0,nME,nME],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,247),heltab2x64(:,:,269))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(89),n2h32(247))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,2,13,16],[nME,0,nME,nME],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,248),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(90),n2h32(248))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,4,2,25],[nME,nME,0,nME],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,249),heltab2x64(:,:,271))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(91),n2h32(249))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,2,25,4],[nME,0,nME,nME],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,250),heltab2x64(:,:,272))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(92),n2h32(250))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[41,2,4,16],[0,nME,nME,nME],4,1,wf8(:,69))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,69),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[41,2,16,4],[0,nME,nME,nME],4,1,wf8(:,69))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,69),G0H8(6),m3h8x8(:,6),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,4,17,10],[nME,nME,0,nME],4,2,wf4(:,14),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,251),heltab2x64(:,:,275))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(95),n2h32(251))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,4,10,17],[nME,nME,0,nME],4,2,wf4(:,4),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,252),heltab2x64(:,:,276))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(96),n2h32(252))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[33,4,16,10],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(7),m3h4x16(:,19),heltab2x64(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(7),33,nME,G1H16(27),n2h16(116))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(248)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[33,10,4,16],[0,nME,nME,nME],4,2,wf4(:,16),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,16),G0H16(8),m3h4x16(:,20),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,4,16,11],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,253),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(97),n2h32(253))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,4,16,11],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,254),heltab2x64(:,:,280))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(98),n2h32(254))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,4,16,11],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,255),heltab2x64(:,:,281))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(99),n2h32(255))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,4,16,11],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,256),heltab2x64(:,:,282))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(100),n2h32(256))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,4,16,11],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,257),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(101),n2h32(257))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,4,16,11],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,258),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(102),n2h32(258))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,4,16,11],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,259),heltab2x64(:,:,285))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(103),n2h32(259))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,4,16,11],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,260),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(104),n2h32(260))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,11,4,16],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,261),heltab2x64(:,:,287))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(105),n2h32(261))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,11,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,262),heltab2x64(:,:,288))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(106),n2h32(262))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,11,4,16],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,263),heltab2x64(:,:,289))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(107),n2h32(263))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,11,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,264),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(108),n2h32(264))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,11,4,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,265),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(265))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,11,4,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,266),heltab2x64(:,:,292))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(110),n2h32(266))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,11,4,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,267),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(111),n2h32(267))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,11,4,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,268),heltab2x64(:,:,294))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(112),n2h32(268))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,4,11,16],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,269),heltab2x64(:,:,295))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(113),n2h32(269))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,4,11,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,270),heltab2x64(:,:,296))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(114),n2h32(270))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,4,11,16],[nME,nME,nME,nME],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,271),heltab2x64(:,:,297))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(115),n2h32(271))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,4,11,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,272),heltab2x64(:,:,298))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(116),n2h32(272))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,4,11,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,273),heltab2x64(:,:,299))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(117),n2h32(273))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,4,11,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,274),heltab2x64(:,:,300))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(118),n2h32(274))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,4,11,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,275),heltab2x64(:,:,301))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(119),n2h32(275))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,4,11,16],[0,0,0,0],4,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,276),heltab2x64(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(120),n2h32(276))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,14,1,16],[nME,0,nME,nME],4,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,277),heltab2x64(:,:,303))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(121),n2h32(277))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,1,14,16],[nME,0,nME,nME],4,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,278),heltab2x64(:,:,304))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(122),n2h32(278))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,4,1,26],[nME,nME,0,nME],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,279),heltab2x64(:,:,305))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(123),n2h32(279))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,1,26,4],[nME,0,nME,nME],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,280),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(124),n2h32(280))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[42,1,4,16],[0,nME,nME,nME],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,58),G0H8(7),m3h8x8(:,7),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[42,1,16,4],[0,nME,nME,nME],4,1,wf8(:,58))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,58),G0H8(8),m3h8x8(:,8),heltab2x64(:,:,308))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[34,8,4,17],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(9),m3h4x16(:,21),heltab2x64(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(9),34,nME,G1H16(28),n2h16(117))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[34,4,8,17],[nME,nME,nME,0],4,2,wf4(:,8),wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,8),G0H16(10),m3h4x16(:,22),heltab2x64(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(10),34,nME,G1H16(3),n2h16(118))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,4,8,19],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,281),heltab2x64(:,:,311))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(125),n2h32(281))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,4,8,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,282),heltab2x64(:,:,312))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(126),n2h32(282))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,4,8,19],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,283),heltab2x64(:,:,313))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(127),n2h32(283))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,4,8,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,284),heltab2x64(:,:,314))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(128),n2h32(284))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,4,8,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,285),heltab2x64(:,:,315))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(129),n2h32(285))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,4,8,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,286),heltab2x64(:,:,316))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(130),n2h32(286))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,4,8,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,287),heltab2x64(:,:,317))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(131),n2h32(287))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,4,8,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,288),heltab2x64(:,:,318))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(132),n2h32(288))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,8,4,19],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,289),heltab2x64(:,:,319))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(133),n2h32(289))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,8,4,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,290),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(134),n2h32(290))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,8,4,19],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,291),heltab2x64(:,:,321))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(135),n2h32(291))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,8,4,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,292),heltab2x64(:,:,322))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(136),n2h32(292))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,8,4,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,293),heltab2x64(:,:,323))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(137),n2h32(293))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,8,4,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,294),heltab2x64(:,:,324))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(138),n2h32(294))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,8,4,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,295),heltab2x64(:,:,325))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(139),n2h32(295))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,8,4,19],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,296),heltab2x64(:,:,326))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(140),n2h32(296))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,4,19,8],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,297),heltab2x64(:,:,327))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(141),n2h32(297))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,4,19,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,298),heltab2x64(:,:,328))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(142),n2h32(298))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,4,19,8],[nME,nME,nME,nME],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,299),heltab2x64(:,:,329))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(143),n2h32(299))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,4,19,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,300),heltab2x64(:,:,330))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(144),n2h32(300))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,4,19,8],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,301),heltab2x64(:,:,331))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(145),n2h32(301))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,4,19,8],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,302),heltab2x64(:,:,332))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(146),n2h32(302))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,4,19,8],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,303),heltab2x64(:,:,333))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(147),n2h32(303))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(265)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,4,19,8],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,304),heltab2x64(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(148),n2h32(304))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,8,2,21],[nME,nME,0,nME],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,305),heltab2x64(:,:,335))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(149),n2h32(305))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,2,21,8],[nME,0,nME,nME],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,306),heltab2x64(:,:,336))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(150),n2h32(306))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,4,2,25],[nME,nME,0,nME],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,307),heltab2x64(:,:,337))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(151),n2h32(307))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,2,25,4],[nME,0,nME,nME],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,308),heltab2x64(:,:,338))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(152),n2h32(308))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[49,2,4,8],[0,nME,nME,nME],4,1,wf8(:,75))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,75),G0H8(9),m3h8x8(:,9),heltab2x64(:,:,339))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[49,2,8,4],[0,nME,nME,nME],4,1,wf8(:,75))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,75),G0H8(10),m3h8x8(:,10),heltab2x64(:,:,340))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[33,4,8,18],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(11),m3h4x16(:,23),heltab2x64(:,:,341))
  call Hloop_Q_A(ntryL,G0H16(11),33,nME,G1H16(30),n2h16(119))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(275)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[33,8,4,18],[nME,nME,nME,0],4,2,wf4(:,16),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,16),G0H16(12),m3h4x16(:,24),heltab2x64(:,:,342))
  call Hloop_Q_A(ntryL,G0H16(12),33,nME,G1H16(31),n2h16(120))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,4,8,19],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,309),heltab2x64(:,:,343))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(153),n2h32(309))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,4,8,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,310),heltab2x64(:,:,344))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(154),n2h32(310))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,4,8,19],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,311),heltab2x64(:,:,345))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(155),n2h32(311))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,4,8,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,312),heltab2x64(:,:,346))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(156),n2h32(312))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,4,8,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,313),heltab2x64(:,:,347))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(157),n2h32(313))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,4,8,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,314),heltab2x64(:,:,348))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(158),n2h32(314))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,4,8,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,315),heltab2x64(:,:,349))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(159),n2h32(315))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,4,8,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,316),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(160),n2h32(316))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,8,4,19],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,317),heltab2x64(:,:,351))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(161),n2h32(317))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,8,4,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,318),heltab2x64(:,:,352))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(162),n2h32(318))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[32,8,4,19],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,319),heltab2x64(:,:,353))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(163),n2h32(319))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,8,4,19],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,320),heltab2x64(:,:,354))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(164),n2h32(320))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,8,4,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,321),heltab2x64(:,:,355))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(165),n2h32(321))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[32,8,4,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,322),heltab2x64(:,:,356))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(166),n2h32(322))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[32,8,4,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,323),heltab2x64(:,:,357))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(167),n2h32(323))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,8,4,19],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,324),heltab2x64(:,:,358))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(168),n2h32(324))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,4,19,8],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,325),heltab2x64(:,:,359))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(169),n2h32(325))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[32,4,19,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,326),heltab2x64(:,:,360))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMM,G1H32(170),n2h32(326))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,4,19,8],[nME,nME,nME,nME],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,327),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(171),n2h32(327))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,4,19,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,328),heltab2x64(:,:,362))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMM,G1H32(172),n2h32(328))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,4,19,8],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,329),heltab2x64(:,:,363))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(173),n2h32(329))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,4,19,8],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,330),heltab2x64(:,:,364))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(174),n2h32(330))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,4,19,8],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,331),heltab2x64(:,:,365))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(175),n2h32(331))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(277)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,4,19,8],[0,0,0,0],4,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,332),heltab2x64(:,:,366))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(176),n2h32(332))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,8,1,22],[nME,nME,0,nME],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,333),heltab2x64(:,:,367))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(177),n2h32(333))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,1,22,8],[nME,0,nME,nME],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,334),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(178),n2h32(334))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,4,1,26],[nME,nME,0,nME],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,335),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(179),n2h32(335))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,1,26,4],[nME,0,nME,nME],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,336),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H32(1),32,nME,G1H32(180),n2h32(336))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[50,1,4,8],[0,nME,nME,nME],4,1,wf8(:,63))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,63),G0H8(11),m3h8x8(:,11),heltab2x64(:,:,371))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[50,1,8,4],[0,nME,nME,nME],4,1,wf8(:,63))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,63),G0H8(12),m3h8x8(:,12),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[35,8,4,16],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(13),m3h8x8(:,13),heltab2x64(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(13),35,nME,G1H8(164),n2h8(307))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[35,8,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(14),m3h8x8(:,14),heltab2x64(:,:,374))
  call Hloop_Q_A(ntryL,G0H8(14),35,nMM,G1H8(166),n2h8(308))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[35,8,4,16],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(15),m3h8x8(:,15),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H8(15),35,nME,G1H8(96),n2h8(309))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[35,8,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(16),m3h8x8(:,16),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H8(16),35,nMM,G1H8(97),n2h8(310))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[35,8,4,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(17),m3h8x8(:,17),heltab2x64(:,:,377))
  call Hloop_Q_A(ntryL,G0H8(17),35,0,G1H8(17),n2h8(311))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[35,8,4,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(18),m3h8x8(:,18),heltab2x64(:,:,378))
  call Hloop_A_Q(ntryL,G0H8(18),35,0,G1H8(18),n2h8(312))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[35,8,4,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(19),m3h8x8(:,19),heltab2x64(:,:,379))
  call Hloop_Q_A(ntryL,G0H8(19),35,0,G1H8(193),n2h8(313))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[35,8,4,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(20),m3h8x8(:,20),heltab2x64(:,:,380))
  call Hloop_A_Q(ntryL,G0H8(20),35,0,G1H8(194),n2h8(314))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[35,4,8,16],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(21),m3h8x8(:,21),heltab2x64(:,:,381))
  call Hloop_A_Q(ntryL,G0H8(21),35,nME,G1H8(37),n2h8(315))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[35,4,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(22),m3h8x8(:,22),heltab2x64(:,:,382))
  call Hloop_A_Q(ntryL,G0H8(22),35,nMM,G1H8(38),n2h8(316))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[35,4,8,16],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(23),m3h8x8(:,23),heltab2x64(:,:,383))
  call Hloop_Q_A(ntryL,G0H8(23),35,nME,G1H8(10),n2h8(317))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[35,4,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(24),m3h8x8(:,24),heltab2x64(:,:,384))
  call Hloop_Q_A(ntryL,G0H8(24),35,nMM,G1H8(21),n2h8(318))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[35,4,8,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(25),m3h8x8(:,25),heltab2x64(:,:,385))
  call Hloop_A_Q(ntryL,G0H8(25),35,0,G1H8(222),n2h8(319))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[35,4,8,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(26),m3h8x8(:,26),heltab2x64(:,:,386))
  call Hloop_Q_A(ntryL,G0H8(26),35,0,G1H8(223),n2h8(320))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[35,4,8,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(27),m3h8x8(:,27),heltab2x64(:,:,387))
  call Hloop_A_Q(ntryL,G0H8(27),35,0,G1H8(69),n2h8(321))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[35,4,8,16],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(28),m3h8x8(:,28),heltab2x64(:,:,388))
  call Hloop_Q_A(ntryL,G0H8(28),35,0,G1H8(70),n2h8(322))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[35,4,16,8],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(29),m3h8x8(:,29),heltab2x64(:,:,389))
  call Hloop_A_Q(ntryL,G0H8(29),35,nME,G1H8(232),n2h8(323))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[35,4,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(30),m3h8x8(:,30),heltab2x64(:,:,390))
  call Hloop_A_Q(ntryL,G0H8(30),35,nMM,G1H8(233),n2h8(324))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[35,4,16,8],[nME,nME,nME,nME],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(31),m3h8x8(:,31),heltab2x64(:,:,391))
  call Hloop_Q_A(ntryL,G0H8(31),35,nME,G1H8(251),n2h8(325))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[35,4,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(32),m3h8x8(:,32),heltab2x64(:,:,392))
  call Hloop_Q_A(ntryL,G0H8(32),35,nMM,G1H8(252),n2h8(326))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[35,4,16,8],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(33),m3h8x8(:,33),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G0H8(33),35,0,G1H8(74),n2h8(327))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[35,4,16,8],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(34),m3h8x8(:,34),heltab2x64(:,:,394))
  call Hloop_Q_A(ntryL,G0H8(34),35,0,G1H8(78),n2h8(328))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[35,4,16,8],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,51),G0H8(35),m3h8x8(:,35),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H8(35),35,0,G1H8(259),n2h8(329))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(288)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[35,4,16,8],[0,0,0,0],4,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,51),G0H8(36),m3h8x8(:,36),heltab2x64(:,:,396))
  call Hloop_Q_A(ntryL,G0H8(36),35,0,G1H8(260),n2h8(330))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[37,2,8,16],[0,nME,nME,nME],4,1,wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,40),G0H8(13),m3h8x8(:,37),heltab2x64(:,:,397))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[37,2,16,8],[0,nME,nME,nME],4,1,wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,40),G0H8(14),m3h8x8(:,38),heltab2x64(:,:,398))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[41,2,4,16],[0,nME,nME,nME],4,1,wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,27),G0H8(15),m3h8x8(:,39),heltab2x64(:,:,399))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[41,2,16,4],[0,nME,nME,nME],4,1,wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,27),G0H8(16),m3h8x8(:,40),heltab2x64(:,:,400))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[49,2,4,8],[0,nME,nME,nME],4,1,wf8(:,77))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,77),G0H8(17),m3h8x8(:,41),heltab2x64(:,:,401))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[49,2,8,4],[0,nME,nME,nME],4,1,wf8(:,77))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,77),G0H8(18),m3h8x8(:,42),heltab2x64(:,:,402))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[35,8,4,16],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(19),m3h8x8(:,43),heltab2x64(:,:,403))
  call Hloop_Q_A(ntryL,G0H8(19),35,nME,G1H8(275),n2h8(331))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[35,8,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(20),m3h8x8(:,44),heltab2x64(:,:,404))
  call Hloop_Q_A(ntryL,G0H8(20),35,nMM,G1H8(276),n2h8(332))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[35,8,4,16],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(21),m3h8x8(:,45),heltab2x64(:,:,405))
  call Hloop_A_Q(ntryL,G0H8(21),35,nME,G1H8(291),n2h8(333))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[35,8,4,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(22),m3h8x8(:,46),heltab2x64(:,:,406))
  call Hloop_A_Q(ntryL,G0H8(22),35,nMM,G1H8(292),n2h8(334))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[35,8,4,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(23),m3h8x8(:,47),heltab2x64(:,:,407))
  call Hloop_Q_A(ntryL,G0H8(23),35,0,G1H8(307),n2h8(335))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[35,8,4,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(24),m3h8x8(:,48),heltab2x64(:,:,408))
  call Hloop_A_Q(ntryL,G0H8(24),35,0,G1H8(308),n2h8(336))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[35,8,4,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(25),m3h8x8(:,49),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G0H8(25),35,0,G1H8(323),n2h8(337))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[35,8,4,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(26),m3h8x8(:,50),heltab2x64(:,:,410))
  call Hloop_A_Q(ntryL,G0H8(26),35,0,G1H8(324),n2h8(338))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[35,4,8,16],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(27),m3h8x8(:,51),heltab2x64(:,:,411))
  call Hloop_A_Q(ntryL,G0H8(27),35,nME,G1H8(339),n2h8(339))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[35,4,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(28),m3h8x8(:,52),heltab2x64(:,:,412))
  call Hloop_A_Q(ntryL,G0H8(28),35,nMM,G1H8(340),n2h8(340))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[35,4,8,16],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(29),m3h8x8(:,53),heltab2x64(:,:,413))
  call Hloop_Q_A(ntryL,G0H8(29),35,nME,G1H8(355),n2h8(341))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[35,4,8,16],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(30),m3h8x8(:,54),heltab2x64(:,:,414))
  call Hloop_Q_A(ntryL,G0H8(30),35,nMM,G1H8(356),n2h8(342))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[35,4,8,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(31),m3h8x8(:,55),heltab2x64(:,:,415))
  call Hloop_A_Q(ntryL,G0H8(31),35,0,G1H8(116),n2h8(343))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[35,4,8,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(32),m3h8x8(:,56),heltab2x64(:,:,416))
  call Hloop_Q_A(ntryL,G0H8(32),35,0,G1H8(118),n2h8(344))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[35,4,8,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(33),m3h8x8(:,57),heltab2x64(:,:,417))
  call Hloop_A_Q(ntryL,G0H8(33),35,0,G1H8(121),n2h8(345))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[35,4,8,16],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(34),m3h8x8(:,58),heltab2x64(:,:,418))
  call Hloop_Q_A(ntryL,G0H8(34),35,0,G1H8(122),n2h8(346))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[35,4,16,8],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(35),m3h8x8(:,59),heltab2x64(:,:,419))
  call Hloop_A_Q(ntryL,G0H8(35),35,nME,G1H8(124),n2h8(347))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[35,4,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(36),m3h8x8(:,60),heltab2x64(:,:,420))
  call Hloop_A_Q(ntryL,G0H8(36),35,nMM,G1H8(125),n2h8(348))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[35,4,16,8],[nME,nME,nME,nME],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(19),m3h8x8(:,61),heltab2x64(:,:,421))
  call Hloop_Q_A(ntryL,G0H8(19),35,nME,G1H8(128),n2h8(349))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[35,4,16,8],[nMM,nMM,nMM,nMM],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(20),m3h8x8(:,62),heltab2x64(:,:,422))
  call Hloop_Q_A(ntryL,G0H8(20),35,nMM,G1H8(130),n2h8(350))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[35,4,16,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(21),m3h8x8(:,63),heltab2x64(:,:,423))
  call Hloop_A_Q(ntryL,G0H8(21),35,0,G1H8(131),n2h8(351))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[35,4,16,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(22),m3h8x8(:,64),heltab2x64(:,:,424))
  call Hloop_Q_A(ntryL,G0H8(22),35,0,G1H8(132),n2h8(352))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[35,4,16,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,52),G0H8(23),m3h8x8(:,65),heltab2x64(:,:,425))
  call Hloop_A_Q(ntryL,G0H8(23),35,0,G1H8(136),n2h8(353))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(298)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[35,4,16,8],[0,0,0,0],4,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,52),G0H8(24),m3h8x8(:,66),heltab2x64(:,:,426))
  call Hloop_Q_A(ntryL,G0H8(24),35,0,G1H8(137),n2h8(354))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[38,1,8,16],[0,nME,nME,nME],4,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,34),G0H8(25),m3h8x8(:,67),heltab2x64(:,:,427))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[38,1,16,8],[0,nME,nME,nME],4,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,34),G0H8(26),m3h8x8(:,68),heltab2x64(:,:,428))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[42,1,4,16],[0,nME,nME,nME],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,14),G0H8(27),m3h8x8(:,69),heltab2x64(:,:,429))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[42,1,16,4],[0,nME,nME,nME],4,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,14),G0H8(28),m3h8x8(:,70),heltab2x64(:,:,430))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[50,1,4,8],[0,nME,nME,nME],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(29),m3h8x8(:,71),heltab2x64(:,:,431))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[50,1,8,4],[0,nME,nME,nME],4,1,wf8(:,65))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,65),G0H8(30),m3h8x8(:,72),heltab2x64(:,:,432))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(355),[G1H8(10),G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(251),G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(275),[G1H8(164),G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(339),[G1H8(37),G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(232),G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(291),[G1H8(96),G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(276),[G1H8(166),G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(292),[G1H8(97),G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(323),[G1H8(307),G1H8(193),G1H8(17),G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(324),[G1H8(308),G1H8(194),G1H8(18),G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(340),[G1H8(38),G1H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(356),[G1H8(21),G1H8(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(116),G1H8(69),G1H8(222),G1H8(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(122),[G1H8(118),G1H8(70),G1H8(223),G1H8(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(125),[G1H8(233),G1H8(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(252),G1H8(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(136),[G1H8(131),G1H8(259),G1H8(74),G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(137),[G1H8(132),G1H8(260),G1H8(78),G1H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(45),[G1H32(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(46),[G1H32(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(77),[G1H32(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(78),[G1H32(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(3),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(4),[G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(25),[G1H32(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(26),[G1H32(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(35),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(36),[G1H32(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(47),[G1H32(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(48),[G1H32(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(65),[G1H32(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(66),[G1H32(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(75),[G1H32(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(76),[G1H32(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(87),[G1H32(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(88),[G1H32(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(103),[G1H32(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(104),[G1H32(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(111),[G1H32(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(112),[G1H32(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(119),[G1H32(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(120),[G1H32(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(27),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(28),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(131),[G1H32(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(132),[G1H32(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(139),[G1H32(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(140),[G1H32(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(147),[G1H32(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(148),[G1H32(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(159),[G1H32(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(160),[G1H32(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(167),[G1H32(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(168),[G1H32(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(175),[G1H32(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(176),[G1H32(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(29),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(30),[G0H8(12)])
  call Hloop_AV_Q(ntryL,G1H8(95),ex3(:),G1H4(875),m3h2x4(:,413),heltab2x8(:,:,557))
  call Hloop_A_Q(ntryL,G1H4(875),60,nME,G2H4(36),n2h4(603))
  call Hloop_AV_Q(ntryL,G1H8(103),ex4(:),G1H4(876),m3h2x4(:,414),heltab2x8(:,:,558))
  call Hloop_A_Q(ntryL,G1H4(876),60,nME,G2H4(66),n2h4(604))
  call Hloop_QV_A(ntryL,G1H8(5),ex5(:),G1H4(891),m3h2x4(:,415),heltab2x8(:,:,559))
  call Hloop_Q_A(ntryL,G1H4(891),60,nME,G2H4(40),n2h4(605))
  call Hloop_QV_A(ntryL,G1H8(13),ex3(:),G1H4(892),m3h2x4(:,416),heltab2x8(:,:,560))
  call Hloop_Q_A(ntryL,G1H4(892),60,nME,G2H4(305),n2h4(606))
  call Hloop_QV_A(ntryL,G1H8(23),ex4(:),G1H4(907),m3h2x4(:,417),heltab2x8(:,:,561))
  call Hloop_Q_A(ntryL,G1H4(907),60,nME,G2H4(44),n2h4(607))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(908),m3h2x4(:,418),heltab2x8(:,:,562))
  call Hloop_A_Q(ntryL,G1H4(908),60,nME,G2H4(353),n2h4(608))
  call Hloop_QV_A(ntryL,G1H8(355),ex3(:),G1H4(923),m3h2x4(:,419),heltab2x8(:,:,563))
  call Hloop_Q_A(ntryL,G1H4(923),39,nME,G2H4(48),n2h4(609))
  call Hloop_QV_A(ntryL,G1H8(128),ex3(:),G1H4(924),m3h2x4(:,420),heltab2x8(:,:,564))
  call Hloop_Q_A(ntryL,G1H4(924),39,nME,G2H4(79),n2h4(610))
  call Hloop_QV_A(ntryL,G1H8(275),ex4(:),G1H4(939),m3h2x4(:,421),heltab2x8(:,:,565))
  call Hloop_Q_A(ntryL,G1H4(939),43,nME,G2H4(52),n2h4(611))
  call Hloop_QV_A(ntryL,G1H8(16),ex4(:),G1H4(940),m3h2x4(:,422),heltab2x8(:,:,566))
  call Hloop_Q_A(ntryL,G1H4(940),43,nME,G2H4(78),n2h4(612))
  call Hloop_QV_A(ntryL,G1H8(40),ex5(:),G1H4(955),m3h2x4(:,423),heltab2x8(:,:,567))
  call Hloop_Q_A(ntryL,G1H4(955),51,nME,G2H4(56),n2h4(613))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(956),m3h2x4(:,424),heltab2x8(:,:,568))
  call Hloop_Q_A(ntryL,G1H4(956),51,nME,G2H4(329),n2h4(614))
  call Hloop_AV_Q(ntryL,G1H8(339),ex3(:),G1H4(971),m3h2x4(:,425),heltab2x8(:,:,569))
  call Hloop_A_Q(ntryL,G1H4(971),39,nME,G2H4(60),n2h4(615))
  call Hloop_AV_Q(ntryL,G1H8(124),ex3(:),G1H4(972),m3h2x4(:,426),heltab2x8(:,:,570))
  call Hloop_A_Q(ntryL,G1H4(972),39,nME,G2H4(91),n2h4(616))
  call Hloop_AV_Q(ntryL,G1H8(291),ex4(:),G1H4(987),m3h2x4(:,427),heltab2x8(:,:,571))
  call Hloop_A_Q(ntryL,G1H4(987),43,nME,G2H4(64),n2h4(617))
  call Hloop_AV_Q(ntryL,G1H8(33),ex4(:),G1H4(988),m3h2x4(:,428),heltab2x8(:,:,572))
  call Hloop_A_Q(ntryL,G1H4(988),43,nME,G2H4(90),n2h4(618))
  call Hloop_AV_Q(ntryL,G1H8(57),ex5(:),G1H4(1003),m3h2x4(:,429),heltab2x8(:,:,573))
  call Hloop_A_Q(ntryL,G1H4(1003),51,nME,G2H4(68),n2h4(619))
  call Hloop_AV_Q(ntryL,G1H8(77),ex5(:),G1H4(1004),m3h2x4(:,430),heltab2x8(:,:,574))
  call Hloop_A_Q(ntryL,G1H4(1004),51,nME,G2H4(74),n2h4(620))
  call Hloop_AV_Q(ntryL,G1H8(111),ex5(:),G1H4(1024),m3h2x4(:,431),heltab2x8(:,:,575))
  call Hloop_A_Q(ntryL,G1H4(1024),51,nMM,G2H4(72),n2h4(621))
  call Hloop_QV_A(ntryL,G1H8(117),ex5(:),G1H4(1025),m3h2x4(:,432),heltab2x8(:,:,576))
  call Hloop_Q_A(ntryL,G1H4(1025),51,nMM,G2H4(71),n2h4(622))
  call Hloop_AV_Q(ntryL,G1H8(123),ex5(:),G1H4(1045),m3h2x4(:,433),heltab2x8(:,:,577))
  call Hloop_A_Q(ntryL,G1H4(1045),51,0,G2H4(76),n2h4(623))
  call Hloop_QV_A(ntryL,G1H8(129),ex5(:),G1H4(1046),m3h2x4(:,434),heltab2x8(:,:,578))
  call Hloop_Q_A(ntryL,G1H4(1046),51,0,G2H4(86),n2h4(624))
  call Hloop_QV_A(ntryL,G1H8(276),ex4(:),G1H4(1061),m3h2x4(:,435),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H4(1061),43,nMM,G2H4(80),n2h4(625))
  call Hloop_AV_Q(ntryL,G1H8(292),ex4(:),G1H4(1062),m3h2x4(:,436),heltab2x8(:,:,580))
  call Hloop_A_Q(ntryL,G1H4(1062),43,nMM,G2H4(83),n2h4(626))
  call Hloop_QV_A(ntryL,G1H8(323),ex4(:),G1H4(1077),m3h2x4(:,437),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H4(1077),43,0,G2H4(84),n2h4(627))
  call Hloop_AV_Q(ntryL,G1H8(324),ex4(:),G1H4(1078),m3h2x4(:,438),heltab2x8(:,:,582))
  call Hloop_A_Q(ntryL,G1H4(1078),43,0,G2H4(94),n2h4(628))
  call Hloop_QV_A(ntryL,G1H8(159),ex5(:),G1H4(1098),m3h2x4(:,439),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H4(1098),51,nMM,G2H4(88),n2h4(629))
  call Hloop_AV_Q(ntryL,G1H8(165),ex5(:),G1H4(1099),m3h2x4(:,440),heltab2x8(:,:,584))
  call Hloop_A_Q(ntryL,G1H4(1099),51,nMM,G2H4(93),n2h4(630))
  call Hloop_QV_A(ntryL,G1H8(171),ex5(:),G1H4(1119),m3h2x4(:,441),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H4(1119),51,0,G2H4(1),n2h4(631))
  call Hloop_AV_Q(ntryL,G1H8(177),ex5(:),G1H4(1120),m3h2x4(:,442),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H4(1120),51,0,G2H4(54),n2h4(632))
  call Hloop_AV_Q(ntryL,G1H16(4),ex4(:),G1H8(138),m3h2x8(:,205),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H8(138),44,nME,G2H8(115),n2h8(355))
  call Hloop_AV_Q(ntryL,G1H16(36),ex4(:),G1H8(139),m3h2x8(:,206),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G1H8(139),44,nMM,G2H8(117),n2h8(356))
  call Hloop_QV_A(ntryL,G1H16(43),ex4(:),G1H8(143),m3h2x8(:,207),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H8(143),44,nME,G2H8(118),n2h8(357))
  call Hloop_QV_A(ntryL,G1H16(7),ex4(:),G1H8(144),m3h2x8(:,208),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H8(144),44,nMM,G2H8(119),n2h8(358))
  call Hloop_AV_Q(ntryL,G1H16(18),ex4(:),G1H8(145),m3h2x8(:,209),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H8(145),44,0,G2H8(121),n2h8(359))
  call Hloop_QV_A(ntryL,G1H16(45),ex4(:),G1H8(146),m3h2x8(:,210),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H8(146),44,0,G2H8(122),n2h8(360))
  call Hloop_AV_Q(ntryL,G1H8(340),ex3(:),G1H4(1135),m3h2x4(:,443),heltab2x8(:,:,587))
  call Hloop_A_Q(ntryL,G1H4(1135),39,nMM,G2H4(55),n2h4(633))
  call Hloop_QV_A(ntryL,G1H8(356),ex3(:),G1H4(1136),m3h2x4(:,444),heltab2x8(:,:,588))
  call Hloop_Q_A(ntryL,G1H4(1136),39,nMM,G2H4(3),n2h4(634))
  call Hloop_AV_Q(ntryL,G1H8(121),ex3(:),G1H4(1151),m3h2x4(:,445),heltab2x8(:,:,589))
  call Hloop_A_Q(ntryL,G1H4(1151),39,0,G2H4(4),n2h4(635))
  call Hloop_QV_A(ntryL,G1H8(122),ex3(:),G1H4(1152),m3h2x4(:,446),heltab2x8(:,:,590))
  call Hloop_Q_A(ntryL,G1H4(1152),39,0,G2H4(59),n2h4(636))
  call Hloop_QV_A(ntryL,G1H16(51),ex3(:),G1H8(150),m3h2x8(:,211),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G1H8(150),44,nME,G2H8(123),n2h8(361))
  call Hloop_QV_A(ntryL,G1H16(57),ex3(:),G1H8(151),m3h2x8(:,212),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H8(151),44,nMM,G2H8(125),n2h8(362))
  call Hloop_AV_Q(ntryL,G1H16(63),ex3(:),G1H8(152),m3h2x8(:,213),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G1H8(152),44,nME,G2H8(126),n2h8(363))
  call Hloop_AV_Q(ntryL,G1H16(69),ex3(:),G1H8(154),m3h2x8(:,214),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G1H8(154),44,nMM,G2H8(127),n2h8(364))
  call Hloop_QV_A(ntryL,G1H16(75),ex3(:),G1H8(157),m3h2x8(:,215),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H8(157),44,0,G2H8(129),n2h8(365))
  call Hloop_AV_Q(ntryL,G1H16(81),ex3(:),G1H8(158),m3h2x8(:,216),heltab2x16(:,:,312))
  call Hloop_A_Q(ntryL,G1H8(158),44,0,G2H8(130),n2h8(366))
  call Hloop_QV_A(ntryL,G1H8(207),ex4(:),G1H4(1172),m3h2x4(:,447),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H4(1172),43,nMM,G2H4(62),n2h4(637))
  call Hloop_AV_Q(ntryL,G1H8(213),ex4(:),G1H4(1173),m3h2x4(:,448),heltab2x8(:,:,592))
  call Hloop_A_Q(ntryL,G1H4(1173),43,nMM,G2H4(6),n2h4(638))



end subroutine vamp_1

end module ol_vamp_1_eeaa_lew_eexaaaa_4_/**/REALKIND
