
module ol_vamp_1_eeaa_lew_eexaaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeaa_lew_eexaaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeaa_lew_eexaaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeaa_lew_eexaaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_eeaa_lew_eexaaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,8,2,1,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(4),n2h32(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,2,1,4,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,nME,G1H32(5),n2h32(4))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(7),m3h2x32(:,9),heltab2x64(:,:,9))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(17),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,8,2,1,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,4,1,2,8,16],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(17),32,nME,G1H32(21),n2h32(5))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,4,1,2,8,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(17),32,nME,G1H32(22),n2h32(6))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,39),heltab2x64(:,:,39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,4,1,2,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(17),32,nME,G1H32(24),n2h32(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,4,1,2,8,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(17),32,nME,G1H32(25),n2h32(8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,43),heltab2x64(:,:,43))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,45),heltab2x64(:,:,45))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(29),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,49),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,51),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(31),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(33),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(35),m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,4,1,2,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,8,4,1,2,16],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(33),32,nME,G1H32(41),n2h32(9))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,4,1,2,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_A_Q(ntryL,G0H32(33),32,nME,G1H32(42),n2h32(10))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(43),m3h2x32(:,75),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,8,4,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(33),32,nME,G1H32(44),n2h32(11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,8,4,1,2,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(33),32,nME,G1H32(45),n2h32(12))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,78),heltab2x64(:,:,78))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(51),m3h2x32(:,91),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,95),heltab2x64(:,:,95))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,96),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,97),heltab2x64(:,:,97))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,100),heltab2x64(:,:,100))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(57),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(59),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,8,4,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,4,1,2,16,8],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(49),32,nME,G1H32(61),n2h32(13))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,4,1,2,16,8],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(49),32,nME,G1H32(62),n2h32(14))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,4,1,2,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(49),32,nME,G1H32(64),n2h32(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,4,1,2,16,8],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(49),32,nME,G1H32(65),n2h32(16))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,117),heltab2x64(:,:,117))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(69),m3h2x32(:,120),heltab2x64(:,:,120))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,121),heltab2x64(:,:,121))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,122),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,123),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(71),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,132),heltab2x64(:,:,132))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(75),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,135),heltab2x64(:,:,135))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,136),heltab2x64(:,:,136))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,137),heltab2x64(:,:,137))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(77),m3h2x32(:,139),heltab2x64(:,:,139))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,140),heltab2x64(:,:,140))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,141),heltab2x64(:,:,141))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,143),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,4,1,2,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,144),heltab2x64(:,:,144))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,2,1,4,8,16],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_Q_A(ntryL,G0H32(65),32,nME,G1H32(81),n2h32(17))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,2,1,4,8,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,146),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G0H32(65),32,nME,G1H32(82),n2h32(18))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,147),heltab2x64(:,:,147))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,2,1,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,148),heltab2x64(:,:,148))
  call Hloop_Q_A(ntryL,G0H32(65),32,nME,G1H32(84),n2h32(19))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,2,1,4,8,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,149),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G0H32(65),32,nME,G1H32(85),n2h32(20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,150),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,151),heltab2x64(:,:,151))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(87),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,157),heltab2x64(:,:,157))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,159),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,160),heltab2x64(:,:,160))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,161),heltab2x64(:,:,161))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,162),heltab2x64(:,:,162))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,163),heltab2x64(:,:,163))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,164),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,165),heltab2x64(:,:,165))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,166),heltab2x64(:,:,166))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,167),heltab2x64(:,:,167))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(74),m3h2x32(:,168),heltab2x64(:,:,168))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,169),heltab2x64(:,:,169))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(95),m3h2x32(:,171),heltab2x64(:,:,171))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,172),heltab2x64(:,:,172))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,173),heltab2x64(:,:,173))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,174),heltab2x64(:,:,174))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(97),m3h2x32(:,175),heltab2x64(:,:,175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,176),heltab2x64(:,:,176))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,177),heltab2x64(:,:,177))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(99),m3h2x32(:,178),heltab2x64(:,:,178))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(80),m3h2x32(:,179),heltab2x64(:,:,179))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,2,1,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(100),m3h2x32(:,180),heltab2x64(:,:,180))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,2,1,4,16,8],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,181),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G0H32(81),32,nME,G1H32(101),n2h32(21))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,2,1,4,16,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,182),heltab2x64(:,:,182))
  call Hloop_Q_A(ntryL,G0H32(81),32,nME,G1H32(102),n2h32(22))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(103),m3h2x32(:,183),heltab2x64(:,:,183))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,2,1,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,184),heltab2x64(:,:,184))
  call Hloop_Q_A(ntryL,G0H32(81),32,nME,G1H32(104),n2h32(23))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,2,1,4,16,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_Q_A(ntryL,G0H32(81),32,nME,G1H32(105),n2h32(24))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,186),heltab2x64(:,:,186))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(106),m3h2x32(:,187),heltab2x64(:,:,187))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(107),m3h2x32(:,188),heltab2x64(:,:,188))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(82),m3h2x32(:,189),heltab2x64(:,:,189))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(108),m3h2x32(:,190),heltab2x64(:,:,190))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,191),heltab2x64(:,:,191))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(109),m3h2x32(:,193),heltab2x64(:,:,193))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,194),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,195),heltab2x64(:,:,195))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,196),heltab2x64(:,:,196))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,197),heltab2x64(:,:,197))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(111),m3h2x32(:,198),heltab2x64(:,:,198))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(112),m3h2x32(:,199),heltab2x64(:,:,199))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(88),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,201),heltab2x64(:,:,201))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(113),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(114),m3h2x32(:,203),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(90),m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(91),m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,206),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(115),m3h2x32(:,207),heltab2x64(:,:,207))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(116),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,209),heltab2x64(:,:,209))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,210),heltab2x64(:,:,210))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(117),m3h2x32(:,211),heltab2x64(:,:,211))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,213),heltab2x64(:,:,213))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,214),heltab2x64(:,:,214))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,215),heltab2x64(:,:,215))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,2,1,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(120),m3h2x32(:,216),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,8,1,2,4,16],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,217),heltab2x64(:,:,217))
  call Hloop_A_Q(ntryL,G0H32(97),32,nME,G1H32(121),n2h32(25))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,8,1,2,4,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,218),heltab2x64(:,:,218))
  call Hloop_A_Q(ntryL,G0H32(97),32,nME,G1H32(122),n2h32(26))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(123),m3h2x32(:,219),heltab2x64(:,:,219))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,8,1,2,4,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_A_Q(ntryL,G0H32(97),32,nME,G1H32(124),n2h32(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,8,1,2,4,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_A_Q(ntryL,G0H32(97),32,nME,G1H32(125),n2h32(28))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,222),heltab2x64(:,:,222))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,223),heltab2x64(:,:,223))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(126),m3h2x32(:,224),heltab2x64(:,:,224))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(127),m3h2x32(:,225),heltab2x64(:,:,225))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,226),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(129),m3h2x32(:,227),heltab2x64(:,:,227))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,228),heltab2x64(:,:,228))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,229),heltab2x64(:,:,229))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(101),m3h2x32(:,230),heltab2x64(:,:,230))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,231),heltab2x64(:,:,231))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(130),m3h2x32(:,232),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,233),heltab2x64(:,:,233))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,234),heltab2x64(:,:,234))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(131),m3h2x32(:,235),heltab2x64(:,:,235))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(132),m3h2x32(:,236),heltab2x64(:,:,236))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(133),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(134),m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,239),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,240),heltab2x64(:,:,240))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(135),m3h2x32(:,241),heltab2x64(:,:,241))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(108),m3h2x32(:,243),heltab2x64(:,:,243))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,244),heltab2x64(:,:,244))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(110),m3h2x32(:,245),heltab2x64(:,:,245))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,246),heltab2x64(:,:,246))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(137),m3h2x32(:,247),heltab2x64(:,:,247))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(138),m3h2x32(:,248),heltab2x64(:,:,248))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(139),m3h2x32(:,249),heltab2x64(:,:,249))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(111),m3h2x32(:,250),heltab2x64(:,:,250))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(112),m3h2x32(:,251),heltab2x64(:,:,251))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,8,1,2,4,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(140),m3h2x32(:,252),heltab2x64(:,:,252))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,4,2,1,8,16],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_Q_A(ntryL,G0H32(113),32,nME,G1H32(141),n2h32(29))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,4,2,1,8,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_Q_A(ntryL,G0H32(113),32,nME,G1H32(142),n2h32(30))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(143),m3h2x32(:,255),heltab2x64(:,:,255))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,4,2,1,8,16],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,256),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(113),32,nME,G1H32(144),n2h32(31))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,4,2,1,8,16],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_Q_A(ntryL,G0H32(113),32,nME,G1H32(145),n2h32(32))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,258),heltab2x64(:,:,258))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(146),m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,260),heltab2x64(:,:,260))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(147),m3h2x32(:,261),heltab2x64(:,:,261))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(148),m3h2x32(:,262),heltab2x64(:,:,262))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,263),heltab2x64(:,:,263))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(149),m3h2x32(:,264),heltab2x64(:,:,264))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(116),m3h2x32(:,265),heltab2x64(:,:,265))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,266),heltab2x64(:,:,266))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(150),m3h2x32(:,267),heltab2x64(:,:,267))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,268),heltab2x64(:,:,268))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,269),heltab2x64(:,:,269))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(151),m3h2x32(:,270),heltab2x64(:,:,270))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(120),m3h2x32(:,271),heltab2x64(:,:,271))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(152),m3h2x32(:,272),heltab2x64(:,:,272))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(153),m3h2x32(:,273),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,274),heltab2x64(:,:,274))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(154),m3h2x32(:,275),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(122),m3h2x32(:,276),heltab2x64(:,:,276))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,277),heltab2x64(:,:,277))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(155),m3h2x32(:,278),heltab2x64(:,:,278))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,279),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,280),heltab2x64(:,:,280))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(156),m3h2x32(:,281),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,282),heltab2x64(:,:,282))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(157),m3h2x32(:,283),heltab2x64(:,:,283))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(158),m3h2x32(:,284),heltab2x64(:,:,284))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,285),heltab2x64(:,:,285))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(159),m3h2x32(:,286),heltab2x64(:,:,286))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(128),m3h2x32(:,287),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,4,2,1,8,16],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(160),m3h2x32(:,288),heltab2x64(:,:,288))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,4,8,1,2,16],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,289),heltab2x64(:,:,289))
  call Hloop_A_Q(ntryL,G0H32(129),32,nME,G1H32(161),n2h32(33))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,4,8,1,2,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,290),heltab2x64(:,:,290))
  call Hloop_A_Q(ntryL,G0H32(129),32,nME,G1H32(162),n2h32(34))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(163),m3h2x32(:,291),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,4,8,1,2,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,292),heltab2x64(:,:,292))
  call Hloop_A_Q(ntryL,G0H32(129),32,nME,G1H32(164),n2h32(35))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,4,8,1,2,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,293),heltab2x64(:,:,293))
  call Hloop_A_Q(ntryL,G0H32(129),32,nME,G1H32(165),n2h32(36))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(129),m3h2x32(:,294),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(130),m3h2x32(:,295),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(166),m3h2x32(:,296),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(167),m3h2x32(:,297),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(168),m3h2x32(:,298),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(169),m3h2x32(:,299),heltab2x64(:,:,299))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(131),m3h2x32(:,300),heltab2x64(:,:,300))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(132),m3h2x32(:,301),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(133),m3h2x32(:,302),heltab2x64(:,:,302))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(134),m3h2x32(:,303),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(170),m3h2x32(:,304),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(135),m3h2x32(:,305),heltab2x64(:,:,305))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(136),m3h2x32(:,306),heltab2x64(:,:,306))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(171),m3h2x32(:,307),heltab2x64(:,:,307))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(172),m3h2x32(:,308),heltab2x64(:,:,308))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(173),m3h2x32(:,309),heltab2x64(:,:,309))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(174),m3h2x32(:,310),heltab2x64(:,:,310))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(137),m3h2x32(:,311),heltab2x64(:,:,311))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(138),m3h2x32(:,312),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(175),m3h2x32(:,313),heltab2x64(:,:,313))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(139),m3h2x32(:,314),heltab2x64(:,:,314))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(140),m3h2x32(:,315),heltab2x64(:,:,315))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(141),m3h2x32(:,316),heltab2x64(:,:,316))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(142),m3h2x32(:,317),heltab2x64(:,:,317))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(176),m3h2x32(:,318),heltab2x64(:,:,318))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(177),m3h2x32(:,319),heltab2x64(:,:,319))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(178),m3h2x32(:,320),heltab2x64(:,:,320))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(179),m3h2x32(:,321),heltab2x64(:,:,321))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(143),m3h2x32(:,322),heltab2x64(:,:,322))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(144),m3h2x32(:,323),heltab2x64(:,:,323))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,4,8,1,2,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(180),m3h2x32(:,324),heltab2x64(:,:,324))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,4,16,2,1,8],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,325),heltab2x64(:,:,325))
  call Hloop_Q_A(ntryL,G0H32(145),32,nME,G1H32(181),n2h32(37))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,4,16,2,1,8],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,326),heltab2x64(:,:,326))
  call Hloop_Q_A(ntryL,G0H32(145),32,nME,G1H32(182),n2h32(38))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(183),m3h2x32(:,327),heltab2x64(:,:,327))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,4,16,2,1,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,328),heltab2x64(:,:,328))
  call Hloop_Q_A(ntryL,G0H32(145),32,nME,G1H32(184),n2h32(39))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,4,16,2,1,8],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,329),heltab2x64(:,:,329))
  call Hloop_Q_A(ntryL,G0H32(145),32,nME,G1H32(185),n2h32(40))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(145),m3h2x32(:,330),heltab2x64(:,:,330))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(146),m3h2x32(:,331),heltab2x64(:,:,331))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(186),m3h2x32(:,332),heltab2x64(:,:,332))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(187),m3h2x32(:,333),heltab2x64(:,:,333))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(188),m3h2x32(:,334),heltab2x64(:,:,334))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(189),m3h2x32(:,335),heltab2x64(:,:,335))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(147),m3h2x32(:,336),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(148),m3h2x32(:,337),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(149),m3h2x32(:,338),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(150),m3h2x32(:,339),heltab2x64(:,:,339))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(190),m3h2x32(:,340),heltab2x64(:,:,340))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(151),m3h2x32(:,341),heltab2x64(:,:,341))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(152),m3h2x32(:,342),heltab2x64(:,:,342))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(191),m3h2x32(:,343),heltab2x64(:,:,343))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(192),m3h2x32(:,344),heltab2x64(:,:,344))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(193),m3h2x32(:,345),heltab2x64(:,:,345))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(194),m3h2x32(:,346),heltab2x64(:,:,346))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(153),m3h2x32(:,347),heltab2x64(:,:,347))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(154),m3h2x32(:,348),heltab2x64(:,:,348))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(195),m3h2x32(:,349),heltab2x64(:,:,349))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(155),m3h2x32(:,350),heltab2x64(:,:,350))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(156),m3h2x32(:,351),heltab2x64(:,:,351))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(157),m3h2x32(:,352),heltab2x64(:,:,352))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(158),m3h2x32(:,353),heltab2x64(:,:,353))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(196),m3h2x32(:,354),heltab2x64(:,:,354))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(197),m3h2x32(:,355),heltab2x64(:,:,355))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(198),m3h2x32(:,356),heltab2x64(:,:,356))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(199),m3h2x32(:,357),heltab2x64(:,:,357))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(159),m3h2x32(:,358),heltab2x64(:,:,358))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(160),m3h2x32(:,359),heltab2x64(:,:,359))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[32,4,16,2,1,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(200),m3h2x32(:,360),heltab2x64(:,:,360))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,2,1,8,4,16],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,361),heltab2x64(:,:,361))
  call Hloop_Q_A(ntryL,G0H32(161),32,nME,G1H32(201),n2h32(41))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,2,1,8,4,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,362),heltab2x64(:,:,362))
  call Hloop_Q_A(ntryL,G0H32(161),32,nME,G1H32(202),n2h32(42))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(203),m3h2x32(:,363),heltab2x64(:,:,363))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,2,1,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,364),heltab2x64(:,:,364))
  call Hloop_Q_A(ntryL,G0H32(161),32,nME,G1H32(204),n2h32(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,2,1,8,4,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,365),heltab2x64(:,:,365))
  call Hloop_Q_A(ntryL,G0H32(161),32,nME,G1H32(205),n2h32(44))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(161),m3h2x32(:,366),heltab2x64(:,:,366))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(206),m3h2x32(:,367),heltab2x64(:,:,367))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(207),m3h2x32(:,368),heltab2x64(:,:,368))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(162),m3h2x32(:,369),heltab2x64(:,:,369))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(208),m3h2x32(:,370),heltab2x64(:,:,370))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(163),m3h2x32(:,371),heltab2x64(:,:,371))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(164),m3h2x32(:,372),heltab2x64(:,:,372))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(209),m3h2x32(:,373),heltab2x64(:,:,373))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(210),m3h2x32(:,374),heltab2x64(:,:,374))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(165),m3h2x32(:,375),heltab2x64(:,:,375))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(166),m3h2x32(:,376),heltab2x64(:,:,376))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(167),m3h2x32(:,377),heltab2x64(:,:,377))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(211),m3h2x32(:,378),heltab2x64(:,:,378))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(212),m3h2x32(:,379),heltab2x64(:,:,379))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(168),m3h2x32(:,380),heltab2x64(:,:,380))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(169),m3h2x32(:,381),heltab2x64(:,:,381))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(213),m3h2x32(:,382),heltab2x64(:,:,382))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(214),m3h2x32(:,383),heltab2x64(:,:,383))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(170),m3h2x32(:,384),heltab2x64(:,:,384))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(171),m3h2x32(:,385),heltab2x64(:,:,385))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(172),m3h2x32(:,386),heltab2x64(:,:,386))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(215),m3h2x32(:,387),heltab2x64(:,:,387))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(216),m3h2x32(:,388),heltab2x64(:,:,388))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(173),m3h2x32(:,389),heltab2x64(:,:,389))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(174),m3h2x32(:,390),heltab2x64(:,:,390))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(217),m3h2x32(:,391),heltab2x64(:,:,391))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(175),m3h2x32(:,392),heltab2x64(:,:,392))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(218),m3h2x32(:,393),heltab2x64(:,:,393))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(219),m3h2x32(:,394),heltab2x64(:,:,394))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(176),m3h2x32(:,395),heltab2x64(:,:,395))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,2,1,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(220),m3h2x32(:,396),heltab2x64(:,:,396))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,2,1,8,16,4],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,397),heltab2x64(:,:,397))
  call Hloop_Q_A(ntryL,G0H32(177),32,nME,G1H32(221),n2h32(45))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,2,1,8,16,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,398),heltab2x64(:,:,398))
  call Hloop_Q_A(ntryL,G0H32(177),32,nME,G1H32(222),n2h32(46))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(223),m3h2x32(:,399),heltab2x64(:,:,399))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,2,1,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,400),heltab2x64(:,:,400))
  call Hloop_Q_A(ntryL,G0H32(177),32,nME,G1H32(224),n2h32(47))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,2,1,8,16,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,401),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G0H32(177),32,nME,G1H32(225),n2h32(48))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(226),m3h2x32(:,402),heltab2x64(:,:,402))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(177),m3h2x32(:,403),heltab2x64(:,:,403))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(227),m3h2x32(:,404),heltab2x64(:,:,404))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(178),m3h2x32(:,405),heltab2x64(:,:,405))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(228),m3h2x32(:,406),heltab2x64(:,:,406))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(179),m3h2x32(:,407),heltab2x64(:,:,407))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(229),m3h2x32(:,408),heltab2x64(:,:,408))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(180),m3h2x32(:,409),heltab2x64(:,:,409))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(181),m3h2x32(:,410),heltab2x64(:,:,410))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(230),m3h2x32(:,411),heltab2x64(:,:,411))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(182),m3h2x32(:,412),heltab2x64(:,:,412))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(231),m3h2x32(:,413),heltab2x64(:,:,413))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(183),m3h2x32(:,414),heltab2x64(:,:,414))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(232),m3h2x32(:,415),heltab2x64(:,:,415))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(184),m3h2x32(:,416),heltab2x64(:,:,416))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(185),m3h2x32(:,417),heltab2x64(:,:,417))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(233),m3h2x32(:,418),heltab2x64(:,:,418))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(186),m3h2x32(:,419),heltab2x64(:,:,419))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(234),m3h2x32(:,420),heltab2x64(:,:,420))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(187),m3h2x32(:,421),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(235),m3h2x32(:,422),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(188),m3h2x32(:,423),heltab2x64(:,:,423))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(189),m3h2x32(:,424),heltab2x64(:,:,424))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(236),m3h2x32(:,425),heltab2x64(:,:,425))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(190),m3h2x32(:,426),heltab2x64(:,:,426))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(237),m3h2x32(:,427),heltab2x64(:,:,427))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(191),m3h2x32(:,428),heltab2x64(:,:,428))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(238),m3h2x32(:,429),heltab2x64(:,:,429))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(192),m3h2x32(:,430),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(239),m3h2x32(:,431),heltab2x64(:,:,431))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[32,2,1,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(240),m3h2x32(:,432),heltab2x64(:,:,432))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,8,4,2,1,16],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,433),heltab2x64(:,:,433))
  call Hloop_Q_A(ntryL,G0H32(193),32,nME,G1H32(241),n2h32(49))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,8,4,2,1,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,434),heltab2x64(:,:,434))
  call Hloop_Q_A(ntryL,G0H32(193),32,nME,G1H32(242),n2h32(50))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(243),m3h2x32(:,435),heltab2x64(:,:,435))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,8,4,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,436),heltab2x64(:,:,436))
  call Hloop_Q_A(ntryL,G0H32(193),32,nME,G1H32(244),n2h32(51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,8,4,2,1,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,437),heltab2x64(:,:,437))
  call Hloop_Q_A(ntryL,G0H32(193),32,nME,G1H32(245),n2h32(52))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(193),m3h2x32(:,438),heltab2x64(:,:,438))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(194),m3h2x32(:,439),heltab2x64(:,:,439))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(246),m3h2x32(:,440),heltab2x64(:,:,440))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(247),m3h2x32(:,441),heltab2x64(:,:,441))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(248),m3h2x32(:,442),heltab2x64(:,:,442))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(249),m3h2x32(:,443),heltab2x64(:,:,443))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(195),m3h2x32(:,444),heltab2x64(:,:,444))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(196),m3h2x32(:,445),heltab2x64(:,:,445))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(197),m3h2x32(:,446),heltab2x64(:,:,446))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(198),m3h2x32(:,447),heltab2x64(:,:,447))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(250),m3h2x32(:,448),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(199),m3h2x32(:,449),heltab2x64(:,:,449))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(200),m3h2x32(:,450),heltab2x64(:,:,450))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(251),m3h2x32(:,451),heltab2x64(:,:,451))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(252),m3h2x32(:,452),heltab2x64(:,:,452))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(253),m3h2x32(:,453),heltab2x64(:,:,453))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(254),m3h2x32(:,454),heltab2x64(:,:,454))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(201),m3h2x32(:,455),heltab2x64(:,:,455))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(202),m3h2x32(:,456),heltab2x64(:,:,456))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(255),m3h2x32(:,457),heltab2x64(:,:,457))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(203),m3h2x32(:,458),heltab2x64(:,:,458))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(204),m3h2x32(:,459),heltab2x64(:,:,459))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(205),m3h2x32(:,460),heltab2x64(:,:,460))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(206),m3h2x32(:,461),heltab2x64(:,:,461))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(256),m3h2x32(:,462),heltab2x64(:,:,462))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(257),m3h2x32(:,463),heltab2x64(:,:,463))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(258),m3h2x32(:,464),heltab2x64(:,:,464))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(259),m3h2x32(:,465),heltab2x64(:,:,465))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(207),m3h2x32(:,466),heltab2x64(:,:,466))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(208),m3h2x32(:,467),heltab2x64(:,:,467))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[32,8,4,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(260),m3h2x32(:,468),heltab2x64(:,:,468))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[32,4,2,1,16,8],[nME,nME,nMH,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,469),heltab2x64(:,:,469))
  call Hloop_Q_A(ntryL,G0H32(209),32,nME,G1H32(261),n2h32(53))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[32,4,2,1,16,8],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,470),heltab2x64(:,:,470))
  call Hloop_Q_A(ntryL,G0H32(209),32,nME,G1H32(262),n2h32(54))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(263),m3h2x32(:,471),heltab2x64(:,:,471))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[32,4,2,1,16,8],[nME,nME,0,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,472),heltab2x64(:,:,472))
  call Hloop_Q_A(ntryL,G0H32(209),32,nME,G1H32(264),n2h32(55))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[32,4,2,1,16,8],[nME,nME,nMZ,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,473),heltab2x64(:,:,473))
  call Hloop_Q_A(ntryL,G0H32(209),32,nME,G1H32(265),n2h32(56))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(209),m3h2x32(:,474),heltab2x64(:,:,474))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(266),m3h2x32(:,475),heltab2x64(:,:,475))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(210),m3h2x32(:,476),heltab2x64(:,:,476))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(267),m3h2x32(:,477),heltab2x64(:,:,477))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(268),m3h2x32(:,478),heltab2x64(:,:,478))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(211),m3h2x32(:,479),heltab2x64(:,:,479))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(269),m3h2x32(:,480),heltab2x64(:,:,480))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(212),m3h2x32(:,481),heltab2x64(:,:,481))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(213),m3h2x32(:,482),heltab2x64(:,:,482))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(270),m3h2x32(:,483),heltab2x64(:,:,483))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(214),m3h2x32(:,484),heltab2x64(:,:,484))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(215),m3h2x32(:,485),heltab2x64(:,:,485))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(271),m3h2x32(:,486),heltab2x64(:,:,486))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(216),m3h2x32(:,487),heltab2x64(:,:,487))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(272),m3h2x32(:,488),heltab2x64(:,:,488))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(273),m3h2x32(:,489),heltab2x64(:,:,489))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(217),m3h2x32(:,490),heltab2x64(:,:,490))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(274),m3h2x32(:,491),heltab2x64(:,:,491))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(218),m3h2x32(:,492),heltab2x64(:,:,492))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(219),m3h2x32(:,493),heltab2x64(:,:,493))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(275),m3h2x32(:,494),heltab2x64(:,:,494))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(220),m3h2x32(:,495),heltab2x64(:,:,495))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(221),m3h2x32(:,496),heltab2x64(:,:,496))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(276),m3h2x32(:,497),heltab2x64(:,:,497))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(222),m3h2x32(:,498),heltab2x64(:,:,498))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(277),m3h2x32(:,499),heltab2x64(:,:,499))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(278),m3h2x32(:,500),heltab2x64(:,:,500))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(223),m3h2x32(:,501),heltab2x64(:,:,501))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(279),m3h2x32(:,502),heltab2x64(:,:,502))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(224),m3h2x32(:,503),heltab2x64(:,:,503))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[32,4,2,1,16,8],[nMW,nMW,0,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(280),m3h2x32(:,504),heltab2x64(:,:,504))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[32,4,8,2,1,16],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(225),m3h2x32(:,505),heltab2x64(:,:,505))
  call Hloop_Q_A(ntryL,G0H32(225),32,nME,G1H32(281),n2h32(57))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,4,8,2,1,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(225),m3h2x32(:,506),heltab2x64(:,:,506))
  call Hloop_Q_A(ntryL,G0H32(225),32,nME,G1H32(282),n2h32(58))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(283),m3h2x32(:,507),heltab2x64(:,:,507))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,4,8,2,1,16],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(225),m3h2x32(:,508),heltab2x64(:,:,508))
  call Hloop_Q_A(ntryL,G0H32(225),32,nME,G1H32(284),n2h32(59))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[32,4,8,2,1,16],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(225),m3h2x32(:,509),heltab2x64(:,:,509))
  call Hloop_Q_A(ntryL,G0H32(225),32,nME,G1H32(285),n2h32(60))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(225),m3h2x32(:,510),heltab2x64(:,:,510))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(226),m3h2x32(:,511),heltab2x64(:,:,511))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(286),m3h2x32(:,512),heltab2x64(:,:,512))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(287),m3h2x32(:,513),heltab2x64(:,:,513))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(288),m3h2x32(:,514),heltab2x64(:,:,514))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(289),m3h2x32(:,515),heltab2x64(:,:,515))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(227),m3h2x32(:,516),heltab2x64(:,:,516))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(228),m3h2x32(:,517),heltab2x64(:,:,517))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(229),m3h2x32(:,518),heltab2x64(:,:,518))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(230),m3h2x32(:,519),heltab2x64(:,:,519))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(290),m3h2x32(:,520),heltab2x64(:,:,520))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(231),m3h2x32(:,521),heltab2x64(:,:,521))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(232),m3h2x32(:,522),heltab2x64(:,:,522))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(291),m3h2x32(:,523),heltab2x64(:,:,523))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(292),m3h2x32(:,524),heltab2x64(:,:,524))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(293),m3h2x32(:,525),heltab2x64(:,:,525))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(294),m3h2x32(:,526),heltab2x64(:,:,526))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(233),m3h2x32(:,527),heltab2x64(:,:,527))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(234),m3h2x32(:,528),heltab2x64(:,:,528))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(295),m3h2x32(:,529),heltab2x64(:,:,529))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(235),m3h2x32(:,530),heltab2x64(:,:,530))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(236),m3h2x32(:,531),heltab2x64(:,:,531))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(237),m3h2x32(:,532),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(238),m3h2x32(:,533),heltab2x64(:,:,533))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(296),m3h2x32(:,534),heltab2x64(:,:,534))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(297),m3h2x32(:,535),heltab2x64(:,:,535))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(298),m3h2x32(:,536),heltab2x64(:,:,536))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(299),m3h2x32(:,537),heltab2x64(:,:,537))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(239),m3h2x32(:,538),heltab2x64(:,:,538))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(240),m3h2x32(:,539),heltab2x64(:,:,539))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[32,4,8,2,1,16],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(300),m3h2x32(:,540),heltab2x64(:,:,540))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[32,4,16,1,2,8],[nME,nME,nME,nMH,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,541),heltab2x64(:,:,541))
  call Hloop_A_Q(ntryL,G0H32(241),32,nME,G1H32(301),n2h32(61))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[32,4,16,1,2,8],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,542),heltab2x64(:,:,542))
  call Hloop_A_Q(ntryL,G0H32(241),32,nME,G1H32(302),n2h32(62))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(303),m3h2x32(:,543),heltab2x64(:,:,543))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[32,4,16,1,2,8],[nME,nME,nME,0,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,544),heltab2x64(:,:,544))
  call Hloop_A_Q(ntryL,G0H32(241),32,nME,G1H32(304),n2h32(63))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[32,4,16,1,2,8],[nME,nME,nME,nMZ,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,545),heltab2x64(:,:,545))
  call Hloop_A_Q(ntryL,G0H32(241),32,nME,G1H32(305),n2h32(64))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(241),m3h2x32(:,546),heltab2x64(:,:,546))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(242),m3h2x32(:,547),heltab2x64(:,:,547))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(306),m3h2x32(:,548),heltab2x64(:,:,548))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(307),m3h2x32(:,549),heltab2x64(:,:,549))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(308),m3h2x32(:,550),heltab2x64(:,:,550))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(309),m3h2x32(:,551),heltab2x64(:,:,551))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(243),m3h2x32(:,552),heltab2x64(:,:,552))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(244),m3h2x32(:,553),heltab2x64(:,:,553))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(245),m3h2x32(:,554),heltab2x64(:,:,554))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(246),m3h2x32(:,555),heltab2x64(:,:,555))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(310),m3h2x32(:,556),heltab2x64(:,:,556))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(247),m3h2x32(:,557),heltab2x64(:,:,557))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(248),m3h2x32(:,558),heltab2x64(:,:,558))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(311),m3h2x32(:,559),heltab2x64(:,:,559))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(312),m3h2x32(:,560),heltab2x64(:,:,560))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(313),m3h2x32(:,561),heltab2x64(:,:,561))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(314),m3h2x32(:,562),heltab2x64(:,:,562))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(249),m3h2x32(:,563),heltab2x64(:,:,563))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(250),m3h2x32(:,564),heltab2x64(:,:,564))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(315),m3h2x32(:,565),heltab2x64(:,:,565))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(251),m3h2x32(:,566),heltab2x64(:,:,566))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(252),m3h2x32(:,567),heltab2x64(:,:,567))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(253),m3h2x32(:,568),heltab2x64(:,:,568))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(254),m3h2x32(:,569),heltab2x64(:,:,569))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(316),m3h2x32(:,570),heltab2x64(:,:,570))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(317),m3h2x32(:,571),heltab2x64(:,:,571))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(318),m3h2x32(:,572),heltab2x64(:,:,572))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(319),m3h2x32(:,573),heltab2x64(:,:,573))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(255),m3h2x32(:,574),heltab2x64(:,:,574))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(256),m3h2x32(:,575),heltab2x64(:,:,575))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[32,4,16,1,2,8],[nMW,nMW,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(320),m3h2x32(:,576),heltab2x64(:,:,576))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[32,2,1,16,4,8],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,577),heltab2x64(:,:,577))
  call Hloop_Q_A(ntryL,G0H32(257),32,nME,G1H32(321),n2h32(65))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[32,2,1,16,4,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,578),heltab2x64(:,:,578))
  call Hloop_Q_A(ntryL,G0H32(257),32,nME,G1H32(322),n2h32(66))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(323),m3h2x32(:,579),heltab2x64(:,:,579))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[32,2,1,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,580),heltab2x64(:,:,580))
  call Hloop_Q_A(ntryL,G0H32(257),32,nME,G1H32(324),n2h32(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[32,2,1,16,4,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,581),heltab2x64(:,:,581))
  call Hloop_Q_A(ntryL,G0H32(257),32,nME,G1H32(325),n2h32(68))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(257),m3h2x32(:,582),heltab2x64(:,:,582))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(326),m3h2x32(:,583),heltab2x64(:,:,583))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(327),m3h2x32(:,584),heltab2x64(:,:,584))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(258),m3h2x32(:,585),heltab2x64(:,:,585))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(328),m3h2x32(:,586),heltab2x64(:,:,586))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(259),m3h2x32(:,587),heltab2x64(:,:,587))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(260),m3h2x32(:,588),heltab2x64(:,:,588))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(329),m3h2x32(:,589),heltab2x64(:,:,589))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(330),m3h2x32(:,590),heltab2x64(:,:,590))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(261),m3h2x32(:,591),heltab2x64(:,:,591))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(262),m3h2x32(:,592),heltab2x64(:,:,592))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(263),m3h2x32(:,593),heltab2x64(:,:,593))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(331),m3h2x32(:,594),heltab2x64(:,:,594))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(332),m3h2x32(:,595),heltab2x64(:,:,595))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(264),m3h2x32(:,596),heltab2x64(:,:,596))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(265),m3h2x32(:,597),heltab2x64(:,:,597))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(333),m3h2x32(:,598),heltab2x64(:,:,598))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(334),m3h2x32(:,599),heltab2x64(:,:,599))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(266),m3h2x32(:,600),heltab2x64(:,:,600))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(267),m3h2x32(:,601),heltab2x64(:,:,601))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(268),m3h2x32(:,602),heltab2x64(:,:,602))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(335),m3h2x32(:,603),heltab2x64(:,:,603))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(336),m3h2x32(:,604),heltab2x64(:,:,604))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(269),m3h2x32(:,605),heltab2x64(:,:,605))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(270),m3h2x32(:,606),heltab2x64(:,:,606))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(337),m3h2x32(:,607),heltab2x64(:,:,607))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(271),m3h2x32(:,608),heltab2x64(:,:,608))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(338),m3h2x32(:,609),heltab2x64(:,:,609))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(339),m3h2x32(:,610),heltab2x64(:,:,610))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(272),m3h2x32(:,611),heltab2x64(:,:,611))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(340),m3h2x32(:,612),heltab2x64(:,:,612))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[32,2,1,16,8,4],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,613),heltab2x64(:,:,613))
  call Hloop_Q_A(ntryL,G0H32(273),32,nME,G1H32(341),n2h32(69))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[32,2,1,16,8,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,614),heltab2x64(:,:,614))
  call Hloop_Q_A(ntryL,G0H32(273),32,nME,G1H32(342),n2h32(70))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(343),m3h2x32(:,615),heltab2x64(:,:,615))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[32,2,1,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,616),heltab2x64(:,:,616))
  call Hloop_Q_A(ntryL,G0H32(273),32,nME,G1H32(344),n2h32(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[32,2,1,16,8,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,617),heltab2x64(:,:,617))
  call Hloop_Q_A(ntryL,G0H32(273),32,nME,G1H32(345),n2h32(72))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(346),m3h2x32(:,618),heltab2x64(:,:,618))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(273),m3h2x32(:,619),heltab2x64(:,:,619))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(347),m3h2x32(:,620),heltab2x64(:,:,620))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(274),m3h2x32(:,621),heltab2x64(:,:,621))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(348),m3h2x32(:,622),heltab2x64(:,:,622))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(275),m3h2x32(:,623),heltab2x64(:,:,623))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(349),m3h2x32(:,624),heltab2x64(:,:,624))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(276),m3h2x32(:,625),heltab2x64(:,:,625))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(277),m3h2x32(:,626),heltab2x64(:,:,626))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(350),m3h2x32(:,627),heltab2x64(:,:,627))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(278),m3h2x32(:,628),heltab2x64(:,:,628))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(351),m3h2x32(:,629),heltab2x64(:,:,629))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(279),m3h2x32(:,630),heltab2x64(:,:,630))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(352),m3h2x32(:,631),heltab2x64(:,:,631))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(280),m3h2x32(:,632),heltab2x64(:,:,632))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(281),m3h2x32(:,633),heltab2x64(:,:,633))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(353),m3h2x32(:,634),heltab2x64(:,:,634))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(282),m3h2x32(:,635),heltab2x64(:,:,635))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(354),m3h2x32(:,636),heltab2x64(:,:,636))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(283),m3h2x32(:,637),heltab2x64(:,:,637))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(355),m3h2x32(:,638),heltab2x64(:,:,638))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(284),m3h2x32(:,639),heltab2x64(:,:,639))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(285),m3h2x32(:,640),heltab2x64(:,:,640))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(356),m3h2x32(:,641),heltab2x64(:,:,641))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(286),m3h2x32(:,642),heltab2x64(:,:,642))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(357),m3h2x32(:,643),heltab2x64(:,:,643))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(287),m3h2x32(:,644),heltab2x64(:,:,644))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(358),m3h2x32(:,645),heltab2x64(:,:,645))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(288),m3h2x32(:,646),heltab2x64(:,:,646))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(359),m3h2x32(:,647),heltab2x64(:,:,647))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[32,2,1,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(360),m3h2x32(:,648),heltab2x64(:,:,648))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[32,1,2,4,8,16],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(289),m3h2x32(:,649),heltab2x64(:,:,649))
  call Hloop_A_Q(ntryL,G0H32(289),32,nME,G1H32(361),n2h32(73))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[32,1,2,4,8,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(289),m3h2x32(:,650),heltab2x64(:,:,650))
  call Hloop_A_Q(ntryL,G0H32(289),32,nME,G1H32(362),n2h32(74))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(363),m3h2x32(:,651),heltab2x64(:,:,651))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[32,1,2,4,8,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(289),m3h2x32(:,652),heltab2x64(:,:,652))
  call Hloop_A_Q(ntryL,G0H32(289),32,nME,G1H32(364),n2h32(75))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[32,1,2,4,8,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(289),m3h2x32(:,653),heltab2x64(:,:,653))
  call Hloop_A_Q(ntryL,G0H32(289),32,nME,G1H32(365),n2h32(76))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(289),m3h2x32(:,654),heltab2x64(:,:,654))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(366),m3h2x32(:,655),heltab2x64(:,:,655))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(367),m3h2x32(:,656),heltab2x64(:,:,656))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(368),m3h2x32(:,657),heltab2x64(:,:,657))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(290),m3h2x32(:,658),heltab2x64(:,:,658))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(291),m3h2x32(:,659),heltab2x64(:,:,659))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(292),m3h2x32(:,660),heltab2x64(:,:,660))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(369),m3h2x32(:,661),heltab2x64(:,:,661))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(293),m3h2x32(:,662),heltab2x64(:,:,662))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(370),m3h2x32(:,663),heltab2x64(:,:,663))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(371),m3h2x32(:,664),heltab2x64(:,:,664))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(372),m3h2x32(:,665),heltab2x64(:,:,665))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(294),m3h2x32(:,666),heltab2x64(:,:,666))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(295),m3h2x32(:,667),heltab2x64(:,:,667))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(296),m3h2x32(:,668),heltab2x64(:,:,668))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(297),m3h2x32(:,669),heltab2x64(:,:,669))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(298),m3h2x32(:,670),heltab2x64(:,:,670))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(299),m3h2x32(:,671),heltab2x64(:,:,671))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(373),m3h2x32(:,672),heltab2x64(:,:,672))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(374),m3h2x32(:,673),heltab2x64(:,:,673))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(375),m3h2x32(:,674),heltab2x64(:,:,674))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(300),m3h2x32(:,675),heltab2x64(:,:,675))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(376),m3h2x32(:,676),heltab2x64(:,:,676))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(301),m3h2x32(:,677),heltab2x64(:,:,677))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(302),m3h2x32(:,678),heltab2x64(:,:,678))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(303),m3h2x32(:,679),heltab2x64(:,:,679))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(377),m3h2x32(:,680),heltab2x64(:,:,680))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(378),m3h2x32(:,681),heltab2x64(:,:,681))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(379),m3h2x32(:,682),heltab2x64(:,:,682))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(304),m3h2x32(:,683),heltab2x64(:,:,683))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[32,1,2,4,8,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(380),m3h2x32(:,684),heltab2x64(:,:,684))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[32,1,2,4,16,8],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,685),heltab2x64(:,:,685))
  call Hloop_A_Q(ntryL,G0H32(305),32,nME,G1H32(381),n2h32(77))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[32,1,2,4,16,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,686),heltab2x64(:,:,686))
  call Hloop_A_Q(ntryL,G0H32(305),32,nME,G1H32(382),n2h32(78))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(383),m3h2x32(:,687),heltab2x64(:,:,687))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[32,1,2,4,16,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,688),heltab2x64(:,:,688))
  call Hloop_A_Q(ntryL,G0H32(305),32,nME,G1H32(384),n2h32(79))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[32,1,2,4,16,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,689),heltab2x64(:,:,689))
  call Hloop_A_Q(ntryL,G0H32(305),32,nME,G1H32(385),n2h32(80))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(305),m3h2x32(:,690),heltab2x64(:,:,690))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(386),m3h2x32(:,691),heltab2x64(:,:,691))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(387),m3h2x32(:,692),heltab2x64(:,:,692))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(388),m3h2x32(:,693),heltab2x64(:,:,693))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(306),m3h2x32(:,694),heltab2x64(:,:,694))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(307),m3h2x32(:,695),heltab2x64(:,:,695))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(308),m3h2x32(:,696),heltab2x64(:,:,696))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(389),m3h2x32(:,697),heltab2x64(:,:,697))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(309),m3h2x32(:,698),heltab2x64(:,:,698))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(390),m3h2x32(:,699),heltab2x64(:,:,699))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(391),m3h2x32(:,700),heltab2x64(:,:,700))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(392),m3h2x32(:,701),heltab2x64(:,:,701))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(310),m3h2x32(:,702),heltab2x64(:,:,702))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(311),m3h2x32(:,703),heltab2x64(:,:,703))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(312),m3h2x32(:,704),heltab2x64(:,:,704))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(313),m3h2x32(:,705),heltab2x64(:,:,705))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(314),m3h2x32(:,706),heltab2x64(:,:,706))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(315),m3h2x32(:,707),heltab2x64(:,:,707))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(393),m3h2x32(:,708),heltab2x64(:,:,708))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(394),m3h2x32(:,709),heltab2x64(:,:,709))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(395),m3h2x32(:,710),heltab2x64(:,:,710))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(316),m3h2x32(:,711),heltab2x64(:,:,711))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(396),m3h2x32(:,712),heltab2x64(:,:,712))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(317),m3h2x32(:,713),heltab2x64(:,:,713))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(318),m3h2x32(:,714),heltab2x64(:,:,714))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(319),m3h2x32(:,715),heltab2x64(:,:,715))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(397),m3h2x32(:,716),heltab2x64(:,:,716))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(398),m3h2x32(:,717),heltab2x64(:,:,717))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(399),m3h2x32(:,718),heltab2x64(:,:,718))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(320),m3h2x32(:,719),heltab2x64(:,:,719))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[32,1,2,4,16,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(400),m3h2x32(:,720),heltab2x64(:,:,720))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[32,1,2,8,4,16],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(321),m3h2x32(:,721),heltab2x64(:,:,721))
  call Hloop_A_Q(ntryL,G0H32(321),32,nME,G1H32(401),n2h32(81))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[32,1,2,8,4,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(321),m3h2x32(:,722),heltab2x64(:,:,722))
  call Hloop_A_Q(ntryL,G0H32(321),32,nME,G1H32(402),n2h32(82))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(403),m3h2x32(:,723),heltab2x64(:,:,723))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[32,1,2,8,4,16],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(321),m3h2x32(:,724),heltab2x64(:,:,724))
  call Hloop_A_Q(ntryL,G0H32(321),32,nME,G1H32(404),n2h32(83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[32,1,2,8,4,16],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(321),m3h2x32(:,725),heltab2x64(:,:,725))
  call Hloop_A_Q(ntryL,G0H32(321),32,nME,G1H32(405),n2h32(84))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(321),m3h2x32(:,726),heltab2x64(:,:,726))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(406),m3h2x32(:,727),heltab2x64(:,:,727))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(407),m3h2x32(:,728),heltab2x64(:,:,728))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(408),m3h2x32(:,729),heltab2x64(:,:,729))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(322),m3h2x32(:,730),heltab2x64(:,:,730))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(323),m3h2x32(:,731),heltab2x64(:,:,731))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(324),m3h2x32(:,732),heltab2x64(:,:,732))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(409),m3h2x32(:,733),heltab2x64(:,:,733))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(325),m3h2x32(:,734),heltab2x64(:,:,734))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(410),m3h2x32(:,735),heltab2x64(:,:,735))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(411),m3h2x32(:,736),heltab2x64(:,:,736))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(412),m3h2x32(:,737),heltab2x64(:,:,737))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(326),m3h2x32(:,738),heltab2x64(:,:,738))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(327),m3h2x32(:,739),heltab2x64(:,:,739))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(328),m3h2x32(:,740),heltab2x64(:,:,740))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(329),m3h2x32(:,741),heltab2x64(:,:,741))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(330),m3h2x32(:,742),heltab2x64(:,:,742))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(331),m3h2x32(:,743),heltab2x64(:,:,743))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(413),m3h2x32(:,744),heltab2x64(:,:,744))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(414),m3h2x32(:,745),heltab2x64(:,:,745))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(415),m3h2x32(:,746),heltab2x64(:,:,746))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(332),m3h2x32(:,747),heltab2x64(:,:,747))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(416),m3h2x32(:,748),heltab2x64(:,:,748))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(333),m3h2x32(:,749),heltab2x64(:,:,749))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(334),m3h2x32(:,750),heltab2x64(:,:,750))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(335),m3h2x32(:,751),heltab2x64(:,:,751))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(417),m3h2x32(:,752),heltab2x64(:,:,752))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(418),m3h2x32(:,753),heltab2x64(:,:,753))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(419),m3h2x32(:,754),heltab2x64(:,:,754))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(336),m3h2x32(:,755),heltab2x64(:,:,755))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[32,1,2,8,4,16],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(420),m3h2x32(:,756),heltab2x64(:,:,756))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[32,1,2,8,16,4],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(337),m3h2x32(:,757),heltab2x64(:,:,757))
  call Hloop_A_Q(ntryL,G0H32(337),32,nME,G1H32(421),n2h32(85))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[32,1,2,8,16,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(337),m3h2x32(:,758),heltab2x64(:,:,758))
  call Hloop_A_Q(ntryL,G0H32(337),32,nME,G1H32(422),n2h32(86))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(423),m3h2x32(:,759),heltab2x64(:,:,759))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[32,1,2,8,16,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(337),m3h2x32(:,760),heltab2x64(:,:,760))
  call Hloop_A_Q(ntryL,G0H32(337),32,nME,G1H32(424),n2h32(87))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[32,1,2,8,16,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(337),m3h2x32(:,761),heltab2x64(:,:,761))
  call Hloop_A_Q(ntryL,G0H32(337),32,nME,G1H32(425),n2h32(88))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(426),m3h2x32(:,762),heltab2x64(:,:,762))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(337),m3h2x32(:,763),heltab2x64(:,:,763))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(427),m3h2x32(:,764),heltab2x64(:,:,764))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(428),m3h2x32(:,765),heltab2x64(:,:,765))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(338),m3h2x32(:,766),heltab2x64(:,:,766))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(339),m3h2x32(:,767),heltab2x64(:,:,767))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(429),m3h2x32(:,768),heltab2x64(:,:,768))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(340),m3h2x32(:,769),heltab2x64(:,:,769))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(430),m3h2x32(:,770),heltab2x64(:,:,770))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(341),m3h2x32(:,771),heltab2x64(:,:,771))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(431),m3h2x32(:,772),heltab2x64(:,:,772))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(342),m3h2x32(:,773),heltab2x64(:,:,773))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(432),m3h2x32(:,774),heltab2x64(:,:,774))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(343),m3h2x32(:,775),heltab2x64(:,:,775))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(344),m3h2x32(:,776),heltab2x64(:,:,776))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(345),m3h2x32(:,777),heltab2x64(:,:,777))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(346),m3h2x32(:,778),heltab2x64(:,:,778))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(433),m3h2x32(:,779),heltab2x64(:,:,779))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(347),m3h2x32(:,780),heltab2x64(:,:,780))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(434),m3h2x32(:,781),heltab2x64(:,:,781))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(348),m3h2x32(:,782),heltab2x64(:,:,782))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(435),m3h2x32(:,783),heltab2x64(:,:,783))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(349),m3h2x32(:,784),heltab2x64(:,:,784))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(436),m3h2x32(:,785),heltab2x64(:,:,785))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(350),m3h2x32(:,786),heltab2x64(:,:,786))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(351),m3h2x32(:,787),heltab2x64(:,:,787))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(437),m3h2x32(:,788),heltab2x64(:,:,788))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(438),m3h2x32(:,789),heltab2x64(:,:,789))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(352),m3h2x32(:,790),heltab2x64(:,:,790))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(439),m3h2x32(:,791),heltab2x64(:,:,791))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[32,1,2,8,16,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(440),m3h2x32(:,792),heltab2x64(:,:,792))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[32,1,2,16,4,8],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(353),m3h2x32(:,793),heltab2x64(:,:,793))
  call Hloop_A_Q(ntryL,G0H32(353),32,nME,G1H32(441),n2h32(89))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[32,1,2,16,4,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(353),m3h2x32(:,794),heltab2x64(:,:,794))
  call Hloop_A_Q(ntryL,G0H32(353),32,nME,G1H32(442),n2h32(90))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(443),m3h2x32(:,795),heltab2x64(:,:,795))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[32,1,2,16,4,8],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(353),m3h2x32(:,796),heltab2x64(:,:,796))
  call Hloop_A_Q(ntryL,G0H32(353),32,nME,G1H32(444),n2h32(91))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[32,1,2,16,4,8],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(353),m3h2x32(:,797),heltab2x64(:,:,797))
  call Hloop_A_Q(ntryL,G0H32(353),32,nME,G1H32(445),n2h32(92))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(353),m3h2x32(:,798),heltab2x64(:,:,798))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(446),m3h2x32(:,799),heltab2x64(:,:,799))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(447),m3h2x32(:,800),heltab2x64(:,:,800))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(448),m3h2x32(:,801),heltab2x64(:,:,801))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(354),m3h2x32(:,802),heltab2x64(:,:,802))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(355),m3h2x32(:,803),heltab2x64(:,:,803))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(356),m3h2x32(:,804),heltab2x64(:,:,804))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(805),h0tab(:,805),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(449),m3h2x32(:,805),heltab2x64(:,:,805))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(806),h0tab(:,806),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(357),m3h2x32(:,806),heltab2x64(:,:,806))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(807),h0tab(:,807),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(450),m3h2x32(:,807),heltab2x64(:,:,807))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(808),h0tab(:,808),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(451),m3h2x32(:,808),heltab2x64(:,:,808))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(809),h0tab(:,809),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(452),m3h2x32(:,809),heltab2x64(:,:,809))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(810),h0tab(:,810),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(358),m3h2x32(:,810),heltab2x64(:,:,810))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(811),h0tab(:,811),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(359),m3h2x32(:,811),heltab2x64(:,:,811))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(812),h0tab(:,812),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(360),m3h2x32(:,812),heltab2x64(:,:,812))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(813),h0tab(:,813),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(361),m3h2x32(:,813),heltab2x64(:,:,813))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(814),h0tab(:,814),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(362),m3h2x32(:,814),heltab2x64(:,:,814))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(815),h0tab(:,815),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(363),m3h2x32(:,815),heltab2x64(:,:,815))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(816),h0tab(:,816),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(453),m3h2x32(:,816),heltab2x64(:,:,816))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(817),h0tab(:,817),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(454),m3h2x32(:,817),heltab2x64(:,:,817))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(818),h0tab(:,818),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(455),m3h2x32(:,818),heltab2x64(:,:,818))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(819),h0tab(:,819),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(364),m3h2x32(:,819),heltab2x64(:,:,819))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(820),h0tab(:,820),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(456),m3h2x32(:,820),heltab2x64(:,:,820))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(821),h0tab(:,821),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(365),m3h2x32(:,821),heltab2x64(:,:,821))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(822),h0tab(:,822),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(366),m3h2x32(:,822),heltab2x64(:,:,822))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(823),h0tab(:,823),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(367),m3h2x32(:,823),heltab2x64(:,:,823))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(824),h0tab(:,824),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(457),m3h2x32(:,824),heltab2x64(:,:,824))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(825),h0tab(:,825),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(458),m3h2x32(:,825),heltab2x64(:,:,825))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(826),h0tab(:,826),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(459),m3h2x32(:,826),heltab2x64(:,:,826))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(827),h0tab(:,827),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(368),m3h2x32(:,827),heltab2x64(:,:,827))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(828),h0tab(:,828),[32,1,2,16,4,8],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(460),m3h2x32(:,828),heltab2x64(:,:,828))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(829),h0tab(:,829),[32,1,2,16,8,4],[nME,nMH,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(369),m3h2x32(:,829),heltab2x64(:,:,829))
  call Hloop_A_Q(ntryL,G0H32(369),32,nME,G1H32(461),n2h32(93))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(830),h0tab(:,830),[32,1,2,16,8,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(369),m3h2x32(:,830),heltab2x64(:,:,830))
  call Hloop_A_Q(ntryL,G0H32(369),32,nME,G1H32(462),n2h32(94))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(831),h0tab(:,831),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(463),m3h2x32(:,831),heltab2x64(:,:,831))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(832),h0tab(:,832),[32,1,2,16,8,4],[nME,0,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(369),m3h2x32(:,832),heltab2x64(:,:,832))
  call Hloop_A_Q(ntryL,G0H32(369),32,nME,G1H32(464),n2h32(95))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(833),h0tab(:,833),[32,1,2,16,8,4],[nME,nMZ,nME,nME,nME,nME],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(369),m3h2x32(:,833),heltab2x64(:,:,833))
  call Hloop_A_Q(ntryL,G0H32(369),32,nME,G1H32(465),n2h32(96))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(834),h0tab(:,834),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(466),m3h2x32(:,834),heltab2x64(:,:,834))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(835),h0tab(:,835),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(369),m3h2x32(:,835),heltab2x64(:,:,835))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(836),h0tab(:,836),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(467),m3h2x32(:,836),heltab2x64(:,:,836))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(837),h0tab(:,837),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(468),m3h2x32(:,837),heltab2x64(:,:,837))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(838),h0tab(:,838),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(370),m3h2x32(:,838),heltab2x64(:,:,838))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(839),h0tab(:,839),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(371),m3h2x32(:,839),heltab2x64(:,:,839))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(840),h0tab(:,840),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(469),m3h2x32(:,840),heltab2x64(:,:,840))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(841),h0tab(:,841),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(372),m3h2x32(:,841),heltab2x64(:,:,841))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(842),h0tab(:,842),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(470),m3h2x32(:,842),heltab2x64(:,:,842))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(843),h0tab(:,843),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(373),m3h2x32(:,843),heltab2x64(:,:,843))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(844),h0tab(:,844),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(471),m3h2x32(:,844),heltab2x64(:,:,844))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(845),h0tab(:,845),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(374),m3h2x32(:,845),heltab2x64(:,:,845))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(846),h0tab(:,846),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(472),m3h2x32(:,846),heltab2x64(:,:,846))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(847),h0tab(:,847),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(375),m3h2x32(:,847),heltab2x64(:,:,847))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(848),h0tab(:,848),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(376),m3h2x32(:,848),heltab2x64(:,:,848))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(849),h0tab(:,849),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(377),m3h2x32(:,849),heltab2x64(:,:,849))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(850),h0tab(:,850),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(378),m3h2x32(:,850),heltab2x64(:,:,850))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(851),h0tab(:,851),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(473),m3h2x32(:,851),heltab2x64(:,:,851))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(852),h0tab(:,852),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(379),m3h2x32(:,852),heltab2x64(:,:,852))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(853),h0tab(:,853),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(474),m3h2x32(:,853),heltab2x64(:,:,853))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(854),h0tab(:,854),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(380),m3h2x32(:,854),heltab2x64(:,:,854))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(855),h0tab(:,855),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(475),m3h2x32(:,855),heltab2x64(:,:,855))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(856),h0tab(:,856),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(381),m3h2x32(:,856),heltab2x64(:,:,856))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(857),h0tab(:,857),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(476),m3h2x32(:,857),heltab2x64(:,:,857))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(858),h0tab(:,858),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(382),m3h2x32(:,858),heltab2x64(:,:,858))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(859),h0tab(:,859),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(383),m3h2x32(:,859),heltab2x64(:,:,859))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(860),h0tab(:,860),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(477),m3h2x32(:,860),heltab2x64(:,:,860))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(861),h0tab(:,861),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(478),m3h2x32(:,861),heltab2x64(:,:,861))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(862),h0tab(:,862),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(384),m3h2x32(:,862),heltab2x64(:,:,862))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(863),h0tab(:,863),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(479),m3h2x32(:,863),heltab2x64(:,:,863))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(864),h0tab(:,864),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(480),m3h2x32(:,864),heltab2x64(:,:,864))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(1),n2h16(1))
  call Hloop_QV_A(ntryL,G1H32(2),ex4(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(2),n2h16(2))
  call Hloop_TV_S(ntryL,G1H32(3),32,ex4(:),8,G2H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_QV_A(ntryL,G1H32(4),ex4(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(4),n2h16(3))
  call Hloop_QV_A(ntryL,G1H32(5),ex4(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),40,nME,G2H16(5),n2h16(4))
  call Hloop_TV_S(ntryL,G0H32(1),32,ex4(:),8,G1H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_VV_S(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_TV_S(ntryL,G1H32(6),32,ex4(:),8,G2H16(6),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_SV_V(ntryL,G1H32(7),ex4(:),G1H16(2),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_TV_S(ntryL,G1H32(8),32,ex4(:),8,G2H16(7),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_VV_S(ntryL,G1H32(9),ex4(:),G1H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_TV_S(ntryL,G0H32(3),32,ex4(:),8,G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_VV_S(ntryL,G0H32(4),ex4(:),G0H16(2),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_SV_V(ntryL,G0H32(5),ex4(:),G0H16(3),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_UV_W(ntryL,G0H32(6),32,ex4(:),8,G1H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_SV_V(ntryL,G1H32(10),ex4(:),G1H16(6),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_TV_S(ntryL,G0H32(7),32,ex4(:),8,G1H16(7),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_VV_S(ntryL,G0H32(8),ex4(:),G0H16(4),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_TV_S(ntryL,G1H32(11),32,ex4(:),8,G2H16(8),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_SV_V(ntryL,G1H32(12),ex4(:),G1H16(8),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_VV_S(ntryL,G1H32(13),ex4(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_UV_W(ntryL,G1H32(14),32,ex4(:),8,G2H16(9),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_SV_V(ntryL,G0H32(9),ex4(:),G0H16(5),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_UV_W(ntryL,G0H32(10),32,ex4(:),8,G1H16(10),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_VV_S(ntryL,G1H32(15),ex4(:),G1H16(11),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_TV_S(ntryL,G0H32(11),32,ex4(:),8,G1H16(12),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_VV_S(ntryL,G0H32(12),ex4(:),G0H16(6),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_SV_V(ntryL,G0H32(13),ex4(:),G0H16(7),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_UV_W(ntryL,G0H32(14),32,ex4(:),8,G1H16(13),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_SV_V(ntryL,G1H32(16),ex4(:),G1H16(14),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_UV_W(ntryL,G1H32(17),32,ex4(:),8,G2H16(10),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_VV_S(ntryL,G1H32(18),ex4(:),G1H16(15),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_UV_W(ntryL,G1H32(19),32,ex4(:),8,G2H16(11),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_SV_V(ntryL,G0H32(15),ex4(:),G0H16(8),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_UV_W(ntryL,G0H32(16),32,ex4(:),8,G1H16(16),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_UV_W(ntryL,G1H32(20),32,ex4(:),8,G2H16(12),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H32(21),ex3(:),G1H16(17),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(17),36,nME,G2H16(13),n2h16(5))
  call Hloop_AV_Q(ntryL,G1H32(22),ex3(:),G1H16(17),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(17),36,nME,G2H16(14),n2h16(6))
  call Hloop_SV_T(ntryL,G1H32(23),32,ex3(:),4,G2H16(15),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_AV_Q(ntryL,G1H32(24),ex3(:),G1H16(17),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H16(17),36,nME,G2H16(16),n2h16(7))
  call Hloop_AV_Q(ntryL,G1H32(25),ex3(:),G1H16(17),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(17),36,nME,G2H16(17),n2h16(8))
  call Hloop_SV_T(ntryL,G0H32(17),32,ex3(:),4,G1H16(17),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_SV_T(ntryL,G1H32(26),32,ex3(:),4,G2H16(18),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_VV_S(ntryL,G0H32(18),ex3(:),G0H16(9),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_SV_T(ntryL,G1H32(27),32,ex3(:),4,G2H16(19),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_SV_V(ntryL,G1H32(28),ex3(:),G1H16(18),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_SV_T(ntryL,G0H32(19),32,ex3(:),4,G1H16(19),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_VV_S(ntryL,G1H32(29),ex3(:),G1H16(20),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_VV_S(ntryL,G0H32(20),ex3(:),G0H16(10),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_SV_T(ntryL,G0H32(21),32,ex3(:),4,G1H16(21),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_SV_T(ntryL,G1H32(30),32,ex3(:),4,G2H16(20),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_VV_S(ntryL,G0H32(22),ex3(:),G0H16(11),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_SV_V(ntryL,G0H32(23),ex3(:),G0H16(12),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_SV_V(ntryL,G1H32(31),ex3(:),G1H16(22),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_UW_V(ntryL,G0H32(24),32,ex3(:),4,G1H16(23),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_SV_V(ntryL,G1H32(32),ex3(:),G1H16(24),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_VV_S(ntryL,G1H32(33),ex3(:),G1H16(25),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_SV_T(ntryL,G0H32(25),32,ex3(:),4,G1H16(26),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_VV_S(ntryL,G1H32(34),ex3(:),G1H16(27),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_VV_S(ntryL,G0H32(26),ex3(:),G0H16(13),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_SV_V(ntryL,G0H32(27),ex3(:),G0H16(14),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_UW_V(ntryL,G1H32(35),32,ex3(:),4,G2H16(21),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_UW_V(ntryL,G0H32(28),32,ex3(:),4,G1H16(28),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_SV_V(ntryL,G0H32(29),ex3(:),G0H16(15),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_SV_V(ntryL,G1H32(36),ex3(:),G1H16(29),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_UW_V(ntryL,G0H32(30),32,ex3(:),4,G1H16(30),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_VV_S(ntryL,G1H32(37),ex3(:),G1H16(31),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_UW_V(ntryL,G1H32(38),32,ex3(:),4,G2H16(22),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_SV_V(ntryL,G0H32(31),ex3(:),G0H16(16),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_UW_V(ntryL,G1H32(39),32,ex3(:),4,G2H16(23),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_UW_V(ntryL,G0H32(32),32,ex3(:),4,G1H16(32),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_UW_V(ntryL,G1H32(40),32,ex3(:),4,G2H16(24),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_AV_Q(ntryL,G1H32(41),ex4(:),G1H16(33),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G1H16(33),40,nME,G2H16(25),n2h16(9))
  call Hloop_AV_Q(ntryL,G1H32(42),ex4(:),G1H16(33),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G1H16(33),40,nME,G2H16(26),n2h16(10))
  call Hloop_SV_T(ntryL,G1H32(43),32,ex4(:),8,G2H16(27),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_AV_Q(ntryL,G1H32(44),ex4(:),G1H16(33),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G1H16(33),40,nME,G2H16(28),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H32(45),ex4(:),G1H16(33),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G1H16(33),40,nME,G2H16(29),n2h16(12))
  call Hloop_SV_T(ntryL,G0H32(33),32,ex4(:),8,G1H16(33),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_VV_S(ntryL,G0H32(34),ex4(:),G0H16(17),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_SV_V(ntryL,G1H32(46),ex4(:),G1H16(34),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_SV_T(ntryL,G1H32(47),32,ex4(:),8,G2H16(30),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_SV_T(ntryL,G1H32(48),32,ex4(:),8,G2H16(31),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_VV_S(ntryL,G1H32(49),ex4(:),G1H16(35),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_SV_V(ntryL,G0H32(35),ex4(:),G0H16(18),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_UW_V(ntryL,G0H32(36),32,ex4(:),8,G1H16(36),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_SV_T(ntryL,G0H32(37),32,ex4(:),8,G1H16(37),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_VV_S(ntryL,G0H32(38),ex4(:),G0H16(19),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_SV_V(ntryL,G1H32(50),ex4(:),G1H16(38),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_SV_T(ntryL,G0H32(39),32,ex4(:),8,G1H16(39),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_VV_S(ntryL,G0H32(40),ex4(:),G0H16(20),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_SV_V(ntryL,G1H32(51),ex4(:),G1H16(40),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_SV_T(ntryL,G1H32(52),32,ex4(:),8,G2H16(32),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_UW_V(ntryL,G1H32(53),32,ex4(:),8,G2H16(33),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_VV_S(ntryL,G1H32(54),ex4(:),G1H16(41),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_SV_V(ntryL,G0H32(41),ex4(:),G0H16(21),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_UW_V(ntryL,G0H32(42),32,ex4(:),8,G1H16(42),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_VV_S(ntryL,G1H32(55),ex4(:),G1H16(43),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_SV_V(ntryL,G0H32(43),ex4(:),G0H16(22),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_UW_V(ntryL,G0H32(44),32,ex4(:),8,G1H16(44),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_SV_T(ntryL,G0H32(45),32,ex4(:),8,G1H16(45),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_VV_S(ntryL,G0H32(46),ex4(:),G0H16(23),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_SV_V(ntryL,G1H32(56),ex4(:),G1H16(46),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_UW_V(ntryL,G1H32(57),32,ex4(:),8,G2H16(34),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_UW_V(ntryL,G1H32(58),32,ex4(:),8,G2H16(35),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_VV_S(ntryL,G1H32(59),ex4(:),G1H16(47),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_SV_V(ntryL,G0H32(47),ex4(:),G0H16(24),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_UW_V(ntryL,G0H32(48),32,ex4(:),8,G1H16(48),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_UW_V(ntryL,G1H32(60),32,ex4(:),8,G2H16(36),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_AV_Q(ntryL,G1H32(61),ex3(:),G1H16(49),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G1H16(49),36,nME,G2H16(37),n2h16(13))
  call Hloop_AV_Q(ntryL,G1H32(62),ex3(:),G1H16(49),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G1H16(49),36,nME,G2H16(38),n2h16(14))
  call Hloop_SV_T(ntryL,G1H32(63),32,ex3(:),4,G2H16(39),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_AV_Q(ntryL,G1H32(64),ex3(:),G1H16(49),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G1H16(49),36,nME,G2H16(40),n2h16(15))
  call Hloop_AV_Q(ntryL,G1H32(65),ex3(:),G1H16(49),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G1H16(49),36,nME,G2H16(41),n2h16(16))
  call Hloop_SV_T(ntryL,G0H32(49),32,ex3(:),4,G1H16(49),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_SV_T(ntryL,G1H32(66),32,ex3(:),4,G2H16(42),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_VV_S(ntryL,G0H32(50),ex3(:),G0H16(25),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_SV_T(ntryL,G1H32(67),32,ex3(:),4,G2H16(43),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_SV_V(ntryL,G1H32(68),ex3(:),G1H16(50),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_SV_T(ntryL,G0H32(51),32,ex3(:),4,G1H16(51),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_VV_S(ntryL,G1H32(69),ex3(:),G1H16(52),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_VV_S(ntryL,G0H32(52),ex3(:),G0H16(26),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_SV_T(ntryL,G0H32(53),32,ex3(:),4,G1H16(53),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_SV_T(ntryL,G1H32(70),32,ex3(:),4,G2H16(44),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_VV_S(ntryL,G0H32(54),ex3(:),G0H16(27),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_SV_V(ntryL,G0H32(55),ex3(:),G0H16(28),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_SV_V(ntryL,G1H32(71),ex3(:),G1H16(54),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_UW_V(ntryL,G0H32(56),32,ex3(:),4,G1H16(55),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_SV_V(ntryL,G1H32(72),ex3(:),G1H16(56),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_VV_S(ntryL,G1H32(73),ex3(:),G1H16(57),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_SV_T(ntryL,G0H32(57),32,ex3(:),4,G1H16(58),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_VV_S(ntryL,G1H32(74),ex3(:),G1H16(59),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_VV_S(ntryL,G0H32(58),ex3(:),G0H16(29),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_SV_V(ntryL,G0H32(59),ex3(:),G0H16(30),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_UW_V(ntryL,G1H32(75),32,ex3(:),4,G2H16(45),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_UW_V(ntryL,G0H32(60),32,ex3(:),4,G1H16(60),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_SV_V(ntryL,G0H32(61),ex3(:),G0H16(31),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_SV_V(ntryL,G1H32(76),ex3(:),G1H16(61),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_UW_V(ntryL,G0H32(62),32,ex3(:),4,G1H16(62),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_VV_S(ntryL,G1H32(77),ex3(:),G1H16(63),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_UW_V(ntryL,G1H32(78),32,ex3(:),4,G2H16(46),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_SV_V(ntryL,G0H32(63),ex3(:),G0H16(32),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_UW_V(ntryL,G1H32(79),32,ex3(:),4,G2H16(47),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_UW_V(ntryL,G0H32(64),32,ex3(:),4,G1H16(64),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_UW_V(ntryL,G1H32(80),32,ex3(:),4,G2H16(48),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_QA_S(ntryL,G1H32(81),ex2(:),G1H16(65),ngH,m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_QA_S(ntryL,G1H32(82),ex2(:),G1H16(66),ngX,m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_SA_Q(ntryL,G1H32(83),ex2(:),G1H16(67),ngPln,m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H16(67),34,0,G2H16(49),n2h16(17))
  call Hloop_QA_V(ntryL,G1H32(84),ex2(:),G1H16(67),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_QA_Z(ntryL,G1H32(85),ex2(:),G1H16(68),ngZl,m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_SA_Q(ntryL,G0H32(65),ex2(:),G0H16(33),ngPln,m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(69),n2h16(18))
  call Hloop_SA_Q(ntryL,G1H32(86),ex2(:),G1H16(70),ngPln,m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_A_Q(ntryL,G1H16(70),34,0,G2H16(50),n2h16(19))
  call Hloop_SA_Q(ntryL,G1H32(87),ex2(:),G1H16(70),ngPln,m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G1H16(70),34,0,G2H16(51),n2h16(20))
  call Hloop_WA_Q(ntryL,G0H32(66),ex2(:),G0H16(33),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(70),n2h16(21))
  call Hloop_SA_Q(ntryL,G1H32(88),ex2(:),G1H16(71),ngPln,m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G1H16(71),34,0,G2H16(52),n2h16(22))
  call Hloop_SA_Q(ntryL,G0H32(67),ex2(:),G0H16(33),ngPln,m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(71),n2h16(23))
  call Hloop_SA_Q(ntryL,G0H32(68),ex2(:),G0H16(33),ngPln,m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(72),n2h16(24))
  call Hloop_SA_Q(ntryL,G1H32(89),ex2(:),G1H16(73),ngPln,m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(53),n2h16(25))
  call Hloop_WA_Q(ntryL,G1H32(90),ex2(:),G1H16(73),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H16(73),34,0,G2H16(54),n2h16(26))
  call Hloop_WA_Q(ntryL,G0H32(69),ex2(:),G0H16(33),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(73),n2h16(27))
  call Hloop_WA_Q(ntryL,G0H32(70),ex2(:),G0H16(33),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(74),n2h16(28))
  call Hloop_SA_Q(ntryL,G0H32(71),ex2(:),G0H16(33),ngPln,m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(75),n2h16(29))
  call Hloop_SA_Q(ntryL,G1H32(91),ex2(:),G1H16(76),ngPln,m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G1H16(76),34,0,G2H16(55),n2h16(30))
  call Hloop_SA_Q(ntryL,G1H32(92),ex2(:),G1H16(76),ngPln,m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G1H16(76),34,0,G2H16(56),n2h16(31))
  call Hloop_WA_Q(ntryL,G0H32(72),ex2(:),G0H16(33),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(76),n2h16(32))
  call Hloop_SA_Q(ntryL,G0H32(73),ex2(:),G0H16(33),ngPln,m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(77),n2h16(33))
  call Hloop_WA_Q(ntryL,G1H32(93),ex2(:),G1H16(78),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G1H16(78),34,0,G2H16(57),n2h16(34))
  call Hloop_WA_Q(ntryL,G1H32(94),ex2(:),G1H16(78),m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G1H16(78),34,0,G2H16(58),n2h16(35))
  call Hloop_WA_Q(ntryL,G0H32(74),ex2(:),G0H16(33),m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(78),n2h16(36))
  call Hloop_SA_Q(ntryL,G0H32(75),ex2(:),G0H16(33),ngPln,m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(79),n2h16(37))
  call Hloop_SA_Q(ntryL,G0H32(76),ex2(:),G0H16(33),ngPln,m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(80),n2h16(38))
  call Hloop_SA_Q(ntryL,G1H32(95),ex2(:),G1H16(81),ngPln,m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G1H16(81),34,0,G2H16(59),n2h16(39))
  call Hloop_WA_Q(ntryL,G1H32(96),ex2(:),G1H16(81),m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H16(81),34,0,G2H16(60),n2h16(40))
  call Hloop_WA_Q(ntryL,G0H32(77),ex2(:),G0H16(33),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(81),n2h16(41))
  call Hloop_WA_Q(ntryL,G0H32(78),ex2(:),G0H16(33),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(82),n2h16(42))
  call Hloop_WA_Q(ntryL,G1H32(97),ex2(:),G1H16(83),m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G1H16(83),34,0,G2H16(61),n2h16(43))
  call Hloop_SA_Q(ntryL,G0H32(79),ex2(:),G0H16(33),ngPln,m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(83),n2h16(44))
  call Hloop_WA_Q(ntryL,G1H32(98),ex2(:),G1H16(84),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G1H16(84),34,0,G2H16(62),n2h16(45))
  call Hloop_WA_Q(ntryL,G1H32(99),ex2(:),G1H16(84),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G1H16(84),34,0,G2H16(63),n2h16(46))
  call Hloop_WA_Q(ntryL,G0H32(80),ex2(:),G0H16(33),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(84),n2h16(47))
  call Hloop_WA_Q(ntryL,G1H32(100),ex2(:),G1H16(85),m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G1H16(85),34,0,G2H16(64),n2h16(48))
  call Hloop_QA_S(ntryL,G1H32(101),ex2(:),G1H16(85),ngH,m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_QA_S(ntryL,G1H32(102),ex2(:),G1H16(86),ngX,m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_SA_Q(ntryL,G1H32(103),ex2(:),G1H16(87),ngPln,m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H16(87),34,0,G2H16(65),n2h16(49))
  call Hloop_QA_V(ntryL,G1H32(104),ex2(:),G1H16(87),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_QA_Z(ntryL,G1H32(105),ex2(:),G1H16(88),ngZl,m3h2x16(:,185),heltab2x32(:,:,185))
  call Hloop_SA_Q(ntryL,G0H32(81),ex2(:),G0H16(33),ngPln,m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(89),n2h16(50))
  call Hloop_SA_Q(ntryL,G1H32(106),ex2(:),G1H16(90),ngPln,m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G1H16(90),34,0,G2H16(66),n2h16(51))
  call Hloop_SA_Q(ntryL,G1H32(107),ex2(:),G1H16(90),ngPln,m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G1H16(90),34,0,G2H16(67),n2h16(52))
  call Hloop_WA_Q(ntryL,G0H32(82),ex2(:),G0H16(33),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(90),n2h16(53))
  call Hloop_SA_Q(ntryL,G1H32(108),ex2(:),G1H16(91),ngPln,m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G1H16(91),34,0,G2H16(68),n2h16(54))
  call Hloop_SA_Q(ntryL,G0H32(83),ex2(:),G0H16(33),ngPln,m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(91),n2h16(55))
  call Hloop_SA_Q(ntryL,G0H32(84),ex2(:),G0H16(33),ngPln,m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(92),n2h16(56))
  call Hloop_SA_Q(ntryL,G1H32(109),ex2(:),G1H16(93),ngPln,m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H16(93),34,0,G2H16(69),n2h16(57))
  call Hloop_WA_Q(ntryL,G1H32(110),ex2(:),G1H16(93),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G1H16(93),34,0,G2H16(70),n2h16(58))
  call Hloop_WA_Q(ntryL,G0H32(85),ex2(:),G0H16(33),m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(93),n2h16(59))
  call Hloop_WA_Q(ntryL,G0H32(86),ex2(:),G0H16(33),m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(94),n2h16(60))
  call Hloop_SA_Q(ntryL,G0H32(87),ex2(:),G0H16(33),ngPln,m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(95),n2h16(61))
  call Hloop_SA_Q(ntryL,G1H32(111),ex2(:),G1H16(96),ngPln,m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G1H16(96),34,0,G2H16(71),n2h16(62))
  call Hloop_SA_Q(ntryL,G1H32(112),ex2(:),G1H16(96),ngPln,m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G1H16(96),34,0,G2H16(72),n2h16(63))
  call Hloop_WA_Q(ntryL,G0H32(88),ex2(:),G0H16(33),m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(96),n2h16(64))
  call Hloop_SA_Q(ntryL,G0H32(89),ex2(:),G0H16(33),ngPln,m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(97),n2h16(65))
  call Hloop_WA_Q(ntryL,G1H32(113),ex2(:),G1H16(98),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(98),34,0,G2H16(73),n2h16(66))
  call Hloop_WA_Q(ntryL,G1H32(114),ex2(:),G1H16(98),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H16(98),34,0,G2H16(74),n2h16(67))
  call Hloop_WA_Q(ntryL,G0H32(90),ex2(:),G0H16(33),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(98),n2h16(68))
  call Hloop_SA_Q(ntryL,G0H32(91),ex2(:),G0H16(33),ngPln,m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(99),n2h16(69))
  call Hloop_SA_Q(ntryL,G0H32(92),ex2(:),G0H16(33),ngPln,m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(100),n2h16(70))
  call Hloop_SA_Q(ntryL,G1H32(115),ex2(:),G1H16(101),ngPln,m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G1H16(101),34,0,G2H16(75),n2h16(71))
  call Hloop_WA_Q(ntryL,G1H32(116),ex2(:),G1H16(101),m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G1H16(101),34,0,G2H16(76),n2h16(72))
  call Hloop_WA_Q(ntryL,G0H32(93),ex2(:),G0H16(33),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(101),n2h16(73))
  call Hloop_WA_Q(ntryL,G0H32(94),ex2(:),G0H16(33),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(102),n2h16(74))
  call Hloop_WA_Q(ntryL,G1H32(117),ex2(:),G1H16(103),m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H16(103),34,0,G2H16(77),n2h16(75))
  call Hloop_SA_Q(ntryL,G0H32(95),ex2(:),G0H16(33),ngPln,m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(103),n2h16(76))
  call Hloop_WA_Q(ntryL,G1H32(118),ex2(:),G1H16(104),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(104),34,0,G2H16(78),n2h16(77))
  call Hloop_WA_Q(ntryL,G1H32(119),ex2(:),G1H16(104),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G1H16(104),34,0,G2H16(79),n2h16(78))
  call Hloop_WA_Q(ntryL,G0H32(96),ex2(:),G0H16(33),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H16(33),34,0,G1H16(104),n2h16(79))
  call Hloop_WA_Q(ntryL,G1H32(120),ex2(:),G1H16(105),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G1H16(105),34,0,G2H16(80),n2h16(80))
  call Hloop_AV_Q(ntryL,G1H32(121),ex4(:),G1H16(105),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G1H16(105),40,nME,G2H16(81),n2h16(81))
  call Hloop_AV_Q(ntryL,G1H32(122),ex4(:),G1H16(105),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G1H16(105),40,nME,G2H16(82),n2h16(82))
  call Hloop_SV_T(ntryL,G1H32(123),32,ex4(:),8,G2H16(83),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_AV_Q(ntryL,G1H32(124),ex4(:),G1H16(105),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G1H16(105),40,nME,G2H16(84),n2h16(83))
  call Hloop_AV_Q(ntryL,G1H32(125),ex4(:),G1H16(105),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G1H16(105),40,nME,G2H16(85),n2h16(84))
  call Hloop_SV_T(ntryL,G0H32(97),32,ex4(:),8,G1H16(105),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_VV_S(ntryL,G0H32(98),ex4(:),G0H16(33),m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_SV_T(ntryL,G1H32(126),32,ex4(:),8,G2H16(86),m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_SV_T(ntryL,G1H32(127),32,ex4(:),8,G2H16(87),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_SV_V(ntryL,G1H32(128),ex4(:),G1H16(106),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_VV_S(ntryL,G1H32(129),ex4(:),G1H16(107),m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_SV_T(ntryL,G0H32(99),32,ex4(:),8,G1H16(108),m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_VV_S(ntryL,G0H32(100),ex4(:),G0H16(34),m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_SV_T(ntryL,G0H32(101),32,ex4(:),8,G1H16(109),m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_VV_S(ntryL,G0H32(102),ex4(:),G0H16(35),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_SV_T(ntryL,G1H32(130),32,ex4(:),8,G2H16(88),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_SV_V(ntryL,G0H32(103),ex4(:),G0H16(36),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_UW_V(ntryL,G0H32(104),32,ex4(:),8,G1H16(110),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_SV_V(ntryL,G1H32(131),ex4(:),G1H16(111),m3h2x16(:,235),heltab2x32(:,:,235))
  call Hloop_SV_V(ntryL,G1H32(132),ex4(:),G1H16(112),m3h2x16(:,236),heltab2x32(:,:,236))
  call Hloop_VV_S(ntryL,G1H32(133),ex4(:),G1H16(113),m3h2x16(:,237),heltab2x32(:,:,237))
  call Hloop_VV_S(ntryL,G1H32(134),ex4(:),G1H16(114),m3h2x16(:,238),heltab2x32(:,:,238))
  call Hloop_SV_T(ntryL,G0H32(105),32,ex4(:),8,G1H16(115),m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_VV_S(ntryL,G0H32(106),ex4(:),G0H16(37),m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_UW_V(ntryL,G1H32(135),32,ex4(:),8,G2H16(89),m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_SV_V(ntryL,G0H32(107),ex4(:),G0H16(38),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_UW_V(ntryL,G0H32(108),32,ex4(:),8,G1H16(116),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_SV_V(ntryL,G0H32(109),ex4(:),G0H16(39),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_UW_V(ntryL,G0H32(110),32,ex4(:),8,G1H16(117),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_SV_V(ntryL,G1H32(136),ex4(:),G1H16(118),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_VV_S(ntryL,G1H32(137),ex4(:),G1H16(119),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_UW_V(ntryL,G1H32(138),32,ex4(:),8,G2H16(90),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_UW_V(ntryL,G1H32(139),32,ex4(:),8,G2H16(91),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_SV_V(ntryL,G0H32(111),ex4(:),G0H16(40),m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_UW_V(ntryL,G0H32(112),32,ex4(:),8,G1H16(120),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_UW_V(ntryL,G1H32(140),32,ex4(:),8,G2H16(92),m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_QV_A(ntryL,G1H32(141),ex3(:),G1H16(121),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G1H16(121),36,nME,G2H16(93),n2h16(85))
  call Hloop_QV_A(ntryL,G1H32(142),ex3(:),G1H16(121),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G1H16(121),36,nME,G2H16(94),n2h16(86))
  call Hloop_TV_S(ntryL,G1H32(143),32,ex3(:),4,G2H16(95),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_QV_A(ntryL,G1H32(144),ex3(:),G1H16(121),m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G1H16(121),36,nME,G2H16(96),n2h16(87))
  call Hloop_QV_A(ntryL,G1H32(145),ex3(:),G1H16(121),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G1H16(121),36,nME,G2H16(97),n2h16(88))
  call Hloop_TV_S(ntryL,G0H32(113),32,ex3(:),4,G1H16(121),m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_TV_S(ntryL,G1H32(146),32,ex3(:),4,G2H16(98),m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_VV_S(ntryL,G0H32(114),ex3(:),G0H16(41),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_SV_V(ntryL,G1H32(147),ex3(:),G1H16(122),m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_TV_S(ntryL,G1H32(148),32,ex3(:),4,G2H16(99),m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_TV_S(ntryL,G0H32(115),32,ex3(:),4,G1H16(123),m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_VV_S(ntryL,G1H32(149),ex3(:),G1H16(124),m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_VV_S(ntryL,G0H32(116),ex3(:),G0H16(42),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_SV_V(ntryL,G0H32(117),ex3(:),G0H16(43),m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_SV_V(ntryL,G1H32(150),ex3(:),G1H16(125),m3h2x16(:,267),heltab2x32(:,:,267))
  call Hloop_UV_W(ntryL,G0H32(118),32,ex3(:),4,G1H16(126),m3h2x16(:,268),heltab2x32(:,:,268))
  call Hloop_TV_S(ntryL,G0H32(119),32,ex3(:),4,G1H16(127),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_TV_S(ntryL,G1H32(151),32,ex3(:),4,G2H16(100),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_VV_S(ntryL,G0H32(120),ex3(:),G0H16(44),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_SV_V(ntryL,G1H32(152),ex3(:),G1H16(128),m3h2x16(:,272),heltab2x32(:,:,272))
  call Hloop_VV_S(ntryL,G1H32(153),ex3(:),G1H16(129),m3h2x16(:,273),heltab2x32(:,:,273))
  call Hloop_SV_V(ntryL,G0H32(121),ex3(:),G0H16(45),m3h2x16(:,274),heltab2x32(:,:,274))
  call Hloop_UV_W(ntryL,G1H32(154),32,ex3(:),4,G2H16(101),m3h2x16(:,275),heltab2x32(:,:,275))
  call Hloop_UV_W(ntryL,G0H32(122),32,ex3(:),4,G1H16(130),m3h2x16(:,276),heltab2x32(:,:,276))
  call Hloop_TV_S(ntryL,G0H32(123),32,ex3(:),4,G1H16(131),m3h2x16(:,277),heltab2x32(:,:,277))
  call Hloop_VV_S(ntryL,G1H32(155),ex3(:),G1H16(132),m3h2x16(:,278),heltab2x32(:,:,278))
  call Hloop_VV_S(ntryL,G0H32(124),ex3(:),G0H16(46),m3h2x16(:,279),heltab2x32(:,:,279))
  call Hloop_SV_V(ntryL,G0H32(125),ex3(:),G0H16(47),m3h2x16(:,280),heltab2x32(:,:,280))
  call Hloop_SV_V(ntryL,G1H32(156),ex3(:),G1H16(133),m3h2x16(:,281),heltab2x32(:,:,281))
  call Hloop_UV_W(ntryL,G0H32(126),32,ex3(:),4,G1H16(134),m3h2x16(:,282),heltab2x32(:,:,282))
  call Hloop_UV_W(ntryL,G1H32(157),32,ex3(:),4,G2H16(102),m3h2x16(:,283),heltab2x32(:,:,283))
  call Hloop_VV_S(ntryL,G1H32(158),ex3(:),G1H16(135),m3h2x16(:,284),heltab2x32(:,:,284))
  call Hloop_SV_V(ntryL,G0H32(127),ex3(:),G0H16(48),m3h2x16(:,285),heltab2x32(:,:,285))
  call Hloop_UV_W(ntryL,G1H32(159),32,ex3(:),4,G2H16(103),m3h2x16(:,286),heltab2x32(:,:,286))
  call Hloop_UV_W(ntryL,G0H32(128),32,ex3(:),4,G1H16(136),m3h2x16(:,287),heltab2x32(:,:,287))
  call Hloop_UV_W(ntryL,G1H32(160),32,ex3(:),4,G2H16(104),m3h2x16(:,288),heltab2x32(:,:,288))
  call Hloop_AV_Q(ntryL,G1H32(161),ex3(:),G1H16(137),m3h2x16(:,289),heltab2x32(:,:,289))
  call Hloop_A_Q(ntryL,G1H16(137),36,nME,G2H16(105),n2h16(89))
  call Hloop_AV_Q(ntryL,G1H32(162),ex3(:),G1H16(137),m3h2x16(:,290),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G1H16(137),36,nME,G2H16(106),n2h16(90))
  call Hloop_SV_T(ntryL,G1H32(163),32,ex3(:),4,G2H16(107),m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_AV_Q(ntryL,G1H32(164),ex3(:),G1H16(137),m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_A_Q(ntryL,G1H16(137),36,nME,G2H16(108),n2h16(91))
  call Hloop_AV_Q(ntryL,G1H32(165),ex3(:),G1H16(137),m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G1H16(137),36,nME,G2H16(109),n2h16(92))
  call Hloop_SV_T(ntryL,G0H32(129),32,ex3(:),4,G1H16(137),m3h2x16(:,294),heltab2x32(:,:,294))
  call Hloop_VV_S(ntryL,G0H32(130),ex3(:),G0H16(49),m3h2x16(:,295),heltab2x32(:,:,295))
  call Hloop_SV_V(ntryL,G1H32(166),ex3(:),G1H16(138),m3h2x16(:,296),heltab2x32(:,:,296))
  call Hloop_SV_T(ntryL,G1H32(167),32,ex3(:),4,G2H16(110),m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_SV_T(ntryL,G1H32(168),32,ex3(:),4,G2H16(111),m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_VV_S(ntryL,G1H32(169),ex3(:),G1H16(139),m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_SV_V(ntryL,G0H32(131),ex3(:),G0H16(50),m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_UW_V(ntryL,G0H32(132),32,ex3(:),4,G1H16(140),m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_SV_T(ntryL,G0H32(133),32,ex3(:),4,G1H16(141),m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_VV_S(ntryL,G0H32(134),ex3(:),G0H16(51),m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_SV_V(ntryL,G1H32(170),ex3(:),G1H16(142),m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_SV_T(ntryL,G0H32(135),32,ex3(:),4,G1H16(143),m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_VV_S(ntryL,G0H32(136),ex3(:),G0H16(52),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_SV_V(ntryL,G1H32(171),ex3(:),G1H16(144),m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_SV_T(ntryL,G1H32(172),32,ex3(:),4,G2H16(112),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_UW_V(ntryL,G1H32(173),32,ex3(:),4,G2H16(113),m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_VV_S(ntryL,G1H32(174),ex3(:),G1H16(145),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_SV_V(ntryL,G0H32(137),ex3(:),G0H16(53),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_UW_V(ntryL,G0H32(138),32,ex3(:),4,G1H16(146),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_VV_S(ntryL,G1H32(175),ex3(:),G1H16(147),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_SV_V(ntryL,G0H32(139),ex3(:),G0H16(54),m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_UW_V(ntryL,G0H32(140),32,ex3(:),4,G1H16(148),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_SV_T(ntryL,G0H32(141),32,ex3(:),4,G1H16(149),m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_VV_S(ntryL,G0H32(142),ex3(:),G0H16(55),m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_SV_V(ntryL,G1H32(176),ex3(:),G1H16(150),m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_UW_V(ntryL,G1H32(177),32,ex3(:),4,G2H16(114),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_UW_V(ntryL,G1H32(178),32,ex3(:),4,G2H16(115),m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_VV_S(ntryL,G1H32(179),ex3(:),G1H16(151),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_SV_V(ntryL,G0H32(143),ex3(:),G0H16(56),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_UW_V(ntryL,G0H32(144),32,ex3(:),4,G1H16(152),m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_UW_V(ntryL,G1H32(180),32,ex3(:),4,G2H16(116),m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_QV_A(ntryL,G1H32(181),ex3(:),G1H16(153),m3h2x16(:,325),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G1H16(153),36,nME,G2H16(117),n2h16(93))
  call Hloop_QV_A(ntryL,G1H32(182),ex3(:),G1H16(153),m3h2x16(:,326),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G1H16(153),36,nME,G2H16(118),n2h16(94))
  call Hloop_TV_S(ntryL,G1H32(183),32,ex3(:),4,G2H16(119),m3h2x16(:,327),heltab2x32(:,:,327))
  call Hloop_QV_A(ntryL,G1H32(184),ex3(:),G1H16(153),m3h2x16(:,328),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G1H16(153),36,nME,G2H16(120),n2h16(95))
  call Hloop_QV_A(ntryL,G1H32(185),ex3(:),G1H16(153),m3h2x16(:,329),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G1H16(153),36,nME,G2H16(121),n2h16(96))
  call Hloop_TV_S(ntryL,G0H32(145),32,ex3(:),4,G1H16(153),m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_VV_S(ntryL,G0H32(146),ex3(:),G0H16(57),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_SV_V(ntryL,G1H32(186),ex3(:),G1H16(154),m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_TV_S(ntryL,G1H32(187),32,ex3(:),4,G2H16(122),m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_TV_S(ntryL,G1H32(188),32,ex3(:),4,G2H16(123),m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_VV_S(ntryL,G1H32(189),ex3(:),G1H16(155),m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_SV_V(ntryL,G0H32(147),ex3(:),G0H16(58),m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_UV_W(ntryL,G0H32(148),32,ex3(:),4,G1H16(156),m3h2x16(:,337),heltab2x32(:,:,337))
  call Hloop_TV_S(ntryL,G0H32(149),32,ex3(:),4,G1H16(157),m3h2x16(:,338),heltab2x32(:,:,338))
  call Hloop_VV_S(ntryL,G0H32(150),ex3(:),G0H16(59),m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_SV_V(ntryL,G1H32(190),ex3(:),G1H16(158),m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_TV_S(ntryL,G0H32(151),32,ex3(:),4,G1H16(159),m3h2x16(:,341),heltab2x32(:,:,341))
  call Hloop_VV_S(ntryL,G0H32(152),ex3(:),G0H16(60),m3h2x16(:,342),heltab2x32(:,:,342))
  call Hloop_SV_V(ntryL,G1H32(191),ex3(:),G1H16(160),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_TV_S(ntryL,G1H32(192),32,ex3(:),4,G2H16(124),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_UV_W(ntryL,G1H32(193),32,ex3(:),4,G2H16(125),m3h2x16(:,345),heltab2x32(:,:,345))
  call Hloop_VV_S(ntryL,G1H32(194),ex3(:),G1H16(161),m3h2x16(:,346),heltab2x32(:,:,346))
  call Hloop_SV_V(ntryL,G0H32(153),ex3(:),G0H16(61),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_UV_W(ntryL,G0H32(154),32,ex3(:),4,G1H16(162),m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_VV_S(ntryL,G1H32(195),ex3(:),G1H16(163),m3h2x16(:,349),heltab2x32(:,:,349))
  call Hloop_SV_V(ntryL,G0H32(155),ex3(:),G0H16(62),m3h2x16(:,350),heltab2x32(:,:,350))
  call Hloop_UV_W(ntryL,G0H32(156),32,ex3(:),4,G1H16(164),m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_TV_S(ntryL,G0H32(157),32,ex3(:),4,G1H16(165),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_VV_S(ntryL,G0H32(158),ex3(:),G0H16(63),m3h2x16(:,353),heltab2x32(:,:,353))
  call Hloop_SV_V(ntryL,G1H32(196),ex3(:),G1H16(166),m3h2x16(:,354),heltab2x32(:,:,354))
  call Hloop_UV_W(ntryL,G1H32(197),32,ex3(:),4,G2H16(126),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_UV_W(ntryL,G1H32(198),32,ex3(:),4,G2H16(127),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_VV_S(ntryL,G1H32(199),ex3(:),G1H16(167),m3h2x16(:,357),heltab2x32(:,:,357))
  call Hloop_SV_V(ntryL,G0H32(159),ex3(:),G0H16(64),m3h2x16(:,358),heltab2x32(:,:,358))
  call Hloop_UV_W(ntryL,G0H32(160),32,ex3(:),4,G1H16(168),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_UV_W(ntryL,G1H32(200),32,ex3(:),4,G2H16(128),m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_QA_S(ntryL,G1H32(201),ex2(:),G1H16(169),ngH,m3h2x16(:,361),heltab2x32(:,:,361))
  call Hloop_QA_S(ntryL,G1H32(202),ex2(:),G1H16(170),ngX,m3h2x16(:,362),heltab2x32(:,:,362))
  call Hloop_SA_Q(ntryL,G1H32(203),ex2(:),G1H16(171),ngPln,m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G1H16(171),34,0,G2H16(129),n2h16(97))
  call Hloop_QA_V(ntryL,G1H32(204),ex2(:),G1H16(171),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_QA_Z(ntryL,G1H32(205),ex2(:),G1H16(172),ngZl,m3h2x16(:,365),heltab2x32(:,:,365))
  call Hloop_SA_Q(ntryL,G0H32(161),ex2(:),G0H16(65),ngPln,m3h2x16(:,366),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(173),n2h16(98))
  call Hloop_SA_Q(ntryL,G1H32(206),ex2(:),G1H16(174),ngPln,m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G1H16(174),34,0,G2H16(130),n2h16(99))
  call Hloop_SA_Q(ntryL,G1H32(207),ex2(:),G1H16(174),ngPln,m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G1H16(174),34,0,G2H16(131),n2h16(100))
  call Hloop_WA_Q(ntryL,G0H32(162),ex2(:),G0H16(65),m3h2x16(:,369),heltab2x32(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(174),n2h16(101))
  call Hloop_SA_Q(ntryL,G1H32(208),ex2(:),G1H16(175),ngPln,m3h2x16(:,370),heltab2x32(:,:,370))
  call Hloop_A_Q(ntryL,G1H16(175),34,0,G2H16(132),n2h16(102))
  call Hloop_SA_Q(ntryL,G0H32(163),ex2(:),G0H16(65),ngPln,m3h2x16(:,371),heltab2x32(:,:,371))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(175),n2h16(103))
  call Hloop_SA_Q(ntryL,G0H32(164),ex2(:),G0H16(65),ngPln,m3h2x16(:,372),heltab2x32(:,:,372))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(176),n2h16(104))
  call Hloop_SA_Q(ntryL,G1H32(209),ex2(:),G1H16(177),ngPln,m3h2x16(:,373),heltab2x32(:,:,373))
  call Hloop_A_Q(ntryL,G1H16(177),34,0,G2H16(133),n2h16(105))
  call Hloop_WA_Q(ntryL,G1H32(210),ex2(:),G1H16(177),m3h2x16(:,374),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G1H16(177),34,0,G2H16(134),n2h16(106))
  call Hloop_WA_Q(ntryL,G0H32(165),ex2(:),G0H16(65),m3h2x16(:,375),heltab2x32(:,:,375))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(177),n2h16(107))
  call Hloop_WA_Q(ntryL,G0H32(166),ex2(:),G0H16(65),m3h2x16(:,376),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(178),n2h16(108))
  call Hloop_SA_Q(ntryL,G0H32(167),ex2(:),G0H16(65),ngPln,m3h2x16(:,377),heltab2x32(:,:,377))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(179),n2h16(109))
  call Hloop_SA_Q(ntryL,G1H32(211),ex2(:),G1H16(180),ngPln,m3h2x16(:,378),heltab2x32(:,:,378))
  call Hloop_A_Q(ntryL,G1H16(180),34,0,G2H16(135),n2h16(110))
  call Hloop_SA_Q(ntryL,G1H32(212),ex2(:),G1H16(180),ngPln,m3h2x16(:,379),heltab2x32(:,:,379))
  call Hloop_A_Q(ntryL,G1H16(180),34,0,G2H16(136),n2h16(111))
  call Hloop_WA_Q(ntryL,G0H32(168),ex2(:),G0H16(65),m3h2x16(:,380),heltab2x32(:,:,380))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(180),n2h16(112))
  call Hloop_SA_Q(ntryL,G0H32(169),ex2(:),G0H16(65),ngPln,m3h2x16(:,381),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(181),n2h16(113))
  call Hloop_WA_Q(ntryL,G1H32(213),ex2(:),G1H16(182),m3h2x16(:,382),heltab2x32(:,:,382))
  call Hloop_A_Q(ntryL,G1H16(182),34,0,G2H16(137),n2h16(114))
  call Hloop_WA_Q(ntryL,G1H32(214),ex2(:),G1H16(182),m3h2x16(:,383),heltab2x32(:,:,383))
  call Hloop_A_Q(ntryL,G1H16(182),34,0,G2H16(138),n2h16(115))
  call Hloop_WA_Q(ntryL,G0H32(170),ex2(:),G0H16(65),m3h2x16(:,384),heltab2x32(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(182),n2h16(116))
  call Hloop_SA_Q(ntryL,G0H32(171),ex2(:),G0H16(65),ngPln,m3h2x16(:,385),heltab2x32(:,:,385))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(183),n2h16(117))
  call Hloop_SA_Q(ntryL,G0H32(172),ex2(:),G0H16(65),ngPln,m3h2x16(:,386),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(184),n2h16(118))
  call Hloop_SA_Q(ntryL,G1H32(215),ex2(:),G1H16(185),ngPln,m3h2x16(:,387),heltab2x32(:,:,387))
  call Hloop_A_Q(ntryL,G1H16(185),34,0,G2H16(139),n2h16(119))
  call Hloop_WA_Q(ntryL,G1H32(216),ex2(:),G1H16(185),m3h2x16(:,388),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G1H16(185),34,0,G2H16(140),n2h16(120))
  call Hloop_WA_Q(ntryL,G0H32(173),ex2(:),G0H16(65),m3h2x16(:,389),heltab2x32(:,:,389))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(185),n2h16(121))
  call Hloop_WA_Q(ntryL,G0H32(174),ex2(:),G0H16(65),m3h2x16(:,390),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(186),n2h16(122))
  call Hloop_WA_Q(ntryL,G1H32(217),ex2(:),G1H16(187),m3h2x16(:,391),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G1H16(187),34,0,G2H16(141),n2h16(123))
  call Hloop_SA_Q(ntryL,G0H32(175),ex2(:),G0H16(65),ngPln,m3h2x16(:,392),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(187),n2h16(124))
  call Hloop_WA_Q(ntryL,G1H32(218),ex2(:),G1H16(188),m3h2x16(:,393),heltab2x32(:,:,393))
  call Hloop_A_Q(ntryL,G1H16(188),34,0,G2H16(142),n2h16(125))
  call Hloop_WA_Q(ntryL,G1H32(219),ex2(:),G1H16(188),m3h2x16(:,394),heltab2x32(:,:,394))
  call Hloop_A_Q(ntryL,G1H16(188),34,0,G2H16(143),n2h16(126))
  call Hloop_WA_Q(ntryL,G0H32(176),ex2(:),G0H16(65),m3h2x16(:,395),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(188),n2h16(127))
  call Hloop_WA_Q(ntryL,G1H32(220),ex2(:),G1H16(189),m3h2x16(:,396),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G1H16(189),34,0,G2H16(144),n2h16(128))
  call Hloop_QA_S(ntryL,G1H32(221),ex2(:),G1H16(189),ngH,m3h2x16(:,397),heltab2x32(:,:,397))
  call Hloop_QA_S(ntryL,G1H32(222),ex2(:),G1H16(190),ngX,m3h2x16(:,398),heltab2x32(:,:,398))
  call Hloop_SA_Q(ntryL,G1H32(223),ex2(:),G1H16(191),ngPln,m3h2x16(:,399),heltab2x32(:,:,399))
  call Hloop_A_Q(ntryL,G1H16(191),34,0,G2H16(145),n2h16(129))
  call Hloop_QA_V(ntryL,G1H32(224),ex2(:),G1H16(191),m3h2x16(:,400),heltab2x32(:,:,400))
  call Hloop_QA_Z(ntryL,G1H32(225),ex2(:),G1H16(192),ngZl,m3h2x16(:,401),heltab2x32(:,:,401))
  call Hloop_SA_Q(ntryL,G1H32(226),ex2(:),G1H16(193),ngPln,m3h2x16(:,402),heltab2x32(:,:,402))
  call Hloop_A_Q(ntryL,G1H16(193),34,0,G2H16(146),n2h16(130))
  call Hloop_SA_Q(ntryL,G0H32(177),ex2(:),G0H16(65),ngPln,m3h2x16(:,403),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(193),n2h16(131))
  call Hloop_SA_Q(ntryL,G1H32(227),ex2(:),G1H16(194),ngPln,m3h2x16(:,404),heltab2x32(:,:,404))
  call Hloop_A_Q(ntryL,G1H16(194),34,0,G2H16(147),n2h16(132))
  call Hloop_WA_Q(ntryL,G0H32(178),ex2(:),G0H16(65),m3h2x16(:,405),heltab2x32(:,:,405))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(194),n2h16(133))
  call Hloop_SA_Q(ntryL,G1H32(228),ex2(:),G1H16(195),ngPln,m3h2x16(:,406),heltab2x32(:,:,406))
  call Hloop_A_Q(ntryL,G1H16(195),34,0,G2H16(148),n2h16(134))
  call Hloop_SA_Q(ntryL,G0H32(179),ex2(:),G0H16(65),ngPln,m3h2x16(:,407),heltab2x32(:,:,407))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(195),n2h16(135))
  call Hloop_SA_Q(ntryL,G1H32(229),ex2(:),G1H16(196),ngPln,m3h2x16(:,408),heltab2x32(:,:,408))
  call Hloop_A_Q(ntryL,G1H16(196),34,0,G2H16(149),n2h16(136))
  call Hloop_SA_Q(ntryL,G0H32(180),ex2(:),G0H16(65),ngPln,m3h2x16(:,409),heltab2x32(:,:,409))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(196),n2h16(137))
  call Hloop_WA_Q(ntryL,G0H32(181),ex2(:),G0H16(65),m3h2x16(:,410),heltab2x32(:,:,410))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(197),n2h16(138))
  call Hloop_WA_Q(ntryL,G1H32(230),ex2(:),G1H16(198),m3h2x16(:,411),heltab2x32(:,:,411))
  call Hloop_A_Q(ntryL,G1H16(198),34,0,G2H16(150),n2h16(139))
  call Hloop_WA_Q(ntryL,G0H32(182),ex2(:),G0H16(65),m3h2x16(:,412),heltab2x32(:,:,412))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(198),n2h16(140))
  call Hloop_SA_Q(ntryL,G1H32(231),ex2(:),G1H16(199),ngPln,m3h2x16(:,413),heltab2x32(:,:,413))
  call Hloop_A_Q(ntryL,G1H16(199),34,0,G2H16(151),n2h16(141))
  call Hloop_SA_Q(ntryL,G0H32(183),ex2(:),G0H16(65),ngPln,m3h2x16(:,414),heltab2x32(:,:,414))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(199),n2h16(142))
  call Hloop_SA_Q(ntryL,G1H32(232),ex2(:),G1H16(200),ngPln,m3h2x16(:,415),heltab2x32(:,:,415))
  call Hloop_A_Q(ntryL,G1H16(200),34,0,G2H16(152),n2h16(143))
  call Hloop_WA_Q(ntryL,G0H32(184),ex2(:),G0H16(65),m3h2x16(:,416),heltab2x32(:,:,416))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(200),n2h16(144))
  call Hloop_SA_Q(ntryL,G0H32(185),ex2(:),G0H16(65),ngPln,m3h2x16(:,417),heltab2x32(:,:,417))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(201),n2h16(145))
  call Hloop_WA_Q(ntryL,G1H32(233),ex2(:),G1H16(202),m3h2x16(:,418),heltab2x32(:,:,418))
  call Hloop_A_Q(ntryL,G1H16(202),34,0,G2H16(153),n2h16(146))
  call Hloop_WA_Q(ntryL,G0H32(186),ex2(:),G0H16(65),m3h2x16(:,419),heltab2x32(:,:,419))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(202),n2h16(147))
  call Hloop_WA_Q(ntryL,G1H32(234),ex2(:),G1H16(203),m3h2x16(:,420),heltab2x32(:,:,420))
  call Hloop_A_Q(ntryL,G1H16(203),34,0,G2H16(154),n2h16(148))
  call Hloop_SA_Q(ntryL,G0H32(187),ex2(:),G0H16(65),ngPln,m3h2x16(:,421),heltab2x32(:,:,421))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(203),n2h16(149))
  call Hloop_SA_Q(ntryL,G1H32(235),ex2(:),G1H16(204),ngPln,m3h2x16(:,422),heltab2x32(:,:,422))
  call Hloop_A_Q(ntryL,G1H16(204),34,0,G2H16(155),n2h16(150))
  call Hloop_SA_Q(ntryL,G0H32(188),ex2(:),G0H16(65),ngPln,m3h2x16(:,423),heltab2x32(:,:,423))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(204),n2h16(151))
  call Hloop_WA_Q(ntryL,G0H32(189),ex2(:),G0H16(65),m3h2x16(:,424),heltab2x32(:,:,424))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(205),n2h16(152))
  call Hloop_WA_Q(ntryL,G1H32(236),ex2(:),G1H16(206),m3h2x16(:,425),heltab2x32(:,:,425))
  call Hloop_A_Q(ntryL,G1H16(206),34,0,G2H16(156),n2h16(153))
  call Hloop_WA_Q(ntryL,G0H32(190),ex2(:),G0H16(65),m3h2x16(:,426),heltab2x32(:,:,426))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(206),n2h16(154))
  call Hloop_WA_Q(ntryL,G1H32(237),ex2(:),G1H16(207),m3h2x16(:,427),heltab2x32(:,:,427))
  call Hloop_A_Q(ntryL,G1H16(207),34,0,G2H16(157),n2h16(155))
  call Hloop_SA_Q(ntryL,G0H32(191),ex2(:),G0H16(65),ngPln,m3h2x16(:,428),heltab2x32(:,:,428))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(207),n2h16(156))
  call Hloop_WA_Q(ntryL,G1H32(238),ex2(:),G1H16(208),m3h2x16(:,429),heltab2x32(:,:,429))
  call Hloop_A_Q(ntryL,G1H16(208),34,0,G2H16(158),n2h16(157))
  call Hloop_WA_Q(ntryL,G0H32(192),ex2(:),G0H16(65),m3h2x16(:,430),heltab2x32(:,:,430))
  call Hloop_A_Q(ntryL,G0H16(65),34,0,G1H16(208),n2h16(158))
  call Hloop_WA_Q(ntryL,G1H32(239),ex2(:),G1H16(209),m3h2x16(:,431),heltab2x32(:,:,431))
  call Hloop_A_Q(ntryL,G1H16(209),34,0,G2H16(159),n2h16(159))
  call Hloop_WA_Q(ntryL,G1H32(240),ex2(:),G1H16(209),m3h2x16(:,432),heltab2x32(:,:,432))
  call Hloop_A_Q(ntryL,G1H16(209),34,0,G2H16(160),n2h16(160))
  call Hloop_QV_A(ntryL,G1H32(241),ex4(:),G1H16(209),m3h2x16(:,433),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G1H16(209),40,nME,G2H16(161),n2h16(161))
  call Hloop_QV_A(ntryL,G1H32(242),ex4(:),G1H16(209),m3h2x16(:,434),heltab2x32(:,:,434))
  call Hloop_Q_A(ntryL,G1H16(209),40,nME,G2H16(162),n2h16(162))
  call Hloop_TV_S(ntryL,G1H32(243),32,ex4(:),8,G2H16(163),m3h2x16(:,435),heltab2x32(:,:,435))
  call Hloop_QV_A(ntryL,G1H32(244),ex4(:),G1H16(209),m3h2x16(:,436),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G1H16(209),40,nME,G2H16(164),n2h16(163))
  call Hloop_QV_A(ntryL,G1H32(245),ex4(:),G1H16(209),m3h2x16(:,437),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G1H16(209),40,nME,G2H16(165),n2h16(164))
  call Hloop_TV_S(ntryL,G0H32(193),32,ex4(:),8,G1H16(209),m3h2x16(:,438),heltab2x32(:,:,438))
  call Hloop_VV_S(ntryL,G0H32(194),ex4(:),G0H16(65),m3h2x16(:,439),heltab2x32(:,:,439))
  call Hloop_SV_V(ntryL,G1H32(246),ex4(:),G1H16(210),m3h2x16(:,440),heltab2x32(:,:,440))
  call Hloop_TV_S(ntryL,G1H32(247),32,ex4(:),8,G2H16(166),m3h2x16(:,441),heltab2x32(:,:,441))
  call Hloop_TV_S(ntryL,G1H32(248),32,ex4(:),8,G2H16(167),m3h2x16(:,442),heltab2x32(:,:,442))
  call Hloop_VV_S(ntryL,G1H32(249),ex4(:),G1H16(211),m3h2x16(:,443),heltab2x32(:,:,443))
  call Hloop_SV_V(ntryL,G0H32(195),ex4(:),G0H16(66),m3h2x16(:,444),heltab2x32(:,:,444))
  call Hloop_UV_W(ntryL,G0H32(196),32,ex4(:),8,G1H16(212),m3h2x16(:,445),heltab2x32(:,:,445))
  call Hloop_TV_S(ntryL,G0H32(197),32,ex4(:),8,G1H16(213),m3h2x16(:,446),heltab2x32(:,:,446))
  call Hloop_VV_S(ntryL,G0H32(198),ex4(:),G0H16(67),m3h2x16(:,447),heltab2x32(:,:,447))
  call Hloop_SV_V(ntryL,G1H32(250),ex4(:),G1H16(214),m3h2x16(:,448),heltab2x32(:,:,448))
  call Hloop_TV_S(ntryL,G0H32(199),32,ex4(:),8,G1H16(215),m3h2x16(:,449),heltab2x32(:,:,449))
  call Hloop_VV_S(ntryL,G0H32(200),ex4(:),G0H16(68),m3h2x16(:,450),heltab2x32(:,:,450))
  call Hloop_SV_V(ntryL,G1H32(251),ex4(:),G1H16(216),m3h2x16(:,451),heltab2x32(:,:,451))
  call Hloop_TV_S(ntryL,G1H32(252),32,ex4(:),8,G2H16(168),m3h2x16(:,452),heltab2x32(:,:,452))
  call Hloop_UV_W(ntryL,G1H32(253),32,ex4(:),8,G2H16(169),m3h2x16(:,453),heltab2x32(:,:,453))
  call Hloop_VV_S(ntryL,G1H32(254),ex4(:),G1H16(217),m3h2x16(:,454),heltab2x32(:,:,454))
  call Hloop_SV_V(ntryL,G0H32(201),ex4(:),G0H16(69),m3h2x16(:,455),heltab2x32(:,:,455))
  call Hloop_UV_W(ntryL,G0H32(202),32,ex4(:),8,G1H16(218),m3h2x16(:,456),heltab2x32(:,:,456))
  call Hloop_VV_S(ntryL,G1H32(255),ex4(:),G1H16(219),m3h2x16(:,457),heltab2x32(:,:,457))
  call Hloop_SV_V(ntryL,G0H32(203),ex4(:),G0H16(70),m3h2x16(:,458),heltab2x32(:,:,458))
  call Hloop_UV_W(ntryL,G0H32(204),32,ex4(:),8,G1H16(220),m3h2x16(:,459),heltab2x32(:,:,459))
  call Hloop_TV_S(ntryL,G0H32(205),32,ex4(:),8,G1H16(221),m3h2x16(:,460),heltab2x32(:,:,460))
  call Hloop_VV_S(ntryL,G0H32(206),ex4(:),G0H16(71),m3h2x16(:,461),heltab2x32(:,:,461))
  call Hloop_SV_V(ntryL,G1H32(256),ex4(:),G1H16(222),m3h2x16(:,462),heltab2x32(:,:,462))
  call Hloop_UV_W(ntryL,G1H32(257),32,ex4(:),8,G2H16(170),m3h2x16(:,463),heltab2x32(:,:,463))
  call Hloop_UV_W(ntryL,G1H32(258),32,ex4(:),8,G2H16(171),m3h2x16(:,464),heltab2x32(:,:,464))
  call Hloop_VV_S(ntryL,G1H32(259),ex4(:),G1H16(223),m3h2x16(:,465),heltab2x32(:,:,465))
  call Hloop_SV_V(ntryL,G0H32(207),ex4(:),G0H16(72),m3h2x16(:,466),heltab2x32(:,:,466))
  call Hloop_UV_W(ntryL,G0H32(208),32,ex4(:),8,G1H16(224),m3h2x16(:,467),heltab2x32(:,:,467))
  call Hloop_UV_W(ntryL,G1H32(260),32,ex4(:),8,G2H16(172),m3h2x16(:,468),heltab2x32(:,:,468))
  call Hloop_QV_A(ntryL,G1H32(261),ex3(:),G1H16(225),m3h2x16(:,469),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G1H16(225),36,nME,G2H16(173),n2h16(165))
  call Hloop_QV_A(ntryL,G1H32(262),ex3(:),G1H16(225),m3h2x16(:,470),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G1H16(225),36,nME,G2H16(174),n2h16(166))
  call Hloop_TV_S(ntryL,G1H32(263),32,ex3(:),4,G2H16(175),m3h2x16(:,471),heltab2x32(:,:,471))
  call Hloop_QV_A(ntryL,G1H32(264),ex3(:),G1H16(225),m3h2x16(:,472),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G1H16(225),36,nME,G2H16(176),n2h16(167))
  call Hloop_QV_A(ntryL,G1H32(265),ex3(:),G1H16(225),m3h2x16(:,473),heltab2x32(:,:,473))
  call Hloop_Q_A(ntryL,G1H16(225),36,nME,G2H16(177),n2h16(168))
  call Hloop_TV_S(ntryL,G0H32(209),32,ex3(:),4,G1H16(225),m3h2x16(:,474),heltab2x32(:,:,474))
  call Hloop_TV_S(ntryL,G1H32(266),32,ex3(:),4,G2H16(178),m3h2x16(:,475),heltab2x32(:,:,475))
  call Hloop_VV_S(ntryL,G0H32(210),ex3(:),G0H16(73),m3h2x16(:,476),heltab2x32(:,:,476))
  call Hloop_SV_V(ntryL,G1H32(267),ex3(:),G1H16(226),m3h2x16(:,477),heltab2x32(:,:,477))
  call Hloop_TV_S(ntryL,G1H32(268),32,ex3(:),4,G2H16(179),m3h2x16(:,478),heltab2x32(:,:,478))
  call Hloop_TV_S(ntryL,G0H32(211),32,ex3(:),4,G1H16(227),m3h2x16(:,479),heltab2x32(:,:,479))
  call Hloop_VV_S(ntryL,G1H32(269),ex3(:),G1H16(228),m3h2x16(:,480),heltab2x32(:,:,480))
  call Hloop_VV_S(ntryL,G0H32(212),ex3(:),G0H16(74),m3h2x16(:,481),heltab2x32(:,:,481))
  call Hloop_SV_V(ntryL,G0H32(213),ex3(:),G0H16(75),m3h2x16(:,482),heltab2x32(:,:,482))
  call Hloop_SV_V(ntryL,G1H32(270),ex3(:),G1H16(229),m3h2x16(:,483),heltab2x32(:,:,483))
  call Hloop_UV_W(ntryL,G0H32(214),32,ex3(:),4,G1H16(230),m3h2x16(:,484),heltab2x32(:,:,484))
  call Hloop_TV_S(ntryL,G0H32(215),32,ex3(:),4,G1H16(231),m3h2x16(:,485),heltab2x32(:,:,485))
  call Hloop_TV_S(ntryL,G1H32(271),32,ex3(:),4,G2H16(180),m3h2x16(:,486),heltab2x32(:,:,486))
  call Hloop_VV_S(ntryL,G0H32(216),ex3(:),G0H16(76),m3h2x16(:,487),heltab2x32(:,:,487))
  call Hloop_SV_V(ntryL,G1H32(272),ex3(:),G1H16(232),m3h2x16(:,488),heltab2x32(:,:,488))
  call Hloop_VV_S(ntryL,G1H32(273),ex3(:),G1H16(233),m3h2x16(:,489),heltab2x32(:,:,489))
  call Hloop_SV_V(ntryL,G0H32(217),ex3(:),G0H16(77),m3h2x16(:,490),heltab2x32(:,:,490))
  call Hloop_UV_W(ntryL,G1H32(274),32,ex3(:),4,G2H16(181),m3h2x16(:,491),heltab2x32(:,:,491))
  call Hloop_UV_W(ntryL,G0H32(218),32,ex3(:),4,G1H16(234),m3h2x16(:,492),heltab2x32(:,:,492))
  call Hloop_TV_S(ntryL,G0H32(219),32,ex3(:),4,G1H16(235),m3h2x16(:,493),heltab2x32(:,:,493))
  call Hloop_VV_S(ntryL,G1H32(275),ex3(:),G1H16(236),m3h2x16(:,494),heltab2x32(:,:,494))
  call Hloop_VV_S(ntryL,G0H32(220),ex3(:),G0H16(78),m3h2x16(:,495),heltab2x32(:,:,495))
  call Hloop_SV_V(ntryL,G0H32(221),ex3(:),G0H16(79),m3h2x16(:,496),heltab2x32(:,:,496))
  call Hloop_SV_V(ntryL,G1H32(276),ex3(:),G1H16(237),m3h2x16(:,497),heltab2x32(:,:,497))
  call Hloop_UV_W(ntryL,G0H32(222),32,ex3(:),4,G1H16(238),m3h2x16(:,498),heltab2x32(:,:,498))
  call Hloop_UV_W(ntryL,G1H32(277),32,ex3(:),4,G2H16(182),m3h2x16(:,499),heltab2x32(:,:,499))
  call Hloop_VV_S(ntryL,G1H32(278),ex3(:),G1H16(239),m3h2x16(:,500),heltab2x32(:,:,500))
  call Hloop_SV_V(ntryL,G0H32(223),ex3(:),G0H16(80),m3h2x16(:,501),heltab2x32(:,:,501))
  call Hloop_UV_W(ntryL,G1H32(279),32,ex3(:),4,G2H16(183),m3h2x16(:,502),heltab2x32(:,:,502))
  call Hloop_UV_W(ntryL,G0H32(224),32,ex3(:),4,G1H16(240),m3h2x16(:,503),heltab2x32(:,:,503))
  call Hloop_UV_W(ntryL,G1H32(280),32,ex3(:),4,G2H16(184),m3h2x16(:,504),heltab2x32(:,:,504))
  call Hloop_QV_A(ntryL,G1H32(281),ex3(:),G1H16(241),m3h2x16(:,505),heltab2x32(:,:,505))
  call Hloop_Q_A(ntryL,G1H16(241),36,nME,G2H16(185),n2h16(169))
  call Hloop_QV_A(ntryL,G1H32(282),ex3(:),G1H16(241),m3h2x16(:,506),heltab2x32(:,:,506))
  call Hloop_Q_A(ntryL,G1H16(241),36,nME,G2H16(186),n2h16(170))
  call Hloop_TV_S(ntryL,G1H32(283),32,ex3(:),4,G2H16(187),m3h2x16(:,507),heltab2x32(:,:,507))
  call Hloop_QV_A(ntryL,G1H32(284),ex3(:),G1H16(241),m3h2x16(:,508),heltab2x32(:,:,508))
  call Hloop_Q_A(ntryL,G1H16(241),36,nME,G2H16(188),n2h16(171))
  call Hloop_QV_A(ntryL,G1H32(285),ex3(:),G1H16(241),m3h2x16(:,509),heltab2x32(:,:,509))
  call Hloop_Q_A(ntryL,G1H16(241),36,nME,G2H16(189),n2h16(172))
  call Hloop_TV_S(ntryL,G0H32(225),32,ex3(:),4,G1H16(241),m3h2x16(:,510),heltab2x32(:,:,510))
  call Hloop_VV_S(ntryL,G0H32(226),ex3(:),G0H16(81),m3h2x16(:,511),heltab2x32(:,:,511))
  call Hloop_SV_V(ntryL,G1H32(286),ex3(:),G1H16(242),m3h2x16(:,512),heltab2x32(:,:,512))
  call Hloop_TV_S(ntryL,G1H32(287),32,ex3(:),4,G2H16(190),m3h2x16(:,513),heltab2x32(:,:,513))
  call Hloop_TV_S(ntryL,G1H32(288),32,ex3(:),4,G2H16(191),m3h2x16(:,514),heltab2x32(:,:,514))
  call Hloop_VV_S(ntryL,G1H32(289),ex3(:),G1H16(243),m3h2x16(:,515),heltab2x32(:,:,515))
  call Hloop_SV_V(ntryL,G0H32(227),ex3(:),G0H16(82),m3h2x16(:,516),heltab2x32(:,:,516))
  call Hloop_UV_W(ntryL,G0H32(228),32,ex3(:),4,G1H16(244),m3h2x16(:,517),heltab2x32(:,:,517))
  call Hloop_TV_S(ntryL,G0H32(229),32,ex3(:),4,G1H16(245),m3h2x16(:,518),heltab2x32(:,:,518))
  call Hloop_VV_S(ntryL,G0H32(230),ex3(:),G0H16(83),m3h2x16(:,519),heltab2x32(:,:,519))
  call Hloop_SV_V(ntryL,G1H32(290),ex3(:),G1H16(246),m3h2x16(:,520),heltab2x32(:,:,520))
  call Hloop_TV_S(ntryL,G0H32(231),32,ex3(:),4,G1H16(247),m3h2x16(:,521),heltab2x32(:,:,521))
  call Hloop_VV_S(ntryL,G0H32(232),ex3(:),G0H16(84),m3h2x16(:,522),heltab2x32(:,:,522))
  call Hloop_SV_V(ntryL,G1H32(291),ex3(:),G1H16(248),m3h2x16(:,523),heltab2x32(:,:,523))
  call Hloop_TV_S(ntryL,G1H32(292),32,ex3(:),4,G2H16(192),m3h2x16(:,524),heltab2x32(:,:,524))
  call Hloop_UV_W(ntryL,G1H32(293),32,ex3(:),4,G2H16(193),m3h2x16(:,525),heltab2x32(:,:,525))
  call Hloop_VV_S(ntryL,G1H32(294),ex3(:),G1H16(249),m3h2x16(:,526),heltab2x32(:,:,526))
  call Hloop_SV_V(ntryL,G0H32(233),ex3(:),G0H16(85),m3h2x16(:,527),heltab2x32(:,:,527))
  call Hloop_UV_W(ntryL,G0H32(234),32,ex3(:),4,G1H16(250),m3h2x16(:,528),heltab2x32(:,:,528))
  call Hloop_VV_S(ntryL,G1H32(295),ex3(:),G1H16(251),m3h2x16(:,529),heltab2x32(:,:,529))
  call Hloop_SV_V(ntryL,G0H32(235),ex3(:),G0H16(86),m3h2x16(:,530),heltab2x32(:,:,530))
  call Hloop_UV_W(ntryL,G0H32(236),32,ex3(:),4,G1H16(252),m3h2x16(:,531),heltab2x32(:,:,531))
  call Hloop_TV_S(ntryL,G0H32(237),32,ex3(:),4,G1H16(253),m3h2x16(:,532),heltab2x32(:,:,532))
  call Hloop_VV_S(ntryL,G0H32(238),ex3(:),G0H16(87),m3h2x16(:,533),heltab2x32(:,:,533))
  call Hloop_SV_V(ntryL,G1H32(296),ex3(:),G1H16(254),m3h2x16(:,534),heltab2x32(:,:,534))
  call Hloop_UV_W(ntryL,G1H32(297),32,ex3(:),4,G2H16(194),m3h2x16(:,535),heltab2x32(:,:,535))
  call Hloop_UV_W(ntryL,G1H32(298),32,ex3(:),4,G2H16(195),m3h2x16(:,536),heltab2x32(:,:,536))
  call Hloop_VV_S(ntryL,G1H32(299),ex3(:),G1H16(255),m3h2x16(:,537),heltab2x32(:,:,537))
  call Hloop_SV_V(ntryL,G0H32(239),ex3(:),G0H16(88),m3h2x16(:,538),heltab2x32(:,:,538))
  call Hloop_UV_W(ntryL,G0H32(240),32,ex3(:),4,G1H16(256),m3h2x16(:,539),heltab2x32(:,:,539))
  call Hloop_UV_W(ntryL,G1H32(300),32,ex3(:),4,G2H16(196),m3h2x16(:,540),heltab2x32(:,:,540))
  call Hloop_AV_Q(ntryL,G1H32(301),ex3(:),G1H16(257),m3h2x16(:,541),heltab2x32(:,:,541))
  call Hloop_A_Q(ntryL,G1H16(257),36,nME,G2H16(197),n2h16(173))
  call Hloop_AV_Q(ntryL,G1H32(302),ex3(:),G1H16(257),m3h2x16(:,542),heltab2x32(:,:,542))
  call Hloop_A_Q(ntryL,G1H16(257),36,nME,G2H16(198),n2h16(174))
  call Hloop_SV_T(ntryL,G1H32(303),32,ex3(:),4,G2H16(199),m3h2x16(:,543),heltab2x32(:,:,543))
  call Hloop_AV_Q(ntryL,G1H32(304),ex3(:),G1H16(257),m3h2x16(:,544),heltab2x32(:,:,544))
  call Hloop_A_Q(ntryL,G1H16(257),36,nME,G2H16(200),n2h16(175))
  call Hloop_AV_Q(ntryL,G1H32(305),ex3(:),G1H16(257),m3h2x16(:,545),heltab2x32(:,:,545))
  call Hloop_A_Q(ntryL,G1H16(257),36,nME,G2H16(201),n2h16(176))
  call Hloop_SV_T(ntryL,G0H32(241),32,ex3(:),4,G1H16(257),m3h2x16(:,546),heltab2x32(:,:,546))
  call Hloop_VV_S(ntryL,G0H32(242),ex3(:),G0H16(89),m3h2x16(:,547),heltab2x32(:,:,547))
  call Hloop_SV_V(ntryL,G1H32(306),ex3(:),G1H16(258),m3h2x16(:,548),heltab2x32(:,:,548))
  call Hloop_SV_T(ntryL,G1H32(307),32,ex3(:),4,G2H16(202),m3h2x16(:,549),heltab2x32(:,:,549))
  call Hloop_SV_T(ntryL,G1H32(308),32,ex3(:),4,G2H16(203),m3h2x16(:,550),heltab2x32(:,:,550))
  call Hloop_VV_S(ntryL,G1H32(309),ex3(:),G1H16(259),m3h2x16(:,551),heltab2x32(:,:,551))
  call Hloop_SV_V(ntryL,G0H32(243),ex3(:),G0H16(90),m3h2x16(:,552),heltab2x32(:,:,552))
  call Hloop_UW_V(ntryL,G0H32(244),32,ex3(:),4,G1H16(260),m3h2x16(:,553),heltab2x32(:,:,553))
  call Hloop_SV_T(ntryL,G0H32(245),32,ex3(:),4,G1H16(261),m3h2x16(:,554),heltab2x32(:,:,554))
  call Hloop_VV_S(ntryL,G0H32(246),ex3(:),G0H16(91),m3h2x16(:,555),heltab2x32(:,:,555))
  call Hloop_SV_V(ntryL,G1H32(310),ex3(:),G1H16(262),m3h2x16(:,556),heltab2x32(:,:,556))
  call Hloop_SV_T(ntryL,G0H32(247),32,ex3(:),4,G1H16(263),m3h2x16(:,557),heltab2x32(:,:,557))
  call Hloop_VV_S(ntryL,G0H32(248),ex3(:),G0H16(92),m3h2x16(:,558),heltab2x32(:,:,558))
  call Hloop_SV_V(ntryL,G1H32(311),ex3(:),G1H16(264),m3h2x16(:,559),heltab2x32(:,:,559))
  call Hloop_SV_T(ntryL,G1H32(312),32,ex3(:),4,G2H16(204),m3h2x16(:,560),heltab2x32(:,:,560))
  call Hloop_UW_V(ntryL,G1H32(313),32,ex3(:),4,G2H16(205),m3h2x16(:,561),heltab2x32(:,:,561))
  call Hloop_VV_S(ntryL,G1H32(314),ex3(:),G1H16(265),m3h2x16(:,562),heltab2x32(:,:,562))
  call Hloop_SV_V(ntryL,G0H32(249),ex3(:),G0H16(93),m3h2x16(:,563),heltab2x32(:,:,563))
  call Hloop_UW_V(ntryL,G0H32(250),32,ex3(:),4,G1H16(266),m3h2x16(:,564),heltab2x32(:,:,564))
  call Hloop_VV_S(ntryL,G1H32(315),ex3(:),G1H16(267),m3h2x16(:,565),heltab2x32(:,:,565))
  call Hloop_SV_V(ntryL,G0H32(251),ex3(:),G0H16(94),m3h2x16(:,566),heltab2x32(:,:,566))
  call Hloop_UW_V(ntryL,G0H32(252),32,ex3(:),4,G1H16(268),m3h2x16(:,567),heltab2x32(:,:,567))
  call Hloop_SV_T(ntryL,G0H32(253),32,ex3(:),4,G1H16(269),m3h2x16(:,568),heltab2x32(:,:,568))
  call Hloop_VV_S(ntryL,G0H32(254),ex3(:),G0H16(95),m3h2x16(:,569),heltab2x32(:,:,569))
  call Hloop_SV_V(ntryL,G1H32(316),ex3(:),G1H16(270),m3h2x16(:,570),heltab2x32(:,:,570))
  call Hloop_UW_V(ntryL,G1H32(317),32,ex3(:),4,G2H16(206),m3h2x16(:,571),heltab2x32(:,:,571))
  call Hloop_UW_V(ntryL,G1H32(318),32,ex3(:),4,G2H16(207),m3h2x16(:,572),heltab2x32(:,:,572))
  call Hloop_VV_S(ntryL,G1H32(319),ex3(:),G1H16(271),m3h2x16(:,573),heltab2x32(:,:,573))
  call Hloop_SV_V(ntryL,G0H32(255),ex3(:),G0H16(96),m3h2x16(:,574),heltab2x32(:,:,574))
  call Hloop_UW_V(ntryL,G0H32(256),32,ex3(:),4,G1H16(272),m3h2x16(:,575),heltab2x32(:,:,575))
  call Hloop_UW_V(ntryL,G1H32(320),32,ex3(:),4,G2H16(208),m3h2x16(:,576),heltab2x32(:,:,576))
  call Hloop_QA_S(ntryL,G1H32(321),ex2(:),G1H16(273),ngH,m3h2x16(:,577),heltab2x32(:,:,577))
  call Hloop_QA_S(ntryL,G1H32(322),ex2(:),G1H16(274),ngX,m3h2x16(:,578),heltab2x32(:,:,578))
  call Hloop_SA_Q(ntryL,G1H32(323),ex2(:),G1H16(275),ngPln,m3h2x16(:,579),heltab2x32(:,:,579))
  call Hloop_A_Q(ntryL,G1H16(275),34,0,G2H16(209),n2h16(177))
  call Hloop_QA_V(ntryL,G1H32(324),ex2(:),G1H16(275),m3h2x16(:,580),heltab2x32(:,:,580))
  call Hloop_QA_Z(ntryL,G1H32(325),ex2(:),G1H16(276),ngZl,m3h2x16(:,581),heltab2x32(:,:,581))
  call Hloop_SA_Q(ntryL,G0H32(257),ex2(:),G0H16(97),ngPln,m3h2x16(:,582),heltab2x32(:,:,582))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(277),n2h16(178))
  call Hloop_SA_Q(ntryL,G1H32(326),ex2(:),G1H16(278),ngPln,m3h2x16(:,583),heltab2x32(:,:,583))
  call Hloop_A_Q(ntryL,G1H16(278),34,0,G2H16(210),n2h16(179))
  call Hloop_SA_Q(ntryL,G1H32(327),ex2(:),G1H16(278),ngPln,m3h2x16(:,584),heltab2x32(:,:,584))
  call Hloop_A_Q(ntryL,G1H16(278),34,0,G2H16(211),n2h16(180))
  call Hloop_WA_Q(ntryL,G0H32(258),ex2(:),G0H16(97),m3h2x16(:,585),heltab2x32(:,:,585))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(278),n2h16(181))
  call Hloop_SA_Q(ntryL,G1H32(328),ex2(:),G1H16(279),ngPln,m3h2x16(:,586),heltab2x32(:,:,586))
  call Hloop_A_Q(ntryL,G1H16(279),34,0,G2H16(212),n2h16(182))
  call Hloop_SA_Q(ntryL,G0H32(259),ex2(:),G0H16(97),ngPln,m3h2x16(:,587),heltab2x32(:,:,587))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(279),n2h16(183))
  call Hloop_SA_Q(ntryL,G0H32(260),ex2(:),G0H16(97),ngPln,m3h2x16(:,588),heltab2x32(:,:,588))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(280),n2h16(184))
  call Hloop_SA_Q(ntryL,G1H32(329),ex2(:),G1H16(281),ngPln,m3h2x16(:,589),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G1H16(281),34,0,G2H16(213),n2h16(185))
  call Hloop_WA_Q(ntryL,G1H32(330),ex2(:),G1H16(281),m3h2x16(:,590),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G1H16(281),34,0,G2H16(214),n2h16(186))
  call Hloop_WA_Q(ntryL,G0H32(261),ex2(:),G0H16(97),m3h2x16(:,591),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(281),n2h16(187))
  call Hloop_WA_Q(ntryL,G0H32(262),ex2(:),G0H16(97),m3h2x16(:,592),heltab2x32(:,:,592))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(282),n2h16(188))
  call Hloop_SA_Q(ntryL,G0H32(263),ex2(:),G0H16(97),ngPln,m3h2x16(:,593),heltab2x32(:,:,593))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(283),n2h16(189))
  call Hloop_SA_Q(ntryL,G1H32(331),ex2(:),G1H16(284),ngPln,m3h2x16(:,594),heltab2x32(:,:,594))
  call Hloop_A_Q(ntryL,G1H16(284),34,0,G2H16(215),n2h16(190))
  call Hloop_SA_Q(ntryL,G1H32(332),ex2(:),G1H16(284),ngPln,m3h2x16(:,595),heltab2x32(:,:,595))
  call Hloop_A_Q(ntryL,G1H16(284),34,0,G2H16(216),n2h16(191))
  call Hloop_WA_Q(ntryL,G0H32(264),ex2(:),G0H16(97),m3h2x16(:,596),heltab2x32(:,:,596))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(284),n2h16(192))
  call Hloop_SA_Q(ntryL,G0H32(265),ex2(:),G0H16(97),ngPln,m3h2x16(:,597),heltab2x32(:,:,597))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(285),n2h16(193))
  call Hloop_WA_Q(ntryL,G1H32(333),ex2(:),G1H16(286),m3h2x16(:,598),heltab2x32(:,:,598))
  call Hloop_A_Q(ntryL,G1H16(286),34,0,G2H16(217),n2h16(194))
  call Hloop_WA_Q(ntryL,G1H32(334),ex2(:),G1H16(286),m3h2x16(:,599),heltab2x32(:,:,599))
  call Hloop_A_Q(ntryL,G1H16(286),34,0,G2H16(218),n2h16(195))
  call Hloop_WA_Q(ntryL,G0H32(266),ex2(:),G0H16(97),m3h2x16(:,600),heltab2x32(:,:,600))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(286),n2h16(196))
  call Hloop_SA_Q(ntryL,G0H32(267),ex2(:),G0H16(97),ngPln,m3h2x16(:,601),heltab2x32(:,:,601))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(287),n2h16(197))
  call Hloop_SA_Q(ntryL,G0H32(268),ex2(:),G0H16(97),ngPln,m3h2x16(:,602),heltab2x32(:,:,602))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(288),n2h16(198))
  call Hloop_SA_Q(ntryL,G1H32(335),ex2(:),G1H16(289),ngPln,m3h2x16(:,603),heltab2x32(:,:,603))
  call Hloop_A_Q(ntryL,G1H16(289),34,0,G2H16(219),n2h16(199))
  call Hloop_WA_Q(ntryL,G1H32(336),ex2(:),G1H16(289),m3h2x16(:,604),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G1H16(289),34,0,G2H16(220),n2h16(200))
  call Hloop_WA_Q(ntryL,G0H32(269),ex2(:),G0H16(97),m3h2x16(:,605),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(289),n2h16(201))
  call Hloop_WA_Q(ntryL,G0H32(270),ex2(:),G0H16(97),m3h2x16(:,606),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(290),n2h16(202))
  call Hloop_WA_Q(ntryL,G1H32(337),ex2(:),G1H16(291),m3h2x16(:,607),heltab2x32(:,:,607))
  call Hloop_A_Q(ntryL,G1H16(291),34,0,G2H16(221),n2h16(203))
  call Hloop_SA_Q(ntryL,G0H32(271),ex2(:),G0H16(97),ngPln,m3h2x16(:,608),heltab2x32(:,:,608))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(291),n2h16(204))
  call Hloop_WA_Q(ntryL,G1H32(338),ex2(:),G1H16(292),m3h2x16(:,609),heltab2x32(:,:,609))
  call Hloop_A_Q(ntryL,G1H16(292),34,0,G2H16(222),n2h16(205))
  call Hloop_WA_Q(ntryL,G1H32(339),ex2(:),G1H16(292),m3h2x16(:,610),heltab2x32(:,:,610))
  call Hloop_A_Q(ntryL,G1H16(292),34,0,G2H16(223),n2h16(206))
  call Hloop_WA_Q(ntryL,G0H32(272),ex2(:),G0H16(97),m3h2x16(:,611),heltab2x32(:,:,611))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(292),n2h16(207))
  call Hloop_WA_Q(ntryL,G1H32(340),ex2(:),G1H16(293),m3h2x16(:,612),heltab2x32(:,:,612))
  call Hloop_A_Q(ntryL,G1H16(293),34,0,G2H16(224),n2h16(208))
  call Hloop_QA_S(ntryL,G1H32(341),ex2(:),G1H16(293),ngH,m3h2x16(:,613),heltab2x32(:,:,613))
  call Hloop_QA_S(ntryL,G1H32(342),ex2(:),G1H16(294),ngX,m3h2x16(:,614),heltab2x32(:,:,614))
  call Hloop_SA_Q(ntryL,G1H32(343),ex2(:),G1H16(295),ngPln,m3h2x16(:,615),heltab2x32(:,:,615))
  call Hloop_A_Q(ntryL,G1H16(295),34,0,G2H16(225),n2h16(209))
  call Hloop_QA_V(ntryL,G1H32(344),ex2(:),G1H16(295),m3h2x16(:,616),heltab2x32(:,:,616))
  call Hloop_QA_Z(ntryL,G1H32(345),ex2(:),G1H16(296),ngZl,m3h2x16(:,617),heltab2x32(:,:,617))
  call Hloop_SA_Q(ntryL,G1H32(346),ex2(:),G1H16(297),ngPln,m3h2x16(:,618),heltab2x32(:,:,618))
  call Hloop_A_Q(ntryL,G1H16(297),34,0,G2H16(226),n2h16(210))
  call Hloop_SA_Q(ntryL,G0H32(273),ex2(:),G0H16(97),ngPln,m3h2x16(:,619),heltab2x32(:,:,619))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(297),n2h16(211))
  call Hloop_SA_Q(ntryL,G1H32(347),ex2(:),G1H16(298),ngPln,m3h2x16(:,620),heltab2x32(:,:,620))
  call Hloop_A_Q(ntryL,G1H16(298),34,0,G2H16(227),n2h16(212))
  call Hloop_WA_Q(ntryL,G0H32(274),ex2(:),G0H16(97),m3h2x16(:,621),heltab2x32(:,:,621))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(298),n2h16(213))
  call Hloop_SA_Q(ntryL,G1H32(348),ex2(:),G1H16(299),ngPln,m3h2x16(:,622),heltab2x32(:,:,622))
  call Hloop_A_Q(ntryL,G1H16(299),34,0,G2H16(228),n2h16(214))
  call Hloop_SA_Q(ntryL,G0H32(275),ex2(:),G0H16(97),ngPln,m3h2x16(:,623),heltab2x32(:,:,623))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(299),n2h16(215))
  call Hloop_SA_Q(ntryL,G1H32(349),ex2(:),G1H16(300),ngPln,m3h2x16(:,624),heltab2x32(:,:,624))
  call Hloop_A_Q(ntryL,G1H16(300),34,0,G2H16(229),n2h16(216))
  call Hloop_SA_Q(ntryL,G0H32(276),ex2(:),G0H16(97),ngPln,m3h2x16(:,625),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(300),n2h16(217))
  call Hloop_WA_Q(ntryL,G0H32(277),ex2(:),G0H16(97),m3h2x16(:,626),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(301),n2h16(218))
  call Hloop_WA_Q(ntryL,G1H32(350),ex2(:),G1H16(302),m3h2x16(:,627),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G1H16(302),34,0,G2H16(230),n2h16(219))
  call Hloop_WA_Q(ntryL,G0H32(278),ex2(:),G0H16(97),m3h2x16(:,628),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(302),n2h16(220))
  call Hloop_SA_Q(ntryL,G1H32(351),ex2(:),G1H16(303),ngPln,m3h2x16(:,629),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G1H16(303),34,0,G2H16(231),n2h16(221))
  call Hloop_SA_Q(ntryL,G0H32(279),ex2(:),G0H16(97),ngPln,m3h2x16(:,630),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(303),n2h16(222))
  call Hloop_SA_Q(ntryL,G1H32(352),ex2(:),G1H16(304),ngPln,m3h2x16(:,631),heltab2x32(:,:,631))
  call Hloop_A_Q(ntryL,G1H16(304),34,0,G2H16(232),n2h16(223))
  call Hloop_WA_Q(ntryL,G0H32(280),ex2(:),G0H16(97),m3h2x16(:,632),heltab2x32(:,:,632))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(304),n2h16(224))
  call Hloop_SA_Q(ntryL,G0H32(281),ex2(:),G0H16(97),ngPln,m3h2x16(:,633),heltab2x32(:,:,633))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(305),n2h16(225))
  call Hloop_WA_Q(ntryL,G1H32(353),ex2(:),G1H16(306),m3h2x16(:,634),heltab2x32(:,:,634))
  call Hloop_A_Q(ntryL,G1H16(306),34,0,G2H16(233),n2h16(226))
  call Hloop_WA_Q(ntryL,G0H32(282),ex2(:),G0H16(97),m3h2x16(:,635),heltab2x32(:,:,635))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(306),n2h16(227))
  call Hloop_WA_Q(ntryL,G1H32(354),ex2(:),G1H16(307),m3h2x16(:,636),heltab2x32(:,:,636))
  call Hloop_A_Q(ntryL,G1H16(307),34,0,G2H16(234),n2h16(228))
  call Hloop_SA_Q(ntryL,G0H32(283),ex2(:),G0H16(97),ngPln,m3h2x16(:,637),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(307),n2h16(229))
  call Hloop_SA_Q(ntryL,G1H32(355),ex2(:),G1H16(308),ngPln,m3h2x16(:,638),heltab2x32(:,:,638))
  call Hloop_A_Q(ntryL,G1H16(308),34,0,G2H16(235),n2h16(230))
  call Hloop_SA_Q(ntryL,G0H32(284),ex2(:),G0H16(97),ngPln,m3h2x16(:,639),heltab2x32(:,:,639))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(308),n2h16(231))
  call Hloop_WA_Q(ntryL,G0H32(285),ex2(:),G0H16(97),m3h2x16(:,640),heltab2x32(:,:,640))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(309),n2h16(232))
  call Hloop_WA_Q(ntryL,G1H32(356),ex2(:),G1H16(310),m3h2x16(:,641),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G1H16(310),34,0,G2H16(236),n2h16(233))
  call Hloop_WA_Q(ntryL,G0H32(286),ex2(:),G0H16(97),m3h2x16(:,642),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(310),n2h16(234))
  call Hloop_WA_Q(ntryL,G1H32(357),ex2(:),G1H16(311),m3h2x16(:,643),heltab2x32(:,:,643))
  call Hloop_A_Q(ntryL,G1H16(311),34,0,G2H16(237),n2h16(235))
  call Hloop_SA_Q(ntryL,G0H32(287),ex2(:),G0H16(97),ngPln,m3h2x16(:,644),heltab2x32(:,:,644))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(311),n2h16(236))
  call Hloop_WA_Q(ntryL,G1H32(358),ex2(:),G1H16(312),m3h2x16(:,645),heltab2x32(:,:,645))
  call Hloop_A_Q(ntryL,G1H16(312),34,0,G2H16(238),n2h16(237))
  call Hloop_WA_Q(ntryL,G0H32(288),ex2(:),G0H16(97),m3h2x16(:,646),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G0H16(97),34,0,G1H16(312),n2h16(238))
  call Hloop_WA_Q(ntryL,G1H32(359),ex2(:),G1H16(313),m3h2x16(:,647),heltab2x32(:,:,647))
  call Hloop_A_Q(ntryL,G1H16(313),34,0,G2H16(239),n2h16(239))
  call Hloop_WA_Q(ntryL,G1H32(360),ex2(:),G1H16(313),m3h2x16(:,648),heltab2x32(:,:,648))
  call Hloop_A_Q(ntryL,G1H16(313),34,0,G2H16(240),n2h16(240))
  call Hloop_AQ_S(ntryL,G1H32(361),ex1(:),G1H16(313),ngH,m3h2x16(:,649),heltab2x32(:,:,649))
  call Hloop_AQ_S(ntryL,G1H32(362),ex1(:),G1H16(314),ngX,m3h2x16(:,650),heltab2x32(:,:,650))
  call Hloop_SQ_A(ntryL,G1H32(363),ex1(:),G1H16(315),ngPnl,m3h2x16(:,651),heltab2x32(:,:,651))
  call Hloop_Q_A(ntryL,G1H16(315),33,0,G2H16(241),n2h16(241))
  call Hloop_AQ_V(ntryL,G1H32(364),ex1(:),G1H16(315),m3h2x16(:,652),heltab2x32(:,:,652))
  call Hloop_AQ_Z(ntryL,G1H32(365),ex1(:),G1H16(316),ngZl,m3h2x16(:,653),heltab2x32(:,:,653))
  call Hloop_SQ_A(ntryL,G0H32(289),ex1(:),G0H16(97),ngPnl,m3h2x16(:,654),heltab2x32(:,:,654))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(317),n2h16(242))
  call Hloop_SQ_A(ntryL,G1H32(366),ex1(:),G1H16(318),ngPnl,m3h2x16(:,655),heltab2x32(:,:,655))
  call Hloop_Q_A(ntryL,G1H16(318),33,0,G2H16(242),n2h16(243))
  call Hloop_SQ_A(ntryL,G1H32(367),ex1(:),G1H16(318),ngPnl,m3h2x16(:,656),heltab2x32(:,:,656))
  call Hloop_Q_A(ntryL,G1H16(318),33,0,G2H16(243),n2h16(244))
  call Hloop_SQ_A(ntryL,G1H32(368),ex1(:),G1H16(318),ngPnl,m3h2x16(:,657),heltab2x32(:,:,657))
  call Hloop_Q_A(ntryL,G1H16(318),33,0,G2H16(244),n2h16(245))
  call Hloop_WQ_A(ntryL,G0H32(290),ex1(:),G0H16(97),m3h2x16(:,658),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(318),n2h16(246))
  call Hloop_SQ_A(ntryL,G0H32(291),ex1(:),G0H16(97),ngPnl,m3h2x16(:,659),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(319),n2h16(247))
  call Hloop_SQ_A(ntryL,G0H32(292),ex1(:),G0H16(97),ngPnl,m3h2x16(:,660),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(320),n2h16(248))
  call Hloop_SQ_A(ntryL,G1H32(369),ex1(:),G1H16(321),ngPnl,m3h2x16(:,661),heltab2x32(:,:,661))
  call Hloop_Q_A(ntryL,G1H16(321),33,0,G2H16(245),n2h16(249))
  call Hloop_SQ_A(ntryL,G0H32(293),ex1(:),G0H16(97),ngPnl,m3h2x16(:,662),heltab2x32(:,:,662))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(321),n2h16(250))
  call Hloop_SQ_A(ntryL,G1H32(370),ex1(:),G1H16(322),ngPnl,m3h2x16(:,663),heltab2x32(:,:,663))
  call Hloop_Q_A(ntryL,G1H16(322),33,0,G2H16(246),n2h16(251))
  call Hloop_SQ_A(ntryL,G1H32(371),ex1(:),G1H16(322),ngPnl,m3h2x16(:,664),heltab2x32(:,:,664))
  call Hloop_Q_A(ntryL,G1H16(322),33,0,G2H16(247),n2h16(252))
  call Hloop_WQ_A(ntryL,G1H32(372),ex1(:),G1H16(322),m3h2x16(:,665),heltab2x32(:,:,665))
  call Hloop_Q_A(ntryL,G1H16(322),33,0,G2H16(248),n2h16(253))
  call Hloop_WQ_A(ntryL,G0H32(294),ex1(:),G0H16(97),m3h2x16(:,666),heltab2x32(:,:,666))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(322),n2h16(254))
  call Hloop_WQ_A(ntryL,G0H32(295),ex1(:),G0H16(97),m3h2x16(:,667),heltab2x32(:,:,667))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(323),n2h16(255))
  call Hloop_WQ_A(ntryL,G0H32(296),ex1(:),G0H16(97),m3h2x16(:,668),heltab2x32(:,:,668))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(324),n2h16(256))
  call Hloop_SQ_A(ntryL,G0H32(297),ex1(:),G0H16(97),ngPnl,m3h2x16(:,669),heltab2x32(:,:,669))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(325),n2h16(257))
  call Hloop_SQ_A(ntryL,G0H32(298),ex1(:),G0H16(97),ngPnl,m3h2x16(:,670),heltab2x32(:,:,670))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(326),n2h16(258))
  call Hloop_SQ_A(ntryL,G0H32(299),ex1(:),G0H16(97),ngPnl,m3h2x16(:,671),heltab2x32(:,:,671))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(327),n2h16(259))
  call Hloop_SQ_A(ntryL,G1H32(373),ex1(:),G1H16(328),ngPnl,m3h2x16(:,672),heltab2x32(:,:,672))
  call Hloop_Q_A(ntryL,G1H16(328),33,0,G2H16(249),n2h16(260))
  call Hloop_WQ_A(ntryL,G1H32(374),ex1(:),G1H16(328),m3h2x16(:,673),heltab2x32(:,:,673))
  call Hloop_Q_A(ntryL,G1H16(328),33,0,G2H16(250),n2h16(261))
  call Hloop_WQ_A(ntryL,G1H32(375),ex1(:),G1H16(328),m3h2x16(:,674),heltab2x32(:,:,674))
  call Hloop_Q_A(ntryL,G1H16(328),33,0,G2H16(251),n2h16(262))
  call Hloop_WQ_A(ntryL,G0H32(300),ex1(:),G0H16(97),m3h2x16(:,675),heltab2x32(:,:,675))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(328),n2h16(263))
  call Hloop_WQ_A(ntryL,G1H32(376),ex1(:),G1H16(329),m3h2x16(:,676),heltab2x32(:,:,676))
  call Hloop_Q_A(ntryL,G1H16(329),33,0,G2H16(252),n2h16(264))
  call Hloop_WQ_A(ntryL,G0H32(301),ex1(:),G0H16(97),m3h2x16(:,677),heltab2x32(:,:,677))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(329),n2h16(265))
  call Hloop_WQ_A(ntryL,G0H32(302),ex1(:),G0H16(97),m3h2x16(:,678),heltab2x32(:,:,678))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(330),n2h16(266))
  call Hloop_SQ_A(ntryL,G0H32(303),ex1(:),G0H16(97),ngPnl,m3h2x16(:,679),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(331),n2h16(267))
  call Hloop_WQ_A(ntryL,G1H32(377),ex1(:),G1H16(332),m3h2x16(:,680),heltab2x32(:,:,680))
  call Hloop_Q_A(ntryL,G1H16(332),33,0,G2H16(253),n2h16(268))
  call Hloop_WQ_A(ntryL,G1H32(378),ex1(:),G1H16(332),m3h2x16(:,681),heltab2x32(:,:,681))
  call Hloop_Q_A(ntryL,G1H16(332),33,0,G2H16(254),n2h16(269))
  call Hloop_WQ_A(ntryL,G1H32(379),ex1(:),G1H16(332),m3h2x16(:,682),heltab2x32(:,:,682))
  call Hloop_Q_A(ntryL,G1H16(332),33,0,G2H16(255),n2h16(270))
  call Hloop_WQ_A(ntryL,G0H32(304),ex1(:),G0H16(97),m3h2x16(:,683),heltab2x32(:,:,683))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(332),n2h16(271))
  call Hloop_WQ_A(ntryL,G1H32(380),ex1(:),G1H16(333),m3h2x16(:,684),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G1H16(333),33,0,G2H16(256),n2h16(272))
  call Hloop_AQ_S(ntryL,G1H32(381),ex1(:),G1H16(333),ngH,m3h2x16(:,685),heltab2x32(:,:,685))
  call Hloop_AQ_S(ntryL,G1H32(382),ex1(:),G1H16(334),ngX,m3h2x16(:,686),heltab2x32(:,:,686))
  call Hloop_SQ_A(ntryL,G1H32(383),ex1(:),G1H16(335),ngPnl,m3h2x16(:,687),heltab2x32(:,:,687))
  call Hloop_Q_A(ntryL,G1H16(335),33,0,G2H16(257),n2h16(273))
  call Hloop_AQ_V(ntryL,G1H32(384),ex1(:),G1H16(335),m3h2x16(:,688),heltab2x32(:,:,688))
  call Hloop_AQ_Z(ntryL,G1H32(385),ex1(:),G1H16(336),ngZl,m3h2x16(:,689),heltab2x32(:,:,689))
  call Hloop_SQ_A(ntryL,G0H32(305),ex1(:),G0H16(97),ngPnl,m3h2x16(:,690),heltab2x32(:,:,690))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(337),n2h16(274))
  call Hloop_SQ_A(ntryL,G1H32(386),ex1(:),G1H16(338),ngPnl,m3h2x16(:,691),heltab2x32(:,:,691))
  call Hloop_Q_A(ntryL,G1H16(338),33,0,G2H16(258),n2h16(275))
  call Hloop_SQ_A(ntryL,G1H32(387),ex1(:),G1H16(338),ngPnl,m3h2x16(:,692),heltab2x32(:,:,692))
  call Hloop_Q_A(ntryL,G1H16(338),33,0,G2H16(259),n2h16(276))
  call Hloop_SQ_A(ntryL,G1H32(388),ex1(:),G1H16(338),ngPnl,m3h2x16(:,693),heltab2x32(:,:,693))
  call Hloop_Q_A(ntryL,G1H16(338),33,0,G2H16(260),n2h16(277))
  call Hloop_WQ_A(ntryL,G0H32(306),ex1(:),G0H16(97),m3h2x16(:,694),heltab2x32(:,:,694))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(338),n2h16(278))
  call Hloop_SQ_A(ntryL,G0H32(307),ex1(:),G0H16(97),ngPnl,m3h2x16(:,695),heltab2x32(:,:,695))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(339),n2h16(279))
  call Hloop_SQ_A(ntryL,G0H32(308),ex1(:),G0H16(97),ngPnl,m3h2x16(:,696),heltab2x32(:,:,696))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(340),n2h16(280))
  call Hloop_SQ_A(ntryL,G1H32(389),ex1(:),G1H16(341),ngPnl,m3h2x16(:,697),heltab2x32(:,:,697))
  call Hloop_Q_A(ntryL,G1H16(341),33,0,G2H16(261),n2h16(281))
  call Hloop_SQ_A(ntryL,G0H32(309),ex1(:),G0H16(97),ngPnl,m3h2x16(:,698),heltab2x32(:,:,698))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(341),n2h16(282))
  call Hloop_SQ_A(ntryL,G1H32(390),ex1(:),G1H16(342),ngPnl,m3h2x16(:,699),heltab2x32(:,:,699))
  call Hloop_Q_A(ntryL,G1H16(342),33,0,G2H16(262),n2h16(283))
  call Hloop_SQ_A(ntryL,G1H32(391),ex1(:),G1H16(342),ngPnl,m3h2x16(:,700),heltab2x32(:,:,700))
  call Hloop_Q_A(ntryL,G1H16(342),33,0,G2H16(263),n2h16(284))
  call Hloop_WQ_A(ntryL,G1H32(392),ex1(:),G1H16(342),m3h2x16(:,701),heltab2x32(:,:,701))
  call Hloop_Q_A(ntryL,G1H16(342),33,0,G2H16(264),n2h16(285))
  call Hloop_WQ_A(ntryL,G0H32(310),ex1(:),G0H16(97),m3h2x16(:,702),heltab2x32(:,:,702))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(342),n2h16(286))
  call Hloop_WQ_A(ntryL,G0H32(311),ex1(:),G0H16(97),m3h2x16(:,703),heltab2x32(:,:,703))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(343),n2h16(287))
  call Hloop_WQ_A(ntryL,G0H32(312),ex1(:),G0H16(97),m3h2x16(:,704),heltab2x32(:,:,704))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(344),n2h16(288))
  call Hloop_SQ_A(ntryL,G0H32(313),ex1(:),G0H16(97),ngPnl,m3h2x16(:,705),heltab2x32(:,:,705))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(345),n2h16(289))
  call Hloop_SQ_A(ntryL,G0H32(314),ex1(:),G0H16(97),ngPnl,m3h2x16(:,706),heltab2x32(:,:,706))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(346),n2h16(290))
  call Hloop_SQ_A(ntryL,G0H32(315),ex1(:),G0H16(97),ngPnl,m3h2x16(:,707),heltab2x32(:,:,707))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(347),n2h16(291))
  call Hloop_SQ_A(ntryL,G1H32(393),ex1(:),G1H16(348),ngPnl,m3h2x16(:,708),heltab2x32(:,:,708))
  call Hloop_Q_A(ntryL,G1H16(348),33,0,G2H16(265),n2h16(292))
  call Hloop_WQ_A(ntryL,G1H32(394),ex1(:),G1H16(348),m3h2x16(:,709),heltab2x32(:,:,709))
  call Hloop_Q_A(ntryL,G1H16(348),33,0,G2H16(266),n2h16(293))
  call Hloop_WQ_A(ntryL,G1H32(395),ex1(:),G1H16(348),m3h2x16(:,710),heltab2x32(:,:,710))
  call Hloop_Q_A(ntryL,G1H16(348),33,0,G2H16(267),n2h16(294))
  call Hloop_WQ_A(ntryL,G0H32(316),ex1(:),G0H16(97),m3h2x16(:,711),heltab2x32(:,:,711))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(348),n2h16(295))
  call Hloop_WQ_A(ntryL,G1H32(396),ex1(:),G1H16(349),m3h2x16(:,712),heltab2x32(:,:,712))
  call Hloop_Q_A(ntryL,G1H16(349),33,0,G2H16(268),n2h16(296))
  call Hloop_WQ_A(ntryL,G0H32(317),ex1(:),G0H16(97),m3h2x16(:,713),heltab2x32(:,:,713))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(349),n2h16(297))
  call Hloop_WQ_A(ntryL,G0H32(318),ex1(:),G0H16(97),m3h2x16(:,714),heltab2x32(:,:,714))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(350),n2h16(298))
  call Hloop_SQ_A(ntryL,G0H32(319),ex1(:),G0H16(97),ngPnl,m3h2x16(:,715),heltab2x32(:,:,715))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(351),n2h16(299))
  call Hloop_WQ_A(ntryL,G1H32(397),ex1(:),G1H16(352),m3h2x16(:,716),heltab2x32(:,:,716))
  call Hloop_Q_A(ntryL,G1H16(352),33,0,G2H16(269),n2h16(300))
  call Hloop_WQ_A(ntryL,G1H32(398),ex1(:),G1H16(352),m3h2x16(:,717),heltab2x32(:,:,717))
  call Hloop_Q_A(ntryL,G1H16(352),33,0,G2H16(270),n2h16(301))
  call Hloop_WQ_A(ntryL,G1H32(399),ex1(:),G1H16(352),m3h2x16(:,718),heltab2x32(:,:,718))
  call Hloop_Q_A(ntryL,G1H16(352),33,0,G2H16(271),n2h16(302))
  call Hloop_WQ_A(ntryL,G0H32(320),ex1(:),G0H16(97),m3h2x16(:,719),heltab2x32(:,:,719))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(352),n2h16(303))
  call Hloop_WQ_A(ntryL,G1H32(400),ex1(:),G1H16(353),m3h2x16(:,720),heltab2x32(:,:,720))
  call Hloop_Q_A(ntryL,G1H16(353),33,0,G2H16(272),n2h16(304))
  call Hloop_AQ_S(ntryL,G1H32(401),ex1(:),G1H16(353),ngH,m3h2x16(:,721),heltab2x32(:,:,721))
  call Hloop_AQ_S(ntryL,G1H32(402),ex1(:),G1H16(354),ngX,m3h2x16(:,722),heltab2x32(:,:,722))
  call Hloop_SQ_A(ntryL,G1H32(403),ex1(:),G1H16(355),ngPnl,m3h2x16(:,723),heltab2x32(:,:,723))
  call Hloop_Q_A(ntryL,G1H16(355),33,0,G2H16(273),n2h16(305))
  call Hloop_AQ_V(ntryL,G1H32(404),ex1(:),G1H16(355),m3h2x16(:,724),heltab2x32(:,:,724))
  call Hloop_AQ_Z(ntryL,G1H32(405),ex1(:),G1H16(356),ngZl,m3h2x16(:,725),heltab2x32(:,:,725))
  call Hloop_SQ_A(ntryL,G0H32(321),ex1(:),G0H16(97),ngPnl,m3h2x16(:,726),heltab2x32(:,:,726))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(357),n2h16(306))
  call Hloop_SQ_A(ntryL,G1H32(406),ex1(:),G1H16(358),ngPnl,m3h2x16(:,727),heltab2x32(:,:,727))
  call Hloop_Q_A(ntryL,G1H16(358),33,0,G2H16(274),n2h16(307))
  call Hloop_SQ_A(ntryL,G1H32(407),ex1(:),G1H16(358),ngPnl,m3h2x16(:,728),heltab2x32(:,:,728))
  call Hloop_Q_A(ntryL,G1H16(358),33,0,G2H16(275),n2h16(308))
  call Hloop_SQ_A(ntryL,G1H32(408),ex1(:),G1H16(358),ngPnl,m3h2x16(:,729),heltab2x32(:,:,729))
  call Hloop_Q_A(ntryL,G1H16(358),33,0,G2H16(276),n2h16(309))
  call Hloop_WQ_A(ntryL,G0H32(322),ex1(:),G0H16(97),m3h2x16(:,730),heltab2x32(:,:,730))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(358),n2h16(310))
  call Hloop_SQ_A(ntryL,G0H32(323),ex1(:),G0H16(97),ngPnl,m3h2x16(:,731),heltab2x32(:,:,731))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(359),n2h16(311))
  call Hloop_SQ_A(ntryL,G0H32(324),ex1(:),G0H16(97),ngPnl,m3h2x16(:,732),heltab2x32(:,:,732))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(360),n2h16(312))
  call Hloop_SQ_A(ntryL,G1H32(409),ex1(:),G1H16(361),ngPnl,m3h2x16(:,733),heltab2x32(:,:,733))
  call Hloop_Q_A(ntryL,G1H16(361),33,0,G2H16(277),n2h16(313))
  call Hloop_SQ_A(ntryL,G0H32(325),ex1(:),G0H16(97),ngPnl,m3h2x16(:,734),heltab2x32(:,:,734))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(361),n2h16(314))
  call Hloop_SQ_A(ntryL,G1H32(410),ex1(:),G1H16(362),ngPnl,m3h2x16(:,735),heltab2x32(:,:,735))
  call Hloop_Q_A(ntryL,G1H16(362),33,0,G2H16(278),n2h16(315))
  call Hloop_SQ_A(ntryL,G1H32(411),ex1(:),G1H16(362),ngPnl,m3h2x16(:,736),heltab2x32(:,:,736))
  call Hloop_Q_A(ntryL,G1H16(362),33,0,G2H16(279),n2h16(316))
  call Hloop_WQ_A(ntryL,G1H32(412),ex1(:),G1H16(362),m3h2x16(:,737),heltab2x32(:,:,737))
  call Hloop_Q_A(ntryL,G1H16(362),33,0,G2H16(280),n2h16(317))
  call Hloop_WQ_A(ntryL,G0H32(326),ex1(:),G0H16(97),m3h2x16(:,738),heltab2x32(:,:,738))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(362),n2h16(318))
  call Hloop_WQ_A(ntryL,G0H32(327),ex1(:),G0H16(97),m3h2x16(:,739),heltab2x32(:,:,739))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(363),n2h16(319))
  call Hloop_WQ_A(ntryL,G0H32(328),ex1(:),G0H16(97),m3h2x16(:,740),heltab2x32(:,:,740))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(364),n2h16(320))
  call Hloop_SQ_A(ntryL,G0H32(329),ex1(:),G0H16(97),ngPnl,m3h2x16(:,741),heltab2x32(:,:,741))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(365),n2h16(321))
  call Hloop_SQ_A(ntryL,G0H32(330),ex1(:),G0H16(97),ngPnl,m3h2x16(:,742),heltab2x32(:,:,742))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(366),n2h16(322))
  call Hloop_SQ_A(ntryL,G0H32(331),ex1(:),G0H16(97),ngPnl,m3h2x16(:,743),heltab2x32(:,:,743))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(367),n2h16(323))
  call Hloop_SQ_A(ntryL,G1H32(413),ex1(:),G1H16(368),ngPnl,m3h2x16(:,744),heltab2x32(:,:,744))
  call Hloop_Q_A(ntryL,G1H16(368),33,0,G2H16(281),n2h16(324))
  call Hloop_WQ_A(ntryL,G1H32(414),ex1(:),G1H16(368),m3h2x16(:,745),heltab2x32(:,:,745))
  call Hloop_Q_A(ntryL,G1H16(368),33,0,G2H16(282),n2h16(325))
  call Hloop_WQ_A(ntryL,G1H32(415),ex1(:),G1H16(368),m3h2x16(:,746),heltab2x32(:,:,746))
  call Hloop_Q_A(ntryL,G1H16(368),33,0,G2H16(283),n2h16(326))
  call Hloop_WQ_A(ntryL,G0H32(332),ex1(:),G0H16(97),m3h2x16(:,747),heltab2x32(:,:,747))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(368),n2h16(327))
  call Hloop_WQ_A(ntryL,G1H32(416),ex1(:),G1H16(369),m3h2x16(:,748),heltab2x32(:,:,748))
  call Hloop_Q_A(ntryL,G1H16(369),33,0,G2H16(284),n2h16(328))
  call Hloop_WQ_A(ntryL,G0H32(333),ex1(:),G0H16(97),m3h2x16(:,749),heltab2x32(:,:,749))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(369),n2h16(329))
  call Hloop_WQ_A(ntryL,G0H32(334),ex1(:),G0H16(97),m3h2x16(:,750),heltab2x32(:,:,750))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(370),n2h16(330))
  call Hloop_SQ_A(ntryL,G0H32(335),ex1(:),G0H16(97),ngPnl,m3h2x16(:,751),heltab2x32(:,:,751))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(371),n2h16(331))
  call Hloop_WQ_A(ntryL,G1H32(417),ex1(:),G1H16(372),m3h2x16(:,752),heltab2x32(:,:,752))
  call Hloop_Q_A(ntryL,G1H16(372),33,0,G2H16(285),n2h16(332))
  call Hloop_WQ_A(ntryL,G1H32(418),ex1(:),G1H16(372),m3h2x16(:,753),heltab2x32(:,:,753))
  call Hloop_Q_A(ntryL,G1H16(372),33,0,G2H16(286),n2h16(333))
  call Hloop_WQ_A(ntryL,G1H32(419),ex1(:),G1H16(372),m3h2x16(:,754),heltab2x32(:,:,754))
  call Hloop_Q_A(ntryL,G1H16(372),33,0,G2H16(287),n2h16(334))
  call Hloop_WQ_A(ntryL,G0H32(336),ex1(:),G0H16(97),m3h2x16(:,755),heltab2x32(:,:,755))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(372),n2h16(335))
  call Hloop_WQ_A(ntryL,G1H32(420),ex1(:),G1H16(373),m3h2x16(:,756),heltab2x32(:,:,756))
  call Hloop_Q_A(ntryL,G1H16(373),33,0,G2H16(288),n2h16(336))
  call Hloop_AQ_S(ntryL,G1H32(421),ex1(:),G1H16(373),ngH,m3h2x16(:,757),heltab2x32(:,:,757))
  call Hloop_AQ_S(ntryL,G1H32(422),ex1(:),G1H16(374),ngX,m3h2x16(:,758),heltab2x32(:,:,758))
  call Hloop_SQ_A(ntryL,G1H32(423),ex1(:),G1H16(375),ngPnl,m3h2x16(:,759),heltab2x32(:,:,759))
  call Hloop_Q_A(ntryL,G1H16(375),33,0,G2H16(289),n2h16(337))
  call Hloop_AQ_V(ntryL,G1H32(424),ex1(:),G1H16(375),m3h2x16(:,760),heltab2x32(:,:,760))
  call Hloop_AQ_Z(ntryL,G1H32(425),ex1(:),G1H16(376),ngZl,m3h2x16(:,761),heltab2x32(:,:,761))
  call Hloop_SQ_A(ntryL,G1H32(426),ex1(:),G1H16(377),ngPnl,m3h2x16(:,762),heltab2x32(:,:,762))
  call Hloop_Q_A(ntryL,G1H16(377),33,0,G2H16(290),n2h16(338))
  call Hloop_SQ_A(ntryL,G0H32(337),ex1(:),G0H16(97),ngPnl,m3h2x16(:,763),heltab2x32(:,:,763))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(377),n2h16(339))
  call Hloop_SQ_A(ntryL,G1H32(427),ex1(:),G1H16(378),ngPnl,m3h2x16(:,764),heltab2x32(:,:,764))
  call Hloop_Q_A(ntryL,G1H16(378),33,0,G2H16(291),n2h16(340))
  call Hloop_SQ_A(ntryL,G1H32(428),ex1(:),G1H16(378),ngPnl,m3h2x16(:,765),heltab2x32(:,:,765))
  call Hloop_Q_A(ntryL,G1H16(378),33,0,G2H16(292),n2h16(341))
  call Hloop_WQ_A(ntryL,G0H32(338),ex1(:),G0H16(97),m3h2x16(:,766),heltab2x32(:,:,766))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(378),n2h16(342))
  call Hloop_SQ_A(ntryL,G0H32(339),ex1(:),G0H16(97),ngPnl,m3h2x16(:,767),heltab2x32(:,:,767))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(379),n2h16(343))
  call Hloop_SQ_A(ntryL,G1H32(429),ex1(:),G1H16(380),ngPnl,m3h2x16(:,768),heltab2x32(:,:,768))
  call Hloop_Q_A(ntryL,G1H16(380),33,0,G2H16(293),n2h16(344))
  call Hloop_SQ_A(ntryL,G0H32(340),ex1(:),G0H16(97),ngPnl,m3h2x16(:,769),heltab2x32(:,:,769))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(380),n2h16(345))
  call Hloop_SQ_A(ntryL,G1H32(430),ex1(:),G1H16(381),ngPnl,m3h2x16(:,770),heltab2x32(:,:,770))
  call Hloop_Q_A(ntryL,G1H16(381),33,0,G2H16(294),n2h16(346))
  call Hloop_SQ_A(ntryL,G0H32(341),ex1(:),G0H16(97),ngPnl,m3h2x16(:,771),heltab2x32(:,:,771))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(381),n2h16(347))
  call Hloop_SQ_A(ntryL,G1H32(431),ex1(:),G1H16(382),ngPnl,m3h2x16(:,772),heltab2x32(:,:,772))
  call Hloop_Q_A(ntryL,G1H16(382),33,0,G2H16(295),n2h16(348))
  call Hloop_WQ_A(ntryL,G0H32(342),ex1(:),G0H16(97),m3h2x16(:,773),heltab2x32(:,:,773))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(382),n2h16(349))
  call Hloop_WQ_A(ntryL,G1H32(432),ex1(:),G1H16(383),m3h2x16(:,774),heltab2x32(:,:,774))
  call Hloop_Q_A(ntryL,G1H16(383),33,0,G2H16(296),n2h16(350))
  call Hloop_WQ_A(ntryL,G0H32(343),ex1(:),G0H16(97),m3h2x16(:,775),heltab2x32(:,:,775))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(383),n2h16(351))
  call Hloop_WQ_A(ntryL,G0H32(344),ex1(:),G0H16(97),m3h2x16(:,776),heltab2x32(:,:,776))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(384),n2h16(352))
  call Hloop_SQ_A(ntryL,G0H32(345),ex1(:),G0H16(97),ngPnl,m3h2x16(:,777),heltab2x32(:,:,777))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(385),n2h16(353))
  call Hloop_SQ_A(ntryL,G0H32(346),ex1(:),G0H16(97),ngPnl,m3h2x16(:,778),heltab2x32(:,:,778))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(386),n2h16(354))
  call Hloop_SQ_A(ntryL,G1H32(433),ex1(:),G1H16(387),ngPnl,m3h2x16(:,779),heltab2x32(:,:,779))
  call Hloop_Q_A(ntryL,G1H16(387),33,0,G2H16(297),n2h16(355))
  call Hloop_SQ_A(ntryL,G0H32(347),ex1(:),G0H16(97),ngPnl,m3h2x16(:,780),heltab2x32(:,:,780))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(387),n2h16(356))
  call Hloop_WQ_A(ntryL,G1H32(434),ex1(:),G1H16(388),m3h2x16(:,781),heltab2x32(:,:,781))
  call Hloop_Q_A(ntryL,G1H16(388),33,0,G2H16(298),n2h16(357))
  call Hloop_WQ_A(ntryL,G0H32(348),ex1(:),G0H16(97),m3h2x16(:,782),heltab2x32(:,:,782))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(388),n2h16(358))
  call Hloop_WQ_A(ntryL,G1H32(435),ex1(:),G1H16(389),m3h2x16(:,783),heltab2x32(:,:,783))
  call Hloop_Q_A(ntryL,G1H16(389),33,0,G2H16(299),n2h16(359))
  call Hloop_WQ_A(ntryL,G0H32(349),ex1(:),G0H16(97),m3h2x16(:,784),heltab2x32(:,:,784))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(389),n2h16(360))
  call Hloop_WQ_A(ntryL,G1H32(436),ex1(:),G1H16(390),m3h2x16(:,785),heltab2x32(:,:,785))
  call Hloop_Q_A(ntryL,G1H16(390),33,0,G2H16(300),n2h16(361))
  call Hloop_WQ_A(ntryL,G0H32(350),ex1(:),G0H16(97),m3h2x16(:,786),heltab2x32(:,:,786))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(390),n2h16(362))
  call Hloop_SQ_A(ntryL,G0H32(351),ex1(:),G0H16(97),ngPnl,m3h2x16(:,787),heltab2x32(:,:,787))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(391),n2h16(363))
  call Hloop_WQ_A(ntryL,G1H32(437),ex1(:),G1H16(392),m3h2x16(:,788),heltab2x32(:,:,788))
  call Hloop_Q_A(ntryL,G1H16(392),33,0,G2H16(301),n2h16(364))
  call Hloop_WQ_A(ntryL,G1H32(438),ex1(:),G1H16(392),m3h2x16(:,789),heltab2x32(:,:,789))
  call Hloop_Q_A(ntryL,G1H16(392),33,0,G2H16(302),n2h16(365))
  call Hloop_WQ_A(ntryL,G0H32(352),ex1(:),G0H16(97),m3h2x16(:,790),heltab2x32(:,:,790))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(392),n2h16(366))
  call Hloop_WQ_A(ntryL,G1H32(439),ex1(:),G1H16(393),m3h2x16(:,791),heltab2x32(:,:,791))
  call Hloop_Q_A(ntryL,G1H16(393),33,0,G2H16(303),n2h16(367))
  call Hloop_WQ_A(ntryL,G1H32(440),ex1(:),G1H16(393),m3h2x16(:,792),heltab2x32(:,:,792))
  call Hloop_Q_A(ntryL,G1H16(393),33,0,G2H16(304),n2h16(368))
  call Hloop_AQ_S(ntryL,G1H32(441),ex1(:),G1H16(393),ngH,m3h2x16(:,793),heltab2x32(:,:,793))
  call Hloop_AQ_S(ntryL,G1H32(442),ex1(:),G1H16(394),ngX,m3h2x16(:,794),heltab2x32(:,:,794))
  call Hloop_SQ_A(ntryL,G1H32(443),ex1(:),G1H16(395),ngPnl,m3h2x16(:,795),heltab2x32(:,:,795))
  call Hloop_Q_A(ntryL,G1H16(395),33,0,G2H16(305),n2h16(369))
  call Hloop_AQ_V(ntryL,G1H32(444),ex1(:),G1H16(395),m3h2x16(:,796),heltab2x32(:,:,796))
  call Hloop_AQ_Z(ntryL,G1H32(445),ex1(:),G1H16(396),ngZl,m3h2x16(:,797),heltab2x32(:,:,797))
  call Hloop_SQ_A(ntryL,G0H32(353),ex1(:),G0H16(97),ngPnl,m3h2x16(:,798),heltab2x32(:,:,798))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(397),n2h16(370))
  call Hloop_SQ_A(ntryL,G1H32(446),ex1(:),G1H16(398),ngPnl,m3h2x16(:,799),heltab2x32(:,:,799))
  call Hloop_Q_A(ntryL,G1H16(398),33,0,G2H16(306),n2h16(371))
  call Hloop_SQ_A(ntryL,G1H32(447),ex1(:),G1H16(398),ngPnl,m3h2x16(:,800),heltab2x32(:,:,800))
  call Hloop_Q_A(ntryL,G1H16(398),33,0,G2H16(307),n2h16(372))
  call Hloop_SQ_A(ntryL,G1H32(448),ex1(:),G1H16(398),ngPnl,m3h2x16(:,801),heltab2x32(:,:,801))
  call Hloop_Q_A(ntryL,G1H16(398),33,0,G2H16(308),n2h16(373))
  call Hloop_WQ_A(ntryL,G0H32(354),ex1(:),G0H16(97),m3h2x16(:,802),heltab2x32(:,:,802))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(398),n2h16(374))
  call Hloop_SQ_A(ntryL,G0H32(355),ex1(:),G0H16(97),ngPnl,m3h2x16(:,803),heltab2x32(:,:,803))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(399),n2h16(375))
  call Hloop_SQ_A(ntryL,G0H32(356),ex1(:),G0H16(97),ngPnl,m3h2x16(:,804),heltab2x32(:,:,804))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(400),n2h16(376))
  call Hloop_SQ_A(ntryL,G1H32(449),ex1(:),G1H16(401),ngPnl,m3h2x16(:,805),heltab2x32(:,:,805))
  call Hloop_Q_A(ntryL,G1H16(401),33,0,G2H16(309),n2h16(377))
  call Hloop_SQ_A(ntryL,G0H32(357),ex1(:),G0H16(97),ngPnl,m3h2x16(:,806),heltab2x32(:,:,806))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(401),n2h16(378))
  call Hloop_SQ_A(ntryL,G1H32(450),ex1(:),G1H16(402),ngPnl,m3h2x16(:,807),heltab2x32(:,:,807))
  call Hloop_Q_A(ntryL,G1H16(402),33,0,G2H16(310),n2h16(379))
  call Hloop_SQ_A(ntryL,G1H32(451),ex1(:),G1H16(402),ngPnl,m3h2x16(:,808),heltab2x32(:,:,808))
  call Hloop_Q_A(ntryL,G1H16(402),33,0,G2H16(311),n2h16(380))
  call Hloop_WQ_A(ntryL,G1H32(452),ex1(:),G1H16(402),m3h2x16(:,809),heltab2x32(:,:,809))
  call Hloop_Q_A(ntryL,G1H16(402),33,0,G2H16(312),n2h16(381))
  call Hloop_WQ_A(ntryL,G0H32(358),ex1(:),G0H16(97),m3h2x16(:,810),heltab2x32(:,:,810))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(402),n2h16(382))
  call Hloop_WQ_A(ntryL,G0H32(359),ex1(:),G0H16(97),m3h2x16(:,811),heltab2x32(:,:,811))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(403),n2h16(383))
  call Hloop_WQ_A(ntryL,G0H32(360),ex1(:),G0H16(97),m3h2x16(:,812),heltab2x32(:,:,812))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(404),n2h16(384))
  call Hloop_SQ_A(ntryL,G0H32(361),ex1(:),G0H16(97),ngPnl,m3h2x16(:,813),heltab2x32(:,:,813))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(405),n2h16(385))
  call Hloop_SQ_A(ntryL,G0H32(362),ex1(:),G0H16(97),ngPnl,m3h2x16(:,814),heltab2x32(:,:,814))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(406),n2h16(386))
  call Hloop_SQ_A(ntryL,G0H32(363),ex1(:),G0H16(97),ngPnl,m3h2x16(:,815),heltab2x32(:,:,815))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(407),n2h16(387))
  call Hloop_SQ_A(ntryL,G1H32(453),ex1(:),G1H16(408),ngPnl,m3h2x16(:,816),heltab2x32(:,:,816))
  call Hloop_Q_A(ntryL,G1H16(408),33,0,G2H16(313),n2h16(388))
  call Hloop_WQ_A(ntryL,G1H32(454),ex1(:),G1H16(408),m3h2x16(:,817),heltab2x32(:,:,817))
  call Hloop_Q_A(ntryL,G1H16(408),33,0,G2H16(314),n2h16(389))
  call Hloop_WQ_A(ntryL,G1H32(455),ex1(:),G1H16(408),m3h2x16(:,818),heltab2x32(:,:,818))
  call Hloop_Q_A(ntryL,G1H16(408),33,0,G2H16(315),n2h16(390))
  call Hloop_WQ_A(ntryL,G0H32(364),ex1(:),G0H16(97),m3h2x16(:,819),heltab2x32(:,:,819))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(408),n2h16(391))
  call Hloop_WQ_A(ntryL,G1H32(456),ex1(:),G1H16(409),m3h2x16(:,820),heltab2x32(:,:,820))
  call Hloop_Q_A(ntryL,G1H16(409),33,0,G2H16(316),n2h16(392))
  call Hloop_WQ_A(ntryL,G0H32(365),ex1(:),G0H16(97),m3h2x16(:,821),heltab2x32(:,:,821))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(409),n2h16(393))
  call Hloop_WQ_A(ntryL,G0H32(366),ex1(:),G0H16(97),m3h2x16(:,822),heltab2x32(:,:,822))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(410),n2h16(394))
  call Hloop_SQ_A(ntryL,G0H32(367),ex1(:),G0H16(97),ngPnl,m3h2x16(:,823),heltab2x32(:,:,823))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(411),n2h16(395))
  call Hloop_WQ_A(ntryL,G1H32(457),ex1(:),G1H16(412),m3h2x16(:,824),heltab2x32(:,:,824))
  call Hloop_Q_A(ntryL,G1H16(412),33,0,G2H16(317),n2h16(396))
  call Hloop_WQ_A(ntryL,G1H32(458),ex1(:),G1H16(412),m3h2x16(:,825),heltab2x32(:,:,825))
  call Hloop_Q_A(ntryL,G1H16(412),33,0,G2H16(318),n2h16(397))
  call Hloop_WQ_A(ntryL,G1H32(459),ex1(:),G1H16(412),m3h2x16(:,826),heltab2x32(:,:,826))
  call Hloop_Q_A(ntryL,G1H16(412),33,0,G2H16(319),n2h16(398))
  call Hloop_WQ_A(ntryL,G0H32(368),ex1(:),G0H16(97),m3h2x16(:,827),heltab2x32(:,:,827))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(412),n2h16(399))
  call Hloop_WQ_A(ntryL,G1H32(460),ex1(:),G1H16(413),m3h2x16(:,828),heltab2x32(:,:,828))
  call Hloop_Q_A(ntryL,G1H16(413),33,0,G2H16(320),n2h16(400))
  call Hloop_AQ_S(ntryL,G1H32(461),ex1(:),G1H16(413),ngH,m3h2x16(:,829),heltab2x32(:,:,829))
  call Hloop_AQ_S(ntryL,G1H32(462),ex1(:),G1H16(414),ngX,m3h2x16(:,830),heltab2x32(:,:,830))
  call Hloop_SQ_A(ntryL,G1H32(463),ex1(:),G1H16(415),ngPnl,m3h2x16(:,831),heltab2x32(:,:,831))
  call Hloop_Q_A(ntryL,G1H16(415),33,0,G2H16(321),n2h16(401))
  call Hloop_AQ_V(ntryL,G1H32(464),ex1(:),G1H16(415),m3h2x16(:,832),heltab2x32(:,:,832))
  call Hloop_AQ_Z(ntryL,G1H32(465),ex1(:),G1H16(416),ngZl,m3h2x16(:,833),heltab2x32(:,:,833))
  call Hloop_SQ_A(ntryL,G1H32(466),ex1(:),G1H16(417),ngPnl,m3h2x16(:,834),heltab2x32(:,:,834))
  call Hloop_Q_A(ntryL,G1H16(417),33,0,G2H16(322),n2h16(402))
  call Hloop_SQ_A(ntryL,G0H32(369),ex1(:),G0H16(97),ngPnl,m3h2x16(:,835),heltab2x32(:,:,835))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(417),n2h16(403))
  call Hloop_SQ_A(ntryL,G1H32(467),ex1(:),G1H16(418),ngPnl,m3h2x16(:,836),heltab2x32(:,:,836))
  call Hloop_Q_A(ntryL,G1H16(418),33,0,G2H16(323),n2h16(404))
  call Hloop_SQ_A(ntryL,G1H32(468),ex1(:),G1H16(418),ngPnl,m3h2x16(:,837),heltab2x32(:,:,837))
  call Hloop_Q_A(ntryL,G1H16(418),33,0,G2H16(324),n2h16(405))
  call Hloop_WQ_A(ntryL,G0H32(370),ex1(:),G0H16(97),m3h2x16(:,838),heltab2x32(:,:,838))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(418),n2h16(406))
  call Hloop_SQ_A(ntryL,G0H32(371),ex1(:),G0H16(97),ngPnl,m3h2x16(:,839),heltab2x32(:,:,839))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(419),n2h16(407))
  call Hloop_SQ_A(ntryL,G1H32(469),ex1(:),G1H16(420),ngPnl,m3h2x16(:,840),heltab2x32(:,:,840))
  call Hloop_Q_A(ntryL,G1H16(420),33,0,G2H16(325),n2h16(408))
  call Hloop_SQ_A(ntryL,G0H32(372),ex1(:),G0H16(97),ngPnl,m3h2x16(:,841),heltab2x32(:,:,841))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(420),n2h16(409))
  call Hloop_SQ_A(ntryL,G1H32(470),ex1(:),G1H16(421),ngPnl,m3h2x16(:,842),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G1H16(421),33,0,G2H16(326),n2h16(410))
  call Hloop_SQ_A(ntryL,G0H32(373),ex1(:),G0H16(97),ngPnl,m3h2x16(:,843),heltab2x32(:,:,843))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(421),n2h16(411))
  call Hloop_SQ_A(ntryL,G1H32(471),ex1(:),G1H16(422),ngPnl,m3h2x16(:,844),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G1H16(422),33,0,G2H16(327),n2h16(412))
  call Hloop_WQ_A(ntryL,G0H32(374),ex1(:),G0H16(97),m3h2x16(:,845),heltab2x32(:,:,845))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(422),n2h16(413))
  call Hloop_WQ_A(ntryL,G1H32(472),ex1(:),G1H16(423),m3h2x16(:,846),heltab2x32(:,:,846))
  call Hloop_Q_A(ntryL,G1H16(423),33,0,G2H16(328),n2h16(414))
  call Hloop_WQ_A(ntryL,G0H32(375),ex1(:),G0H16(97),m3h2x16(:,847),heltab2x32(:,:,847))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(423),n2h16(415))
  call Hloop_WQ_A(ntryL,G0H32(376),ex1(:),G0H16(97),m3h2x16(:,848),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(424),n2h16(416))
  call Hloop_SQ_A(ntryL,G0H32(377),ex1(:),G0H16(97),ngPnl,m3h2x16(:,849),heltab2x32(:,:,849))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(425),n2h16(417))
  call Hloop_SQ_A(ntryL,G0H32(378),ex1(:),G0H16(97),ngPnl,m3h2x16(:,850),heltab2x32(:,:,850))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(426),n2h16(418))
  call Hloop_SQ_A(ntryL,G1H32(473),ex1(:),G1H16(427),ngPnl,m3h2x16(:,851),heltab2x32(:,:,851))
  call Hloop_Q_A(ntryL,G1H16(427),33,0,G2H16(329),n2h16(419))
  call Hloop_SQ_A(ntryL,G0H32(379),ex1(:),G0H16(97),ngPnl,m3h2x16(:,852),heltab2x32(:,:,852))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(427),n2h16(420))
  call Hloop_WQ_A(ntryL,G1H32(474),ex1(:),G1H16(428),m3h2x16(:,853),heltab2x32(:,:,853))
  call Hloop_Q_A(ntryL,G1H16(428),33,0,G2H16(330),n2h16(421))
  call Hloop_WQ_A(ntryL,G0H32(380),ex1(:),G0H16(97),m3h2x16(:,854),heltab2x32(:,:,854))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(428),n2h16(422))
  call Hloop_WQ_A(ntryL,G1H32(475),ex1(:),G1H16(429),m3h2x16(:,855),heltab2x32(:,:,855))
  call Hloop_Q_A(ntryL,G1H16(429),33,0,G2H16(331),n2h16(423))
  call Hloop_WQ_A(ntryL,G0H32(381),ex1(:),G0H16(97),m3h2x16(:,856),heltab2x32(:,:,856))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(429),n2h16(424))
  call Hloop_WQ_A(ntryL,G1H32(476),ex1(:),G1H16(430),m3h2x16(:,857),heltab2x32(:,:,857))
  call Hloop_Q_A(ntryL,G1H16(430),33,0,G2H16(332),n2h16(425))
  call Hloop_WQ_A(ntryL,G0H32(382),ex1(:),G0H16(97),m3h2x16(:,858),heltab2x32(:,:,858))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(430),n2h16(426))
  call Hloop_SQ_A(ntryL,G0H32(383),ex1(:),G0H16(97),ngPnl,m3h2x16(:,859),heltab2x32(:,:,859))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(431),n2h16(427))
  call Hloop_WQ_A(ntryL,G1H32(477),ex1(:),G1H16(432),m3h2x16(:,860),heltab2x32(:,:,860))
  call Hloop_Q_A(ntryL,G1H16(432),33,0,G2H16(333),n2h16(428))
  call Hloop_WQ_A(ntryL,G1H32(478),ex1(:),G1H16(432),m3h2x16(:,861),heltab2x32(:,:,861))
  call Hloop_Q_A(ntryL,G1H16(432),33,0,G2H16(334),n2h16(429))
  call Hloop_WQ_A(ntryL,G0H32(384),ex1(:),G0H16(97),m3h2x16(:,862),heltab2x32(:,:,862))
  call Hloop_Q_A(ntryL,G0H16(97),33,0,G1H16(432),n2h16(430))
  call Hloop_WQ_A(ntryL,G1H32(479),ex1(:),G1H16(433),m3h2x16(:,863),heltab2x32(:,:,863))
  call Hloop_Q_A(ntryL,G1H16(433),33,0,G2H16(335),n2h16(431))
  call Hloop_WQ_A(ntryL,G1H32(480),ex1(:),G1H16(433),m3h2x16(:,864),heltab2x32(:,:,864))
  call Hloop_Q_A(ntryL,G1H16(433),33,0,G2H16(336),n2h16(432))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(3),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G0H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(7),[G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(9),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(8),[G0H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(10),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(11),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(12),[G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(15),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(18),[G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(19),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(25),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(20),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(21),[G0H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(22),[G0H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(23),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(24),[G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(27),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(30),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(31),[G0H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(33),[G0H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(32),[G0H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(34),[G0H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(35),[G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(36),[G0H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(39),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(42),[G0H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(43),[G0H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(44),[G0H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(45),[G0H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(63),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(46),[G0H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(47),[G0H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(64),[G1H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(48),[G0H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(49),[G1H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(54),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(50),[G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(51),[G1H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(52),[G1H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(57),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(58),[G1H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(53),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(60),[G1H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(55),[G1H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(56),[G1H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(61),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(62),[G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(63),[G1H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(59),[G1H16(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(64),[G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(65),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(70),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(66),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(67),[G1H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(68),[G1H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(73),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(74),[G1H16(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(69),[G1H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(76),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(71),[G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(72),[G1H16(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(77),[G1H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(78),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(79),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(75),[G1H16(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(80),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(83),[G0H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(107),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(86),[G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(87),[G0H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(114),[G1H16(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(88),[G0H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(89),[G0H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(116),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G1H16(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(119),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(90),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(91),[G0H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(92),[G0H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(95),[G0H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(124),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(98),[G0H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(126),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(99),[G0H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(129),[G1H16(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(101),[G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(130),[G1H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(132),[G1H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(100),[G0H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(134),[G1H16(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(102),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(135),[G1H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(103),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(136),[G1H16(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(104),[G0H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(107),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G1H16(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(110),[G0H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(111),[G0H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(113),[G0H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(145),[G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(146),[G1H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(147),[G1H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(148),[G1H16(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(112),[G0H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(114),[G0H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(115),[G0H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(152),[G1H16(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(116),[G0H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(119),[G0H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(155),[G1H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(156),[G1H16(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(122),[G0H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(123),[G0H16(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(125),[G0H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(161),[G1H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(162),[G1H16(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(163),[G1H16(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(164),[G1H16(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(124),[G0H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(126),[G0H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(127),[G0H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(167),[G1H16(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(168),[G1H16(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(128),[G0H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(129),[G1H16(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(134),[G1H16(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(130),[G1H16(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(131),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(132),[G1H16(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(137),[G1H16(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(138),[G1H16(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(133),[G1H16(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(140),[G1H16(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(135),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(136),[G1H16(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(141),[G1H16(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(142),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(143),[G1H16(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(139),[G1H16(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(144),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(145),[G1H16(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(146),[G1H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(150),[G1H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(147),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(148),[G1H16(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(153),[G1H16(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(149),[G1H16(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(154),[G1H16(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(151),[G1H16(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(156),[G1H16(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(152),[G1H16(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(157),[G1H16(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(158),[G1H16(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(155),[G1H16(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(159),[G1H16(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(160),[G1H16(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(163),[G0H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(211),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(212),[G1H16(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(166),[G0H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(167),[G0H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(169),[G0H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(218),[G1H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(219),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(220),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(168),[G0H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(170),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(171),[G0H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(223),[G1H16(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(224),[G1H16(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(172),[G0H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(175),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(228),[G1H16(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(178),[G0H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(230),[G1H16(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(179),[G0H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(233),[G1H16(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(181),[G0H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(236),[G1H16(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(180),[G0H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(238),[G1H16(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(182),[G0H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(239),[G1H16(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(183),[G0H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(240),[G1H16(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(184),[G0H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(187),[G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(243),[G1H16(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(244),[G1H16(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(190),[G0H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(191),[G0H16(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(193),[G0H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(249),[G1H16(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(250),[G1H16(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(251),[G1H16(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(252),[G1H16(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(192),[G0H16(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(194),[G0H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(195),[G0H16(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(255),[G1H16(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(256),[G1H16(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(196),[G0H16(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(199),[G0H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(259),[G1H16(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(260),[G1H16(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(202),[G0H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(203),[G0H16(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(205),[G0H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(265),[G1H16(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(266),[G1H16(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(267),[G1H16(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(268),[G1H16(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(204),[G0H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(206),[G0H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(207),[G0H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(271),[G1H16(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(272),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(208),[G0H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(209),[G1H16(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(214),[G1H16(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(210),[G1H16(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(211),[G1H16(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(212),[G1H16(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(217),[G1H16(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(218),[G1H16(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(213),[G1H16(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(220),[G1H16(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(215),[G1H16(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(216),[G1H16(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(221),[G1H16(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(222),[G1H16(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(223),[G1H16(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(219),[G1H16(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(224),[G1H16(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(225),[G1H16(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(226),[G1H16(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(230),[G1H16(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(227),[G1H16(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(228),[G1H16(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(233),[G1H16(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(229),[G1H16(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(234),[G1H16(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(231),[G1H16(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(236),[G1H16(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(232),[G1H16(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(237),[G1H16(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(238),[G1H16(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(235),[G1H16(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(239),[G1H16(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(240),[G1H16(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(241),[G1H16(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(248),[G1H16(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(242),[G1H16(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(243),[G1H16(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(244),[G1H16(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(250),[G1H16(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(251),[G1H16(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(245),[G1H16(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(252),[G1H16(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(246),[G1H16(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(247),[G1H16(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(253),[G1H16(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(254),[G1H16(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(255),[G1H16(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(249),[G1H16(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(256),[G1H16(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(257),[G1H16(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(264),[G1H16(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(258),[G1H16(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(259),[G1H16(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(260),[G1H16(344)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(266),[G1H16(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(267),[G1H16(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(261),[G1H16(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(268),[G1H16(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(262),[G1H16(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(263),[G1H16(350)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(269),[G1H16(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(270),[G1H16(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(271),[G1H16(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(265),[G1H16(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(272),[G1H16(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(273),[G1H16(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(280),[G1H16(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(274),[G1H16(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(275),[G1H16(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(276),[G1H16(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(282),[G1H16(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(283),[G1H16(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(277),[G1H16(368)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(284),[G1H16(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(278),[G1H16(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(279),[G1H16(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(285),[G1H16(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(286),[G1H16(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(287),[G1H16(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(281),[G1H16(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(288),[G1H16(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(289),[G1H16(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(290),[G1H16(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(296),[G1H16(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(291),[G1H16(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(292),[G1H16(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(298),[G1H16(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(293),[G1H16(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(299),[G1H16(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(294),[G1H16(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(300),[G1H16(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(295),[G1H16(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(301),[G1H16(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(302),[G1H16(386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(297),[G1H16(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(303),[G1H16(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(304),[G1H16(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(305),[G1H16(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(312),[G1H16(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(306),[G1H16(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(307),[G1H16(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(308),[G1H16(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(314),[G1H16(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(315),[G1H16(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(309),[G1H16(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(316),[G1H16(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(310),[G1H16(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(311),[G1H16(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(317),[G1H16(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(318),[G1H16(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(319),[G1H16(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(313),[G1H16(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(320),[G1H16(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(321),[G1H16(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(322),[G1H16(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(328),[G1H16(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(323),[G1H16(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(324),[G1H16(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(330),[G1H16(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(325),[G1H16(428)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(331),[G1H16(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(326),[G1H16(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(332),[G1H16(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(327),[G1H16(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(333),[G1H16(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(334),[G1H16(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(329),[G1H16(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(335),[G1H16(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(336),[G1H16(431)])
  call Hloop_QA_S(ntryL,G2H16(1),ex2(:),G2H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_S(ntryL,G2H16(2),ex2(:),G2H8(2),ngX,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(1),mass5set(:,1),  & 
G1H16(433),G1H16(1),G1H16(2),G1H16(4),G1H16(6),G1H16(7),16)
  call HG1shiftOLR(G1H16(1),16,16)
  call Hloop_QA_V(ntryL,G2H16(4),ex2(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_Z(ntryL,G2H16(5),ex2(:),G2H8(4),ngZl,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_SA_Q(ntryL,G1H16(3),ex2(:),G1H8(1),ngPln,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(5),n2h8(1))
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(1),mass5set(:,1),  & 
G1H16(8),G1H16(12),G1H16(14),G1H16(17),G1H16(18),G1H16(19),16)
  call HG1shiftOLR(G1H16(12),16,16)
  call Hloop_WA_Q(ntryL,G1H16(5),ex2(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(6),n2h8(2))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(1),mass5set(:,1),  & 
G1H16(21),G1H16(22),G1H16(24),G1H16(26),G1H16(29),G1H16(33),16)
  call HG1shiftOLR(G1H16(22),16,16)
  call Hloop_SA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),ngPln,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(7),n2h8(3))
  call Hotf_5pt_reduction(G2H16(9),RedSet_5(1),mass5set(:,1),  & 
G1H16(34),G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(45),16)
  call HG1shiftOLR(G1H16(37),16,16)
  call Hloop_WA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(8),n2h8(4))
  call Hloop_SA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),ngPln,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(9),n2h8(5))
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(1),mass5set(:,1),  & 
G1H16(46),G1H16(49),G1H16(50),G1H16(51),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(49),16,16)
  call Hloop_WA_Q(ntryL,G1H16(13),ex2(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(10),n2h8(6))
  call Hotf_5pt_reduction(G2H16(10),RedSet_5(1),mass5set(:,1),  & 
G1H16(56),G1H16(58),G1H16(61),G1H16(70),G1H16(69),G1H16(73),16)
  call HG1shiftOLR(G1H16(58),16,16)
  call Hloop_SA_Q(ntryL,G1H16(15),ex2(:),G1H8(1),ngPln,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(11),n2h8(7))
  call Hotf_5pt_reduction(G2H16(11),RedSet_5(1),mass5set(:,1),  & 
G1H16(74),G1H16(76),G1H16(71),G1H16(72),G1H16(78),G1H16(75),16)
  call HG1shiftOLR(G1H16(76),16,16)
  call Hloop_WA_Q(ntryL,G1H16(16),ex2(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(12),n2h8(8))
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(1),mass5set(:,1),  & 
G1H16(81),G1H16(82),G1H16(77),G1H16(79),G1H16(80),G1H16(84),16)
  call HG1shiftOLR(G1H16(82),16,16)
  call Hloop_AQ_S(ntryL,G2H16(13),ex1(:),G2H8(13),ngH,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_S(ntryL,G2H16(14),ex1(:),G2H8(14),ngX,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(2),mass5set(:,1),  & 
G1H16(83),G1H16(90),G1H16(89),G1H16(93),G1H16(94),G1H16(96),16)
  call HG1shiftOLR(G1H16(90),16,16)
  call Hloop_AQ_V(ntryL,G2H16(16),ex1(:),G2H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H16(17),ex1(:),G2H8(16),ngZl,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_SQ_A(ntryL,G1H16(20),ex1(:),G1H8(1),ngPnl,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(17),n2h8(9))
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(2),mass5set(:,1),  & 
G1H16(91),G1H16(92),G1H16(98),G1H16(95),G1H16(101),G1H16(102),16)
  call HG1shiftOLR(G1H16(92),16,16)
  call Hotf_5pt_reduction(G2H16(19),RedSet_5(2),mass5set(:,1),  & 
G1H16(97),G1H16(99),G1H16(100),G1H16(104),G1H16(103),G1H16(105),16)
  call HG1shiftOLR(G1H16(99),16,16)
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(18),n2h8(10))
  call Hloop_SQ_A(ntryL,G1H16(25),ex1(:),G1H8(1),ngPnl,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(19),n2h8(11))
  call Hloop_SQ_A(ntryL,G1H16(27),ex1(:),G1H8(1),ngPnl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(20),n2h8(12))
  call Hotf_5pt_reduction(G2H16(20),RedSet_5(2),mass5set(:,1),  & 
G1H16(106),G1H16(108),G1H16(109),G1H16(111),G1H16(112),G1H16(115),16)
  call HG1shiftOLR(G1H16(108),16,16)
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(2),mass5set(:,1),  & 
G1H16(118),G1H16(121),G1H16(122),G1H16(123),G1H16(125),G1H16(127),16)
  call HG1shiftOLR(G1H16(121),16,16)
  call Hloop_WQ_A(ntryL,G1H16(28),ex1(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(21),n2h8(13))
  call Hloop_WQ_A(ntryL,G1H16(30),ex1(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(22),n2h8(14))
  call Hloop_SQ_A(ntryL,G1H16(31),ex1(:),G1H8(1),ngPnl,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(23),n2h8(15))
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(2),mass5set(:,1),  & 
G1H16(128),G1H16(131),G1H16(133),G1H16(137),G1H16(138),G1H16(141),16)
  call HG1shiftOLR(G1H16(131),16,16)
  call Hotf_5pt_reduction(G2H16(23),RedSet_5(2),mass5set(:,1),  & 
G1H16(142),G1H16(143),G1H16(144),G1H16(149),G1H16(150),G1H16(153),16)
  call HG1shiftOLR(G1H16(143),16,16)
  call Hloop_WQ_A(ntryL,G1H16(32),ex1(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(24),n2h8(16))
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(2),mass5set(:,1),  & 
G1H16(154),G1H16(157),G1H16(158),G1H16(159),G1H16(160),G1H16(165),16)
  call HG1shiftOLR(G1H16(157),16,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(3),mass5set(:,2),  & 
G1H16(166),G1H16(174),G1H16(173),G1H16(177),G1H16(178),G1H16(180),16)
  call HG1shiftOLR(G1H16(174),16,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(3),mass5set(:,3),  & 
G1H16(175),G1H16(176),G1H16(182),G1H16(179),G1H16(185),G1H16(186),16)
  call HG1shiftOLR(G1H16(176),16,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(3),mass5set(:,4),  & 
G1H16(181),G1H16(183),G1H16(184),G1H16(188),G1H16(187),G1H16(194),16)
  call HG1shiftOLR(G1H16(183),16,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(3),mass5set(:,5),  & 
G1H16(197),G1H16(193),G1H16(198),G1H16(200),G1H16(195),G1H16(202),16)
  call HG1shiftOLR(G1H16(193),16,16)
  call Hotf_5pt_reduction(G2H16(29),RedSet_5(3),mass5set(:,3),  & 
G1H16(196),G1H16(205),G1H16(199),G1H16(206),G1H16(201),G1H16(203),16)
  call HG1shiftOLR(G1H16(205),16,16)
  call Hloop_SV_T(ntryL,G1H16(35),40,ex3(:),4,G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_VV_S(ntryL,G1H16(36),ex3(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hotf_5pt_reduction(G2H16(30),RedSet_5(3),mass5set(:,4),  & 
G1H16(208),G1H16(204),G1H16(207),G1H16(209),G1H16(210),G1H16(213),16)
  call HG1shiftOLR(G1H16(204),16,16)
  call Hloop_SV_V(ntryL,G2H16(31),ex3(:),G2H8(26),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_VV_S(ntryL,G2H16(33),ex3(:),G2H8(27),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_SV_T(ntryL,G1H16(41),40,ex3(:),4,G2H8(28),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_VV_S(ntryL,G1H16(42),ex3(:),G1H8(2),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_SV_V(ntryL,G1H16(43),ex3(:),G1H8(3),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_UW_V(ntryL,G1H16(44),40,ex3(:),4,G2H8(29),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_SV_V(ntryL,G2H16(32),ex3(:),G2H8(30),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_VV_S(ntryL,G2H16(34),ex3(:),G2H8(31),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hotf_5pt_reduction(G2H16(35),RedSet_5(3),mass5set(:,4),  & 
G1H16(214),G1H16(215),G1H16(216),G1H16(221),G1H16(222),G1H16(225),16)
  call HG1shiftOLR(G1H16(215),16,16)
  call Hloop_SV_V(ntryL,G1H16(47),ex3(:),G1H8(4),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_UW_V(ntryL,G1H16(48),40,ex3(:),4,G2H8(32),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hotf_5pt_reduction(G2H16(36),RedSet_5(3),mass5set(:,4),  & 
G1H16(226),G1H16(227),G1H16(229),G1H16(231),G1H16(232),G1H16(235),16)
  call HG1shiftOLR(G1H16(227),16,16)
  call Hloop_AQ_S(ntryL,G2H16(37),ex1(:),G2H8(33),ngH,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_AQ_S(ntryL,G2H16(38),ex1(:),G2H8(34),ngX,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hotf_5pt_reduction(G2H16(39),RedSet_5(2),mass5set(:,1),  & 
G1H16(237),G1H16(241),G1H16(242),G1H16(245),G1H16(246),G1H16(247),16)
  call HG1shiftOLR(G1H16(241),8,16)
  call Hloop_AQ_V(ntryL,G2H16(40),ex1(:),G2H8(35),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_AQ_Z(ntryL,G2H16(41),ex1(:),G2H8(36),ngZl,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_SQ_A(ntryL,G1H16(52),ex1(:),G1H8(5),ngPnl,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(37),n2h8(17))
  call Hotf_5pt_reduction(G2H16(42),RedSet_5(2),mass5set(:,1),  & 
G1H16(248),G1H16(253),G1H16(254),G1H16(257),G1H16(258),G1H16(261),16)
  call HG1shiftOLR(G1H16(253),8,16)
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(2),mass5set(:,1),  & 
G1H16(262),G1H16(263),G1H16(264),G1H16(269),G1H16(270),G1H16(278),16)
  call HG1shiftOLR(G1H16(263),8,16)
  call Hloop_WQ_A(ntryL,G1H16(55),ex1(:),G1H8(5),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(38),n2h8(18))
  call Hloop_SQ_A(ntryL,G1H16(57),ex1(:),G1H8(5),ngPnl,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(39),n2h8(19))
  call Hloop_SQ_A(ntryL,G1H16(59),ex1(:),G1H8(5),ngPnl,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(40),n2h8(20))
  call Hotf_5pt_reduction(G2H16(44),RedSet_5(2),mass5set(:,1),  & 
G1H16(277),G1H16(281),G1H16(282),G1H16(284),G1H16(279),G1H16(280),16)
  call HG1shiftOLR(G1H16(281),8,16)
  call Hotf_5pt_reduction(G2H16(45),RedSet_5(2),mass5set(:,1),  & 
G1H16(286),G1H16(283),G1H16(289),G1H16(290),G1H16(285),G1H16(287),16)
  call HG1shiftOLR(G1H16(283),8,16)
  call Hloop_WQ_A(ntryL,G1H16(60),ex1(:),G1H8(5),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(41),n2h8(21))
  call Hloop_WQ_A(ntryL,G1H16(62),ex1(:),G1H8(5),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(42),n2h8(22))
  call Hloop_SQ_A(ntryL,G1H16(63),ex1(:),G1H8(5),ngPnl,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(43),n2h8(23))
  call Hotf_5pt_reduction(G2H16(46),RedSet_5(2),mass5set(:,1),  & 
G1H16(288),G1H16(292),G1H16(291),G1H16(298),G1H16(301),G1H16(297),16)
  call HG1shiftOLR(G1H16(292),8,16)
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(2),mass5set(:,1),  & 
G1H16(302),G1H16(304),G1H16(299),G1H16(306),G1H16(300),G1H16(309),16)
  call HG1shiftOLR(G1H16(304),8,16)
  call Hloop_WQ_A(ntryL,G1H16(64),ex1(:),G1H8(5),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(5),37,0,G2H8(44),n2h8(24))
  call Hotf_5pt_reduction(G2H16(48),RedSet_5(2),mass5set(:,1),  & 
G1H16(303),G1H16(310),G1H16(305),G1H16(307),G1H16(312),G1H16(308),16)
  call HG1shiftOLR(G1H16(310),8,16)
  call Hloop_SQ_A(ntryL,G1H16(65),ex1(:),G1H8(5),ngH,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(45),n2h8(25))
  call Hloop_SQ_A(ntryL,G1H16(66),ex1(:),G1H8(5),ngX,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(46),n2h8(26))
  call Hloop_AQ_S(ntryL,G2H16(49),ex1(:),G2H8(47),ngPnl,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_VQ_A(ntryL,G1H16(67),ex1(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(48),n2h8(27))
  call Hloop_ZQ_A(ntryL,G1H16(68),ex1(:),G1H8(5),ngZl,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(49),n2h8(28))
  call Hloop_AQ_S(ntryL,G2H16(54),ex1(:),G2H8(50),ngPnl,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_S(ntryL,G2H16(50),ex1(:),G2H8(51),ngPnl,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_S(ntryL,G2H16(51),ex1(:),G2H8(52),ngPnl,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_W(ntryL,G2H16(52),ex1(:),G2H8(53),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_AQ_S(ntryL,G2H16(57),ex1(:),G2H8(54),ngPnl,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_AQ_S(ntryL,G2H16(58),ex1(:),G2H8(55),ngPnl,m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AQ_S(ntryL,G2H16(53),ex1(:),G2H8(56),ngPnl,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_W(ntryL,G2H16(60),ex1(:),G2H8(57),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_W(ntryL,G2H16(55),ex1(:),G2H8(58),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_W(ntryL,G2H16(56),ex1(:),G2H8(59),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_S(ntryL,G2H16(61),ex1(:),G2H8(60),ngPnl,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_W(ntryL,G2H16(62),ex1(:),G2H8(61),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G2H16(63),ex1(:),G2H8(62),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_AQ_W(ntryL,G2H16(59),ex1(:),G2H8(63),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_W(ntryL,G2H16(64),ex1(:),G2H8(64),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_SQ_A(ntryL,G1H16(85),ex1(:),G1H8(5),ngH,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(65),n2h8(29))
  call Hloop_SQ_A(ntryL,G1H16(86),ex1(:),G1H8(5),ngX,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(66),n2h8(30))
  call Hloop_AQ_S(ntryL,G2H16(65),ex1(:),G2H8(67),ngPnl,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_VQ_A(ntryL,G1H16(87),ex1(:),G1H8(5),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(68),n2h8(31))
  call Hloop_ZQ_A(ntryL,G1H16(88),ex1(:),G1H8(5),ngZl,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(5),35,nME,G2H8(69),n2h8(32))
  call Hloop_AQ_S(ntryL,G2H16(70),ex1(:),G2H8(70),ngPnl,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AQ_S(ntryL,G2H16(66),ex1(:),G2H8(71),ngPnl,m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_AQ_S(ntryL,G2H16(67),ex1(:),G2H8(72),ngPnl,m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_AQ_W(ntryL,G2H16(68),ex1(:),G2H8(73),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_AQ_S(ntryL,G2H16(73),ex1(:),G2H8(74),ngPnl,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AQ_S(ntryL,G2H16(74),ex1(:),G2H8(75),ngPnl,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_AQ_S(ntryL,G2H16(69),ex1(:),G2H8(76),ngPnl,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_AQ_W(ntryL,G2H16(76),ex1(:),G2H8(77),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AQ_W(ntryL,G2H16(71),ex1(:),G2H8(78),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_AQ_W(ntryL,G2H16(72),ex1(:),G2H8(79),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_AQ_S(ntryL,G2H16(77),ex1(:),G2H8(80),ngPnl,m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_W(ntryL,G2H16(78),ex1(:),G2H8(81),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_AQ_W(ntryL,G2H16(79),ex1(:),G2H8(82),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_AQ_W(ntryL,G2H16(75),ex1(:),G2H8(83),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_AQ_W(ntryL,G2H16(80),ex1(:),G2H8(84),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_AQ_S(ntryL,G2H16(81),ex1(:),G2H8(85),ngH,m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_AQ_S(ntryL,G2H16(82),ex1(:),G2H8(86),ngX,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hotf_5pt_reduction(G2H16(83),RedSet_5(4),mass5set(:,1),  & 
G1H16(311),G1H16(318),G1H16(317),G1H16(322),G1H16(323),G1H16(324),16)
  call HG1shiftOLR(G1H16(318),16,16)
  call Hloop_AQ_V(ntryL,G2H16(84),ex1(:),G2H8(87),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_AQ_Z(ntryL,G2H16(85),ex1(:),G2H8(88),ngZl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_SQ_A(ntryL,G1H16(107),ex1(:),G1H8(5),ngPnl,m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(89),n2h8(33))
  call Hotf_5pt_reduction(G2H16(86),RedSet_5(4),mass5set(:,1),  & 
G1H16(319),G1H16(320),G1H16(328),G1H16(321),G1H16(329),G1H16(330),16)
  call HG1shiftOLR(G1H16(320),16,16)
  call Hotf_5pt_reduction(G2H16(87),RedSet_5(4),mass5set(:,1),  & 
G1H16(325),G1H16(326),G1H16(327),G1H16(332),G1H16(331),G1H16(338),16)
  call HG1shiftOLR(G1H16(326),16,16)
  call Hloop_WQ_A(ntryL,G1H16(110),ex1(:),G1H8(5),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(90),n2h8(34))
  call Hloop_SQ_A(ntryL,G1H16(113),ex1(:),G1H8(5),ngPnl,m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(91),n2h8(35))
  call Hloop_SQ_A(ntryL,G1H16(114),ex1(:),G1H8(5),ngPnl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(92),n2h8(36))
  call Hotf_5pt_reduction(G2H16(88),RedSet_5(4),mass5set(:,1),  & 
G1H16(337),G1H16(342),G1H16(343),G1H16(344),G1H16(339),G1H16(340),16)
  call HG1shiftOLR(G1H16(342),16,16)
  call Hotf_5pt_reduction(G2H16(89),RedSet_5(4),mass5set(:,1),  & 
G1H16(348),G1H16(341),G1H16(349),G1H16(350),G1H16(345),G1H16(346),16)
  call HG1shiftOLR(G1H16(341),16,16)
  call Hloop_WQ_A(ntryL,G1H16(116),ex1(:),G1H8(5),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(93),n2h8(37))
  call Hloop_WQ_A(ntryL,G1H16(117),ex1(:),G1H8(5),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(94),n2h8(38))
  call Hloop_SQ_A(ntryL,G1H16(119),ex1(:),G1H8(5),ngPnl,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(95),n2h8(39))
  call Hotf_5pt_reduction(G2H16(90),RedSet_5(4),mass5set(:,1),  & 
G1H16(347),G1H16(352),G1H16(351),G1H16(358),G1H16(357),G1H16(362),16)
  call HG1shiftOLR(G1H16(352),16,16)
  call Hotf_5pt_reduction(G2H16(91),RedSet_5(4),mass5set(:,1),  & 
G1H16(363),G1H16(364),G1H16(359),G1H16(360),G1H16(368),G1H16(361),16)
  call HG1shiftOLR(G1H16(364),16,16)
  call Hloop_WQ_A(ntryL,G1H16(120),ex1(:),G1H8(5),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(5),41,0,G2H8(96),n2h8(40))
  call Hotf_5pt_reduction(G2H16(92),RedSet_5(4),mass5set(:,1),  & 
G1H16(369),G1H16(370),G1H16(365),G1H16(366),G1H16(367),G1H16(372),16)
  call HG1shiftOLR(G1H16(370),16,16)
  call Hloop_QA_S(ntryL,G2H16(93),ex2(:),G2H8(97),ngH,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_QA_S(ntryL,G2H16(94),ex2(:),G2H8(98),ngX,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hotf_5pt_reduction(G2H16(95),RedSet_5(5),mass5set(:,1),  & 
G1H16(371),G1H16(378),G1H16(382),G1H16(377),G1H16(383),G1H16(384),16)
  call HG1shiftOLR(G1H16(378),16,16)
  call Hloop_QA_V(ntryL,G2H16(96),ex2(:),G2H8(99),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_QA_Z(ntryL,G2H16(97),ex2(:),G2H8(100),ngZl,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_SA_Q(ntryL,G1H16(124),ex2(:),G1H8(5),ngPln,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(101),n2h8(41))
  call Hotf_5pt_reduction(G2H16(98),RedSet_5(5),mass5set(:,1),  & 
G1H16(379),G1H16(388),G1H16(380),G1H16(389),G1H16(381),G1H16(390),16)
  call HG1shiftOLR(G1H16(388),16,16)
  call Hloop_WA_Q(ntryL,G1H16(126),ex2(:),G1H8(5),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(102),n2h8(42))
  call Hotf_5pt_reduction(G2H16(99),RedSet_5(5),mass5set(:,1),  & 
G1H16(385),G1H16(386),G1H16(392),G1H16(387),G1H16(391),G1H16(398),16)
  call HG1shiftOLR(G1H16(386),16,16)
  call Hloop_SA_Q(ntryL,G1H16(129),ex2(:),G1H8(5),ngPln,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(103),n2h8(43))
  call Hotf_5pt_reduction(G2H16(101),RedSet_5(5),mass5set(:,1),  & 
G1H16(397),G1H16(402),G1H16(403),G1H16(404),G1H16(399),G1H16(400),16)
  call HG1shiftOLR(G1H16(402),16,16)
  call Hloop_WA_Q(ntryL,G1H16(130),ex2(:),G1H8(5),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(104),n2h8(44))
  call Hloop_SA_Q(ntryL,G1H16(132),ex2(:),G1H8(5),ngPln,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(105),n2h8(45))
  call Hotf_5pt_reduction(G2H16(100),RedSet_5(5),mass5set(:,1),  & 
G1H16(408),G1H16(401),G1H16(409),G1H16(410),G1H16(405),G1H16(406),16)
  call HG1shiftOLR(G1H16(401),16,16)
  call Hloop_WA_Q(ntryL,G1H16(134),ex2(:),G1H8(5),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(106),n2h8(46))
  call Hotf_5pt_reduction(G2H16(102),RedSet_5(5),mass5set(:,1),  & 
G1H16(407),G1H16(412),G1H16(411),G1H16(418),G1H16(422),G1H16(417),16)
  call HG1shiftOLR(G1H16(412),16,16)
  call Hloop_SA_Q(ntryL,G1H16(135),ex2(:),G1H8(5),ngPln,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(107),n2h8(47))
  call Hotf_5pt_reduction(G2H16(103),RedSet_5(5),mass5set(:,1),  & 
G1H16(423),G1H16(424),G1H16(419),G1H16(428),G1H16(420),G1H16(429),16)
  call HG1shiftOLR(G1H16(424),16,16)
  call Hloop_WA_Q(ntryL,G1H16(136),ex2(:),G1H8(5),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(5),38,0,G2H8(108),n2h8(48))
  call Hotf_5pt_reduction(G2H16(104),RedSet_5(5),mass5set(:,1),  & 
G1H16(421),G1H16(430),G1H16(425),G1H16(426),G1H16(432),G1H16(427),16)
  call HG1shiftOLR(G1H16(430),16,16)
  call Hotf_5pt_reduction(G2H16(105),RedSet_5(6),mass5set(:,2),  & 
G1H16(431),G1H16(3),G1H16(5),G1H16(9),G1H16(10),G1H16(11),16)
  call HG1shiftOLR(G1H16(3),16,16)
  call Hotf_5pt_reduction(G2H16(106),RedSet_5(6),mass5set(:,3),  & 
G1H16(13),G1H16(15),G1H16(16),G1H16(20),G1H16(23),G1H16(25),16)
  call HG1shiftOLR(G1H16(15),16,16)
  call Hotf_5pt_reduction(G2H16(107),RedSet_5(6),mass5set(:,4),  & 
G1H16(27),G1H16(28),G1H16(30),G1H16(31),G1H16(32),G1H16(35),16)
  call HG1shiftOLR(G1H16(28),16,16)
  call Hotf_5pt_reduction(G2H16(108),RedSet_5(6),mass5set(:,5),  & 
G1H16(36),G1H16(41),G1H16(42),G1H16(43),G1H16(44),G1H16(47),16)
  call HG1shiftOLR(G1H16(41),16,16)
  call Hotf_5pt_reduction(G2H16(109),RedSet_5(6),mass5set(:,3),  & 
G1H16(48),G1H16(52),G1H16(55),G1H16(57),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(52),16,16)
  call Hloop_SV_T(ntryL,G1H16(139),36,ex4(:),8,G2H8(109),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_VV_S(ntryL,G1H16(140),ex4(:),G1H8(5),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hotf_5pt_reduction(G2H16(110),RedSet_5(6),mass5set(:,4),  & 
G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),G1H16(67),16)
  call HG1shiftOLR(G1H16(63),16,16)
  call Hloop_SV_V(ntryL,G2H16(111),ex4(:),G2H8(110),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_VV_S(ntryL,G2H16(113),ex4(:),G2H8(111),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_SV_T(ntryL,G1H16(145),36,ex4(:),8,G2H8(112),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_VV_S(ntryL,G1H16(146),ex4(:),G1H8(6),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_SV_V(ntryL,G1H16(147),ex4(:),G1H8(7),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_UW_V(ntryL,G1H16(148),36,ex4(:),8,G2H8(113),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_SV_V(ntryL,G2H16(112),ex4(:),G2H8(114),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_VV_S(ntryL,G2H16(114),ex4(:),G2H8(115),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hotf_5pt_reduction(G2H16(115),RedSet_5(6),mass5set(:,4),  & 
G1H16(68),G1H16(85),G1H16(86),G1H16(87),G1H16(88),G1H16(107),16)
  call HG1shiftOLR(G1H16(85),16,16)
  call Hloop_SV_V(ntryL,G1H16(151),ex4(:),G1H8(8),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_UW_V(ntryL,G1H16(152),36,ex4(:),8,G2H8(116),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hotf_5pt_reduction(G2H16(116),RedSet_5(6),mass5set(:,4),  & 
G1H16(110),G1H16(113),G1H16(114),G1H16(116),G1H16(117),G1H16(119),16)
  call HG1shiftOLR(G1H16(113),16,16)
  call Hotf_5pt_reduction(G2H16(117),RedSet_5(7),mass5set(:,2),  & 
G1H16(120),G1H16(124),G1H16(126),G1H16(129),G1H16(130),G1H16(132),16)
  call HG1shiftOLR(G1H16(124),8,16)
  call Hotf_5pt_reduction(G2H16(118),RedSet_5(7),mass5set(:,3),  & 
G1H16(134),G1H16(135),G1H16(136),G1H16(139),G1H16(140),G1H16(145),16)
  call HG1shiftOLR(G1H16(135),8,16)
  call Hotf_5pt_reduction(G2H16(119),RedSet_5(7),mass5set(:,4),  & 
G1H16(146),G1H16(147),G1H16(148),G1H16(151),G1H16(152),G1H16(434),16)
  call HG1shiftOLR(G1H16(147),8,16)
  call Hotf_5pt_reduction(G2H16(120),RedSet_5(7),mass5set(:,5),  & 
G1H16(435),G1H16(436),G1H16(437),G1H16(438),G1H16(439),G1H16(440),16)
  call HG1shiftOLR(G1H16(436),8,16)
  call Hotf_5pt_reduction(G2H16(121),RedSet_5(7),mass5set(:,3),  & 
G1H16(441),G1H16(442),G1H16(443),G1H16(444),G1H16(445),G1H16(446),16)
  call HG1shiftOLR(G1H16(442),8,16)
  call Hloop_TV_S(ntryL,G1H16(155),36,ex5(:),16,G2H8(117),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_VV_S(ntryL,G1H16(156),ex5(:),G1H8(9),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_SV_V(ntryL,G2H16(122),ex5(:),G2H8(118),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hotf_5pt_reduction(G2H16(123),RedSet_5(7),mass5set(:,4),  & 
G1H16(155),G1H16(156),G1H16(447),G1H16(448),G1H16(449),G1H16(450),16)
  call HG1shiftOLR(G1H16(156),8,16)
  call Hloop_VV_S(ntryL,G2H16(125),ex5(:),G2H8(119),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_SV_V(ntryL,G1H16(161),ex5(:),G1H8(10),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_UV_W(ntryL,G1H16(162),36,ex5(:),16,G2H8(120),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_TV_S(ntryL,G1H16(163),36,ex5(:),16,G2H8(121),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_VV_S(ntryL,G1H16(164),ex5(:),G1H8(11),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_SV_V(ntryL,G2H16(124),ex5(:),G2H8(122),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hotf_5pt_reduction(G2H16(126),RedSet_5(7),mass5set(:,4),  & 
G1H16(161),G1H16(162),G1H16(163),G1H16(164),G1H16(451),G1H16(452),16)
  call HG1shiftOLR(G1H16(162),8,16)
  call Hloop_VV_S(ntryL,G2H16(127),ex5(:),G2H8(123),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_SV_V(ntryL,G1H16(167),ex5(:),G1H8(12),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_UV_W(ntryL,G1H16(168),36,ex5(:),16,G2H8(124),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hotf_5pt_reduction(G2H16(128),RedSet_5(7),mass5set(:,4),  & 
G1H16(167),G1H16(168),G1H16(453),G1H16(454),G1H16(455),G1H16(456),16)
  call HG1shiftOLR(G1H16(168),8,16)
  call Hloop_SQ_A(ntryL,G1H16(169),ex1(:),G1H8(13),ngH,m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(125),n2h8(49))
  call Hloop_SQ_A(ntryL,G1H16(170),ex1(:),G1H8(13),ngX,m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(126),n2h8(50))
  call Hloop_AQ_S(ntryL,G2H16(129),ex1(:),G2H8(127),ngPnl,m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_VQ_A(ntryL,G1H16(171),ex1(:),G1H8(13),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(128),n2h8(51))
  call Hloop_ZQ_A(ntryL,G1H16(172),ex1(:),G1H8(13),ngZl,m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(129),n2h8(52))
  call Hloop_AQ_S(ntryL,G2H16(134),ex1(:),G2H8(130),ngPnl,m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_AQ_S(ntryL,G2H16(130),ex1(:),G2H8(131),ngPnl,m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_AQ_S(ntryL,G2H16(131),ex1(:),G2H8(132),ngPnl,m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_AQ_W(ntryL,G2H16(132),ex1(:),G2H8(133),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_AQ_S(ntryL,G2H16(137),ex1(:),G2H8(134),ngPnl,m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_AQ_S(ntryL,G2H16(138),ex1(:),G2H8(135),ngPnl,m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_AQ_S(ntryL,G2H16(133),ex1(:),G2H8(136),ngPnl,m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_AQ_W(ntryL,G2H16(140),ex1(:),G2H8(137),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_AQ_W(ntryL,G2H16(135),ex1(:),G2H8(138),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_AQ_W(ntryL,G2H16(136),ex1(:),G2H8(139),m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_AQ_S(ntryL,G2H16(141),ex1(:),G2H8(140),ngPnl,m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_AQ_W(ntryL,G2H16(142),ex1(:),G2H8(141),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_AQ_W(ntryL,G2H16(143),ex1(:),G2H8(142),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_AQ_W(ntryL,G2H16(139),ex1(:),G2H8(143),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_AQ_W(ntryL,G2H16(144),ex1(:),G2H8(144),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_SQ_A(ntryL,G1H16(189),ex1(:),G1H8(13),ngH,m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(145),n2h8(53))
  call Hloop_SQ_A(ntryL,G1H16(190),ex1(:),G1H8(13),ngX,m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(146),n2h8(54))
  call Hloop_AQ_S(ntryL,G2H16(145),ex1(:),G2H8(147),ngPnl,m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_VQ_A(ntryL,G1H16(191),ex1(:),G1H8(13),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(148),n2h8(55))
  call Hloop_ZQ_A(ntryL,G1H16(192),ex1(:),G1H8(13),ngZl,m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(13),35,nME,G2H8(149),n2h8(56))
  call Hloop_AQ_S(ntryL,G2H16(146),ex1(:),G2H8(150),ngPnl,m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_AQ_S(ntryL,G2H16(150),ex1(:),G2H8(151),ngPnl,m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_AQ_S(ntryL,G2H16(147),ex1(:),G2H8(152),ngPnl,m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_AQ_W(ntryL,G2H16(148),ex1(:),G2H8(153),m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_AQ_S(ntryL,G2H16(153),ex1(:),G2H8(154),ngPnl,m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_AQ_S(ntryL,G2H16(149),ex1(:),G2H8(155),ngPnl,m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_AQ_S(ntryL,G2H16(154),ex1(:),G2H8(156),ngPnl,m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_AQ_W(ntryL,G2H16(151),ex1(:),G2H8(157),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_AQ_W(ntryL,G2H16(156),ex1(:),G2H8(158),m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_AQ_W(ntryL,G2H16(152),ex1(:),G2H8(159),m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_AQ_S(ntryL,G2H16(157),ex1(:),G2H8(160),ngPnl,m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_AQ_W(ntryL,G2H16(158),ex1(:),G2H8(161),m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_AQ_W(ntryL,G2H16(155),ex1(:),G2H8(162),m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_AQ_W(ntryL,G2H16(159),ex1(:),G2H8(163),m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_AQ_W(ntryL,G2H16(160),ex1(:),G2H8(164),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hotf_5pt_reduction(G2H16(161),RedSet_5(8),mass5set(:,2),  & 
G1H16(169),G1H16(170),G1H16(171),G1H16(172),G1H16(189),G1H16(190),16)
  call HG1shiftOLR(G1H16(170),16,16)
  call Hotf_5pt_reduction(G2H16(162),RedSet_5(8),mass5set(:,3),  & 
G1H16(191),G1H16(192),G1H16(457),G1H16(458),G1H16(459),G1H16(460),16)
  call HG1shiftOLR(G1H16(192),16,16)
  call Hotf_5pt_reduction(G2H16(163),RedSet_5(8),mass5set(:,4),  & 
G1H16(461),G1H16(462),G1H16(463),G1H16(464),G1H16(465),G1H16(466),16)
  call HG1shiftOLR(G1H16(462),16,16)
  call Hotf_5pt_reduction(G2H16(164),RedSet_5(8),mass5set(:,5),  & 
G1H16(467),G1H16(468),G1H16(469),G1H16(470),G1H16(471),G1H16(472),16)
  call HG1shiftOLR(G1H16(468),16,16)
  call Hotf_5pt_reduction(G2H16(165),RedSet_5(8),mass5set(:,3),  & 
G1H16(473),G1H16(474),G1H16(475),G1H16(476),G1H16(477),G1H16(478),16)
  call HG1shiftOLR(G1H16(474),16,16)
  call Hloop_TV_S(ntryL,G1H16(211),40,ex3(:),4,G2H8(165),m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_VV_S(ntryL,G1H16(212),ex3(:),G1H8(13),m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_SV_V(ntryL,G2H16(166),ex3(:),G2H8(166),m3h2x8(:,179),heltab2x16(:,:,179))
  call Hotf_5pt_reduction(G2H16(167),RedSet_5(8),mass5set(:,4),  & 
G1H16(211),G1H16(212),G1H16(479),G1H16(480),G1H16(481),G1H16(482),16)
  call HG1shiftOLR(G1H16(212),16,16)
  call Hloop_VV_S(ntryL,G2H16(169),ex3(:),G2H8(167),m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_SV_V(ntryL,G1H16(217),ex3(:),G1H8(14),m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_UV_W(ntryL,G1H16(218),40,ex3(:),4,G2H8(168),m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_TV_S(ntryL,G1H16(219),40,ex3(:),4,G2H8(169),m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_VV_S(ntryL,G1H16(220),ex3(:),G1H8(15),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_SV_V(ntryL,G2H16(168),ex3(:),G2H8(170),m3h2x8(:,185),heltab2x16(:,:,185))
  call Hotf_5pt_reduction(G2H16(170),RedSet_5(8),mass5set(:,4),  & 
G1H16(217),G1H16(218),G1H16(219),G1H16(220),G1H16(483),G1H16(484),16)
  call HG1shiftOLR(G1H16(218),16,16)
  call Hloop_VV_S(ntryL,G2H16(171),ex3(:),G2H8(171),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_SV_V(ntryL,G1H16(223),ex3(:),G1H8(16),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_UV_W(ntryL,G1H16(224),40,ex3(:),4,G2H8(172),m3h2x8(:,188),heltab2x16(:,:,188))
  call Hotf_5pt_reduction(G2H16(172),RedSet_5(8),mass5set(:,4),  & 
G1H16(223),G1H16(224),G1H16(485),G1H16(486),G1H16(487),G1H16(488),16)
  call HG1shiftOLR(G1H16(224),16,16)
  call Hloop_QA_S(ntryL,G2H16(173),ex2(:),G2H8(173),ngH,m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_QA_S(ntryL,G2H16(174),ex2(:),G2H8(174),ngX,m3h2x8(:,190),heltab2x16(:,:,190))
  call Hotf_5pt_reduction(G2H16(175),RedSet_5(5),mass5set(:,1),  & 
G1H16(489),G1H16(490),G1H16(491),G1H16(492),G1H16(493),G1H16(494),16)
  call HG1shiftOLR(G1H16(490),8,16)
  call Hloop_QA_V(ntryL,G2H16(176),ex2(:),G2H8(175),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_QA_Z(ntryL,G2H16(177),ex2(:),G2H8(176),ngZl,m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_SA_Q(ntryL,G1H16(228),ex2(:),G1H8(17),ngPln,m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(177),n2h8(57))
  call Hotf_5pt_reduction(G2H16(178),RedSet_5(5),mass5set(:,1),  & 
G1H16(228),G1H16(495),G1H16(496),G1H16(497),G1H16(498),G1H16(499),16)
  call HG1shiftOLR(G1H16(495),8,16)
  call Hloop_WA_Q(ntryL,G1H16(230),ex2(:),G1H8(17),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(178),n2h8(58))
  call Hotf_5pt_reduction(G2H16(179),RedSet_5(5),mass5set(:,1),  & 
G1H16(230),G1H16(500),G1H16(501),G1H16(502),G1H16(503),G1H16(504),16)
  call HG1shiftOLR(G1H16(500),8,16)
  call Hloop_SA_Q(ntryL,G1H16(233),ex2(:),G1H8(17),ngPln,m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(179),n2h8(59))
  call Hotf_5pt_reduction(G2H16(181),RedSet_5(5),mass5set(:,1),  & 
G1H16(233),G1H16(505),G1H16(506),G1H16(507),G1H16(508),G1H16(509),16)
  call HG1shiftOLR(G1H16(505),8,16)
  call Hloop_WA_Q(ntryL,G1H16(234),ex2(:),G1H8(17),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(180),n2h8(60))
  call Hloop_SA_Q(ntryL,G1H16(236),ex2(:),G1H8(17),ngPln,m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(181),n2h8(61))
  call Hotf_5pt_reduction(G2H16(180),RedSet_5(5),mass5set(:,1),  & 
G1H16(234),G1H16(236),G1H16(510),G1H16(511),G1H16(512),G1H16(513),16)
  call HG1shiftOLR(G1H16(236),8,16)
  call Hloop_WA_Q(ntryL,G1H16(238),ex2(:),G1H8(17),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(182),n2h8(62))
  call Hotf_5pt_reduction(G2H16(182),RedSet_5(5),mass5set(:,1),  & 
G1H16(238),G1H16(514),G1H16(515),G1H16(516),G1H16(517),G1H16(518),16)
  call HG1shiftOLR(G1H16(514),8,16)
  call Hloop_SA_Q(ntryL,G1H16(239),ex2(:),G1H8(17),ngPln,m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(183),n2h8(63))
  call Hotf_5pt_reduction(G2H16(183),RedSet_5(5),mass5set(:,1),  & 
G1H16(239),G1H16(519),G1H16(520),G1H16(521),G1H16(522),G1H16(523),16)
  call HG1shiftOLR(G1H16(519),8,16)
  call Hloop_WA_Q(ntryL,G1H16(240),ex2(:),G1H8(17),m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G1H8(17),38,0,G2H8(184),n2h8(64))
  call Hotf_5pt_reduction(G2H16(184),RedSet_5(5),mass5set(:,1),  & 
G1H16(240),G1H16(524),G1H16(525),G1H16(526),G1H16(527),G1H16(528),16)
  call HG1shiftOLR(G1H16(524),8,16)
  call Hotf_5pt_reduction(G2H16(185),RedSet_5(9),mass5set(:,2),  & 
G1H16(529),G1H16(530),G1H16(531),G1H16(532),G1H16(533),G1H16(534),16)
  call HG1shiftOLR(G1H16(530),16,16)
  call Hotf_5pt_reduction(G2H16(186),RedSet_5(9),mass5set(:,3),  & 
G1H16(535),G1H16(536),G1H16(537),G1H16(538),G1H16(539),G1H16(540),16)
  call HG1shiftOLR(G1H16(536),16,16)
  call Hotf_5pt_reduction(G2H16(187),RedSet_5(9),mass5set(:,4),  & 
G1H16(541),G1H16(542),G1H16(543),G1H16(544),G1H16(545),G1H16(546),16)
  call HG1shiftOLR(G1H16(542),16,16)
  call Hotf_5pt_reduction(G2H16(188),RedSet_5(9),mass5set(:,5),  & 
G1H16(547),G1H16(548),G1H16(549),G1H16(550),G1H16(551),G1H16(552),16)
  call HG1shiftOLR(G1H16(548),16,16)
  call Hotf_5pt_reduction(G2H16(189),RedSet_5(9),mass5set(:,3),  & 
G1H16(553),G1H16(554),G1H16(555),G1H16(556),G1H16(557),G1H16(558),16)
  call HG1shiftOLR(G1H16(554),16,16)
  call Hloop_TV_S(ntryL,G1H16(243),36,ex4(:),8,G2H8(185),m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_VV_S(ntryL,G1H16(244),ex4(:),G1H8(17),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_SV_V(ntryL,G2H16(190),ex4(:),G2H8(186),m3h2x8(:,203),heltab2x16(:,:,203))
  call Hotf_5pt_reduction(G2H16(191),RedSet_5(9),mass5set(:,4),  & 
G1H16(243),G1H16(244),G1H16(559),G1H16(560),G1H16(561),G1H16(562),16)
  call HG1shiftOLR(G1H16(244),16,16)
  call Hloop_VV_S(ntryL,G2H16(193),ex4(:),G2H8(187),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_SV_V(ntryL,G1H16(249),ex4(:),G1H8(18),m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_UV_W(ntryL,G1H16(250),36,ex4(:),8,G2H8(188),m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_TV_S(ntryL,G1H16(251),36,ex4(:),8,G2H8(189),m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_VV_S(ntryL,G1H16(252),ex4(:),G1H8(19),m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_SV_V(ntryL,G2H16(192),ex4(:),G2H8(190),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hotf_5pt_reduction(G2H16(194),RedSet_5(9),mass5set(:,4),  & 
G1H16(249),G1H16(250),G1H16(251),G1H16(252),G1H16(563),G1H16(564),16)
  call HG1shiftOLR(G1H16(250),16,16)
  call Hloop_VV_S(ntryL,G2H16(195),ex4(:),G2H8(191),m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_SV_V(ntryL,G1H16(255),ex4(:),G1H8(20),m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_UV_W(ntryL,G1H16(256),36,ex4(:),8,G2H8(192),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hotf_5pt_reduction(G2H16(196),RedSet_5(9),mass5set(:,4),  & 
G1H16(255),G1H16(256),G1H16(565),G1H16(566),G1H16(567),G1H16(568),16)
  call HG1shiftOLR(G1H16(256),16,16)
  call Hotf_5pt_reduction(G2H16(197),RedSet_5(10),mass5set(:,2),  & 
G1H16(569),G1H16(570),G1H16(571),G1H16(572),G1H16(573),G1H16(574),16)
  call HG1shiftOLR(G1H16(570),8,16)
  call Hotf_5pt_reduction(G2H16(198),RedSet_5(10),mass5set(:,3),  & 
G1H16(575),G1H16(576),G1H16(577),G1H16(578),G1H16(579),G1H16(580),16)
  call HG1shiftOLR(G1H16(576),8,16)
  call Hotf_5pt_reduction(G2H16(199),RedSet_5(10),mass5set(:,4),  & 
G1H16(581),G1H16(582),G1H16(583),G1H16(584),G1H16(585),G1H16(586),16)
  call HG1shiftOLR(G1H16(582),8,16)
  call Hotf_5pt_reduction(G2H16(200),RedSet_5(10),mass5set(:,5),  & 
G1H16(587),G1H16(588),G1H16(589),G1H16(590),G1H16(591),G1H16(592),16)
  call HG1shiftOLR(G1H16(588),8,16)
  call Hotf_5pt_reduction(G2H16(201),RedSet_5(10),mass5set(:,3),  & 
G1H16(593),G1H16(594),G1H16(595),G1H16(596),G1H16(597),G1H16(598),16)
  call HG1shiftOLR(G1H16(594),8,16)
  call Hloop_SV_T(ntryL,G1H16(259),36,ex5(:),16,G2H8(193),m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_VV_S(ntryL,G1H16(260),ex5(:),G1H8(21),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hotf_5pt_reduction(G2H16(202),RedSet_5(10),mass5set(:,4),  & 
G1H16(259),G1H16(260),G1H16(599),G1H16(600),G1H16(601),G1H16(602),16)
  call HG1shiftOLR(G1H16(260),8,16)
  call Hloop_SV_V(ntryL,G2H16(203),ex5(:),G2H8(194),m3h2x8(:,215),heltab2x16(:,:,215))
  call Hloop_VV_S(ntryL,G2H16(205),ex5(:),G2H8(195),m3h2x8(:,216),heltab2x16(:,:,216))
  call Hloop_SV_T(ntryL,G1H16(265),36,ex5(:),16,G2H8(196),m3h2x8(:,217),heltab2x16(:,:,217))
  call Hloop_VV_S(ntryL,G1H16(266),ex5(:),G1H8(22),m3h2x8(:,218),heltab2x16(:,:,218))
  call Hloop_SV_V(ntryL,G1H16(267),ex5(:),G1H8(23),m3h2x8(:,219),heltab2x16(:,:,219))
  call Hloop_UW_V(ntryL,G1H16(268),36,ex5(:),16,G2H8(197),m3h2x8(:,220),heltab2x16(:,:,220))
  call Hloop_SV_V(ntryL,G2H16(204),ex5(:),G2H8(198),m3h2x8(:,221),heltab2x16(:,:,221))
  call Hloop_VV_S(ntryL,G2H16(206),ex5(:),G2H8(199),m3h2x8(:,222),heltab2x16(:,:,222))
  call Hotf_5pt_reduction(G2H16(207),RedSet_5(10),mass5set(:,4),  & 
G1H16(265),G1H16(266),G1H16(267),G1H16(268),G1H16(603),G1H16(604),16)
  call HG1shiftOLR(G1H16(266),8,16)
  call Hloop_SV_V(ntryL,G1H16(271),ex5(:),G1H8(24),m3h2x8(:,223),heltab2x16(:,:,223))
  call Hloop_UW_V(ntryL,G1H16(272),36,ex5(:),16,G2H8(200),m3h2x8(:,224),heltab2x16(:,:,224))
  call Hotf_5pt_reduction(G2H16(208),RedSet_5(10),mass5set(:,4),  & 
G1H16(271),G1H16(272),G1H16(605),G1H16(606),G1H16(607),G1H16(608),16)
  call HG1shiftOLR(G1H16(272),8,16)
  call Hloop_SQ_A(ntryL,G1H16(273),ex1(:),G1H8(25),ngH,m3h2x8(:,225),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(201),n2h8(65))
  call Hloop_SQ_A(ntryL,G1H16(274),ex1(:),G1H8(25),ngX,m3h2x8(:,226),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(202),n2h8(66))
  call Hloop_AQ_S(ntryL,G2H16(209),ex1(:),G2H8(203),ngPnl,m3h2x8(:,227),heltab2x16(:,:,227))
  call Hloop_VQ_A(ntryL,G1H16(275),ex1(:),G1H8(25),m3h2x8(:,228),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(204),n2h8(67))
  call Hloop_ZQ_A(ntryL,G1H16(276),ex1(:),G1H8(25),ngZl,m3h2x8(:,229),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(205),n2h8(68))
  call Hloop_AQ_S(ntryL,G2H16(214),ex1(:),G2H8(206),ngPnl,m3h2x8(:,230),heltab2x16(:,:,230))
  call Hloop_AQ_S(ntryL,G2H16(210),ex1(:),G2H8(207),ngPnl,m3h2x8(:,231),heltab2x16(:,:,231))
  call Hloop_AQ_S(ntryL,G2H16(211),ex1(:),G2H8(208),ngPnl,m3h2x8(:,232),heltab2x16(:,:,232))
  call Hloop_AQ_W(ntryL,G2H16(212),ex1(:),G2H8(209),m3h2x8(:,233),heltab2x16(:,:,233))
  call Hloop_AQ_S(ntryL,G2H16(217),ex1(:),G2H8(210),ngPnl,m3h2x8(:,234),heltab2x16(:,:,234))
  call Hloop_AQ_S(ntryL,G2H16(218),ex1(:),G2H8(211),ngPnl,m3h2x8(:,235),heltab2x16(:,:,235))
  call Hloop_AQ_S(ntryL,G2H16(213),ex1(:),G2H8(212),ngPnl,m3h2x8(:,236),heltab2x16(:,:,236))
  call Hloop_AQ_W(ntryL,G2H16(220),ex1(:),G2H8(213),m3h2x8(:,237),heltab2x16(:,:,237))
  call Hloop_AQ_W(ntryL,G2H16(215),ex1(:),G2H8(214),m3h2x8(:,238),heltab2x16(:,:,238))
  call Hloop_AQ_W(ntryL,G2H16(216),ex1(:),G2H8(215),m3h2x8(:,239),heltab2x16(:,:,239))
  call Hloop_AQ_S(ntryL,G2H16(221),ex1(:),G2H8(216),ngPnl,m3h2x8(:,240),heltab2x16(:,:,240))
  call Hloop_AQ_W(ntryL,G2H16(222),ex1(:),G2H8(217),m3h2x8(:,241),heltab2x16(:,:,241))
  call Hloop_AQ_W(ntryL,G2H16(223),ex1(:),G2H8(218),m3h2x8(:,242),heltab2x16(:,:,242))
  call Hloop_AQ_W(ntryL,G2H16(219),ex1(:),G2H8(219),m3h2x8(:,243),heltab2x16(:,:,243))
  call Hloop_AQ_W(ntryL,G2H16(224),ex1(:),G2H8(220),m3h2x8(:,244),heltab2x16(:,:,244))
  call Hloop_SQ_A(ntryL,G1H16(293),ex1(:),G1H8(25),ngH,m3h2x8(:,245),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(221),n2h8(69))
  call Hloop_SQ_A(ntryL,G1H16(294),ex1(:),G1H8(25),ngX,m3h2x8(:,246),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(222),n2h8(70))
  call Hloop_AQ_S(ntryL,G2H16(225),ex1(:),G2H8(223),ngPnl,m3h2x8(:,247),heltab2x16(:,:,247))
  call Hloop_VQ_A(ntryL,G1H16(295),ex1(:),G1H8(25),m3h2x8(:,248),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(224),n2h8(71))
  call Hloop_ZQ_A(ntryL,G1H16(296),ex1(:),G1H8(25),ngZl,m3h2x8(:,249),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G1H8(25),35,nME,G2H8(225),n2h8(72))
  call Hloop_AQ_S(ntryL,G2H16(226),ex1(:),G2H8(226),ngPnl,m3h2x8(:,250),heltab2x16(:,:,250))
  call Hloop_AQ_S(ntryL,G2H16(230),ex1(:),G2H8(227),ngPnl,m3h2x8(:,251),heltab2x16(:,:,251))
  call Hloop_AQ_S(ntryL,G2H16(227),ex1(:),G2H8(228),ngPnl,m3h2x8(:,252),heltab2x16(:,:,252))
  call Hloop_AQ_W(ntryL,G2H16(228),ex1(:),G2H8(229),m3h2x8(:,253),heltab2x16(:,:,253))
  call Hloop_AQ_S(ntryL,G2H16(233),ex1(:),G2H8(230),ngPnl,m3h2x8(:,254),heltab2x16(:,:,254))
  call Hloop_AQ_S(ntryL,G2H16(229),ex1(:),G2H8(231),ngPnl,m3h2x8(:,255),heltab2x16(:,:,255))
  call Hloop_AQ_S(ntryL,G2H16(234),ex1(:),G2H8(232),ngPnl,m3h2x8(:,256),heltab2x16(:,:,256))
  call Hloop_AQ_W(ntryL,G2H16(231),ex1(:),G2H8(233),m3h2x8(:,257),heltab2x16(:,:,257))
  call Hloop_AQ_W(ntryL,G2H16(236),ex1(:),G2H8(234),m3h2x8(:,258),heltab2x16(:,:,258))
  call Hloop_AQ_W(ntryL,G2H16(232),ex1(:),G2H8(235),m3h2x8(:,259),heltab2x16(:,:,259))
  call Hloop_AQ_S(ntryL,G2H16(237),ex1(:),G2H8(236),ngPnl,m3h2x8(:,260),heltab2x16(:,:,260))
  call Hloop_AQ_W(ntryL,G2H16(238),ex1(:),G2H8(237),m3h2x8(:,261),heltab2x16(:,:,261))
  call Hloop_AQ_W(ntryL,G2H16(235),ex1(:),G2H8(238),m3h2x8(:,262),heltab2x16(:,:,262))
  call Hloop_AQ_W(ntryL,G2H16(239),ex1(:),G2H8(239),m3h2x8(:,263),heltab2x16(:,:,263))
  call Hloop_AQ_W(ntryL,G2H16(240),ex1(:),G2H8(240),m3h2x8(:,264),heltab2x16(:,:,264))
  call Hloop_SA_Q(ntryL,G1H16(313),ex2(:),G1H8(25),ngH,m3h2x8(:,265),heltab2x16(:,:,265))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(241),n2h8(73))
  call Hloop_SA_Q(ntryL,G1H16(314),ex2(:),G1H8(25),ngX,m3h2x8(:,266),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(242),n2h8(74))
  call Hloop_QA_S(ntryL,G2H16(241),ex2(:),G2H8(243),ngPln,m3h2x8(:,267),heltab2x16(:,:,267))
  call Hloop_VA_Q(ntryL,G1H16(315),ex2(:),G1H8(25),m3h2x8(:,268),heltab2x16(:,:,268))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(244),n2h8(75))
  call Hloop_ZA_Q(ntryL,G1H16(316),ex2(:),G1H8(25),ngZl,m3h2x8(:,269),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(245),n2h8(76))
  call Hloop_QA_S(ntryL,G2H16(248),ex2(:),G2H8(246),ngPln,m3h2x8(:,270),heltab2x16(:,:,270))
  call Hloop_QA_S(ntryL,G2H16(242),ex2(:),G2H8(247),ngPln,m3h2x8(:,271),heltab2x16(:,:,271))
  call Hloop_QA_S(ntryL,G2H16(243),ex2(:),G2H8(248),ngPln,m3h2x8(:,272),heltab2x16(:,:,272))
  call Hloop_QA_W(ntryL,G2H16(244),ex2(:),G2H8(249),m3h2x8(:,273),heltab2x16(:,:,273))
  call Hloop_QA_S(ntryL,G2H16(250),ex2(:),G2H8(250),ngPln,m3h2x8(:,274),heltab2x16(:,:,274))
  call Hloop_QA_S(ntryL,G2H16(251),ex2(:),G2H8(251),ngPln,m3h2x8(:,275),heltab2x16(:,:,275))
  call Hloop_QA_S(ntryL,G2H16(245),ex2(:),G2H8(252),ngPln,m3h2x8(:,276),heltab2x16(:,:,276))
  call Hloop_QA_W(ntryL,G2H16(252),ex2(:),G2H8(253),m3h2x8(:,277),heltab2x16(:,:,277))
  call Hloop_QA_W(ntryL,G2H16(246),ex2(:),G2H8(254),m3h2x8(:,278),heltab2x16(:,:,278))
  call Hloop_QA_W(ntryL,G2H16(247),ex2(:),G2H8(255),m3h2x8(:,279),heltab2x16(:,:,279))
  call Hloop_QA_S(ntryL,G2H16(253),ex2(:),G2H8(256),ngPln,m3h2x8(:,280),heltab2x16(:,:,280))
  call Hloop_QA_W(ntryL,G2H16(254),ex2(:),G2H8(257),m3h2x8(:,281),heltab2x16(:,:,281))
  call Hloop_QA_W(ntryL,G2H16(255),ex2(:),G2H8(258),m3h2x8(:,282),heltab2x16(:,:,282))
  call Hloop_QA_W(ntryL,G2H16(249),ex2(:),G2H8(259),m3h2x8(:,283),heltab2x16(:,:,283))
  call Hloop_QA_W(ntryL,G2H16(256),ex2(:),G2H8(260),m3h2x8(:,284),heltab2x16(:,:,284))
  call Hloop_SA_Q(ntryL,G1H16(333),ex2(:),G1H8(25),ngH,m3h2x8(:,285),heltab2x16(:,:,285))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(261),n2h8(77))
  call Hloop_SA_Q(ntryL,G1H16(334),ex2(:),G1H8(25),ngX,m3h2x8(:,286),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(262),n2h8(78))
  call Hloop_QA_S(ntryL,G2H16(257),ex2(:),G2H8(263),ngPln,m3h2x8(:,287),heltab2x16(:,:,287))
  call Hloop_VA_Q(ntryL,G1H16(335),ex2(:),G1H8(25),m3h2x8(:,288),heltab2x16(:,:,288))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(264),n2h8(79))
  call Hloop_ZA_Q(ntryL,G1H16(336),ex2(:),G1H8(25),ngZl,m3h2x8(:,289),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(265),n2h8(80))
  call Hloop_QA_S(ntryL,G2H16(264),ex2(:),G2H8(266),ngPln,m3h2x8(:,290),heltab2x16(:,:,290))
  call Hloop_QA_S(ntryL,G2H16(258),ex2(:),G2H8(267),ngPln,m3h2x8(:,291),heltab2x16(:,:,291))
  call Hloop_QA_S(ntryL,G2H16(259),ex2(:),G2H8(268),ngPln,m3h2x8(:,292),heltab2x16(:,:,292))
  call Hloop_QA_W(ntryL,G2H16(260),ex2(:),G2H8(269),m3h2x8(:,293),heltab2x16(:,:,293))
  call Hloop_QA_S(ntryL,G2H16(266),ex2(:),G2H8(270),ngPln,m3h2x8(:,294),heltab2x16(:,:,294))
  call Hloop_QA_S(ntryL,G2H16(267),ex2(:),G2H8(271),ngPln,m3h2x8(:,295),heltab2x16(:,:,295))
  call Hloop_QA_S(ntryL,G2H16(261),ex2(:),G2H8(272),ngPln,m3h2x8(:,296),heltab2x16(:,:,296))
  call Hloop_QA_W(ntryL,G2H16(268),ex2(:),G2H8(273),m3h2x8(:,297),heltab2x16(:,:,297))
  call Hloop_QA_W(ntryL,G2H16(262),ex2(:),G2H8(274),m3h2x8(:,298),heltab2x16(:,:,298))
  call Hloop_QA_W(ntryL,G2H16(263),ex2(:),G2H8(275),m3h2x8(:,299),heltab2x16(:,:,299))
  call Hloop_QA_S(ntryL,G2H16(269),ex2(:),G2H8(276),ngPln,m3h2x8(:,300),heltab2x16(:,:,300))
  call Hloop_QA_W(ntryL,G2H16(270),ex2(:),G2H8(277),m3h2x8(:,301),heltab2x16(:,:,301))
  call Hloop_QA_W(ntryL,G2H16(271),ex2(:),G2H8(278),m3h2x8(:,302),heltab2x16(:,:,302))
  call Hloop_QA_W(ntryL,G2H16(265),ex2(:),G2H8(279),m3h2x8(:,303),heltab2x16(:,:,303))
  call Hloop_QA_W(ntryL,G2H16(272),ex2(:),G2H8(280),m3h2x8(:,304),heltab2x16(:,:,304))
  call Hloop_SA_Q(ntryL,G1H16(353),ex2(:),G1H8(25),ngH,m3h2x8(:,305),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(281),n2h8(81))
  call Hloop_SA_Q(ntryL,G1H16(354),ex2(:),G1H8(25),ngX,m3h2x8(:,306),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(282),n2h8(82))
  call Hloop_QA_S(ntryL,G2H16(273),ex2(:),G2H8(283),ngPln,m3h2x8(:,307),heltab2x16(:,:,307))
  call Hloop_VA_Q(ntryL,G1H16(355),ex2(:),G1H8(25),m3h2x8(:,308),heltab2x16(:,:,308))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(284),n2h8(83))
  call Hloop_ZA_Q(ntryL,G1H16(356),ex2(:),G1H8(25),ngZl,m3h2x8(:,309),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(285),n2h8(84))
  call Hloop_QA_S(ntryL,G2H16(280),ex2(:),G2H8(286),ngPln,m3h2x8(:,310),heltab2x16(:,:,310))
  call Hloop_QA_S(ntryL,G2H16(274),ex2(:),G2H8(287),ngPln,m3h2x8(:,311),heltab2x16(:,:,311))
  call Hloop_QA_S(ntryL,G2H16(275),ex2(:),G2H8(288),ngPln,m3h2x8(:,312),heltab2x16(:,:,312))
  call Hloop_QA_W(ntryL,G2H16(276),ex2(:),G2H8(289),m3h2x8(:,313),heltab2x16(:,:,313))
  call Hloop_QA_S(ntryL,G2H16(282),ex2(:),G2H8(290),ngPln,m3h2x8(:,314),heltab2x16(:,:,314))
  call Hloop_QA_S(ntryL,G2H16(283),ex2(:),G2H8(291),ngPln,m3h2x8(:,315),heltab2x16(:,:,315))
  call Hloop_QA_S(ntryL,G2H16(277),ex2(:),G2H8(292),ngPln,m3h2x8(:,316),heltab2x16(:,:,316))
  call Hloop_QA_W(ntryL,G2H16(284),ex2(:),G2H8(293),m3h2x8(:,317),heltab2x16(:,:,317))
  call Hloop_QA_W(ntryL,G2H16(278),ex2(:),G2H8(294),m3h2x8(:,318),heltab2x16(:,:,318))
  call Hloop_QA_W(ntryL,G2H16(279),ex2(:),G2H8(295),m3h2x8(:,319),heltab2x16(:,:,319))
  call Hloop_QA_S(ntryL,G2H16(285),ex2(:),G2H8(296),ngPln,m3h2x8(:,320),heltab2x16(:,:,320))
  call Hloop_QA_W(ntryL,G2H16(286),ex2(:),G2H8(297),m3h2x8(:,321),heltab2x16(:,:,321))
  call Hloop_QA_W(ntryL,G2H16(287),ex2(:),G2H8(298),m3h2x8(:,322),heltab2x16(:,:,322))
  call Hloop_QA_W(ntryL,G2H16(281),ex2(:),G2H8(299),m3h2x8(:,323),heltab2x16(:,:,323))
  call Hloop_QA_W(ntryL,G2H16(288),ex2(:),G2H8(300),m3h2x8(:,324),heltab2x16(:,:,324))
  call Hloop_SA_Q(ntryL,G1H16(373),ex2(:),G1H8(25),ngH,m3h2x8(:,325),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(301),n2h8(85))
  call Hloop_SA_Q(ntryL,G1H16(374),ex2(:),G1H8(25),ngX,m3h2x8(:,326),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(302),n2h8(86))
  call Hloop_QA_S(ntryL,G2H16(289),ex2(:),G2H8(303),ngPln,m3h2x8(:,327),heltab2x16(:,:,327))
  call Hloop_VA_Q(ntryL,G1H16(375),ex2(:),G1H8(25),m3h2x8(:,328),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(304),n2h8(87))
  call Hloop_ZA_Q(ntryL,G1H16(376),ex2(:),G1H8(25),ngZl,m3h2x8(:,329),heltab2x16(:,:,329))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(305),n2h8(88))
  call Hloop_QA_S(ntryL,G2H16(290),ex2(:),G2H8(306),ngPln,m3h2x8(:,330),heltab2x16(:,:,330))
  call Hloop_QA_S(ntryL,G2H16(296),ex2(:),G2H8(307),ngPln,m3h2x8(:,331),heltab2x16(:,:,331))
  call Hloop_QA_S(ntryL,G2H16(291),ex2(:),G2H8(308),ngPln,m3h2x8(:,332),heltab2x16(:,:,332))
  call Hloop_QA_W(ntryL,G2H16(292),ex2(:),G2H8(309),m3h2x8(:,333),heltab2x16(:,:,333))
  call Hloop_QA_S(ntryL,G2H16(298),ex2(:),G2H8(310),ngPln,m3h2x8(:,334),heltab2x16(:,:,334))
  call Hloop_QA_S(ntryL,G2H16(293),ex2(:),G2H8(311),ngPln,m3h2x8(:,335),heltab2x16(:,:,335))
  call Hloop_QA_S(ntryL,G2H16(299),ex2(:),G2H8(312),ngPln,m3h2x8(:,336),heltab2x16(:,:,336))
  call Hloop_QA_W(ntryL,G2H16(294),ex2(:),G2H8(313),m3h2x8(:,337),heltab2x16(:,:,337))
  call Hloop_QA_W(ntryL,G2H16(300),ex2(:),G2H8(314),m3h2x8(:,338),heltab2x16(:,:,338))
  call Hloop_QA_W(ntryL,G2H16(295),ex2(:),G2H8(315),m3h2x8(:,339),heltab2x16(:,:,339))
  call Hloop_QA_S(ntryL,G2H16(301),ex2(:),G2H8(316),ngPln,m3h2x8(:,340),heltab2x16(:,:,340))
  call Hloop_QA_W(ntryL,G2H16(302),ex2(:),G2H8(317),m3h2x8(:,341),heltab2x16(:,:,341))
  call Hloop_QA_W(ntryL,G2H16(297),ex2(:),G2H8(318),m3h2x8(:,342),heltab2x16(:,:,342))
  call Hloop_QA_W(ntryL,G2H16(303),ex2(:),G2H8(319),m3h2x8(:,343),heltab2x16(:,:,343))
  call Hloop_QA_W(ntryL,G2H16(304),ex2(:),G2H8(320),m3h2x8(:,344),heltab2x16(:,:,344))
  call Hloop_SA_Q(ntryL,G1H16(393),ex2(:),G1H8(25),ngH,m3h2x8(:,345),heltab2x16(:,:,345))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(321),n2h8(89))
  call Hloop_SA_Q(ntryL,G1H16(394),ex2(:),G1H8(25),ngX,m3h2x8(:,346),heltab2x16(:,:,346))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(322),n2h8(90))
  call Hloop_QA_S(ntryL,G2H16(305),ex2(:),G2H8(323),ngPln,m3h2x8(:,347),heltab2x16(:,:,347))
  call Hloop_VA_Q(ntryL,G1H16(395),ex2(:),G1H8(25),m3h2x8(:,348),heltab2x16(:,:,348))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(324),n2h8(91))
  call Hloop_ZA_Q(ntryL,G1H16(396),ex2(:),G1H8(25),ngZl,m3h2x8(:,349),heltab2x16(:,:,349))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(325),n2h8(92))
  call Hloop_QA_S(ntryL,G2H16(312),ex2(:),G2H8(326),ngPln,m3h2x8(:,350),heltab2x16(:,:,350))
  call Hloop_QA_S(ntryL,G2H16(306),ex2(:),G2H8(327),ngPln,m3h2x8(:,351),heltab2x16(:,:,351))
  call Hloop_QA_S(ntryL,G2H16(307),ex2(:),G2H8(328),ngPln,m3h2x8(:,352),heltab2x16(:,:,352))
  call Hloop_QA_W(ntryL,G2H16(308),ex2(:),G2H8(329),m3h2x8(:,353),heltab2x16(:,:,353))
  call Hloop_QA_S(ntryL,G2H16(314),ex2(:),G2H8(330),ngPln,m3h2x8(:,354),heltab2x16(:,:,354))
  call Hloop_QA_S(ntryL,G2H16(315),ex2(:),G2H8(331),ngPln,m3h2x8(:,355),heltab2x16(:,:,355))
  call Hloop_QA_S(ntryL,G2H16(309),ex2(:),G2H8(332),ngPln,m3h2x8(:,356),heltab2x16(:,:,356))
  call Hloop_QA_W(ntryL,G2H16(316),ex2(:),G2H8(333),m3h2x8(:,357),heltab2x16(:,:,357))
  call Hloop_QA_W(ntryL,G2H16(310),ex2(:),G2H8(334),m3h2x8(:,358),heltab2x16(:,:,358))
  call Hloop_QA_W(ntryL,G2H16(311),ex2(:),G2H8(335),m3h2x8(:,359),heltab2x16(:,:,359))
  call Hloop_QA_S(ntryL,G2H16(317),ex2(:),G2H8(336),ngPln,m3h2x8(:,360),heltab2x16(:,:,360))
  call Hloop_QA_W(ntryL,G2H16(318),ex2(:),G2H8(337),m3h2x8(:,361),heltab2x16(:,:,361))
  call Hloop_QA_W(ntryL,G2H16(319),ex2(:),G2H8(338),m3h2x8(:,362),heltab2x16(:,:,362))
  call Hloop_QA_W(ntryL,G2H16(313),ex2(:),G2H8(339),m3h2x8(:,363),heltab2x16(:,:,363))
  call Hloop_QA_W(ntryL,G2H16(320),ex2(:),G2H8(340),m3h2x8(:,364),heltab2x16(:,:,364))
  call Hloop_SA_Q(ntryL,G1H16(413),ex2(:),G1H8(25),ngH,m3h2x8(:,365),heltab2x16(:,:,365))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(341),n2h8(93))
  call Hloop_SA_Q(ntryL,G1H16(414),ex2(:),G1H8(25),ngX,m3h2x8(:,366),heltab2x16(:,:,366))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(342),n2h8(94))
  call Hloop_QA_S(ntryL,G2H16(321),ex2(:),G2H8(343),ngPln,m3h2x8(:,367),heltab2x16(:,:,367))
  call Hloop_VA_Q(ntryL,G1H16(415),ex2(:),G1H8(25),m3h2x8(:,368),heltab2x16(:,:,368))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(344),n2h8(95))
  call Hloop_ZA_Q(ntryL,G1H16(416),ex2(:),G1H8(25),ngZl,m3h2x8(:,369),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G1H8(25),35,nME,G2H8(345),n2h8(96))
  call Hloop_QA_S(ntryL,G2H16(322),ex2(:),G2H8(346),ngPln,m3h2x8(:,370),heltab2x16(:,:,370))
  call Hloop_QA_S(ntryL,G2H16(328),ex2(:),G2H8(347),ngPln,m3h2x8(:,371),heltab2x16(:,:,371))
  call Hloop_QA_S(ntryL,G2H16(323),ex2(:),G2H8(348),ngPln,m3h2x8(:,372),heltab2x16(:,:,372))
  call Hloop_QA_W(ntryL,G2H16(324),ex2(:),G2H8(349),m3h2x8(:,373),heltab2x16(:,:,373))
  call Hloop_QA_S(ntryL,G2H16(330),ex2(:),G2H8(350),ngPln,m3h2x8(:,374),heltab2x16(:,:,374))
  call Hloop_QA_S(ntryL,G2H16(325),ex2(:),G2H8(351),ngPln,m3h2x8(:,375),heltab2x16(:,:,375))
  call Hloop_QA_S(ntryL,G2H16(331),ex2(:),G2H8(352),ngPln,m3h2x8(:,376),heltab2x16(:,:,376))
  call Hloop_QA_W(ntryL,G2H16(326),ex2(:),G2H8(353),m3h2x8(:,377),heltab2x16(:,:,377))
  call Hloop_QA_W(ntryL,G2H16(332),ex2(:),G2H8(354),m3h2x8(:,378),heltab2x16(:,:,378))
  call Hloop_QA_W(ntryL,G2H16(327),ex2(:),G2H8(355),m3h2x8(:,379),heltab2x16(:,:,379))
  call Hloop_QA_S(ntryL,G2H16(333),ex2(:),G2H8(356),ngPln,m3h2x8(:,380),heltab2x16(:,:,380))
  call Hloop_QA_W(ntryL,G2H16(334),ex2(:),G2H8(357),m3h2x8(:,381),heltab2x16(:,:,381))
  call Hloop_QA_W(ntryL,G2H16(329),ex2(:),G2H8(358),m3h2x8(:,382),heltab2x16(:,:,382))
  call Hloop_QA_W(ntryL,G2H16(335),ex2(:),G2H8(359),m3h2x8(:,383),heltab2x16(:,:,383))
  call Hloop_QA_W(ntryL,G2H16(336),ex2(:),G2H8(360),m3h2x8(:,384),heltab2x16(:,:,384))
  call Hloop_SA_Q(ntryL,G1H16(433),ex2(:),G1H8(25),ngPln,m3h2x8(:,385),heltab2x16(:,:,385))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(361),n2h8(97))
call HGT_OLR(G1H16(1),1,1,16)
call HGT_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(1),-16,ex5(:),16,G2H8(362),m3h2x8(:,386),heltab2x16(:,:,386))
  call Hloop_SA_Q(ntryL,G1H16(4),ex2(:),G1H8(25),ngPln,m3h2x8(:,387),heltab2x16(:,:,387))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(363),n2h8(98))
  call Hloop_SA_Q(ntryL,G1H16(6),ex2(:),G1H8(25),ngPln,m3h2x8(:,388),heltab2x16(:,:,388))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(364),n2h8(99))
  call Hloop_SA_Q(ntryL,G1H16(7),ex2(:),G1H8(25),ngPln,m3h2x8(:,389),heltab2x16(:,:,389))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(365),n2h8(100))
  call Hloop_SA_Q(ntryL,G1H16(8),ex2(:),G1H8(25),ngPln,m3h2x8(:,390),heltab2x16(:,:,390))
  call Hloop_A_Q(ntryL,G1H8(25),42,0,G2H8(366),n2h8(101))
call HGT_OLR(G1H16(12),1,1,16)
call HGT_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(12),ex5(:),G1H8(25),m3h2x8(:,391),heltab2x16(:,:,391))
  call Hloop_SA_Q(ntryL,G1H16(17),ex2(:),G1H8(26),ngPln,m3h2x8(:,392),heltab2x16(:,:,392))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(367),n2h8(102))
  call Hloop_SA_Q(ntryL,G1H16(18),ex2(:),G1H8(26),ngPln,m3h2x8(:,393),heltab2x16(:,:,393))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(368),n2h8(103))
  call Hloop_SA_Q(ntryL,G1H16(19),ex2(:),G1H8(26),ngPln,m3h2x8(:,394),heltab2x16(:,:,394))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(369),n2h8(104))
  call Hloop_SA_Q(ntryL,G1H16(21),ex2(:),G1H8(26),ngPln,m3h2x8(:,395),heltab2x16(:,:,395))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(370),n2h8(105))
call HGT_OLR(G1H16(22),1,1,16)
call HGT_invQ_OLR(G1H16(22),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(22),-16,ex5(:),16,G2H8(371),m3h2x8(:,396),heltab2x16(:,:,396))
  call Hloop_SA_Q(ntryL,G1H16(26),ex2(:),G1H8(26),ngPln,m3h2x8(:,397),heltab2x16(:,:,397))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(372),n2h8(106))
  call Hloop_SA_Q(ntryL,G1H16(29),ex2(:),G1H8(26),ngPln,m3h2x8(:,398),heltab2x16(:,:,398))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(373),n2h8(107))
  call Hloop_SA_Q(ntryL,G1H16(33),ex2(:),G1H8(26),ngPln,m3h2x8(:,399),heltab2x16(:,:,399))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(374),n2h8(108))
  call Hloop_WA_Q(ntryL,G1H16(34),ex2(:),G1H8(26),m3h2x8(:,400),heltab2x16(:,:,400))
  call Hloop_A_Q(ntryL,G1H8(26),42,0,G2H8(375),n2h8(109))
call HGT_raise_alpha_OLR(G1H16(37),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(37),ex5(:),G1H8(26),m3h2x8(:,401),heltab2x16(:,:,401))
  call Hloop_WA_Q(ntryL,G1H16(39),ex2(:),G1H8(27),m3h2x8(:,402),heltab2x16(:,:,402))
  call Hloop_A_Q(ntryL,G1H8(27),42,0,G2H8(376),n2h8(110))
  call Hloop_WA_Q(ntryL,G1H16(40),ex2(:),G1H8(27),m3h2x8(:,403),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G1H8(27),42,0,G2H8(377),n2h8(111))
  call Hloop_WA_Q(ntryL,G1H16(45),ex2(:),G1H8(27),m3h2x8(:,404),heltab2x16(:,:,404))
  call Hloop_A_Q(ntryL,G1H8(27),42,0,G2H8(378),n2h8(112))
  call Hloop_SA_Q(ntryL,G1H16(46),ex2(:),G1H8(27),ngPln,m3h2x8(:,405),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G1H8(27),42,0,G2H8(379),n2h8(113))
call HGT_OLR(G1H16(49),1,1,16)
call HGT_invQ_OLR(G1H16(49),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(49),ex5(:),G1H8(27),m3h2x8(:,406),heltab2x16(:,:,406))
  call Hloop_SA_Q(ntryL,G1H16(51),ex2(:),G1H8(28),ngPln,m3h2x8(:,407),heltab2x16(:,:,407))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(380),n2h8(114))
  call Hloop_SA_Q(ntryL,G1H16(53),ex2(:),G1H8(28),ngPln,m3h2x8(:,408),heltab2x16(:,:,408))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(381),n2h8(115))
  call Hloop_SA_Q(ntryL,G1H16(54),ex2(:),G1H8(28),ngPln,m3h2x8(:,409),heltab2x16(:,:,409))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(382),n2h8(116))
  call Hloop_WA_Q(ntryL,G1H16(56),ex2(:),G1H8(28),m3h2x8(:,410),heltab2x16(:,:,410))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(383),n2h8(117))
call HGT_raise_alpha_OLR(G1H16(58),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(58),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(58),-16,ex5(:),16,G2H8(384),m3h2x8(:,411),heltab2x16(:,:,411))
  call Hloop_WA_Q(ntryL,G1H16(70),ex2(:),G1H8(28),m3h2x8(:,412),heltab2x16(:,:,412))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(385),n2h8(118))
  call Hloop_WA_Q(ntryL,G1H16(69),ex2(:),G1H8(28),m3h2x8(:,413),heltab2x16(:,:,413))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(386),n2h8(119))
  call Hloop_WA_Q(ntryL,G1H16(73),ex2(:),G1H8(28),m3h2x8(:,414),heltab2x16(:,:,414))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(387),n2h8(120))
  call Hloop_WA_Q(ntryL,G1H16(74),ex2(:),G1H8(28),m3h2x8(:,415),heltab2x16(:,:,415))
  call Hloop_A_Q(ntryL,G1H8(28),42,0,G2H8(388),n2h8(121))
call HGT_raise_alpha_OLR(G1H16(76),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(76),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(76),ex5(:),G1H8(28),m3h2x8(:,416),heltab2x16(:,:,416))
  call Hloop_WA_Q(ntryL,G1H16(72),ex2(:),G1H8(29),m3h2x8(:,417),heltab2x16(:,:,417))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(389),n2h8(122))
  call Hloop_WA_Q(ntryL,G1H16(78),ex2(:),G1H8(29),m3h2x8(:,418),heltab2x16(:,:,418))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(390),n2h8(123))
  call Hloop_WA_Q(ntryL,G1H16(75),ex2(:),G1H8(29),m3h2x8(:,419),heltab2x16(:,:,419))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(391),n2h8(124))
  call Hloop_WA_Q(ntryL,G1H16(81),ex2(:),G1H8(29),m3h2x8(:,420),heltab2x16(:,:,420))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(392),n2h8(125))
call HGT_raise_alpha_OLR(G1H16(82),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(82),-16,ex5(:),16,G2H8(393),m3h2x8(:,421),heltab2x16(:,:,421))
  call Hloop_WA_Q(ntryL,G1H16(79),ex2(:),G1H8(29),m3h2x8(:,422),heltab2x16(:,:,422))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(394),n2h8(126))
  call Hloop_WA_Q(ntryL,G1H16(80),ex2(:),G1H8(29),m3h2x8(:,423),heltab2x16(:,:,423))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(395),n2h8(127))
  call Hloop_WA_Q(ntryL,G1H16(84),ex2(:),G1H8(29),m3h2x8(:,424),heltab2x16(:,:,424))
  call Hloop_A_Q(ntryL,G1H8(29),42,0,G2H8(396),n2h8(128))
  call Hloop_SQ_A(ntryL,G1H16(83),ex1(:),G1H8(29),ngPnl,m3h2x8(:,425),heltab2x16(:,:,425))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(397),n2h8(129))
call HGT_OLR(G1H16(90),1,1,16)
call HGT_invQ_OLR(G1H16(90),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(90),-16,ex5(:),16,G2H8(398),m3h2x8(:,426),heltab2x16(:,:,426))
  call Hloop_SQ_A(ntryL,G1H16(93),ex1(:),G1H8(29),ngPnl,m3h2x8(:,427),heltab2x16(:,:,427))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(399),n2h8(130))
  call Hloop_SQ_A(ntryL,G1H16(94),ex1(:),G1H8(29),ngPnl,m3h2x8(:,428),heltab2x16(:,:,428))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(400),n2h8(131))
  call Hloop_SQ_A(ntryL,G1H16(96),ex1(:),G1H8(29),ngPnl,m3h2x8(:,429),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(401),n2h8(132))
  call Hloop_SQ_A(ntryL,G1H16(91),ex1(:),G1H8(29),ngPnl,m3h2x8(:,430),heltab2x16(:,:,430))
  call Hloop_Q_A(ntryL,G1H8(29),37,0,G2H8(402),n2h8(133))
call HGT_OLR(G1H16(92),1,1,16)
call HGT_invQ_OLR(G1H16(92),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(92),ex5(:),G1H8(29),m3h2x8(:,431),heltab2x16(:,:,431))
  call Hloop_SQ_A(ntryL,G1H16(95),ex1(:),G1H8(30),ngPnl,m3h2x8(:,432),heltab2x16(:,:,432))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(403),n2h8(134))
  call Hloop_SQ_A(ntryL,G1H16(101),ex1(:),G1H8(30),ngPnl,m3h2x8(:,433),heltab2x16(:,:,433))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(404),n2h8(135))
  call Hloop_SQ_A(ntryL,G1H16(102),ex1(:),G1H8(30),ngPnl,m3h2x8(:,434),heltab2x16(:,:,434))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(405),n2h8(136))
  call Hloop_SQ_A(ntryL,G1H16(97),ex1(:),G1H8(30),ngPnl,m3h2x8(:,435),heltab2x16(:,:,435))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(406),n2h8(137))
call HGT_OLR(G1H16(99),1,1,16)
call HGT_invQ_OLR(G1H16(99),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(99),-16,ex5(:),16,G2H8(407),m3h2x8(:,436),heltab2x16(:,:,436))
  call Hloop_SQ_A(ntryL,G1H16(104),ex1(:),G1H8(30),ngPnl,m3h2x8(:,437),heltab2x16(:,:,437))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(408),n2h8(138))
  call Hloop_SQ_A(ntryL,G1H16(103),ex1(:),G1H8(30),ngPnl,m3h2x8(:,438),heltab2x16(:,:,438))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(409),n2h8(139))
  call Hloop_SQ_A(ntryL,G1H16(105),ex1(:),G1H8(30),ngPnl,m3h2x8(:,439),heltab2x16(:,:,439))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(410),n2h8(140))
  call Hloop_SQ_A(ntryL,G1H16(106),ex1(:),G1H8(30),ngPnl,m3h2x8(:,440),heltab2x16(:,:,440))
  call Hloop_Q_A(ntryL,G1H8(30),37,0,G2H8(411),n2h8(141))
call HGT_OLR(G1H16(108),1,1,16)
call HGT_invQ_OLR(G1H16(108),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(108),ex5(:),G1H8(30),m3h2x8(:,441),heltab2x16(:,:,441))
  call Hloop_SQ_A(ntryL,G1H16(111),ex1(:),G1H8(31),ngPnl,m3h2x8(:,442),heltab2x16(:,:,442))
  call Hloop_Q_A(ntryL,G1H8(31),37,0,G2H8(412),n2h8(142))
  call Hloop_SQ_A(ntryL,G1H16(112),ex1(:),G1H8(31),ngPnl,m3h2x8(:,443),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H8(31),37,0,G2H8(413),n2h8(143))
  call Hloop_SQ_A(ntryL,G1H16(115),ex1(:),G1H8(31),ngPnl,m3h2x8(:,444),heltab2x16(:,:,444))
  call Hloop_Q_A(ntryL,G1H8(31),37,0,G2H8(414),n2h8(144))
  call Hloop_WQ_A(ntryL,G1H16(118),ex1(:),G1H8(31),m3h2x8(:,445),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G1H8(31),37,0,G2H8(415),n2h8(145))
call HGT_raise_alpha_OLR(G1H16(121),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(121),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(121),ex5(:),G1H8(31),m3h2x8(:,446),heltab2x16(:,:,446))
  call Hloop_WQ_A(ntryL,G1H16(123),ex1(:),G1H8(32),m3h2x8(:,447),heltab2x16(:,:,447))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(416),n2h8(146))
  call Hloop_WQ_A(ntryL,G1H16(125),ex1(:),G1H8(32),m3h2x8(:,448),heltab2x16(:,:,448))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(417),n2h8(147))
  call Hloop_WQ_A(ntryL,G1H16(127),ex1(:),G1H8(32),m3h2x8(:,449),heltab2x16(:,:,449))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(418),n2h8(148))
  call Hloop_WQ_A(ntryL,G1H16(128),ex1(:),G1H8(32),m3h2x8(:,450),heltab2x16(:,:,450))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(419),n2h8(149))
call HGT_raise_alpha_OLR(G1H16(131),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(131),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(131),-16,ex5(:),16,G2H8(420),m3h2x8(:,451),heltab2x16(:,:,451))
  call Hloop_WQ_A(ntryL,G1H16(137),ex1(:),G1H8(32),m3h2x8(:,452),heltab2x16(:,:,452))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(421),n2h8(150))
  call Hloop_WQ_A(ntryL,G1H16(138),ex1(:),G1H8(32),m3h2x8(:,453),heltab2x16(:,:,453))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(422),n2h8(151))
  call Hloop_WQ_A(ntryL,G1H16(141),ex1(:),G1H8(32),m3h2x8(:,454),heltab2x16(:,:,454))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(423),n2h8(152))
  call Hloop_WQ_A(ntryL,G1H16(142),ex1(:),G1H8(32),m3h2x8(:,455),heltab2x16(:,:,455))
  call Hloop_Q_A(ntryL,G1H8(32),37,0,G2H8(424),n2h8(153))
call HGT_raise_alpha_OLR(G1H16(143),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(143),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(143),ex5(:),G1H8(32),m3h2x8(:,456),heltab2x16(:,:,456))
  call Hloop_WQ_A(ntryL,G1H16(149),ex1(:),G1H8(33),m3h2x8(:,457),heltab2x16(:,:,457))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(425),n2h8(154))
  call Hloop_WQ_A(ntryL,G1H16(150),ex1(:),G1H8(33),m3h2x8(:,458),heltab2x16(:,:,458))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(426),n2h8(155))
  call Hloop_WQ_A(ntryL,G1H16(153),ex1(:),G1H8(33),m3h2x8(:,459),heltab2x16(:,:,459))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(427),n2h8(156))
  call Hloop_WQ_A(ntryL,G1H16(154),ex1(:),G1H8(33),m3h2x8(:,460),heltab2x16(:,:,460))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(428),n2h8(157))
call HGT_raise_alpha_OLR(G1H16(157),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(157),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(157),-16,ex5(:),16,G2H8(429),m3h2x8(:,461),heltab2x16(:,:,461))
  call Hloop_WQ_A(ntryL,G1H16(159),ex1(:),G1H8(33),m3h2x8(:,462),heltab2x16(:,:,462))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(430),n2h8(158))
  call Hloop_WQ_A(ntryL,G1H16(160),ex1(:),G1H8(33),m3h2x8(:,463),heltab2x16(:,:,463))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(431),n2h8(159))
  call Hloop_WQ_A(ntryL,G1H16(165),ex1(:),G1H8(33),m3h2x8(:,464),heltab2x16(:,:,464))
  call Hloop_Q_A(ntryL,G1H8(33),37,0,G2H8(432),n2h8(160))
  call Hloop_AV_Q(ntryL,G1H16(166),ex3(:),G1H8(33),m3h2x8(:,465),heltab2x16(:,:,465))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(433),n2h8(161))
call HGT_OLR(G1H16(174),1,1,16)
call HGT_invQ_OLR(G1H16(174),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(174),-16,nME,G2H16(1),n2h16(449))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(434),m3h2x8(:,466),heltab2x16(:,:,466))
  call Hloop_AV_Q(ntryL,G1H16(177),ex3(:),G1H8(33),m3h2x8(:,467),heltab2x16(:,:,467))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(435),n2h8(162))
  call Hloop_AV_Q(ntryL,G1H16(178),ex3(:),G1H8(33),m3h2x8(:,468),heltab2x16(:,:,468))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(436),n2h8(163))
  call Hloop_AV_Q(ntryL,G1H16(180),ex3(:),G1H8(33),m3h2x8(:,469),heltab2x16(:,:,469))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(437),n2h8(164))
  call Hloop_AV_Q(ntryL,G1H16(175),ex3(:),G1H8(33),m3h2x8(:,470),heltab2x16(:,:,470))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(438),n2h8(165))
call HGT_OLR(G1H16(176),1,1,16)
call HGT_invQ_OLR(G1H16(176),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(176),-16,nME,G2H16(2),n2h16(450))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(439),m3h2x8(:,471),heltab2x16(:,:,471))
  call Hloop_AV_Q(ntryL,G1H16(179),ex3(:),G1H8(33),m3h2x8(:,472),heltab2x16(:,:,472))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(440),n2h8(166))
  call Hloop_AV_Q(ntryL,G1H16(185),ex3(:),G1H8(33),m3h2x8(:,473),heltab2x16(:,:,473))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(441),n2h8(167))
  call Hloop_AV_Q(ntryL,G1H16(186),ex3(:),G1H8(33),m3h2x8(:,474),heltab2x16(:,:,474))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(442),n2h8(168))
  call Hloop_SV_T(ntryL,G1H16(181),40,ex3(:),4,G2H8(443),m3h2x8(:,475),heltab2x16(:,:,475))
call HGT_OLR(G1H16(183),1,1,16)
call HGT_invQ_OLR(G1H16(183),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(183),-16,ex5(:),16,G2H8(444),m3h2x8(:,476),heltab2x16(:,:,476))
  call Hloop_SV_T(ntryL,G1H16(188),40,ex3(:),4,G2H8(445),m3h2x8(:,477),heltab2x16(:,:,477))
  call Hloop_SV_T(ntryL,G1H16(187),40,ex3(:),4,G2H8(446),m3h2x8(:,478),heltab2x16(:,:,478))
  call Hloop_SV_T(ntryL,G1H16(194),40,ex3(:),4,G2H8(447),m3h2x8(:,479),heltab2x16(:,:,479))
  call Hloop_AV_Q(ntryL,G1H16(197),ex3(:),G1H8(33),m3h2x8(:,480),heltab2x16(:,:,480))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(448),n2h8(169))
call HGT_OLR(G1H16(193),1,1,16)
call HGT_invQ_OLR(G1H16(193),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(193),-16,nME,G2H16(3),n2h16(452))
  call Hloop_QV_A(ntryL,G2H16(3),ex5(:),G2H8(449),m3h2x8(:,481),heltab2x16(:,:,481))
  call Hloop_AV_Q(ntryL,G1H16(200),ex3(:),G1H8(33),m3h2x8(:,482),heltab2x16(:,:,482))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(450),n2h8(170))
  call Hloop_AV_Q(ntryL,G1H16(195),ex3(:),G1H8(33),m3h2x8(:,483),heltab2x16(:,:,483))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(451),n2h8(171))
  call Hloop_AV_Q(ntryL,G1H16(202),ex3(:),G1H8(33),m3h2x8(:,484),heltab2x16(:,:,484))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(452),n2h8(172))
  call Hloop_AV_Q(ntryL,G1H16(196),ex3(:),G1H8(33),m3h2x8(:,485),heltab2x16(:,:,485))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(453),n2h8(173))
call HGT_OLR(G1H16(205),1,1,16)
call HGT_invQ_OLR(G1H16(205),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(205),-16,nME,G2H16(4),n2h16(453))
  call Hloop_QV_A(ntryL,G2H16(4),ex5(:),G2H8(454),m3h2x8(:,486),heltab2x16(:,:,486))
  call Hloop_AV_Q(ntryL,G1H16(206),ex3(:),G1H8(33),m3h2x8(:,487),heltab2x16(:,:,487))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(455),n2h8(174))
  call Hloop_AV_Q(ntryL,G1H16(201),ex3(:),G1H8(33),m3h2x8(:,488),heltab2x16(:,:,488))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(456),n2h8(175))
  call Hloop_AV_Q(ntryL,G1H16(203),ex3(:),G1H8(33),m3h2x8(:,489),heltab2x16(:,:,489))
  call Hloop_A_Q(ntryL,G1H8(33),44,nME,G2H8(457),n2h8(176))
  call Hloop_SV_T(ntryL,G1H16(208),40,ex3(:),4,G2H8(458),m3h2x8(:,490),heltab2x16(:,:,490))
call HGT_OLR(G1H16(204),1,1,16)
call HGT_invQ_OLR(G1H16(204),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(204),ex5(:),G1H8(33),m3h2x8(:,491),heltab2x16(:,:,491))
  call Hloop_SV_T(ntryL,G1H16(209),40,ex3(:),4,G2H8(459),m3h2x8(:,492),heltab2x16(:,:,492))
  call Hloop_SV_T(ntryL,G1H16(210),40,ex3(:),4,G2H8(460),m3h2x8(:,493),heltab2x16(:,:,493))
  call Hloop_SV_T(ntryL,G1H16(213),40,ex3(:),4,G2H8(461),m3h2x8(:,494),heltab2x16(:,:,494))
  call Hloop_UW_V(ntryL,G1H16(214),40,ex3(:),4,G2H8(462),m3h2x8(:,495),heltab2x16(:,:,495))
call HGT_raise_alpha_OLR(G1H16(215),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(215),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(215),ex5(:),G1H8(34),m3h2x8(:,496),heltab2x16(:,:,496))
  call Hloop_UW_V(ntryL,G1H16(221),40,ex3(:),4,G2H8(463),m3h2x8(:,497),heltab2x16(:,:,497))
  call Hloop_UW_V(ntryL,G1H16(222),40,ex3(:),4,G2H8(464),m3h2x8(:,498),heltab2x16(:,:,498))
  call Hloop_UW_V(ntryL,G1H16(225),40,ex3(:),4,G2H8(465),m3h2x8(:,499),heltab2x16(:,:,499))
  call Hloop_UW_V(ntryL,G1H16(226),40,ex3(:),4,G2H8(466),m3h2x8(:,500),heltab2x16(:,:,500))
call HGT_raise_alpha_OLR(G1H16(227),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(227),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(227),-16,ex5(:),16,G2H8(467),m3h2x8(:,501),heltab2x16(:,:,501))
  call Hloop_UW_V(ntryL,G1H16(231),40,ex3(:),4,G2H8(468),m3h2x8(:,502),heltab2x16(:,:,502))
  call Hloop_UW_V(ntryL,G1H16(232),40,ex3(:),4,G2H8(469),m3h2x8(:,503),heltab2x16(:,:,503))
  call Hloop_UW_V(ntryL,G1H16(235),40,ex3(:),4,G2H8(470),m3h2x8(:,504),heltab2x16(:,:,504))
  call Hloop_SQ_A(ntryL,G1H16(237),ex1(:),G1H8(35),ngPnl,m3h2x8(:,505),heltab2x16(:,:,505))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(471),n2h8(177))
call HGT_OLR(G1H16(241),1,1,16)
call HGT_invQ_OLR(G1H16(241),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(241),-8,ex4(:),8,G2H8(472),m3h2x8(:,506),heltab2x16(:,:,506))
  call Hloop_SQ_A(ntryL,G1H16(245),ex1(:),G1H8(35),ngPnl,m3h2x8(:,507),heltab2x16(:,:,507))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(473),n2h8(178))
  call Hloop_SQ_A(ntryL,G1H16(246),ex1(:),G1H8(35),ngPnl,m3h2x8(:,508),heltab2x16(:,:,508))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(474),n2h8(179))
  call Hloop_SQ_A(ntryL,G1H16(247),ex1(:),G1H8(35),ngPnl,m3h2x8(:,509),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(475),n2h8(180))
  call Hloop_SQ_A(ntryL,G1H16(248),ex1(:),G1H8(35),ngPnl,m3h2x8(:,510),heltab2x16(:,:,510))
  call Hloop_Q_A(ntryL,G1H8(35),37,0,G2H8(476),n2h8(181))
call HGT_OLR(G1H16(253),1,1,16)
call HGT_invQ_OLR(G1H16(253),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(253),ex4(:),G1H8(35),m3h2x8(:,511),heltab2x16(:,:,511))
  call Hloop_SQ_A(ntryL,G1H16(257),ex1(:),G1H8(36),ngPnl,m3h2x8(:,512),heltab2x16(:,:,512))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(477),n2h8(182))
  call Hloop_SQ_A(ntryL,G1H16(258),ex1(:),G1H8(36),ngPnl,m3h2x8(:,513),heltab2x16(:,:,513))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(478),n2h8(183))
  call Hloop_SQ_A(ntryL,G1H16(261),ex1(:),G1H8(36),ngPnl,m3h2x8(:,514),heltab2x16(:,:,514))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(479),n2h8(184))
  call Hloop_SQ_A(ntryL,G1H16(262),ex1(:),G1H8(36),ngPnl,m3h2x8(:,515),heltab2x16(:,:,515))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(480),n2h8(185))
call HGT_OLR(G1H16(263),1,1,16)
call HGT_invQ_OLR(G1H16(263),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(263),-8,ex4(:),8,G2H8(481),m3h2x8(:,516),heltab2x16(:,:,516))
  call Hloop_SQ_A(ntryL,G1H16(269),ex1(:),G1H8(36),ngPnl,m3h2x8(:,517),heltab2x16(:,:,517))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(482),n2h8(186))
  call Hloop_SQ_A(ntryL,G1H16(270),ex1(:),G1H8(36),ngPnl,m3h2x8(:,518),heltab2x16(:,:,518))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(483),n2h8(187))
  call Hloop_SQ_A(ntryL,G1H16(278),ex1(:),G1H8(36),ngPnl,m3h2x8(:,519),heltab2x16(:,:,519))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(484),n2h8(188))
  call Hloop_SQ_A(ntryL,G1H16(277),ex1(:),G1H8(36),ngPnl,m3h2x8(:,520),heltab2x16(:,:,520))
  call Hloop_Q_A(ntryL,G1H8(36),37,0,G2H8(485),n2h8(189))
call HGT_OLR(G1H16(281),1,1,16)
call HGT_invQ_OLR(G1H16(281),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(281),ex4(:),G1H8(36),m3h2x8(:,521),heltab2x16(:,:,521))
  call Hloop_SQ_A(ntryL,G1H16(284),ex1(:),G1H8(37),ngPnl,m3h2x8(:,522),heltab2x16(:,:,522))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(486),n2h8(190))
  call Hloop_SQ_A(ntryL,G1H16(279),ex1(:),G1H8(37),ngPnl,m3h2x8(:,523),heltab2x16(:,:,523))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(487),n2h8(191))
  call Hloop_SQ_A(ntryL,G1H16(280),ex1(:),G1H8(37),ngPnl,m3h2x8(:,524),heltab2x16(:,:,524))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(488),n2h8(192))
  call Hloop_WQ_A(ntryL,G1H16(286),ex1(:),G1H8(37),m3h2x8(:,525),heltab2x16(:,:,525))
  call Hloop_Q_A(ntryL,G1H8(37),37,0,G2H8(489),n2h8(193))
call HGT_raise_alpha_OLR(G1H16(283),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(283),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(283),ex4(:),G1H8(37),m3h2x8(:,526),heltab2x16(:,:,526))
  call Hloop_WQ_A(ntryL,G1H16(290),ex1(:),G1H8(38),m3h2x8(:,527),heltab2x16(:,:,527))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(490),n2h8(194))
  call Hloop_WQ_A(ntryL,G1H16(285),ex1(:),G1H8(38),m3h2x8(:,528),heltab2x16(:,:,528))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(491),n2h8(195))
  call Hloop_WQ_A(ntryL,G1H16(287),ex1(:),G1H8(38),m3h2x8(:,529),heltab2x16(:,:,529))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(492),n2h8(196))
  call Hloop_WQ_A(ntryL,G1H16(288),ex1(:),G1H8(38),m3h2x8(:,530),heltab2x16(:,:,530))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(493),n2h8(197))
call HGT_raise_alpha_OLR(G1H16(292),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(292),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(292),-8,ex4(:),8,G2H8(494),m3h2x8(:,531),heltab2x16(:,:,531))
  call Hloop_WQ_A(ntryL,G1H16(298),ex1(:),G1H8(38),m3h2x8(:,532),heltab2x16(:,:,532))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(495),n2h8(198))
  call Hloop_WQ_A(ntryL,G1H16(301),ex1(:),G1H8(38),m3h2x8(:,533),heltab2x16(:,:,533))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(496),n2h8(199))
  call Hloop_WQ_A(ntryL,G1H16(297),ex1(:),G1H8(38),m3h2x8(:,534),heltab2x16(:,:,534))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(497),n2h8(200))
  call Hloop_WQ_A(ntryL,G1H16(302),ex1(:),G1H8(38),m3h2x8(:,535),heltab2x16(:,:,535))
  call Hloop_Q_A(ntryL,G1H8(38),37,0,G2H8(498),n2h8(201))
call HGT_raise_alpha_OLR(G1H16(304),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(304),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(304),ex4(:),G1H8(38),m3h2x8(:,536),heltab2x16(:,:,536))
  call Hloop_WQ_A(ntryL,G1H16(306),ex1(:),G1H8(39),m3h2x8(:,537),heltab2x16(:,:,537))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(499),n2h8(202))
  call Hloop_WQ_A(ntryL,G1H16(300),ex1(:),G1H8(39),m3h2x8(:,538),heltab2x16(:,:,538))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(500),n2h8(203))
  call Hloop_WQ_A(ntryL,G1H16(309),ex1(:),G1H8(39),m3h2x8(:,539),heltab2x16(:,:,539))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(501),n2h8(204))
  call Hloop_WQ_A(ntryL,G1H16(303),ex1(:),G1H8(39),m3h2x8(:,540),heltab2x16(:,:,540))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(502),n2h8(205))
call HGT_raise_alpha_OLR(G1H16(310),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(310),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(310),-8,ex4(:),8,G2H8(503),m3h2x8(:,541),heltab2x16(:,:,541))
  call Hloop_WQ_A(ntryL,G1H16(307),ex1(:),G1H8(39),m3h2x8(:,542),heltab2x16(:,:,542))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(504),n2h8(206))
  call Hloop_WQ_A(ntryL,G1H16(312),ex1(:),G1H8(39),m3h2x8(:,543),heltab2x16(:,:,543))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(505),n2h8(207))
  call Hloop_WQ_A(ntryL,G1H16(308),ex1(:),G1H8(39),m3h2x8(:,544),heltab2x16(:,:,544))
  call Hloop_Q_A(ntryL,G1H8(39),37,0,G2H8(506),n2h8(208))
  call Hloop_SQ_A(ntryL,G1H16(311),ex1(:),G1H8(39),ngPnl,m3h2x8(:,545),heltab2x16(:,:,545))
  call Hloop_Q_A(ntryL,G1H8(39),41,0,G2H8(507),n2h8(209))
call HGT_OLR(G1H16(318),1,1,16)
call HGT_invQ_OLR(G1H16(318),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(318),-16,ex5(:),16,G2H8(508),m3h2x8(:,546),heltab2x16(:,:,546))
  call Hloop_SQ_A(ntryL,G1H16(322),ex1(:),G1H8(39),ngPnl,m3h2x8(:,547),heltab2x16(:,:,547))
  call Hloop_Q_A(ntryL,G1H8(39),41,0,G2H8(509),n2h8(210))
  call Hloop_SQ_A(ntryL,G1H16(323),ex1(:),G1H8(39),ngPnl,m3h2x8(:,548),heltab2x16(:,:,548))
  call Hloop_Q_A(ntryL,G1H8(39),41,0,G2H8(510),n2h8(211))
  call Hloop_SQ_A(ntryL,G1H16(324),ex1(:),G1H8(39),ngPnl,m3h2x8(:,549),heltab2x16(:,:,549))
  call Hloop_Q_A(ntryL,G1H8(39),41,0,G2H8(511),n2h8(212))
  call Hloop_SQ_A(ntryL,G1H16(319),ex1(:),G1H8(39),ngPnl,m3h2x8(:,550),heltab2x16(:,:,550))
  call Hloop_Q_A(ntryL,G1H8(39),41,0,G2H8(512),n2h8(213))
call HGT_OLR(G1H16(320),1,1,16)
call HGT_invQ_OLR(G1H16(320),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(320),ex5(:),G1H8(39),m3h2x8(:,551),heltab2x16(:,:,551))
  call Hloop_SQ_A(ntryL,G1H16(321),ex1(:),G1H8(40),ngPnl,m3h2x8(:,552),heltab2x16(:,:,552))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(513),n2h8(214))
  call Hloop_SQ_A(ntryL,G1H16(329),ex1(:),G1H8(40),ngPnl,m3h2x8(:,553),heltab2x16(:,:,553))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(514),n2h8(215))
  call Hloop_SQ_A(ntryL,G1H16(330),ex1(:),G1H8(40),ngPnl,m3h2x8(:,554),heltab2x16(:,:,554))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(515),n2h8(216))
  call Hloop_SQ_A(ntryL,G1H16(325),ex1(:),G1H8(40),ngPnl,m3h2x8(:,555),heltab2x16(:,:,555))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(516),n2h8(217))
call HGT_OLR(G1H16(326),1,1,16)
call HGT_invQ_OLR(G1H16(326),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(326),-16,ex5(:),16,G2H8(517),m3h2x8(:,556),heltab2x16(:,:,556))
  call Hloop_SQ_A(ntryL,G1H16(332),ex1(:),G1H8(40),ngPnl,m3h2x8(:,557),heltab2x16(:,:,557))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(518),n2h8(218))
  call Hloop_SQ_A(ntryL,G1H16(331),ex1(:),G1H8(40),ngPnl,m3h2x8(:,558),heltab2x16(:,:,558))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(519),n2h8(219))
  call Hloop_SQ_A(ntryL,G1H16(338),ex1(:),G1H8(40),ngPnl,m3h2x8(:,559),heltab2x16(:,:,559))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(520),n2h8(220))
  call Hloop_SQ_A(ntryL,G1H16(337),ex1(:),G1H8(40),ngPnl,m3h2x8(:,560),heltab2x16(:,:,560))
  call Hloop_Q_A(ntryL,G1H8(40),41,0,G2H8(521),n2h8(221))
call HGT_OLR(G1H16(342),1,1,16)
call HGT_invQ_OLR(G1H16(342),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(342),ex5(:),G1H8(40),m3h2x8(:,561),heltab2x16(:,:,561))
  call Hloop_SQ_A(ntryL,G1H16(344),ex1(:),G1H8(41),ngPnl,m3h2x8(:,562),heltab2x16(:,:,562))
  call Hloop_Q_A(ntryL,G1H8(41),41,0,G2H8(522),n2h8(222))
  call Hloop_SQ_A(ntryL,G1H16(339),ex1(:),G1H8(41),ngPnl,m3h2x8(:,563),heltab2x16(:,:,563))
  call Hloop_Q_A(ntryL,G1H8(41),41,0,G2H8(523),n2h8(223))
  call Hloop_SQ_A(ntryL,G1H16(340),ex1(:),G1H8(41),ngPnl,m3h2x8(:,564),heltab2x16(:,:,564))
  call Hloop_Q_A(ntryL,G1H8(41),41,0,G2H8(524),n2h8(224))
  call Hloop_WQ_A(ntryL,G1H16(348),ex1(:),G1H8(41),m3h2x8(:,565),heltab2x16(:,:,565))
  call Hloop_Q_A(ntryL,G1H8(41),41,0,G2H8(525),n2h8(225))
call HGT_raise_alpha_OLR(G1H16(341),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(341),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(341),ex5(:),G1H8(41),m3h2x8(:,566),heltab2x16(:,:,566))
  call Hloop_WQ_A(ntryL,G1H16(350),ex1(:),G1H8(42),m3h2x8(:,567),heltab2x16(:,:,567))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(526),n2h8(226))
  call Hloop_WQ_A(ntryL,G1H16(345),ex1(:),G1H8(42),m3h2x8(:,568),heltab2x16(:,:,568))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(527),n2h8(227))
  call Hloop_WQ_A(ntryL,G1H16(346),ex1(:),G1H8(42),m3h2x8(:,569),heltab2x16(:,:,569))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(528),n2h8(228))
  call Hloop_WQ_A(ntryL,G1H16(347),ex1(:),G1H8(42),m3h2x8(:,570),heltab2x16(:,:,570))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(529),n2h8(229))
call HGT_raise_alpha_OLR(G1H16(352),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(352),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(352),-16,ex5(:),16,G2H8(530),m3h2x8(:,571),heltab2x16(:,:,571))
  call Hloop_WQ_A(ntryL,G1H16(358),ex1(:),G1H8(42),m3h2x8(:,572),heltab2x16(:,:,572))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(531),n2h8(230))
  call Hloop_WQ_A(ntryL,G1H16(357),ex1(:),G1H8(42),m3h2x8(:,573),heltab2x16(:,:,573))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(532),n2h8(231))
  call Hloop_WQ_A(ntryL,G1H16(362),ex1(:),G1H8(42),m3h2x8(:,574),heltab2x16(:,:,574))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(533),n2h8(232))
  call Hloop_WQ_A(ntryL,G1H16(363),ex1(:),G1H8(42),m3h2x8(:,575),heltab2x16(:,:,575))
  call Hloop_Q_A(ntryL,G1H8(42),41,0,G2H8(534),n2h8(233))
call HGT_raise_alpha_OLR(G1H16(364),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(364),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(364),ex5(:),G1H8(42),m3h2x8(:,576),heltab2x16(:,:,576))
  call Hloop_WQ_A(ntryL,G1H16(360),ex1(:),G1H8(43),m3h2x8(:,577),heltab2x16(:,:,577))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(535),n2h8(234))
  call Hloop_WQ_A(ntryL,G1H16(368),ex1(:),G1H8(43),m3h2x8(:,578),heltab2x16(:,:,578))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(536),n2h8(235))
  call Hloop_WQ_A(ntryL,G1H16(361),ex1(:),G1H8(43),m3h2x8(:,579),heltab2x16(:,:,579))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(537),n2h8(236))
  call Hloop_WQ_A(ntryL,G1H16(369),ex1(:),G1H8(43),m3h2x8(:,580),heltab2x16(:,:,580))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(538),n2h8(237))
call HGT_raise_alpha_OLR(G1H16(370),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(370),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(370),-16,ex5(:),16,G2H8(539),m3h2x8(:,581),heltab2x16(:,:,581))
  call Hloop_WQ_A(ntryL,G1H16(366),ex1(:),G1H8(43),m3h2x8(:,582),heltab2x16(:,:,582))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(540),n2h8(238))
  call Hloop_WQ_A(ntryL,G1H16(367),ex1(:),G1H8(43),m3h2x8(:,583),heltab2x16(:,:,583))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(541),n2h8(239))
  call Hloop_WQ_A(ntryL,G1H16(372),ex1(:),G1H8(43),m3h2x8(:,584),heltab2x16(:,:,584))
  call Hloop_Q_A(ntryL,G1H8(43),41,0,G2H8(542),n2h8(240))
  call Hloop_SA_Q(ntryL,G1H16(371),ex2(:),G1H8(43),ngPln,m3h2x8(:,585),heltab2x16(:,:,585))
  call Hloop_A_Q(ntryL,G1H8(43),38,0,G2H8(543),n2h8(241))
call HGT_OLR(G1H16(378),1,1,16)
call HGT_invQ_OLR(G1H16(378),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(378),-16,ex5(:),16,G2H8(544),m3h2x8(:,586),heltab2x16(:,:,586))
  call Hloop_SA_Q(ntryL,G1H16(377),ex2(:),G1H8(43),ngPln,m3h2x8(:,587),heltab2x16(:,:,587))
  call Hloop_A_Q(ntryL,G1H8(43),38,0,G2H8(545),n2h8(242))
  call Hloop_SA_Q(ntryL,G1H16(383),ex2(:),G1H8(43),ngPln,m3h2x8(:,588),heltab2x16(:,:,588))
  call Hloop_A_Q(ntryL,G1H8(43),38,0,G2H8(546),n2h8(243))
  call Hloop_SA_Q(ntryL,G1H16(384),ex2(:),G1H8(43),ngPln,m3h2x8(:,589),heltab2x16(:,:,589))
  call Hloop_A_Q(ntryL,G1H8(43),38,0,G2H8(547),n2h8(244))
  call Hloop_SA_Q(ntryL,G1H16(379),ex2(:),G1H8(43),ngPln,m3h2x8(:,590),heltab2x16(:,:,590))
  call Hloop_A_Q(ntryL,G1H8(43),38,0,G2H8(548),n2h8(245))
call HGT_OLR(G1H16(388),1,1,16)
call HGT_invQ_OLR(G1H16(388),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(388),ex5(:),G1H8(43),m3h2x8(:,591),heltab2x16(:,:,591))
  call Hloop_SA_Q(ntryL,G1H16(389),ex2(:),G1H8(44),ngPln,m3h2x8(:,592),heltab2x16(:,:,592))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(549),n2h8(246))
  call Hloop_SA_Q(ntryL,G1H16(381),ex2(:),G1H8(44),ngPln,m3h2x8(:,593),heltab2x16(:,:,593))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(550),n2h8(247))
  call Hloop_SA_Q(ntryL,G1H16(390),ex2(:),G1H8(44),ngPln,m3h2x8(:,594),heltab2x16(:,:,594))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(551),n2h8(248))
  call Hloop_SA_Q(ntryL,G1H16(385),ex2(:),G1H8(44),ngPln,m3h2x8(:,595),heltab2x16(:,:,595))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(552),n2h8(249))
call HGT_OLR(G1H16(386),1,1,16)
call HGT_invQ_OLR(G1H16(386),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(386),-16,ex5(:),16,G2H8(553),m3h2x8(:,596),heltab2x16(:,:,596))
  call Hloop_SA_Q(ntryL,G1H16(387),ex2(:),G1H8(44),ngPln,m3h2x8(:,597),heltab2x16(:,:,597))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(554),n2h8(250))
  call Hloop_SA_Q(ntryL,G1H16(391),ex2(:),G1H8(44),ngPln,m3h2x8(:,598),heltab2x16(:,:,598))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(555),n2h8(251))
  call Hloop_SA_Q(ntryL,G1H16(398),ex2(:),G1H8(44),ngPln,m3h2x8(:,599),heltab2x16(:,:,599))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(556),n2h8(252))
  call Hloop_WA_Q(ntryL,G1H16(397),ex2(:),G1H8(44),m3h2x8(:,600),heltab2x16(:,:,600))
  call Hloop_A_Q(ntryL,G1H8(44),38,0,G2H8(557),n2h8(253))
call HGT_raise_alpha_OLR(G1H16(402),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(402),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(402),ex5(:),G1H8(44),m3h2x8(:,601),heltab2x16(:,:,601))
  call Hloop_WA_Q(ntryL,G1H16(404),ex2(:),G1H8(45),m3h2x8(:,602),heltab2x16(:,:,602))
  call Hloop_A_Q(ntryL,G1H8(45),38,0,G2H8(558),n2h8(254))
  call Hloop_WA_Q(ntryL,G1H16(399),ex2(:),G1H8(45),m3h2x8(:,603),heltab2x16(:,:,603))
  call Hloop_A_Q(ntryL,G1H8(45),38,0,G2H8(559),n2h8(255))
  call Hloop_WA_Q(ntryL,G1H16(400),ex2(:),G1H8(45),m3h2x8(:,604),heltab2x16(:,:,604))
  call Hloop_A_Q(ntryL,G1H8(45),38,0,G2H8(560),n2h8(256))
  call Hloop_SA_Q(ntryL,G1H16(408),ex2(:),G1H8(45),ngPln,m3h2x8(:,605),heltab2x16(:,:,605))
  call Hloop_A_Q(ntryL,G1H8(45),38,0,G2H8(561),n2h8(257))
call HGT_OLR(G1H16(401),1,1,16)
call HGT_invQ_OLR(G1H16(401),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(401),ex5(:),G1H8(45),m3h2x8(:,606),heltab2x16(:,:,606))
  call Hloop_SA_Q(ntryL,G1H16(410),ex2(:),G1H8(46),ngPln,m3h2x8(:,607),heltab2x16(:,:,607))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(562),n2h8(258))
  call Hloop_SA_Q(ntryL,G1H16(405),ex2(:),G1H8(46),ngPln,m3h2x8(:,608),heltab2x16(:,:,608))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(563),n2h8(259))
  call Hloop_SA_Q(ntryL,G1H16(406),ex2(:),G1H8(46),ngPln,m3h2x8(:,609),heltab2x16(:,:,609))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(564),n2h8(260))
  call Hloop_WA_Q(ntryL,G1H16(407),ex2(:),G1H8(46),m3h2x8(:,610),heltab2x16(:,:,610))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(565),n2h8(261))
call HGT_raise_alpha_OLR(G1H16(412),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(412),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(412),-16,ex5(:),16,G2H8(566),m3h2x8(:,611),heltab2x16(:,:,611))
  call Hloop_WA_Q(ntryL,G1H16(418),ex2(:),G1H8(46),m3h2x8(:,612),heltab2x16(:,:,612))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(567),n2h8(262))
  call Hloop_WA_Q(ntryL,G1H16(422),ex2(:),G1H8(46),m3h2x8(:,613),heltab2x16(:,:,613))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(568),n2h8(263))
  call Hloop_WA_Q(ntryL,G1H16(417),ex2(:),G1H8(46),m3h2x8(:,614),heltab2x16(:,:,614))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(569),n2h8(264))
  call Hloop_WA_Q(ntryL,G1H16(423),ex2(:),G1H8(46),m3h2x8(:,615),heltab2x16(:,:,615))
  call Hloop_A_Q(ntryL,G1H8(46),38,0,G2H8(570),n2h8(265))
call HGT_raise_alpha_OLR(G1H16(424),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(424),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(424),ex5(:),G1H8(46),m3h2x8(:,616),heltab2x16(:,:,616))
  call Hloop_WA_Q(ntryL,G1H16(428),ex2(:),G1H8(47),m3h2x8(:,617),heltab2x16(:,:,617))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(571),n2h8(266))
  call Hloop_WA_Q(ntryL,G1H16(420),ex2(:),G1H8(47),m3h2x8(:,618),heltab2x16(:,:,618))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(572),n2h8(267))
  call Hloop_WA_Q(ntryL,G1H16(429),ex2(:),G1H8(47),m3h2x8(:,619),heltab2x16(:,:,619))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(573),n2h8(268))
  call Hloop_WA_Q(ntryL,G1H16(421),ex2(:),G1H8(47),m3h2x8(:,620),heltab2x16(:,:,620))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(574),n2h8(269))
call HGT_raise_alpha_OLR(G1H16(430),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(430),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(430),-16,ex5(:),16,G2H8(575),m3h2x8(:,621),heltab2x16(:,:,621))
  call Hloop_WA_Q(ntryL,G1H16(426),ex2(:),G1H8(47),m3h2x8(:,622),heltab2x16(:,:,622))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(576),n2h8(270))
  call Hloop_WA_Q(ntryL,G1H16(432),ex2(:),G1H8(47),m3h2x8(:,623),heltab2x16(:,:,623))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(577),n2h8(271))
  call Hloop_WA_Q(ntryL,G1H16(427),ex2(:),G1H8(47),m3h2x8(:,624),heltab2x16(:,:,624))
  call Hloop_A_Q(ntryL,G1H8(47),38,0,G2H8(578),n2h8(272))
  call Hloop_AV_Q(ntryL,G1H16(431),ex4(:),G1H8(47),m3h2x8(:,625),heltab2x16(:,:,625))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(579),n2h8(273))
call HGT_OLR(G1H16(3),1,1,16)
call HGT_invQ_OLR(G1H16(3),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(3),-16,nME,G2H16(5),n2h16(481))
  call Hloop_QV_A(ntryL,G2H16(5),ex5(:),G2H8(580),m3h2x8(:,626),heltab2x16(:,:,626))
  call Hloop_AV_Q(ntryL,G1H16(9),ex4(:),G1H8(47),m3h2x8(:,627),heltab2x16(:,:,627))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(581),n2h8(274))
  call Hloop_AV_Q(ntryL,G1H16(10),ex4(:),G1H8(47),m3h2x8(:,628),heltab2x16(:,:,628))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(582),n2h8(275))
  call Hloop_AV_Q(ntryL,G1H16(11),ex4(:),G1H8(47),m3h2x8(:,629),heltab2x16(:,:,629))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(583),n2h8(276))
  call Hloop_AV_Q(ntryL,G1H16(13),ex4(:),G1H8(47),m3h2x8(:,630),heltab2x16(:,:,630))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(584),n2h8(277))
call HGT_OLR(G1H16(15),1,1,16)
call HGT_invQ_OLR(G1H16(15),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(15),-16,nME,G2H16(6),n2h16(482))
  call Hloop_QV_A(ntryL,G2H16(6),ex5(:),G2H8(585),m3h2x8(:,631),heltab2x16(:,:,631))
  call Hloop_AV_Q(ntryL,G1H16(20),ex4(:),G1H8(47),m3h2x8(:,632),heltab2x16(:,:,632))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(586),n2h8(278))
  call Hloop_AV_Q(ntryL,G1H16(23),ex4(:),G1H8(47),m3h2x8(:,633),heltab2x16(:,:,633))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(587),n2h8(279))
  call Hloop_AV_Q(ntryL,G1H16(25),ex4(:),G1H8(47),m3h2x8(:,634),heltab2x16(:,:,634))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(588),n2h8(280))
  call Hloop_SV_T(ntryL,G1H16(27),36,ex4(:),8,G2H8(589),m3h2x8(:,635),heltab2x16(:,:,635))
call HGT_OLR(G1H16(28),1,1,16)
call HGT_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(28),-16,ex5(:),16,G2H8(590),m3h2x8(:,636),heltab2x16(:,:,636))
  call Hloop_SV_T(ntryL,G1H16(31),36,ex4(:),8,G2H8(591),m3h2x8(:,637),heltab2x16(:,:,637))
  call Hloop_SV_T(ntryL,G1H16(32),36,ex4(:),8,G2H8(592),m3h2x8(:,638),heltab2x16(:,:,638))
  call Hloop_SV_T(ntryL,G1H16(35),36,ex4(:),8,G2H8(593),m3h2x8(:,639),heltab2x16(:,:,639))
  call Hloop_AV_Q(ntryL,G1H16(36),ex4(:),G1H8(47),m3h2x8(:,640),heltab2x16(:,:,640))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(594),n2h8(281))
call HGT_OLR(G1H16(41),1,1,16)
call HGT_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(41),-16,nME,G2H16(7),n2h16(484))
  call Hloop_QV_A(ntryL,G2H16(7),ex5(:),G2H8(595),m3h2x8(:,641),heltab2x16(:,:,641))
  call Hloop_AV_Q(ntryL,G1H16(43),ex4(:),G1H8(47),m3h2x8(:,642),heltab2x16(:,:,642))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(596),n2h8(282))
  call Hloop_AV_Q(ntryL,G1H16(44),ex4(:),G1H8(47),m3h2x8(:,643),heltab2x16(:,:,643))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(597),n2h8(283))
  call Hloop_AV_Q(ntryL,G1H16(47),ex4(:),G1H8(47),m3h2x8(:,644),heltab2x16(:,:,644))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(598),n2h8(284))
  call Hloop_AV_Q(ntryL,G1H16(48),ex4(:),G1H8(47),m3h2x8(:,645),heltab2x16(:,:,645))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(599),n2h8(285))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(52),-16,nME,G2H16(9),n2h16(485))
  call Hloop_QV_A(ntryL,G2H16(9),ex5(:),G2H8(600),m3h2x8(:,646),heltab2x16(:,:,646))
  call Hloop_AV_Q(ntryL,G1H16(57),ex4(:),G1H8(47),m3h2x8(:,647),heltab2x16(:,:,647))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(601),n2h8(286))
  call Hloop_AV_Q(ntryL,G1H16(59),ex4(:),G1H8(47),m3h2x8(:,648),heltab2x16(:,:,648))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(602),n2h8(287))
  call Hloop_AV_Q(ntryL,G1H16(60),ex4(:),G1H8(47),m3h2x8(:,649),heltab2x16(:,:,649))
  call Hloop_A_Q(ntryL,G1H8(47),44,nME,G2H8(603),n2h8(288))
  call Hloop_SV_T(ntryL,G1H16(62),36,ex4(:),8,G2H8(604),m3h2x8(:,650),heltab2x16(:,:,650))
call HGT_OLR(G1H16(63),1,1,16)
call HGT_invQ_OLR(G1H16(63),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(63),ex5(:),G1H8(47),m3h2x8(:,651),heltab2x16(:,:,651))
  call Hloop_SV_T(ntryL,G1H16(65),36,ex4(:),8,G2H8(605),m3h2x8(:,652),heltab2x16(:,:,652))
  call Hloop_SV_T(ntryL,G1H16(66),36,ex4(:),8,G2H8(606),m3h2x8(:,653),heltab2x16(:,:,653))
  call Hloop_SV_T(ntryL,G1H16(67),36,ex4(:),8,G2H8(607),m3h2x8(:,654),heltab2x16(:,:,654))
  call Hloop_UW_V(ntryL,G1H16(68),36,ex4(:),8,G2H8(608),m3h2x8(:,655),heltab2x16(:,:,655))
call HGT_raise_alpha_OLR(G1H16(85),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(85),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(85),ex5(:),G1H8(48),m3h2x8(:,656),heltab2x16(:,:,656))
  call Hloop_UW_V(ntryL,G1H16(87),36,ex4(:),8,G2H8(609),m3h2x8(:,657),heltab2x16(:,:,657))
  call Hloop_UW_V(ntryL,G1H16(88),36,ex4(:),8,G2H8(610),m3h2x8(:,658),heltab2x16(:,:,658))
  call Hloop_UW_V(ntryL,G1H16(107),36,ex4(:),8,G2H8(611),m3h2x8(:,659),heltab2x16(:,:,659))
  call Hloop_UW_V(ntryL,G1H16(110),36,ex4(:),8,G2H8(612),m3h2x8(:,660),heltab2x16(:,:,660))
call HGT_raise_alpha_OLR(G1H16(113),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(113),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(113),-16,ex5(:),16,G2H8(613),m3h2x8(:,661),heltab2x16(:,:,661))
  call Hloop_UW_V(ntryL,G1H16(116),36,ex4(:),8,G2H8(614),m3h2x8(:,662),heltab2x16(:,:,662))
  call Hloop_UW_V(ntryL,G1H16(117),36,ex4(:),8,G2H8(615),m3h2x8(:,663),heltab2x16(:,:,663))
  call Hloop_UW_V(ntryL,G1H16(119),36,ex4(:),8,G2H8(616),m3h2x8(:,664),heltab2x16(:,:,664))
  call Hloop_QV_A(ntryL,G1H16(120),ex5(:),G1H8(49),m3h2x8(:,665),heltab2x16(:,:,665))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(617),n2h8(289))
call HGT_OLR(G1H16(124),1,1,16)
call HGT_invQ_OLR(G1H16(124),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(124),-8,nME,G2H16(8),n2h16(489))
  call Hloop_AV_Q(ntryL,G2H16(8),ex4(:),G2H8(618),m3h2x8(:,666),heltab2x16(:,:,666))
  call Hloop_QV_A(ntryL,G1H16(129),ex5(:),G1H8(49),m3h2x8(:,667),heltab2x16(:,:,667))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(619),n2h8(290))
  call Hloop_QV_A(ntryL,G1H16(130),ex5(:),G1H8(49),m3h2x8(:,668),heltab2x16(:,:,668))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(620),n2h8(291))
  call Hloop_QV_A(ntryL,G1H16(132),ex5(:),G1H8(49),m3h2x8(:,669),heltab2x16(:,:,669))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(621),n2h8(292))
  call Hloop_QV_A(ntryL,G1H16(134),ex5(:),G1H8(49),m3h2x8(:,670),heltab2x16(:,:,670))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(622),n2h8(293))
call HGT_OLR(G1H16(135),1,1,16)
call HGT_invQ_OLR(G1H16(135),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(135),-8,nME,G2H16(10),n2h16(490))
  call Hloop_AV_Q(ntryL,G2H16(10),ex4(:),G2H8(623),m3h2x8(:,671),heltab2x16(:,:,671))
  call Hloop_QV_A(ntryL,G1H16(139),ex5(:),G1H8(49),m3h2x8(:,672),heltab2x16(:,:,672))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(624),n2h8(294))
  call Hloop_QV_A(ntryL,G1H16(140),ex5(:),G1H8(49),m3h2x8(:,673),heltab2x16(:,:,673))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(625),n2h8(295))
  call Hloop_QV_A(ntryL,G1H16(145),ex5(:),G1H8(49),m3h2x8(:,674),heltab2x16(:,:,674))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(626),n2h8(296))
  call Hloop_TV_S(ntryL,G1H16(146),36,ex5(:),16,G2H8(627),m3h2x8(:,675),heltab2x16(:,:,675))
call HGT_OLR(G1H16(147),1,1,16)
call HGT_invQ_OLR(G1H16(147),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(147),-8,ex4(:),8,G2H8(628),m3h2x8(:,676),heltab2x16(:,:,676))
  call Hloop_TV_S(ntryL,G1H16(151),36,ex5(:),16,G2H8(629),m3h2x8(:,677),heltab2x16(:,:,677))
  call Hloop_TV_S(ntryL,G1H16(152),36,ex5(:),16,G2H8(630),m3h2x8(:,678),heltab2x16(:,:,678))
  call Hloop_TV_S(ntryL,G1H16(434),36,ex5(:),16,G2H8(631),m3h2x8(:,679),heltab2x16(:,:,679))
  call Hloop_QV_A(ntryL,G1H16(435),ex5(:),G1H8(49),m3h2x8(:,680),heltab2x16(:,:,680))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(632),n2h8(297))
call HGT_OLR(G1H16(436),1,1,16)
call HGT_invQ_OLR(G1H16(436),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(436),-8,nME,G2H16(11),n2h16(492))
  call Hloop_AV_Q(ntryL,G2H16(11),ex4(:),G2H8(633),m3h2x8(:,681),heltab2x16(:,:,681))
  call Hloop_QV_A(ntryL,G1H16(438),ex5(:),G1H8(49),m3h2x8(:,682),heltab2x16(:,:,682))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(634),n2h8(298))
  call Hloop_QV_A(ntryL,G1H16(439),ex5(:),G1H8(49),m3h2x8(:,683),heltab2x16(:,:,683))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(635),n2h8(299))
  call Hloop_QV_A(ntryL,G1H16(440),ex5(:),G1H8(49),m3h2x8(:,684),heltab2x16(:,:,684))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(636),n2h8(300))
  call Hloop_QV_A(ntryL,G1H16(441),ex5(:),G1H8(49),m3h2x8(:,685),heltab2x16(:,:,685))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(637),n2h8(301))
call HGT_OLR(G1H16(442),1,1,16)
call HGT_invQ_OLR(G1H16(442),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(442),-8,nME,G2H16(12),n2h16(493))
  call Hloop_AV_Q(ntryL,G2H16(12),ex4(:),G2H8(638),m3h2x8(:,686),heltab2x16(:,:,686))
  call Hloop_QV_A(ntryL,G1H16(444),ex5(:),G1H8(49),m3h2x8(:,687),heltab2x16(:,:,687))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(639),n2h8(302))
  call Hloop_QV_A(ntryL,G1H16(445),ex5(:),G1H8(49),m3h2x8(:,688),heltab2x16(:,:,688))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(640),n2h8(303))
  call Hloop_QV_A(ntryL,G1H16(446),ex5(:),G1H8(49),m3h2x8(:,689),heltab2x16(:,:,689))
  call Hloop_Q_A(ntryL,G1H8(49),52,nME,G2H8(641),n2h8(304))
  call Hloop_TV_S(ntryL,G1H16(155),36,ex5(:),16,G2H8(642),m3h2x8(:,690),heltab2x16(:,:,690))
call HGT_OLR(G1H16(156),1,1,16)
call HGT_invQ_OLR(G1H16(156),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(156),ex4(:),G1H8(49),m3h2x8(:,691),heltab2x16(:,:,691))
  call Hloop_TV_S(ntryL,G1H16(448),36,ex5(:),16,G2H8(643),m3h2x8(:,692),heltab2x16(:,:,692))
  call Hloop_TV_S(ntryL,G1H16(449),36,ex5(:),16,G2H8(644),m3h2x8(:,693),heltab2x16(:,:,693))
  call Hloop_TV_S(ntryL,G1H16(450),36,ex5(:),16,G2H8(645),m3h2x8(:,694),heltab2x16(:,:,694))
  call Hloop_UV_W(ntryL,G1H16(161),36,ex5(:),16,G2H8(646),m3h2x8(:,695),heltab2x16(:,:,695))
call HGT_raise_alpha_OLR(G1H16(162),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(162),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(162),ex4(:),G1H8(50),m3h2x8(:,696),heltab2x16(:,:,696))
  call Hloop_UV_W(ntryL,G1H16(164),36,ex5(:),16,G2H8(647),m3h2x8(:,697),heltab2x16(:,:,697))
  call Hloop_UV_W(ntryL,G1H16(451),36,ex5(:),16,G2H8(648),m3h2x8(:,698),heltab2x16(:,:,698))
  call Hloop_UV_W(ntryL,G1H16(452),36,ex5(:),16,G2H8(649),m3h2x8(:,699),heltab2x16(:,:,699))
  call Hloop_UV_W(ntryL,G1H16(167),36,ex5(:),16,G2H8(650),m3h2x8(:,700),heltab2x16(:,:,700))
call HGT_raise_alpha_OLR(G1H16(168),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(168),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(168),-8,ex4(:),8,G2H8(651),m3h2x8(:,701),heltab2x16(:,:,701))
  call Hloop_UV_W(ntryL,G1H16(454),36,ex5(:),16,G2H8(652),m3h2x8(:,702),heltab2x16(:,:,702))
  call Hloop_UV_W(ntryL,G1H16(455),36,ex5(:),16,G2H8(653),m3h2x8(:,703),heltab2x16(:,:,703))
  call Hloop_UV_W(ntryL,G1H16(456),36,ex5(:),16,G2H8(654),m3h2x8(:,704),heltab2x16(:,:,704))
  call Hloop_QV_A(ntryL,G1H16(169),ex3(:),G1H8(51),m3h2x8(:,705),heltab2x16(:,:,705))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(655),n2h8(305))
call HGT_OLR(G1H16(170),1,1,16)
call HGT_invQ_OLR(G1H16(170),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(170),-16,nME,G2H16(13),n2h16(497))
  call Hloop_AV_Q(ntryL,G2H16(13),ex5(:),G2H8(656),m3h2x8(:,706),heltab2x16(:,:,706))
  call Hloop_QV_A(ntryL,G1H16(172),ex3(:),G1H8(51),m3h2x8(:,707),heltab2x16(:,:,707))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(657),n2h8(306))
  call Hloop_QV_A(ntryL,G1H16(189),ex3(:),G1H8(51),m3h2x8(:,708),heltab2x16(:,:,708))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(658),n2h8(307))
  call Hloop_QV_A(ntryL,G1H16(190),ex3(:),G1H8(51),m3h2x8(:,709),heltab2x16(:,:,709))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(659),n2h8(308))
  call Hloop_QV_A(ntryL,G1H16(191),ex3(:),G1H8(51),m3h2x8(:,710),heltab2x16(:,:,710))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(660),n2h8(309))
call HGT_OLR(G1H16(192),1,1,16)
call HGT_invQ_OLR(G1H16(192),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(192),-16,nME,G2H16(14),n2h16(498))
  call Hloop_AV_Q(ntryL,G2H16(14),ex5(:),G2H8(661),m3h2x8(:,711),heltab2x16(:,:,711))
  call Hloop_QV_A(ntryL,G1H16(458),ex3(:),G1H8(51),m3h2x8(:,712),heltab2x16(:,:,712))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(662),n2h8(310))
  call Hloop_QV_A(ntryL,G1H16(459),ex3(:),G1H8(51),m3h2x8(:,713),heltab2x16(:,:,713))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(663),n2h8(311))
  call Hloop_QV_A(ntryL,G1H16(460),ex3(:),G1H8(51),m3h2x8(:,714),heltab2x16(:,:,714))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(664),n2h8(312))
  call Hloop_TV_S(ntryL,G1H16(461),40,ex3(:),4,G2H8(665),m3h2x8(:,715),heltab2x16(:,:,715))
call HGT_OLR(G1H16(462),1,1,16)
call HGT_invQ_OLR(G1H16(462),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(462),-16,ex5(:),16,G2H8(666),m3h2x8(:,716),heltab2x16(:,:,716))
  call Hloop_TV_S(ntryL,G1H16(464),40,ex3(:),4,G2H8(667),m3h2x8(:,717),heltab2x16(:,:,717))
  call Hloop_TV_S(ntryL,G1H16(465),40,ex3(:),4,G2H8(668),m3h2x8(:,718),heltab2x16(:,:,718))
  call Hloop_TV_S(ntryL,G1H16(466),40,ex3(:),4,G2H8(669),m3h2x8(:,719),heltab2x16(:,:,719))
  call Hloop_QV_A(ntryL,G1H16(467),ex3(:),G1H8(51),m3h2x8(:,720),heltab2x16(:,:,720))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(670),n2h8(313))
call HGT_OLR(G1H16(468),1,1,16)
call HGT_invQ_OLR(G1H16(468),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(468),-16,nME,G2H16(15),n2h16(500))
  call Hloop_AV_Q(ntryL,G2H16(15),ex5(:),G2H8(671),m3h2x8(:,721),heltab2x16(:,:,721))
  call Hloop_QV_A(ntryL,G1H16(470),ex3(:),G1H8(51),m3h2x8(:,722),heltab2x16(:,:,722))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(672),n2h8(314))
  call Hloop_QV_A(ntryL,G1H16(471),ex3(:),G1H8(51),m3h2x8(:,723),heltab2x16(:,:,723))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(673),n2h8(315))
  call Hloop_QV_A(ntryL,G1H16(472),ex3(:),G1H8(51),m3h2x8(:,724),heltab2x16(:,:,724))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(674),n2h8(316))
  call Hloop_QV_A(ntryL,G1H16(473),ex3(:),G1H8(51),m3h2x8(:,725),heltab2x16(:,:,725))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(675),n2h8(317))
call HGT_OLR(G1H16(474),1,1,16)
call HGT_invQ_OLR(G1H16(474),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(474),-16,nME,G2H16(16),n2h16(501))
  call Hloop_AV_Q(ntryL,G2H16(16),ex5(:),G2H8(676),m3h2x8(:,726),heltab2x16(:,:,726))
  call Hloop_QV_A(ntryL,G1H16(476),ex3(:),G1H8(51),m3h2x8(:,727),heltab2x16(:,:,727))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(677),n2h8(318))
  call Hloop_QV_A(ntryL,G1H16(477),ex3(:),G1H8(51),m3h2x8(:,728),heltab2x16(:,:,728))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(678),n2h8(319))
  call Hloop_QV_A(ntryL,G1H16(478),ex3(:),G1H8(51),m3h2x8(:,729),heltab2x16(:,:,729))
  call Hloop_Q_A(ntryL,G1H8(51),44,nME,G2H8(679),n2h8(320))
  call Hloop_TV_S(ntryL,G1H16(211),40,ex3(:),4,G2H8(680),m3h2x8(:,730),heltab2x16(:,:,730))
call HGT_OLR(G1H16(212),1,1,16)
call HGT_invQ_OLR(G1H16(212),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(212),ex5(:),G1H8(51),m3h2x8(:,731),heltab2x16(:,:,731))
  call Hloop_TV_S(ntryL,G1H16(480),40,ex3(:),4,G2H8(681),m3h2x8(:,732),heltab2x16(:,:,732))
  call Hloop_TV_S(ntryL,G1H16(481),40,ex3(:),4,G2H8(682),m3h2x8(:,733),heltab2x16(:,:,733))
  call Hloop_TV_S(ntryL,G1H16(482),40,ex3(:),4,G2H8(683),m3h2x8(:,734),heltab2x16(:,:,734))
  call Hloop_UV_W(ntryL,G1H16(217),40,ex3(:),4,G2H8(684),m3h2x8(:,735),heltab2x16(:,:,735))
call HGT_raise_alpha_OLR(G1H16(218),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(218),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(218),ex5(:),G1H8(52),m3h2x8(:,736),heltab2x16(:,:,736))
  call Hloop_UV_W(ntryL,G1H16(220),40,ex3(:),4,G2H8(685),m3h2x8(:,737),heltab2x16(:,:,737))
  call Hloop_UV_W(ntryL,G1H16(483),40,ex3(:),4,G2H8(686),m3h2x8(:,738),heltab2x16(:,:,738))
  call Hloop_UV_W(ntryL,G1H16(484),40,ex3(:),4,G2H8(687),m3h2x8(:,739),heltab2x16(:,:,739))
  call Hloop_UV_W(ntryL,G1H16(223),40,ex3(:),4,G2H8(688),m3h2x8(:,740),heltab2x16(:,:,740))
call HGT_raise_alpha_OLR(G1H16(224),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(224),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(224),-16,ex5(:),16,G2H8(689),m3h2x8(:,741),heltab2x16(:,:,741))
  call Hloop_UV_W(ntryL,G1H16(486),40,ex3(:),4,G2H8(690),m3h2x8(:,742),heltab2x16(:,:,742))
  call Hloop_UV_W(ntryL,G1H16(487),40,ex3(:),4,G2H8(691),m3h2x8(:,743),heltab2x16(:,:,743))
  call Hloop_UV_W(ntryL,G1H16(488),40,ex3(:),4,G2H8(692),m3h2x8(:,744),heltab2x16(:,:,744))
  call Hloop_SA_Q(ntryL,G1H16(489),ex2(:),G1H8(53),ngPln,m3h2x8(:,745),heltab2x16(:,:,745))
  call Hloop_A_Q(ntryL,G1H8(53),38,0,G2H8(693),n2h8(321))
call HGT_OLR(G1H16(490),1,1,16)
call HGT_invQ_OLR(G1H16(490),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(490),-8,ex4(:),8,G2H8(694),m3h2x8(:,746),heltab2x16(:,:,746))
  call Hloop_SA_Q(ntryL,G1H16(492),ex2(:),G1H8(53),ngPln,m3h2x8(:,747),heltab2x16(:,:,747))
  call Hloop_A_Q(ntryL,G1H8(53),38,0,G2H8(695),n2h8(322))
  call Hloop_SA_Q(ntryL,G1H16(493),ex2(:),G1H8(53),ngPln,m3h2x8(:,748),heltab2x16(:,:,748))
  call Hloop_A_Q(ntryL,G1H8(53),38,0,G2H8(696),n2h8(323))
  call Hloop_SA_Q(ntryL,G1H16(494),ex2(:),G1H8(53),ngPln,m3h2x8(:,749),heltab2x16(:,:,749))
  call Hloop_A_Q(ntryL,G1H8(53),38,0,G2H8(697),n2h8(324))
  call Hloop_SA_Q(ntryL,G1H16(228),ex2(:),G1H8(53),ngPln,m3h2x8(:,750),heltab2x16(:,:,750))
  call Hloop_A_Q(ntryL,G1H8(53),38,0,G2H8(698),n2h8(325))
call HGT_OLR(G1H16(495),1,1,16)
call HGT_invQ_OLR(G1H16(495),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(495),ex4(:),G1H8(53),m3h2x8(:,751),heltab2x16(:,:,751))
  call Hloop_SA_Q(ntryL,G1H16(497),ex2(:),G1H8(54),ngPln,m3h2x8(:,752),heltab2x16(:,:,752))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(699),n2h8(326))
  call Hloop_SA_Q(ntryL,G1H16(498),ex2(:),G1H8(54),ngPln,m3h2x8(:,753),heltab2x16(:,:,753))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(700),n2h8(327))
  call Hloop_SA_Q(ntryL,G1H16(499),ex2(:),G1H8(54),ngPln,m3h2x8(:,754),heltab2x16(:,:,754))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(701),n2h8(328))
  call Hloop_SA_Q(ntryL,G1H16(230),ex2(:),G1H8(54),ngPln,m3h2x8(:,755),heltab2x16(:,:,755))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(702),n2h8(329))
call HGT_OLR(G1H16(500),1,1,16)
call HGT_invQ_OLR(G1H16(500),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(500),-8,ex4(:),8,G2H8(703),m3h2x8(:,756),heltab2x16(:,:,756))
  call Hloop_SA_Q(ntryL,G1H16(502),ex2(:),G1H8(54),ngPln,m3h2x8(:,757),heltab2x16(:,:,757))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(704),n2h8(330))
  call Hloop_SA_Q(ntryL,G1H16(503),ex2(:),G1H8(54),ngPln,m3h2x8(:,758),heltab2x16(:,:,758))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(705),n2h8(331))
  call Hloop_SA_Q(ntryL,G1H16(504),ex2(:),G1H8(54),ngPln,m3h2x8(:,759),heltab2x16(:,:,759))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(706),n2h8(332))
  call Hloop_WA_Q(ntryL,G1H16(233),ex2(:),G1H8(54),m3h2x8(:,760),heltab2x16(:,:,760))
  call Hloop_A_Q(ntryL,G1H8(54),38,0,G2H8(707),n2h8(333))
call HGT_raise_alpha_OLR(G1H16(505),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(505),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(505),ex4(:),G1H8(54),m3h2x8(:,761),heltab2x16(:,:,761))
  call Hloop_WA_Q(ntryL,G1H16(507),ex2(:),G1H8(55),m3h2x8(:,762),heltab2x16(:,:,762))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(708),n2h8(334))
  call Hloop_WA_Q(ntryL,G1H16(508),ex2(:),G1H8(55),m3h2x8(:,763),heltab2x16(:,:,763))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(709),n2h8(335))
  call Hloop_WA_Q(ntryL,G1H16(509),ex2(:),G1H8(55),m3h2x8(:,764),heltab2x16(:,:,764))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(710),n2h8(336))
  call Hloop_SA_Q(ntryL,G1H16(234),ex2(:),G1H8(55),ngPln,m3h2x8(:,765),heltab2x16(:,:,765))
  call Hloop_A_Q(ntryL,G1H8(55),38,0,G2H8(711),n2h8(337))
call HGT_OLR(G1H16(236),1,1,16)
call HGT_invQ_OLR(G1H16(236),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(236),ex4(:),G1H8(55),m3h2x8(:,766),heltab2x16(:,:,766))
  call Hloop_SA_Q(ntryL,G1H16(511),ex2(:),G1H8(56),ngPln,m3h2x8(:,767),heltab2x16(:,:,767))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(712),n2h8(338))
  call Hloop_SA_Q(ntryL,G1H16(512),ex2(:),G1H8(56),ngPln,m3h2x8(:,768),heltab2x16(:,:,768))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(713),n2h8(339))
  call Hloop_SA_Q(ntryL,G1H16(513),ex2(:),G1H8(56),ngPln,m3h2x8(:,769),heltab2x16(:,:,769))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(714),n2h8(340))
  call Hloop_WA_Q(ntryL,G1H16(238),ex2(:),G1H8(56),m3h2x8(:,770),heltab2x16(:,:,770))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(715),n2h8(341))
call HGT_raise_alpha_OLR(G1H16(514),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(514),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(514),-8,ex4(:),8,G2H8(716),m3h2x8(:,771),heltab2x16(:,:,771))
  call Hloop_WA_Q(ntryL,G1H16(516),ex2(:),G1H8(56),m3h2x8(:,772),heltab2x16(:,:,772))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(717),n2h8(342))
  call Hloop_WA_Q(ntryL,G1H16(517),ex2(:),G1H8(56),m3h2x8(:,773),heltab2x16(:,:,773))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(718),n2h8(343))
  call Hloop_WA_Q(ntryL,G1H16(518),ex2(:),G1H8(56),m3h2x8(:,774),heltab2x16(:,:,774))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(719),n2h8(344))
  call Hloop_WA_Q(ntryL,G1H16(239),ex2(:),G1H8(56),m3h2x8(:,775),heltab2x16(:,:,775))
  call Hloop_A_Q(ntryL,G1H8(56),38,0,G2H8(720),n2h8(345))
call HGT_raise_alpha_OLR(G1H16(519),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(519),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(519),ex4(:),G1H8(56),m3h2x8(:,776),heltab2x16(:,:,776))
  call Hloop_WA_Q(ntryL,G1H16(521),ex2(:),G1H8(57),m3h2x8(:,777),heltab2x16(:,:,777))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(721),n2h8(346))
  call Hloop_WA_Q(ntryL,G1H16(522),ex2(:),G1H8(57),m3h2x8(:,778),heltab2x16(:,:,778))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(722),n2h8(347))
  call Hloop_WA_Q(ntryL,G1H16(523),ex2(:),G1H8(57),m3h2x8(:,779),heltab2x16(:,:,779))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(723),n2h8(348))
  call Hloop_WA_Q(ntryL,G1H16(240),ex2(:),G1H8(57),m3h2x8(:,780),heltab2x16(:,:,780))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(724),n2h8(349))
call HGT_raise_alpha_OLR(G1H16(524),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(524),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(524),-8,ex4(:),8,G2H8(725),m3h2x8(:,781),heltab2x16(:,:,781))
  call Hloop_WA_Q(ntryL,G1H16(526),ex2(:),G1H8(57),m3h2x8(:,782),heltab2x16(:,:,782))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(726),n2h8(350))
  call Hloop_WA_Q(ntryL,G1H16(527),ex2(:),G1H8(57),m3h2x8(:,783),heltab2x16(:,:,783))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(727),n2h8(351))
  call Hloop_WA_Q(ntryL,G1H16(528),ex2(:),G1H8(57),m3h2x8(:,784),heltab2x16(:,:,784))
  call Hloop_A_Q(ntryL,G1H8(57),38,0,G2H8(728),n2h8(352))
  call Hloop_QV_A(ntryL,G1H16(529),ex4(:),G1H8(57),m3h2x8(:,785),heltab2x16(:,:,785))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(729),n2h8(353))
call HGT_OLR(G1H16(530),1,1,16)
call HGT_invQ_OLR(G1H16(530),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(530),-16,nME,G2H16(17),n2h16(513))
  call Hloop_AV_Q(ntryL,G2H16(17),ex5(:),G2H8(730),m3h2x8(:,786),heltab2x16(:,:,786))
  call Hloop_QV_A(ntryL,G1H16(532),ex4(:),G1H8(57),m3h2x8(:,787),heltab2x16(:,:,787))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(731),n2h8(354))
  call Hloop_QV_A(ntryL,G1H16(533),ex4(:),G1H8(57),m3h2x8(:,788),heltab2x16(:,:,788))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(732),n2h8(355))
  call Hloop_QV_A(ntryL,G1H16(534),ex4(:),G1H8(57),m3h2x8(:,789),heltab2x16(:,:,789))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(733),n2h8(356))
  call Hloop_QV_A(ntryL,G1H16(535),ex4(:),G1H8(57),m3h2x8(:,790),heltab2x16(:,:,790))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(734),n2h8(357))
call HGT_OLR(G1H16(536),1,1,16)
call HGT_invQ_OLR(G1H16(536),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(536),-16,nME,G2H16(18),n2h16(514))
  call Hloop_AV_Q(ntryL,G2H16(18),ex5(:),G2H8(735),m3h2x8(:,791),heltab2x16(:,:,791))
  call Hloop_QV_A(ntryL,G1H16(538),ex4(:),G1H8(57),m3h2x8(:,792),heltab2x16(:,:,792))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(736),n2h8(358))
  call Hloop_QV_A(ntryL,G1H16(539),ex4(:),G1H8(57),m3h2x8(:,793),heltab2x16(:,:,793))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(737),n2h8(359))
  call Hloop_QV_A(ntryL,G1H16(540),ex4(:),G1H8(57),m3h2x8(:,794),heltab2x16(:,:,794))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(738),n2h8(360))
  call Hloop_TV_S(ntryL,G1H16(541),36,ex4(:),8,G2H8(739),m3h2x8(:,795),heltab2x16(:,:,795))
call HGT_OLR(G1H16(542),1,1,16)
call HGT_invQ_OLR(G1H16(542),2,5,16)
  call Hloop_SV_T(ntryL,G1H16(542),-16,ex5(:),16,G2H8(740),m3h2x8(:,796),heltab2x16(:,:,796))
  call Hloop_TV_S(ntryL,G1H16(544),36,ex4(:),8,G2H8(741),m3h2x8(:,797),heltab2x16(:,:,797))
  call Hloop_TV_S(ntryL,G1H16(545),36,ex4(:),8,G2H8(742),m3h2x8(:,798),heltab2x16(:,:,798))
  call Hloop_TV_S(ntryL,G1H16(546),36,ex4(:),8,G2H8(743),m3h2x8(:,799),heltab2x16(:,:,799))
  call Hloop_QV_A(ntryL,G1H16(547),ex4(:),G1H8(57),m3h2x8(:,800),heltab2x16(:,:,800))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(744),n2h8(361))
call HGT_OLR(G1H16(548),1,1,16)
call HGT_invQ_OLR(G1H16(548),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(548),-16,nME,G2H16(19),n2h16(516))
  call Hloop_AV_Q(ntryL,G2H16(19),ex5(:),G2H8(745),m3h2x8(:,801),heltab2x16(:,:,801))
  call Hloop_QV_A(ntryL,G1H16(550),ex4(:),G1H8(57),m3h2x8(:,802),heltab2x16(:,:,802))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(746),n2h8(362))
  call Hloop_QV_A(ntryL,G1H16(551),ex4(:),G1H8(57),m3h2x8(:,803),heltab2x16(:,:,803))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(747),n2h8(363))
  call Hloop_QV_A(ntryL,G1H16(552),ex4(:),G1H8(57),m3h2x8(:,804),heltab2x16(:,:,804))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(748),n2h8(364))
  call Hloop_QV_A(ntryL,G1H16(553),ex4(:),G1H8(57),m3h2x8(:,805),heltab2x16(:,:,805))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(749),n2h8(365))
call HGT_OLR(G1H16(554),1,1,16)
call HGT_invQ_OLR(G1H16(554),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(554),-16,nME,G2H16(20),n2h16(517))
  call Hloop_AV_Q(ntryL,G2H16(20),ex5(:),G2H8(750),m3h2x8(:,806),heltab2x16(:,:,806))
  call Hloop_QV_A(ntryL,G1H16(556),ex4(:),G1H8(57),m3h2x8(:,807),heltab2x16(:,:,807))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(751),n2h8(366))
  call Hloop_QV_A(ntryL,G1H16(557),ex4(:),G1H8(57),m3h2x8(:,808),heltab2x16(:,:,808))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(752),n2h8(367))
  call Hloop_QV_A(ntryL,G1H16(558),ex4(:),G1H8(57),m3h2x8(:,809),heltab2x16(:,:,809))
  call Hloop_Q_A(ntryL,G1H8(57),44,nME,G2H8(753),n2h8(368))
  call Hloop_TV_S(ntryL,G1H16(243),36,ex4(:),8,G2H8(754),m3h2x8(:,810),heltab2x16(:,:,810))
call HGT_OLR(G1H16(244),1,1,16)
call HGT_invQ_OLR(G1H16(244),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(244),ex5(:),G1H8(57),m3h2x8(:,811),heltab2x16(:,:,811))
  call Hloop_TV_S(ntryL,G1H16(560),36,ex4(:),8,G2H8(755),m3h2x8(:,812),heltab2x16(:,:,812))
  call Hloop_TV_S(ntryL,G1H16(561),36,ex4(:),8,G2H8(756),m3h2x8(:,813),heltab2x16(:,:,813))
  call Hloop_TV_S(ntryL,G1H16(562),36,ex4(:),8,G2H8(757),m3h2x8(:,814),heltab2x16(:,:,814))
  call Hloop_UV_W(ntryL,G1H16(249),36,ex4(:),8,G2H8(758),m3h2x8(:,815),heltab2x16(:,:,815))
call HGT_raise_alpha_OLR(G1H16(250),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(250),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(250),ex5(:),G1H8(58),m3h2x8(:,816),heltab2x16(:,:,816))
  call Hloop_UV_W(ntryL,G1H16(252),36,ex4(:),8,G2H8(759),m3h2x8(:,817),heltab2x16(:,:,817))
  call Hloop_UV_W(ntryL,G1H16(563),36,ex4(:),8,G2H8(760),m3h2x8(:,818),heltab2x16(:,:,818))
  call Hloop_UV_W(ntryL,G1H16(564),36,ex4(:),8,G2H8(761),m3h2x8(:,819),heltab2x16(:,:,819))
  call Hloop_UV_W(ntryL,G1H16(255),36,ex4(:),8,G2H8(762),m3h2x8(:,820),heltab2x16(:,:,820))
call HGT_raise_alpha_OLR(G1H16(256),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(256),2,5,16)
  call Hloop_UW_V(ntryL,G1H16(256),-16,ex5(:),16,G2H8(763),m3h2x8(:,821),heltab2x16(:,:,821))
  call Hloop_UV_W(ntryL,G1H16(566),36,ex4(:),8,G2H8(764),m3h2x8(:,822),heltab2x16(:,:,822))
  call Hloop_UV_W(ntryL,G1H16(567),36,ex4(:),8,G2H8(765),m3h2x8(:,823),heltab2x16(:,:,823))
  call Hloop_UV_W(ntryL,G1H16(568),36,ex4(:),8,G2H8(766),m3h2x8(:,824),heltab2x16(:,:,824))
  call Hloop_AV_Q(ntryL,G1H16(569),ex5(:),G1H8(59),m3h2x8(:,825),heltab2x16(:,:,825))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(767),n2h8(369))
call HGT_OLR(G1H16(570),1,1,16)
call HGT_invQ_OLR(G1H16(570),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(570),-8,nME,G2H16(21),n2h16(521))
  call Hloop_QV_A(ntryL,G2H16(21),ex4(:),G2H8(768),m3h2x8(:,826),heltab2x16(:,:,826))
  call Hloop_AV_Q(ntryL,G1H16(572),ex5(:),G1H8(59),m3h2x8(:,827),heltab2x16(:,:,827))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(769),n2h8(370))
  call Hloop_AV_Q(ntryL,G1H16(573),ex5(:),G1H8(59),m3h2x8(:,828),heltab2x16(:,:,828))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(770),n2h8(371))
  call Hloop_AV_Q(ntryL,G1H16(574),ex5(:),G1H8(59),m3h2x8(:,829),heltab2x16(:,:,829))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(771),n2h8(372))
  call Hloop_AV_Q(ntryL,G1H16(575),ex5(:),G1H8(59),m3h2x8(:,830),heltab2x16(:,:,830))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(772),n2h8(373))
call HGT_OLR(G1H16(576),1,1,16)
call HGT_invQ_OLR(G1H16(576),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(576),-8,nME,G2H16(22),n2h16(522))
  call Hloop_QV_A(ntryL,G2H16(22),ex4(:),G2H8(773),m3h2x8(:,831),heltab2x16(:,:,831))
  call Hloop_AV_Q(ntryL,G1H16(578),ex5(:),G1H8(59),m3h2x8(:,832),heltab2x16(:,:,832))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(774),n2h8(374))
  call Hloop_AV_Q(ntryL,G1H16(579),ex5(:),G1H8(59),m3h2x8(:,833),heltab2x16(:,:,833))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(775),n2h8(375))
  call Hloop_AV_Q(ntryL,G1H16(580),ex5(:),G1H8(59),m3h2x8(:,834),heltab2x16(:,:,834))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(776),n2h8(376))
  call Hloop_SV_T(ntryL,G1H16(581),36,ex5(:),16,G2H8(777),m3h2x8(:,835),heltab2x16(:,:,835))
call HGT_OLR(G1H16(582),1,1,16)
call HGT_invQ_OLR(G1H16(582),2,5,16)
  call Hloop_TV_S(ntryL,G1H16(582),-8,ex4(:),8,G2H8(778),m3h2x8(:,836),heltab2x16(:,:,836))
  call Hloop_SV_T(ntryL,G1H16(584),36,ex5(:),16,G2H8(779),m3h2x8(:,837),heltab2x16(:,:,837))
  call Hloop_SV_T(ntryL,G1H16(585),36,ex5(:),16,G2H8(780),m3h2x8(:,838),heltab2x16(:,:,838))
  call Hloop_SV_T(ntryL,G1H16(586),36,ex5(:),16,G2H8(781),m3h2x8(:,839),heltab2x16(:,:,839))
  call Hloop_AV_Q(ntryL,G1H16(587),ex5(:),G1H8(59),m3h2x8(:,840),heltab2x16(:,:,840))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(782),n2h8(377))
call HGT_OLR(G1H16(588),1,1,16)
call HGT_invQ_OLR(G1H16(588),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(588),-8,nME,G2H16(23),n2h16(524))
  call Hloop_QV_A(ntryL,G2H16(23),ex4(:),G2H8(783),m3h2x8(:,841),heltab2x16(:,:,841))
  call Hloop_AV_Q(ntryL,G1H16(590),ex5(:),G1H8(59),m3h2x8(:,842),heltab2x16(:,:,842))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(784),n2h8(378))
  call Hloop_AV_Q(ntryL,G1H16(591),ex5(:),G1H8(59),m3h2x8(:,843),heltab2x16(:,:,843))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(785),n2h8(379))
  call Hloop_AV_Q(ntryL,G1H16(592),ex5(:),G1H8(59),m3h2x8(:,844),heltab2x16(:,:,844))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(786),n2h8(380))
  call Hloop_AV_Q(ntryL,G1H16(593),ex5(:),G1H8(59),m3h2x8(:,845),heltab2x16(:,:,845))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(787),n2h8(381))
call HGT_OLR(G1H16(594),1,1,16)
call HGT_invQ_OLR(G1H16(594),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(594),-8,nME,G2H16(24),n2h16(525))
  call Hloop_QV_A(ntryL,G2H16(24),ex4(:),G2H8(788),m3h2x8(:,846),heltab2x16(:,:,846))
  call Hloop_AV_Q(ntryL,G1H16(596),ex5(:),G1H8(59),m3h2x8(:,847),heltab2x16(:,:,847))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(789),n2h8(382))
  call Hloop_AV_Q(ntryL,G1H16(597),ex5(:),G1H8(59),m3h2x8(:,848),heltab2x16(:,:,848))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(790),n2h8(383))
  call Hloop_AV_Q(ntryL,G1H16(598),ex5(:),G1H8(59),m3h2x8(:,849),heltab2x16(:,:,849))
  call Hloop_A_Q(ntryL,G1H8(59),52,nME,G2H8(791),n2h8(384))
  call Hloop_SV_T(ntryL,G1H16(259),36,ex5(:),16,G2H8(792),m3h2x8(:,850),heltab2x16(:,:,850))
call HGT_OLR(G1H16(260),1,1,16)
call HGT_invQ_OLR(G1H16(260),2,5,16)
  call Hloop_SV_V(ntryL,G1H16(260),ex4(:),G1H8(59),m3h2x8(:,851),heltab2x16(:,:,851))
  call Hloop_SV_T(ntryL,G1H16(600),36,ex5(:),16,G2H8(793),m3h2x8(:,852),heltab2x16(:,:,852))
  call Hloop_SV_T(ntryL,G1H16(601),36,ex5(:),16,G2H8(794),m3h2x8(:,853),heltab2x16(:,:,853))
  call Hloop_SV_T(ntryL,G1H16(602),36,ex5(:),16,G2H8(795),m3h2x8(:,854),heltab2x16(:,:,854))
  call Hloop_UW_V(ntryL,G1H16(265),36,ex5(:),16,G2H8(796),m3h2x8(:,855),heltab2x16(:,:,855))
call HGT_raise_alpha_OLR(G1H16(266),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(266),2,5,16)
  call Hloop_VV_S(ntryL,G1H16(266),ex4(:),G1H8(60),m3h2x8(:,856),heltab2x16(:,:,856))
  call Hloop_UW_V(ntryL,G1H16(268),36,ex5(:),16,G2H8(797),m3h2x8(:,857),heltab2x16(:,:,857))
  call Hloop_UW_V(ntryL,G1H16(603),36,ex5(:),16,G2H8(798),m3h2x8(:,858),heltab2x16(:,:,858))
  call Hloop_UW_V(ntryL,G1H16(604),36,ex5(:),16,G2H8(799),m3h2x8(:,859),heltab2x16(:,:,859))
  call Hloop_UW_V(ntryL,G1H16(271),36,ex5(:),16,G2H8(800),m3h2x8(:,860),heltab2x16(:,:,860))
call HGT_raise_alpha_OLR(G1H16(272),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(272),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(272),-8,ex4(:),8,G2H8(801),m3h2x8(:,861),heltab2x16(:,:,861))
  call Hloop_UW_V(ntryL,G1H16(606),36,ex5(:),16,G2H8(802),m3h2x8(:,862),heltab2x16(:,:,862))
  call Hloop_UW_V(ntryL,G1H16(607),36,ex5(:),16,G2H8(803),m3h2x8(:,863),heltab2x16(:,:,863))
  call Hloop_UW_V(ntryL,G1H16(608),36,ex5(:),16,G2H8(804),m3h2x8(:,864),heltab2x16(:,:,864))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(375),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(361),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(383),[G2H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(366),[G2H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(388),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(370),[G2H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(392),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(379),[G2H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(415),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(397),[G2H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(419),[G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(424),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(402),[G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(406),[G2H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(428),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(411),[G2H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(443),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(458),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(462),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(466),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(489),[G2H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(471),[G2H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(493),[G2H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(498),[G2H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(476),[G2H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(480),[G2H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(502),[G2H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(485),[G2H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G2H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(525),[G2H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(507),[G2H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(529),[G2H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(534),[G2H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(512),[G2H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(516),[G2H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(538),[G2H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(521),[G2H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(557),[G2H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(543),[G2H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(565),[G2H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(548),[G2H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(570),[G2H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(552),[G2H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(574),[G2H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(561),[G2H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(111),[G2H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(589),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(113),[G2H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(115),[G2H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(604),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(608),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(116),[G2H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(612),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(119),[G2H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(627),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(120),[G2H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(646),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(123),[G2H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(642),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(124),[G2H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(650),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(129),[G2H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(149),[G2H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(167),[G2H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(665),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(168),[G2H8(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(684),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(171),[G2H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(680),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(172),[G2H8(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(688),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(707),[G2H8(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(693),[G2H8(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(715),[G2H8(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(698),[G2H8(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(720),[G2H8(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(702),[G2H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(724),[G2H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(711),[G2H8(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(187),[G2H8(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(739),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(188),[G2H8(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(758),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(191),[G2H8(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(754),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(192),[G2H8(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(762),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(195),[G2H8(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(777),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(197),[G2H8(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(199),[G2H8(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(792),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(796),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(200),[G2H8(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(800),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(205),[G2H8(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(225),[G2H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(245),[G2H8(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(265),[G2H8(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(285),[G2H8(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(305),[G2H8(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(325),[G2H8(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(345),[G2H8(342)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,6),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,7),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,8),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(1),mass5set(:,7),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hloop_AQ_S(ntryL,G2H8(375),ex1(:),G2H4(1),ngPnl,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(361),ex1(:),G2H4(2),ngPnl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_S(ntryL,G2H8(383),ex1(:),G2H4(3),ngPnl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_S(ntryL,G2H8(366),ex1(:),G2H4(4),ngPnl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_W(ntryL,G2H8(388),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G2H8(370),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_W(ntryL,G2H8(392),ex1(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_W(ntryL,G2H8(379),ex1(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(2),mass5set(:,6),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(2),mass5set(:,7),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),16,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(2),mass5set(:,8),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(2),mass5set(:,7),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),16,8)
  call Hloop_QA_S(ntryL,G2H8(415),ex2(:),G2H4(9),ngPln,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_S(ntryL,G2H8(397),ex2(:),G2H4(10),ngPln,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_S(ntryL,G2H8(419),ex2(:),G2H4(11),ngPln,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_W(ntryL,G2H8(424),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_S(ntryL,G2H8(402),ex2(:),G2H4(13),ngPln,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_W(ntryL,G2H8(406),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_W(ntryL,G2H8(428),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_W(ntryL,G2H8(411),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(3),mass5set(:,4),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),16,8)
  call Hotf_5pt_reduction(G2H8(443),RedSet_5(3),mass5set(:,4),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),16,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(3),mass5set(:,4),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),16,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(3),mass5set(:,4),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),16,8)
  call Hotf_5pt_reduction(G2H8(458),RedSet_5(3),mass5set(:,4),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),16,8)
  call Hotf_5pt_reduction(G2H8(462),RedSet_5(3),mass5set(:,4),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(3),mass5set(:,4),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),16,8)
  call Hotf_5pt_reduction(G2H8(466),RedSet_5(3),mass5set(:,4),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),16,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(2),mass5set(:,6),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(2),mass5set(:,7),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(2),mass5set(:,8),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(2),mass5set(:,7),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hloop_QA_S(ntryL,G2H8(489),ex2(:),G2H4(17),ngPln,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_S(ntryL,G2H8(471),ex2(:),G2H4(18),ngPln,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_S(ntryL,G2H8(493),ex2(:),G2H4(19),ngPln,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_W(ntryL,G2H8(498),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_S(ntryL,G2H8(476),ex2(:),G2H4(21),ngPln,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(480),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G2H8(502),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G2H8(485),ex2(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(11),mass5set(:,9),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),16,8)
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(11),mass5set(:,10),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),16,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(11),mass5set(:,11),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),16,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(11),mass5set(:,12),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),16,8)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(11),mass5set(:,11),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),16,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(11),mass5set(:,11),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),16,8)
  call Hloop_SV_V(ntryL,G2H8(52),ex3(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_VV_S(ntryL,G2H8(53),ex3(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(11),mass5set(:,11),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),16,8)
  call Hloop_SV_V(ntryL,G2H8(55),ex3(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_SV_V(ntryL,G2H8(56),ex3(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VV_S(ntryL,G2H8(57),ex3(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_VV_S(ntryL,G2H8(58),ex3(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(11),mass5set(:,11),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),16,8)
  call Hloop_SV_V(ntryL,G2H8(60),ex3(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_VV_S(ntryL,G2H8(61),ex3(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(11),mass5set(:,11),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),16,8)
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(11),mass5set(:,11),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),16,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(11),mass5set(:,11),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),16,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(11),mass5set(:,9),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),8,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(11),mass5set(:,10),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(11),mass5set(:,11),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(11),mass5set(:,12),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(70),RedSet_5(11),mass5set(:,11),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(11),mass5set(:,11),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),8,8)
  call Hloop_SV_V(ntryL,G2H8(72),ex3(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_VV_S(ntryL,G2H8(73),ex3(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(11),mass5set(:,11),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),8,8)
  call Hloop_SV_V(ntryL,G2H8(75),ex3(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_SV_V(ntryL,G2H8(76),ex3(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_VV_S(ntryL,G2H8(77),ex3(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_VV_S(ntryL,G2H8(78),ex3(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hotf_5pt_reduction(G2H8(79),RedSet_5(11),mass5set(:,11),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),8,8)
  call Hloop_SV_V(ntryL,G2H8(80),ex3(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_VV_S(ntryL,G2H8(81),ex3(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(11),mass5set(:,11),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),8,8)
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(11),mass5set(:,11),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),8,8)
  call Hotf_5pt_reduction(G2H8(84),RedSet_5(11),mass5set(:,11),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),8,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(4),mass5set(:,6),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),16,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(4),mass5set(:,7),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),16,8)
  call Hotf_5pt_reduction(G2H8(87),RedSet_5(4),mass5set(:,8),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),16,8)
  call Hotf_5pt_reduction(G2H8(88),RedSet_5(4),mass5set(:,7),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),16,8)
  call Hloop_QA_S(ntryL,G2H8(525),ex2(:),G2H4(41),ngPln,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_QA_S(ntryL,G2H8(507),ex2(:),G2H4(42),ngPln,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_QA_S(ntryL,G2H8(529),ex2(:),G2H4(43),ngPln,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_QA_W(ntryL,G2H8(534),ex2(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_QA_S(ntryL,G2H8(512),ex2(:),G2H4(45),ngPln,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_QA_W(ntryL,G2H8(516),ex2(:),G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_QA_W(ntryL,G2H8(538),ex2(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G2H8(521),ex2(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(5),mass5set(:,6),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),16,8)
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(5),mass5set(:,7),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),16,8)
  call Hotf_5pt_reduction(G2H8(99),RedSet_5(5),mass5set(:,8),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),16,8)
  call Hotf_5pt_reduction(G2H8(100),RedSet_5(5),mass5set(:,7),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(332),16,8)
  call Hloop_AQ_S(ntryL,G2H8(557),ex1(:),G2H4(49),ngPnl,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AQ_S(ntryL,G2H8(543),ex1(:),G2H4(50),ngPnl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AQ_S(ntryL,G2H8(565),ex1(:),G2H4(51),ngPnl,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_AQ_S(ntryL,G2H8(548),ex1(:),G2H4(52),ngPnl,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_AQ_W(ntryL,G2H8(570),ex1(:),G2H4(53),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_AQ_W(ntryL,G2H8(552),ex1(:),G2H4(54),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AQ_W(ntryL,G2H8(574),ex1(:),G2H4(55),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_W(ntryL,G2H8(561),ex1(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hotf_5pt_reduction(G2H8(111),RedSet_5(6),mass5set(:,4),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),16,8)
  call Hotf_5pt_reduction(G2H8(589),RedSet_5(6),mass5set(:,4),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),G1H8(348),8)
  call HG1shiftOLR(G1H8(344),16,8)
  call Hotf_5pt_reduction(G2H8(113),RedSet_5(6),mass5set(:,4),  & 
G1H8(349),G1H8(350),G1H8(351),G1H8(352),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(350),16,8)
  call Hotf_5pt_reduction(G2H8(115),RedSet_5(6),mass5set(:,4),  & 
G1H8(355),G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),8)
  call HG1shiftOLR(G1H8(356),16,8)
  call Hotf_5pt_reduction(G2H8(604),RedSet_5(6),mass5set(:,4),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),8)
  call HG1shiftOLR(G1H8(362),16,8)
  call Hotf_5pt_reduction(G2H8(608),RedSet_5(6),mass5set(:,4),  & 
G1H8(367),G1H8(368),G1H8(369),G1H8(370),G1H8(371),G1H8(372),8)
  call HG1shiftOLR(G1H8(368),16,8)
  call Hotf_5pt_reduction(G2H8(116),RedSet_5(6),mass5set(:,4),  & 
G1H8(373),G1H8(374),G1H8(375),G1H8(376),G1H8(377),G1H8(378),8)
  call HG1shiftOLR(G1H8(374),16,8)
  call Hotf_5pt_reduction(G2H8(612),RedSet_5(6),mass5set(:,4),  & 
G1H8(379),G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(380),16,8)
  call Hotf_5pt_reduction(G2H8(119),RedSet_5(7),mass5set(:,4),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),8,8)
  call Hotf_5pt_reduction(G2H8(627),RedSet_5(7),mass5set(:,4),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(392),8,8)
  call Hotf_5pt_reduction(G2H8(120),RedSet_5(7),mass5set(:,4),  & 
G1H8(397),G1H8(398),G1H8(399),G1H8(400),G1H8(401),G1H8(402),8)
  call HG1shiftOLR(G1H8(398),8,8)
  call Hotf_5pt_reduction(G2H8(646),RedSet_5(7),mass5set(:,4),  & 
G1H8(403),G1H8(404),G1H8(405),G1H8(406),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(404),8,8)
  call Hotf_5pt_reduction(G2H8(123),RedSet_5(7),mass5set(:,4),  & 
G1H8(409),G1H8(410),G1H8(411),G1H8(412),G1H8(413),G1H8(414),8)
  call HG1shiftOLR(G1H8(410),8,8)
  call Hotf_5pt_reduction(G2H8(642),RedSet_5(7),mass5set(:,4),  & 
G1H8(415),G1H8(416),G1H8(417),G1H8(418),G1H8(419),G1H8(420),8)
  call HG1shiftOLR(G1H8(416),8,8)
  call Hotf_5pt_reduction(G2H8(124),RedSet_5(7),mass5set(:,4),  & 
G1H8(421),G1H8(422),G1H8(423),G1H8(424),G1H8(425),G1H8(426),8)
  call HG1shiftOLR(G1H8(422),8,8)
  call Hotf_5pt_reduction(G2H8(650),RedSet_5(7),mass5set(:,4),  & 
G1H8(427),G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(428),8,8)
  call Hotf_5pt_reduction(G2H8(125),RedSet_5(12),mass5set(:,9),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),16,8)
  call Hotf_5pt_reduction(G2H8(129),RedSet_5(12),mass5set(:,10),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),G1H8(444),8)
  call HG1shiftOLR(G1H8(440),16,8)
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(12),mass5set(:,11),  & 
G1H8(445),G1H8(446),G1H8(447),G1H8(448),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(446),16,8)
  call Hotf_5pt_reduction(G2H8(128),RedSet_5(12),mass5set(:,12),  & 
G1H8(451),G1H8(452),G1H8(453),G1H8(454),G1H8(455),G1H8(456),8)
  call HG1shiftOLR(G1H8(452),16,8)
  call Hotf_5pt_reduction(G2H8(130),RedSet_5(12),mass5set(:,11),  & 
G1H8(457),G1H8(458),G1H8(459),G1H8(460),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(458),16,8)
  call Hotf_5pt_reduction(G2H8(131),RedSet_5(12),mass5set(:,11),  & 
G1H8(463),G1H8(464),G1H8(465),G1H8(466),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(464),16,8)
  call Hloop_SV_V(ntryL,G2H8(132),ex4(:),G2H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_VV_S(ntryL,G2H8(133),ex4(:),G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hotf_5pt_reduction(G2H8(134),RedSet_5(12),mass5set(:,11),  & 
G1H8(469),G1H8(470),G1H8(471),G1H8(472),G1H8(473),G1H8(474),8)
  call HG1shiftOLR(G1H8(470),16,8)
  call Hloop_SV_V(ntryL,G2H8(135),ex4(:),G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_SV_V(ntryL,G2H8(136),ex4(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_VV_S(ntryL,G2H8(137),ex4(:),G2H4(61),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_VV_S(ntryL,G2H8(138),ex4(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hotf_5pt_reduction(G2H8(139),RedSet_5(12),mass5set(:,11),  & 
G1H8(475),G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(476),16,8)
  call Hloop_SV_V(ntryL,G2H8(140),ex4(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_VV_S(ntryL,G2H8(141),ex4(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hotf_5pt_reduction(G2H8(142),RedSet_5(12),mass5set(:,11),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),16,8)
  call Hotf_5pt_reduction(G2H8(143),RedSet_5(12),mass5set(:,11),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),G1H8(492),8)
  call HG1shiftOLR(G1H8(488),16,8)
  call Hotf_5pt_reduction(G2H8(144),RedSet_5(12),mass5set(:,11),  & 
G1H8(493),G1H8(494),G1H8(495),G1H8(496),G1H8(497),G1H8(498),8)
  call HG1shiftOLR(G1H8(494),16,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(12),mass5set(:,9),  & 
G1H8(499),G1H8(500),G1H8(501),G1H8(502),G1H8(503),G1H8(504),8)
  call HG1shiftOLR(G1H8(500),4,8)
  call Hotf_5pt_reduction(G2H8(149),RedSet_5(12),mass5set(:,10),  & 
G1H8(505),G1H8(506),G1H8(507),G1H8(508),G1H8(509),G1H8(510),8)
  call HG1shiftOLR(G1H8(506),4,8)
  call Hotf_5pt_reduction(G2H8(147),RedSet_5(12),mass5set(:,11),  & 
G1H8(511),G1H8(512),G1H8(513),G1H8(514),G1H8(515),G1H8(516),8)
  call HG1shiftOLR(G1H8(512),4,8)
  call Hotf_5pt_reduction(G2H8(148),RedSet_5(12),mass5set(:,12),  & 
G1H8(517),G1H8(518),G1H8(519),G1H8(520),G1H8(521),G1H8(522),8)
  call HG1shiftOLR(G1H8(518),4,8)
  call Hloop_SV_V(ntryL,G2H8(150),ex4(:),G2H4(65),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hotf_5pt_reduction(G2H8(151),RedSet_5(12),mass5set(:,11),  & 
G1H8(523),G1H8(524),G1H8(525),G1H8(526),G1H8(527),G1H8(528),8)
  call HG1shiftOLR(G1H8(524),4,8)
  call Hotf_5pt_reduction(G2H8(152),RedSet_5(12),mass5set(:,11),  & 
G1H8(529),G1H8(530),G1H8(531),G1H8(532),G1H8(533),G1H8(534),8)
  call HG1shiftOLR(G1H8(530),4,8)
  call Hloop_VV_S(ntryL,G2H8(153),ex4(:),G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_SV_V(ntryL,G2H8(154),ex4(:),G2H4(67),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_SV_V(ntryL,G2H8(155),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hotf_5pt_reduction(G2H8(156),RedSet_5(12),mass5set(:,11),  & 
G1H8(535),G1H8(536),G1H8(537),G1H8(538),G1H8(539),G1H8(540),8)
  call HG1shiftOLR(G1H8(536),4,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(12),mass5set(:,11),  & 
G1H8(541),G1H8(542),G1H8(543),G1H8(544),G1H8(545),G1H8(546),8)
  call HG1shiftOLR(G1H8(542),4,8)
  call Hloop_VV_S(ntryL,G2H8(158),ex4(:),G2H4(69),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_VV_S(ntryL,G2H8(159),ex4(:),G2H4(70),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_SV_V(ntryL,G2H8(160),ex4(:),G2H4(71),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hotf_5pt_reduction(G2H8(161),RedSet_5(12),mass5set(:,11),  & 
G1H8(547),G1H8(548),G1H8(549),G1H8(550),G1H8(551),G1H8(552),8)
  call HG1shiftOLR(G1H8(548),4,8)
  call Hotf_5pt_reduction(G2H8(162),RedSet_5(12),mass5set(:,11),  & 
G1H8(553),G1H8(554),G1H8(555),G1H8(556),G1H8(557),G1H8(558),8)
  call HG1shiftOLR(G1H8(554),4,8)
  call Hloop_VV_S(ntryL,G2H8(163),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hotf_5pt_reduction(G2H8(164),RedSet_5(12),mass5set(:,11),  & 
G1H8(559),G1H8(560),G1H8(561),G1H8(562),G1H8(563),G1H8(564),8)
  call HG1shiftOLR(G1H8(560),4,8)
  call Hotf_5pt_reduction(G2H8(167),RedSet_5(8),mass5set(:,4),  & 
G1H8(565),G1H8(566),G1H8(567),G1H8(568),G1H8(569),G1H8(570),8)
  call HG1shiftOLR(G1H8(566),16,8)
  call Hotf_5pt_reduction(G2H8(665),RedSet_5(8),mass5set(:,4),  & 
G1H8(571),G1H8(572),G1H8(573),G1H8(574),G1H8(575),G1H8(576),8)
  call HG1shiftOLR(G1H8(572),16,8)
  call Hotf_5pt_reduction(G2H8(168),RedSet_5(8),mass5set(:,4),  & 
G1H8(577),G1H8(578),G1H8(579),G1H8(580),G1H8(581),G1H8(582),8)
  call HG1shiftOLR(G1H8(578),16,8)
  call Hotf_5pt_reduction(G2H8(684),RedSet_5(8),mass5set(:,4),  & 
G1H8(583),G1H8(584),G1H8(585),G1H8(586),G1H8(587),G1H8(588),8)
  call HG1shiftOLR(G1H8(584),16,8)
  call Hotf_5pt_reduction(G2H8(171),RedSet_5(8),mass5set(:,4),  & 
G1H8(589),G1H8(590),G1H8(591),G1H8(592),G1H8(593),G1H8(594),8)
  call HG1shiftOLR(G1H8(590),16,8)
  call Hotf_5pt_reduction(G2H8(680),RedSet_5(8),mass5set(:,4),  & 
G1H8(595),G1H8(596),G1H8(597),G1H8(598),G1H8(599),G1H8(600),8)
  call HG1shiftOLR(G1H8(596),16,8)
  call Hotf_5pt_reduction(G2H8(172),RedSet_5(8),mass5set(:,4),  & 
G1H8(601),G1H8(602),G1H8(603),G1H8(604),G1H8(605),G1H8(606),8)
  call HG1shiftOLR(G1H8(602),16,8)
  call Hotf_5pt_reduction(G2H8(688),RedSet_5(8),mass5set(:,4),  & 
G1H8(607),G1H8(608),G1H8(609),G1H8(610),G1H8(611),G1H8(612),8)
  call HG1shiftOLR(G1H8(608),16,8)
  call Hotf_5pt_reduction(G2H8(173),RedSet_5(5),mass5set(:,6),  & 
G1H8(613),G1H8(614),G1H8(615),G1H8(616),G1H8(617),G1H8(618),8)
  call HG1shiftOLR(G1H8(614),8,8)
  call Hotf_5pt_reduction(G2H8(174),RedSet_5(5),mass5set(:,7),  & 
G1H8(619),G1H8(620),G1H8(621),G1H8(622),G1H8(623),G1H8(624),8)
  call HG1shiftOLR(G1H8(620),8,8)
  call Hotf_5pt_reduction(G2H8(175),RedSet_5(5),mass5set(:,8),  & 
G1H8(625),G1H8(626),G1H8(627),G1H8(628),G1H8(629),G1H8(630),8)
  call HG1shiftOLR(G1H8(626),8,8)
  call Hotf_5pt_reduction(G2H8(176),RedSet_5(5),mass5set(:,7),  & 
G1H8(631),G1H8(632),G1H8(633),G1H8(634),G1H8(635),G1H8(636),8)
  call HG1shiftOLR(G1H8(632),8,8)
  call Hloop_AQ_S(ntryL,G2H8(707),ex1(:),G2H4(73),ngPnl,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_S(ntryL,G2H8(693),ex1(:),G2H4(74),ngPnl,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_AQ_S(ntryL,G2H8(715),ex1(:),G2H4(75),ngPnl,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_AQ_S(ntryL,G2H8(698),ex1(:),G2H4(76),ngPnl,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_AQ_W(ntryL,G2H8(720),ex1(:),G2H4(77),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_AQ_W(ntryL,G2H8(702),ex1(:),G2H4(78),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_AQ_W(ntryL,G2H8(724),ex1(:),G2H4(79),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_AQ_W(ntryL,G2H8(711),ex1(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hotf_5pt_reduction(G2H8(187),RedSet_5(9),mass5set(:,4),  & 
G1H8(637),G1H8(638),G1H8(639),G1H8(640),G1H8(641),G1H8(642),8)
  call HG1shiftOLR(G1H8(638),16,8)
  call Hotf_5pt_reduction(G2H8(739),RedSet_5(9),mass5set(:,4),  & 
G1H8(643),G1H8(644),G1H8(645),G1H8(646),G1H8(647),G1H8(648),8)
  call HG1shiftOLR(G1H8(644),16,8)
  call Hotf_5pt_reduction(G2H8(188),RedSet_5(9),mass5set(:,4),  & 
G1H8(649),G1H8(650),G1H8(651),G1H8(652),G1H8(653),G1H8(654),8)
  call HG1shiftOLR(G1H8(650),16,8)
  call Hotf_5pt_reduction(G2H8(758),RedSet_5(9),mass5set(:,4),  & 
G1H8(655),G1H8(656),G1H8(657),G1H8(658),G1H8(659),G1H8(660),8)
  call HG1shiftOLR(G1H8(656),16,8)
  call Hotf_5pt_reduction(G2H8(191),RedSet_5(9),mass5set(:,4),  & 
G1H8(661),G1H8(662),G1H8(663),G1H8(664),G1H8(665),G1H8(666),8)
  call HG1shiftOLR(G1H8(662),16,8)
  call Hotf_5pt_reduction(G2H8(754),RedSet_5(9),mass5set(:,4),  & 
G1H8(667),G1H8(668),G1H8(669),G1H8(670),G1H8(671),G1H8(672),8)
  call HG1shiftOLR(G1H8(668),16,8)
  call Hotf_5pt_reduction(G2H8(192),RedSet_5(9),mass5set(:,4),  & 
G1H8(673),G1H8(674),G1H8(675),G1H8(676),G1H8(677),G1H8(678),8)
  call HG1shiftOLR(G1H8(674),16,8)
  call Hotf_5pt_reduction(G2H8(762),RedSet_5(9),mass5set(:,4),  & 
G1H8(679),G1H8(680),G1H8(681),G1H8(682),G1H8(683),G1H8(684),8)
  call HG1shiftOLR(G1H8(680),16,8)
  call Hotf_5pt_reduction(G2H8(195),RedSet_5(10),mass5set(:,4),  & 
G1H8(685),G1H8(686),G1H8(687),G1H8(688),G1H8(689),G1H8(690),8)
  call HG1shiftOLR(G1H8(686),8,8)
  call Hotf_5pt_reduction(G2H8(777),RedSet_5(10),mass5set(:,4),  & 
G1H8(691),G1H8(692),G1H8(693),G1H8(694),G1H8(695),G1H8(696),8)
  call HG1shiftOLR(G1H8(692),8,8)
  call Hotf_5pt_reduction(G2H8(197),RedSet_5(10),mass5set(:,4),  & 
G1H8(697),G1H8(698),G1H8(699),G1H8(700),G1H8(701),G1H8(702),8)
  call HG1shiftOLR(G1H8(698),8,8)
  call Hotf_5pt_reduction(G2H8(199),RedSet_5(10),mass5set(:,4),  & 
G1H8(703),G1H8(704),G1H8(705),G1H8(706),G1H8(707),G1H8(708),8)
  call HG1shiftOLR(G1H8(704),8,8)
  call Hotf_5pt_reduction(G2H8(792),RedSet_5(10),mass5set(:,4),  & 
G1H8(709),G1H8(710),G1H8(711),G1H8(712),G1H8(713),G1H8(714),8)
  call HG1shiftOLR(G1H8(710),8,8)
  call Hotf_5pt_reduction(G2H8(796),RedSet_5(10),mass5set(:,4),  & 
G1H8(715),G1H8(716),G1H8(717),G1H8(718),G1H8(719),G1H8(720),8)
  call HG1shiftOLR(G1H8(716),8,8)
  call Hotf_5pt_reduction(G2H8(200),RedSet_5(10),mass5set(:,4),  & 
G1H8(721),G1H8(722),G1H8(723),G1H8(724),G1H8(725),G1H8(726),8)
  call HG1shiftOLR(G1H8(722),8,8)
  call Hotf_5pt_reduction(G2H8(800),RedSet_5(10),mass5set(:,4),  & 
G1H8(727),G1H8(728),G1H8(729),G1H8(730),G1H8(731),G1H8(732),8)
  call HG1shiftOLR(G1H8(728),8,8)
  call Hotf_5pt_reduction(G2H8(201),RedSet_5(13),mass5set(:,9),  & 
G1H8(733),G1H8(734),G1H8(735),G1H8(736),G1H8(737),G1H8(738),8)
  call HG1shiftOLR(G1H8(734),8,8)
  call Hotf_5pt_reduction(G2H8(205),RedSet_5(13),mass5set(:,10),  & 
G1H8(739),G1H8(740),G1H8(741),G1H8(742),G1H8(743),G1H8(744),8)
  call HG1shiftOLR(G1H8(740),8,8)
  call Hotf_5pt_reduction(G2H8(203),RedSet_5(13),mass5set(:,11),  & 
G1H8(745),G1H8(746),G1H8(747),G1H8(748),G1H8(749),G1H8(750),8)
  call HG1shiftOLR(G1H8(746),8,8)
  call Hotf_5pt_reduction(G2H8(204),RedSet_5(13),mass5set(:,12),  & 
G1H8(751),G1H8(752),G1H8(753),G1H8(754),G1H8(755),G1H8(756),8)
  call HG1shiftOLR(G1H8(752),8,8)
  call Hotf_5pt_reduction(G2H8(206),RedSet_5(13),mass5set(:,11),  & 
G1H8(757),G1H8(758),G1H8(759),G1H8(760),G1H8(761),G1H8(762),8)
  call HG1shiftOLR(G1H8(758),8,8)
  call Hloop_SV_V(ntryL,G2H8(207),ex5(:),G2H4(81),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hotf_5pt_reduction(G2H8(208),RedSet_5(13),mass5set(:,11),  & 
G1H8(763),G1H8(764),G1H8(765),G1H8(766),G1H8(767),G1H8(768),8)
  call HG1shiftOLR(G1H8(764),8,8)
  call Hloop_VV_S(ntryL,G2H8(209),ex5(:),G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_SV_V(ntryL,G2H8(210),ex5(:),G2H4(83),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hotf_5pt_reduction(G2H8(211),RedSet_5(13),mass5set(:,11),  & 
G1H8(769),G1H8(770),G1H8(771),G1H8(772),G1H8(773),G1H8(774),8)
  call HG1shiftOLR(G1H8(770),8,8)
  call Hloop_SV_V(ntryL,G2H8(212),ex5(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_VV_S(ntryL,G2H8(213),ex5(:),G2H4(85),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hotf_5pt_reduction(G2H8(214),RedSet_5(13),mass5set(:,11),  & 
G1H8(775),G1H8(776),G1H8(777),G1H8(778),G1H8(779),G1H8(780),8)
  call HG1shiftOLR(G1H8(776),8,8)
  call Hloop_VV_S(ntryL,G2H8(215),ex5(:),G2H4(86),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_SV_V(ntryL,G2H8(216),ex5(:),G2H4(87),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hotf_5pt_reduction(G2H8(217),RedSet_5(13),mass5set(:,11),  & 
G1H8(781),G1H8(782),G1H8(783),G1H8(784),G1H8(785),G1H8(786),8)
  call HG1shiftOLR(G1H8(782),8,8)
  call Hloop_VV_S(ntryL,G2H8(218),ex5(:),G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hotf_5pt_reduction(G2H8(219),RedSet_5(13),mass5set(:,11),  & 
G1H8(787),G1H8(788),G1H8(789),G1H8(790),G1H8(791),G1H8(792),8)
  call HG1shiftOLR(G1H8(788),8,8)
  call Hotf_5pt_reduction(G2H8(220),RedSet_5(13),mass5set(:,11),  & 
G1H8(793),G1H8(794),G1H8(795),G1H8(796),G1H8(797),G1H8(798),8)
  call HG1shiftOLR(G1H8(794),8,8)
  call Hotf_5pt_reduction(G2H8(221),RedSet_5(13),mass5set(:,9),  & 
G1H8(799),G1H8(800),G1H8(801),G1H8(802),G1H8(803),G1H8(804),8)
  call HG1shiftOLR(G1H8(800),4,8)
  call Hotf_5pt_reduction(G2H8(225),RedSet_5(13),mass5set(:,10),  & 
G1H8(805),G1H8(806),G1H8(807),G1H8(808),G1H8(809),G1H8(810),8)
  call HG1shiftOLR(G1H8(806),4,8)
  call Hotf_5pt_reduction(G2H8(223),RedSet_5(13),mass5set(:,11),  & 
G1H8(811),G1H8(812),G1H8(813),G1H8(814),G1H8(815),G1H8(816),8)
  call HG1shiftOLR(G1H8(812),4,8)
  call Hotf_5pt_reduction(G2H8(224),RedSet_5(13),mass5set(:,12),  & 
G1H8(817),G1H8(818),G1H8(819),G1H8(820),G1H8(821),G1H8(822),8)
  call HG1shiftOLR(G1H8(818),4,8)
  call Hloop_SV_V(ntryL,G2H8(226),ex5(:),G2H4(89),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hotf_5pt_reduction(G2H8(227),RedSet_5(13),mass5set(:,11),  & 
G1H8(823),G1H8(824),G1H8(825),G1H8(826),G1H8(827),G1H8(828),8)
  call HG1shiftOLR(G1H8(824),4,8)
  call Hotf_5pt_reduction(G2H8(228),RedSet_5(13),mass5set(:,11),  & 
G1H8(829),G1H8(830),G1H8(831),G1H8(832),G1H8(833),G1H8(834),8)
  call HG1shiftOLR(G1H8(830),4,8)
  call Hloop_VV_S(ntryL,G2H8(229),ex5(:),G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_SV_V(ntryL,G2H8(230),ex5(:),G2H4(91),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_SV_V(ntryL,G2H8(231),ex5(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hotf_5pt_reduction(G2H8(232),RedSet_5(13),mass5set(:,11),  & 
G1H8(835),G1H8(836),G1H8(837),G1H8(838),G1H8(839),G1H8(840),8)
  call HG1shiftOLR(G1H8(836),4,8)
  call Hotf_5pt_reduction(G2H8(233),RedSet_5(13),mass5set(:,11),  & 
G1H8(841),G1H8(842),G1H8(843),G1H8(844),G1H8(845),G1H8(846),8)
  call HG1shiftOLR(G1H8(842),4,8)
  call Hloop_VV_S(ntryL,G2H8(234),ex5(:),G2H4(93),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_VV_S(ntryL,G2H8(235),ex5(:),G2H4(94),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_SV_V(ntryL,G2H8(236),ex5(:),G2H4(95),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hotf_5pt_reduction(G2H8(237),RedSet_5(13),mass5set(:,11),  & 
G1H8(847),G1H8(848),G1H8(849),G1H8(850),G1H8(851),G1H8(852),8)
  call HG1shiftOLR(G1H8(848),4,8)
  call Hotf_5pt_reduction(G2H8(238),RedSet_5(13),mass5set(:,11),  & 
G1H8(853),G1H8(854),G1H8(855),G1H8(856),G1H8(857),G1H8(858),8)
  call HG1shiftOLR(G1H8(854),4,8)
  call Hloop_VV_S(ntryL,G2H8(239),ex5(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hotf_5pt_reduction(G2H8(240),RedSet_5(13),mass5set(:,11),  & 
G1H8(859),G1H8(860),G1H8(861),G1H8(862),G1H8(863),G1H8(864),8)
  call HG1shiftOLR(G1H8(860),4,8)
  call Hotf_5pt_reduction(G2H8(241),RedSet_5(14),mass5set(:,9),  & 
G1H8(865),G1H8(866),G1H8(867),G1H8(868),G1H8(869),G1H8(870),8)
  call HG1shiftOLR(G1H8(866),16,8)
  call Hotf_5pt_reduction(G2H8(245),RedSet_5(14),mass5set(:,10),  & 
G1H8(871),G1H8(872),G1H8(873),G1H8(874),G1H8(875),G1H8(876),8)
  call HG1shiftOLR(G1H8(872),16,8)
  call Hotf_5pt_reduction(G2H8(243),RedSet_5(14),mass5set(:,11),  & 
G1H8(877),G1H8(878),G1H8(879),G1H8(880),G1H8(881),G1H8(882),8)
  call HG1shiftOLR(G1H8(878),16,8)
  call Hotf_5pt_reduction(G2H8(244),RedSet_5(14),mass5set(:,12),  & 
G1H8(883),G1H8(884),G1H8(885),G1H8(886),G1H8(887),G1H8(888),8)
  call HG1shiftOLR(G1H8(884),16,8)
  call Hotf_5pt_reduction(G2H8(246),RedSet_5(14),mass5set(:,11),  & 
G1H8(889),G1H8(890),G1H8(891),G1H8(892),G1H8(893),G1H8(894),8)
  call HG1shiftOLR(G1H8(890),16,8)
  call Hotf_5pt_reduction(G2H8(247),RedSet_5(14),mass5set(:,11),  & 
G1H8(895),G1H8(896),G1H8(897),G1H8(898),G1H8(899),G1H8(900),8)
  call HG1shiftOLR(G1H8(896),16,8)
  call Hloop_SV_V(ntryL,G2H8(248),ex3(:),G2H4(97),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_VV_S(ntryL,G2H8(249),ex3(:),G2H4(98),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hotf_5pt_reduction(G2H8(250),RedSet_5(14),mass5set(:,11),  & 
G1H8(901),G1H8(902),G1H8(903),G1H8(904),G1H8(905),G1H8(906),8)
  call HG1shiftOLR(G1H8(902),16,8)
  call Hloop_SV_V(ntryL,G2H8(251),ex3(:),G2H4(99),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_SV_V(ntryL,G2H8(252),ex3(:),G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_VV_S(ntryL,G2H8(253),ex3(:),G2H4(101),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_VV_S(ntryL,G2H8(254),ex3(:),G2H4(102),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hotf_5pt_reduction(G2H8(255),RedSet_5(14),mass5set(:,11),  & 
G1H8(907),G1H8(908),G1H8(909),G1H8(910),G1H8(911),G1H8(912),8)
  call HG1shiftOLR(G1H8(908),16,8)
  call Hloop_SV_V(ntryL,G2H8(256),ex3(:),G2H4(103),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_VV_S(ntryL,G2H8(257),ex3(:),G2H4(104),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hotf_5pt_reduction(G2H8(258),RedSet_5(14),mass5set(:,11),  & 
G1H8(913),G1H8(914),G1H8(915),G1H8(916),G1H8(917),G1H8(918),8)
  call HG1shiftOLR(G1H8(914),16,8)
  call Hotf_5pt_reduction(G2H8(259),RedSet_5(14),mass5set(:,11),  & 
G1H8(919),G1H8(920),G1H8(921),G1H8(922),G1H8(923),G1H8(924),8)
  call HG1shiftOLR(G1H8(920),16,8)
  call Hotf_5pt_reduction(G2H8(260),RedSet_5(14),mass5set(:,11),  & 
G1H8(925),G1H8(926),G1H8(927),G1H8(928),G1H8(929),G1H8(930),8)
  call HG1shiftOLR(G1H8(926),16,8)
  call Hotf_5pt_reduction(G2H8(261),RedSet_5(14),mass5set(:,9),  & 
G1H8(931),G1H8(932),G1H8(933),G1H8(934),G1H8(935),G1H8(936),8)
  call HG1shiftOLR(G1H8(932),8,8)
  call Hotf_5pt_reduction(G2H8(265),RedSet_5(14),mass5set(:,10),  & 
G1H8(937),G1H8(938),G1H8(939),G1H8(940),G1H8(941),G1H8(942),8)
  call HG1shiftOLR(G1H8(938),8,8)
  call Hotf_5pt_reduction(G2H8(263),RedSet_5(14),mass5set(:,11),  & 
G1H8(943),G1H8(944),G1H8(945),G1H8(946),G1H8(947),G1H8(948),8)
  call HG1shiftOLR(G1H8(944),8,8)
  call Hotf_5pt_reduction(G2H8(264),RedSet_5(14),mass5set(:,12),  & 
G1H8(949),G1H8(950),G1H8(951),G1H8(952),G1H8(953),G1H8(954),8)
  call HG1shiftOLR(G1H8(950),8,8)
  call Hotf_5pt_reduction(G2H8(266),RedSet_5(14),mass5set(:,11),  & 
G1H8(955),G1H8(956),G1H8(957),G1H8(958),G1H8(959),G1H8(960),8)
  call HG1shiftOLR(G1H8(956),8,8)
  call Hotf_5pt_reduction(G2H8(267),RedSet_5(14),mass5set(:,11),  & 
G1H8(961),G1H8(962),G1H8(963),G1H8(964),G1H8(965),G1H8(966),8)
  call HG1shiftOLR(G1H8(962),8,8)
  call Hloop_SV_V(ntryL,G2H8(268),ex3(:),G2H4(105),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_VV_S(ntryL,G2H8(269),ex3(:),G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hotf_5pt_reduction(G2H8(270),RedSet_5(14),mass5set(:,11),  & 
G1H8(967),G1H8(968),G1H8(969),G1H8(970),G1H8(971),G1H8(972),8)
  call HG1shiftOLR(G1H8(968),8,8)
  call Hloop_SV_V(ntryL,G2H8(271),ex3(:),G2H4(107),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_SV_V(ntryL,G2H8(272),ex3(:),G2H4(108),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_VV_S(ntryL,G2H8(273),ex3(:),G2H4(109),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_VV_S(ntryL,G2H8(274),ex3(:),G2H4(110),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hotf_5pt_reduction(G2H8(275),RedSet_5(14),mass5set(:,11),  & 
G1H8(973),G1H8(974),G1H8(975),G1H8(976),G1H8(977),G1H8(978),8)
  call HG1shiftOLR(G1H8(974),8,8)
  call Hloop_SV_V(ntryL,G2H8(276),ex3(:),G2H4(111),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_VV_S(ntryL,G2H8(277),ex3(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hotf_5pt_reduction(G2H8(278),RedSet_5(14),mass5set(:,11),  & 
G1H8(979),G1H8(980),G1H8(981),G1H8(982),G1H8(983),G1H8(984),8)
  call HG1shiftOLR(G1H8(980),8,8)
  call Hotf_5pt_reduction(G2H8(279),RedSet_5(14),mass5set(:,11),  & 
G1H8(985),G1H8(986),G1H8(987),G1H8(988),G1H8(989),G1H8(990),8)
  call HG1shiftOLR(G1H8(986),8,8)
  call Hotf_5pt_reduction(G2H8(280),RedSet_5(14),mass5set(:,11),  & 
G1H8(991),G1H8(992),G1H8(993),G1H8(994),G1H8(995),G1H8(996),8)
  call HG1shiftOLR(G1H8(992),8,8)
  call Hotf_5pt_reduction(G2H8(281),RedSet_5(15),mass5set(:,9),  & 
G1H8(997),G1H8(998),G1H8(999),G1H8(1000),G1H8(1001),G1H8(1002),8)
  call HG1shiftOLR(G1H8(998),16,8)
  call Hotf_5pt_reduction(G2H8(285),RedSet_5(15),mass5set(:,10),  & 
G1H8(1003),G1H8(1004),G1H8(1005),G1H8(1006),G1H8(1007),G1H8(1008),8)
  call HG1shiftOLR(G1H8(1004),16,8)
  call Hotf_5pt_reduction(G2H8(283),RedSet_5(15),mass5set(:,11),  & 
G1H8(1009),G1H8(1010),G1H8(1011),G1H8(1012),G1H8(1013),G1H8(1014),8)
  call HG1shiftOLR(G1H8(1010),16,8)
  call Hotf_5pt_reduction(G2H8(284),RedSet_5(15),mass5set(:,12),  & 
G1H8(1015),G1H8(1016),G1H8(1017),G1H8(1018),G1H8(1019),G1H8(1020),8)
  call HG1shiftOLR(G1H8(1016),16,8)
  call Hotf_5pt_reduction(G2H8(286),RedSet_5(15),mass5set(:,11),  & 
G1H8(1021),G1H8(1022),G1H8(1023),G1H8(1024),G1H8(1025),G1H8(1026),8)
  call HG1shiftOLR(G1H8(1022),16,8)
  call Hotf_5pt_reduction(G2H8(287),RedSet_5(15),mass5set(:,11),  & 
G1H8(1027),G1H8(1028),G1H8(1029),G1H8(1030),G1H8(1031),G1H8(1032),8)
  call HG1shiftOLR(G1H8(1028),16,8)
  call Hloop_SV_V(ntryL,G2H8(288),ex4(:),G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_VV_S(ntryL,G2H8(289),ex4(:),G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hotf_5pt_reduction(G2H8(290),RedSet_5(15),mass5set(:,11),  & 
G1H8(1033),G1H8(1034),G1H8(1035),G1H8(1036),G1H8(1037),G1H8(1038),8)
  call HG1shiftOLR(G1H8(1034),16,8)
  call Hloop_SV_V(ntryL,G2H8(291),ex4(:),G2H4(115),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_SV_V(ntryL,G2H8(292),ex4(:),G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_VV_S(ntryL,G2H8(293),ex4(:),G2H4(117),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_VV_S(ntryL,G2H8(294),ex4(:),G2H4(118),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hotf_5pt_reduction(G2H8(295),RedSet_5(15),mass5set(:,11),  & 
G1H8(1039),G1H8(1040),G1H8(1041),G1H8(1042),G1H8(1043),G1H8(1044),8)
  call HG1shiftOLR(G1H8(1040),16,8)
  call Hloop_SV_V(ntryL,G2H8(296),ex4(:),G2H4(119),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_VV_S(ntryL,G2H8(297),ex4(:),G2H4(120),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hotf_5pt_reduction(G2H8(298),RedSet_5(15),mass5set(:,11),  & 
G1H8(1045),G1H8(1046),G1H8(1047),G1H8(1048),G1H8(1049),G1H8(1050),8)
  call HG1shiftOLR(G1H8(1046),16,8)
  call Hotf_5pt_reduction(G2H8(299),RedSet_5(15),mass5set(:,11),  & 
G1H8(1051),G1H8(1052),G1H8(1053),G1H8(1054),G1H8(1055),G1H8(1056),8)
  call HG1shiftOLR(G1H8(1052),16,8)
  call Hotf_5pt_reduction(G2H8(300),RedSet_5(15),mass5set(:,11),  & 
G1H8(1057),G1H8(1058),G1H8(1059),G1H8(1060),G1H8(1061),G1H8(1062),8)
  call HG1shiftOLR(G1H8(1058),16,8)
  call Hotf_5pt_reduction(G2H8(301),RedSet_5(15),mass5set(:,9),  & 
G1H8(1063),G1H8(1064),G1H8(1065),G1H8(1066),G1H8(1067),G1H8(1068),8)
  call HG1shiftOLR(G1H8(1064),4,8)
  call Hotf_5pt_reduction(G2H8(305),RedSet_5(15),mass5set(:,10),  & 
G1H8(1069),G1H8(1070),G1H8(1071),G1H8(1072),G1H8(1073),G1H8(1074),8)
  call HG1shiftOLR(G1H8(1070),4,8)
  call Hotf_5pt_reduction(G2H8(303),RedSet_5(15),mass5set(:,11),  & 
G1H8(1075),G1H8(1076),G1H8(1077),G1H8(1078),G1H8(1079),G1H8(1080),8)
  call HG1shiftOLR(G1H8(1076),4,8)
  call Hotf_5pt_reduction(G2H8(304),RedSet_5(15),mass5set(:,12),  & 
G1H8(1081),G1H8(1082),G1H8(1083),G1H8(1084),G1H8(1085),G1H8(1086),8)
  call HG1shiftOLR(G1H8(1082),4,8)
  call Hloop_SV_V(ntryL,G2H8(306),ex4(:),G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hotf_5pt_reduction(G2H8(307),RedSet_5(15),mass5set(:,11),  & 
G1H8(1087),G1H8(1088),G1H8(1089),G1H8(1090),G1H8(1091),G1H8(1092),8)
  call HG1shiftOLR(G1H8(1088),4,8)
  call Hotf_5pt_reduction(G2H8(308),RedSet_5(15),mass5set(:,11),  & 
G1H8(1093),G1H8(1094),G1H8(1095),G1H8(1096),G1H8(1097),G1H8(1098),8)
  call HG1shiftOLR(G1H8(1094),4,8)
  call Hloop_VV_S(ntryL,G2H8(309),ex4(:),G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_SV_V(ntryL,G2H8(310),ex4(:),G2H4(123),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_SV_V(ntryL,G2H8(311),ex4(:),G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hotf_5pt_reduction(G2H8(312),RedSet_5(15),mass5set(:,11),  & 
G1H8(1099),G1H8(1100),G1H8(1101),G1H8(1102),G1H8(1103),G1H8(1104),8)
  call HG1shiftOLR(G1H8(1100),4,8)
  call Hotf_5pt_reduction(G2H8(313),RedSet_5(15),mass5set(:,11),  & 
G1H8(1105),G1H8(1106),G1H8(1107),G1H8(1108),G1H8(1109),G1H8(1110),8)
  call HG1shiftOLR(G1H8(1106),4,8)
  call Hloop_VV_S(ntryL,G2H8(314),ex4(:),G2H4(125),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_VV_S(ntryL,G2H8(315),ex4(:),G2H4(126),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_SV_V(ntryL,G2H8(316),ex4(:),G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hotf_5pt_reduction(G2H8(317),RedSet_5(15),mass5set(:,11),  & 
G1H8(1111),G1H8(1112),G1H8(1113),G1H8(1114),G1H8(1115),G1H8(1116),8)
  call HG1shiftOLR(G1H8(1112),4,8)
  call Hotf_5pt_reduction(G2H8(318),RedSet_5(15),mass5set(:,11),  & 
G1H8(1117),G1H8(1118),G1H8(1119),G1H8(1120),G1H8(1121),G1H8(1122),8)
  call HG1shiftOLR(G1H8(1118),4,8)
  call Hloop_VV_S(ntryL,G2H8(319),ex4(:),G2H4(128),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hotf_5pt_reduction(G2H8(320),RedSet_5(15),mass5set(:,11),  & 
G1H8(1123),G1H8(1124),G1H8(1125),G1H8(1126),G1H8(1127),G1H8(1128),8)
  call HG1shiftOLR(G1H8(1124),4,8)
  call Hotf_5pt_reduction(G2H8(321),RedSet_5(16),mass5set(:,9),  & 
G1H8(1129),G1H8(1130),G1H8(1131),G1H8(1132),G1H8(1133),G1H8(1134),8)
  call HG1shiftOLR(G1H8(1130),8,8)
  call Hotf_5pt_reduction(G2H8(325),RedSet_5(16),mass5set(:,10),  & 
G1H8(1135),G1H8(1136),G1H8(1137),G1H8(1138),G1H8(1139),G1H8(1140),8)
  call HG1shiftOLR(G1H8(1136),8,8)
  call Hotf_5pt_reduction(G2H8(323),RedSet_5(16),mass5set(:,11),  & 
G1H8(1141),G1H8(1142),G1H8(1143),G1H8(1144),G1H8(1145),G1H8(1146),8)
  call HG1shiftOLR(G1H8(1142),8,8)
  call Hotf_5pt_reduction(G2H8(324),RedSet_5(16),mass5set(:,12),  & 
G1H8(1147),G1H8(1148),G1H8(1149),G1H8(1150),G1H8(1151),G1H8(1152),8)
  call HG1shiftOLR(G1H8(1148),8,8)
  call Hotf_5pt_reduction(G2H8(326),RedSet_5(16),mass5set(:,11),  & 
G1H8(1153),G1H8(1154),G1H8(1155),G1H8(1156),G1H8(1157),G1H8(1158),8)
  call HG1shiftOLR(G1H8(1154),8,8)
  call Hloop_SV_V(ntryL,G2H8(327),ex5(:),G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hotf_5pt_reduction(G2H8(328),RedSet_5(16),mass5set(:,11),  & 
G1H8(1159),G1H8(1160),G1H8(1161),G1H8(1162),G1H8(1163),G1H8(1164),8)
  call HG1shiftOLR(G1H8(1160),8,8)
  call Hloop_VV_S(ntryL,G2H8(329),ex5(:),G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_SV_V(ntryL,G2H8(330),ex5(:),G2H4(131),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hotf_5pt_reduction(G2H8(331),RedSet_5(16),mass5set(:,11),  & 
G1H8(1165),G1H8(1166),G1H8(1167),G1H8(1168),G1H8(1169),G1H8(1170),8)
  call HG1shiftOLR(G1H8(1166),8,8)
  call Hloop_SV_V(ntryL,G2H8(332),ex5(:),G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_VV_S(ntryL,G2H8(333),ex5(:),G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hotf_5pt_reduction(G2H8(334),RedSet_5(16),mass5set(:,11),  & 
G1H8(1171),G1H8(1172),G1H8(1173),G1H8(1174),G1H8(1175),G1H8(1176),8)
  call HG1shiftOLR(G1H8(1172),8,8)
  call Hloop_VV_S(ntryL,G2H8(335),ex5(:),G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_SV_V(ntryL,G2H8(336),ex5(:),G2H4(135),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hotf_5pt_reduction(G2H8(337),RedSet_5(16),mass5set(:,11),  & 
G1H8(1177),G1H8(1178),G1H8(1179),G1H8(1180),G1H8(1181),G1H8(1182),8)
  call HG1shiftOLR(G1H8(1178),8,8)
  call Hloop_VV_S(ntryL,G2H8(338),ex5(:),G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hotf_5pt_reduction(G2H8(339),RedSet_5(16),mass5set(:,11),  & 
G1H8(1183),G1H8(1184),G1H8(1185),G1H8(1186),G1H8(1187),G1H8(1188),8)
  call HG1shiftOLR(G1H8(1184),8,8)
  call Hotf_5pt_reduction(G2H8(340),RedSet_5(16),mass5set(:,11),  & 
G1H8(1189),G1H8(1190),G1H8(1191),G1H8(1192),G1H8(1193),G1H8(1194),8)
  call HG1shiftOLR(G1H8(1190),8,8)
  call Hotf_5pt_reduction(G2H8(341),RedSet_5(16),mass5set(:,9),  & 
G1H8(1195),G1H8(1196),G1H8(1197),G1H8(1198),G1H8(1199),G1H8(1200),8)
  call HG1shiftOLR(G1H8(1196),4,8)
  call Hotf_5pt_reduction(G2H8(345),RedSet_5(16),mass5set(:,10),  & 
G1H8(1201),G1H8(1202),G1H8(1203),G1H8(1204),G1H8(1205),G1H8(1206),8)
  call HG1shiftOLR(G1H8(1202),4,8)
  call Hotf_5pt_reduction(G2H8(343),RedSet_5(16),mass5set(:,11),  & 
G1H8(1207),G1H8(1208),G1H8(1209),G1H8(1210),G1H8(1211),G1H8(1212),8)
  call HG1shiftOLR(G1H8(1208),4,8)
  call Hotf_5pt_reduction(G2H8(344),RedSet_5(16),mass5set(:,12),  & 
G1H8(1213),G1H8(1214),G1H8(1215),G1H8(1216),G1H8(1217),G1H8(1218),8)
  call HG1shiftOLR(G1H8(1214),4,8)
  call Hloop_SV_V(ntryL,G2H8(346),ex5(:),G2H4(137),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hotf_5pt_reduction(G2H8(347),RedSet_5(16),mass5set(:,11),  & 
G1H8(1219),G1H8(1220),G1H8(1221),G1H8(1222),G1H8(1223),G1H8(1224),8)
  call HG1shiftOLR(G1H8(1220),4,8)
  call Hotf_5pt_reduction(G2H8(348),RedSet_5(16),mass5set(:,11),  & 
G1H8(1225),G1H8(1226),G1H8(1227),G1H8(1228),G1H8(1229),G1H8(1230),8)
  call HG1shiftOLR(G1H8(1226),4,8)
  call Hloop_VV_S(ntryL,G2H8(349),ex5(:),G2H4(138),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_SV_V(ntryL,G2H8(350),ex5(:),G2H4(139),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_SV_V(ntryL,G2H8(351),ex5(:),G2H4(140),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hotf_5pt_reduction(G2H8(352),RedSet_5(16),mass5set(:,11),  & 
G1H8(1231),G1H8(1232),G1H8(1233),G1H8(1234),G1H8(1235),G1H8(1236),8)
  call HG1shiftOLR(G1H8(1232),4,8)
  call Hotf_5pt_reduction(G2H8(353),RedSet_5(16),mass5set(:,11),  & 
G1H8(1237),G1H8(1238),G1H8(1239),G1H8(1240),G1H8(1241),G1H8(1242),8)
  call HG1shiftOLR(G1H8(1238),4,8)
  call Hloop_VV_S(ntryL,G2H8(354),ex5(:),G2H4(141),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_VV_S(ntryL,G2H8(355),ex5(:),G2H4(142),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_SV_V(ntryL,G2H8(356),ex5(:),G2H4(143),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hotf_5pt_reduction(G2H8(357),RedSet_5(16),mass5set(:,11),  & 
G1H8(1243),G1H8(1244),G1H8(1245),G1H8(1246),G1H8(1247),G1H8(1248),8)
  call HG1shiftOLR(G1H8(1244),4,8)
  call Hotf_5pt_reduction(G2H8(358),RedSet_5(16),mass5set(:,11),  & 
G1H8(1249),G1H8(1250),G1H8(1251),G1H8(1252),G1H8(1253),G1H8(1254),8)
  call HG1shiftOLR(G1H8(1250),4,8)
  call Hloop_VV_S(ntryL,G2H8(359),ex5(:),G2H4(144),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hotf_5pt_reduction(G2H8(360),RedSet_5(16),mass5set(:,11),  & 
G1H8(1255),G1H8(1256),G1H8(1257),G1H8(1258),G1H8(1259),G1H8(1260),8)
  call HG1shiftOLR(G1H8(1256),4,8)
  call Hloop_AQ_S(ntryL,G2H8(364),ex1(:),G2H4(145),ngPnl,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_AQ_S(ntryL,G2H8(365),ex1(:),G2H4(146),ngPnl,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_AQ_S(ntryL,G2H8(368),ex1(:),G2H4(147),ngPnl,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_AQ_S(ntryL,G2H8(369),ex1(:),G2H4(148),ngPnl,m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_AQ_W(ntryL,G2H8(373),ex1(:),G2H4(149),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_AQ_W(ntryL,G2H8(374),ex1(:),G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_AQ_S(ntryL,G2H8(377),ex1(:),G2H4(151),ngPnl,m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AQ_S(ntryL,G2H8(378),ex1(:),G2H4(152),ngPnl,m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AQ_W(ntryL,G2H8(381),ex1(:),G2H4(153),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_AQ_W(ntryL,G2H8(382),ex1(:),G2H4(154),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_AQ_S(ntryL,G2H8(386),ex1(:),G2H4(155),ngPnl,m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_AQ_S(ntryL,G2H8(387),ex1(:),G2H4(156),ngPnl,m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_AQ_W(ntryL,G2H8(390),ex1(:),G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_AQ_W(ntryL,G2H8(391),ex1(:),G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_AQ_W(ntryL,G2H8(395),ex1(:),G2H4(159),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_AQ_W(ntryL,G2H8(396),ex1(:),G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_QA_S(ntryL,G2H8(400),ex2(:),G2H4(161),ngPln,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_QA_S(ntryL,G2H8(401),ex2(:),G2H4(162),ngPln,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_QA_S(ntryL,G2H8(404),ex2(:),G2H4(163),ngPln,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_QA_S(ntryL,G2H8(405),ex2(:),G2H4(164),ngPln,m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_QA_W(ntryL,G2H8(409),ex2(:),G2H4(165),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_QA_W(ntryL,G2H8(410),ex2(:),G2H4(166),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_QA_W(ntryL,G2H8(413),ex2(:),G2H4(167),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_QA_W(ntryL,G2H8(414),ex2(:),G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_QA_S(ntryL,G2H8(417),ex2(:),G2H4(169),ngPln,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_QA_S(ntryL,G2H8(418),ex2(:),G2H4(170),ngPln,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_QA_S(ntryL,G2H8(422),ex2(:),G2H4(171),ngPln,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_QA_S(ntryL,G2H8(423),ex2(:),G2H4(172),ngPln,m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_QA_W(ntryL,G2H8(426),ex2(:),G2H4(173),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_QA_W(ntryL,G2H8(427),ex2(:),G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_QA_W(ntryL,G2H8(431),ex2(:),G2H4(175),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_QA_W(ntryL,G2H8(432),ex2(:),G2H4(176),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_AQ_S(ntryL,G2H8(433),ex1(:),G2H4(177),ngH,m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_AQ_S(ntryL,G2H8(436),ex1(:),G2H4(178),ngH,m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_AQ_S(ntryL,G2H8(437),ex1(:),G2H4(179),ngH,m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_AQ_S(ntryL,G2H8(438),ex1(:),G2H4(180),ngX,m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_AQ_S(ntryL,G2H8(441),ex1(:),G2H4(181),ngX,m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_AQ_S(ntryL,G2H8(442),ex1(:),G2H4(182),ngX,m3h2x4(:,182),heltab2x8(:,:,182))
  call Hotf_5pt_reduction(G2H8(446),RedSet_5(17),mass5set(:,1),  & 
G1H8(1261),G1H8(1262),G1H8(1263),G1H8(1264),G1H8(1265),G1H8(1266),8)
  call HG1shiftOLR(G1H8(1262),16,8)
  call Hotf_5pt_reduction(G2H8(447),RedSet_5(18),mass5set(:,13),  & 
G1H8(1267),G1H8(1268),G1H8(1269),G1H8(1270),G1H8(1271),G1H8(1272),8)
  call HG1shiftOLR(G1H8(1268),16,8)
  call Hloop_AQ_V(ntryL,G2H8(448),ex1(:),G2H4(183),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_AQ_V(ntryL,G2H8(451),ex1(:),G2H4(184),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_AQ_V(ntryL,G2H8(452),ex1(:),G2H4(185),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_AQ_Z(ntryL,G2H8(453),ex1(:),G2H4(186),ngZl,m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_AQ_Z(ntryL,G2H8(456),ex1(:),G2H4(187),ngZl,m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_AQ_Z(ntryL,G2H8(457),ex1(:),G2H4(188),ngZl,m3h2x4(:,188),heltab2x8(:,:,188))
  call Hotf_5pt_reduction(G2H8(460),RedSet_5(17),mass5set(:,1),  & 
G1H8(1273),G1H8(1274),G1H8(1275),G1H8(1276),G1H8(1277),G1H8(1278),8)
  call HG1shiftOLR(G1H8(1274),16,8)
  call Hotf_5pt_reduction(G2H8(461),RedSet_5(18),mass5set(:,13),  & 
G1H8(1279),G1H8(1280),G1H8(1281),G1H8(1282),G1H8(1283),G1H8(1284),8)
  call HG1shiftOLR(G1H8(1280),16,8)
  call Hotf_5pt_reduction(G2H8(464),RedSet_5(17),mass5set(:,1),  & 
G1H8(1285),G1H8(1286),G1H8(1287),G1H8(1288),G1H8(1289),G1H8(1290),8)
  call HG1shiftOLR(G1H8(1286),16,8)
  call Hotf_5pt_reduction(G2H8(465),RedSet_5(18),mass5set(:,13),  & 
G1H8(1291),G1H8(1292),G1H8(1293),G1H8(1294),G1H8(1295),G1H8(1296),8)
  call HG1shiftOLR(G1H8(1292),16,8)
  call Hotf_5pt_reduction(G2H8(469),RedSet_5(17),mass5set(:,1),  & 
G1H8(1297),G1H8(1298),G1H8(1299),G1H8(1300),G1H8(1301),G1H8(1302),8)
  call HG1shiftOLR(G1H8(1298),16,8)
  call Hotf_5pt_reduction(G2H8(470),RedSet_5(18),mass5set(:,13),  & 
G1H8(1303),G1H8(1304),G1H8(1305),G1H8(1306),G1H8(1307),G1H8(1308),8)
  call HG1shiftOLR(G1H8(1304),16,8)
  call Hloop_QA_S(ntryL,G2H8(474),ex2(:),G2H4(189),ngPln,m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_QA_S(ntryL,G2H8(475),ex2(:),G2H4(190),ngPln,m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_QA_S(ntryL,G2H8(478),ex2(:),G2H4(191),ngPln,m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_QA_S(ntryL,G2H8(479),ex2(:),G2H4(192),ngPln,m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_QA_W(ntryL,G2H8(483),ex2(:),G2H4(193),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_QA_W(ntryL,G2H8(484),ex2(:),G2H4(194),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_QA_W(ntryL,G2H8(487),ex2(:),G2H4(195),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_QA_W(ntryL,G2H8(488),ex2(:),G2H4(196),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QA_S(ntryL,G2H8(491),ex2(:),G2H4(197),ngPln,m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_S(ntryL,G2H8(492),ex2(:),G2H4(198),ngPln,m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_QA_S(ntryL,G2H8(496),ex2(:),G2H4(199),ngPln,m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_QA_S(ntryL,G2H8(497),ex2(:),G2H4(200),ngPln,m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_QA_W(ntryL,G2H8(500),ex2(:),G2H4(201),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_QA_W(ntryL,G2H8(501),ex2(:),G2H4(202),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_QA_W(ntryL,G2H8(505),ex2(:),G2H4(203),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_QA_W(ntryL,G2H8(506),ex2(:),G2H4(204),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_QA_S(ntryL,G2H8(510),ex2(:),G2H4(205),ngPln,m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_QA_S(ntryL,G2H8(511),ex2(:),G2H4(206),ngPln,m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_QA_S(ntryL,G2H8(514),ex2(:),G2H4(207),ngPln,m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_QA_S(ntryL,G2H8(515),ex2(:),G2H4(208),ngPln,m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_QA_W(ntryL,G2H8(519),ex2(:),G2H4(209),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_QA_W(ntryL,G2H8(520),ex2(:),G2H4(210),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_QA_W(ntryL,G2H8(523),ex2(:),G2H4(211),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_QA_W(ntryL,G2H8(524),ex2(:),G2H4(212),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_QA_S(ntryL,G2H8(527),ex2(:),G2H4(213),ngPln,m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_QA_S(ntryL,G2H8(528),ex2(:),G2H4(214),ngPln,m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_QA_S(ntryL,G2H8(532),ex2(:),G2H4(215),ngPln,m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_QA_S(ntryL,G2H8(533),ex2(:),G2H4(216),ngPln,m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_QA_W(ntryL,G2H8(536),ex2(:),G2H4(217),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_QA_W(ntryL,G2H8(537),ex2(:),G2H4(218),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_QA_W(ntryL,G2H8(541),ex2(:),G2H4(219),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_QA_W(ntryL,G2H8(542),ex2(:),G2H4(220),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_AQ_S(ntryL,G2H8(546),ex1(:),G2H4(221),ngPnl,m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_AQ_S(ntryL,G2H8(547),ex1(:),G2H4(222),ngPnl,m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_AQ_S(ntryL,G2H8(550),ex1(:),G2H4(223),ngPnl,m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_AQ_S(ntryL,G2H8(551),ex1(:),G2H4(224),ngPnl,m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_AQ_W(ntryL,G2H8(555),ex1(:),G2H4(225),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_AQ_W(ntryL,G2H8(556),ex1(:),G2H4(226),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_AQ_S(ntryL,G2H8(559),ex1(:),G2H4(227),ngPnl,m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_AQ_S(ntryL,G2H8(560),ex1(:),G2H4(228),ngPnl,m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_AQ_W(ntryL,G2H8(563),ex1(:),G2H4(229),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_AQ_W(ntryL,G2H8(564),ex1(:),G2H4(230),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_AQ_S(ntryL,G2H8(568),ex1(:),G2H4(231),ngPnl,m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_AQ_S(ntryL,G2H8(569),ex1(:),G2H4(232),ngPnl,m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_AQ_W(ntryL,G2H8(572),ex1(:),G2H4(233),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_AQ_W(ntryL,G2H8(573),ex1(:),G2H4(234),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_AQ_W(ntryL,G2H8(577),ex1(:),G2H4(235),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_AQ_W(ntryL,G2H8(578),ex1(:),G2H4(236),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_AQ_S(ntryL,G2H8(579),ex1(:),G2H4(237),ngH,m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_AQ_S(ntryL,G2H8(582),ex1(:),G2H4(238),ngH,m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_AQ_S(ntryL,G2H8(583),ex1(:),G2H4(239),ngH,m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_AQ_S(ntryL,G2H8(584),ex1(:),G2H4(240),ngX,m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_AQ_S(ntryL,G2H8(587),ex1(:),G2H4(241),ngX,m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_AQ_S(ntryL,G2H8(588),ex1(:),G2H4(242),ngX,m3h2x4(:,242),heltab2x8(:,:,242))
  call Hotf_5pt_reduction(G2H8(592),RedSet_5(19),mass5set(:,1),  & 
G1H8(1309),G1H8(1310),G1H8(1311),G1H8(1312),G1H8(1313),G1H8(1314),8)
  call HG1shiftOLR(G1H8(1310),16,8)
  call Hotf_5pt_reduction(G2H8(593),RedSet_5(20),mass5set(:,13),  & 
G1H8(1315),G1H8(1316),G1H8(1317),G1H8(1318),G1H8(1319),G1H8(1320),8)
  call HG1shiftOLR(G1H8(1316),16,8)
  call Hloop_AQ_V(ntryL,G2H8(594),ex1(:),G2H4(243),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_AQ_V(ntryL,G2H8(597),ex1(:),G2H4(244),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_AQ_V(ntryL,G2H8(598),ex1(:),G2H4(245),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_AQ_Z(ntryL,G2H8(599),ex1(:),G2H4(246),ngZl,m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_AQ_Z(ntryL,G2H8(602),ex1(:),G2H4(247),ngZl,m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_AQ_Z(ntryL,G2H8(603),ex1(:),G2H4(248),ngZl,m3h2x4(:,248),heltab2x8(:,:,248))
  call Hotf_5pt_reduction(G2H8(606),RedSet_5(19),mass5set(:,1),  & 
G1H8(1321),G1H8(1322),G1H8(1323),G1H8(1324),G1H8(1325),G1H8(1326),8)
  call HG1shiftOLR(G1H8(1322),16,8)
  call Hotf_5pt_reduction(G2H8(607),RedSet_5(20),mass5set(:,13),  & 
G1H8(1327),G1H8(1328),G1H8(1329),G1H8(1330),G1H8(1331),G1H8(1332),8)
  call HG1shiftOLR(G1H8(1328),16,8)
  call Hotf_5pt_reduction(G2H8(610),RedSet_5(19),mass5set(:,1),  & 
G1H8(1333),G1H8(1334),G1H8(1335),G1H8(1336),G1H8(1337),G1H8(1338),8)
  call HG1shiftOLR(G1H8(1334),16,8)
  call Hotf_5pt_reduction(G2H8(611),RedSet_5(20),mass5set(:,13),  & 
G1H8(1339),G1H8(1340),G1H8(1341),G1H8(1342),G1H8(1343),G1H8(1344),8)
  call HG1shiftOLR(G1H8(1340),16,8)
  call Hotf_5pt_reduction(G2H8(615),RedSet_5(19),mass5set(:,1),  & 
G1H8(1345),G1H8(1346),G1H8(1347),G1H8(1348),G1H8(1349),G1H8(1350),8)
  call HG1shiftOLR(G1H8(1346),16,8)
  call Hotf_5pt_reduction(G2H8(616),RedSet_5(20),mass5set(:,13),  & 
G1H8(1351),G1H8(1352),G1H8(1353),G1H8(1354),G1H8(1355),G1H8(1356),8)
  call HG1shiftOLR(G1H8(1352),16,8)
  call Hloop_QA_S(ntryL,G2H8(617),ex2(:),G2H4(249),ngH,m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_QA_S(ntryL,G2H8(620),ex2(:),G2H4(250),ngH,m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_QA_S(ntryL,G2H8(621),ex2(:),G2H4(251),ngH,m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_QA_S(ntryL,G2H8(622),ex2(:),G2H4(252),ngX,m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_QA_S(ntryL,G2H8(625),ex2(:),G2H4(253),ngX,m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_QA_S(ntryL,G2H8(626),ex2(:),G2H4(254),ngX,m3h2x4(:,254),heltab2x8(:,:,254))
  call Hotf_5pt_reduction(G2H8(630),RedSet_5(21),mass5set(:,1),  & 
G1H8(1357),G1H8(1358),G1H8(1359),G1H8(1360),G1H8(1361),G1H8(1362),8)
  call HG1shiftOLR(G1H8(1358),8,8)
  call Hotf_5pt_reduction(G2H8(631),RedSet_5(22),mass5set(:,13),  & 
G1H8(1363),G1H8(1364),G1H8(1365),G1H8(1366),G1H8(1367),G1H8(1368),8)
  call HG1shiftOLR(G1H8(1364),8,8)
  call Hloop_QA_V(ntryL,G2H8(632),ex2(:),G2H4(255),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_QA_V(ntryL,G2H8(635),ex2(:),G2H4(256),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_QA_V(ntryL,G2H8(636),ex2(:),G2H4(257),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_QA_Z(ntryL,G2H8(637),ex2(:),G2H4(258),ngZl,m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_QA_Z(ntryL,G2H8(640),ex2(:),G2H4(259),ngZl,m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_QA_Z(ntryL,G2H8(641),ex2(:),G2H4(260),ngZl,m3h2x4(:,260),heltab2x8(:,:,260))
  call Hotf_5pt_reduction(G2H8(644),RedSet_5(21),mass5set(:,1),  & 
G1H8(1369),G1H8(1370),G1H8(1371),G1H8(1372),G1H8(1373),G1H8(1374),8)
  call HG1shiftOLR(G1H8(1370),8,8)
  call Hotf_5pt_reduction(G2H8(645),RedSet_5(22),mass5set(:,13),  & 
G1H8(1375),G1H8(1376),G1H8(1377),G1H8(1378),G1H8(1379),G1H8(1380),8)
  call HG1shiftOLR(G1H8(1376),8,8)
  call Hotf_5pt_reduction(G2H8(648),RedSet_5(21),mass5set(:,1),  & 
G1H8(1381),G1H8(1382),G1H8(1383),G1H8(1384),G1H8(1385),G1H8(1386),8)
  call HG1shiftOLR(G1H8(1382),8,8)
  call Hotf_5pt_reduction(G2H8(649),RedSet_5(22),mass5set(:,13),  & 
G1H8(1387),G1H8(1388),G1H8(1389),G1H8(1390),G1H8(1391),G1H8(1392),8)
  call HG1shiftOLR(G1H8(1388),8,8)
  call Hotf_5pt_reduction(G2H8(653),RedSet_5(21),mass5set(:,1),  & 
G1H8(1393),G1H8(1394),G1H8(1395),G1H8(1396),G1H8(1397),G1H8(1398),8)
  call HG1shiftOLR(G1H8(1394),8,8)
  call Hotf_5pt_reduction(G2H8(654),RedSet_5(22),mass5set(:,13),  & 
G1H8(1399),G1H8(1400),G1H8(1401),G1H8(1402),G1H8(1403),G1H8(1404),8)
  call HG1shiftOLR(G1H8(1400),8,8)
  call Hloop_QA_S(ntryL,G2H8(655),ex2(:),G2H4(261),ngH,m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_QA_S(ntryL,G2H8(658),ex2(:),G2H4(262),ngH,m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_QA_S(ntryL,G2H8(659),ex2(:),G2H4(263),ngH,m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_QA_S(ntryL,G2H8(660),ex2(:),G2H4(264),ngX,m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_QA_S(ntryL,G2H8(663),ex2(:),G2H4(265),ngX,m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_QA_S(ntryL,G2H8(664),ex2(:),G2H4(266),ngX,m3h2x4(:,266),heltab2x8(:,:,266))
  call Hotf_5pt_reduction(G2H8(668),RedSet_5(23),mass5set(:,1),  & 
G1H8(1405),G1H8(1406),G1H8(1407),G1H8(1408),G1H8(1409),G1H8(1410),8)
  call HG1shiftOLR(G1H8(1406),16,8)
  call Hotf_5pt_reduction(G2H8(669),RedSet_5(18),mass5set(:,13),  & 
G1H8(1411),G1H8(1412),G1H8(1413),G1H8(1414),G1H8(1415),G1H8(1416),8)
  call HG1shiftOLR(G1H8(1412),16,8)
  call Hloop_QA_V(ntryL,G2H8(670),ex2(:),G2H4(267),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_QA_V(ntryL,G2H8(673),ex2(:),G2H4(268),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_QA_V(ntryL,G2H8(674),ex2(:),G2H4(269),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_QA_Z(ntryL,G2H8(675),ex2(:),G2H4(270),ngZl,m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_QA_Z(ntryL,G2H8(678),ex2(:),G2H4(271),ngZl,m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_QA_Z(ntryL,G2H8(679),ex2(:),G2H4(272),ngZl,m3h2x4(:,272),heltab2x8(:,:,272))
  call Hotf_5pt_reduction(G2H8(682),RedSet_5(23),mass5set(:,1),  & 
G1H8(1417),G1H8(1418),G1H8(1419),G1H8(1420),G1H8(1421),G1H8(1422),8)
  call HG1shiftOLR(G1H8(1418),16,8)
  call Hotf_5pt_reduction(G2H8(683),RedSet_5(18),mass5set(:,13),  & 
G1H8(1423),G1H8(1424),G1H8(1425),G1H8(1426),G1H8(1427),G1H8(1428),8)
  call HG1shiftOLR(G1H8(1424),16,8)
  call Hotf_5pt_reduction(G2H8(686),RedSet_5(23),mass5set(:,1),  & 
G1H8(1429),G1H8(1430),G1H8(1431),G1H8(1432),G1H8(1433),G1H8(1434),8)
  call HG1shiftOLR(G1H8(1430),16,8)
  call Hotf_5pt_reduction(G2H8(687),RedSet_5(18),mass5set(:,13),  & 
G1H8(1435),G1H8(1436),G1H8(1437),G1H8(1438),G1H8(1439),G1H8(1440),8)
  call HG1shiftOLR(G1H8(1436),16,8)
  call Hotf_5pt_reduction(G2H8(691),RedSet_5(23),mass5set(:,1),  & 
G1H8(1441),G1H8(1442),G1H8(1443),G1H8(1444),G1H8(1445),G1H8(1446),8)
  call HG1shiftOLR(G1H8(1442),16,8)
  call Hotf_5pt_reduction(G2H8(692),RedSet_5(18),mass5set(:,13),  & 
G1H8(1447),G1H8(1448),G1H8(1449),G1H8(1450),G1H8(1451),G1H8(1452),8)
  call HG1shiftOLR(G1H8(1448),16,8)
  call Hloop_AQ_S(ntryL,G2H8(696),ex1(:),G2H4(273),ngPnl,m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_AQ_S(ntryL,G2H8(697),ex1(:),G2H4(274),ngPnl,m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_AQ_S(ntryL,G2H8(700),ex1(:),G2H4(275),ngPnl,m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_AQ_S(ntryL,G2H8(701),ex1(:),G2H4(276),ngPnl,m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_AQ_W(ntryL,G2H8(705),ex1(:),G2H4(277),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_AQ_W(ntryL,G2H8(706),ex1(:),G2H4(278),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_AQ_S(ntryL,G2H8(709),ex1(:),G2H4(279),ngPnl,m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_AQ_S(ntryL,G2H8(710),ex1(:),G2H4(280),ngPnl,m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_AQ_W(ntryL,G2H8(713),ex1(:),G2H4(281),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_AQ_W(ntryL,G2H8(714),ex1(:),G2H4(282),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_AQ_S(ntryL,G2H8(718),ex1(:),G2H4(283),ngPnl,m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_AQ_S(ntryL,G2H8(719),ex1(:),G2H4(284),ngPnl,m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_AQ_W(ntryL,G2H8(722),ex1(:),G2H4(285),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_AQ_W(ntryL,G2H8(723),ex1(:),G2H4(286),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_AQ_W(ntryL,G2H8(727),ex1(:),G2H4(287),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_AQ_W(ntryL,G2H8(728),ex1(:),G2H4(288),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_QA_S(ntryL,G2H8(729),ex2(:),G2H4(289),ngH,m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_QA_S(ntryL,G2H8(732),ex2(:),G2H4(290),ngH,m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_QA_S(ntryL,G2H8(733),ex2(:),G2H4(291),ngH,m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_QA_S(ntryL,G2H8(734),ex2(:),G2H4(292),ngX,m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_QA_S(ntryL,G2H8(737),ex2(:),G2H4(293),ngX,m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_QA_S(ntryL,G2H8(738),ex2(:),G2H4(294),ngX,m3h2x4(:,294),heltab2x8(:,:,294))
  call Hotf_5pt_reduction(G2H8(742),RedSet_5(24),mass5set(:,1),  & 
G1H8(1453),G1H8(1454),G1H8(1455),G1H8(1456),G1H8(1457),G1H8(1458),8)
  call HG1shiftOLR(G1H8(1454),16,8)
  call Hotf_5pt_reduction(G2H8(743),RedSet_5(20),mass5set(:,13),  & 
G1H8(1459),G1H8(1460),G1H8(1461),G1H8(1462),G1H8(1463),G1H8(1464),8)
  call HG1shiftOLR(G1H8(1460),16,8)
  call Hloop_QA_V(ntryL,G2H8(744),ex2(:),G2H4(295),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_QA_V(ntryL,G2H8(747),ex2(:),G2H4(296),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_QA_V(ntryL,G2H8(748),ex2(:),G2H4(297),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_QA_Z(ntryL,G2H8(749),ex2(:),G2H4(298),ngZl,m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_QA_Z(ntryL,G2H8(752),ex2(:),G2H4(299),ngZl,m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_QA_Z(ntryL,G2H8(753),ex2(:),G2H4(300),ngZl,m3h2x4(:,300),heltab2x8(:,:,300))
  call Hotf_5pt_reduction(G2H8(756),RedSet_5(24),mass5set(:,1),  & 
G1H8(1465),G1H8(1466),G1H8(1467),G1H8(1468),G1H8(1469),G1H8(1470),8)
  call HG1shiftOLR(G1H8(1466),16,8)
  call Hotf_5pt_reduction(G2H8(757),RedSet_5(20),mass5set(:,13),  & 
G1H8(1471),G1H8(1472),G1H8(1473),G1H8(1474),G1H8(1475),G1H8(1476),8)
  call HG1shiftOLR(G1H8(1472),16,8)
  call Hotf_5pt_reduction(G2H8(760),RedSet_5(24),mass5set(:,1),  & 
G1H8(1477),G1H8(1478),G1H8(1479),G1H8(1480),G1H8(1481),G1H8(1482),8)
  call HG1shiftOLR(G1H8(1478),16,8)
  call Hotf_5pt_reduction(G2H8(761),RedSet_5(20),mass5set(:,13),  & 
G1H8(1483),G1H8(1484),G1H8(1485),G1H8(1486),G1H8(1487),G1H8(1488),8)
  call HG1shiftOLR(G1H8(1484),16,8)
  call Hotf_5pt_reduction(G2H8(765),RedSet_5(24),mass5set(:,1),  & 
G1H8(1489),G1H8(1490),G1H8(1491),G1H8(1492),G1H8(1493),G1H8(1494),8)
  call HG1shiftOLR(G1H8(1490),16,8)
  call Hotf_5pt_reduction(G2H8(766),RedSet_5(20),mass5set(:,13),  & 
G1H8(1495),G1H8(1496),G1H8(1497),G1H8(1498),G1H8(1499),G1H8(1500),8)
  call HG1shiftOLR(G1H8(1496),16,8)
  call Hloop_AQ_S(ntryL,G2H8(767),ex1(:),G2H4(301),ngH,m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_AQ_S(ntryL,G2H8(770),ex1(:),G2H4(302),ngH,m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_AQ_S(ntryL,G2H8(771),ex1(:),G2H4(303),ngH,m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_AQ_S(ntryL,G2H8(772),ex1(:),G2H4(304),ngX,m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_AQ_S(ntryL,G2H8(775),ex1(:),G2H4(305),ngX,m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_AQ_S(ntryL,G2H8(776),ex1(:),G2H4(306),ngX,m3h2x4(:,306),heltab2x8(:,:,306))
  call Hotf_5pt_reduction(G2H8(780),RedSet_5(25),mass5set(:,1),  & 
G1H8(1501),G1H8(1502),G1H8(1503),G1H8(1504),G1H8(1505),G1H8(1506),8)
  call HG1shiftOLR(G1H8(1502),8,8)
  call Hotf_5pt_reduction(G2H8(781),RedSet_5(22),mass5set(:,13),  & 
G1H8(1507),G1H8(1508),G1H8(1509),G1H8(1510),G1H8(1511),G1H8(1512),8)
  call HG1shiftOLR(G1H8(1508),8,8)
  call Hloop_AQ_V(ntryL,G2H8(782),ex1(:),G2H4(307),m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_AQ_V(ntryL,G2H8(785),ex1(:),G2H4(308),m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_AQ_V(ntryL,G2H8(786),ex1(:),G2H4(309),m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_AQ_Z(ntryL,G2H8(787),ex1(:),G2H4(310),ngZl,m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_AQ_Z(ntryL,G2H8(790),ex1(:),G2H4(311),ngZl,m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_AQ_Z(ntryL,G2H8(791),ex1(:),G2H4(312),ngZl,m3h2x4(:,312),heltab2x8(:,:,312))
  call Hotf_5pt_reduction(G2H8(794),RedSet_5(25),mass5set(:,1),  & 
G1H8(1513),G1H8(1514),G1H8(1515),G1H8(1516),G1H8(1517),G1H8(1518),8)
  call HG1shiftOLR(G1H8(1514),8,8)
  call Hotf_5pt_reduction(G2H8(795),RedSet_5(22),mass5set(:,13),  & 
G1H8(1519),G1H8(1520),G1H8(1521),G1H8(1522),G1H8(1523),G1H8(1524),8)
  call HG1shiftOLR(G1H8(1520),8,8)
  call Hotf_5pt_reduction(G2H8(798),RedSet_5(25),mass5set(:,1),  & 
G1H8(1525),G1H8(1526),G1H8(1527),G1H8(1528),G1H8(1529),G1H8(1530),8)
  call HG1shiftOLR(G1H8(1526),8,8)
  call Hotf_5pt_reduction(G2H8(799),RedSet_5(22),mass5set(:,13),  & 
G1H8(1531),G1H8(1532),G1H8(1533),G1H8(1534),G1H8(1535),G1H8(1536),8)
  call HG1shiftOLR(G1H8(1532),8,8)
  call Hotf_5pt_reduction(G2H8(803),RedSet_5(25),mass5set(:,1),  & 
G1H8(1537),G1H8(1538),G1H8(1539),G1H8(1540),G1H8(1541),G1H8(1542),8)
  call HG1shiftOLR(G1H8(1538),8,8)
  call Hotf_5pt_reduction(G2H8(804),RedSet_5(22),mass5set(:,13),  & 
G1H8(1543),G1H8(1544),G1H8(1545),G1H8(1546),G1H8(1547),G1H8(1548),8)
  call HG1shiftOLR(G1H8(1544),8,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1261),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1267),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1273),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1279),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1285),[G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1291),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1297),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1303),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1309),[G1H8(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1315),[G1H8(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1321),[G1H8(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1327),[G1H8(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1333),[G1H8(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1339),[G1H8(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1345),[G1H8(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1351),[G1H8(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1357),[G1H8(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1363),[G1H8(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1381),[G1H8(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1387),[G1H8(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1369),[G1H8(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1375),[G1H8(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1393),[G1H8(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1399),[G1H8(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1405),[G1H8(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1411),[G1H8(576)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1429),[G1H8(587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1435),[G1H8(588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1417),[G1H8(599)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1423),[G1H8(600)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1441),[G1H8(611)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1447),[G1H8(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1453),[G1H8(647)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1459),[G1H8(648)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1477),[G1H8(659)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1483),[G1H8(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1465),[G1H8(671)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1471),[G1H8(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1489),[G1H8(683)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1495),[G1H8(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1501),[G1H8(695)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1507),[G1H8(696)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1513),[G1H8(713)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1519),[G1H8(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1525),[G1H8(719)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1531),[G1H8(720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1537),[G1H8(731)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1543),[G1H8(732)])
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(313),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,nME,G2H8(5),n2h8(385))
  call Hloop_AV_Q(ntryL,G2H8(5),ex5(:),G2H4(314),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_SQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngH,m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(315),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngH,m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(316),n2h4(3))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngX,m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(317),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nME,G2H8(6),n2h8(386))
  call Hloop_AV_Q(ntryL,G2H8(6),ex5(:),G2H4(318),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_SQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),ngX,m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(319),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),ngX,m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(320),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(321),n2h4(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-16,nME,G2H8(7),n2h8(387))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(322),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(323),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(324),n2h4(9))
  call Hloop_ZQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),ngZl,m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(325),n2h4(10))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,nME,G2H8(8),n2h8(388))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(326),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_ZQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),ngZl,m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(327),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),ngZl,m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_Q_A(ntryL,G1H4(1),43,nME,G2H4(328),n2h4(12))
  call Hloop_SA_Q(ntryL,G1H8(61),ex2(:),G1H4(1),ngH,m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(329),n2h4(13))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(62),-16,nME,G2H8(9),n2h8(389))
  call Hloop_QV_A(ntryL,G2H8(9),ex5(:),G2H4(330),m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_SA_Q(ntryL,G1H8(65),ex2(:),G1H4(1),ngH,m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(331),n2h4(14))
  call Hloop_SA_Q(ntryL,G1H8(66),ex2(:),G1H4(1),ngH,m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(332),n2h4(15))
  call Hloop_SA_Q(ntryL,G1H8(67),ex2(:),G1H4(1),ngX,m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(333),n2h4(16))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-16,nME,G2H8(10),n2h8(390))
  call Hloop_QV_A(ntryL,G2H8(10),ex5(:),G2H4(334),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_SA_Q(ntryL,G1H8(71),ex2(:),G1H4(1),ngX,m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(335),n2h4(17))
  call Hloop_SA_Q(ntryL,G1H8(72),ex2(:),G1H4(1),ngX,m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(336),n2h4(18))
  call Hloop_VA_Q(ntryL,G1H8(73),ex2(:),G1H4(1),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(337),n2h4(19))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-16,nME,G2H8(11),n2h8(391))
  call Hloop_QV_A(ntryL,G2H8(11),ex5(:),G2H4(338),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_VA_Q(ntryL,G1H8(77),ex2(:),G1H4(1),m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(339),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(78),ex2(:),G1H4(1),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(340),n2h4(21))
  call Hloop_ZA_Q(ntryL,G1H8(79),ex2(:),G1H4(1),ngZl,m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(341),n2h4(22))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(80),-16,nME,G2H8(12),n2h8(392))
  call Hloop_QV_A(ntryL,G2H8(12),ex5(:),G2H4(342),m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_ZA_Q(ntryL,G1H8(83),ex2(:),G1H4(1),ngZl,m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(343),n2h4(23))
  call Hloop_ZA_Q(ntryL,G1H8(84),ex2(:),G1H4(1),ngZl,m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_A_Q(ntryL,G1H4(1),39,nME,G2H4(344),n2h4(24))
  call Hloop_SQ_A(ntryL,G1H8(85),ex1(:),G1H4(1),ngPnl,m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(345),n2h4(25))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(86),ex5(:),G1H4(1),m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_SQ_A(ntryL,G1H8(89),ex1(:),G1H4(2),ngPnl,m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(346),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H8(90),ex1(:),G1H4(2),ngPnl,m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(347),n2h4(27))
  call Hloop_SQ_A(ntryL,G1H8(91),ex1(:),G1H4(2),ngPnl,m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(348),n2h4(28))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(92),-16,ex5(:),16,G2H4(349),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_SQ_A(ntryL,G1H8(1261),ex1(:),G1H4(2),ngPnl,m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(350),n2h4(29))
  call Hloop_SQ_A(ntryL,G1H8(1267),ex1(:),G1H4(2),ngPnl,m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(351),n2h4(30))
  call Hloop_WQ_A(ntryL,G1H8(97),ex1(:),G1H4(2),m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(352),n2h4(31))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(98),-16,ex5(:),16,G2H4(353),m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_WQ_A(ntryL,G1H8(101),ex1(:),G1H4(2),m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(354),n2h4(32))
  call Hloop_WQ_A(ntryL,G1H8(102),ex1(:),G1H4(2),m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(355),n2h4(33))
  call Hloop_SQ_A(ntryL,G1H8(103),ex1(:),G1H4(2),ngPnl,m3h2x4(:,357),heltab2x8(:,:,357))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(356),n2h4(34))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(104),-16,ex5(:),16,G2H4(357),m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_SQ_A(ntryL,G1H8(107),ex1(:),G1H4(2),ngPnl,m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(358),n2h4(35))
  call Hloop_SQ_A(ntryL,G1H8(108),ex1(:),G1H4(2),ngPnl,m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(359),n2h4(36))
  call Hloop_SQ_A(ntryL,G1H8(109),ex1(:),G1H4(2),ngPnl,m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(2),45,0,G2H4(360),n2h4(37))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(110),ex5(:),G1H4(2),m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_SQ_A(ntryL,G1H8(1273),ex1(:),G1H4(3),ngPnl,m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_Q_A(ntryL,G1H4(3),45,0,G2H4(361),n2h4(38))
  call Hloop_SQ_A(ntryL,G1H8(1279),ex1(:),G1H4(3),ngPnl,m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G1H4(3),45,0,G2H4(362),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(115),ex1(:),G1H4(3),m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_Q_A(ntryL,G1H4(3),45,0,G2H4(363),n2h4(40))
call HGT_raise_alpha_OLR(G1H8(116),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(116),ex5(:),G1H4(3),m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_WQ_A(ntryL,G1H8(1285),ex1(:),G1H4(4),m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(364),n2h4(41))
  call Hloop_WQ_A(ntryL,G1H8(1291),ex1(:),G1H4(4),m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(365),n2h4(42))
  call Hloop_WQ_A(ntryL,G1H8(121),ex1(:),G1H4(4),m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(366),n2h4(43))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(122),ex5(:),G1H4(4),m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_WQ_A(ntryL,G1H8(125),ex1(:),G1H4(5),m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(367),n2h4(44))
  call Hloop_WQ_A(ntryL,G1H8(126),ex1(:),G1H4(5),m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(368),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(127),ex1(:),G1H4(5),m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(369),n2h4(46))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(128),-16,ex5(:),16,G2H4(370),m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_WQ_A(ntryL,G1H8(1297),ex1(:),G1H4(5),m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(371),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(1303),ex1(:),G1H4(5),m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(5),45,0,G2H4(372),n2h4(48))
  call Hloop_SA_Q(ntryL,G1H8(133),ex2(:),G1H4(5),ngH,m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(373),n2h4(49))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(134),-8,nME,G2H8(17),n2h8(401))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(374),m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_SA_Q(ntryL,G1H8(137),ex2(:),G1H4(5),ngH,m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(375),n2h4(50))
  call Hloop_SA_Q(ntryL,G1H8(138),ex2(:),G1H4(5),ngH,m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(376),n2h4(51))
  call Hloop_SA_Q(ntryL,G1H8(139),ex2(:),G1H4(5),ngX,m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(377),n2h4(52))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-8,nME,G2H8(18),n2h8(402))
  call Hloop_QV_A(ntryL,G2H8(18),ex4(:),G2H4(378),m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_SA_Q(ntryL,G1H8(143),ex2(:),G1H4(5),ngX,m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(379),n2h4(53))
  call Hloop_SA_Q(ntryL,G1H8(144),ex2(:),G1H4(5),ngX,m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(380),n2h4(54))
  call Hloop_VA_Q(ntryL,G1H8(145),ex2(:),G1H4(5),m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(381),n2h4(55))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(146),-8,nME,G2H8(19),n2h8(403))
  call Hloop_QV_A(ntryL,G2H8(19),ex4(:),G2H4(382),m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_VA_Q(ntryL,G1H8(149),ex2(:),G1H4(5),m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(383),n2h4(56))
  call Hloop_VA_Q(ntryL,G1H8(150),ex2(:),G1H4(5),m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(384),n2h4(57))
  call Hloop_ZA_Q(ntryL,G1H8(151),ex2(:),G1H4(5),ngZl,m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(385),n2h4(58))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(152),-8,nME,G2H8(20),n2h8(404))
  call Hloop_QV_A(ntryL,G2H8(20),ex4(:),G2H4(386),m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_ZA_Q(ntryL,G1H8(155),ex2(:),G1H4(5),ngZl,m3h2x4(:,391),heltab2x8(:,:,391))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(387),n2h4(59))
  call Hloop_ZA_Q(ntryL,G1H8(156),ex2(:),G1H4(5),ngZl,m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_A_Q(ntryL,G1H4(5),39,nME,G2H4(388),n2h4(60))
  call Hloop_QV_A(ntryL,G1H8(157),ex3(:),G1H4(5),m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(389),n2h4(61))
call HGT_OLR(G1H8(158),1,1,8)
call HGT_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(158),-16,nME,G2H8(21),n2h8(405))
  call Hloop_AV_Q(ntryL,G2H8(21),ex5(:),G2H4(390),m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_QV_A(ntryL,G1H8(161),ex3(:),G1H4(5),m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(391),n2h4(62))
  call Hloop_QV_A(ntryL,G1H8(162),ex3(:),G1H4(5),m3h2x4(:,396),heltab2x8(:,:,396))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(392),n2h4(63))
  call Hloop_QV_A(ntryL,G1H8(163),ex3(:),G1H4(5),m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(393),n2h4(64))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(164),-16,nME,G2H8(22),n2h8(406))
  call Hloop_AV_Q(ntryL,G2H8(22),ex5(:),G2H4(394),m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_QV_A(ntryL,G1H8(167),ex3(:),G1H4(5),m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(395),n2h4(65))
  call Hloop_QV_A(ntryL,G1H8(168),ex3(:),G1H4(5),m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(396),n2h4(66))
  call Hloop_TV_S(ntryL,G1H8(169),35,ex3(:),4,G2H4(397),m3h2x4(:,401),heltab2x8(:,:,401))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(170),-16,ex5(:),16,G2H4(398),m3h2x4(:,402),heltab2x8(:,:,402))
  call Hloop_TV_S(ntryL,G1H8(173),35,ex3(:),4,G2H4(399),m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_TV_S(ntryL,G1H8(174),35,ex3(:),4,G2H4(400),m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_QV_A(ntryL,G1H8(175),ex3(:),G1H4(5),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(401),n2h4(67))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(176),-16,nME,G2H8(23),n2h8(408))
  call Hloop_AV_Q(ntryL,G2H8(23),ex5(:),G2H4(402),m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_QV_A(ntryL,G1H8(179),ex3(:),G1H4(5),m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(403),n2h4(68))
  call Hloop_QV_A(ntryL,G1H8(180),ex3(:),G1H4(5),m3h2x4(:,408),heltab2x8(:,:,408))
  call Hloop_Q_A(ntryL,G1H4(5),39,nME,G2H4(404),n2h4(69))
  call Hloop_TV_S(ntryL,G1H8(181),35,ex3(:),4,G2H4(405),m3h2x4(:,409),heltab2x8(:,:,409))
call HGT_raise_alpha_OLR(G1H8(182),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(182),ex5(:),G1H4(5),m3h2x4(:,410),heltab2x8(:,:,410))
  call Hloop_TV_S(ntryL,G1H8(185),35,ex3(:),4,G2H4(406),m3h2x4(:,411),heltab2x8(:,:,411))
  call Hloop_TV_S(ntryL,G1H8(186),35,ex3(:),4,G2H4(407),m3h2x4(:,412),heltab2x8(:,:,412))
  call Hloop_TV_S(ntryL,G1H8(187),35,ex3(:),4,G2H4(408),m3h2x4(:,413),heltab2x8(:,:,413))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(188),ex5(:),G1H4(6),m3h2x4(:,414),heltab2x8(:,:,414))
  call Hloop_TV_S(ntryL,G1H8(191),35,ex3(:),4,G2H4(409),m3h2x4(:,415),heltab2x8(:,:,415))
  call Hloop_TV_S(ntryL,G1H8(192),35,ex3(:),4,G2H4(410),m3h2x4(:,416),heltab2x8(:,:,416))
  call Hloop_TV_S(ntryL,G1H8(193),35,ex3(:),4,G2H4(411),m3h2x4(:,417),heltab2x8(:,:,417))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(194),-16,ex5(:),16,G2H4(412),m3h2x4(:,418),heltab2x8(:,:,418))
  call Hloop_TV_S(ntryL,G1H8(197),35,ex3(:),4,G2H4(413),m3h2x4(:,419),heltab2x8(:,:,419))
  call Hloop_TV_S(ntryL,G1H8(198),35,ex3(:),4,G2H4(414),m3h2x4(:,420),heltab2x8(:,:,420))
  call Hloop_UV_W(ntryL,G1H8(199),35,ex3(:),4,G2H4(415),m3h2x4(:,421),heltab2x8(:,:,421))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(200),-16,ex5(:),16,G2H4(416),m3h2x4(:,422),heltab2x8(:,:,422))
  call Hloop_UV_W(ntryL,G1H8(203),35,ex3(:),4,G2H4(417),m3h2x4(:,423),heltab2x8(:,:,423))
  call Hloop_UV_W(ntryL,G1H8(204),35,ex3(:),4,G2H4(418),m3h2x4(:,424),heltab2x8(:,:,424))
  call Hloop_UV_W(ntryL,G1H8(205),35,ex3(:),4,G2H4(419),m3h2x4(:,425),heltab2x8(:,:,425))
call HGT_raise_alpha_OLR(G1H8(206),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(206),ex5(:),G1H4(7),m3h2x4(:,426),heltab2x8(:,:,426))
  call Hloop_UV_W(ntryL,G1H8(209),35,ex3(:),4,G2H4(420),m3h2x4(:,427),heltab2x8(:,:,427))
  call Hloop_UV_W(ntryL,G1H8(210),35,ex3(:),4,G2H4(421),m3h2x4(:,428),heltab2x8(:,:,428))
  call Hloop_UV_W(ntryL,G1H8(211),35,ex3(:),4,G2H4(422),m3h2x4(:,429),heltab2x8(:,:,429))
call HGT_OLR(G1H8(212),1,1,8)
call HGT_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(212),ex5(:),G1H4(8),m3h2x4(:,430),heltab2x8(:,:,430))
  call Hloop_UV_W(ntryL,G1H8(215),35,ex3(:),4,G2H4(423),m3h2x4(:,431),heltab2x8(:,:,431))
  call Hloop_UV_W(ntryL,G1H8(216),35,ex3(:),4,G2H4(424),m3h2x4(:,432),heltab2x8(:,:,432))
  call Hloop_UV_W(ntryL,G1H8(217),35,ex3(:),4,G2H4(425),m3h2x4(:,433),heltab2x8(:,:,433))
call HGT_raise_alpha_OLR(G1H8(218),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(218),-16,ex5(:),16,G2H4(426),m3h2x4(:,434),heltab2x8(:,:,434))
  call Hloop_UV_W(ntryL,G1H8(221),35,ex3(:),4,G2H4(427),m3h2x4(:,435),heltab2x8(:,:,435))
  call Hloop_UV_W(ntryL,G1H8(222),35,ex3(:),4,G2H4(428),m3h2x4(:,436),heltab2x8(:,:,436))
  call Hloop_QV_A(ntryL,G1H8(223),ex3(:),G1H4(9),m3h2x4(:,437),heltab2x8(:,:,437))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(429),n2h4(70))
call HGT_OLR(G1H8(224),1,1,8)
call HGT_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(224),-8,nME,G2H8(24),n2h8(416))
  call Hloop_AV_Q(ntryL,G2H8(24),ex4(:),G2H4(430),m3h2x4(:,438),heltab2x8(:,:,438))
  call Hloop_QV_A(ntryL,G1H8(227),ex3(:),G1H4(9),m3h2x4(:,439),heltab2x8(:,:,439))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(431),n2h4(71))
  call Hloop_QV_A(ntryL,G1H8(228),ex3(:),G1H4(9),m3h2x4(:,440),heltab2x8(:,:,440))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(432),n2h4(72))
  call Hloop_QV_A(ntryL,G1H8(229),ex3(:),G1H4(9),m3h2x4(:,441),heltab2x8(:,:,441))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(433),n2h4(73))
call HGT_OLR(G1H8(230),1,1,8)
call HGT_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(230),-8,nME,G2H8(25),n2h8(417))
  call Hloop_AV_Q(ntryL,G2H8(25),ex4(:),G2H4(434),m3h2x4(:,442),heltab2x8(:,:,442))
  call Hloop_QV_A(ntryL,G1H8(233),ex3(:),G1H4(9),m3h2x4(:,443),heltab2x8(:,:,443))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(435),n2h4(74))
  call Hloop_QV_A(ntryL,G1H8(234),ex3(:),G1H4(9),m3h2x4(:,444),heltab2x8(:,:,444))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(436),n2h4(75))
  call Hloop_TV_S(ntryL,G1H8(235),35,ex3(:),4,G2H4(437),m3h2x4(:,445),heltab2x8(:,:,445))
call HGT_OLR(G1H8(236),1,1,8)
call HGT_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(236),-8,ex4(:),8,G2H4(438),m3h2x4(:,446),heltab2x8(:,:,446))
  call Hloop_TV_S(ntryL,G1H8(239),35,ex3(:),4,G2H4(439),m3h2x4(:,447),heltab2x8(:,:,447))
  call Hloop_TV_S(ntryL,G1H8(240),35,ex3(:),4,G2H4(440),m3h2x4(:,448),heltab2x8(:,:,448))
  call Hloop_QV_A(ntryL,G1H8(241),ex3(:),G1H4(9),m3h2x4(:,449),heltab2x8(:,:,449))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(441),n2h4(76))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(242),-8,nME,G2H8(26),n2h8(419))
  call Hloop_AV_Q(ntryL,G2H8(26),ex4(:),G2H4(442),m3h2x4(:,450),heltab2x8(:,:,450))
  call Hloop_QV_A(ntryL,G1H8(245),ex3(:),G1H4(9),m3h2x4(:,451),heltab2x8(:,:,451))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(443),n2h4(77))
  call Hloop_QV_A(ntryL,G1H8(246),ex3(:),G1H4(9),m3h2x4(:,452),heltab2x8(:,:,452))
  call Hloop_Q_A(ntryL,G1H4(9),39,nME,G2H4(444),n2h4(78))
  call Hloop_TV_S(ntryL,G1H8(247),35,ex3(:),4,G2H4(445),m3h2x4(:,453),heltab2x8(:,:,453))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(248),ex4(:),G1H4(9),m3h2x4(:,454),heltab2x8(:,:,454))
  call Hloop_TV_S(ntryL,G1H8(251),35,ex3(:),4,G2H4(446),m3h2x4(:,455),heltab2x8(:,:,455))
  call Hloop_TV_S(ntryL,G1H8(252),35,ex3(:),4,G2H4(447),m3h2x4(:,456),heltab2x8(:,:,456))
  call Hloop_TV_S(ntryL,G1H8(253),35,ex3(:),4,G2H4(448),m3h2x4(:,457),heltab2x8(:,:,457))
call HGT_OLR(G1H8(254),1,1,8)
call HGT_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(254),ex4(:),G1H4(10),m3h2x4(:,458),heltab2x8(:,:,458))
  call Hloop_TV_S(ntryL,G1H8(257),35,ex3(:),4,G2H4(449),m3h2x4(:,459),heltab2x8(:,:,459))
  call Hloop_TV_S(ntryL,G1H8(258),35,ex3(:),4,G2H4(450),m3h2x4(:,460),heltab2x8(:,:,460))
  call Hloop_TV_S(ntryL,G1H8(259),35,ex3(:),4,G2H4(451),m3h2x4(:,461),heltab2x8(:,:,461))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(260),-8,ex4(:),8,G2H4(452),m3h2x4(:,462),heltab2x8(:,:,462))
  call Hloop_TV_S(ntryL,G1H8(263),35,ex3(:),4,G2H4(453),m3h2x4(:,463),heltab2x8(:,:,463))
  call Hloop_TV_S(ntryL,G1H8(264),35,ex3(:),4,G2H4(454),m3h2x4(:,464),heltab2x8(:,:,464))
  call Hloop_UV_W(ntryL,G1H8(265),35,ex3(:),4,G2H4(455),m3h2x4(:,465),heltab2x8(:,:,465))
call HGT_OLR(G1H8(266),1,1,8)
call HGT_invQ_OLR(G1H8(266),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(266),-8,ex4(:),8,G2H4(456),m3h2x4(:,466),heltab2x8(:,:,466))
  call Hloop_UV_W(ntryL,G1H8(269),35,ex3(:),4,G2H4(457),m3h2x4(:,467),heltab2x8(:,:,467))
  call Hloop_UV_W(ntryL,G1H8(270),35,ex3(:),4,G2H4(458),m3h2x4(:,468),heltab2x8(:,:,468))
  call Hloop_UV_W(ntryL,G1H8(271),35,ex3(:),4,G2H4(459),m3h2x4(:,469),heltab2x8(:,:,469))
call HGT_raise_alpha_OLR(G1H8(272),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(272),ex4(:),G1H4(11),m3h2x4(:,470),heltab2x8(:,:,470))
  call Hloop_UV_W(ntryL,G1H8(275),35,ex3(:),4,G2H4(460),m3h2x4(:,471),heltab2x8(:,:,471))
  call Hloop_UV_W(ntryL,G1H8(276),35,ex3(:),4,G2H4(461),m3h2x4(:,472),heltab2x8(:,:,472))
  call Hloop_UV_W(ntryL,G1H8(277),35,ex3(:),4,G2H4(462),m3h2x4(:,473),heltab2x8(:,:,473))
call HGT_OLR(G1H8(278),1,1,8)
call HGT_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(278),ex4(:),G1H4(12),m3h2x4(:,474),heltab2x8(:,:,474))
  call Hloop_UV_W(ntryL,G1H8(281),35,ex3(:),4,G2H4(463),m3h2x4(:,475),heltab2x8(:,:,475))
  call Hloop_UV_W(ntryL,G1H8(282),35,ex3(:),4,G2H4(464),m3h2x4(:,476),heltab2x8(:,:,476))
  call Hloop_UV_W(ntryL,G1H8(283),35,ex3(:),4,G2H4(465),m3h2x4(:,477),heltab2x8(:,:,477))
call HGT_raise_alpha_OLR(G1H8(284),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(284),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(284),-8,ex4(:),8,G2H4(466),m3h2x4(:,478),heltab2x8(:,:,478))
  call Hloop_UV_W(ntryL,G1H8(287),35,ex3(:),4,G2H4(467),m3h2x4(:,479),heltab2x8(:,:,479))
  call Hloop_UV_W(ntryL,G1H8(288),35,ex3(:),4,G2H4(468),m3h2x4(:,480),heltab2x8(:,:,480))
  call Hloop_SA_Q(ntryL,G1H8(289),ex2(:),G1H4(13),ngH,m3h2x4(:,481),heltab2x8(:,:,481))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(469),n2h4(79))
call HGT_OLR(G1H8(290),1,1,8)
call HGT_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(290),-16,nME,G2H8(28),n2h8(427))
  call Hloop_QV_A(ntryL,G2H8(28),ex5(:),G2H4(470),m3h2x4(:,482),heltab2x8(:,:,482))
  call Hloop_SA_Q(ntryL,G1H8(293),ex2(:),G1H4(13),ngH,m3h2x4(:,483),heltab2x8(:,:,483))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(471),n2h4(80))
  call Hloop_SA_Q(ntryL,G1H8(294),ex2(:),G1H4(13),ngH,m3h2x4(:,484),heltab2x8(:,:,484))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(472),n2h4(81))
  call Hloop_SA_Q(ntryL,G1H8(295),ex2(:),G1H4(13),ngX,m3h2x4(:,485),heltab2x8(:,:,485))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(473),n2h4(82))
call HGT_OLR(G1H8(296),1,1,8)
call HGT_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(296),-16,nME,G2H8(30),n2h8(428))
  call Hloop_QV_A(ntryL,G2H8(30),ex5(:),G2H4(474),m3h2x4(:,486),heltab2x8(:,:,486))
  call Hloop_SA_Q(ntryL,G1H8(299),ex2(:),G1H4(13),ngX,m3h2x4(:,487),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(475),n2h4(83))
  call Hloop_SA_Q(ntryL,G1H8(300),ex2(:),G1H4(13),ngX,m3h2x4(:,488),heltab2x8(:,:,488))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(476),n2h4(84))
  call Hloop_VA_Q(ntryL,G1H8(301),ex2(:),G1H4(13),m3h2x4(:,489),heltab2x8(:,:,489))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(477),n2h4(85))
call HGT_OLR(G1H8(302),1,1,8)
call HGT_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(302),-16,nME,G2H8(37),n2h8(429))
  call Hloop_QV_A(ntryL,G2H8(37),ex5(:),G2H4(478),m3h2x4(:,490),heltab2x8(:,:,490))
  call Hloop_VA_Q(ntryL,G1H8(305),ex2(:),G1H4(13),m3h2x4(:,491),heltab2x8(:,:,491))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(479),n2h4(86))
  call Hloop_VA_Q(ntryL,G1H8(306),ex2(:),G1H4(13),m3h2x4(:,492),heltab2x8(:,:,492))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(480),n2h4(87))
  call Hloop_ZA_Q(ntryL,G1H8(307),ex2(:),G1H4(13),ngZl,m3h2x4(:,493),heltab2x8(:,:,493))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(481),n2h4(88))
call HGT_OLR(G1H8(308),1,1,8)
call HGT_invQ_OLR(G1H8(308),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(308),-16,nME,G2H8(38),n2h8(430))
  call Hloop_QV_A(ntryL,G2H8(38),ex5(:),G2H4(482),m3h2x4(:,494),heltab2x8(:,:,494))
  call Hloop_ZA_Q(ntryL,G1H8(311),ex2(:),G1H4(13),ngZl,m3h2x4(:,495),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(483),n2h4(89))
  call Hloop_ZA_Q(ntryL,G1H8(312),ex2(:),G1H4(13),ngZl,m3h2x4(:,496),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G1H4(13),43,nME,G2H4(484),n2h4(90))
  call Hloop_SQ_A(ntryL,G1H8(313),ex1(:),G1H4(13),ngH,m3h2x4(:,497),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(485),n2h4(91))
call HGT_OLR(G1H8(314),1,1,8)
call HGT_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(314),-16,nME,G2H8(39),n2h8(431))
  call Hloop_AV_Q(ntryL,G2H8(39),ex5(:),G2H4(486),m3h2x4(:,498),heltab2x8(:,:,498))
  call Hloop_SQ_A(ntryL,G1H8(317),ex1(:),G1H4(13),ngH,m3h2x4(:,499),heltab2x8(:,:,499))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(487),n2h4(92))
  call Hloop_SQ_A(ntryL,G1H8(318),ex1(:),G1H4(13),ngH,m3h2x4(:,500),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(488),n2h4(93))
  call Hloop_SQ_A(ntryL,G1H8(319),ex1(:),G1H4(13),ngX,m3h2x4(:,501),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(489),n2h4(94))
call HGT_OLR(G1H8(320),1,1,8)
call HGT_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(320),-16,nME,G2H8(40),n2h8(432))
  call Hloop_AV_Q(ntryL,G2H8(40),ex5(:),G2H4(490),m3h2x4(:,502),heltab2x8(:,:,502))
  call Hloop_SQ_A(ntryL,G1H8(323),ex1(:),G1H4(13),ngX,m3h2x4(:,503),heltab2x8(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(491),n2h4(95))
  call Hloop_SQ_A(ntryL,G1H8(324),ex1(:),G1H4(13),ngX,m3h2x4(:,504),heltab2x8(:,:,504))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(492),n2h4(96))
  call Hloop_VQ_A(ntryL,G1H8(325),ex1(:),G1H4(13),m3h2x4(:,505),heltab2x8(:,:,505))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(493),n2h4(97))
call HGT_OLR(G1H8(326),1,1,8)
call HGT_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(326),-16,nME,G2H8(41),n2h8(433))
  call Hloop_AV_Q(ntryL,G2H8(41),ex5(:),G2H4(494),m3h2x4(:,506),heltab2x8(:,:,506))
  call Hloop_VQ_A(ntryL,G1H8(329),ex1(:),G1H4(13),m3h2x4(:,507),heltab2x8(:,:,507))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(495),n2h4(98))
  call Hloop_VQ_A(ntryL,G1H8(330),ex1(:),G1H4(13),m3h2x4(:,508),heltab2x8(:,:,508))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(496),n2h4(99))
  call Hloop_ZQ_A(ntryL,G1H8(331),ex1(:),G1H4(13),ngZl,m3h2x4(:,509),heltab2x8(:,:,509))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(497),n2h4(100))
call HGT_OLR(G1H8(332),1,1,8)
call HGT_invQ_OLR(G1H8(332),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(332),-16,nME,G2H8(42),n2h8(434))
  call Hloop_AV_Q(ntryL,G2H8(42),ex5(:),G2H4(498),m3h2x4(:,510),heltab2x8(:,:,510))
  call Hloop_ZQ_A(ntryL,G1H8(335),ex1(:),G1H4(13),ngZl,m3h2x4(:,511),heltab2x8(:,:,511))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(499),n2h4(101))
  call Hloop_ZQ_A(ntryL,G1H8(336),ex1(:),G1H4(13),ngZl,m3h2x4(:,512),heltab2x8(:,:,512))
  call Hloop_Q_A(ntryL,G1H4(13),39,nME,G2H4(500),n2h4(102))
  call Hloop_SQ_A(ntryL,G1H8(337),ex1(:),G1H4(13),ngPnl,m3h2x4(:,513),heltab2x8(:,:,513))
  call Hloop_Q_A(ntryL,G1H4(13),45,0,G2H4(501),n2h4(103))
call HGT_raise_alpha_OLR(G1H8(338),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(338),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(338),ex5(:),G1H4(13),m3h2x4(:,514),heltab2x8(:,:,514))
  call Hloop_SQ_A(ntryL,G1H8(341),ex1(:),G1H4(14),ngPnl,m3h2x4(:,515),heltab2x8(:,:,515))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(502),n2h4(104))
  call Hloop_SQ_A(ntryL,G1H8(342),ex1(:),G1H4(14),ngPnl,m3h2x4(:,516),heltab2x8(:,:,516))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(503),n2h4(105))
  call Hloop_SQ_A(ntryL,G1H8(343),ex1(:),G1H4(14),ngPnl,m3h2x4(:,517),heltab2x8(:,:,517))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(504),n2h4(106))
call HGT_OLR(G1H8(344),1,1,8)
call HGT_invQ_OLR(G1H8(344),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(344),-16,ex5(:),16,G2H4(505),m3h2x4(:,518),heltab2x8(:,:,518))
  call Hloop_SQ_A(ntryL,G1H8(1309),ex1(:),G1H4(14),ngPnl,m3h2x4(:,519),heltab2x8(:,:,519))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(506),n2h4(107))
  call Hloop_SQ_A(ntryL,G1H8(1315),ex1(:),G1H4(14),ngPnl,m3h2x4(:,520),heltab2x8(:,:,520))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(507),n2h4(108))
  call Hloop_WQ_A(ntryL,G1H8(349),ex1(:),G1H4(14),m3h2x4(:,521),heltab2x8(:,:,521))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(508),n2h4(109))
call HGT_OLR(G1H8(350),1,1,8)
call HGT_invQ_OLR(G1H8(350),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(350),-16,ex5(:),16,G2H4(509),m3h2x4(:,522),heltab2x8(:,:,522))
  call Hloop_WQ_A(ntryL,G1H8(353),ex1(:),G1H4(14),m3h2x4(:,523),heltab2x8(:,:,523))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(510),n2h4(110))
  call Hloop_WQ_A(ntryL,G1H8(354),ex1(:),G1H4(14),m3h2x4(:,524),heltab2x8(:,:,524))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(511),n2h4(111))
  call Hloop_SQ_A(ntryL,G1H8(355),ex1(:),G1H4(14),ngPnl,m3h2x4(:,525),heltab2x8(:,:,525))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(512),n2h4(112))
call HGT_raise_alpha_OLR(G1H8(356),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(356),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(356),-16,ex5(:),16,G2H4(513),m3h2x4(:,526),heltab2x8(:,:,526))
  call Hloop_SQ_A(ntryL,G1H8(359),ex1(:),G1H4(14),ngPnl,m3h2x4(:,527),heltab2x8(:,:,527))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(514),n2h4(113))
  call Hloop_SQ_A(ntryL,G1H8(360),ex1(:),G1H4(14),ngPnl,m3h2x4(:,528),heltab2x8(:,:,528))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(515),n2h4(114))
  call Hloop_SQ_A(ntryL,G1H8(361),ex1(:),G1H4(14),ngPnl,m3h2x4(:,529),heltab2x8(:,:,529))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(516),n2h4(115))
call HGT_OLR(G1H8(362),1,1,8)
call HGT_invQ_OLR(G1H8(362),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(362),ex5(:),G1H4(14),m3h2x4(:,530),heltab2x8(:,:,530))
  call Hloop_SQ_A(ntryL,G1H8(1321),ex1(:),G1H4(15),ngPnl,m3h2x4(:,531),heltab2x8(:,:,531))
  call Hloop_Q_A(ntryL,G1H4(15),45,0,G2H4(517),n2h4(116))
  call Hloop_SQ_A(ntryL,G1H8(1327),ex1(:),G1H4(15),ngPnl,m3h2x4(:,532),heltab2x8(:,:,532))
  call Hloop_Q_A(ntryL,G1H4(15),45,0,G2H4(518),n2h4(117))
  call Hloop_WQ_A(ntryL,G1H8(367),ex1(:),G1H4(15),m3h2x4(:,533),heltab2x8(:,:,533))
  call Hloop_Q_A(ntryL,G1H4(15),45,0,G2H4(519),n2h4(118))
call HGT_raise_alpha_OLR(G1H8(368),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(368),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(368),ex5(:),G1H4(15),m3h2x4(:,534),heltab2x8(:,:,534))
  call Hloop_WQ_A(ntryL,G1H8(1333),ex1(:),G1H4(16),m3h2x4(:,535),heltab2x8(:,:,535))
  call Hloop_Q_A(ntryL,G1H4(16),45,0,G2H4(520),n2h4(119))
  call Hloop_WQ_A(ntryL,G1H8(1339),ex1(:),G1H4(16),m3h2x4(:,536),heltab2x8(:,:,536))
  call Hloop_Q_A(ntryL,G1H4(16),45,0,G2H4(521),n2h4(120))
  call Hloop_WQ_A(ntryL,G1H8(373),ex1(:),G1H4(16),m3h2x4(:,537),heltab2x8(:,:,537))
  call Hloop_Q_A(ntryL,G1H4(16),45,0,G2H4(522),n2h4(121))
call HGT_OLR(G1H8(374),1,1,8)
call HGT_invQ_OLR(G1H8(374),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(374),ex5(:),G1H4(16),m3h2x4(:,538),heltab2x8(:,:,538))
  call Hloop_WQ_A(ntryL,G1H8(377),ex1(:),G1H4(17),m3h2x4(:,539),heltab2x8(:,:,539))
  call Hloop_Q_A(ntryL,G1H4(17),45,0,G2H4(523),n2h4(122))
  call Hloop_WQ_A(ntryL,G1H8(378),ex1(:),G1H4(17),m3h2x4(:,540),heltab2x8(:,:,540))
  call Hloop_Q_A(ntryL,G1H4(17),45,0,G2H4(524),n2h4(123))
  call Hloop_WQ_A(ntryL,G1H8(379),ex1(:),G1H4(17),m3h2x4(:,541),heltab2x8(:,:,541))
  call Hloop_Q_A(ntryL,G1H4(17),45,0,G2H4(525),n2h4(124))
call HGT_raise_alpha_OLR(G1H8(380),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(380),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(380),-16,ex5(:),16,G2H4(526),m3h2x4(:,542),heltab2x8(:,:,542))
  call Hloop_WQ_A(ntryL,G1H8(1345),ex1(:),G1H4(17),m3h2x4(:,543),heltab2x8(:,:,543))
  call Hloop_Q_A(ntryL,G1H4(17),45,0,G2H4(527),n2h4(125))
  call Hloop_WQ_A(ntryL,G1H8(1351),ex1(:),G1H4(17),m3h2x4(:,544),heltab2x8(:,:,544))
  call Hloop_Q_A(ntryL,G1H4(17),45,0,G2H4(528),n2h4(126))
  call Hloop_SA_Q(ntryL,G1H8(385),ex2(:),G1H4(17),ngPln,m3h2x4(:,545),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H4(17),54,0,G2H4(529),n2h4(127))
call HGT_raise_alpha_OLR(G1H8(386),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(386),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(386),ex4(:),G1H4(17),m3h2x4(:,546),heltab2x8(:,:,546))
  call Hloop_SA_Q(ntryL,G1H8(389),ex2(:),G1H4(18),ngPln,m3h2x4(:,547),heltab2x8(:,:,547))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(530),n2h4(128))
  call Hloop_SA_Q(ntryL,G1H8(390),ex2(:),G1H4(18),ngPln,m3h2x4(:,548),heltab2x8(:,:,548))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(531),n2h4(129))
  call Hloop_SA_Q(ntryL,G1H8(391),ex2(:),G1H4(18),ngPln,m3h2x4(:,549),heltab2x8(:,:,549))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(532),n2h4(130))
call HGT_OLR(G1H8(392),1,1,8)
call HGT_invQ_OLR(G1H8(392),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(392),-8,ex4(:),8,G2H4(533),m3h2x4(:,550),heltab2x8(:,:,550))
  call Hloop_SA_Q(ntryL,G1H8(1357),ex2(:),G1H4(18),ngPln,m3h2x4(:,551),heltab2x8(:,:,551))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(534),n2h4(131))
  call Hloop_SA_Q(ntryL,G1H8(1363),ex2(:),G1H4(18),ngPln,m3h2x4(:,552),heltab2x8(:,:,552))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(535),n2h4(132))
  call Hloop_WA_Q(ntryL,G1H8(397),ex2(:),G1H4(18),m3h2x4(:,553),heltab2x8(:,:,553))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(536),n2h4(133))
call HGT_OLR(G1H8(398),1,1,8)
call HGT_invQ_OLR(G1H8(398),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(398),-8,ex4(:),8,G2H4(537),m3h2x4(:,554),heltab2x8(:,:,554))
  call Hloop_WA_Q(ntryL,G1H8(401),ex2(:),G1H4(18),m3h2x4(:,555),heltab2x8(:,:,555))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(538),n2h4(134))
  call Hloop_WA_Q(ntryL,G1H8(402),ex2(:),G1H4(18),m3h2x4(:,556),heltab2x8(:,:,556))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(539),n2h4(135))
  call Hloop_WA_Q(ntryL,G1H8(403),ex2(:),G1H4(18),m3h2x4(:,557),heltab2x8(:,:,557))
  call Hloop_A_Q(ntryL,G1H4(18),54,0,G2H4(540),n2h4(136))
call HGT_raise_alpha_OLR(G1H8(404),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(404),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(404),ex4(:),G1H4(18),m3h2x4(:,558),heltab2x8(:,:,558))
  call Hloop_WA_Q(ntryL,G1H8(1381),ex2(:),G1H4(19),m3h2x4(:,559),heltab2x8(:,:,559))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(541),n2h4(137))
  call Hloop_WA_Q(ntryL,G1H8(1387),ex2(:),G1H4(19),m3h2x4(:,560),heltab2x8(:,:,560))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(542),n2h4(138))
  call Hloop_SA_Q(ntryL,G1H8(409),ex2(:),G1H4(19),ngPln,m3h2x4(:,561),heltab2x8(:,:,561))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(543),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(410),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(410),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(410),-8,ex4(:),8,G2H4(544),m3h2x4(:,562),heltab2x8(:,:,562))
  call Hloop_SA_Q(ntryL,G1H8(413),ex2(:),G1H4(19),ngPln,m3h2x4(:,563),heltab2x8(:,:,563))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(545),n2h4(140))
  call Hloop_SA_Q(ntryL,G1H8(414),ex2(:),G1H4(19),ngPln,m3h2x4(:,564),heltab2x8(:,:,564))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(546),n2h4(141))
  call Hloop_SA_Q(ntryL,G1H8(415),ex2(:),G1H4(19),ngPln,m3h2x4(:,565),heltab2x8(:,:,565))
  call Hloop_A_Q(ntryL,G1H4(19),54,0,G2H4(547),n2h4(142))
call HGT_OLR(G1H8(416),1,1,8)
call HGT_invQ_OLR(G1H8(416),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(416),ex4(:),G1H4(19),m3h2x4(:,566),heltab2x8(:,:,566))
  call Hloop_SA_Q(ntryL,G1H8(1369),ex2(:),G1H4(20),ngPln,m3h2x4(:,567),heltab2x8(:,:,567))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(548),n2h4(143))
  call Hloop_SA_Q(ntryL,G1H8(1375),ex2(:),G1H4(20),ngPln,m3h2x4(:,568),heltab2x8(:,:,568))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(549),n2h4(144))
  call Hloop_WA_Q(ntryL,G1H8(421),ex2(:),G1H4(20),m3h2x4(:,569),heltab2x8(:,:,569))
  call Hloop_A_Q(ntryL,G1H4(20),54,0,G2H4(550),n2h4(145))
call HGT_OLR(G1H8(422),1,1,8)
call HGT_invQ_OLR(G1H8(422),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(422),ex4(:),G1H4(20),m3h2x4(:,570),heltab2x8(:,:,570))
  call Hloop_WA_Q(ntryL,G1H8(425),ex2(:),G1H4(21),m3h2x4(:,571),heltab2x8(:,:,571))
  call Hloop_A_Q(ntryL,G1H4(21),54,0,G2H4(551),n2h4(146))
  call Hloop_WA_Q(ntryL,G1H8(426),ex2(:),G1H4(21),m3h2x4(:,572),heltab2x8(:,:,572))
  call Hloop_A_Q(ntryL,G1H4(21),54,0,G2H4(552),n2h4(147))
  call Hloop_WA_Q(ntryL,G1H8(427),ex2(:),G1H4(21),m3h2x4(:,573),heltab2x8(:,:,573))
  call Hloop_A_Q(ntryL,G1H4(21),54,0,G2H4(553),n2h4(148))
call HGT_raise_alpha_OLR(G1H8(428),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(428),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(428),-8,ex4(:),8,G2H4(554),m3h2x4(:,574),heltab2x8(:,:,574))
  call Hloop_WA_Q(ntryL,G1H8(1393),ex2(:),G1H4(21),m3h2x4(:,575),heltab2x8(:,:,575))
  call Hloop_A_Q(ntryL,G1H4(21),54,0,G2H4(555),n2h4(149))
  call Hloop_WA_Q(ntryL,G1H8(1399),ex2(:),G1H4(21),m3h2x4(:,576),heltab2x8(:,:,576))
  call Hloop_A_Q(ntryL,G1H4(21),54,0,G2H4(556),n2h4(150))
  call Hloop_QV_A(ntryL,G1H8(433),ex4(:),G1H4(21),m3h2x4(:,577),heltab2x8(:,:,577))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(557),n2h4(151))
call HGT_OLR(G1H8(434),1,1,8)
call HGT_invQ_OLR(G1H8(434),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(434),-16,nME,G2H8(43),n2h8(451))
  call Hloop_AV_Q(ntryL,G2H8(43),ex5(:),G2H4(558),m3h2x4(:,578),heltab2x8(:,:,578))
  call Hloop_QV_A(ntryL,G1H8(437),ex4(:),G1H4(21),m3h2x4(:,579),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(559),n2h4(152))
  call Hloop_QV_A(ntryL,G1H8(438),ex4(:),G1H4(21),m3h2x4(:,580),heltab2x8(:,:,580))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(560),n2h4(153))
  call Hloop_QV_A(ntryL,G1H8(439),ex4(:),G1H4(21),m3h2x4(:,581),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(561),n2h4(154))
call HGT_OLR(G1H8(440),1,1,8)
call HGT_invQ_OLR(G1H8(440),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(440),-16,nME,G2H8(44),n2h8(452))
  call Hloop_AV_Q(ntryL,G2H8(44),ex5(:),G2H4(562),m3h2x4(:,582),heltab2x8(:,:,582))
  call Hloop_QV_A(ntryL,G1H8(443),ex4(:),G1H4(21),m3h2x4(:,583),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(563),n2h4(155))
  call Hloop_QV_A(ntryL,G1H8(444),ex4(:),G1H4(21),m3h2x4(:,584),heltab2x8(:,:,584))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(564),n2h4(156))
  call Hloop_TV_S(ntryL,G1H8(445),35,ex4(:),8,G2H4(565),m3h2x4(:,585),heltab2x8(:,:,585))
call HGT_OLR(G1H8(446),1,1,8)
call HGT_invQ_OLR(G1H8(446),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(446),-16,ex5(:),16,G2H4(566),m3h2x4(:,586),heltab2x8(:,:,586))
  call Hloop_TV_S(ntryL,G1H8(449),35,ex4(:),8,G2H4(567),m3h2x4(:,587),heltab2x8(:,:,587))
  call Hloop_TV_S(ntryL,G1H8(450),35,ex4(:),8,G2H4(568),m3h2x4(:,588),heltab2x8(:,:,588))
  call Hloop_QV_A(ntryL,G1H8(451),ex4(:),G1H4(21),m3h2x4(:,589),heltab2x8(:,:,589))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(569),n2h4(157))
call HGT_OLR(G1H8(452),1,1,8)
call HGT_invQ_OLR(G1H8(452),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(452),-16,nME,G2H8(46),n2h8(454))
  call Hloop_AV_Q(ntryL,G2H8(46),ex5(:),G2H4(570),m3h2x4(:,590),heltab2x8(:,:,590))
  call Hloop_QV_A(ntryL,G1H8(455),ex4(:),G1H4(21),m3h2x4(:,591),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(571),n2h4(158))
  call Hloop_QV_A(ntryL,G1H8(456),ex4(:),G1H4(21),m3h2x4(:,592),heltab2x8(:,:,592))
  call Hloop_Q_A(ntryL,G1H4(21),43,nME,G2H4(572),n2h4(159))
  call Hloop_TV_S(ntryL,G1H8(457),35,ex4(:),8,G2H4(573),m3h2x4(:,593),heltab2x8(:,:,593))
call HGT_raise_alpha_OLR(G1H8(458),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(458),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(458),ex5(:),G1H4(21),m3h2x4(:,594),heltab2x8(:,:,594))
  call Hloop_TV_S(ntryL,G1H8(461),35,ex4(:),8,G2H4(574),m3h2x4(:,595),heltab2x8(:,:,595))
  call Hloop_TV_S(ntryL,G1H8(462),35,ex4(:),8,G2H4(575),m3h2x4(:,596),heltab2x8(:,:,596))
  call Hloop_TV_S(ntryL,G1H8(463),35,ex4(:),8,G2H4(576),m3h2x4(:,597),heltab2x8(:,:,597))
call HGT_OLR(G1H8(464),1,1,8)
call HGT_invQ_OLR(G1H8(464),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(464),ex5(:),G1H4(22),m3h2x4(:,598),heltab2x8(:,:,598))
  call Hloop_TV_S(ntryL,G1H8(467),35,ex4(:),8,G2H4(577),m3h2x4(:,599),heltab2x8(:,:,599))
  call Hloop_TV_S(ntryL,G1H8(468),35,ex4(:),8,G2H4(578),m3h2x4(:,600),heltab2x8(:,:,600))
  call Hloop_TV_S(ntryL,G1H8(469),35,ex4(:),8,G2H4(579),m3h2x4(:,601),heltab2x8(:,:,601))
call HGT_raise_alpha_OLR(G1H8(470),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(470),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(470),-16,ex5(:),16,G2H4(580),m3h2x4(:,602),heltab2x8(:,:,602))
  call Hloop_TV_S(ntryL,G1H8(473),35,ex4(:),8,G2H4(581),m3h2x4(:,603),heltab2x8(:,:,603))
  call Hloop_TV_S(ntryL,G1H8(474),35,ex4(:),8,G2H4(582),m3h2x4(:,604),heltab2x8(:,:,604))
  call Hloop_UV_W(ntryL,G1H8(475),35,ex4(:),8,G2H4(583),m3h2x4(:,605),heltab2x8(:,:,605))
call HGT_OLR(G1H8(476),1,1,8)
call HGT_invQ_OLR(G1H8(476),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(476),-16,ex5(:),16,G2H4(584),m3h2x4(:,606),heltab2x8(:,:,606))
  call Hloop_UV_W(ntryL,G1H8(479),35,ex4(:),8,G2H4(585),m3h2x4(:,607),heltab2x8(:,:,607))
  call Hloop_UV_W(ntryL,G1H8(480),35,ex4(:),8,G2H4(586),m3h2x4(:,608),heltab2x8(:,:,608))
  call Hloop_UV_W(ntryL,G1H8(481),35,ex4(:),8,G2H4(587),m3h2x4(:,609),heltab2x8(:,:,609))
call HGT_raise_alpha_OLR(G1H8(482),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(482),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(482),ex5(:),G1H4(23),m3h2x4(:,610),heltab2x8(:,:,610))
  call Hloop_UV_W(ntryL,G1H8(485),35,ex4(:),8,G2H4(588),m3h2x4(:,611),heltab2x8(:,:,611))
  call Hloop_UV_W(ntryL,G1H8(486),35,ex4(:),8,G2H4(589),m3h2x4(:,612),heltab2x8(:,:,612))
  call Hloop_UV_W(ntryL,G1H8(487),35,ex4(:),8,G2H4(590),m3h2x4(:,613),heltab2x8(:,:,613))
call HGT_OLR(G1H8(488),1,1,8)
call HGT_invQ_OLR(G1H8(488),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(488),ex5(:),G1H4(24),m3h2x4(:,614),heltab2x8(:,:,614))
  call Hloop_UV_W(ntryL,G1H8(491),35,ex4(:),8,G2H4(591),m3h2x4(:,615),heltab2x8(:,:,615))
  call Hloop_UV_W(ntryL,G1H8(492),35,ex4(:),8,G2H4(592),m3h2x4(:,616),heltab2x8(:,:,616))
  call Hloop_UV_W(ntryL,G1H8(493),35,ex4(:),8,G2H4(593),m3h2x4(:,617),heltab2x8(:,:,617))
call HGT_raise_alpha_OLR(G1H8(494),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(494),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(494),-16,ex5(:),16,G2H4(594),m3h2x4(:,618),heltab2x8(:,:,618))
  call Hloop_UV_W(ntryL,G1H8(497),35,ex4(:),8,G2H4(595),m3h2x4(:,619),heltab2x8(:,:,619))
  call Hloop_UV_W(ntryL,G1H8(498),35,ex4(:),8,G2H4(596),m3h2x4(:,620),heltab2x8(:,:,620))
  call Hloop_QV_A(ntryL,G1H8(499),ex4(:),G1H4(25),m3h2x4(:,621),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(597),n2h4(160))
call HGT_OLR(G1H8(500),1,1,8)
call HGT_invQ_OLR(G1H8(500),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(500),-4,nME,G2H8(66),n2h8(462))
  call Hloop_AV_Q(ntryL,G2H8(66),ex3(:),G2H4(598),m3h2x4(:,622),heltab2x8(:,:,622))
  call Hloop_QV_A(ntryL,G1H8(503),ex4(:),G1H4(25),m3h2x4(:,623),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(599),n2h4(161))
  call Hloop_QV_A(ntryL,G1H8(504),ex4(:),G1H4(25),m3h2x4(:,624),heltab2x8(:,:,624))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(600),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(505),ex4(:),G1H4(25),m3h2x4(:,625),heltab2x8(:,:,625))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(601),n2h4(163))
call HGT_OLR(G1H8(506),1,1,8)
call HGT_invQ_OLR(G1H8(506),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(506),-4,nME,G2H8(89),n2h8(463))
  call Hloop_AV_Q(ntryL,G2H8(89),ex3(:),G2H4(602),m3h2x4(:,626),heltab2x8(:,:,626))
  call Hloop_QV_A(ntryL,G1H8(509),ex4(:),G1H4(25),m3h2x4(:,627),heltab2x8(:,:,627))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(603),n2h4(164))
  call Hloop_QV_A(ntryL,G1H8(510),ex4(:),G1H4(25),m3h2x4(:,628),heltab2x8(:,:,628))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(604),n2h4(165))
  call Hloop_TV_S(ntryL,G1H8(511),35,ex4(:),8,G2H4(605),m3h2x4(:,629),heltab2x8(:,:,629))
call HGT_OLR(G1H8(512),1,1,8)
call HGT_invQ_OLR(G1H8(512),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(512),-4,ex3(:),4,G2H4(606),m3h2x4(:,630),heltab2x8(:,:,630))
  call Hloop_TV_S(ntryL,G1H8(515),35,ex4(:),8,G2H4(607),m3h2x4(:,631),heltab2x8(:,:,631))
  call Hloop_TV_S(ntryL,G1H8(516),35,ex4(:),8,G2H4(608),m3h2x4(:,632),heltab2x8(:,:,632))
  call Hloop_QV_A(ntryL,G1H8(517),ex4(:),G1H4(25),m3h2x4(:,633),heltab2x8(:,:,633))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(609),n2h4(166))
call HGT_OLR(G1H8(518),1,1,8)
call HGT_invQ_OLR(G1H8(518),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(518),-4,nME,G2H8(90),n2h8(465))
  call Hloop_AV_Q(ntryL,G2H8(90),ex3(:),G2H4(610),m3h2x4(:,634),heltab2x8(:,:,634))
  call Hloop_QV_A(ntryL,G1H8(521),ex4(:),G1H4(25),m3h2x4(:,635),heltab2x8(:,:,635))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(611),n2h4(167))
  call Hloop_QV_A(ntryL,G1H8(522),ex4(:),G1H4(25),m3h2x4(:,636),heltab2x8(:,:,636))
  call Hloop_Q_A(ntryL,G1H4(25),43,nME,G2H4(612),n2h4(168))
  call Hloop_TV_S(ntryL,G1H8(523),35,ex4(:),8,G2H4(613),m3h2x4(:,637),heltab2x8(:,:,637))
call HGT_raise_alpha_OLR(G1H8(524),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(524),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(524),ex3(:),G1H4(25),m3h2x4(:,638),heltab2x8(:,:,638))
  call Hloop_TV_S(ntryL,G1H8(527),35,ex4(:),8,G2H4(614),m3h2x4(:,639),heltab2x8(:,:,639))
  call Hloop_TV_S(ntryL,G1H8(528),35,ex4(:),8,G2H4(615),m3h2x4(:,640),heltab2x8(:,:,640))
  call Hloop_TV_S(ntryL,G1H8(529),35,ex4(:),8,G2H4(616),m3h2x4(:,641),heltab2x8(:,:,641))
call HGT_OLR(G1H8(530),1,1,8)
call HGT_invQ_OLR(G1H8(530),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(530),ex3(:),G1H4(26),m3h2x4(:,642),heltab2x8(:,:,642))
  call Hloop_TV_S(ntryL,G1H8(533),35,ex4(:),8,G2H4(617),m3h2x4(:,643),heltab2x8(:,:,643))
  call Hloop_TV_S(ntryL,G1H8(534),35,ex4(:),8,G2H4(618),m3h2x4(:,644),heltab2x8(:,:,644))
  call Hloop_TV_S(ntryL,G1H8(535),35,ex4(:),8,G2H4(619),m3h2x4(:,645),heltab2x8(:,:,645))
call HGT_raise_alpha_OLR(G1H8(536),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(536),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(536),-4,ex3(:),4,G2H4(620),m3h2x4(:,646),heltab2x8(:,:,646))
  call Hloop_TV_S(ntryL,G1H8(539),35,ex4(:),8,G2H4(621),m3h2x4(:,647),heltab2x8(:,:,647))
  call Hloop_TV_S(ntryL,G1H8(540),35,ex4(:),8,G2H4(622),m3h2x4(:,648),heltab2x8(:,:,648))
  call Hloop_UV_W(ntryL,G1H8(541),35,ex4(:),8,G2H4(623),m3h2x4(:,649),heltab2x8(:,:,649))
call HGT_OLR(G1H8(542),1,1,8)
call HGT_invQ_OLR(G1H8(542),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(542),-4,ex3(:),4,G2H4(624),m3h2x4(:,650),heltab2x8(:,:,650))
  call Hloop_UV_W(ntryL,G1H8(545),35,ex4(:),8,G2H4(625),m3h2x4(:,651),heltab2x8(:,:,651))
  call Hloop_UV_W(ntryL,G1H8(546),35,ex4(:),8,G2H4(626),m3h2x4(:,652),heltab2x8(:,:,652))
  call Hloop_UV_W(ntryL,G1H8(547),35,ex4(:),8,G2H4(627),m3h2x4(:,653),heltab2x8(:,:,653))
call HGT_raise_alpha_OLR(G1H8(548),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(548),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(548),ex3(:),G1H4(27),m3h2x4(:,654),heltab2x8(:,:,654))
  call Hloop_UV_W(ntryL,G1H8(551),35,ex4(:),8,G2H4(628),m3h2x4(:,655),heltab2x8(:,:,655))
  call Hloop_UV_W(ntryL,G1H8(552),35,ex4(:),8,G2H4(629),m3h2x4(:,656),heltab2x8(:,:,656))
  call Hloop_UV_W(ntryL,G1H8(553),35,ex4(:),8,G2H4(630),m3h2x4(:,657),heltab2x8(:,:,657))
call HGT_OLR(G1H8(554),1,1,8)
call HGT_invQ_OLR(G1H8(554),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(554),ex3(:),G1H4(28),m3h2x4(:,658),heltab2x8(:,:,658))
  call Hloop_UV_W(ntryL,G1H8(557),35,ex4(:),8,G2H4(631),m3h2x4(:,659),heltab2x8(:,:,659))
  call Hloop_UV_W(ntryL,G1H8(558),35,ex4(:),8,G2H4(632),m3h2x4(:,660),heltab2x8(:,:,660))
  call Hloop_UV_W(ntryL,G1H8(559),35,ex4(:),8,G2H4(633),m3h2x4(:,661),heltab2x8(:,:,661))
call HGT_raise_alpha_OLR(G1H8(560),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(560),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(560),-4,ex3(:),4,G2H4(634),m3h2x4(:,662),heltab2x8(:,:,662))
  call Hloop_UV_W(ntryL,G1H8(563),35,ex4(:),8,G2H4(635),m3h2x4(:,663),heltab2x8(:,:,663))
  call Hloop_UV_W(ntryL,G1H8(564),35,ex4(:),8,G2H4(636),m3h2x4(:,664),heltab2x8(:,:,664))
  call Hloop_SA_Q(ntryL,G1H8(565),ex2(:),G1H4(29),ngPln,m3h2x4(:,665),heltab2x8(:,:,665))
  call Hloop_A_Q(ntryL,G1H4(29),46,0,G2H4(637),n2h4(169))
call HGT_raise_alpha_OLR(G1H8(566),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(566),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(566),ex5(:),G1H4(29),m3h2x4(:,666),heltab2x8(:,:,666))
  call Hloop_SA_Q(ntryL,G1H8(569),ex2(:),G1H4(30),ngPln,m3h2x4(:,667),heltab2x8(:,:,667))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(638),n2h4(170))
  call Hloop_SA_Q(ntryL,G1H8(570),ex2(:),G1H4(30),ngPln,m3h2x4(:,668),heltab2x8(:,:,668))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(639),n2h4(171))
  call Hloop_SA_Q(ntryL,G1H8(571),ex2(:),G1H4(30),ngPln,m3h2x4(:,669),heltab2x8(:,:,669))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(640),n2h4(172))
call HGT_OLR(G1H8(572),1,1,8)
call HGT_invQ_OLR(G1H8(572),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(572),-16,ex5(:),16,G2H4(641),m3h2x4(:,670),heltab2x8(:,:,670))
  call Hloop_SA_Q(ntryL,G1H8(1405),ex2(:),G1H4(30),ngPln,m3h2x4(:,671),heltab2x8(:,:,671))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(642),n2h4(173))
  call Hloop_SA_Q(ntryL,G1H8(1411),ex2(:),G1H4(30),ngPln,m3h2x4(:,672),heltab2x8(:,:,672))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(643),n2h4(174))
  call Hloop_WA_Q(ntryL,G1H8(577),ex2(:),G1H4(30),m3h2x4(:,673),heltab2x8(:,:,673))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(644),n2h4(175))
call HGT_OLR(G1H8(578),1,1,8)
call HGT_invQ_OLR(G1H8(578),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(578),-16,ex5(:),16,G2H4(645),m3h2x4(:,674),heltab2x8(:,:,674))
  call Hloop_WA_Q(ntryL,G1H8(581),ex2(:),G1H4(30),m3h2x4(:,675),heltab2x8(:,:,675))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(646),n2h4(176))
  call Hloop_WA_Q(ntryL,G1H8(582),ex2(:),G1H4(30),m3h2x4(:,676),heltab2x8(:,:,676))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(647),n2h4(177))
  call Hloop_WA_Q(ntryL,G1H8(583),ex2(:),G1H4(30),m3h2x4(:,677),heltab2x8(:,:,677))
  call Hloop_A_Q(ntryL,G1H4(30),46,0,G2H4(648),n2h4(178))
call HGT_raise_alpha_OLR(G1H8(584),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(584),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(584),ex5(:),G1H4(30),m3h2x4(:,678),heltab2x8(:,:,678))
  call Hloop_WA_Q(ntryL,G1H8(1429),ex2(:),G1H4(31),m3h2x4(:,679),heltab2x8(:,:,679))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(649),n2h4(179))
  call Hloop_WA_Q(ntryL,G1H8(1435),ex2(:),G1H4(31),m3h2x4(:,680),heltab2x8(:,:,680))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(650),n2h4(180))
  call Hloop_SA_Q(ntryL,G1H8(589),ex2(:),G1H4(31),ngPln,m3h2x4(:,681),heltab2x8(:,:,681))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(651),n2h4(181))
call HGT_raise_alpha_OLR(G1H8(590),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(590),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(590),-16,ex5(:),16,G2H4(652),m3h2x4(:,682),heltab2x8(:,:,682))
  call Hloop_SA_Q(ntryL,G1H8(593),ex2(:),G1H4(31),ngPln,m3h2x4(:,683),heltab2x8(:,:,683))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(653),n2h4(182))
  call Hloop_SA_Q(ntryL,G1H8(594),ex2(:),G1H4(31),ngPln,m3h2x4(:,684),heltab2x8(:,:,684))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(654),n2h4(183))
  call Hloop_SA_Q(ntryL,G1H8(595),ex2(:),G1H4(31),ngPln,m3h2x4(:,685),heltab2x8(:,:,685))
  call Hloop_A_Q(ntryL,G1H4(31),46,0,G2H4(655),n2h4(184))
call HGT_OLR(G1H8(596),1,1,8)
call HGT_invQ_OLR(G1H8(596),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(596),ex5(:),G1H4(31),m3h2x4(:,686),heltab2x8(:,:,686))
  call Hloop_SA_Q(ntryL,G1H8(1417),ex2(:),G1H4(32),ngPln,m3h2x4(:,687),heltab2x8(:,:,687))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(656),n2h4(185))
  call Hloop_SA_Q(ntryL,G1H8(1423),ex2(:),G1H4(32),ngPln,m3h2x4(:,688),heltab2x8(:,:,688))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(657),n2h4(186))
  call Hloop_WA_Q(ntryL,G1H8(601),ex2(:),G1H4(32),m3h2x4(:,689),heltab2x8(:,:,689))
  call Hloop_A_Q(ntryL,G1H4(32),46,0,G2H4(658),n2h4(187))
call HGT_OLR(G1H8(602),1,1,8)
call HGT_invQ_OLR(G1H8(602),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(602),ex5(:),G1H4(32),m3h2x4(:,690),heltab2x8(:,:,690))
  call Hloop_WA_Q(ntryL,G1H8(605),ex2(:),G1H4(33),m3h2x4(:,691),heltab2x8(:,:,691))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(659),n2h4(188))
  call Hloop_WA_Q(ntryL,G1H8(606),ex2(:),G1H4(33),m3h2x4(:,692),heltab2x8(:,:,692))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(660),n2h4(189))
  call Hloop_WA_Q(ntryL,G1H8(607),ex2(:),G1H4(33),m3h2x4(:,693),heltab2x8(:,:,693))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(661),n2h4(190))
call HGT_raise_alpha_OLR(G1H8(608),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(608),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(608),-16,ex5(:),16,G2H4(662),m3h2x4(:,694),heltab2x8(:,:,694))
  call Hloop_WA_Q(ntryL,G1H8(1441),ex2(:),G1H4(33),m3h2x4(:,695),heltab2x8(:,:,695))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(663),n2h4(191))
  call Hloop_WA_Q(ntryL,G1H8(1447),ex2(:),G1H4(33),m3h2x4(:,696),heltab2x8(:,:,696))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(664),n2h4(192))
  call Hloop_SQ_A(ntryL,G1H8(613),ex1(:),G1H4(33),ngH,m3h2x4(:,697),heltab2x8(:,:,697))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(665),n2h4(193))
call HGT_OLR(G1H8(614),1,1,8)
call HGT_invQ_OLR(G1H8(614),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(614),-8,nME,G2H8(91),n2h8(481))
  call Hloop_AV_Q(ntryL,G2H8(91),ex4(:),G2H4(666),m3h2x4(:,698),heltab2x8(:,:,698))
  call Hloop_SQ_A(ntryL,G1H8(617),ex1(:),G1H4(33),ngH,m3h2x4(:,699),heltab2x8(:,:,699))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(667),n2h4(194))
  call Hloop_SQ_A(ntryL,G1H8(618),ex1(:),G1H4(33),ngH,m3h2x4(:,700),heltab2x8(:,:,700))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(668),n2h4(195))
  call Hloop_SQ_A(ntryL,G1H8(619),ex1(:),G1H4(33),ngX,m3h2x4(:,701),heltab2x8(:,:,701))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(669),n2h4(196))
call HGT_OLR(G1H8(620),1,1,8)
call HGT_invQ_OLR(G1H8(620),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(620),-8,nME,G2H8(92),n2h8(482))
  call Hloop_AV_Q(ntryL,G2H8(92),ex4(:),G2H4(670),m3h2x4(:,702),heltab2x8(:,:,702))
  call Hloop_SQ_A(ntryL,G1H8(623),ex1(:),G1H4(33),ngX,m3h2x4(:,703),heltab2x8(:,:,703))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(671),n2h4(197))
  call Hloop_SQ_A(ntryL,G1H8(624),ex1(:),G1H4(33),ngX,m3h2x4(:,704),heltab2x8(:,:,704))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(672),n2h4(198))
  call Hloop_VQ_A(ntryL,G1H8(625),ex1(:),G1H4(33),m3h2x4(:,705),heltab2x8(:,:,705))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(673),n2h4(199))
call HGT_OLR(G1H8(626),1,1,8)
call HGT_invQ_OLR(G1H8(626),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(626),-8,nME,G2H8(93),n2h8(483))
  call Hloop_AV_Q(ntryL,G2H8(93),ex4(:),G2H4(674),m3h2x4(:,706),heltab2x8(:,:,706))
  call Hloop_VQ_A(ntryL,G1H8(629),ex1(:),G1H4(33),m3h2x4(:,707),heltab2x8(:,:,707))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(675),n2h4(200))
  call Hloop_VQ_A(ntryL,G1H8(630),ex1(:),G1H4(33),m3h2x4(:,708),heltab2x8(:,:,708))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(676),n2h4(201))
  call Hloop_ZQ_A(ntryL,G1H8(631),ex1(:),G1H4(33),ngZl,m3h2x4(:,709),heltab2x8(:,:,709))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(677),n2h4(202))
call HGT_OLR(G1H8(632),1,1,8)
call HGT_invQ_OLR(G1H8(632),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(632),-8,nME,G2H8(94),n2h8(484))
  call Hloop_AV_Q(ntryL,G2H8(94),ex4(:),G2H4(678),m3h2x4(:,710),heltab2x8(:,:,710))
  call Hloop_ZQ_A(ntryL,G1H8(635),ex1(:),G1H4(33),ngZl,m3h2x4(:,711),heltab2x8(:,:,711))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(679),n2h4(203))
  call Hloop_ZQ_A(ntryL,G1H8(636),ex1(:),G1H4(33),ngZl,m3h2x4(:,712),heltab2x8(:,:,712))
  call Hloop_Q_A(ntryL,G1H4(33),39,nME,G2H4(680),n2h4(204))
  call Hloop_SA_Q(ntryL,G1H8(637),ex2(:),G1H4(33),ngPln,m3h2x4(:,713),heltab2x8(:,:,713))
  call Hloop_A_Q(ntryL,G1H4(33),46,0,G2H4(681),n2h4(205))
call HGT_raise_alpha_OLR(G1H8(638),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(638),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(638),ex5(:),G1H4(33),m3h2x4(:,714),heltab2x8(:,:,714))
  call Hloop_SA_Q(ntryL,G1H8(641),ex2(:),G1H4(34),ngPln,m3h2x4(:,715),heltab2x8(:,:,715))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(682),n2h4(206))
  call Hloop_SA_Q(ntryL,G1H8(642),ex2(:),G1H4(34),ngPln,m3h2x4(:,716),heltab2x8(:,:,716))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(683),n2h4(207))
  call Hloop_SA_Q(ntryL,G1H8(643),ex2(:),G1H4(34),ngPln,m3h2x4(:,717),heltab2x8(:,:,717))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(684),n2h4(208))
call HGT_OLR(G1H8(644),1,1,8)
call HGT_invQ_OLR(G1H8(644),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(644),-16,ex5(:),16,G2H4(685),m3h2x4(:,718),heltab2x8(:,:,718))
  call Hloop_SA_Q(ntryL,G1H8(1453),ex2(:),G1H4(34),ngPln,m3h2x4(:,719),heltab2x8(:,:,719))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(686),n2h4(209))
  call Hloop_SA_Q(ntryL,G1H8(1459),ex2(:),G1H4(34),ngPln,m3h2x4(:,720),heltab2x8(:,:,720))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(687),n2h4(210))
  call Hloop_WA_Q(ntryL,G1H8(649),ex2(:),G1H4(34),m3h2x4(:,721),heltab2x8(:,:,721))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(688),n2h4(211))
call HGT_OLR(G1H8(650),1,1,8)
call HGT_invQ_OLR(G1H8(650),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(650),-16,ex5(:),16,G2H4(689),m3h2x4(:,722),heltab2x8(:,:,722))
  call Hloop_WA_Q(ntryL,G1H8(653),ex2(:),G1H4(34),m3h2x4(:,723),heltab2x8(:,:,723))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(690),n2h4(212))
  call Hloop_WA_Q(ntryL,G1H8(654),ex2(:),G1H4(34),m3h2x4(:,724),heltab2x8(:,:,724))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(691),n2h4(213))
  call Hloop_WA_Q(ntryL,G1H8(655),ex2(:),G1H4(34),m3h2x4(:,725),heltab2x8(:,:,725))
  call Hloop_A_Q(ntryL,G1H4(34),46,0,G2H4(692),n2h4(214))
call HGT_raise_alpha_OLR(G1H8(656),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(656),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(656),ex5(:),G1H4(34),m3h2x4(:,726),heltab2x8(:,:,726))
  call Hloop_WA_Q(ntryL,G1H8(1477),ex2(:),G1H4(35),m3h2x4(:,727),heltab2x8(:,:,727))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(693),n2h4(215))
  call Hloop_WA_Q(ntryL,G1H8(1483),ex2(:),G1H4(35),m3h2x4(:,728),heltab2x8(:,:,728))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(694),n2h4(216))
  call Hloop_SA_Q(ntryL,G1H8(661),ex2(:),G1H4(35),ngPln,m3h2x4(:,729),heltab2x8(:,:,729))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(695),n2h4(217))
call HGT_raise_alpha_OLR(G1H8(662),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(662),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(662),-16,ex5(:),16,G2H4(696),m3h2x4(:,730),heltab2x8(:,:,730))
  call Hloop_SA_Q(ntryL,G1H8(665),ex2(:),G1H4(35),ngPln,m3h2x4(:,731),heltab2x8(:,:,731))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(697),n2h4(218))
  call Hloop_SA_Q(ntryL,G1H8(666),ex2(:),G1H4(35),ngPln,m3h2x4(:,732),heltab2x8(:,:,732))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(698),n2h4(219))
  call Hloop_SA_Q(ntryL,G1H8(667),ex2(:),G1H4(35),ngPln,m3h2x4(:,733),heltab2x8(:,:,733))
  call Hloop_A_Q(ntryL,G1H4(35),46,0,G2H4(699),n2h4(220))
call HGT_OLR(G1H8(668),1,1,8)
call HGT_invQ_OLR(G1H8(668),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(668),ex5(:),G1H4(35),m3h2x4(:,734),heltab2x8(:,:,734))
  call Hloop_SA_Q(ntryL,G1H8(1465),ex2(:),G1H4(36),ngPln,m3h2x4(:,735),heltab2x8(:,:,735))
  call Hloop_A_Q(ntryL,G1H4(36),46,0,G2H4(700),n2h4(221))
  call Hloop_SA_Q(ntryL,G1H8(1471),ex2(:),G1H4(36),ngPln,m3h2x4(:,736),heltab2x8(:,:,736))
  call Hloop_A_Q(ntryL,G1H4(36),46,0,G2H4(701),n2h4(222))
  call Hloop_WA_Q(ntryL,G1H8(673),ex2(:),G1H4(36),m3h2x4(:,737),heltab2x8(:,:,737))
  call Hloop_A_Q(ntryL,G1H4(36),46,0,G2H4(702),n2h4(223))
call HGT_OLR(G1H8(674),1,1,8)
call HGT_invQ_OLR(G1H8(674),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(674),ex5(:),G1H4(36),m3h2x4(:,738),heltab2x8(:,:,738))
  call Hloop_WA_Q(ntryL,G1H8(677),ex2(:),G1H4(37),m3h2x4(:,739),heltab2x8(:,:,739))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(703),n2h4(224))
  call Hloop_WA_Q(ntryL,G1H8(678),ex2(:),G1H4(37),m3h2x4(:,740),heltab2x8(:,:,740))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(704),n2h4(225))
  call Hloop_WA_Q(ntryL,G1H8(679),ex2(:),G1H4(37),m3h2x4(:,741),heltab2x8(:,:,741))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(705),n2h4(226))
call HGT_raise_alpha_OLR(G1H8(680),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(680),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(680),-16,ex5(:),16,G2H4(706),m3h2x4(:,742),heltab2x8(:,:,742))
  call Hloop_WA_Q(ntryL,G1H8(1489),ex2(:),G1H4(37),m3h2x4(:,743),heltab2x8(:,:,743))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(707),n2h4(227))
  call Hloop_WA_Q(ntryL,G1H8(1495),ex2(:),G1H4(37),m3h2x4(:,744),heltab2x8(:,:,744))
  call Hloop_A_Q(ntryL,G1H4(37),46,0,G2H4(708),n2h4(228))
  call Hloop_SQ_A(ntryL,G1H8(685),ex1(:),G1H4(37),ngPnl,m3h2x4(:,745),heltab2x8(:,:,745))
  call Hloop_Q_A(ntryL,G1H4(37),53,0,G2H4(709),n2h4(229))
call HGT_raise_alpha_OLR(G1H8(686),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(686),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(686),ex4(:),G1H4(37),m3h2x4(:,746),heltab2x8(:,:,746))
  call Hloop_SQ_A(ntryL,G1H8(689),ex1(:),G1H4(38),ngPnl,m3h2x4(:,747),heltab2x8(:,:,747))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(710),n2h4(230))
  call Hloop_SQ_A(ntryL,G1H8(690),ex1(:),G1H4(38),ngPnl,m3h2x4(:,748),heltab2x8(:,:,748))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(711),n2h4(231))
  call Hloop_SQ_A(ntryL,G1H8(691),ex1(:),G1H4(38),ngPnl,m3h2x4(:,749),heltab2x8(:,:,749))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(712),n2h4(232))
call HGT_OLR(G1H8(692),1,1,8)
call HGT_invQ_OLR(G1H8(692),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(692),-8,ex4(:),8,G2H4(713),m3h2x4(:,750),heltab2x8(:,:,750))
  call Hloop_SQ_A(ntryL,G1H8(1501),ex1(:),G1H4(38),ngPnl,m3h2x4(:,751),heltab2x8(:,:,751))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(714),n2h4(233))
  call Hloop_SQ_A(ntryL,G1H8(1507),ex1(:),G1H4(38),ngPnl,m3h2x4(:,752),heltab2x8(:,:,752))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(715),n2h4(234))
  call Hloop_WQ_A(ntryL,G1H8(697),ex1(:),G1H4(38),m3h2x4(:,753),heltab2x8(:,:,753))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(716),n2h4(235))
call HGT_OLR(G1H8(698),1,1,8)
call HGT_invQ_OLR(G1H8(698),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(698),-8,ex4(:),8,G2H4(717),m3h2x4(:,754),heltab2x8(:,:,754))
  call Hloop_WQ_A(ntryL,G1H8(701),ex1(:),G1H4(38),m3h2x4(:,755),heltab2x8(:,:,755))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(718),n2h4(236))
  call Hloop_WQ_A(ntryL,G1H8(702),ex1(:),G1H4(38),m3h2x4(:,756),heltab2x8(:,:,756))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(719),n2h4(237))
  call Hloop_SQ_A(ntryL,G1H8(703),ex1(:),G1H4(38),ngPnl,m3h2x4(:,757),heltab2x8(:,:,757))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(720),n2h4(238))
call HGT_raise_alpha_OLR(G1H8(704),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(704),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(704),-8,ex4(:),8,G2H4(721),m3h2x4(:,758),heltab2x8(:,:,758))
  call Hloop_SQ_A(ntryL,G1H8(707),ex1(:),G1H4(38),ngPnl,m3h2x4(:,759),heltab2x8(:,:,759))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(722),n2h4(239))
  call Hloop_SQ_A(ntryL,G1H8(708),ex1(:),G1H4(38),ngPnl,m3h2x4(:,760),heltab2x8(:,:,760))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(723),n2h4(240))
  call Hloop_SQ_A(ntryL,G1H8(709),ex1(:),G1H4(38),ngPnl,m3h2x4(:,761),heltab2x8(:,:,761))
  call Hloop_Q_A(ntryL,G1H4(38),53,0,G2H4(724),n2h4(241))
call HGT_OLR(G1H8(710),1,1,8)
call HGT_invQ_OLR(G1H8(710),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(710),ex4(:),G1H4(38),m3h2x4(:,762),heltab2x8(:,:,762))
  call Hloop_SQ_A(ntryL,G1H8(1513),ex1(:),G1H4(39),ngPnl,m3h2x4(:,763),heltab2x8(:,:,763))
  call Hloop_Q_A(ntryL,G1H4(39),53,0,G2H4(725),n2h4(242))
  call Hloop_SQ_A(ntryL,G1H8(1519),ex1(:),G1H4(39),ngPnl,m3h2x4(:,764),heltab2x8(:,:,764))
  call Hloop_Q_A(ntryL,G1H4(39),53,0,G2H4(726),n2h4(243))
  call Hloop_WQ_A(ntryL,G1H8(715),ex1(:),G1H4(39),m3h2x4(:,765),heltab2x8(:,:,765))
  call Hloop_Q_A(ntryL,G1H4(39),53,0,G2H4(727),n2h4(244))
call HGT_raise_alpha_OLR(G1H8(716),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(716),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(716),ex4(:),G1H4(39),m3h2x4(:,766),heltab2x8(:,:,766))
  call Hloop_WQ_A(ntryL,G1H8(1525),ex1(:),G1H4(40),m3h2x4(:,767),heltab2x8(:,:,767))
  call Hloop_Q_A(ntryL,G1H4(40),53,0,G2H4(728),n2h4(245))
  call Hloop_WQ_A(ntryL,G1H8(1531),ex1(:),G1H4(40),m3h2x4(:,768),heltab2x8(:,:,768))
  call Hloop_Q_A(ntryL,G1H4(40),53,0,G2H4(729),n2h4(246))
  call Hloop_WQ_A(ntryL,G1H8(721),ex1(:),G1H4(40),m3h2x4(:,769),heltab2x8(:,:,769))
  call Hloop_Q_A(ntryL,G1H4(40),53,0,G2H4(730),n2h4(247))
call HGT_OLR(G1H8(722),1,1,8)
call HGT_invQ_OLR(G1H8(722),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(722),ex4(:),G1H4(40),m3h2x4(:,770),heltab2x8(:,:,770))
  call Hloop_WQ_A(ntryL,G1H8(725),ex1(:),G1H4(41),m3h2x4(:,771),heltab2x8(:,:,771))
  call Hloop_Q_A(ntryL,G1H4(41),53,0,G2H4(731),n2h4(248))
  call Hloop_WQ_A(ntryL,G1H8(726),ex1(:),G1H4(41),m3h2x4(:,772),heltab2x8(:,:,772))
  call Hloop_Q_A(ntryL,G1H4(41),53,0,G2H4(732),n2h4(249))
  call Hloop_WQ_A(ntryL,G1H8(727),ex1(:),G1H4(41),m3h2x4(:,773),heltab2x8(:,:,773))
  call Hloop_Q_A(ntryL,G1H4(41),53,0,G2H4(733),n2h4(250))
call HGT_raise_alpha_OLR(G1H8(728),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(728),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(728),-8,ex4(:),8,G2H4(734),m3h2x4(:,774),heltab2x8(:,:,774))
  call Hloop_WQ_A(ntryL,G1H8(1537),ex1(:),G1H4(41),m3h2x4(:,775),heltab2x8(:,:,775))
  call Hloop_Q_A(ntryL,G1H4(41),53,0,G2H4(735),n2h4(251))
  call Hloop_WQ_A(ntryL,G1H8(1543),ex1(:),G1H4(41),m3h2x4(:,776),heltab2x8(:,:,776))
  call Hloop_Q_A(ntryL,G1H4(41),53,0,G2H4(736),n2h4(252))
  call Hloop_QV_A(ntryL,G1H8(733),ex5(:),G1H4(41),m3h2x4(:,777),heltab2x8(:,:,777))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(737),n2h4(253))
call HGT_OLR(G1H8(734),1,1,8)
call HGT_invQ_OLR(G1H8(734),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(734),-8,nME,G2H8(95),n2h8(501))
  call Hloop_AV_Q(ntryL,G2H8(95),ex4(:),G2H4(738),m3h2x4(:,778),heltab2x8(:,:,778))
  call Hloop_QV_A(ntryL,G1H8(737),ex5(:),G1H4(41),m3h2x4(:,779),heltab2x8(:,:,779))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(739),n2h4(254))
  call Hloop_QV_A(ntryL,G1H8(738),ex5(:),G1H4(41),m3h2x4(:,780),heltab2x8(:,:,780))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(740),n2h4(255))
  call Hloop_QV_A(ntryL,G1H8(739),ex5(:),G1H4(41),m3h2x4(:,781),heltab2x8(:,:,781))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(741),n2h4(256))
call HGT_OLR(G1H8(740),1,1,8)
call HGT_invQ_OLR(G1H8(740),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(740),-8,nME,G2H8(96),n2h8(502))
  call Hloop_AV_Q(ntryL,G2H8(96),ex4(:),G2H4(742),m3h2x4(:,782),heltab2x8(:,:,782))
  call Hloop_QV_A(ntryL,G1H8(743),ex5(:),G1H4(41),m3h2x4(:,783),heltab2x8(:,:,783))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(743),n2h4(257))
  call Hloop_QV_A(ntryL,G1H8(744),ex5(:),G1H4(41),m3h2x4(:,784),heltab2x8(:,:,784))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(744),n2h4(258))
  call Hloop_TV_S(ntryL,G1H8(745),35,ex5(:),16,G2H4(745),m3h2x4(:,785),heltab2x8(:,:,785))
call HGT_OLR(G1H8(746),1,1,8)
call HGT_invQ_OLR(G1H8(746),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(746),-8,ex4(:),8,G2H4(746),m3h2x4(:,786),heltab2x8(:,:,786))
  call Hloop_TV_S(ntryL,G1H8(749),35,ex5(:),16,G2H4(747),m3h2x4(:,787),heltab2x8(:,:,787))
  call Hloop_TV_S(ntryL,G1H8(750),35,ex5(:),16,G2H4(748),m3h2x4(:,788),heltab2x8(:,:,788))
  call Hloop_QV_A(ntryL,G1H8(751),ex5(:),G1H4(41),m3h2x4(:,789),heltab2x8(:,:,789))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(749),n2h4(259))
call HGT_OLR(G1H8(752),1,1,8)
call HGT_invQ_OLR(G1H8(752),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(752),-8,nME,G2H8(101),n2h8(504))
  call Hloop_AV_Q(ntryL,G2H8(101),ex4(:),G2H4(750),m3h2x4(:,790),heltab2x8(:,:,790))
  call Hloop_QV_A(ntryL,G1H8(755),ex5(:),G1H4(41),m3h2x4(:,791),heltab2x8(:,:,791))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(751),n2h4(260))
  call Hloop_QV_A(ntryL,G1H8(756),ex5(:),G1H4(41),m3h2x4(:,792),heltab2x8(:,:,792))
  call Hloop_Q_A(ntryL,G1H4(41),51,nME,G2H4(752),n2h4(261))
  call Hloop_TV_S(ntryL,G1H8(757),35,ex5(:),16,G2H4(753),m3h2x4(:,793),heltab2x8(:,:,793))
call HGT_raise_alpha_OLR(G1H8(758),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(758),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(758),ex4(:),G1H4(41),m3h2x4(:,794),heltab2x8(:,:,794))
  call Hloop_TV_S(ntryL,G1H8(761),35,ex5(:),16,G2H4(754),m3h2x4(:,795),heltab2x8(:,:,795))
  call Hloop_TV_S(ntryL,G1H8(762),35,ex5(:),16,G2H4(755),m3h2x4(:,796),heltab2x8(:,:,796))
  call Hloop_TV_S(ntryL,G1H8(763),35,ex5(:),16,G2H4(756),m3h2x4(:,797),heltab2x8(:,:,797))
call HGT_OLR(G1H8(764),1,1,8)
call HGT_invQ_OLR(G1H8(764),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(764),ex4(:),G1H4(42),m3h2x4(:,798),heltab2x8(:,:,798))
  call Hloop_TV_S(ntryL,G1H8(767),35,ex5(:),16,G2H4(757),m3h2x4(:,799),heltab2x8(:,:,799))
  call Hloop_TV_S(ntryL,G1H8(768),35,ex5(:),16,G2H4(758),m3h2x4(:,800),heltab2x8(:,:,800))
  call Hloop_TV_S(ntryL,G1H8(769),35,ex5(:),16,G2H4(759),m3h2x4(:,801),heltab2x8(:,:,801))
call HGT_raise_alpha_OLR(G1H8(770),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(770),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(770),-8,ex4(:),8,G2H4(760),m3h2x4(:,802),heltab2x8(:,:,802))
  call Hloop_TV_S(ntryL,G1H8(773),35,ex5(:),16,G2H4(761),m3h2x4(:,803),heltab2x8(:,:,803))
  call Hloop_TV_S(ntryL,G1H8(774),35,ex5(:),16,G2H4(762),m3h2x4(:,804),heltab2x8(:,:,804))
  call Hloop_UV_W(ntryL,G1H8(775),35,ex5(:),16,G2H4(763),m3h2x4(:,805),heltab2x8(:,:,805))
call HGT_OLR(G1H8(776),1,1,8)
call HGT_invQ_OLR(G1H8(776),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(776),-8,ex4(:),8,G2H4(764),m3h2x4(:,806),heltab2x8(:,:,806))
  call Hloop_UV_W(ntryL,G1H8(779),35,ex5(:),16,G2H4(765),m3h2x4(:,807),heltab2x8(:,:,807))
  call Hloop_UV_W(ntryL,G1H8(780),35,ex5(:),16,G2H4(766),m3h2x4(:,808),heltab2x8(:,:,808))
  call Hloop_UV_W(ntryL,G1H8(781),35,ex5(:),16,G2H4(767),m3h2x4(:,809),heltab2x8(:,:,809))
call HGT_raise_alpha_OLR(G1H8(782),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(782),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(782),ex4(:),G1H4(43),m3h2x4(:,810),heltab2x8(:,:,810))
  call Hloop_UV_W(ntryL,G1H8(785),35,ex5(:),16,G2H4(768),m3h2x4(:,811),heltab2x8(:,:,811))
  call Hloop_UV_W(ntryL,G1H8(786),35,ex5(:),16,G2H4(769),m3h2x4(:,812),heltab2x8(:,:,812))
  call Hloop_UV_W(ntryL,G1H8(787),35,ex5(:),16,G2H4(770),m3h2x4(:,813),heltab2x8(:,:,813))
call HGT_OLR(G1H8(788),1,1,8)
call HGT_invQ_OLR(G1H8(788),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(788),ex4(:),G1H4(44),m3h2x4(:,814),heltab2x8(:,:,814))
  call Hloop_UV_W(ntryL,G1H8(791),35,ex5(:),16,G2H4(771),m3h2x4(:,815),heltab2x8(:,:,815))
  call Hloop_UV_W(ntryL,G1H8(792),35,ex5(:),16,G2H4(772),m3h2x4(:,816),heltab2x8(:,:,816))
  call Hloop_UV_W(ntryL,G1H8(793),35,ex5(:),16,G2H4(773),m3h2x4(:,817),heltab2x8(:,:,817))
call HGT_raise_alpha_OLR(G1H8(794),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(794),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(794),-8,ex4(:),8,G2H4(774),m3h2x4(:,818),heltab2x8(:,:,818))
  call Hloop_UV_W(ntryL,G1H8(797),35,ex5(:),16,G2H4(775),m3h2x4(:,819),heltab2x8(:,:,819))
  call Hloop_UV_W(ntryL,G1H8(798),35,ex5(:),16,G2H4(776),m3h2x4(:,820),heltab2x8(:,:,820))
  call Hloop_QV_A(ntryL,G1H8(799),ex5(:),G1H4(45),m3h2x4(:,821),heltab2x8(:,:,821))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(777),n2h4(262))
call HGT_OLR(G1H8(800),1,1,8)
call HGT_invQ_OLR(G1H8(800),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(800),-4,nME,G2H8(102),n2h8(512))
  call Hloop_AV_Q(ntryL,G2H8(102),ex3(:),G2H4(778),m3h2x4(:,822),heltab2x8(:,:,822))
  call Hloop_QV_A(ntryL,G1H8(803),ex5(:),G1H4(45),m3h2x4(:,823),heltab2x8(:,:,823))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(779),n2h4(263))
  call Hloop_QV_A(ntryL,G1H8(804),ex5(:),G1H4(45),m3h2x4(:,824),heltab2x8(:,:,824))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(780),n2h4(264))
  call Hloop_QV_A(ntryL,G1H8(805),ex5(:),G1H4(45),m3h2x4(:,825),heltab2x8(:,:,825))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(781),n2h4(265))
call HGT_OLR(G1H8(806),1,1,8)
call HGT_invQ_OLR(G1H8(806),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(806),-4,nME,G2H8(103),n2h8(513))
  call Hloop_AV_Q(ntryL,G2H8(103),ex3(:),G2H4(782),m3h2x4(:,826),heltab2x8(:,:,826))
  call Hloop_QV_A(ntryL,G1H8(809),ex5(:),G1H4(45),m3h2x4(:,827),heltab2x8(:,:,827))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(783),n2h4(266))
  call Hloop_QV_A(ntryL,G1H8(810),ex5(:),G1H4(45),m3h2x4(:,828),heltab2x8(:,:,828))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(784),n2h4(267))
  call Hloop_TV_S(ntryL,G1H8(811),35,ex5(:),16,G2H4(785),m3h2x4(:,829),heltab2x8(:,:,829))
call HGT_OLR(G1H8(812),1,1,8)
call HGT_invQ_OLR(G1H8(812),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(812),-4,ex3(:),4,G2H4(786),m3h2x4(:,830),heltab2x8(:,:,830))
  call Hloop_TV_S(ntryL,G1H8(815),35,ex5(:),16,G2H4(787),m3h2x4(:,831),heltab2x8(:,:,831))
  call Hloop_TV_S(ntryL,G1H8(816),35,ex5(:),16,G2H4(788),m3h2x4(:,832),heltab2x8(:,:,832))
  call Hloop_QV_A(ntryL,G1H8(817),ex5(:),G1H4(45),m3h2x4(:,833),heltab2x8(:,:,833))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(789),n2h4(268))
call HGT_OLR(G1H8(818),1,1,8)
call HGT_invQ_OLR(G1H8(818),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(818),-4,nME,G2H8(104),n2h8(515))
  call Hloop_AV_Q(ntryL,G2H8(104),ex3(:),G2H4(790),m3h2x4(:,834),heltab2x8(:,:,834))
  call Hloop_QV_A(ntryL,G1H8(821),ex5(:),G1H4(45),m3h2x4(:,835),heltab2x8(:,:,835))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(791),n2h4(269))
  call Hloop_QV_A(ntryL,G1H8(822),ex5(:),G1H4(45),m3h2x4(:,836),heltab2x8(:,:,836))
  call Hloop_Q_A(ntryL,G1H4(45),51,nME,G2H4(792),n2h4(270))
  call Hloop_TV_S(ntryL,G1H8(823),35,ex5(:),16,G2H4(793),m3h2x4(:,837),heltab2x8(:,:,837))
call HGT_raise_alpha_OLR(G1H8(824),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(824),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(824),ex3(:),G1H4(45),m3h2x4(:,838),heltab2x8(:,:,838))
  call Hloop_TV_S(ntryL,G1H8(827),35,ex5(:),16,G2H4(794),m3h2x4(:,839),heltab2x8(:,:,839))
  call Hloop_TV_S(ntryL,G1H8(828),35,ex5(:),16,G2H4(795),m3h2x4(:,840),heltab2x8(:,:,840))
  call Hloop_TV_S(ntryL,G1H8(829),35,ex5(:),16,G2H4(796),m3h2x4(:,841),heltab2x8(:,:,841))
call HGT_OLR(G1H8(830),1,1,8)
call HGT_invQ_OLR(G1H8(830),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(830),ex3(:),G1H4(46),m3h2x4(:,842),heltab2x8(:,:,842))
  call Hloop_TV_S(ntryL,G1H8(833),35,ex5(:),16,G2H4(797),m3h2x4(:,843),heltab2x8(:,:,843))
  call Hloop_TV_S(ntryL,G1H8(834),35,ex5(:),16,G2H4(798),m3h2x4(:,844),heltab2x8(:,:,844))
  call Hloop_TV_S(ntryL,G1H8(835),35,ex5(:),16,G2H4(799),m3h2x4(:,845),heltab2x8(:,:,845))
call HGT_raise_alpha_OLR(G1H8(836),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(836),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(836),-4,ex3(:),4,G2H4(800),m3h2x4(:,846),heltab2x8(:,:,846))
  call Hloop_TV_S(ntryL,G1H8(839),35,ex5(:),16,G2H4(801),m3h2x4(:,847),heltab2x8(:,:,847))
  call Hloop_TV_S(ntryL,G1H8(840),35,ex5(:),16,G2H4(802),m3h2x4(:,848),heltab2x8(:,:,848))
  call Hloop_UV_W(ntryL,G1H8(841),35,ex5(:),16,G2H4(803),m3h2x4(:,849),heltab2x8(:,:,849))
call HGT_OLR(G1H8(842),1,1,8)
call HGT_invQ_OLR(G1H8(842),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(842),-4,ex3(:),4,G2H4(804),m3h2x4(:,850),heltab2x8(:,:,850))
  call Hloop_UV_W(ntryL,G1H8(845),35,ex5(:),16,G2H4(805),m3h2x4(:,851),heltab2x8(:,:,851))
  call Hloop_UV_W(ntryL,G1H8(846),35,ex5(:),16,G2H4(806),m3h2x4(:,852),heltab2x8(:,:,852))
  call Hloop_UV_W(ntryL,G1H8(847),35,ex5(:),16,G2H4(807),m3h2x4(:,853),heltab2x8(:,:,853))
call HGT_raise_alpha_OLR(G1H8(848),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(848),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(848),ex3(:),G1H4(47),m3h2x4(:,854),heltab2x8(:,:,854))
  call Hloop_UV_W(ntryL,G1H8(851),35,ex5(:),16,G2H4(808),m3h2x4(:,855),heltab2x8(:,:,855))
  call Hloop_UV_W(ntryL,G1H8(852),35,ex5(:),16,G2H4(809),m3h2x4(:,856),heltab2x8(:,:,856))
  call Hloop_UV_W(ntryL,G1H8(853),35,ex5(:),16,G2H4(810),m3h2x4(:,857),heltab2x8(:,:,857))
call HGT_OLR(G1H8(854),1,1,8)
call HGT_invQ_OLR(G1H8(854),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(854),ex3(:),G1H4(48),m3h2x4(:,858),heltab2x8(:,:,858))
  call Hloop_UV_W(ntryL,G1H8(857),35,ex5(:),16,G2H4(811),m3h2x4(:,859),heltab2x8(:,:,859))
  call Hloop_UV_W(ntryL,G1H8(858),35,ex5(:),16,G2H4(812),m3h2x4(:,860),heltab2x8(:,:,860))
  call Hloop_UV_W(ntryL,G1H8(859),35,ex5(:),16,G2H4(813),m3h2x4(:,861),heltab2x8(:,:,861))
call HGT_raise_alpha_OLR(G1H8(860),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(860),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(860),-4,ex3(:),4,G2H4(814),m3h2x4(:,862),heltab2x8(:,:,862))
  call Hloop_UV_W(ntryL,G1H8(863),35,ex5(:),16,G2H4(815),m3h2x4(:,863),heltab2x8(:,:,863))
  call Hloop_UV_W(ntryL,G1H8(864),35,ex5(:),16,G2H4(816),m3h2x4(:,864),heltab2x8(:,:,864))
  call Hloop_AV_Q(ntryL,G1H8(865),ex3(:),G1H4(49),m3h2x4(:,865),heltab2x8(:,:,865))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(817),n2h4(271))
call HGT_OLR(G1H8(866),1,1,8)
call HGT_invQ_OLR(G1H8(866),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(866),-16,nME,G2H8(105),n2h8(523))
  call Hloop_QV_A(ntryL,G2H8(105),ex5(:),G2H4(818),m3h2x4(:,866),heltab2x8(:,:,866))
  call Hloop_AV_Q(ntryL,G1H8(869),ex3(:),G1H4(49),m3h2x4(:,867),heltab2x8(:,:,867))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(819),n2h4(272))
  call Hloop_AV_Q(ntryL,G1H8(870),ex3(:),G1H4(49),m3h2x4(:,868),heltab2x8(:,:,868))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(820),n2h4(273))
  call Hloop_AV_Q(ntryL,G1H8(871),ex3(:),G1H4(49),m3h2x4(:,869),heltab2x8(:,:,869))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(821),n2h4(274))
call HGT_OLR(G1H8(872),1,1,8)
call HGT_invQ_OLR(G1H8(872),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(872),-16,nME,G2H8(106),n2h8(524))
  call Hloop_QV_A(ntryL,G2H8(106),ex5(:),G2H4(822),m3h2x4(:,870),heltab2x8(:,:,870))
  call Hloop_AV_Q(ntryL,G1H8(875),ex3(:),G1H4(49),m3h2x4(:,871),heltab2x8(:,:,871))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(823),n2h4(275))
  call Hloop_AV_Q(ntryL,G1H8(876),ex3(:),G1H4(49),m3h2x4(:,872),heltab2x8(:,:,872))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(824),n2h4(276))
  call Hloop_SV_T(ntryL,G1H8(877),35,ex3(:),4,G2H4(825),m3h2x4(:,873),heltab2x8(:,:,873))
call HGT_OLR(G1H8(878),1,1,8)
call HGT_invQ_OLR(G1H8(878),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(878),-16,ex5(:),16,G2H4(826),m3h2x4(:,874),heltab2x8(:,:,874))
  call Hloop_SV_T(ntryL,G1H8(881),35,ex3(:),4,G2H4(827),m3h2x4(:,875),heltab2x8(:,:,875))
  call Hloop_SV_T(ntryL,G1H8(882),35,ex3(:),4,G2H4(828),m3h2x4(:,876),heltab2x8(:,:,876))
  call Hloop_AV_Q(ntryL,G1H8(883),ex3(:),G1H4(49),m3h2x4(:,877),heltab2x8(:,:,877))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(829),n2h4(277))
call HGT_OLR(G1H8(884),1,1,8)
call HGT_invQ_OLR(G1H8(884),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(884),-16,nME,G2H8(107),n2h8(526))
  call Hloop_QV_A(ntryL,G2H8(107),ex5(:),G2H4(830),m3h2x4(:,878),heltab2x8(:,:,878))
  call Hloop_AV_Q(ntryL,G1H8(887),ex3(:),G1H4(49),m3h2x4(:,879),heltab2x8(:,:,879))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(831),n2h4(278))
  call Hloop_AV_Q(ntryL,G1H8(888),ex3(:),G1H4(49),m3h2x4(:,880),heltab2x8(:,:,880))
  call Hloop_A_Q(ntryL,G1H4(49),39,nME,G2H4(832),n2h4(279))
  call Hloop_SV_T(ntryL,G1H8(889),35,ex3(:),4,G2H4(833),m3h2x4(:,881),heltab2x8(:,:,881))
call HGT_raise_alpha_OLR(G1H8(890),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(890),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(890),ex5(:),G1H4(49),m3h2x4(:,882),heltab2x8(:,:,882))
  call Hloop_SV_T(ntryL,G1H8(893),35,ex3(:),4,G2H4(834),m3h2x4(:,883),heltab2x8(:,:,883))
  call Hloop_SV_T(ntryL,G1H8(894),35,ex3(:),4,G2H4(835),m3h2x4(:,884),heltab2x8(:,:,884))
  call Hloop_SV_T(ntryL,G1H8(895),35,ex3(:),4,G2H4(836),m3h2x4(:,885),heltab2x8(:,:,885))
call HGT_OLR(G1H8(896),1,1,8)
call HGT_invQ_OLR(G1H8(896),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(896),ex5(:),G1H4(50),m3h2x4(:,886),heltab2x8(:,:,886))
  call Hloop_SV_T(ntryL,G1H8(899),35,ex3(:),4,G2H4(837),m3h2x4(:,887),heltab2x8(:,:,887))
  call Hloop_SV_T(ntryL,G1H8(900),35,ex3(:),4,G2H4(838),m3h2x4(:,888),heltab2x8(:,:,888))
  call Hloop_SV_T(ntryL,G1H8(901),35,ex3(:),4,G2H4(839),m3h2x4(:,889),heltab2x8(:,:,889))
call HGT_raise_alpha_OLR(G1H8(902),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(902),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(902),-16,ex5(:),16,G2H4(840),m3h2x4(:,890),heltab2x8(:,:,890))
  call Hloop_SV_T(ntryL,G1H8(905),35,ex3(:),4,G2H4(841),m3h2x4(:,891),heltab2x8(:,:,891))
  call Hloop_SV_T(ntryL,G1H8(906),35,ex3(:),4,G2H4(842),m3h2x4(:,892),heltab2x8(:,:,892))
  call Hloop_UW_V(ntryL,G1H8(907),35,ex3(:),4,G2H4(843),m3h2x4(:,893),heltab2x8(:,:,893))
call HGT_OLR(G1H8(908),1,1,8)
call HGT_invQ_OLR(G1H8(908),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(908),-16,ex5(:),16,G2H4(844),m3h2x4(:,894),heltab2x8(:,:,894))
  call Hloop_UW_V(ntryL,G1H8(911),35,ex3(:),4,G2H4(845),m3h2x4(:,895),heltab2x8(:,:,895))
  call Hloop_UW_V(ntryL,G1H8(912),35,ex3(:),4,G2H4(846),m3h2x4(:,896),heltab2x8(:,:,896))
  call Hloop_UW_V(ntryL,G1H8(913),35,ex3(:),4,G2H4(847),m3h2x4(:,897),heltab2x8(:,:,897))
call HGT_raise_alpha_OLR(G1H8(914),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(914),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(914),ex5(:),G1H4(51),m3h2x4(:,898),heltab2x8(:,:,898))
  call Hloop_UW_V(ntryL,G1H8(917),35,ex3(:),4,G2H4(848),m3h2x4(:,899),heltab2x8(:,:,899))
  call Hloop_UW_V(ntryL,G1H8(918),35,ex3(:),4,G2H4(849),m3h2x4(:,900),heltab2x8(:,:,900))
  call Hloop_UW_V(ntryL,G1H8(919),35,ex3(:),4,G2H4(850),m3h2x4(:,901),heltab2x8(:,:,901))
call HGT_OLR(G1H8(920),1,1,8)
call HGT_invQ_OLR(G1H8(920),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(920),ex5(:),G1H4(52),m3h2x4(:,902),heltab2x8(:,:,902))
  call Hloop_UW_V(ntryL,G1H8(923),35,ex3(:),4,G2H4(851),m3h2x4(:,903),heltab2x8(:,:,903))
  call Hloop_UW_V(ntryL,G1H8(924),35,ex3(:),4,G2H4(852),m3h2x4(:,904),heltab2x8(:,:,904))
  call Hloop_UW_V(ntryL,G1H8(925),35,ex3(:),4,G2H4(853),m3h2x4(:,905),heltab2x8(:,:,905))
call HGT_raise_alpha_OLR(G1H8(926),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(926),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(926),-16,ex5(:),16,G2H4(854),m3h2x4(:,906),heltab2x8(:,:,906))
  call Hloop_UW_V(ntryL,G1H8(929),35,ex3(:),4,G2H4(855),m3h2x4(:,907),heltab2x8(:,:,907))
  call Hloop_UW_V(ntryL,G1H8(930),35,ex3(:),4,G2H4(856),m3h2x4(:,908),heltab2x8(:,:,908))
  call Hloop_AV_Q(ntryL,G1H8(931),ex3(:),G1H4(53),m3h2x4(:,909),heltab2x8(:,:,909))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(857),n2h4(280))
call HGT_OLR(G1H8(932),1,1,8)
call HGT_invQ_OLR(G1H8(932),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(932),-8,nME,G2H8(108),n2h8(534))
  call Hloop_QV_A(ntryL,G2H8(108),ex4(:),G2H4(858),m3h2x4(:,910),heltab2x8(:,:,910))
  call Hloop_AV_Q(ntryL,G1H8(935),ex3(:),G1H4(53),m3h2x4(:,911),heltab2x8(:,:,911))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(859),n2h4(281))
  call Hloop_AV_Q(ntryL,G1H8(936),ex3(:),G1H4(53),m3h2x4(:,912),heltab2x8(:,:,912))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(860),n2h4(282))
  call Hloop_AV_Q(ntryL,G1H8(937),ex3(:),G1H4(53),m3h2x4(:,913),heltab2x8(:,:,913))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(861),n2h4(283))
call HGT_OLR(G1H8(938),1,1,8)
call HGT_invQ_OLR(G1H8(938),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(938),-8,nME,G2H8(109),n2h8(535))
  call Hloop_QV_A(ntryL,G2H8(109),ex4(:),G2H4(862),m3h2x4(:,914),heltab2x8(:,:,914))
  call Hloop_AV_Q(ntryL,G1H8(941),ex3(:),G1H4(53),m3h2x4(:,915),heltab2x8(:,:,915))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(863),n2h4(284))
  call Hloop_AV_Q(ntryL,G1H8(942),ex3(:),G1H4(53),m3h2x4(:,916),heltab2x8(:,:,916))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(864),n2h4(285))
  call Hloop_SV_T(ntryL,G1H8(943),35,ex3(:),4,G2H4(865),m3h2x4(:,917),heltab2x8(:,:,917))
call HGT_OLR(G1H8(944),1,1,8)
call HGT_invQ_OLR(G1H8(944),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(944),-8,ex4(:),8,G2H4(866),m3h2x4(:,918),heltab2x8(:,:,918))
  call Hloop_SV_T(ntryL,G1H8(947),35,ex3(:),4,G2H4(867),m3h2x4(:,919),heltab2x8(:,:,919))
  call Hloop_SV_T(ntryL,G1H8(948),35,ex3(:),4,G2H4(868),m3h2x4(:,920),heltab2x8(:,:,920))
  call Hloop_AV_Q(ntryL,G1H8(949),ex3(:),G1H4(53),m3h2x4(:,921),heltab2x8(:,:,921))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(869),n2h4(286))
call HGT_OLR(G1H8(950),1,1,8)
call HGT_invQ_OLR(G1H8(950),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(950),-8,nME,G2H8(110),n2h8(537))
  call Hloop_QV_A(ntryL,G2H8(110),ex4(:),G2H4(870),m3h2x4(:,922),heltab2x8(:,:,922))
  call Hloop_AV_Q(ntryL,G1H8(953),ex3(:),G1H4(53),m3h2x4(:,923),heltab2x8(:,:,923))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(871),n2h4(287))
  call Hloop_AV_Q(ntryL,G1H8(954),ex3(:),G1H4(53),m3h2x4(:,924),heltab2x8(:,:,924))
  call Hloop_A_Q(ntryL,G1H4(53),39,nME,G2H4(872),n2h4(288))
  call Hloop_SV_T(ntryL,G1H8(955),35,ex3(:),4,G2H4(873),m3h2x4(:,925),heltab2x8(:,:,925))
call HGT_raise_alpha_OLR(G1H8(956),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(956),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(956),ex4(:),G1H4(53),m3h2x4(:,926),heltab2x8(:,:,926))
  call Hloop_SV_T(ntryL,G1H8(959),35,ex3(:),4,G2H4(874),m3h2x4(:,927),heltab2x8(:,:,927))
  call Hloop_SV_T(ntryL,G1H8(960),35,ex3(:),4,G2H4(875),m3h2x4(:,928),heltab2x8(:,:,928))
  call Hloop_SV_T(ntryL,G1H8(961),35,ex3(:),4,G2H4(876),m3h2x4(:,929),heltab2x8(:,:,929))
call HGT_OLR(G1H8(962),1,1,8)
call HGT_invQ_OLR(G1H8(962),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(962),ex4(:),G1H4(54),m3h2x4(:,930),heltab2x8(:,:,930))
  call Hloop_SV_T(ntryL,G1H8(965),35,ex3(:),4,G2H4(877),m3h2x4(:,931),heltab2x8(:,:,931))
  call Hloop_SV_T(ntryL,G1H8(966),35,ex3(:),4,G2H4(878),m3h2x4(:,932),heltab2x8(:,:,932))
  call Hloop_SV_T(ntryL,G1H8(967),35,ex3(:),4,G2H4(879),m3h2x4(:,933),heltab2x8(:,:,933))
call HGT_raise_alpha_OLR(G1H8(968),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(968),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(968),-8,ex4(:),8,G2H4(880),m3h2x4(:,934),heltab2x8(:,:,934))
  call Hloop_SV_T(ntryL,G1H8(971),35,ex3(:),4,G2H4(881),m3h2x4(:,935),heltab2x8(:,:,935))
  call Hloop_SV_T(ntryL,G1H8(972),35,ex3(:),4,G2H4(882),m3h2x4(:,936),heltab2x8(:,:,936))
  call Hloop_UW_V(ntryL,G1H8(973),35,ex3(:),4,G2H4(883),m3h2x4(:,937),heltab2x8(:,:,937))
call HGT_OLR(G1H8(974),1,1,8)
call HGT_invQ_OLR(G1H8(974),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(974),-8,ex4(:),8,G2H4(884),m3h2x4(:,938),heltab2x8(:,:,938))
  call Hloop_UW_V(ntryL,G1H8(977),35,ex3(:),4,G2H4(885),m3h2x4(:,939),heltab2x8(:,:,939))
  call Hloop_UW_V(ntryL,G1H8(978),35,ex3(:),4,G2H4(886),m3h2x4(:,940),heltab2x8(:,:,940))
  call Hloop_UW_V(ntryL,G1H8(979),35,ex3(:),4,G2H4(887),m3h2x4(:,941),heltab2x8(:,:,941))
call HGT_raise_alpha_OLR(G1H8(980),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(980),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(980),ex4(:),G1H4(55),m3h2x4(:,942),heltab2x8(:,:,942))
  call Hloop_UW_V(ntryL,G1H8(983),35,ex3(:),4,G2H4(888),m3h2x4(:,943),heltab2x8(:,:,943))
  call Hloop_UW_V(ntryL,G1H8(984),35,ex3(:),4,G2H4(889),m3h2x4(:,944),heltab2x8(:,:,944))
  call Hloop_UW_V(ntryL,G1H8(985),35,ex3(:),4,G2H4(890),m3h2x4(:,945),heltab2x8(:,:,945))
call HGT_OLR(G1H8(986),1,1,8)
call HGT_invQ_OLR(G1H8(986),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(986),ex4(:),G1H4(56),m3h2x4(:,946),heltab2x8(:,:,946))
  call Hloop_UW_V(ntryL,G1H8(989),35,ex3(:),4,G2H4(891),m3h2x4(:,947),heltab2x8(:,:,947))
  call Hloop_UW_V(ntryL,G1H8(990),35,ex3(:),4,G2H4(892),m3h2x4(:,948),heltab2x8(:,:,948))
  call Hloop_UW_V(ntryL,G1H8(991),35,ex3(:),4,G2H4(893),m3h2x4(:,949),heltab2x8(:,:,949))
call HGT_raise_alpha_OLR(G1H8(992),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(992),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(992),-8,ex4(:),8,G2H4(894),m3h2x4(:,950),heltab2x8(:,:,950))
  call Hloop_UW_V(ntryL,G1H8(995),35,ex3(:),4,G2H4(895),m3h2x4(:,951),heltab2x8(:,:,951))
  call Hloop_UW_V(ntryL,G1H8(996),35,ex3(:),4,G2H4(896),m3h2x4(:,952),heltab2x8(:,:,952))
  call Hloop_AV_Q(ntryL,G1H8(997),ex4(:),G1H4(57),m3h2x4(:,953),heltab2x8(:,:,953))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(897),n2h4(289))
call HGT_OLR(G1H8(998),1,1,8)
call HGT_invQ_OLR(G1H8(998),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(998),-16,nME,G2H8(112),n2h8(545))
  call Hloop_QV_A(ntryL,G2H8(112),ex5(:),G2H4(898),m3h2x4(:,954),heltab2x8(:,:,954))
  call Hloop_AV_Q(ntryL,G1H8(1001),ex4(:),G1H4(57),m3h2x4(:,955),heltab2x8(:,:,955))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(899),n2h4(290))
  call Hloop_AV_Q(ntryL,G1H8(1002),ex4(:),G1H4(57),m3h2x4(:,956),heltab2x8(:,:,956))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(900),n2h4(291))
  call Hloop_AV_Q(ntryL,G1H8(1003),ex4(:),G1H4(57),m3h2x4(:,957),heltab2x8(:,:,957))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(901),n2h4(292))
call HGT_OLR(G1H8(1004),1,1,8)
call HGT_invQ_OLR(G1H8(1004),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1004),-16,nME,G2H8(114),n2h8(546))
  call Hloop_QV_A(ntryL,G2H8(114),ex5(:),G2H4(902),m3h2x4(:,958),heltab2x8(:,:,958))
  call Hloop_AV_Q(ntryL,G1H8(1007),ex4(:),G1H4(57),m3h2x4(:,959),heltab2x8(:,:,959))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(903),n2h4(293))
  call Hloop_AV_Q(ntryL,G1H8(1008),ex4(:),G1H4(57),m3h2x4(:,960),heltab2x8(:,:,960))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(904),n2h4(294))
  call Hloop_SV_T(ntryL,G1H8(1009),35,ex4(:),8,G2H4(905),m3h2x4(:,961),heltab2x8(:,:,961))
call HGT_OLR(G1H8(1010),1,1,8)
call HGT_invQ_OLR(G1H8(1010),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1010),-16,ex5(:),16,G2H4(906),m3h2x4(:,962),heltab2x8(:,:,962))
  call Hloop_SV_T(ntryL,G1H8(1013),35,ex4(:),8,G2H4(907),m3h2x4(:,963),heltab2x8(:,:,963))
  call Hloop_SV_T(ntryL,G1H8(1014),35,ex4(:),8,G2H4(908),m3h2x4(:,964),heltab2x8(:,:,964))
  call Hloop_AV_Q(ntryL,G1H8(1015),ex4(:),G1H4(57),m3h2x4(:,965),heltab2x8(:,:,965))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(909),n2h4(295))
call HGT_OLR(G1H8(1016),1,1,8)
call HGT_invQ_OLR(G1H8(1016),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1016),-16,nME,G2H8(117),n2h8(548))
  call Hloop_QV_A(ntryL,G2H8(117),ex5(:),G2H4(910),m3h2x4(:,966),heltab2x8(:,:,966))
  call Hloop_AV_Q(ntryL,G1H8(1019),ex4(:),G1H4(57),m3h2x4(:,967),heltab2x8(:,:,967))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(911),n2h4(296))
  call Hloop_AV_Q(ntryL,G1H8(1020),ex4(:),G1H4(57),m3h2x4(:,968),heltab2x8(:,:,968))
  call Hloop_A_Q(ntryL,G1H4(57),43,nME,G2H4(912),n2h4(297))
  call Hloop_SV_T(ntryL,G1H8(1021),35,ex4(:),8,G2H4(913),m3h2x4(:,969),heltab2x8(:,:,969))
call HGT_raise_alpha_OLR(G1H8(1022),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1022),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1022),ex5(:),G1H4(57),m3h2x4(:,970),heltab2x8(:,:,970))
  call Hloop_SV_T(ntryL,G1H8(1025),35,ex4(:),8,G2H4(914),m3h2x4(:,971),heltab2x8(:,:,971))
  call Hloop_SV_T(ntryL,G1H8(1026),35,ex4(:),8,G2H4(915),m3h2x4(:,972),heltab2x8(:,:,972))
  call Hloop_SV_T(ntryL,G1H8(1027),35,ex4(:),8,G2H4(916),m3h2x4(:,973),heltab2x8(:,:,973))
call HGT_OLR(G1H8(1028),1,1,8)
call HGT_invQ_OLR(G1H8(1028),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1028),ex5(:),G1H4(58),m3h2x4(:,974),heltab2x8(:,:,974))
  call Hloop_SV_T(ntryL,G1H8(1031),35,ex4(:),8,G2H4(917),m3h2x4(:,975),heltab2x8(:,:,975))
  call Hloop_SV_T(ntryL,G1H8(1032),35,ex4(:),8,G2H4(918),m3h2x4(:,976),heltab2x8(:,:,976))
  call Hloop_SV_T(ntryL,G1H8(1033),35,ex4(:),8,G2H4(919),m3h2x4(:,977),heltab2x8(:,:,977))
call HGT_raise_alpha_OLR(G1H8(1034),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1034),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1034),-16,ex5(:),16,G2H4(920),m3h2x4(:,978),heltab2x8(:,:,978))
  call Hloop_SV_T(ntryL,G1H8(1037),35,ex4(:),8,G2H4(921),m3h2x4(:,979),heltab2x8(:,:,979))
  call Hloop_SV_T(ntryL,G1H8(1038),35,ex4(:),8,G2H4(922),m3h2x4(:,980),heltab2x8(:,:,980))
  call Hloop_UW_V(ntryL,G1H8(1039),35,ex4(:),8,G2H4(923),m3h2x4(:,981),heltab2x8(:,:,981))
call HGT_OLR(G1H8(1040),1,1,8)
call HGT_invQ_OLR(G1H8(1040),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1040),-16,ex5(:),16,G2H4(924),m3h2x4(:,982),heltab2x8(:,:,982))
  call Hloop_UW_V(ntryL,G1H8(1043),35,ex4(:),8,G2H4(925),m3h2x4(:,983),heltab2x8(:,:,983))
  call Hloop_UW_V(ntryL,G1H8(1044),35,ex4(:),8,G2H4(926),m3h2x4(:,984),heltab2x8(:,:,984))
  call Hloop_UW_V(ntryL,G1H8(1045),35,ex4(:),8,G2H4(927),m3h2x4(:,985),heltab2x8(:,:,985))
call HGT_raise_alpha_OLR(G1H8(1046),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1046),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1046),ex5(:),G1H4(59),m3h2x4(:,986),heltab2x8(:,:,986))
  call Hloop_UW_V(ntryL,G1H8(1049),35,ex4(:),8,G2H4(928),m3h2x4(:,987),heltab2x8(:,:,987))
  call Hloop_UW_V(ntryL,G1H8(1050),35,ex4(:),8,G2H4(929),m3h2x4(:,988),heltab2x8(:,:,988))
  call Hloop_UW_V(ntryL,G1H8(1051),35,ex4(:),8,G2H4(930),m3h2x4(:,989),heltab2x8(:,:,989))
call HGT_OLR(G1H8(1052),1,1,8)
call HGT_invQ_OLR(G1H8(1052),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1052),ex5(:),G1H4(60),m3h2x4(:,990),heltab2x8(:,:,990))
  call Hloop_UW_V(ntryL,G1H8(1055),35,ex4(:),8,G2H4(931),m3h2x4(:,991),heltab2x8(:,:,991))
  call Hloop_UW_V(ntryL,G1H8(1056),35,ex4(:),8,G2H4(932),m3h2x4(:,992),heltab2x8(:,:,992))
  call Hloop_UW_V(ntryL,G1H8(1057),35,ex4(:),8,G2H4(933),m3h2x4(:,993),heltab2x8(:,:,993))
call HGT_raise_alpha_OLR(G1H8(1058),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1058),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1058),-16,ex5(:),16,G2H4(934),m3h2x4(:,994),heltab2x8(:,:,994))
  call Hloop_UW_V(ntryL,G1H8(1061),35,ex4(:),8,G2H4(935),m3h2x4(:,995),heltab2x8(:,:,995))
  call Hloop_UW_V(ntryL,G1H8(1062),35,ex4(:),8,G2H4(936),m3h2x4(:,996),heltab2x8(:,:,996))
  call Hloop_AV_Q(ntryL,G1H8(1063),ex4(:),G1H4(61),m3h2x4(:,997),heltab2x8(:,:,997))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(937),n2h4(298))
call HGT_OLR(G1H8(1064),1,1,8)
call HGT_invQ_OLR(G1H8(1064),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1064),-4,nME,G2H8(118),n2h8(556))
  call Hloop_QV_A(ntryL,G2H8(118),ex3(:),G2H4(938),m3h2x4(:,998),heltab2x8(:,:,998))
  call Hloop_AV_Q(ntryL,G1H8(1067),ex4(:),G1H4(61),m3h2x4(:,999),heltab2x8(:,:,999))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(939),n2h4(299))
  call Hloop_AV_Q(ntryL,G1H8(1068),ex4(:),G1H4(61),m3h2x4(:,1000),heltab2x8(:,:,1000))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(940),n2h4(300))
  call Hloop_AV_Q(ntryL,G1H8(1069),ex4(:),G1H4(61),m3h2x4(:,1001),heltab2x8(:,:,1001))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(941),n2h4(301))
call HGT_OLR(G1H8(1070),1,1,8)
call HGT_invQ_OLR(G1H8(1070),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1070),-4,nME,G2H8(121),n2h8(557))
  call Hloop_QV_A(ntryL,G2H8(121),ex3(:),G2H4(942),m3h2x4(:,1002),heltab2x8(:,:,1002))
  call Hloop_AV_Q(ntryL,G1H8(1073),ex4(:),G1H4(61),m3h2x4(:,1003),heltab2x8(:,:,1003))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(943),n2h4(302))
  call Hloop_AV_Q(ntryL,G1H8(1074),ex4(:),G1H4(61),m3h2x4(:,1004),heltab2x8(:,:,1004))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(944),n2h4(303))
  call Hloop_SV_T(ntryL,G1H8(1075),35,ex4(:),8,G2H4(945),m3h2x4(:,1005),heltab2x8(:,:,1005))
call HGT_OLR(G1H8(1076),1,1,8)
call HGT_invQ_OLR(G1H8(1076),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1076),-4,ex3(:),4,G2H4(946),m3h2x4(:,1006),heltab2x8(:,:,1006))
  call Hloop_SV_T(ntryL,G1H8(1079),35,ex4(:),8,G2H4(947),m3h2x4(:,1007),heltab2x8(:,:,1007))
  call Hloop_SV_T(ntryL,G1H8(1080),35,ex4(:),8,G2H4(948),m3h2x4(:,1008),heltab2x8(:,:,1008))
  call Hloop_AV_Q(ntryL,G1H8(1081),ex4(:),G1H4(61),m3h2x4(:,1009),heltab2x8(:,:,1009))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(949),n2h4(304))
call HGT_OLR(G1H8(1082),1,1,8)
call HGT_invQ_OLR(G1H8(1082),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1082),-4,nME,G2H8(122),n2h8(559))
  call Hloop_QV_A(ntryL,G2H8(122),ex3(:),G2H4(950),m3h2x4(:,1010),heltab2x8(:,:,1010))
  call Hloop_AV_Q(ntryL,G1H8(1085),ex4(:),G1H4(61),m3h2x4(:,1011),heltab2x8(:,:,1011))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(951),n2h4(305))
  call Hloop_AV_Q(ntryL,G1H8(1086),ex4(:),G1H4(61),m3h2x4(:,1012),heltab2x8(:,:,1012))
  call Hloop_A_Q(ntryL,G1H4(61),43,nME,G2H4(952),n2h4(306))
  call Hloop_SV_T(ntryL,G1H8(1087),35,ex4(:),8,G2H4(953),m3h2x4(:,1013),heltab2x8(:,:,1013))
call HGT_raise_alpha_OLR(G1H8(1088),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1088),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1088),ex3(:),G1H4(61),m3h2x4(:,1014),heltab2x8(:,:,1014))
  call Hloop_SV_T(ntryL,G1H8(1091),35,ex4(:),8,G2H4(954),m3h2x4(:,1015),heltab2x8(:,:,1015))
  call Hloop_SV_T(ntryL,G1H8(1092),35,ex4(:),8,G2H4(955),m3h2x4(:,1016),heltab2x8(:,:,1016))
  call Hloop_SV_T(ntryL,G1H8(1093),35,ex4(:),8,G2H4(956),m3h2x4(:,1017),heltab2x8(:,:,1017))
call HGT_OLR(G1H8(1094),1,1,8)
call HGT_invQ_OLR(G1H8(1094),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1094),ex3(:),G1H4(62),m3h2x4(:,1018),heltab2x8(:,:,1018))
  call Hloop_SV_T(ntryL,G1H8(1097),35,ex4(:),8,G2H4(957),m3h2x4(:,1019),heltab2x8(:,:,1019))
  call Hloop_SV_T(ntryL,G1H8(1098),35,ex4(:),8,G2H4(958),m3h2x4(:,1020),heltab2x8(:,:,1020))
  call Hloop_SV_T(ntryL,G1H8(1099),35,ex4(:),8,G2H4(959),m3h2x4(:,1021),heltab2x8(:,:,1021))
call HGT_raise_alpha_OLR(G1H8(1100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1100),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1100),-4,ex3(:),4,G2H4(960),m3h2x4(:,1022),heltab2x8(:,:,1022))
  call Hloop_SV_T(ntryL,G1H8(1103),35,ex4(:),8,G2H4(961),m3h2x4(:,1023),heltab2x8(:,:,1023))
  call Hloop_SV_T(ntryL,G1H8(1104),35,ex4(:),8,G2H4(962),m3h2x4(:,1024),heltab2x8(:,:,1024))
  call Hloop_UW_V(ntryL,G1H8(1105),35,ex4(:),8,G2H4(963),m3h2x4(:,1025),heltab2x8(:,:,1025))
call HGT_OLR(G1H8(1106),1,1,8)
call HGT_invQ_OLR(G1H8(1106),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1106),-4,ex3(:),4,G2H4(964),m3h2x4(:,1026),heltab2x8(:,:,1026))
  call Hloop_UW_V(ntryL,G1H8(1109),35,ex4(:),8,G2H4(965),m3h2x4(:,1027),heltab2x8(:,:,1027))
  call Hloop_UW_V(ntryL,G1H8(1110),35,ex4(:),8,G2H4(966),m3h2x4(:,1028),heltab2x8(:,:,1028))
  call Hloop_UW_V(ntryL,G1H8(1111),35,ex4(:),8,G2H4(967),m3h2x4(:,1029),heltab2x8(:,:,1029))
call HGT_raise_alpha_OLR(G1H8(1112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1112),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1112),ex3(:),G1H4(63),m3h2x4(:,1030),heltab2x8(:,:,1030))
  call Hloop_UW_V(ntryL,G1H8(1115),35,ex4(:),8,G2H4(968),m3h2x4(:,1031),heltab2x8(:,:,1031))
  call Hloop_UW_V(ntryL,G1H8(1116),35,ex4(:),8,G2H4(969),m3h2x4(:,1032),heltab2x8(:,:,1032))
  call Hloop_UW_V(ntryL,G1H8(1117),35,ex4(:),8,G2H4(970),m3h2x4(:,1033),heltab2x8(:,:,1033))
call HGT_OLR(G1H8(1118),1,1,8)
call HGT_invQ_OLR(G1H8(1118),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1118),ex3(:),G1H4(64),m3h2x4(:,1034),heltab2x8(:,:,1034))
  call Hloop_UW_V(ntryL,G1H8(1121),35,ex4(:),8,G2H4(971),m3h2x4(:,1035),heltab2x8(:,:,1035))
  call Hloop_UW_V(ntryL,G1H8(1122),35,ex4(:),8,G2H4(972),m3h2x4(:,1036),heltab2x8(:,:,1036))
  call Hloop_UW_V(ntryL,G1H8(1123),35,ex4(:),8,G2H4(973),m3h2x4(:,1037),heltab2x8(:,:,1037))
call HGT_raise_alpha_OLR(G1H8(1124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1124),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1124),-4,ex3(:),4,G2H4(974),m3h2x4(:,1038),heltab2x8(:,:,1038))
  call Hloop_UW_V(ntryL,G1H8(1127),35,ex4(:),8,G2H4(975),m3h2x4(:,1039),heltab2x8(:,:,1039))
  call Hloop_UW_V(ntryL,G1H8(1128),35,ex4(:),8,G2H4(976),m3h2x4(:,1040),heltab2x8(:,:,1040))
  call Hloop_AV_Q(ntryL,G1H8(1129),ex5(:),G1H4(65),m3h2x4(:,1041),heltab2x8(:,:,1041))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(977),n2h4(307))
call HGT_OLR(G1H8(1130),1,1,8)
call HGT_invQ_OLR(G1H8(1130),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1130),-8,nME,G2H8(126),n2h8(567))
  call Hloop_QV_A(ntryL,G2H8(126),ex4(:),G2H4(978),m3h2x4(:,1042),heltab2x8(:,:,1042))
  call Hloop_AV_Q(ntryL,G1H8(1133),ex5(:),G1H4(65),m3h2x4(:,1043),heltab2x8(:,:,1043))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(979),n2h4(308))
  call Hloop_AV_Q(ntryL,G1H8(1134),ex5(:),G1H4(65),m3h2x4(:,1044),heltab2x8(:,:,1044))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(980),n2h4(309))
  call Hloop_AV_Q(ntryL,G1H8(1135),ex5(:),G1H4(65),m3h2x4(:,1045),heltab2x8(:,:,1045))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(981),n2h4(310))
call HGT_OLR(G1H8(1136),1,1,8)
call HGT_invQ_OLR(G1H8(1136),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1136),-8,nME,G2H8(146),n2h8(568))
  call Hloop_QV_A(ntryL,G2H8(146),ex4(:),G2H4(982),m3h2x4(:,1046),heltab2x8(:,:,1046))
  call Hloop_AV_Q(ntryL,G1H8(1139),ex5(:),G1H4(65),m3h2x4(:,1047),heltab2x8(:,:,1047))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(983),n2h4(311))
  call Hloop_AV_Q(ntryL,G1H8(1140),ex5(:),G1H4(65),m3h2x4(:,1048),heltab2x8(:,:,1048))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(984),n2h4(312))
  call Hloop_SV_T(ntryL,G1H8(1141),35,ex5(:),16,G2H4(985),m3h2x4(:,1049),heltab2x8(:,:,1049))
call HGT_OLR(G1H8(1142),1,1,8)
call HGT_invQ_OLR(G1H8(1142),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1142),-8,ex4(:),8,G2H4(986),m3h2x4(:,1050),heltab2x8(:,:,1050))
  call Hloop_SV_T(ntryL,G1H8(1145),35,ex5(:),16,G2H4(987),m3h2x4(:,1051),heltab2x8(:,:,1051))
  call Hloop_SV_T(ntryL,G1H8(1146),35,ex5(:),16,G2H4(988),m3h2x4(:,1052),heltab2x8(:,:,1052))
  call Hloop_AV_Q(ntryL,G1H8(1147),ex5(:),G1H4(65),m3h2x4(:,1053),heltab2x8(:,:,1053))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(989),n2h4(313))
call HGT_OLR(G1H8(1148),1,1,8)
call HGT_invQ_OLR(G1H8(1148),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1148),-8,nME,G2H8(165),n2h8(570))
  call Hloop_QV_A(ntryL,G2H8(165),ex4(:),G2H4(990),m3h2x4(:,1054),heltab2x8(:,:,1054))
  call Hloop_AV_Q(ntryL,G1H8(1151),ex5(:),G1H4(65),m3h2x4(:,1055),heltab2x8(:,:,1055))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(991),n2h4(314))
  call Hloop_AV_Q(ntryL,G1H8(1152),ex5(:),G1H4(65),m3h2x4(:,1056),heltab2x8(:,:,1056))
  call Hloop_A_Q(ntryL,G1H4(65),51,nME,G2H4(992),n2h4(315))
  call Hloop_SV_T(ntryL,G1H8(1153),35,ex5(:),16,G2H4(993),m3h2x4(:,1057),heltab2x8(:,:,1057))
call HGT_raise_alpha_OLR(G1H8(1154),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1154),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1154),ex4(:),G1H4(65),m3h2x4(:,1058),heltab2x8(:,:,1058))
  call Hloop_SV_T(ntryL,G1H8(1157),35,ex5(:),16,G2H4(994),m3h2x4(:,1059),heltab2x8(:,:,1059))
  call Hloop_SV_T(ntryL,G1H8(1158),35,ex5(:),16,G2H4(995),m3h2x4(:,1060),heltab2x8(:,:,1060))
  call Hloop_SV_T(ntryL,G1H8(1159),35,ex5(:),16,G2H4(996),m3h2x4(:,1061),heltab2x8(:,:,1061))
call HGT_OLR(G1H8(1160),1,1,8)
call HGT_invQ_OLR(G1H8(1160),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1160),ex4(:),G1H4(66),m3h2x4(:,1062),heltab2x8(:,:,1062))
  call Hloop_SV_T(ntryL,G1H8(1163),35,ex5(:),16,G2H4(997),m3h2x4(:,1063),heltab2x8(:,:,1063))
  call Hloop_SV_T(ntryL,G1H8(1164),35,ex5(:),16,G2H4(998),m3h2x4(:,1064),heltab2x8(:,:,1064))
  call Hloop_SV_T(ntryL,G1H8(1165),35,ex5(:),16,G2H4(999),m3h2x4(:,1065),heltab2x8(:,:,1065))
call HGT_raise_alpha_OLR(G1H8(1166),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1166),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1166),-8,ex4(:),8,G2H4(1000),m3h2x4(:,1066),heltab2x8(:,:,1066))
  call Hloop_SV_T(ntryL,G1H8(1169),35,ex5(:),16,G2H4(1001),m3h2x4(:,1067),heltab2x8(:,:,1067))
  call Hloop_SV_T(ntryL,G1H8(1170),35,ex5(:),16,G2H4(1002),m3h2x4(:,1068),heltab2x8(:,:,1068))
  call Hloop_UW_V(ntryL,G1H8(1171),35,ex5(:),16,G2H4(1003),m3h2x4(:,1069),heltab2x8(:,:,1069))
call HGT_OLR(G1H8(1172),1,1,8)
call HGT_invQ_OLR(G1H8(1172),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1172),-8,ex4(:),8,G2H4(1004),m3h2x4(:,1070),heltab2x8(:,:,1070))
  call Hloop_UW_V(ntryL,G1H8(1175),35,ex5(:),16,G2H4(1005),m3h2x4(:,1071),heltab2x8(:,:,1071))
  call Hloop_UW_V(ntryL,G1H8(1176),35,ex5(:),16,G2H4(1006),m3h2x4(:,1072),heltab2x8(:,:,1072))
  call Hloop_UW_V(ntryL,G1H8(1177),35,ex5(:),16,G2H4(1007),m3h2x4(:,1073),heltab2x8(:,:,1073))
call HGT_raise_alpha_OLR(G1H8(1178),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1178),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1178),ex4(:),G1H4(67),m3h2x4(:,1074),heltab2x8(:,:,1074))
  call Hloop_UW_V(ntryL,G1H8(1181),35,ex5(:),16,G2H4(1008),m3h2x4(:,1075),heltab2x8(:,:,1075))
  call Hloop_UW_V(ntryL,G1H8(1182),35,ex5(:),16,G2H4(1009),m3h2x4(:,1076),heltab2x8(:,:,1076))
  call Hloop_UW_V(ntryL,G1H8(1183),35,ex5(:),16,G2H4(1010),m3h2x4(:,1077),heltab2x8(:,:,1077))
call HGT_OLR(G1H8(1184),1,1,8)
call HGT_invQ_OLR(G1H8(1184),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1184),ex4(:),G1H4(68),m3h2x4(:,1078),heltab2x8(:,:,1078))
  call Hloop_UW_V(ntryL,G1H8(1187),35,ex5(:),16,G2H4(1011),m3h2x4(:,1079),heltab2x8(:,:,1079))
  call Hloop_UW_V(ntryL,G1H8(1188),35,ex5(:),16,G2H4(1012),m3h2x4(:,1080),heltab2x8(:,:,1080))
  call Hloop_UW_V(ntryL,G1H8(1189),35,ex5(:),16,G2H4(1013),m3h2x4(:,1081),heltab2x8(:,:,1081))
call HGT_raise_alpha_OLR(G1H8(1190),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1190),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1190),-8,ex4(:),8,G2H4(1014),m3h2x4(:,1082),heltab2x8(:,:,1082))
  call Hloop_UW_V(ntryL,G1H8(1193),35,ex5(:),16,G2H4(1015),m3h2x4(:,1083),heltab2x8(:,:,1083))
  call Hloop_UW_V(ntryL,G1H8(1194),35,ex5(:),16,G2H4(1016),m3h2x4(:,1084),heltab2x8(:,:,1084))
  call Hloop_AV_Q(ntryL,G1H8(1195),ex5(:),G1H4(69),m3h2x4(:,1085),heltab2x8(:,:,1085))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1017),n2h4(316))
call HGT_OLR(G1H8(1196),1,1,8)
call HGT_invQ_OLR(G1H8(1196),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1196),-4,nME,G2H8(166),n2h8(578))
  call Hloop_QV_A(ntryL,G2H8(166),ex3(:),G2H4(1018),m3h2x4(:,1086),heltab2x8(:,:,1086))
  call Hloop_AV_Q(ntryL,G1H8(1199),ex5(:),G1H4(69),m3h2x4(:,1087),heltab2x8(:,:,1087))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1019),n2h4(317))
  call Hloop_AV_Q(ntryL,G1H8(1200),ex5(:),G1H4(69),m3h2x4(:,1088),heltab2x8(:,:,1088))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1020),n2h4(318))
  call Hloop_AV_Q(ntryL,G1H8(1201),ex5(:),G1H4(69),m3h2x4(:,1089),heltab2x8(:,:,1089))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1021),n2h4(319))
call HGT_OLR(G1H8(1202),1,1,8)
call HGT_invQ_OLR(G1H8(1202),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1202),-4,nME,G2H8(169),n2h8(579))
  call Hloop_QV_A(ntryL,G2H8(169),ex3(:),G2H4(1022),m3h2x4(:,1090),heltab2x8(:,:,1090))
  call Hloop_AV_Q(ntryL,G1H8(1205),ex5(:),G1H4(69),m3h2x4(:,1091),heltab2x8(:,:,1091))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1023),n2h4(320))
  call Hloop_AV_Q(ntryL,G1H8(1206),ex5(:),G1H4(69),m3h2x4(:,1092),heltab2x8(:,:,1092))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1024),n2h4(321))
  call Hloop_SV_T(ntryL,G1H8(1207),35,ex5(:),16,G2H4(1025),m3h2x4(:,1093),heltab2x8(:,:,1093))
call HGT_OLR(G1H8(1208),1,1,8)
call HGT_invQ_OLR(G1H8(1208),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1208),-4,ex3(:),4,G2H4(1026),m3h2x4(:,1094),heltab2x8(:,:,1094))
  call Hloop_SV_T(ntryL,G1H8(1211),35,ex5(:),16,G2H4(1027),m3h2x4(:,1095),heltab2x8(:,:,1095))
  call Hloop_SV_T(ntryL,G1H8(1212),35,ex5(:),16,G2H4(1028),m3h2x4(:,1096),heltab2x8(:,:,1096))
  call Hloop_AV_Q(ntryL,G1H8(1213),ex5(:),G1H4(69),m3h2x4(:,1097),heltab2x8(:,:,1097))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1029),n2h4(322))
call HGT_OLR(G1H8(1214),1,1,8)
call HGT_invQ_OLR(G1H8(1214),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1214),-4,nME,G2H8(170),n2h8(581))
  call Hloop_QV_A(ntryL,G2H8(170),ex3(:),G2H4(1030),m3h2x4(:,1098),heltab2x8(:,:,1098))
  call Hloop_AV_Q(ntryL,G1H8(1217),ex5(:),G1H4(69),m3h2x4(:,1099),heltab2x8(:,:,1099))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1031),n2h4(323))
  call Hloop_AV_Q(ntryL,G1H8(1218),ex5(:),G1H4(69),m3h2x4(:,1100),heltab2x8(:,:,1100))
  call Hloop_A_Q(ntryL,G1H4(69),51,nME,G2H4(1032),n2h4(324))
  call Hloop_SV_T(ntryL,G1H8(1219),35,ex5(:),16,G2H4(1033),m3h2x4(:,1101),heltab2x8(:,:,1101))
call HGT_raise_alpha_OLR(G1H8(1220),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1220),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1220),ex3(:),G1H4(69),m3h2x4(:,1102),heltab2x8(:,:,1102))
  call Hloop_SV_T(ntryL,G1H8(1223),35,ex5(:),16,G2H4(1034),m3h2x4(:,1103),heltab2x8(:,:,1103))
  call Hloop_SV_T(ntryL,G1H8(1224),35,ex5(:),16,G2H4(1035),m3h2x4(:,1104),heltab2x8(:,:,1104))
  call Hloop_SV_T(ntryL,G1H8(1225),35,ex5(:),16,G2H4(1036),m3h2x4(:,1105),heltab2x8(:,:,1105))
call HGT_OLR(G1H8(1226),1,1,8)
call HGT_invQ_OLR(G1H8(1226),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1226),ex3(:),G1H4(70),m3h2x4(:,1106),heltab2x8(:,:,1106))
  call Hloop_SV_T(ntryL,G1H8(1229),35,ex5(:),16,G2H4(1037),m3h2x4(:,1107),heltab2x8(:,:,1107))
  call Hloop_SV_T(ntryL,G1H8(1230),35,ex5(:),16,G2H4(1038),m3h2x4(:,1108),heltab2x8(:,:,1108))
  call Hloop_SV_T(ntryL,G1H8(1231),35,ex5(:),16,G2H4(1039),m3h2x4(:,1109),heltab2x8(:,:,1109))
call HGT_raise_alpha_OLR(G1H8(1232),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1232),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1232),-4,ex3(:),4,G2H4(1040),m3h2x4(:,1110),heltab2x8(:,:,1110))
  call Hloop_SV_T(ntryL,G1H8(1235),35,ex5(:),16,G2H4(1041),m3h2x4(:,1111),heltab2x8(:,:,1111))
  call Hloop_SV_T(ntryL,G1H8(1236),35,ex5(:),16,G2H4(1042),m3h2x4(:,1112),heltab2x8(:,:,1112))
  call Hloop_UW_V(ntryL,G1H8(1237),35,ex5(:),16,G2H4(1043),m3h2x4(:,1113),heltab2x8(:,:,1113))
call HGT_OLR(G1H8(1238),1,1,8)
call HGT_invQ_OLR(G1H8(1238),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1238),-4,ex3(:),4,G2H4(1044),m3h2x4(:,1114),heltab2x8(:,:,1114))
  call Hloop_UW_V(ntryL,G1H8(1241),35,ex5(:),16,G2H4(1045),m3h2x4(:,1115),heltab2x8(:,:,1115))
  call Hloop_UW_V(ntryL,G1H8(1242),35,ex5(:),16,G2H4(1046),m3h2x4(:,1116),heltab2x8(:,:,1116))
  call Hloop_UW_V(ntryL,G1H8(1243),35,ex5(:),16,G2H4(1047),m3h2x4(:,1117),heltab2x8(:,:,1117))
call HGT_raise_alpha_OLR(G1H8(1244),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1244),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1244),ex3(:),G1H4(71),m3h2x4(:,1118),heltab2x8(:,:,1118))
  call Hloop_UW_V(ntryL,G1H8(1247),35,ex5(:),16,G2H4(1048),m3h2x4(:,1119),heltab2x8(:,:,1119))
  call Hloop_UW_V(ntryL,G1H8(1248),35,ex5(:),16,G2H4(1049),m3h2x4(:,1120),heltab2x8(:,:,1120))
  call Hloop_UW_V(ntryL,G1H8(1249),35,ex5(:),16,G2H4(1050),m3h2x4(:,1121),heltab2x8(:,:,1121))
call HGT_OLR(G1H8(1250),1,1,8)
call HGT_invQ_OLR(G1H8(1250),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1250),ex3(:),G1H4(72),m3h2x4(:,1122),heltab2x8(:,:,1122))
  call Hloop_UW_V(ntryL,G1H8(1253),35,ex5(:),16,G2H4(1051),m3h2x4(:,1123),heltab2x8(:,:,1123))
  call Hloop_UW_V(ntryL,G1H8(1254),35,ex5(:),16,G2H4(1052),m3h2x4(:,1124),heltab2x8(:,:,1124))
  call Hloop_UW_V(ntryL,G1H8(1255),35,ex5(:),16,G2H4(1053),m3h2x4(:,1125),heltab2x8(:,:,1125))
call HGT_raise_alpha_OLR(G1H8(1256),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1256),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1256),-4,ex3(:),4,G2H4(1054),m3h2x4(:,1126),heltab2x8(:,:,1126))
  call Hloop_UW_V(ntryL,G1H8(1259),35,ex5(:),16,G2H4(1055),m3h2x4(:,1127),heltab2x8(:,:,1127))
  call Hloop_UW_V(ntryL,G1H8(1260),35,ex5(:),16,G2H4(1056),m3h2x4(:,1128),heltab2x8(:,:,1128))
call HGT_OLR(G1H8(1262),1,1,8)
call HGT_invQ_OLR(G1H8(1262),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1262),-16,ex5(:),16,G2H4(1057),m3h2x4(:,1129),heltab2x8(:,:,1129))
  call Hloop_SQ_A(ntryL,G1H8(1265),ex1(:),G1H4(73),ngPnl,m3h2x4(:,1130),heltab2x8(:,:,1130))
  call Hloop_Q_A(ntryL,G1H4(73),45,0,G2H4(1058),n2h4(325))
  call Hloop_SQ_A(ntryL,G1H8(1266),ex1(:),G1H4(73),ngPnl,m3h2x4(:,1131),heltab2x8(:,:,1131))
  call Hloop_Q_A(ntryL,G1H4(73),45,0,G2H4(1059),n2h4(326))
call HGT_OLR(G1H8(1268),1,1,8)
call HGT_invQ_OLR(G1H8(1268),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1268),-16,ex5(:),16,G2H4(1060),m3h2x4(:,1132),heltab2x8(:,:,1132))
  call Hloop_SQ_A(ntryL,G1H8(1271),ex1(:),G1H4(73),ngPnl,m3h2x4(:,1133),heltab2x8(:,:,1133))
  call Hloop_Q_A(ntryL,G1H4(73),45,0,G2H4(1061),n2h4(327))
  call Hloop_SQ_A(ntryL,G1H8(1272),ex1(:),G1H4(73),ngPnl,m3h2x4(:,1134),heltab2x8(:,:,1134))
  call Hloop_Q_A(ntryL,G1H4(73),45,0,G2H4(1062),n2h4(328))
call HGT_OLR(G1H8(1274),1,1,8)
call HGT_invQ_OLR(G1H8(1274),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1274),ex5(:),G1H4(73),m3h2x4(:,1135),heltab2x8(:,:,1135))
  call Hloop_SQ_A(ntryL,G1H8(1277),ex1(:),G1H4(74),ngPnl,m3h2x4(:,1136),heltab2x8(:,:,1136))
  call Hloop_Q_A(ntryL,G1H4(74),45,0,G2H4(1063),n2h4(329))
  call Hloop_SQ_A(ntryL,G1H8(1278),ex1(:),G1H4(74),ngPnl,m3h2x4(:,1137),heltab2x8(:,:,1137))
  call Hloop_Q_A(ntryL,G1H4(74),45,0,G2H4(1064),n2h4(330))
call HGT_OLR(G1H8(1280),1,1,8)
call HGT_invQ_OLR(G1H8(1280),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1280),ex5(:),G1H4(74),m3h2x4(:,1138),heltab2x8(:,:,1138))
  call Hloop_SQ_A(ntryL,G1H8(1283),ex1(:),G1H4(75),ngPnl,m3h2x4(:,1139),heltab2x8(:,:,1139))
  call Hloop_Q_A(ntryL,G1H4(75),45,0,G2H4(1065),n2h4(331))
  call Hloop_SQ_A(ntryL,G1H8(1284),ex1(:),G1H4(75),ngPnl,m3h2x4(:,1140),heltab2x8(:,:,1140))
  call Hloop_Q_A(ntryL,G1H4(75),45,0,G2H4(1066),n2h4(332))
call HGT_raise_alpha_OLR(G1H8(1286),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1286),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1286),ex5(:),G1H4(75),m3h2x4(:,1141),heltab2x8(:,:,1141))
  call Hloop_WQ_A(ntryL,G1H8(1289),ex1(:),G1H4(76),m3h2x4(:,1142),heltab2x8(:,:,1142))
  call Hloop_Q_A(ntryL,G1H4(76),45,0,G2H4(1067),n2h4(333))
  call Hloop_WQ_A(ntryL,G1H8(1290),ex1(:),G1H4(76),m3h2x4(:,1143),heltab2x8(:,:,1143))
  call Hloop_Q_A(ntryL,G1H4(76),45,0,G2H4(1068),n2h4(334))
call HGT_raise_alpha_OLR(G1H8(1292),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1292),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1292),ex5(:),G1H4(76),m3h2x4(:,1144),heltab2x8(:,:,1144))
  call Hloop_WQ_A(ntryL,G1H8(1295),ex1(:),G1H4(77),m3h2x4(:,1145),heltab2x8(:,:,1145))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1069),n2h4(335))
  call Hloop_WQ_A(ntryL,G1H8(1296),ex1(:),G1H4(77),m3h2x4(:,1146),heltab2x8(:,:,1146))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1070),n2h4(336))
call HGT_raise_alpha_OLR(G1H8(1298),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1298),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1298),-16,ex5(:),16,G2H4(1071),m3h2x4(:,1147),heltab2x8(:,:,1147))
  call Hloop_WQ_A(ntryL,G1H8(1301),ex1(:),G1H4(77),m3h2x4(:,1148),heltab2x8(:,:,1148))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1072),n2h4(337))
  call Hloop_WQ_A(ntryL,G1H8(1302),ex1(:),G1H4(77),m3h2x4(:,1149),heltab2x8(:,:,1149))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1073),n2h4(338))
call HGT_raise_alpha_OLR(G1H8(1304),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1304),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1304),-16,ex5(:),16,G2H4(1074),m3h2x4(:,1150),heltab2x8(:,:,1150))
  call Hloop_WQ_A(ntryL,G1H8(1307),ex1(:),G1H4(77),m3h2x4(:,1151),heltab2x8(:,:,1151))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1075),n2h4(339))
  call Hloop_WQ_A(ntryL,G1H8(1308),ex1(:),G1H4(77),m3h2x4(:,1152),heltab2x8(:,:,1152))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1076),n2h4(340))
call HGT_OLR(G1H8(1310),1,1,8)
call HGT_invQ_OLR(G1H8(1310),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1310),-16,ex5(:),16,G2H4(1077),m3h2x4(:,1153),heltab2x8(:,:,1153))
  call Hloop_SQ_A(ntryL,G1H8(1313),ex1(:),G1H4(77),ngPnl,m3h2x4(:,1154),heltab2x8(:,:,1154))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1078),n2h4(341))
  call Hloop_SQ_A(ntryL,G1H8(1314),ex1(:),G1H4(77),ngPnl,m3h2x4(:,1155),heltab2x8(:,:,1155))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1079),n2h4(342))
call HGT_OLR(G1H8(1316),1,1,8)
call HGT_invQ_OLR(G1H8(1316),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1316),-16,ex5(:),16,G2H4(1080),m3h2x4(:,1156),heltab2x8(:,:,1156))
  call Hloop_SQ_A(ntryL,G1H8(1319),ex1(:),G1H4(77),ngPnl,m3h2x4(:,1157),heltab2x8(:,:,1157))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1081),n2h4(343))
  call Hloop_SQ_A(ntryL,G1H8(1320),ex1(:),G1H4(77),ngPnl,m3h2x4(:,1158),heltab2x8(:,:,1158))
  call Hloop_Q_A(ntryL,G1H4(77),45,0,G2H4(1082),n2h4(344))
call HGT_OLR(G1H8(1322),1,1,8)
call HGT_invQ_OLR(G1H8(1322),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1322),ex5(:),G1H4(77),m3h2x4(:,1159),heltab2x8(:,:,1159))
  call Hloop_SQ_A(ntryL,G1H8(1325),ex1(:),G1H4(78),ngPnl,m3h2x4(:,1160),heltab2x8(:,:,1160))
  call Hloop_Q_A(ntryL,G1H4(78),45,0,G2H4(1083),n2h4(345))
  call Hloop_SQ_A(ntryL,G1H8(1326),ex1(:),G1H4(78),ngPnl,m3h2x4(:,1161),heltab2x8(:,:,1161))
  call Hloop_Q_A(ntryL,G1H4(78),45,0,G2H4(1084),n2h4(346))
call HGT_OLR(G1H8(1328),1,1,8)
call HGT_invQ_OLR(G1H8(1328),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1328),ex5(:),G1H4(78),m3h2x4(:,1162),heltab2x8(:,:,1162))
  call Hloop_SQ_A(ntryL,G1H8(1331),ex1(:),G1H4(79),ngPnl,m3h2x4(:,1163),heltab2x8(:,:,1163))
  call Hloop_Q_A(ntryL,G1H4(79),45,0,G2H4(1085),n2h4(347))
  call Hloop_SQ_A(ntryL,G1H8(1332),ex1(:),G1H4(79),ngPnl,m3h2x4(:,1164),heltab2x8(:,:,1164))
  call Hloop_Q_A(ntryL,G1H4(79),45,0,G2H4(1086),n2h4(348))
call HGT_raise_alpha_OLR(G1H8(1334),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1334),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1334),ex5(:),G1H4(79),m3h2x4(:,1165),heltab2x8(:,:,1165))
  call Hloop_WQ_A(ntryL,G1H8(1337),ex1(:),G1H4(80),m3h2x4(:,1166),heltab2x8(:,:,1166))
  call Hloop_Q_A(ntryL,G1H4(80),45,0,G2H4(1087),n2h4(349))
  call Hloop_WQ_A(ntryL,G1H8(1338),ex1(:),G1H4(80),m3h2x4(:,1167),heltab2x8(:,:,1167))
  call Hloop_Q_A(ntryL,G1H4(80),45,0,G2H4(1088),n2h4(350))
call HGT_raise_alpha_OLR(G1H8(1340),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1340),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1340),ex5(:),G1H4(80),m3h2x4(:,1168),heltab2x8(:,:,1168))
  call Hloop_WQ_A(ntryL,G1H8(1343),ex1(:),G1H4(81),m3h2x4(:,1169),heltab2x8(:,:,1169))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1089),n2h4(351))
  call Hloop_WQ_A(ntryL,G1H8(1344),ex1(:),G1H4(81),m3h2x4(:,1170),heltab2x8(:,:,1170))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1090),n2h4(352))
call HGT_raise_alpha_OLR(G1H8(1346),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1346),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1346),-16,ex5(:),16,G2H4(1091),m3h2x4(:,1171),heltab2x8(:,:,1171))
  call Hloop_WQ_A(ntryL,G1H8(1349),ex1(:),G1H4(81),m3h2x4(:,1172),heltab2x8(:,:,1172))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1092),n2h4(353))
  call Hloop_WQ_A(ntryL,G1H8(1350),ex1(:),G1H4(81),m3h2x4(:,1173),heltab2x8(:,:,1173))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1093),n2h4(354))
call HGT_raise_alpha_OLR(G1H8(1352),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1352),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1352),-16,ex5(:),16,G2H4(1094),m3h2x4(:,1174),heltab2x8(:,:,1174))
  call Hloop_WQ_A(ntryL,G1H8(1355),ex1(:),G1H4(81),m3h2x4(:,1175),heltab2x8(:,:,1175))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1095),n2h4(355))
  call Hloop_WQ_A(ntryL,G1H8(1356),ex1(:),G1H4(81),m3h2x4(:,1176),heltab2x8(:,:,1176))
  call Hloop_Q_A(ntryL,G1H4(81),45,0,G2H4(1096),n2h4(356))
call HGT_OLR(G1H8(1358),1,1,8)
call HGT_invQ_OLR(G1H8(1358),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1358),-8,ex4(:),8,G2H4(1097),m3h2x4(:,1177),heltab2x8(:,:,1177))
  call Hloop_SA_Q(ntryL,G1H8(1361),ex2(:),G1H4(81),ngPln,m3h2x4(:,1178),heltab2x8(:,:,1178))
  call Hloop_A_Q(ntryL,G1H4(81),54,0,G2H4(1098),n2h4(357))
  call Hloop_SA_Q(ntryL,G1H8(1362),ex2(:),G1H4(81),ngPln,m3h2x4(:,1179),heltab2x8(:,:,1179))
  call Hloop_A_Q(ntryL,G1H4(81),54,0,G2H4(1099),n2h4(358))
call HGT_OLR(G1H8(1364),1,1,8)
call HGT_invQ_OLR(G1H8(1364),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1364),-8,ex4(:),8,G2H4(1100),m3h2x4(:,1180),heltab2x8(:,:,1180))
  call Hloop_SA_Q(ntryL,G1H8(1367),ex2(:),G1H4(81),ngPln,m3h2x4(:,1181),heltab2x8(:,:,1181))
  call Hloop_A_Q(ntryL,G1H4(81),54,0,G2H4(1101),n2h4(359))
  call Hloop_SA_Q(ntryL,G1H8(1368),ex2(:),G1H4(81),ngPln,m3h2x4(:,1182),heltab2x8(:,:,1182))
  call Hloop_A_Q(ntryL,G1H4(81),54,0,G2H4(1102),n2h4(360))
call HGT_OLR(G1H8(1370),1,1,8)
call HGT_invQ_OLR(G1H8(1370),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1370),ex4(:),G1H4(81),m3h2x4(:,1183),heltab2x8(:,:,1183))
  call Hloop_SA_Q(ntryL,G1H8(1373),ex2(:),G1H4(82),ngPln,m3h2x4(:,1184),heltab2x8(:,:,1184))
  call Hloop_A_Q(ntryL,G1H4(82),54,0,G2H4(1103),n2h4(361))
  call Hloop_SA_Q(ntryL,G1H8(1374),ex2(:),G1H4(82),ngPln,m3h2x4(:,1185),heltab2x8(:,:,1185))
  call Hloop_A_Q(ntryL,G1H4(82),54,0,G2H4(1104),n2h4(362))
call HGT_OLR(G1H8(1376),1,1,8)
call HGT_invQ_OLR(G1H8(1376),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1376),ex4(:),G1H4(82),m3h2x4(:,1186),heltab2x8(:,:,1186))
  call Hloop_SA_Q(ntryL,G1H8(1379),ex2(:),G1H4(83),ngPln,m3h2x4(:,1187),heltab2x8(:,:,1187))
  call Hloop_A_Q(ntryL,G1H4(83),54,0,G2H4(1105),n2h4(363))
  call Hloop_SA_Q(ntryL,G1H8(1380),ex2(:),G1H4(83),ngPln,m3h2x4(:,1188),heltab2x8(:,:,1188))
  call Hloop_A_Q(ntryL,G1H4(83),54,0,G2H4(1106),n2h4(364))
call HGT_raise_alpha_OLR(G1H8(1382),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1382),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1382),ex4(:),G1H4(83),m3h2x4(:,1189),heltab2x8(:,:,1189))
  call Hloop_WA_Q(ntryL,G1H8(1385),ex2(:),G1H4(84),m3h2x4(:,1190),heltab2x8(:,:,1190))
  call Hloop_A_Q(ntryL,G1H4(84),54,0,G2H4(1107),n2h4(365))
  call Hloop_WA_Q(ntryL,G1H8(1386),ex2(:),G1H4(84),m3h2x4(:,1191),heltab2x8(:,:,1191))
  call Hloop_A_Q(ntryL,G1H4(84),54,0,G2H4(1108),n2h4(366))
call HGT_raise_alpha_OLR(G1H8(1388),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1388),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1388),ex4(:),G1H4(84),m3h2x4(:,1192),heltab2x8(:,:,1192))
  call Hloop_WA_Q(ntryL,G1H8(1391),ex2(:),G1H4(85),m3h2x4(:,1193),heltab2x8(:,:,1193))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1109),n2h4(367))
  call Hloop_WA_Q(ntryL,G1H8(1392),ex2(:),G1H4(85),m3h2x4(:,1194),heltab2x8(:,:,1194))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1110),n2h4(368))
call HGT_raise_alpha_OLR(G1H8(1394),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1394),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1394),-8,ex4(:),8,G2H4(1111),m3h2x4(:,1195),heltab2x8(:,:,1195))
  call Hloop_WA_Q(ntryL,G1H8(1397),ex2(:),G1H4(85),m3h2x4(:,1196),heltab2x8(:,:,1196))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1112),n2h4(369))
  call Hloop_WA_Q(ntryL,G1H8(1398),ex2(:),G1H4(85),m3h2x4(:,1197),heltab2x8(:,:,1197))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1113),n2h4(370))
call HGT_raise_alpha_OLR(G1H8(1400),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1400),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1400),-8,ex4(:),8,G2H4(1114),m3h2x4(:,1198),heltab2x8(:,:,1198))
  call Hloop_WA_Q(ntryL,G1H8(1403),ex2(:),G1H4(85),m3h2x4(:,1199),heltab2x8(:,:,1199))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1115),n2h4(371))
  call Hloop_WA_Q(ntryL,G1H8(1404),ex2(:),G1H4(85),m3h2x4(:,1200),heltab2x8(:,:,1200))
  call Hloop_A_Q(ntryL,G1H4(85),54,0,G2H4(1116),n2h4(372))
call HGT_OLR(G1H8(1406),1,1,8)
call HGT_invQ_OLR(G1H8(1406),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1406),-16,ex5(:),16,G2H4(1117),m3h2x4(:,1201),heltab2x8(:,:,1201))
  call Hloop_SA_Q(ntryL,G1H8(1409),ex2(:),G1H4(85),ngPln,m3h2x4(:,1202),heltab2x8(:,:,1202))
  call Hloop_A_Q(ntryL,G1H4(85),46,0,G2H4(1118),n2h4(373))
  call Hloop_SA_Q(ntryL,G1H8(1410),ex2(:),G1H4(85),ngPln,m3h2x4(:,1203),heltab2x8(:,:,1203))
  call Hloop_A_Q(ntryL,G1H4(85),46,0,G2H4(1119),n2h4(374))
call HGT_OLR(G1H8(1412),1,1,8)
call HGT_invQ_OLR(G1H8(1412),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1412),-16,ex5(:),16,G2H4(1120),m3h2x4(:,1204),heltab2x8(:,:,1204))
  call Hloop_SA_Q(ntryL,G1H8(1415),ex2(:),G1H4(85),ngPln,m3h2x4(:,1205),heltab2x8(:,:,1205))
  call Hloop_A_Q(ntryL,G1H4(85),46,0,G2H4(1121),n2h4(375))
  call Hloop_SA_Q(ntryL,G1H8(1416),ex2(:),G1H4(85),ngPln,m3h2x4(:,1206),heltab2x8(:,:,1206))
  call Hloop_A_Q(ntryL,G1H4(85),46,0,G2H4(1122),n2h4(376))
call HGT_OLR(G1H8(1418),1,1,8)
call HGT_invQ_OLR(G1H8(1418),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1418),ex5(:),G1H4(85),m3h2x4(:,1207),heltab2x8(:,:,1207))
  call Hloop_SA_Q(ntryL,G1H8(1421),ex2(:),G1H4(86),ngPln,m3h2x4(:,1208),heltab2x8(:,:,1208))
  call Hloop_A_Q(ntryL,G1H4(86),46,0,G2H4(1123),n2h4(377))
  call Hloop_SA_Q(ntryL,G1H8(1422),ex2(:),G1H4(86),ngPln,m3h2x4(:,1209),heltab2x8(:,:,1209))
  call Hloop_A_Q(ntryL,G1H4(86),46,0,G2H4(1124),n2h4(378))
call HGT_OLR(G1H8(1424),1,1,8)
call HGT_invQ_OLR(G1H8(1424),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1424),ex5(:),G1H4(86),m3h2x4(:,1210),heltab2x8(:,:,1210))
  call Hloop_SA_Q(ntryL,G1H8(1427),ex2(:),G1H4(87),ngPln,m3h2x4(:,1211),heltab2x8(:,:,1211))
  call Hloop_A_Q(ntryL,G1H4(87),46,0,G2H4(1125),n2h4(379))
  call Hloop_SA_Q(ntryL,G1H8(1428),ex2(:),G1H4(87),ngPln,m3h2x4(:,1212),heltab2x8(:,:,1212))
  call Hloop_A_Q(ntryL,G1H4(87),46,0,G2H4(1126),n2h4(380))
call HGT_raise_alpha_OLR(G1H8(1430),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1430),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1430),ex5(:),G1H4(87),m3h2x4(:,1213),heltab2x8(:,:,1213))
  call Hloop_WA_Q(ntryL,G1H8(1433),ex2(:),G1H4(88),m3h2x4(:,1214),heltab2x8(:,:,1214))
  call Hloop_A_Q(ntryL,G1H4(88),46,0,G2H4(1127),n2h4(381))
  call Hloop_WA_Q(ntryL,G1H8(1434),ex2(:),G1H4(88),m3h2x4(:,1215),heltab2x8(:,:,1215))
  call Hloop_A_Q(ntryL,G1H4(88),46,0,G2H4(1128),n2h4(382))
call HGT_raise_alpha_OLR(G1H8(1436),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1436),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1436),ex5(:),G1H4(88),m3h2x4(:,1216),heltab2x8(:,:,1216))
  call Hloop_WA_Q(ntryL,G1H8(1439),ex2(:),G1H4(89),m3h2x4(:,1217),heltab2x8(:,:,1217))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1129),n2h4(383))
  call Hloop_WA_Q(ntryL,G1H8(1440),ex2(:),G1H4(89),m3h2x4(:,1218),heltab2x8(:,:,1218))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1130),n2h4(384))
call HGT_raise_alpha_OLR(G1H8(1442),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1442),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1442),-16,ex5(:),16,G2H4(1131),m3h2x4(:,1219),heltab2x8(:,:,1219))
  call Hloop_WA_Q(ntryL,G1H8(1445),ex2(:),G1H4(89),m3h2x4(:,1220),heltab2x8(:,:,1220))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1132),n2h4(385))
  call Hloop_WA_Q(ntryL,G1H8(1446),ex2(:),G1H4(89),m3h2x4(:,1221),heltab2x8(:,:,1221))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1133),n2h4(386))
call HGT_raise_alpha_OLR(G1H8(1448),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1448),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1448),-16,ex5(:),16,G2H4(1134),m3h2x4(:,1222),heltab2x8(:,:,1222))
  call Hloop_WA_Q(ntryL,G1H8(1451),ex2(:),G1H4(89),m3h2x4(:,1223),heltab2x8(:,:,1223))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1135),n2h4(387))
  call Hloop_WA_Q(ntryL,G1H8(1452),ex2(:),G1H4(89),m3h2x4(:,1224),heltab2x8(:,:,1224))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1136),n2h4(388))
call HGT_OLR(G1H8(1454),1,1,8)
call HGT_invQ_OLR(G1H8(1454),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1454),-16,ex5(:),16,G2H4(1137),m3h2x4(:,1225),heltab2x8(:,:,1225))
  call Hloop_SA_Q(ntryL,G1H8(1457),ex2(:),G1H4(89),ngPln,m3h2x4(:,1226),heltab2x8(:,:,1226))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1138),n2h4(389))
  call Hloop_SA_Q(ntryL,G1H8(1458),ex2(:),G1H4(89),ngPln,m3h2x4(:,1227),heltab2x8(:,:,1227))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1139),n2h4(390))
call HGT_OLR(G1H8(1460),1,1,8)
call HGT_invQ_OLR(G1H8(1460),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(1460),-16,ex5(:),16,G2H4(1140),m3h2x4(:,1228),heltab2x8(:,:,1228))
  call Hloop_SA_Q(ntryL,G1H8(1463),ex2(:),G1H4(89),ngPln,m3h2x4(:,1229),heltab2x8(:,:,1229))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1141),n2h4(391))
  call Hloop_SA_Q(ntryL,G1H8(1464),ex2(:),G1H4(89),ngPln,m3h2x4(:,1230),heltab2x8(:,:,1230))
  call Hloop_A_Q(ntryL,G1H4(89),46,0,G2H4(1142),n2h4(392))
call HGT_OLR(G1H8(1466),1,1,8)
call HGT_invQ_OLR(G1H8(1466),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1466),ex5(:),G1H4(89),m3h2x4(:,1231),heltab2x8(:,:,1231))
  call Hloop_SA_Q(ntryL,G1H8(1469),ex2(:),G1H4(90),ngPln,m3h2x4(:,1232),heltab2x8(:,:,1232))
  call Hloop_A_Q(ntryL,G1H4(90),46,0,G2H4(1143),n2h4(393))
  call Hloop_SA_Q(ntryL,G1H8(1470),ex2(:),G1H4(90),ngPln,m3h2x4(:,1233),heltab2x8(:,:,1233))
  call Hloop_A_Q(ntryL,G1H4(90),46,0,G2H4(1144),n2h4(394))
call HGT_OLR(G1H8(1472),1,1,8)
call HGT_invQ_OLR(G1H8(1472),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1472),ex5(:),G1H4(90),m3h2x4(:,1234),heltab2x8(:,:,1234))
  call Hloop_SA_Q(ntryL,G1H8(1475),ex2(:),G1H4(91),ngPln,m3h2x4(:,1235),heltab2x8(:,:,1235))
  call Hloop_A_Q(ntryL,G1H4(91),46,0,G2H4(1145),n2h4(395))
  call Hloop_SA_Q(ntryL,G1H8(1476),ex2(:),G1H4(91),ngPln,m3h2x4(:,1236),heltab2x8(:,:,1236))
  call Hloop_A_Q(ntryL,G1H4(91),46,0,G2H4(1146),n2h4(396))
call HGT_raise_alpha_OLR(G1H8(1478),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1478),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1478),ex5(:),G1H4(91),m3h2x4(:,1237),heltab2x8(:,:,1237))
  call Hloop_WA_Q(ntryL,G1H8(1481),ex2(:),G1H4(92),m3h2x4(:,1238),heltab2x8(:,:,1238))
  call Hloop_A_Q(ntryL,G1H4(92),46,0,G2H4(1147),n2h4(397))
  call Hloop_WA_Q(ntryL,G1H8(1482),ex2(:),G1H4(92),m3h2x4(:,1239),heltab2x8(:,:,1239))
  call Hloop_A_Q(ntryL,G1H4(92),46,0,G2H4(1148),n2h4(398))
call HGT_raise_alpha_OLR(G1H8(1484),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1484),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1484),ex5(:),G1H4(92),m3h2x4(:,1240),heltab2x8(:,:,1240))
  call Hloop_WA_Q(ntryL,G1H8(1487),ex2(:),G1H4(93),m3h2x4(:,1241),heltab2x8(:,:,1241))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1149),n2h4(399))
  call Hloop_WA_Q(ntryL,G1H8(1488),ex2(:),G1H4(93),m3h2x4(:,1242),heltab2x8(:,:,1242))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1150),n2h4(400))
call HGT_raise_alpha_OLR(G1H8(1490),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1490),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1490),-16,ex5(:),16,G2H4(1151),m3h2x4(:,1243),heltab2x8(:,:,1243))
  call Hloop_WA_Q(ntryL,G1H8(1493),ex2(:),G1H4(93),m3h2x4(:,1244),heltab2x8(:,:,1244))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1152),n2h4(401))
  call Hloop_WA_Q(ntryL,G1H8(1494),ex2(:),G1H4(93),m3h2x4(:,1245),heltab2x8(:,:,1245))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1153),n2h4(402))
call HGT_raise_alpha_OLR(G1H8(1496),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1496),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(1496),-16,ex5(:),16,G2H4(1154),m3h2x4(:,1246),heltab2x8(:,:,1246))
  call Hloop_WA_Q(ntryL,G1H8(1499),ex2(:),G1H4(93),m3h2x4(:,1247),heltab2x8(:,:,1247))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1155),n2h4(403))
  call Hloop_WA_Q(ntryL,G1H8(1500),ex2(:),G1H4(93),m3h2x4(:,1248),heltab2x8(:,:,1248))
  call Hloop_A_Q(ntryL,G1H4(93),46,0,G2H4(1156),n2h4(404))
call HGT_OLR(G1H8(1502),1,1,8)
call HGT_invQ_OLR(G1H8(1502),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1502),-8,ex4(:),8,G2H4(1157),m3h2x4(:,1249),heltab2x8(:,:,1249))
  call Hloop_SQ_A(ntryL,G1H8(1505),ex1(:),G1H4(93),ngPnl,m3h2x4(:,1250),heltab2x8(:,:,1250))
  call Hloop_Q_A(ntryL,G1H4(93),53,0,G2H4(1158),n2h4(405))
  call Hloop_SQ_A(ntryL,G1H8(1506),ex1(:),G1H4(93),ngPnl,m3h2x4(:,1251),heltab2x8(:,:,1251))
  call Hloop_Q_A(ntryL,G1H4(93),53,0,G2H4(1159),n2h4(406))
call HGT_OLR(G1H8(1508),1,1,8)
call HGT_invQ_OLR(G1H8(1508),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1508),-8,ex4(:),8,G2H4(1160),m3h2x4(:,1252),heltab2x8(:,:,1252))
  call Hloop_SQ_A(ntryL,G1H8(1511),ex1(:),G1H4(93),ngPnl,m3h2x4(:,1253),heltab2x8(:,:,1253))
  call Hloop_Q_A(ntryL,G1H4(93),53,0,G2H4(1161),n2h4(407))
  call Hloop_SQ_A(ntryL,G1H8(1512),ex1(:),G1H4(93),ngPnl,m3h2x4(:,1254),heltab2x8(:,:,1254))
  call Hloop_Q_A(ntryL,G1H4(93),53,0,G2H4(1162),n2h4(408))
call HGT_OLR(G1H8(1514),1,1,8)
call HGT_invQ_OLR(G1H8(1514),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1514),ex4(:),G1H4(93),m3h2x4(:,1255),heltab2x8(:,:,1255))
  call Hloop_SQ_A(ntryL,G1H8(1517),ex1(:),G1H4(94),ngPnl,m3h2x4(:,1256),heltab2x8(:,:,1256))
  call Hloop_Q_A(ntryL,G1H4(94),53,0,G2H4(1163),n2h4(409))
  call Hloop_SQ_A(ntryL,G1H8(1518),ex1(:),G1H4(94),ngPnl,m3h2x4(:,1257),heltab2x8(:,:,1257))
  call Hloop_Q_A(ntryL,G1H4(94),53,0,G2H4(1164),n2h4(410))
call HGT_OLR(G1H8(1520),1,1,8)
call HGT_invQ_OLR(G1H8(1520),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(1520),ex4(:),G1H4(94),m3h2x4(:,1258),heltab2x8(:,:,1258))
  call Hloop_SQ_A(ntryL,G1H8(1523),ex1(:),G1H4(95),ngPnl,m3h2x4(:,1259),heltab2x8(:,:,1259))
  call Hloop_Q_A(ntryL,G1H4(95),53,0,G2H4(1165),n2h4(411))
  call Hloop_SQ_A(ntryL,G1H8(1524),ex1(:),G1H4(95),ngPnl,m3h2x4(:,1260),heltab2x8(:,:,1260))
  call Hloop_Q_A(ntryL,G1H4(95),53,0,G2H4(1166),n2h4(412))
call HGT_raise_alpha_OLR(G1H8(1526),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1526),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1526),ex4(:),G1H4(95),m3h2x4(:,1261),heltab2x8(:,:,1261))
  call Hloop_WQ_A(ntryL,G1H8(1529),ex1(:),G1H4(96),m3h2x4(:,1262),heltab2x8(:,:,1262))
  call Hloop_Q_A(ntryL,G1H4(96),53,0,G2H4(1167),n2h4(413))
  call Hloop_WQ_A(ntryL,G1H8(1530),ex1(:),G1H4(96),m3h2x4(:,1263),heltab2x8(:,:,1263))
  call Hloop_Q_A(ntryL,G1H4(96),53,0,G2H4(1168),n2h4(414))
call HGT_raise_alpha_OLR(G1H8(1532),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1532),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(1532),ex4(:),G1H4(96),m3h2x4(:,1264),heltab2x8(:,:,1264))
  call Hloop_WQ_A(ntryL,G1H8(1535),ex1(:),G1H4(97),m3h2x4(:,1265),heltab2x8(:,:,1265))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1169),n2h4(415))
  call Hloop_WQ_A(ntryL,G1H8(1536),ex1(:),G1H4(97),m3h2x4(:,1266),heltab2x8(:,:,1266))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1170),n2h4(416))
call HGT_raise_alpha_OLR(G1H8(1538),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1538),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1538),-8,ex4(:),8,G2H4(1171),m3h2x4(:,1267),heltab2x8(:,:,1267))
  call Hloop_WQ_A(ntryL,G1H8(1541),ex1(:),G1H4(97),m3h2x4(:,1268),heltab2x8(:,:,1268))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1172),n2h4(417))
  call Hloop_WQ_A(ntryL,G1H8(1542),ex1(:),G1H4(97),m3h2x4(:,1269),heltab2x8(:,:,1269))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1173),n2h4(418))
call HGT_raise_alpha_OLR(G1H8(1544),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1544),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1544),-8,ex4(:),8,G2H4(1174),m3h2x4(:,1270),heltab2x8(:,:,1270))
  call Hloop_WQ_A(ntryL,G1H8(1547),ex1(:),G1H4(97),m3h2x4(:,1271),heltab2x8(:,:,1271))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1175),n2h4(419))
  call Hloop_WQ_A(ntryL,G1H8(1548),ex1(:),G1H4(97),m3h2x4(:,1272),heltab2x8(:,:,1272))
  call Hloop_Q_A(ntryL,G1H4(97),53,0,G2H4(1176),n2h4(420))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(415),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(397),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(419),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(422),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(405),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(408),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(425),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(411),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(455),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(437),[G2H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(459),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(462),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(445),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(448),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(465),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(451),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(583),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(565),[G2H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(587),[G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(590),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(573),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(576),[G2H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(593),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(579),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(623),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(605),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(627),[G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(630),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(613),[G2H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(616),[G2H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(633),[G2H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(619),[G2H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(763),[G2H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(745),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(767),[G2H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(770),[G2H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(753),[G2H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(756),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(773),[G2H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(759),[G2H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(803),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(785),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(807),[G2H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(810),[G2H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(793),[G2H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(796),[G2H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(813),[G2H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(799),[G2H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(843),[G2H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(825),[G2H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(847),[G2H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(850),[G2H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(833),[G2H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(836),[G2H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(853),[G2H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(839),[G2H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(883),[G2H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(865),[G2H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(887),[G2H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(890),[G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(873),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(876),[G2H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(893),[G2H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(879),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(923),[G2H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(905),[G2H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(927),[G2H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(930),[G2H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(913),[G2H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(916),[G2H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(933),[G2H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(919),[G2H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(963),[G2H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(945),[G2H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(967),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(970),[G2H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(953),[G2H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(956),[G2H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(973),[G2H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(959),[G2H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1003),[G2H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(985),[G2H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1007),[G2H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1010),[G2H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(993),[G2H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(996),[G2H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1013),[G2H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(999),[G2H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1043),[G2H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1025),[G2H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1047),[G2H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1050),[G2H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1033),[G2H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1036),[G2H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1053),[G2H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1039),[G2H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(325),[G2H4(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(328),[G2H4(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(341),[G2H4(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(344),[G2H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(363),[G2H4(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(365),[G2H4(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(352),[G2H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(355),[G2H4(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(369),[G2H4(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(372),[G2H4(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(366),[G2H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(368),[G2H4(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(385),[G2H4(377)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(388),[G2H4(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(481),[G2H4(473)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(484),[G2H4(476)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(497),[G2H4(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(500),[G2H4(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(519),[G2H4(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(521),[G2H4(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(508),[G2H4(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(511),[G2H4(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(525),[G2H4(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(528),[G2H4(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(522),[G2H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(524),[G2H4(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(540),[G2H4(529)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(542),[G2H4(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(536),[G2H4(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(539),[G2H4(535)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(553),[G2H4(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(556),[G2H4(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(550),[G2H4(547)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(552),[G2H4(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(648),[G2H4(637)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(650),[G2H4(639)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(644),[G2H4(640)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(647),[G2H4(643)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(661),[G2H4(651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(664),[G2H4(654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(658),[G2H4(655)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(660),[G2H4(657)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(677),[G2H4(669)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(680),[G2H4(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(692),[G2H4(681)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(694),[G2H4(683)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(688),[G2H4(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(691),[G2H4(687)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(705),[G2H4(695)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(708),[G2H4(698)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(702),[G2H4(699)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(704),[G2H4(701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(727),[G2H4(709)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(729),[G2H4(711)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(716),[G2H4(712)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(719),[G2H4(715)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(733),[G2H4(720)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(736),[G2H4(723)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(730),[G2H4(724)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(732),[G2H4(726)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hloop_SV_V(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_SV_V(ntryL,G2H4(4),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VV_S(ntryL,G2H4(5),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_VV_S(ntryL,G2H4(6),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(1),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(1),mass5set(:,1),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,1),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),16,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,1),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),16,4)
  call Hloop_SV_V(ntryL,G2H4(11),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VV_S(ntryL,G2H4(12),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SV_V(ntryL,G2H4(13),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VV_S(ntryL,G2H4(14),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(2),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(2),mass5set(:,1),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),16,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(2),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(2),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hloop_SV_V(ntryL,G2H4(19),ex5(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VV_S(ntryL,G2H4(20),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_SV_V(ntryL,G2H4(21),ex5(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_VV_S(ntryL,G2H4(22),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(2),mass5set(:,1),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,1),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),8,4)
  call Hloop_VV_S(ntryL,G2H4(415),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hotf_5pt_reduction(G2H4(397),RedSet_5(11),mass5set(:,11),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),16,4)
  call Hloop_VV_S(ntryL,G2H4(419),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H4(422),RedSet_5(11),mass5set(:,11),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(405),RedSet_5(11),mass5set(:,11),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hloop_SV_V(ntryL,G2H4(408),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hotf_5pt_reduction(G2H4(425),RedSet_5(11),mass5set(:,11),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),16,4)
  call Hloop_SV_V(ntryL,G2H4(411),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VV_S(ntryL,G2H4(455),ex5(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hotf_5pt_reduction(G2H4(437),RedSet_5(11),mass5set(:,11),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hloop_VV_S(ntryL,G2H4(459),ex5(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(462),RedSet_5(11),mass5set(:,11),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(445),RedSet_5(11),mass5set(:,11),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),8,4)
  call Hloop_SV_V(ntryL,G2H4(448),ex5(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hotf_5pt_reduction(G2H4(465),RedSet_5(11),mass5set(:,11),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),8,4)
  call Hloop_SV_V(ntryL,G2H4(451),ex5(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(4),mass5set(:,1),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(4),mass5set(:,1),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hloop_SV_V(ntryL,G2H4(43),ex3(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VV_S(ntryL,G2H4(44),ex3(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_SV_V(ntryL,G2H4(45),ex3(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_VV_S(ntryL,G2H4(46),ex3(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(4),mass5set(:,1),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),16,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(4),mass5set(:,1),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),16,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(5),mass5set(:,1),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),16,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(5),mass5set(:,1),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hloop_SV_V(ntryL,G2H4(51),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_SV_V(ntryL,G2H4(52),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VV_S(ntryL,G2H4(53),ex4(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VV_S(ntryL,G2H4(54),ex4(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(5),mass5set(:,1),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),16,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(5),mass5set(:,1),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),16,4)
  call Hloop_VV_S(ntryL,G2H4(583),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hotf_5pt_reduction(G2H4(565),RedSet_5(12),mass5set(:,11),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),16,4)
  call Hloop_VV_S(ntryL,G2H4(587),ex3(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H4(590),RedSet_5(12),mass5set(:,11),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),16,4)
  call Hotf_5pt_reduction(G2H4(573),RedSet_5(12),mass5set(:,11),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),16,4)
  call Hloop_SV_V(ntryL,G2H4(576),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hotf_5pt_reduction(G2H4(593),RedSet_5(12),mass5set(:,11),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
  call HG1shiftOLR(G1H4(284),16,4)
  call Hloop_SV_V(ntryL,G2H4(579),ex3(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VV_S(ntryL,G2H4(623),ex5(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hotf_5pt_reduction(G2H4(605),RedSet_5(12),mass5set(:,11),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),4,4)
  call Hloop_VV_S(ntryL,G2H4(627),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hotf_5pt_reduction(G2H4(630),RedSet_5(12),mass5set(:,11),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(296),4,4)
  call Hotf_5pt_reduction(G2H4(613),RedSet_5(12),mass5set(:,11),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(302),4,4)
  call Hloop_SV_V(ntryL,G2H4(616),ex5(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hotf_5pt_reduction(G2H4(633),RedSet_5(12),mass5set(:,11),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
  call HG1shiftOLR(G1H4(308),4,4)
  call Hloop_SV_V(ntryL,G2H4(619),ex5(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(5),mass5set(:,1),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
  call HG1shiftOLR(G1H4(314),8,4)
  call Hotf_5pt_reduction(G2H4(74),RedSet_5(5),mass5set(:,1),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
  call HG1shiftOLR(G1H4(320),8,4)
  call Hloop_SV_V(ntryL,G2H4(75),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_SV_V(ntryL,G2H4(76),ex5(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_VV_S(ntryL,G2H4(77),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VV_S(ntryL,G2H4(78),ex5(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(5),mass5set(:,1),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
  call HG1shiftOLR(G1H4(326),8,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(5),mass5set(:,1),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
  call HG1shiftOLR(G1H4(332),8,4)
  call Hloop_VV_S(ntryL,G2H4(763),ex3(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hotf_5pt_reduction(G2H4(745),RedSet_5(13),mass5set(:,11),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hloop_VV_S(ntryL,G2H4(767),ex3(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hotf_5pt_reduction(G2H4(770),RedSet_5(13),mass5set(:,11),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G1H4(348),4)
  call HG1shiftOLR(G1H4(344),8,4)
  call Hotf_5pt_reduction(G2H4(753),RedSet_5(13),mass5set(:,11),  & 
G1H4(349),G1H4(350),G1H4(351),G1H4(352),G1H4(353),G1H4(354),4)
  call HG1shiftOLR(G1H4(350),8,4)
  call Hloop_SV_V(ntryL,G2H4(756),ex3(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hotf_5pt_reduction(G2H4(773),RedSet_5(13),mass5set(:,11),  & 
G1H4(355),G1H4(356),G1H4(357),G1H4(358),G1H4(359),G1H4(360),4)
  call HG1shiftOLR(G1H4(356),8,4)
  call Hloop_SV_V(ntryL,G2H4(759),ex3(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VV_S(ntryL,G2H4(803),ex4(:),G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hotf_5pt_reduction(G2H4(785),RedSet_5(13),mass5set(:,11),  & 
G1H4(361),G1H4(362),G1H4(363),G1H4(364),G1H4(365),G1H4(366),4)
  call HG1shiftOLR(G1H4(362),4,4)
  call Hloop_VV_S(ntryL,G2H4(807),ex4(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hotf_5pt_reduction(G2H4(810),RedSet_5(13),mass5set(:,11),  & 
G1H4(367),G1H4(368),G1H4(369),G1H4(370),G1H4(371),G1H4(372),4)
  call HG1shiftOLR(G1H4(368),4,4)
  call Hotf_5pt_reduction(G2H4(793),RedSet_5(13),mass5set(:,11),  & 
G1H4(373),G1H4(374),G1H4(375),G1H4(376),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(374),4,4)
  call Hloop_SV_V(ntryL,G2H4(796),ex4(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hotf_5pt_reduction(G2H4(813),RedSet_5(13),mass5set(:,11),  & 
G1H4(379),G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(380),4,4)
  call Hloop_SV_V(ntryL,G2H4(799),ex4(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VV_S(ntryL,G2H4(843),ex4(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hotf_5pt_reduction(G2H4(825),RedSet_5(14),mass5set(:,11),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),16,4)
  call Hloop_VV_S(ntryL,G2H4(847),ex4(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hotf_5pt_reduction(G2H4(850),RedSet_5(14),mass5set(:,11),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G1H4(396),4)
  call HG1shiftOLR(G1H4(392),16,4)
  call Hotf_5pt_reduction(G2H4(833),RedSet_5(14),mass5set(:,11),  & 
G1H4(397),G1H4(398),G1H4(399),G1H4(400),G1H4(401),G1H4(402),4)
  call HG1shiftOLR(G1H4(398),16,4)
  call Hloop_SV_V(ntryL,G2H4(836),ex4(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hotf_5pt_reduction(G2H4(853),RedSet_5(14),mass5set(:,11),  & 
G1H4(403),G1H4(404),G1H4(405),G1H4(406),G1H4(407),G1H4(408),4)
  call HG1shiftOLR(G1H4(404),16,4)
  call Hloop_SV_V(ntryL,G2H4(839),ex4(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VV_S(ntryL,G2H4(883),ex5(:),G2H2(53),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hotf_5pt_reduction(G2H4(865),RedSet_5(14),mass5set(:,11),  & 
G1H4(409),G1H4(410),G1H4(411),G1H4(412),G1H4(413),G1H4(414),4)
  call HG1shiftOLR(G1H4(410),8,4)
  call Hloop_VV_S(ntryL,G2H4(887),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hotf_5pt_reduction(G2H4(890),RedSet_5(14),mass5set(:,11),  & 
G1H4(415),G1H4(416),G1H4(417),G1H4(418),G1H4(419),G1H4(420),4)
  call HG1shiftOLR(G1H4(416),8,4)
  call Hotf_5pt_reduction(G2H4(873),RedSet_5(14),mass5set(:,11),  & 
G1H4(421),G1H4(422),G1H4(423),G1H4(424),G1H4(425),G1H4(426),4)
  call HG1shiftOLR(G1H4(422),8,4)
  call Hloop_SV_V(ntryL,G2H4(876),ex5(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hotf_5pt_reduction(G2H4(893),RedSet_5(14),mass5set(:,11),  & 
G1H4(427),G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),4)
  call HG1shiftOLR(G1H4(428),8,4)
  call Hloop_SV_V(ntryL,G2H4(879),ex5(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_VV_S(ntryL,G2H4(923),ex3(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hotf_5pt_reduction(G2H4(905),RedSet_5(15),mass5set(:,11),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),16,4)
  call Hloop_VV_S(ntryL,G2H4(927),ex3(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hotf_5pt_reduction(G2H4(930),RedSet_5(15),mass5set(:,11),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G1H4(444),4)
  call HG1shiftOLR(G1H4(440),16,4)
  call Hotf_5pt_reduction(G2H4(913),RedSet_5(15),mass5set(:,11),  & 
G1H4(445),G1H4(446),G1H4(447),G1H4(448),G1H4(449),G1H4(450),4)
  call HG1shiftOLR(G1H4(446),16,4)
  call Hloop_SV_V(ntryL,G2H4(916),ex3(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hotf_5pt_reduction(G2H4(933),RedSet_5(15),mass5set(:,11),  & 
G1H4(451),G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
  call HG1shiftOLR(G1H4(452),16,4)
  call Hloop_SV_V(ntryL,G2H4(919),ex3(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_VV_S(ntryL,G2H4(963),ex5(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hotf_5pt_reduction(G2H4(945),RedSet_5(15),mass5set(:,11),  & 
G1H4(457),G1H4(458),G1H4(459),G1H4(460),G1H4(461),G1H4(462),4)
  call HG1shiftOLR(G1H4(458),4,4)
  call Hloop_VV_S(ntryL,G2H4(967),ex5(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hotf_5pt_reduction(G2H4(970),RedSet_5(15),mass5set(:,11),  & 
G1H4(463),G1H4(464),G1H4(465),G1H4(466),G1H4(467),G1H4(468),4)
  call HG1shiftOLR(G1H4(464),4,4)
  call Hotf_5pt_reduction(G2H4(953),RedSet_5(15),mass5set(:,11),  & 
G1H4(469),G1H4(470),G1H4(471),G1H4(472),G1H4(473),G1H4(474),4)
  call HG1shiftOLR(G1H4(470),4,4)
  call Hloop_SV_V(ntryL,G2H4(956),ex5(:),G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hotf_5pt_reduction(G2H4(973),RedSet_5(15),mass5set(:,11),  & 
G1H4(475),G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),4)
  call HG1shiftOLR(G1H4(476),4,4)
  call Hloop_SV_V(ntryL,G2H4(959),ex5(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_VV_S(ntryL,G2H4(1003),ex3(:),G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hotf_5pt_reduction(G2H4(985),RedSet_5(16),mass5set(:,11),  & 
G1H4(481),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),8,4)
  call Hloop_VV_S(ntryL,G2H4(1007),ex3(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hotf_5pt_reduction(G2H4(1010),RedSet_5(16),mass5set(:,11),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G1H4(492),4)
  call HG1shiftOLR(G1H4(488),8,4)
  call Hotf_5pt_reduction(G2H4(993),RedSet_5(16),mass5set(:,11),  & 
G1H4(493),G1H4(494),G1H4(495),G1H4(496),G1H4(497),G1H4(498),4)
  call HG1shiftOLR(G1H4(494),8,4)
  call Hloop_SV_V(ntryL,G2H4(996),ex3(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hotf_5pt_reduction(G2H4(1013),RedSet_5(16),mass5set(:,11),  & 
G1H4(499),G1H4(500),G1H4(501),G1H4(502),G1H4(503),G1H4(504),4)
  call HG1shiftOLR(G1H4(500),8,4)
  call Hloop_SV_V(ntryL,G2H4(999),ex3(:),G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_VV_S(ntryL,G2H4(1043),ex4(:),G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hotf_5pt_reduction(G2H4(1025),RedSet_5(16),mass5set(:,11),  & 
G1H4(505),G1H4(506),G1H4(507),G1H4(508),G1H4(509),G1H4(510),4)
  call HG1shiftOLR(G1H4(506),4,4)
  call Hloop_VV_S(ntryL,G2H4(1047),ex4(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hotf_5pt_reduction(G2H4(1050),RedSet_5(16),mass5set(:,11),  & 
G1H4(511),G1H4(512),G1H4(513),G1H4(514),G1H4(515),G1H4(516),4)
  call HG1shiftOLR(G1H4(512),4,4)
  call Hotf_5pt_reduction(G2H4(1033),RedSet_5(16),mass5set(:,11),  & 
G1H4(517),G1H4(518),G1H4(519),G1H4(520),G1H4(521),G1H4(522),4)
  call HG1shiftOLR(G1H4(518),4,4)
  call Hloop_SV_V(ntryL,G2H4(1036),ex4(:),G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hotf_5pt_reduction(G2H4(1053),RedSet_5(16),mass5set(:,11),  & 
G1H4(523),G1H4(524),G1H4(525),G1H4(526),G1H4(527),G1H4(528),4)
  call HG1shiftOLR(G1H4(524),4,4)
  call Hloop_SV_V(ntryL,G2H4(1039),ex4(:),G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(26),mass5set(:,1),  & 
G1H4(529),G1H4(530),G1H4(531),G1H4(532),G1H4(533),G1H4(534),4)
  call HG1shiftOLR(G1H4(530),16,4)
  call Hloop_SV_V(ntryL,G2H4(148),ex3(:),G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_VV_S(ntryL,G2H4(150),ex3(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hotf_5pt_reduction(G2H4(152),RedSet_5(26),mass5set(:,1),  & 
G1H4(535),G1H4(536),G1H4(537),G1H4(538),G1H4(539),G1H4(540),4)
  call HG1shiftOLR(G1H4(536),16,4)
  call Hotf_5pt_reduction(G2H4(154),RedSet_5(26),mass5set(:,1),  & 
G1H4(541),G1H4(542),G1H4(543),G1H4(544),G1H4(545),G1H4(546),4)
  call HG1shiftOLR(G1H4(542),16,4)
  call Hloop_SV_V(ntryL,G2H4(156),ex3(:),G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_VV_S(ntryL,G2H4(158),ex3(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hotf_5pt_reduction(G2H4(160),RedSet_5(26),mass5set(:,1),  & 
G1H4(547),G1H4(548),G1H4(549),G1H4(550),G1H4(551),G1H4(552),4)
  call HG1shiftOLR(G1H4(548),16,4)
  call Hotf_5pt_reduction(G2H4(162),RedSet_5(27),mass5set(:,1),  & 
G1H4(553),G1H4(554),G1H4(555),G1H4(556),G1H4(557),G1H4(558),4)
  call HG1shiftOLR(G1H4(554),16,4)
  call Hloop_SV_V(ntryL,G2H4(164),ex4(:),G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_VV_S(ntryL,G2H4(166),ex4(:),G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hotf_5pt_reduction(G2H4(168),RedSet_5(27),mass5set(:,1),  & 
G1H4(559),G1H4(560),G1H4(561),G1H4(562),G1H4(563),G1H4(564),4)
  call HG1shiftOLR(G1H4(560),16,4)
  call Hotf_5pt_reduction(G2H4(170),RedSet_5(27),mass5set(:,1),  & 
G1H4(565),G1H4(566),G1H4(567),G1H4(568),G1H4(569),G1H4(570),4)
  call HG1shiftOLR(G1H4(566),16,4)
  call Hloop_SV_V(ntryL,G2H4(172),ex4(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_VV_S(ntryL,G2H4(174),ex4(:),G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(27),mass5set(:,1),  & 
G1H4(571),G1H4(572),G1H4(573),G1H4(574),G1H4(575),G1H4(576),4)
  call HG1shiftOLR(G1H4(572),16,4)
  call Hotf_5pt_reduction(G2H4(177),RedSet_5(3),mass5set(:,2),  & 
G1H4(577),G1H4(578),G1H4(579),G1H4(580),G1H4(581),G1H4(582),4)
  call HG1shiftOLR(G1H4(578),16,4)
  call Hotf_5pt_reduction(G2H4(179),RedSet_5(18),mass5set(:,14),  & 
G1H4(583),G1H4(584),G1H4(585),G1H4(586),G1H4(587),G1H4(588),4)
  call HG1shiftOLR(G1H4(584),16,4)
  call Hotf_5pt_reduction(G2H4(180),RedSet_5(3),mass5set(:,3),  & 
G1H4(589),G1H4(590),G1H4(591),G1H4(592),G1H4(593),G1H4(594),4)
  call HG1shiftOLR(G1H4(590),16,4)
  call Hotf_5pt_reduction(G2H4(182),RedSet_5(18),mass5set(:,14),  & 
G1H4(595),G1H4(596),G1H4(597),G1H4(598),G1H4(599),G1H4(600),4)
  call HG1shiftOLR(G1H4(596),16,4)
  call Hotf_5pt_reduction(G2H4(183),RedSet_5(3),mass5set(:,5),  & 
G1H4(601),G1H4(602),G1H4(603),G1H4(604),G1H4(605),G1H4(606),4)
  call HG1shiftOLR(G1H4(602),16,4)
  call Hotf_5pt_reduction(G2H4(185),RedSet_5(18),mass5set(:,14),  & 
G1H4(607),G1H4(608),G1H4(609),G1H4(610),G1H4(611),G1H4(612),4)
  call HG1shiftOLR(G1H4(608),16,4)
  call Hotf_5pt_reduction(G2H4(186),RedSet_5(3),mass5set(:,3),  & 
G1H4(613),G1H4(614),G1H4(615),G1H4(616),G1H4(617),G1H4(618),4)
  call HG1shiftOLR(G1H4(614),16,4)
  call Hotf_5pt_reduction(G2H4(188),RedSet_5(18),mass5set(:,14),  & 
G1H4(619),G1H4(620),G1H4(621),G1H4(622),G1H4(623),G1H4(624),4)
  call HG1shiftOLR(G1H4(620),16,4)
  call Hotf_5pt_reduction(G2H4(190),RedSet_5(28),mass5set(:,1),  & 
G1H4(625),G1H4(626),G1H4(627),G1H4(628),G1H4(629),G1H4(630),4)
  call HG1shiftOLR(G1H4(626),8,4)
  call Hloop_SV_V(ntryL,G2H4(192),ex5(:),G2H2(81),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_VV_S(ntryL,G2H4(194),ex5(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hotf_5pt_reduction(G2H4(196),RedSet_5(28),mass5set(:,1),  & 
G1H4(631),G1H4(632),G1H4(633),G1H4(634),G1H4(635),G1H4(636),4)
  call HG1shiftOLR(G1H4(632),8,4)
  call Hotf_5pt_reduction(G2H4(198),RedSet_5(28),mass5set(:,1),  & 
G1H4(637),G1H4(638),G1H4(639),G1H4(640),G1H4(641),G1H4(642),4)
  call HG1shiftOLR(G1H4(638),8,4)
  call Hloop_SV_V(ntryL,G2H4(200),ex5(:),G2H2(83),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_VV_S(ntryL,G2H4(202),ex5(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hotf_5pt_reduction(G2H4(204),RedSet_5(28),mass5set(:,1),  & 
G1H4(643),G1H4(644),G1H4(645),G1H4(646),G1H4(647),G1H4(648),4)
  call HG1shiftOLR(G1H4(644),8,4)
  call Hotf_5pt_reduction(G2H4(206),RedSet_5(29),mass5set(:,1),  & 
G1H4(649),G1H4(650),G1H4(651),G1H4(652),G1H4(653),G1H4(654),4)
  call HG1shiftOLR(G1H4(650),16,4)
  call Hloop_SV_V(ntryL,G2H4(208),ex3(:),G2H2(85),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_VV_S(ntryL,G2H4(210),ex3(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hotf_5pt_reduction(G2H4(212),RedSet_5(29),mass5set(:,1),  & 
G1H4(655),G1H4(656),G1H4(657),G1H4(658),G1H4(659),G1H4(660),4)
  call HG1shiftOLR(G1H4(656),16,4)
  call Hotf_5pt_reduction(G2H4(214),RedSet_5(29),mass5set(:,1),  & 
G1H4(661),G1H4(662),G1H4(663),G1H4(664),G1H4(665),G1H4(666),4)
  call HG1shiftOLR(G1H4(662),16,4)
  call Hloop_SV_V(ntryL,G2H4(216),ex3(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_VV_S(ntryL,G2H4(218),ex3(:),G2H2(88),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hotf_5pt_reduction(G2H4(220),RedSet_5(29),mass5set(:,1),  & 
G1H4(667),G1H4(668),G1H4(669),G1H4(670),G1H4(671),G1H4(672),4)
  call HG1shiftOLR(G1H4(668),16,4)
  call Hotf_5pt_reduction(G2H4(222),RedSet_5(30),mass5set(:,1),  & 
G1H4(673),G1H4(674),G1H4(675),G1H4(676),G1H4(677),G1H4(678),4)
  call HG1shiftOLR(G1H4(674),16,4)
  call Hloop_SV_V(ntryL,G2H4(224),ex4(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_VV_S(ntryL,G2H4(226),ex4(:),G2H2(90),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hotf_5pt_reduction(G2H4(228),RedSet_5(30),mass5set(:,1),  & 
G1H4(679),G1H4(680),G1H4(681),G1H4(682),G1H4(683),G1H4(684),4)
  call HG1shiftOLR(G1H4(680),16,4)
  call Hotf_5pt_reduction(G2H4(230),RedSet_5(30),mass5set(:,1),  & 
G1H4(685),G1H4(686),G1H4(687),G1H4(688),G1H4(689),G1H4(690),4)
  call HG1shiftOLR(G1H4(686),16,4)
  call Hloop_SV_V(ntryL,G2H4(232),ex4(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_VV_S(ntryL,G2H4(234),ex4(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hotf_5pt_reduction(G2H4(236),RedSet_5(30),mass5set(:,1),  & 
G1H4(691),G1H4(692),G1H4(693),G1H4(694),G1H4(695),G1H4(696),4)
  call HG1shiftOLR(G1H4(692),16,4)
  call Hotf_5pt_reduction(G2H4(237),RedSet_5(6),mass5set(:,2),  & 
G1H4(697),G1H4(698),G1H4(699),G1H4(700),G1H4(701),G1H4(702),4)
  call HG1shiftOLR(G1H4(698),16,4)
  call Hotf_5pt_reduction(G2H4(239),RedSet_5(20),mass5set(:,14),  & 
G1H4(703),G1H4(704),G1H4(705),G1H4(706),G1H4(707),G1H4(708),4)
  call HG1shiftOLR(G1H4(704),16,4)
  call Hotf_5pt_reduction(G2H4(240),RedSet_5(6),mass5set(:,3),  & 
G1H4(709),G1H4(710),G1H4(711),G1H4(712),G1H4(713),G1H4(714),4)
  call HG1shiftOLR(G1H4(710),16,4)
  call Hotf_5pt_reduction(G2H4(242),RedSet_5(20),mass5set(:,14),  & 
G1H4(715),G1H4(716),G1H4(717),G1H4(718),G1H4(719),G1H4(720),4)
  call HG1shiftOLR(G1H4(716),16,4)
  call Hotf_5pt_reduction(G2H4(243),RedSet_5(6),mass5set(:,5),  & 
G1H4(721),G1H4(722),G1H4(723),G1H4(724),G1H4(725),G1H4(726),4)
  call HG1shiftOLR(G1H4(722),16,4)
  call Hotf_5pt_reduction(G2H4(245),RedSet_5(20),mass5set(:,14),  & 
G1H4(727),G1H4(728),G1H4(729),G1H4(730),G1H4(731),G1H4(732),4)
  call HG1shiftOLR(G1H4(728),16,4)
  call Hotf_5pt_reduction(G2H4(246),RedSet_5(6),mass5set(:,3),  & 
G1H4(733),G1H4(734),G1H4(735),G1H4(736),G1H4(737),G1H4(738),4)
  call HG1shiftOLR(G1H4(734),16,4)
  call Hotf_5pt_reduction(G2H4(248),RedSet_5(20),mass5set(:,14),  & 
G1H4(739),G1H4(740),G1H4(741),G1H4(742),G1H4(743),G1H4(744),4)
  call HG1shiftOLR(G1H4(740),16,4)
  call Hotf_5pt_reduction(G2H4(249),RedSet_5(7),mass5set(:,2),  & 
G1H4(745),G1H4(746),G1H4(747),G1H4(748),G1H4(749),G1H4(750),4)
  call HG1shiftOLR(G1H4(746),8,4)
  call Hotf_5pt_reduction(G2H4(251),RedSet_5(22),mass5set(:,14),  & 
G1H4(751),G1H4(752),G1H4(753),G1H4(754),G1H4(755),G1H4(756),4)
  call HG1shiftOLR(G1H4(752),8,4)
  call Hotf_5pt_reduction(G2H4(252),RedSet_5(7),mass5set(:,3),  & 
G1H4(757),G1H4(758),G1H4(759),G1H4(760),G1H4(761),G1H4(762),4)
  call HG1shiftOLR(G1H4(758),8,4)
  call Hotf_5pt_reduction(G2H4(254),RedSet_5(22),mass5set(:,14),  & 
G1H4(763),G1H4(764),G1H4(765),G1H4(766),G1H4(767),G1H4(768),4)
  call HG1shiftOLR(G1H4(764),8,4)
  call Hotf_5pt_reduction(G2H4(255),RedSet_5(7),mass5set(:,5),  & 
G1H4(769),G1H4(770),G1H4(771),G1H4(772),G1H4(773),G1H4(774),4)
  call HG1shiftOLR(G1H4(770),8,4)
  call Hotf_5pt_reduction(G2H4(257),RedSet_5(22),mass5set(:,14),  & 
G1H4(775),G1H4(776),G1H4(777),G1H4(778),G1H4(779),G1H4(780),4)
  call HG1shiftOLR(G1H4(776),8,4)
  call Hotf_5pt_reduction(G2H4(258),RedSet_5(7),mass5set(:,3),  & 
G1H4(781),G1H4(782),G1H4(783),G1H4(784),G1H4(785),G1H4(786),4)
  call HG1shiftOLR(G1H4(782),8,4)
  call Hotf_5pt_reduction(G2H4(260),RedSet_5(22),mass5set(:,14),  & 
G1H4(787),G1H4(788),G1H4(789),G1H4(790),G1H4(791),G1H4(792),4)
  call HG1shiftOLR(G1H4(788),8,4)
  call Hotf_5pt_reduction(G2H4(261),RedSet_5(8),mass5set(:,2),  & 
G1H4(793),G1H4(794),G1H4(795),G1H4(796),G1H4(797),G1H4(798),4)
  call HG1shiftOLR(G1H4(794),16,4)
  call Hotf_5pt_reduction(G2H4(263),RedSet_5(18),mass5set(:,14),  & 
G1H4(799),G1H4(800),G1H4(801),G1H4(802),G1H4(803),G1H4(804),4)
  call HG1shiftOLR(G1H4(800),16,4)
  call Hotf_5pt_reduction(G2H4(264),RedSet_5(8),mass5set(:,3),  & 
G1H4(805),G1H4(806),G1H4(807),G1H4(808),G1H4(809),G1H4(810),4)
  call HG1shiftOLR(G1H4(806),16,4)
  call Hotf_5pt_reduction(G2H4(266),RedSet_5(18),mass5set(:,14),  & 
G1H4(811),G1H4(812),G1H4(813),G1H4(814),G1H4(815),G1H4(816),4)
  call HG1shiftOLR(G1H4(812),16,4)
  call Hotf_5pt_reduction(G2H4(267),RedSet_5(8),mass5set(:,5),  & 
G1H4(817),G1H4(818),G1H4(819),G1H4(820),G1H4(821),G1H4(822),4)
  call HG1shiftOLR(G1H4(818),16,4)
  call Hotf_5pt_reduction(G2H4(269),RedSet_5(18),mass5set(:,14),  & 
G1H4(823),G1H4(824),G1H4(825),G1H4(826),G1H4(827),G1H4(828),4)
  call HG1shiftOLR(G1H4(824),16,4)
  call Hotf_5pt_reduction(G2H4(270),RedSet_5(8),mass5set(:,3),  & 
G1H4(829),G1H4(830),G1H4(831),G1H4(832),G1H4(833),G1H4(834),4)
  call HG1shiftOLR(G1H4(830),16,4)
  call Hotf_5pt_reduction(G2H4(272),RedSet_5(18),mass5set(:,14),  & 
G1H4(835),G1H4(836),G1H4(837),G1H4(838),G1H4(839),G1H4(840),4)
  call HG1shiftOLR(G1H4(836),16,4)
  call Hotf_5pt_reduction(G2H4(274),RedSet_5(31),mass5set(:,1),  & 
G1H4(841),G1H4(842),G1H4(843),G1H4(844),G1H4(845),G1H4(846),4)
  call HG1shiftOLR(G1H4(842),8,4)
  call Hloop_SV_V(ntryL,G2H4(276),ex5(:),G2H2(93),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_VV_S(ntryL,G2H4(278),ex5(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hotf_5pt_reduction(G2H4(280),RedSet_5(31),mass5set(:,1),  & 
G1H4(847),G1H4(848),G1H4(849),G1H4(850),G1H4(851),G1H4(852),4)
  call HG1shiftOLR(G1H4(848),8,4)
  call Hotf_5pt_reduction(G2H4(282),RedSet_5(31),mass5set(:,1),  & 
G1H4(853),G1H4(854),G1H4(855),G1H4(856),G1H4(857),G1H4(858),4)
  call HG1shiftOLR(G1H4(854),8,4)
  call Hloop_SV_V(ntryL,G2H4(284),ex5(:),G2H2(95),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_VV_S(ntryL,G2H4(286),ex5(:),G2H2(96),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hotf_5pt_reduction(G2H4(288),RedSet_5(31),mass5set(:,1),  & 
G1H4(859),G1H4(860),G1H4(861),G1H4(862),G1H4(863),G1H4(864),4)
  call HG1shiftOLR(G1H4(860),8,4)
  call Hotf_5pt_reduction(G2H4(289),RedSet_5(9),mass5set(:,2),  & 
G1H4(865),G1H4(866),G1H4(867),G1H4(868),G1H4(869),G1H4(870),4)
  call HG1shiftOLR(G1H4(866),16,4)
  call Hotf_5pt_reduction(G2H4(291),RedSet_5(20),mass5set(:,14),  & 
G1H4(871),G1H4(872),G1H4(873),G1H4(874),G1H4(875),G1H4(876),4)
  call HG1shiftOLR(G1H4(872),16,4)
  call Hotf_5pt_reduction(G2H4(292),RedSet_5(9),mass5set(:,3),  & 
G1H4(877),G1H4(878),G1H4(879),G1H4(880),G1H4(881),G1H4(882),4)
  call HG1shiftOLR(G1H4(878),16,4)
  call Hotf_5pt_reduction(G2H4(294),RedSet_5(20),mass5set(:,14),  & 
G1H4(883),G1H4(884),G1H4(885),G1H4(886),G1H4(887),G1H4(888),4)
  call HG1shiftOLR(G1H4(884),16,4)
  call Hotf_5pt_reduction(G2H4(295),RedSet_5(9),mass5set(:,5),  & 
G1H4(889),G1H4(890),G1H4(891),G1H4(892),G1H4(893),G1H4(894),4)
  call HG1shiftOLR(G1H4(890),16,4)
  call Hotf_5pt_reduction(G2H4(297),RedSet_5(20),mass5set(:,14),  & 
G1H4(895),G1H4(896),G1H4(897),G1H4(898),G1H4(899),G1H4(900),4)
  call HG1shiftOLR(G1H4(896),16,4)
  call Hotf_5pt_reduction(G2H4(298),RedSet_5(9),mass5set(:,3),  & 
G1H4(901),G1H4(902),G1H4(903),G1H4(904),G1H4(905),G1H4(906),4)
  call HG1shiftOLR(G1H4(902),16,4)
  call Hotf_5pt_reduction(G2H4(300),RedSet_5(20),mass5set(:,14),  & 
G1H4(907),G1H4(908),G1H4(909),G1H4(910),G1H4(911),G1H4(912),4)
  call HG1shiftOLR(G1H4(908),16,4)
  call Hotf_5pt_reduction(G2H4(301),RedSet_5(10),mass5set(:,2),  & 
G1H4(913),G1H4(914),G1H4(915),G1H4(916),G1H4(917),G1H4(918),4)
  call HG1shiftOLR(G1H4(914),8,4)
  call Hotf_5pt_reduction(G2H4(303),RedSet_5(22),mass5set(:,14),  & 
G1H4(919),G1H4(920),G1H4(921),G1H4(922),G1H4(923),G1H4(924),4)
  call HG1shiftOLR(G1H4(920),8,4)
  call Hotf_5pt_reduction(G2H4(304),RedSet_5(10),mass5set(:,3),  & 
G1H4(925),G1H4(926),G1H4(927),G1H4(928),G1H4(929),G1H4(930),4)
  call HG1shiftOLR(G1H4(926),8,4)
  call Hotf_5pt_reduction(G2H4(306),RedSet_5(22),mass5set(:,14),  & 
G1H4(931),G1H4(932),G1H4(933),G1H4(934),G1H4(935),G1H4(936),4)
  call HG1shiftOLR(G1H4(932),8,4)
  call Hotf_5pt_reduction(G2H4(307),RedSet_5(10),mass5set(:,5),  & 
G1H4(937),G1H4(938),G1H4(939),G1H4(940),G1H4(941),G1H4(942),4)
  call HG1shiftOLR(G1H4(938),8,4)
  call Hotf_5pt_reduction(G2H4(309),RedSet_5(22),mass5set(:,14),  & 
G1H4(943),G1H4(944),G1H4(945),G1H4(946),G1H4(947),G1H4(948),4)
  call HG1shiftOLR(G1H4(944),8,4)
  call Hotf_5pt_reduction(G2H4(310),RedSet_5(10),mass5set(:,3),  & 
G1H4(949),G1H4(950),G1H4(951),G1H4(952),G1H4(953),G1H4(954),4)
  call HG1shiftOLR(G1H4(950),8,4)
  call Hotf_5pt_reduction(G2H4(312),RedSet_5(22),mass5set(:,14),  & 
G1H4(955),G1H4(956),G1H4(957),G1H4(958),G1H4(959),G1H4(960),4)
  call HG1shiftOLR(G1H4(956),8,4)
  call Hotf_5pt_reduction(G2H4(313),RedSet_5(1),mass5set(:,6),  & 
G1H4(961),G1H4(962),G1H4(963),G1H4(964),G1H4(965),G1H4(966),4)
  call HG1shiftOLR(G1H4(962),16,4)
  call Hotf_5pt_reduction(G2H4(316),RedSet_5(26),mass5set(:,6),  & 
G1H4(967),G1H4(968),G1H4(969),G1H4(970),G1H4(971),G1H4(972),4)
  call HG1shiftOLR(G1H4(968),16,4)
  call Hotf_5pt_reduction(G2H4(325),RedSet_5(1),mass5set(:,7),  & 
G1H4(973),G1H4(974),G1H4(975),G1H4(976),G1H4(977),G1H4(978),4)
  call HG1shiftOLR(G1H4(974),16,4)
  call Hotf_5pt_reduction(G2H4(328),RedSet_5(26),mass5set(:,7),  & 
G1H4(979),G1H4(980),G1H4(981),G1H4(982),G1H4(983),G1H4(984),4)
  call HG1shiftOLR(G1H4(980),16,4)
  call Hotf_5pt_reduction(G2H4(321),RedSet_5(1),mass5set(:,8),  & 
G1H4(985),G1H4(986),G1H4(987),G1H4(988),G1H4(989),G1H4(990),4)
  call HG1shiftOLR(G1H4(986),16,4)
  call Hotf_5pt_reduction(G2H4(324),RedSet_5(26),mass5set(:,8),  & 
G1H4(991),G1H4(992),G1H4(993),G1H4(994),G1H4(995),G1H4(996),4)
  call HG1shiftOLR(G1H4(992),16,4)
  call Hotf_5pt_reduction(G2H4(329),RedSet_5(2),mass5set(:,6),  & 
G1H4(997),G1H4(998),G1H4(999),G1H4(1000),G1H4(1001),G1H4(1002),4)
  call HG1shiftOLR(G1H4(998),16,4)
  call Hotf_5pt_reduction(G2H4(332),RedSet_5(27),mass5set(:,6),  & 
G1H4(1003),G1H4(1004),G1H4(1005),G1H4(1006),G1H4(1007),G1H4(1008),4)
  call HG1shiftOLR(G1H4(1004),16,4)
  call Hotf_5pt_reduction(G2H4(341),RedSet_5(2),mass5set(:,7),  & 
G1H4(1009),G1H4(1010),G1H4(1011),G1H4(1012),G1H4(1013),G1H4(1014),4)
  call HG1shiftOLR(G1H4(1010),16,4)
  call Hotf_5pt_reduction(G2H4(344),RedSet_5(27),mass5set(:,7),  & 
G1H4(1015),G1H4(1016),G1H4(1017),G1H4(1018),G1H4(1019),G1H4(1020),4)
  call HG1shiftOLR(G1H4(1016),16,4)
  call Hotf_5pt_reduction(G2H4(337),RedSet_5(2),mass5set(:,8),  & 
G1H4(1021),G1H4(1022),G1H4(1023),G1H4(1024),G1H4(1025),G1H4(1026),4)
  call HG1shiftOLR(G1H4(1022),16,4)
  call Hotf_5pt_reduction(G2H4(340),RedSet_5(27),mass5set(:,8),  & 
G1H4(1027),G1H4(1028),G1H4(1029),G1H4(1030),G1H4(1031),G1H4(1032),4)
  call HG1shiftOLR(G1H4(1028),16,4)
  call Hloop_QA_S(ntryL,G2H4(363),ex2(:),G2H2(97),ngPln,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_S(ntryL,G2H4(365),ex2(:),G2H2(98),ngPln,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QA_S(ntryL,G2H4(352),ex2(:),G2H2(99),ngPln,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QA_S(ntryL,G2H4(355),ex2(:),G2H2(100),ngPln,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_QA_W(ntryL,G2H4(369),ex2(:),G2H2(101),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_QA_W(ntryL,G2H4(372),ex2(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QA_W(ntryL,G2H4(366),ex2(:),G2H2(103),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_QA_W(ntryL,G2H4(368),ex2(:),G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hotf_5pt_reduction(G2H4(373),RedSet_5(2),mass5set(:,6),  & 
G1H4(1033),G1H4(1034),G1H4(1035),G1H4(1036),G1H4(1037),G1H4(1038),4)
  call HG1shiftOLR(G1H4(1034),8,4)
  call Hotf_5pt_reduction(G2H4(376),RedSet_5(28),mass5set(:,6),  & 
G1H4(1039),G1H4(1040),G1H4(1041),G1H4(1042),G1H4(1043),G1H4(1044),4)
  call HG1shiftOLR(G1H4(1040),8,4)
  call Hotf_5pt_reduction(G2H4(385),RedSet_5(2),mass5set(:,7),  & 
G1H4(1045),G1H4(1046),G1H4(1047),G1H4(1048),G1H4(1049),G1H4(1050),4)
  call HG1shiftOLR(G1H4(1046),8,4)
  call Hotf_5pt_reduction(G2H4(388),RedSet_5(28),mass5set(:,7),  & 
G1H4(1051),G1H4(1052),G1H4(1053),G1H4(1054),G1H4(1055),G1H4(1056),4)
  call HG1shiftOLR(G1H4(1052),8,4)
  call Hotf_5pt_reduction(G2H4(381),RedSet_5(2),mass5set(:,8),  & 
G1H4(1057),G1H4(1058),G1H4(1059),G1H4(1060),G1H4(1061),G1H4(1062),4)
  call HG1shiftOLR(G1H4(1058),8,4)
  call Hotf_5pt_reduction(G2H4(384),RedSet_5(28),mass5set(:,8),  & 
G1H4(1063),G1H4(1064),G1H4(1065),G1H4(1066),G1H4(1067),G1H4(1068),4)
  call HG1shiftOLR(G1H4(1064),8,4)
  call Hotf_5pt_reduction(G2H4(389),RedSet_5(11),mass5set(:,9),  & 
G1H4(1069),G1H4(1070),G1H4(1071),G1H4(1072),G1H4(1073),G1H4(1074),4)
  call HG1shiftOLR(G1H4(1070),16,4)
  call Hotf_5pt_reduction(G2H4(392),RedSet_5(32),mass5set(:,9),  & 
G1H4(1075),G1H4(1076),G1H4(1077),G1H4(1078),G1H4(1079),G1H4(1080),4)
  call HG1shiftOLR(G1H4(1076),16,4)
  call Hotf_5pt_reduction(G2H4(393),RedSet_5(11),mass5set(:,10),  & 
G1H4(1081),G1H4(1082),G1H4(1083),G1H4(1084),G1H4(1085),G1H4(1086),4)
  call HG1shiftOLR(G1H4(1082),16,4)
  call Hotf_5pt_reduction(G2H4(396),RedSet_5(32),mass5set(:,10),  & 
G1H4(1087),G1H4(1088),G1H4(1089),G1H4(1090),G1H4(1091),G1H4(1092),4)
  call HG1shiftOLR(G1H4(1088),16,4)
  call Hotf_5pt_reduction(G2H4(400),RedSet_5(32),mass5set(:,11),  & 
G1H4(1093),G1H4(1094),G1H4(1095),G1H4(1096),G1H4(1097),G1H4(1098),4)
  call HG1shiftOLR(G1H4(1094),16,4)
  call Hotf_5pt_reduction(G2H4(401),RedSet_5(11),mass5set(:,12),  & 
G1H4(1099),G1H4(1100),G1H4(1101),G1H4(1102),G1H4(1103),G1H4(1104),4)
  call HG1shiftOLR(G1H4(1100),16,4)
  call Hotf_5pt_reduction(G2H4(404),RedSet_5(32),mass5set(:,12),  & 
G1H4(1105),G1H4(1106),G1H4(1107),G1H4(1108),G1H4(1109),G1H4(1110),4)
  call HG1shiftOLR(G1H4(1106),16,4)
  call Hotf_5pt_reduction(G2H4(407),RedSet_5(32),mass5set(:,11),  & 
G1H4(1111),G1H4(1112),G1H4(1113),G1H4(1114),G1H4(1115),G1H4(1116),4)
  call HG1shiftOLR(G1H4(1112),16,4)
  call Hloop_SV_V(ntryL,G2H4(410),ex4(:),G2H2(105),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_SV_V(ntryL,G2H4(414),ex4(:),G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VV_S(ntryL,G2H4(418),ex4(:),G2H2(107),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_VV_S(ntryL,G2H4(421),ex4(:),G2H2(108),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hotf_5pt_reduction(G2H4(424),RedSet_5(32),mass5set(:,11),  & 
G1H4(1117),G1H4(1118),G1H4(1119),G1H4(1120),G1H4(1121),G1H4(1122),4)
  call HG1shiftOLR(G1H4(1118),16,4)
  call Hotf_5pt_reduction(G2H4(428),RedSet_5(32),mass5set(:,11),  & 
G1H4(1123),G1H4(1124),G1H4(1125),G1H4(1126),G1H4(1127),G1H4(1128),4)
  call HG1shiftOLR(G1H4(1124),16,4)
  call Hotf_5pt_reduction(G2H4(429),RedSet_5(11),mass5set(:,9),  & 
G1H4(1129),G1H4(1130),G1H4(1131),G1H4(1132),G1H4(1133),G1H4(1134),4)
  call HG1shiftOLR(G1H4(1130),8,4)
  call Hotf_5pt_reduction(G2H4(432),RedSet_5(33),mass5set(:,9),  & 
G1H4(1135),G1H4(1136),G1H4(1137),G1H4(1138),G1H4(1139),G1H4(1140),4)
  call HG1shiftOLR(G1H4(1136),8,4)
  call Hotf_5pt_reduction(G2H4(433),RedSet_5(11),mass5set(:,10),  & 
G1H4(1141),G1H4(1142),G1H4(1143),G1H4(1144),G1H4(1145),G1H4(1146),4)
  call HG1shiftOLR(G1H4(1142),8,4)
  call Hotf_5pt_reduction(G2H4(436),RedSet_5(33),mass5set(:,10),  & 
G1H4(1147),G1H4(1148),G1H4(1149),G1H4(1150),G1H4(1151),G1H4(1152),4)
  call HG1shiftOLR(G1H4(1148),8,4)
  call Hotf_5pt_reduction(G2H4(440),RedSet_5(33),mass5set(:,11),  & 
G1H4(1153),G1H4(1154),G1H4(1155),G1H4(1156),G1H4(1157),G1H4(1158),4)
  call HG1shiftOLR(G1H4(1154),8,4)
  call Hotf_5pt_reduction(G2H4(441),RedSet_5(11),mass5set(:,12),  & 
G1H4(1159),G1H4(1160),G1H4(1161),G1H4(1162),G1H4(1163),G1H4(1164),4)
  call HG1shiftOLR(G1H4(1160),8,4)
  call Hotf_5pt_reduction(G2H4(444),RedSet_5(33),mass5set(:,12),  & 
G1H4(1165),G1H4(1166),G1H4(1167),G1H4(1168),G1H4(1169),G1H4(1170),4)
  call HG1shiftOLR(G1H4(1166),8,4)
  call Hotf_5pt_reduction(G2H4(447),RedSet_5(33),mass5set(:,11),  & 
G1H4(1171),G1H4(1172),G1H4(1173),G1H4(1174),G1H4(1175),G1H4(1176),4)
  call HG1shiftOLR(G1H4(1172),8,4)
  call Hloop_SV_V(ntryL,G2H4(450),ex5(:),G2H2(109),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_SV_V(ntryL,G2H4(454),ex5(:),G2H2(110),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_VV_S(ntryL,G2H4(458),ex5(:),G2H2(111),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_VV_S(ntryL,G2H4(461),ex5(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hotf_5pt_reduction(G2H4(464),RedSet_5(33),mass5set(:,11),  & 
G1H4(1177),G1H4(1178),G1H4(1179),G1H4(1180),G1H4(1181),G1H4(1182),4)
  call HG1shiftOLR(G1H4(1178),8,4)
  call Hotf_5pt_reduction(G2H4(468),RedSet_5(33),mass5set(:,11),  & 
G1H4(1183),G1H4(1184),G1H4(1185),G1H4(1186),G1H4(1187),G1H4(1188),4)
  call HG1shiftOLR(G1H4(1184),8,4)
  call Hotf_5pt_reduction(G2H4(469),RedSet_5(4),mass5set(:,6),  & 
G1H4(1189),G1H4(1190),G1H4(1191),G1H4(1192),G1H4(1193),G1H4(1194),4)
  call HG1shiftOLR(G1H4(1190),16,4)
  call Hotf_5pt_reduction(G2H4(472),RedSet_5(29),mass5set(:,6),  & 
G1H4(1195),G1H4(1196),G1H4(1197),G1H4(1198),G1H4(1199),G1H4(1200),4)
  call HG1shiftOLR(G1H4(1196),16,4)
  call Hotf_5pt_reduction(G2H4(481),RedSet_5(4),mass5set(:,7),  & 
G1H4(1201),G1H4(1202),G1H4(1203),G1H4(1204),G1H4(1205),G1H4(1206),4)
  call HG1shiftOLR(G1H4(1202),16,4)
  call Hotf_5pt_reduction(G2H4(484),RedSet_5(29),mass5set(:,7),  & 
G1H4(1207),G1H4(1208),G1H4(1209),G1H4(1210),G1H4(1211),G1H4(1212),4)
  call HG1shiftOLR(G1H4(1208),16,4)
  call Hotf_5pt_reduction(G2H4(477),RedSet_5(4),mass5set(:,8),  & 
G1H4(1213),G1H4(1214),G1H4(1215),G1H4(1216),G1H4(1217),G1H4(1218),4)
  call HG1shiftOLR(G1H4(1214),16,4)
  call Hotf_5pt_reduction(G2H4(480),RedSet_5(29),mass5set(:,8),  & 
G1H4(1219),G1H4(1220),G1H4(1221),G1H4(1222),G1H4(1223),G1H4(1224),4)
  call HG1shiftOLR(G1H4(1220),16,4)
  call Hotf_5pt_reduction(G2H4(485),RedSet_5(5),mass5set(:,6),  & 
G1H4(1225),G1H4(1226),G1H4(1227),G1H4(1228),G1H4(1229),G1H4(1230),4)
  call HG1shiftOLR(G1H4(1226),16,4)
  call Hotf_5pt_reduction(G2H4(488),RedSet_5(30),mass5set(:,6),  & 
G1H4(1231),G1H4(1232),G1H4(1233),G1H4(1234),G1H4(1235),G1H4(1236),4)
  call HG1shiftOLR(G1H4(1232),16,4)
  call Hotf_5pt_reduction(G2H4(497),RedSet_5(5),mass5set(:,7),  & 
G1H4(1237),G1H4(1238),G1H4(1239),G1H4(1240),G1H4(1241),G1H4(1242),4)
  call HG1shiftOLR(G1H4(1238),16,4)
  call Hotf_5pt_reduction(G2H4(500),RedSet_5(30),mass5set(:,7),  & 
G1H4(1243),G1H4(1244),G1H4(1245),G1H4(1246),G1H4(1247),G1H4(1248),4)
  call HG1shiftOLR(G1H4(1244),16,4)
  call Hotf_5pt_reduction(G2H4(493),RedSet_5(5),mass5set(:,8),  & 
G1H4(1249),G1H4(1250),G1H4(1251),G1H4(1252),G1H4(1253),G1H4(1254),4)
  call HG1shiftOLR(G1H4(1250),16,4)
  call Hotf_5pt_reduction(G2H4(496),RedSet_5(30),mass5set(:,8),  & 
G1H4(1255),G1H4(1256),G1H4(1257),G1H4(1258),G1H4(1259),G1H4(1260),4)
  call HG1shiftOLR(G1H4(1256),16,4)
  call Hloop_QA_S(ntryL,G2H4(519),ex2(:),G2H2(113),ngPln,m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_QA_S(ntryL,G2H4(521),ex2(:),G2H2(114),ngPln,m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QA_S(ntryL,G2H4(508),ex2(:),G2H2(115),ngPln,m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_QA_S(ntryL,G2H4(511),ex2(:),G2H2(116),ngPln,m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QA_W(ntryL,G2H4(525),ex2(:),G2H2(117),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_W(ntryL,G2H4(528),ex2(:),G2H2(118),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QA_W(ntryL,G2H4(522),ex2(:),G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_QA_W(ntryL,G2H4(524),ex2(:),G2H2(120),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_AQ_S(ntryL,G2H4(540),ex1(:),G2H2(121),ngPnl,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_AQ_S(ntryL,G2H4(542),ex1(:),G2H2(122),ngPnl,m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_AQ_S(ntryL,G2H4(536),ex1(:),G2H2(123),ngPnl,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_AQ_S(ntryL,G2H4(539),ex1(:),G2H2(124),ngPnl,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_AQ_W(ntryL,G2H4(553),ex1(:),G2H2(125),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_AQ_W(ntryL,G2H4(556),ex1(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_AQ_W(ntryL,G2H4(550),ex1(:),G2H2(127),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_AQ_W(ntryL,G2H4(552),ex1(:),G2H2(128),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hotf_5pt_reduction(G2H4(557),RedSet_5(12),mass5set(:,9),  & 
G1H4(1261),G1H4(1262),G1H4(1263),G1H4(1264),G1H4(1265),G1H4(1266),4)
  call HG1shiftOLR(G1H4(1262),16,4)
  call Hotf_5pt_reduction(G2H4(560),RedSet_5(32),mass5set(:,9),  & 
G1H4(1267),G1H4(1268),G1H4(1269),G1H4(1270),G1H4(1271),G1H4(1272),4)
  call HG1shiftOLR(G1H4(1268),16,4)
  call Hotf_5pt_reduction(G2H4(561),RedSet_5(12),mass5set(:,10),  & 
G1H4(1273),G1H4(1274),G1H4(1275),G1H4(1276),G1H4(1277),G1H4(1278),4)
  call HG1shiftOLR(G1H4(1274),16,4)
  call Hotf_5pt_reduction(G2H4(564),RedSet_5(32),mass5set(:,10),  & 
G1H4(1279),G1H4(1280),G1H4(1281),G1H4(1282),G1H4(1283),G1H4(1284),4)
  call HG1shiftOLR(G1H4(1280),16,4)
  call Hotf_5pt_reduction(G2H4(568),RedSet_5(32),mass5set(:,11),  & 
G1H4(1285),G1H4(1286),G1H4(1287),G1H4(1288),G1H4(1289),G1H4(1290),4)
  call HG1shiftOLR(G1H4(1286),16,4)
  call Hotf_5pt_reduction(G2H4(569),RedSet_5(12),mass5set(:,12),  & 
G1H4(1291),G1H4(1292),G1H4(1293),G1H4(1294),G1H4(1295),G1H4(1296),4)
  call HG1shiftOLR(G1H4(1292),16,4)
  call Hotf_5pt_reduction(G2H4(572),RedSet_5(32),mass5set(:,12),  & 
G1H4(1297),G1H4(1298),G1H4(1299),G1H4(1300),G1H4(1301),G1H4(1302),4)
  call HG1shiftOLR(G1H4(1298),16,4)
  call Hotf_5pt_reduction(G2H4(575),RedSet_5(32),mass5set(:,11),  & 
G1H4(1303),G1H4(1304),G1H4(1305),G1H4(1306),G1H4(1307),G1H4(1308),4)
  call HG1shiftOLR(G1H4(1304),16,4)
  call Hloop_SV_V(ntryL,G2H4(578),ex3(:),G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_SV_V(ntryL,G2H4(582),ex3(:),G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_VV_S(ntryL,G2H4(586),ex3(:),G2H2(131),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_VV_S(ntryL,G2H4(589),ex3(:),G2H2(132),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hotf_5pt_reduction(G2H4(592),RedSet_5(32),mass5set(:,11),  & 
G1H4(1309),G1H4(1310),G1H4(1311),G1H4(1312),G1H4(1313),G1H4(1314),4)
  call HG1shiftOLR(G1H4(1310),16,4)
  call Hotf_5pt_reduction(G2H4(596),RedSet_5(32),mass5set(:,11),  & 
G1H4(1315),G1H4(1316),G1H4(1317),G1H4(1318),G1H4(1319),G1H4(1320),4)
  call HG1shiftOLR(G1H4(1316),16,4)
  call Hotf_5pt_reduction(G2H4(597),RedSet_5(12),mass5set(:,9),  & 
G1H4(1321),G1H4(1322),G1H4(1323),G1H4(1324),G1H4(1325),G1H4(1326),4)
  call HG1shiftOLR(G1H4(1322),4,4)
  call Hotf_5pt_reduction(G2H4(600),RedSet_5(34),mass5set(:,9),  & 
G1H4(1327),G1H4(1328),G1H4(1329),G1H4(1330),G1H4(1331),G1H4(1332),4)
  call HG1shiftOLR(G1H4(1328),4,4)
  call Hotf_5pt_reduction(G2H4(601),RedSet_5(12),mass5set(:,10),  & 
G1H4(1333),G1H4(1334),G1H4(1335),G1H4(1336),G1H4(1337),G1H4(1338),4)
  call HG1shiftOLR(G1H4(1334),4,4)
  call Hotf_5pt_reduction(G2H4(604),RedSet_5(34),mass5set(:,10),  & 
G1H4(1339),G1H4(1340),G1H4(1341),G1H4(1342),G1H4(1343),G1H4(1344),4)
  call HG1shiftOLR(G1H4(1340),4,4)
  call Hotf_5pt_reduction(G2H4(608),RedSet_5(34),mass5set(:,11),  & 
G1H4(1345),G1H4(1346),G1H4(1347),G1H4(1348),G1H4(1349),G1H4(1350),4)
  call HG1shiftOLR(G1H4(1346),4,4)
  call Hotf_5pt_reduction(G2H4(609),RedSet_5(12),mass5set(:,12),  & 
G1H4(1351),G1H4(1352),G1H4(1353),G1H4(1354),G1H4(1355),G1H4(1356),4)
  call HG1shiftOLR(G1H4(1352),4,4)
  call Hotf_5pt_reduction(G2H4(612),RedSet_5(34),mass5set(:,12),  & 
G1H4(1357),G1H4(1358),G1H4(1359),G1H4(1360),G1H4(1361),G1H4(1362),4)
  call HG1shiftOLR(G1H4(1358),4,4)
  call Hotf_5pt_reduction(G2H4(615),RedSet_5(34),mass5set(:,11),  & 
G1H4(1363),G1H4(1364),G1H4(1365),G1H4(1366),G1H4(1367),G1H4(1368),4)
  call HG1shiftOLR(G1H4(1364),4,4)
  call Hloop_SV_V(ntryL,G2H4(618),ex5(:),G2H2(133),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_SV_V(ntryL,G2H4(622),ex5(:),G2H2(134),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VV_S(ntryL,G2H4(626),ex5(:),G2H2(135),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_VV_S(ntryL,G2H4(629),ex5(:),G2H2(136),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hotf_5pt_reduction(G2H4(632),RedSet_5(34),mass5set(:,11),  & 
G1H4(1369),G1H4(1370),G1H4(1371),G1H4(1372),G1H4(1373),G1H4(1374),4)
  call HG1shiftOLR(G1H4(1370),4,4)
  call Hotf_5pt_reduction(G2H4(636),RedSet_5(34),mass5set(:,11),  & 
G1H4(1375),G1H4(1376),G1H4(1377),G1H4(1378),G1H4(1379),G1H4(1380),4)
  call HG1shiftOLR(G1H4(1376),4,4)
  call Hloop_AQ_S(ntryL,G2H4(648),ex1(:),G2H2(137),ngPnl,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_AQ_S(ntryL,G2H4(650),ex1(:),G2H2(138),ngPnl,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_AQ_S(ntryL,G2H4(644),ex1(:),G2H2(139),ngPnl,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_AQ_S(ntryL,G2H4(647),ex1(:),G2H2(140),ngPnl,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_AQ_W(ntryL,G2H4(661),ex1(:),G2H2(141),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_AQ_W(ntryL,G2H4(664),ex1(:),G2H2(142),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AQ_W(ntryL,G2H4(658),ex1(:),G2H2(143),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_AQ_W(ntryL,G2H4(660),ex1(:),G2H2(144),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hotf_5pt_reduction(G2H4(665),RedSet_5(5),mass5set(:,6),  & 
G1H4(1381),G1H4(1382),G1H4(1383),G1H4(1384),G1H4(1385),G1H4(1386),4)
  call HG1shiftOLR(G1H4(1382),8,4)
  call Hotf_5pt_reduction(G2H4(668),RedSet_5(31),mass5set(:,6),  & 
G1H4(1387),G1H4(1388),G1H4(1389),G1H4(1390),G1H4(1391),G1H4(1392),4)
  call HG1shiftOLR(G1H4(1388),8,4)
  call Hotf_5pt_reduction(G2H4(677),RedSet_5(5),mass5set(:,7),  & 
G1H4(1393),G1H4(1394),G1H4(1395),G1H4(1396),G1H4(1397),G1H4(1398),4)
  call HG1shiftOLR(G1H4(1394),8,4)
  call Hotf_5pt_reduction(G2H4(680),RedSet_5(31),mass5set(:,7),  & 
G1H4(1399),G1H4(1400),G1H4(1401),G1H4(1402),G1H4(1403),G1H4(1404),4)
  call HG1shiftOLR(G1H4(1400),8,4)
  call Hotf_5pt_reduction(G2H4(673),RedSet_5(5),mass5set(:,8),  & 
G1H4(1405),G1H4(1406),G1H4(1407),G1H4(1408),G1H4(1409),G1H4(1410),4)
  call HG1shiftOLR(G1H4(1406),8,4)
  call Hotf_5pt_reduction(G2H4(676),RedSet_5(31),mass5set(:,8),  & 
G1H4(1411),G1H4(1412),G1H4(1413),G1H4(1414),G1H4(1415),G1H4(1416),4)
  call HG1shiftOLR(G1H4(1412),8,4)
  call Hloop_AQ_S(ntryL,G2H4(692),ex1(:),G2H2(145),ngPnl,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_AQ_S(ntryL,G2H4(694),ex1(:),G2H2(146),ngPnl,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_AQ_S(ntryL,G2H4(688),ex1(:),G2H2(147),ngPnl,m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_AQ_S(ntryL,G2H4(691),ex1(:),G2H2(148),ngPnl,m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_AQ_W(ntryL,G2H4(705),ex1(:),G2H2(149),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_AQ_W(ntryL,G2H4(708),ex1(:),G2H2(150),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_AQ_W(ntryL,G2H4(702),ex1(:),G2H2(151),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_AQ_W(ntryL,G2H4(704),ex1(:),G2H2(152),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_QA_S(ntryL,G2H4(727),ex2(:),G2H2(153),ngPln,m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_QA_S(ntryL,G2H4(729),ex2(:),G2H2(154),ngPln,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_QA_S(ntryL,G2H4(716),ex2(:),G2H2(155),ngPln,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_QA_S(ntryL,G2H4(719),ex2(:),G2H2(156),ngPln,m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_QA_W(ntryL,G2H4(733),ex2(:),G2H2(157),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_QA_W(ntryL,G2H4(736),ex2(:),G2H2(158),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_QA_W(ntryL,G2H4(730),ex2(:),G2H2(159),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_QA_W(ntryL,G2H4(732),ex2(:),G2H2(160),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hotf_5pt_reduction(G2H4(737),RedSet_5(13),mass5set(:,9),  & 
G1H4(1417),G1H4(1418),G1H4(1419),G1H4(1420),G1H4(1421),G1H4(1422),4)
  call HG1shiftOLR(G1H4(1418),8,4)
  call Hotf_5pt_reduction(G2H4(740),RedSet_5(33),mass5set(:,9),  & 
G1H4(1423),G1H4(1424),G1H4(1425),G1H4(1426),G1H4(1427),G1H4(1428),4)
  call HG1shiftOLR(G1H4(1424),8,4)
  call Hotf_5pt_reduction(G2H4(741),RedSet_5(13),mass5set(:,10),  & 
G1H4(1429),G1H4(1430),G1H4(1431),G1H4(1432),G1H4(1433),G1H4(1434),4)
  call HG1shiftOLR(G1H4(1430),8,4)
  call Hotf_5pt_reduction(G2H4(744),RedSet_5(33),mass5set(:,10),  & 
G1H4(1435),G1H4(1436),G1H4(1437),G1H4(1438),G1H4(1439),G1H4(1440),4)
  call HG1shiftOLR(G1H4(1436),8,4)
  call Hotf_5pt_reduction(G2H4(748),RedSet_5(33),mass5set(:,11),  & 
G1H4(1441),G1H4(1442),G1H4(1443),G1H4(1444),G1H4(1445),G1H4(1446),4)
  call HG1shiftOLR(G1H4(1442),8,4)
  call Hotf_5pt_reduction(G2H4(749),RedSet_5(13),mass5set(:,12),  & 
G1H4(1447),G1H4(1448),G1H4(1449),G1H4(1450),G1H4(1451),G1H4(1452),4)
  call HG1shiftOLR(G1H4(1448),8,4)
  call Hotf_5pt_reduction(G2H4(752),RedSet_5(33),mass5set(:,12),  & 
G1H4(1453),G1H4(1454),G1H4(1455),G1H4(1456),G1H4(1457),G1H4(1458),4)
  call HG1shiftOLR(G1H4(1454),8,4)
  call Hotf_5pt_reduction(G2H4(755),RedSet_5(33),mass5set(:,11),  & 
G1H4(1459),G1H4(1460),G1H4(1461),G1H4(1462),G1H4(1463),G1H4(1464),4)
  call HG1shiftOLR(G1H4(1460),8,4)
  call Hloop_SV_V(ntryL,G2H4(758),ex3(:),G2H2(161),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_SV_V(ntryL,G2H4(762),ex3(:),G2H2(162),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VV_S(ntryL,G2H4(766),ex3(:),G2H2(163),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_VV_S(ntryL,G2H4(769),ex3(:),G2H2(164),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hotf_5pt_reduction(G2H4(772),RedSet_5(33),mass5set(:,11),  & 
G1H4(1465),G1H4(1466),G1H4(1467),G1H4(1468),G1H4(1469),G1H4(1470),4)
  call HG1shiftOLR(G1H4(1466),8,4)
  call Hotf_5pt_reduction(G2H4(776),RedSet_5(33),mass5set(:,11),  & 
G1H4(1471),G1H4(1472),G1H4(1473),G1H4(1474),G1H4(1475),G1H4(1476),4)
  call HG1shiftOLR(G1H4(1472),8,4)
  call Hotf_5pt_reduction(G2H4(777),RedSet_5(13),mass5set(:,9),  & 
G1H4(1477),G1H4(1478),G1H4(1479),G1H4(1480),G1H4(1481),G1H4(1482),4)
  call HG1shiftOLR(G1H4(1478),4,4)
  call Hotf_5pt_reduction(G2H4(780),RedSet_5(34),mass5set(:,9),  & 
G1H4(1483),G1H4(1484),G1H4(1485),G1H4(1486),G1H4(1487),G1H4(1488),4)
  call HG1shiftOLR(G1H4(1484),4,4)
  call Hotf_5pt_reduction(G2H4(781),RedSet_5(13),mass5set(:,10),  & 
G1H4(1489),G1H4(1490),G1H4(1491),G1H4(1492),G1H4(1493),G1H4(1494),4)
  call HG1shiftOLR(G1H4(1490),4,4)
  call Hotf_5pt_reduction(G2H4(784),RedSet_5(34),mass5set(:,10),  & 
G1H4(1495),G1H4(1496),G1H4(1497),G1H4(1498),G1H4(1499),G1H4(1500),4)
  call HG1shiftOLR(G1H4(1496),4,4)
  call Hotf_5pt_reduction(G2H4(788),RedSet_5(34),mass5set(:,11),  & 
G1H4(1501),G1H4(1502),G1H4(1503),G1H4(1504),G1H4(1505),G1H4(1506),4)
  call HG1shiftOLR(G1H4(1502),4,4)
  call Hotf_5pt_reduction(G2H4(789),RedSet_5(13),mass5set(:,12),  & 
G1H4(1507),G1H4(1508),G1H4(1509),G1H4(1510),G1H4(1511),G1H4(1512),4)
  call HG1shiftOLR(G1H4(1508),4,4)
  call Hotf_5pt_reduction(G2H4(792),RedSet_5(34),mass5set(:,12),  & 
G1H4(1513),G1H4(1514),G1H4(1515),G1H4(1516),G1H4(1517),G1H4(1518),4)
  call HG1shiftOLR(G1H4(1514),4,4)
  call Hotf_5pt_reduction(G2H4(795),RedSet_5(34),mass5set(:,11),  & 
G1H4(1519),G1H4(1520),G1H4(1521),G1H4(1522),G1H4(1523),G1H4(1524),4)
  call HG1shiftOLR(G1H4(1520),4,4)
  call Hloop_SV_V(ntryL,G2H4(798),ex4(:),G2H2(165),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_SV_V(ntryL,G2H4(802),ex4(:),G2H2(166),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_VV_S(ntryL,G2H4(806),ex4(:),G2H2(167),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_VV_S(ntryL,G2H4(809),ex4(:),G2H2(168),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hotf_5pt_reduction(G2H4(812),RedSet_5(34),mass5set(:,11),  & 
G1H4(1525),G1H4(1526),G1H4(1527),G1H4(1528),G1H4(1529),G1H4(1530),4)
  call HG1shiftOLR(G1H4(1526),4,4)
  call Hotf_5pt_reduction(G2H4(816),RedSet_5(34),mass5set(:,11),  & 
G1H4(1531),G1H4(1532),G1H4(1533),G1H4(1534),G1H4(1535),G1H4(1536),4)
  call HG1shiftOLR(G1H4(1532),4,4)
  call Hotf_5pt_reduction(G2H4(817),RedSet_5(14),mass5set(:,9),  & 
G1H4(1537),G1H4(1538),G1H4(1539),G1H4(1540),G1H4(1541),G1H4(1542),4)
  call HG1shiftOLR(G1H4(1538),16,4)
  call Hotf_5pt_reduction(G2H4(820),RedSet_5(35),mass5set(:,9),  & 
G1H4(1543),G1H4(1544),G1H4(1545),G1H4(1546),G1H4(1547),G1H4(1548),4)
  call HG1shiftOLR(G1H4(1544),16,4)
  call Hotf_5pt_reduction(G2H4(821),RedSet_5(14),mass5set(:,10),  & 
G1H4(1549),G1H4(1550),G1H4(1551),G1H4(1552),G1H4(1553),G1H4(1554),4)
  call HG1shiftOLR(G1H4(1550),16,4)
  call Hotf_5pt_reduction(G2H4(824),RedSet_5(35),mass5set(:,10),  & 
G1H4(1555),G1H4(1556),G1H4(1557),G1H4(1558),G1H4(1559),G1H4(1560),4)
  call HG1shiftOLR(G1H4(1556),16,4)
  call Hotf_5pt_reduction(G2H4(828),RedSet_5(35),mass5set(:,11),  & 
G1H4(1561),G1H4(1562),G1H4(1563),G1H4(1564),G1H4(1565),G1H4(1566),4)
  call HG1shiftOLR(G1H4(1562),16,4)
  call Hotf_5pt_reduction(G2H4(829),RedSet_5(14),mass5set(:,12),  & 
G1H4(1567),G1H4(1568),G1H4(1569),G1H4(1570),G1H4(1571),G1H4(1572),4)
  call HG1shiftOLR(G1H4(1568),16,4)
  call Hotf_5pt_reduction(G2H4(832),RedSet_5(35),mass5set(:,12),  & 
G1H4(1573),G1H4(1574),G1H4(1575),G1H4(1576),G1H4(1577),G1H4(1578),4)
  call HG1shiftOLR(G1H4(1574),16,4)
  call Hotf_5pt_reduction(G2H4(835),RedSet_5(35),mass5set(:,11),  & 
G1H4(1579),G1H4(1580),G1H4(1581),G1H4(1582),G1H4(1583),G1H4(1584),4)
  call HG1shiftOLR(G1H4(1580),16,4)
  call Hloop_SV_V(ntryL,G2H4(838),ex4(:),G2H2(169),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_SV_V(ntryL,G2H4(842),ex4(:),G2H2(170),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_VV_S(ntryL,G2H4(846),ex4(:),G2H2(171),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_VV_S(ntryL,G2H4(849),ex4(:),G2H2(172),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hotf_5pt_reduction(G2H4(852),RedSet_5(35),mass5set(:,11),  & 
G1H4(1585),G1H4(1586),G1H4(1587),G1H4(1588),G1H4(1589),G1H4(1590),4)
  call HG1shiftOLR(G1H4(1586),16,4)
  call Hotf_5pt_reduction(G2H4(856),RedSet_5(35),mass5set(:,11),  & 
G1H4(1591),G1H4(1592),G1H4(1593),G1H4(1594),G1H4(1595),G1H4(1596),4)
  call HG1shiftOLR(G1H4(1592),16,4)
  call Hotf_5pt_reduction(G2H4(857),RedSet_5(14),mass5set(:,9),  & 
G1H4(1597),G1H4(1598),G1H4(1599),G1H4(1600),G1H4(1601),G1H4(1602),4)
  call HG1shiftOLR(G1H4(1598),8,4)
  call Hotf_5pt_reduction(G2H4(860),RedSet_5(36),mass5set(:,9),  & 
G1H4(1603),G1H4(1604),G1H4(1605),G1H4(1606),G1H4(1607),G1H4(1608),4)
  call HG1shiftOLR(G1H4(1604),8,4)
  call Hotf_5pt_reduction(G2H4(861),RedSet_5(14),mass5set(:,10),  & 
G1H4(1609),G1H4(1610),G1H4(1611),G1H4(1612),G1H4(1613),G1H4(1614),4)
  call HG1shiftOLR(G1H4(1610),8,4)
  call Hotf_5pt_reduction(G2H4(864),RedSet_5(36),mass5set(:,10),  & 
G1H4(1615),G1H4(1616),G1H4(1617),G1H4(1618),G1H4(1619),G1H4(1620),4)
  call HG1shiftOLR(G1H4(1616),8,4)
  call Hotf_5pt_reduction(G2H4(868),RedSet_5(36),mass5set(:,11),  & 
G1H4(1621),G1H4(1622),G1H4(1623),G1H4(1624),G1H4(1625),G1H4(1626),4)
  call HG1shiftOLR(G1H4(1622),8,4)
  call Hotf_5pt_reduction(G2H4(869),RedSet_5(14),mass5set(:,12),  & 
G1H4(1627),G1H4(1628),G1H4(1629),G1H4(1630),G1H4(1631),G1H4(1632),4)
  call HG1shiftOLR(G1H4(1628),8,4)
  call Hotf_5pt_reduction(G2H4(872),RedSet_5(36),mass5set(:,12),  & 
G1H4(1633),G1H4(1634),G1H4(1635),G1H4(1636),G1H4(1637),G1H4(1638),4)
  call HG1shiftOLR(G1H4(1634),8,4)
  call Hotf_5pt_reduction(G2H4(875),RedSet_5(36),mass5set(:,11),  & 
G1H4(1639),G1H4(1640),G1H4(1641),G1H4(1642),G1H4(1643),G1H4(1644),4)
  call HG1shiftOLR(G1H4(1640),8,4)
  call Hloop_SV_V(ntryL,G2H4(878),ex5(:),G2H2(173),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_SV_V(ntryL,G2H4(882),ex5(:),G2H2(174),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_VV_S(ntryL,G2H4(886),ex5(:),G2H2(175),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_VV_S(ntryL,G2H4(889),ex5(:),G2H2(176),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hotf_5pt_reduction(G2H4(892),RedSet_5(36),mass5set(:,11),  & 
G1H4(1645),G1H4(1646),G1H4(1647),G1H4(1648),G1H4(1649),G1H4(1650),4)
  call HG1shiftOLR(G1H4(1646),8,4)
  call Hotf_5pt_reduction(G2H4(896),RedSet_5(36),mass5set(:,11),  & 
G1H4(1651),G1H4(1652),G1H4(1653),G1H4(1654),G1H4(1655),G1H4(1656),4)
  call HG1shiftOLR(G1H4(1652),8,4)
  call Hotf_5pt_reduction(G2H4(897),RedSet_5(15),mass5set(:,9),  & 
G1H4(1657),G1H4(1658),G1H4(1659),G1H4(1660),G1H4(1661),G1H4(1662),4)
  call HG1shiftOLR(G1H4(1658),16,4)
  call Hotf_5pt_reduction(G2H4(900),RedSet_5(35),mass5set(:,9),  & 
G1H4(1663),G1H4(1664),G1H4(1665),G1H4(1666),G1H4(1667),G1H4(1668),4)
  call HG1shiftOLR(G1H4(1664),16,4)
  call Hotf_5pt_reduction(G2H4(901),RedSet_5(15),mass5set(:,10),  & 
G1H4(1669),G1H4(1670),G1H4(1671),G1H4(1672),G1H4(1673),G1H4(1674),4)
  call HG1shiftOLR(G1H4(1670),16,4)
  call Hotf_5pt_reduction(G2H4(904),RedSet_5(35),mass5set(:,10),  & 
G1H4(1675),G1H4(1676),G1H4(1677),G1H4(1678),G1H4(1679),G1H4(1680),4)
  call HG1shiftOLR(G1H4(1676),16,4)
  call Hotf_5pt_reduction(G2H4(908),RedSet_5(35),mass5set(:,11),  & 
G1H4(1681),G1H4(1682),G1H4(1683),G1H4(1684),G1H4(1685),G1H4(1686),4)
  call HG1shiftOLR(G1H4(1682),16,4)
  call Hotf_5pt_reduction(G2H4(909),RedSet_5(15),mass5set(:,12),  & 
G1H4(1687),G1H4(1688),G1H4(1689),G1H4(1690),G1H4(1691),G1H4(1692),4)
  call HG1shiftOLR(G1H4(1688),16,4)
  call Hotf_5pt_reduction(G2H4(912),RedSet_5(35),mass5set(:,12),  & 
G1H4(1693),G1H4(1694),G1H4(1695),G1H4(1696),G1H4(1697),G1H4(1698),4)
  call HG1shiftOLR(G1H4(1694),16,4)
  call Hotf_5pt_reduction(G2H4(915),RedSet_5(35),mass5set(:,11),  & 
G1H4(1699),G1H4(1700),G1H4(1701),G1H4(1702),G1H4(1703),G1H4(1704),4)
  call HG1shiftOLR(G1H4(1700),16,4)
  call Hloop_SV_V(ntryL,G2H4(918),ex3(:),G2H2(177),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_SV_V(ntryL,G2H4(922),ex3(:),G2H2(178),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_VV_S(ntryL,G2H4(926),ex3(:),G2H2(179),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_VV_S(ntryL,G2H4(929),ex3(:),G2H2(180),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hotf_5pt_reduction(G2H4(932),RedSet_5(35),mass5set(:,11),  & 
G1H4(1705),G1H4(1706),G1H4(1707),G1H4(1708),G1H4(1709),G1H4(1710),4)
  call HG1shiftOLR(G1H4(1706),16,4)
  call Hotf_5pt_reduction(G2H4(936),RedSet_5(35),mass5set(:,11),  & 
G1H4(1711),G1H4(1712),G1H4(1713),G1H4(1714),G1H4(1715),G1H4(1716),4)
  call HG1shiftOLR(G1H4(1712),16,4)
  call Hotf_5pt_reduction(G2H4(937),RedSet_5(15),mass5set(:,9),  & 
G1H4(1717),G1H4(1718),G1H4(1719),G1H4(1720),G1H4(1721),G1H4(1722),4)
  call HG1shiftOLR(G1H4(1718),4,4)
  call Hotf_5pt_reduction(G2H4(940),RedSet_5(37),mass5set(:,9),  & 
G1H4(1723),G1H4(1724),G1H4(1725),G1H4(1726),G1H4(1727),G1H4(1728),4)
  call HG1shiftOLR(G1H4(1724),4,4)
  call Hotf_5pt_reduction(G2H4(941),RedSet_5(15),mass5set(:,10),  & 
G1H4(1729),G1H4(1730),G1H4(1731),G1H4(1732),G1H4(1733),G1H4(1734),4)
  call HG1shiftOLR(G1H4(1730),4,4)
  call Hotf_5pt_reduction(G2H4(944),RedSet_5(37),mass5set(:,10),  & 
G1H4(1735),G1H4(1736),G1H4(1737),G1H4(1738),G1H4(1739),G1H4(1740),4)
  call HG1shiftOLR(G1H4(1736),4,4)
  call Hotf_5pt_reduction(G2H4(948),RedSet_5(37),mass5set(:,11),  & 
G1H4(1741),G1H4(1742),G1H4(1743),G1H4(1744),G1H4(1745),G1H4(1746),4)
  call HG1shiftOLR(G1H4(1742),4,4)
  call Hotf_5pt_reduction(G2H4(949),RedSet_5(15),mass5set(:,12),  & 
G1H4(1747),G1H4(1748),G1H4(1749),G1H4(1750),G1H4(1751),G1H4(1752),4)
  call HG1shiftOLR(G1H4(1748),4,4)
  call Hotf_5pt_reduction(G2H4(952),RedSet_5(37),mass5set(:,12),  & 
G1H4(1753),G1H4(1754),G1H4(1755),G1H4(1756),G1H4(1757),G1H4(1758),4)
  call HG1shiftOLR(G1H4(1754),4,4)
  call Hotf_5pt_reduction(G2H4(955),RedSet_5(37),mass5set(:,11),  & 
G1H4(1759),G1H4(1760),G1H4(1761),G1H4(1762),G1H4(1763),G1H4(1764),4)
  call HG1shiftOLR(G1H4(1760),4,4)
  call Hloop_SV_V(ntryL,G2H4(958),ex5(:),G2H2(181),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_SV_V(ntryL,G2H4(962),ex5(:),G2H2(182),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_VV_S(ntryL,G2H4(966),ex5(:),G2H2(183),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_VV_S(ntryL,G2H4(969),ex5(:),G2H2(184),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hotf_5pt_reduction(G2H4(972),RedSet_5(37),mass5set(:,11),  & 
G1H4(1765),G1H4(1766),G1H4(1767),G1H4(1768),G1H4(1769),G1H4(1770),4)
  call HG1shiftOLR(G1H4(1766),4,4)
  call Hotf_5pt_reduction(G2H4(976),RedSet_5(37),mass5set(:,11),  & 
G1H4(1771),G1H4(1772),G1H4(1773),G1H4(1774),G1H4(1775),G1H4(1776),4)
  call HG1shiftOLR(G1H4(1772),4,4)
  call Hotf_5pt_reduction(G2H4(977),RedSet_5(16),mass5set(:,9),  & 
G1H4(1777),G1H4(1778),G1H4(1779),G1H4(1780),G1H4(1781),G1H4(1782),4)
  call HG1shiftOLR(G1H4(1778),8,4)
  call Hotf_5pt_reduction(G2H4(980),RedSet_5(36),mass5set(:,9),  & 
G1H4(1783),G1H4(1784),G1H4(1785),G1H4(1786),G1H4(1787),G1H4(1788),4)
  call HG1shiftOLR(G1H4(1784),8,4)
  call Hotf_5pt_reduction(G2H4(981),RedSet_5(16),mass5set(:,10),  & 
G1H4(1789),G1H4(1790),G1H4(1791),G1H4(1792),G1H4(1793),G1H4(1794),4)
  call HG1shiftOLR(G1H4(1790),8,4)
  call Hotf_5pt_reduction(G2H4(984),RedSet_5(36),mass5set(:,10),  & 
G1H4(1795),G1H4(1796),G1H4(1797),G1H4(1798),G1H4(1799),G1H4(1800),4)
  call HG1shiftOLR(G1H4(1796),8,4)
  call Hotf_5pt_reduction(G2H4(988),RedSet_5(36),mass5set(:,11),  & 
G1H4(1801),G1H4(1802),G1H4(1803),G1H4(1804),G1H4(1805),G1H4(1806),4)
  call HG1shiftOLR(G1H4(1802),8,4)
  call Hotf_5pt_reduction(G2H4(989),RedSet_5(16),mass5set(:,12),  & 
G1H4(1807),G1H4(1808),G1H4(1809),G1H4(1810),G1H4(1811),G1H4(1812),4)
  call HG1shiftOLR(G1H4(1808),8,4)
  call Hotf_5pt_reduction(G2H4(992),RedSet_5(36),mass5set(:,12),  & 
G1H4(1813),G1H4(1814),G1H4(1815),G1H4(1816),G1H4(1817),G1H4(1818),4)
  call HG1shiftOLR(G1H4(1814),8,4)
  call Hotf_5pt_reduction(G2H4(995),RedSet_5(36),mass5set(:,11),  & 
G1H4(1819),G1H4(1820),G1H4(1821),G1H4(1822),G1H4(1823),G1H4(1824),4)
  call HG1shiftOLR(G1H4(1820),8,4)
  call Hloop_SV_V(ntryL,G2H4(998),ex3(:),G2H2(185),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_SV_V(ntryL,G2H4(1002),ex3(:),G2H2(186),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VV_S(ntryL,G2H4(1006),ex3(:),G2H2(187),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_VV_S(ntryL,G2H4(1009),ex3(:),G2H2(188),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hotf_5pt_reduction(G2H4(1012),RedSet_5(36),mass5set(:,11),  & 
G1H4(1825),G1H4(1826),G1H4(1827),G1H4(1828),G1H4(1829),G1H4(1830),4)
  call HG1shiftOLR(G1H4(1826),8,4)
  call Hotf_5pt_reduction(G2H4(1016),RedSet_5(36),mass5set(:,11),  & 
G1H4(1831),G1H4(1832),G1H4(1833),G1H4(1834),G1H4(1835),G1H4(1836),4)
  call HG1shiftOLR(G1H4(1832),8,4)
  call Hotf_5pt_reduction(G2H4(1017),RedSet_5(16),mass5set(:,9),  & 
G1H4(1837),G1H4(1838),G1H4(1839),G1H4(1840),G1H4(1841),G1H4(1842),4)
  call HG1shiftOLR(G1H4(1838),4,4)
  call Hotf_5pt_reduction(G2H4(1020),RedSet_5(37),mass5set(:,9),  & 
G1H4(1843),G1H4(1844),G1H4(1845),G1H4(1846),G1H4(1847),G1H4(1848),4)
  call HG1shiftOLR(G1H4(1844),4,4)
  call Hotf_5pt_reduction(G2H4(1021),RedSet_5(16),mass5set(:,10),  & 
G1H4(1849),G1H4(1850),G1H4(1851),G1H4(1852),G1H4(1853),G1H4(1854),4)
  call HG1shiftOLR(G1H4(1850),4,4)
  call Hotf_5pt_reduction(G2H4(1024),RedSet_5(37),mass5set(:,10),  & 
G1H4(1855),G1H4(1856),G1H4(1857),G1H4(1858),G1H4(1859),G1H4(1860),4)
  call HG1shiftOLR(G1H4(1856),4,4)
  call Hotf_5pt_reduction(G2H4(1028),RedSet_5(37),mass5set(:,11),  & 
G1H4(1861),G1H4(1862),G1H4(1863),G1H4(1864),G1H4(1865),G1H4(1866),4)
  call HG1shiftOLR(G1H4(1862),4,4)
  call Hotf_5pt_reduction(G2H4(1029),RedSet_5(16),mass5set(:,12),  & 
G1H4(1867),G1H4(1868),G1H4(1869),G1H4(1870),G1H4(1871),G1H4(1872),4)
  call HG1shiftOLR(G1H4(1868),4,4)
  call Hotf_5pt_reduction(G2H4(1032),RedSet_5(37),mass5set(:,12),  & 
G1H4(1873),G1H4(1874),G1H4(1875),G1H4(1876),G1H4(1877),G1H4(1878),4)
  call HG1shiftOLR(G1H4(1874),4,4)
  call Hotf_5pt_reduction(G2H4(1035),RedSet_5(37),mass5set(:,11),  & 
G1H4(1879),G1H4(1880),G1H4(1881),G1H4(1882),G1H4(1883),G1H4(1884),4)
  call HG1shiftOLR(G1H4(1880),4,4)
  call Hloop_SV_V(ntryL,G2H4(1038),ex4(:),G2H2(189),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_SV_V(ntryL,G2H4(1042),ex4(:),G2H2(190),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_VV_S(ntryL,G2H4(1046),ex4(:),G2H2(191),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_VV_S(ntryL,G2H4(1049),ex4(:),G2H2(192),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hotf_5pt_reduction(G2H4(1052),RedSet_5(37),mass5set(:,11),  & 
G1H4(1885),G1H4(1886),G1H4(1887),G1H4(1888),G1H4(1889),G1H4(1890),4)
  call HG1shiftOLR(G1H4(1886),4,4)
  call Hotf_5pt_reduction(G2H4(1056),RedSet_5(37),mass5set(:,11),  & 
G1H4(1891),G1H4(1892),G1H4(1893),G1H4(1894),G1H4(1895),G1H4(1896),4)
  call HG1shiftOLR(G1H4(1892),4,4)
  call Hloop_QA_S(ntryL,G2H4(1062),ex2(:),G2H2(193),ngPln,m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_QA_W(ntryL,G2H4(1066),ex2(:),G2H2(194),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_QA_S(ntryL,G2H4(1070),ex2(:),G2H2(195),ngPln,m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_QA_W(ntryL,G2H4(1076),ex2(:),G2H2(196),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_QA_S(ntryL,G2H4(1082),ex2(:),G2H2(197),ngPln,m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_QA_W(ntryL,G2H4(1086),ex2(:),G2H2(198),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_QA_S(ntryL,G2H4(1090),ex2(:),G2H2(199),ngPln,m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_QA_W(ntryL,G2H4(1096),ex2(:),G2H2(200),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_AQ_S(ntryL,G2H4(1102),ex1(:),G2H2(201),ngPnl,m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_AQ_W(ntryL,G2H4(1106),ex1(:),G2H2(202),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_AQ_S(ntryL,G2H4(1110),ex1(:),G2H2(203),ngPnl,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_AQ_W(ntryL,G2H4(1116),ex1(:),G2H2(204),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_AQ_S(ntryL,G2H4(1122),ex1(:),G2H2(205),ngPnl,m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_AQ_W(ntryL,G2H4(1126),ex1(:),G2H2(206),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_AQ_S(ntryL,G2H4(1130),ex1(:),G2H2(207),ngPnl,m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_AQ_W(ntryL,G2H4(1136),ex1(:),G2H2(208),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_AQ_S(ntryL,G2H4(1142),ex1(:),G2H2(209),ngPnl,m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_AQ_W(ntryL,G2H4(1146),ex1(:),G2H2(210),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_AQ_S(ntryL,G2H4(1150),ex1(:),G2H2(211),ngPnl,m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_AQ_W(ntryL,G2H4(1156),ex1(:),G2H2(212),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_QA_S(ntryL,G2H4(1162),ex2(:),G2H2(213),ngPln,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_QA_W(ntryL,G2H4(1166),ex2(:),G2H2(214),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QA_S(ntryL,G2H4(1170),ex2(:),G2H2(215),ngPln,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_QA_W(ntryL,G2H4(1176),ex2(:),G2H2(216),m3h2x2(:,216),heltab2x4(:,:,216))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(535),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(529),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(547),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(541),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(565),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(553),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(571),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(559),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(637),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(625),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(643),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(631),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1093),[G1H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1117),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1111),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1123),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1153),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1177),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1171),[G1H4(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1183),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(661),[G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(649),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(667),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(655),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(679),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(673),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(691),[G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(685),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1285),[G1H4(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1309),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1303),[G1H4(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1315),[G1H4(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1345),[G1H4(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1369),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1363),[G1H4(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1375),[G1H4(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(847),[G1H4(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(841),[G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(859),[G1H4(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(853),[G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1441),[G1H4(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1465),[G1H4(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1459),[G1H4(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1471),[G1H4(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1501),[G1H4(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1525),[G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1519),[G1H4(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1531),[G1H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1561),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1585),[G1H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1579),[G1H4(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1591),[G1H4(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1621),[G1H4(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1645),[G1H4(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1639),[G1H4(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1651),[G1H4(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1681),[G1H4(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1705),[G1H4(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1699),[G1H4(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1711),[G1H4(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1741),[G1H4(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1765),[G1H4(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1759),[G1H4(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1771),[G1H4(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1801),[G1H4(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1825),[G1H4(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1819),[G1H4(498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1831),[G1H4(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1861),[G1H4(510)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1885),[G1H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1879),[G1H4(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1891),[G1H4(528)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(583),[G1H4(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(595),[G1H4(594)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(607),[G1H4(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(619),[G1H4(618)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(703),[G1H4(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(715),[G1H4(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(727),[G1H4(726)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(739),[G1H4(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(751),[G1H4(750)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(763),[G1H4(762)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(775),[G1H4(774)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(787),[G1H4(786)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(799),[G1H4(798)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(811),[G1H4(810)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(823),[G1H4(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(835),[G1H4(834)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(871),[G1H4(870)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(883),[G1H4(882)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(895),[G1H4(894)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(907),[G1H4(906)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(919),[G1H4(918)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(931),[G1H4(930)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(943),[G1H4(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(955),[G1H4(954)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(967),[G1H4(966)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(979),[G1H4(978)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(991),[G1H4(990)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1003),[G1H4(1002)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1015),[G1H4(1014)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1027),[G1H4(1026)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1039),[G1H4(1038)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1051),[G1H4(1050)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1063),[G1H4(1062)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1075),[G1H4(1074)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1087),[G1H4(1086)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1105),[G1H4(1104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1135),[G1H4(1134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1147),[G1H4(1146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1165),[G1H4(1164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1195),[G1H4(1194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1207),[G1H4(1206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1219),[G1H4(1218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1231),[G1H4(1230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1243),[G1H4(1242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1255),[G1H4(1254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1267),[G1H4(1266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1279),[G1H4(1278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1297),[G1H4(1296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1327),[G1H4(1326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1339),[G1H4(1338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1357),[G1H4(1356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1387),[G1H4(1386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1399),[G1H4(1398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1411),[G1H4(1410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1423),[G1H4(1422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1435),[G1H4(1434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1453),[G1H4(1452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1483),[G1H4(1482)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1495),[G1H4(1494)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1513),[G1H4(1512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1543),[G1H4(1542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1555),[G1H4(1554)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1573),[G1H4(1572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1603),[G1H4(1602)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1615),[G1H4(1614)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1633),[G1H4(1632)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1663),[G1H4(1662)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1675),[G1H4(1674)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1693),[G1H4(1692)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1723),[G1H4(1722)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1735),[G1H4(1734)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1753),[G1H4(1752)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1783),[G1H4(1782)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1795),[G1H4(1794)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1813),[G1H4(1812)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1843),[G1H4(1842)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1855),[G1H4(1854)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1873),[G1H4(1872)])
  call Hloop_TV_S(ntryL,G1H4(97),43,ex3(:),4,G2H2(217),m3h2x2(:,217),heltab2x4(:,:,217))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(98),ex5(:),G1H2(1),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_TV_S(ntryL,G1H4(535),43,ex3(:),4,G2H2(218),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_TV_S(ntryL,G1H4(103),43,ex3(:),4,G2H2(219),m3h2x2(:,220),heltab2x4(:,:,220))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(104),-16,ex5(:),16,G2H2(220),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_TV_S(ntryL,G1H4(529),43,ex3(:),4,G2H2(221),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_UV_W(ntryL,G1H4(109),43,ex3(:),4,G2H2(222),m3h2x2(:,223),heltab2x4(:,:,223))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(110),-16,ex5(:),16,G2H2(223),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_UV_W(ntryL,G1H4(547),43,ex3(:),4,G2H2(224),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_UV_W(ntryL,G1H4(115),43,ex3(:),4,G2H2(225),m3h2x2(:,226),heltab2x4(:,:,226))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(116),ex5(:),G1H2(2),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_UV_W(ntryL,G1H4(541),43,ex3(:),4,G2H2(226),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_SV_T(ntryL,G1H4(121),39,ex4(:),8,G2H2(227),m3h2x2(:,229),heltab2x4(:,:,229))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(122),ex5(:),G1H2(3),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_SV_T(ntryL,G1H4(565),39,ex4(:),8,G2H2(228),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_SV_T(ntryL,G1H4(127),39,ex4(:),8,G2H2(229),m3h2x2(:,232),heltab2x4(:,:,232))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(128),-16,ex5(:),16,G2H2(230),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_SV_T(ntryL,G1H4(553),39,ex4(:),8,G2H2(231),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_UW_V(ntryL,G1H4(133),39,ex4(:),8,G2H2(232),m3h2x2(:,235),heltab2x4(:,:,235))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(134),-16,ex5(:),16,G2H2(233),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_UW_V(ntryL,G1H4(571),39,ex4(:),8,G2H2(234),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_UW_V(ntryL,G1H4(139),39,ex4(:),8,G2H2(235),m3h2x2(:,238),heltab2x4(:,:,238))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(140),ex5(:),G1H2(4),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_UW_V(ntryL,G1H4(559),39,ex4(:),8,G2H2(236),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_SV_T(ntryL,G1H4(145),39,ex5(:),16,G2H2(237),m3h2x2(:,241),heltab2x4(:,:,241))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(146),ex4(:),G1H2(5),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_SV_T(ntryL,G1H4(637),39,ex5(:),16,G2H2(238),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_SV_T(ntryL,G1H4(151),39,ex5(:),16,G2H2(239),m3h2x2(:,244),heltab2x4(:,:,244))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(152),-8,ex4(:),8,G2H2(240),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_SV_T(ntryL,G1H4(625),39,ex5(:),16,G2H2(241),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_UW_V(ntryL,G1H4(157),39,ex5(:),16,G2H2(242),m3h2x2(:,247),heltab2x4(:,:,247))
call HGT_raise_alpha_OLR(G1H4(158),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(158),-8,ex4(:),8,G2H2(243),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_UW_V(ntryL,G1H4(643),39,ex5(:),16,G2H2(244),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_UW_V(ntryL,G1H4(163),39,ex5(:),16,G2H2(245),m3h2x2(:,250),heltab2x4(:,:,250))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(164),ex4(:),G1H2(6),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_UW_V(ntryL,G1H4(631),39,ex5(:),16,G2H2(246),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_TV_S(ntryL,G1H4(169),39,ex4(:),8,G2H2(247),m3h2x2(:,253),heltab2x4(:,:,253))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(170),-16,ex5(:),16,G2H2(248),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_TV_S(ntryL,G1H4(1093),39,ex4(:),8,G2H2(249),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_UV_W(ntryL,G1H4(175),39,ex4(:),8,G2H2(250),m3h2x2(:,256),heltab2x4(:,:,256))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(176),ex5(:),G1H2(7),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_UV_W(ntryL,G1H4(1117),39,ex4(:),8,G2H2(251),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_TV_S(ntryL,G1H4(181),39,ex4(:),8,G2H2(252),m3h2x2(:,259),heltab2x4(:,:,259))
call HGT_raise_alpha_OLR(G1H4(182),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(182),ex5(:),G1H2(8),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_TV_S(ntryL,G1H4(1111),39,ex4(:),8,G2H2(253),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_UV_W(ntryL,G1H4(187),39,ex4(:),8,G2H2(254),m3h2x2(:,262),heltab2x4(:,:,262))
call HGT_raise_alpha_OLR(G1H4(188),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(188),-16,ex5(:),16,G2H2(255),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_UV_W(ntryL,G1H4(1123),39,ex4(:),8,G2H2(256),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_TV_S(ntryL,G1H4(193),39,ex5(:),16,G2H2(257),m3h2x2(:,265),heltab2x4(:,:,265))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(194),-8,ex4(:),8,G2H2(258),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_TV_S(ntryL,G1H4(1153),39,ex5(:),16,G2H2(259),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_UV_W(ntryL,G1H4(199),39,ex5(:),16,G2H2(260),m3h2x2(:,268),heltab2x4(:,:,268))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(200),ex4(:),G1H2(9),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_UV_W(ntryL,G1H4(1177),39,ex5(:),16,G2H2(261),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_TV_S(ntryL,G1H4(205),39,ex5(:),16,G2H2(262),m3h2x2(:,271),heltab2x4(:,:,271))
call HGT_raise_alpha_OLR(G1H4(206),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(206),ex4(:),G1H2(10),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_TV_S(ntryL,G1H4(1171),39,ex5(:),16,G2H2(263),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_UV_W(ntryL,G1H4(211),39,ex5(:),16,G2H2(264),m3h2x2(:,274),heltab2x4(:,:,274))
call HGT_raise_alpha_OLR(G1H4(212),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(212),-8,ex4(:),8,G2H2(265),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_UV_W(ntryL,G1H4(1183),39,ex5(:),16,G2H2(266),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_SV_T(ntryL,G1H4(217),43,ex3(:),4,G2H2(267),m3h2x2(:,277),heltab2x4(:,:,277))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(218),ex5(:),G1H2(11),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_SV_T(ntryL,G1H4(661),43,ex3(:),4,G2H2(268),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_SV_T(ntryL,G1H4(223),43,ex3(:),4,G2H2(269),m3h2x2(:,280),heltab2x4(:,:,280))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(224),-16,ex5(:),16,G2H2(270),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_SV_T(ntryL,G1H4(649),43,ex3(:),4,G2H2(271),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_UW_V(ntryL,G1H4(229),43,ex3(:),4,G2H2(272),m3h2x2(:,283),heltab2x4(:,:,283))
call HGT_raise_alpha_OLR(G1H4(230),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(230),-16,ex5(:),16,G2H2(273),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_UW_V(ntryL,G1H4(667),43,ex3(:),4,G2H2(274),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_UW_V(ntryL,G1H4(235),43,ex3(:),4,G2H2(275),m3h2x2(:,286),heltab2x4(:,:,286))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(236),ex5(:),G1H2(12),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_UW_V(ntryL,G1H4(655),43,ex3(:),4,G2H2(276),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_TV_S(ntryL,G1H4(241),39,ex4(:),8,G2H2(277),m3h2x2(:,289),heltab2x4(:,:,289))
call HGT_raise_alpha_OLR(G1H4(242),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(242),ex5(:),G1H2(13),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_TV_S(ntryL,G1H4(679),39,ex4(:),8,G2H2(278),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_TV_S(ntryL,G1H4(247),39,ex4(:),8,G2H2(279),m3h2x2(:,292),heltab2x4(:,:,292))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(248),-16,ex5(:),16,G2H2(280),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_TV_S(ntryL,G1H4(673),39,ex4(:),8,G2H2(281),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_UV_W(ntryL,G1H4(253),39,ex4(:),8,G2H2(282),m3h2x2(:,295),heltab2x4(:,:,295))
call HGT_raise_alpha_OLR(G1H4(254),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(254),-16,ex5(:),16,G2H2(283),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_UV_W(ntryL,G1H4(691),39,ex4(:),8,G2H2(284),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_UV_W(ntryL,G1H4(259),39,ex4(:),8,G2H2(285),m3h2x2(:,298),heltab2x4(:,:,298))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(260),ex5(:),G1H2(14),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_UV_W(ntryL,G1H4(685),39,ex4(:),8,G2H2(286),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_TV_S(ntryL,G1H4(265),43,ex3(:),4,G2H2(287),m3h2x2(:,301),heltab2x4(:,:,301))
call HGT_OLR(G1H4(266),1,1,4)
call HGT_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(266),-16,ex5(:),16,G2H2(288),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_TV_S(ntryL,G1H4(1285),43,ex3(:),4,G2H2(289),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_UV_W(ntryL,G1H4(271),43,ex3(:),4,G2H2(290),m3h2x2(:,304),heltab2x4(:,:,304))
call HGT_OLR(G1H4(272),1,1,4)
call HGT_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(272),ex5(:),G1H2(15),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_UV_W(ntryL,G1H4(1309),43,ex3(:),4,G2H2(291),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_TV_S(ntryL,G1H4(277),43,ex3(:),4,G2H2(292),m3h2x2(:,307),heltab2x4(:,:,307))
call HGT_raise_alpha_OLR(G1H4(278),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(278),ex5(:),G1H2(16),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_TV_S(ntryL,G1H4(1303),43,ex3(:),4,G2H2(293),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_UV_W(ntryL,G1H4(283),43,ex3(:),4,G2H2(294),m3h2x2(:,310),heltab2x4(:,:,310))
call HGT_raise_alpha_OLR(G1H4(284),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(284),-16,ex5(:),16,G2H2(295),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_UV_W(ntryL,G1H4(1315),43,ex3(:),4,G2H2(296),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_TV_S(ntryL,G1H4(289),43,ex5(:),16,G2H2(297),m3h2x2(:,313),heltab2x4(:,:,313))
call HGT_OLR(G1H4(290),1,1,4)
call HGT_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(290),-4,ex3(:),4,G2H2(298),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_TV_S(ntryL,G1H4(1345),43,ex5(:),16,G2H2(299),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_UV_W(ntryL,G1H4(295),43,ex5(:),16,G2H2(300),m3h2x2(:,316),heltab2x4(:,:,316))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(296),ex3(:),G1H2(17),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_UV_W(ntryL,G1H4(1369),43,ex5(:),16,G2H2(301),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_TV_S(ntryL,G1H4(301),43,ex5(:),16,G2H2(302),m3h2x2(:,319),heltab2x4(:,:,319))
call HGT_raise_alpha_OLR(G1H4(302),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(302),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(302),ex3(:),G1H2(18),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_TV_S(ntryL,G1H4(1363),43,ex5(:),16,G2H2(303),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_UV_W(ntryL,G1H4(307),43,ex5(:),16,G2H2(304),m3h2x2(:,322),heltab2x4(:,:,322))
call HGT_raise_alpha_OLR(G1H4(308),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(308),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(308),-4,ex3(:),4,G2H2(305),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_UV_W(ntryL,G1H4(1375),43,ex5(:),16,G2H2(306),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_TV_S(ntryL,G1H4(313),39,ex5(:),16,G2H2(307),m3h2x2(:,325),heltab2x4(:,:,325))
call HGT_raise_alpha_OLR(G1H4(314),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(314),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(314),ex4(:),G1H2(19),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_TV_S(ntryL,G1H4(847),39,ex5(:),16,G2H2(308),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_TV_S(ntryL,G1H4(319),39,ex5(:),16,G2H2(309),m3h2x2(:,328),heltab2x4(:,:,328))
call HGT_OLR(G1H4(320),1,1,4)
call HGT_invQ_OLR(G1H4(320),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(320),-8,ex4(:),8,G2H2(310),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_TV_S(ntryL,G1H4(841),39,ex5(:),16,G2H2(311),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_UV_W(ntryL,G1H4(325),39,ex5(:),16,G2H2(312),m3h2x2(:,331),heltab2x4(:,:,331))
call HGT_raise_alpha_OLR(G1H4(326),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(326),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(326),-8,ex4(:),8,G2H2(313),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_UV_W(ntryL,G1H4(859),39,ex5(:),16,G2H2(314),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_UV_W(ntryL,G1H4(331),39,ex5(:),16,G2H2(315),m3h2x2(:,334),heltab2x4(:,:,334))
call HGT_OLR(G1H4(332),1,1,4)
call HGT_invQ_OLR(G1H4(332),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(332),ex4(:),G1H2(20),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_UV_W(ntryL,G1H4(853),39,ex5(:),16,G2H2(316),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_TV_S(ntryL,G1H4(337),51,ex3(:),4,G2H2(317),m3h2x2(:,337),heltab2x4(:,:,337))
call HGT_OLR(G1H4(338),1,1,4)
call HGT_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(338),-8,ex4(:),8,G2H2(318),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_TV_S(ntryL,G1H4(1441),51,ex3(:),4,G2H2(319),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_UV_W(ntryL,G1H4(343),51,ex3(:),4,G2H2(320),m3h2x2(:,340),heltab2x4(:,:,340))
call HGT_OLR(G1H4(344),1,1,4)
call HGT_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(344),ex4(:),G1H2(21),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_UV_W(ntryL,G1H4(1465),51,ex3(:),4,G2H2(321),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_TV_S(ntryL,G1H4(349),51,ex3(:),4,G2H2(322),m3h2x2(:,343),heltab2x4(:,:,343))
call HGT_raise_alpha_OLR(G1H4(350),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(350),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(350),ex4(:),G1H2(22),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_TV_S(ntryL,G1H4(1459),51,ex3(:),4,G2H2(323),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_UV_W(ntryL,G1H4(355),51,ex3(:),4,G2H2(324),m3h2x2(:,346),heltab2x4(:,:,346))
call HGT_raise_alpha_OLR(G1H4(356),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(356),-8,ex4(:),8,G2H2(325),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_UV_W(ntryL,G1H4(1471),51,ex3(:),4,G2H2(326),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_TV_S(ntryL,G1H4(361),51,ex4(:),8,G2H2(327),m3h2x2(:,349),heltab2x4(:,:,349))
call HGT_OLR(G1H4(362),1,1,4)
call HGT_invQ_OLR(G1H4(362),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(362),-4,ex3(:),4,G2H2(328),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_TV_S(ntryL,G1H4(1501),51,ex4(:),8,G2H2(329),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_UV_W(ntryL,G1H4(367),51,ex4(:),8,G2H2(330),m3h2x2(:,352),heltab2x4(:,:,352))
call HGT_OLR(G1H4(368),1,1,4)
call HGT_invQ_OLR(G1H4(368),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(368),ex3(:),G1H2(23),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_UV_W(ntryL,G1H4(1525),51,ex4(:),8,G2H2(331),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_TV_S(ntryL,G1H4(373),51,ex4(:),8,G2H2(332),m3h2x2(:,355),heltab2x4(:,:,355))
call HGT_raise_alpha_OLR(G1H4(374),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(374),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(374),ex3(:),G1H2(24),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_TV_S(ntryL,G1H4(1519),51,ex4(:),8,G2H2(333),m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_UV_W(ntryL,G1H4(379),51,ex4(:),8,G2H2(334),m3h2x2(:,358),heltab2x4(:,:,358))
call HGT_raise_alpha_OLR(G1H4(380),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(380),-4,ex3(:),4,G2H2(335),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_UV_W(ntryL,G1H4(1531),51,ex4(:),8,G2H2(336),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_SV_T(ntryL,G1H4(385),39,ex4(:),8,G2H2(337),m3h2x2(:,361),heltab2x4(:,:,361))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(386),-16,ex5(:),16,G2H2(338),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_SV_T(ntryL,G1H4(1561),39,ex4(:),8,G2H2(339),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_UW_V(ntryL,G1H4(391),39,ex4(:),8,G2H2(340),m3h2x2(:,364),heltab2x4(:,:,364))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(392),ex5(:),G1H2(25),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_UW_V(ntryL,G1H4(1585),39,ex4(:),8,G2H2(341),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_SV_T(ntryL,G1H4(397),39,ex4(:),8,G2H2(342),m3h2x2(:,367),heltab2x4(:,:,367))
call HGT_raise_alpha_OLR(G1H4(398),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(398),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(398),ex5(:),G1H2(26),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_SV_T(ntryL,G1H4(1579),39,ex4(:),8,G2H2(343),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_UW_V(ntryL,G1H4(403),39,ex4(:),8,G2H2(344),m3h2x2(:,370),heltab2x4(:,:,370))
call HGT_raise_alpha_OLR(G1H4(404),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(404),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(404),-16,ex5(:),16,G2H2(345),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_UW_V(ntryL,G1H4(1591),39,ex4(:),8,G2H2(346),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_SV_T(ntryL,G1H4(409),39,ex5(:),16,G2H2(347),m3h2x2(:,373),heltab2x4(:,:,373))
call HGT_OLR(G1H4(410),1,1,4)
call HGT_invQ_OLR(G1H4(410),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(410),-8,ex4(:),8,G2H2(348),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_SV_T(ntryL,G1H4(1621),39,ex5(:),16,G2H2(349),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_UW_V(ntryL,G1H4(415),39,ex5(:),16,G2H2(350),m3h2x2(:,376),heltab2x4(:,:,376))
call HGT_OLR(G1H4(416),1,1,4)
call HGT_invQ_OLR(G1H4(416),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(416),ex4(:),G1H2(27),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_UW_V(ntryL,G1H4(1645),39,ex5(:),16,G2H2(351),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_SV_T(ntryL,G1H4(421),39,ex5(:),16,G2H2(352),m3h2x2(:,379),heltab2x4(:,:,379))
call HGT_raise_alpha_OLR(G1H4(422),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(422),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(422),ex4(:),G1H2(28),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_SV_T(ntryL,G1H4(1639),39,ex5(:),16,G2H2(353),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_UW_V(ntryL,G1H4(427),39,ex5(:),16,G2H2(354),m3h2x2(:,382),heltab2x4(:,:,382))
call HGT_raise_alpha_OLR(G1H4(428),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(428),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(428),-8,ex4(:),8,G2H2(355),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_UW_V(ntryL,G1H4(1651),39,ex5(:),16,G2H2(356),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_SV_T(ntryL,G1H4(433),43,ex3(:),4,G2H2(357),m3h2x2(:,385),heltab2x4(:,:,385))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(434),-16,ex5(:),16,G2H2(358),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_SV_T(ntryL,G1H4(1681),43,ex3(:),4,G2H2(359),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_UW_V(ntryL,G1H4(439),43,ex3(:),4,G2H2(360),m3h2x2(:,388),heltab2x4(:,:,388))
call HGT_OLR(G1H4(440),1,1,4)
call HGT_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(440),ex5(:),G1H2(29),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_UW_V(ntryL,G1H4(1705),43,ex3(:),4,G2H2(361),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_SV_T(ntryL,G1H4(445),43,ex3(:),4,G2H2(362),m3h2x2(:,391),heltab2x4(:,:,391))
call HGT_raise_alpha_OLR(G1H4(446),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(446),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(446),ex5(:),G1H2(30),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_SV_T(ntryL,G1H4(1699),43,ex3(:),4,G2H2(363),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_UW_V(ntryL,G1H4(451),43,ex3(:),4,G2H2(364),m3h2x2(:,394),heltab2x4(:,:,394))
call HGT_raise_alpha_OLR(G1H4(452),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(452),-16,ex5(:),16,G2H2(365),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_UW_V(ntryL,G1H4(1711),43,ex3(:),4,G2H2(366),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_SV_T(ntryL,G1H4(457),43,ex5(:),16,G2H2(367),m3h2x2(:,397),heltab2x4(:,:,397))
call HGT_OLR(G1H4(458),1,1,4)
call HGT_invQ_OLR(G1H4(458),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(458),-4,ex3(:),4,G2H2(368),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_SV_T(ntryL,G1H4(1741),43,ex5(:),16,G2H2(369),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_UW_V(ntryL,G1H4(463),43,ex5(:),16,G2H2(370),m3h2x2(:,400),heltab2x4(:,:,400))
call HGT_OLR(G1H4(464),1,1,4)
call HGT_invQ_OLR(G1H4(464),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(464),ex3(:),G1H2(31),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_UW_V(ntryL,G1H4(1765),43,ex5(:),16,G2H2(371),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_SV_T(ntryL,G1H4(469),43,ex5(:),16,G2H2(372),m3h2x2(:,403),heltab2x4(:,:,403))
call HGT_raise_alpha_OLR(G1H4(470),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(470),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(470),ex3(:),G1H2(32),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_SV_T(ntryL,G1H4(1759),43,ex5(:),16,G2H2(373),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_UW_V(ntryL,G1H4(475),43,ex5(:),16,G2H2(374),m3h2x2(:,406),heltab2x4(:,:,406))
call HGT_raise_alpha_OLR(G1H4(476),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(476),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(476),-4,ex3(:),4,G2H2(375),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_UW_V(ntryL,G1H4(1771),43,ex5(:),16,G2H2(376),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_SV_T(ntryL,G1H4(481),51,ex3(:),4,G2H2(377),m3h2x2(:,409),heltab2x4(:,:,409))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(482),-8,ex4(:),8,G2H2(378),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_SV_T(ntryL,G1H4(1801),51,ex3(:),4,G2H2(379),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_UW_V(ntryL,G1H4(487),51,ex3(:),4,G2H2(380),m3h2x2(:,412),heltab2x4(:,:,412))
call HGT_OLR(G1H4(488),1,1,4)
call HGT_invQ_OLR(G1H4(488),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(488),ex4(:),G1H2(33),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_UW_V(ntryL,G1H4(1825),51,ex3(:),4,G2H2(381),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_SV_T(ntryL,G1H4(493),51,ex3(:),4,G2H2(382),m3h2x2(:,415),heltab2x4(:,:,415))
call HGT_raise_alpha_OLR(G1H4(494),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(494),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(494),ex4(:),G1H2(34),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_SV_T(ntryL,G1H4(1819),51,ex3(:),4,G2H2(383),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_UW_V(ntryL,G1H4(499),51,ex3(:),4,G2H2(384),m3h2x2(:,418),heltab2x4(:,:,418))
call HGT_raise_alpha_OLR(G1H4(500),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(500),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(500),-8,ex4(:),8,G2H2(385),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_UW_V(ntryL,G1H4(1831),51,ex3(:),4,G2H2(386),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_SV_T(ntryL,G1H4(505),51,ex4(:),8,G2H2(387),m3h2x2(:,421),heltab2x4(:,:,421))
call HGT_OLR(G1H4(506),1,1,4)
call HGT_invQ_OLR(G1H4(506),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(506),-4,ex3(:),4,G2H2(388),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_SV_T(ntryL,G1H4(1861),51,ex4(:),8,G2H2(389),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_UW_V(ntryL,G1H4(511),51,ex4(:),8,G2H2(390),m3h2x2(:,424),heltab2x4(:,:,424))
call HGT_OLR(G1H4(512),1,1,4)
call HGT_invQ_OLR(G1H4(512),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(512),ex3(:),G1H2(35),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_UW_V(ntryL,G1H4(1885),51,ex4(:),8,G2H2(391),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_SV_T(ntryL,G1H4(517),51,ex4(:),8,G2H2(392),m3h2x2(:,427),heltab2x4(:,:,427))
call HGT_raise_alpha_OLR(G1H4(518),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(518),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(518),ex3(:),G1H2(36),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_SV_T(ntryL,G1H4(1879),51,ex4(:),8,G2H2(393),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_UW_V(ntryL,G1H4(523),51,ex4(:),8,G2H2(394),m3h2x2(:,430),heltab2x4(:,:,430))
call HGT_raise_alpha_OLR(G1H4(524),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(524),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(524),-4,ex3(:),4,G2H2(395),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_UW_V(ntryL,G1H4(1891),51,ex4(:),8,G2H2(396),m3h2x2(:,432),heltab2x4(:,:,432))
call HGT_OLR(G1H4(530),1,1,4)
call HGT_invQ_OLR(G1H4(530),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(530),-16,ex5(:),16,G2H2(397),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_TV_S(ntryL,G1H4(534),43,ex3(:),4,G2H2(398),m3h2x2(:,434),heltab2x4(:,:,434))
call HGT_raise_alpha_OLR(G1H4(536),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(536),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(536),ex5(:),G1H2(37),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_TV_S(ntryL,G1H4(540),43,ex3(:),4,G2H2(399),m3h2x2(:,436),heltab2x4(:,:,436))
call HGT_OLR(G1H4(542),1,1,4)
call HGT_invQ_OLR(G1H4(542),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(542),ex5(:),G1H2(38),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_UV_W(ntryL,G1H4(546),43,ex3(:),4,G2H2(400),m3h2x2(:,438),heltab2x4(:,:,438))
call HGT_raise_alpha_OLR(G1H4(548),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(548),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(548),-16,ex5(:),16,G2H2(401),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_UV_W(ntryL,G1H4(552),43,ex3(:),4,G2H2(402),m3h2x2(:,440),heltab2x4(:,:,440))
call HGT_OLR(G1H4(554),1,1,4)
call HGT_invQ_OLR(G1H4(554),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(554),-16,ex5(:),16,G2H2(403),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_SV_T(ntryL,G1H4(558),39,ex4(:),8,G2H2(404),m3h2x2(:,442),heltab2x4(:,:,442))
call HGT_OLR(G1H4(560),1,1,4)
call HGT_invQ_OLR(G1H4(560),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(560),ex5(:),G1H2(39),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_UW_V(ntryL,G1H4(564),39,ex4(:),8,G2H2(405),m3h2x2(:,444),heltab2x4(:,:,444))
call HGT_raise_alpha_OLR(G1H4(566),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(566),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(566),ex5(:),G1H2(40),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_SV_T(ntryL,G1H4(570),39,ex4(:),8,G2H2(406),m3h2x2(:,446),heltab2x4(:,:,446))
call HGT_raise_alpha_OLR(G1H4(572),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(572),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(572),-16,ex5(:),16,G2H2(407),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_UW_V(ntryL,G1H4(576),39,ex4(:),8,G2H2(408),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_SA_Q(ntryL,G1H4(577),ex2(:),G1H2(41),ngH,m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(409),n2h2(1))
call HGT_OLR(G1H4(578),1,1,4)
call HGT_invQ_OLR(G1H4(578),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(578),-16,nME,G2H4(25),n2h4(501))
  call Hloop_QV_A(ntryL,G2H4(25),ex5(:),G2H2(410),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_SA_Q(ntryL,G1H4(583),ex2(:),G1H2(41),ngH,m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(411),n2h2(2))
call HGT_OLR(G1H4(584),1,1,4)
call HGT_invQ_OLR(G1H4(584),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(584),-16,nME,G2H4(26),n2h4(502))
  call Hloop_QV_A(ntryL,G2H4(26),ex5(:),G2H2(412),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_SA_Q(ntryL,G1H4(588),ex2(:),G1H2(41),ngH,m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(413),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(589),ex2(:),G1H2(41),ngX,m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(414),n2h2(4))
call HGT_OLR(G1H4(590),1,1,4)
call HGT_invQ_OLR(G1H4(590),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(590),-16,nME,G2H4(27),n2h4(503))
  call Hloop_QV_A(ntryL,G2H4(27),ex5(:),G2H2(415),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_SA_Q(ntryL,G1H4(595),ex2(:),G1H2(41),ngX,m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(416),n2h2(5))
call HGT_OLR(G1H4(596),1,1,4)
call HGT_invQ_OLR(G1H4(596),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(596),-16,nME,G2H4(28),n2h4(504))
  call Hloop_QV_A(ntryL,G2H4(28),ex5(:),G2H2(417),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_SA_Q(ntryL,G1H4(600),ex2(:),G1H2(41),ngX,m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(418),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(601),ex2(:),G1H2(41),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(419),n2h2(7))
call HGT_OLR(G1H4(602),1,1,4)
call HGT_invQ_OLR(G1H4(602),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(602),-16,nME,G2H4(29),n2h4(505))
  call Hloop_QV_A(ntryL,G2H4(29),ex5(:),G2H2(420),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_VA_Q(ntryL,G1H4(607),ex2(:),G1H2(41),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(421),n2h2(8))
call HGT_OLR(G1H4(608),1,1,4)
call HGT_invQ_OLR(G1H4(608),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(608),-16,nME,G2H4(30),n2h4(506))
  call Hloop_QV_A(ntryL,G2H4(30),ex5(:),G2H2(422),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_VA_Q(ntryL,G1H4(612),ex2(:),G1H2(41),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(423),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(613),ex2(:),G1H2(41),ngZl,m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(424),n2h2(10))
call HGT_OLR(G1H4(614),1,1,4)
call HGT_invQ_OLR(G1H4(614),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(614),-16,nME,G2H4(31),n2h4(507))
  call Hloop_QV_A(ntryL,G2H4(31),ex5(:),G2H2(425),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_ZA_Q(ntryL,G1H4(619),ex2(:),G1H2(41),ngZl,m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(426),n2h2(11))
call HGT_OLR(G1H4(620),1,1,4)
call HGT_invQ_OLR(G1H4(620),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(620),-16,nME,G2H4(32),n2h4(508))
  call Hloop_QV_A(ntryL,G2H4(32),ex5(:),G2H2(427),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_ZA_Q(ntryL,G1H4(624),ex2(:),G1H2(41),ngZl,m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_A_Q(ntryL,G1H2(41),47,nME,G2H2(428),n2h2(12))
call HGT_OLR(G1H4(626),1,1,4)
call HGT_invQ_OLR(G1H4(626),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(626),-8,ex4(:),8,G2H2(429),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_SV_T(ntryL,G1H4(630),39,ex5(:),16,G2H2(430),m3h2x2(:,470),heltab2x4(:,:,470))
call HGT_OLR(G1H4(632),1,1,4)
call HGT_invQ_OLR(G1H4(632),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(632),ex4(:),G1H2(41),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_UW_V(ntryL,G1H4(636),39,ex5(:),16,G2H2(431),m3h2x2(:,472),heltab2x4(:,:,472))
call HGT_raise_alpha_OLR(G1H4(638),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(638),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(638),ex4(:),G1H2(42),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_SV_T(ntryL,G1H4(642),39,ex5(:),16,G2H2(432),m3h2x2(:,474),heltab2x4(:,:,474))
call HGT_raise_alpha_OLR(G1H4(644),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(644),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(644),-8,ex4(:),8,G2H2(433),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_UW_V(ntryL,G1H4(648),39,ex5(:),16,G2H2(434),m3h2x2(:,476),heltab2x4(:,:,476))
call HGT_OLR(G1H4(650),1,1,4)
call HGT_invQ_OLR(G1H4(650),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(650),-16,ex5(:),16,G2H2(435),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_SV_T(ntryL,G1H4(654),43,ex3(:),4,G2H2(436),m3h2x2(:,478),heltab2x4(:,:,478))
call HGT_OLR(G1H4(656),1,1,4)
call HGT_invQ_OLR(G1H4(656),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(656),ex5(:),G1H2(43),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_UW_V(ntryL,G1H4(660),43,ex3(:),4,G2H2(437),m3h2x2(:,480),heltab2x4(:,:,480))
call HGT_raise_alpha_OLR(G1H4(662),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(662),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(662),ex5(:),G1H2(44),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_SV_T(ntryL,G1H4(666),43,ex3(:),4,G2H2(438),m3h2x2(:,482),heltab2x4(:,:,482))
call HGT_raise_alpha_OLR(G1H4(668),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(668),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(668),-16,ex5(:),16,G2H2(439),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_UW_V(ntryL,G1H4(672),43,ex3(:),4,G2H2(440),m3h2x2(:,484),heltab2x4(:,:,484))
call HGT_OLR(G1H4(674),1,1,4)
call HGT_invQ_OLR(G1H4(674),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(674),-16,ex5(:),16,G2H2(441),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_TV_S(ntryL,G1H4(678),39,ex4(:),8,G2H2(442),m3h2x2(:,486),heltab2x4(:,:,486))
call HGT_raise_alpha_OLR(G1H4(680),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(680),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(680),ex5(:),G1H2(45),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_TV_S(ntryL,G1H4(684),39,ex4(:),8,G2H2(443),m3h2x2(:,488),heltab2x4(:,:,488))
call HGT_OLR(G1H4(686),1,1,4)
call HGT_invQ_OLR(G1H4(686),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(686),ex5(:),G1H2(46),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_UV_W(ntryL,G1H4(690),39,ex4(:),8,G2H2(444),m3h2x2(:,490),heltab2x4(:,:,490))
call HGT_raise_alpha_OLR(G1H4(692),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(692),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(692),-16,ex5(:),16,G2H2(445),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_UV_W(ntryL,G1H4(696),39,ex4(:),8,G2H2(446),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_SA_Q(ntryL,G1H4(697),ex2(:),G1H2(47),ngH,m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(447),n2h2(13))
call HGT_OLR(G1H4(698),1,1,4)
call HGT_invQ_OLR(G1H4(698),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(698),-16,nME,G2H4(33),n2h4(521))
  call Hloop_QV_A(ntryL,G2H4(33),ex5(:),G2H2(448),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_SA_Q(ntryL,G1H4(703),ex2(:),G1H2(47),ngH,m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(449),n2h2(14))
call HGT_OLR(G1H4(704),1,1,4)
call HGT_invQ_OLR(G1H4(704),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(704),-16,nME,G2H4(34),n2h4(522))
  call Hloop_QV_A(ntryL,G2H4(34),ex5(:),G2H2(450),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_SA_Q(ntryL,G1H4(708),ex2(:),G1H2(47),ngH,m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(451),n2h2(15))
  call Hloop_SA_Q(ntryL,G1H4(709),ex2(:),G1H2(47),ngX,m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(452),n2h2(16))
call HGT_OLR(G1H4(710),1,1,4)
call HGT_invQ_OLR(G1H4(710),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(710),-16,nME,G2H4(35),n2h4(523))
  call Hloop_QV_A(ntryL,G2H4(35),ex5(:),G2H2(453),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_SA_Q(ntryL,G1H4(715),ex2(:),G1H2(47),ngX,m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(454),n2h2(17))
call HGT_OLR(G1H4(716),1,1,4)
call HGT_invQ_OLR(G1H4(716),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(716),-16,nME,G2H4(36),n2h4(524))
  call Hloop_QV_A(ntryL,G2H4(36),ex5(:),G2H2(455),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_SA_Q(ntryL,G1H4(720),ex2(:),G1H2(47),ngX,m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(456),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(721),ex2(:),G1H2(47),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(457),n2h2(19))
call HGT_OLR(G1H4(722),1,1,4)
call HGT_invQ_OLR(G1H4(722),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(722),-16,nME,G2H4(37),n2h4(525))
  call Hloop_QV_A(ntryL,G2H4(37),ex5(:),G2H2(458),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_VA_Q(ntryL,G1H4(727),ex2(:),G1H2(47),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(459),n2h2(20))
call HGT_OLR(G1H4(728),1,1,4)
call HGT_invQ_OLR(G1H4(728),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(728),-16,nME,G2H4(38),n2h4(526))
  call Hloop_QV_A(ntryL,G2H4(38),ex5(:),G2H2(460),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_VA_Q(ntryL,G1H4(732),ex2(:),G1H2(47),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(461),n2h2(21))
  call Hloop_ZA_Q(ntryL,G1H4(733),ex2(:),G1H2(47),ngZl,m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(462),n2h2(22))
call HGT_OLR(G1H4(734),1,1,4)
call HGT_invQ_OLR(G1H4(734),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(734),-16,nME,G2H4(39),n2h4(527))
  call Hloop_QV_A(ntryL,G2H4(39),ex5(:),G2H2(463),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_ZA_Q(ntryL,G1H4(739),ex2(:),G1H2(47),ngZl,m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(464),n2h2(23))
call HGT_OLR(G1H4(740),1,1,4)
call HGT_invQ_OLR(G1H4(740),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(740),-16,nME,G2H4(40),n2h4(528))
  call Hloop_QV_A(ntryL,G2H4(40),ex5(:),G2H2(465),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_ZA_Q(ntryL,G1H4(744),ex2(:),G1H2(47),ngZl,m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_A_Q(ntryL,G1H2(47),47,nME,G2H2(466),n2h2(24))
  call Hloop_SQ_A(ntryL,G1H4(745),ex1(:),G1H2(47),ngH,m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(467),n2h2(25))
call HGT_OLR(G1H4(746),1,1,4)
call HGT_invQ_OLR(G1H4(746),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(746),-8,nME,G2H4(57),n2h4(529))
  call Hloop_AV_Q(ntryL,G2H4(57),ex4(:),G2H2(468),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_SQ_A(ntryL,G1H4(751),ex1(:),G1H2(47),ngH,m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(469),n2h2(26))
call HGT_OLR(G1H4(752),1,1,4)
call HGT_invQ_OLR(G1H4(752),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(752),-8,nME,G2H4(58),n2h4(530))
  call Hloop_AV_Q(ntryL,G2H4(58),ex4(:),G2H2(470),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_SQ_A(ntryL,G1H4(756),ex1(:),G1H2(47),ngH,m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(471),n2h2(27))
  call Hloop_SQ_A(ntryL,G1H4(757),ex1(:),G1H2(47),ngX,m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(472),n2h2(28))
call HGT_OLR(G1H4(758),1,1,4)
call HGT_invQ_OLR(G1H4(758),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(758),-8,nME,G2H4(59),n2h4(531))
  call Hloop_AV_Q(ntryL,G2H4(59),ex4(:),G2H2(473),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_SQ_A(ntryL,G1H4(763),ex1(:),G1H2(47),ngX,m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(474),n2h2(29))
call HGT_OLR(G1H4(764),1,1,4)
call HGT_invQ_OLR(G1H4(764),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(764),-8,nME,G2H4(60),n2h4(532))
  call Hloop_AV_Q(ntryL,G2H4(60),ex4(:),G2H2(475),m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_SQ_A(ntryL,G1H4(768),ex1(:),G1H2(47),ngX,m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(476),n2h2(30))
  call Hloop_VQ_A(ntryL,G1H4(769),ex1(:),G1H2(47),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(477),n2h2(31))
call HGT_OLR(G1H4(770),1,1,4)
call HGT_invQ_OLR(G1H4(770),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(770),-8,nME,G2H4(61),n2h4(533))
  call Hloop_AV_Q(ntryL,G2H4(61),ex4(:),G2H2(478),m3h2x2(:,524),heltab2x4(:,:,524))
  call Hloop_VQ_A(ntryL,G1H4(775),ex1(:),G1H2(47),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(479),n2h2(32))
call HGT_OLR(G1H4(776),1,1,4)
call HGT_invQ_OLR(G1H4(776),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(776),-8,nME,G2H4(62),n2h4(534))
  call Hloop_AV_Q(ntryL,G2H4(62),ex4(:),G2H2(480),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_VQ_A(ntryL,G1H4(780),ex1(:),G1H2(47),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(481),n2h2(33))
  call Hloop_ZQ_A(ntryL,G1H4(781),ex1(:),G1H2(47),ngZl,m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(482),n2h2(34))
call HGT_OLR(G1H4(782),1,1,4)
call HGT_invQ_OLR(G1H4(782),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(782),-8,nME,G2H4(63),n2h4(535))
  call Hloop_AV_Q(ntryL,G2H4(63),ex4(:),G2H2(483),m3h2x2(:,529),heltab2x4(:,:,529))
  call Hloop_ZQ_A(ntryL,G1H4(787),ex1(:),G1H2(47),ngZl,m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(484),n2h2(35))
call HGT_OLR(G1H4(788),1,1,4)
call HGT_invQ_OLR(G1H4(788),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(788),-8,nME,G2H4(64),n2h4(536))
  call Hloop_AV_Q(ntryL,G2H4(64),ex4(:),G2H2(485),m3h2x2(:,531),heltab2x4(:,:,531))
  call Hloop_ZQ_A(ntryL,G1H4(792),ex1(:),G1H2(47),ngZl,m3h2x2(:,532),heltab2x4(:,:,532))
  call Hloop_Q_A(ntryL,G1H2(47),55,nME,G2H2(486),n2h2(36))
  call Hloop_SQ_A(ntryL,G1H4(793),ex1(:),G1H2(47),ngH,m3h2x2(:,533),heltab2x4(:,:,533))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(487),n2h2(37))
call HGT_OLR(G1H4(794),1,1,4)
call HGT_invQ_OLR(G1H4(794),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(794),-16,nME,G2H4(65),n2h4(537))
  call Hloop_AV_Q(ntryL,G2H4(65),ex5(:),G2H2(488),m3h2x2(:,534),heltab2x4(:,:,534))
  call Hloop_SQ_A(ntryL,G1H4(799),ex1(:),G1H2(47),ngH,m3h2x2(:,535),heltab2x4(:,:,535))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(489),n2h2(38))
call HGT_OLR(G1H4(800),1,1,4)
call HGT_invQ_OLR(G1H4(800),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(800),-16,nME,G2H4(66),n2h4(538))
  call Hloop_AV_Q(ntryL,G2H4(66),ex5(:),G2H2(490),m3h2x2(:,536),heltab2x4(:,:,536))
  call Hloop_SQ_A(ntryL,G1H4(804),ex1(:),G1H2(47),ngH,m3h2x2(:,537),heltab2x4(:,:,537))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(491),n2h2(39))
  call Hloop_SQ_A(ntryL,G1H4(805),ex1(:),G1H2(47),ngX,m3h2x2(:,538),heltab2x4(:,:,538))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(492),n2h2(40))
call HGT_OLR(G1H4(806),1,1,4)
call HGT_invQ_OLR(G1H4(806),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(806),-16,nME,G2H4(67),n2h4(539))
  call Hloop_AV_Q(ntryL,G2H4(67),ex5(:),G2H2(493),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_SQ_A(ntryL,G1H4(811),ex1(:),G1H2(47),ngX,m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(494),n2h2(41))
call HGT_OLR(G1H4(812),1,1,4)
call HGT_invQ_OLR(G1H4(812),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(812),-16,nME,G2H4(68),n2h4(540))
  call Hloop_AV_Q(ntryL,G2H4(68),ex5(:),G2H2(495),m3h2x2(:,541),heltab2x4(:,:,541))
  call Hloop_SQ_A(ntryL,G1H4(816),ex1(:),G1H2(47),ngX,m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(496),n2h2(42))
  call Hloop_VQ_A(ntryL,G1H4(817),ex1(:),G1H2(47),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(497),n2h2(43))
call HGT_OLR(G1H4(818),1,1,4)
call HGT_invQ_OLR(G1H4(818),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(818),-16,nME,G2H4(69),n2h4(541))
  call Hloop_AV_Q(ntryL,G2H4(69),ex5(:),G2H2(498),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_VQ_A(ntryL,G1H4(823),ex1(:),G1H2(47),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(499),n2h2(44))
call HGT_OLR(G1H4(824),1,1,4)
call HGT_invQ_OLR(G1H4(824),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(824),-16,nME,G2H4(70),n2h4(542))
  call Hloop_AV_Q(ntryL,G2H4(70),ex5(:),G2H2(500),m3h2x2(:,546),heltab2x4(:,:,546))
  call Hloop_VQ_A(ntryL,G1H4(828),ex1(:),G1H2(47),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(501),n2h2(45))
  call Hloop_ZQ_A(ntryL,G1H4(829),ex1(:),G1H2(47),ngZl,m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(502),n2h2(46))
call HGT_OLR(G1H4(830),1,1,4)
call HGT_invQ_OLR(G1H4(830),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(830),-16,nME,G2H4(71),n2h4(543))
  call Hloop_AV_Q(ntryL,G2H4(71),ex5(:),G2H2(503),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_ZQ_A(ntryL,G1H4(835),ex1(:),G1H2(47),ngZl,m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(504),n2h2(47))
call HGT_OLR(G1H4(836),1,1,4)
call HGT_invQ_OLR(G1H4(836),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(836),-16,nME,G2H4(72),n2h4(544))
  call Hloop_AV_Q(ntryL,G2H4(72),ex5(:),G2H2(505),m3h2x2(:,551),heltab2x4(:,:,551))
  call Hloop_ZQ_A(ntryL,G1H4(840),ex1(:),G1H2(47),ngZl,m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_Q_A(ntryL,G1H2(47),47,nME,G2H2(506),n2h2(48))
call HGT_OLR(G1H4(842),1,1,4)
call HGT_invQ_OLR(G1H4(842),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(842),-8,ex4(:),8,G2H2(507),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_TV_S(ntryL,G1H4(846),39,ex5(:),16,G2H2(508),m3h2x2(:,554),heltab2x4(:,:,554))
call HGT_raise_alpha_OLR(G1H4(848),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(848),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(848),ex4(:),G1H2(47),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_TV_S(ntryL,G1H4(852),39,ex5(:),16,G2H2(509),m3h2x2(:,556),heltab2x4(:,:,556))
call HGT_OLR(G1H4(854),1,1,4)
call HGT_invQ_OLR(G1H4(854),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(854),ex4(:),G1H2(48),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_UV_W(ntryL,G1H4(858),39,ex5(:),16,G2H2(510),m3h2x2(:,558),heltab2x4(:,:,558))
call HGT_raise_alpha_OLR(G1H4(860),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(860),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(860),-8,ex4(:),8,G2H2(511),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_UV_W(ntryL,G1H4(864),39,ex5(:),16,G2H2(512),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_SQ_A(ntryL,G1H4(865),ex1(:),G1H2(49),ngH,m3h2x2(:,561),heltab2x4(:,:,561))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(513),n2h2(49))
call HGT_OLR(G1H4(866),1,1,4)
call HGT_invQ_OLR(G1H4(866),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(866),-16,nME,G2H4(81),n2h4(549))
  call Hloop_AV_Q(ntryL,G2H4(81),ex5(:),G2H2(514),m3h2x2(:,562),heltab2x4(:,:,562))
  call Hloop_SQ_A(ntryL,G1H4(871),ex1(:),G1H2(49),ngH,m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(515),n2h2(50))
call HGT_OLR(G1H4(872),1,1,4)
call HGT_invQ_OLR(G1H4(872),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(872),-16,nME,G2H4(82),n2h4(550))
  call Hloop_AV_Q(ntryL,G2H4(82),ex5(:),G2H2(516),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_SQ_A(ntryL,G1H4(876),ex1(:),G1H2(49),ngH,m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(517),n2h2(51))
  call Hloop_SQ_A(ntryL,G1H4(877),ex1(:),G1H2(49),ngX,m3h2x2(:,566),heltab2x4(:,:,566))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(518),n2h2(52))
call HGT_OLR(G1H4(878),1,1,4)
call HGT_invQ_OLR(G1H4(878),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(878),-16,nME,G2H4(83),n2h4(551))
  call Hloop_AV_Q(ntryL,G2H4(83),ex5(:),G2H2(519),m3h2x2(:,567),heltab2x4(:,:,567))
  call Hloop_SQ_A(ntryL,G1H4(883),ex1(:),G1H2(49),ngX,m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(520),n2h2(53))
call HGT_OLR(G1H4(884),1,1,4)
call HGT_invQ_OLR(G1H4(884),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(884),-16,nME,G2H4(84),n2h4(552))
  call Hloop_AV_Q(ntryL,G2H4(84),ex5(:),G2H2(521),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_SQ_A(ntryL,G1H4(888),ex1(:),G1H2(49),ngX,m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(522),n2h2(54))
  call Hloop_VQ_A(ntryL,G1H4(889),ex1(:),G1H2(49),m3h2x2(:,571),heltab2x4(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(523),n2h2(55))
call HGT_OLR(G1H4(890),1,1,4)
call HGT_invQ_OLR(G1H4(890),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(890),-16,nME,G2H4(85),n2h4(553))
  call Hloop_AV_Q(ntryL,G2H4(85),ex5(:),G2H2(524),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_VQ_A(ntryL,G1H4(895),ex1(:),G1H2(49),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(525),n2h2(56))
call HGT_OLR(G1H4(896),1,1,4)
call HGT_invQ_OLR(G1H4(896),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(896),-16,nME,G2H4(86),n2h4(554))
  call Hloop_AV_Q(ntryL,G2H4(86),ex5(:),G2H2(526),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_VQ_A(ntryL,G1H4(900),ex1(:),G1H2(49),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(527),n2h2(57))
  call Hloop_ZQ_A(ntryL,G1H4(901),ex1(:),G1H2(49),ngZl,m3h2x2(:,576),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(528),n2h2(58))
call HGT_OLR(G1H4(902),1,1,4)
call HGT_invQ_OLR(G1H4(902),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(902),-16,nME,G2H4(87),n2h4(555))
  call Hloop_AV_Q(ntryL,G2H4(87),ex5(:),G2H2(529),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_ZQ_A(ntryL,G1H4(907),ex1(:),G1H2(49),ngZl,m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(530),n2h2(59))
call HGT_OLR(G1H4(908),1,1,4)
call HGT_invQ_OLR(G1H4(908),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(908),-16,nME,G2H4(88),n2h4(556))
  call Hloop_AV_Q(ntryL,G2H4(88),ex5(:),G2H2(531),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_ZQ_A(ntryL,G1H4(912),ex1(:),G1H2(49),ngZl,m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(532),n2h2(60))
  call Hloop_SA_Q(ntryL,G1H4(913),ex2(:),G1H2(49),ngH,m3h2x2(:,581),heltab2x4(:,:,581))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(533),n2h2(61))
call HGT_OLR(G1H4(914),1,1,4)
call HGT_invQ_OLR(G1H4(914),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(914),-8,nME,G2H4(89),n2h4(557))
  call Hloop_QV_A(ntryL,G2H4(89),ex4(:),G2H2(534),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_SA_Q(ntryL,G1H4(919),ex2(:),G1H2(49),ngH,m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(535),n2h2(62))
call HGT_OLR(G1H4(920),1,1,4)
call HGT_invQ_OLR(G1H4(920),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(920),-8,nME,G2H4(90),n2h4(558))
  call Hloop_QV_A(ntryL,G2H4(90),ex4(:),G2H2(536),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_SA_Q(ntryL,G1H4(924),ex2(:),G1H2(49),ngH,m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(537),n2h2(63))
  call Hloop_SA_Q(ntryL,G1H4(925),ex2(:),G1H2(49),ngX,m3h2x2(:,586),heltab2x4(:,:,586))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(538),n2h2(64))
call HGT_OLR(G1H4(926),1,1,4)
call HGT_invQ_OLR(G1H4(926),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(926),-8,nME,G2H4(91),n2h4(559))
  call Hloop_QV_A(ntryL,G2H4(91),ex4(:),G2H2(539),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_SA_Q(ntryL,G1H4(931),ex2(:),G1H2(49),ngX,m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(540),n2h2(65))
call HGT_OLR(G1H4(932),1,1,4)
call HGT_invQ_OLR(G1H4(932),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(932),-8,nME,G2H4(92),n2h4(560))
  call Hloop_QV_A(ntryL,G2H4(92),ex4(:),G2H2(541),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_SA_Q(ntryL,G1H4(936),ex2(:),G1H2(49),ngX,m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(542),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(937),ex2(:),G1H2(49),m3h2x2(:,591),heltab2x4(:,:,591))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(543),n2h2(67))
call HGT_OLR(G1H4(938),1,1,4)
call HGT_invQ_OLR(G1H4(938),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(938),-8,nME,G2H4(93),n2h4(561))
  call Hloop_QV_A(ntryL,G2H4(93),ex4(:),G2H2(544),m3h2x2(:,592),heltab2x4(:,:,592))
  call Hloop_VA_Q(ntryL,G1H4(943),ex2(:),G1H2(49),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(545),n2h2(68))
call HGT_OLR(G1H4(944),1,1,4)
call HGT_invQ_OLR(G1H4(944),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(944),-8,nME,G2H4(94),n2h4(562))
  call Hloop_QV_A(ntryL,G2H4(94),ex4(:),G2H2(546),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_VA_Q(ntryL,G1H4(948),ex2(:),G1H2(49),m3h2x2(:,595),heltab2x4(:,:,595))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(547),n2h2(69))
  call Hloop_ZA_Q(ntryL,G1H4(949),ex2(:),G1H2(49),ngZl,m3h2x2(:,596),heltab2x4(:,:,596))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(548),n2h2(70))
call HGT_OLR(G1H4(950),1,1,4)
call HGT_invQ_OLR(G1H4(950),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(950),-8,nME,G2H4(95),n2h4(563))
  call Hloop_QV_A(ntryL,G2H4(95),ex4(:),G2H2(549),m3h2x2(:,597),heltab2x4(:,:,597))
  call Hloop_ZA_Q(ntryL,G1H4(955),ex2(:),G1H2(49),ngZl,m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(550),n2h2(71))
call HGT_OLR(G1H4(956),1,1,4)
call HGT_invQ_OLR(G1H4(956),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(956),-8,nME,G2H4(96),n2h4(564))
  call Hloop_QV_A(ntryL,G2H4(96),ex4(:),G2H2(551),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_ZA_Q(ntryL,G1H4(960),ex2(:),G1H2(49),ngZl,m3h2x2(:,600),heltab2x4(:,:,600))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(552),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(961),ex3(:),G1H2(49),m3h2x2(:,601),heltab2x4(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(553),n2h2(73))
call HGT_OLR(G1H4(962),1,1,4)
call HGT_invQ_OLR(G1H4(962),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(962),-16,nME,G2H4(97),n2h4(565))
  call Hloop_AV_Q(ntryL,G2H4(97),ex5(:),G2H2(554),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_QV_A(ntryL,G1H4(967),ex3(:),G1H2(49),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(555),n2h2(74))
call HGT_OLR(G1H4(968),1,1,4)
call HGT_invQ_OLR(G1H4(968),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(968),-16,nME,G2H4(98),n2h4(566))
  call Hloop_AV_Q(ntryL,G2H4(98),ex5(:),G2H2(556),m3h2x2(:,604),heltab2x4(:,:,604))
  call Hloop_QV_A(ntryL,G1H4(972),ex3(:),G1H2(49),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(557),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(973),ex3(:),G1H2(49),m3h2x2(:,606),heltab2x4(:,:,606))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(558),n2h2(76))
call HGT_OLR(G1H4(974),1,1,4)
call HGT_invQ_OLR(G1H4(974),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(974),-16,nME,G2H4(99),n2h4(567))
  call Hloop_AV_Q(ntryL,G2H4(99),ex5(:),G2H2(559),m3h2x2(:,607),heltab2x4(:,:,607))
  call Hloop_QV_A(ntryL,G1H4(979),ex3(:),G1H2(49),m3h2x2(:,608),heltab2x4(:,:,608))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(560),n2h2(77))
call HGT_OLR(G1H4(980),1,1,4)
call HGT_invQ_OLR(G1H4(980),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(980),-16,nME,G2H4(100),n2h4(568))
  call Hloop_AV_Q(ntryL,G2H4(100),ex5(:),G2H2(561),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_QV_A(ntryL,G1H4(984),ex3(:),G1H2(49),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(562),n2h2(78))
  call Hloop_QV_A(ntryL,G1H4(985),ex3(:),G1H2(49),m3h2x2(:,611),heltab2x4(:,:,611))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(563),n2h2(79))
call HGT_OLR(G1H4(986),1,1,4)
call HGT_invQ_OLR(G1H4(986),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(986),-16,nME,G2H4(101),n2h4(569))
  call Hloop_AV_Q(ntryL,G2H4(101),ex5(:),G2H2(564),m3h2x2(:,612),heltab2x4(:,:,612))
  call Hloop_QV_A(ntryL,G1H4(991),ex3(:),G1H2(49),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(565),n2h2(80))
call HGT_OLR(G1H4(992),1,1,4)
call HGT_invQ_OLR(G1H4(992),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(992),-16,nME,G2H4(102),n2h4(570))
  call Hloop_AV_Q(ntryL,G2H4(102),ex5(:),G2H2(566),m3h2x2(:,614),heltab2x4(:,:,614))
  call Hloop_QV_A(ntryL,G1H4(996),ex3(:),G1H2(49),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(567),n2h2(81))
  call Hloop_AV_Q(ntryL,G1H4(997),ex4(:),G1H2(49),m3h2x2(:,616),heltab2x4(:,:,616))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(568),n2h2(82))
call HGT_OLR(G1H4(998),1,1,4)
call HGT_invQ_OLR(G1H4(998),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(998),-16,nME,G2H4(103),n2h4(571))
  call Hloop_QV_A(ntryL,G2H4(103),ex5(:),G2H2(569),m3h2x2(:,617),heltab2x4(:,:,617))
  call Hloop_AV_Q(ntryL,G1H4(1003),ex4(:),G1H2(49),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(570),n2h2(83))
call HGT_OLR(G1H4(1004),1,1,4)
call HGT_invQ_OLR(G1H4(1004),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1004),-16,nME,G2H4(104),n2h4(572))
  call Hloop_QV_A(ntryL,G2H4(104),ex5(:),G2H2(571),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_AV_Q(ntryL,G1H4(1008),ex4(:),G1H2(49),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(572),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H4(1009),ex4(:),G1H2(49),m3h2x2(:,621),heltab2x4(:,:,621))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(573),n2h2(85))
call HGT_OLR(G1H4(1010),1,1,4)
call HGT_invQ_OLR(G1H4(1010),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1010),-16,nME,G2H4(105),n2h4(573))
  call Hloop_QV_A(ntryL,G2H4(105),ex5(:),G2H2(574),m3h2x2(:,622),heltab2x4(:,:,622))
  call Hloop_AV_Q(ntryL,G1H4(1015),ex4(:),G1H2(49),m3h2x2(:,623),heltab2x4(:,:,623))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(575),n2h2(86))
call HGT_OLR(G1H4(1016),1,1,4)
call HGT_invQ_OLR(G1H4(1016),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1016),-16,nME,G2H4(106),n2h4(574))
  call Hloop_QV_A(ntryL,G2H4(106),ex5(:),G2H2(576),m3h2x2(:,624),heltab2x4(:,:,624))
  call Hloop_AV_Q(ntryL,G1H4(1020),ex4(:),G1H2(49),m3h2x2(:,625),heltab2x4(:,:,625))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(577),n2h2(87))
  call Hloop_AV_Q(ntryL,G1H4(1021),ex4(:),G1H2(49),m3h2x2(:,626),heltab2x4(:,:,626))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(578),n2h2(88))
call HGT_OLR(G1H4(1022),1,1,4)
call HGT_invQ_OLR(G1H4(1022),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1022),-16,nME,G2H4(107),n2h4(575))
  call Hloop_QV_A(ntryL,G2H4(107),ex5(:),G2H2(579),m3h2x2(:,627),heltab2x4(:,:,627))
  call Hloop_AV_Q(ntryL,G1H4(1027),ex4(:),G1H2(49),m3h2x2(:,628),heltab2x4(:,:,628))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(580),n2h2(89))
call HGT_OLR(G1H4(1028),1,1,4)
call HGT_invQ_OLR(G1H4(1028),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1028),-16,nME,G2H4(108),n2h4(576))
  call Hloop_QV_A(ntryL,G2H4(108),ex5(:),G2H2(581),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_AV_Q(ntryL,G1H4(1032),ex4(:),G1H2(49),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_A_Q(ntryL,G1H2(49),47,nME,G2H2(582),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H4(1033),ex5(:),G1H2(49),m3h2x2(:,631),heltab2x4(:,:,631))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(583),n2h2(91))
call HGT_OLR(G1H4(1034),1,1,4)
call HGT_invQ_OLR(G1H4(1034),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1034),-8,nME,G2H4(109),n2h4(577))
  call Hloop_QV_A(ntryL,G2H4(109),ex4(:),G2H2(584),m3h2x2(:,632),heltab2x4(:,:,632))
  call Hloop_AV_Q(ntryL,G1H4(1039),ex5(:),G1H2(49),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(585),n2h2(92))
call HGT_OLR(G1H4(1040),1,1,4)
call HGT_invQ_OLR(G1H4(1040),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1040),-8,nME,G2H4(110),n2h4(578))
  call Hloop_QV_A(ntryL,G2H4(110),ex4(:),G2H2(586),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_AV_Q(ntryL,G1H4(1044),ex5(:),G1H2(49),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(587),n2h2(93))
  call Hloop_AV_Q(ntryL,G1H4(1045),ex5(:),G1H2(49),m3h2x2(:,636),heltab2x4(:,:,636))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(588),n2h2(94))
call HGT_OLR(G1H4(1046),1,1,4)
call HGT_invQ_OLR(G1H4(1046),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1046),-8,nME,G2H4(111),n2h4(579))
  call Hloop_QV_A(ntryL,G2H4(111),ex4(:),G2H2(589),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_AV_Q(ntryL,G1H4(1051),ex5(:),G1H2(49),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(590),n2h2(95))
call HGT_OLR(G1H4(1052),1,1,4)
call HGT_invQ_OLR(G1H4(1052),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1052),-8,nME,G2H4(112),n2h4(580))
  call Hloop_QV_A(ntryL,G2H4(112),ex4(:),G2H2(591),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_AV_Q(ntryL,G1H4(1056),ex5(:),G1H2(49),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(592),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H4(1057),ex5(:),G1H2(49),m3h2x2(:,641),heltab2x4(:,:,641))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(593),n2h2(97))
call HGT_OLR(G1H4(1058),1,1,4)
call HGT_invQ_OLR(G1H4(1058),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1058),-8,nME,G2H4(113),n2h4(581))
  call Hloop_QV_A(ntryL,G2H4(113),ex4(:),G2H2(594),m3h2x2(:,642),heltab2x4(:,:,642))
  call Hloop_AV_Q(ntryL,G1H4(1063),ex5(:),G1H2(49),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(595),n2h2(98))
call HGT_OLR(G1H4(1064),1,1,4)
call HGT_invQ_OLR(G1H4(1064),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1064),-8,nME,G2H4(114),n2h4(582))
  call Hloop_QV_A(ntryL,G2H4(114),ex4(:),G2H2(596),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_AV_Q(ntryL,G1H4(1068),ex5(:),G1H2(49),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_A_Q(ntryL,G1H2(49),55,nME,G2H2(597),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(1069),ex4(:),G1H2(49),m3h2x2(:,646),heltab2x4(:,:,646))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(598),n2h2(100))
call HGT_OLR(G1H4(1070),1,1,4)
call HGT_invQ_OLR(G1H4(1070),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1070),-16,nME,G2H4(115),n2h4(583))
  call Hloop_AV_Q(ntryL,G2H4(115),ex5(:),G2H2(599),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_QV_A(ntryL,G1H4(1075),ex4(:),G1H2(49),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(600),n2h2(101))
call HGT_OLR(G1H4(1076),1,1,4)
call HGT_invQ_OLR(G1H4(1076),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1076),-16,nME,G2H4(116),n2h4(584))
  call Hloop_AV_Q(ntryL,G2H4(116),ex5(:),G2H2(601),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_QV_A(ntryL,G1H4(1080),ex4(:),G1H2(49),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(602),n2h2(102))
  call Hloop_QV_A(ntryL,G1H4(1081),ex4(:),G1H2(49),m3h2x2(:,651),heltab2x4(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(603),n2h2(103))
call HGT_OLR(G1H4(1082),1,1,4)
call HGT_invQ_OLR(G1H4(1082),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1082),-16,nME,G2H4(117),n2h4(585))
  call Hloop_AV_Q(ntryL,G2H4(117),ex5(:),G2H2(604),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_QV_A(ntryL,G1H4(1087),ex4(:),G1H2(49),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(605),n2h2(104))
call HGT_OLR(G1H4(1088),1,1,4)
call HGT_invQ_OLR(G1H4(1088),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1088),-16,nME,G2H4(118),n2h4(586))
  call Hloop_AV_Q(ntryL,G2H4(118),ex5(:),G2H2(606),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_QV_A(ntryL,G1H4(1092),ex4(:),G1H2(49),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(607),n2h2(105))
call HGT_OLR(G1H4(1094),1,1,4)
call HGT_invQ_OLR(G1H4(1094),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(1094),-16,ex5(:),16,G2H2(608),m3h2x2(:,656),heltab2x4(:,:,656))
  call Hloop_TV_S(ntryL,G1H4(1098),39,ex4(:),8,G2H2(609),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_QV_A(ntryL,G1H4(1099),ex4(:),G1H2(49),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_Q_A(ntryL,G1H2(49),47,nME,G2H2(610),n2h2(106))
call HGT_OLR(G1H4(1100),1,1,4)
call HGT_invQ_OLR(G1H4(1100),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1100),-16,nME,G2H4(119),n2h4(588))
  call Hloop_AV_Q(ntryL,G2H4(119),ex5(:),G2H2(611),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_QV_A(ntryL,G1H4(1105),ex4(:),G1H2(49),m3h2x2(:,660),heltab2x4(:,:,660))



end subroutine vamp_1

end module ol_vamp_1_eeaa_lew_eexaaaa_1_/**/REALKIND
