
module ol_vamp_1_eeaa_lew_eexaaa_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeaa_lew_eexaaa_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeaa_lew_eexaaa_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeaa_lew_eexaaa_4_/**/DREALKIND
  use ol_tensor_sum_storage_eeaa_lew_eexaaa_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeaa_lew_eexaaa_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_lew_eexaaa_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nME,nME,0,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nME,0,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nME,nME,0,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nME,0,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[nME,0,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[nME,0,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(6),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(1),n2h8(1))
  call Hloop_QA_V(ntryL,G1H16(2),ex2(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(2),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(2),20,nME,G2H8(2),n2h8(2))
  call Hloop_QA_V(ntryL,G1H16(4),ex2(:),G1H8(2),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex1(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_V(ntryL,G1H16(6),ex1(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(2),n2h4(1))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(4),n2h4(2))
  call Hloop_VA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(5),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(6),n2h4(4))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(3),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(5),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(6),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nME,G2H4(1),n2h4(5))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(3),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(4),n2h2(3))
  call Hloop_QV_A(ntryL,G1H4(7),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(5),n2h2(4))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-8,nME,G2H4(2),n2h4(6))
  call Hloop_AV_Q(ntryL,G2H4(2),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QV_A(ntryL,G1H4(11),ex3(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(7),n2h2(5))
  call Hloop_QV_A(ntryL,G1H4(12),ex3(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(8),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(9),n2h2(7))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-8,nME,G2H4(3),n2h4(7))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VQ_A(ntryL,G1H4(17),ex1(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(11),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex1(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(12),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(19),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),27,nME,G2H2(13),n2h2(10))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-4,nME,G2H4(4),n2h4(8))
  call Hloop_AV_Q(ntryL,G2H4(4),ex3(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),27,nME,G2H2(15),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(24),ex4(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),27,nME,G2H2(16),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H4(25),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(17),n2h2(13))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-8,nME,G2H4(5),n2h4(9))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AV_Q(ntryL,G1H4(29),ex3(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(19),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H4(30),ex3(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(20),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H4(31),ex4(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),27,nME,G2H2(21),n2h2(16))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-4,nME,G2H4(6),n2h4(10))
  call Hloop_QV_A(ntryL,G2H4(6),ex3(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AV_Q(ntryL,G1H4(35),ex4(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),27,nME,G2H2(23),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H4(36),ex4(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),27,nME,G2H2(24),n2h2(18))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),10,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,2),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(2),mass4set(:,2),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),12,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(3),mass4set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),9,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(4),mass5set(:,2),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),4,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(2),mass4set(:,2),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),12,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(5),mass5set(:,2),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(4),mass4set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),12,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(6),mass5set(:,2),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),4,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(4),mass4set(:,2),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call Hloop_AV_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(1),n2h1(1))
  call Hloop_AV_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(2),n2h1(2))
  call Hloop_AV_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(4),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(6),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(7),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(8),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(9),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(10),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(11),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(12),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(13),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(14),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(15),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(20),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(21),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(22),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(23),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(24),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(1),n2h16(7))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(2),n2h16(8))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(3),n2h16(9))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(4),n2h16(10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(11))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(6),n2h16(12))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(8),n2h16(14))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(9),n2h16(15))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(10),n2h16(16))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(11),n2h16(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(12),n2h16(18))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(14),n2h16(20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(22))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(17),n2h16(23))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(18),n2h16(24))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(19),n2h16(25))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(20),n2h16(26))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(23),n2h16(29))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(24),n2h16(30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,5,2,8],[nME,0,nME,nME],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(25),n2h16(31))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,5,8],[nME,0,nME,nME],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(26),n2h16(32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,6,1,8],[nME,0,nME,nME],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(27),n2h16(33))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,6,8],[nME,0,nME,nME],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(28),n2h16(34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,4,2,9],[nME,nME,0,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(29),n2h16(35))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,2,9,4],[nME,0,nME,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(30),n2h16(36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,4,1,10],[nME,nME,0,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(31),n2h16(37))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,1,10,4],[nME,0,nME,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(32),n2h16(38))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[17,2,4,8],[0,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,39))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[17,2,8,4],[0,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,2),heltab2x32(:,:,40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[18,1,4,8],[0,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,41))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[18,1,8,4],[0,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(4),m3h4x8(:,4),heltab2x32(:,:,42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(22)])
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,13),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(1),n2h4(11))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,13),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMM,G2H4(2),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,13),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(5),19,nME,G2H4(3),n2h4(13))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,13),G1H4(6),m3h4x4(:,4),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(6),19,nMM,G2H4(4),n2h4(14))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,13),G1H4(7),m3h4x4(:,5),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(7),19,0,G2H4(5),n2h4(15))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,13),G1H4(8),m3h4x4(:,6),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(8),19,0,G2H4(6),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,13),G1H4(11),m3h4x4(:,7),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(11),19,nME,G2H4(7),n2h4(17))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,13),G1H4(12),m3h4x4(:,8),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(12),19,nMM,G2H4(8),n2h4(18))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,13),G1H4(13),m3h4x4(:,9),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(13),19,nME,G2H4(9),n2h4(19))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,13),G1H4(14),m3h4x4(:,10),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(14),19,nMM,G2H4(10),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,13),G1H4(17),m3h4x4(:,11),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(17),19,0,G2H4(11),n2h4(21))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,13),G1H4(18),m3h4x4(:,12),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(18),19,0,G2H4(12),n2h4(22))
  call Hloop_QV_A(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),20,nME,G2H8(1),n2h8(3))
  call Hloop_QV_A(ntryL,G1H16(18),ex3(:),G1H8(2),m3h2x8(:,8),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMM,G2H8(2),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(19),ex3(:),G1H8(3),m3h2x8(:,9),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(3),20,nME,G2H8(3),n2h8(5))
  call Hloop_AV_Q(ntryL,G1H16(20),ex3(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(4),20,nMM,G2H8(4),n2h8(6))
  call Hloop_QV_A(ntryL,G1H16(23),ex3(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(5),n2h8(7))
  call Hloop_AV_Q(ntryL,G1H16(24),ex3(:),G1H8(2),m3h2x8(:,12),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(2),20,0,G2H8(6),n2h8(8))
  call Hloop_AQ_V(ntryL,G1H16(25),wf4(:,3),G1H4(19),m3h4x4(:,13),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G1H16(26),ex2(:),G1H8(3),m3h2x8(:,13),heltab2x16(:,:,26))
  call Hloop_QA_V(ntryL,G1H16(27),wf4(:,10),G1H4(20),m3h4x4(:,14),heltab2x16(:,:,27))
  call Hloop_AQ_V(ntryL,G1H16(28),ex1(:),G1H8(4),m3h2x8(:,14),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),20,nME,G2H8(7),n2h8(9))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(2),m3h2x8(:,16),heltab2x16(:,:,30))
  call Hloop_AV_Q(ntryL,G1H16(31),ex3(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(8),n2h8(10))
  call Hloop_AQ_V(ntryL,G1H16(32),ex1(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,32))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),19,nME,G1H4(23),n2h4(23))
  call Hloop_VA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),19,nME,G1H4(24),n2h4(24))
  call Hloop_VQ_A(ntryL,G0H8(3),ex1(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),19,nME,G1H4(25),n2h4(25))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(1),19,nME,G1H4(26),n2h4(26))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(34)])
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(6),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(6),23,nME,G2H2(1),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(17),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(17),23,nME,G2H2(4),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(28),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(28),23,nME,G2H2(5),n2h2(21))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(10),mass4set(:,3),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(35),G0H4(1),4)
  call HG1shiftOLR(G1H4(30),8,4)
  call Hloop_VQ_A(ntryL,G1H4(15),ex1(:),G1H2(39),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(39),23,nME,G2H2(8),n2h2(22))
  call Hloop_VQ_A(ntryL,G1H4(20),ex1(:),G1H2(50),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(50),23,nME,G2H2(9),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(26),ex4(:),G1H2(61),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(61),27,nME,G2H2(12),n2h2(24))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(17),mass4set(:,3),  & 
G1H4(36),G1H4(1),G1H4(2),G1H4(5),G1H4(6),G0H4(2),4)
  call HG1shiftOLR(G1H4(1),4,4)
  call Hloop_AV_Q(ntryL,G1H4(23),ex3(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(13),n2h2(25))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(10),mass4set(:,3),  & 
G1H4(7),G1H4(8),G1H4(11),G1H4(12),G1H4(13),G0H4(3),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_AV_Q(ntryL,G1H4(24),ex4(:),G1H2(2),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(2),27,nME,G2H2(16),n2h2(26))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(17),mass4set(:,3),  & 
G1H4(14),G1H4(17),G1H4(18),G1H4(4),G1H4(9),G0H4(4),4)
  call HG1shiftOLR(G1H4(17),4,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(17),mass4set(:,4),  & 
G1H4(10),G1H4(16),G1H4(21),G1H4(22),G1H4(27),G0H4(5),4)
  call HG1shiftOLR(G1H4(16),4,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(17),mass4set(:,4),  & 
G1H4(28),G1H4(33),G1H4(34),G1H4(3),G1H4(19),G0H4(6),4)
  call HG1shiftOLR(G1H4(33),4,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(17),mass4set(:,5),  & 
G1H4(25),G1H4(15),G1H4(20),G1H4(26),G1H4(23),G0H4(7),4)
  call HG1shiftOLR(G1H4(15),4,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(17),mass4set(:,5),  & 
G1H4(24),G1H4(37),G1H4(38),G1H4(39),G1H4(40),G0H4(8),4)
  call HG1shiftOLR(G1H4(37),4,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(10),mass4set(:,4),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G0H4(9),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(10),mass4set(:,4),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),G0H4(10),4)
  call HG1shiftOLR(G1H4(47),8,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(10),mass4set(:,5),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G0H4(11),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(10),mass4set(:,5),  & 
G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),G0H4(12),4)
  call HG1shiftOLR(G1H4(57),8,4)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(7),mass4set(:,3),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),G0H8(1),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(7),mass4set(:,4),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),G0H8(2),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,3),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G0H8(3),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(7),mass4set(:,4),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),G0H8(4),8)
  call HG1shiftOLR(G1H8(21),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(7),mass4set(:,5),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G0H8(5),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(7),mass4set(:,5),  & 
G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),G0H8(6),8)
  call HG1shiftOLR(G1H8(31),8,8)
  call Hloop_VQ_A(ntryL,G1H8(3),wf4(:,3),G1H2(7),m3h4x2(:,1),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(7),23,nME,G2H2(17),n2h2(27))
  call Hloop_VA_Q(ntryL,G1H8(4),wf4(:,10),G1H2(8),m3h4x2(:,2),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(8),23,nME,G2H2(20),n2h2(28))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(9),m3h2x4(:,11),heltab2x8(:,:,13))
  call Hloop_VQ_A(ntryL,G1H8(2),wf4(:,9),G1H2(12),m3h4x2(:,3),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(12),27,nME,G2H2(21),n2h2(29))
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(1),m3h2x4(:,12),heltab2x8(:,:,15))
  call Hloop_VA_Q(ntryL,G1H8(1),wf4(:,4),G1H2(13),m3h4x2(:,4),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(13),27,nME,G2H2(24),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(29),ex3(:),G1H2(18),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(18),23,nME,G2H2(25),n2h2(31))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-8,nME,G2H4(7),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(26),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(32),ex3(:),G1H2(19),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(19),23,nME,G2H2(27),n2h2(32))
  call Hloop_QV_A(ntryL,G1H4(35),ex3(:),G1H2(23),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(23),23,nME,G2H2(28),n2h2(33))
  call Hloop_QV_A(ntryL,G0H4(1),ex3(:),G0H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(24),n2h2(34))
  call Hloop_QV_A(ntryL,G1H4(36),ex4(:),G1H2(29),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(29),27,nME,G2H2(29),n2h2(35))
call HGT_OLR(G1H4(1),1,1,4)
call HGT_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1),-4,nME,G2H4(3),n2h4(28))
  call Hloop_AV_Q(ntryL,G2H4(3),ex3(:),G2H2(30),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QV_A(ntryL,G1H4(5),ex4(:),G1H2(30),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(30),27,nME,G2H2(31),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(6),ex4(:),G1H2(34),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(34),27,nME,G2H2(32),n2h2(37))
  call Hloop_QV_A(ntryL,G0H4(2),ex4(:),G0H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G0H2(1),27,nME,G1H2(35),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H4(7),ex3(:),G1H2(40),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(40),23,nME,G2H2(33),n2h2(39))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-8,nME,G2H4(2),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(34),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AV_Q(ntryL,G1H4(12),ex3(:),G1H2(41),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(41),23,nME,G2H2(35),n2h2(40))
  call Hloop_AV_Q(ntryL,G1H4(13),ex3(:),G1H2(45),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(45),23,nME,G2H2(36),n2h2(41))
  call Hloop_AV_Q(ntryL,G0H4(3),ex3(:),G0H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(46),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(14),ex4(:),G1H2(51),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(51),27,nME,G2H2(37),n2h2(43))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(17),-4,nME,G2H4(4),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(4),ex3(:),G2H2(38),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AV_Q(ntryL,G1H4(4),ex4(:),G1H2(52),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(52),27,nME,G2H2(39),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(9),ex4(:),G1H2(56),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(56),27,nME,G2H2(40),n2h2(45))
  call Hloop_AV_Q(ntryL,G0H4(4),ex4(:),G0H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G0H2(1),27,nME,G1H2(57),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(10),ex4(:),G1H2(62),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(62),27,nMM,G2H2(41),n2h2(47))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(16),-4,nMM,G2H4(5),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(5),ex3(:),G2H2(42),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(22),ex4(:),G1H2(63),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMM,G2H2(43),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(27),ex4(:),G1H2(6),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(6),27,nMM,G2H2(44),n2h2(49))
  call Hloop_QV_A(ntryL,G0H4(5),ex4(:),G0H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMM,G1H2(17),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(28),ex4(:),G1H2(28),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMM,G2H2(45),n2h2(51))
call HGT_OLR(G1H4(33),1,1,4)
call HGT_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(33),-4,nMM,G2H4(6),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(6),ex3(:),G2H2(46),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(3),ex4(:),G1H2(39),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(39),27,nMM,G2H2(47),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H4(19),ex4(:),G1H2(50),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMM,G2H2(48),n2h2(53))
  call Hloop_AV_Q(ntryL,G0H4(6),ex4(:),G0H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMM,G1H2(61),n2h2(54))
  call Hloop_QV_A(ntryL,G1H4(25),ex4(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(49),n2h2(55))
call HGT_OLR(G1H4(15),1,1,4)
call HGT_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(15),-4,0,G2H4(8),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(8),ex3(:),G2H2(50),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(26),ex4(:),G1H2(2),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(2),27,0,G2H2(51),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(7),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(7),27,0,G2H2(52),n2h2(57))
  call Hloop_QV_A(ntryL,G0H4(7),ex4(:),G0H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(8),n2h2(58))
  call Hloop_AV_Q(ntryL,G1H4(24),ex4(:),G1H2(12),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(12),27,0,G2H2(53),n2h2(59))
call HGT_OLR(G1H4(37),1,1,4)
call HGT_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(37),-4,0,G2H4(10),n2h4(34))
  call Hloop_QV_A(ntryL,G2H4(10),ex3(:),G2H2(54),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AV_Q(ntryL,G1H4(39),ex4(:),G1H2(13),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(13),27,0,G2H2(55),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(40),ex4(:),G1H2(18),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(18),27,0,G2H2(56),n2h2(61))
  call Hloop_AV_Q(ntryL,G0H4(8),ex4(:),G0H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(19),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H4(41),ex3(:),G1H2(23),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(23),23,nMM,G2H2(57),n2h2(63))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(42),-8,nMM,G2H4(11),n2h4(35))
  call Hloop_QV_A(ntryL,G2H4(11),ex4(:),G2H2(58),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AV_Q(ntryL,G1H4(44),ex3(:),G1H2(29),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMM,G2H2(59),n2h2(64))
  call Hloop_AV_Q(ntryL,G1H4(45),ex3(:),G1H2(30),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMM,G2H2(60),n2h2(65))
  call Hloop_AV_Q(ntryL,G0H4(9),ex3(:),G0H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(34),n2h2(66))
  call Hloop_QV_A(ntryL,G1H4(46),ex3(:),G1H2(40),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(40),23,nMM,G2H2(61),n2h2(67))
call HGT_OLR(G1H4(47),1,1,4)
call HGT_invQ_OLR(G1H4(47),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(47),-8,nMM,G2H4(12),n2h4(36))
  call Hloop_AV_Q(ntryL,G2H4(12),ex4(:),G2H2(62),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QV_A(ntryL,G1H4(49),ex3(:),G1H2(41),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(41),23,nMM,G2H2(63),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(50),ex3(:),G1H2(45),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMM,G2H2(64),n2h2(69))
  call Hloop_QV_A(ntryL,G0H4(10),ex3(:),G0H2(1),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(51),n2h2(70))
  call Hloop_AV_Q(ntryL,G1H4(51),ex3(:),G1H2(52),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(52),23,0,G2H2(65),n2h2(71))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(52),-8,0,G2H4(7),n2h4(37))
  call Hloop_QV_A(ntryL,G2H4(7),ex4(:),G2H2(66),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AV_Q(ntryL,G1H4(54),ex3(:),G1H2(56),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(56),23,0,G2H2(67),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H4(55),ex3(:),G1H2(62),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(62),23,0,G2H2(68),n2h2(73))
  call Hloop_AV_Q(ntryL,G0H4(11),ex3(:),G0H2(1),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(63),n2h2(74))
  call Hloop_QV_A(ntryL,G1H4(56),ex3(:),G1H2(6),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(6),23,0,G2H2(69),n2h2(75))
call HGT_OLR(G1H4(57),1,1,4)
call HGT_invQ_OLR(G1H4(57),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(57),-8,0,G2H4(3),n2h4(38))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(70),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QV_A(ntryL,G1H4(59),ex3(:),G1H2(28),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(71),n2h2(76))
  call Hloop_QV_A(ntryL,G1H4(60),ex3(:),G1H2(39),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(39),23,0,G2H2(72),n2h2(77))
  call Hloop_QV_A(ntryL,G0H4(12),ex3(:),G0H2(1),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(50),n2h2(78))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,13),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(73),n2h2(79))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(6),-8,nME,G2H8(1),n2h8(11))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(2),m3h2x4(:,13),heltab2x8(:,:,18))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,13),G1H2(2),m3h4x2(:,6),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(2),23,nME,G2H2(74),n2h2(80))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,13),G1H2(7),m3h4x2(:,7),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(7),23,nME,G2H2(75),n2h2(81))
  call Hloop_QV_A(ntryL,G0H8(1),wf4(:,13),G0H2(1),m3h4x2(:,8),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(12),n2h2(82))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,13),G1H2(13),m3h4x2(:,9),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMM,G2H2(76),n2h2(83))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(11),-8,nMM,G2H8(2),n2h8(12))
  call Hloop_AV_Q(ntryL,G2H8(2),ex4(:),G2H4(4),m3h2x4(:,14),heltab2x8(:,:,23))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,13),G1H2(18),m3h4x2(:,10),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(18),23,nMM,G2H2(77),n2h2(84))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,13),G1H2(23),m3h4x2(:,11),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(23),23,nMM,G2H2(78),n2h2(85))
  call Hloop_QV_A(ntryL,G0H8(2),wf4(:,13),G0H2(1),m3h4x2(:,12),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(29),n2h2(86))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,13),G1H2(30),m3h4x2(:,13),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(30),23,nME,G2H2(79),n2h2(87))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-8,nME,G2H8(3),n2h8(13))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(5),m3h2x4(:,15),heltab2x8(:,:,28))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,13),G1H2(40),m3h4x2(:,14),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(40),23,nME,G2H2(80),n2h2(88))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,13),G1H2(41),m3h4x2(:,15),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(41),23,nME,G2H2(81),n2h2(89))
  call Hloop_AV_Q(ntryL,G0H8(3),wf4(:,13),G0H2(1),m3h4x2(:,16),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(45),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,13),G1H2(52),m3h4x2(:,17),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(52),23,nMM,G2H2(82),n2h2(91))
call HGT_OLR(G1H8(21),1,1,8)
call HGT_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(21),-8,nMM,G2H8(4),n2h8(14))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(6),m3h2x4(:,16),heltab2x8(:,:,33))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,13),G1H2(56),m3h4x2(:,18),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(56),23,nMM,G2H2(83),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,13),G1H2(62),m3h4x2(:,19),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(62),23,nMM,G2H2(84),n2h2(93))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,13),G0H2(1),m3h4x2(:,20),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(6),n2h2(94))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,13),G1H2(28),m3h4x2(:,21),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(85),n2h2(95))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-8,0,G2H8(5),n2h8(15))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(8),m3h2x4(:,17),heltab2x8(:,:,38))
  call Hloop_QV_A(ntryL,G1H8(28),wf4(:,13),G1H2(39),m3h4x2(:,22),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(39),23,0,G2H2(86),n2h2(96))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,13),G1H2(1),m3h4x2(:,23),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(87),n2h2(97))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,13),G0H2(1),m3h4x2(:,24),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(2),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,13),G1H2(7),m3h4x2(:,25),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(7),23,0,G2H2(88),n2h2(99))
call HGT_OLR(G1H8(31),1,1,8)
call HGT_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(31),-8,0,G2H8(6),n2h8(16))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(10),m3h2x4(:,18),heltab2x8(:,:,43))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,13),G1H2(13),m3h4x2(:,26),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(13),23,0,G2H2(89),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H8(34),wf4(:,13),G1H2(18),m3h4x2(:,27),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(18),23,0,G2H2(90),n2h2(101))
  call Hloop_AV_Q(ntryL,G0H8(6),wf4(:,13),G0H2(1),m3h4x2(:,28),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(23),n2h2(102))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(3),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(7),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(11),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(25)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(15),G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(19),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(3)])
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(23),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(65)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(26),mass4set(:,1),  & 
G1H2(30),G1H2(40),G1H2(41),G1H2(52),G1H2(56),2)
  call HG1shiftOLR(G1H2(40),2,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(7),mass4set(:,3),  & 
G1H2(62),G1H2(28),G1H2(39),G1H2(1),G1H2(7),2)
  call HG1shiftOLR(G1H2(28),8,2)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(27),mass4set(:,2),  & 
G1H2(13),G1H2(18),G1H2(5),G1H2(16),G1H2(27),2)
  call HG1shiftOLR(G1H2(18),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(11),mass4set(:,2),  & 
G1H2(25),G1H2(38),G1H2(49),G1H2(3),G1H2(60),2)
  call HG1shiftOLR(G1H2(38),8,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(28),mass4set(:,1),  & 
G1H2(4),G1H2(11),G1H2(14),G1H2(15),G1H2(21),2)
  call HG1shiftOLR(G1H2(11),1,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(7),mass4set(:,3),  & 
G1H2(26),G1H2(33),G1H2(36),G1H2(37),G1H2(43),2)
  call HG1shiftOLR(G1H2(33),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(13),mass4set(:,2),  & 
G1H2(47),G1H2(48),G1H2(54),G1H2(58),G1H2(59),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(18),mass4set(:,2),  & 
G1H2(65),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(67),4,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(29),mass4set(:,2),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),2)
  call HG1shiftOLR(G1H2(72),4,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(21),mass4set(:,2),  & 
G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(5),mass4set(:,2),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(24),mass4set(:,2),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(6),mass4set(:,2),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hloop_AV_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(1),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(5),n2h1(26))
  call Hloop_AV_Q(ntryL,G2H2(81),ex4(:),G2H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(1),n2h1(27))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(9),mass4set(:,6),  & 
G1H2(9),G1H2(10),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(10),mass4set(:,3),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(100),8,2)
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(9),n2h1(28))
  call Hloop_QV_A(ntryL,G2H2(28),ex4(:),G2H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(2),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(13),n2h1(30))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(14),mass4set(:,2),  & 
G1H2(20),G1H2(22),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(17),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(21),n2h1(32))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(3),n2h1(33))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(16),mass4set(:,6),  & 
G1H2(31),G1H2(32),G1H2(107),G1H2(108),G1H2(109),2)
  call HG1shiftOLR(G1H2(32),4,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(17),mass4set(:,3),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(111),4,2)
  call Hloop_QV_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(25),n2h1(34))
  call Hloop_QV_A(ntryL,G2H2(32),ex3(:),G2H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(4),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(26),n2h1(36))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(20),mass4set(:,6),  & 
G1H2(42),G1H2(44),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(10),mass4set(:,3),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(119),8,2)
  call Hloop_AV_Q(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(27),n2h1(37))
  call Hloop_AV_Q(ntryL,G2H2(36),ex4(:),G2H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(5),n2h1(38))
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(28),n2h1(39))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(23),mass4set(:,6),  & 
G1H2(53),G1H2(55),G1H2(123),G1H2(124),G1H2(125),2)
  call HG1shiftOLR(G1H2(55),4,2)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(17),mass4set(:,3),  & 
G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(127),4,2)
  call Hloop_AV_Q(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(29),n2h1(40))
  call Hloop_AV_Q(ntryL,G2H2(40),ex3(:),G2H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(6),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(30),n2h1(42))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(3),mass4set(:,1),  & 
G1H4(29),G1H4(30),G1H4(32),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(30),9,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(1),mass4set(:,1),  & 
G1H4(1),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(5),10,4)
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(31),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(35),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(32),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(33),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(34),n2h1(46))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(17),mass4set(:,4),  & 
G1H2(64),G1H2(66),G1H2(24),G1H2(35),G1H2(46),2)
  call HG1shiftOLR(G1H2(66),4,2)
  call Hloop_QV_A(ntryL,G2H2(44),ex3(:),G2H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(7),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(35),n2h1(48))
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(17),mass4set(:,4),  & 
G1H2(57),G1H2(17),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hloop_AV_Q(ntryL,G2H2(48),ex3(:),G2H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(8),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(36),n2h1(50))
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(17),mass4set(:,5),  & 
G1H2(61),G1H2(134),G1H2(135),G1H2(136),G1H2(137),2)
  call HG1shiftOLR(G1H2(134),4,2)
  call Hloop_QV_A(ntryL,G2H2(52),ex3(:),G2H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(9),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(52))
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(17),mass4set(:,5),  & 
G1H2(8),G1H2(138),G1H2(139),G1H2(140),G1H2(141),2)
  call HG1shiftOLR(G1H2(138),4,2)
  call Hloop_AV_Q(ntryL,G2H2(56),ex3(:),G2H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(10),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(54))
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(10),mass4set(:,4),  & 
G1H2(19),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(142),8,2)
  call Hloop_AV_Q(ntryL,G2H2(60),ex4(:),G2H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(11),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(39),n2h1(56))
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(10),mass4set(:,4),  & 
G1H2(34),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hloop_QV_A(ntryL,G2H2(64),ex4(:),G2H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(12),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(40),n2h1(58))
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(10),mass4set(:,5),  & 
G1H2(51),G1H2(150),G1H2(151),G1H2(152),G1H2(153),2)
  call HG1shiftOLR(G1H2(150),8,2)
  call Hloop_AV_Q(ntryL,G2H2(68),ex4(:),G2H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(60))
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(10),mass4set(:,5),  & 
G1H2(63),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hloop_QV_A(ntryL,G2H2(72),ex4(:),G2H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(14),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(43),n2h1(63))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(7),mass4set(:,4),  & 
G1H2(50),G1H2(12),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hloop_QV_A(ntryL,G2H2(78),ex4(:),G2H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(15),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(44),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(45),n2h1(66))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(7),mass4set(:,4),  & 
G1H2(29),G1H2(45),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(45),8,2)
  call Hloop_AV_Q(ntryL,G2H2(84),ex4(:),G2H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(16),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(46),n2h1(68))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(7),mass4set(:,5),  & 
G1H2(6),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hloop_QV_A(ntryL,G2H2(87),ex4(:),G2H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(70))
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(7),mass4set(:,5),  & 
G1H2(2),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hloop_AV_Q(ntryL,G2H2(90),ex4(:),G2H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(49),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(50),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(51),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(52),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(53),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(54),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(55),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(56),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(57),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(58),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(59),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(60),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(4),ex1(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(61),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(11),ex1(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(62),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(21),ex1(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(63),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(64),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(65),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(66),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(67),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(68),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(69),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(70),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(71),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(72),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(71),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(73),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(74),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(75),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(75),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(76),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(77),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(78),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(79),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(80),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(81),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(82),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(83),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(84),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(85),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(86),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(87),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(88),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(89),n2h1(113))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(90),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(91),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(92),n2h1(116))
  call Hloop_QV_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(93),n2h1(117))
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(94),n2h1(118))
  call Hloop_QV_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(95),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(96),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(31),ex3(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(97),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(98),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(99),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(100),n2h1(124))
  call Hloop_QV_A(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(101),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(102),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(103),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(104),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(105),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(106),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(107),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(108),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(109),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(110),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(125),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(111),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(112),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(113),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(114),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H4(29),wf4(:,9),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(115),n2h1(139))
  call Hloop_VQ_A(ntryL,G1H4(30),wf4(:,9),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(116),n2h1(140))
  call Hloop_VQ_A(ntryL,G1H4(36),wf4(:,9),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(117),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H4(1),wf4(:,4),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(118),n2h1(142))
  call Hloop_VA_Q(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(119),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H4(8),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(120),n2h1(144))
  call Hloop_QV_A(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(121),n2h1(145))
  call Hloop_QV_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(122),n2h1(146))
  call Hloop_QV_A(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(123),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(124),n2h1(148))
  call Hloop_AV_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(125),n2h1(149))
  call Hloop_AV_Q(ntryL,G1H2(133),ex3(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(126),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(128),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(130),n2h1(154))
  call Hloop_AV_Q(ntryL,G1H2(138),ex3(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(131),n2h1(155))
  call Hloop_AV_Q(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(156))
  call Hloop_AV_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(133),n2h1(157))
  call Hloop_AV_Q(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(134),n2h1(158))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(135),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(136),n2h1(160))
  call Hloop_QV_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(137),n2h1(161))
  call Hloop_QV_A(ntryL,G1H2(149),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(138),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(140),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(142),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(143),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(144),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(145),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(146),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(160),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(147),n2h1(171))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(148),n2h1(172))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(149),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(150),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(151),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(152),n2h1(176))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(154),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(155),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(180))
  call ol_merge_tensors(G2tensor(49),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(3),G1tensor(6)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(7),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(10),G1tensor(14)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(11),G1tensor(18)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(14),G1tensor(20),G1tensor(15)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(19),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(22),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(52),G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(91),G1tensor(28),G1tensor(10)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(100),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(31)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(32)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(35)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(37)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(39)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(41)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(43)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(44)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(47)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(121)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(127)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(133)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(139)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(145)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(151)])
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(26),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(2),G1tensor(6),G1tensor(8),G1tensor(24))
  call G_TensorShift(G1tensor(2),10)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(27),mass4set(:,2),  & 
G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(15))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,2),  & 
G1tensor(26),G1tensor(36),G1tensor(30),G1tensor(32),G1tensor(3))
  call G_TensorShift(G1tensor(36),12)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(28),mass4set(:,1),  & 
G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(9),G1tensor(28))
  call G_TensorShift(G1tensor(17),1)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(3),mass4set(:,1),  & 
G1tensor(10),G1tensor(11),G1tensor(16),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(11),9)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(13),mass4set(:,2),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(29),G1tensor(33))
  call G_TensorShift(G1tensor(23),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(29),mass4set(:,2),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(4),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),12)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(5),mass4set(:,2),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(6),mass4set(:,2),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(7),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(9),mass4set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(10),mass4set(:,3),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(11),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(14),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),8)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(16),mass4set(:,6),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(17),mass4set(:,3),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(18),mass4set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(20),mass4set(:,6),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(21),mass4set(:,2),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),8)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(23),mass4set(:,6),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),4)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(24),mass4set(:,2),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(10),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120),G0tensor(1))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(17),mass4set(:,3),  & 
G1tensor(116),G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G0tensor(2))
  call G_TensorShift(G1tensor(121),4)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(17),mass4set(:,4),  & 
G1tensor(116),G1tensor(125),G1tensor(126),G1tensor(127),G1tensor(128),G0tensor(3))
  call G_TensorShift(G1tensor(125),4)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(17),mass4set(:,5),  & 
G1tensor(116),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132),G0tensor(4))
  call G_TensorShift(G1tensor(129),4)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(10),mass4set(:,4),  & 
G1tensor(116),G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G0tensor(5))
  call G_TensorShift(G1tensor(133),8)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(10),mass4set(:,5),  & 
G1tensor(116),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140),G0tensor(6))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(7),mass4set(:,3),  & 
G1tensor(116),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G0tensor(7))
  call G_TensorShift(G1tensor(141),8)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(7),mass4set(:,4),  & 
G1tensor(116),G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G0tensor(8))
  call G_TensorShift(G1tensor(145),8)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(7),mass4set(:,5),  & 
G1tensor(116),G1tensor(149),G1tensor(150),G1tensor(151),G1tensor(152),G0tensor(9))
  call G_TensorShift(G1tensor(149),8)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(17),mass4set(:,4),  & 
G1tensor(116),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(153),4)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(17),mass4set(:,5),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(10),mass4set(:,4),  & 
G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166))
  call G_TensorShift(G1tensor(163),8)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(10),mass4set(:,5),  & 
G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170),G1tensor(171))
  call G_TensorShift(G1tensor(168),8)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(7),mass4set(:,4),  & 
G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175),G1tensor(176))
  call G_TensorShift(G1tensor(173),8)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(7),mass4set(:,5),  & 
G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180),G1tensor(181))
  call G_TensorShift(G1tensor(178),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(26),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(27),mass4set(:,2),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,2),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(28),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(3),mass4set(:,1),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(13),mass4set(:,2),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(29),mass4set(:,2),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(4),mass4set(:,2),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(5),mass4set(:,2),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(6),mass4set(:,2),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(7),mass4set(:,3),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(9),mass4set(:,6),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,3),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,2),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(14),mass4set(:,2),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(16),mass4set(:,6),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(17),mass4set(:,3),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(18),mass4set(:,2),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(20),mass4set(:,6),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(21),mass4set(:,2),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(23),mass4set(:,6),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(24),mass4set(:,2),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(17),mass4set(:,4),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(157),RedSet_4(17),mass4set(:,5),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(10),mass4set(:,4),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(167),RedSet_4(10),mass4set(:,5),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(172),RedSet_4(7),mass4set(:,4),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(177),RedSet_4(7),mass4set(:,5),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(1)])
  call ol_merge_tensors(T0sum(25),[G0tensor(2)])
  call ol_merge_tensors(T0sum(26),[G0tensor(3)])
  call ol_merge_tensors(T0sum(27),[G0tensor(4)])
  call ol_merge_tensors(T0sum(28),[G0tensor(5)])
  call ol_merge_tensors(T0sum(29),[G0tensor(6)])
  call ol_merge_tensors(T0sum(30),[G0tensor(7)])
  call ol_merge_tensors(T0sum(31),[G0tensor(8)])
  call ol_merge_tensors(T0sum(32),[G0tensor(9)])
  call ol_merge_tensors(T0sum(33),[G0tensor(125)])
  call ol_merge_tensors(T0sum(34),[G0tensor(130)])
  call ol_merge_tensors(T0sum(35),[G0tensor(135)])
  call ol_merge_tensors(T0sum(36),[G0tensor(140)])
  call ol_merge_tensors(T0sum(37),[G0tensor(145)])
  call ol_merge_tensors(T0sum(38),[G0tensor(150)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,5,10],[nME,0,nME],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(5),n2h16(39))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[18,5,8],[0,nME,nME],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,44))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,7,8],[nME,nME,nME],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(6),n2h16(40))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(13),n2h16(41))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,7,8],[nME,nME,nME],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(14),n2h16(42))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(21),n2h16(43))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(1),n2h16(45))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(46))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(47))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,2,13],[nME,0,nME],3,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(4),n2h16(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[21,2,8],[0,nME,nME],3,1,wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,22),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,6,9],[nME,0,nME],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(7),n2h16(49))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[17,6,8],[0,nME,nME],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,6),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,7,8],[nME,nME,nME],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(8),n2h16(50))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(9),n2h16(51))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,7,8],[nME,nME,nME],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(10),n2h16(52))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(11),n2h16(53))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(54))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(15),n2h16(55))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(16),n2h16(56))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(17),n2h16(57))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,14],[nME,0,nME],3,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(18),n2h16(58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[22,1,8],[0,nME,nME],3,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,27),G0H4(2),m3h8x4(:,2),heltab2x32(:,:,66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[18,4,9],[nME,nME,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,7),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H8(3),18,nME,G1H8(3),n2h8(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,4,11],[nME,nME,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(19),n2h16(59))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(20),n2h16(60))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,4,11],[nME,nME,nME],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(23),n2h16(61))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(24),n2h16(62))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,4,11],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(25),n2h16(63))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,4,11],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(26),n2h16(64))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,4,11],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(65))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,4,11],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(28),n2h16(66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,13],[nME,0,nME],3,1,wf8(:,34))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(29),n2h16(67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[25,2,4],[0,nME,nME],3,1,wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,28),G0H4(3),m3h8x4(:,3),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[17,4,10],[nME,nME,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,8),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H8(4),17,nME,G1H8(4),n2h8(18))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,4,11],[nME,nME,nME],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),16,nME,G1H16(30),n2h16(68))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(31),n2h16(69))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,4,11],[nME,nME,nME],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(32),n2h16(70))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(33),n2h16(71))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(34),n2h16(72))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(35),n2h16(73))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(36),n2h16(74))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(37),n2h16(75))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,1,14],[nME,0,nME],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(38),n2h16(76))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[26,1,4],[0,nME,nME],3,1,wf8(:,21))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,21),G0H4(4),m3h8x4(:,4),heltab2x32(:,:,88))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[19,4,8],[nME,nME,nME],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,42),G0H4(5),m3h8x4(:,5),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H4(5),19,nME,G1H4(12),n2h4(39))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,42),G0H4(6),m3h8x4(:,6),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMM,G1H4(13),n2h4(40))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[19,4,8],[nME,nME,nME],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,42),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(7),19,nME,G1H4(14),n2h4(41))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,42),G0H4(8),m3h8x4(:,8),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(8),19,nMM,G1H4(17),n2h4(42))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[19,4,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,42),G0H4(9),m3h8x4(:,9),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H4(9),19,0,G1H4(4),n2h4(43))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[19,4,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,42),G0H4(10),m3h8x4(:,10),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(10),19,0,G1H4(9),n2h4(44))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[19,4,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,42),G0H4(11),m3h8x4(:,11),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H4(11),19,0,G1H4(10),n2h4(45))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[19,4,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,42),G0H4(12),m3h8x4(:,12),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(12),19,0,G1H4(16),n2h4(46))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[21,2,8],[0,nME,nME],3,1,wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,37),G0H4(5),m3h8x4(:,13),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[25,2,4],[0,nME,nME],3,1,wf8(:,31))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,31),G0H4(6),m3h8x4(:,14),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[19,4,8],[nME,nME,nME],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(7),m3h8x4(:,15),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(7),19,nME,G1H4(22),n2h4(47))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(8),m3h8x4(:,16),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMM,G1H4(27),n2h4(48))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[19,4,8],[nME,nME,nME],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(9),m3h8x4(:,17),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(9),19,nME,G1H4(28),n2h4(49))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(10),m3h8x4(:,18),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(10),19,nMM,G1H4(33),n2h4(50))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(11),m3h8x4(:,19),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H4(11),19,0,G1H4(3),n2h4(51))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(12),m3h8x4(:,20),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(12),19,0,G1H4(19),n2h4(52))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(7),m3h8x4(:,21),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H4(7),19,0,G1H4(25),n2h4(53))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(8),m3h8x4(:,22),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(8),19,0,G1H4(15),n2h4(54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[22,1,8],[0,nME,nME],3,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,33),G0H4(9),m3h8x4(:,23),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[26,1,4],[0,nME,nME],3,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,24),G0H4(10),m3h8x4(:,24),heltab2x32(:,:,108))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(14),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(12),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(13),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(17),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(3),G1H4(10),G1H4(4),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(19),G1H4(16),G1H4(9),G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(5),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(10),[G0H4(4)])
  call Hloop_QV_A(ntryL,G1H4(28),ex3(:),G1H2(23),m3h2x2(:,93),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(23),23,nME,G2H2(3),n2h2(103))
  call Hloop_QV_A(ntryL,G1H4(2),ex4(:),G1H2(30),m3h2x2(:,94),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(30),27,nME,G2H2(7),n2h2(104))
  call Hloop_AV_Q(ntryL,G1H4(22),ex3(:),G1H2(40),m3h2x2(:,95),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(40),23,nME,G2H2(11),n2h2(105))
  call Hloop_AV_Q(ntryL,G1H4(18),ex4(:),G1H2(56),m3h2x2(:,96),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(56),27,nME,G2H2(8),n2h2(106))
  call Hloop_QV_A(ntryL,G1H4(21),ex4(:),G1H2(62),m3h2x2(:,97),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(62),27,nMM,G2H2(15),n2h2(107))
  call Hloop_AV_Q(ntryL,G1H4(34),ex4(:),G1H2(28),m3h2x2(:,98),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMM,G2H2(19),n2h2(108))
  call Hloop_QV_A(ntryL,G1H4(20),ex4(:),G1H2(7),m3h2x2(:,99),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(7),27,0,G2H2(1),n2h2(109))
  call Hloop_AV_Q(ntryL,G1H4(38),ex4(:),G1H2(13),m3h2x2(:,100),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(13),27,0,G2H2(23),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H4(27),ex3(:),G1H2(18),m3h2x2(:,101),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(18),23,nMM,G2H2(2),n2h2(111))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(27),m3h2x2(:,102),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMM,G2H2(79),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H4(25),ex3(:),G1H2(25),m3h2x2(:,103),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(25),23,0,G2H2(6),n2h2(113))
  call Hloop_QV_A(ntryL,G1H4(15),ex3(:),G1H2(38),m3h2x2(:,104),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(38),23,0,G2H2(17),n2h2(114))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,13),G1H2(60),m3h4x2(:,29),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(60),23,nME,G2H2(10),n2h2(115))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,13),G1H2(4),m3h4x2(:,30),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMM,G2H2(73),n2h2(116))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,13),G1H2(11),m3h4x2(:,31),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(11),23,nME,G2H2(14),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,13),G1H2(21),m3h4x2(:,32),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(21),23,nMM,G2H2(21),n2h2(118))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,13),G1H2(26),m3h4x2(:,33),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(18),n2h2(119))
  call Hloop_AV_Q(ntryL,G1H8(32),wf4(:,13),G1H2(33),m3h4x2(:,34),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(33),23,0,G2H2(20),n2h2(120))
  call Hloop_AQ_V(ntryL,G1H16(5),wf4(:,3),G1H4(26),m3h4x4(:,15),heltab2x16(:,:,33))
  call Hloop_VQ_A(ntryL,G0H8(1),wf4(:,3),G0H2(1),m3h4x2(:,35),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(43),n2h2(121))
  call Hloop_AV_Q(ntryL,G1H16(6),wf8(:,38),G1H2(47),m3h8x2(:,1),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(47),23,nME,G2H2(22),n2h2(122))
  call Hloop_AV_Q(ntryL,G1H16(13),wf8(:,38),G1H2(48),m3h8x2(:,2),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(48),23,nMM,G2H2(24),n2h2(123))
  call Hloop_QV_A(ntryL,G1H16(14),wf8(:,38),G1H2(59),m3h8x2(:,3),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(59),23,nME,G2H2(4),n2h2(124))
  call Hloop_QV_A(ntryL,G1H16(21),wf8(:,38),G1H2(65),m3h8x2(:,4),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(65),23,nMM,G2H2(81),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H16(2),wf8(:,38),G1H2(67),m3h8x2(:,5),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(67),23,0,G2H2(5),n2h2(126))
  call Hloop_QV_A(ntryL,G1H16(3),wf8(:,38),G1H2(70),m3h8x2(:,6),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(70),23,0,G2H2(25),n2h2(127))
  call Hloop_QA_V(ntryL,G1H16(4),ex2(:),G1H8(2),m3h2x8(:,19),heltab2x16(:,:,40))
  call Hloop_VA_Q(ntryL,G0H4(5),ex2(:),G0H2(1),m3h2x2(:,105),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(71),n2h2(128))
  call Hloop_QA_V(ntryL,G1H16(7),wf4(:,10),G1H4(23),m3h4x4(:,16),heltab2x16(:,:,41))
  call Hloop_VA_Q(ntryL,G0H8(2),wf4(:,10),G0H2(1),m3h4x2(:,36),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(72),n2h2(129))
  call Hloop_AV_Q(ntryL,G1H16(8),wf8(:,39),G1H2(75),m3h8x2(:,7),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(75),23,nME,G2H2(28),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H16(9),wf8(:,39),G1H2(76),m3h8x2(:,8),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(76),23,nMM,G2H2(9),n2h2(131))
  call Hloop_QV_A(ntryL,G1H16(10),wf8(:,39),G1H2(77),m3h8x2(:,9),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(77),23,nME,G2H2(75),n2h2(132))
  call Hloop_QV_A(ntryL,G1H16(11),wf8(:,39),G1H2(80),m3h8x2(:,10),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(80),23,nMM,G2H2(12),n2h2(133))
  call Hloop_AV_Q(ntryL,G1H16(16),wf8(:,39),G1H2(81),m3h8x2(:,11),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(81),23,0,G2H2(29),n2h2(134))
  call Hloop_QV_A(ntryL,G1H16(17),wf8(:,39),G1H2(82),m3h8x2(:,12),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(82),23,0,G2H2(32),n2h2(135))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,48))
  call Hloop_VQ_A(ntryL,G0H4(9),ex1(:),G0H2(1),m3h2x2(:,106),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(85),n2h2(136))
  call Hloop_AV_Q(ntryL,G1H8(3),ex3(:),G1H4(24),m3h2x4(:,19),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(24),22,nME,G2H4(11),n2h4(55))
  call Hloop_QV_A(ntryL,G1H16(19),ex3(:),G1H8(5),m3h2x8(:,21),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(5),20,nME,G2H8(7),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(20),ex3(:),G1H8(6),m3h2x8(:,22),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMM,G2H8(8),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(23),ex3(:),G1H8(8),m3h2x8(:,23),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(8),20,nME,G2H8(1),n2h8(21))
  call Hloop_AV_Q(ntryL,G1H16(24),ex3(:),G1H8(9),m3h2x8(:,24),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(9),20,nMM,G2H8(2),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(27),ex3(:),G1H8(10),m3h2x8(:,25),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(10),20,0,G2H8(3),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(28),ex3(:),G1H8(11),m3h2x8(:,26),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(11),20,0,G2H8(4),n2h8(24))
  call Hloop_QA_V(ntryL,G1H16(29),ex2(:),G1H8(13),m3h2x8(:,27),heltab2x16(:,:,55))
  call Hloop_VA_Q(ntryL,G0H4(6),ex2(:),G0H2(1),m3h2x2(:,107),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G0H2(1),27,nME,G1H2(86),n2h2(137))
  call Hloop_QV_A(ntryL,G1H8(4),ex3(:),G1H4(37),m3h2x4(:,20),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(37),21,nME,G2H4(12),n2h4(56))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(14),m3h2x8(:,28),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(14),20,nME,G2H8(5),n2h8(25))
  call Hloop_QV_A(ntryL,G1H16(31),ex3(:),G1H8(15),m3h2x8(:,29),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMM,G2H8(6),n2h8(26))
  call Hloop_AV_Q(ntryL,G1H16(32),ex3(:),G1H8(16),m3h2x8(:,30),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(16),20,nME,G2H8(9),n2h8(27))
  call Hloop_AV_Q(ntryL,G1H16(33),ex3(:),G1H8(18),m3h2x8(:,31),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(18),20,nMM,G2H8(10),n2h8(28))
  call Hloop_QV_A(ntryL,G1H16(36),ex3(:),G1H8(19),m3h2x8(:,32),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(19),20,0,G2H8(11),n2h8(29))
  call Hloop_AV_Q(ntryL,G1H16(37),ex3(:),G1H8(20),m3h2x8(:,33),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(20),20,0,G2H8(12),n2h8(30))
  call Hloop_AQ_V(ntryL,G1H16(38),ex1(:),G1H8(21),m3h2x8(:,34),heltab2x16(:,:,62))
  call Hloop_VQ_A(ntryL,G0H4(10),ex1(:),G0H2(1),m3h2x2(:,108),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G0H2(1),27,nME,G1H2(87),n2h2(138))
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(4),G2H2(74),G2H2(27),G1H2(105),G1H2(102) &
    ,G1H2(37),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(58),G1H2(36)])
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(113),G1H2(69)])
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(22),G2H2(80),G2H2(35),G1H2(121),G1H2(94) &
    ,G1H2(79),G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(84),G1H2(39)])
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(129),G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G1H2(158)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(161)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(165)])
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(169)])
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(24),G2H2(83),G2H2(59),G1H2(162),G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(81),G2H2(77),G2H2(63),G1H2(159),G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(5),G2H2(89),G2H2(67),G1H2(170),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(25),G2H2(86),G2H2(71),G1H2(166),G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(97),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(104),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(116),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(93),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(101),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(112),G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(120),G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(128),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(155)])
  call Hloop_QV_A(ntryL,G2H2(26),ex3(:),G2H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(19),n2h1(181))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(20),n2h1(182))
  call Hloop_QV_A(ntryL,G2H2(30),ex4(:),G2H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(21),n2h1(183))
  call Hloop_QV_A(ntryL,G2H2(31),ex3(:),G2H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(22),n2h1(184))
  call Hloop_AV_Q(ntryL,G2H2(34),ex3(:),G2H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(23),n2h1(185))
  call Hloop_AV_Q(ntryL,G2H2(28),ex4(:),G2H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(24),n2h1(186))
  call Hloop_AV_Q(ntryL,G2H2(38),ex4(:),G2H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(25),n2h1(187))
  call Hloop_AV_Q(ntryL,G2H2(39),ex3(:),G2H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(26),n2h1(188))
  call Hloop_QV_A(ntryL,G2H2(42),ex4(:),G2H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(27),n2h1(189))
  call Hloop_QV_A(ntryL,G2H2(43),ex3(:),G2H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(28),n2h1(190))
  call Hloop_AV_Q(ntryL,G2H2(46),ex4(:),G2H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(29),n2h1(191))
  call Hloop_AV_Q(ntryL,G2H2(47),ex3(:),G2H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(30),n2h1(192))
  call Hloop_QV_A(ntryL,G2H2(50),ex4(:),G2H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(31),n2h1(193))
  call Hloop_QV_A(ntryL,G2H2(51),ex3(:),G2H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(32),n2h1(194))
  call Hloop_AV_Q(ntryL,G2H2(54),ex4(:),G2H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(33),n2h1(195))
  call Hloop_AV_Q(ntryL,G2H2(55),ex3(:),G2H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(34),n2h1(196))
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(58),ex3(:),G2H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(35),n2h1(197))
  call Hloop_AV_Q(ntryL,G2H2(9),ex4(:),G2H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(36),n2h1(198))
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(62),ex3(:),G2H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(37),n2h1(199))
  call Hloop_QV_A(ntryL,G2H2(12),ex4(:),G2H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(38),n2h1(200))
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(66),ex3(:),G2H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(39),n2h1(201))
  call Hloop_AV_Q(ntryL,G2H2(29),ex4(:),G2H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(40),n2h1(202))
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(70),ex3(:),G2H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(41),n2h1(203))
  call Hloop_QV_A(ntryL,G2H2(32),ex4(:),G2H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(42),n2h1(204))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,13),G2H1(1),m3h4x1(:,7),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(43),n2h1(205))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,13),G2H1(1),m3h4x1(:,8),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(44),n2h1(206))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,13),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(45),n2h1(207))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,13),G2H1(1),m3h4x1(:,10),heltab2x4(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(46),n2h1(208))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(8),wf4(:,13),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(47),n2h1(209))
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(10),wf4(:,13),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(48),n2h1(210))
  call Hloop_VA_Q(ntryL,G1H2(41),ex2(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(2),n2h1(211))
  call Hloop_VA_Q(ntryL,G1H2(52),ex2(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(3),n2h1(212))
  call Hloop_QV_A(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(6),n2h1(213))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(7),n2h1(214))
  call Hloop_VQ_A(ntryL,G1H2(14),ex1(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(10),n2h1(215))
  call Hloop_VQ_A(ntryL,G1H2(15),ex1(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(11),n2h1(216))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(14),n2h1(217))
  call Hloop_QV_A(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(18),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(19),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(22),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(52),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(91),n2h1(222))
  call Hloop_QV_A(ntryL,G2H2(3),ex4(:),G2H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(49),n2h1(223))
  call Hloop_QV_A(ntryL,G2H2(7),ex3(:),G2H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(50),n2h1(224))
  call Hloop_AV_Q(ntryL,G2H2(11),ex4(:),G2H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(51),n2h1(225))
  call Hloop_AV_Q(ntryL,G2H2(8),ex3(:),G2H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(52),n2h1(226))
  call Hloop_VQ_A(ntryL,G1H4(32),wf4(:,9),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(100),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H4(23),wf4(:,9),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(31),n2h1(228))
  call Hloop_VA_Q(ntryL,G1H4(6),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(32),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H4(26),wf4(:,4),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(35),n2h1(230))
  call Hloop_QV_A(ntryL,G2H2(15),ex3(:),G2H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(53),n2h1(231))
  call Hloop_AV_Q(ntryL,G2H2(19),ex3(:),G2H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(54),n2h1(232))
  call Hloop_QV_A(ntryL,G2H2(1),ex3(:),G2H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(55),n2h1(233))
  call Hloop_AV_Q(ntryL,G2H2(23),ex3(:),G2H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(56),n2h1(234))
  call Hloop_AV_Q(ntryL,G2H2(2),ex4(:),G2H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(57),n2h1(235))
  call Hloop_QV_A(ntryL,G2H2(79),ex4(:),G2H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(58),n2h1(236))
  call Hloop_AV_Q(ntryL,G2H2(6),ex4(:),G2H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(59),n2h1(237))
  call Hloop_QV_A(ntryL,G2H2(17),ex4(:),G2H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(60),n2h1(238))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,25),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(37),n2h1(239))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,30),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(39),n2h1(240))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(11),wf4(:,9),G2tensor(41),m3h4x1(:,17),heltab2x4(:,:,125))
  call Hloop_QV_A(ntryL,G2H8(7),wf8(:,40),G2H1(1),m3h8x1(:,3),heltab2x8(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(61),n2h1(241))
  call Hloop_QV_A(ntryL,G2H8(8),wf8(:,40),G2H1(1),m3h8x1(:,4),heltab2x8(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(62),n2h1(242))
  call Hloop_AV_Q(ntryL,G2H8(1),wf8(:,40),G2H1(1),m3h8x1(:,5),heltab2x8(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(63),n2h1(243))
  call Hloop_AV_Q(ntryL,G2H8(2),wf8(:,40),G2H1(1),m3h8x1(:,6),heltab2x8(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(64),n2h1(244))
  call Hloop_QV_A(ntryL,G2H8(3),wf8(:,40),G2H1(1),m3h8x1(:,7),heltab2x8(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(65),n2h1(245))
  call Hloop_AV_Q(ntryL,G2H8(4),wf8(:,40),G2H1(1),m3h8x1(:,8),heltab2x8(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(66),n2h1(246))
  call Hloop_VQ_A(ntryL,G1H8(13),wf8(:,34),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(43),n2h1(247))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(12),wf4(:,4),G2tensor(44),m3h4x1(:,18),heltab2x4(:,:,126))
  call Hloop_QV_A(ntryL,G2H8(5),wf8(:,41),G2H1(1),m3h8x1(:,10),heltab2x8(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(67),n2h1(248))
  call Hloop_QV_A(ntryL,G2H8(6),wf8(:,41),G2H1(1),m3h8x1(:,11),heltab2x8(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(68),n2h1(249))
  call Hloop_AV_Q(ntryL,G2H8(9),wf8(:,41),G2H1(1),m3h8x1(:,12),heltab2x8(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(69),n2h1(250))
  call Hloop_AV_Q(ntryL,G2H8(10),wf8(:,41),G2H1(1),m3h8x1(:,13),heltab2x8(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(70),n2h1(251))
  call Hloop_QV_A(ntryL,G2H8(11),wf8(:,41),G2H1(1),m3h8x1(:,14),heltab2x8(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(71),n2h1(252))
  call Hloop_AV_Q(ntryL,G2H8(12),wf8(:,41),G2H1(1),m3h8x1(:,15),heltab2x8(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(72),n2h1(253))
  call Hloop_VA_Q(ntryL,G1H8(21),wf8(:,36),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(47),n2h1(254))
  call ol_merge_tensors(G2tensor(119),[G2tensor(50),G2tensor(4),G1tensor(2),G1tensor(7),G0tensor(16),G0tensor(11)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(68),G2tensor(56),G2tensor(16),G2tensor(8),G1tensor(23),G1tensor(5),G1tensor(36) &
    ,G1tensor(14),G0tensor(41),G0tensor(32),G0tensor(26),G0tensor(21)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(62),G2tensor(12),G1tensor(11),G1tensor(17),G0tensor(36),G0tensor(31)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(80),G2tensor(74),G2tensor(24),G2tensor(20),G1tensor(47),G1tensor(42),G1tensor(37) &
    ,G1tensor(13),G0tensor(56),G0tensor(51),G0tensor(46),G0tensor(12)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(83),G2tensor(81),G2tensor(1),G1tensor(112),G1tensor(50),G1tensor(6),G0tensor(121) &
    ,G0tensor(59),G0tensor(17)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(87),G2tensor(5),G1tensor(55),G1tensor(8),G0tensor(64),G0tensor(18)])
  call ol_merge_tensors(G3tensor(69),[G3tensor(67),G3tensor(63),G3tensor(61),G3tensor(3),G3tensor(1),G2tensor(120),G2tensor(117) &
    ,G2tensor(66),G2tensor(54),G1tensor(60),G1tensor(34),G1tensor(24),G0tensor(69),G0tensor(39),G0tensor(19)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(90),G2tensor(25),G2tensor(9),G1tensor(85),G1tensor(65),G1tensor(30),G0tensor(94) &
    ,G0tensor(74),G0tensor(27)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(5),G3tensor(4),G3tensor(2),G2tensor(114),G2tensor(108),G2tensor(102),G2tensor(93) &
    ,G1tensor(90),G1tensor(70),G1tensor(44),G1tensor(32),G0tensor(99),G0tensor(79),G0tensor(53),G0tensor(28)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(37),G2tensor(72),G2tensor(60),G2tensor(26),G2tensor(13),G1tensor(95),G1tensor(75) &
    ,G1tensor(3),G0tensor(104),G0tensor(84),G0tensor(29)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(71),G2tensor(69),G2tensor(17),G1tensor(92),G1tensor(33),G1tensor(16),G0tensor(101) &
    ,G0tensor(44),G0tensor(37)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(96),G2tensor(21),G1tensor(80),G1tensor(21),G0tensor(89),G0tensor(38)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(105),G2tensor(29),G2tensor(27),G1tensor(110),G1tensor(100),G1tensor(43) &
    ,G0tensor(119),G0tensor(109),G0tensor(52)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(39),G2tensor(84),G2tensor(78),G2tensor(30),G2tensor(28),G1tensor(115),G1tensor(105) &
    ,G1tensor(45),G0tensor(124),G0tensor(114),G0tensor(54)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(8),G3tensor(7),G2tensor(138),G2tensor(135),G2tensor(126),G2tensor(123) &
    ,G1tensor(166),G1tensor(156),G0tensor(139),G0tensor(129)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13),G3tensor(10),G3tensor(9),G2tensor(144),G2tensor(141),G2tensor(132) &
    ,G2tensor(129),G1tensor(171),G1tensor(161),G0tensor(144),G0tensor(134)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(68),G3tensor(64),G3tensor(62),G3tensor(16),G3tensor(15),G2tensor(150),G2tensor(147) &
    ,G1tensor(176),G0tensor(149)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(71),G3tensor(66),G3tensor(65),G3tensor(18),G3tensor(17),G2tensor(156),G2tensor(153) &
    ,G1tensor(181),G0tensor(154)])
  call ol_merge_tensors(G3tensor(45),[G3tensor(43),G2tensor(65),G2tensor(63),G2tensor(53),G2tensor(51),G1tensor(57),G1tensor(28) &
    ,G1tensor(25),G0tensor(66),G0tensor(34),G0tensor(14)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(57),G1tensor(72),G1tensor(15),G0tensor(81),G0tensor(24)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(75),G1tensor(102),G1tensor(40),G0tensor(111),G0tensor(49)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(86),G1tensor(52),G1tensor(19),G0tensor(61),G0tensor(13)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(89),G1tensor(62),G1tensor(18),G0tensor(71),G0tensor(22)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(19),G2tensor(107),G2tensor(92),G1tensor(67),G1tensor(39),G1tensor(20),G0tensor(76) &
    ,G0tensor(48),G0tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(95),G1tensor(77),G1tensor(9),G0tensor(86),G0tensor(33)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(98),G1tensor(82),G1tensor(78),G1tensor(27),G0tensor(91),G0tensor(87) &
    ,G0tensor(42)])
  call ol_merge_tensors(G3tensor(25),[G3tensor(21),G2tensor(113),G2tensor(101),G1tensor(87),G1tensor(58),G1tensor(49),G1tensor(29) &
    ,G0tensor(96),G0tensor(67),G0tensor(58),G0tensor(43)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(104),G1tensor(97),G1tensor(38),G0tensor(106),G0tensor(47)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(110),G1tensor(107),G1tensor(53),G1tensor(48),G0tensor(116),G0tensor(62) &
    ,G0tensor(57)])
  call ol_merge_tensors(G3tensor(29),[G3tensor(27),G2tensor(125),G2tensor(122),G1tensor(174),G1tensor(153),G0tensor(147) &
    ,G0tensor(126)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(31),G2tensor(131),G2tensor(128),G1tensor(179),G1tensor(158),G0tensor(152) &
    ,G0tensor(131)])
  call ol_merge_tensors(G3tensor(37),[G3tensor(35),G2tensor(137),G2tensor(134),G1tensor(163),G0tensor(136)])
  call ol_merge_tensors(G3tensor(41),[G3tensor(39),G2tensor(143),G2tensor(140),G1tensor(168),G0tensor(141)])
  call ol_merge_tensors(G3tensor(46),[G3tensor(44),G2tensor(149),G2tensor(146),G1tensor(173),G0tensor(146)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(47),G2tensor(155),G2tensor(152),G1tensor(178),G0tensor(151)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(20),G1tensor(104),G1tensor(79),G1tensor(74),G1tensor(69),G1tensor(59),G1tensor(54) &
    ,G0tensor(113),G0tensor(88),G0tensor(83),G0tensor(78),G0tensor(68),G0tensor(63)])
  call ol_merge_tensors(G3tensor(51),[G3tensor(49),G1tensor(98),G1tensor(68),G1tensor(63),G0tensor(107),G0tensor(77) &
    ,G0tensor(72)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(73),G1tensor(64),G0tensor(82),G0tensor(73)])
  call ol_merge_tensors(G3tensor(52),[G3tensor(50),G1tensor(108),G1tensor(88),G1tensor(83),G0tensor(117),G0tensor(97) &
    ,G0tensor(92)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(93),G1tensor(84),G0tensor(102),G0tensor(93)])
  call ol_merge_tensors(G3tensor(26),[G3tensor(22),G1tensor(114),G1tensor(94),G1tensor(89),G0tensor(123),G0tensor(103) &
    ,G0tensor(98)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(103),G1tensor(99),G0tensor(112),G0tensor(108)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(113),G1tensor(109),G0tensor(122),G0tensor(118)])
  call ol_merge_tensors(G1tensor(143),[G1tensor(119)])
  call ol_merge_tensors(G1tensor(124),[G1tensor(120)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(121)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(125)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(128)])
  call ol_merge_tensors(G1tensor(150),[G1tensor(129)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(132)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(135)])
  call ol_merge_tensors(G1tensor(151),[G1tensor(139)])
  call ol_merge_tensors(G3tensor(54),[G3tensor(53),G1tensor(154),G0tensor(127)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(28),G1tensor(155),G0tensor(128)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G1tensor(159),G0tensor(132)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(32),G1tensor(160),G0tensor(133)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G1tensor(164),G0tensor(137)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(36),G1tensor(175),G1tensor(165),G0tensor(148),G0tensor(138)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G1tensor(169),G0tensor(142)])
  call ol_merge_tensors(G3tensor(42),[G3tensor(40),G1tensor(180),G1tensor(170),G0tensor(153),G0tensor(143)])
  call TI_triangle_red(G2tensor(119),RedBasis(45),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1,[nME], &
    G0tensor(30))
  call TI_triangle_red(G2tensor(10),RedBasis(42),mass3set(:,2),G0tensor(35),G0tensor(40),G0tensor(45),G0tensor(50),M2L1R1,[nME], &
    G0tensor(55))
  call TI_triangle_red(G2tensor(116),RedBasis(46),mass3set(:,1),G0tensor(60),G0tensor(65),G0tensor(70),G0tensor(75),M2L1R1,[nME], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(2),RedBasis(37),mass3set(:,2),G0tensor(85),G0tensor(90),G0tensor(95),G0tensor(100),M2L1R1,[nME], &
    G0tensor(105))
  call TI_triangle_red(G2tensor(32),RedBasis(4),mass3set(:,2),G0tensor(110),G0tensor(115),G0tensor(120),G0tensor(1),M2L1R1,[nME], &
    G0tensor(2))
  call TI_triangle_red(G2tensor(35),RedBasis(2),mass3set(:,2),G0tensor(3),G0tensor(4),G0tensor(5),G0tensor(6),M2L1R1,[nME], &
    G0tensor(7))
  call TI_triangle_red(G3tensor(69),RedBasis(1),mass3set(:,3),G0tensor(8),G0tensor(9),G0tensor(125),G0tensor(130),M2L1R1,[nME], &
    G0tensor(135))
  call TI_triangle_red(G2tensor(99),RedBasis(9),mass3set(:,4),G0tensor(140),G0tensor(145),G0tensor(150),G0tensor(16),M2L1R1,[nME], &
    G0tensor(11))
  call TI_triangle_red(G3tensor(6),RedBasis(8),mass3set(:,3),G0tensor(41),G0tensor(32),G0tensor(26),G0tensor(21),M2L1R1,[nME], &
    G0tensor(36))
  call TI_triangle_red(G2tensor(43),RedBasis(7),mass3set(:,2),G0tensor(31),G0tensor(56),G0tensor(51),G0tensor(46),M2L1R1,[nME], &
    G0tensor(12))
  call TI_triangle_red(G2tensor(100),RedBasis(13),mass3set(:,2),G0tensor(121),G0tensor(59),G0tensor(17),G0tensor(64),M2L1R1,[nME], &
    G0tensor(18))
  call TI_triangle_red(G2tensor(31),RedBasis(12),mass3set(:,2),G0tensor(69),G0tensor(39),G0tensor(19),G0tensor(94),M2L1R1,[nME], &
    G0tensor(74))
  call TI_triangle_red(G2tensor(111),RedBasis(19),mass3set(:,4),G0tensor(27),G0tensor(99),G0tensor(79),G0tensor(53),M2L1R1,[nME], &
    G0tensor(28))
  call TI_triangle_red(G2tensor(47),RedBasis(18),mass3set(:,2),G0tensor(104),G0tensor(84),G0tensor(29),G0tensor(101),M2L1R1,[nME], &
    G0tensor(44))
  call TI_triangle_red(G3tensor(12),RedBasis(8),mass3set(:,5),G0tensor(37),G0tensor(89),G0tensor(38),G0tensor(119),M2L1R1,[nMM], &
    G0tensor(109))
  call TI_triangle_red(G3tensor(14),RedBasis(8),mass3set(:,6),G0tensor(52),G0tensor(124),G0tensor(114),G0tensor(54),M2L1R1)
  call TI_triangle_red(G3tensor(70),RedBasis(1),mass3set(:,5),G0tensor(139),G0tensor(129),G0tensor(144), &
    G0tensor(134),M2L1R1,[nMM],G0tensor(149))
  call TI_triangle_red(G3tensor(72),RedBasis(1),mass3set(:,6),G0tensor(154),G0tensor(66),G0tensor(34),G0tensor(14),M2L1R1)
  call TI_triangle_red(G3tensor(45),RedBasis(35),mass3set(:,3),G0tensor(81),G0tensor(24),G0tensor(111),G0tensor(49),M2L1R1,[nME], &
    G0tensor(61))
  call TI_triangle_red(G2tensor(59),RedBasis(38),mass3set(:,2),G0tensor(13),G0tensor(71),G0tensor(22),G0tensor(76),M2L1R1,[nME], &
    G0tensor(48))
  call TI_triangle_red(G2tensor(77),RedBasis(43),mass3set(:,2),G0tensor(23),G0tensor(86),G0tensor(33),G0tensor(91),M2L1R1,[nME], &
    G0tensor(87))
  call TI_triangle_red(G2tensor(3),RedBasis(36),mass3set(:,2),G0tensor(42),G0tensor(96),G0tensor(67),G0tensor(58),M2L1R1,[nME], &
    G0tensor(43))
  call TI_triangle_red(G2tensor(6),RedBasis(40),mass3set(:,4),G0tensor(106),G0tensor(47),G0tensor(116),G0tensor(62),M2L1R1,[nME], &
    G0tensor(57))
  call TI_triangle_red(G3tensor(23),RedBasis(39),mass3set(:,3),G0tensor(147),G0tensor(126),G0tensor(152), &
    G0tensor(131),M2L1R1,[nME],G0tensor(136))
  call TI_triangle_red(G2tensor(11),RedBasis(41),mass3set(:,2),G0tensor(141),G0tensor(146),G0tensor(151), &
    G0tensor(113),M2L1R1,[nME],G0tensor(88))
  call TI_triangle_red(G2tensor(14),RedBasis(14),mass3set(:,4),G0tensor(83),G0tensor(78),G0tensor(68),G0tensor(63),M2L1R1,[nME], &
    G0tensor(107))
  call TI_triangle_red(G3tensor(25),RedBasis(5),mass3set(:,3),G0tensor(77),G0tensor(72),G0tensor(82),G0tensor(73),M2L1R1,[nME], &
    G0tensor(117))
  call TI_triangle_red(G2tensor(19),RedBasis(44),mass3set(:,4),G0tensor(97),G0tensor(92),G0tensor(102),G0tensor(93),M2L1R1,[nME], &
    G0tensor(123))
  call TI_triangle_red(G2tensor(52),RedBasis(6),mass3set(:,4),G0tensor(103),G0tensor(98),G0tensor(112),G0tensor(108),M2L1R1,[nME], &
    G0tensor(122))
  call TI_triangle_red(G3tensor(29),RedBasis(5),mass3set(:,5),G0tensor(118),G0tensor(127),G0tensor(128), &
    G0tensor(132),M2L1R1,[nMM],G0tensor(133))
  call TI_triangle_red(G3tensor(33),RedBasis(5),mass3set(:,6),G0tensor(137),G0tensor(148),G0tensor(138),G0tensor(142),M2L1R1)
  call TI_triangle_red(G3tensor(37),RedBasis(39),mass3set(:,5),G0tensor(153),G0tensor(143),G0tensor(155), &
    G0tensor(156),M2L1R1,[nMM],G0tensor(157))
  call TI_triangle_red(G3tensor(41),RedBasis(39),mass3set(:,6),G0tensor(158),G0tensor(159),G0tensor(160),G0tensor(161),M2L1R1)
  call TI_triangle_red(G3tensor(46),RedBasis(35),mass3set(:,5),G0tensor(162),G0tensor(163),G0tensor(164), &
    G0tensor(165),M2L1R1,[nMM],G0tensor(166))
  call TI_triangle_red(G3tensor(48),RedBasis(35),mass3set(:,6),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170),M2L1R1)
  call TI_triangle_red(G3tensor(24),RedBasis(3),mass3set(:,3),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nME],G0tensor(175))
  call TI_triangle_red(G3tensor(51),RedBasis(11),mass3set(:,3),G0tensor(176),G0tensor(177),G0tensor(178), &
    G0tensor(179),M2L1R1,[nME],G0tensor(180))
  call TI_triangle_red(G2tensor(7),RedBasis(10),mass3set(:,4),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nME],G0tensor(185))
  call TI_triangle_red(G3tensor(52),RedBasis(17),mass3set(:,3),G0tensor(186),G0tensor(187),G0tensor(188), &
    G0tensor(189),M2L1R1,[nME],G0tensor(190))
  call TI_triangle_red(G2tensor(18),RedBasis(16),mass3set(:,4),G0tensor(191),G0tensor(192),G0tensor(193), &
    G0tensor(194),M2L1R1,[nME],G0tensor(195))
  call TI_triangle_red(G3tensor(26),RedBasis(15),mass3set(:,3),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nME],G0tensor(200))
  call TI_triangle_red(G2tensor(22),RedBasis(20),mass3set(:,4),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nME],G0tensor(205))
  call TI_triangle_red(G2tensor(91),RedBasis(21),mass3set(:,4),G0tensor(206),G0tensor(207),G0tensor(208), &
    G0tensor(209),M2L1R1,[nME],G0tensor(210))
  call TI_triangle_red(G3tensor(54),RedBasis(17),mass3set(:,5),G0tensor(211),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nMM],G0tensor(215))
  call TI_triangle_red(G3tensor(30),RedBasis(15),mass3set(:,5),G0tensor(216),G0tensor(217),G0tensor(218), &
    G0tensor(219),M2L1R1,[nMM],G0tensor(220))
  call TI_triangle_red(G3tensor(56),RedBasis(17),mass3set(:,6),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),M2L1R1)
  call TI_triangle_red(G3tensor(34),RedBasis(15),mass3set(:,6),G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),M2L1R1)
  call TI_triangle_red(G3tensor(58),RedBasis(11),mass3set(:,5),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nMM],G0tensor(233))
  call TI_triangle_red(G3tensor(38),RedBasis(3),mass3set(:,5),G0tensor(234),G0tensor(235),G0tensor(236), &
    G0tensor(237),M2L1R1,[nMM],G0tensor(238))
  call TI_triangle_red(G3tensor(60),RedBasis(11),mass3set(:,6),G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242),M2L1R1)
  call TI_triangle_red(G3tensor(42),RedBasis(3),mass3set(:,6),G0tensor(243),G0tensor(244),G0tensor(245),G0tensor(246),M2L1R1)
  call TI_triangle_red(G2tensor(41),RedBasis(47),mass3set(:,1),G0tensor(247),G0tensor(248),G0tensor(249), &
    G0tensor(250),M2L1R1,[nME],G0tensor(251))
  call TI_triangle_red(G2tensor(44),RedBasis(48),mass3set(:,1),G0tensor(252),G0tensor(253),G0tensor(254), &
    G0tensor(255),M2L1R1,[nME],G0tensor(256))
  call ol_merge_tensors(T0sum(39),[G0tensor(10)])
  call ol_merge_tensors(T0sum(40),[G0tensor(35)])
  call ol_merge_tensors(T0sum(41),[G0tensor(60)])
  call ol_merge_tensors(T0sum(42),[G0tensor(85)])
  call ol_merge_tensors(T0sum(43),[G0tensor(110)])
  call ol_merge_tensors(T0sum(44),[G0tensor(3)])
  call ol_merge_tensors(T0sum(45),[G0tensor(8)])
  call ol_merge_tensors(T0sum(46),[G0tensor(140)])
  call ol_merge_tensors(T0sum(47),[G0tensor(41)])
  call ol_merge_tensors(T0sum(48),[G0tensor(31)])
  call ol_merge_tensors(T0sum(49),[G0tensor(121)])
  call ol_merge_tensors(T0sum(50),[G0tensor(69)])
  call ol_merge_tensors(T0sum(51),[G0tensor(27)])
  call ol_merge_tensors(T0sum(52),[G0tensor(104)])
  call ol_merge_tensors(T0sum(53),[G0tensor(37)])
  call ol_merge_tensors(T0sum(54),[G0tensor(52)])
  call ol_merge_tensors(T0sum(55),[G0tensor(139)])
  call ol_merge_tensors(T0sum(56),[G0tensor(154)])
  call ol_merge_tensors(T0sum(57),[G0tensor(81)])
  call ol_merge_tensors(T0sum(58),[G0tensor(13)])
  call ol_merge_tensors(T0sum(59),[G0tensor(23)])
  call ol_merge_tensors(T0sum(60),[G0tensor(42)])
  call ol_merge_tensors(T0sum(61),[G0tensor(106)])
  call ol_merge_tensors(T0sum(62),[G0tensor(147)])
  call ol_merge_tensors(T0sum(63),[G0tensor(141)])
  call ol_merge_tensors(T0sum(64),[G0tensor(83)])
  call ol_merge_tensors(T0sum(65),[G0tensor(77)])
  call ol_merge_tensors(T0sum(66),[G0tensor(97)])
  call ol_merge_tensors(T0sum(67),[G0tensor(103)])
  call ol_merge_tensors(T0sum(68),[G0tensor(118)])
  call ol_merge_tensors(T0sum(69),[G0tensor(137)])
  call ol_merge_tensors(T0sum(70),[G0tensor(153)])
  call ol_merge_tensors(T0sum(71),[G0tensor(158)])
  call ol_merge_tensors(T0sum(72),[G0tensor(162)])
  call ol_merge_tensors(T0sum(73),[G0tensor(167)])
  call ol_merge_tensors(T0sum(74),[G0tensor(171)])
  call ol_merge_tensors(T0sum(75),[G0tensor(176)])
  call ol_merge_tensors(T0sum(76),[G0tensor(181)])
  call ol_merge_tensors(T0sum(77),[G0tensor(186)])
  call ol_merge_tensors(T0sum(78),[G0tensor(191)])
  call ol_merge_tensors(T0sum(79),[G0tensor(196)])
  call ol_merge_tensors(T0sum(80),[G0tensor(201)])
  call ol_merge_tensors(T0sum(81),[G0tensor(206)])
  call ol_merge_tensors(T1sum(7),[G1tensor(117)])
  call ol_merge_tensors(T1sum(8),[G1tensor(118)])
  call ol_merge_tensors(T1sum(9),[G1tensor(143)])
  call ol_merge_tensors(T1sum(10),[G1tensor(124)])
  call ol_merge_tensors(T1sum(11),[G1tensor(142)])
  call ol_merge_tensors(T1sum(12),[G1tensor(122)])
  call ol_merge_tensors(T1sum(13),[G1tensor(123)])
  call ol_merge_tensors(T1sum(14),[G1tensor(146)])
  call ol_merge_tensors(T1sum(15),[G1tensor(126)])
  call ol_merge_tensors(T1sum(16),[G1tensor(127)])
  call ol_merge_tensors(T1sum(17),[G1tensor(136)])
  call ol_merge_tensors(T1sum(18),[G1tensor(150)])
  call ol_merge_tensors(T1sum(19),[G1tensor(130)])
  call ol_merge_tensors(T1sum(20),[G1tensor(131)])
  call ol_merge_tensors(T1sum(21),[G1tensor(140)])
  call ol_merge_tensors(T1sum(22),[G1tensor(133)])
  call ol_merge_tensors(T1sum(23),[G1tensor(134)])
  call ol_merge_tensors(T1sum(24),[G1tensor(147)])
  call ol_merge_tensors(T1sum(25),[G1tensor(137)])
  call ol_merge_tensors(T1sum(26),[G1tensor(138)])
  call ol_merge_tensors(T1sum(27),[G1tensor(151)])
  call ol_merge_tensors(T1sum(28),[G1tensor(141)])
  call ol_merge_tensors(T1sum(29),[G1tensor(144)])
  call ol_merge_tensors(T1sum(30),[G1tensor(145)])
  call ol_merge_tensors(T1sum(31),[G1tensor(148)])
  call ol_merge_tensors(T1sum(32),[G1tensor(149)])
  call ol_merge_tensors(T1sum(33),[G1tensor(152)])
  call ol_merge_tensors(T0sum(82),[G0tensor(211)])
  call ol_merge_tensors(T0sum(83),[G0tensor(216)])
  call ol_merge_tensors(T0sum(84),[G0tensor(221)])
  call ol_merge_tensors(T0sum(85),[G0tensor(225)])
  call ol_merge_tensors(T0sum(86),[G0tensor(229)])
  call ol_merge_tensors(T0sum(87),[G0tensor(234)])
  call ol_merge_tensors(T0sum(88),[G0tensor(239)])
  call ol_merge_tensors(T0sum(89),[G0tensor(243)])
  call ol_merge_tensors(T0sum(90),[G0tensor(247)])
  call ol_merge_tensors(T0sum(91),[G0tensor(252)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[21,10],[nME,0],2,2,wf8(:,22),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,22),G0H4(11),m3h8x4(:,25),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(11),21,nME,G1H4(39),n2h4(57))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[26,5],[nME,0],2,2,wf8(:,21),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,21),G0H4(12),m3h8x4(:,26),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H4(12),26,nME,G1H4(40),n2h4(58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[18,13],[0,nME],2,2,wf4(:,6),wf8(:,25))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(5),m3h4x8(:,9),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[26,5],[nME,0],2,2,wf8(:,24),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H4(7),26,nME,G1H4(41),n2h4(59))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[25,6],[nME,0],2,2,wf8(:,28),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(8),m3h8x4(:,28),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(8),25,nME,G1H4(42),n2h4(60))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[22,9],[nME,0],2,2,wf8(:,27),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(1),m3h8x4(:,29),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),22,nME,G1H4(44),n2h4(61))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[25,6],[nME,0],2,2,wf8(:,31),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,31),G0H4(2),m3h8x4(:,30),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H4(2),25,nME,G1H4(45),n2h4(62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[17,14],[0,nME],2,2,wf4(:,12),wf8(:,30))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,10),heltab2x32(:,:,116))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[18,13],[0,nME],2,2,wf4(:,6),wf8(:,34))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,117))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[22,9],[nME,0],2,2,wf8(:,33),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(3),m3h8x4(:,31),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H4(3),22,nME,G1H4(46),n2h4(63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[21,10],[nME,0],2,2,wf8(:,37),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(4),m3h8x4(:,32),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(4),21,nME,G1H4(47),n2h4(64))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[17,14],[0,nME],2,2,wf4(:,12),wf8(:,36))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,120))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(44)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(47),wf4(:,4),G1tensor(1),m3h4x1(:,19),heltab2x4(:,:,127))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(41),wf4(:,3),G1tensor(31),m3h4x1(:,20),heltab2x4(:,:,128))
  call Hloop_VQ_A(ntryL,G0H8(5),wf8(:,25),G0H1(1),m3h8x1(:,17),heltab2x8(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nME,G1tensor(12),n2h1(255))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(45),wf4(:,10),G1tensor(26),m3h4x1(:,21),heltab2x4(:,:,129))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(46),wf4(:,9),G1tensor(4),m3h4x1(:,22),heltab2x4(:,:,130))
  call Hloop_VA_Q(ntryL,G0H8(6),wf8(:,30),G0H1(1),m3h8x1(:,18),heltab2x8(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nME,G1tensor(10),n2h1(256))
  call Hloop_VQ_A(ntryL,G0H8(3),wf8(:,34),G0H1(1),m3h8x1(:,19),heltab2x8(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nME,G1tensor(22),n2h1(257))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,36),G0H1(1),m3h8x1(:,20),heltab2x8(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nME,G1tensor(35),n2h1(258))
  call ol_merge_tensors(G0tensor(253),[G0tensor(248),G0tensor(208),G0tensor(198),G0tensor(193),G0tensor(188),G0tensor(177) &
    ,G0tensor(102),G0tensor(152),G0tensor(116),G0tensor(24),G0tensor(9),G0tensor(65),G0tensor(15)])
  call ol_merge_tensors(G0tensor(86),[G0tensor(84),G0tensor(115),G0tensor(90),G0tensor(20)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(96),G0tensor(4),G0tensor(25)])
  call ol_merge_tensors(G0tensor(256),[G0tensor(251),G0tensor(210),G0tensor(205),G0tensor(200),G0tensor(195),G0tensor(190) &
    ,G0tensor(185),G0tensor(180),G0tensor(175),G0tensor(122),G0tensor(123),G0tensor(117),G0tensor(107),G0tensor(88),G0tensor(136) &
    ,G0tensor(57),G0tensor(43),G0tensor(87),G0tensor(48),G0tensor(61),G0tensor(44),G0tensor(28),G0tensor(74),G0tensor(18) &
    ,G0tensor(12),G0tensor(36),G0tensor(11),G0tensor(135),G0tensor(7),G0tensor(2),G0tensor(105),G0tensor(80),G0tensor(55) &
    ,G0tensor(30)])
  call ol_merge_tensors(G0tensor(71),[G0tensor(59),G0tensor(56),G0tensor(70),G0tensor(40)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(151),G0tensor(47),G0tensor(145),G0tensor(45)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(126),G0tensor(111),G0tensor(32),G0tensor(100),G0tensor(50)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(146),G0tensor(39),G0tensor(75)])
  call ol_merge_tensors(G0tensor(98),[G0tensor(92),G0tensor(67),G0tensor(99),G0tensor(95)])
  call ol_merge_tensors(G0tensor(207),[G0tensor(108),G0tensor(5),G0tensor(120)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(73),G0tensor(64),G0tensor(125),G0tensor(1)])
  call ol_merge_tensors(G0tensor(199),[G0tensor(174),G0tensor(101),G0tensor(94),G0tensor(46),G0tensor(21),G0tensor(130) &
    ,G0tensor(6)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(179),G0tensor(79),G0tensor(26),G0tensor(150)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(12),G0tensor(194),G0tensor(184),G0tensor(51),G0tensor(16)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(63),G0tensor(19),G0tensor(17)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(10),G0tensor(209),G0tensor(204),G0tensor(29),G0tensor(53)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(143),G0tensor(127),G0tensor(89)])
  call ol_merge_tensors(G0tensor(232),[G0tensor(214),G0tensor(38)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(219),G0tensor(134),G0tensor(119)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(233),G0tensor(220),G0tensor(215),G0tensor(166),G0tensor(157),G0tensor(133) &
    ,G0tensor(149),G0tensor(109)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(159),G0tensor(148),G0tensor(124)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(224),G0tensor(114)])
  call ol_merge_tensors(G0tensor(246),[G0tensor(228),G0tensor(14),G0tensor(54)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(218),G0tensor(213),G0tensor(163),G0tensor(155),G0tensor(129)])
  call ol_merge_tensors(G0tensor(217),[G0tensor(132),G0tensor(144)])
  call ol_merge_tensors(G0tensor(240),[G0tensor(227),G0tensor(223),G0tensor(168),G0tensor(160),G0tensor(66)])
  call ol_merge_tensors(G0tensor(226),[G0tensor(142),G0tensor(34)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(113),G0tensor(131),G0tensor(58),G0tensor(91),G0tensor(76),G0tensor(49)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(62),G0tensor(22)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(93),G0tensor(33)])
  call ol_merge_tensors(G0tensor(203),[G0tensor(187),G0tensor(183),G0tensor(178),G0tensor(173),G0tensor(112),G0tensor(82) &
    ,G0tensor(68)])
  call ol_merge_tensors(G0tensor(236),[G0tensor(231),G0tensor(212),G0tensor(128)])
  call ol_merge_tensors(G0tensor(245),[G0tensor(241),G0tensor(222),G0tensor(138)])
  call ol_merge_tensors(G0tensor(235),[G0tensor(165),G0tensor(156)])
  call ol_merge_tensors(G0tensor(244),[G0tensor(170),G0tensor(161)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(249)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(254)])
call TI_bubble_red(G1tensor(31),26,mass2set(:,1),G0tensor(10),M2L1R1,G0tensor(35))
call TI_bubble_red(G1tensor(26),25,mass2set(:,1),G0tensor(60),M2L1R1,G0tensor(85))
call TI_bubble_red(G1tensor(22),18,mass2set(:,2),G0tensor(110),M2L1R1,G0tensor(3))
call TI_bubble_red(G1tensor(35),17,mass2set(:,2),G0tensor(8),M2L1R1,G0tensor(140))
call TI_bubble_red(G1tensor(4),22,mass2set(:,1),G0tensor(41),M2L1R1,G0tensor(31))
call TI_bubble_red(G1tensor(1),21,mass2set(:,1),G0tensor(121),M2L1R1,G0tensor(69))
  call ol_merge_tensors(G0tensor(69),[G0tensor(31),G0tensor(140),G0tensor(3),G0tensor(85),G0tensor(256),G0tensor(35)])
  call ol_merge_tensors(T0sum(92),[G0tensor(253)])
  call ol_merge_tensors(T0sum(93),[G0tensor(86)])
  call ol_merge_tensors(T0sum(94),[G0tensor(10)])
  call ol_merge_tensors(T0sum(95),[G0tensor(69)])
  call ol_merge_tensors(T0sum(96),[G0tensor(71)])
  call ol_merge_tensors(T0sum(97),[G0tensor(78)])
  call ol_merge_tensors(T0sum(98),[G0tensor(72)])
  call ol_merge_tensors(T0sum(99),[G0tensor(60)])
  call ol_merge_tensors(T0sum(100),[G0tensor(98)])
  call ol_merge_tensors(T0sum(101),[G0tensor(207)])
  call ol_merge_tensors(T0sum(102),[G0tensor(197)])
  call ol_merge_tensors(T0sum(103),[G0tensor(199)])
  call ol_merge_tensors(T0sum(104),[G0tensor(189)])
  call ol_merge_tensors(T0sum(105),[G0tensor(110)])
  call ol_merge_tensors(T0sum(106),[G0tensor(192)])
  call ol_merge_tensors(T0sum(107),[G0tensor(8)])
  call ol_merge_tensors(T0sum(108),[G0tensor(164)])
  call ol_merge_tensors(T0sum(109),[G0tensor(232)])
  call ol_merge_tensors(T0sum(110),[G0tensor(237)])
  call ol_merge_tensors(T0sum(111),[G0tensor(238)])
  call ol_merge_tensors(T0sum(112),[G0tensor(169)])
  call ol_merge_tensors(T0sum(113),[G0tensor(242)])
  call ol_merge_tensors(T0sum(114),[G0tensor(246)])
  call ol_merge_tensors(T0sum(115),[G0tensor(230)])
  call ol_merge_tensors(T0sum(116),[G0tensor(217)])
  call ol_merge_tensors(T0sum(117),[G0tensor(240)])
  call ol_merge_tensors(T0sum(118),[G0tensor(226)])
  call ol_merge_tensors(T0sum(119),[G0tensor(172)])
  call ol_merge_tensors(T0sum(120),[G0tensor(182)])
  call ol_merge_tensors(T0sum(121),[G0tensor(202)])
  call ol_merge_tensors(T0sum(122),[G0tensor(203)])
  call ol_merge_tensors(T0sum(123),[G0tensor(236)])
  call ol_merge_tensors(T0sum(124),[G0tensor(245)])
  call ol_merge_tensors(T0sum(125),[G0tensor(235)])
  call ol_merge_tensors(T0sum(126),[G0tensor(244)])
  call ol_merge_tensors(T0sum(127),[G0tensor(41)])
  call ol_merge_tensors(T0sum(128),[G0tensor(250)])
  call ol_merge_tensors(T0sum(129),[G0tensor(121)])
  call ol_merge_tensors(T0sum(130),[G0tensor(255)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_15,RedSet_4(5),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_15,RedSet_4(6),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_17,RedSet_4(7),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_16,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_15,RedSet_4(8),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_14,RedSet_4(9),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_17,RedSet_4(10),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_15,RedSet_4(11),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_15,RedSet_4(2),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_14,RedSet_4(12),ScalarBoxes(10))
  call compute_scalar_box([ 20, 22, 23 ],masses2_15,RedSet_4(13),ScalarBoxes(11))
  call compute_scalar_box([ 16, 22, 23 ],masses2_15,RedSet_4(14),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 22 ],masses2_16,RedSet_4(3),ScalarBoxes(13))
  call compute_scalar_box([ 4, 6, 7 ],masses2_15,RedSet_4(15),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_14,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_17,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_15,RedSet_4(18),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_14,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 17, 19, 23 ],masses2_14,RedSet_4(20),ScalarBoxes(19))
  call compute_scalar_box([ 16, 17, 23 ],masses2_15,RedSet_4(21),ScalarBoxes(20))
  call compute_scalar_box([ 16, 17, 19 ],masses2_15,RedSet_4(4),ScalarBoxes(21))
  call compute_scalar_box([ 1, 3, 7 ],masses2_14,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 17, 19, 27 ],masses2_14,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 16, 17, 27 ],masses2_15,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 1, 3, 11 ],masses2_14,RedSet_4(25),ScalarBoxes(25))
! end of process


end subroutine vamp_1

end module ol_vamp_1_eeaa_lew_eexaaa_4_/**/REALKIND
