
module ol_vamp_1_eeaa_lew_eexaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_eeaa_lew_eexaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_eeaa_lew_eexaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_eeaa_lew_eexaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_eeaa_lew_eexaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_eeaa_lew_eexaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_lew_eexaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nME,nME,nMH,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nME,nME,nMZ,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nME,nME,0,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(4),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nME,nME,nMZ,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nME,G1H16(5),n2h16(4))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,7),heltab2x32(:,:,7))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,8),heltab2x32(:,:,8))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,19),heltab2x32(:,:,19))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,4,8],[nME,nMH,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(9),16,nME,G1H16(13),n2h16(5))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,4,8],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(9),16,nME,G1H16(14),n2h16(6))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nME,0,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(9),16,nME,G1H16(16),n2h16(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(9),16,nME,G1H16(17),n2h16(8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,4,2,1,8],[nME,nME,nMH,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(17),16,nME,G1H16(25),n2h16(9))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,4,2,1,8],[nME,nME,nMZ,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(17),16,nME,G1H16(26),n2h16(10))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,4,2,1,8],[nME,nME,0,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(17),16,nME,G1H16(28),n2h16(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,2,1,8],[nME,nME,nMZ,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(17),16,nME,G1H16(29),n2h16(12))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,46),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,47),heltab2x32(:,:,47))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,49),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,50),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,51),heltab2x32(:,:,51))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,52),heltab2x32(:,:,52))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,53),heltab2x32(:,:,53))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,54),heltab2x32(:,:,54))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,55),heltab2x32(:,:,55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,56),heltab2x32(:,:,56))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,57),heltab2x32(:,:,57))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,58),heltab2x32(:,:,58))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,59),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,2,1,8,4],[nME,nMH,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(25),16,nME,G1H16(37),n2h16(13))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,2,1,8,4],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(25),16,nME,G1H16(38),n2h16(14))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,63),heltab2x32(:,:,63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,2,1,8,4],[nME,0,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(25),16,nME,G1H16(40),n2h16(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,2,1,8,4],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(25),16,nME,G1H16(41),n2h16(16))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,66),heltab2x32(:,:,66))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,67),heltab2x32(:,:,67))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,71),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,72),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,73),heltab2x32(:,:,73))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,1,2,4,8],[nME,nMH,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(33),16,nME,G1H16(49),n2h16(17))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,1,2,4,8],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(33),16,nME,G1H16(50),n2h16(18))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,1,2,4,8],[nME,0,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(33),16,nME,G1H16(52),n2h16(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,1,2,4,8],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(33),16,nME,G1H16(53),n2h16(20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,93),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,94),heltab2x32(:,:,94))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,95),heltab2x32(:,:,95))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,2,8,4],[nME,nMH,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(41),16,nME,G1H16(61),n2h16(21))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,2,8,4],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(41),16,nME,G1H16(62),n2h16(22))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,1,2,8,4],[nME,0,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(41),16,nME,G1H16(64),n2h16(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,1,2,8,4],[nME,nMZ,nME,nME,nME],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(41),16,nME,G1H16(65),n2h16(24))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,112),heltab2x32(:,:,112))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,113),heltab2x32(:,:,113))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(71),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(2),n2h8(2))
  call Hloop_SV_T(ntryL,G1H16(3),16,ex3(:),4,G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(4),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nME,G2H8(5),n2h8(4))
  call Hloop_SV_T(ntryL,G0H16(1),16,ex3(:),4,G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VV_S(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_SV_T(ntryL,G1H16(6),16,ex3(:),4,G2H8(6),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_SV_V(ntryL,G1H16(7),ex3(:),G1H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_VV_S(ntryL,G1H16(8),ex3(:),G1H8(3),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_SV_T(ntryL,G0H16(3),16,ex3(:),4,G1H8(4),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_VV_S(ntryL,G0H16(4),ex3(:),G0H8(2),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_SV_V(ntryL,G0H16(5),ex3(:),G0H8(3),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_UW_V(ntryL,G0H16(6),16,ex3(:),4,G1H8(5),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_SV_V(ntryL,G1H16(9),ex3(:),G1H8(6),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_VV_S(ntryL,G1H16(10),ex3(:),G1H8(7),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_UW_V(ntryL,G1H16(11),16,ex3(:),4,G2H8(7),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_SV_V(ntryL,G0H16(7),ex3(:),G0H8(4),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_UW_V(ntryL,G0H16(8),16,ex3(:),4,G1H8(8),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_UW_V(ntryL,G1H16(12),16,ex3(:),4,G2H8(8),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_S(ntryL,G1H16(13),ex2(:),G1H8(9),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_S(ntryL,G1H16(14),ex2(:),G1H8(10),ngX,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_SA_Q(ntryL,G1H16(15),ex2(:),G1H8(11),ngPln,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(11),18,0,G2H8(9),n2h8(5))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(11),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_Z(ntryL,G1H16(17),ex2(:),G1H8(12),ngZl,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_SA_Q(ntryL,G0H16(9),ex2(:),G0H8(5),ngPln,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(13),n2h8(6))
  call Hloop_SA_Q(ntryL,G1H16(18),ex2(:),G1H8(14),ngPln,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(14),18,0,G2H8(10),n2h8(7))
  call Hloop_WA_Q(ntryL,G0H16(10),ex2(:),G0H8(5),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(14),n2h8(8))
  call Hloop_SA_Q(ntryL,G1H16(19),ex2(:),G1H8(15),ngPln,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(15),18,0,G2H8(11),n2h8(9))
  call Hloop_SA_Q(ntryL,G0H16(11),ex2(:),G0H8(5),ngPln,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(15),n2h8(10))
  call Hloop_WA_Q(ntryL,G1H16(20),ex2(:),G1H8(16),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(16),18,0,G2H8(12),n2h8(11))
  call Hloop_WA_Q(ntryL,G0H16(12),ex2(:),G0H8(5),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(16),n2h8(12))
  call Hloop_SA_Q(ntryL,G0H16(13),ex2(:),G0H8(5),ngPln,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(17),n2h8(13))
  call Hloop_SA_Q(ntryL,G1H16(21),ex2(:),G1H8(18),ngPln,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(13),n2h8(14))
  call Hloop_WA_Q(ntryL,G0H16(14),ex2(:),G0H8(5),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(18),n2h8(15))
  call Hloop_WA_Q(ntryL,G1H16(22),ex2(:),G1H8(19),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(19),18,0,G2H8(14),n2h8(16))
  call Hloop_SA_Q(ntryL,G0H16(15),ex2(:),G0H8(5),ngPln,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(19),n2h8(17))
  call Hloop_WA_Q(ntryL,G1H16(23),ex2(:),G1H8(20),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(20),18,0,G2H8(15),n2h8(18))
  call Hloop_WA_Q(ntryL,G0H16(16),ex2(:),G0H8(5),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(20),n2h8(19))
  call Hloop_WA_Q(ntryL,G1H16(24),ex2(:),G1H8(21),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(21),18,0,G2H8(16),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(25),ex3(:),G1H8(21),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(21),20,nME,G2H8(17),n2h8(21))
  call Hloop_QV_A(ntryL,G1H16(26),ex3(:),G1H8(21),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(21),20,nME,G2H8(18),n2h8(22))
  call Hloop_TV_S(ntryL,G1H16(27),16,ex3(:),4,G2H8(19),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(21),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(21),20,nME,G2H8(20),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(21),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(21),20,nME,G2H8(21),n2h8(24))
  call Hloop_TV_S(ntryL,G0H16(17),16,ex3(:),4,G1H8(21),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_VV_S(ntryL,G0H16(18),ex3(:),G0H8(5),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_SV_V(ntryL,G1H16(30),ex3(:),G1H8(22),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_TV_S(ntryL,G1H16(31),16,ex3(:),4,G2H8(22),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_VV_S(ntryL,G1H16(32),ex3(:),G1H8(23),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_SV_V(ntryL,G0H16(19),ex3(:),G0H8(6),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_UV_W(ntryL,G0H16(20),16,ex3(:),4,G1H8(24),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_TV_S(ntryL,G0H16(21),16,ex3(:),4,G1H8(25),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_VV_S(ntryL,G0H16(22),ex3(:),G0H8(7),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_SV_V(ntryL,G1H16(33),ex3(:),G1H8(26),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_UV_W(ntryL,G1H16(34),16,ex3(:),4,G2H8(23),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_VV_S(ntryL,G1H16(35),ex3(:),G1H8(27),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_SV_V(ntryL,G0H16(23),ex3(:),G0H8(8),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_UV_W(ntryL,G0H16(24),16,ex3(:),4,G1H8(28),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_UV_W(ntryL,G1H16(36),16,ex3(:),4,G2H8(24),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_QA_S(ntryL,G1H16(37),ex2(:),G1H8(29),ngH,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_QA_S(ntryL,G1H16(38),ex2(:),G1H8(30),ngX,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_SA_Q(ntryL,G1H16(39),ex2(:),G1H8(31),ngPln,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(31),18,0,G2H8(25),n2h8(25))
  call Hloop_QA_V(ntryL,G1H16(40),ex2(:),G1H8(31),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_QA_Z(ntryL,G1H16(41),ex2(:),G1H8(32),ngZl,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_SA_Q(ntryL,G0H16(25),ex2(:),G0H8(9),ngPln,m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(33),n2h8(26))
  call Hloop_SA_Q(ntryL,G1H16(42),ex2(:),G1H8(34),ngPln,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(34),18,0,G2H8(26),n2h8(27))
  call Hloop_WA_Q(ntryL,G0H16(26),ex2(:),G0H8(9),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(34),n2h8(28))
  call Hloop_SA_Q(ntryL,G1H16(43),ex2(:),G1H8(35),ngPln,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(35),18,0,G2H8(27),n2h8(29))
  call Hloop_SA_Q(ntryL,G0H16(27),ex2(:),G0H8(9),ngPln,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(35),n2h8(30))
  call Hloop_WA_Q(ntryL,G1H16(44),ex2(:),G1H8(36),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(36),18,0,G2H8(28),n2h8(31))
  call Hloop_WA_Q(ntryL,G0H16(28),ex2(:),G0H8(9),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(36),n2h8(32))
  call Hloop_SA_Q(ntryL,G0H16(29),ex2(:),G0H8(9),ngPln,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(37),n2h8(33))
  call Hloop_SA_Q(ntryL,G1H16(45),ex2(:),G1H8(38),ngPln,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(38),18,0,G2H8(29),n2h8(34))
  call Hloop_WA_Q(ntryL,G0H16(30),ex2(:),G0H8(9),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(38),n2h8(35))
  call Hloop_WA_Q(ntryL,G1H16(46),ex2(:),G1H8(39),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(39),18,0,G2H8(30),n2h8(36))
  call Hloop_SA_Q(ntryL,G0H16(31),ex2(:),G0H8(9),ngPln,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(39),n2h8(37))
  call Hloop_WA_Q(ntryL,G1H16(47),ex2(:),G1H8(40),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H8(40),18,0,G2H8(31),n2h8(38))
  call Hloop_WA_Q(ntryL,G0H16(32),ex2(:),G0H8(9),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(9),18,0,G1H8(40),n2h8(39))
  call Hloop_WA_Q(ntryL,G1H16(48),ex2(:),G1H8(41),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(41),18,0,G2H8(32),n2h8(40))
  call Hloop_AQ_S(ntryL,G1H16(49),ex1(:),G1H8(41),ngH,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AQ_S(ntryL,G1H16(50),ex1(:),G1H8(42),ngX,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_SQ_A(ntryL,G1H16(51),ex1(:),G1H8(43),ngPnl,m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(43),17,0,G2H8(33),n2h8(41))
  call Hloop_AQ_V(ntryL,G1H16(52),ex1(:),G1H8(43),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_Z(ntryL,G1H16(53),ex1(:),G1H8(44),ngZl,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_SQ_A(ntryL,G0H16(33),ex1(:),G0H8(9),ngPnl,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(45),n2h8(42))
  call Hloop_SQ_A(ntryL,G1H16(54),ex1(:),G1H8(46),ngPnl,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(46),17,0,G2H8(34),n2h8(43))
  call Hloop_SQ_A(ntryL,G1H16(55),ex1(:),G1H8(46),ngPnl,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(46),17,0,G2H8(35),n2h8(44))
  call Hloop_WQ_A(ntryL,G0H16(34),ex1(:),G0H8(9),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(46),n2h8(45))
  call Hloop_SQ_A(ntryL,G0H16(35),ex1(:),G0H8(9),ngPnl,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(47),n2h8(46))
  call Hloop_SQ_A(ntryL,G0H16(36),ex1(:),G0H8(9),ngPnl,m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(48),n2h8(47))
  call Hloop_SQ_A(ntryL,G1H16(56),ex1(:),G1H8(49),ngPnl,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(49),17,0,G2H8(36),n2h8(48))
  call Hloop_WQ_A(ntryL,G1H16(57),ex1(:),G1H8(49),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(49),17,0,G2H8(37),n2h8(49))
  call Hloop_WQ_A(ntryL,G0H16(37),ex1(:),G0H8(9),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(49),n2h8(50))
  call Hloop_WQ_A(ntryL,G0H16(38),ex1(:),G0H8(9),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(50),n2h8(51))
  call Hloop_SQ_A(ntryL,G0H16(39),ex1(:),G0H8(9),ngPnl,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(51),n2h8(52))
  call Hloop_WQ_A(ntryL,G1H16(58),ex1(:),G1H8(52),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(52),17,0,G2H8(38),n2h8(53))
  call Hloop_WQ_A(ntryL,G1H16(59),ex1(:),G1H8(52),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(52),17,0,G2H8(39),n2h8(54))
  call Hloop_WQ_A(ntryL,G0H16(40),ex1(:),G0H8(9),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(52),n2h8(55))
  call Hloop_WQ_A(ntryL,G1H16(60),ex1(:),G1H8(53),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(53),17,0,G2H8(40),n2h8(56))
  call Hloop_AQ_S(ntryL,G1H16(61),ex1(:),G1H8(53),ngH,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_S(ntryL,G1H16(62),ex1(:),G1H8(54),ngX,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_SQ_A(ntryL,G1H16(63),ex1(:),G1H8(55),ngPnl,m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(55),17,0,G2H8(41),n2h8(57))
  call Hloop_AQ_V(ntryL,G1H16(64),ex1(:),G1H8(55),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(56),ngZl,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_SQ_A(ntryL,G0H16(41),ex1(:),G0H8(9),ngPnl,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(57),n2h8(58))
  call Hloop_SQ_A(ntryL,G1H16(66),ex1(:),G1H8(58),ngPnl,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(58),17,0,G2H8(42),n2h8(59))
  call Hloop_SQ_A(ntryL,G1H16(67),ex1(:),G1H8(58),ngPnl,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(58),17,0,G2H8(43),n2h8(60))
  call Hloop_WQ_A(ntryL,G0H16(42),ex1(:),G0H8(9),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(58),n2h8(61))
  call Hloop_SQ_A(ntryL,G0H16(43),ex1(:),G0H8(9),ngPnl,m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(59),n2h8(62))
  call Hloop_SQ_A(ntryL,G0H16(44),ex1(:),G0H8(9),ngPnl,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(60),n2h8(63))
  call Hloop_SQ_A(ntryL,G1H16(68),ex1(:),G1H8(61),ngPnl,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(61),17,0,G2H8(44),n2h8(64))
  call Hloop_WQ_A(ntryL,G1H16(69),ex1(:),G1H8(61),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(61),17,0,G2H8(45),n2h8(65))
  call Hloop_WQ_A(ntryL,G0H16(45),ex1(:),G0H8(9),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(61),n2h8(66))
  call Hloop_WQ_A(ntryL,G0H16(46),ex1(:),G0H8(9),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(62),n2h8(67))
  call Hloop_SQ_A(ntryL,G0H16(47),ex1(:),G0H8(9),ngPnl,m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(63),n2h8(68))
  call Hloop_WQ_A(ntryL,G1H16(70),ex1(:),G1H8(64),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(64),17,0,G2H8(46),n2h8(69))
  call Hloop_WQ_A(ntryL,G1H16(71),ex1(:),G1H8(64),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(64),17,0,G2H8(47),n2h8(70))
  call Hloop_WQ_A(ntryL,G0H16(48),ex1(:),G0H8(9),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(64),n2h8(71))
  call Hloop_WQ_A(ntryL,G1H16(72),ex1(:),G1H8(65),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(65),17,0,G2H8(48),n2h8(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(63)])
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(65),G1H8(1),G1H8(2),G1H8(4),G1H8(6),G1H8(14),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(4),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngPnl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(5),n2h4(1))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(1),mass5set(:,1),  & 
G1H8(13),G1H8(16),G1H8(18),G1H8(15),G1H8(17),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(6),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngPnl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(7),n2h4(3))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(19),G1H8(21),G1H8(22),G1H8(25),G1H8(26),G1H8(34),8)
  call HG1shiftOLR(G1H8(21),8,8)
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(8),n2h4(4))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(33),G1H8(36),G1H8(38),G1H8(35),G1H8(37),G1H8(40),8)
  call HG1shiftOLR(G1H8(36),8,8)
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngH,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(9),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngX,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(10),n2h4(6))
  call Hloop_AQ_S(ntryL,G2H8(9),ex1(:),G2H4(11),ngPnl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(12),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),ngZl,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(13),n2h4(8))
  call Hloop_AQ_S(ntryL,G2H8(12),ex1(:),G2H4(14),ngPnl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_S(ntryL,G2H8(10),ex1(:),G2H4(15),ngPnl,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_W(ntryL,G2H8(11),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_S(ntryL,G2H8(14),ex1(:),G2H4(17),ngPnl,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_W(ntryL,G2H8(13),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_S(ntryL,G2H8(17),ex2(:),G2H4(21),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_S(ntryL,G2H8(18),ex2(:),G2H4(22),ngX,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(2),mass5set(:,1),  & 
G1H8(39),G1H8(46),G1H8(45),G1H8(49),G1H8(50),G1H8(47),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hloop_QA_V(ntryL,G2H8(20),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_Z(ntryL,G2H8(21),ex2(:),G2H4(24),ngZl,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_SA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),ngPln,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(25),n2h4(9))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(26),n2h4(10))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(2),mass5set(:,1),  & 
G1H8(48),G1H8(52),G1H8(51),G1H8(58),G1H8(57),G1H8(61),8)
  call HG1shiftOLR(G1H8(52),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(2),mass5set(:,1),  & 
G1H8(62),G1H8(59),G1H8(60),G1H8(64),G1H8(63),G1H8(3),8)
  call HG1shiftOLR(G1H8(59),8,8)
  call Hloop_SA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),ngPln,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(27),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(28),n2h4(12))
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(2),mass5set(:,1),  & 
G1H8(5),G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hloop_SQ_A(ntryL,G1H8(29),ex1(:),G1H4(1),ngH,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(29),n2h4(13))
  call Hloop_SQ_A(ntryL,G1H8(30),ex1(:),G1H4(1),ngX,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(30),n2h4(14))
  call Hloop_AQ_S(ntryL,G2H8(25),ex1(:),G2H4(31),ngPnl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_VQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(32),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(32),ex1(:),G1H4(1),ngZl,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),19,nME,G2H4(33),n2h4(16))
  call Hloop_AQ_S(ntryL,G2H8(28),ex1(:),G2H4(34),ngPnl,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_S(ntryL,G2H8(26),ex1(:),G2H4(35),ngPnl,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G2H8(27),ex1(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_AQ_S(ntryL,G2H8(30),ex1(:),G2H4(37),ngPnl,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_W(ntryL,G2H8(31),ex1(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_W(ntryL,G2H8(29),ex1(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_W(ntryL,G2H8(32),ex1(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_SA_Q(ntryL,G1H8(41),ex2(:),G1H4(1),ngH,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(41),n2h4(17))
  call Hloop_SA_Q(ntryL,G1H8(42),ex2(:),G1H4(1),ngX,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(42),n2h4(18))
  call Hloop_QA_S(ntryL,G2H8(33),ex2(:),G2H4(43),ngPln,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_VA_Q(ntryL,G1H8(43),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(44),n2h4(19))
  call Hloop_ZA_Q(ntryL,G1H8(44),ex2(:),G1H4(1),ngZl,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(45),n2h4(20))
  call Hloop_QA_S(ntryL,G2H8(37),ex2(:),G2H4(46),ngPln,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_QA_S(ntryL,G2H8(34),ex2(:),G2H4(47),ngPln,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G2H8(35),ex2(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QA_S(ntryL,G2H8(38),ex2(:),G2H4(49),ngPln,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_QA_W(ntryL,G2H8(39),ex2(:),G2H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_QA_W(ntryL,G2H8(36),ex2(:),G2H4(51),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_QA_W(ntryL,G2H8(40),ex2(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(1),ngH,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(53),n2h4(21))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(1),ngX,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(54),n2h4(22))
  call Hloop_QA_S(ntryL,G2H8(41),ex2(:),G2H4(55),ngPln,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_VA_Q(ntryL,G1H8(55),ex2(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(56),n2h4(23))
  call Hloop_ZA_Q(ntryL,G1H8(56),ex2(:),G1H4(1),ngZl,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),19,nME,G2H4(57),n2h4(24))
  call Hloop_QA_S(ntryL,G2H8(45),ex2(:),G2H4(58),ngPln,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_S(ntryL,G2H8(42),ex2(:),G2H4(59),ngPln,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QA_W(ntryL,G2H8(43),ex2(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_S(ntryL,G2H8(46),ex2(:),G2H4(61),ngPln,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_W(ntryL,G2H8(47),ex2(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_W(ntryL,G2H8(44),ex2(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_QA_W(ntryL,G2H8(48),ex2(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_SQ_A(ntryL,G1H8(65),ex1(:),G1H4(1),ngPnl,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(65),n2h4(25))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(1),-8,ex4(:),8,G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngPnl,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(67),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngPnl,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(68),n2h4(27))
  call Hloop_SQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngPnl,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(69),n2h4(28))
  call Hloop_SQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),ngPnl,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(70),n2h4(29))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(16),ex4(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_SQ_A(ntryL,G1H8(15),ex1(:),G1H4(2),ngPnl,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(71),n2h4(30))
  call Hloop_SQ_A(ntryL,G1H8(17),ex1(:),G1H4(2),ngPnl,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(72),n2h4(31))
  call Hloop_SQ_A(ntryL,G1H8(20),ex1(:),G1H4(2),ngPnl,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(73),n2h4(32))
  call Hloop_WQ_A(ntryL,G1H8(19),ex1(:),G1H4(2),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(74),n2h4(33))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(21),ex4(:),G1H4(2),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_WQ_A(ntryL,G1H8(25),ex1(:),G1H4(3),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(75),n2h4(34))
  call Hloop_WQ_A(ntryL,G1H8(26),ex1(:),G1H4(3),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(76),n2h4(35))
  call Hloop_WQ_A(ntryL,G1H8(34),ex1(:),G1H4(3),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(77),n2h4(36))
  call Hloop_WQ_A(ntryL,G1H8(33),ex1(:),G1H4(3),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(78),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(36),-8,ex4(:),8,G2H4(79),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_WQ_A(ntryL,G1H8(35),ex1(:),G1H4(3),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(80),n2h4(38))
  call Hloop_WQ_A(ntryL,G1H8(37),ex1(:),G1H4(3),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(81),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(40),ex1(:),G1H4(3),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(82),n2h4(40))
  call Hloop_SA_Q(ntryL,G1H8(39),ex2(:),G1H4(3),ngPln,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(83),n2h4(41))
call HGT_OLR(G1H8(46),1,1,8)
call HGT_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(46),-8,ex4(:),8,G2H4(84),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_SA_Q(ntryL,G1H8(49),ex2(:),G1H4(3),ngPln,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(85),n2h4(42))
  call Hloop_SA_Q(ntryL,G1H8(50),ex2(:),G1H4(3),ngPln,m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(86),n2h4(43))
  call Hloop_SA_Q(ntryL,G1H8(47),ex2(:),G1H4(3),ngPln,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(87),n2h4(44))
  call Hloop_SA_Q(ntryL,G1H8(48),ex2(:),G1H4(3),ngPln,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(88),n2h4(45))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(52),ex4(:),G1H4(3),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_SA_Q(ntryL,G1H8(58),ex2(:),G1H4(4),ngPln,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(89),n2h4(46))
  call Hloop_SA_Q(ntryL,G1H8(57),ex2(:),G1H4(4),ngPln,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(90),n2h4(47))
  call Hloop_SA_Q(ntryL,G1H8(61),ex2(:),G1H4(4),ngPln,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(91),n2h4(48))
  call Hloop_WA_Q(ntryL,G1H8(62),ex2(:),G1H4(4),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(4),22,0,G2H4(92),n2h4(49))
call HGT_raise_alpha_OLR(G1H8(59),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(59),ex4(:),G1H4(4),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_WA_Q(ntryL,G1H8(64),ex2(:),G1H4(5),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(93),n2h4(50))
  call Hloop_WA_Q(ntryL,G1H8(63),ex2(:),G1H4(5),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(94),n2h4(51))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(5),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(95),n2h4(52))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(5),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(96),n2h4(53))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(7),-8,ex4(:),8,G2H4(97),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(5),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(98),n2h4(54))
  call Hloop_WA_Q(ntryL,G1H8(10),ex2(:),G1H4(5),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(99),n2h4(55))
  call Hloop_WA_Q(ntryL,G1H8(11),ex2(:),G1H4(5),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(5),22,0,G2H4(100),n2h4(56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(54)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,2),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,3),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,4),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,3),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hloop_QA_S(ntryL,G2H4(74),ex2(:),G2H2(1),ngPln,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_S(ntryL,G2H4(65),ex2(:),G2H2(2),ngPln,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(78),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(70),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,5),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),8,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(3),mass5set(:,6),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,7),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,8),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(3),mass5set(:,7),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hloop_SV_V(ntryL,G2H4(15),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VV_S(ntryL,G2H4(16),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SV_V(ntryL,G2H4(17),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VV_S(ntryL,G2H4(18),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(3),mass5set(:,7),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(3),mass5set(:,7),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(2),mass5set(:,2),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(2),mass5set(:,3),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(2),mass5set(:,4),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,3),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hloop_AQ_S(ntryL,G2H4(92),ex1(:),G2H2(9),ngPnl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_S(ntryL,G2H4(83),ex1(:),G2H2(10),ngPnl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(96),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(88),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(4),mass5set(:,5),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(4),mass5set(:,6),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(4),mass5set(:,7),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),4,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(4),mass5set(:,8),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(4),mass5set(:,7),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),4,4)
  call Hloop_SV_V(ntryL,G2H4(35),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VV_S(ntryL,G2H4(36),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SV_V(ntryL,G2H4(37),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VV_S(ntryL,G2H4(38),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(4),mass5set(:,7),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,7),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(5),mass5set(:,5),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),8,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(5),mass5set(:,6),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(5),mass5set(:,7),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(5),mass5set(:,8),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),8,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(5),mass5set(:,7),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),8,4)
  call Hloop_SV_V(ntryL,G2H4(47),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VV_S(ntryL,G2H4(48),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SV_V(ntryL,G2H4(49),ex3(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VV_S(ntryL,G2H4(50),ex3(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(5),mass5set(:,7),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(168),8,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(5),mass5set(:,7),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),8,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(6),mass5set(:,5),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(180),4,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(6),mass5set(:,6),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),G1H4(190),4)
  call HG1shiftOLR(G1H4(186),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(6),mass5set(:,7),  & 
G1H4(191),G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(192),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(6),mass5set(:,8),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(198),4,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(6),mass5set(:,7),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),4)
  call HG1shiftOLR(G1H4(204),4,4)
  call Hloop_SV_V(ntryL,G2H4(59),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VV_S(ntryL,G2H4(60),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_SV_V(ntryL,G2H4(61),ex4(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_VV_S(ntryL,G2H4(62),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(6),mass5set(:,7),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),4,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(6),mass5set(:,7),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),4,4)
  call Hloop_QA_S(ntryL,G2H4(68),ex2(:),G2H2(25),ngPln,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_S(ntryL,G2H4(69),ex2(:),G2H2(26),ngPln,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_W(ntryL,G2H4(72),ex2(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_W(ntryL,G2H4(73),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_S(ntryL,G2H4(76),ex2(:),G2H2(29),ngPln,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_S(ntryL,G2H4(77),ex2(:),G2H2(30),ngPln,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_W(ntryL,G2H4(81),ex2(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G2H4(82),ex2(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_S(ntryL,G2H4(86),ex1(:),G2H2(33),ngPnl,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_S(ntryL,G2H4(87),ex1(:),G2H2(34),ngPnl,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_W(ntryL,G2H4(90),ex1(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_W(ntryL,G2H4(91),ex1(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_S(ntryL,G2H4(94),ex1(:),G2H2(37),ngPnl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_S(ntryL,G2H4(95),ex1(:),G2H2(38),ngPnl,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(99),ex1(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(100),ex1(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngH,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(41),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(6),-8,nME,G2H4(5),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(43),n2h2(2))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(1),ngH,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(44),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),ngX,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(45),n2h2(4))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-8,nME,G2H4(6),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),ngX,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(47),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(1),ngX,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(48),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(49),n2h2(7))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-8,nME,G2H4(7),n2h4(59))
  call Hloop_QV_A(ntryL,G2H4(7),ex4(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(51),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(22),ex2(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(52),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex2(:),G1H2(1),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(53),n2h2(10))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-8,nME,G2H4(8),n2h4(60))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex2(:),G1H2(1),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(55),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(28),ex2(:),G1H2(1),ngZl,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),23,nME,G2H2(56),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(29),ex3(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(57),n2h2(13))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-8,nME,G2H4(10),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(10),ex4(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(59),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(34),ex3(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(60),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(35),ex3(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(61),n2h2(16))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(36),-8,nME,G2H4(25),n2h4(62))
  call Hloop_AV_Q(ntryL,G2H4(25),ex4(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(63),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(40),ex3(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(64),n2h2(18))
  call Hloop_TV_S(ntryL,G1H4(41),19,ex3(:),4,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(42),-8,ex4(:),8,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_TV_S(ntryL,G1H4(45),19,ex3(:),4,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_TV_S(ntryL,G1H4(46),19,ex3(:),4,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(47),ex3(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(69),n2h2(19))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(48),-8,nME,G2H4(26),n2h4(64))
  call Hloop_AV_Q(ntryL,G2H4(26),ex4(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QV_A(ntryL,G1H4(51),ex3(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(71),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(52),ex3(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),23,nME,G2H2(72),n2h2(21))
  call Hloop_TV_S(ntryL,G1H4(53),19,ex3(:),4,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
call HGT_raise_alpha_OLR(G1H4(54),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(54),ex4(:),G1H2(1),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_TV_S(ntryL,G1H4(57),19,ex3(:),4,G2H2(74),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_TV_S(ntryL,G1H4(58),19,ex3(:),4,G2H2(75),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_UV_W(ntryL,G1H4(59),19,ex3(:),4,G2H2(76),m3h2x2(:,77),heltab2x4(:,:,77))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(60),ex4(:),G1H2(2),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_UV_W(ntryL,G1H4(63),19,ex3(:),4,G2H2(77),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_UV_W(ntryL,G1H4(64),19,ex3(:),4,G2H2(78),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_UV_W(ntryL,G1H4(65),19,ex3(:),4,G2H2(79),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(66),-8,ex4(:),8,G2H2(80),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_UV_W(ntryL,G1H4(69),19,ex3(:),4,G2H2(81),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UV_W(ntryL,G1H4(70),19,ex3(:),4,G2H2(82),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(3),ngH,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(83),n2h2(22))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-8,nME,G2H4(27),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(27),ex4(:),G2H2(84),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(3),ngH,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(85),n2h2(23))
  call Hloop_SQ_A(ntryL,G1H4(76),ex1(:),G1H2(3),ngH,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(86),n2h2(24))
  call Hloop_SQ_A(ntryL,G1H4(77),ex1(:),G1H2(3),ngX,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(87),n2h2(25))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(78),-8,nME,G2H4(28),n2h4(69))
  call Hloop_AV_Q(ntryL,G2H4(28),ex4(:),G2H2(88),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_SQ_A(ntryL,G1H4(81),ex1(:),G1H2(3),ngX,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(89),n2h2(26))
  call Hloop_SQ_A(ntryL,G1H4(82),ex1(:),G1H2(3),ngX,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(90),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(83),ex1(:),G1H2(3),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(91),n2h2(28))
call HGT_OLR(G1H4(84),1,1,4)
call HGT_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(84),-8,nME,G2H4(30),n2h4(70))
  call Hloop_AV_Q(ntryL,G2H4(30),ex4(:),G2H2(92),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_VQ_A(ntryL,G1H4(87),ex1(:),G1H2(3),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(93),n2h2(29))
  call Hloop_VQ_A(ntryL,G1H4(88),ex1(:),G1H2(3),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(94),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(89),ex1(:),G1H2(3),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(95),n2h2(31))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(90),-8,nME,G2H4(42),n2h4(71))
  call Hloop_AV_Q(ntryL,G2H4(42),ex4(:),G2H2(96),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_ZQ_A(ntryL,G1H4(93),ex1(:),G1H2(3),ngZl,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(97),n2h2(32))
  call Hloop_ZQ_A(ntryL,G1H4(94),ex1(:),G1H2(3),ngZl,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(3),23,nME,G2H2(98),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(95),ex4(:),G1H2(3),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(99),n2h2(34))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(96),-4,nME,G2H4(54),n2h4(72))
  call Hloop_AV_Q(ntryL,G2H4(54),ex3(:),G2H2(100),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(3),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(101),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(100),ex4(:),G1H2(3),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(102),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(101),ex4(:),G1H2(3),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(103),n2h2(37))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-4,nME,G2H4(1),n2h4(73))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(104),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_QV_A(ntryL,G1H4(105),ex4(:),G1H2(3),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(105),n2h2(38))
  call Hloop_QV_A(ntryL,G1H4(106),ex4(:),G1H2(3),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(106),n2h2(39))
  call Hloop_TV_S(ntryL,G1H4(107),19,ex4(:),8,G2H2(107),m3h2x2(:,109),heltab2x4(:,:,109))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(108),-4,ex3(:),4,G2H2(108),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_TV_S(ntryL,G1H4(111),19,ex4(:),8,G2H2(109),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_TV_S(ntryL,G1H4(112),19,ex4(:),8,G2H2(110),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(3),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(111),n2h2(40))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-4,nME,G2H4(2),n2h4(75))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(112),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(3),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(113),n2h2(41))
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(3),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(3),27,nME,G2H2(114),n2h2(42))
  call Hloop_TV_S(ntryL,G1H4(119),19,ex4(:),8,G2H2(115),m3h2x2(:,117),heltab2x4(:,:,117))
call HGT_raise_alpha_OLR(G1H4(120),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(120),ex3(:),G1H2(3),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_TV_S(ntryL,G1H4(123),19,ex4(:),8,G2H2(116),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_TV_S(ntryL,G1H4(124),19,ex4(:),8,G2H2(117),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_UV_W(ntryL,G1H4(125),19,ex4(:),8,G2H2(118),m3h2x2(:,121),heltab2x4(:,:,121))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(126),ex3(:),G1H2(4),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_UV_W(ntryL,G1H4(129),19,ex4(:),8,G2H2(119),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_UV_W(ntryL,G1H4(130),19,ex4(:),8,G2H2(120),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_UV_W(ntryL,G1H4(131),19,ex4(:),8,G2H2(121),m3h2x2(:,125),heltab2x4(:,:,125))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(132),-4,ex3(:),4,G2H2(122),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_UV_W(ntryL,G1H4(135),19,ex4(:),8,G2H2(123),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_UV_W(ntryL,G1H4(136),19,ex4(:),8,G2H2(124),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AV_Q(ntryL,G1H4(137),ex3(:),G1H2(5),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(125),n2h2(43))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(138),-8,nME,G2H4(3),n2h4(79))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(126),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AV_Q(ntryL,G1H4(141),ex3(:),G1H2(5),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(127),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(142),ex3(:),G1H2(5),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(128),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(143),ex3(:),G1H2(5),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(129),n2h2(46))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(144),-8,nME,G2H4(4),n2h4(80))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(130),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_AV_Q(ntryL,G1H4(147),ex3(:),G1H2(5),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(131),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(148),ex3(:),G1H2(5),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(132),n2h2(48))
  call Hloop_SV_T(ntryL,G1H4(149),19,ex3(:),4,G2H2(133),m3h2x2(:,137),heltab2x4(:,:,137))
call HGT_OLR(G1H4(150),1,1,4)
call HGT_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(150),-8,ex4(:),8,G2H2(134),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_SV_T(ntryL,G1H4(153),19,ex3(:),4,G2H2(135),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_SV_T(ntryL,G1H4(154),19,ex3(:),4,G2H2(136),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_AV_Q(ntryL,G1H4(155),ex3(:),G1H2(5),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(137),n2h2(49))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(156),-8,nME,G2H4(74),n2h4(82))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(138),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AV_Q(ntryL,G1H4(159),ex3(:),G1H2(5),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(139),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(160),ex3(:),G1H2(5),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(5),23,nME,G2H2(140),n2h2(51))
  call Hloop_SV_T(ntryL,G1H4(161),19,ex3(:),4,G2H2(141),m3h2x2(:,145),heltab2x4(:,:,145))
call HGT_raise_alpha_OLR(G1H4(162),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(162),ex4(:),G1H2(5),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_SV_T(ntryL,G1H4(165),19,ex3(:),4,G2H2(142),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_SV_T(ntryL,G1H4(166),19,ex3(:),4,G2H2(143),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_UW_V(ntryL,G1H4(167),19,ex3(:),4,G2H2(144),m3h2x2(:,149),heltab2x4(:,:,149))
call HGT_OLR(G1H4(168),1,1,4)
call HGT_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(168),ex4(:),G1H2(6),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_UW_V(ntryL,G1H4(171),19,ex3(:),4,G2H2(145),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_UW_V(ntryL,G1H4(172),19,ex3(:),4,G2H2(146),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_UW_V(ntryL,G1H4(173),19,ex3(:),4,G2H2(147),m3h2x2(:,153),heltab2x4(:,:,153))
call HGT_raise_alpha_OLR(G1H4(174),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(174),-8,ex4(:),8,G2H2(148),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_UW_V(ntryL,G1H4(177),19,ex3(:),4,G2H2(149),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_UW_V(ntryL,G1H4(178),19,ex3(:),4,G2H2(150),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_AV_Q(ntryL,G1H4(179),ex4(:),G1H2(7),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(151),n2h2(52))
call HGT_OLR(G1H4(180),1,1,4)
call HGT_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(180),-4,nME,G2H4(65),n2h4(86))
  call Hloop_QV_A(ntryL,G2H4(65),ex3(:),G2H2(152),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_AV_Q(ntryL,G1H4(183),ex4(:),G1H2(7),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(153),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(184),ex4(:),G1H2(7),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(154),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(185),ex4(:),G1H2(7),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(155),n2h2(55))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(186),-4,nME,G2H4(78),n2h4(87))
  call Hloop_QV_A(ntryL,G2H4(78),ex3(:),G2H2(156),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_AV_Q(ntryL,G1H4(189),ex4(:),G1H2(7),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(157),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H4(190),ex4(:),G1H2(7),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(158),n2h2(57))
  call Hloop_SV_T(ntryL,G1H4(191),19,ex4(:),8,G2H2(159),m3h2x2(:,165),heltab2x4(:,:,165))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(192),-4,ex3(:),4,G2H2(160),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_SV_T(ntryL,G1H4(195),19,ex4(:),8,G2H2(161),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_SV_T(ntryL,G1H4(196),19,ex4(:),8,G2H2(162),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_AV_Q(ntryL,G1H4(197),ex4(:),G1H2(7),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(163),n2h2(58))
call HGT_OLR(G1H4(198),1,1,4)
call HGT_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(198),-4,nME,G2H4(70),n2h4(89))
  call Hloop_QV_A(ntryL,G2H4(70),ex3(:),G2H2(164),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_AV_Q(ntryL,G1H4(201),ex4(:),G1H2(7),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(165),n2h2(59))
  call Hloop_AV_Q(ntryL,G1H4(202),ex4(:),G1H2(7),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(7),27,nME,G2H2(166),n2h2(60))
  call Hloop_SV_T(ntryL,G1H4(203),19,ex4(:),8,G2H2(167),m3h2x2(:,173),heltab2x4(:,:,173))
call HGT_raise_alpha_OLR(G1H4(204),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(204),ex3(:),G1H2(7),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_SV_T(ntryL,G1H4(207),19,ex4(:),8,G2H2(168),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_SV_T(ntryL,G1H4(208),19,ex4(:),8,G2H2(169),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_UW_V(ntryL,G1H4(209),19,ex4(:),8,G2H2(170),m3h2x2(:,177),heltab2x4(:,:,177))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(210),ex3(:),G1H2(8),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_UW_V(ntryL,G1H4(213),19,ex4(:),8,G2H2(171),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_UW_V(ntryL,G1H4(214),19,ex4(:),8,G2H2(172),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_UW_V(ntryL,G1H4(215),19,ex4(:),8,G2H2(173),m3h2x2(:,181),heltab2x4(:,:,181))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(216),-4,ex3(:),4,G2H2(174),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_UW_V(ntryL,G1H4(219),19,ex4(:),8,G2H2(175),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_UW_V(ntryL,G1H4(220),19,ex4(:),8,G2H2(176),m3h2x2(:,184),heltab2x4(:,:,184))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(90)])
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,1),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(3),mass5set(:,7),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(3),mass5set(:,7),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,1),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(118),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(4),mass5set(:,7),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),4,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(4),mass5set(:,7),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(115),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(144),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(5),mass5set(:,7),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(5),mass5set(:,7),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(141),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(170),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hotf_5pt_reduction(G2H2(159),RedSet_5(6),mass5set(:,7),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_5pt_reduction(G2H2(173),RedSet_5(6),mass5set(:,7),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(167),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(1),mass4set(:,1),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(82),10,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(1),mass4set(:,1),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),10,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(2),mass4set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),9,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,1),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(97),9,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(1),mass5set(:,2),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(1),mass4set(:,2),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),10,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(1),mass5set(:,3),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(1),mass4set(:,3),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(119),10,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(1),mass5set(:,4),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(1),mass4set(:,4),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),10,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(3),mass5set(:,5),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(3),mass4set(:,5),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(141),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(3),mass5set(:,6),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(3),mass4set(:,6),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(152),12,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(3),mass4set(:,7),  & 
G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(157),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(3),mass5set(:,8),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(3),mass4set(:,8),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(3),mass4set(:,7),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(173),12,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(2),mass5set(:,2),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),8,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(2),mass4set(:,2),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(184),9,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(2),mass5set(:,3),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),8,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(2),mass4set(:,3),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),9,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(2),mass5set(:,4),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(2),mass4set(:,4),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),2)
  call HG1shiftOLR(G1H2(206),9,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(4),mass5set(:,5),  & 
G1H2(210),G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(211),4,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(3),mass4set(:,5),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(217),12,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(4),mass5set(:,6),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),4,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(3),mass4set(:,6),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),2)
  call HG1shiftOLR(G1H2(228),12,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(3),mass4set(:,7),  & 
G1H2(232),G1H2(233),G1H2(234),G1H2(235),G1H2(236),2)
  call HG1shiftOLR(G1H2(233),12,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(4),mass5set(:,8),  & 
G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(238),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(3),mass4set(:,8),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(244),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(117),ex3(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(120),ex3(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(3),mass4set(:,7),  & 
G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(249),12,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(5),mass5set(:,5),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(4),mass4set(:,5),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(260),12,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(5),mass5set(:,6),  & 
G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),2)
  call HG1shiftOLR(G1H2(265),8,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(4),mass4set(:,6),  & 
G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(271),12,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(4),mass4set(:,7),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(276),12,2)
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(5),mass5set(:,8),  & 
G1H2(280),G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),2)
  call HG1shiftOLR(G1H2(281),8,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(4),mass4set(:,8),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(287),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(143),ex4(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(146),ex4(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hotf_4pt_reduction(G2H2(150),RedSet_4(4),mass4set(:,7),  & 
G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(292),12,2)
  call Hotf_5pt_reduction(G2H2(151),RedSet_5(6),mass5set(:,5),  & 
G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),G1H2(301),2)
  call HG1shiftOLR(G1H2(297),4,2)
  call Hotf_4pt_reduction(G2H2(154),RedSet_4(4),mass4set(:,5),  & 
G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(303),12,2)
  call Hotf_5pt_reduction(G2H2(155),RedSet_5(6),mass5set(:,6),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),4,2)
  call Hotf_4pt_reduction(G2H2(158),RedSet_4(4),mass4set(:,6),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),12,2)
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(4),mass4set(:,7),  & 
G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(319),12,2)
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(6),mass5set(:,8),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),4,2)
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(4),mass4set(:,8),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),2)
  call HG1shiftOLR(G1H2(330),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(169),ex3(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(172),ex3(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_4pt_reduction(G2H2(176),RedSet_4(4),mass4set(:,7),  & 
G1H2(334),G1H2(335),G1H2(336),G1H2(337),G1H2(338),2)
  call HG1shiftOLR(G1H2(335),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(275),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(291),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(318),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(334),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(302),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(328)])
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(9),23,ex4(:),8,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(10),0,ex4(:),8,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(81),23,ex4(:),8,G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(16),0,ex4(:),8,G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(86),23,ex4(:),8,G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(22),0,ex4(:),8,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(156),23,ex4(:),8,G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),23,ex4(:),8,G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),0,ex4(:),8,G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(172),23,ex4(:),8,G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(33),23,ex4(:),8,G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(34),0,ex4(:),8,G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(91),23,ex4(:),8,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(39),23,ex4(:),8,G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),0,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(96),23,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(45),27,ex3(:),4,G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(46),0,ex3(:),4,G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(232),27,ex3(:),4,G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(51),27,ex3(:),4,G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),0,ex3(:),4,G2tensor(47),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(248),27,ex3(:),4,G2tensor(48),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(57),23,ex4(:),8,G2tensor(49),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(58),0,ex4(:),8,G2tensor(50),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(275),23,ex4(:),8,G2tensor(51),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(63),23,ex4(:),8,G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(64),0,ex4(:),8,G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(291),23,ex4(:),8,G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(69),27,ex3(:),4,G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(70),0,ex3(:),4,G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(318),27,ex3(:),4,G2tensor(57),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(75),27,ex3(:),4,G2tensor(58),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(76),0,ex3(:),4,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(334),27,ex3(:),4,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(82),2,ex4(:),8,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(87),2,ex4(:),8,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(92),1,ex4(:),8,G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(97),1,ex4(:),8,G2tensor(64),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(65),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(66),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(67),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(68),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(69),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(70),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(71),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(72),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(73),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(74),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(75),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(76),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(77),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(78),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(79),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(80),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(81),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(82),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(83),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(84),n2h1(36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(157),4,ex4(:),8,G2tensor(85),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(86),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(87),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(88),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(89),n2h1(41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(173),4,ex4(:),8,G2tensor(90),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hloop_QV_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(91),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(92),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(93),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(94),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(188),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(95),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(96),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(97),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(98),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(99),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(100),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(101),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(102),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(103),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(104),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(216),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(105),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(217),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(106),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(221),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(107),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(222),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(108),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(227),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(109),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(228),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(110),n2h1(62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(233),8,ex3(:),4,G2tensor(111),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hloop_QV_A(ntryL,G1H2(237),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(112),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(238),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(113),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(243),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(114),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nME,G2tensor(115),n2h1(67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(249),8,ex3(:),4,G2tensor(116),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hloop_AV_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(117),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(118),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(119),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(120),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(121),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(122),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(270),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(123),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(124),n2h1(76))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(276),4,ex4(:),8,G2tensor(125),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hloop_AV_Q(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(126),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(281),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(127),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(128),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(287),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(129),n2h1(81))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(292),4,ex4(:),8,G2tensor(130),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hloop_AV_Q(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(131),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(297),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(132),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(133),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(303),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(134),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(135),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(136),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(137),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(314),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(138),n2h1(90))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(319),8,ex3(:),4,G2tensor(139),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hloop_AV_Q(ntryL,G1H2(323),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(140),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(324),ex3(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(141),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(329),ex3(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(142),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(330),ex3(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nME,G2tensor(143),n2h1(95))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(335),8,ex3(:),4,G2tensor(144),m3h2x1(:,144),heltab2x2(:,:,144))
  call ol_merge_tensors(G2tensor(28),[G2tensor(25),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(31),G2tensor(4),G2tensor(3)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(37),G2tensor(6),G2tensor(5)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(43),G2tensor(8),G2tensor(7)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(49),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(55),G2tensor(12),G2tensor(11)])
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(3),mass5set(:,7),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(4),mass5set(:,7),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(5),mass5set(:,7),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(6),mass5set(:,7),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(1),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(1),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(1),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(3),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(3),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(3),mass5set(:,8),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(2),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(2),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(4),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(4),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(4),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(5),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(5),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(5),mass5set(:,8),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(6),mass5set(:,5),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(6),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(6),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(8),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(5),16,nME,G1H16(5),n2h16(25))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(6),16,nME,G1H16(6),n2h16(26))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(7),16,nME,G1H16(7),n2h16(27))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(8),16,nME,G1H16(8),n2h16(28))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,135),heltab2x32(:,:,135))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(12),m3h2x16(:,136),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(14),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(16),m3h2x16(:,140),heltab2x32(:,:,140))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,141),heltab2x32(:,:,141))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(18),m3h2x16(:,142),heltab2x32(:,:,142))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,143),heltab2x32(:,:,143))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,144),heltab2x32(:,:,144))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,145),heltab2x32(:,:,145))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,146),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,147),heltab2x32(:,:,147))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,148),heltab2x32(:,:,148))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,149),heltab2x32(:,:,149))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,150),heltab2x32(:,:,150))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,152),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,153),heltab2x32(:,:,153))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,154),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,155),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,156),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,157),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,158),heltab2x32(:,:,158))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,159),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,160),heltab2x32(:,:,160))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,161),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,162),heltab2x32(:,:,162))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,163),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,164),heltab2x32(:,:,164))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,165),heltab2x32(:,:,165))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,166),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,170),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,177),heltab2x32(:,:,177))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,178),heltab2x32(:,:,178))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,179),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,181),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,183),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,184),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,187),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,188),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_Q_A(ntryL,G0H16(33),16,nME,G1H16(41),n2h16(29))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(34),16,nME,G1H16(42),n2h16(30))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_Q_A(ntryL,G0H16(35),16,0,G1H16(43),n2h16(31))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(36),16,0,G1H16(44),n2h16(32))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G0H16(37),16,nME,G1H16(45),n2h16(33))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(38),16,nME,G1H16(46),n2h16(34))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G0H16(39),16,0,G1H16(47),n2h16(35))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H16(40),16,0,G1H16(48),n2h16(36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,197),heltab2x32(:,:,197))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,198),heltab2x32(:,:,198))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,199),heltab2x32(:,:,199))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,200),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,201),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(54),m3h2x16(:,202),heltab2x32(:,:,202))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,203),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(56),m3h2x16(:,204),heltab2x32(:,:,204))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,205),heltab2x32(:,:,205))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(58),m3h2x16(:,206),heltab2x32(:,:,206))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,207),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(60),m3h2x16(:,208),heltab2x32(:,:,208))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,209),heltab2x32(:,:,209))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,210),heltab2x32(:,:,210))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,211),heltab2x32(:,:,211))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,212),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,213),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,214),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,215),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,216),heltab2x32(:,:,216))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,217),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,218),heltab2x32(:,:,218))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,219),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,220),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,221),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,222),heltab2x32(:,:,222))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,223),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,224),heltab2x32(:,:,224))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,225),heltab2x32(:,:,225))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,226),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(71),m3h2x16(:,227),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,228),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,229),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,230),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,231),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,232),heltab2x32(:,:,232))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(73),m3h2x16(:,233),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,234),heltab2x32(:,:,234))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,235),heltab2x32(:,:,235))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(76),m3h2x16(:,236),heltab2x32(:,:,236))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,237),heltab2x32(:,:,237))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,238),heltab2x32(:,:,238))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,239),heltab2x32(:,:,239))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,240),heltab2x32(:,:,240))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,241),heltab2x32(:,:,241))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,242),heltab2x32(:,:,242))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,243),heltab2x32(:,:,243))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,244),heltab2x32(:,:,244))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,245),heltab2x32(:,:,245))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,246),heltab2x32(:,:,246))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,247),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,248),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,249),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,250),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,251),heltab2x32(:,:,251))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,252),heltab2x32(:,:,252))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,253),heltab2x32(:,:,253))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(82),m3h2x16(:,254),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,255),heltab2x32(:,:,255))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,256),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,257),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,258),heltab2x32(:,:,258))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,259),heltab2x32(:,:,259))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,260),heltab2x32(:,:,260))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,261),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,262),heltab2x32(:,:,262))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,263),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,264),heltab2x32(:,:,264))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,265),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,266),heltab2x32(:,:,266))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,267),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,268),heltab2x32(:,:,268))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(61),16,nME,G1H16(89),n2h16(37))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(61),16,nME,G1H16(90),n2h16(38))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(61),16,nME,G1H16(91),n2h16(39))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,272),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(61),16,nME,G1H16(92),n2h16(40))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(95),m3h2x16(:,275),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,276),heltab2x32(:,:,276))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(97),m3h2x16(:,277),heltab2x32(:,:,277))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,278),heltab2x32(:,:,278))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(99),m3h2x16(:,279),heltab2x32(:,:,279))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,280),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(101),m3h2x16(:,281),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,282),heltab2x32(:,:,282))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,286),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,287),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,288),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,289),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,290),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,291),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,292),heltab2x32(:,:,292))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,293),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,294),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,295),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,296),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,297),heltab2x32(:,:,297))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,298),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,299),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,300),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,301),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,302),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,303),heltab2x32(:,:,303))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,304),heltab2x32(:,:,304))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,305),heltab2x32(:,:,305))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,306),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,307),heltab2x32(:,:,307))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,308),heltab2x32(:,:,308))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,309),heltab2x32(:,:,309))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,310),heltab2x32(:,:,310))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,311),heltab2x32(:,:,311))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,312),heltab2x32(:,:,312))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,313),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,314),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,315),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,316),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,317),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,318),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,319),heltab2x32(:,:,319))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,320),heltab2x32(:,:,320))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,321),heltab2x32(:,:,321))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,322),heltab2x32(:,:,322))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,323),heltab2x32(:,:,323))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,324),heltab2x32(:,:,324))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,325),heltab2x32(:,:,325))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,326),heltab2x32(:,:,326))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,329),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(125),n2h16(41))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(126),n2h16(42))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(127),n2h16(43))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(128),n2h16(44))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(129),n2h16(45))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(130),n2h16(46))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(131),n2h16(47))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(132),n2h16(48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(133),m3h2x16(:,337),heltab2x32(:,:,337))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(134),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(135),m3h2x16(:,339),heltab2x32(:,:,339))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(136),m3h2x16(:,340),heltab2x32(:,:,340))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(137),m3h2x16(:,341),heltab2x32(:,:,341))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,342),heltab2x32(:,:,342))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(139),m3h2x16(:,343),heltab2x32(:,:,343))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(140),m3h2x16(:,344),heltab2x32(:,:,344))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(141),m3h2x16(:,345),heltab2x32(:,:,345))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,346),heltab2x32(:,:,346))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(143),m3h2x16(:,347),heltab2x32(:,:,347))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(144),m3h2x16(:,348),heltab2x32(:,:,348))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(145),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(146),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(147),m3h2x16(:,351),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,352),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,353),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,354),heltab2x32(:,:,354))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,355),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,356),heltab2x32(:,:,356))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,357),heltab2x32(:,:,357))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,358),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,359),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,360),heltab2x32(:,:,360))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(149),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(151),m3h2x16(:,363),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(152),m3h2x16(:,364),heltab2x32(:,:,364))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(153),m3h2x16(:,365),heltab2x32(:,:,365))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(154),m3h2x16(:,366),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(155),m3h2x16(:,367),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,368),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(157),m3h2x16(:,369),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(158),m3h2x16(:,370),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,371),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,372),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,373),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,374),heltab2x32(:,:,374))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,375),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,376),heltab2x32(:,:,376))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,377),heltab2x32(:,:,377))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,378),heltab2x32(:,:,378))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,379),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,380),heltab2x32(:,:,380))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,381),heltab2x32(:,:,381))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,382),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,383),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,384),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,385),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,386),heltab2x32(:,:,386))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(107),m3h2x16(:,387),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(108),m3h2x16(:,388),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(161),m3h2x16(:,389),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(162),m3h2x16(:,390),heltab2x32(:,:,390))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,391),heltab2x32(:,:,391))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(164),m3h2x16(:,392),heltab2x32(:,:,392))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(165),m3h2x16(:,393),heltab2x32(:,:,393))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(166),m3h2x16(:,394),heltab2x32(:,:,394))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,395),heltab2x32(:,:,395))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,396),heltab2x32(:,:,396))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,397),heltab2x32(:,:,397))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,398),heltab2x32(:,:,398))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,399),heltab2x32(:,:,399))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(172),m3h2x16(:,400),heltab2x32(:,:,400))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(109),m3h2x16(:,401),heltab2x32(:,:,401))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(110),m3h2x16(:,402),heltab2x32(:,:,402))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(111),m3h2x16(:,403),heltab2x32(:,:,403))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(112),m3h2x16(:,404),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(113),m3h2x16(:,405),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(114),m3h2x16(:,406),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,407),heltab2x32(:,:,407))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,408),heltab2x32(:,:,408))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,409),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(173),n2h16(49))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,410),heltab2x32(:,:,410))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(174),n2h16(50))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,411),heltab2x32(:,:,411))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(175),n2h16(51))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,412),heltab2x32(:,:,412))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(176),n2h16(52))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,413),heltab2x32(:,:,413))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(178),m3h2x16(:,414),heltab2x32(:,:,414))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,415),heltab2x32(:,:,415))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(180),m3h2x16(:,416),heltab2x32(:,:,416))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,417),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(182),m3h2x16(:,418),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,419),heltab2x32(:,:,419))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(184),m3h2x16(:,420),heltab2x32(:,:,420))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,421),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(186),m3h2x16(:,422),heltab2x32(:,:,422))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,423),heltab2x32(:,:,423))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(188),m3h2x16(:,424),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,425),heltab2x32(:,:,425))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(190),m3h2x16(:,426),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,427),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(192),m3h2x16(:,428),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,429),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,430),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(193),m3h2x16(:,431),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(194),m3h2x16(:,432),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,433),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(196),m3h2x16(:,434),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,435),heltab2x32(:,:,435))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,436),heltab2x32(:,:,436))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,437),heltab2x32(:,:,437))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,438),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,439),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,440),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,441),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(198),m3h2x16(:,442),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(125),m3h2x16(:,443),heltab2x32(:,:,443))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,444),heltab2x32(:,:,444))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(127),m3h2x16(:,445),heltab2x32(:,:,445))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,446),heltab2x32(:,:,446))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(129),m3h2x16(:,447),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(130),m3h2x16(:,448),heltab2x32(:,:,448))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(131),m3h2x16(:,449),heltab2x32(:,:,449))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(132),m3h2x16(:,450),heltab2x32(:,:,450))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(199),m3h2x16(:,451),heltab2x32(:,:,451))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(200),m3h2x16(:,452),heltab2x32(:,:,452))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,453),heltab2x32(:,:,453))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,454),heltab2x32(:,:,454))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,455),heltab2x32(:,:,455))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,456),heltab2x32(:,:,456))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(137),m3h2x16(:,457),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(138),m3h2x16(:,458),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(201),m3h2x16(:,459),heltab2x32(:,:,459))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(202),m3h2x16(:,460),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(203),m3h2x16(:,461),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(204),m3h2x16(:,462),heltab2x32(:,:,462))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,463),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,464),heltab2x32(:,:,464))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(205),m3h2x16(:,465),heltab2x32(:,:,465))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,466),heltab2x32(:,:,466))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(207),m3h2x16(:,467),heltab2x32(:,:,467))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,468),heltab2x32(:,:,468))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,469),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(209),n2h16(53))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,470),heltab2x32(:,:,470))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(210),n2h16(54))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,471),heltab2x32(:,:,471))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(211),n2h16(55))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,472),heltab2x32(:,:,472))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(212),n2h16(56))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,473),heltab2x32(:,:,473))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(213),n2h16(57))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,474),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(214),n2h16(58))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,475),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(215),n2h16(59))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,476),heltab2x32(:,:,476))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(216),n2h16(60))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(217),m3h2x16(:,477),heltab2x32(:,:,477))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,478),heltab2x32(:,:,478))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,479),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(220),m3h2x16(:,480),heltab2x32(:,:,480))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,481),heltab2x32(:,:,481))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(222),m3h2x16(:,482),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,483),heltab2x32(:,:,483))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(224),m3h2x16(:,484),heltab2x32(:,:,484))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,485),heltab2x32(:,:,485))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(226),m3h2x16(:,486),heltab2x32(:,:,486))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,487),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(228),m3h2x16(:,488),heltab2x32(:,:,488))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,489),heltab2x32(:,:,489))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,490),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,491),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,492),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(233),m3h2x16(:,493),heltab2x32(:,:,493))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,494),heltab2x32(:,:,494))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(235),m3h2x16(:,495),heltab2x32(:,:,495))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(236),m3h2x16(:,496),heltab2x32(:,:,496))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,497),heltab2x32(:,:,497))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,498),heltab2x32(:,:,498))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,499),heltab2x32(:,:,499))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,500),heltab2x32(:,:,500))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(237),m3h2x16(:,501),heltab2x32(:,:,501))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(238),m3h2x16(:,502),heltab2x32(:,:,502))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,503),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,504),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,505),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,506),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,507),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,508),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,509),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,510),heltab2x32(:,:,510))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,511),heltab2x32(:,:,511))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,512),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(241),m3h2x16(:,513),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(242),m3h2x16(:,514),heltab2x32(:,:,514))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(243),m3h2x16(:,515),heltab2x32(:,:,515))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(244),m3h2x16(:,516),heltab2x32(:,:,516))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(153),m3h2x16(:,517),heltab2x32(:,:,517))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,518),heltab2x32(:,:,518))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(155),m3h2x16(:,519),heltab2x32(:,:,519))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,520),heltab2x32(:,:,520))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(157),m3h2x16(:,521),heltab2x32(:,:,521))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,522),heltab2x32(:,:,522))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(159),m3h2x16(:,523),heltab2x32(:,:,523))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,524),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(245),m3h2x16(:,525),heltab2x32(:,:,525))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(246),m3h2x16(:,526),heltab2x32(:,:,526))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(247),m3h2x16(:,527),heltab2x32(:,:,527))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(248),m3h2x16(:,528),heltab2x32(:,:,528))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,529),heltab2x32(:,:,529))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,530),heltab2x32(:,:,530))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(163),m3h2x16(:,531),heltab2x32(:,:,531))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(164),m3h2x16(:,532),heltab2x32(:,:,532))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(165),m3h2x16(:,533),heltab2x32(:,:,533))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(166),m3h2x16(:,534),heltab2x32(:,:,534))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(167),m3h2x16(:,535),heltab2x32(:,:,535))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(168),m3h2x16(:,536),heltab2x32(:,:,536))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(249),m3h2x16(:,537),heltab2x32(:,:,537))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(250),m3h2x16(:,538),heltab2x32(:,:,538))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(251),m3h2x16(:,539),heltab2x32(:,:,539))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(252),m3h2x16(:,540),heltab2x32(:,:,540))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(169),m3h2x16(:,541),heltab2x32(:,:,541))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(170),m3h2x16(:,542),heltab2x32(:,:,542))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(171),m3h2x16(:,543),heltab2x32(:,:,543))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(172),m3h2x16(:,544),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(253),m3h2x16(:,545),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(254),m3h2x16(:,546),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(255),m3h2x16(:,547),heltab2x32(:,:,547))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(256),m3h2x16(:,548),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[16,5,2,8],[nME,nMH,nME,nME],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,549),heltab2x32(:,:,549))
  call Hloop_A_Q(ntryL,G0H16(173),16,nME,G1H16(257),n2h16(61))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[16,5,2,8],[nME,nMZ,nME,nME],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,550),heltab2x32(:,:,550))
  call Hloop_A_Q(ntryL,G0H16(173),16,nME,G1H16(258),n2h16(62))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(259),m3h2x16(:,551),heltab2x32(:,:,551))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[16,5,2,8],[nME,0,nME,nME],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,552),heltab2x32(:,:,552))
  call Hloop_A_Q(ntryL,G0H16(173),16,nME,G1H16(260),n2h16(63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[16,5,2,8],[nME,nMZ,nME,nME],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,553),heltab2x32(:,:,553))
  call Hloop_A_Q(ntryL,G0H16(173),16,nME,G1H16(261),n2h16(64))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,554),heltab2x32(:,:,554))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(174),m3h2x16(:,555),heltab2x32(:,:,555))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(262),m3h2x16(:,556),heltab2x32(:,:,556))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(263),m3h2x16(:,557),heltab2x32(:,:,557))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,558),heltab2x32(:,:,558))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,559),heltab2x32(:,:,559))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(264),m3h2x16(:,560),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[16,2,5,8],[nME,nMH,nME,nME],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,561),heltab2x32(:,:,561))
  call Hloop_Q_A(ntryL,G0H16(177),16,nME,G1H16(265),n2h16(65))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[16,2,5,8],[nME,nMZ,nME,nME],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,562),heltab2x32(:,:,562))
  call Hloop_Q_A(ntryL,G0H16(177),16,nME,G1H16(266),n2h16(66))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(267),m3h2x16(:,563),heltab2x32(:,:,563))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,2,5,8],[nME,0,nME,nME],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,564),heltab2x32(:,:,564))
  call Hloop_Q_A(ntryL,G0H16(177),16,nME,G1H16(268),n2h16(67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,2,5,8],[nME,nMZ,nME,nME],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,565),heltab2x32(:,:,565))
  call Hloop_Q_A(ntryL,G0H16(177),16,nME,G1H16(269),n2h16(68))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(270),m3h2x16(:,566),heltab2x32(:,:,566))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,567),heltab2x32(:,:,567))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,568),heltab2x32(:,:,568))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,569),heltab2x32(:,:,569))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,570),heltab2x32(:,:,570))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(271),m3h2x16(:,571),heltab2x32(:,:,571))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(272),m3h2x16(:,572),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[16,6,1,8],[nME,nMH,nME,nME],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,573),heltab2x32(:,:,573))
  call Hloop_Q_A(ntryL,G0H16(181),16,nME,G1H16(273),n2h16(69))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[16,6,1,8],[nME,nMZ,nME,nME],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,574),heltab2x32(:,:,574))
  call Hloop_Q_A(ntryL,G0H16(181),16,nME,G1H16(274),n2h16(70))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(275),m3h2x16(:,575),heltab2x32(:,:,575))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[16,6,1,8],[nME,0,nME,nME],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,576),heltab2x32(:,:,576))
  call Hloop_Q_A(ntryL,G0H16(181),16,nME,G1H16(276),n2h16(71))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[16,6,1,8],[nME,nMZ,nME,nME],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,577),heltab2x32(:,:,577))
  call Hloop_Q_A(ntryL,G0H16(181),16,nME,G1H16(277),n2h16(72))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,578),heltab2x32(:,:,578))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,579),heltab2x32(:,:,579))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(278),m3h2x16(:,580),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(279),m3h2x16(:,581),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,582),heltab2x32(:,:,582))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,583),heltab2x32(:,:,583))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(280),m3h2x16(:,584),heltab2x32(:,:,584))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[16,1,6,8],[nME,nMH,nME,nME],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,585),heltab2x32(:,:,585))
  call Hloop_A_Q(ntryL,G0H16(185),16,nME,G1H16(281),n2h16(73))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[16,1,6,8],[nME,nMZ,nME,nME],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,586),heltab2x32(:,:,586))
  call Hloop_A_Q(ntryL,G0H16(185),16,nME,G1H16(282),n2h16(74))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(283),m3h2x16(:,587),heltab2x32(:,:,587))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,1,6,8],[nME,0,nME,nME],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,588),heltab2x32(:,:,588))
  call Hloop_A_Q(ntryL,G0H16(185),16,nME,G1H16(284),n2h16(75))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,1,6,8],[nME,nMZ,nME,nME],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,589),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G0H16(185),16,nME,G1H16(285),n2h16(76))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(286),m3h2x16(:,590),heltab2x32(:,:,590))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,591),heltab2x32(:,:,591))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,592),heltab2x32(:,:,592))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,593),heltab2x32(:,:,593))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,594),heltab2x32(:,:,594))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(287),m3h2x16(:,595),heltab2x32(:,:,595))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(288),m3h2x16(:,596),heltab2x32(:,:,596))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,4,2,9],[nME,nME,nMH,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,597),heltab2x32(:,:,597))
  call Hloop_Q_A(ntryL,G0H16(189),16,nME,G1H16(289),n2h16(77))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,4,2,9],[nME,nME,nMZ,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,598),heltab2x32(:,:,598))
  call Hloop_Q_A(ntryL,G0H16(189),16,nME,G1H16(290),n2h16(78))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(291),m3h2x16(:,599),heltab2x32(:,:,599))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,4,2,9],[nME,nME,0,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,600),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G0H16(189),16,nME,G1H16(292),n2h16(79))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[16,4,2,9],[nME,nME,nMZ,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,601),heltab2x32(:,:,601))
  call Hloop_Q_A(ntryL,G0H16(189),16,nME,G1H16(293),n2h16(80))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,602),heltab2x32(:,:,602))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,603),heltab2x32(:,:,603))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(294),m3h2x16(:,604),heltab2x32(:,:,604))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(295),m3h2x16(:,605),heltab2x32(:,:,605))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,606),heltab2x32(:,:,606))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,607),heltab2x32(:,:,607))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(296),m3h2x16(:,608),heltab2x32(:,:,608))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[16,2,9,4],[nME,nMH,nME,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,609),heltab2x32(:,:,609))
  call Hloop_Q_A(ntryL,G0H16(193),16,nME,G1H16(297),n2h16(81))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[16,2,9,4],[nME,nMZ,nME,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,610),heltab2x32(:,:,610))
  call Hloop_Q_A(ntryL,G0H16(193),16,nME,G1H16(298),n2h16(82))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(299),m3h2x16(:,611),heltab2x32(:,:,611))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[16,2,9,4],[nME,0,nME,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,612),heltab2x32(:,:,612))
  call Hloop_Q_A(ntryL,G0H16(193),16,nME,G1H16(300),n2h16(83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[16,2,9,4],[nME,nMZ,nME,nME],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,613),heltab2x32(:,:,613))
  call Hloop_Q_A(ntryL,G0H16(193),16,nME,G1H16(301),n2h16(84))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(302),m3h2x16(:,614),heltab2x32(:,:,614))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,615),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,616),heltab2x32(:,:,616))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,617),heltab2x32(:,:,617))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,618),heltab2x32(:,:,618))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(303),m3h2x16(:,619),heltab2x32(:,:,619))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(304),m3h2x16(:,620),heltab2x32(:,:,620))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[16,4,1,10],[nME,nME,nMH,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,621),heltab2x32(:,:,621))
  call Hloop_A_Q(ntryL,G0H16(197),16,nME,G1H16(305),n2h16(85))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[16,4,1,10],[nME,nME,nMZ,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,622),heltab2x32(:,:,622))
  call Hloop_A_Q(ntryL,G0H16(197),16,nME,G1H16(306),n2h16(86))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(307),m3h2x16(:,623),heltab2x32(:,:,623))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[16,4,1,10],[nME,nME,0,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,624),heltab2x32(:,:,624))
  call Hloop_A_Q(ntryL,G0H16(197),16,nME,G1H16(308),n2h16(87))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[16,4,1,10],[nME,nME,nMZ,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,625),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H16(197),16,nME,G1H16(309),n2h16(88))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,626),heltab2x32(:,:,626))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,627),heltab2x32(:,:,627))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(310),m3h2x16(:,628),heltab2x32(:,:,628))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(311),m3h2x16(:,629),heltab2x32(:,:,629))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,630),heltab2x32(:,:,630))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,631),heltab2x32(:,:,631))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(312),m3h2x16(:,632),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[16,1,10,4],[nME,nMH,nME,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,633),heltab2x32(:,:,633))
  call Hloop_A_Q(ntryL,G0H16(201),16,nME,G1H16(313),n2h16(89))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[16,1,10,4],[nME,nMZ,nME,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,634),heltab2x32(:,:,634))
  call Hloop_A_Q(ntryL,G0H16(201),16,nME,G1H16(314),n2h16(90))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(315),m3h2x16(:,635),heltab2x32(:,:,635))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[16,1,10,4],[nME,0,nME,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,636),heltab2x32(:,:,636))
  call Hloop_A_Q(ntryL,G0H16(201),16,nME,G1H16(316),n2h16(91))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[16,1,10,4],[nME,nMZ,nME,nME],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,637),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H16(201),16,nME,G1H16(317),n2h16(92))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(318),m3h2x16(:,638),heltab2x32(:,:,638))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,639),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,640),heltab2x32(:,:,640))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,641),heltab2x32(:,:,641))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(204),m3h2x16(:,642),heltab2x32(:,:,642))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(319),m3h2x16(:,643),heltab2x32(:,:,643))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(320),m3h2x16(:,644),heltab2x32(:,:,644))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[17,2,4,8],[nMH,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngH,m3h4x8(:,1),heltab2x32(:,:,645))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[17,2,4,8],[nMZ,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(18),ngX,m3h4x8(:,2),heltab2x32(:,:,646))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(19),ngPnl,m3h4x8(:,3),heltab2x32(:,:,647))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(12),n2h8(81))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[17,2,4,8],[0,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(19),m3h4x8(:,4),heltab2x32(:,:,648))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[17,2,4,8],[nMZ,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(20),ngZl,m3h4x8(:,5),heltab2x32(:,:,649))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,6),heltab2x32(:,:,650))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(23),n2h8(82))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,7),heltab2x32(:,:,651))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(24),n2h8(83))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,8),heltab2x32(:,:,652))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(27),n2h8(84))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,9),heltab2x32(:,:,653))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(28),n2h8(85))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,10),heltab2x32(:,:,654))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(29),n2h8(86))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPnl,m3h4x8(:,11),heltab2x32(:,:,655))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(30),n2h8(87))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,12),heltab2x32(:,:,656))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(31),n2h8(88))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[17,2,8,4],[nMH,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngH,m3h4x8(:,13),heltab2x32(:,:,657))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[17,2,8,4],[nMZ,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(22),ngX,m3h4x8(:,14),heltab2x32(:,:,658))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(23),ngPnl,m3h4x8(:,15),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H8(23),17,0,G1H8(32),n2h8(89))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[17,2,8,4],[0,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(23),m3h4x8(:,16),heltab2x32(:,:,660))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[17,2,8,4],[nMZ,nME,nME,nME],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(24),ngZl,m3h4x8(:,17),heltab2x32(:,:,661))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,18),heltab2x32(:,:,662))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(41),n2h8(90))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,19),heltab2x32(:,:,663))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(42),n2h8(91))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,20),heltab2x32(:,:,664))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(43),n2h8(92))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,21),heltab2x32(:,:,665))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(44),n2h8(93))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,22),heltab2x32(:,:,666))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(53),n2h8(94))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPnl,m3h4x8(:,23),heltab2x32(:,:,667))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(54),n2h8(95))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(25),m3h4x8(:,24),heltab2x32(:,:,668))
  call Hloop_Q_A(ntryL,G0H8(25),17,0,G1H8(55),n2h8(96))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[18,1,4,8],[nMH,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngH,m3h4x8(:,25),heltab2x32(:,:,669))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[18,1,4,8],[nMZ,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(26),ngX,m3h4x8(:,26),heltab2x32(:,:,670))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPln,m3h4x8(:,27),heltab2x32(:,:,671))
  call Hloop_A_Q(ntryL,G0H8(27),18,0,G1H8(56),n2h8(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[18,1,4,8],[0,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,28),heltab2x32(:,:,672))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[18,1,4,8],[nMZ,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngZl,m3h4x8(:,29),heltab2x32(:,:,673))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,30),heltab2x32(:,:,674))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(65),n2h8(98))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,31),heltab2x32(:,:,675))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(1),n2h8(99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,32),heltab2x32(:,:,676))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(4),n2h8(100))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,33),heltab2x32(:,:,677))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(6),n2h8(101))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,34),heltab2x32(:,:,678))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(14),n2h8(102))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPln,m3h4x8(:,35),heltab2x32(:,:,679))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(13),n2h8(103))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,36),heltab2x32(:,:,680))
  call Hloop_A_Q(ntryL,G0H8(29),18,0,G1H8(16),n2h8(104))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[18,1,8,4],[nMH,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngH,m3h4x8(:,37),heltab2x32(:,:,681))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[18,1,8,4],[nMZ,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(30),ngX,m3h4x8(:,38),heltab2x32(:,:,682))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(31),ngPln,m3h4x8(:,39),heltab2x32(:,:,683))
  call Hloop_A_Q(ntryL,G0H8(31),18,0,G1H8(15),n2h8(105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[18,1,8,4],[0,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(31),m3h4x8(:,40),heltab2x32(:,:,684))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[18,1,8,4],[nMZ,nME,nME,nME],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(32),ngZl,m3h4x8(:,41),heltab2x32(:,:,685))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,42),heltab2x32(:,:,686))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(17),n2h8(106))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,43),heltab2x32(:,:,687))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(20),n2h8(107))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,44),heltab2x32(:,:,688))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(19),n2h8(108))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,45),heltab2x32(:,:,689))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(21),n2h8(109))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,46),heltab2x32(:,:,690))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(25),n2h8(110))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPln,m3h4x8(:,47),heltab2x32(:,:,691))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(26),n2h8(111))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,48),heltab2x32(:,:,692))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(34),n2h8(112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(22),[G0H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(24),[G0H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(34),[G0H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(36),[G0H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(38),[G0H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(40),[G0H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(101),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(70),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(72),[G0H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(74),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(76),[G0H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G1H16(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(143),[G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(144),[G1H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(98),[G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(100),[G0H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(102),[G0H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(104),[G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(181),[G1H16(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(182),[G1H16(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(185),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(186),[G1H16(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(198),[G1H16(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(126),[G0H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(128),[G0H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(130),[G0H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(132),[G0H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(200),[G1H16(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(223),[G1H16(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(224),[G1H16(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(227),[G1H16(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(228),[G1H16(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(154),[G0H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(156),[G0H16(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(158),[G0H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(160),[G0H16(159)])
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(5),ngPnl,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(5),21,0,G2H4(9),n2h4(93))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(6),ngPnl,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(6),21,0,G2H4(13),n2h4(94))
  call Hloop_WQ_A(ntryL,G1H8(22),ex1(:),G1H4(9),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(11),n2h4(95))
  call Hloop_WQ_A(ntryL,G1H8(38),ex1(:),G1H4(10),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(10),21,0,G2H4(12),n2h4(96))
  call Hloop_SA_Q(ntryL,G1H8(45),ex2(:),G1H4(11),ngPln,m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(11),22,0,G2H4(14),n2h4(97))
  call Hloop_SA_Q(ntryL,G1H8(51),ex2(:),G1H4(12),ngPln,m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(12),22,0,G2H4(15),n2h4(98))
  call Hloop_WA_Q(ntryL,G1H8(60),ex2(:),G1H4(15),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(15),22,0,G2H4(16),n2h4(99))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(16),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(16),22,0,G2H4(17),n2h4(100))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngPln,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(17),n2h4(101))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngPln,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(18),n2h4(102))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(21),n2h4(103))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(22),n2h4(104))
  call Hloop_SQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),ngPnl,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(23),n2h4(105))
  call Hloop_SQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),ngPnl,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(24),n2h4(106))
  call Hloop_WQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(27),n2h4(107))
  call Hloop_WQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(28),n2h4(108))
  call Hloop_SQ_A(ntryL,G1H16(1),ex1(:),G1H8(33),ngPnl,m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(33),17,0,G2H8(1),n2h8(113))
  call Hloop_WQ_A(ntryL,G0H16(1),ex1(:),G0H8(33),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(33),17,0,G1H8(36),n2h8(114))
  call Hloop_SQ_A(ntryL,G0H16(2),ex1(:),G0H8(13),ngPnl,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(13),17,0,G1H8(35),n2h8(115))
  call Hloop_WQ_A(ntryL,G1H16(2),ex1(:),G1H8(37),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(37),17,0,G2H8(2),n2h8(116))
  call Hloop_SA_Q(ntryL,G1H16(3),ex2(:),G1H8(40),ngPln,m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(40),18,0,G2H8(3),n2h8(117))
  call Hloop_WA_Q(ntryL,G0H16(3),ex2(:),G0H8(14),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(14),18,0,G1H8(39),n2h8(118))
  call Hloop_SA_Q(ntryL,G0H16(4),ex2(:),G0H8(15),ngPln,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(46),n2h8(119))
  call Hloop_WA_Q(ntryL,G1H16(4),ex2(:),G1H8(49),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(49),18,0,G2H8(4),n2h8(120))
  call Hloop_QS_A(ntryL,G1H16(5),wf4(:,36),G1H4(29),ngH,m3h4x4(:,1),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(29),19,nME,G2H4(18),n2h4(109))
  call Hloop_AS_Q(ntryL,G1H16(6),wf4(:,36),G1H4(30),ngH,m3h4x4(:,2),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(30),19,nME,G2H4(19),n2h4(110))
  call Hloop_QS_A(ntryL,G1H16(7),wf4(:,37),G1H4(33),ngX,m3h4x4(:,3),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(33),19,nME,G2H4(20),n2h4(111))
  call Hloop_AS_Q(ntryL,G1H16(8),wf4(:,37),G1H4(34),ngX,m3h4x4(:,4),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(34),19,nME,G2H4(21),n2h4(112))
  call Hloop_SS_S(ntryL,G1H16(9),wf4(:,36),G1H4(35),m3h4x4(:,5),heltab2x16(:,:,133))
  call Hloop_SS_S(ntryL,G1H16(10),wf4(:,36),G1H4(36),m3h4x4(:,6),heltab2x16(:,:,134))
  call Hloop_SS_S(ntryL,G1H16(13),wf4(:,36),G1H4(39),m3h4x4(:,7),heltab2x16(:,:,135))
  call Hloop_SS_S(ntryL,G1H16(14),wf4(:,36),G1H4(40),m3h4x4(:,8),heltab2x16(:,:,136))
  call Hloop_SS_S(ntryL,G1H16(17),wf4(:,37),G1H4(41),m3h4x4(:,9),heltab2x16(:,:,137))
  call Hloop_SS_S(ntryL,G1H16(18),wf4(:,37),G1H4(42),m3h4x4(:,10),heltab2x16(:,:,138))
  call Hloop_VS_V(ntryL,G1H16(19),wf4(:,36),G1H4(45),m3h4x4(:,11),heltab2x16(:,:,139))
  call Hloop_VS_V(ntryL,G1H16(20),wf4(:,36),G1H4(46),m3h4x4(:,12),heltab2x16(:,:,140))
  call Hloop_VT_S(ntryL,G0H16(9),16,wf4(:,36),3,G1H4(47),m3h4x4(:,13),heltab2x16(:,:,141))
  call Hloop_VT_S(ntryL,G0H16(10),16,wf4(:,36),3,G1H4(48),m3h4x4(:,14),heltab2x16(:,:,142))
  call Hloop_VT_S(ntryL,G0H16(11),16,wf4(:,37),3,G1H4(51),m3h4x4(:,15),heltab2x16(:,:,143))
  call Hloop_VT_S(ntryL,G0H16(12),16,wf4(:,37),3,G1H4(52),m3h4x4(:,16),heltab2x16(:,:,144))
  call Hloop_ST_V(ntryL,G1H16(21),16,wf4(:,36),3,G2H4(22),m3h4x4(:,17),heltab2x16(:,:,145))
  call Hloop_ST_V(ntryL,G1H16(22),16,wf4(:,36),3,G2H4(23),m3h4x4(:,18),heltab2x16(:,:,146))
  call Hloop_ST_V(ntryL,G1H16(23),16,wf4(:,37),3,G2H4(24),m3h4x4(:,19),heltab2x16(:,:,147))
  call Hloop_ST_V(ntryL,G1H16(24),16,wf4(:,37),3,G2H4(92),m3h4x4(:,20),heltab2x16(:,:,148))
  call Hloop_SS_S(ntryL,G0H16(13),wf4(:,36),G0H4(1),m3h4x4(:,21),heltab2x16(:,:,149))
  call Hloop_SS_S(ntryL,G0H16(14),wf4(:,36),G0H4(2),m3h4x4(:,22),heltab2x16(:,:,150))
  call Hloop_SS_S(ntryL,G1H16(26),wf4(:,36),G1H4(53),m3h4x4(:,23),heltab2x16(:,:,151))
  call Hloop_VS_V(ntryL,G0H16(15),wf4(:,36),G0H4(3),m3h4x4(:,24),heltab2x16(:,:,152))
  call Hloop_VS_V(ntryL,G0H16(16),wf4(:,36),G0H4(4),m3h4x4(:,25),heltab2x16(:,:,153))
  call Hloop_VT_S(ntryL,G1H16(27),16,wf4(:,36),3,G2H4(83),m3h4x4(:,26),heltab2x16(:,:,154))
  call Hloop_VT_S(ntryL,G1H16(28),16,wf4(:,36),3,G2H4(96),m3h4x4(:,27),heltab2x16(:,:,155))
  call Hloop_VT_S(ntryL,G1H16(29),16,wf4(:,37),3,G2H4(88),m3h4x4(:,28),heltab2x16(:,:,156))
  call Hloop_VT_S(ntryL,G1H16(30),16,wf4(:,37),3,G2H4(29),m3h4x4(:,29),heltab2x16(:,:,157))
  call Hloop_ST_V(ntryL,G0H16(18),16,wf4(:,36),3,G1H4(54),m3h4x4(:,30),heltab2x16(:,:,158))
  call Hloop_ST_V(ntryL,G0H16(20),16,wf4(:,37),3,G1H4(57),m3h4x4(:,31),heltab2x16(:,:,159))
  call Hloop_VT_S(ntryL,G0H16(22),16,wf4(:,36),3,G1H4(58),m3h4x4(:,32),heltab2x16(:,:,160))
  call Hloop_VT_S(ntryL,G0H16(24),16,wf4(:,37),3,G1H4(59),m3h4x4(:,33),heltab2x16(:,:,161))
  call Hloop_ST_V(ntryL,G1H16(31),16,wf4(:,36),3,G2H4(33),m3h4x4(:,34),heltab2x16(:,:,162))
  call Hloop_ST_V(ntryL,G1H16(32),16,wf4(:,36),3,G2H4(31),m3h4x4(:,35),heltab2x16(:,:,163))
  call Hloop_ST_V(ntryL,G1H16(33),16,wf4(:,37),3,G2H4(32),m3h4x4(:,36),heltab2x16(:,:,164))
  call Hloop_ST_V(ntryL,G1H16(34),16,wf4(:,37),3,G2H4(34),m3h4x4(:,37),heltab2x16(:,:,165))
  call Hloop_SS_S(ntryL,G0H16(25),wf4(:,36),G0H4(5),m3h4x4(:,38),heltab2x16(:,:,166))
  call Hloop_SS_S(ntryL,G0H16(26),wf4(:,36),G0H4(6),m3h4x4(:,39),heltab2x16(:,:,167))
  call Hloop_VS_V(ntryL,G1H16(36),wf4(:,36),G1H4(60),m3h4x4(:,40),heltab2x16(:,:,168))
  call Hloop_VS_V(ntryL,G0H16(27),wf4(:,36),G0H4(7),m3h4x4(:,41),heltab2x16(:,:,169))
  call Hloop_VS_V(ntryL,G0H16(28),wf4(:,36),G0H4(8),m3h4x4(:,42),heltab2x16(:,:,170))
  call Hloop_VT_S(ntryL,G1H16(37),16,wf4(:,36),3,G2H4(35),m3h4x4(:,43),heltab2x16(:,:,171))
  call Hloop_VT_S(ntryL,G1H16(38),16,wf4(:,36),3,G2H4(36),m3h4x4(:,44),heltab2x16(:,:,172))
  call Hloop_VT_S(ntryL,G1H16(39),16,wf4(:,37),3,G2H4(37),m3h4x4(:,45),heltab2x16(:,:,173))
  call Hloop_VT_S(ntryL,G1H16(40),16,wf4(:,37),3,G2H4(38),m3h4x4(:,46),heltab2x16(:,:,174))
  call Hloop_ST_V(ntryL,G0H16(29),16,wf4(:,36),3,G1H4(63),m3h4x4(:,47),heltab2x16(:,:,175))
  call Hloop_ST_V(ntryL,G0H16(30),16,wf4(:,36),3,G1H4(64),m3h4x4(:,48),heltab2x16(:,:,176))
  call Hloop_ST_V(ntryL,G0H16(31),16,wf4(:,37),3,G1H4(65),m3h4x4(:,49),heltab2x16(:,:,177))
  call Hloop_ST_V(ntryL,G0H16(32),16,wf4(:,37),3,G1H4(66),m3h4x4(:,50),heltab2x16(:,:,178))
  call Hloop_QV_A(ntryL,G1H16(41),wf4(:,13),G1H4(69),m3h4x4(:,51),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(69),19,nME,G2H4(39),n2h4(113))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,13),G1H4(70),m3h4x4(:,52),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(70),19,nME,G2H4(40),n2h4(114))
  call Hloop_QV_A(ntryL,G1H16(43),wf4(:,13),G1H4(71),m3h4x4(:,53),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(71),19,0,G2H4(41),n2h4(115))
  call Hloop_AV_Q(ntryL,G1H16(44),wf4(:,13),G1H4(72),m3h4x4(:,54),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(72),19,0,G2H4(45),n2h4(116))
  call Hloop_QZ_A(ntryL,G1H16(45),wf4(:,14),G1H4(75),ngZl,m3h4x4(:,55),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(75),19,nME,G2H4(43),n2h4(117))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,14),G1H4(76),ngZl,m3h4x4(:,56),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(76),19,nME,G2H4(44),n2h4(118))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,14),G1H4(77),ngZu,m3h4x4(:,57),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(77),19,0,G2H4(46),n2h4(119))
  call Hloop_AZ_Q(ntryL,G1H16(48),wf4(:,14),G1H4(78),ngZu,m3h4x4(:,58),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(78),19,0,G2H4(47),n2h4(120))
  call Hloop_TV_S(ntryL,G1H16(49),16,wf4(:,13),3,G2H4(48),m3h4x4(:,59),heltab2x16(:,:,187))
  call Hloop_SV_T(ntryL,G1H16(50),16,wf4(:,13),3,G2H4(49),m3h4x4(:,60),heltab2x16(:,:,188))
  call Hloop_TV_S(ntryL,G1H16(51),16,wf4(:,14),3,G2H4(50),m3h4x4(:,61),heltab2x16(:,:,189))
  call Hloop_SV_T(ntryL,G1H16(52),16,wf4(:,14),3,G2H4(51),m3h4x4(:,62),heltab2x16(:,:,190))
  call Hloop_CV_D(ntryL,G1H16(55),16,wf4(:,13),3,G2H4(52),m3h4x4(:,63),heltab2x16(:,:,191))
  call Hloop_DV_C(ntryL,G1H16(56),16,wf4(:,13),G2H4(53),m3h4x4(:,64),heltab2x16(:,:,192))
  call Hloop_CV_D(ntryL,G1H16(59),16,wf4(:,14),3,G2H4(57),m3h4x4(:,65),heltab2x16(:,:,193))
  call Hloop_DV_C(ntryL,G1H16(60),16,wf4(:,14),G2H4(55),m3h4x4(:,66),heltab2x16(:,:,194))
  call Hloop_UV_W(ntryL,G1H16(61),16,wf4(:,13),3,G2H4(56),m3h4x4(:,67),heltab2x16(:,:,195))
  call Hloop_UW_V(ntryL,G1H16(62),16,wf4(:,13),3,G2H4(58),m3h4x4(:,68),heltab2x16(:,:,196))
  call Hloop_UV_W(ntryL,G1H16(63),16,wf4(:,14),3,G2H4(59),m3h4x4(:,69),heltab2x16(:,:,197))
  call Hloop_UW_V(ntryL,G1H16(64),16,wf4(:,14),3,G2H4(60),m3h4x4(:,70),heltab2x16(:,:,198))
  call Hloop_VV_S(ntryL,G0H16(41),wf4(:,13),G0H4(9),m3h4x4(:,71),heltab2x16(:,:,199))
  call Hloop_VV_S(ntryL,G0H16(42),wf4(:,13),G0H4(10),m3h4x4(:,72),heltab2x16(:,:,200))
  call Hloop_VV_S(ntryL,G0H16(43),wf4(:,14),G0H4(11),m3h4x4(:,73),heltab2x16(:,:,201))
  call Hloop_VV_S(ntryL,G0H16(44),wf4(:,14),G0H4(12),m3h4x4(:,74),heltab2x16(:,:,202))
  call Hloop_SV_V(ntryL,G1H16(65),wf4(:,13),G1H4(81),m3h4x4(:,75),heltab2x16(:,:,203))
  call Hloop_SV_V(ntryL,G1H16(66),wf4(:,13),G1H4(82),m3h4x4(:,76),heltab2x16(:,:,204))
  call Hloop_SV_V(ntryL,G1H16(67),wf4(:,14),G1H4(83),m3h4x4(:,77),heltab2x16(:,:,205))
  call Hloop_SV_V(ntryL,G1H16(68),wf4(:,14),G1H4(84),m3h4x4(:,78),heltab2x16(:,:,206))
  call Hloop_TV_S(ntryL,G0H16(45),16,wf4(:,13),3,G1H4(87),m3h4x4(:,79),heltab2x16(:,:,207))
  call Hloop_SV_T(ntryL,G0H16(46),16,wf4(:,13),3,G1H4(88),m3h4x4(:,80),heltab2x16(:,:,208))
  call Hloop_TV_S(ntryL,G0H16(47),16,wf4(:,14),3,G1H4(89),m3h4x4(:,81),heltab2x16(:,:,209))
  call Hloop_SV_T(ntryL,G0H16(48),16,wf4(:,14),3,G1H4(90),m3h4x4(:,82),heltab2x16(:,:,210))
  call Hloop_TV_S(ntryL,G1H16(69),16,wf4(:,13),3,G2H4(61),m3h4x4(:,83),heltab2x16(:,:,211))
  call Hloop_SV_T(ntryL,G1H16(70),16,wf4(:,13),3,G2H4(62),m3h4x4(:,84),heltab2x16(:,:,212))
  call Hloop_TV_S(ntryL,G1H16(71),16,wf4(:,14),3,G2H4(63),m3h4x4(:,85),heltab2x16(:,:,213))
  call Hloop_SV_T(ntryL,G1H16(72),16,wf4(:,14),3,G2H4(64),m3h4x4(:,86),heltab2x16(:,:,214))
  call Hloop_UV_W(ntryL,G0H16(5),16,wf4(:,13),3,G1H4(93),m3h4x4(:,87),heltab2x16(:,:,215))
  call Hloop_UW_V(ntryL,G0H16(6),16,wf4(:,13),3,G1H4(94),m3h4x4(:,88),heltab2x16(:,:,216))
  call Hloop_UV_W(ntryL,G0H16(7),16,wf4(:,14),3,G1H4(95),m3h4x4(:,89),heltab2x16(:,:,217))
  call Hloop_UW_V(ntryL,G0H16(8),16,wf4(:,14),3,G1H4(96),m3h4x4(:,90),heltab2x16(:,:,218))
  call Hloop_VV_S(ntryL,G1H16(73),wf4(:,13),G1H4(99),m3h4x4(:,91),heltab2x16(:,:,219))
  call Hloop_VV_S(ntryL,G1H16(74),wf4(:,13),G1H4(100),m3h4x4(:,92),heltab2x16(:,:,220))
  call Hloop_VV_S(ntryL,G1H16(75),wf4(:,14),G1H4(101),m3h4x4(:,93),heltab2x16(:,:,221))
  call Hloop_VV_S(ntryL,G1H16(76),wf4(:,14),G1H4(102),m3h4x4(:,94),heltab2x16(:,:,222))
  call Hloop_SV_V(ntryL,G0H16(34),wf4(:,13),G0H4(13),m3h4x4(:,95),heltab2x16(:,:,223))
  call Hloop_SV_V(ntryL,G0H16(36),wf4(:,14),G0H4(14),m3h4x4(:,96),heltab2x16(:,:,224))
  call Hloop_VV_S(ntryL,G0H16(38),wf4(:,13),G0H4(15),m3h4x4(:,97),heltab2x16(:,:,225))
  call Hloop_VV_S(ntryL,G0H16(40),wf4(:,14),G0H4(16),m3h4x4(:,98),heltab2x16(:,:,226))
  call Hloop_SV_V(ntryL,G1H16(77),wf4(:,13),G1H4(105),m3h4x4(:,99),heltab2x16(:,:,227))
  call Hloop_SV_V(ntryL,G1H16(78),wf4(:,13),G1H4(106),m3h4x4(:,100),heltab2x16(:,:,228))
  call Hloop_SV_V(ntryL,G1H16(79),wf4(:,14),G1H4(107),m3h4x4(:,101),heltab2x16(:,:,229))
  call Hloop_SV_V(ntryL,G1H16(80),wf4(:,14),G1H4(108),m3h4x4(:,102),heltab2x16(:,:,230))
  call Hloop_TV_S(ntryL,G0H16(49),16,wf4(:,13),3,G1H4(111),m3h4x4(:,103),heltab2x16(:,:,231))
  call Hloop_SV_T(ntryL,G0H16(50),16,wf4(:,13),3,G1H4(112),m3h4x4(:,104),heltab2x16(:,:,232))
  call Hloop_TV_S(ntryL,G0H16(51),16,wf4(:,14),3,G1H4(113),m3h4x4(:,105),heltab2x16(:,:,233))
  call Hloop_SV_T(ntryL,G0H16(52),16,wf4(:,14),3,G1H4(114),m3h4x4(:,106),heltab2x16(:,:,234))
  call Hloop_UV_W(ntryL,G1H16(81),16,wf4(:,13),3,G2H4(68),m3h4x4(:,107),heltab2x16(:,:,235))
  call Hloop_UW_V(ntryL,G1H16(82),16,wf4(:,13),3,G2H4(69),m3h4x4(:,108),heltab2x16(:,:,236))
  call Hloop_UV_W(ntryL,G1H16(83),16,wf4(:,14),3,G2H4(72),m3h4x4(:,109),heltab2x16(:,:,237))
  call Hloop_UW_V(ntryL,G1H16(84),16,wf4(:,14),3,G2H4(73),m3h4x4(:,110),heltab2x16(:,:,238))
  call Hloop_UV_W(ntryL,G0H16(53),16,wf4(:,13),3,G1H4(117),m3h4x4(:,111),heltab2x16(:,:,239))
  call Hloop_UW_V(ntryL,G0H16(54),16,wf4(:,13),3,G1H4(118),m3h4x4(:,112),heltab2x16(:,:,240))
  call Hloop_UV_W(ntryL,G0H16(55),16,wf4(:,14),3,G1H4(119),m3h4x4(:,113),heltab2x16(:,:,241))
  call Hloop_UW_V(ntryL,G0H16(56),16,wf4(:,14),3,G1H4(120),m3h4x4(:,114),heltab2x16(:,:,242))
  call Hloop_VV_S(ntryL,G1H16(85),wf4(:,13),G1H4(123),m3h4x4(:,115),heltab2x16(:,:,243))
  call Hloop_VV_S(ntryL,G1H16(86),wf4(:,13),G1H4(124),m3h4x4(:,116),heltab2x16(:,:,244))
  call Hloop_VV_S(ntryL,G1H16(87),wf4(:,14),G1H4(125),m3h4x4(:,117),heltab2x16(:,:,245))
  call Hloop_VV_S(ntryL,G1H16(88),wf4(:,14),G1H4(126),m3h4x4(:,118),heltab2x16(:,:,246))
  call Hloop_SV_V(ntryL,G0H16(57),wf4(:,13),G0H4(17),m3h4x4(:,119),heltab2x16(:,:,247))
  call Hloop_SV_V(ntryL,G0H16(58),wf4(:,13),G0H4(18),m3h4x4(:,120),heltab2x16(:,:,248))
  call Hloop_SV_V(ntryL,G0H16(59),wf4(:,14),G0H4(19),m3h4x4(:,121),heltab2x16(:,:,249))
  call Hloop_SV_V(ntryL,G0H16(60),wf4(:,14),G0H4(20),m3h4x4(:,122),heltab2x16(:,:,250))
  call Hloop_AS_Q(ntryL,G1H16(89),wf4(:,36),G1H4(129),ngH,m3h4x4(:,123),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(129),19,nME,G2H4(76),n2h4(121))
  call Hloop_QS_A(ntryL,G1H16(90),wf4(:,36),G1H4(130),ngH,m3h4x4(:,124),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G1H4(130),19,nME,G2H4(77),n2h4(122))
  call Hloop_AS_Q(ntryL,G1H16(91),wf4(:,37),G1H4(131),ngX,m3h4x4(:,125),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(131),19,nME,G2H4(81),n2h4(123))
  call Hloop_QS_A(ntryL,G1H16(92),wf4(:,37),G1H4(132),ngX,m3h4x4(:,126),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(132),19,nME,G2H4(82),n2h4(124))
  call Hloop_SS_S(ntryL,G1H16(93),wf4(:,36),G1H4(135),m3h4x4(:,127),heltab2x16(:,:,255))
  call Hloop_SS_S(ntryL,G1H16(94),wf4(:,36),G1H4(136),m3h4x4(:,128),heltab2x16(:,:,256))
  call Hloop_SS_S(ntryL,G1H16(97),wf4(:,36),G1H4(137),m3h4x4(:,129),heltab2x16(:,:,257))
  call Hloop_SS_S(ntryL,G1H16(98),wf4(:,36),G1H4(138),m3h4x4(:,130),heltab2x16(:,:,258))
  call Hloop_SS_S(ntryL,G1H16(101),wf4(:,37),G1H4(141),m3h4x4(:,131),heltab2x16(:,:,259))
  call Hloop_SS_S(ntryL,G1H16(102),wf4(:,37),G1H4(142),m3h4x4(:,132),heltab2x16(:,:,260))
  call Hloop_VS_V(ntryL,G1H16(103),wf4(:,36),G1H4(143),m3h4x4(:,133),heltab2x16(:,:,261))
  call Hloop_VS_V(ntryL,G1H16(104),wf4(:,36),G1H4(144),m3h4x4(:,134),heltab2x16(:,:,262))
  call Hloop_VT_S(ntryL,G0H16(61),16,wf4(:,36),3,G1H4(147),m3h4x4(:,135),heltab2x16(:,:,263))
  call Hloop_VT_S(ntryL,G0H16(62),16,wf4(:,36),3,G1H4(148),m3h4x4(:,136),heltab2x16(:,:,264))
  call Hloop_VT_S(ntryL,G0H16(63),16,wf4(:,37),3,G1H4(149),m3h4x4(:,137),heltab2x16(:,:,265))
  call Hloop_VT_S(ntryL,G0H16(64),16,wf4(:,37),3,G1H4(150),m3h4x4(:,138),heltab2x16(:,:,266))
  call Hloop_SS_S(ntryL,G0H16(65),wf4(:,36),G0H4(21),m3h4x4(:,139),heltab2x16(:,:,267))
  call Hloop_SS_S(ntryL,G0H16(66),wf4(:,36),G0H4(22),m3h4x4(:,140),heltab2x16(:,:,268))
  call Hloop_ST_V(ntryL,G1H16(105),16,wf4(:,36),3,G2H4(86),m3h4x4(:,141),heltab2x16(:,:,269))
  call Hloop_ST_V(ntryL,G1H16(106),16,wf4(:,36),3,G2H4(87),m3h4x4(:,142),heltab2x16(:,:,270))
  call Hloop_ST_V(ntryL,G1H16(107),16,wf4(:,37),3,G2H4(90),m3h4x4(:,143),heltab2x16(:,:,271))
  call Hloop_ST_V(ntryL,G1H16(108),16,wf4(:,37),3,G2H4(91),m3h4x4(:,144),heltab2x16(:,:,272))
  call Hloop_SS_S(ntryL,G1H16(110),wf4(:,36),G1H4(153),m3h4x4(:,145),heltab2x16(:,:,273))
  call Hloop_VT_S(ntryL,G1H16(111),16,wf4(:,36),3,G2H4(94),m3h4x4(:,146),heltab2x16(:,:,274))
  call Hloop_VT_S(ntryL,G1H16(112),16,wf4(:,36),3,G2H4(95),m3h4x4(:,147),heltab2x16(:,:,275))
  call Hloop_VT_S(ntryL,G1H16(113),16,wf4(:,37),3,G2H4(99),m3h4x4(:,148),heltab2x16(:,:,276))
  call Hloop_VT_S(ntryL,G1H16(114),16,wf4(:,37),3,G2H4(100),m3h4x4(:,149),heltab2x16(:,:,277))
  call Hloop_VS_V(ntryL,G0H16(67),wf4(:,36),G0H4(23),m3h4x4(:,150),heltab2x16(:,:,278))
  call Hloop_VS_V(ntryL,G0H16(68),wf4(:,36),G0H4(24),m3h4x4(:,151),heltab2x16(:,:,279))
  call Hloop_ST_V(ntryL,G0H16(70),16,wf4(:,36),3,G1H4(154),m3h4x4(:,152),heltab2x16(:,:,280))
  call Hloop_ST_V(ntryL,G0H16(72),16,wf4(:,37),3,G1H4(155),m3h4x4(:,153),heltab2x16(:,:,281))
  call Hloop_VT_S(ntryL,G0H16(74),16,wf4(:,36),3,G1H4(156),m3h4x4(:,154),heltab2x16(:,:,282))
  call Hloop_VT_S(ntryL,G0H16(76),16,wf4(:,37),3,G1H4(159),m3h4x4(:,155),heltab2x16(:,:,283))
  call Hloop_SS_S(ntryL,G0H16(77),wf4(:,36),G0H4(25),m3h4x4(:,156),heltab2x16(:,:,284))
  call Hloop_SS_S(ntryL,G0H16(78),wf4(:,36),G0H4(26),m3h4x4(:,157),heltab2x16(:,:,285))
  call Hloop_ST_V(ntryL,G1H16(115),16,wf4(:,36),3,G2H4(5),m3h4x4(:,158),heltab2x16(:,:,286))
  call Hloop_ST_V(ntryL,G1H16(116),16,wf4(:,36),3,G2H4(6),m3h4x4(:,159),heltab2x16(:,:,287))
  call Hloop_ST_V(ntryL,G1H16(117),16,wf4(:,37),3,G2H4(7),m3h4x4(:,160),heltab2x16(:,:,288))
  call Hloop_ST_V(ntryL,G1H16(118),16,wf4(:,37),3,G2H4(8),m3h4x4(:,161),heltab2x16(:,:,289))
  call Hloop_VS_V(ntryL,G1H16(120),wf4(:,36),G1H4(160),m3h4x4(:,162),heltab2x16(:,:,290))
  call Hloop_VT_S(ntryL,G1H16(121),16,wf4(:,36),3,G2H4(10),m3h4x4(:,163),heltab2x16(:,:,291))
  call Hloop_VT_S(ntryL,G1H16(122),16,wf4(:,36),3,G2H4(25),m3h4x4(:,164),heltab2x16(:,:,292))
  call Hloop_VT_S(ntryL,G1H16(123),16,wf4(:,37),3,G2H4(26),m3h4x4(:,165),heltab2x16(:,:,293))
  call Hloop_VT_S(ntryL,G1H16(124),16,wf4(:,37),3,G2H4(27),m3h4x4(:,166),heltab2x16(:,:,294))
  call Hloop_VS_V(ntryL,G0H16(79),wf4(:,36),G0H4(27),m3h4x4(:,167),heltab2x16(:,:,295))
  call Hloop_VS_V(ntryL,G0H16(80),wf4(:,36),G0H4(28),m3h4x4(:,168),heltab2x16(:,:,296))
  call Hloop_ST_V(ntryL,G0H16(81),16,wf4(:,36),3,G1H4(161),m3h4x4(:,169),heltab2x16(:,:,297))
  call Hloop_ST_V(ntryL,G0H16(82),16,wf4(:,36),3,G1H4(162),m3h4x4(:,170),heltab2x16(:,:,298))
  call Hloop_ST_V(ntryL,G0H16(83),16,wf4(:,37),3,G1H4(165),m3h4x4(:,171),heltab2x16(:,:,299))
  call Hloop_ST_V(ntryL,G0H16(84),16,wf4(:,37),3,G1H4(166),m3h4x4(:,172),heltab2x16(:,:,300))
  call Hloop_AV_Q(ntryL,G1H16(125),wf4(:,13),G1H4(167),m3h4x4(:,173),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(167),19,nME,G2H4(28),n2h4(125))
  call Hloop_QV_A(ntryL,G1H16(126),wf4(:,13),G1H4(168),m3h4x4(:,174),heltab2x16(:,:,302))
  call Hloop_Q_A(ntryL,G1H4(168),19,nME,G2H4(30),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H16(127),wf4(:,13),G1H4(171),m3h4x4(:,175),heltab2x16(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(171),19,0,G2H4(42),n2h4(127))
  call Hloop_QV_A(ntryL,G1H16(128),wf4(:,13),G1H4(172),m3h4x4(:,176),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(172),19,0,G2H4(54),n2h4(128))
  call Hloop_AZ_Q(ntryL,G1H16(129),wf4(:,14),G1H4(173),ngZl,m3h4x4(:,177),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(173),19,nME,G2H4(1),n2h4(129))
  call Hloop_QZ_A(ntryL,G1H16(130),wf4(:,14),G1H4(174),ngZl,m3h4x4(:,178),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(174),19,nME,G2H4(2),n2h4(130))
  call Hloop_AZ_Q(ntryL,G1H16(131),wf4(:,14),G1H4(177),ngZu,m3h4x4(:,179),heltab2x16(:,:,307))
  call Hloop_A_Q(ntryL,G1H4(177),19,0,G2H4(3),n2h4(131))
  call Hloop_QZ_A(ntryL,G1H16(132),wf4(:,14),G1H4(178),ngZu,m3h4x4(:,180),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(178),19,0,G2H4(4),n2h4(132))
  call Hloop_SV_T(ntryL,G1H16(133),16,wf4(:,13),3,G2H4(74),m3h4x4(:,181),heltab2x16(:,:,309))
  call Hloop_TV_S(ntryL,G1H16(134),16,wf4(:,13),3,G2H4(65),m3h4x4(:,182),heltab2x16(:,:,310))
  call Hloop_SV_T(ntryL,G1H16(135),16,wf4(:,14),3,G2H4(78),m3h4x4(:,183),heltab2x16(:,:,311))
  call Hloop_TV_S(ntryL,G1H16(136),16,wf4(:,14),3,G2H4(70),m3h4x4(:,184),heltab2x16(:,:,312))
  call Hloop_DV_C(ntryL,G1H16(139),16,wf4(:,13),G2H4(101),m3h4x4(:,185),heltab2x16(:,:,313))
  call Hloop_CV_D(ntryL,G1H16(140),16,wf4(:,13),3,G2H4(102),m3h4x4(:,186),heltab2x16(:,:,314))
  call Hloop_DV_C(ntryL,G1H16(143),16,wf4(:,14),G2H4(103),m3h4x4(:,187),heltab2x16(:,:,315))
  call Hloop_CV_D(ntryL,G1H16(144),16,wf4(:,14),3,G2H4(104),m3h4x4(:,188),heltab2x16(:,:,316))
  call Hloop_UW_V(ntryL,G1H16(145),16,wf4(:,13),3,G2H4(105),m3h4x4(:,189),heltab2x16(:,:,317))
  call Hloop_UV_W(ntryL,G1H16(146),16,wf4(:,13),3,G2H4(106),m3h4x4(:,190),heltab2x16(:,:,318))
  call Hloop_UW_V(ntryL,G1H16(147),16,wf4(:,14),3,G2H4(107),m3h4x4(:,191),heltab2x16(:,:,319))
  call Hloop_UV_W(ntryL,G1H16(148),16,wf4(:,14),3,G2H4(108),m3h4x4(:,192),heltab2x16(:,:,320))
  call Hloop_VV_S(ntryL,G0H16(85),wf4(:,13),G0H4(29),m3h4x4(:,193),heltab2x16(:,:,321))
  call Hloop_VV_S(ntryL,G0H16(86),wf4(:,13),G0H4(30),m3h4x4(:,194),heltab2x16(:,:,322))
  call Hloop_VV_S(ntryL,G0H16(87),wf4(:,14),G0H4(31),m3h4x4(:,195),heltab2x16(:,:,323))
  call Hloop_VV_S(ntryL,G0H16(88),wf4(:,14),G0H4(32),m3h4x4(:,196),heltab2x16(:,:,324))
  call Hloop_SV_T(ntryL,G0H16(89),16,wf4(:,13),3,G1H4(179),m3h4x4(:,197),heltab2x16(:,:,325))
  call Hloop_TV_S(ntryL,G0H16(90),16,wf4(:,13),3,G1H4(180),m3h4x4(:,198),heltab2x16(:,:,326))
  call Hloop_SV_T(ntryL,G0H16(91),16,wf4(:,14),3,G1H4(183),m3h4x4(:,199),heltab2x16(:,:,327))
  call Hloop_TV_S(ntryL,G0H16(92),16,wf4(:,14),3,G1H4(184),m3h4x4(:,200),heltab2x16(:,:,328))
  call Hloop_SV_V(ntryL,G1H16(149),wf4(:,13),G1H4(185),m3h4x4(:,201),heltab2x16(:,:,329))
  call Hloop_SV_V(ntryL,G1H16(150),wf4(:,13),G1H4(186),m3h4x4(:,202),heltab2x16(:,:,330))
  call Hloop_SV_V(ntryL,G1H16(151),wf4(:,14),G1H4(189),m3h4x4(:,203),heltab2x16(:,:,331))
  call Hloop_SV_V(ntryL,G1H16(152),wf4(:,14),G1H4(190),m3h4x4(:,204),heltab2x16(:,:,332))
  call Hloop_SV_T(ntryL,G1H16(153),16,wf4(:,13),3,G2H4(109),m3h4x4(:,205),heltab2x16(:,:,333))
  call Hloop_TV_S(ntryL,G1H16(154),16,wf4(:,13),3,G2H4(110),m3h4x4(:,206),heltab2x16(:,:,334))
  call Hloop_SV_T(ntryL,G1H16(155),16,wf4(:,14),3,G2H4(111),m3h4x4(:,207),heltab2x16(:,:,335))
  call Hloop_TV_S(ntryL,G1H16(156),16,wf4(:,14),3,G2H4(112),m3h4x4(:,208),heltab2x16(:,:,336))
  call Hloop_VV_S(ntryL,G1H16(157),wf4(:,13),G1H4(191),m3h4x4(:,209),heltab2x16(:,:,337))
  call Hloop_VV_S(ntryL,G1H16(158),wf4(:,13),G1H4(192),m3h4x4(:,210),heltab2x16(:,:,338))
  call Hloop_VV_S(ntryL,G1H16(159),wf4(:,14),G1H4(195),m3h4x4(:,211),heltab2x16(:,:,339))
  call Hloop_VV_S(ntryL,G1H16(160),wf4(:,14),G1H4(196),m3h4x4(:,212),heltab2x16(:,:,340))
  call Hloop_UW_V(ntryL,G0H16(93),16,wf4(:,13),3,G1H4(197),m3h4x4(:,213),heltab2x16(:,:,341))
  call Hloop_UV_W(ntryL,G0H16(94),16,wf4(:,13),3,G1H4(198),m3h4x4(:,214),heltab2x16(:,:,342))
  call Hloop_UW_V(ntryL,G0H16(95),16,wf4(:,14),3,G1H4(201),m3h4x4(:,215),heltab2x16(:,:,343))
  call Hloop_UV_W(ntryL,G0H16(96),16,wf4(:,14),3,G1H4(202),m3h4x4(:,216),heltab2x16(:,:,344))
  call Hloop_SV_V(ntryL,G0H16(98),wf4(:,13),G0H4(33),m3h4x4(:,217),heltab2x16(:,:,345))
  call Hloop_SV_V(ntryL,G0H16(100),wf4(:,14),G0H4(34),m3h4x4(:,218),heltab2x16(:,:,346))
  call Hloop_VV_S(ntryL,G0H16(102),wf4(:,13),G0H4(35),m3h4x4(:,219),heltab2x16(:,:,347))
  call Hloop_VV_S(ntryL,G0H16(104),wf4(:,14),G0H4(36),m3h4x4(:,220),heltab2x16(:,:,348))
  call Hloop_SV_T(ntryL,G0H16(105),16,wf4(:,13),3,G1H4(203),m3h4x4(:,221),heltab2x16(:,:,349))
  call Hloop_TV_S(ntryL,G0H16(106),16,wf4(:,13),3,G1H4(204),m3h4x4(:,222),heltab2x16(:,:,350))
  call Hloop_SV_T(ntryL,G0H16(107),16,wf4(:,14),3,G1H4(207),m3h4x4(:,223),heltab2x16(:,:,351))
  call Hloop_TV_S(ntryL,G0H16(108),16,wf4(:,14),3,G1H4(208),m3h4x4(:,224),heltab2x16(:,:,352))
  call Hloop_SV_V(ntryL,G1H16(161),wf4(:,13),G1H4(209),m3h4x4(:,225),heltab2x16(:,:,353))
  call Hloop_SV_V(ntryL,G1H16(162),wf4(:,13),G1H4(210),m3h4x4(:,226),heltab2x16(:,:,354))
  call Hloop_SV_V(ntryL,G1H16(163),wf4(:,14),G1H4(213),m3h4x4(:,227),heltab2x16(:,:,355))
  call Hloop_SV_V(ntryL,G1H16(164),wf4(:,14),G1H4(214),m3h4x4(:,228),heltab2x16(:,:,356))
  call Hloop_UW_V(ntryL,G1H16(165),16,wf4(:,13),3,G2H4(113),m3h4x4(:,229),heltab2x16(:,:,357))
  call Hloop_UV_W(ntryL,G1H16(166),16,wf4(:,13),3,G2H4(114),m3h4x4(:,230),heltab2x16(:,:,358))
  call Hloop_UW_V(ntryL,G1H16(167),16,wf4(:,14),3,G2H4(115),m3h4x4(:,231),heltab2x16(:,:,359))
  call Hloop_UV_W(ntryL,G1H16(168),16,wf4(:,14),3,G2H4(116),m3h4x4(:,232),heltab2x16(:,:,360))
  call Hloop_VV_S(ntryL,G1H16(169),wf4(:,13),G1H4(215),m3h4x4(:,233),heltab2x16(:,:,361))
  call Hloop_VV_S(ntryL,G1H16(170),wf4(:,13),G1H4(216),m3h4x4(:,234),heltab2x16(:,:,362))
  call Hloop_VV_S(ntryL,G1H16(171),wf4(:,14),G1H4(219),m3h4x4(:,235),heltab2x16(:,:,363))
  call Hloop_VV_S(ntryL,G1H16(172),wf4(:,14),G1H4(220),m3h4x4(:,236),heltab2x16(:,:,364))
  call Hloop_UW_V(ntryL,G0H16(109),16,wf4(:,13),3,G1H4(5),m3h4x4(:,237),heltab2x16(:,:,365))
  call Hloop_UV_W(ntryL,G0H16(110),16,wf4(:,13),3,G1H4(6),m3h4x4(:,238),heltab2x16(:,:,366))
  call Hloop_UW_V(ntryL,G0H16(111),16,wf4(:,14),3,G1H4(9),m3h4x4(:,239),heltab2x16(:,:,367))
  call Hloop_UV_W(ntryL,G0H16(112),16,wf4(:,14),3,G1H4(10),m3h4x4(:,240),heltab2x16(:,:,368))
  call Hloop_SV_V(ntryL,G0H16(113),wf4(:,13),G0H4(37),m3h4x4(:,241),heltab2x16(:,:,369))
  call Hloop_SV_V(ntryL,G0H16(114),wf4(:,13),G0H4(38),m3h4x4(:,242),heltab2x16(:,:,370))
  call Hloop_SV_V(ntryL,G0H16(115),wf4(:,14),G0H4(39),m3h4x4(:,243),heltab2x16(:,:,371))
  call Hloop_SV_V(ntryL,G0H16(116),wf4(:,14),G0H4(40),m3h4x4(:,244),heltab2x16(:,:,372))
  call Hloop_QV_A(ntryL,G1H16(173),ex3(:),G1H8(50),m3h2x8(:,129),heltab2x16(:,:,373))
  call Hloop_Q_A(ntryL,G1H8(50),20,nME,G2H8(5),n2h8(121))
  call Hloop_AV_Q(ntryL,G1H16(174),ex3(:),G1H8(47),m3h2x8(:,130),heltab2x16(:,:,374))
  call Hloop_A_Q(ntryL,G1H8(47),20,nME,G2H8(6),n2h8(122))
  call Hloop_QV_A(ntryL,G1H16(175),ex3(:),G1H8(48),m3h2x8(:,131),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H8(48),20,nME,G2H8(7),n2h8(123))
  call Hloop_AV_Q(ntryL,G1H16(176),ex3(:),G1H8(52),m3h2x8(:,132),heltab2x16(:,:,376))
  call Hloop_A_Q(ntryL,G1H8(52),20,nME,G2H8(8),n2h8(124))
  call Hloop_TV_S(ntryL,G1H16(177),16,ex3(:),4,G2H8(9),m3h2x8(:,133),heltab2x16(:,:,377))
  call Hloop_SV_T(ntryL,G1H16(178),16,ex3(:),4,G2H8(12),m3h2x8(:,134),heltab2x16(:,:,378))
  call Hloop_CV_D(ntryL,G1H16(181),16,ex3(:),4,G2H8(10),m3h2x8(:,135),heltab2x16(:,:,379))
  call Hloop_DV_C(ntryL,G1H16(182),16,ex3(:),G2H8(11),m3h2x8(:,136),heltab2x16(:,:,380))
  call Hloop_CV_D(ntryL,G1H16(185),16,ex3(:),4,G2H8(14),m3h2x8(:,137),heltab2x16(:,:,381))
  call Hloop_DV_C(ntryL,G1H16(186),16,ex3(:),G2H8(15),m3h2x8(:,138),heltab2x16(:,:,382))
  call Hloop_UV_W(ntryL,G1H16(187),16,ex3(:),4,G2H8(13),m3h2x8(:,139),heltab2x16(:,:,383))
  call Hloop_UW_V(ntryL,G1H16(188),16,ex3(:),4,G2H8(16),m3h2x8(:,140),heltab2x16(:,:,384))
  call Hloop_TV_S(ntryL,G1H16(189),16,ex3(:),4,G2H8(17),m3h2x8(:,141),heltab2x16(:,:,385))
  call Hloop_SV_T(ntryL,G1H16(190),16,ex3(:),4,G2H8(18),m3h2x8(:,142),heltab2x16(:,:,386))
  call Hloop_TV_S(ntryL,G1H16(191),16,ex3(:),4,G2H8(19),m3h2x8(:,143),heltab2x16(:,:,387))
  call Hloop_SV_T(ntryL,G1H16(192),16,ex3(:),4,G2H8(20),m3h2x8(:,144),heltab2x16(:,:,388))
  call Hloop_TV_S(ntryL,G0H16(117),16,ex3(:),4,G1H8(58),m3h2x8(:,145),heltab2x16(:,:,389))
  call Hloop_SV_T(ntryL,G0H16(118),16,ex3(:),4,G1H8(57),m3h2x8(:,146),heltab2x16(:,:,390))
  call Hloop_SV_V(ntryL,G1H16(193),ex3(:),G1H8(61),m3h2x8(:,147),heltab2x16(:,:,391))
  call Hloop_SV_V(ntryL,G1H16(194),ex3(:),G1H8(62),m3h2x8(:,148),heltab2x16(:,:,392))
  call Hloop_SV_V(ntryL,G1H16(195),ex3(:),G1H8(59),m3h2x8(:,149),heltab2x16(:,:,393))
  call Hloop_SV_V(ntryL,G1H16(196),ex3(:),G1H8(64),m3h2x8(:,150),heltab2x16(:,:,394))
  call Hloop_VV_S(ntryL,G0H16(119),ex3(:),G0H8(16),m3h2x8(:,151),heltab2x16(:,:,395))
  call Hloop_VV_S(ntryL,G0H16(120),ex3(:),G0H8(8),m3h2x8(:,152),heltab2x16(:,:,396))
  call Hloop_TV_S(ntryL,G0H16(121),16,ex3(:),4,G1H8(63),m3h2x8(:,153),heltab2x16(:,:,397))
  call Hloop_SV_T(ntryL,G0H16(122),16,ex3(:),4,G1H8(3),m3h2x8(:,154),heltab2x16(:,:,398))
  call Hloop_TV_S(ntryL,G0H16(123),16,ex3(:),4,G1H8(5),m3h2x8(:,155),heltab2x16(:,:,399))
  call Hloop_SV_T(ntryL,G0H16(124),16,ex3(:),4,G1H8(7),m3h2x8(:,156),heltab2x16(:,:,400))
  call Hloop_SV_V(ntryL,G1H16(198),ex3(:),G1H8(9),m3h2x8(:,157),heltab2x16(:,:,401))
  call Hloop_SV_V(ntryL,G0H16(126),ex3(:),G0H8(10),m3h2x8(:,158),heltab2x16(:,:,402))
  call Hloop_SV_V(ntryL,G0H16(128),ex3(:),G0H8(11),m3h2x8(:,159),heltab2x16(:,:,403))
  call Hloop_VV_S(ntryL,G0H16(130),ex3(:),G0H8(12),m3h2x8(:,160),heltab2x16(:,:,404))
  call Hloop_VV_S(ntryL,G0H16(132),ex3(:),G0H8(9),m3h2x8(:,161),heltab2x16(:,:,405))
  call Hloop_VV_S(ntryL,G1H16(200),ex3(:),G1H8(10),m3h2x8(:,162),heltab2x16(:,:,406))
  call Hloop_UV_W(ntryL,G0H16(133),16,ex3(:),4,G1H8(11),m3h2x8(:,163),heltab2x16(:,:,407))
  call Hloop_UW_V(ntryL,G0H16(134),16,ex3(:),4,G1H8(2),m3h2x8(:,164),heltab2x16(:,:,408))
  call Hloop_UV_W(ntryL,G0H16(135),16,ex3(:),4,G1H8(18),m3h2x8(:,165),heltab2x16(:,:,409))
  call Hloop_UW_V(ntryL,G0H16(136),16,ex3(:),4,G1H8(22),m3h2x8(:,166),heltab2x16(:,:,410))
  call Hloop_SV_V(ntryL,G0H16(137),ex3(:),G0H8(1),m3h2x8(:,167),heltab2x16(:,:,411))
  call Hloop_SV_V(ntryL,G0H16(138),ex3(:),G0H8(2),m3h2x8(:,168),heltab2x16(:,:,412))
  call Hloop_VV_S(ntryL,G1H16(201),ex3(:),G1H8(38),m3h2x8(:,169),heltab2x16(:,:,413))
  call Hloop_VV_S(ntryL,G1H16(202),ex3(:),G1H8(45),m3h2x8(:,170),heltab2x16(:,:,414))
  call Hloop_VV_S(ntryL,G1H16(203),ex3(:),G1H8(51),m3h2x8(:,171),heltab2x16(:,:,415))
  call Hloop_VV_S(ntryL,G1H16(204),ex3(:),G1H8(60),m3h2x8(:,172),heltab2x16(:,:,416))
  call Hloop_UV_W(ntryL,G0H16(139),16,ex3(:),4,G1H8(8),m3h2x8(:,173),heltab2x16(:,:,417))
  call Hloop_UW_V(ntryL,G0H16(140),16,ex3(:),4,G1H8(33),m3h2x8(:,174),heltab2x16(:,:,418))
  call Hloop_UV_W(ntryL,G1H16(205),16,ex3(:),4,G2H8(21),m3h2x8(:,175),heltab2x16(:,:,419))
  call Hloop_UW_V(ntryL,G1H16(206),16,ex3(:),4,G2H8(22),m3h2x8(:,176),heltab2x16(:,:,420))
  call Hloop_UV_W(ntryL,G1H16(207),16,ex3(:),4,G2H8(23),m3h2x8(:,177),heltab2x16(:,:,421))
  call Hloop_UW_V(ntryL,G1H16(208),16,ex3(:),4,G2H8(24),m3h2x8(:,178),heltab2x16(:,:,422))
  call Hloop_QV_A(ntryL,G1H16(209),ex3(:),G1H8(37),m3h2x8(:,179),heltab2x16(:,:,423))
  call Hloop_Q_A(ntryL,G1H8(37),20,nME,G2H8(25),n2h8(125))
  call Hloop_AV_Q(ntryL,G1H16(210),ex3(:),G1H8(40),m3h2x8(:,180),heltab2x16(:,:,424))
  call Hloop_A_Q(ntryL,G1H8(40),20,nME,G2H8(28),n2h8(126))
  call Hloop_QV_A(ntryL,G1H16(211),ex3(:),G1H8(49),m3h2x8(:,181),heltab2x16(:,:,425))
  call Hloop_Q_A(ntryL,G1H8(49),20,0,G2H8(26),n2h8(127))
  call Hloop_AV_Q(ntryL,G1H16(212),ex3(:),G1H8(50),m3h2x8(:,182),heltab2x16(:,:,426))
  call Hloop_A_Q(ntryL,G1H8(50),20,0,G2H8(27),n2h8(128))
  call Hloop_QV_A(ntryL,G1H16(213),ex3(:),G1H8(47),m3h2x8(:,183),heltab2x16(:,:,427))
  call Hloop_Q_A(ntryL,G1H8(47),20,nME,G2H8(30),n2h8(129))
  call Hloop_AV_Q(ntryL,G1H16(214),ex3(:),G1H8(48),m3h2x8(:,184),heltab2x16(:,:,428))
  call Hloop_A_Q(ntryL,G1H8(48),20,nME,G2H8(31),n2h8(130))
  call Hloop_QV_A(ntryL,G1H16(215),ex3(:),G1H8(52),m3h2x8(:,185),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G1H8(52),20,0,G2H8(29),n2h8(131))
  call Hloop_AV_Q(ntryL,G1H16(216),ex3(:),G1H8(37),m3h2x8(:,186),heltab2x16(:,:,430))
  call Hloop_A_Q(ntryL,G1H8(37),20,0,G2H8(32),n2h8(132))
  call Hloop_TV_S(ntryL,G1H16(217),16,ex3(:),4,G2H8(33),m3h2x8(:,187),heltab2x16(:,:,431))
  call Hloop_SV_T(ntryL,G1H16(218),16,ex3(:),4,G2H8(37),m3h2x8(:,188),heltab2x16(:,:,432))
  call Hloop_TV_S(ntryL,G1H16(219),16,ex3(:),4,G2H8(34),m3h2x8(:,189),heltab2x16(:,:,433))
  call Hloop_SV_T(ntryL,G1H16(220),16,ex3(:),4,G2H8(35),m3h2x8(:,190),heltab2x16(:,:,434))
  call Hloop_CV_D(ntryL,G1H16(223),16,ex3(:),4,G2H8(38),m3h2x8(:,191),heltab2x16(:,:,435))
  call Hloop_DV_C(ntryL,G1H16(224),16,ex3(:),G2H8(39),m3h2x8(:,192),heltab2x16(:,:,436))
  call Hloop_CV_D(ntryL,G1H16(227),16,ex3(:),4,G2H8(36),m3h2x8(:,193),heltab2x16(:,:,437))
  call Hloop_DV_C(ntryL,G1H16(228),16,ex3(:),G2H8(40),m3h2x8(:,194),heltab2x16(:,:,438))
  call Hloop_UV_W(ntryL,G1H16(229),16,ex3(:),4,G2H8(41),m3h2x8(:,195),heltab2x16(:,:,439))
  call Hloop_UW_V(ntryL,G1H16(230),16,ex3(:),4,G2H8(45),m3h2x8(:,196),heltab2x16(:,:,440))
  call Hloop_UV_W(ntryL,G1H16(231),16,ex3(:),4,G2H8(42),m3h2x8(:,197),heltab2x16(:,:,441))
  call Hloop_UW_V(ntryL,G1H16(232),16,ex3(:),4,G2H8(43),m3h2x8(:,198),heltab2x16(:,:,442))
  call Hloop_TV_S(ntryL,G1H16(233),16,ex3(:),4,G2H8(46),m3h2x8(:,199),heltab2x16(:,:,443))
  call Hloop_SV_T(ntryL,G1H16(234),16,ex3(:),4,G2H8(47),m3h2x8(:,200),heltab2x16(:,:,444))
  call Hloop_TV_S(ntryL,G1H16(235),16,ex3(:),4,G2H8(44),m3h2x8(:,201),heltab2x16(:,:,445))
  call Hloop_SV_T(ntryL,G1H16(236),16,ex3(:),4,G2H8(48),m3h2x8(:,202),heltab2x16(:,:,446))
  call Hloop_TV_S(ntryL,G0H16(141),16,ex3(:),4,G1H8(40),m3h2x8(:,203),heltab2x16(:,:,447))
  call Hloop_SV_T(ntryL,G0H16(142),16,ex3(:),4,G1H8(49),m3h2x8(:,204),heltab2x16(:,:,448))
  call Hloop_TV_S(ntryL,G0H16(143),16,ex3(:),4,G1H8(50),m3h2x8(:,205),heltab2x16(:,:,449))
  call Hloop_SV_T(ntryL,G0H16(144),16,ex3(:),4,G1H8(47),m3h2x8(:,206),heltab2x16(:,:,450))
  call Hloop_SV_V(ntryL,G1H16(237),ex3(:),G1H8(48),m3h2x8(:,207),heltab2x16(:,:,451))
  call Hloop_SV_V(ntryL,G1H16(238),ex3(:),G1H8(52),m3h2x8(:,208),heltab2x16(:,:,452))
  call Hloop_SV_V(ntryL,G1H16(239),ex3(:),G1H8(37),m3h2x8(:,209),heltab2x16(:,:,453))
  call Hloop_SV_V(ntryL,G1H16(240),ex3(:),G1H8(66),m3h2x8(:,210),heltab2x16(:,:,454))
  call Hloop_VV_S(ntryL,G0H16(145),ex3(:),G0H8(3),m3h2x8(:,211),heltab2x16(:,:,455))
  call Hloop_VV_S(ntryL,G0H16(146),ex3(:),G0H8(4),m3h2x8(:,212),heltab2x16(:,:,456))
  call Hloop_VV_S(ntryL,G0H16(147),ex3(:),G0H8(5),m3h2x8(:,213),heltab2x16(:,:,457))
  call Hloop_VV_S(ntryL,G0H16(148),ex3(:),G0H8(7),m3h2x8(:,214),heltab2x16(:,:,458))
  call Hloop_TV_S(ntryL,G0H16(149),16,ex3(:),4,G1H8(67),m3h2x8(:,215),heltab2x16(:,:,459))
  call Hloop_SV_T(ntryL,G0H16(150),16,ex3(:),4,G1H8(68),m3h2x8(:,216),heltab2x16(:,:,460))
  call Hloop_TV_S(ntryL,G0H16(151),16,ex3(:),4,G1H8(69),m3h2x8(:,217),heltab2x16(:,:,461))
  call Hloop_SV_T(ntryL,G0H16(152),16,ex3(:),4,G1H8(70),m3h2x8(:,218),heltab2x16(:,:,462))
  call Hloop_SV_V(ntryL,G1H16(241),ex3(:),G1H8(71),m3h2x8(:,219),heltab2x16(:,:,463))
  call Hloop_SV_V(ntryL,G1H16(242),ex3(:),G1H8(72),m3h2x8(:,220),heltab2x16(:,:,464))
  call Hloop_SV_V(ntryL,G1H16(243),ex3(:),G1H8(73),m3h2x8(:,221),heltab2x16(:,:,465))
  call Hloop_SV_V(ntryL,G1H16(244),ex3(:),G1H8(74),m3h2x8(:,222),heltab2x16(:,:,466))
  call Hloop_SV_V(ntryL,G0H16(154),ex3(:),G0H8(6),m3h2x8(:,223),heltab2x16(:,:,467))
  call Hloop_SV_V(ntryL,G0H16(156),ex3(:),G0H8(33),m3h2x8(:,224),heltab2x16(:,:,468))
  call Hloop_VV_S(ntryL,G0H16(158),ex3(:),G0H8(13),m3h2x8(:,225),heltab2x16(:,:,469))
  call Hloop_VV_S(ntryL,G0H16(160),ex3(:),G0H8(14),m3h2x8(:,226),heltab2x16(:,:,470))
  call Hloop_VV_S(ntryL,G1H16(245),ex3(:),G1H8(75),m3h2x8(:,227),heltab2x16(:,:,471))
  call Hloop_VV_S(ntryL,G1H16(246),ex3(:),G1H8(76),m3h2x8(:,228),heltab2x16(:,:,472))
  call Hloop_VV_S(ntryL,G1H16(247),ex3(:),G1H8(77),m3h2x8(:,229),heltab2x16(:,:,473))
  call Hloop_VV_S(ntryL,G1H16(248),ex3(:),G1H8(78),m3h2x8(:,230),heltab2x16(:,:,474))
  call Hloop_UV_W(ntryL,G0H16(161),16,ex3(:),4,G1H8(79),m3h2x8(:,231),heltab2x16(:,:,475))
  call Hloop_UW_V(ntryL,G0H16(162),16,ex3(:),4,G1H8(80),m3h2x8(:,232),heltab2x16(:,:,476))
  call Hloop_UV_W(ntryL,G0H16(163),16,ex3(:),4,G1H8(81),m3h2x8(:,233),heltab2x16(:,:,477))
  call Hloop_UW_V(ntryL,G0H16(164),16,ex3(:),4,G1H8(82),m3h2x8(:,234),heltab2x16(:,:,478))
  call Hloop_SV_V(ntryL,G0H16(165),ex3(:),G0H8(15),m3h2x8(:,235),heltab2x16(:,:,479))
  call Hloop_SV_V(ntryL,G0H16(166),ex3(:),G0H8(34),m3h2x8(:,236),heltab2x16(:,:,480))
  call Hloop_SV_V(ntryL,G0H16(167),ex3(:),G0H8(35),m3h2x8(:,237),heltab2x16(:,:,481))
  call Hloop_SV_V(ntryL,G0H16(168),ex3(:),G0H8(36),m3h2x8(:,238),heltab2x16(:,:,482))
  call Hloop_VV_S(ntryL,G1H16(249),ex3(:),G1H8(83),m3h2x8(:,239),heltab2x16(:,:,483))
  call Hloop_VV_S(ntryL,G1H16(250),ex3(:),G1H8(84),m3h2x8(:,240),heltab2x16(:,:,484))
  call Hloop_VV_S(ntryL,G1H16(251),ex3(:),G1H8(85),m3h2x8(:,241),heltab2x16(:,:,485))
  call Hloop_VV_S(ntryL,G1H16(252),ex3(:),G1H8(86),m3h2x8(:,242),heltab2x16(:,:,486))
  call Hloop_UV_W(ntryL,G0H16(169),16,ex3(:),4,G1H8(87),m3h2x8(:,243),heltab2x16(:,:,487))
  call Hloop_UW_V(ntryL,G0H16(170),16,ex3(:),4,G1H8(88),m3h2x8(:,244),heltab2x16(:,:,488))
  call Hloop_UV_W(ntryL,G0H16(171),16,ex3(:),4,G1H8(89),m3h2x8(:,245),heltab2x16(:,:,489))
  call Hloop_UW_V(ntryL,G0H16(172),16,ex3(:),4,G1H8(90),m3h2x8(:,246),heltab2x16(:,:,490))
  call Hloop_UV_W(ntryL,G1H16(253),16,ex3(:),4,G2H8(49),m3h2x8(:,247),heltab2x16(:,:,491))
  call Hloop_UW_V(ntryL,G1H16(254),16,ex3(:),4,G2H8(50),m3h2x8(:,248),heltab2x16(:,:,492))
  call Hloop_UV_W(ntryL,G1H16(255),16,ex3(:),4,G2H8(51),m3h2x8(:,249),heltab2x16(:,:,493))
  call Hloop_UW_V(ntryL,G1H16(256),16,ex3(:),4,G2H8(52),m3h2x8(:,250),heltab2x16(:,:,494))
  call Hloop_AQ_S(ntryL,G1H16(257),wf4(:,3),G1H4(11),ngH,m3h4x4(:,245),heltab2x16(:,:,495))
  call Hloop_AQ_S(ntryL,G1H16(258),wf4(:,3),G1H4(12),ngX,m3h4x4(:,246),heltab2x16(:,:,496))
  call Hloop_SQ_A(ntryL,G1H16(259),wf4(:,3),G1H4(15),ngPnl,m3h4x4(:,247),heltab2x16(:,:,497))
  call Hloop_Q_A(ntryL,G1H4(15),21,0,G2H4(117),n2h4(133))
  call Hloop_AQ_V(ntryL,G1H16(260),wf4(:,3),G1H4(16),m3h4x4(:,248),heltab2x16(:,:,498))
  call Hloop_AQ_Z(ntryL,G1H16(261),wf4(:,3),G1H4(29),ngZl,m3h4x4(:,249),heltab2x16(:,:,499))
  call Hloop_WQ_A(ntryL,G0H16(173),wf4(:,3),G0H4(41),m3h4x4(:,250),heltab2x16(:,:,500))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(30),n2h4(134))
  call Hloop_SQ_A(ntryL,G0H16(174),wf4(:,3),G0H4(41),ngPnl,m3h4x4(:,251),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(33),n2h4(135))
  call Hloop_SQ_A(ntryL,G1H16(262),wf4(:,3),G1H4(34),ngPnl,m3h4x4(:,252),heltab2x16(:,:,502))
  call Hloop_Q_A(ntryL,G1H4(34),21,0,G2H4(118),n2h4(136))
  call Hloop_WQ_A(ntryL,G1H16(263),wf4(:,3),G1H4(69),m3h4x4(:,253),heltab2x16(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(69),21,0,G2H4(119),n2h4(137))
  call Hloop_WQ_A(ntryL,G0H16(175),wf4(:,3),G0H4(41),m3h4x4(:,254),heltab2x16(:,:,504))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(70),n2h4(138))
  call Hloop_SQ_A(ntryL,G0H16(176),wf4(:,3),G0H4(41),ngPnl,m3h4x4(:,255),heltab2x16(:,:,505))
  call Hloop_Q_A(ntryL,G0H4(41),21,0,G1H4(71),n2h4(139))
  call Hloop_WQ_A(ntryL,G1H16(264),wf4(:,3),G1H4(72),m3h4x4(:,256),heltab2x16(:,:,506))
  call Hloop_Q_A(ntryL,G1H4(72),21,0,G2H4(120),n2h4(140))
  call Hloop_QA_S(ntryL,G1H16(265),ex2(:),G1H8(91),ngH,m3h2x8(:,251),heltab2x16(:,:,507))
  call Hloop_QA_S(ntryL,G1H16(266),ex2(:),G1H8(92),ngX,m3h2x8(:,252),heltab2x16(:,:,508))
  call Hloop_SA_Q(ntryL,G1H16(267),ex2(:),G1H8(93),ngPln,m3h2x8(:,253),heltab2x16(:,:,509))
  call Hloop_A_Q(ntryL,G1H8(93),18,0,G2H8(53),n2h8(133))
  call Hloop_QA_V(ntryL,G1H16(268),ex2(:),G1H8(93),m3h2x8(:,254),heltab2x16(:,:,510))
  call Hloop_QA_Z(ntryL,G1H16(269),ex2(:),G1H8(94),ngZl,m3h2x8(:,255),heltab2x16(:,:,511))
  call Hloop_SA_Q(ntryL,G1H16(270),ex2(:),G1H8(95),ngPln,m3h2x8(:,256),heltab2x16(:,:,512))
  call Hloop_A_Q(ntryL,G1H8(95),18,0,G2H8(54),n2h8(134))
  call Hloop_SA_Q(ntryL,G0H16(177),ex2(:),G0H8(37),ngPln,m3h2x8(:,257),heltab2x16(:,:,513))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(95),n2h8(135))
  call Hloop_WA_Q(ntryL,G0H16(178),ex2(:),G0H8(37),m3h2x8(:,258),heltab2x16(:,:,514))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(96),n2h8(136))
  call Hloop_SA_Q(ntryL,G0H16(179),ex2(:),G0H8(37),ngPln,m3h2x8(:,259),heltab2x16(:,:,515))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(97),n2h8(137))
  call Hloop_WA_Q(ntryL,G0H16(180),ex2(:),G0H8(37),m3h2x8(:,260),heltab2x16(:,:,516))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(98),n2h8(138))
  call Hloop_WA_Q(ntryL,G1H16(271),ex2(:),G1H8(99),m3h2x8(:,261),heltab2x16(:,:,517))
  call Hloop_A_Q(ntryL,G1H8(99),18,0,G2H8(55),n2h8(139))
  call Hloop_WA_Q(ntryL,G1H16(272),ex2(:),G1H8(99),m3h2x8(:,262),heltab2x16(:,:,518))
  call Hloop_A_Q(ntryL,G1H8(99),18,0,G2H8(56),n2h8(140))
  call Hloop_QA_S(ntryL,G1H16(273),wf4(:,10),G1H4(75),ngH,m3h4x4(:,257),heltab2x16(:,:,519))
  call Hloop_QA_S(ntryL,G1H16(274),wf4(:,10),G1H4(76),ngX,m3h4x4(:,258),heltab2x16(:,:,520))
  call Hloop_SA_Q(ntryL,G1H16(275),wf4(:,10),G1H4(77),ngPln,m3h4x4(:,259),heltab2x16(:,:,521))
  call Hloop_A_Q(ntryL,G1H4(77),22,0,G2H4(121),n2h4(141))
  call Hloop_QA_V(ntryL,G1H16(276),wf4(:,10),G1H4(78),m3h4x4(:,260),heltab2x16(:,:,522))
  call Hloop_QA_Z(ntryL,G1H16(277),wf4(:,10),G1H4(129),ngZl,m3h4x4(:,261),heltab2x16(:,:,523))
  call Hloop_WA_Q(ntryL,G0H16(181),wf4(:,10),G0H4(41),m3h4x4(:,262),heltab2x16(:,:,524))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(130),n2h4(142))
  call Hloop_SA_Q(ntryL,G0H16(182),wf4(:,10),G0H4(41),ngPln,m3h4x4(:,263),heltab2x16(:,:,525))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(131),n2h4(143))
  call Hloop_SA_Q(ntryL,G1H16(278),wf4(:,10),G1H4(132),ngPln,m3h4x4(:,264),heltab2x16(:,:,526))
  call Hloop_A_Q(ntryL,G1H4(132),22,0,G2H4(122),n2h4(144))
  call Hloop_WA_Q(ntryL,G1H16(279),wf4(:,10),G1H4(167),m3h4x4(:,265),heltab2x16(:,:,527))
  call Hloop_A_Q(ntryL,G1H4(167),22,0,G2H4(123),n2h4(145))
  call Hloop_WA_Q(ntryL,G0H16(183),wf4(:,10),G0H4(41),m3h4x4(:,266),heltab2x16(:,:,528))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(168),n2h4(146))
  call Hloop_SA_Q(ntryL,G0H16(184),wf4(:,10),G0H4(41),ngPln,m3h4x4(:,267),heltab2x16(:,:,529))
  call Hloop_A_Q(ntryL,G0H4(41),22,0,G1H4(171),n2h4(147))
  call Hloop_WA_Q(ntryL,G1H16(280),wf4(:,10),G1H4(172),m3h4x4(:,268),heltab2x16(:,:,530))
  call Hloop_A_Q(ntryL,G1H4(172),22,0,G2H4(124),n2h4(148))
  call Hloop_AQ_S(ntryL,G1H16(281),ex1(:),G1H8(99),ngH,m3h2x8(:,263),heltab2x16(:,:,531))
  call Hloop_AQ_S(ntryL,G1H16(282),ex1(:),G1H8(100),ngX,m3h2x8(:,264),heltab2x16(:,:,532))
  call Hloop_SQ_A(ntryL,G1H16(283),ex1(:),G1H8(101),ngPnl,m3h2x8(:,265),heltab2x16(:,:,533))
  call Hloop_Q_A(ntryL,G1H8(101),17,0,G2H8(57),n2h8(141))
  call Hloop_AQ_V(ntryL,G1H16(284),ex1(:),G1H8(101),m3h2x8(:,266),heltab2x16(:,:,534))
  call Hloop_AQ_Z(ntryL,G1H16(285),ex1(:),G1H8(102),ngZl,m3h2x8(:,267),heltab2x16(:,:,535))
  call Hloop_SQ_A(ntryL,G1H16(286),ex1(:),G1H8(103),ngPnl,m3h2x8(:,268),heltab2x16(:,:,536))
  call Hloop_Q_A(ntryL,G1H8(103),17,0,G2H8(58),n2h8(142))
  call Hloop_SQ_A(ntryL,G0H16(185),ex1(:),G0H8(37),ngPnl,m3h2x8(:,269),heltab2x16(:,:,537))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(103),n2h8(143))
  call Hloop_WQ_A(ntryL,G0H16(186),ex1(:),G0H8(37),m3h2x8(:,270),heltab2x16(:,:,538))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(104),n2h8(144))
  call Hloop_SQ_A(ntryL,G0H16(187),ex1(:),G0H8(37),ngPnl,m3h2x8(:,271),heltab2x16(:,:,539))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(105),n2h8(145))
  call Hloop_WQ_A(ntryL,G0H16(188),ex1(:),G0H8(37),m3h2x8(:,272),heltab2x16(:,:,540))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(106),n2h8(146))
  call Hloop_WQ_A(ntryL,G1H16(287),ex1(:),G1H8(107),m3h2x8(:,273),heltab2x16(:,:,541))
  call Hloop_Q_A(ntryL,G1H8(107),17,0,G2H8(59),n2h8(147))
  call Hloop_WQ_A(ntryL,G1H16(288),ex1(:),G1H8(107),m3h2x8(:,274),heltab2x16(:,:,542))
  call Hloop_Q_A(ntryL,G1H8(107),17,0,G2H8(60),n2h8(148))
  call Hloop_QV_A(ntryL,G1H16(289),ex3(:),G1H8(107),m3h2x8(:,275),heltab2x16(:,:,543))
  call Hloop_Q_A(ntryL,G1H8(107),20,nME,G2H8(61),n2h8(149))
  call Hloop_QV_A(ntryL,G1H16(290),ex3(:),G1H8(107),m3h2x8(:,276),heltab2x16(:,:,544))
  call Hloop_Q_A(ntryL,G1H8(107),20,nME,G2H8(62),n2h8(150))
  call Hloop_TV_S(ntryL,G1H16(291),16,ex3(:),4,G2H8(63),m3h2x8(:,277),heltab2x16(:,:,545))
  call Hloop_QV_A(ntryL,G1H16(292),ex3(:),G1H8(107),m3h2x8(:,278),heltab2x16(:,:,546))
  call Hloop_Q_A(ntryL,G1H8(107),20,nME,G2H8(64),n2h8(151))
  call Hloop_QV_A(ntryL,G1H16(293),ex3(:),G1H8(107),m3h2x8(:,279),heltab2x16(:,:,547))
  call Hloop_Q_A(ntryL,G1H8(107),20,nME,G2H8(65),n2h8(152))
  call Hloop_TV_S(ntryL,G0H16(189),16,ex3(:),4,G1H8(107),m3h2x8(:,280),heltab2x16(:,:,548))
  call Hloop_VV_S(ntryL,G0H16(190),ex3(:),G0H8(37),m3h2x8(:,281),heltab2x16(:,:,549))
  call Hloop_SV_V(ntryL,G1H16(294),ex3(:),G1H8(108),m3h2x8(:,282),heltab2x16(:,:,550))
  call Hloop_VV_S(ntryL,G1H16(295),ex3(:),G1H8(109),m3h2x8(:,283),heltab2x16(:,:,551))
  call Hloop_SV_V(ntryL,G0H16(191),ex3(:),G0H8(38),m3h2x8(:,284),heltab2x16(:,:,552))
  call Hloop_UV_W(ntryL,G0H16(192),16,ex3(:),4,G1H8(110),m3h2x8(:,285),heltab2x16(:,:,553))
  call Hloop_UV_W(ntryL,G1H16(296),16,ex3(:),4,G2H8(66),m3h2x8(:,286),heltab2x16(:,:,554))
  call Hloop_QA_S(ntryL,G1H16(297),ex2(:),G1H8(111),ngH,m3h2x8(:,287),heltab2x16(:,:,555))
  call Hloop_QA_S(ntryL,G1H16(298),ex2(:),G1H8(112),ngX,m3h2x8(:,288),heltab2x16(:,:,556))
  call Hloop_SA_Q(ntryL,G1H16(299),ex2(:),G1H8(113),ngPln,m3h2x8(:,289),heltab2x16(:,:,557))
  call Hloop_A_Q(ntryL,G1H8(113),18,0,G2H8(67),n2h8(153))
  call Hloop_QA_V(ntryL,G1H16(300),ex2(:),G1H8(113),m3h2x8(:,290),heltab2x16(:,:,558))
  call Hloop_QA_Z(ntryL,G1H16(301),ex2(:),G1H8(114),ngZl,m3h2x8(:,291),heltab2x16(:,:,559))
  call Hloop_SA_Q(ntryL,G1H16(302),ex2(:),G1H8(115),ngPln,m3h2x8(:,292),heltab2x16(:,:,560))
  call Hloop_A_Q(ntryL,G1H8(115),18,0,G2H8(68),n2h8(154))
  call Hloop_SA_Q(ntryL,G0H16(193),ex2(:),G0H8(39),ngPln,m3h2x8(:,293),heltab2x16(:,:,561))
  call Hloop_A_Q(ntryL,G0H8(39),18,0,G1H8(115),n2h8(155))
  call Hloop_WA_Q(ntryL,G0H16(194),ex2(:),G0H8(39),m3h2x8(:,294),heltab2x16(:,:,562))
  call Hloop_A_Q(ntryL,G0H8(39),18,0,G1H8(116),n2h8(156))
  call Hloop_SA_Q(ntryL,G0H16(195),ex2(:),G0H8(39),ngPln,m3h2x8(:,295),heltab2x16(:,:,563))
  call Hloop_A_Q(ntryL,G0H8(39),18,0,G1H8(117),n2h8(157))
  call Hloop_WA_Q(ntryL,G0H16(196),ex2(:),G0H8(39),m3h2x8(:,296),heltab2x16(:,:,564))
  call Hloop_A_Q(ntryL,G0H8(39),18,0,G1H8(118),n2h8(158))
  call Hloop_WA_Q(ntryL,G1H16(303),ex2(:),G1H8(119),m3h2x8(:,297),heltab2x16(:,:,565))
  call Hloop_A_Q(ntryL,G1H8(119),18,0,G2H8(69),n2h8(159))
  call Hloop_WA_Q(ntryL,G1H16(304),ex2(:),G1H8(119),m3h2x8(:,298),heltab2x16(:,:,566))
  call Hloop_A_Q(ntryL,G1H8(119),18,0,G2H8(70),n2h8(160))
  call Hloop_AV_Q(ntryL,G1H16(305),ex3(:),G1H8(119),m3h2x8(:,299),heltab2x16(:,:,567))
  call Hloop_A_Q(ntryL,G1H8(119),20,nME,G2H8(71),n2h8(161))
  call Hloop_AV_Q(ntryL,G1H16(306),ex3(:),G1H8(119),m3h2x8(:,300),heltab2x16(:,:,568))
  call Hloop_A_Q(ntryL,G1H8(119),20,nME,G2H8(72),n2h8(162))
  call Hloop_SV_T(ntryL,G1H16(307),16,ex3(:),4,G2H8(73),m3h2x8(:,301),heltab2x16(:,:,569))
  call Hloop_AV_Q(ntryL,G1H16(308),ex3(:),G1H8(119),m3h2x8(:,302),heltab2x16(:,:,570))
  call Hloop_A_Q(ntryL,G1H8(119),20,nME,G2H8(74),n2h8(163))
  call Hloop_AV_Q(ntryL,G1H16(309),ex3(:),G1H8(119),m3h2x8(:,303),heltab2x16(:,:,571))
  call Hloop_A_Q(ntryL,G1H8(119),20,nME,G2H8(75),n2h8(164))
  call Hloop_SV_T(ntryL,G0H16(197),16,ex3(:),4,G1H8(119),m3h2x8(:,304),heltab2x16(:,:,572))
  call Hloop_VV_S(ntryL,G0H16(198),ex3(:),G0H8(39),m3h2x8(:,305),heltab2x16(:,:,573))
  call Hloop_SV_V(ntryL,G1H16(310),ex3(:),G1H8(120),m3h2x8(:,306),heltab2x16(:,:,574))
  call Hloop_VV_S(ntryL,G1H16(311),ex3(:),G1H8(121),m3h2x8(:,307),heltab2x16(:,:,575))
  call Hloop_SV_V(ntryL,G0H16(199),ex3(:),G0H8(40),m3h2x8(:,308),heltab2x16(:,:,576))
  call Hloop_UW_V(ntryL,G0H16(200),16,ex3(:),4,G1H8(122),m3h2x8(:,309),heltab2x16(:,:,577))
  call Hloop_UW_V(ntryL,G1H16(312),16,ex3(:),4,G2H8(76),m3h2x8(:,310),heltab2x16(:,:,578))
  call Hloop_AQ_S(ntryL,G1H16(313),ex1(:),G1H8(123),ngH,m3h2x8(:,311),heltab2x16(:,:,579))
  call Hloop_AQ_S(ntryL,G1H16(314),ex1(:),G1H8(124),ngX,m3h2x8(:,312),heltab2x16(:,:,580))
  call Hloop_SQ_A(ntryL,G1H16(315),ex1(:),G1H8(125),ngPnl,m3h2x8(:,313),heltab2x16(:,:,581))
  call Hloop_Q_A(ntryL,G1H8(125),17,0,G2H8(77),n2h8(165))
  call Hloop_AQ_V(ntryL,G1H16(316),ex1(:),G1H8(125),m3h2x8(:,314),heltab2x16(:,:,582))
  call Hloop_AQ_Z(ntryL,G1H16(317),ex1(:),G1H8(126),ngZl,m3h2x8(:,315),heltab2x16(:,:,583))
  call Hloop_SQ_A(ntryL,G1H16(318),ex1(:),G1H8(127),ngPnl,m3h2x8(:,316),heltab2x16(:,:,584))
  call Hloop_Q_A(ntryL,G1H8(127),17,0,G2H8(78),n2h8(166))
  call Hloop_SQ_A(ntryL,G0H16(201),ex1(:),G0H8(41),ngPnl,m3h2x8(:,317),heltab2x16(:,:,585))
  call Hloop_Q_A(ntryL,G0H8(41),17,0,G1H8(127),n2h8(167))
  call Hloop_WQ_A(ntryL,G0H16(202),ex1(:),G0H8(41),m3h2x8(:,318),heltab2x16(:,:,586))
  call Hloop_Q_A(ntryL,G0H8(41),17,0,G1H8(128),n2h8(168))
  call Hloop_SQ_A(ntryL,G0H16(203),ex1(:),G0H8(41),ngPnl,m3h2x8(:,319),heltab2x16(:,:,587))
  call Hloop_Q_A(ntryL,G0H8(41),17,0,G1H8(129),n2h8(169))
  call Hloop_WQ_A(ntryL,G0H16(204),ex1(:),G0H8(41),m3h2x8(:,320),heltab2x16(:,:,588))
  call Hloop_Q_A(ntryL,G0H8(41),17,0,G1H8(130),n2h8(170))
  call Hloop_WQ_A(ntryL,G1H16(319),ex1(:),G1H8(131),m3h2x8(:,321),heltab2x16(:,:,589))
  call Hloop_Q_A(ntryL,G1H8(131),17,0,G2H8(79),n2h8(171))
  call Hloop_WQ_A(ntryL,G1H16(320),ex1(:),G1H8(131),m3h2x8(:,322),heltab2x16(:,:,590))
  call Hloop_Q_A(ntryL,G1H8(131),17,0,G2H8(80),n2h8(172))
  call Hloop_SA_Q(ntryL,G0H8(17),ex2(:),G0H4(41),ngH,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(173),n2h4(149))
  call Hloop_SA_Q(ntryL,G0H8(18),ex2(:),G0H4(41),ngX,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(174),n2h4(150))
  call Hloop_QA_S(ntryL,G1H8(12),ex2(:),G1H4(177),ngPln,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_VA_Q(ntryL,G0H8(19),ex2(:),G0H4(41),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(178),n2h4(151))
  call Hloop_ZA_Q(ntryL,G0H8(20),ex2(:),G0H4(41),ngZl,m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(15),n2h4(152))
  call Hloop_QA_S(ntryL,G1H8(23),ex2(:),G1H4(34),ngPln,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_QA_S(ntryL,G1H8(24),ex2(:),G1H4(69),ngPln,m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_QA_W(ntryL,G1H8(27),ex2(:),G1H4(72),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_QA_S(ntryL,G1H8(28),ex2(:),G1H4(77),ngPln,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_QA_W(ntryL,G1H8(29),ex2(:),G1H4(132),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_QA_W(ntryL,G1H8(30),ex2(:),G1H4(167),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_QA_W(ntryL,G1H8(31),ex2(:),G1H4(172),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_SA_Q(ntryL,G0H8(21),ex2(:),G0H4(41),ngH,m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(221),n2h4(153))
  call Hloop_SA_Q(ntryL,G0H8(22),ex2(:),G0H4(41),ngX,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(222),n2h4(154))
  call Hloop_QA_S(ntryL,G1H8(32),ex2(:),G1H4(223),ngPln,m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_VA_Q(ntryL,G0H8(23),ex2(:),G0H4(41),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(224),n2h4(155))
  call Hloop_ZA_Q(ntryL,G0H8(24),ex2(:),G0H4(41),ngZl,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(225),n2h4(156))
  call Hloop_QA_S(ntryL,G1H8(41),ex2(:),G1H4(226),ngPln,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_QA_S(ntryL,G1H8(42),ex2(:),G1H4(227),ngPln,m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_QA_W(ntryL,G1H8(43),ex2(:),G1H4(228),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_QA_S(ntryL,G1H8(44),ex2(:),G1H4(229),ngPln,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_QA_W(ntryL,G1H8(53),ex2(:),G1H4(230),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_QA_W(ntryL,G1H8(54),ex2(:),G1H4(231),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_QA_W(ntryL,G1H8(55),ex2(:),G1H4(232),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_SQ_A(ntryL,G0H8(25),ex1(:),G0H4(41),ngH,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(233),n2h4(157))
  call Hloop_SQ_A(ntryL,G0H8(26),ex1(:),G0H4(41),ngX,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(234),n2h4(158))
  call Hloop_AQ_S(ntryL,G1H8(56),ex1(:),G1H4(235),ngPnl,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_VQ_A(ntryL,G0H8(27),ex1(:),G0H4(41),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(236),n2h4(159))
  call Hloop_ZQ_A(ntryL,G0H8(28),ex1(:),G0H4(41),ngZl,m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(237),n2h4(160))
  call Hloop_AQ_S(ntryL,G1H8(65),ex1(:),G1H4(238),ngPnl,m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_AQ_S(ntryL,G1H8(1),ex1(:),G1H4(239),ngPnl,m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AQ_W(ntryL,G1H8(4),ex1(:),G1H4(240),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AQ_S(ntryL,G1H8(6),ex1(:),G1H4(241),ngPnl,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(242),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(13),ex1(:),G1H4(243),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_AQ_W(ntryL,G1H8(16),ex1(:),G1H4(244),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_SQ_A(ntryL,G0H8(29),ex1(:),G0H4(41),ngH,m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(245),n2h4(161))
  call Hloop_SQ_A(ntryL,G0H8(30),ex1(:),G0H4(41),ngX,m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(246),n2h4(162))
  call Hloop_AQ_S(ntryL,G1H8(15),ex1(:),G1H4(247),ngPnl,m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_VQ_A(ntryL,G0H8(31),ex1(:),G0H4(41),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(248),n2h4(163))
  call Hloop_ZQ_A(ntryL,G0H8(32),ex1(:),G0H4(41),ngZl,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(249),n2h4(164))
  call Hloop_AQ_S(ntryL,G1H8(17),ex1(:),G1H4(250),ngPnl,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AQ_S(ntryL,G1H8(20),ex1(:),G1H4(251),ngPnl,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_AQ_W(ntryL,G1H8(19),ex1(:),G1H4(252),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_AQ_S(ntryL,G1H8(21),ex1(:),G1H4(253),ngPnl,m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_AQ_W(ntryL,G1H8(25),ex1(:),G1H4(254),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_AQ_W(ntryL,G1H8(26),ex1(:),G1H4(255),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_AQ_W(ntryL,G1H8(34),ex1(:),G1H4(256),m3h2x4(:,168),heltab2x8(:,:,168))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(117),[G2H4(67),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(71),G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(75),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(80),G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G2H4(85),G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(89),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G2H4(93),G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(98),G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(30),G2H4(82),G2H4(77),G1H4(50),G1H4(38) &
    ,G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(234),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(65),G1H4(150),G1H4(148),G1H4(136),G1H4(44) &
    ,G0H4(32),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(95),G1H4(196),G1H4(192),G1H4(184),G1H4(180) &
    ,G1H4(56),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(6),G1H4(10),G1H4(6),G1H4(214),G1H4(210),G1H4(62) &
    ,G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G2H4(106),G1H4(166),G1H4(162),G1H4(144),G1H4(68) &
    ,G0H4(40),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(39),G2H4(20),G2H4(18),G1H4(116),G1H4(104) &
    ,G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(249),[G1H4(246),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(48),G1H4(51),G1H4(47),G1H4(35),G1H4(110) &
    ,G0H4(11),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(248),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(250),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(83),G1H4(101),G1H4(99),G1H4(89),G1H4(87) &
    ,G1H4(122),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(33),G1H4(119),G1H4(117),G1H4(107),G1H4(105) &
    ,G1H4(128),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(256),[G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(56),G1H4(65),G1H4(63),G1H4(45),G1H4(134) &
    ,G0H4(19),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(28),G2H4(81),G2H4(76),G1H4(158),G1H4(146) &
    ,G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(174),G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(74),G1H4(149),G1H4(147),G1H4(135),G1H4(152) &
    ,G0H4(31),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(94),G1H4(195),G1H4(191),G1H4(183),G1H4(179) &
    ,G1H4(164),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(5),G1H4(9),G1H4(5),G1H4(213),G1H4(209),G1H4(170) &
    ,G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G2H4(105),G1H4(165),G1H4(161),G1H4(143),G1H4(176) &
    ,G0H4(39),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(221),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(40),G2H4(21),G2H4(19),G1H4(200),G1H4(188) &
    ,G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(225),[G1H4(222),G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(49),G1H4(52),G1H4(48),G1H4(36),G1H4(194) &
    ,G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(226),[G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(96),G1H4(102),G1H4(100),G1H4(90),G1H4(88) &
    ,G1H4(206),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(31),G1H4(120),G1H4(118),G1H4(108),G1H4(106) &
    ,G1H4(212),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(232),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(58),G1H4(66),G1H4(64),G1H4(46),G1H4(218) &
    ,G0H4(20),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(52),G1H4(41),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(53),G1H4(42),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(22),G1H4(95),G1H4(93),G1H4(83),G1H4(81) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(23),G1H4(96),G1H4(94),G1H4(84),G1H4(82) &
    ,G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(63),G2H4(62),G2H4(61),G1H4(59),G1H4(58) &
    ,G1H4(53),G0H4(16),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(72),G2H4(69),G2H4(68),G1H4(60),G1H4(57) &
    ,G1H4(54),G0H4(14),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(35),G1H4(125),G1H4(123),G1H4(113),G1H4(111) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(36),G1H4(126),G1H4(124),G1H4(114),G1H4(112) &
    ,G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G2H4(101),G1H4(141),G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G2H4(102),G1H4(142),G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(86),G1H4(201),G1H4(197),G1H4(189),G1H4(185) &
    ,G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(87),G1H4(202),G1H4(198),G1H4(190),G1H4(186) &
    ,G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(112),[G2H4(111),G2H4(110),G2H4(109),G1H4(159),G1H4(156) &
    ,G1H4(153),G0H4(36),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G2H4(115),G2H4(114),G2H4(113),G1H4(160),G1H4(155) &
    ,G1H4(154),G0H4(34),G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(10),G1H4(219),G1H4(215),G1H4(207),G1H4(203) &
    ,G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(25),G1H4(220),G1H4(216),G1H4(208),G1H4(204) &
    ,G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G2H8(17),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G2H8(19),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(57),G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(8),G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G2H8(21),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(23),G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G0H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G2H8(46),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G2H8(44),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(81),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G2H8(49),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(51),G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G1H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(58),[G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G1H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(66),[G0H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G1H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(73),[G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(122),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(76),[G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(78),[G1H8(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G1H8(129)])
call HGT_OLR(G2H4(66),1,1,4)
call HGT_invQ_OLR(G2H4(66),2,5,4)
call HGT_OLR(G2H4(66),6,15,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(26),mass4set(:,1),  & 
G1H4(30),G1H4(70),G1H4(33),G1H4(71),G1H4(130),4)
  call HG1shiftOLR(G1H4(70),2,4)
  call Hloop_QA_S(ntryL,G2H4(117),ex2(:),G2H2(5),ngPln,m3h2x2(:,185),heltab2x4(:,:,185))
call HGT_lower_alpha_w2_OLR(G1H4(1),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(14),ngPnl,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(14),29,0,G2H2(6),n2h2(61))
  call Hloop_QA_W(ntryL,G2H4(118),ex2(:),G2H2(7),m3h2x2(:,187),heltab2x4(:,:,187))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(2),ex1(:),G1H2(20),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(8),n2h2(62))
  call Hloop_QA_S(ntryL,G2H4(119),ex2(:),G2H2(13),ngPln,m3h2x2(:,189),heltab2x4(:,:,189))
call HGT_lower_alpha_OLR(G2H4(79),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(79),2,5,4)
call HGT_lower_alpha_OLR(G2H4(79),6,15,4)
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(26),mass4set(:,1),  & 
G1H4(168),G1H4(131),G1H4(171),G1H4(8),G1H4(14),4)
  call HG1shiftOLR(G1H4(131),2,4)
  call Hloop_QA_W(ntryL,G2H4(120),ex2(:),G2H2(14),m3h2x2(:,190),heltab2x4(:,:,190))
call HGT_OLR(G2H4(84),1,1,4)
call HGT_invQ_OLR(G2H4(84),2,5,4)
call HGT_OLR(G2H4(84),6,15,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(27),mass4set(:,1),  & 
G1H4(20),G1H4(26),G1H4(31),G1H4(50),G1H4(38),4)
  call HG1shiftOLR(G1H4(26),1,4)
  call Hloop_AQ_S(ntryL,G2H4(121),ex1(:),G2H2(15),ngPnl,m3h2x2(:,191),heltab2x4(:,:,191))
call HGT_lower_alpha_w2_OLR(G1H4(3),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(3),ex2(:),G1H2(26),ngPln,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(26),30,0,G2H2(16),n2h2(63))
  call Hloop_AQ_W(ntryL,G2H4(122),ex1(:),G2H2(17),m3h2x2(:,193),heltab2x4(:,:,193))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(4),ex2(:),G1H2(32),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(32),30,0,G2H2(18),n2h2(64))
  call Hloop_AQ_S(ntryL,G2H4(123),ex1(:),G2H2(19),ngPnl,m3h2x2(:,195),heltab2x4(:,:,195))
call HGT_lower_alpha_OLR(G2H4(97),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(97),2,5,4)
call HGT_lower_alpha_OLR(G2H4(97),6,15,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(27),mass4set(:,1),  & 
G1H4(32),G1H4(234),G1H4(37),G1H4(43),G1H4(150),4)
  call HG1shiftOLR(G1H4(234),1,4)
  call Hloop_AQ_W(ntryL,G2H4(124),ex1(:),G2H2(20),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_SA_Q(ntryL,G1H4(7),ex2(:),G1H2(38),ngH,m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(38),23,nME,G2H2(21),n2h2(65))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(44),ngH,m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(44),23,nME,G2H2(22),n2h2(66))
  call Hloop_SA_Q(ntryL,G1H4(13),ex2(:),G1H2(50),ngX,m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(50),23,nME,G2H2(23),n2h2(67))
  call Hloop_SA_Q(ntryL,G1H4(12),ex2(:),G1H2(56),ngX,m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(56),23,nME,G2H2(24),n2h2(68))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(62),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(62),23,nME,G2H2(45),n2h2(69))
  call Hloop_VA_Q(ntryL,G1H4(16),ex2(:),G1H2(68),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(68),23,nME,G2H2(48),n2h2(70))
  call Hloop_ZA_Q(ntryL,G1H4(25),ex2(:),G1H2(74),ngZl,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(74),23,nME,G2H2(87),n2h2(71))
  call Hloop_ZA_Q(ntryL,G1H4(29),ex2(:),G1H2(80),ngZl,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(80),23,nME,G2H2(90),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(233),ex3(:),G1H2(106),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(106),23,nME,G2H2(1),n2h2(73))
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(10),mass4set(:,9),  & 
G1H4(148),G1H4(136),G1H4(44),G1H4(49),G1H4(55),G0H4(41),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hloop_QV_A(ntryL,G1H4(237),ex3(:),G1H2(117),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(117),23,nME,G2H2(2),n2h2(74))
  call Hloop_TV_S(ntryL,G1H4(235),19,ex3(:),4,G2H2(3),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(10),mass4set(:,10),  & 
G1H4(196),G1H4(192),G1H4(184),G1H4(180),G1H4(56),G0H4(32),4)
  call HG1shiftOLR(G1H4(192),8,4)
  call Hloop_QV_A(ntryL,G1H4(236),ex3(:),G1H2(128),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(128),23,nME,G2H2(4),n2h2(75))
  call Hloop_TV_S(ntryL,G1H4(238),19,ex3(:),4,G2H2(76),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hotf_4pt_reduction(G2H4(100),RedSet_4(10),mass4set(:,10),  & 
G1H4(61),G1H4(10),G1H4(6),G1H4(214),G1H4(210),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_UV_W(ntryL,G1H4(243),19,ex3(:),4,G2H2(65),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(10),mass4set(:,10),  & 
G1H4(62),G1H4(67),G1H4(166),G1H4(162),G1H4(144),4)
  call HG1shiftOLR(G1H4(67),8,4)
  call Hloop_UV_W(ntryL,G1H4(244),19,ex3(:),4,G2H2(79),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hotf_4pt_reduction(G2H4(108),RedSet_4(10),mass4set(:,10),  & 
G1H4(68),G1H4(74),G1H4(80),G1H4(86),G1H4(92),G0H4(30),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hloop_SQ_A(ntryL,G1H4(73),ex1(:),G1H2(139),ngH,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(139),23,nME,G2H2(73),n2h2(76))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(150),ngH,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(150),23,nME,G2H2(9),n2h2(77))
  call Hloop_SQ_A(ntryL,G1H4(79),ex1(:),G1H2(166),ngX,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(166),23,nME,G2H2(10),n2h2(78))
  call Hloop_SQ_A(ntryL,G1H4(76),ex1(:),G1H2(182),ngX,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(182),23,nME,G2H2(11),n2h2(79))
  call Hloop_VQ_A(ntryL,G1H4(85),ex1(:),G1H2(193),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(193),23,nME,G2H2(12),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H4(78),ex1(:),G1H2(204),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(204),23,nME,G2H2(118),n2h2(81))
  call Hloop_ZQ_A(ntryL,G1H4(91),ex1(:),G1H2(215),ngZl,m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(215),23,nME,G2H2(107),n2h2(82))
  call Hloop_ZQ_A(ntryL,G1H4(129),ex1(:),G1H2(226),ngZl,m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(226),23,nME,G2H2(121),n2h2(83))
  call Hloop_QV_A(ntryL,G1H4(245),ex4(:),G1H2(242),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(242),27,nME,G2H2(115),n2h2(84))
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(17),mass4set(:,9),  & 
G1H4(97),G1H4(116),G1H4(104),G1H4(98),G1H4(246),G0H4(22),4)
  call HG1shiftOLR(G1H4(116),4,4)
  call Hloop_QV_A(ntryL,G1H4(249),ex4(:),G1H2(258),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(258),27,nME,G2H2(144),n2h2(85))
  call Hloop_TV_S(ntryL,G1H4(247),19,ex4(:),8,G2H2(133),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(17),mass4set(:,10),  & 
G1H4(103),G1H4(109),G1H4(51),G1H4(47),G1H4(35),G0H4(28),4)
  call HG1shiftOLR(G1H4(109),4,4)
  call Hloop_QV_A(ntryL,G1H4(248),ex4(:),G1H2(269),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(269),27,nME,G2H2(147),n2h2(86))
  call Hloop_TV_S(ntryL,G1H4(250),19,ex4(:),8,G2H2(141),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hotf_4pt_reduction(G2H4(88),RedSet_4(17),mass4set(:,10),  & 
G1H4(110),G1H4(115),G1H4(121),G1H4(101),G1H4(99),4)
  call HG1shiftOLR(G1H4(115),4,4)
  call Hloop_UV_W(ntryL,G1H4(255),19,ex4(:),8,G2H2(170),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(17),mass4set(:,10),  & 
G1H4(89),G1H4(87),G1H4(122),G1H4(127),G1H4(119),4)
  call HG1shiftOLR(G1H4(87),4,4)
  call Hloop_UV_W(ntryL,G1H4(256),19,ex4(:),8,G2H2(159),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(17),mass4set(:,10),  & 
G1H4(117),G1H4(107),G1H4(105),G1H4(128),G1H4(133),G0H4(40),4)
  call HG1shiftOLR(G1H4(107),4,4)
  call Hloop_AV_Q(ntryL,G1H4(173),ex3(:),G1H2(285),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(285),23,nME,G2H2(173),n2h2(87))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(10),mass4set(:,9),  & 
G1H4(65),G1H4(63),G1H4(45),G1H4(134),G1H4(139),G0H4(38),4)
  call HG1shiftOLR(G1H4(63),8,4)
  call Hloop_AV_Q(ntryL,G1H4(15),ex3(:),G1H2(301),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(301),23,nME,G2H2(167),n2h2(88))
  call Hloop_SV_T(ntryL,G1H4(177),19,ex3(:),4,G2H2(26),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(10),mass4set(:,10),  & 
G1H4(158),G1H4(146),G1H4(140),G1H4(174),G1H4(145),G0H4(11),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hloop_AV_Q(ntryL,G1H4(178),ex3(:),G1H2(312),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_A_Q(ntryL,G1H2(312),23,nME,G2H2(28),n2h2(89))
  call Hloop_SV_T(ntryL,G1H4(34),19,ex3(:),4,G2H2(30),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(10),mass4set(:,10),  & 
G1H4(151),G1H4(149),G1H4(147),G1H4(135),G1H4(152),4)
  call HG1shiftOLR(G1H4(149),8,4)
  call Hloop_UW_V(ntryL,G1H4(167),19,ex3(:),4,G2H2(32),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(10),mass4set(:,10),  & 
G1H4(157),G1H4(163),G1H4(195),G1H4(191),G1H4(183),4)
  call HG1shiftOLR(G1H4(163),8,4)
  call Hloop_UW_V(ntryL,G1H4(172),19,ex3(:),4,G2H2(34),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(10),mass4set(:,10),  & 
G1H4(179),G1H4(164),G1H4(169),G1H4(9),G1H4(5),G0H4(9),4)
  call HG1shiftOLR(G1H4(164),8,4)
  call Hloop_AV_Q(ntryL,G1H4(221),ex4(:),G1H2(328),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(328),27,nME,G2H2(36),n2h2(90))
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(17),mass4set(:,9),  & 
G1H4(213),G1H4(209),G1H4(170),G1H4(175),G1H4(165),G0H4(1),4)
  call HG1shiftOLR(G1H4(209),4,4)
  call Hloop_AV_Q(ntryL,G1H4(225),ex4(:),G1H2(9),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(9),27,nME,G2H2(38),n2h2(91))
  call Hloop_SV_T(ntryL,G1H4(223),19,ex4(:),8,G2H2(40),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(17),mass4set(:,10),  & 
G1H4(161),G1H4(143),G1H4(176),G1H4(181),G1H4(200),G0H4(7),4)
  call HG1shiftOLR(G1H4(143),4,4)
  call Hloop_AV_Q(ntryL,G1H4(224),ex4(:),G1H2(10),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(10),27,nME,G2H2(41),n2h2(92))
  call Hloop_SV_T(ntryL,G1H4(226),19,ex4(:),8,G2H2(44),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(17),mass4set(:,10),  & 
G1H4(188),G1H4(182),G1H4(222),G1H4(187),G1H4(193),4)
  call HG1shiftOLR(G1H4(182),4,4)
  call Hloop_UW_V(ntryL,G1H4(231),19,ex4(:),8,G2H2(53),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(17),mass4set(:,10),  & 
G1H4(52),G1H4(48),G1H4(36),G1H4(194),G1H4(199),4)
  call HG1shiftOLR(G1H4(48),4,4)
  call Hloop_UW_V(ntryL,G1H4(232),19,ex4(:),8,G2H2(56),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(17),mass4set(:,10),  & 
G1H4(205),G1H4(102),G1H4(100),G1H4(90),G1H4(88),G0H4(19),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hloop_QA_S(ntryL,G2H4(9),ex2(:),G2H2(49),ngPln,m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_QA_W(ntryL,G2H4(13),ex2(:),G2H2(52),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_QA_S(ntryL,G2H4(11),ex2(:),G2H2(57),ngPln,m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_QA_W(ntryL,G2H4(12),ex2(:),G2H2(60),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_AQ_S(ntryL,G2H4(14),ex1(:),G2H2(61),ngPnl,m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_AQ_W(ntryL,G2H4(15),ex1(:),G2H2(64),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_AQ_S(ntryL,G2H4(16),ex1(:),G2H2(68),ngPnl,m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_AQ_W(ntryL,G2H4(17),ex1(:),G2H2(69),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_AQ_S(ntryL,G1H4(17),ex1(:),G1H2(81),ngPnl,m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_AQ_W(ntryL,G1H4(18),ex1(:),G1H2(15),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_AQ_S(ntryL,G1H4(21),ex1(:),G1H2(16),ngPnl,m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_AQ_W(ntryL,G1H4(22),ex1(:),G1H2(86),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_QA_S(ntryL,G1H4(23),ex2(:),G1H2(21),ngPln,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_QA_W(ntryL,G1H4(24),ex2(:),G1H2(22),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_QA_S(ntryL,G1H4(27),ex2(:),G1H2(156),ngPln,m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_QA_W(ntryL,G1H4(28),ex2(:),G1H2(27),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_QA_S(ntryL,G2H8(1),ex2(:),G2H4(67),ngPln,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(71),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(75),ngPnl,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(80),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(17),mass4set(:,10),  & 
G1H4(206),G1H4(211),G1H4(120),G1H4(118),G1H4(108),G0H4(17),4)
  call HG1shiftOLR(G1H4(211),4,4)
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(17),mass4set(:,10),  & 
G1H4(106),G1H4(212),G1H4(217),G1H4(66),G1H4(64),G0H4(31),4)
  call HG1shiftOLR(G1H4(212),4,4)
  call Hloop_VV_S(ntryL,G2H4(24),ex4(:),G2H2(72),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_VV_S(ntryL,G2H4(92),ex4(:),G2H2(75),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_SV_V(ntryL,G2H4(64),ex4(:),G2H2(78),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_VV_S(ntryL,G2H4(73),ex4(:),G2H2(82),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_SV_V(ntryL,G2H4(37),ex4(:),G2H2(83),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_SV_V(ntryL,G2H4(38),ex4(:),G2H2(86),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(17),mass4set(:,11),  & 
G1H4(46),G1H4(218),G1H4(41),G1H4(39),G1H4(42),G0H4(29),4)
  call HG1shiftOLR(G1H4(218),4,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(17),mass4set(:,11),  & 
G1H4(40),G1H4(95),G1H4(93),G1H4(83),G1H4(81),G0H4(21),4)
  call HG1shiftOLR(G1H4(95),4,4)
  call Hotf_4pt_reduction(G2H4(103),RedSet_4(10),mass4set(:,10),  & 
G1H4(96),G1H4(94),G1H4(84),G1H4(82),G1H4(59),G0H4(27),4)
  call HG1shiftOLR(G1H4(94),8,4)
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(10),mass4set(:,10),  & 
G1H4(58),G1H4(53),G1H4(60),G1H4(57),G1H4(54),G0H4(39),4)
  call HG1shiftOLR(G1H4(53),8,4)
  call Hloop_VV_S(ntryL,G2H4(90),ex3(:),G2H2(95),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_VV_S(ntryL,G2H4(91),ex3(:),G2H2(98),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_SV_V(ntryL,G2H4(112),ex3(:),G2H2(91),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_VV_S(ntryL,G2H4(116),ex3(:),G2H2(94),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_SV_V(ntryL,G2H4(26),ex3(:),G2H2(99),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_SV_V(ntryL,G2H4(27),ex3(:),G2H2(102),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(10),mass4set(:,11),  & 
G1H4(125),G1H4(123),G1H4(113),G1H4(111),G1H4(126),G0H4(37),4)
  call HG1shiftOLR(G1H4(123),8,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(10),mass4set(:,11),  & 
G1H4(124),G1H4(114),G1H4(112),G1H4(141),G1H4(137),G0H4(12),4)
  call HG1shiftOLR(G1H4(114),8,4)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(7),mass4set(:,9),  & 
G1H8(131),G1H8(12),G1H8(23),G1H8(24),G1H8(27),G0H8(41),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(7),mass4set(:,9),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),G0H8(17),8)
  call HG1shiftOLR(G1H8(29),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(7),mass4set(:,9),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(53),G0H8(18),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(7),mass4set(:,9),  & 
G1H8(54),G1H8(55),G1H8(56),G1H8(65),G1H8(1),G0H8(19),8)
  call HG1shiftOLR(G1H8(55),8,8)
  call Hloop_SS_S(ntryL,G2H8(9),wf4(:,36),G2H2(103),m3h4x2(:,1),heltab2x8(:,:,173))
  call Hloop_SS_S(ntryL,G2H8(12),wf4(:,36),G2H2(106),m3h4x2(:,2),heltab2x8(:,:,174))
  call Hloop_SS_S(ntryL,G2H8(10),wf4(:,36),G2H2(110),m3h4x2(:,3),heltab2x8(:,:,175))
  call Hloop_SS_S(ntryL,G2H8(11),wf4(:,36),G2H2(111),m3h4x2(:,4),heltab2x8(:,:,176))
  call Hloop_SS_S(ntryL,G2H8(14),wf4(:,37),G2H2(114),m3h4x2(:,5),heltab2x8(:,:,177))
  call Hloop_SS_S(ntryL,G2H8(15),wf4(:,37),G2H2(117),m3h4x2(:,6),heltab2x8(:,:,178))
  call Hloop_VS_V(ntryL,G2H8(13),wf4(:,36),G2H2(120),m3h4x2(:,7),heltab2x8(:,:,179))
  call Hloop_VS_V(ntryL,G2H8(16),wf4(:,36),G2H2(124),m3h4x2(:,8),heltab2x8(:,:,180))
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(7),mass4set(:,10),  & 
G1H8(4),G1H8(6),G1H8(14),G1H8(13),G1H8(16),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(7),mass4set(:,10),  & 
G1H8(15),G1H8(17),G1H8(20),G1H8(19),G1H8(21),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hloop_SS_S(ntryL,G1H8(10),wf4(:,36),G1H2(28),m3h4x2(:,9),heltab2x8(:,:,181))
  call Hloop_VT_S(ntryL,G1H8(11),20,wf4(:,36),3,G2H2(125),m3h4x2(:,10),heltab2x8(:,:,182))
  call Hloop_VT_S(ntryL,G1H8(2),20,wf4(:,36),3,G2H2(128),m3h4x2(:,11),heltab2x8(:,:,183))
  call Hloop_VT_S(ntryL,G1H8(18),20,wf4(:,37),3,G2H2(129),m3h4x2(:,12),heltab2x8(:,:,184))
  call Hloop_VT_S(ntryL,G1H8(22),20,wf4(:,37),3,G2H2(132),m3h4x2(:,13),heltab2x8(:,:,185))
  call Hloop_ST_V(ntryL,G1H8(38),20,wf4(:,36),3,G2H2(136),m3h4x2(:,14),heltab2x8(:,:,186))
  call Hloop_ST_V(ntryL,G1H8(45),20,wf4(:,36),3,G2H2(137),m3h4x2(:,15),heltab2x8(:,:,187))
  call Hloop_ST_V(ntryL,G1H8(51),20,wf4(:,37),3,G2H2(140),m3h4x2(:,16),heltab2x8(:,:,188))
  call Hloop_ST_V(ntryL,G1H8(60),20,wf4(:,37),3,G2H2(143),m3h4x2(:,17),heltab2x8(:,:,189))
  call Hloop_VS_V(ntryL,G1H8(33),wf4(:,36),G1H2(172),m3h4x2(:,18),heltab2x8(:,:,190))
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(7),mass4set(:,10),  & 
G1H8(25),G1H8(26),G1H8(34),G1H8(36),G1H8(35),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(7),mass4set(:,10),  & 
G1H8(39),G1H8(46),G1H8(57),G1H8(58),G1H8(61),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(7),mass4set(:,9),  & 
G1H8(62),G1H8(59),G1H8(64),G1H8(63),G1H8(3),G0H8(20),8)
  call HG1shiftOLR(G1H8(59),8,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(7),mass4set(:,9),  & 
G1H8(5),G1H8(7),G1H8(8),G1H8(9),G1H8(40),G0H8(21),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(7),mass4set(:,11),  & 
G1H8(49),G1H8(50),G1H8(47),G1H8(48),G1H8(52),G0H8(22),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(7),mass4set(:,11),  & 
G1H8(37),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G0H8(23),8)
  call HG1shiftOLR(G1H8(66),8,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(7),mass4set(:,9),  & 
G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),G0H8(24),8)
  call HG1shiftOLR(G1H8(71),8,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(7),mass4set(:,9),  & 
G1H8(96),G1H8(98),G1H8(95),G1H8(97),G1H8(104),G0H8(25),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(7),mass4set(:,11),  & 
G1H8(106),G1H8(103),G1H8(105),G1H8(107),G1H8(108),G0H8(26),8)
  call HG1shiftOLR(G1H8(103),8,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(7),mass4set(:,11),  & 
G1H8(116),G1H8(118),G1H8(115),G1H8(117),G1H8(119),G0H8(27),8)
  call HG1shiftOLR(G1H8(118),8,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(7),mass4set(:,10),  & 
G1H8(120),G1H8(128),G1H8(130),G1H8(127),G1H8(129),G0H8(28),8)
  call HG1shiftOLR(G1H8(128),8,8)
  call Hotf_4pt_reduction(G2H8(37),RedSet_4(7),mass4set(:,10),  & 
G1H8(10),G1H8(11),G1H8(2),G1H8(18),G1H8(22),G0H8(29),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(7),mass4set(:,10),  & 
G1H8(38),G1H8(45),G1H8(51),G1H8(60),G1H8(33),G0H8(30),8)
  call HG1shiftOLR(G1H8(45),8,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(7),mass4set(:,10),  & 
G1H8(132),G1H8(133),G1H8(134),G1H8(135),G1H8(136),G0H8(31),8)
  call HG1shiftOLR(G1H8(133),8,8)
  call Hotf_4pt_reduction(G2H8(38),RedSet_4(7),mass4set(:,10),  & 
G1H8(137),G1H8(138),G1H8(139),G1H8(140),G1H8(141),G0H8(32),8)
  call HG1shiftOLR(G1H8(138),8,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(7),mass4set(:,10),  & 
G1H8(142),G1H8(143),G1H8(144),G1H8(145),G1H8(146),G0H8(16),8)
  call HG1shiftOLR(G1H8(143),8,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(7),mass4set(:,10),  & 
G1H8(147),G1H8(148),G1H8(149),G1H8(150),G1H8(151),G0H8(8),8)
  call HG1shiftOLR(G1H8(148),8,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(7),mass4set(:,10),  & 
G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),G0H8(1),8)
  call HG1shiftOLR(G1H8(153),8,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(7),mass4set(:,10),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G0H8(2),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(7),mass4set(:,10),  & 
G1H8(162),G1H8(163),G1H8(164),G1H8(165),G1H8(166),G0H8(12),8)
  call HG1shiftOLR(G1H8(163),8,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(7),mass4set(:,10),  & 
G1H8(167),G1H8(168),G1H8(169),G1H8(170),G1H8(171),G0H8(9),8)
  call HG1shiftOLR(G1H8(168),8,8)
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(7),mass4set(:,10),  & 
G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),G0H8(10),8)
  call HG1shiftOLR(G1H8(173),8,8)
  call Hloop_SV_V(ntryL,G2H8(47),wf4(:,13),G2H2(146),m3h4x2(:,19),heltab2x8(:,:,191))
  call Hloop_SV_V(ntryL,G2H8(48),wf4(:,14),G2H2(150),m3h4x2(:,20),heltab2x8(:,:,192))
  call Hloop_TV_S(ntryL,G1H8(75),20,wf4(:,13),3,G2H2(151),m3h4x2(:,21),heltab2x8(:,:,193))
  call Hloop_SV_T(ntryL,G1H8(76),20,wf4(:,13),3,G2H2(154),m3h4x2(:,22),heltab2x8(:,:,194))
  call Hloop_TV_S(ntryL,G1H8(77),20,wf4(:,14),3,G2H2(155),m3h4x2(:,23),heltab2x8(:,:,195))
  call Hloop_SV_T(ntryL,G1H8(78),20,wf4(:,14),3,G2H2(158),m3h4x2(:,24),heltab2x8(:,:,196))
  call Hloop_VV_S(ntryL,G1H8(79),wf4(:,13),G1H2(33),m3h4x2(:,25),heltab2x8(:,:,197))
  call Hloop_VV_S(ntryL,G1H8(80),wf4(:,13),G1H2(34),m3h4x2(:,26),heltab2x8(:,:,198))
  call Hloop_VV_S(ntryL,G1H8(81),wf4(:,14),G1H2(91),m3h4x2(:,27),heltab2x8(:,:,199))
  call Hloop_VV_S(ntryL,G1H8(82),wf4(:,14),G1H2(39),m3h4x2(:,28),heltab2x8(:,:,200))
  call Hloop_SV_V(ntryL,G1H8(83),wf4(:,13),G1H2(40),m3h4x2(:,29),heltab2x8(:,:,201))
  call Hloop_SV_V(ntryL,G1H8(84),wf4(:,13),G1H2(96),m3h4x2(:,30),heltab2x8(:,:,202))
  call Hloop_SV_V(ntryL,G1H8(85),wf4(:,14),G1H2(45),m3h4x2(:,31),heltab2x8(:,:,203))
  call Hloop_SV_V(ntryL,G1H8(86),wf4(:,14),G1H2(46),m3h4x2(:,32),heltab2x8(:,:,204))
  call Hloop_UV_W(ntryL,G1H8(87),20,wf4(:,13),3,G2H2(162),m3h4x2(:,33),heltab2x8(:,:,205))
  call Hloop_UW_V(ntryL,G1H8(88),20,wf4(:,13),3,G2H2(163),m3h4x2(:,34),heltab2x8(:,:,206))
  call Hloop_UV_W(ntryL,G1H8(89),20,wf4(:,14),3,G2H2(166),m3h4x2(:,35),heltab2x8(:,:,207))
  call Hloop_UW_V(ntryL,G1H8(90),20,wf4(:,14),3,G2H2(169),m3h4x2(:,36),heltab2x8(:,:,208))
  call Hloop_VV_S(ntryL,G2H8(50),wf4(:,13),G2H2(172),m3h4x2(:,37),heltab2x8(:,:,209))
  call Hloop_VV_S(ntryL,G2H8(52),wf4(:,14),G2H2(176),m3h4x2(:,38),heltab2x8(:,:,210))
  call Hloop_SQ_A(ntryL,G1H8(91),wf4(:,3),G1H2(232),ngH,m3h4x2(:,39),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(232),23,nME,G2H2(177),n2h2(93))
  call Hloop_SQ_A(ntryL,G1H8(92),wf4(:,3),G1H2(51),ngX,m3h4x2(:,40),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(51),23,nME,G2H2(178),n2h2(94))
  call Hloop_AQ_S(ntryL,G2H8(53),wf4(:,3),G2H2(179),ngPnl,m3h4x2(:,41),heltab2x8(:,:,213))
  call Hloop_VQ_A(ntryL,G1H8(93),wf4(:,3),G1H2(52),m3h4x2(:,42),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(52),23,nME,G2H2(180),n2h2(95))
  call Hloop_ZQ_A(ntryL,G1H8(94),wf4(:,3),G1H2(248),ngZl,m3h4x2(:,43),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(248),23,nME,G2H2(181),n2h2(96))
  call Hloop_AQ_W(ntryL,G2H8(54),wf4(:,3),G2H2(182),m3h4x2(:,44),heltab2x8(:,:,216))
  call Hloop_AQ_S(ntryL,G2H8(55),wf4(:,3),G2H2(183),ngPnl,m3h4x2(:,45),heltab2x8(:,:,217))
  call Hloop_AQ_W(ntryL,G2H8(56),wf4(:,3),G2H2(184),m3h4x2(:,46),heltab2x8(:,:,218))
  call Hloop_SA_Q(ntryL,G1H8(99),wf4(:,10),G1H2(57),ngH,m3h4x2(:,47),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(57),23,nME,G2H2(185),n2h2(97))
  call Hloop_SA_Q(ntryL,G1H8(100),wf4(:,10),G1H2(58),ngX,m3h4x2(:,48),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(58),23,nME,G2H2(186),n2h2(98))
  call Hloop_QA_S(ntryL,G2H8(57),wf4(:,10),G2H2(187),ngPln,m3h4x2(:,49),heltab2x8(:,:,221))
  call Hloop_VA_Q(ntryL,G1H8(101),wf4(:,10),G1H2(275),m3h4x2(:,50),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(275),23,nME,G2H2(188),n2h2(99))
  call Hloop_ZA_Q(ntryL,G1H8(102),wf4(:,10),G1H2(63),ngZl,m3h4x2(:,51),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(63),23,nME,G2H2(189),n2h2(100))
  call Hloop_QA_W(ntryL,G2H8(58),wf4(:,10),G2H2(190),m3h4x2(:,52),heltab2x8(:,:,224))
  call Hloop_QA_S(ntryL,G2H8(59),wf4(:,10),G2H2(191),ngPln,m3h4x2(:,53),heltab2x8(:,:,225))
  call Hloop_QA_W(ntryL,G2H8(60),wf4(:,10),G2H2(192),m3h4x2(:,54),heltab2x8(:,:,226))
  call Hloop_QA_S(ntryL,G2H8(61),ex2(:),G2H4(85),ngH,m3h2x4(:,173),heltab2x8(:,:,227))
  call Hloop_QA_S(ntryL,G2H8(62),ex2(:),G2H4(89),ngX,m3h2x4(:,174),heltab2x8(:,:,228))
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(2),mass4set(:,1),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
  call HG1shiftOLR(G1H8(76),9,8)
  call Hloop_QA_V(ntryL,G2H8(64),ex2(:),G2H4(93),m3h2x4(:,175),heltab2x8(:,:,229))
  call Hloop_QA_Z(ntryL,G2H8(65),ex2(:),G2H4(98),ngZl,m3h2x4(:,176),heltab2x8(:,:,230))
  call Hloop_SA_Q(ntryL,G1H8(109),ex2(:),G1H4(142),ngPln,m3h2x4(:,177),heltab2x8(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(142),22,0,G2H4(30),n2h4(165))
  call Hloop_WA_Q(ntryL,G1H8(110),ex2(:),G1H4(138),m3h2x4(:,178),heltab2x8(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(138),22,0,G2H4(82),n2h4(166))
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(2),mass4set(:,1),  & 
G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(81),9,8)
  call Hloop_SQ_A(ntryL,G1H8(111),wf4(:,9),G1H2(64),ngH,m3h4x2(:,55),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(64),27,nME,G2H2(193),n2h2(101))
  call Hloop_SQ_A(ntryL,G1H8(112),wf4(:,9),G1H2(291),ngX,m3h4x2(:,56),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(291),27,nME,G2H2(194),n2h2(102))
  call Hloop_AQ_S(ntryL,G2H8(67),wf4(:,9),G2H2(195),ngPnl,m3h4x2(:,57),heltab2x8(:,:,235))
  call Hloop_VQ_A(ntryL,G1H8(113),wf4(:,9),G1H2(69),m3h4x2(:,58),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(69),27,nME,G2H2(196),n2h2(103))
  call Hloop_ZQ_A(ntryL,G1H8(114),wf4(:,9),G1H2(70),ngZl,m3h4x2(:,59),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(70),27,nME,G2H2(197),n2h2(104))
  call Hloop_AQ_W(ntryL,G2H8(68),wf4(:,9),G2H2(198),m3h4x2(:,60),heltab2x8(:,:,238))
  call Hloop_AQ_S(ntryL,G2H8(69),wf4(:,9),G2H2(199),ngPnl,m3h4x2(:,61),heltab2x8(:,:,239))
  call Hloop_AQ_W(ntryL,G2H8(70),wf4(:,9),G2H2(200),m3h4x2(:,62),heltab2x8(:,:,240))
  call Hloop_AQ_S(ntryL,G2H8(71),ex1(:),G2H4(77),ngH,m3h2x4(:,179),heltab2x8(:,:,241))
  call Hloop_AQ_S(ntryL,G2H8(72),ex1(:),G2H4(65),ngX,m3h2x4(:,180),heltab2x8(:,:,242))
  call Hotf_4pt_reduction(G2H8(73),RedSet_4(1),mass4set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),8)
  call HG1shiftOLR(G1H8(86),10,8)
  call Hloop_AQ_V(ntryL,G2H8(74),ex1(:),G2H4(95),m3h2x4(:,181),heltab2x8(:,:,243))
  call Hloop_AQ_Z(ntryL,G2H8(75),ex1(:),G2H4(6),ngZl,m3h2x4(:,182),heltab2x8(:,:,244))
  call Hloop_SQ_A(ntryL,G1H8(121),ex1(:),G1H4(201),ngPnl,m3h2x4(:,183),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(201),21,0,G2H4(106),n2h4(167))
  call Hloop_WQ_A(ntryL,G1H8(122),ex1(:),G1H4(197),m3h2x4(:,184),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(197),21,0,G2H4(39),n2h4(168))
  call Hotf_4pt_reduction(G2H8(76),RedSet_4(1),mass4set(:,1),  & 
G1H8(90),G1H8(91),G1H8(92),G1H8(93),G1H8(94),8)
  call HG1shiftOLR(G1H8(91),10,8)
  call Hloop_SA_Q(ntryL,G1H8(123),wf4(:,4),G1H2(318),ngH,m3h4x2(:,63),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(318),27,nME,G2H2(201),n2h2(105))
  call Hloop_SA_Q(ntryL,G1H8(124),wf4(:,4),G1H2(75),ngX,m3h4x2(:,64),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(75),27,nME,G2H2(202),n2h2(106))
  call Hloop_QA_S(ntryL,G2H8(77),wf4(:,4),G2H2(203),ngPln,m3h4x2(:,65),heltab2x8(:,:,249))
  call Hloop_VA_Q(ntryL,G1H8(125),wf4(:,4),G1H2(76),m3h4x2(:,66),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(76),27,nME,G2H2(204),n2h2(107))
  call Hloop_ZA_Q(ntryL,G1H8(126),wf4(:,4),G1H2(334),ngZl,m3h4x2(:,67),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(334),27,nME,G2H2(205),n2h2(108))
  call Hloop_QA_W(ntryL,G2H8(78),wf4(:,4),G2H2(206),m3h4x2(:,68),heltab2x8(:,:,252))
  call Hloop_QA_S(ntryL,G2H8(79),wf4(:,4),G2H2(207),ngPln,m3h4x2(:,69),heltab2x8(:,:,253))
  call Hloop_QA_W(ntryL,G2H8(80),wf4(:,4),G2H2(208),m3h4x2(:,70),heltab2x8(:,:,254))
  call Hloop_SV_V(ntryL,G1H4(69),ex3(:),G1H2(82),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_VV_S(ntryL,G1H4(72),ex3(:),G1H2(87),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_SV_V(ntryL,G1H4(77),ex3(:),G1H2(92),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_VV_S(ntryL,G1H4(132),ex3(:),G1H2(97),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_SV_V(ntryL,G1H4(227),ex4(:),G1H2(101),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_VV_S(ntryL,G1H4(228),ex4(:),G1H2(102),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_SV_V(ntryL,G1H4(229),ex4(:),G1H2(107),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_VV_S(ntryL,G1H4(230),ex4(:),G1H2(108),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_SV_V(ntryL,G1H4(239),ex3(:),G1H2(112),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_VV_S(ntryL,G1H4(240),ex3(:),G1H2(113),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_SV_V(ntryL,G1H4(241),ex3(:),G1H2(118),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_VV_S(ntryL,G1H4(242),ex3(:),G1H2(119),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_SV_V(ntryL,G1H4(251),ex4(:),G1H2(123),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_VV_S(ntryL,G1H4(252),ex4(:),G1H2(124),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_SV_V(ntryL,G1H4(253),ex4(:),G1H2(129),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_VV_S(ntryL,G1H4(254),ex4(:),G1H2(130),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_SQ_A(ntryL,G1H4(30),ex1(:),G1H2(134),ngPnl,m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(134),29,0,G2H2(209),n2h2(109))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(70),ex2(:),G1H2(135),ngPln,m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(140),ngPnl,m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(140),29,0,G2H2(210),n2h2(110))
  call Hloop_SQ_A(ntryL,G1H4(130),ex1(:),G1H2(141),ngPnl,m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(141),29,0,G2H2(211),n2h2(111))
  call Hloop_WQ_A(ntryL,G1H4(168),ex1(:),G1H2(145),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(145),29,0,G2H2(212),n2h2(112))
call HGT_raise_alpha_OLR(G1H4(131),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(131),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(131),ex2(:),G1H2(146),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(151),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(151),29,0,G2H2(213),n2h2(113))
  call Hloop_WQ_A(ntryL,G1H4(14),ex1(:),G1H2(152),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(152),29,0,G2H2(214),n2h2(114))
  call Hloop_SA_Q(ntryL,G1H4(20),ex2(:),G1H2(157),ngPln,m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_A_Q(ntryL,G1H2(157),30,0,G2H2(215),n2h2(115))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(26),ex1(:),G1H2(161),ngPnl,m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_SA_Q(ntryL,G1H4(50),ex2(:),G1H2(162),ngPln,m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_A_Q(ntryL,G1H2(162),30,0,G2H2(216),n2h2(116))
  call Hloop_SA_Q(ntryL,G1H4(38),ex2(:),G1H2(167),ngPln,m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_A_Q(ntryL,G1H2(167),30,0,G2H2(217),n2h2(117))
  call Hloop_WA_Q(ntryL,G1H4(32),ex2(:),G1H2(168),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_A_Q(ntryL,G1H2(168),30,0,G2H2(218),n2h2(118))
call HGT_raise_alpha_OLR(G1H4(234),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(234),ex1(:),G1H2(173),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_WA_Q(ntryL,G1H4(43),ex2(:),G1H2(177),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(177),30,0,G2H2(219),n2h2(119))
  call Hloop_WA_Q(ntryL,G1H4(150),ex2(:),G1H2(178),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_A_Q(ntryL,G1H2(178),30,0,G2H2(220),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(148),ex3(:),G1H2(183),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(183),23,nME,G2H2(221),n2h2(121))
call HGT_OLR(G1H4(136),1,1,4)
call HGT_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(136),-8,nME,G2H4(20),n2h4(173))
  call Hloop_AV_Q(ntryL,G2H4(20),ex4(:),G2H2(222),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_QV_A(ntryL,G1H4(49),ex3(:),G1H2(184),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(184),23,nME,G2H2(223),n2h2(122))
  call Hloop_QV_A(ntryL,G1H4(55),ex3(:),G1H2(188),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(188),23,nME,G2H2(224),n2h2(123))
  call Hloop_QV_A(ntryL,G0H4(41),ex3(:),G0H2(1),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(189),n2h2(124))
  call Hloop_TV_S(ntryL,G1H4(196),19,ex3(:),4,G2H2(225),m3h2x2(:,306),heltab2x4(:,:,306))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(192),-8,ex4(:),8,G2H2(226),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_TV_S(ntryL,G1H4(180),19,ex3(:),4,G2H2(227),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_TV_S(ntryL,G1H4(56),19,ex3(:),4,G2H2(228),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_TV_S(ntryL,G0H4(32),19,ex3(:),4,G1H2(194),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_TV_S(ntryL,G1H4(61),19,ex3(:),4,G2H2(229),m3h2x2(:,311),heltab2x4(:,:,311))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(10),ex4(:),G1H2(195),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_TV_S(ntryL,G1H4(214),19,ex3(:),4,G2H2(230),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_TV_S(ntryL,G1H4(210),19,ex3(:),4,G2H2(231),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_UV_W(ntryL,G1H4(62),19,ex3(:),4,G2H2(232),m3h2x2(:,315),heltab2x4(:,:,315))
call HGT_OLR(G1H4(67),1,1,4)
call HGT_invQ_OLR(G1H4(67),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(67),ex4(:),G1H2(199),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_UV_W(ntryL,G1H4(162),19,ex3(:),4,G2H2(233),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_UV_W(ntryL,G1H4(144),19,ex3(:),4,G2H2(234),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_UV_W(ntryL,G1H4(68),19,ex3(:),4,G2H2(235),m3h2x2(:,319),heltab2x4(:,:,319))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(74),-8,ex4(:),8,G2H2(236),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_UV_W(ntryL,G1H4(86),19,ex3(:),4,G2H2(237),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_UV_W(ntryL,G1H4(92),19,ex3(:),4,G2H2(238),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_UV_W(ntryL,G0H4(30),19,ex3(:),4,G1H2(200),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_QV_A(ntryL,G1H4(97),ex4(:),G1H2(205),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(205),27,nME,G2H2(239),n2h2(125))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-4,nME,G2H4(18),n2h4(178))
  call Hloop_AV_Q(ntryL,G2H4(18),ex3(:),G2H2(240),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_QV_A(ntryL,G1H4(98),ex4(:),G1H2(206),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G1H2(206),27,nME,G2H2(241),n2h2(126))
  call Hloop_QV_A(ntryL,G1H4(246),ex4(:),G1H2(210),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(210),27,nME,G2H2(242),n2h2(127))
  call Hloop_QV_A(ntryL,G0H4(22),ex4(:),G0H2(1),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_Q_A(ntryL,G0H2(1),27,nME,G1H2(211),n2h2(128))
  call Hloop_TV_S(ntryL,G1H4(103),19,ex4(:),8,G2H2(243),m3h2x2(:,329),heltab2x4(:,:,329))
call HGT_OLR(G1H4(109),1,1,4)
call HGT_invQ_OLR(G1H4(109),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(109),-4,ex3(:),4,G2H2(244),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_TV_S(ntryL,G1H4(47),19,ex4(:),8,G2H2(245),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_TV_S(ntryL,G1H4(35),19,ex4(:),8,G2H2(246),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_TV_S(ntryL,G0H4(28),19,ex4(:),8,G1H2(216),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_TV_S(ntryL,G1H4(110),19,ex4(:),8,G2H2(247),m3h2x2(:,334),heltab2x4(:,:,334))
call HGT_raise_alpha_OLR(G1H4(115),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(115),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(115),ex3(:),G1H2(217),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_TV_S(ntryL,G1H4(101),19,ex4(:),8,G2H2(248),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_TV_S(ntryL,G1H4(99),19,ex4(:),8,G2H2(249),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_UV_W(ntryL,G1H4(89),19,ex4(:),8,G2H2(250),m3h2x2(:,338),heltab2x4(:,:,338))
call HGT_OLR(G1H4(87),1,1,4)
call HGT_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(87),ex3(:),G1H2(221),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_UV_W(ntryL,G1H4(127),19,ex4(:),8,G2H2(251),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_UV_W(ntryL,G1H4(119),19,ex4(:),8,G2H2(252),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_UV_W(ntryL,G1H4(117),19,ex4(:),8,G2H2(253),m3h2x2(:,342),heltab2x4(:,:,342))
call HGT_raise_alpha_OLR(G1H4(107),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(107),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(107),-4,ex3(:),4,G2H2(254),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_UV_W(ntryL,G1H4(128),19,ex4(:),8,G2H2(255),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_UV_W(ntryL,G1H4(133),19,ex4(:),8,G2H2(256),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_UV_W(ntryL,G0H4(40),19,ex4(:),8,G1H2(222),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_AV_Q(ntryL,G1H4(65),ex3(:),G1H2(227),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(227),23,nME,G2H2(257),n2h2(129))
call HGT_OLR(G1H4(63),1,1,4)
call HGT_invQ_OLR(G1H4(63),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(63),-8,nME,G2H4(48),n2h4(183))
  call Hloop_QV_A(ntryL,G2H4(48),ex4(:),G2H2(258),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_AV_Q(ntryL,G1H4(134),ex3(:),G1H2(228),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(228),23,nME,G2H2(259),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H4(139),ex3(:),G1H2(233),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_A_Q(ntryL,G1H2(233),23,nME,G2H2(260),n2h2(131))
  call Hloop_AV_Q(ntryL,G0H4(38),ex3(:),G0H2(1),m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(237),n2h2(132))
  call Hloop_SV_T(ntryL,G1H4(158),19,ex3(:),4,G2H2(261),m3h2x2(:,352),heltab2x4(:,:,352))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(146),-8,ex4(:),8,G2H2(262),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_SV_T(ntryL,G1H4(174),19,ex3(:),4,G2H2(263),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_SV_T(ntryL,G1H4(145),19,ex3(:),4,G2H2(264),m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_SV_T(ntryL,G0H4(11),19,ex3(:),4,G1H2(238),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_SV_T(ntryL,G1H4(151),19,ex3(:),4,G2H2(265),m3h2x2(:,357),heltab2x4(:,:,357))
call HGT_raise_alpha_OLR(G1H4(149),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(149),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(149),ex4(:),G1H2(243),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_SV_T(ntryL,G1H4(135),19,ex3(:),4,G2H2(266),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_SV_T(ntryL,G1H4(152),19,ex3(:),4,G2H2(267),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_UW_V(ntryL,G1H4(157),19,ex3(:),4,G2H2(268),m3h2x2(:,361),heltab2x4(:,:,361))
call HGT_OLR(G1H4(163),1,1,4)
call HGT_invQ_OLR(G1H4(163),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(163),ex4(:),G1H2(244),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_UW_V(ntryL,G1H4(191),19,ex3(:),4,G2H2(269),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_UW_V(ntryL,G1H4(183),19,ex3(:),4,G2H2(270),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_UW_V(ntryL,G1H4(179),19,ex3(:),4,G2H2(271),m3h2x2(:,365),heltab2x4(:,:,365))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(164),-8,ex4(:),8,G2H2(272),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_UW_V(ntryL,G1H4(9),19,ex3(:),4,G2H2(273),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_UW_V(ntryL,G1H4(5),19,ex3(:),4,G2H2(274),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_UW_V(ntryL,G0H4(9),19,ex3(:),4,G1H2(249),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_AV_Q(ntryL,G1H4(213),ex4(:),G1H2(253),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(253),27,nME,G2H2(275),n2h2(133))
call HGT_OLR(G1H4(209),1,1,4)
call HGT_invQ_OLR(G1H4(209),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(209),-4,nME,G2H4(83),n2h4(188))
  call Hloop_QV_A(ntryL,G2H4(83),ex3(:),G2H2(276),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_AV_Q(ntryL,G1H4(175),ex4(:),G1H2(254),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(254),27,nME,G2H2(277),n2h2(134))
  call Hloop_AV_Q(ntryL,G1H4(165),ex4(:),G1H2(259),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(259),27,nME,G2H2(278),n2h2(135))
  call Hloop_AV_Q(ntryL,G0H4(1),ex4(:),G0H2(1),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G0H2(1),27,nME,G1H2(260),n2h2(136))
  call Hloop_SV_T(ntryL,G1H4(161),19,ex4(:),8,G2H2(279),m3h2x2(:,375),heltab2x4(:,:,375))
call HGT_OLR(G1H4(143),1,1,4)
call HGT_invQ_OLR(G1H4(143),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(143),-4,ex3(:),4,G2H2(280),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_SV_T(ntryL,G1H4(181),19,ex4(:),8,G2H2(281),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_SV_T(ntryL,G1H4(200),19,ex4(:),8,G2H2(282),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_SV_T(ntryL,G0H4(7),19,ex4(:),8,G1H2(264),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_SV_T(ntryL,G1H4(188),19,ex4(:),8,G2H2(283),m3h2x2(:,380),heltab2x4(:,:,380))
call HGT_raise_alpha_OLR(G1H4(182),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(182),ex3(:),G1H2(265),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_SV_T(ntryL,G1H4(187),19,ex4(:),8,G2H2(284),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_SV_T(ntryL,G1H4(193),19,ex4(:),8,G2H2(285),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_UW_V(ntryL,G1H4(52),19,ex4(:),8,G2H2(286),m3h2x2(:,384),heltab2x4(:,:,384))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(48),ex3(:),G1H2(270),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_UW_V(ntryL,G1H4(194),19,ex4(:),8,G2H2(287),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_UW_V(ntryL,G1H4(199),19,ex4(:),8,G2H2(288),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_UW_V(ntryL,G1H4(205),19,ex4(:),8,G2H2(289),m3h2x2(:,388),heltab2x4(:,:,388))
call HGT_raise_alpha_OLR(G1H4(102),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(102),-4,ex3(:),4,G2H2(290),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_UW_V(ntryL,G1H4(90),19,ex4(:),8,G2H2(291),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_UW_V(ntryL,G1H4(88),19,ex4(:),8,G2H2(292),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_UW_V(ntryL,G0H4(19),19,ex4(:),8,G1H2(271),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_CV_D(ntryL,G1H4(206),19,ex4(:),8,G2H2(293),m3h2x2(:,393),heltab2x4(:,:,393))
call HGT_OLR(G1H4(211),1,1,4)
call HGT_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(211),-4,ex3(:),G2H2(294),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_CV_D(ntryL,G1H4(118),19,ex4(:),8,G2H2(295),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_CV_D(ntryL,G1H4(108),19,ex4(:),8,G2H2(296),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_CV_D(ntryL,G0H4(17),19,ex4(:),8,G1H2(276),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_DV_C(ntryL,G1H4(106),19,ex4(:),G2H2(297),m3h2x2(:,398),heltab2x4(:,:,398))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(212),-4,ex3(:),4,G2H2(298),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_DV_C(ntryL,G1H4(66),19,ex4(:),G2H2(299),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_DV_C(ntryL,G1H4(64),19,ex4(:),G2H2(300),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_DV_C(ntryL,G0H4(31),19,ex4(:),G1H2(280),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_QV_A(ntryL,G1H4(46),ex4(:),G1H2(281),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(281),27,0,G2H2(301),n2h2(137))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(218),-4,0,G2H4(33),n2h4(195))
  call Hloop_AV_Q(ntryL,G2H4(33),ex3(:),G2H2(302),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_QV_A(ntryL,G1H4(39),ex4(:),G1H2(286),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(286),27,0,G2H2(303),n2h2(138))
  call Hloop_QV_A(ntryL,G1H4(42),ex4(:),G1H2(287),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(287),27,0,G2H2(304),n2h2(139))
  call Hloop_QV_A(ntryL,G0H4(29),ex4(:),G0H2(1),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(292),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H4(40),ex4(:),G1H2(296),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(296),27,0,G2H2(305),n2h2(141))
call HGT_OLR(G1H4(95),1,1,4)
call HGT_invQ_OLR(G1H4(95),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(95),-4,0,G2H4(56),n2h4(196))
  call Hloop_QV_A(ntryL,G2H4(56),ex3(:),G2H2(306),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_AV_Q(ntryL,G1H4(83),ex4(:),G1H2(297),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(297),27,0,G2H2(307),n2h2(142))
  call Hloop_AV_Q(ntryL,G1H4(81),ex4(:),G1H2(302),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_A_Q(ntryL,G1H2(302),27,0,G2H2(308),n2h2(143))
  call Hloop_AV_Q(ntryL,G0H4(21),ex4(:),G0H2(1),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(303),n2h2(144))
  call Hloop_DV_C(ntryL,G1H4(96),19,ex3(:),G2H2(309),m3h2x2(:,413),heltab2x4(:,:,413))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(94),-8,ex4(:),8,G2H2(310),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_DV_C(ntryL,G1H4(82),19,ex3(:),G2H2(311),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_DV_C(ntryL,G1H4(59),19,ex3(:),G2H2(312),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_DV_C(ntryL,G0H4(27),19,ex3(:),G1H2(307),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_CV_D(ntryL,G1H4(58),19,ex3(:),4,G2H2(313),m3h2x2(:,418),heltab2x4(:,:,418))
call HGT_OLR(G1H4(53),1,1,4)
call HGT_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(53),-8,ex4(:),G2H2(314),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_CV_D(ntryL,G1H4(57),19,ex3(:),4,G2H2(315),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_CV_D(ntryL,G1H4(54),19,ex3(:),4,G2H2(316),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_CV_D(ntryL,G0H4(39),19,ex3(:),4,G1H2(308),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_AV_Q(ntryL,G1H4(125),ex3(:),G1H2(313),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_A_Q(ntryL,G1H2(313),23,0,G2H2(317),n2h2(145))
call HGT_OLR(G1H4(123),1,1,4)
call HGT_invQ_OLR(G1H4(123),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(123),-8,0,G2H4(28),n2h4(199))
  call Hloop_QV_A(ntryL,G2H4(28),ex4(:),G2H2(318),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_AV_Q(ntryL,G1H4(111),ex3(:),G1H2(314),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_A_Q(ntryL,G1H2(314),23,0,G2H2(319),n2h2(146))
  call Hloop_AV_Q(ntryL,G1H4(126),ex3(:),G1H2(319),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_A_Q(ntryL,G1H2(319),23,0,G2H2(320),n2h2(147))
  call Hloop_AV_Q(ntryL,G0H4(37),ex3(:),G0H2(1),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(323),n2h2(148))
  call Hloop_QV_A(ntryL,G1H4(124),ex3(:),G1H2(324),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(324),23,0,G2H2(321),n2h2(149))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-8,0,G2H4(81),n2h4(200))
  call Hloop_AV_Q(ntryL,G2H4(81),ex4(:),G2H2(322),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_QV_A(ntryL,G1H4(141),ex3(:),G1H2(329),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(329),23,0,G2H2(323),n2h2(150))
  call Hloop_QV_A(ntryL,G1H4(137),ex3(:),G1H2(330),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_Q_A(ntryL,G1H2(330),23,0,G2H2(324),n2h2(151))
  call Hloop_QV_A(ntryL,G0H4(12),ex3(:),G0H2(1),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(335),n2h2(152))
  call Hloop_QS_A(ntryL,G1H8(131),wf4(:,36),G1H2(14),ngH,m3h4x2(:,71),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(14),23,nME,G2H2(325),n2h2(153))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(12),-8,nME,G2H8(17),n2h8(173))
  call Hloop_AV_Q(ntryL,G2H8(17),ex4(:),G2H4(76),m3h2x4(:,185),heltab2x8(:,:,256))
  call Hloop_QS_A(ntryL,G1H8(24),wf4(:,36),G1H2(20),ngH,m3h4x2(:,72),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(20),23,nME,G2H2(326),n2h2(154))
  call Hloop_QS_A(ntryL,G1H8(27),wf4(:,36),G1H2(26),ngH,m3h4x2(:,73),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(26),23,nME,G2H2(327),n2h2(155))
  call Hloop_QS_A(ntryL,G0H8(41),wf4(:,36),G0H2(1),ngH,m3h4x2(:,74),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(32),n2h2(156))
  call Hloop_AS_Q(ntryL,G1H8(28),wf4(:,36),G1H2(38),ngH,m3h4x2(:,75),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(38),23,nME,G2H2(328),n2h2(157))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(29),-8,nME,G2H8(19),n2h8(174))
  call Hloop_QV_A(ntryL,G2H8(19),ex4(:),G2H4(74),m3h2x4(:,186),heltab2x8(:,:,261))
  call Hloop_AS_Q(ntryL,G1H8(31),wf4(:,36),G1H2(44),ngH,m3h4x2(:,76),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(44),23,nME,G2H2(329),n2h2(158))
  call Hloop_AS_Q(ntryL,G1H8(32),wf4(:,36),G1H2(50),ngH,m3h4x2(:,77),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(50),23,nME,G2H2(330),n2h2(159))
  call Hloop_AS_Q(ntryL,G0H8(17),wf4(:,36),G0H2(1),ngH,m3h4x2(:,78),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(56),n2h2(160))
  call Hloop_QS_A(ntryL,G1H8(41),wf4(:,37),G1H2(62),ngX,m3h4x2(:,79),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(62),23,nME,G2H2(331),n2h2(161))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(42),-8,nME,G2H8(21),n2h8(175))
  call Hloop_AV_Q(ntryL,G2H8(21),ex4(:),G2H4(94),m3h2x4(:,187),heltab2x8(:,:,266))
  call Hloop_QS_A(ntryL,G1H8(44),wf4(:,37),G1H2(68),ngX,m3h4x2(:,80),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(68),23,nME,G2H2(332),n2h2(162))
  call Hloop_QS_A(ntryL,G1H8(53),wf4(:,37),G1H2(74),ngX,m3h4x2(:,81),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(74),23,nME,G2H2(333),n2h2(163))
  call Hloop_QS_A(ntryL,G0H8(18),wf4(:,37),G0H2(1),ngX,m3h4x2(:,82),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(80),n2h2(164))
  call Hloop_AS_Q(ntryL,G1H8(54),wf4(:,37),G1H2(106),ngX,m3h4x2(:,83),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G1H2(106),23,nME,G2H2(334),n2h2(165))
call HGT_OLR(G1H8(55),1,1,8)
call HGT_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(55),-8,nME,G2H8(23),n2h8(176))
  call Hloop_QV_A(ntryL,G2H8(23),ex4(:),G2H4(5),m3h2x4(:,188),heltab2x8(:,:,271))
  call Hloop_AS_Q(ntryL,G1H8(65),wf4(:,37),G1H2(117),ngX,m3h4x2(:,84),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G1H2(117),23,nME,G2H2(335),n2h2(166))
  call Hloop_AS_Q(ntryL,G1H8(1),wf4(:,37),G1H2(128),ngX,m3h4x2(:,85),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(128),23,nME,G2H2(336),n2h2(167))
  call Hloop_AS_Q(ntryL,G0H8(19),wf4(:,37),G0H2(1),ngX,m3h4x2(:,86),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(139),n2h2(168))
  call Hloop_ST_V(ntryL,G1H8(4),20,wf4(:,36),3,G2H2(337),m3h4x2(:,87),heltab2x8(:,:,275))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(6),ex4(:),G1H4(189),m3h2x4(:,189),heltab2x8(:,:,276))
  call Hloop_ST_V(ntryL,G1H8(13),20,wf4(:,36),3,G2H2(338),m3h4x2(:,88),heltab2x8(:,:,277))
  call Hloop_ST_V(ntryL,G1H8(16),20,wf4(:,36),3,G2H2(339),m3h4x2(:,89),heltab2x8(:,:,278))
  call Hloop_ST_V(ntryL,G1H8(15),20,wf4(:,37),3,G2H2(340),m3h4x2(:,90),heltab2x8(:,:,279))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(17),ex4(:),G1H4(185),m3h2x4(:,190),heltab2x8(:,:,280))
  call Hloop_ST_V(ntryL,G1H8(19),20,wf4(:,37),3,G2H2(341),m3h4x2(:,91),heltab2x8(:,:,281))
  call Hloop_ST_V(ntryL,G1H8(21),20,wf4(:,37),3,G2H2(342),m3h4x2(:,92),heltab2x8(:,:,282))
  call Hloop_VT_S(ntryL,G1H8(25),20,wf4(:,36),3,G2H2(343),m3h4x2(:,93),heltab2x8(:,:,283))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(26),ex4(:),G1H4(202),m3h2x4(:,191),heltab2x8(:,:,284))
  call Hloop_VT_S(ntryL,G1H8(36),20,wf4(:,36),3,G2H2(344),m3h4x2(:,94),heltab2x8(:,:,285))
  call Hloop_VT_S(ntryL,G1H8(35),20,wf4(:,36),3,G2H2(345),m3h4x2(:,95),heltab2x8(:,:,286))
  call Hloop_VT_S(ntryL,G1H8(39),20,wf4(:,37),3,G2H2(346),m3h4x2(:,96),heltab2x8(:,:,287))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(46),ex4(:),G1H4(198),m3h2x4(:,192),heltab2x8(:,:,288))
  call Hloop_VT_S(ntryL,G1H8(58),20,wf4(:,37),3,G2H2(347),m3h4x2(:,97),heltab2x8(:,:,289))
  call Hloop_VT_S(ntryL,G1H8(61),20,wf4(:,37),3,G2H2(348),m3h4x2(:,98),heltab2x8(:,:,290))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,13),G1H2(150),m3h4x2(:,99),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(150),23,nME,G2H2(349),n2h2(169))
call HGT_OLR(G1H8(59),1,1,8)
call HGT_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(59),-8,nME,G2H8(46),n2h8(181))
  call Hloop_AV_Q(ntryL,G2H8(46),ex4(:),G2H4(105),m3h2x4(:,193),heltab2x8(:,:,292))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,13),G1H2(166),m3h4x2(:,100),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(166),23,nME,G2H2(350),n2h2(170))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,13),G1H2(182),m3h4x2(:,101),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(182),23,nME,G2H2(351),n2h2(171))
  call Hloop_QV_A(ntryL,G0H8(20),wf4(:,13),G0H2(1),m3h4x2(:,102),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(193),n2h2(172))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,13),G1H2(204),m3h4x2(:,103),heltab2x8(:,:,296))
  call Hloop_A_Q(ntryL,G1H2(204),23,nME,G2H2(352),n2h2(173))
call HGT_OLR(G1H8(7),1,1,8)
call HGT_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(7),-8,nME,G2H8(44),n2h8(182))
  call Hloop_QV_A(ntryL,G2H8(44),ex4(:),G2H4(40),m3h2x4(:,194),heltab2x8(:,:,297))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,13),G1H2(215),m3h4x2(:,104),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G1H2(215),23,nME,G2H2(353),n2h2(174))
  call Hloop_AV_Q(ntryL,G1H8(40),wf4(:,13),G1H2(226),m3h4x2(:,105),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(226),23,nME,G2H2(354),n2h2(175))
  call Hloop_AV_Q(ntryL,G0H8(21),wf4(:,13),G0H2(1),m3h4x2(:,106),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(242),n2h2(176))
  call Hloop_QV_A(ntryL,G1H8(49),wf4(:,13),G1H2(258),m3h4x2(:,107),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(258),23,0,G2H2(355),n2h2(177))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-8,0,G2H8(49),n2h8(183))
  call Hloop_AV_Q(ntryL,G2H8(49),ex4(:),G2H4(21),m3h2x4(:,195),heltab2x8(:,:,302))
  call Hloop_QV_A(ntryL,G1H8(48),wf4(:,13),G1H2(269),m3h4x2(:,108),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(269),23,0,G2H2(356),n2h2(178))
  call Hloop_QV_A(ntryL,G1H8(52),wf4(:,13),G1H2(285),m3h4x2(:,109),heltab2x8(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(285),23,0,G2H2(357),n2h2(179))
  call Hloop_QV_A(ntryL,G0H8(22),wf4(:,13),G0H2(1),m3h4x2(:,110),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(301),n2h2(180))
  call Hloop_AV_Q(ntryL,G1H8(37),wf4(:,13),G1H2(312),m3h4x2(:,111),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G1H2(312),23,0,G2H2(358),n2h2(181))
call HGT_OLR(G1H8(66),1,1,8)
call HGT_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(66),-8,0,G2H8(51),n2h8(184))
  call Hloop_QV_A(ntryL,G2H8(51),ex4(:),G2H4(19),m3h2x4(:,196),heltab2x8(:,:,307))
  call Hloop_AV_Q(ntryL,G1H8(68),wf4(:,13),G1H2(328),m3h4x2(:,112),heltab2x8(:,:,308))
  call Hloop_A_Q(ntryL,G1H2(328),23,0,G2H2(359),n2h2(182))
  call Hloop_AV_Q(ntryL,G1H8(69),wf4(:,13),G1H2(9),m3h4x2(:,113),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(9),23,0,G2H2(360),n2h2(183))
  call Hloop_AV_Q(ntryL,G0H8(23),wf4(:,13),G0H2(1),m3h4x2(:,114),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(10),n2h2(184))
  call Hloop_QZ_A(ntryL,G1H8(70),wf4(:,14),G1H2(232),ngZl,m3h4x2(:,115),heltab2x8(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(232),23,nME,G2H2(361),n2h2(185))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(71),-8,nME,G2H8(1),n2h8(185))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(49),m3h2x4(:,197),heltab2x8(:,:,312))
  call Hloop_QZ_A(ntryL,G1H8(73),wf4(:,14),G1H2(51),ngZl,m3h4x2(:,116),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(51),23,nME,G2H2(362),n2h2(186))
  call Hloop_QZ_A(ntryL,G1H8(74),wf4(:,14),G1H2(52),ngZl,m3h4x2(:,117),heltab2x8(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(52),23,nME,G2H2(363),n2h2(187))
  call Hloop_QZ_A(ntryL,G0H8(24),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,118),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(248),n2h2(188))
  call Hloop_AZ_Q(ntryL,G1H8(96),wf4(:,14),G1H2(57),ngZl,m3h4x2(:,119),heltab2x8(:,:,316))
  call Hloop_A_Q(ntryL,G1H2(57),23,nME,G2H2(364),n2h2(189))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(98),-8,nME,G2H8(2),n2h8(186))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(96),m3h2x4(:,198),heltab2x8(:,:,317))
  call Hloop_AZ_Q(ntryL,G1H8(97),wf4(:,14),G1H2(58),ngZl,m3h4x2(:,120),heltab2x8(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(58),23,nME,G2H2(365),n2h2(190))
  call Hloop_AZ_Q(ntryL,G1H8(104),wf4(:,14),G1H2(275),ngZl,m3h4x2(:,121),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(275),23,nME,G2H2(366),n2h2(191))
  call Hloop_AZ_Q(ntryL,G0H8(25),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,122),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(63),n2h2(192))
  call Hloop_QZ_A(ntryL,G1H8(106),wf4(:,14),G1H2(64),ngZu,m3h4x2(:,123),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(64),23,0,G2H2(367),n2h2(193))
call HGT_OLR(G1H8(103),1,1,8)
call HGT_invQ_OLR(G1H8(103),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(103),-8,0,G2H8(3),n2h8(187))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(31),m3h2x4(:,199),heltab2x8(:,:,322))
  call Hloop_QZ_A(ntryL,G1H8(107),wf4(:,14),G1H2(291),ngZu,m3h4x2(:,124),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(291),23,0,G2H2(368),n2h2(194))
  call Hloop_QZ_A(ntryL,G1H8(108),wf4(:,14),G1H2(69),ngZu,m3h4x2(:,125),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(69),23,0,G2H2(369),n2h2(195))
  call Hloop_QZ_A(ntryL,G0H8(26),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,126),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(70),n2h2(196))
  call Hloop_AZ_Q(ntryL,G1H8(116),wf4(:,14),G1H2(318),ngZu,m3h4x2(:,127),heltab2x8(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(318),23,0,G2H2(370),n2h2(197))
call HGT_OLR(G1H8(118),1,1,8)
call HGT_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(118),-8,0,G2H8(4),n2h8(188))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(58),m3h2x4(:,200),heltab2x8(:,:,327))
  call Hloop_AZ_Q(ntryL,G1H8(117),wf4(:,14),G1H2(75),ngZu,m3h4x2(:,128),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H2(75),23,0,G2H2(371),n2h2(198))
  call Hloop_AZ_Q(ntryL,G1H8(119),wf4(:,14),G1H2(76),ngZu,m3h4x2(:,129),heltab2x8(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(76),23,0,G2H2(372),n2h2(199))
  call Hloop_AZ_Q(ntryL,G0H8(27),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,130),heltab2x8(:,:,330))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(334),n2h2(200))
  call Hloop_TV_S(ntryL,G1H8(120),20,wf4(:,13),3,G2H2(373),m3h4x2(:,131),heltab2x8(:,:,331))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(128),-8,ex4(:),8,G2H4(52),m3h2x4(:,201),heltab2x8(:,:,332))
  call Hloop_TV_S(ntryL,G1H8(127),20,wf4(:,13),3,G2H2(374),m3h4x2(:,132),heltab2x8(:,:,333))
  call Hloop_TV_S(ntryL,G1H8(129),20,wf4(:,13),3,G2H2(375),m3h4x2(:,133),heltab2x8(:,:,334))
  call Hloop_TV_S(ntryL,G0H8(28),20,wf4(:,13),3,G1H2(134),m3h4x2(:,134),heltab2x8(:,:,335))
  call Hloop_SV_T(ntryL,G1H8(10),20,wf4(:,13),3,G2H2(376),m3h4x2(:,135),heltab2x8(:,:,336))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(11),-8,ex4(:),8,G2H4(53),m3h2x4(:,202),heltab2x8(:,:,337))
  call Hloop_SV_T(ntryL,G1H8(18),20,wf4(:,13),3,G2H2(377),m3h4x2(:,136),heltab2x8(:,:,338))
  call Hloop_SV_T(ntryL,G1H8(22),20,wf4(:,13),3,G2H2(378),m3h4x2(:,137),heltab2x8(:,:,339))
  call Hloop_SV_T(ntryL,G0H8(29),20,wf4(:,13),3,G1H2(140),m3h4x2(:,138),heltab2x8(:,:,340))
  call Hloop_TV_S(ntryL,G1H8(38),20,wf4(:,14),3,G2H2(379),m3h4x2(:,139),heltab2x8(:,:,341))
call HGT_OLR(G1H8(45),1,1,8)
call HGT_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(45),-8,ex4(:),8,G2H4(22),m3h2x4(:,203),heltab2x8(:,:,342))
  call Hloop_TV_S(ntryL,G1H8(60),20,wf4(:,14),3,G2H2(380),m3h4x2(:,140),heltab2x8(:,:,343))
  call Hloop_TV_S(ntryL,G1H8(33),20,wf4(:,14),3,G2H2(381),m3h4x2(:,141),heltab2x8(:,:,344))
  call Hloop_TV_S(ntryL,G0H8(30),20,wf4(:,14),3,G1H2(141),m3h4x2(:,142),heltab2x8(:,:,345))
  call Hloop_SV_T(ntryL,G1H8(132),20,wf4(:,14),3,G2H2(382),m3h4x2(:,143),heltab2x8(:,:,346))
call HGT_OLR(G1H8(133),1,1,8)
call HGT_invQ_OLR(G1H8(133),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(133),-8,ex4(:),8,G2H4(23),m3h2x4(:,204),heltab2x8(:,:,347))
  call Hloop_SV_T(ntryL,G1H8(135),20,wf4(:,14),3,G2H2(383),m3h4x2(:,144),heltab2x8(:,:,348))
  call Hloop_SV_T(ntryL,G1H8(136),20,wf4(:,14),3,G2H2(384),m3h4x2(:,145),heltab2x8(:,:,349))
  call Hloop_SV_T(ntryL,G0H8(31),20,wf4(:,14),3,G1H2(145),m3h4x2(:,146),heltab2x8(:,:,350))
  call Hloop_CV_D(ntryL,G1H8(137),20,wf4(:,13),3,G2H2(385),m3h4x2(:,147),heltab2x8(:,:,351))
call HGT_OLR(G1H8(138),1,1,8)
call HGT_invQ_OLR(G1H8(138),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(138),-8,ex4(:),G2H4(63),m3h2x4(:,205),heltab2x8(:,:,352))
  call Hloop_CV_D(ntryL,G1H8(140),20,wf4(:,13),3,G2H2(386),m3h4x2(:,148),heltab2x8(:,:,353))
  call Hloop_CV_D(ntryL,G1H8(141),20,wf4(:,13),3,G2H2(387),m3h4x2(:,149),heltab2x8(:,:,354))
  call Hloop_CV_D(ntryL,G0H8(32),20,wf4(:,13),3,G1H2(151),m3h4x2(:,150),heltab2x8(:,:,355))
  call Hloop_DV_C(ntryL,G1H8(142),20,wf4(:,13),G2H2(388),m3h4x2(:,151),heltab2x8(:,:,356))
call HGT_OLR(G1H8(143),1,1,8)
call HGT_invQ_OLR(G1H8(143),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(143),-8,ex4(:),8,G2H4(62),m3h2x4(:,206),heltab2x8(:,:,357))
  call Hloop_DV_C(ntryL,G1H8(145),20,wf4(:,13),G2H2(389),m3h4x2(:,152),heltab2x8(:,:,358))
  call Hloop_DV_C(ntryL,G1H8(146),20,wf4(:,13),G2H2(390),m3h4x2(:,153),heltab2x8(:,:,359))
  call Hloop_DV_C(ntryL,G0H8(16),20,wf4(:,13),G1H2(152),m3h4x2(:,154),heltab2x8(:,:,360))
  call Hloop_CV_D(ntryL,G1H8(147),20,wf4(:,14),3,G2H2(391),m3h4x2(:,155),heltab2x8(:,:,361))
call HGT_OLR(G1H8(148),1,1,8)
call HGT_invQ_OLR(G1H8(148),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(148),-8,ex4(:),G2H4(61),m3h2x4(:,207),heltab2x8(:,:,362))
  call Hloop_CV_D(ntryL,G1H8(150),20,wf4(:,14),3,G2H2(392),m3h4x2(:,156),heltab2x8(:,:,363))
  call Hloop_CV_D(ntryL,G1H8(151),20,wf4(:,14),3,G2H2(393),m3h4x2(:,157),heltab2x8(:,:,364))
  call Hloop_CV_D(ntryL,G0H8(8),20,wf4(:,14),3,G1H2(157),m3h4x2(:,158),heltab2x8(:,:,365))
  call Hloop_DV_C(ntryL,G1H8(152),20,wf4(:,14),G2H2(394),m3h4x2(:,159),heltab2x8(:,:,366))
call HGT_OLR(G1H8(153),1,1,8)
call HGT_invQ_OLR(G1H8(153),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(153),-8,ex4(:),8,G2H4(72),m3h2x4(:,208),heltab2x8(:,:,367))
  call Hloop_DV_C(ntryL,G1H8(155),20,wf4(:,14),G2H2(395),m3h4x2(:,160),heltab2x8(:,:,368))
  call Hloop_DV_C(ntryL,G1H8(156),20,wf4(:,14),G2H2(396),m3h4x2(:,161),heltab2x8(:,:,369))
  call Hloop_DV_C(ntryL,G0H8(1),20,wf4(:,14),G1H2(162),m3h4x2(:,162),heltab2x8(:,:,370))
  call Hloop_UV_W(ntryL,G1H8(157),20,wf4(:,13),3,G2H2(397),m3h4x2(:,163),heltab2x8(:,:,371))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(158),-8,ex4(:),8,G2H4(69),m3h2x4(:,209),heltab2x8(:,:,372))
  call Hloop_UV_W(ntryL,G1H8(160),20,wf4(:,13),3,G2H2(398),m3h4x2(:,164),heltab2x8(:,:,373))
  call Hloop_UV_W(ntryL,G1H8(161),20,wf4(:,13),3,G2H2(399),m3h4x2(:,165),heltab2x8(:,:,374))
  call Hloop_UV_W(ntryL,G0H8(2),20,wf4(:,13),3,G1H2(167),m3h4x2(:,166),heltab2x8(:,:,375))
  call Hloop_UW_V(ntryL,G1H8(162),20,wf4(:,13),3,G2H2(400),m3h4x2(:,167),heltab2x8(:,:,376))
call HGT_raise_alpha_OLR(G1H8(163),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(163),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(163),-8,ex4(:),8,G2H4(68),m3h2x4(:,210),heltab2x8(:,:,377))
  call Hloop_UW_V(ntryL,G1H8(165),20,wf4(:,13),3,G2H2(401),m3h4x2(:,168),heltab2x8(:,:,378))
  call Hloop_UW_V(ntryL,G1H8(166),20,wf4(:,13),3,G2H2(402),m3h4x2(:,169),heltab2x8(:,:,379))
  call Hloop_UW_V(ntryL,G0H8(12),20,wf4(:,13),3,G1H2(168),m3h4x2(:,170),heltab2x8(:,:,380))
  call Hloop_UV_W(ntryL,G1H8(167),20,wf4(:,14),3,G2H2(403),m3h4x2(:,171),heltab2x8(:,:,381))
call HGT_raise_alpha_OLR(G1H8(168),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(168),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(168),-8,ex4(:),8,G2H4(35),m3h2x4(:,211),heltab2x8(:,:,382))
  call Hloop_UV_W(ntryL,G1H8(170),20,wf4(:,14),3,G2H2(404),m3h4x2(:,172),heltab2x8(:,:,383))
  call Hloop_UV_W(ntryL,G1H8(171),20,wf4(:,14),3,G2H2(405),m3h4x2(:,173),heltab2x8(:,:,384))
  call Hloop_UV_W(ntryL,G0H8(9),20,wf4(:,14),3,G1H2(177),m3h4x2(:,174),heltab2x8(:,:,385))
  call Hloop_UW_V(ntryL,G1H8(172),20,wf4(:,14),3,G2H2(406),m3h4x2(:,175),heltab2x8(:,:,386))
call HGT_raise_alpha_OLR(G1H8(173),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(173),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(173),-8,ex4(:),8,G2H4(36),m3h2x4(:,212),heltab2x8(:,:,387))
  call Hloop_UW_V(ntryL,G1H8(175),20,wf4(:,14),3,G2H2(407),m3h4x2(:,176),heltab2x8(:,:,388))
  call Hloop_UW_V(ntryL,G1H8(176),20,wf4(:,14),3,G2H2(408),m3h4x2(:,177),heltab2x8(:,:,389))
  call Hloop_UW_V(ntryL,G0H8(10),20,wf4(:,14),3,G1H2(178),m3h4x2(:,178),heltab2x8(:,:,390))
  call Hloop_SA_Q(ntryL,G1H8(75),ex2(:),G1H4(190),ngPln,m3h2x4(:,213),heltab2x8(:,:,391))
  call Hloop_A_Q(ntryL,G1H4(190),22,0,G2H4(41),n2h4(201))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(76),wf4(:,9),G1H2(183),ngPnl,m3h4x2(:,179),heltab2x8(:,:,392))
  call Hloop_SA_Q(ntryL,G1H8(78),ex2(:),G1H4(186),ngPln,m3h2x4(:,214),heltab2x8(:,:,393))
  call Hloop_A_Q(ntryL,G1H4(186),22,0,G2H4(45),n2h4(202))
  call Hloop_SA_Q(ntryL,G1H8(79),ex2(:),G1H4(159),ngPln,m3h2x4(:,215),heltab2x8(:,:,394))
  call Hloop_A_Q(ntryL,G1H4(159),22,0,G2H4(101),n2h4(203))
  call Hloop_WA_Q(ntryL,G1H8(80),ex2(:),G1H4(156),m3h2x4(:,216),heltab2x8(:,:,395))
  call Hloop_A_Q(ntryL,G1H4(156),22,0,G2H4(102),n2h4(204))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(81),wf4(:,9),G1H2(184),m3h4x2(:,180),heltab2x8(:,:,396))
  call Hloop_WA_Q(ntryL,G1H8(83),ex2(:),G1H4(153),m3h2x4(:,217),heltab2x8(:,:,397))
  call Hloop_A_Q(ntryL,G1H4(153),22,0,G2H4(86),n2h4(205))
  call Hloop_WA_Q(ntryL,G1H8(84),ex2(:),G1H4(160),m3h2x4(:,218),heltab2x8(:,:,398))
  call Hloop_A_Q(ntryL,G1H4(160),22,0,G2H4(87),n2h4(206))
  call Hloop_SQ_A(ntryL,G1H8(85),ex1(:),G1H4(155),ngPnl,m3h2x4(:,219),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H4(155),21,0,G2H4(111),n2h4(207))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(86),wf4(:,4),G1H2(188),ngPln,m3h4x2(:,181),heltab2x8(:,:,400))
  call Hloop_SQ_A(ntryL,G1H8(88),ex1(:),G1H4(154),ngPnl,m3h2x4(:,220),heltab2x8(:,:,401))
  call Hloop_Q_A(ntryL,G1H4(154),21,0,G2H4(110),n2h4(208))
  call Hloop_SQ_A(ntryL,G1H8(89),ex1(:),G1H4(219),ngPnl,m3h2x4(:,221),heltab2x8(:,:,402))
  call Hloop_Q_A(ntryL,G1H4(219),21,0,G2H4(109),n2h4(209))
  call Hloop_WQ_A(ntryL,G1H8(90),ex1(:),G1H4(215),m3h2x4(:,222),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G1H4(215),21,0,G2H4(115),n2h4(210))
call HGT_raise_alpha_OLR(G1H8(91),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(91),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(91),wf4(:,4),G1H2(205),m3h4x2(:,182),heltab2x8(:,:,404))
  call Hloop_WQ_A(ntryL,G1H8(93),ex1(:),G1H4(207),m3h2x4(:,223),heltab2x8(:,:,405))
  call Hloop_Q_A(ntryL,G1H4(207),21,0,G2H4(114),n2h4(211))
  call Hloop_WQ_A(ntryL,G1H8(94),ex1(:),G1H4(203),m3h2x4(:,224),heltab2x8(:,:,406))
  call Hloop_Q_A(ntryL,G1H4(203),21,0,G2H4(113),n2h4(212))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(382),[G2H2(376),G2H2(132),G2H2(128),G2H2(106),G2H2(25) &
    ,G1H2(39),G1H2(34),G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(340),[G2H2(337),G2H2(169),G2H2(166),G2H2(163),G2H2(162) &
    ,G2H2(150),G2H2(146),G2H2(35),G2H2(27),G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(346),[G2H2(343),G2H2(176),G2H2(172),G2H2(158),G2H2(155) &
    ,G2H2(154),G2H2(151),G2H2(37),G2H2(29),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(406),[G2H2(400),G2H2(143),G2H2(137),G2H2(124),G2H2(31) &
    ,G1H2(46),G1H2(96),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(379),[G2H2(373),G2H2(129),G2H2(125),G2H2(103),G2H2(33) &
    ,G1H2(91),G1H2(33),G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(403),[G2H2(397),G2H2(140),G2H2(136),G2H2(120),G2H2(39) &
    ,G1H2(45),G1H2(40),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(364),[G2H2(352),G2H2(334),G2H2(328),G2H2(55),G2H2(51) &
    ,G2H2(47),G2H2(43),G1H2(127),G1H2(116),G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G2H2(59),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G2H2(178),G2H2(63),G1H2(149)])
call ol_merge_last(G1H2(1), G1H2(1)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(1)])
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G2H2(67),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G2H2(71),G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(74)])
call ol_merge_last(G2H2(80), G2H2(80)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(2)])
call HGT_lower_alpha_w2_OLR(G2H2(80),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(80),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(80),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(182),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(81),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(361),[G2H2(349),G2H2(331),G2H2(325),G2H2(97),G2H2(93) &
    ,G2H2(89),G2H2(85),G1H2(203),G1H2(192),G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G1H2(179)])
call HGT_OLR(G2H2(100),1,1,2)
call HGT_invQ_OLR(G2H2(100),2,5,2)
call HGT_OLR(G2H2(100),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G2H2(101),G1H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(10),G1H2(190)])
call HGT_OLR(G2H2(104),1,1,2)
call HGT_invQ_OLR(G2H2(104),2,5,2)
call HGT_OLR(G2H2(104),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(194),G2H2(105),G1H2(225)])
call ol_merge_last(G1H2(3), G1H2(3)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(35)])
call HGT_OLR(G2H2(108),1,1,2)
call HGT_invQ_OLR(G2H2(108),2,5,2)
call HGT_OLR(G2H2(108),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G2H2(109),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(201)])
call HGT_OLR(G2H2(112),1,1,2)
call HGT_invQ_OLR(G2H2(112),2,5,2)
call HGT_OLR(G2H2(112),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G2H2(113),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(199),[G2H2(116)])
call ol_merge_last(G2H2(122), G2H2(122)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(41)])
call HGT_lower_alpha_w2_OLR(G2H2(122),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(122),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(122),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G2H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G2H2(123),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(185),[G2H2(127),G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G2H2(186),G2H2(131),G1H2(268)])
call ol_merge_last(G1H2(5), G1H2(5)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(5)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G2H2(135),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(188),[G2H2(139),G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G2H2(142)])
call ol_merge_last(G2H2(148), G2H2(148)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(6)])
call HGT_lower_alpha_w2_OLR(G2H2(148),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(148),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(148),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G2H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G2H2(149),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(103)])
call HGT_OLR(G2H2(152),1,1,2)
call HGT_invQ_OLR(G2H2(152),2,5,2)
call HGT_OLR(G2H2(152),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G2H2(153),G1H2(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(23),G1H2(114)])
call HGT_OLR(G2H2(156),1,1,2)
call HGT_invQ_OLR(G2H2(156),2,5,2)
call HGT_OLR(G2H2(156),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G2H2(202),G2H2(157),G1H2(311)])
call ol_merge_last(G1H2(7), G1H2(7)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(11)])
call HGT_OLR(G2H2(160),1,1,2)
call HGT_invQ_OLR(G2H2(160),2,5,2)
call HGT_OLR(G2H2(160),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(203),[G2H2(161),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(125)])
call HGT_OLR(G2H2(164),1,1,2)
call HGT_invQ_OLR(G2H2(164),2,5,2)
call HGT_OLR(G2H2(164),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G2H2(165),G1H2(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(207),[G2H2(168)])
call ol_merge_last(G2H2(174), G2H2(174)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(17)])
call HGT_lower_alpha_w2_OLR(G2H2(174),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(174),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(174),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(206),[G2H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(208),[G2H2(175),G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(113),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(225),[G2H2(98),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(118),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(235),[G2H2(102),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(124),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(72),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G1H2(129),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(253),[G2H2(83),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(87),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G2H2(95),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(92),G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(271),[G2H2(99),G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(102),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(279),[G2H2(75),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(107),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G2H2(86),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(384),[G2H2(378),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(408),[G2H2(402),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(381),[G2H2(375),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G2H2(399),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(366),[G2H2(354),G2H2(336),G2H2(330),G1H2(133),G1H2(122) &
    ,G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(24),G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G1H2(164),G1H2(148),G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(224),[G1H2(170),G1H2(154),G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(363),[G2H2(351),G2H2(333),G2H2(327),G1H2(209),G1H2(198) &
    ,G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(11),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(239),[G1H2(240),G1H2(224),G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G1H2(246),G1H2(230),G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(256),[G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(257),[G1H2(283),G1H2(267),G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(260),[G1H2(289),G1H2(273),G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G1H2(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(275),[G1H2(326),G1H2(310),G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(278),[G1H2(332),G1H2(316),G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G1H2(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(292),[G1H2(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(212),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(209),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(218),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(215),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G2H2(250),G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(283),[G2H2(247),G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(268),[G2H2(232),G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(265),[G2H2(229),G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(391),[G2H2(385),G2H2(114),G2H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(394),[G2H2(388),G2H2(117),G2H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G2H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(111),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(267),[G2H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(270),[G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(288),[G2H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(193),G1H2(80),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(242),G1H2(139),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(342),[G2H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(348),[G2H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(367),[G2H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(369),[G2H2(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(370),[G2H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(372),[G2H2(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(334),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(393),[G2H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(396),[G2H2(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(177),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(168)])
  call Hotf_4pt_reduction(G2H2(382),RedSet_4(7),mass4set(:,10),  & 
G1H2(206),G1H2(210),G1H2(227),G1H2(228),G1H2(233),2)
  call HG1shiftOLR(G1H2(210),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(340),ex4(:),G2tensor(25),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(346),ex4(:),G2tensor(2),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hotf_4pt_reduction(G2H2(406),RedSet_4(7),mass4set(:,10),  & 
G1H2(253),G1H2(254),G1H2(259),G1H2(281),G1H2(286),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_4pt_reduction(G2H2(379),RedSet_4(7),mass4set(:,10),  & 
G1H2(287),G1H2(296),G1H2(297),G1H2(302),G1H2(313),2)
  call HG1shiftOLR(G1H2(296),8,2)
  call Hotf_4pt_reduction(G2H2(403),RedSet_4(7),mass4set(:,10),  & 
G1H2(314),G1H2(319),G1H2(324),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(319),8,2)
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(26),mass4set(:,2),  & 
G1H2(14),G1H2(20),G1H2(26),G1H2(38),G1H2(44),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hotf_4pt_reduction(G2H2(364),RedSet_4(7),mass4set(:,9),  & 
G1H2(50),G1H2(62),G1H2(68),G1H2(74),G1H2(106),2)
  call HG1shiftOLR(G1H2(62),8,2)
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(26),mass4set(:,3),  & 
G1H2(117),G1H2(128),G1H2(150),G1H2(166),G1H2(182),2)
  call HG1shiftOLR(G1H2(128),2,2)
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(26),mass4set(:,4),  & 
G1H2(204),G1H2(215),G1H2(226),G1H2(258),G1H2(269),2)
  call HG1shiftOLR(G1H2(215),2,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(26),mass4set(:,3),  & 
G1H2(285),G1H2(312),G1H2(328),G1H2(9),G1H2(232),2)
  call HG1shiftOLR(G1H2(312),2,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(28),mass4set(:,5),  & 
G1H2(51),G1H2(52),G1H2(57),G1H2(58),G1H2(275),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hotf_4pt_reduction(G2H2(177),RedSet_4(11),mass4set(:,5),  & 
G1H2(64),G1H2(291),G1H2(69),G1H2(318),G1H2(75),2)
  call HG1shiftOLR(G1H2(291),8,2)
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(28),mass4set(:,6),  & 
G1H2(76),G1H2(39),G1H2(34),G1H2(13),G1H2(172),2)
  call HG1shiftOLR(G1H2(39),4,2)
  call Hotf_4pt_reduction(G2H2(181),RedSet_4(11),mass4set(:,6),  & 
G1H2(28),G1H2(46),G1H2(96),G1H2(19),G1H2(91),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(28),mass4set(:,7),  & 
G1H2(33),G1H2(37),G1H2(45),G1H2(40),G1H2(43),2)
  call HG1shiftOLR(G1H2(37),4,2)
  call Hotf_4pt_reduction(G2H2(179),RedSet_4(11),mass4set(:,7),  & 
G1H2(127),G1H2(116),G1H2(105),G1H2(138),G1H2(149),2)
  call HG1shiftOLR(G1H2(116),8,2)
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(28),mass4set(:,8),  & 
G1H2(1),G1H2(81),G1H2(25),G1H2(165),G1H2(2),2)
  call HG1shiftOLR(G1H2(81),4,2)
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(11),mass4set(:,8),  & 
G1H2(86),G1H2(31),G1H2(203),G1H2(192),G1H2(181),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(183),ex4(:),G2tensor(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(28),mass4set(:,7),  & 
G1H2(179),G1H2(214),G1H2(190),G1H2(225),G1H2(3),2)
  call HG1shiftOLR(G1H2(214),4,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(182),ex4(:),G2tensor(31),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hotf_4pt_reduction(G2H2(184),RedSet_4(11),mass4set(:,7),  & 
G1H2(35),G1H2(49),G1H2(201),G1H2(241),G1H2(4),2)
  call HG1shiftOLR(G1H2(49),8,2)
call HGT_OLR(G2H2(84),1,1,2)
call HGT_invQ_OLR(G2H2(84),2,5,2)
call HGT_OLR(G2H2(84),6,15,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(27),mass4set(:,2),  & 
G1H2(41),G1H2(55),G1H2(257),G1H2(268),G1H2(5),2)
  call HG1shiftOLR(G1H2(55),1,2)
  call Hotf_4pt_reduction(G2H2(361),RedSet_4(7),mass4set(:,9),  & 
G1H2(21),G1H2(61),G1H2(284),G1H2(6),G1H2(27),2)
  call HG1shiftOLR(G1H2(61),8,2)
call HGT_OLR(G2H2(88),1,1,2)
call HGT_invQ_OLR(G2H2(88),2,5,2)
call HGT_OLR(G2H2(88),6,15,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(27),mass4set(:,3),  & 
G1H2(67),G1H2(103),G1H2(300),G1H2(114),G1H2(311),2)
  call HG1shiftOLR(G1H2(103),1,2)
call HGT_OLR(G2H2(92),1,1,2)
call HGT_invQ_OLR(G2H2(92),2,5,2)
call HGT_OLR(G2H2(92),6,15,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(27),mass4set(:,4),  & 
G1H2(7),G1H2(11),G1H2(73),G1H2(125),G1H2(327),2)
  call HG1shiftOLR(G1H2(11),1,2)
call HGT_OLR(G2H2(96),1,1,2)
call HGT_invQ_OLR(G2H2(96),2,5,2)
call HGT_OLR(G2H2(96),6,15,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(27),mass4set(:,3),  & 
G1H2(8),G1H2(17),G1H2(79),G1H2(12),G1H2(18),2)
  call HG1shiftOLR(G1H2(17),1,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(13),mass4set(:,5),  & 
G1H2(113),G1H2(23),G1H2(24),G1H2(118),G1H2(29),2)
  call HG1shiftOLR(G1H2(23),8,2)
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(18),mass4set(:,5),  & 
G1H2(30),G1H2(36),G1H2(42),G1H2(124),G1H2(47),2)
  call HG1shiftOLR(G1H2(36),4,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(13),mass4set(:,6),  & 
G1H2(48),G1H2(129),G1H2(53),G1H2(54),G1H2(87),2)
  call HG1shiftOLR(G1H2(129),8,2)
  call Hotf_4pt_reduction(G2H2(197),RedSet_4(18),mass4set(:,6),  & 
G1H2(59),G1H2(60),G1H2(92),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(60),4,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(13),mass4set(:,7),  & 
G1H2(102),G1H2(71),G1H2(72),G1H2(107),G1H2(77),2)
  call HG1shiftOLR(G1H2(71),8,2)
  call Hotf_4pt_reduction(G2H2(195),RedSet_4(18),mass4set(:,7),  & 
G1H2(78),G1H2(85),G1H2(90),G1H2(95),G1H2(100),2)
  call HG1shiftOLR(G1H2(85),4,2)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(13),mass4set(:,8),  & 
G1H2(104),G1H2(133),G1H2(122),G1H2(111),G1H2(115),2)
  call HG1shiftOLR(G1H2(133),8,2)
  call Hotf_4pt_reduction(G2H2(196),RedSet_4(18),mass4set(:,8),  & 
G1H2(126),G1H2(136),G1H2(164),G1H2(148),G1H2(137),2)
  call HG1shiftOLR(G1H2(136),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(199),ex3(:),G2tensor(4),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(13),mass4set(:,7),  & 
G1H2(170),G1H2(154),G1H2(143),G1H2(147),G1H2(159),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(198),ex3(:),G2tensor(3),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hotf_4pt_reduction(G2H2(200),RedSet_4(18),mass4set(:,7),  & 
G1H2(163),G1H2(175),G1H2(180),G1H2(209),G1H2(198),2)
  call HG1shiftOLR(G1H2(175),4,2)
call HGT_OLR(G2H2(126),1,1,2)
call HGT_invQ_OLR(G2H2(126),2,5,2)
call HGT_OLR(G2H2(126),6,15,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(29),mass4set(:,5),  & 
G1H2(187),G1H2(191),G1H2(202),G1H2(212),G1H2(240),2)
  call HG1shiftOLR(G1H2(191),4,2)
  call Hotf_4pt_reduction(G2H2(185),RedSet_4(21),mass4set(:,5),  & 
G1H2(224),G1H2(213),G1H2(246),G1H2(230),G1H2(219),2)
  call HG1shiftOLR(G1H2(213),8,2)
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(29),mass4set(:,6),  & 
G1H2(223),G1H2(235),G1H2(239),G1H2(251),G1H2(255),2)
  call HG1shiftOLR(G1H2(235),4,2)
  call Hotf_4pt_reduction(G2H2(189),RedSet_4(21),mass4set(:,6),  & 
G1H2(283),G1H2(267),G1H2(256),G1H2(289),G1H2(273),2)
  call HG1shiftOLR(G1H2(267),8,2)
  call Hotf_4pt_reduction(G2H2(134),RedSet_4(29),mass4set(:,7),  & 
G1H2(262),G1H2(266),G1H2(278),G1H2(282),G1H2(294),2)
  call HG1shiftOLR(G1H2(266),4,2)
  call Hotf_4pt_reduction(G2H2(187),RedSet_4(21),mass4set(:,7),  & 
G1H2(298),G1H2(326),G1H2(310),G1H2(299),G1H2(332),2)
  call HG1shiftOLR(G1H2(326),8,2)
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(29),mass4set(:,8),  & 
G1H2(316),G1H2(305),G1H2(309),G1H2(321),G1H2(325),2)
  call HG1shiftOLR(G1H2(305),4,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(21),mass4set(:,8),  & 
G1H2(337),G1H2(119),G1H2(112),G1H2(130),G1H2(123),2)
  call HG1shiftOLR(G1H2(119),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(191),ex4(:),G2tensor(37),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(29),mass4set(:,7),  & 
G1H2(97),G1H2(82),G1H2(108),G1H2(101),G1H2(193),2)
  call HG1shiftOLR(G1H2(82),4,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(190),ex4(:),G2tensor(6),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hotf_4pt_reduction(G2H2(192),RedSet_4(21),mass4set(:,7),  & 
G1H2(80),G1H2(32),G1H2(242),G1H2(139),G1H2(56),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(5),mass4set(:,5),  & 
G1H2(301),G1H2(10),G1H2(134),G1H2(140),G1H2(151),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_4pt_reduction(G2H2(201),RedSet_4(24),mass4set(:,5),  & 
G1H2(152),G1H2(167),G1H2(168),G1H2(339),G1H2(340),2)
  call HG1shiftOLR(G1H2(167),4,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(5),mass4set(:,6),  & 
G1H2(341),G1H2(342),G1H2(343),G1H2(344),G1H2(345),2)
  call HG1shiftOLR(G1H2(342),8,2)
  call Hotf_4pt_reduction(G2H2(205),RedSet_4(24),mass4set(:,6),  & 
G1H2(346),G1H2(347),G1H2(348),G1H2(349),G1H2(350),2)
  call HG1shiftOLR(G1H2(347),4,2)
  call Hotf_4pt_reduction(G2H2(160),RedSet_4(5),mass4set(:,7),  & 
G1H2(351),G1H2(352),G1H2(353),G1H2(354),G1H2(355),2)
  call HG1shiftOLR(G1H2(352),8,2)
  call Hotf_4pt_reduction(G2H2(203),RedSet_4(24),mass4set(:,7),  & 
G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(357),4,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(5),mass4set(:,8),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),2)
  call HG1shiftOLR(G1H2(362),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(24),mass4set(:,8),  & 
G1H2(366),G1H2(367),G1H2(368),G1H2(369),G1H2(370),2)
  call HG1shiftOLR(G1H2(367),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(207),ex3(:),G2tensor(5),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hotf_4pt_reduction(G2H2(174),RedSet_4(5),mass4set(:,7),  & 
G1H2(371),G1H2(372),G1H2(373),G1H2(374),G1H2(375),2)
  call HG1shiftOLR(G1H2(372),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(206),ex3(:),G2tensor(43),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hotf_4pt_reduction(G2H2(208),RedSet_4(24),mass4set(:,7),  & 
G1H2(376),G1H2(377),G1H2(378),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(377),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(6),mass4set(:,7),  & 
G1H2(381),G1H2(382),G1H2(383),G1H2(384),G1H2(385),2)
  call HG1shiftOLR(G1H2(382),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(6),mass4set(:,7),  & 
G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(387),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(9),mass4set(:,12),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),2)
  call HG1shiftOLR(G1H2(392),8,2)
  call Hotf_4pt_reduction(G2H2(225),RedSet_4(10),mass4set(:,10),  & 
G1H2(396),G1H2(397),G1H2(398),G1H2(399),G1H2(400),2)
  call HG1shiftOLR(G1H2(397),8,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(9),mass4set(:,12),  & 
G1H2(401),G1H2(402),G1H2(403),G1H2(404),G1H2(405),2)
  call HG1shiftOLR(G1H2(402),8,2)
  call Hotf_4pt_reduction(G2H2(235),RedSet_4(10),mass4set(:,10),  & 
G1H2(406),G1H2(407),G1H2(408),G1H2(409),G1H2(410),2)
  call HG1shiftOLR(G1H2(407),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(14),mass4set(:,7),  & 
G1H2(411),G1H2(412),G1H2(413),G1H2(414),G1H2(415),2)
  call HG1shiftOLR(G1H2(412),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(14),mass4set(:,7),  & 
G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(417),8,2)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(16),mass4set(:,12),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),2)
  call HG1shiftOLR(G1H2(422),4,2)
  call Hotf_4pt_reduction(G2H2(243),RedSet_4(17),mass4set(:,10),  & 
G1H2(426),G1H2(427),G1H2(428),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(427),4,2)
  call Hotf_4pt_reduction(G2H2(159),RedSet_4(16),mass4set(:,12),  & 
G1H2(431),G1H2(432),G1H2(433),G1H2(434),G1H2(435),2)
  call HG1shiftOLR(G1H2(432),4,2)
  call Hotf_4pt_reduction(G2H2(253),RedSet_4(17),mass4set(:,10),  & 
G1H2(436),G1H2(437),G1H2(438),G1H2(439),G1H2(440),2)
  call HG1shiftOLR(G1H2(437),4,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(20),mass4set(:,12),  & 
G1H2(441),G1H2(442),G1H2(443),G1H2(444),G1H2(445),2)
  call HG1shiftOLR(G1H2(442),8,2)
  call Hotf_4pt_reduction(G2H2(261),RedSet_4(10),mass4set(:,10),  & 
G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),2)
  call HG1shiftOLR(G1H2(447),8,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(20),mass4set(:,12),  & 
G1H2(451),G1H2(452),G1H2(453),G1H2(454),G1H2(455),2)
  call HG1shiftOLR(G1H2(452),8,2)
  call Hotf_4pt_reduction(G2H2(271),RedSet_4(10),mass4set(:,10),  & 
G1H2(456),G1H2(457),G1H2(458),G1H2(459),G1H2(460),2)
  call HG1shiftOLR(G1H2(457),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(23),mass4set(:,12),  & 
G1H2(461),G1H2(462),G1H2(463),G1H2(464),G1H2(465),2)
  call HG1shiftOLR(G1H2(462),4,2)
  call Hotf_4pt_reduction(G2H2(279),RedSet_4(17),mass4set(:,10),  & 
G1H2(466),G1H2(467),G1H2(468),G1H2(469),G1H2(470),2)
  call HG1shiftOLR(G1H2(467),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(23),mass4set(:,12),  & 
G1H2(471),G1H2(472),G1H2(473),G1H2(474),G1H2(475),2)
  call HG1shiftOLR(G1H2(472),4,2)
  call Hotf_4pt_reduction(G2H2(289),RedSet_4(17),mass4set(:,10),  & 
G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(477),4,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(83),23,ex4(:),8,G2tensor(8),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(84),23,ex4(:),8,G2tensor(7),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(384),23,ex4(:),8,G3tensor(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(49),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(89),23,ex4(:),8,G2tensor(10),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(408),23,ex4(:),8,G3tensor(2),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(93),23,ex4(:),8,G2tensor(9),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(94),23,ex4(:),8,G2tensor(55),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(381),23,ex4(:),8,G3tensor(3),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(98),23,ex4(:),8,G2tensor(12),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(99),23,ex4(:),8,G2tensor(11),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(405),23,ex4(:),8,G3tensor(4),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(6),mass4set(:,5),  & 
G1H2(83),G1H2(84),G1H2(88),G1H2(89),G1H2(93),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hloop_AV_Q(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(28),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(34),n2h1(98))
  call Hloop_AV_Q(ntryL,G2H2(366),ex4(:),G2H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(5),n2h1(99))
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(6),mass4set(:,6),  & 
G1H2(94),G1H2(98),G1H2(99),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hloop_AV_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(40),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(46),n2h1(101))
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(6),mass4set(:,8),  & 
G1H2(120),G1H2(121),G1H2(481),G1H2(482),G1H2(483),2)
  call HG1shiftOLR(G1H2(121),8,2)
  call Hloop_AV_Q(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(52),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(58),n2h1(103))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(9),mass4set(:,13),  & 
G1H2(131),G1H2(132),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(132),8,2)
  call Hotf_4pt_reduction(G2H2(221),RedSet_4(10),mass4set(:,9),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),2)
  call HG1shiftOLR(G1H2(488),8,2)
  call Hloop_QV_A(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(65),n2h1(104))
  call Hloop_QV_A(ntryL,G2H2(224),ex4(:),G2H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(6),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(69),n2h1(106))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(9),mass4set(:,14),  & 
G1H2(142),G1H2(144),G1H2(492),G1H2(493),G1H2(494),2)
  call HG1shiftOLR(G1H2(144),8,2)
  call Hloop_QV_A(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(73),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(77),n2h1(108))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(158),23,ex4(:),8,G2tensor(81),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(228),23,ex4(:),8,G3tensor(7),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(160),23,ex4(:),8,G2tensor(86),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(9),mass4set(:,15),  & 
G1H2(153),G1H2(155),G1H2(158),G1H2(160),G1H2(495),2)
  call HG1shiftOLR(G1H2(155),8,2)
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(91),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(95),n2h1(110))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(174),23,ex4(:),8,G2tensor(99),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(238),23,ex4(:),8,G3tensor(8),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(176),23,ex4(:),8,G2tensor(103),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(14),mass4set(:,5),  & 
G1H2(169),G1H2(171),G1H2(174),G1H2(176),G1H2(496),2)
  call HG1shiftOLR(G1H2(171),8,2)
  call Hloop_QV_A(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(107),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(186),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(112),n2h1(112))
  call Hloop_QV_A(ntryL,G2H2(363),ex4(:),G2H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(9),n2h1(113))
  call Hotf_4pt_reduction(G2H2(121),RedSet_4(14),mass4set(:,6),  & 
G1H2(185),G1H2(186),G1H2(497),G1H2(498),G1H2(499),2)
  call HG1shiftOLR(G1H2(186),8,2)
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(117),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(197),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(121),n2h1(115))
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(14),mass4set(:,8),  & 
G1H2(196),G1H2(197),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(197),8,2)
  call Hloop_QV_A(ntryL,G1H2(207),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(126),n2h1(116))
  call Hloop_QV_A(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(131),n2h1(117))
  call Hotf_4pt_reduction(G2H2(115),RedSet_4(16),mass4set(:,13),  & 
G1H2(207),G1H2(208),G1H2(503),G1H2(504),G1H2(505),2)
  call HG1shiftOLR(G1H2(208),4,2)
  call Hotf_4pt_reduction(G2H2(239),RedSet_4(17),mass4set(:,9),  & 
G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),2)
  call HG1shiftOLR(G1H2(507),4,2)
  call Hloop_QV_A(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(135),n2h1(118))
  call Hloop_QV_A(ntryL,G2H2(242),ex3(:),G2H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(10),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(220),ex3(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(140),n2h1(120))
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(16),mass4set(:,14),  & 
G1H2(218),G1H2(220),G1H2(511),G1H2(512),G1H2(513),2)
  call HG1shiftOLR(G1H2(220),4,2)
  call Hloop_QV_A(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(145),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(231),ex3(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(146),n2h1(122))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(234),27,ex3(:),4,G2tensor(147),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(246),27,ex3(:),4,G3tensor(11),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(236),27,ex3(:),4,G2tensor(148),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hotf_4pt_reduction(G2H2(147),RedSet_4(16),mass4set(:,15),  & 
G1H2(229),G1H2(231),G1H2(234),G1H2(236),G1H2(514),2)
  call HG1shiftOLR(G1H2(231),4,2)
  call Hloop_QV_A(ntryL,G1H2(245),ex3(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(149),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(247),ex3(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(150),n2h1(124))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(250),27,ex3(:),4,G2tensor(151),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(256),27,ex3(:),4,G3tensor(12),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(252),27,ex3(:),4,G2tensor(152),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hotf_4pt_reduction(G2H2(173),RedSet_4(20),mass4set(:,13),  & 
G1H2(245),G1H2(247),G1H2(250),G1H2(252),G1H2(515),2)
  call HG1shiftOLR(G1H2(247),8,2)
  call Hotf_4pt_reduction(G2H2(257),RedSet_4(10),mass4set(:,9),  & 
G1H2(516),G1H2(517),G1H2(518),G1H2(519),G1H2(520),2)
  call HG1shiftOLR(G1H2(517),8,2)
  call Hloop_AV_Q(ntryL,G1H2(261),ex4(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(153),n2h1(125))
  call Hloop_AV_Q(ntryL,G2H2(260),ex4(:),G2H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(13),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(154),n2h1(127))
  call Hotf_4pt_reduction(G2H2(167),RedSet_4(20),mass4set(:,14),  & 
G1H2(261),G1H2(263),G1H2(521),G1H2(522),G1H2(523),2)
  call HG1shiftOLR(G1H2(263),8,2)
  call Hloop_AV_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(155),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(274),ex4(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(156),n2h1(129))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(277),23,ex4(:),8,G2tensor(157),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(264),23,ex4(:),8,G3tensor(14),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(279),23,ex4(:),8,G2tensor(158),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(20),mass4set(:,15),  & 
G1H2(272),G1H2(274),G1H2(277),G1H2(279),G1H2(524),2)
  call HG1shiftOLR(G1H2(274),8,2)
  call Hloop_AV_Q(ntryL,G1H2(288),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(159),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(160),n2h1(131))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(293),23,ex4(:),8,G2tensor(161),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(274),23,ex4(:),8,G3tensor(15),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(295),23,ex4(:),8,G2tensor(162),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(23),mass4set(:,13),  & 
G1H2(288),G1H2(290),G1H2(293),G1H2(295),G1H2(525),2)
  call HG1shiftOLR(G1H2(290),4,2)
  call Hotf_4pt_reduction(G2H2(275),RedSet_4(17),mass4set(:,9),  & 
G1H2(526),G1H2(527),G1H2(528),G1H2(529),G1H2(530),2)
  call HG1shiftOLR(G1H2(527),4,2)
  call Hloop_AV_Q(ntryL,G1H2(304),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(163),n2h1(132))
  call Hloop_AV_Q(ntryL,G2H2(278),ex3(:),G2H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(16),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(164),n2h1(134))
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(23),mass4set(:,14),  & 
G1H2(304),G1H2(306),G1H2(531),G1H2(532),G1H2(533),2)
  call HG1shiftOLR(G1H2(306),4,2)
  call Hloop_AV_Q(ntryL,G1H2(315),ex3(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(165),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(317),ex3(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(166),n2h1(136))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(320),27,ex3(:),4,G2tensor(167),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(282),27,ex3(:),4,G3tensor(17),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(322),27,ex3(:),4,G2tensor(168),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(23),mass4set(:,15),  & 
G1H2(315),G1H2(317),G1H2(320),G1H2(322),G1H2(534),2)
  call HG1shiftOLR(G1H2(317),4,2)
  call Hloop_AV_Q(ntryL,G1H2(331),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(169),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(333),ex3(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(170),n2h1(138))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(336),27,ex3(:),4,G2tensor(171),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(292),27,ex3(:),4,G3tensor(18),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(338),27,ex3(:),4,G2tensor(172),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(212),ex2(:),G2tensor(173),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(174),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(209),ex2(:),G2tensor(175),ngPln,m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(176),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(218),ex1(:),G2tensor(177),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(178),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(215),ex1(:),G2tensor(179),ngPnl,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(180),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(181),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(65),ex4(:),G2tensor(182),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(141),ex3(:),G2tensor(183),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(170),ex3(:),G2tensor(184),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(185),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(186),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(44),ex3(:),G2tensor(187),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(188),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(189),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(190),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(64),ex4(:),G2tensor(191),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(68),ex4(:),G2tensor(192),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(15),ex3(:),G1tensor(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(16),ex3(:),G1tensor(7),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(22),ex3(:),G1tensor(13),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(156),ex3(:),G1tensor(19),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(67),ex4(:),ex3(:),G2tensor(193),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(71),ex4(:),ex3(:),G2tensor(194),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(75),ex4(:),ex3(:),G2tensor(195),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(80),ex4(:),ex3(:),G2tensor(196),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(286),ex3(:),G2tensor(197),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(283),ex3(:),G2tensor(198),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(268),ex4(:),G2tensor(199),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(265),ex4(:),G2tensor(200),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hotf_4pt_reduction(G2H2(391),RedSet_4(7),mass4set(:,10),  & 
G1H2(331),G1H2(333),G1H2(336),G1H2(338),G1H2(15),2)
  call HG1shiftOLR(G1H2(333),8,2)
  call Hotf_4pt_reduction(G2H2(394),RedSet_4(7),mass4set(:,10),  & 
G1H2(16),G1H2(22),G1H2(156),G1H2(535),G1H2(536),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(2),mass4set(:,2),  & 
G1H4(220),G1H4(216),G1H4(208),G1H4(204),G1H4(1),4)
  call HG1shiftOLR(G1H4(216),9,4)
  call Hotf_4pt_reduction(G2H4(89),RedSet_4(2),mass4set(:,3),  & 
G1H4(2),G1H4(3),G1H4(4),G1H4(7),G1H4(11),4)
  call HG1shiftOLR(G1H4(3),9,4)
  call Hotf_4pt_reduction(G2H4(93),RedSet_4(2),mass4set(:,4),  & 
G1H4(13),G1H4(12),G1H4(19),G1H4(16),G1H4(25),4)
  call HG1shiftOLR(G1H4(12),9,4)
  call Hotf_4pt_reduction(G2H4(98),RedSet_4(2),mass4set(:,3),  & 
G1H4(29),G1H4(233),G1H4(237),G1H4(235),G1H4(236),4)
  call HG1shiftOLR(G1H4(233),9,4)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(102),wf4(:,9),G2tensor(201),m3h4x1(:,1),heltab2x4(:,:,433))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(41),wf4(:,9),G2tensor(202),ngPnl,m3h4x1(:,2),heltab2x4(:,:,434))
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(1),mass4set(:,2),  & 
G1H4(238),G1H4(243),G1H4(244),G1H4(73),G1H4(75),4)
  call HG1shiftOLR(G1H4(243),10,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(1),mass4set(:,3),  & 
G1H4(79),G1H4(76),G1H4(85),G1H4(78),G1H4(91),4)
  call HG1shiftOLR(G1H4(76),10,4)
  call Hotf_4pt_reduction(G2H4(95),RedSet_4(1),mass4set(:,4),  & 
G1H4(129),G1H4(245),G1H4(249),G1H4(247),G1H4(248),4)
  call HG1shiftOLR(G1H4(245),10,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(1),mass4set(:,3),  & 
G1H4(250),G1H4(255),G1H4(256),G1H4(173),G1H4(15),4)
  call HG1shiftOLR(G1H4(255),10,4)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(115),wf4(:,4),G2tensor(203),m3h4x1(:,3),heltab2x4(:,:,435))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(111),wf4(:,4),G2tensor(204),ngPln,m3h4x1(:,4),heltab2x4(:,:,436))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(211),ex2(:),G2tensor(205),ngPln,m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(214),ex2(:),G2tensor(206),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(217),ex1(:),G2tensor(207),ngPnl,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(220),ex1(:),G2tensor(208),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(209),n2h1(139))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(194),23,ex4(:),8,G2tensor(210),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(267),ex4(:),G2tensor(211),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(270),ex4(:),G2tensor(212),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(200),23,ex4(:),8,G2tensor(213),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hloop_QV_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(214),n2h1(140))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(216),27,ex3(:),4,G2tensor(215),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(285),ex3(:),G2tensor(216),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(288),ex3(:),G2tensor(217),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(222),27,ex3(:),4,G2tensor(218),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hloop_AV_Q(ntryL,G1H2(237),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(219),n2h1(141))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(238),23,ex4(:),8,G2tensor(220),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(249),23,ex4(:),8,G2tensor(221),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hloop_AV_Q(ntryL,G1H2(260),ex3(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(222),n2h1(142))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(264),27,ex3(:),4,G2tensor(223),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(271),27,ex3(:),4,G2tensor(224),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hotf_4pt_reduction(G2H2(293),RedSet_4(17),mass4set(:,10),  & 
G1H2(189),G1H2(194),G1H2(200),G1H2(211),G1H2(216),2)
  call HG1shiftOLR(G1H2(194),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(296),27,ex3(:),4,G3tensor(19),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(276),27,ex3(:),4,G2tensor(225),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hotf_4pt_reduction(G2H2(297),RedSet_4(17),mass4set(:,10),  & 
G1H2(222),G1H2(237),G1H2(238),G1H2(249),G1H2(260),2)
  call HG1shiftOLR(G1H2(237),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(300),27,ex3(:),G3tensor(20),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(280),27,ex3(:),G2tensor(226),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hotf_4pt_reduction(G2H2(301),RedSet_4(17),mass4set(:,11),  & 
G1H2(264),G1H2(271),G1H2(276),G1H2(280),G1H2(537),2)
  call HG1shiftOLR(G1H2(271),4,2)
  call Hloop_QV_A(ntryL,G2H2(304),ex3(:),G2H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(143))
  call Hloop_QV_A(ntryL,G1H2(292),ex3(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(227),n2h1(144))
  call Hotf_4pt_reduction(G2H2(305),RedSet_4(17),mass4set(:,11),  & 
G1H2(292),G1H2(538),G1H2(539),G1H2(540),G1H2(541),2)
  call HG1shiftOLR(G1H2(538),4,2)
  call Hloop_AV_Q(ntryL,G2H2(308),ex3(:),G2H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(145))
  call Hloop_AV_Q(ntryL,G1H2(303),ex3(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(228),n2h1(146))
  call Hotf_4pt_reduction(G2H2(309),RedSet_4(10),mass4set(:,10),  & 
G1H2(303),G1H2(542),G1H2(543),G1H2(544),G1H2(545),2)
  call HG1shiftOLR(G1H2(542),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(312),23,ex4(:),G3tensor(23),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(307),23,ex4(:),G2tensor(229),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hotf_4pt_reduction(G2H2(313),RedSet_4(10),mass4set(:,10),  & 
G1H2(307),G1H2(546),G1H2(547),G1H2(548),G1H2(549),2)
  call HG1shiftOLR(G1H2(546),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(316),23,ex4(:),8,G3tensor(24),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(308),23,ex4(:),8,G2tensor(230),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hotf_4pt_reduction(G2H2(317),RedSet_4(10),mass4set(:,11),  & 
G1H2(308),G1H2(550),G1H2(551),G1H2(552),G1H2(553),2)
  call HG1shiftOLR(G1H2(550),8,2)
  call Hloop_AV_Q(ntryL,G2H2(320),ex4(:),G2H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H2(323),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(231),n2h1(148))
  call Hotf_4pt_reduction(G2H2(321),RedSet_4(10),mass4set(:,11),  & 
G1H2(323),G1H2(554),G1H2(555),G1H2(556),G1H2(557),2)
  call HG1shiftOLR(G1H2(554),8,2)
  call Hloop_QV_A(ntryL,G2H2(324),ex4(:),G2H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(26),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(335),ex4(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(232),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(233),n2h1(151))
  call Hloop_AV_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(234),n2h1(152))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(342),ex4(:),G2tensor(235),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(348),ex4(:),G2tensor(236),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hotf_4pt_reduction(G2H2(367),RedSet_4(7),mass4set(:,11),  & 
G1H2(335),G1H2(248),G1H2(63),G1H2(558),G1H2(559),2)
  call HG1shiftOLR(G1H2(248),8,2)
  call Hloop_QV_A(ntryL,G2H2(369),ex4(:),G2H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(237),n2h1(154))
  call Hotf_4pt_reduction(G2H2(370),RedSet_4(7),mass4set(:,11),  & 
G1H2(70),G1H2(560),G1H2(561),G1H2(562),G1H2(563),2)
  call HG1shiftOLR(G1H2(560),8,2)
  call Hloop_AV_Q(ntryL,G2H2(372),ex4(:),G2H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(28),n2h1(155))
  call Hloop_AV_Q(ntryL,G1H2(334),ex4(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(238),n2h1(156))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(141),23,ex4(:),8,G2tensor(239),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(145),23,ex4(:),8,G2tensor(240),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(393),23,ex4(:),8,G3tensor(29),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(157),23,ex4(:),8,G2tensor(241),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(396),23,ex4(:),G3tensor(30),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(162),23,ex4(:),G2tensor(242),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(177),23,ex4(:),8,G2tensor(243),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(178),23,ex4(:),8,G2tensor(244),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(101),wf4(:,9),G2tensor(245),ngPnl,m3h4x1(:,5),heltab2x4(:,:,437))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(87),wf4(:,9),G2tensor(246),m3h4x1(:,6),heltab2x4(:,:,438))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(109),wf4(:,4),G2tensor(247),ngPln,m3h4x1(:,7),heltab2x4(:,:,439))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(113),wf4(:,4),G2tensor(248),m3h4x1(:,8),heltab2x4(:,:,440))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(206),23,ex4(:),8,G2tensor(249),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(210),0,ex4(:),8,G2tensor(250),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(233),23,ex4(:),8,G2tensor(251),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(253),23,ex4(:),8,G2tensor(252),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(254),0,ex4(:),8,G2tensor(253),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(286),23,ex4(:),8,G2tensor(254),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(287),23,ex4(:),8,G2tensor(255),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(296),0,ex4(:),8,G2tensor(256),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(313),23,ex4(:),8,G2tensor(257),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(314),23,ex4(:),8,G2tensor(258),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(319),0,ex4(:),8,G2tensor(259),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(330),23,ex4(:),8,G2tensor(260),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hloop_SA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),ngH,m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(261),n2h1(161))
  call Hloop_SA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),ngH,m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(262),n2h1(162))
  call Hloop_SA_Q(ntryL,G1H2(44),ex2(:),G1H1(1),ngH,m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(263),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(264),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(265),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(266),n2h1(166))
  call Hloop_SA_Q(ntryL,G1H2(117),ex2(:),G1H1(1),ngX,m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(267),n2h1(167))
  call Hloop_SA_Q(ntryL,G1H2(128),ex2(:),G1H1(1),ngX,m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(268),n2h1(168))
  call Hloop_SA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),ngX,m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(269),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(204),ex2(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(270),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(215),ex2(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(271),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H2(269),ex2(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(272),n2h1(172))
  call Hloop_ZA_Q(ntryL,G1H2(285),ex2(:),G1H1(1),ngZl,m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(273),n2h1(173))
  call Hloop_ZA_Q(ntryL,G1H2(312),ex2(:),G1H1(1),ngZl,m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nME,G2tensor(274),n2h1(174))
  call Hloop_ZA_Q(ntryL,G1H2(232),ex2(:),G1H1(1),ngZl,m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(275),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(276),n2h1(176))
  call Hloop_QV_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(277),n2h1(177))
  call Hloop_QV_A(ntryL,G1H2(275),ex3(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(278),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(279),n2h1(179))
  call Hloop_QV_A(ntryL,G1H2(291),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(280),n2h1(180))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(281),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(282),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(283),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(284),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(285),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(286),n2h1(186))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(287),n2h1(187))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(33),27,ex3(:),4,G2tensor(288),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(37),0,ex3(:),4,G2tensor(289),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(43),27,ex3(:),4,G2tensor(290),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(127),23,ex4(:),8,G2tensor(291),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(116),0,ex4(:),8,G2tensor(292),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(149),23,ex4(:),8,G2tensor(293),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(294),n2h1(190))
  call Hloop_QV_A(ntryL,G1H2(81),ex3(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(295),n2h1(191))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(296),n2h1(192))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(297),n2h1(193))
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(298),n2h1(194))
  call Hloop_QV_A(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(299),n2h1(195))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(179),27,ex3(:),4,G2tensor(300),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(214),0,ex3(:),4,G2tensor(301),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(3),27,ex3(:),4,G2tensor(302),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),23,ex4(:),8,G2tensor(303),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(49),0,ex4(:),8,G2tensor(304),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(4),23,ex4(:),8,G2tensor(305),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hloop_SQ_A(ntryL,G1H2(41),ex1(:),G1H1(1),ngH,m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(306),n2h1(198))
  call Hloop_SQ_A(ntryL,G1H2(55),ex1(:),G1H1(1),ngH,m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(307),n2h1(199))
  call Hloop_SQ_A(ntryL,G1H2(5),ex1(:),G1H1(1),ngH,m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(308),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(309),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(310),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(311),n2h1(203))
  call Hloop_SQ_A(ntryL,G1H2(67),ex1(:),G1H1(1),ngX,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(312),n2h1(204))
  call Hloop_SQ_A(ntryL,G1H2(103),ex1(:),G1H1(1),ngX,m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(313),n2h1(205))
  call Hloop_SQ_A(ntryL,G1H2(311),ex1(:),G1H1(1),ngX,m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(314),n2h1(206))
  call Hloop_VQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(315),n2h1(207))
  call Hloop_VQ_A(ntryL,G1H2(11),ex1(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(316),n2h1(208))
  call Hloop_VQ_A(ntryL,G1H2(327),ex1(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(317),n2h1(209))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex1(:),G1H1(1),ngZl,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(318),n2h1(210))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex1(:),G1H1(1),ngZl,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nME,G2tensor(319),n2h1(211))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),ngZl,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(320),n2h1(212))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(321),n2h1(213))
  call Hloop_QV_A(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(322),n2h1(214))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(323),n2h1(215))
  call Hloop_QV_A(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(324),n2h1(216))
  call Hloop_QV_A(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(325),n2h1(217))
  call Hloop_QV_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(326),n2h1(218))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(327),n2h1(219))
  call Hloop_QV_A(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(328),n2h1(220))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(329),n2h1(221))
  call Hloop_QV_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(330),n2h1(222))
  call Hloop_QV_A(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(331),n2h1(223))
  call Hloop_QV_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(332),n2h1(224))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(102),23,ex4(:),8,G2tensor(333),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(71),0,ex4(:),8,G2tensor(334),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(77),23,ex4(:),8,G2tensor(335),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(78),27,ex3(:),4,G2tensor(336),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(85),0,ex3(:),4,G2tensor(337),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(100),27,ex3(:),4,G2tensor(338),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hloop_QV_A(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(339),n2h1(227))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(340),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(341),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(342),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(343),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(344),n2h1(232))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(170),23,ex4(:),8,G2tensor(345),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(154),0,ex4(:),8,G2tensor(346),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(159),23,ex4(:),8,G2tensor(347),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(163),27,ex3(:),4,G2tensor(348),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(175),0,ex3(:),4,G2tensor(349),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(198),27,ex3(:),4,G2tensor(350),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hloop_AV_Q(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(351),n2h1(235))
  call Hloop_AV_Q(ntryL,G1H2(191),ex3(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(352),n2h1(236))
  call Hloop_AV_Q(ntryL,G1H2(240),ex3(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(353),n2h1(237))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(354),n2h1(238))
  call Hloop_AV_Q(ntryL,G1H2(213),ex4(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(355),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H2(219),ex4(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(356),n2h1(240))
  call Hloop_AV_Q(ntryL,G1H2(223),ex3(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(357),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H2(235),ex3(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(358),n2h1(242))
  call Hloop_AV_Q(ntryL,G1H2(255),ex3(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(359),n2h1(243))
  call Hloop_AV_Q(ntryL,G1H2(283),ex4(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(360),n2h1(244))
  call Hloop_AV_Q(ntryL,G1H2(267),ex4(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(361),n2h1(245))
  call Hloop_AV_Q(ntryL,G1H2(273),ex4(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(362),n2h1(246))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(262),27,ex3(:),4,G2tensor(363),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(266),0,ex3(:),4,G2tensor(364),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(294),27,ex3(:),4,G2tensor(365),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(298),23,ex4(:),8,G2tensor(366),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(326),0,ex4(:),8,G2tensor(367),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(332),23,ex4(:),8,G2tensor(368),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hloop_AV_Q(ntryL,G1H2(316),ex3(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(369),n2h1(249))
  call Hloop_AV_Q(ntryL,G1H2(305),ex3(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(370),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(325),ex3(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(371),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(337),ex4(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(372),n2h1(252))
  call Hloop_AV_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(373),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(374),n2h1(254))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(97),27,ex3(:),4,G2tensor(375),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(82),0,ex3(:),4,G2tensor(376),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(193),27,ex3(:),4,G2tensor(377),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(80),23,ex4(:),8,G2tensor(378),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(32),0,ex4(:),8,G2tensor(379),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(56),23,ex4(:),8,G2tensor(380),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hloop_AV_Q(ntryL,G1H2(301),ex4(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(381),n2h1(257))
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(382),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(383),n2h1(259))
  call Hloop_AV_Q(ntryL,G1H2(152),ex3(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(384),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(385),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(340),ex3(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(386),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(341),ex4(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(387),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(342),ex4(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(388),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(345),ex4(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(389),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(346),ex3(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(390),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(347),ex3(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(391),n2h1(267))
  call Hloop_AV_Q(ntryL,G1H2(350),ex3(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(392),n2h1(268))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(351),23,ex4(:),8,G2tensor(393),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(352),0,ex4(:),8,G2tensor(394),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(355),23,ex4(:),8,G2tensor(395),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(356),27,ex3(:),4,G2tensor(396),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(357),0,ex3(:),4,G2tensor(397),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(360),27,ex3(:),4,G2tensor(398),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hloop_AV_Q(ntryL,G1H2(361),ex4(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(399),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(362),ex4(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(400),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(365),ex4(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(401),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(366),ex3(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(402),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(367),ex3(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(403),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(370),ex3(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(404),n2h1(276))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(371),23,ex4(:),8,G2tensor(405),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(372),0,ex4(:),8,G2tensor(406),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(375),23,ex4(:),8,G2tensor(407),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(376),27,ex3(:),4,G2tensor(408),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(377),0,ex3(:),4,G2tensor(409),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(380),27,ex3(:),4,G2tensor(410),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(381),23,ex4(:),8,G2tensor(411),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(382),0,ex4(:),8,G2tensor(412),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(385),23,ex4(:),8,G2tensor(413),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(386),23,ex4(:),8,G2tensor(414),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(387),0,ex4(:),8,G2tensor(415),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(390),23,ex4(:),8,G2tensor(416),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(391),23,ex4(:),8,G2tensor(417),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(392),0,ex4(:),8,G2tensor(418),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(395),23,ex4(:),8,G2tensor(419),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(396),23,ex4(:),8,G2tensor(420),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(397),0,ex4(:),8,G2tensor(421),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(400),23,ex4(:),8,G2tensor(422),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(401),23,ex4(:),8,G2tensor(423),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(402),0,ex4(:),8,G2tensor(424),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(405),23,ex4(:),8,G2tensor(425),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(406),23,ex4(:),8,G2tensor(426),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(407),0,ex4(:),8,G2tensor(427),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(410),23,ex4(:),8,G2tensor(428),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(411),23,ex4(:),8,G2tensor(429),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(412),0,ex4(:),8,G2tensor(430),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(415),23,ex4(:),8,G2tensor(431),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(416),23,ex4(:),8,G2tensor(432),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(417),0,ex4(:),8,G2tensor(433),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(420),23,ex4(:),8,G2tensor(434),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(421),27,ex3(:),4,G2tensor(435),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(422),0,ex3(:),4,G2tensor(436),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(425),27,ex3(:),4,G2tensor(437),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(426),27,ex3(:),4,G2tensor(438),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(427),0,ex3(:),4,G2tensor(439),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(430),27,ex3(:),4,G2tensor(440),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(431),27,ex3(:),4,G2tensor(441),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(432),0,ex3(:),4,G2tensor(442),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(435),27,ex3(:),4,G2tensor(443),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(436),27,ex3(:),4,G2tensor(444),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(437),0,ex3(:),4,G2tensor(445),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(440),27,ex3(:),4,G2tensor(446),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(441),23,ex4(:),8,G2tensor(447),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(442),0,ex4(:),8,G2tensor(448),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(445),23,ex4(:),8,G2tensor(449),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(446),23,ex4(:),8,G2tensor(450),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(447),0,ex4(:),8,G2tensor(451),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(450),23,ex4(:),8,G2tensor(452),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(451),23,ex4(:),8,G2tensor(453),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(452),0,ex4(:),8,G2tensor(454),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(455),23,ex4(:),8,G2tensor(455),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(456),23,ex4(:),8,G2tensor(456),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(457),0,ex4(:),8,G2tensor(457),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(460),23,ex4(:),8,G2tensor(458),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(461),27,ex3(:),4,G2tensor(459),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(462),0,ex3(:),4,G2tensor(460),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(465),27,ex3(:),4,G2tensor(461),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(466),27,ex3(:),4,G2tensor(462),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(467),0,ex3(:),4,G2tensor(463),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(470),27,ex3(:),4,G2tensor(464),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(471),27,ex3(:),4,G2tensor(465),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(472),0,ex3(:),4,G2tensor(466),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(475),27,ex3(:),4,G2tensor(467),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(476),27,ex3(:),4,G2tensor(468),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(477),0,ex3(:),4,G2tensor(469),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(480),27,ex3(:),4,G2tensor(470),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hloop_AV_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(471),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(472),n2h1(300))
  call Hloop_AV_Q(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(473),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(94),ex4(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(474),n2h1(302))
  call Hloop_AV_Q(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(475),n2h1(303))
  call Hloop_AV_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(476),n2h1(304))
  call Hloop_AV_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(477),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(478),n2h1(306))
  call Hloop_AV_Q(ntryL,G1H2(483),ex4(:),G1H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(479),n2h1(307))
  call Hloop_QV_A(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(480),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(481),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(486),ex4(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(482),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(487),ex4(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(483),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(488),ex4(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(484),n2h1(312))
  call Hloop_QV_A(ntryL,G1H2(491),ex4(:),G1H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(485),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(486),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(487),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(494),ex4(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(488),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(489),n2h1(317))
  call Hloop_QV_A(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(490),n2h1(318))
  call Hloop_QV_A(ntryL,G1H2(495),ex4(:),G1H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(491),n2h1(319))
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(492),n2h1(320))
  call Hloop_QV_A(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(493),n2h1(321))
  call Hloop_QV_A(ntryL,G1H2(496),ex4(:),G1H1(1),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(494),n2h1(322))
  call Hloop_QV_A(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(495),n2h1(323))
  call Hloop_QV_A(ntryL,G1H2(186),ex4(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(496),n2h1(324))
  call Hloop_QV_A(ntryL,G1H2(499),ex4(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(497),n2h1(325))
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(498),n2h1(326))
  call Hloop_QV_A(ntryL,G1H2(197),ex4(:),G1H1(1),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nME,G2tensor(499),n2h1(327))
  call Hloop_QV_A(ntryL,G1H2(502),ex4(:),G1H1(1),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(500),n2h1(328))
  call Hloop_QV_A(ntryL,G1H2(207),ex3(:),G1H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(501),n2h1(329))
  call Hloop_QV_A(ntryL,G1H2(208),ex3(:),G1H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(502),n2h1(330))
  call Hloop_QV_A(ntryL,G1H2(505),ex3(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(503),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(506),ex3(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(504),n2h1(332))
  call Hloop_QV_A(ntryL,G1H2(507),ex3(:),G1H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(505),n2h1(333))
  call Hloop_QV_A(ntryL,G1H2(510),ex3(:),G1H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(506),n2h1(334))
  call Hloop_QV_A(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(507),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(220),ex3(:),G1H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(508),n2h1(336))
  call Hloop_QV_A(ntryL,G1H2(513),ex3(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(509),n2h1(337))
  call Hloop_QV_A(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(510),n2h1(338))
  call Hloop_QV_A(ntryL,G1H2(231),ex3(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nME,G2tensor(511),n2h1(339))
  call Hloop_QV_A(ntryL,G1H2(514),ex3(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(512),n2h1(340))
  call Hloop_AV_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(513),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(247),ex4(:),G1H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(514),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(515),ex4(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(515),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(516),ex4(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(516),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(517),ex4(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(517),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(520),ex4(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(518),n2h1(346))
  call Hloop_AV_Q(ntryL,G1H2(261),ex4(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(519),n2h1(347))
  call Hloop_AV_Q(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(520),n2h1(348))
  call Hloop_AV_Q(ntryL,G1H2(523),ex4(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(521),n2h1(349))
  call Hloop_AV_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(522),n2h1(350))
  call Hloop_AV_Q(ntryL,G1H2(274),ex4(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nME,G2tensor(523),n2h1(351))
  call Hloop_AV_Q(ntryL,G1H2(524),ex4(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(524),n2h1(352))
  call Hloop_AV_Q(ntryL,G1H2(288),ex3(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(525),n2h1(353))
  call Hloop_AV_Q(ntryL,G1H2(290),ex3(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(526),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H2(525),ex3(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(527),n2h1(355))
  call Hloop_AV_Q(ntryL,G1H2(526),ex3(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(528),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H2(527),ex3(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(529),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H2(530),ex3(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(530),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(304),ex3(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(531),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(532),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H2(533),ex3(:),G1H1(1),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(533),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H2(315),ex3(:),G1H1(1),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(534),n2h1(362))
  call Hloop_AV_Q(ntryL,G1H2(317),ex3(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nME,G2tensor(535),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H2(534),ex3(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(536),n2h1(364))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(331),23,ex4(:),8,G2tensor(537),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(333),0,ex4(:),8,G2tensor(538),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(539),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(16),23,ex4(:),G2tensor(540),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(22),0,ex4(:),G2tensor(541),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(536),23,ex4(:),G2tensor(542),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hloop_SQ_A(ntryL,G1H4(220),wf4(:,9),G1H1(1),ngH,m3h4x1(:,9),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(543),n2h1(367))
  call Hloop_SQ_A(ntryL,G1H4(216),wf4(:,9),G1H1(1),ngH,m3h4x1(:,10),heltab2x4(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(544),n2h1(368))
  call Hloop_SQ_A(ntryL,G1H4(1),wf4(:,9),G1H1(1),ngH,m3h4x1(:,11),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(545),n2h1(369))
  call Hloop_SQ_A(ntryL,G1H4(2),wf4(:,9),G1H1(1),ngX,m3h4x1(:,12),heltab2x4(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(546),n2h1(370))
  call Hloop_SQ_A(ntryL,G1H4(3),wf4(:,9),G1H1(1),ngX,m3h4x1(:,13),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(547),n2h1(371))
  call Hloop_SQ_A(ntryL,G1H4(11),wf4(:,9),G1H1(1),ngX,m3h4x1(:,14),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(548),n2h1(372))
  call Hloop_VQ_A(ntryL,G1H4(13),wf4(:,9),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(549),n2h1(373))
  call Hloop_VQ_A(ntryL,G1H4(12),wf4(:,9),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(550),n2h1(374))
  call Hloop_VQ_A(ntryL,G1H4(25),wf4(:,9),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(551),n2h1(375))
  call Hloop_ZQ_A(ntryL,G1H4(29),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,18),heltab2x4(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(552),n2h1(376))
  call Hloop_ZQ_A(ntryL,G1H4(233),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,19),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nME,G2tensor(553),n2h1(377))
  call Hloop_ZQ_A(ntryL,G1H4(236),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,20),heltab2x4(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(554),n2h1(378))
  call Hloop_SA_Q(ntryL,G1H4(238),wf4(:,4),G1H1(1),ngH,m3h4x1(:,21),heltab2x4(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(555),n2h1(379))
  call Hloop_SA_Q(ntryL,G1H4(243),wf4(:,4),G1H1(1),ngH,m3h4x1(:,22),heltab2x4(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(556),n2h1(380))
  call Hloop_SA_Q(ntryL,G1H4(75),wf4(:,4),G1H1(1),ngH,m3h4x1(:,23),heltab2x4(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(557),n2h1(381))
  call Hloop_SA_Q(ntryL,G1H4(79),wf4(:,4),G1H1(1),ngX,m3h4x1(:,24),heltab2x4(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(558),n2h1(382))
  call Hloop_SA_Q(ntryL,G1H4(76),wf4(:,4),G1H1(1),ngX,m3h4x1(:,25),heltab2x4(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(559),n2h1(383))
  call Hloop_SA_Q(ntryL,G1H4(91),wf4(:,4),G1H1(1),ngX,m3h4x1(:,26),heltab2x4(:,:,458))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(560),n2h1(384))
  call Hloop_VA_Q(ntryL,G1H4(129),wf4(:,4),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(561),n2h1(385))
  call Hloop_VA_Q(ntryL,G1H4(245),wf4(:,4),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,460))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(562),n2h1(386))
  call Hloop_VA_Q(ntryL,G1H4(248),wf4(:,4),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(563),n2h1(387))
  call Hloop_ZA_Q(ntryL,G1H4(250),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,30),heltab2x4(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(564),n2h1(388))
  call Hloop_ZA_Q(ntryL,G1H4(255),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nME,G2tensor(565),n2h1(389))
  call Hloop_ZA_Q(ntryL,G1H4(15),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,32),heltab2x4(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(566),n2h1(390))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(189),27,ex3(:),4,G2tensor(567),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(194),0,ex3(:),4,G2tensor(568),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(216),27,ex3(:),4,G2tensor(569),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(222),27,ex3(:),G2tensor(570),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(237),0,ex3(:),G2tensor(571),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(260),27,ex3(:),G2tensor(572),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hloop_QV_A(ntryL,G1H2(264),ex3(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(573),n2h1(393))
  call Hloop_QV_A(ntryL,G1H2(271),ex3(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(574),n2h1(394))
  call Hloop_QV_A(ntryL,G1H2(537),ex3(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(575),n2h1(395))
  call Hloop_AV_Q(ntryL,G1H2(292),ex3(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(576),n2h1(396))
  call Hloop_AV_Q(ntryL,G1H2(538),ex3(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(577),n2h1(397))
  call Hloop_AV_Q(ntryL,G1H2(541),ex3(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(578),n2h1(398))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(303),23,ex4(:),G2tensor(579),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(542),0,ex4(:),G2tensor(580),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(545),23,ex4(:),G2tensor(581),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(307),23,ex4(:),8,G2tensor(582),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(546),0,ex4(:),8,G2tensor(583),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(549),23,ex4(:),8,G2tensor(584),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hloop_AV_Q(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(585),n2h1(401))
  call Hloop_AV_Q(ntryL,G1H2(550),ex4(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(586),n2h1(402))
  call Hloop_AV_Q(ntryL,G1H2(553),ex4(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(587),n2h1(403))
  call Hloop_QV_A(ntryL,G1H2(323),ex4(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(588),n2h1(404))
  call Hloop_QV_A(ntryL,G1H2(554),ex4(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(589),n2h1(405))
  call Hloop_QV_A(ntryL,G1H2(557),ex4(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(590),n2h1(406))
  call Hloop_QV_A(ntryL,G1H2(335),ex4(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(591),n2h1(407))
  call Hloop_QV_A(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(592),n2h1(408))
  call Hloop_QV_A(ntryL,G1H2(559),ex4(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(593),n2h1(409))
  call Hloop_AV_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(594),n2h1(410))
  call Hloop_AV_Q(ntryL,G1H2(560),ex4(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(595),n2h1(411))
  call Hloop_AV_Q(ntryL,G1H2(563),ex4(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(596),n2h1(412))
  call ol_merge_tensors(G2tensor(204),[G2tensor(203),G2tensor(30),G2tensor(27),G2tensor(14),G2tensor(13),G1tensor(6)])
  call ol_merge_tensors(G2tensor(202),[G2tensor(201),G2tensor(42),G2tensor(39),G2tensor(16),G2tensor(15),G1tensor(18)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(195),G2tensor(48),G2tensor(45),G2tensor(36),G2tensor(33),G2tensor(20),G2tensor(19) &
    ,G2tensor(18),G2tensor(17),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(193),G2tensor(60),G2tensor(57),G2tensor(54),G2tensor(51),G2tensor(24),G2tensor(23) &
    ,G2tensor(22),G2tensor(21),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(173),G2tensor(29),G2tensor(26),G1tensor(2)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(288),G2tensor(35),G2tensor(32),G1tensor(7),G1tensor(1),G1tensor(8)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(177),G2tensor(41),G2tensor(38),G1tensor(14)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(333),G2tensor(192),G2tensor(191),G2tensor(47),G2tensor(44),G1tensor(20) &
    ,G1tensor(15)])
  call ol_merge_tensors(G2tensor(375),[G2tensor(363),G2tensor(53),G2tensor(50),G1tensor(19),G1tensor(13),G1tensor(26)])
  call ol_merge_tensors(G2tensor(405),[G2tensor(393),G2tensor(190),G2tensor(189),G2tensor(59),G2tensor(56),G1tensor(32) &
    ,G1tensor(3)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(66),G1tensor(38)])
  call ol_merge_tensors(G2tensor(555),[G2tensor(67),G1tensor(42)])
  call ol_merge_tensors(G2tensor(273),[G2tensor(267),G2tensor(70),G1tensor(44)])
  call ol_merge_tensors(G2tensor(564),[G2tensor(558),G2tensor(71),G1tensor(48)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(74),G1tensor(50)])
  call ol_merge_tensors(G2tensor(561),[G2tensor(75),G1tensor(54)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(78),G1tensor(56)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(79),G1tensor(96),G1tensor(60)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(82),G1tensor(62)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(83),G1tensor(102),G1tensor(66)])
  call ol_merge_tensors(G2tensor(294),[G2tensor(87),G1tensor(68)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(88),G1tensor(108),G1tensor(72)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(92),G1tensor(74)])
  call ol_merge_tensors(G2tensor(543),[G2tensor(93),G1tensor(78)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(312),G2tensor(96),G1tensor(80)])
  call ol_merge_tensors(G2tensor(552),[G2tensor(546),G2tensor(97),G1tensor(84)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(100),G1tensor(86)])
  call ol_merge_tensors(G2tensor(549),[G2tensor(101),G1tensor(90)])
  call ol_merge_tensors(G2tensor(321),[G2tensor(104),G1tensor(92),G1tensor(75)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(108),G1tensor(98),G1tensor(81)])
  call ol_merge_tensors(G2tensor(339),[G2tensor(113),G1tensor(104),G1tensor(87)])
  call ol_merge_tensors(G2tensor(351),[G2tensor(118),G1tensor(110)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(119),G1tensor(132),G1tensor(114)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(122),G1tensor(116)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(123),G1tensor(138),G1tensor(120)])
  call ol_merge_tensors(G2tensor(369),[G2tensor(127),G1tensor(122)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(128),G1tensor(144),G1tensor(126)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(132),G1tensor(128),G1tensor(39)])
  call ol_merge_tensors(G2tensor(387),[G2tensor(136),G1tensor(134),G1tensor(45)])
  call ol_merge_tensors(G2tensor(399),[G2tensor(141),G1tensor(140),G1tensor(51)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(411),G2tensor(176),G2tensor(174),G1tensor(4)])
  call ol_merge_tensors(G2tensor(540),[G2tensor(537),G2tensor(258),G2tensor(255),G2tensor(252),G2tensor(249),G2tensor(2) &
    ,G2tensor(25),G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(423),[G2tensor(417),G2tensor(182),G2tensor(181),G1tensor(9)])
  call ol_merge_tensors(G2tensor(582),[G2tensor(579),G2tensor(456),G2tensor(450),G2tensor(426),G2tensor(420),G2tensor(200) &
    ,G2tensor(199),G1tensor(28),G1tensor(10)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(291),G2tensor(31),G2tensor(1),G1tensor(11)])
  call ol_merge_tensors(G2tensor(432),[G2tensor(429),G2tensor(180),G2tensor(178),G1tensor(16)])
  call ol_merge_tensors(G2tensor(441),[G2tensor(435),G2tensor(184),G2tensor(183),G1tensor(21)])
  call ol_merge_tensors(G2tensor(570),[G2tensor(567),G2tensor(468),G2tensor(462),G2tensor(444),G2tensor(438),G2tensor(198) &
    ,G2tensor(197),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(348),[G2tensor(336),G2tensor(3),G2tensor(4),G1tensor(23)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(447),G2tensor(186),G2tensor(185),G1tensor(27)])
  call ol_merge_tensors(G2tensor(378),[G2tensor(366),G2tensor(6),G2tensor(37),G1tensor(29)])
  call ol_merge_tensors(G2tensor(465),[G2tensor(459),G2tensor(188),G2tensor(187),G1tensor(33)])
  call ol_merge_tensors(G2tensor(408),[G2tensor(396),G2tensor(43),G2tensor(5),G1tensor(35)])
  call ol_merge_tensors(G2tensor(471),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(264),G1tensor(89),G1tensor(83),G1tensor(77),G1tensor(53),G1tensor(47) &
    ,G1tensor(41)])
  call ol_merge_tensors(G2tensor(474),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(477),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(480),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(516),[G2tensor(483),G1tensor(124),G1tensor(118),G1tensor(112),G1tensor(70),G1tensor(64) &
    ,G1tensor(58)])
  call ol_merge_tensors(G2tensor(279),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(486),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(285),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(489),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(297),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(492),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(495),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(498),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(501),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(528),[G2tensor(504),G1tensor(142),G1tensor(136),G1tensor(130),G1tensor(106),G1tensor(100) &
    ,G1tensor(94)])
  call ol_merge_tensors(G2tensor(324),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(507),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(330),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(510),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(342),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(513),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(354),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(519),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(360),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(522),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(372),[G1tensor(125)])
  call ol_merge_tensors(G2tensor(525),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(384),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(531),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(390),[G1tensor(137)])
  call ol_merge_tensors(G2tensor(534),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(402),[G1tensor(143)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(209)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(229),G2tensor(221),G2tensor(220),G2tensor(213),G2tensor(210)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(214)])
  call ol_merge_tensors(G2tensor(226),[G2tensor(225),G2tensor(224),G2tensor(223),G2tensor(218),G2tensor(215)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(227)])
  call ol_merge_tensors(G2tensor(232),[G2tensor(231)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(233)])
  call ol_merge_tensors(G2tensor(238),[G2tensor(237)])
  call ol_merge_tensors(G2tensor(244),[G2tensor(243),G2tensor(242),G2tensor(241),G2tensor(240),G2tensor(239)])
  call ol_merge_tensors(G2tensor(576),[G2tensor(573)])
  call ol_merge_tensors(G2tensor(588),[G2tensor(585)])
  call ol_merge_tensors(G2tensor(594),[G2tensor(591)])
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(1),mass4set(:,1),  & 
G1tensor(25),G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49))
  call G_TensorShift(G1tensor(31),10)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(2),mass4set(:,1),  & 
G1tensor(55),G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79))
  call G_TensorShift(G1tensor(61),9)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(3),mass4set(:,7),  & 
G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109))
  call G_TensorShift(G1tensor(91),12)
  call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(4),mass4set(:,7),  & 
G1tensor(115),G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139))
  call G_TensorShift(G1tensor(121),12)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(26),mass4set(:,1),  & 
G1tensor(6),G1tensor(18),G1tensor(24),G1tensor(12),G1tensor(36))
  call G_TensorShift(G1tensor(18),2)
  call Hotf_4pt_reduction_last(G2tensor(300),RedSet_4(28),mass4set(:,7),  & 
G1tensor(30),G1tensor(2),G1tensor(7),G1tensor(1),G1tensor(8))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(27),mass4set(:,1),  & 
G1tensor(14),G1tensor(20),G1tensor(15),G1tensor(19),G1tensor(13))
  call G_TensorShift(G1tensor(20),1)
  call Hotf_4pt_reduction_last(G2tensor(345),RedSet_4(13),mass4set(:,7),  & 
G1tensor(26),G1tensor(32),G1tensor(3),G1tensor(38),G1tensor(42))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_4pt_reduction_last(G2tensor(375),RedSet_4(29),mass4set(:,7),  & 
G1tensor(44),G1tensor(48),G1tensor(50),G1tensor(54),G1tensor(56))
  call G_TensorShift(G1tensor(48),4)
  call Hotf_4pt_reduction_last(G2tensor(405),RedSet_4(5),mass4set(:,7),  & 
G1tensor(96),G1tensor(60),G1tensor(62),G1tensor(102),G1tensor(66))
  call G_TensorShift(G1tensor(60),8)
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(26),mass4set(:,2),  & 
G1tensor(68),G1tensor(108),G1tensor(72),G1tensor(74),G1tensor(78))
  call G_TensorShift(G1tensor(108),2)
  call Hotf_4pt_reduction_last(G2tensor(555),RedSet_4(1),mass4set(:,2),  & 
G1tensor(80),G1tensor(84),G1tensor(86),G1tensor(90),G1tensor(92))
  call G_TensorShift(G1tensor(84),10)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(26),mass4set(:,3),  & 
G1tensor(75),G1tensor(98),G1tensor(81),G1tensor(104),G1tensor(87))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_4pt_reduction_last(G2tensor(564),RedSet_4(1),mass4set(:,3),  & 
G1tensor(110),G1tensor(132),G1tensor(114),G1tensor(116),G1tensor(138))
  call G_TensorShift(G1tensor(132),10)
  call Hotf_4pt_reduction_last(G2tensor(270),RedSet_4(26),mass4set(:,4),  & 
G1tensor(120),G1tensor(122),G1tensor(144),G1tensor(126),G1tensor(128))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_4pt_reduction_last(G2tensor(561),RedSet_4(1),mass4set(:,4),  & 
G1tensor(39),G1tensor(134),G1tensor(45),G1tensor(140),G1tensor(51))
  call G_TensorShift(G1tensor(134),10)
  call Hotf_4pt_reduction_last(G2tensor(276),RedSet_4(28),mass4set(:,5),  & 
G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(9),G1tensor(28))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(3),mass4set(:,5),  & 
G1tensor(10),G1tensor(11),G1tensor(16),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(11),12)
  call Hotf_4pt_reduction_last(G2tensor(282),RedSet_4(28),mass4set(:,6),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(29),G1tensor(33))
  call G_TensorShift(G1tensor(23),4)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(3),mass4set(:,6),  & 
G1tensor(35),G1tensor(40),G1tensor(89),G1tensor(83),G1tensor(77))
  call G_TensorShift(G1tensor(40),12)
  call Hotf_4pt_reduction_last(G2tensor(294),RedSet_4(28),mass4set(:,8),  & 
G1tensor(53),G1tensor(47),G1tensor(41),G1tensor(46),G1tensor(52))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(3),mass4set(:,8),  & 
G1tensor(57),G1tensor(124),G1tensor(118),G1tensor(112),G1tensor(70))
  call G_TensorShift(G1tensor(124),12)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(27),mass4set(:,2),  & 
G1tensor(64),G1tensor(58),G1tensor(59),G1tensor(63),G1tensor(65))
  call G_TensorShift(G1tensor(58),1)
  call Hotf_4pt_reduction_last(G2tensor(543),RedSet_4(2),mass4set(:,2),  & 
G1tensor(69),G1tensor(71),G1tensor(76),G1tensor(82),G1tensor(88))
  call G_TensorShift(G1tensor(71),9)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(27),mass4set(:,3),  & 
G1tensor(93),G1tensor(142),G1tensor(136),G1tensor(130),G1tensor(106))
  call G_TensorShift(G1tensor(142),1)
  call Hotf_4pt_reduction_last(G2tensor(552),RedSet_4(2),mass4set(:,3),  & 
G1tensor(100),G1tensor(94),G1tensor(95),G1tensor(99),G1tensor(101))
  call G_TensorShift(G1tensor(94),9)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(27),mass4set(:,4),  & 
G1tensor(105),G1tensor(107),G1tensor(111),G1tensor(113),G1tensor(117))
  call G_TensorShift(G1tensor(107),1)
  call Hotf_4pt_reduction_last(G2tensor(549),RedSet_4(2),mass4set(:,4),  & 
G1tensor(119),G1tensor(123),G1tensor(125),G1tensor(129),G1tensor(131))
  call G_TensorShift(G1tensor(123),9)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(13),mass4set(:,5),  & 
G1tensor(135),G1tensor(137),G1tensor(141),G1tensor(143),G1tensor(145))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(13),mass4set(:,6),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(339),RedSet_4(13),mass4set(:,8),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(351),RedSet_4(29),mass4set(:,5),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(4),mass4set(:,5),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),12)
  call Hotf_4pt_reduction_last(G2tensor(357),RedSet_4(29),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),4)
  call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(4),mass4set(:,6),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),12)
  call Hotf_4pt_reduction_last(G2tensor(369),RedSet_4(29),mass4set(:,8),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),4)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(4),mass4set(:,8),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),12)
  call Hotf_4pt_reduction_last(G2tensor(381),RedSet_4(5),mass4set(:,5),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),8)
  call Hotf_4pt_reduction_last(G2tensor(387),RedSet_4(5),mass4set(:,6),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),8)
  call Hotf_4pt_reduction_last(G2tensor(399),RedSet_4(5),mass4set(:,8),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(414),RedSet_4(6),mass4set(:,7),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(540),RedSet_4(7),mass4set(:,10),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(423),RedSet_4(9),mass4set(:,12),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(582),RedSet_4(10),mass4set(:,10),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(11),mass4set(:,7),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),8)
  call Hotf_4pt_reduction_last(G2tensor(432),RedSet_4(14),mass4set(:,7),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),8)
  call Hotf_4pt_reduction_last(G2tensor(441),RedSet_4(16),mass4set(:,12),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(570),RedSet_4(17),mass4set(:,10),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),4)
  call Hotf_4pt_reduction_last(G2tensor(348),RedSet_4(18),mass4set(:,7),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_4pt_reduction_last(G2tensor(453),RedSet_4(20),mass4set(:,12),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(378),RedSet_4(21),mass4set(:,7),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(465),RedSet_4(23),mass4set(:,12),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),4)
  call Hotf_4pt_reduction_last(G2tensor(408),RedSet_4(24),mass4set(:,7),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),4)
  call Hotf_4pt_reduction_last(G2tensor(471),RedSet_4(6),mass4set(:,5),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),8)
  call Hotf_4pt_reduction_last(G2tensor(309),RedSet_4(7),mass4set(:,9),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_4pt_reduction_last(G2tensor(474),RedSet_4(6),mass4set(:,6),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),8)
  call Hotf_4pt_reduction_last(G2tensor(477),RedSet_4(6),mass4set(:,8),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),8)
  call Hotf_4pt_reduction_last(G2tensor(480),RedSet_4(9),mass4set(:,13),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),8)
  call Hotf_4pt_reduction_last(G2tensor(516),RedSet_4(10),mass4set(:,9),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(279),RedSet_4(11),mass4set(:,5),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),8)
  call Hotf_4pt_reduction_last(G2tensor(486),RedSet_4(9),mass4set(:,14),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(285),RedSet_4(11),mass4set(:,6),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(489),RedSet_4(9),mass4set(:,15),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),8)
  call Hotf_4pt_reduction_last(G2tensor(297),RedSet_4(11),mass4set(:,8),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),8)
  call Hotf_4pt_reduction_last(G2tensor(492),RedSet_4(14),mass4set(:,5),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(495),RedSet_4(14),mass4set(:,6),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(498),RedSet_4(14),mass4set(:,8),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(501),RedSet_4(16),mass4set(:,13),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),4)
  call Hotf_4pt_reduction_last(G2tensor(528),RedSet_4(17),mass4set(:,9),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),4)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(18),mass4set(:,5),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),4)
  call Hotf_4pt_reduction_last(G2tensor(507),RedSet_4(16),mass4set(:,14),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),4)
  call Hotf_4pt_reduction_last(G2tensor(330),RedSet_4(18),mass4set(:,6),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),4)
  call Hotf_4pt_reduction_last(G2tensor(510),RedSet_4(16),mass4set(:,15),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),4)
  call Hotf_4pt_reduction_last(G2tensor(342),RedSet_4(18),mass4set(:,8),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),4)
  call Hotf_4pt_reduction_last(G2tensor(513),RedSet_4(20),mass4set(:,13),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),8)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(21),mass4set(:,5),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),8)
  call Hotf_4pt_reduction_last(G2tensor(519),RedSet_4(20),mass4set(:,14),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),8)
  call Hotf_4pt_reduction_last(G2tensor(360),RedSet_4(21),mass4set(:,6),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),8)
  call Hotf_4pt_reduction_last(G2tensor(522),RedSet_4(20),mass4set(:,15),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),8)
  call Hotf_4pt_reduction_last(G2tensor(372),RedSet_4(21),mass4set(:,8),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),8)
  call Hotf_4pt_reduction_last(G2tensor(525),RedSet_4(23),mass4set(:,13),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),4)
  call Hotf_4pt_reduction_last(G2tensor(384),RedSet_4(24),mass4set(:,5),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(531),RedSet_4(23),mass4set(:,14),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),4)
  call Hotf_4pt_reduction_last(G2tensor(390),RedSet_4(24),mass4set(:,6),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),4)
  call Hotf_4pt_reduction_last(G2tensor(534),RedSet_4(23),mass4set(:,15),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_4pt_reduction_last(G2tensor(402),RedSet_4(24),mass4set(:,8),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),4)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(10),mass4set(:,9),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435),G0tensor(1))
  call G_TensorShift(G1tensor(432),8)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(10),mass4set(:,10),  & 
G1tensor(431),G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G0tensor(2))
  call G_TensorShift(G1tensor(436),8)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(17),mass4set(:,9),  & 
G1tensor(431),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G0tensor(3))
  call G_TensorShift(G1tensor(440),4)
  call Hotf_4pt_reduction_last(G2tensor(226),RedSet_4(17),mass4set(:,10),  & 
G1tensor(431),G1tensor(444),G1tensor(445),G1tensor(446),G1tensor(447),G0tensor(4))
  call G_TensorShift(G1tensor(444),4)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(17),mass4set(:,11),  & 
G1tensor(431),G1tensor(448),G1tensor(449),G1tensor(450),G1tensor(451),G0tensor(5))
  call G_TensorShift(G1tensor(448),4)
  call Hotf_4pt_reduction_last(G2tensor(232),RedSet_4(10),mass4set(:,11),  & 
G1tensor(431),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G0tensor(6))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(7),mass4set(:,9),  & 
G1tensor(431),G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G0tensor(7))
  call G_TensorShift(G1tensor(456),8)
  call Hotf_4pt_reduction_last(G2tensor(238),RedSet_4(7),mass4set(:,11),  & 
G1tensor(431),G1tensor(460),G1tensor(461),G1tensor(462),G1tensor(463),G0tensor(8))
  call G_TensorShift(G1tensor(460),8)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(7),mass4set(:,10),  & 
G1tensor(431),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G0tensor(9))
  call G_TensorShift(G1tensor(464),8)
  call Hotf_4pt_reduction_last(G2tensor(576),RedSet_4(17),mass4set(:,11),  & 
G1tensor(431),G1tensor(468),G1tensor(469),G1tensor(470),G1tensor(471))
  call G_TensorShift(G1tensor(468),4)
  call Hotf_4pt_reduction_last(G2tensor(588),RedSet_4(10),mass4set(:,11),  & 
G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475),G1tensor(476))
  call G_TensorShift(G1tensor(473),8)
  call Hotf_4pt_reduction_last(G2tensor(594),RedSet_4(7),mass4set(:,11),  & 
G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480),G1tensor(481))
  call G_TensorShift(G1tensor(478),8)
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(1),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(2),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(85),RedSet_4(3),mass4set(:,7),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(115),RedSet_4(4),mass4set(:,7),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(26),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(28),mass4set(:,7),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(27),mass4set(:,1),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,7),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(29),mass4set(:,7),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(5),mass4set(:,7),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(26),mass4set(:,2),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(1),mass4set(:,2),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(26),mass4set(:,3),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(1),mass4set(:,3),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(26),mass4set(:,4),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(1),mass4set(:,4),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(28),mass4set(:,5),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(3),mass4set(:,5),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(28),mass4set(:,6),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(3),mass4set(:,6),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(28),mass4set(:,8),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(3),mass4set(:,8),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(27),mass4set(:,2),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(2),mass4set(:,2),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(27),mass4set(:,3),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(100),RedSet_4(2),mass4set(:,3),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(105),RedSet_4(27),mass4set(:,4),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(119),RedSet_4(2),mass4set(:,4),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(13),mass4set(:,5),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(13),mass4set(:,6),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(13),mass4set(:,8),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(29),mass4set(:,5),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(4),mass4set(:,5),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(29),mass4set(:,6),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(4),mass4set(:,6),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(29),mass4set(:,8),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(4),mass4set(:,8),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(5),mass4set(:,5),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(5),mass4set(:,6),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(5),mass4set(:,8),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(6),mass4set(:,7),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(7),mass4set(:,10),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(9),mass4set(:,12),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(10),mass4set(:,10),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(11),mass4set(:,7),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(14),mass4set(:,7),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(16),mass4set(:,12),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(17),mass4set(:,10),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(18),mass4set(:,7),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(20),mass4set(:,12),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(21),mass4set(:,7),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(23),mass4set(:,12),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(24),mass4set(:,7),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(6),mass4set(:,5),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(7),mass4set(:,9),  & 
G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(6),mass4set(:,6),  & 
G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(6),mass4set(:,8),  & 
G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(9),mass4set(:,13),  & 
G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(10),mass4set(:,9),  & 
G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(11),mass4set(:,5),  & 
G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(9),mass4set(:,14),  & 
G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(11),mass4set(:,6),  & 
G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(9),mass4set(:,15),  & 
G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(11),mass4set(:,8),  & 
G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(14),mass4set(:,5),  & 
G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(14),mass4set(:,6),  & 
G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(14),mass4set(:,8),  & 
G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(16),mass4set(:,13),  & 
G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(17),mass4set(:,9),  & 
G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(18),mass4set(:,5),  & 
G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(16),mass4set(:,14),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(18),mass4set(:,6),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(16),mass4set(:,15),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(18),mass4set(:,8),  & 
G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(20),mass4set(:,13),  & 
G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(21),mass4set(:,5),  & 
G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(20),mass4set(:,14),  & 
G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(21),mass4set(:,6),  & 
G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(20),mass4set(:,15),  & 
G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(21),mass4set(:,8),  & 
G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(23),mass4set(:,13),  & 
G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(24),mass4set(:,5),  & 
G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(23),mass4set(:,14),  & 
G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(24),mass4set(:,6),  & 
G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(23),mass4set(:,15),  & 
G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(24),mass4set(:,8),  & 
G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(17),mass4set(:,11),  & 
G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444))
  call Hotf_4pt_reduction_last(G1tensor(472),RedSet_4(10),mass4set(:,11),  & 
G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449))
  call Hotf_4pt_reduction_last(G1tensor(477),RedSet_4(7),mass4set(:,11),  & 
G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(295)])
  call ol_merge_tensors(T0sum(59),[G0tensor(300)])
  call ol_merge_tensors(T0sum(60),[G0tensor(305)])
  call ol_merge_tensors(T0sum(61),[G0tensor(310)])
  call ol_merge_tensors(T0sum(62),[G0tensor(315)])
  call ol_merge_tensors(T0sum(63),[G0tensor(320)])
  call ol_merge_tensors(T0sum(64),[G0tensor(325)])
  call ol_merge_tensors(T0sum(65),[G0tensor(330)])
  call ol_merge_tensors(T0sum(66),[G0tensor(335)])
  call ol_merge_tensors(T0sum(67),[G0tensor(340)])
  call ol_merge_tensors(T0sum(68),[G0tensor(345)])
  call ol_merge_tensors(T0sum(69),[G0tensor(350)])
  call ol_merge_tensors(T0sum(70),[G0tensor(355)])
  call ol_merge_tensors(T0sum(71),[G0tensor(360)])
  call ol_merge_tensors(T0sum(72),[G0tensor(365)])
  call ol_merge_tensors(T0sum(73),[G0tensor(370)])
  call ol_merge_tensors(T0sum(74),[G0tensor(375)])
  call ol_merge_tensors(T0sum(75),[G0tensor(380)])
  call ol_merge_tensors(T0sum(76),[G0tensor(385)])
  call ol_merge_tensors(T0sum(77),[G0tensor(390)])
  call ol_merge_tensors(T0sum(78),[G0tensor(395)])
  call ol_merge_tensors(T0sum(79),[G0tensor(400)])
  call ol_merge_tensors(T0sum(80),[G0tensor(405)])
  call ol_merge_tensors(T0sum(81),[G0tensor(410)])
  call ol_merge_tensors(T0sum(82),[G0tensor(415)])
  call ol_merge_tensors(T0sum(83),[G0tensor(420)])
  call ol_merge_tensors(T0sum(84),[G0tensor(425)])
  call ol_merge_tensors(T0sum(85),[G0tensor(430)])
  call ol_merge_tensors(T0sum(86),[G0tensor(435)])
  call ol_merge_tensors(T0sum(87),[G0tensor(1)])
  call ol_merge_tensors(T0sum(88),[G0tensor(2)])
  call ol_merge_tensors(T0sum(89),[G0tensor(3)])
  call ol_merge_tensors(T0sum(90),[G0tensor(4)])
  call ol_merge_tensors(T0sum(91),[G0tensor(5)])
  call ol_merge_tensors(T0sum(92),[G0tensor(6)])
  call ol_merge_tensors(T0sum(93),[G0tensor(7)])
  call ol_merge_tensors(T0sum(94),[G0tensor(8)])
  call ol_merge_tensors(T0sum(95),[G0tensor(9)])
  call ol_merge_tensors(T0sum(96),[G0tensor(440)])
  call ol_merge_tensors(T0sum(97),[G0tensor(445)])
  call ol_merge_tensors(T0sum(98),[G0tensor(450)])
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(10),m4h2x4x4(:,1),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(2),m4h2x4x4(:,2),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(8),m4h2x4x4(:,3),heltab3x32(:,:,19))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(20),m4h2x4x4(:,4),heltab3x32(:,:,20))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(18),m4h4x2x4(:,1),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(3),m4h4x2x4(:,2),heltab3x32(:,:,22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(4),m4h4x2x4(:,3),heltab3x32(:,:,23))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(16),m4h4x2x4(:,4),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(15),m4h2x4x4(:,5),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,36),G0H4(14),m4h2x4x4(:,6),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(13),m4h2x4x4(:,7),heltab3x32(:,:,27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VVS_S(ntryL,G0H32(1),ex5(:),wf4(:,37),G0H4(5),m4h2x4x4(:,8),heltab3x32(:,:,28))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(6),m4h4x2x4(:,5),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,36),ex5(:),G0H4(23),m4h4x2x4(:,6),heltab3x32(:,:,30))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(24),m4h4x2x4(:,7),heltab3x32(:,:,31))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SSV_V(ntryL,G0H32(1),wf4(:,37),ex5(:),G0H4(36),m4h4x2x4(:,8),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(35),m4h2x4x4(:,9),heltab3x32(:,:,33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(34),m4h2x4x4(:,10),heltab3x32(:,:,34))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(33),m4h2x4x4(:,11),heltab3x32(:,:,35))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(25),m4h2x4x4(:,12),heltab3x32(:,:,36))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(26),m4h2x4x4(:,13),heltab3x32(:,:,37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(41),m4h2x4x4(:,14),heltab3x32(:,:,38))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(32),m4h2x4x4(:,15),heltab3x32(:,:,39))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(30),m4h2x4x4(:,16),heltab3x32(:,:,40))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(22),m4h2x4x4(:,17),heltab3x32(:,:,41))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(28),m4h2x4x4(:,18),heltab3x32(:,:,42))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(40),m4h2x4x4(:,19),heltab3x32(:,:,43))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(38),m4h2x4x4(:,20),heltab3x32(:,:,44))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(11),m4h2x4x4(:,21),heltab3x32(:,:,45))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(9),m4h2x4x4(:,22),heltab3x32(:,:,46))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(1),m4h2x4x4(:,23),heltab3x32(:,:,47))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(7),m4h2x4x4(:,24),heltab3x32(:,:,48))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,645),heltab2x32(:,:,693))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,646),heltab2x32(:,:,694))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,647),heltab2x32(:,:,695))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,648),heltab2x32(:,:,696))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,649),heltab2x32(:,:,697))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,650),heltab2x32(:,:,698))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,651),heltab2x32(:,:,699))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,652),heltab2x32(:,:,700))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,653),heltab2x32(:,:,701))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,654),heltab2x32(:,:,702))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,655),heltab2x32(:,:,703))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,656),heltab2x32(:,:,704))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,657),heltab2x32(:,:,705))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,658),heltab2x32(:,:,706))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,659),heltab2x32(:,:,707))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,660),heltab2x32(:,:,708))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,661),heltab2x32(:,:,709))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,662),heltab2x32(:,:,710))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,663),heltab2x32(:,:,711))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,664),heltab2x32(:,:,712))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,665),heltab2x32(:,:,713))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,666),heltab2x32(:,:,714))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,667),heltab2x32(:,:,715))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,668),heltab2x32(:,:,716))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,669),heltab2x32(:,:,717))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,670),heltab2x32(:,:,718))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,671),heltab2x32(:,:,719))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,672),heltab2x32(:,:,720))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,673),heltab2x32(:,:,721))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,674),heltab2x32(:,:,722))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,675),heltab2x32(:,:,723))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,676),heltab2x32(:,:,724))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(11),m4h2x2x8(:,17),heltab3x32(:,:,49))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,18),heltab3x32(:,:,50))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,19),heltab3x32(:,:,51))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,20),heltab3x32(:,:,52))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,21),heltab3x32(:,:,53))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(15),m4h2x2x8(:,22),heltab3x32(:,:,54))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(34),m4h2x2x8(:,23),heltab3x32(:,:,55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(35),m4h2x2x8(:,24),heltab3x32(:,:,56))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(36),m4h2x2x8(:,25),heltab3x32(:,:,57))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(13),m4h2x2x8(:,26),heltab3x32(:,:,58))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(14),m4h2x2x8(:,27),heltab3x32(:,:,59))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,28),heltab3x32(:,:,60))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(33),m4h2x2x8(:,29),heltab3x32(:,:,61))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(37),m4h2x2x8(:,30),heltab3x32(:,:,62))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(38),m4h2x2x8(:,31),heltab3x32(:,:,63))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(39),m4h2x2x8(:,32),heltab3x32(:,:,64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(40),m4h2x2x8(:,33),heltab3x32(:,:,65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(41),m4h2x2x8(:,34),heltab3x32(:,:,66))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(17),m4h2x2x8(:,35),heltab3x32(:,:,67))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(18),m4h2x2x8(:,36),heltab3x32(:,:,68))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(19),m4h2x2x8(:,37),heltab3x32(:,:,69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(20),m4h2x2x8(:,38),heltab3x32(:,:,70))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(21),m4h2x2x8(:,39),heltab3x32(:,:,71))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(22),m4h2x2x8(:,40),heltab3x32(:,:,72))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(23),m4h2x2x8(:,41),heltab3x32(:,:,73))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(24),m4h2x2x8(:,42),heltab3x32(:,:,74))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(25),m4h2x2x8(:,43),heltab3x32(:,:,75))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(26),m4h2x2x8(:,44),heltab3x32(:,:,76))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(125),m3h2x16(:,677),heltab2x32(:,:,725))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(127),m3h2x16(:,678),heltab2x32(:,:,726))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(129),m3h2x16(:,679),heltab2x32(:,:,727))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(131),m3h2x16(:,680),heltab2x32(:,:,728))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(137),m3h2x16(:,681),heltab2x32(:,:,729))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,682),heltab2x32(:,:,730))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(141),m3h2x16(:,683),heltab2x32(:,:,731))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,684),heltab2x32(:,:,732))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,685),heltab2x32(:,:,733))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(180),m3h2x16(:,686),heltab2x32(:,:,734))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,687),heltab2x32(:,:,735))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,688),heltab2x32(:,:,736))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(153),m3h2x16(:,689),heltab2x32(:,:,737))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(155),m3h2x16(:,690),heltab2x32(:,:,738))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(157),m3h2x16(:,691),heltab2x32(:,:,739))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(159),m3h2x16(:,692),heltab2x32(:,:,740))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,693),heltab2x32(:,:,741))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(199),m3h2x16(:,694),heltab2x32(:,:,742))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,695),heltab2x32(:,:,743))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(222),m3h2x16(:,696),heltab2x32(:,:,744))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,697),heltab2x32(:,:,745))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(226),m3h2x16(:,698),heltab2x32(:,:,746))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,699),heltab2x32(:,:,747))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,700),heltab2x32(:,:,748))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,701),heltab2x32(:,:,749))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,702),heltab2x32(:,:,750))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,703),heltab2x32(:,:,751))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,704),heltab2x32(:,:,752))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,705),heltab2x32(:,:,753))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,706),heltab2x32(:,:,754))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,707),heltab2x32(:,:,755))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,708),heltab2x32(:,:,756))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(27),m4h2x2x8(:,45),heltab3x32(:,:,77))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(28),m4h2x2x8(:,46),heltab3x32(:,:,78))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(29),m4h2x2x8(:,47),heltab3x32(:,:,79))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(30),m4h2x2x8(:,48),heltab3x32(:,:,80))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(31),m4h2x2x8(:,49),heltab3x32(:,:,81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(32),m4h2x2x8(:,50),heltab3x32(:,:,82))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,51),heltab3x32(:,:,83))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(8),m4h2x2x8(:,52),heltab3x32(:,:,84))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(1),m4h2x2x8(:,53),heltab3x32(:,:,85))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(2),m4h2x2x8(:,54),heltab3x32(:,:,86))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,55),heltab3x32(:,:,87))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(9),m4h2x2x8(:,56),heltab3x32(:,:,88))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,57),heltab3x32(:,:,89))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(42),m4h2x2x8(:,58),heltab3x32(:,:,90))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(43),m4h2x2x8(:,59),heltab3x32(:,:,91))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(44),m4h2x2x8(:,60),heltab3x32(:,:,92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(45),m4h2x2x8(:,61),heltab3x32(:,:,93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(46),m4h2x2x8(:,62),heltab3x32(:,:,94))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(47),m4h2x2x8(:,63),heltab3x32(:,:,95))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(48),m4h2x2x8(:,64),heltab3x32(:,:,96))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(49),m4h2x2x8(:,65),heltab3x32(:,:,97))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(50),m4h2x2x8(:,66),heltab3x32(:,:,98))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(51),m4h2x2x8(:,67),heltab3x32(:,:,99))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(52),m4h2x2x8(:,68),heltab3x32(:,:,100))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(53),m4h2x2x8(:,69),heltab3x32(:,:,101))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(54),m4h2x2x8(:,70),heltab3x32(:,:,102))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(55),m4h2x2x8(:,71),heltab3x32(:,:,103))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(56),m4h2x2x8(:,72),heltab3x32(:,:,104))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,709),heltab2x32(:,:,757))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,710),heltab2x32(:,:,758))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,711),heltab2x32(:,:,759))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,712),heltab2x32(:,:,760))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,713),heltab2x32(:,:,761))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,714),heltab2x32(:,:,762))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,715),heltab2x32(:,:,763))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,716),heltab2x32(:,:,764))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,717),heltab2x32(:,:,765))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,718),heltab2x32(:,:,766))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,719),heltab2x32(:,:,767))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,720),heltab2x32(:,:,768))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,721),heltab2x32(:,:,769))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,722),heltab2x32(:,:,770))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,723),heltab2x32(:,:,771))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,724),heltab2x32(:,:,772))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,725),heltab2x32(:,:,773))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,726),heltab2x32(:,:,774))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,727),heltab2x32(:,:,775))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,728),heltab2x32(:,:,776))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,729),heltab2x32(:,:,777))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,730),heltab2x32(:,:,778))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,731),heltab2x32(:,:,779))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,732),heltab2x32(:,:,780))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,733),heltab2x32(:,:,781))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,734),heltab2x32(:,:,782))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,735),heltab2x32(:,:,783))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,736),heltab2x32(:,:,784))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[24,2,5],[nMW,0,nMW],4,1,wf4(:,3))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(57),m4h2x2x8(:,73),heltab3x32(:,:,105))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[24,2,5],[nMW,0,nMW],4,1,wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(58),m4h2x2x8(:,74),heltab3x32(:,:,106))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[24,1,6],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(59),m4h2x2x8(:,75),heltab3x32(:,:,107))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[24,1,6],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(60),m4h2x2x8(:,76),heltab3x32(:,:,108))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[20,2,9],[nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(61),m4h2x2x8(:,77),heltab3x32(:,:,109))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[20,2,9],[nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(62),m4h2x2x8(:,78),heltab3x32(:,:,110))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[20,1,10],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(63),m4h2x2x8(:,79),heltab3x32(:,:,111))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[20,1,10],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(64),m4h2x2x8(:,80),heltab3x32(:,:,112))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[17,2,12],[0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(65),ngPnl,m3h4x8(:,49),heltab2x32(:,:,785))
  call Hloop_Q_A(ntryL,G0H8(65),17,0,G1H8(99),n2h8(205))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[17,2,12],[0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(65),m3h4x8(:,50),heltab2x32(:,:,786))
  call Hloop_Q_A(ntryL,G0H8(65),17,0,G1H8(100),n2h8(206))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[18,1,12],[0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(65),ngPln,m3h4x8(:,51),heltab2x32(:,:,787))
  call Hloop_A_Q(ntryL,G0H8(65),18,0,G1H8(101),n2h8(207))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[18,1,12],[0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(65),m3h4x8(:,52),heltab2x32(:,:,788))
  call Hloop_A_Q(ntryL,G0H8(65),18,0,G1H8(102),n2h8(208))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[16,5,10],[nME,nMH,nME],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,737),heltab2x32(:,:,789))
  call Hloop_A_Q(ntryL,G0H16(41),16,nME,G1H16(19),n2h16(93))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[16,5,10],[nME,nMZ,nME],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,738),heltab2x32(:,:,790))
  call Hloop_A_Q(ntryL,G0H16(42),16,nME,G1H16(20),n2h16(94))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,739),heltab2x32(:,:,791))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[16,5,10],[nME,0,nME],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,740),heltab2x32(:,:,792))
  call Hloop_A_Q(ntryL,G0H16(43),16,nME,G1H16(22),n2h16(95))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[16,5,10],[nME,nMZ,nME],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,741),heltab2x32(:,:,793))
  call Hloop_A_Q(ntryL,G0H16(44),16,nME,G1H16(23),n2h16(96))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,742),heltab2x32(:,:,794))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,743),heltab2x32(:,:,795))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,744),heltab2x32(:,:,796))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[18,5,8],[nMH,nME,nME],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(65),ngH,m3h4x8(:,53),heltab2x32(:,:,797))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[18,5,8],[nMZ,nME,nME],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(66),ngX,m3h4x8(:,54),heltab2x32(:,:,798))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(67),ngPln,m3h4x8(:,55),heltab2x32(:,:,799))
  call Hloop_A_Q(ntryL,G0H8(67),18,0,G1H8(109),n2h8(209))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[18,5,8],[0,nME,nME],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(67),m3h4x8(:,56),heltab2x32(:,:,800))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[18,5,8],[nMZ,nME,nME],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(68),ngZl,m3h4x8(:,57),heltab2x32(:,:,801))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),m3h4x8(:,58),heltab2x32(:,:,802))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(110),n2h8(210))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),ngPln,m3h4x8(:,59),heltab2x32(:,:,803))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(111),n2h8(211))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(69),m3h4x8(:,60),heltab2x32(:,:,804))
  call Hloop_A_Q(ntryL,G0H8(69),18,0,G1H8(112),n2h8(212))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[16,7,8],[nME,nME,nME],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,745),heltab2x32(:,:,805))
  call Hloop_A_Q(ntryL,G0H16(47),16,nME,G1H16(26),n2h16(97))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[16,7,8],[nME,nME,nME],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,746),heltab2x32(:,:,806))
  call Hloop_Q_A(ntryL,G0H16(48),16,nME,G1H16(27),n2h16(98))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[16,7,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,747),heltab2x32(:,:,807))
  call Hloop_A_Q(ntryL,G0H16(5),16,nME,G1H16(28),n2h16(99))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[16,7,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,748),heltab2x32(:,:,808))
  call Hloop_Q_A(ntryL,G0H16(6),16,nME,G1H16(29),n2h16(100))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,749),heltab2x32(:,:,809))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,750),heltab2x32(:,:,810))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(32),m3h2x16(:,751),heltab2x32(:,:,811))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,752),heltab2x32(:,:,812))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(34),m3h2x16(:,753),heltab2x32(:,:,813))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,754),heltab2x32(:,:,814))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(37),m3h2x16(:,755),heltab2x32(:,:,815))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,756),heltab2x32(:,:,816))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(39),m3h2x16(:,757),heltab2x32(:,:,817))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,758),heltab2x32(:,:,818))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,759),heltab2x32(:,:,819))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,760),heltab2x32(:,:,820))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,761),heltab2x32(:,:,821))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,762),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,763),heltab2x32(:,:,823))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,764),heltab2x32(:,:,824))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,765),heltab2x32(:,:,825))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,766),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,767),heltab2x32(:,:,827))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,768),heltab2x32(:,:,828))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,769),heltab2x32(:,:,829))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,770),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,771),heltab2x32(:,:,831))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,772),heltab2x32(:,:,832))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,773),heltab2x32(:,:,833))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,774),heltab2x32(:,:,834))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,775),heltab2x32(:,:,835))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,776),heltab2x32(:,:,836))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,777),heltab2x32(:,:,837))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,778),heltab2x32(:,:,838))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,779),heltab2x32(:,:,839))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,780),heltab2x32(:,:,840))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[16,7,8],[nME,nME,nME],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,781),heltab2x32(:,:,841))
  call Hloop_A_Q(ntryL,G0H16(55),16,nME,G1H16(51),n2h16(101))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[16,7,8],[nME,nME,nME],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,782),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G0H16(56),16,nME,G1H16(52),n2h16(102))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,783),heltab2x32(:,:,843))
  call Hloop_A_Q(ntryL,G0H16(57),16,0,G1H16(55),n2h16(103))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[16,7,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,784),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G0H16(58),16,0,G1H16(56),n2h16(104))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[16,7,8],[nME,nME,nME],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,785),heltab2x32(:,:,845))
  call Hloop_A_Q(ntryL,G0H16(59),16,nME,G1H16(59),n2h16(105))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[16,7,8],[nME,nME,nME],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,786),heltab2x32(:,:,846))
  call Hloop_Q_A(ntryL,G0H16(60),16,nME,G1H16(60),n2h16(106))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,787),heltab2x32(:,:,847))
  call Hloop_A_Q(ntryL,G0H16(61),16,0,G1H16(61),n2h16(107))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[16,7,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,788),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G0H16(62),16,0,G1H16(62),n2h16(108))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,789),heltab2x32(:,:,849))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,790),heltab2x32(:,:,850))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,791),heltab2x32(:,:,851))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,792),heltab2x32(:,:,852))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(67),m3h2x16(:,793),heltab2x32(:,:,853))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,794),heltab2x32(:,:,854))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(69),m3h2x16(:,795),heltab2x32(:,:,855))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,796),heltab2x32(:,:,856))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(71),m3h2x16(:,797),heltab2x32(:,:,857))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,798),heltab2x32(:,:,858))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(73),m3h2x16(:,799),heltab2x32(:,:,859))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,800),heltab2x32(:,:,860))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,801),heltab2x32(:,:,861))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(76),m3h2x16(:,802),heltab2x32(:,:,862))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,803),heltab2x32(:,:,863))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,804),heltab2x32(:,:,864))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,805),heltab2x32(:,:,865))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,806),heltab2x32(:,:,866))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,807),heltab2x32(:,:,867))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,808),heltab2x32(:,:,868))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,809),heltab2x32(:,:,869))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,810),heltab2x32(:,:,870))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,811),heltab2x32(:,:,871))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(82),m3h2x16(:,812),heltab2x32(:,:,872))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,813),heltab2x32(:,:,873))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,814),heltab2x32(:,:,874))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,815),heltab2x32(:,:,875))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,816),heltab2x32(:,:,876))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,817),heltab2x32(:,:,877))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,818),heltab2x32(:,:,878))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,819),heltab2x32(:,:,879))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,820),heltab2x32(:,:,880))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,821),heltab2x32(:,:,881))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,822),heltab2x32(:,:,882))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,823),heltab2x32(:,:,883))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,824),heltab2x32(:,:,884))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,825),heltab2x32(:,:,885))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,826),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,827),heltab2x32(:,:,887))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,828),heltab2x32(:,:,888))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[16,2,13],[nME,nMH,nME],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,829),heltab2x32(:,:,889))
  call Hloop_Q_A(ntryL,G0H16(83),16,nME,G1H16(87),n2h16(109))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[16,2,13],[nME,nMZ,nME],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,830),heltab2x32(:,:,890))
  call Hloop_Q_A(ntryL,G0H16(84),16,nME,G1H16(88),n2h16(110))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,831),heltab2x32(:,:,891))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[16,2,13],[nME,0,nME],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,832),heltab2x32(:,:,892))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(90),n2h16(111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[16,2,13],[nME,nMZ,nME],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,833),heltab2x32(:,:,893))
  call Hloop_Q_A(ntryL,G0H16(86),16,nME,G1H16(91),n2h16(112))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,834),heltab2x32(:,:,894))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,835),heltab2x32(:,:,895))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[16,2,13],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(92),m3h2x16(:,836),heltab2x32(:,:,896))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[21,2,8],[nMH,nME,nME],3,1,wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,28),G0H4(19),ngH,m3h8x4(:,1),heltab2x32(:,:,897))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[21,2,8],[nMZ,nME,nME],3,1,wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,28),G0H4(17),ngX,m3h8x4(:,2),heltab2x32(:,:,898))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(31),ngPnl,m3h8x4(:,3),heltab2x32(:,:,899))
  call Hloop_Q_A(ntryL,G0H4(31),21,0,G1H4(177),n2h4(213))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[21,2,8],[0,nME,nME],3,1,wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,28),G0H4(29),m3h8x4(:,4),heltab2x32(:,:,900))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[21,2,8],[nMZ,nME,nME],3,1,wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,28),G0H4(21),ngZl,m3h8x4(:,5),heltab2x32(:,:,901))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(27),m3h8x4(:,6),heltab2x32(:,:,902))
  call Hloop_Q_A(ntryL,G0H4(27),21,0,G1H4(178),n2h4(214))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(39),ngPnl,m3h8x4(:,7),heltab2x32(:,:,903))
  call Hloop_Q_A(ntryL,G0H4(39),21,0,G1H4(34),n2h4(215))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[21,2,8],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(37),m3h8x4(:,8),heltab2x32(:,:,904))
  call Hloop_Q_A(ntryL,G0H4(37),21,0,G1H4(167),n2h4(216))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[16,6,9],[nME,nMH,nME],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,837),heltab2x32(:,:,905))
  call Hloop_Q_A(ntryL,G0H16(89),16,nME,G1H16(93),n2h16(113))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[16,6,9],[nME,nMZ,nME],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,838),heltab2x32(:,:,906))
  call Hloop_Q_A(ntryL,G0H16(90),16,nME,G1H16(94),n2h16(114))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,839),heltab2x32(:,:,907))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[16,6,9],[nME,0,nME],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,840),heltab2x32(:,:,908))
  call Hloop_Q_A(ntryL,G0H16(91),16,nME,G1H16(98),n2h16(115))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[16,6,9],[nME,nMZ,nME],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,841),heltab2x32(:,:,909))
  call Hloop_Q_A(ntryL,G0H16(92),16,nME,G1H16(101),n2h16(116))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,842),heltab2x32(:,:,910))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,843),heltab2x32(:,:,911))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,844),heltab2x32(:,:,912))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[17,6,8],[nMH,nME,nME],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(69),ngH,m3h4x8(:,61),heltab2x32(:,:,913))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[17,6,8],[nMZ,nME,nME],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(70),ngX,m3h4x8(:,62),heltab2x32(:,:,914))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(71),ngPnl,m3h4x8(:,63),heltab2x32(:,:,915))
  call Hloop_Q_A(ntryL,G0H8(71),17,0,G1H8(113),n2h8(213))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[17,6,8],[0,nME,nME],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(71),m3h4x8(:,64),heltab2x32(:,:,916))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[17,6,8],[nMZ,nME,nME],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(72),ngZl,m3h4x8(:,65),heltab2x32(:,:,917))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),ngPnl,m3h4x8(:,66),heltab2x32(:,:,918))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(114),n2h8(214))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),m3h4x8(:,67),heltab2x32(:,:,919))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(121),n2h8(215))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(73),m3h4x8(:,68),heltab2x32(:,:,920))
  call Hloop_Q_A(ntryL,G0H8(73),17,0,G1H8(122),n2h8(216))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[16,7,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,845),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G0H16(95),16,nME,G1H16(103),n2h16(117))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[16,7,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,846),heltab2x32(:,:,922))
  call Hloop_Q_A(ntryL,G0H16(96),16,nME,G1H16(104),n2h16(118))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[16,7,8],[nME,nME,nME],3,1,wf8(:,47))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,847),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G0H16(98),16,nME,G1H16(105),n2h16(119))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[16,7,8],[nME,nME,nME],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,848),heltab2x32(:,:,924))
  call Hloop_Q_A(ntryL,G0H16(100),16,nME,G1H16(106),n2h16(120))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,849),heltab2x32(:,:,925))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,850),heltab2x32(:,:,926))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(110),m3h2x16(:,851),heltab2x32(:,:,927))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,852),heltab2x32(:,:,928))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(112),m3h2x16(:,853),heltab2x32(:,:,929))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,854),heltab2x32(:,:,930))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(114),m3h2x16(:,855),heltab2x32(:,:,931))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,856),heltab2x32(:,:,932))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(116),m3h2x16(:,857),heltab2x32(:,:,933))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,858),heltab2x32(:,:,934))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,859),heltab2x32(:,:,935))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,860),heltab2x32(:,:,936))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,861),heltab2x32(:,:,937))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,862),heltab2x32(:,:,938))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,863),heltab2x32(:,:,939))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,864),heltab2x32(:,:,940))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,865),heltab2x32(:,:,941))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,866),heltab2x32(:,:,942))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,867),heltab2x32(:,:,943))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,868),heltab2x32(:,:,944))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(107),m3h2x16(:,869),heltab2x32(:,:,945))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(108),m3h2x16(:,870),heltab2x32(:,:,946))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(109),m3h2x16(:,871),heltab2x32(:,:,947))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(110),m3h2x16(:,872),heltab2x32(:,:,948))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,873),heltab2x32(:,:,949))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,874),heltab2x32(:,:,950))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,875),heltab2x32(:,:,951))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(128),m3h2x16(:,876),heltab2x32(:,:,952))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(111),m3h2x16(:,877),heltab2x32(:,:,953))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(112),m3h2x16(:,878),heltab2x32(:,:,954))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(113),m3h2x16(:,879),heltab2x32(:,:,955))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(114),m3h2x16(:,880),heltab2x32(:,:,956))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[16,7,8],[nME,nME,nME],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,881),heltab2x32(:,:,957))
  call Hloop_A_Q(ntryL,G0H16(115),16,nME,G1H16(129),n2h16(121))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[16,7,8],[nME,nME,nME],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,882),heltab2x32(:,:,958))
  call Hloop_Q_A(ntryL,G0H16(116),16,nME,G1H16(130),n2h16(122))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,883),heltab2x32(:,:,959))
  call Hloop_A_Q(ntryL,G0H16(117),16,0,G1H16(131),n2h16(123))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[16,7,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,884),heltab2x32(:,:,960))
  call Hloop_Q_A(ntryL,G0H16(118),16,0,G1H16(132),n2h16(124))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[16,7,8],[nME,nME,nME],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,885),heltab2x32(:,:,961))
  call Hloop_A_Q(ntryL,G0H16(119),16,nME,G1H16(133),n2h16(125))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[16,7,8],[nME,nME,nME],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,886),heltab2x32(:,:,962))
  call Hloop_Q_A(ntryL,G0H16(120),16,nME,G1H16(134),n2h16(126))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1075),h0tab(:,1075),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,887),heltab2x32(:,:,963))
  call Hloop_A_Q(ntryL,G0H16(121),16,0,G1H16(135),n2h16(127))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1076),h0tab(:,1076),[16,7,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,888),heltab2x32(:,:,964))
  call Hloop_Q_A(ntryL,G0H16(122),16,0,G1H16(136),n2h16(128))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1077),h0tab(:,1077),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(139),m3h2x16(:,889),heltab2x32(:,:,965))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1078),h0tab(:,1078),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(140),m3h2x16(:,890),heltab2x32(:,:,966))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1079),h0tab(:,1079),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(143),m3h2x16(:,891),heltab2x32(:,:,967))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1080),h0tab(:,1080),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(144),m3h2x16(:,892),heltab2x32(:,:,968))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1081),h0tab(:,1081),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(145),m3h2x16(:,893),heltab2x32(:,:,969))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1082),h0tab(:,1082),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(146),m3h2x16(:,894),heltab2x32(:,:,970))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1083),h0tab(:,1083),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(147),m3h2x16(:,895),heltab2x32(:,:,971))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1084),h0tab(:,1084),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,896),heltab2x32(:,:,972))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1085),h0tab(:,1085),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(149),m3h2x16(:,897),heltab2x32(:,:,973))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1086),h0tab(:,1086),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,898),heltab2x32(:,:,974))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1087),h0tab(:,1087),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(151),m3h2x16(:,899),heltab2x32(:,:,975))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1088),h0tab(:,1088),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(152),m3h2x16(:,900),heltab2x32(:,:,976))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1089),h0tab(:,1089),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(153),m3h2x16(:,901),heltab2x32(:,:,977))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1090),h0tab(:,1090),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(154),m3h2x16(:,902),heltab2x32(:,:,978))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1091),h0tab(:,1091),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(155),m3h2x16(:,903),heltab2x32(:,:,979))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1092),h0tab(:,1092),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,904),heltab2x32(:,:,980))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1093),h0tab(:,1093),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,905),heltab2x32(:,:,981))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1094),h0tab(:,1094),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,906),heltab2x32(:,:,982))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1095),h0tab(:,1095),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,907),heltab2x32(:,:,983))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1096),h0tab(:,1096),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,908),heltab2x32(:,:,984))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1097),h0tab(:,1097),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(157),m3h2x16(:,909),heltab2x32(:,:,985))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1098),h0tab(:,1098),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(158),m3h2x16(:,910),heltab2x32(:,:,986))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1099),h0tab(:,1099),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,911),heltab2x32(:,:,987))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1100),h0tab(:,1100),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,912),heltab2x32(:,:,988))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1101),h0tab(:,1101),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(130),m3h2x16(:,913),heltab2x32(:,:,989))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1102),h0tab(:,1102),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(132),m3h2x16(:,914),heltab2x32(:,:,990))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1103),h0tab(:,1103),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,915),heltab2x32(:,:,991))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1104),h0tab(:,1104),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,916),heltab2x32(:,:,992))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1105),h0tab(:,1105),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,917),heltab2x32(:,:,993))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1106),h0tab(:,1106),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,918),heltab2x32(:,:,994))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1107),h0tab(:,1107),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(137),m3h2x16(:,919),heltab2x32(:,:,995))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1108),h0tab(:,1108),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(138),m3h2x16(:,920),heltab2x32(:,:,996))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1109),h0tab(:,1109),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(161),m3h2x16(:,921),heltab2x32(:,:,997))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1110),h0tab(:,1110),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(162),m3h2x16(:,922),heltab2x32(:,:,998))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1111),h0tab(:,1111),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,923),heltab2x32(:,:,999))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1112),h0tab(:,1112),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(164),m3h2x16(:,924),heltab2x32(:,:,1000))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1113),h0tab(:,1113),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,925),heltab2x32(:,:,1001))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1114),h0tab(:,1114),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,926),heltab2x32(:,:,1002))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1115),h0tab(:,1115),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,927),heltab2x32(:,:,1003))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1116),h0tab(:,1116),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,928),heltab2x32(:,:,1004))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1117),h0tab(:,1117),[16,1,14],[nME,nMH,nME],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,929),heltab2x32(:,:,1005))
  call Hloop_A_Q(ntryL,G0H16(143),16,nME,G1H16(165),n2h16(129))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1118),h0tab(:,1118),[16,1,14],[nME,nMZ,nME],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,930),heltab2x32(:,:,1006))
  call Hloop_A_Q(ntryL,G0H16(144),16,nME,G1H16(166),n2h16(130))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1119),h0tab(:,1119),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,931),heltab2x32(:,:,1007))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1120),h0tab(:,1120),[16,1,14],[nME,0,nME],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,932),heltab2x32(:,:,1008))
  call Hloop_A_Q(ntryL,G0H16(145),16,nME,G1H16(168),n2h16(131))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1121),h0tab(:,1121),[16,1,14],[nME,nMZ,nME],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,933),heltab2x32(:,:,1009))
  call Hloop_A_Q(ntryL,G0H16(146),16,nME,G1H16(169),n2h16(132))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1122),h0tab(:,1122),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,934),heltab2x32(:,:,1010))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1123),h0tab(:,1123),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,935),heltab2x32(:,:,1011))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1124),h0tab(:,1124),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,936),heltab2x32(:,:,1012))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1125),h0tab(:,1125),[22,1,8],[nMH,nME,nME],3,1,wf8(:,33))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,33),G0H4(12),ngH,m3h8x4(:,9),heltab2x32(:,:,1013))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1126),h0tab(:,1126),[22,1,8],[nMZ,nME,nME],3,1,wf8(:,33))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,33),G0H4(31),ngX,m3h8x4(:,10),heltab2x32(:,:,1014))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1127),h0tab(:,1127),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(27),ngPln,m3h8x4(:,11),heltab2x32(:,:,1015))
  call Hloop_A_Q(ntryL,G0H4(27),22,0,G1H4(172),n2h4(217))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1128),h0tab(:,1128),[22,1,8],[0,nME,nME],3,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,33),G0H4(39),m3h8x4(:,12),heltab2x32(:,:,1016))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1129),h0tab(:,1129),[22,1,8],[nMZ,nME,nME],3,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,33),G0H4(37),ngZl,m3h8x4(:,13),heltab2x32(:,:,1017))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1130),h0tab(:,1130),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(27),m3h8x4(:,14),heltab2x32(:,:,1018))
  call Hloop_A_Q(ntryL,G0H4(27),22,0,G1H4(221),n2h4(218))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1131),h0tab(:,1131),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(27),ngPln,m3h8x4(:,15),heltab2x32(:,:,1019))
  call Hloop_A_Q(ntryL,G0H4(27),22,0,G1H4(225),n2h4(219))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1132),h0tab(:,1132),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(27),m3h8x4(:,16),heltab2x32(:,:,1020))
  call Hloop_A_Q(ntryL,G0H4(27),22,0,G1H4(223),n2h4(220))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1133),h0tab(:,1133),[18,4,9],[nME,nME,nMH],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngH,m3h4x8(:,69),heltab2x32(:,:,1021))
  call Hloop_A_Q(ntryL,G0H8(73),18,nME,G1H8(123),n2h8(217))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1134),h0tab(:,1134),[18,4,9],[nME,nME,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngX,m3h4x8(:,70),heltab2x32(:,:,1022))
  call Hloop_A_Q(ntryL,G0H8(73),18,nME,G1H8(124),n2h8(218))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1135),h0tab(:,1135),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(73),ngPln,m3h4x8(:,71),heltab2x32(:,:,1023))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1136),h0tab(:,1136),[18,4,9],[nME,nME,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(74),m3h4x8(:,72),heltab2x32(:,:,1024))
  call Hloop_A_Q(ntryL,G0H8(74),18,nME,G1H8(125),n2h8(219))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1137),h0tab(:,1137),[18,4,9],[nME,nME,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(74),ngZl,m3h4x8(:,73),heltab2x32(:,:,1025))
  call Hloop_A_Q(ntryL,G0H8(74),18,nME,G1H8(126),n2h8(220))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1138),h0tab(:,1138),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(74),m3h4x8(:,74),heltab2x32(:,:,1026))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1139),h0tab(:,1139),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(75),ngPln,m3h4x8(:,75),heltab2x32(:,:,1027))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1140),h0tab(:,1140),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(76),m3h4x8(:,76),heltab2x32(:,:,1028))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1141),h0tab(:,1141),[16,4,11],[nME,nME,nME],3,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,937),heltab2x32(:,:,1029))
  call Hloop_Q_A(ntryL,G0H16(149),16,nME,G1H16(171),n2h16(133))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1142),h0tab(:,1142),[16,4,11],[nME,nME,nME],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,938),heltab2x32(:,:,1030))
  call Hloop_A_Q(ntryL,G0H16(150),16,nME,G1H16(172),n2h16(134))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1143),h0tab(:,1143),[16,4,11],[nME,nME,nME],3,1,wf8(:,50))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,939),heltab2x32(:,:,1031))
  call Hloop_Q_A(ntryL,G0H16(151),16,nME,G1H16(173),n2h16(135))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1144),h0tab(:,1144),[16,4,11],[nME,nME,nME],3,1,wf8(:,50))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,940),heltab2x32(:,:,1032))
  call Hloop_A_Q(ntryL,G0H16(152),16,nME,G1H16(174),n2h16(136))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1145),h0tab(:,1145),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,941),heltab2x32(:,:,1033))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1146),h0tab(:,1146),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(176),m3h2x16(:,942),heltab2x32(:,:,1034))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1147),h0tab(:,1147),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,943),heltab2x32(:,:,1035))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1148),h0tab(:,1148),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(178),m3h2x16(:,944),heltab2x32(:,:,1036))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1149),h0tab(:,1149),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,945),heltab2x32(:,:,1037))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1150),h0tab(:,1150),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(182),m3h2x16(:,946),heltab2x32(:,:,1038))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1151),h0tab(:,1151),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,947),heltab2x32(:,:,1039))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1152),h0tab(:,1152),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(186),m3h2x16(:,948),heltab2x32(:,:,1040))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1153),h0tab(:,1153),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,949),heltab2x32(:,:,1041))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1154),h0tab(:,1154),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(188),m3h2x16(:,950),heltab2x32(:,:,1042))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1155),h0tab(:,1155),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,951),heltab2x32(:,:,1043))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1156),h0tab(:,1156),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(190),m3h2x16(:,952),heltab2x32(:,:,1044))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1157),h0tab(:,1157),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,953),heltab2x32(:,:,1045))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1158),h0tab(:,1158),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,954),heltab2x32(:,:,1046))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1159),h0tab(:,1159),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,955),heltab2x32(:,:,1047))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1160),h0tab(:,1160),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,956),heltab2x32(:,:,1048))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1161),h0tab(:,1161),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,957),heltab2x32(:,:,1049))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1162),h0tab(:,1162),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(192),m3h2x16(:,958),heltab2x32(:,:,1050))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1163),h0tab(:,1163),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(193),m3h2x16(:,959),heltab2x32(:,:,1051))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1164),h0tab(:,1164),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(194),m3h2x16(:,960),heltab2x32(:,:,1052))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1165),h0tab(:,1165),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,961),heltab2x32(:,:,1053))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1166),h0tab(:,1166),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,962),heltab2x32(:,:,1054))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1167),h0tab(:,1167),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(163),m3h2x16(:,963),heltab2x32(:,:,1055))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1168),h0tab(:,1168),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(164),m3h2x16(:,964),heltab2x32(:,:,1056))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1169),h0tab(:,1169),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,965),heltab2x32(:,:,1057))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1170),h0tab(:,1170),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(196),m3h2x16(:,966),heltab2x32(:,:,1058))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1171),h0tab(:,1171),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(198),m3h2x16(:,967),heltab2x32(:,:,1059))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1172),h0tab(:,1172),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(200),m3h2x16(:,968),heltab2x32(:,:,1060))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1173),h0tab(:,1173),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(165),m3h2x16(:,969),heltab2x32(:,:,1061))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1174),h0tab(:,1174),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,15))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(166),m3h2x16(:,970),heltab2x32(:,:,1062))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1175),h0tab(:,1175),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(167),m3h2x16(:,971),heltab2x32(:,:,1063))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1176),h0tab(:,1176),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,50))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(168),m3h2x16(:,972),heltab2x32(:,:,1064))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1177),h0tab(:,1177),[16,4,11],[nME,nME,nME],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(169),m3h2x16(:,973),heltab2x32(:,:,1065))
  call Hloop_Q_A(ntryL,G0H16(169),16,nME,G1H16(201),n2h16(137))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1178),h0tab(:,1178),[16,4,11],[nME,nME,nME],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(170),m3h2x16(:,974),heltab2x32(:,:,1066))
  call Hloop_A_Q(ntryL,G0H16(170),16,nME,G1H16(202),n2h16(138))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1179),h0tab(:,1179),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(171),m3h2x16(:,975),heltab2x32(:,:,1067))
  call Hloop_Q_A(ntryL,G0H16(171),16,0,G1H16(203),n2h16(139))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1180),h0tab(:,1180),[16,4,11],[0,0,0],3,1,wf8(:,51))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(172),m3h2x16(:,976),heltab2x32(:,:,1068))
  call Hloop_A_Q(ntryL,G0H16(172),16,0,G1H16(204),n2h16(140))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1181),h0tab(:,1181),[16,4,11],[nME,nME,nME],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,977),heltab2x32(:,:,1069))
  call Hloop_Q_A(ntryL,G0H16(173),16,nME,G1H16(205),n2h16(141))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1182),h0tab(:,1182),[16,4,11],[nME,nME,nME],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(174),m3h2x16(:,978),heltab2x32(:,:,1070))
  call Hloop_A_Q(ntryL,G0H16(174),16,nME,G1H16(206),n2h16(142))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1183),h0tab(:,1183),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,979),heltab2x32(:,:,1071))
  call Hloop_Q_A(ntryL,G0H16(175),16,0,G1H16(207),n2h16(143))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1184),h0tab(:,1184),[16,4,11],[0,0,0],3,1,wf8(:,52))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,980),heltab2x32(:,:,1072))
  call Hloop_A_Q(ntryL,G0H16(176),16,0,G1H16(208),n2h16(144))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1185),h0tab(:,1185),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,981),heltab2x32(:,:,1073))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1186),h0tab(:,1186),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(210),m3h2x16(:,982),heltab2x32(:,:,1074))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1187),h0tab(:,1187),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(211),m3h2x16(:,983),heltab2x32(:,:,1075))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1188),h0tab(:,1188),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,984),heltab2x32(:,:,1076))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1189),h0tab(:,1189),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(213),m3h2x16(:,985),heltab2x32(:,:,1077))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1190),h0tab(:,1190),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(214),m3h2x16(:,986),heltab2x32(:,:,1078))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1191),h0tab(:,1191),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(215),m3h2x16(:,987),heltab2x32(:,:,1079))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1192),h0tab(:,1192),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(216),m3h2x16(:,988),heltab2x32(:,:,1080))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1193),h0tab(:,1193),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(217),m3h2x16(:,989),heltab2x32(:,:,1081))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1194),h0tab(:,1194),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(218),m3h2x16(:,990),heltab2x32(:,:,1082))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1195),h0tab(:,1195),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,991),heltab2x32(:,:,1083))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1196),h0tab(:,1196),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(220),m3h2x16(:,992),heltab2x32(:,:,1084))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1197),h0tab(:,1197),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,993),heltab2x32(:,:,1085))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1198),h0tab(:,1198),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,994),heltab2x32(:,:,1086))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1199),h0tab(:,1199),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,995),heltab2x32(:,:,1087))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1200),h0tab(:,1200),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(228),m3h2x16(:,996),heltab2x32(:,:,1088))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1201),h0tab(:,1201),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,997),heltab2x32(:,:,1089))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1202),h0tab(:,1202),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,998),heltab2x32(:,:,1090))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1203),h0tab(:,1203),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,999),heltab2x32(:,:,1091))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1204),h0tab(:,1204),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,1000),heltab2x32(:,:,1092))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1205),h0tab(:,1205),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,1001),heltab2x32(:,:,1093))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1206),h0tab(:,1206),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,1002),heltab2x32(:,:,1094))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1207),h0tab(:,1207),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,1003),heltab2x32(:,:,1095))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1208),h0tab(:,1208),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,1004),heltab2x32(:,:,1096))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1209),h0tab(:,1209),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,1005),heltab2x32(:,:,1097))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1210),h0tab(:,1210),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,1006),heltab2x32(:,:,1098))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1211),h0tab(:,1211),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,1007),heltab2x32(:,:,1099))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1212),h0tab(:,1212),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,1008),heltab2x32(:,:,1100))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1213),h0tab(:,1213),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,1009),heltab2x32(:,:,1101))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1214),h0tab(:,1214),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,1010),heltab2x32(:,:,1102))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1215),h0tab(:,1215),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,1011),heltab2x32(:,:,1103))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1216),h0tab(:,1216),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,1012),heltab2x32(:,:,1104))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1217),h0tab(:,1217),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(233),m3h2x16(:,1013),heltab2x32(:,:,1105))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1218),h0tab(:,1218),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,1014),heltab2x32(:,:,1106))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1219),h0tab(:,1219),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(235),m3h2x16(:,1015),heltab2x32(:,:,1107))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1220),h0tab(:,1220),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(236),m3h2x16(:,1016),heltab2x32(:,:,1108))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1221),h0tab(:,1221),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,1017),heltab2x32(:,:,1109))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1222),h0tab(:,1222),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,51))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,1018),heltab2x32(:,:,1110))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1223),h0tab(:,1223),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,1019),heltab2x32(:,:,1111))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1224),h0tab(:,1224),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,52))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,1020),heltab2x32(:,:,1112))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1225),h0tab(:,1225),[16,2,13],[nME,nMH,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,1021),heltab2x32(:,:,1113))
  call Hloop_Q_A(ntryL,G0H16(193),16,nME,G1H16(237),n2h16(145))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1226),h0tab(:,1226),[16,2,13],[nME,nMZ,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,1022),heltab2x32(:,:,1114))
  call Hloop_Q_A(ntryL,G0H16(194),16,nME,G1H16(238),n2h16(146))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1227),h0tab(:,1227),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,1023),heltab2x32(:,:,1115))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1228),h0tab(:,1228),[16,2,13],[nME,0,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,1024),heltab2x32(:,:,1116))
  call Hloop_Q_A(ntryL,G0H16(195),16,nME,G1H16(240),n2h16(147))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1229),h0tab(:,1229),[16,2,13],[nME,nMZ,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,1025),heltab2x32(:,:,1117))
  call Hloop_Q_A(ntryL,G0H16(196),16,nME,G1H16(241),n2h16(148))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1230),h0tab(:,1230),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,1026),heltab2x32(:,:,1118))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1231),h0tab(:,1231),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,1027),heltab2x32(:,:,1119))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1232),h0tab(:,1232),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(242),m3h2x16(:,1028),heltab2x32(:,:,1120))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1233),h0tab(:,1233),[25,2,4],[nMH,nME,nME],3,1,wf8(:,34))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,34),G0H4(27),ngH,m3h8x4(:,17),heltab2x32(:,:,1121))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1234),h0tab(:,1234),[25,2,4],[nMZ,nME,nME],3,1,wf8(:,34))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,34),G0H4(42),ngX,m3h8x4(:,18),heltab2x32(:,:,1122))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1235),h0tab(:,1235),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(43),ngPnl,m3h8x4(:,19),heltab2x32(:,:,1123))
  call Hloop_Q_A(ntryL,G0H4(43),25,0,G1H4(224),n2h4(221))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1236),h0tab(:,1236),[25,2,4],[0,nME,nME],3,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,34),G0H4(43),m3h8x4(:,20),heltab2x32(:,:,1124))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1237),h0tab(:,1237),[25,2,4],[nMZ,nME,nME],3,1,wf8(:,34))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,34),G0H4(44),ngZl,m3h8x4(:,21),heltab2x32(:,:,1125))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1238),h0tab(:,1238),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),m3h8x4(:,22),heltab2x32(:,:,1126))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(226),n2h4(222))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1239),h0tab(:,1239),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),ngPnl,m3h8x4(:,23),heltab2x32(:,:,1127))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(231),n2h4(223))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1240),h0tab(:,1240),[25,2,4],[0,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,34),G0H4(45),m3h8x4(:,24),heltab2x32(:,:,1128))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(232),n2h4(224))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1241),h0tab(:,1241),[17,4,10],[nME,nME,nMH],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngH,m3h4x8(:,77),heltab2x32(:,:,1129))
  call Hloop_Q_A(ntryL,G0H8(77),17,nME,G1H8(131),n2h8(221))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1242),h0tab(:,1242),[17,4,10],[nME,nME,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngX,m3h4x8(:,78),heltab2x32(:,:,1130))
  call Hloop_Q_A(ntryL,G0H8(77),17,nME,G1H8(12),n2h8(222))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1243),h0tab(:,1243),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(77),ngPnl,m3h4x8(:,79),heltab2x32(:,:,1131))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1244),h0tab(:,1244),[17,4,10],[nME,nME,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(78),m3h4x8(:,80),heltab2x32(:,:,1132))
  call Hloop_Q_A(ntryL,G0H8(78),17,nME,G1H8(24),n2h8(223))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1245),h0tab(:,1245),[17,4,10],[nME,nME,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(78),ngZl,m3h4x8(:,81),heltab2x32(:,:,1133))
  call Hloop_Q_A(ntryL,G0H8(78),17,nME,G1H8(27),n2h8(224))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1246),h0tab(:,1246),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(78),ngPnl,m3h4x8(:,82),heltab2x32(:,:,1134))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1247),h0tab(:,1247),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(79),m3h4x8(:,83),heltab2x32(:,:,1135))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1248),h0tab(:,1248),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(80),m3h4x8(:,84),heltab2x32(:,:,1136))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1249),h0tab(:,1249),[16,4,11],[nME,nME,nME],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,1029),heltab2x32(:,:,1137))
  call Hloop_Q_A(ntryL,G0H16(199),16,nME,G1H16(243),n2h16(149))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1250),h0tab(:,1250),[16,4,11],[nME,nME,nME],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,1030),heltab2x32(:,:,1138))
  call Hloop_A_Q(ntryL,G0H16(200),16,nME,G1H16(244),n2h16(150))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1251),h0tab(:,1251),[16,4,11],[nME,nME,nME],3,1,wf8(:,53))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,1031),heltab2x32(:,:,1139))
  call Hloop_Q_A(ntryL,G0H16(201),16,nME,G1H16(245),n2h16(151))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1252),h0tab(:,1252),[16,4,11],[nME,nME,nME],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,1032),heltab2x32(:,:,1140))
  call Hloop_A_Q(ntryL,G0H16(202),16,nME,G1H16(246),n2h16(152))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1253),h0tab(:,1253),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(247),m3h2x16(:,1033),heltab2x32(:,:,1141))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1254),h0tab(:,1254),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(248),m3h2x16(:,1034),heltab2x32(:,:,1142))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1255),h0tab(:,1255),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(249),m3h2x16(:,1035),heltab2x32(:,:,1143))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1256),h0tab(:,1256),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(250),m3h2x16(:,1036),heltab2x32(:,:,1144))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1257),h0tab(:,1257),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(251),m3h2x16(:,1037),heltab2x32(:,:,1145))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1258),h0tab(:,1258),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(252),m3h2x16(:,1038),heltab2x32(:,:,1146))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1259),h0tab(:,1259),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(253),m3h2x16(:,1039),heltab2x32(:,:,1147))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1260),h0tab(:,1260),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(254),m3h2x16(:,1040),heltab2x32(:,:,1148))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1261),h0tab(:,1261),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(255),m3h2x16(:,1041),heltab2x32(:,:,1149))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1262),h0tab(:,1262),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(256),m3h2x16(:,1042),heltab2x32(:,:,1150))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1263),h0tab(:,1263),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(257),m3h2x16(:,1043),heltab2x32(:,:,1151))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1264),h0tab(:,1264),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(258),m3h2x16(:,1044),heltab2x32(:,:,1152))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1265),h0tab(:,1265),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,1045),heltab2x32(:,:,1153))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1266),h0tab(:,1266),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(204),m3h2x16(:,1046),heltab2x32(:,:,1154))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1267),h0tab(:,1267),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,1047),heltab2x32(:,:,1155))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1268),h0tab(:,1268),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,1048),heltab2x32(:,:,1156))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1269),h0tab(:,1269),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(259),m3h2x16(:,1049),heltab2x32(:,:,1157))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1270),h0tab(:,1270),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(260),m3h2x16(:,1050),heltab2x32(:,:,1158))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1271),h0tab(:,1271),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(261),m3h2x16(:,1051),heltab2x32(:,:,1159))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1272),h0tab(:,1272),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(262),m3h2x16(:,1052),heltab2x32(:,:,1160))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1273),h0tab(:,1273),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,1053),heltab2x32(:,:,1161))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1274),h0tab(:,1274),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,1054),heltab2x32(:,:,1162))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1275),h0tab(:,1275),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,1055),heltab2x32(:,:,1163))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1276),h0tab(:,1276),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,1056),heltab2x32(:,:,1164))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1277),h0tab(:,1277),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(263),m3h2x16(:,1057),heltab2x32(:,:,1165))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1278),h0tab(:,1278),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(264),m3h2x16(:,1058),heltab2x32(:,:,1166))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1279),h0tab(:,1279),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(265),m3h2x16(:,1059),heltab2x32(:,:,1167))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1280),h0tab(:,1280),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(266),m3h2x16(:,1060),heltab2x32(:,:,1168))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1281),h0tab(:,1281),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,1061),heltab2x32(:,:,1169))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1282),h0tab(:,1282),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,1062),heltab2x32(:,:,1170))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1283),h0tab(:,1283),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,1063),heltab2x32(:,:,1171))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1284),h0tab(:,1284),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,53))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,1064),heltab2x32(:,:,1172))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1285),h0tab(:,1285),[16,4,11],[nME,nME,nME],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,1065),heltab2x32(:,:,1173))
  call Hloop_Q_A(ntryL,G0H16(57),16,nME,G1H16(267),n2h16(153))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1286),h0tab(:,1286),[16,4,11],[nME,nME,nME],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,1066),heltab2x32(:,:,1174))
  call Hloop_A_Q(ntryL,G0H16(58),16,nME,G1H16(268),n2h16(154))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1287),h0tab(:,1287),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,1067),heltab2x32(:,:,1175))
  call Hloop_Q_A(ntryL,G0H16(59),16,0,G1H16(269),n2h16(155))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1288),h0tab(:,1288),[16,4,11],[0,0,0],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,1068),heltab2x32(:,:,1176))
  call Hloop_A_Q(ntryL,G0H16(60),16,0,G1H16(270),n2h16(156))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1289),h0tab(:,1289),[16,4,11],[nME,nME,nME],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,1069),heltab2x32(:,:,1177))
  call Hloop_Q_A(ntryL,G0H16(61),16,nME,G1H16(271),n2h16(157))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1290),h0tab(:,1290),[16,4,11],[nME,nME,nME],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,1070),heltab2x32(:,:,1178))
  call Hloop_A_Q(ntryL,G0H16(62),16,nME,G1H16(272),n2h16(158))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1291),h0tab(:,1291),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,1071),heltab2x32(:,:,1179))
  call Hloop_Q_A(ntryL,G0H16(83),16,0,G1H16(273),n2h16(159))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1292),h0tab(:,1292),[16,4,11],[0,0,0],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,1072),heltab2x32(:,:,1180))
  call Hloop_A_Q(ntryL,G0H16(84),16,0,G1H16(274),n2h16(160))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1293),h0tab(:,1293),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(275),m3h2x16(:,1073),heltab2x32(:,:,1181))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1294),h0tab(:,1294),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(276),m3h2x16(:,1074),heltab2x32(:,:,1182))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1295),h0tab(:,1295),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(277),m3h2x16(:,1075),heltab2x32(:,:,1183))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1296),h0tab(:,1296),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(278),m3h2x16(:,1076),heltab2x32(:,:,1184))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1297),h0tab(:,1297),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(279),m3h2x16(:,1077),heltab2x32(:,:,1185))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1298),h0tab(:,1298),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(280),m3h2x16(:,1078),heltab2x32(:,:,1186))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1299),h0tab(:,1299),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(281),m3h2x16(:,1079),heltab2x32(:,:,1187))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1300),h0tab(:,1300),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(282),m3h2x16(:,1080),heltab2x32(:,:,1188))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1301),h0tab(:,1301),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(283),m3h2x16(:,1081),heltab2x32(:,:,1189))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1302),h0tab(:,1302),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(284),m3h2x16(:,1082),heltab2x32(:,:,1190))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1303),h0tab(:,1303),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(285),m3h2x16(:,1083),heltab2x32(:,:,1191))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1304),h0tab(:,1304),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(286),m3h2x16(:,1084),heltab2x32(:,:,1192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1305),h0tab(:,1305),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(287),m3h2x16(:,1085),heltab2x32(:,:,1193))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1306),h0tab(:,1306),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(288),m3h2x16(:,1086),heltab2x32(:,:,1194))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1307),h0tab(:,1307),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(289),m3h2x16(:,1087),heltab2x32(:,:,1195))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1308),h0tab(:,1308),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(290),m3h2x16(:,1088),heltab2x32(:,:,1196))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1309),h0tab(:,1309),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,1089),heltab2x32(:,:,1197))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1310),h0tab(:,1310),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,1090),heltab2x32(:,:,1198))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1311),h0tab(:,1311),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,1091),heltab2x32(:,:,1199))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1312),h0tab(:,1312),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,1092),heltab2x32(:,:,1200))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1313),h0tab(:,1313),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(291),m3h2x16(:,1093),heltab2x32(:,:,1201))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1314),h0tab(:,1314),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(292),m3h2x16(:,1094),heltab2x32(:,:,1202))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1315),h0tab(:,1315),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(293),m3h2x16(:,1095),heltab2x32(:,:,1203))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1316),h0tab(:,1316),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(294),m3h2x16(:,1096),heltab2x32(:,:,1204))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1317),h0tab(:,1317),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,1097),heltab2x32(:,:,1205))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1318),h0tab(:,1318),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,1098),heltab2x32(:,:,1206))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1319),h0tab(:,1319),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,1099),heltab2x32(:,:,1207))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1320),h0tab(:,1320),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,1100),heltab2x32(:,:,1208))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1321),h0tab(:,1321),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,1101),heltab2x32(:,:,1209))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1322),h0tab(:,1322),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,1102),heltab2x32(:,:,1210))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1323),h0tab(:,1323),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,1103),heltab2x32(:,:,1211))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1324),h0tab(:,1324),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,1104),heltab2x32(:,:,1212))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1325),h0tab(:,1325),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(295),m3h2x16(:,1105),heltab2x32(:,:,1213))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1326),h0tab(:,1326),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(296),m3h2x16(:,1106),heltab2x32(:,:,1214))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1327),h0tab(:,1327),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(297),m3h2x16(:,1107),heltab2x32(:,:,1215))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1328),h0tab(:,1328),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(298),m3h2x16(:,1108),heltab2x32(:,:,1216))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1329),h0tab(:,1329),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,1109),heltab2x32(:,:,1217))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1330),h0tab(:,1330),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,54))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,1110),heltab2x32(:,:,1218))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1331),h0tab(:,1331),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,1111),heltab2x32(:,:,1219))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1332),h0tab(:,1332),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,55))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,1112),heltab2x32(:,:,1220))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1333),h0tab(:,1333),[16,1,14],[nME,nMH,nME],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,1113),heltab2x32(:,:,1221))
  call Hloop_A_Q(ntryL,G0H16(121),16,nME,G1H16(299),n2h16(161))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1334),h0tab(:,1334),[16,1,14],[nME,nMZ,nME],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,1114),heltab2x32(:,:,1222))
  call Hloop_A_Q(ntryL,G0H16(122),16,nME,G1H16(300),n2h16(162))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1335),h0tab(:,1335),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(301),m3h2x16(:,1115),heltab2x32(:,:,1223))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1336),h0tab(:,1336),[16,1,14],[nME,0,nME],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,1116),heltab2x32(:,:,1224))
  call Hloop_A_Q(ntryL,G0H16(143),16,nME,G1H16(302),n2h16(163))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1337),h0tab(:,1337),[16,1,14],[nME,nMZ,nME],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,1117),heltab2x32(:,:,1225))
  call Hloop_A_Q(ntryL,G0H16(144),16,nME,G1H16(303),n2h16(164))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1338),h0tab(:,1338),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,1118),heltab2x32(:,:,1226))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1339),h0tab(:,1339),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,1119),heltab2x32(:,:,1227))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1340),h0tab(:,1340),[16,1,14],[nMW,0,nMW],3,1,wf8(:,42))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(304),m3h2x16(:,1120),heltab2x32(:,:,1228))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1341),h0tab(:,1341),[26,1,4],[nMH,nME,nME],3,1,wf8(:,27))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,27),G0H4(45),ngH,m3h8x4(:,25),heltab2x32(:,:,1229))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1342),h0tab(:,1342),[26,1,4],[nMZ,nME,nME],3,1,wf8(:,27))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,27),G0H4(46),ngX,m3h8x4(:,26),heltab2x32(:,:,1230))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1343),h0tab(:,1343),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(47),ngPln,m3h8x4(:,27),heltab2x32(:,:,1231))
  call Hloop_A_Q(ntryL,G0H4(47),26,0,G1H4(17),n2h4(225))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1344),h0tab(:,1344),[26,1,4],[0,nME,nME],3,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,27),G0H4(47),m3h8x4(:,28),heltab2x32(:,:,1232))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1345),h0tab(:,1345),[26,1,4],[nMZ,nME,nME],3,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,27),G0H4(48),ngZl,m3h8x4(:,29),heltab2x32(:,:,1233))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1346),h0tab(:,1346),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),m3h8x4(:,30),heltab2x32(:,:,1234))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(18),n2h4(226))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1347),h0tab(:,1347),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),ngPln,m3h8x4(:,31),heltab2x32(:,:,1235))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(21),n2h4(227))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1348),h0tab(:,1348),[26,1,4],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(49),m3h8x4(:,32),heltab2x32(:,:,1236))
  call Hloop_A_Q(ntryL,G0H4(49),26,0,G1H4(22),n2h4(228))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1349),h0tab(:,1349),[19,4,8],[nME,nME,nME],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,33),heltab2x32(:,:,1237))
  call Hloop_A_Q(ntryL,G0H4(49),19,nME,G1H4(23),n2h4(229))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1350),h0tab(:,1350),[19,4,8],[nME,nME,nME],3,1,wf8(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,18),G0H4(49),ngH,m3h8x4(:,34),heltab2x32(:,:,1238))
  call Hloop_Q_A(ntryL,G0H4(49),19,nME,G1H4(24),n2h4(230))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1351),h0tab(:,1351),[19,4,8],[nME,nME,nME],3,1,wf8(:,56))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,35),heltab2x32(:,:,1239))
  call Hloop_A_Q(ntryL,G0H4(49),19,nME,G1H4(27),n2h4(231))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1352),h0tab(:,1352),[19,4,8],[nME,nME,nME],3,1,wf8(:,56))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,56),G0H4(49),ngX,m3h8x4(:,36),heltab2x32(:,:,1240))
  call Hloop_Q_A(ntryL,G0H4(49),19,nME,G1H4(28),n2h4(232))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1353),h0tab(:,1353),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(49),m3h8x4(:,37),heltab2x32(:,:,1241))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1354),h0tab(:,1354),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(50),m3h8x4(:,38),heltab2x32(:,:,1242))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1355),h0tab(:,1355),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(51),m3h8x4(:,39),heltab2x32(:,:,1243))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1356),h0tab(:,1356),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(52),m3h8x4(:,40),heltab2x32(:,:,1244))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1357),h0tab(:,1357),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(53),m3h8x4(:,41),heltab2x32(:,:,1245))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1358),h0tab(:,1358),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(54),m3h8x4(:,42),heltab2x32(:,:,1246))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1359),h0tab(:,1359),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(55),m3h8x4(:,43),heltab2x32(:,:,1247))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1360),h0tab(:,1360),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(56),m3h8x4(:,44),heltab2x32(:,:,1248))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1361),h0tab(:,1361),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(57),m3h8x4(:,45),heltab2x32(:,:,1249))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1362),h0tab(:,1362),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,56),G0H4(58),m3h8x4(:,46),heltab2x32(:,:,1250))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1363),h0tab(:,1363),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(59),m3h8x4(:,47),heltab2x32(:,:,1251))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1364),h0tab(:,1364),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(60),m3h8x4(:,48),heltab2x32(:,:,1252))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1365),h0tab(:,1365),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(142),m3h8x4(:,49),heltab2x32(:,:,1253))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1366),h0tab(:,1366),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(138),m3h8x4(:,50),heltab2x32(:,:,1254))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1367),h0tab(:,1367),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(201),m3h8x4(:,51),heltab2x32(:,:,1255))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1368),h0tab(:,1368),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(197),m3h8x4(:,52),heltab2x32(:,:,1256))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1369),h0tab(:,1369),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(69),m3h8x4(:,53),heltab2x32(:,:,1257))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1370),h0tab(:,1370),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(72),m3h8x4(:,54),heltab2x32(:,:,1258))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1371),h0tab(:,1371),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(77),m3h8x4(:,55),heltab2x32(:,:,1259))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1372),h0tab(:,1372),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(132),m3h8x4(:,56),heltab2x32(:,:,1260))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1373),h0tab(:,1373),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(61),m3h8x4(:,57),heltab2x32(:,:,1261))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1374),h0tab(:,1374),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(62),m3h8x4(:,58),heltab2x32(:,:,1262))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1375),h0tab(:,1375),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(63),m3h8x4(:,59),heltab2x32(:,:,1263))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1376),h0tab(:,1376),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,18),G0H4(64),m3h8x4(:,60),heltab2x32(:,:,1264))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1377),h0tab(:,1377),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(227),m3h8x4(:,61),heltab2x32(:,:,1265))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1378),h0tab(:,1378),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(228),m3h8x4(:,62),heltab2x32(:,:,1266))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1379),h0tab(:,1379),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(229),m3h8x4(:,63),heltab2x32(:,:,1267))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1380),h0tab(:,1380),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(230),m3h8x4(:,64),heltab2x32(:,:,1268))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1381),h0tab(:,1381),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(239),m3h8x4(:,65),heltab2x32(:,:,1269))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1382),h0tab(:,1382),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(240),m3h8x4(:,66),heltab2x32(:,:,1270))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1383),h0tab(:,1383),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(241),m3h8x4(:,67),heltab2x32(:,:,1271))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1384),h0tab(:,1384),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,56))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,56),19,G1H4(242),m3h8x4(:,68),heltab2x32(:,:,1272))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1385),h0tab(:,1385),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,69),heltab2x32(:,:,1273))
  call Hloop_A_Q(ntryL,G0H4(65),19,nME,G1H4(251),n2h4(233))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1386),h0tab(:,1386),[19,4,8],[nME,nME,nME],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,70),heltab2x32(:,:,1274))
  call Hloop_Q_A(ntryL,G0H4(65),19,nME,G1H4(252),n2h4(234))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1387),h0tab(:,1387),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,71),heltab2x32(:,:,1275))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(253),n2h4(235))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1388),h0tab(:,1388),[19,4,8],[0,0,0],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,72),heltab2x32(:,:,1276))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(254),n2h4(236))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1389),h0tab(:,1389),[19,4,8],[nME,nME,nME],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,73),heltab2x32(:,:,1277))
  call Hloop_A_Q(ntryL,G0H4(65),19,nME,G1H4(30),n2h4(237))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1390),h0tab(:,1390),[19,4,8],[nME,nME,nME],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZl,m3h8x4(:,74),heltab2x32(:,:,1278))
  call Hloop_Q_A(ntryL,G0H4(65),19,nME,G1H4(70),n2h4(238))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1391),h0tab(:,1391),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,75),heltab2x32(:,:,1279))
  call Hloop_A_Q(ntryL,G0H4(65),19,0,G1H4(71),n2h4(239))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1392),h0tab(:,1392),[19,4,8],[0,0,0],3,1,wf8(:,58))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,58),G0H4(65),ngZu,m3h8x4(:,76),heltab2x32(:,:,1280))
  call Hloop_Q_A(ntryL,G0H4(65),19,0,G1H4(130),n2h4(240))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1393),h0tab(:,1393),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(168),m3h8x4(:,77),heltab2x32(:,:,1281))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1394),h0tab(:,1394),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(131),m3h8x4(:,78),heltab2x32(:,:,1282))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1395),h0tab(:,1395),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(8),m3h8x4(:,79),heltab2x32(:,:,1283))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1396),h0tab(:,1396),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(14),m3h8x4(:,80),heltab2x32(:,:,1284))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1397),h0tab(:,1397),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(20),m3h8x4(:,81),heltab2x32(:,:,1285))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1398),h0tab(:,1398),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(26),m3h8x4(:,82),heltab2x32(:,:,1286))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1399),h0tab(:,1399),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,57),G1H4(50),m3h8x4(:,83),heltab2x32(:,:,1287))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1400),h0tab(:,1400),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(38),m3h8x4(:,84),heltab2x32(:,:,1288))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1401),h0tab(:,1401),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,58),G1H4(32),m3h8x4(:,85),heltab2x32(:,:,1289))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1402),h0tab(:,1402),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(234),m3h8x4(:,86),heltab2x32(:,:,1290))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1403),h0tab(:,1403),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,58),G1H4(43),m3h8x4(:,87),heltab2x32(:,:,1291))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1404),h0tab(:,1404),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(150),m3h8x4(:,88),heltab2x32(:,:,1292))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1405),h0tab(:,1405),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(148),m3h8x4(:,89),heltab2x32(:,:,1293))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1406),h0tab(:,1406),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(136),m3h8x4(:,90),heltab2x32(:,:,1294))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1407),h0tab(:,1407),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(49),m3h8x4(:,91),heltab2x32(:,:,1295))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1408),h0tab(:,1408),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(55),m3h8x4(:,92),heltab2x32(:,:,1296))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1409),h0tab(:,1409),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(65),m3h8x4(:,93),heltab2x32(:,:,1297))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1410),h0tab(:,1410),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(66),m3h8x4(:,94),heltab2x32(:,:,1298))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1411),h0tab(:,1411),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(67),m3h8x4(:,95),heltab2x32(:,:,1299))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1412),h0tab(:,1412),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(68),m3h8x4(:,96),heltab2x32(:,:,1300))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1413),h0tab(:,1413),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(69),m3h8x4(:,97),heltab2x32(:,:,1301))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1414),h0tab(:,1414),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(70),m3h8x4(:,98),heltab2x32(:,:,1302))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1415),h0tab(:,1415),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(71),m3h8x4(:,99),heltab2x32(:,:,1303))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1416),h0tab(:,1416),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(72),m3h8x4(:,100),heltab2x32(:,:,1304))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1417),h0tab(:,1417),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(196),m3h8x4(:,101),heltab2x32(:,:,1305))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1418),h0tab(:,1418),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(192),m3h8x4(:,102),heltab2x32(:,:,1306))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1419),h0tab(:,1419),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(180),m3h8x4(:,103),heltab2x32(:,:,1307))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1420),h0tab(:,1420),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(56),m3h8x4(:,104),heltab2x32(:,:,1308))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1421),h0tab(:,1421),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(61),m3h8x4(:,105),heltab2x32(:,:,1309))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1422),h0tab(:,1422),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,57),19,G1H4(10),m3h8x4(:,106),heltab2x32(:,:,1310))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1423),h0tab(:,1423),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(214),m3h8x4(:,107),heltab2x32(:,:,1311))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1424),h0tab(:,1424),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,58),19,G1H4(210),m3h8x4(:,108),heltab2x32(:,:,1312))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1425),h0tab(:,1425),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(73),m3h8x4(:,109),heltab2x32(:,:,1313))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1426),h0tab(:,1426),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,57),G0H4(74),m3h8x4(:,110),heltab2x32(:,:,1314))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1427),h0tab(:,1427),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(75),m3h8x4(:,111),heltab2x32(:,:,1315))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1428),h0tab(:,1428),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,58),G0H4(76),m3h8x4(:,112),heltab2x32(:,:,1316))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1429),h0tab(:,1429),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(77),m3h8x4(:,113),heltab2x32(:,:,1317))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1430),h0tab(:,1430),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,57))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,57),G0H4(78),m3h8x4(:,114),heltab2x32(:,:,1318))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1431),h0tab(:,1431),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(79),m3h8x4(:,115),heltab2x32(:,:,1319))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1432),h0tab(:,1432),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,58))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,58),G0H4(80),m3h8x4(:,116),heltab2x32(:,:,1320))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1433),h0tab(:,1433),[21,2,8],[nMH,nME,nME],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(81),ngH,m3h8x4(:,117),heltab2x32(:,:,1321))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1434),h0tab(:,1434),[21,2,8],[nMZ,nME,nME],3,1,wf8(:,43))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,43),G0H4(82),ngX,m3h8x4(:,118),heltab2x32(:,:,1322))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1435),h0tab(:,1435),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(83),ngPnl,m3h8x4(:,119),heltab2x32(:,:,1323))
  call Hloop_Q_A(ntryL,G0H4(83),21,0,G1H4(62),n2h4(241))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1436),h0tab(:,1436),[21,2,8],[0,nME,nME],3,1,wf8(:,43))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,43),G0H4(83),m3h8x4(:,120),heltab2x32(:,:,1324))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1437),h0tab(:,1437),[21,2,8],[nMZ,nME,nME],3,1,wf8(:,43))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,43),G0H4(84),ngZl,m3h8x4(:,121),heltab2x32(:,:,1325))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1438),h0tab(:,1438),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,122),heltab2x32(:,:,1326))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(67),n2h4(242))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1439),h0tab(:,1439),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),ngPnl,m3h8x4(:,123),heltab2x32(:,:,1327))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(162),n2h4(243))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1440),h0tab(:,1440),[21,2,8],[0,nMW,nMW],3,1,wf8(:,43))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,124),heltab2x32(:,:,1328))
  call Hloop_Q_A(ntryL,G0H4(85),21,0,G1H4(144),n2h4(244))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1441),h0tab(:,1441),[25,2,4],[nMH,nME,nME],3,1,wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,37),G0H4(85),ngH,m3h8x4(:,125),heltab2x32(:,:,1329))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1442),h0tab(:,1442),[25,2,4],[nMZ,nME,nME],3,1,wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,37),G0H4(86),ngX,m3h8x4(:,126),heltab2x32(:,:,1330))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1443),h0tab(:,1443),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(87),ngPnl,m3h8x4(:,127),heltab2x32(:,:,1331))
  call Hloop_Q_A(ntryL,G0H4(87),25,0,G1H4(68),n2h4(245))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1444),h0tab(:,1444),[25,2,4],[0,nME,nME],3,1,wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,37),G0H4(87),m3h8x4(:,128),heltab2x32(:,:,1332))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1445),h0tab(:,1445),[25,2,4],[nMZ,nME,nME],3,1,wf8(:,37))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,37),G0H4(88),ngZl,m3h8x4(:,129),heltab2x32(:,:,1333))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1446),h0tab(:,1446),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),m3h8x4(:,130),heltab2x32(:,:,1334))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(74),n2h4(246))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1447),h0tab(:,1447),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),ngPnl,m3h8x4(:,131),heltab2x32(:,:,1335))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(86),n2h4(247))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1448),h0tab(:,1448),[25,2,4],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(89),m3h8x4(:,132),heltab2x32(:,:,1336))
  call Hloop_Q_A(ntryL,G0H4(89),25,0,G1H4(92),n2h4(248))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1449),h0tab(:,1449),[19,4,8],[nME,nME,nME],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,133),heltab2x32(:,:,1337))
  call Hloop_A_Q(ntryL,G0H4(89),19,nME,G1H4(97),n2h4(249))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1450),h0tab(:,1450),[19,4,8],[nME,nME,nME],3,1,wf8(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,19),G0H4(89),ngH,m3h8x4(:,134),heltab2x32(:,:,1338))
  call Hloop_Q_A(ntryL,G0H4(89),19,nME,G1H4(116),n2h4(250))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1451),h0tab(:,1451),[19,4,8],[nME,nME,nME],3,1,wf8(:,59))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,135),heltab2x32(:,:,1339))
  call Hloop_A_Q(ntryL,G0H4(89),19,nME,G1H4(98),n2h4(251))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1452),h0tab(:,1452),[19,4,8],[nME,nME,nME],3,1,wf8(:,59))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,59),G0H4(89),ngX,m3h8x4(:,136),heltab2x32(:,:,1340))
  call Hloop_Q_A(ntryL,G0H4(89),19,nME,G1H4(246),n2h4(252))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1453),h0tab(:,1453),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(89),m3h8x4(:,137),heltab2x32(:,:,1341))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1454),h0tab(:,1454),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(90),m3h8x4(:,138),heltab2x32(:,:,1342))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1455),h0tab(:,1455),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(91),m3h8x4(:,139),heltab2x32(:,:,1343))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1456),h0tab(:,1456),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(92),m3h8x4(:,140),heltab2x32(:,:,1344))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1457),h0tab(:,1457),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(93),m3h8x4(:,141),heltab2x32(:,:,1345))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1458),h0tab(:,1458),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(94),m3h8x4(:,142),heltab2x32(:,:,1346))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1459),h0tab(:,1459),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(95),m3h8x4(:,143),heltab2x32(:,:,1347))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1460),h0tab(:,1460),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(96),m3h8x4(:,144),heltab2x32(:,:,1348))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1461),h0tab(:,1461),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(97),m3h8x4(:,145),heltab2x32(:,:,1349))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1462),h0tab(:,1462),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,59),G0H4(98),m3h8x4(:,146),heltab2x32(:,:,1350))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1463),h0tab(:,1463),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(99),m3h8x4(:,147),heltab2x32(:,:,1351))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1464),h0tab(:,1464),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(100),m3h8x4(:,148),heltab2x32(:,:,1352))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1465),h0tab(:,1465),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(103),m3h8x4(:,149),heltab2x32(:,:,1353))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1466),h0tab(:,1466),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(109),m3h8x4(:,150),heltab2x32(:,:,1354))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1467),h0tab(:,1467),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(47),m3h8x4(:,151),heltab2x32(:,:,1355))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1468),h0tab(:,1468),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(35),m3h8x4(:,152),heltab2x32(:,:,1356))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1469),h0tab(:,1469),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(110),m3h8x4(:,153),heltab2x32(:,:,1357))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1470),h0tab(:,1470),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(115),m3h8x4(:,154),heltab2x32(:,:,1358))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1471),h0tab(:,1471),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(101),m3h8x4(:,155),heltab2x32(:,:,1359))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1472),h0tab(:,1472),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(99),m3h8x4(:,156),heltab2x32(:,:,1360))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1473),h0tab(:,1473),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(101),m3h8x4(:,157),heltab2x32(:,:,1361))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1474),h0tab(:,1474),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,19),G0H4(102),m3h8x4(:,158),heltab2x32(:,:,1362))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1475),h0tab(:,1475),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(103),m3h8x4(:,159),heltab2x32(:,:,1363))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1476),h0tab(:,1476),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,19),G0H4(104),m3h8x4(:,160),heltab2x32(:,:,1364))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1477),h0tab(:,1477),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(89),m3h8x4(:,161),heltab2x32(:,:,1365))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1478),h0tab(:,1478),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(87),m3h8x4(:,162),heltab2x32(:,:,1366))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1479),h0tab(:,1479),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(127),m3h8x4(:,163),heltab2x32(:,:,1367))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1480),h0tab(:,1480),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(119),m3h8x4(:,164),heltab2x32(:,:,1368))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1481),h0tab(:,1481),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(117),m3h8x4(:,165),heltab2x32(:,:,1369))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1482),h0tab(:,1482),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(107),m3h8x4(:,166),heltab2x32(:,:,1370))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1483),h0tab(:,1483),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(128),m3h8x4(:,167),heltab2x32(:,:,1371))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1484),h0tab(:,1484),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,59))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,59),19,G1H4(133),m3h8x4(:,168),heltab2x32(:,:,1372))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1485),h0tab(:,1485),[19,4,8],[nME,nME,nME],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,169),heltab2x32(:,:,1373))
  call Hloop_A_Q(ntryL,G0H4(105),19,nME,G1H4(65),n2h4(253))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1486),h0tab(:,1486),[19,4,8],[nME,nME,nME],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,170),heltab2x32(:,:,1374))
  call Hloop_Q_A(ntryL,G0H4(105),19,nME,G1H4(63),n2h4(254))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1487),h0tab(:,1487),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,171),heltab2x32(:,:,1375))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(134),n2h4(255))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1488),h0tab(:,1488),[19,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,172),heltab2x32(:,:,1376))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(139),n2h4(256))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1489),h0tab(:,1489),[19,4,8],[nME,nME,nME],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,173),heltab2x32(:,:,1377))
  call Hloop_A_Q(ntryL,G0H4(105),19,nME,G1H4(158),n2h4(257))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1490),h0tab(:,1490),[19,4,8],[nME,nME,nME],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZl,m3h8x4(:,174),heltab2x32(:,:,1378))
  call Hloop_Q_A(ntryL,G0H4(105),19,nME,G1H4(146),n2h4(258))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1491),h0tab(:,1491),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,175),heltab2x32(:,:,1379))
  call Hloop_A_Q(ntryL,G0H4(105),19,0,G1H4(174),n2h4(259))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1492),h0tab(:,1492),[19,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,61),G0H4(105),ngZu,m3h8x4(:,176),heltab2x32(:,:,1380))
  call Hloop_Q_A(ntryL,G0H4(105),19,0,G1H4(145),n2h4(260))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1493),h0tab(:,1493),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(151),m3h8x4(:,177),heltab2x32(:,:,1381))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1494),h0tab(:,1494),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(149),m3h8x4(:,178),heltab2x32(:,:,1382))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1495),h0tab(:,1495),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(135),m3h8x4(:,179),heltab2x32(:,:,1383))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1496),h0tab(:,1496),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(152),m3h8x4(:,180),heltab2x32(:,:,1384))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1497),h0tab(:,1497),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,60),G1H4(157),m3h8x4(:,181),heltab2x32(:,:,1385))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1498),h0tab(:,1498),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(163),m3h8x4(:,182),heltab2x32(:,:,1386))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1499),h0tab(:,1499),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,60),G1H4(191),m3h8x4(:,183),heltab2x32(:,:,1387))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1500),h0tab(:,1500),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(183),m3h8x4(:,184),heltab2x32(:,:,1388))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1501),h0tab(:,1501),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,61),G1H4(179),m3h8x4(:,185),heltab2x32(:,:,1389))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1502),h0tab(:,1502),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(164),m3h8x4(:,186),heltab2x32(:,:,1390))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1503),h0tab(:,1503),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,61),G1H4(9),m3h8x4(:,187),heltab2x32(:,:,1391))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1504),h0tab(:,1504),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(5),m3h8x4(:,188),heltab2x32(:,:,1392))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1505),h0tab(:,1505),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(213),m3h8x4(:,189),heltab2x32(:,:,1393))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1506),h0tab(:,1506),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(209),m3h8x4(:,190),heltab2x32(:,:,1394))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1507),h0tab(:,1507),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(175),m3h8x4(:,191),heltab2x32(:,:,1395))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1508),h0tab(:,1508),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(165),m3h8x4(:,192),heltab2x32(:,:,1396))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1509),h0tab(:,1509),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(105),m3h8x4(:,193),heltab2x32(:,:,1397))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1510),h0tab(:,1510),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(106),m3h8x4(:,194),heltab2x32(:,:,1398))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1511),h0tab(:,1511),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(107),m3h8x4(:,195),heltab2x32(:,:,1399))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1512),h0tab(:,1512),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(108),m3h8x4(:,196),heltab2x32(:,:,1400))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1513),h0tab(:,1513),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(109),m3h8x4(:,197),heltab2x32(:,:,1401))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1514),h0tab(:,1514),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(110),m3h8x4(:,198),heltab2x32(:,:,1402))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1515),h0tab(:,1515),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(111),m3h8x4(:,199),heltab2x32(:,:,1403))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1516),h0tab(:,1516),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(112),m3h8x4(:,200),heltab2x32(:,:,1404))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1517),h0tab(:,1517),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(161),m3h8x4(:,201),heltab2x32(:,:,1405))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1518),h0tab(:,1518),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(143),m3h8x4(:,202),heltab2x32(:,:,1406))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1519),h0tab(:,1519),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(181),m3h8x4(:,203),heltab2x32(:,:,1407))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1520),h0tab(:,1520),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(200),m3h8x4(:,204),heltab2x32(:,:,1408))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1521),h0tab(:,1521),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(188),m3h8x4(:,205),heltab2x32(:,:,1409))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1522),h0tab(:,1522),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,60),19,G1H4(182),m3h8x4(:,206),heltab2x32(:,:,1410))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1523),h0tab(:,1523),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(187),m3h8x4(:,207),heltab2x32(:,:,1411))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1524),h0tab(:,1524),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,61),19,G1H4(193),m3h8x4(:,208),heltab2x32(:,:,1412))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1525),h0tab(:,1525),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(113),m3h8x4(:,209),heltab2x32(:,:,1413))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1526),h0tab(:,1526),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,60),G0H4(114),m3h8x4(:,210),heltab2x32(:,:,1414))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1527),h0tab(:,1527),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(115),m3h8x4(:,211),heltab2x32(:,:,1415))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1528),h0tab(:,1528),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,61),G0H4(116),m3h8x4(:,212),heltab2x32(:,:,1416))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1529),h0tab(:,1529),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(117),m3h8x4(:,213),heltab2x32(:,:,1417))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1530),h0tab(:,1530),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,60))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,60),G0H4(118),m3h8x4(:,214),heltab2x32(:,:,1418))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1531),h0tab(:,1531),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(119),m3h8x4(:,215),heltab2x32(:,:,1419))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1532),h0tab(:,1532),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,61))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,61),G0H4(120),m3h8x4(:,216),heltab2x32(:,:,1420))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1533),h0tab(:,1533),[22,1,8],[nMH,nME,nME],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(121),ngH,m3h8x4(:,217),heltab2x32(:,:,1421))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1534),h0tab(:,1534),[22,1,8],[nMZ,nME,nME],3,1,wf8(:,39))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,39),G0H4(122),ngX,m3h8x4(:,218),heltab2x32(:,:,1422))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1535),h0tab(:,1535),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(123),ngPln,m3h8x4(:,219),heltab2x32(:,:,1423))
  call Hloop_A_Q(ntryL,G0H4(123),22,0,G1H4(52),n2h4(261))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1536),h0tab(:,1536),[22,1,8],[0,nME,nME],3,1,wf8(:,39))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,39),G0H4(123),m3h8x4(:,220),heltab2x32(:,:,1424))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1537),h0tab(:,1537),[22,1,8],[nMZ,nME,nME],3,1,wf8(:,39))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,39),G0H4(124),ngZl,m3h8x4(:,221),heltab2x32(:,:,1425))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1538),h0tab(:,1538),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),m3h8x4(:,222),heltab2x32(:,:,1426))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(48),n2h4(262))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1539),h0tab(:,1539),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),ngPln,m3h8x4(:,223),heltab2x32(:,:,1427))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(194),n2h4(263))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1540),h0tab(:,1540),[22,1,8],[0,nMW,nMW],3,1,wf8(:,39))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,39),G0H4(125),m3h8x4(:,224),heltab2x32(:,:,1428))
  call Hloop_A_Q(ntryL,G0H4(125),22,0,G1H4(199),n2h4(264))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1541),h0tab(:,1541),[26,1,4],[nMH,nME,nME],3,1,wf8(:,30))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,30),G0H4(125),ngH,m3h8x4(:,225),heltab2x32(:,:,1429))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1542),h0tab(:,1542),[26,1,4],[nMZ,nME,nME],3,1,wf8(:,30))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,30),G0H4(126),ngX,m3h8x4(:,226),heltab2x32(:,:,1430))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1543),h0tab(:,1543),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(127),ngPln,m3h8x4(:,227),heltab2x32(:,:,1431))
  call Hloop_A_Q(ntryL,G0H4(127),26,0,G1H4(205),n2h4(265))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1544),h0tab(:,1544),[26,1,4],[0,nME,nME],3,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,30),G0H4(127),m3h8x4(:,228),heltab2x32(:,:,1432))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1545),h0tab(:,1545),[26,1,4],[nMZ,nME,nME],3,1,wf8(:,30))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,30),G0H4(128),ngZl,m3h8x4(:,229),heltab2x32(:,:,1433))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1546),h0tab(:,1546),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),m3h8x4(:,230),heltab2x32(:,:,1434))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(102),n2h4(266))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1547),h0tab(:,1547),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),ngPln,m3h8x4(:,231),heltab2x32(:,:,1435))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(90),n2h4(267))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1548),h0tab(:,1548),[26,1,4],[0,nMW,nMW],3,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,30),G0H4(129),m3h8x4(:,232),heltab2x32(:,:,1436))
  call Hloop_A_Q(ntryL,G0H4(129),26,0,G1H4(88),n2h4(268))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(146),[G1H4(63),G1H4(246),G1H4(116),G1H4(70),G1H4(252) &
    ,G1H4(28),G1H4(24),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(152),[G1H4(149),G1H4(14),G1H4(131),G1H4(184),G0H4(90) &
    ,G0H4(50),G0H4(25),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(109),G1H4(197),G1H4(138),G1H4(6),G0H4(108) &
    ,G0H4(106),G0H4(68),G0H4(66),G0H4(20),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(107),G1H4(242),G1H4(240),G1H4(166),G0H4(120) &
    ,G0H4(118),G0H4(80),G0H4(78),G0H4(36),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(209),G1H4(55),G1H4(136),G1H4(80),G0H4(100) &
    ,G0H4(60),G0H4(30),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(65),G1H4(98),G1H4(97),G1H4(30),G1H4(251) &
    ,G1H4(27),G1H4(23),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(151),G1H4(8),G1H4(168),G1H4(140),G0H4(89) &
    ,G0H4(49),G0H4(33),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(103),G1H4(201),G1H4(142),G1H4(147),G0H4(107) &
    ,G0H4(105),G0H4(67),G0H4(65),G0H4(8),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(117),G1H4(241),G1H4(239),G1H4(195),G0H4(119) &
    ,G0H4(117),G0H4(79),G0H4(77),G0H4(24),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(213),G1H4(49),G1H4(148),G1H4(169),G0H4(99) &
    ,G0H4(59),G0H4(32),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(179),G1H4(191),G1H4(157),G1H4(43),G1H4(32) &
    ,G1H4(50),G1H4(20),G1H4(84),G0H4(97),G0H4(95),G0H4(93),G0H4(91),G0H4(57),G0H4(55),G0H4(53),G0H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(164),G1H4(183),G1H4(163),G1H4(150),G1H4(234) &
    ,G1H4(38),G1H4(26),G1H4(60),G0H4(98),G0H4(96),G0H4(94),G0H4(92),G0H4(58),G0H4(56),G0H4(54),G0H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(134),G1H4(71),G1H4(253),G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(139),G1H4(130),G1H4(254),G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G0H8(32),G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G0H8(8),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(57),[G0H8(9),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G0H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G0H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(134),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(159),[G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(164),[G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G0H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G0H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G0H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G0H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(110),G1H4(77),G1H4(69),G0H4(111),G0H4(109) &
    ,G0H4(71),G0H4(69),G0H4(4),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(115),G1H4(132),G1H4(72),G0H4(112),G0H4(110) &
    ,G0H4(72),G0H4(70),G0H4(16),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(89),G1H4(229),G1H4(227),G0H4(115),G0H4(113) &
    ,G0H4(75),G0H4(73),G0H4(13),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(87),G1H4(230),G1H4(228),G0H4(116),G0H4(114) &
    ,G0H4(76),G0H4(74),G0H4(5),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(181),G1H4(143),G1H4(161),G1H4(56),G1H4(180) &
    ,G1H4(192),G1H4(196),G0H4(102),G0H4(101),G0H4(62),G0H4(61),G0H4(38),G0H4(40),G0H4(28),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(187),G1H4(182),G1H4(188),G1H4(210),G1H4(214) &
    ,G1H4(10),G1H4(61),G0H4(104),G0H4(103),G0H4(64),G0H4(63),G0H4(7),G0H4(1),G0H4(9),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(71),[G0H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(75),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(99),[G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(103),[G0H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(35),[G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(138),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(142),[G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(180),[G1H16(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(184),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(4),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(10),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(50),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(52),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(54),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(56),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(14),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(24),[G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(26),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(28),[G0H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(30),[G0H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(32),[G0H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(39),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(40),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(69),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(74),[G1H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(81),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(82),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(83),[G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(84),[G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(144),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(112),[G1H16(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(116),[G1H16(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(122),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(124),[G1H16(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(108),[G0H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(110),[G0H16(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(126),[G1H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(128),[G1H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(147),[G1H16(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(148),[G1H16(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(152),[G1H16(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(158),[G1H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(160),[G1H16(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(162),[G1H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(164),[G1H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(121),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(122),[G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(123),[G0H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(124),[G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(181),[G1H16(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(182),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(192),[G1H16(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(194),[G1H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(162),[G0H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(164),[G0H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(196),[G1H16(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(200),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(215),[G1H16(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(216),[G1H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(219),[G1H16(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(220),[G1H16(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(230),[G1H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(232),[G1H16(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(236),[G1H16(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(85),[G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(86),[G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(87),[G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(88),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(251),[G1H16(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(252),[G1H16(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(255),[G1H16(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(256),[G1H16(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(260),[G1H16(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(262),[G1H16(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(44),[G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(264),[G1H16(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(266),[G1H16(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(281),[G1H16(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(282),[G1H16(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(285),[G1H16(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(286),[G1H16(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(292),[G1H16(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(294),[G1H16(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(296),[G1H16(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(298),[G1H16(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(125),[G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(126),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(127),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(128),[G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(22)])
  call Hloop_SQ_A(ntryL,G1H4(33),ex1(:),G1H2(334),ngPnl,m3h2x2(:,433),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(334),29,0,G2H2(376),n2h2(201))
  call Hloop_WQ_A(ntryL,G1H4(171),ex1(:),G1H2(141),m3h2x2(:,434),heltab2x4(:,:,466))
  call Hloop_Q_A(ntryL,G1H2(141),29,0,G2H2(132),n2h2(202))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(145),ngPln,m3h2x2(:,435),heltab2x4(:,:,467))
  call Hloop_A_Q(ntryL,G1H2(145),30,0,G2H2(128),n2h2(203))
  call Hloop_WA_Q(ntryL,G1H4(37),ex2(:),G1H2(157),m3h2x2(:,436),heltab2x4(:,:,468))
  call Hloop_A_Q(ntryL,G1H2(157),30,0,G2H2(106),n2h2(204))
  call Hloop_QV_A(ntryL,G1H4(146),ex3(:),G1H2(162),m3h2x2(:,437),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G1H2(162),23,nME,G2H2(25),n2h2(205))
  call Hloop_TV_S(ntryL,G1H4(152),19,ex3(:),4,G2H2(337),m3h2x2(:,438),heltab2x4(:,:,470))
  call Hloop_TV_S(ntryL,G1H4(35),19,ex3(:),4,G2H2(169),m3h2x2(:,439),heltab2x4(:,:,471))
  call Hloop_UV_W(ntryL,G1H4(133),19,ex3(:),4,G2H2(166),m3h2x2(:,440),heltab2x4(:,:,472))
  call Hloop_UV_W(ntryL,G1H4(165),19,ex3(:),4,G2H2(163),m3h2x2(:,441),heltab2x4(:,:,473))
  call Hloop_QV_A(ntryL,G1H4(104),ex4(:),G1H2(177),m3h2x2(:,442),heltab2x4(:,:,474))
  call Hloop_Q_A(ntryL,G1H2(177),27,nME,G2H2(162),n2h2(206))
  call Hloop_TV_S(ntryL,G1H4(51),19,ex4(:),8,G2H2(150),m3h2x2(:,443),heltab2x4(:,:,475))
  call Hloop_TV_S(ntryL,G1H4(121),19,ex4(:),8,G2H2(146),m3h2x2(:,444),heltab2x4(:,:,476))
  call Hloop_UV_W(ntryL,G1H4(122),19,ex4(:),8,G2H2(35),m3h2x2(:,445),heltab2x4(:,:,477))
  call Hloop_UV_W(ntryL,G1H4(105),19,ex4(:),8,G2H2(27),m3h2x2(:,446),heltab2x4(:,:,478))
  call Hloop_AV_Q(ntryL,G1H4(158),ex3(:),G1H2(178),m3h2x2(:,447),heltab2x4(:,:,479))
  call Hloop_A_Q(ntryL,G1H2(178),23,nME,G2H2(343),n2h2(207))
  call Hloop_SV_T(ntryL,G1H4(135),19,ex3(:),4,G2H2(176),m3h2x2(:,448),heltab2x4(:,:,480))
  call Hloop_SV_T(ntryL,G1H4(47),19,ex3(:),4,G2H2(172),m3h2x2(:,449),heltab2x4(:,:,481))
  call Hloop_UW_V(ntryL,G1H4(128),19,ex3(:),4,G2H2(158),m3h2x2(:,450),heltab2x4(:,:,482))
  call Hloop_UW_V(ntryL,G1H4(175),19,ex3(:),4,G2H2(155),m3h2x2(:,451),heltab2x4(:,:,483))
  call Hloop_AV_Q(ntryL,G1H4(170),ex4(:),G1H2(206),m3h2x2(:,452),heltab2x4(:,:,484))
  call Hloop_A_Q(ntryL,G1H2(206),27,nME,G2H2(154),n2h2(208))
  call Hloop_SV_T(ntryL,G1H4(176),19,ex4(:),8,G2H2(151),m3h2x2(:,453),heltab2x4(:,:,485))
  call Hloop_SV_T(ntryL,G1H4(222),19,ex4(:),8,G2H2(37),m3h2x2(:,454),heltab2x4(:,:,486))
  call Hloop_UW_V(ntryL,G1H4(36),19,ex4(:),8,G2H2(29),m3h2x2(:,455),heltab2x4(:,:,487))
  call Hloop_UW_V(ntryL,G1H4(100),19,ex4(:),8,G2H2(400),m3h2x2(:,456),heltab2x4(:,:,488))
  call Hloop_CV_D(ntryL,G1H4(120),19,ex4(:),8,G2H2(143),m3h2x2(:,457),heltab2x4(:,:,489))
  call Hloop_DV_C(ntryL,G1H4(217),19,ex4(:),G2H2(137),m3h2x2(:,458),heltab2x4(:,:,490))
  call Hloop_QV_A(ntryL,G1H4(41),ex4(:),G1H2(210),m3h2x2(:,459),heltab2x4(:,:,491))
  call Hloop_Q_A(ntryL,G1H2(210),27,0,G2H2(124),n2h2(209))
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(233),m3h2x2(:,460),heltab2x4(:,:,492))
  call Hloop_A_Q(ntryL,G1H2(233),27,0,G2H2(31),n2h2(210))
  call Hloop_DV_C(ntryL,G1H4(9),19,ex3(:),G2H2(373),m3h2x2(:,461),heltab2x4(:,:,493))
  call Hloop_CV_D(ntryL,G1H4(5),19,ex3(:),4,G2H2(129),m3h2x2(:,462),heltab2x4(:,:,494))
  call Hloop_AV_Q(ntryL,G1H4(174),ex3(:),G1H2(253),m3h2x2(:,463),heltab2x4(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(253),23,0,G2H2(125),n2h2(211))
  call Hloop_QV_A(ntryL,G1H4(145),ex3(:),G1H2(254),m3h2x2(:,464),heltab2x4(:,:,496))
  call Hloop_Q_A(ntryL,G1H2(254),23,0,G2H2(103),n2h2(212))
  call Hloop_QS_A(ntryL,G1H8(23),wf4(:,36),G1H2(286),ngH,m3h4x2(:,183),heltab2x8(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(286),23,nME,G2H2(33),n2h2(213))
  call Hloop_AS_Q(ntryL,G1H8(30),wf4(:,36),G1H2(287),ngH,m3h4x2(:,184),heltab2x8(:,:,408))
  call Hloop_A_Q(ntryL,G1H2(287),23,nME,G2H2(397),n2h2(214))
  call Hloop_QS_A(ntryL,G1H8(43),wf4(:,37),G1H2(296),ngX,m3h4x2(:,185),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(296),23,nME,G2H2(140),n2h2(215))
  call Hloop_AS_Q(ntryL,G1H8(56),wf4(:,37),G1H2(313),ngX,m3h4x2(:,186),heltab2x8(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(313),23,nME,G2H2(136),n2h2(216))
  call Hloop_ST_V(ntryL,G1H8(14),20,wf4(:,36),3,G2H2(120),m3h4x2(:,187),heltab2x8(:,:,411))
  call Hloop_ST_V(ntryL,G1H8(20),20,wf4(:,37),3,G2H2(39),m3h4x2(:,188),heltab2x8(:,:,412))
  call Hloop_VT_S(ntryL,G1H8(34),20,wf4(:,36),3,G2H2(352),m3h4x2(:,189),heltab2x8(:,:,413))
  call Hloop_VT_S(ntryL,G1H8(57),20,wf4(:,37),3,G2H2(334),m3h4x2(:,190),heltab2x8(:,:,414))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,13),G1H2(314),m3h4x2(:,191),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(314),23,nME,G2H2(328),n2h2(217))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,13),G1H2(319),m3h4x2(:,192),heltab2x8(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(319),23,nME,G2H2(55),n2h2(218))
  call Hloop_QV_A(ntryL,G1H8(47),wf4(:,13),G1H2(330),m3h4x2(:,193),heltab2x8(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(330),23,0,G2H2(51),n2h2(219))
  call Hloop_AV_Q(ntryL,G1H8(67),wf4(:,13),G1H2(14),m3h4x2(:,194),heltab2x8(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(14),23,0,G2H2(47),n2h2(220))
  call Hloop_QZ_A(ntryL,G1H8(72),wf4(:,14),G1H2(20),ngZl,m3h4x2(:,195),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(20),23,nME,G2H2(43),n2h2(221))
  call Hloop_AZ_Q(ntryL,G1H8(95),wf4(:,14),G1H2(44),ngZl,m3h4x2(:,196),heltab2x8(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(44),23,nME,G2H2(59),n2h2(222))
  call Hloop_QZ_A(ntryL,G1H8(105),wf4(:,14),G1H2(50),ngZu,m3h4x2(:,197),heltab2x8(:,:,421))
  call Hloop_Q_A(ntryL,G1H2(50),23,0,G2H2(178),n2h2(223))
  call Hloop_AZ_Q(ntryL,G1H8(115),wf4(:,14),G1H2(62),ngZu,m3h4x2(:,198),heltab2x8(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(62),23,0,G2H2(63),n2h2(224))
  call Hloop_TV_S(ntryL,G1H8(130),20,wf4(:,13),3,G2H2(67),m3h4x2(:,199),heltab2x8(:,:,423))
  call Hloop_SV_T(ntryL,G1H8(2),20,wf4(:,13),3,G2H2(71),m3h4x2(:,200),heltab2x8(:,:,424))
  call Hloop_TV_S(ntryL,G1H8(51),20,wf4(:,14),3,G2H2(74),m3h4x2(:,201),heltab2x8(:,:,425))
  call Hloop_SV_T(ntryL,G1H8(134),20,wf4(:,14),3,G2H2(77),m3h4x2(:,202),heltab2x8(:,:,426))
  call Hloop_CV_D(ntryL,G1H8(139),20,wf4(:,13),3,G2H2(81),m3h4x2(:,203),heltab2x8(:,:,427))
  call Hloop_DV_C(ntryL,G1H8(144),20,wf4(:,13),G2H2(349),m3h4x2(:,204),heltab2x8(:,:,428))
  call Hloop_CV_D(ntryL,G1H8(149),20,wf4(:,14),3,G2H2(331),m3h4x2(:,205),heltab2x8(:,:,429))
  call Hloop_DV_C(ntryL,G1H8(154),20,wf4(:,14),G2H2(325),m3h4x2(:,206),heltab2x8(:,:,430))
  call Hloop_UV_W(ntryL,G1H8(159),20,wf4(:,13),3,G2H2(97),m3h4x2(:,207),heltab2x8(:,:,431))
  call Hloop_UW_V(ntryL,G1H8(164),20,wf4(:,13),3,G2H2(93),m3h4x2(:,208),heltab2x8(:,:,432))
  call Hloop_UV_W(ntryL,G1H8(169),20,wf4(:,14),3,G2H2(89),m3h4x2(:,209),heltab2x8(:,:,433))
  call Hloop_UW_V(ntryL,G1H8(174),20,wf4(:,14),3,G2H2(85),m3h4x2(:,210),heltab2x8(:,:,434))
  call Hloop_SA_Q(ntryL,G1H8(77),ex2(:),G1H4(206),ngPln,m3h2x4(:,225),heltab2x8(:,:,435))
  call Hloop_A_Q(ntryL,G1H4(206),22,0,G2H4(10),n2h4(269))
  call Hloop_WA_Q(ntryL,G1H8(82),ex2(:),G1H4(211),m3h2x4(:,226),heltab2x8(:,:,436))
  call Hloop_A_Q(ntryL,G1H4(211),22,0,G2H4(25),n2h4(270))
  call Hloop_SQ_A(ntryL,G1H8(87),ex1(:),G1H4(118),ngPnl,m3h2x4(:,227),heltab2x8(:,:,437))
  call Hloop_Q_A(ntryL,G1H4(118),21,0,G2H4(42),n2h4(271))
  call Hloop_WQ_A(ntryL,G1H8(92),ex1(:),G1H4(108),m3h2x4(:,228),heltab2x8(:,:,438))
  call Hloop_Q_A(ntryL,G1H4(108),21,0,G2H4(54),n2h4(272))
  call Hloop_VV_S(ntryL,G1H4(101),ex3(:),G1H2(106),m3h2x2(:,465),heltab2x4(:,:,497))
  call Hloop_VV_S(ntryL,G1H4(99),ex3(:),G1H2(117),m3h2x2(:,466),heltab2x4(:,:,498))
  call Hloop_SV_V(ntryL,G1H4(127),ex3(:),G1H2(128),m3h2x2(:,467),heltab2x4(:,:,499))
  call Hloop_SV_V(ntryL,G1H4(119),ex3(:),G1H2(182),m3h2x2(:,468),heltab2x4(:,:,500))
  call Hloop_SV_V(ntryL,G1H4(200),ex3(:),G1H2(204),m3h2x2(:,469),heltab2x4(:,:,501))
  call Hloop_VV_S(ntryL,G1H4(193),ex3(:),G1H2(215),m3h2x2(:,470),heltab2x4(:,:,502))
  call Hloop_TV_S(ntryL,G0H16(17),16,ex3(:),4,G1H8(28),m3h2x8(:,323),heltab2x16(:,:,591))
  call Hloop_SV_T(ntryL,G0H16(19),16,ex3(:),4,G1H8(29),m3h2x8(:,324),heltab2x16(:,:,592))
  call Hloop_TV_S(ntryL,G0H16(21),16,ex3(:),4,G1H8(31),m3h2x8(:,325),heltab2x16(:,:,593))
  call Hloop_SV_T(ntryL,G0H16(23),16,ex3(:),4,G1H8(32),m3h2x8(:,326),heltab2x16(:,:,594))
  call Hloop_SV_V(ntryL,G1H16(12),ex3(:),G1H8(41),m3h2x8(:,327),heltab2x16(:,:,595))
  call Hloop_SV_V(ntryL,G1H16(16),ex3(:),G1H8(42),m3h2x8(:,328),heltab2x16(:,:,596))
  call Hloop_VV_S(ntryL,G1H16(35),ex3(:),G1H8(44),m3h2x8(:,329),heltab2x16(:,:,597))
  call Hloop_VV_S(ntryL,G1H16(54),ex3(:),G1H8(53),m3h2x8(:,330),heltab2x16(:,:,598))
  call Hloop_UV_W(ntryL,G0H16(33),16,ex3(:),4,G1H8(54),m3h2x8(:,331),heltab2x16(:,:,599))
  call Hloop_UW_V(ntryL,G0H16(35),16,ex3(:),4,G1H8(55),m3h2x8(:,332),heltab2x16(:,:,600))
  call Hloop_UV_W(ntryL,G0H16(37),16,ex3(:),4,G1H8(65),m3h2x8(:,333),heltab2x16(:,:,601))
  call Hloop_UW_V(ntryL,G0H16(39),16,ex3(:),4,G1H8(1),m3h2x8(:,334),heltab2x16(:,:,602))
  call Hloop_TV_S(ntryL,G1H16(57),16,ex3(:),4,G2H8(5),m3h2x8(:,335),heltab2x16(:,:,603))
  call Hloop_SV_T(ntryL,G1H16(58),16,ex3(:),4,G2H8(6),m3h2x8(:,336),heltab2x16(:,:,604))
  call Hloop_TV_S(ntryL,G1H16(95),16,ex3(:),4,G2H8(7),m3h2x8(:,337),heltab2x16(:,:,605))
  call Hloop_SV_T(ntryL,G1H16(96),16,ex3(:),4,G2H8(8),m3h2x8(:,338),heltab2x16(:,:,606))
  call Hloop_UV_W(ntryL,G1H16(99),16,ex3(:),4,G2H8(9),m3h2x8(:,339),heltab2x16(:,:,607))
  call Hloop_UW_V(ntryL,G1H16(100),16,ex3(:),4,G2H8(12),m3h2x8(:,340),heltab2x16(:,:,608))
  call Hloop_UV_W(ntryL,G1H16(109),16,ex3(:),4,G2H8(10),m3h2x8(:,341),heltab2x16(:,:,609))
  call Hloop_UW_V(ntryL,G1H16(119),16,ex3(:),4,G2H8(11),m3h2x8(:,342),heltab2x16(:,:,610))
  call Hloop_VV_S(ntryL,G0H16(71),ex3(:),G0H8(32),m3h2x8(:,343),heltab2x16(:,:,611))
  call Hloop_VV_S(ntryL,G0H16(75),ex3(:),G0H8(31),m3h2x8(:,344),heltab2x16(:,:,612))
  call Hloop_SV_V(ntryL,G0H16(99),ex3(:),G0H8(8),m3h2x8(:,345),heltab2x16(:,:,613))
  call Hloop_SV_V(ntryL,G0H16(103),ex3(:),G0H8(16),m3h2x8(:,346),heltab2x16(:,:,614))
  call Hloop_SS_S(ntryL,G0H8(11),wf4(:,36),G0H2(1),m3h4x2(:,211),heltab2x8(:,:,439))
  call Hloop_SS_S(ntryL,G0H8(3),wf4(:,36),G0H2(2),m3h4x2(:,212),heltab2x8(:,:,440))
  call Hloop_VS_V(ntryL,G0H8(4),wf4(:,36),G0H2(3),m3h4x2(:,213),heltab2x8(:,:,441))
  call Hloop_VS_V(ntryL,G0H8(5),wf4(:,36),G0H2(4),m3h4x2(:,214),heltab2x8(:,:,442))
  call Hloop_ST_V(ntryL,G0H8(15),24,wf4(:,36),3,G1H2(269),m3h4x2(:,215),heltab2x8(:,:,443))
  call Hloop_ST_V(ntryL,G0H8(35),24,wf4(:,37),3,G1H2(285),m3h4x2(:,216),heltab2x8(:,:,444))
  call Hloop_VT_S(ntryL,G0H8(13),24,wf4(:,36),3,G1H2(312),m3h4x2(:,217),heltab2x8(:,:,445))
  call Hloop_VT_S(ntryL,G0H8(6),24,wf4(:,37),3,G1H2(232),m3h4x2(:,218),heltab2x8(:,:,446))
  call Hloop_TV_S(ntryL,G0H8(33),24,wf4(:,13),3,G1H2(51),m3h4x2(:,219),heltab2x8(:,:,447))
  call Hloop_SV_T(ntryL,G0H8(37),24,wf4(:,13),3,G1H2(52),m3h4x2(:,220),heltab2x8(:,:,448))
  call Hloop_TV_S(ntryL,G0H8(38),24,wf4(:,14),3,G1H2(275),m3h4x2(:,221),heltab2x8(:,:,449))
  call Hloop_SV_T(ntryL,G0H8(39),24,wf4(:,14),3,G1H2(64),m3h4x2(:,222),heltab2x8(:,:,450))
  call Hloop_UV_W(ntryL,G0H8(40),24,wf4(:,13),3,G1H2(291),m3h4x2(:,223),heltab2x8(:,:,451))
  call Hloop_UW_V(ntryL,G0H8(41),24,wf4(:,13),3,G1H2(75),m3h4x2(:,224),heltab2x8(:,:,452))
  call Hloop_UV_W(ntryL,G0H8(17),24,wf4(:,14),3,G1H2(76),m3h4x2(:,225),heltab2x8(:,:,453))
  call Hloop_UW_V(ntryL,G0H8(18),24,wf4(:,14),3,G1H2(39),m3h4x2(:,226),heltab2x8(:,:,454))
  call Hloop_SV_V(ntryL,G0H8(20),wf4(:,13),G0H2(5),m3h4x2(:,227),heltab2x8(:,:,455))
  call Hloop_SV_V(ntryL,G0H8(22),wf4(:,14),G0H2(6),m3h4x2(:,228),heltab2x8(:,:,456))
  call Hloop_VV_S(ntryL,G0H8(24),wf4(:,13),G0H2(7),m3h4x2(:,229),heltab2x8(:,:,457))
  call Hloop_VV_S(ntryL,G0H8(26),wf4(:,14),G0H2(8),m3h4x2(:,230),heltab2x8(:,:,458))
  call Hloop_VVS_S(ntryL,G0H16(125),ex3(:),wf4(:,36),G0H2(9),m4h2x4x2(:,1),heltab3x16(:,:,1))
  call Hloop_VVS_S(ntryL,G0H16(127),ex3(:),wf4(:,36),G0H2(10),m4h2x4x2(:,2),heltab3x16(:,:,2))
  call Hloop_VVS_S(ntryL,G0H16(129),ex3(:),wf4(:,37),G0H2(11),m4h2x4x2(:,3),heltab3x16(:,:,3))
  call Hloop_VVS_S(ntryL,G0H16(131),ex3(:),wf4(:,37),G0H2(12),m4h2x4x2(:,4),heltab3x16(:,:,4))
  call Hloop_SSV_V(ntryL,G1H16(138),wf4(:,36),ex3(:),G1H2(172),m4h4x2x2(:,1),heltab3x16(:,:,5))
  call Hloop_SSV_V(ntryL,G1H16(142),wf4(:,37),ex3(:),G1H2(28),m4h4x2x2(:,2),heltab3x16(:,:,6))
  call Hloop_VVS_S(ntryL,G1H16(180),ex3(:),wf4(:,36),G1H2(46),m4h2x4x2(:,5),heltab3x16(:,:,7))
  call Hloop_VVS_S(ntryL,G1H16(184),ex3(:),wf4(:,37),G1H2(91),m4h2x4x2(:,6),heltab3x16(:,:,8))
  call Hloop_SSV_V(ntryL,G0H16(153),wf4(:,36),ex3(:),G0H2(13),m4h4x2x2(:,3),heltab3x16(:,:,9))
  call Hloop_SSV_V(ntryL,G0H16(155),wf4(:,36),ex3(:),G0H2(14),m4h4x2x2(:,4),heltab3x16(:,:,10))
  call Hloop_SSV_V(ntryL,G0H16(157),wf4(:,37),ex3(:),G0H2(15),m4h4x2x2(:,5),heltab3x16(:,:,11))
  call Hloop_SSV_V(ntryL,G0H16(159),wf4(:,37),ex3(:),G0H2(16),m4h4x2x2(:,6),heltab3x16(:,:,12))
  call Hloop_SVV_S(ntryL,G1H16(197),ex3(:),wf4(:,13),G1H2(33),m4h2x4x2(:,7),heltab3x16(:,:,13))
  call Hloop_SVV_S(ntryL,G1H16(199),ex3(:),wf4(:,13),G1H2(37),m4h2x4x2(:,8),heltab3x16(:,:,14))
  call Hloop_SVV_S(ntryL,G1H16(221),ex3(:),wf4(:,14),G1H2(43),m4h2x4x2(:,9),heltab3x16(:,:,15))
  call Hloop_SVV_S(ntryL,G1H16(222),ex3(:),wf4(:,14),G1H2(127),m4h2x4x2(:,10),heltab3x16(:,:,16))
  call Hloop_VWW_V(ntryL,G1H16(225),ex3(:),wf4(:,13),G1H2(116),m4h2x4x2(:,11),heltab3x16(:,:,17))
  call Hloop_VWW_V(ntryL,G1H16(226),ex3(:),wf4(:,13),G1H2(149),m4h2x4x2(:,12),heltab3x16(:,:,18))
  call Hloop_VWW_V(ntryL,G1H16(1),ex3(:),wf4(:,14),G1H2(1),m4h2x4x2(:,13),heltab3x16(:,:,19))
  call Hloop_VWW_V(ntryL,G1H16(2),ex3(:),wf4(:,14),G1H2(81),m4h2x4x2(:,14),heltab3x16(:,:,20))
  call Hloop_SVV_S(ntryL,G0H16(2),ex3(:),wf4(:,13),G0H2(17),m4h2x4x2(:,15),heltab3x16(:,:,21))
  call Hloop_SVV_S(ntryL,G0H16(4),ex3(:),wf4(:,14),G0H2(18),m4h2x4x2(:,16),heltab3x16(:,:,22))
  call Hloop_VWW_V(ntryL,G0H16(10),ex3(:),wf4(:,13),G0H2(19),m4h2x4x2(:,17),heltab3x16(:,:,23))
  call Hloop_VWW_V(ntryL,G0H16(12),ex3(:),wf4(:,14),G0H2(20),m4h2x4x2(:,18),heltab3x16(:,:,24))
  call Hloop_SS_S(ntryL,G0H8(27),wf4(:,36),G0H2(21),m3h4x2(:,231),heltab2x8(:,:,459))
  call Hloop_SS_S(ntryL,G0H8(28),wf4(:,36),G0H2(22),m3h4x2(:,232),heltab2x8(:,:,460))
  call Hloop_VS_V(ntryL,G0H8(29),wf4(:,36),G0H2(23),m3h4x2(:,233),heltab2x8(:,:,461))
  call Hloop_VS_V(ntryL,G0H8(30),wf4(:,36),G0H2(24),m3h4x2(:,234),heltab2x8(:,:,462))
  call Hloop_SV_V(ntryL,G0H8(50),wf4(:,13),G0H2(25),m3h4x2(:,235),heltab2x8(:,:,463))
  call Hloop_SV_V(ntryL,G0H8(52),wf4(:,14),G0H2(26),m3h4x2(:,236),heltab2x8(:,:,464))
  call Hloop_VV_S(ntryL,G0H8(54),wf4(:,13),G0H2(27),m3h4x2(:,237),heltab2x8(:,:,465))
  call Hloop_VV_S(ntryL,G0H8(56),wf4(:,14),G0H2(28),m3h4x2(:,238),heltab2x8(:,:,466))
  call Hloop_SS_S(ntryL,G1H16(4),wf4(:,36),G1H4(106),m3h4x4(:,269),heltab2x16(:,:,615))
  call Hloop_VS_V(ntryL,G1H16(6),wf4(:,36),G1H4(212),m3h4x4(:,270),heltab2x16(:,:,616))
  call Hloop_VT_S(ntryL,G0H16(14),16,wf4(:,36),3,G1H4(66),m3h4x4(:,271),heltab2x16(:,:,617))
  call Hloop_VT_S(ntryL,G0H16(16),16,wf4(:,37),3,G1H4(64),m3h4x4(:,272),heltab2x16(:,:,618))
  call Hloop_ST_V(ntryL,G0H16(20),16,wf4(:,36),3,G1H4(46),m3h4x4(:,273),heltab2x16(:,:,619))
  call Hloop_ST_V(ntryL,G0H16(24),16,wf4(:,37),3,G1H4(218),m3h4x4(:,274),heltab2x16(:,:,620))
  call Hloop_SV_T(ntryL,G1H16(7),16,wf4(:,13),3,G2H4(66),m3h4x4(:,275),heltab2x16(:,:,621))
  call Hloop_TV_S(ntryL,G1H16(8),16,wf4(:,13),3,G2H4(117),m3h4x4(:,276),heltab2x16(:,:,622))
  call Hloop_SV_T(ntryL,G1H16(9),16,wf4(:,14),3,G2H4(118),m3h4x4(:,277),heltab2x16(:,:,623))
  call Hloop_TV_S(ntryL,G1H16(10),16,wf4(:,14),3,G2H4(119),m3h4x4(:,278),heltab2x16(:,:,624))
  call Hloop_UW_V(ntryL,G1H16(13),16,wf4(:,13),3,G2H4(79),m3h4x4(:,279),heltab2x16(:,:,625))
  call Hloop_UV_W(ntryL,G1H16(14),16,wf4(:,13),3,G2H4(120),m3h4x4(:,280),heltab2x16(:,:,626))
  call Hloop_UW_V(ntryL,G1H16(17),16,wf4(:,14),3,G2H4(84),m3h4x4(:,281),heltab2x16(:,:,627))
  call Hloop_UV_W(ntryL,G1H16(18),16,wf4(:,14),3,G2H4(121),m3h4x4(:,282),heltab2x16(:,:,628))
  call Hloop_VV_S(ntryL,G0H16(26),wf4(:,13),G0H4(129),m3h4x4(:,283),heltab2x16(:,:,629))
  call Hloop_VV_S(ntryL,G0H16(28),wf4(:,14),G0H4(90),m3h4x4(:,284),heltab2x16(:,:,630))
  call Hloop_SV_V(ntryL,G0H16(30),wf4(:,13),G0H4(50),m3h4x4(:,285),heltab2x16(:,:,631))
  call Hloop_SV_V(ntryL,G0H16(32),wf4(:,14),G0H4(25),m3h4x4(:,286),heltab2x16(:,:,632))
  call Hloop_SA_Q(ntryL,G0H8(57),ex2(:),G0H4(34),ngPln,m3h2x4(:,229),heltab2x8(:,:,467))
  call Hloop_A_Q(ntryL,G0H4(34),26,0,G1H4(39),n2h4(273))
  call Hloop_WA_Q(ntryL,G0H8(58),ex2(:),G0H4(108),m3h2x4(:,230),heltab2x8(:,:,468))
  call Hloop_A_Q(ntryL,G0H4(108),26,0,G1H4(42),n2h4(274))
  call Hloop_SQ_A(ntryL,G0H8(59),ex1(:),G0H4(106),ngPnl,m3h2x4(:,231),heltab2x8(:,:,469))
  call Hloop_Q_A(ntryL,G0H4(106),25,0,G1H4(40),n2h4(275))
  call Hloop_WQ_A(ntryL,G0H8(60),ex1(:),G0H4(68),m3h2x4(:,232),heltab2x8(:,:,470))
  call Hloop_Q_A(ntryL,G0H4(68),25,0,G1H4(95),n2h4(276))
  call Hloop_QA_S(ntryL,G1H8(99),ex2(:),G1H4(83),ngPln,m3h2x4(:,233),heltab2x8(:,:,471))
  call Hloop_QA_W(ntryL,G1H8(100),ex2(:),G1H4(81),m3h2x4(:,234),heltab2x8(:,:,472))
  call Hloop_AQ_S(ntryL,G1H8(101),ex1(:),G1H4(96),ngPnl,m3h2x4(:,235),heltab2x8(:,:,473))
  call Hloop_AQ_W(ntryL,G1H8(102),ex1(:),G1H4(94),m3h2x4(:,236),heltab2x8(:,:,474))
  call Hloop_AQ_S(ntryL,G1H16(19),wf4(:,3),G1H4(82),ngH,m3h4x4(:,287),heltab2x16(:,:,633))
  call Hloop_AQ_S(ntryL,G1H16(20),wf4(:,3),G1H4(59),ngX,m3h4x4(:,288),heltab2x16(:,:,634))
  call Hloop_SQ_A(ntryL,G1H16(21),wf4(:,3),G1H4(58),ngPnl,m3h4x4(:,289),heltab2x16(:,:,635))
  call Hloop_Q_A(ntryL,G1H4(58),21,0,G2H4(122),n2h4(277))
  call Hloop_AQ_V(ntryL,G1H16(22),wf4(:,3),G1H4(53),m3h4x4(:,290),heltab2x16(:,:,636))
  call Hloop_AQ_Z(ntryL,G1H16(23),wf4(:,3),G1H4(57),ngZl,m3h4x4(:,291),heltab2x16(:,:,637))
  call Hloop_SQ_A(ntryL,G0H16(45),wf4(:,3),G0H4(66),ngPnl,m3h4x4(:,292),heltab2x16(:,:,638))
  call Hloop_Q_A(ntryL,G0H4(66),21,0,G1H4(54),n2h4(278))
  call Hloop_WQ_A(ntryL,G0H16(46),wf4(:,3),G0H4(20),m3h4x4(:,293),heltab2x16(:,:,639))
  call Hloop_Q_A(ntryL,G0H4(20),21,0,G1H4(125),n2h4(279))
  call Hloop_WQ_A(ntryL,G1H16(24),wf4(:,3),G1H4(123),m3h4x4(:,294),heltab2x16(:,:,640))
  call Hloop_Q_A(ntryL,G1H4(123),21,0,G2H4(123),n2h4(280))
  call Hloop_SQ_A(ntryL,G0H8(65),wf4(:,3),G0H2(29),ngH,m3h4x2(:,239),heltab2x8(:,:,475))
  call Hloop_Q_A(ntryL,G0H2(29),23,nME,G1H2(2),n2h2(225))
  call Hloop_SQ_A(ntryL,G0H8(66),wf4(:,3),G0H2(29),ngX,m3h4x2(:,240),heltab2x8(:,:,476))
  call Hloop_Q_A(ntryL,G0H2(29),23,nME,G1H2(86),n2h2(226))
  call Hloop_AQ_S(ntryL,G1H8(109),wf4(:,3),G1H2(31),ngPnl,m3h4x2(:,241),heltab2x8(:,:,477))
  call Hloop_VQ_A(ntryL,G0H8(67),wf4(:,3),G0H2(29),m3h4x2(:,242),heltab2x8(:,:,478))
  call Hloop_Q_A(ntryL,G0H2(29),23,nME,G1H2(181),n2h2(227))
  call Hloop_ZQ_A(ntryL,G0H8(68),wf4(:,3),G0H2(29),ngZl,m3h4x2(:,243),heltab2x8(:,:,479))
  call Hloop_Q_A(ntryL,G0H2(29),23,nME,G1H2(179),n2h2(228))
  call Hloop_AQ_S(ntryL,G1H8(110),wf4(:,3),G1H2(214),ngPnl,m3h4x2(:,244),heltab2x8(:,:,480))
  call Hloop_AQ_W(ntryL,G1H8(111),wf4(:,3),G1H2(3),m3h4x2(:,245),heltab2x8(:,:,481))
  call Hloop_AQ_W(ntryL,G1H8(112),wf4(:,3),G1H2(35),m3h4x2(:,246),heltab2x8(:,:,482))
  call Hloop_AS_Q(ntryL,G1H16(26),wf8(:,10),G1H2(49),ngH,m3h8x2(:,1),heltab2x16(:,:,641))
  call Hloop_A_Q(ntryL,G1H2(49),23,nME,G2H2(73),n2h2(229))
  call Hloop_QS_A(ntryL,G1H16(27),wf8(:,10),G1H2(4),ngH,m3h8x2(:,2),heltab2x16(:,:,642))
  call Hloop_Q_A(ntryL,G1H2(4),23,nME,G2H2(101),n2h2(230))
  call Hloop_AS_Q(ntryL,G1H16(28),wf8(:,44),G1H2(41),ngX,m3h8x2(:,3),heltab2x16(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(41),23,nME,G2H2(10),n2h2(231))
  call Hloop_QS_A(ntryL,G1H16(29),wf8(:,44),G1H2(55),ngX,m3h8x2(:,4),heltab2x16(:,:,644))
  call Hloop_Q_A(ntryL,G1H2(55),23,nME,G2H2(107),n2h2(232))
  call Hloop_SS_S(ntryL,G1H16(30),wf8(:,10),G1H2(5),m3h8x2(:,5),heltab2x16(:,:,645))
  call Hloop_SS_S(ntryL,G1H16(31),wf8(:,10),G1H2(21),m3h8x2(:,6),heltab2x16(:,:,646))
  call Hloop_SS_S(ntryL,G1H16(34),wf8(:,10),G1H2(61),m3h8x2(:,7),heltab2x16(:,:,647))
  call Hloop_SS_S(ntryL,G1H16(36),wf8(:,10),G1H2(27),m3h8x2(:,8),heltab2x16(:,:,648))
  call Hloop_SS_S(ntryL,G1H16(39),wf8(:,44),G1H2(67),m3h8x2(:,9),heltab2x16(:,:,649))
  call Hloop_SS_S(ntryL,G1H16(40),wf8(:,44),G1H2(103),m3h8x2(:,10),heltab2x16(:,:,650))
  call Hloop_VS_V(ntryL,G1H16(41),wf8(:,10),G1H2(311),m3h8x2(:,11),heltab2x16(:,:,651))
  call Hloop_VS_V(ntryL,G1H16(42),wf8(:,10),G1H2(7),m3h8x2(:,12),heltab2x16(:,:,652))
  call Hloop_VT_S(ntryL,G0H16(7),16,wf8(:,10),7,G1H2(11),m3h8x2(:,13),heltab2x16(:,:,653))
  call Hloop_VT_S(ntryL,G0H16(8),16,wf8(:,10),7,G1H2(327),m3h8x2(:,14),heltab2x16(:,:,654))
  call Hloop_VT_S(ntryL,G0H16(34),16,wf8(:,44),7,G1H2(8),m3h8x2(:,15),heltab2x16(:,:,655))
  call Hloop_VT_S(ntryL,G0H16(36),16,wf8(:,44),7,G1H2(17),m3h8x2(:,16),heltab2x16(:,:,656))
  call Hloop_ST_V(ntryL,G1H16(44),16,wf8(:,10),7,G2H2(194),m3h8x2(:,17),heltab2x16(:,:,657))
  call Hloop_ST_V(ntryL,G1H16(46),16,wf8(:,44),7,G2H2(105),m3h8x2(:,18),heltab2x16(:,:,658))
  call Hloop_SS_S(ntryL,G0H16(40),wf8(:,10),G0H2(29),m3h8x2(:,19),heltab2x16(:,:,659))
  call Hloop_VS_V(ntryL,G0H16(50),wf8(:,10),G0H2(30),m3h8x2(:,20),heltab2x16(:,:,660))
  call Hloop_VT_S(ntryL,G1H16(48),16,wf8(:,10),7,G2H2(61),m3h8x2(:,21),heltab2x16(:,:,661))
  call Hloop_VT_S(ntryL,G1H16(50),16,wf8(:,44),7,G2H2(109),m3h8x2(:,22),heltab2x16(:,:,662))
  call Hloop_ST_V(ntryL,G0H16(51),16,wf8(:,10),7,G1H2(18),m3h8x2(:,23),heltab2x16(:,:,663))
  call Hloop_ST_V(ntryL,G0H16(52),16,wf8(:,10),7,G1H2(113),m3h8x2(:,24),heltab2x16(:,:,664))
  call Hloop_ST_V(ntryL,G0H16(53),16,wf8(:,44),7,G1H2(23),m3h8x2(:,25),heltab2x16(:,:,665))
  call Hloop_ST_V(ntryL,G0H16(54),16,wf8(:,44),7,G1H2(29),m3h8x2(:,26),heltab2x16(:,:,666))
  call Hloop_AV_Q(ntryL,G1H16(51),wf8(:,45),G1H2(30),m3h8x2(:,27),heltab2x16(:,:,667))
  call Hloop_A_Q(ntryL,G1H2(30),23,nME,G2H2(12),n2h2(233))
  call Hloop_QV_A(ntryL,G1H16(52),wf8(:,45),G1H2(36),m3h8x2(:,28),heltab2x16(:,:,668))
  call Hloop_Q_A(ntryL,G1H2(36),23,nME,G2H2(113),n2h2(234))
  call Hloop_AV_Q(ntryL,G1H16(55),wf8(:,45),G1H2(47),m3h8x2(:,29),heltab2x16(:,:,669))
  call Hloop_A_Q(ntryL,G1H2(47),23,0,G2H2(116),n2h2(235))
  call Hloop_QV_A(ntryL,G1H16(56),wf8(:,45),G1H2(48),m3h8x2(:,30),heltab2x16(:,:,670))
  call Hloop_Q_A(ntryL,G1H2(48),23,0,G2H2(69),n2h2(236))
  call Hloop_AZ_Q(ntryL,G1H16(59),wf8(:,46),G1H2(129),ngZl,m3h8x2(:,31),heltab2x16(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(129),23,nME,G2H2(119),n2h2(237))
  call Hloop_QZ_A(ntryL,G1H16(60),wf8(:,46),G1H2(87),ngZl,m3h8x2(:,32),heltab2x16(:,:,672))
  call Hloop_Q_A(ntryL,G1H2(87),23,nME,G2H2(123),n2h2(238))
  call Hloop_AZ_Q(ntryL,G1H16(61),wf8(:,46),G1H2(59),ngZu,m3h8x2(:,33),heltab2x16(:,:,673))
  call Hloop_A_Q(ntryL,G1H2(59),23,0,G2H2(127),n2h2(239))
  call Hloop_QZ_A(ntryL,G1H16(62),wf8(:,46),G1H2(60),ngZu,m3h8x2(:,34),heltab2x16(:,:,674))
  call Hloop_Q_A(ntryL,G1H2(60),23,0,G2H2(186),n2h2(240))
  call Hloop_SV_T(ntryL,G1H16(63),16,wf8(:,45),7,G2H2(131),m3h8x2(:,35),heltab2x16(:,:,675))
  call Hloop_TV_S(ntryL,G1H16(64),16,wf8(:,45),7,G2H2(135),m3h8x2(:,36),heltab2x16(:,:,676))
  call Hloop_SV_T(ntryL,G1H16(65),16,wf8(:,46),7,G2H2(139),m3h8x2(:,37),heltab2x16(:,:,677))
  call Hloop_TV_S(ntryL,G1H16(66),16,wf8(:,46),7,G2H2(142),m3h8x2(:,38),heltab2x16(:,:,678))
  call Hloop_DV_C(ntryL,G1H16(69),16,wf8(:,45),G2H2(145),m3h8x2(:,39),heltab2x16(:,:,679))
  call Hloop_CV_D(ntryL,G1H16(70),16,wf8(:,45),7,G2H2(149),m3h8x2(:,40),heltab2x16(:,:,680))
  call Hloop_DV_C(ntryL,G1H16(73),16,wf8(:,46),G2H2(21),m3h8x2(:,41),heltab2x16(:,:,681))
  call Hloop_CV_D(ntryL,G1H16(74),16,wf8(:,46),7,G2H2(153),m3h8x2(:,42),heltab2x16(:,:,682))
  call Hloop_UW_V(ntryL,G1H16(75),16,wf8(:,45),7,G2H2(23),m3h8x2(:,43),heltab2x16(:,:,683))
  call Hloop_UV_W(ntryL,G1H16(76),16,wf8(:,45),7,G2H2(87),m3h8x2(:,44),heltab2x16(:,:,684))
  call Hloop_UW_V(ntryL,G1H16(77),16,wf8(:,46),7,G2H2(202),m3h8x2(:,45),heltab2x16(:,:,685))
  call Hloop_UV_W(ntryL,G1H16(78),16,wf8(:,46),7,G2H2(157),m3h8x2(:,46),heltab2x16(:,:,686))
  call Hloop_VV_S(ntryL,G0H16(63),wf8(:,45),G0H2(31),m3h8x2(:,47),heltab2x16(:,:,687))
  call Hloop_VV_S(ntryL,G0H16(64),wf8(:,45),G0H2(32),m3h8x2(:,48),heltab2x16(:,:,688))
  call Hloop_VV_S(ntryL,G0H16(65),wf8(:,46),G0H2(33),m3h8x2(:,49),heltab2x16(:,:,689))
  call Hloop_VV_S(ntryL,G0H16(66),wf8(:,46),G0H2(34),m3h8x2(:,50),heltab2x16(:,:,690))
  call Hloop_SV_V(ntryL,G1H16(80),wf8(:,45),G1H2(66),m3h8x2(:,51),heltab2x16(:,:,691))
  call Hloop_SV_V(ntryL,G1H16(82),wf8(:,46),G1H2(102),m3h8x2(:,52),heltab2x16(:,:,692))
  call Hloop_SV_T(ntryL,G0H16(67),16,wf8(:,45),7,G1H2(71),m3h8x2(:,53),heltab2x16(:,:,693))
  call Hloop_TV_S(ntryL,G0H16(68),16,wf8(:,45),7,G1H2(77),m3h8x2(:,54),heltab2x16(:,:,694))
  call Hloop_SV_T(ntryL,G0H16(70),16,wf8(:,46),7,G1H2(78),m3h8x2(:,55),heltab2x16(:,:,695))
  call Hloop_TV_S(ntryL,G0H16(72),16,wf8(:,46),7,G1H2(85),m3h8x2(:,56),heltab2x16(:,:,696))
  call Hloop_UW_V(ntryL,G0H16(74),16,wf8(:,45),7,G1H2(100),m3h8x2(:,57),heltab2x16(:,:,697))
  call Hloop_UV_W(ntryL,G0H16(76),16,wf8(:,45),7,G1H2(104),m3h8x2(:,58),heltab2x16(:,:,698))
  call Hloop_UW_V(ntryL,G0H16(77),16,wf8(:,46),7,G1H2(133),m3h8x2(:,59),heltab2x16(:,:,699))
  call Hloop_UV_W(ntryL,G0H16(78),16,wf8(:,46),7,G1H2(115),m3h8x2(:,60),heltab2x16(:,:,700))
  call Hloop_VV_S(ntryL,G1H16(84),wf8(:,45),G1H2(126),m3h8x2(:,61),heltab2x16(:,:,701))
  call Hloop_VV_S(ntryL,G1H16(86),wf8(:,46),G1H2(136),m3h8x2(:,62),heltab2x16(:,:,702))
  call Hloop_SV_V(ntryL,G0H16(79),wf8(:,45),G0H2(35),m3h8x2(:,63),heltab2x16(:,:,703))
  call Hloop_SV_V(ntryL,G0H16(80),wf8(:,45),G0H2(36),m3h8x2(:,64),heltab2x16(:,:,704))
  call Hloop_SV_V(ntryL,G0H16(81),wf8(:,46),G0H2(37),m3h8x2(:,65),heltab2x16(:,:,705))
  call Hloop_SV_V(ntryL,G0H16(82),wf8(:,46),G0H2(38),m3h8x2(:,66),heltab2x16(:,:,706))
  call Hloop_QA_S(ntryL,G1H16(87),ex2(:),G1H8(4),ngH,m3h2x8(:,347),heltab2x16(:,:,707))
  call Hloop_QA_S(ntryL,G1H16(88),ex2(:),G1H8(6),ngX,m3h2x8(:,348),heltab2x16(:,:,708))
  call Hloop_SA_Q(ntryL,G1H16(89),ex2(:),G1H8(13),ngPln,m3h2x8(:,349),heltab2x16(:,:,709))
  call Hloop_A_Q(ntryL,G1H8(13),18,0,G2H8(14),n2h8(225))
  call Hloop_QA_V(ntryL,G1H16(90),ex2(:),G1H8(16),m3h2x8(:,350),heltab2x16(:,:,710))
  call Hloop_QA_Z(ntryL,G1H16(91),ex2(:),G1H8(15),ngZl,m3h2x8(:,351),heltab2x16(:,:,711))
  call Hloop_SA_Q(ntryL,G0H16(87),ex2(:),G0H8(2),ngPln,m3h2x8(:,352),heltab2x16(:,:,712))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(17),n2h8(226))
  call Hloop_WA_Q(ntryL,G0H16(88),ex2(:),G0H8(1),m3h2x8(:,353),heltab2x16(:,:,713))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(19),n2h8(227))
  call Hloop_WA_Q(ntryL,G1H16(92),ex2(:),G1H8(21),m3h2x8(:,354),heltab2x16(:,:,714))
  call Hloop_A_Q(ntryL,G1H8(21),18,0,G2H8(15),n2h8(228))
  call Hloop_SA_Q(ntryL,G0H4(81),ex2(:),G0H2(39),ngH,m3h2x2(:,471),heltab2x4(:,:,503))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(137),n2h2(241))
  call Hloop_SA_Q(ntryL,G0H4(82),ex2(:),G0H2(39),ngX,m3h2x2(:,472),heltab2x4(:,:,504))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(170),n2h2(242))
  call Hloop_QA_S(ntryL,G1H4(62),ex2(:),G1H2(154),ngPln,m3h2x2(:,473),heltab2x4(:,:,505))
  call Hloop_VA_Q(ntryL,G0H4(83),ex2(:),G0H2(39),m3h2x2(:,474),heltab2x4(:,:,506))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(159),n2h2(243))
  call Hloop_ZA_Q(ntryL,G0H4(84),ex2(:),G0H2(39),ngZl,m3h2x2(:,475),heltab2x4(:,:,507))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(163),n2h2(244))
  call Hloop_QA_S(ntryL,G1H4(67),ex2(:),G1H2(175),ngPln,m3h2x2(:,476),heltab2x4(:,:,508))
  call Hloop_QA_W(ntryL,G1H4(162),ex2(:),G1H2(198),m3h2x2(:,477),heltab2x4(:,:,509))
  call Hloop_QA_W(ntryL,G1H4(144),ex2(:),G1H2(187),m3h2x2(:,478),heltab2x4(:,:,510))
  call Hloop_QA_S(ntryL,G1H16(93),wf4(:,10),G1H4(111),ngH,m3h4x4(:,295),heltab2x16(:,:,715))
  call Hloop_QA_S(ntryL,G1H16(94),wf4(:,10),G1H4(126),ngX,m3h4x4(:,296),heltab2x16(:,:,716))
  call Hloop_SA_Q(ntryL,G1H16(97),wf4(:,10),G1H4(124),ngPln,m3h4x4(:,297),heltab2x16(:,:,717))
  call Hloop_A_Q(ntryL,G1H4(124),22,0,G2H4(97),n2h4(281))
  call Hloop_QA_V(ntryL,G1H16(98),wf4(:,10),G1H4(114),m3h4x4(:,298),heltab2x16(:,:,718))
  call Hloop_QA_Z(ntryL,G1H16(101),wf4(:,10),G1H4(141),ngZl,m3h4x4(:,299),heltab2x16(:,:,719))
  call Hloop_WA_Q(ntryL,G0H16(93),wf4(:,10),G0H4(2),m3h4x4(:,300),heltab2x16(:,:,720))
  call Hloop_A_Q(ntryL,G0H4(2),22,0,G1H4(137),n2h4(282))
  call Hloop_SA_Q(ntryL,G0H16(94),wf4(:,10),G0H4(120),ngPln,m3h4x4(:,301),heltab2x16(:,:,721))
  call Hloop_A_Q(ntryL,G0H4(120),22,0,G1H4(190),n2h4(283))
  call Hloop_WA_Q(ntryL,G1H16(102),wf4(:,10),G1H4(186),m3h4x4(:,302),heltab2x16(:,:,722))
  call Hloop_A_Q(ntryL,G1H4(186),22,0,G2H4(124),n2h4(284))
  call Hloop_SA_Q(ntryL,G0H8(69),wf4(:,10),G0H2(39),ngH,m3h4x2(:,247),heltab2x8(:,:,483))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(191),n2h2(245))
  call Hloop_SA_Q(ntryL,G0H8(70),wf4(:,10),G0H2(39),ngX,m3h4x2(:,248),heltab2x8(:,:,484))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(240),n2h2(246))
  call Hloop_QA_S(ntryL,G1H8(113),wf4(:,10),G1H2(224),ngPln,m3h4x2(:,249),heltab2x8(:,:,485))
  call Hloop_VA_Q(ntryL,G0H8(71),wf4(:,10),G0H2(39),m3h4x2(:,250),heltab2x8(:,:,486))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(213),n2h2(247))
  call Hloop_ZA_Q(ntryL,G0H8(72),wf4(:,10),G0H2(39),ngZl,m3h4x2(:,251),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G0H2(39),23,nME,G1H2(219),n2h2(248))
  call Hloop_QA_W(ntryL,G1H8(114),wf4(:,10),G1H2(223),m3h4x2(:,252),heltab2x8(:,:,488))
  call Hloop_QA_S(ntryL,G1H8(121),wf4(:,10),G1H2(235),ngPln,m3h4x2(:,253),heltab2x8(:,:,489))
  call Hloop_QA_W(ntryL,G1H8(122),wf4(:,10),G1H2(255),m3h4x2(:,254),heltab2x8(:,:,490))
  call Hloop_AS_Q(ntryL,G1H16(103),wf8(:,13),G1H2(283),ngH,m3h8x2(:,67),heltab2x16(:,:,723))
  call Hloop_A_Q(ntryL,G1H2(283),23,nME,G2H2(49),n2h2(249))
  call Hloop_QS_A(ntryL,G1H16(104),wf8(:,13),G1H2(267),ngH,m3h8x2(:,68),heltab2x16(:,:,724))
  call Hloop_Q_A(ntryL,G1H2(267),23,nME,G2H2(161),n2h2(250))
  call Hloop_AS_Q(ntryL,G1H16(105),wf8(:,47),G1H2(273),ngX,m3h8x2(:,69),heltab2x16(:,:,725))
  call Hloop_A_Q(ntryL,G1H2(273),23,nME,G2H2(45),n2h2(251))
  call Hloop_QS_A(ntryL,G1H16(106),wf8(:,47),G1H2(262),ngX,m3h8x2(:,70),heltab2x16(:,:,726))
  call Hloop_Q_A(ntryL,G1H2(262),23,nME,G2H2(165),n2h2(252))
  call Hloop_SS_S(ntryL,G1H16(107),wf8(:,13),G1H2(266),m3h8x2(:,71),heltab2x16(:,:,727))
  call Hloop_SS_S(ntryL,G1H16(108),wf8(:,13),G1H2(294),m3h8x2(:,72),heltab2x16(:,:,728))
  call Hloop_SS_S(ntryL,G1H16(112),wf8(:,13),G1H2(298),m3h8x2(:,73),heltab2x16(:,:,729))
  call Hloop_SS_S(ntryL,G1H16(113),wf8(:,13),G1H2(326),m3h8x2(:,74),heltab2x16(:,:,730))
  call Hloop_SS_S(ntryL,G1H16(116),wf8(:,47),G1H2(332),m3h8x2(:,75),heltab2x16(:,:,731))
  call Hloop_SS_S(ntryL,G1H16(117),wf8(:,47),G1H2(316),m3h8x2(:,76),heltab2x16(:,:,732))
  call Hloop_VS_V(ntryL,G1H16(118),wf8(:,13),G1H2(305),m3h8x2(:,77),heltab2x16(:,:,733))
  call Hloop_VS_V(ntryL,G1H16(120),wf8(:,13),G1H2(325),m3h8x2(:,78),heltab2x16(:,:,734))
  call Hloop_VT_S(ntryL,G0H16(102),16,wf8(:,13),7,G1H2(337),m3h8x2(:,79),heltab2x16(:,:,735))
  call Hloop_VT_S(ntryL,G0H16(104),16,wf8(:,13),7,G1H2(119),m3h8x2(:,80),heltab2x16(:,:,736))
  call Hloop_VT_S(ntryL,G0H16(105),16,wf8(:,47),7,G1H2(123),m3h8x2(:,81),heltab2x16(:,:,737))
  call Hloop_VT_S(ntryL,G0H16(106),16,wf8(:,47),7,G1H2(97),m3h8x2(:,82),heltab2x16(:,:,738))
  call Hloop_ST_V(ntryL,G1H16(122),16,wf8(:,13),7,G2H2(168),m3h8x2(:,83),heltab2x16(:,:,739))
  call Hloop_ST_V(ntryL,G1H16(124),16,wf8(:,47),7,G2H2(60),m3h8x2(:,84),heltab2x16(:,:,740))
  call Hloop_SS_S(ntryL,G0H16(108),wf8(:,13),G0H2(39),m3h8x2(:,85),heltab2x16(:,:,741))
  call Hloop_VS_V(ntryL,G0H16(110),wf8(:,13),G0H2(40),m3h8x2(:,86),heltab2x16(:,:,742))
  call Hloop_VT_S(ntryL,G1H16(126),16,wf8(:,13),7,G2H2(171),m3h8x2(:,87),heltab2x16(:,:,743))
  call Hloop_VT_S(ntryL,G1H16(128),16,wf8(:,47),7,G2H2(175),m3h8x2(:,88),heltab2x16(:,:,744))
  call Hloop_ST_V(ntryL,G0H16(111),16,wf8(:,13),7,G1H2(82),m3h8x2(:,89),heltab2x16(:,:,745))
  call Hloop_ST_V(ntryL,G0H16(112),16,wf8(:,13),7,G1H2(193),m3h8x2(:,90),heltab2x16(:,:,746))
  call Hloop_ST_V(ntryL,G0H16(113),16,wf8(:,47),7,G1H2(80),m3h8x2(:,91),heltab2x16(:,:,747))
  call Hloop_ST_V(ntryL,G0H16(114),16,wf8(:,47),7,G1H2(32),m3h8x2(:,92),heltab2x16(:,:,748))
  call Hloop_AV_Q(ntryL,G1H16(129),wf8(:,48),G1H2(56),m3h8x2(:,93),heltab2x16(:,:,749))
  call Hloop_A_Q(ntryL,G1H2(56),23,nME,G2H2(98),n2h2(253))
  call Hloop_QV_A(ntryL,G1H16(130),wf8(:,48),G1H2(301),m3h8x2(:,94),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G1H2(301),23,nME,G2H2(102),n2h2(254))
  call Hloop_AV_Q(ntryL,G1H16(131),wf8(:,48),G1H2(10),m3h8x2(:,95),heltab2x16(:,:,751))
  call Hloop_A_Q(ntryL,G1H2(10),23,0,G2H2(72),n2h2(255))
  call Hloop_QV_A(ntryL,G1H16(132),wf8(:,48),G1H2(151),m3h8x2(:,96),heltab2x16(:,:,752))
  call Hloop_Q_A(ntryL,G1H2(151),23,0,G2H2(83),n2h2(256))
  call Hloop_AZ_Q(ntryL,G1H16(133),wf8(:,49),G1H2(152),ngZl,m3h8x2(:,97),heltab2x16(:,:,753))
  call Hloop_A_Q(ntryL,G1H2(152),23,nME,G2H2(95),n2h2(257))
  call Hloop_QZ_A(ntryL,G1H16(134),wf8(:,49),G1H2(167),ngZl,m3h8x2(:,98),heltab2x16(:,:,754))
  call Hloop_Q_A(ntryL,G1H2(167),23,nME,G2H2(99),n2h2(258))
  call Hloop_AZ_Q(ntryL,G1H16(135),wf8(:,49),G1H2(340),ngZu,m3h8x2(:,99),heltab2x16(:,:,755))
  call Hloop_A_Q(ntryL,G1H2(340),23,0,G2H2(75),n2h2(259))
  call Hloop_QZ_A(ntryL,G1H16(136),wf8(:,49),G1H2(341),ngZu,m3h8x2(:,100),heltab2x16(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(341),23,0,G2H2(86),n2h2(260))
  call Hloop_SV_T(ntryL,G1H16(139),16,wf8(:,48),7,G2H2(378),m3h8x2(:,101),heltab2x16(:,:,757))
  call Hloop_TV_S(ntryL,G1H16(140),16,wf8(:,48),7,G2H2(402),m3h8x2(:,102),heltab2x16(:,:,758))
  call Hloop_SV_T(ntryL,G1H16(143),16,wf8(:,49),7,G2H2(375),m3h8x2(:,103),heltab2x16(:,:,759))
  call Hloop_TV_S(ntryL,G1H16(144),16,wf8(:,49),7,G2H2(399),m3h8x2(:,104),heltab2x16(:,:,760))
  call Hloop_DV_C(ntryL,G1H16(147),16,wf8(:,48),G2H2(354),m3h8x2(:,105),heltab2x16(:,:,761))
  call Hloop_CV_D(ntryL,G1H16(148),16,wf8(:,48),7,G2H2(336),m3h8x2(:,106),heltab2x16(:,:,762))
  call Hloop_DV_C(ntryL,G1H16(151),16,wf8(:,49),G2H2(330),m3h8x2(:,107),heltab2x16(:,:,763))
  call Hloop_CV_D(ntryL,G1H16(152),16,wf8(:,49),7,G2H2(24),m3h8x2(:,108),heltab2x16(:,:,764))
  call Hloop_UW_V(ntryL,G1H16(153),16,wf8(:,48),7,G2H2(351),m3h8x2(:,109),heltab2x16(:,:,765))
  call Hloop_UV_W(ntryL,G1H16(154),16,wf8(:,48),7,G2H2(333),m3h8x2(:,110),heltab2x16(:,:,766))
  call Hloop_UW_V(ntryL,G1H16(155),16,wf8(:,49),7,G2H2(327),m3h8x2(:,111),heltab2x16(:,:,767))
  call Hloop_UV_W(ntryL,G1H16(156),16,wf8(:,49),7,G2H2(11),m3h8x2(:,112),heltab2x16(:,:,768))
  call Hloop_VV_S(ntryL,G0H16(123),wf8(:,48),G0H2(41),m3h8x2(:,113),heltab2x16(:,:,769))
  call Hloop_VV_S(ntryL,G0H16(124),wf8(:,48),G0H2(42),m3h8x2(:,114),heltab2x16(:,:,770))
  call Hloop_VV_S(ntryL,G0H16(126),wf8(:,49),G0H2(43),m3h8x2(:,115),heltab2x16(:,:,771))
  call Hloop_VV_S(ntryL,G0H16(128),wf8(:,49),G0H2(44),m3h8x2(:,116),heltab2x16(:,:,772))
  call Hloop_SV_V(ntryL,G1H16(158),wf8(:,48),G1H2(342),m3h8x2(:,117),heltab2x16(:,:,773))
  call Hloop_SV_V(ntryL,G1H16(160),wf8(:,49),G1H2(345),m3h8x2(:,118),heltab2x16(:,:,774))
  call Hloop_SV_T(ntryL,G0H16(130),16,wf8(:,48),7,G1H2(346),m3h8x2(:,119),heltab2x16(:,:,775))
  call Hloop_TV_S(ntryL,G0H16(132),16,wf8(:,48),7,G1H2(347),m3h8x2(:,120),heltab2x16(:,:,776))
  call Hloop_SV_T(ntryL,G0H16(133),16,wf8(:,49),7,G1H2(350),m3h8x2(:,121),heltab2x16(:,:,777))
  call Hloop_TV_S(ntryL,G0H16(134),16,wf8(:,49),7,G1H2(351),m3h8x2(:,122),heltab2x16(:,:,778))
  call Hloop_UW_V(ntryL,G0H16(135),16,wf8(:,48),7,G1H2(352),m3h8x2(:,123),heltab2x16(:,:,779))
  call Hloop_UV_W(ntryL,G0H16(136),16,wf8(:,48),7,G1H2(355),m3h8x2(:,124),heltab2x16(:,:,780))
  call Hloop_UW_V(ntryL,G0H16(137),16,wf8(:,49),7,G1H2(356),m3h8x2(:,125),heltab2x16(:,:,781))
  call Hloop_UV_W(ntryL,G0H16(138),16,wf8(:,49),7,G1H2(357),m3h8x2(:,126),heltab2x16(:,:,782))
  call Hloop_VV_S(ntryL,G1H16(162),wf8(:,48),G1H2(360),m3h8x2(:,127),heltab2x16(:,:,783))
  call Hloop_VV_S(ntryL,G1H16(164),wf8(:,49),G1H2(361),m3h8x2(:,128),heltab2x16(:,:,784))
  call Hloop_SV_V(ntryL,G0H16(139),wf8(:,48),G0H2(45),m3h8x2(:,129),heltab2x16(:,:,785))
  call Hloop_SV_V(ntryL,G0H16(140),wf8(:,48),G0H2(46),m3h8x2(:,130),heltab2x16(:,:,786))
  call Hloop_SV_V(ntryL,G0H16(141),wf8(:,49),G0H2(47),m3h8x2(:,131),heltab2x16(:,:,787))
  call Hloop_SV_V(ntryL,G0H16(142),wf8(:,49),G0H2(48),m3h8x2(:,132),heltab2x16(:,:,788))
  call Hloop_AQ_S(ntryL,G1H16(165),ex1(:),G1H8(25),ngH,m3h2x8(:,355),heltab2x16(:,:,789))
  call Hloop_AQ_S(ntryL,G1H16(166),ex1(:),G1H8(26),ngX,m3h2x8(:,356),heltab2x16(:,:,790))
  call Hloop_SQ_A(ntryL,G1H16(167),ex1(:),G1H8(36),ngPnl,m3h2x8(:,357),heltab2x16(:,:,791))
  call Hloop_Q_A(ntryL,G1H8(36),17,0,G2H8(13),n2h8(229))
  call Hloop_AQ_V(ntryL,G1H16(168),ex1(:),G1H8(35),m3h2x8(:,358),heltab2x16(:,:,792))
  call Hloop_AQ_Z(ntryL,G1H16(169),ex1(:),G1H8(39),ngZl,m3h2x8(:,359),heltab2x16(:,:,793))
  call Hloop_SQ_A(ntryL,G0H16(147),ex1(:),G0H8(9),ngPnl,m3h2x8(:,360),heltab2x16(:,:,794))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(46),n2h8(230))
  call Hloop_WQ_A(ntryL,G0H16(148),ex1(:),G0H8(12),m3h2x8(:,361),heltab2x16(:,:,795))
  call Hloop_Q_A(ntryL,G0H8(12),17,0,G1H8(58),n2h8(231))
  call Hloop_WQ_A(ntryL,G1H16(170),ex1(:),G1H8(61),m3h2x8(:,362),heltab2x16(:,:,796))
  call Hloop_Q_A(ntryL,G1H8(61),17,0,G2H8(16),n2h8(232))
  call Hloop_SQ_A(ntryL,G0H4(121),ex1(:),G0H2(49),ngH,m3h2x2(:,479),heltab2x4(:,:,511))
  call Hloop_Q_A(ntryL,G0H2(49),23,nME,G1H2(362),n2h2(261))
  call Hloop_SQ_A(ntryL,G0H4(122),ex1(:),G0H2(49),ngX,m3h2x2(:,480),heltab2x4(:,:,512))
  call Hloop_Q_A(ntryL,G0H2(49),23,nME,G1H2(365),n2h2(262))
  call Hloop_AQ_S(ntryL,G1H4(52),ex1(:),G1H2(366),ngPnl,m3h2x2(:,481),heltab2x4(:,:,513))
  call Hloop_VQ_A(ntryL,G0H4(123),ex1(:),G0H2(49),m3h2x2(:,482),heltab2x4(:,:,514))
  call Hloop_Q_A(ntryL,G0H2(49),23,nME,G1H2(367),n2h2(263))
  call Hloop_ZQ_A(ntryL,G0H4(124),ex1(:),G0H2(49),ngZl,m3h2x2(:,483),heltab2x4(:,:,515))
  call Hloop_Q_A(ntryL,G0H2(49),23,nME,G1H2(370),n2h2(264))
  call Hloop_AQ_S(ntryL,G1H4(48),ex1(:),G1H2(371),ngPnl,m3h2x2(:,484),heltab2x4(:,:,516))
  call Hloop_AQ_W(ntryL,G1H4(194),ex1(:),G1H2(372),m3h2x2(:,485),heltab2x4(:,:,517))
  call Hloop_AQ_W(ntryL,G1H4(199),ex1(:),G1H2(375),m3h2x2(:,486),heltab2x4(:,:,518))
  call Hloop_AV_Q(ntryL,G1H8(123),ex3(:),G1H4(159),m3h2x4(:,237),heltab2x8(:,:,491))
  call Hloop_A_Q(ntryL,G1H4(159),22,nME,G2H4(2),n2h4(285))
  call Hloop_AV_Q(ntryL,G1H8(124),ex3(:),G1H4(156),m3h2x4(:,238),heltab2x8(:,:,492))
  call Hloop_A_Q(ntryL,G1H4(156),22,nME,G2H4(70),n2h4(286))
  call Hloop_SV_T(ntryL,G0H8(73),18,ex3(:),4,G1H4(153),m3h2x4(:,239),heltab2x8(:,:,493))
  call Hloop_AV_Q(ntryL,G1H8(125),ex3(:),G1H4(160),m3h2x4(:,240),heltab2x8(:,:,494))
  call Hloop_A_Q(ntryL,G1H4(160),22,nME,G2H4(100),n2h4(287))
  call Hloop_AV_Q(ntryL,G1H8(126),ex3(:),G1H4(155),m3h2x4(:,241),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H4(155),22,nME,G2H4(8),n2h4(288))
  call Hloop_VV_S(ntryL,G0H8(74),ex3(:),G0H4(118),m3h2x4(:,242),heltab2x8(:,:,496))
  call Hloop_SV_V(ntryL,G0H8(75),ex3(:),G0H4(80),m3h2x4(:,243),heltab2x8(:,:,497))
  call Hloop_UW_V(ntryL,G0H8(76),18,ex3(:),4,G1H4(154),m3h2x4(:,244),heltab2x8(:,:,498))
  call Hloop_QV_A(ntryL,G1H16(171),ex3(:),G1H8(62),m3h2x8(:,363),heltab2x16(:,:,797))
  call Hloop_Q_A(ntryL,G1H8(62),20,nME,G2H8(18),n2h8(233))
  call Hloop_AV_Q(ntryL,G1H16(172),ex3(:),G1H8(59),m3h2x8(:,364),heltab2x16(:,:,798))
  call Hloop_A_Q(ntryL,G1H8(59),20,nME,G2H8(20),n2h8(234))
  call Hloop_QV_A(ntryL,G1H16(173),ex3(:),G1H8(63),m3h2x8(:,365),heltab2x16(:,:,799))
  call Hloop_Q_A(ntryL,G1H8(63),20,nME,G2H8(22),n2h8(235))
  call Hloop_AV_Q(ntryL,G1H16(174),ex3(:),G1H8(3),m3h2x8(:,366),heltab2x16(:,:,800))
  call Hloop_A_Q(ntryL,G1H8(3),20,nME,G2H8(24),n2h8(236))
  call Hloop_TV_S(ntryL,G1H16(175),16,ex3(:),4,G2H8(25),m3h2x8(:,367),heltab2x16(:,:,801))
  call Hloop_SV_T(ntryL,G1H16(176),16,ex3(:),4,G2H8(28),m3h2x8(:,368),heltab2x16(:,:,802))
  call Hloop_CV_D(ntryL,G1H16(181),16,ex3(:),4,G2H8(26),m3h2x8(:,369),heltab2x16(:,:,803))
  call Hloop_DV_C(ntryL,G1H16(182),16,ex3(:),G2H8(27),m3h2x8(:,370),heltab2x16(:,:,804))
  call Hloop_CV_D(ntryL,G1H16(187),16,ex3(:),4,G2H8(30),m3h2x8(:,371),heltab2x16(:,:,805))
  call Hloop_DV_C(ntryL,G1H16(188),16,ex3(:),G2H8(31),m3h2x8(:,372),heltab2x16(:,:,806))
  call Hloop_UV_W(ntryL,G1H16(189),16,ex3(:),4,G2H8(29),m3h2x8(:,373),heltab2x16(:,:,807))
  call Hloop_UW_V(ntryL,G1H16(190),16,ex3(:),4,G2H8(32),m3h2x8(:,374),heltab2x16(:,:,808))
  call Hloop_TV_S(ntryL,G0H16(154),16,ex3(:),4,G1H8(5),m3h2x8(:,375),heltab2x16(:,:,809))
  call Hloop_SV_T(ntryL,G0H16(156),16,ex3(:),4,G1H8(7),m3h2x8(:,376),heltab2x16(:,:,810))
  call Hloop_TV_S(ntryL,G0H16(158),16,ex3(:),4,G1H8(9),m3h2x8(:,377),heltab2x16(:,:,811))
  call Hloop_SV_T(ntryL,G0H16(160),16,ex3(:),4,G1H8(40),m3h2x8(:,378),heltab2x16(:,:,812))
  call Hloop_SV_V(ntryL,G1H16(192),ex3(:),G1H8(49),m3h2x8(:,379),heltab2x16(:,:,813))
  call Hloop_SV_V(ntryL,G1H16(194),ex3(:),G1H8(50),m3h2x8(:,380),heltab2x16(:,:,814))
  call Hloop_VV_S(ntryL,G0H16(162),ex3(:),G0H8(10),m3h2x8(:,381),heltab2x16(:,:,815))
  call Hloop_SV_V(ntryL,G0H16(164),ex3(:),G0H8(42),m3h2x8(:,382),heltab2x16(:,:,816))
  call Hloop_VV_S(ntryL,G1H16(196),ex3(:),G1H8(48),m3h2x8(:,383),heltab2x16(:,:,817))
  call Hloop_VV_S(ntryL,G1H16(200),ex3(:),G1H8(52),m3h2x8(:,384),heltab2x16(:,:,818))
  call Hloop_UV_W(ntryL,G0H16(165),16,ex3(:),4,G1H8(37),m3h2x8(:,385),heltab2x16(:,:,819))
  call Hloop_UW_V(ntryL,G0H16(166),16,ex3(:),4,G1H8(66),m3h2x8(:,386),heltab2x16(:,:,820))
  call Hloop_UV_W(ntryL,G0H16(167),16,ex3(:),4,G1H8(68),m3h2x8(:,387),heltab2x16(:,:,821))
  call Hloop_UW_V(ntryL,G0H16(168),16,ex3(:),4,G1H8(69),m3h2x8(:,388),heltab2x16(:,:,822))
  call Hloop_QV_A(ntryL,G1H16(201),ex3(:),G1H8(70),m3h2x8(:,389),heltab2x16(:,:,823))
  call Hloop_Q_A(ntryL,G1H8(70),20,nME,G2H8(33),n2h8(237))
  call Hloop_AV_Q(ntryL,G1H16(202),ex3(:),G1H8(71),m3h2x8(:,390),heltab2x16(:,:,824))
  call Hloop_A_Q(ntryL,G1H8(71),20,nME,G2H8(37),n2h8(238))
  call Hloop_QV_A(ntryL,G1H16(203),ex3(:),G1H8(73),m3h2x8(:,391),heltab2x16(:,:,825))
  call Hloop_Q_A(ntryL,G1H8(73),20,0,G2H8(34),n2h8(239))
  call Hloop_AV_Q(ntryL,G1H16(204),ex3(:),G1H8(74),m3h2x8(:,392),heltab2x16(:,:,826))
  call Hloop_A_Q(ntryL,G1H8(74),20,0,G2H8(35),n2h8(240))
  call Hloop_QV_A(ntryL,G1H16(205),ex3(:),G1H8(96),m3h2x8(:,393),heltab2x16(:,:,827))
  call Hloop_Q_A(ntryL,G1H8(96),20,nME,G2H8(38),n2h8(241))
  call Hloop_AV_Q(ntryL,G1H16(206),ex3(:),G1H8(98),m3h2x8(:,394),heltab2x16(:,:,828))
  call Hloop_A_Q(ntryL,G1H8(98),20,nME,G2H8(39),n2h8(242))
  call Hloop_QV_A(ntryL,G1H16(207),ex3(:),G1H8(97),m3h2x8(:,395),heltab2x16(:,:,829))
  call Hloop_Q_A(ntryL,G1H8(97),20,0,G2H8(36),n2h8(243))
  call Hloop_AV_Q(ntryL,G1H16(208),ex3(:),G1H8(104),m3h2x8(:,396),heltab2x16(:,:,830))
  call Hloop_A_Q(ntryL,G1H8(104),20,0,G2H8(40),n2h8(244))
  call Hloop_TV_S(ntryL,G1H16(209),16,ex3(:),4,G2H8(41),m3h2x8(:,397),heltab2x16(:,:,831))
  call Hloop_SV_T(ntryL,G1H16(210),16,ex3(:),4,G2H8(45),m3h2x8(:,398),heltab2x16(:,:,832))
  call Hloop_TV_S(ntryL,G1H16(211),16,ex3(:),4,G2H8(42),m3h2x8(:,399),heltab2x16(:,:,833))
  call Hloop_SV_T(ntryL,G1H16(212),16,ex3(:),4,G2H8(43),m3h2x8(:,400),heltab2x16(:,:,834))
  call Hloop_CV_D(ntryL,G1H16(215),16,ex3(:),4,G2H8(47),m3h2x8(:,401),heltab2x16(:,:,835))
  call Hloop_DV_C(ntryL,G1H16(216),16,ex3(:),G2H8(48),m3h2x8(:,402),heltab2x16(:,:,836))
  call Hloop_CV_D(ntryL,G1H16(219),16,ex3(:),4,G2H8(50),m3h2x8(:,403),heltab2x16(:,:,837))
  call Hloop_DV_C(ntryL,G1H16(220),16,ex3(:),G2H8(52),m3h2x8(:,404),heltab2x16(:,:,838))
  call Hloop_UV_W(ntryL,G1H16(223),16,ex3(:),4,G2H8(53),m3h2x8(:,405),heltab2x16(:,:,839))
  call Hloop_UW_V(ntryL,G1H16(224),16,ex3(:),4,G2H8(54),m3h2x8(:,406),heltab2x16(:,:,840))
  call Hloop_UV_W(ntryL,G1H16(227),16,ex3(:),4,G2H8(55),m3h2x8(:,407),heltab2x16(:,:,841))
  call Hloop_UW_V(ntryL,G1H16(228),16,ex3(:),4,G2H8(56),m3h2x8(:,408),heltab2x16(:,:,842))
  call Hloop_TV_S(ntryL,G0H16(177),16,ex3(:),4,G1H8(106),m3h2x8(:,409),heltab2x16(:,:,843))
  call Hloop_SV_T(ntryL,G0H16(178),16,ex3(:),4,G1H8(103),m3h2x8(:,410),heltab2x16(:,:,844))
  call Hloop_TV_S(ntryL,G0H16(179),16,ex3(:),4,G1H8(107),m3h2x8(:,411),heltab2x16(:,:,845))
  call Hloop_SV_T(ntryL,G0H16(180),16,ex3(:),4,G1H8(108),m3h2x8(:,412),heltab2x16(:,:,846))
  call Hloop_SV_V(ntryL,G1H16(230),ex3(:),G1H8(116),m3h2x8(:,413),heltab2x16(:,:,847))
  call Hloop_SV_V(ntryL,G1H16(232),ex3(:),G1H8(118),m3h2x8(:,414),heltab2x16(:,:,848))
  call Hloop_VV_S(ntryL,G0H16(181),ex3(:),G0H8(43),m3h2x8(:,415),heltab2x16(:,:,849))
  call Hloop_VV_S(ntryL,G0H16(182),ex3(:),G0H8(44),m3h2x8(:,416),heltab2x16(:,:,850))
  call Hloop_VV_S(ntryL,G0H16(183),ex3(:),G0H8(45),m3h2x8(:,417),heltab2x16(:,:,851))
  call Hloop_VV_S(ntryL,G0H16(184),ex3(:),G0H8(46),m3h2x8(:,418),heltab2x16(:,:,852))
  call Hloop_SV_V(ntryL,G0H16(185),ex3(:),G0H8(47),m3h2x8(:,419),heltab2x16(:,:,853))
  call Hloop_SV_V(ntryL,G0H16(186),ex3(:),G0H8(48),m3h2x8(:,420),heltab2x16(:,:,854))
  call Hloop_SV_V(ntryL,G0H16(187),ex3(:),G0H8(61),m3h2x8(:,421),heltab2x16(:,:,855))
  call Hloop_SV_V(ntryL,G0H16(188),ex3(:),G0H8(62),m3h2x8(:,422),heltab2x16(:,:,856))
  call Hloop_VV_S(ntryL,G1H16(234),ex3(:),G1H8(117),m3h2x8(:,423),heltab2x16(:,:,857))
  call Hloop_VV_S(ntryL,G1H16(236),ex3(:),G1H8(119),m3h2x8(:,424),heltab2x16(:,:,858))
  call Hloop_UV_W(ntryL,G0H16(189),16,ex3(:),4,G1H8(120),m3h2x8(:,425),heltab2x16(:,:,859))
  call Hloop_UW_V(ntryL,G0H16(190),16,ex3(:),4,G1H8(128),m3h2x8(:,426),heltab2x16(:,:,860))
  call Hloop_UV_W(ntryL,G0H16(191),16,ex3(:),4,G1H8(127),m3h2x8(:,427),heltab2x16(:,:,861))
  call Hloop_UW_V(ntryL,G0H16(192),16,ex3(:),4,G1H8(129),m3h2x8(:,428),heltab2x16(:,:,862))
  call Hloop_QA_S(ntryL,G1H16(237),ex2(:),G1H8(10),ngH,m3h2x8(:,429),heltab2x16(:,:,863))
  call Hloop_QA_S(ntryL,G1H16(238),ex2(:),G1H8(11),ngX,m3h2x8(:,430),heltab2x16(:,:,864))
  call Hloop_SA_Q(ntryL,G1H16(239),ex2(:),G1H8(18),ngPln,m3h2x8(:,431),heltab2x16(:,:,865))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(57),n2h8(245))
  call Hloop_QA_V(ntryL,G1H16(240),ex2(:),G1H8(22),m3h2x8(:,432),heltab2x16(:,:,866))
  call Hloop_QA_Z(ntryL,G1H16(241),ex2(:),G1H8(38),ngZl,m3h2x8(:,433),heltab2x16(:,:,867))
  call Hloop_SA_Q(ntryL,G0H16(197),ex2(:),G0H8(63),ngPln,m3h2x8(:,434),heltab2x16(:,:,868))
  call Hloop_A_Q(ntryL,G0H8(63),18,0,G1H8(45),n2h8(246))
  call Hloop_WA_Q(ntryL,G0H16(198),ex2(:),G0H8(64),m3h2x8(:,435),heltab2x16(:,:,869))
  call Hloop_A_Q(ntryL,G0H8(64),18,0,G1H8(60),n2h8(247))
  call Hloop_WA_Q(ntryL,G1H16(242),ex2(:),G1H8(33),m3h2x8(:,436),heltab2x16(:,:,870))
  call Hloop_A_Q(ntryL,G1H8(33),18,0,G2H8(58),n2h8(248))
  call Hloop_SA_Q(ntryL,G0H4(85),ex2(:),G0H2(49),ngH,m3h2x2(:,487),heltab2x4(:,:,519))
  call Hloop_A_Q(ntryL,G0H2(49),27,nME,G1H2(376),n2h2(265))
  call Hloop_SA_Q(ntryL,G0H4(86),ex2(:),G0H2(49),ngX,m3h2x2(:,488),heltab2x4(:,:,520))
  call Hloop_A_Q(ntryL,G0H2(49),27,nME,G1H2(377),n2h2(266))
  call Hloop_QA_S(ntryL,G1H4(68),ex2(:),G1H2(380),ngPln,m3h2x2(:,489),heltab2x4(:,:,521))
  call Hloop_VA_Q(ntryL,G0H4(87),ex2(:),G0H2(49),m3h2x2(:,490),heltab2x4(:,:,522))
  call Hloop_A_Q(ntryL,G0H2(49),27,nME,G1H2(381),n2h2(267))
  call Hloop_ZA_Q(ntryL,G0H4(88),ex2(:),G0H2(49),ngZl,m3h2x2(:,491),heltab2x4(:,:,523))
  call Hloop_A_Q(ntryL,G0H2(49),27,nME,G1H2(382),n2h2(268))
  call Hloop_QA_S(ntryL,G1H4(74),ex2(:),G1H2(385),ngPln,m3h2x2(:,492),heltab2x4(:,:,524))
  call Hloop_QA_W(ntryL,G1H4(86),ex2(:),G1H2(386),m3h2x2(:,493),heltab2x4(:,:,525))
  call Hloop_QA_W(ntryL,G1H4(92),ex2(:),G1H2(387),m3h2x2(:,494),heltab2x4(:,:,526))
  call Hloop_QV_A(ntryL,G1H8(131),ex3(:),G1H4(219),m3h2x4(:,245),heltab2x8(:,:,499))
  call Hloop_Q_A(ntryL,G1H4(219),21,nME,G2H4(108),n2h4(289))
  call Hloop_QV_A(ntryL,G1H8(12),ex3(:),G1H4(215),m3h2x4(:,246),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H4(215),21,nME,G2H4(43),n2h4(290))
  call Hloop_TV_S(ntryL,G0H8(77),17,ex3(:),4,G1H4(207),m3h2x4(:,247),heltab2x8(:,:,501))
  call Hloop_QV_A(ntryL,G1H8(24),ex3(:),G1H4(203),m3h2x4(:,248),heltab2x8(:,:,502))
  call Hloop_Q_A(ntryL,G1H4(203),21,nME,G2H4(50),n2h4(291))
  call Hloop_QV_A(ntryL,G1H8(27),ex3(:),G1H4(220),m3h2x4(:,249),heltab2x8(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(220),21,nME,G2H4(88),n2h4(292))
  call Hloop_SV_V(ntryL,G0H8(78),ex3(:),G0H4(78),m3h2x4(:,250),heltab2x8(:,:,504))
  call Hloop_VV_S(ntryL,G0H8(79),ex3(:),G0H4(36),m3h2x4(:,251),heltab2x8(:,:,505))
  call Hloop_UV_W(ntryL,G0H8(80),17,ex3(:),4,G1H4(216),m3h2x4(:,252),heltab2x8(:,:,506))
  call Hloop_QV_A(ntryL,G1H16(243),ex3(:),G1H8(132),m3h2x8(:,437),heltab2x16(:,:,871))
  call Hloop_Q_A(ntryL,G1H8(132),20,nME,G2H8(59),n2h8(249))
  call Hloop_AV_Q(ntryL,G1H16(244),ex3(:),G1H8(133),m3h2x8(:,438),heltab2x16(:,:,872))
  call Hloop_A_Q(ntryL,G1H8(133),20,nME,G2H8(60),n2h8(250))
  call Hloop_QV_A(ntryL,G1H16(245),ex3(:),G1H8(135),m3h2x8(:,439),heltab2x16(:,:,873))
  call Hloop_Q_A(ntryL,G1H8(135),20,nME,G2H8(61),n2h8(251))
  call Hloop_AV_Q(ntryL,G1H16(246),ex3(:),G1H8(136),m3h2x8(:,440),heltab2x16(:,:,874))
  call Hloop_A_Q(ntryL,G1H8(136),20,nME,G2H8(62),n2h8(252))
  call Hloop_TV_S(ntryL,G1H16(247),16,ex3(:),4,G2H8(63),m3h2x8(:,441),heltab2x16(:,:,875))
  call Hloop_SV_T(ntryL,G1H16(248),16,ex3(:),4,G2H8(64),m3h2x8(:,442),heltab2x16(:,:,876))
  call Hloop_CV_D(ntryL,G1H16(251),16,ex3(:),4,G2H8(65),m3h2x8(:,443),heltab2x16(:,:,877))
  call Hloop_DV_C(ntryL,G1H16(252),16,ex3(:),G2H8(66),m3h2x8(:,444),heltab2x16(:,:,878))
  call Hloop_CV_D(ntryL,G1H16(255),16,ex3(:),4,G2H8(67),m3h2x8(:,445),heltab2x16(:,:,879))
  call Hloop_DV_C(ntryL,G1H16(256),16,ex3(:),G2H8(68),m3h2x8(:,446),heltab2x16(:,:,880))
  call Hloop_UV_W(ntryL,G1H16(257),16,ex3(:),4,G2H8(69),m3h2x8(:,447),heltab2x16(:,:,881))
  call Hloop_UW_V(ntryL,G1H16(258),16,ex3(:),4,G2H8(70),m3h2x8(:,448),heltab2x16(:,:,882))
  call Hloop_TV_S(ntryL,G0H16(203),16,ex3(:),4,G1H8(137),m3h2x8(:,449),heltab2x16(:,:,883))
  call Hloop_SV_T(ntryL,G0H16(204),16,ex3(:),4,G1H8(138),m3h2x8(:,450),heltab2x16(:,:,884))
  call Hloop_TV_S(ntryL,G0H16(41),16,ex3(:),4,G1H8(140),m3h2x8(:,451),heltab2x16(:,:,885))
  call Hloop_SV_T(ntryL,G0H16(42),16,ex3(:),4,G1H8(141),m3h2x8(:,452),heltab2x16(:,:,886))
  call Hloop_SV_V(ntryL,G1H16(260),ex3(:),G1H8(142),m3h2x8(:,453),heltab2x16(:,:,887))
  call Hloop_SV_V(ntryL,G1H16(262),ex3(:),G1H8(143),m3h2x8(:,454),heltab2x16(:,:,888))
  call Hloop_VV_S(ntryL,G0H16(44),ex3(:),G0H8(7),m3h2x8(:,455),heltab2x16(:,:,889))
  call Hloop_SV_V(ntryL,G0H16(48),ex3(:),G0H8(34),m3h2x8(:,456),heltab2x16(:,:,890))
  call Hloop_VV_S(ntryL,G1H16(264),ex3(:),G1H8(145),m3h2x8(:,457),heltab2x16(:,:,891))
  call Hloop_VV_S(ntryL,G1H16(266),ex3(:),G1H8(146),m3h2x8(:,458),heltab2x16(:,:,892))
  call Hloop_UV_W(ntryL,G0H16(5),16,ex3(:),4,G1H8(147),m3h2x8(:,459),heltab2x16(:,:,893))
  call Hloop_UW_V(ntryL,G0H16(6),16,ex3(:),4,G1H8(148),m3h2x8(:,460),heltab2x16(:,:,894))
  call Hloop_UV_W(ntryL,G0H16(55),16,ex3(:),4,G1H8(150),m3h2x8(:,461),heltab2x16(:,:,895))
  call Hloop_UW_V(ntryL,G0H16(56),16,ex3(:),4,G1H8(151),m3h2x8(:,462),heltab2x16(:,:,896))
  call Hloop_QV_A(ntryL,G1H16(267),ex3(:),G1H8(152),m3h2x8(:,463),heltab2x16(:,:,897))
  call Hloop_Q_A(ntryL,G1H8(152),20,nME,G2H8(71),n2h8(253))
  call Hloop_AV_Q(ntryL,G1H16(268),ex3(:),G1H8(153),m3h2x8(:,464),heltab2x16(:,:,898))
  call Hloop_A_Q(ntryL,G1H8(153),20,nME,G2H8(72),n2h8(254))
  call Hloop_QV_A(ntryL,G1H16(269),ex3(:),G1H8(155),m3h2x8(:,465),heltab2x16(:,:,899))
  call Hloop_Q_A(ntryL,G1H8(155),20,0,G2H8(73),n2h8(255))
  call Hloop_AV_Q(ntryL,G1H16(270),ex3(:),G1H8(156),m3h2x8(:,466),heltab2x16(:,:,900))
  call Hloop_A_Q(ntryL,G1H8(156),20,0,G2H8(74),n2h8(256))
  call Hloop_QV_A(ntryL,G1H16(271),ex3(:),G1H8(157),m3h2x8(:,467),heltab2x16(:,:,901))
  call Hloop_Q_A(ntryL,G1H8(157),20,nME,G2H8(75),n2h8(257))
  call Hloop_AV_Q(ntryL,G1H16(272),ex3(:),G1H8(158),m3h2x8(:,468),heltab2x16(:,:,902))
  call Hloop_A_Q(ntryL,G1H8(158),20,nME,G2H8(76),n2h8(258))
  call Hloop_QV_A(ntryL,G1H16(273),ex3(:),G1H8(160),m3h2x8(:,469),heltab2x16(:,:,903))
  call Hloop_Q_A(ntryL,G1H8(160),20,0,G2H8(77),n2h8(259))
  call Hloop_AV_Q(ntryL,G1H16(274),ex3(:),G1H8(161),m3h2x8(:,470),heltab2x16(:,:,904))
  call Hloop_A_Q(ntryL,G1H8(161),20,0,G2H8(78),n2h8(260))
  call Hloop_TV_S(ntryL,G1H16(275),16,ex3(:),4,G2H8(79),m3h2x8(:,471),heltab2x16(:,:,905))
  call Hloop_SV_T(ntryL,G1H16(276),16,ex3(:),4,G2H8(80),m3h2x8(:,472),heltab2x16(:,:,906))
  call Hloop_TV_S(ntryL,G1H16(277),16,ex3(:),4,G2H8(17),m3h2x8(:,473),heltab2x16(:,:,907))
  call Hloop_SV_T(ntryL,G1H16(278),16,ex3(:),4,G2H8(19),m3h2x8(:,474),heltab2x16(:,:,908))
  call Hloop_CV_D(ntryL,G1H16(281),16,ex3(:),4,G2H8(21),m3h2x8(:,475),heltab2x16(:,:,909))
  call Hloop_DV_C(ntryL,G1H16(282),16,ex3(:),G2H8(23),m3h2x8(:,476),heltab2x16(:,:,910))
  call Hloop_CV_D(ntryL,G1H16(285),16,ex3(:),4,G2H8(46),m3h2x8(:,477),heltab2x16(:,:,911))
  call Hloop_DV_C(ntryL,G1H16(286),16,ex3(:),G2H8(44),m3h2x8(:,478),heltab2x16(:,:,912))
  call Hloop_UV_W(ntryL,G1H16(287),16,ex3(:),4,G2H8(49),m3h2x8(:,479),heltab2x16(:,:,913))
  call Hloop_UW_V(ntryL,G1H16(288),16,ex3(:),4,G2H8(51),m3h2x8(:,480),heltab2x16(:,:,914))
  call Hloop_UV_W(ntryL,G1H16(289),16,ex3(:),4,G2H8(1),m3h2x8(:,481),heltab2x16(:,:,915))
  call Hloop_UW_V(ntryL,G1H16(290),16,ex3(:),4,G2H8(2),m3h2x8(:,482),heltab2x16(:,:,916))
  call Hloop_TV_S(ntryL,G0H16(85),16,ex3(:),4,G1H8(162),m3h2x8(:,483),heltab2x16(:,:,917))
  call Hloop_SV_T(ntryL,G0H16(86),16,ex3(:),4,G1H8(163),m3h2x8(:,484),heltab2x16(:,:,918))
  call Hloop_TV_S(ntryL,G0H16(89),16,ex3(:),4,G1H8(165),m3h2x8(:,485),heltab2x16(:,:,919))
  call Hloop_SV_T(ntryL,G0H16(90),16,ex3(:),4,G1H8(166),m3h2x8(:,486),heltab2x16(:,:,920))
  call Hloop_SV_V(ntryL,G1H16(292),ex3(:),G1H8(167),m3h2x8(:,487),heltab2x16(:,:,921))
  call Hloop_SV_V(ntryL,G1H16(294),ex3(:),G1H8(168),m3h2x8(:,488),heltab2x16(:,:,922))
  call Hloop_VV_S(ntryL,G0H16(91),ex3(:),G0H8(36),m3h2x8(:,489),heltab2x16(:,:,923))
  call Hloop_VV_S(ntryL,G0H16(92),ex3(:),G0H8(14),m3h2x8(:,490),heltab2x16(:,:,924))
  call Hloop_VV_S(ntryL,G0H16(95),ex3(:),G0H8(19),m3h2x8(:,491),heltab2x16(:,:,925))
  call Hloop_VV_S(ntryL,G0H16(96),ex3(:),G0H8(21),m3h2x8(:,492),heltab2x16(:,:,926))
  call Hloop_SV_V(ntryL,G0H16(98),ex3(:),G0H8(23),m3h2x8(:,493),heltab2x16(:,:,927))
  call Hloop_SV_V(ntryL,G0H16(100),ex3(:),G0H8(25),m3h2x8(:,494),heltab2x16(:,:,928))
  call Hloop_SV_V(ntryL,G0H16(115),ex3(:),G0H8(49),m3h2x8(:,495),heltab2x16(:,:,929))
  call Hloop_SV_V(ntryL,G0H16(116),ex3(:),G0H8(51),m3h2x8(:,496),heltab2x16(:,:,930))
  call Hloop_VV_S(ntryL,G1H16(296),ex3(:),G1H8(170),m3h2x8(:,497),heltab2x16(:,:,931))
  call Hloop_VV_S(ntryL,G1H16(298),ex3(:),G1H8(171),m3h2x8(:,498),heltab2x16(:,:,932))
  call Hloop_UV_W(ntryL,G0H16(117),16,ex3(:),4,G1H8(172),m3h2x8(:,499),heltab2x16(:,:,933))
  call Hloop_UW_V(ntryL,G0H16(118),16,ex3(:),4,G1H8(173),m3h2x8(:,500),heltab2x16(:,:,934))
  call Hloop_UV_W(ntryL,G0H16(119),16,ex3(:),4,G1H8(175),m3h2x8(:,501),heltab2x16(:,:,935))
  call Hloop_UW_V(ntryL,G0H16(120),16,ex3(:),4,G1H8(176),m3h2x8(:,502),heltab2x16(:,:,936))
  call Hloop_AQ_S(ntryL,G1H16(299),ex1(:),G1H8(75),ngH,m3h2x8(:,503),heltab2x16(:,:,937))
  call Hloop_AQ_S(ntryL,G1H16(300),ex1(:),G1H8(76),ngX,m3h2x8(:,504),heltab2x16(:,:,938))
  call Hloop_SQ_A(ntryL,G1H16(301),ex1(:),G1H8(78),ngPnl,m3h2x8(:,505),heltab2x16(:,:,939))
  call Hloop_Q_A(ntryL,G1H8(78),17,0,G2H8(3),n2h8(261))
  call Hloop_AQ_V(ntryL,G1H16(302),ex1(:),G1H8(79),m3h2x8(:,506),heltab2x16(:,:,940))
  call Hloop_AQ_Z(ntryL,G1H16(303),ex1(:),G1H8(80),ngZl,m3h2x8(:,507),heltab2x16(:,:,941))
  call Hloop_SQ_A(ntryL,G0H16(145),ex1(:),G0H8(53),ngPnl,m3h2x8(:,508),heltab2x16(:,:,942))
  call Hloop_Q_A(ntryL,G0H8(53),17,0,G1H8(81),n2h8(262))
  call Hloop_WQ_A(ntryL,G0H16(146),ex1(:),G0H8(55),m3h2x8(:,509),heltab2x16(:,:,943))
  call Hloop_Q_A(ntryL,G0H8(55),17,0,G1H8(83),n2h8(263))
  call Hloop_WQ_A(ntryL,G1H16(304),ex1(:),G1H8(84),m3h2x8(:,510),heltab2x16(:,:,944))
  call Hloop_Q_A(ntryL,G1H8(84),17,0,G2H8(4),n2h8(264))
  call Hloop_SQ_A(ntryL,G0H4(125),ex1(:),G0H2(49),ngH,m3h2x2(:,495),heltab2x4(:,:,527))
  call Hloop_Q_A(ntryL,G0H2(49),27,nME,G1H2(390),n2h2(269))
  call Hloop_SQ_A(ntryL,G0H4(126),ex1(:),G0H2(49),ngX,m3h2x2(:,496),heltab2x4(:,:,528))
  call Hloop_Q_A(ntryL,G0H2(49),27,nME,G1H2(391),n2h2(270))
  call Hloop_AQ_S(ntryL,G1H4(205),ex1(:),G1H2(392),ngPnl,m3h2x2(:,497),heltab2x4(:,:,529))
  call Hloop_VQ_A(ntryL,G0H4(127),ex1(:),G0H2(49),m3h2x2(:,498),heltab2x4(:,:,530))
  call Hloop_Q_A(ntryL,G0H2(49),27,nME,G1H2(395),n2h2(271))
  call Hloop_ZQ_A(ntryL,G0H4(128),ex1(:),G0H2(49),ngZl,m3h2x2(:,499),heltab2x4(:,:,531))
  call Hloop_Q_A(ntryL,G0H2(49),27,nME,G1H2(396),n2h2(272))
  call Hloop_AQ_S(ntryL,G1H4(102),ex1(:),G1H2(397),ngPnl,m3h2x2(:,500),heltab2x4(:,:,532))
  call Hloop_AQ_W(ntryL,G1H4(90),ex1(:),G1H2(400),m3h2x2(:,501),heltab2x4(:,:,533))
  call Hloop_AQ_W(ntryL,G1H4(88),ex1(:),G1H2(401),m3h2x2(:,502),heltab2x4(:,:,534))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(188),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(13),G1H2(58)])
call HGT_OLR(G2H2(222),1,1,2)
call HGT_invQ_OLR(G2H2(222),2,5,2)
call HGT_OLR(G2H2(222),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(102),G2H2(165),G2H2(161),G2H2(123),G2H2(113) &
    ,G2H2(107),G2H2(101),G2H2(362),G2H2(350),G2H2(332),G2H2(326),G2H2(223),G1H2(501),G1H2(498),G1H2(176),G1H2(490),G1H2(6) &
    ,G1H2(192),G1H2(19),G1H2(318)])
call ol_merge_last(G1H2(195), G1H2(195)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(275),[G1H2(51),G1H2(40),G0H2(1)])
call HGT_OLR(G2H2(226),1,1,2)
call HGT_invQ_OLR(G2H2(226),2,5,2)
call HGT_OLR(G2H2(226),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G1H2(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(399),[G2H2(402),G2H2(142),G2H2(135),G2H2(380),G2H2(374) &
    ,G2H2(227),G1H2(97),G1H2(119),G1H2(294),G1H2(17),G1H2(327),G1H2(21),G1H2(127),G1H2(37),G1H2(414),G1H2(399),G1H2(138),G1H2(302) &
    ,G0H2(44),G0H2(42),G0H2(34),G0H2(32),G0H2(12),G0H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G2H2(171),G2H2(109),G2H2(61),G2H2(347),G2H2(344) &
    ,G2H2(266),G2H2(230),G1H2(361),G1H2(360),G1H2(351),G1H2(350),G1H2(347),G1H2(346),G1H2(136),G1H2(126),G1H2(85),G1H2(78) &
    ,G1H2(77),G1H2(71),G1H2(91),G1H2(46),G0H2(39),G0H2(29),G0H2(18),G0H2(17)])
call ol_merge_last(G2H2(236), G2H2(236)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(291),G1H2(225),G0H2(3)])
call HGT_lower_alpha_w2_OLR(G2H2(236),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(236),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(236),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(168),G2H2(105),G2H2(194),G2H2(341),G2H2(338) &
    ,G2H2(269),G2H2(233),G1H2(357),G1H2(356),G1H2(355),G1H2(352),G1H2(345),G1H2(342),G1H2(115),G1H2(133),G1H2(104),G1H2(100) &
    ,G1H2(102),G1H2(66),G1H2(28),G1H2(172),G0H2(40),G0H2(30),G0H2(20),G0H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(333),G2H2(157),G2H2(87),G2H2(404),G2H2(398) &
    ,G2H2(237),G1H2(32),G1H2(193),G1H2(325),G1H2(29),G1H2(113),G1H2(7),G1H2(81),G1H2(149),G1H2(419),G1H2(409),G1H2(241),G1H2(329) &
    ,G0H2(48),G0H2(46),G0H2(38),G0H2(36),G0H2(16),G0H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(328),G2H2(140),G2H2(33),G1H2(111),G1H2(54) &
    ,G1H2(118),G1H2(284)])
call HGT_OLR(G2H2(240),1,1,2)
call HGT_invQ_OLR(G2H2(240),2,5,2)
call HGT_OLR(G2H2(240),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G1H2(509),G1H2(148),G1H2(65),G1H2(124)])
call ol_merge_last(G1H2(217), G1H2(217)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(67),G1H2(107),G1H2(297),G0H2(21)])
call HGT_OLR(G2H2(244),1,1,2)
call HGT_invQ_OLR(G2H2(244),2,5,2)
call HGT_OLR(G2H2(244),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G1H2(429),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G2H2(248)])
call ol_merge_last(G2H2(254), G2H2(254)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(97),G1H2(147),G1H2(324),G0H2(23)])
call HGT_lower_alpha_w2_OLR(G2H2(254),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(254),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(254),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(287),[G2H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(255),[G1H2(439),G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(251),G1H2(212)])
call HGT_OLR(G2H2(258),1,1,2)
call HGT_invQ_OLR(G2H2(258),2,5,2)
call HGT_OLR(G2H2(258),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G1H2(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(98),G2H2(45),G2H2(49),G2H2(119),G2H2(12) &
    ,G2H2(10),G2H2(73),G2H2(365),G2H2(353),G2H2(335),G2H2(329),G2H2(259),G1H2(519),G1H2(482),G1H2(109),G1H2(89),G1H2(130) &
    ,G1H2(289),G1H2(230),G1H2(74)])
call ol_merge_last(G1H2(243), G1H2(243)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(262),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(52),G1H2(282),G0H2(2)])
call HGT_OLR(G2H2(262),1,1,2)
call HGT_invQ_OLR(G2H2(262),2,5,2)
call HGT_OLR(G2H2(262),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(262),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(375),[G2H2(378),G2H2(139),G2H2(131),G2H2(383),G2H2(377) &
    ,G2H2(263),G1H2(123),G1H2(337),G1H2(266),G1H2(8),G1H2(11),G1H2(5),G1H2(43),G1H2(33),G1H2(449),G1H2(384),G1H2(299),G1H2(228) &
    ,G0H2(43),G0H2(41),G0H2(33),G0H2(31),G0H2(11),G0H2(9)])
call ol_merge_last(G2H2(272), G2H2(272)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(272),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(75),G1H2(101),G0H2(4)])
call HGT_lower_alpha_w2_OLR(G2H2(272),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(272),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(272),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(272),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(327),[G2H2(351),G2H2(202),G2H2(23),G2H2(407),G2H2(401) &
    ,G2H2(273),G1H2(80),G1H2(82),G1H2(305),G1H2(23),G1H2(18),G1H2(311),G1H2(1),G1H2(116),G1H2(459),G1H2(389),G1H2(139),G1H2(281) &
    ,G0H2(47),G0H2(45),G0H2(37),G0H2(35),G0H2(15),G0H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(55),G2H2(136),G2H2(397),G1H2(364),G1H2(344) &
    ,G1H2(140),G1H2(68)])
call HGT_OLR(G2H2(276),1,1,2)
call HGT_invQ_OLR(G2H2(276),2,5,2)
call HGT_OLR(G2H2(276),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(276),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G1H2(529),G1H2(369),G1H2(349),G1H2(339)])
call ol_merge_last(G1H2(265), G1H2(265)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(280),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(71),G1H2(354),G1H2(227),G0H2(22)])
call HGT_OLR(G2H2(280),1,1,2)
call HGT_invQ_OLR(G2H2(280),2,5,2)
call HGT_OLR(G2H2(280),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(280),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(281),[G1H2(469),G1H2(359)])
call ol_merge_last(G2H2(290), G2H2(290)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(290),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(93),G1H2(374),G1H2(259),G0H2(24)])
call HGT_lower_alpha_w2_OLR(G2H2(290),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(290),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(290),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(290),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G1H2(479),G1H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(331),[G2H2(81),G1H2(336)])
call HGT_OLR(G2H2(294),1,1,2)
call HGT_invQ_OLR(G2H2(294),2,5,2)
call HGT_OLR(G2H2(294),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G2H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(295),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(325),[G2H2(349),G1H2(156)])
call HGT_OLR(G2H2(298),1,1,2)
call HGT_invQ_OLR(G2H2(298),2,5,2)
call HGT_OLR(G2H2(298),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(298),[G2H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(299),[G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G2H2(51),G1H2(63)])
call HGT_OLR(G2H2(302),1,1,2)
call HGT_invQ_OLR(G2H2(302),2,5,2)
call HGT_OLR(G2H2(302),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(302),[G2H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(303),[G1H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(47),G1H2(561)])
call HGT_OLR(G2H2(306),1,1,2)
call HGT_invQ_OLR(G2H2(306),2,5,2)
call HGT_OLR(G2H2(306),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(306),[G2H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G1H2(540)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(330),[G2H2(354),G2H2(21),G2H2(145),G2H2(395),G2H2(389) &
    ,G2H2(311),G1H2(332),G1H2(298),G1H2(67),G1H2(61),G1H2(544),G1H2(535)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(336),G2H2(153),G2H2(149),G2H2(392),G2H2(386) &
    ,G2H2(315),G1H2(316),G1H2(326),G1H2(103),G1H2(27),G1H2(548),G1H2(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(72),G2H2(127),G2H2(116),G2H2(371),G2H2(359) &
    ,G2H2(319),G1H2(562),G1H2(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(83),G2H2(186),G2H2(69),G2H2(368),G2H2(356) &
    ,G2H2(323),G1H2(558),G1H2(556)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G2H4(45),G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(86),G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(110),G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G2H4(114),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(390),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(485),G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(396),[G1H2(391),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(86),G1H2(493),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(392),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(394),G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(395),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(181),[G1H2(160),G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(401),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(404),G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(362),[G1H2(174),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(504),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(370),[G1H2(365),G1H2(497),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(512),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(366),[G1H2(413),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(424),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(367),[G1H2(500),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(236),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(375),[G1H2(418),G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(434),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(376),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(252),G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(382),[G1H2(377),G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(240),G1H2(522),G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(380),[G1H2(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(224),[G1H2(444),G1H2(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(381),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(213),[G1H2(279),G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(387),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(454),G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(88),G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(295),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(170),G1H2(99),G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(532),[G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(383),G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(464),[G1H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(481),G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(368)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(187),[G1H2(388),G1H2(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(474),[G1H2(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(337),[G1H2(117),G1H2(398),G1H2(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G1H2(182),G1H2(408),G1H2(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G1H2(428),G1H2(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(438),G1H2(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G1H2(106),G1H2(448),G1H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G1H2(128),G1H2(458),G1H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(151),[G1H2(468),G1H2(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(400),[G1H2(478),G1H2(473)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(158),G1H2(492),G1H2(489),G1H2(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G1H2(234),G1H2(511),G1H2(508),G1H2(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(343),[G1H2(277),G1H2(521),G1H2(518),G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G1H2(320),G1H2(531),G1H2(528),G1H2(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(539)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(373),[G1H2(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(547)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(551)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G1H2(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G2H2(169),G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(166),G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(120),G0H2(26),G0H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(334),[G2H2(352),G0H2(28),G0H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(29),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(32),G1H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(54),G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(65),G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(5),G0H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(7),G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G2H8(9),G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G2H8(10),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(269),G0H2(6),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(312),G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(118),G2H4(117),G2H4(66),G1H4(64),G1H4(66) &
    ,G1H4(106),G0H4(90),G0H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G2H4(84),G2H4(120),G2H4(79),G1H4(218),G1H4(46) &
    ,G1H4(212),G0H4(25),G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G0H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G0H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(25),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(29),G0H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(7),G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(40),G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(37),G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(69),[G1H8(68),G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G0H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G0H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G0H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(117),[G1H8(103),G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(108),G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(120),G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(129),[G1H8(127),G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(58),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(216),[G0H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G2H8(63),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G2H8(69),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(138),G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(146),[G1H8(141),G1H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(148),[G1H8(147),G1H8(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(150),G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(170),[G1H8(163),G1H8(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(166),G1H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(172),G1H8(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(176),[G1H8(175),G1H8(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(81)])
call HGT_OLR(G1H2(188),1,1,2)
call HGT_invQ_OLR(G1H2(188),2,5,2)
  call Hloop_SQ_A(ntryL,G1H2(188),ex1(:),G1H1(1),ngPnl,m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(413))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(210),ex2(:),G2tensor(30),ngPln,m3h2x1(:,638),heltab2x2(:,:,638))
call HGT_w2_OLR(G1H2(205),1,1,2)
call HGT_w2_invQ_OLR(G1H2(205),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(205),ex1(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(414))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(213),ex2(:),G2tensor(14),m3h2x1(:,640),heltab2x2(:,:,640))
call HGT_OLR(G1H2(183),1,1,2)
call HGT_invQ_OLR(G1H2(183),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(183),ex2(:),G1H1(1),ngPln,m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(415))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(216),ex1(:),G2tensor(201),ngPnl,m3h2x1(:,642),heltab2x2(:,:,642))
call HGT_w2_OLR(G1H2(184),1,1,2)
call HGT_w2_invQ_OLR(G1H2(184),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(184),ex2(:),G1H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(416))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(219),ex1(:),G2tensor(39),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hloop_QV_A(ntryL,G2H2(222),ex3(:),G2H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(31),n2h1(417))
  call Hloop_QV_A(ntryL,G2H2(99),ex4(:),G2H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(32),n2h1(418))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(226),27,ex3(:),4,G3tensor(33),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(399),23,ex4(:),8,G3tensor(34),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(175),ex4(:),G2tensor(16),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(236),27,ex3(:),4,G3tensor(35),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(15),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(11),23,ex4(:),8,G3tensor(36),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hloop_QV_A(ntryL,G2H2(240),ex4(:),G2H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(37),n2h1(419))
  call Hloop_QV_A(ntryL,G2H2(241),ex3(:),G2H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(38),n2h1(420))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(244),23,ex4(:),8,G3tensor(39),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(245),27,ex3(:),4,G3tensor(40),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(284),ex3(:),G2tensor(195),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(254),23,ex4(:),8,G3tensor(41),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(287),ex3(:),G2tensor(48),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(255),27,ex3(:),4,G3tensor(42),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hloop_AV_Q(ntryL,G2H2(258),ex3(:),G2H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(43),n2h1(421))
  call Hloop_AV_Q(ntryL,G2H2(95),ex4(:),G2H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(44),n2h1(422))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(262),27,ex3(:),4,G3tensor(45),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(375),23,ex4(:),8,G3tensor(46),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(272),27,ex3(:),4,G3tensor(47),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(327),23,ex4(:),8,G3tensor(48),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hloop_AV_Q(ntryL,G2H2(276),ex4(:),G2H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(49),n2h1(423))
  call Hloop_AV_Q(ntryL,G2H2(277),ex3(:),G2H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(50),n2h1(424))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(280),23,ex4(:),8,G3tensor(51),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(281),27,ex3(:),4,G3tensor(52),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(290),23,ex4(:),8,G3tensor(53),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(291),27,ex3(:),4,G3tensor(54),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(294),23,ex4(:),8,G3tensor(55),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(295),27,ex3(:),4,G3tensor(56),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(298),23,ex4(:),G3tensor(57),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(299),27,ex3(:),G3tensor(58),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hloop_QV_A(ntryL,G2H2(302),ex4(:),G2H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(59),n2h1(425))
  call Hloop_QV_A(ntryL,G2H2(303),ex3(:),G2H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(60),n2h1(426))
  call Hloop_AV_Q(ntryL,G2H2(306),ex4(:),G2H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(61),n2h1(427))
  call Hloop_AV_Q(ntryL,G2H2(307),ex3(:),G2H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(62),n2h1(428))
call HGT_OLR(G2H2(310),1,1,2)
call HGT_invQ_OLR(G2H2(310),2,5,2)
call HGT_OLR(G2H2(310),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(310),27,ex3(:),G3tensor(63),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(330),23,ex4(:),G3tensor(64),m3h2x1(:,682),heltab2x2(:,:,682))
call HGT_OLR(G2H2(314),1,1,2)
call HGT_invQ_OLR(G2H2(314),2,5,2)
call HGT_OLR(G2H2(314),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(314),27,ex3(:),4,G3tensor(65),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(24),23,ex4(:),8,G3tensor(66),m3h2x1(:,684),heltab2x2(:,:,684))
call HGT_OLR(G2H2(318),1,1,2)
call HGT_invQ_OLR(G2H2(318),2,5,2)
call HGT_OLR(G2H2(318),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(318),ex3(:),G2H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(67),n2h1(429))
  call Hloop_AV_Q(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(68),n2h1(430))
call HGT_OLR(G2H2(322),1,1,2)
call HGT_invQ_OLR(G2H2(322),2,5,2)
call HGT_OLR(G2H2(322),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(322),ex3(:),G2H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(69),n2h1(431))
  call Hloop_QV_A(ntryL,G2H2(86),ex4(:),G2H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(70),n2h1(432))
call HGT_OLR(G2H4(76),1,1,4)
call HGT_invQ_OLR(G2H4(76),2,5,4)
call HGT_OLR(G2H4(76),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(76),wf4(:,36),G2H1(1),ngH,m3h4x1(:,33),heltab2x4(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(71),n2h1(433))
call HGT_OLR(G2H4(74),1,1,4)
call HGT_invQ_OLR(G2H4(74),2,5,4)
call HGT_OLR(G2H4(74),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(74),wf4(:,36),G2H1(1),ngH,m3h4x1(:,34),heltab2x4(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(72),n2h1(434))
call HGT_OLR(G2H4(94),1,1,4)
call HGT_invQ_OLR(G2H4(94),2,5,4)
call HGT_OLR(G2H4(94),6,15,4)
  call Hloop_QS_A(ntryL,G2H4(94),wf4(:,37),G2H1(1),ngX,m3h4x1(:,35),heltab2x4(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(73),n2h1(435))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_AS_Q(ntryL,G2H4(5),wf4(:,37),G2H1(1),ngX,m3h4x1(:,36),heltab2x4(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(74),n2h1(436))
call HGT_lower_alpha_w2_OLR(G1H4(189),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(189),2,5,4)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(189),28,wf4(:,36),3,G2tensor(45),m3h4x1(:,37),heltab2x4(:,:,539))
call HGT_lower_alpha_w2_OLR(G1H4(185),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(185),2,5,4)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(185),28,wf4(:,37),3,G2tensor(36),m3h4x1(:,38),heltab2x4(:,:,540))
call HGT_w2_OLR(G1H4(202),1,1,4)
call HGT_w2_invQ_OLR(G1H4(202),2,5,4)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(202),28,wf4(:,36),3,G2tensor(33),m3h4x1(:,39),heltab2x4(:,:,541))
call HGT_w2_OLR(G1H4(198),1,1,4)
call HGT_w2_invQ_OLR(G1H4(198),2,5,4)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(198),28,wf4(:,37),3,G2tensor(20),m3h4x1(:,40),heltab2x4(:,:,542))
call HGT_OLR(G2H4(105),1,1,4)
call HGT_invQ_OLR(G2H4(105),2,5,4)
call HGT_OLR(G2H4(105),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(105),wf4(:,13),G2H1(1),m3h4x1(:,41),heltab2x4(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(75),n2h1(437))
call HGT_OLR(G2H4(40),1,1,4)
call HGT_invQ_OLR(G2H4(40),2,5,4)
call HGT_OLR(G2H4(40),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(40),wf4(:,13),G2H1(1),m3h4x1(:,42),heltab2x4(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(76),n2h1(438))
call HGT_OLR(G2H4(21),1,1,4)
call HGT_invQ_OLR(G2H4(21),2,5,4)
call HGT_OLR(G2H4(21),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(21),wf4(:,13),G2H1(1),m3h4x1(:,43),heltab2x4(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(77),n2h1(439))
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(19),wf4(:,13),G2H1(1),m3h4x1(:,44),heltab2x4(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(78),n2h1(440))
call HGT_OLR(G2H4(49),1,1,4)
call HGT_invQ_OLR(G2H4(49),2,5,4)
call HGT_OLR(G2H4(49),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(49),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,45),heltab2x4(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(79),n2h1(441))
call HGT_OLR(G2H4(96),1,1,4)
call HGT_invQ_OLR(G2H4(96),2,5,4)
call HGT_OLR(G2H4(96),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(96),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,46),heltab2x4(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(80),n2h1(442))
call HGT_OLR(G2H4(31),1,1,4)
call HGT_invQ_OLR(G2H4(31),2,5,4)
call HGT_OLR(G2H4(31),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(31),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,47),heltab2x4(:,:,549))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(81),n2h1(443))
call HGT_OLR(G2H4(58),1,1,4)
call HGT_invQ_OLR(G2H4(58),2,5,4)
call HGT_OLR(G2H4(58),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(58),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,48),heltab2x4(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(82),n2h1(444))
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(52),28,wf4(:,13),3,G3tensor(83),m3h4x1(:,49),heltab2x4(:,:,551))
call HGT_OLR(G2H4(53),1,1,4)
call HGT_invQ_OLR(G2H4(53),2,5,4)
call HGT_OLR(G2H4(53),6,15,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(53),28,wf4(:,13),3,G3tensor(84),m3h4x1(:,50),heltab2x4(:,:,552))
call HGT_OLR(G2H4(22),1,1,4)
call HGT_invQ_OLR(G2H4(22),2,5,4)
call HGT_OLR(G2H4(22),6,15,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(22),28,wf4(:,14),3,G3tensor(85),m3h4x1(:,51),heltab2x4(:,:,553))
call HGT_OLR(G2H4(23),1,1,4)
call HGT_invQ_OLR(G2H4(23),2,5,4)
call HGT_OLR(G2H4(23),6,15,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(23),28,wf4(:,14),3,G3tensor(86),m3h4x1(:,52),heltab2x4(:,:,554))
call HGT_OLR(G2H4(63),1,1,4)
call HGT_invQ_OLR(G2H4(63),2,5,4)
call HGT_OLR(G2H4(63),6,15,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(63),28,wf4(:,13),3,G3tensor(87),m3h4x1(:,53),heltab2x4(:,:,555))
call HGT_OLR(G2H4(62),1,1,4)
call HGT_invQ_OLR(G2H4(62),2,5,4)
call HGT_OLR(G2H4(62),6,15,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(62),28,wf4(:,13),G3tensor(88),m3h4x1(:,54),heltab2x4(:,:,556))
call HGT_OLR(G2H4(61),1,1,4)
call HGT_invQ_OLR(G2H4(61),2,5,4)
call HGT_OLR(G2H4(61),6,15,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(61),28,wf4(:,14),3,G3tensor(89),m3h4x1(:,55),heltab2x4(:,:,557))
call HGT_OLR(G2H4(72),1,1,4)
call HGT_invQ_OLR(G2H4(72),2,5,4)
call HGT_OLR(G2H4(72),6,15,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(72),28,wf4(:,14),G3tensor(90),m3h4x1(:,56),heltab2x4(:,:,558))
call HGT_lower_alpha_OLR(G2H4(69),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(69),2,5,4)
call HGT_lower_alpha_OLR(G2H4(69),6,15,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(69),28,wf4(:,13),3,G3tensor(91),m3h4x1(:,57),heltab2x4(:,:,559))
call HGT_lower_alpha_OLR(G2H4(68),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(68),2,5,4)
call HGT_lower_alpha_OLR(G2H4(68),6,15,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(68),28,wf4(:,13),3,G3tensor(92),m3h4x1(:,58),heltab2x4(:,:,560))
call HGT_lower_alpha_OLR(G2H4(35),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(35),2,5,4)
call HGT_lower_alpha_OLR(G2H4(35),6,15,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(35),28,wf4(:,14),3,G3tensor(93),m3h4x1(:,59),heltab2x4(:,:,561))
call HGT_lower_alpha_OLR(G2H4(36),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(36),2,5,4)
call HGT_lower_alpha_OLR(G2H4(36),6,15,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(36),28,wf4(:,14),3,G3tensor(94),m3h4x1(:,60),heltab2x4(:,:,562))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(97),wf4(:,9),G2tensor(19),ngPnl,m3h4x1(:,61),heltab2x4(:,:,563))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(124),wf4(:,9),G2tensor(18),m3h4x1(:,62),heltab2x4(:,:,564))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(122),wf4(:,4),G2tensor(17),ngPln,m3h4x1(:,63),heltab2x4(:,:,565))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(123),wf4(:,4),G2tensor(193),m3h4x1(:,64),heltab2x4(:,:,566))
  call Hloop_SA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),ngH,m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(60),n2h1(445))
  call Hloop_SA_Q(ntryL,G1H2(38),ex2(:),G1H1(1),ngH,m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(57),n2h1(446))
  call Hloop_SA_Q(ntryL,G1H2(150),ex2(:),G1H1(1),ngX,m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(54),n2h1(447))
  call Hloop_SA_Q(ntryL,G1H2(166),ex2(:),G1H1(1),ngX,m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(51),n2h1(448))
  call Hloop_VA_Q(ntryL,G1H2(226),ex2(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(24),n2h1(449))
  call Hloop_VA_Q(ntryL,G1H2(258),ex2(:),G1H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(23),n2h1(450))
  call Hloop_ZA_Q(ntryL,G1H2(328),ex2(:),G1H1(1),ngZl,m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(22),n2h1(451))
  call Hloop_ZA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),ngZl,m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(21),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(390),ex3(:),G1H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(173),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(29),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(396),ex3(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(26),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(288),n2h1(456))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(392),27,ex3(:),4,G2tensor(35),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(31),23,ex4(:),8,G2tensor(32),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hloop_QV_A(ntryL,G1H2(395),ex3(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(177),n2h1(457))
  call Hloop_QV_A(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(41),n2h1(458))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(401),27,ex3(:),4,G2tensor(38),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),23,ex4(:),8,G2tensor(333),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hloop_SQ_A(ntryL,G1H2(257),ex1(:),G1H1(1),ngH,m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(192),n2h1(459))
  call Hloop_SQ_A(ntryL,G1H2(268),ex1(:),G1H1(1),ngH,m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(191),n2h1(460))
  call Hloop_SQ_A(ntryL,G1H2(300),ex1(:),G1H1(1),ngX,m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(47),n2h1(461))
  call Hloop_SQ_A(ntryL,G1H2(114),ex1(:),G1H1(1),ngX,m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(44),n2h1(462))
  call Hloop_VQ_A(ntryL,G1H2(73),ex1(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(363),n2h1(463))
  call Hloop_VQ_A(ntryL,G1H2(125),ex1(:),G1H1(1),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(53),n2h1(464))
  call Hloop_ZQ_A(ntryL,G1H2(79),ex1(:),G1H1(1),ngZl,m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(50),n2h1(465))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex1(:),G1H1(1),ngZl,m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(393),n2h1(466))
  call Hloop_QV_A(ntryL,G1H2(362),ex4(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(190),n2h1(467))
  call Hloop_QV_A(ntryL,G1H2(504),ex3(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(189),n2h1(468))
  call Hloop_QV_A(ntryL,G1H2(370),ex4(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(59),n2h1(469))
  call Hloop_QV_A(ntryL,G1H2(512),ex3(:),G1H1(1),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(56),n2h1(470))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(366),23,ex4(:),8,G2tensor(66),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(424),27,ex3(:),4,G2tensor(67),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hloop_QV_A(ntryL,G1H2(367),ex4(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(267),n2h1(471))
  call Hloop_QV_A(ntryL,G1H2(236),ex3(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(70),n2h1(472))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(375),23,ex4(:),8,G2tensor(558),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(434),27,ex3(:),4,G2tensor(71),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hloop_AV_Q(ntryL,G1H2(376),ex3(:),G1H1(1),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(74),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(75),n2h1(474))
  call Hloop_AV_Q(ntryL,G1H2(382),ex3(:),G1H1(1),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(78),n2h1(475))
  call Hloop_AV_Q(ntryL,G1H2(219),ex4(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(79),n2h1(476))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(380),27,ex3(:),4,G2tensor(82),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(224),23,ex4(:),8,G2tensor(83),m3h2x1(:,730),heltab2x2(:,:,730))
  call Hloop_AV_Q(ntryL,G1H2(381),ex3(:),G1H1(1),m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(87),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H2(213),ex4(:),G1H1(1),m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(88),n2h1(478))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(387),27,ex3(:),4,G2tensor(92),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(255),23,ex4(:),8,G2tensor(93),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hloop_AV_Q(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(312),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H2(295),ex3(:),G1H1(1),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(96),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(546),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H2(532),ex3(:),G1H1(1),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(97),n2h1(482))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(154),23,ex4(:),8,G2tensor(100),m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(464),27,ex3(:),4,G2tensor(101),m3h2x1(:,740),heltab2x2(:,:,740))
  call Hloop_AV_Q(ntryL,G1H2(159),ex4(:),G1H1(1),m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(104),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H2(322),ex3(:),G1H1(1),m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(108),n2h1(484))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(187),23,ex4(:),8,G2tensor(113),m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(474),27,ex3(:),4,G2tensor(118),m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(337),23,ex4(:),8,G3tensor(95),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(163),23,ex4(:),8,G3tensor(96),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(150),27,ex3(:),4,G3tensor(97),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(27),27,ex3(:),4,G3tensor(98),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(176),23,ex4(:),8,G3tensor(99),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(155),23,ex4(:),8,G3tensor(100),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(151),27,ex3(:),4,G3tensor(101),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(400),27,ex3(:),4,G3tensor(102),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hloop_QV_A(ntryL,G2H2(25),ex4(:),G2H1(1),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(103),n2h1(485))
  call Hloop_QV_A(ntryL,G2H2(162),ex3(:),G2H1(1),m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(104),n2h1(486))
  call Hloop_AV_Q(ntryL,G2H2(343),ex4(:),G2H1(1),m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(105),n2h1(487))
  call Hloop_AV_Q(ntryL,G2H2(154),ex3(:),G2H1(1),m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(106),n2h1(488))
  call Hloop_SQ_A(ntryL,G1H4(208),wf4(:,9),G1H1(1),ngH,m3h4x1(:,65),heltab2x4(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(119),n2h1(489))
  call Hloop_SQ_A(ntryL,G1H4(111),wf4(:,9),G1H1(1),ngH,m3h4x1(:,66),heltab2x4(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(122),n2h1(490))
  call Hloop_SQ_A(ntryL,G1H4(4),wf4(:,9),G1H1(1),ngX,m3h4x1(:,67),heltab2x4(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(123),n2h1(491))
  call Hloop_SQ_A(ntryL,G1H4(126),wf4(:,9),G1H1(1),ngX,m3h4x1(:,68),heltab2x4(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(127),n2h1(492))
  call Hloop_VQ_A(ntryL,G1H4(19),wf4(:,9),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(128),n2h1(493))
  call Hloop_VQ_A(ntryL,G1H4(114),wf4(:,9),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(132),n2h1(494))
  call Hloop_ZQ_A(ntryL,G1H4(237),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,71),heltab2x4(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(136),n2h1(495))
  call Hloop_ZQ_A(ntryL,G1H4(141),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,72),heltab2x4(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(141),n2h1(496))
  call Hloop_SA_Q(ntryL,G1H4(244),wf4(:,4),G1H1(1),ngH,m3h4x1(:,73),heltab2x4(:,:,575))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(411),n2h1(497))
  call Hloop_SA_Q(ntryL,G1H4(82),wf4(:,4),G1H1(1),ngH,m3h4x1(:,74),heltab2x4(:,:,576))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(176),n2h1(498))
  call Hloop_SA_Q(ntryL,G1H4(85),wf4(:,4),G1H1(1),ngX,m3h4x1(:,75),heltab2x4(:,:,577))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(174),n2h1(499))
  call Hloop_SA_Q(ntryL,G1H4(59),wf4(:,4),G1H1(1),ngX,m3h4x1(:,76),heltab2x4(:,:,578))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(537),n2h1(500))
  call Hloop_VA_Q(ntryL,G1H4(249),wf4(:,4),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,579))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(258),n2h1(501))
  call Hloop_VA_Q(ntryL,G1H4(53),wf4(:,4),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(255),n2h1(502))
  call Hloop_ZA_Q(ntryL,G1H4(256),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,79),heltab2x4(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(252),n2h1(503))
  call Hloop_ZA_Q(ntryL,G1H4(57),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,80),heltab2x4(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(249),n2h1(504))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(143),27,ex3(:),4,G3tensor(107),m3h2x1(:,757),heltab2x2(:,:,757))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(137),27,ex3(:),G3tensor(108),m3h2x1(:,758),heltab2x2(:,:,758))
  call Hloop_QV_A(ntryL,G2H2(124),ex3(:),G2H1(1),m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(109),n2h1(505))
  call Hloop_AV_Q(ntryL,G2H2(31),ex3(:),G2H1(1),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(110),n2h1(506))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(373),23,ex4(:),G3tensor(111),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(129),23,ex4(:),8,G3tensor(112),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hloop_AV_Q(ntryL,G2H2(125),ex4(:),G2H1(1),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(113),n2h1(507))
  call Hloop_QV_A(ntryL,G2H2(103),ex4(:),G2H1(1),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(114),n2h1(508))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(376),ex2(:),G2tensor(2),ngPln,m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(132),ex2(:),G2tensor(25),m3h2x1(:,766),heltab2x2(:,:,766))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(128),ex1(:),G2tensor(417),ngPnl,m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(106),ex1(:),G2tensor(182),m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(172),ex4(:),G2tensor(181),m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(158),ex4(:),G2tensor(579),m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(456),m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(450),m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(426),m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(334),ex4(:),G2tensor(420),m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(10),wf4(:,9),G2tensor(200),ngPnl,m3h4x1(:,81),heltab2x4(:,:,583))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(25),wf4(:,9),G2tensor(199),m3h4x1(:,82),heltab2x4(:,:,584))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(42),wf4(:,4),G2tensor(291),ngPln,m3h4x1(:,83),heltab2x4(:,:,585))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(54),wf4(:,4),G2tensor(31),m3h4x1(:,84),heltab2x4(:,:,586))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H8(44),wf4(:,36),ex4(:),G1tensor(25),m4h4x2x1(:,1),heltab3x8(:,:,1))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H8(53),wf4(:,37),ex4(:),G1tensor(55),m4h4x2x1(:,2),heltab3x8(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H8(55),ex4(:),wf4(:,36),G1tensor(85),m4h2x4x1(:,1),heltab3x8(:,:,3))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H8(1),ex4(:),wf4(:,37),G1tensor(115),m4h2x4x1(:,2),heltab3x8(:,:,4))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H8(6),ex4(:),wf4(:,13),G2tensor(1),m4h2x4x1(:,3),heltab3x8(:,:,5))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H8(8),ex4(:),wf4(:,14),G2tensor(429),m4h2x4x1(:,4),heltab3x8(:,:,6))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H8(12),ex4(:),wf4(:,13),G2tensor(180),m4h2x4x1(:,5),heltab3x8(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H8(11),ex4(:),wf4(:,14),G2tensor(178),m4h2x4x1(:,6),heltab3x8(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(285),ex3(:),G1tensor(6),m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(232),ex3(:),G1tensor(30),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(119),ex4(:),ex3(:),G2tensor(435),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(121),ex4(:),ex3(:),G2tensor(184),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(39),wf4(:,3),G1tensor(14),ngPnl,m3h4x1(:,85),heltab2x4(:,:,587))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(42),wf4(:,3),G1tensor(26),m3h4x1(:,86),heltab2x4(:,:,588))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(40),wf4(:,10),G1tensor(44),ngPln,m3h4x1(:,87),heltab2x4(:,:,589))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(95),wf4(:,10),G1tensor(96),m3h4x1(:,88),heltab2x4(:,:,590))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(83),ex4(:),ex3(:),G1tensor(68),m4h2x2x1(:,7),heltab3x4(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(81),ex4(:),ex3(:),G1tensor(80),m4h2x2x1(:,8),heltab3x4(:,:,8))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(96),ex4(:),ex3(:),G1tensor(75),m4h2x2x1(:,9),heltab3x4(:,:,9))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(94),ex4(:),ex3(:),G1tensor(110),m4h2x2x1(:,10),heltab3x4(:,:,10))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(214),ex4(:),G1tensor(120),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(3),ex4(:),G1tensor(39),m3h2x1(:,778),heltab2x2(:,:,778))
  call Hloop_SQ_A(ntryL,G1H8(4),wf8(:,31),G1H1(1),ngH,m3h8x1(:,1),heltab2x8(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(183),n2h1(509))
  call Hloop_SQ_A(ntryL,G1H8(6),wf8(:,31),G1H1(1),ngX,m3h8x1(:,2),heltab2x8(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(567),n2h1(510))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H8(14),wf8(:,31),G2tensor(468),ngPnl,m3h8x1(:,3),heltab2x8(:,:,509))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,31),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(462),n2h1(511))
  call Hloop_ZQ_A(ntryL,G1H8(15),wf8(:,31),G1H1(1),ngZl,m3h8x1(:,5),heltab2x8(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(444),n2h1(512))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(15),wf8(:,31),G2tensor(438),m3h8x1(:,6),heltab2x8(:,:,512))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(175),ex4(:),G1tensor(4),m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(198),ex4(:),G1tensor(10),m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(223),ex4(:),G1tensor(22),m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(235),ex4(:),G1tensor(35),m3h2x1(:,782),heltab2x2(:,:,782))
  call Hloop_SA_Q(ntryL,G1H8(25),wf8(:,36),G1H1(1),ngH,m3h8x1(:,7),heltab2x8(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(198),n2h1(513))
  call Hloop_SA_Q(ntryL,G1H8(26),wf8(:,36),G1H1(1),ngX,m3h8x1(:,8),heltab2x8(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(197),n2h1(514))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H8(13),wf8(:,36),G2tensor(336),ngPln,m3h8x1(:,9),heltab2x8(:,:,515))
  call Hloop_VA_Q(ntryL,G1H8(35),wf8(:,36),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(3),n2h1(515))
  call Hloop_ZA_Q(ntryL,G1H8(39),wf8(:,36),G1H1(1),ngZl,m3h8x1(:,11),heltab2x8(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(4),n2h1(516))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(16),wf8(:,36),G2tensor(447),m3h8x1(:,12),heltab2x8(:,:,518))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(371),ex4(:),G1tensor(53),m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(372),ex4(:),G1tensor(57),m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(2),wf4(:,9),G2tensor(186),ngH,m3h4x1(:,89),heltab2x4(:,:,591))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(70),wf4(:,9),G2tensor(185),ngX,m3h4x1(:,90),heltab2x4(:,:,592))
  call Hloop_SQ_A(ntryL,G1H4(153),wf4(:,9),G1H1(1),ngPnl,m3h4x1(:,91),heltab2x4(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(366),n2h1(517))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(100),wf4(:,9),G2tensor(6),m3h4x1(:,92),heltab2x4(:,:,594))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(8),wf4(:,9),G2tensor(37),ngZl,m3h4x1(:,93),heltab2x4(:,:,595))
  call Hloop_WQ_A(ntryL,G1H4(154),wf4(:,9),G1H1(1),m3h4x1(:,94),heltab2x4(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(459),n2h1(518))
  call Hloop_QS_A(ntryL,G2H8(18),wf8(:,15),G2H1(1),ngH,m3h8x1(:,13),heltab2x8(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(115),n2h1(519))
  call Hloop_AS_Q(ntryL,G2H8(20),wf8(:,15),G2H1(1),ngH,m3h8x1(:,14),heltab2x8(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(116),n2h1(520))
  call Hloop_QS_A(ntryL,G2H8(22),wf8(:,50),G2H1(1),ngX,m3h8x1(:,15),heltab2x8(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(117),n2h1(521))
  call Hloop_AS_Q(ntryL,G2H8(24),wf8(:,50),G2H1(1),ngX,m3h8x1(:,16),heltab2x8(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(118),n2h1(522))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(28),wf8(:,15),G2tensor(188),m3h8x1(:,17),heltab2x8(:,:,523))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(26),wf8(:,15),G2tensor(187),m3h8x1(:,18),heltab2x8(:,:,524))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(27),wf8(:,15),G2tensor(396),m3h8x1(:,19),heltab2x8(:,:,525))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(30),wf8(:,50),G2tensor(43),m3h8x1(:,20),heltab2x8(:,:,526))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(31),wf8(:,50),G2tensor(5),m3h8x1(:,21),heltab2x8(:,:,527))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H8(32),wf8(:,15),G2tensor(264),m3h8x1(:,22),heltab2x8(:,:,528))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H8(48),20,wf8(:,15),11,G2tensor(483),m3h8x1(:,23),heltab2x8(:,:,529))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H8(52),20,wf8(:,50),11,G2tensor(504),m3h8x1(:,24),heltab2x8(:,:,530))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H8(66),20,wf8(:,15),11,G2tensor(209),m3h8x1(:,25),heltab2x8(:,:,531))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H8(69),20,wf8(:,50),11,G2tensor(229),m3h8x1(:,26),heltab2x8(:,:,532))
  call Hloop_QV_A(ntryL,G2H8(33),wf8(:,51),G2H1(1),m3h8x1(:,27),heltab2x8(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(119),n2h1(523))
  call Hloop_AV_Q(ntryL,G2H8(37),wf8(:,51),G2H1(1),m3h8x1(:,28),heltab2x8(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(120),n2h1(524))
  call Hloop_QV_A(ntryL,G2H8(34),wf8(:,51),G2H1(1),m3h8x1(:,29),heltab2x8(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(121),n2h1(525))
  call Hloop_AV_Q(ntryL,G2H8(35),wf8(:,51),G2H1(1),m3h8x1(:,30),heltab2x8(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(122),n2h1(526))
  call Hloop_QZ_A(ntryL,G2H8(38),wf8(:,52),G2H1(1),ngZl,m3h8x1(:,31),heltab2x8(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(123),n2h1(527))
  call Hloop_AZ_Q(ntryL,G2H8(39),wf8(:,52),G2H1(1),ngZl,m3h8x1(:,32),heltab2x8(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(124),n2h1(528))
  call Hloop_QZ_A(ntryL,G2H8(36),wf8(:,52),G2H1(1),ngZu,m3h8x1(:,33),heltab2x8(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(125),n2h1(529))
  call Hloop_AZ_Q(ntryL,G2H8(40),wf8(:,52),G2H1(1),ngZu,m3h8x1(:,34),heltab2x8(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(126),n2h1(530))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(41),20,wf8(:,51),11,G3tensor(127),m3h8x1(:,35),heltab2x8(:,:,541))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(45),20,wf8(:,51),11,G3tensor(128),m3h8x1(:,36),heltab2x8(:,:,542))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(42),20,wf8(:,52),11,G3tensor(129),m3h8x1(:,37),heltab2x8(:,:,543))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(43),20,wf8(:,52),11,G3tensor(130),m3h8x1(:,38),heltab2x8(:,:,544))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(47),20,wf8(:,51),11,G3tensor(131),m3h8x1(:,39),heltab2x8(:,:,545))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(48),20,wf8(:,51),G3tensor(132),m3h8x1(:,40),heltab2x8(:,:,546))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(50),20,wf8(:,52),11,G3tensor(133),m3h8x1(:,41),heltab2x8(:,:,547))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(52),20,wf8(:,52),G3tensor(134),m3h8x1(:,42),heltab2x8(:,:,548))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(53),20,wf8(:,51),11,G3tensor(135),m3h8x1(:,43),heltab2x8(:,:,549))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(54),20,wf8(:,51),11,G3tensor(136),m3h8x1(:,44),heltab2x8(:,:,550))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(55),20,wf8(:,52),11,G3tensor(137),m3h8x1(:,45),heltab2x8(:,:,551))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(56),20,wf8(:,52),11,G3tensor(138),m3h8x1(:,46),heltab2x8(:,:,552))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(117),wf8(:,51),G1tensor(64),m3h8x1(:,47),heltab2x8(:,:,553))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(119),wf8(:,52),G1tensor(69),m3h8x1(:,48),heltab2x8(:,:,554))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(128),wf8(:,51),G1tensor(93),m3h8x1(:,49),heltab2x8(:,:,555))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(129),wf8(:,52),G1tensor(100),m3h8x1(:,50),heltab2x8(:,:,556))
  call Hloop_SQ_A(ntryL,G1H8(10),wf8(:,40),G1H1(1),ngH,m3h8x1(:,51),heltab2x8(:,:,557))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(221),n2h1(531))
  call Hloop_SQ_A(ntryL,G1H8(11),wf8(:,40),G1H1(1),ngX,m3h8x1(:,52),heltab2x8(:,:,558))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(220),n2h1(532))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H8(57),wf8(:,40),G2tensor(213),ngPnl,m3h8x1(:,53),heltab2x8(:,:,559))
  call Hloop_VQ_A(ntryL,G1H8(22),wf8(:,40),G1H1(1),m3h8x1(:,54),heltab2x8(:,:,560))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(210),n2h1(533))
  call Hloop_ZQ_A(ntryL,G1H8(38),wf8(:,40),G1H1(1),ngZl,m3h8x1(:,55),heltab2x8(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(214),n2h1(534))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(58),wf8(:,40),G2tensor(225),m3h8x1(:,56),heltab2x8(:,:,562))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(385),ex3(:),G1tensor(105),m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(386),ex3(:),G1tensor(119),m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(108),wf4(:,4),G2tensor(224),ngH,m3h4x1(:,95),heltab2x4(:,:,597))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(43),wf4(:,4),G2tensor(223),ngX,m3h4x1(:,96),heltab2x4(:,:,598))
  call Hloop_SA_Q(ntryL,G1H4(207),wf4(:,4),G1H1(1),ngPln,m3h4x1(:,97),heltab2x4(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(218),n2h1(535))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(50),wf4(:,4),G2tensor(215),m3h4x1(:,98),heltab2x4(:,:,600))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(88),wf4(:,4),G2tensor(227),ngZl,m3h4x1(:,99),heltab2x4(:,:,601))
  call Hloop_WA_Q(ntryL,G1H4(216),wf4(:,4),G1H1(1),m3h4x1(:,100),heltab2x4(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(231),n2h1(536))
  call Hloop_QS_A(ntryL,G2H8(59),wf8(:,17),G2H1(1),ngH,m3h8x1(:,57),heltab2x8(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(139),n2h1(537))
  call Hloop_AS_Q(ntryL,G2H8(60),wf8(:,17),G2H1(1),ngH,m3h8x1(:,58),heltab2x8(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(140),n2h1(538))
  call Hloop_QS_A(ntryL,G2H8(61),wf8(:,53),G2H1(1),ngX,m3h8x1(:,59),heltab2x8(:,:,565))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(141),n2h1(539))
  call Hloop_AS_Q(ntryL,G2H8(62),wf8(:,53),G2H1(1),ngX,m3h8x1(:,60),heltab2x8(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(142),n2h1(540))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(64),wf8(:,17),G2tensor(233),m3h8x1(:,61),heltab2x8(:,:,567))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(65),wf8(:,17),G2tensor(237),m3h8x1(:,62),heltab2x8(:,:,568))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(66),wf8(:,17),G2tensor(243),m3h8x1(:,63),heltab2x8(:,:,569))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(67),wf8(:,53),G2tensor(242),m3h8x1(:,64),heltab2x8(:,:,570))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H8(68),wf8(:,53),G2tensor(241),m3h8x1(:,65),heltab2x8(:,:,571))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H8(70),wf8(:,17),G2tensor(240),m3h8x1(:,66),heltab2x8(:,:,572))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H8(145),20,wf8(:,17),11,G2tensor(239),m3h8x1(:,67),heltab2x8(:,:,573))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H8(146),20,wf8(:,53),11,G2tensor(573),m3h8x1(:,68),heltab2x8(:,:,574))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H8(148),20,wf8(:,17),11,G2tensor(585),m3h8x1(:,69),heltab2x8(:,:,575))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H8(151),20,wf8(:,53),11,G2tensor(591),m3h8x1(:,70),heltab2x8(:,:,576))
  call Hloop_QV_A(ntryL,G2H8(71),wf8(:,54),G2H1(1),m3h8x1(:,71),heltab2x8(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(143),n2h1(541))
  call Hloop_AV_Q(ntryL,G2H8(72),wf8(:,54),G2H1(1),m3h8x1(:,72),heltab2x8(:,:,578))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(144),n2h1(542))
  call Hloop_QV_A(ntryL,G2H8(73),wf8(:,54),G2H1(1),m3h8x1(:,73),heltab2x8(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(145),n2h1(543))
  call Hloop_AV_Q(ntryL,G2H8(74),wf8(:,54),G2H1(1),m3h8x1(:,74),heltab2x8(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(146),n2h1(544))
  call Hloop_QZ_A(ntryL,G2H8(75),wf8(:,55),G2H1(1),ngZl,m3h8x1(:,75),heltab2x8(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(147),n2h1(545))
  call Hloop_AZ_Q(ntryL,G2H8(76),wf8(:,55),G2H1(1),ngZl,m3h8x1(:,76),heltab2x8(:,:,582))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(148),n2h1(546))
  call Hloop_QZ_A(ntryL,G2H8(77),wf8(:,55),G2H1(1),ngZu,m3h8x1(:,77),heltab2x8(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(149),n2h1(547))



end subroutine vamp_1

end module ol_vamp_1_eeaa_lew_eexaaa_1_/**/REALKIND
