
module ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 1]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 1]

  K2(1,:) = [ 1]

  KL(1,:) = [ 1]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND



module ol_forced_parameters_eeaa_lew_eexaaaa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, nfl, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nf /= 0) write(*,101) 'nf = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wME /= 0) write(*,101) 'wME = 0'
  if (wME /= 0) write(*,101) 'wME = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_eeaa_lew_eexaaaa_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_eeaa_lew_eexaaaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 64 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(64) ! physical helicity states
  integer(intkind2), save :: nhflip = 64    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,64) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(531)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,58), wf8(8,212), wf16(16,240), wf64(64,244)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(54), c(49)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_eeaa_lew_eexaaaa_1_/**/REALKIND






! **********************************************************************
module ol_loop_eeaa_lew_eexaaaa_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4
    f( 2) = CI*countertermnorm*eQED**6
    f( 3) = CI*countertermnorm*eQED**6*EWctR2AAAA
    f( 4) = CI*countertermnorm*eQED**6*EWctR2AAAZ
    f( 5) = (CI*countertermnorm*eQED**6*EWctHAA*ME)/(2._/**/REALKIND*MW*sw)
    f( 6) = eQED**6*integralnorm*SwB
    f( 7) = 2*eQED**6*integralnorm*SwB
    f( 8) = 4*eQED**6*integralnorm*SwB
    f( 9) = eQED**6*integralnorm*MW**2*SwB
    f(10) = 2*eQED**6*integralnorm*MW**2*SwB
    f(11) = eQED**6*integralnorm*MW**4*SwB
    f(12) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(13) = (eQED**6*integralnorm*ME*SwB)/(sw**2*4._/**/REALKIND)
    f(14) = (eQED**6*integralnorm*ME*SwB)/(sw**2*2._/**/REALKIND)
    f(15) = (eQED**6*integralnorm*ME*SwB)/sw**2
    f(16) = (eQED**6*integralnorm*ME**2*SwB)/(sw**2*2._/**/REALKIND)
    f(17) = (eQED**6*integralnorm*ME**2*SwB)/sw**2
    f(18) = (eQED**6*integralnorm*ME*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f(19) = (eQED**6*integralnorm*ME*MH**2*SwB)/(sw**2*2._/**/REALKIND)
    f(20) = (eQED**6*integralnorm*ME**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(21) = (eQED**6*integralnorm*ME**2*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(22) = (eQED**6*integralnorm*ME**2*SwB)/(MW**2*sw**2)
    f(23) = (2*eQED**6*integralnorm*ME**2*SwB)/(MW**2*sw**2)
    f(24) = (eQED**6*integralnorm*ME*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(25) = (eQED**6*integralnorm*ME*MH**2*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(26) = (eQED**6*integralnorm*ME*MH**2*SwB)/(MW**2*sw**2)
    f(27) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(28) = (eQED**6*integralnorm*MW**2*SwB)/sw**2
    f(29) = (eQED**6*integralnorm*ME*MW**2*SwB)/(sw**2*4._/**/REALKIND)
    f(30) = (eQED**6*integralnorm*ME*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(31) = (eQED**6*integralnorm*ME*MW**2*SwB)/sw**2
    f(32) = (eQED**6*integralnorm*ME**2*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(33) = (eQED**6*integralnorm*ME*MH**2*MW**2*SwB)/(sw**2*4._/**/REALKIND)
    f(34) = (eQED**6*integralnorm*MW**4*SwB)/(sw**2*2._/**/REALKIND)
    f(35) = (eQED**6*integralnorm*ME*MW**4*SwB)/(sw**2*2._/**/REALKIND)
    f(36) = (cw*eQED**6*integralnorm*SwB)/sw
    f(37) = (cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(38) = (2*cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(39) = (cw*eQED**6*integralnorm*MW**4*SwB)/sw
    f(40) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(41) = (2*eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(42) = (eQED**6*integralnorm*MW**4*sw*SwB)/cw
    f(43) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(44) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(45) = (-2*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw)
    f(46) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(47) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(48) = -((eQED**6*integralnorm*MW**4*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(49) = (32*eQED**6*integralnorm*SwF)/243._/**/REALKIND
    f(50) = (16*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(51) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(52) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(53) = eQED**6*integralnorm*SwF
    f(54) = (eQED**6*integralnorm*ME**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ f(6), f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23) &
    , f(24), f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41) &
    , f(42), f(43), f(44), f(45), f(46), f(47), f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52), f(53), f(54) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - ME2)+L(6,5))
  den(2) = 1 /((L(5,10) - ME2)+L(6,10))
  den(3) = 1 /((L(5,21) - ME2)+L(6,21))
  den(6) = 1 /((L(5,26) - ME2)+L(6,26))
  den(9) = 1 /((L(5,18) - ME2)+L(6,18))
  den(10) = 1 /((L(5,13) - ME2)+L(6,13))
  den(15) = 1 /((L(5,34) - ME2)+L(6,34))
  den(17) = 1 /((L(5,42) - ME2)+L(6,42))
  den(20) = 1 /((L(5,9) - ME2)+L(6,9))
  den(21) = 1 /((L(5,6) - ME2)+L(6,6))
  den(22) = 1 /((L(5,25) - ME2)+L(6,25))
  den(25) = 1 /((L(5,22) - ME2)+L(6,22))
  den(28) = 1 /((L(5,17) - ME2)+L(6,17))
  den(31) = 1 /((L(5,14) - ME2)+L(6,14))
  den(34) = 1 /((L(5,33) - ME2)+L(6,33))
  den(35) = 1 /((L(5,41) - ME2)+L(6,41))
  den(44) = 1 /((L(5,38) - ME2)+L(6,38))
  den(51) = 1 /((L(5,37) - ME2)+L(6,37))
  den(59) = 1 /((L(5,56))+L(6,56))
  den(61) = 1 /((L(5,56) - MZ2)+L(6,56))
  den(65) = 1 /((L(5,52))+L(6,52))
  den(67) = 1 /((L(5,52) - MZ2)+L(6,52))
  den(71) = 1 /((L(5,44))+L(6,44))
  den(73) = 1 /((L(5,44) - MZ2)+L(6,44))
  den(77) = 1 /((L(5,28))+L(6,28))
  den(79) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(87) = 1 /((L(5,48) - MH2)+L(6,48))
  den(90) = 1 /((L(5,50) - ME2)+L(6,50))
  den(96) = 1 /((L(5,40) - MH2)+L(6,40))
  den(104) = 1 /((L(5,24) - MH2)+L(6,24))
  den(115) = 1 /((L(5,49) - ME2)+L(6,49))
  den(140) = 1 /((L(5,36) - MH2)+L(6,36))
  den(147) = 1 /((L(5,20) - MH2)+L(6,20))
  den(172) = 1 /((L(5,12) - MH2)+L(6,12))
  den(263) = 1 /((L(5,3) - MH2)+L(6,3))
  den(264) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(265) = 1 /((L(5,3))+L(6,3))
  den(266) = 1 /((L(5,7) - MH2)+L(6,7))
  den(268) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(270) = 1 /((L(5,7))+L(6,7))
  den(275) = 1 /((L(5,11) - MH2)+L(6,11))
  den(277) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(279) = 1 /((L(5,11))+L(6,11))
  den(284) = 1 /((L(5,19) - MH2)+L(6,19))
  den(286) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(288) = 1 /((L(5,19))+L(6,19))
  den(293) = 1 /((L(5,35) - MH2)+L(6,35))
  den(295) = 1 /((L(5,35) - MZ2)+L(6,35))
  den(297) = 1 /((L(5,35))+L(6,35))
  den(302) = 1 /((L(5,15) - MH2)+L(6,15))
  den(304) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(306) = 1 /((L(5,15))+L(6,15))
  den(308) = 1 /((L(5,23) - MH2)+L(6,23))
  den(310) = 1 /((L(5,23) - MZ2)+L(6,23))
  den(312) = 1 /((L(5,23))+L(6,23))
  den(314) = 1 /((L(5,39) - MH2)+L(6,39))
  den(316) = 1 /((L(5,39) - MZ2)+L(6,39))
  den(318) = 1 /((L(5,39))+L(6,39))
  den(323) = 1 /((L(5,29) - ME2)+L(6,29))
  den(325) = 1 /((L(5,45) - ME2)+L(6,45))
  den(331) = 1 /((L(5,53) - ME2)+L(6,53))
  den(356) = 1 /((L(5,30) - ME2)+L(6,30))
  den(358) = 1 /((L(5,46) - ME2)+L(6,46))
  den(361) = 1 /((L(5,54) - ME2)+L(6,54))
  den(365) = 1 /((L(5,27) - MH2)+L(6,27))
  den(367) = 1 /((L(5,27) - MZ2)+L(6,27))
  den(369) = 1 /((L(5,27))+L(6,27))
  den(371) = 1 /((L(5,43) - MH2)+L(6,43))
  den(373) = 1 /((L(5,43) - MZ2)+L(6,43))
  den(375) = 1 /((L(5,43))+L(6,43))
  den(386) = 1 /((L(5,57) - ME2)+L(6,57))
  den(411) = 1 /((L(5,58) - ME2)+L(6,58))
  den(415) = 1 /((L(5,51) - MH2)+L(6,51))
  den(417) = 1 /((L(5,51) - MZ2)+L(6,51))
  den(419) = 1 /((L(5,51))+L(6,51))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(1)*den(7)
  den(11) = den(1)*den(10)
  den(12) = den(9)*den(11)
  den(13) = den(6)*den(9)
  den(14) = den(1)*den(13)
  den(16) = den(11)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(1)*den(18)
  den(23) = den(20)*den(22)
  den(24) = den(21)*den(23)
  den(26) = den(21)*den(25)
  den(27) = den(20)*den(26)
  den(29) = den(22)*den(28)
  den(30) = den(21)*den(29)
  den(32) = den(21)*den(31)
  den(33) = den(28)*den(32)
  den(36) = den(34)*den(35)
  den(37) = den(21)*den(36)
  den(38) = den(32)*den(34)
  den(39) = den(10)*den(20)
  den(40) = den(9)*den(39)
  den(41) = den(9)*den(25)
  den(42) = den(20)*den(41)
  den(43) = den(15)*den(39)
  den(45) = den(15)*den(44)
  den(46) = den(20)*den(45)
  den(47) = den(3)*den(28)
  den(48) = den(2)*den(47)
  den(49) = den(2)*den(31)
  den(50) = den(28)*den(49)
  den(52) = den(34)*den(51)
  den(53) = den(2)*den(52)
  den(54) = den(34)*den(49)
  den(55) = den(15)*den(47)
  den(56) = den(28)*den(45)
  den(57) = den(9)*den(52)
  den(58) = den(34)*den(41)
  den(60) = den(1)*den(59)
  den(62) = den(1)*den(61)
  den(63) = den(21)*den(59)
  den(64) = den(21)*den(61)
  den(66) = den(20)*den(65)
  den(68) = den(20)*den(67)
  den(69) = den(2)*den(65)
  den(70) = den(2)*den(67)
  den(72) = den(28)*den(71)
  den(74) = den(28)*den(73)
  den(75) = den(9)*den(71)
  den(76) = den(9)*den(73)
  den(78) = den(34)*den(77)
  den(80) = den(34)*den(79)
  den(81) = den(15)*den(77)
  den(82) = den(15)*den(79)
  den(83) = den(1)*den(51)
  den(84) = den(2)*den(83)
  den(85) = den(2)*den(17)
  den(86) = den(1)*den(85)
  den(88) = den(1)*den(2)
  den(89) = den(87)*den(88)
  den(91) = den(87)*den(90)
  den(92) = den(1)*den(91)
  den(93) = den(9)*den(83)
  den(94) = den(9)*den(90)
  den(95) = den(1)*den(94)
  den(97) = den(1)*den(9)
  den(98) = den(96)*den(97)
  den(99) = den(4)*den(15)
  den(100) = den(15)*den(90)
  den(101) = den(1)*den(100)
  den(102) = den(17)*den(96)
  den(103) = den(1)*den(102)
  den(105) = den(1)*den(15)
  den(106) = den(104)*den(105)
  den(107) = den(6)*den(104)
  den(108) = den(1)*den(107)
  den(109) = den(20)*den(35)
  den(110) = den(21)*den(109)
  den(111) = den(21)*den(44)
  den(112) = den(20)*den(111)
  den(113) = den(20)*den(21)
  den(114) = den(87)*den(113)
  den(116) = den(87)*den(115)
  den(117) = den(21)*den(116)
  den(118) = den(28)*den(115)
  den(119) = den(21)*den(118)
  den(120) = den(28)*den(111)
  den(121) = den(21)*den(28)
  den(122) = den(96)*den(121)
  den(123) = den(34)*den(115)
  den(124) = den(21)*den(123)
  den(125) = den(26)*den(34)
  den(126) = den(35)*den(96)
  den(127) = den(21)*den(126)
  den(128) = den(21)*den(34)
  den(129) = den(104)*den(128)
  den(130) = den(22)*den(104)
  den(131) = den(21)*den(130)
  den(132) = den(20)*den(91)
  den(133) = den(2)*den(116)
  den(134) = den(28)*den(102)
  den(135) = den(9)*den(126)
  den(136) = den(34)*den(107)
  den(137) = den(15)*den(130)
  den(138) = den(9)*den(109)
  den(139) = den(20)*den(94)
  den(141) = den(9)*den(20)
  den(142) = den(140)*den(141)
  den(143) = den(15)*den(23)
  den(144) = den(20)*den(100)
  den(145) = den(44)*den(140)
  den(146) = den(20)*den(145)
  den(148) = den(15)*den(20)
  den(149) = den(147)*den(148)
  den(150) = den(25)*den(147)
  den(151) = den(20)*den(150)
  den(152) = den(2)*den(118)
  den(153) = den(28)*den(85)
  den(154) = den(2)*den(28)
  den(155) = den(140)*den(154)
  den(156) = den(2)*den(123)
  den(157) = den(7)*den(34)
  den(158) = den(51)*den(140)
  den(159) = den(2)*den(158)
  den(160) = den(2)*den(34)
  den(161) = den(147)*den(160)
  den(162) = den(3)*den(147)
  den(163) = den(2)*den(162)
  den(164) = den(15)*den(29)
  den(165) = den(18)*den(28)
  den(166) = den(28)*den(145)
  den(167) = den(9)*den(36)
  den(168) = den(13)*den(34)
  den(169) = den(9)*den(158)
  den(170) = den(34)*den(150)
  den(171) = den(15)*den(162)
  den(173) = den(15)*den(28)
  den(174) = den(172)*den(173)
  den(175) = den(31)*den(172)
  den(176) = den(28)*den(175)
  den(177) = den(9)*den(34)
  den(178) = den(172)*den(177)
  den(179) = den(10)*den(172)
  den(180) = den(9)*den(179)
  den(181) = den(34)*den(175)
  den(182) = den(15)*den(179)
  den(183) = den(1)**2
  den(184) = den(85)*den(183)
  den(185) = den(7)*den(183)
  den(186) = den(2)**2
  den(187) = den(83)*den(186)
  den(188) = den(4)*den(186)
  den(189) = den(4)*den(85)
  den(190) = den(7)*den(83)
  den(191) = den(94)*den(183)
  den(192) = den(13)*den(183)
  den(193) = den(9)**2
  den(194) = den(83)*den(193)
  den(195) = den(11)*den(193)
  den(196) = den(11)*den(94)
  den(197) = den(13)*den(83)
  den(198) = den(100)*den(183)
  den(199) = den(18)*den(183)
  den(200) = den(15)**2
  den(201) = den(4)*den(200)
  den(202) = den(11)*den(200)
  den(203) = den(11)*den(100)
  den(204) = den(4)*den(18)
  den(205) = den(20)**2
  den(206) = den(111)*den(205)
  den(207) = den(26)*den(205)
  den(208) = den(21)**2
  den(209) = den(109)*den(208)
  den(210) = den(23)*den(208)
  den(211) = den(23)*den(111)
  den(212) = den(26)*den(109)
  den(213) = den(28)**2
  den(214) = den(111)*den(213)
  den(215) = den(32)*den(213)
  den(216) = den(118)*den(208)
  den(217) = den(29)*den(208)
  den(218) = den(29)*den(111)
  den(219) = den(32)*den(118)
  den(220) = den(34)**2
  den(221) = den(26)*den(220)
  den(222) = den(32)*den(220)
  den(223) = den(123)*den(208)
  den(224) = den(36)*den(208)
  den(225) = den(26)*den(36)
  den(226) = den(32)*den(123)
  den(227) = den(94)*den(205)
  den(228) = den(41)*den(205)
  den(229) = den(109)*den(193)
  den(230) = den(39)*den(193)
  den(231) = den(39)*den(94)
  den(232) = den(41)*den(109)
  den(233) = den(100)*den(205)
  den(234) = den(45)*den(205)
  den(235) = den(23)*den(200)
  den(236) = den(39)*den(200)
  den(237) = den(39)*den(100)
  den(238) = den(23)*den(45)
  den(239) = den(85)*den(213)
  den(240) = den(49)*den(213)
  den(241) = den(118)*den(186)
  den(242) = den(47)*den(186)
  den(243) = den(47)*den(85)
  den(244) = den(49)*den(118)
  den(245) = den(7)*den(220)
  den(246) = den(49)*den(220)
  den(247) = den(123)*den(186)
  den(248) = den(52)*den(186)
  den(249) = den(7)*den(52)
  den(250) = den(49)*den(123)
  den(251) = den(18)*den(213)
  den(252) = den(45)*den(213)
  den(253) = den(29)*den(200)
  den(254) = den(47)*den(200)
  den(255) = den(18)*den(47)
  den(256) = den(29)*den(45)
  den(257) = den(13)*den(220)
  den(258) = den(41)*den(220)
  den(259) = den(36)*den(193)
  den(260) = den(52)*den(193)
  den(261) = den(13)*den(52)
  den(262) = den(36)*den(41)
  den(267) = den(1)*den(266)
  den(269) = den(1)*den(268)
  den(271) = den(1)*den(270)
  den(272) = den(21)*den(266)
  den(273) = den(21)*den(268)
  den(274) = den(21)*den(270)
  den(276) = den(20)*den(275)
  den(278) = den(20)*den(277)
  den(280) = den(20)*den(279)
  den(281) = den(2)*den(275)
  den(282) = den(2)*den(277)
  den(283) = den(2)*den(279)
  den(285) = den(28)*den(284)
  den(287) = den(28)*den(286)
  den(289) = den(28)*den(288)
  den(290) = den(9)*den(284)
  den(291) = den(9)*den(286)
  den(292) = den(9)*den(288)
  den(294) = den(34)*den(293)
  den(296) = den(34)*den(295)
  den(298) = den(34)*den(297)
  den(299) = den(15)*den(293)
  den(300) = den(15)*den(295)
  den(301) = den(15)*den(297)
  den(303) = den(88)*den(302)
  den(305) = den(88)*den(304)
  den(307) = den(88)*den(306)
  den(309) = den(97)*den(308)
  den(311) = den(97)*den(310)
  den(313) = den(97)*den(312)
  den(315) = den(105)*den(314)
  den(317) = den(105)*den(316)
  den(319) = den(105)*den(318)
  den(320) = den(11)*den(302)
  den(321) = den(11)*den(304)
  den(322) = den(11)*den(306)
  den(324) = den(11)*den(323)
  den(326) = den(11)*den(325)
  den(327) = den(4)*den(308)
  den(328) = den(4)*den(310)
  den(329) = den(4)*den(312)
  den(330) = den(4)*den(323)
  den(332) = den(4)*den(331)
  den(333) = den(83)*den(314)
  den(334) = den(83)*den(316)
  den(335) = den(83)*den(318)
  den(336) = den(83)*den(325)
  den(337) = den(83)*den(331)
  den(338) = den(113)*den(302)
  den(339) = den(113)*den(304)
  den(340) = den(113)*den(306)
  den(341) = den(121)*den(308)
  den(342) = den(121)*den(310)
  den(343) = den(121)*den(312)
  den(344) = den(128)*den(314)
  den(345) = den(128)*den(316)
  den(346) = den(128)*den(318)
  den(347) = den(32)*den(302)
  den(348) = den(32)*den(304)
  den(349) = den(32)*den(306)
  den(350) = den(26)*den(308)
  den(351) = den(26)*den(310)
  den(352) = den(26)*den(312)
  den(353) = den(111)*den(314)
  den(354) = den(111)*den(316)
  den(355) = den(111)*den(318)
  den(357) = den(32)*den(356)
  den(359) = den(32)*den(358)
  den(360) = den(26)*den(356)
  den(362) = den(26)*den(361)
  den(363) = den(111)*den(358)
  den(364) = den(111)*den(361)
  den(366) = den(141)*den(365)
  den(368) = den(141)*den(367)
  den(370) = den(141)*den(369)
  den(372) = den(148)*den(371)
  den(374) = den(148)*den(373)
  den(376) = den(148)*den(375)
  den(377) = den(39)*den(302)
  den(378) = den(39)*den(304)
  den(379) = den(39)*den(306)
  den(380) = den(39)*den(323)
  den(381) = den(39)*den(325)
  den(382) = den(23)*den(365)
  den(383) = den(23)*den(367)
  den(384) = den(23)*den(369)
  den(385) = den(23)*den(323)
  den(387) = den(23)*den(386)
  den(388) = den(109)*den(371)
  den(389) = den(109)*den(373)
  den(390) = den(109)*den(375)
  den(391) = den(109)*den(325)
  den(392) = den(109)*den(386)
  den(393) = den(154)*den(365)
  den(394) = den(154)*den(367)
  den(395) = den(154)*den(369)
  den(396) = den(160)*den(371)
  den(397) = den(160)*den(373)
  den(398) = den(160)*den(375)
  den(399) = den(49)*den(302)
  den(400) = den(49)*den(304)
  den(401) = den(49)*den(306)
  den(402) = den(7)*den(365)
  den(403) = den(7)*den(367)
  den(404) = den(7)*den(369)
  den(405) = den(85)*den(371)
  den(406) = den(85)*den(373)
  den(407) = den(85)*den(375)
  den(408) = den(49)*den(356)
  den(409) = den(49)*den(358)
  den(410) = den(7)*den(356)
  den(412) = den(7)*den(411)
  den(413) = den(85)*den(358)
  den(414) = den(85)*den(411)
  den(416) = den(173)*den(415)
  den(418) = den(173)*den(417)
  den(420) = den(173)*den(419)
  den(421) = den(47)*den(308)
  den(422) = den(47)*den(310)
  den(423) = den(47)*den(312)
  den(424) = den(47)*den(323)
  den(425) = den(47)*den(331)
  den(426) = den(29)*den(365)
  den(427) = den(29)*den(367)
  den(428) = den(29)*den(369)
  den(429) = den(29)*den(323)
  den(430) = den(29)*den(386)
  den(431) = den(118)*den(415)
  den(432) = den(118)*den(417)
  den(433) = den(118)*den(419)
  den(434) = den(118)*den(331)
  den(435) = den(118)*den(386)
  den(436) = den(177)*den(415)
  den(437) = den(177)*den(417)
  den(438) = den(177)*den(419)
  den(439) = den(41)*den(308)
  den(440) = den(41)*den(310)
  den(441) = den(41)*den(312)
  den(442) = den(13)*den(365)
  den(443) = den(13)*den(367)
  den(444) = den(13)*den(369)
  den(445) = den(94)*den(415)
  den(446) = den(94)*den(417)
  den(447) = den(94)*den(419)
  den(448) = den(41)*den(356)
  den(449) = den(41)*den(361)
  den(450) = den(13)*den(356)
  den(451) = den(13)*den(411)
  den(452) = den(94)*den(361)
  den(453) = den(94)*den(411)
  den(454) = den(52)*den(314)
  den(455) = den(52)*den(316)
  den(456) = den(52)*den(318)
  den(457) = den(52)*den(325)
  den(458) = den(52)*den(331)
  den(459) = den(36)*den(371)
  den(460) = den(36)*den(373)
  den(461) = den(36)*den(375)
  den(462) = den(36)*den(325)
  den(463) = den(36)*den(386)
  den(464) = den(123)*den(415)
  den(465) = den(123)*den(417)
  den(466) = den(123)*den(419)
  den(467) = den(123)*den(331)
  den(468) = den(123)*den(386)
  den(469) = den(45)*den(314)
  den(470) = den(45)*den(316)
  den(471) = den(45)*den(318)
  den(472) = den(18)*den(371)
  den(473) = den(18)*den(373)
  den(474) = den(18)*den(375)
  den(475) = den(100)*den(415)
  den(476) = den(100)*den(417)
  den(477) = den(100)*den(419)
  den(478) = den(45)*den(358)
  den(479) = den(45)*den(361)
  den(480) = den(18)*den(358)
  den(481) = den(18)*den(411)
  den(482) = den(100)*den(361)
  den(483) = den(100)*den(411)
  den(484) = den(2)*den(332)
  den(485) = den(2)*den(337)
  den(486) = den(1)*den(412)
  den(487) = den(1)*den(414)
  den(488) = den(9)*den(326)
  den(489) = den(9)*den(336)
  den(490) = den(1)*den(451)
  den(491) = den(1)*den(453)
  den(492) = den(15)*den(324)
  den(493) = den(15)*den(330)
  den(494) = den(1)*den(481)
  den(495) = den(1)*den(483)
  den(496) = den(21)*den(387)
  den(497) = den(21)*den(392)
  den(498) = den(20)*den(362)
  den(499) = den(20)*den(364)
  den(500) = den(21)*den(430)
  den(501) = den(21)*den(435)
  den(502) = den(28)*den(359)
  den(503) = den(28)*den(363)
  den(504) = den(21)*den(463)
  den(505) = den(21)*den(468)
  den(506) = den(34)*den(357)
  den(507) = den(34)*den(360)
  den(508) = den(9)*den(381)
  den(509) = den(9)*den(391)
  den(510) = den(20)*den(449)
  den(511) = den(20)*den(452)
  den(512) = den(15)*den(380)
  den(513) = den(15)*den(385)
  den(514) = den(20)*den(479)
  den(515) = den(20)*den(482)
  den(516) = den(2)*den(425)
  den(517) = den(2)*den(434)
  den(518) = den(28)*den(409)
  den(519) = den(28)*den(413)
  den(520) = den(2)*den(458)
  den(521) = den(2)*den(467)
  den(522) = den(34)*den(408)
  den(523) = den(34)*den(410)
  den(524) = den(15)*den(424)
  den(525) = den(15)*den(429)
  den(526) = den(28)*den(478)
  den(527) = den(28)*den(480)
  den(528) = den(9)*den(457)
  den(529) = den(9)*den(462)
  den(530) = den(34)*den(448)
  den(531) = den(34)*den(450)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,244))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:244)%j = 0
  A(1:hel_states,1:244)%e = 0
  A(1:hel_states,1:244)%hf = 0
  A(1:hel_states,1:244)%s = 0
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ gamma gamma gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_eeaa_lew_eexaaaa_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_eeaa_lew_eexaaaa_1, only: &
    & external_perm_eeaa_lew_eexaaaa_1, &
    & external_perm_inv_eeaa_lew_eexaaaa_1, &
    & extcomb_perm_eeaa_lew_eexaaaa_1, &
    & average_factor_eeaa_lew_eexaaaa_1
  use ol_external_eeaa_lew_eexaaaa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_eeaa_lew_eexaaaa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_eeaa_lew_eexaaaa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,244))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nME, nME, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_eeaa_lew_eexaaaa_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rME, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rME, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,1), 5, ME, 1_intkind1, wf4(:,3), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 10, ME, 1_intkind1, wf4(:,4), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, wf4(:,4), ex6(:), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 21, ME, 1_intkind1, wf8(:,3), n2(3))
  call vert_AV_Q(ntry, wf4(:,4), ex5(:), wf8(:,4), n3(:,5), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf4(:,3), wf8(:,5), n3(:,6), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,4), 26, ME, 1_intkind1, wf8(:,6), n2(4))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,5), n3(:,7), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,5), 18, ME, 1_intkind1, wf4(:,6), n2(5))
  call vert_VQ_A(ntry, ex4(:), wf4(:,3), wf8(:,7), n3(:,8), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,6), ex6(:), wf8(:,8), n3(:,9), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 13, ME, 1_intkind1, wf8(:,9), n2(6))
  call vert_AV_Q(ntry, wf4(:,6), ex4(:), wf8(:,10), n3(:,10), t3x8(:,:,7))
  call prop_A_Q(ntry, wf8(:,10), 26, ME, 1_intkind1, wf8(:,11), n2(7))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,7), n3(:,11), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,7), 34, ME, 1_intkind1, wf4(:,8), n2(8))
  call vert_AV_Q(ntry, wf4(:,8), ex5(:), wf8(:,12), n3(:,12), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,8), ex4(:), wf8(:,13), n3(:,13), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,13), 42, ME, 1_intkind1, wf8(:,14), n2(9))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,9), n3(:,14), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,10), n3(:,15), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,9), 9, ME, 1_intkind1, wf4(:,11), n2(10))
  call prop_A_Q(ntry, wf4(:,10), 6, ME, 1_intkind1, wf4(:,12), n2(11))
  call vert_VQ_A(ntry, ex5(:), wf4(:,11), wf8(:,15), n3(:,16), t3x8(:,:,10))
  call vert_AV_Q(ntry, wf4(:,12), ex6(:), wf8(:,16), n3(:,17), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,15), 25, ME, 1_intkind1, wf8(:,17), n2(12))
  call vert_AV_Q(ntry, wf4(:,12), ex5(:), wf8(:,18), n3(:,18), t3x8(:,:,12))
  call vert_VQ_A(ntry, ex6(:), wf4(:,11), wf8(:,19), n3(:,19), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,18), 22, ME, 1_intkind1, wf8(:,20), n2(13))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,13), n3(:,20), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,13), 17, ME, 1_intkind1, wf4(:,14), n2(14))
  call vert_VQ_A(ntry, ex4(:), wf4(:,14), wf8(:,21), n3(:,21), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,21), 25, ME, 1_intkind1, wf8(:,22), n2(15))
  call vert_AV_Q(ntry, wf4(:,12), ex4(:), wf8(:,23), n3(:,22), t3x8(:,:,15))
  call vert_VQ_A(ntry, ex6(:), wf4(:,14), wf8(:,24), n3(:,23), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,23), 14, ME, 1_intkind1, wf8(:,25), n2(16))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,15), n3(:,24), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,15), 33, ME, 1_intkind1, wf4(:,16), n2(17))
  call vert_VQ_A(ntry, ex4(:), wf4(:,16), wf8(:,26), n3(:,25), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,26), 41, ME, 1_intkind1, wf8(:,27), n2(18))
  call vert_VQ_A(ntry, ex5(:), wf4(:,16), wf8(:,28), n3(:,26), t3x8(:,:,18))
  call vert_VQ_A(ntry, ex3(:), wf4(:,11), wf8(:,29), n3(:,27), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,29), 13, ME, 1_intkind1, wf8(:,30), n2(19))
  call vert_AV_Q(ntry, wf4(:,6), ex3(:), wf8(:,31), n3(:,28), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,31), 22, ME, 1_intkind1, wf8(:,32), n2(20))
  call vert_AV_Q(ntry, wf4(:,8), ex3(:), wf8(:,33), n3(:,29), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,33), 38, ME, 1_intkind1, wf8(:,34), n2(21))
  call vert_VQ_A(ntry, ex3(:), wf4(:,14), wf8(:,35), n3(:,30), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,35), 21, ME, 1_intkind1, wf8(:,36), n2(22))
  call vert_AV_Q(ntry, wf4(:,4), ex3(:), wf8(:,37), n3(:,31), t3x8(:,:,23))
  call prop_A_Q(ntry, wf8(:,37), 14, ME, 1_intkind1, wf8(:,38), n2(23))
  call vert_VQ_A(ntry, ex3(:), wf4(:,16), wf8(:,39), n3(:,32), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,39), 37, ME, 1_intkind1, wf8(:,40), n2(24))
  call counter_VVV_V(ntry, ex4(:), ex5(:), ex6(:), wf8(:,41), n4(:,1), t4x8(:,:,1))
  call vert_QA_V(ntry, wf4(:,3), ex2(:), wf8(:,42), n3(:,33), t3x8(:,:,25))
  call vert_QA_Z(gZl,ntry, wf4(:,3), ex2(:), wf8(:,43), n3(:,34), t3x8(:,:,26))
  call vert_QA_V(ntry, ex1(:), wf4(:,12), wf8(:,44), n3(:,35), t3x8(:,:,27))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,12), wf8(:,45), n3(:,36), t3x8(:,:,28))
  call counter_VVV_V(ntry, ex3(:), ex5(:), ex6(:), wf8(:,46), n4(:,2), t4x8(:,:,2))
  call vert_QA_V(ntry, wf4(:,11), ex2(:), wf8(:,47), n3(:,37), t3x8(:,:,29))
  call vert_QA_Z(gZl,ntry, wf4(:,11), ex2(:), wf8(:,48), n3(:,38), t3x8(:,:,30))
  call vert_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,49), n3(:,39), t3x8(:,:,31))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,4), wf8(:,50), n3(:,40), t3x8(:,:,32))
  call counter_VVV_V(ntry, ex3(:), ex4(:), ex6(:), wf8(:,51), n4(:,3), t4x8(:,:,3))
  call vert_QA_V(ntry, wf4(:,14), ex2(:), wf8(:,52), n3(:,41), t3x8(:,:,33))
  call vert_QA_Z(gZl,ntry, wf4(:,14), ex2(:), wf8(:,53), n3(:,42), t3x8(:,:,34))
  call vert_QA_V(ntry, ex1(:), wf4(:,6), wf8(:,54), n3(:,43), t3x8(:,:,35))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,6), wf8(:,55), n3(:,44), t3x8(:,:,36))
  call counter_VVV_V(ntry, ex3(:), ex4(:), ex5(:), wf8(:,56), n4(:,4), t4x8(:,:,4))
  call vert_QA_V(ntry, wf4(:,16), ex2(:), wf8(:,57), n3(:,45), t3x8(:,:,37))
  call vert_QA_Z(gZl,ntry, wf4(:,16), ex2(:), wf8(:,58), n3(:,46), t3x8(:,:,38))
  call vert_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,59), n3(:,47), t3x8(:,:,39))
  call vert_QA_Z(gZl,ntry, ex1(:), wf4(:,8), wf8(:,60), n3(:,48), t3x8(:,:,40))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,4), ex6(:), wf8(:,61), n3(:,49), t3x8(:,:,41))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), wf4(:,3), wf8(:,62), n3(:,50), t3x8(:,:,42))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,4), ex5(:), wf8(:,63), n3(:,51), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,5), 37, ME, 1_intkind1, wf8(:,64), n2(25))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), wf4(:,3), wf8(:,65), n3(:,52), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,2), 42, ME, 1_intkind1, wf8(:,66), n2(26))
  call counter_VV_S(ntry, ex5(:), ex6(:), wf4(:,17), n3(:,53), t3x4(:,:,9))
  call vert_AQ_S(gH,ntry, wf4(:,4), wf4(:,3), wf16(:,1), n3(:,54), t3x16(:,:,1))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,6), ex6(:), wf8(:,67), n3(:,55), t3x8(:,:,45))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,8), ex5(:), wf8(:,68), n3(:,56), t3x8(:,:,46))
  call vert_SA_Q(gH,ntry, wf4(:,17), ex2(:), wf8(:,69), n3(:,57), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,69), 50, ME, 1_intkind1, wf8(:,70), n2(27))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,6), ex4(:), wf8(:,71), n3(:,58), t3x8(:,:,48))
  call counter_ZQ_A(EWctAee,ntry, ex4(:), wf4(:,3), wf8(:,72), n3(:,59), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,8), 50, ME, 1_intkind1, wf8(:,73), n2(28))
  call counter_VV_S(ntry, ex4(:), ex6(:), wf4(:,18), n3(:,60), t3x4(:,:,10))
  call vert_AQ_S(gH,ntry, wf4(:,6), wf4(:,3), wf16(:,2), n3(:,61), t3x16(:,:,2))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,8), ex4(:), wf8(:,74), n3(:,62), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,12), 50, ME, 1_intkind1, wf8(:,75), n2(29))
  call vert_SA_Q(gH,ntry, wf4(:,18), ex2(:), wf8(:,76), n3(:,63), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,76), 42, ME, 1_intkind1, wf8(:,77), n2(30))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf4(:,19), n3(:,64), t3x4(:,:,11))
  call vert_AQ_S(gH,ntry, wf4(:,8), wf4(:,3), wf16(:,3), n3(:,65), t3x16(:,:,3))
  call vert_SA_Q(gH,ntry, wf4(:,19), ex2(:), wf8(:,78), n3(:,66), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,78), 26, ME, 1_intkind1, wf8(:,79), n2(31))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,12), ex6(:), wf8(:,80), n3(:,67), t3x8(:,:,53))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), wf4(:,11), wf8(:,81), n3(:,68), t3x8(:,:,54))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,12), ex5(:), wf8(:,82), n3(:,69), t3x8(:,:,55))
  call prop_Q_A(ntry, wf8(:,19), 41, ME, 1_intkind1, wf8(:,83), n2(32))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), wf4(:,11), wf8(:,84), n3(:,70), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,16), 38, ME, 1_intkind1, wf8(:,85), n2(33))
  call vert_AQ_S(gH,ntry, wf4(:,12), wf4(:,11), wf16(:,4), n3(:,71), t3x16(:,:,4))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), wf4(:,14), wf8(:,86), n3(:,72), t3x8(:,:,57))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), wf4(:,16), wf8(:,87), n3(:,73), t3x8(:,:,58))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,17), wf8(:,88), n3(:,74), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,88), 49, ME, 1_intkind1, wf8(:,89), n2(34))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,12), ex4(:), wf8(:,90), n3(:,75), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,24), 49, ME, 1_intkind1, wf8(:,91), n2(35))
  call counter_ZQ_A(EWctAee,ntry, ex4(:), wf4(:,14), wf8(:,92), n3(:,76), t3x8(:,:,61))
  call vert_AQ_S(gH,ntry, wf4(:,12), wf4(:,14), wf16(:,5), n3(:,77), t3x16(:,:,5))
  call prop_Q_A(ntry, wf8(:,28), 49, ME, 1_intkind1, wf8(:,93), n2(36))
  call counter_ZQ_A(EWctAee,ntry, ex4(:), wf4(:,16), wf8(:,94), n3(:,78), t3x8(:,:,62))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,18), wf8(:,95), n3(:,79), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,95), 41, ME, 1_intkind1, wf8(:,96), n2(37))
  call vert_AQ_S(gH,ntry, wf4(:,12), wf4(:,16), wf16(:,6), n3(:,80), t3x16(:,:,6))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,19), wf8(:,97), n3(:,81), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,97), 25, ME, 1_intkind1, wf8(:,98), n2(38))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,6), ex3(:), wf8(:,99), n3(:,82), t3x8(:,:,65))
  call counter_ZQ_A(EWctAee,ntry, ex3(:), wf4(:,11), wf8(:,100), n3(:,83), t3x8(:,:,66))
  call counter_VV_S(ntry, ex3(:), ex6(:), wf4(:,20), n3(:,84), t3x4(:,:,12))
  call vert_AQ_S(gH,ntry, wf4(:,6), wf4(:,11), wf16(:,7), n3(:,85), t3x16(:,:,7))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,8), ex3(:), wf8(:,101), n3(:,86), t3x8(:,:,67))
  call vert_SA_Q(gH,ntry, wf4(:,20), ex2(:), wf8(:,102), n3(:,87), t3x8(:,:,68))
  call prop_A_Q(ntry, wf8(:,102), 38, ME, 1_intkind1, wf8(:,103), n2(39))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf4(:,21), n3(:,88), t3x4(:,:,13))
  call vert_AQ_S(gH,ntry, wf4(:,8), wf4(:,11), wf16(:,8), n3(:,89), t3x16(:,:,8))
  call vert_SA_Q(gH,ntry, wf4(:,21), ex2(:), wf8(:,104), n3(:,90), t3x8(:,:,69))
  call prop_A_Q(ntry, wf8(:,104), 22, ME, 1_intkind1, wf8(:,105), n2(40))
  call counter_AZ_Q(EWctAee,ntry, wf4(:,4), ex3(:), wf8(:,106), n3(:,91), t3x8(:,:,70))
  call counter_ZQ_A(EWctAee,ntry, ex3(:), wf4(:,14), wf8(:,107), n3(:,92), t3x8(:,:,71))
  call vert_AQ_S(gH,ntry, wf4(:,4), wf4(:,14), wf16(:,9), n3(:,93), t3x16(:,:,9))
  call counter_ZQ_A(EWctAee,ntry, ex3(:), wf4(:,16), wf8(:,108), n3(:,94), t3x8(:,:,72))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,20), wf8(:,109), n3(:,95), t3x8(:,:,73))
  call prop_Q_A(ntry, wf8(:,109), 37, ME, 1_intkind1, wf8(:,110), n2(41))
  call vert_AQ_S(gH,ntry, wf4(:,4), wf4(:,16), wf16(:,10), n3(:,96), t3x16(:,:,10))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,21), wf8(:,111), n3(:,97), t3x8(:,:,74))
  call prop_Q_A(ntry, wf8(:,111), 21, ME, 1_intkind1, wf8(:,112), n2(42))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf4(:,22), n3(:,98), t3x4(:,:,14))
  call vert_AQ_S(gH,ntry, wf4(:,8), wf4(:,14), wf16(:,11), n3(:,99), t3x16(:,:,11))
  call vert_SA_Q(gH,ntry, wf4(:,22), ex2(:), wf8(:,113), n3(:,100), t3x8(:,:,75))
  call prop_A_Q(ntry, wf8(:,113), 14, ME, 1_intkind1, wf8(:,114), n2(43))
  call vert_AQ_S(gH,ntry, wf4(:,6), wf4(:,16), wf16(:,12), n3(:,101), t3x16(:,:,12))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,22), wf8(:,115), n3(:,102), t3x8(:,:,76))
  call prop_Q_A(ntry, wf8(:,115), 13, ME, 1_intkind1, wf8(:,116), n2(44))
  call counter_AZ_Q(EWctAee,ntry, ex2(:), ex6(:), wf4(:,23), n3(:,103), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,23), 34, ME, 1_intkind1, wf4(:,24), n2(45))
  call vert_AV_Q(ntry, wf4(:,24), ex5(:), wf8(:,117), n3(:,104), t3x8(:,:,77))
  call vert_AV_Q(ntry, wf4(:,24), ex4(:), wf8(:,118), n3(:,105), t3x8(:,:,78))
  call prop_A_Q(ntry, wf8(:,118), 42, ME, 1_intkind1, wf8(:,119), n2(46))
  call counter_AZ_Q(EWctAee,ntry, ex2(:), ex5(:), wf4(:,25), n3(:,106), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,25), 18, ME, 1_intkind1, wf4(:,26), n2(47))
  call vert_AV_Q(ntry, wf4(:,26), ex6(:), wf8(:,120), n3(:,107), t3x8(:,:,79))
  call vert_AV_Q(ntry, wf4(:,26), ex4(:), wf8(:,121), n3(:,108), t3x8(:,:,80))
  call prop_A_Q(ntry, wf8(:,121), 26, ME, 1_intkind1, wf8(:,122), n2(48))
  call counter_AZ_Q(EWctAee,ntry, ex2(:), ex4(:), wf4(:,27), n3(:,109), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,27), 10, ME, 1_intkind1, wf4(:,28), n2(49))
  call vert_AV_Q(ntry, wf4(:,28), ex6(:), wf8(:,123), n3(:,110), t3x8(:,:,81))
  call vert_AV_Q(ntry, wf4(:,28), ex5(:), wf8(:,124), n3(:,111), t3x8(:,:,82))
  call prop_A_Q(ntry, wf8(:,124), 26, ME, 1_intkind1, wf8(:,125), n2(50))
  call vert_AV_Q(ntry, wf4(:,24), ex3(:), wf8(:,126), n3(:,112), t3x8(:,:,83))
  call prop_A_Q(ntry, wf8(:,126), 38, ME, 1_intkind1, wf8(:,127), n2(51))
  call vert_AV_Q(ntry, wf4(:,26), ex3(:), wf8(:,128), n3(:,113), t3x8(:,:,84))
  call prop_A_Q(ntry, wf8(:,128), 22, ME, 1_intkind1, wf8(:,129), n2(52))
  call vert_AV_Q(ntry, wf4(:,28), ex3(:), wf8(:,130), n3(:,114), t3x8(:,:,85))
  call prop_A_Q(ntry, wf8(:,130), 14, ME, 1_intkind1, wf8(:,131), n2(53))
  call counter_AZ_Q(EWctAee,ntry, ex2(:), ex3(:), wf4(:,29), n3(:,115), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,29), 6, ME, 1_intkind1, wf4(:,30), n2(54))
  call vert_AV_Q(ntry, wf4(:,30), ex6(:), wf8(:,132), n3(:,116), t3x8(:,:,86))
  call vert_AV_Q(ntry, wf4(:,30), ex5(:), wf8(:,133), n3(:,117), t3x8(:,:,87))
  call prop_A_Q(ntry, wf8(:,133), 22, ME, 1_intkind1, wf8(:,134), n2(55))
  call vert_AV_Q(ntry, wf4(:,30), ex4(:), wf8(:,135), n3(:,118), t3x8(:,:,88))
  call prop_A_Q(ntry, wf8(:,135), 14, ME, 1_intkind1, wf8(:,136), n2(56))
  call counter_ZQ_A(EWctAee,ntry, ex6(:), ex1(:), wf4(:,31), n3(:,119), t3x4(:,:,19))
  call prop_Q_A(ntry, wf4(:,31), 33, ME, 1_intkind1, wf4(:,32), n2(57))
  call vert_VQ_A(ntry, ex4(:), wf4(:,32), wf8(:,137), n3(:,120), t3x8(:,:,89))
  call prop_Q_A(ntry, wf8(:,137), 41, ME, 1_intkind1, wf8(:,138), n2(58))
  call vert_VQ_A(ntry, ex5(:), wf4(:,32), wf8(:,139), n3(:,121), t3x8(:,:,90))
  call counter_ZQ_A(EWctAee,ntry, ex5(:), ex1(:), wf4(:,33), n3(:,122), t3x4(:,:,20))
  call prop_Q_A(ntry, wf4(:,33), 17, ME, 1_intkind1, wf4(:,34), n2(59))
  call vert_VQ_A(ntry, ex4(:), wf4(:,34), wf8(:,140), n3(:,123), t3x8(:,:,91))
  call prop_Q_A(ntry, wf8(:,140), 25, ME, 1_intkind1, wf8(:,141), n2(60))
  call vert_VQ_A(ntry, ex6(:), wf4(:,34), wf8(:,142), n3(:,124), t3x8(:,:,92))
  call counter_ZQ_A(EWctAee,ntry, ex4(:), ex1(:), wf4(:,35), n3(:,125), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,35), 9, ME, 1_intkind1, wf4(:,36), n2(61))
  call vert_VQ_A(ntry, ex5(:), wf4(:,36), wf8(:,143), n3(:,126), t3x8(:,:,93))
  call prop_Q_A(ntry, wf8(:,143), 25, ME, 1_intkind1, wf8(:,144), n2(62))
  call vert_VQ_A(ntry, ex6(:), wf4(:,36), wf8(:,145), n3(:,127), t3x8(:,:,94))
  call vert_VQ_A(ntry, ex3(:), wf4(:,32), wf8(:,146), n3(:,128), t3x8(:,:,95))
  call prop_Q_A(ntry, wf8(:,146), 37, ME, 1_intkind1, wf8(:,147), n2(63))
  call vert_VQ_A(ntry, ex3(:), wf4(:,34), wf8(:,148), n3(:,129), t3x8(:,:,96))
  call prop_Q_A(ntry, wf8(:,148), 21, ME, 1_intkind1, wf8(:,149), n2(64))
  call vert_VQ_A(ntry, ex3(:), wf4(:,36), wf8(:,150), n3(:,130), t3x8(:,:,97))
  call prop_Q_A(ntry, wf8(:,150), 13, ME, 1_intkind1, wf8(:,151), n2(65))
  call counter_ZQ_A(EWctAee,ntry, ex3(:), ex1(:), wf4(:,37), n3(:,131), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,37), 5, ME, 1_intkind1, wf4(:,38), n2(66))
  call vert_VQ_A(ntry, ex5(:), wf4(:,38), wf8(:,152), n3(:,132), t3x8(:,:,98))
  call prop_Q_A(ntry, wf8(:,152), 21, ME, 1_intkind1, wf8(:,153), n2(67))
  call vert_VQ_A(ntry, ex6(:), wf4(:,38), wf8(:,154), n3(:,133), t3x8(:,:,99))
  call vert_VQ_A(ntry, ex4(:), wf4(:,38), wf8(:,155), n3(:,134), t3x8(:,:,100))
  call prop_Q_A(ntry, wf8(:,155), 13, ME, 1_intkind1, wf8(:,156), n2(68))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,3), 5, wf4(:,39), n2(69))
  call prop_Q_A(ntry, wf4(:,39), 5, ME, 1_intkind1, wf4(:,40), n2(70))
  call vert_VQ_A(ntry, ex5(:), wf4(:,40), wf8(:,157), n3(:,135), t3x8(:,:,101))
  call vert_VQ_A(ntry, ex6(:), wf4(:,40), wf8(:,158), n3(:,136), t3x8(:,:,102))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,4), 10, wf4(:,41), n2(71))
  call prop_A_Q(ntry, wf4(:,41), 10, ME, 1_intkind1, wf4(:,42), n2(72))
  call vert_AV_Q(ntry, wf4(:,42), ex5(:), wf8(:,159), n3(:,137), t3x8(:,:,103))
  call vert_AV_Q(ntry, wf4(:,42), ex6(:), wf8(:,160), n3(:,138), t3x8(:,:,104))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,3), 21, wf8(:,161), n2(73))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,6), 26, wf8(:,162), n2(74))
  call vert_VQ_A(ntry, ex4(:), wf4(:,40), wf8(:,163), n3(:,139), t3x8(:,:,105))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,6), 18, wf4(:,43), n2(75))
  call prop_A_Q(ntry, wf4(:,43), 18, ME, 1_intkind1, wf4(:,44), n2(76))
  call vert_AV_Q(ntry, wf4(:,44), ex4(:), wf8(:,164), n3(:,140), t3x8(:,:,106))
  call vert_AV_Q(ntry, wf4(:,44), ex6(:), wf8(:,165), n3(:,141), t3x8(:,:,107))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,9), 13, wf8(:,166), n2(77))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,11), 26, wf8(:,167), n2(78))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,8), 34, wf4(:,45), n2(79))
  call prop_A_Q(ntry, wf4(:,45), 34, ME, 1_intkind1, wf4(:,46), n2(80))
  call vert_AV_Q(ntry, wf4(:,46), ex4(:), wf8(:,168), n3(:,142), t3x8(:,:,108))
  call vert_AV_Q(ntry, wf4(:,46), ex5(:), wf8(:,169), n3(:,143), t3x8(:,:,109))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,14), 42, wf8(:,170), n2(81))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,11), 9, wf4(:,47), n2(82))
  call prop_Q_A(ntry, wf4(:,47), 9, ME, 1_intkind1, wf4(:,48), n2(83))
  call vert_VQ_A(ntry, ex5(:), wf4(:,48), wf8(:,171), n3(:,144), t3x8(:,:,110))
  call vert_VQ_A(ntry, ex6(:), wf4(:,48), wf8(:,172), n3(:,145), t3x8(:,:,111))
  call counter_A_Q_LR(EWctee,ntry, wf4(:,12), 6, wf4(:,49), n2(84))
  call prop_A_Q(ntry, wf4(:,49), 6, ME, 1_intkind1, wf4(:,50), n2(85))
  call vert_AV_Q(ntry, wf4(:,50), ex5(:), wf8(:,173), n3(:,146), t3x8(:,:,112))
  call vert_AV_Q(ntry, wf4(:,50), ex6(:), wf8(:,174), n3(:,147), t3x8(:,:,113))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,17), 25, wf8(:,175), n2(86))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,20), 22, wf8(:,176), n2(87))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,14), 17, wf4(:,51), n2(88))
  call prop_Q_A(ntry, wf4(:,51), 17, ME, 1_intkind1, wf4(:,52), n2(89))
  call vert_VQ_A(ntry, ex4(:), wf4(:,52), wf8(:,177), n3(:,148), t3x8(:,:,114))
  call vert_VQ_A(ntry, ex6(:), wf4(:,52), wf8(:,178), n3(:,149), t3x8(:,:,115))
  call vert_AV_Q(ntry, wf4(:,50), ex4(:), wf8(:,179), n3(:,150), t3x8(:,:,116))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,22), 25, wf8(:,180), n2(90))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,25), 14, wf8(:,181), n2(91))
  call counter_Q_A_LR(EWctee,ntry, wf4(:,16), 33, wf4(:,53), n2(92))
  call prop_Q_A(ntry, wf4(:,53), 33, ME, 1_intkind1, wf4(:,54), n2(93))
  call vert_VQ_A(ntry, ex4(:), wf4(:,54), wf8(:,182), n3(:,151), t3x8(:,:,117))
  call vert_VQ_A(ntry, ex5(:), wf4(:,54), wf8(:,183), n3(:,152), t3x8(:,:,118))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,27), 41, wf8(:,184), n2(94))
  call vert_VQ_A(ntry, ex3(:), wf4(:,48), wf8(:,185), n3(:,153), t3x8(:,:,119))
  call vert_AV_Q(ntry, wf4(:,44), ex3(:), wf8(:,186), n3(:,154), t3x8(:,:,120))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,30), 13, wf8(:,187), n2(95))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,32), 22, wf8(:,188), n2(96))
  call vert_AV_Q(ntry, wf4(:,46), ex3(:), wf8(:,189), n3(:,155), t3x8(:,:,121))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,34), 38, wf8(:,190), n2(97))
  call vert_VQ_A(ntry, ex3(:), wf4(:,52), wf8(:,191), n3(:,156), t3x8(:,:,122))
  call vert_AV_Q(ntry, wf4(:,42), ex3(:), wf8(:,192), n3(:,157), t3x8(:,:,123))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,36), 21, wf8(:,193), n2(98))
  call counter_A_Q_LR(EWctee,ntry, wf8(:,38), 14, wf8(:,194), n2(99))
  call vert_VQ_A(ntry, ex3(:), wf4(:,54), wf8(:,195), n3(:,158), t3x8(:,:,124))
  call counter_Q_A_LR(EWctee,ntry, wf8(:,40), 37, wf8(:,196), n2(100))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,55), n3(:,159), t3x4(:,:,23))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,56), n3(:,160), t3x4(:,:,24))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,57), n3(:,161), t3x4(:,:,25))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,58), n3(:,162), t3x4(:,:,26))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,3), wf8(:,197), n3(:,163), t3x8(:,:,125))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,3), wf8(:,198), n3(:,164), t3x8(:,:,126))
  call vert_AQ_S(gH,ntry, wf4(:,12), ex1(:), wf8(:,199), n3(:,165), t3x8(:,:,127))
  call vert_AQ_S(gX,ntry, wf4(:,12), ex1(:), wf8(:,200), n3(:,166), t3x8(:,:,128))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,11), wf8(:,201), n3(:,167), t3x8(:,:,129))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,11), wf8(:,202), n3(:,168), t3x8(:,:,130))
  call vert_AQ_S(gH,ntry, wf4(:,4), ex1(:), wf8(:,203), n3(:,169), t3x8(:,:,131))
  call vert_AQ_S(gX,ntry, wf4(:,4), ex1(:), wf8(:,204), n3(:,170), t3x8(:,:,132))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,14), wf8(:,205), n3(:,171), t3x8(:,:,133))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,14), wf8(:,206), n3(:,172), t3x8(:,:,134))
  call vert_AQ_S(gH,ntry, wf4(:,6), ex1(:), wf8(:,207), n3(:,173), t3x8(:,:,135))
  call vert_AQ_S(gX,ntry, wf4(:,6), ex1(:), wf8(:,208), n3(:,174), t3x8(:,:,136))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,16), wf8(:,209), n3(:,175), t3x8(:,:,137))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,16), wf8(:,210), n3(:,176), t3x8(:,:,138))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex1(:), wf8(:,211), n3(:,177), t3x8(:,:,139))
  call vert_AQ_S(gX,ntry, wf4(:,8), ex1(:), wf8(:,212), n3(:,178), t3x8(:,:,140))
  call vert_AQ_S(gX,ntry, wf4(:,4), wf4(:,3), wf16(:,13), n3(:,179), t3x16(:,:,13))
  call vert_QA_V(ntry, wf4(:,3), wf4(:,4), wf16(:,14), n3(:,180), t3x16(:,:,14))
  call vert_QA_Z(gZl,ntry, wf4(:,3), wf4(:,4), wf16(:,15), n3(:,181), t3x16(:,:,15))
  call vert_AQ_S(gX,ntry, wf4(:,6), wf4(:,3), wf16(:,16), n3(:,182), t3x16(:,:,16))
  call vert_QA_V(ntry, wf4(:,3), wf4(:,6), wf16(:,17), n3(:,183), t3x16(:,:,17))
  call vert_QA_Z(gZl,ntry, wf4(:,3), wf4(:,6), wf16(:,18), n3(:,184), t3x16(:,:,18))
  call vert_AQ_S(gX,ntry, wf4(:,8), wf4(:,3), wf16(:,19), n3(:,185), t3x16(:,:,19))
  call vert_QA_V(ntry, wf4(:,3), wf4(:,8), wf16(:,20), n3(:,186), t3x16(:,:,20))
  call vert_QA_Z(gZl,ntry, wf4(:,3), wf4(:,8), wf16(:,21), n3(:,187), t3x16(:,:,21))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,9), wf16(:,22), n3(:,188), t3x16(:,:,22))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,9), wf16(:,23), n3(:,189), t3x16(:,:,23))
  call vert_QA_V(ntry, wf8(:,9), ex2(:), wf16(:,24), n3(:,190), t3x16(:,:,24))
  call vert_QA_Z(gZl,ntry, wf8(:,9), ex2(:), wf16(:,25), n3(:,191), t3x16(:,:,25))
  call vert_VQ_A(ntry, ex5(:), wf8(:,9), wf16(:,26), n3(:,192), t3x16(:,:,26))
  call prop_Q_A(ntry, wf16(:,26), 29, ME, 1_intkind1, wf16(:,27), n2(101))
  call vert_VQ_A(ntry, ex6(:), wf8(:,9), wf16(:,28), n3(:,193), t3x16(:,:,27))
  call prop_Q_A(ntry, wf16(:,28), 45, ME, 1_intkind1, wf16(:,29), n2(102))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,3), wf16(:,30), n3(:,194), t3x16(:,:,28))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,3), wf16(:,31), n3(:,195), t3x16(:,:,29))
  call vert_QA_V(ntry, wf8(:,3), ex2(:), wf16(:,32), n3(:,196), t3x16(:,:,30))
  call vert_QA_Z(gZl,ntry, wf8(:,3), ex2(:), wf16(:,33), n3(:,197), t3x16(:,:,31))
  call vert_VQ_A(ntry, ex4(:), wf8(:,3), wf16(:,34), n3(:,198), t3x16(:,:,32))
  call prop_Q_A(ntry, wf16(:,34), 29, ME, 1_intkind1, wf16(:,35), n2(103))
  call vert_VQ_A(ntry, ex6(:), wf8(:,3), wf16(:,36), n3(:,199), t3x16(:,:,33))
  call prop_Q_A(ntry, wf16(:,36), 53, ME, 1_intkind1, wf16(:,37), n2(104))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,64), wf16(:,38), n3(:,200), t3x16(:,:,34))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,64), wf16(:,39), n3(:,201), t3x16(:,:,35))
  call vert_QA_V(ntry, wf8(:,64), ex2(:), wf16(:,40), n3(:,202), t3x16(:,:,36))
  call vert_QA_Z(gZl,ntry, wf8(:,64), ex2(:), wf16(:,41), n3(:,203), t3x16(:,:,37))
  call vert_VQ_A(ntry, ex4(:), wf8(:,64), wf16(:,42), n3(:,204), t3x16(:,:,38))
  call prop_Q_A(ntry, wf16(:,42), 45, ME, 1_intkind1, wf16(:,43), n2(105))
  call vert_VQ_A(ntry, ex5(:), wf8(:,64), wf16(:,44), n3(:,205), t3x16(:,:,39))
  call prop_Q_A(ntry, wf16(:,44), 53, ME, 1_intkind1, wf16(:,45), n2(106))
  call vert_AQ_S(gX,ntry, wf4(:,12), wf4(:,11), wf16(:,46), n3(:,206), t3x16(:,:,40))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,12), wf16(:,47), n3(:,207), t3x16(:,:,41))
  call vert_QA_Z(gZl,ntry, wf4(:,11), wf4(:,12), wf16(:,48), n3(:,208), t3x16(:,:,42))
  call vert_AQ_S(gX,ntry, wf4(:,12), wf4(:,14), wf16(:,49), n3(:,209), t3x16(:,:,43))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,12), wf16(:,50), n3(:,210), t3x16(:,:,44))
  call vert_QA_Z(gZl,ntry, wf4(:,14), wf4(:,12), wf16(:,51), n3(:,211), t3x16(:,:,45))
  call vert_AQ_S(gX,ntry, wf4(:,12), wf4(:,16), wf16(:,52), n3(:,212), t3x16(:,:,46))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,12), wf16(:,53), n3(:,213), t3x16(:,:,47))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf4(:,12), wf16(:,54), n3(:,214), t3x16(:,:,48))
  call vert_AQ_S(gH,ntry, wf8(:,25), ex1(:), wf16(:,55), n3(:,215), t3x16(:,:,49))
  call vert_AQ_S(gX,ntry, wf8(:,25), ex1(:), wf16(:,56), n3(:,216), t3x16(:,:,50))
  call vert_QA_V(ntry, ex1(:), wf8(:,25), wf16(:,57), n3(:,217), t3x16(:,:,51))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,25), wf16(:,58), n3(:,218), t3x16(:,:,52))
  call vert_AQ_S(gH,ntry, wf8(:,20), ex1(:), wf16(:,59), n3(:,219), t3x16(:,:,53))
  call vert_AQ_S(gX,ntry, wf8(:,20), ex1(:), wf16(:,60), n3(:,220), t3x16(:,:,54))
  call vert_QA_V(ntry, ex1(:), wf8(:,20), wf16(:,61), n3(:,221), t3x16(:,:,55))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,20), wf16(:,62), n3(:,222), t3x16(:,:,56))
  call vert_AQ_S(gH,ntry, wf8(:,85), ex1(:), wf16(:,63), n3(:,223), t3x16(:,:,57))
  call vert_AQ_S(gX,ntry, wf8(:,85), ex1(:), wf16(:,64), n3(:,224), t3x16(:,:,58))
  call vert_QA_V(ntry, ex1(:), wf8(:,85), wf16(:,65), n3(:,225), t3x16(:,:,59))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,85), wf16(:,66), n3(:,226), t3x16(:,:,60))
  call vert_AV_Q(ntry, wf8(:,25), ex5(:), wf16(:,67), n3(:,227), t3x16(:,:,61))
  call prop_A_Q(ntry, wf16(:,67), 30, ME, 1_intkind1, wf16(:,68), n2(107))
  call vert_AV_Q(ntry, wf8(:,25), ex6(:), wf16(:,69), n3(:,228), t3x16(:,:,62))
  call prop_A_Q(ntry, wf16(:,69), 46, ME, 1_intkind1, wf16(:,70), n2(108))
  call vert_AV_Q(ntry, wf8(:,20), ex4(:), wf16(:,71), n3(:,229), t3x16(:,:,63))
  call prop_A_Q(ntry, wf16(:,71), 30, ME, 1_intkind1, wf16(:,72), n2(109))
  call vert_AV_Q(ntry, wf8(:,20), ex6(:), wf16(:,73), n3(:,230), t3x16(:,:,64))
  call prop_A_Q(ntry, wf16(:,73), 54, ME, 1_intkind1, wf16(:,74), n2(110))
  call vert_AV_Q(ntry, wf8(:,85), ex4(:), wf16(:,75), n3(:,231), t3x16(:,:,65))
  call prop_A_Q(ntry, wf16(:,75), 46, ME, 1_intkind1, wf16(:,76), n2(111))
  call vert_AV_Q(ntry, wf8(:,85), ex5(:), wf16(:,77), n3(:,232), t3x16(:,:,66))
  call prop_A_Q(ntry, wf16(:,77), 54, ME, 1_intkind1, wf16(:,78), n2(112))
  call vert_AQ_S(gX,ntry, wf4(:,6), wf4(:,11), wf16(:,79), n3(:,233), t3x16(:,:,67))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,6), wf16(:,80), n3(:,234), t3x16(:,:,68))
  call vert_QA_Z(gZl,ntry, wf4(:,11), wf4(:,6), wf16(:,81), n3(:,235), t3x16(:,:,69))
  call vert_AQ_S(gX,ntry, wf4(:,8), wf4(:,11), wf16(:,82), n3(:,236), t3x16(:,:,70))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,8), wf16(:,83), n3(:,237), t3x16(:,:,71))
  call vert_QA_Z(gZl,ntry, wf4(:,11), wf4(:,8), wf16(:,84), n3(:,238), t3x16(:,:,72))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,30), wf16(:,85), n3(:,239), t3x16(:,:,73))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,30), wf16(:,86), n3(:,240), t3x16(:,:,74))
  call vert_QA_V(ntry, wf8(:,30), ex2(:), wf16(:,87), n3(:,241), t3x16(:,:,75))
  call vert_QA_Z(gZl,ntry, wf8(:,30), ex2(:), wf16(:,88), n3(:,242), t3x16(:,:,76))
  call vert_VQ_A(ntry, ex5(:), wf8(:,30), wf16(:,89), n3(:,243), t3x16(:,:,77))
  call prop_Q_A(ntry, wf16(:,89), 29, ME, 1_intkind1, wf16(:,90), n2(113))
  call vert_VQ_A(ntry, ex6(:), wf8(:,30), wf16(:,91), n3(:,244), t3x16(:,:,78))
  call prop_Q_A(ntry, wf16(:,91), 45, ME, 1_intkind1, wf16(:,92), n2(114))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,17), wf16(:,93), n3(:,245), t3x16(:,:,79))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,17), wf16(:,94), n3(:,246), t3x16(:,:,80))
  call vert_QA_V(ntry, wf8(:,17), ex2(:), wf16(:,95), n3(:,247), t3x16(:,:,81))
  call vert_QA_Z(gZl,ntry, wf8(:,17), ex2(:), wf16(:,96), n3(:,248), t3x16(:,:,82))
  call vert_VQ_A(ntry, ex3(:), wf8(:,17), wf16(:,97), n3(:,249), t3x16(:,:,83))
  call prop_Q_A(ntry, wf16(:,97), 29, ME, 1_intkind1, wf16(:,98), n2(115))
  call vert_VQ_A(ntry, ex6(:), wf8(:,17), wf16(:,99), n3(:,250), t3x16(:,:,84))
  call prop_Q_A(ntry, wf16(:,99), 57, ME, 1_intkind1, wf16(:,100), n2(116))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,83), wf16(:,101), n3(:,251), t3x16(:,:,85))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,83), wf16(:,102), n3(:,252), t3x16(:,:,86))
  call vert_QA_V(ntry, wf8(:,83), ex2(:), wf16(:,103), n3(:,253), t3x16(:,:,87))
  call vert_QA_Z(gZl,ntry, wf8(:,83), ex2(:), wf16(:,104), n3(:,254), t3x16(:,:,88))
  call vert_VQ_A(ntry, ex3(:), wf8(:,83), wf16(:,105), n3(:,255), t3x16(:,:,89))
  call prop_Q_A(ntry, wf16(:,105), 45, ME, 1_intkind1, wf16(:,106), n2(117))
  call vert_VQ_A(ntry, ex5(:), wf8(:,83), wf16(:,107), n3(:,256), t3x16(:,:,90))
  call prop_Q_A(ntry, wf16(:,107), 57, ME, 1_intkind1, wf16(:,108), n2(118))
  call vert_AQ_S(gX,ntry, wf4(:,4), wf4(:,14), wf16(:,109), n3(:,257), t3x16(:,:,91))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,4), wf16(:,110), n3(:,258), t3x16(:,:,92))
  call vert_QA_Z(gZl,ntry, wf4(:,14), wf4(:,4), wf16(:,111), n3(:,259), t3x16(:,:,93))
  call vert_AQ_S(gX,ntry, wf4(:,4), wf4(:,16), wf16(:,112), n3(:,260), t3x16(:,:,94))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,4), wf16(:,113), n3(:,261), t3x16(:,:,95))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf4(:,4), wf16(:,114), n3(:,262), t3x16(:,:,96))
  call vert_AQ_S(gH,ntry, wf8(:,38), ex1(:), wf16(:,115), n3(:,263), t3x16(:,:,97))
  call vert_AQ_S(gX,ntry, wf8(:,38), ex1(:), wf16(:,116), n3(:,264), t3x16(:,:,98))
  call vert_QA_V(ntry, ex1(:), wf8(:,38), wf16(:,117), n3(:,265), t3x16(:,:,99))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,38), wf16(:,118), n3(:,266), t3x16(:,:,100))
  call vert_AQ_S(gH,ntry, wf8(:,6), ex1(:), wf16(:,119), n3(:,267), t3x16(:,:,101))
  call vert_AQ_S(gX,ntry, wf8(:,6), ex1(:), wf16(:,120), n3(:,268), t3x16(:,:,102))
  call vert_QA_V(ntry, ex1(:), wf8(:,6), wf16(:,121), n3(:,269), t3x16(:,:,103))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,6), wf16(:,122), n3(:,270), t3x16(:,:,104))
  call vert_AQ_S(gH,ntry, wf8(:,66), ex1(:), wf16(:,123), n3(:,271), t3x16(:,:,105))
  call vert_AQ_S(gX,ntry, wf8(:,66), ex1(:), wf16(:,124), n3(:,272), t3x16(:,:,106))
  call vert_QA_V(ntry, ex1(:), wf8(:,66), wf16(:,125), n3(:,273), t3x16(:,:,107))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,66), wf16(:,126), n3(:,274), t3x16(:,:,108))
  call vert_AV_Q(ntry, wf8(:,38), ex5(:), wf16(:,127), n3(:,275), t3x16(:,:,109))
  call prop_A_Q(ntry, wf16(:,127), 30, ME, 1_intkind1, wf16(:,128), n2(119))
  call vert_AV_Q(ntry, wf8(:,38), ex6(:), wf16(:,129), n3(:,276), t3x16(:,:,110))
  call prop_A_Q(ntry, wf16(:,129), 46, ME, 1_intkind1, wf16(:,130), n2(120))
  call vert_AV_Q(ntry, wf8(:,6), ex3(:), wf16(:,131), n3(:,277), t3x16(:,:,111))
  call prop_A_Q(ntry, wf16(:,131), 30, ME, 1_intkind1, wf16(:,132), n2(121))
  call vert_AV_Q(ntry, wf8(:,6), ex6(:), wf16(:,133), n3(:,278), t3x16(:,:,112))
  call prop_A_Q(ntry, wf16(:,133), 58, ME, 1_intkind1, wf16(:,134), n2(122))
  call vert_AV_Q(ntry, wf8(:,66), ex3(:), wf16(:,135), n3(:,279), t3x16(:,:,113))
  call prop_A_Q(ntry, wf16(:,135), 46, ME, 1_intkind1, wf16(:,136), n2(123))
  call vert_AV_Q(ntry, wf8(:,66), ex5(:), wf16(:,137), n3(:,280), t3x16(:,:,114))
  call prop_A_Q(ntry, wf16(:,137), 58, ME, 1_intkind1, wf16(:,138), n2(124))
  call vert_AQ_S(gX,ntry, wf4(:,8), wf4(:,14), wf16(:,139), n3(:,281), t3x16(:,:,115))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,8), wf16(:,140), n3(:,282), t3x16(:,:,116))
  call vert_QA_Z(gZl,ntry, wf4(:,14), wf4(:,8), wf16(:,141), n3(:,283), t3x16(:,:,117))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,36), wf16(:,142), n3(:,284), t3x16(:,:,118))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,36), wf16(:,143), n3(:,285), t3x16(:,:,119))
  call vert_QA_V(ntry, wf8(:,36), ex2(:), wf16(:,144), n3(:,286), t3x16(:,:,120))
  call vert_QA_Z(gZl,ntry, wf8(:,36), ex2(:), wf16(:,145), n3(:,287), t3x16(:,:,121))
  call vert_VQ_A(ntry, ex4(:), wf8(:,36), wf16(:,146), n3(:,288), t3x16(:,:,122))
  call prop_Q_A(ntry, wf16(:,146), 29, ME, 1_intkind1, wf16(:,147), n2(125))
  call vert_VQ_A(ntry, ex6(:), wf8(:,36), wf16(:,148), n3(:,289), t3x16(:,:,123))
  call prop_Q_A(ntry, wf16(:,148), 53, ME, 1_intkind1, wf16(:,149), n2(126))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,22), wf16(:,150), n3(:,290), t3x16(:,:,124))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,22), wf16(:,151), n3(:,291), t3x16(:,:,125))
  call vert_QA_V(ntry, wf8(:,22), ex2(:), wf16(:,152), n3(:,292), t3x16(:,:,126))
  call vert_QA_Z(gZl,ntry, wf8(:,22), ex2(:), wf16(:,153), n3(:,293), t3x16(:,:,127))
  call vert_VQ_A(ntry, ex3(:), wf8(:,22), wf16(:,154), n3(:,294), t3x16(:,:,128))
  call prop_Q_A(ntry, wf16(:,154), 29, ME, 1_intkind1, wf16(:,155), n2(127))
  call vert_VQ_A(ntry, ex6(:), wf8(:,22), wf16(:,156), n3(:,295), t3x16(:,:,129))
  call prop_Q_A(ntry, wf16(:,156), 57, ME, 1_intkind1, wf16(:,157), n2(128))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,91), wf16(:,158), n3(:,296), t3x16(:,:,130))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,91), wf16(:,159), n3(:,297), t3x16(:,:,131))
  call vert_QA_V(ntry, wf8(:,91), ex2(:), wf16(:,160), n3(:,298), t3x16(:,:,132))
  call vert_QA_Z(gZl,ntry, wf8(:,91), ex2(:), wf16(:,161), n3(:,299), t3x16(:,:,133))
  call vert_VQ_A(ntry, ex3(:), wf8(:,91), wf16(:,162), n3(:,300), t3x16(:,:,134))
  call prop_Q_A(ntry, wf16(:,162), 53, ME, 1_intkind1, wf16(:,163), n2(129))
  call vert_VQ_A(ntry, ex4(:), wf8(:,91), wf16(:,164), n3(:,301), t3x16(:,:,135))
  call prop_Q_A(ntry, wf16(:,164), 57, ME, 1_intkind1, wf16(:,165), n2(130))
  call vert_AQ_S(gX,ntry, wf4(:,6), wf4(:,16), wf16(:,166), n3(:,302), t3x16(:,:,136))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,6), wf16(:,167), n3(:,303), t3x16(:,:,137))
  call vert_QA_Z(gZl,ntry, wf4(:,16), wf4(:,6), wf16(:,168), n3(:,304), t3x16(:,:,138))
  call vert_AQ_S(gH,ntry, wf8(:,32), ex1(:), wf16(:,169), n3(:,305), t3x16(:,:,139))
  call vert_AQ_S(gX,ntry, wf8(:,32), ex1(:), wf16(:,170), n3(:,306), t3x16(:,:,140))
  call vert_QA_V(ntry, ex1(:), wf8(:,32), wf16(:,171), n3(:,307), t3x16(:,:,141))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,32), wf16(:,172), n3(:,308), t3x16(:,:,142))
  call vert_AQ_S(gH,ntry, wf8(:,11), ex1(:), wf16(:,173), n3(:,309), t3x16(:,:,143))
  call vert_AQ_S(gX,ntry, wf8(:,11), ex1(:), wf16(:,174), n3(:,310), t3x16(:,:,144))
  call vert_QA_V(ntry, ex1(:), wf8(:,11), wf16(:,175), n3(:,311), t3x16(:,:,145))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,11), wf16(:,176), n3(:,312), t3x16(:,:,146))
  call vert_AQ_S(gH,ntry, wf8(:,73), ex1(:), wf16(:,177), n3(:,313), t3x16(:,:,147))
  call vert_AQ_S(gX,ntry, wf8(:,73), ex1(:), wf16(:,178), n3(:,314), t3x16(:,:,148))
  call vert_QA_V(ntry, ex1(:), wf8(:,73), wf16(:,179), n3(:,315), t3x16(:,:,149))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,73), wf16(:,180), n3(:,316), t3x16(:,:,150))
  call vert_AV_Q(ntry, wf8(:,32), ex4(:), wf16(:,181), n3(:,317), t3x16(:,:,151))
  call prop_A_Q(ntry, wf16(:,181), 30, ME, 1_intkind1, wf16(:,182), n2(131))
  call vert_AV_Q(ntry, wf8(:,32), ex6(:), wf16(:,183), n3(:,318), t3x16(:,:,152))
  call prop_A_Q(ntry, wf16(:,183), 54, ME, 1_intkind1, wf16(:,184), n2(132))
  call vert_AV_Q(ntry, wf8(:,11), ex3(:), wf16(:,185), n3(:,319), t3x16(:,:,153))
  call prop_A_Q(ntry, wf16(:,185), 30, ME, 1_intkind1, wf16(:,186), n2(133))
  call vert_AV_Q(ntry, wf8(:,11), ex6(:), wf16(:,187), n3(:,320), t3x16(:,:,154))
  call prop_A_Q(ntry, wf16(:,187), 58, ME, 1_intkind1, wf16(:,188), n2(134))
  call vert_AV_Q(ntry, wf8(:,73), ex3(:), wf16(:,189), n3(:,321), t3x16(:,:,155))
  call prop_A_Q(ntry, wf16(:,189), 54, ME, 1_intkind1, wf16(:,190), n2(135))
  call vert_AV_Q(ntry, wf8(:,73), ex4(:), wf16(:,191), n3(:,322), t3x16(:,:,156))
  call prop_A_Q(ntry, wf16(:,191), 58, ME, 1_intkind1, wf16(:,192), n2(136))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,40), wf16(:,193), n3(:,323), t3x16(:,:,157))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,40), wf16(:,194), n3(:,324), t3x16(:,:,158))
  call vert_QA_V(ntry, wf8(:,40), ex2(:), wf16(:,195), n3(:,325), t3x16(:,:,159))
  call vert_QA_Z(gZl,ntry, wf8(:,40), ex2(:), wf16(:,196), n3(:,326), t3x16(:,:,160))
  call vert_VQ_A(ntry, ex4(:), wf8(:,40), wf16(:,197), n3(:,327), t3x16(:,:,161))
  call prop_Q_A(ntry, wf16(:,197), 45, ME, 1_intkind1, wf16(:,198), n2(137))
  call vert_VQ_A(ntry, ex5(:), wf8(:,40), wf16(:,199), n3(:,328), t3x16(:,:,162))
  call prop_Q_A(ntry, wf16(:,199), 53, ME, 1_intkind1, wf16(:,200), n2(138))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,27), wf16(:,201), n3(:,329), t3x16(:,:,163))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,27), wf16(:,202), n3(:,330), t3x16(:,:,164))
  call vert_QA_V(ntry, wf8(:,27), ex2(:), wf16(:,203), n3(:,331), t3x16(:,:,165))
  call vert_QA_Z(gZl,ntry, wf8(:,27), ex2(:), wf16(:,204), n3(:,332), t3x16(:,:,166))
  call vert_VQ_A(ntry, ex3(:), wf8(:,27), wf16(:,205), n3(:,333), t3x16(:,:,167))
  call prop_Q_A(ntry, wf16(:,205), 45, ME, 1_intkind1, wf16(:,206), n2(139))
  call vert_VQ_A(ntry, ex5(:), wf8(:,27), wf16(:,207), n3(:,334), t3x16(:,:,168))
  call prop_Q_A(ntry, wf16(:,207), 57, ME, 1_intkind1, wf16(:,208), n2(140))
  call vert_AQ_S(gH,ntry, ex2(:), wf8(:,93), wf16(:,209), n3(:,335), t3x16(:,:,169))
  call vert_AQ_S(gX,ntry, ex2(:), wf8(:,93), wf16(:,210), n3(:,336), t3x16(:,:,170))
  call vert_QA_V(ntry, wf8(:,93), ex2(:), wf16(:,211), n3(:,337), t3x16(:,:,171))
  call vert_QA_Z(gZl,ntry, wf8(:,93), ex2(:), wf16(:,212), n3(:,338), t3x16(:,:,172))
  call vert_VQ_A(ntry, ex3(:), wf8(:,93), wf16(:,213), n3(:,339), t3x16(:,:,173))
  call prop_Q_A(ntry, wf16(:,213), 53, ME, 1_intkind1, wf16(:,214), n2(141))
  call vert_VQ_A(ntry, ex4(:), wf8(:,93), wf16(:,215), n3(:,340), t3x16(:,:,174))
  call prop_Q_A(ntry, wf16(:,215), 57, ME, 1_intkind1, wf16(:,216), n2(142))
  call vert_AQ_S(gH,ntry, wf8(:,34), ex1(:), wf16(:,217), n3(:,341), t3x16(:,:,175))
  call vert_AQ_S(gX,ntry, wf8(:,34), ex1(:), wf16(:,218), n3(:,342), t3x16(:,:,176))
  call vert_QA_V(ntry, ex1(:), wf8(:,34), wf16(:,219), n3(:,343), t3x16(:,:,177))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,34), wf16(:,220), n3(:,344), t3x16(:,:,178))
  call vert_AQ_S(gH,ntry, wf8(:,14), ex1(:), wf16(:,221), n3(:,345), t3x16(:,:,179))
  call vert_AQ_S(gX,ntry, wf8(:,14), ex1(:), wf16(:,222), n3(:,346), t3x16(:,:,180))
  call vert_QA_V(ntry, ex1(:), wf8(:,14), wf16(:,223), n3(:,347), t3x16(:,:,181))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,14), wf16(:,224), n3(:,348), t3x16(:,:,182))
  call vert_AQ_S(gH,ntry, wf8(:,75), ex1(:), wf16(:,225), n3(:,349), t3x16(:,:,183))
  call vert_AQ_S(gX,ntry, wf8(:,75), ex1(:), wf16(:,226), n3(:,350), t3x16(:,:,184))
  call vert_QA_V(ntry, ex1(:), wf8(:,75), wf16(:,227), n3(:,351), t3x16(:,:,185))
  call vert_QA_Z(gZl,ntry, ex1(:), wf8(:,75), wf16(:,228), n3(:,352), t3x16(:,:,186))
  call vert_AV_Q(ntry, wf8(:,34), ex4(:), wf16(:,229), n3(:,353), t3x16(:,:,187))
  call prop_A_Q(ntry, wf16(:,229), 46, ME, 1_intkind1, wf16(:,230), n2(143))
  call vert_AV_Q(ntry, wf8(:,34), ex5(:), wf16(:,231), n3(:,354), t3x16(:,:,188))
  call prop_A_Q(ntry, wf16(:,231), 54, ME, 1_intkind1, wf16(:,232), n2(144))
  call vert_AV_Q(ntry, wf8(:,14), ex3(:), wf16(:,233), n3(:,355), t3x16(:,:,189))
  call prop_A_Q(ntry, wf16(:,233), 46, ME, 1_intkind1, wf16(:,234), n2(145))
  call vert_AV_Q(ntry, wf8(:,14), ex5(:), wf16(:,235), n3(:,356), t3x16(:,:,190))
  call prop_A_Q(ntry, wf16(:,235), 58, ME, 1_intkind1, wf16(:,236), n2(146))
  call vert_AV_Q(ntry, wf8(:,75), ex3(:), wf16(:,237), n3(:,357), t3x16(:,:,191))
  call prop_A_Q(ntry, wf16(:,237), 54, ME, 1_intkind1, wf16(:,238), n2(147))
  call vert_AV_Q(ntry, wf8(:,75), ex4(:), wf16(:,239), n3(:,358), t3x16(:,:,192))
  call prop_A_Q(ntry, wf16(:,239), 58, ME, 1_intkind1, wf16(:,240), n2(148))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,1), n3(:,359), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,2), n3(:,360), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,3), n3(:,361), t3x64(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,11), A(:,4), n3(:,362), t3x64(:,:,4), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,12), A(:,5), n3(:,363), t3x64(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,1), wf8(:,14), A(:,6), n3(:,364), t3x64(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,17), A(:,7), n3(:,365), t3x64(:,:,7), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,20), A(:,8), n3(:,366), t3x64(:,:,8), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,22), A(:,9), n3(:,367), t3x64(:,:,9), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,25), A(:,10), n3(:,368), t3x64(:,:,10), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,27), A(:,11), n3(:,369), t3x64(:,:,11), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,28), A(:,12), n3(:,370), t3x64(:,:,12), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,30), A(:,13), n3(:,371), t3x64(:,:,13), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,32), A(:,14), n3(:,372), t3x64(:,:,14), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,30), A(:,15), n3(:,373), t3x64(:,:,15), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,34), A(:,16), n3(:,374), t3x64(:,:,16), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,36), A(:,17), n3(:,375), t3x64(:,:,17), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,38), A(:,18), n3(:,376), t3x64(:,:,18), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,40), A(:,19), n3(:,377), t3x64(:,:,19), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,38), A(:,20), n3(:,378), t3x64(:,:,20), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,36), A(:,21), n3(:,379), t3x64(:,:,21), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,34), A(:,22), n3(:,380), t3x64(:,:,22), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,40), A(:,23), n3(:,381), t3x64(:,:,23), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,32), A(:,24), n3(:,382), t3x64(:,:,24), nhel, den(58))

    call Hcont_VV(nsync, wf8(:,41), wf8(:,42), A(:,25), n3(:,383), t3x64(:,:,25), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,43), A(:,26), n3(:,384), t3x64(:,:,26), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,44), A(:,27), n3(:,385), t3x64(:,:,27), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,41), wf8(:,45), A(:,28), n3(:,386), t3x64(:,:,28), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,47), A(:,29), n3(:,387), t3x64(:,:,29), nhel, den(66))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,48), A(:,30), n3(:,388), t3x64(:,:,30), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,49), A(:,31), n3(:,389), t3x64(:,:,31), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,46), wf8(:,50), A(:,32), n3(:,390), t3x64(:,:,32), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,52), A(:,33), n3(:,391), t3x64(:,:,33), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,53), A(:,34), n3(:,392), t3x64(:,:,34), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,54), A(:,35), n3(:,393), t3x64(:,:,35), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,51), wf8(:,55), A(:,36), n3(:,394), t3x64(:,:,36), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,57), A(:,37), n3(:,395), t3x64(:,:,37), nhel, den(78))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,58), A(:,38), n3(:,396), t3x64(:,:,38), nhel, den(80))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,59), A(:,39), n3(:,397), t3x64(:,:,39), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,56), wf8(:,60), A(:,40), n3(:,398), t3x64(:,:,40), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,61), A(:,41), n3(:,399), t3x64(:,:,41), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,62), A(:,42), n3(:,400), t3x64(:,:,42), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,64), A(:,43), n3(:,401), t3x64(:,:,43), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,65), wf8(:,66), A(:,44), n3(:,402), t3x64(:,:,44), nhel, den(86))
    call Hcont_SS(nsync, wf4(:,17), wf16(:,1), A(:,45), n3(:,403), t3x64(:,:,45), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,67), A(:,46), n3(:,404), t3x64(:,:,46), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,62), A(:,47), n3(:,405), t3x64(:,:,47), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,68), A(:,48), n3(:,406), t3x64(:,:,48), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,65), A(:,49), n3(:,407), t3x64(:,:,49), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,70), A(:,50), n3(:,408), t3x64(:,:,50), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,71), A(:,51), n3(:,409), t3x64(:,:,51), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,73), A(:,52), n3(:,410), t3x64(:,:,52), nhel, den(95))
    call Hcont_SS(nsync, wf4(:,18), wf16(:,2), A(:,53), n3(:,411), t3x64(:,:,53), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,74), A(:,54), n3(:,412), t3x64(:,:,54), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,72), wf8(:,75), A(:,55), n3(:,413), t3x64(:,:,55), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,1), wf8(:,77), A(:,56), n3(:,414), t3x64(:,:,56), nhel, den(103))
    call Hcont_SS(nsync, wf4(:,19), wf16(:,3), A(:,57), n3(:,415), t3x64(:,:,57), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,79), A(:,58), n3(:,416), t3x64(:,:,58), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,80), A(:,59), n3(:,417), t3x64(:,:,59), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,81), A(:,60), n3(:,418), t3x64(:,:,60), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,83), A(:,61), n3(:,419), t3x64(:,:,61), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,85), A(:,62), n3(:,420), t3x64(:,:,62), nhel, den(112))
    call Hcont_SS(nsync, wf4(:,17), wf16(:,4), A(:,63), n3(:,421), t3x64(:,:,63), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,80), A(:,64), n3(:,422), t3x64(:,:,64), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,86), A(:,65), n3(:,423), t3x64(:,:,65), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,82), A(:,66), n3(:,424), t3x64(:,:,66), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,87), A(:,67), n3(:,425), t3x64(:,:,67), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,89), A(:,68), n3(:,426), t3x64(:,:,68), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,91), A(:,69), n3(:,427), t3x64(:,:,69), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,92), A(:,70), n3(:,428), t3x64(:,:,70), nhel, den(120))
    call Hcont_SS(nsync, wf4(:,18), wf16(:,5), A(:,71), n3(:,429), t3x64(:,:,71), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,90), wf8(:,93), A(:,72), n3(:,430), t3x64(:,:,72), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,94), A(:,73), n3(:,431), t3x64(:,:,73), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,96), A(:,74), n3(:,432), t3x64(:,:,74), nhel, den(127))
    call Hcont_SS(nsync, wf4(:,19), wf16(:,6), A(:,75), n3(:,433), t3x64(:,:,75), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,98), A(:,76), n3(:,434), t3x64(:,:,76), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,67), A(:,77), n3(:,435), t3x64(:,:,77), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,81), A(:,78), n3(:,436), t3x64(:,:,78), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,68), A(:,79), n3(:,437), t3x64(:,:,79), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,84), A(:,80), n3(:,438), t3x64(:,:,80), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,70), A(:,81), n3(:,439), t3x64(:,:,81), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,61), A(:,82), n3(:,440), t3x64(:,:,82), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,86), A(:,83), n3(:,441), t3x64(:,:,83), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,63), A(:,84), n3(:,442), t3x64(:,:,84), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,87), A(:,85), n3(:,443), t3x64(:,:,85), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,89), A(:,86), n3(:,444), t3x64(:,:,86), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,74), A(:,87), n3(:,445), t3x64(:,:,87), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,92), A(:,88), n3(:,446), t3x64(:,:,88), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,77), A(:,89), n3(:,447), t3x64(:,:,89), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,71), A(:,90), n3(:,448), t3x64(:,:,90), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,94), A(:,91), n3(:,449), t3x64(:,:,91), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,96), A(:,92), n3(:,450), t3x64(:,:,92), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,79), A(:,93), n3(:,451), t3x64(:,:,93), nhel, den(136))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,98), A(:,94), n3(:,452), t3x64(:,:,94), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,99), A(:,95), n3(:,453), t3x64(:,:,95), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,100), A(:,96), n3(:,454), t3x64(:,:,96), nhel, den(139))
    call Hcont_SS(nsync, wf4(:,20), wf16(:,7), A(:,97), n3(:,455), t3x64(:,:,97), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,101), A(:,98), n3(:,456), t3x64(:,:,98), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,75), wf8(:,100), A(:,99), n3(:,457), t3x64(:,:,99), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,103), A(:,100), n3(:,458), t3x64(:,:,100), nhel, den(146))
    call Hcont_SS(nsync, wf4(:,21), wf16(:,8), A(:,101), n3(:,459), t3x64(:,:,101), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,105), A(:,102), n3(:,460), t3x64(:,:,102), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,106), A(:,103), n3(:,461), t3x64(:,:,103), nhel, den(152))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,107), A(:,104), n3(:,462), t3x64(:,:,104), nhel, den(153))
    call Hcont_SS(nsync, wf4(:,20), wf16(:,9), A(:,105), n3(:,463), t3x64(:,:,105), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,106), A(:,106), n3(:,464), t3x64(:,:,106), nhel, den(156))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,108), A(:,107), n3(:,465), t3x64(:,:,107), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,110), A(:,108), n3(:,466), t3x64(:,:,108), nhel, den(159))
    call Hcont_SS(nsync, wf4(:,21), wf16(:,10), A(:,109), n3(:,467), t3x64(:,:,109), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,112), A(:,110), n3(:,468), t3x64(:,:,110), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,101), A(:,111), n3(:,469), t3x64(:,:,111), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,107), A(:,112), n3(:,470), t3x64(:,:,112), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,103), A(:,113), n3(:,471), t3x64(:,:,113), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,99), A(:,114), n3(:,472), t3x64(:,:,114), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,108), A(:,115), n3(:,473), t3x64(:,:,115), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,110), A(:,116), n3(:,474), t3x64(:,:,116), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,105), A(:,117), n3(:,475), t3x64(:,:,117), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,112), A(:,118), n3(:,476), t3x64(:,:,118), nhel, den(171))
    call Hcont_SS(nsync, wf4(:,22), wf16(:,11), A(:,119), n3(:,477), t3x64(:,:,119), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,114), A(:,120), n3(:,478), t3x64(:,:,120), nhel, den(176))
    call Hcont_SS(nsync, wf4(:,22), wf16(:,12), A(:,121), n3(:,479), t3x64(:,:,121), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,116), A(:,122), n3(:,480), t3x64(:,:,122), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,114), A(:,123), n3(:,481), t3x64(:,:,123), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,116), A(:,124), n3(:,482), t3x64(:,:,124), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,117), A(:,125), n3(:,483), t3x64(:,:,125), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,1), wf8(:,119), A(:,126), n3(:,484), t3x64(:,:,126), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,120), A(:,127), n3(:,485), t3x64(:,:,127), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,122), A(:,128), n3(:,486), t3x64(:,:,128), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,123), A(:,129), n3(:,487), t3x64(:,:,129), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,125), A(:,130), n3(:,488), t3x64(:,:,130), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,117), A(:,131), n3(:,489), t3x64(:,:,131), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,127), A(:,132), n3(:,490), t3x64(:,:,132), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,120), A(:,133), n3(:,491), t3x64(:,:,133), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,129), A(:,134), n3(:,492), t3x64(:,:,134), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,118), A(:,135), n3(:,493), t3x64(:,:,135), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,127), A(:,136), n3(:,494), t3x64(:,:,136), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,121), A(:,137), n3(:,495), t3x64(:,:,137), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,129), A(:,138), n3(:,496), t3x64(:,:,138), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,123), A(:,139), n3(:,497), t3x64(:,:,139), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,131), A(:,140), n3(:,498), t3x64(:,:,140), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,124), A(:,141), n3(:,499), t3x64(:,:,141), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,131), A(:,142), n3(:,500), t3x64(:,:,142), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,132), A(:,143), n3(:,501), t3x64(:,:,143), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,134), A(:,144), n3(:,502), t3x64(:,:,144), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,132), A(:,145), n3(:,503), t3x64(:,:,145), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,136), A(:,146), n3(:,504), t3x64(:,:,146), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,133), A(:,147), n3(:,505), t3x64(:,:,147), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,136), A(:,148), n3(:,506), t3x64(:,:,148), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,138), A(:,149), n3(:,507), t3x64(:,:,149), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,139), A(:,150), n3(:,508), t3x64(:,:,150), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,141), A(:,151), n3(:,509), t3x64(:,:,151), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,142), A(:,152), n3(:,510), t3x64(:,:,152), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,144), A(:,153), n3(:,511), t3x64(:,:,153), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,145), A(:,154), n3(:,512), t3x64(:,:,154), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,147), A(:,155), n3(:,513), t3x64(:,:,155), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,139), A(:,156), n3(:,514), t3x64(:,:,156), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,149), A(:,157), n3(:,515), t3x64(:,:,157), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,142), A(:,158), n3(:,516), t3x64(:,:,158), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,147), A(:,159), n3(:,517), t3x64(:,:,159), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,137), A(:,160), n3(:,518), t3x64(:,:,160), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,149), A(:,161), n3(:,519), t3x64(:,:,161), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,140), A(:,162), n3(:,520), t3x64(:,:,162), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,151), A(:,163), n3(:,521), t3x64(:,:,163), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,145), A(:,164), n3(:,522), t3x64(:,:,164), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,151), A(:,165), n3(:,523), t3x64(:,:,165), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,143), A(:,166), n3(:,524), t3x64(:,:,166), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,153), A(:,167), n3(:,525), t3x64(:,:,167), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,154), A(:,168), n3(:,526), t3x64(:,:,168), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,156), A(:,169), n3(:,527), t3x64(:,:,169), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,154), A(:,170), n3(:,528), t3x64(:,:,170), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,156), A(:,171), n3(:,529), t3x64(:,:,171), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,152), A(:,172), n3(:,530), t3x64(:,:,172), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,157), A(:,173), n3(:,531), t3x64(:,:,173), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,158), A(:,174), n3(:,532), t3x64(:,:,174), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,159), A(:,175), n3(:,533), t3x64(:,:,175), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,160), A(:,176), n3(:,534), t3x64(:,:,176), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,161), A(:,177), n3(:,535), t3x64(:,:,177), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,162), A(:,178), n3(:,536), t3x64(:,:,178), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,163), A(:,179), n3(:,537), t3x64(:,:,179), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,158), A(:,180), n3(:,538), t3x64(:,:,180), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,164), A(:,181), n3(:,539), t3x64(:,:,181), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,165), A(:,182), n3(:,540), t3x64(:,:,182), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,166), A(:,183), n3(:,541), t3x64(:,:,183), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,64), wf8(:,167), A(:,184), n3(:,542), t3x64(:,:,184), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,75), wf8(:,163), A(:,185), n3(:,543), t3x64(:,:,185), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,157), A(:,186), n3(:,544), t3x64(:,:,186), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,168), A(:,187), n3(:,545), t3x64(:,:,187), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,169), A(:,188), n3(:,546), t3x64(:,:,188), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,75), wf8(:,166), A(:,189), n3(:,547), t3x64(:,:,189), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,170), A(:,190), n3(:,548), t3x64(:,:,190), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,171), A(:,191), n3(:,549), t3x64(:,:,191), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,172), A(:,192), n3(:,550), t3x64(:,:,192), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,173), A(:,193), n3(:,551), t3x64(:,:,193), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,174), A(:,194), n3(:,552), t3x64(:,:,194), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,175), A(:,195), n3(:,553), t3x64(:,:,195), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,176), A(:,196), n3(:,554), t3x64(:,:,196), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,177), A(:,197), n3(:,555), t3x64(:,:,197), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,178), A(:,198), n3(:,556), t3x64(:,:,198), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,179), A(:,199), n3(:,557), t3x64(:,:,199), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,174), A(:,200), n3(:,558), t3x64(:,:,200), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,180), A(:,201), n3(:,559), t3x64(:,:,201), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,181), A(:,202), n3(:,560), t3x64(:,:,202), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,182), A(:,203), n3(:,561), t3x64(:,:,203), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,183), A(:,204), n3(:,562), t3x64(:,:,204), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,179), A(:,205), n3(:,563), t3x64(:,:,205), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,173), A(:,206), n3(:,564), t3x64(:,:,206), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,184), A(:,207), n3(:,565), t3x64(:,:,207), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,181), A(:,208), n3(:,566), t3x64(:,:,208), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,185), A(:,209), n3(:,567), t3x64(:,:,209), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,172), A(:,210), n3(:,568), t3x64(:,:,210), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,186), A(:,211), n3(:,569), t3x64(:,:,211), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,165), A(:,212), n3(:,570), t3x64(:,:,212), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,73), wf8(:,187), A(:,213), n3(:,571), t3x64(:,:,213), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,188), A(:,214), n3(:,572), t3x64(:,:,214), nhel, den(232))
    call Hcont_QA(nsync, wf8(:,75), wf8(:,185), A(:,215), n3(:,573), t3x64(:,:,215), nhel, den(233))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,171), A(:,216), n3(:,574), t3x64(:,:,216), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,189), A(:,217), n3(:,575), t3x64(:,:,217), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,169), A(:,218), n3(:,576), t3x64(:,:,218), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,75), wf8(:,187), A(:,219), n3(:,577), t3x64(:,:,219), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,190), A(:,220), n3(:,578), t3x64(:,:,220), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,191), A(:,221), n3(:,579), t3x64(:,:,221), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,178), A(:,222), n3(:,580), t3x64(:,:,222), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,192), A(:,223), n3(:,581), t3x64(:,:,223), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,160), A(:,224), n3(:,582), t3x64(:,:,224), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,66), wf8(:,193), A(:,225), n3(:,583), t3x64(:,:,225), nhel, den(243))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,194), A(:,226), n3(:,584), t3x64(:,:,226), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,195), A(:,227), n3(:,585), t3x64(:,:,227), nhel, den(245))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,183), A(:,228), n3(:,586), t3x64(:,:,228), nhel, den(246))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,192), A(:,229), n3(:,587), t3x64(:,:,229), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,159), A(:,230), n3(:,588), t3x64(:,:,230), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,196), A(:,231), n3(:,589), t3x64(:,:,231), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,93), wf8(:,194), A(:,232), n3(:,590), t3x64(:,:,232), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,191), A(:,233), n3(:,591), t3x64(:,:,233), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,177), A(:,234), n3(:,592), t3x64(:,:,234), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,189), A(:,235), n3(:,593), t3x64(:,:,235), nhel, den(253))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,168), A(:,236), n3(:,594), t3x64(:,:,236), nhel, den(254))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,193), A(:,237), n3(:,595), t3x64(:,:,237), nhel, den(255))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,190), A(:,238), n3(:,596), t3x64(:,:,238), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,195), A(:,239), n3(:,597), t3x64(:,:,239), nhel, den(257))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,182), A(:,240), n3(:,598), t3x64(:,:,240), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,186), A(:,241), n3(:,599), t3x64(:,:,241), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,164), A(:,242), n3(:,600), t3x64(:,:,242), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,196), A(:,243), n3(:,601), t3x64(:,:,243), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,188), A(:,244), n3(:,602), t3x64(:,:,244), nhel, den(262))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j+A(j,7)%j+A(j,8)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j &
       +A(j,13)%j+A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,23)%j &
       +A(j,24)%j)*f(1)

  M2(1)%j = (A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,44)%j+A(j,46)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j+A(j,51)%j+A(j,52)%j+A(j,54)%j &
       +A(j,55)%j+A(j,59)%j+A(j,60)%j+A(j,61)%j+A(j,62)%j+A(j,64)%j+A(j,65)%j+A(j,66)%j+A(j,67)%j+A(j,69)%j+A(j,70)%j+A(j,72)%j &
       +A(j,73)%j+A(j,77)%j+A(j,78)%j+A(j,79)%j+A(j,80)%j+A(j,82)%j+A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,87)%j+A(j,88)%j+A(j,90)%j &
       +A(j,91)%j+A(j,95)%j+A(j,96)%j+A(j,98)%j+A(j,99)%j+A(j,103)%j+A(j,104)%j+A(j,106)%j+A(j,107)%j+A(j,111)%j+A(j,112)%j &
       +A(j,114)%j+A(j,115)%j+A(j,125)%j+A(j,126)%j+A(j,127)%j+A(j,128)%j+A(j,129)%j+A(j,130)%j+A(j,131)%j+A(j,132)%j+A(j,133)%j &
       +A(j,134)%j+A(j,135)%j+A(j,136)%j+A(j,137)%j+A(j,138)%j+A(j,139)%j+A(j,140)%j+A(j,141)%j+A(j,142)%j+A(j,143)%j+A(j,144)%j &
       +A(j,145)%j+A(j,146)%j+A(j,147)%j+A(j,148)%j+A(j,149)%j+A(j,150)%j+A(j,151)%j+A(j,152)%j+A(j,153)%j+A(j,154)%j+A(j,155)%j &
       +A(j,156)%j+A(j,157)%j+A(j,158)%j+A(j,159)%j+A(j,160)%j+A(j,161)%j+A(j,162)%j+A(j,163)%j+A(j,164)%j+A(j,165)%j+A(j,166)%j &
       +A(j,167)%j+A(j,168)%j+A(j,169)%j+A(j,170)%j+A(j,171)%j+A(j,172)%j-A(j,173)%j-A(j,174)%j-A(j,175)%j-A(j,176)%j-A(j,177)%j &
       -A(j,178)%j-A(j,179)%j-A(j,180)%j-A(j,181)%j-A(j,182)%j-A(j,183)%j-A(j,184)%j-A(j,185)%j-A(j,186)%j-A(j,187)%j-A(j,188)%j &
       -A(j,189)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j-A(j,193)%j-A(j,194)%j-A(j,195)%j-A(j,196)%j-A(j,197)%j-A(j,198)%j-A(j,199)%j &
       -A(j,200)%j-A(j,201)%j-A(j,202)%j-A(j,203)%j-A(j,204)%j-A(j,205)%j-A(j,206)%j-A(j,207)%j-A(j,208)%j-A(j,209)%j-A(j,210)%j &
       -A(j,211)%j-A(j,212)%j-A(j,213)%j-A(j,214)%j-A(j,215)%j-A(j,216)%j-A(j,217)%j-A(j,218)%j-A(j,219)%j-A(j,220)%j-A(j,221)%j &
       -A(j,222)%j-A(j,223)%j-A(j,224)%j-A(j,225)%j-A(j,226)%j-A(j,227)%j-A(j,228)%j-A(j,229)%j-A(j,230)%j-A(j,231)%j-A(j,232)%j &
       -A(j,233)%j-A(j,234)%j-A(j,235)%j-A(j,236)%j-A(j,237)%j-A(j,238)%j-A(j,239)%j-A(j,240)%j-A(j,241)%j-A(j,242)%j-A(j,243)%j &
       -A(j,244)%j)*f(2)+(A(j,25)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j)*f(3)+(A(j,26)%j &
       +A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j+A(j,38)%j+A(j,40)%j)*f(4)+(-A(j,45)%j-A(j,50)%j-A(j,53)%j-A(j,56)%j &
       -A(j,57)%j-A(j,58)%j-A(j,63)%j-A(j,68)%j-A(j,71)%j-A(j,74)%j-A(j,75)%j-A(j,76)%j-A(j,81)%j-A(j,86)%j-A(j,89)%j-A(j,92)%j &
       -A(j,93)%j-A(j,94)%j-A(j,97)%j-A(j,100)%j-A(j,101)%j-A(j,102)%j-A(j,105)%j-A(j,108)%j-A(j,109)%j-A(j,110)%j-A(j,113)%j &
       -A(j,116)%j-A(j,117)%j-A(j,118)%j-A(j,119)%j-A(j,120)%j-A(j,121)%j-A(j,122)%j-A(j,123)%j-A(j,124)%j)*f(5)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_eeaa_lew_eexaaaa_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for e- e+ gamma gamma gamma gamma -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for e- e+ gamma gamma gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,6)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for eeaa_lew_eexaaaa_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_eeaa_lew_eexaaaa_1, only: &
    & external_perm_inv_eeaa_lew_eexaaaa_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 6
    r = external_perm_inv_eeaa_lew_eexaaaa_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
        case(6)
          call assign_helicity_flip(ex6(:)%hf,ex6(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(64,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_eeaa_lew_eexaaaa_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_eeaa_lew_eexaaaa_1_/**/REALKIND
