      subroutine writeinfo(unitno,xsec,xsec_err)
************************************************************************
*   Routine to write out run information to a desired unit             *
************************************************************************
      implicit none
      include 'maxwt.f'
      include 'masses.f'
      include 'facscale.f'
      include 'scale.f'
      include 'zerowidth.f'
      include 'flags.f'
      include 'clustering.f'
      include 'gridinfo.f'
      include 'limits.f'
      include 'pdfiset.f'
      integer unitno
      double precision xsec,xsec_err
      
      character*4 part
      character*30 runstring
      logical creatent,dswhisto,makecuts
      integer nproc,ih1,ih2,itmx1,itmx2,ncall1,ncall2,rseed
      integer order
      double precision sqrts
      double precision Rcut
      double precision leptpt,leptrap,misspt,Rjlmin,Rllmin,delyjjmin,
     . leptpt2,leptrap2,gammpt,gammrap,gammcone,gammcut
      integer lbjscheme
      logical jetsopphem
 
      common/outputflags/creatent,dswhisto      

      common/nnlo/order
      common/part/part
      common/runstring/runstring
      common/energy/sqrts
      common/density/ih1,ih2
      common/iterat/itmx1,ncall1,itmx2,ncall2
         
    
      
      common/Rcut/Rcut
      common/makecuts/makecuts
      common/leptcuts/leptpt,leptrap,misspt,Rjlmin,Rllmin,delyjjmin,
     . leptpt2,leptrap2,gammpt,gammrap,gammcone,gammcut,
     . lbjscheme,jetsopphem

      common/rseed/rseed

      write(unitno,*) '( Cross-section is: ',xsec,'+/-',xsec_err,')'
      write(unitno,*)
      write(unitno,*) '( Run corresponds to this input file)'
      write(unitno,*)
      write(unitno,*) '(sqrts= ',sqrts
      write(unitno,*) '(ih1= ',ih1,'ih2= ',ih2
      write(unitno,*) '(Mh: ',hmass
      write(unitno,*) '(muf= ',facscale
      write(unitno,*) '(mur= ',scale
      write(unitno,*) '(order= ',order
      write(unitno,*) '(part= ',part
      write(unitno,*) '(itmx1= ',itmx1
      write(unitno,*) '(ncall1= ',ncall1
      write(unitno,*) '(itmx2= ',itmx2
      write(unitno,*) '(ncall2= ',ncall2
      write(unitno,*) '(rnd seed= ',rseed
      write(unitno,*) '(iset= ',iset
      write(unitno,*) '(runstring=',runstring
      write(unitno,*)

      return
      
      end
      
      
