      subroutine scaleset(qt2)
      implicit none
      include 'constants.f'
      include 'masses.f'
      include 'qcdcouple.f'
      include 'nwz.f'
      include 'nlooprun.f'
      include 'scale.f'
      include 'facscale.f'

      double precision qt2,scalemax,amz,alphas,smur,smuf,A
      common/couple/amz
      common/scalefactors/smur,smuf      

C     Parameter used in the scale choice: can be changed in principle

      A=1d0

      scale=smur*dsqrt(hmass**2+A*qt2)
      facscale=smuf*dsqrt(hmass**2+A*qt2)

      scalemax=3000d0


      A=1d0

c--- catch absurdly large scales      
      if  (scale.gt.scalemax) then
       scale=scalemax
       facscale=scalemax
      endif
       

c--- run alpha_s
      as=alphas(scale,amz,nlooprun)  
      ason2pi=as/twopi
      ason4pi=as/fourpi
      gsq=fourpi*as
      musq=scale**2
      
      return
            
      end
