      double precision function c1ggdeltaf(icross,xmh,xmt,xmb)
      implicit none
      integer nl,ibot,icross,approxim
      real * 8 delta2,xmh,xmt,xmb,pi
      real*8 XCVIRT,RHOT,RHOB,EPST,EPSV,REPS
      real*8 FACT,FACB 
      COMPLEX*16 CKOF,CF0,CF0B,CF0T,CFBORN
      common/nl/nl
      COMMON/CUT/EPST,EPSV,REPS
      common/flag/approxim

      pi=3.14159265359d0


c     icross =0 exact result
c     icross =1 large mtop limit

c parameters needed to perform the analytical continuation of Logs
c
      EPST=1.D-8
      EPSV=1.D-8
      REPS=1.D-8
c      
  

      ibot=1


c     Coefficient C1 for Higgs production


       if (icross.eq.0) then
       
         RHOT=xmh**2/xmt**2
         RHOB=xmh**2/xmb**2
         if (ibot.eq.1) then
            fact=1
            facb=1
         elseif (ibot.eq.0) then
            fact=1
            facb=0
         else 
             write(6,*)'wrong ibot in setpar: ',ibot
             stop
         endif
                
C--TOTAL FORM FACTOR
c        CF0=FACT*CFBORN(XMH,xmt)+FACB*CFBORN(XMH,xmb)
C--TOP FORM FACTOR
        CF0T=FACT*CFBORN(XMH,xmt)
C--BOTTOM FORM FACTOR
        CF0B=FACB*CFBORN(XMH,xmb)
C--TOTAL FORM FACTOR
        CF0=CF0T+CF0B*(approxim-1)
c        
        XCVIRT=DREAL((CKOF(RHOT)*CF0T+(approxim-1)*
     .                      CKOF(RHOB)*CF0B)/CF0)
                  
       elseif (icross.eq.1) then       
c Large MT limit
            XCVIRT=5.5d0
       endif

c       write(*,*)XCVIRT

       c1ggdeltaf=xcvirt/2d0+3d0*pi**2/4d0

       return
       end
       

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      BLOCKDATA CVIRT
C--DATA OF VIRTUAL CORRECTIONS
      PARAMETER(NN=999)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      COMMON/RESINT/XX(NN),YHR(NN),YHI(NN),YAR(NN),YAI(NN)

      DATA ( XX(I),I=  1, 40)/
     .   0.000000D+00,   0.100000D+00,   0.200000D+00,   0.300000D+00,
     .   0.400000D+00,   0.500000D+00,   0.600000D+00,   0.800000D+00,
     .   0.900000D+00,   0.100000D+01,   0.110000D+01,   0.120000D+01,
     .   0.130000D+01,   0.150000D+01,   0.160000D+01,   0.170000D+01,
     .   0.180000D+01,   0.190000D+01,   0.200000D+01,   0.210000D+01,
     .   0.220000D+01,   0.230000D+01,   0.240000D+01,   0.250000D+01,
     .   0.260000D+01,   0.270000D+01,   0.280000D+01,   0.300000D+01,
     .   0.310000D+01,   0.320000D+01,   0.330000D+01,   0.340000D+01,
     .   0.350000D+01,   0.360000D+01,   0.370000D+01,   0.380000D+01,
     .   0.390000D+01,   0.391000D+01,   0.392000D+01,   0.393000D+01/

      DATA ( XX(I),I= 41, 80)/
     .   0.394000D+01,   0.395000D+01,   0.396000D+01,   0.397000D+01,
     .   0.398000D+01,   0.399000D+01,   0.399900D+01,   0.399990D+01,
     .   0.399999D+01,   0.400001D+01,   0.400010D+01,   0.400100D+01,
     .   0.401000D+01,   0.402000D+01,   0.403000D+01,   0.404000D+01,
     .   0.405000D+01,   0.406000D+01,   0.407000D+01,   0.408000D+01,
     .   0.409000D+01,   0.410000D+01,   0.420000D+01,   0.430000D+01,
     .   0.440000D+01,   0.450000D+01,   0.460000D+01,   0.470000D+01,
     .   0.480000D+01,   0.490000D+01,   0.500000D+01,   0.510000D+01,
     .   0.520000D+01,   0.530000D+01,   0.540000D+01,   0.550000D+01,
     .   0.560000D+01,   0.570000D+01,   0.580000D+01,   0.590000D+01/

      DATA ( XX(I),I= 81,120)/
     .   0.600000D+01,   0.610000D+01,   0.620000D+01,   0.630000D+01,
     .   0.640000D+01,   0.650000D+01,   0.660000D+01,   0.670000D+01,
     .   0.680000D+01,   0.690000D+01,   0.700000D+01,   0.710000D+01,
     .   0.720000D+01,   0.730000D+01,   0.740000D+01,   0.750000D+01,
     .   0.760000D+01,   0.770000D+01,   0.780000D+01,   0.790000D+01,
     .   0.800000D+01,   0.810000D+01,   0.820000D+01,   0.830000D+01,
     .   0.840000D+01,   0.850000D+01,   0.860000D+01,   0.870000D+01,
     .   0.880000D+01,   0.890000D+01,   0.900000D+01,   0.910000D+01,
     .   0.920000D+01,   0.930000D+01,   0.940000D+01,   0.950000D+01,
     .   0.960000D+01,   0.970000D+01,   0.980000D+01,   0.990000D+01/

      DATA ( XX(I),I=121,160)/
     .   0.100000D+02,   0.105000D+02,   0.110000D+02,   0.115000D+02,
     .   0.120000D+02,   0.125000D+02,   0.130000D+02,   0.135000D+02,
     .   0.140000D+02,   0.145000D+02,   0.150000D+02,   0.155000D+02,
     .   0.160000D+02,   0.165000D+02,   0.170000D+02,   0.175000D+02,
     .   0.180000D+02,   0.185000D+02,   0.190000D+02,   0.195000D+02,
     .   0.200000D+02,   0.210000D+02,   0.220000D+02,   0.230000D+02,
     .   0.240000D+02,   0.250000D+02,   0.260000D+02,   0.270000D+02,
     .   0.280000D+02,   0.290000D+02,   0.300000D+02,   0.310000D+02,
     .   0.320000D+02,   0.330000D+02,   0.340000D+02,   0.350000D+02,
     .   0.360000D+02,   0.370000D+02,   0.380000D+02,   0.390000D+02/

      DATA ( XX(I),I=161,200)/
     .   0.400000D+02,   0.410000D+02,   0.420000D+02,   0.430000D+02,
     .   0.440000D+02,   0.450000D+02,   0.460000D+02,   0.470000D+02,
     .   0.480000D+02,   0.490000D+02,   0.500000D+02,   0.510000D+02,
     .   0.520000D+02,   0.530000D+02,   0.540000D+02,   0.550000D+02,
     .   0.560000D+02,   0.570000D+02,   0.580000D+02,   0.590000D+02,
     .   0.600000D+02,   0.610000D+02,   0.620000D+02,   0.630000D+02,
     .   0.640000D+02,   0.650000D+02,   0.660000D+02,   0.670000D+02,
     .   0.680000D+02,   0.690000D+02,   0.700000D+02,   0.710000D+02,
     .   0.720000D+02,   0.730000D+02,   0.740000D+02,   0.750000D+02,
     .   0.760000D+02,   0.770000D+02,   0.780000D+02,   0.790000D+02/

      DATA ( XX(I),I=201,240)/
     .   0.800000D+02,   0.810000D+02,   0.820000D+02,   0.830000D+02,
     .   0.840000D+02,   0.850000D+02,   0.860000D+02,   0.870000D+02,
     .   0.880000D+02,   0.890000D+02,   0.900000D+02,   0.910000D+02,
     .   0.920000D+02,   0.930000D+02,   0.940000D+02,   0.950000D+02,
     .   0.960000D+02,   0.970000D+02,   0.980000D+02,   0.990000D+02,
     .   0.100000D+03,   0.105000D+03,   0.110000D+03,   0.115000D+03,
     .   0.120000D+03,   0.125000D+03,   0.130000D+03,   0.135000D+03,
     .   0.140000D+03,   0.145000D+03,   0.150000D+03,   0.155000D+03,
     .   0.160000D+03,   0.165000D+03,   0.170000D+03,   0.175000D+03,
     .   0.180000D+03,   0.185000D+03,   0.190000D+03,   0.195000D+03/

      DATA ( XX(I),I=241,280)/
     .   0.200000D+03,   0.210000D+03,   0.220000D+03,   0.230000D+03,
     .   0.240000D+03,   0.250000D+03,   0.260000D+03,   0.270000D+03,
     .   0.280000D+03,   0.290000D+03,   0.300000D+03,   0.310000D+03,
     .   0.320000D+03,   0.330000D+03,   0.340000D+03,   0.350000D+03,
     .   0.360000D+03,   0.370000D+03,   0.380000D+03,   0.390000D+03,
     .   0.400000D+03,   0.410000D+03,   0.420000D+03,   0.430000D+03,
     .   0.440000D+03,   0.450000D+03,   0.460000D+03,   0.470000D+03,
     .   0.480000D+03,   0.490000D+03,   0.500000D+03,   0.550000D+03,
     .   0.600000D+03,   0.650000D+03,   0.700000D+03,   0.750000D+03,
     .   0.800000D+03,   0.850000D+03,   0.900000D+03,   0.950000D+03/

      DATA ( XX(I),I=281,320)/
     .   0.100000D+04,   0.105000D+04,   0.110000D+04,   0.115000D+04,
     .   0.120000D+04,   0.125000D+04,   0.130000D+04,   0.135000D+04,
     .   0.140000D+04,   0.145000D+04,   0.150000D+04,   0.155000D+04,
     .   0.160000D+04,   0.165000D+04,   0.170000D+04,   0.175000D+04,
     .   0.180000D+04,   0.185000D+04,   0.190000D+04,   0.195000D+04,
     .   0.200000D+04,   0.210000D+04,   0.220000D+04,   0.230000D+04,
     .   0.240000D+04,   0.250000D+04,   0.260000D+04,   0.270000D+04,
     .   0.280000D+04,   0.290000D+04,   0.300000D+04,   0.310000D+04,
     .   0.320000D+04,   0.330000D+04,   0.340000D+04,   0.350000D+04,
     .   0.360000D+04,   0.370000D+04,   0.380000D+04,   0.390000D+04/

      DATA ( XX(I),I=321,360)/
     .   0.400000D+04,   0.410000D+04,   0.420000D+04,   0.430000D+04,
     .   0.440000D+04,   0.450000D+04,   0.460000D+04,   0.470000D+04,
     .   0.480000D+04,   0.490000D+04,   0.500000D+04,   0.550000D+04,
     .   0.600000D+04,   0.650000D+04,   0.700000D+04,   0.750000D+04,
     .   0.800000D+04,   0.850000D+04,   0.900000D+04,   0.950000D+04,
     .   0.100000D+05,   0.105000D+05,   0.110000D+05,   0.115000D+05,
     .   0.120000D+05,   0.125000D+05,   0.130000D+05,   0.135000D+05,
     .   0.140000D+05,   0.145000D+05,   0.150000D+05,   0.155000D+05,
     .   0.160000D+05,   0.165000D+05,   0.170000D+05,   0.175000D+05,
     .   0.180000D+05,   0.185000D+05,   0.190000D+05,   0.195000D+05/

      DATA ( XX(I),I=361,400)/
     .   0.200000D+05,   0.210000D+05,   0.220000D+05,   0.230000D+05,
     .   0.240000D+05,   0.250000D+05,   0.260000D+05,   0.270000D+05,
     .   0.280000D+05,   0.290000D+05,   0.300000D+05,   0.310000D+05,
     .   0.320000D+05,   0.330000D+05,   0.340000D+05,   0.350000D+05,
     .   0.360000D+05,   0.370000D+05,   0.380000D+05,   0.390000D+05,
     .   0.400000D+05,   0.410000D+05,   0.420000D+05,   0.430000D+05,
     .   0.440000D+05,   0.450000D+05,   0.460000D+05,   0.470000D+05,
     .   0.480000D+05,   0.490000D+05,   0.500000D+05,   0.550000D+05,
     .   0.600000D+05,   0.650000D+05,   0.700000D+05,   0.750000D+05,
     .   0.800000D+05,   0.850000D+05,   0.900000D+05,   0.950000D+05/

      DATA ( XX(I),I=401,440)/
     .   0.100000D+06,   0.105000D+06,   0.110000D+06,   0.115000D+06,
     .   0.120000D+06,   0.125000D+06,   0.130000D+06,   0.135000D+06,
     .   0.140000D+06,   0.145000D+06,   0.150000D+06,   0.155000D+06,
     .   0.160000D+06,   0.165000D+06,   0.170000D+06,   0.175000D+06,
     .   0.180000D+06,   0.185000D+06,   0.190000D+06,   0.195000D+06,
     .   0.200000D+06,   0.210000D+06,   0.220000D+06,   0.230000D+06,
     .   0.240000D+06,   0.250000D+06,   0.260000D+06,   0.270000D+06,
     .   0.280000D+06,   0.290000D+06,   0.300000D+06,   0.310000D+06,
     .   0.320000D+06,   0.330000D+06,   0.340000D+06,   0.350000D+06,
     .   0.360000D+06,   0.370000D+06,   0.380000D+06,   0.390000D+06/

      DATA ( XX(I),I=441,461)/
     .   0.400000D+06,   0.410000D+06,   0.420000D+06,   0.430000D+06,
     .   0.440000D+06,   0.450000D+06,   0.460000D+06,   0.470000D+06,
     .   0.480000D+06,   0.490000D+06,   0.500000D+06,   0.550000D+06,
     .   0.600000D+06,   0.650000D+06,   0.700000D+06,   0.750000D+06,
     .   0.800000D+06,   0.850000D+06,   0.900000D+06,   0.950000D+06,
     .   0.100000D+07/

C--SCALAR HIGGS

      DATA (YHR(I),I=  1, 40)/
     .   0.153696D+02,   0.153951D+02,   0.154213D+02,   0.154481D+02,
     .   0.154757D+02,   0.155040D+02,   0.155332D+02,   0.155940D+02,
     .   0.156258D+02,   0.156586D+02,   0.156925D+02,   0.157275D+02,
     .   0.157637D+02,   0.158400D+02,   0.158803D+02,   0.159222D+02,
     .   0.159657D+02,   0.160111D+02,   0.160585D+02,   0.161081D+02,
     .   0.161600D+02,   0.162145D+02,   0.162719D+02,   0.163325D+02,
     .   0.163966D+02,   0.164646D+02,   0.165372D+02,   0.166985D+02,
     .   0.167890D+02,   0.168877D+02,   0.169963D+02,   0.171170D+02,
     .   0.172533D+02,   0.174100D+02,   0.175954D+02,   0.178248D+02,
     .   0.181347D+02,   0.181734D+02,   0.182142D+02,   0.182575D+02/

      DATA (YHR(I),I= 41, 80)/
     .   0.183037D+02,   0.183535D+02,   0.184078D+02,   0.184678D+02,
     .   0.185361D+02,   0.186179D+02,   0.187203D+02,   0.187370D+02,
     .   0.187397D+02,   0.187397D+02,   0.187407D+02,   0.187583D+02,
     .   0.188505D+02,   0.189202D+02,   0.189718D+02,   0.190124D+02,
     .   0.190449D+02,   0.190712D+02,   0.190923D+02,   0.191094D+02,
     .   0.191230D+02,   0.191343D+02,   0.191324D+02,   0.190340D+02,
     .   0.188968D+02,   0.187436D+02,   0.185854D+02,   0.184272D+02,
     .   0.182726D+02,   0.181223D+02,   0.179773D+02,   0.178379D+02,
     .   0.177044D+02,   0.175755D+02,   0.174523D+02,   0.173340D+02,
     .   0.172205D+02,   0.171119D+02,   0.170069D+02,   0.169060D+02/

      DATA (YHR(I),I= 81,120)/
     .   0.168092D+02,   0.167155D+02,   0.166296D+02,   0.165386D+02,
     .   0.164551D+02,   0.163742D+02,   0.162951D+02,   0.162194D+02,
     .   0.161458D+02,   0.160745D+02,   0.160057D+02,   0.159387D+02,
     .   0.158736D+02,   0.158106D+02,   0.157493D+02,   0.156897D+02,
     .   0.156310D+02,   0.155753D+02,   0.155202D+02,   0.154678D+02,
     .   0.154148D+02,   0.153639D+02,   0.153141D+02,   0.152655D+02,
     .   0.152188D+02,   0.151723D+02,   0.151270D+02,   0.150829D+02,
     .   0.150399D+02,   0.149983D+02,   0.149571D+02,   0.149162D+02,
     .   0.148769D+02,   0.148380D+02,   0.148001D+02,   0.147630D+02,
     .   0.147268D+02,   0.146917D+02,   0.146564D+02,   0.146222D+02/

      DATA (YHR(I),I=121,160)/
     .   0.145896D+02,   0.144313D+02,   0.142862D+02,   0.141531D+02,
     .   0.140304D+02,   0.139163D+02,   0.138104D+02,   0.137133D+02,
     .   0.136199D+02,   0.135336D+02,   0.134524D+02,   0.133772D+02,
     .   0.133040D+02,   0.132358D+02,   0.131717D+02,   0.131100D+02,
     .   0.130517D+02,   0.129963D+02,   0.129435D+02,   0.128938D+02,
     .   0.128449D+02,   0.127547D+02,   0.126720D+02,   0.125952D+02,
     .   0.125243D+02,   0.124586D+02,   0.123971D+02,   0.123397D+02,
     .   0.122863D+02,   0.122363D+02,   0.121882D+02,   0.121435D+02,
     .   0.121018D+02,   0.120594D+02,   0.120235D+02,   0.119877D+02,
     .   0.119535D+02,   0.119214D+02,   0.118901D+02,   0.118606D+02/

      DATA (YHR(I),I=161,200)/
     .   0.118324D+02,   0.118054D+02,   0.117794D+02,   0.117550D+02,
     .   0.117312D+02,   0.117086D+02,   0.116866D+02,   0.116658D+02,
     .   0.116456D+02,   0.116262D+02,   0.116074D+02,   0.115898D+02,
     .   0.115708D+02,   0.115553D+02,   0.115390D+02,   0.115234D+02,
     .   0.115069D+02,   0.114936D+02,   0.114795D+02,   0.114658D+02,
     .   0.114524D+02,   0.114397D+02,   0.114271D+02,   0.114151D+02,
     .   0.114035D+02,   0.113952D+02,   0.113809D+02,   0.113701D+02,
     .   0.113598D+02,   0.113496D+02,   0.113398D+02,   0.113304D+02,
     .   0.113212D+02,   0.113118D+02,   0.113029D+02,   0.112944D+02,
     .   0.112860D+02,   0.112780D+02,   0.112699D+02,   0.112621D+02/

      DATA (YHR(I),I=201,240)/
     .   0.112545D+02,   0.112473D+02,   0.112401D+02,   0.112333D+02,
     .   0.112262D+02,   0.112198D+02,   0.112129D+02,   0.112068D+02,
     .   0.112006D+02,   0.111946D+02,   0.111880D+02,   0.111824D+02,
     .   0.111771D+02,   0.111715D+02,   0.111657D+02,   0.111610D+02,
     .   0.111555D+02,   0.111508D+02,   0.111457D+02,   0.111411D+02,
     .   0.111356D+02,   0.111142D+02,   0.110943D+02,   0.110760D+02,
     .   0.110602D+02,   0.110450D+02,   0.110321D+02,   0.110202D+02,
     .   0.110092D+02,   0.109992D+02,   0.109884D+02,   0.109818D+02,
     .   0.109735D+02,   0.109674D+02,   0.109598D+02,   0.109557D+02,
     .   0.109502D+02,   0.109457D+02,   0.109417D+02,   0.109376D+02/

      DATA (YHR(I),I=241,280)/
     .   0.109344D+02,   0.109287D+02,   0.109243D+02,   0.109206D+02,
     .   0.109176D+02,   0.109163D+02,   0.109149D+02,   0.109149D+02,
     .   0.109138D+02,   0.109155D+02,   0.109168D+02,   0.109168D+02,
     .   0.109197D+02,   0.109221D+02,   0.109066D+02,   0.109275D+02,
     .   0.109301D+02,   0.109329D+02,   0.109365D+02,   0.109379D+02,
     .   0.109420D+02,   0.109399D+02,   0.109506D+02,   0.109512D+02,
     .   0.109587D+02,   0.109592D+02,   0.109676D+02,   0.109799D+02,
     .   0.109754D+02,   0.109980D+02,   0.109854D+02,   0.110086D+02,
     .   0.110331D+02,   0.110515D+02,   0.110831D+02,   0.111067D+02,
     .   0.111137D+02,   0.111537D+02,   0.111767D+02,   0.111985D+02/

      DATA (YHR(I),I=281,320)/
     .   0.112244D+02,   0.112580D+02,   0.112723D+02,   0.112939D+02,
     .   0.113157D+02,   0.113372D+02,   0.113565D+02,   0.113760D+02,
     .   0.113955D+02,   0.114196D+02,   0.114359D+02,   0.114621D+02,
     .   0.114624D+02,   0.114949D+02,   0.115161D+02,   0.115340D+02,
     .   0.115462D+02,   0.115610D+02,   0.115418D+02,   0.116090D+02,
     .   0.116234D+02,   0.116532D+02,   0.116915D+02,   0.117046D+02,
     .   0.117561D+02,   0.117793D+02,   0.117998D+02,   0.118404D+02,
     .   0.118722D+02,   0.119008D+02,   0.119270D+02,   0.119539D+02,
     .   0.119749D+02,   0.120013D+02,   0.120428D+02,   0.120544D+02,
     .   0.120795D+02,   0.120898D+02,   0.121223D+02,   0.121456D+02/

      DATA (YHR(I),I=321,360)/
     .   0.121634D+02,   0.121898D+02,   0.122172D+02,   0.122386D+02,
     .   0.122635D+02,   0.122877D+02,   0.122954D+02,   0.123050D+02,
     .   0.123233D+02,   0.123454D+02,   0.123801D+02,   0.124654D+02,
     .   0.125601D+02,   0.126519D+02,   0.127199D+02,   0.127902D+02,
     .   0.128598D+02,   0.129767D+02,   0.129954D+02,   0.130571D+02,
     .   0.131151D+02,   0.131736D+02,   0.132275D+02,   0.132820D+02,
     .   0.133335D+02,   0.133835D+02,   0.134319D+02,   0.134789D+02,
     .   0.135246D+02,   0.135691D+02,   0.136124D+02,   0.136546D+02,
     .   0.136957D+02,   0.137359D+02,   0.137751D+02,   0.138134D+02,
     .   0.138510D+02,   0.138876D+02,   0.139235D+02,   0.139586D+02/

      DATA (YHR(I),I=361,400)/
     .   0.139926D+02,   0.140593D+02,   0.141245D+02,   0.141861D+02,
     .   0.142468D+02,   0.143049D+02,   0.143612D+02,   0.144156D+02,
     .   0.144687D+02,   0.145202D+02,   0.145702D+02,   0.146190D+02,
     .   0.146665D+02,   0.147128D+02,   0.147579D+02,   0.148022D+02,
     .   0.148453D+02,   0.148872D+02,   0.149285D+02,   0.149688D+02,
     .   0.150079D+02,   0.150466D+02,   0.150850D+02,   0.151222D+02,
     .   0.151583D+02,   0.151941D+02,   0.152293D+02,   0.152639D+02,
     .   0.152982D+02,   0.153316D+02,   0.153644D+02,   0.155208D+02,
     .   0.156659D+02,   0.158012D+02,   0.159277D+02,   0.160477D+02,
     .   0.161608D+02,   0.162674D+02,   0.163639D+02,   0.164615D+02/

      DATA (YHR(I),I=401,440)/
     .   0.165507D+02,   0.167323D+02,   0.168185D+02,   0.169015D+02,
     .   0.169834D+02,   0.170585D+02,   0.171330D+02,   0.172052D+02,
     .   0.172751D+02,   0.173429D+02,   0.174086D+02,   0.174726D+02,
     .   0.175348D+02,   0.175954D+02,   0.176544D+02,   0.177120D+02,
     .   0.177682D+02,   0.178231D+02,   0.178766D+02,   0.179291D+02,
     .   0.179803D+02,   0.180795D+02,   0.181747D+02,   0.182662D+02,
     .   0.183545D+02,   0.184396D+02,   0.185217D+02,   0.186010D+02,
     .   0.186780D+02,   0.187524D+02,   0.188248D+02,   0.188951D+02,
     .   0.189635D+02,   0.190307D+02,   0.190948D+02,   0.191581D+02,
     .   0.192195D+02,   0.192796D+02,   0.193383D+02,   0.193956D+02/

      DATA (YHR(I),I=441,461)/
     .   0.194517D+02,   0.195066D+02,   0.195604D+02,   0.196129D+02,
     .   0.196644D+02,   0.197149D+02,   0.197643D+02,   0.198131D+02,
     .   0.198606D+02,   0.199076D+02,   0.199535D+02,   0.201718D+02,
     .   0.203734D+02,   0.205605D+02,   0.207353D+02,   0.208990D+02,
     .   0.210539D+02,   0.212002D+02,   0.213389D+02,   0.214705D+02,
     .   0.215521D+02/

      DATA (YHI(I),I=  1, 40)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00/

      DATA (YHI(I),I= 41, 80)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.103828D-03,   0.956232D-03,   0.101108D-01,
     .   0.939720D-01,   0.184324D+00,   0.270111D+00,   0.351237D+00,
     .   0.429877D+00,   0.506050D+00,   0.578718D+00,   0.649415D+00,
     .   0.714251D+00,   0.796202D+00,   0.134408D+01,   0.177540D+01,
     .   0.211827D+01,   0.239741D+01,   0.262849D+01,   0.282209D+01,
     .   0.298629D+01,   0.312731D+01,   0.324839D+01,   0.335408D+01,
     .   0.344691D+01,   0.352697D+01,   0.359781D+01,   0.366071D+01,
     .   0.371635D+01,   0.376661D+01,   0.380990D+01,   0.384872D+01/

      DATA (YHI(I),I= 81,120)/
     .   0.388367D+01,   0.391480D+01,   0.394363D+01,   0.396735D+01,
     .   0.399014D+01,   0.401029D+01,   0.402624D+01,   0.404140D+01,
     .   0.405531D+01,   0.406688D+01,   0.407779D+01,   0.408696D+01,
     .   0.409483D+01,   0.410147D+01,   0.410726D+01,   0.411202D+01,
     .   0.411582D+01,   0.411879D+01,   0.412116D+01,   0.412387D+01,
     .   0.412368D+01,   0.412350D+01,   0.412368D+01,   0.412299D+01,
     .   0.412206D+01,   0.411998D+01,   0.411814D+01,   0.411566D+01,
     .   0.411291D+01,   0.411029D+01,   0.410560D+01,   0.410255D+01,
     .   0.409883D+01,   0.409429D+01,   0.409001D+01,   0.408554D+01,
     .   0.408035D+01,   0.407563D+01,   0.407019D+01,   0.406465D+01/

      DATA (YHI(I),I=121,160)/
     .   0.405809D+01,   0.403029D+01,   0.399830D+01,   0.396483D+01,
     .   0.392962D+01,   0.389474D+01,   0.385889D+01,   0.382350D+01,
     .   0.378746D+01,   0.375179D+01,   0.371653D+01,   0.368151D+01,
     .   0.364692D+01,   0.361317D+01,   0.357941D+01,   0.354669D+01,
     .   0.351403D+01,   0.348225D+01,   0.345082D+01,   0.341898D+01,
     .   0.338976D+01,   0.333067D+01,   0.327372D+01,   0.321880D+01,
     .   0.316576D+01,   0.311447D+01,   0.306456D+01,   0.301680D+01,
     .   0.296973D+01,   0.292531D+01,   0.288199D+01,   0.283993D+01,
     .   0.279879D+01,   0.277387D+01,   0.272029D+01,   0.268286D+01,
     .   0.264630D+01,   0.261076D+01,   0.257609D+01,   0.254231D+01/

      DATA (YHI(I),I=161,200)/
     .   0.250939D+01,   0.247733D+01,   0.244452D+01,   0.241537D+01,
     .   0.238541D+01,   0.235633D+01,   0.232778D+01,   0.229986D+01,
     .   0.227246D+01,   0.224575D+01,   0.221951D+01,   0.219374D+01,
     .   0.216869D+01,   0.214421D+01,   0.211987D+01,   0.209618D+01,
     .   0.206976D+01,   0.204911D+01,   0.202716D+01,   0.200561D+01,
     .   0.198399D+01,   0.196272D+01,   0.194127D+01,   0.192087D+01,
     .   0.190010D+01,   0.189543D+01,   0.186138D+01,   0.184241D+01,
     .   0.182347D+01,   0.180182D+01,   0.178640D+01,   0.176840D+01,
     .   0.175191D+01,   0.173270D+01,   0.171510D+01,   0.169858D+01,
     .   0.168164D+01,   0.166512D+01,   0.164879D+01,   0.163254D+01/

      DATA (YHI(I),I=201,240)/
     .   0.161641D+01,   0.160101D+01,   0.158550D+01,   0.157001D+01,
     .   0.155500D+01,   0.153987D+01,   0.152506D+01,   0.151075D+01,
     .   0.149651D+01,   0.148231D+01,   0.146604D+01,   0.145443D+01,
     .   0.144050D+01,   0.142725D+01,   0.141303D+01,   0.140051D+01,
     .   0.138766D+01,   0.137455D+01,   0.136181D+01,   0.134906D+01,
     .   0.133671D+01,   0.127592D+01,   0.121827D+01,   0.116199D+01,
     .   0.111162D+01,   0.105920D+01,   0.101241D+01,   0.967089D+00,
     .   0.923058D+00,   0.880397D+00,   0.837579D+00,   0.800124D+00,
     .   0.760050D+00,   0.724849D+00,   0.685016D+00,   0.655055D+00,
     .   0.620992D+00,   0.588618D+00,   0.557638D+00,   0.526851D+00/

      DATA (YHI(I),I=241,280)/
     .   0.497112D+00,   0.439665D+00,   0.385464D+00,   0.333219D+00,
     .   0.283249D+00,   0.236711D+00,   0.190893D+00,   0.148375D+00,
     .   0.107641D+00,   0.674164D-01,   0.282429D-01,  -0.118929D-01,
     .  -0.451581D-01,  -0.800718D-01,  -0.106407D+00,  -0.146132D+00,
     .  -0.177594D+00,  -0.209087D+00,  -0.237939D+00,  -0.268054D+00,
     .  -0.297210D+00,  -0.326472D+00,  -0.349928D+00,  -0.374204D+00,
     .  -0.401362D+00,  -0.427556D+00,  -0.449879D+00,  -0.461232D+00,
     .  -0.497959D+00,  -0.465266D+00,  -0.541772D+00,  -0.645032D+00,
     .  -0.739474D+00,  -0.828596D+00,  -0.905896D+00,  -0.978443D+00,
     .  -0.106542D+01,  -0.111143D+01,  -0.117268D+01,  -0.123118D+01/

      DATA (YHI(I),I=281,320)/
     .  -0.128217D+01,  -0.132113D+01,  -0.137951D+01,  -0.142661D+01,
     .  -0.146928D+01,  -0.151264D+01,  -0.155622D+01,  -0.159162D+01,
     .  -0.162531D+01,  -0.166463D+01,  -0.170018D+01,  -0.173385D+01,
     .  -0.176173D+01,  -0.179582D+01,  -0.182630D+01,  -0.185676D+01,
     .  -0.188124D+01,  -0.190601D+01,  -0.198109D+01,  -0.196626D+01,
     .  -0.199073D+01,  -0.204167D+01,  -0.208667D+01,  -0.213625D+01,
     .  -0.217197D+01,  -0.221764D+01,  -0.223929D+01,  -0.229089D+01,
     .  -0.232265D+01,  -0.236000D+01,  -0.239057D+01,  -0.242162D+01,
     .  -0.245804D+01,  -0.249028D+01,  -0.250018D+01,  -0.254592D+01,
     .  -0.257096D+01,  -0.257866D+01,  -0.263340D+01,  -0.265605D+01/

      DATA (YHI(I),I=321,360)/
     .  -0.267627D+01,  -0.270760D+01,  -0.272511D+01,  -0.274800D+01,
     .  -0.276102D+01,  -0.278071D+01,  -0.281972D+01,  -0.284543D+01,
     .  -0.283352D+01,  -0.287545D+01,  -0.289426D+01,  -0.298833D+01,
     .  -0.307003D+01,  -0.315041D+01,  -0.321780D+01,  -0.329049D+01,
     .  -0.335487D+01,  -0.336054D+01,  -0.345719D+01,  -0.350846D+01,
     .  -0.355815D+01,  -0.360314D+01,  -0.364808D+01,  -0.368901D+01,
     .  -0.372910D+01,  -0.376751D+01,  -0.380438D+01,  -0.383982D+01,
     .  -0.387395D+01,  -0.390684D+01,  -0.393860D+01,  -0.396929D+01,
     .  -0.399898D+01,  -0.402773D+01,  -0.405561D+01,  -0.408269D+01,
     .  -0.410905D+01,  -0.413447D+01,  -0.415930D+01,  -0.418350D+01/

      DATA (YHI(I),I=361,400)/
     .  -0.420826D+01,  -0.425293D+01,  -0.429561D+01,  -0.433733D+01,
     .  -0.437631D+01,  -0.441412D+01,  -0.445041D+01,  -0.448520D+01,
     .  -0.451893D+01,  -0.455133D+01,  -0.458262D+01,  -0.461287D+01,
     .  -0.464213D+01,  -0.467047D+01,  -0.469796D+01,  -0.472493D+01,
     .  -0.475084D+01,  -0.477576D+01,  -0.480023D+01,  -0.482410D+01,
     .  -0.484762D+01,  -0.487028D+01,  -0.489210D+01,  -0.491368D+01,
     .  -0.493501D+01,  -0.495558D+01,  -0.497571D+01,  -0.499540D+01,
     .  -0.501444D+01,  -0.503331D+01,  -0.505178D+01,  -0.513888D+01,
     .  -0.521829D+01,  -0.529127D+01,  -0.535898D+01,  -0.542150D+01,
     .  -0.548015D+01,  -0.553562D+01,  -0.557842D+01,  -0.562670D+01/

      DATA (YHI(I),I=401,440)/
     .  -0.568872D+01,  -0.559614D+01,  -0.563704D+01,  -0.567617D+01,
     .  -0.571222D+01,  -0.574924D+01,  -0.578356D+01,  -0.581671D+01,
     .  -0.584856D+01,  -0.587928D+01,  -0.590900D+01,  -0.593768D+01,
     .  -0.596543D+01,  -0.599231D+01,  -0.601838D+01,  -0.604366D+01,
     .  -0.606824D+01,  -0.609212D+01,  -0.611541D+01,  -0.613797D+01,
     .  -0.616005D+01,  -0.620252D+01,  -0.624308D+01,  -0.628174D+01,
     .  -0.631872D+01,  -0.635416D+01,  -0.638823D+01,  -0.642105D+01,
     .  -0.645264D+01,  -0.648309D+01,  -0.651248D+01,  -0.654093D+01,
     .  -0.656842D+01,  -0.659469D+01,  -0.662087D+01,  -0.664591D+01,
     .  -0.667035D+01,  -0.669401D+01,  -0.671705D+01,  -0.673959D+01/

      DATA (YHI(I),I=441,461)/
     .  -0.676149D+01,  -0.678273D+01,  -0.680348D+01,  -0.682388D+01,
     .  -0.684370D+01,  -0.686313D+01,  -0.688203D+01,  -0.690059D+01,
     .  -0.691884D+01,  -0.693653D+01,  -0.695399D+01,  -0.703614D+01,
     .  -0.711101D+01,  -0.717985D+01,  -0.724357D+01,  -0.730302D+01,
     .  -0.735815D+01,  -0.741018D+01,  -0.745916D+01,  -0.750572D+01,
     .  -0.745858D+01/

C--PSEUDOSCALAR HIGGS

      DATA (YAR(I),I=  1, 40)/
     .   0.158696D+02,   0.159218D+02,   0.159757D+02,   0.160313D+02,
     .   0.160889D+02,   0.161484D+02,   0.162101D+02,   0.163404D+02,
     .   0.164093D+02,   0.164810D+02,   0.165557D+02,   0.166336D+02,
     .   0.167149D+02,   0.168892D+02,   0.169828D+02,   0.170812D+02,
     .   0.171849D+02,   0.172945D+02,   0.174105D+02,   0.175337D+02,
     .   0.176649D+02,   0.178052D+02,   0.179556D+02,   0.181177D+02,
     .   0.182931D+02,   0.184841D+02,   0.186933D+02,   0.191811D+02,
     .   0.194701D+02,   0.197993D+02,   0.201803D+02,   0.206303D+02,
     .   0.211768D+02,   0.218661D+02,   0.227879D+02,   0.241489D+02,
     .   0.266372D+02,   0.270326D+02,   0.274797D+02,   0.279932D+02/

      DATA (YAR(I),I= 41, 80)/
     .   0.285944D+02,   0.293168D+02,   0.302174D+02,   0.314040D+02,
     .   0.331227D+02,   0.361754D+02,   0.471154D+02,   0.588099D+02,
     .   0.708533D+02,   0.707389D+02,   0.585302D+02,   0.464786D+02,
     .   0.348948D+02,   0.316033D+02,   0.297432D+02,   0.284583D+02,
     .   0.274838D+02,   0.267031D+02,   0.260544D+02,   0.255016D+02,
     .   0.250204D+02,   0.246005D+02,   0.219522D+02,   0.205297D+02,
     .   0.195777D+02,   0.188719D+02,   0.183157D+02,   0.178589D+02,
     .   0.174734D+02,   0.171409D+02,   0.168488D+02,   0.165893D+02,
     .   0.163566D+02,   0.161441D+02,   0.159504D+02,   0.157722D+02,
     .   0.156075D+02,   0.154550D+02,   0.153114D+02,   0.151770D+02/

      DATA (YAR(I),I= 81,120)/
     .   0.150511D+02,   0.149318D+02,   0.148239D+02,   0.147125D+02,
     .   0.146119D+02,   0.145157D+02,   0.144222D+02,   0.143341D+02,
     .   0.142498D+02,   0.141686D+02,   0.140915D+02,   0.140168D+02,
     .   0.139450D+02,   0.138759D+02,   0.138093D+02,   0.137450D+02,
     .   0.136821D+02,   0.136227D+02,   0.135645D+02,   0.135097D+02,
     .   0.134537D+02,   0.134006D+02,   0.133491D+02,   0.132990D+02,
     .   0.132512D+02,   0.132035D+02,   0.131574D+02,   0.131127D+02,
     .   0.130693D+02,   0.130276D+02,   0.129858D+02,   0.129452D+02,
     .   0.129061D+02,   0.128673D+02,   0.128298D+02,   0.127932D+02,
     .   0.127575D+02,   0.127231D+02,   0.126885D+02,   0.126549D+02/

      DATA (YAR(I),I=121,160)/
     .   0.126228D+02,   0.124702D+02,   0.123310D+02,   0.122046D+02,
     .   0.120888D+02,   0.119821D+02,   0.118836D+02,   0.117940D+02,
     .   0.117078D+02,   0.116289D+02,   0.115548D+02,   0.114866D+02,
     .   0.114202D+02,   0.113588D+02,   0.113012D+02,   0.112460D+02,
     .   0.111939D+02,   0.111446D+02,   0.110977D+02,   0.110535D+02,
     .   0.110105D+02,   0.109311D+02,   0.108587D+02,   0.107917D+02,
     .   0.107301D+02,   0.106732D+02,   0.106200D+02,   0.105707D+02,
     .   0.105248D+02,   0.104822D+02,   0.104412D+02,   0.104033D+02,
     .   0.103679D+02,   0.103349D+02,   0.103018D+02,   0.102717D+02,
     .   0.102430D+02,   0.102162D+02,   0.101901D+02,   0.101656D+02/

      DATA (YAR(I),I=161,200)/
     .   0.101421D+02,   0.101198D+02,   0.100980D+02,   0.100782D+02,
     .   0.100586D+02,   0.100400D+02,   0.100220D+02,   0.100050D+02,
     .   0.998850D+01,   0.997274D+01,   0.995747D+01,   0.994323D+01,
     .   0.992769D+01,   0.991542D+01,   0.990228D+01,   0.988978D+01,
     .   0.987587D+01,   0.986571D+01,   0.985459D+01,   0.984378D+01,
     .   0.983305D+01,   0.982301D+01,   0.981293D+01,   0.980350D+01,
     .   0.979431D+01,   0.979050D+01,   0.977668D+01,   0.976826D+01,
     .   0.976025D+01,   0.975183D+01,   0.974468D+01,   0.973745D+01,
     .   0.973054D+01,   0.972299D+01,   0.971611D+01,   0.970967D+01,
     .   0.970319D+01,   0.969712D+01,   0.969095D+01,   0.968504D+01/

      DATA (YAR(I),I=201,240)/
     .   0.967920D+01,   0.967386D+01,   0.966839D+01,   0.966325D+01,
     .   0.965788D+01,   0.965311D+01,   0.964786D+01,   0.964339D+01,
     .   0.963882D+01,   0.963439D+01,   0.962914D+01,   0.962534D+01,
     .   0.962147D+01,   0.961741D+01,   0.961292D+01,   0.960977D+01,
     .   0.960566D+01,   0.960235D+01,   0.959864D+01,   0.959531D+01,
     .   0.959126D+01,   0.957614D+01,   0.956225D+01,   0.954937D+01,
     .   0.953906D+01,   0.952858D+01,   0.952050D+01,   0.951315D+01,
     .   0.950643D+01,   0.950040D+01,   0.949334D+01,   0.949056D+01,
     .   0.948552D+01,   0.948295D+01,   0.947822D+01,   0.947754D+01,
     .   0.947505D+01,   0.947339D+01,   0.947215D+01,   0.947070D+01/

      DATA (YAR(I),I=241,280)/
     .   0.947004D+01,   0.946916D+01,   0.946931D+01,   0.946985D+01,
     .   0.947087D+01,   0.947338D+01,   0.947562D+01,   0.947907D+01,
     .   0.948136D+01,   0.948608D+01,   0.949024D+01,   0.949289D+01,
     .   0.949865D+01,   0.950358D+01,   0.949215D+01,   0.951384D+01,
     .   0.951877D+01,   0.952380D+01,   0.952957D+01,   0.953303D+01,
     .   0.953905D+01,   0.953903D+01,   0.955148D+01,   0.955415D+01,
     .   0.956308D+01,   0.956538D+01,   0.957536D+01,   0.958962D+01,
     .   0.958620D+01,   0.961314D+01,   0.959921D+01,   0.962927D+01,
     .   0.965978D+01,   0.968376D+01,   0.972000D+01,   0.974814D+01,
     .   0.975908D+01,   0.980308D+01,   0.982954D+01,   0.985456D+01/

      DATA (YAR(I),I=281,320)/
     .   0.988358D+01,   0.992011D+01,   0.993698D+01,   0.996114D+01,
     .   0.998536D+01,   0.100091D+02,   0.100306D+02,   0.100523D+02,
     .   0.100740D+02,   0.100997D+02,   0.101179D+02,   0.101456D+02,
     .   0.101485D+02,   0.101819D+02,   0.102045D+02,   0.102239D+02,
     .   0.102380D+02,   0.102544D+02,   0.102361D+02,   0.103043D+02,
     .   0.103200D+02,   0.103524D+02,   0.103928D+02,   0.104086D+02,
     .   0.104615D+02,   0.104868D+02,   0.105102D+02,   0.105516D+02,
     .   0.105851D+02,   0.106152D+02,   0.106431D+02,   0.106715D+02,
     .   0.106940D+02,   0.107216D+02,   0.107645D+02,   0.107773D+02,
     .   0.108038D+02,   0.108165D+02,   0.108488D+02,   0.108733D+02/

      DATA (YAR(I),I=321,360)/
     .   0.108925D+02,   0.109196D+02,   0.109480D+02,   0.109705D+02,
     .   0.109964D+02,   0.110216D+02,   0.110301D+02,   0.110409D+02,
     .   0.110612D+02,   0.110834D+02,   0.111183D+02,   0.112078D+02,
     .   0.113058D+02,   0.114004D+02,   0.114719D+02,   0.115449D+02,
     .   0.116169D+02,   0.117359D+02,   0.117572D+02,   0.118210D+02,
     .   0.118809D+02,   0.119413D+02,   0.119969D+02,   0.120531D+02,
     .   0.121062D+02,   0.121576D+02,   0.122075D+02,   0.122559D+02,
     .   0.123029D+02,   0.123486D+02,   0.123931D+02,   0.124365D+02,
     .   0.124788D+02,   0.125200D+02,   0.125603D+02,   0.125997D+02,
     .   0.126382D+02,   0.126758D+02,   0.127126D+02,   0.127487D+02/

      DATA (YAR(I),I=361,400)/
     .   0.127835D+02,   0.128519D+02,   0.129187D+02,   0.129818D+02,
     .   0.130440D+02,   0.131034D+02,   0.131611D+02,   0.132168D+02,
     .   0.132711D+02,   0.133237D+02,   0.133749D+02,   0.134247D+02,
     .   0.134733D+02,   0.135206D+02,   0.135667D+02,   0.136120D+02,
     .   0.136560D+02,   0.136988D+02,   0.137409D+02,   0.137821D+02,
     .   0.138220D+02,   0.138615D+02,   0.139006D+02,   0.139386D+02,
     .   0.139755D+02,   0.140120D+02,   0.140479D+02,   0.140832D+02,
     .   0.141181D+02,   0.141522D+02,   0.141856D+02,   0.143451D+02,
     .   0.144928D+02,   0.146306D+02,   0.147594D+02,   0.148815D+02,
     .   0.149965D+02,   0.151050D+02,   0.152034D+02,   0.153027D+02/

      DATA (YAR(I),I=401,440)/
     .   0.153933D+02,   0.155761D+02,   0.156636D+02,   0.157479D+02,
     .   0.158311D+02,   0.159074D+02,   0.159830D+02,   0.160563D+02,
     .   0.161272D+02,   0.161960D+02,   0.162627D+02,   0.163276D+02,
     .   0.163908D+02,   0.164522D+02,   0.165121D+02,   0.165705D+02,
     .   0.166275D+02,   0.166831D+02,   0.167374D+02,   0.167906D+02,
     .   0.168425D+02,   0.169431D+02,   0.170396D+02,   0.171323D+02,
     .   0.172218D+02,   0.173080D+02,   0.173912D+02,   0.174716D+02,
     .   0.175495D+02,   0.176249D+02,   0.176982D+02,   0.177694D+02,
     .   0.178386D+02,   0.179066D+02,   0.179716D+02,   0.180356D+02,
     .   0.180978D+02,   0.181586D+02,   0.182180D+02,   0.182760D+02/

      DATA (YAR(I),I=441,461)/
     .   0.183327D+02,   0.183883D+02,   0.184427D+02,   0.184958D+02,
     .   0.185480D+02,   0.185990D+02,   0.186490D+02,   0.186984D+02,
     .   0.187464D+02,   0.187940D+02,   0.188404D+02,   0.190612D+02,
     .   0.192650D+02,   0.194542D+02,   0.196309D+02,   0.197963D+02,
     .   0.199529D+02,   0.201007D+02,   0.202408D+02,   0.203737D+02,
     .   0.204582D+02/

      DATA (YAI(I),I=  1, 40)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00/

      DATA (YAI(I),I= 41, 80)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.165937D+02,   0.163500D+02,   0.157866D+02,
     .   0.144564D+02,   0.138551D+02,   0.134457D+02,   0.131284D+02,
     .   0.128686D+02,   0.126478D+02,   0.124541D+02,   0.122825D+02,
     .   0.121239D+02,   0.120015D+02,   0.110083D+02,   0.104071D+02,
     .   0.997378D+01,   0.963668D+01,   0.936151D+01,   0.912931D+01,
     .   0.892868D+01,   0.875285D+01,   0.859548D+01,   0.845409D+01,
     .   0.832571D+01,   0.820668D+01,   0.809683D+01,   0.799502D+01,
     .   0.789966D+01,   0.781088D+01,   0.772581D+01,   0.764562D+01/

      DATA (YAI(I),I= 81,120)/
     .   0.756969D+01,   0.749755D+01,   0.742783D+01,   0.736254D+01,
     .   0.729977D+01,   0.723938D+01,   0.717960D+01,   0.712279D+01,
     .   0.706858D+01,   0.701550D+01,   0.696474D+01,   0.691534D+01,
     .   0.686729D+01,   0.682052D+01,   0.677522D+01,   0.673111D+01,
     .   0.668834D+01,   0.664607D+01,   0.660531D+01,   0.656609D+01,
     .   0.652629D+01,   0.648770D+01,   0.645091D+01,   0.641455D+01,
     .   0.637888D+01,   0.634364D+01,   0.630966D+01,   0.627602D+01,
     .   0.624308D+01,   0.621104D+01,   0.617807D+01,   0.614776D+01,
     .   0.611735D+01,   0.608704D+01,   0.605769D+01,   0.602882D+01,
     .   0.599987D+01,   0.597188D+01,   0.594413D+01,   0.591675D+01/

      DATA (YAI(I),I=121,160)/
     .   0.588861D+01,   0.576174D+01,   0.564238D+01,   0.553080D+01,
     .   0.542532D+01,   0.532697D+01,   0.523331D+01,   0.514452D+01,
     .   0.506028D+01,   0.497973D+01,   0.490296D+01,   0.482902D+01,
     .   0.475882D+01,   0.469147D+01,   0.462614D+01,   0.456397D+01,
     .   0.450352D+01,   0.444551D+01,   0.438929D+01,   0.433384D+01,
     .   0.428252D+01,   0.418219D+01,   0.408778D+01,   0.399882D+01,
     .   0.391452D+01,   0.383443D+01,   0.375801D+01,   0.368564D+01,
     .   0.361564D+01,   0.354975D+01,   0.348659D+01,   0.342580D+01,
     .   0.336699D+01,   0.332507D+01,   0.325638D+01,   0.320415D+01,
     .   0.315361D+01,   0.310472D+01,   0.305750D+01,   0.301171D+01/

      DATA (YAI(I),I=161,200)/
     .   0.296736D+01,   0.292438D+01,   0.288128D+01,   0.284202D+01,
     .   0.280253D+01,   0.276428D+01,   0.272697D+01,   0.269060D+01,
     .   0.265510D+01,   0.262059D+01,   0.258685D+01,   0.255379D+01,
     .   0.252201D+01,   0.249057D+01,   0.245974D+01,   0.242976D+01,
     .   0.239767D+01,   0.237078D+01,   0.234308D+01,   0.231598D+01,
     .   0.228903D+01,   0.226254D+01,   0.223611D+01,   0.221079D+01,
     .   0.218528D+01,   0.217457D+01,   0.213741D+01,   0.211406D+01,
     .   0.209085D+01,   0.206526D+01,   0.204560D+01,   0.202363D+01,
     .   0.200323D+01,   0.198041D+01,   0.195919D+01,   0.193906D+01,
     .   0.191866D+01,   0.189872D+01,   0.187909D+01,   0.185960D+01/

      DATA (YAI(I),I=201,240)/
     .   0.184034D+01,   0.182179D+01,   0.180327D+01,   0.178480D+01,
     .   0.176692D+01,   0.174894D+01,   0.173140D+01,   0.171433D+01,
     .   0.169740D+01,   0.168058D+01,   0.166198D+01,   0.164770D+01,
     .   0.163128D+01,   0.161560D+01,   0.159913D+01,   0.158416D+01,
     .   0.156907D+01,   0.155369D+01,   0.153877D+01,   0.152384D+01,
     .   0.150946D+01,   0.143855D+01,   0.137167D+01,   0.130702D+01,
     .   0.124860D+01,   0.118908D+01,   0.113536D+01,   0.108362D+01,
     .   0.103362D+01,   0.985383D+00,   0.937598D+00,   0.894882D+00,
     .   0.850328D+00,   0.810513D+00,   0.766864D+00,   0.732489D+00,
     .   0.694695D+00,   0.658687D+00,   0.624212D+00,   0.590172D+00/

      DATA (YAI(I),I=241,280)/
     .   0.557265D+00,   0.493928D+00,   0.434282D+00,   0.377078D+00,
     .   0.322540D+00,   0.271614D+00,   0.221836D+00,   0.175480D+00,
     .   0.131278D+00,   0.876669D-01,   0.453968D-01,   0.260449D-02,
     .  -0.336707D-01,  -0.712215D-01,  -0.990712D-01,  -0.142171D+00,
     .  -0.175867D+00,  -0.209440D+00,  -0.240408D+00,  -0.272259D+00,
     .  -0.303267D+00,  -0.333794D+00,  -0.359626D+00,  -0.385394D+00,
     .  -0.414272D+00,  -0.441650D+00,  -0.465815D+00,  -0.479750D+00,
     .  -0.516504D+00,  -0.489225D+00,  -0.562987D+00,  -0.671934D+00,
     .  -0.771217D+00,  -0.863988D+00,  -0.945448D+00,  -0.102119D+01,
     .  -0.110912D+01,  -0.115945D+01,  -0.122290D+01,  -0.128329D+01/

      DATA (YAI(I),I=281,320)/
     .  -0.133643D+01,  -0.137823D+01,  -0.143730D+01,  -0.148579D+01,
     .  -0.152986D+01,  -0.157442D+01,  -0.161894D+01,  -0.165551D+01,
     .  -0.169033D+01,  -0.173063D+01,  -0.176688D+01,  -0.180168D+01,
     .  -0.182969D+01,  -0.186502D+01,  -0.189631D+01,  -0.192737D+01,
     .  -0.195241D+01,  -0.197778D+01,  -0.204980D+01,  -0.203940D+01,
     .  -0.206432D+01,  -0.211600D+01,  -0.216219D+01,  -0.221162D+01,
     .  -0.224919D+01,  -0.229508D+01,  -0.231773D+01,  -0.236981D+01,
     .  -0.240243D+01,  -0.244023D+01,  -0.247137D+01,  -0.250295D+01,
     .  -0.253941D+01,  -0.257200D+01,  -0.258363D+01,  -0.262860D+01,
     .  -0.265411D+01,  -0.266241D+01,  -0.271666D+01,  -0.273973D+01/

      DATA (YAI(I),I=321,360)/
     .  -0.276024D+01,  -0.279169D+01,  -0.280986D+01,  -0.283299D+01,
     .  -0.284671D+01,  -0.286681D+01,  -0.290494D+01,  -0.293034D+01,
     .  -0.291978D+01,  -0.296114D+01,  -0.298064D+01,  -0.307517D+01,
     .  -0.315780D+01,  -0.323886D+01,  -0.330652D+01,  -0.337925D+01,
     .  -0.344382D+01,  -0.345290D+01,  -0.354709D+01,  -0.359855D+01,
     .  -0.364834D+01,  -0.369356D+01,  -0.373855D+01,  -0.377965D+01,
     .  -0.381984D+01,  -0.385833D+01,  -0.389527D+01,  -0.393078D+01,
     .  -0.396496D+01,  -0.399789D+01,  -0.402968D+01,  -0.406040D+01,
     .  -0.409012D+01,  -0.411890D+01,  -0.414679D+01,  -0.417388D+01,
     .  -0.420024D+01,  -0.422567D+01,  -0.425051D+01,  -0.427470D+01/

      DATA (YAI(I),I=361,400)/
     .  -0.429941D+01,  -0.434408D+01,  -0.438677D+01,  -0.442843D+01,
     .  -0.446740D+01,  -0.450518D+01,  -0.454143D+01,  -0.457618D+01,
     .  -0.460985D+01,  -0.464221D+01,  -0.467345D+01,  -0.470364D+01,
     .  -0.473285D+01,  -0.476113D+01,  -0.478857D+01,  -0.481548D+01,
     .  -0.484133D+01,  -0.486619D+01,  -0.489061D+01,  -0.491441D+01,
     .  -0.493787D+01,  -0.496046D+01,  -0.498224D+01,  -0.500376D+01,
     .  -0.502502D+01,  -0.504554D+01,  -0.506562D+01,  -0.508524D+01,
     .  -0.510424D+01,  -0.512305D+01,  -0.514147D+01,  -0.522829D+01,
     .  -0.530743D+01,  -0.538015D+01,  -0.544760D+01,  -0.550989D+01,
     .  -0.556831D+01,  -0.562354D+01,  -0.566626D+01,  -0.571436D+01/

      DATA (YAI(I),I=401,440)/
     .  -0.577575D+01,  -0.568757D+01,  -0.572828D+01,  -0.576723D+01,
     .  -0.580316D+01,  -0.583996D+01,  -0.587412D+01,  -0.590711D+01,
     .  -0.593880D+01,  -0.596937D+01,  -0.599895D+01,  -0.602748D+01,
     .  -0.605510D+01,  -0.608184D+01,  -0.610778D+01,  -0.613293D+01,
     .  -0.615739D+01,  -0.618116D+01,  -0.620432D+01,  -0.622676D+01,
     .  -0.624873D+01,  -0.629098D+01,  -0.633132D+01,  -0.636978D+01,
     .  -0.640656D+01,  -0.644182D+01,  -0.647570D+01,  -0.650834D+01,
     .  -0.653976D+01,  -0.657004D+01,  -0.659927D+01,  -0.662757D+01,
     .  -0.665490D+01,  -0.668104D+01,  -0.670706D+01,  -0.673197D+01,
     .  -0.675626D+01,  -0.677979D+01,  -0.680271D+01,  -0.682511D+01/

      DATA (YAI(I),I=441,461)/
     .  -0.684689D+01,  -0.686801D+01,  -0.688865D+01,  -0.690893D+01,
     .  -0.692863D+01,  -0.694795D+01,  -0.696675D+01,  -0.698520D+01,
     .  -0.700334D+01,  -0.702094D+01,  -0.703829D+01,  -0.711997D+01,
     .  -0.719440D+01,  -0.726284D+01,  -0.732619D+01,  -0.738528D+01,
     .  -0.744009D+01,  -0.749182D+01,  -0.754051D+01,  -0.758679D+01,
     .  -0.754063D+01/

      END


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC


      COMPLEX*16 FUNCTION CKOF(RHO)
C--COMPLEX COEFFICIENT OF VIRTUAL CORRECTIONS
C--RHO = (MH/MQ)**2
      PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=341)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      DIMENSION XC(NN),YCR(NN),YCI(NN)
      COMMON/RESINT/XX(NN),YHR(NN),YHI(NN),YAR(NN),YAI(NN)
      COMMON/HIGGS/IHIGGS
      COMMON/CUT/EPST,EPSV,REPS
      PI=4.D0*DATAN(1.D0)
      RHO2=XX(NCUT3)
      RHEP=1.D-15
 
C--CALCULATE COMPLEX COEFFICIENT BY INTERPOLATION
      IF(IHIGGS.EQ.1)THEN
C--PSEUDOSCALAR HIGGS
       RHO0=XX(NCUT1)
       RHO1=XX(NCUT2)
       IF(RHO.LE.RHO0.OR.RHO.GE.RHO1)THEN
        IF(RHO.LE.RHO2)THEN
         CKOF=DCMPLX(FINT1(RHO,XX,YAR,N),FINT1(RHO,XX,YAI,N))
        ELSE
         CRHO=RHO2/DCMPLX(1.D0,-RHEP)
         CDLR=CDLOG(-CRHO)
         CLIM=5.D0/36.D0*CDLR**2-4.D0/3.D0*CDLR
         CONST=DCMPLX(YAR(NCUT3),YAI(NCUT3))-CLIM
         CRHO=RHO/DCMPLX(1.D0,-REPS)
         CDLR=CDLOG(-CRHO)
         CLIM=5.D0/36.D0*CDLR**2-4.D0/3.D0*CDLR
         CKOF=CLIM+CONST
        ENDIF
       ELSEIF(RHO.LT.4.D0.AND.RHO.GT.RHO0)THEN
        TAU=4.D0/RHO0
        CONST=DCMPLX(YAR(NCUT1)+16.D0/3.D0*DLOG((TAU-1.D0)/TAU),
     .               YAI(NCUT1))
        CTAU=DCMPLX(4.D0/RHO,0.D0)
        CKOF=-16.D0/3.D0*CDLOG((CTAU-1.D0)/CTAU)+CONST
       ELSEIF(RHO.GT.4.D0.AND.RHO.LT.RHO1)THEN
        TAU=4.D0/RHO1
        BETA=DSQRT(1.D0-TAU)
        CCFF0=DCMPLX(1.D0,4.D0/PI*BETA)
        CLIM=-16.D0/3.D0*DCMPLX(DLOG((1.D0-TAU)/TAU),-PI)/CCFF0
        CONST=DCMPLX(YAR(NCUT2),YAI(NCUT2))-CLIM
        TAU=4.D0/RHO
        BETA=DSQRT(1.D0-TAU)
        CCFF0=DCMPLX(1.D0,4.D0/PI*BETA)
        CLIM=-16.D0/3.D0*DCMPLX(DLOG((1.D0-TAU)/TAU),-PI)/CCFF0
        CKOF=CLIM+CONST
       ELSEIF(RHO.EQ.4.D0)THEN
        CKOF=DCMPLX(1.D5,16.D0/3.D0*PI)
       ENDIF
      ELSE
C--SCALAR HIGGS
       IF(RHO.LE.RHO2)THEN
        CKOF=DCMPLX(FINT1(RHO,XX,YHR,N),FINT1(RHO,XX,YHI,N))
       ELSE
        CRHO=RHO2/DCMPLX(1.D0,-RHEP)
        CDLR=CDLOG(-CRHO)
        CLIM=5.D0/36.D0*CDLR**2-4.D0/3.D0*CDLR
        CONST=DCMPLX(YHR(NCUT3),YHI(NCUT3))-CLIM
        CRHO=RHO/DCMPLX(1.D0,-REPS)
        CDLR=CDLOG(-CRHO)
        CLIM=5.D0/36.D0*CDLR**2-4.D0/3.D0*CDLR
        CKOF=CLIM+CONST
       ENDIF
      ENDIF
C--SUBTRACT UNIVERSAL PI**2-TERM
      CKOF=CKOF-DCMPLX(PI**2,0.D0)
      RETURN
      END
 

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      DOUBLE PRECISION FUNCTION FINT1(X,XP,YP,NP)
C--ONE-DIMENSIONAL QUADRATIC INTERPOLATION
C--X  = WANTED POINT
C--XP = ARRAY OF DISCRETE X-VALUES
C--YP = ARRAY OF DISCRETE FUNCTION-VALUES
C--NP = NUMBER OF DISCTRETE POINTS
      PARAMETER(N0=999,N1=3)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XP(N0),YP(N0),X0(N1),Y0(N1),XX(N1),YY(N1)
      DO 1 I=1,NP
       IF(X.GE.XP(I)) NX=I
1     CONTINUE
      IF(NX.EQ.NP)NX=NP-1
      IF(NX.EQ.1)NX=2
      DO 2 I=1,3
        X0(I)=XP(NX+I-2)
2     CONTINUE
      DO 3 I=1,3
        Y0(I)=YP(NX+I-2)
3     CONTINUE
      FINT1=FINT(X,X0,Y0)
      RETURN
      END

      DOUBLE PRECISION FUNCTION FINT2(X,XP,YP,NP)
C--TWO-DIMENSIONAL QUADRATIC INTERPOLATION
C--X  = WANTED POINT
C--XP = ARRAY OF DISCRETE X-VALUES
C--YP = ARRAY OF DISCRETE FUNCTION-VALUES
C--NP = NUMBER OF DISCTRETE POINTS
      PARAMETER(N0=500,NN=10,N1=2,N2=3)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(N1),XP(N0,N1),YP(N0,NN),NP(N1),NX(N1),X0(N2),
     .          Y0(N2),XX(N2,N1),YY(N2,N2)
      DO 1 I=1,2
       DO 1 J=1,NP(I)
        IF(X(I).GE.XP(J,I)) NX(I)=J
1     CONTINUE
      DO 2 I=1,2
       IF(NX(I).EQ.NP(I))NX(I)=NP(I)-1
       IF(NX(I).EQ.1)NX(I)=2
2     CONTINUE
      DO 3 I=1,3
       DO 3 J=1,2
        XX(I,J)=XP(NX(J)+I-2,J)
3     CONTINUE
      DO 4 I=1,3
       DO 4 J=1,3
        YY(I,J)=YP(NX(1)+I-2,NX(2)+J-2)
4     CONTINUE
      XF=X(1)
      X0(1)=XX(1,1)
      X0(2)=XX(2,1)
      X0(3)=XX(3,1)
      Y0(1)=YY(1,1)
      Y0(2)=YY(2,1)
      Y0(3)=YY(3,1)
      F0=FINT(XF,X0,Y0)
      Y0(1)=YY(1,2)
      Y0(2)=YY(2,2)
      Y0(3)=YY(3,2)
      F1=FINT(XF,X0,Y0)
      Y0(1)=YY(1,3)
      Y0(2)=YY(2,3)
      Y0(3)=YY(3,3)
      F2=FINT(XF,X0,Y0)
      XF=X(2)
      X0(1)=XX(1,2)
      X0(2)=XX(2,2)
      X0(3)=XX(3,2)
      Y0(1)=F0
      Y0(2)=F1
      Y0(3)=F2
      FINT2=FINT(XF,X0,Y0)
      RETURN
      END

      DOUBLE PRECISION FUNCTION FINT(X,XX,YY)
C--ONE-DIMENSIONAL QUADRATIC INTERPOLATION
C--X  = WANTED POINT
C--XX = ARRAY OF 3 DISCRETE X-VALUES AROUND X
C--YY = ARRAY OF 3 DISCRETE FUNCTION-VALUES AROUND X
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XX(3),YY(3)
      COMMON/INTPOL/KORD
      X0=XX(1)
      X1=XX(2)
      X2=XX(3)
      Y0=YY(1)
      Y1=YY(2)
      Y2=YY(3)
      D1F=(Y1-Y0)/(X1-X0)
      D2F=(Y2-Y1)/(X2-X1)
      IF(X.LT.X1)THEN
        DX=X-X0
        DF=D1F
      ELSE
        DX=X-X1
        DF=D2F
      ENDIF
      GINT=Y1+DF*DX
      IF(KORD.EQ.2) THEN
       A0=(X-X1)*(X-X2)/(X0-X1)/(X0-X2)
       A1=(X-X0)*(X-X2)/(X1-X0)/(X1-X2)
       A2=(X-X0)*(X-X1)/(X2-X0)/(X2-X1)
       GINT=A0*Y0+A1*Y1+A2*Y2
      ENDIF
      FINT=GINT
      RETURN
      END

      COMPLEX*16 FUNCTION CFBORN(AMH,AMQ)
C--LOWEST ORDER FORM FACTOR FOR SCALAR HIGGS
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      COMMON/CUT/EPST,EPSV,REPS
      CTAU=4.D0*AMQ**2/AMH**2*DCMPLX(1.D0,-REPS)
      CFBORN=1.5D0*CTAU*(1.D0+(1.D0-CTAU)*CF(CTAU))
      RETURN
      END

      COMPLEX*16 FUNCTION CF(CTAU)
C--SCALAR INTEGRAL
      IMPLICIT COMPLEX*16 (C)
      CETA=CDSQRT(1.D0-CTAU)
      CALP=1.D0+CETA
      CALM=CTAU/CALP
      CF=-CDLOG(-CALP/CALM)**2/4.D0
      RETURN
      END




 
