      subroutine bookplot(n,tag,titlex,var,wt,xmin,xmax,dx,llplot) 
      implicit none
      include 'nplot.f'
      integer n
      character*(*) titlex
      character*3 llplot
      character*4 tag,mypart
      double precision var,wt,xmin,xmax,dx
      common/mypart/mypart

      if (tag.eq.'book') then
          call mbook(n,titlex,dx,xmin,xmax)
          call mbook(20+n,titlex,dx,xmin,xmax)
          call mbook(40+n,titlex,dx,xmin,xmax)
          call mbook(60+n,titlex,dx,xmin,xmax)
          call mbook(80+n,titlex,dx,xmin,xmax)
          call mbook(100+n,titlex,dx,xmin,xmax)
          call mbook(120+n,titlex,dx,xmin,xmax)
      elseif (tag .eq. 'plot') then
          call mfill(n,var,wt)
        linlog(n)=llplot
        titlearray(n)=titlex
      endif

      return
      end

    
      subroutine plotter(p,wt,switch)
      implicit none
      include 'clustering.f'
      include 'constants.f'
      include 'cutoff.f'
      include 'jetlabel.f'
      include 'npart.f'
      include 'mxdim.f'
      include 'process.f'
      include 'removebr.f'
      include 'masses.f'


      character*2 plabel(mxpart)
      common/plabel/plabel

      integer n,switch,nplotmax,i,j
      character tag*4
  
      double precision wt
      double precision m34,p(mxpart,4),fphi,HT
      double precision pt3,pt4,pt5,pt6,pt7,pt8
      double precision eta3,eta4,eta5,eta6,eta7,eta8
      double precision pt34,y34,pjm,pt3dpt4,tmass,ptmin,ptmax
      double precision pt,etarap,yraptwo,yrapfour,pttwo,R
      double precision cosphi45,deltaphi,pto(1:4),tmp(1:2)
      integer eventpart,nqcdjets,nqcdstart
      
      logical first,jetmerge
      character*30 runstring
      common/runstring/runstring
      common/nplotmax/nplotmax
      common/nqcdjets/nqcdjets,nqcdstart
      common/jetmerge/jetmerge
      double precision realeventp(mxpart,4)
      common/realeventp/realeventp
      integer order,nproc,ndec
      common/nproc/nproc
      common/nnlo/order
      data first/.true./
      save first
       if (first) then
        tag='book'
c--- ensure we initialize all possible histograms
        eventpart=npart+3
        eta3=0d0
        pt3=0d0
        eta4=0d0
        pt4=0d0
        eta5=0d0
        pt5=0d0
        eta6=0d0
        pt6=0d0
        eta7=0d0
        pt7=0d0
        eta8=0d0
        pt8=0d0

        y34=0d0
        pt34=0d0
        m34=0d0
        


        HT=0d0

        deltaphi=0d0
        pto(1)=0d0
        pto(2)=0d0
        pto(3)=0d0
        pto(4)=0d0


        jetmerge=.true.
CC      Here set jets to the maximum number of jets 
CC      to book the necessary histograms: 0 at LO, 1 at NLO and 2 at NNLO
        jets=order
CC
        goto 99
      else
        tag='plot'
      endif

C     ndec is the number of decay products of the vector boson

      ndec=2

C     enventpart is the total number of four momenta in the event
C     2 for initial state + ndec=2 for the V decay + number of jets 

      eventpart=2+ndec+jets
    

      eta3=etarap(3,p)
      pt3=pt(3,p)
      eta4=etarap(4,p)
      pt4=pt(4,p)        
      y34=yraptwo(3,4,p)
      pt34=pttwo(3,4,p)
      m34=dsqrt((p(3,4)+p(4,4))**2-(p(3,1)+p(4,1))**2
     .          -(p(3,2)+p(4,2))**2-(p(3,3)+p(4,3))**2)

      HT=pt3+pt4

C     Transverse mass

      pt3dpt4=p(3,1)*p(4,1)+p(3,2)*p(4,2)

      tmass=dsqrt(2*(pt3*pt4-pt3dpt4))

      ptmin=min(pt3,pt4)
      ptmax=max(pt3,pt4)



 99   continue

      n=1                  
      
      call bookplot(n,tag,'m34',m34,wt,50d0,400d0,20d0,'lin')
      n=n+1
      call bookplot(n,tag,'eta3',eta3,wt,-4d0,4d0,0.2d0,'lin')
      n=n+1
      call bookplot(n,tag,'pt3',pt3,wt,0d0,150d0,5d0,'lin')
      n=n+1      
      call bookplot(n,tag,'eta4',eta4,wt,-4d0,4d0,0.2d0,'lin')
      n=n+1
      call bookplot(n,tag,'pt4',pt4,wt,0d0,150d0,5d0,'lin')
      n=n+1
      call bookplot(n,tag,'y34',y34,wt,-5d0,5d0,0.2d0,'lin')
      n=n+1
      call bookplot(n,tag,'pt34',pt34,wt,0d0,200d0,5d0,'lin')
      n=n+1
      if(nproc.ne.3) then
       call bookplot(n,tag,'mt',tmass,wt,0d0,100d0,2d0,'lin')
       n=n+1
      else
       call bookplot(n,tag,'ptmin',ptmin,wt,0d0,100d0,2d0,'lin')
       n=n+1
       call bookplot(n,tag,'ptmax',ptmax,wt,0d0,100d0,2d0,'lin')
       n=n+1
      endif



       if(jets.eq.2) then
        pt5=pt(5,p)
        pt6=pt(6,p)
        HT=HT+pt5+pt6
        if(pt5.gt.pt6) then
         pjm=pt6
         pt6=pt5
         pt5=pjm
        endif
        call bookplot(n,tag,'pt5',pt5,wt,0d0,500d0,5d0,'lin')
        n=n+1
        call bookplot(n,tag,'pt6',pt6,wt,0d0,500d0,5d0,'lin')
        n=n+1
       elseif(jets.eq.1) then
        pt5=pt(5,p)
        HT=HT+pt5
        call bookplot(n,tag,'pt5',pt5,wt,0d0,500d0,5d0,'lin')
        n=n+1
       endif 


    
      n=n-1

      if (n .gt. 20) then
        write(6,*) 'WARNING - TOO MANY HISTOGRAMS!'
        write(6,*) n,' > 20, which is the built-in maximum'
        stop
      endif

c--- set the maximum number of plots, on the first call
      if (first) then
        first=.false.
        nplotmax=n
      endif
      

      return 
      end
      

      
