//Defines a star in terms of RVS observables stared in star together
//with AAvars and freqs computed for a speciphic Phi 
#ifndef __starx__
#define __starx__
#include <string.h>

class starx{
	public:
		long long unsigned id;
		float s1,RV,Vh,Wh,pioepi,x,y,z,R,Ug,Vg;
		float Jr,Jphi,Jz,thetar,thetaphi,thetaz,Omegar,Omegaphi,Omegaz;
		starx(void){};
		starx(star &s,actions::ActionAngles &AAvars,actions::Frequencies &freq,
		      const units::InternalUnits &unit){
			id=s.id;
			float Junit=pow_2(unit.to_Kpc)/unit.to_Myr;
			s1=s.s1; RV=s.RV; Vh=s.Vh; Wh=s.Wh; pioepi=s.pioepi;
			x=s.x; y=s.y; z=s.z; R=s.R; Ug=s.Ug; Vg=s.Vg;
			Jr=AAvars.Jr*Junit; Jphi=AAvars.Jphi*Junit; Jz=AAvars.Jz*Junit;
			thetar=AAvars.thetar; thetaphi=AAvars.thetaphi; thetaz=AAvars.thetaz;
			Omegar=freq.Omegar/unit.to_Myr;
			Omegaphi=freq.Omegaphi/unit.to_Myr;
			Omegaz=freq.Omegaz/unit.to_Myr;
		}
		starx(FILE *ifile){
			float s[20];
			bool success=true;
			if(1!=fscanf(ifile,"%I64u",&id)) success=false;
			if(success) success=decompress(ifile,s,20);
			s1=s[0]; RV=s[1]; Vh=s[2]; Wh=s[3]; pioepi=s[4]; x=s[5];
			y=s[6]; z=s[7]; R=s[8]; Ug=s[9]; Vg=s[10]; Jr=s[11];
			Jphi=s[12]; Jz=s[13]; thetar=s[14]; thetaphi=s[15]; thetaz=s[16];
			Omegar=s[17]; Omegaphi=s[18]; Omegaz=s[19];
			if(!success) s1=-100;
		}
		void putit(FILE *ofile){
			fprintf(ofile,"%I64u\n",id);
			float s[20];
			s[0]=s1; s[1]=RV; s[2]=Vh; s[3]=Wh; s[4]=pioepi; s[5]=x;
			s[6]=y; s[7]=z; s[8]=R; s[9]=Ug; s[10]=Vg; s[11]=Jr;
			s[12]=Jphi; s[13]=Jz; s[14]=thetar; s[15]=thetaphi; s[16]=thetaz;
			s[17]=Omegar; s[18]=Omegaphi; s[19]=Omegaz;
			compress0(ofile,s,20);
		}
};
#endif