#include <stdio.h>
#include <math.h>
#include "grid.h"

#define MIN(A,B) ((A)<(B)?(A):(B))
#define MAX(A,B) ((A)>(B)?(A):(B))

//Two graphics routines to supply/replace
void colourwh(float**,int,int,float,float,float,int);
//colours ny,ny grid of pixels with values in mp. Colour assigned to
//values in (first float, second float) and white below third float
//Colour bar shown if bool=true
void mgobox(int,int,int,int);
//mgobox(0,0,0,0) adds a box with tickmarks around coloured pixels

float *fmatrix(int n){
	float *m1 = new float[n];
	for(int i=0;i<n;i++) m1[i]=0;
	return m1;
}
float **fmatrix(int n,int m){
	float **m1 = new float*[n];
	for(int i=0; i<n; i++) m1[i] = fmatrix(m);
	return m1;
}
void delmatrix(float **m1,int n){
	for(int i=0;i<n;i++) delete[] m1[i];
	delete [] m1;
}

grid::grid(int nx0,int ny0,double xmin,double xmax,double ymin,double ymax){
	nx=nx0; ny=ny0;
	x0=xmin; y0=ymin;
	Deltax=(xmax-xmin)/(double)(nx); Deltay=(ymax-ymin)/(double)(ny);
	m=fmatrix(nx,ny); av=fmatrix(nx,ny);
	for(int i=0;i<nx;i++)
		for(int j=0;j<ny;j++){
			m[i][j]=0; av[i][j]=0;
		}
}
grid::~grid(){
	delmatrix(m,nx); delmatrix(av,nx);
}
double grid::w(double x,double Dx){
	double f=1-fabs(x)/Dx;
	return MAX(0,f);
}
void grid::CIC(double x,double y){
	//The virtual cell centres should be at (i+.5)Delta
	if(x<x0 || y<y0) return;// off grid
	int i=(int)((x-x0)/Deltax-.5);//index of centre of virtual cell
	int j=(int)((y-y0)/Deltay-.5);//
	if(i<0 || j<0 || i>=nx || j>=ny) return; //off grid
	double dx=x-(x0+(i+.5)*Deltax),dy=y-(y0+(j+.5)*Deltay);//ofsets from cell centre
	double wx=w(dx,Deltax), wy=w(dy,Deltay);
	m[i][j]+=wx*wy;
	if(dy>0 && j<ny-1) m[i][j+1]+=wx*(1-wy);
	if(dx>0){
		if(i<nx-1){
			m[i+1][j]+=(1-wx)*wy;
			if(dy>0 && j<ny-1) m[i+1][j+1]+=(1-wx)*(1-wy);
		}
	} else {
		if(i>0){
			m[i-1][j]+=(1-wx)*wy;
			if(dy>0 && j<ny-1) m[i-1][j+1]+=(1-wx)*(1-wy);
		}
	}
}
void grid::CIC(double value,double x,double y){
	//The virtual cell centres should be at (i+.5)Delta
	if(x<x0 || y<y0) return;// off grid
	int i=(int)((x-x0)/Deltax-.5);//index of centre of virtual cell
	int j=(int)((y-y0)/Deltay-.5);//
	if(i<0 || j<0 || i>=nx || j>=ny) return; //off grid
	double dx=x-(x0+(i+.5)*Deltax),dy=y-(y0+(j+.5)*Deltay);//ofsets from cell centre
	double wx=w(dx,Deltax), wy=w(dy,Deltay);
	m[i][j]+=wx*wy; av[i][j]+=value*wx*wy;
	if(dy>0 && j<ny-1){
		m[i][j+1]+=wx*(1-wy); av[i][j+1]+=value*wx*(1-wy);
	}
	if(dx>0){
		if(i<nx-1){
			m[i+1][j]+=(1-wx)*wy;
			av[i+1][j]+=value*(1-wx)*wy;
			if(dy>0 && j<ny-1){
				m[i+1][j+1]+=(1-wx)*(1-wy);
				av[i+1][j+1]+=value*(1-wx)*(1-wy);
			}
		}
	} else {
		if(i>0){
			m[i-1][j]+=(1-wx)*wy;
			av[i-1][j]+=value*(1-wx)*wy;
			if(dy>0 && j<ny-1){
				m[i-1][j+1]+=(1-wx)*(1-wy);
				av[i-1][j+1]+=value*(1-wx)*(1-wy);
			}
		}
	}
}
double grid::value(double x,double y){//returns mean value at (x,y)
	//The virtual cell centres should be at (i+.5)Delta
	if(x<x0 || y<y0) return 0;// off grid
	int i=(int)((x-x0)/Deltax-.5);//index of centre of virtual cell
	int j=(int)((y-y0)/Deltay-.5);//
	if(i<0 || j<0 || i>=nx || j>=ny) return 0; //off grid
	double dx=x-(x0+(i+.5)*Deltax),dy=y-(y0+(j+.5)*Deltay);//ofsets from cell centre
	double wx=w(dx,Deltax), wy=w(dy,Deltay);
	double value=m[i][j]*wx*wy;
	if(dy>0 && j<ny-1) value+=m[i][j+1]*wx*(1-wy);
	if(dx>0){
		if(i<nx-1){
			value+=m[i+1][j]*(1-wx)*wy;
			if(dy>0 && j<ny-1) value+=m[i+1][j+1]*(1-wx)*(1-wy);
		}
	} else {
		if(i>0){
			value+=m[i-1][j]*(1-wx)*wy;
			if(dy>0 && j<ny-1) value+=m[i-1][j+1]*(1-wx)*(1-wy);
		}
	}
	return value;
}
void grid::plot_dens(void){//plots log10 of density
	float lmin=1e10,lmax=-1e10,**mp;
	mp=fmatrix(nx,ny);
	for(int i=0;i<nx;i++)
		for(int j=0;j<ny;j++){
			mp[i][j]=log10(MAX(1e-30,m[i][j]));
			if(mp[i][j]>-29){
				lmin=MIN(lmin,mp[i][j]); lmax=MAX(lmax,mp[i][j]);
			}
		}
//Next 2 lines colour pixels & draw box; adapt for graphics system
	colourwh(mp,nx,ny,lmin+.1*(lmax-lmin),lmax,lmin+.1*(lmax-lmin),1);
	mgobox(0,0,0,0);
//
	delmatrix(mp,nx);
}
void grid::plot_values(float blank){//plots av values with blank value of empty cells
	float lmin=1e6,lmax=-1e6,**mp;
	mp=fmatrix(nx,ny);
	for(int i=0;i<nx;i++){
		for(int j=0;j<ny;j++){
			if(m[i][j]>0){
				mp[i][j]=av[i][j]/m[i][j];
				if(m[i][j]>3){
					lmin=MIN(lmin,mp[i][j]);
					lmax=MAX(lmax,mp[i][j]);
				}
			}else{
				//if(i==nx/2) printf("%d %g %g\n",j,m[i][j],av[i][j]);
				mp[i][j]=blank;
			}
		}
	}
	printf("lmin/max: %g %g\n",lmin,lmax);
//Next 2 lines colour pixels & draw box; adapt for graphics system
	colourwh(mp,nx,ny,lmin,lmax,lmin,1);
	mgobox(0,0,0,0);
//
	delmatrix(mp,nx);
}
void grid::plot_values(float lmin,float lmax,float blank){//plots av values with blank value of empty cells
	float **mp;
	mp=fmatrix(nx,ny);
	for(int i=0;i<nx;i++){
		for(int j=0;j<ny;j++){
			if(m[i][j]>0){
				mp[i][j]=av[i][j]/m[i][j];
			}else{
				if(i==nx/2) printf("%d %g %g\n",j,m[i][j],av[i][j]);
				mp[i][j]=blank;
			}
		}
	}
//Next 2 lines colour pixels & draw box; adapt for graphics system
	colourwh(mp,nx,ny,lmin,lmax,lmin,1);
	mgobox(0,0,0,0);
//
	delmatrix(mp,nx);
}
void grid::zero(void){
	for(int i=0;i<nx;i++)
		for(int j=0;j<ny;j++){
			m[i][j]=0; av[i][j]=0;
		}
}
void grid::filter(void){//a simple smoothing routine 
	float **mp; mp=fmatrix(nx,ny);
	for(int i=0;i<nx;i++)
		for(int j=0;j<ny;j++) mp[i][j]=m[i][j];
	for(int i=0;i<nx;i++){
		for(int j=0;j<ny;j++){
			if(m[i][j]>1e-30){
				double sum=0,val=m[i][j]; int ns=0,nh=0;//compute mean of neighbours
				bool change=true;
				for(int k=-1;k<2;k++){
					int ik=i+k;
					if(ik>=0 && ik<nx){//keep within grid
						for(int l=-1;l<2;l++){
							if(k!=0 || l!=0){
								int jl=j+l;
								if(jl>=0 && jl<ny){
									if(m[ik][jl]>1e-30){
										if(fabs(m[ik][jl]-val)>fabs(m[ik][jl])){
											nh++;; sum+=m[ik][jl]; ns++;
										}
									}
								}
							}
						}
					}
				}
				if(sum!=0){
					sum/=(double)ns;
					if(nh>4){
						mp[i][j]=sum;//replace with mean
					}
				}
			}
		}
	}
	for(int i=0;i<nx;i++)
		for(int j=0;j<ny;j++) m[i][j]=mp[i][j];
	delmatrix(mp,nx);
}